/*
 *  @author Rajkumar.patidar
 * 
 */
Ext.define('Academia.controller.coursetransaction.sectionmanagement.CourseSectionManagementController', {
	extend: 'Academia.controller.base.BaseController',
	models : ['common.IdValueDataModel','genericmodels.dropdowns.EnumCombo','course.CreateCourseModel','department.DepartmentModel'],
		stores : ['common.StudentEnrolmentCriteriaStore','common.EvaluationPlanByPeriodStore','program.FindProgramsStore',	
			   'program.ManageCourseSectionProgramsPeriodStore',
				'program.ManageCourseSectionParametersStore',
				'attendance.facultyportal.AttendanceCourseVariantStore','Academia.store.program.FindProgramAndPeriodWithBatchStore',
				'common.OptionMandatoryStore',
				'course.CourseGradeStore','Academia.store.program.FindProgramsAndAcademyLocationStore',
				'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',
				'coursetransaction.sectionmanagement.CoruseVariantFacultyMappingGridStore'
				,'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.ClassRoom','common.EvaluationPlanByPeriodStore','common.StudentEnrolmentCriteriaStore','coursetransaction.sectionmanagement.EditCourseSectionGridStore',
				'coursetransaction.sectionmanagement.CourseSectionStudentStore','coursetransaction.sectionmanagement.AcademyLocationsByUserStore','common.EnrollmentCriteriaStore','coursetransaction.sectionmanagement.AssignClassTeacherSmartSearch','program.programbatchdetail.AlternateFacultyStore'],
			views : ['coursetransaction.sectionmanagement.CourseSectionManagementStructure','coursetransaction.courseSectionManagment.ProgramWiseSectionSearch',
				'coursetransaction.courseSectionManagment.OpenSectionSearch','coursetransaction.sectionmanagement.ManageCourseSectionSummaryViewGrid',
				'coursetransaction.sectionmanagement.ManageCourseSectionDetailedViewGrid','coursetransaction.sectionmanagement.SectionTeacherMappingForm',
				'coursetransaction.sectionmanagement.SectionTeacherMappingGrid','coursetransaction.sectionmanagement.SectionTeacherMappingView',
				'coursetransaction.sectionmanagement.SectionTeacherMappingList','coursetransaction.sectionmanagement.SectionAssociatedProgramGrid','coursetransaction.sectionmanagement.EditCourseSectionGroupStructure'
				,'coursetransaction.sectionmanagement.EditCourseSectionListGrid','coursetransaction.courseSectionManagment.CreateCourseSectionForm','feeandpayment.adjustment.AdjustmentProgressTracker',
				'coursetransaction.sectionmanagement.ManageCourseSectionAddMappingTab',
				'coursetransaction.sectionmanagement.ManageCourseSectionAddProgramBatchStructure',
				'coursetransaction.sectionmanagement.ManageCourseSectionAddProgramGrid',
				'coursetransaction.sectionmanagement.ManageCourseSectionAddProgramPeriodGrid',
				'coursetransaction.sectionmanagement.ManageCourseSectionAddCourseParametersGrid',
				'coursetransaction.sectionmanagement.StudentCourseSectionDetails',
				'coursetransaction.sectionmanagement.CourseSectionStudentStructure',
				'coursetransaction.sectionmanagement.ManageCourseSectionStudentGrid','coursetransaction.sectionmanagement.SectionForCourseManageWin',
				'coursetransaction.sectionmanagement.ManageCourseSectionStudentStructure','coursetransaction.sectionmanagement.StudentCourseSectionDetails'],	 
				config:{
					/*
					 * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
					 */
					/**
					 * @cfg {Array} PROGRAM_BATCHSECTION__PERMISSIONS array (required)
					 * The array of permissions to use for Access control wise enabling and disabling buttons.
					 * @accessor
					 */
					MANAGE_COURSE_SECTION_GROUP_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_COURSE_SECTION_GROUP_PRIVILEGES'),
					MANAGE_COURSE_SECTION_SUMMARY_VIEW_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_COURSE_SECTION_SUMMARY_VIEW_PRIVILEGES'),
					MANAGE_COURSE_SECTION_DETAILED_VIEW_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_COURSE_SECTION_DETAILED_VIEW_PRIVILEGES'),
					COURSE_SECTION__PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSE_SECTION_PRIVILEGES')
                 	
				},      

				refs : [{
					ref: 'contentPanel',
					selector: 'contentpanel'
				},{
					ref : 'coursesectionmanagementstructure',
					selector : 'coursesectionmanagementstructure'
				},{
					ref : 'programwisesectionsearch',
					selector : 'programwisesectionsearch'
				},{
					ref : 'opensectionsearch',
					selector : 'opensectionsearch'
				},{
					ref : 'sectionteachermappingform',
					selector : 'sectionteachermappingform'
				},{
					ref : 'managecoursesectionsummaryviewgrid',
					selector : 'managecoursesectionsummaryviewgrid'
				},{
					ref : 'managecoursesectiondetailedviewgrid',
					selector : 'managecoursesectiondetailedviewgrid'
				},{
					ref : 'sectionteachermappingview',
					selector : 'sectionteachermappingview'
				},{
					ref : 'sectionteachermappinggrid',
					selector : 'sectionteachermappinggrid'
				},{
					ref : 'sectionteachermappinglist',
					selector : 'sectionteachermappinglist'
				},{
					ref : 'sectionassociatedprogramgrid',
					selector : 'sectionassociatedprogramgrid'
				},{
					ref : 'editcoursesectiongroupstructure',
					selector : 'editcoursesectiongroupstructure'
				},{
					ref : 'editcoursesectionlistgrid',
					selector : 'editcoursesectionlistgrid'
				},{
					ref : 'createcoursesectionform',
					selector : 'createcoursesectionform'
				},{
					ref : 'managecoursesectionaddmappingtab',
					selector : 'managecoursesectionaddmappingtab'
				},{
					ref : 'managecoursesectionaddprogrambatchstructure',
					selector : 'managecoursesectionaddprogrambatchstructure'
				},{
					ref:'adjustmentprogresstracker',
					selector:'adjustmentprogresstracker'
				},{
					ref : 'managecoursesectionaddprogramgrid',
					selector : 'managecoursesectionaddprogramgrid'
				},{
					ref:'managecoursesectionaddprogramperiodgrid',
					selector:'managecoursesectionaddprogramperiodgrid'
				},{
					ref:'managecoursesectionaddcourseparametersgrid',
					selector:'managecoursesectionaddcourseparametersgrid'
				},{
					ref:'editcoursesectiongridstore',
					selector:'editcoursesectiongridstore'
				},{
					ref:'studentcoursesectiondetails',
					selector:'studentcoursesectiondetails'
				},{
					ref : 'coursesectionstudentstructure',
	                selector : 'coursesectionstudentstructure'
	            },{
					ref : 'managecoursesectionstudentgrid',
		            selector : 'managecoursesectionstudentgrid'
		        },{
                    ref:'sectionforcoursemanagewin',
                    selector:'sectionforcoursemanagewin'
                },{
               	 ref:'sectionforcoursemanagewin',
            	 selector:'sectionforcoursemanagewin form'		 
                },{
             	   ref : 'managecoursesectionstudentstructure',
            	   selector : 'managecoursesectionstudentstructure'
                }],
				init : function() {
					this.control({
						'coursesectionmanagementstructure':{
							beforerender : function(structure){
								permissionsMap = this.getMANAGE_COURSE_SECTION_GROUP_PERMISSIONS();
								this.disableRadioSelectionsPivileges(structure, permissionsMap);
							}
						},
						'coursesectionmanagementstructure tabpanel#coursesectionmanagementpanel':{
							tabchange:function(tabPanel, newCard, oldCard, eOpts){
								   var newTabName=newCard;
								   if(newTabName.title==getCommonTranslation('DETAILED_VIEW')){
									   var structure = this.getCoursesectionmanagementstructure();
									   var radiogroupValue = structure.down('#sectionTypeRadio').getValue();
									   if(radiogroupValue.sectionType=='PROGRAM_WISE_SECTION'){
										   var grid=this.getManagecoursesectiondetailedviewgrid();
											var buttonsToolBar = grid.query('toolbar')[0];
											var deleteBtn= buttonsToolBar.query('#btnDelete')[0];
											deleteBtn.setVisible(false);
									   }
									   var programwisesectionsearch = this.getProgramwisesectionsearch();
									   var opensectionsearch = this.getOpensectionsearch();
								   }
								   

								   var el = newCard.up('coursesectionmanagementstructure');
								   if (el) {
									   var originalscroll = newCard.up('coursesectionmanagementstructure').body.dom.scrollTop;

									   newCard.up('coursesectionmanagementstructure').body.dom.scrollTop = originalscroll + 1;
									   newCard.up('coursesectionmanagementstructure').body.dom.scrollTop = originalscroll;
							}
						    }
						},
						'managecoursesectionsummaryviewgrid':{
							render:function(grid){
								this.manageCourseSectionSummaryView(grid, this.getMANAGE_COURSE_SECTION_SUMMARY_VIEW_PERMISSION());
							},
							cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
								var columnName=grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
								if(e.target.tagName=='A'){
									if(columnName=='programAssociated'){
										this.showMappedProgramPeriodPeriodWithCourse(grid, RowIdx, record);
									}else if(columnName=='noOfSection'){
										this.showDetailedViewOfCourse(grid, RowIdx, record);
									}
								}
							}
						},
						'managecoursesectiondetailedviewgrid':{
							render:function(grid){
								this.manageCourseSectionDetailedView(grid, this.getMANAGE_COURSE_SECTION_DETAILED_VIEW_PERMISSION());
							},
							afterrender: function(grid) {
                				var me = this;
								setTimeout(function(){
	    							me.addDataGridConfigButton(grid,me.getMANAGE_COURSE_SECTION_DETAILED_VIEW_PERMISSION());
								}, 1500);
               				},
							cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
								var columnName=grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
								if(e.target.tagName=='A'){
									if(columnName=='programAssociated' && record.data.prgBtchPrdModelList!=null){
										this.showMappedProgramPeriodPeriodWithCourseVariant(grid, RowIdx, record);
									}else if(columnName=='primaryFaculty' && record.data.prgBtchPrdModelList!=null){
										this.showPrimaryTeacherOfCourseVariant(grid, RowIdx, record);
									}else if(columnName=='enrolledstudents'){
										this.getCurrentlyEnrolledStudentOfCourseSection(record);
									}
								}
							}
						},
						'programwisesectionsearch customcombobox[itemId=academyLocation]':{
							select:function(obj, record){
								this.academyLocationChange();
							}
						},
						'programwisesectionsearch customcombobox[itemId=programWiseAcademicTermId]':{
							select:function(obj, record){
								this.academicTermChange();
							}
						},
						'programwisesectionsearch customcombobox[itemId=programWiseCourseMarkGrade_id]':{
							select:function(obj, record){
								var $this = this;
								var form = $this.getProgramwisesectionsearch();
								var aLId = $this.getCurrentAcademyLocation();
								var academicTermId = form.down('#programWiseAcademicTermId').getValue();
								var academyLocationId = form.down('#academyLocation').getValue();
								var grid = $this.getManagecoursesectionsummaryviewgrid();
								grid.down('#addSection').setDisabled(true);
								grid.down('#mapProgramPeriod').setDisabled(true);
								grid.getStore().removeAll();
								try {
									grid.down('custompagingtoolbar').hide();
								}
								catch(e){
								}
								var detailGrid=this.getManagecoursesectiondetailedviewgrid();
								detailGrid.getStore().removeAll();
								try {
									detailGrid.down('custompagingtoolbar').hide();
								}
								catch(e){
								}
								var programBatchCombo = form.down('#programWiseProgramId');
								var programWisePeriodCombo = form.down('#programWisePeriodId');
								var programWiseCourseCombo = form.down('#programWiseCourseId');
								var courseMarksGradesField = form.down("#programWiseCourseMarkGrade_id");
								var programWiseCheckBox = form.down("#programWiseCheckBoxId");
								var courseMarksGradesFieldId = courseMarksGradesField.getValue();
								var programWiseSectionCombo = form.down('#programWiseSectionId');
								programWiseCheckBox.setValue(false);
								programBatchCombo.reset();
								programWisePeriodCombo.reset();
								programWiseCourseCombo.reset();
								programWiseSectionCombo.reset();
								
								programBatchCombo.setDisabled(true);
								programWisePeriodCombo.setDisabled(true);
								programWiseCourseCombo.setDisabled(true);
								programWiseCheckBox.setDisabled(true);

								if(academyLocationId > 0) {
									/*form.getForm().isValid();
									form.getForm().clearInvalid();*/
									programBatchCombo.setDisabled(false);
									var programBatchStore = programBatchCombo.getStore();
									programBatchStore.getProxy().extraParams = {
										academyLocationIds : academyLocationId,
										academicTermId : academicTermId,
										programType:courseMarksGradesFieldId
									};
									programBatchStore.load({
										callback: function(records, operation, success) {
											if (success) {
												if(records.length == 1){
													var batchId = records[0].get('id');
													var batchIds = [batchId];
													programBatchCombo.setValue(batchIds);
													programWisePeriodCombo.setDisabled(false);
													
												}
											}
										}
									});
								}
							}
						},
						'createcoursesectionform customcombobox[itemId=createAcademicTermId]':{
							select:function(obj, record){
								var $this = this;
								var form = $this.getCreatecoursesectionform();
								var evalutionPlanCombo = form.down('#evalutionPlan');
								evalutionPlanCombo.reset();
								var evalutionComboStore = evalutionPlanCombo.getStore();
								var grid = $this.getManagecoursesectionsummaryviewgrid();
                       		 	var rows = grid.getSelectionModel().getSelection();
                       		 	var courseIds = [];
                       		 	Ext.each(rows,function(course){
                       		 		courseIds.push(course.data.courseId);
                       		 	});
                       		 	evalutionComboStore.getProxy().extraParams = {
	                				 academyLocationId : $this.getCurrentAcademyLocation(),
	                				 academicTermId : record[0].data.id,
	                				 courseId : courseIds.join()
	                			 };
                       		 evalutionComboStore.load({
                    			 callback: function(records) {
                    				 if(records.length == 1) {
                    					 evalutionPlanCombo.select(evalutionComboStore.data.items[0].data.id);
                    				 }
                    			 }
                    		 });
							}
						},
						'programwisesectionsearch multiselectcombofield[itemId=programWiseProgramId]':{
							change:function(obj, record){
								var $this = this;
								var records = obj.value;
								var form = $this.getProgramwisesectionsearch();
								var grid = $this.getManagecoursesectionsummaryviewgrid();
								grid.down('#addSection').setDisabled(true);
								grid.down('#mapProgramPeriod').setDisabled(true);
								grid.getStore().removeAll();
								try {
									grid.down('custompagingtoolbar').hide();
								}
								catch(e){
								}
								var detailGrid=this.getManagecoursesectiondetailedviewgrid();
								detailGrid.getStore().removeAll();
								try {
									detailGrid.down('custompagingtoolbar').hide();
								}
								catch(e){
								}
								
								var aLId = $this.getCurrentAcademyLocation();
								var alinfomodel = Academia.model.authentication.ALInfoModel;
								var wheatherSchool = alinfomodel.get('wheatherSchool');
								var academicTermId = form.down('#programWiseAcademicTermId').getValue();
								var programWisePeriodCombo = form.down('#programWisePeriodId');
								var programWiseCourseCombo = form.down('#programWiseCourseId');
								var programWiseCheckBox = form.down('#programWiseCheckBoxId');
								var courseMarksGrade = form.down('#programWiseCourseMarkGrade_id').getValue();
								var academyLocationId = form.down('#academyLocation').getValue();
								var programWiseSectionCombo = form.down('#programWiseSectionId');
								var courseMarksGradeVal;
								if(courseMarksGrade=="GRADE"){
									courseMarksGradeVal="G";
								}else{
									courseMarksGradeVal="M";
								}
								
								if(wheatherSchool){
									programWisePeriodCombo.setVisible(false);
									$this.setAllowBlank(programWisePeriodCombo, true);
								} else {
									$this.setAllowBlank(programWisePeriodCombo, false);
								}
								programWiseCheckBox.setValue(false);

								programWisePeriodCombo.reset();
								programWiseCourseCombo.reset();
								programWiseSectionCombo.reset();

								programWisePeriodCombo.setDisabled(true);
								programWiseCourseCombo.setDisabled(true);
								programWiseCheckBox.setDisabled(true);
								programWisePeriodCombo.addCls("resetPasswordMultiselect");

								var batchIds = [];
								if(!isNullOrEmpty(records)) {
									Ext.each(records,function(batch){
										if(typeof batch=="number"){
											batchIds.push(batch);
										}else if(!isNullOrEmpty(batch.data)){
											batchIds.push(batch.data.id);
										}
									});
								}
								if(batchIds.length > 0){
									/*form.getForm().isValid();
									form.getForm().clearInvalid();*/
									if(wheatherSchool){
										programWiseCheckBox.setDisabled(false);
										programWiseCourseCombo.setDisabled(false);
										var programWiseCourseStore = programWiseCourseCombo.getStore();
										programWiseCourseStore.getProxy().extraParams = {
											academyLocationIds : academyLocationId,
											academicTermId : academicTermId,
											wheatherSchool : wheatherSchool,
											batchIds : batchIds.join(),
											programType:courseMarksGradeVal
										};
										programWiseCourseStore.load();
									} else {
										programWisePeriodCombo.setDisabled(false);
									}
									var programWisePeriodStore = programWisePeriodCombo.getStore();
									programWisePeriodCombo.removeCls("resetPasswordMultiselect");
									programWisePeriodStore.getProxy().extraParams = {
										academyLocationIds : academyLocationId,
										academicTermId : academicTermId,
										batchIds : batchIds.join()
									};
									programWisePeriodStore.load({
										callback: function(records, operation, success) {
											if (success) {
												if(records.length == 1){
													var periodId = records[0].get('id');
													var periodIds = [periodId];
													programWisePeriodCombo.setValue(periodIds);
													programWisePeriodCombo.setValue(periodIds)
													programWiseCourseCombo.setDisabled(false);
													form.getForm().isValid();
													form.getForm().clearInvalid();
												}else if(records.length > 1){
													programWisePeriodCombo.setDisabled(false);
													programWisePeriodCombo.setVisible(true);
													programWiseCourseCombo.setDisabled(true);
													form.getForm().isValid();
													form.getForm().clearInvalid();
												}
											}
										}
									});
								}
							}
						},
						'sectionteachermappinglist button[itemId=facultyDeleteItemId]':{
		        			click:function(){
		        				var $this = this;
		        				var form = $this.getSectionteachermappinglist();
		        				var grid=$this.getSectionteachermappinggrid();
		        				if (grid.getSelectionModel().getCount() > 0) {	
		        					var records=grid.getSelectionModel().getSelection()[0];
		        					showConfirmMessage(getCommonTranslation('FACULTY'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
		        						if (btn == 'yes') {
		        							Ext.Ajax.request({
		        								type: 'rest',
		        								url: SERVERURL.PATH_DELETE_FACULTIES_BY_COURSE_VAIRANT_ID+'?courseVariantId='+records.data.courseVariantId+'&facultyId='+records.data.facultyId,
		        								method: 'DELETE',
		        								success: function(f, action) {
		        									showSuccessMessage(getCommonTranslation('FACULTY'), getCommonTranslation('FACULTY_SUCCESSFULLY_DELETED'));
		        									form.close();
		        									var detailedgrid = $this.getManagecoursesectiondetailedviewgrid();
		        		    						var detailedStore = detailedgrid.getStore();
		        		    						detailedStore.load();
		        		    						grid.getStore().reload();
		        								}
		        							});
		        						}
		        					});

		        				}else{
		        					showWarningMessage(getCommonTranslation('FACULTY_LIST'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		        				}
		        			}
		        		},
		        		'sectionteachermappinglist button[itemId=saveBtnId]':{
		        			click:function(btn){
		        				var win = btn.up('window');
		        				var grid =win.down('sectionassociatedprogramgrid');
		        				var courseSecGrid = this.getManagecoursesectiondetailedviewgrid();
		        				
		        				var gridRec = grid.getStore().data.items;
		        				var recordArray =[];
		        				for(var i=0 ;i<gridRec.length;i++){
		        					var jsonObj = new Object();
		        					   jsonObj.paramId = gridRec[i].data.programBatchCourseParamId,
		        					    jsonObj.courseMarksGrades=gridRec[i].data.courseMarksGrades;
		        					    if(gridRec[i].data.courseMarksGrades == 'M'){
		        					    	jsonObj.courseGradeType= null
		        					    }else{
		        					    	 jsonObj.courseGradeType=gridRec[i].data.courseGradeType
				        					    
		        					    }
		        					   jsonObj.courseCutOff=gridRec[i].data.courseCutOff,
		        					    jsonObj.courseMaxMark=gridRec[i].data.courseMaxMark;
		        					    if(isNullOrEmpty(gridRec[i].data.courseCredits)){
		        					    	jsonObj.courseCredits = 0
		        					    }else{
		        					    	 jsonObj.courseCredits=gridRec[i].data.courseCredits
		        					    }
		        					   
		        					    recordArray.push(jsonObj)
		        				}
		        				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
								
		        				Ext.Ajax.request({
		                      			 url: SERVERURL.PATH_UPDATE_PARAMETERIZED_COURSE_INFORMATION,
		                      			 type:'rest',
		                      			 jsonData: recordArray,
		                      			 method: 'POST',
		                      			 success: function(response) {
		                      				win.close();
		                      				Ext.getBody().unmask();
		                      				showSuccessMessage(getCourseTxCommonTranslation('COURSE_SECTION'),getCommonTranslation('SUCCESS'))
		                      				courseSecGrid.getStore().load();
		                      			 }
		        				})
		        			}
		        		},

		        		'sectionteachermappinglist button[itemId=cancelBtnId]':{
		        			click:function(btn){
		        				var win = btn.up('window');
		        				win.close();
		        			}
		        		},
						'programwisesectionsearch multiselectcombofield[itemId=programWisePeriodId]':{
							change:function(obj, record){
								var $this = this;
								var records = obj.value;
								var periodIds = [];
								if(!isNullOrEmpty(records)) {
									Ext.each(records,function(period){
										if(typeof period=="number"){
											periodIds.push(period);
										}else if(!isNullOrEmpty(period.data)){
											periodIds.push(period.data.id);
										}
									});
								}
								var form = $this.getProgramwisesectionsearch();
								var grid = $this.getManagecoursesectionsummaryviewgrid();
								grid.down('#addSection').setDisabled(true);
								grid.down('#mapProgramPeriod').setDisabled(true);
								grid.getStore().removeAll();
								try {
									grid.down('custompagingtoolbar').hide();
								}
								catch(e){
								}
								var detailGrid=this.getManagecoursesectiondetailedviewgrid();
								detailGrid.getStore().removeAll();
								try {
									detailGrid.down('custompagingtoolbar').hide();
								}
								catch(e){
								}
								var aLId = $this.getCurrentAcademyLocation();
								var academicTermId = form.down('#programWiseAcademicTermId').getValue();
								var programWiseCheckBox = form.down('#programWiseCheckBoxId');

								var programWiseCourseCombo = form.down('#programWiseCourseId');
								var programWiseSectionCombo = form.down('#programWiseSectionId');
								programWiseCourseCombo.addCls("resetPasswordMultiselect");
								programWiseCourseCombo.reset();
								programWiseSectionCombo.reset();
								programWiseCourseCombo.setDisabled(true);
								programWiseSectionCombo.setDisabled(true);
								var courseMarksGrade = form.down('#programWiseCourseMarkGrade_id').getValue();
								var academyLocationId = form.down('#academyLocation').getValue();
								var courseMarksGradeVal;
								if(courseMarksGrade=="GRADE"){
									courseMarksGradeVal="G";
								}else{
									courseMarksGradeVal="M";
								}

								if(periodIds.length > 0){
									form.getForm().isValid();
									form.getForm().clearInvalid();
									programWiseCourseCombo.setDisabled(false);	
									programWiseCourseCombo.removeCls("resetPasswordMultiselect");
									programWiseCourseCombo.setDisabled(false);
									var programWiseCourseStore = programWiseCourseCombo.getStore();
									programWiseCourseStore.getProxy().extraParams = {
										academyLocationIds : academyLocationId,
										academicTermId : academicTermId,
										periodIds : periodIds.join(),
										programType:courseMarksGradeVal
									};
									//programWiseCourseStore.load();
									programWiseCourseStore.load({
										callback: function(records, operation, success) {
											if (success) {
												if(records.length == 1){
													var courseId = records[0].get('id');
													var courseIds = [courseId];
													programWiseCourseCombo.setValue(courseIds);
												}
											}
										}
									});
								}
							}
						},
						// Course filter function
						'programwisesectionsearch multiselectcombofield[itemId=programWiseCourseId]':{
							change:function(obj, record){
								var $this = this;
								var records = obj.value;
								var courseIds = [];
								if(!isNullOrEmpty(records)) {
									Ext.each(records,function(course){
										if(typeof course=="number"){
											courseIds.push(course);
										}else if(!isNullOrEmpty(course.data)){
											courseIds.push(course.data.id);
										}
									});
								}
								var form = $this.getProgramwisesectionsearch();
								var grid = $this.getManagecoursesectionsummaryviewgrid();
								grid.down('#addSection').setDisabled(true);
								grid.down('#mapProgramPeriod').setDisabled(true);
								grid.getStore().removeAll();
								try {
									grid.down('custompagingtoolbar').hide();
								}
								catch(e){
								}
								var detailGrid=this.getManagecoursesectiondetailedviewgrid();
								detailGrid.getStore().removeAll();
								try {
									detailGrid.down('custompagingtoolbar').hide();
								}
								catch(e){
								}
								var aLId = $this.getCurrentAcademyLocation();
								var academicTermId = form.down('#programWiseAcademicTermId').getValue();
								var batchRecords = form.down('#programWiseProgramId').getValue();
								var periodRecords = form.down('#programWisePeriodId').getValue();
								var programWiseSectionCombo = form.down('#programWiseSectionId');
								var programWiseCheckBox = form.down('#programWiseCheckBoxId');
								programWiseSectionCombo.addCls("resetPasswordMultiselect");
								programWiseSectionCombo.reset();
								var batchIds=[];
			                 	   if(batchRecords.length>0){
			                 		   for (var i in batchRecords) {
			                 			   if(Ext.isObject(batchRecords[i])){
			                 				  batchIds.push(batchRecords[i].get('id'));
			                 			   }
			                 			   else{
			                 				  batchIds.push(batchRecords[i]);	
			                 			   }
			                 		   }
			                 	   }
			             		var periodIds=[];
			                 	   if(periodRecords.length>0){
			                 		   for (var i in periodRecords) {
			                 			   if(Ext.isObject(periodRecords[i])){
			                 				  periodIds.push(periodRecords[i].get('id'));
			                 			   }
			                 			   else{
			                 				  periodIds.push(periodRecords[i]);	
			                 			   }
			                 		   }
			                 	   }
								var courseMarksGrade = form.down('#programWiseCourseMarkGrade_id').getValue();
								var academyLocationId = form.down('#academyLocation').getValue();
								var courseMarksGradeVal;
								if(courseMarksGrade=="GRADE"){
									courseMarksGradeVal="G";
								}else{
									courseMarksGradeVal="M";
								}
								if(!isNullOrEmpty(courseIds[0]) && !isNullOrEmpty(courseIds) && courseIds.length > 0){
									form.getForm().isValid();
									form.getForm().clearInvalid();
									programWiseCheckBox.setDisabled(false);
									programWiseSectionCombo.setDisabled(false);
									programWiseSectionCombo.removeCls("resetPasswordMultiselect");
									var programWiseSectionStore = programWiseSectionCombo.getStore();
									programWiseSectionStore.getProxy().extraParams = {
								//		academyLocationIds : academyLocationId,
								//		academicTermId : academicTermId,
										batchIds : batchIds.join(),
										periodIds : periodIds.join(),
										courseIds : courseIds.join(),
										programType:courseMarksGradeVal
									};
									//programWiseSectionStore.load();
									programWiseSectionStore.load({
										callback: function(records, operation, success) {
											if (success) {
												if(records.length == 1){
													var sectionId = records[0].get('id');
													var sectionIds = [sectionId];
													programWiseSectionCombo.setValue(sectionIds);
												}
											}
										}
									});
								} else {
									programWiseSectionCombo.reset();
									programWiseSectionCombo.setDisabled(true);
								}
							}
						},
						'programwisesectionsearch button[itemId=searchBtn]':{
							click:function(){
								this.getProgramWiseSectionSearchData();
								this.getProgramWiseSectionDetailViewSearchData();
							}
						},
						'programwisesectionsearch button[itemId=resetBtn]':{
							click:function(){
								this.renderReset();
							}
						},
						'coursesectionmanagementstructure radiogroup[itemId=sectionTypeRadio]' : {
							change : function(val,nV,oV){
								var $this = this;
								var academyLocationIds=this.getCurrentAcademyLocation();
								var summaryGrid = this.getManagecoursesectionsummaryviewgrid();
								summaryGrid.getStore().removeAll();
								try {
									summaryGrid.down('custompagingtoolbar').hide();
								}
								catch(e){
								}
								var grid=this.getManagecoursesectiondetailedviewgrid();
								grid.getStore().removeAll();
								try {
									grid.down('custompagingtoolbar').hide();
								}
								catch(e){
								}
								var buttonsToolBar = grid.query('toolbar')[0];
								var deleteBtn= buttonsToolBar.query('#btnDelete')[0];
								var addTeacherBtn= buttonsToolBar.query('#addFaculty')[0];
								addTeacherBtn.setDisabled(true);
								var btnEdit= buttonsToolBar.query('#btnEdit')[0];
								btnEdit.setDisabled(true);
								var buttonsToolBarSummary = summaryGrid.query('toolbar')[0];
								var addSectionBtn= buttonsToolBarSummary.query('#addSection')[0];
								addSectionBtn.setDisabled(true);
								var alinfomodel = Academia.model.authentication.ALInfoModel;
								var wheatherSchool = alinfomodel.get('wheatherSchool');
								if(nV.sectionType == 'PROGRAM_WISE_SECTION') {
									//this.renderReset();
									var form = this.getProgramwisesectionsearch();
									form.setVisible(true);
									form.down("#programWiseCheckBoxId").setDisabled(true);
									this.getOpensectionsearch().setVisible(false);
									deleteBtn.setVisible(false);
//									this.setAllowBlank(this.getOpensectionsearch().down("#courseDepartment"), true);
									if(this.getProgramwisesectionsearch().down("#programWiseAcademicTermId").allowBlank) {
										this.setAllowBlank(this.getProgramwisesectionsearch().down("#programWiseAcademicTermId"), false);
									}
									if(this.getProgramwisesectionsearch().down("#programWiseProgramId").allowBlank) {
										this.setAllowBlank(this.getProgramwisesectionsearch().down("#programWiseProgramId"), false);
									}
									if(!wheatherSchool && this.getProgramwisesectionsearch().down("#programWisePeriodId").allowBlank) {
										this.setAllowBlank(this.getProgramwisesectionsearch().down("#programWisePeriodId"), false);
									}/* else {
										this.setAllowBlank(this.getProgramwisesectionsearch().down("#programWisePeriodId"), true);
									}*/
									this.getOpensectionsearch().getForm().reset();
									form.getForm().isValid();
									form.getForm().clearInvalid();
									var academyLocation = form.down("#academyLocation");
									var courseMarksGradesField = form.down('#programWiseCourseMarkGrade_id');
									var academyLocationId = academyLocation.getValue();
									var academyLocationStore = academyLocation.getStore();
									var currentALId = ''; 
									academyLocationStore.getProxy().extraParams={};
				   				 	academyLocationStore.load({
										callback: function(records, operation, success) {
											if (success) {
												for(var i in records){
													if(records[i].data.id==academyLocationIds){
														academyLocation.setValue(records[i].data.id);
														$this.academyLocationChange();
														currentALId = records[i].data.id;
													}
												}
												if(isNullOrEmpty(courseMarksGradesField.getValue())) {
													var courseMarksGrades_Store = courseMarksGradesField.getStore();
													courseMarksGrades_Store.getProxy().extraParams = {
														academyLocationIds : currentALId
													};
													courseMarksGrades_Store.load({
														callback: function(rec, success) {
															if (success) {
																for(var i in rec){
																	if(rec[i].get('id')=='GRADE'){
																		courseMarksGradesField.setValue(rec[i].get('id'));
																	}
																}
															}
														}
													});
							   				 }
											}
										}
									});
				   				 
								} else {
									var form=this.getOpensectionsearch();
//									this.setAllowBlank(form.down("#courseDepartment"), true);
									form.getForm().isValid();
									form.getForm().clearInvalid();
									var courseMarksGradesField = form.down("#courseMarksGrades_id");
									form.getForm().reset();
									form.down("#courseSubDepartment").setDisabled(true);
									form.down("#courseCategory").setDisabled(true);
//									form.down("#courseSectionId").setDisabled(true);
									form.down("#programWiseCheckBoxId").setDisabled(true);
									this.getProgramwisesectionsearch().getForm().reset();
									this.getProgramwisesectionsearch().setVisible(false);
									this.getOpensectionsearch().setVisible(true);
									this.getOpensectionsearch().getForm().reset();
									deleteBtn.setVisible(true);
									var academyLocation = form.down("#academyLocation");
									var academyLocationId = academyLocation.getValue();
									var academyLocationStore = academyLocation.getStore();
									academyLocationStore.getProxy().extraParams={};
				   				 	academyLocationStore.load({
										callback: function(records, operation, success) {
											if (success) {
												for(var i in records){
													if(records[i].data.id==academyLocationIds){
														academyLocation.setValue(records[i].data.id);
													}
												}
											}
										}
									});
								}
							}
						},
						'opensectionsearch button[itemId=searchBtn]' : {
							click : function() {
								this.getOpenSectionSearchData();
								this.getProgramWiseSectionDetailViewSearchData();
							}
						},
						'opensectionsearch button[itemId=resetBtn]' : { 
							click : function() {
								var form=this.getOpensectionsearch();
								var academyLocationIds=this.getCurrentAcademyLocation();
								var courseSectionId = form.down('#courseSectionId');
								var courseMarksGradesField = form.down('#courseMarksGrades_id');
								var courseMarksGradesFieldVal = form.down('#courseMarksGrades_id').getValue();
								var academicTermField = form.down('#academicTerm');
								var courseMarksGrades_Store=courseMarksGradesField.getStore();
								var departmentCombo = form.down("#courseDepartment");
								departmentCombo.reset();
								academicTermField.reset();
								var departmentStore = departmentCombo.getStore();
								programWiseCheckBox = form.down('#programWiseCheckBoxId');
								
								programWiseCheckBox.setValue(false);
								/*departmentStore.getProxy().extraParams = {
									academyLocationIds : academyLocationIds
								};
								departmentStore.load();
								var courseCategory = form.down('#courseCategory');
								courseMarksGrades_Store.getProxy().extraParams = {
									academyLocationIds : 1
								};
								courseMarksGrades_Store.load({
									callback: function(rec, success) {
										if (success) {
											for(var i in rec){
												if(rec[i].get('id')=='GRADE'){
													courseMarksGradesField.setValue(rec[i].get('id'));
												}
											}
										}
									}
								});
								
								courseMarksGrades_Store.load();*/ 
								
								
								var grid = this.getManagecoursesectionsummaryviewgrid();
								grid.down('#addSection').setDisabled(true);
								grid.down('#mapProgramPeriod').setDisabled(true);
								grid.getStore().removeAll();
								try {
									grid.down('custompagingtoolbar').hide();
								}
								catch(e){
								}
								var detailGrid=this.getManagecoursesectiondetailedviewgrid();
								detailGrid.getStore().removeAll();
								try {
									detailGrid.down('custompagingtoolbar').hide();
								}
								catch(e){
								}
								form.down("#courseCategory").clearValue();
								form.down("#courseDepartment").clearValue();
								form.down("#courseSubDepartment").clearValue();
								form.down("#courseSectionId").clearValue();
								form.down("#openWiseSectionId").clearValue();
								form.down("#programWiseCheckBoxId").setValue(false);
								form.down("#courseSubDepartment").setDisabled(true);
								form.down("#courseCategory").setDisabled(true);
//								form.down("#courseSectionId").setDisabled(true);
								form.down("#programWiseCheckBoxId").setDisabled(true);
								form.down("#openWiseSectionId").setDisabled(true);
								var academyLocation = form.down("#academyLocation");
								academyLocation.reset();
								var academyLocationId = academyLocation.getValue();
								var academyLocationStore = academyLocation.getStore();
								academyLocationStore.getProxy().extraParams={};
			   				 	academyLocationStore.load({
									callback: function(records, operation, success) {
										if (success) {
											for(var i in records){
												if(records[i].data.id==academyLocationIds){
													academyLocation.setValue(records[i].data.id);
												}
											}
										}
									}
								});
			   				 form.down('#courseSectionId').getStore().getProxy().extraParams = {
									academyLocationIds : this.getCurrentAcademyLocation(),
									courseMarksGrade : courseMarksGradesFieldVal,
									assignSectionType: 'CourseSection'
								};	
			   				form.down('#courseSectionId').getStore().load();
							}
						},
						'opensectionsearch customcombobox[itemId=academyLocation]':{
							change:function(obj, record){
								var form=this.getOpensectionsearch();
								var subDept = obj.up('form').down('#courseSubDepartment');
								var courseSectionId = obj.up('form').down('#courseSectionId');
								var courseCategory = obj.up('form').down('#courseCategory');
								var academyLocationId=obj.up('form').down('#academyLocation').getValue();
								var courseMarksGradesField =  obj.up('form').down('#courseMarksGrades_id');
								var academicTermCombo = obj.up('form').down('#academicTerm');
								var openWiseSectionCombo = obj.up('form').down('#openWiseSectionId');
								if(!isNullOrEmpty(subDept)){
									subDept.clearValue();
								}
								//var departmentId = record[0].get("id");
								courseSectionId.clearValue();
								courseCategory.clearValue();
								openWiseSectionCombo.clearValue();
								academicTermCombo.clearValue();
								form.down("#courseSubDepartment").setDisabled(true);
//								form.down("#courseSectionId").setDisabled(true);
								form.down("#courseCategory").setDisabled(true);
								form.down("#programWiseCheckBoxId").setDisabled(true);
								form.down("#openWiseSectionId").setDisabled(true);
								if(academyLocationId > 0){
									var academicTermStore = academicTermCombo.getStore();
									academicTermStore.getProxy().extraParams = {
										academyLocationIds : academyLocationId
									};
									var academicTermId = 0;
									var departmentCombo = form.down("#courseDepartment");
									var departmentId = 0;
									var subDeptId = 0;
									var courseCategoryId = 0;
									academicTermStore.load({
										callback: function(records, operation, success) {
											if (success) {
												if(records.length == 1){
													academicTermId = records[0].get('id');
													academicTermCombo.setValue(academicTermId);
												}
												var departmentStore = departmentCombo.getStore();
												departmentStore.getProxy().extraParams = {
													academyLocationIds : academyLocationId
												};
												/*departmentStore.load({
													callback: function(records, operation, success) {
														if (success) {
															if(records.length == 1){
																departmentId = records[0].get('id');
																departmentCombo.setValue(departmentId);
																form.down("#courseSubDepartment").setDisabled(false);
																form.down("#courseSectionId").setDisabled(false);
																form.down("#courseCategory").setDisabled(false);
																form.down("#programWiseCheckBoxId").setDisabled(false);
																var subDeptstore=subDept.getStore();
																subDeptstore.getProxy().extraParams = {
																	parentId : departmentId
																};
																subDeptstore.load({
																	callback: function(records, operation, success) {
																		if (success) {
																			if(records.length == 1){
																				subDeptId = records[0].get('id');
																				subDept.setValue(subDeptId);
																			}
																		}
																	}
																});
																var courseCategoryStore=courseCategory.getStore();
																courseCategoryStore.getProxy().extraParams = {
																	academyLocationIds : academyLocationId,
																	departmentId : departmentId
																};
																courseCategoryStore.load({
																	callback: function(records, operation, success) {
																		if (success) {
																			if(records.length == 1){
																				courseCategoryId = records[0].get('id');
																				courseCategory.setValue(courseCategoryId);
																			}
																		}
																		var courseSectionStore=courseSectionId.getStore();
																		courseSectionStore.getProxy().extraParams = {
																			academyLocationIds : academyLocationId,
																			departmentId : departmentId,
																			courseMarksGrade : courseMarksGradesField.getValue(),
																			subDeptId    : subDeptId>0?subDeptId:'',
																			courseCategory : courseCategoryId>0?courseCategoryId:'',
																			assignSectionType : 'CourseSection',
																			academicTermId : academicTermCombo.getValue()
																		};
																		courseSectionStore.load({
																			callback: function(records, operation, success) {
																				if (success) {
																					if(records.length == 1){
																						var courseIds = [];
																						courseSectionId.setValue(records[0].get('id'));
																						courseIds.push(records[0].get('id'));
																						openWiseSectionCombo.setDisabled(false);
																						var openWiseSectionStore = openWiseSectionCombo.getStore();
																						openWiseSectionStore.getProxy().extraParams = {
																							academyLocationIds : academyLocationId,
																							assignSectionType : 'CourseSection',
																							departmentId : departmentId,
																							subDeptId : subDeptId>0?subDeptId:'',
																							courseMarksGrade : courseMarksGradesField.getValue(),
																							courseCategory : courseCategoryId>0?courseCategoryId:'',
																							courseIds : courseIds.join(),
																							academicTermId : academicTermCombo.getValue()
																						};
																						//openWiseSectionStore.load();
																						openWiseSectionStore.load({
																							callback: function(records, operation, success) {
																								if (success) {
																									if(records.length == 1){
																										var sectionId = records[0].get('id');
																										var sectionIds = [sectionId];
																										openWiseSectionCombo.setValue(sectionIds);
																									}
																								}
																							}
																						});
																					}
																				}
																			}
																		});
																	}
																});
															}
														}
													}
												});*/
												
												
											}
										}
									});
									var courseMarksGrades_Store = courseMarksGradesField.getStore();
									courseMarksGrades_Store.getProxy().extraParams = {
										academyLocationIds : academyLocationId
									};
									courseMarksGrades_Store.load({
										callback: function(rec, success) {
											if (success) {
												for(var i in rec){
													if(rec[i].get('id')=='GRADE'){
														var courseMarksGradesFieldId = rec[i].get('id');
														courseMarksGradesField.setValue(courseMarksGradesFieldId);
														if(departmentId > 0){
															var courseSectionStore=courseSectionId.getStore();
															courseSectionStore.getProxy().extraParams = {
																academyLocationIds : academyLocationId,
																departmentId : departmentId,
																courseMarksGrade : courseMarksGradesFieldId,
																subDeptId    : subDeptId>0?subDeptId:'',
																courseCategory : courseCategoryId>0?courseCategoryId:'',
																assignSectionType : 'CourseSection',
																academicTermId : academicTermCombo.getValue()
															};
															courseSectionStore.load({
																callback: function(records, operation, success) {
																	if (success) {
																		if(records.length == 1){
																			var courseIds = [];
																			courseSectionId.setValue(records[0].get('id'));
																			courseIds.push(records[0].get('id'));
																			openWiseSectionCombo.setDisabled(false);
																			var openWiseSectionStore = openWiseSectionCombo.getStore();
																			openWiseSectionStore.getProxy().extraParams = {
																				academyLocationIds : academyLocationId,
																				assignSectionType : 'CourseSection',
																				departmentId : departmentId,
																				subDeptId : subDeptId>0?subDeptId:'',
																				courseMarksGrade : courseMarksGradesField,
																				courseCategory : courseCategoryId>0?courseCategoryId:'',
																				courseIds : courseIds.join(),
																				academicTermId : academicTermCombo.getValue()
																			};
																			//openWiseSectionStore.load();
																			openWiseSectionStore.load({
																				callback: function(records, operation, success) {
																					if (success) {
																						if(records.length == 1){
																							var sectionId = records[0].get('id');
																							var sectionIds = [sectionId];
																							openWiseSectionCombo.setValue(sectionIds);
																						}
																					}
																				}
																			});
																		}
																	}
																}
															});
														}
													}
												}
											}
										}
									});
								}
							}
						},
						'opensectionsearch customcombobox[itemId=academicTerm]':{
							select:function(obj, record){
								var form=this.getOpensectionsearch();
								var subDept = obj.up('form').down('#courseSubDepartment');
								var courseDepartmentCombo = obj.up('form').down('#courseDepartment');
								var courseSectionId = obj.up('form').down('#courseSectionId');
								var openWiseSectionCombo = obj.up('form').down('#openWiseSectionId');
								var courseCategory = obj.up('form').down('#courseCategory');
								var academicTermId=obj.up('form').down('#academicTerm').getValue();
								var academyLocationId=obj.up('form').down('#academyLocation').getValue();
								var courseMarksGradesField =  obj.up('form').down('#courseMarksGrades_id');
								if(!isNullOrEmpty(subDept)){
									subDept.clearValue();
								}
								courseDepartmentCombo.reset();
								courseSectionId.clearValue();
								courseSectionId.reset();
								courseCategory.clearValue();
								openWiseSectionCombo.clearValue();
					//			form.down("#courseSubDepartment").setDisabled(true);
//								form.down("#courseSectionId").setDisabled(true);
								form.down("#courseCategory").setDisabled(true);
								form.down("#programWiseCheckBoxId").setDisabled(true);
								form.down("#openWiseSectionId").setDisabled(true);
								if(academicTermId > 0){
									var departmentCombo = form.down("#courseDepartment");
									var departmentId = 0;
									var subDeptId = 0;
									var courseCategoryId = 0;
									var departmentStore = departmentCombo.getStore();
									departmentStore.getProxy().extraParams = {
										academyLocationIds : academyLocationId,
										academicTermId : academicTermId,
									};
									departmentStore.load({
										callback: function(records, operation, success) {
											if (success) {
												if(records.length == 1){
													departmentId = records[0].get('id');
													departmentCombo.setValue(departmentId);
													form.down("#courseSubDepartment").setDisabled(false);
													form.down("#courseSectionId").setDisabled(false);
													form.down("#courseCategory").setDisabled(false);
													form.down("#programWiseCheckBoxId").setDisabled(false);
													var subDeptstore=subDept.getStore();
													subDeptstore.getProxy().extraParams = {
														parentId : departmentId
													};
													subDeptstore.load({
														callback: function(records, operation, success) {
															if (success) {
																if(records.length == 1){
																	subDeptId = records[0].get('id');
																	subDept.setValue(subDeptId);
																}
															}
														}
													});
													var courseCategoryStore=courseCategory.getStore();
													courseCategoryStore.getProxy().extraParams = {
														academyLocationIds : academyLocationId,
														departmentId : departmentId
													};
													courseCategoryStore.load({
														callback: function(records, operation, success) {
															if (success) {
																if(records.length == 1){
																	courseCategoryId = records[0].get('id');
																	courseCategory.setValue(courseCategoryId);
																}
															}
															var courseSectionStore=courseSectionId.getStore();
															courseSectionStore.getProxy().extraParams = {
																academyLocationIds : academyLocationId,
																departmentId : departmentId,
																courseMarksGrade : courseMarksGradesField.getValue(),
																subDeptId    : subDeptId>0?subDeptId:'',
																courseCategory : courseCategoryId>0?courseCategoryId:'',
																assignSectionType : 'CourseSection',
																academicTermId : academicTermId
															};
															courseSectionStore.load({
																callback: function(records, operation, success) {
																	if (success) {
																		if(records.length == 1){
																			var courseIds = [];
																			courseSectionId.setValue(records[0].get('id'));
																			courseIds.push(records[0].get('id'));
																			openWiseSectionCombo.setDisabled(false);
																			var openWiseSectionStore = openWiseSectionCombo.getStore();
																			openWiseSectionStore.getProxy().extraParams = {
																				academyLocationIds : academyLocationId,
																				assignSectionType : 'CourseSection',
																				departmentId : departmentId,
																				subDeptId : subDeptId>0?subDeptId:'',
																				courseMarksGrade : courseMarksGradesField.getValue(),
																				courseCategory : courseCategoryId>0?courseCategoryId:'',
																				courseIds : courseIds.join(),
																				academicTermId : academicTermId
																			};
																			//openWiseSectionStore.load();
																			openWiseSectionStore.load({
																				callback: function(records, operation, success) {
																					if (success) {
																						if(records.length == 1){
																							var sectionId = records[0].get('id');
																							var sectionIds = [sectionId];
																							openWiseSectionCombo.setValue(sectionIds);
																						}
																					}
																				}
																			});
																		}
																	}
																}
															});
														}
													});
												}
											}
										}
									});
									var courseMarksGrades_Store = courseMarksGradesField.getStore();
									courseMarksGrades_Store.getProxy().extraParams = {
										academyLocationIds : academyLocationId
									};
									courseMarksGrades_Store.load({
										callback: function(rec, success) {
											if (success) {
												for(var i in rec){
													if(rec[i].get('id')=='GRADE'){
														var courseMarksGradesFieldId = rec[i].get('id');
														courseMarksGradesField.setValue(courseMarksGradesFieldId);
														if(departmentId > 0){
															var courseSectionStore=courseSectionId.getStore();
															courseSectionStore.getProxy().extraParams = {
																academyLocationIds : academyLocationId,
																departmentId : departmentId,
																courseMarksGrade : courseMarksGradesFieldId,
																subDeptId    : subDeptId>0?subDeptId:'',
																courseCategory : courseCategoryId>0?courseCategoryId:'',
																assignSectionType : 'CourseSection',
																academicTermId : academicTermId
															};
															courseSectionStore.load({
																callback: function(records, operation, success) {
																	if (success) {
																		if(records.length == 1){
																			var courseIds = [];
																			courseSectionId.setValue(records[0].get('id'));
																			courseIds.push(records[0].get('id'));
																			openWiseSectionCombo.setDisabled(false);
																			var openWiseSectionStore = openWiseSectionCombo.getStore();
																			openWiseSectionStore.getProxy().extraParams = {
																				academyLocationIds : academyLocationId,
																				assignSectionType : 'CourseSection',
																				departmentId : departmentId,
																				subDeptId    : subDeptId>0?subDeptId:'',
																				courseCategory : courseCategoryId>0?courseCategoryId:'',
																				courseMarksGrade : courseMarksGradesField,
																				courseIds : courseIds.join(),
																				academicTermId : academicTermId
																			};
																			//openWiseSectionStore.load();
																			openWiseSectionStore.load({
																				callback: function(records, operation, success) {
																					if (success) {
																						if(records.length == 1){
																							var sectionId = records[0].get('id');
																							var sectionIds = [sectionId];
																							openWiseSectionCombo.setValue(sectionIds);
																						}
																					}
																				}
																			});
																		}
																	}
																}
															});
														}
													}
												}
											}
										}
									});
								}
							}
						},
						'opensectionsearch customcombobox[itemId=courseDepartment]':{
							select:function(obj, record){
								var form=this.getOpensectionsearch();
								var subDept = obj.up('form').down('#courseSubDepartment');
								var courseSectionId = obj.up('form').down('#courseSectionId');
								var openWiseSectionCombo = obj.up('form').down('#openWiseSectionId');
								var academicTermId = obj.up('form').down('#academicTerm').getValue();
								var courseCategory = obj.up('form').down('#courseCategory');
								var academyLocationId=obj.up('form').down('#academyLocation').getValue();
								var courseMarksGradesField =  obj.up('form').down('#courseMarksGrades_id');
								
								if(!isNullOrEmpty(subDept)){
									subDept.clearValue();
								}
								var departmentId = record[0].get("id");
								var subDeptId = 0;
								var courseCategoryId = 0;
								courseSectionId.clearValue();
								courseCategory.clearValue();
								openWiseSectionCombo.clearValue();
								openWiseSectionCombo.setDisabled(true);
									var subDeptstore=subDept.getStore();
									subDeptstore.getProxy().extraParams = {
										parentId : departmentId
									};
									subDeptstore.load({
										callback: function(records, operation, success) {
											if (success) {
												if(records.length == 1){
													subDeptId = records[0].get('id');
													subDept.setValue(subDeptId);
												}
											}
											var courseCategoryStore=courseCategory.getStore();
											courseCategoryStore.getProxy().extraParams = {
												academyLocationIds : academyLocationId,
												departmentId : departmentId
											};
											courseCategoryStore.load({
												callback: function(records, operation, success) {
													if (success) {
														if(records.length == 1){
															courseCategoryId = records[0].get('id');
															courseCategory.setValue(courseCategoryId);
														}
													}
													var courseSectionStore=courseSectionId.getStore();
													courseSectionStore.getProxy().extraParams = {
														academyLocationIds : academyLocationId,
														departmentId : departmentId,
														courseMarksGrade : courseMarksGradesField.getValue(),
														subDeptId    : subDeptId>0?subDeptId:'',
														courseCategory : courseCategoryId>0?courseCategoryId:'',
														assignSectionType : 'CourseSection',
														academicTermId : academicTermId
													};
													courseSectionStore.load({
														callback: function(records, operation, success) {
															if (success) {
																if(records.length == 1){
																	var courseIds = [];
																	courseSectionId.setValue(records[0].get('id'));
																	courseIds.push(records[0].get('id'));
																	openWiseSectionCombo.setDisabled(false);
																	var openWiseSectionStore = openWiseSectionCombo.getStore();
																	openWiseSectionStore.getProxy().extraParams = {
																		academyLocationIds : academyLocationId,
																		assignSectionType : 'CourseSection',
																		departmentId : departmentId,
																		subDeptId    : subDeptId>0?subDeptId:'',
																		courseCategory : courseCategoryId>0?courseCategoryId:'',
																		courseMarksGrade : courseMarksGradesField.getValue(),
																		courseIds : courseIds.join(),
																		academicTermId : academicTermId
																	};
																	//openWiseSectionStore.load();
																	openWiseSectionStore.load({
																		callback: function(records, operation, success) {
																			if (success) {
																				if(records.length == 1){
																					var sectionId = records[0].get('id');
																					var sectionIds = [sectionId];
																					openWiseSectionCombo.setValue(sectionIds);
																				}
																			}
																		}
																	});
																}
															}
														}
													});
												}
											});
										}
									});
								form.down("#courseSubDepartment").setDisabled(false);
								form.down("#courseSectionId").setDisabled(false);
								form.down("#courseCategory").setDisabled(false);
								form.down("#programWiseCheckBoxId").setDisabled(false);
							}
						},
						'sectionteachermappingform combo[itemId=alternateNameItemId]':{
							afterrender: function(combo){
								var grid=this.getManagecoursesectiondetailedviewgrid();
								var record = grid.getSelectionModel().getSelection()[0];
								var store = combo.getStore();
								if(!isNullOrEmpty(record) && !isNullOrEmpty(record.data) && record.data.isFacultyCourseInterestApprovalImplement && !isNullOrEmpty(record.data.prgBtchPrdModelList[0]) && !isNullOrEmpty(record.data.prgBtchPrdModelList[0].programBatchCourseParamId)){
									store.on('beforeload', function(){
										 store.getProxy().extraParams.paramId = record.data.prgBtchPrdModelList[0].programBatchCourseParamId;
									});
								}else{
									store.on('beforeload', function(){
										 store.getProxy().extraParams.paramId = null;
									});
								}
							}
						},
						'sectionteachermappingform combo[itemId=facultyNameItemId]':{
							afterrender: function(combo){
								var grid=this.getManagecoursesectiondetailedviewgrid();
								var record = grid.getSelectionModel().getSelection()[0];
								var store = combo.getStore();
								if(!isNullOrEmpty(record) && !isNullOrEmpty(record.data) && record.data.isFacultyCourseInterestApprovalImplement && !isNullOrEmpty(record.data.prgBtchPrdModelList[0]) && !isNullOrEmpty(record.data.prgBtchPrdModelList[0].programBatchCourseParamId)){
									store.on('beforeload', function(){
										 store.getProxy().extraParams.paramId = record.data.prgBtchPrdModelList[0].programBatchCourseParamId;
									});
								}else{
									store.on('beforeload', function(){
										 store.getProxy().extraParams.paramId = null;
									});
								}
							},
                			select:function(obj,rec){
                			   var formWindow = this.getSectionteachermappingform();
            					if (!formWindow){
            						Ext.widget('sectionteachermappingform');
            						formWindow = this.getSectionteachermappingform();
            					}
            					var facultyIds = [];
            					if(!isNullOrEmpty(rec)) {
            						Ext.each(rec,function(faculty){
            							if(typeof faculty=="number"){
            								facultyIds.push(faculty);
            							}else if(!isNullOrEmpty(faculty.data)){
            								facultyIds.push(faculty.data.id);
            							}
            						});
            					}
                               	var grid=this.getManagecoursesectiondetailedviewgrid();
								var record = grid.getSelectionModel().getSelection()[0];
								var paramId=null;
								if(!isNullOrEmpty(record) && !isNullOrEmpty(record.data) && record.data.isFacultyCourseInterestApprovalImplement && !isNullOrEmpty(record.data.prgBtchPrdModelList[0]) && !isNullOrEmpty(record.data.prgBtchPrdModelList[0].programBatchCourseParamId)){
									paramId=record.data.prgBtchPrdModelList[0].programBatchCourseParamId;
									}
                				obj.nextSibling().getStore().getProxy().extraParams ={
                					FacultyIds : facultyIds.join(),
									paramId:paramId
                				},
                				obj.nextSibling().getStore().load();
                			}
                		},
						'coursesectionmanagementstructure [itemId=managecoursesectiondetailedviewgridId]':{
							selectionchange: function(column, selected,eOpts ){
								var grid=this.getManagecoursesectiondetailedviewgrid();
								var buttonsToolBar = grid.query('toolbar')[0];
								var addTeacherBtn= buttonsToolBar.query('#addFaculty')[0];
								var deleteBtn= buttonsToolBar.query('#btnDelete')[0];
								var btnEdit= buttonsToolBar.query('#btnEdit')[0];
								var addmapProgramPeriodBtn= buttonsToolBar.query('#mapProgramPeriod')[0];
								if(selected.length > 0){
									addTeacherBtn.setDisabled(false);
									addmapProgramPeriodBtn.setDisabled(false);
									deleteBtn.setDisabled(false);
									btnEdit.setDisabled(false);
								}else{
									addTeacherBtn.setDisabled(true);
									deleteBtn.setDisabled(true);
									btnEdit.setDisabled(true);
									addmapProgramPeriodBtn.setDisabled(true);
								}
								
								if(!isNullOrEmpty(selected) && !isNullOrEmpty(selected[0]) && !isNullOrEmpty(selected[0].data) && selected[0].data.isFacultyCourseInterestApprovalImplement && selected.length>1){
									addTeacherBtn.setDisabled(true);
								}
							}
						},
						'managecoursesectiondetailedviewgrid button[itemId=mapProgramPeriod]':{
							click: function(structure) {
								var grid = this.getManagecoursesectiondetailedviewgrid();
								if (grid.getSelectionModel().getCount() > 0) {
									this.openProgramBatchMappingTab(grid);
								}else{
									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
								}
							}
						},
						'managecoursesectionsummaryviewgrid button[itemId=mapProgramPeriod]':{
							click: function(structure) {
								var grid = this.getManagecoursesectionsummaryviewgrid();
								if (grid.getSelectionModel().getCount() > 0) {
									this.openProgramBatchMappingTab(grid);
								}else{
									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
								}
							}
						},		            
						'opensectionsearch customcombobox[itemId=courseSubDepartment]':{
							select:function(obj, record){
								var form=this.getOpensectionsearch();
								var subDept = record[0].get("id");
								var departmentId = form.down('#courseDepartment').getValue();				 
								var courseSectionId = form.down('#courseSectionId');
								var openWiseSectionCombo = form.down('#openWiseSectionId');
								var academicTermId = form.down('#academicTerm').getValue();
								var courseMarksGradesField =  form.down('#courseMarksGrades_id').getValue();
								var academyLocationId=form.down('#academyLocation').getValue();
								if (subDept > 0) {
									courseSectionId.clearValue();
									openWiseSectionCombo.clearValue();
									openWiseSectionCombo.setDisabled(true);
									var courseSectionStore=courseSectionId.getStore();
									courseSectionStore.getProxy().extraParams = {
										academyLocationIds : academyLocationId,
										departmentId : departmentId,
										subDeptId    : subDept,
										courseMarksGrade : courseMarksGradesField,
										assignSectionType : 'CourseSection',
										academicTermId : academicTermId
									};
									courseSectionStore.load({
										callback: function(records, operation, success) {
											if (success) {
												if(records.length == 1){
													var courseIds = [];
													courseSectionId.setValue(records[0].get('id'));
													courseIds.push(records[0].get('id'));
													openWiseSectionCombo.setDisabled(false);
													var openWiseSectionStore = openWiseSectionCombo.getStore();
													openWiseSectionStore.getProxy().extraParams = {
														academyLocationIds : academyLocationId,
														assignSectionType : 'CourseSection',
														departmentId : departmentId,
														subDeptId : subDept,
														courseMarksGrade : courseMarksGradesField,
														courseCategory : null,
														courseIds : courseIds.join(),
														academicTermId : academicTermId
													};
													//openWiseSectionStore.load();
													openWiseSectionStore.load({
														callback: function(records, operation, success) {
															if (success) {
																if(records.length == 1){
																	var sectionId = records[0].get('id');
																	var sectionIds = [sectionId];
																	openWiseSectionCombo.setValue(sectionIds);
																}
															}
														}
													});
												}
											}
										}
									});
								}
							}
						},

						'opensectionsearch customcombobox[itemId=courseMarksGrades_id]':{
							select:function(obj, record){
								var form=this.getOpensectionsearch();
								var subDept = obj.up('form').down('#courseSubDepartment').value;
								var departmentId = obj.up('form').down('#courseDepartment').value;				 
								var courseSectionId = obj.up('form').down('#courseSectionId');
								var openWiseSectionCombo = obj.up('form').down('#openWiseSectionId');
								var courseCategory = obj.up('form').down('#courseCategory').value;
								var courseMarksGradesField =  obj.up('form').down('#courseMarksGrades_id').value;
								var academicTermId =  obj.up('form').down('#academicTerm').value;
								var academyLocationId=form.down('#academyLocation').getValue();
								courseSectionId.clearValue();
								openWiseSectionCombo.clearValue();
								openWiseSectionCombo.setDisabled(true);
								var courseSectionStore=courseSectionId.getStore();
								courseSectionStore.getProxy().extraParams = {
									academyLocationIds : academyLocationId,
									departmentId : departmentId,
									subDeptId    : subDept,
									courseCategory : courseCategory,
									courseMarksGrade : courseMarksGradesField,
									assignSectionType : 'CourseSection',
									academicTermId : academicTermId
								};
								courseSectionStore.load({
									callback: function(records, operation, success) {
										if (success) {
											if(records.length == 1){
												var courseIds = [];
												courseSectionId.setValue(records[0].get('id'));
												courseIds.push(records[0].get('id'));
												openWiseSectionCombo.setDisabled(false);
												var openWiseSectionStore = openWiseSectionCombo.getStore();
												openWiseSectionStore.getProxy().extraParams = {
													academyLocationIds : academyLocationId,
													assignSectionType : 'CourseSection',
													departmentId : departmentId,
													subDeptId : subDept,
													courseMarksGrade : courseMarksGradesField,
													courseCategory : courseCategory,
													courseIds : courseIds.join(),
													academicTermId : academicTermId
												};
												//openWiseSectionStore.load();
												openWiseSectionStore.load({
													callback: function(records, operation, success) {
														if (success) {
															if(records.length == 1){
																var sectionId = records[0].get('id');
																var sectionIds = [sectionId];
																openWiseSectionCombo.setValue(sectionIds);
															}
														}
													}
												});
											}
										}
									}
								});

							}
						},
						'opensectionsearch customcombobox[itemId=courseCategory]':{
							change:function(obj, record){
								var form=this.getOpensectionsearch();
								var subDept = obj.up('form').down('#courseSubDepartment');
								var departmentId = obj.up('form').down('#courseDepartment');				 
								var courseSectionId = obj.up('form').down('#courseSectionId');
								var courseCategory = obj.up('form').down('#courseCategory').value;
								var openWiseSectionCombo = obj.up('form').down('#openWiseSectionId');
								var academicTermId =  obj.up('form').down('#academicTerm').value;
								var courseMarksGradesField =  obj.up('form').down('#courseMarksGrades_id');
								var academyLocationId=form.down('#academyLocation').getValue();
								courseSectionId.clearValue();
								openWiseSectionCombo.clearValue();
								openWiseSectionCombo.setDisabled(true);
								var courseSectionStore=courseSectionId.getStore();
								courseSectionStore.getProxy().extraParams = {
									academyLocationIds : academyLocationId,
									departmentId : departmentId.getValue(),
									subDeptId    : subDept.getValue(),
									courseCategory : courseCategory,
									courseMarksGrade : courseMarksGradesField.getValue(),
									academicTermId : academicTermId
								};
								courseSectionStore.load({
									callback: function(records, operation, success) {
										if (success) {
											if(records.length == 1){
												courseSectionId.setValue(records[0].get('id'));
												var courseIds = [];
												courseSectionId.setValue(records[0].get('id'));
												courseIds.push(records[0].get('id'));
												openWiseSectionCombo.setDisabled(false);
												var openWiseSectionStore = openWiseSectionCombo.getStore();
												openWiseSectionStore.getProxy().extraParams = {
													academyLocationIds : academyLocationId,
													assignSectionType : 'CourseSection',
													departmentId : departmentId.getValue(),
													subDeptId : subDept.getValue(),
													courseMarksGrade : courseMarksGradesField.getValue(),
													courseCategory : courseCategory,
													courseIds : courseIds.join(),
													academicTermId : academicTermId
												};
												//openWiseSectionStore.load();
												openWiseSectionStore.load({
													callback: function(records, operation, success) {
														if (success) {
															if(records.length == 1){
																var sectionId = records[0].get('id');
																var sectionIds = [sectionId];
																openWiseSectionCombo.setValue(sectionIds);
															}
														}
													}
												});
											}
										}
									}
								});

							}
						},
						'opensectionsearch multiselectcombofield[itemId=courseSectionId]':{
							change:function(obj, record){
								var form=this.getOpensectionsearch();
								var subDept = form.down('#courseSubDepartment').value;
								var departmentId = form.down('#courseDepartment').value;				 
								var courseSectionId = form.down('#courseSectionId');
								var academicTermId = form.down('#academicTerm').value;
								var openWiseSectionCombo = form.down('#openWiseSectionId');
								var courseCategory = form.down('#courseCategory').value;
								var courseMarksGradesField =  form.down('#courseMarksGrades_id').value;
								var academyLocationId=form.down('#academyLocation').getValue();
								openWiseSectionCombo.reset();
								openWiseSectionCombo.setDisabled(false);
								var records = obj.value;
								var courseIds = [];
								if(!isNullOrEmpty(records)) {
									Ext.each(records,function(course){
										if(typeof course=="number"){
											courseIds.push(course);
										}else if(!isNullOrEmpty(course.data)){
											courseIds.push(course.data.id);
										}
									});
								}
								if(!isNullOrEmpty(courseIds[0]) && !isNullOrEmpty(courseIds) && courseIds.length > 0){
									var openWiseSectionStore = openWiseSectionCombo.getStore();
									openWiseSectionStore.getProxy().extraParams = {
										academyLocationIds : academyLocationId,
										assignSectionType : 'CourseSection',
										departmentId : departmentId,
										subDeptId : subDept,
										courseMarksGrade : courseMarksGradesField,
										courseCategory : courseCategory,
										courseIds : courseIds.join(),
										academicTermId : academicTermId
									};
									//openWiseSectionStore.load();
									openWiseSectionStore.load({
										callback: function(records, operation, success) {
											if (success) {
												if(records.length == 1){
													var sectionId = records[0].get('id');
													var sectionIds = [sectionId];
													openWiseSectionCombo.setValue(sectionIds);
												}
											}
										}
									});
								} else {
									openWiseSectionCombo.reset();
									openWiseSectionCombo.setDisabled(true);
								}
							}
						},
						'coursesectionmanagementstructure [itemId=managecoursesectionsummaryviewgridId]':{
							selectionchange: function(column, selected,eOpts ){
								var grid=this.getManagecoursesectionsummaryviewgrid();
								var buttonsToolBar = grid.query('toolbar')[0];
								var addSectionBtn= buttonsToolBar.query('#addSection')[0];
								var mapProgramPeriodBtn= buttonsToolBar.query('#mapProgramPeriod')[0];
								if(selected.length > 0){
									addSectionBtn.setDisabled(false);
									mapProgramPeriodBtn.setDisabled(false);
								}else{
									addSectionBtn.setDisabled(true);
									mapProgramPeriodBtn.setDisabled(true);
								}
							}
						},
						'managecoursesectiondetailedviewgrid button[itemId=addFaculty]':{
							click: function() {
								this.showSectionTeacherMappingWindow();
							}
						},
						'managecoursesectiondetailedviewgrid button[itemId=btnDelete]':{
							click: function() {
								this.deleteSections();
							}
						},
						'sectionteachermappingform button[itemId=sectionTeacherMappingFormSubmit]':{
							click: function() {
								this.saveSectionTeacherMapping();
							}
						},
						'sectionteachermappingform button[itemId=sectionTeacherMappingFormCancel]':{
							click: function() {
								this.closeSectionTeacherMappingWindow();
							}
						},
						'managecoursesectiondetailedviewgrid button[itemId=btnEdit]':{
							click:this.openEditCourseSectionGroupForm
						},
						'editcoursesectionlistgrid button[itemId=resetGridBtnNew]':{
							click:function(button){
								this.resetEditCourseSectionGridItems(button);
							}
						},
						
						'managecoursesectionsummaryviewgrid button[itemId=addSection]':{
							click:function(button){
								this.createNewCourseSection(button);
							}
						},
						'editcoursesectionlistgrid button[itemId=saveBtnNew]':{
							click:function(button){
								this.updateEditCourseSectionGridItems(button);
							}
						},

						/*Start code for Manage Course Section Mapping Tab */
						'managecoursesectionaddprogramgrid button#nextButton':{
							click:function(btn){
								this.nextEventOnProgramTab(btn);
							}
						},
						'managecoursesectionaddprogramgrid button#resetBtn':{
							click:function(btn){
								var activeGrid = this.getManagecoursesectionaddprogramgrid();
								activeGrid.getSelectionModel().deselectAll();
								activeGrid.getStore().clearFilter();
								if(activeGrid.down('#programsearchcombo')){
									activeGrid.down('#programsearchcombo').reset();
								}
								document.getElementsByClassName('gridTotalDivCls '+activeGrid.id)[0].innerHTML = "";
								document.getElementsByClassName('gridTotalDivCls '+activeGrid.id)[0].innerHTML ="<span class='totalSpanCls'>"+getCommonTranslation('TOTAL_RECORDS')+": "+activeGrid.getStore().data.length+ "</span>";
							}
						},
						'managecoursesectionaddprogramgrid customcombobox#programsearchcombo' : {
							select:function(obj, record){
								var grid = this.getManagecoursesectionaddprogramgrid();
								grid.getStore().clearFilter();
								grid.getStore().filter({property: 'id',
									value: record[0].get('id'),
									exactMatch: true,
									caseSensitive: true});
								document.getElementsByClassName('gridTotalDivCls '+grid.id)[0].innerHTML = "";
								document.getElementsByClassName('gridTotalDivCls '+grid.id)[0].innerHTML ="<span class='totalSpanCls'>"+getCommonTranslation('TOTAL_RECORDS')+": "+grid.getStore().data.length+ "</span>";
							}
						},

						/*'managecoursesectionaddprogramperiodgrid button#nextButton':{
							click:function(btn){
								this.nextEventOnProgramPeriodTab(btn);
							}
						},*/
						'managecoursesectionaddprogramperiodgrid button#resetBtn':{
							click:function(btn){
								var activeGrid = this.getManagecoursesectionaddprogramperiodgrid();
								activeGrid.down('#whetherOptionalItemId').items.items[0].setValue(true);
								activeGrid.getSelectionModel().deselectAll();
								activeGrid.getStore().clearFilter();
								if(activeGrid.down('#programbatchsearchcombo')){
									activeGrid.down('#programbatchsearchcombo').reset();
								}
							}
						},
						'managecoursesectionaddprogramperiodgrid customcombobox#programbatchsearchcombo' : {
							select:function(obj, record){
								var grid = this.getManagecoursesectionaddprogramperiodgrid();
								grid.getStore().clearFilter();
								grid.getStore().filter({property: 'batchId',
									value: record[0].get('batchId'),
									exactMatch: true,
									caseSensitive: true});
							}
						},
						'managecoursesectionaddcourseparametersgrid button#resetBtn':{
							click:function(btn){
								var activeGrid = this.getManagecoursesectionaddcourseparametersgrid();
								activeGrid.getSelectionModel().deselectAll();
								activeGrid.getStore().clearFilter();
							}
						},
						'managecoursesectionaddprogramperiodgrid button#submitMapping':{
							click:function(btn){
								this.submitMappingMangeCourseSection(btn);
							}
						},
						/*End code for Manage Course Section Mapping Tab */
						'createcoursesectionform button[itemId=preDefinedDetailedBtn]':{
							click:function(){
								this.addMorePreDefinedDetailed();
							}
						},
						'createcoursesectionform button[itemId=preDefinedDetailedBtn1]':{
							click:function(){
								this.addMorePreDefinedDetailed();
							}
						},
						'createcoursesectionform customcombobox#preDefinedAssignHomeRoomId': {
               			 select: function(obj, record) {
               				 this.getCapacityForCourseWin(obj,record);
               			 }
               		 },
               		'createcoursesectionform customcombobox[name=assignHomeRoom]': {
                        select: function(obj, record) {
                          //  this.getCapacityForAddCourseWin(obj,record);
                        }
                    },
               		'createcoursesectionform customcombobox#usrDefinedAssignHomeRoomId': {
              			 select: function(obj, record) {
							 this.getCapacityForAddCourseWin(obj,record);
              			 }
              		 },
						'createcoursesectionform button[itemId=preDefinedDetailedDeleteBtn1]':{
							click : function(deleteButton) {
								this.preDefinedDeleteMoreDetailed(deleteButton);
							}
						},
						'createcoursesectionform button[itemId=usrDefinedDetailedBtn]':{
							click:function(){
								this.addMoreUsrDefinedDetailed();
							}
						},
						'createcoursesectionform button[itemId=usrDefinedDetailedBtn1]':{
							click:function(){
								this.addMoreUsrDefinedDetailed();
							}
						},
						'createcoursesectionform button[itemId=usrDefinedDetailedDeleteBtn1]':{
							click : function(deleteButton) {
								this.usrDefinedDeleteMoreDetailed(deleteButton);
							}
						},
						'createcoursesectionform radiogroup[itemId=definedSectionId]':{
							change : function(val,nV,oV){
								this.createCourseSectionRadioOption(val,nV,oV);
							}
						},
						'createcoursesectionform button[itemId=programFormSubmitButtonId]':{
							click:function(){
								this.saveMultipleCourseSection();
							}
						},
						'createcoursesectionform':{
							afterrender : function(form){
								var $this = this;
								form.body.on('click', function() {
                	   		   		$this.hideInvalidIconFromField($this.getCreatecoursesectionform());
                	   		   	});
								var searchForm = $this.getProgramwisesectionsearch();
								var sectionType = $this.getCoursesectionmanagementstructure().down('#sectionTypeRadio').getValue().sectionType;
								var academicTerm = searchForm.down('#programWiseAcademicTermId');
								var createAcademicTermId=form.down('#createAcademicTermId');
								createAcademicTermId.getStore().load();
								var values = searchForm.getForm().getValues();
								var periodIds = [];
								var alinfomodel = Academia.model.authentication.ALInfoModel;
			                	 var whetherSchool = alinfomodel.get('wheatherSchool');
			                	// if(whetherSchool){
			                		 var evalutionCombo=form.down('#evalutionPlan');
			                		 $this.loadDFRForSingleCourseProgram(evalutionCombo);
	                            	 if(sectionType == 'PROGRAM_WISE_SECTION') {
	                            		 var evalutionComboStore = evalutionCombo.getStore();
	                            		 var grid = $this.getManagecoursesectionsummaryviewgrid();
	                            		 var rows = grid.getSelectionModel().getSelection();
	                            		 var courseIds = [];
	                            		 Ext.each(rows,function(course){
	                            			 courseIds.push(course.data.courseId);
	                            		 });
	                            		 evalutionComboStore.getProxy().extraParams = {
	                            			 academyLocationId : $this.getCurrentAcademyLocation(),
			                				 academicTermId : academicTerm.getValue(),
			                				 courseId : courseIds.join()
			                			 };
	                            		 evalutionComboStore.load({
	                            			 callback: function(records) {
	                            				 if(records.length == 1) {
	                            					 evalutionCombo.select(evalutionComboStore.data.getAt(0));
	                            				 }
	                            			 }
	                            		 });
	                            	 }
			                	// }
			                	 if(sectionType == 'PROGRAM_WISE_SECTION') {
			                		 if(whetherSchool) {
			                			 var batchIds = [];
			                			 Ext.each(values.programWiseProgram,function(batch){
			                				 if(typeof batch=="number"){
			                					 batchIds.push(batch);
			                				 }else if(!isNullOrEmpty(batch.data)){
			                					 batchIds.push(batch.data.id);
			                				 }
			                			 });
			                			 var programWisePeriodCombo = searchForm.down('#programWisePeriodId');
			                			 var programWisePeriodStore = programWisePeriodCombo.getStore();
			                			 programWisePeriodStore.getProxy().extraParams = {
			                				 academyLocationIds : $this.getCurrentAcademyLocation(),
			                				 academicTermId : academicTerm.getValue(),
			                				 batchIds : batchIds.join()
			                			 };
			                			 programWisePeriodStore.load({
			                				 callback: function(records, operation, success) {
			                					 if (success) {
			                						 Ext.each(records,function(period){
			                							 if(typeof period=="number"){
			                								 periodIds.push(period);
			                							 }else if(!isNullOrEmpty(period.data)){
			                								 periodIds.push(period.data.id);
			                							 }
			                						 });
			                						 form.down('#periodIds').setValue(periodIds.join());
			                					 }
			                				 }
			                			 });
			                		 } else {
			                			 Ext.each(values.programWisePeriod,function(period){
			                				 if(typeof period=="number"){
			                					 periodIds.push(period);
			                				 }else if(!isNullOrEmpty(period.data)){
			                					 periodIds.push(period.data.id);
			                				 }
			                			 });
			                			 form.down('#periodIds').setValue(periodIds.join())
			                		 }
			                		 form.down('#createAcademicTermId').readOnly = true;
			                		 var academicTermStore = form.down('#createAcademicTermId').getStore();
			                		 academicTermStore.load({
		                				 callback: function(records, operation, success) {
		                					 if (success) {
		                						form.down('#createAcademicTermId').setValue(academicTerm.getValue());
		 										form.down('#createAcademicTermValue').setValue(academicTerm.getRawValue());
		                					 }
		                				 }
			                		 });
			                	 }
								var calendarCombo = form.down('#calendar');
								form.down('#locationCodeItemId').setVisible(false);
								var calendarComboStore = calendarCombo.getStore();
								calendarComboStore.getProxy().extraParams = {
									academyLocationId : $this.getCurrentAcademyLocation()
								};
								calendarComboStore.load();
								var alinfomodel = Academia.model.authentication.ALInfoModel;
			                	 var whetherSchool = alinfomodel.get('wheatherSchool');
			                	 if(whetherSchool) { 
			                		 Ext.Ajax.request({
		                             		url: SERVERURL.FIND_LOCATION_DETAILS,
		                             		method: 'GET',
		                             		async: false,
		                             		params: {
		                             			id:$this.getCurrentAcademyLocation(),
		                             		},
		                             		success: function(res, action) {
		                         				var data = Ext.decode(res.responseText);
		                         				form.down('#locationCodeItemId').setValue(data.code);
		                         				form.down('#locationCodeItemId').setVisible(true);
		                         			}
		                         		});
			                	 }
			                	 var grid = $this.getManagecoursesectionsummaryviewgrid();
			                	 if(grid.getSelectionModel().getCount() > 0) {
			                		 var gridRecord = grid.getSelectionModel().getSelection();
			                		 var sectionCourseId = [];
			                		 if(!isNullOrEmpty(gridRecord)) {
			                			 Ext.Array.each(gridRecord, function(currentRecord) {
			                				 sectionCourseId.push(currentRecord.data.courseId);
			                			 });
			                			 form.down('#sectionCourseId').setValue(sectionCourseId);
			                		 }
			                	 }
							}
						},
						'createcoursesectionform customcombobox[itemId=preDefinedSectionId]':{
							select : function(form){
								var $this = this;
								var form = $this.getCreatecoursesectionform();
								var sectionName = form.down('#preDefinedSectionId').getRawValue();
								var sectionId = form.down('#preDefinedSectionId').getValue();
								var rec = form.down('#preDefinedSectionId').getStore().findRecord('id',sectionId);
								form.down('#preDefinedSectionPrintNameId').setValue(rec.get('value'));
								form.down('#preDefinedSectionCodeId').setValue(sectionName);
							}
						},
						'createcoursesectionform button[itemId=createCourseSectionResetBtn]':{
							click:function(){
								var form = this.getCreatecoursesectionform();
								var this$ = this;
								var form = this.getCreatecoursesectionform();
								form.down('#calendar').reset();
								var preDefinedPanel = form.down('#preDefinedPanelId');
								form.down('#definedSectionId').getValue().definedSection;
								if(!form.down('#definedSectionId').getValue().definedSection) {
									preDefinedPanel = form.down('#usrDefinedPanelId');
								}
								for(var i =preDefinedPanel.items.length;i>=1;i--) {
									var container = preDefinedPanel.items.items[i-1];
									if(preDefinedPanel.items.length > 1) {
										preDefinedPanel.remove(container);
										this.hideShowDetails(preDefinedPanel);
									} else{
										if(form.down('#definedSectionId').getValue().definedSection) {
											container.down('#preDefinedSectionId').reset();
											container.down('#preDefinedSectionCodeId').reset();
											container.down('#preDefinedSectionPrintNameId').reset();
											container.down('#preDefinedAssignHomeRoomId').reset();
											container.down('#preDefinedMaxCapacity_id').reset();
											container.down('#facultyNameItemId').reset();
											container.down('#alternateNameItemId').reset();
										} else {
											container.down('#usrDefinedSectionNameId').reset();
											container.down('#usrDefinedSectionPrintNameId').reset();
											container.down('#usrDefinedAssignHomeRoomId').reset();
											container.down('#usrDefinedMaxCapacity_id').reset();
											container.down('#facultyNameItemId').reset();
											container.down('#alternateNameItemId').reset();
										}
										}
								}
							}
						},
						
						'managecoursesectionstudentgrid button[itemId=assignSectionforCourseLink]':{
							click:this.showSectionforCS
						},
						'sectionforcoursemanagewin button[itemId=submitBtn]':{
							click:this.saveSectionforCS
						},
						'sectionforcoursemanagewin button[itemId=cancelBtn]':{
							click:this.closeSectionforCS
						},
						'sectionforcoursemanagewin':{
							beforerender:function(win){
								this.setReadOnlyFieldsForCBS(win);
							}
						},
						'managecoursesectionstudentstructure [itemId=managecoursesectionstudentgrid]':{
						selectionchange: function(column, selected,eOpts ){
							var gridReference=this.getManagecoursesectionstudentgrid();
							var assignSectionbtn = gridReference.down('#assignSectionforCourseLink');
							if(selected.length > 0){
								assignSectionbtn.setDisabled(false);
							}else{
								assignSectionbtn.setDisabled(true);
							}
						}
						},
						'managecoursesectionstudentgrid':{
							render:function(grid){
								this.disableMoreActionPivileges(grid,this.getCOURSE_SECTION__PERMISSIONS());
							}
						},
						'programwisesectionsearch':{
							render: function(window){
			    				var $this = this;
			    				
			    				window.body.on('click', function() {
			    	    			$this.hideInvalidIconFromField($this.getProgramwisesectionsearch());
			    	    	       });
			    			}
				
						},
						'opensectionsearch':{
							render: function(window){
			    				var $this = this;
			    				window.body.on('click', function() {
			    	    			$this.hideInvalidIconFromField($this.getOpensectionsearch());
			    	    	       });
			    				
			    			},
			    			afterrender : function(form){
			    				var saveBtn = form.down('#searchBtn');
			    				
			    				 

			    				function checkSearchEnable(){
			    					var allow = true;

			    					form.getForm().getFields().each(function(field){

			    						if(field.isVisible && field.isVisible()){

			    							// mandatory check based on asterisk / required class
			    							var html = field.labelEl ? field.labelEl.dom.innerHTML : '';
			    							var isMandatory = (html.indexOf('required') !== -1 || html.indexOf('*') !== -1);

			    							if(isMandatory){
			    								var v = field.getValue();
			    								if(v === null || v === "" || v === undefined){
			    									allow = false;
			    									return false;
			    								}
			    							}
			    						}
			    					});

			    					saveBtn.setDisabled(!allow);
			    				}

			    				checkSearchEnable(); // initial

			    				form.getForm().getFields().each(function(f){
			    					f.on('change', checkSearchEnable);
			    				});

			    				form.getForm().on('validitychange', checkSearchEnable);
			    			}
						},
						'sectionteachermappingform':{
							render: function(window){
			    				var $this = this;
			    				window.body.on('click', function() {
			    					var filter = window.down('form');
			    	    			$this.hideInvalidIconFromField(filter);
			    	    	       });
			    			}
						},
					});
					this.callParent(arguments);
				},
				showSectionTeacherMappingWindow: function() {
					var formWindow = this.getSectionteachermappingform();
					if (!formWindow){
						Ext.widget('sectionteachermappingform');
						formWindow = this.getSectionteachermappingform();
					}
					formWindow.show();
				},
				closeSectionTeacherMappingWindow: function() {
					this.getSectionteachermappingform().close();
				},
				showSectionTeacherListWindow: function() {
					var formWindow = this.getSectionteachermappinglist();
					if (!formWindow){
						Ext.widget('sectionteachermappinglist');
						formWindow = this.getSectionteachermappinglist();
					}
					formWindow.setTitle(getProgramandcourseTranslation('TEACHERS_ASSIGNED'));
					formWindow.show();
				},
				renderReset : function(){
					var $this = this;
					var form = $this.getProgramwisesectionsearch();
					var aLId = $this.getCurrentAcademyLocation();
					var academicTermCombo = form.down('#programWiseAcademicTermId');
					var courseMarksGradesField = form.down('#programWiseCourseMarkGrade_id');
					var programBatchCombo = form.down('#programWiseProgramId');
					var programWisePeriodCombo = form.down('#programWisePeriodId');
					var programWiseCourseCombo = form.down('#programWiseCourseId');
					var programWiseSectionCombo = form.down('#programWiseSectionId');
					var programWiseCheckBox = form.down('#programWiseCheckBoxId');
					if(wheatherSchool){
						programWisePeriodCombo.setVisible(false);
						$this.setAllowBlank(programWisePeriodCombo, true);
					} else {
						$this.setAllowBlank(programWisePeriodCombo, false);
					}
					programWiseCheckBox.setValue(false);

					programWisePeriodCombo.reset();
					programWiseCourseCombo.reset();
					programWiseSectionCombo.reset();
					programBatchCombo.reset();

					programWisePeriodCombo.setDisabled(true);
					programWiseCourseCombo.setDisabled(true);
					programWiseSectionCombo.setDisabled(true);
					programWiseCheckBox.setDisabled(true);
					programBatchCombo.setDisabled(true);
					academicTermCombo.reset();
					courseMarksGradesField.reset();
					if(isNullOrEmpty(courseMarksGradesField.getValue())) {
						var courseMarksGrades_Store = courseMarksGradesField.getStore();
						courseMarksGrades_Store.getProxy().extraParams = {
							academyLocationIds: aLId
						};
						courseMarksGrades_Store.load({
							callback: function(rec, success) {
								if (success) {
									for (var i in rec) {
										if (rec[i].get('id') == 'GRADE') {
											courseMarksGradesField.setValue(rec[i].get('id'));
										}
									}
								}
							}
						});
					}
					programBatchCombo.reset();
					var academyLocation = form.down("#academyLocation");
					var academyLocationId = academyLocation.getValue();
					var academyLocationStore = academyLocation.getStore();
					academyLocationStore.getProxy().extraParams={};
   				 	academyLocationStore.load({
						callback: function(records, operation, success) {
							if (success) {
								for(var i in records){
									if(records[i].data.id==aLId){
										academyLocation.setValue(records[i].data.id);
										academyLocationId = records[i].data.id
										var academicTermStore = academicTermCombo.getStore();
										academicTermStore.getProxy().extraParams = {
											academyLocationIds : academyLocationId
										};
										
										
						
										var courseMarksGradesFieldId = courseMarksGradesField.getValue();
										academicTermStore.load({
											callback: function(records, operation, success) {
												for(var i in records) {
													if(records[i].get('sequence') == 1) {
														var academicTermId = records[i].get('id');
														academicTermCombo.setValue(academicTermId);
															var courseMarksGrades_Store = courseMarksGradesField.getStore();
															courseMarksGrades_Store.getProxy().extraParams = {
																academyLocationIds : academyLocationId
															};
															courseMarksGrades_Store.load({
																callback: function(rec, success) {
																	if (success) {
																		for(var i in rec){
																			if(rec[i].get('id')=='GRADE'){
																				var courseMarksGradesFieldId = rec[i].get('id');
																				courseMarksGradesField.setValue(rec[i].get('id'));
																				if(academyLocationId > 0) {
																					form.getForm().isValid();
																					form.getForm().clearInvalid();
																					programBatchCombo.setDisabled(false);
																					var programBatchStore = programBatchCombo.getStore();
																					programBatchStore.getProxy().extraParams = {
																						academyLocationIds : academyLocationId,
																						academicTermId : academicTermId,
																						programType:courseMarksGradesFieldId
																					};
																					programBatchStore.load({
																						callback: function(records, operation, success) {
																							if (success) {
																								if(records.length == 1){
																									var batchId = records[0].get('id');
																									var batchIds = [batchId];
																									programBatchCombo.setValue(batchIds);
																									programWisePeriodCombo.setDisabled(false);
																									
																								}
																							}
																						}
																					});
																				}
																			}
																		}
																	}
																}
															});
													}
												}
												if(academicTermId == 0) {
													$this.academicTermChange();
												}
											}
										});
									}
								}
							}
						}
					});
				},
				showDetailedViewOfCourse:function(grid, RowIdx, record){
					var $this = this;
					var structure = this.getCoursesectionmanagementstructure();
					var aLId = $this.getCurrentAcademyLocation();
					var radiogroupValue = structure.down('#sectionTypeRadio').getValue();
					var structure = this.getCoursesectionmanagementstructure();
					var panel=structure.down('#coursesectionmanagementpanel');
					var detailedPanel = panel.down('#detailedviewpanel');
					
				    panel.setActiveTab(detailedPanel);
					if(radiogroupValue.sectionType=='PROGRAM_WISE_SECTION'){
						var form = $this.getProgramwisesectionsearch();
						var academyLocationId = form.down('#academyLocation').getValue();
						var academicTermId = form.down('#programWiseAcademicTermId').getValue();
						var batchRecord = form.down('#programWiseProgramId').getValue();
						var periodRecord = form.down('#programWisePeriodId').getValue();
						var courseWithoutSection = form.down('#programWiseCheckBoxId').getValue();
						var sectionRecord = form.down('#programWiseSectionId').getValue();
						var batchIds = [];
						if(!isNullOrEmpty(batchRecord)) {
							Ext.each(batchRecord,function(batch){
								if(typeof batch=="number"){
									batchIds.push(batch);
								}else if(!isNullOrEmpty(batch.data)){
									batchIds.push(batch.data.id);
								}
							});
						}
						var periodIds = [];
						if(!isNullOrEmpty(periodRecord)) {
							Ext.each(periodRecord,function(period){
								if(typeof period=="number"){
									periodIds.push(period);
								}else if(!isNullOrEmpty(period.data)){
									periodIds.push(period.data.id);
								}
							});
						}
						var courseIds = [];
						courseIds.push(record.data.courseId);
						
						var sectionIds = [];
						if(!isNullOrEmpty(sectionRecord)) {
							Ext.each(sectionRecord,function(section){
								if(typeof section=="number"){
									sectionIds.push(section);
								}else if(!isNullOrEmpty(section.data)){
									sectionIds.push(section.data.id);
								}
							});
						}
						
						var grid = this.getManagecoursesectiondetailedviewgrid();
						var store = grid.getStore();
						store.getProxy().extraParams = {
							academyLocationIds : academyLocationId,
							academicTermId : academicTermId,
							batchIds : batchIds.join(),
							periodIds : periodIds.join(),
							courseIds : courseIds.join(),
							courseWithoutSection : courseWithoutSection,
							sectionIds : sectionIds.join()
						};
						store.load();
					}else{
						var form=this.getOpensectionsearch();
						var departmentId = form.down('#courseDepartment').getValue();
						var subDeptId = form.down('#courseSubDepartment').getValue();
						var courseCategory = form.down('#courseCategory').getValue();
						var courseRecord = form.down('#courseSectionId').getValue();
						var sectionRecord = form.down('#openWiseSectionId').getValue();
						var courseMarksGrade = form.down('#courseMarksGrades_id').getValue();
						var courseMarksGradeVal;
						if(courseMarksGrade=="GRADE"){
							courseMarksGradeVal="G";
						}else{
							courseMarksGradeVal="M";
						}
						var courseWithoutSection = form.down('#programWiseCheckBoxId').getValue();
						var courseIds = [];
						courseIds.push(record.data.courseId);
						var sectionIds = [];
						if(!isNullOrEmpty(sectionRecord)) {
							Ext.each(sectionRecord,function(section){
								if(typeof section=="number"){
									sectionIds.push(section);
								}else if(!isNullOrEmpty(section.data)){
									sectionIds.push(section.data.id);
								}
							});
						}
						var grid = this.getManagecoursesectiondetailedviewgrid();
						var store = grid.getStore();
						store.getProxy().extraParams = {
						//	academyLocationIds : aLId,
							departmentId : departmentId,
							subDeptId : subDeptId,
							courseCategory : courseCategory,
							courseIds : courseIds.join(),
							courseWithoutSection : courseWithoutSection,
							courseMarksGrade : courseMarksGradeVal,
							sectionIds : sectionIds.join(),
							isOpenSection:true
						};
						store.load();
					}
			    },
				showMappedProgramPeriodPeriodWithCourse:function(grid, RowIdx, record){
			    	var docWindow = this.getSectionteachermappinglist();
			    	if (!docWindow) {
			    		Ext.widget('sectionteachermappinglist');
			    		docWindow = this.getSectionteachermappinglist();
			    	}
			    	docWindow.show();
			    	docWindow.setTitle(getProgramandcourseTranslation('PROGRAMS_ASSOCIATED'));
			    	docWindow.down('#sectionteachermappinggrid').setVisible(false);
			    	docWindow.down('#sectionassociatedprogramgrid').setVisible(true);
			    	
			    	var formWindow = docWindow.down('#sectionteachermappingviewItemId');
			    	formWindow.down('#courseVariantId').setVisible(false);
			    	formWindow.down('#courseId').setVisible(true);
			    	formWindow.down('#courseId').setValue(record.data.courseCode+" / "+record.data.courseName);
			    	var programAssociateGrid = this.getSectionassociatedprogramgrid();
			    	var store = programAssociateGrid.getStore();
			    	var columnModel = [];
			    	 columnModel.push({
		    				header : getCourseTxCommonTranslation('PROGRAM'),
		    				dataIndex : 'programName',
		    				flex : 1,
		    			},{
		    				header : getCourseTxCommonTranslation('BATCH'),
		    				dataIndex : 'batchName',
		    				flex : 1,
		    			},{
		    				header : getCommonTranslation('PERIOD'),
		    				dataIndex : 'periodName',
		    				flex : 1,
		    			});
		    		 
		    		 
			    	 programAssociateGrid.reconfigure(null,columnModel);
			    	 programAssociateGrid.getView().refresh();
			    	store.loadData(record.data.prgBtchPrdModelList);
			    },
			    showMappedProgramPeriodPeriodWithCourseVariant:function(grid, RowIdx, record){
			    	var docWindow = this.getSectionteachermappinglist();
			    	if (!docWindow) {
			    		Ext.widget('sectionteachermappinglist');
			    		docWindow = this.getSectionteachermappinglist();
			    	}
			    	docWindow.show();
			    	docWindow.setTitle(getProgramandcourseTranslation('PROGRAMS_ASSOCIATED'));
			    	docWindow.down('#sectionteachermappinggrid').setVisible(false);
			    	docWindow.down('#sectionassociatedprogramgrid').setVisible(true);
			    	
			    	var formWindow = docWindow.down('#sectionteachermappingviewItemId');
			    	formWindow.down('#courseVariantId').setVisible(true);
			    	formWindow.down('#courseId').setVisible(false);
			    	formWindow.down('#courseVariantId').setValue(record.data.courseVariantName);
			    	var programAssociateGrid = this.getSectionassociatedprogramgrid();
			    	var store = programAssociateGrid.getStore();
			    	var saveBtnId = docWindow.down('#saveBtnId');
			    	var cancelBtnId = docWindow.down('#cancelBtnId');
			    	saveBtnId.show();
			    	cancelBtnId.show();
			    	var columnModel = [];
			    	var columnModelForMarkGradeType =[];
			    	columnModel.push({
			    		header : getCourseTxCommonTranslation('PROGRAM'),
			    		dataIndex : 'programName',
			    		flex : 1,
			    	},{
			    		header : getCourseTxCommonTranslation('BATCH'),
			    		dataIndex : 'batchName',
			    		flex : 1,
			    	},{
			    		header : getCommonTranslation('PERIOD'),
			    		dataIndex : 'periodName',
			    		flex : 1,
			    	},{
			    		header : getCommonTranslation('CREDIT'),
			    		dataIndex : 'courseCredits',
			    		editor:{

			    			xtype : 'numberfield',
			    			name: 'courseCredits',
			    			itemId:'courseCredit_Id',
			    			minValue : 0,
			    			allowDecimals:true,
			    			decimalPrecision: 2,

			    		},
			    		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			    			if(!isNullOrEmpty(value) && value !== '') {
			    				try{
			    					return value;
			    				}
			    				catch(e){
			    					return null;
			    				}
			    			}
			    			else {
			    				rec.tdCls = 'gridInputCustomStyle';
			    				return getExaminationTranslation('CLICK_TO_ENTER');
			    			}
			    		}
			    	});
			    	if(record.data.prgBtchPrdModelList[0].courseMarksGrades == 'G'){
			    		columnModelForMarkGradeType.push({
			    			header: getCommonTranslation('GRADE_TYPE'),
			    			dataIndex: 'courseGradeType',
			    			sortable: false,
			    			flex:1,
			    			editor: {
			    				xtype: 'customcombobox',
			    				itemId:'courseMarksGrades',
			    				name:'courseMarksGrades',
			    				store:Ext.create('Academia.store.course.CourseGradeStore'),
			    				displayField: 'value',
			    				valuefield:'value',
			    				listeners: {
			    					select:function(obj,rec){
			    						var grid=obj.up('sectionassociatedprogramgrid');
			    						var gridCol =grid.getView().getGridColumns();
			    						var minPassGrade = gridCol[5].getEditor();
			    						var maxPassGrade = gridCol[6].getEditor();
			    						grid.editingPlugin.activeRecord.set('courseMaxMark','');
			    						grid.editingPlugin.activeRecord.set('courseCutOff','');
			    						minPassGrade.getStore().getProxy().extraParams={
			    							gradeType : rec[0].data.value
			    						}
			    						minPassGrade.getStore().load();
			    						maxPassGrade.getStore().getProxy().extraParams={
			    							gradeType : rec[0].data.value
			    						}
			    						maxPassGrade.getStore().load();
			    					}
			    				}
			    			},
			    			renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			    				if(!isNullOrEmpty(value) && value !== '') {
			    					try{
			    						var grid=view.up('sectionassociatedprogramgrid');
			    						var gridCol =grid.getView().getGridColumns();
			    						var minPassGrade = gridCol[5].getEditor();
			    						var maxPassGrade = gridCol[6].getEditor();
			    						
				    						minPassGrade.getStore().getProxy().extraParams={
				    							gradeType : value
				    						}
				    						minPassGrade.getStore().load();
				    						maxPassGrade.getStore().getProxy().extraParams={
				    							gradeType : value
				    						}
				    						maxPassGrade.getStore().load();
			    						    return value;
			    					}
			    					catch(e){
			    						return null;
			    					}
			    				}
			    				else {
			    					rec.tdCls = 'gridInputCustomStyle';
			    					return getExaminationTranslation('CLICK_TO_ENTER');
			    				}
			    			}
			    		},{
			    			header: getCommonTranslation('MIN_PASSING_GRADE'),
			    			dataIndex: 'courseCutOff',
			    			sortable: false,
			    			flex:1,
			    			editor: {
			    				xtype: 'customcombobox',
			    				itemId:'minPassingGradeItemId',
			    				name:'courseCutOffComboMin',
			    				store:Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades'),
			    				displayField: 'gradeName',
			    				valuefield:'gradeName',
			    				forceSelection:true,
			    				
			    			},
			    			renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			    				if(!isNullOrEmpty(value) && value !== '') {
			    					try{
			    						return value;
			    					}
			    					catch(e){
			    						return null;
			    					}
			    				}
			    				else {
			    					rec.tdCls = 'gridInputCustomStyle';
			    					return getExaminationTranslation('CLICK_TO_ENTER');
			    				}
			    			}
			    		},{
			    			header: getCommonTranslation('MAX_PASSING_GRADE'),
			    			dataIndex: 'courseMaxMark',
			    			sortable: false,
			    			flex:1,
			    			editor: {

			    				xtype: 'customcombobox',
			    				itemId:'maxPassingGradeItemId',
			    				name:'courseCutOffComboMax',
			    				store:Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades'),
			    				displayField: 'gradeName',
			    				valuefield:'gradeName',
			    				forceSelection:true,
			    			},
			    			renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			    				if(!isNullOrEmpty(value) && value !== '') {
			    					try{
			    						return value;
			    					}
			    					catch(e){
			    						return null;
			    					}
			    				}
			    				else {
			    					rec.tdCls = 'gridInputCustomStyle';
			    					return getExaminationTranslation('CLICK_TO_ENTER');
			    				}
			    			}
			    		});
			    	}
			    	else if(record.data.prgBtchPrdModelList[0].courseMarksGrades == 'M'){
			    		columnModelForMarkGradeType.push({
			    			header: getCommonTranslation('MIN_PASSING_MARKS'),
			    			dataIndex: 'courseCutOff',
			    			sortable: false,
			    			flex:1,
			    			editor: {

			    				xtype: 'numberfield',
			    				itemId:'minPassingMarkItemId',
			    				name: 'minPassingMark',
			    				minValue : 0,
			    				minText:getCommonTranslation('COURSE_DEFICITS_POINT_MSG'),
			    				validator : function(val,rec) {
			    					var grid = this.up('grid');
			    					var record= grid.editingPlugin.activeRecord;
			    					var maxValue = record.data.courseMaxMark;
			    					if (!isNullOrEmpty(maxValue)) {
			    						if (parseInt(val)< parseInt(maxValue)) {
			    							return true;
			    						} else {
			    							return getCommonTranslation('LESS_THAN_MAX_VALUE');
			    						}
			    					} else {
			    						return true;
			    					}
			    				}
			    			},
			    			renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			    				if(!isNullOrEmpty(value) && value !== '') {
			    					try{
			    						return value;
			    					}
			    					catch(e){
			    						return null;
			    					}
			    				}
			    				else {
			    					rec.tdCls = 'gridInputCustomStyle';
			    					return getExaminationTranslation('CLICK_TO_ENTER');
			    				}
			    			}
			    		},{  header: getCommonTranslation('COURSE_MAXIMUM_PASSING_MARKS'),
			    			dataIndex: 'courseMaxMark',
			    			sortable: false,
			    			flex:1,
			    			editor: {

			    				xtype: 'numberfield',
			    				itemId:'maxPassingMarkItemId',
			    				name: 'maxPassingMark',
			    				minValue : 1,
			    				minText:getCommonTranslation('MAX_PASSING_MARKS'),
			    				validator : function(val,rec) {
			    					var grid = this.up('grid');
			    					var record= grid.editingPlugin.activeRecord;
			    					var minValue = record.data.courseCutOff;
			    					if (!isNullOrEmpty(minValue)) {
			    						if (parseInt(val) >= parseInt(minValue)) {
			    							return true;
			    						} else {
			    							return getCommonTranslation('MORE_THAN_MIN_VALUE');
			    						}
			    					} else {
			    						return true;
			    					}
			    				}
			    			},
			    			renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			    				if(!isNullOrEmpty(value) && value !== '') {
			    					try{
			    						return value;
			    					}
			    					catch(e){
			    						return null;
			    					}
			    				}
			    				else {
			    					rec.tdCls = 'gridInputCustomStyle';
			    					return getExaminationTranslation('CLICK_TO_ENTER');
			    				}
			    			}
			    		})
			    	}else{
			    		if(record.data.courseMarksGrades == 'G'){
				    		columnModelForMarkGradeType.push({
				    			header: getCommonTranslation('GRADE_TYPE'),
				    			dataIndex: 'courseGradeType',
				    			sortable: false,
				    			flex:1,
				    			editor: {
				    				xtype: 'customcombobox',
				    				itemId:'courseMarksGrades',
				    				name:'courseMarksGrades',
				    				store:Ext.create('Academia.store.course.CourseGradeStore'),
				    				displayField: 'value',
				    				valuefield:'value',
				    				listeners: {
				    					select:function(obj,rec){
				    						var grid=obj.up('sectionassociatedprogramgrid');
				    						var gridCol =grid.getView().getGridColumns();
				    						var minPassGrade = gridCol[5].getEditor();
				    						var maxPassGrade = gridCol[6].getEditor();
				    						grid.editingPlugin.activeRecord.set('courseMaxMark','');
				    						grid.editingPlugin.activeRecord.set('courseCutOff','');
				    						minPassGrade.getStore().getProxy().extraParams={
				    							gradeType : rec[0].data.value
				    						}
				    						minPassGrade.getStore().load();
				    						maxPassGrade.getStore().getProxy().extraParams={
				    							gradeType : rec[0].data.value
				    						}
				    						maxPassGrade.getStore().load();
				    					}
				    				}
				    			},
				    			renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
				    				if(!isNullOrEmpty(value) && value !== '') {
				    					try{
				    						var grid=view.up('sectionassociatedprogramgrid');
				    						var gridCol =grid.getView().getGridColumns();
				    						var minPassGrade = gridCol[5].getEditor();
				    						var maxPassGrade = gridCol[6].getEditor();
				    						
					    						minPassGrade.getStore().getProxy().extraParams={
					    							gradeType : value
					    						}
					    						minPassGrade.getStore().load();
					    						maxPassGrade.getStore().getProxy().extraParams={
					    							gradeType : value
					    						}
					    						maxPassGrade.getStore().load();
				    						    return value;
				    					}
				    					catch(e){
				    						return null;
				    					}
				    				}
				    				else {
				    					rec.tdCls = 'gridInputCustomStyle';
				    					return getExaminationTranslation('CLICK_TO_ENTER');
				    				}
				    			}
				    		},{
				    			header: getCommonTranslation('MIN_PASSING_GRADE'),
				    			dataIndex: 'courseCutOff',
				    			sortable: false,
				    			flex:1,
				    			editor: {
				    				xtype: 'customcombobox',
				    				itemId:'minPassingGradeItemId',
				    				name:'courseCutOffComboMin',
				    				store:Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades'),
				    				displayField: 'gradeName',
				    				valuefield:'gradeName',
				    				forceSelection:true,
				    				
				    			},
				    			renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
				    				if(!isNullOrEmpty(value) && value !== '') {
				    					try{
				    						return value;
				    					}
				    					catch(e){
				    						return null;
				    					}
				    				}
				    				else {
				    					rec.tdCls = 'gridInputCustomStyle';
				    					return getExaminationTranslation('CLICK_TO_ENTER');
				    				}
				    			}
				    		},{
				    			header: getCommonTranslation('MAX_PASSING_GRADE'),
				    			dataIndex: 'courseMaxMark',
				    			sortable: false,
				    			flex:1,
				    			editor: {

				    				xtype: 'customcombobox',
				    				itemId:'maxPassingGradeItemId',
				    				name:'courseCutOffComboMax',
				    				store:Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades'),
				    				displayField: 'gradeName',
				    				valuefield:'gradeName',
				    				forceSelection:true,
				    			},
				    			renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
				    				if(!isNullOrEmpty(value) && value !== '') {
				    					try{
				    						return value;
				    					}
				    					catch(e){
				    						return null;
				    					}
				    				}
				    				else {
				    					rec.tdCls = 'gridInputCustomStyle';
				    					return getExaminationTranslation('CLICK_TO_ENTER');
				    				}
				    			}
				    		});
				    	}
				    	else if(record.data.courseMarksGrades == 'M'){
				    		columnModelForMarkGradeType.push({
				    			header: getCommonTranslation('MIN_PASSING_MARKS'),
				    			dataIndex: 'courseCutOff',
				    			sortable: false,
				    			flex:1,
				    			editor: {

				    				xtype: 'numberfield',
				    				itemId:'minPassingMarkItemId',
				    				name: 'minPassingMark',
				    				minValue : 0,
				    				minText:getCommonTranslation('COURSE_DEFICITS_POINT_MSG'),
				    				validator : function(val,rec) {
				    					var grid = this.up('grid');
				    					var record= grid.editingPlugin.activeRecord;
				    					var maxValue = record.data.courseMaxMark;
				    					if (!isNullOrEmpty(maxValue)) {
				    						if (parseInt(val)< parseInt(maxValue)) {
				    							return true;
				    						} else {
				    							return getCommonTranslation('LESS_THAN_MAX_VALUE');
				    						}
				    					} else {
				    						return true;
				    					}
				    				}
				    			},
				    			renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
				    				if(!isNullOrEmpty(value) && value !== '') {
				    					try{
				    						return value;
				    					}
				    					catch(e){
				    						return null;
				    					}
				    				}
				    				else {
				    					rec.tdCls = 'gridInputCustomStyle';
				    					return getExaminationTranslation('CLICK_TO_ENTER');
				    				}
				    			}
				    		},{  header: getCommonTranslation('COURSE_MAXIMUM_PASSING_MARKS'),
				    			dataIndex: 'courseMaxMark',
				    			sortable: false,
				    			flex:1,
				    			editor: {

				    				xtype: 'numberfield',
				    				itemId:'maxPassingMarkItemId',
				    				name: 'maxPassingMark',
				    				minValue : 1,
				    				minText:getCommonTranslation('MAX_PASSING_MARKS'),
				    				validator : function(val,rec) {
				    					var grid = this.up('grid');
				    					var record= grid.editingPlugin.activeRecord;
				    					var minValue = record.data.courseCutOff;
				    					if (!isNullOrEmpty(minValue)) {
				    						if (parseInt(val) >= parseInt(minValue)) {
				    							return true;
				    						} else {
				    							return getCommonTranslation('MORE_THAN_MIN_VALUE');
				    						}
				    					} else {
				    						return true;
				    					}
				    				}
				    			},
				    			renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
				    				if(!isNullOrEmpty(value) && value !== '') {
				    					try{
				    						return value;
				    					}
				    					catch(e){
				    						return null;
				    					}
				    				}
				    				else {
				    					rec.tdCls = 'gridInputCustomStyle';
				    					return getExaminationTranslation('CLICK_TO_ENTER');
				    				}
				    			}
				    		})
				    	}
			    	}

			    	if(columnModelForMarkGradeType.length > 0){
			    		for(var i=0; i< columnModelForMarkGradeType.length; i++){
			    			columnModel.push(columnModelForMarkGradeType[i]);		 
			    		}
			    	}

			    	programAssociateGrid.reconfigure(null,columnModel);
			    	programAssociateGrid.getView().refresh();
			    	store.loadData(record.data.prgBtchPrdModelList);
			    },
			    getCurrentlyEnrolledStudentOfCourseSection:function(record){
			    	var $this = this;
			    	var tabName = getProgramandcourseTranslation('ENROLLED_STUDENTS');
			    	var contentPanel = $this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
			    	var structure = Ext.widget('managecoursesectionstudentstructure');
			    	/**
			    	 * This is to remove tab from content panel and open same tab again
			    	 */
			    	var getcontroller=$this.getController('menu.CoreERPNavigationController');
			    	var getTab = null;
			    	for(var i =0 ;i<contentPanel.items.length;i++){
			    		if(contentPanel.items.items[i].title == tabName){
			    			getTab= contentPanel.items.items[i];
			    		}
			    	}
			    	if(getTab!=null){
			    		contentPanel.remove(getTab, true);
			    	}
			    	openTab(contentPanel, tabName, structure);
			    	var detailsFilter =  $this.getStudentcoursesectiondetails();
			    	detailsFilter.down('#courseName').setValue(record.get("courseCode")+" / "+record.get("courseName"));
			    	detailsFilter.down('#sectionId').setValue(record.get("sectionId"));
			    	detailsFilter.down('#courseId').setValue(record.get("courseId"));
			    	detailsFilter.down('#academicTermId').setValue(record.get("academicTermId"));
			    	var courseSectionId = record.get("courseId");
			    	var sectionId = record.get("sectionId");
			    	var store1 = $this.getStore('coursetransaction.sectionmanagement.CourseSectionStudentStore');
			    	var grid=$this.getManagecoursesectionstudentgrid();
			    	detailsFilter.down('#componentName').setVisible(false);
			    	store1.getProxy().extraParams = {
			    		courseId : courseSectionId,
			    		sectionId:sectionId,
			    		sort:null
			    	};
			    	store1.load({
			    		callback:function(success,rec){
			    			var sectTrf=rec.resultSet.records[0].data.status;
			    			var assignSectionLink = Ext.ComponentQuery.query('#assignSectionforCourseLink')[0];
			    			/*if(!sectTrf){
			    				assignSectionLink.setDisabled(true);
			    			}
			    			else{
			    				assignSectionLink.setDisabled(false);
			    			}*/
			    		}	 
			    	});
			    	//grid.down('#spBtnMoreActions').setVisible(true);
			    },
			    showPrimaryTeacherOfCourseVariant:function(grid, RowIdx, record){
			    	var docWindow = this.getSectionteachermappinglist();
			    	if (!docWindow) {
			    		Ext.widget('sectionteachermappinglist');
			    		docWindow = this.getSectionteachermappinglist();
			    	}
			    	docWindow.show();
			    	docWindow.setTitle(getProgramandcourseTranslation('FACULTYS_ASSIGNED'));
			    	docWindow.down('#sectionteachermappinggrid').setVisible(true);
			    	docWindow.down('#sectionassociatedprogramgrid').setVisible(false);
			    	var formWindow = docWindow.down('#sectionteachermappingviewItemId');
			    	formWindow.down('#courseVariantId').setVisible(true);
			    	formWindow.down('#courseId').setVisible(false);
			    	formWindow.down('#courseVariantId').setValue(record.data.courseVariantName);
			    	var teacherGrid = this.getSectionteachermappinggrid();
			    	var store = teacherGrid.getStore();
			//    	store.loadData(record.data.facultyList);
			    	store.getProxy().extraParams ={
			    		courseVariantId :record.data.courseVariantId
 	        	//	   limit:-1
 	        	   },
 	        	//    this.resetPageSetting(store);
			    	store.load();
			    },
			    deleteSections : function(){
			    	var detailedGrid = this.getManagecoursesectiondetailedviewgrid();
			    	if(detailedGrid.getSelectionModel().getCount()>0){
               		 showConfirmMessage(getCourseTxCommonTranslation('COURSE_SECTION'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
               			 if (btn == 'yes') {
               				
        					var gridRecords = detailedGrid.getSelectionModel().getSelection();						        
        					var submitDataModel=[];
        					if(!isNullOrEmpty(gridRecords)) {
        						Ext.each(gridRecords,function(records){
        							var courseVariantId=records.data.courseVariantId;
        							var sectionId=records.data.sectionId;
        							var submitData= new Object();
        							submitData.id = sectionId;
        							submitData.secondId = courseVariantId;
        							submitDataModel.push(submitData);
        							
        						});
        					}
            				var fData = Ext.encode(submitDataModel);
               				 Ext.Ajax.request({
               					 method: "DELETE",
               					 type: 'rest',
               					jsonData: fData,
               					 url: SERVERURL.PATH_DELETE_COURSE_SECTIONS,
               					 headers: {
               						 'Content-Type': 'application/json'
               					 },
               					 success:function(response){
               						 var MSSG = response.responseText;
               						 if(MSSG=="SUCCEESS"){
               							showSuccessMessage(getCourseTxCommonTranslation('COURSE_SECTION'),getCommonTranslation('SUCCESS'));//Section deleted successfully
               							 
               						 }else{
               							var array = MSSG.split(',');
               							var deleteCount=array[0];
               							var totalCount=array[1];
               							MSSG=deleteCount+getCommonTranslation('OUT_OF')+totalCount+getCommonTranslation('COURSE_SECTIONS_DELETED_MSG');
               							showWarningMessage(getCourseTxCommonTranslation('COURSE_SECTION'),MSSG);
               						 }}
               				 });
               			 };
               		 });
               	 }
			    },
				saveSectionTeacherMapping : function(){
					var $this=this;
    				var windowForm=this.getSectionteachermappingform();
    				var facultyRecord=windowForm.down('#facultyNameItemId').getValue();
    				var alternateFacultyRecord=windowForm.down('#alternateNameItemId').getValue();
    				var facultyIds = [];
					if(!isNullOrEmpty(facultyRecord)) {
						Ext.each(facultyRecord,function(faculty){
							if(typeof faculty=="number"){
								facultyIds.push(faculty);
							}else if(!isNullOrEmpty(faculty.data)){
								facultyIds.push(faculty.data.id);
							}
						});
					}
					var alternateFacultyIds = [];
					if(!isNullOrEmpty(alternateFacultyRecord)) {
						Ext.each(alternateFacultyRecord,function(alternateFaculty){
							if(typeof alternateFaculty=="number"){
								alternateFacultyIds.push(alternateFaculty);
							}else if(!isNullOrEmpty(alternateFaculty.data)){
								alternateFacultyIds.push(alternateFaculty.data.id);
							}
						});
					}
					var detailedGrid = this.getManagecoursesectiondetailedviewgrid();
					var gridRecords = detailedGrid.getSelectionModel().getSelection();
					var submitDataModel=[];
					if(!isNullOrEmpty(gridRecords)) {
						Ext.each(gridRecords,function(records){
							var programBatchCourseParamIds=[];
							var courseVariantId=records.data.courseVariantId;
							Ext.each(records.data.prgBtchPrdModelList,function(record){
								programBatchCourseParamIds.push(record.programBatchCourseParamId);
							});
							var submitData= new Object();
							submitData.courseVariantId = courseVariantId;
							submitData.programBatchCourseParamIds = programBatchCourseParamIds.join();
							submitData.facultyIds = facultyIds.join();
							submitData.alternatFacultyIds = alternateFacultyIds.join();
							submitDataModel.push(submitData);
							
						});
					}
    				var fData = Ext.encode(submitDataModel);
    				var submitUrl= SERVERURL.MAP_FACAULTYS_WITH_COURSE_VARIANT;
    				Ext.Ajax.request({
    					type: 'rest',
    					url: submitUrl,
    					jsonData: fData,
    					method: 'POST',
    					headers: {
    						'Content-Type': 'application/json'
    					},
    					success: function(f, action) {
    						var detailedGrid = $this.getManagecoursesectiondetailedviewgrid();
    						var gridRecords = detailedGrid.getSelectionModel().getSelection();
    						var submitDataModel=[];
    						var programBatchCourseParamIds=[];
    						if(!isNullOrEmpty(gridRecords)) {
    							Ext.each(gridRecords,function(records){
    						
    								var courseVariantId=records.data.courseVariantId;
    								Ext.each(records.data.prgBtchPrdModelList,function(record){
    									programBatchCourseParamIds.push(record.programBatchCourseParamId);
    								});
    								
    								
    							});
    						}
    						if(programBatchCourseParamIds.length==0)
       					    	showSuccessMessage(getCommonTranslation('ADD_FACULTY'), getCommonTranslation('NON_PARAMETERIZED_SUBMIT'));
    						else
    						showSuccessMessage(getCommonTranslation('ADD_FACULTY'), getCommonTranslation('FACULTY_SAVED_SUCCESSFULLY'));
    						$this.closeSectionTeacherMappingWindow();
    						var detailedgrid = $this.getManagecoursesectiondetailedviewgrid();
    						var detailedStore = detailedgrid.getStore();
    						detailedStore.load();
    					}
    				});
    			
				},
				disableRadioSelectionsPivileges: function(form, permissionsMap) {
					var associatedAcadLocationIds = new Array();
					associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
					var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
					var programWiseSection, openSection = false;
					var radioButton = form.down('#sectionTypeRadio');
					var criteriaBasedGradeFieldId = form.down('#sectionTypeRadioFieldId');
					criteriaBasedGradeFieldId.setVisible(false);
					Ext.each(permissionList, function(privilege) {
						if (privilege === 'PROGRAM_SECTION') {
							programWiseSection = true;
						}
						if (privilege === 'OPEN_SECTION') {
							openSection = true;
						}
					});
					if (programWiseSection && openSection) {
						criteriaBasedGradeFieldId.setVisible(true);
						radioButton.items.items[0].setValue(true);
						radioButton.items.items[1].setValue(false);
					} else if (programWiseSection && !openSection) {
						criteriaBasedGradeFieldId.setVisible(false);
						radioButton.items.items[1].setValue(false);
						radioButton.items.items[0].setValue(true);
					} else if (openSection && !programWiseSection) {
						criteriaBasedGradeFieldId.setVisible(false);
						radioButton.items.items[1].setValue(true);
						radioButton.items.items[0].setVisible(false);
					} else  if (!programWiseSection && !openSection) {
						criteriaBasedGradeFieldId.setVisible(false);
						radioButton.items.items[1].setVisible(false);
						radioButton.items.items[0].setValue(true);
					}
				},
                getIdValueJson: function(id, value) {
               	 if (id) return {
               		 id: id,
               		 value: value
               	 };
                },
				openEditCourseSectionGroupForm: function(){
					var $this = this;
					var grid=$this.getManagecoursesectiondetailedviewgrid();
					var portalId = $this.getCurrentLoggedPortalId();
					var classRoomStore = Ext.getStore('coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.ClassRoom');
					if (grid.getSelectionModel().getCount() > 0) {
						var gridRecord = grid.getSelectionModel().getSelection();
						var contentPanel = grid.up().up(); 
						var structure = Ext.widget('editcoursesectiongroupstructure', {
							itemId: 'editcoursesectiongroupstructureItemId'
						});
						var tabName = getCourseTxCommonTranslation('EDIT_SECTION');
						var getcontroller=$this.getController('menu.CoreERPNavigationController');
						var getTab = null;
						for(var i =0 ;i<contentPanel.items.length;i++){
							if(contentPanel.items.items[i].title == getCourseTxCommonTranslation('EDIT_SECTION')){
								getTab= contentPanel.items.items[i];
							}
						}
						if(getTab!=null){
							contentPanel.remove(getTab, true);
						}
						classRoomStore.load({
							callback: function(){
								openTab(contentPanel, tabName, structure);
								var windowGridNew=$this.getEditcoursesectionlistgrid();
								var alinfomodel = Academia.model.authentication.ALInfoModel;
								var whetherSchool = alinfomodel.get('wheatherSchool');
								//var  evaluationPlanIdCombo = windowGridNew.down('#evaluationPlanId');
							/*if(!whetherSchool){
									var evaluationPlanIdCombo = windowGridNew.down('[dataIndex=evaluationPlanId]');
				                		evaluationPlanIdCombo.hide();
								
									//var e=windowGridNew.down('[dataIndex=evaluationPlanId]').setReadOnly(true);
								}*/
						
							
					//		var e=windowGridNew.down('[dataIndex=evaluationPlanId]').setReadOnly(true);
								/*var roomStore=$this.getStore('coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.ClassRoom');
								roomStore.load();
								
								var evalStore=$this.getStore('common.EvaluationPlanByPeriodStore');
								evalStore.load();
								
								var enrollStore=$this.getStore('common.StudentEnrolmentCriteriaStore');
								enrollStore.load();*/
								
								/*if(data.evalInMarksOrGrade=='GRADE' && data.gradeType!=null){
													var gradeStore=$this.getStore('gradeMaster.GradeGroupMapping');
													gradeStore.getProxy().extraParams = {
				        								gradeType:data.gradeType,
				        								evaluationDetailSequneceId:gridRecord[0].data.evaluationSequenceDetailId
				        							};
				        							gradeStore.load();
												}	
											}*/
								var windowGridArray=[];
								Ext.Array.each(gridRecord, function(student) {
										var data={
												"id":student.data.id,
												"courseId":student.data.courseId,
												"courseName":student.data.courseName,
												"courseVariantId":student.data.courseVariantId,
												"courseVariantName":student.data.courseVariantName,
												"sectionId":student.data.sectionId,
												"campusCode":student.data.campusCode,
												"sectionName":student.data.sectionName,
												"sectionPrintName":student.data.sectionPrintName,
												"roomId":student.data.roomId,
												"minCapacity":student.data.minCapacity,
												"maxCapacity":student.data.maxCapacity,
												"academicTermId":student.data.academicTermId,
												"calendarId":student.data.calendarId,
											   "printNameInMarksheet":student.data.printNameInMarksheet,
												"evaluationPlanId":student.data.evaluationPlanId,
												"studentCourseEnrollmentCriteria":student.data.studentCourseEnrollmentCriteria,
												"sectionRule":student.data.sectionRule,
												"roomId":student.data.roomId,
												
										};
										windowGridArray.push(data);
								});
								var store = windowGridNew.getStore();
								store.clearFilter();
								store.removeAll();
								store.loadRawData(windowGridArray);
								/*tempERGStore = Ext.create('Academia.store.coursetransaction.homework.AssessmentEventResultStore');
								tempERGStore.clearFilter();
								tempERGStore.removeAll();
								tempERGStore.loadRawData(windowGridArray);*/
								
							}
						});
					}else{
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				},
				updateEditCourseSectionGridItems: function(button){
					var $this=this;
					var grid=button.up('grid');
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var whetherSchool = alinfomodel.get('wheatherSchool');
					var getcontroller=$this.getController('menu.CoreERPNavigationController');
					if (grid.getSelectionModel().getCount() > 0) {
						var selected = [];
						var gridRecord=grid.getSelectionModel().getSelection();
						Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						Ext.Array.each(gridRecord, function(currentRecord) {
							var courseSectionObject = {};
							courseSectionObject['sectionCode'] = null;
							if(!isNullOrEmpty(currentRecord.data.campusCode)){
								courseSectionObject['sectionCode'] = currentRecord.data.campusCode+"/"+ currentRecord.data.sectionName;
							}else{
								courseSectionObject['sectionCode'] = currentRecord.data.sectionName;
							}
							courseSectionObject['alternateName'] = currentRecord.data.sectionName;
							courseSectionObject['sectionRule'] = currentRecord.data.sectionRule;
							courseSectionObject['minCapacity'] = currentRecord.data.minCapacity;
							courseSectionObject['maxCapacity'] = currentRecord.data.maxCapacity;
							courseSectionObject['homeRoom'] = $this.getIdValueJson(currentRecord.data.roomId);
							courseSectionObject['academicTerm'] = $this.getIdValueJson(currentRecord.data.academicTermId);
							courseSectionObject['evaluationPlan'] = $this.getIdValueJson(currentRecord.data.evaluationPlanId);
							courseSectionObject['course'] = $this.getIdValueJson(currentRecord.data.courseId);
							courseSectionObject['calender'] = $this.getIdValueJson(currentRecord.data.calendarId);
							courseSectionObject['studentCourseEnrollmentCriteria'] = currentRecord.data.studentCourseEnrollmentCriteria;
							courseSectionObject['id'] = currentRecord.data.sectionId;
							courseSectionObject['courseVariant'] = $this.getIdValueJson(currentRecord.data.courseVariantId);
							selected.push(courseSectionObject);	
						});
						Ext.Ajax.request({
							method: "POST",
							type: 'rest',
							url: SERVERURL.COURSE_SECTION_UPDATE_ALL,
							jsonData:selected,
							success : function(response, action) {
								 var me = this;
								
								Ext.getBody().unmask();
							    
								var data = response.responseText;
							
						     	var contentPanel =$this.getEditcoursesectiongroupstructure().up('tabpanel');//get hold of the content panel where we are adding all the tabs
								var tabName = getCourseTxCommonTranslation('EDIT_SECTION');
							    var tabDetail = contentPanel.items.items;
							        for(var i in tabDetail){
							        if(tabDetail[i].title==tabName){
							        tabDetail[i].close();
							        }
							        }
								
								
								
								/* var tabName = getCourseTxCommonTranslation('EDIT_SECTION');
			                	// 'Academia.controller.coursetransaction.sectionmanagement.CourseSectionManagementController'
			                
			                   var getcontroller=this.getController('menu.CoreERPNavigationController');
			                	 
			                	 var getTab = null;
									for(var i =0 ;i<contentPanel.items.length;i++){
										if(contentPanel.items.items[i].title ==tabName ){
											getTab= contentPanel.items.items[i];
										}
									}
			                
			                	 if(getTab!=null){
			                		 contentPanel.remove(true);
			                	 }*/
							    var detailedgrid = $this.getManagecoursesectiondetailedviewgrid();   
							    detailedgrid.getStore().load();
								showSuccessMessage(getCourseTxCommonTranslation('SECTION'),getCourseTxCommonTranslation('SECTION_UPDATED_SUCCESSFULLY'));
								
								
							}
						});
						grid.getView().refreshView();
						Ext.getBody().unmask();
					}else{
						Ext.getBody().unmask();
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
					}

				},
				resetEditCourseSectionGridItems:function(button){
					this.openEditCourseSectionGroupForm()
				},
				manageCourseSectionSummaryView: function(gridReference,permissionsMap) {
					var associatedAcadLocationIds = new Array();
					associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
					var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
					var addsectionButton = gridReference.down('#addSection');
					addsectionButton.setVisible(false);
					var mapProgramPeriodButton = gridReference.down('#mapProgramPeriod');
					mapProgramPeriodButton.setVisible(false);

					buttonsToolBar = gridReference.query('toolbar')[0];

					var buttons = buttonsToolBar.query('button');
					Ext.each(buttons, function(button) {
						button.setVisible(false);
					});

					Ext.each(permissionList, function(privilege) {
						if (privilege === 'ADD_SECTION') {
							if(!isNullOrEmpty(addsectionButton)){
								addsectionButton.setVisible(true);
							}        		
						}
						if (privilege === 'MAP_PROGRAM_PERIOD') {
							if(!isNullOrEmpty(mapProgramPeriodButton)){
								mapProgramPeriodButton.setVisible(true);
							}        		
						}
						if (privilege === 'EXPORT') {
							var buttonsArray = new Array();
							buttonsArray.push(buttonsToolBar.query('#btnExportToPDF')[0]);
							buttonsArray.push(buttonsToolBar.query('#btnExportToExcel')[0]);
							Ext.each(buttonsArray, function(button) {
								if(!isNullOrEmpty(button)){
									button.setVisible(true);
								}  
							});
						}
					});

				},
				manageCourseSectionDetailedView: function(gridReference,permissionsMap) {
					var associatedAcadLocationIds = new Array();
					associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
					var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
					var mapProgramPeriodButton = gridReference.down('#mapProgramPeriod');
					mapProgramPeriodButton.setVisible(false);
					
					var addFacultyButton = gridReference.down('#addFaculty');
					addFacultyButton.setVisible(false);
					
					
					var studentEnrollmentButton = gridReference.down('#studentEnrollmentBtn');
					studentEnrollmentButton.setVisible(false);
					
					var courseEnrollmentButton = gridReference.down('#courseEnrollmentBtn');
					courseEnrollmentButton.setVisible(false);


					buttonsToolBar = gridReference.query('toolbar')[0];

					var buttons = buttonsToolBar.query('button');
					Ext.each(buttons, function(button) {
						button.setVisible(false);
					});

					Ext.each(permissionList, function(privilege) {
						if (privilege === 'MAP_PROGRAM_PERIOD') {
							if(!isNullOrEmpty(mapProgramPeriodButton)){
								mapProgramPeriodButton.setVisible(true);
							}        		
						}

						if (privilege === 'UPDATE') {
							var button = buttonsToolBar.query('#btnEdit')[0];
							if(!isNullOrEmpty(button)){
								button.setVisible(true);
							}  
						} 

						if (privilege === 'DELETE') {
							var button = buttonsToolBar.query('#btnDelete')[0];
							if(!isNullOrEmpty(button)){
								button.setVisible(true);
							}  
						}

						if (privilege === 'EXPORT') {
							var buttonsArray = new Array();
							buttonsArray.push(buttonsToolBar.query('#btnExportToPDF')[0]);
							buttonsArray.push(buttonsToolBar.query('#btnExportToExcel')[0]);
							Ext.each(buttonsArray, function(button) {
								if(!isNullOrEmpty(button)){
									button.setVisible(true);
								}  
							});
						}

						if (privilege === 'ADD_FACULTY') {
							if(!isNullOrEmpty(addFacultyButton)){
								addFacultyButton.setVisible(true);
							}        		
						}
						
						if (privilege === 'STUDENT_ENROLLMENT') {
							if(!isNullOrEmpty(studentEnrollmentButton)){
								studentEnrollmentButton.setVisible(true);
							}        		
						}
						
						if (privilege === 'COURSE_ENROLLMENT') {
							if(!isNullOrEmpty(courseEnrollmentButton)){
								courseEnrollmentButton.setVisible(true);
							}        		
						}
						
						
					});

				},
				createNewCourseSection: function() {
					var me = this;
					var contentpanel = me.getContentPanel();
					var courseSectionForm = Ext.widget('createcoursesectionform');
					var tabName = getProgramandcourseTranslation('CREATE_SECTION');
					var getcontroller=me.getController('menu.CoreERPNavigationController');
					var getTab = null;
					for(var i =0 ;i<contentPanel.items.length;i++){
						if(contentPanel.items.items[i].title == tabName){
							getTab= contentPanel.items.items[i];
						}
					}
					if(getTab!=null){
						contentPanel.remove(getTab, true);
					}
					openTab(contentpanel, tabName, courseSectionForm,CONSTANTS.MENU_COLOR_THREE);

				},
				addMorePreDefinedDetailed : function(){
					var $this = this;
					var form = $this.getCreatecoursesectionform();
					var panelContiner = form.down('#preDefinedPanelId');
					var panelItem = new Array();
					panelItem.push({
						style:{marginLeft:'0px',marginTop:'0px'},
						xtype : 'fieldcontainer',
						layout : 'hbox',
						defaults : {
							labelAlign : 'top',
							width:256
						},
						layout : {
							type : 'hbox'
						},
						items:[{
							xtype: 'customcombobox',
							name: 'preDefinedSection',
							itemId:'preDefinedSectionId',
							store:Ext.create('Academia.store.coursetransaction.sectionmanagement.SectionMasterStore'),
							displayField:'code',
							valueField:'id',
							allowBlank:false,
							typeAhead:true,
							forceSelection:true,
							listeners:{
								afterrender: function(obj, rec,value){
		    						 var store = obj.getStore();
		    						 var values = $this.getCreatecoursesectionform().getForm().getValues();
		    						 var cleanSections = Ext.Array.clean(values.preDefinedSection);
		    						 var expectIds;
		            					if(cleanSections.length > 0){
		            						expectIds = cleanSections.join();
		            					}else{
		            						expectIds = cleanSections;
		            					}
		    						 store.getProxy().extraParams = {
		    							 expectIds:expectIds
		    						 };
		    						 store.load();
		    					 },
							select: function(obj, rec,value) {
		        				   var sectionName = rec[0].get("value");
		        				   var sectionCode = rec[0].get("code");
		        				   obj.nextSibling().setValue(sectionCode);
		        				   obj.nextSibling().nextSibling().setValue(sectionName);
		        			   }
							}
						},{
							xtype: 'textfield',
							name: 'preDefinedSectionCode',
							itemId: 'preDefinedSectionCodeId',
							fieldLabel: getProgramandcourseTranslation('SECTION_PRINT_NAME'),
							readOnly:true,
							hidden:true
						},{
							xtype: 'textfield',
							name: 'preDefinedSectionPrintName',
							itemId:'preDefinedSectionPrintNameId',
							readOnly:true
						},{
							xtype: 'customcombobox',
							width:256,
//							name: 'assignHomeRoom',
							name: 'preDefinedAssignHomeRoom',
                            itemId: 'preDefinedAssignHomeRoomId',
							store:Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.ClassRoom'),
							displayField:'value',
							valueField:'id',
							typeAhead:true,
							forceSelection:true,
							allowBlank:true,
							editable:false
						},{
						
							xtype: 'numberfield',
							name: 'preDefinedMaxCapacity',
							minValue:1,
							hideTrigger:true,
							maxValue : 5000,
							hideTrigger:true,
							allowExponential:false,
							allowDecimals:false
						},{
                                                      xtype: 'customcombobox',
                                                      itemId: 'facultyNameItemId',
                                                      name: 'facultyId',
                                                      store: 'coursetransaction.sectionmanagement.AssignClassTeacherSmartSearch',
                                                      valueField: 'id',
                                                      displayField: 'value',
                                                      queryParam: 'nameOrCode',
                                                      minChars: 3,
                                                      typeAhead: false,
                                                      triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
                                                      hideTrigger: false,
                                                      emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                                                      triggerAction: '',
                                                      forceSelection: true,
                                                      listConfig: {
                                                          listeners: {
                                                               beforeshow: function(picker) {
                                                                       picker.minWidth = picker.up('combobox').getSize().width;
                                                                       }
                                                          },
                                                          loadingText: getCommonTranslation('SEARCHING'),
                                                          emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                                                          getInnerTpl: function() {
                                                          return '<div class="search-item">{value}</div>';
                                                          }
                                                      },
                                                      listeners: {
                                                          select: function(combo, records) {
                                                                 var selectedFacultyId = records && records[0] ? records[0].get('id') : null;
                                                                  // ✅ Get the next sibling (Alternate Class Teacher)
                                                                  var alternateCombo = combo.nextSibling('customcombobox[itemId=alternateNameItemId]');
                                                                  if (alternateCombo) {
                                                                           var alternateVal = alternateCombo.getValue();
                                                                            // ❌ If both same, alert & reset
                                                                            if (alternateVal && alternateVal === selectedFacultyId) {
                                                                            showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CLASS_TEACHER_CANNOT_BE_SAME_AS_ALTERNATE_CLASS_TEACHER'));
                                                                            combo.reset();
                                                                            return;
                                                                            }

                                                                      // ✅ Update store params (if needed)
                                                                      var store = alternateCombo.getStore();
                                                                      store.getProxy().extraParams = store.getProxy().extraParams || {};
                                                                      if (selectedFacultyId) {
                                                                            store.getProxy().extraParams.facultyId = selectedFacultyId;
                                                                      } else {
                                                                        delete store.getProxy().extraParams.facultyId;
                                                                      }

                                                                          // Optionally reload store
                                                                         store.load({
                                                                          params: { facultyId: selectedFacultyId }
                                                                          });
                                                                  }
                                                          },
                                                          change: function(combo, newValue) {
                                                                  var alternateCombo = combo.nextSibling('customcombobox[itemId=alternateNameItemId]');
                                                                  if (!newValue && alternateCombo) {
                                                                            var store = alternateCombo.getStore();
                                                                                   if (store && store.getProxy && store.getProxy().extraParams) {
                                                                                           delete store.getProxy().extraParams.facultyId;
                                                                                   }
                                                                                   alternateCombo.reset();
                                                                                   store.removeAll();
                                                                  }
                                                          }
                                                      }
                                                  },{
                                                       xtype: 'customcombobox',
                                                       itemId: 'alternateNameItemId',
                                                       name: 'alternateId',
                                                       store: 'coursetransaction.sectionmanagement.AssignClassTeacherSmartSearch',
                                                       valueField: 'id',
                                                       displayField: 'value',
                                                       queryParam: 'nameOrCode',
                                                       minChars: 3,
                                                       typeAhead: true,
                                                       triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
                                                       hideTrigger: false,
                                                       emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                                                       triggerAction: '',
                                                       forceSelection: true,
                                                       beforeBlur: function() {
                                                                 var value = this.getRawValue();
                                                                 if (value == '') {
                                                                         this.lastSelection = [];
                                                                 }
                                                                 this.doQueryTask.cancel();
                                                                 this.assertValue();
                                                       },
                                                       listConfig: {
                                                             listeners: {
                                                                  beforeshow: function(picker) {
                                                                         picker.minWidth = picker.up('combobox').getSize().width;
                                                                  }
                                                             },
                                                             loadingText: getCommonTranslation('SEARCHING'),
                                                             emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                                                             getInnerTpl: function() {
                                                                     return '<div class="search-item">{value}</div>';
                                                             }
                                                       },
                                                       listeners: {
                                                             select: function(combo, records) {
                                                                   var selectedAlternateId = records && records[0] ? records[0].get('id') : null;

                                                                   // ✅ Get previous sibling (Class Teacher)
                                                                   var facultyCombo = combo.previousSibling('customcombobox[itemId=facultyNameItemId]');
                                                                   if (facultyCombo) {
                                                                            var facultyVal = facultyCombo.getValue();
                                                                              // ❌ If same teacher, show alert and reset alternate
                                                                            if (facultyVal && facultyVal === selectedAlternateId) {
                                                                                  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CLASS_TEACHER_CANNOT_BE_SAME_AS_ALTERNATE_CLASS_TEACHER'));
                                                                                  combo.reset();
                                                                                  return;
                                                                            }
                                                                   }
                                                             }
                                                       }
                                                  }
                           ,{
							xtype: 'button',
							glyph: ICONGLYPH.DELETEGLYPH,
							itemId: 'preDefinedDetailedDeleteBtn1',
							width: 'auto',
							cls: 'CustomBodyBtnReject',
							tooltip: getCommonTranslation('DELETETOOLTIP'),
							listeners:{
								click:function(obj){
									var container = obj.up('fieldcontainer');
									var check = $this.getCreatecoursesectionform().getForm().isValid();
									if(check){
										$this.getCreatecoursesectionform().down('#programFormSubmitButtonId').setDisabled(false);
									}
								}
							}
						},{
							xtype: 'button',
							itemId: 'preDefinedDetailedBtn1',
							width: 'auto',
							cls: 'CustomBodyBtnSettings',
							width: 'auto',
							text: getCommonTranslation('ADDBUTTONTEXT'),
							tooltip: getCommonTranslation('ADD'),
							padding: '5 3'
						}]
					});
					panelContiner.add(panelItem);
					this.hideShowDetails(panelContiner);
					panelContiner.doLayout();
				},
				addMoreUsrDefinedDetailed : function(){
					var $this = this;
					var form = $this.getCreatecoursesectionform();
					var panelContiner = form.down('#usrDefinedPanelId');
					var panelItem = new Array();
					panelItem.push({
						style:{marginLeft:'0px',marginTop:'0px'},
						xtype : 'fieldcontainer',
						layout : 'hbox',
						defaults : {
							labelAlign : 'top',
							width:256
						},
						layout : {
							type : 'hbox'
						},
						items:[{
							xtype: 'textfield',
							name: 'usrDefinedSectionName',
							itemId: 'usrDefinedSectionNameId',
							allowBlank:false
						},{
							xtype: 'textfield',
							name: 'usrDefinedSectionPrintName',
							itemId: 'usrDefinedSectionPrintNameId',
						},{
							xtype: 'customcombobox',
							width:256,
							name: 'usrDefinedAssignHomeRoom',
							itemId: 'usrDefinedAssignHomeRoomId',
							store:Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.ClassRoom'),
							displayField:'value',
							valueField:'id',
							typeAhead:true,
							forceSelection:true,
							allowBlank:true,
							editable:false
						},{
							xtype: 'numberfield',
							name: 'usrDefinedMaxCapacity',
							itemId:'usrDefinedMaxCapacity_id',
							minValue:1,
							hideTrigger:true,
							maxValue : 5000,
							hideTrigger:true,
							allowExponential:false,
							allowDecimals:false
						},{
                            xtype: 'customcombobox',
                            itemId: 'facultyNameItemId',
                            name: 'facultyId',
                            store: 'coursetransaction.sectionmanagement.AssignClassTeacherSmartSearch',
                            valueField: 'id',
                            displayField: 'value',
                            queryParam: 'nameOrCode',
                            minChars: 3,
                            typeAhead: false,
                            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
                            hideTrigger: false,
                            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                            triggerAction: '',
                            forceSelection: true,
                            listConfig: {
                                listeners: {
                                     beforeshow: function(picker) {
                                             picker.minWidth = picker.up('combobox').getSize().width;
                                             }
                                },
                                loadingText: getCommonTranslation('SEARCHING'),
                                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                                getInnerTpl: function() {
                                return '<div class="search-item">{value}</div>';
                                }
                            },
                            listeners: {
                                select: function(combo, records) {
                                       var selectedFacultyId = records && records[0] ? records[0].get('id') : null;
                                        // ✅ Get the next sibling (Alternate Class Teacher)
                                        var alternateCombo = combo.nextSibling('customcombobox[itemId=alternateNameItemId]');
                                        if (alternateCombo) {
                                                 var alternateVal = alternateCombo.getValue();
                                                  // ❌ If both same, alert & reset
                                                  if (alternateVal && alternateVal === selectedFacultyId) {
                                                  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CLASS_TEACHER_CANNOT_BE_SAME_AS_ALTERNATE_CLASS_TEACHER'));
                                                  combo.reset();
                                                  return;
                                                  }

                                            // ✅ Update store params (if needed)
                                            var store = alternateCombo.getStore();
                                            store.getProxy().extraParams = store.getProxy().extraParams || {};
                                            if (selectedFacultyId) {
                                                  store.getProxy().extraParams.facultyId = selectedFacultyId;
                                            } else {
                                              delete store.getProxy().extraParams.facultyId;
                                            }

                                                // Optionally reload store
                                               store.load({
                                                params: { facultyId: selectedFacultyId }
                                                });
                                        }
                                },
                                change: function(combo, newValue) {
                                        var alternateCombo = combo.nextSibling('customcombobox[itemId=alternateNameItemId]');
                                        if (!newValue && alternateCombo) {
                                                  var store = alternateCombo.getStore();
                                                         if (store && store.getProxy && store.getProxy().extraParams) {
                                                                 delete store.getProxy().extraParams.facultyId;
                                                         }
                                                         alternateCombo.reset();
                                                         store.removeAll();
                                        }
                                }
                            }
                        },{
                             xtype: 'customcombobox',
                             itemId: 'alternateNameItemId',
                             name: 'alternateId',
                             store: 'coursetransaction.sectionmanagement.AssignClassTeacherSmartSearch',
                             valueField: 'id',
                             displayField: 'value',
                             queryParam: 'nameOrCode',
                             minChars: 3,
                             typeAhead: true,
                             triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
                             hideTrigger: false,
                             emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                             triggerAction: '',
                             forceSelection: true,
                             beforeBlur: function() {
                                       var value = this.getRawValue();
                                       if (value == '') {
                                               this.lastSelection = [];
                                       }
                                       this.doQueryTask.cancel();
                                       this.assertValue();
                             },
                             listConfig: {
                                   listeners: {
                                        beforeshow: function(picker) {
                                               picker.minWidth = picker.up('combobox').getSize().width;
                                        }
                                   },
                                   loadingText: getCommonTranslation('SEARCHING'),
                                   emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                                   getInnerTpl: function() {
                                           return '<div class="search-item">{value}</div>';
                                   }
                             },
                             listeners: {
                                   select: function(combo, records) {
                                         var selectedAlternateId = records && records[0] ? records[0].get('id') : null;

                                         // ✅ Get previous sibling (Class Teacher)
                                         var facultyCombo = combo.previousSibling('customcombobox[itemId=facultyNameItemId]');
                                         if (facultyCombo) {
                                                  var facultyVal = facultyCombo.getValue();
                                                    // ❌ If same teacher, show alert and reset alternate
                                                  if (facultyVal && facultyVal === selectedAlternateId) {
                                                        showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CLASS_TEACHER_CANNOT_BE_SAME_AS_ALTERNATE_CLASS_TEACHER'));
                                                        combo.reset();
                                                        return;
                                                  }
                                         }
                                   }
                             }
                        }

                        ,{
							xtype: 'button',
							glyph: ICONGLYPH.DELETEGLYPH,
							itemId: 'usrDefinedDetailedDeleteBtn1',
							width: 'auto',
							cls: 'CustomBodyBtnReject',
							tooltip: getCommonTranslation('DELETETOOLTIP'),
							listeners:{
								click:function(obj){
									var container = obj.up('fieldcontainer');
									var check = $this.getCreatecoursesectionform().getForm().isValid();
									if(check){
										$this.getCreatecoursesectionform().down('#programFormSubmitButtonId').setDisabled(false);
									}
								}
							}
						},{
							xtype: 'button',
							itemId: 'usrDefinedDetailedBtn1',
							width: 'auto',
							cls: 'CustomBodyBtnSettings',
							width: 'auto',
							text: getCommonTranslation('ADDBUTTONTEXT'),
							tooltip: getCommonTranslation('ADD'),
							padding: '5 3'
						}]
					});
					panelContiner.add(panelItem);
					this.hideShowDetails(panelContiner);
					panelContiner.doLayout();
				},
				preDefinedDeleteMoreDetailed: function(deleteButton) {
					var this$ = this;
					var form = this.getCreatecoursesectionform();
					var preDefinedPanel = form.down('#preDefinedPanelId');
					var container = deleteButton.up('fieldcontainer');

					if (container != null && preDefinedPanel != null) {
						if (preDefinedPanel.items.length > 1) {
						    container.items.items[0].reset();
		        			container.items.items[0].allowBlank=true;
		        			container.items.items[0].validate();
							preDefinedPanel.remove(container);
							this.hideShowDetails(preDefinedPanel);
						}
					}
				},
				usrDefinedDeleteMoreDetailed: function(deleteButton) {
					var this$ = this;
					var form = this.getCreatecoursesectionform();
					var usrDefinedPanel = form.down('#usrDefinedPanelId');
					var container = deleteButton.up('fieldcontainer');

					if (container != null && usrDefinedPanel != null) {
						if (usrDefinedPanel.items.length > 1) {
						    container.items.items[0].reset();
		        			container.items.items[0].allowBlank=true;
		        			container.items.items[0].validate();
							usrDefinedPanel.remove(container);
							this.hideShowDetails(usrDefinedPanel);
						}
					}
				},
				hideShowDetails: function(detailedPanel) {
					var this$ = this;
					detailedPanel.items.each(function(item, index, items) {
						var addButton = item.getComponent(item.items.length - 1);
						if (index == (items - 1)) {
							if (addButton != null) {
								addButton.show();
							}
						} else {
							if (addButton != null) {
								addButton.hide();
							}
						}
					});
				},
				createCourseSectionRadioOption : function(val,nV,oV){
					var this$ = this;
					var form = this.getCreatecoursesectionform();
					var preDefinedPanelObj = form.down("#preDefinedPanelId");
					var usrDefinedPanelObj = form.down("#usrDefinedPanelId");
					var preDefinedSectionIdFields = Ext.ComponentQuery.query('#preDefinedSectionId');
					var usrDefinedSectionNameIdFields = Ext.ComponentQuery.query('#usrDefinedSectionNameId');	
					if(nV.definedSection==true){
						preDefinedPanelObj.setVisible(true);
						preDefinedPanelObj.setDisabled(false);
						usrDefinedPanelObj.setVisible(false);
						usrDefinedPanelObj.setDisabled(true);
						Ext.each(preDefinedSectionIdFields , function(currentPreField){
							this$.setAllowBlank(currentPreField, false);
						});
						Ext.each(usrDefinedSectionNameIdFields , function(currentUserField){
							this$.setAllowBlank(currentUserField, true);
						});
					}else if(nV.definedSection==false){
						preDefinedPanelObj.setVisible(false);
						preDefinedPanelObj.setDisabled(true);
						usrDefinedPanelObj.setVisible(true);
						usrDefinedPanelObj.setDisabled(false);
						Ext.each(preDefinedSectionIdFields , function(currentPreField){
							this$.setAllowBlank(currentPreField, true);
						});
						Ext.each(usrDefinedSectionNameIdFields , function(currentUserField){
							this$.setAllowBlank(currentUserField, false);
						});
					}
					form.getForm().isValid();
					form.getForm().clearInvalid();
				},
				getOpenSectionSearchData : function(){
					var form=this.getOpensectionsearch();
					form.down('#searchBtn').setDisabled(true);
					var aLId = this.getCurrentAcademyLocation();
					var departmentId = form.down('#courseDepartment').getValue();
					var academicTermId = form.down('#academicTerm').getValue();
					var subDeptId = form.down('#courseSubDepartment').getValue();
					var courseCategory = form.down('#courseCategory').getValue();
					var courseRecord = form.down('#courseSectionId').getValue();
					var sectionRecord = form.down('#openWiseSectionId').getValue();
					var courseMarksGrade = form.down('#courseMarksGrades_id').getValue();
					var academyLocationId = form.down('#academyLocation').getValue();
					
					var courseMarksGradeVal;
					if(courseMarksGrade=="GRADE"){
						courseMarksGradeVal="G";
					}else{
						courseMarksGradeVal="M";
					}
					var courseWithoutSection = form.down('#programWiseCheckBoxId').getValue();
					var courseIds = [];
					if(!isNullOrEmpty(courseRecord)) {
						Ext.each(courseRecord,function(course){
							if(typeof course=="number"){
								courseIds.push(course);
							}else if(!isNullOrEmpty(course.data)){
								courseIds.push(course.data.id);
							}
						});
					}
					var sectionIds = [];
					if(!isNullOrEmpty(sectionRecord)) {
						Ext.each(sectionRecord,function(section){
							if(typeof course=="number"){
								sectionIds.push(section);
							}else if(!isNullOrEmpty(section.data)){
								sectionIds.push(section.data.id);
							}
						});
					}
					var grid = this.getManagecoursesectionsummaryviewgrid();
					var store = grid.getStore();
					store.getProxy().extraParams = {
						academyLocationIds : academyLocationId,
						academicTermId : academicTermId,
						departmentId : departmentId,
						subDeptId : subDeptId,
						courseCategory : courseCategory,
						courseIds : courseIds.join(),
						courseWithoutSection : courseWithoutSection,
						courseMarksGrade : courseMarksGradeVal,
						sectionIds : sectionIds.join(),
						isOpenSection:true
					};
					store.load({
						callback: function(records, operation, success) {
								form.down('#searchBtn').setDisabled(false);
							}
					});
					grid.config.searchFilterForm = form;
				},
				getProgramWiseSectionSearchData : function(){
					var $this = this;
					var form = $this.getProgramwisesectionsearch();
					form.down('#searchBtn').setDisabled(true);
					var aLId = $this.getCurrentAcademyLocation();
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var wheatherSchool = alinfomodel.get('wheatherSchool');
					var academicTermId = form.down('#programWiseAcademicTermId').getValue();
					var batchRecord = form.down('#programWiseProgramId').getValue();
					var periodRecord = form.down('#programWisePeriodId').getValue();
					var courseRecord = form.down('#programWiseCourseId').getValue();
					var courseWithoutSection = form.down('#programWiseCheckBoxId').getValue();
					var courseMarksGrade = form.down('#programWiseCourseMarkGrade_id').getValue();
					var academyLocationId = form.down('#academyLocation').getValue();
					var sectionRecord = form.down('#programWiseSectionId').getValue();
					var courseMarksGradeVal;
					if(courseMarksGrade=="GRADE"){
						courseMarksGradeVal="G";
					}else{
						courseMarksGradeVal="M";
					}
					var batchIds = [];
					if(!isNullOrEmpty(batchRecord)) {
						Ext.each(batchRecord,function(batch){
							if(typeof batch=="number"){
								batchIds.push(batch);
							}else if(!isNullOrEmpty(batch.data)){
								batchIds.push(batch.data.id);
							}
						});
					}
					var periodIds = [];
					if(!isNullOrEmpty(periodRecord)) {
						Ext.each(periodRecord,function(period){
							if(typeof period=="number"){
								periodIds.push(period);
							}else if(!isNullOrEmpty(period.data)){
								periodIds.push(period.data.id);
							}
						});
					}
					var courseIds = [];
					if(!isNullOrEmpty(courseRecord)) {
						Ext.each(courseRecord,function(course){
							if(typeof course=="number"){
								courseIds.push(course);
							}else if(!isNullOrEmpty(course.data)){
								courseIds.push(course.data.id);
							}
						});
					}
					var sectionIds = [];
					if(!isNullOrEmpty(sectionRecord)) {
						Ext.each(sectionRecord,function(section){
							if(typeof section=="number"){
								sectionIds.push(section);
							}else if(!isNullOrEmpty(section.data)){
								sectionIds.push(section.data.id);
							}
						});
					}
					var grid = this.getManagecoursesectionsummaryviewgrid();
					var store = grid.getStore();
					store.getProxy().extraParams = {
						academyLocationIds : academyLocationId,
						academicTermId : academicTermId,
						batchIds : batchIds.join(),
						periodIds : periodIds.join(),
						courseIds : courseIds.join(),
						wheatherSchool : wheatherSchool,
						courseWithoutSection : courseWithoutSection,
						courseMarksGrade:courseMarksGradeVal,
						sectionIds : sectionIds.join()
					};
					store.load({
						callback: function(records, operation, success) {
								form.down('#searchBtn').setDisabled(false);
							}
					});
					grid.config.searchFilterForm = form;
				}, 
				/*getProgramWiseSectionDetailViewSearchData : function(){
					var $this = this;
					var aLId = $this.getCurrentAcademyLocation();
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var wheatherSchool = alinfomodel.get('wheatherSchool');
					var structure = this.getCoursesectionmanagementstructure();
					var radiogroupValue = structure.down('#sectionTypeRadio').getValue();
					var detailedgrid = this.getManagecoursesectiondetailedviewgrid();
					var detailedStore = detailedgrid.getStore();
					// ✅ Initialize pagination toolbar after store load
					var pagingToolbar = detailedgrid.down('pagingtoolbar');

					// ✅ Initialize paging toolbar dynamically on search click
					var pagingToolbar = detailedgrid.down('pagingtoolbar');
					if (pagingToolbar) {
					    pagingToolbar.bindStore(detailedStore, true);

					    // when data is loaded, refresh toolbar counts/buttons
					    detailedStore.on('load', function() {
					        pagingToolbar.onLoad();
					    }, this, { single: true });

					} else {
					    // grid not rendered yet? wait for it to render once, then bind
					    detailedgrid.on('afterlayout', function() {
					        var ptb = detailedgrid.down('pagingtoolbar');
					        if (ptb) {
					            ptb.bindStore(detailedStore, true);
					            ptb.onLoad();
					        }
					    }, this, { single: true });
					}


					if(radiogroupValue.sectionType=='PROGRAM_WISE_SECTION'){
						var form = $this.getProgramwisesectionsearch();
						form.down('#searchBtn').setDisabled(true);
						var academicTermId = form.down('#programWiseAcademicTermId').getValue();
						var batchRecord = form.down('#programWiseProgramId').getValue();
						var periodRecord = form.down('#programWisePeriodId').getValue();
						var courseRecord = form.down('#programWiseCourseId').getValue();
						var courseWithoutSection = form.down('#programWiseCheckBoxId').getValue();
						var academyLocationId = form.down('#academyLocation').getValue();
						var sectionRecord = form.down('#programWiseSectionId').getValue();
						var batchIds = [];
						if(!isNullOrEmpty(batchRecord)) {
							Ext.each(batchRecord,function(batch){
								if(typeof batch=="number"){
									batchIds.push(batch);
								}else if(!isNullOrEmpty(batch.data)){
									batchIds.push(batch.data.id);
								}
							});
						}
						var periodIds = [];
						if(!isNullOrEmpty(periodRecord)) {
							Ext.each(periodRecord,function(period){
								if(typeof period=="number"){
									periodIds.push(period);
								}else if(!isNullOrEmpty(period.data)){
									periodIds.push(period.data.id);
								}
							});
						}
						var courseIds = [];
						if(!isNullOrEmpty(courseRecord)) {
							Ext.each(courseRecord,function(course){
								if(typeof course=="number"){
									courseIds.push(course);
								}else if(!isNullOrEmpty(course.data)){
									courseIds.push(course.data.id);
								}
							});
						}
						var sectionIds = [];
						if(!isNullOrEmpty(sectionRecord)) {
							Ext.each(sectionRecord,function(section){
								if(typeof section=="number"){
									sectionIds.push(section);
								}else if(!isNullOrEmpty(section.data)){
									sectionIds.push(section.data.id);
								}
							});
						}
						detailedStore.getProxy().extraParams = {
							academyLocationIds : academyLocationId,
							academicTermId : academicTermId,
							batchIds : batchIds.join(),
							periodIds : periodIds.join(),
							courseIds : courseIds.join(),
							courseWithoutSection : courseWithoutSection,
							sectionIds : sectionIds.join()
						};
						detailedStore.load();
						detailedgrid.config.searchFilterForm = form;
					}else{
						var form=this.getOpensectionsearch();
						form.down('#searchBtn').setDisabled(true);
						var departmentId = form.down('#courseDepartment').getValue();
						var academicTermId = form.down('#academicTerm').getValue();
						var subDeptId = form.down('#courseSubDepartment').getValue();
						var courseCategory = form.down('#courseCategory').getValue();
						var courseRecord = form.down('#courseSectionId').getValue();
						var sectionRecord = form.down('#openWiseSectionId').getValue();
						var courseMarksGrade = form.down('#courseMarksGrades_id').getValue();
						var academyLocationId = form.down('#academyLocation').getValue();
						var courseMarksGradeVal;
						if(courseMarksGrade=="GRADE"){
							courseMarksGradeVal="G";
						}else{
							courseMarksGradeVal="M";
						}
						var courseWithoutSection = form.down('#programWiseCheckBoxId').getValue();
						var courseIds = [];
						if(!isNullOrEmpty(courseRecord)) {
							Ext.each(courseRecord,function(course){
								if(typeof course=="number"){
									courseIds.push(course);
								}else if(!isNullOrEmpty(course.data)){
									courseIds.push(course.data.id);
								}
							});
						}
						var sectionIds = [];
						if(!isNullOrEmpty(sectionRecord)) {
							Ext.each(sectionRecord,function(section){
								if(typeof course=="number"){
									sectionIds.push(section);
								}else if(!isNullOrEmpty(section.data)){
									sectionIds.push(section.data.id);
								}
							});
						}
						detailedStore.getProxy().extraParams = {
							academyLocationIds : academyLocationId,
							academicTermId : academicTermId,
							departmentId : departmentId,
							subDeptId : subDeptId,
							courseCategory : courseCategory,
							courseIds : courseIds.join(),
							courseWithoutSection : courseWithoutSection,
							courseMarksGrade : courseMarksGradeVal,
							sectionIds : sectionIds.join()
						};
						detailedStore.load();
						detailedgrid.config.searchFilterForm = form;
					}
				},*/
				
				getProgramWiseSectionDetailViewSearchData: function() {
				    var me = this;
				    var structure = me.getCoursesectionmanagementstructure();
				    var radiogroupValue = structure.down('#sectionTypeRadio').getValue();

				    // ✅ Always initialize detailed grid on search click
				    var detailedGrid = me.getManagecoursesectiondetailedviewgrid();

				    // if grid not created yet, delay until after render
				    if (!detailedGrid || !detailedGrid.rendered) {
				        detailedGrid.on('afterrender', function() {
				            me.getProgramWiseSectionDetailViewSearchData();
				        }, me, { single: true });
				        return;
				    }

				    var detailedStore = detailedGrid.getStore();

				    // 🧠 Determine which tab’s data to load based on sectionType
				    if (radiogroupValue.sectionType == 'PROGRAM_WISE_SECTION') {
				        me.loadProgramWiseSectionDetails(detailedStore, detailedGrid);
				    } else {
				        me.loadOpenSectionDetails(detailedStore, detailedGrid);
				    }

				    // ✅ Optional: load both grids if you have 2 detailed view tabs
				    // me.loadProgramWiseSectionDetails(...);
				    // me.loadOpenSectionDetails(...);
				},
				
				loadProgramWiseSectionDetails: function(detailedStore, detailedGrid) {
				    var me = this;
				    var form = me.getProgramwisesectionsearch();
				    form.down('#searchBtn').setDisabled(true);

				    // Collect params (same as your code)
				    var academicTermId = form.down('#programWiseAcademicTermId').getValue();
				    var batchRecord = form.down('#programWiseProgramId').getValue();
				    var periodRecord = form.down('#programWisePeriodId').getValue();
				    var courseRecord = form.down('#programWiseCourseId').getValue();
				    var courseWithoutSection = form.down('#programWiseCheckBoxId').getValue();
				    var academyLocationId = form.down('#academyLocation').getValue();
				    var sectionRecord = form.down('#programWiseSectionId').getValue();

				    var batchIds = me.extractIds(batchRecord);
				    var periodIds = me.extractIds(periodRecord);
				    var courseIds = me.extractIds(courseRecord);
				    var sectionIds = me.extractIds(sectionRecord);

				    detailedStore.getProxy().extraParams = {
				        academyLocationIds: academyLocationId,
				        academicTermId: academicTermId,
				        batchIds: batchIds.join(),
				        periodIds: periodIds.join(),
				        courseIds: courseIds.join(),
				        courseWithoutSection: courseWithoutSection,
				        sectionIds: sectionIds.join()
				    };

				    detailedStore.loadPage(1, {
				        callback: function() {
				            var toolbar = detailedGrid.down('pagingtoolbar');
				            if (toolbar) {
				                toolbar.bindStore(detailedStore, true);
				                toolbar.onLoad();
				            }
				            form.down('#searchBtn').setDisabled(false);
				        }
				    });
				},

				loadOpenSectionDetails: function(detailedStore, detailedGrid) {
				    var me = this;
				    var form = me.getOpensectionsearch();
				    form.down('#searchBtn').setDisabled(true);

				    var departmentId = form.down('#courseDepartment').getValue();
				    var academicTermId = form.down('#academicTerm').getValue();
				    var subDeptId = form.down('#courseSubDepartment').getValue();
				    var courseCategory = form.down('#courseCategory').getValue();
				    var courseRecord = form.down('#courseSectionId').getValue();
				    var sectionRecord = form.down('#openWiseSectionId').getValue();
				    var courseMarksGrade = form.down('#courseMarksGrades_id').getValue();
				    var academyLocationId = form.down('#academyLocation').getValue();

				    var courseMarksGradeVal = (courseMarksGrade == "GRADE") ? "G" : "M";
				    var courseWithoutSection = form.down('#programWiseCheckBoxId').getValue();

				    var courseIds = me.extractIds(courseRecord);
				    var sectionIds = me.extractIds(sectionRecord);

				    detailedStore.getProxy().extraParams = {
				        academyLocationIds: academyLocationId,
				        academicTermId: academicTermId,
				        departmentId: departmentId,
				        subDeptId: subDeptId,
				        courseCategory: courseCategory,
				        courseIds: courseIds.join(),
				        courseWithoutSection: courseWithoutSection,
				        courseMarksGrade: courseMarksGradeVal,
				        sectionIds: sectionIds.join(),
						isOpenSection : true
				    };

				    detailedStore.loadPage(1, {
				        callback: function() {
				            var toolbar = detailedGrid.down('pagingtoolbar');
				            if (toolbar) {
				                toolbar.bindStore(detailedStore, true);
				                toolbar.onLoad();
				            }
				            form.down('#searchBtn').setDisabled(false);
				        }
				    });
				},

				extractIds: function(records) {
				    var ids = [];
				    if (!isNullOrEmpty(records)) {
				        Ext.each(records, function(item) {
				            if (typeof item === "number") {
				                ids.push(item);
				            } else if (!isNullOrEmpty(item.data)) {
				                ids.push(item.data.id);
				            }
				        });
				    }
				    return ids;
				},

				/*Open Add Mapping tab from Manage Course Section Grid Button*/
				openProgramBatchMappingTab: function(grid){
					var contentpanel = this.getContentPanel();
					var managecoursesectionaddmappingtab = Ext.widget('managecoursesectionaddmappingtab');
					var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
					var coursesectionmanagementstructure = this.getCoursesectionmanagementstructure();
					var sectionTypeRadio = coursesectionmanagementstructure.down('#sectionTypeRadio').getValue();
					var acdemicTermVal;
					var programBaseCourseGrade ;
					var programId ;
					var batchRecord ;
					var markGradeType;
					if(sectionTypeRadio.sectionType == "PROGRAM_WISE_SECTION"){
						acdemicTermVal = coursesectionmanagementstructure.down('#programWiseAcademicTermId').getValue();
						markGradeType= coursesectionmanagementstructure.down('#programWiseCourseMarkGrade_id').getValue();
					}
					else{
						acdemicTermVal = "";
						var form=this.getOpensectionsearch(); 
						var courseRecord = form.down('#courseSectionId').getValue();
						markGradeType = form.down('#courseMarksGrades_id').getValue();
						
					}
					if(markGradeType=="GRADE"){
						programBaseCourseGrade="G";
					}else{
						programBaseCourseGrade="M";
					}
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var whetherSchool = alinfomodel.get('wheatherSchool');
					var aLId = this.getCurrentAcademyLocation();
					var gridRec = grid.getSelectionModel().getSelection();
					managecoursesectionaddmappingtab.config.gridRecord = gridRec;
					managecoursesectionaddmappingtab.config.gridXtype = grid.xtype;
					managecoursesectionaddmappingtab.down('#academicTermId').setValue(acdemicTermVal);
					managecoursesectionaddmappingtab.down('#academyLocationId').setValue(aLId);
					managecoursesectionaddmappingtab.down('#whetherSchoolId').setValue(whetherSchool);

					var courseMarksGrades =gridRec[0].data.courseMarksGrades;
					var getcontroller=this.getController('menu.CoreERPNavigationController');
					var getTab=getcontroller.getTab(tabName);
					if(getTab!=null){
						contentpanel.remove(getTab, true);
					}
					openTab(contentpanel, tabName, managecoursesectionaddmappingtab,CONSTANTS.MENU_COLOR_THREE);

					var programBatchGrid = this.getManagecoursesectionaddprogramgrid();
					if(whetherSchool){
						var academyLocationName = programBatchGrid.down('[dataIndex=academyLocationName]');
						academyLocationName.hide();
					}
					 
					var programSearchCombo = programBatchGrid.down('#programsearchcombo');
					programSearchCombo.getStore().getProxy().extraParams= {
			    		academyLocationIds: aLId,
						academicTermId:acdemicTermVal,
						whetherSchool:whetherSchool,
						programBaseCourseGrade : programBaseCourseGrade
			    	};
					programSearchCombo.getStore().load();
					programBatchGrid.getStore().clearFilter();
					programBatchGrid.getStore().getProxy().extraParams= {
						academyLocationIds: aLId,
						academicTermId:acdemicTermVal,
						whetherSchool:whetherSchool,
						programBaseCourseGrade : programBaseCourseGrade
					};
					programBatchGrid.getStore().load();
					this.getAdjustmentprogresstracker().setVisible(true);
					this.resetProgressTracker();
					var adjustmentprogresstracker = managecoursesectionaddmappingtab.down("#adjustmentprogresstracker");
					var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
					progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
					progresstracker1.textEl.addCls("inProgressCss-progress-text");
					progresstracker1.updateText(getCommonTranslation('STEP_1_IN_PROGRESS'));
				},

				/*Function for Set Progress Bar on header*/
				setProgressTracker : function(progresstracker){
					var structure = this.getManagecoursesectionaddmappingtab();
					var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");

					var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
					var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
					var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");
					var progresstracker4 = adjustmentprogresstracker.down("#progresstracker4");

					if(progresstracker==1){
						for(var i = 0; i < 11; i ++ ){
							progresstracker1.updateProgress((i * 0.1), '');
						}
						progresstracker1.textEl.addCls("custom-progress-text");
						progresstracker1.textEl.removeCls("inProgressCss-progress-text");
						progresstracker2.textEl.removeCls("x-progress-text x-progress-text-back");
						progresstracker2.textEl.addCls("inProgressCss-progress-text");
						progresstracker2.updateText(getCommonTranslation('STEP_2_IN_PROGRESS'));
						progresstracker1.updateText(getCommonTranslation('STEP_1_COMPLETE'));
					}
					if(progresstracker==2){
						for(var i = 0; i < 11; i ++ ){
							progresstracker2.updateProgress((i * 0.1), '');
						}
						progresstracker2.textEl.removeCls("inProgressCss-progress-text");
						progresstracker2.textEl.addCls("custom-progress-text");
						progresstracker2.updateText(getCommonTranslation('STEP_2_COMPLETE'));
						progresstracker3.textEl.removeCls("x-progress-text x-progress-text-back");
						progresstracker3.textEl.addCls("inProgressCss-progress-text");
						progresstracker3.updateText(getCommonTranslation('STEP_3_IN_PROGRESS'));
					}
				},

				/*Function for Reset Progress Bar on header*/
				resetProgressTracker : function(){
					var structure = this.getManagecoursesectionaddmappingtab();
					var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");
					var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
					var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
					var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");
					var progresstracker4 = adjustmentprogresstracker.down("#progresstracker4");
					progresstracker1.reset();
					progresstracker1.updateText('');
					progresstracker2.reset();
					progresstracker2.updateText('');
					progresstracker3.reset();
					progresstracker3.updateText('');
					progresstracker4.reset();
					progresstracker4.updateText('');
				},

				/*Function for next button click on Program Tab*/
				nextEventOnProgramTab:function(btn){
					var managecoursesectionaddprogrambatchstructure = this.getManagecoursesectionaddprogrambatchstructure();
					var alProgramGrid = this.getManagecoursesectionaddprogramgrid();
					var selectionModel = alProgramGrid.getSelectionModel().getSelection();

					var programIdsArr = [];
					selectionModel.forEach(function(obj){

						if(programIdsArr.indexOf(obj.get('id')) == -1){
							programIdsArr.push(obj.get('id'));
						}
					});

					var gradesIdsArr = [];
					selectionModel.forEach(function(obj){

						if(gradesIdsArr.indexOf(obj.get('programMarkGrade')) == -1){
							gradesIdsArr.push(obj.get('programMarkGrade'));
						}
					});
					var coursesectionmanagementstructure = this.getCoursesectionmanagementstructure();
					var sectionTypeRadio = coursesectionmanagementstructure.down('#sectionTypeRadio').getValue();
					var acdemicTermVal;
					var programBaseCourseGrade ;
					var programId ;
					var batchRecord ;
					var periodRecord ;
					var programName;
					var markGradeType;
					if(sectionTypeRadio.sectionType == "PROGRAM_WISE_SECTION"){
						acdemicTermVal = coursesectionmanagementstructure.down('#programWiseAcademicTermId').getValue();
						markGradeType= coursesectionmanagementstructure.down('#programWiseCourseMarkGrade_id').getValue();
						      coursesectionmanagementstructure.down('#programWiseAcademicTermId').getValue();
						 periodRecord = coursesectionmanagementstructure.down('#programWisePeriodId').getValue();
					}
					else{
						var form=this.getOpensectionsearch(); 
						var courseRecord = form.down('#courseSectionId').getValue();
						markGradeType = form.down('#courseMarksGrades_id').getValue();
						acdemicTermVal=form.down('#academicTerm').getValue();
					}
					if(markGradeType=="GRADE"){
						programBaseCourseGrade="G";
					}else{
						programBaseCourseGrade="M";
					}
					
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var whetherSchool = alinfomodel.get('wheatherSchool');
					var aLId = this.getCurrentAcademyLocation();

					if(programIdsArr.length > 0){
						var programbatchcontainer = managecoursesectionaddprogrambatchstructure.down('#programbatchcontainer');
						var managecoursesectionaddmappingtab = this.getManagecoursesectionaddmappingtab();
						programbatchcontainer.setDisabled(false);
						managecoursesectionaddprogrambatchstructure.setActiveTab(programbatchcontainer);
						var alProgramPeriodGrid = this.getManagecoursesectionaddprogramperiodgrid();

						var batchIds = [];
						if(!isNullOrEmpty(batchRecord)) {
							Ext.each(batchRecord,function(batch){
								if(typeof batch=="number"){
									batchIds.push(batch);
								}else if(!isNullOrEmpty(batch.data)){
									batchIds.push(batch.data.id);
								}
							});
						} 
						var periodIds = [];
						if(!isNullOrEmpty(periodRecord)) {
							Ext.each(periodRecord,function(period){
								if(typeof period=="number"){
									periodIds.push(period);
								}else if(!isNullOrEmpty(period.data)){
									periodIds.push(period.data.id);
								}
							});
						} 
						
						var alProgramBatchSearchCombo = alProgramPeriodGrid.down('#programbatchsearchcombo');
						var alProgramBatchSearchComboValue = alProgramPeriodGrid.down('#programbatchsearchcombo').getValue();
						alProgramBatchSearchCombo.reset();
						alProgramBatchSearchCombo.getStore().getProxy().extraParams= {
							academyLocationIds: aLId,
							academicTermId:acdemicTermVal,
							whetherSchool:whetherSchool,
							programIds:programIdsArr.join(),
							programBaseCourseGrade : programBaseCourseGrade,
							programName :alProgramBatchSearchComboValue,
							sectionType:sectionTypeRadio.sectionType=="PROGRAM_WISE_SECTION"?null:sectionTypeRadio.sectionType
									
						};
						alProgramBatchSearchCombo.getStore().load();

					//	programBatchGrid.getStore().clearFilter();

						var alProgramPeriodGridStore = alProgramPeriodGrid.getStore();

						alProgramPeriodGridStore.getProxy().extraParams= {
							academyLocationIds: aLId,
							academicTermId:acdemicTermVal,
							whetherSchool:whetherSchool,
							programIds:programIdsArr.join(),
							programBaseCourseGrade : programBaseCourseGrade,
							programName :alProgramBatchSearchComboValue,
							sectionType:sectionTypeRadio.sectionType=="PROGRAM_WISE_SECTION"?null:sectionTypeRadio.sectionType
									
						};
						//alProgramPeriodGridStore.clearFilter();
						alProgramPeriodGridStore.load();

						this.setProgressTracker(1);
					}
					else {
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				},
				
				submitMappingMangeCourseSection: function(btn){ 

			    	var $this = this;
			    	var contentPanel = this.getContentPanel();
			    	var tabStructure = this.getManagecoursesectionaddprogrambatchstructure();
			    	var getcontroller=this.getController('menu.CoreERPNavigationController');
			    	var activeGrid = tabStructure.getActiveTab().down('grid');
			    	var csdetailviewgrid = contentPanel.down('managecoursesectiondetailedviewgrid');
			    	var whetherOptional=activeGrid.down('#whetherOptionalItemId').getValue().whetherOptional;
			    	var selectedRecord = activeGrid.getSelectionModel().getSelection();
			    	var managecoursesectionaddmappingtab = this.getManagecoursesectionaddmappingtab();
			    	var recordsGrid = managecoursesectionaddmappingtab.config.gridRecord;
			    	var gridXtype = managecoursesectionaddmappingtab.config.gridXtype;
			    	var submitJsonArr;
			    	var jsonALArr = [];
			    	var jsonALCourseArr = [];
			    	var alProgBatchSeat;
			    	var selected = [];
			    	 var wsBatchCoursesAndParameterizationModel = new Object();
			    	if(selectedRecord.length>0){
			    		var submitUrl = SERVERURL.PROGRAM_BATCH_DETAIL_COURSE_PARAMETER_CREATE_ALL_URL;
			    		if(activeGrid.xtype == 'managecoursesectionaddprogramperiodgrid'){
			    			if(gridXtype == "managecoursesectionsummaryviewgrid"){
			    				for (var i = 0; i < recordsGrid.length; i++) {
				    				var courseVariantList = recordsGrid[i].data.courseVariantSectionModelList;
				    				
				    				if(!isNullOrEmpty(courseVariantList) && courseVariantList.length>0){
				    					for (var j = 0; j < courseVariantList.length; j++) {
				    						for (var k = 0; k < selectedRecord.length; k++) {
							    				var courseSectionObject = {};
							    				courseSectionObject['programPeriodNameId'] = selectedRecord[k].data.periodId;
							    				courseSectionObject['sectionCodeId'] = courseVariantList[j].sectionId;
							    				courseSectionObject['sectionCode'] = courseVariantList[j].sectionId;
							    				courseSectionObject['courseVariantCodeId'] = courseVariantList[j].courseVariantId;
							    				courseSectionObject['batchId'] = selectedRecord[k].data.batchId;
							    				//courseSectionObject['periodId'] = selectedRecord[k].data.periodId;
							    				courseSectionObject['courseId'] = recordsGrid[i].data.courseId;
							    				courseSectionObject['calendar'] = null;
							    				courseSectionObject['courseCode'] = recordsGrid[i].data.courseCode;
							    				courseSectionObject['courseName'] = recordsGrid[i].data.courseName;
							    				courseSectionObject['whetherOptional'] = recordsGrid[i].data.whetherOptional;
							    				courseSectionObject['courseCutOff'] = recordsGrid[i].data.courseCutOff;
							    				courseSectionObject['courseMaxMark'] = recordsGrid[i].data.courseMaxMark;
							    				courseSectionObject['courseGradeType'] = recordsGrid[i].data.courseGradeType;
							    				courseSectionObject['courseMarksGrades'] = recordsGrid[i].data.courseMarksGrades;
							    				courseSectionObject['courseCredits'] = recordsGrid[i].data.courseCredits;
							    				courseSectionObject['whetherRegularCourse'] = true;
							    				
							    				selected.push(courseSectionObject);	
							    			}
				    					}
				    				}
				    			}
			    			}
			    			else{
			    				for (var i = 0; i < recordsGrid.length; i++) {
			    					for (var k = 0; k < selectedRecord.length; k++) {
			    						var courseSectionObject = {};
			    						courseSectionObject['programPeriodNameId'] = selectedRecord[k].data.periodId;
			    						courseSectionObject['sectionCodeId'] = recordsGrid[i].data.sectionId;
			    						courseSectionObject['sectionCode'] = recordsGrid[i].data.sectionId;
			    						courseSectionObject['courseVariantCodeId'] = recordsGrid[i].data.courseVariantId;
			    						courseSectionObject['batchId'] = selectedRecord[k].data.batchId;
			    						//courseSectionObject['periodId'] = selectedRecord[k].data.periodId;
			    						courseSectionObject['courseId'] = recordsGrid[i].data.courseId;
			    						courseSectionObject['calendar'] = null;
			    						courseSectionObject['courseCode'] = recordsGrid[i].data.courseCode;
			    						courseSectionObject['courseName'] = recordsGrid[i].data.courseName;
			    						courseSectionObject['whetherOptional'] = recordsGrid[i].data.whetherOptional;
			    						courseSectionObject['courseCutOff'] = recordsGrid[i].data.courseCutOff;
			    						courseSectionObject['courseMaxMark'] = recordsGrid[i].data.courseMaxMark;
			    						courseSectionObject['courseGradeType'] = recordsGrid[i].data.courseGradeType;
			    						courseSectionObject['courseMarksGrades'] = recordsGrid[i].data.courseMarksGrades;
			    						courseSectionObject['courseCredits'] = recordsGrid[i].data.courseCredits;
			    						courseSectionObject['whetherRegularCourse'] = true;

			    						selected.push(courseSectionObject);	
			    					}
			    				}
			    			}
			    		}
			    		wsBatchCoursesAndParameterizationModel.whetherOptional=whetherOptional;
			    		wsBatchCoursesAndParameterizationModel.wsProgramBatchCourseParams=selected;
			    		var wsBatchCoursesAndParameterizationModelData = Ext.encode(wsBatchCoursesAndParameterizationModel);
			    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');

			    		Ext.Ajax.request({
			    			method: "POST",
			    			type: 'rest',
			    			url: submitUrl,
			    			timeout: 3600000,  // 1 hour   
			    			jsonData:wsBatchCoursesAndParameterizationModelData,
			    			success : function(response, action) {
			    				Ext.getBody().unmask();
			    				var data = response.responseText;
			    				var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
			    				var getTab=getcontroller.getTab(tabName);
			    				if(getTab!=null){
			    					contentPanel.remove(getTab, true);
			    				}
                                if(csdetailviewgrid){
                                    csdetailviewgrid.getStore().load();
                                }
			    				showSuccessMessage(getCourseTxCommonTranslation('SECTION'),getCommonTranslation('SUCCESS'));
			    			}
			    		});
			    	} else {
			    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
			    	}
			    
			    },
			    saveMultipleCourseSection:function(){
	            	var $this = this;
	            	var searchForm = this.getProgramwisesectionsearch();
	            	var saveForm = $this.getCreatecoursesectionform();
	            	var periodValue = saveForm.down("#periodIds").getValue();
	            	var form = saveForm.getForm();
	            	var createSectionType = saveForm.down('#definedSectionId').getValue();
	            	var periodIds = periodValue;
	            	var alinfomodel = Academia.model.authentication.ALInfoModel;
                    var whetherSchool = alinfomodel.get('wheatherSchool');
	            	if(createSectionType.definedSection) {
	            		var panel = saveForm.down('#preDefinedPanelId');
		            	var values = form.getValues();
		            	var academicTermId = values.createAcademicTermId;
                   	 //	var academicTermValue = form.findField('createAcademicTermId').store.findRecord('id',academicTermId).data.value;
		            	var academicTermValueStore= saveForm.down('#createAcademicTermId').getStore();
		            	var academicTermValue =academicTermValueStore.getAt(academicTermValueStore.findExact('id',academicTermId)).data.value;
		            	var courseIds = values.sectionCourseId.split(',');
		            	var enrollmentCriteria = 'FIRST_COME'; // default

                        if (values.enrollmentCriteria && values.enrollmentCriteria === 'MEDICATION') {
                            enrollmentCriteria = 'BY_FACULTY';
                        }
		            	var masterData=[];
		            	for(var j=0; j < courseIds.length; j++){
		            		if(courseIds[j] > 0){
		            			if(panel.items.length > 1){
				            		for(var i=0; i < values.preDefinedSectionCode.length; i++){
				            			var sectionCode='';
	                                    if(whetherSchool) { 
	                                        sectionCode = values.locationCode[i]+"/"+  values.preDefinedSectionCode[i];
	                                    }else{
	                                        sectionCode=values.preDefinedSectionCode[i];
	                                    }
				            			masterData.push({
					            			"sectionCode": sectionCode,
					            			"alternateName": values.preDefinedSectionPrintName[i],
					            			"sectionRule": null,
					            			"maxCapacity": (isNullOrEmpty(values.preDefinedMaxCapacity[i]) || values.preDefinedMaxCapacity[i] == "") ? null : values.preDefinedMaxCapacity[i],
					            			"minCapacity": 0,
					            			"homeRoom": (isNullOrEmpty(values.preDefinedAssignHomeRoom[i]) || values.preDefinedAssignHomeRoom[i] == "") ? null : values.preDefinedAssignHomeRoom[i],
					            			"academicTerm":$this.getIdValueJson(academicTermId, academicTermValue),
					            			"evaluationPlan":$this.getIdValueJson(values.evalutionPlanName),
					            			"calender":$this.getIdValueJson(values.calendar),
					            			"studentCourseEnrollmentCriteria":enrollmentCriteria,
					            			"customFieldDatas":null,
					            			"course":$this.getIdValueJson(courseIds[j]),
					            			"periodIds":periodIds,
                                            "facultyId":$this.getIdValueJson(values.facultyId[i]),
                                            "alternateId": $this.getIdValueJson(values.alternateId[i]),

					            		});
				            		}
				            	}else{
				            		var sectionCodepre='';
                                    if(whetherSchool) { 
                                        sectionCodepre = values.locationCode+"/"+  values.preDefinedSectionCode;
                                    }else{
                                        sectionCodepre=values.preDefinedSectionCode;
                                    }
				            		masterData.push({
				            			
				            			"sectionCode": sectionCodepre,
				            			"alternateName": values.preDefinedSectionPrintName,
				            			"sectionRule": null,
				            			"maxCapacity": (isNullOrEmpty(values.preDefinedMaxCapacity) || values.preDefinedMaxCapacity == "") ? null : values.preDefinedMaxCapacity,
				            			"minCapacity": 0,
				            			"homeRoom": (isNullOrEmpty(values.preDefinedAssignHomeRoom) || values.preDefinedAssignHomeRoom == "") ? null : values.preDefinedAssignHomeRoom,
				            			"academicTerm":$this.getIdValueJson(academicTermId, academicTermValue),
				            			"evaluationPlan":$this.getIdValueJson(values.evalutionPlanName),
				            			"calender":$this.getIdValueJson(values.calendar),
				            			"studentCourseEnrollmentCriteria":enrollmentCriteria,
				            			"customFieldDatas":null,
				            			"course":$this.getIdValueJson(courseIds[j]),
				            			"periodIds":periodIds,
				            			"facultyId": $this.getIdValueJson(isNullOrEmpty(values.facultyId) ? null : values.facultyId),
                                        "alternateId": $this.getIdValueJson(isNullOrEmpty(values.alternateId) ? null : values.alternateId)

				            		});
				            	}
		            		}
		            	}

	            	} else {
	            		var panel = saveForm.down('#usrDefinedPanelId');
		            	var values = form.getValues();
		            	var academicTermId = values.createAcademicTermId;
//		            	var academicTermValue = form.findField('createAcademicTermId').store.findRecord('id',academicTermId).data.value;
		            	var academicTermValueStore= saveForm.down('#createAcademicTermId').getStore();
		            	var academicTermValue =academicTermValueStore.getAt(academicTermValueStore.findExact('id',academicTermId)).data.value;
		            	var courseIds = values.sectionCourseId.split(',');
		            	var enrollmentCriteria = 'FIRST_COME'; // default
		            	if (values.enrollmentCriteria && values.enrollmentCriteria === 'MEDICATION') {
                             enrollmentCriteria = 'BY_FACULTY';
                            }

		            	var masterData=[];
		            	for(var j=0; j < courseIds.length; j++){
		            		if(courseIds[j] > 0){
		            			if(panel.items.length > 1){
		            				var allSectionCode=[];
				            		for(var i=0; i < values.usrDefinedSectionName.length; i++){
				            			if(!(allSectionCode.indexOf(values.usrDefinedSectionName[i])>-1)){
				            				var sectionCodeus='';
                                            if(whetherSchool) { 
                                                sectionCodeus = values.locationCode+"/"+  values.usrDefinedSectionName[i];
                                            }else{
                                                sectionCodeus=values.usrDefinedSectionName[i];
                                            }
				            				masterData.push({
						            			"sectionCode": sectionCodeus,
						            			"alternateName": values.usrDefinedSectionPrintName[i],
						            			"sectionRule": null,
						            			"maxCapacity": (isNullOrEmpty(values.usrDefinedMaxCapacity[i]) || values.usrDefinedMaxCapacity[i] == "") ? null : values.usrDefinedMaxCapacity[i],
						            			"minCapacity": 0,
						            			"homeRoom": (isNullOrEmpty(values.usrDefinedAssignHomeRoom[i]) || values.usrDefinedAssignHomeRoom[i] == "") ? null : values.usrDefinedAssignHomeRoom[i],
						            			"academicTerm":$this.getIdValueJson(academicTermId, academicTermValue),
						            			"evaluationPlan":$this.getIdValueJson(values.evalutionPlanName),
						            			"calender":$this.getIdValueJson(values.calendar),
						            			"studentCourseEnrollmentCriteria":enrollmentCriteria,
						            			"customFieldDatas":null,
						            			"course":$this.getIdValueJson(courseIds[j]),
						            			"periodIds":periodIds,
                                                "facultyId":$this.getIdValueJson(values.facultyId[i]),
                                                "alternateId": $this.getIdValueJson(values.alternateId[i])
						            		});
				            				allSectionCode.push(values.usrDefinedSectionName[i]);
				            			}
				            		}
				            	}else{
				            		var sectionCodeuser='';
                                    if(whetherSchool) { 
                                        sectionCodeuser = values.locationCode+"/"+  values.usrDefinedSectionName;
                                    }else{
                                        sectionCodeuser=values.usrDefinedSectionName;
                                    }
				            		masterData.push({
				            			"sectionCode": sectionCodeuser,
				            			"alternateName": values.usrDefinedSectionPrintName,
				            			"sectionRule": null,
				            			"maxCapacity": (isNullOrEmpty(values.usrDefinedMaxCapacity) || values.usrDefinedMaxCapacity == "") ? null : values.usrDefinedMaxCapacity,
				            			"minCapacity": 0,
				            			"homeRoom": (isNullOrEmpty(values.usrDefinedAssignHomeRoom) || values.usrDefinedAssignHomeRoom == "") ? null : values.usrDefinedAssignHomeRoom,
				            			"academicTerm":$this.getIdValueJson(academicTermId, academicTermValue),
				            			"evaluationPlan":$this.getIdValueJson(values.evalutionPlanName),
				            			"calender":$this.getIdValueJson(values.calendar),
				            			"studentCourseEnrollmentCriteria":enrollmentCriteria,
				            			"customFieldDatas":null,
				            			"course":$this.getIdValueJson(courseIds[j]),
				            			"periodIds":periodIds,
                                        "facultyId": $this.getIdValueJson(isNullOrEmpty(values.facultyId) ? null : values.facultyId),
                                        "alternateId": $this.getIdValueJson(isNullOrEmpty(values.alternateId) ? null : values.alternateId)
				            		});
				            	}
		            		}
		            	}
	            	}
	            	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	            	submitUrl = SERVERURL.PATH_CREATE_MULTIPLE_COURSE_SECTION;
	            	Ext.Ajax.request({
	            		type : 'rest',
	            		url : submitUrl,
	            		jsonData : masterData,
	            		method : 'POST',
	            		timeout: 900000,
	            		success : function(form, action) {
	            			Ext.getBody().unmask();
	            			$this.getContentPanel().getActiveTab().close();
	            			$this.getManagecoursesectionsummaryviewgrid().getStore().reload();
	            			if(form.responseText!="success"){
	            				showWarningMessage(getCommonTranslation('ALERT'),"Section is already created for following Courses.<br>"+form.responseText);
	            			}else{
	            				showSuccessMessage(getCourseTxCommonTranslation('SECTION'),getProgramandcourseTranslation('COURSE_SECTION_CREATE_SUCCESS_MSG'));
	            			}
	            		}
	            	});
	            },
	            getIdValueJson: function(id, value) {
               	 if (id) return {
               		 id: id,
               		 value: value
               	 };
                },
                academicTermChange: function() {
					var $this = this;
					var form = $this.getProgramwisesectionsearch();
					var grid = $this.getManagecoursesectionsummaryviewgrid();
					grid.down('#addSection').setDisabled(true);
					grid.down('#mapProgramPeriod').setDisabled(true);
					grid.getStore().removeAll();
					try {
						grid.down('custompagingtoolbar').hide();
					}
					catch(e){
					}
					var detailGrid=this.getManagecoursesectiondetailedviewgrid();
					detailGrid.getStore().removeAll();
					try {
						detailGrid.down('custompagingtoolbar').hide();
					}
					catch(e){
					}
					var aLId = $this.getCurrentAcademyLocation();
					var academicTermId = form.down('#programWiseAcademicTermId').getValue();

					var programBatchCombo = form.down('#programWiseProgramId');
					var programWisePeriodCombo = form.down('#programWisePeriodId');
					var programWiseCourseCombo = form.down('#programWiseCourseId');
					var courseMarksGradesField = form.down("#programWiseCourseMarkGrade_id");
					var programWiseCheckBox = form.down('#programWiseCheckBoxId');
					var academyLocationId = form.down('#academyLocation').getValue();
					var programWiseSectionCombo = form.down('#programWiseSectionId');
					
					programWiseCheckBox.setValue(false);
					programBatchCombo.reset();
					programWisePeriodCombo.reset();
					programWiseCourseCombo.reset();
					programWiseSectionCombo.reset();
				

					programBatchCombo.setDisabled(true);
					programWisePeriodCombo.setDisabled(true);
					programWiseCourseCombo.setDisabled(true);
					programWiseCheckBox.setDisabled(true);
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var wheatherSchool = alinfomodel.get('wheatherSchool');
					if(wheatherSchool){
						programWisePeriodCombo.setVisible(false);
						$this.setAllowBlank(programWisePeriodCombo, true);
					} else {
						$this.setAllowBlank(programWisePeriodCombo, false);
					}
					var courseMarksGradesField = form.down("#programWiseCourseMarkGrade_id");
						if(academicTermId > 0 || academyLocationId > 0) {
							//form.getForm().isValid();
							//form.getForm().clearInvalid();
							programBatchCombo.setDisabled(false);
							var programBatchStore = programBatchCombo.getStore();
							programBatchStore.getProxy().extraParams = {
								academyLocationIds : academyLocationId,
								academicTermId : academicTermId,
								programType:courseMarksGradesField.getValue()
							};
							programBatchStore.load({
								callback: function(records, operation, success) {
									if (success) {
										if(records.length == 1){
											var batchId = records[0].get('id');
											var batchIds = [batchId];
											programBatchCombo.setValue(batchIds);
											programWisePeriodCombo.setDisabled(false);
											
										}
									}
								}
							});
							//form.getForm().isValid();
						}
                },
                
                academyLocationChange : function(){
					var $this = this;
					var form = $this.getProgramwisesectionsearch();
					var grid = $this.getManagecoursesectionsummaryviewgrid();
					grid.down('#addSection').setDisabled(true);
					grid.down('#mapProgramPeriod').setDisabled(true);
					grid.getStore().removeAll();
					try {
						grid.down('custompagingtoolbar').hide();
					}
					catch(e){
					}
					var detailGrid=this.getManagecoursesectiondetailedviewgrid();
					detailGrid.getStore().removeAll();
					try {
						detailGrid.down('custompagingtoolbar').hide();
					}
					catch(e){
					}
					var aLId = $this.getCurrentAcademyLocation();
					var academicTermCombo = form.down('#programWiseAcademicTermId');
					var programBatchCombo = form.down('#programWiseProgramId');
					var programWisePeriodCombo = form.down('#programWisePeriodId');
					var programWiseCourseCombo = form.down('#programWiseCourseId');
					var courseMarksGradesField = form.down("#programWiseCourseMarkGrade_id");
					var programWiseCheckBox = form.down('#programWiseCheckBoxId');
					var academyLocationId = form.down('#academyLocation').getValue();
					var programWiseSectionCombo = form.down('#programWiseSectionId');
					programWiseCheckBox.setValue(false);
					programBatchCombo.reset();
					programWisePeriodCombo.reset();
					programWiseCourseCombo.reset();
					programWiseSectionCombo.reset();
					

					programBatchCombo.setDisabled(true);
					programWisePeriodCombo.setDisabled(true);
					programWiseCourseCombo.setDisabled(true);
					programWiseCheckBox.setDisabled(true);
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var wheatherSchool = alinfomodel.get('wheatherSchool');
					if(wheatherSchool){
						programWisePeriodCombo.setVisible(false);
						$this.setAllowBlank(programWisePeriodCombo, true);
					} else {
						$this.setAllowBlank(programWisePeriodCombo, false);
					}
					var academicTermStore = academicTermCombo.getStore();
					academicTermStore.getProxy().extraParams = {
						academyLocationIds : academyLocationId
					};
					var academicTermId = 0;
					var courseMarksGradesFieldId = courseMarksGradesField.getValue();
					if (isNullOrEmpty(courseMarksGradesFieldId)) {
						courseMarksGradesFieldId = "GRADE"
			        }
					academicTermStore.load({
						callback: function(records, operation, success) {
							for(var i in records) {
								if(records[i].get('sequence') == 1) {
									academicTermId = records[i].get('id');
									academicTermCombo.setValue(academicTermId);
									if(isNullOrEmpty(courseMarksGradesField.getValue())) {
										var courseMarksGrades_Store = courseMarksGradesField.getStore();
										courseMarksGrades_Store.getProxy().extraParams = {
											academyLocationIds : academyLocationId
										};
										courseMarksGrades_Store.load({
											callback: function(rec, success) {
												if (success) {
													for(var i in rec){
														if(rec[i].get('id')=='GRADE'){
															courseMarksGradesFieldId = rec[i].get('id');
															courseMarksGradesField.setValue(rec[i].get('id'));
															if(academyLocationId > 0) {
																/*form.getForm().isValid();
																form.getForm().clearInvalid();*/
																programBatchCombo.setDisabled(false);
																var programBatchStore = programBatchCombo.getStore();
																programBatchStore.getProxy().extraParams = {
																	academyLocationIds : academyLocationId,
																	academicTermId : academicTermId,
																	programType:courseMarksGradesFieldId
																};
																programBatchStore.load({
																	callback: function(records, operation, success) {
																		if (success) {
																			if(records.length == 1){
																				var batchId = records[0].get('id');
																				var batchIds = [batchId];
																				programBatchCombo.setValue(batchIds);
																				programWisePeriodCombo.setDisabled(false);
																				
																			}
																		}
																	}
																});
															}
														}
													}
												}
											}
										});
									} else {
										if(academyLocationId > 0) {
											form.getForm().isValid();
											form.getForm().clearInvalid();
											programBatchCombo.setDisabled(false);
											var programBatchStore = programBatchCombo.getStore();
											programBatchStore.getProxy().extraParams = {
												academyLocationIds : academyLocationId,
												academicTermId : academicTermId,
												programType:courseMarksGradesFieldId
											};
											programBatchStore.load({
												callback: function(records, operation, success) {
													if (success) {
														if(records.length == 1){
															var batchId = records[0].get('id');
															var batchIds = [batchId];
															programBatchCombo.setValue(batchIds);
															programWisePeriodCombo.setDisabled(false);
															
														}
													}
												}
											});
										}
									}
								}
							}
						}
					});
					//form.isValid();
                
                },
                
                showSectionforCS : function(){
               	 
               	 var grid = this.getManagecoursesectionstudentgrid();
               	 if(grid.getSelectionModel().getCount()>0){
               		 
               		 var isAllRegularSelected = false;
               		 var isAllRepeatSelected = false;

               		 var isAllProgramSame = false;
               		 var isAllBatchSame = false;
               		 var isAllPeriodSame = false;

               		 var selectedRecords = grid.getSelectionModel().getSelection();
               		 var enrollmentTypeArray = Ext.Array.pluck(Ext.Array.pluck(selectedRecords,'data'),'moduleType');

               		 var programIdsArray = Ext.Array.pluck(Ext.Array.pluck(selectedRecords,'data'),'programId');
               		 var batchIdsArray = Ext.Array.pluck(Ext.Array.pluck(selectedRecords,'data'),'batchId');
               		 var periodIdsArray = Ext.Array.pluck(Ext.Array.pluck(selectedRecords,'data'),'periodId');

               		 var firstRecordProgramId = selectedRecords[0].data.programId;
               		 var firstRecordBatchId = selectedRecords[0].data.batchId;
               		 var firstRecordPeriodId = selectedRecords[0].data.periodId;

               		 isAllRegularSelected = Ext.Array.every(enrollmentTypeArray, function(item) {
               			 return item === 'Regular';
               		 });

               		 isAllRepeatSelected = Ext.Array.every(enrollmentTypeArray, function(item) {
               			 return item === 'Repeat';
               		 });

               		 if(!isAllRepeatSelected){
               			 isAllRepeatSelected = Ext.Array.every(enrollmentTypeArray, function(item) {
               				 return item === 'Backlog';
               			 });
               		 }

               		 if(!isAllRepeatSelected){
               			 isAllRepeatSelected = Ext.Array.every(enrollmentTypeArray, function(item) {
               				 return item === 'Additional';
               			 });
               		 }

               		 isAllProgramSame = Ext.Array.every(programIdsArray, function(item) {
               			 return item === firstRecordProgramId;
               		 });

               		 isAllBatchSame = Ext.Array.every(batchIdsArray, function(item) {
               			 return item === firstRecordBatchId;
               		 });

               		 isAllPeriodSame = Ext.Array.every(periodIdsArray, function(item) {
               			 return item === firstRecordPeriodId;
               		 });

               		 if(isAllRegularSelected){
               			 if(isAllProgramSame && isAllBatchSame && isAllPeriodSame){
               				 //-Continue to Open Window
               			 }
               			 else{
               				 showWarningMessage(getCourseTxCommonTranslation('SECTION'),getCommonTranslation('PLEASE_SELECT_SINGLE_PROGRAM_BATCH_PERIOD_STUDENTS'));
               				 return false;
               			 }
               		 }
               		 else if(isAllRepeatSelected){
               			 if(isAllProgramSame){
               				 //-Continue to Open Window
               			 }
               			 else{
               				 showWarningMessage(getCourseTxCommonTranslation('SECTION'),getCommonTranslation('PLEASE_SELECT_SINGLE_PROGRAM_STUDENTS'));
               				 return false;
               			 }
               		 }
               		 else{
               			 showWarningMessage(getCourseTxCommonTranslation('SECTION'),getCommonTranslation('PLEASE_SELECT_SAME_ENROLLMENT_TYPE_STUDENTS'));
               			 return false;
               		 }
               		 
               		 var frmWin = this.getSectionforcoursemanagewin();
               		 if (!frmWin) {
               			 Ext.widget('sectionforcoursemanagewin');
               			 frmWin = this.getSectionforcoursemanagewin();
               		 }
               		 var record = grid.getSelectionModel().getSelection();
               		 var periodId;
               		if(record !=undefined && record.length > 0){
               			periodId=record[0].data.periodId;
               		}
               		 frmWin.show();
               		 var $this=this;
               		 var searcgfrm = $this.getOpensectionsearch().getForm();
               		 var detailsFilter =  $this.getStudentcoursesectiondetails();
               		 var structure = $this.getCoursesectionmanagementstructure();
               		 var radiogroupValue = structure.down('#sectionTypeRadio').getValue();
               		 var academicTermId=null;
               		 if(radiogroupValue.sectionType=='PROGRAM_WISE_SECTION'){
               			 academicTermId=detailsFilter.down("#academicTermId").getValue()
               		 }
               		 var courseSectionId = detailsFilter.down("#courseId").getValue();
               		 var componentId = detailsFilter.down("#componentId").getValue();
               		 var sectionId = detailsFilter.down("#sectionId").getValue();
               		 // var academicTermId=searcgfrm.findField("academicTerm").getValue();
               		 var sectionStore=frmWin.down('#sectionId').getStore();
               		 // var store2 = $this.getStore('coursetransaction.sectionmanagement.CourseSectionCombo');
               	/*	 if(!isNullOrEmpty(componentId)){
               			 sectionStore.getProxy().extraParams = {
               				 componentId : componentId,
               				 sectionId   : sectionId,
               				 sort:null,
               				 whetherSchool:true,
               				 academicTermId:academicTermId,
               				periodId:periodId
               			 };
               		 }else{
               			 sectionStore.getProxy().extraParams = {
               				 courseId : courseSectionId,
               				 sectionId: sectionId,
               				 sort:null,
               				 whetherSchool:true,
               				 academicTermId:academicTermId,
               				periodId:periodId
               			 };
               		 */
               		 
               		 if(isAllRegularSelected){
               			 if(isAllProgramSame && isAllBatchSame && isAllPeriodSame){
               				 if(!isNullOrEmpty(componentId)){
               					 sectionStore.getProxy().extraParams = {
               						 componentId : componentId,
               						 sectionId   : sectionId,
               						 sort:null,
               						 whetherSchool:true,
               						 academicTermId:academicTermId,
               						 periodId:firstRecordPeriodId
               					 };
               				 }else{
               					 sectionStore.getProxy().extraParams = {
               						 courseId : courseSectionId,
               						 sectionId: sectionId,
               						 sort:null,
               						 whetherSchool:true,
               						 academicTermId:academicTermId,
               						 periodId:firstRecordPeriodId
               					 };
               				 }
               			 }
               		 }
               		 else if(isAllRepeatSelected){
               			 if(isAllProgramSame){
               				 if(!isNullOrEmpty(componentId)){
               					 sectionStore.getProxy().extraParams = {
               						 componentId : componentId,
               						 sectionId   : sectionId,
               						 sort:null,
               						 whetherSchool:true,
               						 academicTermId:academicTermId,
               						 programId:firstRecordProgramId
               					 };
               				 }else{
               					 sectionStore.getProxy().extraParams = {
               						 courseId : courseSectionId,
               						 sectionId: sectionId,
               						 sort:null,
               						 whetherSchool:true,
               						 academicTermId:academicTermId,
               						 programId:firstRecordProgramId
               					 };
               				 }
               			 }
               		 }
               		 
               		 sectionStore.load();
               	 }else{
               		 showWarningMessage(getCourseTxCommonTranslation('SECTION'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record 
               	 }
                },
                
                closeSectionforCS :function(){
               	 this.getSectionforcoursemanagewin().close();
                },
                
                saveSectionforCS : function(){
               	 var $this = this;
               	 var form =  $this.getSectionforcoursemanagewin();
               	 var sectionId = form.down("#sectionId").getValue();
               	 var sectionName = form.down("#sectionId").getRawValue();
               	 var value = form.down('#transferDate').getValue();
               	 var date = Ext.Date.format(new Date(value), 'Y-m-d'); 
               	 var CSgrid = this.getManagecoursesectiondetailedviewgrid();
               	 var CSgrdStore = CSgrid.getStore();  

               	 var grid = $this.getManagecoursesectionstudentgrid();
               	 var grdStore = grid.getStore();

               	 var records = grid.selModel.getSelection();
               	 if(records.length>0){
               		 var studentJson=[];
               		 for(var i in records) {
               			 studentJson.push({
               				 "id":records[i].data.id,
               				 "section":$this.getIdValueJson(sectionId,sectionName)
               			 });
               		 };	 
               		 var submitData = studentJson;
               		 $this.applyWindowMask(); 
               		 Ext.Ajax.request({
               			 url: SERVERURL.COURSE_STUDENT_UPDATE+"?dateOfTransfer="+date,
               			 jsonData: submitData,
               			 method: 'POST',
               			 success: function(response) {
               				 $this.hideWindowMask();
               				 if(response.responseText == "The student can't be transfered to this section as it is not mapped to his current period."){
               					 showWarningMessage(getCourseTxCommonTranslation('SECTION'),getCourseTxCommonTranslation('TRANSFER_WARNING'));
               					 $this.closeSectionforCS();
               				 }
               				 else if(response.responseText=="SUCCESS"){
               					 showSuccessMessage(getCourseTxCommonTranslation('SECTION'),getCourseTxCommonTranslation('SECTION_ASSIGNED'));
               					 grdStore.reload();
               					 CSgrdStore.reload();
               					 grid.getSelectionModel().deselectAll();
               					 $this.closeSectionforCS();
               				 }else{
               					 showWarningMessage(getCourseTxCommonTranslation('SECTION'), response.responseText);
               				 }
               			 }
               		 });
               	 }

                },
                
                
                setReadOnlyFieldsForCBS:function(win){
               	 var $this = this;
               	 var searchForm = $this.getStudentcoursesectiondetails();
               	 var searchCourse = searchForm.down('#courseName').getValue();
               	 var searchComponent = searchForm.down('#componentName').getValue();

               	 var form =  $this.getSectionforcoursemanagewin();
               	 form.down('#course').setVisible(true);
               	 form.down('#course').setRawValue(searchCourse);

               	 if(searchComponent !="" && searchComponent !=null){
               		 form.down('#component').setVisible(true);	
               		 form.down('#component').setRawValue(searchComponent);
               	 }else{
               		 form.down('#component').setVisible(false);
               	 }

                },
                
                disableMoreActionPivileges: function(gridReference,permissionsMap) {
               	 var associatedAcadLocationIds = new Array();
            	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
            	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
            	 var assignSectionLink = gridReference.down('#assignSectionforCourseLink');
            	 assignSectionLink.setVisible(false);
            	 Ext.each(permissionList, function(privilege) {
            		 if (privilege === 'ASSIGN_SECTION') {
            			 if(!isNullOrEmpty(assignSectionLink)){
            				 assignSectionLink.setVisible(true);
            			 }        		
            		 }
            	 });
             },
             
             loadDFRForSingleCourseProgram :function(evalutionCombo){
            	 var $this = this;
            	 Ext.Ajax.request({
            		 type : 'rest',
            		 async : false,
            		 url : SERVERURL.COMMON_FORM_FIELD_INFO,
            		 params : {
            			 screenName : 'createcoursesectionform',
            			 academyLocationId : this.getCurrentAcademyLocation(),
            			 languageCode : 'en'
            		 },
            		 method : 'GET',
            		 success : function(res, action) {
            			 var response = Ext.decode(res.responseText);
            			 if (Object.keys(response).length > 0) {
            				 var records = response.createcoursesectionform;
            				 for (i in records) {
            					 if (records[i].formFieldInputType == 'customcombobox'&& records[i].formFieldId =='evalutionPlan' && records[i].isVisible) {
            						 evalutionCombo.show();
            					 }
            				 }
            			 }
            		 }
            	 });


             },
             getCapacityForCourseWin:function(obj,record){
            	 var roomId = record[0].get("id");
            	 var courseSectionForm = this.getCreatecoursesectionform().getForm();	
            	 Ext.Ajax.request({
            		 type : 'rest',
            		 url :SERVERURL.FIND_INTERNAL_RESOURCE_BY_ID,
            		 params : {
            			 id:roomId
            		 },
            		 method : 'GET',
            		 success : function(form, action) {
            			 var resData = 	Ext.JSON.decode(form.responseText);
            			 var resourceBookingPurposes = resData.resourceBookingPurposes;
            			 var acadmicFlag = false;
            			 for(var i=0; i<resourceBookingPurposes.length;i++){

            				 if(resourceBookingPurposes[i].bookingPurpose.value == 'Academic'){
            					 acadmicFlag = true;
            					 var capacity = resourceBookingPurposes[i].capacity;
            					 obj.nextSibling().setValue(capacity);
            				 }

            			 }
            			 if(!acadmicFlag){
            				 courseSectionForm.findField('preDefinedAssignHomeRoom').reset();
            				 courseSectionForm.findField('preDefinedMaxCapacity').reset();
            				 showWarningMessage(getCommonTranslation('ALERT'),getCourseTxCommonTranslation('ACADMIC_ROOM_MSG'));
            			 }
            		 }
            	 });
             },
             getCapacityForAddCourseWin:function(obj,record){
            	 var roomId = record[0].get("id");
            	 var courseSectionForm = this.getCreatecoursesectionform().getForm();    
            	 Ext.Ajax.request({
            		 type : 'rest',
            		 url :SERVERURL.FIND_INTERNAL_RESOURCE_BY_ID,
            		 params : {
            			 id:roomId
            		 },
            		 method : 'GET',
            		 success : function(form, action) {
            			 var resData =     Ext.JSON.decode(form.responseText);
            			 var resourceBookingPurposes = resData.resourceBookingPurposes;
            			 var acadmicFlag = false;
            			 for(var i=0; i<resourceBookingPurposes.length;i++){

            				 if(resourceBookingPurposes[i].bookingPurpose.value == 'Academic'){
            					 acadmicFlag = true;
            					 var capacity = resourceBookingPurposes[i].capacity;
            					 obj.nextSibling().setValue(capacity);    
            				 }

            			 }
            		 }
            	 });
             },


             getUserDefineCapacityForCourseWin:function(obj,record){
            	 var roomId = record[0].get("id");
            	 var courseSectionForm = this.getCreatecoursesectionform().getForm();	
            	 Ext.Ajax.request({
            		 type : 'rest',
            		 url :SERVERURL.FIND_INTERNAL_RESOURCE_BY_ID,
            		 params : {
            			 id:roomId
            		 },
            		 method : 'GET',
            		 success : function(form, action) {
            			 var resData = 	Ext.JSON.decode(form.responseText);
            			 var resourceBookingPurposes = resData.resourceBookingPurposes;
            			 var acadmicFlag = false;
            			 for(var i=0; i<resourceBookingPurposes.length;i++){

            				 if(resourceBookingPurposes[i].bookingPurpose.value == 'Academic'){
            					 acadmicFlag = true;
            					 var capacity = resourceBookingPurposes[i].capacity;
            					 courseSectionForm.findField('usrDefinedMaxCapacity').setValue(capacity);	
            				 }

            			 }
            			 if(!acadmicFlag){
            				 courseSectionForm.findField('usrDefinedAssignHomeRoom').reset();
            				 courseSectionForm.findField('usrDefinedMaxCapacity').reset();
            				 showWarningMessage(getCommonTranslation('ALERT'),getCourseTxCommonTranslation('ACADMIC_ROOM_MSG'));
            			 }
            		 }
            	 });
             }

});
