/*
 * This controller is used for Department related Actions.   
 */
Ext.define('Academia.controller.department.DepartmentController', {
    extend: 'Academia.controller.base.BaseController',

    models: ['common.IdValueDataModel', 'department.DepartmentModel'],

    stores: ['common.StatusComboStore','department.DepartmentStore', 'department.DepartmentTypeStore', 'department.HeadOfDepartmentStore', 
             'department.AcademyLocationStore', 'department.AssignedAcademyLocationStore', 'department.HODHistoryStore',
             'Academia.store.scholarships.LogedInUserAcademyLocationStore', 'department.AcademyLocationDepartmentStore'],

    views: ['common.StatusCombo','department.Department', 'department.DepartmentGrid', 
            'department.DepartmentFormWindow', 'department.CopyDepartmentWindow', 'department.HODHistoryGrid', 'baselayout.contentarea.ContentPanel'],

    alias: "widget.departmentcontroller",

    refs: [{
        ref: 'grdDepartment',
        selector: 'departmentgrid'
    }, {
        ref: 'winDepartmentForm',
        selector: 'departmentformwindow'
    }, {
        ref: 'winCopyDepartmentWindow',
        selector: 'copydepartmentwindow'
    }, {
        ref: 'departmentForm',
        selector: 'departmentformwindow form[itemId=departmentForm]'
    }, {
        ref: 'grdSubDepartmentGrid',
        selector: 'subdepartmentgrid'
    }, {
        ref: 'grdUnAssignedGrid',
        selector: 'copydepartmentwindow grid[itemId=unassignedAcademyLocationList]'
    }, {
        ref: 'grdAssignedGrid',
        selector: 'copydepartmentwindow grid[itemId=assignedAcademyLocationList]'
    }, {
        ref: 'grdHodHistoryGrid',
        selector: 'hodhistorygrid'
    }, {
        ref: 'contentPanel',
        selector: 'contentPanel'
    },{
        ref: 'department',
        selector: 'department'
    }],
    config: {
        DEPARTMENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ORGANIZATION_DEPARTMENT_PRIVILEGES')
    },
    init: function(application) {
        this.control({
            'departmentformwindow combo': {
                render: this.onDepartmentFormWindowRender
            },
            
            'departmentgrid button[itemId=btnAdd]': {
                click: this.addDepartment
            },
            'departmentformwindow button[itemId=btnSaveDepartmentForm]': {
                click: this.saveDepartment
            },
            'departmentgrid button[itemId=btnDelete]': {
                click: this.deleteDepartment
            },
            'departmentgrid #spBtnMoreActions menuitem[itemId=btnCopyDepartment]': {
                click: this.showCopyDepartmentWindow
            },
            'departmentgrid #spBtnMoreActions menuitem[itemId=hodHistoryMenu]': {
                click: this.hodHistoryMenuClicked
            },
            'copydepartmentwindow button[itemId=btnCopyToLeft]': {
                click: this.moveToLeft
            },
            'copydepartmentwindow button[itemId=btnCopyToRight]': {
                click: this.moveToRight
            },
            'copydepartmentwindow button[itemId=btnCopyDepartmentWindow]': {
                click: this.copyDepartmentToAcademyLoction
            },
            'copydepartmentwindow button[itemId=btnCancelCopyDepartmentWindow]': {
                click: this.cancelCopyDepartmentWindow
            },
            'departmentgrid button[itemId=btnEdit]': {
                click: Ext.bind(this.editDepartment, this, [false])
            },
            'departmentgrid button[itemId=btnView]': {
                click: Ext.bind(this.editDepartment, this, [true])
            },
            'departmentformwindow button[itemId=btnCancelDepartmentForm]': {
                click: this.canceldepartment
            },
            'departmentgrid': {
                select: this.selectDepartmentGridRecord,
                cellclick: this.linkClicked,
                render: function(component, options) {
                    component.getStore().load();
                    this.doAccessControlValidation(component, this.getDEPARTMENT_PERMISSIONS());
            		this.disableMoreActionPivileges(component,this.getDEPARTMENT_PERMISSIONS());
                }
            },
            'departmentformwindow textfield[itemId=shortCode]':{
	 			   blur:function(obj,value){
     				 if(obj.readOnly!=true && !isNullOrEmpty(obj.getValue())){
     					 var getUrl =  SERVERURL.PATH_CHECK_DUPLICATE_SHORTCODE;
     					 Ext.Ajax.request({
     						 method: "GET",
     						 type: 'rest',
     						 url: getUrl,
     						 params: {
     							shortCode: obj.getValue()
     						 },
     						 success:function(response, action){
     							 if(response.responseText == false  || response.responseText == "false"){
     								 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DUPLICATE_DEPARTMENT_SHORT_CODE'));
     								 obj.reset();
     								 return false
     							 }else{
     								 return true;
     							 }
     						 }
     					 }); 
     				 }
     			 }
	 		   }
            /*'departmentgrid[itemId=departmentgrid]': {
            	render: function(grid){
            		this.doAccessControlValidation(grid, this.getDEPARTMENT_PERMISSIONS());
            		this.disableMoreActionPivileges(grid,this.getDEPARTMENT_PERMISSIONS());
            	}
            }*/
        });
    },

    /**
     * This is the function to add HOD History tab on main content panel.
     * 
     */
    linkClicked:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    	var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
    	if(columnName == "id"){
    		if(e.target.tagName=='A'){
    			this.hodHistoryMenuClicked();
    		}
    	}
    },
    hodHistoryMenuClicked: function() {
        //var cellData=td.childNodes[0].childNodes[0].innerHTML;  //check Cell Data
        //if(cellData!=undefined && cellData!=="" && cellData==="HOD History"){
        var me = this;
        var grid = me.getGrdDepartment();
        if (grid.getSelectionModel().getCount() > 0) {

            var contentpanel = me.getContentPanel();
            var hodhistorygrid = Ext.widget('hodhistorygrid');

            var records = grid.getSelectionModel().getSelection();
            if (records != "" && records != null && records != undefined) {
                var rec = new Academia.model.department.DepartmentModel(records[0].data);
                if (rec.data.id !== "" && rec.data.id != undefined) {
                    var tabName = rec.get("name") + " - " + getCommonTranslation('HOD_HISTORY');
                    openTab(contentpanel, tabName, hodhistorygrid, CONSTANTS.MENU_COLOR_THIRTEEN);
                    var criteria = new Object();
                    criteria.id = rec.get("id");
                    var grid =  me.getGrdHodHistoryGrid();
                    var store = grid.getStore();
                    store.getProxy().extraParams=criteria;
                    store.load();
                    grid.down('pagingtoolbar').moveFirst();
                }
            }
        } else {
        	showWarningMessage(getCommonTranslation('DEPARTMENT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
        //                                }                                                                                                                                                                                                                                                                                                                                                                                                                              
    },


    /**
     * This is the function to initialize the stores after the components are displayed on the screen.
     * 
     */
    onDepartmentFormWindowRender: function(component, options) {
	                     
    	var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
    	var me = this;
    	 var departmentForm = me.getDepartmentForm();
    	  var acdLocCmb=departmentForm.down('#academyLocationId');
    	  acdLocCmb.getStore().loadData(academyLocationList);
          component.getStore().load();
    },

    /*
     * This function is used for to move data from right to Left
     */
    moveToLeft: function() {

        var assignedgrid = this.getGrdAssignedGrid();
        var unAssignedGrid =this.getGrdUnAssignedGrid();
        var unAssignedGridStore = this.getGrdUnAssignedGrid().getStore();
        var assignedGridStore = this.getGrdAssignedGrid().getStore();

        var selectedRowCount = assignedgrid.getSelectionModel().getCount();
        if (selectedRowCount > 0) {
            var records = assignedgrid.getSelectionModel().getSelection();
            for (var recordCount = 0; recordCount < records.length; recordCount++) {
                var model = new Academia.model.common.IdValueDataModel();
                model.data.id = records[recordCount].data.id;
                model.data.value = records[recordCount].data.value;
                unAssignedGridStore.add(model);
                assignedGridStore.remove(records[recordCount]);
            }
            var totalRecordDisplayFieldAssign=assignedgrid.down('#totalRecordDisplayField');
            totalRecordDisplayFieldAssign.setValue(getCommonTranslation('TOTAL_RECORDS')+": "+assignedgrid.getStore().getCount());
            var totalRecordDisplayFieldUnAssign=unAssignedGrid.down('#totalRecordDisplayField');
            totalRecordDisplayFieldUnAssign.setValue(getCommonTranslation('TOTAL_RECORDS')+": "+unAssignedGrid.getStore().getCount());
        } else {
        	showWarningMessage(getCommonTranslation('DEPARTMENT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },

    /*
     * This function is used for to move data from left to right
     */
    moveToRight: function() {

        var unAssignedgrid = this.getGrdUnAssignedGrid();
        var unAssignedGridStore = this.getGrdUnAssignedGrid().getStore();
        var assignedGrid = this.getGrdAssignedGrid();
        var assignedGridStore = this.getGrdAssignedGrid().getStore();

        var selectedRowCount = unAssignedgrid.getSelectionModel().getCount();
        if (selectedRowCount > 0) {
            var records = unAssignedgrid.getSelectionModel().getSelection();
            for (var recordCount = 0; recordCount < records.length; recordCount++) {
                var model = new Academia.model.common.IdValueDataModel();
                model.data.id = records[recordCount].data.id;
                model.data.value = records[recordCount].data.value;
                assignedGridStore.add(model);
                unAssignedGridStore.remove(records[recordCount]);
            }
            
            var totalRecordDisplayFieldUnAssign=unAssignedgrid.down('#totalRecordDisplayField');
            totalRecordDisplayFieldUnAssign.setValue(getCommonTranslation('TOTAL_RECORDS')+": "+unAssignedgrid.getStore().getCount());

            var totalRecordDisplayFieldAssign=assignedGrid.down('#totalRecordDisplayField');
            totalRecordDisplayFieldAssign.setValue(getCommonTranslation('TOTAL_RECORDS')+": "+assignedGrid.getStore().getCount());
        } else {
        	showWarningMessage(getCommonTranslation('DEPARTMENT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },

    /*
     * This function is used for to display the Add dialog box for departments.
     */
    addDepartment: function() {
        this.getGrdDepartment().showDepartmentForm();

                      var departmentForm=this.getDepartmentForm();
                      Ext.Ajax.request({
                         type: 'rest',
                         url: SERVERURL.FIND_BY_ENTITY_ID,                             
                         method: 'GET',
                         params: {
                             entityId: 17
                         },
                         success: function(response,form, action) {
                             if(!isNullOrEmpty(response.responseText)){
                                 var responseObject =  Ext.JSON.decode(response.responseText);                                  
                                 if(!isEmpty(responseObject)){
                                     var shortCode = departmentForm.down("#shortCode");
                                     if(responseObject.whetherManualId){
                                         shortCode.setReadOnly(false);
										 shortCode.emptyText=' ';
									     shortCode.allowBlank=false;
										 shortCode.labelSeparator +='<span class="required" style="color:red"> *</span>';
										 shortCode.setFieldLabel(shortCode.fieldLabel);
										 shortCode.applyEmptyText();
                                     }else{
										 shortCode.setReadOnly(true);
									     shortCode.allowBlank=true;
										 shortCode.emptyText= getCommonTranslation('ID_AUTOGENERATE');
										 shortCode.applyEmptyText();
	
                                    }
                                 }
                             }                                                     
                         }                
                     });
    },


    editDepartment: function(isView) {
        var me = this;
        var grid = me.getGrdDepartment();
        if (grid.getSelectionModel().getCount() > 0) {
            me.getGrdDepartment().showDepartmentForm();
            var records = grid.getSelectionModel().getSelection();
            if (records != "" && records != null && records != undefined) {
            	var departmentForm = me.getDepartmentForm();
            	if(!isNullOrEmpty(records[0].data.hodFromDate)) {
            		records[0].data.hodFromDate = new Date(records[0].data.hodFromDate);
            	}
            	if(!isNullOrEmpty(records[0].data.hodToDate)) {
            		records[0].data.hodToDate = new Date(records[0].data.hodToDate);
            	}
            	departmentForm.loadRecord(records[0]);
            	if (records[0].data.headOfDepartment != null) {
            		departmentForm.down('#cmbHod').setValue(records[0].data.headOfDepartment.id);
            	}
               //V2D-342342
            //	departmentForm.down('#shortCode').setReadOnly(true);
            	departmentForm.down('#academyLocationId').setValue(records[0].data.academyLocationId);
            	departmentForm.down('#cmbDeptType').setValue(getCommonTranslation(records[0].data.departmentType));
            	if (isView) {
            		var winDepartmentFormWindow = me.getWinDepartmentForm();
            		winDepartmentFormWindow.down('#btnSaveDepartmentForm').setVisible(false);
            		toggleReadOnlyFormItems(departmentForm.getForm(), true);
            	}
            }
        } else {
        	showWarningMessage(getCommonTranslation('DEPARTMENT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },

    /*
     * This function is used for to show dialog box of copy selected department to other academy locations.
     */
    showCopyDepartmentWindow: function() {
        var me = this;
        var grid = me.getGrdDepartment();
        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection();
            if (records != "" && records != null && records != undefined) {
                var rec = new Academia.model.department.DepartmentModel(records[0].data);
                if (rec.data.id !== "" && rec.data.id != undefined) {
                    grid.showCopyDepartmentWindow();
                    me.getGrdUnAssignedGrid().getStore().load({
                        params: {
                            id: rec.get("id")
                        }
                    });
                    me.getGrdAssignedGrid().getStore().removeAll();
                }
            }
        } else {
        	showWarningMessage(getCommonTranslation('DEPARTMENT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },

    /*
     * This function is used for to copy/assign selected department to other selected academy locations.
     */
    copyDepartmentToAcademyLoction: function() {
        var me = this;
        var grid = me.getGrdDepartment();
        var assignedGrid = me.getGrdAssignedGrid();
        var winCopyDepartmentWindow = this.getWinCopyDepartmentWindow();
        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection();
            if (records != "" && records != null && records != undefined) {
                var rec = new Academia.model.department.DepartmentModel(records[0].data);
                if (rec.data.id !== "" && rec.data.id != undefined) {

                    var sendData = new Object();
                    sendData.id = rec.data.id; //selected department Id

                    var assignedAcadLocIds = new Array();
                    var assignedAcadLocRecords = new Ext.util.HashMap();
                    var count = 0,
                        key = "";
                    assignedGrid.getStore().each(function(record) { //keep all assigned record in hashmap with academy location id and name   
                        //record.fields.each(function(field)  
                        //{  										     
                        assignedAcadLocIds.push(record.get("id"));
                        key = "record" + count;
                        assignedAcadLocRecords.add(key, {
                            "id": record.get("id"),
                            "name": record.get("value")
                        });
                        count++;
                        //});
                    });

                    sendData.ids = assignedAcadLocIds; //all assigned grid Ids for selected department Id									
                    var jsonFormatData = Ext.encode(sendData);
                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.DEPARTMENT_COPY, //URL-rest/department/copy	
                        jsonData: jsonFormatData,
                        method: 'POST',
                        success: function(response, form, action) {
                            winCopyDepartmentWindow.close();
                            grid.getStore().reload();
                            var responseObject = eval("(" + response.responseText + ")"); //make object of response text
                            var successAcadLocString = "",
                                failureAcadLocString = "",
                                msg = "";
                            for (var acadLocCount = 0; acadLocCount < assignedAcadLocRecords.length; acadLocCount++) {
                                for (var successAcadLocCount = 0; successAcadLocCount < responseObject.ids.length; successAcadLocCount++) {
                                    if (assignedAcadLocRecords.get("record" + acadLocCount).id == responseObject.ids[successAcadLocCount]) {
                                        break; //check assigned academy location id with successfully processed response id
                                    }
                                }
                                if (successAcadLocCount == responseObject.ids.length) {
                                    failureAcadLocString += assignedAcadLocRecords.get("record" + acadLocCount).name + ",";
                                } else {
                                    successAcadLocString += assignedAcadLocRecords.get("record" + acadLocCount).name + ",";
                                }
                            }
                            if (successAcadLocString.length > 0) {
                                successAcadLocString = successAcadLocString.substring(0, successAcadLocString.length - 1);
                                msg += getCommonTranslation('COPY_DEPT_SUCCESS_MSG') + ' <br><b>' + successAcadLocString + '</b><br><br>'; //Department successfully copied to below academy locations
                            }
                            if (failureAcadLocString.length > 0) {
                                failureAcadLocString = failureAcadLocString.substring(0, failureAcadLocString.length - 1);
                                msg += getCommonTranslation('COPY_DEPT_FAILURE_MSG') + ' <br><b>' + failureAcadLocString + '</b><br><br>'; //Department not copied to below academy locations
                            }
                            if (msg.length > 0) {
                               showSuccessMessage(getCommonTranslation('COPY_DEPARTMENT_TO_ACADLOC'), msg); //Copy Department to Academy Location
                            }
                        },
                        failure: function(response, form, action) {
                            winCopyDepartmentWindow.close();
                        }
                    });
                }

            }
        }
    },

    /*
     * This function is used for to close dialog box of copy selected department to other academy locations.
     */
    cancelCopyDepartmentWindow: function() {
        this.getWinCopyDepartmentWindow().close();
    },

    /*
     * This function is used for to delete department after click on delete button.
     */
    deleteDepartment: function() {
    	var me=this;
        var grid = this.getGrdDepartment();
        var subGrid = this.getGrdSubDepartmentGrid();
        var grdStore = grid.getStore();
        var records = grid.getSelectionModel().getSelection();
        if (records != "" && records != null && records != undefined) {
            var rec = new Academia.model.department.DepartmentModel(records[0].data);
        }
        if (grid.getSelectionModel().getCount() > 0) {
        		showConfirmMessage(getCommonTranslation('DEPARTMENT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn, text) {

                    if (btn == 'ok'|| btn == 'yes') {

                    	var isSubDept=me.hasSubDepartment(rec);
                    	if(isSubDept===false){
                        if (grid.getSelectionModel().getCount() > 0) {
                            var records = grid.getSelectionModel().getSelection();
                            for (var count = 0; count < records.length; count++) {
                                var id = "";
                                if (records[count].get("id") != "" && records[count].get("id") != undefined && records[count].get("id") != null) {
                                    id = records[count].get("id");
                                }
                                Ext.Ajax.request({
                                    type: 'rest',
                                    method: 'DELETE',
                                    url: SERVERURL.DEPARTMENT_DELETE, //URL-rest/department/delete					
                                    headers: {
                                        'Content-Type': 'application/json'
                                    },
                                    params: {
                                        id: id
                                    },
                                    success: function(form, action) {
                                    	if(form.responseText == 'HOD_HISTORY_EXIST'){
                                    		showWarningMessage(getCommonTranslation('DEPARTMENT'), getCommonTranslation('HOD_HISTORY_EXIST'));
                                    	}else if(form.responseText == 'PROGRAM_EXIST') {
                                    		showWarningMessage(getCommonTranslation('DEPARTMENT'), getCommonTranslation('PROGRAM_EXIST'));
                                    	} else if(form.responseText == 'COURSE_EXIST') {
                                    		showWarningMessage(getCommonTranslation('DEPARTMENT'), getCommonTranslation('COURSE_EXIST'));
                                    	}else {
                                        grdStore.reload();
                                        subGrid.getStore().reload();
                                        showInfoMessage(getCommonTranslation('DEPARTMENT'), getCommonTranslation('DELETE_DEPARTMENT_MSG')); //Department deleted successfully
                                    	}
                                    },
                                    failure: function(form, action) {
                                        showWarningMessage(getCommonTranslation('DEPARTMENT'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
                                    }
                                });
                            }
                        }
                    }else{
                    	showWarningMessage(getCommonTranslation('DEPARTMENT'), getCommonTranslation('SUB_DEPT_EXIST'));
                    	
                    }
                }
                });
         } else {
        	showWarningMessage(getCommonTranslation('DEPARTMENT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },

    /*
     * This function is used for to save/update department after click on add/update buttons.
     */
    saveDepartment: function(model, records) {
        var me = this;
        var winDepartmentForm = this.getWinDepartmentForm();
        var grid = this.getGrdDepartment();
        var grdStore = this.getGrdDepartment().getStore();
        var departmentForm = this.getDepartmentForm();
        var loadedRecord = new Academia.model.department.DepartmentModel(departmentForm.getValues());
        //var checkDuplicate=this.checkDuplicate(loadedRecord);
        //if(checkDuplicate==true){
        //Ext.Msg.alert('Department','Department already exits with the same name.');
        //}else{
        var submitUrl, isUpdate = false;
        var hasSubDept = this.checkSubDepartments(model, records);
        var departmentHiddenField = departmentForm.down('#department_hidden_field');
        var allowSub = departmentForm.getValues().hasSubDepartment;
        if (departmentHiddenField.getSubmitValue() == null || departmentHiddenField.getSubmitValue() == "" || departmentHiddenField.getSubmitValue() === undefined) {
            submitUrl = SERVERURL.DEPARTMENT_CREATE; //URL-rest/department/create
            isUpdate = false;
        } else {
            submitUrl = SERVERURL.DEPARTMENT_UPDATE; //URL-rest/department/update
            isUpdate = true;
        }
        
        
        
        var jsonFormatFormData = this.createJsonFormat(departmentForm, records, isUpdate);
        if (!isUpdate || allowSub == 'on' || (isUpdate && hasSubDept == "false" && allowSub != 'on') || (isUpdate && hasSubDept == "false") || (isUpdate == true && hasSubDept == "true" && allowSub == "true")) {
            Ext.Ajax.request({
                type: 'rest',
                url: submitUrl,
                jsonData: jsonFormatFormData,
                method: 'POST',
                success: function(form, action) {
                    winDepartmentForm.close();
                    me.checkSubDepartmentFunctionality(loadedRecord, me);
                    grid.getSelectionModel().clearSelections();
                    grdStore.reload();
                    if (isUpdate) {
                    	showInfoMessage(getCommonTranslation('DEPARTMENT'), getCommonTranslation('UPDATE_DEPARTMENT_MSG')); //Department updated successfully
                    } else {
                    	showInfoMessage(getCommonTranslation('DEPARTMENT'), getCommonTranslation('ADD_DEPARTMENT_MSG')); //Department added successfully
                    }
                },
                failure: function(form, action) {
                    winDepartmentForm.close();
                    grdStore.reload();
                }
            });
        } else {
        	showInfoMessage(getCommonTranslation('DEPARTMENT'), getCommonTranslation('SUB_DEPARTMENT_EXIST_MSG')); //There are already subdepartment(s) exits
        }
        //						}																	
    },


    /*
     * This function is used for to check sub department 
     */
    checkSubDepartments: function(model, records) {
        var departmentForm = this.getDepartmentForm();
        var hasSub = false;
        var departmentHiddenField = departmentForm.down('#department_hidden_field').getSubmitValue();
        Ext.Ajax.request({
            type: 'rest',
            async: false,
            method: 'GET',
            url: SERVERURL.DEPARTMENT_CHECK_SUBDEPARTMENT, //URL-rest/department/checkSubDepartments
            params: {
                id: departmentHiddenField
            },
            success: function(form, action) {
                hasSub = form.responseText;
            }
        });
        return hasSub;
    },

    /*
     * This function is used for create Json Format for submitting json data to server 
     */
    createJsonFormat: function(departmentForm, records, isUpdate) {
        var formDataValues = departmentForm.getValues();
        var cmbDepartmentType = departmentForm.down('#cmbDeptType');
        var cmbStatus = departmentForm.down('#cmbStatus');
        var cmbHOD = departmentForm.down('#cmbHod');
        var cmbAcadLoc = departmentForm.down('#academyLocationId');
        var values = new Object();
        if (isUpdate && formDataValues.id != "" && formDataValues.id != null && formDataValues.id != undefined) {
            values.id = formDataValues.id[0];
        }
        //values.departmentType = cmbDepartmentType.getRawValue();
        var indx =  cmbDepartmentType.getStore().find('value',cmbDepartmentType.getRawValue());
        var cmbSelectedRec = cmbDepartmentType.getStore().getAt(indx);
        values.departmentType = cmbSelectedRec.get('id');
        values.status = cmbStatus.getValue();
        values.headOfDepartment = {
            id: cmbHOD.getValue(),
            value: cmbHOD.getRawValue()
        };
        values.hodFromDate = formDataValues.hodFromDate;
        values.hodToDate = formDataValues.hodToDate;
        values.academyLocationId = cmbAcadLoc.getValue();
        values.shortCode = formDataValues.shortCode;
        values.serialId = formDataValues.serialId;
        values.name = formDataValues.name;
        values.hasSubDepartment = formDataValues.hasSubDepartment;
        var formData = Ext.encode(values);
        return formData;
    },

    /*
     * This function is used for to Enable or dissable sub department functionality after checking form sub department value   
     */
    checkSubDepartmentFunctionality: function(record, me) {
        var grdSubDepartmentGrid = me.getGrdSubDepartmentGrid();
        var hasSubDepartment = record.get("hasSubDepartment");
        if (hasSubDepartment != undefined && hasSubDepartment !== "" && (hasSubDepartment == true || hasSubDepartment === 'true')) {
            grdSubDepartmentGrid.down('#btnAdd').setDisabled(false);
            grdSubDepartmentGrid.down('#btnEdit').setDisabled(false);
            grdSubDepartmentGrid.down('#btnView').setDisabled(false);
            grdSubDepartmentGrid.down('#btnDelete').setDisabled(false);
        } else {
            grdSubDepartmentGrid.down('#btnAdd').setDisabled(true);
            grdSubDepartmentGrid.down('#btnEdit').setDisabled(true);
            grdSubDepartmentGrid.down('#btnView').setDisabled(true);
            grdSubDepartmentGrid.down('#btnDelete').setDisabled(true);
        }
    },

    /*
     * This function is used for to close department Dialog box 
     */
    canceldepartment: function() {
        this.getWinDepartmentForm().close();
    },

    /*
     * This function is used for to reload Sub Departments grid after selecting record from Department grid    
     */
    selectDepartmentGridRecord: function(obj, record, index, opts) {
        var me = this;
        if (record != "" && record != null && record != undefined) {
        	
        	var departmentGrid = this.getGrdDepartment();
            var hasSubDepartment = record.get("hasSubDepartment");
            var hasChildDepartment = record.raw.hasChildDepartment;
            if ((hasSubDepartment != undefined && !isNullOrEmpty(hasSubDepartment) && (hasSubDepartment == true || hasSubDepartment === 'true') && hasChildDepartment == true) || hasChildDepartment == true) {
//            	departmentGrid.down('#btnEdit').setDisabled(true);
            	departmentGrid.down('#btnDelete').setDisabled(true);
            } else {
//            	departmentGrid.down('#btnEdit').setDisabled(false);
            	departmentGrid.down('#btnDelete').setDisabled(false);
            }
            
            /****** Enable or dissable sub department functionality after checking form sub department value ***/
            me.checkSubDepartmentFunctionality(record, me);
            this.getGrdSubDepartmentGrid().getStore().reload({
                id: record.get("id"),
                callback:function(response, form, action) {
                  //me.getDepartment().body.setScrollTop(0);
            }
            });
        }
    },

    /*
     *This function is used for to check duplicate departname name 
     */
    checkDuplicate: function(record) {
        var deptName = record.get("name");
        var academyLocationId = record.get("academyLocationId");
        var isExist = false;
        Ext.Ajax.request({
            type: 'rest',
            async: false,
            url: SERVERURL.DEPARTMENT_CHECKDUPLICATE, //URL-rest/department/checkDuplicate
            params: {
                deptName: deptName,
                academyLocationId: academyLocationId
            },
            method: 'GET',
            success: function(response, form, action) {
                var responseObject = eval("(" + response.responseText + ")");
                if (responseObject == true) {
                    isExist = true;
                }
            },
            failure: function(response, form, action) {
            	showWarningMessage(getCommonTranslation('DEPARTMENT'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
            }
        });
        return isExist;
    },
    
    /*
     *This function is used for to check subdepartments 
     */
    hasSubDepartment: function(record) {
        var deptId = record.get("id");
        var isExist = false;
        Ext.Ajax.request({
            type: 'rest',
            async: false,
            url: SERVERURL.CHECK_SUB_DEPTS, //URL-rest/department/checkSubDepartments
            params: {
                id: deptId
            },
            method: 'GET',
            success: function(response, form, action) {
                var responseObject = eval("(" + response.responseText + ")");
                if (responseObject == true) {
                    isExist = true;
                }
            },
            failure: function(response, form, action) {
            	showWarningMessage(getCommonTranslation('DEPARTMENT'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
            }
        });
        return isExist;
    },
    /**
     * method to get the currently selected/default academy location.
     * @returns the value of the current academy location.
     */
	getCurrentAcademyLocation:function(){
		return Ext.ComponentQuery.query('customcombobox#cmbGlobalAcademyLocation');
	},
	/**
     * @author Pravin.Surve
     * This function is to enable more action button
     */
    disableMoreActionPivileges: function(gridReference,permissionsMap) {
       	var associatedAcadLocationIds = new Array();
   		associatedAcadLocationIds.push(Ext.ComponentQuery.query('customcombobox#cmbGlobalAcademyLocation')[0].getValue()); 
   		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
   		var grid = this.getGrdDepartment();
   		var moreButton = grid.down("#spBtnMoreActions");//itemId of split button
//   		var copyButton = grid.down('#btnCopyDepartment');
       	
   		moreButton.setVisible(false);
//   		copyButton.setVisible(false);
       	 
       	Ext.each(permissionList, function(privilege) {
       		if (privilege === 'MOREACTIONS') {
           		if(!isNullOrEmpty(moreButton)){
           			moreButton.setVisible(true);//enable more action button
           		}        		
           	}/*else if(privilege === 'COPY') {
           		if(!isNullOrEmpty(copyButton)){
           			copyButton.setVisible(true);
           		}
           	}*/
       	});
       }
});
