/**
 * @author Ramkrishna Yadav
 * 
 */
Ext.define('Academia.controller.election.election.ElectionController', {
	extend: 'Academia.controller.base.BaseController',
	
	models : ['election.election.ElectionModel','election.election.ElectionCandidateGridDataModel','election.election.ElectionVoterPoolGridDataModel',
'election.election.ElectionCandidateInfoGridDataModel','election.election.ElectionExternalUserGridDataModel','department.DepartmentModel',
'common.IdValueCodeDataModel','election.election.ElectionAlbumModel','election.election.SPElectionModel','election.election.ElectionVotingPoolStatusModel'],
	stores : ['common.AcademicTermStoreForIntakeYearId','election.election.ElectionCodeNameStore','election.election.ElectionTypeStore',
		'common.StatusComboStore','election.election.ElectionGridStore','election.election.VootingPoolStore',
		'election.election.ElectionCandidateGridStore','election.election.ElectionVoterPoolGridStore',
'department.ParentDepartmentByAccesibleStore','common.CountryStore','feeandpayment.managebill.Student',
'coursetransaction.sectionmanagement.EmployeeIdValueSmartSearch','election.election.ElectionCandiateListStore',
'election.election.ElectionCandidateInfoGridStore','election.election.ElectionStudentNameCode',
'election.election.ElectionStaffNameCode','election.election.ElectionExternalUserVoterPoolGridStore',
'election.election.ElectionStaffVoterPoolGridStore','election.election.ElectionVoterPoolCodeNameStore',
'election.election.ElectionListNameStore','program.ProgramCodeOrNameSmartSearch','program.ProgramByGroupIdStore',
'election.election.ElectionListNameStore','election.election.SPElectionGridStore','election.election.FPElectionGridStore',
'common.VoterPoolStatusComboStore','importutility.ModuleName','hostel.importhostel.ImportHostelAllocation','election.election.ElectionVoterPoolType','messaging.MessagingTemplatesStore',
'committee.committee.MessageTypeNotificationStore','messaging.StaticDocumentAttachmentGridStore','election.election.ElectionVotingPoolStatusStore'],
	views : ['mangeElections.mangeElections.ElectionsTabStructure','mangeElections.mangeElections.ElectionFilter'
		,'mangeElections.mangeElections.ElectionsGrid','mangeElections.mangeElections.ElectionForm',
		'mangeElections.candidate.ElectonCandidateStructure','mangeElections.candidate.CandidateGrid',
		'mangeElections.candidate.CandidateDetailWin','mangeElections.candidate.ElectonVoterPoolStructure','mangeElections.candidate.StudentVoterPoolGrid',
		'mangeElections.candidate.CandidateInfoWin','mangeElections.candidate.CandidatesInformationGrid','mangeElections.candidate.ExternalUserVoterPoolGrid',
		'mangeElections.candidate.ExternalUserVoterPoolDetailWin','mangeElections.candidate.EmployeeVoterPoolGrid','mangeElections.copyElection.CopyElectionWin',
		'mangeElections.candidate.ChangeWeightageWin','personinfo.common.documents.DocumentRemarkFormWin','mangeElections.mangeElections.PrintSheetWindow',
		'studentPortal.Elections.SPElectionsGrid','studentPortal.Elections.StudentVoteInElectionStructure','studentPortal.Elections.StudentVoteInElectionAlbumStructure',
		'studentPortal.Elections.StudentVoteInElectionListStructure','facultyPortal.Elections.FPElectionsGrid',
		'mangeElections.candidate.ElectionVoterPoolLoderStructure','mangeElections.candidate.ImportVoterPoolGrid',
		'mangeElections.candidate.DownloadElectionVoterPool','mangeElections.candidate.ImportVoterPoolUploadForm','mangeElections.candidate.ImportVoterPoolLoaderGrid',
		 'UploadOptionRadioGroup','mangeElections.mangeElections.ElectionVoterPoolSendMessages','mangeElections.mangeElections.ElectionVoterPoolForExternalUserSendMessages','mangeElections.mangeElections.ElectionVoterPoolForStudentSendMessages',
		 'mangeElections.mangeElections.StaffStaticDocumentAttachmentGrid','mangeElections.mangeElections.StduentVoterPoolStaticDocumentAttachmentGrid',
		 'mangeElections.mangeElections.ExternalVoterPoolStaticDocumentAttachmentGrid','mangeElections.mangeElections.ElectionDescriptionWindow','mangeElections.mangeElections.ElectionDescriptionOtherWindow',
		 'mangeElections.mangeElections.ElectionVotingPoolWindow','studentPortal.Elections.SPElectionsStructure'],
	refs : [{
    	ref : 'electionfilter',
    	selector : 'electionfilter'
    },{
    	ref: 'electionsgrid',
    	selector: 'electionsgrid'
    },{
    	ref: 'electionform',
    	selector: 'electionform'
    },{
    	ref: 'electoncandidatestructure',
    	selector: 'electoncandidatestructure'
    },{
    	ref: 'contentPanel',
    	selector: 'contentPanel'
    },{
    	ref: 'candidategrid',
    	selector: 'candidategrid'
    },{
    	ref: 'candidatesinformationgrid',
    	selector: 'candidatesinformationgrid'
    },{
    	ref: 'candidatedetailwin',
    	selector: 'candidatedetailwin'
    },{
    	ref: 'electonvoterpoolstructure',
    	selector: 'electonvoterpoolstructure'
    },{
    	ref: 'studentvoterpoolgrid',
    	selector: 'studentvoterpoolgrid'
    },{
    	ref: 'candidateinfowin',
    	selector: 'candidateinfowin'
    },{
    	ref: 'externaluservoterpoolgrid',
    	selector: 'externaluservoterpoolgrid'
    },{
    	ref: 'externaluserdetailwin',
    	selector: 'externaluserdetailwin'
    },{
    	ref: 'employeevoterpoolgrid',
    	selector: 'employeevoterpoolgrid'
    },{
    	ref: 'copyelectionwin',
    	selector: 'copyelectionwin'
    },{
    	ref: 'changeweightagewin',
    	selector: 'changeweightagewin[itemId=studentchangeweightagewin]'
    },{
    	ref: 'changeweightagewinstaff',
    	selector: 'changeweightagewin[itemId=staffchangeweightagewin]'
    },{
    	ref: 'changeweightagewinexternal',
    	selector: 'changeweightagewin[itemId=externaluserchangeweightagewin]'
    },{
    	ref: 'documentremarkformwin',
    	selector: 'documentremarkformwin'
    },{
    	ref: 'printsheetwindow',
    	selector: 'printsheetwindow'
    },{
		ref:'spelectionsgrid',
		selector:'spelectionsgrid'
	},{
		ref:'studentvoteinelectionstructure',
		selector:'studentvoteinelectionstructure'
	},{
		ref:'studentvoteinelectionalbumstructure',
		selector:'studentvoteinelectionalbumstructure'
	},{
		ref:'studentvoteinelectionliststructure',
		selector:'studentvoteinelectionliststructure'
	},{
    	ref: 'electionvoterpoolloderstructure',
    	selector: 'electionvoterpoolloderstructure'
    },{
    	ref: 'importvoterpoolgrid',
    	selector: 'importvoterpoolgrid'
    },{
    	ref: 'downloadelectionvoterpool',
    	selector: 'downloadelectionvoterpool'
    },{
    	ref: 'importvoterpooluploadform',
    	selector: 'importvoterpooluploadform'
    },{
    	ref: 'importvoterpoolloadergrid',
    	selector: 'importvoterpoolloadergrid'
    },{
   	 ref : 'uploadoptionradiogroup',
	 selector : 'uploadoptionradiogroup[itemId=electionVoterPoolRadioGroupItemId]'
 },{
		ref : 'electionvoterpoolsendmessages',
		selector : 'electionvoterpoolsendmessages[itemId=voterPoolForStaff]'	
	},{
        ref: 'contentpanel',
        selector: 'contentpanel'
    },{
		ref : 'electionvoterpoolforstudentsendmessages',
		selector : 'electionvoterpoolforstudentsendmessages[itemId=voterPoolForStudent]'	
	},{
		ref : 'electionvoterpoolforexternalusersendmessages',
		selector : 'electionvoterpoolforexternalusersendmessages[itemId=voterPoolForExternalUser]'	
	},{
    	ref :'voterPoolStaffDocumentMessageAttachmentGrid',
    	selector : 'staffstaticdocumentattachmentgrid[itemId=voterPoolEmployeeStaticDocumentAttachmentGridMessage]'
    },{
    	ref :'VoterPoolStudentDocumentMessageAttachmentGrid',
    	selector : 'stduentvoterpoolstaticdocumentattachmentgrid[itemId=voterPoolStudentStaticDocumentAttachmentGridMessage]'
    },{
    	ref :'voterPoolExternalUserDocumentMessageAttachmentGrid',
    	selector : 'externalvoterpoolstaticdocumentattachmentgrid[itemId=voterPoolExternalUserStaticDocumentAttachmentGridMessage]'
    },{
      	 ref : 'electiondescriptionwindow',
    	 selector : 'electiondescriptionwindow'
     },
     {
      	 ref : 'electiondescriptionotherwindow',
    	 selector : 'electiondescriptionotherwindow'
     },{
      	 ref : 'electionvotingpoolwindow',
    	 selector : 'electionvotingpoolwindow'
     }],
    config: {
    	TNS_MANAGE_ELECTIONS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TNS_MANAGE_ELECTIONS_PRIVILEGES'),
    	TNS_MANAGE_ELECTIONS_VOTER_POOL_PRIVILEGES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TNS_MANAGE_ELECTIONS_VOTER_POOL_PRIVILEGES'),
    	STUDENT_PORTAL_ELECTIONS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_ELECTIONS_PRIVILEGES'),
    	FACULTY_PORTAL_ELECTIONS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_ELECTIONS_PRIVILEGES'),
    },
    init : function() {
    	this.control({
    	'electionsgrid button[itemId=btnDelete]':{
		click: this.deleteElectionRecord
	},
	'electionsgrid button[itemId=btnAdd]':{
		click: function(button){
		
			this.addelectionRecord('ADD');
		}
	},
	'electionsgrid button[itemId=btnView]':{
		click: this.viewElectionRecord
	},
	'electionsgrid button[itemId=btnEdit]':{
		click: this.editElectionRecord
	},
	'electionform button[itemId=submitBtn]':{
		click: this.saveElectionRecord
	},
	'electionform':{
		afterrender: function(form){
			this.loadDFRForAddressContactDetailVisibility(form);
		
		}},
	'electionsgrid':{
		render: function(grid){
		
			this.doAccessControlValidation(grid, this.getTNS_MANAGE_ELECTIONS_PERMISSIONS());
			this.disableMoreActionPivileges(grid, this.getTNS_MANAGE_ELECTIONS_PERMISSIONS());
		},
		cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
			var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
			var grid1 = this.getElectionsgrid();

			if(record.data.isDeleted==true){
			grid1.down("#btnAdd").setDisabled(true);
			grid1.down("#btnEdit").setDisabled(true);
			grid1.down("#btnView").setDisabled(true);
			grid1.down("#btnDelete").setDisabled(true);
			grid1.down("#condidateLink").setDisabled(true);
			grid1.down("#voterPoolLink").setDisabled(true);
			grid1.down("#printElectionSheetLink").setDisabled(true);
			}else{
				grid1.down("#btnAdd").setDisabled(false);
				grid1.down("#btnEdit").setDisabled(false);
				grid1.down("#btnView").setDisabled(false);
				grid1.down("#btnDelete").setDisabled(false);
				grid1.down("#condidateLink").setDisabled(false);
				grid1.down("#voterPoolLink").setDisabled(false);
				grid1.down("#printElectionSheetLink").setDisabled(false);
			}
			
			if(columnName == "electionDescriptionInEnglish"){
				if (e.target.tagName == 'A') {
				var this$=this;
				var formWindow = this$.getElectiondescriptionwindow();
	                if (!formWindow) {
	                    Ext.widget('electiondescriptionwindow');
	                    formWindow = this$.getElectiondescriptionwindow();
	                }
				formWindow.show();
				var rec = grid1.getSelectionModel().getSelection();
				var data = rec[0].data.electionDescriptionInEnglish;
                var winData = formWindow.down('#electionDescDisplay');
                winData.setValue(data);
				}
			}
			
			if(columnName == 'electionDescriptionInOtherLang'){
				if(e.target.tagName == 'A'){
					var formWindow = this.getElectiondescriptionotherwindow();
					if(!formWindow){
						Ext.widget('electiondescriptionotherwindow');
						formWindow = this.getElectiondescriptionotherwindow();
					}
					formWindow.show();
					var rec = grid1.getSelectionModel().getSelection();
					var data = rec[0].data.electionDescriptionInOtherLang;
	                var winData = formWindow.down('#electionDescOtherDisplay');
	                winData.setValue(data);
				}
			}
			
			if(columnName == 'voterPoolSize'){
				if(e.target.tagName == 'A'){
					var formWindow = this.getElectionvotingpoolwindow();
					if(!formWindow){
						Ext.widget('electionvotingpoolwindow');
						formWindow = this.getElectionvotingpoolwindow();
					}
					formWindow.show();
					var grid=formWindow.down('#votingPoolStatusGrid');
					var rec = grid1.getSelectionModel().getSelection();
					var data = rec[0].data.id;
					var store = grid.getStore();
					store.getProxy().extraParams = {
						electionId : data,
       		    	};
					store.load();
				}
			}
			
		}
	},
	'electionfilter button[itemId=searchBtn]': {
		click: this.loadElectionGrid
	},
	'electionform radiogroup[itemId=isAdminCapture]': {
	    change: function(radioField, newValue, oldValue, eOpts) {
	        var formWin = this.getElectionform();
	        this.onChangeAdminCaptureRadioGroup(formWin, newValue);
	    }
	},
	'electionform radiogroup[itemId=referendum1]': {
	    change: function(radioField, newValue, oldValue, eOpts) {
	        var formWin = this.getElectionform();
	        this.onChangeReferendumRadioGroup(formWin, newValue);
	    }
	},
	'electionform radiogroup[itemId=referendumTwo]': {
	    change: function(radioField, newValue, oldValue, eOpts) {
	        var formWin = this.getElectionform();
	        this.onChangeReferendumTwoRadioGroup(formWin, newValue);
	    }
	},
	'electionfilter button[itemId=resetBtn]': {
		click: this.resetElectionFilter
	},
	'electionsgrid menuitem[itemId=condidateLink]':{
		click : this.getElectionCondidate
	},
	'electionsgrid menuitem[itemId=voterPoolLink]':{
		click : this.getElectionVoterPool
	},
	'electionsgrid menuitem[itemId=copyElectionLink]':{
		click : this.getShowCopyElectionWin
	},
	'candidategrid':{
		render : function(grid){
			this.getRenderCandidate(grid);
		},
		select: function(column, selected) {
			var grid = this.getCandidatesinformationgrid();
    		if(selected.data!=null){ 
    			
    			grid.down('#btnEdit').setDisabled(true);
    			grid.down('#btnDelete').setDisabled(true);
    			grid.down('#btnAdd').setDisabled(false);
    			var  parentRecordId=selected.data.id;
    			
    			this.LoadCandidateInfoGrid(grid, parentRecordId);
    			grid.getSelectionModel().deselectAll();
    			
    		} else {
    			
    			grid.down('#btnAdd').setDisabled(true);
    		}
    	}
	},
	'candidatesinformationgrid':{
		render : function(grid){
			grid.down('#btnEdit').setDisabled(true);
			grid.down('#btnDelete').setDisabled(true);
			grid.down('#btnAdd').setDisabled(true);
			
			 var store = grid.getStore();
			 store.removeAll();
			 this.resetPageSetting(store);
			
			
		},
		select: function() {
			var grid = this.getCandidatesinformationgrid();
    		
    			
    			grid.down('#btnEdit').setDisabled(false);
    			grid.down('#btnDelete').setDisabled(false);
    			grid.down('#btnAdd').setDisabled(false);
    			
    			
    		
    	},
		selectionchange: function(column, selected) {/*
			var grid = this.getCandidategrid();
    		if(selected.length== 1){ 
    			grid.down('#btnEdit').setDisabled(true);
    			grid.down('#btnDelete').setDisabled(true);
    		} else {
    			grid.down('#btnEdit').setDisabled(false);
    			grid.down('#btnDelete').setDisabled(false);
    		}
    	*/}
	},
	
	'studentvoterpoolgrid':{
		render : function(grid){
			this.getRenderVoterPool(grid);
			this.disableChangeWeightagePivileges(grid, this.getTNS_MANAGE_ELECTIONS_VOTER_POOL_PRIVILEGES_PERMISSIONS());

		},
		selectionchange: function(column, selected,eOpts ){
			var grid = this.getStudentvoterpoolgrid();
        	this.disableElectionExtraButton(column,selected,grid);                	
        }
	},
	'externaluservoterpoolgrid':{
		render : function(grid){
			this.getRenderVoterPoolExternal(grid);
			this.disableChangeWeightagePivileges(grid, this.getTNS_MANAGE_ELECTIONS_VOTER_POOL_PRIVILEGES_PERMISSIONS());

		},
	    cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e, eopts) {
	        if (e.target.tagName == 'A') {
	            var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
	            var $this = this;
	            var grid = $this.getExternaluservoterpoolgrid();
	            var record = grid.getSelectionModel().getSelection()[0];
	            if (columnName == 'description') {
	                var formWindow = $this.getDocumentremarkformwin();
	                if (!formWindow) {
	                    Ext.widget('documentremarkformwin');
	                    formWindow = $this.getDocumentremarkformwin();
	                }

	                formWindow.show();
	            //	var disciplinaryactiondocumentlistgrid = formWindow.down('#disciplinaryactiondocumentlistgridItemId');
	                formWindow.setTitle(getCommonTranslation('DESCRIPTION'));
					var portalId = this.getCurrentLoggedPortalId();
	                var remark = record.get("description");
	                var documentRemarkArea = formWindow.down('#documentRemarkItemId');
	                documentRemarkArea.setValue(remark);

	            }
	            if(columnName == 'electionVoterPoolUrl'){
	            	 var $this = this;
	            	 var formWindow = $this.getDocumentremarkformwin();
	            	 var formWindow = $this.getDocumentremarkformwin();
		                if (!formWindow) {
		                    Ext.widget('documentremarkformwin');
		                    formWindow = $this.getDocumentremarkformwin();
		                }
		                formWindow.setTitle(getCommonTranslation('ELECTION_LINK'));
		                formWindow.show();
		            
	            	  var documentRemarkArea = formWindow.down('#documentRemarkItemId');
		                documentRemarkArea.setValue(record.data.electionVoterPoolUrl);
	            	
	            }
	        }else if(e.target.tagName == "DIV"){
	        	 if(columnName == 'electionVoterPoolUrl'){
		            	//$this.copy(record.data.electionVoterPoolUrl);
		            }
	        }
	    },
		selectionchange: function(column, selected,eOpts ){
			var grid = this.getExternaluservoterpoolgrid();
        	this.disableElectionExtraButton(column,selected,grid);                	
        }
	
	},
	'candidategrid button[itemId=btnAdd]' :{
		click : this.getShowCandidateWin
	},
	'candidategrid button[itemId=btnEdit]' :{
		click : this.getEditCandidate
	},
	'candidategrid button[itemId=btnView]' :{
		click : this.getViewCandidate
	},
	'candidategrid button[itemId=btnDelete]' :{
		click : this.getDeleteCandidate
	},
	'candidatedetailwin button[itemId=SubmitBtnCandidate]' :{
		click : this.getSaveCandidateDetail
	},
	'candidatedetailwin button[itemId=CancelBtnCandidate]' :{
		click : this.getCloseCandidateWin
	},
	
	'candidatesinformationgrid button[itemId=btnAdd]' :{
		click : this.getShowCandidateInformationWin
	},
	'candidatesinformationgrid button[itemId=btnEdit]' :{
		click : this.getEditCandidateInfoWin
	},
	'candidatesinformationgrid button[itemId=btnView]' :{
		click : this.getViewCandidate
	},
	'candidatesinformationgrid button[itemId=btnDelete]' :{
		click : this.getDeleteCandidateInfoWin
	},
	
		'electionfilter customcombobox[itemId=academicTerm]':{
		   select:function(obj,rec){
		  var data=rec[0].data.id;  
		  var filterForm=obj.up('form');
		  var $this=this;
		      var academyLocationId = $this.getCurrentAcademyLocation();
		  var serviceName=filterForm.down('#electioncCodeName');
		  serviceName.setDisabled(false);
		  serviceName.reset();
		  serviceName.getStore().getProxy().extraParams={
			  academicTermId:data
		  };
		      serviceName.getStore().load();
		  }
		   },
		   'candidateinfowin button[itemId=SubmitBtnCandidateInfo]' :{
				click : this.getSaveCandidateInfoWin
			},
			'candidateinfowin button[itemId=CancelBtnCandidateInfo]' :{
				click : this.getCloseCandidateInfoWin
			},
		   'candidateinfowin customcombobox[itemId=candidateType]':{

 			   select : function(obj,record){
 				  var win = this.getCandidateinfowin();
		       		var sgForm = win.down('form');
 				  
 				   var staffs = sgForm.getForm().findField('employee');
 				   var studentNameField= sgForm.getForm().findField('studentId');
 				   var applicantNameField = sgForm.down('#externalUserId');
 				   var mobileField = sgForm.down("#mobileNo").reset();
 				   var countryCodeField=sgForm.down("#cellCountryCode").reset();
 				   var emailId = sgForm.down("#emailId").reset();
                   var departmentField=sgForm.getForm().findField('department');
				   var program = sgForm.getForm().findField('program');
				  /* countryCodeField.setReadOnly(false);
     			   mobileField.setReadOnly(false);
     			   emailId.setReadOnly(false);*/
				var type  = record[0].data.id;
 				   if(record[0].data.id=="STUDENTS"){
 						this.loadDFRForCandidateInformation(sgForm,type);
 					 
 					  studentNameField.setVisible(true)
 					   program.setVisible(true)
 					  studentNameField.allowBlank=false
 					  program.allowBlank=false
 					  
 					  applicantNameField.reset();
 					  departmentField.reset();
 					  program.reset();
 					  staffs.reset();
 					  applicantNameField.setVisible(false)
					  staffs.setVisible(false)
					  departmentField.setVisible(false)
					  staffs.allowBlank=true
					  departmentField.allowBlank=true
					  applicantNameField.allowBlank=true

 				   }else if(record[0].data.id=="STAFF_USERS"){
 					  this.loadDFRForCandidateInformation(sgForm,type);
 					  
					  departmentField.setVisible(true)
 					  staffs.setVisible(true)
 					  staffs.allowBlank=false
 					  departmentField.allowBlank=false
					 
 					 applicantNameField.reset();
					 studentNameField.reset();
					 program.reset();
					 departmentField.reset();
 					
 				    	
 				      program.setVisible(false)
 					  applicantNameField.setVisible(false)
					  studentNameField.setVisible(false)
					  studentNameField.allowBlank=true
					  applicantNameField.allowBlank=true
					  program.allowBlank=true
 				   }else if(record[0].data.id=="EXTERNAL_USERS"){
 					  this.loadDFRForCandidateInformation(sgForm,type);
 					 applicantNameField.setVisible(true)
 					  applicantNameField.allowBlank=false
 					 
 					  staffs.reset();
  					 studentNameField.reset();
  					program.reset();
					 departmentField.reset();
					 
					  staffs.setVisible(false)
					  studentNameField.setVisible(false)
					   departmentField.setVisible(false)
					    program.setVisible(false)
					  studentNameField.allowBlank=true
					  staffs.allowBlank=true
					  departmentField.allowBlank=true
 					  program.allowBlank=true
 					 var win = this.getCandidateinfowin();
			       		var sgForm = win.down('form');
          	 
          	   var mobileField = sgForm.down("#mobileNo");
          	   var countryCodeField=sgForm.down("#cellCountryCode");
          	   var emailId = sgForm.down("#emailId");
          	   countryCodeField.setReadOnly(false);
   			   mobileField.setReadOnly(false);
   			   emailId.setReadOnly(false);
   			
				 this.setMaximumMinimumDigitsForMobileNoValidation(sgForm,countryCodeField,mobileField,null);

 				   }
 				
			   }
 		   
		    },
			   
			   'candidateinfowin customcombobox[itemId=studentItemId]' : {
    			   select : function(obj,record){
    				   this.getStudentDetails();
    			   }
    		   },
    		   
    		   'candidateinfowin textfield[itemId=externalUserId]' : {
    			   click : function(obj,record){
    				   this.getExternalUser();
    			   }
    		   },
    		   
    		   
			   'candidateinfowin customcombobox[itemId=employeeId]' : {
    			   select : function(obj,record){
    				   this.getfacultyInfoDetails();
    			   }
    		   },
    		   

				

				'candidateinfowin filefield[itemId=imageUploadField]' : {
				change: function(photoFileImage, value, eOpts) {
		            		value = value.replace('C:\\fakepath\\', '');
		            		var newValue = value.replace(/ +/g, " ").split(' ').join('_');
		            		photoFileImage.setRawValue(newValue);
		            		
		            		var extension = value.substring(value.lastIndexOf('.') + 1).toLowerCase();
		            		if(!isNullOrEmpty(value)){
		            			if (extension == "gif" || extension == "png" || extension == "bmp"
		            				|| extension == "jpeg" || extension == "jpg") {
		            				
		            			}else{
		                			photoFileImage.reset();
		                			showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_VALID_FILE'));
		            			}
		            		}

		            	}
		            },
		            'candidateinfowin customcombobox[itemId=cellCountryCode]': {
		                select: function(rowModel, record) {
		                	 var win = this.getCandidateinfowin();
		 		       		var form = win.down('form');
		                	var countryCodeField = form.down("#cellCountryCode");
		                	var mobileField = form.down("#mobileNo");
		                	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, record);
		                }
		            },
		            'externaluservoterpoolgrid button[itemId=btnAdd]' :{
		        		click : this.getShowExternalUserForm
		        	},
		        	'externaluservoterpoolgrid button[itemId=btnEdit]' :{
		        		click : this.getEditExertnalUser
		        	},
		        	'externaluservoterpoolgrid button[itemId=btnView]' :{
		        		click : this.getViewExertnalUser
		        	},
		        	'externaluservoterpoolgrid button[itemId=btnDelete]' :{
		        		click : this.getDeleteExertnalUser
		        	},
		        	'externaluserdetailwin button[itemId=SubmitBtnExternalUser]' :{
		        		click : this.getSaveExertnalUserDetail
		        	},
		        	'externaluserdetailwin button[itemId=CancelBtnExternalUser]' :{
		        		click : this.getCloseExertnalUserWin
		        	},
		        	
		        	'employeevoterpoolgrid':{
		        		render : function(grid){
		        			this.getRenderVoterPoolEmployee(grid);
		        			this.disableChangeWeightagePivileges(grid, this.getTNS_MANAGE_ELECTIONS_VOTER_POOL_PRIVILEGES_PERMISSIONS());

		        		},
		        		selectionchange: function(column, selected,eOpts ){
		        			var grid = this.getEmployeevoterpoolgrid();
		                	this.disableElectionExtraButton(column,selected,grid);                	
		                }
		        	},
		        	 'electionform datefield[itemId=votingStartDateItemId]':{
			        	 change: function() {
			        		
			        	   var frm = this.getElectionform();
			        	   var votingStartDate = frm.down('#votingStartDateItemId');
			        	   var votingEndDate = frm.down('#votingEndDateItemId');
			  			   var adminCaptureStartDate = frm.down('#adminCaptureStartDateItemId');
			  			  var votingStartTime = frm.down('#votingStartTime');
			  			 var votingEndTime = frm.down('#votingEndTime');
			  			   if(!isNullOrEmpty(votingStartDate.getValue())){
			  				   var joinDate = new Date(votingStartDate.getValue());
			  					  adminCaptureStartDate.setMinValue(joinDate);
				  				  adminCaptureStartDate.validate();
				  				  
				  				 if(votingStartDate.getSubmitValue() == votingEndDate.getSubmitValue()){
				  					votingEndTime.setMinValue(votingStartTime.getValue());
					  				votingEndTime.validate();
				  				 }else{
				  					votingEndTime.setMinValue(null);
				  				 }
			        	 }
			        	 }
			        },
			        'electionform datefield[itemId=votingEndDateItemId]':{
			        	 change: function() {
			        		
			        	   var frm = this.getElectionform();
			        	   var votingStartDate = frm.down('#votingStartDateItemId');
			        	   var votingEndDate = frm.down('#votingEndDateItemId');
			  			   var adminCaptureStartDate = frm.down('#adminCaptureStartDateItemId');
			  			   var votingStartTime = frm.down('#votingStartTime');
			  			   var votingEndTime = frm.down('#votingEndTime');
			  			   if(!isNullOrEmpty(votingStartDate.getValue())){
			  				 
				  				 if(votingStartDate.getSubmitValue() == votingEndDate.getSubmitValue()){
				  					votingEndTime.setMinValue(votingStartTime.getValue());
					  				votingEndTime.validate();
				  				 }else{
				  					votingEndTime.setMinValue(null);
				  				 }
			        	 }
			        	 }
			        },
			        'electionform timefield[itemId=votingStartTime]':{
			        	 change: function() {
			        		
			        	   var frm = this.getElectionform();
			        	   var votingStartTime = frm.down('#votingStartTime');
			  			   var adminCaptureStartTime = frm.down('#adminCaptureStartTime');
			  			   var votingEndTime = frm.down('#votingEndTime');
			  			   var votingStartDate = frm.down('#votingStartDateItemId');
			        	   var votingEndDate = frm.down('#votingEndDateItemId');
			  			   if(!isNullOrEmpty(votingStartTime.getValue())){
			  				 adminCaptureStartTime.setMinValue(votingStartTime.getValue());
			  				adminCaptureStartTime.validate();
			  				 if(votingStartDate.getSubmitValue() == votingEndDate.getSubmitValue()){
				  					votingEndTime.setMinValue(votingStartTime.getValue());
					  				votingEndTime.validate();
				  				 }else{
				  					votingEndTime.setMinValue(null);
				  				 }
			        	 }
			        	 }
			        },
			        'electionform timefield[itemId=votingEndTime]':{
			        	 change: function() {
			        		
			        	   var frm = this.getElectionform();
			        	   var votingStartTime = frm.down('#votingStartTime');
			  			   var votingEndTime = frm.down('#votingEndTime');
			  			   var votingStartDate = frm.down('#votingStartDateItemId');
			        	   var votingEndDate = frm.down('#votingEndDateItemId');
			  			   if(!isNullOrEmpty(votingStartTime.getValue())){
			  				 if(votingStartDate.getSubmitValue() == votingEndDate.getSubmitValue()){
				  					votingEndTime.setMinValue(votingStartTime.getValue());
					  				votingEndTime.validate();
				  				 }else{
				  					votingEndTime.setMinValue(null);
				  				 }
			        	 }
			        	 }
			        },
			        'electionform timefield[itemId=adminCaptureStartTime]':{
			        	 change: function() {
			        	   var frm = this.getElectionform();
			  			   var adminCaptureStartTime = frm.down('#adminCaptureStartTime');
			  			   var adminCaptureEndTime = frm.down('#adminCaptureEndTime');
			  			   if(!isNullOrEmpty(adminCaptureStartTime.getValue())){
			  				 adminCaptureEndTime.setMinValue(adminCaptureStartTime.getValue());
			  				 adminCaptureEndTime.validate();
			        	 }
			        	 }
			        },
			        'electionform datefield[itemId=adminCaptureStartDateItemId]':{
			        	 change: function() {
			        		
			        	   var frm = this.getElectionform();
			        	   var adminCaptureStartDate = frm.down('#adminCaptureStartDateItemId');
			        	   var adminCaptureEndDate = frm.down('#adminCaptureEndDate');
			        	   var adminCaptureStartTime = frm.down('#adminCaptureStartTime');
			  			   var adminCaptureEndTime = frm.down('#adminCaptureEndTime');
				  				 if(adminCaptureStartDate.getSubmitValue() == adminCaptureEndDate.getSubmitValue()){
				  					adminCaptureEndTime.setMinValue(adminCaptureStartTime.getValue());
				  					adminCaptureEndTime.validate();
				  				 }else{
				  					adminCaptureEndTime.setMinValue(null);
				  				 }
			        	 }
			        },
			        'electionform datefield[itemId=adminCaptureEndDate]':{
			        	 change: function() {
			        		
			        	   var frm = this.getElectionform();
			        	   var adminCaptureStartDate = frm.down('#adminCaptureStartDateItemId');
			        	   var adminCaptureEndDate = frm.down('#adminCaptureEndDate');
			        	   var adminCaptureStartTime = frm.down('#adminCaptureStartTime');
			  			   var adminCaptureEndTime = frm.down('#adminCaptureEndTime');
				  				 if(adminCaptureStartDate.getSubmitValue() == adminCaptureEndDate.getSubmitValue()){
				  					adminCaptureEndTime.setMinValue(adminCaptureStartTime.getValue());
				  					adminCaptureEndTime.validate();
				  				 }else{
				  					adminCaptureEndTime.setMinValue(null);
				  				 }
			        	 }
			        },
		        	'copyelectionwin button[itemId=submitBtn]' :{
		        		click : this.getSaveCopyEletions
		        	},
		        	'copyelectionwin button[itemId=CancelBtnCopyElection]' :{
		        		click : this.getCloseCopyElectionWin
		        	},
		        	'studentvoterpoolgrid button[itemId=changeWeightage]' :{
		        		click :this.getShowChangeWeightageWinForStudent
			        			
		        	},
		        	'changeweightagewin[itemId=studentchangeweightagewin] button[itemId=SubmitBtnChangeWeightage]' :{
		        		click : this.getSaveChangeWeightage
		        	},
		        	'changeweightagewin[itemId=studentchangeweightagewin] button[itemId=CancelBtnChangeWeightage]' :{
		        		click : function(){
		        			var this$=this;
		        			var win = this$.getChangeweightagewin();
		        			this.getCloseChangeWeightageWin(win);
		        			}
		        	},
		        	'employeevoterpoolgrid button[itemId=changeWeightage]' :{
		        		click :this.getShowChangeWeightageWinForStaff
		        			
		        	},
		        	'externaluservoterpoolgrid button[itemId=changeWeightage]' :{
		        		click :this.getShowChangeWeightageWinForExternalUser
			        			
		        	},
		        	'changeweightagewin[itemId=staffchangeweightagewin] button[itemId=SubmitBtnChangeWeightage]' :{
		        		click : function(){
		        			var this$=this;
		        			var win = this$.getChangeweightagewinstaff();
		        			this.getSaveChangeWeightageForStaff(win);
		        		}
		        			
		        	},
		        	'changeweightagewin[itemId=externaluserchangeweightagewin] button[itemId=CancelBtnChangeWeightage]' :{
		        		click : function(){
		        			var this$=this;
		        			var win = this$.getChangeweightagewinexternal();
		        			this.getCloseChangeWeightageWin(win);
		        			}
		        	},
		        	'changeweightagewin[itemId=staffchangeweightagewin] button[itemId=CancelBtnChangeWeightage]' :{
		        		click : function(){
		        			var this$=this;
		        			var win = this$.getChangeweightagewinstaff();
		        			this.getCloseChangeWeightageWin(win);
		        		}
		        			
		        	},
		        	'changeweightagewin[itemId=externaluserchangeweightagewin] button[itemId=SubmitBtnChangeWeightage]' :{
		        		click : function(){
		        			var this$=this;
		        			var win = this$.getChangeweightagewinexternal();
		        			this.getSaveChangeWeightageForExternalUser(win);
		        			}
		        	},
		        	'externaluserdetailwin customcombobox[itemId=cellCountryCode]': {
		                select: function(rowModel, record) {
		                	 var win = this.getExternaluserdetailwin();
		 		       		var form = win.down('form');
		                	var countryCodeField = form.down("#cellCountryCode");
		                	var mobileField = form.down("#mobileNo");
		                	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, record);
		                }
		            },
		            'studentvoterpoolgrid button[itemId=btnDelete]' :{
		        		click : this.getDeleteStudentVoterPool
		        	},
		        	'employeevoterpoolgrid button[itemId=btnDelete]' :{
		        		click : this.getDeleteStaffVoterPool
		        	},
		        	'documentremarkformwin button[itemId=cancelBtnRemarkItemId]': {
		            	    click: function() {
		            	        var formWindow = this.getDocumentremarkformwin();
		            	        formWindow.close();
		            	    }
		            	},
		            	
		            	'electionsgrid menuitem[itemId=printElectionSheetLink]': {
		                	   click: function(obj) {
		                			var grid = this.getElectionsgrid();
		                			var record = grid.getSelectionModel().getSelection()[0];
		                		   if (grid.getSelectionModel().getCount() > 0) {
		                			   var this$ = this;
		                			   var window = this$.getPrintsheetwindow();
		                			   if(!window){
		                				   window =Ext.widget('printsheetwindow');
		                			   }
		                			   
		                			   window.show();
		                			   
		                			   var form = window.down('form');
		               				var  voterPoolField = form.down("#voterPoolItemId");
		               				
		               				var store = voterPoolField.getStore();
		               				
		               			var electionId=	record.data.id;
		               				store.getProxy().extraParams={
		               					electionId: electionId
		               				};
		               			
		               			store.load();
		               	    
		                		   } else {
		                			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		                		   }  
		                	   }
		                   },
		                   'printsheetwindow button[itemId=saveBtn]': {
		                  	   click: function(btn) {
		                  		   this.exportPDFEletionPrint();
		                  	   }
		                     },
		                     'spelectionsgrid':{
		                    	 render : function(grid){
		                    		if(portalId == 3 || portalId == 2){
		                    			grid.setTitle(getCommonTranslation("LIST_OF_ELECTIONS"));
		                    		}
		                    		 var person = this.getCurrentlyLoggedInUserWithPersonId();
		                    		 var personId = person.personId;
		                    		 var store = grid.getStore();
		                    		 store.getProxy().extraParams = {
		                    			 personId : personId
		                    		 };
		                    		 store.load();
		                    	 },
		                    	 cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
		                    		 var this$ = this;
		                    		 var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
		                    		 if(columnName == "votingAction"){
		                    			 if(e.target.tagName=='A'){
		                    				 Ext.Ajax.request({
			                    				 method : "GET",
			                    				 type : 'rest',
			                    				 url: SERVERURL.PATH_FIND_ELECTION_STATUS,
			                    				 params: {
			                    					 electionId : record.data.id,
			                    					 voteCaptureBy : "SELF"
			                    				 },
			                    				 headers : {
			                    					 'Content-Type' : 'application/json'
			                    				 },
			                    				 success: function(response) {
			                    					 var data = Ext.decode(response.responseText);
			                    					 if(data=="STARTED"){
			                    						 this$.showVoteInElectionTab(data);
			                    					 }else if(data=="NOT_STARTED"){
			                    						 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ELECTION_NOT_STARTED_YET'));
			                    					 }else if(data=="FINISHED"){
			                    						 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ELECTION_HAS_FINISHED'));
			                    					 }
			                    					 
			                    				 }
			                    			 });
		                    			 }
		                    			

		                    		 }
		                    	 }
		                     },
		                     'studentvoteinelectionwindow button[itemId=cancelBtnElec]':{
									click: function(btn) {
				                  		   this.getStudentvoteinelectionwindow().close();
				                  	   }
								},
								'studentvoterpoolgrid button[itemId=captureBollotVotesBtn]':{
									click: function(btn) {
										var this$ = this;
										var structure = this$.getElectonvoterpoolstructure();
										var electionId =  structure.down("#electionId").getValue();
										var adminCaptureStartDate = dateRender(structure.config.adminCaptureStartDate);
										var adminCaptureStartTime = timeRender(structure.config.adminCaptureStartTime);
										var grid = this$.getStudentvoterpoolgrid();
										if(grid.getSelectionModel().getCount() > 0){
											Ext.Ajax.request({
												method : "GET",
												type : 'rest',
												async: false,
												url: SERVERURL.PATH_FIND_ELECTION_STATUS,
												params: {
													electionId : electionId,
													voteCaptureBy :'BALLOT'
												},
												headers : {
													'Content-Type' : 'application/json'
												},
												success: function(f, action) {
													var data = Ext.decode(f.responseText);
													if(!isNullOrEmpty(data)&&data=="STARTED"){
														this$.showVoteInElectionTab(data);

													}else if(data=="NOT_STARTED"){
			                    						 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BALLOT_VOTING_NOT_STARTED_YET')+', '+getCommonTranslation('START_DATE')+'='+adminCaptureStartDate+', '+getCommonTranslation('START_TIME')+'='+adminCaptureStartTime);
			                    					 }else if(data=="FINISHED"){
			                    						 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BALLOT_VOTING_HAS_FINISHED'));
			                    					 }												
													}
											});	
										}else {
						            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						            	} 
									}
								},
								'employeevoterpoolgrid button[itemId=captureBollotVotesBtn]':{
									click: function(btn) {
										var this$ = this;
										var structure = this$.getElectonvoterpoolstructure();
										var electionId =  structure.down("#electionId").getValue();
										var grid = this$.getEmployeevoterpoolgrid();
										if(grid.getSelectionModel().getCount() > 0){
											Ext.Ajax.request({
												method : "GET",
												type : 'rest',
												async: false,
												url: SERVERURL.PATH_FIND_ELECTION_STATUS,
												params: {
													electionId : electionId,
													voteCaptureBy :'BALLOT'
												},
												headers : {
													'Content-Type' : 'application/json'
												},
												success: function(f, action) {
													var data = Ext.decode(f.responseText);
													if(!isNullOrEmpty(data)&&data=="STARTED"){
														this$.showVoteInElectionTab(data);

													}else if(data=="NOT_STARTED"){
			                    						 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ELECTION_NOT_STARTED_YET'));
			                    					 }else if(data=="FINISHED"){
			                    						 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ELECTION_HAS_FINISHED'));
			                    					 }												}
											});	
										}else {
						            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						            	} 
									}
								},
								'externaluservoterpoolgrid button[itemId=captureBollotVotesBtn]':{
									click: function(btn) {
										var this$ = this;
										var structure = this$.getElectonvoterpoolstructure();
										var electionId =  structure.down("#electionId").getValue();
										var grid = this$.getExternaluservoterpoolgrid();
										if(grid.getSelectionModel().getCount() > 0){
											Ext.Ajax.request({
												method : "GET",
												type : 'rest',
												async: false,
												url: SERVERURL.PATH_FIND_ELECTION_STATUS,
												params: {
													electionId : electionId,
													voteCaptureBy :'BALLOT'
												},
												headers : {
													'Content-Type' : 'application/json'
												},
												success: function(f, action) {
													var data = Ext.decode(f.responseText);
													if(!isNullOrEmpty(data)&&data=="STARTED"){
														this$.showVoteInElectionTab(data);

													}else if(data=="NOT_STARTED"){
			                    						 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ELECTION_NOT_STARTED_YET'));
			                    					 }else if(data=="FINISHED"){
			                    						 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ELECTION_HAS_FINISHED'));
			                    					 }												}
											});	
										}else {
						            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						            	} 
									}
								},
								'fpelectionsgrid':{
									render : function(grid){
										var person = this.getCurrentlyLoggedInUserWithPersonId();
			                    		 var personId = person.id;
			                    		 var store = grid.getStore();
			                    		 store.getProxy().extraParams = {
			                    			 personId : personId
			                    		 };
			                    		 store.load();
									},
									cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
										var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
										if(columnName == "votingAction"){
											//this.showVoteInElectionTab();
										}
									}
								},
								'studentvoteinelectionliststructure':{
									afterrender:function(structure){
										var this$ = this;
										structure.config.temp=0;
										var listPanel = structure.down('#listPanel');
										var grid = null;
								    	var electionId = null;
								    	if(portalId == 2 || portalId == 3){
								    		grid= this$.getSpelectionsgrid();
								    		var record = grid.getSelectionModel().getSelection()[0];
								    		electionId = record.data.id;
								    	}else{
								    		var structure = this$.getElectonvoterpoolstructure();
								    		var tabPanelStrc = structure.down('tabpanel');
								    		var studentVoterPollGrid = tabPanelStrc.getActiveTab().down('#studentvoterpoolgrid');
											var EmployeeVoterPoolGrid =  tabPanelStrc.getActiveTab().down('#employeevoterpoolgrid');
											var ExternaluserVoterPollGrid =  tabPanelStrc.getActiveTab().down('#externaluservoterpoolgrid');
											if(!isNullOrEmpty(studentVoterPollGrid)){
												grid = studentVoterPollGrid;
											}else if(!isNullOrEmpty(EmployeeVoterPoolGrid)){
												grid = EmployeeVoterPoolGrid;
											}else if(!isNullOrEmpty(ExternaluserVoterPollGrid)){
												grid = ExternaluserVoterPollGrid;
											}
								    		electionId = structure.down('#electionId').getValue();
								    	}
										var handingButton = {
	     											xtype:'button',
	     											text: getCommonTranslation("CANDIDATE_LIST_HANDING"),
	     											cls:'headingBtnCls'
	     										};
                 						    listPanel.add(handingButton);
										 Ext.Ajax.request({
		                    				 method : "GET",
		                    				 type : 'rest',
		                    				 url: SERVERURL.PATH_FIND_BY_ELECTION_ID_ELECTION_LIST,
		                    				 params: {
		                    					 electionId : electionId
		                    				 },
		                    				 headers : {
		                    					 'Content-Type' : 'application/json'
		                    				 },
		                    				 success: function(f, action) {
		                    					var resp = Ext.decode(f.responseText);
		                    					var i=1;
		                    					Ext.each(resp, function(candidateList){
		                    						    var button = {
			     											xtype:'button',
			     											text: candidateList.value,
			     											itemId:'candidate_'+candidateList.id,
			     											tooltip: candidateList.value,
			     											/*style:{
			     												border:'0px',
			     												width:'302px'
			     											},*/
			     											cls:'panelUrlCLS',
			     											//pressedCls:'pressed',
			     											 //enableToggle : true,
			     											  
			     											handler: function(btn){
			     												this$.onCandidateListClick(candidateList.id,candidateList.value);
			     												this$.onChangeClickedBtnCss(btn);
			     											}
			     										};
		                    						    listPanel.add(button);
		                    						    i=i+1;
		                    					 });
		                    				 }
		                    			 });
										 
										 
									}
								},
    	   
           'downloadelectionvoterpool button[itemId=electionDownoladBtnId]':{
 			   click:function(obj){
 				   var $this = this;
 				  var structure = $this.getElectonvoterpoolstructure();
 				 var electionId=structure.down("#electionId").getValue();
 				   var form =obj.up('downloadelectionvoterpool').getForm();
 				   var value = form.getValues();
 				   var csvForm = Ext.create('Ext.form.Panel'); 
 				   csvForm.getForm().submit({
 					   target: '_blank',
 					   method:'POST',
 					   params :{
 						   access_token : Ext.Ajax.defaultHeaders.access_token,
 						  electionId:electionId,
 						 voterPool:value.voterPool,
 					   },
 					   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
 					   url: SERVERURL.DOWNLOAD_VOTER_POOL_LOADER_TEMPLATE,
 					   standardSubmit :true
 				   });
 			   }  
 		   },
 		   'studentvoteinelectionliststructure button[itemId=searchBtnElec]':{
 			  click : this.submittElectionVote
 		   },
 		  'studentvoteinelectionliststructure button[itemId=resetBtnElec]':{
 			  click :function(obj){
 				var tempStore = Ext.getStore('electionTempStore');
 				var dataView = Ext.ComponentQuery.query('#galleryDataViewElection')[0];
 				var structure = this.getStudentvoteinelectionliststructure();
 				var submitBtn = structure.down('#searchBtnElec');
 				structure.config.temp=0;
 				tempStore.removeAll();
 				dataView.getStore().load();
 				submitBtn.setDisabled(true);
 				
 				var ablStructure = this.getStudentvoteinelectionalbumstructure();
 				var refRadioGroup = ablStructure.down('#referendumelec1');
 				refRadioGroup.items.items[0].setValue(false);
 				refRadioGroup.items.items[1].setValue(true);
 				
 				var refRadioGroup2 = ablStructure.down('#referendumelec2');
 				refRadioGroup2.items.items[0].setValue(false);
 				refRadioGroup2.items.items[1].setValue(true)
 				
 			  }
 		   },
 		  'importvoterpooluploadform':{
				render: function(obj){
					var $this = this;
					var temForm = $this.getImportvoterpooluploadform();
					var structure = $this.getElectonvoterpoolstructure();
 					var electionId = structure.down("#electionId").getValue();
 					var grid = $this.getElectionsgrid();
 					var record=grid.getSelectionModel().getSelection()[0].data;
 					 var voterPoolUploadType=temForm.down("#uploadTypeItemId");
 					var voterPoolUploadTypeStore=voterPoolUploadType.getStore();
 					voterPoolUploadTypeStore.getProxy().extraParams = {
 				  		electionId: electionId
 				  
 					};
					
				}
			},
			'importvoterpoolloadergrid':{
				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					if (e.target.tagName == 'A') {
						var fileType=null;
						if(cellIndex==1){
							fileType='successFile';
						}else if(cellIndex==6){
							fileType='errorFile';
						}else if(cellIndex==7){
							fileType='logFile';
						}
						var documentId = record.get("id");
						if (!isNullOrEmpty(documentId)) {
							this.getDownloadFile(documentId,fileType);
						}
					}
				}
			},
			 'importvoterpoolloadergrid button[itemId=btnForce]':{
				 click : function(obj) {
					 var grid = this.getImportvoterpoolloadergrid();
		            	if (grid.getSelectionModel().getCount() > 0) {
		            		if(grid.getSelectionModel().getCount() > 1){
			        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
			        		}else{
			        			var this$ = this;
	 	                	var id = grid.getSelectionModel().selectionStart.data.id;
	 	                	var urlAppend="?jobName="+id;
	 	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
	 	    	        	Ext.Ajax.request({
	 	    	        		url: submitURL,
	 	    	        		method: 'GET',
	 	    	        		success: function(response) {
	 	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
	 	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
	 	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
	 	    	        				//console.log("Manual trigger hit");
	 	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
	 	    	        			}else if(response.responseText==="SUCCESS"){
	 	    	        				//console.log("Manual trigger hit");
	     	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	 	    	        			}
	 	    	        		}
	 	    	        	});
			        		}
		            	} else {
		            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		            	}  
		            }
			 },
			 'electionvoterpoolloderstructure radiogroup[itemId=importDownloadgroupIds]':{
					change  : function(obj,newValue,oldValue){
						var form = obj.up('electionvoterpoolloderstructure');	 
						var value = obj.getValue();
						var downAllocationform = form.down('downloadelectionvoterpool');
						var importAllocationform = form.down('importvoterpooluploadform');
						var importList = form.down('importvoterpoolloadergrid');

						downAllocationform.setVisible(false);
						importAllocationform.setVisible(false);
						importList.setVisible(false);

						if(value.downloadUploadTemplate=='forDownloadTemplate'){
							downAllocationform.setVisible(true);
						}else if(value.downloadUploadTemplate=='forUploadTemplate'){
							//this.doAccessControlValidationForLoader(importAllocationform,this.getCORE_ERP_LOADER_PERMISSIONS());
							var uploadoptionradiogroupform  = this.getUploadoptionradiogroup();
							uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
								isUploadAll: false
							});
							importAllocationform.setVisible(true);
							importList.setVisible(true);
						}
					}
				},
		        'electionvoterpoolloderstructure uploadoptionradiogroup[itemId=electionVoterPoolRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
		        	change: function( radioGroup, newValue, oldValue, eOpts){
		        		var grid =this.getImportvoterpoolloadergrid();
		        		var form =this.getUploadoptionradiogroup();
		        		var isUploadAll = newValue.isUploadAll;
		        		this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'BULK_ALLOCATION_UPLOAD');
		        	}   
				
				
		 		   },
		 		  'importvoterpooluploadform customcombobox[itemId=uploadTypeItemId]': {
		     			 select: function(obj, record) {
		     				 var $this = this;
		     				 var form = this.getImportvoterpooluploadform().getForm();
		     				 var templateName = form.getValues().uploadType;
		     				 var moduleName = null;
		     				 var moduleNameUi = null;
		     				 switch (templateName){
		     				 case 'STAFF_STUDENTS':
		     					 moduleName = 'IMPORT_BULK_VOTER_POOL_STUDENT_USER';
		     					 moduleNameUi = 'Voter Pool - Students / Staff';
		     					 break;
		     				 case 'EXTERNAL_USERS':
		     					 moduleName = 'IMPORT_BULK_VOTER_POOL_EXTERNAL_USER';
		     					 moduleNameUi = 'Voter Pool- External User';
		     					 break;
		     				 default : null;
		     				 }
		     				 var combo = form.findField('importUtilityMasterId');
		     				 combo.getStore().load({
		     					 callback: function(records, operation, success) {
		     						 for(var i in records){
		     							 if(records[i].data.value == moduleNameUi){
		     								 combo.setValue(records[i].data.id);
		     								 combo.setReadOnly(true);
		     							 }
		     						 }
		     					 }	   
		     				 });
		     				 var grid = $this.getImportvoterpoolloadergrid();
		     				 var form = $this.getUploadoptionradiogroup();
		     				 var isUploadAll = form.items.items[0].getValue().isUploadAll;
		     				 $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,moduleName);
		     			 }
			        },
					'importvoterpooluploadform button[itemId=SubmitBtn]':{
						click: function(obj){
							var temForm = obj.up('importvoterpooluploadform');
					    	var tempFormValue=temForm.getForm().findField('importUtilityMasterId').getValue();
					    	var $this=this;
					    	var grdStore;
					    	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
		    	            $this.getHashOfFile(temForm);
				            setTimeout(function() {
						    	temForm.getForm().submit({
						    		method : 'POST',
						    		url : submitUrl,
						    		success : function(form, action){
							        	showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
							        	temForm.getForm().isValid();
						    		},
						    		failure: function(form, action) {
		   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
						    	    }
						    	});
				        	},1000);
					    	Ext.defer(function() {
					    		$this.loadImportHostelBedGrid(temForm.getValues().uploadType);
					    	}, 2000, this);
							
						}
					},
			         'studentvoteinelectionalbumstructure button[itemId=btnNextElec]':{
			        	 click : this.nextButtonOnAlbumPanel
			         },
			         'studentvoteinelectionalbumstructure button[itemId=btnPreviousElec]':{
			        	 click : this.previousButtonOnAlbumPanel
			         },
			         'importvoterpooluploadform button[itemId=resetBtn]':{
				        	click:function(obj){
				        		var $this=this;
				        		var form = $this.getImportvoterpooluploadform().getForm();
				        		form.reset();
				        		form.findField('file').reset();
				        		var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
				        		uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
				        			isUploadAll: false
				        		});
				        		form.isValid();
				        	}
				        },
				        'downloadelectionvoterpool':{
				        	afterrender:function(){
				 				   var $this = this;
				 					var form = this.getDownloadelectionvoterpool();
				 					var structure = $this.getElectonvoterpoolstructure();
				 					var electionId = structure.down("#electionId").getValue();
				 					var grid = $this.getElectionsgrid();
				 					var record=grid.getSelectionModel().getSelection()[0].data;
				 					 var voterPoolType=form.down("#voterPoolItemId");
				 					var voterPoolTypeStore=voterPoolType.getStore();
				 					voterPoolTypeStore.getProxy().extraParams = {
				 				  		electionId: electionId
				 				  	   };
				 					/*var voterPoolTypeStore=voterPoolType.getStore();
				 					var staffs1 =true ;
				 					var external1=true 
				 					for(var i in record.electionVotingPools){
				 						if(record.electionVotingPools[i].votingPool=="STAFF_USERS" || record.electionVotingPools[i].votingPool=="STUDENTS"){
				 						}else if(record.electionVotingPools[i].votingPool=="EXTERNAL_USERS"){
                                           	external1=false
                                           }

				 					}
				 					 var rowIndex = voterPoolType.indexOf(1);
	                        		  if (rowIndex == 1) {
	                        			  voterPoolTypeStore.remove(0);
	                        		  }
	                        		  if(external1){
	               							 if(voterPoolTypeStore.data.items[0].data.id=="EXTERNAL_USERS"){
	               								 voterPoolTypeStore.remove(0);
	               								 
	               							 }}else if (staffs1){
	               								 if(voterPoolTypeStore.data.items[0].data.id=="STAFF_STUDENTS"){
	               									 voterPoolTypeStore.remove(1);
	                   								 
	                   							 }
	               							 }
				 					voterPoolTypeStore.store.load({
               					  callback: function(records, operation, success) {
               						 for(var i in records){
               							 if(external1){
               							 if(records[i].data.id=="EXTERNAL_USERS"){
               								 delete records[i];
               								 
               							 }}else if (staffs1){
               								 if(records[i].data.id=="STAFF_STUDENTS"){
                   								 delete records[i];
                   								 
                   							 }
               							 }
               							 
               						 }
               							
               						  
               					  }
               				  });
				 				   */
				 				 
				 				  
				 			   }  
				 		   },
				        'downloadelectionvoterpool customcombobox[itemId=voterPoolItemId]':{
				    		select: function() {
				    			var form = this.getDownloadelectionvoterpool();
				    			var downoladBtn =form.down("#electionDownoladBtnId");
				    			
				    			form.isValid();
				    			downoladBtn.setDisabled(false);
				        	}
				    	},
				    	'electonvoterpoolstructure':{
				    		/*afterrender: function(structure) {
				    			var electionList = this.getElectionsgrid();
				    			var record = electionList.getSelectionModel().getSelection()[0];
				    			structure.down("#isAdminCaptureVote").setValue(record.get("isAdminCaptureVote"));
				    		},*/
				    		render: function(structure) {
				    			var electionList = this.getElectionsgrid();
				    			var record = electionList.getSelectionModel().getSelection()[0];
				    			//structure.down("#isAdminCaptureVote").setValue(record.get("isAdminCaptureVote"));
				    			structure.config.isAdminCaptureVote = record.get("isAdminCaptureVote");
				    			structure.config.adminCaptureStartDate = record.get("adminCaptureStartDate");
				    			structure.config.adminCaptureStartTime = record.get("adminCaptureStartTime");
				    		}
				    	},
				    	'studentvoterpoolgrid button[itemId=sendMessageBtn]':{
						click:function(){
							this.openVoterPoolStudentSendMessage();
						}
					},'electionvoterpoolforstudentsendmessages[itemId=voterPoolForStudent] radiogroup[itemId=messageType]':{
						change : function(val,nV,oV){
							this.selectSectionMessageTypeForVoterPoolStudent(val,nV,oV);
						}
					},
					'electionvoterpoolforstudentsendmessages[itemId=voterPoolForStudent] customcombobox[itemId=voterPoolStudentMsgTempletId]':{
						select : function(obj,rec){
							this.selectMessageTempForVoterPoolStudent(obj,rec);
						}
					},
					'electionvoterpoolforstudentsendmessages[itemId=voterPoolForStudent] textarea[itemId=empPushNotificationDiscription]':{
						change : function(val,nV,oV){
							var employeeSendMessages =  this.getElectionvoterpoolsendmessages();
							var pushTextField = employeeSendMessages.down('#empPushNotificationDiscription');
							var pushTextFieldDiscription = employeeSendMessages.down('#empPushNotificationDiscriptionNotice');
							var maxLength = 1000;
							var newValue = maxLength - pushTextField.getValue().length;
							pushTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
						}
					},
					'electionvoterpoolforstudentsendmessages[itemId=voterPoolForStudent] button[itemId=voterPoolStudentAdhocMsgSubmitBtn]':{
						click: function(obj) {
							var grid = this.getStudentvoterpoolgrid();
							var employeesendmessage =  this.getElectionvoterpoolforstudentsendmessages();
							var formPnl = obj.up('form');
							var isMySelfChecked = false;
							var fldValues = formPnl.getForm().getFieldValues();
							isMySelfChecked = fldValues.empRecieverType;
							if(fldValues.empRecieverType[0] == false ){
								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SEND_MESSAGE_ALERT_FOR_MYSELF'));
								return;
							}
							var currentlyLoggedInUserId= this.getCurrentlyLoggedInUser().id;
							var empWsMsgEventRecipientConfigsUpdated = [];
							var formData = obj.up('form').getValues();

							var sendMessageToOptions = formData.empRecieverType;
							var isStudentChecked = false;
							var isParentChecked = false;
							var isFeePayerChecked = false;

							if(sendMessageToOptions != null && sendMessageToOptions != undefined ){
								if(sendMessageToOptions.constructor === Array){
									if(sendMessageToOptions.length > 0){
										sendMessageToOptions.forEach(function(current_value, index, initial_array) {
											if(current_value == 1 || current_value == '1'){
												isStudentChecked = true;
											}
											if(current_value == 2 || current_value == '2'){
												isParentChecked = true;
											}
											if(current_value == 3 || current_value == '3'){
												isFeePayerChecked = true;
											}
										});
									}
								}else{
									if(sendMessageToOptions == 1 || sendMessageToOptions == '1'){
										isStudentChecked = true;
									}
									if(sendMessageToOptions == 2 || sendMessageToOptions == '2'){
										isParentChecked = true;
									}
									if(sendMessageToOptions == 3 || sendMessageToOptions == '3'){
										isFeePayerChecked = true;
									}
								}
							}

							//var abc = xyz.c;

							if( !isParentChecked && !isFeePayerChecked ){ // No checkbox is checked
								//empWsMsgEventRecipientConfigsUpdated = [];
								employeesendmessage.sendMessage(obj,grid, empWsMsgEventRecipientConfigsUpdated, isStudentChecked,isMySelfChecked,currentlyLoggedInUserId);
							}else{
								var recipientIds;
								if(grid.xtype == 'studentvoterpoolgrid'){
									recipientIds = this.getStudentReceipientIdsForSendingMessages(grid);
									recipientIds = Ext.encode(recipientIds);
									//typeId = 2;
									//recipientId = 2;
								}

								var RecipientTypeCodes = ["Fee Payer Adhoc","Parent Adhoc"];

								if(isParentChecked && isFeePayerChecked){ // Both checkboxes are cheked 
									// Ajax Call to get Parent Ids by Admission Ids

									Ext.Ajax.request({
										type: 'rest',
										url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
										jsonData: RecipientTypeCodes,
										method: 'POST',
										success: function(response) {
											var RecipientTypeCodesData = Ext.decode(response.responseText);

											Ext.Ajax.request({
												type: 'rest',
												url:SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS,
												jsonData: recipientIds,
												method: 'POST',
												success: function(response) {
													// update empWsMsgEventRecipientConfigsUpdated with parent ids
													var empWsMsgEventRecipientConfigsParents = {
															msgRecipientTypeId: 66,
															msgTemplateConfigId: 0,	//formData.id, 
															selectiveRecipientIds: []
													};
													if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
														empWsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
													}
													empWsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
													empWsMsgEventRecipientConfigsUpdated.push(empWsMsgEventRecipientConfigsParents);

													// Ajax Call to get Fee Payer Ids by Admission Ids
													Ext.Ajax.request({
														type: 'rest',
														url: SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS,
														jsonData: recipientIds,
														method: 'POST',
														success: function(response) {
															// update empWsMsgEventRecipientConfigsUpdated with fee payer ids
															var empWsMsgEventRecipientConfigsFeePayer = {
																	msgRecipientTypeId: 67,
																	msgTemplateConfigId: 0,	//formData.id, 
																	selectiveRecipientIds: []
															};

															if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
																empWsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
															}

															empWsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
															empWsMsgEventRecipientConfigsUpdated.push(empWsMsgEventRecipientConfigsFeePayer);
															employeesendmessage.sendMessage(obj,grid, empWsMsgEventRecipientConfigsUpdated, isStudentChecked,isMySelfChecked,currentlyLoggedInUserId);
														}
													});
												}
											});
										}
									});
								}else{ // Only one checkbox is selected
									var urlNew = '';
									if(isParentChecked) { // If Parent checkbox is selected
										// url for getting parent ids
										urlNew = SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS;
									}
									if(isFeePayerChecked) { // If Fee Payer checkbox is selected
										// url for getting fee payer ids
										urlNew = SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS;
									}

									Ext.Ajax.request({
										type: 'rest',
										url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
										jsonData: RecipientTypeCodes,
										method: 'POST',
										success: function(response) {
											var RecipientTypeCodesData = Ext.decode(response.responseText);

											Ext.Ajax.request({
												type: 'rest',
												url: urlNew,
												jsonData: recipientIds,
												method: 'POST',
												success: function(response) {
													if(isParentChecked) { // If Parent checkbox is selected
														// update empWsMsgEventRecipientConfigsUpdated with parent ids
														var empWsMsgEventRecipientConfigsParents = {
																msgRecipientTypeId: 66,
																msgTemplateConfigId: 0,	//formData.id, 
																selectiveRecipientIds: []
														};
														if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
															empWsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
														}
														empWsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
														empWsMsgEventRecipientConfigsUpdated.push(empWsMsgEventRecipientConfigsParents);
													}
													if(isFeePayerChecked) { // If Fee Payer checkbox is selected
														// update empWsMsgEventRecipientConfigsUpdated with fee payer ids
														var empWsMsgEventRecipientConfigsFeePayer = {
																msgRecipientTypeId: 67,
																msgTemplateConfigId: 0,	//formData.id, 
																selectiveRecipientIds: []
														};
														if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
															empWsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
														}
														empWsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
														empWsMsgEventRecipientConfigsUpdated.push(empWsMsgEventRecipientConfigsFeePayer);
													}
													employeesendmessage.sendMessage(obj,grid, empWsMsgEventRecipientConfigsUpdated,isStudentChecked,isMySelfChecked,currentlyLoggedInUserId);
												}
											});
										}
									});

								}
								//employeesendmessage.sendMessage(obj,grid);
							}

						}
					},
					/*V2D-13247*/
					'electionvoterpoolforstudentsendmessages[itemId=voterPoolForStudent] textarea[itemId=empSmsDiscription]':{
						change : function(val,nV,oV){
							var employeesendmessage =  this.getElectionvoterpoolforstudentsendmessages();
							var smsTextField = employeesendmessage.down('#empSmsDiscription');
							var smsTextFieldDiscription = employeesendmessage.down('#empSmsDiscriptionNotice');
							var maxLength = localStorage.getItem('maxLength');
							var newValue = maxLength - smsTextField.getValue().length;
							smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
						}
					},'electionvoterpoolforstudentsendmessages[itemId=voterPoolForStudent]  filefield[itemId=empStaticUploadFileField]': {
						change: function(fileField, value, eOpts){
							var this$ = this;
							//value = value.replace('C:\\fakepath\\', '');
							var form=this$.getElectionvoterpoolforstudentsendmessages();
							var empSubject = form.down('#empSubject').getValue();
							if(isNullOrEmpty(empSubject)){
								form.down('#empSubject').setValue(' ');
							}
							this$.uploadForVoterPoolStudentStaticDocumentFileMessage(fileField, value, eOpts);
						}
					}, 'staffstaticdocumentattachmentgrid[itemId=voterPoolEmployeeStaticDocumentAttachmentGridMessage] actioncolumn': {
		            	click : function(view, rowIndex, colIndex, item, e, record, row){
		            		this.deleteVoterPoolStaffStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
		            	}
		            },'electionvoterpoolsendmessages[itemId=voterPoolForStaff]': {
						render: function(grid){
							var this$ = this;
							var docGrid = grid.down('#voterPoolEmployeeStaticDocumentAttachmentGridMessage');
							docGrid.getStore().removeAll();
							docGrid.getStore().sync();
						}
					}, 'electionvoterpoolsendmessages[itemId=voterPoolForStaff] radiogroup#empSendingPriority': {
						change: function( radio, newValue, oldValue, eOpts) {
							this.loadStudentScheduleField(radio, newValue, oldValue);
						}
					},'employeevoterpoolgrid button[itemId=sendMessageBtn]':{
						click:function(){
							this.openEmployeeSendMessage();
						},
				
					},'electionvoterpoolsendmessages[itemId=voterPoolForStaff] radiogroup[itemId=messageType]':{
						change : function(val,nV,oV){
							this.selectSectionMessageType(val,nV,oV);
						}
					},
					'electionvoterpoolsendmessages[itemId=voterPoolForStaff] customcombobox[itemId=empMsgTempletId]':{
						select : function(obj,rec){
							this.selectMessageTemp(obj,rec);
						}
					},
					'electionvoterpoolsendmessages[itemId=voterPoolForStaff] textarea[itemId=empPushNotificationDiscription]':{
						change : function(val,nV,oV){
							var employeeSendMessages =  this.getElectionvoterpoolsendmessages();
							var pushTextField = employeeSendMessages.down('#empPushNotificationDiscription');
							var pushTextFieldDiscription = employeeSendMessages.down('#empPushNotificationDiscriptionNotice');
							var maxLength = 1000;
							var newValue = maxLength - pushTextField.getValue().length;
							pushTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
						}
					},
					'electionvoterpoolsendmessages[itemId=voterPoolForStaff] button[itemId=voterpoolStaffpAdhocMsgSubmitBtn]':{
						click: function(obj) {
							var grid = this.getEmployeevoterpoolgrid();
							var employeesendmessage =  this.getElectionvoterpoolsendmessages();
							var formPnl = obj.up('form');
							var isMySelfChecked = false;
							var fldValues = formPnl.getForm().getFieldValues();
							isMySelfChecked = fldValues.empRecieverType;
							if(fldValues.empRecieverType[0] == false ){
								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SEND_MESSAGE_ALERT_FOR_MYSELF'));
								return;
							}
							var currentlyLoggedInUserId= this.getCurrentlyLoggedInUser().id;
							var empWsMsgEventRecipientConfigsUpdated = [];
							/*var empWsMsgEventRecipientConfigsUpdated = [{ 
								                           	 	msgRecipientTypeId: 500,
								                           	 	msgTemplateConfigId: 0,	//formData.id, 
								                           	 	selectiveRecipientIds: [] 
								                            },{ 
								                           	 	msgRecipientTypeId: 600,
								                           	 	msgTemplateConfigId: 0,	//formData.id, 
								                           	 	selectiveRecipientIds: [] 
								                            }];*/

							var formData = obj.up('form').getValues();

							var sendMessageToOptions = formData.empRecieverType;
							var isStudentChecked = false;
							var isParentChecked = false;
							var isFeePayerChecked = false;

							if(sendMessageToOptions != null && sendMessageToOptions != undefined ){
								if(sendMessageToOptions.constructor === Array){
									if(sendMessageToOptions.length > 0){
										sendMessageToOptions.forEach(function(current_value, index, initial_array) {
											if(current_value == 1 || current_value == '1'){
												isStudentChecked = true;
											}
											if(current_value == 2 || current_value == '2'){
												isParentChecked = true;
											}
											if(current_value == 3 || current_value == '3'){
												isFeePayerChecked = true;
											}
										});
									}
								}else{
									if(sendMessageToOptions == 1 || sendMessageToOptions == '1'){
										isStudentChecked = true;
									}
									if(sendMessageToOptions == 2 || sendMessageToOptions == '2'){
										isParentChecked = true;
									}
									if(sendMessageToOptions == 3 || sendMessageToOptions == '3'){
										isFeePayerChecked = true;
									}
								}
							}

							//var abc = xyz.c;

							if( !isParentChecked && !isFeePayerChecked ){ // No checkbox is checked
								//empWsMsgEventRecipientConfigsUpdated = [];
								employeesendmessage.sendMessage(obj,grid, empWsMsgEventRecipientConfigsUpdated, isStudentChecked,isMySelfChecked,currentlyLoggedInUserId);
							}else{
								var recipientIds;
								if(grid.xtype == 'employeevoterpoolgrid'){
									recipientIds = this.getStudentReceipientIdsForSendingMessages(grid);
									recipientIds = Ext.encode(recipientIds);
									//typeId = 2;
									//recipientId = 2;
								}

								var RecipientTypeCodes = ["Fee Payer Adhoc","Parent Adhoc"];

								if(isParentChecked && isFeePayerChecked){ // Both checkboxes are cheked 
									// Ajax Call to get Parent Ids by Admission Ids

									Ext.Ajax.request({
										type: 'rest',
										url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
										jsonData: RecipientTypeCodes,
										method: 'POST',
										success: function(response) {
											var RecipientTypeCodesData = Ext.decode(response.responseText);

											Ext.Ajax.request({
												type: 'rest',
												url:SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS,
												jsonData: recipientIds,
												method: 'POST',
												success: function(response) {
													// update empWsMsgEventRecipientConfigsUpdated with parent ids
													var empWsMsgEventRecipientConfigsParents = {
															msgRecipientTypeId: 66,
															msgTemplateConfigId: 0,	//formData.id, 
															selectiveRecipientIds: []
													};
													if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
														empWsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
													}
													empWsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
													empWsMsgEventRecipientConfigsUpdated.push(empWsMsgEventRecipientConfigsParents);

													// Ajax Call to get Fee Payer Ids by Admission Ids
													Ext.Ajax.request({
														type: 'rest',
														url: SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS,
														jsonData: recipientIds,
														method: 'POST',
														success: function(response) {
															// update empWsMsgEventRecipientConfigsUpdated with fee payer ids
															var empWsMsgEventRecipientConfigsFeePayer = {
																	msgRecipientTypeId: 67,
																	msgTemplateConfigId: 0,	//formData.id, 
																	selectiveRecipientIds: []
															};

															if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
																empWsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
															}

															empWsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
															empWsMsgEventRecipientConfigsUpdated.push(empWsMsgEventRecipientConfigsFeePayer);
															employeesendmessage.sendMessage(obj,grid, empWsMsgEventRecipientConfigsUpdated, isStudentChecked,isMySelfChecked,currentlyLoggedInUserId);
														}
													});
												}
											});
										}
									});
								}else{ // Only one checkbox is selected
									var urlNew = '';
									if(isParentChecked) { // If Parent checkbox is selected
										// url for getting parent ids
										urlNew = SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS;
									}
									if(isFeePayerChecked) { // If Fee Payer checkbox is selected
										// url for getting fee payer ids
										urlNew = SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS;
									}

									Ext.Ajax.request({
										type: 'rest',
										url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
										jsonData: RecipientTypeCodes,
										method: 'POST',
										success: function(response) {
											var RecipientTypeCodesData = Ext.decode(response.responseText);

											Ext.Ajax.request({
												type: 'rest',
												url: urlNew,
												jsonData: recipientIds,
												method: 'POST',
												success: function(response) {
													if(isParentChecked) { // If Parent checkbox is selected
														// update empWsMsgEventRecipientConfigsUpdated with parent ids
														var empWsMsgEventRecipientConfigsParents = {
																msgRecipientTypeId: 66,
																msgTemplateConfigId: 0,	//formData.id, 
																selectiveRecipientIds: []
														};
														if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
															empWsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
														}
														empWsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
														empWsMsgEventRecipientConfigsUpdated.push(empWsMsgEventRecipientConfigsParents);
													}
													if(isFeePayerChecked) { // If Fee Payer checkbox is selected
														// update empWsMsgEventRecipientConfigsUpdated with fee payer ids
														var empWsMsgEventRecipientConfigsFeePayer = {
																msgRecipientTypeId: 67,
																msgTemplateConfigId: 0,	//formData.id, 
																selectiveRecipientIds: []
														};
														if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
															empWsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
														}
														empWsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
														empWsMsgEventRecipientConfigsUpdated.push(empWsMsgEventRecipientConfigsFeePayer);
													}
													employeesendmessage.sendMessage(obj,grid, empWsMsgEventRecipientConfigsUpdated,isStudentChecked,isMySelfChecked,currentlyLoggedInUserId);
												}
											});
										}
									});

								}
								//employeesendmessage.sendMessage(obj,grid);
							}

						}
					},
					/*V2D-13247*/
					'electionvoterpoolsendmessages[itemId=voterPoolForStaff] textarea[itemId=empSmsDiscription]':{
						change : function(val,nV,oV){
							var employeesendmessage =  this.getElectionvoterpoolsendmessages();
							var smsTextField = employeesendmessage.down('#empSmsDiscription');
							var smsTextFieldDiscription = employeesendmessage.down('#empSmsDiscriptionNotice');
							var maxLength = localStorage.getItem('maxLength');
							var newValue = maxLength - smsTextField.getValue().length;
							smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
						}
					},'electionvoterpoolsendmessages[itemId=voterPoolForStaff]  filefield[itemId=empStaticUploadFileField]': {
						change: function(fileField, value, eOpts){
							var this$ = this;
							//value = value.replace('C:\\fakepath\\', '');
							var form=this$.getElectionvoterpoolsendmessages();
							var empSubject = form.down('#empSubject').getValue();
							if(isNullOrEmpty(empSubject)){
								form.down('#empSubject').setValue(' ');
							}
							this$.uploadEmployeeStaticDocumentFileMessage(fileField, value, eOpts);
						}
					}, 'stduentvoterpoolstaticdocumentattachmentgrid[itemId=voterPoolStudentStaticDocumentAttachmentGridMessage] actioncolumn': {
		            	click : function(view, rowIndex, colIndex, item, e, record, row){
		            		this.deleteVoterPoolStudentStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
		            	}
		            },
		            'electionvoterpoolforstudentsendmessages[itemId=voterPoolForStudent]': {
						render: function(grid){
							var this$ = this;
							var docGrid = grid.down('#voterPoolStudentStaticDocumentAttachmentGridMessage');
							docGrid.getStore().removeAll();
							docGrid.getStore().sync();
						}
					},
					'electionvoterpoolforstudentsendmessages[itemId=voterPoolForStudent] radiogroup#empSendingPriority': {
						change: function( radio, newValue, oldValue, eOpts) {
							this.loadStudentScheduleFieldForStudent(radio, newValue, oldValue);
						}},
					'electionvoterpoolforexternalusersendmessages[itemId=voterPoolForExternalUser] radiogroup[itemId=messageType]':{
						change : function(val,nV,oV){
							this.selectSectionMessageTypeForVoterPoolExternalUser(val,nV,oV);
						}
					},'electionvoterpoolforexternalusersendmessages[itemId=voterPoolForExternalUser] textarea[itemId=empPushNotificationDiscription]':{
						change : function(val,nV,oV){
							var employeeSendMessages =  this.getElectionvoterpoolforexternalusersendmessagess();
							var pushTextField = employeeSendMessages.down('#empPushNotificationDiscription');
							var pushTextFieldDiscription = employeeSendMessages.down('#empPushNotificationDiscriptionNotice');
							var maxLength = 1000;
							var newValue = maxLength - pushTextField.getValue().length;
							pushTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
						}
					},
					
					'electionvoterpoolforexternalusersendmessages[itemId=voterPoolForExternalUser] textarea[itemId=empSmsDiscription]':{
						change : function(val,nV,oV){
							var employeesendmessage =  this.getElectionvoterpoolforexternalusersendmessages();
							var smsTextField = employeesendmessage.down('#empSmsDiscription');
							var smsTextFieldDiscription = employeesendmessage.down('#empSmsDiscriptionNotice');
							var maxLength = localStorage.getItem('maxLength');
							var newValue = maxLength - smsTextField.getValue().length;
							smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
						}
					},
					'electionvoterpoolforexternalusersendmessages[itemId=voterPoolForExternalUser]  filefield[itemId=empStaticUploadFileField]': {
						change: function(fileField, value, eOpts){
							var this$ = this;
							//value = value.replace('C:\\fakepath\\', '');
							var form=this$.getElectionvoterpoolforexternalusersendmessages();
							var empSubject = form.down('#empSubject').getValue();
							if(isNullOrEmpty(empSubject)){
								form.down('#empSubject').setValue(' ');
							}
							this$.uploadForVoterPoolExternalUserStaticDocumentFileMessage(fileField, value, eOpts);
						}
					},
					
					'externalvoterpoolstaticdocumentattachmentgrid[itemId=voterPoolExternalUserStaticDocumentAttachmentGridMessage] actioncolumn': {
		            	click : function(view, rowIndex, colIndex, item, e, record, row){
		            		this.deleteVoterPoolExternalUserStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
		            	}
		            },
		            'electionvoterpoolforexternalusersendmessages[itemId=voterPoolForExternalUser]': {
						render: function(grid){
							var this$ = this;
							var docGrid = grid.down('#voterPoolExternalUserStaticDocumentAttachmentGridMessage');
							docGrid.getStore().removeAll();
							docGrid.getStore().sync();
						}
					},
					'electionvoterpoolforexternalusersendmessages[itemId=voterPoolForExternalUser] radiogroup#empSendingPriority': {
						change: function( radio, newValue, oldValue, eOpts) {
							this.loadStudentScheduleFieldForExternalUser(radio, newValue, oldValue);
						}
					},
					'externaluservoterpoolgrid button[itemId=sendMessageBtn]':{
						click:function(){
							this.openVoterPoolExternalUserSendMessage();
						}
					},
					'electionvoterpoolforexternalusersendmessages[itemId=voterPoolForExternalUser] customcombobox[itemId=voterpoolExternalUserMsgTempletId]':{
						select : function(obj,rec){
							this.selectMessageTempForVoterPoolExternalUser(obj,rec);
						}
					},'electionvoterpoolforexternalusersendmessages[itemId=voterPoolForExternalUser] button[itemId=voterPoolExternalUserAdhocMsgSubmitBtn]':{
						click: function(obj) {
							var grid = this.getExternaluservoterpoolgrid();
							var employeesendmessage =  this.getElectionvoterpoolforexternalusersendmessages();
							var formPnl = obj.up('form');
							var isMySelfChecked = false;
							var fldValues = formPnl.getForm().getFieldValues();
							isMySelfChecked = fldValues.empRecieverType;
							if(fldValues.empRecieverType[0] == false ){
								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SEND_MESSAGE_ALERT_FOR_MYSELF'));
								return;
							}
							var currentlyLoggedInUserId= this.getCurrentlyLoggedInUser().id;
							var empWsMsgEventRecipientConfigsUpdated = [];
                            var formData = obj.up('form').getValues();

							var sendMessageToOptions = formData.empRecieverType;
							var isStudentChecked = false;
							var isParentChecked = false;
							var isFeePayerChecked = false;
                            if(sendMessageToOptions != null && sendMessageToOptions != undefined ){
								if(sendMessageToOptions.constructor === Array){
									if(sendMessageToOptions.length > 0){
										sendMessageToOptions.forEach(function(current_value, index, initial_array) {
											if(current_value == 1 || current_value == '1'){
												isStudentChecked = true;
											}
											if(current_value == 2 || current_value == '2'){
												isParentChecked = true;
											}
											if(current_value == 3 || current_value == '3'){
												isFeePayerChecked = true;
											}
										});
									}
								}else{
									if(sendMessageToOptions == 1 || sendMessageToOptions == '1'){
										isStudentChecked = true;
									}
									if(sendMessageToOptions == 2 || sendMessageToOptions == '2'){
										isParentChecked = true;
									}
									if(sendMessageToOptions == 3 || sendMessageToOptions == '3'){
										isFeePayerChecked = true;
									}
								}
							}

							

							if( !isParentChecked && !isFeePayerChecked ){ // No checkbox is checked
								employeesendmessage.sendMessage(obj,grid, empWsMsgEventRecipientConfigsUpdated, isStudentChecked,isMySelfChecked,currentlyLoggedInUserId);
							}else{
								var recipientIds;
								if(grid.xtype == 'externaluservoterpoolgrid'){
									recipientIds = this.getStudentReceipientIdsForSendingMessages(grid);
									recipientIds = Ext.encode(recipientIds);
									//typeId = 2;
									//recipientId = 2;
								}

								var RecipientTypeCodes = ["Fee Payer Adhoc","Parent Adhoc"];

								if(isParentChecked && isFeePayerChecked){ // Both checkboxes are cheked 
									// Ajax Call to get Parent Ids by Admission Ids

									Ext.Ajax.request({
										type: 'rest',
										url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
										jsonData: RecipientTypeCodes,
										method: 'POST',
										success: function(response) {
											var RecipientTypeCodesData = Ext.decode(response.responseText);

											Ext.Ajax.request({
												type: 'rest',
												url:SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS,
												jsonData: recipientIds,
												method: 'POST',
												success: function(response) {
													// update empWsMsgEventRecipientConfigsUpdated with parent ids
													var empWsMsgEventRecipientConfigsParents = {
															msgRecipientTypeId: 66,
															msgTemplateConfigId: 0,	//formData.id, 
															selectiveRecipientIds: []
													};
													if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
														empWsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
													}
													empWsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
													empWsMsgEventRecipientConfigsUpdated.push(empWsMsgEventRecipientConfigsParents);

													// Ajax Call to get Fee Payer Ids by Admission Ids
													Ext.Ajax.request({
														type: 'rest',
														url: SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS,
														jsonData: recipientIds,
														method: 'POST',
														success: function(response) {
															// update empWsMsgEventRecipientConfigsUpdated with fee payer ids
															var empWsMsgEventRecipientConfigsFeePayer = {
																	msgRecipientTypeId: 67,
																	msgTemplateConfigId: 0,	//formData.id, 
																	selectiveRecipientIds: []
															};

															if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
																empWsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
															}

															empWsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
															empWsMsgEventRecipientConfigsUpdated.push(empWsMsgEventRecipientConfigsFeePayer);
															employeesendmessage.sendMessage(obj,grid, empWsMsgEventRecipientConfigsUpdated, isStudentChecked,isMySelfChecked,currentlyLoggedInUserId);
														}
													});
												}
											});
										}
									});
								}else{ // Only one checkbox is selected
									var urlNew = '';
									if(isParentChecked) { // If Parent checkbox is selected
										// url for getting parent ids
										urlNew = SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS;
									}
									if(isFeePayerChecked) { // If Fee Payer checkbox is selected
										// url for getting fee payer ids
										urlNew = SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS;
									}

									Ext.Ajax.request({
										type: 'rest',
										url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
										jsonData: RecipientTypeCodes,
										method: 'POST',
										success: function(response) {
											var RecipientTypeCodesData = Ext.decode(response.responseText);

											Ext.Ajax.request({
												type: 'rest',
												url: urlNew,
												jsonData: recipientIds,
												method: 'POST',
												success: function(response) {
													if(isParentChecked) { // If Parent checkbox is selected
														// update empWsMsgEventRecipientConfigsUpdated with parent ids
														var empWsMsgEventRecipientConfigsParents = {
																msgRecipientTypeId: 66,
																msgTemplateConfigId: 0,	//formData.id, 
																selectiveRecipientIds: []
														};
														if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
															empWsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
														}
														empWsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
														empWsMsgEventRecipientConfigsUpdated.push(empWsMsgEventRecipientConfigsParents);
													}
													if(isFeePayerChecked) { // If Fee Payer checkbox is selected
														// update empWsMsgEventRecipientConfigsUpdated with fee payer ids
														var empWsMsgEventRecipientConfigsFeePayer = {
																msgRecipientTypeId: 67,
																msgTemplateConfigId: 0,	//formData.id, 
																selectiveRecipientIds: []
														};
														if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
															empWsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
														}
														empWsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
														empWsMsgEventRecipientConfigsUpdated.push(empWsMsgEventRecipientConfigsFeePayer);
													}
													employeesendmessage.sendMessage(obj,grid, empWsMsgEventRecipientConfigsUpdated,isStudentChecked,isMySelfChecked,currentlyLoggedInUserId);
												}
											});
										}
									});

								}
								//employeesendmessage.sendMessage(obj,grid);
							}

						}
					},
					 'studentvoterpoolgrid textfield[itemId=studentVoterPoolGridSearch]' : {
            			 change : function(obj) {
            				 var $this = this;
            				 var codeNameValue =  obj.getValue();
            				 var codeName = codeNameValue.trim(); 
            				 var electionsGrid = $this.getElectionsgrid();
     				         var record = electionsGrid.getSelectionModel().getSelection()[0];
            				 var store = this.getStore('election.election.ElectionVoterPoolGridStore');
            				 if(codeName.length >= 3){
            					 store.getProxy().extraParams = {
            						 electionId : record.get("id"),
            						 codeName:codeName
            					 };
            					 $this.resetPageSetting(store);
            					 store.loadPage(1);
            				 }else if(codeName.length == 0){
            					 store.getProxy().extraParams = {
            						 electionId : record.get("id"),
            						 codeName:codeName
            					 };
            					 $this.resetPageSetting(store);
            					 store.load();
            				 }
            			 }
            		 },
            		 'employeevoterpoolgrid textfield[itemId=empVoterPoolGridSearch]' : {
            			 change : function(obj) {
            				 var $this = this;
            				 var codeNameValue =  obj.getValue();
            				 var codeName = codeNameValue.trim(); 
            				 var electionsGrid = $this.getElectionsgrid();
     				         var record = electionsGrid.getSelectionModel().getSelection()[0];
            				 var store = this.getStore('election.election.ElectionStaffVoterPoolGridStore');
            				 if(codeName.length >= 3){
            					 store.getProxy().extraParams = {
            						 electionId : record.get("id"),
            						 codeName:codeName
            					 };
            					 $this.resetPageSetting(store);
            					 store.loadPage(1);
            				 }else if(codeName.length == 0){
            					 store.getProxy().extraParams = {
            						 electionId : record.get("id"),
            						 codeName:codeName
            					 };
            					 $this.resetPageSetting(store);
            					 store.load();
            				 }
            			 }
            		 },
            		 'externaluservoterpoolgrid textfield[itemId=extUserVoterPoolGridSearch]' : {
            			 change : function(obj) {
            				 var $this = this;
            				 var codeNameValue =  obj.getValue();
            				 var codeName = codeNameValue.trim(); 
            				 var electionsGrid = $this.getElectionsgrid();
     				         var record = electionsGrid.getSelectionModel().getSelection()[0];
            				 var store = this.getStore('election.election.ElectionExternalUserVoterPoolGridStore');
            				 if(codeName.length >= 3){
            					 store.getProxy().extraParams = {
            						 electionId : record.get("id"),
            						 codeName:codeName
            					 };
            					 $this.resetPageSetting(store);
            					 store.loadPage(1);
            				 }else if(codeName.length == 0){
            					 store.getProxy().extraParams = {
            						 electionId : record.get("id"),
            						 codeName:codeName
            					 };
            					 $this.resetPageSetting(store);
            					 store.load();
            				 }
            			 }
            		 }
	});
    	}, 
	addelectionRecord:function(isView){
		//var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
			var structure = Ext.widget('electionform');
	        var tabName = getCommonTranslation('ADD_ELECTION')
	       /**
	        * This is to remove tab from content panel and open same tab again
	        */
	        if (isView == 'ADD') {
	        	structure.setTitle(getCommonTranslation('ADD_ELECTION'));
	            tabName = getCommonTranslation('ADD_ELECTION')
	            
	        }
	        else if (isView == 'VIEW') {
	        	structure.setTitle(getCommonTranslation('VIEW_ELECTION'));
	            tabName = getCommonTranslation('VIEW_ELECTION')
	            
	        } else if (isView== 'EDIT') {
	        	structure.setTitle(getCommonTranslation('EDIT_ELECTION'));
	            tabName = getCommonTranslation('EDIT_ELECTION')
	        } 
	        
	       var getcontroller=this.getController('menu.CoreERPNavigationController');
	       var getAddTab = getcontroller.getTab(getCommonTranslation('ADD_ELECTION'));
	        var getEditTab = getcontroller.getTab(getCommonTranslation('EDIT_ELECTION'));
	        var getViewTab = getcontroller.getTab(getCommonTranslation('VIEW_ELECTION'));
	        if (getAddTab != null) {
	            contentPanel.remove(getAddTab, true);
	        }
	        if (getEditTab != null) {
	            contentPanel.remove(getEditTab, true);
	        }
	        if (getViewTab != null) {
	            contentPanel.remove(getViewTab, true);
	        }
	        
	       /*var getTab=getcontroller.getTab(tabName);
	       if(getTab!=null){
	       	contentPanel.remove(getTab, true);
	       }*/
	       openTab(contentPanel, tabName, structure, CONSTANTS.MENU_COLOR_TWO);
	       Ext.apply(structure,{
	    	   code:null,
	    	   setCode : function(code){
	    		   structure.code = code;
	    	   },
	    	   getCode:function(){
	    		   return structure.code;
	    	   }
	       });
	       structure.setCode(true);
	},
	saveElectionRecord: function(){
		var $this = this;
		//var contentPanel = $this.getContentPanel();
		var grid = $this.getElectionsgrid();
		var json;
		

		var submitUrl;
		var isView = '';
	//	var isPermissionGiven = $this.getElectionfilter().config.isPermissionGiven;
		if($this.getElectionform().getCode()) {
			json = $this.createSaveJson($this);
			submitUrl = SERVERURL.PATH_ELECTION_SAVE;
			json.isDeleted = false;
			isView = 'ADD';
		} else {
			json = $this.createUpdateJson($this, grid);
			var record = grid.getSelectionModel().getSelection();
			json.isDeleted = record[0].data.isDeleted;
			submitUrl = SERVERURL.PATH_ELECTION_UPDATE;
			isView = 'EDIT';
		}
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		var formData = Ext.encode(json);
		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl,
			jsonData : formData,
			method : 'POST',
			success : function(frm, action) {
				Ext.getBody().unmask(); 
				if (isView == 'ADD') {
		            tabName = getCommonTranslation('ADD_ELECTION');
		            showSuccessMessage(getCommonTranslation('ELECTION'), getCommonTranslation('ELECTION_CREATED_SUCCESSFULLY'));
		        }
		        else if (isView== 'EDIT') {
		            tabName = getCommonTranslation('EDIT_ELECTION');
		            showSuccessMessage(getCommonTranslation('ELECTION'), getCommonTranslation('ELECTION_UPDATED_SUCCESSFULLY'));
		        }
				$this.resetElectionFilter();
				
		    	var getcontroller=$this.getController('menu.CoreERPNavigationController');
				grid.getSelectionModel().deselectAll();
				var getTab=getcontroller.getTab(tabName);
				if(getTab!=null){
					contentPanel.remove(getTab, true);
				}
				try {
					$this.getElectionfilter().el.dom.getElementsByClassName('ph ph-caret-up')[0].parentElement.click();
					$this.getElectionfilter().el.dom.getElementsByClassName('filter-toggle-button')[0].click();
				}
				catch(e) {}
			}
		});
	},
	createSaveJson: function($this){
		var formValue = $this.getElectionform().getValues();
		var json= new Object;
		var electionTypeCSM={
			"id":	formValue.electionType
		};
		var academicTerm={
				"id":	formValue.academicTerm
			};
		var votingPool=[];
		for (var i=0; i<formValue.votingPool.length; i++) {
			
			academyLocation={
					"votingPool":(formValue.votingPool[i].data!=undefined)?formValue.votingPool[i].data.id:formValue.votingPool[i]
					
			}	
			votingPool.push(academyLocation)
		}
		
		
		json = {
				"electionCode":formValue.electionCode,
				"electionTypeCSM":electionTypeCSM,
				"electionName":formValue.electionName,
				"electionNameInOtherLanguage":formValue.electionNameInOtherLang,
				"academicTerm":academicTerm,
				"isAdminCaptureVote":formValue.isAdminCaptureVote,
				"votingStartDate":formValue.votingStartDate,
				"votingEndDate":formValue.votingEndDate,
				"adminCaptureStartDate":formValue.adminCaptureStartDate,
				"adminCaptureEndDate":formValue.adminCaptureEndDate,
				"isReferendumOne":formValue.isReferendumOne,
				"referendumOneQuestionInEnglish":formValue.referendumOneQuestionInEnglish,
				"referendumOneQuestionInOtherLang":formValue.referendumOneQuestionInOtherLang,
				"isReferendumTwo":formValue.isReferendumTwo,
				"referendumTwoQuestionInEnglish":formValue.referendumTwoQuesInEng,
				"referendumTwoQuestionInOtherLang" :formValue.referendumTwoQuesInOtherLang,
				"electionDescriptionInEnglish":formValue.electionDesInEng,
				"electionDescriptionInOtherLang":formValue.electionDescriptionInOtherLang,
				"isActive":formValue.isActive,
				"votingStartTime":formValue.votingStartTime,
				"votingEndTime":formValue.votingEndTime,
				"adminCaptureStartTime":formValue.adminCaptureStartTime,
				"adminCaptureEndTime":formValue.adminCaptureEndTime,
				"electionVotingPools":votingPool
		};
		return json;	
	},
	createUpdateJson: function($this, grid){
		var formValue = $this.getElectionform().getValues();
		var json= new Object;
		var electionTypeCSM={
				"id":	formValue.electionType
			};
			var academicTerm={
					"id":	formValue.academicTerm
				};
			var votingPool=[];
			for (var i=0; i<formValue.votingPool.length; i++) {
				
				academyLocation={
						"votingPool":(formValue.votingPool[i].data!=undefined)?formValue.votingPool[i].data.id:formValue.votingPool[i]
						
				}	
				votingPool.push(academyLocation)
			}
			
		json = {
				"id":formValue.id[0],
                 "electionCode":formValue.electionCode,
				"electionTypeCSM":electionTypeCSM,
				"electionName":formValue.electionName,
				"electionNameInOtherLanguage":formValue.electionNameInOtherLang,
				"academicTerm":academicTerm,
				"isAdminCaptureVote":formValue.isAdminCaptureVote,
				"votingStartDate":formValue.votingStartDate,
				"votingEndDate":formValue.votingEndDate,
				"adminCaptureStartDate":formValue.adminCaptureStartDate,
				"adminCaptureEndDate":formValue.adminCaptureEndDate,
				"isReferendumOne":formValue.isReferendumOne,
				"referendumOneQuestionInEnglish":formValue.referendumOneQuestionInEnglish,
				"referendumOneQuestionInOtherLang":formValue.referendumOneQuestionInOtherLang,
				"isReferendumTwo":formValue.isReferendumTwo,
				"referendumTwoQuestionInEnglish":formValue.referendumTwoQuesInEng,
				"referendumTwoQuestionInOtherLang" :formValue.referendumTwoQuesInOtherLang,
				"electionDescriptionInEnglish":formValue.electionDesInEng,
				"electionDescriptionInOtherLang":formValue.electionDescriptionInOtherLang,
				"isActive":formValue.isActive,
				"votingStartTime":formValue.votingStartTime,
				"votingEndTime":formValue.votingEndTime,
				"adminCaptureStartTime":formValue.adminCaptureStartTime,
				"adminCaptureEndTime":formValue.adminCaptureEndTime,
				"electionVotingPools":votingPool
		
		};
		return json;	
	},
	loadElectionGrid:function(){
    	var $this=this;
    	var form = $this.getElectionfilter().getForm();
    	var formValue = form.getValues();
    	var grid = $this.getElectionsgrid();
    	grid.down("#btnAdd").setDisabled(false);
    	grid.down("#btnEdit").setDisabled(false);
    	grid.down("#btnView").setDisabled(false);
    	grid.down("#btnDelete").setDisabled(false);
    	grid.down("#condidateLink").setDisabled(false);
    	grid.down("#voterPoolLink").setDisabled(false);
    	grid.down("#printElectionSheetLink").setDisabled(false);
   
    var isActive=false;
    if(formValue.status=='ACTIVE'){
    	isActive=true
    }
    	
    	var store = grid.getStore();
    	
  	   store.getProxy().extraParams = {
  		 electionType: formValue.electionType,
			votingEndDate:formValue.endDate,
			votingStartDate:formValue.startDate,
			status:isActive,
			  academicTermId:formValue.academicTerm,
			  electionId: formValue.electioncCodeName
  	   };
  	 grid.getSelectionModel().deselectAll();
 	$this.resetGridSetting(grid);
  	   $this.resetPageSetting(store);
  	   store.load();
    grid.config.searchFilterForm = $this.getElectionfilter();
    }, 
    viewElectionRecord:function(){
		var $this = this;
		var grid = $this.getElectionsgrid();
		if(grid.getSelectionModel().getCount()>0) {
			$this.addelectionRecord('VIEW');
			var electionform = $this.getElectionform().getForm();
			$this.populateElectionRecord(grid, electionform, false);
		} else {
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
    editElectionRecord:function(){
		var $this = this;
		var grid = $this.getElectionsgrid();
		if(grid.getSelectionModel().getCount()>0) {
			$this.addelectionRecord('EDIT');
			var electionform = $this.getElectionform().getForm();
			$this.getElectionform().setCode(false);
			$this.populateElectionRecord(grid, electionform, true);
		} else {
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	populateElectionRecord:function(grid, electionform, isEditable){
		var $this = this;
		var record = grid.getSelectionModel().getSelection()[0];
		var form=$this.getElectionform();
		
		var submitUrl = SERVERURL.PATH_ELECTION_FIND_BY_ID;
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl+"?electionId="+record.data.id,
			method : 'GET',
			success : function(resp, action) {
				Ext.getBody().unmask();
				var data = Ext.decode(resp.responseText);
				var electionCode = electionform.findField('electionCode');
				electionCode.setValue(data.electionCode);
				var electionName = electionform.findField('electionName');
				electionName.setValue(data.electionName);
				var votingPool = electionform.findField('votingPool');
				var votingPoolIds= [];
				if(!isNullOrEmpty(data.electionVotingPools)) {
					for(var i in data.electionVotingPools){
						votingPoolIds.push(data.electionVotingPools[i].votingPool);
					}
				}
				
				
				votingPool.getStore().load({
	    			callback:function(records){
	    				
	    					votingPool.setValue(votingPoolIds); 
	    					
	    				}
	    			
	    		});
				var electionType = electionform.findField('electionType');
				
				electionType.getStore().load({
					callback:function(record) {
						electionType.setValue(data.electionTypeCSM.id);
					}
				});
                   var academicTerm = electionform.findField('academicTerm');
				
                   academicTerm.getStore().load({
					callback:function(record) {
						academicTerm.setValue(data.academicTerm.id);
					}
				});
                   var isAdminCaptureVote = electionform.findField('isAdminCaptureVote');
                   var isReferendumOne = electionform.findField('isReferendumOne');
                   var isReferendumTwo = electionform.findField('isReferendumTwo');
                   var isActive = electionform.findField('isActive');
                   var status = electionform.findField('status');
                 
                 //  var isActiveNo = electionform.findField('isActiveNo');
				var electionNameInOtherLang = electionform.findField('electionNameInOtherLang');
				electionNameInOtherLang.setValue(data.electionNameInOtherLanguage);
				var votingStartDate = electionform.findField('votingStartDate');
				votingStartDate.setValue(dateRender(data.votingStartDate));
				var votingEndDate = electionform.findField('votingEndDate');
				votingEndDate.setValue(dateRender(data.votingEndDate));
				
				var votingStartTime = electionform.findField('votingStartTime');
				votingStartTime.setValue(timeRender(data.votingStartTime));
				var votingEndTime = electionform.findField('votingEndTime');
				votingEndTime.setValue(timeRender(data.votingEndTime));
				
				var adminCaptureStartTime = electionform.findField('adminCaptureStartTime');
				adminCaptureStartTime.setValue(timeRender(data.adminCaptureStartTime));
				var adminCaptureEndTime = electionform.findField('adminCaptureEndTime');
				adminCaptureEndTime.setValue(timeRender(data.adminCaptureEndTime));
				
				
				var adminCaptureStartDate = electionform.findField('adminCaptureStartDate');
				adminCaptureStartDate.setValue(dateRender(data.adminCaptureStartDate));
				var adminCaptureEndDate = electionform.findField('adminCaptureEndDate');
				adminCaptureEndDate.setValue(dateRender(data.adminCaptureEndDate));
				
				var referendumOneQuestionInEnglish = electionform.findField('referendumOneQuestionInEnglish');
				referendumOneQuestionInEnglish.setValue(data.referendumOneQuestionInEnglish);
				var referendumOneQuestionInOtherLang = electionform.findField('referendumOneQuestionInOtherLang');
				referendumOneQuestionInOtherLang.setValue(data.referendumOneQuestionInOtherLang);
				
				var referendumTwoQuesInOtherLang = electionform.findField('referendumTwoQuesInOtherLang');
				referendumTwoQuesInOtherLang.setValue(data.referendumTwoQuestionInOtherLang);
				var referendumTwoQuesInEng = electionform.findField('referendumTwoQuesInEng');
				referendumTwoQuesInEng.setValue(data.referendumTwoQuestionInEnglish);
				
				var electionDescriptionInOtherLang = electionform.findField('electionDesInEng');
				electionDescriptionInOtherLang.setValue(data.electionDescriptionInEnglish);
				var electionDescriptionInOtherLang = electionform.findField('electionDescriptionInOtherLang');
				electionDescriptionInOtherLang.setValue(data.electionDescriptionInOtherLang);
				var adminCapStartDateAndTIme = electionform.findField('adminCapStartDateAndTIme');
		     	var adminCapEndDateAndTIme = electionform.findField('adminCapEndDateAndTIme');
		     	
				if(data.isAdminCaptureVote==true){
					isAdminCaptureVote.setValue(true)
					adminCaptureStartDate.setDisabled(false)
					adminCaptureEndDate.setDisabled(false)
					adminCaptureStartTime.setDisabled(false)
					adminCaptureEndTime.setDisabled(false)
					
				}else {
					isAdminCaptureVote.setValue(false)
					form.down('#NoItemId').setValue(true);
				}
				if(data.isReferendumTwo==true){
					isReferendumTwo.setValue(true)
					referendumOneQuestionInEnglish.setDisabled(false)
					referendumOneQuestionInOtherLang.setDisabled(false)
					
				}else{
					isReferendumTwo.setValue(false)
					form.down('#Noreferendum2ItemIdItemId').setValue(true);
				}
				if(data.isReferendumOne==true){
					isReferendumOne.setValue(true)
					referendumTwoQuesInOtherLang.setDisabled(false)
					referendumTwoQuesInEng.setDisabled(false)
					
				}else{
					isReferendumOne.setValue(false)
					form.down('#Noreferendum1ItemIdItemId').setValue(true);
				}
				var id = electionform.findField('id');
				id.setValue(data.id);
				if(data.isActive==true){
		     		isActive.setValue(true)
		     	}else {
		     		isActive.setValue(false)
		     		$this.getElectionform().down('#statusNoItemId').setValue(true);
		     		//isActiveNo.setValue(true)
		     	}
				if(data.isAdminCaptureVote==true){
				$this.getElectionform().down('#adminCapStartDateAndTIme').setDisabled(false);
				$this.getElectionform().down('#adminCapEndDateAndTIme').setDisabled(false);}
				$this.getElectionform().down('#resetBtn').setVisible(false);
				if(!isEditable) {
					$this.getElectionform().down('#submitBtn').setVisible(false);
					$this.getElectionform().down('#resetBtn').setVisible(false);
					$this.toggleReadOnlyFormItems(electionform, true);
				}
			}
		});
	},
	 deleteElectionRecord:function(){
	    	var $this=this;
	    	var d1=new Date()
	    	var grid = $this.getElectionsgrid();
	    	
	    	if (grid.getSelectionModel().getCount() > 0) {
	    		  var record = grid.getSelectionModel().getSelection()[0];
	    		   var votingdate1= new Date(record.data.votingStartDate);
	    		   var votingEndDate=new Date(record.data.votingEndDate);
	    		   var isElectionDeteled=false;
	    		   if(votingdate1>d1 ){
		      			isElectionDeteled=true;
		      		}else if (votingdate1<d1 && votingEndDate<d1){
		      			isElectionDeteled=true;
		      		}else if(votingdate1<d1 && votingEndDate>d1){
		      			isElectionDeteled=false;
		      		}
	      		if(isElectionDeteled){
	    		showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	    			if (btn == 'yes') {
	    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	    				var records = grid.getSelectionModel().getSelection();
	    				var id = records[0].get("id");
	    				Ext.Ajax.request({
	    					method : "DELETE",
	    					type : 'rest',
	    					url : SERVERURL.PATH_ELECTION_DELETE +'?id='+ id,
	    					headers : {
	    						'Content-Type' : 'application/json'
	    					},
	    					params: {
								id: id
							},
	    					success : function(form,action) {
	    						Ext.getBody().unmask();
	    						
	    							grid.getStore().reload();
	    							showSuccessMessage(getCommonTranslation('ELECTION'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
	    						
	    					}
	    				});
	    			}
	    		});
	      		}else{
	      			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ELECTION_IS_WORKING'));
	      		}
	      		}else {
	    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	    	}
	   },
	   
	   onChangeAdminCaptureRadioGroup : function(formWin, newValue) {
			 
	     	
	     	//var votingStartDateItemId = formWin.down('#votingStartDateItemId');
	     	var adminCapStartDateAndTIme = formWin.down('#adminCapStartDateAndTIme');
	     	var adminCapEndDateAndTIme = formWin.down('#adminCapEndDateAndTIme');
	     	var adminCaptureStartDateItemId = formWin.down('#adminCaptureStartDateItemId');
	     	var adminCaptureStartTime = formWin.down('#adminCaptureStartTime');
	     	var adminCaptureEndDate = formWin.down('#adminCaptureEndDate');
	     	var adminCaptureEndTime = formWin.down('#adminCaptureEndTime');
	     	var saveBtn = formWin.down('#submitBtn');
	     	var labelAdminCapStartDateAndTIme=adminCapStartDateAndTIme.title;
	     	var labelAdminCapEndDateAndTIme  =	adminCapEndDateAndTIme.title;
	     	if(newValue.isAdminCaptureVote == true){
	     		
	     		adminCapStartDateAndTIme.setDisabled(false);
	     		adminCapEndDateAndTIme.setDisabled(false);
	     		adminCaptureStartDateItemId.setDisabled(false);
	     		adminCaptureStartTime.setDisabled(false);
	     		adminCaptureEndDate.setDisabled(false);
	     		adminCaptureEndTime.setDisabled(false);
	     		//adminCapStartDateAndTIme.setTitle(labelAdminCapStartDateAndTIme+ ': <span class="required" style="color:red"> *</span>');
	     		//adminCapEndDateAndTIme.setTitle(labelAdminCapEndDateAndTIme+ ': <span class="required" style="color:red"> *</span>');
	     		
	     		/*adminCapStartDateAndTIme.allowBlank = true;
	     		adminCapEndDateAndTIme.allowBlank = true;
	     		adminCaptureStartDateItemId.allowBlank = true;
	     		adminCaptureStartTime.allowBlank = true;
	     		
	     		adminCaptureEndDate.allowBlank = true;
	     		adminCaptureEndTime.allowBlank = true;*/
	     		if(formWin.isValid()){
					saveBtn.setDisabled(false);
				}
	     		
	     	} else {
	     		adminCaptureStartDateItemId.setDisabled(true);
	     		adminCaptureStartTime.setDisabled(true);
	     		adminCaptureEndDate.setDisabled(true);
	     		adminCaptureEndTime.setDisabled(true);
	     		
	     		adminCapStartDateAndTIme.setDisabled(true);
	     		adminCapEndDateAndTIme.setDisabled(true);
	     		
	     		adminCaptureStartDateItemId.reset();
	     		adminCaptureStartTime.reset();
	     		adminCaptureEndDate.reset();
	     		adminCaptureEndTime.reset();
	     		if(formWin.isValid()){
					saveBtn.setDisabled(false);
				}
	     		/*adminCaptureStartDateItemId.allowBlank = false;
	     		adminCaptureStartTime.allowBlank = false;
	     		adminCaptureEndDate.allowBlank = false;
	     		adminCaptureEndTime.allowBlank = false;*/
	     		//adminCapStartDateAndTIme.setTitle(labelAdminCapStartDateAndTIme);
	     		//adminCapEndDateAndTIme.setTitle(labelAdminCapEndDateAndTIme);
	     		
	     		
	     	}
	     	
		 },
		 onChangeReferendumRadioGroup : function(formWin, newValue) {
			 
		     	
		     	var referendumOneQuestionInEnglish = formWin.down('#referendumOneQuestionInEnglish');
		     	var referendumOneQuestionInOtherLang = formWin.down('#referendumOneQuestionInOtherLang');
		     	if(newValue.isReferendumOne == true){
		     		referendumOneQuestionInEnglish.setDisabled(false);
		     		referendumOneQuestionInOtherLang.setDisabled(false);
		     		referendumOneQuestionInEnglish.allowBlank = true;
		     		referendumOneQuestionInOtherLang.allowBlank = true;
		     		} else {
		     			
		     		referendumOneQuestionInEnglish.setDisabled(true);
		     		referendumOneQuestionInOtherLang.setDisabled(true);
		     		referendumOneQuestionInEnglish.reset();
		     		referendumOneQuestionInOtherLang.reset();
		     		referendumOneQuestionInEnglish.allowBlank = false;
		     		referendumOneQuestionInEnglish.allowBlank = false;
		     		
		     	}
		     	
			 },
			 onChangeReferendumTwoRadioGroup : function(formWin, newValue) {
	                    var referendumTwoQuesInEng = formWin.down('#referendumTwoQuesInEng');
			     	var referendumTwoQuesInOtherLang = formWin.down('#referendumTwoQuesInOtherLang');
			     	if(newValue.isReferendumTwo == true){
			     		referendumTwoQuesInEng.setDisabled(false);
			     		referendumTwoQuesInOtherLang.setDisabled(false);
			     		referendumTwoQuesInEng.allowBlank = true;
			     		referendumTwoQuesInOtherLang.allowBlank = true;
			     	} else {
			     		referendumTwoQuesInEng.setDisabled(true);
			     		referendumTwoQuesInOtherLang.setDisabled(true);
			     		referendumTwoQuesInEng.reset();
			     		referendumTwoQuesInOtherLang.reset();
			     		referendumTwoQuesInEng.allowBlank = false;
			     		referendumTwoQuesInOtherLang.allowBlank = false;
			     		
			     	}
			     	
				 },
				 resetElectionFilter: function() {
				        var $this = this;
				        var filter = $this.getElectionfilter().getForm();
				        filter.reset();
				        var serviceName=filter.findField('electioncCodeName');
						serviceName.reset();
						  serviceName.getStore().getProxy().extraParams={
							 
						  };
						  serviceName.getStore().load();
						  
						$this.loadElectionGrid();
				    },
				    getElectionCondidate : function(){
				   		var grid = this.getElectionsgrid();
				   		if (grid.getSelectionModel().getCount() > 0) {
				   			var contentpanel = this.getContentPanel();
				   			var structure = Ext.widget('electoncandidatestructure');
				   			var tabName = getCommonTranslation('CANDIDATE_LIST');
				   			var getcontroller=this.getController('menu.CoreERPNavigationController');
				   			var getTab=getcontroller.getTab(tabName);
				   			if(getTab!=null){
				   				contentpanel.remove(getTab, true);
				   			}
				   			openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_NINE);
				   		}else{
				   			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
				   		}
				   	},
				   	getElectionVoterPool : function(){
				   		var grid = this.getElectionsgrid();
				   		if (grid.getSelectionModel().getCount() > 0) {
				   			var contentpanel = this.getContentPanel();
				   			var structure = Ext.widget('electonvoterpoolstructure');
				   			var tabName = getCommonTranslation('VOTER_POOL');
				   			var getcontroller=this.getController('menu.CoreERPNavigationController');
				   			var getTab=getcontroller.getTab(tabName);
				   			if(getTab!=null){
				   				contentpanel.remove(getTab, true);
				   			}
				   			openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_NINE);
				   			var record=grid.getSelectionModel().getSelection()[0].data;
				   			var s =structure.down('#resourceBookingTabPanel');
				   			var poolArray= [];
			   				
				   			
				   			record.electionVotingPools.forEach(function(obj){
				   			
				   				poolArray.push(obj.votingPool);
				   				
				   				
							});
				   			if(!Ext.Array.contains(poolArray, 'EXTERNAL_USERS')){
			   					structure.down('#externalUserPanel').destroy();
			   				}
				   			if(!Ext.Array.contains(poolArray, 'STAFF_USERS')){
			   					structure.down('#staffAndUsersPanel').destroy();
			   				}
				   			if(!Ext.Array.contains(poolArray, 'STUDENTS')){
			   					structure.down('#stdentPanel').destroy();
			   				}
				   			
				   		}else{
				   			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
				   		}
				   	},
				   	getRenderCandidate : function(grid){
				   		var this$ = this;
				   		var structure = this$.getElectoncandidatestructure();
				        var vehicleList = this$.getElectionsgrid();
				        var record = vehicleList.getSelectionModel().getSelection()[0];
				        var electionNameCode=record.get("electionCode")+ "/"+ record.get("electionName");
				        structure.down("#electionName").setValue(electionNameCode);
				        var votingdate=dateRender(record.get("votingStartDate")) +" - "+ timeRender(record.get("votingStartTime"));
				        var votingEndDate=dateRender(record.get("votingEndDate")) +" - "+timeRender(record.get("votingEndTime"));
				      
				        structure.down("#electionType").setValue(record.get("electionTypeCSM").value);
				        structure.down("#academicTerm").setValue(record.get("academicTerm").value);
				        structure.down("#votingStartDate").setValue(votingdate);
				        structure.down("#votingEndDate").setValue(votingEndDate);
				       structure.down("#electionId").setValue(record.get("id"));
				        var store = grid.getStore();
				        store.getProxy().extraParams = {
				   	    	electionId : record.get("id")
				   		};
				   	    store.sorters.clear();
				   	    store.load();
				
				   	},
					getRenderVoterPool : function(grid){
				   		var this$ = this;
				   		var structure = this$.getElectonvoterpoolstructure();
				        var vehicleList = this$.getElectionsgrid();
				        var record = vehicleList.getSelectionModel().getSelection()[0];
				        var electionNameCode=record.get("electionCode")+ "/"+ record.get("electionName");
				        structure.down("#electionName").setValue(electionNameCode);
				        var votingdate=dateRender(record.get("votingStartDate")) +" - "+ timeRender(record.get("votingStartTime"));
				        var votingEndDate=dateRender(record.get("votingEndDate")) +" - "+timeRender(record.get("votingEndTime"));
				        structure.down("#electionType").setValue(record.get("electionTypeCSM").value);
				        structure.down("#academicTerm").setValue(record.get("academicTerm").value);
				        structure.down("#votingStartDate").setValue(votingdate);
				        structure.down("#votingEndDate").setValue(votingEndDate);
				        structure.down("#electionId").setValue(record.get("id"));
				        
				        var captureBollotVotesBtn = grid.down("#captureBollotVotesBtn");
				        if(structure.config.isAdminCaptureVote){
				        	captureBollotVotesBtn.setDisabled(false);
				        }else{
				        	captureBollotVotesBtn.setDisabled(true);
				        }
				        
				        var store = grid.getStore();
				   	    store.getProxy().extraParams = {
				   	    	electionId : record.get("id")
				   		};
				   	    store.sorters.clear();
				   	    store.load();
				   	},
				   	getRenderVoterPoolExternal : function(grid){
				   		var this$ = this;
				   		var structure = this$.getElectonvoterpoolstructure();
				        var vehicleList = this$.getElectionsgrid();
				        var record = vehicleList.getSelectionModel().getSelection()[0];
				        var electionNameCode=record.get("electionCode")+ "/"+ record.get("electionName");
				        structure.down("#electionName").setValue(electionNameCode);
				        var votingdate=dateRender(record.get("votingStartDate")) +" - "+ timeRender(record.get("votingStartTime"));
				        var votingEndDate=dateRender(record.get("votingEndDate")) +" - "+timeRender(record.get("votingEndTime"));
				        structure.down("#electionType").setValue(record.get("electionTypeCSM").value);
				        structure.down("#academicTerm").setValue(record.get("academicTerm").value);
				        structure.down("#votingStartDate").setValue(votingdate);
				        structure.down("#votingEndDate").setValue(votingEndDate);
				        structure.down("#electionId").setValue(record.get("id"));
				        
				        var captureBollotVotesBtn = grid.down("#captureBollotVotesBtn");
				        
				        if(structure.config.isAdminCaptureVote){
				        	captureBollotVotesBtn.setDisabled(false);
				        }else{
				        	captureBollotVotesBtn.setDisabled(true);
				        }
				        
				        var store = grid.getStore();
				   	    store.getProxy().extraParams = {
				   	    	electionId : record.get("id")
				   		};
				   	    store.sorters.clear();
				   	    store.load();
				   	},
				    getIdValueJson: function(id, value) {
				   		if (id) return {
				   			id: id,
				   			value: value
				   		};
				   	},
				   	getShowCandidateWin:function(){
				   		var frmWin = this.getCandidatedetailwin();
				   		if(!frmWin){
				   			Ext.widget('candidatedetailwin');
				   			frmWin = this.getCandidatedetailwin();
				   		}
				   		frmWin.show();
				   	},
					getSaveCandidateDetail : function(){
				   		var this$ = this;
				   		var grid = this$.getCandidategrid();
				   		var gridStore = grid.getStore();
				   		var win = this$.getCandidatedetailwin();
				   		var form = win.down('form');
				   		var values = form.getForm().getValues();

				   		var structure = this$.getElectoncandidatestructure();
				   		var electionId = structure.down("#electionId").getValue();
				   		var record = grid.getSelectionModel().getSelection()[0];
				   		var candidateModel = new Academia.model.election.election.ElectionCandidateGridDataModel();
				   		candidateModel.set("id",values.id);
				   		candidateModel.set("election",this$.getIdValueJson(electionId));
				   		candidateModel.set("nameInEnglish",values.listName);
				   		candidateModel.set("nameInOtherLanguage",values.listNameOthLang);
				   		candidateModel.set("maximumVoteInList",values.maximumVotesList);
				   		candidateModel.set("isActive",values.isActive);
				   		candidateModel.set("remark",values.electionDesInEng);
				   		

				   		var submitUrl = SERVERURL.PATH_ELECTION_LIST_SAVE; 

				   		var id = values.id;
				   		if(!isNullOrEmpty(values.id)) {
				   			submitUrl = SERVERURL.PATH_ELECTION_LIST_UPDATE;
				   		}
				   		var submitData = Ext.encode(candidateModel.data);
				   		this$.applyWindowMask(); 

				   		Ext.Ajax.request({
				   			url: submitUrl,
				   			jsonData: submitData,
				   			method: 'POST',
				   			success: function(response) {
				   				this$.hideWindowMask();
				   				this$.getCloseCandidateWin();
				   				gridStore.reload();
				   				grid.getSelectionModel().deselectAll(true);
								var candidateInfoGrid = this$.getCandidatesinformationgrid();
								var addBtn=candidateInfoGrid.down('#btnAdd');
								addBtn.setDisabled(true);
				   				if(!isNullOrEmpty(id)) {
				   					showSuccessMessage(getCommonTranslation('CANDIDATE_LIST'),getCommonTranslation('RECORD_UPDATE_SUCCESS'));
				   				} else {
				   					showSuccessMessage(getCommonTranslation('CANDIDATE_LIST'),getCommonTranslation('RECORD_ADD_SUCCESS'));
				   				}
				   			}
				   		});
				   	},
				   	getCloseCandidateWin : function(){
				   		this.getCandidatedetailwin().close();
				   	},
				   	getEditCandidate : function(){
				   		var this$ = this;
				   		var grid = this$.getCandidategrid();
				    	if (grid.getSelectionModel().getCount() > 0) {
				    		this$.getShowCandidateWin();
				    		var win = this$.getCandidatedetailwin();
				       		var form = win.down('form');
				    		var record = grid.getSelectionModel().getSelection()[0];
				    		var id = record.get("id");
				    		var listName= win.down('#listNameItemId');
				    		var listNameOthLang= win.down('#listNameOthLangItemId');
				    		var maximumVotesList= win.down('#maximumVotesList');
				    		var status= win.down('#status');
				    		   var isActive = win.down('#statusYesItemId');
				    		var electionDesInEng= win.down('#electionDesInEng');
				    		win.down('#id').setValue(record.data.id);
				    		listName.setValue(record.data.nameInEnglish);
				    		listNameOthLang.setValue(record.data.nameInOtherLanguage);
				    		maximumVotesList.setValue(record.data.maximumVoteInList);
				    		if(record.data.isActive==true){
					     		isActive.setValue(true)
					     	}else {
					     		isActive.setValue(false)
					     		
					     	}
				    		
				    		electionDesInEng.setValue(record.data.remark);
				    		

				    		
				    		}else{
				    			 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
				    		}
				   	},
					getViewCandidate : function(){
				   		this.getEditCandidate();
				 		var win = this.getCandidatedetailwin();
				 		if (win) {
				 			var form = win.down('form');
				 			form.down('#SubmitBtnCandidate').setVisible(false);
				 			form = form.getForm();
				 			toggleReadOnlyFormItems(form,true);
				 			win.doLayout()
				 		}
				   	},
				   	getDeleteCandidate: function(){
				        var this$ = this;
				        var grid = this$.getCandidategrid();
				    	var grdStore = grid.getStore();
				    	if (grid.getSelectionModel().getCount() > 0) {
				    		showConfirmMessage(getCommonTranslation('CANDIDATE_LIST'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
				    			if (btn == 'yes') {
									var records = grid.getSelectionModel().getSelection();
									var id = records[0].data.id;
									Ext.Ajax.request({
										type: 'rest',
										method: 'DELETE',
										url: SERVERURL.PATH_ELECTION_LIST_DELETE  +'?id='+ id,
										headers: {
											'Content-Type': 'application/json'
										},
										params: {
											id: id
										},
										success: function(form, action) {
											
												showSuccessMessage(getCommonTranslation('CANDIDATE_LIST'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
												this$.resetPageSetting(grdStore);
												grdStore.reload();
											
										},
										failure: function(form, action) {
											showWarningMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
										}
									});
								}
				    		});
				    	} else {
				    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
				    	}
				    },
				    getShowCandidateInformationWin:function(){
				   		var frmWin = this.getCandidateinfowin();
				   		if(!frmWin){
				   			Ext.widget('candidateinfowin');
				   			frmWin = this.getCandidateinfowin();
				   		}
				   		
				   		frmWin.show();
				   		var gridRecord=this.getCandidategrid();
				   		
				   		var record = gridRecord.getSelectionModel().getSelection()
				   		var sgForm = frmWin.down('form');
				   		var candidateListName =sgForm.down('#candidateListNameItemId');
				   		var candidateListNameStore = candidateListName.getStore();
				   		candidateListNameStore.load({
							callback: function(records, operation, success) {
								if (!isNullOrEmpty(record[0].data.id)) {
									candidateListName.setValue(record[0].data.id);
								}
							}
						});
				   		
				   		candidateListName.setReadOnly(true);
				   		
				   		
				   	},
				   
				    getStudentDetails : function(){
				    	 var win = this.getCandidateinfowin();
				       		var sgForm = win.down('form');
                 	   var id=sgForm.down("#studentItemId").displayTplData[0].id;
                 	   var mobileField = sgForm.down("#mobileNo");
                 	   var countryCodeField=sgForm.down("#cellCountryCode");
                 	   var emailId = sgForm.down("#emailId");
                 	  var program = sgForm.down("#program");
       				 this.setMaximumMinimumDigitsForMobileNoValidation(sgForm,countryCodeField,mobileField,null);

                 	   Ext.Ajax
                 	   .request({
                 		   method : "GET",
                 		   type : 'rest',
                 		   url : SERVERURL.PATH_GET_STUDENT_DETAIL,
                 		   params : {
                 			  userId : id,
                 		   },
                 		   headers : {
                 			   'Content-Type' : 'application/json'
                 		   },
                 		   success : function(response, action) {
                 			   var data=Ext.decode(response.responseText);
                 			   countryCodeField.setValue(data.mobileCountryCode);
                 			   mobileField.setValue(data.mobileNumber);
                 			   emailId.setValue(data.emailId);
                  			  program.getStore().load({
                					callback:function(records, operation, success) {
                						 for(var  i in records){
                							 if(records[i].data.id==data.progId){
                								program.setValue(records[i].data.id);
                							 }
                						
                					}
                						 }
                   			  
                				});
                 			   countryCodeField.setReadOnly(true);
                 			   mobileField.setReadOnly(true);
                 			   emailId.setReadOnly(true);

                 		   }
                 	   });
                    },
                    getExternalUser : function(){
				    	 var win = this.getCandidateinfowin();
				       		var sgForm = win.down('form');
                	   var id=sgForm.down("#studentItemId").getValue();
                	   var mobileField = sgForm.down("#mobileNo");
                	   var countryCodeField=sgForm.down("#cellCountryCode");
                	   var emailId = sgForm.down("#emailId");
                	   countryCodeField.setReadOnly(false);
         			   mobileField.setReadOnly(false);
         			   emailId.setReadOnly(false);
         			
      				 this.setMaximumMinimumDigitsForMobileNoValidation(sgForm,countryCodeField,mobileField,null);

                	   
                   },
                    getfacultyInfoDetails : function(){
                    	 var win = this.getCandidateinfowin();
				       		var sgForm = win.down('form');
                 	   var staffId=sgForm.down("#employeeId").displayTplData[0].id;
                 	   var mobileField = sgForm.down("#mobileNo");
                 	   var countryCodeField=sgForm.down("#cellCountryCode");
           			   this.setMaximumMinimumDigitsForMobileNoValidation(sgForm,countryCodeField,mobileField,null);
                        var emailId = sgForm.down("#emailId");
                        var department = sgForm.down("#departmentId");
 					   var submitUrl = SERVERURL.PATH_GET_STAFF_DETAIL;
 					   Ext.Ajax.request({
				    		   type : 'rest',
				    		   url : submitUrl,
				    		   params: {
				    			   userId: staffId,
				               },
				    		  /// jsonData : formData,
				    		   method : 'GET',
				    		   async: false,
				    		   success : function(frm, action) {
				    			   var data = Ext.JSON.decode(frm.responseText);
                 			   countryCodeField.setValue(data.mobileCountryCode);
                 			   mobileField.setValue(data.mobileNumber);
                 			   emailId.setValue(data.emailId);
                 			  department.getStore().load({
              					callback:function(records, operation, success) {
              						 for(var  i in records){
                							 if(records[i].data.id==data.deptId){
                								department.setValue(records[i].data.id);
                							 }
                						
                					}
              						//department.setValue(data.deptId);
              					}
              				});
                 			   countryCodeField.setReadOnly(true);
                 			   mobileField.setReadOnly(true);
                 			   emailId.setReadOnly(true);
                 			  department.setReadOnly(true);
				    		   }
				    	   });
                    },
				    disableMoreActionPivileges: function(grid,permissionMap){

				    	var associatedAcadLocationIds = new Array();
				    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
						var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
				    	
						
						var spBtnMoreActions = grid.down('#spBtnMoreActions');
						spBtnMoreActions.setVisible(false);
				    	var condidateLink = grid.down('#condidateLink');
				    	condidateLink.setVisible(false);
				    	var voterPoolLink = grid.down('#voterPoolLink');
				    	voterPoolLink.setVisible(false);
				    	var electionResultLink = grid.down('#electionResultLink');
				    	electionResultLink.setVisible(false);
				    	var copyElectionLink = grid.down('#copyElectionLink');
				    	copyElectionLink.setVisible(false);
				    	var printElectionSheetLink = grid.down('#printElectionSheetLink');
				    	printElectionSheetLink.setVisible(false);
				    	
				    	
				    	Ext.each(permissionList, function(privilege) {
				    		
				    		if (privilege === 'MOREACTIONS') {
				        		if(!isNullOrEmpty(spBtnMoreActions)){
				        			spBtnMoreActions.setVisible(true);
				        		}        		
				        	}
				    		if (privilege === 'CANDIDATE_LIST') {
				        		if(!isNullOrEmpty(condidateLink)){
				        			condidateLink.setVisible(true);
				        		}        		
				        	}
				    		if (privilege === 'VOTER_POOL') {
				        		if(!isNullOrEmpty(voterPoolLink)){
				        			voterPoolLink.setVisible(true);
				        		}        		
				        	}
				    		if (privilege === 'ELECTION_RESULTS') {
				        		if(!isNullOrEmpty(electionResultLink)){
				        			electionResultLink.setVisible(false);
				        		}        		
				        	}
				    		if (privilege === 'COPY_ELECTION') {
				        		if(!isNullOrEmpty(copyElectionLink)){
				        			copyElectionLink.setVisible(true);
				        		}        		
				        	}
				    		if (privilege === 'PRINT_ELECTION_SHEET') {
				        		if(!isNullOrEmpty(printElectionSheetLink)){
				        			printElectionSheetLink.setVisible(true);
				        		}        		
				        	}
				    						 
				    	});
				    
				    },
				    disableChangeWeightagePivileges: function(grid,permissionMap){

				    	var this$ = this;
				    	var associatedAcadLocationIds = new Array();
				    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
						var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
						var captureBollotVotesBtn = grid.down('#captureBollotVotesBtn');
						captureBollotVotesBtn.setVisible(false);
				    	var sendMessageBtn = grid.down('#sendMessageBtn');
				    	sendMessageBtn.setVisible(false);
				    	var changeWeightage = grid.down('#changeWeightage');
				    	changeWeightage.setVisible(false);
				    	
				    	Ext.each(permissionList, function(privilege) {
				    		
				    		if (privilege === 'CAPTURE_BALLOT_VOTE') {
				        		if(!isNullOrEmpty(captureBollotVotesBtn)){
				        			captureBollotVotesBtn.setVisible(true);
				        		}        		
				        	}
				    		if (privilege === 'SENDMESSAGE') {
				        		if(!isNullOrEmpty(sendMessageBtn)){
				        			sendMessageBtn.setVisible(true);
				        		}        		
				        	}
				    		if (privilege === 'CHANGE_WEIGHTAGE') {
				        		if(!isNullOrEmpty(changeWeightage)){
				        			changeWeightage.setVisible(true);
				        			var structure = this$.getElectonvoterpoolstructure();
				        			var electionId = structure.down("#electionId").getValue();
				        			 Ext.Ajax.request({
	                    				 method : "GET",
	                    				 type : 'rest',
	                    				 url: SERVERURL.PATH_FIND_ELECTION_STATUS,
	                    				 params: {
	                    					 electionId : electionId,
	                    					 voteCaptureBy : "SELF"
	                    				 },
	                    				 headers : {
	                    					 'Content-Type' : 'application/json'
	                    				 },
	                    				 success: function(response) {
	                    					 var data = Ext.decode(response.responseText);
	                    					 if(data!="NOT_STARTED"){
	                    						 changeWeightage.setDisabled(true);
	                    					 }
	                    				 }
				        			 });
				        		}        		
				        	}
				 
				    	});
				    
				    },
				    getSaveCandidateInfoWin : function(){
				   		var this$ = this;
				   		var userName='';
				   		var grid = this$.getCandidatesinformationgrid();
				   		var gridStore = grid.getStore();
				   		var win = this$.getCandidateinfowin();
				   		var form = win.down('form');
				   		var values = form.getForm().getValues();

				   	/*	var structure = this$.getElectoncandidatestructure();
				   		var electionId = structure.down("#electionId").getValue();*/
				   		var record = grid.getSelectionModel().getSelection()[0];
				   		var candidateInfoModel = new Academia.model.election.election.ElectionCandidateInfoGridDataModel();
				   
				   	//	candidateInfoModel.set("electionList",this$.getIdValueJson(electionId));
				   		if(values.candidateListName!=null)
				   		candidateInfoModel.set("electionCandidateList",this$.getIdValueJson(values.candidateListName));
				   		candidateInfoModel.set("candidateType",values.candidateType);
				   		candidateInfoModel.set("mobileCountryCode",values.mobileCountryCode);
				   		candidateInfoModel.set("mobileNumber",values.mobileNo);
				   		candidateInfoModel.set("emailId",values.emailId);
				   		candidateInfoModel.set("id",values.id[0]);
				   		/*candidateInfoModel.set("department",values.department);
				   		candidateInfoModel.set("program",values.program);*/
				   		var id=candidateInfoModel.data.id;	
				   	
				   		candidateInfoModel.set("candidateStatement",values.candidateStatement);
				   		if(values.candidateType=="STUDENTS"){
				   			candidateInfoModel.set("candidate",this$.getIdValueJson(values.studentId));
				   			candidateInfoModel.set("program",this$.getIdValueJson(values.program));
				   			delete candidateInfoModel.data.department;
				   			var stdname =form.down("#studentItemId").getRawValue();
				   			if(stdname!=null){
				   				var std=stdname.split("/");
				   				userName =	std[0].replace(" ","");
				   			}
				   		}else if(values.candidateType=="STAFF_USERS"){
				   			candidateInfoModel.set("candidate",this$.getIdValueJson(values.employee));
				   			
				   			candidateInfoModel.set("department",this$.getIdValueJson(values.department));
				   			delete candidateInfoModel.data.program;
				   			var employeeId =form.down("#employeeId").getRawValue();
				   			if(employeeId!=null){
				   				var std=employeeId.split("/");
				   				userName =	std[0].replace(" ","");
				   			}
				   		}else{
				   			candidateInfoModel.set("candidateName",values.externalUserId);
				   			userName=values.externalUserId;
				   			delete candidateInfoModel["data"].candidate;
				   			delete candidateInfoModel.data.department;
				   			delete candidateInfoModel.data.program;
				   		}
				   		var submitUrl;
				   		var imagePath = form.down('#imageUploadField').getValue();
				   		if(candidateInfoModel.data.id!=""){
				   			submitUrl = SERVERURL.PATH_ELECTION_CANDIDATE_INFO_UPDATE;
				   			if(isNullOrEmpty(imagePath)) {
				   				candidateInfoModel.set("imageUrl",record.data.imageUrl);
				   			}
				   		}else
                       submitUrl = SERVERURL.PATH_ELECTION_CANDIDATE_INFO_SAVE;
				   		
				   		this$.applyWindowMask(); 
				   		
						 if(!isNullOrEmpty(imagePath)){
									form.getForm().submit({
							             type: 'rest',
							             url: SERVERURL.PATH_ELECTION_LIST_CANDIDATE_UPLOAD_IMAGE,
							             method: 'POST',
							             params:{
							            	 userName : userName
							        	 },
							        	 success : function(form, action) {
							            this$.hideWindowMask();
							            	var  imageUrl= action.result.path;
							            	candidateInfoModel.set("imageUrl",imageUrl);
							            	 var submitData = Ext.encode(candidateInfoModel.data);
							            	 Ext.Ajax.request({
										   			url: submitUrl,
										   			jsonData: submitData,
										   			method: 'POST',
										   			success: function(response) {
										   				this$.hideWindowMask();
										   				var candidateInfoId= response.responseText;
										   			//	this$.uploadImageCandidateInfo(candidateInfoId,form);
										   				
										   				
										   				this$.getCloseCandidateInfoWin();
										   				if(!isNullOrEmpty(id)) {
										   					showSuccessMessage(getCommonTranslation('CANDIDATES_INFORMATION'),getCommonTranslation('RECORD_UPDATE_SUCCESS'));
										   				} else {
										   					showSuccessMessage(getCommonTranslation('CANDIDATES_INFORMATION'),getCommonTranslation('RECORD_ADD_SUCCESS'));
										   				}
										   			//	showSuccessMessage(getCommonTranslation('CANDIDATES_INFORMATION'),getCommonTranslation('RECORD_ADD_SUCCESS'));
										   				gridStore.reload();
										   				grid.getSelectionModel().deselectAll(true);
										   				
										   					
										   				
										   			}
							            	 });
                                              
								   				
							             }
									});
								}else{
									//candidateInfoModel.set("imageUrl",imageUrl);
					            	 var submitData = Ext.encode(candidateInfoModel.data);
					            	 Ext.Ajax.request({
								   			url: submitUrl,
								   			jsonData: submitData,
								   			method: 'POST',
								   			success: function(response) {
								   				this$.hideWindowMask();
								   				var candidateInfoId= response.responseText;
								   			//	this$.uploadImageCandidateInfo(candidateInfoId,form);
								   				
								   				
								   				this$.getCloseCandidateInfoWin();
								   				if(!isNullOrEmpty(id)) {
								   					showSuccessMessage(getCommonTranslation('CANDIDATES_INFORMATION'),getCommonTranslation('RECORD_UPDATE_SUCCESS'));
								   				} else {
								   					showSuccessMessage(getCommonTranslation('CANDIDATES_INFORMATION'),getCommonTranslation('RECORD_ADD_SUCCESS'));
								   				}								   				
								   				gridStore.reload();
								   				grid.getSelectionModel().deselectAll(true);
								   				
								   					
								   				
								   			}
					            	 });
								}

			        	 

				   		

				   	},
				   	getCloseCandidateInfoWin : function(){
				   		this.getCandidateinfowin().close();
				   	},
				   	getEditCandidateInfoWin : function(){
				   		var this$ = this;
				   		var grid = this$.getCandidatesinformationgrid();
				    	if (grid.getSelectionModel().getCount() > 0) {
				    		this$.getShowCandidateInformationWin();
				    		var win = this$.getCandidateinfowin();
				       		var form = win.down('form');
				    		var record = grid.getSelectionModel().getSelection()[0];
				    		var id = record.get("id");
				    		var listName= win.down('#candidateListNameItemId');
				    		var candidateType= win.down('#candidateType');
				    		var studentNameField= win.down('#studentItemId');
				    		var staffs= win.down('#employeeId');
				    		var applicantNameField= win.down('#externalUserId');
				    		var cellCountryCode= win.down('#cellCountryCode');
				    		var mobileNo= win.down('#mobileNo');
				    		var emailId= win.down('#emailId');
				    		var departmentField= win.down('#departmentId');
				    		var program= win.down('#program');
				    		var candidateStatement= win.down('#candidateStatement');
				    		win.down('#id').setValue(record.data.id);
				    		candidateStatement.setValue(record.data.candidateStatement);
				    		emailId.setValue(record.data.emailId);
				    		
				    		cellCountryCode.setValue(record.data.mobileCountryCode);
				    		mobileNo.setValue(record.data.mobileNumber);
				    		candidateType.getStore().load({
								callback:function(records) {
									candidateType.setValue(record.data.candidateType);
								}
							});
				    		var type=record.data.candidateTyp;
				    		 if(record.data.candidateType=="STUDENTS"){
				    			this.loadDFRForCandidateInformation(form,type);
				    			studentNameField.store.getProxy().extraParams = {
				    		    studentNameOrCode: record.data.candidateName
				    		        };
				    			 studentNameField.store.load({
                  				   callback : function(records,operation,success) {
                  					   if (success) {
                  						   studentNameField.setValue(record.data.userId);
                  						 //this$.getStudentDetails();
                  					   }
                  				   }
                  			   });
				    			 
				    			 program.store.load({
	                  				   callback : function(records,operation,success) {
	                  					   if (success) {
	                  						 program.setValue(record.data.program.id);
	                  						 //this$.getStudentDetails();
	                  					   }
	                  				   }
	                  			   });
				    			 cellCountryCode.setValue(record.data.mobileCountryCode);
			 				
			 					  studentNameField.setVisible(true)
			 					   program.setVisible(true)
			 					  studentNameField.allowBlank=false
			 					  program.allowBlank=false
			 					  
			 					  applicantNameField.reset();
			 					  departmentField.reset();
			 					  program.reset();
			 					  staffs.reset();
			 					  applicantNameField.setVisible(false)
								  staffs.setVisible(false)
								  departmentField.setVisible(false)
								  staffs.allowBlank=true
								  departmentField.allowBlank=true
								  applicantNameField.allowBlank=true
								 

			 				   }else if(record.data.candidateType=="STAFF_USERS"){
			 					  this.loadDFRForCandidateInformation(form,type);
			 					  staffs.store.load({
	                  				   callback : function(records,operation,success) {
	                  					   if (success) {
	                  						 staffs.setValue(record.data.userId);
	                  						// this$.getfacultyInfoDetails();
	                  					   }
	                  				   }
	                  			   });
			 					  
				 					 departmentField.store.load({
		                  				   callback : function(records,operation,success) {
		                  					   if (success) {
		                  						 departmentField.setValue(record.data.department.id);
		                  						 //this$.getStudentDetails();
		                  					   }
		                  				   }
		                  			   });
				 					cellCountryCode.setValue(record.data.mobileCountryCode);
								
								  departmentField.setVisible(true)
			 					  staffs.setVisible(true)
			 					  staffs.allowBlank=false
			 					  departmentField.allowBlank=false
								 
			 					 applicantNameField.reset();
								 studentNameField.reset();
								 program.reset();
								 departmentField.reset();
			 					
			 				    	
			 				      program.setVisible(false)
			 					  applicantNameField.setVisible(false)
								  studentNameField.setVisible(false)
								  studentNameField.allowBlank=true
								  applicantNameField.allowBlank=true
								  program.allowBlank=true
								 
			 				   }else if(record.data.candidateType=="EXTERNAL_USERS"){
			 					  this.loadDFRForCandidateInformation(form,type);
			 					  applicantNameField.setValue(record.data.candidateName)
			 					 applicantNameField.setVisible(true)
			 					  applicantNameField.allowBlank=false
			 					 
			 					  staffs.reset();
			  					 studentNameField.reset();
			  					program.reset();
								 departmentField.reset();
								 
								  staffs.setVisible(false)
								  studentNameField.setVisible(false)
								   departmentField.setVisible(false)
								    program.setVisible(false)
								  studentNameField.allowBlank=true
								  staffs.allowBlank=true
								  departmentField.allowBlank=true
			 					  program.allowBlank=true
			 					 var win = this.getCandidateinfowin();
						       		var sgForm = win.down('form');
			          	 
			          	   var mobileField = sgForm.down("#mobileNo");
			          	   var countryCodeField=sgForm.down("#cellCountryCode");
			          	   var emailId = sgForm.down("#emailId");
			          	   countryCodeField.setReadOnly(false);
			   			   mobileField.setReadOnly(false);
			   			   emailId.setReadOnly(false);
			   			
							 this.setMaximumMinimumDigitsForMobileNoValidation(sgForm,countryCodeField,mobileField,null);

			 				   }
			 				
				    		

				    		
				    		}else{
				    			 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
				    		}
				   	},
					
				   	getDeleteCandidateInfoWin: function(){
				        var this$ = this;
				        var grid = this$.getCandidatesinformationgrid();
				    	var grdStore = grid.getStore();
				    	if (grid.getSelectionModel().getCount() > 0) {
				    		showConfirmMessage(getCommonTranslation('CANDIDATE_LIST'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
				    			if (btn == 'yes') {
									var records = grid.getSelectionModel().getSelection();
									var id = records[0].data.id;
									Ext.Ajax.request({
										type: 'rest',
										method: 'DELETE',
										url: SERVERURL.PATH_ELECTION_CANDIDATE_INFO_DELETE  +'?id='+ id,
										headers: {
											'Content-Type': 'application/json'
										},
										params: {
											id: id
										},
										success: function(form, action) {
											
												showSuccessMessage(getCommonTranslation('CANDIDATE_LIST'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
												this$.resetPageSetting(grdStore);
												grdStore.reload();
											
										},
										failure: function(form, action) {
											showWarningMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
										}
									});
								}
				    		});
				    	} else {
				    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
				    	}
				    },
				    
				  LoadCandidateInfoGrid: function(grid,  parentRecId) {
					        grid.getSelectionModel().deselectAll();
					        var store = grid.getStore();
					        store.getProxy().extraParams = {
					        	electionListId: parentRecId
					        };
					       
					        store.reload();
					        //Rebind store to grid
					        grid.down('custompagingtoolbar').bindStore(store);
					    },
					    uploadImageCandidateInfo: function(candidateInfoId,form) {
							var this$ = this;
						//	var form = btn.up('form');
						//	candidateInfoId= eval( candidateInfoId.valueOf());
							var imagePath = form.down('#imageUploadField').getValue();
								
						  if(!isNullOrEmpty(imagePath)){
									form.getForm().submit({
							             type: 'rest',
							             url: SERVERURL.PATH_ELECTION_LIST_CANDIDATE_UPLOAD_IMAGE,
							             method: 'POST',
							             params:{
							            	 userName : candidateInfoId
							        	 },
							             success: function() {
								   				showSuccessMessage(getCommonTranslation('CANDIDATES_INFORMATION'),getCommonTranslation('RECORD_ADD_SUCCESS'));
 
							            	 
							             }
							         });
								}
							
						},
						
						getShowExternalUserForm:function(){
					   		var frmWin = this.getExternaluserdetailwin();
					   		if(!frmWin){
					   			Ext.widget('externaluserdetailwin');
					   			frmWin = this.getExternaluserdetailwin();
					   		}
					   		frmWin.show();
					   	},
					   	getSaveExertnalUserDetail : function(){
					   		var this$ = this;
					   		var grid = this$.getExternaluservoterpoolgrid();
					   		var gridStore = grid.getStore();
					   		var win = this$.getExternaluserdetailwin();
					   		var form = win.down('form');
					   		var values = form.getForm().getValues();

					   		var structure = this$.getElectonvoterpoolstructure();
					   		var electionId = structure.down("#electionId").getValue();
					   		var record = grid.getSelectionModel().getSelection()[0];
					   		var externalUserModel = new Academia.model.election.election.ElectionExternalUserGridDataModel();
					   		externalUserModel.set("id",values.id[0]);
					   		
					   		externalUserModel.set("name",values.name);
					   		externalUserModel.set("emailId",values.emailId);
					   		externalUserModel.set("phoneCountryCode",values.mobileCountryCode);
					   		externalUserModel.set("phoneNumber",values.mobileNo);
					   		externalUserModel.set("description",values.description);
					   		//externalUserModel.set("votingAction",record.data.votingAction);
					   		delete externalUserModel.data.personId;
					   		delete externalUserModel.data.votingAction;
					   		delete externalUserModel.data.weightage;
					   		delete externalUserModel.data.personId;
					   		delete externalUserModel.data.votingAction;
					   		var jason= new Object();
					   		jason.voterPoolExternalUser=externalUserModel.data;
                            jason.electionId=electionId;
                            
					   		var submitUrl = SERVERURL.PATH_ADD_EXTERNAL_USER_VOTER; 

					   		var id = externalUserModel.data.id;
					   		if(!isNullOrEmpty(externalUserModel.data.id)) {
					   		 jason.votingAction=record.data.votingAction;
					   			if(!isNullOrEmpty(record.data.weightage)){
						   			externalUserModel.data.weightage=record.data.weightage;
						   		}
					   			jason.id=record.data.electionVoterPoolId;
					   		 jason.votingAction=record.data.votingAction;

					   			submitUrl = SERVERURL.PATH_UPDATE_EXTERNAL_USER_VOTER;
					   		}
					   		var submitData = Ext.encode(jason);
					   		this$.applyWindowMask(); 

					   		Ext.Ajax.request({
					   			url: submitUrl,
					   			jsonData: submitData,
					   			method: 'POST',
					   			success: function(response) {
					   				this$.hideWindowMask();
					   				this$.getCloseExertnalUserWin();
					   				gridStore.reload();
					   				grid.getSelectionModel().deselectAll(true);
					   				if(!isNullOrEmpty(id)) {
					   					showSuccessMessage(getCommonTranslation('EXTERNAL_USER'),getCommonTranslation('RECORD_UPDATE_SUCCESS'));
					   				} else {
					   					showSuccessMessage(getCommonTranslation('EXTERNAL_USER'),getCommonTranslation('RECORD_ADD_SUCCESS'));
					   				}
					   			}
					   		});
					   	},
					   	getCloseExertnalUserWin : function(){
					   		this.getExternaluserdetailwin().close();
					   	},
					   	getEditExertnalUser : function(){
					   		var this$ = this;
					   		var grid = this$.getExternaluservoterpoolgrid();
					    	if (grid.getSelectionModel().getCount() > 0) {
					    		this$.getShowExternalUserForm();
					    		var win = this$.getExternaluserdetailwin();
					       		var form = win.down('form');
					    		var record = grid.getSelectionModel().getSelection()[0];
					    		var id = record.get("id");
					    		var name= win.down('#nameItemId');
					    		var emailId= win.down('#emailId');
					    		var cellCountryCode= win.down('#cellCountryCode');
					    		var mobileNo= win.down('#mobileNo');
					    		var description= win.down('#description');
					    		win.down('#id').setValue(record.data.id);
					    		name.setValue(record.data.name);
					    		emailId.setValue(record.data.emailId);
					    		cellCountryCode.setValue(record.data.phoneCountryCode);
					    		mobileNo.setValue(record.data.phoneNumber);
					    		description.setValue(record.data.description);
					    		

					    		/*cellCountryCode.getStore().load({
									callback:function(record) {
										cellCountryCode.setValue(record.data.cellcountrycode);
									}
								});*/
					    		
					    		}else{
					    			 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
					    		}
					   	},
						getViewExertnalUser : function(){
					   		this.getEditExertnalUser();
					 		var win = this.getExternaluserdetailwin();
					 		if (win) {
					 			var form = win.down('form');
					 			form.down('#SubmitBtnExternalUser').setVisible(false);
					 			form = form.getForm();
					 			toggleReadOnlyFormItems(form,true);
					 			win.doLayout()
					 		}
					   	},
					 	getDeleteExertnalUser: function(){
					        var this$ = this;
					        var grid = this$.getExternaluservoterpoolgrid();
					    	var grdStore = grid.getStore();
					    	if (grid.getSelectionModel().getCount() > 0) {
					    		showConfirmMessage(getCommonTranslation('EXTERNAL_USER'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
					    			if (btn == 'yes') {
										
										var id = [];
								   		var record = grid.getSelectionModel().getSelection();
								    	if( record.length > 0){
								    		for( var i = 0; i < record.length; i++) {
								    			id.push(record[i].data.electionVoterPoolId);
								    		}
								    	}
								    	var Ids = id.join(',');
										Ext.Ajax.request({
											type: 'rest',
											method: 'DELETE',
											url: SERVERURL.PATH_DELETE_EXTERNAL_USER  ,
											headers: {
												'Content-Type': 'application/json'
											},
											params: {
												ids: Ids
											},
											success: function(form, action) {
												
													showSuccessMessage(getCommonTranslation('EXTERNAL_USER'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
													this$.resetPageSetting(grdStore);
													grdStore.reload();
												
											},
											failure: function(form, action) {
												showWarningMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
											}
										});
									}
					    		});
					    	} else {
					    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					    	}
					    },
					    
					    getRenderVoterPoolEmployee : function(grid){
					   		var this$ = this;
					   		var structure = this$.getElectonvoterpoolstructure();
					        var vehicleList = this$.getElectionsgrid();
					        var record = vehicleList.getSelectionModel().getSelection()[0];
					        var electionNameCode=record.get("electionCode")+ "/"+ record.get("electionName");
					        structure.down("#electionName").setValue(electionNameCode);
					        var votingdate=dateRender(record.get("votingStartDate")) +" - "+ timeRender(record.get("votingStartTime"));
					        var votingEndDate=dateRender(record.get("votingEndDate")) +" - "+timeRender(record.get("votingEndTime"));
					        structure.down("#electionType").setValue(record.get("electionTypeCSM").value);
					        structure.down("#academicTerm").setValue(record.get("academicTerm").value);
					        structure.down("#votingStartDate").setValue(votingdate);
					        structure.down("#votingEndDate").setValue(votingEndDate);
					        structure.down("#electionId").setValue(record.get("id"));
					        
					        
					        var captureBollotVotesBtn = grid.down("#captureBollotVotesBtn");
					        if(structure.config.isAdminCaptureVote){
					        	captureBollotVotesBtn.setDisabled(false);
					        }else{
					        	captureBollotVotesBtn.setDisabled(true);
					        }
					        
					        
					        var store = grid.getStore();
					   	    store.getProxy().extraParams = {
					   	    	electionId : record.get("id")
					   		};
					   	    store.sorters.clear();
					   	    store.load();
					   	},
					   	getShowCopyElectionWin:function(){
					   		var frmWin = this.getCopyelectionwin();
					   		var grid = this.getElectionsgrid();
					   		if (grid.getSelectionModel().getCount() > 0) {
					   		if(!frmWin){
					   			Ext.widget('copyelectionwin');
					   			frmWin = this.getCopyelectionwin();
					   		}
					   		frmWin.show();
					   		}else{
					   			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
					   		}
					   	},
						getSaveCopyEletions: function(){
							var this$ = this;
					   		var grid = this$.getElectionsgrid();
					   		var gridStore = grid.getStore();
					   		var json= new Object;
					   		var win = this$.getCopyelectionwin();
					   		var form = win.down('form');
					   		var formValue = form.getForm().getValues();
					   		var record = grid.getSelectionModel().getSelection()[0];
					   		var electionTypeCSM={
					   				"id":	formValue.electionType
					   			};
					   			var academicTerm={
					   					"id":	formValue.academicTerm
					   				};
					   			var election={
						   				"id":	record.data.id
						   			};
					   			json = {
					   					//"electionCode":formValue.electionCode,
					   					"electionCode":formValue.electionCode,
					   					"electionTypeCSM":electionTypeCSM,
					   					"electionName":formValue.electionName,
					   					"electionNameInOtherLanguage":formValue.electionNameInOtherLang,
					   					"academicTerm":academicTerm,
					   					"electionDescriptionInEnglish":formValue.electionDescription,
					   					"electionDescriptionInOtherLang":formValue.electionDescriptionInOtherLang,
					   					"isActive":formValue.isActive,
					   					"id":record.data.id
					   			};
					   			var submitUrl = SERVERURL.PATH_COPY_ELECTION_SAVE; 
                                var submitData = Ext.encode(json);
					   		   this$.applyWindowMask(); 
                                Ext.Ajax.request({
					   			url: submitUrl,
					   			jsonData: submitData,
					   			method: 'POST',
					   			success: function(response) {
					   				this$.hideWindowMask();
					   				this$.getCloseCopyElectionWin();
					   				gridStore.reload();
					   				grid.getSelectionModel().deselectAll(true);
					   				 showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('RECORD_ADD_SUCCESS'));
					   				
					   			}
					   		});
					   		
					   		},
					   	getCloseCopyElectionWin : function(){
					   		this.getCopyelectionwin().close();
					   	},
					   	
					   	
						getCloseChangeWeightageWin : function(win){
					   	win.close();
					   	},
					   	
					   
					   		getShowChangeWeightageWinForStudent:function(){
						   		var grid = this.getStudentvoterpoolgrid();
						   		if (grid.getSelectionModel().getCount() > 0) {
						   			var record = grid.getSelectionModel().getSelection();
						   		var frmWin = this.getChangeweightagewin();
						   		if(!frmWin){
						   			frmWin =Ext.widget('changeweightagewin',{
	              		    			itemId:'studentchangeweightagewin'
	              		    		});
						   		}
						   		
						   		frmWin.show();
						   	
						   		var changeWeightageOne= frmWin.down("#changeWeightageOne")
						   		if(record.length==1){
						   			changeWeightageOne.setValue(record[0].data.weightage)
						   		}
						   	
						   		}else{
						   			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
						   		}
						   		},
						   		getShowChangeWeightageWinForStaff:function(){
							   		var grid = this.getEmployeevoterpoolgrid();
							   		if (grid.getSelectionModel().getCount() > 0) {
							   			var record = grid.getSelectionModel().getSelection();
							   		var frmWin = this.getChangeweightagewin();
							   		if(!frmWin){
							   			frmWin =Ext.widget('changeweightagewin',{
		              		    			itemId:'staffchangeweightagewin'
		              		    		});
							   		}
							   		frmWin.show();
							   		var changeWeightageOne= frmWin.down("#changeWeightageOne")
							   		if(record.length==1){
							   			changeWeightageOne.setValue(record[0].data.weightage)
							   		}
							   		}else{
							   			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
							   		}
							   		},
							   		getShowChangeWeightageWinForExternalUser:function(){
								   		var grid = this.getExternaluservoterpoolgrid();
								   		if (grid.getSelectionModel().getCount() > 0) {
								   			var record = grid.getSelectionModel().getSelection();
								   		var frmWin = this.getChangeweightagewin();
								   		if(!frmWin){
								   			frmWin =Ext.widget('changeweightagewin',{
			              		    			itemId:'externaluserchangeweightagewin'
			              		    		});
								   		}
								   		frmWin.show();
								   		var changeWeightageOne= frmWin.down("#changeWeightageOne")
								   		if(record.length==1){
								   			changeWeightageOne.setValue(record[0].data.weightage)
								   		}
								   		}else{
								   			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
								   		}
								   		},
						   		
					   		getSaveChangeWeightage: function(){
								var this$ = this;
						   		var grid = this$.getStudentvoterpoolgrid();
						   		var grdStore = grid.getStore();
						   	   var json= new Object;
						   		var win = this$.getChangeweightagewin();
						   		
						   		var form = win.down('form');
						   		var formValue = form.getForm().getValues();
						   		
						   		var jsonData = [];
						   		var record = grid.getSelectionModel().getSelection();
						    	if( record.length > 0){
						    		for( var i = 0; i < record.length; i++) {
						    			jsonData.push(record[i].data.electionVoterPoolId);
						    		}
						    	}
						   			
						   			
						    	var modifiedRecords = new Ext.util.HashMap();
						    	modifiedRecords.add(formValue.changeWeightageOne,jsonData)
						   		
						   			var submitUrl = SERVERURL.PATH_ELECTION_CHANG_EWEIGHTAGE; 
						    	 var submitData = Ext.encode(modifiedRecords.map);
						   		   this$.applyWindowMask(); 
	                                Ext.Ajax.request({
						   			url: submitUrl,
						   			jsonData: submitData,
						   			method: 'POST',
						   			success: function(response) {
						   				this$.hideWindowMask();
						   				this$.getCloseChangeWeightageWin(win);
						   				grid.getStore().reload();
						   				grid.getSelectionModel().deselectAll(true);
						   				 showSuccessMessage(getCommonTranslation('EXTERNAL_USER'),getCommonTranslation('RECORD_ADD_SUCCESS'));
						   				
						   			}
						   		});
						   		
						   		},
						   		getSaveChangeWeightageForStaff: function(win){
									var this$ = this;
							   		var grid = this$.getEmployeevoterpoolgrid();
							   		var grdStore = grid.getStore();
							   	   var json= new Object;
							   	//	var win = this$.getChangeweightagewin();
							   		
							   		var form = win.down('form');
							   		var formValue = form.getForm().getValues();
							   		
							   		var jsonData = [];
							   		var record = grid.selModel.getSelection();
							    	if( record.length > 0){
							    		for( var i = 0; i < record.length; i++) {
							    			jsonData.push(record[i].data.electionVoterPoolId);
							    		}
							    	}
							   			
							   			
							    	var modifiedRecords = new Ext.util.HashMap();
							    	modifiedRecords.add(formValue.changeWeightageOne,jsonData)
							   		
							   			var submitUrl = SERVERURL.PATH_ELECTION_CHANG_EWEIGHTAGE; 
							    	 var submitData = Ext.encode(modifiedRecords.map);
							   		   this$.applyWindowMask(); 
		                                Ext.Ajax.request({
							   			url: submitUrl,
							   			jsonData: submitData,
							   			method: 'POST',
							   			success: function(response) {
							   				this$.hideWindowMask();
							   				this$.getCloseChangeWeightageWin(win);
							   				grid.getStore().reload();
							   				grid.getSelectionModel().deselectAll(true);
							   				 showSuccessMessage(getCommonTranslation('EXTERNAL_USER'),getCommonTranslation('RECORD_ADD_SUCCESS'));
							   				
							   			}
							   		});
							   		
							   		},
							   		getSaveChangeWeightageForExternalUser: function(win){
										var this$ = this;
								   		var grid = this$.getExternaluservoterpoolgrid();
								   		var grdStore = grid.getStore();
								   	   var json= new Object;
								   		var form = win.down('form');
								   		var formValue = form.getForm().getValues();
								   		
								   		var jsonData = [];
								   		var record = grid.selModel.getSelection();
								    	if( record.length > 0){
								    		for( var i = 0; i < record.length; i++) {
								    			jsonData.push(record[i].data.electionVoterPoolId);
								    		}
								    	}
								   			
								    	var modifiedRecords = new Ext.util.HashMap();
								    	modifiedRecords.add(formValue.changeWeightageOne,jsonData)
								   			
								   			
								   			var submitUrl = SERVERURL.PATH_ELECTION_CHANG_EWEIGHTAGE; 
			                                var submitData = Ext.encode(modifiedRecords.map);
								   		   this$.applyWindowMask(); 
			                                Ext.Ajax.request({
								   			url: submitUrl,
								   			jsonData: submitData,
								   			method: 'POST',
								   			success: function(response) {
								   				this$.hideWindowMask();
								   				this$.getCloseChangeWeightageWin(win);
								   				grid.getStore().reload();
								   				grid.getSelectionModel().deselectAll(true);
								   				 showSuccessMessage(getCommonTranslation('EXTERNAL_USER'),getCommonTranslation('RECORD_ADD_SUCCESS'));
								   				
								   			}
								   		});
								   		
								   		},
								   		getDeleteStudentVoterPool: function(){
									        var this$ = this;
									        var grid = this$.getStudentvoterpoolgrid();
									    	var grdStore = grid.getStore();
									    	if (grid.getSelectionModel().getCount() > 0) {
									    		showConfirmMessage(getCommonTranslation('STAFF_USERS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
									    			if (btn == 'yes') {
														
														var id = [];
												   		var record = grid.getSelectionModel().getSelection();
												    	if( record.length > 0){
												    		for( var i = 0; i < record.length; i++) {
												    			id.push(record[i].data.electionVoterPoolId);
												    		}
												    	}
												    	var Ids = id.join(',');
														Ext.Ajax.request({
															type: 'rest',
															method: 'DELETE',
															url: SERVERURL.PATH_DELETE_EXTERNAL_USER  ,
															headers: {
																'Content-Type': 'application/json'
															},
															params: {
																ids: Ids
															},
															success: function(form, action) {
																
																	showSuccessMessage(getCommonTranslation('STAFF_USERS'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
																	this$.resetPageSetting(grdStore);
																	grdStore.reload();
																
															},
															failure: function(form, action) {
																showWarningMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
															}
														});
													}
									    		});
									    	} else {
									    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
									    	}
									    },
									    getDeleteStaffVoterPool: function(){
									        var this$ = this;
									        var grid = this$.getEmployeevoterpoolgrid();
									    	var grdStore = grid.getStore();
									    	if (grid.getSelectionModel().getCount() > 0) {
									    		showConfirmMessage(getCommonTranslation('STAFF_USERS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
									    			if (btn == 'yes') {
														
														var id = [];
												   		var record = grid.getSelectionModel().getSelection();
												    	if( record.length > 0){
												    		for( var i = 0; i < record.length; i++) {
												    			id.push(record[i].data.electionVoterPoolId);
												    		}
												    	}
												    	var Ids = id.join(',');
														Ext.Ajax.request({
															type: 'rest',
															method: 'DELETE',
															url: SERVERURL.PATH_DELETE_EXTERNAL_USER  ,
															headers: {
																'Content-Type': 'application/json'
															},
															params: {
																ids: Ids
															},
															success: function(form, action) {
																
																	showSuccessMessage(getCommonTranslation('STAFF_USERS'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
																	this$.resetPageSetting(grdStore);
																	grdStore.reload();
																
															},
															failure: function(form, action) {
																showWarningMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
															}
														});
													}
									    		});
									    	} else {
									    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
									    	}
									    },
									    exportPDFEletionPrint: function(){
									    	var $this = this;
									    	var exportType = $this.getPrintsheetwindow().down("#voterPoolItemId");
									       var reportParams = new Object();
									    	var admParams = [];
									
									    	
									    	
									    	var grid = this.getElectionsgrid();
									    	    var applicationsArray=[];
									    	    var record = grid.getSelectionModel().getSelection()[0];
									    	  var electionId = record.data.id;
									    	  var electionName = record.data.electionName;
									    	  reportParams.electionId=electionId;
									    	  reportParams.electionName=electionName;
									    	  reportParams.electionListId=  exportType.getValue();
									    	  reportParams.electionListName=  exportType.getDisplayValue();
									    	  
									    	    var reportName=exportType.getDisplayValue() +" report";
									    	//if(exportType.value == 'STEP3_EDUCATION_BACKGROUND'||exportType.value == 'Educational Background'){
									    	    reportHeader = "Election List Report";
									    	    reportTitle = "Election List Report";
									    	    code = 'ELECTION_LIST_REPORT';
									    	    reportParams.code = code;
									    	 
									    	    reportParams.headerName = reportHeader;
									    	    var gridData = grid.getStore().data.items;
									    	    if(gridData.length>0) {
									    	    	 $this.exportJRXMLReport(code, reportParams, reportTitle, '.pdf', SERVERURL.PATH_ELECTION_LIST_CANDIDATE_EXPORT_PDF);									    	    } else {
									    	    showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NO_DATA_DISPLAY_MSG'));
									    	}
									    	$this.getPrintsheetwindow().close();
									    },
									    showVoteInElectionTab:function(data){
									    	var this$ = this; 
											var grid = null;
									    	var electionId = null;
									    	if(portalId == 2 || portalId == 3){
									    		grid= this$.getSpelectionsgrid();
									    		var record = grid.getSelectionModel().getSelection()[0];
									    		electionId = record.data.id;
									    	}else{
									    		var structure = this$.getElectonvoterpoolstructure();
									    		var tabPanelStrc = structure.down('tabpanel');
									    		var studentVoterPollGrid = tabPanelStrc.getActiveTab().down('#studentvoterpoolgrid');
												var EmployeeVoterPoolGrid =  tabPanelStrc.getActiveTab().down('#employeevoterpoolgrid');
												var ExternaluserVoterPollGrid =  tabPanelStrc.getActiveTab().down('#externaluservoterpoolgrid');
												if(!isNullOrEmpty(studentVoterPollGrid)){
													grid = studentVoterPollGrid;
												}else if(!isNullOrEmpty(EmployeeVoterPoolGrid)){
													grid = EmployeeVoterPoolGrid;
												}else if(!isNullOrEmpty(ExternaluserVoterPollGrid)){
													grid = ExternaluserVoterPollGrid;
												}
									    		electionId = structure.down('#electionId').getValue();
									    		var record = grid.getSelectionModel().getSelection()[0];
									    	}
											
											 Ext.Ajax.request({
			                    				 method : "GET",
			                    				 type : 'rest',
			                    				 url: SERVERURL.PATH_FIND_BY_ELECTION_ID_ELECTION_LIST,
			                    				 params: {
			                    					 electionId :electionId 
			                    				 },
			                    				 headers : {
			                    					 'Content-Type' : 'application/json'
			                    				 },
			                    				 success: function(f, action) {
			                    					 var candidateListdata = Ext.decode(f.responseText);
			                    					 if(candidateListdata.length > 0){
			                    						 if(portalId == 3 || portalId == 2){
			                    							 this$.openCandidateListDataView(data,null); 
			                    						 }else{
			                    							 if(grid.xtype == 'externaluservoterpoolgrid'){
			                    								 this$.openCandidateListDataView(data,record.data.id);
			                    							 }else{
			                    								 this$.openCandidateListDataView(data,record.data.personId);
			                    							 }
			                    							 
			                    						 }
			                    						
			                    					 }else{
			                    						 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('NO_CANDIDATE_LIST'));
			                    					 }
			                    				 }
			                    			 });
										},
										onCandidateListClick: function(candidateListId,candidateListName){
											var me = this;
				                    		var albumStructure = me.getStudentvoteinelectionalbumstructure();
				                    		var candidateListStructure = me.getStudentvoteinelectionliststructure();
				                    		candidateListStructure.config.candidateListName = candidateListName;
				                    		candidateListStructure.config.maximumVoteInList = 0;
				                    		albumStructure.down('#candidateListId').setValue(candidateListId);
				                    		albumStructure.down('#candidateListValue').setValue(candidateListName);
				                    		
				                    		albumStructure.down('#albumCandidateImagesPanel').removeAll();
				                    		albumStructure.down('#albumCandidateImagesPanel').body.setHTML('');
				                    		albumStructure.down('#albumCandidateImagesPanel').body.addCls('text-middle-center');
											var prvBtn = albumStructure.down('#btnPreviousElec');
											var nextBtn = albumStructure.down('#btnNextElec');
											nextBtn.setDisabled(false);
											prvBtn.setDisabled(false);
											
											var electionAlbumStore = Ext.create('Academia.store.election.election.SPElectionAlbumStore');
											var personId =null;
											if(typeof candidateListId == 'number'){
												candidateListId=Ext.encode(candidateListId)
											}
											if(portalId == 3 || portalId == 2){
												var person = this.getCurrentlyLoggedInUserWithPersonId();
					                    		 personId = person.personId;
					                    		 electionAlbumStore.getProxy().extraParams = {
														electionCandidateListId  : candidateListId,
														personId : personId
													};
											}else{
												var structure = me.getElectonvoterpoolstructure();
												var tabPanelStrc = structure.down('tabpanel');
												var ExternaluserVoterPollGrid =  tabPanelStrc.getActiveTab().down('#externaluservoterpoolgrid');
												 personId = me.getStudentvoteinelectionstructure().down('#electionStudentItemId').getValue();
												 if(!isNullOrEmpty(ExternaluserVoterPollGrid)){
													 electionAlbumStore.getProxy().extraParams = {
															electionCandidateListId  : candidateListId,
															externalUserId : personId
														};
												 }else{
													 electionAlbumStore.getProxy().extraParams = {
															electionCandidateListId  : candidateListId,
															personId : personId
														}; 
												 }
												
											}
											electionAlbumStore.removeAll();
											electionAlbumStore.load({
												callback: function(records, operation, success){
													if(!isNullOrEmpty(records)){
														if(records.length>0){
															albumStructure.down('#albumCandidateImagesPanel').removeAll();
								                    		albumStructure.down('#albumCandidateImagesPanel').body.setHTML('');
								                    		albumStructure.down('#albumCandidateImagesPanel').body.addCls('text-middle-center');
														}
													}	
													
													var imageTpl = new Ext.XTemplate(
															
															'<tpl for=".">',
													        '<div  class="albulm-thumb-wrap image-border">',
													          '<img src="{imageUrl}" />',
													          '<br/><span style="color: black;margin-top: 11px;padding: 0 10px !important;" data-qtip="{candidateName}"><a href="javascript:void(0)" onclick="candidateDetail({electionCandidateId});">{candidateName}</a></span>',
													          '<tpl if="programOrDepartmentName != null">',
													          '<br/><span style="height: 36px;color: green;margin-top: -12px;font-size: 11px !important;padding: 0 10px !important;line-height: 12px;width: 196px;white-space: normal;" data-qtip="{programOrDepartmentName}">({programOrDepartmentName})</span>',
													          '</tpl>',
													          '<tpl if="programOrDepartmentName == null">',
														         
													          '<span><button style="width: 200px;border: 0px;float: left;margin-top: 40px;height: 30px;"><input type="checkbox" {[this.getChecked(values)]} value="{electionCandidateId}" name="imageId" onclick="changeState({electionCandidateId},this);"/> Vote</button></span>',
													          '<tpl else>',
													          '<span style="color:#e8e8e8"><button style="width:200px;border:0px;float:left;margin-top:3px;height:29px"><input type="checkbox" {[this.getChecked(values)]} value="{electionCandidateId}" name="imageId" onclick="changeState({electionCandidateId},this);"/> Vote</button></span>',
													          '</tpl>','</div>',
													        '</tpl>' , 
													        { 
																getChecked: function(values) { 
																   var tempStore = Ext.getStore('electionTempStore');	
																   var rec = tempStore.findRecord('electionCandidateId',values.electionCandidateId);
																   if(!isNullOrEmpty(rec)){
																	   return 'checked="checked"';
																   }else{
																	   return '';
																   }
																}
													        }
													);
													Ext.each(Ext.ComponentQuery.query('#galleryDataViewElection'), function(currentGalleryDataView){
														currentGalleryDataView.destroy();
													});
													Ext.create('Ext.view.View', {
													    store: electionAlbumStore,
													    tpl: imageTpl,
													    itemSelector: 'div.gallery-thumb-wrap',
													    emptyText: getCommonTranslation('NO_FILES_ADDED_YET_MSG'),
													    renderTo:  albumStructure.down('#albumCandidateImagesPanel').body,
														itemId: 'galleryDataViewElection',
														height: '90%',
														autoScroll:false,
														deferEmptyText: false,
														style: {
												            marginTop: '-18px'
												        }
												       /* handler: function(view){
												        	  view.fireEvent('itemClick',function(){
												        		 debugger 
												        	  });
												        	  
												               itemclick: function(view, record, item, index, e, eOpts) {
												                   var target = e.target;
												                   if (target.tagName == 'INPUT') {
												                      alert('clicked');
												                   }
												                   else {
												                       alert('something else clicked');
												                   }
												               }
												           }
*/
													});
													
													var data = Ext.decode(operation.response.responseText);
													albumStructure.config.electionVoterPoolId = data.electionVoterPoolId;
													//candidateListStructure.config.maximumVoteInList = data.maximumVoteInList;
													albumStructure.config.weightage=data.weightage;
													var electionName = albumStructure.down('#electionName');
													var candidateList = albumStructure.down('#candidateList');
													var referendumelec1 = albumStructure.down('#referendumdetail1');
													var referendumradio1 = albumStructure.down('#referendumelec1');
													var referendumelec2 = albumStructure.down('#referendumdetail2');
													var referendumradio2 = albumStructure.down('#referendumelec2');
													var maximumVoteInList = albumStructure.down('#maximumVoteInList');
													
													if(!isEmpty(records)){
														
														electionName.setValue(data.electionName);
														electionName.setVisible(true);
														candidateList.setValue(candidateListName);
														candidateList.setVisible(true);
														maximumVoteInList.setVisible(true);
														maximumVoteInList.setValue(getCommonTranslation('YOU_MAY_VOTE_FOR_MAXIMUM')+" "+data.maximumVoteInWord+" "+" ("+data.maximumVoteInList+") "+getCommonTranslation('CANDIDATES'));
														
														if(!isNullOrEmpty(data.referendumOneQuestionInEnglish)){
															referendumelec1.setVisible(true);
															referendumradio1.setVisible(true);
															referendumelec1.setValue(data.referendumOneQuestionInEnglish);
														}
														if(!isNullOrEmpty(data.referendumTwoQuestionInEnglish)){
															referendumelec2.setVisible(true);
															referendumradio2.setVisible(true);
															referendumelec2.setValue(data.referendumTwoQuestionInEnglish);
														}
													}
												}
											});
											
										},
										submittElectionVote : function(){
											var this$ = this;
											var json= new Object;
											//var grid = this.getSpelectionsgrid();
											//var record = grid.getSelectionModel().getSelection()[0];
											var form = this$.getStudentvoteinelectionalbumstructure();
											 var albumStructure = this.getStudentvoteinelectionalbumstructure();
											var tempStore = Ext.getStore('electionTempStore');
											var formValue = form.getForm().getValues();
											var electionVoterPoolCandidates = [];
											var jsonData = [];
											var voteCaptureBy =null;
											if(portalId == 3 || portalId == 2){
												 voteCaptureBy = "SELF";
											}else{
												var structure = this$.getElectonvoterpoolstructure();
									    		var tabPanelStrc = structure.down('tabpanel');
												var ExternaluserVoterPollGrid =  tabPanelStrc.getActiveTab().down('#externaluservoterpoolgrid');
												voteCaptureBy = "BALLOT";
											}
											
											/*var electionCandidate = $("[name=imageId]:checked").map(function(){
												return $(this).val();
											}).get();*/
											
											//var electionCandidate =tempStore.data.items[0].data.electionCandidateId;
											
											var weightage = (form.config.weightage)/100;
											/*var electionCandidateObj={
													"id":	electionCandidate
											};*/
											for( var i = 0; i < tempStore.getCount(); i++) {
												electionVoterPoolCandidates = {

														"electionCandidate":this$.getIdValueJson(tempStore.data.items[i].data.electionCandidateId),
														"electionVoterPool":this$.getIdValueJson(form.config.electionVoterPoolId),
														"effectiveVote":weightage

												};
												jsonData.push(electionVoterPoolCandidates);
											}
											var jsonnew1 = { };

											jsonnew1.voteCaptureBy= voteCaptureBy;
											jsonnew1.isReferendumOne= formValue.referendumelec1;
											jsonnew1.isReferendumTwo= formValue.referendumelec2;
											jsonnew1.electionVoterPoolCandidates = jsonData;
											showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('SUBMIT_VOTE_FOR_SELECTED_CADIDATE'),function(btn,text){
									         if (btn == 'yes') {
									          if(albumStructure.config.electionStatus == "FINISHED"){
									        	  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ELECTION_HAS_FINISHED'));
									          }else{
									        	  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
													
													var submitUrl = SERVERURL.PATH_ADD_VOTE; 
													var submitData = Ext.encode(jsonnew1);
													// this$.applyWindowMask(); 
													Ext.Ajax.request({
														url: submitUrl,
														jsonData: submitData,
														method: 'POST',
														success: function(response) {
															//this$.hideWindowMask();
															Ext.getBody().unmask();
															var tabName = getCommonTranslation('VOTE_IN_ELECTIONS_TAB');
															var getcontroller= this$.getController('menu.CoreERPNavigationController');
															var contentPanel = this$.getContentPanel();
															var getTab=getcontroller.getTab(tabName);
															if(getTab!=null){
																contentPanel.remove(getTab, true);
															}
															var grid = null;
															if(portalId == 3 || portalId == 2){
																 grid= this$.getSpelectionsgrid();
															}else{
																var structure = this$.getElectonvoterpoolstructure();
													    		var tabPanelStrc = structure.down('tabpanel');
													    		var studentVoterPollGrid = tabPanelStrc.getActiveTab().down('#studentvoterpoolgrid');
																var EmployeeVoterPoolGrid =  tabPanelStrc.getActiveTab().down('#employeevoterpoolgrid');
																var ExternaluserVoterPollGrid =  tabPanelStrc.getActiveTab().down('#externaluservoterpoolgrid');
																if(!isNullOrEmpty(studentVoterPollGrid)){
																	grid = studentVoterPollGrid;
																}else if(!isNullOrEmpty(EmployeeVoterPoolGrid)){
																	grid = EmployeeVoterPoolGrid;
																}else if(!isNullOrEmpty(ExternaluserVoterPollGrid)){
																	grid = ExternaluserVoterPollGrid;
																}
															}
															var grdStore = grid.getStore();
															grid.getSelectionModel().deselectAll();
															grdStore.load();
															showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('VOTE_SUBMIT_SUCCESS'));

														}
													 });
													
													
													var tempStore = Ext.getStore('electionTempStore');
									 				var dataView = Ext.ComponentQuery.query('#galleryDataViewElection')[0];
									 				tempStore.removeAll();
									 				dataView.getStore().load();
									          }
											
									        }
											});
										},
										nextButtonOnAlbumPanel:function(){
											var albumStructure = this.getStudentvoteinelectionalbumstructure();
											var prvBtn = albumStructure.down('#btnPreviousElec');
										    prvBtn.setDisabled(false);
											var structure = this.getStudentvoteinelectionliststructure();
										    var listPanel = structure.down('#listPanel');
                                            var nextBtn = albumStructure.down('#btnNextElec');
				                    		var candidateListId = albumStructure.down('#candidateListId').getValue();
				                    		var currentBtn = Ext.ComponentQuery.query('#'+'candidate_'+candidateListId)[0];
				                    	
				                    		if(!isNullOrEmpty(currentBtn)){
				                    			if(!isNullOrEmpty(currentBtn.nextSibling())){
					                    			var nextCandidateBtn = currentBtn.nextSibling().itemId;
						                    		var candidateListIdInc= nextCandidateBtn.substring(10);
						                    		
						                    	    var candidateListName = currentBtn.nextSibling().text;
						                    	    nextBtn.setDisabled(false);
						                    	    this.onCandidateListClick(candidateListIdInc,candidateListName);
						                    	    this.onChangeClickedBtnCss(currentBtn.nextSibling());
						                    		
					                    		}else{
					                    			nextBtn.setDisabled(true);
					                    		}
				                    		}
				                    		
										},
										previousButtonOnAlbumPanel:function(){
										    var albumStructure = this.getStudentvoteinelectionalbumstructure();
											var nextBtn = albumStructure.down('#btnNextElec');
											nextBtn.setDisabled(false);
											var structure = this.getStudentvoteinelectionliststructure();
										    var listPanel = structure.down('#listPanel');
                                            var prvBtn = albumStructure.down('#btnPreviousElec');
				                    		var candidateListId = albumStructure.down('#candidateListId').getValue();
				                    		var currentBtn = Ext.ComponentQuery.query('#'+'candidate_'+candidateListId)[0];
				                    		
				                    		if(!isNullOrEmpty(currentBtn)){
				                    			if(!isNullOrEmpty(currentBtn.previousSibling()) &&  currentBtn.previousSibling().cls != 'headingBtnCls'){
					                    			var nextCandidateBtn = currentBtn.previousSibling().itemId;
						                    		var candidateListIdInc= nextCandidateBtn.substring(10);
						                    		var candidateListName = currentBtn.previousSibling().text;
						                    		prvBtn.setDisabled(false);
						                    		this.onCandidateListClick(candidateListIdInc,candidateListName);
						                    		this.onChangeClickedBtnCss(currentBtn.previousSibling());
						                    		
					                    		}else{
					                    			prvBtn.setDisabled(true);
					                    		}
				                    		}
										},
										
										loadImportHostelBedGrid : function(votingPoolType){
											var $this = this;
											var grid = this.getImportvoterpoolloadergrid();
											var form  = $this.getUploadoptionradiogroup();
											var isUploadAll = form.items.items[0].getValue().isUploadAll;
											if(votingPoolType == "STAFF_STUDENTS") {
												$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_VOTER_POOL_STUDENT_USER');
											} else {
												$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_VOTER_POOL_EXTERNAL_USER');
											}
										}, 
										openEmployeeSendMessage:function(obj){

											var grid = this.getEmployeevoterpoolgrid();
											if(grid.getSelectionModel().getCount()>0) {
												var electionVoterPoolUrl;
												var  record = grid.getSelectionModel().getSelection()
												var $this=this;
												var contentPanel = this.getContentpanel(); //get hold of the content panel where we are adding all the tabs
												var structure = Ext.widget('electionvoterpoolsendmessages',{
													itemId:'voterPoolForStaff'
												});
												var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
												/**
												 * This is to remove tab from content panel and open same tab again
												 */
												var getcontroller=this.getController('menu.CoreERPNavigationController');
												var getTab=getcontroller.getTab(tabName);
												if(getTab!=null){
													contentPanel.remove(getTab, true);
												}
												var formWindowTab = $this.getElectionvoterpoolsendmessages();
												formWindowTab.down("#empSelectTemplate").allowBlank=true;
												formWindowTab.down("#empSelectTemplate").setVisible(false);
												formWindowTab.down("#empMessageName").allowBlank=true;   
												formWindowTab.down("#empMessageName").setVisible(false);
												
												var templateStore = formWindowTab.down('#empSelectTemplate').getStore();
												templateStore.getProxy().extraParams={
													msgRecipientTypeId:2
												};
												templateStore.load();

												Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
												Ext.Ajax.request({
													method : "GET",
													type : 'rest',
													url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=Election539740-692d-4ae1-bc17-338c4002874d',	//Committeebe539740-692d-4ae1-bc17-338c4002874d',
													headers : {
														'Content-Type' : 'application/json'
													},
													success : function(form,action) {
														var data = Ext.JSON.decode(form.responseText);
														formWindowTab.down("#id").setValue(data.id);
														formWindowTab.down("#code").setValue(data.code);
														formWindowTab.down("#empTemplateConfigName").setValue(data.templateConfigName);
														formWindowTab.down("#empMsgSubCategoryId").setValue(data.msgSubCategoryId);
														formWindowTab.down("#empMsgCategoryId").setValue(data.msgCategoryId);
														Ext.getBody().unmask();

														//grid.getStore().reload();
														//showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
													}

												});
												openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_THREE);
												/*if (!formWindow) {
											    				Ext.widget('jobapplicationemployeesendmessages');
											    				formWindow = $ this.getElectionvoterpoolsendmessages();
											    			}
											    			formWindow.show(;*/

											} else {
												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
											}
										},
										selectMessageTemp: function(obj,rec){
											var $this =  this;
											var formWin = $this.getElectionvoterpoolsendmessages();
											var empSubject = formWin.down('#empSubject');
											var smsDiscription = formWin.down('#empSmsDiscription');
											var smsDiscriptionNotice = formWin.down('#empSmsDiscriptionNotice');
											var pushNotificationDiscription = formWin.down('#empPushNotificationDiscription');
											var pushNotificationDiscriptionNotice = formWin.down('#empPushNotificationDiscriptionNotice');
											if(rec[0].data.value == "SMS")
											{  
												this.setAllowBlank (formWin.down("#empSubject"),true);
												//formWin.down("#empSubject").allowBlank=true;
												formWin.down("#empSubject").hide();
												formWin.down("#empStaticUploadFileField").hide();
												formWin.down("#voterPoolStaffDocumentMessageAttachmentGrid").hide();
												formWin.down('#empDiscriptionId').reset();
												formWin.down('#empDiscriptionId').hide();	       		 
												formWin.down('#empSubject').reset();
												formWin.down('#empSmsDiscription').show();
												formWin.down('#empSmsDiscriptionNotice').show();
												pushNotificationDiscription.hide();
												pushNotificationDiscriptionNotice.hide();
												pushNotificationDiscription.reset();
											}/*else if(rec[0].data.Dvalue == "PUSH_NOTIFICATION" || rec[0].data.value == "Push Notification"){
												      		 empSubject.show();
												      		 formWin.down("#empStaticUploadFileField").hide();
												      		 this.setAllowBlank(empSubject,false);
												      		 formWin.down("#voterPoolStaffDocumentMessageAttachmentGrid").hide();
												      		 formWin.down('#empDiscriptionId').reset();
												      		 formWin.down('#empDiscriptionId').hide();
												      		 empSubject.reset();
												      		 smsDiscription.reset();
												      		 smsDiscription.hide();
												      		 empSmsDiscriptionNotice.hide();
												      		 pushNotificationDiscription.reset();
												      		 pushNotificationDiscription.show();
												      		 pushNotificationDiscriptionNotice.show();
												      		 pushNotificationDiscriptionNotice.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+' 1000/1000</span>');
												      		 //formWin.down('#smsDiscription')
												      	 }*/else{
												      		 formWin.down('#empDiscriptionId').reset();
												      		 formWin.down('#empSmsDiscription').reset();
												      		 formWin.down('#empSmsDiscription').hide();
												      		 formWin.down('#empSmsDiscriptionNotice').hide();
												      		 formWin.down("#empStaticUploadFileField").show();
												      		 // formWin.down("#staticDocumentMessageAttachmentGrid").show();
												      		 formWin.down("#voterPoolStaffDocumentMessageAttachmentGrid").show();
												      		 formWin.down("#empSubject").reset();
												      		 formWin.down("#empSubject").show();
												      		 this.setAllowBlank (formWin.down("#empSubject"),false);
												      		 //formWin.down("#empSubject").allowBlank=false;
												      		 formWin.down('#empDiscriptionId').show();
												      		pushNotificationDiscription.hide();
												      		pushNotificationDiscriptionNotice.hide();
												      		pushNotificationDiscription.reset();
												      	 }
										},
										selectSectionMessageType : function(val,nV,oV){

											var $this =  this;
											var formWin = $this.getElectionvoterpoolsendmessages();

											//var value = nV.1;
											formWin.down('#empRecieverTypeIncludeMySelf').setValue(false);
											if(nV.messageType==2){
												formWin.down("#empMessageId").hide();
												formWin.down("#empSelectTemplate").allowBlank=true;
												formWin.down("#empSelectTemplate").setVisible(false);     		 
												formWin.down("#empMessageName").allowBlank=true;   
												formWin.down("#empMessageName").setVisible(false);
												formWin.down("#empMsgTempletId").setVisible(true);
												formWin.down("#empMsgTempletId").allowBlank=false;
												formWin.down("#empMsgTempletId").reset();
												formWin.down("#empSubject").setVisible(true);
												//formWin.down("#empSubject").allowBlank=false;
												formWin.down("#empSubject").reset();
												formWin.down("#empDiscriptionId").setVisible(true);
												formWin.down("#empDiscriptionId").reset();
												formWin.down('#empSmsDiscription').reset();
												formWin.down('#empSmsDiscription').hide();
												formWin.down('#empSmsDiscriptionNotice').hide();
												formWin.down('#empPushNotificationDiscription').hide();
												formWin.down('#empPushNotificationDiscriptionNotice').hide();
												formWin.down('#empRecieverTypeIncludeMySelf').setVisible(true);
												this.setAllowBlank (formWin.down("#empSubject"),false);
											}else{
												formWin.down("#empMsgTempletId").allowBlank=true;
												formWin.down("#empMsgTempletId").setVisible(false);     		
												formWin.down("#empMessageId").setVisible(true);
												formWin.down("#empSelectTemplate").setVisible(true);     		
												formWin.down("#empMessageName").setVisible(true);
												formWin.down("#empMessageName").reset();
												//formWin.down("#empSubject").allowBlank=true;
												this.setAllowBlank (formWin.down("#empSubject"),true);
												formWin.down("#empSubject").setVisible(false);
												formWin.down("#empDiscriptionId").setVisible(false);
												formWin.down("#empMessageName").allowBlank=false;  
												formWin.down("#empSelectTemplate").allowBlank=false;
												formWin.down("#empSelectTemplate").reset();
												formWin.down("#voterPoolStaffDocumentMessageAttachmentGrid").setVisible(false);
												formWin.down("#empStaticUploadFileField").setVisible(false);
												formWin.down('#empSmsDiscription').reset();
												formWin.down('#empSmsDiscription').hide();
												formWin.down('#empSmsDiscriptionNotice').hide();
												formWin.down('#empPushNotificationDiscription').hide();
												formWin.down('#empPushNotificationDiscriptionNotice').hide();
												formWin.down('#empRecieverTypeIncludeMySelf').setVisible(false);
												this.setAllowBlank (formWin.down("#empMessageName"),false);
												this.setAllowBlank (formWin.down("#empSelectTemplate"),false);
												// var allowblankFalse = '<span class="required" style="color:red"> *</span>';
												// formWin.down("#empMessageName").setFieldLabel(getMessagingModuleTranslation('MESSAGE_NAME')+allowblankFalse);
												//formWin.down("#empSelectTemplate").setFieldLabel(getMessagingModuleTranslation('SELECT_TEMPLATE')+allowblankFalse);
											}
										},   uploadEmployeeStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts){
									    	   var this$ = this;
									    	   var setupForm = fileField.up('electionvoterpoolsendmessages');
									    	   var grid = setupForm.down('#voterPoolEmployeeStaticDocumentAttachmentGridMessage');
									    	   fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
									    	   fileField.setRawValue(fileUploadPath);
									    	   var file = fileField.fileInputEl.dom.files[0];
									    	   fileField.setRawValue(fileUploadPath);
									    	   if((file.size / 1048576) <= CONSTANTS.EMAIL_UPLOAD_FILE_SIZE_LIMIT  ){
									    		   if(!isNullOrEmpty(fileUploadPath)){
									    			   var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
									    			   if (extension == "gif" || extension == "png" || extension == "bmp"
									    				   || extension == "jpeg" || extension == "jpg" || extension == "pdf" 
									    					   || extension == "doc" || extension == "docx" || extension == "txt"
									    						   || extension == "xls" || extension == "csv" || extension == "xml" 
									    							   || extension == "zip" || extension == "xlsx" || extension == "ppt" || extension == "pptx") {
									    				   var entityId = 'student';
									    				   var module = 'messaging';
									    				   var entityType = 'template';
									    				   var documentType = 'DOCUMENT';
									    				   var isTransient = true;
									    				   var this$ = this;
									    				   Ext.getBody().mask(getCommonTranslation('LOADING'), 'x-mask-loading');
									    				   this$.saveStaticDocumentFormMessage(entityId, module, entityType, documentType, function(success, action, isTransient){
									    					   if(success){
									    						   Ext.getBody().unmask();
									    						   var path = Ext.JSON.decode(action.response.responseText).path;
									    						   var user = this$.getCurrentlyLoggedInUser();
									    						   var store = grid.getStore();
									    						   var documentStatus = "SUBMITTED";
									    						   var documentType = null;
									    						   if(!isNullOrEmpty(path)){
									    							   store.add({
									    								   id: '',
									    								   name: fileUploadPath,
									    								   path: path ,
									    								   createdBy : {
									    									   id :user.id,
									    									   value : user.value,
									    									   code : user.code
									    								   },
									    								   status : documentStatus,
									    								   documentType : documentType,
									    								   templateConfigDocId: '',
									    								   submissionDate: Ext.Date.format(new Date(), 'd-m-Y')

									    							   });
									    							   this$.loadGridWithFileNameMessage(grid,fileUploadPath,store);
									    							   showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
									    						   }
									    						   var form=this$.getElectionvoterpoolsendmessages();
									           	            	   var empSubject = form.down('#empSubject').getValue();
									           	            	   if(!isNullOrEmpty(empSubject)){
									           	            		   if(empSubject == ' '){
									           	            			form.down('#empSubject').reset();
									           	            		   }
									           	            	   }
									    						   fileField.reset();
									    					   }

									    				   }, isTransient);
									    			   }else{
									    				   fileField.reset();
									    				   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
									    			   }
									    		   }
									    	   }else{
									    		   fileField.reset();
									    		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
									    	   }
									       }, 
									       saveStaticDocumentFormMessage : function(entityId, module, entityType, documentType, callBackFunction, isTransient){
										       	var submitUrl = '';
										       	var templateTab = this.getContentpanel();
										       	var formWin =  this.getElectionvoterpoolsendmessages();
										       	var form = formWin.down('#empMsgDetailsForm');
										       	var id = form.down('#emp_document_hidden_field');
										           if (isNullOrEmpty(id.getSubmitValue())) {
										               submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
										           }
										           var data = new Object();
										           if(!isNullOrEmpty(entityId)){
										           	data.entityId = entityId;
										           }else{
										           	data.entityId = null;
										           }
										           if(!isNullOrEmpty(module)){
										           	data.module = module;
										           }else{
										           	data.module = null;
										           }
										           if(!isNullOrEmpty(entityType)){
										           	data.entityType = entityType;
										           }else{
										           	data.entityType = null;
										           }
										           form.getForm().setValues(data);
										           form.getForm().submit({
										           	method : 'POST',
										           	url : submitUrl,
										           	success : function(form, action){
										           		callBackFunction(true, action, isTransient);
										           		
										           	}
										           });
										       },
										       deleteVoterPoolStaffStaticMessageDocument : function(view, rowIndex, colIndex, item, e, record, row){
										    	   var grid = view.up('#voterPoolEmployeeStaticDocumentAttachmentGridMessage');
										    	   var panel = this.getContentpanel().getActiveTab();
										    	   var tabTitle = panel.title;
										    	   var store = grid.getStore();
										    	   var templateConfigDocId = record.get('templateConfigDocId');
										    	   var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
										    	   if(!(tabTitle == viewTitle)){
										    		   if(!isNullOrEmpty(templateConfigDocId)){
										    			   showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
										    				   if (btn == 'yes') {
										    					   Ext.Ajax.request({
										    						   type: 'rest',
										    						   url: SERVERURL.STATIC_DOC_DELETE,
										    						   method: 'DELETE',
										    						   params: {
										    							   templateConfigDocId : templateConfigDocId
										    						   },
										    						   headers: {
										    							   'Content-Type': 'application/json'
										    						   },
										    						   success: function(form, action) {
										    							   store.remove(record);
										    							   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
										    						   }
										    					   });
										    				   }
										    			   });

										    		   }else{
										    			   store.remove(record);
										    			   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
										    		   }
										    	   }else{
										    		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
										    	   }

										       },
										       loadStudentScheduleField : function(radio,newValue, oldValue){
													var adhocMessageForm = radio.up('form');
													var scheduleDateField = adhocMessageForm.down('#empScheduleDate');
													var scheduleTimeField = adhocMessageForm.down('#empScheduleTime');
													var radioValue = radio.getValue().empSendingPriority;

													if(radioValue=='IMMEDIATE'){
														scheduleDateField.setVisible(false);
														scheduleDateField.setDisabled(true);
														scheduleTimeField.setVisible(false);
														scheduleTimeField.setDisabled(true);    		
													}
													else if(radioValue=='SCHEDULE'){
														scheduleDateField.setVisible(true);
														scheduleDateField.setDisabled(false);
														scheduleTimeField.setVisible(true);
														scheduleTimeField.setDisabled(false);
													}
												}, 
												loadGridWithFileNameMessage:function(grid,value,store){
											    	   grid.bindStore(store);
											       },
											       /********for Student send mesge**/
											       openVoterPoolStudentSendMessage:function(obj){

														var grid = this.getStudentvoterpoolgrid();
														if(grid.getSelectionModel().getCount()>0) {
															
															var $this=this;
															var contentPanel = this.getContentpanel(); //get hold of the content panel where we are adding all the tabs
															var structure = Ext.widget('electionvoterpoolforstudentsendmessages',{
																itemId:'voterPoolForStudent'
															});
															var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
															/**
															 * This is to remove tab from content panel and open same tab again
															 */
															var getcontroller=this.getController('menu.CoreERPNavigationController');
															var getTab=getcontroller.getTab(tabName);
															if(getTab!=null){
																contentPanel.remove(getTab, true);
															}
															var formWindowTab = $this.getElectionvoterpoolforstudentsendmessages();
															formWindowTab.down("#empSelectTemplate").allowBlank=true;
															formWindowTab.down("#empSelectTemplate").setVisible(false);
															formWindowTab.down("#empMessageName").allowBlank=true;   
															formWindowTab.down("#empMessageName").setVisible(false);
														 var templateStore = formWindowTab.down('#empSelectTemplate').getStore();
															templateStore.getProxy().extraParams={
																msgRecipientTypeId:2
															};
															templateStore.load();

															Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
															Ext.Ajax.request({
																method : "GET",
																type : 'rest',
																url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=Election539740-692d-4ae1-bc17-338c4002874d',	//Committeebe539740-692d-4ae1-bc17-338c4002874d',
																headers : {
																	'Content-Type' : 'application/json'
																},
																success : function(form,action) {
																	var data = Ext.JSON.decode(form.responseText);
																	formWindowTab.down("#id").setValue(data.id);
																	formWindowTab.down("#code").setValue(data.code);
																	formWindowTab.down("#empTemplateConfigName").setValue(data.templateConfigName);
																	formWindowTab.down("#empMsgSubCategoryId").setValue(data.msgSubCategoryId);
																	formWindowTab.down("#empMsgCategoryId").setValue(data.msgCategoryId);
																	Ext.getBody().unmask();

																	//grid.getStore().reload();
																	//showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
																}

															});
															openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_THREE);
															/*if (!formWindow) {
														    				Ext.widget('jobapplicationemployeesendmessages');
														    				formWindow = $ this.getElectionvoterpoolsendmessages();
														    			}
														    			formWindow.show(;*/

														} else {
															showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
														}
													},
													selectMessageTempForVoterPoolStudent: function(obj,rec){
														var $this =  this;
														var formWin = $this.getElectionvoterpoolforstudentsendmessages();
														var empSubject = formWin.down('#empSubject');
														var smsDiscription = formWin.down('#empSmsDiscription');
														var smsDiscriptionNotice = formWin.down('#empSmsDiscriptionNotice');
														var pushNotificationDiscription = formWin.down('#empPushNotificationDiscription');
														var pushNotificationDiscriptionNotice = formWin.down('#empPushNotificationDiscriptionNotice');
														if(rec[0].data.value == "SMS")
														{  
															this.setAllowBlank (formWin.down("#empSubject"),true);
															//formWin.down("#empSubject").allowBlank=true;
															formWin.down("#empSubject").hide();
															formWin.down("#empStaticUploadFileField").hide();
															formWin.down("#VoterPoolStudentDocumentMessageAttachmentGrid").hide();
															formWin.down('#empDiscriptionId').reset();
															formWin.down('#empDiscriptionId').hide();	       		 
															formWin.down('#empSubject').reset();
															formWin.down('#empSmsDiscription').show();
															formWin.down('#empSmsDiscriptionNotice').show();
															pushNotificationDiscription.hide();
															pushNotificationDiscriptionNotice.hide();
															pushNotificationDiscription.reset();
														}/*else if(rec[0].data.Dvalue == "PUSH_NOTIFICATION" || rec[0].data.value == "Push Notification"){
															      		 empSubject.show();
															      		 formWin.down("#empStaticUploadFileField").hide();
															      		 this.setAllowBlank(empSubject,false);
															      		 formWin.down("#VoterPoolStudentDocumentMessageAttachmentGrid").hide();
															      		 formWin.down('#empDiscriptionId').reset();
															      		 formWin.down('#empDiscriptionId').hide();
															      		 empSubject.reset();
															      		 smsDiscription.reset();
															      		 smsDiscription.hide();
															      		 empSmsDiscriptionNotice.hide();
															      		 pushNotificationDiscription.reset();
															      		 pushNotificationDiscription.show();
															      		 pushNotificationDiscriptionNotice.show();
															      		 pushNotificationDiscriptionNotice.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+' 1000/1000</span>');
															      		 //formWin.down('#smsDiscription')
															      	 }*/else{
															      		 formWin.down('#empDiscriptionId').reset();
															      		 formWin.down('#empSmsDiscription').reset();
															      		 formWin.down('#empSmsDiscription').hide();
															      		 formWin.down('#empSmsDiscriptionNotice').hide();
															      		 formWin.down("#empStaticUploadFileField").show();
															      		 // formWin.down("#staticDocumentMessageAttachmentGrid").show();
															      		 formWin.down("#VoterPoolStudentDocumentMessageAttachmentGrid").show();
															      		 formWin.down("#empSubject").reset();
															      		 formWin.down("#empSubject").show();
															      		 this.setAllowBlank (formWin.down("#empSubject"),false);
															      		 //formWin.down("#empSubject").allowBlank=false;
															      		 formWin.down('#empDiscriptionId').show();
															      		pushNotificationDiscription.hide();
															      		pushNotificationDiscriptionNotice.hide();
															      		pushNotificationDiscription.reset();
															      	 }
													},
													selectSectionMessageTypeForVoterPoolStudent : function(val,nV,oV){

														var $this =  this;
														var formWin = $this.getElectionvoterpoolforstudentsendmessages();

														//var value = nV.1;
														formWin.down('#empRecieverTypeIncludeMySelf').setValue(false);
														if(nV.messageType==2){
															formWin.down("#empMessageId").hide();
															formWin.down("#empSelectTemplate").allowBlank=true;
															formWin.down("#empSelectTemplate").setVisible(false);     		 
															formWin.down("#empMessageName").allowBlank=true;   
															formWin.down("#empMessageName").setVisible(false);
															formWin.down("#empMsgTempletId").setVisible(true);
															formWin.down("#empMsgTempletId").allowBlank=false;
															formWin.down("#empMsgTempletId").reset();
															formWin.down("#empSubject").setVisible(true);
															//formWin.down("#empSubject").allowBlank=false;
															formWin.down("#empSubject").reset();
															formWin.down("#empDiscriptionId").setVisible(true);
															formWin.down("#empDiscriptionId").reset();
															formWin.down('#empSmsDiscription').reset();
															formWin.down('#empSmsDiscription').hide();
															formWin.down('#empSmsDiscriptionNotice').hide();
															formWin.down('#empPushNotificationDiscription').hide();
															formWin.down('#empPushNotificationDiscriptionNotice').hide();
															formWin.down('#empRecieverTypeIncludeMySelf').setVisible(true);
															this.setAllowBlank (formWin.down("#empSubject"),false);
														}else{
															formWin.down("#empMsgTempletId").allowBlank=true;
															formWin.down("#empMsgTempletId").setVisible(false);     		
															formWin.down("#empMessageId").setVisible(true);
															formWin.down("#empSelectTemplate").setVisible(true);     		
															formWin.down("#empMessageName").setVisible(true);
															formWin.down("#empMessageName").reset();
															//formWin.down("#empSubject").allowBlank=true;
															this.setAllowBlank (formWin.down("#empSubject"),true);
															formWin.down("#empSubject").setVisible(false);
															formWin.down("#empDiscriptionId").setVisible(false);
															formWin.down("#empMessageName").allowBlank=false;  
															formWin.down("#empSelectTemplate").allowBlank=false;
															formWin.down("#empSelectTemplate").reset();
															formWin.down("#VoterPoolStudentDocumentMessageAttachmentGrid").setVisible(false);
															formWin.down("#empStaticUploadFileField").setVisible(false);
															formWin.down('#empSmsDiscription').reset();
															formWin.down('#empSmsDiscription').hide();
															formWin.down('#empSmsDiscriptionNotice').hide();
															formWin.down('#empPushNotificationDiscription').hide();
															formWin.down('#empPushNotificationDiscriptionNotice').hide();
															formWin.down('#empRecieverTypeIncludeMySelf').setVisible(false);
															this.setAllowBlank (formWin.down("#empMessageName"),false);
															this.setAllowBlank (formWin.down("#empSelectTemplate"),false);
															// var allowblankFalse = '<span class="required" style="color:red"> *</span>';
															// formWin.down("#empMessageName").setFieldLabel(getMessagingModuleTranslation('MESSAGE_NAME')+allowblankFalse);
															//formWin.down("#empSelectTemplate").setFieldLabel(getMessagingModuleTranslation('SELECT_TEMPLATE')+allowblankFalse);
														}
													},  
													uploadForVoterPoolStudentStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts){
												    	   var this$ = this;
												    	   var setupForm = fileField.up('electionvoterpoolforstudentsendmessages');
												    	   var grid = setupForm.down('#voterPoolStudentStaticDocumentAttachmentGridMessage');
												    	   fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
												    	   fileField.setRawValue(fileUploadPath);
												    	   var file = fileField.fileInputEl.dom.files[0];
												    	   fileField.setRawValue(fileUploadPath);
												    	   if((file.size / 1048576) <= CONSTANTS.EMAIL_UPLOAD_FILE_SIZE_LIMIT  ){
												    		   if(!isNullOrEmpty(fileUploadPath)){
												    			   var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
												    			   if (extension == "gif" || extension == "png" || extension == "bmp"
												    				   || extension == "jpeg" || extension == "jpg" || extension == "pdf" 
												    					   || extension == "doc" || extension == "docx" || extension == "txt"
												    						   || extension == "xls" || extension == "csv" || extension == "xml" 
												    							   || extension == "zip" || extension == "xlsx" || extension == "ppt" || extension == "pptx") {
												    				   var entityId = 'student';
												    				   var module = 'messaging';
												    				   var entityType = 'template';
												    				   var documentType = 'DOCUMENT';
												    				   var isTransient = true;
												    				   var this$ = this;
												    				   Ext.getBody().mask(getCommonTranslation('LOADING'), 'x-mask-loading');
												    				   this$.saveStaticDocumentFormMessageForVoterPoolStudent(entityId, module, entityType, documentType, function(success, action, isTransient){
												    					   if(success){
												    						   Ext.getBody().unmask();
												    						   var path = Ext.JSON.decode(action.response.responseText).path;
												    						   var user = this$.getCurrentlyLoggedInUser();
												    						   var store = grid.getStore();
												    						   var documentStatus = "SUBMITTED";
												    						   var documentType = null;
												    						   if(!isNullOrEmpty(path)){
												    							   store.add({
												    								   id: '',
												    								   name: fileUploadPath,
												    								   path: path ,
												    								   createdBy : {
												    									   id :user.id,
												    									   value : user.value,
												    									   code : user.code
												    								   },
												    								   status : documentStatus,
												    								   documentType : documentType,
												    								   templateConfigDocId: '',
												    								   submissionDate: Ext.Date.format(new Date(), 'd-m-Y')

												    							   });
												    							   this$.loadGridWithFileNameMessage(grid,fileUploadPath,store);
												    							   showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
												    						   }
												    						   var form=this$.getElectionvoterpoolforstudentsendmessages();
												           	            	   var empSubject = form.down('#empSubject').getValue();
												           	            	   if(!isNullOrEmpty(empSubject)){
												           	            		   if(empSubject == ' '){
												           	            			form.down('#empSubject').reset();
												           	            		   }
												           	            	   }
												    						   fileField.reset();
												    					   }

												    				   }, isTransient);
												    			   }else{
												    				   fileField.reset();
												    				   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
												    			   }
												    		   }
												    	   }else{
												    		   fileField.reset();
												    		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
												    	   }
												       }, 
												       saveStaticDocumentFormMessageForVoterPoolStudent : function(entityId, module, entityType, documentType, callBackFunction, isTransient){
													       	var submitUrl = '';
													       	var templateTab = this.getContentpanel();
													       	var formWin =  this.getElectionvoterpoolforstudentsendmessages();
													       	var form = formWin.down('#empMsgDetailsForm');
													       	var id = form.down('#emp_document_hidden_field');
													           if (isNullOrEmpty(id.getSubmitValue())) {
													               submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
													           }
													           var data = new Object();
													           if(!isNullOrEmpty(entityId)){
													           	data.entityId = entityId;
													           }else{
													           	data.entityId = null;
													           }
													           if(!isNullOrEmpty(module)){
													           	data.module = module;
													           }else{
													           	data.module = null;
													           }
													           if(!isNullOrEmpty(entityType)){
													           	data.entityType = entityType;
													           }else{
													           	data.entityType = null;
													           }
													           form.getForm().setValues(data);
													           form.getForm().submit({
													           	method : 'POST',
													           	url : submitUrl,
													           	success : function(form, action){
													           		callBackFunction(true, action, isTransient);
													           		
													           	}
													           });
													       },
													       deleteVoterPoolStudentStaticMessageDocument : function(view, rowIndex, colIndex, item, e, record, row){
													    	   var grid = view.up('#voterPoolStudentStaticDocumentAttachmentGridMessage');
													    	   var panel = this.getContentpanel().getActiveTab();
													    	   var tabTitle = panel.title;
													    	   var store = grid.getStore();
													    	   var templateConfigDocId = record.get('templateConfigDocId');
													    	   var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
													    	   if(!(tabTitle == viewTitle)){
													    		   if(!isNullOrEmpty(templateConfigDocId)){
													    			   showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
													    				   if (btn == 'yes') {
													    					   Ext.Ajax.request({
													    						   type: 'rest',
													    						   url: SERVERURL.STATIC_DOC_DELETE,
													    						   method: 'DELETE',
													    						   params: {
													    							   templateConfigDocId : templateConfigDocId
													    						   },
													    						   headers: {
													    							   'Content-Type': 'application/json'
													    						   },
													    						   success: function(form, action) {
													    							   store.remove(record);
													    							   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
													    						   }
													    					   });
													    				   }
													    			   });

													    		   }else{
													    			   store.remove(record);
													    			   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
													    		   }
													    	   }else{
													    		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
													    	   }

													       },
													       loadStudentScheduleFieldForStudent : function(radio,newValue, oldValue){
																var adhocMessageForm = radio.up('form');
																var scheduleDateField = adhocMessageForm.down('#empScheduleDate');
																var scheduleTimeField = adhocMessageForm.down('#empScheduleTime');
																var radioValue = radio.getValue().empSendingPriority;

																if(radioValue=='IMMEDIATE'){
																	scheduleDateField.setVisible(false);
																	scheduleDateField.setDisabled(true);
																	scheduleTimeField.setVisible(false);
																	scheduleTimeField.setDisabled(true);    		
																}
																else if(radioValue=='SCHEDULE'){
																	scheduleDateField.setVisible(true);
																	scheduleDateField.setDisabled(false);
																	scheduleTimeField.setVisible(true);
																	scheduleTimeField.setDisabled(false);
																}
															}, 
															loadGridWithFileNameMessage:function(grid,value,store){
														    	   grid.bindStore(store);
														       },
														       
														       /*******************Send Msge Funcationlity for External Users***/
														       openVoterPoolExternalUserSendMessage:function(obj){

																	var grid = this.getExternaluservoterpoolgrid();
																	if(grid.getSelectionModel().getCount()>0) {
																		var  record = grid.getSelectionModel().getSelection()
																		var electionVoterPoolUrl;
																		 if(record.length==1){
																			 electionVoterPoolUrl =record[0].data.electionVoterPoolUrl;
																		 }
																		var $this=this;
																		var contentPanel = this.getContentpanel(); //get hold of the content panel where we are adding all the tabs
																		var structure = Ext.widget('electionvoterpoolforexternalusersendmessages',{
																			itemId:'voterPoolForExternalUser'
																		});
																		var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
																		/**
																		 * This is to remove tab from content panel and open same tab again
																		 */
																		var getcontroller=this.getController('menu.CoreERPNavigationController');
																		var getTab=getcontroller.getTab(tabName);
																		if(getTab!=null){
																			contentPanel.remove(getTab, true);
																		}
																		var formWindowTab = $this.getElectionvoterpoolforexternalusersendmessages();
																		formWindowTab.down("#empSelectTemplate").allowBlank=true;
																		formWindowTab.down("#empSelectTemplate").setVisible(false);
																		formWindowTab.down("#empMessageName").allowBlank=true;   
																		
																		formWindowTab.down("#empMessageName").setVisible(false);
																		var templateStore = formWindowTab.down('#empSelectTemplate').getStore();
																		templateStore.getProxy().extraParams={
																			msgRecipientTypeId:2
																		};
																		templateStore.load();

																		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
																		Ext.Ajax.request({
																			method : "GET",
																			type : 'rest',
																			url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=ExtUsrElection539740-692d-4ae1-bc17-338c4002874d',	//Committeebe539740-692d-4ae1-bc17-338c4002874d',
																			headers : {
																				'Content-Type' : 'application/json'
																			},
																			success : function(form,action) {
																				var data = Ext.JSON.decode(form.responseText);
																				formWindowTab.down("#id").setValue(data.id);
																				formWindowTab.down("#code").setValue(data.code);
																				formWindowTab.down("#empTemplateConfigName").setValue(data.templateConfigName);
																				formWindowTab.down("#empMsgSubCategoryId").setValue(data.msgSubCategoryId);
																				formWindowTab.down("#empMsgCategoryId").setValue(data.msgCategoryId);
																				Ext.getBody().unmask();

																				//grid.getStore().reload();
																				//showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
																			}

																		});
																		openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_THREE);
																		/*if (!formWindow) {
																	    				Ext.widget('jobapplicationemployeesendmessages');
																	    				formWindow = $ this.getElectionvoterpoolsendmessages();
																	    			}
																	    			formWindow.show(;*/

																	} else {
																		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
																	}
																},
																selectMessageTempForVoterPoolExternalUser: function(obj,rec){
																	var $this =  this;
																	var formWin = $this.getElectionvoterpoolforexternalusersendmessages();
																	var empSubject = formWin.down('#empSubject');
																	var smsDiscription = formWin.down('#empSmsDiscription');
																	var smsDiscriptionNotice = formWin.down('#empSmsDiscriptionNotice');
																	var pushNotificationDiscription = formWin.down('#empPushNotificationDiscription');
																	var pushNotificationDiscriptionNotice = formWin.down('#empPushNotificationDiscriptionNotice');
																	if(rec[0].data.value == "SMS")
																	{  
																		this.setAllowBlank (formWin.down("#empSubject"),true);
																		//formWin.down("#empSubject").allowBlank=true;
																		formWin.down("#empSubject").hide();
																		formWin.down("#empStaticUploadFileField").hide();
																		formWin.down("#voterPoolExternalUserDocumentMessageAttachmentGrid").hide();
																		formWin.down('#empDiscriptionId').reset();
																		formWin.down('#empDiscriptionId').hide();	       		 
																		formWin.down('#empSubject').reset();
																		formWin.down('#empSmsDiscription').show();
																		formWin.down('#empSmsDiscriptionNotice').show();
																		pushNotificationDiscription.hide();
																		pushNotificationDiscriptionNotice.hide();
																		pushNotificationDiscription.reset();
																	}else{
																		      		 formWin.down('#empDiscriptionId').reset();
																		      		 formWin.down('#empSmsDiscription').reset();
																		      		 formWin.down('#empSmsDiscription').hide();
																		      		 formWin.down('#empSmsDiscriptionNotice').hide();
																		      		 formWin.down("#empStaticUploadFileField").show();
																		      		
																		      		 formWin.down("#voterPoolExternalUserDocumentMessageAttachmentGrid").show();
																		      		 formWin.down("#empSubject").reset();
																		      		 formWin.down("#empSubject").show();
																		      		 this.setAllowBlank (formWin.down("#empSubject"),false);
																		      		
																		      		 formWin.down('#empDiscriptionId').show();
																		      		pushNotificationDiscription.hide();
																		      		pushNotificationDiscriptionNotice.hide();
																		      		pushNotificationDiscription.reset();
																		      	 }
																},
																selectSectionMessageTypeForVoterPoolExternalUser : function(val,nV,oV){

																	var $this =  this;
																	var formWin = $this.getElectionvoterpoolforexternalusersendmessages();

																	//var value = nV.1;
																	formWin.down('#empRecieverTypeIncludeMySelf').setValue(false);
																	if(nV.messageType==2){
																		formWin.down("#empMessageId").hide();
																		formWin.down("#empSelectTemplate").allowBlank=true;
																		formWin.down("#empSelectTemplate").setVisible(false);     		 
																		formWin.down("#empMessageName").allowBlank=true;   
																		formWin.down("#empMessageName").setVisible(false);
																		formWin.down("#empMsgTempletId").setVisible(true);
																		formWin.down("#empMsgTempletId").allowBlank=false;
																		formWin.down("#empMsgTempletId").reset();
																		formWin.down("#empSubject").setVisible(true);
																		//formWin.down("#empSubject").allowBlank=false;
																		formWin.down("#empSubject").reset();
																		formWin.down("#empDiscriptionId").setVisible(true);
																		formWin.down("#empDiscriptionId").reset();
																		formWin.down('#empSmsDiscription').reset();
																		formWin.down('#empSmsDiscription').hide();
																		formWin.down('#empSmsDiscriptionNotice').hide();
																		formWin.down('#empPushNotificationDiscription').hide();
																		formWin.down('#empPushNotificationDiscriptionNotice').hide();
																		formWin.down('#empRecieverTypeIncludeMySelf').setVisible(true);
																		this.setAllowBlank (formWin.down("#empSubject"),false);
																	}else{
																		formWin.down("#empMsgTempletId").allowBlank=true;
																		formWin.down("#empMsgTempletId").setVisible(false);     		
																		formWin.down("#empMessageId").setVisible(true);
																		formWin.down("#empSelectTemplate").setVisible(true);     		
																		formWin.down("#empMessageName").setVisible(true);
																		formWin.down("#empMessageName").reset();
																		//formWin.down("#empSubject").allowBlank=true;
																		this.setAllowBlank (formWin.down("#empSubject"),true);
																		formWin.down("#empSubject").setVisible(false);
																		formWin.down("#empDiscriptionId").setVisible(false);
																		formWin.down("#empMessageName").allowBlank=false;  
																		formWin.down("#empSelectTemplate").allowBlank=false;
																		formWin.down("#empSelectTemplate").reset();
																		formWin.down("#voterPoolExternalUserDocumentMessageAttachmentGrid").setVisible(false);
																		formWin.down("#empStaticUploadFileField").setVisible(false);
																		formWin.down('#empSmsDiscription').reset();
																		formWin.down('#empSmsDiscription').hide();
																		formWin.down('#empSmsDiscriptionNotice').hide();
																		formWin.down('#empPushNotificationDiscription').hide();
																		formWin.down('#empPushNotificationDiscriptionNotice').hide();
																		formWin.down('#empRecieverTypeIncludeMySelf').setVisible(false);
																		this.setAllowBlank (formWin.down("#empMessageName"),false);
																		this.setAllowBlank (formWin.down("#empSelectTemplate"),false);
																		
																	}
																},  
																uploadForVoterPoolExternalUserStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts){
															    	   var this$ = this;
															    	   var setupForm = fileField.up('electionvoterpoolforexternalusersendmessages');
															    	   var grid = setupForm.down('#voterPoolExternalUserStaticDocumentAttachmentGridMessage');
															    	   fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
															    	   fileField.setRawValue(fileUploadPath);
															    	   var file = fileField.fileInputEl.dom.files[0];
															    	   fileField.setRawValue(fileUploadPath);
															    	   if((file.size / 1048576) <= CONSTANTS.EMAIL_UPLOAD_FILE_SIZE_LIMIT  ){
															    		   if(!isNullOrEmpty(fileUploadPath)){
															    			   var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
															    			   if (extension == "gif" || extension == "png" || extension == "bmp"
															    				   || extension == "jpeg" || extension == "jpg" || extension == "pdf" 
															    					   || extension == "doc" || extension == "docx" || extension == "txt"
															    						   || extension == "xls" || extension == "csv" || extension == "xml" 
															    							   || extension == "zip" || extension == "xlsx" || extension == "ppt" || extension == "pptx") {
															    				   var entityId = 'student';
															    				   var module = 'messaging';
															    				   var entityType = 'template';
															    				   var documentType = 'DOCUMENT';
															    				   var isTransient = true;
															    				   var this$ = this;
															    				   Ext.getBody().mask(getCommonTranslation('LOADING'), 'x-mask-loading');
															    				   this$.saveStaticDocumentFormMessageForVoterPoolExternalUser(entityId, module, entityType, documentType, function(success, action, isTransient){
															    					   if(success){
															    						   Ext.getBody().unmask();
															    						   var path = Ext.JSON.decode(action.response.responseText).path;
															    						   var user = this$.getCurrentlyLoggedInUser();
															    						   var store = grid.getStore();
															    						   var documentStatus = "SUBMITTED";
															    						   var documentType = null;
															    						   if(!isNullOrEmpty(path)){
															    							   store.add({
															    								   id: '',
															    								   name: fileUploadPath,
															    								   path: path ,
															    								   createdBy : {
															    									   id :user.id,
															    									   value : user.value,
															    									   code : user.code
															    								   },
															    								   status : documentStatus,
															    								   documentType : documentType,
															    								   templateConfigDocId: '',
															    								   submissionDate: Ext.Date.format(new Date(), 'd-m-Y')

															    							   });
															    							   this$.loadGridWithFileNameMessage(grid,fileUploadPath,store);
															    							   showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
															    						   }
															    						   var form=this$.getElectionvoterpoolforexternalusersendmessages();
															           	            	   var empSubject = form.down('#empSubject').getValue();
															           	            	   if(!isNullOrEmpty(empSubject)){
															           	            		   if(empSubject == ' '){
															           	            			form.down('#empSubject').reset();
															           	            		   }
															           	            	   }
															    						   fileField.reset();
															    					   }

															    				   }, isTransient);
															    			   }else{
															    				   fileField.reset();
															    				   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
															    			   }
															    		   }
															    	   }else{
															    		   fileField.reset();
															    		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
															    	   }
															       }, 
															       saveStaticDocumentFormMessageForVoterPoolExternalUser : function(entityId, module, entityType, documentType, callBackFunction, isTransient){
																       	var submitUrl = '';
																       	var templateTab = this.getContentpanel();
																       	var formWin =  this.getElectionvoterpoolforexternalusersendmessages();
																       	var form = formWin.down('#empMsgDetailsForm');
																       	var id = form.down('#emp_document_hidden_field');
																           if (isNullOrEmpty(id.getSubmitValue())) {
																               submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
																           }
																           var data = new Object();
																           if(!isNullOrEmpty(entityId)){
																           	data.entityId = entityId;
																           }else{
																           	data.entityId = null;
																           }
																           if(!isNullOrEmpty(module)){
																           	data.module = module;
																           }else{
																           	data.module = null;
																           }
																           if(!isNullOrEmpty(entityType)){
																           	data.entityType = entityType;
																           }else{
																           	data.entityType = null;
																           }
																           form.getForm().setValues(data);
																           form.getForm().submit({
																           	method : 'POST',
																           	url : submitUrl,
																           	success : function(form, action){
																           		callBackFunction(true, action, isTransient);
																           		
																           	}
																           });
																       },
																       deleteVoterPoolExternalUserStaticMessageDocument : function(view, rowIndex, colIndex, item, e, record, row){
																    	   var grid = view.up('#voterPoolExternalUserStaticDocumentAttachmentGridMessage');
																    	   var panel = this.getContentpanel().getActiveTab();
																    	   var tabTitle = panel.title;
																    	   var store = grid.getStore();
																    	   var templateConfigDocId = record.get('templateConfigDocId');
																    	   var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
																    	   if(!(tabTitle == viewTitle)){
																    		   if(!isNullOrEmpty(templateConfigDocId)){
																    			   showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
																    				   if (btn == 'yes') {
																    					   Ext.Ajax.request({
																    						   type: 'rest',
																    						   url: SERVERURL.STATIC_DOC_DELETE,
																    						   method: 'DELETE',
																    						   params: {
																    							   templateConfigDocId : templateConfigDocId
																    						   },
																    						   headers: {
																    							   'Content-Type': 'application/json'
																    						   },
																    						   success: function(form, action) {
																    							   store.remove(record);
																    							   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
																    						   }
																    					   });
																    				   }
																    			   });

																    		   }else{
																    			   store.remove(record);
																    			   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
																    		   }
																    	   }else{
																    		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
																    	   }

																       },
																       loadStudentScheduleFieldForExternalUser : function(radio,newValue, oldValue){
																			var adhocMessageForm = radio.up('form');
																			var scheduleDateField = adhocMessageForm.down('#empScheduleDate');
																			var scheduleTimeField = adhocMessageForm.down('#empScheduleTime');
																			var radioValue = radio.getValue().empSendingPriority;

																			if(radioValue=='IMMEDIATE'){
																				scheduleDateField.setVisible(false);
																				scheduleDateField.setDisabled(true);
																				scheduleTimeField.setVisible(false);
																				scheduleTimeField.setDisabled(true);    		
																			}
																			else if(radioValue=='SCHEDULE'){
																				scheduleDateField.setVisible(true);
																				scheduleDateField.setDisabled(false);
																				scheduleTimeField.setVisible(true);
																				scheduleTimeField.setDisabled(false);
																			}
																		}, 
																		loadGridWithFileNameMessage:function(grid,value,store){
																	    	   grid.bindStore(store);
																	       },
										 getDownloadFile : function(documentId,fileType){

										    	if(!isNullOrEmpty(documentId)){
										    		var csvForm = Ext.create('Ext.form.Panel'); 
										    		csvForm.getForm().submit({
										    			target: '_blank',
										    			method:'POST',
										    			params :{
										    				access_token : Ext.Ajax.defaultHeaders.access_token
										    			},
										    			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
										    			url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
										    			standardSubmit :true
										    		});
										    	}
										    },
										    onChangeClickedBtnCss:function(btn){
										    	var structure = this.getStudentvoteinelectionliststructure();
											    var listPanel = structure.down('#listPanel');
											    var btnItems = listPanel.items.items;
											    var btnItemLength = listPanel.items.items.length ;
											    for(var i=1;i<btnItemLength;i++){
											    	if(btnItems[i].hasCls('btnClickedCls') == true){
											    		btnItems[i].removeCls('btnClickedCls');
											    		btn.addCls('btnClickedCls');
											    	}else{
											    		 btn.addCls('btnClickedCls');
											    	}
											    }
											   
										    },
										    openCandidateListDataView:function(data,studentId){
										    	var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
										        var structure = Ext.widget('studentvoteinelectionstructure');
										    	var tabName = getCommonTranslation('VOTE_IN_ELECTIONS_TAB');
										    	/**
										    	 * This is to remove tab from content panel and open same tab again
										    	 */
										    	var getcontroller=this.getController('menu.CoreERPNavigationController');
										    	var getTab=getcontroller.getTab(tabName);
										    	if(getTab!=null){
										    		contentPanel.remove(getTab, true);
										    	}
										    	openTab(contentPanel, tabName, structure, CONSTANTS.MENU_COLOR_TWO);
										    	if(!Ext.getStore('electionTempStore')){
										    		Ext.create('Academia.store.election.election.SPElectionAlbumStore',{
											    		storeId : 'electionTempStore',
											    	})
										    	}else{
										    		Ext.getStore('electionTempStore').removeAll();
										    	}
										    	if(!isNullOrEmpty(studentId)){
										    		structure.down('#electionStudentItemId').setValue(studentId);
										    	}
										    	 var albumStructure = this.getStudentvoteinelectionalbumstructure();
										    	 albumStructure.config.electionStatus = data;
										    },
										  
											loadDFRForAddressContactDetailVisibility: function(form){
										    	var $this = this;
										    	//var form=$this.getElectionform();
										    	
										    	var votingStartDateTime=form.down('#votingStartDateTime');
										    	var votingEndDateTime =form.down('#votingEndDateTime');
										    	var votingPool=form.down('#extendedDateFieldSet');
										    	var adminCapStartDateAndTIme =form.down('#adminCapStartDateAndTIme');
										    	var adminCapEndDateAndTIme=form.down('#adminCapEndDateAndTIme');
										    	var isAdminCapture=form.down('#isAdminCapture');
										    	
										    	Ext.Ajax.request({
										    		type: 'rest',
										    		async: false,
										    		url: SERVERURL.COMMON_FORM_FIELD_INFO,
										    		params: {
										    			screenName: 'electionform',
										    			academyLocationId: $this.getCurrentAcademyLocation(),
										    			languageCode:'en'
										    		},
										    		method: 'GET',
										    		success: function(res, action) {
										    			var response = Ext.decode(res.responseText);
										    			if( Object.keys(response).length > 0 ){
										    				var records=response.electionform;
										    				for(i in records){  
										    					if(records[i].formFieldInputType=='fieldset' && records[i].formFieldId=='votingStartDateTime' && records[i].isVisible==true || records[i].isMandatory == true){
										    						votingStartDateTime.setTitle(records[i].formFieldLabel+ ': <span class="required" style="color:red"> *</span>');
										    						
										    					}
										    					
										    					if(records[i].formFieldInputType=='fieldset' && records[i].formFieldId=='votingEndDateTime' && records[i].isMandatory == true){
										    						votingEndDateTime.setTitle(records[i].formFieldLabel + ': <span class="required" style="color:red"> *</span>');
										    					}
										    					
										    					if(records[i].formFieldInputType=='fieldset' && records[i].formFieldId=='extendedDateFieldSet' && records[i].isMandatory == true){
										    						votingPool.setTitle(records[i].formFieldLabel+ ': <span class="required" style="color:red"> *</span>');
										    					}
										    					if(records[i].formFieldInputType=='fieldset' && records[i].formFieldId=='adminCapStartDateAndTIme'){
										    						if( records[i].isMandatory == true){
										    							adminCapStartDateAndTIme.setTitle(records[i].formFieldLabel+ ': <span class="required" style="color:red"> *</span>');
										    						}else{
										    							adminCapStartDateAndTIme.setTitle(records[i].formFieldLabel);
										    						}
										    						
										    					}
										    					
										    					if(records[i].formFieldInputType=='fieldset' && records[i].formFieldId=='adminCapEndDateAndTIme'){
										    						if( records[i].isMandatory == true){
										    							adminCapEndDateAndTIme.setTitle(records[i].formFieldLabel+ ': <span class="required" style="color:red"> *</span>');
										    						}else{
										    							adminCapEndDateAndTIme.setTitle(records[i].formFieldLabel);
										    						}
										    						
										    					}
										    					
										    				}
										    			}
										    		}
										    	});
										    },
										    loadDFRForCandidateInformation: function(form,type){
										    	var $this = this;
										    
										    	
										    	var studentItemId=form.down('#studentItemId');
										    	var employeeId =form.down('#employeeId');
										    	var externalUserId=form.down('#externalUserId');
										    	
										    	
										    	Ext.Ajax.request({
										    		type: 'rest',
										    		async: false,
										    		url: SERVERURL.COMMON_FORM_FIELD_INFO,
										    		params: {
										    			screenName: 'candidateinfowin',
										    			academyLocationId: $this.getCurrentAcademyLocation(),
										    			languageCode:'en'
										    		},
										    		method: 'GET',
										    		success: function(res, action) {
										    			var response = Ext.decode(res.responseText);
										    			if( Object.keys(response).length > 0 ){
										    				var records=response.candidateinfowin;
										    				for(i in records){  
										    					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='externalUserId' ){ 
										    						if(type=="STUDENTS"){
										    							studentItemId.setFieldLabel(records[i].formFieldLabel+ ': <span class="required" style="color:red"> *</span>');
										    						}else if(type=="STAFF_USERS"){
										    							employeeId.setFieldLabel(records[i].formFieldLabel+ ': <span class="required" style="color:red"> *</span>');
										    						}
										    				}
										    					
										    					
										    					
										    				}
										    			}
										    		}
										    	});
										    },
										    disableElectionExtraButton:function(column,selected,grid) {
										    	var this$ = this;
										    	var captureBollotVotesBtn = grid.down('#captureBollotVotesBtn');
										    	var structure = this$.getElectonvoterpoolstructure();
										    	if(structure.config.isAdminCaptureVote){
										        	captureBollotVotesBtn.setDisabled(false);
										        }else{
										        	captureBollotVotesBtn.setDisabled(true);
										        }
										    	var count=selected.length;
										    	if(count== 1){ // enable
										    		var applicationSource = selected[0].data.votingAction;
										    		if(structure.config.isAdminCaptureVote){
										    			if( applicationSource == "VOTED"){
										    				captureBollotVotesBtn.setDisabled(true);
										    			}else{
										    				captureBollotVotesBtn.setDisabled(false);
										    			}
										    		}else{
										    			captureBollotVotesBtn.setDisabled(true);
										    		}
										    		/*if( applicationSource == "VOTED"){
										    			captureBollotVotesBtn.setDisabled(true);
										    		}else{
										    			captureBollotVotesBtn.setDisabled(false);
										    		}*/
										    	}else{  // disable
										    		captureBollotVotesBtn.setDisabled(true);
										    		
										    	}
										    },
    });
