/**
 *
 * Rajkumar
 */
Ext.define('Academia.controller.enquiry.enquirydetail.EnquiryDetailController', {
    extend: 'Academia.controller.base.BaseController',
    models: ['enquiry.enquiryDetail.EnquiryDetailModel'],
    stores: ['enquiry.EnquirySourceStore', 'enquiry.EnquiryRegisteredBy','common.CountryStore',
    	'sgappointment.sgappointment.SGAppointmentGridStore','sgappointment.sgappointment.SGVisitorCategoryStore',
    	'sgappointment.sgappointment.SGParentGuardianStore','enquiry.EnquiryCodeSearchStore','common.CountryStore',
    	'coursetransaction.sectionmanagement.FacultyIdValueSmartSearch','hostel.roomallocation.UserSmartSearchByUserType',
    	'sgappointment.sgappointment.SGReasonForVisitStore','sgappointment.sgappointment.SGVisitStatus',
    	'coursetransaction.sectionmanagement.EmployeeIdValueSmartSearch','admission.applications.applicantProfileBase.ApplicantSmartSearchStore',
    	'criteriabuilder.userquicksearch.QuickSearchPrintNameStore','messaging.SendMessageReportEventNameStore',
    	'messaging.SendMessageReportRecipientStore',
    	'enquiry.communicationhistorystore.CommunicationHistoryNameStore',
    	'enquiry.communicationhistorystore.CommunicationHistoryContactStore',
    	'messaging.CommunicationHistoryReportList','sgappointment.sgappointment.SGEnquiryAppointmentGridStore','common.GenderTypeStore',
    	'enquiry.EnqIntermediateType','enquiry.EnquiryCodeSearchForAppointmentStore'],
    	
    views: ['enquiry.enquirydetail.EnquiryDetailStructure','enquiry.enquirydetail.EnquiryDetailForm',
            'enquiry.TrackEnquiryStructure','enquiry.dashboard.EnquiryGridsForPendingEnquiryDashboard',
            'sgappointment.sgappointment.sgAppointmentDetailStructure','sgappointment.sgappointment.SGAppointmentDetailGrid',
            'sgappointment.sgappointment.SGAppointmentForm','enquiry.CommunicationHistory.CommunicationHistoryEnquiryStructure',
            'enquiry.CommunicationHistory.CommunicationHistoryFilter','enquiry.CommunicationHistory.CommunicationHistoryGrid','baselayout.contentarea.ContentPanel'],

    alias: "widget.enquirydetailcontroller",
    refs: [{
    	ref:'trackenquirygrid',
    	selector:'trackenquirygrid'
    },{
    	ref:'searchresultgrid',
    	selector:'searchresultgrid[itemId=trackenquirygrid]'
    },{
        ref: 'enquirydetailform',
        selector: 'enquirydetailform'
    }, {
        ref: 'enquirytabstructure',
        selector: 'enquirytabstructure'
    }, {
        ref: 'enquirygridsforpendingenquirydashboard',
        selector: 'enquirygridsforpendingenquirydashboard'
    },{
    	ref: 'enquirygridsforpendingenquirydashboard',
    	selector: 'enquirygridsforpendingenquirydashboard'
    },{
        ref: 'sgappointmentdetailstructure',
        selector: 'sgappointmentdetailstructure'
    },{
        ref: 'sgappointmentdetailgrid',
        selector: 'sgappointmentdetailgrid'
    },{
    	ref: 'sgappointmentform',
    	selector: 'sgappointmentform[itemId=SGAppointmentEnquiryItemId]'
    },{
    	ref: 'contentPanel',
    	selector: 'contentPanel'
    },{
 	   ref : 'viewcalendarwin',
	   selector : 'viewcalendarwin' 
   },{
		ref : 'communicationhistoryenquirystructure',
		selector : 'communicationhistoryenquirystructure'
	},{
		ref : 'communicationhistoryfilter',
		selector : 'communicationhistoryfilter'
	},{
		ref : 'communicationhistorygrid',
		selector : 'communicationhistorygrid'
	}    
    ],
    config: {
    	
    	ENQUIRY_MANAGE_APPOINTMENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ENQUIRY_MANAGE_APPOINTMENT_PRIVILEGES'),
    	ENQUIRY_STUDENT_DETAILS_TAB_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ENQUIRY_STUDENT_DETAILS_TAB_PRIVILEGES'),
    	ENQUIRY_EDUCATION_DETAILS_TAB_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ENQUIRY_EDUCATION_DETAILS_TAB_PRIVILEGES'),
    	ENQUIRY_COMMUNICATION_HISTORY_DETAILS_TAB_PRIVILEGES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ENQUIRY_COMMUNICATION_HISTORY_DETAILS_TAB_PRIVILEGES')
    	
      },
    init: function() {

        this.control({
        	
        	'communicationhistoryfilter customcombobox#recipientName': {
        		render: function(obj) {
        			var structFilter = this.getEnquirytabstructure().getForm();
        			var enqId=structFilter.findField("hiddenEnquiryId").getValue();
        			obj.getStore().getProxy().extraParams = {
        				enquiryId : enqId
        			};
        			obj.getStore().load();
        		}
             },
             'communicationhistoryfilter customcombobox#emailId': {
         		render: function(obj) {
         			var structFilter = this.getEnquirytabstructure().getForm();
         			var enqId=structFilter.findField("hiddenEnquiryId").getValue();
         			obj.getStore().getProxy().extraParams = {
         				enquiryId : enqId,
         				isEmail:true
         			};
         			 var form=this.getCommunicationhistoryfilter();
         			form.down("#emailId").getStore().load();
         		}
              },
              'communicationhistoryfilter radiogroup[itemId=sendmessageId]': {
            	  change: function(obj, newValue, oldValue, eOpts) {
            		  var structFilter = this.getEnquirytabstructure().getForm();
            		  var enqId=structFilter.findField("hiddenEnquiryId").getValue();
            		  var filterForm=this.getCommunicationhistoryfilter();
            		  if(newValue.sendMessage=='1'){
            			  filterForm.down('#emailId').setVisible(true);
            			  filterForm.down('#mobileId').setVisible(false);
            			  var emailStore= filterForm.down('#emailId').getStore();
            			  emailStore.getProxy().extraParams = {
                			  enquiryId : enqId,
                			  isEmail:true
                		  };
            			  emailStore.load();
            		  }else{
            			  filterForm.down('#emailId').setVisible(false);
            			  filterForm.down('#mobileId').setVisible(true);
            			  var mobileStore= filterForm.down('#mobileId').getStore();
            			  mobileStore.getProxy().extraParams = {
                			  enquiryId : enqId,
                			  isEmail:false
                		  };
            			  mobileStore.load();
            		  }
            		 
            	  }
              },
              'communicationhistoryfilter button[itemId=searchButtonId]':{
            	  click : function(obj){
            		  var form = this.getCommunicationhistoryfilter();
            		  var grid = this.getCommunicationhistorygrid();

            		  var sendMessage = form.down("#sendmessageId").getValue();
            		  var recipient=form.down("#recipientName").getValue();
            		  var enquiryStore=form.down("#emailId").getStore();
            		  if( !isNullOrEmpty(recipient) && recipient != undefined ){

            			  var n = recipient.search("/");
            			  if( n != -1 ){
            				  var res = recipient.split("/");
            				  if( !isNullOrEmpty(res) && res.length > 0 ){
            					  recipient = res[res.length-1];
            					  /*if( recipient.search(" ") != -1 ){
            						  var res2 = recipient.split(" ");
            						  if( !isNullOrEmpty(res2) && res2.length > 0 ){
            							  recipient = res2[0];
            						  }
            					  }*/
            				  }
            			  } else {
            				  if( recipient.search(" ") != -1 ){
            					  var res3 = recipient.split(" ");
            					  if( !isNullOrEmpty(res3) && res3.length > 0 ){
            						  recipient = res3[0];
            					  }
            				  }
            			  }
            			  
            		  } else {
            			  
            			  var recipientComboStore=form.down("#recipientName").getStore();
            			  recipientComboStore.load();
            			  var recipientStoreValue = recipientComboStore.data.items;
            			  var recipientValue = recipientStoreValue[0].data.value;
            			  
            			  var n = recipientValue.search("/");
            			  if( n != -1 ){
            				  var res = recipientValue.split("/");
            				  if( !isNullOrEmpty(res) && res.length > 0 ){
            					  recipientValue = res[res.length-1];
            					  /*if( recipient.search(" ") != -1 ){
		            	        		var res2 = recipient.split(" ");
		            	        		if( !isNullOrEmpty(res2) && res2.length > 0 ){
		            	        			recipient = res2[0];
		            	        		}
		            	        	}*/
            				  }
            			  } else {
            				  /*if( recipient.search(" ") != -1 ){
	            	        		var res3 = recipient.split(" ");
	            	        		if( !isNullOrEmpty(res3) && res3.length > 0 ){
	            	        			recipient = res3[0];
	            	        		}
	            	        	}*/
            			  }
            			  recipient=recipientValue;
            		  }

            		  var contactId=null;
            		  var contactIdValue=null;
            		  var sentbyName=form.down("#sentby").getValue();
            		  var eventNameCode=form.down("#eventName").getValue();
            		  var eventDateForm=Ext.Date.format(form.down("#eventDateForm").getValue(),CONSTANTS.SUBMIT_DATE_FORMAT);
            		  var eventDateTill=Ext.Date.format(form.down("#eventDateTill").getValue(),CONSTANTS.SUBMIT_DATE_FORMAT);
            		  var messageId=form.down("#sendmessageId").getValue();
            		  //var facultyProfile = this.getStudentprofile();
            		  if(messageId.sendMessage==1){
            			  contactId=form.down("#emailId").getValue();
            			  if(contactId==null){
            				 // var contactIdComboStore=enquiryStore;
            				  var storeValue = enquiryStore.data.items;
            				  if(storeValue.length>0){
            				  contactIdValue = storeValue[0].data.primaryeEmailId;
            				  }for(var recordInt=1;recordInt<storeValue.length;recordInt++){
            					  contactIdValue=contactIdValue+","+storeValue[recordInt].data.primaryeEmailId;
            				  }
            				  contactId=contactIdValue;
            			  }
            		  }else{
            			  contactId=form.down("#mobileId").getValue();
            			  if(contactId==null){
            				  var contactIdComboStore=form.down("#mobileId").getStore();
            				  var storeValue = contactIdComboStore.data.items;
            				  if(storeValue.length>0){
            				  contactIdValue = storeValue[0].data.phoneNo;
            				  }for(var recordInt=1;recordInt<storeValue.length;recordInt++){
            					  contactIdValue=contactIdValue+","+storeValue[recordInt].data.phoneNo;
            				  }
            				  contactId=contactIdValue;
            			  }
            		  }
            		  var store = grid.getStore();
            		  store.getProxy().extraParams = {
            			  deliveryModeId: sendMessage.sendMessage,
            			  recipientName: recipient,
            			  contact:contactId,
            			  sentBy:sentbyName,
            			  eventName:eventNameCode,
            			  fromDate:eventDateForm,
            			  toDate:eventDateTill
            		  }
            		  store.load();
            	  }
              },
	        'communicationhistoryfilter button[itemId=resetButtonId]' :{
	        	click: function(f) {
	        		var form = this.getCommunicationhistoryfilter();
	        		var sendMessage = form.down("#sendmessageId").reset();
	        		var recipient=form.down("#recipientName").reset();
	        		var contactId=form.down("#emailId").reset();
	        		var contactId=form.down("#mobileId").reset();
	        		var sentbyName=form.down("#sentby").reset();
	        		var eventNameCode=form.down("#eventName").reset();
	        		var eventDateForm=form.down("#eventDateForm").reset();
	        		var eventDateTill=form.down("#eventDateTill").reset();
	        		form.down('#eventDateForm').setMaxValue(null);
	        		form.down('#eventDateForm').setMinValue(null);
					form.down('#eventDateTill').setMaxValue(null);
					form.down('#eventDateTill').setMinValue(null);
	        		}
              },
        	'enquirydetailform button[itemId=enquirydetail_SubmitButtonId]': {
                click: function(f) {
                    this.saveEnquiryDetail(f);
                }
            },
            /*'enquirydetailform button[itemId=enquirydetail_EditButtonId]': {
                click: this.editEnquiryDetail
            },*/
           
            'enquirydetailform': {
                render: function(f) {
                    this.onFormRender(f);
                }
            },
            
            'enquirytabstructure':{
            	render:function(structure){
            		
            		var associatedAcadLocationIds = new Array();
            		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
            		var enquiryStudentDetailsTabPermissionsList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getENQUIRY_STUDENT_DETAILS_TAB_PERMISSIONS());
            		var enquiryEducationDetailsTabPermissionsList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getENQUIRY_EDUCATION_DETAILS_TAB_PERMISSIONS());
            		var enquiryCommunicationDetailsTabPermissionsList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getENQUIRY_COMMUNICATION_HISTORY_DETAILS_TAB_PRIVILEGES_PERMISSIONS());
            		var enquiryStudentDetailsHiddenTab=true;
            		var enquiryEducationDetailsHiddenTab=true;
            		var enquiryCommunicationHistoryHiddenTab=true;
            		
            		Ext.each(enquiryStudentDetailsTabPermissionsList, function(privilege) {
            			if (privilege === 'VIEW') {
            				enquiryStudentDetailsHiddenTab = false;
            			} else {
            				enquiryStudentDetailsHiddenTab = true;
            			}
            		});
            		
            		Ext.each(enquiryEducationDetailsTabPermissionsList, function(privilege) {
            			if (privilege === 'VIEW') {
            				enquiryEducationDetailsHiddenTab = false;
            			} else {
            				enquiryEducationDetailsHiddenTab = true;
            			}
            		});
            		
            		Ext.each(enquiryCommunicationDetailsTabPermissionsList, function(privilege) {
            			if (privilege === 'VIEW') {
            				enquiryCommunicationHistoryHiddenTab = false;
            			} else {
            				enquiryCommunicationHistoryHiddenTab = true;
            			}
            		});

            		
            		var enquiryTabPanelArea = structure.down('#enquiryTabPanelArea');
            		var tabPanelWithoutEdudetail = {
            			xtype:'tabpanel',
            			plain: true,
            			//id:'enquiry_tabPanelId1',
            			itemId:'enquirytabpanel1',
            			style:{margin:'0!important'},
            			border:false,
            			frame: false,
            			name:'tabPanels',
            			items : [{
            				title : getEnquiryTranslation('ENQUIRY_DETAILS'),      
            				xtype: 'enquirydetailstructure',
            				itemId:'enquirydetailsId',
            				frame: false,
            				border:false,
            				closable: false
            			}, {
            				title :  getEnquiryTranslation('STUDENT_DETAILS'), 
            				xtype: 'studentdetailstructure',
            				itemId:'studentdetailsId',
            				//id:'enquirytabpanel_studentdetailsId',
            				frame: false,
            				border:false,
            				hidden:enquiryStudentDetailsHiddenTab,
            				closable: false
            				},{
            				title : getEnquiryTranslation('ADMISSION_DEATILS'),             
            				xtype: 'admissionreqmntstructure',
            				frame: false,
            				border:false,
            				closable: false
            		    },{
            				title : getEnquiryTranslation('FOLLOW_UP_DETAIL'),             
            				xtype: 'followupstructure',
            				frame: false,
            				border:false,
            				closable: false	
            			},{
        					title : getEnquiryTranslation('SG_APPOINTMENTS'),             
        					xtype: 'sgappointmentdetailstructure',
        					itemId:'sgappointmentdetailId',
        					frame: false,
        					border:false,
        					closable: false
        				},{
            				title : getPersonModuleTranslation('COMMUNICATION_HISTORY'),             
            				xtype: 'communicationhistoryenquirystructure',
            				frame: false,
            				itemId:'communicationhistoryId',
            				border:false,
            				hidden:enquiryCommunicationHistoryHiddenTab,
            				closable: false
            			}/*/*{
            				title : getEnquiryTranslation('ENQUIRY_CHECK_LIST_TITLE'),             
            				xtype: 'checkliststructure',
            				closable: false
            			}*/,{
            				title : getEnquiryTranslation('CLOSURE_TITLE'),             
            				xtype: 'closuredetailstructure',
            				frame: false,
            				border:false,
            				closable: false
            			}]

            		};
            		
            		var tabPanelWithEduDetail = {
            				xtype:'tabpanel',
            				plain: true,
            				//id:'enquiry_tabPanelId2',
            				itemId:'enquirytabpanel2',
            				style:{margin:'0!important'},
            				border:false,
            				frame: false,
            				name:'tabPanels',
            				items : [{
            					title : getEnquiryTranslation('ENQUIRY_DETAILS'),      
            					xtype: 'enquirydetailstructure',
            					itemId:'enquirydetailsId',
            					frame: false,
            					border:false,
            					closable: false
            				}, {
            					title :  getEnquiryTranslation('STUDENT_DETAILS'), 
            					xtype: 'studentdetailstructure',
            					itemId:'studentdetailsId',
            					//id:'enquirytabpanel_studentdetailsId',
            					frame: false,
            					border:false,
            					hidden:enquiryStudentDetailsHiddenTab,
            					closable: false
            					},{
            					title : getEnquiryTranslation('EDUCATION_DETAILS'),             
            					xtype: 'educationdetailstructure',
            					itemId:'examdetailsId',
            					frame: false,
            					border:false,
            					hidden:enquiryEducationDetailsHiddenTab,
            					closable: false 
            				},{
            					title : getEnquiryTranslation('ADMISSION_DEATILS'),             
            					xtype: 'admissionreqmntstructure',
            					frame: false,
            					border:false,
            					closable: false
            			    },{
            					title : getEnquiryTranslation('FOLLOW_UP_DETAIL'),             
            					xtype: 'followupstructure',
            					frame: false,
            					border:false,
            					closable: false	
            				},{
            					title : getEnquiryTranslation('SG_APPOINTMENTS'),             
            					xtype: 'sgappointmentdetailstructure',
            					itemId:'sgappointmentdetailId',
            					frame: false,
            					border:false,
            					closable: false
            				},{
            					title : getPersonModuleTranslation('COMMUNICATION_HISTORY'),             
            					xtype: 'communicationhistoryenquirystructure',
            					itemId:'communicationhistoryId',
            					frame: false,
            					border:false,
            					hidden:enquiryCommunicationHistoryHiddenTab,
            					closable: false
            				},{
            					title : getEnquiryTranslation('CLOSURE_TITLE'),             
            					xtype: 'closuredetailstructure',
            					frame: false,
            					border:false,
            					closable: false
            				}]

            			};
            		
            		if(Ext.app.checkVelocity){
            			enquiryTabPanelArea.add(tabPanelWithoutEdudetail);
            		} else {
            			enquiryTabPanelArea.add(tabPanelWithEduDetail);
            		}
            	}
            },
            
            'enquirytabstructure textfield[itemId=enquiryTxtId]' : {
            	blur : function(obj) {
					 var $this = this;
	            	    var structFilter = $this.getEnquirytabstructure().getForm();
	            	    var defaultText=structFilter.findField("enquiryTxtId").getValue();
	                    if(!isNullOrEmpty(Ext.ComponentQuery.query('textfield[itemId=enquiryTxtId]')[0])){
	                    	//Unique check here
	                    	if(!isNullOrEmpty(Ext.ComponentQuery.query('textfield[itemId=enquiryTxtId]')[0].getValue())){
		                    	if(structFilter.findField("enquiryTxtId").getValue()!=Ext.ComponentQuery.query('textfield[itemId=enquiryTxtId]')[0].getValue()){
			                    	var editUrl = SERVERURL.FIND_ENQUIRY_CODE_UNIQUENESS;
			                    	Ext.Ajax.request({
			                    		method: "GET",
			                    		type: 'rest',
			                    		url: editUrl,
			                    		params: {
			                    			code: Ext.ComponentQuery.query('textfield[itemId=enquiryTxtId]')[0].getValue()
			                    		},
			                    		success: function(response, action) {
			                    			var receiptData = Ext.JSON.decode(response.responseText);
			                    			if(receiptData==false){
			                    				Ext.ComponentQuery.query('textfield[itemId=enquiryTxtId]')[0].setValue(defaultText);
			                    				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ENQUIRY_UNIQUE_CHECK_ERROR_MSG'));
			                    			}
			                    		}
			                    	})
		                    	}
	                    	}else{
	                    		Ext.ComponentQuery.query('textfield[itemId=enquiryTxtId]')[0].setValue(defaultText);
	                    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ENQUIRY_UNIQUE_CHECK_ERROR_MSG'));
	                    	}
	                  }
				}
			 },
				'communicationhistorygrid': {
				cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
					var id = record.get('msgRcpntLogId');
					var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
					if(columnName == "msgContent"){
					if (e.target.tagName == 'A') {
					if (!isNullOrEmpty(id)) {
						Ext.Ajax.request({
							type: 'rest',
							url: SERVERURL.PATH_FIND_MSG_CONTENT_BY_MSG_RCPNTLOG_ID,
							method: 'GET',
							async: false,
							headers: {
								'Content-Type': 'application/json'
							},
							params: {
								id: id
							},
							success: function(response, form, action) {
								responseObject = eval("(" + response.responseText + ")"); //make object of response text
								var msgContent = responseObject.msgContent;
								var win = new Ext.Window({
									title: getMessagingModuleTranslation('MESSAGE_CONTENT'),
									frame: true,
									height: 405,
									minWidth: 767,
									width: 800,
									autoScroll: true,
									modal: true,
									html: msgContent,
									cls: 'messageContentWinCls'
								});
								win.show();
							},
							failure: function(form, action) {
								//showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
							}
						});
					}
					}
					}
									/*var messageTemplate = record.get('msgContent');
					var $this = this;
					if (e.target.tagName == 'A') {
						var win = new Ext.Window({
							title: getMessagingModuleTranslation('MESSAGE_CONTENT'),
							frame: true,
							height: 500,
							minWidth: 200,
							autoScroll: true,
							modal: true,
							html: messageTemplate,
						});
						win.show();
					}*/
				}
			},
            
            'enquirydetailform customcombobox#country': {
                select: function(obj, record) {
                	var form = obj.up('form');
      				form.down('#genericFieldId1').clearValue();
      				form.down('#genericFieldId1').setDisabled(false);
      				form.down('#city').clearValue();
      				form.down('#city').setDisabled(true);
      				var countryId = record[0].get("id");
      				if (countryId > 0) {
      					var store = form.down('#genericFieldId1').getStore();
      					store.getProxy().extraParams = {
      						cid: countryId
      					};
      					store.load();
      				}
      				form.getForm().checkValidity();
    			}
            },
            'enquirydetailform customcombobox#genericFieldId1':{
            	select:function(obj,rec){
            		var form = obj.up('form');
      				form.down('#city').clearValue();
      				form.down('#city').setDisabled(false);
      				var countryRegionId=rec[0].data.id;
      				var store = form.down('#city').getStore();
      				store.getProxy().extraParams = {
      					id: countryRegionId
      				};
      				store.load();
      				form.getForm().checkValidity();
    			}
            },
            'enquirydetailform customcombobox#referredType': {
                select: function(obj, record) {
                	var form=obj.up('form').getForm();
					var refUserNameField=form.findField('refUserName');
					refUserNameField.setVisible(false);
					refUserNameField.reset();
					refUserNameField.setDisabled(true);
                    var refrredNameField = Ext.getCmp('enqdetail_referrerName');
                    refrredNameField.reset();
                    refrredNameField.setVisible(false);
                    var refType = record[0].get("value");

                    if (refType != 'None') {
						if(refType == 'Corporate' || refType == 'Others'){
							refUserNameField.setVisible(true);
							refUserNameField.setDisabled(false);
						}else{
							refrredNameField.setVisible(true);
						}
					}
                    
                    var store = this.getStore('enquiry.ReferredIdStore');
                    store.getProxy().extraParams = {
  					  refTypeId:record[0].data.id
					  };
                }
            },

            /*added for appointment tab on enquiry detail*/

            'sgappointmentdetailstructure' :{
            	activate : function(tab, eOpts) {
            		var gridStore = Ext.getStore('sgappointment.sgappointment.SGAppointmentGridStore');
            		var grid = this.getSgappointmentdetailgrid().getStore();

            		var structFilter = this.getEnquirytabstructure().getForm();
            		var enqId=structFilter.findField("hiddenEnquiryId").getValue();
            		var academyLocationIdList= this.getUserAccessibleAL();

            		//loading store using store.load and removing extra params in callback
            		grid.getProxy().extraParams = {
            			enquiryId : enqId,
            			academyLocationIdList : academyLocationIdList.join()
 					};
            		grid.loadPage(1,{params:{
            			page: grid.currentPage,
            			limit: grid.pageSize,
            			start: ((grid.currentPage-1)*(grid.pageSize)),
            			enquiryId : enqId
            		},callback: function(record, operation, success) {
            			if (success) {
            				delete grid.getProxy().extraParams.page;
            				delete grid.getProxy().extraParams.limit;
            				delete grid.getProxy().extraParams.start;
            				delete grid.getProxy().extraParams.academyLocationIds;
            			}
            		}
            		});
            		this.resetPageSetting(gridStore);
            		/*grid.getProxy().extraParams = {
            			page: grid.currentPage,
            			limit: grid.pageSize,
            			start: ((grid.currentPage-1)*(grid.pageSize)),
            			enquiryId : enqId
 					};
            		grid.load({
                         callback: function(record, operation, success) {
                             if (success) {
                         			delete grid.getProxy().extraParams.page;
                         			delete grid.getProxy().extraParams.limit;
                         			delete grid.getProxy().extraParams.start;
                         			delete grid.getProxy().extraParams.academyLocationIds;
                             }
                         }
                     });*/
            		/*grid.load({params: {
            			page: grid.currentPage,
            			limit: grid.pageSize,
            			start: ((grid.currentPage-1)*(grid.pageSize)),
            			enquiryId : enqId
            		},callback:function(){
            			delete grid.getProxy().extraParams.page;
            			delete grid.getProxy().extraParams.limit;
            			delete grid.getProxy().extraParams.start;
            			delete grid.getProxy().extraParams.academyLocationIds;
            		}});*/
            	}            	
            },

            'sgappointmentdetailgrid button[itemId=btnDelete]':{
            	click: this.deleteSGAppointmentDetailRecord
            },
            'sgappointmentdetailgrid button[itemId=btnAdd]':{
            	click: function(){
            		this.addSGAppointmentDetailRecord('ADD');  
            		this.setEntrybyValuebydefault();
            		this.setVisitStatusByDefault();
            	}

            },
            'sgappointmentdetailgrid button[itemId=btnEdit]':{
            	click : function(obj, record) {
            		var $this=this;
            		var grid = $this.getSgappointmentdetailgrid();
            		if (grid.getSelectionModel().getCount() > 0) {
            			var record=grid.getSelectionModel().getSelection()[0];
            			if(!isNullOrEmpty(record.data.isRescheduleAppointment) && record.data.isRescheduleAppointment == true){
            				showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("RESCHEDULE_APPOINTMENT_CANT_BE_EDITED"));
            				return;
            			}else{
            				this.editAppointmentDetailRecord(obj, record);
            				var Form=this.getSgappointmentform();
            				Form.down('#viewCalendar').setDisabled(false); 
            			}
            		}
            	}
            },
 		   'sgappointmentform button[itemId=viewCalendar]':{
 			   click : this.openViewCalendarWin
 		   },
            'sgappointmentform[itemId=SGAppointmentEnquiryItemId] button[itemId=resetBtnForm]':{
            	click: function(){
            		var $this=this;
            		var form = $this.getSgappointmentform();
            		var visitTimeIdfield=form.getForm().findField('visitTime');
            		var expectedOutTimefield=form.getForm().findField('expectedOutTime');
            		visitTimeIdfield.setMaxValue(null);
            		visitTimeIdfield.setMinValue(null);
            		expectedOutTimefield.setMaxValue(null);
            		expectedOutTimefield.setMinValue(null);
            		this.resetSGAppointment(form);
            		this.setEntrybyValuebydefault();
            		this.setVisitStatusByDefault();
            		form.getForm().findField('bookingDate').setValue(new Date());
            		var userId=this.getCurrentlyLoggedInUser();
			    	var personToMeetId = form.down("#personToMeetId");
			    	personToMeetId.store.load({
			    		callback : function(operation,success) {
			    			if (success) {
			    				personToMeetId.setValue(userId.id);
			    			}
			    		} 
			    	});
            	}
   		 },
            'sgappointmentdetailgrid button[itemId=btnView]':{
            	click: this.viewSGAppointmentDetailRecord
            },
            'sgappointmentdetailgrid':{
            	render:function(grid){
            		this$ = this;
            		this$.doAccessControlValidation(grid, this$.getENQUIRY_MANAGE_APPOINTMENT_PERMISSIONS());
            		var commonForm = this.getEnquirytabstructure().getForm();
            		var commonVal = commonForm.getValues();
            		var buttonId = commonVal.buttonType;
            		if(buttonId == 'View'){
            			grid.down('#btnAdd').setVisible(false);
            			grid.down('#btnEdit').setVisible(false);
            			grid.down('#btnDelete').setVisible(false);
            		}
            	},
            	afterrender:function(grid){
            		var me = this;
            		me.addDataGridConfigButton(grid,me.getENQUIRY_MANAGE_APPOINTMENT_PERMISSIONS());
            	}
            },
			'sgappointmentform[itemId=SGAppointmentEnquiryItemId]': {
				render: function(obj) {
					var this$ = this;
					var sgForm = this.getSgappointmentform();
					var userId = this.getCurrentlyLoggedInUser();
					var personToMeetId = sgForm.down("#personToMeetId");
					personToMeetId.store.load({
						callback: function(operation, success) {
							if (success) {
								personToMeetId.setValue(userId.id);
							}
						}
					});
					var PersonToMeet = sgForm.getForm().findField('personToMeet').getValue();
					if (PersonToMeet == null) {
						var Form = this.getSgappointmentform();
						Form.down('#viewCalendar').setDisabled(true);
						Ext.defer(function() {
							sgForm.down("#documentUploadFile").setVisible(false);
							sgForm.down("#documentUploadFile").setDisabled(true);
						}, 1000);
					}

					var admissionReqDetails = this.getEnquirytabstructure().getForm().getValues();
					var enquiryStudentDetails = admissionReqDetails.setStudentDetailModel;
					var data = JSON.parse(enquiryStudentDetails);
					var enquiryStudentDetailId = data.id;
					var academyLocation = sgForm.down("#academyLocationId");
					academyLocation.getStore().getProxy().extraParams = {
						enquiryStudentDetailId: enquiryStudentDetailId,
						applicationId: null
					};
					academyLocation.getStore().load();
				}
			},
            'sgappointmentform[itemId=SGAppointmentEnquiryItemId] button[itemId=submitBtn]':{
            	click: this.saveEnquirySGAppointmentRecord
            },
            'communicationhistoryenquirystructure' :{
            	activate : function(tab, eOpts) {
            		var filterForm=this.getCommunicationhistoryfilter();
            		var structFilter = this.getEnquirytabstructure().getForm();
            		var emailId = filterForm.down("#emailId").getStore();
            		var enqId=structFilter.findField("hiddenEnquiryId").getValue();
            		emailId.getProxy().extraParams = {
            			enquiryId : enqId,
            			isEmail:true
            		};
            		emailId.load();
            		var mobileStore= filterForm.down('#mobileId').getStore();
            		mobileStore.getProxy().extraParams = {
            			enquiryId : enqId,
            			isEmail:false
            		};
            		mobileStore.load();
            	}            	
            },
            'sgappointmentform[itemId=SGAppointmentEnquiryItemId] customcombobox[itemId=personToMeetId]': {
            	change : function(){
            		var sgForm=this.getSgappointmentform();
 				   var PersonToMeet=sgForm.getForm().findField('personToMeet').getValue();
 				   
            		if(PersonToMeet!=null)
            		{
            			sgForm.down('#viewCalendar').setDisabled(false);
            		}else{
            			sgForm.down('#viewCalendar').setDisabled(true);
            		}            		
            	}
            },
            'sgappointmentform[itemId=SGAppointmentEnquiryItemId] customcombobox[itemId=viewStatusID]': {
            	select : function(obj, record){
            		var sgForm=this.getSgappointmentform();
            		var recVal = record[0].data.value;
            		var rescheduleAppointmentFld = sgForm.down('#rescheduleAppointmentFld');
            		var rescheduleAppointmentDateId = sgForm.down('#rescheduleAppointmentDateId');
            		var rescheduleAppointmentTimeId = sgForm.down('#rescheduleAppointmentTimeId');
            		var chkRescheduleAppointment = sgForm.down('#chkRescheduleAppointment');
            		if(recVal == "Rescheduled"){
            			rescheduleAppointmentFld.setVisible(true);
            			this.setAllowBlank(rescheduleAppointmentDateId,false);
            			rescheduleAppointmentDateId.reset();
            			chkRescheduleAppointment.setValue(true);
            		}
            		else{
            			rescheduleAppointmentFld.setVisible(false);
            			this.setAllowBlank(rescheduleAppointmentDateId,true);
            			rescheduleAppointmentDateId.reset();
            		}
            		rescheduleAppointmentTimeId.reset();
            		sgForm.getForm().checkValidity();
            	}
            },
            'sgappointmentform[itemId=SGAppointmentEnquiryItemId] checkboxfield[itemId=chkRescheduleAppointment]': {
            	change : function(cmp, currentValue, oldValue, eOpts){
            		var sgForm=this.getSgappointmentform();
            		var dateTimeRescheduleAppointmentItemId = sgForm.down('#dateTimeRescheduleAppointmentItemId');
            		var rescheduleAppointmentDateId = sgForm.down('#rescheduleAppointmentDateId');
            		var rescheduleAppointmentTimeId = sgForm.down('#rescheduleAppointmentTimeId');

            		if (currentValue == true) {
            			dateTimeRescheduleAppointmentItemId.setVisible(true);
            			this.setAllowBlank(rescheduleAppointmentDateId,false);
            			rescheduleAppointmentDateId.reset();
            		}
            		else{
            			dateTimeRescheduleAppointmentItemId.setVisible(false);
            			this.setAllowBlank(rescheduleAppointmentDateId,true);
            			rescheduleAppointmentDateId.reset();
            		}
            		rescheduleAppointmentTimeId.reset();
            		sgForm.getForm().checkValidity();
            	}
            },
     		 'sgappointmentform[itemId=SGAppointmentEnquiryItemId] combo#reasonForVisitID': {
    			 select: function(obj,record) {
    				 this.setExpectedOutTimeInEnquiry(obj,record);
    			 }
    		 },
      		 'sgappointmentform[itemId=SGAppointmentEnquiryItemId] timefield[itemId=visitTimeId]': {
    			 change: function(obj,record) {
    				 this.setExpectedOutTimeInEnquiry(obj,record);
    			 }
    		 },
    		 'sgappointmentform[itemId=SGAppointmentEnquiryItemId] datefield[itemId=appointmentId]': {
    			 change: function(obj,record) {
    				 var sgForm=this.getSgappointmentform();
    				 var isAppointeeItemId=sgForm.down("#isAppointeeItemId");
    				 var currentDate = Ext.Date.format(new Date() ,'Y-m-d');
    				 var appointmentDate = Ext.Date.format(record ,'Y-m-d');
    				 if(obj.itemId == 'appointmentId'){
    					 if(currentDate>appointmentDate){
    						 isAppointeeItemId.setValue({isAppointee:false});
    					 }else{
    						 isAppointeeItemId.setValue({isAppointee:true});
    					 }
    				 }
    			 }
    		 },
    		 'sgappointmentform[itemId=SGAppointmentEnquiryItemId] combo#reasonForVisitID' : {
  			   select : function(obj,record){
  				   var userGroupName = record[0].get("code");
	        		    this.enableOrDisableAdditionalReasonEnq(userGroupName);
  			   }
  		   },
			'sgappointmentform[itemId=SGAppointmentEnquiryItemId] customcombobox#academyLocationId': {
				select: function(obj, record) {
					var this$ = this;
					var programComboField = obj.up('form').down('#programId');
					var academyLocationField = obj.up('form').down('#academyLocationId');
					var batchCombo = obj.up("form").down("#batchId");
					var seatCombo = obj.up('form').down('#seatTypeId');
					var alValue = academyLocationField.getValue();
					programComboField.reset();
					programComboField.setDisabled(false);
					batchCombo.reset();
					batchCombo.setDisabled(true);
					batchCombo.allowBlank = true;
					seatCombo.reset();
					seatCombo.setDisabled(true);
					seatCombo.allowBlank = true;

					var admissionReqDetails = this$.getEnquirytabstructure().getForm().getValues();
					var enquiryStudentDetails = admissionReqDetails.setStudentDetailModel;
					var data = JSON.parse(enquiryStudentDetails);
					var enquiryStudentDetailId = data.id;
					programComboField.getStore().getProxy().extraParams = {
						academyLocationId: alValue,
						enquiryStudentDetailId: enquiryStudentDetailId,
						applicationId: null
					}
					this$.loadDFRForManageAppointment(academyLocationField);
					programComboField.getStore().load();
				}
			},
			'sgappointmentform[itemId=SGAppointmentEnquiryItemId] customcombobox#programId': {
				select: function(obj, record) {
					var this$ = this;
					var programId = record[0].get("id");
					var batchCombo = obj.up('form').down('#batchId');
					var seatCombo = obj.up('form').down('#seatTypeId');
					batchCombo.reset();
					batchCombo.setDisabled(false);
					seatCombo.reset();
					seatCombo.setDisabled(true);
					seatCombo.allowBlank = true;
					var academyLocationId = obj.up('form').down("#academyLocationId");
					this$.loadDFRForManageAppointment(academyLocationId);

					var admissionReqDetails = this$.getEnquirytabstructure().getForm().getValues();
					var enquiryStudentDetails = admissionReqDetails.setStudentDetailModel;
					var data = JSON.parse(enquiryStudentDetails);
					var enquiryStudentDetailId = data.id;
					batchCombo.getStore().getProxy().extraParams = {
						programId: programId,
						enquiryStudentDetailId: enquiryStudentDetailId,
						applicationId: null
					};
					batchCombo.getStore().load();
					obj.up('form').isValid();
				}
			},
			'sgappointmentform[itemId=SGAppointmentEnquiryItemId] customcombobox#batchId': {
				select: function(obj, record) {
					var this$ = this;
					var batchId = record[0].get("id");
					var seatCombo = obj.up('form').down('#seatTypeId');
					seatCombo.reset();
					seatCombo.setDisabled(false);
					var academyLocationId = obj.up('form').down("#academyLocationId");
					this$.loadDFRForManageAppointment(academyLocationId);

					var admissionReqDetails = this$.getEnquirytabstructure().getForm().getValues();
					var enquiryStudentDetails = admissionReqDetails.setStudentDetailModel;
					var data = JSON.parse(enquiryStudentDetails);
					var enquiryStudentDetailId = data.id;
					seatCombo.getStore().getProxy().extraParams = {
						batchId: batchId,
						enquiryStudentDetailId: enquiryStudentDetailId,
						applicationId: null
					};
					seatCombo.getStore().load();
					obj.up('form').isValid();
				}
			}
        });
        this.callParent(arguments);
    },
    saveEnquiryDetail: function(f) {

        var $this = this;
        var form = f.ownerCt.ownerCt.getForm();
        var val = form.getValues();
        var referId = val.referredType;
        var referredTypeName=form.findField('referredType').getRawValue();
        var referrerNameField=form.findField('referrerName');
        var structFilter = $this.getEnquirytabstructure().getForm();
        var enqDetail = new Academia.model.enquiry.enquiryDetail.EnquiryDetailModel();
        enqDetail.set("id", Ext.getCmp("enquiryDetail_id").getValue());
        enqDetail.set("code", Ext.ComponentQuery.query('textfield[itemId=enquiryTxtId]')[0].getValue());
        enqDetail.set("enquirySource", $this.getIdValueJson(Ext.getCmp("enquiryDetail_enquirySource").getValue()));
        enqDetail.set("registeredByType", Ext.getCmp("enquiryDetail_registeredByType").getValue());
        ///
        var id = Ext.getCmp("enquiryDetail_enquiryType").getValue()
        var store = Ext.getCmp("enquiryDetail_enquiryType").getStore();
        var passId = store.findRecord('id',id);
    	var enqType = id.data.code;
    	
        if (enqType == 'Corporate') {
            enqDetail.set("firstName", Ext.getCmp("enquiryDetail_companyName").getValue());
            enqDetail.set("middleName", Ext.getCmp("enquiryDetail_contactPerson").getValue());
            enqDetail.set("lastName", Ext.getCmp("enquiryDetail_totalSeats").getValue());
        } else {
            enqDetail.set("firstName", Ext.getCmp("enquiryDetail_firstName").getValue());
            enqDetail.set("middleName", Ext.getCmp("enquiryDetail_middleName").getValue());
            enqDetail.set("lastName", Ext.getCmp("enquiryDetail_lastName").getValue());
        }
        enqDetail.set("enquiryDate", Ext.getCmp("enquiryDetail_enquiryDate").getValue());
        enqDetail.set("remark", Ext.getCmp("enquiryDetail_remark").getValue());
        enqDetail.set("followUpDate", Ext.getCmp("enquiryDetail_followUpDate").getValue());
        enqDetail.set("campaign", $this.getIdValueJson(Ext.getCmp("enquiryDetail_campaign").getValue()));
        enqDetail.set("enquiryType", $this.getIdValueJson(Ext.getCmp("enquiryDetail_enquiryType").getValue()));
//        enqDetail.set("enquiryType", Ext.getCmp("enquiryDetail_enquiryType").getValue());
//        enqDetail.set("followUpUser", Ext.getCmp("enquiryDetail_followUpUser").getValue());
        enqDetail.set("followUpUser", $this.getIdValueJson(Ext.getCmp("enquiryDetail_followUpUser").getValue()));
        enqDetail.set("whetherDeleted", false);
        enqDetail.set("customData", val.customData);

        enqDetail.set("enquiryReferrerType", $this.getIdValueJson(referId));
       /* if (referId == 5) {
            enqDetail.set("refUserName", val.referrerName);
        }
        enqDetail.set("refEnquirer", $this.getIdValueJson(val.enquirerID));
        enqDetail.set("refUser", $this.getIdValueJson(val.referrerId));
*/
        if(referredTypeName == 'Others' || referredTypeName == 'Corporate'){
        	enqDetail.set("refUserName", val.refUserName);
		}else if(referredTypeName == 'Employee' || referredTypeName == 'Student' ||referredTypeName == 'External User'){
			enqDetail.set("refUser", $this.getIdValueJson(referrerNameField.getValue()));
		}else if(referredTypeName == 'Enquirer'){
			enqDetail.set("refEnquirer", $this.getIdValueJson(referrerNameField.getValue()));
		}

        enqDetail.set("enqIntermediateType", $this.getIdValueJson(val.enqIntermediateTypeId, val.enqIntermediateType));

        var user = {
            id: Ext.getCmp("enquiryDetail_userId").getValue(),
            value: Ext.getCmp("enquiryDetail_user").getValue()
        };

        enqDetail.set("user", user);

        var address = [];
        address.push({
            "id": Ext.getCmp("enquiryDetail_addressId").getValue(),
            "enquiry": $this.getIdValueJson(Ext.getCmp("enquiryDetail_id").getValue()),
            "address": {
                "id": Ext.getCmp("enquiryDetail_enquiryAddressId").getValue(),
                "country": $this.getIdValueJson(Ext.getCmp("enquiryDetail_country").getValue()),
//                "parentCountryRegion": $this.getIdValueJson(Ext.getCmp("enquiryDetail_parentCountryRegion").getValue()),
                "parentCountryRegion": $this.getIdValueJson(Ext.getCmp("genericFieldId1").getValue()),
                "countryRegion": $this.getIdValueJson(Ext.getCmp("enquiryDetail_countryRegion").getValue()),
                "city": $this.getIdValueJson(Ext.getCmp("enquiryDetail_city").getValue()),
                "cellCountryCode": Ext.getCmp("enquiryDetail_cellCountrycode").getValue(),
                "cellNo": Ext.getCmp("enquiryDetail_cellNumber").getValue(),
                "phoneCountryCode": Ext.getCmp("enquiryDetail_phoneCountryCode").getValue(),
                "phoneAreaCode": Ext.getCmp("enquiryDetail_areaCode").getValue(),
                "phoneNo": Ext.getCmp("enquiryDetail_regdPhoneNo").getValue(),
                "primaryeEmailId": Ext.getCmp("enquiryDetail_primaryeEmailId").getValue(),
                "version": Ext.getCmp("enquiryDetail_versionId").getValue()
            }
        });

        enqDetail.set("enquiryAddresses", address);
        var submitData = Ext.encode(enqDetail.data);

        var submitUrl = SERVERURL.ENQUIRY_DETAIL_UPDATE;
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        Ext.Ajax.request({
            url: submitUrl,
            jsonData: submitData,
            method: 'POST',
            success: function(response) {
            	/*var personController=  Academia.app.getController('Academia.controller.enquiry.TrackEnquiryController');
            	console.log('personController',personController);*/
//		        personController.loadEnquiryGrid;
            	
            	var grid=$this.getSearchresultgrid();
            	
//            	console.log('grid',grid);
            	grid.getStore().reload();
            	Ext.getBody().unmask();
            	//loadEnquiryGrid
                showSuccessMessage(getCommonTranslation('ENQUIRY_TITLE'), getCommonTranslation('SUCCESS'));
            }
        });
    },
    cancelEnquiryDetail: function() {
        var form = this.getEnquirydetailform().getForm();
        form.reset();
    },

    onFormRender: function(f) {

        var this$ = this;

        var tab = this.getEnquirytabstructure();
        var tabs = tab.items.items[1].items;
        var form = f.getForm();

        var commonForm = tab.getForm();
        var commonVal = commonForm.getValues();
        var enquiryId = commonVal.enqId;
        var enqType = commonVal.enqTypes;

        if(enqType!='Admission'){
        	  var studentStructure = Ext.widget('studentdetailstructure');
			  studentStructure.setDisabled(true);
        }	  
        
        var buttonId = commonVal.buttonType;
        if (buttonId == 'View') {
            f.down('#enquirydetail_SubmitButtonId').setVisible(false);
            f.down('#enquirydetail_EditButtonId').setVisible(false);
        }
        
        if (buttonId == 'Edit') {
        	var grid=this$.getSearchresultgrid();
        	if(grid==undefined) {
        		grid=this$.getEnquirygridsforpendingenquirydashboard().down('#trackEnquiryGridDashBoardItemId');
        	}
			var record=grid.getSelectionModel().getSelection()[0];
			//console.log('record...',record);
			var openclose;
			if(!isNullOrEmpty(record)){
				openclose = record.get('TRACK_ENQUIRY_STATUS');
			}
			if(openclose=='Closed'){
             f.down('#enquirydetail_SubmitButtonId').setVisible(false);
           // f.down('#enquirydetail_EditButtonId').setVisible(false);
			}
        }
        
        if (enquiryId > 0) {
            Ext.Ajax.request({
                method: 'GET',
                corsSupport: true,
                url: SERVERURL.ENQUIRY_DETAIL_FIND_BY_ID,
                params: {
                    id: enquiryId
                },
                success: function(response) {
                    if (response.responseText != null && response.responseText != "") {
                        var data = JSON.parse(response.responseText);
                        var enquiryDetail = new Academia.model.enquiry.enquiryDetail.EnquiryDetailModel(data);
                        var enquiryAddresses = data.enquiryAddresses;
                        form.loadRecord(enquiryDetail);

                        if (data.enqIntermediateType != null) {
                            form.findField("enqIntermediateTypeId").setValue(data.enqIntermediateType.id);
                            form.findField("enqIntermediateType").setValue(data.enqIntermediateType.value);
                        }
                        if (data.enquiryReferrerType != null) {
                        	
                        	var refUserNameField=form.findField('refUserName');
        					refUserNameField.setVisible(false);
        					refUserNameField.reset();
        					refUserNameField.setDisabled(true);
        					var refrredNameField = form.findField('referrerName');
        					refrredNameField.setVisible(false);
        					refrredNameField.reset();
        					refrredNameField.allowBlank = true;
        					
                            var refferTypeId = data.enquiryReferrerType.id;
                            var refType = data.enquiryReferrerType.value;
                            
                            if (refType != 'None') {
        						if(refType == 'Corporate' || refType == 'Others'){
        							refUserNameField.setVisible(true);
        							refUserNameField.setDisabled(false);
        						}else{
        							refrredNameField.setVisible(true);
        						}
        					} 
                            
                            if(refType == 'Others' || refType == 'Corporate'){
                				form.findField('refUserName').setValue(data.refUserName);
                			}/*else if(refType == 'Employee' || refType == 'Student' ||refType == 'External User'){
                				enquiryModel.set("refUser", $this.getIdValueJson(referrerNameField.getValue()));
                				
                			}else if(refType == 'Enquirer'){
                				enquiryModel.set("refEnquirer", $this.getIdValueJson(referrerNameField.getValue()));
                				
                			}*/
                            
                           /* if (refferTypeId == 5 || refferTypeId == 2) {
                                form.findField("referrerName").setValue(data.refUserName);
                            } else {
                                if (data.refUser != null) {
                                    form.findField("referrerName").setValue(data.refUser.value);
                                }
                            }
                            if(refferTypeId==7){
                            	 form.findField("referrerName").setVisible(false);
                            }*/
                            
                            
                            var store = this$.getStore('enquiry.ReferredTypeStore');
                            store.load({
                                callback: function(record, operation, success) {
                                    if (success) {
                                        form.findField("referredType").setValue(refferTypeId);
                                        //form.findField("enquirerID").setVisible(false);
                                    }
                                }
                            });
                        }
                        if (data.refUser != null || data.refEnquirer!=null) {

                            var refferTypeId = data.enquiryReferrerType.id;
                            var refNameId = null;
                            var name;
                            if (data.refUser != null) {
                                name = data.refUser.value;
                                refNameId=data.refUser.id;
                            } else {
                                name = data.refEnquirer.value;
                                refNameId=data.refEnquirer.id;
                            }
                            var store = this$.getStore('enquiry.ReferredIdStore');
                            store.load({
                                params: {
                                    refTypeId: refferTypeId,
                                    name: name
                                },
                                callback: function(record, operation, success) {
                                    if (success) {
                                    	
                                    	form.findField("referrerName").setValue(refNameId);
                                      /*  if (refferTypeId == 2) {
                                            form.findField("referrerId").setVisible(false);
                                            form.findField("enquirerID").setValue(refUserId);
                                        } else {
                                            //form.findField("referrerId").setValue(refUserId);
                                        }*/
                                    }
                                }
                            });
                        }

                        if (data.enquiryAddresses.length > 0) {

                            var addId = enquiryAddresses[0].id;
                            var address = enquiryAddresses[0].address;

                            form.findField("enquiryAddressId").setValue(address.id);
                            form.findField("addressId").setValue(addId);
                            form.findField("version").setValue(address.version);
                            var countryId;
                            if(!isNullOrEmpty(address.country)){
                            	countryId = address.country.id;
                            }else{
    							form.findField("parentCountryRegion").setDisabled(true);
        						form.findField("city").setDisabled(true);
    						}
                            var cityId;
                            if(!isNullOrEmpty(address.city)){
                            	 cityId = address.city.id;
                            }
                            var val = this$.findSettingValue('primaryeEmailId', enquiryAddresses);
                            if (val != null) {
                                form.findField("primaryeEmailId").setValue(val.primaryeEmailId);
                                form.findField("cellCountrycode").setValue(val.cellCountryCode);
                                form.findField("cellNo").setValue(val.cellNo);
                                form.findField("phoneCountryCode").setValue(val.phoneCountryCode);
                                form.findField("phoneAreaCode").setValue(val.phoneAreaCode);
                                form.findField("phoneNo").setValue(val.phoneNo);
                                if (address.parentCountryRegion != null) {
                                    form.findField("parentCountryRegionId").setValue(address.parentCountryRegion.id);
                                }
                                if (address.countryRegion != null) {
                                    form.findField("countryRegionId").setValue(address.countryRegion.id);
                                }
                            }
                            var countryStore = this$.getStore('common.CountryStore');
                            countryStore.load({
                                callback: function(record, operation, success) {
                                    if (success) {
                                        form.findField("country").setValue(countryId);
                                    }
                                }
                            });
                            
                            var countryRegionStore = this$.getStore('organization.CountryRegionStore');
                            countryRegionStore.getProxy().extraParams = {
                            	cid: countryId
        					};
                            countryRegionStore.load({
                                callback: function(record, operation, success) {
                                    if (success) {
                                    	if(!isNullOrEmpty(address.countryRegion)){
                                    	form.findField("parentCountryRegion").setValue(address.countryRegion.id);
                                    	}
                                    }
                                }
                            });
                            

//                            var cityStore = this$.getStore('organization.CityStore');
                            var cityStore = this$.getStore('organization.CityByCountryRegion');
                            if(!isNullOrEmpty(address.countryRegion)){
                            cityStore.getProxy().extraParams = {
                            	id: address.countryRegion.id
        					};
                            cityStore.load({
                                callback: function(record, operation, success) {
                                    if (success) {
                                    	if(!isNullOrEmpty(address.city)){
                                    	form.findField("city").setValue(address.city.id);
                                    	}
                                    }
                                }
                            });
                           }
                            var registeredByType = this$.getStore('enquiry.EnquiryRegisteredBy');
                            registeredByType.load({
                                callback: function(record, operation, success) {
                                    if (success) {
                                        form.findField("registeredByType").setValue(data.registeredByType);
                                    }
                                }
                            });
                        };

                        if (data.followUpUser != null) {
                            form.findField("followUpUser").setValue(data.followUpUser.id);
                        }
                        if (enquiryDetail.data.campaign != null) {
                            var campaignId = enquiryDetail.data.campaign.id;
                        }
                        var enquiryTypeId = enquiryDetail.data.enquiryType.id;
                        var enquiryTypeName = enquiryDetail.data.enquiryType.value;
                        var enquiryId = enquiryDetail.data.id;
                        if (enquiryTypeName == 'Corporate') {
                            f.down("#enquiryDetailNamePanel").setVisible(false);
                            f.down("#corporateEnqItemId").setVisible(true);
                            form.findField("companyName").setValue(data.firstName);
                            form.findField("contactPerson").setValue(data.middleName);
                            form.findField("totalSeats").setValue(data.lastName);
                        } else {
                            f.down("#enquiryDetailNamePanel").setVisible(true);
                            f.down("#corporateEnqItemId").setVisible(false);
                            form.findField("companyName").allowBlank = true;
                            form.findField("contactPerson").setValue(data.middleName);
                            form.findField("totalSeats").allowBlank = true;
                        }

                        var campaignStore = this$.getStore('campaign.CampaignComboStore');
                        campaignStore.clearFilter(true);
                        campaignStore.getProxy().extraParams={
                        	academyLocationId:this$.getCurrentAcademyLocation()
                        };
                        campaignStore.load({
                            callback: function(record, operation, success) {
                                if (success) {
                                    form.findField("campaign").setValue(campaignId);
                                    /**
                                     * make field readonly if campaign is deleted
                                     */
                                    if(record.length>0){
                                    Ext.Array.each(record,function(value){
                                    	if(value.data.id==campaignId){
                                    		if(!value.data.code){
                                    			form.findField("campaign").setReadOnly(true);
                                    		}
                                    	}
                                    });
                                  }
                                }
                            }
                        });

                        var enquiryStore = this$.getStore('enquiry.EnquiryTypeStore');
                        enquiryStore.load({
                            callback: function(record, operation, success) {
                                if (success) {
                                    form.findField("enquiryType").setValue(enquiryTypeId);
                                }
                            }
                        });
                        if(data.enquirySource){
                        var sourceEnquiryStore = this$.getStore('enquiry.EnquirySourceStore');
                        sourceEnquiryStore.load({
                            callback: function(record, operation, success) {
                                if (success) {
                                    form.findField("sourceCode").setValue(data.enquirySource.id);
                                }
                            }
                        });
                        }
                        form.findField("enquiryDate").setValue(dateRender(enquiryDetail.data.enquiryDate));
                        form.findField("user").setValue(enquiryDetail.data.user.value);
                        form.findField("userId").setValue(enquiryDetail.data.user.id);
                    }
                },
                failure: function() {
                    showErrorMessage(getCommonTranslation('ORGINFOTITLE'), getCommonTranslation('FAILURE'));
                }
            });
        }

       /* if (form) {
            toggleReadOnlyFormItems(form, true);
        }*/

        //f.down("#enquirydetail_CancelButtonId").disable();

    },
    findSettingValue: function(key, enquiryAddresses) {
        var retvalue = null;
        Ext.each(enquiryAddresses[0].address, function(rec) {
            retvalue = rec;
        });
        return retvalue;
    },
    getIdValueJson: function(id, value) {
        if (id) return {
            id: id,
            value: value
        };
    },
    openViewCalendarWin:function(){
    	var $this =this;
    	var contentpanel = this.getContentPanel();
    	var scheduledetails = Ext.widget('scheduledetails');
    	var tabName = getServiceRequestTranslation('VIEW_CALENDAR');
    	var personToMeetId = null;
    	var getcontroller=this.getController('menu.CoreERPNavigationController');
    	var getTab=getcontroller.getTab(tabName);
    	if(getTab!=null){
    		contentPanel.remove(getTab, true);
    	}
    	openTab(contentpanel, tabName, scheduledetails,contentpanel.activeTab.menuColorCls);	
    	var sgForm=$this.getSgappointmentform();
    	var id=sgForm.down("#id").getValue();
    	var appointmentDateId=sgForm.down("#appointmentId").getValue();
    	if(isNullOrEmpty(id)){
    		personToMeetId=sgForm.down("#personToMeetId").getStore().data.items[0].data.id;
    	}else{
    		var facultyName= sgForm.down("#personToMeetId").getRawValue();
    		var records=sgForm.down("#personToMeetId").getStore().data.items;
    		for(var i in sgForm.down("#personToMeetId").getStore().data.items){
    			if(records[i].data.valueCode==facultyName){
    				personToMeetId=records[i].data.id;
    			}
    		}
    	}
    	var personProfile = this.getContentPanelActiveTab();
    	var calendar = personProfile.down('#personViewCalendar');
    	var params = new Object();
    	calendar.eventStore.getProxy().actionMethods.read = 'GET';
    	params.facultyId = personToMeetId;
    	calendar.eventStore.removeAll();
    	calendar.eventStore.getProxy().url = SERVERURL.RESOURCE_BOOKING_GET_FACULTY_CALENDAR_DATA;
    	calendar.eventStore.getProxy().extraParams = params;
    	calendar.eventStore.load();
    },
    getContentPanelActiveTab: function() {
    	var this$ = this;
    	var personProfile = null;
    	var controller=this.getContentPanel();
    	if (contentPanel) {
    		personProfile = contentPanel.getActiveTab();
    	}
    	return personProfile;
    },
    getUserAccessibleAL:function(){
        var academyLocationId = [];
        var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
        for(var i=0; i<academyLocationList.length; i++){
        academyLocationId.push(academyLocationList[i].id);
        }
        return academyLocationId;
         },
    /*added for appointment tab on enquiry detail*/
    addSGAppointmentDetailRecord:function(openView, submitPortal){
    	var me = this;
    	var grid=me.getSearchresultgrid();
    	var eqId = Ext.ComponentQuery.query('enquirytabstructure')[0];
    	var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
    	var structure =  Ext.widget('sgappointmentform', {
    		itemId : 'SGAppointmentEnquiryItemId'
    	});
    	var tabName = getServiceRequestTranslation('SG_APPOINTMENT');
    	/**
    	 * This is to remove tab from content panel and open same tab again
    	 */
    	var getcontroller=this.getController('menu.CoreERPNavigationController');
    	var getTab=getcontroller.getTab(tabName);
    	if(getTab!=null){
    		contentPanel.remove(getTab, true);
    	}
    	openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_ONE);
    	
    	var visitorCategoryIDCombo =Ext.ComponentQuery.query("#visitorCategoryID")[0];
    	var visitorCategoryIDComboStore = visitorCategoryIDCombo.getStore();
    	visitorCategoryIDComboStore.load({
    		/*callback:function(operation,success) {
    			visitorCategoryIDCombo.setValue(3);
    			var sgForm=me.getSgappointmentform();
    			sgForm.down("#appointeeNameId").setVisible(false);
    			sgForm.down("#leadId").setVisible(true);
    		}*/
    		callback:function(record){
    			for(var i in record) {
    				if(record[i].data.id == 2) {    					
    					visitorCategoryIDCombo.setValue(record[i].data.id);
    					visitorCategoryIDCombo.resetOriginalValue();
    					visitorCategoryIDCombo.setReadOnly(true);
    					visitorCategoryIDCombo.setVisible(false);
    					var sgForm=me.getSgappointmentform();
    					sgForm.down("#flagRelatedRadio").setVisible(false);
    					var structFilter = me.getEnquirytabstructure().getForm();
						if (structFilter.getValues().enqTypes == 'Counselling' || structFilter.getValues().enqTypes == 'Corporate') {
							sgForm.down('#academyLocationId').setVisible(false);
							sgForm.down('#programId').setVisible(false);
							sgForm.down('#batchId').setVisible(false);
							sgForm.down('#seatTypeId').setVisible(false);
							sgForm.down('#academyLocationId').allowBlank = true;
							sgForm.down('#programId').allowBlank = true;
							sgForm.down('#batchId').allowBlank = true;
							sgForm.down('#seatTypeId').allowBlank = true;
						}
    					var portalId = me.getCurrentLoggedPortalId();
                		var enqId=structFilter.findField("hiddenEnquiryId").getValue();                		
                		var enqCode=structFilter.findField("enquiryTxtId").getValue();                
    	    			sgForm.down("#appointeeNameId").setVisible(false);
    	    			var enquiryCombo = sgForm.down("#leadId");
    	    			enquiryCombo.setVisible(true);
    	    			var bookingID = sgForm.down("#bookingId");
    	    			if(bookingID.readOnly != true){
    	                   me.setAllowBlank(bookingID,false);  
    	    	           me.setFieldPlaceHolder(bookingID,'');
    	                   bookingID.labelSeparator = '';
                           bookingID.setFieldLabel(getServiceRequestTranslation('BOOKING_ID')+':' +'<span class="required" style="color:red"> *</span>');
    	    			  }else{
    	    		       me.setAllowBlank(bookingID,true);
    	    		       me.setFieldPlaceHolder(bookingID,getCommonTranslation('ID_AUTOGENERATE'));
    	    		       bookingID.labelSeparator = '';
    	                   bookingID.setFieldLabel(getServiceRequestTranslation('BOOKING_ID')+':' +'<span class="required" style="color:red"> *</span>');
    	                }
                        //enquiryCombo.setValue(enqId);
    	    			var appointeeNameField=sgForm.down('#appointeeNameId');
    	    			var parentGuardian=sgForm.down("#appointeeNameParentId");
    	    			var leadNameField=sgForm.down("#leadId");
    	    			var studentNameField=sgForm.down('#studentItemId');
    	    			var facultyNameField=sgForm.down('#facAppointmentId');
    	    			var applicantConbo = sgForm.down('#applicantNameId');
    	    			studentNameField.setVisible(false);
    	    			facultyNameField.setVisible(false);
    	    			applicantConbo.setVisible(false);
    	    			var reasonForVisitID = sgForm.down("#reasonForVisitID");
    	    			var visitCatId = record[i].data.id;
    	    			var reasonForVisitStore=reasonForVisitID.getStore();
    	    			   reasonForVisitStore.getProxy().extraParams = {
    	    				  id : visitCatId,
    	    				 
    	    			  };
    	    			   reasonForVisitStore.load();
    	    			var appointeeEmailField = sgForm.down("#appointeeEmailItemId");
    	    			var mobileNoField = sgForm.down("#mobileNo");
    	    			var cellCountryCodeField = sgForm.down("#cellCountryCode");
    	    			appointeeEmailField.setReadOnly(true);
    	    			mobileNoField.setReadOnly(true);
    	    			cellCountryCodeField.setReadOnly(true);
    	    			var reasonForVisitIDComboStore = reasonForVisitID.getStore();
    	    			
    	    			reasonForVisitIDComboStore.load({
    	    				callback:function(record){
    	    					for(i in record){
    	    						if(reasonForVisitID.value==null){
    	    						if(record[i].data.code=='Book A Tour'){
    	    							reasonForVisitID.setValue(record[i].data.id);
        	    						reasonForVisitID.resetOriginalValue(); 
    	    						}
    	    						}
    	    					}
    	    				}
    	    			});
    	    			
    	    			appointeeNameField.allowBlank = true;
    	    			parentGuardian.allowBlank = true;
    	    			studentNameField.allowBlank = true;
    	    			facultyNameField.allowBlank = true;
    	    			applicantConbo.allowBlank = true;
    	    			
    	    			if(openView == 'ADD'){
    	    				var submitPortalData = sgForm.down("#submitPortalId")
    	    				submitPortalData.setValue(portalId);
    	    				submitPortalData.resetOriginalValue();
    	    			}
    	    			
    	    			var primaryEmail = Ext.getCmp("enquiryDetail_primaryeEmailId").getValue();
    	    			var mobileNo = Ext.getCmp("enquiryDetail_cellNumber").getValue()
    	    			var countryCode = Ext.getCmp("enquiryDetail_cellCountrycode").getValue()
    	    			
    	    			appointeeEmailField.setValue(primaryEmail);
    	    			mobileNoField.setValue(mobileNo);
    	    			appointeeEmailField.resetOriginalValue();
    	    			mobileNoField.resetOriginalValue();
    	    			
    	    			var locations = [];
    	    			var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
    	    			for(var i=0; i<academyLocationList.length; i++){
    	    				locations.push(academyLocationList[i].id);
    	    			}

    	    			var leadStore = leadNameField.getStore();
    	    			leadNameField.setReadOnly(true);
    	    			leadStore.getProxy().extraParams = {
    	    				academyLocationIds:locations.join(),	//me.getCurrentAcademyLocation(),
    	    				codeOrName: enqCode,
    	    				enquiryId:enqId
    	    			};
    	    			leadStore.load({
    	    				callback:function(record){
    	    					for(var i in record){
    	    						if(record[i].data.id == enqId){
        	    						leadNameField.setValue(record[i].data.id);
        	    						leadNameField.resetOriginalValue();
        	    						break;
        	    					}
    	    					}    	    					
    	    				}

    	    			});
    	    			cellCountryCodeField.getStore().load({
  						   callback:function(record){
  							   for(var i in record){
  								   if(record[i].data.isdCode == countryCode){
  									   cellCountryCodeField.setValue(record[i].data.isdCode);
  									   cellCountryCodeField.resetOriginalValue();
  									   break;
  								   }
  							   }    	    					
  						   }

  					   });
    	    			var newMandatoryFields = ['leadId'];
    	    			
    	    			var stageId = Ext.getCmp('enqtab_intermediateStageId').getValue();
    	    			var enqIntermediateStage = sgForm.down("#enqIntermediateStage");
    	    	 		   // var enqIntermediateStage = sgForm.getForm().findField('enqIntermediateStage');
    	    	 		   if (stageId != null) {
    	    	 			   enqIntermediateStage.store.load({
    	    	 				   callback: function(records, operation, success) {
    	    	 					   if (success) {
    	    	 						   enqIntermediateStage.setValue(parseInt(stageId));
    	    	 					   }
    	    	 				   }
    	    	 			   });
    	    	 		   }
                     	
                        Ext.Ajax.request({
	                		url: SERVERURL.COMMON_FORM_FIELD_INFO,
	                		method: 'GET',
	                		async: false,
	                		params: {
	                			academyLocationId:me.getCurrentAcademyLocation(),
	                			languageCode:'en'
	                		},
	                		success: function(response) {
	                			var json = JSON.parse(response.responseText);
	                			var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
	                			fieldInfo.set("formFieldsInfo", json);
	                			var academyLocationId = sgForm.down("#academyLocationId");
	                			var programId = sgForm.down("#programId");
	                			var batchId = sgForm.down("#batchId");
	                			var seatTypeId = sgForm.down("#seatTypeId");
	                			if( !isNullOrEmpty(json) ){
	                				if( !isNullOrEmpty(json.sgappointmentform) ){
	                					var sgappointmentformDFRConfig = json.sgappointmentform;
	                					for( i in sgappointmentformDFRConfig){
	                						var fieldConfig = sgappointmentformDFRConfig[i];
	                						if( newMandatoryFields.includes(fieldConfig.formFieldId) ){
	                							if( fieldConfig.isVisible ){
	                								var currentField = sgForm.down("#"+fieldConfig.formFieldId);
	                								currentField.setVisible(true);
	                							}else{
	                								var currentField = sgForm.down("#"+fieldConfig.formFieldId);
	                								currentField.setVisible(false);
	                							}
	                						}
	                					}
	                				}else{
	                					academyLocationId.setVisible(false);
                                    	academyLocationId.reset();
                                    	programId.setVisible(false);
                                    	programId.reset();
                                    	batchId.setVisible(false);
                                    	batchId.reset();
                                    	seatTypeId.setVisible(false);
                                    	seatTypeId.reset();
	                				}
	                			}
	                		}
	                	});
    	    			
    				};
    				
    			}
    		}
    	})
    },
    
    loadDFRForManageAppointment: function(academyLocationId) {
        var $this = this;
        var form = $this.getSgappointmentform();
        var academyLocationId = form.down("#academyLocationId");
		var programId = form.down("#programId");
		var batchId = form.down("#batchId");
		var seatTypeId = form.down("#seatTypeId");

        Ext.Ajax.request({
            type: 'rest',
            async: false,
            url: SERVERURL.COMMON_FORM_FIELD_INFO,
            params: {
                screenName: 'sgappointmentform',
                academyLocationId: this.getCurrentAcademyLocation(),
                languageCode: 'en'
            },
            method: 'GET',
            success: function(res, action) {
                var response = Ext.decode(res.responseText);
                if (Object.keys(response).length > 0) {
                    var records = response.sgappointmentform;
                    for (i in records) {
                        var fieldConfig = records[i];
                        
                          if (fieldConfig.formFieldInputType == 'customcombobox' && fieldConfig.formFieldId == 'academyLocationId') {
                            if (fieldConfig.isMandatory) {
                            	academyLocationId.allowBlank = false;
                            }else{
                            	academyLocationId.allowBlank = true;
                            }
                            if (fieldConfig.isVisible) {
                            	academyLocationId.setVisible(true);
                            }else{
                            	academyLocationId.setVisible(false);
                            	academyLocationId.reset();
                            	programId.setVisible(false);
                            	programId.reset();
                            	batchId.setVisible(false);
                            	batchId.reset();
                            	seatTypeId.setVisible(false);
                            	seatTypeId.reset();
                            }
                           }
                            if (fieldConfig.formFieldInputType == 'customcombobox' && fieldConfig.formFieldId == 'programId') {
                                if (fieldConfig.isMandatory) {
                                	programId.allowBlank = false;
                                }else{
                                	programId.allowBlank = true;
                                }
                                if (fieldConfig.isVisible) {
                                	programId.setVisible(true);
                                }else{
                                	programId.setVisible(false);
                                	programId.reset();
                                	batchId.setVisible(false);
                                	batchId.reset();
                                	seatTypeId.setVisible(false);
                                	seatTypeId.reset();
                                }
                            }
                         	if (fieldConfig.formFieldInputType == 'customcombobox' && fieldConfig.formFieldId == 'batchId') {
                                if (fieldConfig.isMandatory) {
                                	batchId.allowBlank = false;
                                }else{
                                	batchId.allowBlank = true;
                                }
                                if (fieldConfig.isVisible) {
                                	batchId.setVisible(true);
                                }else{
                                	batchId.setVisible(false);
                                	batchId.reset();
                                	seatTypeId.setVisible(false);
                                	seatTypeId.reset();
                                }
                            }
                         	if (fieldConfig.formFieldInputType == 'customcombobox' && fieldConfig.formFieldId == 'seatTypeId') {
                                if (fieldConfig.isMandatory) {
                                	seatTypeId.allowBlank = false;
                                }else{
                                	seatTypeId.allowBlank = true;
                                }
                                if (fieldConfig.isVisible) {
                                	seatTypeId.setVisible(true);
                                }else{
                                	seatTypeId.setVisible(false);
                                	seatTypeId.reset();
                                }
                            }
                    }
                }
            }
        });
    },
    enableOrDisableAdditionalReasonEnq:function(userGroupName) {
       	
 	   var form = this.getActiveTabfromContentPanel().down('sgappointmentform');
 	   
    	if(userGroupName == 'Other'){
	    	
	    	form.down('#additionalReasonToVisitItemId').setDisabled(false);
	    	form.down('#additionalReasonToVisitItemId').allowBlank = false;
	    } 
    	else{ form.down('#additionalReasonToVisitItemId').setDisabled(true);
    	form.down('#additionalReasonToVisitItemId').allowBlank = true;
    	form.down('#additionalReasonToVisitItemId').reset();
    	}
    		
    	
    	var valid = form.isValid();
    	if(!valid) {
    		form.down('#submitBtn').setDisabled(true);
    	}
    },

    editAppointmentDetailRecord:function(){

    	var $this=this;
    	var grid = $this.getSgappointmentdetailgrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		this.addSGAppointmentDetailRecord('EDIT');
    		var record=grid.getSelectionModel().getSelection()[0];
    		var sgForm=this.getSgappointmentform();
    		var dataModel=new Academia.model.sgappointment.sgappointment.SGAppointmentModel(record.data);
    		sgForm.loadRecord(dataModel);

    		sgForm.down("#visitTimeId").setValue(timeRender(record.data.visitTime));
    		sgForm.down("#outTimeId").setValue(timeRender(record.data.expectedOutTime));
    		sgForm.down("#bookingDateId").setValue(dateRender(record.data.bookingDate));
    		sgForm.down("#appointmentId").setValue(dateRender(record.data.appointmentDate));
    		sgForm.down("#bookingId").setReadOnly(true);
    		
    		var isAppointeeItemId =  sgForm.down("#isAppointeeItemId");
    		isAppointeeItemId.setValue({isAppointee:record.data.isAppointeeAppointment});
    		
    		var visitorCategory=sgForm.down("#visitorCategoryID");
    		if(record.data.visitorCategory != null){
    			visitorCategory.store.load({
    				callback : function(records,operation,success) {
    					if (success) {
    						visitorCategory.setValue(record.data.visitorCategory.id);
    					}
    				}
    			});
    		}
			var academyLocationId = sgForm.down("#academyLocationId");
			var programId = sgForm.down("#programId");
			var batchId = sgForm.down("#batchId");
			var seatTypeId = sgForm.down("#seatTypeId");
			var admissionReqDetails = $this.getEnquirytabstructure().getForm().getValues();
			var enquiryStudentDetails = admissionReqDetails.setStudentDetailModel;
			var data = JSON.parse(enquiryStudentDetails);
			var enquiryStudentDetailId = data.id;

			academyLocationId.getStore().getProxy().extraParams = {
				enquiryStudentDetailId: enquiryStudentDetailId,
				applicationId: null
			}
			if (record.data.academyLocation != null) {
				programId.setDisabled(false);
				academyLocationId.store.load({
					callback: function(records, operation, success) {
						var matchedId = null;
						for (var i in records) {
							if (records[i].data.id == record.data.academyLocation.id) {
								matchedId = records[i].data.id;
								break;
							}
						}
						if (matchedId != null) {
							academyLocationId.setValue(records[i].data.id);
						} else {
							academyLocationId.setValue(null);
							programId.setDisabled(true);
							programId.allowBlank = true;
							batchId.setDisabled(true);
							batchId.allowBlank = true;
							seatTypeId.setDisabled(true);
							seatTypeId.allowBlank = true;
						}
					}
				});

				programId.getStore().getProxy().extraParams = {
					academyLocationId: record.data.academyLocation.id,
					enquiryStudentDetailId: enquiryStudentDetailId,
					applicationId: null
				}
				if (record.data.program != null) {
					batchId.setDisabled(false);
					programId.getStore().load({
						callback: function(records, operation, success) {
							var matchedId = null;
							for (var i in records) {
								if (records[i].data.id == record.data.program.id) {
									matchedId = records[i].data.id;
									break;
								}
							}
							if (matchedId != null) {
								programId.setValue(records[i].data.id);
							} else {
								programId.setValue(null);
								batchId.setDisabled(true);
								batchId.allowBlank = true;
								seatTypeId.setDisabled(true);
								seatTypeId.allowBlank = true;
							}
						}
					});

					batchId.getStore().getProxy().extraParams = {
						programId: record.data.program.id,
						enquiryStudentDetailId: enquiryStudentDetailId,
						applicationId: null
					}
					if (record.data.batch != null) {
						seatTypeId.setDisabled(false);
						batchId.getStore().load({
							callback: function(records, operation, success) {
								var matchedId = null;
								for (var i in records) {
									if (records[i].data.id == record.data.batch.id) {
										matchedId = records[i].data.id;
										break;
									}
								}
								if (matchedId != null) {
									batchId.setValue(records[i].data.id);
								} else {
									batchId.setValue(null);
									seatTypeId.setDisabled(true);
									seatTypeId.allowBlank = true;
								}
							}
						});
						seatTypeId.getStore().getProxy().extraParams = {
							batchId: record.data.batch.id,
							enquiryStudentDetailId: enquiryStudentDetailId,
							applicationId: null
						}
						if (record.data.progBatchSeatConfig != null) {
							seatTypeId.getStore().load({
								callback: function(records, operation, success) {
									var matchedId = null;
									for (var i in records) {
										if (records[i].data.id == record.data.progBatchSeatConfig.id) {
											matchedId = records[i].data.id;
											break;
										}
									}
									if (matchedId != null) {
										seatTypeId.setValue(records[i].data.id);
									} else {
										seatTypeId.setValue(null);
									}
								}
							});
						}
					} else {
						seatTypeId.setDisabled(true);
						seatTypeId.allowBlank = true;
					}
				} else {
					batchId.setDisabled(true);
					batchId.allowBlank = true;
					seatTypeId.setDisabled(true);
					seatTypeId.allowBlank = true;
				}
			} else {
				programId.setDisabled(true);
				programId.allowBlank = true;
				batchId.setDisabled(true);
				batchId.allowBlank = true;
				seatTypeId.setDisabled(true);
				seatTypeId.allowBlank = true;
			}
			
    		var entryByField = sgForm.down("#entryById");
    		//entryByField.setReadOnly(true);
    		if(record.data.entryBy != null){
    			entryByField.store.getProxy().extraParam = {
    				academyLocationIds:this.getCurrentAcademyLocation()
    			}
    			entryByField.store.load({
    				callback : function(records,operation,success) {
    					if (success) {
    						entryByField.setValue(record.data.entryBy.id);
    					}
    				}
    			});
    		}
    		var personToMeetId = sgForm.down("#personToMeetId");
    		if(record.data.personToMeet != null){
    			personToMeetId.store.getProxy().extraParam = {
    				academyLocationIds:this.getCurrentAcademyLocation()
    			}
    			personToMeetId.store.load({
    				callback : function(records,operation,success) {
    					if (success) {
    						
    						/* for(var i in sgForm.down("#personToMeetId").getStore().data.items){
            					 if(records[i].data.valueCode==facultyName){
            						 personToMeetId=records[i].data.id;
            					 }
        					 }*/
    						
    						
							for(i in records){
								if(records[i].data.valueCode == record.data.personToMeet){
								personToMeetId.setValue(records[i].data.id);
							}
						}
    					//	personToMeetId.setRawValue(record.data.personToMeet);
    					}
    				}
    			});
    		}
    		var appointeeNameField=sgForm.getForm().findField('appointeeName');

    		var leadNameField=sgForm.down("#leadId");
    		var parentGuardian=sgForm.down("#appointeeNameParentId");
    		if(record.data.visitorCategory.id == 1){
    			parentGuardian.store.load({
    				callback : function(records,operation,success) {
    					if (success) {
    						parentGuardian.setValue(record.data.person.id);
    					}
    				}
    			});
    			parentGuardian.setVisible(true);
    			appointeeNameField.setVisible(false);
    			appointeeNameField.allowBlank = true;

    			leadNameField.setVisible(false);
    			leadNameField.allowBlank = true;
    			visitorCategory.setReadOnly(false);
    		}else if(record.data.visitorCategory.id == 2){
    			leadNameField.store.load({
    				callback : function(records,operation,success) {
    					if (success) {
    						leadNameField.setValue(record.data.enquiry.id);
    					}
    				}
    			});
    			leadNameField.setVisible(true);
    			leadNameField.setReadOnly(true);
    			appointeeNameField.setVisible(false);
    			appointeeNameField.allowBlank = true;
    			parentGuardian.setVisible(false);
    			parentGuardian.allowBlank = true;

    			visitorCategory.setReadOnly(true);
    		}else{
    			parentGuardian.allowBlank = true;
    			leadNameField.allowBlank = true;
    			visitorCategory.setReadOnly(false);
    		}


    		var mobileField = sgForm.down("#mobileNo");
    		var countryCodeField=sgForm.down("#cellCountryCode");
    		var str=record.data.appointeeContactNo;
    		var spiltMobileNo;
    		if(str!=null){
    			spiltMobileNo =str.split("-");
    		}
    		if(record.data.appointeeContactNo != null){
    			if(spiltMobileNo.length == 2){
    				countryCodeField.setValue(spiltMobileNo[0]);
    				mobileField.setValue(spiltMobileNo[1]);
    			}

    		}
    		
    		 /*added for visit status and reason to visit*/
 		   var visitStatusCombo=sgForm.down("#viewStatusID");
 		   var reasonForVisitCombo=sgForm.down("#reasonForVisitID");

 		   if(record.data.sgReasonForVisit != null){
 			  var userGroupName = record.data.sgReasonForVisit.code;
     		    this.enableOrDisableAdditionalReasonEnq(userGroupName);
 			   reasonForVisitCombo.store.load({
 				   callback : function(records,operation,success) {
 					   if (success) {
 						   reasonForVisitCombo.setValue(record.data.sgReasonForVisit.id);
 					   }
 				   }
 			   });
 		   }

 		   if(record.data.sgVisitStatus != null){
 			   visitStatusCombo.store.load({
 				   callback : function(records,operation,success) {
 					   if (success) {
 						   visitStatusCombo.setValue(record.data.sgVisitStatus.id);
 					   }
 				   }
 			   });
 		   }
 		   sgForm.down('#resetBtnForm').setVisible(false);
 		   
 		   var rescheduleAppointmentDateId = sgForm.down('#rescheduleAppointmentDateId');
 		   var rescheduleAppointmentTimeId = sgForm.down('#rescheduleAppointmentTimeId');
 		   this.setAllowBlank(rescheduleAppointmentDateId,true);
 		   if(!isNullOrEmpty(record.data.sgVisitStatus) && record.data.sgVisitStatus.code == "Completed"){
 			   sgForm.down('#submitBtn').setVisible(false);
 			   //var viewStatusID = sgForm.down('#viewStatusID');
 			   sgForm = sgForm.getForm();
 			   //viewStatusID.setReadOnly(true);
 			   toggleReadOnlyFormItems(sgForm, true);
 		   }
 		   else if(!isNullOrEmpty(record.data.sgVisitStatus) && record.data.sgVisitStatus.code == "Rescheduled"){
 			   var dateTimeRescheduleAppointmentItemId = sgForm.down('#dateTimeRescheduleAppointmentItemId');
 			   var rescheduleAppointmentFld = sgForm.down('#rescheduleAppointmentFld');
 			   if(!isNullOrEmpty(record.data.isRescheduleAppointment) && record.data.isRescheduleAppointment){
 				   dateTimeRescheduleAppointmentItemId.setVisible(true);
 				   var rescheduleAppointmentDateId = sgForm.down('#rescheduleAppointmentDateId');
 				   rescheduleAppointmentDateId.setValue(dateRender(record.data.rescheduleDate));
 				   if(!isNullOrEmpty(record.data.rescheduleTime)){
 					   sgForm.down("#rescheduleAppointmentTimeId").setValue(timeRender(record.data.rescheduleTime));
 				   }
 			   }
 			   else{
 				   dateTimeRescheduleAppointmentItemId.setVisible(false);
 				   rescheduleAppointmentDateId.reset();
 				   rescheduleAppointmentTimeId.reset();
 			   }
 			   rescheduleAppointmentFld.setVisible(true);
 		   }
 		   else{
 			   rescheduleAppointmentDateId.reset();
 			   rescheduleAppointmentTimeId.reset();
 		   }
 		   
 		   var enqIntermediateStage = sgForm.down("#enqIntermediateStage");
 		   // var enqIntermediateStage = sgForm.getForm().findField('enqIntermediateStage');
 		   if (record.data.enqIntermediateType != null) {
 			   enqIntermediateStage.store.load({
 				   callback: function(records, operation, success) {
 					   if (success) {
 						   enqIntermediateStage.setValue(record.data.enqIntermediateType.id);
 					   }
 				   }
 			   });
 		   }
 		   
    	}else {
    		showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_RECORD"));
    	}
    },

    viewSGAppointmentDetailRecord:function(){
    	this.editAppointmentDetailRecord();
    	var sgForm=this.getSgappointmentform();
    	sgForm.down('#submitBtn').setVisible(false);
    	sgForm.down('#resetBtnForm').setVisible(false);
    	sgForm = sgForm.getForm();
    	toggleReadOnlyFormItems(sgForm, true);


    },

    deleteSGAppointmentDetailRecord:function(){
    	var $this=this;
    	var grid = $this.getSgappointmentdetailgrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		showConfirmMessage(getServiceRequestTranslation('SG_APPOINTMENT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
    			if (btn == 'yes') {
    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    				var records = grid.getSelectionModel().getSelection();
    				var id = records[0].get("id");
    				Ext.Ajax.request({
    					method : "DELETE",
    					type : 'rest',
    					url : SERVERURL.SG_APPOINTMENT_DELETE+'?id='+ id,
    					headers : {
    						'Content-Type' : 'application/json'
    					},
    					success : function(form,action) {
    						Ext.getBody().unmask();
    						showSuccessMessage(getServiceRequestTranslation('SG_APPOINTMENT'), getServiceRequestTranslation('SG_APPOINTMENT_DELETE_SUCCESS_MSG'));
    						$this.resetPageSetting(store);
    						grid.getStore().reload();
    					}

    				});
    			}
    		});
    	}else {
    		showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_RECORD"));
    	}
    },
    
    saveEnquirySGAppointmentRecord: function(){
 	   var $this = this;
 	   var sgForm=$this.getSgappointmentform();
 	   var parentStore=sgForm.down("#appointeeNameParentId").getStore();
 	   var academyLocationId = sgForm.down("#academyLocationId");
	   var programId = sgForm.down("#programId");
	   var batchId = sgForm.down("#batchId");
	   var seatTypeId = sgForm.down("#seatTypeId");
	   if(!academyLocationId.isVisible()){
		   academyLocationId.reset();
	   }
	   if(!programId.isVisible()){
		   programId.reset();
	   }
	   if(!batchId.isVisible()){
		   batchId.reset();
	   }
	   if(!seatTypeId.isVisible()){
		   seatTypeId.reset();
	   }
 	   var sgFormValues=sgForm.getValues();
 	   var submitUrl,isUpdate = false;
 	   var contentPanel = $this.getContentPanel();
 	   var tabName = getServiceRequestTranslation('SG_APPOINTMENT');
 	   var sgDetailGrid = $this.getSgappointmentdetailgrid();
 	   var getcontroller=$this.getController('menu.CoreERPNavigationController');
 	   var portalId = $this.getCurrentLoggedPortalId();
 	   var submitPortalData = sgForm.down("#submitPortalId").getValue();
 	   var getTab=getcontroller.getTab(tabName);
 	   if (isNullOrEmpty(sgFormValues.id)) {
 		   submitUrl = SERVERURL.SG_APPOINTMENT_SAVE;
 		   isUpdate = false;
 	   } else {
 		   submitUrl =SERVERURL.SG_APPOINTMENT_UPDATE;
 		   isUpdate = true;
 	   }
 	   var visitorCategory={
 			   id:sgFormValues.visitorCategory
 	   };
 	   var appointeeName;
 	   var personToMeetId=sgForm.getForm().findField('personToMeet').getValue();
 	   if(sgFormValues.visitorCategory==1){
 		   var str=sgForm.down('#appointeeNameParentId').getRawValue();
			   var appointee=str.split("-");
			   appointeeName=appointee[0];
 	   }else if(sgFormValues.visitorCategory==2){                        		   
 		   var str=sgForm.down('#leadId').getRawValue();
 		   appointeeName=str;
 	   }else if (sgFormValues.visitorCategory == 3) {
            var str = sgForm.down('#studentItemId').getRawValue();
            appointeeName = str;
        }else if(sgFormValues.visitorCategory==4){                        		   
 		   var str=sgForm.down('#facAppointmentId').getRawValue();
 		   appointeeName=str;
 	   }else{
 		   appointeeName=sgFormValues.appointeeName;	                        		  
 	   }
 	   var personId={
 			   id:sgFormValues.appointeeNameParent	   
 	   };
 	   var enquiryId={
 			   id:sgFormValues.leadId	   
 	   };
 	   var visitStatusId={
 			   id:sgFormValues.viewStatusID	   
 	   };
 	   var reasonForVisitId={
 			   id:sgFormValues.reasonForVisitID 
 	   };
 	   var student = {
 			   id : sgFormValues.studentId
 	   };
 	   var staff={
 			   id:sgFormValues.facAppointmentId	   
 	   };
 	   var personToMeetId={
			   id:personToMeetId  
	   };
 	   var academyLocationId={
			   id: !isNullOrEmpty(sgFormValues.academyLocation) ? sgFormValues.academyLocation : $this.getCurrentAcademyLocation()  
	   };
 	   var programId={
			   id:sgFormValues.program	   
	   };
 	   var batchId={
			   id:sgFormValues.batch   
	   };
 	   var seatTypeId={
			   id:sgFormValues.seatType	   
	   };
 	   var appointmentFormData=new Academia.model.sgappointment.sgappointment.SGAppointmentModel();
 	   var chkRescheduleAppointment = sgForm.getForm().findField('isRescheduleAppointment');
 	   if(chkRescheduleAppointment.getValue()){
 		   appointmentFormData.set("isRescheduleAppointment",chkRescheduleAppointment.getValue());
 		   appointmentFormData.set("rescheduleDate",sgFormValues.rescheduleDate);
 		   if(!isNullOrEmpty(sgFormValues.rescheduleTime)){
 			   appointmentFormData.set("rescheduleTime",sgFormValues.rescheduleTime); 
 		   }else{
 			   delete appointmentFormData.data.rescheduleTime;
 		   }
 	   }
 	   appointmentFormData.set("id",sgFormValues.id);
 	   appointmentFormData.set("visitorCategory",visitorCategory);
 	   appointmentFormData.set("bookingId",sgFormValues.bookingId);
 	   appointmentFormData.set("appointeeName",appointeeName);
 	   appointmentFormData.set("personToMeetId",personToMeetId);
 	   appointmentFormData.set("isAppointeeAppointment",sgFormValues.isAppointee);
 	   appointmentFormData.set("program",programId);
 	   appointmentFormData.set("batch",batchId);
 	   appointmentFormData.set("progBatchSeatConfig",seatTypeId);
 	   appointmentFormData.set("academyLocation",academyLocationId);
 	   
 	   var enquiryStageId = null;
 	   var enquiryStageRawValue = null;
 	   
 	   var enqIntermediateStage = sgForm.getForm().findField('enqIntermediateStage');
 	   if( !isNullOrEmpty(enqIntermediateStage.getValue()) ){
 		   var enqIntermediateStageJsonObj = {
 				   id:enqIntermediateStage.getValue()  
 		   };
 		   enquiryStageId = enqIntermediateStage.getValue();
 		   enquiryStageRawValue = enqIntermediateStage.getRawValue();
 		   appointmentFormData.set("enqIntermediateType",enqIntermediateStageJsonObj);
 	   }
 	   delete appointmentFormData.data.enqIntermediateStage;
	   if(isNullOrEmpty(appointmentFormData.data.enqIntermediateType)) {
	 	 delete appointmentFormData.data.enqIntermediateType;
	   }

 	   var countryCode=sgFormValues.mobileCountryCode;
 	   var mobileNo=sgFormValues.appointeeContactNo;
 	   var mobileNoWithCode;
 	   if(isNullOrEmpty(countryCode) && isNullOrEmpty(mobileNo) ){
 		   mobileNoWithCode=null;
 	   }else{
 		   mobileNoWithCode=countryCode +'-'+ mobileNo;
 	   }
 	   
 	   /*change for entry by*/ 
 	   var entryBy;
 	  if(submitPortalData == 1){
 		  if(isNullOrEmpty(sgFormValues.entryBy)){
 			  var userId=this.getCurrentlyLoggedInUser();
 			  entryBy = {
 					  id: userId.id
 			  };
 		  } else{
			   entryBy = {
					   id: sgFormValues.entryBy
			   };
		   }
	   }
 	   appointmentFormData.set("appointeeContactNo",mobileNoWithCode);
 	   appointmentFormData.set("bookingDate",sgFormValues.bookingDate);
 	   appointmentFormData.set("appointmentDate",sgFormValues.appointmentDate);
 	   appointmentFormData.set("appointeeEmailId",sgFormValues.appointeeEmailId);
 	   var persontoMeetValue=sgForm.getForm().findField('personToMeet').getRawValue();
 	   appointmentFormData.set("personToMeet",persontoMeetValue);
 	   appointmentFormData.set("visitTime",sgFormValues.visitTime);
 	   appointmentFormData.set("expectedOutTime",sgFormValues.expectedOutTime);
 	   appointmentFormData.set("reasonToVisit",sgFormValues.reasonToVisit);
 	   appointmentFormData.set("entryBy",entryBy);
 	  appointmentFormData.set("additionalReasonToVisit",sgFormValues.additionalReasonToVisit);
 	   
 	   appointmentFormData.set("submitPortalId", submitPortalData);
 	   if(!isNullOrEmpty(visitStatusId.id)){
 		   appointmentFormData.set("sgVisitStatus",visitStatusId);   
 	   }else{
 		   appointmentFormData.set("sgVisitStatus",null); 
 	   }
 	   if(!isNullOrEmpty(reasonForVisitId.id)){
 		   appointmentFormData.set("sgReasonForVisit",reasonForVisitId);   
 	   }else{
 		   appointmentFormData.set("sgReasonForVisit",null); 
 	   }	
 	   appointmentFormData.set("customData",sgFormValues.customData);
 	  
 	   if(sgFormValues.visitorCategory==1){//base category
 		   appointmentFormData.set("person",personId);
 		   delete appointmentFormData.data.enquiry;
 		   delete appointmentFormData.data.staff;
 		   delete appointmentFormData.data.student;
 		   delete appointmentFormData.data.application;
 	   }else if(sgFormValues.visitorCategory==2){
 		   appointmentFormData.set("enquiry",enquiryId);
 		   delete appointmentFormData.data.person;
 		   delete appointmentFormData.data.staff;
 		   delete appointmentFormData.data.student;
 		   delete appointmentFormData.data.application;
 	   } else if (sgFormValues.visitorCategory == 3) {
            appointmentFormData.set("student", student);
            delete appointmentFormData.data.person;
            delete appointmentFormData.data.enquiry;
            delete appointmentFormData.data.staff;
            delete appointmentFormData.data.application;
        }else if(sgFormValues.visitorCategory==4){
 		   appointmentFormData.set("staff",staff);
 		   delete appointmentFormData.data.person;
 		   delete appointmentFormData.data.enquiry;
 		   delete appointmentFormData.data.student;
 		   delete appointmentFormData.data.application;
 	   }else{
 		   delete appointmentFormData.data.person;
 		   delete appointmentFormData.data.enquiry;
 		   delete appointmentFormData.data.staff;
 		   delete appointmentFormData.data.student;
 		   delete appointmentFormData.data.application;
 	   }
 	   if(Ext.isDefined(appointmentFormData.data.entryByName)){
 		   delete appointmentFormData.data.entryByName;
 	   }
 	   if(Ext.isDefined(appointmentFormData.data.personToMeetId)){
 		   delete appointmentFormData.data.personToMeetId;
 	   }
 	   if(isNullOrEmpty(appointmentFormData.data.enqIntermediateType)){
 		   delete appointmentFormData.data.enqIntermediateType;
 	   }
 	   if(isNullOrEmpty(appointmentFormData.data.enqIntermediateStage)){
		   delete appointmentFormData.data.enqIntermediateStage;
	   }
 	   if(isNullOrEmpty(appointmentFormData.data.program.id)){
		   delete appointmentFormData.data.program;
	   }
 	   if(isNullOrEmpty(appointmentFormData.data.batch.id)){
		   delete appointmentFormData.data.batch;
	   }
 	   if(isNullOrEmpty(appointmentFormData.data.progBatchSeatConfig.id)){
		   delete appointmentFormData.data.progBatchSeatConfig;
	   }
 	   
 	   var formData = Ext.encode(appointmentFormData.data);
 	   Ext.getBody().mask();
 	   Ext.Ajax.request({
 		   type : 'rest',
 		   url : submitUrl,
 		   jsonData : formData,
 		   method : 'POST',
 		   success : function(frm, action) {
 			   Ext.getBody().unmask();
 			   sgForm.getForm().reset();
 			   if (isUpdate) {
 				   showSuccessMessage(getServiceRequestTranslation('SG_UPDATE_APPOINTMENT'), getServiceRequestTranslation('SG_APPOINTMENT_UPDATED_SUCCESSFULLY'));
 				   if(getTab!=null){
 					   contentPanel.remove(getTab, true);
 				   }
 				   if(sgDetailGrid!=undefined){
 					   //  sgDetailGrid.getStore().load();
 					   var gridStore = sgDetailGrid.getStore();
 					   var enqId = appointmentFormData.data.enquiry.id;
 					   gridStore.loadPage(1,{params:{
 						   page: gridStore.currentPage,
 						   limit: gridStore.pageSize,
 						   start: ((gridStore.currentPage-1)*(gridStore.pageSize)),
 						   enquiryId : enqId
 					   },callback: function(record, operation, success) {
 						   if (success) {
 							   delete gridStore.getProxy().extraParams.page;
 							   delete gridStore.getProxy().extraParams.limit;
 							   delete gridStore.getProxy().extraParams.start;
 							   delete gridStore.getProxy().extraParams.academyLocationIds;
 						   }
 					   }
 					   });
 					  sgDetailGrid.getSelectionModel().deselectAll();
 				   }
 				   if(sgFormValues.visitorCategory==2){
 					   if( !isNullOrEmpty(enquiryStageId) && !isNullOrEmpty(enquiryStageRawValue) ){
 						   if( !isNullOrEmpty(Ext.getCmp('enqtab_intermediateStage')) && !isNullOrEmpty(Ext.getCmp('enqtab_intermediateStageId')) ){
 							  Ext.getCmp('enqtab_intermediateStage').setValue(enquiryStageRawValue);
							   Ext.getCmp('enqtab_intermediateStageId').setValue(enquiryStageId);
 						   }
 					   }
 				   }

 			   }else{
 				   showSuccessMessage(getServiceRequestTranslation('SG_ADD_APPOINTMENT'), getServiceRequestTranslation('SG_APPOINTMENT_CREATED_SUCCESSFULLY'));
 				   if(getTab!=null){
 					   contentPanel.remove(getTab, true);
 				   }
 				   if(sgDetailGrid!=undefined){
 					   //  sgDetailGrid.getStore().load();
 					   var gridStore = sgDetailGrid.getStore();
 					   var enqId = appointmentFormData.data.enquiry.id;
 					   gridStore.loadPage(1,{params:{
 						   page: gridStore.currentPage,
 						   limit: gridStore.pageSize,
 						   start: ((gridStore.currentPage-1)*(gridStore.pageSize)),
 						   enquiryId : enqId
 					   },callback: function(record, operation, success) {
 						   if (success) {
 							   delete gridStore.getProxy().extraParams.page;
 							   delete gridStore.getProxy().extraParams.limit;
 							   delete gridStore.getProxy().extraParams.start;
 							   delete gridStore.getProxy().extraParams.academyLocationIds;
 						   }
 					   }
 					   });
 					  sgDetailGrid.getSelectionModel().deselectAll();
 				   }
 				   if(sgFormValues.visitorCategory==2){
 					   if( !isNullOrEmpty(enquiryStageId) && !isNullOrEmpty(enquiryStageRawValue) ){
 						   if( !isNullOrEmpty(Ext.getCmp('enqtab_intermediateStage')) && !isNullOrEmpty(Ext.getCmp('enqtab_intermediateStageId')) ){
 							   Ext.getCmp('enqtab_intermediateStage').setValue(enquiryStageRawValue);
 							   Ext.getCmp('enqtab_intermediateStageId').setValue(enquiryStageId);
 						   }
 					   }
 				   }

 			   }
 		   }
 	   });

    },
    setEntrybyValuebydefault : function() {
    	var userId=this.getCurrentlyLoggedInUser();
    	var sgForm=this.getSgappointmentform();
    	var entryByField = sgForm.down("#entryById");
    	entryByField.store.load({
    		callback : function(operation,success) {
    			if (success) {
    				entryByField.setValue(userId.id);
    			}
    		} 
    	});
    },
    setVisitStatusByDefault: function(){
    	var sgForm=this.getSgappointmentform();
    	var viewStatusID = sgForm.down("#viewStatusID");
    	var viewStatusIDStore = viewStatusID.getStore();
    	viewStatusID.setReadOnly(true);
    	viewStatusIDStore.load({
    		callback:function(records,operation,success){
    			var rec = viewStatusIDStore.findRecord('code','Booked');
    			if(!isNullOrEmpty(rec)){
    				var idVal = rec.get('id');
    				viewStatusID.setValue(idVal);
    			}
    		}
    	});  
    	sgForm.down("#appointmentId").setValue(new Date());
    },
    resetSGAppointment: function(form) {
    	var form=this.getSgappointmentform();
    	var bookingId = form.down('#bookingId');
    	var vistrCategory = form.down('#visitorCategoryID');
    	var mobileField = form.down("#mobileNo");
    	var countryCodeField=form.down("#cellCountryCode");
    	var appointeeEmailItemId=form.down("#appointeeEmailItemId");
    	var submitPortalId=form.down("#submitPortalId");
    	submitPortalId.resetOriginalValue();
    	mobileField.resetOriginalValue();
    	appointeeEmailItemId.resetOriginalValue();
    	countryCodeField.resetOriginalValue();
    	form.getForm().reset();
    },
    setExpectedOutTimeInEnquiry : function(obj,record){
    	var sgForm=this.getSgappointmentform();
    	var visitTimeValue='';
    	if(obj.itemId == 'visitTimeId'){
    		var visitTimeValue=record;
    		var id=sgForm.down("#reasonForVisitID").getValue();
    	}else{
    		visitTimeValue=sgForm.down("#visitTimeId").getValue();
    		var id = record[0].get("id");
    	}
    	var visitTimeIdfield=sgForm.getForm().findField('visitTime');
    	var expectedOutTimefield=sgForm.getForm().findField('expectedOutTime');
    	expectedOutTimefield.reset();
    	if(!isNullOrEmpty(id)){
    		var submitUrl = SERVERURL.PATH_SG_REASON_FOR_VISIT_TIME;
    		Ext.Ajax.request({
    			type : 'rest',
    			url : submitUrl,
    			params: {
    				id: id,
    			},
    			method : 'GET',
    			async: false,
    			success : function(data, action) {
    				var data=Ext.decode(data.responseText);
    				if(data.length>0){
    					if(!isNullOrEmpty(visitTimeValue)){
    						if(data[0].code!="0" && data[0].code!="00" || data[0].value!="0" && data[0].value!="00" ){
    							var expTimeDuration='';
    							var expTime =  parseInt(data[0].code)+(parseInt(data[0].value)/60);
    							expTimeDuration = visitTimeValue.getTime() + (expTime*60*60*1000);
    							var expTimeDurationRender = timeRender(expTimeDuration);
    							expectedOutTimefield.setValue(expTimeDurationRender);
    						}else{
   							 expectedOutTimefield.reset();
   							visitTimeIdfield.setMaxValue(null);
   							visitTimeIdfield.setMinValue(null);
   						 }
    					}
    				}
    			}
    		});   
    	}
    } 

     
});