/**
 * @author Rajkumar.patidar
 */
Ext.define('Academia.controller.enquiry.exam.ExamDetailController', {
	extend: 'Academia.controller.base.BaseController',
	alias: "widget.examdetailcontroller",
	stores: ['enquiry.exam.ExamDetailStore', 'enquiry.exam.ProgramStore','common.StatusStore','common.ExamPassedStore','admission.applications.history.StudyModes',
	       'admission.applications.history.ResultStatus','admission.applications.history.EducationGradAndMarks','common.SubjectTypeStore','enquiry.exam.ExamDetailStore'],
	views: ['enquiry.exam.ExamDetailStructure', 'enquiry.exam.ExamDetailForm', 
	        'enquiry.exam.ExamDetailGrid','common.CustomFieldForm','enquiry.Education.EducationDetailStructure','enquiry.Education.EducationDetailForm','enquiry.Education.EducationDetailGrid'],
	        config: {
	        	/*
	        	 * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
	        	 */
	        	/**
	        	 * @cfg {Array} ENQUIRY_EXAM_DETAIL_PERMISSIONS array (required)
	        	 * The array of permissions to use for Access control wise enabling and disabling buttons.
	        	 * @accessor
	        	 */
	        	ENQUIRY_EXAM_DETAIL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ENQUIRY_EXAM_DETAIL_PRIVILEGES')
	        },
	        refs: [{
	            ref: 'personCommonWindow',
	            selector: 'personcommonwindow'
	        },{
	        	ref: 'examdetailForm',
	        	selector: 'examdetailform form'
	        }, {
	        	ref: 'examdetailform',
	        	selector: 'examdetailform'
	        }, {
	        	ref: 'examdetailgrid',
	        	selector: 'examdetailgrid'
	        }, {
	        	ref: 'examdetailstructure',
	        	selector: 'examdetailstructure'
	        }, {
	        	ref: 'enquirytabstructure',
	        	selector: 'enquirytabstructure'
	      },{
	        	ref: 'educationdetailForm',
	        	selector: 'educationdetailform form'
	        }, {
	        	ref: 'educationdetailform',
	        	selector: 'educationdetailform'
	        }, {
	        	ref: 'educationdetailgrid',
	        	selector: 'educationdetailgrid'
	        }, {
	        	ref: 'educationdetailstructure',
	        	selector: 'educationdetailstructure'
	        }],
	        init: function() {
	        	this.control({
	        		
	        		'educationdetailstructure': {
	        			render: function(grid) {
	        				var commonForm = this.getEnquirytabstructure().getForm();
	        	        	var commonVal = commonForm.getValues();
	        	          	var grid = Ext.getCmp('educationDetail_grid');
	        	          	var grdStore = grid.getStore();
	        	          	var buttonId = commonVal.buttonType;
    	                     if(buttonId == 'View'){
    	                    		grid.down('#btnAdd').setVisible(false);
    	                    		grid.down('#btnEdit').setVisible(false);
    	                    		grid.down('#btnDelete').setVisible(false);
    	                    	}
    	                     if(commonVal.enqTypes == 'Counselling'){
    	                    	 this.setEduGridBtnHideShow(grid,false,buttonId);
    	                     }else{
    	                    	 this.setEduGridBtnHideShow(grid,true,buttonId);  
    	                     }
	        	          	grdStore.getProxy().extraParams={
	        	          		id:commonVal.enqId
	        	          	};
	        	          	grdStore.load({
	        	          		start: 0,
	        	          		limit: 5
	        	          	});
	        			}
	        		},
	        		'examdetailgrid': {
	        			render: function(grid) {
	        				this.doAccessControlValidation(grid, this.getENQUIRY_EXAM_DETAIL_PERMISSIONS());
	        				var commonForm = this.getEnquirytabstructure().getForm();
	        	        	var commonVal = commonForm.getValues();
	        				var buttonId = commonVal.buttonType;
	                    	if(buttonId == 'View'){
	                    		grid.down('#btnAdd').setVisible(false);
	                    		grid.down('#btnEdit').setVisible(false);
	                    		grid.down('#btnDelete').setVisible(false);
	                    	}
	        			}
	        		},
	        		'examdetailgrid button[itemId=btnAdd]': {
	        			click: this.showFormWindow
	        		},
                   'educationdetailgrid button[itemId=btnAdd]': {
	        			click: this.showEducationWindow
	        		},
	        		'examdetailgrid button[itemId=btnEdit]': {
	        			click: this.editFormWindow
	        		},
                    'educationdetailgrid button[itemId=btnEdit]': {
	        			click: this.editEducationWindow
	        		},
	        		'educationdetailgrid button[itemId=btnView]': {
	                    click: this.viewEducationDetailFormWindow
	                },
	        		'examdetailgrid button[itemId=btnDelete]': {
	        			click: this.deleteFormWindow
	        		},
	        		'examdetailgrid button[itemId=btnView]': {
	        			click: this.viewFormWindow
	        		},
	        		'educationdetailgrid button[itemId=btnDelete]': {
	        			click: this.deleteEducationFormWindow
	        		},
	        		'examdetailform button[itemId=examdetail_submitbuttonId]': {
	        			click: this.saveExamDetail
	        		},
                    'educationdetailform button[itemId=EdusubmitButtonId]': {
	        		    click: this.saveEducationHistoryDetail
	        		},
	        		'examdetailform button[itemId=examdetail_cancelbuttonId]': {
	        			click: this.cancelExamDetail
	        		},
	        		'examdetailform radiogroup[itemId=ED_radioBtn]': {
	        			change: function(f) {
	        				this.onProgramSelection(f);
	        			}
	        		},
	        		'educationdetailform': {
	                    afterrender: function(form){
	                    	this.afterEducationFormRender();
		                    this.educationDetailFormDFR(form);
	                    }
	                },
	        		 'educationdetailform button[itemId=cancelButtonId]': {
	        			 click: this.cancelEducationDetail
		        		},
	        		'educationdetailform combo[itemId=subject]': {
		        		select: function(obj, record, eOpts) {
	        				var subject = record[0].get('id');
	        				var flag = true;
	    					var subjectMarkPanel = obj.up("#subjectMarkPanel");
	    					var rowIndx = obj.rowIndx;
	    					var maximumMarks = obj.nextSibling();
	                    	var marks = maximumMarks.nextSibling();
	    					if(!isNullOrEmpty(subjectMarkPanel)){
	    						subjectMarkPanel.items.each(function(item, index, items) {
	    							var subjectNameVal = item.down("[name=subject]").getValue();
	    							if(subject == subjectNameVal && rowIndx != index){
	    								flag = false;
	    	        					return false;
	    							}
	    						});
	    						if(flag){
	                				if(!isNullOrEmpty(maximumMarks)){
	                					maximumMarks.setDisabled(false);
	                					maximumMarks.allowBlank=true;
	                				}
	                				if(!isNullOrEmpty(marks)){
	                					marks.setDisabled(false);
	                					marks.allowBlank=false;
	                				}
	    						}
	    						else{
	    							obj.reset();
	    							if(!obj.nextSibling().isHidden()){
	    								if(!isNullOrEmpty(maximumMarks)){
	    									maximumMarks.reset();
	    									maximumMarks.allowBlank=true;
	    									maximumMarks.setDisabled(true);
		                				}
	    	 							}else{
	    	 								if(!isNullOrEmpty(maximumMarks)){
	    	 									maximumMarks.reset();
	    	 									maximumMarks.allowBlank=true;
	    	 									maximumMarks.setDisabled(true);
			                				}
	    	 							}
	    							if(!isNullOrEmpty(marks)) {
	    								marks.reset();
	    								marks.allowBlank=true;
	    								marks.setDisabled(true);
	    							}
	    							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SUBJECT_ALREADY_SELECTED_MSG'));
	    							return false;
	    						}
	    					}
	                    }
	                },
	        		'examdetailstructure': {
	        			render: function(component, options) {
	        				this.onExamFormRender(component, options);
	        			}
	        		},
	        		'examdetailform combo[itemId=programId]': {
	        			select: function(c, r) {
	        				this.getExamdetailForm().getForm().findField('programCodeExamDeatil').setValue(r[0].data.code);
	        			}
	        		},
	        		'educationdetailform combo[itemId=examPassed]': {
	        			select: function(obj, newValue, oldValue, eOpts) {
	        				var educationGrid=this.getEducationdetailgrid();
	        				educationGrid.getStore().each(function(record){
	        					if(record.get('examPassed').id == newValue[0].get('id')){
	        						obj.setValue();
	        						showWarningMessage(getCommonTranslation('EXAMTITLE'), getCommonTranslation('DUPLICATE_EXAMPASSED'));
	        					}
	        				});
	        			}
	        		},
	        		'educationdetailform combo[itemId=gradeMark]': {
	        			select: function(obj, newValue, oldValue, eOpts) {
	        				var form = this.getEducationdetailform();
	        				var gradeObtained = form.down('#gradeObtained');
	        				var marksObtained = form.down('#marksObtained');
	        				if(newValue[0].getId() =='MARKS')
	        				{
	        					marksObtained.setVisible(true);
	        					gradeObtained.setVisible(false);
	        				}else
	        				{
	        					marksObtained.setVisible(false);
	        					gradeObtained.setVisible(true);
	        				}	


	        			}
	        		},
		        	'educationdetailform combo[itemId=yearItemId]':{
		        		render : this.loadEnquiryEducationYearData
		        	},
		        	'educationdetailform datefield[itemId=yearOfExam]':{
		        		render: function(obj) {
		        			 this.setEnquiryYearOfEaxmDateMinvalue(obj);
		        		 },
		        		 select: function(obj,value){       
		        		 this.setEnquiryEducationYearMonthData(obj,value);
		        		}
		        	},
		        	'educationdetailform textfield[itemId=marks]':{
		        		 blur: function(textfield, eOpts) { 
		        			 var num = textfield.getValue();
		        			 if(!isNaN(num)&&!isEmpty(num)){	
			        			 var number=Math.round(num*100)/100;
			        			 textfield.setValue(number); 
		        			 }
		        		 }
		        	},
		        	'personcommonwindow': {
		    			render:function(window){
		    				var $this = this
		    				window.body.on('click', function() {
		    					var form = window.down('educationdetailform');
		    					$this.hideInvalidIconFromField(form);
		    			       });
		    			}
		    		},
		    		 'educationdetailform textfield[itemId=marks]': {
		             	blur: function(textfield, eOpts) { 
		        			 var num = textfield.getValue();
		        			 if(!isNaN(num)&&!isEmpty(num)){	
		 	        			 var number=Math.round(num*100)/100;
		 	        			 textfield.setValue(number); 
		        			 }
		        		 }
		             },
		            
	        	});
	        },
	        enableRadioButton: function() {
	        	var form = this.getExamdetailForm();
	        	var examform = form.getForm();
	        	var radiobutton = examform.findField("programExam");
	        	radiobutton.items.items[0].setValue(false);
	        	radiobutton.items.items[1].setValue(true);
	        },
	        cancelExamDetail: function() {
	        	var form = this.getExamdetailform();
	        	form.close();
	        },
	        cancelEducationDetail : function(){
	        	/*var form = this.getEducationdetailform();
	        	form.close();*/
	        	var this$ = this;
	            this$.getPersonCommonWindow().close();
	        },
	        showFormWindow: function() {
	        	var formWindow = this.getExamdetailform();
	        	if (!formWindow) {
	        		Ext.widget('examdetailform');
	        		formWindow = this.getExamdetailform();
	        	}
	        	formWindow.show();
	        },
            showEducationWindow: function(){
	        	var title = getEnquiryTranslation('EXAMTITLE');
	        	var formItemId = 'educationdetailform'
	    		var xtypeForm = 'educationdetailform';
	    		var formWindow = Ext.widget('personcommonwindow',{
	        		title: title,
	        		itemId : 'personCommonWindow',
	        		items: [{
	        			 xtype: xtypeForm,
	        		     itemId: formItemId
	        		}]
	        	});    		
	        	formWindow.show();
	        },
	        editFormWindow: function() {
	        	//  var grid = this.getExamdetailgrid();
	        	var grid = Ext.getCmp('examDetail_grid');
	        	var store = this.getStore('enquiry.exam.ExamDetailStore');
	        	var selectedRecord = grid.getSelectionModel().getSelection()[0];
	        	var row = store.indexOf(selectedRecord);
	        	var storedata = store.getAt(row);
	        	if (grid.getSelectionModel().getCount() > 0) {
	        		this.showFormWindow();
	        		var form = this.getExamdetailForm();
	        		var f = form.getForm();
	        		var records = grid.getSelectionModel().getSelection();
	        		var programCombo = f.findField('program');
	        		if (storedata != undefined && storedata != "" && storedata != null) {
	        			form.loadRecord(storedata);
	        			var pursuingExamDetal = Ext.ComponentQuery.query('radiogroup#ED_radioBtn')[0];
	        			if (storedata.data.programExamType === "Current Pursuing") {
	        				pursuingExamDetal.items.items[0].setValue(true);
	        				pursuingExamDetal.items.items[1].setValue(false);
	        				Ext.ComponentQuery.query('combo#examStatusDetail')[0].reset();
	        			}
	        			else {
	        				pursuingExamDetal.items.items[0].setValue(false);
	        				pursuingExamDetal.items.items[1].setValue(true);
	        			}
	        			programCombo.store.load({
	        				callback: function(r, operation, success) {
	        					if (success) {
	        						programCombo.setValue(records[0].data.enqProgramMaster.id);
	        					}
	        				}
	        			});
	        		}
	        		//  this.enableRadioButton();
	        	}
	        	else {
	        		showWarningMessage(getCommonTranslation('EXAMTITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	        	}
	        },
                editEducationWindow: function(){
	        	var grid = Ext.getCmp('educationDetail_grid');
	        	var store = grid.getStore();
	        	
	        	if (grid.getSelectionModel().getCount() > 0) {
	             	this.showEducationWindow();
	                 var form = this.getEducationdetailForm();
	                 var records = grid.getSelectionModel().getSelection()[0];
//	                 console.log('records',records);
	                 var gradeMark=records.get('gradeMark');
	                 var marksOrGradeObtained=records.get('marksOrGradeObtained');
	                 if (!isEmpty(records)) {
	                	 if (!isNullOrEmpty(records.data.yearOfExam))
	                		 records.data.yearOfExam = new Date(records.data.yearOfExam);
	                     form.loadRecord(records);
	                     form.down('#examPassed').setReadOnly(true);
	                     var data = records.get("subjectMarkInfo");
	                     if (!isEmpty(data)) {
	                         for (var i = 0; i < data.length; i++) {
	                             var subjectMarkPanel = form.down('#subjectMarkPanel');
	                             var formContainer = subjectMarkPanel.getComponent(i);
	                             formContainer.down('#subjectId').setValue(data[i].id);
	                             formContainer.down('#subjectVersion').setValue(data[i].version);
	                             formContainer.down('#subject').setValue(data[i].subject);
	                             formContainer.down('#marks').setDisabled(false);
	                             formContainer.down('#subMaximumMarks').setDisabled(false);
	                             formContainer.down('#marks').setValue(data[i].marks);
	                             formContainer.down('#subMaximumMarks').setValue(data[i].subMaximumMarks);
	                             if (i < (data.length - 1)) {
	                                 this.addSubjectMarkContainer();
	                             }
	                         }
	                     }
	                     if(gradeMark=='MARKS'){
	                    	form.down("#marksObtained").setVisible(true);
	                    	form.down("#gradeObtained").setVisible(false);
	                     	form.down("#marksObtained").setValue(marksOrGradeObtained);
	                     }else{
	                    	form.down("#marksObtained").setVisible(false);
		                    form.down("#gradeObtained").setVisible(true);
	                     	form.down("#gradeObtained").setValue(marksOrGradeObtained);
	                     }  
	                 }
	             } else {
	                 showWarningMessage(getPersonModuleTranslation('EDUCATION_HISTORY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	             }
	        },
	        deleteFormWindow: function() {
	        	var grid = Ext.getCmp('examDetail_grid');
	        	var grdStore = grid.getStore();
	        	if (grid.getSelectionModel().getCount() > 0) {
	        		var records = grid.getSelectionModel().getSelection();
	        		var id = records[0].get("id");
	        		showConfirmMessage(getCommonTranslation('DELETE_CONFIRM_MESSAGE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	        			if (btn == 'yes') {
	        				Ext.Ajax.request({
	        					method: "DELETE",
	        					type: 'rest',
	        					url: SERVERURL.ENQUIRY_EXAM_DETAIL_DELETE + '?id=' + id,
	        					headers: {
	        						'Content-Type': 'application/json'
	        					},
	        					success: function(form, action) {
	        						grdStore.reload();
	        						showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('DELETE_ENQUIRY_MSG'));
	        					}
	        				});
	        			}
	        		});
	        	}
	        	else {
	        		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
	        	}
	        },
	        viewFormWindow: function() {
	        	this.editFormWindow();
	        	var form = this.getExamdetailForm();
	        	if (form) {
	        		form.down('#examdetail_submitbuttonId').setVisible(false);
	        		form = form.getForm();
	        		toggleReadOnlyFormItems(form, true);
	        	}
	        },
	        saveExamDetail: function() {
	        	var me = this;
	        	var grid = Ext.getCmp('examDetail_grid');
	        	var grdStore = grid.getStore();

	        	var formWindow = me.getExamdetailForm().getForm();
	        	var commonForm = me.getEnquirytabstructure().getForm();
	        	var commonVal = commonForm.getValues();
	        	var enquiryId = commonVal.enqId;
	        	var programExamDetal = formWindow.findField('program');
	        	var value = formWindow.getValues();
	        	var pursuingExamDetal = Ext.ComponentQuery.query('radiogroup#ED_radioBtn')[0];
	        	var curntlyPrsuing = pursuingExamDetal.items.items[0].checked;

	        		var examdetailgridModel = new Academia.model.enquiry.exam.ExamDetailModel();
	        		examdetailgridModel.set("programYear", value.programYear);
	        		if (curntlyPrsuing) {
	        			examdetailgridModel.set("examStatus", "Pur");
	        			examdetailgridModel.set("examResult");
	        		}
	        		else {
	        			examdetailgridModel.set("examStatus", value.examStatus);
	        			examdetailgridModel.set("examResult", value.examResult);
	        		}
	        		examdetailgridModel.set("programConductedBy", value.programConductedBy);
	        		examdetailgridModel.set("enqProgramMaster", me.getIdValueJson(programExamDetal.getValue(), programExamDetal.getRawValue(), value.programCodeExamDeatil));
	        		examdetailgridModel.set("enquiry", me.getIdValueJson(enquiryId));
	        		examdetailgridModel.set("whetherDeleted", false);
	        		examdetailgridModel.set("customData", value.customData);
	        		if (curntlyPrsuing) {
	        			examdetailgridModel.set("programExamType", "Current Pursuing");
	        		}
	        		else {
	        			examdetailgridModel.set("programExamType", "Previous Passed Exam");
	        		}
	        		if (value.id == null || value.id == "") {
	        			submitUrl = SERVERURL.ENQUIRY_EXAM_DETAIL_CREATE;
	        		}
	        		else {
	        			examdetailgridModel.set("id", value.id);
	        			submitUrl = SERVERURL.ENQUIRY_EXAM_DETAIL_UPDATE;
	        		}
	        		var submitData = Ext.encode(examdetailgridModel.data);
	        		Ext.Ajax.request({
	        			url: submitUrl,
	        			jsonData: submitData,
	        			method: 'POST',
	        			success: function(response) {
	        				console.log('response',response);
	        				var msg = response.responseText;
	            			 if(msg!='' && msg=='DUPLICATE'){
	            				 showWarningMessage(getCommonTranslation('EXAMTITLE'), getCommonTranslation('RECORD_IS_ALREADY_EXIST'));
	            			 }else if(msg!='' && msg=='SUCCESS'){
	            				grdStore.reload();
	 	        				me.cancelExamDetail();
	 	        				showSuccessMessage(getCommonTranslation('EXAMTITLE'), getCommonTranslation('SUCCESS'));
	            			 }            	
	        			}
	        		});
	        },
	        onProgramSelection: function(f) {
	        	var form = this.getExamdetailForm().getForm();
	        	var curntlyPrsuing = f.items.items[0].checked;
	        	if (!curntlyPrsuing) {
	        		var result = form.findField("examResult");
	        		var status = form.findField("examStatus");
	        		result.show();
	        		status.show();
	        		result.allowBlank = false;
	        		status.allowBlank = false;
	        		result.setFieldLabel(getCommonTranslation('EXAM_RESULT') + '<span class="required" style="color:red"> *</span>');
	        		status.setFieldLabel(getCommonTranslation('STATUS') + '<span class="required" style="color:red"> *</span>');
	        		//f.ownerCt.getPlugin().onBeforeRender(this.getExamdetailForm());
	        	}
	        	else {
	        		var result = form.findField("examResult");
	        		var status = form.findField("examStatus");
	        		result.reset();
	        		status.reset();
	        		result.hide();
	        		status.hide();
	        		result.allowBlank = true;
	        		status.allowBlank = true;
	        		form.isValid();
	        	}
	        },
	        onExamFormRender: function(component, options) {
	        	var $this=this;
	        	var commonForm = $this.getEnquirytabstructure().getForm();
	        	var commonVal = commonForm.getValues();
	        	var enquiryId = commonVal.enqId;
	        	var grid = $this.getExamdetailgrid();
	        	var store = grid.getStore();
	        	store.getProxy().extraParams = {
	        		id: enquiryId
	        	};
	        	store.load();
	        },
	        getIdValueJson: function(id, value, code) {
	        	if (id) return {
	        		id: id,
	        		value: value,
	        		code: code
	        	};
	        },
	        addSubjectMarkContainer: function() {
	            var this$ = this;
	            var window = this$.getEducationdetailform();
	            var form = this$.getEducationdetailForm();
	            var panelContiner = form.down('#subjectMarkPanel');

	            window.subjectmarksCount += 1;
	            var subjectmarksCount = window.subjectmarksCount;
	            var indx;
				indx = panelContiner.items.items.length;
	            var panelItem = new Array();
	            panelItem.push({
	                xtype: 'fieldcontainer',
	                layout: {
	                    type: 'hbox',
	                    align: 'bottom'
	                },
	                items: [{
	                    xtype: 'hidden',
	                    itemId: 'subjectId',
	                    name: 'subjectId'
	                }, {
	                    xtype: 'hidden',
	                    itemId: 'subjectVersion',
	                    name: 'subjectVersion'
	                }, {
	                    xtype: 'nestedJsonCombo',
	                    itemId: 'subject',
	                    fieldLabel: getPersonModuleTranslation('SUBJECT'),
	                    labelAlign: 'top',
	                    hideLabel: true,
	                    width: 256,
	                    store: 'common.SubjectTypeStore',
	                    valueField: 'id',
	                    displayField: 'value',
	                    name: 'subject',
	                    editable: false,
	                    rowIndx:indx
	                   // allowBlank: false,
	                },{
	                	xtype: 'numberfield',
	                	fieldLabel: getPersonModuleTranslation('MAXIMUM_MARKS'),
	                	labelAlign: 'top',
	                	itemId: 'subMaximumMarks',
	                	name: 'subMaximumMarks',
	                	disabled: true,
	                	width: 113,
	                	maxLength:5,
	                	hideLabel: true,
	                	keyNavEnabled: false,
	                	mouseWheelEnabled: false,
	                	hideTrigger: true,
	                	minValue:0,
	                	validator: function(value){
	                    	var res = true;
	                    	var maxMarkvalidText = null;
	                    	if(!this.nextSibling().isHidden()){
	                    		if(!isNullOrEmpty(this.nextSibling().getValue())){
	                    			if(!isNullOrEmpty(this.getValue())){
	                    				if(this.getValue()<this.nextSibling().getValue()){
	                    				    maxMarkvalidText = getCommonTranslation('MAXIMUM_MARK_MARKS_OBTAINED_VALIDATION');
	                    				    res = false;
	                    				}	
	                    			}
	                			}
	                            if(res) {
	                                return true;
	                            } else {
	                            	if(!isNullOrEmpty(maxMarkvalidText)){
	                            		return maxMarkvalidText;	
	                            	}
	                            }
	                    	}else{
	                    		return true;
	                    	}
	                    }
	                }, {
	                    xtype: 'textfield',
	                    itemId: 'marks',
	                    fieldLabel: getPersonModuleTranslation('MARKS_GRADE'),
	                    labelAlign: 'top',
	                    hideLabel: true,
	                    allowBlank: false,
	                    disabled: true,
	                    width: 256,
	                    name: 'marks',
	                    maxLength:7,
	                    decimalPrecision:2,
	                    validator: function(value){
	                    	var validText = getPersonModuleTranslation('MARKS_GRADE_VALID_TYPE');
	                    	var patt = new RegExp('(^[A-Z]{1}[+]{1}$)|(^[A-Z]{1}[+]{2}$)|(^[A-Z]{1}[-]{1}$)|(^[A-Z]{1}[-]{2}$)|(^[A-Z]{1}[0-9]{1}$)|(^[A-Z]{1}$)|(^[0-9]{1,3}$)|(^[0-9]{1,3}[\.]{1}[0-9]{1,5}$)');
	                    	var res = patt.test(value);
	                    	var maxMarkvalidText = null;
	                    	if(!this.previousSibling().isHidden()){
	                    		if(!isNullOrEmpty(this.previousSibling().getValue())){
	                    			if(!isNullOrEmpty(this.getValue())){
	                    				if(this.getValue()>this.previousSibling().getValue()){
	                    				    maxMarkvalidText = getCommonTranslation('MAXIMUM_MARK_MARKS_OBTAINED_VALIDATION');
	                    				    res = false;
	                    				}	
	                    			}
	                			}
	                    	}
	                        if(res) {
	                            return true;
	                        } else {
	                        	if(!isNullOrEmpty(maxMarkvalidText)){
	                        		return maxMarkvalidText;	
	                        	}else{
	                        		return validText;
	                        	}
	                        }
	                    }
	                }, {
	            		xtype : 'button',
	            		itemId: 'btnDeleteSubjectMarks' + subjectmarksCount,
	            		/*ui: 'CustomBtnSubmit',
	            		tooltip : getCommonTranslation('DELETE'),
	            		glyph : ICONGLYPH.DELETEGLYPH*/
	            		glyph: ICONGLYPH.DELETEGLYPH,
	    	   			cls: 'CustomBodyBtnReject',
	    	   			tooltip: getCommonTranslation('DELETETOOLTIP')
	            	}, {
	            		xtype : 'button',
	            		//ui: 'CustomBtnSubmit',
	            		itemId: 'btnAddSubjectMarks' + subjectmarksCount,
	            		/*tooltip : getCommonTranslation('ADD'),
	            		glyph : ICONGLYPH.ADDGLYPH*/
	            		cls: 'CustomBodyBtnSettings',
	    				text: getCommonTranslation('ADDBUTTONTEXT'),
	    				tooltip: getCommonTranslation('ADD')
	            	}]
	            });

	            var subjectMarkPanel = form.down('#subjectMarkPanel');
	            subjectMarkPanel.add(panelItem);

	            form.down('#btnAddSubjectMarks' + subjectmarksCount).on('click', function() {
	                this$.addSubjectMarkContainer();
	            }, form);
	            form.down('#btnDeleteSubjectMarks' + subjectmarksCount).on('click', function(deleteButton) {
	                this$.deleteSubjectMarkContainer(deleteButton);
	            }, form);
	            this$.hideShowSubjectMarksElement(subjectMarkPanel);
	            window.doLayout();
	        },
	        
	        hideShowSubjectMarksElement: function(subjectMarkPanel) {
	            var this$ = this;
	            var form = this$.getEducationdetailForm();
	            subjectMarkPanel.items.each(function(item, index, items) {
	                if (index == 0) {
	                    var allowblankFalse = '<span class="required" style="color:red"> *</span>';
	                    item.down('#subject').hideLabel = false;
	                    item.down('#marks').hideLabel = false;
	                    item.down('#subject').labelSeparator = '';
	                    item.down('#marks').labelSeparator = '';
	                    //item.down('#subject').setFieldLabel(getPersonModuleTranslation('SUBJECTT'));
	                    //item.down('#marks').setFieldLabel(getPersonModuleTranslation('MARKS_GRADEE')+allowblankFalse);
	                } else {
	                    item.down('#subject').hideLabel = true;
	                    item.down('#marks').hideLabel = true;
	                    var subMaxMark = item.down('#subMaximumMarks');
	                    if (localStorage.getItem('isVisibleEnquirySubMaximumMarks') == true) {
	                    	subMaxMark.setVisible(true);
	     				}else{
	     					subMaxMark.setVisible(false);
	     				}
	                }
	                var addButton = item.getComponent(item.items.length - 1);
	                if (index == (items - 1)) {
	                    if (addButton != null) {
	                        addButton.show();
	                    }
	                } else {
	                    if (addButton != null) {
	                        addButton.hide();
	                    }
	                }

	            });

	        },

	        saveEducationHistoryDetail : function(){
	        	var this$ = this;
	          	var grid = Ext.getCmp('educationDetail_grid');
	          	var grdStore = grid.getStore();
	          	var form = this$.getEducationdetailform();
	          	this.showInvalidIconOnField(form);
	          	if(this$.getEducationdetailform() != undefined &&  this$.getEducationdetailForm() != undefined) {
	          		 var window = this$.getEducationdetailform();
	 	            var form = this$.getEducationdetailForm();
	 	            var commonForm = this$.getEnquirytabstructure().getForm();
	 	            if(!isNullOrEmpty(commonForm.getValues)){
	 	            	
	 	            	var commonVal = commonForm.getValues();
	 		          	var enquiryId = commonVal.enqId;
	 		          	
	 	            }
	 	           grdStore.getProxy().extraParams = {
	 	        	   id:enquiryId
	 	           };
	 	           var jsonFormatFormData = this$.getJsonEducationHistoryData(form,enquiryId);
	 	           if(jsonFormatFormData!=false){
	 	        	  form.down('#EdusubmitButtonId').setDisabled(true);
	 	        	  var id = form.down('#education_hidden_field');
		 	            if (id.rawValue == null || id.rawValue == "") {
		        			submitUrl = SERVERURL.ENQUIRY_EXAM_DETAIL_CREATE;
		        		}
		        		else {
		        			submitUrl = SERVERURL.ENQUIRY_EXAM_DETAIL_UPDATE;
		        		}
		 	           Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		 	             Ext.Ajax.request({
		 	        			url: submitUrl,
		 	        			jsonData: jsonFormatFormData,
		 	        			method: 'POST',
		 	        			success: function(response) {
		 	        				 Ext.getBody().unmask();
//		 	        				console.log('response',response);
		 	        				var msg = response.responseText;
		 	            			 if(msg!='' && msg=='DUPLICATE'){
		 	            				 showWarningMessage(getCommonTranslation('EXAMTITLE'), getCommonTranslation('RECORD_IS_ALREADY_EXIST'));
		 	            			 }else if(msg!='' && msg=='SUCCESS'){
		 	            				grdStore.reload();
		 	            				grid.getSelectionModel().deselectAll();
		 	            				this$.cancelEducationDetail();
		 	 	        				showSuccessMessage(getCommonTranslation('EXAMTITLE'), getCommonTranslation('SUCCESS'));
		 	            			 }            	
		 	        			}
		 	        		}); 
	 	           }
	          	}
	        },
	        getJsonEducationHistoryData: function(form,enquiryId) {
	        	
	        	var this$ = this;
	        	var flag = 0;
	            var jsonFormFieldData = new Object();
	            var formData = form.getValues();
	            if (!isEmpty(formData)) {
	                var subjectMarkInfo = new Array();
	               // if (!isNullOrEmpty(formData["subject"]) && !isNullOrEmpty(formData["subject"].id)) {
	                if (!isNullOrEmpty(formData["subject"]) && !isNullOrEmpty(formData["marks"])) {
	                    var isSubjectArray = isArray(formData["subject"]);
	                    var isMarksArray = isArray(formData["marks"]);
	                    if (isSubjectArray || isMarksArray) {
	                        for (var i = 0; i < formData["subject"].length; i++) {
	                        	if(!isNullOrEmpty(formData["subject"][i]) && !isNullOrEmpty(formData["marks"][i])){
	                        		var obj = new Object();
	                                obj.id = formData["subjectId"][i];
	                                obj.version = formData["subjectVersion"][i];
	                                obj.subject = formData["subject"][i];
	                                obj.marks = formData["marks"][i];
	                                obj.subMaximumMarks = formData["subMaximumMarks"][i];
	                                subjectMarkInfo.push(obj);
	                        	}
	                        }
	                    } else {
	                        var obj = new Object();
	                        if(!isNullOrEmpty(formData["subject"])){
	                        	obj.id = formData["subjectId"];
	                            obj.version = formData["subjectVersion"];
	                            obj.subject = formData["subject"];
	                            obj.marks = formData["marks"];
	                            obj.subMaximumMarks = formData["subMaximumMarks"];
	                            subjectMarkInfo.push(obj);
	                        }
	                    }

	                    formData.subjectMarkInfo = subjectMarkInfo;
	                }
	                delete formData["subjectId"];
	                delete formData["subjectVersion"];
	                delete formData["subject"];
	                delete formData["marks"];
	                delete formData["subMaximumMarks"];
	            }
	            var getYearValue = null;
	            var getMonthValue = null;
	            
	            if( !isNullOrEmpty(formData["yearOfExam"]) ){
	            	getYearValue = Ext.Date.format(new Date(formData["yearOfExam"]), 'Y');
	            	getMonthValue = parseInt(Ext.Date.format(new Date(formData["yearOfExam"]), 'm'));

	            	var fetchMonthValue = this.getMonthArrayEnquiryEducation(getMonthValue);
	            	var monthofExam = form.down('#monthItemId');
	            	var yearofExam = form.down('#yearItemId');
	            	if(formData.monthOfExamination.toLocaleUpperCase() == fetchMonthValue && formData.yearOfExamination == getYearValue){
	            		if(monthofExam.isVisible() != true){
	            			formData.monthOfExamination = fetchMonthValue;
	            		}else{
	            			formData.monthOfExamination = formData.monthOfExamination.toLocaleUpperCase();
	            		}
	            		if(isNullOrEmpty(formData.monthOfExamination)){
	            			formData.monthOfExamination = null;
	            		}
	            		if(yearofExam.isVisible() != true){
	            			formData.yearOfExamination = getYearValue;
	            		}
	            	}else{
	            		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('EDUCATION_DETAIL_DATE_OF_EXAM_NOT_VALID')); //Please select a record
	            		return false;
	            	}
	            }else{
	            	delete	formData.monthOfExamination;
	            	delete	formData.yearOfExamination;
	            	delete	formData.yearOfExam;
	            }
	            if(formData.gradeMark=='MARKS'){
            		formData.marksOrGradeObtained = formData.marksObtained;
            	}else{
            		formData.marksOrGradeObtained = formData.gradeObtained;
            	}
            	if(!isNullOrEmpty(formData.id)){
            		formData.id = formData.id;
            	}
            	delete formData.gradeObtained;
            	delete formData.marksObtained;
            	formData.enquiry = this$.getIdValueJson(enquiryId);
            	jsonFormFieldData = Ext.encode(formData);

            	return jsonFormFieldData;
	           
	        },
	        deleteSubjectMarkContainer: function(deleteButton) {
	            var this$ = this;
	            var window = this$.getEducationdetailform();
	            var form = this$.getEducationdetailForm();
	            var subjectMarkPanel = form.down('#subjectMarkPanel');
	            var container = deleteButton.up('fieldcontainer');

	            if (container != null && subjectMarkPanel != null) {
	                if (subjectMarkPanel.items.length > 1) {
	                	//var id=container.down('#subjectId').getValue();
	                	container.down('#subject').allowBlank=true;
	                	container.down('#marks').allowBlank=true;
	                	form.isValid();
	                	subjectMarkPanel.remove(container);
	                	this$.hideShowSubjectMarksElement(subjectMarkPanel);
	                    
	                }
	            }
	            window.doLayout();
	        },
	        deleteEducationFormWindow: function() {
	        	var grid = Ext.getCmp('educationDetail_grid');
	        	var grdStore = grid.getStore();
	        	if (grid.getSelectionModel().getCount() > 0) {
	        		var records = grid.getSelectionModel().getSelection();
	        		var id = records[0].get("id");
	        		showConfirmMessage(getCommonTranslation('CONFIRM_DELETE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	        			if (btn == 'yes') {
	        				Ext.Ajax.request({
	        					method: "DELETE",
	        					type: 'rest',
	        					url: SERVERURL.ENQUIRY_EXAM_DETAIL_DELETE + '?id=' + id,
	        					headers: {
	        						'Content-Type': 'application/json'
	        					},
	        					success: function(form, action) {
	        						grdStore.reload();
	        						showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('EDUCATION_DETAIL_DELETE_MSG'));
	        					}
	        				});
	        			}
	        		});
	        	}
	        	else {
	        		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
	        	}
	        },

	        viewEducationDetailFormWindow: function() {
	        	var this$ = this;
	            this$.editEducationWindow();
	            var form = this$.getEducationdetailForm();
	            var window = this$.getEducationdetailform();
	            var formData = form.getValues();
	           	var deleteBtn= form.query('#btnDeleteSubjectMarks0');
	           	var addBtn= form.query('#btnAddSubjectMarks0');
	            if (form) {
	        		form.down('#EdusubmitButtonId').setVisible(false);
	        		
	        		var filter = form.getForm();
	        		toggleReadOnlyFormItems(filter, true);
	        	}
	            deleteBtn.forEach(function(rec){
	            	rec.setDisabled(true)
	            });
	            addBtn.forEach(function(rec){
	            	rec.setDisabled(true)
	            });
	            
	            },
	            afterEducationFormRender: function() {
	                var this$ = this;
	                var window = this$.getEducationdetailform();
	                Ext.apply(window, {
	                    subjectmarksCount: 0
	                });
	                var form = this$.getEducationdetailForm();
	                form.down('#btnAddSubjectMarks0').on('click', function() {
	                    this$.addSubjectMarkContainer();
	                }, form);
	                form.down('#btnDeleteSubjectMarks0').on('click', function(deleteButton) {
	                    this$.deleteSubjectMarkContainer(deleteButton);
	                }, form);
	            },
                setEduGridBtnHideShow: function(grid,check,buttonId){
                	if(buttonId != 'View'){
                		grid.down('#btnAdd').setVisible(check);
                 		grid.down('#btnEdit').setVisible(check);
                 		grid.down('#btnView').setVisible(check);
                 		grid.down('#btnDelete').setVisible(check); 
                 		var btnToolBar =  grid.query('toolbar')[0];
                 		btnToolBar.query('#btnExportToPDF')[0].setVisible(check); 
                 		btnToolBar.query('#btnExportToExcel')[0].setVisible(check); 
                	}
                },
                loadEnquiryEducationYearData : function(cmb){
                	var records= new Array ();
                	var currentYear = Ext.Date.format(new Date(), 'Y');
                	for(var num = currentYear ;num >=1950; num--){
                		records.push({
                            value: num,
                            id : num.toString()
                        });
                	}
                	var store = cmb.getStore();
                	store.loadData(records);
                },
                setEnquiryEducationYearMonthData:function(obj,value){
                	var getYearValue = Ext.Date.format(new Date(value), 'Y');
                	var getMonthValue = Ext.Date.format(new Date(value), 'm');
                	var $this = this;
                	var getEducationForm = $this.getEducationdetailform();
                	var getMonthField = getEducationForm.down('#monthItemId');
                	var getYearField = getEducationForm.down('#yearItemId');
                	var getMonthOfExamination = getEducationForm.down('#monthOfExamination');
                	var getYearOfExamination = getEducationForm.down('#yearOfExamination');
                	
                	getMonthField.getStore().load({
            			   callback: function(records, operation, success) {
            				   for(var i in records){
            					   if(records[i].data.id==getMonthValue){
            						   getMonthField.setValue(records[i].data.value);
            					   }
            				   }
            			   }	   
            		   });
                	
                	getYearField.setValue(getYearValue);
                },
       		 getMonthArrayEnquiryEducation: function(getMonthValue){
    			 var month=new Array(12);
    	         month[01]="JANUARY";
    	         month[02]="FEBRUARY";
    	         month[03]="MARCH";
    	         month[04]="APRIL";
    	         month[05]="MAY";
    	         month[06]="JUNE";
    	         month[07]="JULY";
    	         month[08]="AUGUST";
    	         month[09]="SEPTEMBER";
    	         month[10]="OCTOBER";
    	         month[11]="NOVEMBER";
    	         month[12]="DECEMBER";
    	         return month[getMonthValue];
    		 },
    		 setEnquiryYearOfEaxmDateMinvalue:function(obj){
    			 	var getYearValue = Ext.Date.format(new Date(), 'Y');
    		    	var getCurrentLastYearValue = getYearValue+'/12/31/';
    		    	obj.setMinValue(Ext.Date.format(new Date('1950/01/01'), 'Y-m-d'));
    		    	obj.setMaxValue(Ext.Date.format(new Date(getCurrentLastYearValue), 'Y-m-d'));
    		    	
    		    },
    		    educationDetailFormDFR : function(form) {
    		    	var $this = this;
    		    	form = $this.getEducationdetailform().getForm();
    		    	Ext.Ajax.request({
    		    		type: 'rest',
    		    		async: false,
    		    		url: SERVERURL.COMMON_FORM_FIELD_INFO,
    		    		params: {
    		    			screenName: 'educationdetailform',
    		    			academyLocationId: this.getCurrentAcademyLocation(),
    		    			languageCode:'en'
    		    		},
    		    		method: 'GET',
    		    		success: function(res, action) {
    		    			var response = Ext.decode(res.responseText);
    		    			if( Object.keys(response).length > 0 ){
    		    				var records=response.educationdetailform;
    		    				for(i in records){
    		    					if(records[i].formFieldInputType=='numberfield' && records[i].formFieldId=='subMaximumMarks'){
    		    						if(records[i].formFieldInputType=='numberfield' && records[i].formFieldId=='subMaximumMarks' && 
    		    								records[i].isVisible==true){
    		    							form.findField('subMaximumMarks').setVisible(true);
    		    							localStorage.setItem('isVisibleEnquirySubMaximumMarks',true);
    		    						}
    		    						if(records[i].formFieldInputType=='numberfield' && records[i].formFieldId=='subMaximumMarks' && 
    		    								records[i].isVisible==false){
    		    							form.findField('subMaximumMarks').setVisible(false);
    		    							localStorage.setItem('isVisibleEnquirySubMaximumMarks',false);
    		    						}
    		    					}
    		    				}
    		    			}else{
    		    				localStorage.setItem('isVisibleEnquirySubMaximumMarks',true);
    		    			}
    		    		}
    		    	});
					
				}
});
