/**
 * @author Vinay Kumrawat
 * 
 **/
Ext.define('Academia.controller.examinationattendancerule.ExaminationAttendanceRuleController', {
	extend : 'Academia.controller.base.BaseController',
	models : [
		    'attendancerulemodels.AttendanceRuleGridModel',
		    'attendancerulemodels.AttendanceRangeGridModel'
	],
	stores : [
	           'attendancerulestores.AttendanceRuleGridStore',
	           'attendancerulestores.AttendanceRangeGridStore',
	           'attendancerulestores.AttendanceRuleProgramAssociatedGridStore'
	],
	views : [
		'baselayout.contentarea.ContentPanel',
		'examinationattendancerule.AttendanceRuleStructure', 
		'examinationattendancerule.AttendanceRuleGrid',
		'examinationattendancerule.AttendanceRangeGrid',
		'examinationattendancerule.AttendanceRuleWindow',
		'examinationattendancerule.AttendanceRuleForm',
		'examinationattendancerule.AttendanceRangeWindow',
		'examinationattendancerule.AttendanceRuleForm',
		'examinationattendancerule.AttendanceRangeForm',
		'examinationattendancerule.AttendanceRuleApplyToStructure',
		'examinationattendancerule.AttendanceRuleAddMappingStructure',
		'examinationattendancerule.AttendanceRuleProgressTracker',
		'examinationattendancerule.AttendanceAddMappingTabStructure',
		'examinationattendancerule.AttendanceAddMappingAcademyLocationTab',
		'examinationattendancerule.AttendanceAddMappingProgramTab',
		'examinationattendancerule.AttendanceAddMappingProgramBatchTab',
		'examinationattendancerule.AttendanceRuleApplyToWindow',
		'examinationattendancerule.AttendanceRuleProgramsAssociatedGridWindow'
		
	],	
	config:{
		
		EXAMINATION_ATTENDANCE_RULE_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAMINATION_ATTENDANCE_RULE_PRIVILEGES'),
		EXAMINATION_ATTENDANCE_RANGE_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAMINATION_ATTENDANCE_RANGE_PRIVILEGES'),
		EXAMINATION_ATTENDANCE_RULE_PRIVILEGES_APPLY_TO: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAMINATION_ATTENDANCE_RULE_PRIVILEGES_APPLY_TO'),
	},	
	refs : [{
		ref: 'contentPanel',
		selector: 'contentPanel'
	},
	{
		ref: 'attendancerulestructure',
		selector: 'attendancerulestructure'
	},
	{
		ref: 'attendancerulegrid',
		selector: 'attendancerulegrid'
	},
	{
		ref: 'attendancerangegrid',
		selector: 'attendancerangegrid'
	},
	{
		ref: 'attendancerulewindow',
		selector: 'attendancerulewindow'
	},
	{
		ref: 'attendanceruleform',
		selector: 'attendanceruleform'
	},
	{
		ref: 'attendancerangewindow',
		selector: 'attendancerangewindow'
	},
	{
		ref: 'attendancerangeform',
		selector: 'attendancerangeform'
	},
	{
		ref: 'attendanceruleapplytostructure',
		selector: 'attendanceruleapplytostructure'
	},
	{
		ref: 'attendanceruleaddmappingstructure',
		selector: 'attendanceruleaddmappingstructure'
	},
	{
		ref: 'attendanceruleprogresstracker',
		selector: 'attendanceruleprogresstracker'
	},
	{
		ref: 'attendanceaddmappingtabstructure',
		selector: 'attendanceaddmappingtabstructure'
	},
	{
		ref: 'attendanceaddmappingacademylocationtab',
		selector: 'attendanceaddmappingacademylocationtab'
	},
	{
		ref: 'attendanceaddmappingprogramtab',
		selector: 'attendanceaddmappingprogramtab'
	},
	{
		ref: 'attendanceaddmappingprogrambatchtab',
		selector: 'attendanceaddmappingprogrambatchtab'
	},
	{
		ref: 'attendanceruleapplytowindow',
		selector: 'attendanceruleapplytowindow'
	},
	{
		ref: 'attendanceruleprogramsassociatedgridwindow',
		selector: 'attendanceruleprogramsassociatedgridwindow'
	}
	
	
	],
	init : function() {
		
		this.control({
			'attendancerulewindow':{
				 afterrender:function(window){
     				$this = this;
     				var filterForm = window.down('form');
     				window.body.on('click',function() {
   						$this.hideInvalidIconFromField(filterForm);
 			       });
     			} 
			},
			'attendancerangewindow':{
				 afterrender:function(window){
	     				$this = this;
	     				var filterForm = window.down('form');
	     				window.body.on('click',function() {
	   						$this.hideInvalidIconFromField(filterForm);
	 			       });
	     			} 
				},
			'attendancerulegrid button[itemId=btnAdd_dc]':{
				click: function(button){
					var me = this;
					var attendancerulewindow = me.showWindow('attendancerulewindow');
				}
			},
			'attendancerulegrid':{
				afterrender:function(obj){
					var me = this;
					obj.getStore().load();
				},
				
				cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
					var me = this;
					var attendancerulegrid = View.up('grid');
					if (e.target.tagName == 'A') {
						var attendanceRuleId = record.data.id;
						var attendanceruleprogramsassociatedgridwindow = me.showWindow('attendanceruleprogramsassociatedgridwindow');
						attendanceRuleProgramAssociatedGridStore = attendanceruleprogramsassociatedgridwindow.down('grid').getStore();
						attendanceRuleProgramAssociatedGridStore.removeAll();
						attendanceRuleProgramAssociatedGridStore.getProxy().extraParams = {
							attendanceRuleId: attendanceRuleId
						};
						attendanceRuleProgramAssociatedGridStore.load();
					}
 			   },
				   selectionchange: function(row, record){
	 				   var me = this;
	 				   try{
	 					   var attendancerulegrid = row.view.up('grid');
	 					   var btnEdit_dc= attendancerulegrid.down('#btnEdit_dc');
	 					   var btnDelete_dc= attendancerulegrid.down('#btnDelete_dc');
	 					   var btnApplyTo_dc= attendancerulegrid.down('#btnApplyTo_dc');

	 					   btnEdit_dc.setDisabled(!attendancerulegrid.getSelectionModel().getSelection().length);
	 					   btnDelete_dc.setDisabled(!attendancerulegrid.getSelectionModel().getSelection().length);
	 					   btnApplyTo_dc.setDisabled(!attendancerulegrid.getSelectionModel().getSelection().length);

	 					   var attendancerangegrid = attendancerulegrid.up('attendancerulestructure').down('attendancerangegrid');
	 					   var attendancerangegridStore = attendancerangegrid.getStore();
	 					   var btnAdd_cr = attendancerangegrid.down('#btnAdd_cr');
	 					   var btnEdit_cr = attendancerangegrid.down('#btnEdit_cr');
	 					   var btnDelete_cr = attendancerangegrid.down('#btnDelete_cr');
	 					  attendancerangegrid.getSelectionModel().deselectAll();
	 					   if(attendancerulegrid.getSelectionModel().getSelection().length){
	 						   var attendanceRuleId = record[0].data.id;
	 						  
	 						   btnAdd_cr.setDisabled(false);
	 						   /*var marks=me.getColumnByDataIndex(attendancerangegrid,'marks');
	 						   var rangeFromColumn = me.getColumnByDataIndex(attendancerangegrid,'attendanceRangeFrom');
	 						   var rangeToColumn = me.getColumnByDataIndex(attendancerangegrid,'attendanceRangeTo');*/
	 							   //rangeFromColumn.setText(getCommonTranslation('MARK_RANGE_FROM'));
	 							   //rangeToColumn.setText(getCommonTranslation('MARK_RANGE_TO'));
	 						
	 						  this.resetPageSetting(attendancerangegrid.getStore(), attendancerangegrid);
	 						  attendancerangegrid.getStore().load();     
	 						  attendancerangegridStore.getProxy().extraParams = {
	 								 attendanceRuleId: attendanceRuleId
	 						   }
	 						 attendancerangegridStore.load();
	 					   }
	 					   else{
	 						  attendancerangegridStore.removeAll();
	 						   btnAdd_cr.setDisabled(true);
	 						   btnEdit_cr.setDisabled(true);
	 						   btnDelete_cr.setDisabled(true);
	 						/*   var marks=me.getColumnByDataIndex(attendancerangegrid,'marks');
	 						   var rangeFromColumn = me.getColumnByDataIndex(attendancerangegrid,'attendanceRangeFrom');
	 						   var rangeToColumn = me.getColumnByDataIndex(attendancerangegrid,'attendanceRangeTo');*/

	 						 //  rangeFromColumn.setText(getCommonTranslation('RANGE_FROM'));
	 						   //rangeToColumn.setText(getCommonTranslation('RANGE_TO'));
	 					   }
	 				   }
	 				   catch(e){}
	 			   }
				
			},
			
			'attendancerangewindow button[itemId=attendanceRangeSubmitBtn]':{
				click: function(button){
					var me = this;
					var form = button.up('form');
					var formWindow = button.up('window');
					me.saveAttendanceRange(form, formWindow);
				}
			},
			
			'attendancerangegrid button[itemId=btnAdd_cr]':{
				click: function(button){
					var me = this;
				    var attendancerulegrid = button.up('attendancerulestructure').down('attendancerulegrid');
				    var attendancerulegridRecord = attendancerulegrid.getSelectionModel().getSelection()[0];
					
					var attendancerangewindow = me.showWindow('attendancerangewindow');
					attendancerangewindow.down('[name=attendanceRuleId]').setValue(attendancerulegridRecord.data.id);
					attendancerangewindow.down('[name=attendanceRuleName]').setValue(attendancerulegridRecord.data.attendanceRule);
					attendancerangewindow.down('[name=rangeFrom]').setMinValue(0);
					attendancerangewindow.down('[name=rangeFrom]').setMaxValue(99.99);
					attendancerangewindow.down('[name=rangeTo]').setMinValue(0.01);
					attendancerangewindow.down('[name=rangeTo]').setMaxValue(100);
					me.setAllowBlank(attendancerangewindow.down('[name=rangeFrom]'),false);
					me.setAllowBlank(attendancerangewindow.down('[name=rangeTo]'),false);
					
				}
			},
			'attendancerulegrid button[itemId=btnApplyTo_dc]':{
				click: function(button){
					var me = this;
					var attendancerulegrid = button.up('grid');
					var gridRecord=attendancerulegrid.getSelectionModel().getSelection()[0];
					if(attendancerulegrid.getSelectionModel().getCount() > 0){
						var attendanceRuleId = gridRecord.data.id;
						var attendanceRuleName = gridRecord.data.attendanceRule;
						var contentpanel = me.getContentPanel();
						var applyToTab = Ext.widget('attendanceruleapplytostructure',{
							attendanceRuleId:attendanceRuleId,
							attendanceRuleName: attendanceRuleName
						});
						var tabName = getCommonTranslation('APPLY_TO');
						var getcontroller=this.getController('menu.CoreERPNavigationController');
						var getTab=getcontroller.getTab(tabName);
						if(getTab!=null){
							contentpanel.remove(getTab, true);
						}
						openTab(contentpanel, tabName, applyToTab, CONSTANTS.MENU_COLOR_FOUR);
					}else{
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
			
			'attendanceruleapplytostructure':{
				afterrender: function(structure){
					var me = this;
					var applyToGrid = structure.down('grid');
					
					var attendanceRuleId = structure.attendanceRuleId;
					var applyToGridStore = applyToGrid.getStore();
					applyToGridStore.getProxy().extraParams={
						attendanceRuleId: attendanceRuleId
					};
						
					this.resetPageSetting(applyToGridStore, applyToGrid);
					applyToGridStore.load();
				
					var associatedAcadLocationIds = new Array();
					associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
					var permissionListThree = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
							associatedAcadLocationIds, me.getEXAMINATION_ATTENDANCE_RULE_PRIVILEGES_APPLY_TO());

					var btnAdd_Apply_To = structure.down('#btnAdd');
					var btnView_Apply_To = structure.down('#btnView');
					var btnDelete_Apply_To = structure.down('#btnDelete');

					btnAdd_Apply_To.setVisible(false);
					btnView_Apply_To.setVisible(false);
					btnDelete_Apply_To.setVisible(false);

					if((Ext.Array.contains(permissionListThree, 'CREATE'))){
						btnAdd_Apply_To.setVisible(true);
					}

					if((Ext.Array.contains(permissionListThree, 'VIEW'))){
						btnView_Apply_To.setVisible(true);
					}

					if((Ext.Array.contains(permissionListThree, 'DELETE'))){
						btnDelete_Apply_To.setVisible(true);
					}
				}
			},
			'attendancerulewindow button[itemId=attendanceRuleNameCancelBtn]':{
				click: function(button){
					var formWindow = button.up('window');
					formWindow.close();
				}
			},
			
			
			'attendancerangewindow button[itemId=attendanceRangeCancelBtn]':{
				click: function(button){
					var formWindow = button.up('window');
					formWindow.close();
				}
			},
			
			'attendancerulestructure':{
				afterrender: function(structure){
					var me = this;
					var associatedAcadLocationIds = new Array();
					associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
					var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
   	    					associatedAcadLocationIds, me.getEXAMINATION_ATTENDANCE_RULE_PRIVILEGES());
					var permissionListTwo = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
   	    					associatedAcadLocationIds, me.getEXAMINATION_ATTENDANCE_RANGE_PRIVILEGES());
					
					var btnAdd_dc = structure.down('#btnAdd_dc');
					var btnEdit_dc = structure.down('#btnEdit_dc');
           	    	var btnDelete_dc = structure.down('#btnDelete_dc');
           	    	var btnApplyTo_dc = structure.down('#btnApplyTo_dc');
           	    	var btnApplyTo_dc = structure.down('#btnApplyTo_dc');
           	    	var btnAdd_cr = structure.down('#btnAdd_cr');
					var btnEdit_cr = structure.down('#btnEdit_cr');
           	    	var btnDelete_cr = structure.down('#btnDelete_cr');
           	    	var exportToPdfBtn_dc = structure.down('attendancerulegrid').down('#btnExportToPDF');
           	    	var exportToXcelBtn_dc = structure.down('attendancerulegrid').down('#btnExportToExcel');
           	    	var exportToPdfBtn_cr = structure.down('attendancerangegrid').down('#btnExportToPDF');
           	    	var exportToXcelBtn_cr = structure.down('attendancerangegrid').down('#btnExportToExcel');
           	    	
           	    	btnAdd_dc.setVisible(false);
           	    	btnEdit_dc.setVisible(false);
           	    	btnDelete_dc.setVisible(false);
           	    	btnApplyTo_dc.setVisible(false);
           	    	btnAdd_cr.setVisible(false);
           	    	btnEdit_cr.setVisible(false);
           	    	btnDelete_cr.setVisible(false);
           	    	exportToPdfBtn_dc.setVisible(false);
           	    	exportToXcelBtn_dc.setVisible(false);
           	    	exportToPdfBtn_cr.setVisible(false);
           	    	exportToXcelBtn_cr.setVisible(false);
           	    	
           	    	if((Ext.Array.contains(permissionList, 'CREATE'))){
           	    		btnAdd_dc.setVisible(true);
	        		}
           	    	
           	    	if((Ext.Array.contains(permissionList, 'UPDATE'))){
           	    		btnEdit_dc.setVisible(true);
	        		}
           	    	
           	    	if((Ext.Array.contains(permissionList, 'DELETE'))){
           	    		btnDelete_dc.setVisible(true);
	        		}
           	    	if((Ext.Array.contains(permissionList, 'APPLY'))){
           	    		btnApplyTo_dc.setVisible(true);
	        		}
           	    	if((Ext.Array.contains(permissionListTwo, 'CREATE'))){
           	    		btnAdd_cr.setVisible(true);
	        		}
           	    	
           	    	if((Ext.Array.contains(permissionListTwo, 'UPDATE'))){
           	    		btnEdit_cr.setVisible(true);
	        		}
           	    	if((Ext.Array.contains(permissionListTwo, 'DELETE'))){
           	    		btnDelete_cr.setVisible(true);
	        		}

           	    	if((Ext.Array.contains(permissionList, 'EXPORT'))){
           	    		exportToPdfBtn_dc.setVisible(true);
           	    		exportToXcelBtn_dc.setVisible(true);
           	    	}
           	    	if((Ext.Array.contains(permissionListTwo, 'EXPORT'))){
           	    		exportToPdfBtn_cr.setVisible(true);
           	    		exportToXcelBtn_cr.setVisible(true);
           	    	}
				}
			},
			
			'attendanceruleaddmappingstructure':{
				afterrender: function(structure){
					var me = this;
					
					var attendanceruleprogresstracker = structure.down('attendanceruleprogresstracker');
					attendanceruleprogresstracker.setVisible(true);
					var progresstracker1 = attendanceruleprogresstracker.down("#progresstracker1");
					var progresstracker2 = attendanceruleprogresstracker.down("#progresstracker2");
					var progresstracker3 = attendanceruleprogresstracker.down("#progresstracker3");
					
					progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
					progresstracker1.textEl.addCls("inProgressCss-progress-text");
					progresstracker1.updateText("Step 1 In Progress");
					
					progresstracker2.textEl.removeCls("inProgressCss-progress-text");
					progresstracker2.textEl.addCls("x-progress-text x-progress-text-back");
					progresstracker2.updateText("");
					
					progresstracker3.textEl.removeCls("inProgressCss-progress-text");
					progresstracker3.textEl.addCls("x-progress-text x-progress-text-back");
					progresstracker3.updateText("");
					
					var academyLocationTab = structure.down('attendanceaddmappingacademylocationtab');
					var programTab = structure.down('attendanceaddmappingprogramtab');
					var programBatchTab = structure.down('attendanceaddmappingprogrambatchtab');
					
					academyLocationTab.down('#attendanceRuleNameLabel').setText(getExaminationTranslation('ATTENDANCE_RULE')+': '+structure.attendanceRuleName);
					
					academyLocationTab.setDisabled(false);
					programTab.setDisabled(true);
					programBatchTab.setDisabled(true);
					
					academyLocationTab.down('grid').getStore().load();
					academyLocationTab.down('#academyLocationCombo').getStore().load();
				}
			},
			
			'attendanceruleapplytostructure button[itemId=btnAdd]':{
				click: function(button){
					var me = this;
					var applyToStructure = button.up('attendanceruleapplytostructure');
					var attendanceRuleId = applyToStructure.attendanceRuleId;
					var attendanceRuleName = applyToStructure.attendanceRuleName;
					var contentpanel = me.getContentPanel();
					var addMappingTab = Ext.widget('attendanceruleaddmappingstructure',{
						attendanceRuleId:attendanceRuleId,
						attendanceRuleName: attendanceRuleName
					});
					var tabName = getExaminationTranslation('ADD_MAPPINGS');
					var getcontroller=this.getController('menu.CoreERPNavigationController');
					var getTab=getcontroller.getTab(tabName);
					if(getTab!=null){
						contentpanel.remove(getTab, true);
					}
					openTab(contentpanel, tabName, addMappingTab, CONSTANTS.MENU_COLOR_FOUR);
				}
			},
			'attendanceaddmappingacademylocationtab grid':{
				selectionchange: function(row, record){
					var me = this;
					try{
						var attendanceaddmappingacademylocationtabgrid = row.view.up('grid');

						var btnNext= attendanceaddmappingacademylocationtabgrid.down('#academyLocationNextBtn');

						btnNext.setDisabled(!attendanceaddmappingacademylocationtabgrid.getSelectionModel().getSelection().length);
					}
					catch(e){}
				}
			},
			'attendanceaddmappingacademylocationtab button[itemId=academyLocationResetBtn]':{
				click: function(button){
					var me = this;
					var grid = button.up('grid');
					grid.getStore().clearFilter();
					
					grid.down('#academyLocationCombo').reset();
					grid.down('#academyLocationCombo').clearValue();
					grid.down('#academyLocationCombo').getStore().clearFilter();
					
					grid.getSelectionModel().deselectAll();
				}
			},
			'attendanceaddmappingacademylocationtab combo[itemId=academyLocationCombo]':{
				select: function(combo){
					var me = this;
					var alId = combo.getValue();

					var grid = combo.up('grid');
					var store = grid.getStore();
					store.clearFilter();
					store.filterBy(function(record, id){
						return (record.get('id') == alId);
					});
					//manually showing total count for V2D-301647
					var gridDom = grid.el ? grid.el.dom : null;
					gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ store.getCount();
					grid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ store.getCount());

				}
			},
			
			'attendanceaddmappingprogramtab combo[itemId=programCombo]':{
				select: function(combo){
					var me = this;
					var programId = combo.getValue();

					var grid = combo.up('grid');
					var store  = grid.getStore();
					grid.getStore().clearFilter();
					grid.getStore().filterBy(function(record, id){
						return (record.get('id') == programId);
					});
					var gridDom = grid.el ? grid.el.dom : null;
	 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ store.getCount();
					grid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ store.getCount());	
				}
			},
			
			'attendanceaddmappingprogrambatchtab combo[itemId=batchCombo]':{
				select: function(combo){
					var me = this;
					var batchId = combo.getValue();

					var grid = combo.up('grid');                           
					var store = grid.getStore();                           
					store.clearFilter();                                   
					store.filterBy(function(record, id){                   
						return (record.get('batchId') == batchId);               
					});
					var gridDom = grid.el ? grid.el.dom : null;
	 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ store.getCount();	
				
				}
			},
			'attendanceaddmappingacademylocationtab button[itemId=academyLocationNextBtn]':{
				click: function(button){
					var me = this;
					var grid = button.up('grid');
					var attendanceaddmappingtabstructure = button.up('attendanceaddmappingtabstructure');
					
					var selectedRecords = grid.getSelectionModel().getSelection();
					var selectedAls = [];
					Ext.each(selectedRecords, function(selectedRecord){
						selectedAls.push(selectedRecord.get('id'));
					});
					
					var structure = button.up('attendanceruleaddmappingstructure');
					
					var attendanceruleprogresstracker = structure.down('attendanceruleprogresstracker');
					attendanceruleprogresstracker.setVisible(true);
					var progresstracker1 = attendanceruleprogresstracker.down("#progresstracker1");
					var progresstracker2 = attendanceruleprogresstracker.down("#progresstracker2");
					var progresstracker3 = attendanceruleprogresstracker.down("#progresstracker3");
					
					for(var i = 0; i < 11; i ++ ){
		    			progresstracker1.updateProgress((i * 0.1), '');
		    		}
		    		progresstracker1.textEl.addCls("custom-progress-text");
		    		progresstracker1.textEl.removeCls("inProgressCss-progress-text");
		    		progresstracker2.textEl.removeCls("x-progress-text x-progress-text-back");
		    		progresstracker2.textEl.addCls("inProgressCss-progress-text");
		    		progresstracker2.updateText("Step 2 In Progress");
		    		progresstracker1.updateText(getCommonTranslation('STEP_1_COMPLETE'));
					
					progresstracker3.textEl.removeCls("inProgressCss-progress-text");
					progresstracker3.textEl.addCls("x-progress-text x-progress-text-back");
					progresstracker3.updateText("");
					
					var academyLocationTab = structure.down('attendanceaddmappingacademylocationtab');
					var programTab = structure.down('attendanceaddmappingprogramtab');
					var programBatchTab = structure.down('attendanceaddmappingprogrambatchtab');
					
					programTab.down('#attendanceRuleNameLabel').setText(getExaminationTranslation('ATTENDANCE_RULE')+': '+structure.attendanceRuleName);
					
					academyLocationTab.setDisabled(false);
					programTab.setDisabled(false);
					programBatchTab.setDisabled(true);
					
					attendanceaddmappingtabstructure.setActiveTab(1);
					
					programTab.down('grid').getStore().getProxy().extraParams={
						'academyLocationIds':selectedAls.join()
					};
					programTab.down('grid').getStore().load();
					programTab.down('#programCombo').getStore().getProxy().extraParams={
						'academyLocationIds':selectedAls.join()
					};
					programTab.down('#programCombo').getStore().load();
				}
			},
			
			'attendanceaddmappingprogramtab grid':{
				selectionchange: function(row, record){
					var me = this;
					try{
						var attendanceaddmappingprogramtabgrid = row.view.up('grid');

						var btnNext= attendanceaddmappingprogramtabgrid.down('#programNextBtn');
						var btnSubmit = attendanceaddmappingprogramtabgrid.down('#programSubmitBtn');

						btnNext.setDisabled(!attendanceaddmappingprogramtabgrid.getSelectionModel().getSelection().length);
						btnSubmit.setDisabled(!attendanceaddmappingprogramtabgrid.getSelectionModel().getSelection().length);
					}
					catch(e){}
				}
			},
			'attendanceaddmappingprogramtab button[itemId=programResetBtn]':{
				click: function(button){
					var me = this;
					var grid = button.up('grid');
					grid.getStore().clearFilter();
					
					grid.down('#programCombo').reset();
					grid.down('#programCombo').clearValue();
					grid.down('#programCombo').getStore().clearFilter();
					
					grid.getSelectionModel().deselectAll();
				}
			},
			'attendanceaddmappingprogramtab button[itemId=programNextBtn]':{
				click: function(button){
					var me = this;
					var grid = button.up('grid');
					var attendanceaddmappingtabstructure = button.up('attendanceaddmappingtabstructure');
					
					var selectedRecords = grid.getSelectionModel().getSelection();
					var selectedAls = [];
					Ext.each(selectedRecords, function(selectedRecord){
						selectedAls.push(selectedRecord.get('id'));
					});
					
					var structure = button.up('attendanceruleaddmappingstructure');
					
					var attendanceruleprogresstracker = structure.down('attendanceruleprogresstracker');
					attendanceruleprogresstracker.setVisible(true);
					var progresstracker1 = attendanceruleprogresstracker.down("#progresstracker1");
					var progresstracker2 = attendanceruleprogresstracker.down("#progresstracker2");
					var progresstracker3 = attendanceruleprogresstracker.down("#progresstracker3");
					
					for(var i = 0; i < 11; i ++ ){
		    			progresstracker1.updateProgress((i * 0.1), '');
		    		}
		    		progresstracker1.textEl.addCls("custom-progress-text");
		    		progresstracker1.textEl.removeCls("inProgressCss-progress-text");
		    		progresstracker1.updateText(getCommonTranslation('STEP_1_COMPLETE'));
		    		for(var i = 0; i < 11; i ++ ){
		    			progresstracker2.updateProgress((i * 0.1), '');
		    		}
		    		progresstracker2.textEl.addCls("custom-progress-text");
		    		progresstracker2.textEl.removeCls("inProgressCss-progress-text");
		    		progresstracker2.updateText(getCommonTranslation('STEP_2_COMPLETE'));
					
		    		progresstracker3.textEl.removeCls("x-progress-text x-progress-text-back");
		    		progresstracker3.textEl.addCls("inProgressCss-progress-text");
		    		progresstracker3.updateText("Step 3 In Progress");
					
					var academyLocationTab = structure.down('attendanceaddmappingacademylocationtab');
					var programTab = structure.down('attendanceaddmappingprogramtab');
					var programBatchTab = structure.down('attendanceaddmappingprogrambatchtab');
					
					programBatchTab.down('#attendanceRuleNameLabel').setText(getExaminationTranslation('ATTENDANCE_RULE')+': '+structure.attendanceRuleName);
					
					academyLocationTab.setDisabled(false);
					programTab.setDisabled(false);
					programBatchTab.setDisabled(false);
					
					attendanceaddmappingtabstructure.setActiveTab(2);
					
					programBatchTab.down('grid').getStore().getProxy().extraParams={
						'programIds':selectedAls.join()
					};
					programBatchTab.down('grid').getStore().load();
					programBatchTab.down('#batchCombo').getStore().getProxy().extraParams={
						'programIds':selectedAls.join()
					};
					programBatchTab.down('#batchCombo').getStore().load();
				}
			},
			
			
			'attendanceaddmappingprogrambatchtab grid':{
				selectionchange: function(row, record){
					var me = this;
					try{
						var attendanceaddmappingprogrambatchtabgrid = row.view.up('grid');

						var btnSubmit= attendanceaddmappingprogrambatchtabgrid.down('#batchSubmitBtn');

						btnSubmit.setDisabled(!attendanceaddmappingprogrambatchtabgrid.getSelectionModel().getSelection().length);
					}
					catch(e){}
				}
			},
			'attendanceaddmappingprogrambatchtab button[itemId=batchResetBtn]':{
				click: function(button){
					var me = this;
					var grid = button.up('grid');
					grid.getStore().clearFilter();
					
					grid.down('#batchCombo').reset();
					grid.down('#batchCombo').clearValue();
					grid.down('#batchCombo').getStore().clearFilter();
					
					grid.getSelectionModel().deselectAll();
				}
			},
			'attendanceaddmappingprogrambatchtab button[itemId=batchSubmitBtn]':{
				click: function(button){
					var me = this;
					var grid = button.up('grid');
					var mainGridRecord=me.getAttendancerulegrid().getSelectionModel().getSelection()[0];
					var gridRecord = grid.getSelectionModel().getSelection();
					var attendanceRuleId = button.up('attendanceruleaddmappingstructure').attendanceRuleId 
					
					var formData = [];
					Ext.each(gridRecord, function(currentRecord){
						formData.push({
							attendanceRuleId:attendanceRuleId,
							academyLocationId:currentRecord.get('academyLocationId'),
							programId:currentRecord.get('programId'),
							batchId:currentRecord.get('batchId'),
							attendanceRuleName:mainGridRecord.data.attendanceRule
						});
					});
					me.saveAllMappings(formData);
				}
			},
			
			'attendancerulewindow button[itemId=attendanceRuleNameSubmitBtn]':{
				click: function(button){
					var me = this;
					var form = button.up('form');
					var formWindow = button.up('window');
					me.saveAttendanceRule(form, formWindow);
				}
			},
			'attendancerangewindow button[itemId=attendanceRangeSubmitBtn]':{
				click: function(button){
					var me = this;
					var form = button.up('form');
					var formWindow = button.up('window');
					me.saveAttendanceRange(form, formWindow);
				}
			},
			'attendancerulegrid button[itemId=btnEdit_dc]':{
				click: function(button){
					var me = this;
					var attendancerulegrid = button.up('grid');
					var attendancerangegrid = me.getAttendancerangegrid();
					var selectedRecord = attendancerulegrid.getSelectionModel().getSelection()[0];
					var attendancerulewindow = me.showWindow('attendancerulewindow');
					var form = attendancerulewindow.down('form');
					var attendanceRuleNameId = form.down('#attendanceRuleNameId');
					attendanceRuleNameId.setValue(selectedRecord.data.attendanceRule);
					var id=form.down('#id');
					id.setValue(selectedRecord.data.id);
					
					
				}
			},
			
			'attendancerulegrid button[itemId=btnDelete_dc]':{
				click: function(button){
					var me = this;

					var attendancerulegrid = button.up('grid');
					var gridRecord=attendancerulegrid.getSelectionModel().getSelection()[0];
					var jsonData=[];
					if(attendancerulegrid.getSelectionModel().getCount() > 0){
						var submitUrl = SERVERURL.ATTENDANCE_RULE_DELETE;
						showConfirmMessage(getExaminationTranslation('ATTENDANCE_RULE'), getCommonTranslation('DEGREE_CLASSIFICATION_DELETE_ALERT'),function(btn,text){
							if (btn == 'yes') {
								Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
								Ext.Ajax.request({
									type : 'rest',
									url : submitUrl+ '?id='+ gridRecord.data.id,
									method : 'DELETE',
									success : function(response, action) {
										Ext.getBody().unmask();
										attendancerulegrid.getStore().loadPage(1);
										attendancerulegrid.getSelectionModel().deselectAll();
										showSuccessMessage(getExaminationTranslation('ATTENDANCE_RULE'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
									}
								});
							}
						});
					}else{
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
			'attendancerangegrid':{
				afterrender:function(obj){
					var me = this;
					obj.getStore().removeAll();
				},
				selectionchange: function(row, record){
					var me = this;
					try{
						var attendancerangegrid = row.view.up('grid');

						var btnEdit_cr= attendancerangegrid.down('#btnEdit_cr');
						var btnDelete_cr= attendancerangegrid.down('#btnDelete_cr');

						btnEdit_cr.setDisabled(!attendancerangegrid.getSelectionModel().getSelection().length);
						btnDelete_cr.setDisabled(!attendancerangegrid.getSelectionModel().getSelection().length);
					}
					catch(e){}
				}
			},
			
			'attendancerangegrid button[itemId=btnEdit_cr]':{
				click: function(button){
					var me = this;
					var attendancerulegrid = button.up('attendancerulestructure').down('attendancerulegrid');
					var attendancerulegridRecord = attendancerulegrid.getSelectionModel().getSelection()[0];
					
					var attendancerangegrid = button.up('attendancerangegrid');
					var selectedRecord = attendancerangegrid.getSelectionModel().getSelection()[0];
					
					var formRecord = {
							id:selectedRecord.data.id,
							attendanceRuleId: attendancerulegridRecord.data.id,
							attendanceRuleName:attendancerulegridRecord.data.attendanceRule,
							marks:selectedRecord.data.marks,
							rangeFrom:selectedRecord.data.rangeFrom,
							rangeTo:selectedRecord.data.rangeTo,
					
					};
					
					var attendancerangewindow = me.showWindow('attendancerangewindow');
					var form = attendancerangewindow.down('form');
					form.getForm().setValues(formRecord);
					attendancerangewindow.down('[name=rangeFrom]').setMinValue(0);
					attendancerangewindow.down('[name=rangeFrom]').setMaxValue(99.99);
					attendancerangewindow.down('[name=rangeTo]').setMinValue(0.01);
					attendancerangewindow.down('[name=rangeTo]').setMaxValue(100);
					
					me.setAllowBlank(attendancerangewindow.down('[name=rangeFrom]'),false);
					me.setAllowBlank(attendancerangewindow.down('[name=rangeTo]'),false);
				}
			},
			
			'attendancerangegrid button[itemId=btnDelete_cr]':{
				click: function(button){
					var me = this;

					var attendancerangegrid = button.up('grid');
					var gridRecord=attendancerangegrid.getSelectionModel().getSelection()[0];
					var jsonData=[];
					if(attendancerangegrid.getSelectionModel().getCount() > 0){
						var submitUrl = SERVERURL.ATTENDANCE_RANGE_DELETE;
						showConfirmMessage(getExaminationTranslation('ATTENDANCE_RANGE'), getCommonTranslation('DEGREE_CLASSIFICATION_DELETE_ALERT'),function(btn,text){
							if (btn == 'yes') {
								Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
								Ext.Ajax.request({
									type : 'rest',
									url : submitUrl+ '?id='+ gridRecord.data.id,
									method : 'DELETE',
									success : function(response, action) {
										Ext.getBody().unmask();
										attendancerangegrid.getStore().loadPage(1);
										attendancerangegrid.getSelectionModel().deselectAll();
										showSuccessMessage(getExaminationTranslation('ATTENDANCE_RANGE'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
									}
								});
							}
						});
					}else{
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
			
			'attendanceaddmappingprogramtab button[itemId=programSubmitBtn]':{
				click: function(button){
					var me = this;
					var grid = button.up('grid');
					
					var mainGridRecord=me.getAttendancerulegrid().getSelectionModel().getSelection()[0];
					var gridRecord = grid.getSelectionModel().getSelection();
					var attendanceRuleId = button.up('attendanceruleaddmappingstructure').attendanceRuleId;
					
					var formData = [];
					Ext.each(gridRecord, function(currentRecord){
						formData.push({
							attendanceRuleId:attendanceRuleId,
							academyLocationId:currentRecord.get('secondId'),
							programId:currentRecord.get('id'),
							attendanceRuleName:mainGridRecord.data.attendanceRule
						});
					});
					
					me.saveAllMappings(formData);
				}
			},
			'attendanceruleapplytostructure grid':{
				selectionchange: function(row, record){
					var me = this;
					try{
						var applyToGrid = row.view.up('grid');

						var btnView= applyToGrid.down('#btnView');
						var btnDelete= applyToGrid.down('#btnDelete');

						btnView.setDisabled(!applyToGrid.getSelectionModel().getSelection().length);
						btnDelete.setDisabled(!applyToGrid.getSelectionModel().getSelection().length);
					}
					catch(e){}
				}
			},
			
			'attendanceruleapplytostructure button[itemId=btnDelete]':{
				click: function(button){
					var me = this;
					
					var applyToGrid = button.up('grid');
					var gridRecord=applyToGrid.getSelectionModel().getSelection()[0];
					if(applyToGrid.getSelectionModel().getCount() > 0){
						var submitUrl = SERVERURL.ASSOCIATED_PROGRAM_MAPPING_DELETE;
						showConfirmMessage(getExaminationTranslation('APPLY_TO'), getCommonTranslation('DEGREE_CLASSIFICATION_DELETE_ALERT'),function(btn,text){
							if (btn == 'yes') {
								Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
								Ext.Ajax.request({
									type : 'rest',
									url : submitUrl+ '?id='+ gridRecord.data.id,
									method : 'DELETE',
									success : function(response, action) {
										Ext.getBody().unmask();
										applyToGrid.getStore().loadPage(1);
										applyToGrid.getSelectionModel().deselectAll();
										showSuccessMessage(getExaminationTranslation('APPLY_TO'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
									}
								});
							}
						});
					}else{
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
			
			'attendanceruleapplytowindow button[itemId=applyToWindowCancelBtn]':{
				click: function(button){
					var window = button.up('attendanceruleapplytowindow');
					window.close();
				}
			},
			
			'attendanceruleapplytostructure button[itemId=btnView]':{
				click: function(button){
					var me = this;
					var applyToStructure = button.up('attendanceruleapplytostructure');
					var applyToGrid = button.up('grid');
					var applyToRecord = applyToGrid.getSelectionModel().getSelection()[0];
					
					var formRecord = {
							attendanceRuleName: applyToStructure.attendanceRuleName,
							academyLocationName:applyToRecord.get('academyLocationName'),
							programName:applyToRecord.get('programName'),
							batchName:applyToRecord.get('batchName')
					};
					var attendanceruleapplytowindow = me.showWindow('attendanceruleapplytowindow');
					setTimeout(function(){
						var form = attendanceruleapplytowindow.down('form');
						form.getForm().setValues(formRecord);
					},300);
				}
			},
			
			'attendancerangewindow numberfield[name=rangeFrom]':{
				change: function(obj){
					var rangeFromField = obj;
					var rangeToField = obj.up('form').down('[name=rangeTo]');
					var rangeFrom = rangeFromField.getValue();
					var rangeTo = rangeToField.getValue();
					

	               if(rangeFrom!="" && rangeFrom!=null && rangeTo!="" && rangeTo!=null){
							if(parseFloat((rangeTo-0.01).toFixed(2))>=0){
							rangeFromField.setMaxValue(parseFloat((rangeTo-0.01).toFixed(2)));
						}
					}
					if(rangeFrom!="" && rangeFrom!=null && rangeTo!="" && rangeTo!=null){
						if(parseFloat((rangeFrom+0.01).toFixed(2))<=100){
						rangeToField.setMinValue(parseFloat((rangeFrom+0.01).toFixed(2)));
						}
					}
					if(rangeFrom!="" && rangeFrom!=null){
						if(!obj.up('form').isValid()){
							obj.up('form').down('#attendanceRangeSubmitBtn').setDisabled(true);
						}
					}
					else{
						if(obj.up('form').isValid()){
							obj.up('form').down('#attendanceRangeSubmitBtn').setDisabled(false);
						}
						
					}
					
					if(rangeTo!="" && rangeTo!=null){
						if(!obj.up('form').isValid()){
							obj.up('form').down('#attendanceRangeSubmitBtn').setDisabled(true);
						}
					}
					else{
						if(obj.up('form').isValid()) {
							obj.up('form').down('#attendanceRangeSubmitBtn').setDisabled(false);
						}
						
					}
					
					
					try{
						if(rangeFrom!="" && rangeFrom!=null && rangeTo!="" && rangeTo!=null ){
							obj.up('form').isValid();
						}
					}
					catch(e){}
				}
			},
			
			'attendancerangewindow numberfield[name=rangeTo]':{
				change: function(obj){
					var rangeFromField = obj.up('form').down('[name=rangeFrom]');
					var rangeToField = obj;
					var rangeFrom = rangeFromField.getValue();
					var rangeTo = rangeToField.getValue();
					
					var marksField = obj.up('form').down('[name=marks]');
					var marks = marksField.getValue();
					
					if(rangeFrom!="" && rangeFrom!=null && rangeTo!="" && rangeTo!=null){
						if(parseFloat((rangeFrom+0.01).toFixed(2))<=100){
						rangeToField.setMinValue(parseFloat((rangeFrom+0.01).toFixed(2)));
					}
					}
					if(rangeFrom!="" && rangeFrom!=null && rangeTo!="" && rangeTo!=null){
						if(parseFloat((rangeTo-0.01).toFixed(2))>=0){
							rangeFromField.setMaxValue(parseFloat((rangeTo-0.01).toFixed(2)));
						}
					}
					if(rangeFrom!="" && rangeTo!=null){
						if(!rangeFromField.isValid() || !rangeToField.isValid()){
							obj.up('form').down('#attendanceRangeSubmitBtn').setDisabled(true);
						}
						
					}
					else{
						if(obj.up('form').isValid()) {
							obj.up('form').down('#attendanceRangeSubmitBtn').setDisabled(false);
						}
						
					}
					
					
					if(rangeTo!="" && rangeFrom!=null){
						if(!rangeToField.isValid()){
							obj.up('form').down('#attendanceRangeSubmitBtn').setDisabled(true);
						}
						if(marks == null || marks == ""){
							obj.up('form').down('#attendanceRangeSubmitBtn').setDisabled(true);
						}
					}
					else{
						if(obj.up('form').isValid()) {
							obj.up('form').down('#attendanceRangeSubmitBtn').setDisabled(false);
						}
						
					}
					
					try{
						if(rangeFrom!="" && rangeFrom!=null && rangeTo!="" && rangeTo!=null){
							obj.up('form').isValid();
						}
					}
					catch(e){}
				}
			},
		})
	},
	
	
	
	saveAttendanceRule: function(form, formWindow) {
		
		var me = this;
		var formValues = form.getForm().getValues();
		var btn = formWindow.down('#attendanceRuleNameSubmitBtn');
		btn.setDisabled(true);

		var id = formValues.id;
		var attendanceRuleName = formValues.attendanceRuleName;
		var regex = /[^a-zA-Z0-9\s!@#$%^&*-]+/;
		
        if(regex.test(attendanceRuleName)){ // special character exists
            showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NAME_CONTAINS_SPECIAL_CHARACTERS'));
			btn.setDisabled(false);
        }else{
            var submitUrl, isUpdate = false;
            if (isNullOrEmpty(id)) {
                submitUrl = SERVERURL.ATTENDANCE_RULE_CREATE,
                isUpdate = false;
                var formData = {
                        id:id,
                        attendanceRule: attendanceRuleName,
                };
            } else {
                submitUrl = SERVERURL.ATTENDANCE_RULE_UPDATE,
                isUpdate = true;
                var formData = {
                        id:id,
                        attendanceRule: attendanceRuleName,
                };
            }

            Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            Ext.Ajax.request({
                type: 'rest',
                url: submitUrl,
                jsonData: formData,
                method: 'POST',
                success: function(response, form) {
                    Ext.getBody().unmask();
                    if(response.responseText=="Success"){
                        if (isUpdate) {
                            showSuccessMessage(getExaminationTranslation('ATTENDANCE_RULE'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
                        } else {
                            showSuccessMessage(getExaminationTranslation('ATTENDANCE_RULE'), getCommonTranslation('SUCCESS'));
                        }
                        formWindow.close();
                        me.getAttendancerulegrid().getSelectionModel().deselectAll();
                        me.getAttendancerulegrid().getStore().loadPage(1);
                    }
                    else{
                        showWarningMessage(getCommonTranslation('ALERT'),response.responseText);
                    }
                }
            });
        }
	},
	saveAttendanceRange: function(form, formWindow) {
		var me = this;
		var btn = formWindow.down('#attendanceRangeSubmitBtn');
		btn.setDisabled(true);
		var formValues = form.getForm().getValues();

		var id = formValues.id;
		var attendanceRuleId = formValues.attendanceRuleId;
		var rangeFrom = formValues.rangeFrom;
		var rangeTo = formValues.rangeTo;
		var marks=formValues.marks;
		var submitUrl, isUpdate = false;
		if (isNullOrEmpty(id)) {
			submitUrl = SERVERURL.ATTENDANCE_RANGE_CREATE,
			isUpdate = false;
			var formData = {
					attendanceRuleId: attendanceRuleId,
					rangeFrom: rangeFrom,
					rangeTo: rangeTo,
					marks:marks
			};
		} else {
			submitUrl = SERVERURL.ATTENDANCE_RANGE_UPDATE,
			isUpdate = true;
			var formData = {
					id:id,
					attendanceRuleId: attendanceRuleId,
					rangeFrom: rangeFrom,
					rangeTo: rangeTo,
					marks:marks
			};
		}

		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		btn.setDisabled(false);
		Ext.Ajax.request({
			type: 'rest',
			url: submitUrl,
			jsonData: formData,
			method: 'POST',
			success: function(response, form) {
				Ext.getBody().unmask();
				if(response.responseText=="success"){
					if (isUpdate) {
						showSuccessMessage(getExaminationTranslation('ATTENDANCE_RANGE'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
					} else {
						showSuccessMessage(getExaminationTranslation('ATTENDANCE_RANGE'), getCommonTranslation('SUCCESS'));
					}
					formWindow.close();
					me.getAttendancerangegrid().getSelectionModel().deselectAll();
					me.getAttendancerangegrid().getStore().loadPage(1);
				}
				else{
					showWarningMessage(getCommonTranslation('ALERT'),response.responseText);
					btn.setDisabled(false);
				}
			},
			failure: function(response){
				console.log(response);
				
			}
		});
	},
	
	getColumnByDataIndex : function(grid,dataIndex){},
	saveAllMappings: function(formData){
		
		var me = this;
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.ASSOCIATED_PROGRAM_SAVE_ALL_MAPPING,
			jsonData: formData,
			method: 'POST',
			success: function(response, form) {
				Ext.getBody().unmask();
				var responseJson = Ext.decode(response.responseText);
				if(responseJson.length==0){
					showSuccessMessage(getCommonTranslation('ADD_MAPPING'), getExaminationTranslation('ATTENDANCE_RULE_MAPPED_SUCCESS_MSG'));	
					try{
						me.getContentPanel().getActiveTab().close();
						me.getAttendanceruleapplytostructure().down('grid').getStore().loadPage(1);
					}
					catch(e){}
				}
				else if(responseJson.length>0){
					
					var notMappedArray = [];
					Ext.each(responseJson, function(currentRecord){
						if(currentRecord.attendanceRuleId!=me.getContentPanel().getActiveTab().down('attendanceruleaddmappingstructure').attendanceRuleId){
							notMappedArray.push(currentRecord);
						}
					});
					
					if(notMappedArray.length==0){
						showWarningMessage(getCommonTranslation('ADD_MAPPING'), getExaminationTranslation('ATTENDANCE_RULE_ALREADY_MAPPED_MSG'));	
						try{
							me.getContentPanel().getActiveTab().close();
							me.getAttendanceruleapplytostructure().down('grid').getStore().loadPage(1);
						}
						catch(e){}
					}
					else{
						var responseJson = notMappedArray;
						var messageText = "Other Degree Classification is already mapped with the following programs and batches<br />";
						messageText = messageText + "<p style=\"height: auto;max-height:100px;display:block;float:left;width:100%;overflow-y:auto;\">";
						Ext.each(responseJson, function(currentBatchDetail){
							messageText = messageText+currentBatchDetail.programName+" and "+currentBatchDetail.batchName+"<br />";
						});
						messageText = messageText+"</p><br />Do you still want to map the degree classification with the selected programs and batches?";

						var newFormData = [];
						Ext.each(responseJson, function(currentRecord){
							newFormData.push({
								attendanceRuleId:me.getContentPanel().getActiveTab().down('attendanceruleaddmappingstructure').attendanceRuleId,
								academyLocationId:currentRecord.academyLocationId,
								programId:currentRecord.programId,
								batchId:currentRecord.batchId,
								id:currentRecord.attendanceRuleBatchMappingId
							});
						});

						showConfirmMessage(getCommonTranslation('APPLY_TO'),messageText, function(btn, text) {
							if (btn == 'yes') {
								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
								Ext.Ajax.request({
									type: 'rest',
									url: SERVERURL.ASSOCIATED_PROGRAM_UPDATE_MAPPING,
									jsonData: newFormData,
									method: 'POST',
									success: function(form, action) {
										Ext.getBody().unmask();
										showSuccessMessage(getCommonTranslation('ADD_MAPPING'), getExaminationTranslation('ATTENDANCE_RULE_MAPPED_SUCCESS_MSG'));	
										try{
											me.getContentPanel().getActiveTab().close();
											me.getAttendanceruleapplytostructure().down('grid').getStore().loadPage(1);
										}
										catch(e){}
									}
								});
							}
							else{
								Ext.getBody().unmask();
								//showSuccessMessage(getCommonTranslation('ADD_MAPPING'), getCommonTranslation('DEGREE_CLASSIFICATION_MAPPED_SUCCESS_MSG'));	
								try{
									me.getContentPanel().getActiveTab().close();
									me.getAttendanceruleapplytostructure().down('grid').getStore().loadPage(1);
								}
								catch(e){}
							}
						});
					}
				}
				else{
					showWarningMessage(getCommonTranslation('ALERT'),response.responseText);
				}
			},
			failure: function(response){
				console.log(response);
			}
		});
	},
	
});