/**
 * @author Sumit meena
 * 
 */
Ext.define('Academia.controller.examinationcenters.dasboard.ExamLogisticStatisticsController', {
	extend: 'Academia.controller.programCourseDashboard.organizationUnit.organizationUnitController',
	stores : ['examinationcenters.dashboard.SupervisorRolePlayed','examinationcenters.dashboard.UpcomingCenterUsage',
	          'examinationcenters.dashboard.ProgramWiseDashboard','examinationcenters.dashboard.ShowStaticsFor','examinationcenters.dashboard.ReportType',
	          'examinationcenters.dashboard.CourseByEvalPlanID','examinationcenters.dashboard.ExamDashBoardEvaluationEvent','examinationcenters.dashboard.CourseByMultipleAcdemyLocation',
	          'examinationcenters.dashboard.ExamDashboardLocationPieChart','examinationcenters.dashboard.ExamDashboardAcademyPieChart',
	          'examinationcenters.dashboard.EvaluationPlanByAcademyAndEvalType','program.programDetails.programBatches.assignExamCenter.ProgramCenterTypeStore',
	          'examinationcenters.evaluationgrouplisting.centerallocation.CenterNameByEvalGroupIdCenterType','common.ProgramStore','common.BatchesByProgramId',
	          'examinationcenters.roomallocation.RoomAllocationInvigilator','examCenter.AssignSequence.EvaluationType','examinationcenters.CenterUseFor',
	          'examinationcenters.evaluation.PlacementAcademyOthers','examinationcenters.manageEvaluation.DetailSequence','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
	          'examinationcenters.evaluationgroup.detailsequencecovered.EvalGroupEvaluationPlanCombo','examinationcenters.dashboard.ExamDashboardProgramBarChart',
	          'examinationcenters.dashboard.ExamDashboardTreeStore','facilitiesresources.resourcebooking.ProgramByAcademyLocationIdsListStore','course.AssignedPeriodCoursesFacultyStore'],
	views : ['examinationcenters.dashboard.ExamDashboardStructure','examinationcenters.dashboard.centerusage.CenterUsageFilter','examinationcenters.dashboard.supervisorroleplayed.SupervisorRolePlayedGrid',
	         'examinationcenters.dashboard.supervisorroleplayed.SupervisorRolePlayedFilter','examinationcenters.dashboard.centerusage.UpcomingCenterUsageGrid','examinationcenters.dashboard.ExamDashboardGraphFilter',
	         'examinationcenters.dashboard.ProgramWiseDashboardGrid',
	         'examinationcenters.dashboard.supervisorroleplayed.SupervisorRolePlayedGridStructure',
	         'examinationcenters.dashboard.centerusage.UpcomingCenterUsageGridStructure',
	         'examinationcenters.dashboard.ExaminationStatisticsStructure'],
	config:{
		   EXAMINATIONDASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAMINATIONDASHBOARD_PRIVILEGES'),
		   EXAMINATION_STATISTICS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAMINATION_STATISTICS_PRIVILEGES'),
		   EXAMINATION_LOGISTICS_STATISTICS_SUPERVISOR_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAMINATION_LOGISTICS_STATISTICS_SUPERVISOR_PRIVILEGES'),
		   EXAMINATION_LOGISTICS_UPCOMING_CENTER_USAGE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAMINATION_LOGISTICS_UPCOMING_CENTER_USAGE_PRIVILEGES')
	},      
	          refs : [{
	        	  ref:'supervisorroleplayedgrid',
	        	  selector:'supervisorroleplayedgrid'
	          },{
	        	  ref:'supervisorroleplayedfilter',
	        	  selector:'supervisorroleplayedfilter'
	          },{
	        	  ref:'centerusagefilter',
	        	  selector:'centerusagefilter'
	          },{
	        	  ref:'upcomingcenterusagegrid',
	        	  selector:'upcomingcenterusagegrid'
	          },{
	        	  ref:'examdashboardstructure',
	        	  selector:'examdashboardstructure'
	          },{
	        	  ref:'organizationUnitExamDashBoard',
	        	  selector:'organizationunit[itemId=organizationunitExamDashboardItemId]'
	          },{
	        	  ref:'examdashboardgraphfilter',
	        	  selector:'examdashboardgraphfilter'
	          },{
	        	  ref:'examDashBoardProgramBarChart',
	        	  selector:'paymentstatisticsbycolumnchart[itemId=examDashBoardProgramBarChartItemId]'
	          },{
	        	  ref:'programwisedashboardgrid',
	        	  selector:'programwisedashboardgrid'
	          },{
		    	 ref: 'enlargeFeeChartWindow',
		    	 selector: 'enlargefeechartwindow'
		     },{
		    	 ref: 'examdashBoardAcademyPieChart',
		    	 selector: 'piechartreport[itemId=examdashboardbyacademieschartItemId]'
		     },{
		    	 ref: 'examdashBoardLocationPieChart',
		    	 selector: 'piechartreport[itemId=examdashboardbylocationchartItemId]'
		     }, {
		    	 ref: 'examDashboardSummaryAndDetailsTabPanel',
		    	 selector: 'tabpanel[itemId=examDashboardSummaryAndDetailsTabPnl]'
		     },{
		    	 ref :'examinationStatiSticsStructure',
		    	 selector : 'examinationstatisticsstructure'
		     }],
	          init : function() {
	        	  this.control({
	        		  'examinationstatisticsstructure tabpanel#examDashboardSummaryAndDetailsTabPnl': {
	        			  tabchange:function(view,newTab,oldTab){
	        				  if(view.activeTab.itemId =='examDashboardDetailsTab' ) {
	        					 var filter =  this.getExamdashboardgraphfilter();
	        					  var grid = view.down('programwisedashboardgrid');
	        					  grid.config.searchFilterForm = filter;
	        				  }
	        			  }
	        		  },
	        		  'examdashboardstructure treepanel[itemId=examDashboardReportTreePanelItemId]':{
	        			  itemclick : this.getOpenExamDashbordStructure
	        		  },
	        		  'upcomingcenterusagegrid':{
	        			  afterrender:function(grid){
	        				  this.doAccessControlValidation(grid, this.getEXAMINATION_LOGISTICS_UPCOMING_CENTER_USAGE_PERMISSIONS());
	        			  }
	        		  },
	        		  'supervisorroleplayedgrid':{
	        			afterrender:function(grid){
	        				this.doAccessControlValidation(grid, this.getEXAMINATION_LOGISTICS_STATISTICS_SUPERVISOR_PERMISSIONS());
	        			}  
	        		  },
	        		  'programwisedashboardgrid':{
	        			  afterrender:function(grid){
	        				  console.log('grid',this.getEXAMINATION_STATISTICS_PERMISSIONS());
	        				  this.doAccessControlValidation(grid, this.getEXAMINATION_STATISTICS_PERMISSIONS());
	        			  }
	        			  
	        		  },
	      			 'organizationunit[itemId=organizationunitExamDashboardItemId] button[itemId=resetBtn]': {
	      			//	click:function(obj,record){ 
	      			//		this.resetOrganizationunit(obj);
	        		//	  	}
	        			  	  click : function(obj, record) {
	                				//   this.resetOrganizationunit(obj);
	                				//   var academyLocationId = this.getCurrentAcademyLocation();
	                				   var form = obj.up('form');
										 var multiSelectALId = form.down('#multiselectAcademyLocationId');
									 	 var multiSelectALIdStore = multiSelectALId.getStore();
					    				
									 	multiSelectALIdStore.load({
					    					 callback: function(records, operation, success) {
					    						if (success) {
											 multiSelectALId.setValue(records);			
										}
					    					 }
					    				 });
	                			   }
	                			                  			
	        		  		
	        		  	},
	        		  	'organizationunit[itemId=organizationunitExamDashboardItemId] radiogroup[itemId=organizationRadioUnitId]': {
	        		  		change:function(obj,record){
	        		  			this.organizationUnitChange(obj,record);
	        		  		},
	        		  		render:function(obj){
	        		  			var permission = this.getEXAMINATIONDASHBOARD_PERMISSIONS();
	          		  			this.organizationUnitChange(obj,null,permission);
	        		  		}
	        		  	},
	        		  'examdashboardstructure tabpanel[itemId=examLogisticsTabPanelItemId]':{
	        			  tabchange:function( tabPanel, newCard, oldCard, eOpts ){
	        				  /**
	        				   * this function is to reset the tab form filters.
	        				   */
	        				if(oldCard.title==getExaminationTranslation('SUPERVISOR_INVIGILATOR_ROLE_PLAYED')){
	        					oldCard.items.items[0].getForm().reset();
	        				}else if(oldCard.title==getExaminationTranslation('UPCOMING_CENTER_USAGE')){
	        					oldCard.items.items[0].getForm().reset();
	        				}
	        			}  
	        		  },
	        		  'supervisorroleplayedfilter customcombobox[itemId=centerTypeItemId]':{
							select:function(obj,rec){
								var data=rec[0].data.id;
								var form=obj.up('form').getForm();
								var centerName=form.findField('centerName');
								centerName.enable();
								centerName.reset();
								var academyLocationIds=this.getAcademyLocationOfOrganization();
								var store=centerName.getStore();
			      				store.getProxy().extraParams = {
			      					centerType:data,
			      					academyLocationIds:academyLocationIds
				    				   };
			      				store.load();
			      				this.loadCourseByAcademyLocation(form.findField('courseId'));
							}
						},
		        		'supervisorroleplayedfilter customcombobox[itemId=programItemId]':{
		        			select: function(obj,rec){
								var data=rec[0].data.id;
								var form=obj.up('form').getForm();
								var batchIdField=form.findField('batchId');
								var courseField=form.findField('courseId');
								batchIdField.enable();
								batchIdField.reset();
								courseField.reset();
								var store=batchIdField.getStore();
			      				store.getProxy().extraParams = {
			      					id:data
				    			};
			      				store.load();
						   }
						},
						'centerusagefilter customcombobox[itemId=centerTypeItemId]':{
							select:function(obj,rec){
								var data=rec[0].data.id;
								var form=obj.up('form').getForm();
								var centerName=form.findField('centerName');
								var batchIdField=form.findField('batchId');
								var courseField=form.findField('courseId');
								var programIds=form.findField('programId');
								var userIds=form.findField('user');
								var fromDate = form.findField('fromDate');
								var toDate = form.findField('toDate');
								
								batchIdField.enable();
								batchIdField.reset();
								courseField.reset();
								centerName.enable();
								programIds.reset();
								userIds.reset();
								fromDate.reset();
								toDate.reset();
								
								var academyLocationIds=this.getAcademyLocationOfOrganization();
								var store=centerName.getStore();
			      				store.getProxy().extraParams = {
			      					centerType:data,
			      					academyLocationIds:academyLocationIds
				    			};
			      				store.load();
			      				this.loadCourseByAcademyLocation(form.findField('courseId'));
							}
						},
						'centerusagefilter customcombobox[itemId=centerTypeItemId]':{
							change:function(obj,rec){
								var form=obj.up('form').getForm();
								var centerName=form.findField('centerName');
								var batchIdField=form.findField('batchId');
								var courseField=form.findField('courseId');
								var programIds=form.findField('programId');
								var fromDate = form.findField('fromDate');
								var toDate = form.findField('toDate');
								
								var centerStore = centerName.getStore();
								centerStore.getProxy().extraParams = {
									centerType: obj.getValue()
								};
								centerStore.load();
								batchIdField.enable();
								batchIdField.reset();
								courseField.reset();
								centerName.enable();
								programIds.reset();
								fromDate.reset();
								toDate.reset();
							
							}
						}
						,
						'supervisorroleplayedfilter customcombobox[itemId=centerTypeItemId]':{
							change:function(obj,rec){
								var form=obj.up('form').getForm();
								var centerName=form.findField('centerName');
								var batchIdField=form.findField('batchId');
								var courseField=form.findField('courseId');
								var programIds=form.findField('programId');
								var userIds=form.findField('user');
								var fromDate = form.findField('fromDate');
								var toDate = form.findField('toDate');
								
								var centerStore = centerName.getStore();
								centerStore.getProxy().extraParams = {
									centerType: obj.getValue()
								};
								centerStore.load();
								
								batchIdField.enable();
								batchIdField.reset();
								courseField.reset();
								centerName.enable();
								programIds.reset();
								userIds.reset();
								fromDate.reset();
								toDate.reset();
								
							}
						},
						
						'centerusagefilter multiselectcombofield[itemId=programItemId]':{
							select:function(obj,rec){
								 var programsId = [];
								 for(var i in rec){
									 if(Ext.isObject(rec[i])){
										 programsId.push(rec[i].data.id);
									 }else{
										 programsId.push(rec[i]);
									 }
								 }
								 var programIds = programsId.join();
								var data=rec[i].data.id;
								
								var form=obj.up('form').getForm();
								var batchIdField=form.findField('batchId');
								var courseField=form.findField('courseId');
								courseField.reset();
								batchIdField.setDisabled(false);
								batchIdField.reset();
								var store=batchIdField.getStore();
			      				store.getProxy().extraParams = {
			      					programIds:programIds
				    			};
			      				store.load();
							}
						},
						'centerusagefilter customcombobox[itemId=batchItemId]':{
							select:function(obj,rec){
								var data=rec[0].data.id;
								var form=obj.up('form').getForm();
								var courseField=form.findField('courseId');
								courseField.reset();
								var store=courseField.getStore();
								 var academyLocationIds=[];
								    var organizationForm=this.getOrganizationUnitExamDashBoard().getForm();
								    var academyLocation=organizationForm.findField('academyLocation');
								    var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation');
								   if(!multiselectAcademyLocation.isHidden()){
								    	Ext.Array.each(multiselectAcademyLocation.getValue(),function(value){
								    		if(Ext.isObject(value)){
								    			academyLocationIds.push(value.data.id);	
								    		}else {
								    			academyLocationIds.push(value);
								    		}
								    	});
								    }
			      				store.getProxy().extraParams = {
			      					academyLocationIds:academyLocationIds.join(),
			      					batchId:data,
			      					isCurrentPeriod:true
				    			};
			      				store.load();
							}
						},
						'centerusagefilter button[itemId=searchBtn]':{
							click:function(obj){
								var filterForm =obj.up('form');
								var form=obj.up('form').getForm();
								var formValues=form.getValues();
								var supervisorGrid=this.getUpcomingcenterusagegrid();
								var centerName=form.findField('centerName').getValue();
								var programId=form.findField('programId').getValue();
                                var centerNameIds=[];
								if(centerName!=undefined){
									Ext.Array.each(centerName,function(value){
										if(Ext.isObject(value)){
											centerNameIds.push(value.data.id);	
							    		}else {
							    			centerNameIds.push(value);
							    		}
									});
								}
								var programIds=[];
								if(programId!=undefined){
									Ext.Array.each(programId,function(value){
										if(Ext.isObject(value)){
											programIds.push(value.data.id);	
							    		}else {
							    			programIds.push(value);
							    		}
									});
								}
								
								/**
								  * Load Academy location of organization unit
								  */
							    var organizationForm=this.getOrganizationUnitExamDashBoard().getForm();
							    var academyLocation=organizationForm.findField('academyLocation');
							    var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation');
							    var academyLocationIds=[];
							    if(!academyLocation.isHidden()){
							    	Ext.Array.each(academyLocation.getValue(),function(value){
							    		if(Ext.isObject(value)){
							    			academyLocationIds.push(value.data.id);	
							    		}else {
							    			academyLocationIds.push(value);
							    		}
							    	});
							    }
							    
							    if(!multiselectAcademyLocation.isHidden()){
							    	Ext.Array.each(multiselectAcademyLocation.getValue(),function(value){
							    		if(Ext.isObject(value)){
							    			academyLocationIds.push(value.data.id);	
							    		}else {
							    			academyLocationIds.push(value);
							    		}
							    	});
							    }
//							    Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
							       
								var store=supervisorGrid.getStore();
			      				store.getProxy().extraParams = {
			      					    academyLocationIds:academyLocationIds.join(),
				      					centerType:formValues.centerType,
				      					examCenterIds:centerNameIds.length>0 ? centerNameIds.join(): null,
				      					programIds:programIds.length>0 ? programIds.join(): null,
		      							fromDate:formValues.fromDate!="" ? formValues.fromDate: null,
				      					toDate:formValues.toDate!="" ? formValues.toDate: null,
				      					batchIds:formValues.batchId!="" ? formValues.batchIds: null,
				      					courseId:formValues.courseId!="" ? formValues.courseId: null
				    				   };
			      				store.load();
			      				supervisorGrid.config.searchFilterForm = filterForm;
//			      				var taskDelay = new Ext.util.DelayedTask(function(){
//						       		Ext.getBody().unmask();
//						       	  });
//						       	taskDelay.delay(1000);
							}
						},
						'centerusagefilter button[itemId=resetBtn]':{
							click:function(obj){
							  var filterForm=obj.up('form').getForm();
		        				  filterForm.findField('centerName').setDisabled(true);
		        				  filterForm.findField('batchId').setDisabled(true);
		        				  filterForm.reset();
							}
						},
		        		 'supervisorroleplayedfilter datefield[itemId=fromDateItemId]':{
		        			 change:function(obj,val){
		        				obj.nextSibling().setMinValue(val);
		        			 }
		        		 },
		        		 'supervisorroleplayedfilter datefield[itemId=toDateItemId]':{
		        			 change:function(obj,val){
		        				obj.previousSibling().setMaxValue(val);
		        			 }
		        		 },
						'supervisorroleplayedfilter button[itemId=searchBtn]':{
							click:function(obj){
								var filterForm = obj.up('form');
								var form=obj.up('form').getForm();
								var formValues=form.getValues();
								var supervisorGrid=this.getSupervisorroleplayedgrid();
								var centerName=form.findField('centerName').getValue();
								var programId=form.findField('programId').getValue();
                                var centerNameIds=[];
								if(centerName!=undefined){
									Ext.Array.each(centerName,function(value){
										if(Ext.isObject(value)){
											centerNameIds.push(value.data.id);	
							    		}else {
							    			centerNameIds.push(value);
							    		}
									});
								}
								var programIds=[];
								if(programId!=undefined){
									Ext.Array.each(programId,function(value){
										if(Ext.isObject(value)){
											programIds.push(value.data.id);	
							    		}else {
							    			programIds.push(value);
							    		}
									});
								}
								/**
								   * Load Academy location of organization unit
								   */
								    var organizationForm=this.getOrganizationUnitExamDashBoard().getForm();
								    var academyLocation=organizationForm.findField('academyLocation');
								    var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation');
								    var academyLocationIds=[];
								    if(!academyLocation.isHidden()){
								    	Ext.Array.each(academyLocation.getValue(),function(value){
								    		if(Ext.isObject(value)){
								    			academyLocationIds.push(value.data.id);	
								    		}else {
								    			academyLocationIds.push(value);
								    		}
								    	});
								    }
								    
								    if(!multiselectAcademyLocation.isHidden()){
								    	Ext.Array.each(multiselectAcademyLocation.getValue(),function(value){
								    		if(Ext.isObject(value)){
								    			academyLocationIds.push(value.data.id);	
								    		}else {
								    			academyLocationIds.push(value);
								    		}
								    	});
								    }
								 //   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
								      
								var store=supervisorGrid.getStore();
			      				store.getProxy().extraParams = {
			      					    academyLocationIds:academyLocationIds.join(),
				      					centerType:formValues.centerType,
				      					examCenterIds:centerNameIds.length>0 ? centerNameIds.join(): null,
				      					programIds:programIds.length>0 ? programIds.join(): null,
		      							fromDate:formValues.fromDate!="" ? formValues.fromDate: null,
				      					toDate:formValues.toDate!="" ? formValues.toDate: null,
				      					userId:formValues.user!="" ? formValues.user: null,
				      					batchIds:formValues.batchId!="" ? formValues.batchId: null,
				      					courseId:formValues.courseId!="" ? formValues.courseId: null
				    				   };
			      				store.load();
			      				supervisorGrid.config.searchFilterForm = filterForm;
			      			   /*	var taskDelay = new Ext.util.DelayedTask(function(){
						       		Ext.getBody().unmask();
						       	  });
						       	taskDelay.delay(1000);  */
							}
						},
						'supervisorroleplayedfilter button[itemId=resetBtn]':{
							click:function(obj){
								var filterForm=obj.up('form').getForm();
		        				  filterForm.findField('centerName').setDisabled(true);
		        				  filterForm.findField('batchId').setDisabled(true);
		        				  filterForm.reset();
							}
						},
						'examdashboardgraphfilter':{
							beforerender : function(obj){
								var $this= this;
								var form = $this.getExamdashboardgraphfilter().getForm();
								var evalStage = form.findField('evaluationStage').hide();
								evalStage.getStore().load({
		        					 callback: function(records, operation, success) {
		        						 evalStage.setValue(records[1].data.id);
	      	            		   	 }	   
								});
	        			    }
		        		},
		        		
		        		'examdashboardgraphfilter customcombobox[itemId=showStaticsForId]':{
		        			change:function(obj,rec){
								var mainForm=obj.up('form');
								var form=mainForm.getForm();
								var programIdField=form.findField('programId');
								var batchIdField=form.findField('batchId');
								var periodIdField=form.findField('periodId');
								var assesmentSchemeType = form.findField('evaluationPlanType');
								var assesmentScheme = form.findField('evaluationStage');
								var assesmentEvent = form.findField('placementEvaluationStage');
								var assesmentGroup = form.findField('evaluationPlanId');
								var assesmentSchemeGroup = form.findField('detailSequenceId');
								var reportForId = form.findField('reportFor');
								var course = form.findField('courseId');
								
								assesmentSchemeType.reset();
								assesmentScheme.reset();
								assesmentEvent.reset();
								assesmentGroup.reset();
								assesmentSchemeGroup.reset();
								course.reset();
								programIdField.reset();
								batchIdField.reset();
								periodIdField.reset();
								reportForId.reset();
								
		        			}
		        		},
		        		
						'examdashboardgraphfilter customcombobox[itemId=reportForItemId]':{
							select:function(obj,rec){
								//var reportFor=rec[0].data.id;
								var reportFor=rec[0].data.value;
								var mainForm=obj.up('form');
								var form=mainForm.getForm();
								var filter = this.getExamdashboardgraphfilter();
								var addBtn = filter.down('#btnAddMultipleFields');
								var multpileFieldPanel=Ext.ComponentQuery.query('container#multipleFieldPanel')[0];
								var programIdField=form.findField('programId');
								var batchIdField=form.findField('batchId');
								var periodIdField=form.findField('periodId');
								
								
								form.findField('detailSequenceId').reset();
								programIdField.reset();
								batchIdField.reset();
								periodIdField.reset();
								var courseIdField=form.findField('courseId');
								courseIdField.reset();
								courseIdField.setVisible(false);
								multpileFieldPanel.setVisible(false);
								
								var evaluationPlanTypeField=form.findField('evaluationPlanType');
								var evaluationStageField=form.findField('evaluationStage');
								var placementEvaluationStageField=form.findField('placementEvaluationStage');
								var evaluationPlanIdField=form.findField('evaluationPlanId');
								var detailSequenceIdField=form.findField('detailSequenceId');
								var evaluationGroupIdField=form.findField('evaluationGroupId');
								
								evaluationPlanTypeField.reset();
								evaluationPlanTypeField.setVisible(false);
//								evaluationStageField.reset();
								evaluationStageField.setVisible(false);
								placementEvaluationStageField.reset();
								placementEvaluationStageField.setVisible(false);
								evaluationPlanIdField.reset();
								evaluationPlanIdField.setVisible(false);
								detailSequenceIdField.reset();
								detailSequenceIdField.setVisible(false);
								evaluationGroupIdField.reset();
								evaluationGroupIdField.setVisible(false);
								evaluationGroupIdField.setDisabled(true);
								
								var programColumnChartLabel=this.getExamDashBoardProgramBarChart().previousSibling();
								var detailTabGrid=this.getProgramwisedashboardgrid();
								if(reportFor==getCommonTranslation('PROGRAM_WISE')){
									multpileFieldPanel.setVisible(true);
									addBtn.setDisabled(false); 
									
									programColumnChartLabel.items.items[0].setText(getCommonTranslation('PROGRAM_WISE'));
									detailTabGrid.columns[0].setVisible(true);
									detailTabGrid.columns[1].setVisible(false);
									this.loadProgramByAcademyLocation(programIdField);
								}else if(reportFor==getCommonTranslation('COURSE_WISE')){
									
									programColumnChartLabel.items.items[0].setText(getCommonTranslation('COURSE_WISE'));
									detailTabGrid.columns[0].setVisible(false);
									detailTabGrid.columns[1].setVisible(true);
									
									courseIdField.setVisible(true);
									
									evaluationPlanTypeField.setVisible(true);
//									evaluationStageField.setVisible(true);
									//placementEvaluationStageField.setVisible(true);
									evaluationPlanIdField.setVisible(true);
									detailSequenceIdField.setVisible(true);
									evaluationGroupIdField.setVisible(true);
									
									/**
									 * It is used remove multiple fields from panel
									 */
									if(multpileFieldPanel.items.length>1){
			        					  for(var i=1;multpileFieldPanel.items.length>i;i++){
			        						  multpileFieldPanel.remove(multpileFieldPanel.items.items[i]);
			        					  }
			        					  mainForm.doLayout();
			        				  }
								}
								this.loadCourseByAcademyLocation(courseIdField);
						    }
						},
						'examdashboardgraphfilter customcombobox[itemId=evaluationPlanTypeItemId]':{
							select:function(obj,rec){
								var evalPlanType=rec[0].data.id;
								var form=obj.up('form').getForm();
								var evaluationStageField=form.findField('evaluationStage');
								var placementEvaluationStageField=form.findField('placementEvaluationStage');
								var evaluationPlanIdField=form.findField('evaluationPlanId');
								form.findField('detailSequenceId').reset();
								evaluationPlanIdField.enable();
								evaluationPlanIdField.reset();
								
//								evaluationStageField.reset();
								placementEvaluationStageField.reset();
								
								evaluationStageField.setVisible(false);
								placementEvaluationStageField.setVisible(false);
								
								if(evalPlanType==getExaminationTranslation('CNTRL_ACADEMICS') || evalPlanType==getExaminationTranslation('CNTRL_OTHER')){
//									evaluationStageField.setVisible(true);
								}else if(evalPlanType==getExaminationTranslation('CNTRL_EXTERNAL_ORGANISATION')){
									placementEvaluationStageField.setVisible(true);
								}
								if(evalPlanType==getExaminationTranslation('CNTRL_OTHER')){
									var academyLocationIds=this.getAcademyLocationOfOrganization();
									evaluationPlanIdField.getStore().getProxy().extraParams={
										evaluationPlanType:evalPlanType,
										academyLocationIds:academyLocationIds
									};
									evaluationPlanIdField.getStore().load();
								}
								else{
									var academyLocationIds=this.getAcademyLocationOfOrganization();
									evaluationPlanIdField.getStore().getProxy().extraParams={
										evaluationPlanType:evalPlanType,
										academyLocationIds:academyLocationIds
									};
									evaluationPlanIdField.getStore().load();
								}
							}
						},
						'examdashboardgraphfilter customcombobox[itemId=evaluationStageItemId]':{
		        			  select:function(obj,rec){
		        				  var stage=rec[0].data.id;
									var form=obj.up('form').getForm();
									var evaluationPlanIdField=form.findField('evaluationPlanId');
									
									var evalPlanType = form.findField('evaluationPlanType').getRawValue();
									form.findField('detailSequenceId').reset();
									
									if(form.findField('evaluationPlanType').getValue()==getExaminationTranslation('CNTRL_OTHER')){
										var academyLocationIds=this.getAcademyLocationOfOrganization();
										evaluationPlanIdField.getStore().getProxy().extraParams={
											evaluationPlanType:evalPlanType,
											//academyLocationIds:academyLocationIds,
											evaluationStage:stage
										};
										evaluationPlanIdField.getStore().load();
									}
									else{
										var academyLocationIds=this.getAcademyLocationOfOrganization();
										evaluationPlanIdField.getStore().getProxy().extraParams={
											evaluationPlanType:evalPlanType,
											academyLocationIds:academyLocationIds,
											evaluationStage:stage
										};
										evaluationPlanIdField.getStore().load();
									}
									
		        			}  
		        		  },
							'examdashboardgraphfilter customcombobox[itemId=placementEvaluationStageItemId]':{
			        			  select:function(obj,rec){
			        				  var stage=rec[0].data.id;
										var form=obj.up('form').getForm();
										var evaluationPlanIdField=form.findField('evaluationPlanId');
										
										var evalPlanType = form.findField('evaluationPlanType').getRawValue();
										
										var academyLocationIds=this.getAcademyLocationOfOrganization();
										evaluationPlanIdField.getStore().getProxy().extraParams={
											evaluationPlanType:evalPlanType,
											academyLocationIds:academyLocationIds,
											evaluationStage:stage
										};
										evaluationPlanIdField.getStore().load();
			        			}  
			        		  },
						
						
						'examdashboardgraphfilter customcombobox[itemId=evaluationPlanItemId]':{
		        			  select:function(obj,rec){
		        				  var evalPlanId=rec[0].data.id;
								  var form=obj.up('form').getForm();
								  var detailSequenceIdField=form.findField('detailSequenceId');
								  detailSequenceIdField.enable();
								  detailSequenceIdField.getStore().getProxy().extraParams={
									  evalPlanId:evalPlanId
		        				  };
								  detailSequenceIdField.getStore().load();
								  
								  var courseField=form.findField('courseId');
								  courseField.enable();
								  var store=courseField.getStore();
								  store.getProxy().extraParams={
									  evalPlanId:evalPlanId
		        				  };
								  store.load({
		    								callback:function(rec,success){
		    									if(rec.length==1){
		    										courseField.setValue(rec[0].data.id);
		    								  }
		    								}
								  });
		        			}  
		        		  },
						'examdashboardgraphfilter customcombobox[itemId=detailSequenceItemId]':{
		        			  select:function(obj,rec){
		        				  var evalEventId=rec[0].data.id;
								  var form=obj.up('form').getForm();
								  var evaluationGroupIdField=form.findField('evaluationGroupId');
								  evaluationGroupIdField.enable();
								  evaluationGroupIdField.getStore().getProxy().extraParams={
									  evalSeqDetailId:evalEventId
		        				  };
								  evaluationGroupIdField.getStore().load();
		        			}  
		        		  },
						'examdashboardgraphfilter customcombobox[itemId=programItemId]':{
		        			  select:function(obj,rec){
		        				  var programId=rec[0].data.id;
								  var form=obj.up('form').getForm();
								  var batchField=form.findField('batchId');
								  var periodField=form.findField('periodId');
								  periodField.setDisabled(true);
								  periodField.reset();
								  batchField.enable();
								  batchField.getStore().getProxy().extraParams={
									  id:programId
		        				  };
								  batchField.getStore().load();
		        			}  
		        		  },
						'examdashboardgraphfilter customcombobox[itemId=batchItemId]':{
		        			  select:function(obj,rec){
		        				  var batchId=rec[0].data.id;
								  var form=obj.up('form').getForm();
								  var periodField=form.findField('periodId');
								  periodField.enable();
								  periodField.getStore().getProxy().extraParams={
									  id:batchId
		        				  };
								  periodField.getStore().load();
		        			 }  
		        		  },
						'examdashboardgraphfilter button[itemId=btnAddMultipleFields]':{
		        			  click:function(obj,rec){
		        			     this.addMultipleTimeSlots();
		        			}  
		        		  },
						'examdashboardgraphfilter button[itemId=searchBtn]':{
		        			  click:function(obj){
		        				  this.loadDataOfGraphAndPieChart();
		        			  }
		        		  },
						'examdashboardgraphfilter button[itemId=resetBtn]':{
		        			  click:function(obj){
		        			  var filterForm=obj.up('form').getForm();
		        				  filterForm.findField('evaluationPlanId').setDisabled(true);
		        				  filterForm.findField('detailSequenceId').setDisabled(true);
		        				  filterForm.findField('evaluationGroupId').setDisabled(true);
		        				  filterForm.findField('batchId').setDisabled(true);
		        				  filterForm.findField('periodId').setDisabled(true);
		        				  filterForm.findField('periodId').setDisabled(true);
		        				  filterForm.reset();
		        				  filterForm.findField('evaluationStage').setValue('COURSE_EXECUTION').hide();
		        			  }  
		        		  },
			    		 /*'panel[itemId=examchartpanelsbyacademies]': {
			    			 render: this.enlargeExamChart
			    		 },
			    		 'panel[itemId=examchartpanelbylocation]': {
			    			 render: this.enlargeExamChart
			    		 },
			    		 'panel[itemId=examchartpanelbycolumn]': {
			    			 render: this.enlargeExamChart
			    		 },*/
						/*'paymentstatisticsbycolumnchart[itemId=examDashBoardProgramBarChartItemId]':{
		        			  render:function(obj){
		        				  obj.getStore().getProxy().extraParams={
		        					  academyLocationIds:4,
		        					  status:'PASS',
		        					  evaluationPlanType:'ACADEMICS',
		        					  stage:'COURSE_EXECUTION',
		        					  programIds:5,
		        					  typeOfPie : 'PROGRAM'
		        				  };
		        				  obj.getStore().load();
		        			}  
		        	   },*/
		        		 /* 'paymentstatisticsbycolumnchart[itemId=examDashBoardProgramBarChartItemId]': {
		                      afterlayout: this.afterExamDashBoardProgramBarChartLayout
		                  },*/
		                  'container[itemId=examDashboardDetailsTab]':{
		                	  activate:function(obj,rec){
		                		  var filterForm=this.getExamdashboardgraphfilter().getForm();
		                		  var reportForField=filterForm.findField('reportFor');
		                	  	if(this.clickOnChartColumn != true){
		                		  var detailGrid  = this.getProgramwisedashboardgrid();
		                		  detailGrid.setTitle(reportForField.getRawValue());
		    	            	  var detailStore = detailGrid.getStore();
		    	            	  detailStore.clearFilter();
		                	  	}
		                	  	this.clickOnChartColumn = false;
		                	  }
		                  }
	        	  });
	          },
	          getOpenExamDashbordStructure : function(treePanel, record, item,index, e, eOpts){
	        	  var $this = this;
	        	  var containpanel = $this.getExamdashboardstructure();
	        	  var treePanel = containpanel.down('#examDashboardReportTreePanelItemId');
	        	  var tabDetail = record.data;
	        	  var structure = Ext.widget(tabDetail.reportXtype);
	        	  var tabstructure = containpanel.down('#tabpanelIds');

	        	  if (!isNullOrEmpty(tabDetail.text)
	        			  && !isNullOrEmpty(tabDetail.reportXtype)
	        			  && !isNullOrEmpty(tabDetail.reportXtypeItemId)) {
	        		  treePanel.toggleCollapse();
	        		  openTab(tabstructure, tabDetail.text,structure);
	        		  treePanel.getSelectionModel().deselectAll();
	        	  }
	          },
	          afterExamDashBoardProgramBarChartLayout: function(chart){
	        	  var that = this;
	              if(this.initializedEvents==true) return;
	              this.initializedEvents=true;
	              chart.series.items[0].on('itemclick',function(obj){
	            	  var form=that.getExamdashboardgraphfilter();
	            	  var filterForm=that.getExamdashboardgraphfilter().getForm();
            		  var reportForField=filterForm.findField('reportFor');
	            	  var chart = that.getExamDashBoardProgramBarChart();
	            	  var detailGrid  = that.getProgramwisedashboardgrid();
	            	  var detailStore = detailGrid.getStore();
	            	  detailStore.clearFilter();
	            	  var selectedName=obj.value[0];
	            	  detailGrid.setTitle(reportForField.getRawValue()+' :- '+selectedName);
	            	  detailStore.filter({
                          filterFn: function(record) {
                        	  var flag = false;
                              if (record.get('programName') == selectedName) {
                                  flag = true;
                              }else if(record.get('courseCode') == selectedName){
                            	  flag = true;
                              } else {
                                  flag = false;
                              }
                              return flag;
                          }
                      }, this);
	            	  var tabPnl = that.getExamDashboardSummaryAndDetailsTabPanel();
	            	  that.clickOnChartColumn = true;
	            	  detailGrid.config.searchFilterForm =  form;
	            	  tabPnl.setActiveTab(1);
	              });
	          },
	          /**
	           *Fetch academy location from organizatin combo 
	           */
	          getAcademyLocationOfOrganization:function(){
	        	  var organizationForm=this.getOrganizationUnitExamDashBoard().getForm();
				    var academyLocation=organizationForm.findField('academyLocation');
				    var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation');
				    var academyLocationIds=[];
				    if(!academyLocation.isHidden()){
				    	Ext.Array.each(academyLocation.getValue(),function(value){
				    		if(Ext.isObject(value)){
				    			academyLocationIds.push(value.data.id);	
				    		}else {
				    			academyLocationIds.push(value);
				    		}
				    	});
				    }
				    
				    if(!multiselectAcademyLocation.isHidden()){
				    	Ext.Array.each(multiselectAcademyLocation.getValue(),function(value){
				    		if(Ext.isObject(value)){
				    			academyLocationIds.push(value.data.id);	
				    		}else {
				    			academyLocationIds.push(value);
				    		}
				    	});
				    }
				    
				    return academyLocationIds.join();
	          },
	          /**
			   * Load Course of Academy location of organization unit
			   */
	          loadCourseByAcademyLocation:function(courseField){
				    var organizationForm=this.getOrganizationUnitExamDashBoard().getForm();
				    var academyLocation=organizationForm.findField('academyLocation');
				    var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation');
				    var academyLocationIds=[];
				    if(!academyLocation.isHidden()){
				    	Ext.Array.each(academyLocation.getValue(),function(value){
				    		if(Ext.isObject(value)){
				    			academyLocationIds.push(value.data.id);	
				    		}else {
				    			academyLocationIds.push(value);
				    		}
				    	});
				    }
				    
				    if(!multiselectAcademyLocation.isHidden()){
				    	Ext.Array.each(multiselectAcademyLocation.getValue(),function(value){
				    		if(Ext.isObject(value)){
				    			academyLocationIds.push(value.data.id);	
				    		}else {
				    			academyLocationIds.push(value);
				    		}
				    	});
				    }
					    
				    courseField.getStore().getProxy().extraParams={
						academyLocationIds:academyLocationIds.join()
					};
				    courseField.getStore().load();  
	          },
	          loadProgramByAcademyLocation:function(programField){
				    var organizationForm=this.getOrganizationUnitExamDashBoard().getForm();
				    var academyLocation=organizationForm.findField('academyLocation');
				    var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation');
				    var academyLocationIds=[];
				    if(!academyLocation.isHidden()){
				    	Ext.Array.each(academyLocation.getValue(),function(value){
				    		if(Ext.isObject(value)){
				    			academyLocationIds.push(value.data.id);	
				    		}else {
				    			academyLocationIds.push(value);
				    		}
				    	});
				    }
				    
				    if(!multiselectAcademyLocation.isHidden()){
				    	Ext.Array.each(multiselectAcademyLocation.getValue(),function(value){
				    		if(Ext.isObject(value)){
				    			academyLocationIds.push(value.data.id);	
				    		}else {
				    			academyLocationIds.push(value);
				    		}
				    	});
				    }
					    
				    programField.getStore().getProxy().extraParams={
						academyLocationIds:academyLocationIds.join()
					};
				    programField.getStore().load();  
	          },
	          /**
	           * load data in graph screen
	           */
	          loadDataOfGraphAndPieChart:function(){
	        	  var $this=this;
	        	  var tabPnl = $this.getExamDashboardSummaryAndDetailsTabPanel();
            	  tabPnl.setActiveTab(0);
	        	  /**
				   * Load Academy location of organization unit
				   */
            	  
            	  var examinationStatiSticsStructure = $this.getExaminationStatiSticsStructure();
            	  var yAxesCategoryTitleValue=examinationStatiSticsStructure.down('#examDashBoardProgramBarChartItemId');

				  var academyLocationIds=$this.getAcademyLocationOfOrganization();
				  if (academyLocationIds == ''){
	        		  showWarningMessage(getExaminationTranslation('PLEASE_SELECT_ACADEMY_LOCATIONS'));
	        	  }else{  
				  var filterForm=$this.getExamdashboardgraphfilter();
	        	  var filterFormValues=filterForm.getForm().getValues();
				   /**
			       * Assessment Stage  ,program ,batch and period data
			       */
				    var evaluationStage=null;
				    if(!isNullOrEmpty(filterFormValues.evaluationStage)){
				    	evaluationStage=filterFormValues.evaluationStage;
				    }else if(!isNullOrEmpty(filterFormValues.placementEvaluationStage)){
				    	evaluationStage=filterFormValues.placementEvaluationStage;
				    }
				    
				    var multipleFieldPanel=Ext.ComponentQuery.query('container#multipleFieldPanel')[0];
				    var programIdValue=null;
				    var batchIdValue=null;
				    var periodIdValue=null;
				    var typeOfpieValue=null;
				    if(!multipleFieldPanel.isHidden()){
					   var multipleFieldPanelCount=multipleFieldPanel.items.length;
					    if(multipleFieldPanelCount>1){
					    	programIdValue=filterFormValues.programId.join();
					    	batchIdValue=filterFormValues.batchId.join();
						    periodIdValue=filterFormValues.periodId.join();
		        		  }else{
		        			programIdValue=filterFormValues.programId;
						    batchIdValue=filterFormValues.batchId;
							periodIdValue=filterFormValues.periodId;
		    		      }
					    typeOfpieValue=getExaminationTranslation('CNTRL_PROGRAM_WISE');
				    }else{
				    	typeOfpieValue=getExaminationTranslation('CNTRL_COURSE_WISE');
				    }
				    
				    if(filterForm.down('#reportForItemId').rawValue==getExaminationTranslation('CNTRL_PROGRAM_WISE')){
				    	yAxesCategoryTitleValue.axes.items[1].title=getExaminationTranslation('CNTRL_PROGRAM_WISE');
				    }else{
				    	yAxesCategoryTitleValue.axes.items[1].title=getExaminationTranslation('EVALUATION_PLAN');
				    }
				    
				    
				    
				    var examinationStatiSticsStructure = $this.getExaminationStatiSticsStructure();
				    var academyExtraBtns = examinationStatiSticsStructure.down('#academyExtraBtns');
				    var locationExtraBtns = examinationStatiSticsStructure.down('#locationExtraBtns');
				    var programExtraBtns = examinationStatiSticsStructure.down('#programExtraBtns');
				    
				  /**
				   * Load data in bar and pie chart store
				   */
				  var locationPieChart=$this.getExamdashBoardLocationPieChart();
				  var academyPieChart=$this.getExamdashBoardAcademyPieChart();  
				  var programColumnChart=$this.getExamDashBoardProgramBarChart();
				  var programWiseReportGrid=$this.getProgramwisedashboardgrid();
				  programWiseReportGrid.config.searchFilterForm =  filterForm;
			     	
				  
				  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				     	
				  locationPieChart.getStore().getProxy().extraParams={
					  academyLocationIds:academyLocationIds,
					  evaluationPlanType:filterFormValues.evaluationPlanType,
					  stage:evaluationStage,
					  resultStatus:filterFormValues.showStaticsFor,
					  programIds:programIdValue,
					  batchIds:batchIdValue,
					  programBatchPeriodId:periodIdValue,
					  evalGroupId:filterFormValues.evaluationGroupId,
					  evalPlanId:filterFormValues.evaluationPlanId,
					  evalSequenceDetailId:filterFormValues.detailSequenceId,
					  courseId:filterFormValues.courseId,
					  typeOfPie:getExaminationTranslation('CNTRL_LOCATION_WISE'),
					  reportType:filterFormValues.reportFor
				  };
				  locationPieChart.getStore().load({
					  callback:function(record){
						  if(record.length > 0){
							  locationExtraBtns.setVisible(true);
						  }else{
							  locationExtraBtns.setVisible(false);
							  locationPieChart.surface.removeAll();
						  }
					  }
				  });
				  $this.addExportToPngForDashboard(locationExtraBtns.menu,locationPieChart);
				  
				  academyPieChart.getStore().getProxy().extraParams={
					  academyLocationIds:academyLocationIds,
					  evaluationPlanType:filterFormValues.evaluationPlanType,
					  stage:evaluationStage,
					  programIds:programIdValue,
					  resultStatus:filterFormValues.showStaticsFor,
					  batchIds:batchIdValue,
					  programBatchPeriodId:periodIdValue,
					  evalGroupId:filterFormValues.evaluationGroupId,
					  evalPlanId:filterFormValues.evaluationPlanId,
					  evalSequenceDetailId:filterFormValues.detailSequenceId,
					  courseId:filterFormValues.courseId,
					  typeOfPie:getExaminationTranslation('CNTRL_ACADEMY_WISE'),
					  reportType:filterFormValues.reportFor
				  };
				  academyPieChart.getStore().load({
					  callback : function(record){
						  if(record.length > 0){
							  academyExtraBtns.setVisible(true);
						  }else{
							  academyExtraBtns.setVisible(false);
							  academyPieChart.surface.removeAll();
						  }
					  }
				  });
				  $this.addExportToPngForDashboard(academyExtraBtns.menu,academyPieChart);
				  
				  programColumnChart.getStore().getProxy().extraParams={
					  academyLocationIds:academyLocationIds,
					  evaluationPlanType:filterFormValues.evaluationPlanType,
					  stage:evaluationStage,
					  programIds:programIdValue,
					  batchIds:batchIdValue,
					  programBatchPeriodId:periodIdValue,
					  resultStatus:filterFormValues.showStaticsFor,
					  evalGroupId:filterFormValues.evaluationGroupId,
					  evalPlanId:filterFormValues.evaluationPlanId,
					  evalSequenceDetailId:filterFormValues.detailSequenceId,
					  courseId:filterFormValues.courseId,
					  typeOfPie:typeOfpieValue,
					  reportType:filterFormValues.reportFor
				  };
				  programColumnChart.getStore().load({
					  callback:function(record){
						  if(record.length > 0){
							  programExtraBtns.setVisible(true);
						  }else{
							  programExtraBtns.setVisible(false);
							  programColumnChart.surface.removeAll();
						  }
					  }
				  });
				  $this.addExportToPngForDashboard(programExtraBtns.menu,programColumnChart);
				  
				  /**
				   * Load Program wise listing. 
				   */
				  programWiseReportGrid.getStore().getProxy().extraParams={
					  academyLocationIds:academyLocationIds,
					  evaluationPlanType:filterFormValues.evaluationPlanType,
					  programIds:programIdValue,
					  batchIds:batchIdValue,
					  resultStatus:filterFormValues.showStaticsFor,
					  evalGroupId:filterFormValues.evaluationGroupId,
					  evalPlanId:filterFormValues.evaluationPlanId,
					  evalSequenceDetailId:filterFormValues.detailSequenceId,
					  courseId:filterFormValues.courseId,
					  reportType:filterFormValues.reportFor
				  };
				  programWiseReportGrid.getStore().load({
					  callback:function(record){
						  if(record.length == 0){
							  programWiseReportGrid.surface.removeAll();
						  }
					  }
				  });
				  var taskDelay = new Ext.util.DelayedTask(function(){
			     		Ext.getBody().unmask();
			     	  });
			     	taskDelay.delay(1000);
		     	/**
		     	 * Apply click functionality on bar of colummn chart by clicking on search button.
		     	 */
			     	
			     this.afterExamDashBoardProgramBarChartLayout(programColumnChart);
		     	
	          }
			 },
	       // ************ add multiple program,batch,period Fields on add and delete button*************
              addMultipleTimeSlots: function() {
	              var $this = this;
	              var form = $this.getExamdashboardgraphfilter();
	              /**
	               * Create Dynamic store for program , batch ,period.
	               */
	              var batchStore = Ext.create('Ext.data.Store', {
	            	    model : 'Academia.model.common.IdValueCodeDataModel',
	            	    autoLoad : false,
	            		proxy : {
	            			type : 'rest',
	            			api:{
	            				read:SERVERURL.BATCHES_BY_PROGRAM_ID
	            			},
	            			reader: {
	            				type:'json'
	            			}
	            		}
	            	});
	              
	              var periodStore = Ext.create('Ext.data.Store', {
	            	    model : 'Academia.model.common.IdValueCodeDataModel',
	            	    autoLoad : false,
	            		proxy : {
	            			type : 'rest',
	            			api:{
	            				read:SERVERURL.PROGRAM_BATCH_DETAIL_PERIOD_DROPDOWN_URL
	            			},
	            			reader: {
	            				type:'json'
	            			}
	            		}
	            	});
	              
	              var panelItem = new Array();
	              panelItem.push({
	      			xtype: 'fieldcontainer',
	    			width: '100%',
	    			layout: {
	    				type: 'hbox',
	    				align: 'bottom',
	    				width: 256
	    			},
	    			items: [{
	    				xtype: 'customcombobox',
	    				width: 256,
	    				name: 'programId',
	    				store: 'common.ProgramStore',
	    				valueField: 'id',
	    				displayField: 'value',
	    				typeAhead:true,
	    				forceSelection:true,
	    				allowBlank:false,
	    				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    				listConfig: {
        	 				listeners: {
        	 					select : function(obj,record){
									var programId = record[0].get("id");
									var batchField=obj.nextSibling();
									batchField.enable();
									batchField.reset();
									var store =batchField.getStore(); 
									store.getProxy().extraParams = {
										  id : programId  
									};
									store.load();
          					  	},
        						beforeshow: function(picker) {
        							picker.minWidth = picker.up('combobox').getSize().width;
        						}
        					},
        	 				loadingText: getCommonTranslation('SEARCHING'),
        	 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        	 				getInnerTpl: function() {
        	 					return '<div class="search-item">' +
        	 					'{value}' +
        	 					'</div>';
        	 				}
        	 		   }  
	    			},{
	    				xtype: 'customcombobox',
	    				width: 256,
	    				name: 'batchId',
	    				store: batchStore,
	    				valueField: 'id',
	    				displayField: 'value',
	    				typeAhead:true,
	    				forceSelection:true,
	    				disabled:true,
	    				listeners:{
    					select : function(obj,record){
    						 var batchId = record[0].get("id");
    						 var periodIdField=obj.nextSibling();
    						 periodIdField.enable();
    						 periodIdField.reset();
							 var store =periodIdField.getStore(); 
    						 store.getProxy().extraParams = {
    							 id : batchId   
        					  };
	        				  store.load();
	    				  }
	    				}
	    			},{
	    				xtype:'customcombobox',
	    				width: 256,
	    				name:'periodId',
	    				store:periodStore,
	    				valueField: 'id',
	    				displayField: 'value',
	    				typeAhead:true,
	    				forceSelection:true,
	    				disabled:true
	    			},{
	                 	xtype: 'button',
	                    glyph: ICONGLYPH.DELETEGLYPH,
	                    cls: 'CustomBodyBtnReject',
	                    tooltip: getCommonTranslation('DELETETOOLTIP'),
	                    listeners:{
                           click:function(obj){
                         	  var frm = obj.ownerCt.ownerCt.ownerCt;
                         	  var multipleFieldPanel = frm.down('#multipleFieldPanel');
                         	  var container = obj.up('fieldcontainer');
                         	   multipleFieldPanel.remove(container);
                               frm.doLayout();
                           }
	                    }
	                 }]    
	              });

	              var multipleFieldPanel = form.down('#multipleFieldPanel');
	              multipleFieldPanel.add(panelItem);
	              form.doLayout();
	          },
              /**
               * enable panel click to view enlarged view of exam charts
               */
	          /*enlargeExamChart: function(panel){
             	 var $this = this;
             	 var me = panel;
             	 panel.body.on('click', function(){
             		 if(me.down('chart').isVisible()){
             			 var chartWindow = $this.openEnlargeChartWindow(),
             			 oriView = me.items.items[0],
             			 viewType = oriView.xtype,
             			 store = oriView.getStore(),
             			 storeName = store.$className,
             			 minHeight = oriView.minHeight, minWidth = oriView.minWidth, view = {};

             			 chartWindow.setTitle(oriView.chartTitle.el.dom.textContent);
             			 if(oriView.series.getAt(0).type != 'pie'){
             				 view = {
             						 xtype: viewType,
             						 minHeight: minHeight,
             						 minWidth: minWidth,
             						 columnWidth: oriView.columnWidth,
             						 columnColor: oriView.columnColor,
             						 store: storeName,
             						 xAxesNumericField: oriView.xAxesNumericField,
             						 xAxesNumericTitle: oriView.xAxesNumericTitle,
             						 yAxesCategoryField: oriView.yAxesCategoryField,
             						 yAxesCategoryTitle: oriView.yAxesCategoryTitle
             				 };
             			 }
             			 else {
             				 view = {
             						 xtype: viewType,
             						 minHeight : minHeight,
             						 minWidth: minWidth,
             						 store: storeName,
             						 numericField: oriView.numericField,
             						 categoryField: oriView.categoryField,
             						 legend: {
             							 position: 'right',
             							 minWidth: 140
             						 }
             				 };
             			 }
             			 chartWindow.add(view);
             			 var clonedView = chartWindow.down('chart');
			clonedView.series.getAt(0).renderer = function(sprite, record, attr, index, store) {
				var color = CONSTANTS.CHART_COLORSET[index];
         	if(store.getCount() <= 8){
         		return Ext.apply(attr, {
                     fill: color,
                     height: 30,
                     y: Math.max(attr.y, attr.y + (attr.height - 30) / 2)
                 });
         	}
         	else{
                 return Ext.apply(attr, {
                     fill: color
                 });
         	}
			};
             			 clonedView.getStore().add(store.data.items);
             			 clonedView.series.getAt(0).label.font = CONSTANTS.LABEL_FONT_STYLE_ENLARGED_VIEW;
             			 clonedView.updateTitle('');
             		 }
             	 });
             	 panel.body.on('mouseover', function(){
             		 if(me.down('chart').isVisible()){
             			 me.getEl().applyStyles(CONSTANTS.CHART_FRAMING);
             		 }
             	 });
             	 panel.body.on('mouseout', function(){
             		 me.getEl().applyStyles(CONSTANTS.CHART_UNFRAMING);
             	 });
              },
              
               * show window for enlart chart view
               
              openEnlargeChartWindow: function(){
             	 var chartWindow = this.getEnlargeFeeChartWindow();
             	 if (!chartWindow) {
             		 Ext.widget('enlargefeechartwindow');
             		 chartWindow = this.getEnlargeFeeChartWindow();
             	 }
             	 chartWindow.show();
             	 return chartWindow;
              }*/
});
