/**
 * @author Sumit meena
 * 
 */
Ext.define('Academia.controller.examinationcenters.evaluationgroup.documents.EvalGroupDocumentController', {
	//extend : 'Ext.app.Controller',
	extend: 'Academia.controller.base.BaseController',
	models : ['examinationcenters.evaluationgroup.document.EvalGroupCreateData'],
	stores : ['examinationcenters.evaluationgroup.document.EvalGroupDocumentName','examinationcenters.evaluationgroup.document.EvalGroupDocumentType',
	          'examinationcenters.evaluationgroup.document.EvalGroupDocumentGrid'
	          ],
	views : ['examinationcenters.evaluationgroup.documents.EvalGroupDocumentGrid','examinationcenters.evaluationgroup.documents.EvalGroupDocumentWin'],	           
	 config:{
    	 /* * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
          
         	*//**
           * @cfg {Array} EVALUATION GROUP DOCUMENT array (required)
           * The array of permissions to use for Access control wise enabling and disabling buttons.
           * @accessor
           */
      EVALUATION_GROUP_DOCUMENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EVALUATION_GROUP_DOCUMENT_PRIVILEGES')  
    } ,            
	refs : [
	           {
				 ref : 'evalgroupdocumentgrid',
				 selector : 'evalgroupdocumentsgrid'
			   },{
				 ref : 'evalgroupdocumentwin',
				 selector : 'evalgroupdocumentwin'
			   },{
				 ref : 'evalGroupDocumentForm',
				 selector : 'evalgroupdocumentwin form'
			   },{
				 ref : 'evalgroupdetailform',
				 selector : 'evalgroupdetailform'
			   }
	          ],
	          init : function() {
	        	  this.control({
	        		  'evalgroupdocumentsgrid':{
		        			 render:function(obj){
	        				 /**
	        				  * User permission
	        				  */
	        				 this.doAccessControlValidation(obj, this.getEVALUATION_GROUP_DOCUMENT_PERMISSIONS()); 
	        				 /**
	        				  * Load data grid data on the bases of evaluation group id
	        				  */
		        				var evalGroupForm=this.getEvalgroupdetailform().getForm();
	    		        		var evalGroupId=evalGroupForm.findField('id').getValue();
		        				var store=obj.getStore();
		        				store.getProxy().extraParams = {
		        					evaluationGroupId: evalGroupId
	        	                    };
		        				store.load();
		        			 },
		        			 afterrender:function(grid){
		        				 /**
		        				  * This condition is used to make document tab in view mode.    
		        				  */
		        				 var evalGroupForm=this.getEvalgroupdetailform().getForm();
		        				 var wetherEditableField=evalGroupForm.findField('wetherEditable').getValue();
		        				 if(wetherEditableField=="false"){
		        					 grid.down('#btnAdd').setVisible(false);
		        					 grid.down('#btnEdit').setVisible(false);
		        					 grid.down('#btnDelete').setVisible(false);
		        				 }
		        			 }
		        		 },
	        		 'evalgroupdocumentsgrid button[itemId=btnAdd]':{
	        			 click:function(){
	        				 this.openDocumentWindow();
	        			 }
	        		 },
	        		 'evalgroupdocumentsgrid button[itemId=btnEdit]':{
	        			 click:function(){
	        				 this.loadDocumentFormData();
	        			 }
	        		 },
	        		 'evalgroupdocumentsgrid button[itemId=btnDelete]':{
	        			 click:function(){
	        				 this.deleteDocument();
	        			 }
	        		 },
	        		 'evalgroupdocumentsgrid button[itemId=btnView]':{
	        			 click:function(){
	        				 var $this=this;
	        				 $this.loadDocumentFormData();
	        				 var evalForm=$this.getEvalGroupDocumentForm();
                             var getForm=evalForm.getForm();
                             toggleReadOnlyFormItems(getForm, true);
                             evalForm.down('#btnSave').hide();
	        			 }
	        		 },
	        		 'evalgroupdocumentwin button[itemId=btnCancel]':{
	        			 click:function(obj){
	        				 obj.up('window').close();
	        			 }
	        		 },
	        		 'evalgroupdocumentwin button[itemId=btnSave]':{
	        			 click:function(obj){
	        				this.submitDocumentData(obj);
	        			 }
	        		 }
	        	  });
	          },
	          openDocumentWindow:function(){
      	    	var formWindow = this.getEvalgroupdocumentwin();
      			if (!formWindow) {
      				Ext.widget('evalgroupdocumentwin');
      				formWindow = this.getEvalgroupdocumentwin();
      			}
      			formWindow.show();
		       },
		        submitDocumentData:function(btn){
		        	btn.setDisabled(true);  
		        	var $this=this;
		        	var form=$this.getEvalGroupDocumentForm().getForm();
		        	var formValues=form.getValues();
		        	
		        	var evalGroupForm=$this.getEvalgroupdetailform().getForm();
					var evalGroupId=evalGroupForm.findField('id').getValue();
					 
					var submitData=new Academia.model.examinationcenters.evaluationgroup.document.EvalGroupCreateData();
		        	submitData.set('evaluationGroupId',evalGroupId);
		        	submitData.set('documentId',formValues.documentId);
		        	submitData.set('documentType',formValues.documentType);
		        	submitData.set('droolsRule',formValues.droolsRule);
		        	submitData.set('droolsRuleDescription',formValues.droolsRuleDescription);
		        	
		        	if(formValues.id>0&&formValues.id!=null){
		        		submitData.set('id',formValues.id);
		        		submitUrl= SERVERURL.EVAL_GROUP_DOCUMENT_UPDATE_URL;
		        	}else{
		        		submitUrl= SERVERURL.EVAL_GROUP_DOCUMENT_CREATE_URL;
		        	}
		        	/**
		        	 * Here delete document code from model.
		        	 */
		           	delete submitData.data.documentCode;
		           	var fData= Ext.encode(submitData.data);
		           	$this.applyWindowMask(); 
		      	   Ext.Ajax.request({
		           		 type: 'rest',
		           		 url: submitUrl,
		           		 jsonData: fData,
		           		 method: 'POST',
		           		 success: function(resp, action) {
		           			 $this.hideWindowMask();
		           			if(resp.responseText=='true' || resp.responseText=='Success'){
		           				showSuccessMessage(getExaminationTranslation('DOCUMENT'), getExaminationTranslation('DOCUMENT_SUCCES_MSG'));
	           				 }else{
	           					showWarningMessage(getExaminationTranslation('DOCUMENT'),getExaminationTranslation('DOCUMENT_ALREADY_MAPPED_MSG')); 
	           				 }
		           			 $this.getEvalgroupdocumentwin().close();
		           			 $this.getEvalgroupdocumentgrid().getStore().load();
		           		 }
		           	 });
		        },
		        /**
		         *Load data on form by find By id 
		         */
		        loadDocumentFormData:function(){
		        	var $this=this;
		        	var grid=$this.getEvalgroupdocumentgrid();
		        	if (grid.getSelectionModel().getCount() > 0) {
						$this.openDocumentWindow();
						var records = grid.getSelectionModel().getSelection()[0];
                        var form=$this.getEvalGroupDocumentForm().getForm();
						submitUrl=SERVERURL.EVAL_GROUP_DOCUMENT_FIND_BY_ID_URL;
			        	Ext.Ajax.request({
			           		 type: 'rest',
			           		 url: submitUrl,
			           		 method: 'GET',
			           		 params:{
			           			 id:records.data.id
			           		 },
			           		 success: function(resp, action) {
			           			var data= Ext.decode(resp.responseText);
			           			
			           			form.findField('id').setValue(data.id);
			           			form.findField('evaluationGroupId').setValue(data.evaluationGroupId);
			           			form.findField('droolsRule').setValue(data.droolsRule);
			           			form.findField('droolsRuleDescription').setValue(data.droolsRuleDescription);
			           			
			           			var documentIdField=form.findField('documentId');
			           			if(data.documentId!=null){
			           				documentIdField.getStore().load({
				           				callback:function(){
				           					documentIdField.setValue(data.documentId);
				           				}
				           		 	});
			           			 }
			           			
			           			var documentTypeField=form.findField('documentType');
			           			if(data.documentType!=null){
			           				documentTypeField.getStore().load({
				           				callback:function(){
				           					documentTypeField.setValue(data.documentType);
				           				}
				           		 	});
			           			 }
			           			
			           		 }
			           	 });
                	   } else {
                		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
                	  }
		        },
		      	deleteDocument:function(){
					 var $this=this;
					 var grid = $this.getEvalgroupdocumentgrid();
	           	 if (grid.getSelectionModel().getCount() > 0) {
	           		 var record = grid.getSelectionModel().getSelection()[0];
	           		 var id=record.data.id;
	           		showConfirmMessage(getExaminationTranslation('DOCUMENT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn, text) {
	           			 if (btn == 'yes'){
		           		 Ext.Ajax.request({
		           			 method: "DELETE",
		           			 type: 'rest',
		           			 url: SERVERURL.EVAL_GROUP_DOCUMENT_DELETE_URL+'?id='+id,
		           			 headers: {
		           				 'Content-Type': 'application/json'
		           			 },
		           			 success: function(form, action) {
		           				 if(form.responseText=='true'){
		           					showSuccessMessage(getExaminationTranslation('DOCUMENT'), getExaminationTranslation('DOCUMENT_DELETE_MSG'));	 
		           				 }else{
		           					showWarningMessage(getExaminationTranslation('DOCUMENT'),getExaminationTranslation('DOCUMENT_DELETE_WARNING_MSG')); 
		           				 }
		           				 grid.store.reload();
		           			 }
		           		 });
	           			}
	           		 });
	           	 } else {
	           		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
	           	 }
				}
});
