/**
 * @author Santosh Sahu
 * 
 */
Ext.define('Academia.controller.examinationcenters.manageEvaluation.ManageSpecialGradeController', {
	//extend : 'Ext.app.Controller',
	extend: 'Academia.controller.base.BaseController',
	models : [],
	stores : ['examinationcenters.reports.SpecialGradeListStore','examinationcenters.evaluation.CourseMaster',
	          'examinationcenters.reports.ExaminationReportProgramStore','examinationcenters.reports.SpecialGradeBatchStore','examinationcenters.reports.SpecialGradePeriodStore',
	          'examinationcenters.reports.ExaminationReportCourseStore','attendance.VariantMappedToPlan'
	         ,'feeandpayment.managebill.Student','examinationcenters.reports.ExaminationSpecialGradeComboStore',
	         'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',
	         'examinationcenters.reports.ExaminationReportStudentStore','attendance.VariantMappedToSpecialGrade',
	         'examinationcenters.reports.RevisedGradingTypeStore','examinationcenters.assessmentEvent.CoursesForEvents',
	         'examinationcenters.assessmentEvent.EvaluationPlanForEventStore','examinationcenters.reports.CriteriaBasedGradeListStore',
	         'examinationcenters.assessmentEvent.CoursesAndCourseGradeTypeForEvents','examinationcenters.reports.CriteriaBasedProgramStore',
	         'examinationcenters.evaluation.evaluationPlanHeirarchy.DroolCalculationData','examinationcenters.reports.GradeWiseStudentListStore','importutility.ModuleName','importutility.ImportAssessmentEventStore'],
	views : ['examinationcenters.examSpecialGrade.ManageSpecialGradeSearch','examinationcenters.examSpecialGrade.MangeSpecialGradeGrid'
	         ,'examinationcenters.examSpecialGrade.ManageSpecialGradeFilter','examinationcenters.examSpecialGrade.CriteriaBasedGradeGrid',
	         'examinationcenters.examSpecialGrade.CriteriaBasedGradeApplyWin','examinationcenters.examSpecialGrade.SpecialGradeSearchTabForm','examinationcenters.examSpecialGrade.ImportSpecialGrade',
	         'examinationcenters.examSpecialGrade.UploadSpecialGradeFilter','examinationcenters.examSpecialGrade.DownloadSpecialGradeFilter',
	         'examinationcenters.examSpecialGrade.ImportUtilitySpecialGrade','UploadOptionRadioGroup'],
	config:{
		MANAGE_SPECIAL_GRADE_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_SPECIAL_GRADE_PRIVILEGES'),
		MANAGE_REVISED_GRADE_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_REVISED_GRADE_PRIVILEGES')
		
         },
	          refs : [{
	        	  ref:'managespecialgradesearch',
	        	  selector:'managespecialgradesearch'
	          },{
	        	  ref:'mangespecialgradegrid',
	        	  selector:'mangespecialgradegrid'
	          },{
	        	  ref:'managespecialgradefilter',
	        	  selector:'managespecialgradefilter'
	          },{
	        	  ref:'criteriabasedgradegrid',
	        	  selector:'criteriabasedgradegrid'
	          },{
	        	  ref:'criteriabasedgradeapplywin',
	        	  selector:'criteriabasedgradeapplywin'
	          },{
	        	  ref:'specialgradesearchtabform',
	        	  selector:'specialgradesearchtabform'
	          },{
	        	  ref:'importspecialgrade',
	        	  selector:'importspecialgrade'
	          },{
	        	  ref:'downloadspecialgradefilter',
	        	  selector:'downloadspecialgradefilter'
	          },{
	        	  ref:'uploadspecialgradefilter',
	        	  selector:'uploadspecialgradefilter'
	          },{
	        	  ref:'importutilityspecialgrade',
	        	  selector:'importutilityspecialgrade'
	          },{         		
				  ref : 'uploadoptionradiogroup',	           	
				  selector : 'uploadoptionradiogroup[itemId=uploadSpecialGradeUploadOptionRadioGroupItemId]'
           	}],
	          init : function() {
	        	  this.control({
	        		  'managespecialgradesearch':{
	        			  render:function(structure){
             					this.disableImportTab(structure);
          			    }
	        		  },
	        		 'importspecialgrade radiogroup[itemId=importDownloadGradeId]':{
	        			   change: this.importDownloadUploadFormChange
	        		 },
	        		  'managespecialgradefilter':{
	        			  beforerender:function(obj,data){
	        				  this.disableCriteriaBasedGrade(grid, this.getMANAGE_REVISED_GRADE_PERMISSION());
	        			  },
	        			  render:function(obj){
	        				  var $this = this;
	        				  var form = $this.getManagespecialgradefilter().getForm();
	        				  var formFields=$this.getManagespecialgradefilter();
	        				  var radioButton = form.findField('radiogroupId');
	        				  var evalautionPlanId = formFields.down("#evalautionPlanId");
	        				  var criteriaBasedCourseId = formFields.down("#criteriaBasedCourseItemId");
	        				  var revisedGradingType = formFields.down("#revisedGradingTypeId");
	        				 
	        				  if(radioButton.getChecked()[0].getGroupValue()){
	        					  formFields.down('#criteriaBasedCourseFieldItemId').hide();
	        					  formFields.down('#specialGradeFieldItemId').show();
	        					  formFields.down('#admissionItemId').hide();
	        					  revisedGradingType.allowBlank=true;
		        				  evalautionPlanId.allowBlank=true;
		        				  criteriaBasedCourseId.allowBlank=true;
	        				  }else {
	        					  formFields.down('#criteriaBasedCourseFieldItemId').show();
	        					  formFields.down('#specialGradeFieldItemId').hide();
	        					  formFields.down('#admissionItemId').show();
	        					  revisedGradingType.allowBlank=false;
		        				  evalautionPlanId.allowBlank=false;
		        				  criteriaBasedCourseId.allowBlank=false;
	        				  }
	        				  var program = form.findField("programId");
	        				  var als = [];
	        				  als.push($this.getCurrentAcademyLocation());
	        				  program.getStore().getProxy().extraParams = {
	        					  whetherMarksheet:true,
	        					  academyLocationIds:als.join()
	        				  }

	        				  var courseId = form.findField("courseId");
	        				  courseId.getStore().getProxy().extraParams = {
	        					  whetherMarksheet:true,
	        					  academyLocationIds:als.join()
	        				  }

	        				  var specialGradeCombo = form.findField("specialGradeCombo");
	        				  specialGradeCombo.getStore().getProxy().extraParams = {
	        					  gradeType:'Special Grade'
	        				  }
	        				  specialGradeCombo.getStore().load({
	        					  callback:function(record){
	        						  if(record.length == 1){
	        							  specialGradeCombo.setValue(record[0].data.value);
	        						  }
	        					  }
	        				  });
	        				  
	        				  var criteriaBasedCourseId = form.findField("criteriaBasedCourseId");
	        				  criteriaBasedCourseId.getStore().getProxy().extraParams = {
	        					  whetherMarksheet:true,
	        					  academyLocationIds:als.join()
	        				  }
	        				  var criteriaBasedProgramId = form.findField("criteriaBasedProgramId");
	        				  criteriaBasedProgramId.getStore().getProxy().extraParams = {
	        					  whetherMarksheet:true,
	        					  academyLocationIds:als.join()
	        				  }
	        				  var admissionId = form.findField("admissionId");
	        				  admissionId.reset();
	        				  var studentListStore=admissionId.getStore();
	        				  studentListStore.getProxy().extraParams={
	        					  academyLocationIds:als.join()
	        				  };
	        				  //studentListStore.load();
	        			  }
	        		  },
	        		  'mangespecialgradegrid':{
	        			  render:function(grid){
	        				  var $this = this;
	        				  $this.doAccessControlValidation(grid, $this.getMANAGE_SPECIAL_GRADE_PERMISSION());
	        				  $this.calculateResultPivilegesAction(grid, $this.getMANAGE_SPECIAL_GRADE_PERMISSION());
	        				  var structure= this.getManagespecialgradesearch();
	        				  this.getGridHeaderFreeze(grid,structure,false);
	        				  var btnExportToPDF = grid.down('#btnExportToPDF');
	        				  var btnExportToExcel = grid.down('#btnExportToExcel');
	        				  if(btnExportToPDF){
	        					  btnExportToPDF.setDisabled(true)
	        				  }
	        				  if(btnExportToExcel){
	        					  btnExportToExcel.setDisabled(true)
	        				  }
	        				  
	        				  
	        			  },
	        			  
	        			  cellclick: function (view, cell, cellIndex, record, row, rowIndex, e) {
	        				  var $this = this;
							  var form = $this.getManagespecialgradefilter().getForm();
	        				  var speicialGradeStore = $this.getStore('examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades');
	        				  speicialGradeStore.getProxy().extraParams = {
	        					  gradeType : form.findField("specialGradeCombo").getValue() 
	        				  };
	        				  var arr=[];
	        				  var grid = view.up();
	        				  Ext.apply(grid,{
	        					  mlpData:null,
	        					  setMlpData : function(mlpData){
	        						  grid.mlpData = mlpData;
	        					  },
	        					  getMlpData:function(){
	        						  return grid.mlpData;
	        					  }
	        				  });
	        				  speicialGradeStore.load({
	        					  callback:function(record){
	        						  if(record.length>0){
	        							  for(var i in record){
	        								  arr.push(record[i])
	        							  }
	        						  }
	        						  grid.setMlpData(arr);
	        					  }
	        				  });
	        			  },
	        			  selectionchange:function(view,records){
	        				  var emptySpecialGradeArr = [];
	        				 var deleteBtn = this.getMangespecialgradegrid().down('#btnDelete');
	        				 if(records.length > 0){
	        					 for(var i =0 ;i< records.length ; i++){
		        					  if(isNullOrEmpty(records[i].data.specialGrade)){
		        						  emptySpecialGradeArr.push(records[i]);
		        					  }
		        				  } 
	        				 }
	        				 
	        				  if(emptySpecialGradeArr.length >0  && records.length > 0){
	        					  deleteBtn.disable();
	        				  }else if(records.length == 0){
	        					  deleteBtn.disable();
	        				  }else{
	        					  deleteBtn.enable(); 
	        				  }
	        				  
	        			  },
	        			  afterrender:function(grid){
	        				grid.getStore().removeAll();
	        			  }
	        		  },
	        		  'criteriabasedgradegrid':{
	        			  render:function(grid){
	        				  var $this = this;
	        				  $this.doAccessControlValidation(grid, $this.getMANAGE_REVISED_GRADE_PERMISSION());

	        				  $this.applyChangesPivilegesAction(grid, $this.getMANAGE_REVISED_GRADE_PERMISSION());
	        			  },
	        			  cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
	        				  var $this = this;
	        				  var form =  $this.getManagespecialgradefilter().getForm();
	        				  var dataIndex = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
	        				  if (dataIndex == 'revisedGrade' && 
	        						  form.findField('revisedGradingType').getValue().toUpperCase() == 'Automatic'.toUpperCase()) {
	        					 return false;
	        				  }
	        			  }
	        		  },
					'downloadspecialgradefilter button[itemId=specialGradeDownload]':{
		    			click : function(deleteButton) {
		 					$this=this;
		     				var form=$this.getDownloadspecialgradefilter();
		     				var formValues=form.getForm().getValues();
							var variantIds = [];
	                				   if(!isNullOrEmpty(formValues.courseVariant)){
	                					   for(var i=0;i<formValues.courseVariant.length;i++){
	                						   var variant=formValues.courseVariant[i];
	                						   variantIds.push(variant.data.id);
	                					   }
	                				   }
		     				var csvForm = Ext.create('Ext.form.Panel'); 
        	 				csvForm.getForm().submit({
        	 					target: '_blank',
        	 					method:'POST',
       	 					params :{
       	 						access_token : Ext.Ajax.defaultHeaders.access_token,
        	 						 academicTerm : formValues.academicTerm,
									 programId :formValues.programId,
									 batchId :formValues.batchId,
									 periodId :formValues.periodId,
						 			 courseId :formValues.courseId,
									 variantIds :variantIds.join(),
								     specialGradeName :formValues.specialGradeCombo,
        	 					},
        	 					headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
        	 					url: SERVERURL.DOWNLOAD_TEMPLATE_FOR_SPECIAL_GRADE,
        	 					standardSubmit :true
        	 				});
	 	   			 	}
		    		 },
		    		 'downloadspecialgradefilter button#resetBtn':{
		    			 click:function(){
		    					var als = [];
								als.push(this.getCurrentAcademyLocation());
							
		    				 var form =this.getDownloadspecialgradefilter().getForm();
								//form.reset();
		    				   var academicTerm = form.findField("academicTerm");
		    					var courseVariant = form.findField("courseVariant");
								var courseId = form.findField("courseId");
								var programId = form.findField("programId");
								var batchId= form.findField("batchId");
								var periodId = form.findField("periodId");
								var specialGrade =form.findField('specialGradeCombo');
								programId.reset();
								batchId.reset();
								periodId.reset();
								academicTerm.reset();
								courseId.reset();
								courseVariant.reset();
								courseVariant.clearValue();
								specialGrade.reset();
								batchId.setDisabled(true);
								periodId.setDisabled(true);
								programId.getStore().getProxy().extraParams = {
									academicTermId:academicTerm.getValue(),
									academyLocationIds:als.join(),
									whetherMarksheet:true,
								}
								programId.getStore().load();
		        				  courseId.getStore().getProxy().extraParams = {
		        					  academyLocationIds:als.join(),
		        					  whetherMarksheet:true,
		        				  }
								 courseId.getStore().load();
								 courseVariant.getStore().getProxy().extraParams = {
		        					  academyLocationId:als.join(),
		        					  whetherMarksheet:true,
		        				  }
								courseVariant.getStore().load();
		    			 }
		    		 },
		    		 'downloadspecialgradefilter customcombobox[itemId=academicTermItemId]':{
          			   afterrender :function(form){
        				   form.getStore().load();
        			   },
		    			 select:function(obj, record){
		    					var $this = this;
								var form = $this.getDownloadspecialgradefilter().getForm();
								var courseVariant = form.findField("courseVariant");
								var courseId = form.findField("courseId");
								var programId = form.findField("programId");
								var batchId= form.findField("batchId");
								var periodId = form.findField("periodId");
								programId.reset();
								batchId.reset();
								batchId.setDisabled(true);
								periodId.reset();
								periodId.setDisabled(true);;
								var als = [];
								als.push($this.getCurrentAcademyLocation());
								programId.getStore().getProxy().extraParams = {
									academicTermId:record[0].data.id,
									academyLocationIds:als.join(),
									whetherMarksheet:true,
								}
								programId.getStore().load({
										callback:function(records,operation,success){
											if(records.length == 1){
												programId.setValue(records[0].data.id);
												batchId.setDisabled(false);
												batchId.getStore().getProxy().extraParams = {
													programId:records[0].data.id,
													whetherMarksheet:true,
													academyLocationIds:als.join(),
													academicTermId :form.findField("academicTerm").getValue(),
												}
												batchId.getStore().load({
													callback:function(records,operation,success){
														if(records.length == 1){
															batchId.reset();
															batchId.setDisabled(false);
															batchId.setValue(records[0].data.id);
															periodId.getStore().getProxy().extraParams = {
															    programId:form.findField("programId").getValue(),
																batchId:records[0].data.id,
																whetherMarksheet:true,
																academyLocationIds:als.join(),
																academicTermId :form.findField("academicTerm").getValue(),
															}
															periodId.getStore().load({
																callback:function(records,operation,success){
																	if(records.length == 1){
																		periodId.reset();
																		periodId.setDisabled(false);
																		periodId.setValue(records[0].data.id);
																		
																		courseId.getStore().getProxy().extraParams = {
																			programId:form.findField("programId").getValue(),
																			academyLocationIds:als.join(),
																			batchId:form.findField("batchId").getValue(),
																			whetherMarksheet:true,
																			academicTermId :form.findField("academicTerm").getValue(),
																			periodId:form.findField("periodId").getValue(),
																		}
																		courseId.reset();
																		courseId.getStore().load({
																			callback:function(records,operation,success){
																				if(records.length == 1){
																					courseId.setValue(records[0].data.id);
																				}
																			}
																		});
																	}
																}
															});
															
															courseId.getStore().getProxy().extraParams = {
																programId:form.findField("programId").getValue(),
																academyLocationIds:als.join(),
																batchId:form.findField("batchId").getValue(),
																whetherMarksheet:true,
																academicTermId :form.findField("academicTerm").getValue(),
															}
															courseId.reset();
															courseId.getStore().load({
																callback:function(records,operation,success){
																	if(records.length == 1){
																		courseId.setValue(records[0].data.id);
																	}
																}
															});
														}
													}
												});
												
												
												courseId.getStore().getProxy().extraParams = {
													programId:form.findField("programId").getValue(),
													academyLocationIds:als.join(),
													whetherMarksheet:true,
													academicTermId :form.findField("academicTerm").getValue(),
												}
												courseId.reset();
												courseId.getStore().load({
													callback:function(records,operation,success){
														if(records.length == 1){
															courseId.setValue(records[0].data.id);
														}
													}
												});
											}
											
										}
								});
								courseId.reset();
								courseId.getStore().getProxy().extraParams = {
									academicTermId :form.findField("academicTerm").getValue(),
									academyLocationIds:$this.getCurrentAcademyLocation()
								}
								courseId.getStore().load({
									callback:function(records,operation){
										if(records.length ==1){
											courseId.setValue(records[0].data.id)	;
										}
									}
								});
								courseVariant.reset();
								courseVariant.getStore().getProxy().extraParams = {
									academicTermId :form.findField("academicTerm").getValue(),
									academyLocationId:$this.getCurrentAcademyLocation()
								}
								courseVariant.getStore().load({
									callback:function(records,operation){
										if(records.length ==1){
											courseVariant.setValue(records[0].data.id)	;
										}
									}
								});
								
								
		    			 }
		    		 },
		    		 'downloadspecialgradefilter':{
		    			 afterrender:function(){
		    				var form =  this.getDownloadspecialgradefilter();
		    				form.getForm().reset();
		    				var filterForm = form.getForm();
		    				var courseVariant = filterForm.findField('courseVariant');
		    				var als = [];
							als.push(this.getCurrentAcademyLocation());
		    				
		    				courseVariant.getStore().getProxy().extraParams={
		    					academyLocationId:this.getCurrentAcademyLocation(),
		    					whetherMarksheet:true,
		    				}
		    				courseVariant.getStore().load();
		    				var course = filterForm.findField("courseId");
	  						course.getStore().getProxy().extraParams = {
								academyLocationIds:als.join(),
								whetherMarksheet:true,
							}
	  						course.reset();
	  						course.getStore().load({
								callback:function(records,operation,success){
									if(records.length == 1){
										course.setValue(records[0].data.id);
									}
								}
							});
		    			 }
		    		 },
	        		  'downloadspecialgradefilter customcombobox[itemId=programComboItemId]':{
	        			  select:function(obj, record){
								var $this = this;
								var form = $this.getDownloadspecialgradefilter().getForm();
								
								var als = [];
								als.push($this.getCurrentAcademyLocation());
								var batchId = form.findField("batchId");
								var periodId= form.findField("periodId");
								var courseId = form.findField('courseId');
								batchId.reset();
								batchId.setDisabled(false);
								batchId.getStore().getProxy().extraParams = {
									programId:record[0].data.id,
									academicTermId :form.findField("academicTerm").getValue(),
									whetherMarksheet:true,
									academyLocationIds:als.join()
								}
								batchId.getStore().load({
									callback:function(records,operation,success){
										if(records.length == 1){
											batchId.setValue(records[0].data.id);
											periodId.reset();
											periodId.setDisabled(false);
											periodId.getStore().getProxy().extraParams = {
												programId:form.findField("programId").getValue(),
												batchId:records[0].data.id,
												whetherMarksheet:true,
												academyLocationIds:als.join(),
												academicTermId :form.findField("academicTerm").getValue(),
											}
											periodId.getStore().load({
												callback:function(records,operation,success){
													if(records.length == 1){
														periodId.setValue(records[0].data.id);
														courseId.getStore().getProxy().extraParams = {
															programId:form.findField("programId").getValue(),
															academyLocationIds:als.join(),
															batchId:form.findField("batchId").getValue(),
															whetherMarksheet:true,
															academicTermId :form.findField("academicTerm").getValue(),
															periodId:form.findField("periodId").getValue(),
														}
														courseId.reset();
														courseId.getStore().load({
															callback:function(records,operation,success){
																if(records.length == 1){
																	courseId.setValue(records[0].data.id);
																}
															}
														});
													}
												}
											});
											courseId.getStore().getProxy().extraParams = {
												programId:form.findField("programId").getValue(),
												academyLocationIds:als.join(),
												batchId:form.findField("batchId").getValue(),
												whetherMarksheet:true,
												academicTermId :form.findField("academicTerm").getValue(),
											}
											courseId.reset();
											courseId.getStore().load({
												callback:function(records,operation,success){
													if(records.length == 1){
														courseId.setValue(records[0].data.id);
													}
												}
											});
										}
										
									}
								});
								var course = form.findField("courseId");
		  						course.getStore().getProxy().extraParams = {
									programId:form.findField("programId").getValue(),
									academyLocationIds:als.join(),
									whetherMarksheet:true,
									academicTermId :form.findField("academicTerm").getValue(),
								}
		  						course.reset();
		  						course.getStore().load({
									callback:function(records,operation,success){
										if(records.length == 1){
											course.setValue(records[0].data.id);
										}
									}
								});
		  						
								var periodId = form.findField("periodId");
								periodId.reset();
								periodId.setDisabled(true);
								
								var courseVariantId= form.findField("courseVariant");
								courseVariantId.reset();
								courseVariantId.getStore().getProxy().extraParams = {
									programId:form.findField("programId").getValue(),
									academyLocationId:$this.getCurrentAcademyLocation(),
									academicTermId :form.findField("academicTerm").getValue(),
								}
								courseVariantId.getStore().load({
									callback:function(records,operation,success){
										if(records.length == 1){
											courseVariantId.setValue(records[0].data.id);
										}
									}
								});
								
							}
	        		  },
	        		  'downloadspecialgradefilter customcombobox[itemId=batchComboItemId]':{
							select:function(obj, record){
								var $this = this;
								var form = $this.getDownloadspecialgradefilter().getForm();
								var als = [];
								als.push($this.getCurrentAcademyLocation());
								var period = form.findField("periodId");
								period.reset();
								period.setDisabled(false);
								period.getStore().getProxy().extraParams = {
									programId:form.findField("programId").getValue(),
									batchId:record[0].data.id,
									whetherMarksheet:true,
									academyLocationIds:als.join(),
									academicTermId :form.findField("academicTerm").getValue(),
								}
								period.getStore().load({
									callback:function(records,operation,success){
										if(records.length == 1){
											period.setValue(records[0].data.id);
										}
									}
								});
								
								var course = form.findField("courseId");
		  						course.getStore().getProxy().extraParams = {
									programId:form.findField("programId").getValue(),
									periodId:form.findField("periodId").getValue(),
									academyLocationIds:als.join(),
									whetherMarksheet:true,
									academicTermId :form.findField("academicTerm").getValue(),
								}
								
								var courseId= form.findField("courseId");
								courseId.reset();
								courseId.getStore().getProxy().extraParams= {
									programId:form.findField("programId").getValue(),
									batchId:form.findField("batchId").getValue(),
									academyLocationIds:this.getCurrentAcademyLocation(),
									academicTermId :form.findField("academicTerm").getValue(),
								}
								courseId.getStore().load({
									callback:function(records,operation,success){
										if(records.length == 1){
											courseId.setValue(records[0].data.id);
										}
									}
								});
								var courseVariantId= form.findField("courseVariant");
								 
								courseVariantId.reset();
								 courseVariantId.getStore().getProxy().extraParams= {
									programId:form.findField("programId").getValue(),
									batchId:record[0].data.id,
									academyLocationId:this.getCurrentAcademyLocation(),
									academicTermId :form.findField("academicTerm").getValue(),
								}
								 courseVariantId.getStore().load({
										callback:function(records,operation,success){
											if(records.length == 1){
												courseVariantId.setValue(records[0].data.id);
											}
										}
									});
							}
						},
						'downloadspecialgradefilter customcombobox[itemId=periodComboItemId]':{
							select:function(obj, record){
								var $this = this;
								var form = $this.getDownloadspecialgradefilter().getForm();
								var course = form.findField("courseId");
								var als = [];
								als.push($this.getCurrentAcademyLocation());
								course.reset();
								//course.setDisabled(false);
								var courseVariant = form.findField("courseVariant");
								course.getStore().getProxy().extraParams = {
										programId:form.findField("programId").getValue(),
										batchId:form.findField("batchId").getValue(),
										periodId:form.findField("periodId").getValue(),
										academyLocationIds:als.join(),
										whetherMarksheet:true,
										academicTermId :form.findField("academicTerm").getValue(),
									}
								//course.setVisible(true);
								course.getStore().load();
								var courseId= form.findField("courseId");
								
								courseId.reset();
								courseId.getStore().getProxy().extraParams= {
									programId:form.findField("programId").getValue(),
									batchId:form.findField("batchId").getValue(),
									academyLocationIds:this.getCurrentAcademyLocation(),
									periodId:form.findField("periodId").getValue(),
									academicTermId :form.findField("academicTerm").getValue(),
								}
								courseId.getStore().load({
									callback:function(records,operation,success){
										if(records.length == 1){
											courseId.setValue(records[0].data.id);
										}
									}
								});
								var courseVariantId= form.findField("courseVariant");
								courseVariantId.reset();
								 courseVariantId.getStore().getProxy().extraParams= {
										programId:form.findField("programId").getValue(),
										batchId:form.findField("batchId").getValue(),
										academyLocationId:this.getCurrentAcademyLocation(),
										periodId:form.findField("periodId").getValue(),
										academicTermId :form.findField("academicTerm").getValue(),
									}
									 courseVariantId.getStore().load({
											callback:function(records,operation,success){
												if(records.length == 1){
													courseVariantId.setValue(records[0].data.id);
												}
											}
										});
								
								
								
							}
						},
						'downloadspecialgradefilter customcombobox[itemId=courseComboItemId]':{
							select:function(obj, record){
								var $this = this;
								var form = $this.getDownloadspecialgradefilter().getForm();
								var courseVariant = form.findField("courseVariant");
								var student = form.findField('STUDENT_ID');
								var als = [];
								als.push($this.getCurrentAcademyLocation());
								courseVariant.reset();
								courseVariant.getStore().getProxy().extraParams = {
									programId:form.findField("programId").getValue(),
									batchId:form.findField("batchId").getValue(),
									periodId:form.findField("periodId").getValue(),
									courseId:record[0].data.id,
									academicTermId :form.findField("academicTerm").getValue(),
									academyLocationIds:$this.getCurrentAcademyLocation()
								}
								courseVariant.getStore().load({
									callback:function(records,operation,success){
										if(records.length == 1){
											courseVariant.setValue(records[0].data.id);
										}
									}
								});
							}
						},
						
						 
						/*'downloadspecialgradefilter customcombobox[itemId=courseVariantComboItemId]':{
							select:function(obj, record){
								var $this = this;
								var form = $this.getDownloadspecialgradefilter().getForm();
								var als = [];
								als.push($this.getCurrentAcademyLocation());
								var studentId = form.findField("STUDENT_ID");
								studentId.reset();
								studentId.setDisabled(false);
								studentId.getStore().getProxy().extraParams = {
									programId:form.findField("programId").getValue(),
									batchId:form.findField("batchId").getValue(),
									periodId:form.findField("periodId").getValue(),
									academyLocationIds:als.join(),
									whetherMarksheet:true,
									courseId:form.findField("courseId").getValue(),
									courseVariantId:form.findField("courseVariant").getValue()
								}
								studentId.getStore().load();
							}
						},*/
						'managespecialgradefilter customcombobox[itemId=academicTermId]':{
             			   afterrender :function(form){
            				   form.getStore().load();
            			   },
							select:function(obj, record){
		    					var $this = this;
								var form = $this.getManagespecialgradefilter().getForm();
								var courseVariant = form.findField("courseVariant");
								var courseId = form.findField("courseId");
								var programId = form.findField("programId");
								var batchId= form.findField("batchId");
								var periodId = form.findField("periodId");
								programId.reset();
								batchId.reset();
								batchId.setDisabled(true);
								periodId.reset();
								periodId.setDisabled(true);
								
								var als = [];
								als.push($this.getCurrentAcademyLocation());
								programId.getStore().getProxy().extraParams = {
									academicTermId:record[0].data.id,
									whetherMarksheet:true,
									academyLocationIds:als.join()
								}
								programId.getStore().load({
										callback:function(records,operation,success){
											if(records.length == 1){
												programId.setValue(records[0].data.id);
												batchId.setDisabled(false);
												batchId.getStore().getProxy().extraParams = {
													programId:records[0].data.id,
													whetherMarksheet:true,
													academyLocationIds:als.join(),
													academicTermId :form.findField("academicTerm").getValue(),
												}
												batchId.getStore().load({
													callback:function(records,operation,success){
														if(records.length == 1){
															batchId.reset();
															batchId.setDisabled(false);
															batchId.setValue(records[0].data.id);
															periodId.getStore().getProxy().extraParams = {
															    programId:form.findField("programId").getValue(),
																batchId:records[0].data.id,
																whetherMarksheet:true,
																academyLocationIds:als.join(),
																academicTermId :form.findField("academicTerm").getValue(),
															}
															periodId.getStore().load({
																callback:function(records,operation,success){
																	if(records.length == 1){
																		periodId.reset();
																		periodId.setDisabled(false);
																		periodId.setValue(records[0].data.id);
																	}
																}
															});
														}
													}
												});
											}
											
										}
								});
								courseId.reset();
								courseId.getStore().getProxy().extraParams = {
									academicTermId :form.findField("academicTerm").getValue(),
									academyLocationIds:$this.getCurrentAcademyLocation()
								}
								courseId.getStore().load({
									callback:function(records,operation){
										if(records.length ==1){
											courseId.setValue(records[0].data.id)	;
										}
									}
								});
								courseVariant.reset();
								courseVariant.setDisabled(true);
								courseVariant.getStore().getProxy().extraParams = {
									academicTermId :form.findField("academicTerm").getValue(),
									academyLocationId:$this.getCurrentAcademyLocation()
								}
								courseVariant.getStore().load({
									callback:function(records,operation){
										if(records.length ==1){
											courseVariant.setValue(records[0].data.id)	;
										}
									}
								});
								var studentId = form.findField("STUDENT_ID");
								studentId.reset();
								studentId.setDisabled(true);
		    			    }
						},
	        		  'managespecialgradefilter customcombobox[itemId=programItemId]':{
						select:function(obj, record){
							var $this = this;
							var filterForm = $this.getManagespecialgradefilter();
							var form = $this.getManagespecialgradefilter().getForm();
							var batchItemId = filterForm.down('#batchItemId');
							var periodItemId = filterForm.down('#periodItemId');
							var courseVariantItemId = filterForm.down('#courseVariantItemId');
							var studentItemId = filterForm.down('#studentItemId');
							var als = [];
							als.push($this.getCurrentAcademyLocation());
							var batchId = form.findField("batchId");
							batchId.reset();
							batchId.setDisabled(false);
							batchId.getStore().getProxy().extraParams = {
								programId:record[0].data.id,
								whetherMarksheet:true,
								academyLocationIds:als.join(),
								academicTermId :form.findField("academicTerm").getValue(),
							}
							batchId.getStore().load({
								callback:function(records,operation,success){
									if(records.length == 1){
										batchItemId.setValue(records[0].data.id);
										periodItemId.setDisabled(false);
										periodItemId.getStore().getProxy().extraParams = {
											programId:form.findField("programId").getValue(),
											batchId:records[0].data.id,
											whetherMarksheet:true,
											academyLocationIds:als.join(),
											academicTermId :form.findField("academicTerm").getValue(),
										}
										periodItemId.getStore().load({
											callback:function(records,operation,success){
												if(records.length == 1){
													periodItemId.setValue(records[0].data.id);
												}
											}
										});
									}
									
								}
							});
							
							var course = form.findField("courseId");
	  						course.getStore().getProxy().extraParams = {
								programId:form.findField("programId").getValue(),
								academyLocationIds:als.join(),
								whetherMarksheet:true,
								academicTermId :form.findField("academicTerm").getValue(),
							}
	  						course.reset();
	  						course.getStore().load();
	  						
							var periodId = form.findField("periodId");
							periodId.reset();
							periodId.setDisabled(true);
							
							var courseVariantId= form.findField("courseVariant");
							courseVariantId.reset();
							courseVariantId.setDisabled(true);
							
							var studentId = form.findField("STUDENT_ID");
							studentId.reset();
							 form.findField("STUDENT_ID").lastQuery = null;
							studentId.setDisabled(true);
							
						}
					},
					
					'managespecialgradefilter customcombobox[itemId=batchItemId]':{
						select:function(obj, record){
							var $this = this;
							var form = $this.getManagespecialgradefilter().getForm();
							var als = [];
							als.push($this.getCurrentAcademyLocation());
							var period = form.findField("periodId");
							period.reset();
							period.setDisabled(false);
							period.getStore().getProxy().extraParams = {
								programId:form.findField("programId").getValue(),
								batchId:record[0].data.id,
								whetherMarksheet:true,
								academyLocationIds:als.join(),
								academicTermId :form.findField("academicTerm").getValue(),
							}
							period.getStore().load({
								callback:function(records,operation,success){
									if(records.length == 1){
										period.setValue(records[0].data.id);
									}
									
								}
							});
							
							var course = form.findField("courseId");
	  						course.getStore().getProxy().extraParams = {
	  							academicTermId :form.findField("academicTerm").getValue(),
							    programId:form.findField("programId").getValue(),
							    batchId:record[0].data.id,
								academyLocationIds:als.join(),
								whetherMarksheet:true,
							}
	  						course.getStore().load();
	  						course.reset();
							var courseId= form.findField("courseId");
							courseId.reset();
							var courseVariantId= form.findField("courseVariant");
							courseVariantId.reset();
							courseVariantId.setDisabled(true);
							
							
							var studentId = form.findField("STUDENT_ID");
							 form.findField("STUDENT_ID").lastQuery = null;
							studentId.reset();
							studentId.setDisabled(true);
							
						}
					},
					'managespecialgradefilter customcombobox[itemId=periodItemId]':{
						select:function(obj, record){
							var $this = this;
							var form = $this.getManagespecialgradefilter().getForm();
							var course = form.findField("courseId");
							var als = [];
							als.push($this.getCurrentAcademyLocation());
							course.reset();
							//course.setDisabled(false);
							var courseVariant = form.findField("courseVariant");
							course.getStore().getProxy().extraParams = {
									programId:form.findField("programId").getValue(),
									batchId:form.findField("batchId").getValue(),
									periodId:form.findField("periodId").getValue(),
									academyLocationIds:als.join(),
									whetherMarksheet:true,
									academicTermId :form.findField("academicTerm").getValue(),
								}
							//course.setVisible(true);
							course.getStore().load({
								callback:function(records,operation,success){
									if(records.length == 1){
										course.setValue(records[0].data.id);
									}
									
								}
							});
							var courseId= form.findField("courseId");
							courseId.reset();
							var courseVariantId= form.findField("courseVariant");
							courseVariantId.reset();
							courseVariantId.setDisabled(true);
							var studentId = form.findField("STUDENT_ID");
							studentId.reset();
							 form.findField("STUDENT_ID").lastQuery = null;
							studentId.setDisabled(true);
							
						}
					},
					'managespecialgradefilter customcombobox[itemId=courseItemId]':{
						select:function(obj, record){
							var $this = this;
							var form = $this.getManagespecialgradefilter().getForm();
							var courseVariant = form.findField("courseVariant");
							var student = form.findField('STUDENT_ID');
							var als = [];
							als.push($this.getCurrentAcademyLocation());
							courseVariant.reset();
							form.findField('STUDENT_ID').lastQuery = null;
							courseVariant.setDisabled(false);
							courseVariant.getStore().getProxy().extraParams = {
								courseId:record[0].data.id,
								academyLocationId:$this.getCurrentAcademyLocation(),
								academicTermId :form.findField("academicTerm").getValue(),
							}
							courseVariant.getStore().load({
								callback:function(records,operation,success){
									if(records.length == 1){
										courseVariant.setValue(records[0].data.id);
										student.reset();
										 form.findField('STUDENT_ID').lastQuery = null;
										student.setDisabled(false);
										student.getStore().getProxy().extraParams = {
											programId:form.findField("programId").getValue(),
											batchId:form.findField("batchId").getValue(),
											periodId:form.findField("periodId").getValue(),
											academyLocationIds:als.join(),
											whetherMarksheet:true,
											courseId:form.findField("courseId").getValue(),
											courseVariantId:form.findField("courseVariant").getValue(),
											academicTermId :form.findField("academicTerm").getValue(),
										}
										student.getStore().load();
									}
									
								}
							});
						}
					},
					
					 
					'managespecialgradefilter customcombobox[itemId=courseVariantItemId]':{
						select:function(obj, record){
							var $this = this;
							var form = $this.getManagespecialgradefilter().getForm();
							var als = [];
							als.push($this.getCurrentAcademyLocation());
							var studentId = form.findField("STUDENT_ID");
							studentId.reset();							
						    form.findField("STUDENT_ID").lastQuery = null;;							 
							studentId.setDisabled(false);
							studentId.getStore().getProxy().extraParams = {
								programId:form.findField("programId").getValue(),
								batchId:form.findField("batchId").getValue(),
								periodId:form.findField("periodId").getValue(),
								academyLocationIds:als.join(),
								whetherMarksheet:true,
								courseId:form.findField("courseId").getValue(),
								courseVariantId:form.findField("courseVariant").getValue(),
								academicTermId :form.findField("academicTerm").getValue(),
							}
							studentId.getStore().load();
						}
					},
					'managespecialgradefilter button[itemId=resetBtn]':{
						click:function(button){
							var $this = this;
							var form = $this.getManagespecialgradefilter().getForm();
							//form.reset();
							var grid = $this.getCriteriabasedgradegrid();
							var specialGradefilter = $this.getManagespecialgradefilter();
							var revisedGradingType = specialGradefilter.down("#revisedGradingTypeId");
							var studentId=specialGradefilter.down("#studentItemId");
							var specialGradeId = specialGradefilter.down("#specialGradeId");
							var moreFilterId = specialGradefilter.down("#moreFilterId");
							var criteriaBasedProgramId = specialGradefilter.down("#criteriaBasedProgramItemId");
							var criteriaBasedBatchId = specialGradefilter.down("#criteriaBasedBatchItemId");
							var criteriaBasedPeriodId = specialGradefilter.down("#criteriaBasedPeriodItemId");
							var criteriaBasedCourseFieldItemId = specialGradefilter.down("#criteriaBasedCourseFieldItemId");
							var specialGradeFieldItemId = specialGradefilter.down("#specialGradeFieldItemId");
							var specialGradeFieldId = specialGradefilter.down("#specialGradeFieldId");
							var evalautionPlanId = specialGradefilter.down("#evalautionPlanId");
							var criteriaBasedCourseId = specialGradefilter.down("#criteriaBasedCourseItemId");
							var criteriaBasedCourseVariantItemId = specialGradefilter.down("#criteriaBasedCourseVariantItemId");
							var studentId = specialGradefilter.down("#studentItemId");
							var specialGradeId = specialGradefilter.down("#specialGradeId");
							var programId = form.findField("programId");
							criteriaBasedCourseId.reset();
							criteriaBasedCourseVariantItemId.reset();
							evalautionPlanId.reset();
							criteriaBasedProgramId.reset();
							criteriaBasedBatchId.reset();
							criteriaBasedPeriodId.reset();
							programId.reset();
							revisedGradingType.reset();
							specialGradeId.reset();
							  var als = [];
	        				  als.push(this.getCurrentAcademyLocation());
	        				 

							var academicTerm = form.findField("academicTerm");
							academicTerm.reset();
							programId.getStore().getProxy().extraParams = {
	        					  whetherMarksheet:true,
	        					  academyLocationIds:als.join(),
	        					  academicTermId:academicTerm.getValue()
	        				  }
							programId.getStore().load();
							var batchId = form.findField("batchId");
							batchId.reset();
							batchId.setDisabled(true);

							var periodId = form.findField("periodId");
							periodId.reset();
							periodId.setDisabled(true);

							var courseId= form.findField("courseId");
							courseId.reset();

							var als = [];
							als.push($this.getCurrentAcademyLocation());

							courseId.getStore().getProxy().extraParams = {
								whetherMarksheet:true,
								academyLocationIds:als.join()
							}
							courseId.getStore().load();

							var courseVariantId= form.findField("courseVariant");
							courseVariantId.reset();
							courseVariantId.setDisabled(true);

							var studentId = form.findField("STUDENT_ID");
							studentId.reset();
							form.findField("STUDENT_ID").lastQuery = null;
							studentId.setDisabled(true);

							var criteriaBasedCourseId = form.findField("criteriaBasedCourseId");
							criteriaBasedCourseId.getStore().getProxy().extraParams = {
								whetherMarksheet:true,
								academyLocationIds:als.join()
							}
							criteriaBasedCourseId.getStore().load();
							var criteriaBasedProgramId = form.findField("criteriaBasedProgramId");
							criteriaBasedProgramId.getStore().getProxy().extraParams = {
								whetherMarksheet:true,
								academyLocationIds:als.join()
							}
							criteriaBasedProgramId.getStore().load();
							form.findField("criteriaBasedBatchId").setDisabled(true);
							form.findField("criteriaBasedPeriodId").setDisabled(true);
							var admissionId = form.findField("admissionId");
							admissionId.reset();
							var studentListStore=admissionId.getStore();
							studentListStore.getProxy().extraParams={
								academyLocationIds:als.join()
							};
							studentListStore.load();
							evalautionPlanId.reset();
							var evalautionPlanStore=evalautionPlanId.getStore();
							evalautionPlanStore.getProxy().extraParams={
								academyLocationIds:als.join()
							};
							evalautionPlanStore.load();
							grid.columns[6].setVisible(false);
							grid.columns[7].setVisible(false);
							grid.columns[9].setVisible(false);
							grid.columns[11].setVisible(false);
							grid.columns[12].setVisible(false);
						}
					},
					'managespecialgradefilter button[itemId=searchBtn]':{
						click:function(button){
							var $this = this;
							var form = $this.getManagespecialgradefilter().getForm();
							var formFields=$this.getManagespecialgradefilter();
							var radioButton = form.findField('radiogroupId');
							var formValues=form.getValues();
							var sform = $this.getManagespecialgradefilter();
							
							
							var courseVariantArray=[];
			 				   if(!isNullOrEmpty(formValues.criteriaBasedCourseVariant)){
			 					   for(var i=0;i<formValues.criteriaBasedCourseVariant.length;i++){
			 						   var cvValue=formValues.criteriaBasedCourseVariant[i];
			 						   if(Ext.isObject(cvValue)){
			 							  courseVariantArray.push(cvValue.data.id);
			 						   }
			 					   }
			 				}
							
							
							if(radioButton.getChecked()[0].getGroupValue()){

								var grid = $this.getMangespecialgradegrid();
								
								
								 var btnExportToPDF = grid.down('#btnExportToPDF');
		        				  var btnExportToExcel = grid.down('#btnExportToExcel');
		        				
								grid.config.searchFilterForm = sform;
								var gridStore = grid.getStore();
								gridStore.getProxy().extraParams = {
									programId:form.findField("programId").getValue(),
									batchId:form.findField("batchId").getValue(),
									periodId:form.findField("periodId").getValue(),
									courseId:form.findField("courseId").getValue(),
									courseVariantId:form.findField("courseVariant").getValue(),
									admissionId:form.findField("STUDENT_ID").getValue(),
									forManageSpecialGrade:true
								}
								gridStore.load({
									callback : function(record) {
										if(record.length >0){

											if(btnExportToPDF){
												btnExportToPDF.setDisabled(false)
											}
											if(btnExportToExcel){
												btnExportToExcel.setDisabled(false)
											}
										}
										Ext.ComponentQuery.query('mangespecialgradegrid')[0].reconfigure();
										grid.getView().refresh();
									}
								});

								//var speicialGradeCombo = grid.down('#specialGradeItemId');
								/*speicialGradeStore = $this.getStore('examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades');
								//speicialGradeCombo.getStore();
								speicialGradeStore.getProxy().extraParams = {
									gradeType : form.findField("specialGradeCombo").getValue() 
								}
								speicialGradeStore.load();*/

								var form = $this.getManagespecialgradefilter().getForm();
								var speicialGradeStore = $this.getStore('examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades');
								speicialGradeStore.getProxy().extraParams = {
									gradeType : form.findField("specialGradeCombo").getValue() 
								};
								var arr=[];
								Ext.apply(grid,{
									mlpData:null,
									setMlpData : function(mlpData){
										grid.mlpData = mlpData;
									},
									getMlpData:function(){
										return grid.mlpData;
									}
								});
								speicialGradeStore.load({
									callback:function(record){
										if(record.length>0){
											for(var i in record){
												arr.push(record[i])
											}
										}
										grid.setMlpData(arr);
										grid.getView().refresh();
									}
								});

							}else{
								var grid = $this.getCriteriabasedgradegrid();
								grid.config.searchFilterForm = sform;
								var gridStore = grid.getStore();
								gridStore.getProxy().extraParams = {
									programId:form.findField("criteriaBasedProgramId").getValue(),
									batchId:form.findField("criteriaBasedBatchId").getValue(),
									periodId:form.findField("criteriaBasedPeriodId").getValue(),
									courseId:form.findField("criteriaBasedCourseId").getValue(),
									//courseVariantId:form.findField("criteriaBasedCourseVariant").getValue(),
									admissionId:form.findField("admissionId").getValue(),
									evaluationPlanId:form.findField("evaluationplan").getValue(),
									courseVariantIds:courseVariantArray.join()
								}
								Ext.apply(grid,{
					        		code:null,
					     		  setCode : function(code){
					     			 grid.code = code;
					     		  },
					     		  getCode:function(){
					     			  return grid.code;
					     		  }
								});
								grid.setCode(form.findField("revisedGradingType").getValue());
								gridStore.load({
									callback : function() {
										Ext.ComponentQuery.query('criteriabasedgradegrid')[0].reconfigure();
										grid.getView().refresh();
									}
								});
								var courseGradeType=null;
								var courseStore=form.findField("criteriaBasedCourseId").getStore();
								var criteriaBasedCourseId=form.findField("criteriaBasedCourseId");
								 for(var i in courseStore.data.items){
	                				   if(courseStore.data.items[i].data.id==criteriaBasedCourseId.getValue()){
	                					   courseGradeType=	 courseStore.data.items[i].data.code;
	                				   }
	                			   }
								var form = $this.getManagespecialgradefilter().getForm();
								var speicialGradeStore = $this.getStore('examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades');
								speicialGradeStore.getProxy().extraParams = {
									gradeType : courseGradeType
								};
								var arr=[];
								Ext.apply(grid,{
									mlpData:null,
									setMlpData : function(mlpData){
										grid.mlpData = mlpData;
									},
									getMlpData:function(){
										return grid.mlpData;
									}
								});
								speicialGradeStore.load({
									callback:function(record){
										if(record.length>0){
											for(var i in record){
												arr.push(record[i])
											}
										}
										grid.setMlpData(arr);
										grid.getView().refresh();
									}
								});
								var revisedGrade=form.findField("revisedGradingType");
								if(revisedGrade.getValue()=="AUTOMATIC"){
									grid.columns[11].setVisible(false);
								}else {
									grid.columns[11].setVisible(true);
								}
							}
							grid.getSelectionModel().deselectAll();
							
							$this.resetPageSetting(grid.getStore(), grid);
							//grid.getStore().load();     
							grid.getSelectionModel().deselectAll();
							grid.getStore().pageSize=100;
						}
					},
					'mangespecialgradegrid button[itemId=btnDelete]':{
						click:function(button){
							var $this = this;
							var jsonArr=[];
							var specialGradeArr =[];
							var grid = $this.getMangespecialgradegrid();
							if(grid.getSelectionModel().getCount() >0){
								
								
								var record = grid.getSelectionModel().getSelection();
								for(var i in record) {
									if(record[i].data.specialGrade== "" || record[i].data.specialGrade== null ){
										specialGradeArr.push(record[i].data.specialGrade);  
									}
									jsonArr.push({
										"admissionId":record[i].data.admissionId,
										"courseVariantId":record[i].data.courseVariantId,
										"sectionId":record[i].data.sectionId,
										"periodId":record[i].data.periodId,  
										"periodName":record[i].data.periodName,
										"specialGrade":!isNullOrEmpty(record[i].data.specialGradeCode) ? record[i].data.specialGradeCode:record[i].data.specialGrade,
										"gradePoint":record[i].data.specialGradePoint,
										"resultStatus":record[i].data.resultStatus
									});
								}
								if(specialGradeArr.length > 0 ) {
									showWarningMessage(getExaminationTranslation('SPECIAL_GRADE'),getExaminationTranslation('PLEASE_ENTER_A_SPECIAL_GRADE_FOR_ALL_THE_SELECTED_RECORDS'));
								}

								else{
									showConfirmMessage(getExaminationTranslation('SPECIAL_GRADE'), getExaminationTranslation('ARE_YOU_SURE_YOU_WANT_TO_DELETE_THESE_RECORDS_?'),function(btn, text) {
									if (btn == 'yes') {
										var submitUrl = SERVERURL.PATH_DELETE_SPECIAL_GRADE;
										Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
										Ext.Ajax.request({
											type : 'rest',
											url : submitUrl,
											jsonData : jsonArr,
											method : 'POST',
											success : function(resp, action) {
												Ext.getBody().unmask();
												showSuccessMessage(getExaminationTranslation('SPECIAL_GRADE'), getExaminationTranslation('SPECIAL_GRADE_DELETED_SUCCESSFULLY'));
												grid.store.reload();
												grid.getSelectionModel().deselectAll();
											}
										});
									   }
									});
									
								}
							}else{
								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
							}
							
						}
					},
					'mangespecialgradegrid button[itemId=btnCalculateMarksheet]':{
						click:function(button){
							var $this = this;
							
							$this.calculateResultSpecialGrade();
			                	 
							/*var form = $this.getManagespecialgradefilter().getForm();
							var grid = $this.getMangespecialgradegrid();
							if (grid.getSelectionModel().getCount() > 0) {
					    		var record = grid.getSelectionModel().getSelection();
					    		
					    		var examSpecialGradeList = new Array();
					    		for(var i in record){
					    			
					    			var examSpecialGradeModel = new Object();
						    		examSpecialGradeModel.courseVarientId = record[i].get("courseId");
					    			examSpecialGradeModel.periodId = record[i].get("periodId");
					    			
					    			examSpecialGradeList.push(examSpecialGradeModel);
					    		}
					    		console.log('Data '+examSpecialGradeList);
							}*/
						}
					},
					
					'managespecialgradefilter radiogroup[itemId=criteriaBasedGradeId]':{
         			   change:function(obj) {
         				   var $this=this;
	                	   var form = $this.getManagespecialgradefilter().getForm();
	                	   var specialGradefilter = $this.getManagespecialgradefilter();
	                	   var revisedGradingType = specialGradefilter.down("#revisedGradingTypeId");
	                	   var programId = specialGradefilter.down("#programItemId");
	                	   var batchId = specialGradefilter.down("#batchItemId");
	                	   var periodId = specialGradefilter.down("#periodItemId");
	                	   var courseId=specialGradefilter.down("#courseItemId");
	                	   var courseVariantId=specialGradefilter.down("#courseVariantItemId");
	                	   var studentId=specialGradefilter.down("#studentItemId");
	                	   var specialGradeId = specialGradefilter.down("#specialGradeId");
	                	   var moreFilterId = specialGradefilter.down("#moreFilterId");
	                	   var criteriaBasedProgramId = specialGradefilter.down("#criteriaBasedProgramItemId");
	                	   var criteriaBasedBatchId = specialGradefilter.down("#criteriaBasedBatchItemId");
	                	   var criteriaBasedPeriodId = specialGradefilter.down("#criteriaBasedPeriodItemId");
	                	   var criteriaBasedCourseFieldItemId = specialGradefilter.down("#criteriaBasedCourseFieldItemId");
	                	   var specialGradeFieldItemId = specialGradefilter.down("#specialGradeFieldItemId");
	                	   var specialGradeFieldId = specialGradefilter.down("#specialGradeFieldId");
	                	   var evalautionPlanId = specialGradefilter.down("#evalautionPlanId");
	                	   var criteriaBasedCourseId = specialGradefilter.down("#criteriaBasedCourseItemId");
	                	   var criteriaBasedCourseVariantItemId = specialGradefilter.down("#criteriaBasedCourseVariantItemId");
	                	   var studentId = specialGradefilter.down("#studentItemId");
	                	   var searchbtn= $this.getManagespecialgradefilter().down("#searchBtn");
	                	   var specialGradeId = specialGradefilter.down("#specialGradeId");
	                	   var admissionId = specialGradefilter.down("#admissionItemId");
	                	   var specialgradesearchtabform=obj.up('specialgradesearchtabform'); 
	                	   searchbtn.setDisabled(true);
	                	   var als = [];
						   als.push($this.getCurrentAcademyLocation());
	                	   var specialGradeGrid = $this.getMangespecialgradegrid();
         				   var criteriaBasedGrid = $this.getCriteriabasedgradegrid();
         				   var radioButton = form.findField('radiogroupId');
         				   if(radioButton.items.items[0].checked){
         					   revisedGradingType.reset();
         					   revisedGradingType.hide();
         					   moreFilterId.hide();
         					   programId.show();
         					   batchId.show();
         					   periodId.show();
         					   criteriaBasedCourseFieldItemId.hide();
         					   specialGradeFieldItemId.show();
         					   specialGradeFieldId.show();  
         					   
         					   criteriaBasedGrid.setVisible(false);
         					   courseId.allowBlank=false;
         					   courseVariantId.allowBlank=false;
         					   specialGradeId.allowBlank=false;
         					   revisedGradingType.allowBlank=true;
         					   evalautionPlanId.allowBlank=true;
         					   criteriaBasedCourseId.allowBlank=true;

         					   programId.reset();
         					   batchId.reset();
         					   batchId.setDisabled(true);
         					   periodId.reset();
         					   periodId.setDisabled(true);
         					   courseId.reset();
         					   var als = [];
         					   als.push($this.getCurrentAcademyLocation());

         					   courseId.getStore().getProxy().extraParams = {
         						   whetherMarksheet:true,
         						   academyLocationIds:als.join()
         					   }
         					   //courseId.getStore().load();

         					   courseVariantId.reset();
         					   courseVariantId.setDisabled(true);

         					   studentId.reset();
         					   studentId.setDisabled(true);
         					  specialGradeId.reset();
         					 admissionId.reset();
         					admissionId.hide();      
                            specialgradesearchtabform.down('mangespecialgradegrid').setVisible(true);	
         				   }
         				   else{
         					   revisedGradingType.reset();
         					   revisedGradingType.show();
         					   programId.hide();
         					   batchId.hide();
         					   periodId.hide();
         					   moreFilterId.show();
         					   criteriaBasedCourseFieldItemId.show();
         					   specialGradeFieldItemId.hide();
         					   specialGradeFieldId.hide();
         					   specialGradeGrid.setVisible(false);
         					   criteriaBasedGrid.setVisible(true);
         					   courseId.allowBlank=true;
         					   courseVariantId.allowBlank=true;
         					   specialGradeId.allowBlank=true;
         					   revisedGradingType.allowBlank=false;
         					   evalautionPlanId.allowBlank=false;
         					   evalautionPlanId.reset();
         					   criteriaBasedCourseVariantItemId.reset();
         					   criteriaBasedCourseId.allowBlank=false;
         					   criteriaBasedProgramId.reset();
         					   var criteriaBasedCourseId = form.findField("criteriaBasedCourseId");
         					   criteriaBasedCourseId.reset();
         					   criteriaBasedCourseId.getStore().getProxy().extraParams = {
         						   whetherMarksheet:true,
         						   academyLocationIds:als.join()
         					   }
         					   //criteriaBasedCourseId.getStore().load();
         					   var criteriaBasedProgramId = form.findField("criteriaBasedProgramId");
         					   criteriaBasedProgramId.reset();
         					   criteriaBasedProgramId.getStore().getProxy().extraParams = {
         						   whetherMarksheet:true,
         						   academyLocationIds:als.join()
         					   }
         					   //criteriaBasedProgramId.getStore().load();
         					   form.findField("criteriaBasedBatchId").reset();
         					   form.findField("criteriaBasedBatchId").setDisabled(true);
         					   form.findField("criteriaBasedPeriodId").reset();
         					   form.findField("criteriaBasedPeriodId").setDisabled(true);
         					   admissionId.reset();
         					   admissionId.show();
         					   var studentListStore=admissionId.getStore();
         					   studentListStore.getProxy().extraParams={
         						   academyLocationIds:als.join(),
         					   };
         					  // studentListStore.load();
         				   }
//         				   marksGrid.getStore().loadRawData(null);
         				 //  $this.formReset(form);
//         				   marksGrid.getStore().load();
         			   }
         		   },
         		   
         		   'managespecialgradefilter customcombobox[itemId=criteriaBasedCourseItemId]':{
         			   select:function(obj,rec){
         				   var $this=this;
         				   $this.loadEvaluationPlan();
         			   }
         		   },
         		  'managespecialgradefilter customcombobox[itemId=evalautionPlanId]':{
         			  select:function(obj,rec){
         				  var $this=this;
         				  var form = $this.getManagespecialgradefilter().getForm();
         				  var alinfomodel = Academia.model.authentication.ALInfoModel;
                    	  var wheatherSchool = alinfomodel.get('wheatherSchool');
         				  var admissionId = form.findField("admissionId");
         				  var course = form.findField("criteriaBasedCourseId");
         				  var evaluation = form.findField("evaluationplan");
         				  var courseVariant = form.findField('criteriaBasedCourseVariant');
                          courseVariant.reset();

         				  var als = [];
         				  als.push($this.getCurrentAcademyLocation());
         				  admissionId.reset();
         				  var studentListStore=admissionId.getStore();
         				  studentListStore.getProxy().extraParams={
         					  academyLocationIds:als.join(),
         					  courseId:course.getValue(),
         					  evaluationPlanId:evaluation.getValue(),
         					 wheatherSchool:wheatherSchool
         				  };
//         				  studentListStore.load();
                        courseVariant.getStore().getProxy().extraParams={
                		    evaluationPlanId:rec[0].data.id,
                		    //  evaluationPlanType:'ACADEMICS',
                	    	//  evaluationStage:'COURSE_EXECUTION',
                		    //  academyLocationId:$this.getCurrentAcademyLocation(),
                		    courseId:course.getValue(),
                		    wheatherSchool:wheatherSchool
                		    // whetherDynamicPlan:true
                	};

         			  }
        		   },
        		   'managespecialgradefilter customcombobox[itemId=criteriaBasedCourseVariantItemId]':{
        			   select:function(obj,rec){
        				   var $this=this;
        				   var form = $this.getManagespecialgradefilter().getForm();
        				   var alinfomodel = Academia.model.authentication.ALInfoModel;
                     	   var wheatherSchool = alinfomodel.get('wheatherSchool');
        				   var admissionId = form.findField("admissionId");
        				   var course = form.findField("criteriaBasedCourseId");
        				   var evaluationplan = form.findField("evaluationplan");
        				   var courseVariant = form.findField("criteriaBasedCourseVariant");
        				   var als = [];
						   als.push($this.getCurrentAcademyLocation());
        				   admissionId.reset();
        				   var studentListStore=admissionId.getStore();
        				   studentListStore.getProxy().extraParams={
        					   academyLocationIds:als.join(),
        					   courseId:course.getValue(),
        					   evaluationPlanId:evaluationplan.getValue(),
        					   courseVariantId:courseVariant.getValue(),
        					   wheatherSchool:wheatherSchool
        				   };
        				   studentListStore.load();
        			   }
         		   },
         		   'criteriabasedgradegrid button[itemId=applyChangesId]':{
         			   click:function(button){
         				   var $this = this;
         				   var grid = $this.getCriteriabasedgradegrid();
         				   var record = grid.getSelectionModel().getSelection();
         				   if(record.length > 0) {
         					   var specialGradefilter = $this.getManagespecialgradefilter();
         					   var revisedGradingType = specialGradefilter.down("#revisedGradingTypeId");
         					   var flag=false;
         					   var markAttendance=true;
         					   
         					   if(revisedGradingType.getValue()==="AUTOMATIC"){
         						   for(var i=0;i<record.length;i++){
         							   if(record[i].data.attendancePercentage==null){
         								   markAttendance=false;
         								   //flag=true;
         							   }
         						   }
         					   }
         					   
         					   /*if(revisedGradingType.getValue()==="AUTOMATIC"){
         						   for(var i=0;i<record.length;i++){
         							   if(record[i].data.attendancePercentage==null){
         								   markAttendance=true;
         								   flag=true;
         							   }
         						   }
         					   } else {
         						   for(var i=0;i<record.length;i++){
         							   if(record[i].data.revisedGrade==null){
         								   markAttendance=false;
         								   flag=true;
         							   }
         						   }
         					   }*/

         					  //  if(!flag && !markAttendance){
         						   var formWindow = this.getCriteriabasedgradeapplywin();
         						   if (!formWindow) {
         							   Ext.widget('criteriabasedgradeapplywin');
         							   formWindow = this.getCriteriabasedgradeapplywin();
         						   }
         						   formWindow.show();  
         						   var ruleApplicable=formWindow.down('#droolsItemId');
         						   var noOfRecords=formWindow.down('#noOfRecords');
         						   var setMarkAttendance=formWindow.down('#markAttendance');
         						   var setFlag=formWindow.down('#flag');
         						   noOfRecords.setValue(record.length);
         						   setMarkAttendance.setValue(markAttendance);
         						   setFlag.setValue(flag);
         						   if(revisedGradingType.getValue()=="AUTOMATIC"){
         							   ruleApplicable.show();
         							   ruleApplicable.allowBlank=false;
         						   }else {
         							   ruleApplicable.hide();
         							   ruleApplicable.allowBlank=true;
         						   }
         						  /* }else {
         						   if(markAttendance){
         							   showWarningMessage(getExaminationTranslation('REVISED_GRADE'),getExaminationTranslation('ATTENDANCE_NOT_MARKED'));
         						   }else {
         							   showWarningMessage(getExaminationTranslation('REVISED_GRADE'),getExaminationTranslation('PLEASE_SELECT_REVISED_GRADE'));
         						   }
         					   }*/
         				   }
         				   else {
         					   showWarningMessage(getExaminationTranslation('REVISED_GRADE'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
         				   }
         			   }
         		   },
         		  'criteriabasedgradeapplywin button[itemId=submitBtnWin]':{
        			   click:function(button){
        				   var $this = this;
        				   $this.calculateApplyChanges(button);
        			   }
        		   },
        		   'criteriabasedgradeapplywin button[itemId=cancelBtn]':{
        			   click:function(button){
        				   var $this = this;
        				   button.up('window').close();
        			   }
        		   },

        		   'managespecialgradefilter customcombobox[itemId=criteriaBasedProgramItemId]':{
						select:function(obj, record){
							var $this = this;
							var form = $this.getManagespecialgradefilter().getForm();
							var als = [];
							als.push($this.getCurrentAcademyLocation());
							var batchId = form.findField("criteriaBasedBatchId");
							batchId.reset();
							batchId.setDisabled(false);
							batchId.getStore().getProxy().extraParams = {
								programId:record[0].data.id,
								whetherMarksheet:true,
								academyLocationIds:als.join()
							}
							batchId.getStore().load();
							
	  						
							var periodId = form.findField("criteriaBasedPeriodId");
							periodId.reset();
							periodId.setDisabled(true);
							
						}
					},
					
					'managespecialgradefilter customcombobox[itemId=criteriaBasedBatchItemId]':{
						select:function(obj, record){
							var $this = this;
							var form = $this.getManagespecialgradefilter().getForm();
							var als = [];
							als.push($this.getCurrentAcademyLocation());
							var period = form.findField("criteriaBasedPeriodId");
							period.reset();
							period.setDisabled(false);
							period.getStore().getProxy().extraParams = {
								programId:form.findField("criteriaBasedProgramId").getValue(),
								batchId:record[0].data.id,
								whetherMarksheet:true,
								academyLocationIds:als.join()
							}
							period.getStore().load();
							
						}
					},
					'criteriabasedgradeapplywin':{
						render:function(obj){
							var drools = obj.down('#droolsItemId');
							drools.getStore().getProxy().extraParams={
								moduleName:'REVISED_GRADE'
							};
							drools.getStore().load();
						}
					},
					
   				 'uploadspecialgradefilter button[itemId=resetBtn]':{
   	 	        		click:function(obj){
   					 				var $this = this;
   					 				var form =obj.up('uploadspecialgradefilter').getForm();
   					 				form.findField('file').reset();
   					 				var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
   					 				uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
   					 					isUploadAll: false
   					 				});
   					 				  form.checkValidity();
   					 			},
   					 			render :function(obj){
   					 				var $this = this;
   					 				var form =obj.up('uploadspecialgradefilter').getForm();
   					 				var combo = form.findField('importUtilityMasterId');
   					 				combo.getStore().load({
   					 					callback: function(records, operation, success) {
   					 						for(var i in records){
   					 							if(records[i].data.value=='Import Special Grade'){
   					 								combo.setValue(records[i].data.id);
   					 								combo.setReadOnly(true);
   					 							}
   					 						}
   					 					}	   
   					 				});
   					 			}  
   	        		 },
                 'uploadspecialgradefilter uploadoptionradiogroup[itemId=uploadSpecialGradeUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
 	    	        	change: function( radioGroup, newValue, oldValue, eOpts){
 	    	        		var grid =this.getImportutilityspecialgrade();
 	    	        		var form =this.getUploadoptionradiogroup();
 	    	        		var isUploadAll = newValue.isUploadAll;
 	    	        		this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'Import Special Grade');
 	    	        	}   
 	    	 		   }, 
 					'uploadspecialgradefilter button[itemId=specialGradeUpload]':{
 		        		click:function(obj){
 		        			var $this=this;
 		    	        	var importWin=$this.getUploadspecialgradefilter()
 		    	        	var grdStore;
 		    	        	var grid = $this.getImportutilityspecialgrade();
 		    	        	var form=$this.getUploadspecialgradefilter();
 		    	        	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
 		    	        	$this.getHashOfFile(form);
 				        	setTimeout(function() {
 			    	        	form.getForm().submit({
 			    	        		method : 'POST',
 			    	        		url : submitUrl,
 			    	        		success : function(form, action){
 			    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY') ,getCommonTranslation('SUCCESS'));
 			    	    	        },
 			    	        		failure: function(form, action) {
 		   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
 			    	    	        }
 			    	        	});
 				        	},1000);
 		    	        	
 		    	        	Ext.defer(function() {
 		    	        		var form =this.getUploadoptionradiogroup();
 		    	        		var isUploadAll = form.items.items[0].getValue().isUploadAll;
 		    	        		this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'Import Special Grade');
     	    	        	}, 2000, this);
 		        		}  
 		        	  },
  					'importutilityspecialgrade':{
 		         		     render : function(obj){
 		        				var $this = this;
 		        				var grid = $this.getImportutilityspecialgrade();
 		        				var form =this.getUploadoptionradiogroup();
 		    	        		var isUploadAll = form.items.items[0].getValue().isUploadAll;
 		    	        		$this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'Import Special Grade');
 		        			  },
 		        			  cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
 		          				if (e.target.tagName == 'A') {
 		          					var fileType=null;
 		          					if(cellIndex==1){
 		          						fileType='successFile';
 		          					}else if(cellIndex==6){
 		          						fileType='errorFile';
 		          					}else if(cellIndex==7){
 		          						fileType='logFile';
 		          					}
 		          					var documentId = record.get("id");
 		          					if (!isNullOrEmpty(documentId)) {
 		          						this.getCourseCreationDownloadFile(documentId,fileType);
 		          					}
 		          				}
 		          			}
 		         		},
 		         		  
 			         	'importutilityspecialgrade button[itemId=btnForce]':{
 			            			click: function(obj) {
 			         	            	var grid = this.getImportutilityspecialgrade();
 			         	            	if (grid.getSelectionModel().getCount() > 0) {
 			         	            		if(grid.getSelectionModel().getCount() > 1){
 			         		        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
 			         		        		}else{
 			         		        			var this$ = this;
 			            	                	var id = grid.getSelectionModel().selectionStart.data.id;
 			            	                	console.log(id);
 			            	                	var urlAppend="?jobName="+ id;
 			            	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+ urlAppend;
 			            	    	        	Ext.Ajax.request({
 			            	    	        		url: submitURL,
 			            	    	        		method: 'GET',
 			            	    	        		success: function(response) {
 			            	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
 			            	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
 			            	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
 			            	    	        				//console.log("Manual trigger hit");
 			            	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
 			            	    	        			}else if(response.responseText==="SUCCESS" || response.responseText==="Success"){  
 			            	    	        				//console.log("Manual trigger hit");
 			                	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
 			            	    	        			}
 			            	    	        		}
 			            	    	        	});
 			         		        		}
 			         	            	} else { 
 			         	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
 			         	            	}  
 			         	            }
			         	},
	        	  });
			    },
        		   
	      	// ********* Hide  all more Action button *************
			    calculateResultPivilegesAction: function(gridReference,permissionsMap) {
			    	var associatedAcadLocationIds = new Array();
			    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
			    	
			    	var calculateResultBtn = gridReference.down('#btnCalculateMarksheet');
			    	calculateResultBtn.setVisible(false);
			    	var btnDelete = gridReference.down('#btnDelete');
			    	btnDelete.setVisible(false);
			    	Ext.each(permissionList, function(privilege) {
			    		if (privilege === 'GRADESUBMISSION') {
			    			if(!isNullOrEmpty(calculateResultBtn)){
			    				calculateResultBtn.setVisible(true);
			    			}        		
			    		}
			    		if(privilege ==='DELETE'){
			    			if(!isNullOrEmpty(btnDelete)){
			    				btnDelete.setVisible(true);
			    			}
			    		}
			    	});
			    },
			    
			    // ********* Hide  all Apply Changes button *************
			    applyChangesPivilegesAction: function(gridReference,permissionsMap) {
			    	var associatedAcadLocationIds = new Array();
			    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

			    	var applyChnagesBtn = gridReference.down('#applyChangesId');
			    	applyChnagesBtn.setVisible(false);

			    	Ext.each(permissionList, function(privilege) {
			    		if (privilege === 'APPLYCHANGES') {
			    			if(!isNullOrEmpty(applyChnagesBtn)){
			    				applyChnagesBtn.setVisible(true);
			    			}        		
			    		}
			    	});
			    },
			    
			    // ********* Hide  Radio Button  *************
			    disableCriteriaBasedGrade: function(gridReference,permissionsMap) {
					var associatedAcadLocationIds = new Array();
					associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
					var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
					var flag,flag1=false;
					var form = this.getManagespecialgradefilter().getForm();
					var filter= this.getManagespecialgradefilter();
					var radioButton = form.findField('radiogroupId');
					var criteriaBasedGradeFieldId=filter.down('#criteriaBasedGradeFieldId');
					//radioButton.setVisible(false);
					criteriaBasedGradeFieldId.setVisible(false);
					Ext.each(permissionList, function(privilege) {
						if(privilege === 'CRITERIA_BASED_GRADE'){
							//radioButton.setVisible(false);
							criteriaBasedGradeFieldId.setVisible(false);
							radioButton.items.items[0].setValue(false);
							radioButton.items.items[1].setValue(true);
							flag1=true;
						}
						if(privilege === 'SPECIALGRADE'){
							//radioButton.setVisible(false);
							criteriaBasedGradeFieldId.setVisible(false);
							radioButton.items.items[1].setValue(false);
							radioButton.items.items[0].setValue(true);
							flag=true;
						}
						if(flag && flag1){
							//radioButton.setVisible(true);
							criteriaBasedGradeFieldId.setVisible(true);
							radioButton.items.items[1].setValue(false);
							radioButton.items.items[0].setValue(true);
							//radioButton.items.items[1].setValue(false);
							//radioButton.items.items[0].setValue(true);
						}
					});
				},
				
			    calculateResultSpecialGrade:function() {
             	   var $this = this;
             	   
             		   var grid = $this.getMangespecialgradegrid();
        			   var record = grid.getSelectionModel().getSelection();
        			   if(record.length > 0) {
        				   showConfirmMessage(getExaminationTranslation('SPECIAL_GRADE'),
                     			   getExaminationTranslation('IS_PUBLISH_SPECIAL_GRADE'),function(btn, text) {
        				   if (btn == 'yes') {
        					   /*var form = $this.getGeneratehallticketfilter().getForm();
             			   var formValues = form.getValues();*/
        					   var formPanel=$this.getManagespecialgradefilter();
        					   var specialGradeType = formPanel.down('#specialGradeId').getValue();
        					   var jsonArr=[];
        					   var specialGradeArr =[];
        					   for(var i in record) {
        						   
        						   if(record[i].data.specialGrade== "" || record[i].data.specialGrade== null ){
        							   specialGradeArr.push(record[i].data.specialGrade);  
        						   }
        						   jsonArr.push({
        							   "admissionId":record[i].data.admissionId,
        							   "courseVariantId":record[i].data.courseVariantId,
        							   "sectionId":record[i].data.sectionId,
        							   "periodId":record[i].data.periodId,  
        							   "periodName":record[i].data.periodName,
        							   "specialGrade":record[i].data.specialGradeCode!=null ? record[i].data.specialGradeCode:record[i].data.specialGrade,
									   "gradePoint":record[i].data.specialGradePoint,
									   "resultStatus":record[i].data.resultStatus,
									   "sgpaCgpaCalculationRule":record[i].data.sgpaCgpaCalculationRule,
									   "specialGradeType":specialGradeType
        						   });
        					   }
        					   if(specialGradeArr.length > 0 ) {
        						   showWarningMessage(getExaminationTranslation('SPECIAL_GRADE'),getExaminationTranslation('PLEASE_ENTER_A_SPECIAL_GRADE_FOR_ALL_THE_SELECTED_RECORDS'));
        					   }
        					   
        					   else{
        						   var submitUrl = SERVERURL.PATH_UPDATE_SPECIAL_GRADE;
            					   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            					   Ext.Ajax.request({
            						   type : 'rest',
            						   url : submitUrl,
            						   jsonData : jsonArr,
            						   method : 'POST',
            						   success : function(resp, action) {
            							   Ext.getBody().unmask();
            							   showSuccessMessage(getExaminationTranslation('SPECIAL_GRADE'), getExaminationTranslation('SPECIAL_GRADE_PUBLISH_SUCCESS_MSG'));
            							   grid.store.reload();
            						   }
            					   });
        					   }
        				   }
        				  });
        			   }
        			   else {
        				   showWarningMessage(getExaminationTranslation('SPECIAL_GRADE'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
        			   }
             	   
                },
                
                loadEvaluationPlan:function(){
                	var $this = this;
                	var form = $this.getManagespecialgradefilter().getForm();
                    var alinfomodel = Academia.model.authentication.ALInfoModel;
                	var wheatherSchool = alinfomodel.get('wheatherSchool');
                	var evaluationplan = form.findField('evaluationplan');
                	var course = form.findField('criteriaBasedCourseId');
                	var program = form.findField('criteriaBasedProgramId');
                	var batch = form.findField('criteriaBasedBatchId');
                	var period = form.findField('criteriaBasedPeriodId');
                	var courseVariant = form.findField('criteriaBasedCourseVariant');
                	var als = [];
                	als.push($this.getCurrentAcademyLocation());
                	evaluationplan.reset();
                	evaluationplan.getStore().getProxy().extraParams={
                		// evaluationPlanType:'ACADEMICS',
                		//evaluationStage:'COURSE_EXECUTION',
                		//  academyLocationId:$this.getCurrentAcademyLocation(),
                		courseId:course.getValue(),
                		// whetherDynamicPlan:true
                	};
                	evaluationplan.getStore().load();
                	courseVariant.reset();
                	courseVariant.getStore().getProxy().extraParams={
                		// evaluationPlanType:'ACADEMICS',
                		//evaluationStage:'COURSE_EXECUTION',
                		//  academyLocationId:$this.getCurrentAcademyLocation(),
                		courseId:course.getValue(),
                		wheatherSchool:wheatherSchool
                		// whetherDynamicPlan:true
                	};
                	courseVariant.getStore().load();
                	program.reset();
                	program.getStore().getProxy().extraParams={
                		courseId:course.getValue(),
                		wheatherSchool:wheatherSchool
                	};
                	program.getStore().load();
                	batch.reset();
                	batch.setDisabled(true);
                	period.reset();
                	period.setDisabled(true);
                	var admissionId = form.findField("admissionId");
                	admissionId.reset();
                	var studentListStore=admissionId.getStore();
                	studentListStore.getProxy().extraParams={
                		academyLocationIds:als.join(),
                		courseId:course.getValue()
                	};
                	studentListStore.load();
                },
                
                calculateApplyChanges:function(button) {
                	var $this = this;
                	var grid = $this.getCriteriabasedgradegrid();
                	var record = grid.getSelectionModel().getSelection();
                	var window = $this.getCriteriabasedgradeapplywin();
					var savebtn=window.down('#submitBtnWin');
	                savebtn.setDisabled(true);// V2D-454661 
                	var form = $this.getManagespecialgradefilter().getForm();
                	var course = form.findField('criteriaBasedCourseId');
                	var droolItems=null;
                	var markAttendance=window.down('#markAttendance').getValue();
                	if(window.down('#droolsItemId').valueModels[0]!=undefined){
                		droolItems=window.down('#droolsItemId').valueModels[0].data.code;
                	}
                	var formValues=form.getValues();
                	
                   var courseVariantArray=[];
 				   if(!isNullOrEmpty(formValues.criteriaBasedCourseVariant)){
 					   for(var i=0;i<formValues.criteriaBasedCourseVariant.length;i++){
 						   var cvValue=formValues.criteriaBasedCourseVariant[i];
 						   if(Ext.isObject(cvValue)){
 							  courseVariantArray.push(cvValue.data.id);
 						   }
 					   }
 				   }
                	
                	
                	if(droolItems=="REVISED_GRADE_CALCULATION") {
                		if(record.length > 0){
                			if (markAttendance=="true"){
                    			var jsonArr=[];
                    			for(var i in record) {
                    				jsonArr.push({
                    					"id":record[i].data.id,
                    					"admissionId":record[i].data.admissionId,
                    					"courseVariantId":record[i].data.courseVariantId,
                    					"sectionId":record[i].data.sectionId,
                    					"periodId":record[i].data.periodId,
                    					"remark":window.down('#RemarkId').getValue(),
                    					"revisedGrade":record[i].data.revisedGradeCode!=null ? record[i].data.revisedGradeCode:record[i].data.revisedGrade,
                    							"revisedGradePoint":record[i].data.revisedGradePoint,
                    							"attendancePercentage":record[i].data.attendancePercentage,
                    							"ruleApplicable" : droolItems,
                    							"gradeType":course.valueModels[0].data.code
                    				});
                    			}
                    			var submitUrl = SERVERURL.PATH_UPDATE_REVISED_GRADE;
                    			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                    			Ext.Ajax.request({
                    				type : 'rest',
                    				url : submitUrl,
                    				jsonData : jsonArr,
                    				method : 'POST',
                    				success : function(resp, action) {
                    					Ext.getBody().unmask();
                    					button.up('window').close();
                    					showSuccessMessage(getExaminationTranslation('CRITERIA_BASED_GRADE'), getExaminationTranslation('SPECIAL_GRADE_PUBLISH_SUCCESS_MSG'));
                    					grid.store.reload();
                    				}
                    			});  
                    		} else{
                    			 showWarningMessage(getExaminationTranslation('REVISED_GRADE'),getExaminationTranslation('ATTENDANCE_NOT_MARKED'));
                    		}
                		} else {
                    		showWarningMessage(getExaminationTranslation('CRITERIA_BASED_GRADE'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
                    	}
                	}
                	
                	 // Automatic Revised Grading without Percentage Calculation
                	
                	else if(droolItems=="Z_SCORE_CALCULATION_50" || 
                			droolItems=="Z_SCORE_CALCULATION_20_40" || droolItems=="Z_SCORE_CALCULATION_20_30_50" ||
                			droolItems=="Z_SCORE_CALCULATION_20_50"  || droolItems=="Z_SCORE_CALCULATION_16_40"){   
                		
                		
                		if(record.length >= 30){
                			showConfirmMessage(getExaminationTranslation('REVISED_GRADE'), getExaminationTranslation('Z_SCORE_CONFIRMATION'), function(btn, text) {
                				if (btn == 'yes') {

                					var jsonArr=[];
                					for(var i in record) {
                						jsonArr.push({
                							"id":record[i].data.id,
                							"admissionId":record[i].data.admissionId,
                							"courseVariantId":record[i].data.courseVariantId,
                							"courseId":formValues.criteriaBasedCourseId,
                							"evaluationPlanId":formValues.evaluationplan,
                							"sectionId":record[i].data.sectionId,
                							"periodId":record[i].data.periodId,
                							"effectiveMarks":record[i].data.finalMarks,
                							"remark":window.down('#RemarkId').getValue(),
                							"revisedGrade":record[i].data.revisedGradeCode!=null ? record[i].data.revisedGradeCode:record[i].data.revisedGrade,
                									"revisedGradePoint":record[i].data.revisedGradePoint,
                									"attendancePercentage":record[i].data.attendancePercentage,
                									"ruleApplicable" : droolItems,
                									"gradeType":course.valueModels[0].data.code,
                									"roundingMode":record[i].data.roundingMode,
                									"roundingCount":record[i].data.roundingCount,
                									"courseVariantIds":courseVariantArray.join()
                						});
                					}
                					var submitUrl = SERVERURL.PATH_UPDATE_ZSCORE_REVISED_GRADE;
                					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                					Ext.Ajax.request({
                						type : 'rest',
                						url : submitUrl,
                						jsonData : jsonArr,
                						method : 'POST',
                						success : function(resp, action) {
                							Ext.getBody().unmask();
                							button.up('window').close();
                							if(resp.responseText=="SUCCESS"){
                								showSuccessMessage(getExaminationTranslation('CRITERIA_BASED_GRADE'), getExaminationTranslation('SPECIAL_GRADE_PUBLISH_SUCCESS_MSG'));
                							}
                							if(resp.responseText=="DEPENDENCY_EXISTS"){
                								showWarningMessage(getCommonTranslation('ERROR'),getCommonTranslation('DEPENDENCY_EXISTS'));
                							}
                							if(resp.responseText=="NOT_CONFIGURED"){
                								showWarningMessage(getCommonTranslation('ERROR'),getExaminationTranslation('Z_SCORE_NOT_CONFIGURED'));
                							}
                							grid.store.load();
                						}
                					});  

                				}
                			});

                		}else{
                			showWarningMessage(getExaminationTranslation('REVISED_GRADE'),getExaminationTranslation('TO_APPLY_THE_RULE_THE_MINIMUM_NUMBER_OF_STUDENTS'));
                		}
                		
                	}else{    // Manual Revised Grading
                		if(record.length > 0){
                			var jsonArr=[];
                			for(var i in record) {
                				jsonArr.push({
                					"id":record[i].data.id,
                					"admissionId":record[i].data.admissionId,
                					"courseVariantId":record[i].data.courseVariantId,
                					"sectionId":record[i].data.sectionId,
                					"periodId":record[i].data.periodId,
                					"remark":window.down('#RemarkId').getValue(),
                					"revisedGrade":record[i].data.revisedGradeCode!=null ? record[i].data.revisedGradeCode:record[i].data.revisedGrade,
                							"revisedGradePoint":record[i].data.revisedGradePoint,
                							"attendancePercentage":record[i].data.attendancePercentage,
                							"ruleApplicable" : droolItems,
                							"gradeType":course.valueModels[0].data.code
                				});
                			}
                			var submitUrl = SERVERURL.PATH_UPDATE_REVISED_GRADE;
                			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                			Ext.Ajax.request({
                				type : 'rest',
                				url : submitUrl,
                				jsonData : jsonArr,
                				method : 'POST',
                				success : function(resp, action) {
                					Ext.getBody().unmask();
                					button.up('window').close();
                					showSuccessMessage(getExaminationTranslation('CRITERIA_BASED_GRADE'), getExaminationTranslation('SPECIAL_GRADE_PUBLISH_SUCCESS_MSG'));
                					grid.store.reload();
                				}
                			});  
                		} else {
                    		showWarningMessage(getExaminationTranslation('CRITERIA_BASED_GRADE'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
                    	}
                	}
                },
                disableImportTab :function(structure){
                	
                	
                	var associatedAcadLocationIds = new Array();
	  				associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	  				var importUtilityPermissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getMANAGE_SPECIAL_GRADE_PERMISSION());
	  				
	  				var importSpecialGradeTab = false;
//	  				enquiryUploadDownloadStructure.hide(false);
	  				
	  				Ext.each(importUtilityPermissionList, function(privilege) {
	  					if (privilege === 'IMPORT_BULK_SPECIAL_GRADE') {
	  						importSpecialGradeTab = true;
	  					}
	  				});

	  				var panelItem = new Array();
	  				var $this = this;
	  				var newcont = structure.items.items.length;
	  				var insertPosition=newcont+1;
	  				if(!Ext.ComponentQuery.query("specialgradesearchtabform")[0]){
	  					
	  					var panelItem = new Array();
	  		 			var $this = this;
	  		 			var newcont = structure.items.items.length;
	  		 			var insertPosition = newcont;
	  		 			panelItem.push({
	  		 				xtype : 'tabpanel',
	  		 				itemId : 'allVisibleTP',
	  		 				plain : true,
	  		 				frame : false,
	  		 				border : false,
	  		 				defaults : {
	  		 					labelAlign : 'top'
	  		 				},
	  		 				items : [{
	  		 					xtype: 'specialgradesearchtabform',
	  		 					//autoScroll:true,
	  		 				    title: getCommonTranslation('SEARCH'),
	  		 				    tabCls: 'right-tab',
	  		 				}],
	  		 				listeners: {
	  		 					tabchange: function(){
	  		 						var structure = $this.getManagespecialgradesearch();
	  		 						structure.scrollBy(0,1);
	  		 						structure.scrollBy(0,-1);
	  		 					}
	  		 				}
	  		 			});
	  					
	  					var insertAt = panelItem["0"].items.length;
	  		 			
	  					if (importSpecialGradeTab) {
	  		 				panelItem["0"].items[insertAt] = {
  		 						xtype: 'importspecialgrade',
  		 						title: getExaminationTranslation('IMPORT_SPECIAL_GRADE'),
  		 						tabCls: 'right-tab'
	  		 				};
	  		 				insertAt = insertAt + 1;
	  		 			}
	  					
	  					structure.insert(insertPosition,panelItem);
	  				}
	  			
                },
                importDownloadUploadFormChange :function(cb, nv, ov){
  	        	  var $this = this;
	        	  var downloadTemplateForm = this.getDownloadspecialgradefilter();
	        	  var uploadTemplateForm = this.getUploadspecialgradefilter();
	        	  var grid =this.getImportutilityspecialgrade();
	        	  if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
	        		   uploadTemplateForm.hide();
	        		  downloadTemplateForm.show();
	        		  grid.setVisible(false);
	        		  grid.getView().refresh();
	        		  uploadTemplateForm.down("#uploadFileField").setDisabled(true);
	        		  downloadTemplateForm.up('importspecialgrade').isValid();

	        	  }else{
	        		  downloadTemplateForm.hide();
	        		  uploadTemplateForm.show();
	        		  grid.setVisible(true);
	        		  grid.getView().refresh();
	        		  uploadTemplateForm.down("#moduleName").reset();
	        		  uploadTemplateForm.down("#uploadFileField").reset();
	        		  uploadTemplateForm.down("#uploadFileField").setDisabled(false);
	        		  var combo = uploadTemplateForm.down("#moduleName");
	        		  combo.getStore().load({
	        			  callback: function(records, operation, success) {
	        				  for(var i in records){
	        					  if(records[i].data.value == "Import Special Grade"){
	        						  combo.setValue(records[i].data.id);
	        						  combo.setReadOnly(true);
	        					  }
	        				  }
	        			  }
	        		  });
	        	  }
	        	  
	          },

				getCourseCreationDownloadFile : function(documentId,fileType){
  	                  	   if(!isNullOrEmpty(documentId)){
  	                  		   var csvForm = Ext.create('Ext.form.Panel'); 
  	                  		   csvForm.getForm().submit({
  	                  			   target: '_blank',
  	                  			   method:'POST',
  	                  			   params :{
  	                  				   access_token : Ext.Ajax.defaultHeaders.access_token
  	                  			   },
  	                  			   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
  	                  			   url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId + '&fileType='+ fileType,
  	                  			   standardSubmit :true
  	                  		   });
  	                  	   }
  	                     },
});
