/**
 * @author Chouhan Abhishek
 * 
 */
Ext.define('Academia.controller.examinationcenters.marksheet.AssessmentGroupMarksheetController', {
    extend: 'Academia.controller.base.BaseController',
    stores: ['examinationcenters.manageEvaluation.evaluationgroup.AssessmentGroupMarksheetStore',
        'examinationcenters.manageEvaluation.evaluationgroup.EGMarksheetProgramStore',
        'examinationcenters.marksheet.StudentMarksheetStore',
        'examinationcenters.manageEvaluation.evaluationgroup.EGMarksheetBatchStore',
        'examinationcenters.marksheet.AssessmentGroupMarksheetGridStore',
        'examinationcenters.marksheet.AssesssmentGroupMarksheetTemplateStore'
    ],
    views: ['examinationcenters.assessmentGroupMarksheet.AssessmentGroupMarksheetStructure',
        'examinationcenters.assessmentGroupMarksheet.AssessmentGroupMarksheetFilter',
        'examinationcenters.assessmentGroupMarksheet.AssessmentGroupMarksheetGrid',
         'setup.templatemapping.PreviewTemplate',
        'examinationcenters.assessmentGroupMarksheet.AGMarksheetGenerationWin',
        'examinationcenters.assessmentGroupMarksheet.EGPublishMarksheetWin'
    ],
    config: {
        ASSESSMENT_GROUP_MARKSHEET_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ASSESSMENT_GROUP_MARKSHEET_PRIVILEGES'),
    },
    refs: [{
        ref: 'contentPanel',
        selector: 'contentPanel'
    }, {
        ref: 'assessmentgroupmarksheetfilter',
        selector: 'assessmentgroupmarksheetfilter'
    }, {
        ref: 'assessmentgroupmarksheetstructure',
        selector: 'assessmentgroupmarksheetstructure'
    }, {
        ref: 'assessmentgroupmarksheetgrid',
        selector: 'assessmentgroupmarksheetgrid'
    }, {
        ref: 'agmarksheetgenerationwin',
        selector: 'agmarksheetgenerationwin'
    }, {
        ref: 'previewtemplate',
        selector: 'previewtemplate'
    }, {
        ref: 'egpublishmarksheetwin',
        selector: 'egpublishmarksheetwin'
    }],
    init: function() {
        this.control({
            'assessmentgroupmarksheetfilter': {
                render: function(obj) {
                    var $this = this;
                    var filterForm = obj.up('form').getForm();
                    var evaluationGroupId = filterForm.findField("evaluationGroupId");
                    evaluationGroupId.getStore().getProxy().extraParams = {
                        academyLocationId: $this.getCurrentAcademyLocation(),
                        isAssessmentGroupMarksheet: true
                    };
                    evaluationGroupId.getStore().load()
                }
            },
            'assessmentgroupmarksheetfilter customcombobox[itemId=evaluationGroupItemId]': {
                select: function(obj, record) {
                    var $this = this;
                    var data = record[0].data.id;
                    var form = $this.getAssessmentgroupmarksheetfilter().getForm();
                    var program = form.findField("program");
                    var batch = form.findField("batch");
                    batch.reset();
                    batch.disable();
                    program.enable();
                    program.reset();
                    program.getStore().getProxy().extraParams = {
                        academyLocationId: $this.getCurrentAcademyLocation(),
                        evaluationGroupId: data
                    };
                    program.getStore().load({
                    	callback: function(record, operation, success) {
                    		if (record.length == 1) {
                    			program.setDisabled(false);
                    			program.setValue(record[0].data.id);
                    			batch.reset();
                    			batch.setDisabled(false);
                    			batch.getStore().getProxy().extraParams={
                    				academyLocationId: $this.getCurrentAcademyLocation(),
                    				evaluationGroupId: data,
                    				programId: record[0].data.id
                    			};
                    			batch.getStore().load({
                    				callback: function(record, operation, success) {
                    					if (record.length == 1) {
                    						batch.setValue(record[0].data.id);
                    					}
                    				}
                    			});
                    		} else
                    		{
                    			batch.setDisabled(true).reset();
                    		}
                    	}	   
                    })

                }
            },
            'assessmentgroupmarksheetfilter customcombobox[itemId=programItemId]': {
                select: function(obj, record) {
                    var $this = this;
                    var data = record[0].data.id;
                    var form = $this.getAssessmentgroupmarksheetfilter().getForm();
                    var batchField = form.findField("batch");
                    var evaluationGroupId = form.findField("evaluationGroupId").getValue();
                    batchField.enable();
                    batchField.reset();
                    batchField.getStore().getProxy().extraParams = {
                        academyLocationId: $this.getCurrentAcademyLocation(),
                        evaluationGroupId: evaluationGroupId,
                        programId: data
                    };
                    batchField.getStore().load({
        				callback: function(record, operation, success) {
        					if (record.length == 1) {
        						batchField.setValue(record[0].data.id);
        					}
        				}
        			})

                }
            },
            'assessmentgroupmarksheetfilter button[itemId=resetBtn]': {
                click: function(obj) {
                    var $this = this;
                    var filterForm = obj.up('form');
                    var getForm = filterForm.getForm();
                    getForm.reset();
                    var evaluationGroupField = getForm.findField("evaluationGroupId");
                    var programField = getForm.findField('program');
                    var batchField = getForm.findField("batch");
                    programField.setDisabled(true);
                    batchField.setDisabled(true);

                    evaluationGroupField.getStore().getProxy().extraParams = {
                        academyLocationId: $this.getCurrentAcademyLocation(),
                        isAssessmentGroupMarksheet: true
                    };
                    evaluationGroupField.getStore().load()
                }
            },

            'assessmentgroupmarksheetfilter button[itemId=searchBtn]': {
                click: function(obj) {
                    var $this = this;
                    var filterForm = obj.up('form');
                    var assessmentgroupmarksheetgrid = this.getAssessmentgroupmarksheetgrid();
                    var formValues = filterForm.getForm().getValues();
                    var sectionArray = [];
                    var records;

                    assessmentgroupmarksheetgrid.getStore().getProxy().extraParams = {
                        evaluationGroupId: formValues.evaluationGroupId,
                        programId: formValues.program,
                        batchId: formValues.batch,
                        isConsiderProgramTransfer: formValues.isConsiderProgramTransfer
                    };
                    var gridColumns = assessmentgroupmarksheetgrid.columns;
                    var len = gridColumns.length;
                    assessmentgroupmarksheetgrid.getStore().load({
                        callback: function(record) {
                            assessmentgroupmarksheetgrid.getSelectionModel().deselectAll();
                            for (var i = 0; i < record.length; i++) {
                                var rec = record[i];
                                if (!isNullOrEmpty(rec.data.marksheetPath)) {
                                    assessmentgroupmarksheetgrid.getSelectionModel().select(rec, true);
                                }
                            }
                            $this.enableDisablePublishBtn(assessmentgroupmarksheetgrid, record);
                            $this.enableDisableDownloadAllBtn(assessmentgroupmarksheetgrid, record);
                        }
                    });
                    if (!isNullOrEmpty(formValues.marksheetJobId)) {
                        var buttonsToolBar = assessmentgroupmarksheetgrid.query('toolbar')[0];
                        var button = buttonsToolBar.query('#btnGenerateMarksheet')[0];
                        button.enable();
                    }
                    filterForm.focus();
                    assessmentgroupmarksheetgrid.config.searchFilterForm = filterForm;
                }
            },

            'agmarksheetgenerationwin button[itemId=generateBtnWin]': {
                click: function(obj) {
                    var $this = this;
                    var assessmentGroupMarksheetGrid = this.getAssessmentgroupmarksheetgrid();
                    var form = $this.getAgmarksheetgenerationwin();
                    if (assessmentGroupMarksheetGrid.getSelectionModel().getCount() > 0) {
                        var records = assessmentGroupMarksheetGrid.getSelectionModel().getSelection();
                        $this.saveGenerateMarksheet(form);
                    }
                }
            },
            'egpublishmarksheetwin button[itemId=publishMarksheetBtn]': {
                click: function(obj) {
                    this.saveAssessmentGroupPublshMarksheet();
                }
            },
            
            'egpublishmarksheetwin  button[itemId=publishMarksheetCancelBtn]': {
                click: function() {
                    this.getEgpublishmarksheetwin().close();
                }
            },
            
            'assessmentgroupmarksheetgrid menuitem[itemId=btnEGPublishMarksheet]': {
            	click: function(obj) {
            		var $this=this;
            		var grid = this.getAssessmentgroupmarksheetgrid();
            		if (grid.getSelectionModel().getCount() > 0) {
            			$this.openPublishMarksheetWindow();
            			var publishForm = $this.getEgpublishmarksheetwin();
            		    var publishDate=publishForm.down('#publishDateItemId');
            			var records = grid.getSelectionModel().getSelection();
            			if(isNullOrEmpty(records[0].data.publishDate)){
            				publishDate.setValue(new Date());
            				//publishDate.allowBlank=true;
            				
            			} else{
            				publishDate.setValue(dateRender(records[0].data.publishDate));
            				//publishDate.allowBlank=true;
            			}
            		} else {
            			showWarningMessage(getExaminationTranslation('ASSESSMENT_GROUP_GENERATE_MARKSHEET'), getCommonTranslation('PLEASE_SELECT_RECORD'));
            		}
            	}
            },
            
            'assessmentgroupmarksheetgrid menuitem[itemId=btnEGDownloadAllMarksheet]': {
                click: function(obj) {
                    this.downloadAGAllMarksheetZip();
                }
            },
            'assessmentgroupmarksheetgrid menuitem[itemId=btnEGUncheckedAll]': {
                click: function(obj) {
                    var $this = this;
                    $this.uncheckedAllAGrecords();
                }
            },


            'previewtemplate  button[itemId=cancelBtn]': {
                click: function() {
                    this.getPreviewtemplate().close();
                }
            },
            'agmarksheetgenerationwin': {
            	render: function() {
            		var form = this.getAgmarksheetgenerationwin();
            		var records = this.getAssessmentgroupmarksheetgrid().getSelectionModel().getSelection();
            		var id=records[0].data.evaluationGroupMarksheetId;
            		this.disableGenerateButtonPivileges(form, this.getASSESSMENT_GROUP_MARKSHEET_PERMISSION());
            		var marksheetTemplate = form.down('#AGMarksheetTemplate');
            		var publishDate = form.down('#publishDateItemId');
            		var data =null;

            		var academyLocationId = this.getCurrentAcademyLocation();
            		marksheetTemplate.getStore().getProxy().extraParams = {
            			levelName: "EVALUATION_EVENT"
            		};
            		marksheetTemplate.getStore().load();
            	}
            },
            'agmarksheetgenerationwin  button[itemId=cancelBtn]': {
                click: function() {
                    this.getAgmarksheetgenerationwin().close();
                }
            },
            'agmarksheetgenerationwin button[itemId=assessmentGroupPreviewTemplateBtn]': {
                click: function() {
                    var $this = this;
                    var filterForm = this.getAgmarksheetgenerationwin();
                    var templateField = filterForm.down('#AGMarksheetTemplate');
                    if (!isNullOrEmpty(templateField.getValue())) {
                        var formWindow = $this.getPreviewtemplate();
                        if (!formWindow) {
                            Ext.widget('previewtemplate');
                            formWindow = $this.getPreviewtemplate();
                        }
                        formWindow.show();

                        var previewForm = $this.getPreviewtemplate();

                        var templateId = templateField.getValue();
                        var id = null;
                        var url = SERVERURL.TEMPLATE_FIND_BY_ID;
                        Ext.Ajax.request({
                            type: 'rest',
                            url: url,
                            params: {
                                id: templateId
                            },
                            method: 'GET',
                            success: function(response) {
                                var data = Ext.decode(response.responseText);
                                id = data.reportTemplate.id;

                                if (!isNullOrEmpty(data.reportTemplate)) {
                                    var url = SERVERURL.TEMPLATE_PREVIEW;
                                    Ext.Ajax.request({
                                        type: 'rest',
                                        binary: true,
                                        url: url + '?id=' + data.reportTemplate.id,
                                        method: 'GET',
                                        success: function(response) {
                                            if (response.responseBytes.length > 0) {
                                                var blob = new Blob([response.responseBytes], {
                                                    type: 'image/jpg'
                                                });
                                                if (!isNullOrEmpty(blob) && blob != undefined) {
                                                    var url = window.URL.createObjectURL(blob);
                                                    var a = previewForm.down("#profile_image");
                                                    a.getEl().dom.src = url;
                                                }
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                }
            },

            'assessmentgroupmarksheetgrid ': {
                select: function(obj, record, rowIndex, e) {
                    var assessmentGroupMarksheetGrid = this.getAssessmentgroupmarksheetgrid();

                    /**
                     * this condition is for student's can't selected with students whose marksheet already created.   
                     */
                    if (obj.selected.items.length > 1) {
                        var newLength = obj.selected.items.length - 2;
                        if ((!obj.selected.items[newLength].data.marksheetPath && record.data.marksheetPath) ||
                            (!record.data.marksheetPath && obj.selected.items[newLength].data.marksheetPath)) {
                            obj.deselect(record);
                            showWarningMessage(getCommonTranslation('ALERT'), getExaminationTranslation('STUDENT_MARKSHEET_WITHOUT_MARKSHEET_CANNOT_BE_SELECTED_TOGETHER'));
                        }
                    }

                    if (assessmentGroupMarksheetGrid.getSelectionModel().getCount() > 0) {
                        var records = assessmentGroupMarksheetGrid.getSelectionModel().getSelection();
                        this.enableDisablePublishBtn(assessmentGroupMarksheetGrid, records);
                        this.enableDisableDownloadAllBtn(assessmentGroupMarksheetGrid, records);
                        this.enableGenerateMarksheetBtn(assessmentGroupMarksheetGrid, records);
                    } else {
                        var buttonsToolBar = assessmentGroupMarksheetGrid.query('toolbar')[0];
                        var publishButton = buttonsToolBar.query('#btnEGPublishMarksheet')[0];
                        publishButton.disable();
                        var downloadAllButton = buttonsToolBar.query('#btnEGDownloadAllMarksheet')[0];
                        downloadAllButton.disable();
                    }
                },
                deselect: function(obj, record, rowIndex, e) {
                    var assessmentGroupMarksheetGrid = this.getAssessmentgroupmarksheetgrid();
                    if (assessmentGroupMarksheetGrid.getSelectionModel().getCount() > 0) {
                        var records = assessmentGroupMarksheetGrid.getSelectionModel().getSelection();
                        this.enableDisablePublishBtn(assessmentGroupMarksheetGrid, records);
                        this.enableDisableDownloadAllBtn(assessmentGroupMarksheetGrid, records);
                        this.disableGenerateMarksheetBtn(assessmentGroupMarksheetGrid, records);
                    } else {
                        var buttonsToolBar = assessmentGroupMarksheetGrid.query('toolbar')[0];
                        var publishButton = buttonsToolBar.query('#btnEGPublishMarksheet')[0];
                        publishButton.disable();
                        var downloadAllButton = buttonsToolBar.query('#btnEGDownloadAllMarksheet')[0];
                        downloadAllButton.disable();
                        var generateMarksheetButton = buttonsToolBar.query('#btnEGGenerateMarksheet')[0];
                        generateMarksheetButton.disable();
                    }
                }
            },

            'assessmentgroupmarksheetgrid': {
                render: function(grid) {
					grid.getStore().removeAll();
                    this.doAccessControlValidation(grid, this.getASSESSMENT_GROUP_MARKSHEET_PERMISSION());
                    this.disableMoreActionPivileges(grid, this.getASSESSMENT_GROUP_MARKSHEET_PERMISSION());
                },
                cellclick: function(view, td, colIndex, record, event, target, pop) {
                    if (pop.target.tagName == 'A') {
                        var submitUrl = SERVERURL.MARKSHEET_DOWNLOAD_URL;
                        var csvForm = Ext.create('Ext.form.Panel');
                        var filePath = window.btoa(unescape(encodeURIComponent(record.data.marksheetPath)));
                        csvForm.getForm().submit({
                            url: submitUrl + "?filePath=" + filePath,
                            method: 'POST',
                            target: '_blank',
                            params: {
                                access_token: Ext.Ajax.defaultHeaders.access_token
                            },
                            headers: {
                                'Authorization': Ext.Ajax.defaultHeaders.Authorization
                            },
                            standardSubmit: true
                        });
                    }
                },

            },

            'assessmentgroupmarksheetgrid menuitem[itemId=btnEGGenerateMarksheet]': {
            	click: function(obj) {
            		var $this=this;
            		var grid = this.getAssessmentgroupmarksheetgrid();
            		 var jData=null;
            		Ext.Ajax.request({
                        type: 'rest',
                        async: false,
                        url: SERVERURL.FIND_ALL_MARKSHEET_TEMPLATE_URL,
                        params: {
                        	  levelName: "EVALUATION_EVENT"
                        },
                        method: 'GET',
                        success: function(resp, action) {
                        	 var respData = resp.responseText;
                             jData = Ext.JSON.decode(respData);
                        }
                    });
            		if (grid.getSelectionModel().getCount() > 0) {
            			if(jData.length==1){
            				$this.saveGenerateMarksheet(form,jData);
            			} else if(jData.length==0){
            				showWarningMessage(getCommonTranslation('ALERT'), getExaminationTranslation('MARKSHEET_TEMPLATE_NOT_MAPPED'));
            			} else{
            				var records = grid.getSelectionModel().getSelection();
            				this.openMarksheetGenetionWindow();
            				var form = this.getAgmarksheetgenerationwin();
            				var publishDate = form.down('#publishDateItemId');
            				var marksheetTemplate = form.down('#AGMarksheetTemplate');
            			}
            		} else {
            			showWarningMessage(getExaminationTranslation('ASSESSMENT_GROUP_GENERATE_MARKSHEET'), getCommonTranslation('PLEASE_SELECT_RECORD'));
            		}
            	}
            },
            
            'assessmentgroupmarksheetstructure' : {
				afterrender : function(structure){
					var form = structure.down('assessmentgroupmarksheetfilter');
					var grid = structure.down('assessmentgroupmarksheetgrid');
					this.getGridHeaderFreeze(grid,structure);
				}
			},
        });
    },
    /**
     * Enable disable check for publish button.
     */
    enableDisablePublishBtn: function(grid, records) {
        var assessmentGroupMarksheetGrid = this.getAssessmentgroupmarksheetgrid();
        if (assessmentGroupMarksheetGrid.getSelectionModel().getCount() > 0) {
            //assessmentGroupMarksheetGrid.getSelectionModel().deselectAll();
            var records = assessmentGroupMarksheetGrid.getSelectionModel().getSelection();
            var marksheetPublishFlag = false;
            for (var i in records) {
                if (!records[i].get('isPublishMarksheet')) {
                    if (isNullOrEmpty(records[i].get('marksheetPath'))) {
                        marksheetPublishFlag = false;
                        break;
                    } else {
                        marksheetPublishFlag = true;
                    }
                }
            }

            if (marksheetPublishFlag) {
                var buttonsToolBar = grid.query('toolbar')[0];
                var publishButton = buttonsToolBar.query('#btnEGPublishMarksheet')[0];
                publishButton.enable();
            } else {
                var buttonsToolBar = grid.query('toolbar')[0];
                var publishButton = buttonsToolBar.query('#btnEGPublishMarksheet')[0];
                publishButton.disable();
            }
        }
    },

    enableGenerateMarksheetBtn: function(grid, records) {
        var assessmentGroupMarksheetGrid = this.getAssessmentgroupmarksheetgrid();
        if (assessmentGroupMarksheetGrid.getSelectionModel().getCount() > 0) {
            //assessmentGroupMarksheetGrid.getSelectionModel().deselectAll();
            var records = assessmentGroupMarksheetGrid.getSelectionModel().getSelection();
            var buttonsToolBar = grid.query('toolbar')[0];
            var publishButton = buttonsToolBar.query('#btnEGGenerateMarksheet')[0];
            publishButton.enable();
        }
    },
    disableGenerateMarksheetBtn: function(grid, records) {
        var assessmentGroupMarksheetGrid = this.getAssessmentgroupmarksheetgrid();
        if (assessmentGroupMarksheetGrid.getSelectionModel().getCount() > 0) {
            //assessmentGroupMarksheetGrid.getSelectionModel().deselectAll();
            var buttonsToolBar = grid.query('toolbar')[0];
            var records = assessmentGroupMarksheetGrid.getSelectionModel().getSelection();
            var publishButton = buttonsToolBar.query('#btnEGGenerateMarksheet')[0];
            publishButton.disable();
        }
    },

    /**
     * Enable disable check for download all button.
     */
    enableDisableDownloadAllBtn: function(grid, records) {
        var assessmentGroupMarksheetGrid = this.getAssessmentgroupmarksheetgrid();
        if (assessmentGroupMarksheetGrid.getSelectionModel().getCount() > 0) {
            //assessmentGroupMarksheetGrid.getSelectionModel().deselectAll();
            var records = assessmentGroupMarksheetGrid.getSelectionModel().getSelection();
            var marksheetPublishFlag = false;
            for (var i in records) {
                if (!isNullOrEmpty(records[i].get('marksheetPath'))) {
                    var buttonsToolBar = grid.query('toolbar')[0];
                    var downloadButton = buttonsToolBar.query('#btnEGDownloadAllMarksheet')[0];
                    downloadButton.enable();
                }
            }
        }
    },



    /**
     * Unchecked All selected records button.
     */
    uncheckedAllAGrecords: function() {
        var assessmentGroupMarksheetGrid = this.getAssessmentgroupmarksheetgrid();
        if (assessmentGroupMarksheetGrid.getSelectionModel().getCount() > 0) {
            assessmentGroupMarksheetGrid.getSelectionModel().deselectAll();
        }
    },


    /**
     * Open window for marksheet generation.
     */
    openMarksheetGenerationWindow: function() {
        var $this = this;
        var formWindow = $this.getMarksheetgenerationwin();
        if (!formWindow) {
            Ext.widget('marksheetgenerationwin');
            formWindow = $this.getMarksheetgenerationwin();
        }
        formWindow.show();

        var winForm = $this.getMarksheetGenerationWinForm().getForm();
        var idField = winForm.findField('id').getValue();
        var academyLocationId = $this.getCurrentAcademyLocation();
        /**
         * At the time of create, status must be pending and load store for template on bases of id field is their or not.
         */
        var statusField = winForm.findField('jobStatus');
        if (isNullOrEmpty(idField)) {
            statusField.getStore().load({
                callback: function(rec) {
                    statusField.setValue(rec[0].data.id);
                }
            });

            var reportTemplateConfigurationIdField = winForm.findField('reportTemplateConfigurationId');
            reportTemplateConfigurationIdField.getStore().getProxy().extraParams = {
                academyLocationId: academyLocationId
            };
            reportTemplateConfigurationIdField.getStore().load();
        }
    },
 
    
    /**
     * Open window for marksheet generation.
     */
    openEvaluationTypeWindow: function() {
        var $this = this;
        var formWindow = $this.getEvaluationtypewin();
        if (!formWindow) {
            Ext.widget('evaluationtypewin');
            formWindow = $this.getEvaluationtypewin();
        }
        formWindow.show();
    },
   
    /**
     * Save publish marksheet status
     */
    saveAssessmentGroupPublshMarksheet: function() {
        var $this = this;
        var publishForm = this.getEgpublishmarksheetwin();
        var assessmentGroupMarksheetGrid = $this.getAssessmentgroupmarksheetgrid();
        var publishDate=publishForm.down('#publishDateItemId').getValue();
        if (assessmentGroupMarksheetGrid.getSelectionModel().getCount() > 0) {
            var records = assessmentGroupMarksheetGrid.getSelectionModel().getSelection();
            var saveModel = [];
            for (var i in records) {
                saveModel.push(records[i].get('evaluationGroupMarksheetDetailId'));
            }
            var jsonData = saveModel.join();
            showConfirmMessage(getExaminationTranslation('MARKSHEET'), getExaminationTranslation('IS_PUBLISH_MARKSHEET'), function(btn, text) {
                if (btn == 'yes') {
                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.EVALUATION_GROUP_PUBLISH_MARKSHEET,
                        params: {
                        	evaluationGroupMarksheetDetailIds: jsonData,
                        	publishDate:publishDate
                        },
                        method: 'GET',
                        success: function(resp, action) {
                        	publishForm.close();
                            showSuccessMessage(getExaminationTranslation('ISPUBLISHMARKSHEET'),getCommonTranslation('SUCCESS'));
                            assessmentGroupMarksheetGrid.getStore().reload();
                        }
                    });
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },

   
    /**
     * Delete marksheet generation data
     */

    /**
     * Save student marksheet grid
     */
    saveGenerateMarksheet: function(form,jData) {
        var $this = this;
        var assessmentGroupMarksheetGrid = $this.getAssessmentgroupmarksheetgrid();
        var filterForm = $this.getAssessmentgroupmarksheetfilter().getForm();
        var isConsiderProgramTransfer = filterForm.findField('isConsiderProgramTransfer').getValue();
        var publishDateFormValue = null;
        var reportTemplateConfigurationId=null;
        var publishDateField=null;
        
        if(!isNullOrEmpty(jData)){
        	  var reportTemplateConfigurationId = jData[0].id;
        }else{
        	  var reportTemplateConfigurationId = form.down('#AGMarksheetTemplate').getValue();
        }
        if(isNullOrEmpty(jData)){
        	publishDateField=form.down('#AGMarksheetTemplate').getValue();
        }
        if (assessmentGroupMarksheetGrid.getSelectionModel().getCount() > 0) {
            //assessmentGroupMarksheetGrid.getSelectionModel().deselectAll();
            var records = assessmentGroupMarksheetGrid.getSelectionModel().getSelection();
            var saveModel = new Array();
            var saveData;
            var evaluationGroupMarksheetModel;
            var evaluationGroupMarksheetId = null;
            var submitUrl;
            var evaluationGroupMarksheetModel = {
                'id': records[0].data.evaluationGroupMarksheetId,
                'evaluationGroupId': records[0].data.evaluationGroupId,
                "batchId": records[0].data.batchId,
                "templateId": reportTemplateConfigurationId,
                "isConsiderProgramTransfer": isConsiderProgramTransfer.isConsiderProgramTransfer,
            };

            if (!isNullOrEmpty(records[0].data.evaluationGroupMarksheetId)) {
                submitUrl = SERVERURL.EVALUATION_GROUP_MARKSHEET_UPDATE
            } else {
                submitUrl = SERVERURL.EVALUATION_GROUP_MARKSHEET_SAVE
            }

            Ext.Ajax.request({
                type: 'rest',
                url: submitUrl,
                jsonData: evaluationGroupMarksheetModel,
                timeout: 250000,
                method: 'POST',
                async: false,
                success: function(resp, action) {
                    evaluationGroupMarksheetId = resp.responseText;
                }
            });
            if (!isNullOrEmpty(records[0].data.evaluationGroupMarksheetId)) {
                evaluationGroupMarksheetId = records[0].data.evaluationGroupMarksheetId;
            }
            Ext.Array.each(records, function(value, index) {
            	if(!isNullOrEmpty(value.data.publishDate)){
            		publishDateField=value.data.publishDate;
            	}
            	
            	var data = {
                    "id": value.data.evaluationGroupMarksheetDetailId,
                    "evaluationGroupMarksheetId": evaluationGroupMarksheetId,
                    "evaluationGroupMarksheetDetailId": value.data.evaluationGroupMarksheetDetailId,
                    "admissionId": value.data.admissionId,
                    "marksheetPath": value.data.marksheetPath,
                    "isMarksheetPrint": value.data.isMarksheetPrint, 
                    "isPublishMarksheet": value.data.isPublishMarksheet,
                    "academyLocationId": value.data.academyLocationId,
                    "admissionCode": value.data.admissionCode,
                    "batchId": value.data.batchId,
                    "batchName": value.data.batchName,
                    "programName": value.data.programName,
                    "studentCode": value.data.studentCode,
                    "studentName": value.data.studentName,
                    "periodId": value.data.periodId,
                    "periodName": value.data.periodName,
                    "sectionCode": value.data.sectionCode,
                    "templateId": reportTemplateConfigurationId,
                    "personId": value.data.personId,
                    "isConsiderProgramTransfer": isConsiderProgramTransfer.isConsiderProgramTransfer,
                    'evaluationGroupId': value.data.evaluationGroupId,
                    'studentId': value.data.studentId,
                    "publishDate":publishDateField
                };

                saveModel.push(data);

                var publishDate = records[0].data.publishDate; //01-12-2016 convert to 2016-12-01
                var dateArr = [];

                saveData = {
                    'marksheetJobVariantLevelsForSaveModel': saveModel,
                    'assessmentGroupMarksheetModel':evaluationGroupMarksheetModel
                }
            });
            showConfirmMessage(getExaminationTranslation('MARKSHEET'), getExaminationTranslation('ANY_EXISTING_MARKSHEET_WILL_DELETED_REGENERATED'), function(btn, text) {
                if (btn == 'yes') {
                    Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.EVALUATION_GROUP_MARKSHEET_DETAILS_SAVE,
                        jsonData: saveData,
                        timeout: 250000,
                        method: 'POST',
                        success: function(resp, action) {
                            showSuccessMessage(getExaminationTranslation('MARKSHEET_GENERATION'), getCommonTranslation('SUCCESS'));
                            assessmentGroupMarksheetGrid.getStore().reload();
                            if(isNullOrEmpty(jData)){
                            	 form.close();
                            }
                            Ext.getBody().unmask();
                        }
                    });
                }
            });

        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },

    getDocumentController: function() {
        var this$ = this;
        return this$.getController('Academia.controller.document.DocumentController');
    },

    /**
     * Download all Marksheet generation
     */
    downloadAGAllMarksheetZip: function() {
        var $this = this;
        var assessmentGroupMarksheetGrid = $this.getAssessmentgroupmarksheetgrid();
        if (assessmentGroupMarksheetGrid.getSelectionModel().getCount() > 0) {
            //assessmentGroupMarksheetGrid.getSelectionModel().deselectAll();
            var records = assessmentGroupMarksheetGrid.getSelectionModel().getSelection();
            var saveModel = [];

            var marksheetZipName = records[0].get('programName') + '_' + records[0].get('batchName');
            for (var i in records) {
                if (!isNullOrEmpty(records[i].get('marksheetPath'))) {
				    var filePath = window.btoa(unescape(encodeURIComponent(records[i].get('marksheetPath'))));
                    saveModel.push(filePath);
                }
            }
            showConfirmMessage(getExaminationTranslation('MARKSHEET'), getExaminationTranslation('DOWNLOAD_ALL_MARKSHEET_MSG'), function(btn, text) {
                if (btn == 'yes') {
                    var directoryType = CONSTANTS.DIRECTORY_TYPE_MARKSHEET;
                    $this.getDocumentController().downloadMultipleDocumentFile(saveModel, marksheetZipName, directoryType);
                }
            });
        } else {
            $this.hideWindowMask();
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },

    //***********************Disable MoreAction Privileges*********************************************************		   
    disableMoreActionPivileges: function(gridReference, permissionsMap) {
        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        buttonsToolBar = gridReference.query('toolbar')[0];
        

        var btnEGPublishMarksheet = buttonsToolBar.query('#btnEGPublishMarksheet')[0];
        btnEGPublishMarksheet.hide();

        var btnEGGenerateMarksheet = buttonsToolBar.query('#btnEGGenerateMarksheet')[0];
        btnEGGenerateMarksheet.hide();
        
        var btnEGDownloadAllMarksheet = buttonsToolBar.query('#btnEGDownloadAllMarksheet')[0];
        btnEGDownloadAllMarksheet.hide();

        Ext.each(permissionList, function(privilege) {
            if (privilege === 'PUBLISHMARKSHEET') {
                if (!isNullOrEmpty(btnEGPublishMarksheet)) {
                	btnEGPublishMarksheet.setVisible(true);
                }
            }
            if (privilege === 'GENERATEANDDOWNLOADMARKSHEET') {
                if (!isNullOrEmpty(btnEGGenerateMarksheet)) {
                	btnEGGenerateMarksheet.setVisible(true);
                }
            }
            if (privilege === 'DOWNLOADMARKSHEETS') {
                if (!isNullOrEmpty(btnEGDownloadAllMarksheet)) {
                	btnEGDownloadAllMarksheet.setVisible(true);
                }
            }
            var button = buttonsToolBar.query('#btnEGUncheckedAll')[0];
            button.setVisible(true);
            
            gridReference.down('#btnMoreActions').show();
        });
    },

    //***********************Disable MoreAction Privileges*********************************************************		   
    disableGenerateButtonPivileges: function(form, permissionsMap) {
        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        var generateBtn = form.down('#generateBtnWin');
        generateBtn.setVisible(false);
        Ext.each(permissionList, function(privilege) {
            if (privilege === 'GENERATE') {
                if (!isNullOrEmpty(generateBtn)) {
                    generateBtn.setVisible(true);
                }
            }
        });
    },

    openMarksheetGenetionWindow: function() {
        var formWindow = this.getAgmarksheetgenerationwin();
        if (!formWindow) {
            Ext.widget('agmarksheetgenerationwin');
            formWindow = this.getAgmarksheetgenerationwin();
        }
        formWindow.show();
    },
    
    openPublishMarksheetWindow: function() {
        var formWindow = this.getEgpublishmarksheetwin();
        if (!formWindow) {
            Ext.widget('egpublishmarksheetwin');
            formWindow = this.getEgpublishmarksheetwin();
        }
        formWindow.show();
    },
});