/**
 * @author Bhanu PS
 */
Ext.define('Academia.controller.examinationcenters.revaluation.RevaluationSetupController', {
	extend: 'Academia.controller.base.BaseController',
	models : [],
	stores : ['examinationcenters.revaluation.RevaluationNameCodeStore','examCenter.AssignSequence.RevaluationTypeStore',
	          'examinationcenters.revaluation.RevaluationPeriodStore','examinationcenters.revaluation.RevaluationBatchStore',
	          'examinationcenters.revaluation.RevaluationProgramStore','examinationcenters.revaluation.RevaluationGridStore',
	          'examinationcenters.revaluation.RevaluationRuleGridStore','examinationcenters.revaluation.RevaluationMappedProgramStore',
	          'examinationcenters.revaluation.RevalFeePlanStore','examinationcenters.evaluation.evaluationPlanHeirarchy.DroolCalculationData',
	          'examinationcenters.revaluation.RevalFeePlanRuleStore','Academia.store.common.ProgramByAcAndLoIdStore',
	          'Academia.store.program.programbatchdetail.BatchStore','Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'],
	          views : ['examinationcenters.revaluation.RevaluationMasterStructure', 'examinationcenters.revaluation.RevaluationSearchStructure',
	                   'examinationcenters.revaluation.RevaluationSearchFilter', 'examinationcenters.revaluation.RevaluationSetupGrid',
	                   'examinationcenters.revaluation.AddRevaluationWin','examinationcenters.revaluation.AddRevaluationFormWindow','examinationcenters.revaluation.AddRevaluationRuleFormWindow','examinationcenters.revaluation.RevaluationRuleStructure',
	                   'examinationcenters.revaluation.RevaluationRuleGrid','examinationcenters.revaluation.RevaluationProgramWin',
	                   'examinationcenters.revaluation.AddRevaluationRuleWin','examinationcenters.revaluation.ProgramMappingStructure'],
	                   config:{
	                	   REVALUATION_SETUP_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('REVALUATION_SETUP_PRIVILEGES'),
	                	   REVALUATION_RULE_MAPPING_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('REVALUATION_RULE_MAPPING_PRIVILEGES')
	                   }, 	         
	                   refs : [{
	                	   ref : 'revaluationsearchfilter',
	                	   selector : 'revaluationsearchfilter'
	                   },{
	                	   ref : 'revaluationsetupgrid',
	                	   selector : 'revaluationsetupgrid'
	                   },{
	                	   ref : 'revaluationmasterstructure',
	                	   selector : 'revaluationmasterstructure'
	                   },{
	                	   ref : 'addrevaluationwin',
	                	   selector : 'addrevaluationwin'
	                   },{
	                	   ref : 'revaluationrulestructure',
	                	   selector : 'revaluationrulestructure'
	                   },{
	                	   ref : 'revaluationrulegrid',
	                	   selector : 'revaluationrulegrid'
	                   },{
	                	   ref : 'revaluationprogramwin',
	                	   selector : 'revaluationprogramwin'
	                   },{
	                	   ref : 'addrevaluationrulewin',
	                	   selector : 'addrevaluationrulewin'
	                   },{
	                	   ref : 'programmappingstructure',
	                	   selector : 'programmappingstructure'
	                   },{
	                	   ref : 'revaluationsearchstructure',
	                	   selector : 'revaluationsearchstructure'
	                   },{
	                	   ref: 'addrevaluationformwindow',
	                	   selector:'addrevaluationformwindow'
	                   },{
	                	   ref:'addrevaluationruleformwindow',
	                	   selector:'addrevaluationruleformwindow'
	                   }],
	                   init : function() {
	                	   this.control({

	                		   'revaluationsetupgrid':{
	                			   render:function(grid){
	                				   this.doAccessControlValidation(grid, this.getREVALUATION_SETUP_PERMISSION());
	                				   this.disableMoreActionGridPivileges(grid, this.getREVALUATION_SETUP_PERMISSION());
	                			   },
	                			   beforerender: function(grid) {
	                				   grid.getStore().removeAll();
	                			   }
	                		   },

	                		   'revaluationsearchstructure':{
	                			   afterrender : function(structure){
	                				   var $this = this;
	                				   var grid = structure.down('grid');
	                				   $this.getGridHeaderFreeze(grid,structure, false);
	                			   }
	                		   },
	                		   'revaluationsearchfilter button[itemId=quickSearchId]':{
	                			   click:function(obj){
	                				   var grid = this.getRevaluationsetupgrid();
	                				   var store = grid.getStore();
	                				   var filter=this.getRevaluationsearchfilter();
		                				 
	                				   var filterForm=this.getRevaluationsearchfilter().getForm();
	                				   var values = filterForm.getValues();
	                				   store.getProxy().extraParams={
	                					   "id":values.revaluationName,
	                					   "revaluationType":filterForm.findField('revaluationTypeEnum').getRawValue().toUpperCase(),
	                					   "fromDate":this.getRevaluationsearchfilter().down('#fromdate').getValue(),
	                					   "tillDate":this.getRevaluationsearchfilter().down('#tilldate').getValue(),
	                					   "programId":values.programId,
	                					   "batchId":values.batchId,
	                					   "periodId":values.periodId
	                				   };
	                				   this.resetPageSetting(grid.getStore(), grid);  
                                       grid.getStore().pageSize=100;
	                				   grid.getStore().loadPage(1);
	                				   grid.getSelectionModel().deselectAll();
	                				   grid.config.searchFilterForm = filter;
	                			   }
	                		   },
	                		   'revaluationsearchfilter button[itemId=resetBtn]':{
	                			   click:function(obj){
	                				   var filterForm=this.getRevaluationsearchfilter().getForm();
									   filterForm.reset();
	                				   filterForm.findField('programId').setDisabled(true);
	                				   filterForm.findField('batchId').setDisabled(true);
	                				   filterForm.findField('periodId').setDisabled(true);
	                				   
	                				   var tillDt = filterForm.findField('tilldate');
	                				   tillDt.setMinValue(null);
	                				   var fromDt = filterForm.findField("fromdate");
	                				   fromDt.setMaxValue(null);
	                			   }
	                		   }, 
	                		   'revaluationsearchfilter customcombobox[itemId=revaluationNameItemId]':{
	                			   afterrender :function(form){
	                				   form.getStore().load();
	                			   },
	                			   select:function(obj,rec){
	                				   var data=rec[0].data.id;
	                				   var filterForm=this.getRevaluationsearchfilter().getForm();
	                				   var programId=filterForm.findField('programId');
	                				   var fromDate=filterForm.findField('fromdate');
	                				   var tilldate=filterForm.findField('tilldate');
	                				   var batchId=filterForm.findField('batchId');
	                				   var periodId=filterForm.findField('periodId');
	                				   var revaluationTypeEnum=filterForm.findField('revaluationTypeEnum');
	                				   programId.reset();
	                				   batchId.reset();
	                				   batchId.setDisabled(true);
	                				   periodId.reset();
	                				   periodId.setDisabled(true);
	                				  /* revaluationTypeEnum.getStore().getProxy().extraParams = {
	                					   examRevaluationId:data
	                				   }*/
	                				   var revalType=rec[0].data.secondValue;
	                				   revaluationTypeEnum.getStore().load({
                						   callback:function(records) {
                							   for(i in records) {
	                							   if(records[i].data.Dvalue == revalType) {
	                								   revaluationTypeEnum.setValue(records[i].data.value);
	                								   
	                								   programId.setDisabled(false);
	            	                				   programId.reset();
	            	                				   programId.getStore().getProxy().extraParams = {
	            	                					   revaluationId: data,
	            	                					   fromDate:fromDate.getValue(),
	            	                					   tillDate:tilldate.getValue(),
	            	                					   revaluationType:revaluationTypeEnum.getValue()
	            	                				   };
	            	                				   programId.getStore().load({
	            	                					   callback: function(records){
	            	                						   if(records.length == 1) {
	            	                							   programId.setValue(records[0].get('id'));
	            	                							   
	            	                							   batchId.reset();
	        	            	                				   batchId.setDisabled(false);
	        	            	                				   
	        	            	                				   batchId.getStore().getProxy().extraParams = {
	        	            	                					   programId:records[0].get('id'),
	        	            	                					   fromDate:fromDate.getValue(),
	        	            	                					   tillDate:tilldate.getValue(),
	        	            	                					   revaluationType:revaluationTypeEnum.getValue(),
	        	            	                					   revaluationId:data
	        	            	                				   };
	        	            	                				   batchId.getStore().load({
	        	            	                					   callback: function(records){
	        	            	                						   if(records.length == 1) {
	        	            	                							   batchId.setValue(records[0].get('id'));
	        	            	                							   periodId.reset();
	        	            	                							   periodId.setDisabled(false);
	        	            	                							   //periodId.reset();
	        	            	                							   periodId.getStore().getProxy().extraParams = {
	        	            	        	                					   programId: programId.getValue(),
	        	            	        	                					   batchId: records[0].get('id'),
	        	            	        	                					   fromDate:fromDate.getValue(),
	        	            	        	                					   tillDate:tilldate.getValue(),
	        	            	        	                					   revaluationType:revaluationTypeEnum.getValue(),
	        	            	        	                					   revaluationId:data
	        	            	        	                				   };
	        	            	        	                				   periodId.getStore().load({
	        	            	                								   callback: function(records){
	        	            	                									   if(records.length == 1) {
	        	            	                									    periodId.setValue(records[0].get('id'));
	        	            	                									  }
	        	            	                								   } 
	        	            	                							   });
	        	            	                							  
	        	            	                						   }
	        	            	                					   }
	        	            	                				   });
	        	            	                			   
	            	                						   }
	            	                					   }
	            	                				   });
	            	                				  
	                								   
	                							   }
	                						   }
                						   }
                					   });
	                				  
	                			   }
	                		   },
	                		   'revaluationsearchfilter customcombobox[itemId=revaluationTypeEnum]':{
	                			   select:function(obj,rec){
	                				   var data=rec[0].data.id;
	                				   var filterForm=this.getRevaluationsearchfilter().getForm();
	                				   var programId=filterForm.findField('programId');
	                				   var revaluationName=filterForm.findField('revaluationName');
	                				   var fromDate=filterForm.findField('fromdate');
	                				   var tilldate=filterForm.findField('tilldate');
	                				   var batchId=filterForm.findField('batchId');
	                				   var periodId=filterForm.findField('periodId');
	                				   var revaluationTypeEnum=filterForm.findField('revaluationTypeEnum');
	                				   periodId.reset();
	                				   periodId.setDisabled(true);
	                				   batchId.reset();
	                				   batchId.setDisabled(true);
	                				   
	                				   programId.reset();
    								   programId.setDisabled(false);
	                				   programId.getStore().getProxy().extraParams = {
	                					   revaluationId: revaluationName.getValue(),
	                					   fromDate:fromDate.getValue(),
	                					   tillDate:tilldate.getValue(),
	                					   revaluationType:revaluationTypeEnum.getValue()
	                				   };
	                				   programId.getStore().load({
	                					   callback: function(records){
	                						   if(records.length == 1) {
	                							   programId.setValue(records[0].get('id'));
	                							   
	                							   batchId.reset();
            	                				   batchId.setDisabled(false);
            	                				   
            	                				   batchId.getStore().getProxy().extraParams = {
            	                					   programId:records[0].get('id'),
            	                					   fromDate:fromDate.getValue(),
            	                					   tillDate:tilldate.getValue(),
            	                					   revaluationType:revaluationTypeEnum.getValue(),
            	                					   revaluationId:revaluationName.getValue()
            	                				   };
            	                				   batchId.getStore().load({
            	                					   callback: function(records){
            	                						   if(records.length == 1) {
            	                							   batchId.setValue(records[0].get('id'));
            	                							   periodId.reset();
            	                							   periodId.setDisabled(false);
            	                							   periodId.getStore().getProxy().extraParams = {
            	        	                					   programId: programId.getValue(),
            	        	                					   batchId: records[0].get('id'),
            	        	                					   fromDate:fromDate.getValue(),
            	        	                					   tillDate:tilldate.getValue(),
            	        	                					   revaluationType:revaluationTypeEnum.getValue(),
            	        	                					   revaluationId:revaluationName.getValue()
            	        	                				   };
            	        	                				   periodId.getStore().load({
            	                								   callback: function(records){
            	                									   if(records.length == 1) {
            	                									    periodId.setValue(records[0].get('id'));
            	                									  }
            	                								   } 
            	                							   });
            	                							  
            	                						   }
            	                					   }
            	                				   });
            	                			   
	                						   }
	                					   }
	                				   });
	                				  
    								   
    							   
	                			   }
	                		   },
	                		   'revaluationsearchfilter datefield[itemId=fromdate]':{
	                			   change:function(obj,rec){
	                				   var filterForm=this.getRevaluationsearchfilter().getForm();
	                				   var programId=filterForm.findField('programId');
	                				   var revaluationName=filterForm.findField('revaluationName');
	                				   var fromDate=filterForm.findField('fromdate');
	                				   var tilldate=filterForm.findField('tilldate');
	                				   var batchId=filterForm.findField('batchId');
	                				   var periodId=filterForm.findField('periodId');
	                				   var revaluationTypeEnum=filterForm.findField('revaluationTypeEnum');
	                				   programId.setDisabled(true);
	                				   programId.reset();
	                				   programId.getStore().getProxy().extraParams = {
	                					   fromDate:fromDate.getValue(),
	                					   tillDate:tilldate.getValue(),
	                					   revaluationType:revaluationTypeEnum.getValue(),
	                					   revaluationId:revaluationName.getValue()
	                				   };
	                				   programId.getStore().load();
	                				   periodId.reset();
	                				   periodId.setDisabled(true);
	                				   batchId.reset();
	                				   batchId.setDisabled(true);
	                				   var form = this.getRevaluationsearchfilter();
	                				   var fromDt = form.down("#fromdate");
	                				   var tillDt = form.getForm().findField('tilldate');
	                				   if(!isNullOrEmpty(fromDt.getValue())){
	                					   tillDt.setMinValue(fromDt.getValue());
	                				   }
	                			   }
	                		   },
	                		   'revaluationsearchfilter datefield[itemId=tilldate]':{
	                			   change:function(obj,rec){
	                				   var filterForm=this.getRevaluationsearchfilter().getForm();
										//commented for V2D-155102
	                				   /*var programId=filterForm.findField('programId');
	                				   var revaluationName=filterForm.findField('revaluationName');
	                				   var fromDate=filterForm.findField('fromdate');
	                				   var tilldate=filterForm.findField('tilldate');
	                				   var batchId=filterForm.findField('batchId');
	                				   var periodId=filterForm.findField('periodId');
	                				   var revaluationTypeEnum=filterForm.findField('revaluationTypeEnum');
	                				   programId.setDisabled(false);
	                				   programId.reset();
	                				   programId.getStore().getProxy().extraParams = {
	                					   fromDate:fromDate.getValue(),
	                					   tillDate:tilldate.getValue(),
	                					   revaluationType:revaluationTypeEnum.getValue(),
	                					   revaluationId:revaluationName.getValue()
	                				   };
	                				   programId.getStore().load();
	                				   periodId.reset();
	                				   periodId.setDisabled(true);
	                				   batchId.reset();
	                				   batchId.setDisabled(true);*/
	                				   var form = this.getRevaluationsearchfilter();
	                				   var fromDt = form.down("#fromdate");
	                				   var tillDt = form.getForm().findField('tilldate');
	                				   if(!isNullOrEmpty(tillDt.getValue())){
	                					   fromDt.setMaxValue(tillDt.getValue());
	                				   }
	                			   }
	                		   },
	                		   'revaluationsearchfilter customcombobox[itemId=programIdQuickFilter]':{
	                			   select:function(obj,rec){
	                				   var data=rec[0].data.id;
	                				   var filterForm=this.getRevaluationsearchfilter().getForm();
	                				   var programId=filterForm.findField('programId');
	                				   var revaluationName=filterForm.findField('revaluationName');
	                				   var fromDate=filterForm.findField('fromdate');
	                				   var tilldate=filterForm.findField('tilldate');
	                				   var batchId=filterForm.findField('batchId');
	                				   var periodId=filterForm.findField('periodId');
	                				   var revaluationTypeEnum=filterForm.findField('revaluationTypeEnum');
	                				   batchId.setDisabled(false);
	                				   batchId.reset();
	                				   batchId.getStore().getProxy().extraParams = {
	                					   programId: data,
	                					   fromDate:fromDate.getValue(),
	                					   tillDate:tilldate.getValue(),
	                					   revaluationType:revaluationTypeEnum.getValue(),
	                					   revaluationId:revaluationName.getValue()
	                				   };
	                				   batchId.getStore().load({
	                					   callback: function(records){
	                						   if(records.length == 1) {
	                							   batchId.setValue(records[0].get('id'));
	                							   periodId.setDisabled(false);
	                							   //periodId.reset();
	                							   periodId.getStore().getProxy().extraParams = {
	        	                					   programId: programId.getValue(),
	        	                					   batchId: records[0].get('id'),
	        	                					   fromDate:fromDate.getValue(),
	        	                					   tillDate:tilldate.getValue(),
	        	                					   revaluationType:revaluationTypeEnum.getValue(),
	        	                					   revaluationId:revaluationName.getValue()
	        	                				   };
	        	                				   periodId.getStore().load({
	                								   callback: function(records){
	                									   if(records.length == 1) {
	                									    periodId.setValue(records[0].get('id'));
	                									  }
	                								   } 
	                							   });
	                							  
	                						   } else {
	                							   	   periodId.reset();
		                							   periodId.setDisabled(true);
	                						   }
	                					   }
	                				   });
	                			   }
	                		   },
	                		   'revaluationsearchfilter customcombobox[itemId=batchIdQuickFilter]':{
	                			   select:function(obj,rec){
	                				   var data=rec[0].data.id;
	                				   var filterForm=this.getRevaluationsearchfilter().getForm();
	                				   var programId=filterForm.findField('programId');
	                				   var revaluationName=filterForm.findField('revaluationName');
	                				   var fromDate=filterForm.findField('fromdate');
	                				   var tilldate=filterForm.findField('tilldate');
	                				   var batchId=filterForm.findField('batchId');
	                				   var periodId=filterForm.findField('periodId');
	                				   var revaluationTypeEnum=filterForm.findField('revaluationTypeEnum');
	                				   periodId.setDisabled(false);
	                				   periodId.reset();
	                				   periodId.getStore().getProxy().extraParams = {
	                					   programId: programId.getValue(),
	                					   batchId: data,
	                					   fromDate:fromDate.getValue(),
	                					   tillDate:tilldate.getValue(),
	                					   revaluationType:revaluationTypeEnum.getValue(),
	                					   revaluationId:revaluationName.getValue()
	                				   };
	                				   periodId.getStore().load();
	                			   }
	                		   },

	                		   'revaluationsetupgrid button[itemId=btnAdd]':{
	                			   click:function(obj,rec){
	                				   var $this = this;
	                				   var grid =  $this.getRevaluationsetupgrid();
	                				 

	                				   $this.showWindow('addrevaluationformwindow');
	                				   Ext.apply(grid,{
	                					   mode:null,
	                					   setMode : function(mode){
	                						   grid.mode = mode;
	                					   },
	                					   getMode:function(){
	                						   return grid.mode;
	                					   }
	                				   });
	                				   grid.setMode('save');
	                			   }
	                		   },

	                		   'revaluationsetupgrid button[itemId=btnDelete]':{
	                			   click:function(obj,rec){
	                				   var $this = this;
	                				   var grid =  $this.getRevaluationsetupgrid();
	                				   if(grid.getSelectionModel().getCount() > 0) {
	                					   showConfirmMessage(getCommonTranslation('ALERT'),
	                							   getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
	                							   function(btn, text) {
	                						   var id = grid.getSelectionModel().getSelection()[0].data.id;
	                						   if (btn == 'yes') {
	                							   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                							   Ext.Ajax.request({
	                								   method : "DELETE",
	                								   type : 'rest',
	                								   url : SERVERURL.PATH_DELETE_REVALUATION+ '?id='+id,
	                								   headers : {
	                									   'Content-Type' : 'application/json'
	                								   },
	                								   params : {
	                									   id:id
	                								   },
	                								   success : function(form,action) {
	                									   Ext.getBody().unmask();
	                									   showSuccessMessage(getExaminationTranslation('SUCCESS'),getCommonTranslation('SUCCESS'));
	                									   grid.getStore().reload();
	                									   grid.getSelectionModel().deselectAll();;
	                								   },
													   failure: function(result, request) {
                    										showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('DEPENDENCY_EXIST_MSG')); //Error occured while performing transaction
                    										return false;
                									   }
	                							   });
	                						   }
	                					   });

	                				   } else {
	                					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                				   }

	                			   }
	                		   },

	                		   'revaluationsetupgrid button[itemId=btnView]':{
	                			   click:function(obj,rec){
	                				   var $this = this;
	                				   var grid =  $this.getRevaluationsetupgrid();
	                				   if(grid.getSelectionModel().getCount() > 0) {
	                					   var formWindow =  $this.showWindow('addrevaluationformwindow');
	                					   var window=$this.getAddrevaluationformwindow();
		                				   window.setTitle(getExaminationTranslation('VIEW_REVALUATION_SETUP'));
	                					   Ext.apply(grid,{
	                						   mode:null,
	                						   setMode : function(mode){
	                							   grid.mode = mode;
	                						   },
	                						   getMode:function(){
	                							   return grid.mode;
	                						   }
	                					   });
	                					   grid.setMode('edit');
	                					   var record = grid.getSelectionModel().getSelection()[0];
	                					   formWindow.down('#revaluationCodeItemId').setValue(record.data.revaluationCode);
	                					   formWindow.down('#revaluationNameItemId').setValue(record.data.revaluationName);
	                					   formWindow.down('#maxRevalToApplyItemId').setValue(record.data.maxRevaluationToApply);
	                					   formWindow.down('#validTillItemId').setValue(record.data.validTill);
	                					    if(record.data.whetherRevalFeeApplicable) {
	                						   formWindow.down('#revalFeeApplicableItemId').setValue(true).setReadOnly(true);
	                						   formWindow.down('#revalApplicableForItemId').setValue(record.data.revaluationFor).setReadOnly(true);
	                					   }
	                					   else{
	                						  var revalFeeApplicableItemId =  formWindow.down('#revalFeeApplicableItemId')
	                						   revalFeeApplicableItemId.items.items[1].setValue(true);
	                						   formWindow.down('#revalFeeApplicableItemId').setReadOnly(true);
	                					   }
	                					   var applicableFor = formWindow.down('#revalApplicableForItemId');
	                					   if(record.data.revaluationFor == getExaminationTranslation('COURSE_LEVEL')){
	                						   applicableFor.items.items[0].setValue(true);
	                						   applicableFor.items.items[1].setValue(false);
	                					   } else {
	                						   applicableFor.items.items[0].setValue(false);
	                						   applicableFor.items.items[1].setValue(true);
	                					   }
	                					   formWindow.down('#submitButtonId').setVisible(false);
	                					   formWindow.down('#revaluationCodeItemId').setReadOnly(true);
	                					   formWindow.down('#revaluationNameItemId').setReadOnly(true);
	                					   formWindow.down('#maxRevalToApplyItemId').setReadOnly(true);
	                					   formWindow.down('#validTillItemId').setReadOnly(true);
	                					   formWindow.down('#revalApplicableForItemId').setReadOnly(true);
	                				   } else {
	                					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                				   }

	                			   }
	                		   },

	                		   'revaluationsetupgrid button[itemId=btnEdit]':{
	                			   click:function(obj,rec){
	                				   var $this = this;
	                				   var grid =  $this.getRevaluationsetupgrid();
	                				  
	                				   if(grid.getSelectionModel().getCount() > 0) {
	                					 var formWindow =  $this.showWindow('addrevaluationformwindow');
	                					   var window=$this.getAddrevaluationformwindow();
		                				   window.setTitle(getExaminationTranslation('EDIT_REVALUATION_SETUP'));
	                					   Ext.apply(grid,{
	                						   mode:null,
	                						   setMode : function(mode){
	                							   grid.mode = mode;
	                						   },
	                						   getMode:function(){
	                							   return grid.mode;
	                						   }
	                					   });
	                					   grid.setMode('edit');
	                					   var record = grid.getSelectionModel().getSelection()[0];
	                					   formWindow.down('#revaluationCodeItemId').setValue(record.data.revaluationCode);
	                					   formWindow.down('#revaluationNameItemId').setValue(record.data.revaluationName);
	                					   formWindow.down('#maxRevalToApplyItemId').setValue(record.data.maxRevaluationToApply).setReadOnly(true);
	                					   //formWindow.down('#revalFeeApplicableItemId').setReadOnly(true); 
	                					  // formWindow.down('#revalApplicableForItemId').setValue(record.data.revaluationFor).setReadOnly(true); 
	                					   formWindow.down('#validTillItemId').setValue(record.data.validTill);
	                					   var applicableFor = formWindow.down('#revalApplicableForItemId');
	                					   record.data.whetherRevaluationApplied;
	                					   if(record.data.whetherRevalFeeApplicable) {
	                						   formWindow.down('#revalApplicableForItemId').setValue(record.data.revaluationFor).
	                						   		setReadOnly(true);
	                					   }
	                					   else {
	                						   var revalFeeApplicableItemId =  formWindow.down('#revalFeeApplicableItemId')
	                						   revalFeeApplicableItemId.items.items[0].setValue(false);
	                						   revalFeeApplicableItemId.items.items[1].setValue(true);
	                						   formWindow.down('#revalFeeApplicableItemId').setReadOnly(true);
	                					   }
	                					   if(record.data.whetherRevaluationApplied) {
	                						   formWindow.down('#revalFeeApplicableItemId').setValue(record.data.whetherRevalFeeApplicable).
	                						   		setReadOnly(true);
	                					   } else {
	                						   formWindow.down('#revalApplicableForItemId').setValue(record.data.whetherRevalFeeApplicable).
               						   		setReadOnly(false);
	                						   formWindow.down('#revalFeeApplicableItemId').setValue(record.data.whetherRevalFeeApplicable).
	                						   		setReadOnly(false);
	                					   }
	                					   if(record.data.revaluationFor == getExaminationTranslation('COURSE_LEVEL')){
	                						   applicableFor.items.items[0].setValue(true);
	                						   applicableFor.items.items[1].setValue(false);
	                					   } else {
	                						   applicableFor.items.items[0].setValue(false);
	                						   applicableFor.items.items[1].setValue(true);
	                					   }
	                				   } else {
	                					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                				   }

	                			   }
	                		   },
	                		   'revaluationprogramwin grid[itemId=programPeriodGrid] button#btnDelete':{
	                			   click : function(obj){
	                				   var $this = this;
	                				   var ruleGrid = $this.getRevaluationrulegrid();
	                				   var grid = obj.up().up();
	                				   var windowForm = $this.getRevaluationprogramwin();
	                				   var record  = grid.getSelectionModel().getSelection();
	                				   if(grid.getSelectionModel().getCount() > 0) {
	                					   showConfirmMessage(getCommonTranslation('ALERT'),
	                							   getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
	                							   function(btn, text) {
	                						   if (btn == 'yes') {
	                							   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                							   var ids = [];
	                							   for(var i in record) {
	                								   ids.push(record[i].data.id);
	                							   }
	                							   Ext.Ajax.request({
	                								   method : "DELETE",
	                								   type : 'rest',
	                								   url : SERVERURL.PATH_FIND_RULE_MAPPING_DELETE+ '?ids='+ids,
	                								   headers : {
	                									   'Content-Type' : 'application/json'
	                								   },
	                								   params : {
	                									   ids:ids
	                								   },
	                								   success : function(form,action) {
	                									   Ext.getBody().unmask();
	                									   showSuccessMessage(getExaminationTranslation('SUCCESS'),getCommonTranslation('SUCCESS'));
	                									   ruleGrid.getStore().reload();
	                									   ruleGrid.getSelectionModel().deselectAll();
	                									   windowForm.close();
	                								   }
	                							   });
	                						   }
	                					   });

	                				   } else {
	                					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                				   }
	                			   }
	                		   },
	                		   'revaluationsetupgrid button[itemId=btnManageRule]':{
	                			   click : function(){
	                				   var $this = this;
	                				   var grid =  $this.getRevaluationsetupgrid();
	                				   var record = grid.getSelectionModel().getSelection()[0];
	                				   if(grid.getSelectionModel().getCount() > 0) {
	                					   var contentPanel = $this.getRevaluationmasterstructure();
	                					   var newTab = contentPanel.items.findBy(function(tab) {
	                						   return tab.title === getExaminationTranslation('MANAGE_RULES');
	                					   });
	                					   if (!newTab) {
	                						   contentPanel.add({
	                							   title: getExaminationTranslation('MANAGE_RULES'),
	                							   closable : true,
	                							   autoScroll:true,
	                							   xtype : 'revaluationrulestructure',
	                						   }).show();
	                					   }
	                					   contentPanel.setActiveTab(newTab);
	                					   contentPanel.doLayout();
	                					   var gridRule = $this.getRevaluationrulegrid();
	                					   gridRule.down('#whetherRevalApplicable').setValue(record.get('whetherRevalFeeApplicable'));

		                				   if(!record.get('whetherRevalFeeApplicable')){
		                					   gridRule.columns[1].setVisible(false);
		                					   gridRule.columns[2].setVisible(false);
		                				   }else{
		                					   gridRule.columns[1].setVisible(true);
		                					   gridRule.columns[2].setVisible(true);
		                				   }
	                					   gridRule.getStore().getProxy().extraParams={
	                						   examRevaluationId:record.data.id
	                					   };
	                					   gridRule.getStore().load();
	                					   Ext.apply(gridRule,{
	                						   revalNameCode:null,
	                						   setRevalNameCode : function(revalNameCode){
	                							   gridRule.revalNameCode = revalNameCode;
	                						   },
	                						   getRevalNameCode:function(){
	                							   return gridRule.revalNameCode;
	                						   }
	                					   });
	                					   var data = {
	                							   'name':record.data.revaluationCode+" / "+record.data.revaluationName,
	                							   'id':record.data.id
	                					   }
	                					   gridRule.setRevalNameCode(data);

	                				   } else {
	                					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                				   }
	                			   }
	                		   },

	                		   'programmappingstructure button[itemId=addFilterBtn]':{
	                			   click: function(obj){
	                				   this.addMultipleProgramBatchForMapping(obj);
	                			   }
	                		   },
	                		   'programmappingstructure button[itemId=periodMappingBtn]':{
	                			   click:function(obj){
	                				   var $this = this;
	                				   var formWindow = this.getProgrammappingstructure();
	                				   var json = $this.getRuleJsonJson();
	                				   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                				   var grid =  $this.getRevaluationrulegrid();
	                				   var submitUrl = SERVERURL.PATH_FIND_RULE_MAPPING_CREATE;
	                				   Ext.Ajax.request({
	                					   type : 'rest',
	                					   url : submitUrl,
	                					   jsonData : json,
	                					   method : 'POST',
	                					   success : function(resp, action) {
	                						   Ext.getBody().unmask();
	                						   showSuccessMessage(getExaminationTranslation('SUCCESS'),getCommonTranslation('SUCCESS'));
	                						   grid.getStore().reload();
	                						   grid.getSelectionModel().deselectAll();
	                						   var contentPanel = $this.getRevaluationmasterstructure();
	                						   contentPanel.items.items[2].close();
	                					   }
	                				   });
	                			   }
	                		   },

	                		   'programmappingstructure combo[itemId=program]': {
	                			   render : function(combo){
	                				   var academyLocationId = this.getCurrentAcademyLocation();
	                				   var store = combo.getStore();
	                				   store.proxy.extraParams = {
	                						   academyLocationId : academyLocationId
	                				   };
	                				   store.load();
	                			   }
	                		   },
	                		   'revaluationrulegrid button[itemId=mapProgramBtn]':{
	                			   click : function(){
	                				   var $this = this;
	                				   var gridRule = $this.getRevaluationrulegrid();
	                				   if(gridRule.getSelectionModel().getCount() > 0) {
	                					   var contentPanel = $this.getRevaluationmasterstructure();
	                					   var newTab = contentPanel.items.findBy(function(tab) {
	                						   return tab.title === getExaminationTranslation('PROGRAM_DETAILS');
	                					   });
	                					   if (!newTab) {
	                						   contentPanel.add({
	                							   title: getExaminationTranslation('PROGRAM_DETAILS'),
	                							   closable : true,
	                							   autoScroll:true,
	                							   xtype : 'programmappingstructure',
	                						   }).show();
	                					   }
	                					   contentPanel.setActiveTab(newTab);
	                					   contentPanel.doLayout();
	                					   var grid =  $this.getRevaluationsetupgrid();
	                					   var record = grid.getSelectionModel().getSelection()[0];
	                					   var programDetails  = $this.getProgrammappingstructure();
	                					   programDetails.down('#revaluationName').setValue(gridRule.getRevalNameCode().name);
	                				   } else {
	                					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                				   }
	                			   }
	                		   },

	                		   'revaluationrulegrid':{
	                			   render:function(grid){
	                				   this.doAccessControlValidation(grid, this.getREVALUATION_RULE_MAPPING_PERMISSION());
	                				   this.disableMoreActionGridPivileges(grid, this.getREVALUATION_RULE_MAPPING_PERMISSION());
	                			   },
	                			  afterrender: function(grid,cell){
	                				   var whetherRevalApplicable= this.getRevaluationsetupgrid().getSelectionModel().getSelection()[0].get('whetherRevalFeeApplicable');

		                				   if(!whetherRevalApplicable){
		                					   grid.columns[1].setVisible(false);
		                					   grid.columns[2].setVisible(false);
		                				   }else{
		                					   grid.columns[1].setVisible(true);
		                					   grid.columns[2].setVisible(true);
		                				   }
	                			   },
	                			   cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
	                				   if (e.target.tagName == 'A') {
	                					   var $this = this;
	                					   var grid =  $this.getRevaluationrulegrid();
	                					   var record = grid.getSelectionModel().getSelection()[0];
	                					   var formWindow = $this.getRevaluationprogramwin();
	                					   if (!formWindow) {
	                						   Ext.widget('revaluationprogramwin');
	                						   formWindow = $this.getRevaluationprogramwin();
	                					   }
	                					   formWindow.show();
	                					   var grid = formWindow.down('grid');
	                					   grid.getStore().getProxy().extraParams={
	                						   examRevaluationId:record.data.id
	                					   };
	                					   grid.getStore().load();
	                				   }
	                			   }
	                		   },

	                		   'revaluationrulegrid button[itemId=btnDelete]':{
	                			   click:function(obj,rec){
	                				   var $this = this;
	                				   var grid =  $this.getRevaluationrulegrid();
	                				   if(grid.getSelectionModel().getCount() > 0) {
	                					   showConfirmMessage(getCommonTranslation('ALERT'),
	                							   getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
	                							   function(btn, text) {
	                						   var id = grid.getSelectionModel().getSelection()[0].data.id;
	                						   if (btn == 'yes') {
	                							   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                							   Ext.Ajax.request({
	                								   method : "DELETE",
	                								   type : 'rest',
	                								   url : SERVERURL.PATH_DELETE_REVALUATION_RULE+ '?id='+id,
	                								   headers : {
	                									   'Content-Type' : 'application/json'
	                								   },
	                								   params : {
	                									   id:id
	                								   },
	                								   success : function(form,action) {
	                									   Ext.getBody().unmask();
	                									   showSuccessMessage(getExaminationTranslation('SUCCESS'),getCommonTranslation('SUCCESS'));
	                									   grid.getStore().reload();
	                									   grid.getSelectionModel().deselectAll();;
	                								   }
	                							   });
	                						   }
	                					   });

	                				   } else {
	                					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                				   }

	                			   }
	                		   },

	                		   'revaluationrulegrid button[itemId=btnAdd]':{
	                			   click:function(obj,rec){
	                				   var $this = this;
	                				   var grid =  $this.getRevaluationrulegrid();
	                				  // var formWindow = $this.getAddrevaluationrulewin();
	                				   var whetherRevalFeeApplicable = grid.down('#whetherRevalApplicable').getValue();
	                				   var formWindowRule = $this.showWindow('addrevaluationruleformwindow');
	                				   var formWindow = formWindowRule.down('form');
	                				
	                				   var feePlan = formWindow.down('#feePlanType');
	                				   feePlan.getStore().getProxy().extraParams={
	                					   filterType:'FeePlan',
	                					   feePlanTypeId:5
	                				   };
	                				   feePlan.getStore().load();
	                				   var droolsItemId = formWindow.down('#droolsItemId');
	                				   droolsItemId.getStore().getProxy().extraParams={
	                					   moduleName:'REVALUATION'
	                				   };
	                				   droolsItemId.getStore().load();
	                				   formWindow.down('#revaluationName').setValue(grid.getRevalNameCode().name);
	                				   Ext.apply(grid,{
	                					   editMode:null,
	                					   setEditMode : function(editMode){
	                						   grid.editMode = editMode;
	                					   },
	                					   getEditMode:function(){
	                						   return grid.editMode;
	                					   }
	                				   });
	                				   grid.setEditMode(false);
	                			   }
	                		   },

	                		   'revaluationrulegrid button[itemId=btnEdit]':{
	                			   click:function(obj,rec){
	                				   var $this = this;
	                				   var grid =  $this.getRevaluationrulegrid();
	                				   if(grid.getSelectionModel().getCount() > 0) {
	                					   var formWindowRule = $this.showWindow('addrevaluationruleformwindow');
	                					   var formWindow = formWindowRule.down('form');
	                					   
	                					   var record = grid.getSelectionModel().getSelection();
	                					   formWindow.down('#feeAmount').setValue(record[0].data.feeAmount);
	                					   formWindow.down('#feeAmount').setDisabled(false);
	                					   formWindow.down('#maxCourseToApplyItemId').setValue(record[0].data.maxRevaluationToApply);
	                					   formWindow.down('#noOfRevaluaterItemId').setValue(record[0].data.noOfRevaluers);
	                					   var revalType = formWindow.down('#revaluationTypeEnum');
	                					   revalType.getStore().load({
	                						   callback:function(records) {
	                							   for(i in records) {
	                								   if(records[i].data.id.toUpperCase() == record[0].data.revaluationType.toUpperCase()) {
	                									   revalType.setValue(records[i].data.value);
	                								   }
	                							   }
	                						   }
	                					   });
	                					   var feePlan = formWindow.down('#feePlanType');
	                					   feePlan.getStore().getProxy().extraParams={
	                						   filterType:'FeePlan',
	                						   feePlanTypeId:5
	                					   };
	                					   feePlan.getStore().load({
	                						   callback:function(records) {
	                							   for(i in records) {
	                								   if(records[i].data.id == record[0].data.feePlanId) {
	                									   feePlan.setValue(records[i].data.id);
	                									   var rule = formWindow.down('#feePlanRuleItemId');
	                									   rule.getStore().getProxy().extraParams={
	                										   filterType:'FeePlanRule',
	                										   feePlanTypeId:5,
	                										   feePlanId:records[i].data.id
	                									   };
	                									   rule.getStore().load({
	                										   callback:function(rec) {
	                											   for(j in rec) {
	                												   if(rec[j].data.id == record[0].data.feePlanRule.id){
	                													   rule.setDisabled(false);
	                													   rule.setValue(rec[j].data.id );
	                												   }
	                											   }
	                										   }
	                									   });
	                								   }
	                							   }
	                						   }
	                					   });
	                					   var droolsItemId = formWindow.down('#droolsItemId');
	                					   droolsItemId.getStore().getProxy().extraParams={
	                						   moduleName:'REVALUATION'
	                					   };
	                					   droolsItemId.getStore().load({
	                						   callback:function(records) {
	                							   for(i in records) {
	                								   if(records[i].data.value == record[0].data.ruleApplicable) {
	                									   droolsItemId.setValue(records[i].data.id);
	                								   }
	                							   }
	                						   }
	                					   });
	                					   formWindow.down('#revaluationName').setValue(grid.getRevalNameCode().name);
	                					   Ext.apply(grid,{
	                						   editMode:null,
	                						   setEditMode : function(editMode){
	                							   grid.editMode = editMode;
	                						   },
	                						   getEditMode:function(){
	                							   return grid.editMode;
	                						   }
	                					   });
	                					   grid.setEditMode(true);
	                				   } else {
	                					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                				   }
	                			   }
	                		   },

	                		   'revaluationrulegrid button[itemId=btnView]':{
	                			   click:function(obj,rec){
	                				   var $this = this;
	                				   var grid =  $this.getRevaluationrulegrid();
	                				  
	                				   if(grid.getSelectionModel().getCount() > 0) {
	                					   var formRuleWindow = $this.showWindow('addrevaluationruleformwindow');
		                				   
	                					   var formWindow = formRuleWindow.down('form');
	                					   var record = grid.getSelectionModel().getSelection()[0];
		                				   formWindow.down('#feeAmount').setValue(record.data.feeAmount);
		                				   formWindow.down('#feeAmount').setReadOnly(true);
		                				   formWindow.down('#maxCourseToApplyItemId').setValue(record.data.maxRevaluationToApply);
		                				   formWindow.down('#maxCourseToApplyItemId').setReadOnly(true);
		                				   formWindow.down('#noOfRevaluaterItemId').setValue(record.data.noOfRevaluers);
		                				   formWindow.down('#noOfRevaluaterItemId').setReadOnly(true);
		                				   var revalType = formWindow.down('#revaluationTypeEnum');
		                				   revalType.setReadOnly(true);
		                				   revalType.getStore().load({
		                					   callback:function(records) {
		                						   for(i in records) {
		                							   if(records[i].data.id.toUpperCase() == record.data.revaluationType.toUpperCase()) {
		                								   revalType.setValue(records[i].data.value);
		                							   }
		                						   }
		                					   }
		                				   });
		                				   var feePlan = formWindow.down('#feePlanType');
		                				   feePlan.setReadOnly(true);
		                				   feePlan.getStore().getProxy().extraParams={
		                					   filterType:'FeePlan',
		                					   feePlanTypeId:5
		                				   };
		                				   feePlan.getStore().load({
		                					   callback:function(records) {
		                						   for(i in records) {
		                							   if(records[i].data.id == record.data.feePlanId) {
		                								   feePlan.setValue(records[i].data.id);
		                								   var rule = formWindow.down('#feePlanRuleItemId');
		                								   rule.setReadOnly(true);
		                								   rule.getStore().getProxy().extraParams={
		                									   filterType:'FeePlanRule',
		                									   feePlanTypeId:5,
		                									   feePlanId:records[i].data.id
		                								   };
		                								   rule.getStore().load({
		                									   callback:function(rec) {
		                										   for(j in rec) {
		                											   if(rec[j].data.id == record.data.feePlanRule.id){
		                												   rule.setDisabled(false);
		                												   rule.setValue(rec[j].data.id );
		                											   }
		                										   }
		                									   }
		                								   });
		                							   }
		                						   }
		                					   }
		                				   });
		                				   var droolsItemId = formWindow.down('#droolsItemId');
		                				   droolsItemId.setReadOnly(true);
		                				   droolsItemId.getStore().getProxy().extraParams={
		                					   moduleName:'REVALUATION'
		                				   };
		                				   droolsItemId.getStore().load({
		                					   callback:function(records) {
		                						   for(i in records) {
		                							   if(records[i].data.value == record.data.ruleApplicable) {
		                								   droolsItemId.setValue(records[i].data.id);
		                							   }
		                						   }
		                					   }
		                				   });
		                				   formWindow.down('#revaluationName').setValue(grid.getRevalNameCode().name);
		                				   formWindow.down('#revaluationName').setReadOnly(true);
		                				   Ext.apply(grid,{
		                					   editMode:null,
		                					   setEditMode : function(editMode){
		                						   grid.editMode = editMode;
		                					   },
		                					   getEditMode:function(){
		                						   return grid.editMode;
		                					   }
		                				   });
		                				   grid.setEditMode(true);
		                				   formWindow.down('#submitButtonId').setVisible(false);
	                				   } else {
	                					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));   
	                				   }
	                			   }
	                		   },

	                		   'addrevaluationrulewin':{
	                			   afterrender:function(obj){
	                				   var $this = this;
	                				   var grid =  $this.getRevaluationsetupgrid();
	                				   var record = grid.getSelectionModel().getSelection()[0];
	                				   obj.down('#addRuleHiddenCombo').setValue(record.get('whetherRevalFeeApplicable'));
	                				   obj.down('#maxCourseToApplyItemId').setMaxValue(record.data.maxRevaluationToApply);
	                				   if(!record.get('whetherRevalFeeApplicable')){
	                					   obj.down('#feePlanType').setVisible(false);
	                					   obj.down('#feePlanRuleItemId').setVisible(false);
	                					   obj.down('#feeAmount').setVisible(false);
	                					   obj.down('#feePlanType').allowBlank = true;
	                					   obj.down('#feePlanRuleItemId').allowBlank = true;
	                					   obj.down('#feeAmount').allowBlank = true;
	                				   }
	                				   
	                			   }
	                		   },
	                		  
	                		   'addrevaluationrulewin customcombobox[itemId=feePlanType]':{
	                			   select:function(obj,rec){
	                				   var data=rec[0].data.id;
	                				   var formWindow = this.getAddrevaluationrulewin();
	                				   var feePlanRule = formWindow.down('#feePlanRuleItemId');
	                				   feePlanRule.enable();
	                				   feePlanRule.getStore().getProxy().extraParams = {
	                					   filterType:'FeePlanRule',
	                					   feePlanTypeId:5,
	                					   feePlanId:data
	                				   };
	                				   feePlanRule.getStore().load();
	                			   }
	                		   },
	                		   
	                		   'addrevaluationrulewin customcombobox[itemId=feePlanRuleItemId]':{
	                			   select:function(obj,rec){
	                				   var formWindow = this.getAddrevaluationrulewin();
	                				   var feeAmount = formWindow.down('#feeAmount');
	                				   feeAmount.setDisabled(false);
	                				   feeAmount.setValue(parseInt(rec[0].data.code));
	                			   }
	                		   },

	                		   'addrevaluationrulewin button[itemId=cancelButtonId]':{
	                			   click:function(obj){
	                				   var formWindow =obj.up('window');
	                				   formWindow.close();
	                			   }
	                		   },

	                		   'addrevaluationrulewin button[itemId=submitButtonId]':{
	                			   click:function(obj){
	                				   var $this = this;
	                				   var formWindow = this.getAddrevaluationrulewin();
									   var savebtn=formWindow.down('#submitButtonId');
									   savebtn.setDisabled(true);  //for multiple-clicks prevent V2D-330256
	                				   var formWindowRule = $this.getAddrevaluationruleformwindow();
	                				   var json;
	                				   $this.applyWindowMask();
	                				   var grid =  $this.getRevaluationrulegrid();
	                				   var record = grid.getSelectionModel().getSelection()[0];
	                				   var submitUrl;
	                				   if(!grid.getEditMode()) {
	                					   submitUrl = SERVERURL.PATH_SAVE_REVALUATION_RULE;
	                					   var feePlan = {
	                							   'id': formWindow.down('#feePlanType').getValue()
	                					   };
	                					   var feePlanRuleStage = {
	                							   'id': formWindow.down('#feePlanRuleItemId').getValue()
	                					   };
	                					   var examinationRevaluation={
	                							   'id':grid.getRevalNameCode().id
	                					   };
	                					    var revalType = formWindow.down('#revaluationTypeEnum').getValue();
	                					   json={
	                							   examinationRevaluation:examinationRevaluation,
	                							  revaluationType:(revalType ? revalType.toUpperCase(): ''),
	                							   feePlanType:feePlan,
	                							   feePlanRule:feePlanRuleStage,
	                							   noOfRevaluers:formWindow.down('#noOfRevaluaterItemId').getValue(),
	                							   maxRevaluationToApply:formWindow.down('#maxCourseToApplyItemId').getValue(),
	                							   ruleApplicable:formWindow.down('#droolsItemId').valueModels[0].data.code,
	                							   feeAmount:formWindow.down('#feeAmount').getValue()
	                					   };
	                				   } else if(grid.getEditMode()){
	                					   submitUrl = SERVERURL.PATH_UPDATE_REVALUATION_RULE;
	                					   var feePlan = {
	                							   'id': formWindow.down('#feePlanType').getValue()
	                					   };
	                					   var feePlanRuleStage = {
	                							   'id': formWindow.down('#feePlanRuleItemId').getValue()
	                					   };
	                					   var examinationRevaluation={
	                							   'id':grid.getRevalNameCode().id
	                					   };
	                					   var revalTypeVal = formWindow.down('#revaluationTypeEnum').getValue();
	                					   json={
	                							   id:record.data.id,
	                							   examinationRevaluation:examinationRevaluation,
	                							   revaluationType: (revalTypeVal ? revalTypeVal.toUpperCase() :''),
	                							   feePlanType:feePlan,
	                							   feePlanRule:feePlanRuleStage,
	                							   noOfRevaluers:formWindow.down('#noOfRevaluaterItemId').getValue(),
	                							   maxRevaluationToApply:formWindow.down('#maxCourseToApplyItemId').getValue(),
	                							   ruleApplicable:formWindow.down('#droolsItemId').valueModels[0].data.code,
	                							   feeAmount:formWindow.down('#feeAmount').getValue()
	                					   };

	                				   }
	                			
	                			if(formWindow.down('#addRuleHiddenCombo').value) {
	                				   if(!isNullOrEmpty(json.examinationRevaluation) && !isNullOrEmpty(json.revaluationType) && 
	                						   !isNullOrEmpty(json.feePlanType) && !isNullOrEmpty(json.feePlanRule) && !isNullOrEmpty(json.noOfRevaluers) && 
	                						   !isNullOrEmpty(json.maxRevaluationToApply) && !isNullOrEmpty(json.ruleApplicable) && !isNullOrEmpty(json.feeAmount)){
	                				       Ext.Ajax.request({
		                					   type : 'rest',
		                					   url : submitUrl,
		                					   jsonData : json,
		                					   method : 'POST',
		                					   success : function(resp, action) {
		                						   $this.hideWindowMask();
		                					//	   showSuccessMessage(getExaminationTranslation('SUCCESS'),getCommonTranslation('SUCCESS'));
												   if (resp.responseText === "0") {
													   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('DUPLICACY_EXIST'));
												   } else if (resp.responseText === "Duplicacy") {
													   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('DUPLICACY_EXIST'));
												   } else {
													   showSuccessMessage(getExaminationTranslation('SUCCESS'), getCommonTranslation('SUCCESS'));
												   }
		                						   grid.getStore().reload();
		                						   grid.getSelectionModel().deselectAll();
		                						   formWindowRule.close();
		                					   }
		                				   });
	                				  }
	                				  else{
	                					   $this.hideWindowMask();
	                					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SELECTION_ALERT_MSG'));
	                					   
	                				   }
	                				 }
	                				else{
	                					  if(json.examinationRevaluation && json.revaluationType &&   json.noOfRevaluers && json.maxRevaluationToApply && json.ruleApplicable){
	   	                				   Ext.Ajax.request({
	   	                					   type : 'rest',
	   	                					   url : submitUrl,
	   	                					   jsonData : json,
	   	                					   method : 'POST',
	   	                					   success : function(resp, action) {
	   	                						   $this.hideWindowMask();
														   if (resp.responseText === "0") {
															   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('DUPLICACY_EXIST'));
														   } else if (resp.responseText === "Duplicacy") {
															   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('DUPLICACY_EXIST'));
														   } else {
															   showSuccessMessage(getExaminationTranslation('SUCCESS'), getCommonTranslation('SUCCESS'));
														   }
	   	                						   grid.getStore().reload();
	   	                						   grid.getSelectionModel().deselectAll();
	   	                						   formWindowRule.close();
	   	                					   }
	   	                				   });
	   	                				  }
	                					  else{
		                					   $this.hideWindowMask();
		                					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SELECTION_ALERT_MSG'));
		                					   
		                				   }
	                					  
	                				  }
	                			   }
	                		   },
	                		   'addrevaluationrulewin customcombobox[itemId=revaluationTypeEnum]':{
	                			   select:function(obj,rec){
	                				   var formWindow = this.getAddrevaluationrulewin();
	                				   var droolsItemId = formWindow.down('#droolsItemId');
	                				   droolsItemId.reset();
	                			   }
	                		   },
                                'addrevaluationwin radiogroup[itemId=revalFeeApplicableItemId]':{ 
	                			   change : function(cb, nv, ov){
	                    				var form=this.getAddrevaluationwin();
	                    				var revalApplicableForItemId=form.down('#revalApplicableForItemId');
	                    				revalApplicableForItemId.reset();
	                    				if (nv.isRevalFeeApplicable) {
	                    					revalApplicableForItemId.show();
	                    					
	                    				}else{
	                    					revalApplicableForItemId.hide();
	                    				}
	                    			}
	                		   },
	                		   'addrevaluationwin button[itemId=cancelButtonId]':{
	                			   click:function(obj,rec){
	                				   var $this = this;
	                				   var formWindow =obj.up('window');
	                				   formWindow.close();
	                			   }
	                		   },

	                		   'addrevaluationwin button[itemId=submitButtonId]':{
	                			   click:function(obj,rec){
	                				 var $this = this;
	                				  var formWindow =  $this.getAddrevaluationwin();
	                				  var submitbtn=  formWindow.down('#submitButtonId');
	                				  submitbtn.setDisabled(true);
	                				   var formSetupWindow =  $this.getAddrevaluationformwindow();
	                				   var json;
	                				   $this.applyWindowMask();
	                				   var grid =  $this.getRevaluationsetupgrid();
	                				   var submitUrl;
	                				   var isRevalFeeApplicable = formWindow.down('form').getForm().getValues().isRevalFeeApplicable;
	                				   if(grid.getMode() == 'save') {
	                					   submitUrl = SERVERURL.PATH_SAVE_REVALUATION;
	                					   if(isRevalFeeApplicable) {
	                						   json={  
	                						  
                							   "revaluationCode":formWindow.down('#revaluationCodeItemId').getValue(),
    	                					   "revaluationName":formWindow.down('#revaluationNameItemId').getValue(),
    	                							 
    	                					   "whetherRevalFeeApplicable":formWindow.down('form').getForm().getValues().isRevalFeeApplicable ? true:false,
    	                					   "revaluationFor":formWindow.down('form').getForm().getValues().isRevalApplicableFor? "COURSE_LEVEL":"EVENT_LEVEL",
    	                					   "maxRevaluationToApply":formWindow.down('#maxRevalToApplyItemId').getValue(),
    	                					    "validTill":formWindow.down('#validTillItemId').getValue()
    	                					 };
    	                					}
	                					   else{
	                					   json={
	                							   "revaluationCode":formWindow.down('#revaluationCodeItemId').getValue(),
	                							   "revaluationName":formWindow.down('#revaluationNameItemId').getValue(),
	                							   "revaluationFor":"COURSE_LEVEL",
	                							   "whetherRevalFeeApplicable":formWindow.down('form').getForm().getValues().isRevalFeeApplicable ?
	    	                									   true:false,
	                									   "maxRevaluationToApply":formWindow.down('#maxRevalToApplyItemId').getValue(),
	                									   "validTill":formWindow.down('#validTillItemId').getValue()
	                					   };
	                					   }
	                				   } else if(grid.getMode() == 'edit'){
	                					   submitUrl = SERVERURL.PATH_UPDATE_REVALUATION;
	                					   if(isRevalFeeApplicable) {
	                					   json={
	                							   "id":grid.getSelectionModel().getSelection()[0].data.id,
	                							   "revaluationCode":formWindow.down('#revaluationCodeItemId').getValue(),
	                							   "revaluationName":formWindow.down('#revaluationNameItemId').getValue(),
	                							   "revaluationFor":formWindow.down('form').getForm().getValues().isRevalApplicableFor?
	                									   "COURSE_LEVEL":"EVENT_LEVEL",
	                							   "whetherRevalFeeApplicable":formWindow.down('form').getForm().getValues().isRevalFeeApplicable ?
	    	                									   true :false,
	                									   "maxRevaluationToApply":formWindow.down('#maxRevalToApplyItemId').getValue(),
	                									   "validTill":formWindow.down('#validTillItemId').getValue()
	                					   };
	                					  }
	                					   else {
	                						   json={
		                							   "id":grid.getSelectionModel().getSelection()[0].data.id,
		                							   "revaluationCode":formWindow.down('#revaluationCodeItemId').getValue(),
		                							   "revaluationName":formWindow.down('#revaluationNameItemId').getValue(),
		                							   "whetherRevalFeeApplicable":formWindow.down('form').getForm().getValues().isRevalFeeApplicable ?
		    	                									   true :false,
		                									   "maxRevaluationToApply":formWindow.down('#maxRevalToApplyItemId').getValue(),
		                									   "validTill":formWindow.down('#validTillItemId').getValue(),
		                									   "revaluationFor":"COURSE_LEVEL",
		                					   };
	                					   }
	                				   }
									    //disable the button to prevent multiple clicks V2D-328747
	                				   Ext.Ajax.request({
	                					   type : 'rest',
	                					   url : submitUrl,
	                					   jsonData : json,
	                					   method : 'POST',
	                					   success : function(resp, action) {
	                						   $this.hideWindowMask();
	                						   showSuccessMessage(getExaminationTranslation('SUCCESS'),getCommonTranslation('SUCCESS'));
	                						   $this.getRevaluationsetupgrid().getStore().reload();
	                						   $this.getRevaluationsetupgrid().getSelectionModel().deselectAll();
	                						   formSetupWindow.close();
	                					   },
										   failure: function(form, action) {
											formSetupWindow.close();
		       		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('RECORD_IS_ALREADY_EXIST'));
		    	    	    	           }
	                				   });
	                			   }
	                		   }
	                	   });
	                   },

	                   loadEvaluationPlanByCriteria:function(){},
	                   deleteEvaluationPlan:function(grid){},


	                   openEvaluation:function(){
	                	   var contentpanel = this.getContentPanel();
	                	   var evaluationAddTab = Ext.widget('evaluationplan');
	                	   var tabName = getExaminationTranslation('ADD_EVALUATION_PLAN');
	                	   /**
	                	    * This is to remove tab from content panel and open same tab again 
	                	    */
	                	   var getcontroller=this.getController('menu.CoreERPNavigationController');
	                	   var getTab=getcontroller.getTab(tabName);
	                	   if(getTab!=null){
	                		   contentpanel.remove(getTab, true);
	                	   }
	                	   openTab(contentpanel, tabName, evaluationAddTab,CONSTANTS.MENU_COLOR_FOUR);

	                   },

	                   addMultipleProgramBatchForMapping: function (obj) {
	                	    var $this = this;
	                	    var stopContiner = $this.getProgrammappingstructure().down('#programBatchContainerId');
	                	    var from = $this.getProgrammappingstructure().getForm();
	                	    var panelItem = new Array();
	                	    var fieldContainer = obj.up('fieldcontainer');
	                	    var newcont = stopContiner.items.items.length;
	                	    var insertPosition = newcont + 1;
	                	    panelItem.push({
	                	        xtype: 'fieldcontainer',
	                	        width: '100%',
	                	        layout: 'hbox',
	                	        defaults: {
	                	            labelAlign: 'top'
	                	        },
	                	        items: [{
	                	            xtype: 'customcombobox',
	                	            name: 'PROGRAM_NAME',
	                	            itemId: 'program' + insertPosition,
	                	            valueField: 'id',
	                	            displayField: 'value',
	                	            minChars: 3,
	                	            width: 180,
	                	            queryParam: 'programName',
	                	            allowBlank: false,
	                	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	                	            listeners: {
	                	                render: function (combo) {
	                	                    var store = Ext.create('Academia.store.common.ProgramByAcAndLoIdStore');
	                	                    combo.bindStore(store);

	                	                    var academyLocationId = $this.getCurrentAcademyLocation();
	                	                    store.proxy.extraParams = {
	                	                        academyLocationId: academyLocationId
	                	                    };
	                	                    store.load();
	                	                },
	                	                select: function (obj, record) {
	                	                    var programId = record[0].get("id");
	                	                    var batch = obj.nextSibling();
	                	                    var period = batch.nextSibling();

	                	                    batch.setDisabled(false);
	                	                    batch.reset();

	                	                    period.setDisabled(true);
	                	                    period.reset();
	                	                    var store = batch.getStore();

	                	                    store.proxy.extraParams = {
	                	                        id: programId
	                	                    };
	                	                    store.load();
	                	                },
	                	                change: function (cmb) {
	                	                    if (isNullOrEmpty(cmb.getValue())) {
	                	                        cmb.getStore().load();
	                	                    }
	                	                }
	                	            },
	                	            listConfig: {
	                	                listeners: {
	                	                    beforeshow: function (picker) {
	                	                        picker.minWidth = picker.up('combobox').getSize().width;
	                	                    }
	                	                },
	                	                loadingText: getCommonTranslation('SEARCHING'),
	                	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                	                getInnerTpl: function () {
	                	                    return '<div class="search-item">' +
	                	                        '{value}' +
	                	                        '</div>';
	                	                }
	                	            }
	                	        }, {
	                	            xtype: 'customcombobox',
	                	            name: 'BATCH_NAME',
	                	            itemId: 'batch' + insertPosition,
	                	            disabled: true,
	                	            editable: false,
	                	            queryMode: 'local',
	                	            width: 180,
	                	            displayField: 'value',
	                	            valueField: 'id',
	                	            allowBlank: false,
	                	            listeners: {
	                	                render: function (combo) {
	                	                    var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
	                	                    combo.bindStore(store);
	                	                },
	                	                select: function (obj, record) {
	                	                    var batchId = record[0].get("id");
	                	                    var period = obj.nextSibling();
	                	                    var section = period.nextSibling();

	                	                    period.setDisabled(false);
	                	                    period.reset();

	                	                    var store = period.getStore();

	                	                    store.proxy.extraParams = {
	                	                        id: batchId
	                	                    };
	                	                    store.load();
	                	                }
	                	            }
	                	        }, {
	                	            xtype: 'customcombobox',
	                	            itemId: 'period' + insertPosition,
	                	            disabled: true,
	                	            editable: false,
	                	            displayField: 'value',
	                	            valueField: 'id',
	                	            width: 180,
	                	            queryMode: 'local',
	                	            allowBlank: false,
	                	            name: 'PERIOD_NAME',
	                	            listeners: {
	                	                render: function (combo) {
	                	                    var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
	                	                    combo.bindStore(store);
	                	                },
	                	                select: function (obj, record) {
	                	                        var fromdate = obj.nextSibling();
	                	                        fromdate.setDisabled(false);
	                	                    }
	                	                    /*var periodId = record[0].get("id");
	                						var  section = obj.nextSibling();

	                						section.setDisabled(false);
	                						section.reset();

	                						var store = section.getStore();

	                						store.proxy.extraParams = {
	                							periodId: periodId
	                						};
	                						store.load();*/
	                	            }
	                	        }, {
	                	            xtype: 'datefield',
	                	            name: 'fromdate',
	                	            allowBlank: false,
	                	            editable: false,
	                	            width: 180,
	                	            itemId: 'fromdate' + insertPosition,
	                	            //--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
	                	            //vtype: 'daterange',
	                	            disabled: true,
	                	            minValue: new Date(), //V2D-404152   
	                	            endDateField: 'tilldate' + insertPosition,
	                	            listeners: {
	                	                select: function (obj, record) {
	                	                    var tilldate = obj.nextSibling();
	                	                    tilldate.setDisabled(false);
	                	                },
	                	                render: function (field) {
	                	                    return dateFormatRender(field);
	                	                },
	                	                change: function (dateFld, newValue, oldValue) {
	                	                    dateFld.up().items.items[4].setMinValue(newValue)
	                	                }
	                	            }
	                	        }, {
	                	            xtype: 'datefield',
	                	            name: 'tilldate',
	                	            width: 180,
	                	            itemId: 'tilldate' + insertPosition,
	                	            allowBlank: false,
	                	            editable: false,
	                	            disabled: true,
	                	            // vtype: 'daterange',
	                	            startDateField: 'fromdate' + insertPosition,
	                	            endDateField: 'approvalEndDate' + insertPosition,
	                	            //--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
	                	            listeners: {
	                	                select: function (obj, record) {
	                	                    var approvalEndDate = obj.nextSibling();
	                	                    approvalEndDate.setDisabled(false);
	                	                },
	                	                render: function (field) {
	                	                    return dateFormatRender(field);
	                	                },
	                	                change: function (dateFld, newValue, oldValue) {
	                	                    dateFld.up().items.items[3].setMaxValue(newValue)
	                	                    dateFld.up().items.items[5].setMinValue(newValue);
	                	                }
	                	            }
	                	        }, {
	                	            xtype: 'datefield',
	                	            name: 'approvalEndDate',
	                	            width: 180,
	                	            itemId: 'approvalEndDate' + insertPosition,
	                	            allowBlank: false,
	                	            editable: false,
	                	            disabled: true,
	                	            // vtype: 'daterange',
	                	            startDateField: 'tilldate' + insertPosition,
	                	            //--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
	                	            listeners: {
	                	                render: function (field) {
	                	                    return dateFormatRender(field);
	                	                },
	                	                change: function (dateFld, newValue, oldValue) {
	                	                    dateFld.up().items.items[4].setMaxValue(newValue)
	                	                }
	                	            }
	                	        }, {
	                	            xtype: 'button',
	                	            itemId: 'delFilterBtn',
	                	            cls: 'CustomBodyBtnReject',
	                	            glyph: ICONGLYPH.DELETEGLYPH,
	                	            tooltip: getCommonTranslation('DELETE'),
	                	            listeners: {
	                	                click: function (obj) {
	                	                    var container = obj.up('fieldcontainer');
	                	                    var panelContiner = $this.getProgrammappingstructure().down('#programBatchContainerId');
	                	                    panelContiner.remove(container);
	                	                    panelContiner.doLayout();
	                	                    from.checkValidity();
	                	                }
	                	            }
	                	        }, {
	                	            xtype: 'button',
	                	            itemId: 'addFilterBtn',
	                	            cls: 'CustomBodyBtnSettings',
	                	            text: getCommonTranslation('ADDBUTTONTEXT'),
	                	            tooltip: getCommonTranslation('ADD')
	                	        }]
	                	    });
	                	    stopContiner.insert(insertPosition, panelItem);
	                	    stopContiner.doLayout();
	                	},

	                   getRuleJsonJson:function(){
	                	   var this$ = this;
	                	   var grid =  this$.getRevaluationrulegrid();
	                	   var record = grid.getSelectionModel().getSelection()[0];
	                	   var basicStudentSearchForm=this$.getProgrammappingstructure();
	                	   var pbpsContiner = basicStudentSearchForm.down('#programBatchContainerId');
	                	   var pbpsFieldsCount = pbpsContiner.items.length;
	                	   var pbpsArray=new Array();
	                	   var endJson=null;
	                	   var fieldSequence=1;
	                	   for(var j=0; j<pbpsContiner.items.length; j++){
	                		   var pbpsPanelContainer=pbpsContiner.items.items[j];
	                		   var period={
	                				   'id':pbpsPanelContainer.items.items[2].getValue()
	                		   };
	                		   var rule = {
	                				   'id':record.data.id
	                		   };
	                		   if(period.id==null)
	                			   {
	                			   break;
	                			   }
	                		   pbpsArray.push({
	                			   'period':period,
	                			   'examinationRevaluationRules':rule,
	                			   'startDate':pbpsPanelContainer.items.items[3].getValue(),
	                			   'endDate':pbpsPanelContainer.items.items[4].getValue(),
	                			   'approvalEndDate':pbpsPanelContainer.items.items[5].getValue(),
	                		   });
	                	   }
	                	   return pbpsArray;	
	                   },

	                   disableMoreActionGridPivileges: function(structure,permissionsMap) {
	                	   var associatedAcadLocationIds = new Array();
	                	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	                	   var portalId = this.getCurrentLoggedPortalId();
	                	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	                	   var btnManageRule = structure.down('#btnManageRule');
	                	   if(btnManageRule){
	                	   btnManageRule.setVisible(false);
	                	   }
	                	   Ext.each(permissionList, function(privilege) {
	                		   if (privilege === "MANAGERULE") {
	                			   if(!isNullOrEmpty(btnManageRule)){
	                				   btnManageRule.setVisible(true);
	                			   }        		
	                		   }
	                	   });
	                   },

});
