/*
 * @author Raghavendra.Soni
 */
Ext.define('Academia.controller.facilitiesresources.managegallery.ManageGalleryController', {
	extend: 'Academia.controller.base.BaseController',
	models: [],
	stores: [],  
	views: [
		'facilitiesresources.managegallery.ManageGalleryStructure',
		'facilitiesresources.managegallery.AlbumDetailsWin',
		'facilitiesresources.managegallery.FileUploadWin',
		'facilitiesresources.managegallery.ShareAlbumStructure',
		'facilitiesresources.managegallery.ShareAlbumGrid',
		'facilitiesresources.managegallery.MapAlbumStructure',
		'facilitiesresources.managegallery.MapAlbumGrid',
		'facilitiesresources.managegallery.ShareDetailsWin',
		'facilitiesresources.managegallery.ViewGalleryStructure',
		'facilitiesresources.managegallery.MyFolderFileGrid',
		'feeandpayment.adjustment.AdjustmentProgressTracker',
		'facilitiesresources.managegallery.MapFolderALProgramBatchSectionStructure',
		'facilitiesresources.managegallery.MapFolderAddALGrid',
		'facilitiesresources.managegallery.MapFolderAddProgramGrid',
		'facilitiesresources.managegallery.MapFolderAddProgramBatchGrid',
		'facilitiesresources.managegallery.MapFolderAddProgramBatchSectionGrid',
		'facilitiesresources.managegallery.TnsShareAlbumCourseSectionGrid',
		'facilitiesresources.managegallery.TnsCourseSectionMapAlbumStructure',
		'facilitiesresources.managegallery.MapFolderAcademicTermCourseSectionStructure',
		'facilitiesresources.managegallery.CourseSectionMapFolderAddATGrid',
		'facilitiesresources.managegallery.CourseSectionMapFolderAddCourseGrid',
		'facilitiesresources.managegallery.CourseSectionMapFolderAddCourseVariantGrid',
		'facilitiesresources.managegallery.ShareCBSDetailsWin','facilitiesresources.managegallery.HyperLinkEditWindow'
	],
	stores: [
		'facilitiesresources.managegallery.ManageGalleryStore',
		'facilitiesresources.managegallery.ShareAlbumStore',
		'facilitiesresources.managegallery.MapAlbumStore',
		'facilitiesresources.managegallery.FileUploadWindowDataviewStore',
		'user.UserAcademyLocationStore',
		'facilitiesresources.managegallery.MapFolderALProgramStore',
		'facilitiesresources.managegallery.MapFolderALProgramBatchStore',
		'facilitiesresources.managegallery.MapFolderALProgramBatchSectionStore',
		'user.UserAcademyTermsByALStore',
		'facilitiesresources.managegallery.MapFolderATCourseVariantStore'
	],
	refs: [{
		ref: 'contentPanel',
		selector: 'contentPanel'
	},{
		ref: 'managegallerystructure',
		selector: 'managegallerystructure'
	},{
		ref: 'albumdetailswin',
		selector: 'albumdetailswin'
	},{
		ref: 'fileuploadwin',
		selector: 'fileuploadwin'
	},{
		ref: 'sharealbumstructure',
		selector: 'sharealbumstructure'
	},{
		ref: 'sharealbumgrid',
		selector: 'sharealbumgrid'
	},{
		ref: 'mapalbumstructure',
		selector: 'mapalbumstructure'
	},{
		ref: 'mapalbumgrid',
		selector: 'mapalbumgrid'
	},{
		ref: 'sharedetailswin',
		selector: 'sharedetailswin'
	},{
		ref: 'viewgallerystructure',
		selector: 'viewgallerystructure'
	},{
		ref: 'myfolderfilegrid',
		selector: 'myfolderfilegrid'
	},{
    	ref:'adjustmentprogresstracker',
    	selector:'adjustmentprogresstracker'
    },{
    	ref:'mapfolderalprogrambatchsectionstructure',
    	selector:'mapfolderalprogrambatchsectionstructure'
    },{
    	ref:'mapfolderaddalgrid',
    	selector:'mapfolderaddalgrid'
    },{
    	ref:'mapfolderaddprogramgrid',
    	selector:'mapfolderaddprogramgrid'
    },{
    	ref:'mapfolderaddprogrambatchgrid',
    	selector:'mapfolderaddprogrambatchgrid'
    },{
    	ref:'mapfolderaddprogrambatchsectiongrid',
    	selector:'mapfolderaddprogrambatchsectiongrid'
    },{
    	ref:'tnssharealbumcoursesectiongrid',
    	selector:'tnssharealbumcoursesectiongrid'
    },{
    	ref:'tnscoursesectionmapalbumstructure',
    	selector:'tnscoursesectionmapalbumstructure'
    },{
    	ref:'mapfolderacademictermcoursesectionstructure',
    	selector:'mapfolderacademictermcoursesectionstructure'
    },{
    	ref:'coursesectionmapfolderaddatgrid',
    	selector:'coursesectionmapfolderaddatgrid'
    },{
    	ref:'coursesectionmapfolderaddcoursegrid',
    	selector:'coursesectionmapfolderaddcoursegrid'
    },{
    	ref:'coursesectionmapfolderaddcoursevariantgrid',
    	selector:'coursesectionmapfolderaddcoursevariantgrid'
    },{
    	ref:'sharecbsdetailswin',
    	selector:'sharecbsdetailswin'
    },{
    	ref:'hyperlinkeditwindow',
    	selector:'hyperlinkeditwindow'
    }],
	config: {
		CERP_MANAGE_GALLERY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CERP_MANAGE_GALLERY_PRIVILEGES'),
		FACULTY_GALLERY_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_GALLERY_PRIVILEGES'),
		STUDENT_GALLERY_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_GALLERY_PRIVILEGES'),
		PARENT_GALLERY_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_GALLERY_PRIVILEGES')
	},
	init: function(application) {
		this.albumMyFolderBtns;
		this.isUpdateHyperLinkCase;
		this.whetherListView=false;
		this.albumIdForSharedAlumni;
		this.control({
			'managegallerystructure': {
				afterrender:function(structure) {
					var me = this;
					me.setNoAlbumSelected(structure);
					me.loadAllAlbums(structure);
					me.loadSharedFolders(structure);
					//---
					var associatedAcadLocationIds = new Array();
           	    	associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
           	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
   	    					associatedAcadLocationIds, me.getCERP_MANAGE_GALLERY_PERMISSIONS());
           	    	
           	    	var newAlbumBtn = structure.down('#newAlbumBtn');
           	    	var btnAddImage = structure.down('#albumImagesPanelMenuView').down('#btnAddImage');
           	    	var btnDeleteImage = structure.down('#albumImagesPanelMenuView').down('#btnDeleteImage');
           	    	var btnEditImage = structure.down('#albumImagesPanelMenuView').down('#btnEditImage');
           	    	
           	    	newAlbumBtn.setVisible(false);
           	    	btnAddImage.setVisible(false);
           	    	btnDeleteImage.setVisible(false);
           	    	btnEditImage.setVisible(false);
           	    	
           	    	if((Ext.Array.contains(permissionList, 'ADD_FOLDER'))){
           	    		newAlbumBtn.setVisible(true);
	        		}
           	    	
           	    	if((Ext.Array.contains(permissionList, 'ADD_FILE'))){
           	    		btnAddImage.setVisible(true);
	        		}
           	    	
           	    	if((Ext.Array.contains(permissionList, 'DELETE_FILE'))){
           	    		btnDeleteImage.setVisible(true);
	        		}
           	    	
           	    	if((Ext.Array.contains(permissionList, 'EDIT_LINKS'))){
           	    		btnEditImage.setVisible(true);
	        		}
				}
			},
			'managegallerystructure button[cls=albumSideBtns]': {
				click:this.onAlbumBtnClick
			},
			'viewgallerystructure button[cls=albumSideBtns]': {
				click: this.onAlbumBtnClick2
			},
			'managegallerystructure button[itemId=newAlbumBtn]': {
				click:this.addNewAlbum
			},
			'albumdetailswin button[itemId=submitBtnWin]': {
				click: this.updateAlbum
			},
			'albumdetailswin button[itemId=cancelBtn]': {
				click: function(btn){
					btn.up('window').close();
				}
			},
			'managegallerystructure button[itemId=btnDeleteImage]': {
				click: this.deleteImages
			},
			'managegallerystructure button[itemId=btnAddImage]': {
				click: this.openGalleryImageUploadWin
			},
			'managegallerystructure button[itemId=btnEditImage]': {
				click: this.openGalleryLinkUploadWin
			},
			'viewgallerystructure button[itemId=btnEditImage]': {
				click: this.openGalleryLinkUploadWin
			},
			'managegallerystructure button[itemId=btnDriveListIcon]': {
				click: this.showFolderDriveList
			},
			'viewgallerystructure button[itemId=btnDriveListIcon]': {
				click: this.showFPFolderDriveList
			},
			'managegallerystructure button[itemId=btnDriveMenuIcon]': {
				click: this.onAlbumBtnClick
			},
			'viewgallerystructure button[itemId=btnDriveMenuIcon]': {
				click: this.onAlbumBtnClick2
			},
			'fileuploadwin[itemId=galleryWin] button[itemId=submitImageBtnWin]': {
				click: this.uploadGalleryImages
			},
			'fileuploadwin[itemId=galleryWin] button[itemId=cancelImageBtnWin]': {
				click: function(btn){
					btn.up('window').close();
				}
			},
			'viewgallerystructure button[itemId=newAddAlbumBtn]': {
				click:this.addNewAlbum
			},
			'sharealbumstructure': {
				afterrender: function(structure) {
					var me = this;
					var shareAlbumGridStore = me.getSharealbumgrid().getStore();
					shareAlbumGridStore.getProxy().extraParams = {
						galleryId : structure.albumId,
						academyLocationId:this.getCurrentAcademyLocation(),
						sort: null,
						isCBS:false
					};
					shareAlbumGridStore.load({
						callback: function(records){
							if(shareAlbumGridStore.pageSize>records.length){
								me.getSharealbumgrid().down('custompagingtoolbar').hide();
							}
							else{
								me.getSharealbumgrid().down('custompagingtoolbar').show();
							}
						}
					});
				}
			},
			'sharealbumgrid':{
				selectionchange: function( grid, selected, eOpts ){
					var me = this;
					if(selected.length==1){
						grid.view.up('grid').down('#btnView').setDisabled(false);
					}
					else{
						grid.view.up('grid').down('#btnView').setDisabled(true);
					}
				}
			},
			'sharealbumgrid button[itemId=btnAdd]': {
				click: this.openMapAlbumStructure
			},
			'sharealbumgrid button[itemId=btnView]': {
				click: this.openShareDetailWin
			},
			'sharealbumgrid button[itemId=btnDelete]': {
				click: this.deleteShareAlbumGridItems
			},
			'mapalbumstructure': {
				afterrender: function(structure) {/*
					var me = this;
					var albumName = structure.albumName;
					structure.down('#albumNameDisplayField').setValue(albumName);
					
					var mapAlbumGridStore = me.getMapalbumgrid().getStore();
					mapAlbumGridStore.getProxy().extraParams = {
						albumId : structure.albumId,
						academyLocationId:this.getCurrentAcademyLocation()
					};
					mapAlbumGridStore.clearFilter();
					structure.down('mapalbumgrid').down('#programNameTextId').reset();
					mapAlbumGridStore.load();
				*/}
			},
			/*'mapalbumstructure checkboxgroup[itemId=shareAlbumWithItemId]':{            	
            	change:function(checkbox, newValue, oldValue, eOpts ){
            		 var checkBoxArray=checkbox.getChecked();
            		 var programBatchGrid = this.getMapfolderaddprogrambatchgrid();
            		 var submitBatchMapping = programBatchGrid.down('#submitBatchMapping');
            		 var programBatchSectionGrid = this.getMapfolderaddprogrambatchsectiongrid();
            		 var submitMapping = programBatchSectionGrid.down('#submitMapping');
            		 
            		 if(checkBoxArray.length>0){
            			 submitBatchMapping.setDisabled(false);
            			 submitMapping.setDisabled(false);
            		 }
            		 else{
            			 submitBatchMapping.setDisabled(true);
            			 submitMapping.setDisabled(true);
            		 }
                }
            },*/
			/*'mapalbumgrid textfield[itemId=programNameTextId]':{
				keyup: function( me, e, eOpts ){
					var store = me.up('grid').getStore();
					store.clearFilter();
					store.filter({
						property: 'code',
						value: me.getValue(),
						anyMatch: true,
						caseSensitive: false
					});
				}
			},
			'mapalbumgrid button[itemId=btnSaveMapAlbum]':{
				click: this.saveShareDetails
			},
			'mapalbumgrid button[itemId=btnResetMapAlbum]':{
				click: function(btn){
					btn.up('grid').getSelectionModel().deselectAll();
					btn.up('grid').down('#programNameTextId').reset();
					btn.up('grid').getStore().clearFilter();
				}
			},*/
			'viewgallerystructure': {
				afterrender:function(structure) {
					var me = this;
					if(portalId==3 || portalId==7){
						
						me.setNoAlbumSelected(structure);
						me.loadFoldersPortal(structure);
						me.loadSharedFoldersPortal(structure);
						
						var myFolderSection = structure.down('#buttonContainer2');
						myFolderSection.setVisible(false);
						
						var buttonContainerShared = structure.down('#buttonContainerShared');
						buttonContainerShared.getEl().setStyle({marginTop:'0px'});
						buttonContainerShared.setTitle(getCommonTranslation('FOLDERS'));
						var btnAddImage = structure.down('#albumImagesPanelMenuView2').down('#btnAddImage');
	           	    	var btnDeleteImage = structure.down('#albumImagesPanelMenuView2').down('#btnDeleteImage');
	           	    	var btnEditImage = structure.down('#albumImagesPanelMenuView2').down('#btnEditImage');
	           	    	
	           	    	btnAddImage.setVisible(false);
	           	    	btnDeleteImage.setVisible(false);
	           	    	btnEditImage.setVisible(false);
					}
					else{
						me.setNoAlbumSelected(structure);
						me.loadFoldersPortal(structure);
						me.loadSharedFoldersPortal(structure);
						//---
						var associatedAcadLocationIds = new Array();
	           	    	associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
	           	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
	   	    					associatedAcadLocationIds, me.getFACULTY_GALLERY_PRIVILEGES());
	           	    	
	           	    	var newAlbumBtn = structure.down('#newAddAlbumBtn');
	           	    	var btnAddImage = structure.down('#albumImagesPanelMenuView2').down('#btnAddImage');
	           	    	var btnDeleteImage = structure.down('#albumImagesPanelMenuView2').down('#btnDeleteImage');
	           	    	var btnEditImage = structure.down('#albumImagesPanelMenuView2').down('#btnEditImage');
	           	    	
	           	    	newAlbumBtn.setVisible(false);
	           	    	btnAddImage.setVisible(false);
	           	    	btnDeleteImage.setVisible(false);
	           	    	btnEditImage.setVisible(false);
	           	    	
	           	    	if((Ext.Array.contains(permissionList, 'ADD_FOLDER'))){
	           	    		newAlbumBtn.setVisible(true);
		        		}
	           	    	
	           	    	if((Ext.Array.contains(permissionList, 'ADD_FILE'))){
	           	    		btnAddImage.setVisible(true);
		        		}
	           	    	
	           	    	if((Ext.Array.contains(permissionList, 'DELETE_FILE'))){
	           	    		btnDeleteImage.setVisible(true);
		        		}
	           	    	
	           	    	if((Ext.Array.contains(permissionList, 'EDIT_LINKS'))){
	           	    		btnEditImage.setVisible(true);
		        		}
					}
				}
			},
			'viewgallerystructure button[itemId=btnAddImage]': {
				click: this.openGalleryImageUploadWin
			},
			'viewgallerystructure button[itemId=btnDeleteImage]': {
				click: this.deleteImages
			},
			/*'viewgallerystructure button[cls=albumSideBtns]': {
				click:this.onAlbumBtnClickForView
			},*/
			'myfolderfilegrid':{
    			render: function(grid){
    				var $this = this;
    			},
    			cellclick:function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
					if (e.target.tagName == 'A') {
						var dataIndex = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
						var $this = this;
						if(dataIndex == 'imageName'){
							$this.openImageGridList(grid,record);
						}
					}
    			},
    			select:function(obj, record,rowIndex, e){
    				var $this = this;
    				var grid = $this.getMyfolderfilegrid();
    				var structure = $this.getManagegallerystructure();
    				if(portalId==1){
    					structure = $this.getManagegallerystructure();
    				}
    				else{
    					structure = $this.getViewgallerystructure();
    				}
    				
    				if(obj.selected.items.length>0){
    					structure.down('#btnDeleteImage').setDisabled(false);
    					if(obj.selected.items.length==1){
    						structure.down('#btnEditImage').setDisabled(false);
    					}
    				} else {
    					structure.down('#btnDeleteImage').setDisabled(true);
    					 structure.down('#btnEditImage').setDisabled(true);
    				}
    				
    				var whetherLinkSelected=0;
					var whetherImageSelected=0;
					for(var i=0;i<obj.selected.items.length;i++){
						if(obj.selected.items[i] && obj.selected.items[i].data.imageName=="link"){
							whetherLinkSelected++;
						}else{
							whetherImageSelected++;
						}
					}
					if(whetherLinkSelected==1 && whetherImageSelected<1){
						structure.down('#btnEditImage').setDisabled(false);
					}else{
						structure.down('#btnEditImage').setDisabled(true);
					}
    			},
    			deselect:function(obj, record, rowIndex, e){
    				var $this = this;
    				var grid = $this.getMyfolderfilegrid();
    				var structure = $this.getManagegallerystructure();
    				if(portalId==1){
    					structure = $this.getManagegallerystructure();
    				}
    				else{
    					structure = $this.getViewgallerystructure();
    				}
    				if(obj.selected.items.length>0){
    					structure.down('#btnDeleteImage').setDisabled(false);
    					if(obj.selected.items.length==1){
    						structure.down('#btnEditImage').setDisabled(false);
    					}
    				} else {
    					structure.down('#btnDeleteImage').setDisabled(true);
    					structure.down('#btnEditImage').setDisabled(true);
    				}
    				
    				var whetherLinkSelected=0;
					var whetherImageSelected=0;
					for(var i=0;i<obj.selected.items.length;i++){
						if(obj.selected.items[i] && obj.selected.items[i].data.imageName=="link"){
							whetherLinkSelected++;
						}else{
							whetherImageSelected++;
						}
					}
					if(whetherLinkSelected==1 && whetherImageSelected<1){
						structure.down('#btnEditImage').setDisabled(false);
					}else{
						structure.down('#btnEditImage').setDisabled(true);
					}
    			}
    		},
    		'mapfolderaddalgrid customcombobox#academylocationsearchcomboFolder' : {
    			select:function(obj, record){
    				var academylocationgrid = this.getMapfolderaddalgrid();
    				academylocationgrid.getStore().clearFilter();
    				if(!isNullOrEmpty(record)){
    					academylocationgrid.getStore().filter({property: 'id',
    						value: record[0].get('id'),
    						exactMatch: true,
    						caseSensitive: true});
    				}
    				
    				var gridDom = academylocationgrid.el ? academylocationgrid.el.dom : null;
	 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ 1;	
    			}
    		},
    		'mapfolderaddalgrid button#resetBtn':{
    			click:function(btn){
    				var $this = this
    				var activeGrid = this.getMapfolderaddalgrid();
    				var sharealbumgrid = $this.getSharealbumgrid();
    				activeGrid.getSelectionModel().deselectAll();
    				activeGrid.getStore().clearFilter();
    				if(activeGrid.down('#academylocationsearchcomboFolder')){
    					activeGrid.down('#academylocationsearchcomboFolder').reset();
    				}
    				var mapalbumstructure = this.getMapalbumstructure();
    				mapalbumstructure.down('#albumId').setValue(this.albumIdForSharedAlumni);
    				
    				var checkBoxes =$this.getMapalbumstructure().down('#shareAlbumWithItemId');
    				if(!isNullOrEmpty(sharealbumgrid.getStore().data.items[0].data)){
          				var rec = sharealbumgrid.getStore().data.items[0].data
          				var isSharedWithParent = rec.isSharedWithParent
              			var isSharedWithFaculty = rec.isSharedWithFaculty
              			var isSharedWithStudent = rec.isSharedWithStudent       			
              				if(isSharedWithParent == 'No' && isSharedWithFaculty == 'No' && isSharedWithStudent == 'No'){
              					checkBoxes.items.items[0].setReadOnly(true)
                				checkBoxes.items.items[0].setValue(false)
                				checkBoxes.items.items[1].setReadOnly(true)
                				checkBoxes.items.items[1].setValue(false)
                				checkBoxes.items.items[2].setReadOnly(true)
                				checkBoxes.items.items[2].setValue(false)
                				checkBoxes.items.items[3].setReadOnly(true)
                				checkBoxes.items.items[3].setValue(true)
              				}
    				}
    			}
    		},
    		'mapfolderaddalgrid button#nextButton':{
    			click:function(btn){
    				this.academyLocationNextEventProgramFolder(btn);
    			}
    		},

    		'mapfolderaddprogramgrid button#nextButton':{
    			click:function(btn){
    				this.programNextEventOnProgramFolder(btn);
    			}
    		},
    		'mapfolderaddprogramgrid button#resetBtn':{
    			click:function(btn){
    				var $this = this;
    				var activeGrid = this.getMapfolderaddprogramgrid();
    				var sharealbumgrid = $this.getSharealbumgrid();
    				activeGrid.getSelectionModel().deselectAll();
    				activeGrid.getStore().clearFilter();
    				if(activeGrid.down('#programsearchcombo')){
    					activeGrid.down('#programsearchcombo').reset();
    				}
    				var mapalbumstructure = this.getMapalbumstructure();
    				mapalbumstructure.down('#albumId').setValue(this.albumIdForSharedAlumni);
    				var checkBoxes =$this.getMapalbumstructure().down('#shareAlbumWithItemId');
    				if(!isNullOrEmpty(sharealbumgrid.getStore().data.items[0].data)){
          				var rec = sharealbumgrid.getStore().data.items[0].data
          				var isSharedWithParent = rec.isSharedWithParent
              			var isSharedWithFaculty = rec.isSharedWithFaculty
              			var isSharedWithStudent = rec.isSharedWithStudent       			
              				if(isSharedWithParent == 'No' && isSharedWithFaculty == 'No' && isSharedWithStudent == 'No'){
              					checkBoxes.items.items[0].setReadOnly(true)
                				checkBoxes.items.items[0].setValue(false)
                				checkBoxes.items.items[1].setReadOnly(true)
                				checkBoxes.items.items[1].setValue(false)
                				checkBoxes.items.items[2].setReadOnly(true)
                				checkBoxes.items.items[2].setValue(false)
                				checkBoxes.items.items[3].setReadOnly(true)
                				checkBoxes.items.items[3].setValue(true)
              				}
    				}
    			}
    		},
    		'mapfolderaddprogramgrid customcombobox#programsearchcombo' : {
    			select:function(obj, record){
    				var grid = this.getMapfolderaddprogramgrid();
    				grid.getStore().clearFilter();
    				grid.getStore().filter({property: 'programId',
    					value: record[0].get('programId'),
    					exactMatch: true,
    					caseSensitive: true});
    				
    				var gridDom = grid.el ? grid.el.dom : null;
	 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ 1;	
    			}
    		},
    		'mapfolderaddprogrambatchgrid button#nextButton':{
    			click:function(btn){
    				this.programNextEventOnProgramBatchTabFolder(btn);
    			}
    		},
    		'mapfolderaddprogrambatchgrid button#resetBtn':{
    			click:function(btn){
    				var $this = this;
    				var activeGrid = this.getMapfolderaddprogrambatchgrid();
    				var sharealbumgrid = $this.getSharealbumgrid();
    				activeGrid.getSelectionModel().deselectAll();
    				activeGrid.getStore().clearFilter();
    				if(activeGrid.down('#programbatchsearchcombo')){
    					activeGrid.down('#programbatchsearchcombo').reset();
    				}
    				var mapalbumstructure = this.getMapalbumstructure();
    				mapalbumstructure.down('#albumId').setValue(this.albumIdForSharedAlumni);
    				var checkBoxes =$this.getMapalbumstructure().down('#shareAlbumWithItemId');
    				if(!isNullOrEmpty(sharealbumgrid.getStore().data.items[0].data)){
          				var rec = sharealbumgrid.getStore().data.items[0].data
          				var isSharedWithParent = rec.isSharedWithParent
              			var isSharedWithFaculty = rec.isSharedWithFaculty
              			var isSharedWithStudent = rec.isSharedWithStudent       			
              				if(isSharedWithParent == 'No' && isSharedWithFaculty == 'No' && isSharedWithStudent == 'No'){
              					checkBoxes.items.items[0].setReadOnly(true)
                				checkBoxes.items.items[0].setValue(false)
                				checkBoxes.items.items[1].setReadOnly(true)
                				checkBoxes.items.items[1].setValue(false)
                				checkBoxes.items.items[2].setReadOnly(true)
                				checkBoxes.items.items[2].setValue(false)
                				checkBoxes.items.items[3].setReadOnly(true)
                				checkBoxes.items.items[3].setValue(true)
              				}
    				}
    			}
    		},
    		'mapfolderaddprogrambatchgrid button#submitBatchMapping':{
    			click:function(btn){
    				this.submitFolderMappingWithProgramBatch(btn);  // Common function used for Save Batch and Section grid mapping
    			}
    		},
    		'mapfolderaddprogrambatchgrid customcombobox#programbatchsearchcombo' : {
    			select:function(obj, record){
    				var grid = this.getMapfolderaddprogrambatchgrid();
    				grid.getStore().clearFilter();
    				grid.getStore().filter({property: 'batchId',
    					value: record[0].get('batchId'),
    					exactMatch: true,
    					caseSensitive: true});
    			}
    		},
    		'mapfolderaddprogrambatchsectiongrid button#resetBtn':{
    			click:function(btn){
    				var activeGrid = this.getMapfolderaddprogrambatchsectiongrid();
    				activeGrid.getSelectionModel().deselectAll();
    				activeGrid.getStore().clearFilter();
    				
    			}
    		},
    		'mapfolderaddprogrambatchsectiongrid button#submitMapping':{
    			click:function(btn){
    				this.submitFolderMappingWithProgramBatch(btn); // Common function used for Save AL, Program, Batch and Section grid mapping
    			} 
    		},
    		'mapfolderaddalgrid button#submitBtn':{
    			click:function(btn){
    				this.submitFolderMappingWithProgramBatch(btn); // Common function used for Save AL, Program,Batch and Section grid mapping
    			}
    		},
    		'mapfolderaddprogramgrid button#submitBtn':{
    			click:function(btn){
    				this.submitFolderMappingWithProgramBatch(btn); // Common function used for Save AL, Program, Batch and Section grid mapping
    			}
    		},
    		'sharealbumstructure radiogroup[itemId=albumCourseSectionTypeRadio]' :{
   			   change : function(cb) {
  				   this.changeAblSectionTypeRadioGroup(cb);
  			   }
  		   },
			'tnssharealbumcoursesectiongrid button[itemId=btnAdd]': {
				click: this.openCourseSectionMapAlbumStructure
			},
			'tnssharealbumcoursesectiongrid button[itemId=btnView]': {
				click: this.openCBSShareDetailWin
			},
    		'coursesectionmapfolderaddatgrid button#nextButton':{
    			click:function(btn){
    				this.academyTermsNextEventCourseFolder(btn);
    			}
    		},
    		'coursesectionmapfolderaddcoursegrid button#nextButton':{
    			click:function(btn){
    				this.CourseNextEventOnCourseVariantTabFolder(btn);
    			}
    		},
    		'coursesectionmapfolderaddcoursegrid button#submitBtn':{
    			click:function(btn){
    				this.submitFolderMappingWithCourseCode(btn);
    			}
    		},
    		'coursesectionmapfolderaddcoursevariantgrid button#submitMapping':{
    			click:function(btn){
    				this.submitFolderMappingWithCourseCode(btn);
    			}
    		},
    		'coursesectionmapfolderaddatgrid customcombobox#academyTermsearchcomboFolder' : {
    			select:function(obj, record){
    				var academytermgrid = this.getCoursesectionmapfolderaddatgrid();
    				academytermgrid.getStore().clearFilter();
    				if(!isNullOrEmpty(record)){
    					academytermgrid.getStore().filter({property: 'id',
    						value: record[0].get('id'),
    						exactMatch: true,
    						caseSensitive: true});
    				}
    			}
    		},
    		'coursesectionmapfolderaddatgrid button#resetBtn':{
    			click:function(btn){
    				var activeGrid = this.getCoursesectionmapfolderaddatgrid();
    				activeGrid.getSelectionModel().deselectAll();
    				activeGrid.getStore().clearFilter();
    				if(activeGrid.down('#academyTermsearchcomboFolder')){
    					activeGrid.down('#academyTermsearchcomboFolder').reset();
    				}
    			}
    		},
    		'coursesectionmapfolderaddcoursegrid customcombobox#coursesearchcombo' : {
    			select:function(obj, record){
    				var CourseCodegrid = this.getCoursesectionmapfolderaddcoursegrid();
    				CourseCodegrid.getStore().clearFilter();
    				if(!isNullOrEmpty(record)){
    					CourseCodegrid.getStore().filter({property: 'courseId',
    						value: record[0].get('courseId'),
    						exactMatch: true,
    						caseSensitive: true});
    				}
    			}
    		},
    		'coursesectionmapfolderaddcoursegrid button#resetBtn':{
    			click:function(btn){
    				var activeGrid = this.getCoursesectionmapfolderaddcoursegrid();
    				activeGrid.getSelectionModel().deselectAll();
    				activeGrid.getStore().clearFilter();
    				if(activeGrid.down('#coursesearchcombo')){
    					activeGrid.down('#coursesearchcombo').reset();
    				}
    			}
    		},
			'tnssharealbumcoursesectiongrid button[itemId=btnDelete]': {
				click: this.deleteCBSShareAlbumGridItems
			},
    		'coursesectionmapfolderaddcoursevariantgrid customcombobox#coursevariantsearchcombo' : {
    			select:function(obj, record){
    				var CourseVariantgrid = this.getCoursesectionmapfolderaddcoursevariantgrid();
    				CourseVariantgrid.getStore().clearFilter();
    				if(!isNullOrEmpty(record)){
    					CourseVariantgrid.getStore().filter({property: 'sectionId',
    						value: record[0].get('sectionId'),
    						exactMatch: true,
    						caseSensitive: true});
    				}
    			}
    		},
    		'coursesectionmapfolderaddcoursevariantgrid button#resetBtn':{
    			click:function(btn){
    				var activeGrid = this.getCoursesectionmapfolderaddcoursevariantgrid();
    				activeGrid.getSelectionModel().deselectAll();
    				activeGrid.getStore().clearFilter();
    				if(activeGrid.down('#coursevariantsearchcombo')){
    					activeGrid.down('#coursevariantsearchcombo').reset();
    				}
    			}
    		},
			'tnssharealbumcoursesectiongrid':{
				selectionchange: function( grid, selected, eOpts ){
					if(selected.length==1){
						grid.view.up('grid').down('#btnView').setDisabled(false);
					}
					else{
						grid.view.up('grid').down('#btnView').setDisabled(true);
					}
				}
			},'fileuploadwin  textfield[itemId=labelOfHyperlinkId]':{
        		change:function(btn){
        			var SubmitImageButton = btn.up('form').down('#submitImageBtnWin');
        			var labelOfHyperlinkId = btn.up('form').down('#labelOfHyperlinkId').getValue();
        			var galleryDataViewAddWin = btn.up('form').down('#galleryDataViewAddWin');
        			var addHyperlinkId = btn.up('form').down('#addHyperlinkId').getValue();
        			 if(isNullOrEmpty((labelOfHyperlinkId) && isNullOrEmpty(addHyperlinkId )) && galleryDataViewAddWin.all.elements.length==0) {
        				 
        				 	SubmitImageButton.setDisabled(true);
                        }
                      else
                    	{
                    	SubmitImageButton.setDisabled(false);
                    	}
        			
        	      
          	  }
          	},
          	'fileuploadwin  textfield[itemId=addHyperlinkId]':{
        		change:function(btn){
        			var SubmitImageButton = btn.up('form').down('#submitImageBtnWin');
        			var labelOfHyperlinkId = btn.up('form').down('#labelOfHyperlinkId').getValue();
        			var galleryDataViewAddWin = btn.up('form').down('#galleryDataViewAddWin');
        			var addHyperlinkId = btn.up('form').down('#addHyperlinkId').getValue();
        			 if(isNullOrEmpty((labelOfHyperlinkId) && isNullOrEmpty(addHyperlinkId )) && galleryDataViewAddWin.all.elements.length==0) {
        				 
        				 	SubmitImageButton.setDisabled(true);
                        }
                      else
                    	{
                    	SubmitImageButton.setDisabled(false);
                    	}
        			
        	      
          	  }
          	},
          	'hyperlinkeditwindow button[itemId=cancelWin]':{
          		click:function(){
          			var win = this.getHyperlinkeditwindow();
          			win.close();
          		}
          	},
          	'hyperlinkeditwindow button[itemId=submitHyperLinkWin]':{
          		click:function(){
          			var win = this.getHyperlinkeditwindow();
          			this.updateHyperLinkData(win);
          		}
          	},
          	'hyperlinkeditwindow  textfield[itemId=labelOfHyperlinkId]':{
          		change:function(btn){
          			var SubmitImageButton = btn.up('form').down('#submitHyperLinkWin');
          			var labelOfHyperlinkId = btn.up('form').down('#labelOfHyperlinkId').getValue();
          			var addHyperlinkId = btn.up('form').down('#addHyperlinkId').getValue();
          			if(isNullOrEmpty(labelOfHyperlinkId) || isNullOrEmpty(addHyperlinkId)) {
          				SubmitImageButton.setDisabled(true);
          			}else{
          				SubmitImageButton.setDisabled(false);
          			}
          		}
          	},
          	'hyperlinkeditwindow  textfield[itemId=addHyperlinkId]':{
          		change:function(btn){
          			var SubmitImageButton = btn.up('form').down('#submitHyperLinkWin');
          			var labelOfHyperlinkId = btn.up('form').down('#labelOfHyperlinkId').getValue();
          			var addHyperlinkId = btn.up('form').down('#addHyperlinkId').getValue();
          			if(isNullOrEmpty(labelOfHyperlinkId) || isNullOrEmpty(addHyperlinkId )) {
          				SubmitImageButton.setDisabled(true);
          			} else{
          				SubmitImageButton.setDisabled(false);
          			}
          		}
          	},
          	'mapalbumstructure':{
          		afterrender:function(structure){
    				var me = this;
    				var associatedAcadLocationIds = new Array();
           	    	associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
           	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
   	    					associatedAcadLocationIds, me.getCERP_MANAGE_GALLERY_PERMISSIONS());           	    	
           	    	var alumniCheckboxBtn = structure.down('#alumniRadioItemId');           	    	
           	    	alumniCheckboxBtn.setVisible(false);           	    	
           	    	if((Ext.Array.contains(permissionList, 'ALUMNI_CHECKBOX'))){
           	    		alumniCheckboxBtn.setVisible(true);
	        		}
           	    	var sharealbumgrid = this.getSharealbumgrid();
          			if(!isNullOrEmpty(sharealbumgrid.store.data.items[0] && sharealbumgrid.store.data.items[0].data)){
          				var rec = sharealbumgrid.store.data.items[0].data
          				var isSharedWithParent = rec.isSharedWithParent
              			var isSharedWithFaculty = rec.isSharedWithFaculty
              			var isSharedWithStudent = rec.isSharedWithStudent
              			var checkBoxLists = structure.items.items[0].items.items          			
              				if(isSharedWithParent == 'Yes' || isSharedWithFaculty == 'Yes' || isSharedWithStudent == 'Yes'){
              					checkBoxLists[0].setDisabled(false)
              					checkBoxLists[0].setValue(true)
              					checkBoxLists[1].setDisabled(false)
              					checkBoxLists[1].setValue(true)
              					checkBoxLists[2].setDisabled(false)
              					checkBoxLists[2].setValue(true)         					
              					checkBoxLists[3].setDisabled(true)
              					checkBoxLists[3].setValue(false)
              				}
              				else{
              					checkBoxLists[0].setDisabled(true)
              					checkBoxLists[0].setValue(false)
              					checkBoxLists[1].setDisabled(true)
              					checkBoxLists[1].setValue(false)
              					checkBoxLists[2].setDisabled(true) 
              					checkBoxLists[2].setValue(false)
              					checkBoxLists[3].setDisabled(false)
              					checkBoxLists[3].setValue(true)
              					checkBoxLists[3].setReadOnly(true)
              				}	
          			}
          		},
          	},
          	'mapalbumstructure checkboxgroup[itemId=shareAlbumWithItemId]': {
          		change: this.isAlumniSelected
	          	}
		});
	},
	isAlumniSelected:function(structure) { 
		var $this = this
		var checkBoxLists = structure.items.items
		var mapAlbumstructure = $this.getMapalbumstructure();
		var alGrid = $this.getMapfolderaddalgrid();
		var alProgramGrid = $this.getMapfolderaddprogramgrid();
		var alProgramBatchGrid = $this.getMapfolderaddprogrambatchgrid();
		var tabStructure =$this.getMapfolderalprogrambatchsectionstructure();
		var tabLength = tabStructure.items.items;
		var isAnyShareAlbumChecked = false
		
		Ext.each(checkBoxLists, function(item){		
			
			if(item.inputValue == 'alumni' && item.checked == true){			
				checkBoxLists[0].setDisabled(true)
				checkBoxLists[0].setValue(false)
				checkBoxLists[1].setDisabled(true)
				checkBoxLists[1].setValue(false)
				checkBoxLists[2].setDisabled(true)
				checkBoxLists[2].setValue(false)
				alGrid.down('#submitBtn').setDisabled(false)
				alProgramGrid.down('#submitBtn').setDisabled(false)
				alProgramBatchGrid.down('#nextButton').setDisabled(true)
				$this.resetProgressTracker();
				var adjustmentprogresstracker = $this.getMapalbumstructure().down("#adjustmentprogresstracker");
		  		var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
		  		progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
		  		progresstracker1.textEl.addCls("inProgressCss-progress-text");
		  		progresstracker1.updateText("Step 1 In Progress");
		  		tabStructure.setActiveTab(tabStructure.items.items[0])
		  		tabStructure.items.items[1].setDisabled(true)
		  		tabStructure.items.items[2].setDisabled(true)
		  		tabStructure.items.items[3].setDisabled(true)
		  		alGrid.getSelectionModel().deselectAll();
			}
			else{
				checkBoxLists[0].setDisabled(false)
				checkBoxLists[1].setDisabled(false)
				checkBoxLists[2].setDisabled(false)
				alGrid.down('#submitBtn').setDisabled(true)
				alProgramGrid.down('#submitBtn').setDisabled(true)
				alProgramBatchGrid.down('#nextButton').setDisabled(false)
				$this.resetProgressTracker();
				var adjustmentprogresstracker = $this.getMapalbumstructure().down("#adjustmentprogresstracker");
		  		var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
		  		progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
		  		progresstracker1.textEl.addCls("inProgressCss-progress-text");
		  		progresstracker1.updateText("Step 1 In Progress");
		  		tabStructure.setActiveTab(tabStructure.items.items[0])
		  		tabStructure.items.items[1].setDisabled(true)
		  		tabStructure.items.items[2].setDisabled(true)
		  		tabStructure.items.items[3].setDisabled(true)
//		  		alGrid.down('#resetBtn').setDisabled(true)
//		  		alProgramGrid.down('#resetBtn').setDisabled(true)
//		  		alProgramBatchGrid.down('#resetBtn').setDisabled(true)
		  		alGrid.getSelectionModel().deselectAll();
			}
			if(item.checked){			 
				isAnyShareAlbumChecked = true;				
		}
		})
		
		if(isAnyShareAlbumChecked){
			alGrid.down('#nextButton').setDisabled(false)
		}
		else{
			alGrid.down('#nextButton').setDisabled(true)
		}
		
	},
	setContextMenu: function(structure) {
		var me = this;
		if(portalId==1){
			//---
			var associatedAcadLocationIds = new Array();
   	    	associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
   	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
   					associatedAcadLocationIds, me.getCERP_MANAGE_GALLERY_PERMISSIONS());
   	    	
   	    	
   	    	var iconCls = [];
   	    	var myFoldersList = structure.down('#buttonContainer').query('[cls=albumSideBtns]');
   	    	
   	    	Ext.each(myFoldersList, function(albumBtn){

   	    		var contextMenuItems = [];

   	    		if((Ext.Array.contains(permissionList, 'SHARE_FOLDER'))){
   	    			contextMenuItems.push({
   	    				text: getCommonTranslation('SHARE_FOLDER'),
   	    				glyph: '109@Pictos',
   	    				albumId: albumBtn.albumId,
   	    				albumName: albumBtn.text,
   	    				btnItemId: albumBtn.itemId,
   	    				handler: function(btn){
   	    					me.openShareAlbum(btn);
   	    				}
   	    			});
   	    		}

   	    		if((Ext.Array.contains(permissionList, 'FOLDER_DETAILS'))){
   	    			contextMenuItems.push({
   	    				text: getCommonTranslation('EDIT_DETAILS'),
   	    				glyph: '76@Pictos',
   	    				albumId: albumBtn.albumId,
   	    				btnItemId: albumBtn.itemId,
   	    				handler: function(btn){
   	    					me.showAlbumDetails(btn,'Edit');
   	    				}
   	    			});
   	    		}

   	    		if((Ext.Array.contains(permissionList, 'DELETE_FOLDER'))){
   	    			contextMenuItems.push({
   	    				text: getCommonTranslation('DELETE_FOLDER'),
   	    				glyph: ICONGLYPH.DELETEGLYPH,
   	    				albumId: albumBtn.albumId,
   	    				btnItemId: albumBtn.itemId,
   	    				handler: function(btn){
   	    					me.deleteAlbum(btn);
   	    				}
   	    			});
   	    		}

   	    		if(contextMenuItems.length>0){
   	    			var contextMenu = new Ext.menu.Menu({
   	    				items: contextMenuItems,
   	    				cls: 'btn_contextmenu_cls'
   	    			});
   	    			albumBtn.getEl().on('contextmenu', function(e) {
   	    				e.preventDefault();
   	    				contextMenu.showAt([e.browserEvent.clientX,e.browserEvent.clientY]);
   	    			});
   	    		}
   	    	});
		}
		else{
			//---
			if(portalId==2){ //faculty portal
				var associatedAcadLocationIds = new Array();
	   	    	associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
	   	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
	   					associatedAcadLocationIds, me.getFACULTY_GALLERY_PRIVILEGES());
				
			}
			else if(portalId==3){ //student portal
				var associatedAcadLocationIds = new Array();
	   	    	associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
	   	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
	   					associatedAcadLocationIds, me.getSTUDENT_GALLERY_PRIVILEGES());
				
			}
			else if(portalId==7){ //parent portal
				var associatedAcadLocationIds = new Array();
	   	    	associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
	   	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
	   					associatedAcadLocationIds, me.getPARENT_GALLERY_PRIVILEGES());
			}
			if(portalId==2){
				var iconCls = [];
				var myFoldersList = structure.down('#buttonContainer2').query('[cls=albumSideBtns]');
	   	    	
				Ext.each(myFoldersList, function(albumBtn){
					
					var contextMenuItems = [];
					
					if((Ext.Array.contains(permissionList, 'SHARE_FOLDER'))){
						contextMenuItems.push({
	   	    				text: getCommonTranslation('SHARE_FOLDER'),
	   	    				glyph: '109@Pictos',
	   	    				albumId: albumBtn.albumId,
	   	    				albumName: albumBtn.text,
	   	    				btnItemId: albumBtn.itemId,
	   	    				handler: function(btn){
	   	    					me.openShareAlbum(btn);
	   	    				}
	   	    			});
					}
					if((Ext.Array.contains(permissionList, 'EDIT_DETAILS'))){
						contextMenuItems.push({
							text: getCommonTranslation('EDIT_DETAILS'),
							glyph: '76@Pictos',
							albumId: albumBtn.albumId,
							btnItemId: albumBtn.itemId,
							handler: function(btn){
								me.showAlbumDetails(btn,'Edit');
							}
						});
					}
					if((Ext.Array.contains(permissionList, 'DELETE_FOLDER'))){
						contextMenuItems.push({
	   	    				text: getCommonTranslation('DELETE_FOLDER'),
	   	    				glyph: ICONGLYPH.DELETEGLYPH,
	   	    				albumId: albumBtn.albumId,
	   	    				btnItemId: albumBtn.itemId,
	   	    				handler: function(btn){
	   	    					me.deleteAlbum(btn);
	   	    				}
	   	    			});
					}
					if(contextMenuItems.length>0){
					var contextMenu = new Ext.menu.Menu({
   	    				items: contextMenuItems
   	    			});
					albumBtn.getEl().on('contextmenu', function(e) {
						e.preventDefault();
						contextMenu.showAt([e.browserEvent.clientX,e.browserEvent.clientY]);
					});
					}
				});
			}else{
				if((Ext.Array.contains(permissionList, 'VIEW_ALBUM_DETAILS'))){
					var iconCls = [];
					Ext.each(Ext.ComponentQuery.query('[cls=albumSideBtns]'), function(albumBtn){
						var contextMenu = new Ext.menu.Menu({
							items: [{
								text: getCommonTranslation('FOLDER_DETAILS'),
								glyph: '76@Pictos',
								albumId: albumBtn.albumId,
								btnItemId: albumBtn.itemId,
								handler: function(btn){
									me.showAlbumDetails(btn,'View');
								}
							}]
						});
						albumBtn.getEl().on('contextmenu', function(e) {
							e.preventDefault();
							contextMenu.showAt([e.browserEvent.clientX,e.browserEvent.clientY]);
						});
					});
				}
			}
		}
	},
	setContextMenuForSharedFolder: function(structure) {
		var me = this;
		if(portalId==1){
			//---
			var associatedAcadLocationIds = new Array();
   	    	associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
   	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
   					associatedAcadLocationIds, me.getCERP_MANAGE_GALLERY_PERMISSIONS());
   	    	
   	    	
   	    	var iconCls = [];
   	    	
   	    	var sharedFolders = structure.down('#buttonContainerShared').query('[cls=albumSideBtns]');
   	    	
   	    	Ext.each(sharedFolders, function(albumBtn){

   	    		var contextMenuItems = [];

   	    		if((Ext.Array.contains(permissionList, 'FOLDER_DETAILS'))){
   	    			contextMenuItems.push({
   	    				text: getCommonTranslation('FOLDER_DETAILS'),
   	    				glyph: '76@Pictos',
   	    				albumId: albumBtn.albumId,
   	    				btnItemId: albumBtn.itemId,
   	    				handler: function(btn){
   	    					me.showAlbumDetails(btn,'View');
   	    				}
   	    			});
   	    		}

   	    		if(contextMenuItems.length>0){
   	    			var contextMenu = new Ext.menu.Menu({
   	    				items: contextMenuItems
   	    			});
   	    			albumBtn.getEl().on('contextmenu', function(e) {
   	    				e.preventDefault();
   	    				contextMenu.showAt([e.browserEvent.clientX,e.browserEvent.clientY]);
   	    			});
   	    		}
   	    	});
		}
		else{
			//---
			if(portalId==2){ //faculty portal
				var associatedAcadLocationIds = new Array();
	   	    	associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
	   	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
	   					associatedAcadLocationIds, me.getFACULTY_GALLERY_PRIVILEGES());
				
			}
			else if(portalId==3){ //student portal
				var associatedAcadLocationIds = new Array();
	   	    	associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
	   	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
	   					associatedAcadLocationIds, me.getSTUDENT_GALLERY_PRIVILEGES());
				
			}
			else if(portalId==7){ //parent portal
				var associatedAcadLocationIds = new Array();
	   	    	associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
	   	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
	   					associatedAcadLocationIds, me.getPARENT_GALLERY_PRIVILEGES());
			}
			
			var sharedFolders = structure.down('#buttonContainerShared').query('[cls=albumSideBtns]');
			
			if((Ext.Array.contains(permissionList, 'VIEW_ALBUM_DETAILS'))){
				var iconCls = [];
				Ext.each(sharedFolders, function(albumBtn){
					var contextMenu = new Ext.menu.Menu({
						items: [{
							text: getCommonTranslation('FOLDER_DETAILS'),
							glyph: '76@Pictos',
							albumId: albumBtn.albumId,
							btnItemId: albumBtn.itemId,
							handler: function(btn){
								me.showAlbumDetails(btn,'View');
							}
						}]
					});
					albumBtn.getEl().on('contextmenu', function(e) {
						e.preventDefault();
						contextMenu.showAt([e.browserEvent.clientX,e.browserEvent.clientY]);
					});
				});
			}
		}
	},
	setNoAlbumSelected: function(structure) {
		var me = this;
		if(portalId==1){
			structure.down('#albumImagesPanel').body.setHTML(getCommonTranslation('PLEASE_SELECT_FOLDER_MSG'));
			structure.down('#albumImagesPanel').body.addCls('text-middle-center');

			//-- hide button toolbar
			structure.down('#albumImagesPanelMenuView').down('toolbar').hide();
			structure.down('#buttonMainRightSideContainer').setTitle(getCommonTranslation('ACADEMIA_DRIVE'));
			structure.down('#albumImagesPanelMenuView').removeCls('albumImagesPanelMenuToolbarCls');
		}
		else{
			structure.down('#albumImagesPanel2').body.setHTML(getCommonTranslation('PLEASE_SELECT_FOLDER_MSG'));
			structure.down('#albumImagesPanel2').body.addCls('text-middle-center');
			
			if(portalId==2){
				//-- hide button toolbar
				structure.down('#albumImagesPanelMenuView2').down('toolbar').hide();
				structure.down('#buttonMainRightSideContainer2').setTitle(getCommonTranslation('ACADEMIA_DRIVE'));
				structure.down('#albumImagesPanelMenuView2').removeCls('albumImagesPanelMenuToolbarCls');
			}
			else if(portalId==3 || portalId==7){
				structure.down('#albumImagesPanelMenuView2').down('toolbar').hide();
				structure.down('#buttonMainRightSideContainer2').setTitle(getCommonTranslation('ACADEMIA_DRIVE'));
				structure.down('#albumImagesPanelMenuView2').removeCls('albumImagesPanelMenuToolbarCls');
			}
	  }
	},
	onAlbumBtnClick: function(btn) {
		var me = this;
		this.whetherListView=false;
		if(!me.isUpdateHyperLinkCase){
			me.albumMyFolderBtns=btn;
		}
		me.isUpdateHyperLinkCase=false;
		if(btn.itemId !=="btnDriveMenuIcon"){
			Ext.each(Ext.ComponentQuery.query('[cls=albumSideBtns]'), function(currentBtn){
				currentBtn.getEl().setStyle('box-shadow', '');
			});
			btn.getEl().setStyle('box-shadow', 'inset 0 0 10px #828482');
		}
		
		btn.up('managegallerystructure').down('#btnDriveMenuIcon').addCls('driveActiveMenuIcon');
		btn.up('managegallerystructure').down('#btnDriveListIcon').removeCls('driveActiveListIcon');
		btn.up('managegallerystructure').down('#btnDriveListIcon').addCls('driveListIcon');
		
		btn.up('managegallerystructure').down('#btnEditImage').setDisabled(true);
		btn.up('managegallerystructure').down('#btnDeleteImage').setDisabled(true);
		btn.up('managegallerystructure').down('#albumImagesPanel').removeAll();
		btn.up('managegallerystructure').down('#albumImagesPanel').body.setHTML('');
		//-rgv-btn.up('managegallerystructure').down('#albumImagesPanel').body.setHTML(getCommonTranslation('NO_IMAGE_ADDED'));
		btn.up('managegallerystructure').down('#albumImagesPanel').body.addCls('text-middle-center');

		//Ext.ComponentQuery.query('managegallerystructure')[0].down('#btnEditImage').config.albumId = btn.albumId;
		if(btn.itemId !=="btnDriveMenuIcon"){
			btn.up('managegallerystructure').down('#btnDriveMenuIcon').config.albumId = btn.albumId;
			btn.up('managegallerystructure').down('#btnDriveListIcon').config.albumId = btn.albumId;
			btn.up('managegallerystructure').down('#btnDriveMenuIcon').sharedBtn = btn.sharedBtn;
			Ext.ComponentQuery.query('managegallerystructure')[0].down('#btnEditImage').config.albumId = btn.albumId;
		}
		else{
			btn.up('managegallerystructure').down('#btnDriveMenuIcon').config.albumId = btn.config.albumId;
			btn.up('managegallerystructure').down('#btnDriveListIcon').config.albumId = btn.config.albumId;
			btn.up('managegallerystructure').down('#btnDriveMenuIcon').sharedBtn = btn.sharedBtn;
			Ext.ComponentQuery.query('managegallerystructure')[0].down('#btnEditImage').config.albumId = btn.config.albumId;
		}
		
		//-- show button toolbar
		btn.up('managegallerystructure').down('#albumImagesPanelMenuView').down('toolbar').show();
		btn.up('managegallerystructure').down('#albumImagesPanelMenuView').addCls('albumImagesPanelMenuToolbarCls');
		
		if(btn.itemId !=="btnDriveMenuIcon"){
			btn.up('managegallerystructure').down('#buttonMainRightSideContainer').setTitle(btn.text);	
		}
		
		//--permission on buttons
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
				associatedAcadLocationIds, me.getCERP_MANAGE_GALLERY_PERMISSIONS());

		var btnAddImage = btn.up('managegallerystructure').down('#albumImagesPanelMenuView').down('toolbar').down('#btnAddImage');
		var btnDeleteImage = btn.up('managegallerystructure').down('#albumImagesPanelMenuView').down('toolbar').down('#btnDeleteImage');
		var btnEditImage = btn.up('managegallerystructure').down('#albumImagesPanelMenuView').down('toolbar').down('#btnEditImage');

		btnAddImage.setVisible(false);
		btnDeleteImage.setVisible(false);
		btnEditImage.setVisible(false);

		if((Ext.Array.contains(permissionList, 'ADD_FILE'))){
			if(!btn.sharedBtn){
				btnAddImage.setVisible(true);
			}
		}

		if((Ext.Array.contains(permissionList, 'DELETE_FILE'))){
			if(!btn.sharedBtn){
				btnDeleteImage.setVisible(true);
			}
		}
		
		if((Ext.Array.contains(permissionList, 'EDIT_LINKS'))){
			if(!btn.sharedBtn){
				btnEditImage.setVisible(true);
			}
		}

		var albumId = btn.albumId;
		if(btn.itemId == "btnDriveMenuIcon"){
			albumId = btn.config.albumId;
		}
		var managGalleryStore = Ext.create('Academia.store.facilitiesresources.managegallery.ManageGalleryStore');
		managGalleryStore.getProxy().extraParams = {
			galleryId : albumId
		};
		managGalleryStore.removeAll();
		managGalleryStore.load({
			callback: function(records, operation, success){
				if(records.length>0){
					btn.up('managegallerystructure').down('#albumImagesPanel').removeAll();
					btn.up('managegallerystructure').down('#albumImagesPanel').body.setHTML('');
					btn.up('managegallerystructure').down('#albumImagesPanel').body.removeCls('text-middle-center');
					btn.up('managegallerystructure').down('#albumImagesPanel').doLayout();
				}
				
				
				var imageTpl = new Ext.XTemplate(
						'<tpl for=".">',
						 '<tpl if="fileType == &quot;png&quot; || imageName == &quot;link&quot; || fileType == &quot;jpg&quot; || fileType == &quot;jpeg&quot; || fileType == &quot;gif&quot;">',
						 '<div style="margin-bottom: 10px;" class="gallery-thumb-wrap" data-qtip="{labelOfHyperlink}">',
						 '<tpl else>',
						 '<div style="margin-bottom: 10px;" class="gallery-thumb-wrap" data-qtip="Double click to download file">',
						 '</tpl>',
						 '<tpl if="imageName == &quot;link&quot;">',
						 '<a href="{addHyperlink}" target="_blank"><img src="resources/images/driveToolImages/pin_url.png" /></a>',
						 '<br/><a href="{addHyperlink}" target="_blank"><span>{labelOfHyperlink}</span></a>',
						 '<div><input type="checkbox" value="{id}" name="imageId" id="{id}" onclick="changeDeleteBtnState();" /></div>',
						 '<tpl else>',
						 '<img src="{iconImage}" />',
						 '<br/><span>{imageName}</span>',
						 '<div><input type="checkbox" value="{id}" name="imageId" id="{id}" onclick="changeDeleteBtnState();" /></div>',
						 '</tpl>',
						 '</div>',
						 '</tpl>'

				);
				
				if(portalId==1 && btn.sharedBtn){
					imageTpl = new Ext.XTemplate(
							'<tpl for=".">',
							'<tpl if="fileType == &quot;png&quot; || fileType == &quot;jpg&quot; || fileType == &quot;jpeg&quot; || fileType == &quot;gif&quot;">',
							'<div style="margin-bottom: 10px;" class="gallery-thumb-wrap" data-qtip="{labelOfHyperlink}">',
							'<tpl else>',
							'<div style="margin-bottom: 10px;" class="gallery-thumb-wrap" data-qtip="Double click to download file">',
							'</tpl>',
							'<tpl if="imageName == &quot;link&quot;">',
							 '<a href="{addHyperlink}" target="_blank"><img src="resources/images/driveToolImages/pin_url.png" /></a>',
							'<br/><a href="{addHyperlink}" target="_blank"><span>{labelOfHyperlink}</span></a>',
							'<div><input type="checkbox" value="{id}" name="imageId" onclick="changeDeleteBtnState();" /></div>',
							'<tpl else>',
							'<img src="{iconImage}" />',
							'<br/><span>{imageName}</span>',
							 '</tpl>',
							'</div>',
							'</tpl>'
					);
				}
				
				/*var imageTpl = new Ext.XTemplate(
						'<tpl for=".">',
						'<div style="margin-bottom: 10px;" class="gallery-thumb-wrap">',
						'<img src="resources/images/uploads{iconImage}" />',
						'<br/><span>Image {#}</span>',
						'<div><input type="checkbox" value="{id}" name="imageId" onclick="changeDeleteBtnState();" /></div>',
						'</div>',
						'</tpl>'
				);*/
				
				
				
				Ext.each(Ext.ComponentQuery.query('#galleryDataView'), function(currentGalleryDataView){
					currentGalleryDataView.destroy();
				});
				Ext.each(Ext.ComponentQuery.query('myfolderfilegrid'), function(myFolderFileGrid){
					myFolderFileGrid.destroy();
				});
				Ext.create('Ext.view.View', {
				    store: managGalleryStore,
				    tpl: imageTpl,
				    itemSelector: 'div.gallery-thumb-wrap',
				    emptyText: getCommonTranslation('NO_FILES_ADDED_YET_MSG'),
				    renderTo: btn.up('managegallerystructure').down('#albumImagesPanel').body,
					itemId: 'galleryDataView',
					height: '90%',
					deferEmptyText: false,
					style: {
			            marginTop: '15px'
			        },
					listeners: {
						itemclick: function( dataview, record, item, index, e, eOpts ){
							if(!isNullOrEmpty(record.data.fileType)){
								var extension = record.data.fileType.toLowerCase();
								if(extension == "png" || extension == "jpeg" || extension == "gif" || extension == "jpg"){
									me.openImage(dataview, record, item, index, e, eOpts);
								}
							}
						},
						itemdblclick: function(dataview, record, item, index, e, eOpts ){
							var extension = record.data.fileType.toLowerCase();
							if(extension == "pdf" || extension == "doc" || extension == "docx" || extension == "xls" 
								|| extension == "xlsx" || extension == "ppt" || extension == "pptx" 
									|| extension == "txt" || extension == "odt" || extension == "zip"){
								me.downloadDocumentFile(record.data.id);
							}
						}
					}
				});
			}
		});
	},
	onAlbumBtnClick2: function(btn) {
		var me = this;
		this.whetherListView=false;
		if(!me.isUpdateHyperLinkCase){
			me.albumMyFolderBtns=btn;
		}
		me.isUpdateHyperLinkCase=false;
		if(btn.itemId !=="btnDriveMenuIcon"){
			Ext.each(Ext.ComponentQuery.query('[cls=albumSideBtns]'), function(currentBtn){
				currentBtn.getEl().setStyle('box-shadow', '');
			});
			btn.getEl().setStyle('box-shadow', 'inset 0 0 10px #828482');
		}
		
		btn.up('viewgallerystructure').down('#btnDriveMenuIcon').addCls('driveActiveMenuIcon');
		btn.up('viewgallerystructure').down('#btnDriveListIcon').removeCls('driveActiveListIcon');
		btn.up('viewgallerystructure').down('#btnDriveListIcon').addCls('driveListIcon');
		
		btn.up('viewgallerystructure').down('#btnDeleteImage').setDisabled(true);
		btn.up('viewgallerystructure').down('#btnEditImage').setDisabled(true);
		btn.up('viewgallerystructure').down('#albumImagesPanel2').removeAll();
		btn.up('viewgallerystructure').down('#albumImagesPanel2').body.setHTML('');
		//-rgv-btn.up('managegallerystructure').down('#albumImagesPanel').body.setHTML(getCommonTranslation('NO_IMAGE_ADDED'));
		btn.up('viewgallerystructure').down('#albumImagesPanel2').body.addCls('text-middle-center');
		btn.up('viewgallerystructure').down('#btnDriveMenuIcon').sharedBtn = btn.sharedBtn;
		if(btn.itemId !=="btnDriveMenuIcon"){
			btn.up('viewgallerystructure').down('#btnDriveMenuIcon').config.albumId = btn.albumId;
			btn.up('viewgallerystructure').down('#btnDriveListIcon').config.albumId = btn.albumId;
			Ext.ComponentQuery.query('viewgallerystructure')[0].down('#btnEditImage').config.albumId = btn.albumId;
		}
		else{
			btn.up('viewgallerystructure').down('#btnDriveMenuIcon').config.albumId = btn.config.albumId;
			btn.up('viewgallerystructure').down('#btnDriveListIcon').config.albumId = btn.config.albumId;
			Ext.ComponentQuery.query('viewgallerystructure')[0].down('#btnEditImage').config.albumId = btn.config.albumId;
		}
		
		//-- show button toolbar
		btn.up('viewgallerystructure').down('#albumImagesPanelMenuView2').down('toolbar').show();
		btn.up('viewgallerystructure').down('#albumImagesPanelMenuView2').addCls('albumImagesPanelMenuToolbarCls');
		
		if(btn.itemId !=="btnDriveMenuIcon"){
			btn.up('viewgallerystructure').down('#buttonMainRightSideContainer2').setTitle(btn.text);	
		}
		
		//--permission on buttons
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
				associatedAcadLocationIds, me.getFACULTY_GALLERY_PRIVILEGES());

		var btnAddImage = btn.up('viewgallerystructure').down('#albumImagesPanelMenuView2').down('toolbar').down('#btnAddImage');
		var btnDeleteImage = btn.up('viewgallerystructure').down('#albumImagesPanelMenuView2').down('toolbar').down('#btnDeleteImage');
		var btnEditImage = btn.up('viewgallerystructure').down('#albumImagesPanelMenuView2').down('toolbar').down('#btnEditImage');

		btnAddImage.setVisible(false);
		btnDeleteImage.setVisible(false);
		btnEditImage.setVisible(false);

		if((Ext.Array.contains(permissionList, 'ADD_FILE'))){
			if(!btn.sharedBtn){
				btnAddImage.setVisible(true);
			}
		}

		if((Ext.Array.contains(permissionList, 'DELETE_FILE'))){
			if(!btn.sharedBtn){
				btnDeleteImage.setVisible(true);
			}
		}
		
		if((Ext.Array.contains(permissionList, 'EDIT_LINKS'))){
			if(!btn.sharedBtn){
				btnEditImage.setVisible(true);
			}
		}

		var albumId = btn.albumId;
		if(btn.itemId == "btnDriveMenuIcon"){
			albumId = btn.config.albumId;
		}
		//Ext.ComponentQuery.query('viewgallerystructure')[0].down('#btnEditImage').config.albumId = btn.albumId;
		var managGalleryStore = Ext.create('Academia.store.facilitiesresources.managegallery.ManageGalleryStore');
		managGalleryStore.getProxy().extraParams = {
			galleryId : albumId
		};
		managGalleryStore.removeAll();
		managGalleryStore.load({
			callback: function(records, operation, success){
				if(records.length>0){
					btn.up('viewgallerystructure').down('#albumImagesPanel2').removeAll();
					btn.up('viewgallerystructure').down('#albumImagesPanel2').body.setHTML('');
					btn.up('viewgallerystructure').down('#albumImagesPanel2').body.removeCls('text-middle-center');
					btn.up('viewgallerystructure').down('#albumImagesPanel2').doLayout();
				}
				
				var imageTpl = new Ext.XTemplate(
						 '<tpl for=".">',
						 '<tpl if="fileType == &quot;png&quot; || imageName == &quot;link&quot; || fileType == &quot;jpg&quot; || fileType == &quot;jpeg&quot; || fileType == &quot;gif&quot;">',
						 '<div style="margin-bottom: 10px;" class="gallery-thumb-wrap" data-qtip="{labelOfHyperlink}">',
						 '<tpl else>',
						 '<div style="margin-bottom: 10px;" class="gallery-thumb-wrap" data-qtip="Double click to download file">',
						 '</tpl>',
						 '<tpl if="imageName == &quot;link&quot;">',
						 '<a href="{addHyperlink}" target="_blank"><img src="resources/images/driveToolImages/pin_url.png" /></a>',
						 '<br/><a href="{addHyperlink}" target="_blank"><span>{labelOfHyperlink}</span></a>',
						 '<div><input type="checkbox" value="{id}" name="imageId" id="{id}" onclick="changeDeleteBtnState();" /></div>',
						 '<tpl else>',
						 '<img src="{iconImage}" />',
						 '<br/><span>{imageName}</span>',
						 '<div><input type="checkbox" value="{id}" name="imageId" id="{id}" onclick="changeDeleteBtnState();" /></div>',
						 '</tpl>',
						 '</div>',
						 '</tpl>'
				);
				
				if(portalId==3 || portalId==7){
					imageTpl = new Ext.XTemplate(
							'<tpl for=".">',
							 '<tpl if="fileType == &quot;png&quot; || imageName == &quot;link&quot; || fileType == &quot;jpg&quot; || fileType == &quot;jpeg&quot; || fileType == &quot;gif&quot;">',
							 '<div style="margin-bottom: 10px;" class="gallery-thumb-wrap" data-qtip="{labelOfHyperlink}">',
							 '<tpl else>',
							 '<div style="margin-bottom: 10px;" class="gallery-thumb-wrap" data-qtip="Double click to download file">',
							 '</tpl>',
							 '<tpl if="imageName == &quot;link&quot;">',
							 '<a href="{addHyperlink}" target="_blank"><img src="resources/images/driveToolImages/pin_url.png" /></a>',
							 '<br/><a href="{addHyperlink}" target="_blank"><span>{labelOfHyperlink}</span></a>',
							 '<tpl else>',
							 '<img src="{iconImage}" />',
							 '<br/><span>{imageName}</span>',
							 '</tpl>',
							 '</div>',
							 '</tpl>'
					);
				}
				
				if(portalId==2 && btn.sharedBtn){
					imageTpl = new Ext.XTemplate(
							'<tpl for=".">',
							 '<tpl if="fileType == &quot;png&quot; || imageName == &quot;link&quot; || fileType == &quot;jpg&quot; || fileType == &quot;jpeg&quot; || fileType == &quot;gif&quot;">',
							 '<div style="margin-bottom: 10px;" class="gallery-thumb-wrap" data-qtip="{labelOfHyperlink}">',
							 '<tpl else>',
							 '<div style="margin-bottom: 10px;" class="gallery-thumb-wrap" data-qtip="Double click to download file">',
							 '</tpl>',
							 '<tpl if="imageName == &quot;link&quot;">',
							 '<a href="{addHyperlink}" target="_blank"><img src="resources/images/driveToolImages/pin_url.png" /></a>',
							 '<br/><a href="{addHyperlink}" target="_blank"><span>{labelOfHyperlink}</span></a>',
							 '<tpl else>',
							 '<img src="{iconImage}" />',
							 '<br/><span>{imageName}</span>',
							 '</tpl>',
							 '</div>',
							 '</tpl>'
					);
				}
				
				
				
				/*var imageTpl = new Ext.XTemplate(
						'<tpl for=".">',
						'<div style="margin-bottom: 10px;" class="gallery-thumb-wrap">',
						'<img src="resources/images/uploads{iconImage}" />',
						'<br/><span>Image {#}</span>',
						'<div><input type="checkbox" value="{id}" name="imageId" onclick="changeDeleteBtnState();" /></div>',
						'</div>',
						'</tpl>'
				);*/
				
				
				
				Ext.each(Ext.ComponentQuery.query('#galleryDataView'), function(currentGalleryDataView){
					currentGalleryDataView.destroy();
				});
				Ext.each(Ext.ComponentQuery.query('myfolderfilegrid'), function(myFolderFileGrid){
					myFolderFileGrid.destroy();
				});
				Ext.create('Ext.view.View', {
				    store: managGalleryStore,
				    tpl: imageTpl,
				    itemSelector: 'div.gallery-thumb-wrap',
				    emptyText: getCommonTranslation('NO_FILES_ADDED_YET_MSG'),
				    renderTo: btn.up('viewgallerystructure').down('#albumImagesPanel2').body,
					itemId: 'galleryDataView',
					height: '90%',
					deferEmptyText: false,
					style: {
			            marginTop: '15px'
			        },
					listeners: {
						itemclick: function( dataview, record, item, index, e, eOpts ){
							if(!isNullOrEmpty(record.data.fileType)){
								var extension = record.data.fileType.toLowerCase();
								if(extension == "png" || extension == "jpeg" || extension == "gif" || extension == "jpg"){
									me.openImage(dataview, record, item, index, e, eOpts);
								}
							}
						},
						itemdblclick: function(dataview, record, item, index, e, eOpts ){
							var extension = record.data.fileType.toLowerCase();
							if(extension == "pdf" || extension == "doc" || extension == "docx" || extension == "xls" 
								|| extension == "xlsx" || extension == "ppt" || extension == "pptx" 
									|| extension == "txt" || extension == "odt" || extension == "zip"){
								me.downloadDocumentFile(record.data.id);
							}
						}
					}
				});
			}
		});
	},
	loadAllAlbums: function(structure) {
		var me = this;
		structure.down('#buttonContainer').body.mask('Loading...');
		//-- get album API here
		Ext.Ajax.request({
			method : "GET",
			type : 'rest',
			url : SERVERURL.PATH_GET_ALL_GALLERY,
			params: {
				academyLocationId:this.getCurrentAcademyLocation()
			},
			success : function(f, action) {
				var resp = Ext.decode(f.responseText);
				var albums = resp.rows;

				var i = 1;
				Ext.each(albums, function(currentAlbum){
					var newAlbumBtn = {
							xtype: 'button',
							text: currentAlbum.albumName,
							itemId: 'Album_'+currentAlbum.id+'_Btn',
							tooltip: currentAlbum.albumName,
							iconCls: 'folderOpenIcon',
							cls: 'albumSideBtns',
							sharedBtn:false,
							albumId: currentAlbum.id
					};
					structure.down('#buttonContainer').add(newAlbumBtn);
					i=i+1;
				});
				structure.down('#buttonContainer').body.unmask();
				me.setContextMenu(structure);
			}
		});
	},
	loadSharedFolders: function(structure) {
		var me = this;
		structure.down('#buttonContainerShared').body.mask('Loading...');
		//-- get album API here
		Ext.Ajax.request({
			method : "GET",
			type : 'rest',
			url : SERVERURL.PATH_FIND_SHARED_GALLERY,
			params: {
				academyLocationId:this.getCurrentAcademyLocation()
			},
			success : function(f, action) {
				var resp = Ext.decode(f.responseText);
				var albums = resp.rows;

				var i = 1;
				Ext.each(albums, function(currentAlbum){
					var newAlbumBtn = {
							xtype: 'button',
							text: currentAlbum.albumName,
							itemId: 'Album_'+currentAlbum.id+'_Btn',
							tooltip: currentAlbum.albumName,
							iconCls: 'folderOpenIcon',
							cls: 'albumSideBtns',
							sharedBtn:true,
							albumId: currentAlbum.id
					};
					structure.down('#buttonContainerShared').add(newAlbumBtn);
					i=i+1;
				});
				structure.down('#buttonContainerShared').body.unmask();
				me.setContextMenuForSharedFolder(structure);
			}
		});
	},
	addNewAlbum: function(btn) {
		var me = this;
		
		var formWindow = me.getAlbumdetailswin();
		if (!formWindow) {
			Ext.widget('albumdetailswin');
			formWindow = me.getAlbumdetailswin();
		}
		formWindow.setTitle(getCommonTranslation('ADD_FOLDER'));
		formWindow.show();
		
		
		/*var oldAlbumBtns = Ext.ComponentQuery.query('[cls=albumSideBtns]');
		var newNumber = (oldAlbumBtns.length+1);

		//-- save album API here
		Ext.Ajax.request({
			method : "POST",
			type : 'rest',
			url : SERVERURL.PATH_SAVE_UPDATE_GALLERY,
			jsonData : {
				albumName : 'Album '+newNumber,
				createdBy: this.getCurrentlyLoggedInUser().id,
				academyLocationId:this.getCurrentAcademyLocation()
			},
			success : function(f, action) {

				var newAlbumBtn = {
						xtype: 'button',
						text: 'Album '+newNumber,
						itemId: 'Album_'+f.responseText+'_Btn',
						iconCls: 'folderOpenIcon',
						tooltip: 'Album '+newNumber,
						cls: 'albumSideBtns',
						albumId: f.responseText
				};

				btn.up('#buttonContainer').add(newAlbumBtn);
				me.setContextMenu();
			}
		});*/
	},
	
	/*Delete My Folder section items*/
	deleteAlbum: function(button){
		var me = this;
		var structure;

		if(portalId==1){
			structure = me.getManagegallerystructure();
		}
		else{
			structure = me.getViewgallerystructure();
		}
		showConfirmMessage(getCommonTranslation('ACADEMIA_DRIVE'), getCommonTranslation('DELETE_FOLDER_MSG'), function(btn, text) {
			if (btn == 'yes') {
				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				Ext.Ajax.request({
					type: 'rest',
					url: SERVERURL.PATH_DELETE_GALLERY+'?id='+button.albumId,
					method: 'DELETE',
					headers: {
						'Content-Type': 'application/json'
					},
					success: function(form, action) {
						Ext.getBody().unmask();
						var albumBtn = structure.down('#'+button.btnItemId);
						
						//---
						try{
							var storeAlbumId = Ext.ComponentQuery.query('#galleryDataView')[0].getStore().getProxy().extraParams.galleryId;
							var albumBtnAlbumId = albumBtn.albumId;
							
							if(albumBtnAlbumId==storeAlbumId){
								me.setNoAlbumSelected(structure);
							}
						}
						catch(e){
							
						}
						if(portalId==1){
							structure.down('#buttonContainer').remove(albumBtn);
							structure.down('#buttonContainer').doLayout();
						}
						else{
							structure.down('#buttonContainer2').remove(albumBtn);
							structure.down('#buttonContainer2').doLayout();
						}
						showSuccessMessage(getAlumni('SHARE_FOLDER'),getAlumni('FOLDER_HAS_BEEN_DELETED_SUCCESSFULLY_MSG'))
					}
				});
			}
		});
	},
	showAlbumDetails: function(button,isView){
		var me =this;
		var albumId = button.albumId;

		Ext.Ajax.request({
			method : "GET",
			type : 'rest',
			url :  SERVERURL.PATH_GALLERY_BY_ID,
			params: {
				id: albumId
			},
			success : function(f, action) {
				var resp = Ext.decode(f.responseText);
				var formWindow = me.getAlbumdetailswin();
				if (!formWindow) {
					Ext.widget('albumdetailswin');
					formWindow = me.getAlbumdetailswin();
				}
				if(isView == 'Edit'){
					formWindow.setTitle(getCommonTranslation('EDIT_FOLDER_DETAILS'));	
				}
				else{
					formWindow.setTitle(getCommonTranslation('FOLDER_DETAILS'));	
				}
				
				formWindow.show();

				formWindow.down('#id').setValue(resp.id);
				formWindow.down('#albumName').setValue(resp.albumName);
				formWindow.down('#description').setValue(resp.description);
				if(!isNullOrEmpty(resp.wsNameValue)){
					var createdBy = resp.wsNameValue[0].code + "/"+resp.wsNameValue[0].value;
					formWindow.down('#createdBy').setValue(createdBy);
					formWindow.down('#createdBy').setVisible(true);
				}
				
				if(portalId!=1){
					formWindow.down('#albumName').setReadOnly(true);
					formWindow.down('#description').setReadOnly(true);
					formWindow.down('#submitBtnWin').hide();
					
					if(portalId==2){
						var associatedAcadLocationIds = new Array();
			   	    	associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
			   	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
			   					associatedAcadLocationIds, me.getFACULTY_GALLERY_PRIVILEGES());
			   	    	
			   	    	if((Ext.Array.contains(permissionList, 'EDIT_DETAILS'))){
			   	    		if(isView == 'Edit'){
			   	    			formWindow.down('#submitBtnWin').show();	
			   	    			formWindow.down('#albumName').setReadOnly(false);
								formWindow.down('#description').setReadOnly(false);
			   	    		}
			    		}
					}
				}
				else{
					formWindow.down('#submitBtnWin').hide();
					if(isView == "View"){
						formWindow.down('#albumName').setReadOnly(true);
						formWindow.down('#description').setReadOnly(true);
					}
					
					var associatedAcadLocationIds = new Array();
		   	    	associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
		   	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
		   					associatedAcadLocationIds, me.getCERP_MANAGE_GALLERY_PERMISSIONS());
		   	    	
		   	    	if((Ext.Array.contains(permissionList, 'SAVE_ALBUM'))){
		   	    		if(isView == 'Edit'){
		   	    			formWindow.down('#submitBtnWin').show();	
		   	    		}
		    		}
				}
			}
		});
	},
	updateAlbum: function(button){
		var me = this;
		var albumdetailswin = button.up('albumdetailswin');

		var id = albumdetailswin.down('#id').getValue();
		var albumName = albumdetailswin.down('#albumName').getValue();
		var description = albumdetailswin.down('#description').getValue();
		var createdBy = this.getCurrentlyLoggedInUser().id;
		var structure;
		
		if(portalId==2){
			var btn = me.getViewgallerystructure().down('#newAddAlbumBtn');
			structure=me.getViewgallerystructure();
		}else{
			var btn = me.getManagegallerystructure().down('#newAlbumBtn');
			structure=me.getManagegallerystructure();
		}
		
		if(isNullOrEmpty(id)){
			var oldAlbumBtns = Ext.ComponentQuery.query('[cls=albumSideBtns]');
			//var newNumber = (oldAlbumBtns.length+1);

			//-- save album API here
//			albumdetailswin.body.mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
			Ext.Ajax.request({
				method : "POST",
				type : 'rest',
				url : SERVERURL.PATH_SAVE_UPDATE_GALLERY,
				jsonData : {
					albumName : albumName,
					description: description,
					createdBy:createdBy,
					academyLocationId:me.getCurrentAcademyLocation()
				},
				success : function(f, action) {
					albumdetailswin.body.unmask();
					var newAlbumBtn = {
							xtype: 'button',
							text: albumName,
							itemId: 'Album_'+f.responseText+'_Btn',
							iconCls: 'folderOpenIcon',
							tooltip: albumName,
							cls: 'albumSideBtns',
							sharedBtn:false,
							albumId: f.responseText
					};
					if(portalId==2){
						btn.up('#buttonContainer2').add(newAlbumBtn);
					}else{
						btn.up('#buttonContainer').add(newAlbumBtn);
					}
					
					me.setContextMenu(structure);
					button.up('albumdetailswin').close();
					showSuccessMessage(getCommonTranslation('ACADEMIA_DRIVE'),getCommonTranslation('DRIVE_FOLDER_ADDED_SUCCESSFULLY'));
				}
			});
		}
		else{
//			albumdetailswin.body.mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
			Ext.Ajax.request({
				method : "POST",
				type : 'rest',
				url : SERVERURL.PATH_SAVE_UPDATE_GALLERY,
				jsonData : {
					id: id,
					albumName : albumName,
					createdBy: createdBy,
					description: description,
					academyLocationId:me.getCurrentAcademyLocation()
				},
				success : function(f, action) {
					albumdetailswin.body.unmask();
					if(f.responseText!="0"){
						button.up('albumdetailswin').close();
						showSuccessMessage(getCommonTranslation('ACADEMIA_DRIVE'),getCommonTranslation('DRIVE_FOLDER_UPDATED_SUCCESSFULLY'));
						var albumBtn;
						if(portalId==1){
							albumBtn = me.getManagegallerystructure().down('#Album_'+id+'_Btn');
						}
						else{
							albumBtn = me.getViewgallerystructure().down('#Album_'+id+'_Btn');
						}
						
						albumBtn.setText(albumName);
						albumBtn.setTooltip(albumName);
						me.setContextMenu(structure);
					}
					else{
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ALBUM_NAME_ALREADY_EXIST'));
					}
				}
			});
		}
	},
	deleteImages: function(button){
		var me = this;
		
		//--gettting tpl checked checkbox through jquery
		var imageIDs = $("[name=imageId]:checked").map(function(){
			return $(this).val();
		}).get();
		
		if(imageIDs.length){
			// Delete API here
			showConfirmMessage(getCommonTranslation('ACADEMIA_DRIVE'), getCommonTranslation('DELETE_FILE_MSG'), function(btn, text) {
				if (btn == 'yes') {
					Ext.Ajax.request({
						type: 'rest',
						url: SERVERURL.PATH_DELETE_GALLERY_IMAGES+'?ids='+imageIDs.join(','),
						method: 'DELETE',
						headers: {
							'Content-Type': 'application/json'
						},
						success: function(form, action) {
							var dataViewStore = Ext.ComponentQuery.query('#galleryDataView')[0].getStore();
							dataViewStore.load({
								callback: function(records, operation, success){
									if(records.length==0){
										try{
											var galleryId = dataViewStore.getProxy().extraParams.galleryId;
											var selectAlbumBtn = Ext.ComponentQuery.query('#Album_'+galleryId+'_Btn')[0];
											selectAlbumBtn.fireEvent('click',selectAlbumBtn);
										}
										catch(e){
											
										}
									}
								}
							});
							button.setDisabled(true);
						}
					});
				}
			});
		}
		else{
			if(Ext.ComponentQuery.query('myfolderfilegrid').length>0){
				var grid = me.getMyfolderfilegrid();
				if (grid.getSelectionModel().getCount() > 0) {
					showConfirmMessage(getCommonTranslation('ACADEMIA_DRIVE'),getCommonTranslation('DELETE_FILE_MSG'),function(btn,text){
						if (btn == 'yes') {
							var records = grid.getSelectionModel().getSelection();
							var ids=[];
							for(var i in records) {
								ids.push(records[i].data.id);
							}
							Ext.Ajax.request({
								method : "DELETE",
								url : SERVERURL.PATH_DELETE_GALLERY_IMAGES+'?ids='+ ids.join(','),
								headers : {
									'Content-Type' : 'application/json'
								},
								success : function(form,action) {
									var myFolderFileGridStore = Ext.ComponentQuery.query('myfolderfilegrid')[0].getStore();
									myFolderFileGridStore.load();
									button.setDisabled(true);
								}
							});
						}
					});
				}else {
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				}
			}
		}
	},
	openImage: function(dataview, record, item, index, e, eOpts){
		var me = this;
		if(e.target.tagName != 'INPUT'){
			$('#galleryCarousal').show();
			$('#galleryCarousal')[0].style.backgroundImage = 'url(resources/images/uploads'+record.data.path+')';
			$('#galleryCarousal')[0].currentImage = record.data.id;
			$('#galleryCarousal')[0].style.backgroundSize = 'contain';//(window.innerWidth-250)+'px'+(window.innerHeight-250)+'px';
			
			var dataViewStore = Ext.ComponentQuery.query('#galleryDataView')[0].getStore();
			var currentRecordId = $('#galleryCarousal')[0].currentImage;
			var currentRecordIndex = dataViewStore.findExact('id',currentRecordId);
			var previousRecord = dataViewStore.getAt(currentRecordIndex-1);
			var nextRecord = dataViewStore.getAt(currentRecordIndex+1);
			
			if(Ext.isDefined(previousRecord)){
				$('.previousGalleryCarousal')[0].style.display = '';
			}
			else{
				$('.previousGalleryCarousal')[0].style.display = 'none';
			}
			
			if(Ext.isDefined(nextRecord)){
				$('.nextGalleryCarousal')[0].style.display = '';
			}
			else{
				$('.nextGalleryCarousal')[0].style.display = 'none';
			}
		}
	},
	/*Open Image carousal from grid list*/
	openImageGridList: function(grid, record){
		
		var extension = record.data.fileType.toLowerCase();
		if(extension == "pdf" || extension == "doc" || extension == "docx" || extension == "xls" 
			|| extension == "xlsx" || extension == "ppt" || extension == "pptx" 
				|| extension == "txt" || extension == "odt"){
			this.downloadDocumentFile(record.data.id);
		}
		else if(record.data.addHyperlink==null && record.data.addHyperlink==null){
			var me = this;
			$('#galleryCarousal').show();
			$('#galleryCarousal')[0].style.backgroundImage = 'url(resources/images/uploads'+record.data.path+')';
			$('#galleryCarousal')[0].currentImage = record.data.id;
			$('#galleryCarousal')[0].style.backgroundSize = 'contain';//(window.innerWidth-250)+'px'+(window.innerHeight-250)+'px';

			var dataViewStore = grid.getStore();
			var currentRecordId = $('#galleryCarousal')[0].currentImage;
			var currentRecordIndex = dataViewStore.findExact('id',currentRecordId);
			var previousRecord = dataViewStore.getAt(currentRecordIndex-1);
			var nextRecord = dataViewStore.getAt(currentRecordIndex+1);

			if(Ext.isDefined(previousRecord)){
				$('.previousGalleryCarousal')[0].style.display = '';
			}
			else{
				$('.previousGalleryCarousal')[0].style.display = 'none';
			}

			if(Ext.isDefined(nextRecord)){
				$('.nextGalleryCarousal')[0].style.display = '';
			}
			else{
				$('.nextGalleryCarousal')[0].style.display = 'none';
			}
		}
	},
	openGalleryImageUploadWin: function(btn){
		var me = this;
		var formWindow = me.getFileuploadwin();
		if (!formWindow) {
			Ext.widget('fileuploadwin',{
				itemId: 'galleryWin'
			});
			formWindow = me.getFileuploadwin();
		}
		var dataview = formWindow.down('#galleryDataViewAddWin');
		var store = dataview.getStore();
		store.removeAll();
		
		formWindow.show();
	},
	uploadGalleryImages: function(btn){
		if (typeof btn.lastExecutionTime === 'undefined') {
            btn.lastExecutionTime = 0;
           }

           var currentTime = new Date().getTime();

           // Prevent function execution if called within the last 5+ seconds
           if (currentTime - btn.lastExecutionTime < 5000) {
               console.log('Function call skipped to prevent duplicate execution');
               return false;
           }

           // Update last execution time
           btn.lastExecutionTime = currentTime;
		var me = this;
		if(Ext.ComponentQuery.query('#galleryDataView').length>0){
			var galleryId = Ext.ComponentQuery.query('#galleryDataView')[0].getStore().getProxy().extraParams.galleryId;
			var uploadedBy = this.getCurrentlyLoggedInUser().id;
			var formData = new FormData();
			var galleryDataViewAddWin = btn.up('form').down('#galleryDataViewAddWin');
			var labelOfHyperlinkId = btn.up('form').down('#labelOfHyperlinkId').getValue();
			var addHyperlinkId = btn.up('form').down('#addHyperlinkId').getValue();
			var galleryStore = galleryDataViewAddWin.getStore();
			
			if(galleryStore.data.length>0){
				Ext.each(galleryStore.data.items,function(currentFile){
					formData.append("file[]", currentFile.data.fileData);
				});
			}
			if(isNullOrEmpty(labelOfHyperlinkId)){
                if(!isNullOrEmpty(addHyperlinkId)){
                  return  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILL_LABEL_OF_HYPERLINK'));
                }
            }
            if(isNullOrEmpty(addHyperlinkId)){
                if(!isNullOrEmpty(labelOfHyperlinkId)){
                   return showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('Fill_ADD_HYPERLINK'));
                }
            }
            var SubmitImageButton = btn.up('form').down('#submitImageBtnWin');
            SubmitImageButton.setDisabled(false);
			/*var allFiles = $('[type=file]').prop('files');
			try{
				if(allFiles.length==0){
					allFiles = $('[type=file]')[$('[type=file]').length-1].files;
				}
			}
			catch(e){

			}
			Ext.each(allFiles,function(currentFile){
				formData.append("file[]", currentFile);
			});*/
            if(galleryDataViewAddWin.all.elements.length==0){
            	$.ajax({
				
				url: SERVERURL.PATH_GALLERY_IMAGE_UPLOAD_ONLY_LINK+'?galleryId='+galleryId+'&uploadedBy='+uploadedBy+
				'&labelOfHyperlinkId='+encodeURIComponent(labelOfHyperlinkId)+'&addHyperlinkId='+encodeURIComponent(addHyperlinkId),
				method: 'GET',
				contentType: false,
				processData: false,
				headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
				success: function (response) {
					btn.up('window').body.unmask();
					btn.up('window').close();
					Ext.ComponentQuery.query('#galleryDataView')[0].getStore().load({
						callback: function(){
							var currentBtn = Ext.ComponentQuery.query('#Album_'+galleryId+'_Btn')[0];
							currentBtn.fireEvent('click',currentBtn);
						}
					});
				},
				error: function (err) {
					btn.up('window').body.unmask();
					//console.log(err);
				}
			});
            
				
			}
            else {
			btn.up('window').body.mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
			$.ajax({
				url: SERVERURL.PATH_UPLOAD_GALLERY_IMAGES+'?galleryId='+galleryId+'&uploadedBy='+uploadedBy+
				'&labelOfHyperlinkId='+labelOfHyperlinkId+'&addHyperlinkId='+addHyperlinkId,
				method: 'POST',
				data: formData,
				contentType: false,
				processData: false,
				headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
				success: function (response) {
					btn.up('window').body.unmask();
					btn.up('window').close();
					Ext.ComponentQuery.query('#galleryDataView')[0].getStore().load({
						callback: function(){
							var currentBtn = Ext.ComponentQuery.query('#Album_'+galleryId+'_Btn')[0];
							currentBtn.fireEvent('click',currentBtn);
						}
					});
				},
				error: function (err) {
					btn.up('window').body.unmask();
					//console.log(err);
				}
			});
		}}
		else if(Ext.ComponentQuery.query('myfolderfilegrid').length>0){
			var galleryId = Ext.ComponentQuery.query('myfolderfilegrid')[0].getStore().getProxy().extraParams.galleryId;
			var uploadedBy = this.getCurrentlyLoggedInUser().id;
			var formData = new FormData();
			var labelOfHyperlinkId = btn.up('form').down('#labelOfHyperlinkId').getValue();
			var addHyperlinkId = btn.up('form').down('#addHyperlinkId').getValue();
			var galleryDataViewAddWin = btn.up('form').down('#galleryDataViewAddWin');
			var galleryStore = galleryDataViewAddWin.getStore();
			
			if(galleryStore.data.length>0){
				Ext.each(galleryStore.data.items,function(currentFile){
					formData.append("file[]", currentFile.data.fileData);
				});
			}
			if(isNullOrEmpty(labelOfHyperlinkId)){
                if(!isNullOrEmpty(addHyperlinkId)){
                    return showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILL_LABEL_OF_HYPERLINK'));
                }
            }
            if(isNullOrEmpty(addHyperlinkId)){
                if(!isNullOrEmpty(labelOfHyperlinkId)){
                  return  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('Fill_ADD_HYPERLINK'));
                }
            }
            var SubmitImageButton = btn.up('form').down('#submitImageBtnWin');
            SubmitImageButton.setDisabled(false);
			
			/*var allFiles = $('[type=file]').prop('files');
			try{
				if(allFiles.length==0){
					allFiles = $('[type=file]')[$('[type=file]').length-1].files;
				}
			}
			catch(e){

			}
			Ext.each(allFiles,function(currentFile){
				formData.append("file[]", currentFile);
			});*/
            if(galleryDataViewAddWin.all.elements.length==0){
            	$.ajax({
				
				url: SERVERURL.PATH_GALLERY_IMAGE_UPLOAD_ONLY_LINK+'?galleryId='+galleryId+'&uploadedBy='+uploadedBy+
				'&labelOfHyperlinkId='+labelOfHyperlinkId+'&addHyperlinkId='+addHyperlinkId,
				method: 'GET',
				contentType: false,
				processData: false,
				headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
				success: function (response) {
					btn.up('window').body.unmask();
					btn.up('window').close();
					Ext.ComponentQuery.query('myfolderfilegrid')[0].getStore().load({
						callback: function(){
							//var currentBtn = Ext.ComponentQuery.query('#Album_'+galleryId+'_Btn')[0];
							//currentBtn.fireEvent('click',currentBtn);
						}
					});
					
				},
				error: function (err) {
					btn.up('window').body.unmask();
					//console.log(err);
				}
			});
				
			}
            else {
			btn.up('window').body.mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
			$.ajax({
				url: SERVERURL.PATH_UPLOAD_GALLERY_IMAGES+'?galleryId='+galleryId+'&uploadedBy='+uploadedBy+
				'&labelOfHyperlinkId='+labelOfHyperlinkId+'&addHyperlinkId='+addHyperlinkId,
				method: 'POST',
				data: formData,
				contentType: false,
				processData: false,
				headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
				success: function (response) {
					btn.up('window').body.unmask();
					btn.up('window').close();
					Ext.ComponentQuery.query('myfolderfilegrid')[0].getStore().load({
						callback: function(){
							//var currentBtn = Ext.ComponentQuery.query('#Album_'+galleryId+'_Btn')[0];
							//currentBtn.fireEvent('click',currentBtn);
						}
					});
				},
				error: function (err) {
					btn.up('window').body.unmask();
					//console.log(err);
				}
			});
		}}
	},
	openShareAlbum: function(btn){
		var me =this;
		var albumId = btn.albumId;
		var albumName = btn.albumName;
		
		var contentpanel = me.getContentPanel();
		var shareAlbumStructure = Ext.widget('sharealbumstructure');
		var tabName = getCommonTranslation('SHARE_FOLDER');
		
		var getcontroller=this.getController('menu.CoreERPNavigationController');
		var getTab=getcontroller.getTab(tabName);
		if(getTab!=null){
			contentpanel.remove(getTab, true);
		}
		
		if(contentPanel!=undefined){
	  		var newTab = contentPanel.items.findBy( function(tab) {
	  			return tab.title === tabName;
	  		 });
	  		
	  		if(!newTab){
	  			var newTab = contentPanel.add({
	  				xtype: 'sharealbumstructure',
	  				closable:true,										 
	  				title: tabName,
	  				albumId: albumId,
	  				albumName: albumName
	  			});
	  		}																	
	  		contentPanel.setActiveTab(newTab);
	  		contentPanel.doLayout();		
	  	}		
	},
	openMapAlbumStructure: function(btn){
		var me =this;
		var albumId = btn.up('sharealbumstructure').albumId;
		this.albumIdForSharedAlumni = btn.up('sharealbumstructure').albumId;
		var albumName = btn.up('sharealbumstructure').albumName;

		/*var contentpanel = me.getContentPanel();
		var shareAlbumStructure = Ext.widget('mapalbumstructure');
		var tabName = getCommonTranslation('MAP_FOLDER');
		
		var getcontroller=this.getController('menu.CoreERPNavigationController');
		var getTab=getcontroller.getTab(tabName);
		if(getTab!=null){
			contentpanel.remove(getTab, true);
		}*/
		
		var contentpanel = this.getContentPanel();
		var shareAlbumStructure = Ext.widget('mapalbumstructure');
		var tabName = getCommonTranslation('MAP_FOLDER');
	
		
		var getcontroller=this.getController('menu.CoreERPNavigationController');
		var getTab=getcontroller.getTab(tabName);
		if(getTab!=null){
			contentpanel.remove(getTab, true);
		}
		openTab(contentpanel, tabName, shareAlbumStructure,CONSTANTS.MENU_COLOR_NINE);
		
		var academylocationgrid = this.getMapfolderaddalgrid();
		academylocationgrid.getStore().clearFilter();
		academylocationgrid.getStore().load();
		
		me.getAdjustmentprogresstracker().setVisible(true);
  		me.resetProgressTracker();
  		var adjustmentprogresstracker = me.getMapalbumstructure().down("#adjustmentprogresstracker");
  		var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
  		progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
  		progresstracker1.textEl.addCls("inProgressCss-progress-text");
  		progresstracker1.updateText("Step 1 In Progress");
  		shareAlbumStructure.down('#sectionValueItemId').setValue(false);
  		shareAlbumStructure.down('#albumId').setValue(albumId);
  		shareAlbumStructure.down('#albumName').setValue(albumName);
		
		/*if(contentPanel!=undefined){
	  		var newTab = contentPanel.items.findBy( function(tab) {
	  			return tab.title === tabName;
	  		 });
	  		
	  		if(!newTab){
	  			var newTab = contentPanel.add({
	  				xtype: 'mapalbumstructure',
	  				closable:true,										 
	  				title: tabName,
	  				albumId: albumId,
	  				albumName: albumName
	  			});
	  		}
	  		contentPanel.setActiveTab(newTab);
	  		contentPanel.doLayout();	
	  	}*/		
	},
	deleteShareAlbumGridItems: function(btn){
		var me =this;
		var grid=btn.up('grid');
		
		if(grid.getSelectionModel().getSelection().length>0){
			var id=Number(grid.getSelectionModel().getSelection()[0].data.id);
			var albumId = btn.up('sharealbumstructure').albumId;
			showConfirmMessage(getCommonTranslation('SHARE_FOLDER'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
				if (btn == 'yes') {
					Ext.Ajax.request({
						type: 'rest',
						url: SERVERURL.PATH_DELETE_SHARED_BATCH_MAPPING+'?id='+id,
						method: 'DELETE',
						headers: {
							'Content-Type': 'application/json'
						},
						success: function(form, action) {
							var extraParams = grid.getStore().getProxy().extraParams;
							extraParams.sort = null;
							grid.getStore().getProxy().extraParams = extraParams;
							grid.getStore().load({
								callback: function(records){
									if(grid.getStore().pageSize>records.length){
										grid.down('custompagingtoolbar').hide();
									}
									else{
										grid.down('custompagingtoolbar').show();
									}
								}
							});
							showSuccessMessage(getAlumni('SHARE_FOLDER'),getAlumni('FOLDER_HAS_BEEN_DELETED_SUCCESSFULLY_MSG'))
						}
					});
				}
			});
		}else{
		  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	  }
	},
	
	saveShareDetails: function(btn){
		var me =this;
		var albumId = btn.up('mapalbumstructure').albumId;
		
		if(btn.up('grid').getSelectionModel().getCount()>0 && btn.up('mapalbumstructure').down('#shareAlbumWithItemId').query('[checked="true"]').length>0){
			var gridRecords = btn.up('grid').getSelectionModel().getSelection();
			var shareWith = btn.up('mapalbumstructure').down('#shareAlbumWithItemId').query('[checked="true"]');
			
			var galleryId = albumId;
			var uploadedBy = this.getCurrentlyLoggedInUser().id;
			var isSharedWithFaculty = false;
			var isSharedWithStudent = false;
			var academyLocationId = this.getCurrentAcademyLocation();
			var batches = '';
			
			Ext.each(shareWith, function(currentShareWith){
				if(currentShareWith.inputValue=="faculties"){
					isSharedWithFaculty=true;
				}else{
					isSharedWithStudent = true;
				}
			});
			
			var alreadySharedBatchIds = [];
			var notSharedBatchIds = [];
			
			Ext.each(gridRecords, function(currentRecord){
				if(currentRecord.get('isShared')==true){
					alreadySharedBatchIds.push(currentRecord.get('code')+'-'+currentRecord.get('value'));
				}
				else{
					notSharedBatchIds.push(currentRecord.get('id'));
				}
			});
			
			if(notSharedBatchIds.length>0){
				var batches = notSharedBatchIds.join(',');
			}

			if(alreadySharedBatchIds.length){
				/*var msg = '<span style="font-weight: 600;font-size: 16px;letter-spacing: 0.5px;color: black;">'+'Alert'+'</span><br><span style="font-size: 12px;text-align: left;color: black;top: -3px;position: relative;">'+'<b>'+getCommonTranslation('ALREADY_MAPPED_IN_PB')+'</b><br /><div style="overflow-x: hidden;height: 155px;width:330px;overflow-y: auto;">'+alreadySharedBatchIds.join('<br />')+'</div>'+'</span>';
				var box2 =Ext.Msg.show({
				//title: getCommonTranslation('TITLE_QUARTZ_DETAIL'),
				msg	: msg,
				buttons	: Ext.MessageBox.OK,
				icon: Ext.Msg.INFO,
				cls: 'successMessageBox commonMsgBoxCls newClsMessageSuccessBox',
				fn	: function(response){
					if(response=="ok"){
						me.mapAlbumMessageCallbackFunction(response,notSharedBatchIds,galleryId,uploadedBy,isSharedWithFaculty,isSharedWithStudent,academyLocationId,batches);
					}
				}
				});	
				box2.removeCls('newClsMessageConfirmBox');
				box2.dockedItems.items[1].layout.pack = "end";
				box2.doLayout();
				box2.dockedItems.items[1].items.items[0].setUI('CustomBtnSubmit');*/
				showSessionTimeOutMessage(
					'Alert',
					'<b>'+getCommonTranslation('ALREADY_MAPPED_IN_PB')+'</b><br /><div style="overflow-x: hidden;height: 155px;width:330px;overflow-y: auto;">'+alreadySharedBatchIds.join('<br />'),
					function(response){
						if(response=="ok"){
							me.mapAlbumMessageCallbackFunction(response,notSharedBatchIds,galleryId,uploadedBy,isSharedWithFaculty,isSharedWithStudent,academyLocationId,batches);
						}
					}
				);
			}
			else if(notSharedBatchIds.length>0){
				me.submitShareAjax(galleryId,uploadedBy,isSharedWithFaculty,isSharedWithStudent,academyLocationId,batches);
			}
		}
		else{
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	
	mapAlbumMessageCallbackFunction: function(response,notSharedBatchIds,galleryId,uploadedBy,isSharedWithFaculty,isSharedWithStudent,academyLocationId,batches){
		var me = this;
		if(response=="ok"){
			if(notSharedBatchIds.length>0){
				me.submitShareAjax(galleryId,uploadedBy,isSharedWithFaculty,isSharedWithStudent,academyLocationId,batches);
			}
		}
	},
	
	submitShareAjax: function(galleryId,uploadedBy,isSharedWithFaculty,isSharedWithStudent,academyLocationId,batches){
		var me = this;
		
		Ext.Ajax.request({
			method : "POST",
			type : 'rest',
			url : SERVERURL.PATH_SAVE_ALL_SHARED_BATCH_MAPPING,
			jsonData : {
				galleryId: galleryId,
				uploadedBy: uploadedBy,
				isSharedWithFaculty: isSharedWithFaculty,
				isSharedWithStudent: isSharedWithStudent,
				academyLocationId: academyLocationId,
				batches: batches
			},
			success : function(f, action) {
				if(f.responseText=="true"){
					showSuccessMessage(getCommonTranslation('SHARE_FOLDER'),getCommonTranslation('ALBUM_HAS_BEEN_SHARED_SUCCESSFULLY')); 
					me.getContentPanel().getActiveTab().close();
					var isShareOpened = me.getContentPanel().items.findBy( function(tab) {
						return tab.title === getCommonTranslation('SHARE_FOLDER');
					});
					if(isShareOpened){
						isShareOpened.down('grid').getStore().loadPage(1);
					}
				}
				else{
					showWarningMessage(getCommonTranslation('ERROR'),getCommonTranslation('DEPENDENCY_EXISTS'));
				}
			}
		});
	},
	
	openShareDetailWin: function(btn){
		var me =this;
		var record = btn.up('grid').getSelectionModel().getSelection();

		var formWindow = me.getSharedetailswin();
		if (!formWindow) {
			Ext.widget('sharedetailswin');
			formWindow = me.getSharedetailswin();
		}
		formWindow.show();
		
		if(record[0].data.isSharedWithFaculty=="Yes"){
			formWindow.down('#shareAlbumWithSDItemId').items.items[0].setValue(true);
		}
		
		if(record[0].data.isSharedWithStudent=="Yes"){
			formWindow.down('#shareAlbumWithSDItemId').items.items[1].setValue(true);
		}
		if(record[0].data.isSharedWithParent=="Yes"){
			formWindow.down('#shareAlbumWithSDItemId').items.items[2].setValue(true);
			formWindow.down('#shareAlbumWithSDItemId').items.items[3].setReadOnly(true);

		}
		if(record[0].data.isSharedWithAlumni=="Yes"){
			formWindow.down('#shareAlbumWithSDItemId').items.items[3].setValue(true);
			formWindow.down('#shareAlbumWithSDItemId').items.items[3].setReadOnly(true);
			formWindow.down('#shareAlbumWithSDItemId').items.items[2].setValue(false)
			formWindow.down('#shareAlbumWithSDItemId').items.items[2].setReadOnly(true)
		}
		formWindow.down('#academyLocationSDItemId').setValue(record[0].data.academyLocationName);
		formWindow.down('#programSDItemId').setValue(record[0].data.programName);
		formWindow.down('#batchSDItemId').setValue(record[0].data.batchName);
		formWindow.down('#sectionSDItemId').setValue(record[0].data.sectionName);
	},
	openCBSShareDetailWin: function(btn){
		var me =this;
		var record = btn.up('grid').getSelectionModel().getSelection();

		var formWindow = me.getSharecbsdetailswin();
		if (!formWindow) {
			Ext.widget('sharecbsdetailswin');
			formWindow = me.getSharecbsdetailswin();
		}
		formWindow.show();
		
		if(record[0].data.isSharedWithFaculty=="Yes"){
			formWindow.down('#shareAlbumWithSDItemId').items.items[0].setValue(true);
		}
		
		if(record[0].data.isSharedWithStudent=="Yes"){
			formWindow.down('#shareAlbumWithSDItemId').items.items[1].setValue(true);
		}
		if(record[0].data.isSharedWithParent=="Yes"){
			formWindow.down('#shareAlbumWithSDItemId').items.items[2].setValue(true);
		}

		formWindow.down('#academicTermItemId').setValue(record[0].data.academicTerm);
		formWindow.down('#courseNameItemId').setValue(record[0].data.coursePrintName);
		formWindow.down('#courseVariantItemId').setValue(record[0].data.courseVariant);
	},
	loadFoldersPortal: function(structure) {
		var me = this;
		structure.down('#buttonContainer2').body.mask('Loading...');
		var params = {};
		
		if(portalId==2){ //faculty portal
			params = {
					/*isFacultyPortal: true,
					isStudentPortal: false,*/
					academyLocationId:this.getCurrentAcademyLocation()
			}
		}
		else if(portalId==7){ //parent portal
			var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
			var studentprogramId = studentPortalInfo.programBatchDetails.programId;
			var studentbatchId = studentPortalInfo.programBatchDetails.batchId;
			params = {
					isFacultyPortal: false,
					isStudentPortal: true,
					academyLocationId:this.getCurrentAcademyLocation(),
					batchId: studentbatchId
			}
		}
		else if(portalId==3){ //student portal
			var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
			var studentprogramId = studentPortalInfo.programBatchDetails.programId;
			var studentbatchId = studentPortalInfo.programBatchDetails.batchId;
			params = {
					/*isFacultyPortal: false,
					isStudentPortal: true,*/
					academyLocationId:this.getCurrentAcademyLocation(),
					batchId: studentbatchId
			}
		}

		//-- get album API here
		Ext.Ajax.request({
			method : "GET",
			type : 'rest',
			url : SERVERURL.PATH_GET_ALL_GALLERY,
			params: params,
			success : function(f, action) {
				var resp = Ext.decode(f.responseText);
				var albums = resp.rows;

				var i = 1;
				Ext.each(albums, function(currentAlbum){
					var newAlbumBtn = {
							xtype: 'button',
							text: currentAlbum.albumName,
							itemId: 'Album_'+currentAlbum.id+'_Btn',
							tooltip: currentAlbum.albumName,
							iconCls: 'folderOpenIcon',
							cls: 'albumSideBtns',
							albumId: currentAlbum.id,
						    /*style:{
						    	marginLeft: '26px'
						    }*/
					};
					structure.down('#buttonContainer2').add(newAlbumBtn);
					i=i+1;
				});
				structure.down('#buttonContainer2').body.unmask();
				me.setContextMenu(structure);
			}
		});
	},
	loadSharedFoldersPortal: function(structure) {
		var me = this;
		structure.down('#buttonContainerShared').body.mask('Loading...');
		var academyLocations = Academia.model.authentication.PortalInfoModel.data.userAacademyLocations;
		var currentlyLoggedInUserId= this.getCurrentlyLoggedInUser().id;		// V2D-301930
		if( portalId == 7){
           currentlyLoggedInUserId = userInfo.get("parentUserId");
          }
		var alId;
		for(i in academyLocations) {
			if(academyLocations[i].whetherPrimary == true) {
				alId = academyLocations[i].academyLocationId;
			}
		}
		//-- get album API here
		Ext.Ajax.request({
			method : "GET",
			type : 'rest',
			url : SERVERURL.PATH_FIND_SHARED_GALLERY,
			params: {
				academyLocationId:alId,
				currentUserId:currentlyLoggedInUserId				
			},
			success : function(f, action) {
				var resp = Ext.decode(f.responseText);
				var albums = resp.rows;

				var i = 1;
				Ext.each(albums, function(currentAlbum){
					var newAlbumBtn = {
							xtype: 'button',
							text: currentAlbum.albumName,
							itemId: 'Album_'+currentAlbum.id+'_Btn',
							tooltip: currentAlbum.albumName,
							iconCls: 'folderOpenIcon',
							cls: 'albumSideBtns',
							sharedBtn:true,
							albumId: currentAlbum.id
					};
					structure.down('#buttonContainerShared').add(newAlbumBtn);
					i=i+1;
				});
			    //structure.down('#buttonContainerShared').add(newAlbumBtn);
				me.setContextMenuForSharedFolder(structure);
				structure.down('#buttonContainerShared').body.unmask();
			}
		});
	},
	
/*	onAlbumBtnClickForView: function(btn) {
		var me = this;
		Ext.each(Ext.ComponentQuery.query('[cls=albumSideBtns]'), function(currentBtn){
			currentBtn.getEl().setStyle('box-shadow', '');
		});
		btn.getEl().setStyle('box-shadow', 'inset 0 0 10px #828482');
		
		btn.up('viewgallerystructure').down('#albumImagesPanel2').removeAll();
		btn.up('viewgallerystructure').down('#albumImagesPanel2').body.setHTML('');
		//-rgv-btn.up('viewgallerystructure').down('#albumImagesPanel2').body.setHTML(getCommonTranslation('NO_IMAGE_ADDED'));
		btn.up('viewgallerystructure').down('#albumImagesPanel2').body.addCls('text-middle-center');

		var managGalleryStore = Ext.create('Academia.store.facilitiesresources.managegallery.ManageGalleryStore');
		managGalleryStore.getProxy().extraParams = {
			galleryId : btn.albumId
		};
		managGalleryStore.removeAll();
		managGalleryStore.load({
			callback: function(records, operation, success){
				if(records.length>0){
					btn.up('viewgallerystructure').down('#albumImagesPanel2').removeAll();
					btn.up('viewgallerystructure').down('#albumImagesPanel2').body.setHTML('');
					btn.up('viewgallerystructure').down('#albumImagesPanel2').body.removeCls('text-middle-center');
					btn.up('viewgallerystructure').down('#albumImagesPanel2').doLayout();
				}
				var imageTpl = new Ext.XTemplate(
						'<tpl for=".">',
						'<div style="margin-bottom: 10px;" class="gallery-thumb-wrap">',
						'<img src="resources/images/uploads{iconImage}" />',
						'<br/><span>Image {#}</span>',
						'</div>',
						'</tpl>'
				);
				
				Ext.each(Ext.ComponentQuery.query('#galleryDataView'), function(currentGalleryDataView){
					currentGalleryDataView.destroy();
				});
				
				Ext.create('Ext.view.View', {
				    store: managGalleryStore,
				    tpl: imageTpl,
				    itemSelector: 'div.gallery-thumb-wrap',
				    emptyText: getCommonTranslation('NO_FILES_ADDED_YET_MSG'),
				    renderTo: btn.up('viewgallerystructure').down('#albumImagesPanel2').body,
					itemId: 'galleryDataView',
					height: '100%',
					deferEmptyText: false,
					listeners: {
						itemclick: function( dataview, record, item, index, e, eOpts ){
							me.openImage(dataview, record, item, index, e, eOpts);
						}
					}
				});
			}
		});
	},*/
	
	showFolderDriveList: function(btn) {
		var me = this;
		this.whetherListView=true;
		var managegallerystructure = me.getManagegallerystructure();
        managegallerystructure.down('#btnEditImage').setDisabled(true);
		managegallerystructure.down('#btnDeleteImage').setDisabled(true);
		managegallerystructure.down('#albumImagesPanel').removeAll();
		managegallerystructure.down('#albumImagesPanel').body.setHTML('');
		managegallerystructure.down('#albumImagesPanel').body.addCls('text-middle-center');
		btn.addCls('driveActiveListIcon');
		managegallerystructure.down('#btnDriveMenuIcon').removeCls('driveActiveMenuIcon');
		managegallerystructure.down('#btnDriveMenuIcon').addCls('driveMenuIcon');
		
		managegallerystructure.down('#albumImagesPanelMenuView').removeCls('albumImagesPanelMenuToolbarCls');
		
		var managGalleryStore = Ext.create('Academia.store.facilitiesresources.managegallery.ManageGalleryStore');
		managGalleryStore.getProxy().extraParams = {
			galleryId : btn.config.albumId
		};
		managGalleryStore.removeAll();
		managGalleryStore.load({
			callback: function(records, operation, success){
				managegallerystructure.down('#albumImagesPanel').removeAll();
				managegallerystructure.down('#albumImagesPanel').body.setHTML('');
				managegallerystructure.down('#albumImagesPanel').doLayout();
				managegallerystructure.down('#albumImagesPanel').body.removeCls('text-middle-center');
				Ext.each(Ext.ComponentQuery.query('#galleryDataView'), function(currentGalleryDataView){
					currentGalleryDataView.destroy();
				});
				Ext.each(Ext.ComponentQuery.query('myfolderfilegrid'), function(myFolderFileGrid){
					myFolderFileGrid.destroy();
				});

				Ext.widget("myfolderfilegrid", {
					store: managGalleryStore,
					renderTo: btn.up('managegallerystructure').down('#albumImagesPanel').body
					//height: '100%',
					//readerRoot: 'data',
				});
				
				var btnDrive = managegallerystructure.down('#btnDriveMenuIcon');
				var sharedBtn = btnDrive.sharedBtn;
				if(portalId==1 && sharedBtn){
					Ext.ComponentQuery.query('myfolderfilegrid')[0].headerCt.items.getAt(0).hide();
				}
			}
		});
	},	
	showFPFolderDriveList: function(btn) {
		var me = this;
		this.whetherListView=true;
		var viewGalleryStructure = me.getViewgallerystructure();
		viewGalleryStructure.down('#btnEditImage').setDisabled(true);
		viewGalleryStructure.down('#btnDeleteImage').setDisabled(true);
		viewGalleryStructure.down('#albumImagesPanel2').removeAll();
		viewGalleryStructure.down('#albumImagesPanel2').body.setHTML('');
		viewGalleryStructure.down('#albumImagesPanel2').body.addCls('text-middle-center');
		btn.addCls('driveActiveListIcon');
		viewGalleryStructure.down('#btnDriveMenuIcon').removeCls('driveActiveMenuIcon');
		viewGalleryStructure.down('#btnDriveMenuIcon').addCls('driveMenuIcon');

		viewGalleryStructure.down('#albumImagesPanelMenuView2').removeCls('albumImagesPanelMenuToolbarCls');

		var managGalleryStore = Ext.create('Academia.store.facilitiesresources.managegallery.ManageGalleryStore');
		managGalleryStore.getProxy().extraParams = {
			galleryId : btn.config.albumId
		};
		managGalleryStore.removeAll();
		managGalleryStore.load({
			callback: function(records, operation, success){
				viewGalleryStructure.down('#albumImagesPanel2').removeAll();
				viewGalleryStructure.down('#albumImagesPanel2').body.setHTML('');
				viewGalleryStructure.down('#albumImagesPanel2').doLayout();
				viewGalleryStructure.down('#albumImagesPanel2').body.removeCls('text-middle-center');
				Ext.each(Ext.ComponentQuery.query('#galleryDataView'), function(currentGalleryDataView){
					currentGalleryDataView.destroy();
				});
				Ext.each(Ext.ComponentQuery.query('myfolderfilegrid'), function(myFolderFileGrid){
					myFolderFileGrid.destroy();
				});

				Ext.widget("myfolderfilegrid", {
					store: managGalleryStore,
					renderTo: btn.up('viewgallerystructure').down('#albumImagesPanel2').body
					//height: '100%',
					//readerRoot: 'data',
				});
				
				var btnDrive = viewGalleryStructure.down('#btnDriveMenuIcon');
				var sharedBtn = btnDrive.sharedBtn;
				if(portalId==2 && sharedBtn){
					Ext.ComponentQuery.query('myfolderfilegrid')[0].headerCt.items.getAt(0).hide();
				} else if(portalId==3 || portalId==7){
					Ext.ComponentQuery.query('myfolderfilegrid')[0].headerCt.items.getAt(0).hide();
				}
			}
		});
	},
	downloadDocumentFile : function(documentId){

		var whetherFile = false;
		if(!isNullOrEmpty(documentId)){
			Ext.Ajax.request({
				type: 'rest',
				url: SERVERURL.PATH_CHECK_WHETHER_FILE_EXISIS+documentId,
				method: 'GET',
				callback : function(opt, success, response){
					if(response.responseText == 'true') {
						var csvForm = Ext.create('Ext.form.Panel'); 
						csvForm.getForm().submit({
							target: '_blank',
							method:'GET',
							params :{
								documentId : documentId,
								access_token : Ext.Ajax.defaultHeaders.access_token
							},
							headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
							url: SERVERURL.PATH_DOWNLOAD_DRIVE_FILES + '?documentId=' + documentId,
							standardSubmit :true
						});
					} else {
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
					}
				}
			});
		}
	},
	setProgressTracker : function(progresstracker){
    	var structure = this.getMapalbumstructure();
    	var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");

    	var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
    	var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
    	var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");
		var progresstracker4 = adjustmentprogresstracker.down("#progresstracker4");
		
			
    	if(progresstracker==1){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker1.updateProgress((i * 0.1), '');
    		}
    		progresstracker1.textEl.addCls("custom-progress-text");
    		progresstracker1.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker2.textEl.removeCls("x-progress-text x-progress-text-back");
    		progresstracker2.textEl.addCls("inProgressCss-progress-text");
    		progresstracker2.updateText("Step 2 In Progress");
    		progresstracker1.updateText(getCommonTranslation('STEP_1_COMPLETE'));
    	}
    	if(progresstracker==2){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker2.updateProgress((i * 0.1), '');
    		}
    		progresstracker2.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker2.textEl.addCls("custom-progress-text");
    		progresstracker2.updateText(getCommonTranslation('STEP_2_COMPLETE'));
    		
    		progresstracker3.textEl.removeCls("x-progress-text x-progress-text-back");
			progresstracker3.textEl.addCls("inProgressCss-progress-text");
			progresstracker3.updateText("Step 3 In Progress");
    	}
    	
    	if(progresstracker==3){
			for(var i = 0; i < 11; i ++ ){
				progresstracker3.updateProgress((i * 0.1), '');
			}
			progresstracker4.textEl.removeCls("x-progress-text x-progress-text-back");
			progresstracker4.textEl.addCls("inProgressCss-progress-text");
			progresstracker4.updateText("Step 4 In Progress");
			progresstracker3.textEl.removeCls("inProgressCss-progress-text");
			progresstracker3.textEl.addCls("custom-progress-text");
			progresstracker3.updateText(getCommonTranslation('STEP_3_COMPLETE'));
		} 
    	if(progresstracker==4){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker4.updateProgress((i * 0.1), '');
    		}
    		progresstracker4.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker4.textEl.addCls("custom-progress-text");
    		progresstracker4.updateText(getCommonTranslation('STEP_4_COMPLETE'));
    	}
    	
    },
	resetProgressTracker : function(){
    	var structure = this.getMapalbumstructure();
    	var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");
    	var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
    	var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
    	var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");
    	var progresstracker4 = adjustmentprogresstracker.down("#progresstracker4");
    	progresstracker1.reset();
    	progresstracker1.updateText('');
    	progresstracker2.reset();
    	progresstracker2.updateText('');
    	progresstracker3.reset();
    	progresstracker3.updateText('');
    	progresstracker4.reset();
    	progresstracker4.updateText('');
    },
    academyLocationNextEventProgramFolder:function(btn){
    	var mapfolderalprogrambatchsectionstructure = this.getMapfolderalprogrambatchsectionstructure();
    	var academylocationgrid = mapfolderalprogrambatchsectionstructure.down('#mapFolderAddALGridItemId');
    	var selectionModel = academylocationgrid.getSelectionModel().getSelection();
    	var academyLocationIdsArr = [];
    	selectionModel.forEach(function(obj){
    		academyLocationIdsArr.push(obj.get('id'));
    	});
    	if(academyLocationIdsArr.length > 0){
    		var mapalbumstructure = this.getMapalbumstructure();
    		var programcontainer = mapfolderalprogrambatchsectionstructure.down('#programContainerId');
    		programcontainer.setDisabled(false);
    		mapfolderalprogrambatchsectionstructure.setActiveTab(programcontainer);
    		var alProgramGrid = this.getMapfolderaddprogramgrid();
    		var alProgramSearchCombo = alProgramGrid.down('#programsearchcombo');
    		alProgramSearchCombo.reset();
    		alProgramSearchCombo.getStore().getProxy().extraParams= {
    			academyLocationIds: academyLocationIdsArr.join()
    		};
    		alProgramSearchCombo.getStore().load();
    		var alProgramGridStore = alProgramGrid.getStore();
    		
    		alProgramGridStore.getProxy().extraParams= {
	    		academyLocationIds: academyLocationIdsArr.join()
	    	};
    		alProgramGridStore.clearFilter();
    		alProgramGridStore.load();
    		this.setProgressTracker(1);   		
    		
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    programNextEventOnProgramFolder:function(btn){
    	var mapfolderalprogrambatchsectionstructure = this.getMapfolderalprogrambatchsectionstructure();
    	var alProgramGrid = this.getMapfolderaddprogramgrid();
    	var selectionModel = alProgramGrid.getSelectionModel().getSelection();
    	
    	var alprogramgridIdsArr = [];
    	var programIdsArr = [];
    	selectionModel.forEach(function(obj){
    		if(alprogramgridIdsArr.indexOf(obj.get('academyLocationId')) == -1){
    			alprogramgridIdsArr.push(obj.get('academyLocationId'));
    		}
    		if(programIdsArr.indexOf(obj.get('programId')) == -1){
    			programIdsArr.push(obj.get('programId'));
    		}
    	});
    	
    	if(programIdsArr.length > 0){
    		var programbatchcontainer = mapfolderalprogrambatchsectionstructure.down('#programbatchcontainer');
    		programbatchcontainer.setDisabled(false);
    		mapfolderalprogrambatchsectionstructure.setActiveTab(programbatchcontainer);
    		var alProgramBatchGrid = this.getMapfolderaddprogrambatchgrid();
    		var alProgramBatchSearchCombo = alProgramBatchGrid.down('#programbatchsearchcombo');
    		alProgramBatchSearchCombo.reset();
    		alProgramBatchSearchCombo.getStore().getProxy().extraParams= {
    			academyLocationIds: alprogramgridIdsArr.join(),
    			programIds:programIdsArr.join()
    		};
    		alProgramBatchSearchCombo.getStore().load();
    		
    		var alProgramBatchGridStore = alProgramBatchGrid.getStore();
    		
    		alProgramBatchGridStore.getProxy().extraParams= {
    			programIds:programIdsArr.join()
	    	};
    		alProgramBatchGridStore.clearFilter();
    		alProgramBatchGridStore.load();
    		
    		this.setProgressTracker(2);
    	}
    	else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    programNextEventOnProgramBatchTabFolder: function(btn){
    	var mapfolderalprogrambatchsectionstructure = this.getMapfolderalprogrambatchsectionstructure();
    	var alProgramBatchGrid = this.getMapfolderaddprogrambatchgrid();
    	var selectionModel = alProgramBatchGrid.getSelectionModel().getSelection();

    	var batchIdsArr = [];
    	selectionModel.forEach(function(obj){
    		if(batchIdsArr.indexOf(obj.get('batchId')) == -1){
    			batchIdsArr.push(obj.get('batchId'));
    		}
    	});

    	if(batchIdsArr.length > 0){
    		var programbatchSeatTypecontainer = mapfolderalprogrambatchsectionstructure.down('#programBatchSectionContainer');
    		programbatchSeatTypecontainer.setDisabled(false);
    		mapfolderalprogrambatchsectionstructure.setActiveTab(programbatchSeatTypecontainer);
    		var alprogrambatchsectiongrid = this.getMapfolderaddprogrambatchsectiongrid();
    		var alProgramBatchSectionGridStore = alprogrambatchsectiongrid.getStore();
    		alProgramBatchSectionGridStore.getProxy().extraParams= {
    			batchIds:batchIdsArr.join()
    		};
    		alProgramBatchSectionGridStore.clearFilter();
    		alProgramBatchSectionGridStore.load();

    		this.setProgressTracker(3);
    	}
    	else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}

    },
    submitFolderMappingWithProgramBatch: function(btn){
    	var $this = this;
    	var contentPanel = this.getContentPanel();
    	var tabStructure = this.getMapfolderalprogrambatchsectionstructure();
    	var getcontroller= this.getController('menu.CoreERPNavigationController');
    	var activeGrid = tabStructure.getActiveTab().down('grid');
    	var selectedRecord = activeGrid.getSelectionModel().getSelection();
    	var mapalbumstructure = this.getMapalbumstructure();

    	var applyToGrid = this.getSharealbumgrid();

    	var galleryId = mapalbumstructure.down('#albumId').getValue();
    	var uploadedBy = this.getCurrentlyLoggedInUser().id;
    	var academyLocationId = this.getCurrentAcademyLocation();

    	var shareWith = mapalbumstructure.down('#shareAlbumWithItemId').query('[checked="true"]');
		var isSharedWithFaculty = false;
		var isSharedWithStudent = false;
		var isSharedWithParent = false;
		var isSharedWithAlumni = false;
		
		Ext.each(shareWith, function(currentShareWith){
//			if(currentShareWith.inputValue=="faculties"){
//				isSharedWithFaculty=true;
//			}else if(currentShareWith.inputValue=="students"){
//				isSharedWithStudent = true;
//			}else {
//				isSharedWithParent = true
//			}
			if(currentShareWith.inputValue=="faculties"){
				isSharedWithFaculty=true;
			}else if(currentShareWith.inputValue=="students"){
				isSharedWithStudent = true;
			}else if(currentShareWith.inputValue=="parents"){
				isSharedWithParent = true;
			}else {
				isSharedWithAlumni = true
			}
		});
    	var submitJsonArr;
    	var jsonBatchesArr = [];
    	
    	if(selectedRecord.length>0){
    		var submitUrl = SERVERURL.PATH_SAVE_ALL_SHARED_BATCH_MAPPING;

    		if(!isSharedWithFaculty && !isSharedWithStudent && !isSharedWithParent && !isSharedWithAlumni){
    			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_ANY_ONE_CHECKBOX_FROM_SHARED_FOLDER_WITH_MSG'));
    			return false;
    		}
    		if(activeGrid.xtype == 'mapfolderaddalgrid'){
    			selectedRecord.forEach(function(obj){
    				jsonBatchesArr.push(obj.get('id'));
    			});

    			submitJsonArr={
    					galleryId: galleryId,
    					uploadedBy: uploadedBy,
    					isSharedWithFaculty: isSharedWithFaculty,
    					isSharedWithStudent: isSharedWithStudent,
    					isSharedWithParent: isSharedWithParent,
    					isSharedWithAlumni:isSharedWithAlumni,
    					academyLocations: jsonBatchesArr.join()
    			}
    		}
    		else if(activeGrid.xtype == 'mapfolderaddprogramgrid'){
    			selectedRecord.forEach(function(obj){
    				jsonBatchesArr.push(obj.get('programId'));
    			});

    			submitJsonArr={
    					galleryId: galleryId,
    					uploadedBy: uploadedBy,
    					isSharedWithFaculty: isSharedWithFaculty,
    					isSharedWithStudent: isSharedWithStudent,
    					isSharedWithParent: isSharedWithParent,
    					isSharedWithAlumni:isSharedWithAlumni,
    					programs: jsonBatchesArr.join()
    			}
    		}
    		else if(activeGrid.xtype == 'mapfolderaddprogrambatchgrid'){ 
    			selectedRecord.forEach(function(obj){
    				jsonBatchesArr.push(obj.get('batchId'));
    			});

    			submitJsonArr={
    					galleryId: galleryId,
    					uploadedBy: uploadedBy,
    					isSharedWithFaculty: isSharedWithFaculty,
    					isSharedWithStudent: isSharedWithStudent,
    					isSharedWithParent: isSharedWithParent,
    					isSharedWithAlumni:isSharedWithAlumni,
    					batches: jsonBatchesArr.join()
    			}
    		}
    		else{
    			selectedRecord.forEach(function(obj){
    				jsonBatchesArr.push(obj.get('sectionId'));
    			});

    			submitJsonArr={
    					galleryId: galleryId,
    					uploadedBy: uploadedBy,
    					isSharedWithFaculty: isSharedWithFaculty,
    					isSharedWithStudent: isSharedWithStudent,
    					isSharedWithParent: isSharedWithParent,
    					isSharedWithAlumni:isSharedWithAlumni,
    					sections: jsonBatchesArr.join()
    			}
    		}

    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');

    		Ext.Ajax.request({
    			method: "POST",
    			type: 'rest',
    			url: submitUrl,
    			timeout:3000000,
    			jsonData:submitJsonArr,
    			success : function(response, action) {
    				Ext.getBody().unmask();
    				var data = response.responseText;

    				if(data != "false"){
    					var tabName = getCommonTranslation('MAP_FOLDER');
    					var getTab=getcontroller.getTab(tabName);
    					if(getTab!=null){
    						contentPanel.remove(getTab, true);
    					}

    					var shareAlbumStructure = Ext.widget('sharealbumstructure');
    					var tabName = getCommonTranslation('SHARE_FOLDER');

    					//Start code for open Apply To tab again with updated records 
    					var tabNameApplyTo = getCommonTranslation('SHARE_FOLDER');
    					var getTabApplyTo=getcontroller.getTab(tabNameApplyTo);
    					/*if(getTabApplyTo!=null){
							contentPanel.remove(getTabApplyTo, true);
						}*/

    					var shareAlbumGridStore = applyToGrid.getStore();
    					shareAlbumGridStore.getProxy().extraParams = {
    						galleryId : galleryId,
    						academyLocationId:academyLocationId,
    						sort: null
    					};
    					$this.resetGridSetting(applyToGrid);
    					shareAlbumGridStore.load();
    					/*var documentApplyToGridStore = applyToGrid.getStore();
						if(!isNullOrEmpty(committeeMappingId)){
							documentApplyToGridStore.getProxy().extraParams={
								templateId: recordsCommitteeGrid.get('templateId'),
								ownerId:recordsCommitteeGrid.get('ownerId'),
								documentTypeId: parseInt(recordsCommitteeGrid.get('documentTypeId')),
								configLevel:recordsCommitteeGrid.get('configLevel')
							};
						}
						$this.resetGridSetting(applyToGrid);
						$this.resetPageSetting(documentApplyToGridStore);
						documentApplyToGridStore.load();

						var structure = Ext.widget('documenttemplatemappingapplytotabstructure');

						var applyToALGrid = structure.query('documenttemplatemappingapplytogrid')[0];
						applyToALGrid.setVisible(false);

						var applyToGridProgramBatch = structure.query('documenttemplatemappingapplytoprogambatchgrid')[0];
						applyToGridProgramBatch.setVisible(true);

						openTab(contentPanel, tabNameApplyTo, structure,CONSTANTS.MENU_COLOR_NINE);*/
    					//End code for open Apply To tab again with updated records 
    					showSuccessMessage(getCommonTranslation('SHARE_FOLDER'),getCommonTranslation('FOLDER_HAS_BEEN_SHARED_SUCCESSFULLY_MSG'));
    				}

    			}
    		});
    	}
    	else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    changeAblSectionTypeRadioGroup : function(obj){
    	var  contentPanelMain = this.getContentPanel().getActiveTab();
    	contentPanelMain.scrollBy(0,1);
    	contentPanelMain.scrollBy(0,-1);
    	var courseSectionContainer = obj.up('sharealbumstructure');
    	var ablumComponentSectionContainerPBS = courseSectionContainer.down('#shareAlbumGridContainerFirst');
    	var ablumComponentSectionContainerCBS = courseSectionContainer.down('#shareAlbumGridContainerSecond');
    	var grid;
    	if(obj.getValue().ablSectionType=='CBS') {
    		ablumComponentSectionContainerPBS.hide();
    		ablumComponentSectionContainerCBS.show();
    		grid = ablumComponentSectionContainerCBS.down('tnssharealbumcoursesectiongrid');
    		grid.getStore().getProxy().extraParams= {
    			galleryId : courseSectionContainer.albumId,
				academyLocationId:this.getCurrentAcademyLocation(),
				sort: null,
    			isCBS: true
    		};
    		grid.getStore().load();
    	} else {
    		ablumComponentSectionContainerPBS.show();
    		ablumComponentSectionContainerCBS.hide();
    		 grid = ablumComponentSectionContainerPBS.down('sharealbumgrid');
    		grid.getStore().getProxy().extraParams= {
    			galleryId : courseSectionContainer.albumId,
				academyLocationId:this.getCurrentAcademyLocation(),
				sort: null,
    			isCBS: false
    		};
    		grid.getStore().load();
    	}
    },
    openCourseSectionMapAlbumStructure: function(btn){
		var me =this;
		var albumId = btn.up('sharealbumstructure').albumId;
		var albumName = btn.up('sharealbumstructure').albumName;
		var contentpanel = this.getContentPanel();
		var courseSectionShareAlbumStructure = Ext.widget('tnscoursesectionmapalbumstructure');
		var tabName = getCommonTranslation('MAP_FOLDER');
		var getcontroller=this.getController('menu.CoreERPNavigationController');
		var getTab=getcontroller.getTab(tabName);
		if(getTab!=null){
			contentpanel.remove(getTab, true);
		}
		openTab(contentpanel, tabName, courseSectionShareAlbumStructure,CONSTANTS.MENU_COLOR_NINE);
		var academylocationgrid = this.getCoursesectionmapfolderaddatgrid();
		academylocationgrid.getStore().clearFilter();
		academylocationgrid.getStore().load();
		me.getAdjustmentprogresstracker().setVisible(true);
  		me.resetCBSProgressTracker();
  		var adjustmentprogresstracker = me.getTnscoursesectionmapalbumstructure().down("#adjustmentprogresstracker");
  		var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
  		progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
  		progresstracker1.textEl.addCls("inProgressCss-progress-text");
  		progresstracker1.updateText("Step 1 In Progress");
  		courseSectionShareAlbumStructure.down('#sectionValueItemId').setValue(true);
  		courseSectionShareAlbumStructure.down('#albumId').setValue(albumId);
  		courseSectionShareAlbumStructure.down('#albumName').setValue(albumName);
	},
	academyTermsNextEventCourseFolder:function(btn){
    	var mapfolderalcoursesectionstructure = this.getMapfolderacademictermcoursesectionstructure();
    	var academyTermgrid = mapfolderalcoursesectionstructure.down('#coursesectionmapfolderaddatgridItemId');
    	var selectionModel = academyTermgrid.getSelectionModel().getSelection();
    	var academyTermIdsArr = [];
    	selectionModel.forEach(function(obj){
    		academyTermIdsArr.push(obj.get('id'));
    	});
    	if(academyTermIdsArr.length > 0){
    		var courseContainer = mapfolderalcoursesectionstructure.down('#courseContainerId');
    		courseContainer.setDisabled(false);
    		mapfolderalcoursesectionstructure.setActiveTab(courseContainer);
    		var aTCourseGrid = this.getCoursesectionmapfolderaddcoursegrid();
    		var aTCourseSearchCombo = aTCourseGrid.down('#coursesearchcombo');
    		aTCourseSearchCombo.reset();
    		aTCourseSearchCombo.getStore().getProxy().extraParams= {
    			academicTermIds: academyTermIdsArr.join(),
    			limit:-1,
    		};
    		aTCourseSearchCombo.getStore().load();
    		var aTCourseGridStore = aTCourseGrid.getStore();
    		
    		aTCourseGridStore.getProxy().extraParams= {
    			academicTermIds: academyTermIdsArr.join(),
    			limit:-1,
	    	};
    		aTCourseGridStore.clearFilter();
    		aTCourseGridStore.load();
    		this.setCBSProgressTracker(1);
    		
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    CourseNextEventOnCourseVariantTabFolder: function(btn){
    	var mapfolderaTcourseSectionstructure = this.getMapfolderacademictermcoursesectionstructure();
    	var aTCourseVariantGrid = this.getCoursesectionmapfolderaddcoursegrid();
    	var selectionModel = aTCourseVariantGrid.getSelectionModel().getSelection();
       
    	var academicTermIdsArr = [];
    	var courseVariantIdsArr = [];
    	selectionModel.forEach(function(obj){
    		if(academicTermIdsArr.indexOf(obj.get('academicTermId')) == -1){
    			academicTermIdsArr.push(obj.get('academicTermId'));
    		}
    		if(courseVariantIdsArr.indexOf(obj.get('courseId')) == -1){
    			courseVariantIdsArr.push(obj.get('courseId'));
    		}
    	});

    	if(courseVariantIdsArr.length > 0){
    		var courseVariantContainer = mapfolderaTcourseSectionstructure.down('#courseVariantContainer');
    		courseVariantContainer.setDisabled(false);
    		mapfolderaTcourseSectionstructure.setActiveTab(courseVariantContainer);
    		var CourseVariantgrid = this.getCoursesectionmapfolderaddcoursevariantgrid();
    		var aTCourseSearchCombo = CourseVariantgrid.down('#coursevariantsearchcombo');
    		aTCourseSearchCombo.reset();
    		aTCourseSearchCombo.getStore().getProxy().extraParams= {
    			courseIds:courseVariantIdsArr.join(),
    			academicTermIds: academicTermIdsArr.join()
    		};
    		aTCourseSearchCombo.getStore().load();
    		var CourseVariantgridStore = CourseVariantgrid.getStore();
    		CourseVariantgridStore.getProxy().extraParams= {
    			courseIds:courseVariantIdsArr.join(),
    			academicTermIds:academicTermIdsArr.join(),
				limit:-1
    		};
    		CourseVariantgridStore.clearFilter();
    		CourseVariantgridStore.load();

    		this.setCBSProgressTracker(2);
    	}
    	else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}

    },
	setCBSProgressTracker : function(progresstracker){
    	var structure = this.getTnscoursesectionmapalbumstructure();
    	var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");

    	var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
    	var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
    	var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");
		
    	if(progresstracker==1){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker1.updateProgress((i * 0.1), '');
    		}
    		progresstracker1.textEl.addCls("custom-progress-text");
    		progresstracker1.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker2.textEl.removeCls("x-progress-text x-progress-text-back");
    		progresstracker2.textEl.addCls("inProgressCss-progress-text");
    		progresstracker2.updateText("Step 2 In Progress");
    		progresstracker1.updateText(getCommonTranslation('STEP_1_COMPLETE'));
    	}
    	if(progresstracker==2){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker2.updateProgress((i * 0.1), '');
    		}
    		progresstracker2.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker2.textEl.addCls("custom-progress-text");
    		progresstracker2.updateText(getCommonTranslation('STEP_2_COMPLETE'));
    		
    		progresstracker3.textEl.removeCls("x-progress-text x-progress-text-back");
			progresstracker3.textEl.addCls("inProgressCss-progress-text");
			progresstracker3.updateText("Step 3 In Progress");
    	}
    	
    },
	resetCBSProgressTracker : function(){
    	var structure = this.getTnscoursesectionmapalbumstructure();
    	var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");
    	var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
    	var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
    	var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");
    	progresstracker1.reset();
    	progresstracker1.updateText('');
    	progresstracker2.reset();
    	progresstracker2.updateText('');
    	progresstracker3.reset();
    	progresstracker3.updateText('');
    },
    submitFolderMappingWithCourseCode: function(btn){
    	var $this = this;
    	var contentPanel = this.getContentPanel();
    	var tabStructure = this.getMapfolderacademictermcoursesectionstructure();
    	var getcontroller= this.getController('menu.CoreERPNavigationController');
    	var activeGrid = tabStructure.getActiveTab().down('grid');
    	var selectedRecord = activeGrid.getSelectionModel().getSelection();
    	var mapalbumstructure = this.getTnscoursesectionmapalbumstructure();

    	var applyToGrid = this.getTnssharealbumcoursesectiongrid();

    	var galleryId = mapalbumstructure.down('#albumId').getValue();
    	var IsCBSValue = mapalbumstructure.down('#sectionValueItemId').getValue();
    	var uploadedBy = this.getCurrentlyLoggedInUser().id;
    	var academyLocationId = this.getCurrentAcademyLocation();

    	var shareWith = mapalbumstructure.down('#shareAlbumWithItemId').query('[checked="true"]');
		var isSharedWithFaculty = false;
		var isSharedWithStudent = false;
		var isSharedWithParent = false;
		
		Ext.each(shareWith, function(currentShareWith){
			if(currentShareWith.inputValue=="faculties"){
				isSharedWithFaculty=true;
			}else if(currentShareWith.inputValue=="students"){
				isSharedWithStudent = true;
			}else {
				isSharedWithParent = true
			}
		});
    	var submitJsonArr;
    	var jsonBatchesArr = [];
    	var jsonTerm=[];
    	
    	if(selectedRecord.length>0){
    		var submitUrl = SERVERURL.PATH_SAVE_ALL_SHARED_BATCH_MAPPING;

    		if(!isSharedWithFaculty && !isSharedWithStudent && !isSharedWithParent){
    			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_ANY_ONE_CHECKBOX_FROM_SHARED_FOLDER_WITH_MSG'));
    			return false;
    		}
    		if(activeGrid.xtype == 'coursesectionmapfolderaddcoursegrid'){
    			selectedRecord.forEach(function(obj){
    				jsonBatchesArr.push(obj.get('courseId'));
    			});
    			selectedRecord.forEach(function(obj){
    				jsonTerm.push(obj.get('academicTermId'));
    			});
    			submitJsonArr={
    					galleryId: galleryId,
    					uploadedBy: uploadedBy,
    					isSharedWithFaculty: isSharedWithFaculty,
    					isSharedWithStudent: isSharedWithStudent,
    					isSharedWithParent: isSharedWithParent,
    					courseIds: jsonBatchesArr.join(),
    					academicTermIds: jsonTerm.join(),
    					isCBS:true
    			}
    		}
    		else{
    			selectedRecord.forEach(function(obj){
    				jsonBatchesArr.push(obj.get('sectionId'));
    			});
    			submitJsonArr={
    					galleryId: galleryId,
    					uploadedBy: uploadedBy,
    					isSharedWithFaculty: isSharedWithFaculty,
    					isSharedWithStudent: isSharedWithStudent,
    					isSharedWithParent: isSharedWithParent,
    					sections: jsonBatchesArr.join(),
    					isCBS:true
    			}
    		}
    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		Ext.Ajax.request({
    			method: "POST",
    			type: 'rest',
    			url: submitUrl,
    			timeout:3000000,
    			jsonData:submitJsonArr,
    			success : function(response, action) {
    				Ext.getBody().unmask();
    				var data = response.responseText;
    				if(data != "false"){
    					var tabName = getCommonTranslation('MAP_FOLDER');
    					var getTab=getcontroller.getTab(tabName);
    					if(getTab!=null){
    						contentPanel.remove(getTab, true);
    					}

    					var shareAlbumStructure = Ext.widget('sharealbumstructure');
    					var tabName = getCommonTranslation('SHARE_FOLDER');

    					var tabNameApplyTo = getCommonTranslation('SHARE_FOLDER');
    					var getTabApplyTo=getcontroller.getTab(tabNameApplyTo);
    					var shareAlbumGridStore = applyToGrid.getStore();
    					shareAlbumGridStore.getProxy().extraParams = {
    						galleryId : galleryId,
    						academyLocationId:academyLocationId,
    						sort: null,
    						isCBS:true
    					};
    					$this.resetGridSetting(applyToGrid);
    					shareAlbumGridStore.load();
    					showSuccessMessage(getCommonTranslation('SHARE_FOLDER'),getCommonTranslation('FOLDER_HAS_BEEN_SHARED_SUCCESSFULLY_MSG'));
    				}

    			}
    		});
    	}
    	else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    deleteCBSShareAlbumGridItems: function(btn){
		var me =this;
		var grid=btn.up('grid');
		
		if(grid.getSelectionModel().getSelection().length>0){
			var id=grid.getSelectionModel().getSelection()[0].data.id
			showConfirmMessage(getCommonTranslation('SHARE_FOLDER'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
				if (btn == 'yes') {
					Ext.Ajax.request({
						type: 'rest',
						url: SERVERURL.PATH_DELETE_SHARED_BATCH_MAPPING+'?id='+id,
						method: 'DELETE',
						headers: {
							'Content-Type': 'application/json'
						},
						success: function(form, action) {
							var extraParams = grid.getStore().getProxy().extraParams;
							extraParams.sort = null;
							grid.getStore().getProxy().extraParams = extraParams;
							grid.getStore().load({
								callback: function(records){
									if(grid.getStore().pageSize>records.length){
										grid.down('custompagingtoolbar').hide();
									}
									else{
										grid.down('custompagingtoolbar').show();
									}
								}
							});
						}
					});
				}
			});
		}else{
		  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	  }
	},
	openGalleryLinkUploadWin:function(btn){
		var me =this;
		var structure;
		var grid=btn.up('grid');
		var editWindow = me.getHyperlinkeditwindow();
		if (!editWindow) {
			Ext.widget('hyperlinkeditwindow');
			editWindow = me.getHyperlinkeditwindow();
		}
		editWindow.show();
		
    	if(portalId ==1){
    		structure=Ext.ComponentQuery.query('managegallerystructure')[0];
    	}else{
    		structure=Ext.ComponentQuery.query('viewgallerystructure')[0];
    	}
		var albumId = structure.down('#btnEditImage').config.albumId;
		
		if(this.whetherListView){
			var grid = this.getMyfolderfilegrid();
			var selectedRecord = grid.getSelectionModel().getSelection()[0];
			var hyperLinkEditWin = Ext.ComponentQuery.query('hyperlinkeditwindow')[0];
			hyperLinkEditWin.down('#id').setValue(selectedRecord.data.id);
			hyperLinkEditWin.down('#labelOfHyperlinkId').setValue(selectedRecord.data.labelOfHyperlink);
			hyperLinkEditWin.down('#addHyperlinkId').setValue(selectedRecord.data.addHyperlink);
		}else{
			var managGalleryStore = Ext.create('Academia.store.facilitiesresources.managegallery.ManageGalleryStore');
			managGalleryStore.getProxy().extraParams = {
				galleryId : albumId
			};
			managGalleryStore.load({
				callback: function(records, operation, success){
					if(records.length>0){
						var hyperLinkId;
						for(var i=0;i<records.length;i++){
							var checkBox = document.getElementById(records[i].data.id);
							if(checkBox.checked && records[i].data.imageName=="link"){
								hyperLinkId = records[i].data.id;
							}
						}
						var selectedRecord = this.findRecord("id",hyperLinkId);
						var hyperLinkEditWin = Ext.ComponentQuery.query('hyperlinkeditwindow')[0];
						hyperLinkEditWin.down('#id').setValue(selectedRecord.data.id);
						hyperLinkEditWin.down('#labelOfHyperlinkId').setValue(selectedRecord.data.labelOfHyperlink);
						hyperLinkEditWin.down('#addHyperlinkId').setValue(selectedRecord.data.addHyperlink);
					}
				}
			});
		}
	},
	updateHyperLinkData:function(win){
		var me = this;
		var formData = win.down('form').getValues();
		var json = {
				"addHyperlink": formData.addHyperlink,
				"id":formData.id,
				"labelOfHyperlink":formData.labelOfHyperlink
		};
		var jsonData = Ext.encode(json);
		Ext.Ajax.request({
            type: 'rest',
            url:SERVERURL.PATH_UPDATE_FOR_HYPERLINK,
			jsonData: jsonData,
            method: 'POST',
            success: function(response, action) {
            	me.isUpdateHyperLinkCase=true;
                var responseData = Ext.decode(response.responseText);
        		var managGalleryStore = Ext.create('Academia.store.facilitiesresources.managegallery.ManageGalleryStore');
        		var editWindow = me.getHyperlinkeditwindow();
        		
        		if(portalId ==1){
        			 me.onAlbumBtnClick(me.albumMyFolderBtns);
        			 Ext.ComponentQuery.query('managegallerystructure')[0].down('#btnEditImage').setDisabled(true);
            	}else{
            		me.onAlbumBtnClick2(me.albumMyFolderBtns);
            		 Ext.ComponentQuery.query('viewgallerystructure')[0].down('#btnEditImage').setDisabled(true);
            	}
                showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
                editWindow.close();
            }
        });
	}
});
