/**
 *kamlesh kumar chilhate
 */
Ext.define('Academia.controller.facultyCourseInterest.FacultyCourseInterestController', {
	extend: 'Academia.controller.base.BaseController',
	stores: [
		'coursetransaction.sectionmanagement.AssignClassTeacherSmartSearch',
		'resourceutilization.FacultyInterestReportGridStore',
		'course.CourseCESMCodeStoreFromCSM',
		'personinfo.common.course.CourseListExceptCurrentEquivalenceStore',
		'personinfo.common.course.CourseComponentListExceptIdsStore',
		'lecturercostingdefinition.ActionReasonStore',
		'lecturercostingdefinition.HighestQualificationGridStore'
	],
    model: ['resourceutilization.FacultyInterestReportGridModel'
           ],
	views: ['facultyCourseInterest.FacultyInterestReportSearch','facultyCourseInterest.FacultyInterestReportStructure','facultyCourseInterest.FacultyInterestReportGrid',
		'Academia.view.facultyCourseInterest.ApproveWindow','Academia.view.facultyCourseInterest.DeclineWindow','Academia.view.facultyCourseInterest.HighestQualificationWindow'
		,'Academia.view.facultyCourseInterest.HighestQualificationDetails','Academia.view.facultyCourseInterest.HighestQualificationInnerGrid'
	       ],
	config: {
		FACULTY_INTEREST_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_INTEREST_REPORT_PRIVILEGES'),
		FIR_HIGHEST_QUALIFICATION_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FIR_HIGHEST_QUALIFICATION_PRIVILEGES'),
		},
		refs: [{
			ref: 'facultyinterestreportgrid',
			selector: 'facultyinterestreportgrid'
		},{
			ref: 'facultyinterestreportsearch',
			selector: 'facultyinterestreportsearch'
		},{
			ref: 'facultyniterestreportstructure',
			selector: 'facultyniterestreportstructure'
		},{
			ref: 'resourceutilizationstructure',
			selector: 'resourceutilizationstructure'
		},{
			ref: 'resourceutilizationsearch',
			selector: 'resourceutilizationsearch'
		},{
			ref: 'resourceutilizationgrid',
			selector: 'resourceutilizationgrid'
		},{
			ref: 'eventparticipantwindow',
			selector: 'eventparticipantwindow'
		},{
			ref: 'eventparticipantgrid',
			selector: 'eventparticipantgrid'
		},{
	    	 ref : 'approvewindow',
	    	 selector : 'approvewindow'
	     },{
	    	 ref : 'declinewindow',
	    	 selector : 'declinewindow'
	     },{
	    	 ref : 'highestqualificationwindow',
	    	 selector : 'highestqualificationwindow'
	     },{
	    	 ref : 'highestqualificationinnergrid',
	    	 selector : 'highestqualificationinnergrid'
	     },{
	    	 ref : 'highestqualificationdetails',
	    	 selector : 'highestqualificationdetails'
	     }],
		init: function(application) {
			this.control({
				'facultyinterestreportgrid button[itemId=approveBtnId]':{
					 click: function(btn) {
	    				 var $this = this;
	    				 var grid = btn.up('grid');
	    				 if (grid.getSelectionModel().getCount() > 0) {
	    					 this.showApproveWindow();
	    				 }else{
	    					 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	    				 }
	    			 }
	    			 
	    			 
					/*click: function(btn) {
						var $this = this;
						var grid = btn.up('grid');
						var allRecords = grid.getSelectionModel().getSelection();
						var facultyInterestIds=[];
						var isAllreadyApproved=false;
						if(allRecords !=undefined && allRecords.length > 0){
							for(var i in allRecords){
								if(allRecords[i].get("secondCheck")){
									isAllreadyApproved=true;
								}
								if(Ext.isObject(allRecords[i])){
									facultyInterestIds.push(allRecords[i].get("id"));
								}else{
									facultyInterestIds.push(allRecords[i]);
								}
							}
							if(isAllreadyApproved){
								showWarningMessage(getCommonTranslation('FACULTY_INTEREST_REPORT'), getCommonTranslation('INTEREST_ALREADY_APPROVED'));
							    return false;
							}
							 Ext.Ajax.request({
								type : 'rest',
								url :SERVERURL.PATH_APPROVE_FACULTY_INTEREST,
								params : {
									facultyInterestId:facultyInterestIds.join()
								},
								method : 'GET',
								async: true,
								success : function(response) {
									if(response.responseText=='SUCCESS'){
										grid.store.load();
									 showSuccessMessage(getCommonTranslation('FACULTY_INTEREST_REPORT'), getCommonTranslation('DETAILS_SAVED_SUCCESSFULLY'));	
									}
								}
							});
						}else{
							showWarningMessage(getCommonTranslation('FACULTY_INTEREST_REPORT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
						}
					}*/
				},
				
				'facultyinterestreportgrid button[itemId=declineBtnId]':{
					 click: function(btn) {
	    				 var $this = this;
	    				 var grid = btn.up('grid');
	    				 if (grid.getSelectionModel().getCount() > 0) {
	    					 this.showDeclineWindow();
	    				 }else{
	    					 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	    				 }
	    			 }
   			 },
				
				'facultyinterestreportsearch button[itemId=searchBtn]':{
					click: function() {
						var $this = this;
						var searchForm =$this.getFacultyinterestreportsearch();
							searchForm.down('#searchBtn').setDisabled(true);
						var grid = this.getFacultyinterestreportgrid();
						var store = grid.getStore();
						var values = searchForm.getValues();
						var coursesId = values.courses;
						var programCesmCodeId = values.programCesm;
						var courseCESMCodeId = values.courseCesm;
						var facultyNameItemId = values.facultyId;
						var approvalStatus = values.approvalStatus;
						var coursesIds=[];
						var courseIds; 
						if(coursesId !=undefined && coursesId.length > 0){
							for(var i in coursesId){
								if(Ext.isObject(coursesId[i])){
									coursesIds.push(coursesId[i].get("categoryId"));
								}else{
									coursesIds.push(coursesId[i]);
								}
							}
							courseIds = coursesIds.join();
						} else {
							coursesIds.push(coursesId);
							courseIds = coursesIds.join();
						}
						

						var componentsIds=[];
						var componentIds; 
						if(coursesId !=undefined && coursesId.length > 0){
							for(var i in coursesId){
								if(Ext.isObject(coursesId[i])){
									componentsIds.push(coursesId[i].get("id"));
								}else{
									componentsIds.push(coursesId[i]);
								}
							}
							componentIds = componentsIds.join();
						} else {
							componentsIds.push(coursesId);
							componentIds = componentsIds.join();
						}
						


						var courseCESMCodeIds=[];
						var coursecesmIds; 
						
						if(courseCESMCodeId !=undefined && courseCESMCodeId.length > 0){
							for(var i in courseCESMCodeId){
								if(Ext.isObject(courseCESMCodeId[i])){
									courseCESMCodeIds.push(courseCESMCodeId[i].get("id"));
								}else{
									courseCESMCodeIds.push(courseCESMCodeId[i]);
								}
							}
							coursecesmIds = courseCESMCodeIds.join();
						} else {
							courseCESMCodeIds.push(courseCESMCodeId);
							coursecesmIds = courseCESMCodeIds.join();
						}
						
						
						var submitURL = SERVERURL.PATH_GET_FACULTY_INTEREST_REPORT_LIST;
						store.getProxy().api.read=submitURL;
						store.getProxy().extraParams = {
							facultyId:facultyNameItemId,
							coursecesmId:coursecesmIds,
							programCesmId:programCesmCodeId,
							courseIds : courseIds,
							componentIds : componentIds,
							status:approvalStatus
						};
						this.resetPageSetting(store);
						store.load({
							   callback: function(records, operation, success) {
								   searchForm.down('#searchBtn').setDisabled(false);
							   }
						});
					}
				},
				'facultyinterestreportgrid':{
					render : function(grid){
						//this.doAccessControlValidation(grid, this.getFACULTY_INTEREST_REPORT_PRIVILEGES());
						this.approveButtonPermission(grid,this.getFACULTY_INTEREST_REPORT_PRIVILEGES());
					},
					afterrender: function(grid) {
                    var me = this;
                     grid.down('#approveBtnId').setDisabled(true); 
                     grid.down('#declineBtnId').setDisabled(true); 
                    setTimeout(function(){
                        me.addDataGridConfigButton(grid,me.getFACULTY_INTEREST_REPORT_PRIVILEGES());
                    },3000);

                },
				selectionchange: function(column, selected,eOpts ){    
                    var $this = this;
                      var grid = $this.getFacultyinterestreportgrid();
                      
                      var selectionModel = grid.getSelectionModel().getSelection();
                      
                      if(selectionModel.length==0){
                          grid.down('#approveBtnId').setDisabled(true);    
                          grid.down('#declineBtnId').setDisabled(true); 
                      }
                      else{
                    	  if(selectionModel[0].data.cityName == "Approved" || selectionModel[0].data.cityName == "Declined"){
                    		  grid.down('#approveBtnId').setDisabled(true);  
                              grid.down('#declineBtnId').setDisabled(true); 
                    	  }else{
                          grid.down('#approveBtnId').setDisabled(false);  
                          grid.down('#declineBtnId').setDisabled(false); 
                    	  }
                      }
                },cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					var $this=this;
					var facultyGrid = $this.getFacultyinterestreportgrid();
					var columnName=facultyGrid.columnManager.columns[cellIndex].dataIndex;

					if(columnName=='highestQual'){
						this.showHighestQualificationWindowGrid(record,facultyGrid);
					}	
					
				}
				},
				'highestqualificationinnergrid':{
					afterrender:function(grid){
						var me = this;
						setTimeout(function(){
							me.addDataGridConfigButton(grid,me.getFIR_HIGHEST_QUALIFICATION_PRIVILEGES());
						},1500);
						var facultyIntrestReportGrid=this.getFacultyinterestreportgrid();
						var qualificationGrid=this.getHighestqualificationinnergrid();
						var qualificationDetails=this.getHighestqualificationdetails();
						var data=facultyIntrestReportGrid.getSelectionModel().getSelection()[0];
						qualificationDetails.down("#facultyNameItemId").setValue(data.raw.value);
						qualificationGrid.store.getProxy().extraParams = {
							userId:data.raw.batchId
						};
						qualificationGrid.store.load();
						facultyIntrestReportGrid.getSelectionModel().deselectAll();

					}
				},
				'facultyinterestreportsearch button[itemId=resetBtn]':{
					click: function() {
						var this$ = this;
						var form = this$.getFacultyinterestreportsearch();
						var courseId = form.down("#coursesId");
						var courseCESMCodeId = form.down("#courseCESMCodeId");
						var courseId = form.down("#coursesId");
						var facultyNameItemId = form.down("#facultyNameItemId");
						var programCESMCodeId = form.down("#programCESMCodeId");
						courseId.clearValue();
						courseCESMCodeId.clearValue();
						facultyNameItemId.clearValue();
						programCESMCodeId.clearValue();
						courseId.getStore().getProxy().extraParams = {}
						courseId.getStore().load();
					}
				},
				'facultyinterestreportsearch multiselectcombofield[itemId=courseCESMCodeId]': {
				 change: function(combo, records, eOpts) {
					var this$ = this;
					var form = combo.up("form");
					var courseId = form.down("#coursesId");
					var courseCESMCodeIds = form.down('multiselectcombofield#courseCESMCodeId').getValue();
					
					var courseCESMCodeIdsArr=[];
					
					 if(!isNullOrEmpty(courseCESMCodeIds)) {
		        		 Ext.each(courseCESMCodeIds,function(courseCESMCodeId){
		        			 if(typeof courseCESMCodeId=="number"){
		        				 courseCESMCodeIdsArr.push(courseCESMCodeId);
		        			 }
		        			 else{
		        				 courseCESMCodeIdsArr.push(courseCESMCodeId.data.id);
		        			 }
		        		 });
		        	 }
		        	 
		        	var courseCESMCodeIdsString= courseCESMCodeIdsArr.join();
					
					courseId.clearValue();
					courseId.getStore().getProxy().extraParams = {
						courseCESMCode:courseCESMCodeIdsString
					}
					courseId.getStore().load({
							   callback: function(records, operation, success) {
								   if (success) {
									   if(records.length==1){
										courseId.setValue(records[0].get("id"));
									   }
								   }
							   }
						   });
					}
				},
				'facultyinterestreportsearch customcombobox[itemId=facultyNameItemId]': {
					 select: function(combo, records, eOpts) {
						var this$ = this;
						var form = combo.up("form");
						var programCESMCodeId = form.down("#programCESMCodeId");
						programCESMCodeId.clearValue();
						programCESMCodeId.getStore().getProxy().extraParams = {
							facultyId:records[0].data.personId
						}
						programCESMCodeId.getStore().load({
								   callback: function(records, operation, success) {
									   if (success) {
										   if(records.length==1){
											   programCESMCodeId.setValue(records[0].get("id"));
										   }
									   }
								   }
							   });
						}
					},'facultyinterestreportsearch customcombobox[itemId=programCESMCodeId]': {
						 select: function(combo, records, eOpts) {
								var this$ = this;
								var form = combo.up("form");
								var courseId = form.down("#coursesId");
								var courseCESMCodeId = form.down("#courseCESMCodeId");
								courseCESMCodeId.clearValue();
								courseCESMCodeId.getStore().getProxy().extraParams = {
									programCESMCodeId:records[0].data.id
								}
								courseCESMCodeId.getStore().load({
										   callback: function(records, operation, success) {
											   if (success) {
												   if(records.length==1){
													   courseCESMCodeId.setValue(records[0].get("id"));
													   courseId.getStore().getProxy().extraParams = {
															courseCESMCode:records[0].get("id")
														}
														courseId.getStore().load({
																   callback: function(records, operation, success) {
																	   if (success) {
																		   if(records.length==1){
																			courseId.setValue(records[0].get("id"));
																		   }
																	   }
																   }
															   });
												   }
												   
												  
											   }
										   }
									   });
								}
							},
				'facultyinterestreportsearch [itemId=coursesId]': {
					 afterrender: function(combo, records, eOpts) {
						var this$ = this;
						var form = combo.up("form");
						var courseId = form.down("#coursesId");
						courseId.getStore().on('beforeload', function(str){
							str.proxy.extraParams.isFacultyIntrestReport = true;
						})
						
				}
				},
				'declinewindow button[itemId=declineCancelBtn]':{
					click: function(btn) {
						this.getDeclinewindow().destroy();
					}
				},
				
				'declinewindow button[itemId=declineSubmitBtn]':{
					click: function(btn) {
						var $this = this;
						var grid = this.getFacultyinterestreportgrid();
						var allRecords = grid.getSelectionModel().getSelection();
						var win = this.getDeclinewindow();
						var actionReason = win.down('#actionReasonId').getValue();
						var comments = win.down('#comments').getValue();
						var facultyInterestIds=[];
						var isAllreadyApproved=false;
						if(allRecords !=undefined && allRecords.length > 0){
							for(var i in allRecords){
								if(allRecords[i].get("secondCheck")){
									isAllreadyApproved=true;
								}
								if(Ext.isObject(allRecords[i])){
									facultyInterestIds.push(allRecords[i].get("id"));
								}else{
									facultyInterestIds.push(allRecords[i]);
								}
							}
							if(isAllreadyApproved){
								showWarningMessage(getCommonTranslation('FACULTY_INTEREST_REPORT'), getCommonTranslation('INTEREST_ALREADY_APPROVED'));
							    return false;
							}
							 Ext.Ajax.request({
								type : 'rest',
								url :SERVERURL.PATH_APPROVE_FACULTY_INTEREST,
								params : {
									facultyInterestId:facultyInterestIds.join(),
									actionReasonId:actionReason,
									comments:comments,
									status:"DECLINED"
								},
								method : 'GET',
								async: true,
								success : function(response) {
									if(response.responseText=='SUCCESS'){
										grid.store.load();
									 showSuccessMessage(getCommonTranslation('FACULTY_INTEREST_REPORT'), getCommonTranslation('DETAILS_SAVED_SUCCESSFULLY'));
									 win.close();
									}
								}
							});
						}else{
							showWarningMessage(getCommonTranslation('FACULTY_INTEREST_REPORT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
						}
					}
				},
				
				'approvewindow button[itemId=CancelBtn]':{
					click: function(btn) {
						this.getApprovewindow().destroy();
					}
				},
				
				'approvewindow button[itemId=approveSubmitBtn]':{
					click: function(btn) {
						var $this = this;
						var grid = this.getFacultyinterestreportgrid();
						var allRecords = grid.getSelectionModel().getSelection();
						var win = this.getApprovewindow();
						var actionReason = win.down('#actionReasonId').getValue();
						var comments = win.down('#comments').getValue();
						var facultyInterestIds=[];
						var isAllreadyApproved=false;
						if(allRecords !=undefined && allRecords.length > 0){
							for(var i in allRecords){
								if(allRecords[i].get("secondCheck")){
									isAllreadyApproved=true;
								}
								if(Ext.isObject(allRecords[i])){
									facultyInterestIds.push(allRecords[i].get("id"));
								}else{
									facultyInterestIds.push(allRecords[i]);
								}
							}
							if(isAllreadyApproved){
								showWarningMessage(getCommonTranslation('FACULTY_INTEREST_REPORT'), getCommonTranslation('INTEREST_ALREADY_APPROVED'));
							    return false;
							}
							 Ext.Ajax.request({
								type : 'rest',
								url :SERVERURL.PATH_APPROVE_FACULTY_INTEREST,
								params : {
									facultyInterestId:facultyInterestIds.join(),
									actionReasonId:actionReason,
									comments:comments,
									status:"APPROVED"
								},
								method : 'GET',
								async: true,
								success : function(response) {
									if(response.responseText=='SUCCESS'){
										grid.store.load();
									 showSuccessMessage(getCommonTranslation('FACULTY_INTEREST_REPORT'), getCommonTranslation('DETAILS_SAVED_SUCCESSFULLY'));
									 win.close();
									}
								}
							});
						}else{
							showWarningMessage(getCommonTranslation('FACULTY_INTEREST_REPORT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
						}
					}
				}
			});
		},
		approveButtonPermission:function(grid,permissionMap){
			var associatedAcadLocationIds = new Array();
			associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);

			var approveBtn = grid.down('#approveBtnId');
			approveBtn.setVisible(false);

			var declineBtn = grid.down('#declineBtnId');
			declineBtn.setVisible(false);

			Ext.each(permissionList, function(privilege) {

				if (privilege === 'APPROVE') {
					if(!isNullOrEmpty(approveBtn)){
						approveBtn.setVisible(true);
					}                
				}

				if (privilege === 'DECLINE') {
					if(!isNullOrEmpty(declineBtn)){
						declineBtn.setVisible(true);
					}                
				}
			});

		},
		loadResourceRecord : function(val) {

			var $this=this;
	    	var form = $this.getResourceutilizationsearch();
	    	form.down('#searchBtn').setDisabled(true);
			var grid = this.getResourceutilizationgrid();
			var searchForm = this.getResourceutilizationsearch().getForm();
			var alId = this.getCurrentAcademyLocation();
			var values = searchForm.getValues();
			var store = grid.getStore();
			var roomId = values.room;
			if(isNullOrEmpty(roomId)){
				roomId = values.resources;
			}
			var facultyId = values.faculty;
			var facultyIds=[];
			var facultyUserIds; 
			if(facultyId !=undefined && facultyId.length > 0){
				for(var i in facultyId){
					if(Ext.isObject(facultyId[i])){
						facultyIds.push(facultyId[i].get("id"));
					}else{
						facultyIds.push(facultyId[i]);
					}
				}
				facultyUserIds = facultyIds.join();
			} else {
				facultyIds.push(facultyId);
				facultyUserIds = facultyIds.join();
			}
			var fromDate = values.fromDate;
			var toDate = values.toDate;
			var fromTime = values.fromTime;
			var toTime = values.toTime;
			var day = values.weekDay;
			var userId = values.userName;
			var eventName = values.eventName;
			var bookingPurposeId = values.bookingPurpose;
			var academyLocationId = values.academyLocation;
			var alIds=[];
			var academyLocationIds; 
			if(academyLocationId !=undefined && academyLocationId.length > 0){
				for(var i in academyLocationId){
					if(Ext.isObject(academyLocationId[0])){
						alIds.push(academyLocationId[i].get("id"));
					}else{
						alIds.push(academyLocationId[i]);
					}
				}
				academyLocationIds = alIds.join();
			} else {
				alIds.push(alId);
				academyLocationIds = alIds.join();
			}
			var pbs = '2';
			var submitURL = null;
			if(val == 'detailedTimetable'){
				submitURL=SERVERURL.PATH_GET_RESOURCE_UTILIZATION_REPORT;
			}else if(val == 'event'){
				submitURL=SERVERURL.PATH_GET_RESOURCE_UTILIZATION_EVENT_REPORT;
			}else {
				submitURL=SERVERURL.FIND_MASTER_TIME_TABLE_SESSION_PBSC;
			}
			store.getProxy().api.read=submitURL;
			store.getProxy().extraParams = {
				roomId:roomId,
				facultyId:facultyUserIds,
				academyLocationIds : academyLocationIds,
				startDate:fromDate,
				endDate:toDate,
				fromTime:fromTime,
				toTime:toTime,
				pbs : '2',
				day: day,
				userId : userId,
				eventName : eventName,
				bookingPurposeId : bookingPurposeId
			};
			this.resetPageSetting(store);
			store.load({
				   callback: function(records, operation, success) {
					   form.down('#searchBtn').setDisabled(false);
				   }
			});

			grid.config.searchFilterForm = form;
		},
		
		showApproveWindow : function(){
	       	 var formWindow = this.getApprovewindow();
	       	 if (isNullOrEmpty(formWindow)) {
	       		
	       		 formWindow =  Ext.widget('approvewindow');
	       	 }
	       	var approveActionStore=formWindow.down('#actionReasonId').getStore();
	       	approveActionStore.getProxy().extraParams = {
	       		status:"APPROVAL"
	       	};
	       	approveActionStore.load();
	       	 formWindow.show();
	     },
	     
	     showDeclineWindow : function(){
	       	 var formWindow = this.getDeclinewindow();
	       	 if (isNullOrEmpty(formWindow)) {
	       		
	       		 formWindow =  Ext.widget('declinewindow');
	       	 }
	       	var approveActionStore=formWindow.down('#actionReasonId').getStore();
	       	approveActionStore.getProxy().extraParams = {
	       		status:"DECLINED"
	       	};
	       	approveActionStore.load();
	       	 formWindow.show();
	     }, 
	     showHighestQualificationWindowGrid : function(record,grid){
	    	var me=this;
	 		var window =  this.getHighestqualificationwindow();
	 		if (!window) {
	 			Ext.widget('highestqualificationwindow');
	 			window = this.getHighestqualificationwindow();
	 		}
	 		if(grid.getSelectionModel().getCount()!=1){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
				}else{
	 		window.show();
				}
	 	}
	    
});
