/**
 * @author Akshay Sharma
 * 
 */
var sessionNumber = "";
Ext.define('Academia.controller.facultyportal.attendance.FacultyCaptureAttendanceController', {
	extend: 'Academia.controller.base.BaseController',
	models : [
		'attendance.StudentAttendanceList','attendance.StudentAttendance','attendance.StudentCourses',
		'attendance.SectionByCourseNComponent','attendance.AttendanceFacultyList',
		'attendance.StudentCourseAttendance','attendance.StudentServiceAttendance'
		],
		stores : ['attendance.facultyportal.DetailedTimeSlotList','attendance.facultyportal.AttendanceProgramStore','attendance.StudentAttendanceType','common.ProgramByAcademyLocationStore','enquiry.AcademicBatchStore',
			'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod','attendance.StudentAttendanceStatus',
			'attendance.SectionAndFacultyByPeriodID','attendance.StudentAttendanceList','attendance.StudentCourses','course.courseequivalence.CourseComponentEquivalenceStore',
			'attendance.SectionByCourseNComponent','attendance.AllProgramMappedByCourse','common.BatchesByProgramId',
			'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod','attendance.AttendanceFacultyList',
			'attendance.TimeSlotList','attendance.CourseLevelFacultyBlank','importutility.ImportUtilityList','importutility.ImportListByModule',
			'course.coursecomponent.CourseComponentCouseWise','importutility.ModuleName','attendance.AttendanceCountStore','attendance.FacultyGridCompleteNMultipleSession',
			'attendance.FacultyTimeSlot','course.coursevariants.CourseVariantStore', 'attendance.SectionTypeComboStore', 'coursetransaction.sectionmanagement.CoruseSectionStore',
			'course.coursetopic.CourseComponentStore', 'coursetransaction.facultytopicassignment.CourseSectionByIDStore', 'coursetransaction.facultytopicassignment.FacultyDetails',
			'coursetransaction.facultytopicassignment.AssignFacultyStore', 'attendance.SectionByVariant', 'coursetransaction.homework.CourseVarientByCourseIdDropDown',
			'attendance.StudentAttendanceTopic', 'importutility.ImportUtilityAttendanceList', 'importutility.importUtilityCourseLevelAttendanceList',
			'attendance.AssignedCoursesFacultyStore', 'attendance.AssignedCoursesFacultyBySectionTypeStore','common.AssignedProgramStore','common.ClassTeacherProgramStore',
			'common.AcademicTermStore','attendance.AttendanceMarkingTypeStore','attendance.MultipleSessionValueStore','course.coursevariants.ParameterCourseVariantStore',
			'attendance.FacultyServiceStore','attendance.BatchByServiceStore'],
			views : ['facultyPortal.attendance.FacultyCaptureAttendanceMasterStructure', 'facultyPortal.attendance.StudentCaptureAttendanceStructure',
				'facultyPortal.attendance.CaptureAttendanceGrid','facultyPortal.attendance.CaptureAttendanceCountGrid',
				'facultyPortal.attendance.ProgramwiseCaptureAttendanceSearch','facultyPortal.attendance.MultipleSessionwiseCaptureAttendanceSearch',
				'facultyPortal.attendance.CoursewiseCaptureAttendanceSearch','facultyPortal.attendance.StudentCaptureAttendanceUploadDownloadStructureForFaculty','facultyPortal.attendance.ImportUtilityStudentAttendanceList',
		           'facultyPortal.attendance.UploadStudentAttendanceForm','facultyPortal.attendance.DownloadStudentAttendanceForm',
		           'attendance.OtherEmployeAndadminAttendanceStructure','attendance.OtherEmployeeAttendance',
		           'attendance.AdminGridForSession', 'facultyPortal.attendance.StudentCourseLevelAttendanceUploadDownloadStructureForFaculty', 'facultyPortal.attendance.DownloadStudentCourseLevelAttendanceForm',
		           'facultyPortal.attendance.UploadStudentCourseLevelAttendanceForm', 'facultyPortal.attendance.ImportUtilityStudentCourseLevelAttendanceList',
		           'attendance.DownloadCourseLevelAttendancePBSForm', 'attendance.DownloadCourseLevelAttendanceCBSForm',
		           'UploadOptionRadioGroup','attendance.GenrateQrCodeFacultyPortal','attendance.QRCodeWindow',
		           'facultyPortal.attendance.ServicewiseCaptureAttendanceSearch','facultyPortal.attendance.CaptureAttendanceInnerGrid'
				],
				requires:['Ext.ux.InputTextMask','Academia.model.attendance.AttendanceQRModel'],	
				config: {
					ATTENDANCE_ENTRY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ATTENDANCE_ENTRY_PRIVILEGES'),
					ATTENDANCE_ENTRY_FACULTY_PORTAL_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ATTENDANCE_ENTRY_FACULTY_PORTAL_PRIVILEGES'),
					CORE_ERP_LOADER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_LOADER_PRIVILEGES'),
					FACULTY_PORTAL_LOADER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_LOADER_PRIVILEGES')
				},
				refs : [{
					ref : 'contentPanel',
			    	selector : 'contentpanel'
				},{
					ref : 'facultycaptureattendancemasterstructure',
					selector : 'facultycaptureattendancemasterstructure'
				},{
					ref : 'studentcaptureattendancestructure',
					selector : 'studentcaptureattendancestructure'
				},{
					ref : 'programwisecaptureattendancesearch',
					selector : 'programwisecaptureattendancesearch'
				},{
					ref : 'multiplesessionwisecaptureattendancesearch',
					selector : 'multiplesessionwisecaptureattendancesearch'
				},{
					ref : 'coursewisecaptureattendancesearch',
					selector : 'coursewisecaptureattendancesearch'
				},{
					ref : 'captureattendancegrid',
					selector : 'captureattendancegrid'
				},{
					ref : 'captureattendancecountgrid',
					selector : 'captureattendancecountgrid'
				},{
					ref : 'studentcaptureattendanceuploaddownloadstructureforfaculty',
					selector : 'studentcaptureattendanceuploaddownloadstructureforfaculty'
				},{
					ref : 'importutilityStudentattendancelist',
					selector : 'importutilityStudentattendancelist'
				},{
					ref : 'downloadstudentattendanceform',
					selector : 'downloadstudentattendanceform'
				},{
					ref : 'uploadstudentattendanceform',
					selector : 'uploadstudentattendanceform'
				},{
					ref : 'studentcourselevelattendanceuploaddownloadstructureforfaculty',
					selector : 'studentcourselevelattendanceuploaddownloadstructureforfaculty'
				},{
					ref : 'downloadstudentcourselevelattendanceform',
					selector : 'downloadstudentcourselevelattendanceform'
				},{
					ref : 'uploadstudentcourselevelattendanceform',
					selector : 'uploadstudentcourselevelattendanceform'
				},{
					ref : 'importutilitystudentcourselevelattendancelist',
					selector : 'importutilitystudentcourselevelattendancelist'
				},
				{
			   		ref : 'uploadoptionradiogroup',
			   		selector : 'uploadoptionradiogroup[itemId=studentattendanceListUploadOptionRadioGroupItemId]'
			   	},{
					ref : 'genrateqrcodefacultyportal',
					selector : 'genrateqrcodefacultyportal'
				},{
					ref: 'qrcodewindow',
					selector: 'qrcodewindow'
				},
				{
				ref: 'servicewisecaptureattendancesearch',
				selector: 'servicewisecaptureattendancesearch'
				},{
					ref: 'captureattendanceinnergrid',
					selector: 'captureattendanceinnergrid'
				}
			],
				init : function() {
					this.control({
						'facultycaptureattendancemasterstructure':{
							beforerender:function(structure){
								var $this = this;
								var academyLocationId = this.getCurrentAcademyLocation();

								var studentAttendanceType = [];
								var attendanceType=[];
								var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
								if(!isNullOrEmpty(attendanceTypess.data.COMPLETE_DAY) && attendanceTypess.data.COMPLETE_DAY.academyLocationId == academyLocationId) {
									attendanceType.push(attendanceTypess.data.COMPLETE_DAY.studentAttendanceType);
								} else {
									var authenticationController = Academia.app.getController('Academia.controller.authentication.AuthenticationController');
									authenticationController.loadMultipleLangFilePerAL(academyLocationId);
									attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
									if(!isNullOrEmpty(attendanceTypess.data.COMPLETE_DAY)) {
										attendanceType.push(attendanceTypess.data.COMPLETE_DAY.studentAttendanceType);
									}
								}
								if(!isNullOrEmpty(attendanceTypess.data.MULTIPLE_SESSION)) {
									attendanceType.push(attendanceTypess.data.MULTIPLE_SESSION.studentAttendanceType);
								}
								if(!isNullOrEmpty(attendanceTypess.data.COURSE_LEVEL)) {
									attendanceType.push(attendanceTypess.data.COURSE_LEVEL.studentAttendanceType);
								}
								if(!isNullOrEmpty(attendanceTypess.data.SERVICE_LEVEL)) {
									attendanceType.push(attendanceTypess.data.SERVICE_LEVEL.studentAttendanceType);
								}
								if(attendanceType.length > 0){
									studentAttendanceType=attendanceType.join();
								} else {
									showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ATTENDANCE_SETTING_NOT_DONE'));
								}
								var permissionsMap = new Ext.util.HashMap();
								permissionsMap = this.getATTENDANCE_ENTRY_FACULTY_PORTAL_PRIVILEGES();
								var associatedAcadLocationIds = new Array();
								associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
								var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
								var tab2=false, tab3=false,tab4=false;
								for (var i = 0; i < permissionList.length; i++) {
									if (permissionList[i] === "IMPORTATTENDANCE") {
										tab2=true;
									}
									if (permissionList[i] === "IMPORTATTENDANCE") {
										tab4=true;
									}
									if (permissionList[i] === "IMPORTCOURSELEVELATTENDANCE") {
										tab3=true;
									}
								}
								Ext.suspendLayouts();
								$this.checkTabPermission(tab2, tab3, structure,tab4,attendanceType,permissionList);
								Ext.resumeLayouts();
							} 
						},
						'studentcaptureattendancestructure radiogroup[itemId=newAttendanceTypeRadio]':{
							change : function(obj,record){
								this.onChangeAttedanceType(obj,record); 
							}
						},
						'programwisecaptureattendancesearch customcombobox[itemId=facultyAttendanceProgramId]':{
							select: function(obj, record) {
								var $this = this;
								var forms = $this.getCaptureattendancegrid();
								forms.down('#markOnlyAttendance_Id').items.items[0].setValue(false);
								forms.down('#markOnlyAttendance_Id').items.items[1].setValue(false);
								$this.getCaptureattendancegrid().down('grid').getStore().removeAll();
								$this.getCaptureattendancecountgrid().getStore().removeAll();
								this.getStudentcaptureattendancestructure().down('#submitBtn').setDisabled(true);
							}
						},
						'programwisecaptureattendancesearch datefield[itemId=completeDayDate_Id]':{
							change: function(obj, record) {
								var $this = this;
								try{
									var forms = $this.getCaptureattendancegrid();
									forms.down('#markOnlyAttendance_Id').items.items[0].setValue(false);
									forms.down('#markOnlyAttendance_Id').items.items[1].setValue(false);
									this.getCaptureattendancegrid().down('grid').getStore().removeAll();
									this.getCaptureattendancecountgrid().getStore().removeAll();
									this.getStudentcaptureattendancestructure().down('#submitBtn').setDisabled(true);
								} catch (e){
									
								}
							}
						},
						'programwisecaptureattendancesearch button[itemId=searchBtn]':{
							click: this.loadCaptureAttendanceStudentGrid,
						},
						'multiplesessionwisecaptureattendancesearch button[itemId=searchBtn]':{
							click: this.loadCaptureAttendanceStudentGrid,
						},
						'coursewisecaptureattendancesearch button[itemId=searchBtn]':{
							click: this.loadCaptureAttendanceStudentGrid,
						},
						'programwisecaptureattendancesearch button[itemId=resetBtn]':{
							click: this.resetStudentAttendanceForm
						},
						'multiplesessionwisecaptureattendancesearch button[itemId=resetBtn]':{
							click: this.resetStudentAttendanceForm
						},
						'coursewisecaptureattendancesearch button[itemId=resetBtn]':{
							click: this.resetStudentAttendanceForm
						},
						'programwisecaptureattendancesearch button[itemId=GENRATEQR]':{
	        					  click: this.genrateQrCodeForFacultyPortal
						},
						'coursewisecaptureattendancesearch button[itemId=viewQR]':{
							click: this.viewQrCodeForFacultyPortal
						},
                      'coursewisecaptureattendancesearch button[itemId=GENRATEQR]':{
	        					  click: this.genrateQrCodeForFacultyPortal
	        		   },
	        		   'multiplesessionwisecaptureattendancesearch button[itemId=GENRATEQR]':{
	        			   click: this.genrateQrCodeForFacultyPortal
	        		   },
	        		   'genrateqrcodefacultyportal button[itemId=generateQRWinBtnItemId]':{
	        			   click: function(btn){
	        				   var $this=this;

	        				   var structure = $this.getStudentcaptureattendancestructure();
	        				   var attendanceType = structure.down('#newAttendanceTypeRadio').getValue().newAttendanceTypeWise;
	                           //var endTime = btn.up('window').down('#toTime').getValue(); //using this for expiry of QR code
	                           var duration = btn.up('window').down('#expirytime').getValue();
	                           
	                           if(duration == "00:00:00"){
	                        	   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('EXPIRY_TIME_CANNOT_BE_ZERO'));
	                        	   return false;
	                           }

	                           if (!isValidDuration(duration)) {
	                        	   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('CALENDAR_HOLIDAY_VALIDATION'));
	                        	   return false;
	                           }
	                           
	                           //var endTimeTimePart = Ext.Date.format(endTime, 'H:i:s');

	        				   if((attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY')){
	        					   var attendancesearchstrucure =  $this.getProgramwisecaptureattendancesearch();

	        					   var sectionId = attendancesearchstrucure.down('#facultyAttendanceProgramId').getValue();
	        					   var selectedRecord = attendancesearchstrucure.down('#facultyAttendanceProgramId').findRecordByValue(sectionId).data;
	        					   var programId = selectedRecord.programId;
	        					   var batchId = selectedRecord.batchId;
	        					   var periodId = selectedRecord.periodId;
	        					   var attendanceDate = attendancesearchstrucure.down('#completeDayDate_Id').getValue();
	        					   var facultyId = this.getCurrentlyLoggedInUser().id;
        						   var facultyName = this.getCurrentlyLoggedInUser().value;
        						   var sessionNo = null;
        						   
        						   var programName = selectedRecord.value.split(" / ")[0];
        						   var batchName = selectedRecord.value.split(" / ")[1];
        						   var periodName = selectedRecord.value.split(" / ")[2];
        						   var sectionName = selectedRecord.value.split(" / ")[3];
        						   
        						   var attendanceModel = new Academia.model.attendance.AttendanceQRModel();
	        					   attendanceModel.set('academyLocationId', this.getCurrentAcademyLocation());
		        				   attendanceModel.set('attendanceType', attendanceType);
		        				   attendanceModel.set('batchId', batchId);
		        				   attendanceModel.set('dateOfAttendance', attendanceDate);
		        				   attendanceModel.set('facultyId', facultyId);
		        				   attendanceModel.set('id', null);
		        				   attendanceModel.set('periodId', periodId);
		        				   attendanceModel.set('programId', programId);
		        				   attendanceModel.set('sectionId', sectionId);
		        				   attendanceModel.set('sessionNo', sessionNo);
		        				   attendanceModel.set('qrCodeExpiryTime', duration);
		        				   var submitUrl =SERVERURL.PATH_ATTENDANCE_CAPTURE_QR_SAVE;
	        				   }
	        				   else if((attendanceType == 'Multiple Session' || attendanceType == 'MULTIPLE_SESSION')){
	        					   var attendancesearchstrucure =  $this.getMultiplesessionwisecaptureattendancesearch();
	        					   
	        					   var sectionId = attendancesearchstrucure.down('#session_programBatch_programId').getValue();
	        					   var selectedRecord = attendancesearchstrucure.down('#session_programBatch_programId').findRecordByValue(sectionId).data;
	        					   var programId = selectedRecord.programId;
	        					   var batchId = selectedRecord.batchId;
	        					   var periodId = selectedRecord.periodId;
	        					   var attendanceDate = attendancesearchstrucure.down('#session_dateOfAttendance_Id').getValue();
	        					   var facultyId = this.getCurrentlyLoggedInUser().id;
        						   var facultyName = this.getCurrentlyLoggedInUser().value;
	        					   var sessionNo = attendancesearchstrucure.down('#newSessionItemId').getValue();
	        					   
	        					   var programName = selectedRecord.value.split(" / ")[0];
        						   var batchName = selectedRecord.value.split(" / ")[1];
        						   var periodName = selectedRecord.value.split(" / ")[2];
        						   var sectionName = selectedRecord.value.split(" / ")[3];
	        					   
	        					   var attendanceModel = new Academia.model.attendance.AttendanceQRModel();
	        					   attendanceModel.set('academyLocationId', this.getCurrentAcademyLocation());
		        				   attendanceModel.set('attendanceType', attendanceType);
		        				   attendanceModel.set('batchId', batchId);
		        				   attendanceModel.set('dateOfAttendance', attendanceDate);
		        				   attendanceModel.set('facultyId', facultyId);
		        				   attendanceModel.set('id', null);
		        				   attendanceModel.set('periodId', periodId);
		        				   attendanceModel.set('programId', programId);
		        				   attendanceModel.set('sectionId', sectionId);
		        				   attendanceModel.set('sessionNo', sessionNo);
		        				   attendanceModel.set('qrCodeExpiryTime', duration);
		        				   var submitUrl =SERVERURL.PATH_ATTENDANCE_CAPTURE_QR_SAVE;
	        				   }
	        				   else{
	        					   var attendancesearchstrucure =  $this.getCoursewisecaptureattendancesearch();
	        					   
	        					   var facultyId = this.getCurrentlyLoggedInUser().id;
        						   var facultyName = this.getCurrentlyLoggedInUser().value;
        						   var sessionPlanningDone=false;
        						   var fromTime=null;
	        					   var toTime=null;
	        					   var attendanceDate=null;

	        					   var courseVariantId = attendancesearchstrucure.down('#courseVariantId').getValue();
	        					   var courseVariantStore = attendancesearchstrucure.down('#courseVariantId').getStore();
	        					   var selectedData  = courseVariantStore.findRecord('id', courseVariantId).data;
	        					   var courseId = selectedData.courseId;
	        					   var courseComponentId = selectedData.courseComponentId;
	        					   if(!isNullOrEmpty(selectedData.parentCourseId)) {
	        						   courseId = selectedData.parentCourseId;
	        					   } 
	        					   var sectionIds = selectedData.sectionId;
	        					   var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
	        					   var data = attendanceTypess.data.COURSE_LEVEL;
	        					   var attendanceSlot=data.attendanceSlot;
	        					   
	        					   var courseVariantName =  attendancesearchstrucure.down('#courseVariantId').getDisplayValue();
	        					   
	        					   var adhocRequired=false;
	        					 /*  if(attendanceTypess.data.COURSE_LEVEL.whetherAdhocRequired){
	        						   var adhocRequired = attendanceTypess.data.COURSE_LEVEL.whetherAdhocRequired;
	        					   }*/
	        					   if(attendanceSlot=="TIME_TABLE_SLOTS"){
	        						   sessionPlanningDone=true;
	        						   
	        						   var ccpId = attendancesearchstrucure.down('#timetableSlotListId').getValue();
	        						   if(!isNullOrEmpty(ccpId) && ccpId.length>0){
	        							   var timeSlotStore = attendancesearchstrucure.down('#timetableSlotListId').getStore();
	        							   if(typeof ccpId[0]=="object"){
	        								   var currentCcpId = ccpId[0].data.id;
	        							   }
	        							   else{
	        								   var currentCcpId = ccpId[0];
	        							   }
	        							   if(isNullOrEmpty(currentCcpId)){
	        								   adhocRequired=true;
	        							   }else{
	        								   var data = timeSlotStore.findRecord('id', currentCcpId).data;
	        								   attendanceDate = Ext.Date.format(new Date(data.sessionDate), 'Y-m-d');
	        								   fromTime = data.fromTime;
	        								   toTime =  data.toTime;
	        							   }
	        						   }else{
	        							   adhocRequired=true;
	        						   }

	        					   }else if(attendanceSlot=="CALENDAR_SLOTS" || attendanceSlot=="AD_HOC_SLOTS"){
	        						   var timeSlot = attendancesearchstrucure.down('#calendarSlotListId').getValue();
	        						   attendanceDate = attendancesearchstrucure.down('#dateOfAttendance_Id').getValue();
	        						   if(!isNullOrEmpty(timeSlot) && timeSlot.length>0 && !isNullOrEmpty(timeSlot[0].data)){
	        							   var timeSlotStore = attendancesearchstrucure.down('#calendarSlotListId').getStore();
	        							   var data = timeSlotStore.findRecord('id', timeSlot[0].data.id).data;
	        							   var tokens = data.value.split(' - ');
	        							   fromTime = tokens[0];
	        							   toTime = tokens[1];
	        						   }else{
	        							   adhocRequired=true;
	        						   }
	        					   }
	        					   var startTime = null;
	        					   if(adhocRequired){
	        						   attendanceDate = attendancesearchstrucure.down('#dateOfAttendance_Id').getValue();
	        						   var formValuesData = attendancesearchstrucure.getForm().getValues();
	        						   
	        						   var startTime = btn.up('window').down('#fromTime').getValue(); //using this for expiry of QR code
    		                           var startTimeTimePart = Ext.Date.format(startTime, 'H:i:s');
    		                           var endTime1 =  btn.up('window').down('#toTime1').getValue(); //using this for expiry of QR code
    		                           var endTime1TimePart = Ext.Date.format(endTime1, 'H:i:s');
    		                           
    		                           var toTime1 = null;
    		                           if(!isNullOrEmpty(startTime)){
        		                           var fromTime = startTimeTimePart;
    		        					   var toTime1 = endTime1TimePart;
    		                           }
	        					   }
	        					   
	        					   var attendanceModel = new Academia.model.attendance.StudentCourseAttendance();
	        					   attendanceModel.set('academyLocationId', $this.getCurrentAcademyLocation());
	        					   attendanceModel.set('attendanceType', attendanceType);
	        					   attendanceModel.set('dateOfAttendance', attendanceDate);
	        					   attendanceModel.set('facultyId', facultyId);
	        					   attendanceModel.set('attendanceMarkedBy', facultyId);
	        					   attendanceModel.set('isMobile', false);
	        					   attendanceModel.set('sessionPlanningDone', sessionPlanningDone);
	        					   attendanceModel.set('facultyConflictCheck', "false");
	        					   if(adhocRequired){
		        					   attendanceModel.set('slotFrom', fromTime);
		        					   attendanceModel.set('slotTo', toTime1);
		        					   attendanceModel.set('fromTime', fromTime);
		        					   attendanceModel.set('toTime', toTime1);
		        					   attendanceModel.set('adhocSlot', true);
	        					   }
	        					   else{
	        						   attendanceModel.set('slotFrom', fromTime);
		        					   attendanceModel.set('slotTo', toTime);
		        					   attendanceModel.set('fromTime', "");
		        					   attendanceModel.set('toTime', "");
		        					   attendanceModel.set('adhocSlot', false);
	        					   }
	        					   attendanceModel.set('courseId', courseId);
	        					   attendanceModel.set('courseVariantId', courseVariantId);
	        					   attendanceModel.set('sectionId', sectionIds);
	        					   attendanceModel.set('componentId', courseComponentId);
		        				   attendanceModel.set('qrCodeExpiryTime', duration);
	        					   var submitUrl =SERVERURL.PATH_ATTENDANCE_COURSE_CAPTURE_QR_SAVE;
	        					   
	        				   }
	        				   //var endTime = btn.up('window').down('#toTime').getValue(); //using this for expiry of QR code
	        				   var duration = btn.up('window').down('#expirytime').getValue();

	        				   var formData = Ext.encode(attendanceModel.data);
	        				   
	        				   Ext.Ajax.request({
	        					   type : 'rest',
	        					   url : submitUrl,
	        					   method : 'POST',
	        					   async: false,
	        					   jsonData : formData,
	        					   success : function(form1, action) {
	        						   if(form1.responseText != 0){
        								   btn.up('window').close();
        								   var qrDataModel = {};
        								   if((attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY')){
        									   qrDataModel.qrData = {
        											   qrId: form1.responseText,
        											   academyLocationId: $this.getCurrentAcademyLocation(),
        											   attendanceType: attendanceType,
        											   batchId: batchId,
        											   dateOfAttendance: attendanceDate,
        											   facultyId: facultyId,
        											   id: null,
        											   periodId: periodId,
        											   programId: programId,
        											   sectionId: sectionId,
        											   sessionNo: sessionNo,
		        									   //endTime: endTime,
        											   duration: duration
        									   };
        									   
        									   var qrDisplayData = programName + ' | ' + batchName + ' | '+ periodName + ' | ' + sectionName + ' | '+ facultyName +' | '+ dateRender(attendanceDate);
        								   }
        								   else if((attendanceType == 'Multiple Session' || attendanceType == 'MULTIPLE_SESSION')){
        									   qrDataModel.qrData = {
        											   qrId: form1.responseText,
        											   academyLocationId: $this.getCurrentAcademyLocation(),
        											   attendanceType: attendanceType,
        											   batchId: batchId,
        											   dateOfAttendance: attendanceDate,
        											   facultyId: facultyId,
        											   id: null,
        											   periodId: periodId,
        											   programId: programId,
        											   sectionId: sectionId,
        											   sessionNo: sessionNo,
		        									   //endTime: endTime,
        											   duration: duration
        									   };

        									   var qrDisplayData = programName + ' | ' + batchName + ' | '+ periodName + ' | ' + sectionName + ' | '+ facultyName +' | '+ dateRender(attendanceDate);
        								   }
        								   else{
        									   qrDataModel.qrData = {
        											   qrId: form1.responseText,
        											   academyLocationId: $this.getCurrentAcademyLocation(),
        											   attendanceType: attendanceType,
        											   dateOfAttendance: attendanceDate,
        											   facultyId: facultyId,
        											   adhocSlot: false,
        											   attendanceMarkedBy: facultyId,
        											   isMobile: false,
        											   sessionPlanningDone: sessionPlanningDone,
        											   facultyConflictCheck: "false",
        											   slotFrom: fromTime,
        											   slotTo: toTime,
        											   fromTime: "",
        											   toTime: "",
        											   courseId: courseId,
        											   courseVariantId: courseVariantId,
        											   sectionId: sectionIds,
		        									   //endTime: endTime,
        											   duration: duration
        									   };
        									   
        									   if(adhocRequired){
        										   qrDataModel.qrData.slotFrom = fromTime;
        										   qrDataModel.qrData.slotTo = toTime1;
        										   qrDataModel.qrData.fromTime = fromTime;
        										   qrDataModel.qrData.toTime = toTime1;
        										   qrDataModel.qrData.adhocSlot = true;
        										   var qrDisplayData = courseVariantName + ' | ' + fromTime + ' - ' + toTime1 + ' | ' + facultyName + ' | ' + dateRender(attendanceDate);
        		        					   }
        									   else{
            									   var qrDisplayData = courseVariantName + ' | ' + fromTime + ' - ' + toTime + ' | ' + facultyName + ' | ' + dateRender(attendanceDate);
        									   }

        								   }
        								   var formWindow =  $this.getQrcodewindow();
        								   if (!formWindow) {
        									   Ext.widget('qrcodewindow',{
        										   qrData: Ext.encode(qrDataModel.qrData),
        										   qrDisplayData: qrDisplayData,
        									   });
        									   formWindow =  $this.getQrcodewindow();
        								   }
        								   formWindow.show();
        							   }
	        						   else{
	        							   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('QR_ALREADY_GENERATED'));
	        						   }
	        					   }
	        				   });


	        			   }
	        		   },
	        		   'qrcodewindow':{
	        			   afterrender: function(win){
	        				   if(win.itemId == 'attendanceViewFacultyQRWin'){
	        					   return;
	        				   }
	        				   var me = this;
	        				   var qrData = win.qrData;
	        				   var qrDisplayData = win.qrDisplayData;
	        				   var qrDataJson = Ext.decode(qrData);
	        				   var base64EncodedQRData = qrDataJson.attendanceType + '|' + qrDataJson.qrId; //Base64.encode(qrData);
	        				   var qrCodeImg = generateQr(base64EncodedQRData, '', "");
	        				   var attendanceType = qrDataJson.attendanceType;
	        				   
	        				   var attendanceQRCode = '';
	        				   if(attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY'){
	        					   attendanceQRCode = 'CD'; //CompleteDay
	        				   }
	        				   else if(attendanceType == 'Multiple Session' || attendanceType == 'MULTIPLE_SESSION'){
	        					   attendanceQRCode = 'MS'; //MultipleSessions
	        				   }
	        				   else{
	        					   attendanceQRCode = 'CW'; //CourseWise
	        				   }
	        				   
	        				   var acedemyLocationName = me.getAcademyLocationDisplayName(me.getCurrentAcademyLocation());
	        				   
	        				   var printBtmVals = Object.values(qrDataJson);
	        				   
	        				   win.down('#qrALLabelCls').setText(acedemyLocationName);
	        				   win.down('#qrOtherTxtLabelCls').setText(qrDisplayData);
	        				   
	        				   if(Ext.query('#'+win.id+' #qrcodetext').length){
	        					   Ext.query('#'+win.id+' #qrcodetext')[0].innerText=attendanceQRCode+'-'+qrDataJson.qrId;
	        				   }
	        				   
	        				   if((attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY') || (attendanceType == 'Multiple Session' || attendanceType == 'MULTIPLE_SESSION')){
	        					   var submitUrl = SERVERURL.PATH_ATTENDANCE_CAPTURE_QR_SAVE  
	        				   }
	        				   else{
	        					   var submitUrl = SERVERURL.PATH_ATTENDANCE_COURSE_CAPTURE_QR_SAVE;
	        				   }
	        				   setTimeout(function(){
	        					   //debugger;
	        					   var base64Src = Ext.query('#qrcode img')[0].src;
	        					   
	        					   Ext.Ajax.request({
		        					   type : 'rest',
		        					   url : submitUrl ,
		        					   method : 'POST',
		        					   async: false,
		        					   jsonData : {
		        						   'attendanceQRCode': base64Src,
		        						   'duration': qrDataJson.duration,
		        						   'id': qrDataJson.qrId,
		        						   'attendanceType': qrDataJson.attendanceType
		        					   },
		        					   success : function(form1, action) {
		        						   //debugger;
                                           if(form1.responseText == "SUCCESS"){
                                               showSuccessMessage(getCommonTranslation('GENERATE_QR'), getCommonTranslation('QR_GENERATED_SUCCESSFULLY'));
                                               me.resetStudentAttendance();
                                               me.downloadQRDivAsImage(win);
                                           }
                                           else{
                                                win.close();
                                                showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('Error while generating QR! Please regenerate.'));
                                           }
		        					   }
	        					   });
	        				   },500);
	        					   //-- Saving Generated QR Here
	        				   }
	        		   },
	        		   'genrateqrcodefacultyportal textfield[itemId=expirytime]':
	        		   {
	        			   change:function(obj)

	        			   {     
	        				   var expirytimevalue=obj.getValue();
	        				   if(expirytimevalue=='00:00')
	        				   {
	        					   obj.setValue('00:01');	
	        				   }
	        			   }

	        		   }	,
						'coursewisecaptureattendancesearch customcombobox[itemId=academicTerm]':{
							change: function(obj, record){
								var me = this;
								var form = obj.up('form');
								var academicTermId = obj.getValue();
								if(academicTermId > 0) {
									this.academicTermSelection(form, academicTermId);
								}
							}
						},
						'coursewisecaptureattendancesearch customcombobox[itemId=courseVariantId]':{
							change: function(obj, record){
								var me = this;
								var form = obj.up('form');
								var courseVariantId = obj.getValue();
								if(!isNullOrEmpty(courseVariantId) && !isNaN(courseVariantId)) {
									try{
										var calendarId = obj.getStore().findRecord('id',courseVariantId).data.calendarId;
										me.courseVariantSelection(form, courseVariantId, calendarId);
									} catch(e){
										obj.getStore().load({
											callback: function(records, operation, success) {
												if (success) {
													var calendarId = obj.getStore().findRecord('id',courseVariantId).data.calendarId;
													me.courseVariantSelection(form, courseVariantId, calendarId);
												}
											}
										});
									}
								} else {
									form.down("#topicId").clearValue();
									form.down("#topicId").reset();
									form.down("#topicId").setDisabled(true);
								}
							}
						},
						'coursewisecaptureattendancesearch button[itemId=timeBtnAdd]' : {
							click : this.adhocTimeSlotFieldsAdd
						},
						'servicewisecaptureattendancesearch button[itemId=timeBtnAdd]' : {
							click : this.adhocTimeSlotFieldsAddService
						},
						'servicewisecaptureattendancesearch button[itemId=timeBtnAdd1]' : {
							click : this.adhocTimeSlotFieldsAddService
						},
						'coursewisecaptureattendancesearch button[itemId=timeBtnAdd1]' : {
							click : this.adhocTimeSlotFieldsAdd
						},
						'coursewisecaptureattendancesearch button[itemId=timeBtnDelete1]' : {
							click : function(deleteButton) {
								this.deleteAdhocTimeSlotContainer(deleteButton)
							}
						},
						'servicewisecaptureattendancesearch button[itemId=timeBtnDelete1]' : {
							click : function(deleteButton) {
								this.deleteAdhocTimeSlotContainerService(deleteButton)
							}
						},
						'coursewisecaptureattendancesearch datefield[itemId=dateOfAttendance_Id]':{
							change: function(obj, record) {
								var form = obj.up('form');
								this.getCaptureattendancegrid().down('grid').getStore().removeAll();
								this.getCaptureattendancecountgrid().getStore().removeAll();
								this.getStudentcaptureattendancestructure().down('#submitBtn').setDisabled(true);
								var calendarTimeSlot = form.down('#calendarSlotListId');
								var attendanceDate = record;
								var validDate = Date.parse(attendanceDate);
								var courseVariantId = form.down('#courseVariantId').getValue();
								var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
								var timeSlotPanel = form.down('#panelId');
								var date = form.down('#dateOfAttendance_Id');
								if(!isNullOrEmpty(attendanceTypess.data.COURSE_LEVEL)){
									if(attendanceTypess.data.COURSE_LEVEL.whetherAdhocRequired){
										if (timeSlotPanel != null && !timeSlotPanel.items.items[0].isHidden()) {
											for(var i=timeSlotPanel.items.length;i>=0;i--){
												if(i==0){
													timeSlotPanel.items.items[i].setVisible(true);
												}else{
													timeSlotPanel.remove(timeSlotPanel.items.items[i]);
												}
												this.hideShowTimeSlotElement(timeSlotPanel);
											}
										}
										form.down('#fromTime').reset();
										form.down('#toTime').reset();
										form.down('#fromTime').setDisabled(false);
										form.down('#toTime').setDisabled(false);
										form.down('#fromTime').allowBlank=false;
										form.down('#toTime').allowBlank=false;
									}
								}
								
								form.down('#fromTime').setMaxValue(null);
								form.down('#toTime').setMinValue(null);
								calendarTimeSlot.clearValue();
								calendarTimeSlot.setDisabled(true);
								if(!isNullOrEmpty(courseVariantId) && !isNaN(validDate)) {
									if(calendarTimeSlot != null && !calendarTimeSlot.isHidden()){
									var calendarId = form.down('#courseVariantId').getStore().findRecord('id',courseVariantId).data.calendarId;
									calendarTimeSlot.setDisabled(false);
									var calendarTimeSlotStore = calendarTimeSlot.getStore();
									calendarTimeSlotStore.getProxy().extraParams = {
										calendarId : calendarId,
										attendanceDate : attendanceDate
									};
									calendarTimeSlotStore.load();
									
									}
								}
								if(!isNullOrEmpty(attendanceTypess.data.COURSE_LEVEL) && attendanceTypess.data.COURSE_LEVEL.attendanceSlot=="TIME_TABLE_SLOTS"){
									var timeTableSlot = form.down('#timetableSlotListId');
									timeTableSlot.setDisabled(true);
								}
								var dateVal = date.getValue();
								var newDate = null;
								Ext.Ajax.request({
									type : 'rest',
									url :SERVERURL.PATH_FIND_SERVER_DATE_TIME,
									method : 'GET',
									async: false,
									success : function(form1, action) {
										data = Ext.JSON.decode(form1.responseText);
										newDate=data.serverDateTimeYYYYMMDDTweentyFourHour;
										newDate = new Date(newDate)
										var fromTime = form.down('#fromTime');
										if(dateVal.getDate() == newDate.getDate()){
											var time = moment(newDate).format("HH:mm"); 
											fromTime.setMaxValue(time);
										}else{
											fromTime.setMaxValue(false);
										}
									}});
							}
						},
						'coursewisecaptureattendancesearch multiselectcombofield[itemId=timetableSlotListId]':{
							change: function(obj, record) {
								var $this = this;
								this.getCaptureattendancegrid().down('grid').getStore().removeAll();
								this.getCaptureattendancecountgrid().getStore().removeAll();
								this.getStudentcaptureattendancestructure().down('#submitBtn').setDisabled(true);
								var form=this.getCoursewisecaptureattendancesearch();
								form.down("#topicId").clearValue();
								form.down('#fromTime').clearValue();
								form.down('#toTime').clearValue();
								if(record != null && record.length > 0){
									form.down('#dateOfAttendance_Id').setDisabled(true);
									form.down('#fromTime').setDisabled(true);
									form.down('#toTime').setDisabled(true);
									form.down('#fromTime').allowBlank=true;
									form.down('#toTime').allowBlank=true;
									form.down('#dateOfAttendance_Id').allowBlank=true;
									form.down('#timeBtnAdd').setDisabled(true);
									var cvId = form.down('#courseVariantId').getValue();
									var courseValues = form.down('#courseVariantId').getStore().findRecord('id',cvId).data;
									var courseId = courseValues.courseId;
									var componentId = "";
									if(courseValues.courseComponentId > 0) {
										courseId = courseValues.parentCourseId;
										componentId = courseValues.courseComponentId;
									}
									$this.loadTopics(form, courseId, componentId);
								}else{
									form.down('#dateOfAttendance_Id').setDisabled(false);
									form.down('#fromTime').setDisabled(false);
									form.down('#toTime').setDisabled(false);
									form.down('#fromTime').allowBlank=false;
									form.down('#toTime').allowBlank=false;
									form.down('#dateOfAttendance_Id').allowBlank=false;
									var cvId = form.down('#courseVariantId').getValue();
									var courseValues = form.down('#courseVariantId').getStore().findRecord('id',cvId).data;
									var courseId = courseValues.courseId;
									var componentId = "";
									if(courseValues.courseComponentId > 0) {
										courseId = courseValues.parentCourseId;
										componentId = courseValues.courseComponentId;
									}
									$this.loadTopics(form, courseId, componentId);
								}
								form.isValid();
							}
						},
						'coursewisecaptureattendancesearch multiselectcombofield[itemId=calendarSlotListId]':{
							change: function(obj, record) {
								this.getCaptureattendancegrid().down('grid').getStore().removeAll();
								this.getCaptureattendancecountgrid().getStore().removeAll();
								this.getStudentcaptureattendancestructure().down('#submitBtn').setDisabled(true);
								var form=this.getCoursewisecaptureattendancesearch();
								form.down('#fromTime').clearValue();
								form.down('#toTime').clearValue();
								var timeSlotPanel = form.down('#panelId');
					            if (timeSlotPanel != null && !timeSlotPanel.items.items[0].isHidden()) {
					            	for(var i=timeSlotPanel.items.length;i>=0;i--){
					            		if(i==0){
					            			timeSlotPanel.items.items[i].setVisible(true);
					            		}else{
					            			timeSlotPanel.remove(timeSlotPanel.items.items[i]);
					            		}
					                    this.hideShowTimeSlotElement(timeSlotPanel);
					            	}
					            }
								if(record != null && record.length > 0){
									form.down('#fromTime').setDisabled(true);
									form.down('#toTime').setDisabled(true);
									form.down('#fromTime').allowBlank=true;
									form.down('#toTime').allowBlank=true;
									form.down('#timeBtnAdd').setDisabled(true);
								}else{
									form.down('#fromTime').setDisabled(false);
									form.down('#toTime').setDisabled(false);
									form.down('#fromTime').allowBlank=false;
									form.down('#toTime').allowBlank=false;
								}
							}
						},
						'coursewisecaptureattendancesearch timefield#fromTime':{
							change:function(obj, record){
								var form = this.getCoursewisecaptureattendancesearch();
								var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
								this.getCaptureattendancegrid().down('grid').getStore().removeAll();
								this.getCaptureattendancecountgrid().getStore().removeAll();
								this.getStudentcaptureattendancestructure().down('#submitBtn').setDisabled(true);
								if (!isNullOrEmpty(record)) {
									if(attendanceTypess.data.COURSE_LEVEL.attendanceSlot=="TIME_TABLE_SLOTS"){
										form.down('#timetableSlotListId').setDisabled(true);
										form.down('#timetableSlotListId').allowBlank = true;
									}else{
										form.down('#calendarSlotListId').setDisabled(true);
										form.down('#calendarSlotListId').allowBlank = true;
									}
									form.down('#timeBtnAdd').setDisabled(false);
								}else{
									if(attendanceTypess.data.COURSE_LEVEL.attendanceSlot=="TIME_TABLE_SLOTS"){
										form.down('#timetableSlotListId').setDisabled(false);
										form.down('#timetableSlotListId').allowBlank = true;
									}else{
										form.down('#calendarSlotListId').setDisabled(false);
										form.down('#calendarSlotListId').allowBlank = true;
									}
									form.down('#timeBtnAdd').setDisabled(true);
								}
							}
						},
						'servicewisecaptureattendancesearch timefield#fromTime':{
							change:function(obj, record){
								var form = this.getCoursewisecaptureattendancesearch();
								var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
								this.getCaptureattendancegrid().down('grid').getStore().removeAll();
								this.getCaptureattendancecountgrid().getStore().removeAll();
								this.getStudentcaptureattendancestructure().down('#submitBtn').setDisabled(true);
									form.down('#timeBtnAdd').setDisabled(false);
							}
						},
						'coursewisecaptureattendancesearch timefield#toTime':{
							change:function(obj, record){
								var form = this.getCoursewisecaptureattendancesearch();
								var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
								this.getCaptureattendancegrid().down('grid').getStore().removeAll();
								this.getCaptureattendancecountgrid().getStore().removeAll();
								this.getStudentcaptureattendancestructure().down('#submitBtn').setDisabled(true);
								if (!isNullOrEmpty(record)) {
									if(attendanceTypess.data.COURSE_LEVEL.attendanceSlot=="TIME_TABLE_SLOTS"){
										form.down('#timetableSlotListId').setDisabled(true);
										form.down('#timetableSlotListId').allowBlank = true;
									}else{
										form.down('#calendarSlotListId').setDisabled(true);
										form.down('#calendarSlotListId').allowBlank = true;
									}
									form.down('#timeBtnAdd').setDisabled(false);
									var date = form.down('#dateOfAttendance_Id');

									var dateVal = date.getValue();
									var newDate = null;
									Ext.Ajax.request({
										type : 'rest',
										url :SERVERURL.PATH_FIND_SERVER_DATE_TIME,
										method : 'GET',
										async: false,
										success : function(form1, action) {
											data = Ext.JSON.decode(form1.responseText);
											newDate=data.serverDateTimeYYYYMMDDTweentyFourHour;
											newDate = new Date(newDate)
											var fromTime = form.down('#fromTime');
											if(dateVal.getDate() == newDate.getDate()){
												var time = moment(newDate).format("HH:mm"); 
												fromTime.setMaxValue(time);
											}
										}});
								}else{
									if(attendanceTypess.data.COURSE_LEVEL.attendanceSlot=="TIME_TABLE_SLOTS"){
										form.down('#timetableSlotListId').setDisabled(false);
										form.down('#timetableSlotListId').allowBlank = true;
									}else{
										form.down('#calendarSlotListId').setDisabled(false);
										form.down('#calendarSlotListId').allowBlank = true;
									}
									form.down('#timeBtnAdd').setDisabled(true);
								}
							}
						},
						'servicewisecaptureattendancesearch timefield#toTime':{
							change:function(obj, record){
								var form = this.getServicewisecaptureattendancesearch();
								var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
								this.getCaptureattendancegrid().down('grid').getStore().removeAll();
								this.getCaptureattendancecountgrid().getStore().removeAll();
								this.getStudentcaptureattendancestructure().down('#submitBtn').setDisabled(true);
								if (!isNullOrEmpty(record)) {
									form.down('#timeBtnAdd').setDisabled(false);
									var date = form.down('#dateOfAttendance_Id');

									var dateVal = date.getValue();
									var newDate = null;
									Ext.Ajax.request({
										type : 'rest',
										url :SERVERURL.PATH_FIND_SERVER_DATE_TIME,
										method : 'GET',
										async: false,
										success : function(form1, action) {
											data = Ext.JSON.decode(form1.responseText);
											newDate=data.serverDateTimeYYYYMMDDTweentyFourHour;
											newDate = new Date(newDate)
											var fromTime = form.down('#fromTime');
											if(dateVal.getDate() == newDate.getDate()){
												var time = moment(newDate).format("HH:mm"); 
												fromTime.setMaxValue(time);
											}
										}});
								}
							}
						},
						'captureattendancegrid':{
							render:function(obj){
								this.attendanceMarkingTypeRadioFields();   
								this.getCaptureattendancegrid().down('grid').getStore().removeAll();
							}
						},
						'captureattendancegrid grid':{
		        			   afterrender:function(grid){
		        				   var me = this;
		        				   setTimeout(function(){
		        					   me.addDataGridConfigButton(grid,me.getATTENDANCE_ENTRY_FACULTY_PORTAL_PRIVILEGES());
		                			},1500);
		        			   }
		        		   },
						'captureattendancegrid radiogroup[itemId=markOnlyAttendance_Id]':{
							change:function(obj,record){
								this.changeAttendanceMarkingType(obj,record);
							}
						},
						'captureattendancegrid customcombobox[itemId=newOtherStatusId]':{
		        			   select:function(obj,record){
		        				   this.selectOtherStatus(obj,record);
		        			   }
		        		   },
						'captureattendancegrid checkcolumn':{
							checkchange:function(obj, rowIndex, checked, eOpts ){
								var this$ = this;
								var grid = this$.getCaptureattendancegrid().down('grid');
								var store = grid.getStore();
								var models = grid.getStore().getRange();
								if(checked){
									if(obj.text=='Absent'){
										for(var i =0; i<store.data.length;i++){
											if(rowIndex==i){
												models[rowIndex].set('present', false);
												Ext.defer(function() {
													if(models[rowIndex].data.absent == true){
			        	                	    		models[rowIndex].set('attendanceStatus', null);
			        	                	    	}
													var preCount=0,absCount=0, other=0, presentSummaryCount = 0, absentSummaryCount= 0;
													for(var i =0; i<store.data.length;i++){
														if(models[i].data.present){
															preCount++;
															presentSummaryCount++;
														}
														if(models[i].data.absent){
															absCount++;
															absentSummaryCount++;
														}
														if(models[i].data.attendanceStatus){
															other++;
															var data  = this.getCaptureattendancegrid().down('grid').down('#StudentAttendanceStatus_Id').getStore().data.items;
															for(var j= 0; j<data.length;j++){
																if(data[j].data.value == models[i].data.attendanceStatus){
																	if(data[j].data.code == 'PRESENT')
																		presentSummaryCount++;
																	if(data[j].data.code == 'ABSENT')
																		absentSummaryCount++;
																}
															}
														}
													}
													var gridCount = this$.getCaptureattendancecountgrid();
													var  data = {
															totalStudent:store.data.length,
															totalPresent:preCount,
															totalAbsent:absCount,
															otherCount:other,
															presentPercent:parseFloat((presentSummaryCount/store.data.length)*100).toFixed(2)+"%",
															absentPercent:parseFloat((absentSummaryCount/store.data.length)*100).toFixed(2)+"%",
													};
													var gridStore =  gridCount.getStore();
													gridStore.removeAll();
													gridStore.loadRawData(data, true);
												}, 50, this);
												break;
											}
										}
									}
									if(obj.text=='Present'){
										for(var i =0; i<store.data.length;i++){
											if(rowIndex==i){
												models[rowIndex].set('absent', false);
												Ext.defer(function() {
													if(models[rowIndex].data.present == true){
			        	                	    		models[rowIndex].set('attendanceStatus', null);
			        	                	    	}
													var preCount=0,absCount=0, other=0, presentSummaryCount = 0, absentSummaryCount= 0;
													for(var i =0; i<store.data.length;i++){
														if(models[i].data.present){
															preCount++;
															presentSummaryCount++;
														}
														if(models[i].data.absent){
															absCount++;
															absentSummaryCount++;
														}
														if(models[i].data.attendanceStatus){
															other++;
															var data  = this.getCaptureattendancegrid().down('grid').down('#StudentAttendanceStatus_Id').getStore().data.items;
															for(var j= 0; j<data.length;j++){
																if(data[j].data.value == models[i].data.attendanceStatus){
																	if(data[j].data.code == 'PRESENT')
																		presentSummaryCount++;
																	if(data[j].data.code == 'ABSENT')
																		absentSummaryCount++;
																}
															}
														}
													}
													var gridCount = this$.getCaptureattendancecountgrid();
													var  data = {
															totalStudent:store.data.length,
															totalPresent:preCount,
															totalAbsent:absCount,
															otherCount:other,
															presentPercent:parseFloat((presentSummaryCount/store.data.length)*100).toFixed(2)+"%",
															absentPercent:parseFloat((absentSummaryCount/store.data.length)*100).toFixed(2)+"%",
													};
													var gridStore =  gridCount.getStore();
													gridStore.removeAll();
													gridStore.loadRawData(data, true);
												}, 50, this);
												break;
											}
										}
									}
								}else{
									if(obj.text=='Absent'){
										for(var i =0; i<store.data.length;i++){
											if(rowIndex==i){
												models[rowIndex].set('present', true);
												Ext.defer(function() {
													if(models[rowIndex].data.absent == true){
			        	                	    		models[rowIndex].set('attendanceStatus', null);
			        	                	    	}
													var preCount=0,absCount=0, other=0, presentSummaryCount = 0, absentSummaryCount= 0;
													for(var i =0; i<store.data.length;i++){
														if(models[i].data.present){
															preCount++;
															presentSummaryCount++;
														}
														if(models[i].data.absent){
															absCount++;
															absentSummaryCount++;
														}
														if(models[i].data.attendanceStatus){
															other++;
															var data  = this.getCaptureattendancegrid().down('grid').down('#StudentAttendanceStatus_Id').getStore().data.items;
															for(var j= 0; j<data.length;j++){
																if(data[j].data.value == models[i].data.attendanceStatus){
																	if(data[j].data.code == 'PRESENT')
																		presentSummaryCount++;
																	if(data[j].data.code == 'ABSENT')
																		absentSummaryCount++;
																}
															}
														}
													}
													var gridCount = this$.getCaptureattendancecountgrid();
													var  data = {
															totalStudent:store.data.length,
															totalPresent:preCount,
															totalAbsent:absCount,
															otherCount:other,
															presentPercent:parseFloat((presentSummaryCount/store.data.length)*100).toFixed(2)+"%",
															absentPercent:parseFloat((absentSummaryCount/store.data.length)*100).toFixed(2)+"%",
													};
													var gridStore =  gridCount.getStore();
													gridStore.removeAll();
													gridStore.loadRawData(data, true);
												}, 50, this);
												break;
											}
										}
									}
									if(obj.text=='Present'){
										for(var i =0; i<store.data.length;i++){
											if(rowIndex==i){
												models[rowIndex].set('absent', true);
												Ext.defer(function() {
													if(models[rowIndex].data.present == true){
			        	                	    		models[rowIndex].set('attendanceStatus', null);
			        	                	    	}
													var preCount=0,absCount=0, other=0, presentSummaryCount = 0, absentSummaryCount= 0;
													for(var i =0; i<store.data.length;i++){
														if(models[i].data.present){
															preCount++;
															presentSummaryCount++;
														}
														if(models[i].data.absent){
															absCount++;
															absentSummaryCount++;
														}
														if(models[i].data.attendanceStatus){
															other++;
															var data  = this.getCaptureattendancegrid().down('grid').down('#StudentAttendanceStatus_Id').getStore().data.items;
															for(var j= 0; j<data.length;j++){
																if(data[j].data.value == models[i].data.attendanceStatus){
																	if(data[j].data.code == 'PRESENT')
																		presentSummaryCount++;
																	if(data[j].data.code == 'ABSENT')
																		absentSummaryCount++;
																}
															}
														}
													}
													var gridCount = this$.getCaptureattendancecountgrid();
													var  data = {
															totalStudent:store.data.length,
															totalPresent:preCount,
															totalAbsent:absCount,
															otherCount:other,
															presentPercent:parseFloat((presentSummaryCount/store.data.length)*100).toFixed(2)+"%",
															absentPercent:parseFloat((absentSummaryCount/store.data.length)*100).toFixed(2)+"%",
													};
													var gridStore =  gridCount.getStore();
													gridStore.removeAll();
													gridStore.loadRawData(data, true);
												}, 50, this);
												break;
											}
										}
									}
								}
							}
						},
						'studentcaptureattendancestructure button[itemId=submitBtn]' : {
							click : function(btn){
								var me = this;
								btn.setDisabled(true);
								setTimeout(function(){
									if(!Ext.isDefined(btn.isSaving) || btn.isSaving==false){
										btn.isSaving = true;
										me.saveCaptureStudentAttendance(btn);
									}
								},1000);
							}
						},
						'studentcaptureattendancestructure':{
							afterrender:function(obj){
								var $this = this;
								var structure = obj.up('personinfofacultyportal');
								var newStructure = obj.up('facultycaptureattendancemasterstructure');
								var gridOuter = newStructure.down('captureattendancegrid');
								var grid = gridOuter.down('grid');
								if(Ext.isDefined(structure)){
									this.getGridHeaderFreezeWithoutPaginationTwoItemsCustomized(grid,structure,false);
								}
								this.getGridHeaderFreezeWithoutPaginationTwoItemsCustomized(grid,newStructure,false);
							}
						},
						'downloadstudentattendanceform':{
							afterrender: function(obj){
								this.loadStudentCaptureAttendanceProgram();
							}
						},
						'studentcaptureattendanceuploaddownloadstructureforfaculty radiogroup[itemId=importStudentDownloadgroupId]':{
							change: this.downloadUploadStudentFormChange
						},
						'uploadstudentattendanceform uploadoptionradiogroup[itemId=attendanceUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
							change: function( radioGroup, newValue, oldValue, eOpts){
								var grid =this.getImportutilityStudentattendancelist();
								var isUploadAll = newValue.isUploadAll;
								this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_MODULE_ATTENDANCE');
							}   
						},
						'downloadstudentattendanceform button[itemId=resetStudentAttendenceBtn]':{
							click: this.resetDownloadStudentAttendanceForm
						},
						'downloadstudentattendanceform button[itemId=programBatchStudentDownoladBtnId]':{
							click: this.programBatchStudentAttendanceDownloadTemplete
						},
						'uploadstudentattendanceform button[itemId=programBatchUpload]':{
							click: this.uploadCompleteDayAttendance
						},

						'importutilityStudentattendancelist button[itemId=btnForce]':{
							click: this.forceRunUploadedFile
						},
						'importutilityStudentattendancelist':{
							render:function(obj){
								var $this = this;
								var grid = $this.getImportutilityStudentattendancelist();
								this.onChangeUploadOptionRadioGroup(false,grid, 'IMPORT_MODULE_ATTENDANCE');
							},
							cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
								if (e.target.tagName == 'A') {
									var fileType=null;
									if(cellIndex==1){
										fileType='successFile';
									}else if(cellIndex==6){
										fileType='errorFile';
									}else if(cellIndex==7){
										fileType='logFile';
									}
									var documentId = record.get("id");
									if (!isNullOrEmpty(documentId)) {
										this.getDownloadFile(documentId,fileType);
									}
								}
							}
						},
						'importutilityStudentattendancelist button[itemId=btnRefresh]':{
							click: this.refreshStudentUploadData
						},
						'uploadstudentattendanceform button[itemId=resetBtn]':{
							click: this.resetUploadStudentAttendance
						},
						'downloadstudentcourselevelattendanceform':{
							afterrender:function(obj){
								this.loadStudentCourseLevelAcademicTerm();
							}
						},
						'downloadstudentcourselevelattendanceform customcombobox[itemId=studentAcademicTermId]':{
							change: function(obj, record){
								var me = this;
								var form = obj.up('form');
								var academicTermId = obj.getValue();
								if(academicTermId > 0) {
									this.courseLevelAcademicTermSelection(form, academicTermId);
								}
							}
						},
						'studentcourselevelattendanceuploaddownloadstructureforfaculty radiogroup[itemId=importStudentCourseLevelDownloadgroupId]':{
							change: this.downloadUploadStudentFormCourseLevel
						},
						'downloadstudentcourselevelattendanceform button[itemId=courseLevelStudentDownoladBtnId]':{
							click: this.courseLevelStudentAttendanceDownloadTemplete
						},
						'downloadstudentcourselevelattendanceform button[itemId=resetCourseLevelStudentAttendenceBtn]':{
							click: this.resetCourseLevelStudentDownloadAttendance
						},
						'uploadstudentcourselevelattendanceform button[itemId=uploadCourseLevelStudentId]':{
							click: this.uploadCourseLevelStudentAttendance
						},
						'importutilitystudentcourselevelattendancelist button[itemId=btnCourseLevelStudentAttendanceRefresh]':{
							click: this.refreshCourseLevelStudentAttendanceGrid
						},
						'importutilitystudentcourselevelattendancelist button[itemId=btnCourseLevelStudentAttendanceForce]':{
							click: this.forceRunCourseLevelStudentAttendanceUploadedFile
						},
						'importutilitystudentcourselevelattendancelist':{
							render:function(obj){
								var $this = this;
							   var grid = $this.getImportutilitystudentcourselevelattendancelist();
		 					   $this.onChangeUploadOptionRadioGroup(false, grid,'IMPORT_BULK_COURSE_LEVEL_ATTENDANCE_UPLOAD');
						   },
							cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
								if (e.target.tagName == 'A') {
									   var fileType=null;
									   if(cellIndex==1){
										   fileType='successFile';
									   }else if(cellIndex==6){
										   fileType='errorFile';
									   }else if(cellIndex==7){
										   fileType='logFile';
									   }
									   var documentId = record.get("id");
									   if (!isNullOrEmpty(documentId)) {
										   this.getCourseLevelAtttendenceDownloadFile(documentId,fileType);
									   }
								}
							}
						},
						'uploadstudentcourselevelattendanceform button[itemId=resetCourseLevelStudentBtn]':{
							click: this.resetUploadCourseLevelStudentAttendance
						},
						'programwisecaptureattendancesearch':{
                         afterrender: function(form){
                         this.generateQrCodePermissionProgramWise(form,this.getATTENDANCE_ENTRY_FACULTY_PORTAL_PRIVILEGES());
                    		}
							},
						'coursewisecaptureattendancesearch':{
                         afterrender: function(form){
                         this.generateQrCodePermissionCourseWise(form,this.getATTENDANCE_ENTRY_FACULTY_PORTAL_PRIVILEGES());
                    		}
						},
                      
						'multiplesessionwisecaptureattendancesearch':{
                         afterrender: function(form){
                         this.generateQrCodePermissionSessionWise(form,this.getATTENDANCE_ENTRY_FACULTY_PORTAL_PRIVILEGES());
                    		}
						},'servicewisecaptureattendancesearch combo#serviceId': {
		        			   select: function(obj, record) {
		        				   var this$ =  this;
		        				   var form = this$.getServicewisecaptureattendancesearch();
		        				   var serviceCombo = form.down("#serviceId");
		        				   var serviceId = serviceCombo.getValue();
		        				   var serviceBatchCombo = form.down("#serviceBatchId");
		        				   serviceBatchCombo.clearValue();
		        				   serviceBatchCombo.setDisabled(false);
		        				   var batchStore = serviceBatchCombo.getStore();
		        				   batchStore.getProxy().extraParams = {
		        					   serviceId: serviceId,
		        					   programId: null
		        				   };
		        				   batchStore.load({
		        					   callback: function(records, operation, success) {
		        						   if (success) {
		        							   if(records.length==1){

		        							   }
		        						   }
		        					   }
		        				   });
		        			   }
		        		   },'servicewisecaptureattendancesearch button[itemId=searchBtn]':{
		        			   click: this.searchServiceWiseGridData
		        		   },'servicewisecaptureattendancesearch button[itemId=resetBtn]':{
		        			   click: this.resetStudentAttendance
		        		   },'studentcaptureattendancestructure button[itemId=cancelBtn]':{
		        			   click: this.resetStudentAttendance
		        		   }

					});
				},
				checkTabPermission:function(tab2, tab3, structure,tab4,attendanceType,permissionList) {
					var panelItem = new Array();
					var $this = this;
					var newcont=structure.items.items.length;
					var insertPosition=newcont+1;
					
					if(Ext.ComponentQuery.query('studentcaptureattendancestructure').length){
						return;
					}
					
					if((tab2 || tab4) && tab3) {
						panelItem.push({
							xtype:'tabpanel',
							itemId:'allVisibleTP',
							plain: true,
							style:{overflow:'hidden !important'},
							
							frame: false,
							border:false,
							defaults: {
								labelAlign: 'top'
							},
							items:[{
								xtype: 'studentcaptureattendancestructure',
								title: getCommonTranslation('SEARCH'),
								tabCls: 'right-tab'
							}, {
								xtype: 'studentcaptureattendanceuploaddownloadstructureforfaculty',
								title: getProgramandcourseTranslation("UPLOAD_ATTENDANCE"),
								tabCls: 'right-tab'
							}, {
								xtype: 'studentcourselevelattendanceuploaddownloadstructureforfaculty',
								title: getProgramandcourseTranslation("UPLOAD_COURSE_LEVEL_ATTENDANCE"),
								tabCls: 'right-tab'
							}]
						});
					} else if(tab2 || tab4) {
						panelItem.push({
							xtype:'tabpanel',
							itemId:'allVisibleTP',
							plain: true,
							style:{overflow:'hidden !important'},
							
							frame: false,
							border:false,
							defaults: {
								labelAlign: 'top'
							},
							items:[{
								xtype: 'studentcaptureattendancestructure',
								title: getCommonTranslation('SEARCH'),
								tabCls: 'right-tab'
							}, {
								xtype: 'studentcaptureattendanceuploaddownloadstructureforfaculty',
								title: getProgramandcourseTranslation("UPLOAD_ATTENDANCE"),
								tabCls: 'right-tab'
							}]
						});
					} else if(tab3) {
						panelItem.push({
							xtype:'tabpanel',
							itemId:'allVisibleTP',
							plain: true,
							style:{overflow:'hidden !important'},
							
							frame: false,
							border:false,
							defaults: {
								labelAlign: 'top'
							},
							items:[{
								xtype: 'studentcaptureattendancestructure',
								title: getCommonTranslation('SEARCH'),
								tabCls: 'right-tab'
							}, {
								xtype: 'studentcourselevelattendanceuploaddownloadstructureforfaculty',
								title: getProgramandcourseTranslation("UPLOAD_COURSE_LEVEL_ATTENDANCE"),
								tabCls: 'right-tab'
							}]
						});
					} else {
						panelItem.push({
							xtype:'tabpanel',
							itemId:'allVisibleTP',
							plain: true,
							style:{overflow:'hidden !important'},
							
							frame: false,
							border:false,
							defaults: {
								labelAlign: 'top'
							},
							items:[{
								xtype: 'studentcaptureattendancestructure',
								title: getCommonTranslation('SEARCH'),
								tabCls: 'right-tab'
							}]
						});
					}
					structure.insert(insertPosition,panelItem);

					Ext.defer(function() {
						var activeTab = Ext.ComponentQuery.query('contentPanel')[0].getActiveTab();
						var studentpncattendancestructure = activeTab.down('studentcaptureattendancestructure');
						var attendanceTypeRadio= studentpncattendancestructure.down('#newAttendanceTypeRadio');
						attendanceTypeRadio.setVisible(false);
						var completeDay=false;//tab2
						var multipleSession=false;//tab4
						var courseLevel=false;//tab3
						var serviceLevel=false;

						if((Ext.Array.contains(permissionList, 'PROGRAM_WISE')) &&(Ext.Array.contains(attendanceType, 'COMPLETE_DAY') || Ext.Array.contains(attendanceType, 'Complete Day'))){
							completeDay=true;
						}
						if((Ext.Array.contains(permissionList, 'SESSION_WISE'))&&(Ext.Array.contains(attendanceType, 'MULTIPLE_SESSION') || Ext.Array.contains(attendanceType, 'Multiple Session'))){
							multipleSession=true;
						}
						if((Ext.Array.contains(permissionList, 'COURSE_WISE'))&&(Ext.Array.contains(attendanceType, 'COURSE_LEVEL') || Ext.Array.contains(attendanceType, 'Course Level'))){
							courseLevel=true;
						}
						 if((Ext.Array.contains(permissionList, 'SERVICE_WISE'))&&(Ext.Array.contains(attendanceType, 'SERVICE_LEVEL') || Ext.Array.contains(attendanceType, 'Service Level'))){
							 serviceLevel=true;
						}

						if(!completeDay && !multipleSession && !courseLevel){
							completeDay=true;
						}

						if (completeDay && courseLevel && multipleSession && serviceLevel) {
							attendanceTypeRadio.setVisible(true);
							attendanceTypeRadio.items.items[0].setValue(true);
							attendanceTypeRadio.items.items[1].setValue(false);
							attendanceTypeRadio.items.items[2].setValue(false);
							attendanceTypeRadio.items.items[3].setValue(false);
						}else if (completeDay  && courseLevel && serviceLevel && !multipleSession) {
							attendanceTypeRadio.setVisible(true);
							attendanceTypeRadio.items.items[2].setVisible(false);
							attendanceTypeRadio.items.items[1].setValue(false);
							attendanceTypeRadio.items.items[0].setValue(true);
							attendanceTypeRadio.items.items[3].setValue(false);
						}else if (courseLevel && multipleSession && serviceLevel &&  !completeDay) {
							attendanceTypeRadio.setVisible(true);
							attendanceTypeRadio.items.items[2].setValue(false);
							attendanceTypeRadio.items.items[1].setValue(true);
							attendanceTypeRadio.items.items[0].setVisible(false);
							attendanceTypeRadio.items.items[3].setVisible(false);
						}else if (multipleSession && completeDay && serviceLevel && !courseLevel ) {
							attendanceTypeRadio.setVisible(true);
							attendanceTypeRadio.items.items[2].setValue(false);
							attendanceTypeRadio.items.items[1].setVisible(false);
							attendanceTypeRadio.items.items[0].setValue(true);
							attendanceTypeRadio.items.items[3].setVisible(false);
						}else if (multipleSession && completeDay && courseLevel && !serviceLevel ) {
                        	attendanceTypeRadio.setVisible(true);
		        			attendanceTypeRadio.items.items[0].setValue(true);
		        			attendanceTypeRadio.items.items[1].setValue(false);
		        			attendanceTypeRadio.items.items[2].setValue(false);
		        			attendanceTypeRadio.items.items[3].setVisible(false);
                        }else if (completeDay && courseLevel && !serviceLevel && !multipleSession) {
                        	attendanceTypeRadio.setVisible(true);
                        	attendanceTypeRadio.items.items[2].setVisible(false);
                        	attendanceTypeRadio.items.items[1].setValue(false);
                        	attendanceTypeRadio.items.items[0].setValue(true);
                        	attendanceTypeRadio.items.items[3].setVisible(false);
                        }else if (!courseLevel && multipleSession && serviceLevel && !completeDay) {
                        	attendanceTypeRadio.setVisible(true);
                        	attendanceTypeRadio.items.items[2].setValue(true);
                        	attendanceTypeRadio.items.items[1].setVisible(false);
                        	attendanceTypeRadio.items.items[0].setVisible(false);
                        	attendanceTypeRadio.items.items[3].setValue(false);
                        }else if (multipleSession && completeDay && !serviceLevel && !courseLevel) {
                        	attendanceTypeRadio.setVisible(true);
                        	attendanceTypeRadio.items.items[2].setValue(false);
                        	attendanceTypeRadio.items.items[1].setVisible(false);
                        	attendanceTypeRadio.items.items[0].setValue(true);
                        	attendanceTypeRadio.items.items[3].setVisible(false);
                        }else if (multipleSession && !completeDay && courseLevel && !serviceLevel ) {
                        	attendanceTypeRadio.setVisible(true);
		        			attendanceTypeRadio.items.items[0].setVisible(false);
		        			attendanceTypeRadio.items.items[1].setValue(true);
		        			attendanceTypeRadio.items.items[2].setValue(false);
		        			attendanceTypeRadio.items.items[3].setVisible(false);
                        }else if (!multipleSession && completeDay && !courseLevel && serviceLevel ) {
                        	attendanceTypeRadio.setVisible(true);
                        	attendanceTypeRadio.items.items[0].setValue(true);
		        			attendanceTypeRadio.items.items[1].setVisible(false);
		        			attendanceTypeRadio.items.items[2].setVisible(false);
		        			attendanceTypeRadio.items.items[3].setValue(false);
                        }else if (!multipleSession && !completeDay && courseLevel && serviceLevel ) {
                        	attendanceTypeRadio.setVisible(true);
                        	attendanceTypeRadio.items.items[0].setVisible(false);
		        			attendanceTypeRadio.items.items[1].setValue(true);
		        			attendanceTypeRadio.items.items[2].setVisible(false);
		        			attendanceTypeRadio.items.items[3].setValue(false);
                        }else if(completeDay){
							attendanceTypeRadio.items.items[0].setValue(true);
							attendanceTypeRadio.items.items[1].setValue(false);
							attendanceTypeRadio.items.items[2].setValue(false);
							attendanceTypeRadio.items.items[3].setValue(false);
						}else if(courseLevel){
							attendanceTypeRadio.items.items[0].setValue(false);
							attendanceTypeRadio.items.items[1].setValue(true);
							attendanceTypeRadio.items.items[2].setValue(false);
							attendanceTypeRadio.items.items[3].setValue(false);
						}else if(multipleSession){
							attendanceTypeRadio.items.items[0].setValue(false);
							attendanceTypeRadio.items.items[1].setValue(false);
							attendanceTypeRadio.items.items[2].setValue(true);
							attendanceTypeRadio.items.items[3].setValue(false);
						}else if(serviceLevel){
		        			attendanceTypeRadio.items.items[0].setValue(false);
		        			attendanceTypeRadio.items.items[1].setValue(false);
		        			attendanceTypeRadio.items.items[2].setValue(false);
		        			attendanceTypeRadio.items.items[3].setValue(true);
		        		}
					}, 500, this);

				},
				onChangeAttedanceType:function(obj,record){
					var $this = this;
					var academyLocationId = this.getCurrentAcademyLocation();
					var attendanceType = record.newAttendanceTypeWise;
					var programWiseSearch = this.getProgramwisecaptureattendancesearch();
					var sessionWiseSearch = this.getMultiplesessionwisecaptureattendancesearch();
					var courseWiseSearch = this.getCoursewisecaptureattendancesearch();
					var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var facultyId = this.getCurrentlyLoggedInUser().id;
					var wheatherSchool = alinfomodel.get('wheatherSchool');
					var forms = $this.getCaptureattendancegrid();
					var serviceWiseSearch=this.getServicewisecaptureattendancesearch();
					try {
						forms.down('#markOnlyAttendance_Id').items.items[0].setValue(false);
						forms.down('#markOnlyAttendance_Id').items.items[1].setValue(false);
						forms.down('#markOnlyAttendance_Id').items.items[2].setValue(false);
						forms.down('#newOtherStatusId').clearValue();
			        	forms.down('#newOtherStatusId').setVisible(false);
						$this.getCaptureattendancegrid().down('grid').getStore().removeAll();
						$this.getCaptureattendancecountgrid().getStore().removeAll();
					} catch(e) {
						
					}
					var date = courseWiseSearch.down('#dateOfAttendance_Id');

					var dateVal = date.getValue();
					var newDate = null;
					Ext.Ajax.request({
						type : 'rest',
						url :SERVERURL.PATH_FIND_SERVER_DATE_TIME,
						method : 'GET',
						async: false,
						success : function(form1, action) {
							data = Ext.JSON.decode(form1.responseText);
							newDate=data.serverDateTimeYYYYMMDDTweentyFourHour;
							newDate = new Date(newDate)
							var fromTime = courseWiseSearch.down('#fromTime');
							if(dateVal.getDate() == newDate.getDate()){
								var time = moment(newDate).format("HH:mm"); 
								fromTime.setMaxValue(time);
							}

						}});

					if(attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY'){
						var data=attendanceTypess.data.COMPLETE_DAY;
						var date = new Date();
						var minDate = Ext.Date.add(date, Ext.Date.DAY, -data.backDateAllowedForFaculty);
						programWiseSearch.down("#completeDayDate_Id").setMinValue(minDate);
						programWiseSearch.setVisible(true);
						sessionWiseSearch.setVisible(false);
						courseWiseSearch.setVisible(false);
						serviceWiseSearch.setVisible(false);
						programWiseSearch.down('#facultyAttendanceProgramId').reset();
						this.setAllowBlank(programWiseSearch.down('#facultyAttendanceProgramId'),false);
						if(wheatherSchool) {
							programWiseSearch.down("#facultyAttendanceProgramId").setFieldLabel(getCourseTxCommonTranslation('ATTENDANCE_PROGRAM_BATCH_SECTION'))
						} else {
							programWiseSearch.down("#facultyAttendanceProgramId").setFieldLabel(getCourseTxCommonTranslation('PROGRAM_BATCH_PERIOD_SECTION'))
						}
						var programByAcademyLocationStore = programWiseSearch.down('#facultyAttendanceProgramId').getStore();
						programByAcademyLocationStore.getProxy().extraParams = {
							academyLocationIds:academyLocationId,
							facultyId:facultyId,
							onlyCurrentRecords:true,
							wheatherSchool:wheatherSchool
						};
						programByAcademyLocationStore.load();
					} else if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL') {
						programWiseSearch.setVisible(false);
						sessionWiseSearch.setVisible(false);
						courseWiseSearch.setVisible(true);
						serviceWiseSearch.setVisible(false);
						var data=attendanceTypess.data.COURSE_LEVEL;
						var attendanceSlot=data.attendanceSlot;
						var date = new Date();
						courseWiseSearch.down('#courseVariantId').reset();
						courseWiseSearch.down('#academicTerm').reset();
						courseWiseSearch.down('#viewQR').hide();
						var minDate = Ext.Date.add(date, Ext.Date.DAY, -data.backDateAllowedForFaculty);
						if(attendanceSlot=="TIME_TABLE_SLOTS"){
							courseWiseSearch.down('#timetableSlotListId').reset();
							courseWiseSearch.down('#timetableSlotListId').setDisabled(true);
							courseWiseSearch.down('#timetableSlotListId').setVisible(true);
							courseWiseSearch.down('#calendarSlotListId').setVisible(false);

							this.setAllowBlank(courseWiseSearch.down('#timetableSlotListId'), false);
							this.setAllowBlank(courseWiseSearch.down('#calendarSlotListId'), true);

							if(data.whetherAdhocRequired) {
								courseWiseSearch.down('#dateOfAttendance_Id').setVisible(true);
								courseWiseSearch.down('#timeContainer').setVisible(true);
								courseWiseSearch.down('#timeBtnAdd').setDisabled(true);
								courseWiseSearch.down('#dateOfAttendance_Id').setDisabled(false);
								courseWiseSearch.down('#fromTime').setDisabled(false);
								courseWiseSearch.down('#toTime').setDisabled(false);
								this.setAllowBlank(courseWiseSearch.down('#dateOfAttendance_Id'), false);
								this.setAllowBlank(courseWiseSearch.down('#fromTime'), false);
								this.setAllowBlank(courseWiseSearch.down('#toTime'), false);
								courseWiseSearch.down('#viewQR').show();
							}else{
								courseWiseSearch.down('#dateOfAttendance_Id').setVisible(false);
								courseWiseSearch.down('#timeContainer').setVisible(false);
								this.setAllowBlank(courseWiseSearch.down('#dateOfAttendance_Id'), true);
								this.setAllowBlank(courseWiseSearch.down('#fromTime'), true);
								this.setAllowBlank(courseWiseSearch.down('#toTime'), true);
								courseWiseSearch.down('#viewQR').hide();
							}

						}else if(attendanceSlot=="CALENDAR_SLOTS"){
							courseWiseSearch.down('#timetableSlotListId').reset();
							courseWiseSearch.down('#timetableSlotListId').setDisabled(false);
							courseWiseSearch.down('#timetableSlotListId').setVisible(false);
							courseWiseSearch.down('#calendarSlotListId').reset();
							courseWiseSearch.down('#calendarSlotListId').setDisabled(true);
							courseWiseSearch.down('#calendarSlotListId').setVisible(true);
							courseWiseSearch.down('#dateOfAttendance_Id').setVisible(true);
							this.setAllowBlank(courseWiseSearch.down('#timetableSlotListId'), true);
							this.setAllowBlank(courseWiseSearch.down('#calendarSlotListId'), false);
							this.setAllowBlank(courseWiseSearch.down('#dateOfAttendance_Id'), false);
							if(data.whetherAdhocRequired) {
								courseWiseSearch.down('#timeContainer').setVisible(true);
								courseWiseSearch.down('#timeBtnAdd').setDisabled(true);
								courseWiseSearch.down('#dateOfAttendance_Id').setDisabled(false);
								courseWiseSearch.down('#fromTime').setDisabled(false);
								courseWiseSearch.down('#toTime').setDisabled(false);
								this.setAllowBlank(courseWiseSearch.down('#fromTime'), false);
								this.setAllowBlank(courseWiseSearch.down('#toTime'), false);
							}else{
								courseWiseSearch.down('#timeContainer').setVisible(false);
								this.setAllowBlank(courseWiseSearch.down('#fromTime'), true);
								this.setAllowBlank(courseWiseSearch.down('#toTime'), true);
							}
						}else if(attendanceSlot=="AD_HOC_SLOTS"){
							courseWiseSearch.down('#timetableSlotListId').reset();
							courseWiseSearch.down('#timetableSlotListId').setDisabled(false);
							courseWiseSearch.down('#timetableSlotListId').setVisible(false);
							courseWiseSearch.down('#calendarSlotListId').reset();
							courseWiseSearch.down('#calendarSlotListId').setVisible(false);
							this.setAllowBlank(courseWiseSearch.down('#timetableSlotListId'), true);
							this.setAllowBlank(courseWiseSearch.down('#calendarSlotListId'), true);
							courseWiseSearch.down('#timeBtnAdd').setDisabled(true);

							courseWiseSearch.down('#dateOfAttendance_Id').setVisible(true);
							courseWiseSearch.down('#timeContainer').setVisible(true);
							this.setAllowBlank(courseWiseSearch.down('#dateOfAttendance_Id'), false);
							this.setAllowBlank(courseWiseSearch.down('#fromTime'), false);
							this.setAllowBlank(courseWiseSearch.down('#toTime'), false);

						}
						
						var academicTerm = courseWiseSearch.down('#academicTerm');
						var academicTermStore = academicTerm.getStore();
						var currentAcademicTermDefine=false;
						academicTermStore.load({
							callback: function(record, operation, success) {
								if (success) {
									if(record.length>0){
										var tabAcademicTerm = null;
										try{
											tabAcademicTerm = $this.getContentPanel().getActiveTab().academicTermId;
										}
										catch(e){}
										if(!isNullOrEmpty(tabAcademicTerm)){
											academicTerm.setValue(tabAcademicTerm);
											$this.getContentPanel().getActiveTab().academicTermId = null;
											currentAcademicTermDefine=true;
										}
										else{
											Ext.each(record, function(value) {
												if(value.get('whetherCurrentAcademicTerm')){
													academicTerm.setValue(value.get('id'));
													currentAcademicTermDefine=true;
												}
											});
										}
									}
								}
							}
						});
						setTimeout(function(){
							if(!currentAcademicTermDefine){
								var courseVariantField = courseWiseSearch.down('#courseVariantId');
								var courseVariantFieldStore = courseVariantField.getStore();
								courseVariantFieldStore.getProxy().extraParams = {
									academyLocationIds:academyLocationId,
									facultyId:facultyId,
									isCurrentPeriod:true
								};
								courseVariantFieldStore.load();
							}
						},1000);

					} else if(attendanceType == 'Multiple Session' || attendanceType == 'MULTIPLE_SESSION') {
						var data=attendanceTypess.data.MULTIPLE_SESSION;
						var date = new Date();
						var minDate = Ext.Date.add(date, Ext.Date.DAY, -data.backDateAllowedForFaculty);
						sessionNumber = data.sessionNo;
						sessionWiseSearch.down("#session_dateOfAttendance_Id").setMinValue(minDate);
						programWiseSearch.setVisible(false);
						sessionWiseSearch.setVisible(true);
						courseWiseSearch.setVisible(false);
						serviceWiseSearch.setVisible(false);
						sessionWiseSearch.down('#session_programBatch_programId').reset();
						this.setAllowBlank(sessionWiseSearch.down('#session_programBatch_programId'),false);
						var programByAcademyLocationStore = sessionWiseSearch.down('#session_programBatch_programId').getStore();
						if(wheatherSchool) {
							sessionWiseSearch.down("#session_programBatch_programId").setFieldLabel(getCourseTxCommonTranslation('ATTENDANCE_PROGRAM_BATCH_SECTION'))
						} else {
							sessionWiseSearch.down("#session_programBatch_programId").setFieldLabel(getCourseTxCommonTranslation('PROGRAM_BATCH_PERIOD_SECTION'))
						}
						programByAcademyLocationStore.getProxy().extraParams = {
							academyLocationIds:academyLocationId,
							facultyId:facultyId,
							onlyCurrentRecords:true,
							wheatherSchool:wheatherSchool
						};
						programByAcademyLocationStore.load();

						var storeArray = [];
						var multipleSessionStore = sessionWiseSearch.down('#newSessionItemId').getStore();
						multipleSessionStore.getProxy().extraParams = {
							type:"multipleSession"
						};
						multipleSessionStore.load({
							callback: function(records, operation, success) {
								if (success) {
									for (s=1;s<=sessionNumber;s++) {
										if(multipleSessionStore.find("code",s)>=0){
											storeArray.push({
												'val':multipleSessionStore.getAt(multipleSessionStore.find("code",s)).get('val'),
												'code':multipleSessionStore.getAt(multipleSessionStore.find("code",s)).get('code')
											});
										} else {
											storeArray.push({'val':s,
												'code': s});
										}
									}
								}
								var store1 = Ext.create('Ext.data.Store', {
									fields: ['val','code'],
									data : storeArray
								});
								sessionWiseSearch.down('#newSessionItemId').bindStore(store1);
								if(storeArray.length>0)
								{
									sessionWiseSearch.down('#newSessionItemId').setValue(1);
								}
							}
						});
					}else if(attendanceType == 'SERVICE_LEVEL' || attendanceType == 'Service Level' ){
						var dataServieAttendance=attendanceTypess.data.SERVICE_LEVEL;
						programWiseSearch.setVisible(false);
						sessionWiseSearch.setVisible(false);
						courseWiseSearch.setVisible(false);
						serviceWiseSearch.setVisible(true);
						serviceWiseSearch.down('#serviceId').reset();
						serviceWiseSearch.down('#serviceBatchId').reset();
						serviceWiseSearch.down('#serviceBatchId').setDisabled(true);
						var serviceStore = serviceWiseSearch.down("#serviceId").getStore();
						serviceStore.getProxy().extraParams = {
							academeyLocationId: academyLocationId,
							coordinatorId:this.getCurrentlyLoggedInUser().id
						};
						serviceStore.load();
						var date = serviceWiseSearch.down('#dateOfAttendance_Id');

						var dateVal = date.getValue();
						var newDate = null;
						Ext.Ajax.request({
							type : 'rest',
							url :SERVERURL.PATH_FIND_SERVER_DATE_TIME,
							method : 'GET',
							async: false,
							success : function(form1, action) {
								data = Ext.JSON.decode(form1.responseText);
								newDate=data.serverDateTimeYYYYMMDDTweentyFourHour;
								newDate = new Date(newDate)
								var fromTime = serviceWiseSearch.down('#fromTime');
								if(dateVal.getDate() == newDate.getDate()){
									var time = moment(newDate).format("HH:mm"); 
									fromTime.setMaxValue(time);
								}

							}});
						if(dataServieAttendance.whetherAdhocRequired) {
							serviceWiseSearch.down('#timeContainer').setVisible(true);
							serviceWiseSearch.down("#fromTime").reset();
							serviceWiseSearch.down("#toTime").reset();
							this.setAllowBlank(serviceWiseSearch.down('#fromTime'), false);
							this.setAllowBlank(serviceWiseSearch.down('#toTime'), false);
						}else{
						serviceWiseSearch.down('#timeContainer').setVisible(false);
						this.setAllowBlank(serviceWiseSearch.down('#fromTime'), true);
						this.setAllowBlank(serviceWiseSearch.down('#toTime'), true);
						}
					}
				},
				changeAttendanceMarkingType:function(obj,record){
					var attendanceStatus = record.attendance;
					var grid = this.getCaptureattendancegrid().down('grid');
					var store = grid.getStore();

					var present=false,absent=false,attStatus=null;
					var prePercent='0%', absPercent='0%';
					var abs=0,pre=0,oth=0;
					this.getCaptureattendancegrid().down('#newOtherStatusId').clearValue();
			        this.getCaptureattendancegrid().down('#newOtherStatusId').setVisible(false);

					if (attendanceStatus == 'PRESENT' || attendanceStatus == 'Present') {
						present = true;
						absent = false;
						attStatus = null;
						pre=store.data.length;
						prePercent='100%';

					} else if (attendanceStatus == 'ABSENT' || attendanceStatus == 'Absent') {
						attStatus = null;
						present = false;
						
						absent = true;
						abs=store.data.length;
						absPercent='100%';

					} else if(record.attendance != undefined){
						this.getCaptureattendancegrid().down('#newOtherStatusId').setVisible(true);
						var store = this.getStore('attendance.AttendanceMarkingTypeStore');
						store.on('load', function(){
							for(var i=0; i< store.data.items.length;i++){
								if(store.data.items[i].data.value == 'Present'){
									store.removeAt(i);
								} 
								if(store.data.items[i].data.value == 'Absent'){
									store.removeAt(i);
								}
							}
						});
					} 

					store.suspendEvents();   
					store.each(function(rec) {
						rec.set('present', present);
						rec.set('absent', absent);
						rec.set('attendanceStatus', attStatus);
					});
					store.resumeEvents();
					grid.getView().refresh();

					var gridCount = this.getCaptureattendancecountgrid();
					var data = {
							totalStudent:store.data.length,
							totalPresent:pre,
							totalAbsent:abs,
							otherCount:oth,
							presentPercent:prePercent,
							absentPercent:absPercent,
					};
					var gridStore =  gridCount.getStore();
					if(store.data.length!=0){
						gridStore.removeAll();
						gridStore.loadRawData(data, true);
					}
				},
				loadCaptureAttendanceStudentGrid:function(){
					var $this = this;
					var grid = $this.getCaptureattendancegrid();
					var radioBts = grid.down('#markOnlyAttendance_Id').items.items;
					for(var i =0; i<radioBts.length;i++){
						radioBts[0].setValue(true);
					}
					var gridCount = $this.getCaptureattendancecountgrid();
					var gridStore =  gridCount.getStore();
					gridStore.removeAll();

					var form = "";
					var structure = $this.getStudentcaptureattendancestructure();
					var attendanceType = structure.down('#newAttendanceTypeRadio').getValue().newAttendanceTypeWise;
					if(attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY') {
						form = $this.getProgramwisecaptureattendancesearch();
						var sectionId = form.down('#facultyAttendanceProgramId').getValue();
						var attendanceDate = Ext.Date.format(form.down('#completeDayDate_Id').getValue(),CONSTANTS.SUBMIT_DATE_FORMAT);
						var store = grid.down('grid').getStore()
						store.getProxy().api.read=SERVERURL.GET_STUDENT_LIST_BY_SECTION_ID;
						store.getProxy().extraParams = {
							sectionId: sectionId,
							date:attendanceDate,
							attendanceType:attendanceType,
             			    portalId:'2'
						};
						store.load({
							callback: function(records, operation, success) {
								if (success) {
									$this.afterSaveAction(records, attendanceType, structure)
								}
							}	   
						});
					} else if (attendanceType == 'Multiple Session' || attendanceType == 'MULTIPLE_SESSION') {
						form = $this.getMultiplesessionwisecaptureattendancesearch();
						var sectionId = form.down('#session_programBatch_programId').getValue();
						var attendanceDate = Ext.Date.format(form.down('#session_dateOfAttendance_Id').getValue(),CONSTANTS.SUBMIT_DATE_FORMAT);
						var sessionNo = form.down('#newSessionItemId').getValue();
						var store = grid.down('grid').getStore()
						store.getProxy().api.read=SERVERURL.GET_STUDENT_LIST_BY_SECTION_ID;
						store.getProxy().extraParams = {
							sectionId: sectionId,
							date:attendanceDate,
							attendanceType:attendanceType,
							sessionNo:sessionNo,
             			    portalId:'2'
						};
						store.load({
							callback: function(records, operation, success) {
								if (success) {
									$this.afterSaveAction(records, attendanceType, structure)
								}
							}	   
						});
					} else if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL'){
						var dateTimeList = [];
						form = $this.getCoursewisecaptureattendancesearch();
						if(!form.isValid()) {
							form.down('#searchBtn').setDisabled(true);
							return;
						} else {
							form.down('#searchBtn').setDisabled(false);
						}
						var courseVariantId = form.down('#courseVariantId').getValue();
						var courseVariantStore = form.down('#courseVariantId').getStore();
						var selectedData  = courseVariantStore.findRecord('id', courseVariantId).data;
						var courseId = selectedData.courseId;
						var courseComponentId = selectedData.courseComponentId;
						if(!isNullOrEmpty(selectedData.parentCourseId)) {
							courseId = selectedData.parentCourseId;
						} 
						var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
						var data = attendanceTypess.data.COURSE_LEVEL;
						var attendanceSlot=data.attendanceSlot;
						var attendanceDate=null;
						var fromTime=null;
						var toTime=null;
						var adhocRequired=false;
						if(attendanceSlot=="TIME_TABLE_SLOTS"){
							var ccpId = form.down('#timetableSlotListId').getValue();
							if(!isNullOrEmpty(ccpId) && ccpId.length>0){
								var timeSlotStore = form.down('#timetableSlotListId').getStore();
								if(typeof ccpId[0]=="object"){
									var currentCcpId = ccpId[0].data.id;
								}
								else{
									var currentCcpId = ccpId[0];
								}
								if(isNullOrEmpty(currentCcpId)){
									adhocRequired=true;
								}else{
									var data = timeSlotStore.findRecord('id', currentCcpId).data;
									attendanceDate = Ext.Date.format(new Date(data.sessionDate), 'Y-m-d');
									fromTime = data.fromTime;
									toTime =  data.toTime;
								}
							}else{
								adhocRequired=true;
							}
							
						}else if(attendanceSlot=="CALENDAR_SLOTS" || attendanceSlot=="AD_HOC_SLOTS"){
							var timeSlot = form.down('#calendarSlotListId').getValue();
							attendanceDate = form.down('#dateOfAttendance_Id').getValue();
							if(!isNullOrEmpty(timeSlot) && timeSlot.length>0 && !isNullOrEmpty(timeSlot[0].data)){
								var timeSlotStore = form.down('#calendarSlotListId').getStore();
								var data = timeSlotStore.findRecord('id', timeSlot[0].data.id).data;
								var tokens = data.value.split(' - ');
								fromTime = tokens[0];
								toTime = tokens[1];
							}else{
								adhocRequired=true;
							}
						}
						if(adhocRequired){
							attendanceDate = form.down('#dateOfAttendance_Id').getValue();
							var formValuesData = form.getForm().getValues();
	                		   if(typeof formValuesData.fromTime=="object"){
			                	   for(var j=0; j<formValuesData.fromTime.length &&  formValuesData.toTime.length; j++){
			                		   dateTimeList.push(formValuesData.fromTime[j] + " - " + formValuesData.toTime[j]);
			                	   }
	                		   }
	                		   else {
	                			   dateTimeList.push(formValuesData.fromTime + " - " + formValuesData.toTime)
	                		   }
							fromTime = formValuesData.fromTime;
							toTime = formValuesData.toTime;
						}
						var store = grid.down('grid').getStore()
						store.getProxy().api.read=SERVERURL.GET_STUDENT_ENROLLED_IN_VARIANT;
						store.getProxy().extraParams = {
							courseVariantId: courseVariantId,
							componentId: courseComponentId,
							courseId : courseId,
							attendanceDate:attendanceDate,
							fromTime:fromTime,
							toTime:toTime,
							attendanceType:attendanceType,
							timeList:dateTimeList.join(),
             			    portalId:'2'
						};
						store.load({
							callback: function(records, operation, success) {
								if (success) {
									$this.afterSaveAction(records, attendanceType, structure)
								}
							}	   
						});
					}
					var store = $this.getStore('attendance.AttendanceMarkingTypeStore');
					store.on('load', function(){
						for(var i=0; i< store.data.items.length;i++){
							if(store.data.items[i].data.value == 'Present'){
								store.removeAt(i);
							} 
							if(store.data.items[i].data.value == 'Absent'){
								store.removeAt(i);
							}
						}
					});
				},
				afterSaveAction : function(records, attendanceType, structure) {
					var $this = this;
 				   if(records.length > 0){
 					  structure.down('#submitBtn').setDisabled(false);
 					   if(records[0].data.attendanceMarkStatus != null) {
 						   if(attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY')
 						   { showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'), getProgramandcourseTranslation("ATTENDANCE_ALREADY_MARKED_CD"));   
 						   } else
 						   {showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'), getProgramandcourseTranslation("ATTENDANCE_ALREADY_MARKED_SELECTEDT_SESSION_DATE"));
 						   }
 						  structure.down('#submitBtn').setDisabled(true);
 						   $this.getStore('attendance.StudentAttendanceList').removeAll();
 					   } else if(records[0].data.isDateAllow != null){
 						   showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'), getProgramandcourseTranslation(records[0].data.isDateAllow));
 						  structure.down('#submitBtn').setDisabled(true);
 						   $this.changeMarkingTypeOnLoad("PRESENT");
 						   $this.loadCaptureAttendanceSummary();
 					   } else if(records[0].data.isWorkingDay != null){
 						   showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'), getProgramandcourseTranslation(records[0].data.isWorkingDay));
 						   $this.changeMarkingTypeOnLoad("PRESENT");
 						   $this.loadCaptureAttendanceSummary();
 					   } else {
 						   $this.loadCaptureAttendanceSummary();
     					   $this.changeMarkingTypeOnLoad("PRESENT");
 					   }
 				   }else{
 					  structure.down('#submitBtn').setDisabled(true);
 				   }
                },
				// Load Attendance summary grid
				loadCaptureAttendanceSummary:function() {
					var this$ = this;
					var grid = this$.getCaptureattendancegrid();
					var store = grid.down('grid').getStore();
					var models = store.getRange();

					var preCount=0,absCount=0, other=0;
					for(var i =0; i<store.data.length;i++){
						if(models[i].data.present)
							preCount++;
						if(models[i].data.absent)
							absCount++;
						if(models[i].data.attendanceStatus)
							other++;
					}
					var gridCount = this$.getCaptureattendancecountgrid();
					var  data = {
							totalStudent:store.data.length,
							totalPresent:preCount,
							totalAbsent:absCount,
							otherCount:other,
							presentPercent:parseFloat((preCount/store.data.length)*100).toFixed(2)+"%",
							absentPercent:parseFloat((absCount/store.data.length)*100).toFixed(2)+"%",
					};
					var gridStore =  gridCount.getStore();
					gridStore.removeAll();
					gridStore.loadRawData(data, true);
				},
				resetStudentAttendance:function() {
					var $this = this;
					var form = "";
					var academyLocationId = this.getCurrentAcademyLocation();
					var facultyId = this.getCurrentlyLoggedInUser().id;
					var structure = $this.getStudentcaptureattendancestructure();
					var attendanceType = structure.down('#newAttendanceTypeRadio').getValue().newAttendanceTypeWise;
					$this.getStudentcaptureattendancestructure().down('#submitBtn').setDisabled(true);
					var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
					if(attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY') {
						form = this.getProgramwisecaptureattendancesearch();
						form.down('#completeDayDate_Id').setValue(dateRender(new Date));
						form.down('#facultyAttendanceProgramId').reset();
					} else if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL'){
						form = this.getCoursewisecaptureattendancesearch();
						var timeSlotPanel = form.down('#panelId');
			            if (timeSlotPanel != null && !timeSlotPanel.items.items[0].isHidden()) {
			            	for(var i=timeSlotPanel.items.length;i>=0;i--){
			            		if(i==0){
			            			timeSlotPanel.items.items[i].setVisible(true);
			            		}else{
			            			timeSlotPanel.remove(timeSlotPanel.items.items[i]);
			            		}
			                    this.hideShowTimeSlotElement(timeSlotPanel);
			            	}
			            }
						form.down('#dateOfAttendance_Id').setValue(dateRender(new Date));
						form.down('#courseVariantId').reset();
						form.down('#topicId').reset();
						form.down('#topicId').setDisabled(true);
						form.down('#academicTerm').reset();
						form.down('#timetableSlotListId').reset();
						form.down('#timetableSlotListId').clearValue();
						form.down('#calendarSlotListId').reset();
						form.down('#fromTime').reset();
						form.down('#toTime').reset();
						if(attendanceTypess.data.COURSE_LEVEL.attendanceSlot=="TIME_TABLE_SLOTS"){
							form.down('#timetableSlotListId').setDisabled(true);
						}else{
							form.down('#calendarSlotListId').setDisabled(true);
						}
						if(attendanceTypess.data.COURSE_LEVEL.whetherAdhocRequired){
							form.down('#dateOfAttendance_Id').setDisabled(false);
							form.down('#fromTime').setDisabled(false);
							form.down('#toTime').setDisabled(false);
						}
						form.down('#fromTime').setMaxValue(null);
						form.down('#toTime').setMinValue(null);
						var academicTerm = form.down('#academicTerm');
						var academicTermStore = academicTerm.getStore();
	            		var currentAcademicTermDefine=false;
	            		academicTermStore.load({
	            			callback: function(record, operation, success) {
	            				if (success) {
	            					if(record.length>0){
	            						Ext.each(record, function(value) {
	            							if(value.get('whetherCurrentAcademicTerm')){
	            								academicTerm.setValue(value.get('id'));
	            								currentAcademicTermDefine=true;
	            							}
	            						});
	            					}
	            				}
	            			}
	            		});
	            		setTimeout(function(){
		            		if(!currentAcademicTermDefine){
		            			var courseVariantField = form.down('#courseVariantId');
		            			var courseVariantFieldStore = courseVariantField.getStore();
		            			courseVariantFieldStore.getProxy().extraParams = {
									academyLocationIds:academyLocationId,
									facultyId:facultyId,
									isCurrentPeriod:true
								};
		            			courseVariantFieldStore.load();
		            		}
	            		},500);
	            		var date = form.down('#dateOfAttendance_Id');

	    				var dateVal = date.getValue();
	    				var newDate = null;
	    				Ext.Ajax.request({
	    					type : 'rest',
	    					url :SERVERURL.PATH_FIND_SERVER_DATE_TIME,
	    					method : 'GET',
	    					async: false,
	    					success : function(form1, action) {
	    						data = Ext.JSON.decode(form1.responseText);
	    						serverCurrentDate=data.serverDateTimeYYYYMMDDTweentyFourHour;
	    						newDate = new Date(serverCurrentDate)
	    						var fromTime = form.down('#fromTime');
	    	    				if(dateVal.getDate() == newDate.getDate()){
	    	    					var time = moment(newDate).format("HH:mm"); 
	    	    					fromTime.setMaxValue(time);
	    	    				}
	    					}});
					}   else if(attendanceType == 'Service Level' || attendanceType == 'SERVICE_LEVEL'){
						  var form = this.getServicewisecaptureattendancesearch().getForm();
		        		  var serviceField=form.findField("service");
		        		  var batchFieldField=form.findField("serviceBatch");
		        		  batchFieldField.setDisabled(true);
		        		  form.findField('dateOfAttendance').setValue(dateRender(new Date));
		        		  serviceField.reset();
		        		  batchFieldField.reset();
		        		  
		        		  form1 = this.getServicewisecaptureattendancesearch();
							var timeSlotPanel = form1.down('#panelId');
				            if (timeSlotPanel != null && !timeSlotPanel.items.items[0].isHidden()) {
				            	for(var i=timeSlotPanel.items.length;i>=0;i--){
				            		if(i==0){
				            			timeSlotPanel.items.items[i].setVisible(true);
				            		}else{
				            			timeSlotPanel.remove(timeSlotPanel.items.items[i]);
				            		}
				                    this.hideShowTimeSlotElement(timeSlotPanel);
				            	}
				            }
				            form.findField('fromTime').reset();
				            form.findField('toTime').reset();
				            form.checkValidity();
				            var date = form.findField('dateOfAttendance');

		    				var dateVal = date.getValue();
		    				var newDate = null;
		    				Ext.Ajax.request({
		    					type : 'rest',
		    					url :SERVERURL.PATH_FIND_SERVER_DATE_TIME,
		    					method : 'GET',
		    					async: false,
		    					success : function(form1, action) {
		    						data = Ext.JSON.decode(form1.responseText);
		    						serverCurrentDate=data.serverDateTimeYYYYMMDDTweentyFourHour;
		    						newDate = new Date(serverCurrentDate)
		    						var fromTime = form.findField('fromTime');
		    	    				if(dateVal.getDate() == newDate.getDate()){
		    	    					var time = moment(newDate).format("HH:mm"); 
		    	    					fromTime.setMaxValue(time);
		    	    				}
		    					}});
	        		  }else {
						var data=attendanceTypess.data.MULTIPLE_SESSION;
						sessionNumber = data.sessionNo;
						sessionWiseSearch = this.getMultiplesessionwisecaptureattendancesearch();
						sessionWiseSearch.down('#session_dateOfAttendance_Id').setValue(dateRender(new Date));
						sessionWiseSearch.down('#session_programBatch_programId').reset();
						var storeArray = [];
						var multipleSessionStore = sessionWiseSearch.down('#newSessionItemId').getStore();
						multipleSessionStore.getProxy().extraParams = {
							type:"multipleSession"
						};
						multipleSessionStore.load({
							callback: function(records, operation, success) {
								if (success) {
									for (s=1;s<=sessionNumber;s++) {
										if(multipleSessionStore.find("code",s)>=0){
											storeArray.push({
												'val':multipleSessionStore.getAt(multipleSessionStore.find("code",s)).get('val'),
												'code':multipleSessionStore.getAt(multipleSessionStore.find("code",s)).get('code')
											});
										} else {
											storeArray.push({'val':s,
												'code': s});
										}
									}
								}
								var store1 = Ext.create('Ext.data.Store', {
									fields: ['val','code'],
									data : storeArray
								});
								sessionWiseSearch.down('#newSessionItemId').bindStore(store1);
								if(storeArray.length>0)
								{
									sessionWiseSearch.down('#newSessionItemId').setValue(1);
								}
							}
						});
					}
					var forms = $this.getCaptureattendancegrid();
					forms.down('#markOnlyAttendance_Id').items.items[0].setValue(false);
					forms.down('#markOnlyAttendance_Id').items.items[1].setValue(false);
					forms.down('#markOnlyAttendance_Id').items.items[2].setValue(false);
					forms.down('#newOtherStatusId').clearValue();
		        	forms.down('#newOtherStatusId').setVisible(false);
					$this.getCaptureattendancegrid().down('grid').getStore().removeAll();
					$this.getCaptureattendancecountgrid().getStore().removeAll();
				},
				attendanceMarkingTypeRadioFields:function(){
					var $this =this;
					Ext.Ajax.request({
						type : 'rest',
						url :SERVERURL.STUDENT_ATTENDANCE_MARKING_TYPE,
						method : 'GET',
						success : function(form, action) {
							var attendanceType = Ext.JSON.decode(form.responseText);
							var varattendanceTypeRadio = $this.getCaptureattendancegrid().down('#markOnlyAttendance_Id');
							if(!varattendanceTypeRadio.items.length){
								for(var i=0, n=attendanceType.length; i<n; i++ ){
									var attendanceName;
									if(attendanceType[i].value == 'Present'){
										attendanceName = getProgramandcourseTranslation('PRESENT');
									}else if(attendanceType[i].value == 'Absent'){
										attendanceName = getProgramandcourseTranslation('ABSENT');
									}
									if(i<=2){
			        					  if(i==0){
					        				  varattendanceTypeRadio.add({
					        					  style:{
					        							 color:'green !important',
					        						 },
					        					  boxLabel: getProgramandcourseTranslation('MARK_ALL')+ attendanceName,
					        					  name:'attendance',
					        					  inputValue: attendanceType[i].value
					        				  });
			        					  }else if(i==1){
			        						  varattendanceTypeRadio.add({
					        					  style:{
					        							 color:'red !important',
					        						 },
					        					  boxLabel: getProgramandcourseTranslation('MARK_ALL') + attendanceName,
					        					  name:'attendance',
					        					  inputValue: attendanceType[i].value
					        				  });
			        					  } else {
			        						  varattendanceTypeRadio.add({
					        					  style:{
					        							 color:'orange !important',
					        						 },
					        					  boxLabel: getProgramandcourseTranslation('MARK_ALL_OTHER'),
					        					  name:'attendance'
					        				  });
			        					  }
			        				  }
								}
								var forms = $this.getCaptureattendancegrid();
								forms.down('#markOnlyAttendance_Id').items.items[0].setValue(false);
								forms.down('#markOnlyAttendance_Id').items.items[1].setValue(false);
							    forms.down('#markOnlyAttendance_Id').items.items[2].setValue(false);
							    forms.down('#newOtherStatusId').clearValue();
				        	    forms.down('#newOtherStatusId').setVisible(false);
							}
						}
					});
				},
				/**
				 * This function is used for save student attendance course level and multiple session and complete day.    
				 */
				saveCaptureStudentAttendance:function(btn){
					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					var $this = this;
					var form = "";
					var structure = $this.getStudentcaptureattendancestructure();
					var academyLocationId = this.getCurrentAcademyLocation();
					var attendanceType = structure.down('#newAttendanceTypeRadio').getValue().newAttendanceTypeWise;
					if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL') {
						form = $this.getCoursewisecaptureattendancesearch();
						/**
						 * Prepare Student Model
						 */
						var store = $this.getStore('attendance.StudentAttendanceList');
						var models = store.getRange();
						var studentCourseAttendanceDetails =[]; 
						for(var i=0;i<store.data.length;i++){
							if(!store.data.items[i].data.attendanceStatus){
								if(models[i].data.present){
									studentCourseAttendanceDetails.push({
										"admissionId":store.data.items[i].data.admissionId,
										"attendanceStatus": 'PRESENT',
										"attendanceComment" : store.data.items[i].data.comment,
										"attendanceMarkingType" : this.getIdValueJson(1)
									}); 
								}else{
									studentCourseAttendanceDetails.push({
										"admissionId":store.data.items[i].data.admissionId,
										"attendanceStatus": 'ABSENT',
										"attendanceComment" : store.data.items[i].data.comment,
										"attendanceMarkingType" : this.getIdValueJson(2)
									});
								}
							}else if(!isNullOrEmpty(store.data.items[i].data.markingType)){
								if(models[i].data.present){
									studentCourseAttendanceDetails.push({
										"admissionId":store.data.items[i].data.admissionId,
										"attendanceStatus": 'PRESENT',
										"attendanceComment" : store.data.items[i].data.comment,
										"attendanceMarkingType" : this.getIdValueJson(1)
									}); 
								}else{
									studentCourseAttendanceDetails.push({
										"admissionId":store.data.items[i].data.admissionId,
										"attendanceStatus": 'ABSENT',
										"attendanceComment" : store.data.items[i].data.comment,
										"attendanceMarkingType" : this.getIdValueJson(2)
									});
								}
	           	    		  }else{
								studentCourseAttendanceDetails.push({
									"admissionId":store.data.items[i].data.admissionId,
									"attendanceStatus":store.data.items[i].data.attendanceMarkStatus,
									"attendanceComment" : store.data.items[i].data.comment,
									"attendanceMarkingType" : this.getIdValueJson(store.data.items[i].data.attendanceMarkingType)
								});
							}
						}
						/**
						 * END
						 */
						var studentCourseAttendances =[]; 
						var cvId = form.down('#courseVariantId').getValue();
						var cvObject = form.down('#courseVariantId');
						var topicId = form.down('#topicId').getValue();
						values=	cvObject.store.getAt(cvObject.store.findExact('id',cvId)).data;		
						var facultyId = this.getCurrentlyLoggedInUser().id
						var sectionId = values.sectionId;
						var courseId = values.courseId;
						if(!isNullOrEmpty(values.parentCourseId)) {
							courseId = values.parentCourseId;
							}
						var courseComponentId = values.courseComponentId;
						var attendanceData = Academia.model.authentication.AttendanceSettingModel.data.COURSE_LEVEL;
						var facultyConflictCheck = attendanceData.concurrentAttendanceAllowed;
						var ccpId = form.down('#timetableSlotListId').getValue();
						var timeSlot = form.down('#calendarSlotListId').getRawValue();
						try{
							if(typeof ccpId[0]=="object"){
								var currentCcpId1 = ccpId[0].data.id;
							}
							else{
								var currentCcpId1 = ccpId[0];
							}
						}
						catch(e){
							var currentCcpId1 = '';
						}
						if(!isNullOrEmpty(ccpId) && ccpId.length>0 && !isNullOrEmpty(currentCcpId1)){
							var timeslotValues = form.down('#timetableSlotListId').getValue();
							for(var i in timeslotValues) {
								var timeSlotStore = form.down('#timetableSlotListId').getStore();
								if(typeof ccpId[i]=="object"){
									var currentCcpId = ccpId[i].data.id;
								}
								else{
									var currentCcpId = ccpId[0];
								}
								var data = timeSlotStore.findRecord('id', currentCcpId).data;
								var attendanceDate = Ext.Date.format(new Date(data.sessionDate), 'Y-m-d');
								var fromTime = data.fromTime;
								var toTime =  data.toTime;
								var studentCourseAttendance = new Academia.model.attendance.StudentCourseAttendance();
								studentCourseAttendance.set("courseId",courseId);
								studentCourseAttendance.set("sectionId",sectionId);
								studentCourseAttendance.set("courseVariantId",cvId);
								studentCourseAttendance.set("dateOfAttendance",attendanceDate);
								studentCourseAttendance.set("academyLocationId",academyLocationId);
								studentCourseAttendance.set("slotFrom",fromTime);
								studentCourseAttendance.set("slotTo",toTime);
								studentCourseAttendance.set("facultyId",facultyId);
								studentCourseAttendance.set("attendanceMarkedBy",facultyId);
								if(courseComponentId!="" && courseComponentId!= null){
									studentCourseAttendance.set("componentId",courseComponentId);
								}
								studentCourseAttendance.set("sessionPlanningDone", true);
								studentCourseAttendance.set("facultyConflictCheck", facultyConflictCheck);
								studentCourseAttendance.set("adhocSlot", false);
								studentCourseAttendance.set("isMobile",false);
								var topicId = form.down('#topicId').getValue();
	      			        	var topicIds = [];
	      			        	if(topicId !=undefined && topicId.length > 0){
	      	                		 for(var i in topicId){
	      	                			 if(Ext.isObject(topicId[i])){
	      	                				 topicIds.push({
	                	    					  "courseTopic":$this.getIdValueJson(topicId[i].get("id"))
	                	    				  })
	      	                			 }else{
	      	                				 topicIds.push({
	      	                					"courseTopic":$this.getIdValueJson(topicId[i])
	      	                				 });
	      	                			 }
	      	                		 }
	      	                		 studentCourseAttendance.set("studentCourseAttendanceTopics", topicIds);
	      	                	 }
								studentCourseAttendance.set("studentCourseAttendanceDetails",studentCourseAttendanceDetails);
								studentCourseAttendances.push(studentCourseAttendance.data);
							}
						} else if(!isNullOrEmpty(timeSlot)){
							var timeSlotValues = form.down('#calendarSlotListId').getValue();
							if(!isNullOrEmpty(timeSlotValues) && timeSlotValues.length>0 && !isNullOrEmpty(timeSlotValues[0].data)){
								for(var i in timeSlotValues) {
									var timeSlotStore = form.down('#calendarSlotListId').getStore();
									var data = timeSlotStore.findRecord('id', timeSlotValues[i].data.id).data;
									var tokens = data.value.split(' - ');
									var fromTime = tokens[0];
									var toTime = tokens[1];
									var formValuesData = form.getForm().getValues();
									var attendanceDate = form.down('#dateOfAttendance_Id').getValue();
									var studentCourseAttendance = new Academia.model.attendance.StudentCourseAttendance();
									studentCourseAttendance.set("courseId",courseId);
									studentCourseAttendance.set("sectionId",sectionId);
									studentCourseAttendance.set("courseVariantId",cvId);
									studentCourseAttendance.set("dateOfAttendance",attendanceDate);
									studentCourseAttendance.set("academyLocationId",academyLocationId);
									studentCourseAttendance.set("slotFrom",fromTime);
									studentCourseAttendance.set("slotTo",toTime);
									studentCourseAttendance.set("facultyId",facultyId);
									studentCourseAttendance.set("attendanceMarkedBy",facultyId);
									if(courseComponentId!="" && courseComponentId!= null){
										studentCourseAttendance.set("componentId",courseComponentId);
									}
									studentCourseAttendance.set("sessionPlanningDone", false);
									studentCourseAttendance.set("facultyConflictCheck", facultyConflictCheck);
									studentCourseAttendance.set("adhocSlot", false);
									studentCourseAttendance.set("isMobile",false);
									var topicId = form.down('#topicId').getValue();
		      			        	var topicIds = [];
		      			        	if(topicId !=undefined && topicId.length > 0){
		      	                		 for(var i in topicId){
		      	                			 if(Ext.isObject(topicId[i])){
		      	                				 topicIds.push({
		                	    					  "courseTopic":$this.getIdValueJson(topicId[i].get("id"))
		                	    				  })
		      	                			 }else{
		      	                				 topicIds.push({
		      	                					"courseTopic":$this.getIdValueJson(topicId[i])
		      	                				 });
		      	                			 }
		      	                		 }
		      	                		 studentCourseAttendance.set("studentCourseAttendanceTopics", topicIds);
		      	                	 }
									studentCourseAttendance.set("studentCourseAttendanceDetails",studentCourseAttendanceDetails);
									studentCourseAttendances.push(studentCourseAttendance.data);
								}
							}
						
						}else{
							if(attendanceData.whetherAdhocRequired) {
								var formValuesData = form.getForm().getValues();
								var attendanceDate = form.down('#dateOfAttendance_Id').getValue();
								var dateTimeList = [];
		                		   if(typeof formValuesData.fromTime=="object"){
				                	   for(var j=0; j<formValuesData.fromTime.length &&  formValuesData.toTime.length; j++){
				                		   dateTimeList.push({
				                			   "fromTime":formValuesData.fromTime[j],
				                			   "toTime": formValuesData.toTime[j]
				                		   });
				                	   }
		                		   }
		                		   else {
		                			   dateTimeList.push({
		                				   "fromTime":formValuesData.fromTime,
			                			   "toTime": formValuesData.toTime
			                		   });
		                		   }
								if(!isNullOrEmpty(dateTimeList) && dateTimeList.length > 0) {
				        			  for(var i in dateTimeList) {
				        				  var studentCourseAttendance = new Academia.model.attendance.StudentCourseAttendance();
											studentCourseAttendance.set("courseId",courseId);
											studentCourseAttendance.set("sectionId",sectionId);
											studentCourseAttendance.set("courseVariantId",cvId);
											studentCourseAttendance.set("dateOfAttendance",attendanceDate);
											studentCourseAttendance.set("academyLocationId",academyLocationId);
											studentCourseAttendance.set("slotFrom",dateTimeList[i].fromTime);
											studentCourseAttendance.set("slotTo",dateTimeList[i].toTime);
											studentCourseAttendance.set("facultyId",facultyId);
											studentCourseAttendance.set("attendanceMarkedBy",facultyId);
											if(courseComponentId!="" && courseComponentId!= null){
												studentCourseAttendance.set("componentId",courseComponentId);
											}
											studentCourseAttendance.set("sessionPlanningDone", false);
											studentCourseAttendance.set("facultyConflictCheck", facultyConflictCheck);
											studentCourseAttendance.set("adhocSlot", true);
											studentCourseAttendance.set("isMobile",false);
											var topicId = form.down('#topicId').getValue();
				      			        	var topicIds = [];
				      			        	if(topicId !=undefined && topicId.length > 0){
				      	                		 for(var i in topicId){
				      	                			 if(Ext.isObject(topicId[i])){
				      	                				 topicIds.push({
				                	    					  "courseTopic":$this.getIdValueJson(topicId[i].get("id"))
				                	    				  })
				      	                			 }else{
				      	                				 topicIds.push({
				      	                					"courseTopic":$this.getIdValueJson(topicId[i])
				      	                				 });
				      	                			 }
				      	                		 }
				      	                		 studentCourseAttendance.set("studentCourseAttendanceTopics", topicIds);
				      	                	 }
											studentCourseAttendance.set("studentCourseAttendanceDetails",studentCourseAttendanceDetails);
											studentCourseAttendances.push(studentCourseAttendance.data);
					        		  }
				        		  }
							} 
						}
						var submitUrl = SERVERURL.CREATE_STUDENT_COURSE_ATTENDANCE;;
						var formData = Ext.encode(studentCourseAttendances);
						Ext.Ajax.request({
							type : 'rest',
							url : submitUrl,
							jsonData : formData,
							method : 'POST',
							success : function(form, action) {
								Ext.getBody().unmask();
								btn.isSaving = false;
								var msg = form.responseText;
								if(!isNullOrEmpty(msg) && msg =='DUPLICATE_ATTENDANCE'){
									showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getProgramandcourseTranslation('ATTENDANCE_ALREADY_MARKED_DATE_TIME_SLOT'));
								} else if(!isNullOrEmpty(msg) && msg =='NO_SESSION') {
									showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getProgramandcourseTranslation('NO_SESSION_FOUND'));
								} else if(!isNullOrEmpty(msg) && msg =='MULTIPLE_SESSION_FOUND'){
									showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getProgramandcourseTranslation('MULTIPLE_SESSION_FOUND'));
								} else if(!isNullOrEmpty(msg) && msg =='FROM_TIME_NULL'){
									showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getProgramandcourseTranslation('FROM_TIME_NULL'));
								} 
								else if(msg!='' && msg=='SUCCESS'){
									var gridCount = Ext.getCmp('studentAttendancecountGridId');
									var models = gridCount.getStore().getRange();
									models[0].set('totalStudent',0);
									models[0].set('totalPresent',0);
									models[0].set('totalAbsent',0);
									models[0].set('otherCount',0);
									models[0].set('presentPercent','0%');
									models[0].set('absentPercent','0%');
									showSuccessMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getCommonTranslation('SUCCESS'));
									$this.getStudentcaptureattendancestructure().down('#submitBtn').setDisabled(true);
									$this.resetStudentAttendance();
								}else{
								}	       			  
							}
						});
					} else if(attendanceType == 'Service Level' || attendanceType == 'SERVICE_LEVEL'){
	            		  var typeOfAttendanc;
	            		  var studentServiceAttendanceArray = [];
	            		  if(attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY'){
	            			  typeOfAttendanc = 'COMPLETE_DAY';
	            		  }else if(attendanceType == 'Multiple Session' || attendanceType == 'MULTIPLE_SESSION'){
	            			  typeOfAttendanc = 'MULTIPLE_SESSION';
	            		  }else if(attendanceType == 'COURSE_LEVEL' || attendanceType == 'Course Level'){
	            			  typeOfAttendanc = 'COURSE_LEVEL';
	            		  }else if(attendanceType == 'SERVICE_LEVEL' || attendanceType == 'Service Level'){
	            			  typeOfAttendanc = 'SERVICE_LEVEL';
	            		  }
	            		  	var grid = $this.getCaptureattendancegrid();
							var store = grid.down('grid').getStore()	 
							var form = $this.getServicewisecaptureattendancesearch().getForm();
							var formValues = form.getValues();
							if(typeof formValues.fromTime != "object"){
		        				  var fromTimeArray = [formValues.fromTime];
		        				  var toTimeArray = [formValues.toTime];
		        			  }
		        			  else{
		        				  var fromTimeArray = formValues.fromTime;
		        				  var toTimeArray = formValues.toTime;
		        			  }
							 var wsStdServiceAttendanceCordinatorDtls=[];
							 var facultyId = this.getCurrentlyLoggedInUser().id;
							 var coordinator;
							  coordinator={id:facultyId}
							  wsStdServiceAttendanceCordinatorDtls.push({
							 coordinator:coordinator
							 });
	    	        	  
							 for(var i=0;i<store.data.length;i++){
	    	           	    	var studentServiceAttendance =new Academia.model.attendance.StudentServiceAttendance();
	    	        		  studentServiceAttendance.set("programId",store.data.items[i].data.programId);
	                		  studentServiceAttendance.set("serviceId",formValues.service);
	                		  studentServiceAttendance.set("batchId", store.data.items[i].raw.batchId);
	                		  studentServiceAttendance.set("dateOfAttendance",formValues.dateOfAttendance);
	                		  studentServiceAttendance.set("attendanceType",typeOfAttendanc);
	                		  studentServiceAttendance.set("academyLocationId",academyLocationId);
	        	        	  studentServiceAttendance.set("id", store.data.items[i].data.attendanceId);
	        	        	  var studentServiceAttendanceDetails =[]; 
	        	        	  var models = store.getRange();
	    	        		  if(!store.data.items[i].data.attendanceStatus){
	    	        			  if(models[i].data.present){
	    	        				  studentServiceAttendanceDetails.push({
	    		        				  "admissionId":store.data.items[i].data.admissionId,
	    		        				  "seatConfigId":store.data.items[i].data.seatConfigId,
	    		        				  "attendanceStatus": 'PRESENT',
	    		        				  "attendanceId":store.data.items[i].data.attendanceId,
	    		        				  "id":store.data.items[i].data.id,
	    		        				  "attendanceComment" : store.data.items[i].data.comment,
	    		        				  "attendanceMarkingType" : this.getIdValueJson(1)
	    		        			  }); 
	    	        			  }else{
	    	        				  studentServiceAttendanceDetails.push({
	    		        				  "admissionId":store.data.items[i].data.admissionId,
	    		        				  "seatConfigId":store.data.items[i].data.seatConfigId,
	    		        				  "attendanceStatus": 'ABSENT',
	    		        				  "attendanceId":store.data.items[i].data.attendanceId,
	    		        				  "id":store.data.items[i].data.id,
	    		        				  "attendanceComment" : store.data.items[i].data.comment,
	    		        				  "attendanceMarkingType" : this.getIdValueJson(2)
	    		        			  }); 
	    	        			  }
	    	        		  }else{
	    	        			  var attendanceTest = store.data.items[i].data.attendanceStatus;
	    	        			  studentServiceAttendanceDetails.push({
	    	        				  "admissionId":store.data.items[i].data.admissionId,
	    	        				  "seatConfigId":store.data.items[i].data.seatConfigId,
	    	        				  "attendanceStatus":store.data.items[i].data.attendanceMarkStatus,
	    	        				  "attendanceId":store.data.items[i].data.attendanceId,
	    	        				  "id":store.data.items[i].data.id,
	    	        				  "attendanceComment" : store.data.items[i].data.comment,
	    	        				  "attendanceMarkingType" : this.getIdValueJson(store.data.items[i].data.attendanceMarkingType)
	    	        			  });
	    	        		  }
	        	        	  studentServiceAttendance.set("studentServiceAttendanceDetails",studentServiceAttendanceDetails);
	        	        	  studentServiceAttendance.set("studentServiceAttendanceCoordinatorDtls",wsStdServiceAttendanceCordinatorDtls); 
	        	        	  studentServiceAttendanceArray.push(studentServiceAttendance.data);
	    	        	  }
	    	        	  
	    	        	  var allBatchIdsArray = Ext.Array.pluck(studentServiceAttendanceArray, 'batchId');
	    	        	  var alreadyPushedBatchIds = [];
	    	        	  var finalData = [];
	    	        	  
	    	        	  Ext.each(studentServiceAttendanceArray, function(currentStudentServiceAttendance){
	    	        		  if(alreadyPushedBatchIds.length == 0){
	    	        			  finalData.push(currentStudentServiceAttendance);
	    	        			  alreadyPushedBatchIds.push(currentStudentServiceAttendance.batchId);
	    	        		  }
	    	        		  else{
	    	        			  var foundIdx = alreadyPushedBatchIds.indexOf(currentStudentServiceAttendance.batchId);
	    	        			  
	    	        			  if(foundIdx == -1){
	    	        				  finalData.push(currentStudentServiceAttendance);
	        	        			  alreadyPushedBatchIds.push(currentStudentServiceAttendance.batchId);
	    	        			  }
	    	        			  else{
	    	        				  finalData[foundIdx]['studentServiceAttendanceDetails'].push(currentStudentServiceAttendance.studentServiceAttendanceDetails[0]);
	    	        			  }
	    	        		  }
	    	        	  });
	    	        	 var serviceData= Academia.model.authentication.AttendanceSettingModel.data.SERVICE_LEVEL
	    	        	  if(serviceData.whetherAdhocRequired){
	    	        		  var tempFinalArray = [];
	    	        		  for (var i = 0; i < toTimeArray.length; i++) {
	    	        		      for (var j = 0; j < finalData.length; j++) {
	    	        		          var tempFinal = Object.assign({}, finalData[j]); // Clone the object
	    	        		          var fromTime = fromTimeArray[i];
	    	        		          var toTime = toTimeArray[i];
	    	        		          tempFinal["fromTime"] = fromTime;
	    	        		          tempFinal["toTime"] = toTime;
	    	        		          tempFinalArray.push(tempFinal);
	    	        		      }
	    	        		  }
	    	        		  finalData=[];
	    	        		  finalData=tempFinalArray;
	    	        	  }

	    	        	  var submitUrl;
	    	        	  if (form.findField('id').getSubmitValue() == null
	    	        			  || form.findField('id' ).getSubmitValue() == "") {
	    	        		  submitUrl = SERVERURL.SAVE_STUDENT_SERVICE_WISE_ATTENDANCE;
	    	        	  } else {
	    	        		  //courseReading.set("id", values.id);
	    	        		  //submitUrl = SERVERURL.;
	    	        	  }
	    	        	  var formData = Ext.encode(finalData);
	    	        	  //Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	    	        	  
	    	        	  Ext.Ajax.request({
	    	        		  type : 'rest',
	    	        		  url : submitUrl,
	    	        		  jsonData : formData,
	    	        		  method : 'POST',
	    	        		  success : function(form, action) {
	    	        			  Ext.getBody().unmask();
	    	        			  btn.isSaving = false;
	    	        			  var msg = form.responseText;
	    	        			  if(msg!='' && msg=='SUCCESS'){
	    	        				  showSuccessMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getCommonTranslation('SUCCESS'));
	    	        				  $this.getStudentcaptureattendancestructure().down('#submitBtn').setDisabled(true);
	    		        			  $this.resetStudentAttendance();
//	    		        			  var gridCount = Ext.getCmp('studentAttendancecountGridId');
	    		        			  var gridCount = $this.getCaptureattendancecountgrid();
	    		        			  var models = gridCount.getStore().getRange();
	    		        			  if(models.length > 0){
	    		        			  models[0].set('totalStudent',0);
	    		        			  models[0].set('totalPresent',0);
	    		        			  models[0].set('totalAbsent',0);
	    		        			  models[0].set('otherCount',0);
	    		        			  models[0].set('presentPercent','0%');
	    		        			  models[0].set('absentPercent','0%');
	    		        			 }
	    	        			  } 
	    	        			  else if(msg!='' && msg=='DUPLICATE_ATTENDANCE'){
	    	        				  Ext.getBody().unmask();
	    	        				  showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getProgramandcourseTranslation('STUDENT_SERVICE_DUPLICATE_ATTENDANCE'));
	    	        			  } else{
	    	        			  }
	    	        		  }
	    	        	  });
	           	      
						
					}
					else {
						var sectionId = "";
						var values = "";
						var dateOfAttendance = "";
						var studentAttendance =new Academia.model.attendance.StudentAttendance();
						if(attendanceType == 'COMPLETE_DAY' || attendanceType == 'Complete Day') {
							form = $this.getProgramwisecaptureattendancesearch();
							sectionId = form.down('#facultyAttendanceProgramId').getValue();
							values = form.down('#facultyAttendanceProgramId').getStore().findRecord('sectionId', sectionId).data;
							dateOfAttendance = form.down('#completeDayDate_Id').getValue();
						} else {
							form = $this.getMultiplesessionwisecaptureattendancesearch();
							sectionId = form.down('#session_programBatch_programId').getValue();
							values = form.down('#session_programBatch_programId').getStore().findRecord('sectionId', sectionId).data;
							dateOfAttendance = form.down('#session_dateOfAttendance_Id').getValue();
							var sessionNo = form.down('#newSessionItemId').getValue();
							studentAttendance.set("sessionNo",sessionNo );
						}
						
						var facultyId = this.getCurrentlyLoggedInUser().id
						studentAttendance.set("programId",values.programId);
						studentAttendance.set("batchId",values.batchId);
						studentAttendance.set("periodId",values.periodId);
						studentAttendance.set("sectionId",values.sectionId);
						studentAttendance.set("dateOfAttendance",dateOfAttendance);
						studentAttendance.set("attendanceType",attendanceType);
						studentAttendance.set("facultyId",facultyId);
						studentAttendance.set("academyLocationId",academyLocationId);

						var store = $this.getCaptureattendancegrid().down('grid').getStore();
						studentAttendance.set("id", store.data.items[0].data.attendanceId);
						var studentProgramAttendanceDetails =[]; 
						var models = store.getRange();
						for(var i=0;i<store.data.length;i++){
							if(!store.data.items[i].data.attendanceStatus){
								if(models[i].data.present){
									studentProgramAttendanceDetails.push({
										"admissionId":store.data.items[i].data.admissionId,
										"attendanceStatus": 'PRESENT',
										"attendanceId":store.data.items[i].data.attendanceId,
										"id":store.data.items[i].data.id,
										"attendanceComment" : store.data.items[i].data.comment,
										"attendanceMarkingType" : this.getIdValueJson(1)
									}); 
								}else{
									studentProgramAttendanceDetails.push({
										"admissionId":store.data.items[i].data.admissionId,
										"attendanceStatus": 'ABSENT',
										"attendanceId":store.data.items[i].data.attendanceId,
										"id":store.data.items[i].data.id,
										"attendanceComment" : store.data.items[i].data.comment,
										"attendanceMarkingType" : this.getIdValueJson(2)
									}); 
								}
							}else if(!isNullOrEmpty(store.data.items[i].data.markingType)){
								if(models[i].data.present){
									studentProgramAttendanceDetails.push({
										"admissionId":store.data.items[i].data.admissionId,
										"attendanceStatus": 'PRESENT',
										"attendanceId":store.data.items[i].data.attendanceId,
										"id":store.data.items[i].data.id,
										"attendanceComment" : store.data.items[i].data.comment,
										"attendanceMarkingType" : this.getIdValueJson(1)
									}); 
								}else{
									studentProgramAttendanceDetails.push({
										"admissionId":store.data.items[i].data.admissionId,
										"attendanceStatus": 'ABSENT',
										"attendanceId":store.data.items[i].data.attendanceId,
										"id":store.data.items[i].data.id,
										"attendanceComment" : store.data.items[i].data.comment,
										"attendanceMarkingType" : this.getIdValueJson(2)
									}); 
								}
		       	    		  }else{
								var attendanceTest = store.data.items[i].data.attendanceStatus;
								studentProgramAttendanceDetails.push({
									"admissionId":store.data.items[i].data.admissionId,
									"attendanceStatus":store.data.items[i].data.attendanceMarkStatus,
									"attendanceId":store.data.items[i].data.attendanceId,
									"id":store.data.items[i].data.id,
									"attendanceComment" : store.data.items[i].data.comment,
									"attendanceMarkingType" : this.getIdValueJson(store.data.items[i].data.attendanceMarkingType)
								});
							}
						}

						studentAttendance.set("studentProgramAttendanceDetails",studentProgramAttendanceDetails);
						var submitUrl = SERVERURL.SAVE_STUDENT_ATTENDANCE;
						var formData = Ext.encode(studentAttendance.data);

						Ext.Ajax.request({
							type : 'rest',
							url : submitUrl,
							jsonData : formData,
							method : 'POST',
							success : function(form, action) {
								Ext.getBody().unmask();
								btn.isSaving = false;
								var msg = form.responseText;
								if(msg!='' && msg=='SUCCESS'){
									showSuccessMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getCommonTranslation('SUCCESS'));
									$this.getStudentcaptureattendancestructure().down('#submitBtn').setDisabled(true);
									$this.resetStudentAttendance();
									var gridCount = $this.getCaptureattendancecountgrid();;
									var models = gridCount.getStore().getRange();
									if(models.length > 0){
										models[0].set('totalStudent',0);
										models[0].set('totalPresent',0);
										models[0].set('totalAbsent',0);
										models[0].set('otherCount',0);
										models[0].set('presentPercent','0%');
										models[0].set('absentPercent','0%');
									}
								} 
								else if(msg!='' && msg=='DUPLICATE_ATTENDANCE'){
									Ext.getBody().unmask();
									btn.isSaving = false;
									showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getProgramandcourseTranslation('DUPLICATE_ATTENDANCE'));
								} else{
								}
							}
						});
					}
				},
				// reset student form
				resetStudentAttendanceForm:function(){
					var $this = this;
					$this.resetStudentAttendance();
				},
				
				viewQrCodeForFacultyPortal: function(btn){
					var $this=this;
					var grid = $this.getCaptureattendancegrid();
					var form = $this.getDownloadstudentattendanceform();
					var structure = $this.getStudentcaptureattendancestructure();
					var attendanceType = structure.down('#newAttendanceTypeRadio').getValue().newAttendanceTypeWise;
					var facultyAttendanceProgramId=structure.down('#facultyAttendanceProgramId').rawValue;
					var completeDayDate_Id=structure.down('#completeDayDate_Id').rawValue;


					var session_programBatch_programId=structure.down('#session_programBatch_programId').rawValue;
					var newSessionItemId=structure.down('#newSessionItemId').rawValue;
					var session_dateOfAttendance_Id=structure.down('#session_dateOfAttendance_Id').rawValue;

					var academicTerm=structure.down('#academicTerm').rawValue;
					var courseVariantIds=structure.down('#courseVariantId').rawValue;
					var timetableSlotListId=structure.down('#timetableSlotListId').rawValue;
					var topicId=structure.down('#topicId').rawValue;

					var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
					var data = attendanceTypess.data.COURSE_LEVEL;
					var attendanceSlot=data.attendanceSlot;

					var adhocRequired = false;
					if(attendanceTypess.data.COURSE_LEVEL.whetherAdhocRequired){
						var adhocRequired = attendanceTypess.data.COURSE_LEVEL.whetherAdhocRequired;
					}

					var store = ''; 
					if(attendanceType == 'COURSE_WISE' || attendanceType == 'COURSE_LEVEL') {
						var form = $this.getCoursewisecaptureattendancesearch();
						var courseVariantId = form.down('#courseVariantId').getValue();
						var courseVariantStore = form.down('#courseVariantId').getStore();
						var fromTime=form.down("#fromTime").getValue();
						var toTime=form.down("#toTime").getValue();
						var attendanceDate=form.down("#dateOfAttendance_Id").getValue();
						var selectedData  = courseVariantStore.findRecord('id', courseVariantId).data;
						var courseId = selectedData.courseId;
						var courseComponentId = selectedData.courseComponentId;
						if(!isNullOrEmpty(selectedData.parentCourseId)) {
							courseId = selectedData.parentCourseId;
						} 

						store = grid.down('grid').getStore();
						var dateTimeList = [];
						store.getProxy().api.read=SERVERURL.GET_STUDENT_ENROLLED_IN_VARIANT;
						store.getProxy().extraParams = {
							courseVariantId: courseVariantId,
							componentId: courseComponentId,
							courseId : courseId,
							attendanceDate:attendanceDate,
							fromTime:fromTime,
							toTime:toTime,
							attendanceType:attendanceType,
							timeList:dateTimeList.join(),
							portalId:'2'
						}


						var isAdHoc = adhocRequired;
						if(attendanceSlot == 'TIME_TABLE_SLOTS' && !isAdHoc) {
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CANNOT_SHOW_QR_FOR_SELECTED_CONFIGURATIONS'));
							//--CANNOT VIEW
							return false;
						}  else if(attendanceSlot == 'TIME_TABLE_SLOTS' && isAdHoc){
							if(!isNullOrEmpty(timetableSlotListId) && timetableSlotListId.length){
								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CANNOT_SHOW_QR_FOR_SELECTED_CONFIGURATIONS'));
								//--CANNOT VIEW
								return false;
							} else {
								var formValues = form.getValues();
								var fromTimeSelected = formValues.fromTime;
								var toTimeSelected = formValues.toTime;

								var fromTimeArray = [];
								var toTimeArray = [];
								if(Ext.isArray(form.getValues().fromTime)){
									fromTimeArray = form.getValues().fromTime;
								}
								else{
									fromTimeArray.push(form.getValues().fromTime)
								}

								if(Ext.isArray(form.getValues().toTime)){
									toTimeArray = form.getValues().toTime;
								}
								else{
									toTimeArray.push(form.getValues().toTime)
								}

								if(fromTimeArray.length > 1 || toTimeArray.length > 1){
									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('QR_CANNOT_BE_GENERATED_FOR_MULTIPLE_TIME_SLOTS'));	
									return false;
								}
								
								var qrDataModel = {};
								
								
								
								//--
								
								qrDataModel.qrData = {
										qrId: undefined,
										courseVariantId:courseVariantIds,
										courseId:courseId
								};
								   
								   var qrDisplayData = form.down('#courseVariantId').getDisplayValue() + ' | ' + fromTimeSelected + ' - ' + toTimeSelected + ' | ' + this.getCurrentlyLoggedInUser().value + ' | ' + dateRender(attendanceDate);
			 						
								   Ext.Ajax.request({
					                    type: 'rest',
					                    url: SERVERURL.PATH_COURSE_ATTENDANCE_QR,										 
					                    method: 'GET',
					                    headers: {
					                        'Content-Type': 'application/json'
					                    },
					                    params: {
											courseVariantId:courseVariantId,
											academyLocationId:this.getCurrentAcademyLocation(),
											//sectionId:sectionId,
											attendanceType:attendanceType,
											facultyId:this.getCurrentlyLoggedInUser().id,
											attendanceDate:attendanceDate,
											slotFrom:fromTimeSelected,
											slotTo:toTimeSelected,
											programId:"",
											batchId:"",
											periodId:""	
					                    },
					                    success: function(form, action) {
					                    	if(isNullOrEmpty(form.responseText)){
					                    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('THE_QR_CODE_FOR_THIS_SESSION_IS_NOT_YET_GENERATED_YOU_CAN_GENERATE_IT_FROM_CAPTURE_ATTENDANCE_SCREEN'));
					                    	}else{
					                    		Ext.Ajax.request({
								                    type: 'rest',
								                    url: SERVERURL.PATH_COURSE_ATTENDANCE_QR_CODE,											 
								                    method: 'GET',
								                    headers: {
								                        'Content-Type': 'application/json'
								                    },
								                    params: {
														courseVariantId:courseVariantId,
														academyLocationId:$this.getCurrentAcademyLocation(),
														//sectionId:sectionId,
														attendanceType:attendanceType,
														facultyId:$this.getCurrentlyLoggedInUser().id,
														attendanceDate:attendanceDate,
														slotFrom:fromTimeSelected,
														slotTo:toTimeSelected,
														programId:"",
														batchId:"",
														periodId:"",
														checkExpiry: true
								                    },
								                    success: function(form1, action1) {
								                    	if(isNullOrEmpty(form1.responseText)){
								                    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('THE_QR_CODE_FOR_THIS_SESSION_IS_NOT_YET_GENERATED_YOU_CAN_GENERATE_IT_FROM_CAPTURE_ATTENDANCE_SCREEN'));
								                    	} else if (form1.responseText == "QR_CODE_EXPIRE"){
								                    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('QR_CODE_EXPIRED'));
								                    	}else{
								                    		
								                    		var qrCodeText = '';
								                    		if(attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY'){
								                    			qrCodeText = 'CD-'+form1.responseText; //CompleteDay
								                    		}
								                    		else if(attendanceType == 'Multiple Session' || attendanceType == 'MULTIPLE_SESSION'){
								                    			qrCodeText = 'MS-'+form1.responseText; //MultipleSessions
								                    		}
								                    		else{
								                    			qrCodeText = 'CW-'+form1.responseText; //CourseWise
								                    		}
								                    		
								                    		var formWindow =  $this.getQrcodewindow();
								                    		if (!formWindow) {
								                    			Ext.widget('qrcodewindow',{
								                    				qrData: Ext.encode(qrDataModel.qrData),
								                    				path:form.responseText,
								                    				qrDisplayData: qrDisplayData,
								                    				qrCode: qrCodeText,
								                    				itemId: 'attendanceViewFacultyQRWin',
								                    				title: getCommonTranslation('VIEW_QR'),
								                    				listeners:{
								                    					afterrender: function(win){
								                    						var me = $this;
								                    						var qrData = win.qrData;
								                    						var qrDisplayData = win.qrDisplayData;
								                    						var path=win.path;
								                    						var qrDataJson = Ext.decode(qrData);

								                    						$('#qrcode').html('<img src="'+path+'"/>');

								                    						var test= path.src;
								                    						var acedemyLocationName = me.getAcademyLocationDisplayName(me.getCurrentAcademyLocation());

								                    						var printBtmVals = Object.values(qrDataJson);

								                    						win.down('#qrALLabelCls').setText(acedemyLocationName);
								                    						win.down('#qrOtherTxtLabelCls').setText(qrDisplayData);

								                    						if(Ext.query('#'+win.id+' #qrcodetext').length){
								                    							Ext.query('#'+win.id+' #qrcodetext')[0].innerText = win.qrCode;
								                            				}


								                    					}
								                    				}
								                    			})
								                    			formWindow =  $this.getQrcodewindow();
								                    		}
								                    		formWindow.show();
								                    	}
								     				
								                    }
								                });
					                    	
					                    	}
					     				
					                    }
					                });
								
								//--
								
							}
						}
						else if(attendanceSlot == 'AD_HOC_SLOTS'){
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CANNOT_SHOW_QR_FOR_SELECTED_CONFIGURATIONS'));
							//--CANNOT VIEW
							return false;
						}
						else  {
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CANNOT_SHOW_QR_FOR_SELECTED_CONFIGURATIONS'));
							//--CANNOT VIEW
							return false;
						}
						
					}
				},
				
				genrateQrCodeForFacultyPortal:function(){
					
					var $this=this;
					var grid = $this.getCaptureattendancegrid();
					var form = $this.getDownloadstudentattendanceform();
					var structure = $this.getStudentcaptureattendancestructure();
					var attendanceType = structure.down('#newAttendanceTypeRadio').getValue().newAttendanceTypeWise;
					var facultyAttendanceProgramId=structure.down('#facultyAttendanceProgramId').rawValue;
					var completeDayDate_Id=structure.down('#completeDayDate_Id').rawValue;


					var session_programBatch_programId=structure.down('#session_programBatch_programId').rawValue;
					var newSessionItemId=structure.down('#newSessionItemId').rawValue;
					var session_dateOfAttendance_Id=structure.down('#session_dateOfAttendance_Id').rawValue;

					var academicTerm=structure.down('#academicTerm').rawValue;
					var courseVariantIds=structure.down('#courseVariantId').rawValue;
					var timetableSlotListId=structure.down('#timetableSlotListId').rawValue;
					var topicId=structure.down('#topicId').rawValue;

					var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
					var data = attendanceTypess.data.COURSE_LEVEL;
					var attendanceSlot=data.attendanceSlot;

					var adhocRequired = false;
					if(attendanceTypess.data.COURSE_LEVEL.whetherAdhocRequired){
						var adhocRequired = attendanceTypess.data.COURSE_LEVEL.whetherAdhocRequired;
					}
				
						 
					var store = '', qrCodeExpiryTime;   
					
					Ext.Ajax.request({
						type: 'rest',
						url: SERVERURL.QR_CODE_EXP_BY_AL_AND_ATTENDANCE_TYPE,										 
						method: 'GET',
						async: true,
						headers: {
							'Content-Type': 'application/json'
						},
						params: {
							attendanceType: attendanceType
						},
						success: function(form, action) {
							qrCodeExpiryTime = Ext.JSON.decode(form.responseText).qrCodeExpiryTime
						}
					});
					 
					if(attendanceType == 'PROGRAM_WISE' || attendanceType == 'COMPLETE_DAY'){
						var formvval = $this.getProgramwisecaptureattendancesearch();
						var sectionId = formvval.down('#facultyAttendanceProgramId').getValue();
						var attendanceDate = formvval.down('#completeDayDate_Id').getValue();

						store = grid.down('grid').getStore()
						store.getProxy().api.read=SERVERURL.GET_STUDENT_LIST_BY_SECTION_ID;
						store.getProxy().extraParams = {
							sectionId: sectionId,
							date:attendanceDate,
							attendanceType:attendanceType,
							portalId:'2'
						};
					} else if(attendanceType == 'COURSE_WISE' || attendanceType == 'COURSE_LEVEL') {
						var form = $this.getCoursewisecaptureattendancesearch();
						var courseVariantId = form.down('#courseVariantId').getValue();
						var courseVariantStore = form.down('#courseVariantId').getStore();
						var fromTime=Ext.Date.format(form.down("#fromTime").getValue(),CONSTANTS.SUBMIT_DATE_FORMAT);
						var toTime=Ext.Date.format(form.down("#toTime").getValue(),CONSTANTS.SUBMIT_DATE_FORMAT);
						var attendanceDate=Ext.Date.format(form.down("#dateOfAttendance_Id").getValue(),CONSTANTS.SUBMIT_DATE_FORMAT);
						var selectedData  = courseVariantStore.findRecord('id', courseVariantId).data;
						var courseId = selectedData.courseId;
						var courseComponentId = selectedData.courseComponentId;
						if(!isNullOrEmpty(selectedData.parentCourseId)) {
							courseId = selectedData.parentCourseId;
						} 

						store = grid.down('grid').getStore();
						var dateTimeList = [];
						store.getProxy().api.read=SERVERURL.GET_STUDENT_ENROLLED_IN_VARIANT;
						store.getProxy().extraParams = {
							courseVariantId: courseVariantId,
							componentId: courseComponentId,
							courseId : courseId,
							attendanceDate:attendanceDate,
							fromTime:fromTime,
							toTime:toTime,
							attendanceType:attendanceType,
							timeList:dateTimeList.join(),
							portalId:'2'
						}
					} else {
						var formvval = $this.getMultiplesessionwisecaptureattendancesearch();
						var sectionId = formvval.down('#session_programBatch_programId').getValue();
						var attendanceDate = formvval.down('#session_dateOfAttendance_Id').getValue();
						var sessionNo = formvval.down('#newSessionItemId').getValue();

						store = grid.down('grid').getStore();
						store.getProxy().api.read=SERVERURL.GET_STUDENT_LIST_BY_SECTION_ID;
						store.getProxy().extraParams = {
							sectionId: sectionId,
							date:attendanceDate,
							attendanceType:attendanceType,
							sessionNo:sessionNo,
							portalId:'2'

						};						
					}
					
					store.load({
						callback: function(records, operation, success) {
							if (success) {
								if(records.length > 0){
									if(attendanceType == 'PROGRAM_WISE' || attendanceType == 'COMPLETE_DAY'){
										var formWindow =  $this.getGenrateqrcodefacultyportal();
										if (!formWindow) {
											Ext.widget('genrateqrcodefacultyportal');
											formWindow =  $this.getGenrateqrcodefacultyportal();
											formWindow.down("#facultyAttendanceProgramId").setVisible(true);
											formWindow.down("#completeDayDate_Id").setVisible(true);

											formWindow.down("#facultyAttendanceProgramId").setValue(facultyAttendanceProgramId);
											formWindow.down("#completeDayDate_Id").setValue(completeDayDate_Id);
											formWindow.down("#expirytime").setValue(qrCodeExpiryTime);
											//formWindow.down('#toTime').setValue("12:00 AM"); //using this for expiry of QR code
										}
										formWindow.show();
									}  else if (attendanceType == 'COURSE_WISE' || attendanceType == 'COURSE_LEVEL') {
										var isAdHoc = adhocRequired;
										 if(attendanceSlot == 'TIME_TABLE_SLOTS' && !isAdHoc) {
											var formWindow =  $this.getGenrateqrcodefacultyportal();
											if (!formWindow) {
												Ext.widget('genrateqrcodefacultyportal');
												formWindow =  $this.getGenrateqrcodefacultyportal();
												formWindow.down("#academicTerm").setVisible(true);
												formWindow.down("#courseVariantId").setVisible(true);
												formWindow.down("#timetableSlotListId").setVisible(true);
												formWindow.down("#topicId").setVisible(true); 
												formWindow.down("#expirytime").setValue(qrCodeExpiryTime);
												//formWindow.down('#toTime').setValue("12:00 AM");
												formWindow.down("#academicTerm").setValue(academicTerm);
												formWindow.down("#courseVariantId").setValue(courseVariantIds);
												formWindow.down("#timetableSlotListId").setValue(timetableSlotListId);
												formWindow.down("#topicId").setValue(topicId);  
											}
											formWindow.show();
										}  else if(attendanceSlot == 'TIME_TABLE_SLOTS' && isAdHoc){
											if(!isNullOrEmpty(timetableSlotListId) && timetableSlotListId.length){
												var formWindow =  $this.getGenrateqrcodefacultyportal();
												if (!formWindow) {
													Ext.widget('genrateqrcodefacultyportal',{
														isAdHoc: true
													});
													formWindow =  $this.getGenrateqrcodefacultyportal();
													formWindow.down("#academicTerm").setVisible(true);
													formWindow.down("#courseVariantId").setVisible(true);
													formWindow.down("#timetableSlotListId").setVisible(true);
													formWindow.down("#topicId").setVisible(true); 
													formWindow.down("#expirytime").setValue(qrCodeExpiryTime);
													//formWindow.down('#toTime').setValue("12:00 AM");
													formWindow.down("#academicTerm").setValue(academicTerm);
													formWindow.down("#courseVariantId").setValue(courseVariantIds);
													formWindow.down("#timetableSlotListId").setValue(timetableSlotListId);
													formWindow.down("#topicId").setValue(topicId);  
												}
											} else {
												var formValues = form.getValues();
												var fromTimeSelected = formValues.fromTime;
												var toTimeSelected = formValues.toTime;
												
												var fromTimeArray = [];
												var toTimeArray = [];
												if(Ext.isArray(form.getValues().fromTime)){
													fromTimeArray = form.getValues().fromTime;
												}
												else{
													fromTimeArray.push(form.getValues().fromTime)
												}

												if(Ext.isArray(form.getValues().toTime)){
													toTimeArray = form.getValues().toTime;
												}
												else{
													toTimeArray.push(form.getValues().toTime)
												}

												if(fromTimeArray.length > 1 || toTimeArray.length > 1){
													showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('QR_CANNOT_BE_GENERATED_FOR_MULTIPLE_TIME_SLOTS'));	
													return false;
												}

												var formWindow =  $this.getGenrateqrcodefacultyportal();
												if (!formWindow) {
													Ext.widget('genrateqrcodefacultyportal',{
														isAdHoc: true
													});
													formWindow =  $this.getGenrateqrcodefacultyportal();
													formWindow.down("#academicTerm").setVisible(true);
													formWindow.down("#courseVariantId").setVisible(true);
													formWindow.down("#timetableSlotListId").setVisible(false);
													formWindow.down("#topicId").setVisible(true); 
													formWindow.down("#fromTime").setVisible(true); 
													formWindow.down("#toTime1").setVisible(true); 

													//formWindow.down('#toTime').setValue("12:00 AM");
													formWindow.down("#expirytime").setValue(qrCodeExpiryTime);
													formWindow.down("#academicTerm").setValue(academicTerm);
													formWindow.down("#courseVariantId").setValue(courseVariantIds);
													//formWindow.down("#timetableSlotListId").setValue(timetableSlotListId);
													formWindow.down("#topicId").setValue(topicId);  
													formWindow.down("#fromTime").setValue(fromTimeSelected);
													formWindow.down("#toTime1").setValue(toTimeSelected);

													formWindow.down("#fromTime").setReadOnly(true);
													formWindow.down("#toTime1").setReadOnly(true);
												}
											}
											formWindow.show();
										}
										else if(attendanceSlot == 'AD_HOC_SLOTS'){


											var formValues = form.getValues();
											var fromTimeSelected = formValues.fromTime;
											var toTimeSelected = formValues.toTime;
											
											var fromTimeArray = [];
											var toTimeArray = [];
											if(Ext.isArray(form.getValues().fromTime)){
												fromTimeArray = form.getValues().fromTime;
											}
											else{
												fromTimeArray.push(form.getValues().fromTime)
											}

											if(Ext.isArray(form.getValues().toTime)){
												toTimeArray = form.getValues().toTime;
											}
											else{
												toTimeArray.push(form.getValues().toTime)
											}

											if(fromTimeArray.length > 1 || toTimeArray.length > 1){
												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('QR_CANNOT_BE_GENERATED_FOR_MULTIPLE_TIME_SLOTS'));	
												return false;
											}
											
											var formWindow =  $this.getGenrateqrcodefacultyportal();
											if (!formWindow) {
												Ext.widget('genrateqrcodefacultyportal',{
													isAdHoc: true
												});
												formWindow =  $this.getGenrateqrcodefacultyportal();
												formWindow.down("#academicTerm").setVisible(true);
												formWindow.down("#courseVariantId").setVisible(true);
												formWindow.down("#timetableSlotListId").setVisible(false);
												formWindow.down("#topicId").setVisible(true); 
												formWindow.down("#fromTime").setVisible(true); 
												formWindow.down("#toTime1").setVisible(true); 

												//formWindow.down('#toTime').setValue("12:00 AM");
												formWindow.down("#expirytime").setValue(qrCodeExpiryTime);
												formWindow.down("#academicTerm").setValue(academicTerm);
												formWindow.down("#courseVariantId").setValue(courseVariantIds);
												//formWindow.down("#timetableSlotListId").setValue(timetableSlotListId);
												formWindow.down("#topicId").setValue(topicId);  
												formWindow.down("#fromTime").setValue(fromTimeSelected);
												formWindow.down("#toTime1").setValue(toTimeSelected);

												formWindow.down("#fromTime").setReadOnly(true);
												formWindow.down("#toTime1").setReadOnly(true);
											}
											formWindow.show();
										}
										else  {
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('QR_Code_is_generated_only_for_Timetable_wise_configuration!'));	
										}
									}
									else
									{
										var formWindow =  $this.getGenrateqrcodefacultyportal();
										if (!formWindow) {
											Ext.widget('genrateqrcodefacultyportal');
											formWindow = $this.getGenrateqrcodefacultyportal();
											formWindow.down("#newSessionItemId").setVisible(true);
											formWindow.down("#session_programBatch_programId").setVisible(true);
											formWindow.down("#session_dateOfAttendance_Id").setVisible(true);

											formWindow.down("#session_programBatch_programId").setValue(session_programBatch_programId);
											formWindow.down("#session_dateOfAttendance_Id").setValue(session_dateOfAttendance_Id);
											formWindow.down("#newSessionItemId").setValue(newSessionItemId);
											//formWindow.down("#expirytime").setValue("01:00");
											//formWindow.down('#toTime').setValue("12:00 AM");
											formWindow.down("#expirytime").setValue(qrCodeExpiryTime);

										}  
										formWindow.show();

									}
								}
								else
								{  
									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NO_STUDENTS_ARE_SCHEDULED_TO_TAKE_THIS_CLASS'));	

								}
							}
						}});
                     },

				academicTermSelection : function(form, academicTermId) {
					var $this = this;
					var facultyId = this.getCurrentlyLoggedInUser().id;
					var academyLocationId = this.getCurrentAcademyLocation();
					this.getCaptureattendancegrid().down('grid').getStore().removeAll();
					this.getCaptureattendancecountgrid().getStore().removeAll();
					this.getStudentcaptureattendancestructure().down('#submitBtn').setDisabled(true);
					var courseVariantField = form.down('#courseVariantId');
					courseVariantField.clearValue();
        			var courseVariantFieldStore = courseVariantField.getStore();
					if(!courseVariantFieldStore.isLoading()){
            			courseVariantFieldStore.getProxy().extraParams = {
    						academyLocationIds:academyLocationId,
    						facultyId:facultyId,
    						isCurrentPeriod:true,
    						academicTermId:academicTermId
    					};
            			courseVariantFieldStore.load();
            			var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
            			if(attendanceTypess.data.COURSE_LEVEL.attendanceSlot=="CALENDAR_SLOTS"){
            				var calendarTimeSlot = form.down('#calendarSlotListId');
            				calendarTimeSlot.clearValue();
            				calendarTimeSlot.setDisabled(true);
            			}else if(attendanceTypess.data.COURSE_LEVEL.attendanceSlot=="TIME_TABLE_SLOTS"){
            				var timeTableSlot = form.down('#timetableSlotListId');
            				timeTableSlot.clearValue();
            				timeTableSlot.setDisabled(true);
            			}
        			}

				},
				courseVariantSelection : function(form, courseVariantId, calendarId) {
					var $this = this;
					var courseValues = form.down('#courseVariantId').getStore().findRecord('id',courseVariantId).data;
					var courseId = courseValues.courseId;
					var componentId = "";
					if(courseValues.courseComponentId > 0) {
						courseId = courseValues.parentCourseId;
						componentId = courseValues.courseComponentId;
					}
					$this.loadTopics(form, courseId, componentId);
					var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
					this.getCaptureattendancegrid().down('grid').getStore().removeAll();
					this.getCaptureattendancecountgrid().getStore().removeAll();
					this.getStudentcaptureattendancestructure().down('#submitBtn').setDisabled(true);
					var timeSlotPanel = form.down('#panelId');
		            if (timeSlotPanel != null && !timeSlotPanel.items.items[0].isHidden()) {
		            	for(var i=timeSlotPanel.items.length;i>=0;i--){
		            		if(i==0){
		            			timeSlotPanel.items.items[i].setVisible(true);
		            		}else{
		            			timeSlotPanel.remove(timeSlotPanel.items.items[i]);
		            		}
		                    this.hideShowTimeSlotElement(timeSlotPanel);
		            	}
		            }
					
					form.down('#fromTime').reset();
					form.down('#toTime').reset();
					if(attendanceTypess.data.COURSE_LEVEL.whetherAdhocRequired){
						form.down('#fromTime').allowBlank=false;
						form.down('#toTime').allowBlank=false;
						form.down('#fromTime').setDisabled(false);
						form.down('#toTime').setDisabled(false);
						form.down('#dateOfAttendance_Id').setDisabled(false);
						form.down('#dateOfAttendance_Id').allowBlank=false;
					}
					form.down('#fromTime').setMaxValue(null);
					form.down('#toTime').setMinValue(null);
					if(attendanceTypess.data.COURSE_LEVEL.attendanceSlot=="TIME_TABLE_SLOTS"){
						
						var dateVal = form.down('#dateOfAttendance_Id').getValue();
						var newDate = null;
						Ext.Ajax.request({
							type : 'rest',
							url :SERVERURL.PATH_FIND_SERVER_DATE_TIME,
							method : 'GET',
							async: false,
							success : function(form1, action) {
								data = Ext.JSON.decode(form1.responseText);
								newDate=data.serverDateTimeYYYYMMDDTweentyFourHour;
								newDate = new Date(newDate)
								var fromTime = form.down('#fromTime');
								if(dateVal.getDate() == newDate.getDate()){
									var time = moment(newDate).format("HH:mm"); 
									fromTime.setMaxValue(time);
								}else{
									fromTime.setMaxValue(false);
								}
							}});
						var backDaysAllowed = attendanceTypess.data.COURSE_LEVEL.backDateAllowedForFaculty;
						var facultyId = this.getCurrentlyLoggedInUser().id;
						var academyLocationId = this.getCurrentAcademyLocation();
						var timetableSlotField = form.down('#timetableSlotListId');
						timetableSlotField.setDisabled(false);
						timetableSlotField.clearValue();
						timetableSlotField.allowBlank=false;
	        			var timetableSlotFieldStore = timetableSlotField.getStore();
	        			timetableSlotFieldStore.getProxy().extraParams = {
	        				courseVariantId:courseVariantId,
							facultyId:facultyId,
							backDaysAllowed:backDaysAllowed
						};
	        			timetableSlotFieldStore.load();
	        			
					} else {
						var calendarTimeSlot = form.down('#calendarSlotListId');
						var attendanceDate = form.down('#dateOfAttendance_Id').getValue();
						calendarTimeSlot.clearValue();
						calendarTimeSlot.setDisabled(true);
						calendarTimeSlot.allowBlank=false;
						var validDate = Date.parse(attendanceDate);
						if(!isNaN(validDate)) {
							calendarTimeSlot.setDisabled(false);
							var calendarTimeSlotStore = calendarTimeSlot.getStore();
		        			calendarTimeSlotStore.getProxy().extraParams = {
		        				calendarId : calendarId,
		        				attendanceDate : attendanceDate
							};
		        			calendarTimeSlotStore.load();
						}
					}
				},
				/**
				 * adhocTimeSlotFieldsAdd function are use for add dynamic time fields
				 */
				adhocTimeSlotFieldsAdd:function(){
					var $this = this;
					var form = this.getCoursewisecaptureattendancesearch();
					var timeContiner = this.getCoursewisecaptureattendancesearch().down('#panelId');
					var date = this.getCoursewisecaptureattendancesearch().down('#dateOfAttendance_Id');
					var timeFieldsCount = timeContiner.items.length;
					var panelItem = new Array();
					if(timeFieldsCount < 5) {
						panelItem.push({
							xtype:'fieldcontainer',
							width: 'auto',
							layout : 'hbox',
							defaults : {
								labelAlign : 'top'
							},
							items : [{
								xtype : 'timefield',
								name : 'fromTime',		
								itemId : 'fromTime'+timeFieldsCount,			
								format:'g:i A',
								vtype: 'timerange',
								increment: 1,
								allowBlank:false,
								width:100,
								listeners:{
									change:function(obj,val){
										if (!isNullOrEmpty(val)) {
											var sDate = Ext.Date.add(val, Ext.Date.MINUTE, 1);
											obj.nextSibling().setMinValue(sDate);	
										}
									}
								}

							},{
								xtype : 'timefield',
								name : 'toTime',		
								itemId : 'toTime'+timeFieldsCount,			
								format:'g:i A',
								vtype: 'timerange',
								increment: 1,
								allowBlank:false,
								width:100,
								listeners:{
									change:function(obj,val){
										if (!isNullOrEmpty(val)) {
											var eDate = Ext.Date.add(val, Ext.Date.MINUTE, -1);
											obj.previousSibling().setMaxValue(eDate);
											var dateVal = date.getValue();
											var newDate = null;
											Ext.Ajax.request({
												type : 'rest',
												url :SERVERURL.PATH_FIND_SERVER_DATE_TIME,
												method : 'GET',
												async: false,
												success : function(form1, action) {
													data = Ext.JSON.decode(form1.responseText);
													newDate=data.serverDateTimeYYYYMMDDTweentyFourHour;
													var fromTime = form.down('#fromTime');
													newDate = new Date(newDate)
													if(dateVal.getDate() == newDate.getDate()){
														var time = moment(newDate).format("HH:mm"); 
														obj.previousSibling().setMaxValue(time);
													}
												}});
										}
									}
								}
							},{
								xtype : 'button',
								itemId: 'timeBtnDelete1',
								glyph: ICONGLYPH.DELETEGLYPH,
								cls: 'CustomBodyBtnReject',
								tooltip: getCommonTranslation('DELETETOOLTIP'),
								listeners:{
									click:function(obj){
										var container = obj.up('fieldcontainer');
										var form = $this.getCoursewisecaptureattendancesearch();
									}

								},

							}, {
								xtype : 'button',
								itemId: 'timeBtnAdd1',
								cls: 'CustomBodyBtnSettings',
								text: getCommonTranslation('ADDBUTTONTEXT'),
								tooltip: getCommonTranslation('ADD')

							}]
						});
						timeContiner.add(panelItem);
						var dateVal = date.getValue();
						var newDate = null;
						Ext.Ajax.request({
							type : 'rest',
							url :SERVERURL.PATH_FIND_SERVER_DATE_TIME,
							method : 'GET',
							async: false,
							success : function(form1, action) {
								data = Ext.JSON.decode(form1.responseText);
								newDate=data.serverDateTimeYYYYMMDDTweentyFourHour;
								var fromTime = form.down('#fromTime');
								newDate = new Date(newDate)
								var fromTime = timeContiner.down('#fromTime'+timeFieldsCount);
								if(dateVal.getDate() == newDate.getDate()){
									var time = moment(newDate).format("HH:mm"); 
									fromTime.setMaxValue(time);
								}
							}});
						
						this.hideShowTimeSlotElement(timeContiner);
						timeContiner.doLayout();
					} else {
						this.hideShowTimeSlotElement(timeContiner);
					}
				},
				
				adhocTimeSlotFieldsAddService:function(){
					var $this = this;
					var form = this.getServicewisecaptureattendancesearch();
					var timeContiner = this.getServicewisecaptureattendancesearch().down('#panelId');
					var date = this.getServicewisecaptureattendancesearch().down('#dateOfAttendance_Id');
					var timeFieldsCount = timeContiner.items.length;
					var panelItem = new Array();
					if(timeFieldsCount < 5) {
						panelItem.push({
							xtype:'fieldcontainer',
							width: 'auto',
							layout : 'hbox',
							defaults : {
								labelAlign : 'top'
							},
							items : [{
								xtype : 'timefield',
								name : 'fromTime',		
								itemId : 'fromTime'+timeFieldsCount,			
								format:'g:i A',
								vtype: 'timerange',
								increment: 1,
								allowBlank:false,
								width:100,
								listeners:{
									change:function(obj,val){
										if (!isNullOrEmpty(val)) {
											var sDate = Ext.Date.add(val, Ext.Date.MINUTE, 1);
											obj.nextSibling().setMinValue(sDate);	
										}
									}
								}

							},{
								xtype : 'timefield',
								name : 'toTime',		
								itemId : 'toTime'+timeFieldsCount,			
								format:'g:i A',
								vtype: 'timerange',
								increment: 1,
								allowBlank:false,
								width:100,
								listeners:{
									change:function(obj,val){
										if (!isNullOrEmpty(val)) {
											var eDate = Ext.Date.add(val, Ext.Date.MINUTE, -1);
											obj.previousSibling().setMaxValue(eDate);
											var dateVal = date.getValue();
											var newDate = null;
											Ext.Ajax.request({
												type : 'rest',
												url :SERVERURL.PATH_FIND_SERVER_DATE_TIME,
												method : 'GET',
												async: false,
												success : function(form1, action) {
													data = Ext.JSON.decode(form1.responseText);
													newDate=data.serverDateTimeYYYYMMDDTweentyFourHour;
													var fromTime = form.down('#fromTime');
													newDate = new Date(newDate)
													if(dateVal.getDate() == newDate.getDate()){
														var time = moment(newDate).format("HH:mm"); 
														obj.previousSibling().setMaxValue(time);
													}
												}});
										}
									}
								}
							},{
								xtype : 'button',
								itemId: 'timeBtnDelete1',
								glyph: ICONGLYPH.DELETEGLYPH,
								cls: 'CustomBodyBtnReject',
								tooltip: getCommonTranslation('DELETETOOLTIP'),
								listeners:{
									click:function(obj){
										var container = obj.up('fieldcontainer');
										var form = $this.getServicewisecaptureattendancesearch();
									}

								},

							}, {
								xtype : 'button',
								itemId: 'timeBtnAdd1',
								cls: 'CustomBodyBtnSettings',
								text: getCommonTranslation('ADDBUTTONTEXT'),
								tooltip: getCommonTranslation('ADD')

							}]
						});
						timeContiner.add(panelItem);
						var dateVal = date.getValue();
						var newDate = null;
						Ext.Ajax.request({
							type : 'rest',
							url :SERVERURL.PATH_FIND_SERVER_DATE_TIME,
							method : 'GET',
							async: false,
							success : function(form1, action) {
								data = Ext.JSON.decode(form1.responseText);
								newDate=data.serverDateTimeYYYYMMDDTweentyFourHour;
								var fromTime = form.down('#fromTime');
								newDate = new Date(newDate)
								var fromTime = timeContiner.down('#fromTime'+timeFieldsCount);
								if(dateVal.getDate() == newDate.getDate()){
									var time = moment(newDate).format("HH:mm"); 
									fromTime.setMaxValue(time);
								}
							}});
						
						this.hideShowTimeSlotElement(timeContiner);
						timeContiner.doLayout();
					} else {
						this.hideShowTimeSlotElement(timeContiner);
					}
				},
				deleteAdhocTimeSlotContainer: function(deleteButton) {
					var this$ = this;
					var form = this$.getCoursewisecaptureattendancesearch();
					var timeSlotPanel = form.down('#panelId');
					var container = deleteButton.up('fieldcontainer');

					if (container != null && timeSlotPanel != null) {
						if (timeSlotPanel.items.length > 1) {
							timeSlotPanel.remove(container);
							this$.hideShowTimeSlotElement(timeSlotPanel);
							form.isValid();
						}
					}
				},
				deleteAdhocTimeSlotContainerService: function(deleteButton) {
					var this$ = this;
					var form = this$.getServicewisecaptureattendancesearch();
					var timeSlotPanel = form.down('#panelId');
					var container = deleteButton.up('fieldcontainer');

					if (container != null && timeSlotPanel != null) {
						if (timeSlotPanel.items.length > 1) {
							timeSlotPanel.remove(container);
							this$.hideShowTimeSlotElement(timeSlotPanel);
							form.isValid();
						}
					}
				},
				hideShowTimeSlotElement: function(timeSlotPanel) {
					var this$ = this;
					var form = this$.getCoursewisecaptureattendancesearch();
					timeSlotPanel.items.each(function(item, index, items) {
						var addButton = item.getComponent(item.items.length - 1);
						if (index == (items - 1) && items<5) {
							if (addButton != null) {
								addButton.show();
							}
						} else {
							if (addButton != null) {
								addButton.hide();
							}
						}
					});
				},

				getIdValueJson: function(id, value,code) {
					if (id) return {
						id: id,
						value: value,
						code: code
					};
				},
				changeMarkingTypeOnLoad:function(attendanceStatus){
					var grid = this.getCaptureattendancegrid();
					var store = grid.down('grid').getStore();

					var present=false,absent=false,attStatus=null;
					var prePercent='0%', absPercent='0%';
					var abs=0,pre=0,oth=0;
					if (attendanceStatus == 'PRESENT' || attendanceStatus == 'Present') {
						present = true;
						absent = false;
						attStatus = null;
					} else if (attendanceStatus == 'ABSENT' || attendanceStatus == 'Absent') {
						attStatus = null;
						present = false;
						absent = true;
					} else if (attendanceStatus == 'LEAVE' || attendanceStatus == 'Leave') {
						attStatus = "Leave";
						present = false;
						absent = false;
					} else if (attendanceStatus == 'SICK_LEAVE' || attendanceStatus == 'Leave') {
						attStatus = "Leave";
						present = false;
						absent = false;
					}

					var attendanceMarkingType = this.getIdValueJson(3);
					store.suspendEvents();   
					store.each(function(rec) {
						 if(isNullOrEmpty(rec.data.attendanceStatus)){
						if(!isNullOrEmpty(rec.data.leaveStatus) && rec.data.leaveStatus == 'Absent'){
	  	        			 rec.set('present', false);
		  	        		 rec.set('absent', true);
		  	        		 rec.set('attendanceStatus', null);
		  	        		 abs++;
	  	        			 
	  	        		 } else if(!isNullOrEmpty(rec.data.leaveStatus) && rec.data.leaveStatus == 'Leave'){
	  	        			 rec.set('present', false);
		  	        		 rec.set('absent', false);
		  	        		 rec.set('attendanceStatus', "Leave");
		  	        		 rec.set('attendanceMarkStatus', "ABSENT");
		  	        		 rec.set('attendanceMarkingType', attendanceMarkingType.id);
		  	        		 oth++;
	  	        			 
	  	        		 } else{
	  	        			rec.set('present', present);
		  	        		rec.set('absent', absent);
		  	        		rec.set('attendanceStatus', attStatus);
		  	        		if(present){
		  	        			pre++;
		  	        		} else if(absent){
		  	        			abs++;
		  	        		} else {
		  	        			oth++;
		  	        		}
		  	        		
	  	        		 }}
	  	        		   else{
	  	        			   if(rec.data.markingType == "PRESENT"){
	  	        					pre++;
	  	        					rec.set('present', true);
				  	        		rec.set('absent', false);
	  	        			   }
	  	        			   else if(rec.data.markingType == "ABSENT"){
	  	        				   abs++;
	  	        				   rec.set('present', false);
	  	        				   rec.set('absent', true);
	  	        			   }
	  	        			   else{
		  	        			   oth++;
		  	        			   rec.set('present', false);
	  	        				   rec.set('absent', false);
	  	        				   rec.set('attendanceMarkingType', attendanceMarkingType.id);
	  	        			   }
	  	        		   }
					});
					store.resumeEvents();
					grid.down('grid').getView().refresh();

					var gridCount = this.getCaptureattendancecountgrid();
					var data = {
							totalStudent:store.data.length,
							totalPresent:pre,
							totalAbsent:abs,
							otherCount:oth,
							presentPercent:parseFloat((pre/store.data.length)*100).toFixed(2)+"%",
	            			absentPercent:parseFloat((abs/store.data.length)*100).toFixed(2)+"%",
					};
					var gridStore =  gridCount.getStore();
					if(store.data.length!=0){
						gridStore.removeAll();
						gridStore.loadRawData(data, true);
					}
				},
				selectOtherStatus:function(obj,record){
					var attStatus = obj.getValue();
					var grid = this.getCaptureattendancegrid();
					var store = grid.down('grid').getStore();

					var prePercent='0%', absPercent='0%';
					var abs=0,pre=0,oth=0;
					if(record[0].data.code == 'PRESENT' || record[0].data.code == 'Present') {
						prePercent = '100%'
					} else if(record[0].data.code == 'ABSENT' || record[0].data.code == 'Absent') {
						absPercent = '100%'
					}
					store.suspendEvents();   
					store.each(function(rec) {
						rec.set('present', false);
						rec.set('absent', false);
						rec.set('attendanceStatus', attStatus);
						rec.set('attendanceMarkingType' ,record[0].data.id);
						rec.set('attendanceMarkStatus' ,record[0].data.code);
					});
					store.resumeEvents();
					grid.down('grid').getView().refresh();

					var gridCount = this.getCaptureattendancecountgrid();
					var data = {
							totalStudent:store.data.length,
							totalPresent:0,
							totalAbsent:0,
							otherCount:store.data.length,
							presentPercent:prePercent,
							absentPercent:absPercent,
					};
					var gridStore =  gridCount.getStore();
					if(store.data.length!=0){
						gridStore.removeAll();
						gridStore.loadRawData(data, true);
					}
				},
				loadStudentCaptureAttendanceProgram : function(){
					var $this = this;
					var academyLocationId = this.getCurrentAcademyLocation();
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var facultyId = this.getCurrentlyLoggedInUser().id;
					var wheatherSchool = alinfomodel.get('wheatherSchool');
					var downloadForm = $this.getDownloadstudentattendanceform();
					var programBatchSectionField = downloadForm.down('#facultyStudentAttendanceProgramId');
					this.setAllowBlank(programBatchSectionField, false);
					programBatchSectionField.reset();
					if(wheatherSchool) {
						programBatchSectionField.setFieldLabel(getCourseTxCommonTranslation('ATTENDANCE_PROGRAM_BATCH_SECTION'))
					} else {
						programBatchSectionField.setFieldLabel(getCourseTxCommonTranslation('PROGRAM_BATCH_PERIOD_SECTION'))
					}

					var programStore = programBatchSectionField.getStore();
					programStore.getProxy().extraParams = {
						academyLocationIds:academyLocationId,
						facultyId:facultyId,
						onlyCurrentRecords:true,
						wheatherSchool:wheatherSchool
					};
					programStore.load();

				},
				downloadUploadStudentFormChange : function(cb, nv, ov){
					var $this = this;
					var mainStruct = this.getStudentcaptureattendanceuploaddownloadstructureforfaculty();
					var importGrid = $this.getImportutilityStudentattendancelist();
					var downloadTemplateForm = $this.getDownloadstudentattendanceform();
					var uploadTemplateForm = $this.getUploadstudentattendanceform();

					if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
						var form = $this.getDownloadstudentattendanceform();
						var programField = form.down('#facultyStudentAttendanceProgramId');
						var fromDateFeild = form.down("#dateOfStudentAttendanceId");
						var toDateFeild = form.down("#consolidateStudentEndDateId");
						var academyLocationId = this.getCurrentAcademyLocation();
						var facultyId = this.getCurrentlyLoggedInUser().id;
						var alinfomodel = Academia.model.authentication.ALInfoModel;
						var wheatherSchool = alinfomodel.get('wheatherSchool');

						uploadTemplateForm.hide();
						downloadTemplateForm.show();
						importGrid.setVisible(false);
						programField.reset();

						var programStore = programField.getStore();
						programStore.getProxy().extraParams={
							academyLocationIds:academyLocationId,
							facultyId:facultyId,
							onlyCurrentRecords:true,
							wheatherSchool:wheatherSchool
						};
						programStore.load();

						fromDateFeild.setValue(new Date());
						toDateFeild.setValue(new Date());


					}else{
						var portalId = $this.getCurrentLoggedPortalId();
						if(portalId==2){
							$this.doAccessControlValidationForLoader(uploadTemplateForm,this.getFACULTY_PORTAL_LOADER_PERMISSIONS());
						}
						downloadTemplateForm.hide();
						uploadTemplateForm.show();
						importGrid.setVisible(true);
						uploadTemplateForm.down('#moduleName').getStore().load({
							callback:function(recprds, success){
								for(var i in recprds){
									if(recprds[i].data.value=="Bulk Mark Attendance"){
										uploadTemplateForm.down('#moduleName').setValue(recprds[i].data.id);
										uploadTemplateForm.down('#moduleName').setReadOnly(true);
									}
								}
							}
						});
					}
				},

				resetDownloadStudentAttendanceForm : function(){
					var $this = this;
					var form = this.getDownloadstudentattendanceform();
					var programFeild = form.down("#facultyStudentAttendanceProgramId");
					var fromDateFeild = form.down("#dateOfStudentAttendanceId");
					var toDateFeild = form.down("#consolidateStudentEndDateId");
					var academyLocationId = this.getCurrentAcademyLocation();
					var facultyId = this.getCurrentlyLoggedInUser().id;
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var wheatherSchool = alinfomodel.get('wheatherSchool');

					programFeild.reset();
					fromDateFeild.reset();
					toDateFeild.reset();

					var programStore = programFeild.getStore();
					programStore.getProxy().extraParams={
						academyLocationIds:academyLocationId,
						facultyId:facultyId,
						onlyCurrentRecords:true,
						wheatherSchool:wheatherSchool
					};
					programStore.load();

					fromDateFeild.setValue(new Date());
					toDateFeild.setValue(new Date());
				},
				programBatchStudentAttendanceDownloadTemplete : function(){
					var $this = this;
					var attendanceType= "";
					var form = this.getDownloadstudentattendanceform();;
					var structure = $this.getStudentcaptureattendancestructure();
					var attendanceType = structure.down('#newAttendanceTypeRadio').getValue().newAttendanceTypeWise;
					var programBatchSectionId = form.down("#facultyStudentAttendanceProgramId").getValue();
					var fromDateFeild = form.down("#dateOfStudentAttendanceId").getValue();
					var toDateFeild = form.down("#consolidateStudentEndDateId").getValue();
					var academyLocationId = this.getCurrentAcademyLocation();
					values = form.down('#facultyStudentAttendanceProgramId').getStore().findRecord('sectionId', programBatchSectionId).data;

					sdoa = Ext.Date.format(fromDateFeild,'Y-m-d');
					edoa = Ext.Date.format(toDateFeild,'Y-m-d');
					if(attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY'){
					var csvForm = Ext.create('Ext.form.Panel'); 
					csvForm.getForm().submit({
						target: '_blank',
						method:'POST',
						params :{
							access_token : Ext.Ajax.defaultHeaders.access_token,
							alname:academyLocationId,
							sectionID:programBatchSectionId,
							programId:values.programId,
							batchId:values.batchId,
							AttendanceType:'COMPLETE_DAY',
							sdoa:sdoa,
							edoa:edoa
						},
						headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
						url: SERVERURL.COMPLETE_ATTENDANCE,
						standardSubmit :true
					});

					Ext.defer(function() {
						var $this = this;
						var grid = $this.getImportutilityStudentattendancelist();
						grid.getStore().getProxy().extraParams = {
							moduleName:'IMPORT_MODULE_ATTENDANCE'
						};
						grid.getStore().load();
					}, 2000, this);
				}
					if(attendanceType == 'Multiple Session' || attendanceType == 'MULTIPLE_SESSION'){
						
						var csvForm = Ext.create('Ext.form.Panel'); 
						csvForm.getForm().submit({
							target: '_blank',
							method:'POST',
							params :{
								access_token : Ext.Ajax.defaultHeaders.access_token,
								alname:academyLocationId,
								sectionID:programBatchSectionId,
								programId:values.programId,
								batchId:values.batchId,
								AttendanceType:attendanceType,
								sdoa:fromDateFeild,
								edoa:toDateFeild,
								sessionNumber:sessionNumber
							},
							headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
							url: SERVERURL.MULTIPLE_SESSION_ATTENDANCE,
							standardSubmit :true
						});
						

						Ext.defer(function() {
							var $this = this;
							var grid = $this.getImportutilityStudentattendancelist();
							grid.getStore().getProxy().extraParams = {
								moduleName:'IMPORT_MODULE_ATTENDANCE'
							};
							grid.getStore().load();
						}, 2000, this);
					}
				},
				uploadCompleteDayAttendance : function(){
					var $this=this;
					var importWin=$this.getUploadstudentattendanceform();
					var grdStore;
					var form=$this.getUploadstudentattendanceform();
					submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
			     	
    	        	$this.getHashOfFile(form);
		        	setTimeout(function() {
						form.getForm().submit({
							method : 'POST',
							url : submitUrl,
							success : function(form, action){
								
									showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
									var grid = $this.getImportutilityStudentattendancelist();
									$this.onChangeUploadOptionRadioGroup(false,grid, 'IMPORT_MODULE_ATTENDANCE');
									},
							failure: function(form, action) {
								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'))							
							}
						});
		        	},1000);
		        	Ext.defer(function() {
        				var grid = $this.getImportuserupdategrid();
        				var form = $this.getUserupdateuploadoptionradiogroup();
        				var isUploadAll = form.items.items[0].getValue().isUploadAll;
        				$this.onChangeUploadOptionRadioGroup(isUploadAll, grid, 'IMPORT_BULK_USER_UPDATE');
        			}, 2000, this);
				},
				forceRunUploadedFile : function(){
					var grid = this.getImportutilityStudentattendancelist();
					if (grid.getSelectionModel().getCount() > 0) {
						if(grid.getSelectionModel().getCount() > 1){
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
						}else{
							var id = grid.getSelectionModel().selectionStart.data.id;
							var urlAppend="?jobName="+id;
							var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
							Ext.Ajax.request({
								url: submitURL,
								method: 'GET',
								success: function(response) {
									if(response.responseText==="JOB_STATUS_NOT_PENDING"){
										showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
									}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
										showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
									}else if(response.responseText==="SUCCESS"){ 
										showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
									}
								}
							});
						}
					} else {
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}  
				},

				refreshStudentUploadData : function(){
					var $this = this;
					var grid = $this.getImportutilityStudentattendancelist();
					var facultyId = $this.getCurrentlyLoggedInUser().id;
					var gridStore = grid.getStore();
					gridStore.getProxy().extraParams={
						uploadedBy:facultyId,
						moduleName:'IMPORT_MODULE_ATTENDANCE'
					};
					gridStore.load();
				},
				getDownloadFile : function(documentId,fileType){

					if(!isNullOrEmpty(documentId)){
						var csvForm = Ext.create('Ext.form.Panel'); 
						csvForm.getForm().submit({
							target: '_blank',
							method:'POST',
							params :{
								access_token : Ext.Ajax.defaultHeaders.access_token
							},
							headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
							url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
							standardSubmit :true
						});
					}
				},
				resetUploadStudentAttendance : function(){
					var $this = this;
					var form = $this.getUploadstudentattendanceform();
					var uploadField = form.down('#uploadFileField');
					uploadField.reset();
				},
				loadStudentCourseLevelAcademicTerm : function(){
					var $this = this;
					var downloadForm = this.getDownloadstudentcourselevelattendanceform();
					var academicTermField = downloadForm.down('#studentAcademicTermId');
					var courseVariantFeild = downloadForm.down('#studentCourseVariantId');
					academicTermField.reset();
					courseVariantFeild.reset();

					var academicTermStore = academicTermField.getStore();
					academicTermStore.load({
						callback: function(record, operation, success) {
							if (success) {
								if(record.length>0){
									Ext.each(record, function(value) {
										if(value.data.whetherCurrentAcademicTerm){
											academicTermField.setValue(value.data.id);
										}
									});
								}
							}
						}
					});

				},
				courseLevelAcademicTermSelection : function(form,academicTermId){
					var $this = this;
					var facultyId = this.getCurrentlyLoggedInUser().id;
					var academyLocationId = this.getCurrentAcademyLocation();
					var courseVariantField = form.down('#studentCourseVariantId');
					courseVariantField.reset();
					var courseVariantFieldStore = courseVariantField.getStore();
					courseVariantFieldStore.getProxy().extraParams = {
						academyLocationIds:academyLocationId,
						facultyId:facultyId,
						isCurrentPeriod:true,
						academicTermId:academicTermId
					};
					courseVariantFieldStore.load();
				},
				downloadUploadStudentFormCourseLevel : function(cb, nv, ov){
					var $this = this;
					var mainCourseLevelStudentStruct = this.getStudentcourselevelattendanceuploaddownloadstructureforfaculty();
					var importCourseLevelStudentGrid = $this.getImportutilitystudentcourselevelattendancelist();
					var downloadCourseLevelStudentTemplateForm = $this.getDownloadstudentcourselevelattendanceform();
					var uploadCourseLevelStudentTemplateForm = $this.getUploadstudentcourselevelattendanceform();

					if(nv.downloadCourseLevelUploadTemplate == 'forDownloadCourseLevelStudentTemplate'){
						var academicTermFeild = downloadCourseLevelStudentTemplateForm.down('#studentAcademicTermId');
						var courseVariantsFeild = downloadCourseLevelStudentTemplateForm.down("#studentCourseVariantId");
						var facultyId = this.getCurrentlyLoggedInUser().id;

						uploadCourseLevelStudentTemplateForm.hide();
						downloadCourseLevelStudentTemplateForm.show();
						importCourseLevelStudentGrid.setVisible(false);

						academicTermFeild.reset();
						courseVariantsFeild.reset();

						var academicTermStore = academicTermFeild.getStore();
						var currentAcademicTermDefine=false;
						academicTermStore.load({
							callback: function(record, operation, success) {
								if (success) {
									if(record.length>0){
										Ext.each(record, function(value) {
											if(value.data.whetherCurrentAcademicTerm){
												academicTermFeild.setValue(value.data.id);
											}
										});
									}
								}
							}
						});


					}else{
						var portalId = $this.getCurrentLoggedPortalId();
						if(portalId==2){
							$this.doAccessControlValidationForLoader(uploadCourseLevelStudentTemplateForm,this.getFACULTY_PORTAL_LOADER_PERMISSIONS());
						}
						downloadCourseLevelStudentTemplateForm.hide();
						uploadCourseLevelStudentTemplateForm.show();
						importCourseLevelStudentGrid.setVisible(true);
						uploadCourseLevelStudentTemplateForm.down('#moduleName').getStore().load({
							callback:function(recprds, success){
								for(var i in recprds){
									if(recprds[i].data.value=="Bulk Course Level Attendance"){
										uploadCourseLevelStudentTemplateForm.down('#moduleName').setValue(recprds[i].data.id);
										uploadCourseLevelStudentTemplateForm.down('#moduleName').setReadOnly(true);
									}
								}
							}
						});
					}
				},
				resetCourseLevelStudentDownloadAttendance : function(){
					var $this = this;
					var downloadTemplateForm = $this.getDownloadstudentcourselevelattendanceform();
					var academicTermFeild = downloadTemplateForm.down('#studentAcademicTermId');
					var courseVariantsFeild = downloadTemplateForm.down("#studentCourseVariantId");

					academicTermFeild.reset();
					courseVariantsFeild.reset();

					var academicTermStore = academicTermFeild.getStore();
					var currentAcademicTermDefine=false;
					academicTermStore.load({
						callback: function(record, operation, success) {
							if (success) {
								if(record.length>0){
									Ext.each(record, function(value) {
										if(value.data.whetherCurrentAcademicTerm){
											academicTermFeild.setValue(value.data.id);
										}
									});
								}
							}
						}
					});
				},
				courseLevelStudentAttendanceDownloadTemplete : function(){
					var $this = this;
					var downloadTemplateForm = $this.getDownloadstudentcourselevelattendanceform();
					var academicTermFeild = downloadTemplateForm.down('#studentAcademicTermId');
					var courseVariantsFeild = downloadTemplateForm.down("#studentCourseVariantId");
					var formValue = downloadTemplateForm.getValues();
					var academicTermId = formValue.ACADEMIC_TERM;
					var courseVariantId = formValue.studentCourseVariantId;
					var academyLocationId = this.getCurrentAcademyLocation();
					var facultyId = this.getCurrentlyLoggedInUser().id;

					var values = downloadTemplateForm.down('#studentCourseVariantId').getStore().findRecord('id', courseVariantId).data;
					var csvForm = Ext.create('Ext.form.Panel'); 
					csvForm.getForm().submit({
						target: '_blank',
						method:'POST',
						params :{
							access_token : Ext.Ajax.defaultHeaders.access_token,
							academyLocationId : academyLocationId,
							sectionType : values.sectionType,
							courseId : values.courseId,
							componentId : values.componentId,
							variantId : values.id,
							sectionId : values.sectionId,
							facultyId :facultyId
						},
						headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
						url: SERVERURL.DOWNLOAD_TEMPLATE_COURSE_LEVEL_ATTENDANDCE,
						standardSubmit :true
					});;
				},
				uploadCourseLevelStudentAttendance : function(){
					var $this=this;
					var importWin=$this.getUploadstudentcourselevelattendanceform();
					var grdStore;
					var form=$this.getUploadstudentcourselevelattendanceform();
					submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
    	        	$this.getHashOfFile(form);
		        	setTimeout(function() {
						form.getForm().submit({
							method : 'POST',
							url : submitUrl,
							success : function(form, action){
								showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
							},
							failure: function(form, action) {
   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
							}
						});
		        	},1000);

					Ext.defer(function() {
						var grid = $this.getImportutilitystudentcourselevelattendancelist();
						$this.onChangeUploadOptionRadioGroup(false, grid,'IMPORT_BULK_COURSE_LEVEL_ATTENDANCE_UPLOAD');
					}, 2000, this);
				},
				refreshCourseLevelStudentAttendanceGrid : function(){
					var $this = this;
					var grid = $this.getImportutilitystudentcourselevelattendancelist();
					var facultyId = $this.getCurrentlyLoggedInUser().id;
					var gridStore = grid.getStore();
					gridStore.getProxy().extraParams={
						uploadedBy:facultyId,
						moduleName:'IMPORT_BULK_COURSE_LEVEL_ATTENDANCE_UPLOAD'
					};
					gridStore.load();
				},
				forceRunCourseLevelStudentAttendanceUploadedFile : function(){
					var grid = this.getImportutilitystudentcourselevelattendancelist();
					if (grid.getSelectionModel().getCount() > 0) {
						if(grid.getSelectionModel().getCount() > 1){
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
						}else{
							var this$ = this;
							var id = grid.getSelectionModel().selectionStart.data.id;
							console.log(id);
							var urlAppend="?jobName="+id;
							var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
							Ext.Ajax.request({
								url: submitURL,
								method: 'GET',
								success: function(response) {
									if(response.responseText==="JOB_STATUS_NOT_PENDING"){
										showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
									}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
										showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
									}else if(response.responseText==="SUCCESS"){
										showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
										grid.getStore().reload();
									}
								}
							});
						}
					} else {
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}  
				},
				getCourseLevelAtttendenceDownloadFile : function(documentId,fileType){
					if(!isNullOrEmpty(documentId)){
						var csvForm = Ext.create('Ext.form.Panel'); 
						csvForm.getForm().submit({
							target: '_blank',
							method:'POST',
							params :{
								access_token : Ext.Ajax.defaultHeaders.access_token
							},
							headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
							url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
							standardSubmit :true
						});
					}
				},
				resetUploadCourseLevelStudentAttendance : function(){
					var $this = this;
					var form = $this.getUploadstudentcourselevelattendanceform();
					var uploadField = form.down('#uploadFileField');
					uploadField.reset();
				},
				loadTopics:function(form, courseId, componentId) {
		        	var topicField = form.down("#topicId");
		        	topicField.clearValue();
		        	topicField.setDisabled(false);
		        	var sessionId = form.down('#timetableSlotListId').getValue();
		        	var sessionIds = [];
		        	if(sessionId !=undefined && sessionId.length > 0){
                		 for(var i in sessionId){
                			 if(Ext.isObject(sessionId[i])){
                				 sessionIds.push(sessionId[i].get("id"));
                			 }else{
                				 sessionIds.push(sessionId[i]);
                			 }
                		 }
                	 }
		        	var topicStore = topicField.getStore();
		        	topicStore.getProxy().extraParams = {
		        		courseId: courseId,
		        		componentId: componentId,
		        		sessionId:sessionIds.join()
		        	};
		        	topicStore.load({
		        		callback: function(records, operation, success) {
		        			if (success) {
		        				var topicIds = [];
		        				if(records.length > 0 && sessionIds.length > 0 && sessionIds != ""){
		        					for(var i in records) {
		        						topicIds.push(records[i].data.id);
		        					}
		        				}
	        					topicStore.getProxy().extraParams = {
	        		        		courseId: courseId,
	        		        		componentId: componentId
	        		        	};
	        		        	topicStore.load({
	        		        		callback: function(records, operation, success) {
	        		        			if (success) {
	        		        				if(records.length > 0 && sessionIds.length > 0 && sessionIds != ""){
	        		        					topicField.setValue(topicIds);
	        		        				}
	        		        			}
	        		        		}
	        		        	});
		        			}
		        		}
		        	});
		        },
              generateQrCodePermissionProgramWise:function(form,permissionMap){
	                   var associatedAcadLocationIds = new Array();
                        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
                        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
						var generateQRProgramWise = form.down('#GENRATEQR');
                        generateQRProgramWise.setVisible(false);
                         Ext.each(permissionList, function(privilege) {
                            if (privilege == 'GENERATE_QR_PROGRAM_WISE') {
                                if(!isNullOrEmpty(generateQRProgramWise)){
                                    generateQRProgramWise.setVisible(true);
                                }                
                            }
                        });
				},                 
                generateQrCodePermissionCourseWise:function(form,permissionMap){
	                   var associatedAcadLocationIds = new Array();
                        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
                        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
						var generateQRProgramWise = form.down('#GENRATEQR');
                        generateQRProgramWise.setVisible(false);
                         Ext.each(permissionList, function(privilege) {
							 if (privilege == 'GENERATE_QR_COURSE_WISE') {
                                if(!isNullOrEmpty(generateQRProgramWise)){
                                    generateQRProgramWise.setVisible(true);
                                }                
                            }
                        });
					},
                  generateQrCodePermissionSessionWise:function(form,permissionMap){
	                   var associatedAcadLocationIds = new Array();
                        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
                        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
						var generateQRProgramWise = form.down('#GENRATEQR');
                        generateQRProgramWise.setVisible(false);
                         Ext.each(permissionList, function(privilege) {
							if (privilege == 'GENERATE_QR_SESSION_WISE') {
                                if(!isNullOrEmpty(generateQRProgramWise)){
                                    generateQRProgramWise.setVisible(true);
                                }                
                            }
                        });
						},
						searchServiceWiseGridData:function(){
							var $this = this;
							var grid = $this.getCaptureattendancegrid();
							var store = grid.down('grid').getStore()
							var form=$this.getServicewisecaptureattendancesearch().getForm();
							$this.getServicewisecaptureattendancesearch().down('#searchBtn').setDisabled(true);
							store.getProxy().api.read=SERVERURL.PATH_GET_STUDENT_LIST_FOR_SERVICE_ATTENDANCE;
							var serviceId = form.findField('service').getValue();
							var serviceBatchId = form.findField('serviceBatch').getValue();
							var attendanceDate = form.findField('dateOfAttendance').getValue();
							var date = Ext.Date.format(new Date(attendanceDate), 'Y-m-d');
							var attendanceStructure=this.getStudentcaptureattendancestructure();
							var studentsAttendanceType = attendanceStructure.down('#newAttendanceTypeRadio').getValue();
							var attendanceType=studentsAttendanceType.newAttendanceTypeWise;
							if(serviceBatchId && typeof serviceBatchId == "object" && serviceBatchId.length && !isNullOrEmpty(serviceBatchId[0])){
								if(typeof serviceBatchId[0] == "object"){
									var batchIds = Ext.Array.pluck(Ext.Array.pluck(serviceBatchId,'data'),'id').join();
								}
								else{
									var batchIds = serviceBatchId.join();
								}
							}
							else{
								var batchIds = serviceBatchId;
							}

							store.getProxy().extraParams = {
								date:date,
								portalId:'2',
								serviceId:serviceId,
								batchIds:batchIds,
								attendanceType:attendanceType
							};
							store.load({
								callback: function(records, operation, success) {
									if (success) {
										$this.getServicewisecaptureattendancesearch().down('#searchBtn').setDisabled(false);
										if(records.length > 0){
											 $this.getStudentcaptureattendancestructure().down('#submitBtn').setDisabled(false);
											if(records[0].data.attendanceMarkStatus != null) {
												showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'), getProgramandcourseTranslation('DUPLICATE_ATTENDANCE'));
												$this.getStudentcaptureattendancestructure().down('#submitBtn').setDisabled(true);
												store.removeAll();
											} else if(records[0].data.isDateAllow != null){
												showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'), getProgramandcourseTranslation(records[0].data.isDateAllow));
												$this.getStudentcaptureattendancestructure().down('#submitBtn').setDisabled(true);
												$this.loadCaptureAttendanceSummary();
												$this.changeMarkingTypeOnLoad("PRESENT");
											} else if(records[0].data.isWorkingDay != null){
												showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'), getProgramandcourseTranslation(records[0].data.isWorkingDay));
												$this.loadCaptureAttendanceSummary();
												$this.changeMarkingTypeOnLoad("PRESENT");
											} else {
												$this.loadCaptureAttendanceSummary();
												$this.changeMarkingTypeOnLoad("PRESENT");
											}
										}else{
											$this.getStudentcaptureattendancestructure().down('#submitBtn').setDisabled(true);
										}
									}
								}	   
							});
						},resetServiceWiseForm:function(){
							var form = this.getServicewisecaptureattendancesearch().getForm();
			        		  var serviceField=form.findField("service");
			        		  var batchFieldField=form.findField("serviceBatch");
			        		  var dateField=form.findField("dateOfAttendance");
			        		  var timeContainer = form.owner.down('#timeContainer').up().items.items;
			        		   
			        		  if(timeContainer.length > 1){
			        			  var arr = timeContainer.slice(0, 1);
			        			  timeContainer
			        		  }
			        		  dateField.setValue(dateRender(new Date));
			        		  batchFieldField.setDisabled(true);
			        		  serviceField.reset();
			        		  batchFieldField.reset();
			        		  form.findField("fromTime").reset();
			        		  form.findField("toTime").reset();
			        		  form.checkValidity();
			        		  
						},
			  	         
			  	         downloadQRDivAsImage: function(win) {
			  	        	 // Check if the window and body ID are valid
			  	        	 if (!win || !win.body || !win.body.id) {
			  	        		 return;
			  	        	 }

			  	        	 // Retrieve the body ID and QR data
			  	        	 var bodyId = win.down('#mainQRPanal').body.id;
			  	        	 var qrRawData = win.qrData;

			  	        	 // Check if qrData is valid and decoded
			  	        	 var qrData;
			  	        	 try {
			  	        		 qrData = Ext.decode(qrRawData);
			  	        	 } catch (e) {
			  	        		 return;
			  	        	 }

			  	        	 // Check if the div with the bodyId exists
			  	        	 var original = document.getElementById(bodyId);
			  	        	 if (!original) {
			  	        		 return;
			  	        	 }

			  	        	 // Ensure the window is open (you can define your own condition for checking this)
			  	        	 if (win.isClosed || !win.isVisible()) {
			  	        		 return;
			  	        	 }

			  	        	 // Now, proceed with the html2canvas capture
			  	        	 html2canvas(original).then(function(canvas) {
			  	        		 var link = document.createElement("a");
			  	        		 link.href = canvas.toDataURL("image/png");
			  	        		 link.download = qrData.attendanceType + "-" + qrData.qrId + "-QRImg.png";
			  	        		 link.click();
			  	        	 });
			  	         }

});

