
/**
 *  @author Rajkumar.patidar
 * 
 */
Ext.define('Academia.controller.feeandpayment.AccountStatementReportController', {
	extend : 'Academia.controller.base.BaseController',
	stores : ['feeandpayment.dashboardAndReports.FeeFindAllBillTypedUser','feeandpayment.dashboardAndReports.FeeStudentDetailsByStudentCodeStore','feeandpayment.dashboardAndReports.ViewAccountStatementReportGrid',
	          'feeandpayment.dashboardAndReports.FeeProgramCodeStore','feeandpayment.dashboardAndReports.FeeBatchNameByProgramStore','feeandpayment.dashboardAndReports.AccountStatementReportGrid',
	          'feeandpayment.managebill.Sponsors','feeandpayment.managebill.Applicant','common.ProgramByApplicantAndStudentStore',
	          'feeandpayment.ActualAccountStatementGridStore','feeandpayment.ViewActualAccountStatementGridStore','feeandpayment.StatementOfAccountReportTypeStore',
	          'feeandpayment.managebill.billview.BillViewForPC', 'program.ProgramCategoryStore', 'program.ProgramGroupStore',
	          'common.SeatTypesByBatchId','program.ProgramGroupByProgramIdStore','program.ProgramCategoryByProgramId','feeandpayment.managebill.StudentDetailsByNationalId','feeandpayment.managebill.Student','common.StatusAllComboStore',
               'feeandpayment.StatementOfAccountReportTypeStore'
	          ],
	          views : ['feeandpayment.AccountStatmentStructure','feeandpayment.AccountStatementSearch','feeandpayment.ViewAccountStatementGrid',
	                   'feeandpayment.AccountStatementGrid','feeandpayment.ViewAccountStatmentStructure','feeandpayment.ViewAccountStatement',
	                   'feeandpayment.ViewStudentAccountStatementGrid','feeandpayment.ViewStudentAccountStatmentStructure','feeandpayment.StudentAccountStatementSearch',
	                   'feeandpayment.ActualAccountStatementGrid', 'feeandpayment.ViewActualAccountStatementStructure',
	                   'feeandpayment.ViewActualAccountStatementGrid', 'feeandpayment.ActualApplicantAccountStatementGrid',
	                   'feeandpayment.ActualSponsorAccountStatementGrid', 'feeandpayment.ViewActualApplicantAccountStatementGrid',
	                   'feeandpayment.ViewActualSponsorAccountStatementGrid','feeandpayment.managebill.billview.BillViewWindow',
	                   'feeandpayment.managebill.billview.BillViewForPCGrid','feeandpayment.ViewStudentActualAccountStatementGrid',
	                   'feeandpayment.reports.FeeHeadWiseCollectionReportForm','feeandpayment.reports.FeeHeadWiseCollectionReportGrid','feeandpayment.reports.ApplicantFeeHeadWiseCollectionReportForm','feeandpayment.reports.ApplicantFeeHeadWiseCollectionReportGrid',
	      			   'programCourseDashboard.organizationUnit.OrganizationUnit','common.StatusAllCombo','feeandpayment.StatementOfAccountReportWin',
	                   'feeandpayment.StudentStatementOfAccountPopup','feeandpayment.StudentStatementOfAccountForm','feeandpayment.AccountStatementWindow'],	
	                   config:{
	                	   STUDENT_STATEMENT_OF_ACCOUNT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_STATEMENT_OF_ACCOUNT_PRIVILEGES'),
	                	   PARENT_STATEMENT_OF_ACCOUNT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_STATEMENT_OF_ACCOUNT_PRIVILEGES'),
	                	   PC_STUDENT_STATEMENT_OF_ACCOUNT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PC_STUDENT_STATEMENT_OF_ACCOUNT_PRIVILEGES')
	                   },
	                   refs : [{
	                	   ref : 'accountstatementsearch',
	                	   selector : 'accountstatementsearch' 
	                   },{
	                	   ref : 'accountstatementgrid',
	                	   selector : 'accountstatementgrid' 
	                   },{
	                	   ref : 'actualaccountstatementgrid',
	                	   selector : 'actualaccountstatementgrid' 
	                   },{
	                	   ref : 'actualapplicantaccountstatementgrid',
	                	   selector : 'actualapplicantaccountstatementgrid' 
	                   },{
	                	   ref : 'actualsponsoraccountstatementgrid',
	                	   selector : 'actualsponsoraccountstatementgrid' 
	                   },{
	                	   ref : 'viewaccountstatementgrid',
	                	   selector : 'viewaccountstatementgrid'
	                   },{
	                	   ref : 'viewactualaccountstatementgrid',
	                	   selector : 'viewactualaccountstatementgrid'
	                   },{
	                	   ref : 'viewactualapplicantaccountstatementgrid',
	                	   selector : 'viewactualapplicantaccountstatementgrid'
	                   },{
	                	   ref : 'viewactualsponsoraccountstatementgrid',
	                	   selector : 'viewactualsponsoraccountstatementgrid'
	                   },{
	                	   ref : 'viewaccountstatement',
	                	   selector : 'viewaccountstatement'
	                   },{
	                	   ref : 'contentPanel',
	                	   selector : 'contentPanel'
	                   },{
	                	   ref:'viewAccountAddressDetailPanel',
	            	       selector:'addressdetailpanel[itemId=viewaccountaddressdetailpanel]'
	                   },{
	                	   ref:'viewActualAccountAddressDetailPanel',
	            	       selector:'addressdetailpanel[itemId=viewactualaccountaddressdetailpanel]'
	                   },{
	       				   ref : 'studentaccountstatementsearch',
	       				   selector : 'studentaccountstatementsearch' 
	                   },{
                      	   ref:'billviewwindow',
                    	   selector:'billviewwindow'
                       },{
	    				   ref : 'viewstudentaccountstatementgrid',
	    				   selector : 'viewstudentaccountstatementgrid' 
	                   },{
	    				   ref : 'viewstudentactualaccountstatementgrid',
	    				   selector : 'viewstudentactualaccountstatementgrid' 
	                   },{
                      	 	ref : 'billviewforpcgrid',
                      	 	selector : 'billviewforpcgrid'
	                   },{
	             			ref : 'feeheadwisecollectionreportform',
	            			selector : 'feeheadwisecollectionreportform'
	            		},{
	            			ref : 'feeheadwisecollectionreportgrid',
	            			selector : 'feeheadwisecollectionreportgrid'
	            		},
	            		{
	            			ref:'applicantfeeheadwisecollectionreportform',
	            			selector:'applicantfeeheadwisecollectionreportform'
	            		},
	            		{
	            			ref:'applicantfeeheadbasedcollectionreportgrid',
	            			selector:'applicantfeeheadbasedcollectionreportgrid'
	            		},{
	            			ref:'applicantfeeheadwisecollectionreportgrid',
	            			selector:'applicantfeeheadwisecollectionreportgrid'
	            		},{
	            			ref : 'organizationunit',
	            			selector : 'organizationunit'
	            		},{
	            			ref:'statementofaccountreportwin',
	            			selector:'statementofaccountreportwin'
	            		},
	            		{
                            ref : 'studentstatementofaccountpopup',
                            selector : 'studentstatementofaccountpopup'

                        },{
                        	ref : 'studentstatementofaccountform',
                            selector : 'studentstatementofaccountform'
                        },{
                        	ref : 'accountStatementWindow',
                            selector : 'accountStatementWindow'
                        	
                        }], 

	                   init : function() {
	                	   this.control({
	                		   'accountstatementsearch':{
	                			   render:function(frm){
	                				   var form = frm.getForm();
	                				   var recieptView = form.findField('recieptView');
	                				   var sponsors = form.findField('sponsors');
	                				   var applicant = form.findField('applicant');
	                				   recieptView.allowBlank=true;
	                				   sponsors.allowBlank=true;
	                				   applicant.allowBlank=true;
	                				   frm.down('#statusComboItemId').setValue('Active');
	                				  
	                				   var recieptView = form.findField('recieptView');
	                				   var recieptViewStore  = recieptView.getStore();
	                				   recieptViewStore.getProxy().extraParams ={
	                					   screenType:'statementOfAccount',
	                				   },
	                				   recieptViewStore.load({
	                					   callback: function(rec, operation, success) {
	                						   if (success) {
	                							   for(i in rec) {
	                								   if(rec[i].get('id')==1) {
	                									   recieptView.setValue(rec[i].get('id'));
	                								   }
	                							   }
	                							    for(var i in rec){
	                								   if(rec[i].data.code=='Student')
	                								   {
	                									   recieptView.setValue(rec[i].get('id'));
	                								   }
	                							   }
	                						   }
	                					   }
	                				   });
	                				  this.loadProgram(frm);
	                				  
	                				  $this = this;
	                				  
	                				  setTimeout(function(){
		                				   var itemIdPrivilegeNameArray = [{"#actualTransactionId" : "ACTUAL_TRANS" , "#voucherTransactionId" : "VOUCHER_BASED_TRANS", "radioGroupItemId" : "#transactionTypeId", "defaultButtonItemId" : "#actualTransactionId" }];
		                				   $this.disableRadioGroupAndOtherPivileges(frm, $this.getPC_STUDENT_STATEMENT_OF_ACCOUNT_PERMISSIONS(), itemIdPrivilegeNameArray);
	                				   }, 100);
	                				  
	                			   },
	                			   afterrender:function(form){
	                				   var grid = form.down('accountstatementgrid');
	                				   var structure = form.up('accountstatmentstructure');
	                				   this.getGridHeaderFreeze(grid,form);
	                				  this.doAccessControlValidation(form,this.getPC_STUDENT_STATEMENT_OF_ACCOUNT_PERMISSIONS());
	                				   this.disableMoreActionPivileges(form,this.getPC_STUDENT_STATEMENT_OF_ACCOUNT_PERMISSIONS());
	                			   }
	                		   },
	                		   'accountstatementsearch multiselectcombofield[itemId=academyLocationId]': {
					    			 render: function(){
					    				 var $this = this;
					    				 var form = $this.getAccountstatementsearch();
					    				 if(form){
										 var academyLocationId = this.getCurrentAcademyLocation();
										 var fnpALId = form.down('#academyLocationId');
									 	 var store = fnpALId.getStore();
					    				
					    				 store.load({
					    					 callback: function(records, operation, success) {
					    						 if (success) {
					    							for(var i in records){
					    								   if(records[i].data.id==academyLocationId){
					    									   fnpALId &&  fnpALId.setValue(academyLocationId);
					    								   }
					    							   }
					    							fnpALId &&  fnpALId.select(fnpALId.getStore().collect(fnpALId.valueField));
					    						 }
					    					 }
					    				 });
					    				 var studentField = form.down('#student');
					    				 if(studentField){
					    				 var studentStore = studentField.getStore();
					    				 studentStore.getProxy().extraParams = {
					    					 academyLocationIds: academyLocationId,
					    				 };
					    				 studentStore.load();
					    				 }
					    				 }
					    			    },
					    			 
					
//					    			    select : function(obj,record) { 
//										var $this = this;
//										setTimeout(function(){
//											$this.fnpChangeAcademyLocationEventNew(obj,record);
//										},300);
//							}
	    		 },
	                			   
	                		 /*Comment due to V2D-42822 V2D-42822 on 10-04-2019
	                		    * 'accountstatementsearch radiogroup[itemId=accountstatementId]':{
	                			   change : function(obj,newValue){
	                				   var form = obj.up('form');
	                				   var programwise = form.down("#programwise");

	                				   var recieptView = form.getForm().findField('recieptView');
	                				   var student = form.getForm().findField('student');
	                				   var sponsors = form.getForm().findField('sponsors');
	                				   var applicant = form.getForm().findField('applicant');
	                				   var program = form.getForm().findField('programName');
	                				   var batchName = form.getForm().findField('batchName');
	                				   
	                				   var accountStatemenType = form.down("#accountstatementId").getValue();
	                				   
	                				   student.setVisible(false);
	                				   programwise.setVisible(false);

	                				   recieptView.allowBlank=true;
	                				   student.allowBlank=true;
	                				   sponsors.allowBlank=true;
	                				   applicant.allowBlank=true;
	                				   program.allowBlank=true;
	                				   batchName.allowBlank=true;
	                				   
	                				   student.reset();
	                				   sponsors.reset();
	                				   applicant.reset();
	                				   program.reset();
	                				   batchName.reset();

	                				   if(newValue.statementType){
	                					   if(recieptView.getValue()==1){
	                						   student.setVisible(true);
	                						   student.allowBlank=false;
	                					   }else if(recieptView.getValue()==2){
	                						   applicant.setVisible(true);
	                						   applicant.allowBlank=false;
	                					   }else if(recieptView.getValue()==3){
	                						   sponsors.setVisible(true);
	                						   sponsors.allowBlank=false;
	                					   }
	                				   }else{
	                					   if(recieptView.getValue()!=3){
	                						   programwise.setVisible(true);
		                					   program.setVisible(true);
		                					   batchName.setVisible(true);
		                					   program.allowBlank=false;
			                				   batchName.allowBlank=false;
	                					   }
		                				   student.setVisible(false);
		                				   applicant.setVisible(false);
		                				   sponsors.setVisible(false);
	                				   }
	                				   form.isValid();
	                			   }
	                		   },*/
	                		   'accountstatementsearch customcombobox#student': {
	                			   select :function(obj){
	                				   var form = obj.up('form');
	                				   form.isValid();
	                			   }
	                		   },
	                		   'accountstatementsearch multiselectcombofield#academyLocationId': {
	                			   select :function(obj,record){
	                				   var form = obj.up('form');
	                				   var alField =form.down('#academyLocationId');
	                				   var studentFld =form.down('#student');
	                				   var programName = form.down('#programName');
	                				   var programGroup = form.down('#programGroup');
	                				   var programCategoryId = form.down('#programCategoryId');
	                				   var multiselectAcademyLocation=alField.getValue();
	                				   var ALsId = [];
	                				   for(var i in multiselectAcademyLocation){
	                					   if(multiselectAcademyLocation.length>0){
	                						   ALsId.push(multiselectAcademyLocation[i].data.id);
	                					   }
	                				   }
	                				   if(ALsId.length == 0){
	                					   var academyLocation = this.getCurrentAcademyLocation();
	                				   }else{
	                					   var academyLocation =  ALsId.join();
	                				   }
	                				   programName.getStore().getProxy().extraParams = {
	                					   academyLocationIds:academyLocation,
	                					   
	                				   }
	                				   programName.getStore().load();
	                				  studentFld.getStore().getProxy().extraParams = {
    										allStudents:true,
    										academyLocationIds:ALsId.join()
    									}
    									studentFld.getStore().load();
	                			   }
	                		   },
	                		   'accountstatementsearch customcombobox#recieptView': {
	                			   select: function(obj, record) {
	                				   var $this=this;
	                				   var form = obj.up('form');
	                				   var grid = this.getAccountstatementgrid();
	                				   
	                				   var transactionTypeRadio = form.getForm().findField('transactionTypeName');
	                				   var accountStatementGrid = this.getAccountstatementgrid();
	                				   
	                				   var actualAccountStatementGrid = this.getActualaccountstatementgrid();
	                				   var actualApplicantAccountStatementGrid = this.getActualapplicantaccountstatementgrid();
	                				   var actualSponsorAccountStatementGrid = this.getActualsponsoraccountstatementgrid();
	                				   
	                				   var isVoucherGrid = true;
	                				   
	                				   var studentIdColIndex = 0;
                					   var personNameColIndex = 1;
                					   var programNameColIndex = 2;
                					   var batchNameColIndex = 3;
	                				   
	                				   if(transactionTypeRadio.getValue().transactionType=="ACTUAL_TRANSACTION"){
	                					   grid = actualAccountStatementGrid;
	                					   isVoucherGrid = false;
	                					   personNameColIndex = 2;
	                					   programNameColIndex = 3;
	                					   batchNameColIndex = 4;
	                				   
	                				   } else if(transactionTypeRadio.getValue().transactionType=="VOUCHER_BASED_TRANSACTION"){
	                					   grid = accountStatementGrid;
	                					   isVoucherGrid = true;
	                				   }
	                				   
	                				   
	                				   var recieptViewId = record[0].get("id");
	                				   var programwise = form.down("#programwise");
	                				   var students = form.down("#student");
	                				   var sponsors = form.down("#sponsors");
	                				   var applicants = form.down("#applicant");
	                				   var programCategory = form.getForm().findField('programCategory');
	                				   var programGroup = form.getForm().findField('programGroup');
	                				   var programName = form.down("#programName");
	                				   var batchName = form.down("#batchName");
	                				   var seatType = form.down("#seatType");
	                				   var status = form.down("#statusComboItemId");
	                				   var showAllStudents = form.down("#showAllStudentsItemId");
	                				   
	                				   var transactionTypeRadio = form.getForm().findField('transactionTypeName');
	                				   
	                				   students.reset();
	                				   status.reset();
	                				   sponsors.reset();
	                				   applicants.reset();
	                				   students.setVisible(false);
	                				   sponsors.setVisible(false);
	                				   applicants.setVisible(false);
	                				   students.allowBlank=true;
	                				   sponsors.allowBlank=true;
	                				   applicants.allowBlank=true;
	                				   programName.allowBlank=true;
                					   batchName.allowBlank=true;
                					   status.setVisible(false);
                					   showAllStudents.setVisible(false);
                					   
	                				   if(recieptViewId==1){
	                				   	   students.setVisible(true);
	                				   	   programCategory.setVisible(true);
	                				   	   programGroup.setVisible(true);
	                					   programName.setVisible(true);
	                					   batchName.setVisible(true);
	                					   seatType.setVisible(true);
	                					   showAllStudents.setVisible(true);
	                					   
	                					   if(transactionTypeRadio.getValue().transactionType=="ACTUAL_TRANSACTION"){
	                						   status.setVisible(true);
	                						   showAllStudents.setVisible(true);
	                						   grid = actualAccountStatementGrid;
		                					   actualAccountStatementGrid.setVisible(true);
		                					   actualApplicantAccountStatementGrid.setVisible(false);
		                					   actualSponsorAccountStatementGrid.setVisible(false);
	                					   } else {
	                						   status.setVisible(false);
	                						   showAllStudents.setVisible(false);
	                						   grid = this.getAccountstatementgrid();
		                					   actualAccountStatementGrid.setVisible(false);
		                					   actualApplicantAccountStatementGrid.setVisible(false);
		                					   actualSponsorAccountStatementGrid.setVisible(false);
		                					   
		                					   grid.columns[studentIdColIndex].setText(getFeeAndPaymentCommonTranslation('STUDENT_ID'));
		                					   grid.columns[personNameColIndex].setText(getFeeAndPaymentCommonTranslation('STUDENT_NAME'));
		                					   grid.columns[programNameColIndex].setVisible(true);
		                					   grid.columns[batchNameColIndex].setVisible(true);
		                					   
		                					   grid.setTitle(getFeeAndPaymentCommonTranslation('LIST_OF_STUDENT'));
	                					   }
	                					   
	                					   this.loadProgram(form);

	                				   }
	                				   else if(recieptViewId==2){
	   			             			   applicants.setVisible(true);
	                					   applicants.allowBlank=true;
	                					   programCategory.setVisible(true);
	                				   	   programGroup.setVisible(true);
	                					   programName.setVisible(true);
	                					   batchName.setVisible(true);
	                					   seatType.setVisible(true);
	                					   showAllStudents.setVisible(false);
	                					   
	                					   if(transactionTypeRadio.getValue().transactionType=="ACTUAL_TRANSACTION"){
	                						   grid = actualApplicantAccountStatementGrid;
		                					   actualAccountStatementGrid.setVisible(false);
		                					   actualApplicantAccountStatementGrid.setVisible(true);
		                					   actualSponsorAccountStatementGrid.setVisible(false);
		                					   showAllStudents.setVisible(false);
	                					   } else {
	                						   status.setVisible(false);
	                						   grid = this.getAccountstatementgrid();
	                						   showAllStudents.setVisible(false);
		                					   actualAccountStatementGrid.setVisible(false);
		                					   actualApplicantAccountStatementGrid.setVisible(false);
		                					   actualSponsorAccountStatementGrid.setVisible(false);
		                					   
		                					   grid.columns[studentIdColIndex].setText(getFeeAndPaymentCommonTranslation('APPLICANT_ID'));
		                					   grid.columns[personNameColIndex].setText(getFeeAndPaymentCommonTranslation('APPLICANT_NAME'));
		                					   grid.columns[programNameColIndex].setVisible(true);
		                					   grid.columns[batchNameColIndex].setVisible(true);
		                					   
		                					   grid.setTitle(getCommonTranslation('LIST_OF_APPLICANTS'));
	                					   }
	                					   
	                					  // grid.setTitle('title_changed');
	                					   status.setVisible(false);
	                					   this.loadProgram(form);	                					   
	                				   }
	                				   else if(recieptViewId==3){
	                				       sponsors.setVisible(true);
	                					   sponsors.allowBlank=true;
	                					   programCategory.setVisible(false);
	                					   programGroup.setVisible(false);
	                					   programName.setVisible(false);
	                					   batchName.setVisible(false);
	                					   seatType.setVisible(false);
	                					   programCategory.reset();
	                					   programGroup.reset();
	                					   programName.reset();
	                					   batchName.reset();
	                					   seatType.reset();
	                					   showAllStudents.setVisible(false);
	                					   
	                					   if(transactionTypeRadio.getValue().transactionType=="ACTUAL_TRANSACTION"){
	                						   grid = actualSponsorAccountStatementGrid;
		                					   actualAccountStatementGrid.setVisible(false);
		                					   actualApplicantAccountStatementGrid.setVisible(false);
		                					   actualSponsorAccountStatementGrid.setVisible(true);
		                					   showAllStudents.setVisible(false);
	                					   } else {
	                						   status.setVisible(false);
	                						   grid = this.getAccountstatementgrid();
		                					   actualAccountStatementGrid.setVisible(false);
		                					   actualApplicantAccountStatementGrid.setVisible(false);
		                					   actualSponsorAccountStatementGrid.setVisible(false);
		                					   
		                					   grid.columns[studentIdColIndex].setText(getFeeAndPaymentCommonTranslation('SPONSOR_ID'));
		                					   grid.columns[personNameColIndex].setText(getFeeAndPaymentCommonTranslation('SPONSOR_NAME'));
		                					   grid.columns[programNameColIndex].setVisible(false);
		                					   grid.columns[batchNameColIndex].setVisible(false);
		                					   showAllStudents.setVisible(false);
		                					   
		                					   grid.setTitle(getCommonTranslation('LIST_OF_SPONSORS'));
	                					   }
	                					   
	                					   status.setVisible(false);

	                				   }
	                				   
	                				   //grid.getStore().getProxy().extraParams= {};
	                				   grid.getStore().removeAll();
	                				   actualAccountStatementGrid.getStore().removeAll();
	                				   actualApplicantAccountStatementGrid.getStore().removeAll();
	                				   actualSponsorAccountStatementGrid.getStore().removeAll();
	                				   
	                				   $this.resetPageSetting(grid.getStore());
	                				   $this.resetPageSetting(actualAccountStatementGrid.getStore());
	                				   $this.resetPageSetting(actualApplicantAccountStatementGrid.getStore());
	                				   $this.resetPageSetting(actualSponsorAccountStatementGrid.getStore());
	                				   
	                				    var toolbar1 = grid.down('custompagingtoolbar');
	                		   			//leaveApprovalGrid.getStore().removeAll();
	                				    toolbar1.bindStore(grid.getStore());
	                				    toolbar1.onLoad();
	                				    
	                				    var toolbar2 = actualAccountStatementGrid.down('custompagingtoolbar');
	                		   			//leaveApprovalGrid.getStore().removeAll();
	                				    toolbar2.bindStore(actualAccountStatementGrid.getStore());
	                				    toolbar2.onLoad();
	                				    
	                				    var toolbar3 = actualApplicantAccountStatementGrid.down('custompagingtoolbar');
	                		   			//leaveApprovalGrid.getStore().removeAll();
	                				    toolbar3.bindStore(actualApplicantAccountStatementGrid.getStore());
	                				    toolbar3.onLoad();
	                				    
	                				    var toolbar4 = actualSponsorAccountStatementGrid.down('custompagingtoolbar');
	                		   			//leaveApprovalGrid.getStore().removeAll();
	                				    toolbar4.bindStore(actualSponsorAccountStatementGrid.getStore());
	                				    toolbar4.onLoad();
	                				   
	                				   //grid.getStore().load();
	                				   form.isValid();
	                			   }
	                		   },
	                		   'accountstatementsearch customcombobox#batchName': {
	                			   select : function(obj, record){
	                				   var form = obj.up('form');
	                				   var batchId = record[0].get("id");
	                				   var seatType = form.down('#seatType');
	                				   seatType.reset();
	        	                	   seatType.setDisabled(true);
	                				   if(batchId > 0){
	                					   seatType.setDisabled(false);
	                					   var seatTypeStore = seatType.getStore();
            							   seatTypeStore.getProxy().extraParams = {
            								   batchId: batchId
            							   };
            							   seatTypeStore.load({
            								   callback: function(records, operation, success) {
            									   if(records.length==1){
            										   seatType.setValue(records[0].data.seatType.id);
            										   seatType.setDisabled(false);
            									   }else
            									   {
            										   seatType.setDisabled(false);
            									   }
            								   }
            							   })
	                				   }
	                				   form.isValid();
	                			   }
	                		   },
	                		   'accountstatementsearch customcombobox#student': {
	                			   select: function(obj, record) {
	                				   var form = obj.up('form');
	                				   if(form){
	                				   var applicant = form.down("#applicant");
	                				   var sponsors = form.down("#sponsors");
	                				   var statusComboItemId = form.down("#statusComboItemId");
	                				   var programCategory = form.getForm().findField('programCategory');
	        	                	   var programGroup = form.getForm().findField('programGroup');
	        	                	   programCategory.reset();
	        	                	   programGroup.reset();
	                				   applicant.allowBlank=true;
	                				   sponsors.allowBlank=true;
	                				   this.loadPrgramAndBatch(form,null,obj.getValue(),null,null);
	                				   if(record[0].raw.studentStatus=="Active")
	                					   statusComboItemId.setValue(true);
	                				   else if(record[0].raw.studentStatus=="Inactive")
	                					   statusComboItemId.setValue(false);
	                				   else
	                					   statusComboItemId.setValue(null);
	                				       statusComboItemId.setReadOnly(true);
	                				   }
	                			   },
	                			   render: function(field){
	                				   var this$ = this;
	                				   var studentStore=field.getStore();
	                				   /* var academyLocationIds = this.getCurrentAcademyLocation();
	                				   studentStore.getProxy().extraParams = {
	                					   academyLocationIds: academyLocationIds,
	                					   allStudents:true
                					   };
	                				   studentStore.load();*/

	                				   studentStore.on('beforeload', function(store, operation) {
	                					   var form = this$.getAccountstatementsearch();
	                					   if(form){
	                					   var alField = form.down("#academyLocationId");
	                					   var multiselectAcademyLocation=alField.getValue();
	                					   var ALsId = [];
	                					   for(var i in multiselectAcademyLocation){
	                						   if(!isNullOrEmpty(multiselectAcademyLocation[i]) && typeof multiselectAcademyLocation[i]=='object'){
	                							   ALsId.push(multiselectAcademyLocation[i].data.id);
	                						   }else{
	                							   ALsId.push(multiselectAcademyLocation[i]);
	                						   }
	                					   }
	                					   var isInactive,statusCombo =form.down('#statusComboItemId'),
	                					   statusComboValue = statusCombo.getValue(),
	                					   store = field.getStore();
	                					   if(statusComboValue){
	                						   isInactive=false;
	                					   }else{
	                						   isInactive=true;
	                					   }
	                					   if(isNullOrEmpty(statusComboValue)){
	                						   isInactive=null;
	                					   }
	                					   studentStore.proxy.extraParams.academyLocationIds=ALsId.join();
	                					   studentStore.proxy.extraParams.isInactive=isInactive;
	                					   }
	                				   });
	                			   }
	                		   },
	                		   'accountstatementsearch customcombobox#sponsors': {
	                			   select: function(obj, record) {
	                				   var form = obj.up('form');
	                				   if(form){
		                				   var students = form.down("#student");
		                				   var applicants = form.down("#applicant");
		                				   students.allowBlank=true;
		                				   applicants.allowBlank=true;
		                				   form.isValid();
	                				   }
	                			   },
	                			   render:function(obj){
	                				    var this$ = this;
	                				    var store = obj.getStore();
	                				    store.on('beforeload', function(store, operation) {
	                				        var form = this$.getAccountstatementsearch();
	                				        if(form){
	                				        var alField = form.down("#academyLocationId");
	                				        var multiselectAcademyLocation=alField.getValue();
	                				        var ALsId = [];
	                				        for(var i in multiselectAcademyLocation){
	                				            if(!isNullOrEmpty(multiselectAcademyLocation[i]) && typeof multiselectAcademyLocation[i]=='object'){
	                				                ALsId.push(multiselectAcademyLocation[i].data.id);
	                				            }else{
	                				                ALsId.push(multiselectAcademyLocation[i]);
	                				            }

	                				        }
	                				        store.proxy.extraParams.academyLocationIds=ALsId.join()
	                				        }
	                				    });
	                				}
	                		   },
	                		   'accountstatementsearch customcombobox#applicant': {
	                			   select: function(obj, record) {
	                				   var form = obj.up('form');
	                				   if(form){
		                				   var students = form.down("#student");
		                				   var sponsors = form.down("#sponsors");
		                				   students.allowBlank=true;
		                				   sponsors.allowBlank=true;
		                				   var programCategory = form.getForm().findField('programCategory');
		        	                	   var programGroup = form.getForm().findField('programGroup');
		        	                	   programCategory.reset();
		        	                	   programGroup.reset();
		                				   this.loadPrgramAndBatch(form,obj.getValue(),null,null,null);
	                				   }
	                			   },
	                			   render: function(field){
		                               var this$ = this;
	                				   var applicantStore=field.getStore();
	                				  /*  if(applicantStore){
	                				  var academyLocationId = this.getCurrentAcademyLocation();
	                				   applicantStore.getProxy().extraParams = {
	                					   academyLocationId: academyLocationId
                					   };
	                				   applicantStore.load();
	                				   }*/
                                      applicantStore.on('beforeload', function(store, operation) {
	                					   var form = this$.getAccountstatementsearch();
	                					   if(form){
	                					   var alField = form.down("#academyLocationId");
	                					   var multiselectAcademyLocation=alField.getValue();
	                					   var ALsId = [];
	                					   for(var i in multiselectAcademyLocation){
	                						   if(!isNullOrEmpty(multiselectAcademyLocation[i]) && typeof multiselectAcademyLocation[i]=='object'){
	                							   ALsId.push(multiselectAcademyLocation[i].data.id);
	                						   }else{
	                							   ALsId.push(multiselectAcademyLocation[i]);
	                						   }
	                					   }
	                					   applicantStore.proxy.extraParams.academyLocationIds=ALsId.join()
	                					   }
	                				   });
	                			   }
	                		   },
	                		   'accountstatementsearch customcombobox[name=programCategory]': {
	                			   select: function(obj, record) {
	                				   var form = obj.up('form');
	                				   var applicant = form.down("#applicant");
	                				   var sponsors = form.down("#sponsors");
	                				   var statusComboItemId = form.down("#statusComboItemId");
	                				   applicant.allowBlank=true;
	                				   sponsors.allowBlank=true;
	                				   this.loadPrgramAndBatch(form,null,null,obj.getValue(),null);
	                				   if(record[0].raw.studentStatus=="Active")
	                					   statusComboItemId.setValue(true);
	                				   else if(record[0].raw.studentStatus=="Inactive")
	                					   statusComboItemId.setValue(false);
	                				   else
	                					   statusComboItemId.setValue(null);
	                				       statusComboItemId.setReadOnly(true);
	                			   },
	                		   },
	                		   'accountstatementsearch customcombobox[name=programGroup]': {
	                			   select: function(obj, record) {
	                				   var form = obj.up('form');
	                				   var applicant = form.down("#applicant");
	                				   var sponsors = form.down("#sponsors");
	                				   var statusComboItemId = form.down("#statusComboItemId");
	                				   applicant.allowBlank=true;
	                				   sponsors.allowBlank=true;
	                				   this.loadPrgramAndBatch(form,null,null,null,obj.getValue());
	                				   if(record[0].raw.studentStatus=="Active")
	                					   statusComboItemId.setValue(true);
	                				   else if(record[0].raw.studentStatus=="Inactive")
	                					   statusComboItemId.setValue(false);
	                				   else
	                					   statusComboItemId.setValue(null);
	                				       statusComboItemId.setReadOnly(true);
	                			   },
	                		   },
	                		   'accountstatementsearch customcombobox#programName': {
	                			   select: function(obj, record) {
	                				   var form = obj.up('form');
	                				   var programId = record[0].get("id");
	                				   var batch=form.down("#batchName");
	        	                	   batch.reset();
	        	                	   batch.setDisabled(true);
	        	                	   var seatType=form.down("#seatType");
	        	                	   seatType.reset();
	        	                	   seatType.setDisabled(true);
	                				   if(programId > 0){
	                					   batch.setDisabled(false);
	                					   var batchStore = batch.getStore();
		                				   batchStore.getProxy().extraParams = {
		                					   id: programId
		                				   };

		                				   batchStore.load({
		                					   callback: function(records, operation, success) {
		                						   if(records.length==1){
		                							   batch.setValue(records[0].get('id'));
		                							   var batchId=records[0].get('id');
		                							   var seatTypeStore = seatType.getStore();
		                							   seatTypeStore.getProxy().extraParams = {
		                								   batchId: batchId
		                							   };
		                							   seatTypeStore.load({
		                								   callback: function(records, operation, success) {
		                									   if(records.length==1){
		                										   seatType.setValue(records[0].data.seatType.id);
		                										   seatType.setDisabled(false);
		                									   }else
		                									   {
		                										   seatType.setDisabled(false);
		                									   }
		                								   }
		                							   })
		                							   batch.setDisabled(false);
		                						   }else{
		                							   batch.setDisabled(false);
		                						   }
		                					   }
		                				   });
		                				   var programCategory = form.getForm().findField('programCategory');
		    	                		   programCategoryId = programCategory.getValue();
		    	                		   var programGroup = form.getForm().findField('programGroup');
		    	                		   programGroupId = programGroup.getValue();
		    							    var programCategoryStore = programCategory.getStore();
		    	                				   programCategoryStore.getProxy().extraParams = {
		    	                					   programId: programId
		    	                				   };
		    	                				   programCategoryStore.load({
		            								   callback: function(records, operation, success) {
		            									   if(records.length==1){
		            										   programCategory.setValue(records[0].get('id'));
		            									   }
		            								   }
		            							   })
		    	                				   var programGroupStore = programGroup.getStore();
		    	                				   programGroupStore.getProxy().extraParams = {
		    	                					   programId: programId
		    	                					   
		    	                				   };
		    	                				   programGroupStore.load({
		            								   callback: function(records, operation, success) {
		            									   if(records.length==1){
		            										   programGroup.setValue(records[0].get('id'));
		            									   }
		            								   }
		            							   })
	                				   }
	                				   form.isValid();
	                			   },
	                			   render:function(obj){
	                				    var this$ = this;
	                				    var store = obj.getStore();
	                				    store.on('beforeload', function(store, operation) {
	                				        var form = this$.getAccountstatementsearch();
	                				        if(form){
	                				        var alField = form.down("#academyLocationId");
	                				        var multiselectAcademyLocation=alField.getValue();
	                				        var ALsId = [];
	                				        for(var i in multiselectAcademyLocation){
	                				            if(!isNullOrEmpty(multiselectAcademyLocation[i]) && typeof multiselectAcademyLocation[i]=='object'){
	                				                ALsId.push(multiselectAcademyLocation[i].data.id);
	                				            }else{
	                				                ALsId.push(multiselectAcademyLocation[i]);
	                				            }

	                				        }
	                				        store.proxy.extraParams.academyLocationIds=ALsId.join()
	                				        }
	                				    });
	                				}
	                		   },

	                		   'accountstatementsearch button[itemId=searchBtn]' : {
	                			   click : this.loadCreateSeqGrid
	                		   },

	                		   'accountstatementsearch button[itemId=resetBtn]': {
	                			   click: function(obj){
	                				   var form = obj.up('form');
	                				   form.down('#startDate').reset();
	                				   form.down('#student').reset(); 		//Added - V2D-282661
	                				   form.down('#tillDate').reset();
	                				   form.down('#statusComboItemId').setValue(null);
	                				   form.down('#statusComboItemId').setReadOnly(false);
	                				   form.down('#startDate').setMaxValue(false);
	                				   form.down('#tillDate').setMinValue(false);
//	                				   form.down('#academyLocationId');
	                				   var academyLocationId = this.getCurrentAcademyLocation();
										 var fnpALId = form.down('#academyLocationId');
									 	 var store = fnpALId.getStore();
	                				  
	                				  /* form.getForm().getFields().each(function(fields){
	                					   if(fields.name != 'recieptView' && fields.name != 'transactionTypeName' 
	                						   && fields.name != 'transactionType' ){
	                						   fields.reset();
	                						form.down('#startDate').setMaxValue(false);
	                						form.down('#tillDate').setMinValue(false);
	                					   }
	                				   });*/
	                				   this.resetStatementFor(form);
	                				   this.loadProgram(form);
	                				   setTimeout(function(){
                                           form.getForm().reset();
                                       },900);
	                				   
                                       setTimeout(function(){
                                           form.down('#recieptView').setValue(1);
                                             					    				
  					    				 store.load({
  					    					 callback: function(records, operation, success) {
  					    						 if (success) {
  					    							for(var i in records){
  					    								   if(records[i].data.id==academyLocationId){
  					    									   fnpALId.setValue(academyLocationId);
  					    								   }
  					    							   }
  					    							 fnpALId.select(fnpALId.getStore().collect(fnpALId.valueField));
  					    						 }
  					    					 }
  					    				 });
  					    				 var studentField = form.down('#student');
  					    				 var studentStore = studentField.getStore();
  					    				 studentStore.getProxy().extraParams = {
  					    					 academyLocationIds: academyLocationId,
  					    				 };
  					    				 studentStore.load();

                                       },905);
	                			   }
	                		   },
	                		   'studentaccountstatementsearch':{
	                			   render:function(frm){
	                				  $this = this;
	                				  var itemIdPrivilegeNameArray = [{"#actualTransactionId" : "ACTUAL_TRANS" , "#voucherTransactionId" : "VOUCHER_BASED_TRANS", "radioGroupItemId" : "#transactionTypeId", "defaultButtonItemId" : "#actualTransactionId" }];
	                				  
	                				  if(portalId==7){
	                  					  $this.disableRadioGroupAndOtherPivileges(frm, $this.getPARENT_STATEMENT_OF_ACCOUNT_PERMISSIONS(), itemIdPrivilegeNameArray);
	                  				  }else{//student portal
	                  					  $this.disableRadioGroupAndOtherPivileges(frm, $this.getSTUDENT_STATEMENT_OF_ACCOUNT_PERMISSIONS(), itemIdPrivilegeNameArray);
	                  				  }
	                				  
	                				  /*setTimeout(function(){
		                				   var itemIdPrivilegeNameArray = [{"#actualTransactionId" : "ACTUAL_TRANS" , "#voucherTransactionId" : "VOUCHER_BASED_TRANS", "radioGroupItemId" : "#transactionTypeId", "defaultButtonItemId" : "#actualTransactionId" }];
		                				   $this.disableRadioGroupAndOtherPivileges(frm, $this.getSTUDENT_STATEMENT_OF_ACCOUNT_PERMISSIONS(), itemIdPrivilegeNameArray);
	                				   }, 100);*/
	                				  
	                			   }
	                		   },
	                		   'studentaccountstatementsearch radiogroup[itemId=transactionTypeId]':{
	                			   change : function(obj,newValue,oldValue){
	                				   var activeTab = this.getContentPanel().getActiveTab(); 
	                				   var formObj = activeTab.down('studentaccountstatementsearch');
	                				   var form = formObj.getForm();
	                				   
	                				   var Viewstudentaccountstatementgrid = activeTab.down('viewstudentaccountstatementgrid');
	                				   var Viewstudentactualaccountstatementgrid = activeTab.down('viewstudentactualaccountstatementgrid');
                					   
	                				   if(newValue.transactionType=="ACTUAL_TRANSACTION"){
	                					   
	                					   Viewstudentactualaccountstatementgrid.setVisible(true);
	                					   Viewstudentaccountstatementgrid.setVisible(false);
	                					   grid = Viewstudentactualaccountstatementgrid;
	                				   
	                				   } else if(newValue.transactionType=="VOUCHER_BASED_TRANSACTION"){
	                					   
	                					   Viewstudentactualaccountstatementgrid.setVisible(false);
	                					   Viewstudentaccountstatementgrid.setVisible(true);
	                					   grid = Viewstudentaccountstatementgrid;
	                				   }
	                				   // change grid labels also
	                				   
	                				   formObj.doLayout();
	                				   activeTab.down('studentaccountstatementsearch').scrollBy(0,1);
	                				   activeTab.down('studentaccountstatementsearch').scrollBy(0,-1);
	                			   }
	                		   },
	                		   'accountstatementsearch radiogroup[itemId=transactionTypeId]':{
	                			   change : function(obj,newValue,oldValue){
	                				   this.selectTransactionType(obj,newValue,oldValue);
	                				   obj.up('accountstatementsearch').scrollBy(0,1);
	                				   obj.up('accountstatementsearch').scrollBy(0,-1);
	                			   },
	                			   afterrender: function(obj){
	                				   
	                				   setTimeout(function(){
		                				   var newValue = {};
		                				   var oldValue = {};
		                				   
		                				   if( !(obj.items.items[0].isVisible() && obj.items.items[1].isVisible()) ){
		                					   obj.setVisible(false);
		                				   }
		                				   
		                				   if( obj.items.items[0].isVisible() ){
		                					   
		                				   } else {
		                					   //if( obj.items.items[1].isVisible ){
			                					   newValue.transactionType = "VOUCHER_BASED_TRANSACTION";
			                					   oldValue.transactionType = "ACTUAL_TRANSACTION";
			                				   /*} else if( obj.items.items[0].isVisible ){
			                					   newValue.transactionType = "ACTUAL_TRANSACTION";
			                					   oldValue.transactionType = "VOUCHER_BASED_TRANSACTION";
			                				   }*/
			                				   
			                				   //setTimeout(function(){
				                				   //obj.items.items[0].checked = false;
				                				   //obj.items.items[1].checked = true;
				                				   //obj.fireEvent('change', obj, newValue, oldValue);
			                				   //}, 300);
		                				   }
	                				   }, 100);
	                			   }
	                		   },
	                		   'accountstatementgrid button[itemId=btnView]': {
	                			   click: function() {
	                				   this.viewAccountStatment();
	                			   }
	                		   },
	                		   'actualaccountstatementgrid': {
	                		   	  render : function(grid){
	                 				  var $this = this;
	                 				  $this.doAccessControlValidation(grid,this.getPC_STUDENT_STATEMENT_OF_ACCOUNT_PERMISSIONS());
	                 			  },
	                 			  afterrender:function(grid){
	                				var me = this;
	                				setTimeout(function(){
	                					me.addDataGridConfigButton(grid, me.getPC_STUDENT_STATEMENT_OF_ACCOUNT_PERMISSIONS());

	                				},1500);

	                			}
	                		   
	                		   },
	                		   'actualapplicantaccountstatementgrid': {
	                		   	  render : function(grid){
	                 				  var $this = this;
	                 				  $this.doAccessControlValidation(grid,this.getPC_STUDENT_STATEMENT_OF_ACCOUNT_PERMISSIONS());
	                 			  },
	                 			  afterrender:function(grid){
		                				var me = this;
		                				setTimeout(function(){
		                					me.addDataGridConfigButton(grid, me.getPC_STUDENT_STATEMENT_OF_ACCOUNT_PERMISSIONS());

		                				},1500);

		                			}
	                		   },
	                		   'actualsponsoraccountstatementgrid': {
	                		   	  render : function(grid){
	                 				  var $this = this;
	                 				  $this.doAccessControlValidation(grid,this.getPC_STUDENT_STATEMENT_OF_ACCOUNT_PERMISSIONS());
	                 			  },
	                 			  afterrender:function(grid){
		                				var me = this;
		                				setTimeout(function(){
		                					me.addDataGridConfigButton(grid, me.getPC_STUDENT_STATEMENT_OF_ACCOUNT_PERMISSIONS());

		                				},1500);

		                			}
	                		   },
	                		   'actualaccountstatementgrid button[itemId=btnView]': {
	                			   click: function(obj) {
	                				   var form = obj.up('form');
	                				   this.viewActualAccountStatment(form.getForm());
	                			   }
	                		   },
	                		   'actualapplicantaccountstatementgrid button[itemId=btnView]': {
	                			   click: function(obj) {
	                				   var form = obj.up('form');
	                				   this.viewActualAccountStatment(form.getForm());
	                			   }
	                		   },
	                		   'actualsponsoraccountstatementgrid button[itemId=btnView]': {
	                			   click: function(obj) {
	                				   var form = obj.up('form');
	                				   this.viewActualAccountStatment(form.getForm());
	                			   }
	                		   },
	                		   'viewaccountstatementgrid button[itemId=btnPrint]':{
	                 			  click : function(){
	                 				  var grid= this.getAccountstatementgrid();
	                 				  this.exportJRXML('pdf',grid);
	                 			  }
	                 		  },
	                 		  'studentaccountstatementsearch button[itemId=searchBtn]': {
	                 			  click: function() {
	                 				  this.searchStudentAccountStatment();
	                 			  }
	                 		  },
	                 		  'studentaccountstatementsearch button[itemId=resetBtn]': {
	                 			  click: function(obj) {
	                 				  var form = obj.up('form');
	                 				  form.getForm().getFields().each(function(fields){
	                 					  fields.reset();
	                 					  form.down('#startDate').setMaxValue(false);
	                 					  form.down('#tillDate').setMinValue(false);
	                 				  });
	                 				  form.down('#startDate').setValue(dateRender(Ext.Date.add(new Date(), Ext.Date.DAY, -30)));
                					  form.down('#tillDate').setValue(dateRender(new Date()));
	                 			  }
	                 		  },
	                 		  'viewstudentaccountstatementgrid button[itemId=btnPrint]':{
	                 			  click : function(){
	                 				  var grid= this.getAccountstatementgrid();
	                 				  this.studentExportJRXML('pdf',grid);
	                 			  }
	                 		  },
	                 		  'viewactualaccountstatementgrid button[itemId=btnPrint]':{
	                 			  click : function(){
	                 				  var $this =this;
	                 				  var reportType =  "Student Statement of Account";
	                 				  Ext.Ajax.request({
	                 					  method: "GET",
	                 					  type: 'rest',
	                 					  url: SERVERURL.TEMPLATE_NAME_BY_CODE,
	                 					  params: {
	                 						  reportType : reportType
	                 					  },
	                 					  success: function(f, action) {
	                 						  $this.data = Ext.decode(f.responseText);
	                 						  var grid =  $this.getActualaccountstatementgrid();
	                 						  var records = grid.getSelectionModel().getSelection();
	                 							  if(!isNullOrEmpty($this.data)){
	                 								  if($this.data.length == 0){
	                 									  showWarningMessage(getServiceRequestTranslation('ALERT'),'No Report is Mapped');
	                 								  }else if($this.data.length > 1){

	                 									  var statementOfAccountReportWin = $this.getStudentstatementofaccountpopup();
	                 									  if (!statementOfAccountReportWin) {
	                 										  Ext.widget('studentstatementofaccountpopup');
	                 										  statementOfAccountReportWin = $this.getStudentstatementofaccountpopup();
	                 									  }
	                 									  statementOfAccountReportWin.show();
	                 									  var store = statementOfAccountReportWin.down('#statementOfAccountReportTypeId').getStore();
	                 									  store.getProxy().extraParams = {
	                 										  reportType : 'Student Statement of Account'
	                 									  };
	                 									  store.load();

	                 								  }
	                 								  else{
	                 									  if($this.data[0].value == 'Falsebay Statement of Account'){
	                 										  code = 'VELOCITY_STATEMENT_OF_ACCOUNT';
	                 										  $this.downloadDetailedStudentStatementOfAccountReport(code);
	                 									  }
	                 									  else if ($this.data.value == 'Statement of Account'){
	                 										  code = 'STATEMENT_OF_ACCOUNT'
	                 											  $this.downloadDetailedStudentStatementOfAccountReport(code);
	                 									  }
	                 									  else if ($this.data.value == 'Statement of Account - KRMU'){
	                 										  code = 'STATEMENT_OF_ACCOUNT_KRMU'
	                 											  $this.downloadDetailedStudentStatementOfAccountReport(code);
	                 									  }
	                 									  else if ($this.data.value == 'SUB Statement of Account'){
	                 										  code = 'SUB_STATEMENT_OF_ACCOUNT'
	                 											  $this.downloadDetailedStudentStatementOfAccountReport(code);
	                 									  }
	                 									  else if ($this.data.value == 'Eng Statement of Account - SU'){
	                 										  code = 'SUNSHINE_STATEMENT_OF_ACCOUNT'
	                 											  $this.downloadDetailedStudentStatementOfAccountReport(code);
	                 									  }
	                 									  else if ($this.data.value == 'UPNG Statement of Account'){
	                 										  code = 'UPNG_STATEMENT_OF_ACCOUNT'
	                 											  $this.downloadDetailedStudentStatementOfAccountReport(code);
	                 									  }
	                 									  else if ($this.data.value == 'UWC Statement of Account'){
	                 										  code = 'UWC_STATEMENT_OF_ACCOUNT'
	                 											  $this.downloadDetailedStudentStatementOfAccountReport(code);
	                 									  }
                                                         else if ($this.data.value == 'OUM Statement of Account'){
	                 										  code = 'OUM_STATEMENT_OF_ACCOUNT'
	                 											  $this.downloadDetailedStudentStatementOfAccountReport(code);
	                 									  }
	                 									  else if ($this.data.value == 'Velocity Statement of Account'){
	                 										  code = 'VELOCITY_STATEMENT_OF_ACCOUNT'
	                 											  $this.downloadDetailedStudentStatementOfAccountReport(code);
	                 									  }
	                 									  else if ($this.data.value == 'Voucher Based Statement of Account'){
	                 										  code = 'STATEMENT_OF_ACCOUNT_REPORT'
	                 											  $this.downloadDetailedStudentStatementOfAccountReport(code);
	                 									  }
	                 									  else if($this.data.value == 'Afr Statement of Account - SU'){
	                 										 code = 'SUNSHINE_STATEMENT_OF_ACCOUNT_(AFRIKAANS)'
	                 											  $this.downloadDetailedStudentStatementOfAccountReport(code);	
	                 									  }
	                 									  else{
	                 										  code = 'SUNSHINE_STATEMENT_OF_ACCOUNT_(AFRIKAANS)';
	                 										  $this.downloadDetailedStudentStatementOfAccountReport(code);
	                 									  }

	                 								  }
	                 							  }
	                 						  
	                 						  else {
	                 							  showWarningMessage(getServiceRequestTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	                 						  }

	                 					  }
	                 				  });


	                 			  }
	                 		  }, 
	                                  
	                                  'studentstatementofaccountpopup button[itemId=downloadStudentStatementOfAccountReport]':{
	                                	  click : function(){
	                                		  var popupForm = this.getStudentstatementofaccountpopup();
	                                		  var $this = this;
	                                		  var reportType = popupForm.down('#statementOfAccountReportTypeId');
	                                		  var code;
	                                		  if(reportType.getDisplayValue() == 'Falsebay Statement of Account'){
	                                			  code = 'VELOCITY_STATEMENT_OF_ACCOUNT';
	                                			  $this.downloadDetailedStudentStatementOfAccountReport(code);
	                                		  }
	                                		  else if (reportType.getDisplayValue() == 'Statement of Account'){
	                                			  code = 'STATEMENT_OF_ACCOUNT'
	                                				  $this.downloadDetailedStudentStatementOfAccountReport(code);
	                                		  }
	                                		  else if (reportType.getDisplayValue() == 'Statement of Account - KRMU'){
	                                			  code = 'STATEMENT_OF_ACCOUNT_KRMU'
	                                				  $this.downloadDetailedStudentStatementOfAccountReport(code);
	                                		  }
	                                		  else if (reportType.getDisplayValue() == 'SUB Statement of Account'){
	                                			  code = 'SUB_STATEMENT_OF_ACCOUNT'
	                                				  $this.downloadDetailedStudentStatementOfAccountReport(code);
	                                		  }
	                                		  else if (reportType.getDisplayValue() == 'Eng Statement of Account - SU'){
	                                			  code = 'SUNSHINE_STATEMENT_OF_ACCOUNT'
	                                				  $this.downloadDetailedStudentStatementOfAccountReport(code);
	                                		  }
	                                		  else if (reportType.getDisplayValue() == 'UPNG Statement of Account'){
	                                			  code = 'UPNG_STATEMENT_OF_ACCOUNT'
	                                				  $this.downloadDetailedStudentStatementOfAccountReport(code);
	                                		  }
	                                		  else if (reportType.getDisplayValue() == 'UWC Statement of Account'){
	                                			  code = 'UWC_STATEMENT_OF_ACCOUNT'
	                                				  $this.downloadDetailedStudentStatementOfAccountReport(code);
	                                		  }
                                              else if (reportType.getDisplayValue() == 'OUM Statement of Account'){
	                 										  code = 'OUM_STATEMENT_OF_ACCOUNT'
	                 											  $this.downloadDetailedStudentStatementOfAccountReport(code);
	                 									  }
	                                		  else if (reportType.getDisplayValue() == 'Velocity Statement of Account'){
	                                			  code = 'VELOCITY_STATEMENT_OF_ACCOUNT'
	                                				  $this.downloadDetailedStudentStatementOfAccountReport(code);
	                                		  }
	                                		  else if (reportType.getDisplayValue() == 'Voucher Based Statement of Account'){
	                                			  code = 'STATEMENT_OF_ACCOUNT_REPORT'
	                                				  $this.downloadDetailedStudentStatementOfAccountReport(code);
	                                		  }
	                                		  else if($this.data.value == 'Afr Statement of Account - SU'){
          										 code = 'SUNSHINE_STATEMENT_OF_ACCOUNT_(AFRIKAANS)'
          											  $this.downloadDetailedStudentStatementOfAccountReport(code);	
          									  }
	                                		  else{
	                                			  code = 'SUNSHINE_STATEMENT_OF_ACCOUNT_(AFRIKAANS)';
	                                			  $this.downloadDetailedStudentStatementOfAccountReport(code);
	                                		  }
	                                		  popupForm.close();
	                                	  }
	                                  }, 
	                 		  'viewactualapplicantaccountstatementgrid button[itemId=btnPrint]':{
	                 			  click : function(){
	                 				  var grid = this.getViewactualapplicantaccountstatementgrid();
	                 				  this.exportXLFunction('pdf',grid,'APPLICANT');
	                 			  }
	                 		  },
	                 		  'viewactualsponsoraccountstatementgrid button[itemId=btnPrint]':{
	                 			  click : function(){
	                 				  var grid = this.getViewactualsponsoraccountstatementgrid();
	                 				  this.exportXLFunction('pdf',grid,'SPONSOR');
	                 			  }
	                 		  },
	                 		  'viewstudentactualaccountstatementgrid button[itemId=btnPrint]':{
	                 			  click : function(){
	                 				  var $this =this;
	                 				  var reportType =  "Student Statement of Account";
	                 				  Ext.Ajax.request({
	                 					  method: "GET",
	                 					  type: 'rest',
	                 					  url: SERVERURL.TEMPLATE_NAME_BY_CODE,
	                 					  params: {
	                 						  reportType : reportType
	                 					  },
	                 					  success: function(f, action) {
	                 						  $this.data = Ext.decode(f.responseText);
	                 						  var grid =  $this.getActualaccountstatementgrid();
//	                 						  var records = grid.getSelectionModel().getSelection();
	                 							  if(!isNullOrEmpty($this.data)){
	                 								  if($this.data.length == 0){
	                 									  showWarningMessage(getServiceRequestTranslation('ALERT'),'No Report is Mapped');
	                 								  }else if($this.data.length > 1){

	                 									  var statementOfAccountReportWin = $this.getStudentstatementofaccountform();
	                 									  if (!statementOfAccountReportWin) {
	                 										  Ext.widget('studentstatementofaccountform');
	                 										  statementOfAccountReportWin = $this.getStudentstatementofaccountform();
	                 									  }
	                 									  statementOfAccountReportWin.show();
	                 									  var store = statementOfAccountReportWin.down('#statementOfAccountReportTypeId').getStore();
	                 									  store.getProxy().extraParams = {
	                 										  reportType : 'Student Statement of Account'
	                 									  };
	                 									  store.load();

	                 								  }
	                 								  else{
	                 									  if($this.data[0].value == 'Falsebay Statement of Account'){
	                 										  code = 'VELOCITY_STATEMENT_OF_ACCOUNT';
	                 										  $this.downloadStudentDetailedStudentStatementOfAccountReport(code);
	                 									  }
	                 									  else if ($this.data.value == 'Statement of Account'){
	                 										  code = 'STATEMENT_OF_ACCOUNT'
	                 											  $this.downloadStudentDetailedStudentStatementOfAccountReport(code);
	                 									  }
	                 									  else if ($this.data.value == 'Statement of Account - KRMU'){
	                 										  code = 'STATEMENT_OF_ACCOUNT_KRMU'
	                 											  $this.downloadStudentDetailedStudentStatementOfAccountReport(code);
	                 									  }
	                 									  else if ($this.data.value == 'SUB Statement of Account'){
	                 										  code = 'SUB_STATEMENT_OF_ACCOUNT'
	                 											  $this.downloadStudentDetailedStudentStatementOfAccountReport(code);
	                 									  }
	                 									  else if ($this.data.value == 'Eng Statement of Account - SU'){
	                 										  code = 'SUNSHINE_STATEMENT_OF_ACCOUNT'
	                 											  $this.downloadStudentDetailedStudentStatementOfAccountReport(code);
	                 									  }
	                 									  else if ($this.data.value == 'UPNG Statement of Account'){
	                 										  code = 'UPNG_STATEMENT_OF_ACCOUNT'
	                 											  $this.downloadStudentDetailedStudentStatementOfAccountReport(code);
	                 									  }
	                 									  else if ($this.data.value == 'UWC Statement of Account'){
	                 										  code = 'UWC_STATEMENT_OF_ACCOUNT'
	                 											  $this.downloadStudentDetailedStudentStatementOfAccountReport(code);
	                 									  }
                                                          else if ($this.data.value == 'OUM Statement of Account'){
	                 										  code = 'OUM_STATEMENT_OF_ACCOUNT'
	                 											  $this.downloadDetailedStudentStatementOfAccountReport(code);
	                 									  }
	                 									  else if ($this.data.value == 'Velocity Statement of Account'){
	                 										  code = 'VELOCITY_STATEMENT_OF_ACCOUNT'
	                 											  $this.downloadStudentDetailedStudentStatementOfAccountReport(code);
	                 									  }
	                 									  else if ($this.data.value == 'Voucher Based Statement of Account'){
	                 										  code = 'STATEMENT_OF_ACCOUNT_REPORT'
	                 											  $this.downloadStudentDetailedStudentStatementOfAccountReport(code);
	                 									  }
	                 									  else if($this.data.value == 'Afr Statement of Account - SU'){
	                 										 code = 'SUNSHINE_STATEMENT_OF_ACCOUNT_(AFRIKAANS)'
	                 											  $this.downloadStudentDetailedStudentStatementOfAccountReport(code);	
	                 									  }
	                 									  else{
	                 										  code = 'SUNSHINE_STATEMENT_OF_ACCOUNT_(AFRIKAANS)';
	                 										  $this.downloadStudentDetailedStudentStatementOfAccountReport(code);
	                 									  }

	                 								  }
	                 							  }
	                 						  
	                 						  else {
	                 							  showWarningMessage(getServiceRequestTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	                 						  }

	                 					  }
	                 				  });

	                 			  }
	                 		  },
	                 		  
	                 	      'studentstatementofaccountform button[itemId=downloadStatementOfAccountReport]':{
                            	  click : function(){
                            		  var popupForm = this.getStudentstatementofaccountform();
                            		  var reportType = popupForm.down('#statementOfAccountReportTypeId');
                            		  var code;
                            		  if(reportType.getDisplayValue() == 'Falsebay Statement of Account'){
                            			  code = 'VELOCITY_STATEMENT_OF_ACCOUNT';
                            			  $this.downloadStudentDetailedStudentStatementOfAccountReport(code);
                            		  }
                            		  else if (reportType.getDisplayValue() == 'Statement of Account'){
                            			  code = 'STATEMENT_OF_ACCOUNT'
                            				  $this.downloadStudentDetailedStudentStatementOfAccountReport(code);
                            		  }
                            		  else if (reportType.getDisplayValue() == 'Statement of Account - KRMU'){
                            			  code = 'STATEMENT_OF_ACCOUNT_KRMU'
                            				  $this.downloadStudentDetailedStudentStatementOfAccountReport(code);
                            		  }
                            		  else if (reportType.getDisplayValue() == 'SUB Statement of Account'){
                            			  code = 'SUB_STATEMENT_OF_ACCOUNT'
                            				  $this.downloadStudentDetailedStudentStatementOfAccountReport(code);
                            		  }
                            		  else if (reportType.getDisplayValue() == 'Eng Statement of Account - SU'){
                            			  code = 'SUNSHINE_STATEMENT_OF_ACCOUNT'
                            				  $this.downloadStudentDetailedStudentStatementOfAccountReport(code);
                            		  }
                            		  else if (reportType.getDisplayValue() == 'UPNG Statement of Account'){
                            			  code = 'UPNG_STATEMENT_OF_ACCOUNT'
                            				  $this.downloadStudentDetailedStudentStatementOfAccountReport(code);
                            		  }
                            		  else if (reportType.getDisplayValue() == 'UWC Statement of Account'){
                            			  code = 'UWC_STATEMENT_OF_ACCOUNT'
                            				  $this.downloadStudentDetailedStudentStatementOfAccountReport(code);
                            		  }
                                      else if (reportType.getDisplayValue() == 'OUM Statement of Account'){
	                 							code = 'OUM_STATEMENT_OF_ACCOUNT'
	                 						$this.downloadStudentDetailedStudentStatementOfAccountReport(code);
	                 									  }
                            		  else if (reportType.getDisplayValue() == 'Velocity Statement of Account'){
                            			  code = 'VELOCITY_STATEMENT_OF_ACCOUNT'
                            				  $this.downloadStudentDetailedStudentStatementOfAccountReport(code);
                            		  }
                            		  else if (reportType.getDisplayValue() == 'Voucher Based Statement of Account'){
                            			  code = 'STATEMENT_OF_ACCOUNT_REPORT'
                            				  $this.downloadStudentDetailedStudentStatementOfAccountReport(code);
                            		  }
                            		  else if($this.data.value == 'Afr Statement of Account - SU'){
  										 code = 'SUNSHINE_STATEMENT_OF_ACCOUNT_(AFRIKAANS)'
  											  $this.downloadStudentDetailedStudentStatementOfAccountReport(code);	
  									  }
                            		  else{
                            			  code = 'SUNSHINE_STATEMENT_OF_ACCOUNT_(AFRIKAANS)';
                            			  $this.downloadStudentDetailedStudentStatementOfAccountReport(code);
                            		  }
                            		  popupForm.close();
                            	  }
                              },
	                 		  'viewstudentactualaccountstatementgrid':{
	                 			  render : function(grid){
	                 				  var $this = this;
	                 				  if(portalId==7){
	                 					  $this.doAccessControlValidation(grid,this.getPARENT_STATEMENT_OF_ACCOUNT_PERMISSIONS());
	                 				  }else{//student portal
	                 					  $this.doAccessControlValidation(grid,this.getSTUDENT_STATEMENT_OF_ACCOUNT_PERMISSIONS());
	                 				  }
	                 			  },
	                 			  afterrender : function()
	                 			  {
	                 				  var $this = this;
	                 				  var grid = $this.getViewstudentactualaccountstatementgrid();
	                 				  var viewstore = grid.getStore();
	                 				  viewstore.data.removeAll();
	                 			  }
	                 		  },
	                 		  'viewstudentaccountstatementgrid':{
	                 			  render : function(grid){
	                 				  var $this = this;
	                 				  if(portalId==7){
	                 					  $this.doAccessControlValidation(grid,this.getPARENT_STATEMENT_OF_ACCOUNT_PERMISSIONS());
	                 				  }else{//student portal
	                 					  $this.doAccessControlValidation(grid,this.getSTUDENT_STATEMENT_OF_ACCOUNT_PERMISSIONS());
	                 				  }
	                 			  }
	                 		   },
	                 		    'viewactualaccountstatementgrid':{
	                     			 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	 	                			    //var gridObj = this.getViewactualaccountstatementgrid();
                                      this.viewActualAccountStatementGridCellClick(grid,td, cellIndex, record, tr, rowIndex, e, eOpts, 'STUDENT' );
                                         /*var grid = this.getViewactualaccountstatementgrid();
                                         var exportBtn = grid.down('#btnPrint');
                                         if(record.data.creditAmount==0 && record.data.debitAmount==0 && record.data.balanceAmount==0){
                                             exportBtn.setDisabled(true);
                                         }
                                     else{
	                                       exportBtn.setDisabled(false);
                                       }*/
	                     			 },
	                     			render : function(grid){
		                 				  var $this = this;
		                 				  $this.doAccessControlValidation(grid,this.getPC_STUDENT_STATEMENT_OF_ACCOUNT_PERMISSIONS());
		                 			  },
										afterrender: function(grid) {
											var me = this;
											setTimeout(function() {
												me.addDataGridConfigButton(grid, me.getPC_STUDENT_STATEMENT_OF_ACCOUNT_PERMISSIONS());
											}, 1500);

                            },
								selectionchange: function(column, selected,eOpts ){ 
							            		var viewActualAccountGrid = this.getViewactualaccountstatementgrid()
												if(selected.length == 1){
													if(selected[0].data.transactionDate === null ||
															selected[0].data.transactionNo === null ||
															selected[0].data.transactionType === null){
							                    		viewActualAccountGrid.down('#btnCancel').setDisabled(true)
							                    		}else{
							                    			viewActualAccountGrid.down('#btnCancel').setDisabled(false);
							                        }							            			
													}
							            	}
	                     		 },
	                     		'viewactualapplicantaccountstatementgrid':{
	                     			 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	                     				 //var gridObj = this.getViewactualapplicantaccountstatementgrid();
	                     				 this.viewActualAccountStatementGridCellClick(grid,td, cellIndex, record, tr, rowIndex, e, eOpts, 'APPLICANT' );
	                     			 },
	                     			render : function(grid){
		                 				  var $this = this;
		                 				  $this.doAccessControlValidation(grid,this.getPC_STUDENT_STATEMENT_OF_ACCOUNT_PERMISSIONS());
		                 			  }
	                     		 },
	                     		'viewactualsponsoraccountstatementgrid':{
	                     			 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	                     				 //var gridObj = this.getViewactualsponsoraccountstatementgrid(); 
	                     				 this.viewActualAccountStatementGridCellClick(grid,td, cellIndex, record, tr, rowIndex, e, eOpts, 'SPONSOR' );
	                     			 },
	                     			render : function(grid){
		                 				  var $this = this;
		                 				  $this.doAccessControlValidation(grid,this.getPC_STUDENT_STATEMENT_OF_ACCOUNT_PERMISSIONS());
		                 			  }
	                     		 },
	                     		'addressdetailpanel[itemId=viewactualaccountaddressdetailpanel] displayfield[itemId=feeheadwisedistributionId]':{
	                     			render: function(component) {
	                     				var $this =this;
	                     				var infoPanel = $this.getViewActualAccountAddressDetailPanel();
	                     				if(!isNullOrEmpty(infoPanel)) {
	                     					var  detail = getCommonTranslation('FEE_HEADWISE_DISTRIBUTION');
	                     					infoPanel.down('#feeheadwisedistributionId').setValue("<a href='#'>"+detail+"</a>");
	                     					component.getEl().on('click', function(e) {
	                     						if(e.target.tagName=='A'){

	                     							var form =$this.getAccountstatementsearch();
	                     							var transactionType = form.down('#actualTransactionId').getValue();
	                     							var getForm = form.getForm();
	                     							var billUserType = getForm.findField('recieptView').valueModels[0].data.value;
	                     							if( billUserType == 'APPLICANT' ){
	                     								var actualApplicantAccountStatementGrid = $this.getActualapplicantaccountstatementgrid();
	                     								var records = actualApplicantAccountStatementGrid.getSelectionModel().getSelection();
	                     								var applicantId =  records[0].data.studentId;
	                     							}else{
	                     								var actualAccountStatementGrid = $this.getActualaccountstatementgrid();
	                     							var records = actualAccountStatementGrid.getSelectionModel().getSelection();
	                     							var studentId =  records[0].data.studentId;
	                     							}

	                     							/*var studentId = form.down('#student').getValue();
	                     							var applicantId = form.down('#applicant').getValue();*/

	                     							if(!isNullOrEmpty(studentId)){
	                     								var contentpanel = $this.getContentPanel();
	                     								Academia.app.getController('Academia.controller.feeandpayment.reports.FeeReportCommonController');
	                     								var accountstatmentstructure = Ext.widget('studentfeereportfinalstructure');
	                     								var tabName = 'Fee Reports';
	                     								/**
	                     								 * This is to remove tab from content panel and open same tab again 
	                     								 */
	                     								var getcontroller=$this.getController('menu.CoreERPNavigationController');
	                     								var getTab=getcontroller.getTab(tabName);
	                     								if(getTab!=null){
	                     									contentpanel.remove(getTab, true);
	                     								}
	                     								openTab(contentpanel, tabName, accountstatmentstructure, CONSTANTS.MENU_COLOR_FIVE);

	                     								var frm = accountstatmentstructure.down('form');
	                     								var studentfeereportfinalstructure = accountstatmentstructure;
	                     								var feeReportTabStructure = studentfeereportfinalstructure.down('#feeReportTabStructure');
	                     								/* var academyForm = $this.getStudentFeeAndPaymentOrganizationUnit().getForm();
	    		                											   var values = academyForm.getValues();
	    		                											   if(values.multiselectAcademyLocation[0] =="" || values.multiselectAcademyLocation.length==0){
	    		                												   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_ATLEAST_ONE_ACADEMY_LOCATION'));
	    		                												   return;
	    		                											   }*/
	                     								var treeTab = studentfeereportfinalstructure.down('#studentReportTreePanelItemId');
	                     								// var feeReportTabStructure = $this.getFeeReportTabStructure();
	                     								var feeReportTabStructure = studentfeereportfinalstructure.down('#feeReportTabStructure');
	                     								// feeReportTabStructure.removeAll();
	                     								var tabDetail = 'feeheadwisecollectionreportstructure';
	                     								var structure = Ext.widget(tabDetail);

	                     								openTab(feeReportTabStructure, getFeeAndPaymentCommonTranslation('STUDENT_FEE_HEAD_WISE'),
	                     										structure);

	                     								treeTab.toggleCollapse();
	                     								var headWiseForm = $this.getFeeheadwisecollectionreportform();
	                     								var moreFilterOpt = headWiseForm.down('fieldset');
	                     								moreFilterOpt.expand(true);		                												   
	                     								var studentField = headWiseForm.down('#student');
	                     								var studentFieldStore =  studentField.getStore();
	                     								studentFieldStore.getProxy().extraParams = { 
	                     									pageSize: 0,
	                     									limit: 0,};
	                     								

	                     								setTimeout(function(){
	                     									studentFieldStore.load({
		                     									callback: function(records, operation, success) {
		                     										if (success) {
		                     											for(var i in records){
		                     												if(records[i].data.id==studentId){
		                     													studentField.setValue(records[i].data.id);
		                     												}
		                     											}

		                     										}
		                     									}
		                     								});

	                     									var feeheadwisecollectionreportgrid = $this.getFeeheadwisecollectionreportgrid();
	                     									var feeheadwisecollectionreportgridStore =  feeheadwisecollectionreportgrid.getStore();

	                     									var organizationForm=$this.getOrganizationunit().getForm();
	                     									var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation').getValue();
	                     									var ALsId = [];
	                     									for(var i in multiselectAcademyLocation){

	                     										ALsId.push(multiselectAcademyLocation[i]);
	                     									}

	                     									feeheadwisecollectionreportgridStore.getProxy().extraParams = { 
	                     										academyLocationIds: ALsId.join(),
	                     										studentId: studentId,
	                     										onlyStudent: false,
	                     										isSchool: false,
	                     										studentStatus: true,
	                     										screenName: "feeheadwisecollectionreportform"
	                     									};
	                     									feeheadwisecollectionreportgridStore.load();


	                     								},1500);



	                     							} 
	                     							else if(!isNullOrEmpty(applicantId)){

	                     								var contentpanel = $this.getContentPanel();
	                     								Academia.app.getController('Academia.controller.feeandpayment.reports.FeeReportCommonController');
	                     								var accountstatmentstructure = Ext.widget('studentfeereportfinalstructure');
	                     								var tabName = 'Fee Reports';
	                     								/**
	                     								 * This is to remove tab from content panel and open same tab again 
	                     								 */
	                     								var getcontroller=$this.getController('menu.CoreERPNavigationController');
	                     								var getTab=getcontroller.getTab(tabName);
	                     								if(getTab!=null){
	                     									contentpanel.remove(getTab, true);
	                     								}
	                     								openTab(contentpanel, tabName, accountstatmentstructure, CONSTANTS.MENU_COLOR_FIVE);

	                     								var frm = accountstatmentstructure.down('form');
	                     								var studentfeereportfinalstructure = accountstatmentstructure;
	                     								var feeReportTabStructure = studentfeereportfinalstructure.down('#feeReportTabStructure');

	                     								var treeTab = studentfeereportfinalstructure.down('#studentReportTreePanelItemId');
	                     								var feeReportTabStructure = studentfeereportfinalstructure.down('#feeReportTabStructure');
	                     								var tabDetail = 'applicantfeeheadwisecollectionreportstructure';
	                     								var structure = Ext.widget(tabDetail);

	                     								openTab(feeReportTabStructure, getFeeAndPaymentCommonTranslation('APPLIACNT_HEAD_WISE'),
	                     										structure);

	                     								treeTab.toggleCollapse();
	                     								var headWiseForm = $this.getApplicantfeeheadwisecollectionreportform();
	                     								var moreFilterOpt = headWiseForm.down('fieldset');
	                     								moreFilterOpt.expand(true);		                												   
	                     								var studentField = headWiseForm.down('#applicantId');
	                     								var studentFieldStore =  studentField.getStore();
	                     								studentFieldStore.getProxy().extraParams = { 
	                     									pageSize: 0,
	                     									limit: 0,
	                     									applicantId :applicantId};
	                     							
	                     								setTimeout(function(){
	                     									studentFieldStore.load({
		                     									callback: function(records, operation, success) {
		                     										if (success) {
		                     											for(var i in records){
		                     												if(records[i].data.id==applicantId){
		                     													studentField.setValue(records[i].data.id);
		                     												}
		                     											}

		                     										}
		                     									}
		                     								});
	                     									var feeheadwisecollectionreportgrid = $this.getApplicantfeeheadwisecollectionreportgrid();
	                     									var feeheadwisecollectionreportgridStore =  feeheadwisecollectionreportgrid.getStore();
	                     									var organizationForm=$this.getOrganizationunit().getForm();
	                     									var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation').getValue();
	                     									var ALsId = [];
	                     									for(var i in multiselectAcademyLocation){

	                     										ALsId.push(multiselectAcademyLocation[i]);
	                     									}

	                     									feeheadwisecollectionreportgridStore.getProxy().extraParams = { 
	                     										academyLocationIds: ALsId.join(),
	                     										applicantId: applicantId,
	                     										onlyApplicant: false,

	                     									};
	                     									feeheadwisecollectionreportgridStore.load();

	                     								},1500);




	                     							}


	                     						}
	                     					});    
	                     				}
	                     			}
	    						 },
	    						 'addressdetailpanel[itemId=viewaccountaddressdetailpanel] displayfield[itemId=feeheadwisedistributionId]':{
		                     			render: function(component) {
		                     				var $this =this;
		                     				var infoPanel = $this.getViewAccountAddressDetailPanel();
		                     				if(!isNullOrEmpty(infoPanel)) {
		                     					var  detail = getCommonTranslation('FEE_HEADWISE_DISTRIBUTION');
		                     					infoPanel.down('#feeheadwisedistributionId').setValue("<a href='#'>"+detail+"</a>");
		                     					component.getEl().on('click', function(e) {
		                     						if(e.target.tagName=='A'){

		                     							var form =$this.getAccountstatementsearch();
		                     							var transactionType = form.down('#actualTransactionId').getValue();
		                     							var getForm = form.getForm();
		                     							var billUserType = getForm.findField('recieptView').valueModels[0].data.value;
		                     							if( billUserType == 'APPLICANT' ){
		                     								var actualApplicantAccountStatementGrid = $this.getAccountstatementgrid();
		                     								var records = actualApplicantAccountStatementGrid.getSelectionModel().getSelection();
		                     								var applicantId =  records[0].data.id;
		                     							}else{
		                     								var actualAccountStatementGrid = $this.getAccountstatementgrid();
		                     							var records = actualAccountStatementGrid.getSelectionModel().getSelection();
		                     							var studentId =  records[0].data.id;
		                     							}


		                     							/*var studentId = form.down('#student').getValue();
		                     							var applicantId = form.down('#applicant').getValue();*/

		                     							if(!isNullOrEmpty(studentId)){
		                     								var contentpanel = $this.getContentPanel();
		                     								Academia.app.getController('Academia.controller.feeandpayment.reports.FeeReportCommonController');
		                     								var accountstatmentstructure = Ext.widget('studentfeereportfinalstructure');
		                     								var tabName = 'Fee Reports';
		                     								/**
		                     								 * This is to remove tab from content panel and open same tab again 
		                     								 */
		                     								var getcontroller=$this.getController('menu.CoreERPNavigationController');
		                     								var getTab=getcontroller.getTab(tabName);
		                     								if(getTab!=null){
		                     									contentpanel.remove(getTab, true);
		                     								}
		                     								openTab(contentpanel, tabName, accountstatmentstructure, CONSTANTS.MENU_COLOR_FIVE);

		                     								var frm = accountstatmentstructure.down('form');
		                     								var studentfeereportfinalstructure = accountstatmentstructure;
		                     								var feeReportTabStructure = studentfeereportfinalstructure.down('#feeReportTabStructure');
		                     								/* var academyForm = $this.getStudentFeeAndPaymentOrganizationUnit().getForm();
		    		                											   var values = academyForm.getValues();
		    		                											   if(values.multiselectAcademyLocation[0] =="" || values.multiselectAcademyLocation.length==0){
		    		                												   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_ATLEAST_ONE_ACADEMY_LOCATION'));
		    		                												   return;
		    		                											   }*/
		                     								var treeTab = studentfeereportfinalstructure.down('#studentReportTreePanelItemId');
		                     								// var feeReportTabStructure = $this.getFeeReportTabStructure();
		                     								var feeReportTabStructure = studentfeereportfinalstructure.down('#feeReportTabStructure');
		                     								// feeReportTabStructure.removeAll();
		                     								var tabDetail = 'feeheadwisecollectionreportstructure';
		                     								var structure = Ext.widget(tabDetail);

		                     								openTab(feeReportTabStructure, getFeeAndPaymentCommonTranslation('STUDENT_FEE_HEAD_WISE'),
		                     										structure);

		                     								treeTab.toggleCollapse();
		                     								var headWiseForm = $this.getFeeheadwisecollectionreportform();
		                     								var moreFilterOpt = headWiseForm.down('fieldset');
		                     								moreFilterOpt.expand(true);		                												   
		                     								var studentField = headWiseForm.down('#student');
		                     								var studentFieldStore =  studentField.getStore();
		                     								studentFieldStore.getProxy().extraParams = { 
		                     									pageSize: 0,
		                     									limit:0,};
		                     								
		                     								setTimeout(function(){
		                     									studentFieldStore.load({
			                     									callback: function(records, operation, success) {
			                     										if (success) {
			                     											for(var i in records){
			                     												if(records[i].data.id==studentId){
			                     													studentField.setValue(records[i].data.id);
			                     												}
			                     											}

			                     										}
			                     									}
			                     								});

		                     									var feeheadwisecollectionreportgrid = $this.getFeeheadwisecollectionreportgrid();
		                     									var feeheadwisecollectionreportgridStore =  feeheadwisecollectionreportgrid.getStore();

		                     									var organizationForm=$this.getOrganizationunit().getForm();
		                     									var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation').getValue();
		                     									var ALsId = [];
		                     									for(var i in multiselectAcademyLocation){

		                     										ALsId.push(multiselectAcademyLocation[i]);
		                     									}

		                     									feeheadwisecollectionreportgridStore.getProxy().extraParams = { 
		                     										academyLocationIds: ALsId.join(),
		                     										studentId: studentId,
		                     										onlyStudent: false,
		                     										isSchool: false,
		                     										studentStatus: true,
		                     										screenName: "feeheadwisecollectionreportform"
		                     									};
		                     									feeheadwisecollectionreportgridStore.load();


		                     								},1500);



		                     							} 
		                     							else if(!isNullOrEmpty(applicantId)){

		                     								var contentpanel = $this.getContentPanel();
		                     								Academia.app.getController('Academia.controller.feeandpayment.reports.FeeReportCommonController');
		                     								var accountstatmentstructure = Ext.widget('studentfeereportfinalstructure');
		                     								var tabName = 'Fee Reports';
		                     								/**
		                     								 * This is to remove tab from content panel and open same tab again 
		                     								 */
		                     								var getcontroller=$this.getController('menu.CoreERPNavigationController');
		                     								var getTab=getcontroller.getTab(tabName);
		                     								if(getTab!=null){
		                     									contentpanel.remove(getTab, true);
		                     								}
		                     								openTab(contentpanel, tabName, accountstatmentstructure, CONSTANTS.MENU_COLOR_FIVE);

		                     								var frm = accountstatmentstructure.down('form');
		                     								var studentfeereportfinalstructure = accountstatmentstructure;
		                     								var feeReportTabStructure = studentfeereportfinalstructure.down('#feeReportTabStructure');

		                     								var treeTab = studentfeereportfinalstructure.down('#studentReportTreePanelItemId');
		                     								var feeReportTabStructure = studentfeereportfinalstructure.down('#feeReportTabStructure');
		                     								var tabDetail = 'applicantfeeheadwisecollectionreportstructure';
		                     								var structure = Ext.widget(tabDetail);

		                     								openTab(feeReportTabStructure, getFeeAndPaymentCommonTranslation('APPLIACNT_HEAD_WISE'),
		                     										structure);

		                     								treeTab.toggleCollapse();
		                     								var headWiseForm = $this.getApplicantfeeheadwisecollectionreportform();
		                     								var moreFilterOpt = headWiseForm.down('fieldset');
		                     								moreFilterOpt.expand(true);		                												   
		                     								var studentField = headWiseForm.down('#applicantId');
		                     								var studentFieldStore =  studentField.getStore();
		                     								studentFieldStore.getProxy().extraParams = { 
		                     									pageSize: 0,
		                     									limit:0,
		                     									applicantId :applicantId};
		                     								
		                     								setTimeout(function(){
		                     									studentFieldStore.load({
			                     									callback: function(records, operation, success) {
			                     										if (success) {
			                     											for(var i in records){
			                     												if(records[i].data.id==applicantId){
			                     													studentField.setValue(records[i].data.id);
			                     												}
			                     											}

			                     										}
			                     									}
			                     								});
		                     									var feeheadwisecollectionreportgrid = $this.getApplicantfeeheadwisecollectionreportgrid();
		                     									var feeheadwisecollectionreportgridStore =  feeheadwisecollectionreportgrid.getStore();
		                     									var organizationForm=$this.getOrganizationunit().getForm();
		                     									var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation').getValue();
		                     									var ALsId = [];
		                     									for(var i in multiselectAcademyLocation){

		                     										ALsId.push(multiselectAcademyLocation[i]);
		                     									}

		                     									feeheadwisecollectionreportgridStore.getProxy().extraParams = { 
		                     										academyLocationIds: ALsId.join(),
		                     										applicantId: applicantId,
		                     										onlyApplicant: false,

		                     									};
		                     									feeheadwisecollectionreportgridStore.load();

		                     								},1500);




		                     							}


		                     						}
		                     					});    
		                     				}
		                     			}
		    						 },
		    						 'actualaccountstatementgrid button[itemId=exportReportItemId]':{
		    							 click:function(obj){
		    								 var $this =this;
		    								 var reportType =  "Statement of Account";
		    								 Ext.Ajax.request({
		    		                  			 method: "GET",
		    		                  			 type: 'rest',
		    		                  			 url: SERVERURL.TEMPLATE_NAME_BY_CODE,
		    		                  			 params: {
		    		                  				 reportType : reportType
		    		                  			 },
		    		                  			 success: function(f, action) {
		    		                  				 var data = Ext.decode(f.responseText);
		    		                  				var grid =  $this.getActualaccountstatementgrid();
   		                  						 var records = grid.getSelectionModel().getSelection();
   		                  						 if(!isNullOrEmpty(records) && records.length > 0) {
   		                  						if(!isNullOrEmpty(data)){
	    		                  					 if(data.length == 0){
	    		                  						showWarningMessage(getServiceRequestTranslation('ALERT'),'No Report is Mapped');
	    		                  					 }else if(data.length > 1){
	    		                  						 
	    		                  							 var statementOfAccountReportWin = $this.getStatementofaccountreportwin();
	    		                  							 if (!statementOfAccountReportWin) {
	    		                  								 Ext.widget('statementofaccountreportwin');
	    		                  								 statementOfAccountReportWin = $this.getStatementofaccountreportwin();
	    		                  							 }
	    		                  							 statementOfAccountReportWin.show();
	    		                  							$this.disableDownloadAllPivileges(statementOfAccountReportWin,$this.getPC_STUDENT_STATEMENT_OF_ACCOUNT_PERMISSIONS());
	    		                  							var store = statementOfAccountReportWin.down('#statementOfAccountReportTypeId').getStore();
	    		                  							store.getProxy().extraParams = {
	    		                  								reportType : 'Statement of Account'
	    		                  		       		    	};
	    		                  							store.load();
	    		                  						 
	    		                  					 }
	    		                  					  else{
	    		                  						  if(data[0].value == 'DETAILED_STATEMENT_OF_ACCOUNT_DIT'){
	    		                  							code = 'DETAILED_STATEMENT_OF_ACCOUNT_DIT';
	    			    									 $this.downloadDetailedStatementOfAccountReport(code);
	    		                  						  }
	    		                  						  else{
	    		                  							code = 'STATEMENT_OF_ACCOUNT_DIT';
	    		                  							$this.downloadStudentStatementOfAccountReport(code);
	    		                  						  }
	    		                  						 
	    		                  						  }
	    		                  				 }
   		                  						 }
   		                  					else {
	                  							 showWarningMessage(getServiceRequestTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	                  						 }
		    		                  				 
		    		                  			 }
		    		                  			 });
		    								 
	    								 }
		    						 },
		    						 'statementofaccountreportwin button[itemId=downloadStatementOfAccountReport]':{
		    							 click:function(obj){
		    								 var statementOfAccountReportWin = this.getStatementofaccountreportwin();
		    								 var reportType = statementOfAccountReportWin.down('#statementOfAccountReportTypeId');
		    								 var code;
		    								 if(reportType.getDisplayValue()=='Student Statement Of Account DIT'){
		    									 code = 'STATEMENT_OF_ACCOUNT_DIT';
		    									 this.downloadStudentStatementOfAccountReport(code);
		    								 }else{
		    									 code = 'DETAILED_STATEMENT_OF_ACCOUNT_DIT';
		    									 this.downloadDetailedStatementOfAccountReport(code);
		    								 }
		    							 } 
		    						 },
		    						 'statementofaccountreportwin  combo[itemId=statementOfAccountReportTypeId]': {
		    				                select: function(obj) {   
		    				                	var me =this;
			    								 var statementOfAccountReportWin = me.getStatementofaccountreportwin();
		    				                	 if(obj.getDisplayValue()=='Detailed statement of account DIT'){
			    									 statementOfAccountReportWin.down('#downloadDetailAllStatementOfAccountReport').setDisabled(false);
			    								 }else if(obj.getDisplayValue()=='Student Statement Of Account DIT'){
			    									 setTimeout(function(){
			    										 statementOfAccountReportWin.down('#downloadDetailAllStatementOfAccountReport').setDisabled(true);
			                                         },100);
			    								 }
		    				                }
		    				           },
		    				            'statementofaccountreportwin button[itemId=downloadDetailAllStatementOfAccountReport]':{
			    							 click:function(obj){
			    								 var statementOfAccountReportWin = this.getStatementofaccountreportwin();
			    								 var reportType = statementOfAccountReportWin.down('#statementOfAccountReportTypeId');
			    								 var code;
			    								 if(reportType.getDisplayValue()=='Detailed statement of account DIT'){
			    									 code = 'DETAILED_STATEMENT_OF_ACCOUNT_DIT';
			    									 this.bulkDownloadDetailedStatementOfAccountReport(code);
			    								 }
			    							 } 
			    						 },
			    						 'addressdetailpanel[itemId=viewactualaccountaddressdetailpanel]':{
											 render:function(flyOut){
												this.doAccessControlValidationForFlyOut(flyOut, this.getPC_STUDENT_STATEMENT_OF_ACCOUNT_PERMISSIONS());
											 }
										 },
										 'viewactualaccountstatementgrid button[itemId=btnCancel]': { 
												click:function(btn){
													var me = this
													var viewActualAccountGrid = me.getViewactualaccountstatementgrid()
													var selectedRow = viewActualAccountGrid.getSelectionModel().getSelection() 
													if(selectedRow.length==1){
															if(selectedRow[0].data.receiptStatus === "CANCELLED" || 
															   selectedRow[0].data.billStatus === "CANCELLED" || 
																	selectedRow[0].data.paymentStatus === "CANCELLED"){	
															showWarningMessage(getCommonTranslation('ALERT'), getFeeAndPaymentCommonTranslation('RECORD_IS_ALREADY_CANCELLED'));
														}
														else if(selectedRow[0].data.category === 'PAYMENT'){
															this.saveStatementTransactionReason(btn);
														}
														else{
															Ext.widget('accountStatementWindow').show();	
														}
													}
													else{
														showWarningMessage(getCommonTranslation('ALERT'), getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
													}
													}            
									            },
									            'accountStatementWindow button[itemId=btnSaveCancel]': {
									            	click:function(btn){
									    				this.saveStatementTransactionReason(btn)
									    				}   
									            },
									        /*    'viewactualaccountstatementgrid': {
									            	selectionchange: function(column, selected,eOpts ){ 
									            		var viewActualAccountGrid = this.getViewactualaccountstatementgrid()
														if(selected.length == 1){
															if(selected[0].data.transactionDate === null ||
																	selected[0].data.transactionNo === null ||
																	selected[0].data.transactionType === null){
									                    		viewActualAccountGrid.down('#btnCancel').setDisabled(true)
									                    		}else{
									                    			viewActualAccountGrid.down('#btnCancel').setDisabled(false);
									                        }							            			
															}
									            	}
									            },*/
									            
	                 		 });
	                   },
	                   saveStatementTransactionReason: function(form){ 
	                	var $this = this;
	               		var grid = $this.getViewactualaccountstatementgrid();
	               		var windowPanel = $this.getAccountStatementWindow()
	               		var selectedRow = grid.getSelectionModel().getSelection()[0].data
	               		var cancellationReasonForm;
	               		var cancellationReasonVal;
	               		if(windowPanel){
	               			 cancellationReasonForm = windowPanel.down('form');
	               			 cancellationReasonVal = cancellationReasonForm.down('#reasonToCancelItemId').getValue()
	               		}	               		
	               		var reasonMsg = cancellationReasonVal?cancellationReasonVal:null;
	               		var submitUrl = SERVERURL.PATH_FIND_CANCEL_STATMENT_OF_ACCOUNT_TRANSACTION;	               		
	               		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');	
	               		
	               		var dataPayload =  {
                            	id: Number(selectedRow.txnNo),
                            	cancellationNarration: reasonMsg,
                            	transactionType: selectedRow.category
                            }
	               		var data = Ext.encode(dataPayload);
	               		Ext.Ajax.request({
	               			url: submitUrl,
	               			method: "POST",
                            type: 'rest',
                             
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            jsonData: data,
                            success:function(form, action){
                                Ext.getBody().unmask(); 
                                grid.getStore().load();
                                grid.getSelectionModel().deselectAll();
                                if(windowPanel){                                        	
                                	windowPanel.close();
                                }
                                showSuccessMessage(getCommonTranslation('SUCCESS'), getFeeAndPaymentCommonTranslation('TRANSACTION_CANCELLED_SUCCESSFULLY'));
                            }
                        }); 
	                   },
	                   getActualStatementGridByUserType: function(form) {
	                	   var billedUserType = form.findField('recieptView').valueModels[0].data.value;
	                	   
	                	   var actualAccountStatementGrid = this.getActualaccountstatementgrid();
        				   var actualApplicantAccountStatementGrid = this.getActualapplicantaccountstatementgrid();
        				   var actualSponsorAccountStatementGrid = this.getActualsponsoraccountstatementgrid();
        				   
        				   var grid;
	                	   
	                	   if( billedUserType == 'STUDENT' ){	   
	                		   grid = actualAccountStatementGrid;
        				   }
        				   else if( billedUserType == 'APPLICANT' ){
        					   grid = actualApplicantAccountStatementGrid;
        				   }
        				   else if( billedUserType == 'SPONSOR' ) {
        					   grid = actualSponsorAccountStatementGrid;
        				   }
	                	   
	                	   return grid;
	                	   
	                   },
	                   showHideActualStatementGrid: function(form) {
	                	   var billedUserType = form.findField('recieptView').valueModels[0].data.value;
	                	   
	                	   var actualAccountStatementGrid = this.getActualaccountstatementgrid();
        				   var actualApplicantAccountStatementGrid = this.getActualapplicantaccountstatementgrid();
        				   var actualSponsorAccountStatementGrid = this.getActualsponsoraccountstatementgrid();
        				   
        				   var grid;
	                	   
	                	   if( billedUserType == 'STUDENT' ){	   
	                		   grid = actualAccountStatementGrid;
	                		   
	                		   actualAccountStatementGrid.setVisible(true);
        					   actualApplicantAccountStatementGrid.setVisible(false);
        					   actualSponsorAccountStatementGrid.setVisible(false);
        				   }
        				   else if( billedUserType == 'APPLICANT' ){
        					   grid = actualApplicantAccountStatementGrid;
        					   
        					   actualAccountStatementGrid.setVisible(false);
        					   actualApplicantAccountStatementGrid.setVisible(true);
        					   actualSponsorAccountStatementGrid.setVisible(false);
        				   }
        				   else if( billedUserType == 'SPONSOR' ) {
        					   grid = actualSponsorAccountStatementGrid;
        					   
        					   actualAccountStatementGrid.setVisible(false);
        					   actualApplicantAccountStatementGrid.setVisible(false);
        					   actualSponsorAccountStatementGrid.setVisible(true);
        				   }
	                	   
	                	   return grid;
	                	   
	                   },
	                   getSearchGridColumns: function(columnNames, columnDataIndexes) {
	                       var columns = new Array();
	                       for (var count = 0; count < columnNames.length && count < columnDataIndexes.length; count++) {
	                           
	                    	   var colIndexArr = columnDataIndexes[count].split("#");
	                    	   
	                    	   var colIndex = colIndexArr[0];
	                    	   var showHide = colIndexArr[1];
	                    	   
	                    	   var columnObj = {
		                               header: columnNames[count],
		                               dataIndex: colIndex,
		                               flex: 1
		                           };
	                    	   
	                    	   if( showHide == 'hide' ){
	                    		   columnObj.hidden = true;
	                    	   }
	                    	   
	                    	   if( colIndex == 'feeAmount' || colIndex == 'amountPending' ){
	                    		   columnObj.renderer = function(value,meta,record){
	                    				if(!isNullOrEmpty(value)) {
	                    					return currencyRenderer(value,record.get("currencyId"));
	                    				}                        
	                    			};
	                    	   }
	                    	   
	                    	   columns.push(columnObj);
	                       }
	                       return columns;
	                   },
	                   loadCreateSeqGrid:function(){
	                	   var $this=this;
	                	   var frm = this.getAccountstatementsearch();
	                	   frm.down('#searchBtn').setDisabled(true);
	                	   var form = frm.getForm();
	                	   var grid = this.getAccountstatementgrid();
	                	   var values = form.getValues();
	                	   var programCategoryId = values.programCategory;
	                	   var programGroupId = values.programGroup;
	                	   var programId = values.programName;
	                	   var batchId = values.batchName;
	                	   var seatTypeId = values.seatType;
	                	   var startDate = values.startDate;
	                	   var tillDate = values.tillDate;
	                	   var showAllStudents = values.showAllStudents;
                           //var whetherCancelledTransaction = values.includeAllCancelledTransaction;
	                	   var billedUserType=null;
	                	   var billedUserTypeEnumValue = form.findField('recieptView').getRawValue();   
                    	   var billedUserType = form.findField('recieptView').store.findRecord('value', billedUserTypeEnumValue).data.displayValue;
	                	   var message=null;
	                	   var screenName = "StatementOfAccount";
	                	   var id;
	                	   if(!isNullOrEmpty(values.student)){
	                		   id = values.student;
	                	   }else if(!isNullOrEmpty(values.sponsors)){
	                		   id = values.sponsors;
	                	   }else if(!isNullOrEmpty(values.applicant)){
	                		   id = values.applicant;
	                	   }
	                	  
	                	   
	                	   var academyLocationId = $this.getALIdsFromDropdown($this);
	                	   var alField =frm.down('#academyLocationId');
        				   var multiselectAcademyLocation=alField.getValue();
							var ALsId = [];
							for(var i in multiselectAcademyLocation){
								if(!isNullOrEmpty(multiselectAcademyLocation[i]) && typeof multiselectAcademyLocation[i]=='object'){
									ALsId.push(multiselectAcademyLocation[i].data.id);
								}else{
									ALsId.push(multiselectAcademyLocation[i]);
								}

							}
                		   var statusField = form.findField('STATUS');
                		   if(statusField.getValue()==null){
                   		   	statusField.setValue(true);
                   		   }
        				   var transactionTypeRadio = form.findField('transactionTypeName');
        				   var accountStatementGrid = this.getAccountstatementgrid();
        				   var actualAccountStatementGrid = this.showHideActualStatementGrid(form);
        				   
        				   if(transactionTypeRadio.getValue().transactionType=="ACTUAL_TRANSACTION"){
        					   actualAccountStatementGrid.setVisible(true);
        					   accountStatementGrid.setVisible(false);
        					   grid = actualAccountStatementGrid;
        				       
        				   } else if(transactionTypeRadio.getValue().transactionType=="VOUCHER_BASED_TRANSACTION"){
        					   actualAccountStatementGrid.setVisible(false);
        					   accountStatementGrid.setVisible(true);
        					   grid = accountStatementGrid;
        				   }
        				   
        				   var store = grid.getStore();
        				   grid.config.searchFilterForm = frm;                		    
        				   $this.resetPageSetting(store);
                		   store.getProxy().extraParams = {	
                			   id:id,
                			   statementFrom:startDate,
                			   statementTo:tillDate,
                			   programId:programId,
                			   batchId:batchId,
                			   billedUserType:billedUserType,
                			   status: statusField.getValue(),
                			   screenName: screenName,
                			   programCategoryId:programCategoryId,
                			   programGroupId:programGroupId,
                			   seatTypeId:seatTypeId,
                			  // academyLocationIds: ALsId.join(),
                			   academyLocationIds:academyLocationId,
                			   whetherShowAllStudents : showAllStudents,
                              // whetherCancelledTransaction :whetherCancelledTransaction?whetherCancelledTransaction:false
                               
                              
                		   };
                		   
                		   store.load({
                			   callback: function(records, operation, success) {
                				   frm.down('#searchBtn').setDisabled(false);
                				   if (success) {
                					   if(operation.params.billedUserType=="STUDENT")
                					   {
                						   var grid = $this.getActualaccountstatementgrid();
                					   }else if(operation.params.billedUserType=="APPLICANT")
                					   {
                						   var grid = $this.getActualapplicantaccountstatementgrid();
                					   }else if(operation.params.billedUserType=="SPONSOR")
                					   {
                						   var grid = $this.getActualsponsoraccountstatementgrid();
                					   }
                					   if(grid.getStore().getAt(0)!=null)
                					{
                					   var records = grid.getStore().getAt(0).data;
                					   var columns = grid.columns;
                					   if(records.baseCurrencyId!=null)
                					   {
                						   for(var i in columns) {
                							   if (columns[i].dataIndex == "debitAmount" || columns[i].dataIndex == "creditAmount" || columns[i].dataIndex == "balanceAmount") {
                								   columns[i].hide();
                							   }
                							   if(columns[i].dataIndex == "baseCurrencyBalanceAmount" || columns[i].dataIndex == "baseCurrencyDebitAmount" || columns[i].dataIndex == "baseCurrencyCreditAmount"){
                								   columns[i].show();
                							   }
                						   }
                					   }/*else
                					   {
                						   for(var i in columns) {
                							   if (columns[i].dataIndex == "debitAmount" || columns[i].dataIndex == "creditAmount" || columns[i].dataIndex == "balanceAmount") {
                								   columns[i].show();
                							   }
                							   if(columns[i].dataIndex == "baseCurrencyBalanceAmount" || columns[i].dataIndex == "baseCurrencyDebitAmount" || columns[i].dataIndex == "baseCurrencyCreditAmount"){
                								   columns[i].hide();
                							   }
                						   }
                					   }*/
                				   }
                				   }
                			   }
                		   });
	                   },    
	                   getALIdsFromDropdown : function($this){
							var academyLocationDropDown = $this.getAccountstatementsearch().down("#academyLocationId");
							var records = academyLocationDropDown.getValue();
							
							if(academyLocationDropDown.hidden!=true){
		             		   var alids=[];
		                 	   if(!isEmpty(academyLocationDropDown.getDisplayValue()) &&  records.length>0){
		                 		   for (var i in records) {
		                 			   if(Ext.isObject(records[i])){
		                 				   alids.push(records[i].get('id'));
		                 			   }
		                 			   else{
		                 				   alids.push(records[i]);	
		                 			   }
		                 		   }
		                 	   }else{
		                 		   alids = $this.getCurrentAcademyLocation();
		                 	   }  
		             	   }else{
		             		   alids = $this.getCurrentAcademyLocation(); 
		             	   }
		             	   if(isArray(alids)){
		             		   alidsValue =  alids.join(); 
		             	   }else{
		             		   alidsValue = alids;
		             	   }

							return alidsValue;
						},
	                   viewStatement:function(){
	                	   var $this = this;
	                	   var contentpanel = $this.getContentPanel();
	                	   var contentXtype ='viewaccountstatmentstructure';
	                	   var tabName = getFeeAndPaymentCommonTranslation('STATEMENT_OF_ACCOUNT');
	                	   var newTab = this.getTabReferenceByTabTitle(tabName);
	                	   var getcontroller=$this.getController('menu.CoreERPNavigationController');
	                	   var getTab=getcontroller.getTab(tabName);
	                	   if(getTab!=null){
	                		   contentpanel.remove(getTab, true);
	                		   newTab = contentPanel.add({
	                			   xtype: contentXtype,
	                			   closable: true,
	                			   title: tabName,
	                			   menuColorCls: CONSTANTS.MENU_COLOR_FIVE
	                		   });
	                	   } else if(!newTab){
	                		   newTab = contentPanel.add({
	                			   xtype: contentXtype,
	                			   closable: true,
	                			   title: tabName,
	                			   menuColorCls: CONSTANTS.MENU_COLOR_FIVE
	                		   });
	                	   }
	                	   contentpanel.setActiveTab(newTab);
	                   },
	                   viewAccountStatment:function(){
	                	  var $this = this;
	                	   var grid = this.getAccountstatementgrid();
	                	   if (grid.getSelectionModel().getCount() > 0) {
	                		   this.viewStatement();
	                		   var outerForm = this.getAccountstatementsearch().getForm();
	                		   var records = grid.getSelectionModel().getSelection();
	                		   if (records != undefined && records != ""
	                			   && records != null) {
	                			   var id = records[0].data.id;
	                			   var name = records[0].data.name;
	                			   var programName = records[0].data.programName;
	                			   var batchName = records[0].data.batchName;
	                			   var startDate = outerForm.findField('startDate').getValue();
	                			   var tillDate = outerForm.findField('tillDate').getValue();        	   
	                			   var programId = outerForm.findField('programName').getValue();
	                			   var batchId = outerForm.findField('batchName').getValue();
	                			   //var billedUserType = outerForm.findField('recieptView').getRawValue();
	                			   var billedUserType = outerForm.findField('recieptView').valueModels[0].data.value;
	                			   if(startDate != null){
	                				   startDate= new Date(startDate);
	                				   startDate = Ext.Date.format(startDate, 'Y-m-d');
	                	                  }
	                	            
	                	            if(tillDate != null){
	                	            	tillDate= new Date(tillDate);
	                	            	tillDate = Ext.Date.format(tillDate, 'Y-m-d');
	                	                  }
	                			  
	                			   if(billedUserType=='STUDENT'){
	                				   this.setAddressForStudent(id,"VOUCHER_TRANSCTION",null);
	                			   }else if(billedUserType=='APPLICANT'){
	                				    this.setAddressForApplicant(id,"VOUCHER_TRANSCTION");
	                			   }else if(billedUserType=='SPONSOR'){
	                				   this.setAddressForSponsors(id,"VOUCHER_TRANSCTION");
	                			   }
	                			  
	                			   var viewgrid = this.getViewaccountstatementgrid();
	                			   var viewstore = viewgrid.getStore();
	                			   $this.setTitleWithDate(startDate,tillDate,viewgrid);
	                			   
	                			   viewstore.getProxy().extraParams = {	
	                				   id:id,
	                				   statementFrom:startDate,
	                				   statementTo:tillDate,
	                				   programId:programId,
	                				   batchId:batchId,
	                				   billedUserType:billedUserType
	                			   };
	                			   viewstore.gridView = viewgrid
	                			   viewstore.load({
	    								 callback: function(record, operation, success) {
	    									 if (record.length > 0) {
	    	 									$this.toggleGridSummaryRow(viewgrid,true);
	    	 								 }else{
	    	 									$this.toggleGridSummaryRow(viewgrid,false);
	    	 								 }
	    	 							 }
	    							});
	                		   }
	                	   }else{
	                		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                	   }
	                   },
	                   viewActualStatement:function(){
	                	   var $this = this;
	                	   var contentpanel = $this.getContentPanel();
	                	   var contentXtype ='viewactualaccountstatementstructure';
	                	   //var tabName = getFeeAndPaymentCommonTranslation('STATEMENT_OF_ACCOUNT');
	                	   var tabName = getFeeAndPaymentCommonTranslation('Account Statement');
	                	   var newTab = this.getTabReferenceByTabTitle(tabName);
	                	   var getcontroller=$this.getController('menu.CoreERPNavigationController');
	                	   var getTab=getcontroller.getTab(tabName);
	                	   if(getTab!=null){
	                		   contentpanel.remove(getTab, true);
	                		   newTab = contentPanel.add({
	                			   xtype: contentXtype,
	                			   closable: true,
	                			   title: tabName,
	                			   menuColorCls: CONSTANTS.MENU_COLOR_FIVE
	                		   });
	                	   } else if(!newTab){
	                		   newTab = contentPanel.add({
	                			   xtype: contentXtype,
	                			   closable: true,
	                			   title: tabName,
	                			   menuColorCls: CONSTANTS.MENU_COLOR_FIVE
	                		   });
	                	   }
	                	   contentpanel.setActiveTab(newTab);
	                   },
	                   viewActualAccountStatment:function(form){
	                	  var $this = this;
	                	   var grid = this.showHideActualStatementGrid(form);
	                	   if (grid.getSelectionModel().getCount() > 0) {
	                		   var record = grid.selModel.getSelection();
	                  		 if(record.length == 1){
	                  			 this.viewActualStatement();
		                		   var outerForm = this.getAccountstatementsearch().getForm();	                		   
		                		   var academyLocation = outerForm.findField('academyLocation');
		                		   
		                		   var multiselectAcademyLocation=academyLocation.getValue();
									var ALsId = [];
									for(var i in multiselectAcademyLocation){
										if(!isNullOrEmpty(multiselectAcademyLocation[i])&& typeof multiselectAcademyLocation[i]=='object'){
											ALsId.push(multiselectAcademyLocation[i].data.id);
										}else{
											ALsId.push(multiselectAcademyLocation[i]);

										}

									} 
									
		                		   $this.records = grid.getSelectionModel().getSelection();
		                		   if ($this.records != undefined && $this.records != ""
		                			   && $this.records != null) {
		                			   var id = $this.records[0].data.studentId;
		                			   var personId = $this.records[0].data.personId;
		                			   var name = $this.records[0].data.name;
		                			   var programName = $this.records[0].data.programName;
		                			   var batchName = $this.records[0].data.batchName;
		                			   var startDate = outerForm.getValues().startDate;
		                			   var tillDate = outerForm.getValues().tillDate;        	   
		                			   
		                			   var programId = $this.records[0].data.programId;
		                			   var batchId = $this.records[0].data.batchId;
		                			   var programCategoryId = $this.records[0].data.programCategoryId;
		                			   var programGroupId = $this.records[0].data.programGroupId;
		                			   var seatTypeId = $this.records[0].data.seatTypeId;
		                			   var status = $this.records[0].data.studentStatus;
		                			   var showAllStudents = outerForm.findField('showAllStudents').getValue();
		                			   
		                			   var billedUserType = outerForm.findField('recieptView').getValue();
		                			   
		                			   var billedUserTypeEnumValue = outerForm.findField('recieptView').getRawValue();   
		                        	   var billedUserTypeValue = outerForm.findField('recieptView').store.findRecord('value', billedUserTypeEnumValue).data.displayValue;
		                			  
		                			   var grid = this.getViewactualaccountstatementgrid();
		                			   
		                			   var Viewactualaccountstatementgrid = this.getViewactualaccountstatementgrid();
		                			   var Viewactualapplicantaccountstatementgrid = this.getViewactualapplicantaccountstatementgrid();
		                			   var Viewactualsponsoraccountstatementgrid = this.getViewactualsponsoraccountstatementgrid();
		                			   
		                			   if(billedUserType==1){
		                				   this.setAddressForStudent(id,"ACTUAL_TRANSACTION",personId);
		                				   this.setProgramBatchToFlyOut(id,"ACTUAL_TRANSACTION",programId, batchId);
		                				   grid = Viewactualaccountstatementgrid;
		                				   Viewactualaccountstatementgrid.setVisible(true);
		                				   Viewactualapplicantaccountstatementgrid.setVisible(false);
		                				   Viewactualsponsoraccountstatementgrid.setVisible(false);
		                				   
		                			   }else if(billedUserType==2){
		                				   this.setAddressForApplicant(id,"ACTUAL_TRANSACTION");
		                				   this.setProgramBatchToFlyOut(id,"ACTUAL_TRANSACTION",programId, batchId);
		                				   grid = Viewactualapplicantaccountstatementgrid;
		                				   Viewactualaccountstatementgrid.setVisible(false);
		                				   Viewactualapplicantaccountstatementgrid.setVisible(true);
		                				   Viewactualsponsoraccountstatementgrid.setVisible(false);
		                			   }else if(billedUserType==3){
		                				   this.setAddressForSponsors(id,"ACTUAL_TRANSACTION");
		                				   grid = Viewactualsponsoraccountstatementgrid;
		                				   Viewactualaccountstatementgrid.setVisible(false);
		                				   Viewactualapplicantaccountstatementgrid.setVisible(false);
		                				   Viewactualsponsoraccountstatementgrid.setVisible(true);
		                			   }
		                			   
		                			   var viewstore = grid.getStore();
	            					   
	                				   $this.resetPageSetting(viewstore);
	                				   
	                				   viewstore.getProxy().extraParams = {	
		                				   id:id,
		                				   statementFrom:startDate,
		                				   statementTo:tillDate,
		                				   programId:programId,
		                				   batchId:batchId,
		                				   billedUserType:billedUserTypeValue,
		                				   programCategoryId:programCategoryId,
		                				   programGroupId:programGroupId,
		                				   seatTypeId:seatTypeId,
		                				   status:status,
		                				   screenName:'StatementOfAccount',
		                				   academyLocationIds: ALsId.join(),
		                				   whetherShowAllStudents : showAllStudents
		                			   }
	                				   
	                				   $this.setTitleWithDate(startDate,tillDate,grid);
		                			   viewstore.load({
		    								 callback: function(record, operation, success) {
		                					   if (success) {
		                						   if(operation.params.billedUserType=="STUDENT")
		                    					   {
		                    						   var grid = $this.getViewactualaccountstatementgrid();
		                    					   }else if(operation.params.billedUserType=="APPLICANT")
		                    					   {
		                    						   var grid = $this.getViewactualapplicantaccountstatementgrid();
		                    					   }else if(operation.params.billedUserType=="SPONSOR")
		                    					   {
		                    						   var grid = $this.getViewactualsponsoraccountstatementgrid();
		                    					   }
		                						   var records = grid.getStore().getAt(0).data;
                                                   $this.studentRecord = records;
		                						   var columns = grid.columns;
		                						   if(records.baseCurrencyId!=null)
		                						   {
		                							   for(var i in columns) {
		                								   if (columns[i].dataIndex == "balanceAmount") {
		                									   columns[i].hide();
		                								   }
		                								   if(columns[i].dataIndex == "baseCurrencyDebitAmount" || columns[i].dataIndex == "baseCurrencyCreditAmount" ||
		                									  columns[i].dataIndex == "baseCurrencyBalanceAmount" || columns[i].dataIndex == "currencyExchangeRate") {
		                									   columns[i].show();
		                								   }
		                							   }
		                						   }else
		                						   {
		                							   for(var i in columns) {
		                								   if (columns[i].dataIndex == "balanceAmount") {
		                									   columns[i].show();
		                								   }
		                								   if(columns[i].dataIndex == "baseCurrencyDebitAmount" || columns[i].dataIndex == "baseCurrencyCreditAmount" ||
		                									  columns[i].dataIndex == "baseCurrencyBalanceAmount" || columns[i].dataIndex == "currencyExchangeRate") {
		                									   columns[i].hide();
		                								   }
		                							   }
		                						   }
		                					   }
		                					   if(record!=null)
		                					   {
		                						   if (record.length > 0) {
		                							   $this.toggleGridSummaryRow(grid,true);
		                						   }else{
		                							   $this.toggleGridSummaryRow(grid,false);
		                						   }
		                					   }
		    	 							 }
		    							});
		                		   }
	                  		 }else{
	                  			showWarningMessage(getCommonTranslation('ALERT'), getFeeAndPaymentCommonTranslation('PLEASE_SELECT_ONE_RECORD'));
	                  		 }
	                	   }else{
	                		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                	   }
	                   },
	                   exportJRXML: function(fileType,grid) {
	                	   var viewGrid=this.getViewaccountstatementgrid();
	                	   
	                	   var outerForm = this.getAccountstatementsearch().getForm();
	                	   var startDate = outerForm.findField('startDate').getValue();
	                	   var tillDate = outerForm.findField('tillDate').getValue();     	   
	                	   var programId = outerForm.findField('programName').getValue();
	                	   var batchId = outerForm.findField('batchName').getValue();
                	       var billedUserType = outerForm.findField('recieptView').getRawValue();
                	       
	                	   var selectedId = 0;
	                	   selectedId = grid.getStore().data.items[0].data.id;
	                	   user=this.getCurrentlyLoggedInUser();
	                	   // code to identify jasper
	                	   var code ="STATEMENT_OF_ACCOUNT_REPORT";
	                	   var reportParams =new Object();
	                	   reportParams.userId=user.code;
	                	   reportParams.ids=String(selectedId); // convert int into string
	                	   reportParams.billedUserType=billedUserType;
	                	   reportParams.programId=programId;
	                	   reportParams.batchId=batchId;
	                	   reportParams.statementFrom=Ext.Date.format(new Date(startDate),CONSTANTS.SUBMIT_DATE_FORMAT);
	    	               reportParams.statementTo=Ext.Date.format(new Date(tillDate),CONSTANTS.SUBMIT_DATE_FORMAT);
	                	   var reportTitle=getFeeAndPaymentCommonTranslation('ACCOUNT_STATEMENT');
	                	   var exportUrl = SERVERURL.ACCOUNT_STATEMENT_PDF;
	                	   this.exportJRXMLReport(code,reportParams,reportTitle,fileType,exportUrl);
	                	  
	                   },
	                   
	                   setProgramBatchToFlyOut : function(studentId, transactionType, programId, batchId){
	                	   if( transactionType == "ACTUAL_TRANSACTION" ){
	                		   form = this.getViewActualAccountAddressDetailPanel();
	                		   if(!isNullOrEmpty(form)){
	                			   form.down("#programIdHidden").setValue(programId);
	                			   form.down("#batchIdHidden").setValue(batchId);
	                		   }
		                   }
	                   },
	                   
	                 //****** set Address For Student*************
	                   setAddressForStudent : function(studentId, transactionType,personId){
	                	 var $this = this;
	                  	 var form = this.getViewAccountAddressDetailPanel();
	                  	 
	                   	 if( transactionType == "VOUCHER_TRANSCTION" ){
	                		 form = this.getViewAccountAddressDetailPanel();
	                	 } else if( transactionType == "ACTUAL_TRANSACTION" ){
	                		 form = this.getViewActualAccountAddressDetailPanel();
	                	 } 
	                  	 
	                  	 if (form.collapsed) {
	                  		 form.expand();
	                  	 }
	                  	 form.down("#profile_image").setVisible(true);
	                  	 
	                  	 if(personId == null)
	                  	 {
	                  	   personId = studentId;
	                  	 }

	                  	 if(!isNullOrEmpty(studentId)){
	                  		 Ext.Ajax.request({
	                  			 type: 'rest',
	                  			 binary: true,
	                  			 url: SERVERURL.PERSON_IMAGE_DOWNLOAD +'?personId='+personId,
	                  			 method: 'GET',
	                  			 success : function(response){
	                  				 if(response.responseBytes.length>0){
	                  					 var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
	                  					 var url = window.URL.createObjectURL(blob);
	                  					 var image = form.down("#profile_image");
//	                  					 image.setVisible(true);
	                  					 image.getEl().dom.src=url;
	                  				 }
	                  			 }

	                  		 });

	                  		 Ext.Ajax.request({
		                   
	                  			 method: "GET",
	                  			 type: 'rest',
	                  			 url: SERVERURL.PAYMENT_STUDENT_FO_FLYOUT_INFO,
	                  			 params: {
	                  				 studentId: studentId
	                  			 },
	                  			 success: function(f, action) {
	                  				var responseData = Ext.JSON.decode(f.responseText);
                                    $this.studentData = responseData

	                  				 form.down("#departmentName").setVisible(false),
	                  				 form.down("#whetherFaculty").setVisible(false),
	                  				 form.down("#whetherInternal").setVisible(false),
	                  				 form.down("#sponsorType").setVisible(false);
	                  				 form.down("#sponsorCode").setVisible(false);
	                  				 form.down("#noOfSponsoredStudents").setVisible(false);

	                  				 form.down("#addmissionId").setVisible(true);
	                  				 form.down("#applicationId").setVisible(true);
	                  				 form.down("#program").setVisible(true);
	                  				 form.down("#batch").setVisible(true);
	                  				 form.down("#period").setVisible(true);
	                  				 form.down("#section").setVisible(true);
	                  				 form.down("#seatType").setVisible(true);
	                  				 form.down("#userId").setVisible(true);
	                  				 form.down("#feeheadwisedistributionId").setVisible(true);

	                  				 form.down("#name").setValue(responseData.studentName);
	                  				 form.down("#address").setValue(responseData.addressText);
	                  				 form.down("#emailId").setValue(responseData.primaryeEmailId);
	                  				 form.down("#contactNo").setValue(responseData.cellNo);
	                  				 form.down("#addmissionId").setValue(responseData.admissionID);
	                  				 form.down("#applicationId").setValue(responseData.applicationID);
	                  				 form.down("#userId").setValue(responseData.studentCode);
	                  				 form.down("#program").setValue(responseData.programName);
	                  				 form.down("#batch").setValue(responseData.batch);
	                  				 form.down("#period").setValue(responseData.period);
	                  				 form.down("#section").setValue(responseData.sectionCode);
	                  				 form.down("#seatType").setValue(responseData.seatType);

	                  				form.down("#totalBalance").setValue(responseData.totalBalance);	
	                  				form.down("#totalAcadInvoiceAmount").setValue(responseData.totalAcadInvoiceAmount);
	                  				form.down("#totalAcadReceiptAmount").setValue(responseData.totalAcadReceiptAmount);
	                  				form.down("#totalConvertedOutstanding").setValue(responseData.totalConvertedOutstanding);
	                  				form.down("#totalAcadPaymentAmount").setValue(responseData.totalAcadPaymentAmount);
	                  				form.down("#totalAcadDicountAmount").setValue(responseData.totalAcadDicountAmount);
	                  				form.down("#totalAcadLocAdvanceAmount").setValue(responseData.totalAcadLocAdvanceAmount);

	                  			 }
	                  		 });
	                  	 }
	                   },
	                   setAddressForSponsors:function(sponsorId, transactionType){
	                  	 var form = this.getViewAccountAddressDetailPanel();
	                  	 
	                  	 if( transactionType == "VOUCHER_TRANSCTION" ){
	                		 form = this.getViewAccountAddressDetailPanel();
	                	 } else if( transactionType == "ACTUAL_TRANSACTION" ){
	                		 form = this.getViewActualAccountAddressDetailPanel();
	                	 }
	                  	 
	                  	 if (form.collapsed) {
	                  		 form.expand();
	                  	 }
	                  	 form.down("#profile_image").setVisible(false);
	                  	 
	                  	 Ext.Ajax.request({
	                           method: "GET",
	                           type: 'rest',
	                           url: SERVERURL.SPONSOR_FLYOUT,
	                           params: {
	                          	 sponsorId: sponsorId
	                           },
	                       success: function(f, action) {
	                       var responseData = Ext.JSON.decode(f.responseText);

	                       form.down("#sponsorType").setVisible(true);
	                       form.down("#sponsorCode").setVisible(true);
	                       form.down("#noOfSponsoredStudents").setVisible(true);
	                       
	                       form.down("#addmissionId").setVisible(false);
	                       form.down("#applicationId").setVisible(false);
	                       form.down("#userId").setVisible(false);
	                       form.down("#program").setVisible(false);
	                       form.down("#batch").setVisible(false);
	                       form.down("#section").setVisible(false);
	                       form.down("#seatType").setVisible(false);
	                       form.down("#period").setVisible(false);
	                       form.down("#whetherFaculty").setVisible(false);
	                       form.down("#whetherInternal").setVisible(false);
	                       form.down("#departmentName").setVisible(false);
	                       
	                       form.down("#name").setValue(responseData.sponsorName);
	                       form.down("#address").setValue(responseData.addressText);
	                       form.down("#emailId").setValue(responseData.primaryEmailId);
	                       form.down("#contactNo").setValue(responseData.phoneNo);
	                       form.down("#sponsorType").setValue(responseData.sponsorType);
	                       form.down("#sponsorCode").setValue(responseData.sponsorCode);
	                       form.down("#noOfSponsoredStudents").setValue(responseData.noOfSponsoredStudents);
	                       
	                       form.down("#totalBalance").setValue(responseData.totalBalance);
	                       form.down("#totalAcadInvoiceAmount").setValue(responseData.totalAcadInvoiceAmount);
             				form.down("#totalAcadReceiptAmount").setValue(responseData.totalAcadReceiptAmount);
             				form.down("#totalConvertedOutstanding").setValue(responseData.totalConvertedOutstanding);
             				form.down("#totalAcadPaymentAmount").setValue(responseData.totalAcadPaymentAmount);
             				form.down("#totalAcadDicountAmount").setValue(responseData.totalAcadDicountAmount);
             				form.down("#totalAcadLocAdvanceAmount").setValue(responseData.totalAcadLocAdvanceAmount);
	                 	 
	                  	 }
	                     });
	                   },
	                 //********* Set Address For Applicant *********
	                   setAddressForApplicant:function(applicantId, transactionType){
	                  	 var form = this.getViewAccountAddressDetailPanel();
	                  	 
	                  	if( transactionType == "VOUCHER_TRANSCTION" ){
	                		 form = this.getViewAccountAddressDetailPanel();
	                	 } else if( transactionType == "ACTUAL_TRANSACTION" ){
	                		 form = this.getViewActualAccountAddressDetailPanel();
	                	 }
	                  	 
	                  	 if (form.collapsed) {
	                  		 form.expand();
	                  	 }
	                  	 form.down("#profile_image").setVisible(true);
	                  	 if(!isNullOrEmpty(applicantId)){
	                  		 Ext.Ajax.request({
	                  			 type: 'rest',
	                  			 binary: true,
	                  			 url: SERVERURL.PERSON_IMAGE_DOWNLOAD+'?personId='+applicantId,
	                  			 method: 'GET',
	                  			 success : function(response){
	                  				 if(response.responseBytes.length>0){
	                  					 var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
	                  					 var url = window.URL.createObjectURL(blob);
	                  					 var image = form.down("#profile_image");
//	                  					 image.setVisible(true);
	                  					 image.getEl().dom.src=url;
	                  				 }
	                  			 }

	                  		 });

	                  		 Ext.Ajax.request({
	                  			 method: "GET",
	                  			 type: 'rest',
	                  			 url: SERVERURL.APPLICANT_FLYOUT,
	                  			 params: {
	                  				 id: applicantId
	                  			 },
	                  			 success: function(f, action) {
	                  				 var responseData = Ext.JSON.decode(f.responseText);

	                  				 form.down("#program").setVisible(true);
	                  				 form.down("#batch").setVisible(true);
	                  				 form.down("#seatType").setVisible(true);
	                  				 form.down("#applicationId").setVisible(true);

	                  				 form.down("#sponsorType").setVisible(false);
	                  				 form.down("#sponsorCode").setVisible(false);
	                  				 form.down("#noOfSponsoredStudents").setVisible(false);
	                  				 form.down("#addmissionId").setVisible(false);
	                  				 form.down("#period").setVisible(false);
	                  				 form.down("#section").setVisible(false);
	                  				 form.down("#userId").setVisible(false);
	                  				 form.down("#whetherFaculty").setVisible(false);
	                  				 form.down("#whetherInternal").setVisible(false);
	                  				 form.down("#departmentName").setVisible(false);
	                  				 form.down("#feeheadwisedistributionId").setVisible(true);

	                  				 form.down("#name").setValue(responseData.applicantName);
	                  				 form.down("#address").setValue(responseData.addressText);
	                  				 form.down("#emailId").setValue(responseData.primaryeEmailId);
	                  				 form.down("#contactNo").setValue(responseData.cellNo);
	                  				 form.down("#applicationId").setValue(responseData.code);
	                  				 form.down("#program").setValue(responseData.program);
	                  				 form.down("#batch").setValue(responseData.batch);
	                  				 form.down("#seatType").setValue(responseData.seatType);
	                  				form.down("#totalBalance").setValue(responseData.totalBalance);
	                  				form.down("#totalAcadInvoiceAmount").setValue(responseData.totalAcadInvoiceAmount);
	                  				form.down("#totalAcadReceiptAmount").setValue(responseData.totalAcadReceiptAmount);
	                  				form.down("#totalConvertedOutstanding").setValue(responseData.totalConvertedOutstanding);
	                  				form.down("#totalAcadPaymentAmount").setValue(responseData.totalAcadPaymentAmount);
	                  				form.down("#totalAcadDicountAmount").setValue(responseData.totalAcadDicountAmount);
	                  				form.down("#totalAcadLocAdvanceAmount").setValue(responseData.totalAcadLocAdvanceAmount);
	                  			 
	                  			 }
	                  		 });
	                  	 }
	                   },
	                   loadPrgramAndBatch:function(form,applicationId,studentId,programCategoryId,programGroupId){
	                	/*   var multiselectAcademyLocation =form.down('#academyLocationId').getValue();
	                	   var ALsId = [];
        				   for(var i in multiselectAcademyLocation){
        					   if((multiselectAcademyLocation.length>0) && (!isNullOrEmpty(multiselectAcademyLocation[0]))){
        						   ALsId.push(multiselectAcademyLocation[i].data.id);
        					   }

        				   }
        				   if(ALsId.length == 0){
        					   var academyLocationForProgram = this.getCurrentAcademyLocation();
        				   }else{
        					   var academyLocationForProgram =  ALsId.join();
        				   }*/
	                	   var $this=this;
	                	   var academyLocationForProgram = $this.getALIdsFromDropdown($this);
	                	   if(programCategoryId!=null)
	                	   {
	                		   var applicant = form.getForm().findField('applicant');
	                		   applicationId = applicant.getValue();
	                		   var student = form.getForm().findField('student');
	                		   studentId = student.getValue();
	                		   var programGroup = form.getForm().findField('programGroup');
	                		   programGroupId = programGroup.getValue();
	                	   }
	                	   if(programGroupId!=null)
	                	   {
	                		   var applicant = form.getForm().findField('applicant');
	                		   applicationId = applicant.getValue();
	                		   var student = form.getForm().findField('student');
	                		   studentId = student.getValue();
	                		   var programCategory = form.getForm().findField('programCategory');
	                		   programCategoryId = programCategory.getValue();
	                	   }
	                	   if(applicationId!=null || studentId!=null)
	                	   {
	                		   var programCategory = form.getForm().findField('programCategory');
	                		   programCategoryId = programCategory.getValue();
	                		   var programGroup = form.getForm().findField('programGroup');
	                		   programGroupId = programGroup.getValue();
	                	   }
	                	   var batch=form.down("#batchName");
	                	   batch.reset();
	                	   batch.setDisabled(true);
	                	   var seatType=form.down("#seatType");
	                	   seatType.reset();
	                	   seatType.setDisabled(true);
	                	   var program = form.down('#programName');
	                	   var academyLocation = this.getCurrentAcademyLocation();
	                	   var programStore  = program.getStore();
	                	   var applicantField=form.down();
	                	   programStore.getProxy().extraParams = {	
	                		   academyLocationIds:academyLocationForProgram,
	                		   applicationId:applicationId,
	                		   studentId:studentId,
	                		   programCategoryId:programCategoryId,
	                		   programGroupId:programGroupId
	                	   };
	                	   var studentField=form.down('#student');
	                	   var applicantField=form.down('#applicant');
	                	   programStore.load({
	                		   callback: function(records, operation, success) {
		                        
                             var   status=form.down('#statusComboItemId').getValue();
		                    if(status==true){
	                			   if(records.length==1){
	                				  // program.setValue(records[0].get('id'));
	                			 
	                				   var programId = records[0].get("id");
	                				   var programCategoryStore = programCategory.getStore();
	                				   programCategoryStore.getProxy().extraParams = {
	                					   programId: programId
	                				   };
	                				   programCategoryStore.load({
        								   callback: function(records, operation, success) {
        									   if(records.length==1){
        										   //programCategory.setValue(records[0].get('id'));
        										  // programCategory.setValue(records[0].get('id'));
        									   }
        								   }
        							   })
	                				   var programGroupStore = programGroup.getStore();
	                				   programGroupStore.getProxy().extraParams = {
	                					   programId: programId
	                					   
	                				   };
	                				   programGroupStore.load({
        								   callback: function(records, operation, success) {
        									   if(records.length==1){
        										  //programGroup.setValue(records[0].get('id'));
        										  // programGroup.setValue(records[0].get('id'));
        									   }
        								   }
        							   })
	                				   var batchStore = batch.getStore();
	                				   batchStore.getProxy().extraParams = {
	                					   id: programId,
	                					   studentId: studentField.getValue(),
	                					   applicationId: applicantField.getValue(),
	                					   admissionId:0
	                				   };

	                				   batchStore.load({
	                					   callback: function(records, operation, success) {
	                			   if(records.length>=1){
	                							   //batch.setValue(records[0].get('id'));
	                							   var batchId=records[0].get('id');
	                							   var  seatTypeStore = seatType.getStore();
	                							   seatTypeStore.getProxy().extraParams = {
	                								   batchId: batchId
	                							   };
	                							   seatTypeStore.load({
	                								   callback: function(records, operation, success) {
	                									   if(records.length==1){
	                										   //seatType.setValue(records[0].data.seatType.id);
	                										  // seatType.setValue(records[0].data.seatType.id);
	                										   seatType.setDisabled(false);
	                									   }else
	                									   {
	                										   seatType.setDisabled(false);
	                									   }
	                								   }
	                							   })
	                							   batch.setDisabled(false);
	                						   }else{
	                							   batch.setDisabled(false);
	                						   }
	                					   }
	                				   });
	                			   }
}

else{
	
	                				  // program.setValue(records[0].get('id'));
	                				   var programId = records[0].get("id");
	                				   var programCategoryStore = programCategory.getStore();
	                				   programCategoryStore.getProxy().extraParams = {
	                					   programId: programId
	                				   };
	                				   programCategoryStore.load({
        								   callback: function(records, operation, success) {
        									   if(records.length>=1){
        										   //programCategory.setValue(records[0].get('id'));
        									   }
        								   }
        							   })
	                				   var programGroupStore = programGroup.getStore();
	                				   programGroupStore.getProxy().extraParams = {
	                					   programId: programId
	                					   
	                				   };
	                				   programGroupStore.load({
        								   callback: function(records, operation, success) {
        									   if(records.length==1){
        										   //programGroup.setValue(records[0].get('id'));
        									   }
        								   }
        							   })
	                				   var batchStore = batch.getStore();
	                				   batchStore.getProxy().extraParams = {
	                					   id: programId,
	                					   studentId: studentField.getValue(),
	                					   applicationId: applicantField.getValue(),
	                					   admissionId:0
	                				   };

	                				   batchStore.load({
	                					   callback: function(records, operation, success) {
	                						   if(records.length==1){
	                							   //batch.setValue(records[0].get('id'));
	                							   var batchId=records[0].get('id');
	                							   var seatTypeStore = seatType.getStore();
	                							   seatTypeStore.getProxy().extraParams = {
	                								   batchId: batchId
	                							   };
	                							   seatTypeStore.load({
	                								   callback: function(records, operation, success) {
	                									   if(records.length==1){
	                										   //seatType.setValue(records[0].data.seatType.id);
	                										   seatType.setDisabled(false);
	                									   }else
	                									   {
	                										   seatType.setDisabled(false);
	                									   }
	                								   }
	                							   })
	                							   batch.setDisabled(false);
	                						   }else{
	                							   batch.setDisabled(false);
	                						   }
	                					   }
	                				   });
	                			   }
	                		   }
	                	   });
	                	   form.isValid();
	                   },
	                   loadProgram:function(form){
	                	   var multiselectAcademyLocation =form.down('#academyLocationId').getValue();
	                	   var ALsId = [];
        				   for(var i in multiselectAcademyLocation){
        					   if((multiselectAcademyLocation.length>0) && (!isNullOrEmpty(multiselectAcademyLocation[0]))){
        						   ALsId.push(multiselectAcademyLocation[i]);
        					   }

        				   }
        				   if(ALsId.length == 0){
        					   var academyLocation = this.getCurrentAcademyLocation();
        				   }else{
        					   var academyLocation =  ALsId.join();
        				   }
	                	   var batch=form.down("#batchName");
	                	   batch.reset();
	                	   batch.setDisabled(true);
	                	   var seatType=form.down("#seatType");
	                	   seatType.reset();
	                	   seatType.setDisabled(true);
	                	   var program = form.down('#programName');
	                	   program.reset();
	                	   var programCategory = form.getForm().findField('programCategory');
	                	   var programGroup = form.getForm().findField('programGroup');
	                	   programCategory.reset();
	                	   programCategory.getStore().getProxy().extraParams = {	
	                		   programId:null
	                	   }; 
	                	   programCategory.getStore().reload();
	                	   programGroup.reset();
	                	   programGroup.getStore().getProxy().extraParams = {	
	                		   programId:null
	                	   }; 
	                	   var academyLocation = this.getCurrentAcademyLocation();
	                	   var store  = program.getStore();
	                	   store.getProxy().extraParams = {	
	                		   academyLocationIds:academyLocation
	                	   };
	                	   store.load();
	                   },
	                   resetStatementFor:function(form){
	                	   var students = form.down("#student");
	                	   var sponsors = form.down("#sponsors");
	                	   var applicants = form.down("#applicant");
	                	   var programCategory = form.getForm().findField('programCategory');
	                	   var programGroup = form.getForm().findField('programGroup');
	                	   var programName = form.down("#programName");
	                	   var batchName = form.down("#batchName");
	                	   var recieptView = form.down('#recieptView');
	                	   var showAllStudents = form.down('#showAllStudentsItemId');       				  
        				  
	                	   
	                	   students.reset();
	                	   sponsors.reset();
	                	   applicants.reset();
	                	   showAllStudents.reset();
	                	   programCategory.reset();
	                	  // fnpALId.reset();
	                	   programCategory.getStore().getProxy().extraParams = {	
	                		   programId:null
	                	   }; 
	                	   programCategory.getStore().reload();
	                	   programGroup.reset();
	                	   programGroup.getStore().getProxy().extraParams = {	
	                		   programId:null
	                	   }; 
	                	   programGroup.getStore().reload();
	                	   students.allowBlank=true;
	                	   sponsors.allowBlank=true;
	                	   applicants.allowBlank=true;
	                	   programName.allowBlank=true;
	                	   batchName.allowBlank=true;
	                	   if(recieptView.getValue()!=3){//Sponsor Id
	                		   programName.setVisible(true);
		                	   batchName.setVisible(true);
	                	   }

	                	  
	                	  /* 
        				   var recieptViewStore  = recieptView.getStore();
        				   recieptViewStore.load({
        					   callback: function(rec, operation, success) {
        						   if (success) {
        							   recieptView.setValue(rec[0].get('id'));
        						   }
        					   }
        				   });*/
        				   form.isValid();
	                   },
	                   
	                   downloadDetailedStudentStatementOfAccountReport:function(code){
	                          var $this =this;
	                          var grid =  $this.getActualaccountstatementgrid();
	                          var academyLocationId = $this.getCurrentAcademyLocation();
	                          var records = grid.getSelectionModel().getSelection();
	                          var outerForm = $this.getAccountstatementsearch().getForm();                  
	                          var academyLocation = outerForm.findField('academyLocation');
	                          var userTypeValue = outerForm.findField('recieptView').getValue();
	                          var multiselectAcademyLocation=academyLocation.getValue();
	                          var portalId = this.getCurrentLoggedPortalId();
	                          var billedUserTypeEnumValue = outerForm.findField('recieptView').getRawValue();
	                          var programId = $this.records[0].data.programId;
	                          var programCategoryId = $this.records[0].data.programCategoryId;
	                          var programGroupId = $this.records[0].data.programGroupId;
	                          var seatTypeId = $this.records[0].data.seatTypeId;
	                          var status = $this.records[0].data.studentStatus;
	                          var batchId = $this.records[0].data.batchId;
	                          var id = $this.records[0].data.personId;
	                          var portalId = this.getCurrentLoggedPortalId();
	                          var showAllStudents = outerForm.findField('showAllStudents').getValue();
	                          //var whetherCancelledTransaction = outerForm.findField('includeAllCancelledTransaction').getValue();

	                          var startDate = outerForm.getValues().startDate;
	                          var tillDate = outerForm.getValues().tillDate;
	                          var user=$this.getCurrentlyLoggedInUser();

	                          var studentIdArr = records[0].data.studentId

//	                          var statusField = outerForm.findField('STATUS');
//	                          if(statusField.getValue()==null){
//	                              statusField.setValue(true);
//	                          }
	                          var reportParams = new Object();
	                          console.log(reportParams,"123")
	                          var reportTitle = 'StudentStatementOfAccount';
//	                        var code = 'STATEMENT_OF_ACCOUNT_DIT';
	                          
	                          var ALsId = [];
								 for(var i in multiselectAcademyLocation){
									 if(!isNullOrEmpty(multiselectAcademyLocation[i]) && typeof multiselectAcademyLocation[i]=='object'){
										 ALsId.push(multiselectAcademyLocation[i].data.id);
									 }else{
										 ALsId.push(multiselectAcademyLocation[i]);
									 }
								 } 
	                          
	                          reportParams.code = code;
	                          reportParams.reportTitle = reportTitle;
	                          reportParams.id = studentIdArr
	                          reportParams.screenName='StudentStatementOfAccount';
	                          reportParams.academyLocationIds=ALsId.join();
	                          reportParams.academyLocationId=academyLocationId;
	                          reportParams.billedUserType = outerForm.findField('recieptView').store.findRecord('value', billedUserTypeEnumValue).data.displayValue;
	                          reportParams.status = status;
	                          reportParams.statementFrom=startDate;
	                          reportParams.statementTo=tillDate;
	                          reportParams.programId=programId;
	                          reportParams.batchId=batchId;
	                          reportParams.programCategoryId=programCategoryId;
	                          reportParams.programGroupId=programGroupId;
	                          reportParams.seatTypeId=seatTypeId;
	                          reportParams.personId=id;
	                          reportParams.portalId=portalId;
	                          reportParams.userCode=user.code;
	                          reportParams.whetherShowAllStudents=showAllStudents;
	                          //reportParams.whetherCancelledTransaction=whetherCancelledTransaction;
	                          $this.exportJRXMLReport(code, reportParams, reportTitle, '.pdf', SERVERURL.ACTUAL_ACCOUNT_STATEMENT_PDF);
	   
	                  },

	                  

	                   downloadStudentDetailedStudentStatementOfAccountReport:function(code){
	                          var $this =this;
	                          var grid =  $this.getActualaccountstatementgrid();
	                          var academyLocationId = $this.getCurrentAcademyLocation();
//	                          var records = grid.getSelectionModel().getSelection();
	                          var outerForm = $this.getStudentaccountstatementsearch();                  
//	                          var academyLocation = outerForm.findField('academyLocation');
//	                          var userTypeValue = outerForm.findField('recieptView').getValue();
//	                          var multiselectAcademyLocation=academyLocation.getValue();
	                          var portalId = this.getCurrentLoggedPortalId();
//	                          var billedUserTypeEnumValue = outerForm.findField('recieptView').getRawValue();
	                          var programId = $this.studentRecords.data.programId;
	                          var programCategoryId = $this.studentRecords.data.programCategoryId;
	                          var programGroupId = $this.studentRecords.data.programGroupId;
	                          var seatTypeId = $this.studentRecords.data.seatTypeId;
	                          var status = $this.studentRecords.data.studentStatus;
	                          var batchId = $this.studentRecords.data.batchId;
	                          var id = $this.studentRecords.data.studentId;
	                          var portalId = this.getCurrentLoggedPortalId();
//	                          var showAllStudents = outerForm.findField('showAllStudents').getValue();
 
	                          var startDate = outerForm.getValues().startDate;
	                          var tillDate = outerForm.getValues().tillDate;
//	                          var user=$this.getCurrentlyLoggedInUser();

	                          var studentIdArr = $this.studentRecords.data.studentId

//	                          var statusField = outerForm.findField('STATUS');
//	                          if(statusField.getValue()==null){
//	                              statusField.setValue(true);
//	                          }
	                          var reportParams = new Object();
	                          console.log(reportParams,"123")
	                          var reportTitle = 'StudentStatementOfAccount';
//	                        var code = 'STATEMENT_OF_ACCOUNT_DIT';
	                          reportParams.code = code;
	                          reportParams.reportTitle = reportTitle;
	                          reportParams.id = studentIdArr
	                          reportParams.screenName='StudentStatementOfAccount';
	                          reportParams.academyLocationIds=academyLocationId.toString();
	                          reportParams.academyLocationId=academyLocationId;
//	                          reportParams.billedUserType = outerForm.findField('recieptView').store.findRecord('value', billedUserTypeEnumValue).data.displayValue;
	                          reportParams.status = status;
	                          reportParams.statementFrom=startDate;
	                          reportParams.statementTo=tillDate;
	                          reportParams.programId=programId;
	                          reportParams.batchId=batchId;
	                          reportParams.programCategoryId=programCategoryId;
	                          reportParams.programGroupId=programGroupId;
	                          reportParams.seatTypeId=seatTypeId;
	                          reportParams.personId=id;
	                          reportParams.portalId=portalId;
	                          reportParams.billedUserType = "STUDENT";
//	                          reportParams.userCode=user.code;
//	                          reportParams.whetherShowAllStudents=showAllStudents;
	                          $this.exportJRXMLReport(code, reportParams, reportTitle, '.pdf', SERVERURL.ACTUAL_ACCOUNT_STATEMENT_PDF);
	   
	                  },
	                   searchStudentAccountStatment:function(){
	                	   var $this = this;
	                	   var activeTab = this.getContentPanel().getActiveTab(); 
	                	   var outerForm = this.getStudentaccountstatementsearch().getForm();
	                	   var startDate = (!isNullOrEmpty(activeTab.down("#startDate").getValue()))?activeTab.down("#startDate").getValue().toISOString().split('.')[0]:'';
	   					   var tillDate = (!isNullOrEmpty(activeTab.down("#tillDate").getValue()))?activeTab.down("#tillDate").getValue().toISOString().split('.')[0]:'';
	   					   if(startDate.includes('T')){
	   						startDate = startDate.replace('T', ' ');
	   					    }
						   if(tillDate.includes('T')){
							   tillDate = tillDate.replace('T', ' ');
	            		    }
	                	  // var startDate = activeTab.down('#startDate').getValue();
	                	  // var tillDate = activeTab.down('#tillDate').getValue();        	   
	                	   var billedUserType = 'STUDENT';
	                	   var viewgrid = activeTab.down('viewstudentaccountstatementgrid');
	                	   
	                	   var transactionTypeRadio = activeTab.down('#transactionTypeId');
	                	   var viewgrid = null;
	                	   
        				   var Viewstudentaccountstatementgrid = activeTab.down('viewstudentaccountstatementgrid');
        				   var Viewstudentactualaccountstatementgrid = activeTab.down('viewstudentactualaccountstatementgrid');
    					   
        				   if(transactionTypeRadio.getValue().transactionType=="ACTUAL_TRANSACTION"){
        					   
        					   Viewstudentactualaccountstatementgrid.setVisible(true);
        					   Viewstudentaccountstatementgrid.setVisible(false);
        					   viewgrid = Viewstudentactualaccountstatementgrid;
        				   
        				   } else if(transactionTypeRadio.getValue().transactionType=="VOUCHER_BASED_TRANSACTION"){
        					   
        					   Viewstudentactualaccountstatementgrid.setVisible(false);
        					   Viewstudentaccountstatementgrid.setVisible(true);
        					   viewgrid = Viewstudentaccountstatementgrid;
        				   }
        				   
        				   var viewstore = viewgrid.getStore();
        				   var portalId = this.getCurrentLoggedPortalId();
        				   $this.setTitleWithDate(startDate,tillDate,viewgrid);
	                	   $this.resetPageSetting(viewstore);
	                	   var studentId=this.getCurrentlyLoggedInUserInfoForPortal().student.id;
	                	   viewstore.getProxy().extraParams = {	
	                		   id:studentId,
	                		   statementFrom:startDate,
	                		   statementTo:tillDate,
	                		   billedUserType:billedUserType,
	                		   screenName:'statementOfAccount',
	                		   status: true,
	                		   portalId:portalId
	                		   
	                	   };
	                	   viewstore.load({
	                		   callback: function(record, operation, success) {
	                			   if(record && record[0].data && record[0].data.narration=="<b>Opening Balance</b>"){
	                				   $this.studentRecords = record[1]; 
	                			   }else{
	                				   $this.studentRecords = record[0]; 
	                			   }
	                			   if (record.length > 0) {
	                				   for(var i in record){
	  		                				if (record[i].data.whetherDisplayTotal != false) {
	  		                					this$.toggleGridSummaryRow(grid,true); 
	  		                				}
	  		                			}
	                	//			   $this.toggleGridSummaryRow(viewgrid,true);
	                			   }else{
	                				   $this.toggleGridSummaryRow(viewgrid,false);
	                			   }
	                		   }
	                	   });
	                   },
	                   studentExportJRXML:function(fileType,grid){
	                	   var viewGrid=this.getViewstudentaccountstatementgrid();
	                	   if (viewGrid.getSelectionModel().getCount() > 0) {
	                	   var outerForm = this.getStudentaccountstatementsearch().getForm();
	                	   var startDate = outerForm.findField('startDate').getValue();
	                	   var tillDate = outerForm.findField('tillDate').getValue();     	   
	                	   var billedUserType ='STUDENT';
	                	   var studentId=this.getCurrentlyLoggedInUserInfoForPortal().student.id;
	                	   
	                	   user=this.getCurrentlyLoggedInUser();
	                	   // code to identify jasper
	                	   var code ="STATEMENT_OF_ACCOUNT_REPORT";
	                	   var reportParams =new Object();
	                	   reportParams.userId=user.code;
	                	   reportParams.ids=String(studentId); // convert int into string
	                	   reportParams.billedUserType=billedUserType;
	                	   reportParams.statementFrom=Ext.Date.format(new Date(startDate),CONSTANTS.SUBMIT_DATE_FORMAT);
	                	   reportParams.statementTo=Ext.Date.format(new Date(tillDate),CONSTANTS.SUBMIT_DATE_FORMAT);
	                	   var reportTitle=getFeeAndPaymentCommonTranslation('ACCOUNT_STATEMENT');
	                	   var exportUrl = SERVERURL.ACCOUNT_STATEMENT_PDF;
	                	   this.exportJRXMLReport(code,reportParams,reportTitle,fileType,exportUrl);
	                	   }else{
	                	   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                	   }
	                   },
	                   disableOtherPivileges:function(grid,permissionsMap){
	                	   var associatedAcadLocationIds = new Array();
	                	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	                	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	                	   var studentPrintBtn=grid.down('#btnPrint');
	                	   if(!isNullOrEmpty(studentPrintBtn)){
	                		   studentPrintBtn.setVisible(false);
	                	   }
	                	   Ext.each(permissionList, function(privilege) {
	                		   if (privilege === 'PRINT') {
	                			   if(!isNullOrEmpty(studentPrintBtn)){
	                				   studentPrintBtn.setVisible(true);
	                			   } 
	                		   }
	                	   });
	                   },
	                   exportXLFunction:function(fileType, viewGrid, billedUserType){
	                	   //var viewGrid=this.getViewstudentaccountstatementgrid();
	                	   
	                	   /*if(portalId==7){
          					  $this.doAccessControlValidation(grid,this.getPARENT_STATEMENT_OF_ACCOUNT_PERMISSIONS());
          				  }else{//student portal
          					  $this.doAccessControlValidation(grid,this.getSTUDENT_STATEMENT_OF_ACCOUNT_PERMISSIONS());
          				  }*/
	                	   
	                	   if(portalId==1){
	                		//   if (viewGrid.getSelectionModel().getCount() > 0) {
			                	   var outerForm = this.getAccountstatementsearch().getForm();
			                	   var startDate = outerForm.findField('startDate').getValue();
			                	   var tillDate = outerForm.findField('tillDate').getValue();
			                	   var status = outerForm.findField('STATUS').getValue();
			                	   var billedUserType = billedUserType;
			                	   var academyLocations=outerForm.findField('academyLocation').getValue();
			                	   //var programId = outerForm.findField('programName').getValue();
			                	   //var batchId = outerForm.findField('batchName').getValue();
			                	   
			                	   var records =viewGrid.getStore().data.items;
			                	   var studentId = records[0].data.studentId;
			                	   var personId = records[0].data.personId;
			                	   
			                	   var academyLocation = this.getCurrentAcademyLocation();
			                	   
			                	   user=this.getCurrentlyLoggedInUser();
			                	   // code to identify jasper
			                	   var code ="VELOCITY_STATEMENT_OF_ACCOUNT";
			                	   var reportParams =new Object();
			                	   /*reportParams.userId=user.code;*/
			                	   reportParams.id=studentId;
			                	   reportParams.personId=personId;
			                	   reportParams.billedUserType=billedUserType;
			                	   reportParams.portalId=portalId;
			                	   reportParams.programCategoryId=records[0].data.programCategoryId;
			                	   reportParams.programGroupId=records[0].data.programGroupId;
			                	   reportParams.seatTypeId=records[0].data.seatTypeId;
			                	   reportParams.status=status;
			                	   
			                	   if(billedUserType == "SPONSOR"){
			                		   var sponsorId = records[0].data.sponsorId;
			                		   reportParams.sponsorId=sponsorId;
			                	   }
			                	   var ids = [];
			                	   if(academyLocations!=null){
			                	   for(var i=0;i<academyLocations.length;i++){
			                		   if(typeof academyLocations=='Object'){
			                	      ids.push(academyLocations[i].data.id);
			                		   }
			                		   else{
			                			   ids.push(academyLocations[i]);
			                		   }
			                	      }
			                	   }
			                	   
			                	   var ALIds = ids.join(',');
			                	  reportParams.academyLocationIds = ALIds;
			                	   
			                	   //reportParams.statementFrom=Ext.Date.format(new Date(startDate),CONSTANTS.SUBMIT_DATE_FORMAT);
			                	   //reportParams.statementTo=Ext.Date.format(new Date(tillDate),CONSTANTS.SUBMIT_DATE_FORMAT);
			                	   
			                	   reportParams.statementFrom=startDate;
			                	   reportParams.statementTo=tillDate;
			                	   
			                	   //reportParams.programId = programId;
			                	   //reportParams.batchId = batchId;
			                	   form = this.getViewActualAccountAddressDetailPanel();
		                		   if(!isNullOrEmpty(form)){
		                			   reportParams.programId = parseInt(form.down("#programIdHidden").getValue());
		                			   reportParams.batchId = parseInt(form.down("#batchIdHidden").getValue());
		                		   }
			                	   
			                	   reportParams.academyLocationId = academyLocation;
			                	   //reportParams.personId = 8600;
			                	   
			                	   var reportTitle=getFeeAndPaymentCommonTranslation('STATEMENT_OF_ACCOUNT');
			                	   var exportUrl = SERVERURL.ACTUAL_ACCOUNT_STATEMENT_PDF;
			                	   this.exportJRXMLReport(code,reportParams,reportTitle,fileType,exportUrl);
		                	   //}/*else{
		                		 //  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));*/
		                	   //}
	                	   } else {
	                		   
	                		   var studentObj = this.getCurrentlyLoggedInUserInfoForPortal();
	                		   
	                		   var outerForm = this.getStudentaccountstatementsearch().getForm();
		                	   var startDate = outerForm.getValues().startDate;
		                	   var tillDate = outerForm.getValues().tillDate;
		                	   var billedUserType = billedUserType;
		                	   
		                	   var studentId = studentObj.student.id;
		                	   var personId = studentObj.student.person.id;
		                	   
		                	   var academyLocation = this.getCurrentAcademyLocation();
		                	   
		                	   var code ="VELOCITY_STATEMENT_OF_ACCOUNT";
		                	   var reportParams =new Object();
		                	   reportParams.id=studentId;
		                	   reportParams.personId=personId;
		                	   reportParams.billedUserType=billedUserType;
		                	   
		                	   reportParams.statementFrom=startDate;
		                	   reportParams.statementTo=tillDate;
	                		   reportParams.programId = studentObj.programBatchDetails.programId;
	                		   reportParams.batchId = studentObj.programBatchDetails.batchId;
	                		   reportParams.portalId=portalId;
	                		   reportParams.status=true;
		                	   
		                	   reportParams.academyLocationId = academyLocation;
		                	   
		                	   var reportTitle=getFeeAndPaymentCommonTranslation('STATEMENT_OF_ACCOUNT');
		                	   var exportUrl = SERVERURL.ACTUAL_ACCOUNT_STATEMENT_PDF;
		                	   this.exportJRXMLReport(code,reportParams,reportTitle,fileType,exportUrl);
	                		   
	                	   }
	                	   
	                	   
		                },
                        viewActualAccountStatementGridCellClick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts, userType ) {
                        	 
                        	var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
            				 if(columnName == "transactionNo"){
            					 if(e.target.tagName=='A'){
            						 //alert('link clicked');
            						 this.openTransaction(grid,record, userType);
            					 }
            				 }
                        },
		                openTransaction : function(grid, record, userType){
		                	
	                       	 if(grid.getSelectionModel().getCount()>0){
	                       		 var records = grid.getSelectionModel().getSelection()[0];
	                       		 
	                       		 if( records.get("category") == "BILL_RECEIVABLE" || records.get("category") == "BILL_PAYABLE" ){
	                       			this.openTransactionBill(grid, record, userType);
	                       		 } else if( records.get("category") == "RECEIPT" ){
	                       			this.openTransactionReciept(grid, record, userType);
	                       		 } else if( records.get("category") == "PAYMENT" ){
	                       			this.openTransactionPayment(grid, record, userType);
	                       		 }
	                       		 
	                       	 }else{
	                       		 showWarningMessage(getFeeAndPaymentCommonTranslation('BILL_HEADER'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
	                       	 }
                        },
                        openTransactionPayment : function(grid, record, userType){
                        	var records = grid.getSelectionModel().getSelection()[0];
                        	var paymentId = records.get("txnNo");
                        	var paymentController = Academia.app.getController('Academia.controller.feeandpayment.payment.PaymentController');
                        	paymentController.getOpenManagePaymentForm();
                        	paymentController.getViewPaymentDetailsByIdAndType(null,paymentId, userType);
                        },
                        openTransactionReciept : function(grid, record, userType){
                        	var records = grid.getSelectionModel().getSelection()[0];
                        	var recieptId = records.get("txnNo");
                        	var receiptController = Academia.app.getController('Academia.controller.feeandpayment.receipts.ReceiptsController');
                        	receiptController.getViewReceiptDetailsByReport(recieptId);
                        },
                        openTransactionBill : function(grid, record, userType){

                        	 $this = this;
                        	
                      		 var records = grid.getSelectionModel().getSelection()[0];
                      		 var formWindow = this.getBillviewwindow();
                      		 if (!formWindow) {
                      			 Ext.widget('billviewwindow');
                      			 formWindow = this.getBillviewwindow();
                      		 }
                      		 formWindow.down("#billNo").setValue(records.get("transactionNo"));
                      		 //formWindow.down("#billAmount").setValue(currencyRenderer(records.get("grossAmount"),records.get("currencyId")));
                      		 //formWindow.down("#billAmount").setValue(currencyRenderer(records.get("debitAmount"),records.get("currencyId")));
                      		 formWindow.down("#billingDate").setValue(dateRender(records.get("transactionDate")));
                      		 formWindow.down("#currency").setValue(records.get("createdCurrencyCode"));
                      		 
                      		 var bindingStore = this.getStore('feeandpayment.managebill.billview.BillViewForPC');
                          	 var listGrid=$this.getBillviewforpcgrid();
                 	             var paginationStore = listGrid.getDockedItems()[1].items.items[0];
                          	 listGrid.bindStore(bindingStore);
                          	// paginationStore.bindStore(bindingStore);
                          	 var store = listGrid.getStore();
                      		 
                      		 store.getProxy().extraParams={
                      			 billId:records.get("txnNo")
                      		 };
                      		 
                      		 var billAmount = 0;
                      		 
                      		 store.load({
          						 callback: function(record, operation, success) {
          							 if (success) {
          								 formWindow.show();
          								 
          								for(var i in record) {
          									billAmount = billAmount + record[i].data.feeAmount;
          			    				}
          								formWindow.down("#settlementStatus").setValue(record[0].data.settlementStatus);
          								formWindow.down("#billAmount").setValue(currencyRenderer(billAmount,records.get("currencyId")));
          								formWindow.down("#currency").setValue(record[0].data.currencyName);
          								 
          							// Remove column from grid
        	                       		var columns = null,
        	                            store = null;
        	                            var columnNames = [getFeeAndPaymentCommonTranslation('FEE_PLAN'), getFeeAndPaymentCommonTranslation('STAGE_NAME'), getCommonTranslation('FEE_HEAD_GROUP'),
        	                            	getFeeAndPaymentCommonTranslation('FEE_HEAD'), getFeeAndPaymentCommonTranslation('FEE_AMOUNT'),
        	                            	getFeeAndPaymentCommonTranslation('AMOUNT')];
        	                            var columnDataIndexes = ['feePlan#show', 'stageName#show','groupingFeeHeadName#hide', 'feeHead#show', 'feeAmount#show','amountPending#show'];
        	                            columns = $this.getSearchGridColumns(columnNames, columnDataIndexes);
        	                            //store = me.getSearchGridData(me, selectedApplicationType, searchResult);
        	                            
        	                            if (!isEmpty(columns)) {
        	                            	listGrid.reconfigure(null, columns);
        	                                //grid.getSelectionModel().deselectAll(true);
        	                            }
        	                            
        		                     // Remove column from grid
          								 
          							 }
          						 }
          					 });
                      		 
                        },
                        selectTransactionType : function(obj,newValue,oldValue){
         				   
         				   var formObj = obj.up('form');
         				   var form = formObj.getForm();
         				   var statusField = form.findField('STATUS');
         				   var showAllStudents = form.findField('showAllStudents');
         				   
         				   var billedUserType = form.findField('recieptView').valueModels[0].data.value;
         				   var accountStatementGrid = this.getAccountstatementgrid();
         				   //var actualAccountStatementGrid = this.getActualaccountstatementgrid();
         				   var actualAccountStatementGrid = this.showHideActualStatementGrid(form);
         				   // sdfsdfsdf
         				   
         				   var isVoucherGrid = true;
         				   
         				   var studentIdColIndex = 0;
     					   var personNameColIndex = 1;
     					   var programNameColIndex = 2;
     					   var batchNameColIndex = 3;
     					   
         				   if(newValue.transactionType=="ACTUAL_TRANSACTION"){
         					   
         					   if( billedUserType == 'STUDENT' ){
         						   statusField.setVisible(true);
         					   } else {
         						   statusField.setVisible(false);
         					   }
         					   actualAccountStatementGrid.setVisible(true);
         					   accountStatementGrid.setVisible(false);
         					   showAllStudents.setVisible(true);
         					   
         					   grid = actualAccountStatementGrid;
         					   isVoucherGrid = false;
         					   personNameColIndex = 2;
         					   programNameColIndex = 3;
         					   batchNameColIndex = 4;
         					   
         				   
         				   } else if(newValue.transactionType=="VOUCHER_BASED_TRANSACTION"){
         					   statusField.setVisible(false);
         					   showAllStudents.setVisible(false);
         					   actualAccountStatementGrid.setVisible(false);
         					   accountStatementGrid.setVisible(true);
         					   
         					   grid = accountStatementGrid;
         					   isVoucherGrid = true;
         				   }
         				   
         				   // change grid labels also
             			   if( billedUserType == 'STUDENT' ){
             				   
             				   if(newValue.transactionType=="VOUCHER_BASED_TRANSACTION"){
	                				   grid.columns[studentIdColIndex].setText(getFeeAndPaymentCommonTranslation('STUDENT_ID'));
             					   grid.columns[personNameColIndex].setText(getFeeAndPaymentCommonTranslation('STUDENT_NAME'));
             					   grid.columns[programNameColIndex].setVisible(true);
             					   grid.columns[batchNameColIndex].setVisible(true);
             					   grid.setTitle(getFeeAndPaymentCommonTranslation('LIST_OF_STUDENT'));
             				   }
         				   }
         				   else if( billedUserType == 'APPLICANT' ){
         					   if(newValue.transactionType=="VOUCHER_BASED_TRANSACTION"){
             					   grid.columns[studentIdColIndex].setText(getFeeAndPaymentCommonTranslation('APPLICANT_ID'));
             					   grid.columns[personNameColIndex].setText(getFeeAndPaymentCommonTranslation('APPLICANT_NAME'));
             					   grid.columns[programNameColIndex].setVisible(true);
             					   grid.columns[batchNameColIndex].setVisible(true);
             					   grid.setTitle(getCommonTranslation('LIST_OF_APPLICANTS'));
         					   }
         				   }
         				   else if( billedUserType == 'SPONSOR' ) {
         					   if(newValue.transactionType=="VOUCHER_BASED_TRANSACTION"){
             					   grid.columns[studentIdColIndex].setText(getFeeAndPaymentCommonTranslation('SPONSOR_ID'));
             					   grid.columns[personNameColIndex].setText(getFeeAndPaymentCommonTranslation('SPONSOR_NAME'));
             					   grid.columns[programNameColIndex].setVisible(false);
             					   grid.columns[batchNameColIndex].setVisible(false);
             					   grid.setTitle(getCommonTranslation('LIST_OF_SPONSORS'));
         					   }
         				   }
         				   // change grid labels also
         				   
         				   
         				   formObj.doLayout();
         				   formObj.body.setScrollTop(0);
         			   
     				   },
     				   setTitleWithDate : function(startDate,tillDate,viewgrid){
     					   if(!isNullOrEmpty(startDate) && !isNullOrEmpty(tillDate)){
     						   var title = getFeeAndPaymentCommonTranslation('ACCOUNT_STATEMENT')+' From '+ (dateRender(startDate)) +' To '+(dateRender(tillDate));
     						   viewgrid.setTitle(title);
     					   }else{
     						   if(!isNullOrEmpty(startDate)){
     							   var title = getFeeAndPaymentCommonTranslation('ACCOUNT_STATEMENT')+' From '+ (dateRender(startDate));
     							   viewgrid.setTitle(title);
     						   }else{
     							   if(!isNullOrEmpty(tillDate)){
     								   var title = getFeeAndPaymentCommonTranslation('ACCOUNT_STATEMENT')+' To '+(dateRender(tillDate));
     								   viewgrid.setTitle(title);
     							   }else{
     								   viewgrid.setTitle('');
     							   }
     						   }
     					   }
     				   },
     				  disableMoreActionPivileges:function(form,permissionsMap){
	                	   var associatedAcadLocationIds = new Array();
	                	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	                	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	                	   var studentcheckallbtn=form.down('#showAllStudentsItemId');
	                	   if(!isNullOrEmpty(studentcheckallbtn)){
	                		   studentcheckallbtn.setVisible(false);
	                	   }
	                	   Ext.each(permissionList, function(privilege) {
	                		   if (privilege === 'SHOWALLSTUDENT') {
	                			   if(!isNullOrEmpty(studentcheckallbtn)){
	                				   studentcheckallbtn.setVisible(true);
	                			   } 
	                		   }
	                	   });
	                   },
	                   disableDownloadAllPivileges:function(form,permissionsMap){
	                	   var associatedAcadLocationIds = new Array();
	                	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	                	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	                	   var downloadAllBtn=form.down('#downloadDetailAllStatementOfAccountReport');
	                	   if(!isNullOrEmpty(downloadAllBtn)){
	                		   downloadAllBtn.setVisible(false);
	                	   }
	                	   Ext.each(permissionList, function(privilege) {
	                		   if (privilege === 'DOWNLOAD_ALL') {
	                			   if(!isNullOrEmpty(downloadAllBtn)){
	                				   downloadAllBtn.setVisible(true);
	                			   } 
	                		   }
	                	   });
	                   },
	                   downloadDetailedStatementOfAccountReport:function(code){
	                	   var $this =this;
							 var grid =  $this.getActualaccountstatementgrid();
							 var academyLocationId = $this.getCurrentAcademyLocation();
							 var records = grid.getSelectionModel().getSelection();
							 var outerForm = $this.getAccountstatementsearch().getForm();	                		   
							 var academyLocation = outerForm.findField('academyLocation');
							 var userTypeValue = outerForm.findField('recieptView').getValue();
							 var multiselectAcademyLocation=academyLocation.getValue();
							 var billedUserTypeEnumValue = outerForm.findField('recieptView').getRawValue();
							 var programCategoryId = outerForm.findField('programCategory').getValue();
							 var programGroupId =outerForm.findField('programGroup').getValue();
							 var programId=outerForm.findField('programName').getValue();
							 var batchId=outerForm.findField('batchName').getValue();
							 var seatTypeId=outerForm.findField('seatType').getValue();
							 var id=outerForm.findField('student').getValue();
							 var showAllStudents = outerForm.findField('showAllStudents').getValue();
							// var whetherCancelledTransaction = outerForm.findField('includeAllCancelledTransaction').getValue();

							 var startDate = outerForm.getValues().startDate;
							 var tillDate = outerForm.getValues().tillDate;
							 var user=$this.getCurrentlyLoggedInUser();
							 var ALsId = [];
							 for(var i in multiselectAcademyLocation){
								 if(!isNullOrEmpty(multiselectAcademyLocation[i]) && typeof multiselectAcademyLocation[i]=='object'){
									 ALsId.push(multiselectAcademyLocation[i].data.id);
								 }else{
									 ALsId.push(multiselectAcademyLocation[i]);
								 }
							 } 
							 var studentIdArr = new Array();
							 for( var i=0; i<records.length; i++ ) {
								 if(!isNullOrEmpty(records[i].data.studentId)){
									 studentIdArr.push(records[i].data.studentId);
								 }
							 }
							 var statusField = outerForm.findField('STATUS');
							 if(statusField.getValue()==null){
								 statusField.setValue(true);
							 }
							 var reportParams = new Object();
							 var reportTitle = 'StatementOfAccount';
							 //var code = 'STATEMENT_OF_ACCOUNT_DIT';
							 reportParams.code = code;
							 reportParams.reportTitle = reportTitle;
							 reportParams.studentIds = studentIdArr.join(',');
							 reportParams.screenName='StatementOfAccount';
							 reportParams.academyLocationIds=ALsId.join();
							 reportParams.billedUserType = outerForm.findField('recieptView').store.findRecord('value', billedUserTypeEnumValue).data.displayValue;
							 reportParams.status = statusField.getValue();
							 reportParams.statementFrom=startDate;
							 reportParams.statementTo=tillDate;
							 reportParams.programId=programId;
							 reportParams.batchId=batchId;
							 reportParams.programCategoryId=programCategoryId;
							 reportParams.programGroupId=programGroupId;
							 reportParams.seatTypeId=seatTypeId;
							 reportParams.id=id;
							 reportParams.userCode=user.code;
							 reportParams.whetherShowAllStudents=showAllStudents;
							 //reportParams.whetherCancelledTransaction=whetherCancelledTransaction;
							 $this.exportJRXMLReport(code, reportParams, reportTitle, '.pdf', SERVERURL.PATH_EXPORT_REPORT_STATEMENT_OF_ACCOUNT_DIT);
    					 
	                   },
	                   bulkDownloadDetailedStatementOfAccountReport:function(code){
	                	   var $this =this;
	                	   var statementOfAccountReportWin = $this.getStatementofaccountreportwin();
	                	   statementOfAccountReportWin.down('#downloadDetailAllStatementOfAccountReport').setDisabled(true);
	                	    // for code= DETAILED_STATEMENT_OF_ACCOUNT_DIT
							 var academyLocationId = $this.getCurrentAcademyLocation();
							 var outerForm = $this.getAccountstatementsearch().getForm();	                		   
							 var academyLocation = outerForm.findField('academyLocation');
							 var userTypeValue = outerForm.findField('recieptView').getValue();
							 var multiselectAcademyLocation=academyLocation.getValue();
							 var billedUserTypeEnumValue = outerForm.findField('recieptView').getRawValue();
							 var programCategoryId = outerForm.findField('programCategory').getValue();
							 var programGroupId =outerForm.findField('programGroup').getValue();
							 var programId=outerForm.findField('programName').getValue();
							 var batchId=outerForm.findField('batchName').getValue();
							 var seatTypeId=outerForm.findField('seatType').getValue();
							 var id=outerForm.findField('student').getValue();
							 var showAllStudents = outerForm.findField('showAllStudents').getValue();
							 var startDate = outerForm.getValues().startDate;
							 var tillDate = outerForm.getValues().tillDate;
							 var user=$this.getCurrentlyLoggedInUser();
							 var ALsId = [];
							 for(var i in multiselectAcademyLocation){
								 if(!isNullOrEmpty(multiselectAcademyLocation[i])&& typeof multiselectAcademyLocation[i]=='object'){
									 ALsId.push(multiselectAcademyLocation[i].data.id);
								}else{
									ALsId.push(multiselectAcademyLocation[i]);
								 }
							 } 
							 var statusField = outerForm.findField('STATUS');
							 if(statusField.getValue()==null){
								 statusField.setValue(true);
							 }
							 var studentIdArr = new Array();
							 Ext.Ajax.request({
	                  			 type: 'rest',
	                  			 url: SERVERURL.PATH_GET_ALL_STUDENT_IDS_FOR_FILTER_FORM_OF_STATEMENT_OF_ACCOUNT,
	                  			 method: 'GET',
	                  			 //async:true,
	                  			 timeout:420000,
	                  			 params: {
		                  			   id:id,
		                  			   statementFrom:startDate,
		                  			   statementTo:tillDate,
		                  			   programId:programId,
		                  			   batchId:batchId,
		                  			   billedUserType:outerForm.findField('recieptView').store.findRecord('value', billedUserTypeEnumValue).data.displayValue,
		                  			   status: statusField.getValue(),
		                  			   screenName: 'StatementOfAccount',
		                  			   programCategoryId:programCategoryId,
		                  			   programGroupId:programGroupId,
		                  			   seatTypeId:seatTypeId,
		                  			   academyLocationIds: ALsId.join(),
		                  			   whetherShowAllStudents : showAllStudents
	                  			 },
	                  			 success : function(response){
	                  				 if(!isNullOrEmpty(response) && !isNullOrEmpty(response.responseText)){
	                  					 statementOfAccountReportWin.close();
	                  					 var ids = Ext.decode(response.responseText)
	        							//start export report
	        							 var reportParams = new Object();
	        							 var reportTitle = 'StatementOfAccount';
	        							 //var code = 'DETAILED_STATEMENT_OF_ACCOUNT_DIT';
	        							 reportParams.code = code;
	        							 reportParams.reportTitle = reportTitle;
	        							 reportParams.studentIds = ids.join();
	        							 reportParams.screenName='StatementOfAccount';
	        							 reportParams.academyLocationIds=ALsId.join();
	        							 reportParams.billedUserType = outerForm.findField('recieptView').store.findRecord('value', billedUserTypeEnumValue).data.displayValue;
	        							 reportParams.status = statusField.getValue();
	        							 reportParams.statementFrom=startDate;
	        							 reportParams.statementTo=tillDate;
	        							 reportParams.programId=programId;
	        							 reportParams.batchId=batchId;
	        							 reportParams.programCategoryId=programCategoryId;
	        							 reportParams.programGroupId=programGroupId;
	        							 reportParams.seatTypeId=seatTypeId;
	        							 reportParams.id=id;
	        							 reportParams.userCode=user.code;
	        							 reportParams.whetherShowAllStudents=showAllStudents;
	        							 $this.exportJRXMLReport(code, reportParams, reportTitle, '.pdf', SERVERURL.PATH_EXPORT_REPORT_STATEMENT_OF_ACCOUNT_DIT);
	        							// end export report 
	        							 
	                  				 }else{
	                  					 statementOfAccountReportWin.close();
	                  				 }
	                  			 }
	                  		 });
							 
							
    					 
	                   },
	                   downloadStudentStatementOfAccountReport:function(code){

	                	   var $this =this;
							 var grid =  $this.getActualaccountstatementgrid();
							 var academyLocationId = $this.getCurrentAcademyLocation();
							 var records = grid.getSelectionModel().getSelection();
							 var outerForm = $this.getAccountstatementsearch().getForm();	                		   
							 var academyLocation = outerForm.findField('academyLocation');
							 var userTypeValue = outerForm.findField('recieptView').getValue();
							 var multiselectAcademyLocation=academyLocation.getValue();
							 var billedUserTypeEnumValue = outerForm.findField('recieptView').getRawValue();
							 var programCategoryId = outerForm.findField('programCategory').getValue();
							 var programGroupId =outerForm.findField('programGroup').getValue();
							 var programId=outerForm.findField('programName').getValue();
							 var batchId=outerForm.findField('batchName').getValue();
							 var seatTypeId=outerForm.findField('seatType').getValue();
							 var id=outerForm.findField('student').getValue();
							 var showAllStudents = outerForm.findField('showAllStudents').getValue();
							 //var whetherCancelledTransaction = outerForm.findField('includeAllCancelledTransaction').getValue();

							 var startDate = outerForm.getValues().startDate;
							 var tillDate = outerForm.getValues().tillDate;
							 var user=$this.getCurrentlyLoggedInUser();
							 var ALsId = [];
							 for(var i in multiselectAcademyLocation){
								 if(!isNullOrEmpty(multiselectAcademyLocation[i])&& typeof multiselectAcademyLocation[i]=='object'){
									 ALsId.push(multiselectAcademyLocation[i].data.id);
								 }else{
									 ALsId.push(multiselectAcademyLocation[i]);

								 }
							 } 
							 var studentIdArr = new Array();
							 for( var i=0; i<records.length; i++ ) {
								 if(!isNullOrEmpty(records[i].data.studentId)){
									 studentIdArr.push(records[i].data.studentId);
								 }
							 }
							 var statusField = outerForm.findField('STATUS');
							 if(statusField.getValue()==null){
								 statusField.setValue(true);
							 }
							 var reportParams = new Object();
							 var reportTitle = 'StatementOfAccount';
							 //var code = 'STATEMENT_OF_ACCOUNT_DIT';
							 reportParams.code = code;
							 reportParams.reportTitle = reportTitle;
							 reportParams.studentIds = studentIdArr.join(',');
							 reportParams.screenName='StatementOfAccount';
							 reportParams.academyLocationIds=ALsId.join();
							 reportParams.billedUserType = outerForm.findField('recieptView').store.findRecord('value', billedUserTypeEnumValue).data.displayValue;
							 reportParams.status = statusField.getValue();
							 reportParams.statementFrom=startDate;
							 reportParams.statementTo=tillDate;
							 reportParams.programId=programId;
							 reportParams.batchId=batchId;
							 reportParams.programCategoryId=programCategoryId;
							 reportParams.programGroupId=programGroupId;
							 reportParams.seatTypeId=seatTypeId;
							 reportParams.id=id;
							 reportParams.userCode=user.code;
							 reportParams.whetherShowAllStudents=showAllStudents;
							 //reportParams.whetherCancelledTransaction=whetherCancelledTransaction;
							 $this.exportJRXMLReport(code, reportParams, reportTitle, '.pdf', SERVERURL.STATEMENT_OF_ACCOUNT_EXPORT_REPORT_EXCEL);
    					 
	                   
	                   },
	                   fnpChangeAcademyLocationEventNew: function(obj,record){
	    		        	 var $this = this;
		                	   var form = $this.getAccountstatementsearch();
	    		        	//change :function(obj,record){
           				   var form = obj.up('form');
           				   var alField =form.down('#academyLocationId');
           				   var studentFld =form.down('#student');
           				   var programName = form.down('#programName');
           				   var programGroup = form.down('#programGroup');
           				   var programCategoryId = form.down('#programCategoryId');
           				   var multiselectAcademyLocation=alField.getValue();
           				   var ALsId = [];
           				   for(var i in multiselectAcademyLocation){
           					   if(multiselectAcademyLocation.length>0){
           						   ALsId.push(multiselectAcademyLocation[i]);
           					   }

           				   }
           				   if(ALsId.length == 0){
           					   var academyLocation = this.getCurrentAcademyLocation();
           				   }else{
           					   var academyLocation =  ALsId.join();
           				   }
           				   programName.getStore().getProxy().extraParams = {
           					   academyLocationIds:academyLocation,
           					   
           				   }
           				   programName.getStore().load();
           				  studentFld.getStore().getProxy().extraParams = {
										allStudents:true,
										academyLocationIds:ALsId.join()
									}
									studentFld.getStore().load();
									
									
									
           			   
	    		        },

});
