/**
 *  @author Rajkumar.patidar
 * 
 */
Ext.define('Academia.controller.feeandpayment.adjustment.AdjustmentController', {
	extend : 'Academia.controller.base.BaseController',
	models : ['feeandpayment.adjustment.ReceiptAdjustment','feeandpayment.adjustment.BillReceivable',
	          'feeandpayment.adjustment.FeeAdjustmentInstruments','feeandpayment.adjustment.AdjustmentForCash',
	          'feeandpayment.adjustment.ReceiptViewAdjustment','feeandpayment.adjustment.BillToBillAdjustment',
	          'feeandpayment.adjustment.AllBillsList','personinfo.common.pasthistory.HostelTrainingTypeGridMdl'],
	stores : ['feeandpayment.adjustment.ReceiptAdjustment','feeandpayment.adjustment.BillReceivable',
	          'feeandpayment.adjustment.FeeAdjustmentIntruments','feeandpayment.adjustment.PaymentAdjustment',
	          'feeandpayment.adjustment.ReceiptViewAdjustment','feeandpayment.adjustment.BillToBillAdjustment',
	          'feeandpayment.managebill.ThirdParties','feeandpayment.managebill.Sponsors','feeandpayment.managebill.Applicant',
	          'feeandpayment.managebill.User','feeandpayment.managebill.Student','feeandpayment.payment.ReceiptAndPaymentDetails',
	          'feeandpayment.common.BillSettlementViewDetails','feeandpayment.voucherMode.VoucherLinkType',
	          'feeandpayment.adjustment.AdjustmentFor','feeandpayment.adjustment.AdjustmentStatus',
	          'examinationcenters.IsTemplateMappedStore',
	          'feeandpayment.adjustment.AllBillsList','personinfo.common.pasthistory.HosetlTrainingTypeGridStr','personinfo.common.pasthistory.TransportDetailsGridStore',
	          'feeandpayment.dashboardAndReports.FeeStudentDetailsByStudentCodeStore','sponsorship.SponsorsListForSuspenseStore',
	          'feeandpayment.adjustment.StudentDetailsByStudentCodeForSponsorStore','feeandpayment.adjustment.InstrumentDetailSmartSearchStore',
	          'feeandpayment.receipts.FeeHeadDetails','feeandpayment.adjustment.BillNoSmartSearch','feeandpayment.adjustment.ReceiptNoSmartSearch','feeandpayment.adjustment.PaymentNoSmartSearch',
	          'feeandpayment.managebill.StudentDetailsByNationalId','feeandpayment.managebill.StudentDetailsByCodeAndAl','feeandpayment.adjustment.PaymentAdjustmentWithReceiptStore',
	          'feeandpayment.adjustment.ReceiptAdjustmentWithPaymentStore','feeandpayment.adjustment.ReceiptPaymentViewAdjustmentStore'],
	views : ['feeandpayment.adjustment.AdjustmentStructure','feeandpayment.adjustment.ReceiptsList',
	         'feeandpayment.adjustment.InstumentDetailsList','feeandpayment.adjustment.BillReceivableList',
	         'feeandpayment.adjustment.PaymentsList','feeandpayment.adjustment.ReceiptViewGridWindow',
	         'feeandpayment.adjustment.BillList','feeandpayment.adjustment.AdjustmentFilters',
	         'feeandpayment.adjustment.AdjustmentForm','common.AddressDetailPanel',
	         'feeandpayment.adjustment.AdjustmentTabStructure','feeandpayment.adjustment.AdjustmentProgressTracker','personinfo.common.pasthistory.HostelPersonDetailsGrid',
	         'personinfo.common.pasthistory.TransportPersonDetailsGrid','feeandpayment.receipts.FeeHeadDetailsWindow','personinfo.common.paymentandrefund.ReceiptGridForApplicant',
             'admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionPaymentsGrid','admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionRefundsGrid',
             'feeandpayment.reports.FeeHeadWiseCollectionReportForm','feeandpayment.reports.FeeHeadWiseCollectionReportGrid','feeandpayment.reports.ApplicantFeeHeadWiseCollectionReportForm','feeandpayment.reports.ApplicantFeeHeadWiseCollectionReportGrid',
				'programCourseDashboard.organizationUnit.OrganizationUnit','feeandpayment.receipts.ManageReceiptForm','feeandpayment.adjustment.PaymentsListForReceiptSettlement','feeandpayment.adjustment.ReceiptsListForPaymentSettlement',
				'feeandpayment.payment.ReceiptAndPaymentViewAdjustmentWindow'],
	         config: {
	 	  		CANCELSETTLEMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CANCELSETTLEMENTS_PRIVILEGES'),  		  
	 	  		SAVEBUTTON_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SAVEBUTTON_PRIVILEGES') , 		  
	 	  		PRINTBUTTON_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PRINTBUTTON_PRIVILEGES'),
	 	  		MANAGESETTLEMENT_MAP_ACADEMY_LOCATION_PETMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MAP_ACADEMY_LOCATIONS_PRIVILEGES'),
	 	  		PERFORM_SETTELEMENT_RADIOBTN_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PERFORM_SETTELEMENT_RADIOBTN_PRIVILEGES'),
	 	  		PAYMENT_RECEIVED_HISTORY_GRID_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_PAYMENT_RECIEVED_PRIVILEGES'),
	 	  		APPLICATIONS_RECIEPT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_RECEIPT_PRIVILEGES')
	             
	         },
	refs : [{
        	   ref:'receiptslist',
        	   selector:'receiptslist'
	       },{
	    	   ref:'adjustmentstructure',
	    	   selector:'adjustmentstructure'
	       },{
	    	   ref:'instumentdetailslist',
	    	   selector:'instumentdetailslist'
	       },{
	    	   ref:'billreceivablelist',
	    	   selector:'billreceivablelist'
	       },{
	    	   ref:'receiptviewgridwindow',
	    	   selector:'receiptviewgridwindow'
	       },{
	    	   ref:'paymentslist', 
	    	   selector:'paymentslist'
	       },{
	    	   ref:'receiptandpaymentgridwindow',
	    	   selector:'receiptandpaymentgridwindow'
	       },{
	    	   ref:'receiptAndPaymentGrid',
	    	   selector:'receiptandpaymentgridwindow grid'
	       },{
	    	   ref:'billlist',
	    	   selector:'billlist'
	       },{
	    	   ref:'adjustmentAddressDetailPanel',
	    	   selector:'addressdetailpanel[itemId=adjustmentaddressdetailpanel]'
	       },{
	    	   ref:'adjustmentFilters',
	    	   selector:'adjustmentfilters'
	       },{
	    	   ref: 'allbillslist',
	    	   selector: 'allbillslist'
	       },{
	    	   ref : 'pendingbillsgrid',
	    	   selector : 'pendingbillsgrid'
	       },{
	    	   ref : 'paymentreceivedhistorygrid',
	    	   selector : 'paymentreceivedhistorygrid'
	       },{
	    	   ref : 'refundhistorygrid',
	    	   selector : 'refundhistorygrid'
	       },{
	    	   ref:'contentPanel',
	    	   selector:'contentPanel'
	       },{
	    	   ref : 'hostelpersondetailsgrid',
	    	   selector : 'hostelpersondetailsgrid[itemId=adjustmenthostelpersondetailsgrid]'
	       },{
          	 ref : 'transportpersondetailsgrid',
        	 selector : 'transportpersondetailsgrid[itemId=adjustmenttransportpersondetailsgrid]'
         },{
          	 ref : 'adjustmentform',
        	 selector : 'adjustmentform'
         },{
        	 ref : 'adjustmenttabstructure',
        	 selector : 'adjustmenttabstructure'
         },{
        	 ref : 'feeheaddetailswindow',
        	 selector : 'feeheaddetailswindow'
         },{
       	   ref : 'receiptgridforapplicant',
    	   selector : 'receiptgridforapplicant' 
       }
       ,{
     	   ref : 'preadmissionpaymentsgrid',
    	   selector : 'preadmissionpaymentsgrid' 
       },{
     	   ref : 'preadmissionrefundsgrid',
    	   selector : 'preadmissionrefundsgrid' 
       },{
			ref : 'feeheadwisecollectionreportform',
			selector : 'feeheadwisecollectionreportform'
		},{
			ref : 'feeheadwisecollectionreportgrid',
			selector : 'feeheadwisecollectionreportgrid'
		},
		{
			ref:'applicantfeeheadwisecollectionreportform',
			selector:'applicantfeeheadwisecollectionreportform'
		},
		{
			ref:'applicantfeeheadbasedcollectionreportgrid',
			selector:'applicantfeeheadbasedcollectionreportgrid'
		},{
			ref:'applicantfeeheadwisecollectionreportgrid',
			selector:'applicantfeeheadwisecollectionreportgrid'
		},{
			ref : 'organizationunit',
			selector : 'organizationunit'
		},{
     	   ref:'managereceiptform',
    	   selector:'managereceiptform'
       },{
    	   ref:'paymentslistforreceiptsettlement',
    	   selector:'paymentslistforreceiptsettlement'
       },{
    	   ref:'receiptslistforpaymentsettlement',
    	   selector:'receiptslistforpaymentsettlement'
       },{
    	   ref:'paymentslistforreceiptsettlement',
    	   selector:'paymentslistforreceiptsettlement'
       },{
    	   ref:'receiptslistforpaymentsettlement',
    	   selector:'receiptslistforpaymentsettlement'
       },{
    	   ref:'receiptandpaymentviewadjustmentwindow',
    	   selector:'receiptandpaymentviewadjustmentwindow'
       }],
      init : function() {
    	  var triggerBlur = true;
           this.billHeaderIdForMsg=null;
           this.receiptHeaderIdForMsg=null;
          this.paymentHeaderIdForMsg=null;
          this.selectedPaymentId=null;
          this.selectedReceiptId=null;
          this.isVisibleSettleWithCheckBox=false;
    	  this.control({
    		  'adjustmentfilters':{
    			  render : this.getRenderAdjustmentFilters
    		  },
    		  'adjustmentstructure customcombobox[itemId=adjustmentFor]':{
    			  change:this.getCheckAdjustmentFor
    		  },
    		  'adjustmentstructure customcombobox[itemId=adjustment]':{
    			  select:this.getCheckAdjustment
    		  },
    		  'adjustmentstructure button[itemId=searchBtn]' : {
    			  click:this.getSearchSettlementDetails
    			  
    			 /* */
    		  },
    		  'paymentslist':{
    			  cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	 
                       this.paymentHeaderIdForMsg=record.data.id;
    				  var paymentsGrid = this.getPaymentslist();
    				  if(e.target.tagName=='A'){
    					  this.getViewAdjustment(paymentsGrid,record);
    				  }else{
    					  this.getCheckedPaymentListing(paymentsGrid,record);
    				  }
    			  },
    			  render : function(obj,record){
    				  var form=this.getPaymentslist();
    				 // this.doAccessControlValidation(obj, this.getCANCELSETTLEMENTS_PERMISSIONS());
    				 this.disableCancelPivileges(form,this.getCANCELSETTLEMENTS_PERMISSIONS());
    			  }
    		  },
    		  'receiptslist':{
    			  cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	                  var $this=this;
                  this.receiptHeaderIdForMsg=record.data.id;
    				  var receiptGrid = this.getReceiptslist();
    				  if(e.target.tagName=='A'){
    					  this.getViewAdjustment(receiptGrid,record);
    				  }
                     else{
                        Ext.Ajax.request({
			                 method : "GET",
			                  type : 'rest',
			                   url: SERVERURL.FIND_RECEIPT_STATUS,
			                    params: {
			                    	receiptId : record.data.id,
			                    	},
			                    headers : {
			                    	 'Content-Type' : 'application/json'
			                    	 },
			                     success: function(response) {
			                     var data = Ext.decode(response.responseText);
			                     if(data) {
				                  showWarningMessage(getCommonTranslation('ALERT'), getFeeAndPaymentCommonTranslation('SELECTED_RECEIPT_ALREADY_CANCELLED'));
				                  receiptGrid.getStore().reload();
				                    }
                                else{
    					        $this.getCheckedReceiptListing(receiptGrid,record);  
                                }
			                      }
			                    	});
                                        }
    			  },
    			  render : function(obj,record){
    				  var form=this.getReceiptslist();
    				 /* this.doAccessControlValidation(obj, this.getCANCELSETTLEMENTS_PERMISSIONS());
    				  this.doAccessControlValidation(obj, this.getPRINTBUTTON_PERMISSIONS());*/
    				  this.disablePrintPivileges(form,this.getPRINTBUTTON_PERMISSIONS());
    				  this.disableCancelPivileges(form,this.getCANCELSETTLEMENTS_PERMISSIONS());
    			  },
    			  afterrender:function(grid){
						var me = this;
						setTimeout(function(){
							me.addDataGridConfigButton(grid, me.getPRINTBUTTON_PERMISSIONS());
						},1500);
					}
    		  },
    		  'instumentdetailslist':{
    			  select :function($this, record, index){
    				  this.getCheckedInstumentListing($this, record, index, 'select');
    			  },
    			  deselect :function($this, record, index){
    				  this.getCheckedInstumentListing($this, record, index, 'deselct');
    			  },
    			  afterrender:function(grid){
						var me = this;
						setTimeout(function(){
							me.addDataGridConfigButton(grid, me.getPRINTBUTTON_PERMISSIONS());
						},1500);
					}
    			  
    		  },
    		  'allbillslist':{
    			  select :function($this, record, index){
    				  this.getCheckedAllBillsListing($this, record, index, 'select');
    			  },
    			  deselect :function($this, record, index){
    				  this.getCheckedAllBillsListing($this, record, index, 'deselct');
    			  },
    			  cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    				  var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
    				  var $this =this;
    				  if(columnName == "adjustmentDetails"){
    					  if(e.target.tagName=='A'){
    						  this.getViewBillReceivablePaybleAdjustmentView(grid,record);
    					  }
    				  }
    				  if(columnName == "feeHeadDetails"){
    					  if(e.target.tagName=='A'){
    						  this.getViewBillReceivablePaybleFeeHeadDetailsView(grid,record);
    					  }
    				  }
    			  },
    			  /*cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
  		    		 if(cellIndex==8){
  		    			 if(e.target.tagName=='A'){
  		    				 this.getViewBillReceivablePaybleAdjustmentView(grid,record);
  		    			 }
  		    		 }
  		    	 }*/
    			  afterrender:function(grid){
    				  var me = this;
    				  var structure = this.getAdjustmentstructure();
    				  var form = structure.down('adjustmentfilters');
    				  var manageSettlementCurrency =  form.down("#manageSettlementCurrency");
    				  var allBillsList = this.getAllbillslist();

    				  setTimeout(function(){
    					  me.addDataGridConfigButton(grid, me.getPRINTBUTTON_PERMISSIONS());
    					  if(manageSettlementCurrency.getValue().currencyType == true){
    						  var columns = allBillsList.columns;
    						  for(var i in columns) {
    							  if (columns[i].dataIndex == "currencyExchangeRate" || columns[i].dataIndex == "convertedBalanceAmount") {
    								  columns[i].hide();
    							  }
    						  }  
    					  }else{
    						  var columns = allBillsList.columns;
    						  for(var i in columns) {
    							  if (columns[i].dataIndex == "currencyExchangeRate" || columns[i].dataIndex == "convertedBalanceAmount") {
    								  columns[i].show();
    							  }
    						  }    
    					  }

    				  },1500);
    			  }
    		  },
    		  'billlist':{
    			  cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    				  var billGrid = this.getBilllist();
                        this.billHeaderIdForMsg=record.data.billHeaderId;
    				  if(e.target.tagName=='A'){
    					  this.getViewBillReceivableAdjustment(billGrid,record);
    				  } else{
    					  this.getCheckedBillListing(billGrid,record);
    				  }
    			  },
    			  render : function(obj,record){
    				  var form=this.getBilllist();
    				  //  this.doAccessControlValidation(obj, this.getCANCELSETTLEMENTS_PERMISSIONS());
    				  this.disableCancelPivileges(form,this.getCANCELSETTLEMENTS_PERMISSIONS());
    			  }
    		  },
     		     'billreceivablelist button[itemId=saveBtn]':{
     		    	 click : function(obj){
     		    		 $this=this;
     		    		 var form = this.getAdjustmentstructure();
     		    		 var adjustment = form.down("#adjustment").getValue();
     		    		 var gridBill= $this.getBillreceivablelist()
     		    		 var record = gridBill.getSelectionModel().getSelection()[0];
     		    		 if(isNullOrEmpty(record)){
     		    			 return showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
     		    		 }
     		    		 obj.setDisabled(true);
    				  var billType=record.get("raiseBillCategory");
                          var billHeaderId = record.get("billHeaderId");
    				  var receiptHeaderIdParam;
                          var billHeaderIdParam;
    				  var creditNoteIdParam;
    				  var paymentHeaderIdParam;

    				  //Going Via Reciept (For Receipt Cancellation check) on ManageSettlement Screen 
    				  receiptHeaderIdParam=this.receiptHeaderIdForMsg;

    				  //Going Via Payment(For Payment Cancellation Check)on ManageSettlement Screen 
    				  paymentHeaderIdParam=this.paymentHeaderIdForMsg;


    				  if((this.billHeaderIdForMsg==undefined ||this.billHeaderIdForMsg==null)&&this.paymentHeaderIdForMsg==null){  
    					  //Going Via Receipt(For Bill Cancellation check) on ManageSettlement Screen 
    					  billHeaderIdParam=billHeaderId;
                           }
                          else{
    					  //Going Via Bill & Payment(For Bill and Credit Note Cancellation Check ) on ManageSettlement Screen
	                          billHeaderIdParam=this.billHeaderIdForMsg;
    					  creditNoteIdParam=billHeaderId;
    				  }
    				  Ext.Ajax.request({
    					  method : "GET",
    					  type : 'rest',
    					  url: SERVERURL.FIND_BILL_STATUS,
    					  params: {
    						  billId : creditNoteIdParam,
    					  },
    					  headers : {
    						  'Content-Type' : 'application/json'
    					  },
    					  success: function(response) {
    						  this.billHeaderIdForMsg=null;
    						  var data = Ext.decode(response.responseText);
    						  if(data) {
    							  showWarningMessage(getCommonTranslation('ALERT'), getFeeAndPaymentCommonTranslation('SELECTED_CREDIT_NOTE_ALREADY_CANCELLED'));
    							  obj.setDisabled(false);
	                           }
    						  else{

                         Ext.Ajax.request({
			                 method : "GET",
			                  type : 'rest',
			                   url: SERVERURL.FIND_BILL_STATUS,
			                    params: {
			                    	billId : billHeaderIdParam,
			                    	},
			                    headers : {
			                    	 'Content-Type' : 'application/json'
			                    	 },
			                     success: function(response) {
    									  this.billHeaderIdForMsg==null;
			                     var data = Ext.decode(response.responseText);
			                     if(data) {
				                   showWarningMessage(getCommonTranslation('ALERT'), getFeeAndPaymentCommonTranslation('SELECTED_BILL_ALREADY_CANCELLED'));
				                   obj.setDisabled(false);
				                    }
    									  else {
    										  Ext.Ajax.request({
    											  method : "GET",
    											  type : 'rest',
    											  url: SERVERURL.FIND_PAYMENT_STATUS,
    											  params: {
    												  paymnetHeaderId : paymentHeaderIdParam,
    											  },
    											  headers : {
    												  'Content-Type' : 'application/json'
    											  },
    											  success: function(response) {
    												  this.paymentHeaderIdForMsg=null;
    												  var data = Ext.decode(response.responseText);
    												  if(data) {
    													  showWarningMessage(getCommonTranslation('ALERT'), getFeeAndPaymentCommonTranslation('SELECTED_PAYMENT_ALREADY_CANCELLED'));
    													  obj.setDisabled(false);

    												  }
    												  else{
    													  Ext.Ajax.request({
    														  method : "GET",
    														  type : 'rest',
    														  url: SERVERURL.FIND_RECEIPT_STATUS,
    														  params: {
    															  receiptId : receiptHeaderIdParam,
    														  },
    														  headers : {
    															  'Content-Type' : 'application/json'
    														  },
    														  success: function(response) {
    															  this.receiptHeaderIdForMsg=null;
    															  var data = Ext.decode(response.responseText);
    															  if(data) {
    																  showWarningMessage(getCommonTranslation('ALERT'), getFeeAndPaymentCommonTranslation('SELECTED_RECEIPT_ALREADY_CANCELLED'));
    																  obj.setDisabled(false);
    															  }
                                 else if(adjustment=='RECEIPT'){
     		    			        $this.getSaveReceiptDeatils();
     		    			       obj.setDisabled(false);
     		    		         }else if(adjustment=='PAYMENT'){
     		    			           $this.getSavePaymentDeatils();
     		    			          obj.setDisabled(false);
     		    		          }else if(adjustment=='BILL'){
     		    			           $this.getSaveBillDeatils();
     		    			          obj.setDisabled(false);
     		    		          }
			                      }
			                    	});
    												  }
    											  }
    										  });
    									  }
    								  }
    							  });
    						  }
    					  }
    				  });

     		    		 
     		    	/*	var adjustmentform = this.getAdjustmentform();
     		    		adjustmentform.down('panel').scrollBy(0,1);
     		    		adjustmentform.down('panel').scrollBy(0,-1);
     		    		 if(form.up('panel'))
     		    		 {
     		    			form.up('panel').scrollBy(0,1);
     		    			form.up('panel').scrollBy(0,-1);
     		    		 }*/
     		    	 }
     		     },
     		     'billreceivablelist numberfield[itemId=amountToBeAdjusted]':{
     		    	 focus : function(obj){
     		    		 var billReceivableGrid = obj.ownerCt.grid;
     		    		 var selectedRow = billReceivableGrid.getSelectionModel().getSelection()[0];
     		    		 var rowIndex = billReceivableGrid.store.indexOf(selectedRow);
     		    		 Ext.apply(billReceivableGrid, {
     		    			 rowIndexes:null,
     		    			 setRowIndexes: function(rowIndexes) {
     		    				 billReceivableGrid.rowIndexes = rowIndexes;
     		    			 },
     		    			 getRowIndexes: function() {
     		    				 return billReceivableGrid.rowIndexes;
     		    			 }
     		    		 });
     		    		 billReceivableGrid.setRowIndexes(rowIndex);

     		    		 this.setMaxAmountLimit(obj);
     		    	 },
     		    	 specialkey: function(f, e) {
     		    		 if (e.getKey() == e.ENTER || e.getKey() == e.ESC) {
     		    			 triggerBlur=false;
     		    		 }
     		    	 },
     		    	 blur: function(obj,event,eOpt){
     		    		 if(triggerBlur==true){
     		    			 this.getCalulationForBalanceAmount(obj);
     		    		 }
     		    		 triggerBlur=true;
     		    	 }
     		     },
     		    'allbillslist numberfield[itemId=amountToBeAdjusted]':{
     		    	focus : function(obj){
     		    		var allBillListGrid = obj.ownerCt.grid;
     		    		var selectedRow = allBillListGrid.getSelectionModel().getSelection()[0];
     		    		var rowIndex = allBillListGrid.store.indexOf(selectedRow);
     		    		Ext.apply(allBillListGrid, {
     		    			rowIndexes:null,
     		    			setRowIndexes: function(rowIndexes) {
     		    				allBillListGrid.rowIndexes = rowIndexes;
     		    			},
     		    			getRowIndexes: function() {
     		    				return allBillListGrid.rowIndexes;
     		    			}
     		    		});
     		    		allBillListGrid.setRowIndexes(rowIndex);

     		    		this.setMaxAmountLimitForBillList(obj);
     		    	},
     		    	specialkey: function(f, e) {
     		    		if (e.getKey() == e.ENTER || e.getKey() == e.ESC) {
     		    			triggerBlur=false;
     		    		}
     		    	},
     		    	blur: function(obj,event,eOpt){
     		    		if(triggerBlur==true){
     		    			this.getCalulationForBalanceAmountForBillList(obj);
     		    		}
     		    		triggerBlur=true;
     		    	}
    		     },
     		     'billreceivablelist':{
     		    	 select : function(grid,selected, eOpts){
     		    		 var billReceivableGrid = this.getBillreceivablelist();
//     		    		 billReceivableGrid.focus();
     		    	 },
     		    	 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
     		    		 var cellDataIndex = grid.getGridColumns()[cellIndex].dataIndex;
     		    		 if(cellIndex==9 || cellDataIndex == 'viewAdjustments'){
     		    			 if(e.target.tagName=='A'){
     		    				 this.getViewBillReceivableAdjustment(grid,record);
     		    			 }
     		    		 }
     		    	 },
     		    	 afterrender:function(grid){
     		    		  var me = this;
        				  var structure = this.getAdjustmentstructure();
        				  var form = structure.down('adjustmentfilters');
        				  var manageSettlementCurrency =  form.down("#manageSettlementCurrency");
 						setTimeout(function(){
 							me.addDataGridConfigButton(grid, me.getPRINTBUTTON_PERMISSIONS());
 							 if(manageSettlementCurrency.getValue().currencyType == true){
 	    						  var columns = grid.columns;
 	    						  for(var i in columns) {
 	    							  if (columns[i].dataIndex == "currencyExchangeRate" || columns[i].dataIndex == "convertedBalanceAmount") {
 	    								  columns[i].hide();
 	    							  }
 	    						  }  
 	    					  }else{
 	    						  var columns = grid.columns;
 	    						  for(var i in columns) {
 	    							  if (columns[i].dataIndex == "currencyExchangeRate" || columns[i].dataIndex == "convertedBalanceAmount") {
 	    								  columns[i].show();
 	    							  }
 	    						  }    
 	    					  }
 						},1500);
 					}
     		     },
     		   'allbillslist button[itemId=saveBtnAllBillBtn]':{
	   		    	 click : function(obj){
	   		    		 this.saveBillSettelmentDetails(obj);
	   		    	 }
	   		     },
    		  'adjustmentstructure button[itemId=btnReset]':{
    			  click:this.getResetForCashAndBank
    		  },
    		  'adjustmentstructure button[itemId=resetBtn]':{
    			  click:function(){
    				  var form = this.getAdjustmentstructure();
    				  form.down("#thirdParty").clearValue();
    				  form.down("#sponsors").clearValue();
    				  form.down("#applicant").clearValue();
    				  form.down("#userId").clearValue();
    				  form.down("#student").clearValue();
    				  form.down("#instrumentNumberId").reset();
    				  form.down("#instrumentNumberId").setDisabled(true);
    				  form.down("#billNoId").reset();
    				  form.down("#billNoId").setDisabled(true);
    				  form.down("#receiptNoId").reset();
    				  form.down("#receiptNoId").setDisabled(true);
    				  form.down("#paymentNoId").reset();
    				  form.down("#paymentNoId").setDisabled(true);
    				  
    				  
    				  var addresDetailPanel = this.getAdjustmentAddressDetailPanel();	
    	        	//  addresForm.getForm().reset();
    				  var addressForm=addresDetailPanel.getForm();
    				  var nameField = addressForm.findField('name');
    				  nameField.reset();
    				  var fatherNameField = addressForm.findField('fatherName');
    				  fatherNameField.reset();
    				  var addressField = addressForm.findField('address');
    				  addressField.reset();
    				  var emailIdField = addressForm.findField('emailId');
    				  emailIdField.reset();
    				  var contactNoField = addressForm.findField('contactNo');
    				  contactNoField.reset();
    				  var addmissionIdField = addressForm.findField('addmissionId');
    				  addmissionIdField.reset();
    				  var applicationIdField = addressForm.findField('applicationId');
    				  applicationIdField.reset();
    				  var actualUserId = addressForm.findField('actualUserId');
    				  actualUserId.reset();
    				  var applicantIdField = addressForm.findField('applicantId');
    				  applicantIdField.reset();
    				  var programField = addressForm.findField('program');
    				  programField.reset();
    				  var batchField = addressForm.findField('batch');
    				  batchField.reset();
    				  var periodField = addressForm.findField('period');
    				  periodField.reset();
    				  var sectionField = addressForm.findField('section');
    				  sectionField.reset();
    				  var seatTypeField = addressForm.findField('seatType');
    				  seatTypeField.reset();
    				  var totalAcadInvoiceAmountField = addressForm.findField('totalAcadInvoiceAmount');
    				  totalAcadInvoiceAmountField.reset();
    				  var totalAcadReceiptAmountField = addressForm.findField('totalAcadReceiptAmount');
    				  totalAcadReceiptAmountField.reset();
    				  var totalAcadPaymentAmountField = addressForm.findField('totalAcadPaymentAmount');
    				  totalAcadPaymentAmountField.reset();
    				  var totalConvertedOutstandingField = addressForm.findField('totalConvertedOutstanding');
    				  totalConvertedOutstandingField.reset();
    				  var totalAcadDicountAmountField = addressForm.findField('totalAcadDicountAmount');
    				  totalAcadDicountAmountField.reset();
    				  var totalAcadLocAdvanceAmountField = addressForm.findField('totalAcadLocAdvanceAmount');
    				  totalAcadLocAdvanceAmountField.reset();
    				  
    				  var structure = this.getAdjustmentstructure();
        			  var adjustmentform = structure.down('adjustmentfilters');    				  
        		      var adjustmentFor = adjustmentform.down("#adjustmentFor");
        		      var adjustment = adjustmentform.down("#adjustment");
        		      var showAllSettlement = adjustmentform.down("#showAllSettlementId");
        		      var fnpBrandCampusItem = adjustmentform.down("#fnpBrandCampusItemId");
        		      var alFilterField = adjustmentform.down("#fnpBrandCampusItemId");
        		      var academyLocationId = this.getCurrentAcademyLocation();
        		    	  
        		    	  adjustment.store.load();
        		    	  
        		    	  var adjustmentForStore = adjustmentFor.getStore();
        		    	  adjustmentForStore.load({
        		    		  callback: function(record, operation, success) {
        		    			  if (success) {
        		    				  adjustmentFor.setValue(record[0].data.id);
        		    			  }
        		    		  }
        		    	  });

        		    	  var adjustmentStore = adjustment.getStore();
        		    	  adjustmentStore.load({
        		    		  callback: function(record, operation, success) {
        		    			  if (success) {
        		    				  adjustment.setValue(record[1].data.id);
        		    			  }
        		    		  }
        		    	  });

        		    	  var showAllSettlementStore = showAllSettlement.getStore();
        		    	  showAllSettlementStore.load({
        		    		  callback: function(record, operation, success) {
        		    			  if (success) {
        		    				  showAllSettlement.setValue(record[0].data.id);
        		    			  }
        		    		  }
        		    	  });
        		    	 
         				 
         				 var alFilterStore = alFilterField.getStore();
         				 alFilterStore.load({
         					 callback: function(record, operation, success) {
         						 if (success) {
         							 alFilterField.setValue(academyLocationId);
         						 }
         					 }
         				 });
    				  
    				  
    				  addresDetailPanel.collapse();
    	        	  this.resetProgressTracker();
    	        	  Ext.resumeLayouts();
    			  }
    		  },
    		 'paymentslist button[itemId=cancelSettlementLink]':{
      			 click: function(){
      				var grid = this.getPaymentslist();
      				if (grid.getSelectionModel().getCount() > 0) {
      				  var records = grid.getSelectionModel().getSelection()[0];
      				  var id = records.get("id");
      				  this.getCancelSettlements(id);
      				}else{
      					Ext.getBody().unmask();
      					showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
      				}
      			 }
      		 },
      		'receiptslist button[itemId=cancelSettlementLink]':{
     			 click:function(grid1){
     				var grid = this.getReceiptslist();
     				if (grid.getSelectionModel().getCount() > 0) {
        				  var records = grid.getSelectionModel().getSelection()[0];
        				  var id = records.get("id");
        				  this.getCancelSettlements(id);
        				}else{
        					showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record	
        				}
     			 }
     		 },
     		'billlist button[itemId=cancelSettlementLink]':{
    			 click:function(){
    				 var grid = this.getBilllist();
    				 if (grid.getSelectionModel().getCount() > 0) {
         				  var records = grid.getSelectionModel().getSelection()[0];
         				  var id = records.get("billHeaderId");
         				  var billFeePlanRuleStageId = records.get('billFeePlanRuleStageId');
         				  this.getCancelSettlements(id,billFeePlanRuleStageId);
         				}else{
         					 showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record	
         				}
    			 }
    		 },
    		 'receiptslist button[itemId=btnPrint]':{
    			 click : function(){
    				 this.exportJRXML('pdf');
    			 }
    		 },
    		 'adjustmentfilters customcombobox[itemId=thirdParty]':{
    			 select : this.setAddressForThirdParty
    		 },
    		 'adjustmentfilters customcombobox[itemId=applicant]':{
    			 select : this.setAddressForApplicant
    		 },
    		 'adjustmentfilters customcombobox[itemId=sponsors]':{
    			 select : this.setAddressForSponsors
    		 },
    		 'adjustmentfilters customcombobox[itemId=userId]':{
    			 select : this.setAddressForUser
    		 },
    		 'adjustmentfilters customcombobox[itemId=student]':{
    			 select : this.setAddressForStudent,
    			 afterrender: function(combo) {
    				 var form = combo.up('form'),
    				 inActiveStudentCheckBox =form.down('#inActiveStudentItemId');
    				 store = combo.getStore();
    				 store.on('beforeload',function() {
    					 if(inActiveStudentCheckBox){
    						 store.getProxy().setExtraParam('isInactive', inActiveStudentCheckBox.getValue());
    					 }
    				 }, this);
    			 }
    		 },
    		 'adjustmentfilters customcombobox[itemId=fnpBrandCampusItemId]': {
    			 render: function(){
    				 var $this = this;
    				 var filter = $this.getAdjustmentFilters();
    				 var academyLocationId = $this.getCurrentAcademyLocation();
    				 var alFilterField = filter.down("#fnpBrandCampusItemId");
    				 var alFilterStore = alFilterField.getStore();
    				 alFilterStore.load({
    					 callback: function(record, operation, success) {
    						 if (success) {
    							 alFilterField.setValue(academyLocationId);
    						 }
    					 }
    				 });
    			 },
    			 select : function(obj,record) { 
					 var $this = this;
					 setTimeout(function(){
						 $this.fnpChangeAcademyLocationEvent(obj,record);
	            		},300);
				 }
    		 },
    		 'adjustmenttabstructure multiselectcombofield[itemId=fnpMultiBrandCampusAdjustmentItemId]': {
    			 render: function(){
    				 var $this = this;
    				 var formLayout = $this.getAdjustmenttabstructure();
    				 var academyLocationId = this.getCurrentAcademyLocation();
    				 var fnpBrandCampusId = formLayout.down('#fnpMultiBrandCampusAdjustmentItemId');
    				 var ALComboStore = fnpBrandCampusId.getStore();
    				 ALComboStore.load({
    					 callback: function(records, operation, success) {
    						 if (success) {
    							 for(var i in records){
    								   if(records[i].data.id==academyLocationId){
    									   fnpBrandCampusId.setValue(academyLocationId);
    								   }
    							   }
    						 }
    					 }
    				 });
    				 var studentField = formLayout.down('#studentNameId');
    				 var studentStore = studentField.getStore();
    				 studentStore.getProxy().extraParams = {
    					 academyLocationIds: academyLocationId,
    				 };
    				 studentStore.load();
    			    },

    			    change : function(obj,record) { 
					var $this = this;
					setTimeout(function(){
						$this.fnpChangeAcademyLocationEventNew(obj,record);
					},300);
				}

    			 /*select : function(obj, record) {
    				 this.fnpChangeAcademyLocationEventManagePayment(obj, record);
    			 }*/
    		 },
    		 /*
    		  * for new changes
    		  */
    		 'receiptslist button[itemId=nextBtn]':{
    			 click : this.receiptNextTab
      		 },
      		 'instumentdetailslist button[itemId=nextInstrumentBtn]':{
   			      click : this.instrumentNextTab
     		 },
     		 'paymentslist button[itemId=nextBtn]':{
    			 click : this.paymentNextTab
      		 },
      		'billlist button[itemId=nextBtn]':{
      			click : this.billNextTab
     		 },
     		'allbillslist button[itemId=nextBtnAllBillBtn]':{
      			click : this.allbillNextTab
     		 },
     		 
     		'addressdetailpanel[itemId=adjustmentaddressdetailpanel] displayfield[itemId=statementaccountId]':{
   			   render: function(component) {
   				   var $this =this;
   				   var infoPanel = $this.getAdjustmentAddressDetailPanel();
   				   if(!isNullOrEmpty(infoPanel)) {
   					   infoPanel.down('#statementaccountId').setValue("<a href='#'>Statement of Account</a>");
   					   component.getEl().on('click', function(e) {
   						   if(e.target.tagName=='A'){
   							   var path = SERVERURL.IS_ACCOUNT_CFG_EXISTS_OR_NOT+"?academyLocationId="+$this.getCurrentAcademyLocation();
   							   Ext.Ajax.request({
   								   url: path,
   								   method: 'GET',
   								   success: function(response) {
   									   var responseData = Ext.decode(response.responseText);
   									   if(responseData) {
   										   var form = $this.getAdjustmentFilters();
   										   var studentId = form.down('#student').getValue();
   										   if(!isNullOrEmpty(studentId)){
   											   var contentpanel = $this.getContentPanel();
   											   Academia.app.getController('Academia.controller.feeandpayment.AccountStatementReportController');
   											   var accountstatmentstructure = Ext.widget('accountstatmentstructure');
   											   var tabName = 'Statement of Account';
   											   /**
   											    * This is to remove tab from content panel and open same tab again 
   											    */
   											   var getcontroller=$this.getController('menu.CoreERPNavigationController');
   											   var getTab=getcontroller.getTab(tabName);
   											   if(getTab!=null){
   												   contentpanel.remove(getTab, true);
   											   }
   											   openTab(contentpanel, tabName, accountstatmentstructure, CONSTANTS.MENU_COLOR_FIVE);
   											   var frm = accountstatmentstructure.down('form');
   											   var student = frm.down('#student');
   											   var recieptView = frm.down('#recieptView');
   											   student.getStore().load({
   												   callback:function(rec) {
   													   for (var i in rec) {
   														   if(rec[i].data.id==studentId) {
   															   student.setValue(studentId);
   														   }
   													   }
   												   }
   											   });
   											   var gird = accountstatmentstructure.down('grid');
   											   gird.getStore().getProxy().extraParams={
   												   id:studentId,
   												   billedUserType:'STUDENT'
   											   };
   											   gird.getStore().load();
   										   } else {
   											   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SELECT_STUENT'));
   										   }
   									   } else {
   										   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ACCOUNTING_CFG_IS_NOT_DONE_MSG'));
   									   }
   								   }
   							   });
   						   }
   					   });    
   				   }
   			   }
   		   },
   		 'addressdetailpanel[itemId=adjustmentaddressdetailpanel] displayfield[itemId=feeheadwisedistributionId]':{
			 render: function(component) {
				 var $this =this;
				 var infoPanel = $this.getAdjustmentAddressDetailPanel();
				 if(!isNullOrEmpty(infoPanel)) {
					 var  detail = getCommonTranslation('FEE_HEADWISE_DISTRIBUTION');
					 infoPanel.down('#feeheadwisedistributionId').setValue("<a href='#'>"+detail+"</a>");
					 component.getEl().on('click', function(e) {
						 if(e.target.tagName=='A'){

							 var billFlayOutForm = $this.getAdjustmentFilters();
 							   
 							   var studentId = billFlayOutForm.down('#student').getValue();
 							  var applicantId = billFlayOutForm.down('#applicant').getValue();
 							  
							 

							 if(!isNullOrEmpty(studentId)){
								 var contentpanel = $this.getContentPanel();
								 Academia.app.getController('Academia.controller.feeandpayment.reports.FeeReportCommonController');
								 var accountstatmentstructure = Ext.widget('studentfeereportfinalstructure');
								 var tabName = 'Fee Reports';
								 /**
								  * This is to remove tab from content panel and open same tab again 
								  */
								 var getcontroller=$this.getController('menu.CoreERPNavigationController');
								 var getTab=getcontroller.getTab(tabName);
								 if(getTab!=null){
									 contentpanel.remove(getTab, true);
								 }
								 openTab(contentpanel, tabName, accountstatmentstructure, CONSTANTS.MENU_COLOR_FIVE);

								 var frm = accountstatmentstructure.down('form');
								 var studentfeereportfinalstructure = accountstatmentstructure;
								 var feeReportTabStructure = studentfeereportfinalstructure.down('#feeReportTabStructure');
								 /* var academyForm = $this.getStudentFeeAndPaymentOrganizationUnit().getForm();
        											   var values = academyForm.getValues();
        											   if(values.multiselectAcademyLocation[0] =="" || values.multiselectAcademyLocation.length==0){
        												   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_ATLEAST_ONE_ACADEMY_LOCATION'));
        												   return;
        											   }*/
								 var treeTab = studentfeereportfinalstructure.down('#studentReportTreePanelItemId');
								 // var feeReportTabStructure = $this.getFeeReportTabStructure();
								 var feeReportTabStructure = studentfeereportfinalstructure.down('#feeReportTabStructure');
								 // feeReportTabStructure.removeAll();
								 var tabDetail = 'feeheadwisecollectionreportstructure';
								 var structure = Ext.widget(tabDetail);

								 openTab(feeReportTabStructure, getFeeAndPaymentCommonTranslation('STUDENT_FEE_HEAD_WISE'),
										 structure);

								 treeTab.toggleCollapse();
								 var headWiseForm = $this.getFeeheadwisecollectionreportform();
								 var moreFilterOpt = headWiseForm.down('fieldset');
								 moreFilterOpt.expand(true);		                												   
								 var studentField = headWiseForm.down('#student');
								 var studentFieldStore =  studentField.getStore();
								 studentFieldStore.getProxy().extraParams = { 
									 pageSize: 0,
									 limit: 0,};
								
								 
								 setTimeout(function(){
									 studentFieldStore.load({
										 callback: function(records, operation, success) {
											 if (success) {
												 for(var i in records){
													 if(records[i].data.id==studentId){
														 studentField.setValue(records[i].data.id);
													 }
												 }

											 }
										 }
									 });
									 var feeheadwisecollectionreportgrid = $this.getFeeheadwisecollectionreportgrid();
									 var feeheadwisecollectionreportgridStore =  feeheadwisecollectionreportgrid.getStore();
									 
									  var organizationForm=$this.getOrganizationunit().getForm();
						                var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation').getValue();
						                var ALsId = [];
						                for(var i in multiselectAcademyLocation){

						                ALsId.push(multiselectAcademyLocation[i]);
						                }
						               
									 feeheadwisecollectionreportgridStore.getProxy().extraParams = { 
										 academyLocationIds: ALsId.join(),
										 studentId: studentId,
										 onlyStudent: false,
										 isSchool: false,
										 studentStatus: true,
										 screenName: "feeheadwisecollectionreportform"
									 };
									 feeheadwisecollectionreportgridStore.load();


								 },1500);
								


							 } 
							 else if(!isNullOrEmpty(applicantId)){

								 var contentpanel = $this.getContentPanel();
								 Academia.app.getController('Academia.controller.feeandpayment.reports.FeeReportCommonController');
								 var accountstatmentstructure = Ext.widget('studentfeereportfinalstructure');
								 var tabName = 'Fee Reports';
								 /**
								  * This is to remove tab from content panel and open same tab again 
								  */
								 var getcontroller=$this.getController('menu.CoreERPNavigationController');
								 var getTab=getcontroller.getTab(tabName);
								 if(getTab!=null){
									 contentpanel.remove(getTab, true);
								 }
								 openTab(contentpanel, tabName, accountstatmentstructure, CONSTANTS.MENU_COLOR_FIVE);

								 var frm = accountstatmentstructure.down('form');
								 var studentfeereportfinalstructure = accountstatmentstructure;
								 var feeReportTabStructure = studentfeereportfinalstructure.down('#feeReportTabStructure');
								
								 var treeTab = studentfeereportfinalstructure.down('#studentReportTreePanelItemId');
								 var feeReportTabStructure = studentfeereportfinalstructure.down('#feeReportTabStructure');
								 var tabDetail = 'applicantfeeheadwisecollectionreportstructure';
								 var structure = Ext.widget(tabDetail);

								 openTab(feeReportTabStructure, getFeeAndPaymentCommonTranslation('APPLIACNT_HEAD_WISE'),
										 structure);

								 treeTab.toggleCollapse();
								 var headWiseForm = $this.getApplicantfeeheadwisecollectionreportform();
								 var moreFilterOpt = headWiseForm.down('fieldset');
								 moreFilterOpt.expand(true);		                												   
								 var studentField = headWiseForm.down('#applicantId');
								 var studentFieldStore =  studentField.getStore();
								 studentFieldStore.getProxy().extraParams = { 
									 pageSize: 0,
									 limit:0,
									 applicantId :applicantId};
								 studentFieldStore.load({
									 callback: function(records, operation, success) {
										 if (success) {
											 for(var i in records){
												 if(records[i].data.id==applicantId){
													 studentField.setValue(records[i].data.id);
												 }
											 }

										 }
									 }
								 });
								 setTimeout(function(){
								 var feeheadwisecollectionreportgrid = $this.getApplicantfeeheadwisecollectionreportgrid();
								 var feeheadwisecollectionreportgridStore =  feeheadwisecollectionreportgrid.getStore();
								  var organizationForm=$this.getOrganizationunit().getForm();
					                var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation').getValue();
					                var ALsId = [];
					                for(var i in multiselectAcademyLocation){

					                ALsId.push(multiselectAcademyLocation[i]);
					                }
					               
								 feeheadwisecollectionreportgridStore.getProxy().extraParams = { 
									 academyLocationIds: ALsId.join(),
									 applicantId: applicantId,
									 onlyApplicant: false,

								 };
								 feeheadwisecollectionreportgridStore.load();

								 },1500);




							 }


						 }
					 });    
				 }
			 }
		 },

   		   
   		   'addressdetailpanel[itemId=adjustmentaddressdetailpanel] displayfield[itemId=hosteldetailId]':{
   			   render: function(component) {
   				   var $this =this;
   				   var infoPanel = $this.getAdjustmentAddressDetailPanel();
   				   if(!isNullOrEmpty(infoPanel)) {
   					   infoPanel.down('#hosteldetailId').setValue("<a href='#'>Hostel Detail</a>");
   					   component.getEl().on('click', function(e) {		                						

   						   if(e.target.tagName=='A'){
   							   var billFlayOutForm = $this.getAdjustmentFilters();
   							   var tabTitle =  billFlayOutForm.down('#student').getValue();

   							   var programBatchSeatTypeConfigId = null;
   							   var personId = $this.getAdjustmentAddressDetailPanel().down('#person').getValue(); //billFlayOutForm.down('#person').getValue();
   							   var userId = billFlayOutForm.down('#student').getValue();
   							   var admissionId = null; //billFlayOutForm.down('#addmissionId').getValue();
   							   var applicationId = null; //billFlayOutForm.down('#applicationId').getValue();		                						   

   							   /* For student case */
   							   if(!isNullOrEmpty(userId)){
   								   Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
   								   var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
   								   personController.isProfilePicSaved = false;
   								   if(!isNullOrEmpty(personId)){
   									   personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, applicationId, admissionId, null);
   									   personController.addPersonTabPanel('STUDENT', 'studentHostelPersonDetails', 'HOSTEL_DETAILS', 'hostelpersondetailsgrid', 'adjustmenthostelpersondetailsgrid', true);
   									   var pendingGrid = $this.getHostelpersondetailsgrid();
   									   var pendingGridStore = pendingGrid.getStore();
   									   pendingGridStore.getProxy().extraParams = {		                									
   										   personId:personId
   									   };
   									   pendingGridStore.load();
   								   }		                										                								
   							   }			                				           
   						   }

   					   });    
   				   }
   			   }
   		   },
   		   
   		   /*added for transport detail*/
   		   'addressdetailpanel[itemId=adjustmentaddressdetailpanel] displayfield[itemId=transportdetailId]':{
   			   render: function(component) {
   				   var $this =this;
   				   var infoPanel = $this.getAdjustmentAddressDetailPanel();
   				   if(!isNullOrEmpty(infoPanel)) {
   					   infoPanel.down('#transportdetailId').setValue("<a href='#'>Transport Details</a>");
   					   component.getEl().on('click', function(e) {		                						

   						   if(e.target.tagName=='A'){
   							   var billFlayOutForm = $this.getAdjustmentFilters();
   							   var tabTitle =  billFlayOutForm.down('#student').getValue();

   							   var programBatchSeatTypeConfigId = null;
   							   var personId = $this.getAdjustmentAddressDetailPanel().down('#person').getValue(); //billFlayOutForm.down('#person').getValue();
   							   var userId = billFlayOutForm.down('#student').getValue();
   							   var admissionId = null; //billFlayOutForm.down('#addmissionId').getValue();
   							   var applicationId = null; //billFlayOutForm.down('#applicationId').getValue();		                						   

   							   /* For student case */
   							   if(!isNullOrEmpty(userId)){
   								   Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
   								   var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
   								   personController.isProfilePicSaved = false;
   								   if(!isNullOrEmpty(personId)){
   									   personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, applicationId, admissionId, null);
   									   personController.addPersonTabPanel('STUDENT', 'studentTransportPersonDetails', 'TRANSPORT_DETAILS', 'transportpersondetailsgrid', 'adjustmenttransportpersondetailsgrid', true);
   									   var pendingGrid = $this.getTransportpersondetailsgrid();
   									   var pendingGridStore = pendingGrid.getStore();
   									   pendingGridStore.getProxy().extraParams = {		                									
   										   userId:userId
   									   };
   									   pendingGridStore.load();
   								   }		                										                								
   							   }			                				           
   						   }

   					   });    
   				   }
   			   }
   		   },
     		 
     		 /*added for total bill amount flyout link manage settlements link*/
     		 'addressdetailpanel[itemId=adjustmentaddressdetailpanel] [itemId=totalAcadInvoiceAmount]':{
     			 render: function(component) {
     				 var $this =this;
     				 component.getEl().on('click', function(e) {
     					 if(e.target.tagName=='A'){
     						 var billFlayOutForm = $this.getAdjustmentFilters();
     						 var tabTitle =  $this.getAdjustmentAddressDetailPanel().down('#studentCode').getValue();
     						 var personId = null;
     						 var programBatchSeatTypeConfigId = null;
     						 var userId = billFlayOutForm.down('#student').getValue();
     						 var applicantId = billFlayOutForm.down('#applicant').getValue();
     						 var admissionId = null; //billFlayOutForm.down('#addmissionId').getValue();
     						 var applicationId = null; //billFlayOutForm.down('#applicationId').getValue();		                						   
     						 var raiseBillFor=billFlayOutForm.down("#adjustmentFor").getValue();
     						 var actualUserId = billFlayOutForm.down('#userId').getValue();

     						   /* For User case */
  						   if(!isNullOrEmpty(actualUserId) && raiseBillFor=='USER'){
     						   if(!isNullOrEmpty(actualUserId)){
       							  var tabTitle =  billFlayOutForm.down('#userId').getValue();
       							  var admissionId = null; 
          						  var applicationId = null; 
      							   
          						   Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
      							   var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
//      							   personController.isProfilePicSaved = false;
      							   personController.addContentPanelTab(tabTitle, 'facultyprofile', actualUserId, personId, applicationId, admissionId, null);
      							   personController.addPersonTabPanel('USER', 'userPendingBillDetails', 'BILL', 'pendingbillsgrid', 'userPendingBillsGrid', true);
      							   
      							   var params = {
      			                     		id : actualUserId,
      			                     		billedUserType : 'USER',
      			         					raiseBillCategory : 'BILL_PAYABLE'
      			                     };
      							   $this.loadGridStoreFaculty('#pendingbillsgrid', SERVERURL.FACULTY_PENDING_BILLS_DETAILS, params);
      							  
         						   } }else{

     						 /* For student case */
     						 if(!isNullOrEmpty(userId)){
     							 Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
     							 var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
     							 personController.isProfilePicSaved = false;
     							 personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, applicationId, admissionId, null);
     							 personController.addPersonTabPanel('STUDENT', 'studentPendingBillDetails', 'BILL', 'pendingbillsgrid', 'studentPendingBillsGrid', true);
     							 var pendingGrid = $this.getPendingbillsgrid();
     							 var pendingGridStore = pendingGrid.getStore();
     							 pendingGridStore.getProxy().extraParams = {
     								 id:userId,
     								 billedUserType:'STUDENT',
     								 raiseBillCategory:'BILL_RECEIVABLE'
     							 };
     							 // pendingGridStore.load();
     							 pendingGridStore.load({ 
     								 callback: function(record, operation, success) {
     									 if (record.length > 0) {
     										 $this.toggleGridSummaryRow(pendingGrid,true);
     									 }else{
     										 $this.toggleGridSummaryRow(pendingGrid,false);
     									 }
     								 }
     							 });
     						 }		
         				}
     	     				//For Applicant.......
     						   if(!isNullOrEmpty(applicantId)){
   							   var tabTitle =  $this.getAdjustmentAddressDetailPanel().down('#applicationId').getValue();
     							  
   							  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
   							  var personController=  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
   							  personController.isProfilePicSaved = false;
   							  personController.addContentPanelTab(tabTitle, 'applicantprofile', applicantId, personId, applicantId, admissionId, null);
   							  personController.addPersonTabPanel('APPLICANT', 'applicantPendingBillDetails', 'Payment', 'preadmissionpaymentsgrid', 'applicantPendingBillDetails', true);
 							  var pendingGridNew = $this.getPreadmissionpaymentsgrid();
							  var pendingGridStoreNew = pendingGridNew.getStore();
							  pendingGridStoreNew.getProxy().extraParams = {
								  applicantId:applicantId
								 //  billedUserType:'APPLICANT',
								 //  raiseBillCategory:'BILL_RECEIVABLE'
							   };
						
							  pendingGridStoreNew.load({ 
					        		callback: function(record, operation, success) {
								 if (record.length > 0) {
									 $this.toggleGridSummaryRow(pendingGrid,true);
									 }else{
										 $this.toggleGridSummaryRow(pendingGrid,false);
									 }
								 }
							});
  						   }
     						 
     					 }
     				 });    
     			 }		                			   
     		 },

     		 /*added for total reciept flyout link to manage settlements link*/
     		 'addressdetailpanel[itemId=adjustmentaddressdetailpanel] [itemId=totalAcadReceiptAmount]':{
     			 render: function(component) {
     				 var $this =this;
     				 component.getEl().on('click', function(e) {
     					 if(e.target.tagName=='A'){
     						 var billFlayOutForm = $this.getAdjustmentFilters();
     						 var tabTitle = $this.getAdjustmentAddressDetailPanel().down('#studentCode').getValue();
     						 var personId = null;
     						 var programBatchSeatTypeConfigId = null;
     						 var userId = billFlayOutForm.down('#student').getValue();
     						 var applicantId = billFlayOutForm.down('#applicant').getValue();
     						 var admissionId = null;
     						 var applicationId = null;		                						   
     						var raiseBillFor=billFlayOutForm.down("#adjustmentFor").getValue();
    						 var actualUserId = billFlayOutForm.down('#userId').getValue();

    						 /* For User case */
    						 if(!isNullOrEmpty(actualUserId) && raiseBillFor=='USER'){
    							   if(!isNullOrEmpty(actualUserId)){
             							  var tabTitle =  billFlayOutForm.down('#userId').getValue();
             							  var admissionId = null; 
                						  var applicationId = null; 
            							   
                						   Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
            							   var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
//            							   personController.isProfilePicSaved = false;
            							   personController.addContentPanelTab(tabTitle, 'facultyprofile', actualUserId, personId, applicationId, admissionId, null);
            							   personController.addPersonTabPanel('USER', 'userPaymentReceivedHistoryDetails', 'RECEIPTS', 'paymentreceivedhistorygrid', 'userPaymentReceivedHistoryGrid', true);
            							   
            							   var params = {
            			                     		id : actualUserId,
            			                     };
            							   $this.loadGridStoreFaculty('#facultyPaymentReceivedHistoryGrid', SERVERURL.FACULTY_PAYMENT_RECEIVED_HISTORY_DETAILS, params);
            							  
               						   } 
    						   }				                 						
    						   else{
     						 /* For student case */
     						 if(!isNullOrEmpty(userId)){
     							 Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
     							 var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
     							 personController.isProfilePicSaved = false;
     							 personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, applicationId, admissionId, null);
     							 personController.addPersonTabPanel('STUDENT', 'studentPaymentReceivedHistoryDetails', 'RECEIPTS', 'paymentreceivedhistorygrid', 'studentPaymentReceivedHistoryGrid', true);
     							 var paymentReceivedGrid = $this.getPaymentreceivedhistorygrid();
     							 // var pendingGridStore = $this.getStore('Academia.store.personinfo.common.paymentandrefund.PendingBillStore');
     							 var paymentReceivedGridStore = paymentReceivedGrid.getStore();
     							 paymentReceivedGridStore.getProxy().extraParams = {
     								 studentId:userId		                								   
     							 };
     							 paymentReceivedGridStore.load({ 
     								 callback: function(record, operation, success) {
     									 if (record.length > 0) {
     										 $this.toggleGridSummaryRow(paymentReceivedGrid,true);
     									 }else{
     										 $this.toggleGridSummaryRow(paymentReceivedGrid,false);
     									 }
     								 }
     							 });
     						 }
    					 }
			     	//For Applicant.......
	   						   if(!isNullOrEmpty(applicantId)){
	 							   var tabTitle =  $this.getAdjustmentAddressDetailPanel().down('#applicationId').getValue();
	   							  
	 							  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
	 							  var personController=  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
	 							  personController.isProfilePicSaved = false;
	 							  personController.addContentPanelTab(tabTitle, 'applicantprofile', applicantId, personId, applicantId, admissionId, null);
	 							 personController.addPersonTabPanel('APPLICANT', 'applicantPaymentReceivedHistoryDetails', 'RECEIPTS', 'receiptgridforapplicant', 'applicantPaymentReceivedHistoryGrid', true);
            						
	 							  var pendingGridNew = $this.getReceiptgridforapplicant();
   							  var pendingGridStoreNew = pendingGridNew.getStore();
   							  pendingGridStoreNew.getProxy().extraParams = {
   								  personId:applicantId,
   								  billedUserType: 'APPLICANT',
   								  adjustmentType: 'BILL_RECEIVABLE',
   								  whetherDeleted: 'FALSE',
   								  raiseBillType: 'P_AND_C_FEE'
   						
   							   };
   							  pendingGridStoreNew.load({ 
   								   callback: function(record, operation, success) {
   									   if (record.length > 0) {
   										   $this.toggleGridSummaryRow(paymentReceivedGrid,true);
   									   }else{
   										   $this.toggleGridSummaryRow(paymentReceivedGrid,false);
   									   }
   								   }
   							   });
						  }			                				           

     					 }
     				 });    
     			 }		                			   
     		 },

     		 /*added for total payment amount flyout link to manage settlements link*/
     		 'addressdetailpanel[itemId=adjustmentaddressdetailpanel] [itemId=totalAcadPaymentAmount]':{
     			 render: function(component) {
     				 var $this =this;
     				 component.getEl().on('click', function(e) {
     					 if(e.target.tagName=='A'){
     						 var billFlayOutForm = $this.getAdjustmentFilters();
     						 var tabTitle =  $this.getAdjustmentAddressDetailPanel().down('#studentCode').getValue();
     						 var personId = null;
     						 var programBatchSeatTypeConfigId = null;
     						 var userId = billFlayOutForm.down('#student').getValue();
     						 var applicantId = billFlayOutForm.down('#applicant').getValue();
     						 var admissionId = null;
     						 var applicationId = null;		                						   
     						var raiseBillFor=billFlayOutForm.down("#adjustmentFor").getValue();
     						var actualUserId = billFlayOutForm.down('#userId').getValue();

     						   /* For User case */
     						   if(!isNullOrEmpty(actualUserId) && raiseBillFor=='USER'){
        						   if(!isNullOrEmpty(actualUserId)){
          							  var tabTitle =  billFlayOutForm.down('#userId').getValue();
          							  var admissionId = null; 
             						  var applicationId = null; 
         							   
             						   Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
         							   var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
//         							   personController.isProfilePicSaved = false;
         							   personController.addContentPanelTab(tabTitle, 'facultyprofile', actualUserId, personId, applicationId, admissionId, null);
         							  personController.addPersonTabPanel('USER', 'userPaymentMadeHistoryGrid', 'Payment Made History', 'paymentmadehistorygrid', 'userPaymentMadeHistoryGrid', true);	
         							   
         							   var params = {
         			                     		id : actualUserId,
         							   	};
         							   
         							   $this.loadGridStoreFaculty('#facultyPaymentMadeGrid', SERVERURL.FACULTY_PAYMENT_MADE_HISTORY_DETAILS, params);
         							  
            						   } }else{

     						 /* For student case */
     						 if(!isNullOrEmpty(userId)){
     							 Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
     							 var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
     							 personController.isProfilePicSaved = false;
     							 personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, applicationId, admissionId, null);
     							 personController.addPersonTabPanel('STUDENT', 'studentRefundHistoryDetails', 'REFUNDS', 'refundhistorygrid', 'studentRefundHistoryGrid', true);
     							 var refundhistorygrid = $this.getRefundhistorygrid();
     							 var refundhistorygridStore = paymentReceivedGrid.getStore();
     							 refundhistorygridStore.getProxy().extraParams = {
     								 studentId:userId		                								   
     							 };
     							 refundhistorygridStore.load({ 
     								 callback: function(record, operation, success) {
     									 if (record.length > 0) {
     										 $this.toggleGridSummaryRow(refundhistorygrid,true);
     									 }else{
     										 $this.toggleGridSummaryRow(refundhistorygrid,false);
     									 }
     								 }
     							 });
     						 }	}
     			   			//For Applicant.......
	   						   if(!isNullOrEmpty(applicantId)){
	 							   var tabTitle =  $this.getAdjustmentAddressDetailPanel().down('#applicationId').getValue();
	   							  
	 							  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
	 							  var personController=  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
	 							  personController.isProfilePicSaved = false;
	 							  personController.addContentPanelTab(tabTitle, 'applicantprofile', applicantId, personId, applicantId, admissionId, null);
	 							 personController.addPersonTabPanel('APPLICANT', 'applicantRefundHistoryDetails', 'REFUNDS', 'preadmissionrefundsgrid', 'applicantRefundHistoryGrid', true);
	 							   var preadrefundsgrid = $this.getPreadmissionrefundsgrid();
  							   var preadrefundsgridStore = preadrefundsgrid.getStore();
  							   preadrefundsgridStore.getProxy().extraParams = {
  								   studentId:userId		                								   
  							   };
  							   preadrefundsgridStore.load({ 
  								   callback: function(record, operation, success) {
  									   if (record.length > 0) {
  										   $this.toggleGridSummaryRow(refundhistorygrid,true);
  									   }else{
  										   $this.toggleGridSummaryRow(refundhistorygrid,false);
  									   }
  								   }
  							   });
						  }
     						 
     					 }
     				 });    
     			 }		                			   
     		 },

     		 /*added for total outstanding amount flyout link manage settlements link*/
     		 'addressdetailpanel[itemId=adjustmentaddressdetailpanel] [itemId=totalConvertedOutstanding]':{
     			 render: function(component) {
     				 var $this =this;
     				 component.getEl().on('click', function(e) {
     					 if(e.target.tagName=='A'){
     						 var billFlayOutForm = $this.getAdjustmentFilters();
     						 var tabTitle = $this.getAdjustmentAddressDetailPanel().down('#studentCode').getValue();
     						 var personId = null;
     						 var programBatchSeatTypeConfigId = null;
     						 var userId = billFlayOutForm.down('#student').getValue();
     						 var applicantId = billFlayOutForm.down('#applicant').getValue();
     						 var admissionId = null;
     						 var applicationId = null;	                						   
     						var raiseBillFor=billFlayOutForm.down("#adjustmentFor").getValue();
     						var actualUserId = billFlayOutForm.down('#userId').getValue();

     						 
     						/* For User case */
  						   if(!isNullOrEmpty(actualUserId) && raiseBillFor=='USER'){
     						   if(!isNullOrEmpty(actualUserId)){
       							  var tabTitle =  billFlayOutForm.down('#userId').getValue();
       							  var admissionId = null; 
          						  var applicationId = null; 
      							   
          						   Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
      							   var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
//      							   personController.isProfilePicSaved = false;
      							   personController.addContentPanelTab(tabTitle, 'facultyprofile', userId, personId, applicationId, admissionId, null);
      							   personController.addPersonTabPanel('USER', 'userPendingBillDetails', 'BILL', 'pendingbillsgrid', 'userPendingBillsGrid', true);
      							   
      							   var params = {
      			                     		id : actualUserId,
      			                     		billedUserType : 'USER',
      			         					raiseBillCategory : 'BILL_PAYABLE'
      			                     };
      							   $this.loadGridStoreFaculty('#pendingbillsgrid', SERVERURL.FACULTY_PENDING_BILLS_DETAILS, params);
     						   } }else{
     						 /* For student case */
     						 if(!isNullOrEmpty(userId)){
     							 Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
     							 var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
     							 personController.isProfilePicSaved = false;
     							 personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, applicationId, admissionId, null);
     							 personController.addPersonTabPanel('STUDENT', 'studentPendingBillDetails', 'BILL', 'pendingbillsgrid', 'studentPendingBillsGrid', true);
     							 var pendingGrid = $this.getPendingbillsgrid();
     							 var pendingGridStore = pendingGrid.getStore();
     							 pendingGridStore.getProxy().extraParams = {
     								 id:userId,
     								 billedUserType:'STUDENT',
     								 raiseBillCategory:'BILL_RECEIVABLE'
     							 };
     							 // pendingGridStore.load();
     							 pendingGridStore.load({ 
     								 callback: function(record, operation, success) {
     									 if (record.length > 0) {
     										 $this.toggleGridSummaryRow(pendingGrid,true);
     									 }else{
     										 $this.toggleGridSummaryRow(pendingGrid,false);
     									 }
     								 }
     							 });
     						 }
     						}	 
     			     		//For Applicant.......
	   						   if(!isNullOrEmpty(applicantId)){
	 							   var tabTitle =  $this.getAdjustmentAddressDetailPanel().down('#applicationId').getValue();
	   							  
	 							  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
	 							  var personController=  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
	 							  personController.isProfilePicSaved = false;
	 							  personController.addContentPanelTab(tabTitle, 'applicantprofile', applicantId, personId, applicantId, admissionId, null);
	 							 personController.addPersonTabPanel('APPLICANT', 'applicantPendingBillDetails', 'Payment', 'preadmissionpaymentsgrid', 'applicantPendingBillDetails', true);
    							  var pendingGridNew = $this.getPreadmissionpaymentsgrid();
   							  var pendingGridStoreNew = pendingGridNew.getStore();
   							  pendingGridStoreNew.getProxy().extraParams = {
   								  applicantId:applicantId
   								 //  billedUserType:'APPLICANT',
   								 //  raiseBillCategory:'BILL_RECEIVABLE'
   							   };
   						
   							  pendingGridStoreNew.load({ 
   					        		callback: function(record, operation, success) {
   								 if (record.length > 0) {
   									 $this.toggleGridSummaryRow(pendingGrid,true);
   									 }else{
   										 $this.toggleGridSummaryRow(pendingGrid,false);
   									 }
   								 }
   							});
						  }
     						 
     					 }
     				 });    
     			 }		                			   
     		 },
     		 'adjustmentform':{
     			 afterrender:function(structure){
     				 var $this = this;
     				var structure = structure.down('panel');
     				structure.body.on('scroll', function(e, target) {
     					var adjustmentstructure = $this.getAdjustmentstructure();
     					var adjustmenttabstructure = adjustmentstructure.down('adjustmenttabstructure');
     					var grid = adjustmenttabstructure.getActiveTab().down('grid');
     					var billListGrid = $this.getBilllist();
     					var receiptsListGrid = $this.getReceiptslist();
     					var paymentsListGrid = $this.getPaymentslist();
     					var instumentDetailsListGrid = $this.getInstumentdetailslist();
     					var allbillsListGrid = $this.getAllbillslist();
     					var billReceivableList = $this.getBillreceivablelist();
     					var adjustmentFiltersForm = $this.getAdjustmentFilters();
     					//var adjustmentadjustmentFiltersForm.down('#adjustment').getValue();
     					 var grid = null;
    					 
    					 if(adjustmentFiltersForm.down('#adjustment').getValue() =='RECEIPT'){
    						 if(!receiptsListGrid.isHidden() && receiptsListGrid.isVisible() && adjustmenttabstructure.getActiveTab().title=='Receipt / Payment / Bill' ){
        						 grid = $this.getReceiptslist();
        						 $this.getMultipleGridHeaderFreeze(grid,structure,true); 
        					 }
    						 if(!allbillsListGrid.isHidden() && allbillsListGrid.isVisible() && adjustmenttabstructure.getActiveTab().title=='Bill Receivable/ Payable' ){
        						 grid = $this.getAllbillslist();
        						 $this.getMultipleGridHeaderFreezeWithoutPaggination(grid,structure,true); 
        					 }
    						 if(!billReceivableList.isHidden() && billReceivableList.isVisible() && adjustmenttabstructure.getActiveTab().title=='Fee Head Covered'){
    							 grid = $this.getBillreceivablelist();
    							 $this.getMultipleGridHeaderFreezeWithoutPaggination(grid,structure,true); 
    						 }
    						 if(!instumentDetailsListGrid.isHidden() && instumentDetailsListGrid.isVisible() && adjustmenttabstructure.getActiveTab().title=='Instrument Details'){
        						 grid = $this.getInstumentdetailslist();
        						 $this.getMultipleGridHeaderFreeze(grid,structure,true); 
        					 }
    						 
    					 }
    					 if(adjustmentFiltersForm.down('#adjustment').getValue() =='PAYMENT'){
    						 if(!paymentsListGrid.isHidden() && paymentsListGrid.isVisible() && adjustmenttabstructure.getActiveTab().title=='Receipt / Payment / Bill'){
        						 grid = $this.getPaymentslist();
        						 $this.getMultipleGridHeaderFreeze(grid,structure,true); 
        					 }
    						 if(!billReceivableList.isHidden() && billReceivableList.isVisible() && adjustmenttabstructure.getActiveTab().title=='Fee Head Covered'){
    							 grid = $this.getBillreceivablelist();
    							 $this.getMultipleGridHeaderFreezeWithoutPaggination(grid,structure,true); 
    						 }
    						 if(!allbillsListGrid.isHidden() && allbillsListGrid.isVisible() && adjustmenttabstructure.getActiveTab().title=='Bill Receivable/ Payable' ){
        						 grid = $this.getAllbillslist();
        						 $this.getMultipleGridHeaderFreezeWithoutPaggination(grid,structure,true); 
        					 }
    					 }
    					 if(adjustmentFiltersForm.down('#adjustment').getValue() =='BILL'){
    						 if(!billListGrid.isHidden() && billListGrid.isVisible() && adjustmenttabstructure.getActiveTab().title=='Receipt / Payment / Bill' ){
        						 grid = $this.getBilllist();
        					 }
    						 if(!billReceivableList.isHidden() && billReceivableList.isVisible() && adjustmenttabstructure.getActiveTab().title=='Fee Head Covered'){
    							 grid = $this.getBillreceivablelist();
    						 }
    						 //$this.getMultipleGridHeaderFreezeWithoutPaggination(grid,structure,true); 
    					 }
    					
    					
    					 /*if(!instumentDetailsListGrid.isHidden() && instumentDetailsListGrid.isVisible()){
    						 grid = $this.getInstumentdetailslist();
    					 }
    					 if(!allbillsListGrid.isHidden() && allbillsListGrid.isVisible()){
    						 grid = $this.getAllbillslist();
    					 }*/
    					 /*if(!billReceivableList.isHidden() && billReceivableList.isVisible()){
    						 grid = $this.getBillreceivablelist();
    					 }*/
     					

     				});
     			 }

     		 },'adjustmenttabstructure button[itemId=studentSearchBtn]':{
      			click : this.findBillReceivableByStudentId
     		 },
     		 'adjustmenttabstructure':{
   			  render : function(obj,record){
   				  var form=this.getAdjustmenttabstructure();
   				  this.disableAcademyLocationPivileges(form, this.getMANAGESETTLEMENT_MAP_ACADEMY_LOCATION_PETMISSION());
   			  }
   		  },
   		  'paymentreceivedhistorygrid' :{
   			  cellclick: function(view, cell, cellIndex, record, row, rowIndex, e){
   				  if(isNullOrEmpty(record.data.studentId)){
   					  var cellDataIndex = view.getGridColumns()[cellIndex].dataIndex;
   					  if (cellDataIndex == "adjustment") {
   						  this.viewPaymentRecievedHistoryGrid('PAYMENT_RECIEVED_HISTORY', 'receiptsettlementheadwindow', 'paymentreceivedhistorygrid', SERVERURL.BILL_HEADER_ADJUSTMENT_DETAILS);
   						  //this.viewPaymentRecievedHistoryForProfile('PAYMENT_RECIEVED_HISTORY', 'receiptsettlementheadwindow', '#studentPaymentReceivedHistoryGrid', SERVERURL.BILL_HEADER_ADJUSTMENT_DETAILS, record);
   					  }else if(cellDataIndex == "instrument"){
   						  this.viewPaymentRecievedHistoryGrid('PAYMENT_RECIEVED_HISTORY', 'paymentheaderinstrumentadjustmentdetailsgridwindow', 'paymentreceivedhistorygrid', SERVERURL.PAYMENT_HEADER_INSTRUMENT_ADJUSTMENT_DETAILS);
   					  }
   				  }
   			  },
   			  afterrender:function(grid){
   				  var me = this;
   				  setTimeout(function(){
   					  me.addDataGridConfigButton(grid, me.getPAYMENT_RECEIVED_HISTORY_GRID_PERMISSION());
   				  },1500);
   			  }
   		  },
   		  'receiptgridforapplicant' :{
   			  /*cellclick: function(view, cell, cellIndex, record, row, rowIndex, e){
   					  var cellDataIndex = view.getGridColumns()[cellIndex].dataIndex;
   					  if (cellDataIndex == "adjustment") {
   						  this.viewPaymentRecievedHistoryGrid('PAYMENT_RECIEVED_HISTORY', 'receiptsettlementheadwindow', 'receiptgridforapplicant', SERVERURL.BILL_HEADER_ADJUSTMENT_DETAILS);
   						  //this.viewPaymentRecievedHistoryForProfile('PAYMENT_RECIEVED_HISTORY', 'receiptsettlementheadwindow', '#studentPaymentReceivedHistoryGrid', SERVERURL.BILL_HEADER_ADJUSTMENT_DETAILS, record);
   					  }else if(cellDataIndex == "instrument"){
   						  this.viewPaymentRecievedHistoryGrid('PAYMENT_RECIEVED_HISTORY', 'paymentheaderinstrumentadjustmentdetailsgridwindow', 'receiptgridforapplicant', SERVERURL.PAYMENT_HEADER_INSTRUMENT_ADJUSTMENT_DETAILS);
   					  }
   				  },*/
                  afterrender:function(grid){
                  	var me = this;
                  	setTimeout(function(){
                  		me.addDataGridConfigButton(grid, me.getAPPLICATIONS_RECIEPT_PERMISSIONS());
                  	},1500);
                  }
   		  
   		  },
   		 'addressdetailpanel[itemId=adjustmentaddressdetailpanel]':{
			 render:function(flyOut){
				this.doAccessControlValidationForFlyOut(flyOut, this.getPRINTBUTTON_PERMISSIONS());
			 }
		 },
		 'adjustmentfilters checkboxfield[itemId=inActiveStudentItemId]': {
        	 change:function(obj,newValue, oldValue, eOpts ){
        		 var form = obj.up('form');
        		 var student = form.down('#student');
        		 student.clearValue();
        	 }
		 },
		 'adjustmentfilters checkboxfield[itemId=settleWithCheckBoxId]': {
			 change:function(obj,newValue, oldValue, eOpts ){
				 var adjustmentStructure = this.getAdjustmentstructure(),
				 adjustmenttabstructure = adjustmentStructure && adjustmentStructure.down('adjustmenttabstructure');
				 adjustmenttabstructure.down('#instumentdetailscontainer').setDisabled(true);
				 adjustmenttabstructure.down('#allbilllistcontainer').setDisabled(true);
				 adjustmenttabstructure.down('#billreceivablecontainer').setDisabled(true);
				 adjustmenttabstructure.down('#paymentReceiptSetttlementcontainer').setDisabled(true);
				 adjustmenttabstructure.setActiveTab( adjustmenttabstructure.down('#listcontainer'));
				 this.resetProgressTracker();
				 var adjustmentprogresstracker = adjustmentStructure && adjustmentStructure.down("#adjustmentprogresstracker");
				 var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
				 progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
				 progresstracker1.textEl.addCls("inProgressCss-progress-text");
				 progresstracker1.updateText("Step 1 In Progress");
				 if(this.getAdjustmentform()){
					  var adjustmentform = this.getAdjustmentform();
					  adjustmentform.down('panel').scrollBy(0,1);
					  adjustmentform.down('panel').scrollBy(0,-1);
				  }
			 }
		 },
		 'paymentslistforreceiptsettlement numberfield[itemId=amountToBeAdjusted]':{
			 focus : function(obj){
				 var grid = obj.ownerCt.grid;
				 var selectedRow = grid.getSelectionModel().getSelection()[0];
				 var rowIndex = grid.store.indexOf(selectedRow);
				 Ext.apply(grid, {
					 rowIndexes:null,
					 setRowIndexes: function(rowIndexes) {
						 grid.rowIndexes = rowIndexes;
					 },
					 getRowIndexes: function() {
						 return grid.rowIndexes;
					 }
				 });
				 grid.setRowIndexes(rowIndex);
				 this.setMaxAmountLimitForPaymentList(obj);
			 },
			 specialkey: function(f, e) {
				 if (e.getKey() == e.ENTER || e.getKey() == e.ESC) {
					 triggerBlur=false;
				 }
			 },
			 blur: function(obj,event,eOpt){
				 if(triggerBlur==true){
					 this.getCalForBalanceAmtOfSettleWithReceiptOrPayment(obj);
				 }
				 triggerBlur=true;
			 }
		 },
		 'receiptslistforpaymentsettlement numberfield[itemId=amountToBeAdjusted]':{
			 focus : function(obj){
				 var grid = obj.ownerCt.grid;
				 var selectedRow = grid.getSelectionModel().getSelection()[0];
				 var rowIndex = grid.store.indexOf(selectedRow);
				 Ext.apply(grid, {
					 rowIndexes:null,
					 setRowIndexes: function(rowIndexes) {
						 grid.rowIndexes = rowIndexes;
					 },
					 getRowIndexes: function() {
						 return grid.rowIndexes;
					 }
				 });
				 grid.setRowIndexes(rowIndex);
				 this.setMaxAmountLimit(obj);
			 },
			 specialkey: function(f, e) {
				 if (e.getKey() == e.ENTER || e.getKey() == e.ESC) {
					 triggerBlur=false;
				 }
			 },
			 blur: function(obj,event,eOpt){
				 if(triggerBlur==true){
					 this.getCalForBalanceAmtOfSettleWithReceiptOrPayment(obj);
				 }
				 triggerBlur=true;
			 }
		 },
		 'paymentslistforreceiptsettlement':{
			 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				 var cellDataIndex = grid.getGridColumns()[cellIndex].dataIndex;
				 this.selectedPaymentId =record.data.id;
				 if(cellDataIndex == 'viewAdjustments'){
					 if(e.target.tagName=='A'){
						 this.getViewReceiptPaymentAdjustment(grid,record);
					 }
				 }
			 },
		 },
		 'receiptslistforpaymentsettlement':{
			 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				 this.selectedReceiptId=record.data.id;
				 var paymentsGrid = this.getReceiptslistforpaymentsettlement();
				 if(e.target.tagName=='A'){
					 //this.getViewAdjustment(paymentsGrid,record);
				 }else{
					 //this.getCheckedPaymentListing(paymentsGrid,record);
				 }
			 }
		 },
		 'paymentslistforreceiptsettlement button[itemId=submitBtn]':{
			 click : function(obj){
				 var $this=this,
				 form = this.getAdjustmentstructure(),
				 adjustment = form.down("#adjustment").getValue(),
				 paymentListGrid= $this.getPaymentslistforreceiptsettlement(),
				 record = paymentListGrid.getSelectionModel().getSelection()[0];
				 if(isNullOrEmpty(record)){
					 return showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
				 }
				 obj.setDisabled(true);
				 var paymentHeaderIdParam=this.selectedPaymentId;
				 Ext.Ajax.request({
					 method : "GET",
					 type : 'rest',
					 url: SERVERURL.FIND_PAYMENT_STATUS,
					 params: {
						 paymnetHeaderId : paymentHeaderIdParam,
					 },
					 headers : {
						 'Content-Type' : 'application/json'
					 },
					 success: function(response) {
						 $this.selectedPaymentId=null;
						 var data = Ext.decode(response.responseText);
						 if(data) {
							 showWarningMessage(getCommonTranslation('ALERT'), getFeeAndPaymentCommonTranslation('SELECTED_PAYMENT_ALREADY_CANCELLED'));
							 obj.setDisabled(false);
						 }else{
							 $this.getSavePaymentListDetails(obj);
						 }
					 }
				 });
			 }
		 }
        });
      },
      /**
       * render adjustment filter screen.
       */
      getRenderAdjustmentFilters : function(form){
    	  var $this = this;
    	  $this.disableSettlementCurrencyPivileges(form,$this.getPERFORM_SETTELEMENT_RADIOBTN_PERMISSION());
    	  
    	  form.down("#thirdParty").allowBlank=true;
    	  form.down("#sponsors").allowBlank=true;
    	  form.down("#applicant").allowBlank=true;
    	  form.down("#userId").allowBlank=true;

    	  var adjustmentFor = form.down("#adjustmentFor");
    	  var adjustment = form.down("#adjustment");
    	  var showAllSettlement = form.down("#showAllSettlementId");
    	  var receiptNo=form.down("#receiptNoId");
    	  receiptNo.setVisible(true);

    	  
    	  if(!form.up().isEditable){
        	  var adjustmentStore = adjustment.getStore();
        	  adjustmentStore.load({
        		  callback: function(record, operation, success) {
        			  if (success) {
        				  adjustment.setValue(record[1].data.id);
        			  }
        		  }
        	  });
    		}else{
    			adjustment.store.load();
    		}
    	  
		  var addressdetailpanel = $this.getAdjustmentAddressDetailPanel();
    	  var alinfomodel = Academia.model.authentication.ALInfoModel;
    	  var wheatherSchool = alinfomodel.get('wheatherSchool');
    	  if(wheatherSchool){
    		  if(addressdetailpanel==undefined){}
    		  else
    			  addressdetailpanel.down('#period').hide();
    	  }

    	  var adjustmentForStore = adjustmentFor.getStore();
    	  adjustmentForStore.load({
    		  callback: function(record, operation, success) {
    			  if (success) {
    				  adjustmentFor.setValue(record[0].data.id);
    			  }
    		  }
    	  });
	
    	  var showAllSettlementStore = showAllSettlement.getStore();
    	  showAllSettlementStore.load({
    		  callback: function(record, operation, success) {
    			  if (success) {
    				  showAllSettlement.setValue(record[0].data.id);
    			  }
    		  }
    	  });
    	  
    	  this.disableAcademyLocationPivileges(form, this.getMANAGESETTLEMENT_MAP_ACADEMY_LOCATION_PETMISSION());
    	  this.disableSettleWithCheckBoxPrivileges(form, this.getMANAGESETTLEMENT_MAP_ACADEMY_LOCATION_PETMISSION());
      },
      
      // ****** to check selected radio buttons***********
      getCheckAdjustmentFor : function(obj,record){
    	 
    	  var $this = this;
    	  var form = obj.up('form');
    	  var newValue = record //record[0].get('id');
    	  
    	  var formLayout = $this.getAdjustmentFilters();
    	  var receiptForm = $this.getManagereceiptform();
    	  var academyLocationId = formLayout.down("#fnpBrandCampusItemId").getValue();
    	  var adjustmentOf = formLayout.down("#adjustment");
    	  
    	  var thirdParty =  form.down("#thirdParty");
          var sponsors =  form.down("#sponsors");
          var applicant =  form.down("#applicant");
          var userId =  form.down("#userId");
          var student =  form.down("#student");
          var instrumentNumberField =  form.down("#instrumentNumberId");
          var settlementOf = form.down("#adjustment");
          
          var receiptNo=form.down("#receiptNoId");
          var billNo = form.down("#billNoId");
          var paymentNo = form.down("#paymentNoId");
          var inActiveStudent = form.down("#inActiveStudentItemId");
          var settleWithCheckBoxId = form.down('#settleWithCheckBoxId');
          
          receiptNo.reset();
          billNo.reset();
          paymentNo.reset();
          
          receiptNo.setDisabled(true);
          billNo.setDisabled(true);
          paymentNo.setDisabled(true);
         
          instrumentNumberField.reset();
          
          
          thirdParty.setVisible(false);
          sponsors.setVisible(false);
          applicant.setVisible(false);
          userId.setVisible(false);
          student.setVisible(false); 
    	  
          thirdParty.reset();
          sponsors.reset();
          applicant.reset();
          userId.reset();
          student.reset(); 
          
          thirdParty.allowBlank=true;
          sponsors.allowBlank=true;
          applicant.allowBlank=true;
          userId.allowBlank=true;
          student.allowBlank=true;
          inActiveStudent.setVisible(false);
          inActiveStudent.reset();
          settleWithCheckBoxId.setVisible(false);
          settleWithCheckBoxId.reset();
    	  if(newValue=="STUDENT"){
    		  inActiveStudent.setVisible(true);
    		  if($this.isVisibleSettleWithCheckBox && adjustmentOf.getValue()!='BILL'){
    			  //settleWithCheckBoxId.setVisible(true);
    		  }
    		  student.setVisible(true);
              student.allowBlank=false;
              instrumentNumberField.setVisible(false);
              instrumentNumberField.setDisabled(true);
              if(settlementOf.value=="PAYMENT"){
            	  
              }else{
              var alFilterField = form.down("#student");
        	  var alFilterStore = alFilterField.getStore();
        	  alFilterStore.getProxy().extraParams={
        		  academyLocationIds:academyLocationId,
        	  };
        	  if(!receiptForm){
        		  if(Ext.get('isManagePaymentForm') && !isManagePaymentForm){
        			  alFilterStore.load();
        		  }
        	  }
        	  isManagePaymentForm=false;
        	}
        	 /* if(form.up().isEditable){
        		  !form.up().isEditable && alFilterStore.load();
        	  }
        	  } */
    	  }
    	  if(newValue=="APPLICANT"){
    		  applicant.setVisible(true); 
              applicant.allowBlank=false;
              instrumentNumberField.setVisible(false);
              instrumentNumberField.setDisabled(true);
              
              if(settlementOf.value=="PAYMENT"){
            	  
              }else{
              var alFilterField = form.down("#applicant");
        	  var alFilterStore = alFilterField.getStore();
        	  alFilterStore.getProxy().extraParams={
        		  academyLocationIds:academyLocationId,
        	  };
        	  if(form.up().isEditable){
        		  !form.up().isEditable && alFilterStore.load();
        	  }
        	  }
    	  }
    	  if(newValue=="SPONSOR"){
    		  sponsors.setVisible(true); 
              sponsors.allowBlank=false;
              if(settlementOf.value=="RECEIPT"){
            	  instrumentNumberField.setVisible(true);
            	  instrumentNumberField.setDisabled(true);
              }else{
            	  instrumentNumberField.setVisible(false);
            	  instrumentNumberField.setDisabled(true);
              }
    	  }
    	  if(newValue=="USER"){
    		  userId.setVisible(true); 
              userId.allowBlank=false;
              instrumentNumberField.setVisible(false);
              instrumentNumberField.setDisabled(true);
    	  }
    	  if(newValue=="THIRD_PARTY"){
    		  thirdParty.setVisible(true); 
    		  thirdParty.allowBlank=false;
    		  instrumentNumberField.setVisible(false);
    		  instrumentNumberField.setDisabled(true);
    		 
    		  var alFilterField = form.down("#thirdParty");
        	  var alFilterStore = alFilterField.getStore();
        	  alFilterStore.getProxy().extraParams={
        		  academyLocationIds:academyLocationId,
        	  };
        	  alFilterStore.load();
    		  
    	  }	  
    	  $this.resetProgressTracker();
      },
      //**************** get search settlement details***************
      getSearchSettlementDetails : function(obj){
    	 /* var form = obj.up('form');
    	  var thirdParty =  form.down("#thirdParty");
          var sponsors =  form.down("#sponsors");
          var applicant =  form.down("#applicant");
          var userId =  form.down("#userId");
          var student =  form.down("#student");
          
          var id=0;
          var billedUserType=null;
          if(!thirdParty.isHidden()){
        	  id = thirdParty.getValue();
        	  billedUserType = getFeeAndPaymentCommonTranslation('THIRD_PARTY_TYPE');

          }else if(!sponsors.isHidden()){
        	  id = sponsors.getValue();
        	  billedUserType = getFeeAndPaymentCommonTranslation('SPONSOR_TYPE');

          }else if(!applicant.isHidden()){
        	  id = applicant.getValue();
        	  billedUserType = getFeeAndPaymentCommonTranslation('APPLICANT_TYPE');

          }else if(!userId.isHidden()){
        	  id = userId.getValue();
        	  billedUserType = getFeeAndPaymentCommonTranslation('USER_TYPE');  

          }else if(!student.isHidden()){
        	  id = student.getValue();
        	  billedUserType = getFeeAndPaymentCommonTranslation('STUDENT_TYPE');

          }
          
    	  var value = form.down("#adjustmentFor").getValue();
    	  var showAllSettlement = form.down("#showAllSettlementId").getValue();
    	  var adjustment = form.down("#adjustment").getValue();
    	  var adjustmentType;
    	  
    	  switch(showAllSettlement){
    	  case 'ALL' :{
    		  showAllSettlement = 'All'
    			  break;
    	  }
    	  case 'FULLY_SETTELED' :{
    		  showAllSettlement = 'settled'
    			  break;
    	  }
    	  case 'NOT_FULLY_SETTELED' :{
    		  showAllSettlement = 'Pending'
    			  break;
    	  }
    	  }
    	  
		  if(adjustment=='RECEIPT'){
			  this.loadReceiptGrid(billedUserType,id,showAllSettlement);
			  adjustmentType = getFeeAndPaymentCommonTranslation('BILL_RECEIVABLE_LABEL');			  
		  }
		  else if(adjustment=='PAYMENT'){
			  this.loadPaymentGrid(billedUserType,id,showAllSettlement);
			  adjustmentType = getFeeAndPaymentCommonTranslation('BILL_PAYABLE_LABEL');
		  }
		  else if(adjustment=='BILL'){
			  adjustmentType = getFeeAndPaymentCommonTranslation('BILL_PAYABLE_LABEL');
			  this.loadBillGrid(billedUserType,id,adjustment,showAllSettlement);
		  }
		  
    	  this.loadBillReceivableGrid(billedUserType,id,adjustmentType,showAllSettlement);
 		 
 		  this.getReceiptslist().getSelectionModel().deselectAll();
    	  this.getPaymentslist().getSelectionModel().deselectAll();
    	  this.getBilllist().getSelectionModel().deselectAll();
    	  this.getInstumentdetailslist().getSelectionModel().deselectAll();
     	  this.getBillreceivablelist().getSelectionModel().deselectAll();*/
    	  
    	  var adjustmentForm =  obj.up('form');
    	  var manageSettlementCurrency = adjustmentForm.down('#manageSettlementCurrency').getValue();
    	  this.resetProgressTracker();
    	  var structure = this.getAdjustmentstructure();
    	  var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");
    	  var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
    	  progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
    	  progresstracker1.textEl.addCls("inProgressCss-progress-text");
    	  progresstracker1.updateText("Step 1 In Progress");
     	 this.getInitialFormView();
         },
         // *********load payment list(common for receipt) ***** 
         loadPaymentGrid : function(billedUserType,id,showAllSettlement,paymentHeaderId,manageSettlementCurrency,form){
        	 if(form){
        		 form.down('#searchBtn').setDisabled(true); 
        	 }
        	 var receiptAdjustmentstore = this.getStore('feeandpayment.adjustment.PaymentAdjustment');
        	 if(!isNullOrEmpty(manageSettlementCurrency)){
        		 var multiCurrencyValue = manageSettlementCurrency.getValue().currencyType;
        	 }
       	     receiptAdjustmentstore.getProxy().extraParams = {
       	    	 billedUserType: billedUserType,
       	    	 id:id,
       	    	 showAllSettlement:showAllSettlement,
       	    	 paymentHeaderId:paymentHeaderId,
       	    	 whetherCreatedCurrency:multiCurrencyValue,
       	    	 limit:-1
             };
       	 // receiptAdjustmentstore.load();
       	    receiptAdjustmentstore.load({
			   callback: function(records, operation, success) {
				   if (success && form.isValid()) {
					   form.down('#searchBtn').setDisabled(false); 
				   }
			   }
		   });
         },
         // *********load receipt list(common for receipt) ***** 
         loadReceiptGrid : function(billedUserType,id,showAllSettlement,instrumentNumberFieldValue,receiptHeaderId,manageSettlementCurrency,form){
        	 var receiptAdjustmentstore = this.getStore('feeandpayment.adjustment.ReceiptAdjustment');
        	 if(form){
        		 form.down('#searchBtn').setDisabled(true); 
        	 }
        	 if(!isNullOrEmpty(manageSettlementCurrency)){
        		 var multiCurrencyValue = manageSettlementCurrency.getValue().currencyType;
        	 }
        	 receiptAdjustmentstore.getProxy().extraParams = {
        		 billedUserType: billedUserType,
        		 id:id,
        		 showAllSettlement:showAllSettlement,
        		 instrumentId:instrumentNumberFieldValue,
        		 receiptHeaderId:receiptHeaderId,
        		 fetchBillOfOtherCurrency:multiCurrencyValue,
        		 limit:-1
        	 };
        	 receiptAdjustmentstore.load({
  			   callback: function(records, operation, success) {
  				   if (success && form.isValid()) {
  					   form.down('#searchBtn').setDisabled(false); 
  				   }
  			   }
  		   });
         },
         // *********load instrument list (common for instrument)***** 
         loadInstrumentGrid : function(receiptHeaderId,paymentHeaderId){
        	 var grid = this.getInstumentdetailslist();
        	 var store = grid.getStore();
         	 store.getProxy().extraParams = {
         		 receiptHeaderId:receiptHeaderId,
         		 paymentHeaderId:paymentHeaderId
                 };
         	 store.load();
         },
      // *********load receipt list(common for receipt) ***** 
         loadBillReceivableGrid : function(billedUserType,id,adjustmentType,showAllSettlement,manageSettlementCurrency){
        	 if(!isNullOrEmpty(manageSettlementCurrency)){
        		 var multiCurrencyValue = manageSettlementCurrency.getValue().currencyType;
        	 }
        	 var grid = this.getBillreceivablelist();
        	 var billAdjustmentstore = grid.getStore();
        	 billAdjustmentstore.getProxy().extraParams = {
        		 billedUserType: billedUserType,
        		 id:id,
        		 adjustmentType:adjustmentType,
        		 showAllSettlement:showAllSettlement,
        		 limit:1000,
        		 whetherCreatedCurrency:multiCurrencyValue
        	 };
        	 this.resetPageSetting(billAdjustmentstore);
        	 billAdjustmentstore.load();
         },
         loadBillReceivableGridForPayment : function(billedUserType,id,adjustmentType,showAllSettlement,manageSettlementCurrency){
        	 if(!isNullOrEmpty(manageSettlementCurrency)){
        		 var multiCurrencyValue = manageSettlementCurrency.getValue().currencyType;
        	 }
        	 var grid = this.getBillreceivablelist();
        	 var billAdjustmentstore = grid.getStore();
        	 // var billAdjustmentstore = this.getStore('feeandpayment.adjustment.BillToBillAdjustment');
        	 billAdjustmentstore.getProxy().extraParams = {
        		 billedUserType: billedUserType,
        		 id:id,
        		 adjustmentType:adjustmentType,
        		 showAllSettlement:showAllSettlement,
        		 limit:1000,
        		 whetherCreatedCurrency:multiCurrencyValue
        	 };
        	 this.resetPageSetting(billAdjustmentstore);
        	 billAdjustmentstore.load();
         },
         // *********load Bill list(common for bill to bill) ***** 
         loadBillGrid : function(billedUserType,id,adjustmentType,showAllSettlement,billId,manageSettlementCurrency,form){
             var feePlanType=null;   
        	 var billAdjustmentstore = this.getStore('feeandpayment.adjustment.BillToBillAdjustment');
        	 if(form){
        		 form.down('#searchBtn').setDisabled(true); 
        	 }
        	 if(!isNullOrEmpty(manageSettlementCurrency)){
        		 var multiCurrencyValue = manageSettlementCurrency.getValue().currencyType;
        	 }
        	 billAdjustmentstore.getProxy().extraParams = {
        		 billedUserType: billedUserType,
        		 id:id,
        		 adjustmentType:'Bill Receivable',
        		 feePlanType:feePlanType,
        		 showAllSettlement:showAllSettlement,
        		 limit:1000,
        		 billId : billId,
        		 whetherCreatedCurrency:multiCurrencyValue
        	 };
        	 this.resetPageSetting(billAdjustmentstore);
        	 billAdjustmentstore.load({
        		 callback: function(records, operation, success) {
        			 if (success && form.isValid()) {
        				 form.down('#searchBtn').setDisabled(false); 
        			 }
        		 }
        	 });
         },
       //**************** when select payment grid then it will call*************** 
         getCheckedPaymentListing : function(obj,record){
        	 var tabstructure = this.getAdjustmentstructure().down('adjustmenttabstructure');
        	 var buttonsToolBar = obj.query('toolbar')[0];
     		 var nextButton = buttonsToolBar.query('#nextBtn')[0];
     		 nextButton.setDisabled(true);
     		 tabstructure.down("#instumentdetailscontainer").setDisabled(true);
			 tabstructure.down("#billreceivablecontainer").setDisabled(true);
        	 var balanceAmount = record.get("totalBalanceAmount");
        	 if(balanceAmount > 0){
        		 nextButton.setDisabled(false);
        		 if(record.get("voucherMode")=='BANK'){
        			 var paymentHeaderId = record.get('id');
        			 var receiptHeaderId=null;
        			 this.loadInstrumentGrid(receiptHeaderId,paymentHeaderId);
        		 }else{
        			 var paymentHeaderId = 0;
        			 var receiptHeaderId=null;
        			 this.loadInstrumentGrid(receiptHeaderId,paymentHeaderId);
        		 }
        	 }else{
        		 var paymentHeaderId = 0;
    			 var receiptHeaderId=null;
    			 this.loadInstrumentGrid(receiptHeaderId,paymentHeaderId);
        	 }
//        	 this.resetProgressTracker();
         },
         //**************** when select reciept grid then it will call*************** 
         getCheckedReceiptListing : function(obj,record){
        	 var tabstructure = this.getAdjustmentstructure().down('adjustmenttabstructure');
        	 var buttonsToolBar = obj.query('toolbar')[0];
     		 var nextButton = buttonsToolBar.query('#nextBtn')[0];
     		 nextButton.setDisabled(true);
     		 tabstructure.down("#instumentdetailscontainer").setDisabled(true);
			 tabstructure.down("#billreceivablecontainer").setDisabled(true);
        	 var balanceAmount = record.get("totalBalanceAmount");
        	 if(balanceAmount > 0){
        		 nextButton.setDisabled(false);
        		 if(record.get("voucherMode")=='BANK'){
        			 var receiptHeaderId = record.get("id");
        			 var paymentHeaderId=null;
        			 this.loadInstrumentGrid(receiptHeaderId,paymentHeaderId);
        		 }else{
        			 var receiptHeaderId = 0;
        			 var paymentHeaderId=null;
        			 this.loadInstrumentGrid(receiptHeaderId,paymentHeaderId);
        		 }
        	 }else{
        		 var receiptHeaderId = 0;
    			 var paymentHeaderId=null;
    			 this.loadInstrumentGrid(receiptHeaderId,paymentHeaderId);
        	 }
//        	 this.resetProgressTracker();
         },
         getCheckedBillListing : function(obj,record){
        	 var tabstructure = this.getAdjustmentstructure().down('adjustmenttabstructure');
        	 var buttonsToolBar = obj.query('toolbar')[0];
     		 var nextButton = buttonsToolBar.query('#nextBtn')[0];
     		 nextButton.setDisabled(true);
     		 tabstructure.down("#instumentdetailscontainer").setDisabled(true);
			 tabstructure.down("#billreceivablecontainer").setDisabled(true);
        	 var balanceAmount = record.get("totalBalanceAmount");
        	 if(balanceAmount > 0){
        		 nextButton.setDisabled(false);
        	 }
//        	 this.resetProgressTracker();
         },
         //**************** when select Instrument grid then it will call***************
         getCheckedInstumentListing : function($this, record, index, eOpts){
        	 var grid = this.getInstumentdetailslist();
        	 var buttonsToolBar = grid.query('toolbar')[0];
     		 var nextInstrumentBtn = buttonsToolBar.query('#nextInstrumentBtn')[0];
        	 nextInstrumentBtn.setDisabled(true);
        	 if(eOpts=='select'){
        		 var instrumentAmount = record.get('totalInstrumentBalanceAmount');
        		 if(instrumentAmount > 0){
        			 nextInstrumentBtn.setDisabled(false);
        		 } 
        	 }
         },
         getCheckedAllBillsListing : function($this, record, index, eOpts){
        	 var grid = this.getAllbillslist();
        	 var buttonsToolBar = grid.query('toolbar')[0];
     		 var nextBtnAllBillBtn = buttonsToolBar.query('#nextBtnAllBillBtn')[0];
     		 
 		 	 nextBtnAllBillBtn.setDisabled(true);
        	 if(eOpts=='select'){
        		 var balanceAmount = record.get('balanceAmount');
        		 var amountToBeAdjusted = record.get('amountToBeAdjusted');
        		 if(balanceAmount > 0 || amountToBeAdjusted > 0){
        			 nextBtnAllBillBtn.setDisabled(false);
        		 } 
        	 } else if(grid.getSelectionModel().selected.length > 0 && eOpts=='deselct'){
        		 nextBtnAllBillBtn.setDisabled(false);
        	 }
         },
         /**
          * ********* changed when enter data for receipt/payment/bill*************
          */
         getCalulationForBalanceAmount : function(obj){
        	 var form = this.getAdjustmentstructure();
        	 var adjustment = form.down("#adjustment").getValue();
        	 var manageSettlementCurrency = form.down('#manageSettlementCurrency').getValue();
        	 var settedValue = obj.getValue();
        	 var grid = obj.ownerCt.grid;
        	 var recieptGrid = this.getReceiptslist();
        	 var paymentGrid = this.getPaymentslist();
        	 var billGrid = this.getBilllist();
        	 var instrumentGrid = this.getInstumentdetailslist();

        	 var store = grid.getStore();
        	 var rowIndex = grid.getRowIndexes();
        	 var records = store.getAt(rowIndex);

        	 var totalBalanceAmount = records.get('totalBalanceAmount');
        	 var billingAmount = records.get('totalTempBalanceAmount');        		 
        	 var convertedBalanceAmount = records.get('convertedBalanceAmount');  
        	 var exchangeRate = records.get('exchangeRate');
        	 var totalBaseBalanceAmount = totalBalanceAmount*exchangeRate;
        	 var billingBaseAmount = billingAmount*exchangeRate;

        	 var recipt_bill_amount = grid.ownerCt.down("#recipt_bill_balance_amount");
        	 

        	 if(manageSettlementCurrency.currencyType==true)
        	 {
        	 var recipt_bill_amount_value = parseFloat(recipt_bill_amount.getValue());

        	 if(settedValue > recipt_bill_amount_value || settedValue > totalBalanceAmount){
        		 
        		 Ext.defer(function() {
        			 records.set('amountToBeAdjusted',0);
        		 }, 50, this);
        		 showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('AMOUNT_TO_SETTLE_CANNOT_BE_GREATER_THAN_AVAILABLE_MOUNT'));//Please select a record
        	 }else{
        		 var newvalue = recipt_bill_amount_value - settedValue;
        		 recipt_bill_amount.setValue(parseFloat(newvalue.toFixed(2)));
        		 var totalBalanceAmountForBill = totalBalanceAmount-settedValue;
        		 records.set('totalBalanceAmount',totalBalanceAmountForBill);
        	 }
        	 }else
        	 {
        		var recipt_bill = recipt_bill_amount.getValue();
        		var arrValue = recipt_bill.split(' ');
        		var recipt_bill_amount_value=arrValue[1];
        		 if(settedValue > recipt_bill_amount_value || settedValue > convertedBalanceAmount){
        			 Ext.defer(function() {
        				 records.set('amountToBeAdjusted',0);
        			 }, 50, this);
        			 showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('AMOUNT_TO_SETTLE_CANNOT_BE_GREATER_THAN_AVAILABLE_MOUNT'));//Please select a record
        		 }else{
        			 recipt_bill_FinalAmount= parseFloat(recipt_bill_amount_value) - settedValue;
        			 recipt_bill_amount.setValue(arrValue[0]+" "+recipt_bill_FinalAmount.toFixed(2));
        			 var totalconvertedBalanceAmountForBill = convertedBalanceAmount-settedValue;
        			 records.set('convertedBalanceAmount',totalconvertedBalanceAmountForBill);
        		 }
        	 }
        	 
        	 /*if(settedValue==0){
        		
        	 }*/
        	 grid.getSelectionModel().deselectAll();
        	 settedValue = 0;
        },
        getCalulationForBalanceAmountForBillList : function(obj){
        	var form = this.getAdjustmentstructure();
        	var adjustment = form.down("#adjustment").getValue();
        	var manageSettlementCurrency = form.down('#manageSettlementCurrency').getValue();
        	var settedValue = obj.getValue();
        	var grid = obj.ownerCt.grid;

        	var store = grid.getStore();
        	var rowIndex = grid.getRowIndexes();
        	var records = store.getAt(rowIndex);

        	var totalBalanceAmount = records.get('balanceAmount');      		 
        	var convertedBalanceAmount = records.get('convertedBalanceAmount');   

        	var recipt_bill_amount = grid.ownerCt.down("#recipt_bill_balance_amount_ab");
        	
        	if(manageSettlementCurrency.currencyType==true)
       	 {
        	var recipt_bill_amount_value = parseFloat(recipt_bill_amount.getValue());

        	if(settedValue > recipt_bill_amount_value || settedValue > totalBalanceAmount){

        		Ext.defer(function() {
        			records.set('amountToBeAdjusted',0);
        		}, 50, this);
        		Ext.app.gridRendered = false;
        		showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('AMOUNT_TO_SETTLE_CANNOT_BE_GREATER_THAN_AVAILABLE_MOUNT'));//Please select a record
        	}else{
        		var newvalue = recipt_bill_amount_value - settedValue;
        		recipt_bill_amount.setValue(newvalue.toFixed(2));
        		var totalBalanceAmountForBill = totalBalanceAmount-settedValue;
        		records.set('balanceAmount',totalBalanceAmountForBill);
            		
            	}
       	 }else
       	 {
       		var recipt_bill = recipt_bill_amount.getValue();
       		var arrValue = recipt_bill.split(' ');
       		if(arrValue.length>1){
       			var recipt_bill_amount_value=arrValue[1]; 
       			if(settedValue > recipt_bill_amount_value || settedValue > convertedBalanceAmount){
       				Ext.defer(function() {
       					records.set('amountToBeAdjusted',0);
       				}, 50, this);
       				showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('AMOUNT_TO_SETTLE_CANNOT_BE_GREATER_THAN_AVAILABLE_MOUNT'));//Please select a record
       			}else{
       				recipt_bill_FinalAmount= parseFloat(recipt_bill_amount_value) - settedValue;
       				recipt_bill_amount.setValue(arrValue[0]+" "+recipt_bill_FinalAmount.toFixed(2));
       				var totalconvertedBalanceAmountForBill = convertedBalanceAmount-settedValue;
       				records.set('convertedBalanceAmount',totalconvertedBalanceAmountForBill);
       			}
       		}
       	 }
        	
        	selectionModel = grid.getSelectionModel();
        	selectedRow = selectionModel.getSelection();
        	amountToBeAdjusted = selectedRow[0].get('amountToBeAdjusted');
        	if(amountToBeAdjusted <= 0 || settedValue > recipt_bill_amount_value || settedValue > totalBalanceAmount){
        		selectionModel.deselect(selectedRow);
        	}
        	settedValue = 0;
        },
          // ******* get reset changes for cash ****************** 
          getResetForCashAndBank : function(){
        	  var $this= this;
        	  var form = this.getAdjustmentstructure();
    	      var adjustmentType = form.down("#adjustment").getValue();
        	
    	      var recieptGrid = $this.getReceiptslist();
        	  var paymentGrid = $this.getPaymentslist();
        	  var billGrid = $this.getBilllist();
        	  var instrumentGrid = $this.getInstumentdetailslist();
        	  var billReceivableGrid = $this.getBillreceivablelist();
        	  var allbillslist = $this.getAllbillslist();
        	  
        	  var receiptModel = recieptGrid.getSelectionModel();
        	  var paymentModel = paymentGrid.getSelectionModel();
        	  var billModel = billGrid.getSelectionModel();
        	  var instrumentModel = instrumentGrid.getSelectionModel();
        	 
        	  
        	  if(adjustmentType=='RECEIPT'){
        		  recieptGrid.getStore().reload();
            	  recieptGrid.getSelectionModel().deselectAll(); 
        	  }else if(adjustmentType=='PAYMENT'){
        		  paymentGrid.getStore().reload();
            	  paymentGrid.getSelectionModel().deselectAll();  
        	  }else if(adjustmentType=='BILL'){
        		  billGrid.getStore().reload();
        		  billGrid.getSelectionModel().deselectAll();  
        	  } 
        	  if(form.down('adjustmenttabstructure').getActiveTab().itemId == 'billreceivablecontainer'){
        		  billReceivableGrid.getStore().reload();
            	  billReceivableGrid.getSelectionModel().deselectAll();
        	  } else if(form.down('adjustmenttabstructure').getActiveTab().itemId == 'allbilllistcontainer'){
        		  allbillslist.getStore().reload();
        		  allbillslist.getSelectionModel().deselectAll();
        	  }
        	  
        	  var id = 0;
        	  var pId=0;
        	  this.loadInstrumentGrid(id,pId);
          },
          
          
          /**
           * save records for receipt detail 
           */
          getSaveReceiptDeatils :function(){
        	  var $this = this;

        	  var adjustmenttabstructure = $this.getAdjustmentstructure().down('adjustmenttabstructure');
        	  var recipt_bill_amount = adjustmenttabstructure.down('#recipt_bill_balance_amount');
        	  
        	  var adform = this.getAdjustmentstructure();
          	  var manageSettlementCurrency = adform.down('#manageSettlementCurrency').getValue();
          	  var adjustmentFor = adform.down("#adjustmentFor").getValue();
        	  if(manageSettlementCurrency.currencyType==false)
         	 {
        		  var arrValue = recipt_bill_amount.getValue().split(' ');
				  var receipt_bill_split_amount_value = arrValue[1];
				  var recipt_bill_amount_value= parseFloat(receipt_bill_split_amount_value);
         	 }else{
        	  var recipt_bill_amount_value = parseFloat(recipt_bill_amount.getValue());
         	 }
        	  

        	  var recieptGrid = $this.getReceiptslist();
        	  var instrumentGrid = $this.getInstumentdetailslist();
        	  var billReceivableGrid = $this.getBillreceivablelist();

        	  var selectedBillReceivableGrid = billReceivableGrid.selModel.getSelection();

        	  if(selectedBillReceivableGrid.length>0){
        		  var storeLength = billReceivableGrid.getStore().getRange();  
        		  var amountadjusted = 0;
        		  var count = 0;
        		  for(var i in storeLength){
        			  if(storeLength[i].get("amountToBeAdjusted")!=undefined && storeLength[i].get("amountToBeAdjusted")>0){
        				  count = count+1; 
        			  }
        		  }	  
        		  if(selectedBillReceivableGrid.length == count){

        			  var selectedRecieptGrid = recieptGrid.selModel.getSelection()[0];
        			  var selectedinstrumentGrid = instrumentGrid.selModel.getSelection()[0];

        			  var newValue=0;
        			  for(var i in selectedBillReceivableGrid){
        				  if(selectedBillReceivableGrid[i].data.amountToBeAdjusted!= undefined){
        					  newValue = parseFloat(newValue) + parseFloat(selectedBillReceivableGrid[i].data.amountToBeAdjusted);
        				  }
        			  }

        			  var adjustmentForCashModel = new Academia.model.feeandpayment.adjustment.AdjustmentForCash();
        			  var voucherMode = selectedRecieptGrid.data.voucherMode;
        			  if(voucherMode=='BANK'){
        				  adjustmentForCashModel.set("receiptPaymentInstrument",$this.getIdValueJson(selectedinstrumentGrid.data.id));
        				  adjustmentForCashModel.set("voucherMode",'BANK'); 
        				  
        				  var instrument_amount = selectedinstrumentGrid.get('totalInstrumentBalanceAmount');//parseInt(adjustmenttabstructure.down('#instrument_amount').getValue());
        	        	  var receipt_bill_amount = selectedRecieptGrid.get('totalBalanceAmount');//parseInt(adjustmenttabstructure.down('#receipt_bill_amount').getValue());
        	        	  var diffrenceAmount = receipt_bill_amount-instrument_amount;
        	        	  
        	        	  
        	        	  if(manageSettlementCurrency.currencyType==false)
        	          	 {
        	         		  var arrValue = recipt_bill_amount.getValue().split(' ');
        	 				  var receipt_bill_split_amount_value = arrValue[1];
        	 				  var recipt_bill_amount_valuechange = diffrenceAmount + parseFloat(receipt_bill_split_amount_value);
        	 				  var recipt_bill_amount_value= parseFloat(recipt_bill_amount_valuechange);
        	          	 }else{
        	        	  recipt_bill_amount_value = diffrenceAmount + recipt_bill_amount_value; 
        	          	 }
        				  
        			  }else{
        				  adjustmentForCashModel.set("voucherMode",'CASH');  
        			  }
        			  if(manageSettlementCurrency.currencyType==true)
        			  {
        			  adjustmentForCashModel.set("voucherType",'RECEIPT');
        			  adjustmentForCashModel.set("adjustedAmount",newValue);
        			  adjustmentForCashModel.set("balanceAmount",recipt_bill_amount_value);
        			  adjustmentForCashModel.set("receiptHeader",$this.getIdValueJson(selectedRecieptGrid.data.id));
        			  adjustmentForCashModel.set("adjustmentDate",Ext.Date.format(new Date(), CONSTANTS.SUBMIT_DATE_FORMAT));
        			  adjustmentForCashModel.set("paymentHeader",null);
        			  adjustmentForCashModel.set("adjustmentFor",adjustmentFor);
        			  //TODO
        			  // adjustmentForCashModel.set("paymentHeader",$this.getIdValueJson()); 
        			  var totalAdjustedAmount = 0;
        			  var BillReceivableJson=[];
        			  for(var i in selectedBillReceivableGrid){
        				  if(selectedBillReceivableGrid[i].data.amountToBeAdjusted!=undefined){
        					  totalAdjustedAmount = totalAdjustedAmount + selectedBillReceivableGrid[i].data.amountToBeAdjusted;
        					  BillReceivableJson.push({
        						  "voucherType":'RECEIPT',
        						  "billFeePlanRuleStageId":selectedBillReceivableGrid[i].data.billFeePlanRuleStageId,
        						  "billHeader":$this.getIdValueJson(selectedBillReceivableGrid[i].data.billHeaderId),
        						  "voucherMode":'CASH',
        						  "adjustedAmount":selectedBillReceivableGrid[i].data.amountToBeAdjusted,
        						  "balanceAmount":selectedBillReceivableGrid[i].data.totalBalanceAmount,
        						  "adjustmentDate":Ext.Date.format(new Date(), CONSTANTS.SUBMIT_DATE_FORMAT),
        						  "feeAdjustmentMaster":null
        					  });
        				  }
        			  }
        			  }else
        			  {
        				  adjustmentForCashModel.set("voucherType",'RECEIPT');
        				  adjustmentForCashModel.set("adjustedAmountInALBaseCurrency",newValue);
        				  adjustmentForCashModel.set("balanceAmountInALBaseCurrency",recipt_bill_amount_value);
        				  adjustmentForCashModel.set("receiptHeader",$this.getIdValueJson(selectedRecieptGrid.data.id));
        				  adjustmentForCashModel.set("adjustmentDate",Ext.Date.format(new Date(), CONSTANTS.SUBMIT_DATE_FORMAT));
        				  adjustmentForCashModel.set("paymentHeader",null);
        				  adjustmentForCashModel.set("adjustmentFor",adjustmentFor);
        				  //TODO
        				  // adjustmentForCashModel.set("paymentHeader",$this.getIdValueJson()); 
        				  var totalAdjustedAmount = 0;
        				  var BillReceivableJson=[];
        				  for(var i in selectedBillReceivableGrid){
        					  if(selectedBillReceivableGrid[i].data.amountToBeAdjusted!=undefined){
        						  totalAdjustedAmount = totalAdjustedAmount + selectedBillReceivableGrid[i].data.amountToBeAdjusted;
        						  BillReceivableJson.push({
        							  "voucherType":'RECEIPT',
        							  "billFeePlanRuleStageId":selectedBillReceivableGrid[i].data.billFeePlanRuleStageId,
        							  "billHeader":$this.getIdValueJson(selectedBillReceivableGrid[i].data.billHeaderId),
        							  "voucherMode":'CASH',
        							  "adjustedAmountInALBaseCurrency":selectedBillReceivableGrid[i].data.amountToBeAdjusted,
        							  "balanceAmountInALBaseCurrency":selectedBillReceivableGrid[i].data.convertedBalanceAmount,
        							  "adjustmentDate":Ext.Date.format(new Date(), CONSTANTS.SUBMIT_DATE_FORMAT),
        							  "feeAdjustmentMaster":null
        						  });
        					  }
        				  }
        			  
        				  
        			  }
        			  adjustmentForCashModel.set("feeAdjustmentDetails",BillReceivableJson);
        			  var adjustmentstructure =  adjustmenttabstructure.up("adjustmentstructure");
        			  var adjustmentfilters =  adjustmentstructure.down("#adjustmentfilters");
        			  var sponsors = adjustmentfilters.down("#sponsors");
        			  if(!sponsors.isHidden()){
        				  var recipt_bill_amount_ab = adjustmenttabstructure.down('#recipt_bill_balance_amount_ab');
        				  
        				  if(manageSettlementCurrency.currencyType==false)
         	          	 {
         	         		  var arrValue = recipt_bill_amount_ab.getValue().split(' ');
         	 				  var receipt_bill_split_amount_ab_value = arrValue[1];
         	 				  var recipt_bill_amount_ab_value= parseFloat(receipt_bill_split_amount_ab_value);
         	          	 }else{
         	          		 var recipt_bill_amount_ab_value = parseFloat(recipt_bill_amount_ab.getValue());
         	        	 
         	          	 }
        				  
        				 
        				  if(recipt_bill_amount_ab_value>=0){
        					  var submitData = Ext.encode(adjustmentForCashModel.data);
        					  var submitUrl = SERVERURL.FEE_ADJUSTMENT_CREATE;
        					  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        					  Ext.Ajax.request({
        						  url: submitUrl,
        						  jsonData: submitData,
        						  method: 'POST',
        						  success: function(response) {
        							  showSuccessMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('ADJUSTMENT_SUCCESS'));
        							  $this.getResetForCashAndBank();
        							  Ext.getBody().unmask();
        							  $this.setProgressTracker(3);
        							  $this.getInitialFormView();
        							  $this.updateProgressTracker();  
        							  if($this.getAdjustmentform())
        							  {
        								  var adjustmentform = $this.getAdjustmentform();
        								  adjustmentform.down('panel').scrollBy(0,1);
        								  adjustmentform.down('panel').scrollBy(0,-1);
        							  }

        						  }
        					  });
        				  }else{
        					  showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('PLEASE_SETTLE_TOTAL_AMOUNT'));
        				  }

        			  }else{
        				  var submitData = Ext.encode(adjustmentForCashModel.data);
        				  var submitUrl = SERVERURL.FEE_ADJUSTMENT_CREATE;
        				  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        				  Ext.Ajax.request({
        					  url: submitUrl,
        					  jsonData: submitData,
        					  method: 'POST',
        					  success: function(response) {
        						  showSuccessMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('ADJUSTMENT_SUCCESS'));
        						  $this.getResetForCashAndBank();
        						  Ext.getBody().unmask();
        						  $this.setProgressTracker(3);
        						  $this.getInitialFormView();
        						  $this.updateProgressTracker();  
        						  if($this.getAdjustmentform())
        						  {
        							  var adjustmentform = $this.getAdjustmentform();
        							  adjustmentform.down('panel').scrollBy(0,1);
        							  adjustmentform.down('panel').scrollBy(0,-1);
        						  }

        					  }
        				  });
        			  }
        		  }else{
        			  showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_ALL_UPDATED_RECORDS'));//Please select a record
        		  }
        	  }else{
        		  showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record 
        	  }
          },
          /**
           * save record from all bill list grid
           */
          saveBillSettelmentDetails: function(obj){
        	  obj.setDisabled(true);
        	  var $this = this;
        	  var billHeaderId;
        	  var adjustmenttabstructure = $this.getAdjustmentstructure().down('adjustmenttabstructure');
        	  var recipt_bill_amount = adjustmenttabstructure.down('#recipt_bill_balance_amount_ab');
        	  var adform = this.getAdjustmentstructure();
          	  var manageSettlementCurrency = adform.down('#manageSettlementCurrency').getValue();
        	  if(manageSettlementCurrency.currencyType==false)
         	 {
        		  var arrValue = recipt_bill_amount.getValue().split(' ');
				  var receipt_bill_split_amount_value = arrValue[1];
				  var recipt_bill_amount_value= parseFloat(receipt_bill_split_amount_value);
        		 // var recipt_bill_amount_value = parseFloat(recipt_bill_amount.getValue());
         	 }else{
        	  var recipt_bill_amount_value = parseFloat(recipt_bill_amount.getValue());
         	 }

        	  var recieptGrid = $this.getReceiptslist();
        	  var instrumentGrid = $this.getInstumentdetailslist();
        	  var allbillslist = $this.getAllbillslist();
        	  var selectedBillAllBillsList = allbillslist.selModel.getSelection();
              var record = allbillslist.getSelectionModel().getSelection()[0];
              if(record){
            	 billHeaderId = record.get("billHeaderId");
              }
              var receiptHeaderIdParam=this.receiptHeaderIdForMsg;
              Ext.Ajax.request({
			       method : "GET",
			       type : 'rest',
			       url: SERVERURL.FIND_BILL_STATUS,
			       params: {
			       billId : billHeaderId,
			         },
			       headers : {
			       'Content-Type' : 'application/json'
			        },
			       success: function(response) {
			       var data = Ext.decode(response.responseText);
			       if(data) {
				      showWarningMessage(getCommonTranslation('ALERT'), getFeeAndPaymentCommonTranslation('SELECTED_BILL_ALREADY_CANCELLED'));
				           }
                   else{
    			      Ext.Ajax.request({
			          method : "GET",
			          type : 'rest',
			          url: SERVERURL.FIND_RECEIPT_STATUS,
			          params:{
			           receiptId :receiptHeaderIdParam ,
			             },
			           headers :{
			           'Content-Type' : 'application/json'
			                           },
			           success: function(response) {
				        this.receiptHeaderIdForMsg=null;
			           var data = Ext.decode(response.responseText);
			        if(data) {
				        showWarningMessage(getCommonTranslation('ALERT'), getFeeAndPaymentCommonTranslation('SELECTED_RECEIPT_ALREADY_CANCELLED'));
				                 
				 }else if(selectedBillAllBillsList.length>0){
        		  var storeLength = allbillslist.getStore().getRange();  
        		  var amountadjusted = 0;
        		  var count = 0;
        		  for(var i in storeLength){
        			  if(storeLength[i].get("amountToBeAdjusted")!=undefined && storeLength[i].get("amountToBeAdjusted")>0){
        				  count = count+1; 
        			  }
        		  }	  
        		  if(selectedBillAllBillsList.length == count){//selectedBillReceivableGrid

        			  var selectedRecieptGrid = recieptGrid.selModel.getSelection()[0];
        			  var selectedinstrumentGrid = instrumentGrid.selModel.getSelection()[0];

        			  var newValue=0;
        			  for(var i in selectedBillAllBillsList){
        				  if(selectedBillAllBillsList[i].data.amountToBeAdjusted!= undefined){
        					  newValue = parseFloat(newValue) + parseFloat(selectedBillAllBillsList[i].data.amountToBeAdjusted);
        				  }
        			  }

        			  var adjustmentForCashModel = new Academia.model.feeandpayment.adjustment.AdjustmentForCash();
        			  var voucherMode = selectedRecieptGrid.data.voucherMode;
        			  if(voucherMode=='BANK'){
        				  adjustmentForCashModel.set("receiptPaymentInstrument",$this.getIdValueJson(selectedinstrumentGrid.data.id));
        				  adjustmentForCashModel.set("voucherMode",'BANK'); 
        				  
        				  var instrument_amount = selectedinstrumentGrid.get('totalInstrumentBalanceAmount');//parseInt(adjustmenttabstructure.down('#instrument_amount').getValue());
        	        	  var receipt_bill_amount = selectedRecieptGrid.get('totalBalanceAmount');//parseInt(adjustmenttabstructure.down('#receipt_bill_amount').getValue());
        	        	  var diffrenceAmount = receipt_bill_amount-instrument_amount;
        	        	  
        	        	  recipt_bill_amount_value = diffrenceAmount + recipt_bill_amount_value; 
        				  
        			  }else{
        				  adjustmentForCashModel.set("voucherMode",'CASH');  
        			  }

        			  if(manageSettlementCurrency.currencyType==true)
        			  {
        			  adjustmentForCashModel.set("voucherType",'RECEIPT');
        			  adjustmentForCashModel.set("adjustedAmount",newValue);
        			  adjustmentForCashModel.set("balanceAmount",recipt_bill_amount_value);
        			  adjustmentForCashModel.set("receiptHeader",$this.getIdValueJson(selectedRecieptGrid.data.id));
        			  adjustmentForCashModel.set("adjustmentDate",Ext.Date.format(new Date(), CONSTANTS.SUBMIT_DATE_FORMAT));
        			  adjustmentForCashModel.set("paymentHeader",null);
        			  //TODO
        			  // adjustmentForCashModel.set("paymentHeader",$this.getIdValueJson()); 
        			  var totalAdjustedAmount = 0;
        			  var BillReceivableJson=[];
        			  for(var i in selectedBillAllBillsList){
        				  if(selectedBillAllBillsList[i].data.amountToBeAdjusted!=undefined){
        					  totalAdjustedAmount = totalAdjustedAmount + selectedBillAllBillsList[i].data.amountToBeAdjusted;
        					  BillReceivableJson.push({
        						  "voucherType":'RECEIPT',
        						  "billFeePlanRuleStageId": null,//selectedBillAllBillsList[i].data.billFeePlanRuleStageId,
        						  "billHeader":$this.getIdValueJson(selectedBillAllBillsList[i].data.billHeaderId),
        						  "voucherMode":'CASH',
        						  "adjustedAmount":selectedBillAllBillsList[i].data.amountToBeAdjusted,
        						  "balanceAmount":selectedBillAllBillsList[i].data.balanceAmount,
        						  "adjustmentDate":Ext.Date.format(new Date(), CONSTANTS.SUBMIT_DATE_FORMAT),
        						  "feeAdjustmentMaster":null
        					  });
        				  }
        			  }
        			  }else
        			  {
        				  adjustmentForCashModel.set("voucherType",'RECEIPT');
        				  adjustmentForCashModel.set("adjustedAmountInALBaseCurrency",newValue);
        				  adjustmentForCashModel.set("balanceAmountInALBaseCurrency",recipt_bill_amount_value);
        				  adjustmentForCashModel.set("receiptHeader",$this.getIdValueJson(selectedRecieptGrid.data.id));
        				  adjustmentForCashModel.set("adjustmentDate",Ext.Date.format(new Date(), CONSTANTS.SUBMIT_DATE_FORMAT));
        				  adjustmentForCashModel.set("paymentHeader",null);
        				  //TODO
        				  // adjustmentForCashModel.set("paymentHeader",$this.getIdValueJson()); 
        				  var totalAdjustedAmount = 0;
        				  var BillReceivableJson=[];
        				  for(var i in selectedBillAllBillsList){
        					  if(selectedBillAllBillsList[i].data.amountToBeAdjusted!=undefined){
        						  totalAdjustedAmount = totalAdjustedAmount + selectedBillAllBillsList[i].data.amountToBeAdjusted;
        						  BillReceivableJson.push({
        							  "voucherType":'RECEIPT',
        							  "billFeePlanRuleStageId": null,//selectedBillAllBillsList[i].data.billFeePlanRuleStageId,
        							  "billHeader":$this.getIdValueJson(selectedBillAllBillsList[i].data.billHeaderId),
        							  "voucherMode":'CASH',
        							  "adjustedAmountInALBaseCurrency":selectedBillAllBillsList[i].data.amountToBeAdjusted,
        							  "balanceAmountInALBaseCurrency":selectedBillAllBillsList[i].data.convertedBalanceAmount,
        							  "adjustmentDate":Ext.Date.format(new Date(), CONSTANTS.SUBMIT_DATE_FORMAT),
        							  "feeAdjustmentMaster":null
        						  });
        					  }
        				  }
        			  }
        			  adjustmentForCashModel.set("feeAdjustmentDetails",BillReceivableJson);
        			  var adjustmentstructure = adjustmenttabstructure.up('adjustmentstructure');
                	  var adjustmentfilters =  adjustmentstructure.down("#adjustmentfilters");
                	  var adjustmentForItemId=adjustmentfilters.down("#adjustmentFor");
                	  var adjustmentFor = adjustmentForItemId.getValue();
                	  adjustmentForCashModel.set("adjustmentFor",adjustmentFor);
                	  var sponsors = adjustmentfilters.down("#sponsors");
                	  if(!sponsors.isHidden()){
                		  var recipt_bill_amount_ab = adjustmenttabstructure.down('#recipt_bill_balance_amount_ab');
                		  if(manageSettlementCurrency.currencyType==false)
                		  {
                			  var arrValue = recipt_bill_amount_ab.getValue().split(' ');
                			  var receipt_bill_split_amount_ab_value = arrValue[1];
                			  var recipt_bill_amount_ab_value= parseFloat(receipt_bill_split_amount_ab_value);
                		  }else{
                			  var recipt_bill_amount_ab_value = parseFloat(recipt_bill_amount_ab.getValue());
                		  }
        				  if(recipt_bill_amount_ab_value>=0){
                			  var submitData = Ext.encode(adjustmentForCashModel.data);
                			  var submitUrl = SERVERURL.SETTLEMENT_AT_BILL_LEVEL;
                			  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                			  obj.setDisabled(true);
                			  Ext.Ajax.request({
                				  url: submitUrl,
                				  jsonData: submitData,
                				  method: 'POST',
                				  success: function(response) {
                					  $this.getResetForCashAndBank();
                					  Ext.getBody().unmask();
                					  $this.setProgressTracker(3);
                					  $this.getInitialFormView();
                					  $this.updateProgressTracker();
                					  showSuccessMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('ADJUSTMENT_SUCCESS'));
                					  obj.setDisabled(false);
                				  }
                			  });
                			  
                		  }else{
                			  showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('PLEASE_SETTLE_TOTAL_AMOUNT'));
                		  }

        			  }else{
        				  var submitData = Ext.encode(adjustmentForCashModel.data);
            			  var submitUrl = SERVERURL.SETTLEMENT_AT_BILL_LEVEL;
            			  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            			  obj.setDisabled(true);
            			  Ext.Ajax.request({
            				  url: submitUrl,
            				  jsonData: submitData,
            				  method: 'POST',
            				  success: function(response) {
            					  $this.getResetForCashAndBank();
            					  Ext.getBody().unmask();
            					  $this.setProgressTracker(3);
            					  $this.getInitialFormView();
            					  $this.updateProgressTracker();
            					  showSuccessMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('ADJUSTMENT_SUCCESS'));
            					  obj.setDisabled(false);
            				  }
            			  });
        				  
        			  }
        			 
        		  }else{
        			  showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_ALL_UPDATED_RECORDS'));//Please select a record
        			  obj.setDisabled(false);
        		  }
        	  } else{
        		  showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record 
        		  obj.setDisabled(false);
        	  }
			                      }
			                    	});
                                }
			                      }
			                    	});
         

          },
          
          /**
           * save records for payment detail 
           */
          getSavePaymentDeatils :function(){
        	  var $this = this;
        	  
        	  var adjustmenttabstructure = $this.getAdjustmentstructure().down('adjustmenttabstructure');
        	  var payment_bill_amount = adjustmenttabstructure.down('#recipt_bill_balance_amount');
        	  var payment_bill_amount_value = parseFloat(payment_bill_amount.getValue());
        	  
        	  var paymentGrid = $this.getPaymentslist();
        	  var instrumentGrid = $this.getInstumentdetailslist();
        	  var billReceivableGrid = $this.getBillreceivablelist();
        	  var selectedBillReceivableGrid = billReceivableGrid.selModel.getSelection();
        	  var structure = this.getAdjustmentstructure();
        	  var form = structure.down('adjustmentfilters');
    		  var manageSettlementCurrency =  form.down("#manageSettlementCurrency");
    		  var adjustmentFor = form.down("#adjustmentFor").getValue();

        	  if(selectedBillReceivableGrid.length>0){
        		  var storeLength = billReceivableGrid.getStore().getRange();  
        		  var amountadjusted = 0;
        		  var count = 0;
        		  for(var i in storeLength){
        			  if(storeLength[i].get("amountToBeAdjusted")!=undefined && storeLength[i].get("amountToBeAdjusted")>0){
        				  count = count+1; 
        			  }
        		  }	  
        		  if(selectedBillReceivableGrid.length == count){
        			  
        			  var selectedPaymentGrid = paymentGrid.selModel.getSelection()[0];
        			  var selectedinstrumentGrid = instrumentGrid.selModel.getSelection()[0];

        			  var newValue=0;
        			  for(var i in selectedBillReceivableGrid){
        				  if(selectedBillReceivableGrid[i].data.amountToBeAdjusted!= undefined){
        					  newValue = parseFloat(newValue) + parseFloat(selectedBillReceivableGrid[i].data.amountToBeAdjusted);
        				  }
        			  }
        			  var adjustmentForCashModel = new Academia.model.feeandpayment.adjustment.AdjustmentForCash();
        			  var voucherMode = selectedPaymentGrid.data.voucherMode;
        			  if(voucherMode=='BANK'){
        				  adjustmentForCashModel.set("receiptPaymentInstrument",$this.getIdValueJson(selectedinstrumentGrid.data.id));
        				  adjustmentForCashModel.set("voucherMode",'BANK'); 
        			 
        				  var instrument_amount = selectedinstrumentGrid.get('totalInstrumentBalanceAmount');//parseInt(adjustmenttabstructure.down('#instrument_amount').getValue());
        	        	  var payment_bill_amount = selectedPaymentGrid.get('totalBalanceAmount');//parseInt(adjustmenttabstructure.down('#receipt_bill_amount').getValue());
        	        	  var diffrenceAmount = payment_bill_amount-instrument_amount;
        	        	  
        	        	  payment_bill_amount_value = diffrenceAmount + payment_bill_amount_value;
        			  
        			  }else{
        				  adjustmentForCashModel.set("voucherMode",'CASH');  
        			  }
        			  var BillReceivableJson=[];
        			  if(manageSettlementCurrency.getValue().currencyType==true)
        			  {
        			  adjustmentForCashModel.set("voucherType",'PAYMENT');
        			  adjustmentForCashModel.set("adjustedAmount",newValue);
        			  adjustmentForCashModel.set("balanceAmount",payment_bill_amount_value);
        			  adjustmentForCashModel.set("paymentHeader",$this.getIdValueJson(selectedPaymentGrid.data.id));
        			  adjustmentForCashModel.set("adjustmentDate",Ext.Date.format(new Date(), CONSTANTS.SUBMIT_DATE_FORMAT));
        			  adjustmentForCashModel.set("receiptHeader",null);
        			  adjustmentForCashModel.set("adjustmentFor",adjustmentFor);
        			  var BillReceivableJson=[];
        			  for(var i in selectedBillReceivableGrid){
        				  if(selectedBillReceivableGrid[i].data.amountToBeAdjusted!=undefined){
        					  BillReceivableJson.push({
        						  "voucherType":'RECEIPT',
        						  "voucherMode":'CASH',
        						  "billFeePlanRuleStageId":selectedBillReceivableGrid[i].data.billFeePlanRuleStageId,
        						  "adjustedAmount":selectedBillReceivableGrid[i].data.amountToBeAdjusted,
        						  "balanceAmount":selectedBillReceivableGrid[i].data.totalBalanceAmount,
        						  "billHeader":$this.getIdValueJson(selectedBillReceivableGrid[i].data.billHeaderId),
        						  "adjustmentDate":Ext.Date.format(new Date(), CONSTANTS.SUBMIT_DATE_FORMAT),
        						  "feeAdjustmentMaster":null
        					  });
        				  }
        			  }
        			  }else
        			  {
        				  var payment_bill = adjustmenttabstructure.down('#recipt_bill_balance_amount');
        				  var payment_amount = payment_bill.getValue();
        				  var arrValue = payment_amount.split(' ');
        				  var Payment_bill_split_amount_value = arrValue[1];
        				  var recipt_bill_final_amount= parseFloat(Payment_bill_split_amount_value);
        				  adjustmentForCashModel.set("voucherType",'PAYMENT');
            			  adjustmentForCashModel.set("adjustedAmountInALBaseCurrency",newValue);
            			  adjustmentForCashModel.set("balanceAmountInALBaseCurrency",recipt_bill_final_amount);
            			  adjustmentForCashModel.set("paymentHeader",$this.getIdValueJson(selectedPaymentGrid.data.id));
            			  adjustmentForCashModel.set("adjustmentDate",Ext.Date.format(new Date(), CONSTANTS.SUBMIT_DATE_FORMAT));
            			  adjustmentForCashModel.set("receiptHeader",null);  
            			  adjustmentForCashModel.set("adjustmentFor",adjustmentFor);
            			  for(var i in selectedBillReceivableGrid){
            				  if(selectedBillReceivableGrid[i].data.amountToBeAdjusted!=undefined){
            					  BillReceivableJson.push({
            						  "voucherType":'RECEIPT',
            						  "voucherMode":'CASH',
            						  "billFeePlanRuleStageId":selectedBillReceivableGrid[i].data.billFeePlanRuleStageId,
            						  "adjustedAmountInALBaseCurrency":selectedBillReceivableGrid[i].data.amountToBeAdjusted,
            						  "balanceAmountInALBaseCurrency":selectedBillReceivableGrid[i].data.convertedBalanceAmount,
            						  "billHeader":$this.getIdValueJson(selectedBillReceivableGrid[i].data.billHeaderId),
            						  "adjustmentDate":Ext.Date.format(new Date(), CONSTANTS.SUBMIT_DATE_FORMAT),
            						  "feeAdjustmentMaster":null
            					  });
            				  }
            			  }
        			  }

        			  adjustmentForCashModel.set("feeAdjustmentDetails",BillReceivableJson);

        			  var submitData = Ext.encode(adjustmentForCashModel.data);
        			  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        			  var submitUrl = SERVERURL.FEE_ADJUSTMENT_CREATE;
        			  Ext.Ajax.request({
        				  url: submitUrl,
        				  jsonData: submitData,
        				  method: 'POST',
        				  success: function(response) {
        					  showSuccessMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('ADJUSTMENT_SUCCESS'));
        					  $this.getResetForCashAndBank();
        					  Ext.getBody().unmask();
        					  $this.setProgressTracker(3);
        					  $this.getInitialFormView();
        					  $this.updateProgressTracker();
        					  if($this.getAdjustmentform())
        					  {
        						  var adjustmentform = $this.getAdjustmentform();
        						  adjustmentform.down('panel').scrollBy(0,1);
        						  adjustmentform.down('panel').scrollBy(0,-1);
        					  }
        				  }
        			  });
        		  }else{
        			  showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_ALL_UPDATED_RECORDS'));//Please select a record
        		  }
        	  }else{
        		  showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record 
        	  }
          },
          /**
           * save records for bill detail 
           */
          getSaveBillDeatils :function(){
        	  var $this = this;

        	  var adjustmenttabstructure = $this.getAdjustmentstructure().down('adjustmenttabstructure');
        	  var bill_amount = adjustmenttabstructure.down('#recipt_bill_balance_amount');
        	  var bill_amount_value = parseFloat(bill_amount.getValue());

        	  var billGrid = $this.getBilllist();
        	  var billReceivableGrid = $this.getBillreceivablelist();

        	  var selectedBillReceivableGrid = billReceivableGrid.selModel.getSelection();

        	  if(selectedBillReceivableGrid.length>0){
        		  var storeLength = billReceivableGrid.getStore().getRange();  
        		  var amountadjusted = 0;
        		  var count = 0;
        		  for(var i in storeLength){
        			  if(storeLength[i].get("amountToBeAdjusted")!=undefined && storeLength[i].get("amountToBeAdjusted")>0){
        				  count = count+1; 
        			  }
        		  }	  
        		  if(selectedBillReceivableGrid.length == count){

        			  var selectedBillGrid = billGrid.selModel.getSelection()[0];

        			  var newValue=0;
        			  for(var i in selectedBillReceivableGrid){
        				  if(selectedBillReceivableGrid[i].data.amountToBeAdjusted!= undefined){
        					  newValue = parseFloat(newValue) + parseFloat(selectedBillReceivableGrid[i].data.amountToBeAdjusted);
        				  }
        			  }

        			  var adjustmentForCashModel = new Academia.model.feeandpayment.adjustment.AdjustmentForCash();
        			  var adForm = $this.getAdjustmentstructure().down('adjustmentfilters');
            		  var manageSettlementCurrency =  adForm.down("#manageSettlementCurrency").getValue();
            		  var adjustmentFor = adForm.down("#adjustmentFor").getValue();
            		  if(manageSettlementCurrency.currencyType == true){
        			  adjustmentForCashModel.set("voucherType",null);
        			  adjustmentForCashModel.set("voucherMode",null);
        			  adjustmentForCashModel.set("adjustedAmount",newValue);
        			  adjustmentForCashModel.set("balanceAmount",bill_amount_value);
        			  adjustmentForCashModel.set("receiptPaymentInstrument",null);    
        			  adjustmentForCashModel.set("receiptHeader",null);        
        			  adjustmentForCashModel.set("paymentHeader",null);        
        			  adjustmentForCashModel.set("adjustmentDate",Ext.Date.format(new Date(), CONSTANTS.SUBMIT_DATE_FORMAT));      
        			  adjustmentForCashModel.set("billFeePlanRuleStage",$this.getIdValueJson(selectedBillGrid.data.billFeePlanRuleStageId));
        			  adjustmentForCashModel.set("billHeader",$this.getIdValueJson(selectedBillGrid.data.billHeaderId));
        			  adjustmentForCashModel.set("adjustmentFor",adjustmentFor);
        			  var BillReceivableJson=[];
        			  for(var i in selectedBillReceivableGrid){
        				  if(selectedBillReceivableGrid[i].data.amountToBeAdjusted!=undefined){
        					  BillReceivableJson.push({
        						  "voucherType":null,
        						  "billFeePlanRuleStageId":selectedBillReceivableGrid[i].data.billFeePlanRuleStageId,
        						  "voucherMode":null,
        						  "adjustedAmount":selectedBillReceivableGrid[i].data.amountToBeAdjusted,
        						  "balanceAmount":selectedBillReceivableGrid[i].data.totalBalanceAmount,
        						  "billHeader":$this.getIdValueJson(selectedBillReceivableGrid[i].data.billHeaderId),
        						  "adjustmentDate":Ext.Date.format(new Date(), CONSTANTS.SUBMIT_DATE_FORMAT)  ,
        						  "feeAdjustmentMaster":null
        					  });
        				  }
        			  }
            		  }else{
            			  var payment_bill = adjustmenttabstructure.down('#recipt_bill_balance_amount');
            			           var payment_amount = payment_bill.getValue();
            			           var arrValue = payment_amount.split(' ');
            			           var Payment_bill_split_amount_value = arrValue[1];
            			           var recipt_bill_final_amount= parseFloat(Payment_bill_split_amount_value);
            			  
            			  
            			  adjustmentForCashModel.set("voucherType",null);
            			  adjustmentForCashModel.set("voucherMode",null);
            			  adjustmentForCashModel.set("adjustedAmountInALBaseCurrency",newValue);
            			  adjustmentForCashModel.set("balanceAmountInALBaseCurrency",recipt_bill_final_amount);
            			  adjustmentForCashModel.set("receiptPaymentInstrument",null);    
            			  adjustmentForCashModel.set("receiptHeader",null);        
            			  adjustmentForCashModel.set("paymentHeader",null);        
            			  adjustmentForCashModel.set("adjustmentDate",Ext.Date.format(new Date(), CONSTANTS.SUBMIT_DATE_FORMAT));      
            			  adjustmentForCashModel.set("billFeePlanRuleStage",$this.getIdValueJson(selectedBillGrid.data.billFeePlanRuleStageId));
            			  adjustmentForCashModel.set("billHeader",$this.getIdValueJson(selectedBillGrid.data.billHeaderId));
            			  adjustmentForCashModel.set("adjustmentFor",adjustmentFor);
            			  var BillReceivableJson=[];
            			  
            			  for(var i in selectedBillReceivableGrid){
            				  if(selectedBillReceivableGrid[i].data.amountToBeAdjusted!=undefined){
            					  BillReceivableJson.push({
            						  "voucherType":null,
            						  "billFeePlanRuleStageId":selectedBillReceivableGrid[i].data.billFeePlanRuleStageId,
            						  "voucherMode":null,
            						 // "adjustedAmount":selectedBillReceivableGrid[i].data.amountToBeAdjusted,
            						 // "balanceAmount":selectedBillReceivableGrid[i].data.totalBalanceAmount,
            						  "billHeader":$this.getIdValueJson(selectedBillReceivableGrid[i].data.billHeaderId),
            						  "adjustmentDate":Ext.Date.format(new Date(), CONSTANTS.SUBMIT_DATE_FORMAT)  ,
            						  "feeAdjustmentMaster":null,
            						  "adjustedAmountInALBaseCurrency":selectedBillReceivableGrid[i].data.amountToBeAdjusted,
            						  "balanceAmountInALBaseCurrency":selectedBillReceivableGrid[i].data.convertedBalanceAmount
            					  });
            				  }
            			  }
            			  
            		  }
        			  
        			  adjustmentForCashModel.set("feeAdjustmentDetails",BillReceivableJson);

        			  var submitData = Ext.encode(adjustmentForCashModel.data);
        			  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        			  var submitUrl = SERVERURL.FEE_ADJUSTMENT_CREATE;
        			  Ext.Ajax.request({
        				  url: submitUrl,
        				  jsonData: submitData,
        				  method: 'POST',
        				  success: function(response) {
        					  showSuccessMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('ADJUSTMENT_SUCCESS'));
        					  $this.getResetForCashAndBank();
        					  Ext.getBody().unmask();
        					  $this.setProgressTracker(3);
        					  $this.getInitialFormView();
        					  if($this.getAdjustmentform())
        					  {
        						  var adjustmentform = $this.getAdjustmentform();
        						  adjustmentform.down('panel').scrollBy(0,1);
        						  adjustmentform.down('panel').scrollBy(0,-1);
        					  }
        					  Ext.defer(function() {
        						  $this.resetProgressTracker();
        						  var structure = $this.getAdjustmentstructure();
        				    	  var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");
        				    	  var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
        				    	  progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
        				    	  progresstracker1.textEl.addCls("inProgressCss-progress-text");
        				    	  progresstracker1.updateText("Step 1 In Progress");
                  	        }, 1500, this);
        				  }
        			  });
        		  }else{
        			  showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_ALL_UPDATED_RECORDS'));//Please select a record
        		  }
        	  }else{
        		  showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record 
        	  }
          },

          //***** user can see adjustment details of receipt *********
          getViewAdjustment : function(grid,record){
        	  var form = this.getAdjustmentstructure();
        	  var adjustmentType = form.down("#adjustment").getValue();

        	  var receiptHeaderId=null;
        	  var paymentHeaderId=null;

        	  if(adjustmentType=='RECEIPT'){
        		  receiptHeaderId = record.get("id");
        	  }else if(adjustmentType=='PAYMENT'){
        		  paymentHeaderId = record.get("id");
        	  }

        	  var formWindow = this.getReceiptviewgridwindow();
        	  if (!formWindow) {
        		  Ext.widget('receiptviewgridwindow');
        		  formWindow = this.getReceiptviewgridwindow();
        	  }

        	  var store = formWindow.down("#receiptviewgrid").getStore();
        	  store.getProxy().extraParams = {
        		  receiptHeaderId: receiptHeaderId,
        		  paymentHeaderId: paymentHeaderId
        	  };
        	  store.load();
        	  formWindow.show();
          },
          //**************** when select bill receivable grid then it will call*************** 
          getViewBillReceivableAdjustment : function(grid,record){
        	  var $this=this;
        	  var form = this.getAdjustmentstructure();
    	      var adjustmentType = form.down("#adjustment").getValue();
    	      var raiseBillCategory = record.get("raiseBillCategory");
        	  var billFeeRuleStageId = record.get("billFeePlanRuleStageId");
        	  
        	 
        	  var formWindow = $this.getReceiptandpaymentgridwindow();
    	          if (!formWindow) {
    	            Ext.widget('receiptandpaymentgridwindow');
    	            formWindow = $this.getReceiptandpaymentgridwindow();
    	          }
    	          formWindow.show();

    	          var bindingStore = this.getStore('feeandpayment.common.BillSettlementViewDetails');
    	          var grid=$this.getReceiptAndPaymentGrid();
    	          var paginationStore = grid.getDockedItems()[2].items.items[0];
    	          grid.bindStore(bindingStore);
    	          paginationStore.bindStore(bindingStore);
    	          var store = grid.getStore();
    	          store.getProxy().extraParams = {
    	        	  billFeeRuleStageId: billFeeRuleStageId,
    	        	  raiseBillCategory:raiseBillCategory
    	          };
    	          store.load();
          },
          
          // get check adjustmenty (Receipt or payment)
          getCheckAdjustment : function(obj,record){
        	  
        	  var form = obj.up('form');
        	  var adjustmenttabstructure = this.getAdjustmentstructure().down('adjustmenttabstructure');
        	  var newValue = record[0].get('id');
        	  
        	  var billedUserType = form.down("#adjustmentFor").getValue();
        	  var adjustment = form.down("#adjustment").getValue();
        	  var showAllSettlement = form.down("#showAllSettlementId").getValue();
        	  var instrumentNumberField =  form.down("#instrumentNumberId");
        	  var receiptNo = form.down("#receiptNoId");
              var paymentNo = form.down("#paymentNoId");
              var billNo = form.down("#billNoId"),
              settledWithCheckBoxId = form.down('#settleWithCheckBoxId');
              
               if(obj.getValue()!="BILL")
               {
	               this.billHeaderIdForMsg=null;
                }
               if(obj.getValue()!='PAYMENT') 
               {
	              this.paymentHeaderIdForMsg=null;
                }
               if(obj.getValue()!='RECEIPT')
               {
	            this.receiptHeaderIdForMsg=null;
               }
              
              
              receiptNo.reset();
              paymentNo.reset();
              billNo.reset();
        	  instrumentNumberField.reset();
        	  settledWithCheckBoxId.reset();
        	  
        	  var adjustmentType=null;
        	  
        	  
        	  var formLayout = this.getAdjustmentFilters();
        	  var academyLocationId = formLayout.down("#fnpBrandCampusItemId").getValue();
        	  var alFilterField = form.down("#student");
        	  
        	  
        	  
        	  adjustmenttabstructure.down('#paymentReceiptSetttlementcontainer').setDisabled(true);
        	  adjustmenttabstructure.setActiveTab( adjustmenttabstructure.down('#listcontainer'));
        	  if(adjustment=='RECEIPT'){
        		   adjustmentType = 'Bill Receivable';
        		   adjustmenttabstructure.down('#allbilllistcontainer').tab.show();
        		   if(billedUserType=="SPONSOR"){
        			   instrumentNumberField.setVisible(true);
        			   instrumentNumberField.setDisabled(true);
        		   }else{
        			   instrumentNumberField.setVisible(false);
        			   instrumentNumberField.setDisabled(true);
        		   }
        		   receiptNo.setVisible(true);
        		   paymentNo.setVisible(false);
         		   billNo.setVisible(false);
         		   
         		   receiptNo.setDisabled(true);
        		   paymentNo.setDisabled(true);
        		   billNo.setDisabled(true);
        		   settledWithCheckBoxId.setBoxLabel(getCommonTranslation('SETTLE_WITH_PAYMENT'));
        		   if(this.isVisibleSettleWithCheckBox && billedUserType=='STUDENT'){
        			   //settledWithCheckBoxId.setVisible(true);
        		   }
        	  }else if(adjustment=='PAYMENT'){
        		  adjustmenttabstructure.down('#allbilllistcontainer').tab.hide();
        		  adjustmentType = 'Bill Payable';
        		  instrumentNumberField.setVisible(false);
        		  instrumentNumberField.setDisabled(true);
        		  paymentNo.setVisible(true);
        		  receiptNo.setVisible(false);
        		  billNo.setVisible(false);
        		  
        		  receiptNo.setDisabled(true);
        		  paymentNo.setDisabled(true);
       		   	  billNo.setDisabled(true);
       		      settledWithCheckBoxId.setBoxLabel(getCommonTranslation('SETTLE_WITH_RECEIPT'));
       		      if(this.isVisibleSettleWithCheckBox && billedUserType=='STUDENT'){
       		    	  //settledWithCheckBoxId.setVisible(true);
       		      }
        	  }else{
        		  adjustmentType = 'Bill Receivable';
        		  adjustmenttabstructure.down('#allbilllistcontainer').tab.hide();
        		  instrumentNumberField.setVisible(false);
        		  instrumentNumberField.setDisabled(true);
        		  billNo.setVisible(true);
        		  paymentNo.setVisible(false);
        		  receiptNo.setVisible(false);
        		  
        		  receiptNo.setDisabled(true);
       		   	  paymentNo.setDisabled(true);
       		      billNo.setDisabled(true);
       		     settledWithCheckBoxId.setVisible(false);
        	  }

        	  var id=0;
        	  var pId=0;
        	  this.loadInstrumentGrid(id,pId);
        	  this.loadBillReceivableGrid(billedUserType,id,adjustmentType);
        	  
        	  form.down("#thirdParty").reset();
        	  form.down("#sponsors").reset();
        	  form.down("#applicant").reset();
        	  form.down("#userId").reset();
        	  form.down("#student").reset(); 
        	  
        	  adjustmenttabstructure.down("#receiptslist").setVisible(false);
        	  adjustmenttabstructure.down("#paymentslist").setVisible(false);
        	  adjustmenttabstructure.down("#billlist").setVisible(false);
        	  
        	  var billlist = adjustmenttabstructure.down("#billlist");
        	  var billreceivablelist = adjustmenttabstructure.down("#billreceivablelist");
        	  
          	 var instrumentGrid = this.getInstumentdetailslist();
        	  
        	  if(newValue=='RECEIPT'){
        		  billreceivablelist.setTitle(getFeeAndPaymentCommonTranslation('BILL_RECEIVABLE_LABEL'));
        		  adjustmenttabstructure.down("#receiptslist").setVisible(true);
        		  this.loadPaymentGrid(billedUserType,id,showAllSettlement,'','',form);
        	  }
        	  else if(newValue=='PAYMENT'){
        		  billreceivablelist.setTitle(getFeeAndPaymentCommonTranslation('BILL_PAYABLE_LABEL'));
        		  adjustmenttabstructure.down("#paymentslist").setVisible(true);
        		  this.loadReceiptGrid(billedUserType,id,showAllSettlement,'','','',form);
        	  }
        	  else if(newValue=='BILL'){
        		  billreceivablelist.setTitle(getFeeAndPaymentCommonTranslation('BILL_PAYABLE_LABEL'));
        		  adjustmenttabstructure.down("#billlist").setVisible(true); 
        		  this.loadBillGrid(billedUserType,id,adjustmentType,showAllSettlement,'','',form);
        	  }
        	  //this.getInitialFormView();
        	  this.resetProgressTracker();
          },
          //******* get id value json **********
          getIdValueJson: function(id, value) {
      		if (id) return {
      			id: id,
      			value: value
      		};
      	},
      	
    //*********Export Functionality***************************//
        exportJRXML: function(fileType) {
        	// code to get selected row
        	var $this = this;
        	var selectedId = 0;
        	grid = $this.getReceiptslist();
     		if (grid.getSelectionModel().getCount() > 0) {
        	var record = grid.getSelectionModel().getSelection()[0];
        	selectedId = record.get("id");
     		user=$this.getCurrentlyLoggedInUser();
        	
        	// code to identify jasper
	        
	        var reportParams =new Object();
	        reportParams.userId=user.code;
	        reportParams.ids=String(selectedId); // convert int into string
	        if(record.data.totalAdjustedAmount==0)
	        {
	        	var reportTitle=getFeeAndPaymentCommonTranslation('MANAGE_RECEIPT_JASPER_TITLE');
	        	var exportUrl = SERVERURL.MANAGE_RECEIPT_PDF;
	        	var code ="MANAGE_RECEIPT_CODE";

	        }else
	        {
	        	var reportTitle=getFeeAndPaymentCommonTranslation('MANAGE_RECEIPT_SETTLEMENT_JASPER_TITLE');
	        	var exportUrl = SERVERURL.MANAGE_RECEIPT_SETTLEMENT_PDF;
	        	var code ="MANAGE_RECEIPT_SETTLEMENT_CODE";
	        }
	        if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true") {
	        	code="MANAGE_RECEIPT_CODE";
	        	reportTitle=getFeeAndPaymentCommonTranslation('MANAGE_RECEIPT_JASPER_TITLE');
	        	exportUrl=SERVERURL.MANAGE_RECEIPT_PDF
	        }
	        
	        var store=$this.getStore('examinationcenters.IsTemplateMappedStore');
	        store.getProxy().extraParams={
	        	code:code
	        };
	        store.load({
	        	callback:function(rec,obj,success){
	        		if(obj.response.responseText=="true"){
	        			$this.exportJRXMLReport(code,reportParams,reportTitle,fileType,exportUrl);
	        		}else{
	        			showWarningMessage(getCommonTranslation('ALERT'),getTranslation('TEMPLATE_MAPPING_ERROR'));
	        		}
      			}
	        });
     		}else
     		{
     			 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
     		}
        },

      	//****** Cancel Adjustments for receipt , bill and payment**********
        getCancelSettlements : function(id,billFeePlanRuleStageId){
            var $this = this;
        	var structure = this.getAdjustmentstructure();
        	var value = structure.down("#adjustment").getValue();
        	var adjustmentType = null;

        	var grid = null;

        	if(value=='RECEIPT'){
        		adjustmentType = getFeeAndPaymentCommonTranslation('RECEIPT_MSSG');
        		grid = this.getReceiptslist();
        	}else if(value=='PAYMENT'){
        		adjustmentType = getFeeAndPaymentCommonTranslation('PAYMENT_TITLE');
        		grid = this.getPaymentslist();
        	}else if(value=='BILL'){
        		adjustmentType = getFeeAndPaymentCommonTranslation('Bill');
        		grid = this.getBilllist();
        	}

        	var billReceivableGrid = this.getBillreceivablelist();
        	var instumentdetailGrid = this.getInstumentdetailslist();
        		showConfirmMessage(getFeeAndPaymentCommonTranslation('RECEIPT_MSSG'), getFeeAndPaymentCommonTranslation('DELETE_RECEIPT_AND_SETTLEMENT'), function(btn, text) {
        		if (btn == 'yes') {
        			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        			Ext.Ajax.request({
        				method: "GET",
        				type: 'rest',
        				url: SERVERURL.CANCEL_ADJUSTMENT_URL,
        				params:{
        					id:id,
        					adjustmentType:adjustmentType,
        					billFeePlanRuleStageId : billFeePlanRuleStageId
        					
        				},
        				success:function(form, action){
        					showSuccessMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('ADJUSTMENT_CANCELLED_SUCCESSFULLY'));
        					grid.getStore().reload(); 
        					instumentdetailGrid.getStore().reload(); 
        					billReceivableGrid.getStore().reload(); 
        					grid.getSelectionModel().deselectAll();
        					instumentdetailGrid.getSelectionModel().deselectAll();
        					billReceivableGrid.getSelectionModel().deselectAll();  
        					$this.updateProgressTracker();        					
        				}
        			});
        			Ext.getBody().unmask();
        		}
        	});
        },
      //****************Disable save and cancel settlements buttons permission***************************
      	disableCancelPivileges: function(from,permissionsMap) {
       	 var associatedAcadLocationIds = new Array();
       	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
       	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
       	 var cancelButton = from.down('#cancelSettlementLink');
        	cancelButton.setVisible(false);
       	 Ext.each(permissionList, function(privilege) {
       		 if (privilege === 'CANCELSETTLEMENTS') {
       			 if(!isNullOrEmpty(cancelButton)){
       				cancelButton.setVisible(true);	 
       			 }
       		 }
       	 });
        },
       //******************Disable for SAVE button Permission ****************************************
    	disableSavePivileges: function(from,permissionsMap) {
          	 var associatedAcadLocationIds = new Array();
          	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
          	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
           var adjustmentform = this.getAdjustmentstructure();	
          	var saveButton=adjustmentform.down('#btnSubmit'); 
          	saveButton.setVisible(false);
          	
          	 Ext.each(permissionList, function(privilege) {
          		 if (privilege === 'SAVE') {
          			 if(!isNullOrEmpty(saveButton)){
          				saveButton.setVisible(true);	
          			 }
          		 } 
          	 });
           },
           
           //******************Disable for Print button Permission ****************************************
           disablePrintPivileges: function(from,permissionsMap) {
             	 var associatedAcadLocationIds = new Array();
             	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
             	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
            //  var adjustmentform = this.getAdjustmentstructure();	
             	var printButton=from.down('#btnPrint'); 
             	printButton.setVisible(false);
             	
             	 Ext.each(permissionList, function(privilege) {
             		 if (privilege === 'PRINT') {
             			 if(!isNullOrEmpty(printButton)){
             				printButton.setVisible(true);	
             			 }
             		 } 
             	 });
              },
              setAddressForThirdParty : function(obj,record){
             	 var form = this.getAdjustmentAddressDetailPanel();
             	 if (form.collapsed) {
             		 form.expand();
             	 }
             	 
             	 var adForm = this.getAdjustmentFilters();
             	 var billNoId = adForm.down("#billNoId");
             	 var receiptNoId = adForm.down("#receiptNoId");
             	 var paymentNoId = adForm.down("#paymentNoId");
             	 
             	 billNoId.reset();
             	 receiptNoId.reset();
             	 paymentNoId.reset();
             	 
             	 billNoId.lastQuery=null;
             	 receiptNoId.lastQuery=null;
             	 paymentNoId.lastQuery=null;
        	  
             	 var settlementOf = adForm.down("#adjustment");
             	 if(settlementOf.value=="RECEIPT"){
             		 receiptNoId.setVisible(true);
             		 receiptNoId.setDisabled(false);
             		 this.loadReceiptStore(receiptNoId.getStore(),"THIRDPARTY",adForm.down("#thirdParty").value);
             	 }else if(settlementOf.value=="BILL"){
             		 billNoId.setVisible(true);
             		 billNoId.setDisabled(false);
             		 this.loadBillStore(billNoId.getStore(),"THIRDPARTY",adForm.down("#thirdParty").value);
             	 }else if(settlementOf.value=="PAYMENT"){
             		 paymentNoId.setVisible(true);
             		 paymentNoId.setDisabled(false);
             		 this.loadPaymentStore(paymentNoId.getStore(),"THIRDPARTY",adForm.down("#thirdParty").value);
             	 }
             	 
             	 var studentId = record[0].get("id");
                  Ext.Ajax.request({
                      method: "GET",
                      type: 'rest',
                      url: SERVERURL.PAYMENT_STUDENT_FO_FLYOUT_INFO,
                      params: {
                          studentId: studentId
                      },
                  success: function(f, action) {
                     var responseData = Ext.JSON.decode(f.responseText);
             	 form.down("#emailId").setValue(record[0].get("emailId"));
             	 form.down("#contactNo").setValue(record[0].get("cellNo"));
             	 form.down("#address").setValue(record[0].get("addressText"));
             	 }
                 });
              },
              //********* Set Address For Sponsor *********
              setAddressForSponsors:function(obj,record){
            	  var form = this.getAdjustmentAddressDetailPanel();
             	 if (form.collapsed) {
             		 form.expand();
             	 }

              	 var adForm = this.getAdjustmentFilters();
             	 var billNoId = adForm.down("#billNoId");
             	 var receiptNoId = adForm.down("#receiptNoId");
             	 var paymentNoId = adForm.down("#paymentNoId");

             	 billNoId.reset();
             	 receiptNoId.reset();
             	 paymentNoId.reset();
             	 
             	 billNoId.lastQuery=null;
             	 receiptNoId.lastQuery=null;
             	 paymentNoId.lastQuery=null;
        	  
             	 var settlementOf = adForm.down("#adjustment");
             	 if(settlementOf.value=="RECEIPT"){
             		 receiptNoId.setVisible(true);
             		 receiptNoId.setDisabled(false);
             		 this.loadReceiptStore(receiptNoId.getStore(),"SPONSOR",adForm.down("#sponsors").value);
             	 }else if(settlementOf.value=="BILL"){
             		 billNoId.setVisible(true);
             		 billNoId.setDisabled(false);
             		 this.loadBillStore(billNoId.getStore(),"SPONSOR",adForm.down("#sponsors").value);
             	 }else if(settlementOf.value=="PAYMENT"){
             		 paymentNoId.setVisible(true);
             		 paymentNoId.setDisabled(false);
             		 this.loadPaymentStore(paymentNoId.getStore(),"SPONSOR",adForm.down("#sponsors").value);
             	 }
             	 
             	 var sponsorId ;
             	 if(record){
             		 sponsorId = record[0].get("id");
             	 }else{
             		 sponsorId = obj;
             	 }

             	 var adjustmentFiltersForm = obj.up('adjustmentfilters');
             	 var instrumentNumberField = adjustmentFiltersForm.down('#instrumentNumberId');
             	 instrumentNumberField.getStore().getProxy().extraParams = {
             		 userType:'SPONSOR',
             		 userId:sponsorId,
             		 receiptId : receiptNoId.value
             	 }
             	 instrumentNumberField.getStore().load();
             	 instrumentNumberField.setDisabled(false);
             	 form.down("#profile_image").setVisible(false);

             	 Ext.Ajax.request({
             		 method: "GET",
             		 type: 'rest',
             		 url: SERVERURL.SPONSOR_FLYOUT,
             		 params: {
                     	 sponsorId: sponsorId
                      },
                  success: function(f, action) {
                  var responseData = Ext.JSON.decode(f.responseText);

                  form.down("#sponsorType").setVisible(true);
                  form.down("#sponsorCode").setVisible(true);
                  form.down("#noOfSponsoredStudents").setVisible(true);
                  
                  form.down("#addmissionId").setVisible(false);
                  form.down("#applicationId").setVisible(false);
                  form.down("#userId").setVisible(false);
                  form.down("#program").setVisible(false);
                  form.down("#batch").setVisible(false);
                  form.down("#section").setVisible(false);
                  form.down("#seatType").setVisible(false);
                  form.down("#period").setVisible(false);
                  form.down("#whetherFaculty").setVisible(false);
                  form.down("#whetherInternal").setVisible(false);
                  form.down("#departmentName").setVisible(false);
                  form.down("#feeheadwisedistributionId").setVisible(false);
                  
                  form.down("#name").setValue(responseData.sponsorName);
                  form.down("#address").setValue(responseData.addressText);
                  form.down("#emailId").setValue(responseData.primaryEmailId);
                  form.down("#contactNo").setValue(responseData.phoneNo);
                  form.down("#sponsorType").setValue(responseData.sponsorType);
                  form.down("#sponsorCode").setValue(responseData.sponsorCode);
                  form.down("#noOfSponsoredStudents").setValue(responseData.noOfSponsoredStudents);
                  form.down("#totalAcadLocAdvanceAmount").setValue(responseData.totalAdvanceFee);
                  form.down("#totalAcadPaymentAmount").setValue(responseData.totalAcadPaymentAmount);
    			  form.down("#totalAcadReceiptAmount").setValue(responseData.totalAcadReceiptAmount);
    			  form.down("#totalBalance").setValue(responseData.totalBalance);
    			  form.down("#totalAcadInvoiceAmount").setValue(responseData.totalAcadInvoiceAmount);
    			  form.down("#totalConvertedOutstanding").setValue(responseData.totalConvertedOutstanding);
   			      form.down("#totalAcadDicountAmount").setValue(responseData.totalDiscountAmount);
          
             	 }
                });
             	 
              },
              //********* Set Address For Applicant *********
              setAddressForApplicant:function(obj,record){
            	  var form = this.getAdjustmentAddressDetailPanel();
            	  if (form.collapsed) {
            		  form.expand();
            	  }
            	  form.down("#profile_image").setVisible(true);
            	  
              	 var adForm = this.getAdjustmentFilters();
             	 var billNoId = adForm.down("#billNoId");
             	 var receiptNoId = adForm.down("#receiptNoId");
             	 var paymentNoId = adForm.down("#paymentNoId");
             	 
             	 billNoId.reset();
             	 receiptNoId.reset();
             	 paymentNoId.reset();
             	 
             	 billNoId.lastQuery=null;
             	 receiptNoId.lastQuery=null;
             	 paymentNoId.lastQuery=null;
        	  
             	 var settlementOf = adForm.down("#adjustment");
             	 if(settlementOf.value=="RECEIPT"){
             		 receiptNoId.setVisible(true);
             		 receiptNoId.setDisabled(false);
             		 this.loadReceiptStore(receiptNoId.getStore(),"APPLICANT",adForm.down("#applicant").value);
             	 }else if(settlementOf.value=="BILL"){
             		 billNoId.setVisible(true);
             		 billNoId.setDisabled(false);
             		 this.loadBillStore(billNoId.getStore(),"APPLICANT",adForm.down("#applicant").value);
             	 }else if(settlementOf.value=="PAYMENT"){
             		 paymentNoId.setVisible(true);
             		 paymentNoId.setDisabled(false);
             		 this.loadPaymentStore(paymentNoId.getStore(),"APPLICANT",adForm.down("#applicant").value);
             	 }
            	  
            	  var applicantId ;
            	  var personId;
            	  if(record){
            		  applicantId = record[0].get("id");
            		  personId = record[0].get("personId");
            	  }else{
            		  applicantId = obj;
            	  }

            	  if(!isNullOrEmpty(personId)){
            		  Ext.Ajax.request({
            			  type: 'rest',
            			  binary: true,
            			  url: SERVERURL.APPLICANT_IMAGE_DOWNLOAD+'?personId='+personId,
            			  method: 'GET',
            			  success : function(response){
            				  if(response.responseBytes.length>0){
            					  var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
            					  var url = window.URL.createObjectURL(blob);
            					  var image = form.down("#profile_image");
//          					  image.setVisible(true);
            					  image.getEl().dom.src=url;
            				  }
            			  }
            		  });
            	  }

            	  Ext.Ajax.request({
            		  method: "GET",
            		  type: 'rest',
            		  url: SERVERURL.APPLICANT_FLYOUT,
            		  params: {
            			  id: applicantId
            		  },
            		  success: function(f, action) {
            			  var responseData = Ext.JSON.decode(f.responseText);

            			  form.down("#program").setVisible(true);
            			  form.down("#batch").setVisible(true);
            			  form.down("#seatType").setVisible(true);
            			  form.down("#applicationId").setVisible(true);

            			  form.down("#sponsorType").setVisible(false);
            			  form.down("#sponsorCode").setVisible(false);
            			  form.down("#noOfSponsoredStudents").setVisible(false);
            			  form.down("#addmissionId").setVisible(false);
            			  form.down("#period").setVisible(false);
            			  form.down("#section").setVisible(false);
            			  form.down("#userId").setVisible(false);
            			  form.down("#whetherFaculty").setVisible(false);
            			  form.down("#whetherInternal").setVisible(false);
            			  form.down("#departmentName").setVisible(false);
            			  form.down("#feeheadwisedistributionId").setVisible(true);

            			  form.down("#name").setValue(responseData.applicantName);
            			  form.down("#fatherName").setValue(responseData.fatherName);
            			  form.down("#address").setValue(responseData.addressText);
            			  form.down("#emailId").setValue(responseData.primaryEmailId);
            			  form.down("#contactNo").setValue(responseData.cellNo);
            			  form.down("#applicationId").setValue(responseData.code);
            			  form.down("#program").setValue(responseData.program);
            			  form.down("#batch").setValue(responseData.batch);
            			  form.down("#seatType").setValue(responseData.seatType);
           			      //form.down("#totalDiscountAmount").setValue(responseData.totalDiscountAmount);
           			      //form.down("#totalAdvanceFee").setValue(responseData.totalAdvanceFee);
           			      form.down("#totalAcadPaymentAmount").setValue(responseData.totalAcadPaymentAmount);
	            	      form.down("#totalAcadReceiptAmount").setValue(responseData.totalAcadReceiptAmount);
	            	      form.down("#totalBalance").setValue(responseData.totalBalance);
	            	      form.down("#totalAcadInvoiceAmount").setValue(responseData.totalAcadInvoiceAmount);
	            	      form.down("#totalConvertedOutstanding").setValue(responseData.totalConvertedOutstanding);
	            	      form.down("#totalAcadDicountAmount").setValue(responseData.totalAcadDicountAmount);
          			      form.down("#totalAcadLocAdvanceAmount").setValue(responseData.totalAcadLocAdvanceAmount);
            		  
            		  }
            	  });
              },
              //********* Set Address For user *********
              setAddressForUser:function(obj,record){
            	  var form = this.getAdjustmentAddressDetailPanel();
             	 if (form.collapsed) {
             		 form.expand();
             	 }
             	 
             	 form.down("#profile_image").setVisible(true);

              	 var adForm = this.getAdjustmentFilters();
             	 var billNoId = adForm.down("#billNoId");
             	 var receiptNoId = adForm.down("#receiptNoId");
             	 var paymentNoId = adForm.down("#paymentNoId");
             	 
             	 billNoId.reset();
             	 receiptNoId.reset();
             	 paymentNoId.reset();
             	 
             	 billNoId.lastQuery=null;
             	 receiptNoId.lastQuery=null;
             	 paymentNoId.lastQuery=null;
        	  
             	 var settlementOf = adForm.down("#adjustment");
             	 if(settlementOf.value=="RECEIPT"){
             		 receiptNoId.setVisible(true);
             		 receiptNoId.setDisabled(false);
             		 this.loadReceiptStore(receiptNoId.getStore(),"USER",adForm.down("#userId").value);
             	 }else if(settlementOf.value=="BILL"){
             		 billNoId.setVisible(true);
             		 billNoId.setDisabled(false);
             		 this.loadBillStore(billNoId.getStore(),"USER",adForm.down("#userId").value);
             	 }else if(settlementOf.value=="PAYMENT"){
             		 paymentNoId.setVisible(true);
             		 paymentNoId.setDisabled(false);
             		 this.loadPaymentStore(paymentNoId.getStore(),"USER",adForm.down("#userId").value);
             	 }
             	 
             	 var userId ;
             	 var personId;
             	 if(record){
             		 userId = record[0].get("id");
             		 personId = record[0].get("personId");
             	 }else{
             		 userId = obj;
             	 }

             	 if(!isNullOrEmpty(userId)){
             		 Ext.Ajax.request({
             			 type: 'rest',
             			 binary: true,
             			 url: SERVERURL.PERSON_IMAGE_DOWNLOAD+'?personId='+userId,
             			 method: 'GET',
             			 success : function(response){
             				 if(response.responseBytes.length>0){
             					 var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
             					 var url = window.URL.createObjectURL(blob);
             					 var image = form.down("#profile_image");
//             					 image.setVisible(true);
             					 image.getEl().dom.src=url;
             				 }
             			 }

             		 });

             		 Ext.Ajax.request({
             			 method: "GET",
             			 type: 'rest',
             			 url: SERVERURL.STAFFF_LYOUT,
             			 params: {
             				 userId:userId

             			 },
             			 success: function(f, action) {
             				 var responseData = Ext.JSON.decode(f.responseText);

             				 form.down("#departmentName").setVisible(true),
             				 form.down("#whetherFaculty").setVisible(true),
             				 form.down("#whetherInternal").setVisible(true),
             				 form.down("#userId").setVisible(true),

             				 form.down("#addmissionId").setVisible(false);
             				 form.down("#applicationId").setVisible(false);
             				 form.down("#program").setVisible(false);
             				 form.down("#batch").setVisible(false);
             				 form.down("#period").setVisible(false);
             				 form.down("#section").setVisible(false);
             				 form.down("#seatType").setVisible(false);
             				 form.down("#sponsorType").setVisible(false);
             				 form.down("#sponsorCode").setVisible(false);
             				 form.down("#noOfSponsoredStudents").setVisible(false);

             				 form.down("#name").setValue(responseData.printName);
             				 form.down("#address").setValue(responseData.addressText);
             				 form.down("#emailId").setValue(responseData.primaryeEmailId);
             				 form.down("#contactNo").setValue(responseData.phoneNo);
             				 form.down("#userId").setValue(responseData.userId);
             				 form.down("#departmentName").setValue(responseData.departmentName);
             				 form.down("#whetherFaculty").setValue(responseData.whetherFaculty);
             				 form.down("#whetherInternal").setValue(responseData.whetherInternal);
             				 form.down("#totalBalance").setValue(responseData.totalBalance);
             				 form.down("#totalAcadInvoiceAmount").setValue(responseData.totalAcadInvoiceAmount);
             				 form.down("#totalConvertedOutstanding").setValue(responseData.totalConvertedOutstanding);
             				 form.down("#totalAcadReceiptAmount").setValue(responseData.totalAcadReceiptAmount); 
             				 form.down("#totalAcadPaymentAmount").setValue(responseData.totalAcadPaymentAmount);
             			 }
             		 });

             	 }	 
              },
              
              //****** set Address For Student*************
              setAddressForStudent : function(obj,record){
            	  var form = this.getAdjustmentAddressDetailPanel();
            	  if (form.collapsed) {
            		  form.expand();
            	  }
            	  form.down("#profile_image").setVisible(true);
            	  
            	  var adForm = this.getAdjustmentFilters();
            	  var billNoId = adForm.down("#billNoId");
            	  var receiptNoId = adForm.down("#receiptNoId");
            	  var paymentNoId = adForm.down("#paymentNoId");
            	  
              	  billNoId.reset();
             	  receiptNoId.reset();
             	  paymentNoId.reset();
             	 
             	  billNoId.lastQuery=null;
             	  receiptNoId.lastQuery=null;
             	  paymentNoId.lastQuery=null;
            	  
            	  var settlementOf = adForm.down("#adjustment");
            	  if(settlementOf.value=="RECEIPT"){
            		  receiptNoId.setVisible(true);
            		  receiptNoId.setDisabled(false);
            		  this.loadReceiptStore(receiptNoId.getStore(),"STUDENT",adForm.down("#student").value);
                  }else if(settlementOf.value=="BILL"){
                	  billNoId.setVisible(true);
                	  billNoId.setDisabled(false);
                	  this.loadBillStore(billNoId.getStore(),"STUDENT",adForm.down("#student").value);
                  }else if(settlementOf.value=="PAYMENT"){
                	  paymentNoId.setVisible(true);
                	  paymentNoId.setDisabled(false);
                	  this.loadPaymentStore(paymentNoId.getStore(),"STUDENT",adForm.down("#student").value);
                  }
            	  

            	  var studentId ;
            	  var personId;
            	  if(record){
            		  studentId = record[0].get("id");
            		  personId = record[0].get("personId");
            	  }else{
            		  studentId = obj;
            	  }

            	  if(!isNullOrEmpty(personId)){
            		  Ext.Ajax.request({
            			  type: 'rest',
            			  binary: true,
            			  url: SERVERURL.PERSON_IMAGE_DOWNLOAD+'?personId='+personId,
            			  method: 'GET',
            			  success : function(response){
            				  var image = form.down("#profile_image");
            				  if(response.responseBytes.length>0){
            					  var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
            					  var url = window.URL.createObjectURL(blob);
            					  image.getEl().dom.src=url;
            				  }
            			  }

            		  });
            	  }
            	  Ext.Ajax.request({
            		  method: "GET",
            		  type: 'rest',
            		  url: SERVERURL.PAYMENT_STUDENT_FO_FLYOUT_INFO,
            		  params: {
            			  studentId: studentId
            		  },
            		  success: function(f, action) {
            			  var responseData = Ext.JSON.decode(f.responseText);

            			  form.down("#departmentName").setVisible(false),
            			  form.down("#whetherFaculty").setVisible(false),
            			  form.down("#whetherInternal").setVisible(false),
            			  form.down("#sponsorType").setVisible(false);
            			  form.down("#sponsorCode").setVisible(false);
            			  form.down("#noOfSponsoredStudents").setVisible(false);

            			  form.down("#addmissionId").setVisible(true);
            			  form.down("#applicationId").setVisible(true);
            			  form.down("#program").setVisible(true);
            			  form.down("#batch").setVisible(true);
            			  form.down("#period").setVisible(true);
            			  form.down("#section").setVisible(true);
            			  form.down("#seatType").setVisible(true);
            			  form.down("#userId").setVisible(true);
            			  form.down("#feeheadwisedistributionId").setVisible(true);
            			  
            			  form.down("#name").setValue(responseData.studentName);
            			  form.down("#fatherName").setValue(responseData.fatherName);
            			  form.down("#address").setValue(responseData.addressText);
            			  form.down("#emailId").setValue(responseData.primaryeEmailId);
            			  form.down("#contactNo").setValue(responseData.cellNo);
            			  form.down("#addmissionId").setValue(responseData.admissionID);
            			  form.down("#applicationId").setValue(responseData.applicationID);
            			  form.down("#userId").setValue(responseData.id);
            			  form.down("#program").setValue(responseData.programName);
            			  form.down("#batch").setValue(responseData.batch);
            			  form.down("#studentCode").setValue(responseData.studentCode);
            			  
            			  var alinfomodel = Academia.model.authentication.ALInfoModel;
            			  var wheatherSchool = alinfomodel.get('wheatherSchool');
            			  if(wheatherSchool){
            			     form.down("#period").setVisible(false);
            			  }else{
            			     form.down("#period").setVisible(true);
            			     form.down("#period").setValue(responseData.period);   
            			  }
            			  
            			  form.down("#section").setValue(responseData.sectionCode);
            			  form.down("#seatType").setValue(responseData.seatType);
//            			  form.down("#totalBillAmount").setValue(responseData.totalBillAmount);
//            			  form.down("#totalReceiptAmount").setValue(responseData.totalReceiptAmount);
//            			  form.down("#totalPaymentAmount").setValue(responseData.totalPaymentAmount);
//            			  form.down("#totalOutStanding").setValue(responseData.totalOutStanding);
            			  form.down("#totalBalance").setValue(responseData.totalBalance);	
            			  form.down("#totalAcadLocAdvanceAmount").setValue(responseData.totalAcadLocAdvanceAmount);
            			  form.down("#person").setValue(responseData.personId);
           			      form.down("#totalAcadDicountAmount").setValue(responseData.totalAcadDicountAmount);
	        			  form.down("#totalAcadPaymentAmount").setValue(responseData.totalAcadPaymentAmount);
	            	      form.down("#totalAcadReceiptAmount").setValue(responseData.totalAcadReceiptAmount);
	            	      form.down("#totalAcadInvoiceAmount").setValue(responseData.totalAcadInvoiceAmount);
	            	      form.down("#totalConvertedOutstanding").setValue(responseData.totalConvertedOutstanding);
	            	      
            		  }
            	  });
              },
              receiptNextTab : function(){
            	  var $this=this;
            	  var structure = this.getAdjustmentstructure();
            	  var tabstructure = structure.down("#adjustmenttabstructure");
            	  var grid = this.getReceiptslist();
            	  var istrmntGrid = this.getInstumentdetailslist();
            	  var billrcvblGrid = this.getBillreceivablelist();
            	  var billreceivable = this.getBillreceivablelist();
            	  var allBillsList = this.getAllbillslist();
            	  var structure = this.getAdjustmentstructure();
            	  var form = structure.down('adjustmentfilters');
            	  var settleWithCheckBox = form.down('#settleWithCheckBoxId');
            	  var isSettleWithChecked = settleWithCheckBox.getValue();
            	  var manageSettlementCurrency =  form.down("#manageSettlementCurrency");
					if(manageSettlementCurrency.getValue().currencyType == true){
						var columns = allBillsList.columns;
						for(var i in columns) {
							if (columns[i].dataIndex == "currencyExchangeRate" || columns[i].dataIndex == "convertedBalanceAmount") {
								columns[i].hide();
							}
						}  
					}else{
						var columns = allBillsList.columns;
						for(var i in columns) {
							if (columns[i].dataIndex == "currencyExchangeRate" || columns[i].dataIndex == "convertedBalanceAmount") {
								columns[i].show();
							}
						}    
					}

            	  if (grid.getSelectionModel().getCount() > 0) {
            		  var records = grid.getSelectionModel().getSelection()[0];
            		  this.getCheckedReceiptListing(grid,records);
            		if(!isSettleWithChecked){
            		  if(records.get('voucherMode')=='BANK'){
            			  tabstructure.down("#instumentdetailscontainer").setDisabled(false);
            			  tabstructure.setActiveTab(tabstructure.down("#instumentdetailscontainer"));
            			  tabstructure.down("#receipt_no").setValue(records.get('receiptNo'));
            			  
            			  if(manageSettlementCurrency.getValue().currencyType == false)
            			  {
                    			  if(!isNullOrEmpty(records.get('balanceAmountInALBaseCurrency')) && records.get('baseCurrencyCode'))
                    			  {
                    				  var baseCurrencyCode = records.get('baseCurrencyCode') || '';
                    				  var balanceAmountInALBaseCurrency = parseFloat(records.get('balanceAmountInALBaseCurrency')) || 0;
                					  var roundedBalanceAmount = Ext.util.Format.round(balanceAmountInALBaseCurrency, 2).toFixed(2);
                					  tabstructure.down("#recipt_amount").setValue(baseCurrencyCode + " " + roundedBalanceAmount);
                    			  }
            			  
            			  }else
            			  {
            				  var totalAmount = parseFloat(records.get('amount')) || 0;
            				  var roundedValue = Ext.util.Format.round(totalAmount, 2).toFixed(2);
            				  tabstructure.down("#recipt_amount").setValue(roundedValue);
            			  }
            			  
            			  this.setProgressTracker(1);
            		  }else{
            			  tabstructure.down("#allbilllistcontainer").setDisabled(false);
            			  tabstructure.setActiveTab(tabstructure.down("#allbilllistcontainer"));
            			  tabstructure.down('#nextBtnAllBillBtn').setDisabled(true);
            			  tabstructure.down("#receipt_bill_no_ab").setValue(records.get('receiptNo'));
            			  tabstructure.down("#receipt_bill_amount_ab").setValue(records.get('totalBalanceAmount'));
            			  tabstructure.down("#instrument_no_ab").setVisible(false);
            			  tabstructure.down("#instrument_amount_ab").setVisible(false);
            			  
            			  if(manageSettlementCurrency.getValue().currencyType == false)
            			  {
                				  if(!isNullOrEmpty(records.get('balanceAmountInALBaseCurrency')) && records.get('baseCurrencyCode'))
                				  {
                					  var baseCurrencyCode = records.get('baseCurrencyCode') || '';
                					  var acadLocCurrConvertedAmount = parseFloat(records.get('acadLocCurrConvertedAmount')) || 0;
                					  var balanceAmountInALBaseCurrency = parseFloat(records.get('balanceAmountInALBaseCurrency')) || 0;
                					  var roundedAcadAmount = Ext.util.Format.round(acadLocCurrConvertedAmount, 2).toFixed(2);
                					  var roundedBalanceAmount = Ext.util.Format.round(balanceAmountInALBaseCurrency, 2).toFixed(2);
                					  tabstructure.down("#receipt_bill_amount_ab").setValue(baseCurrencyCode + " " + roundedAcadAmount);
                					  tabstructure.down("#recipt_bill_balance_amount_ab").setValue(baseCurrencyCode + " " + roundedBalanceAmount);
                				  }
            			  }else
            			  {
            				  var totalBalanceAmount = parseFloat(records.get('totalBalanceAmount')) || 0;
            				  var roundedValue = Ext.util.Format.round(totalBalanceAmount, 2).toFixed(2);

            				  tabstructure.down("#receipt_bill_amount_ab").setValue(roundedValue);
            				  tabstructure.down("#recipt_bill_balance_amount_ab").setValue(roundedValue);
            			  }
            			  
            			  var form = structure.down('adjustmentfilters');
            			  var thirdParty =  form.down("#thirdParty");
            			  var sponsors =  form.down("#sponsors");
            			  var applicant =  form.down("#applicant");
            			  var userId =  form.down("#userId");
            			  var student =  form.down("#student");

            			  var id=0;
            			  var billedUserType=null;
            			  if(!thirdParty.isHidden()){
            				  id = thirdParty.getValue();
            				  billedUserType ="THIRD PARTY";

            			  }else if(!sponsors.isHidden()){
            				  id = sponsors.getValue();
            				  billedUserType ="SPONSOR";

            			  }else if(!applicant.isHidden()){
            				  id = applicant.getValue();
            				  billedUserType ="APPLICANT";

            			  }else if(!userId.isHidden()){
            				  id = userId.getValue();
            				  billedUserType ="USER";  

            			  }else if(!student.isHidden()){
            				  id = student.getValue();
            				  billedUserType ="STUDENT";
            			  }

            			  var value = form.down("#adjustmentFor").getValue();
            			  var showAllSettlement = form.down("#showAllSettlementId").getValue();
            			  var adjustment = form.down("#adjustment").getValue();
            			  var adjustmentType;

            			  switch(showAllSettlement){
            			  case 'ALL' :{
            				  showAllSettlement = 'All'
            					  break;
            			  }
            			  case 'FULLY_SETTELED' :{
            				  showAllSettlement = 'settled'
            					  break;
            			  }
            			  case 'NOT_FULLY_SETTELED' :{
            				  showAllSettlement = 'Pending'
            					  break;
            			  }
            			  }

            			  if(adjustment=='RECEIPT'){
            				  adjustmentType = 'Bill Receivable';		
            			  }
            			  else if(adjustment=='PAYMENT'){
            				  adjustmentType = 'Bill Payable';
            			  }
            			  else if(adjustment=='BILL'){
            				  adjustmentType = 'Bill Payable';
            			  }

      					if(!sponsors.isHidden()){
  	                	   Ext.Ajax.request({
 	                		   method: "GET",
 	                		   type: 'rest',
 	                		   url: SERVERURL.SPONSORSHIP_URL,
 	                		   params: {
 	                			   id: id
 	                		   },
 	                		   success: function(f, action) {
 	                			   var responseData = Ext.JSON.decode(f.responseText);
 	                			   var sponsorsIsSuspenseAccount = responseData.isSuspenseAccount;
 	                			   if(!sponsors.isHidden()&& sponsorsIsSuspenseAccount == true && !isNullOrEmpty(sponsorsIsSuspenseAccount)){
 	                				   allBillsList.getStore().removeAll();
 	                				   tabstructure.down('#studentNameId').show();
 	                				  tabstructure.down('#studentSearchBtn').show();
 	                			   }else{
 	                				  tabstructure.down('#studentNameId').hide();
 	                				 tabstructure.down('#fnpMultiBrandCampusAdjustmentItemId').show();
 	                			   }
 	                		   }
 	                	   });
     					}
      					
        					if(billedUserType=='STUDENT' || billedUserType=='APPLICANT' || billedUserType=='USER' || billedUserType=='THIRD PARTY')
        					{
        						tabstructure.down('#fnpMultiBrandCampusAdjustmentItemId').hide();
        					}
        					  var manageSettlementCurrency =  form.down("#manageSettlementCurrency");
        					 if(manageSettlementCurrency.getValue().currencyType == true){
               				  var columns = allBillsList.columns;
                       		   for(var i in columns) {
                       			   if (columns[i].dataIndex == "currencyExchangeRate" || columns[i].dataIndex == "convertedBalanceAmount") {
                       				   columns[i].hide();
                       			   }
                       		   }  
               			  }else{
               				  var columns = allBillsList.columns;
                       		   for(var i in columns) {
                       			   if (columns[i].dataIndex == "currencyExchangeRate" || columns[i].dataIndex == "convertedBalanceAmount") {
                       				   columns[i].show();
                       			   }
                       		   }    
               			  }
        					

        						allBillsList.getStore().getProxy().extraParams = {
        							billedUserType: billedUserType,
        							id:id,
        							adjustmentType:adjustmentType,
        							showAllSettlement:showAllSettlement,
        							limit:1000,
        							currencyId: records.get('currencyId'),
        							fetchBillOfOtherCurrency:manageSettlementCurrency.getValue().currencyType
        						};
        						allBillsList.getStore().reload();

        		
            			  $this.setProgressTracker(1);
            			  $this.setProgressTracker(2);
            		  }
            		}else{
            			tabstructure.down("#allbilllistcontainer").setDisabled(true);
            			tabstructure.down("#billreceivablecontainer").setDisabled(true);
            			tabstructure.down("#instumentdetailscontainer").setDisabled(true);
            			tabstructure.down("#paymentReceiptSetttlementcontainer").setDisabled(false);
            			tabstructure.setActiveTab(tabstructure.down("#paymentReceiptSetttlementcontainer"));
            			tabstructure.down('#receiptsListForPaymentSettlement').setVisible(false);
            			tabstructure.down('#paymentsListForReceiptSettlement').setVisible(true);
            			
            			tabstructure.down('#paymentNumId').setVisible(false);
            			tabstructure.down('#paymentAmountId').setVisible(false);
            			tabstructure.down('#receiptNumId').setVisible(true);
            			tabstructure.down('#receiptAmountId').setVisible(true);

            			tabstructure.down("#receiptNumId").setValue(records.get('receiptNo'));
            			if(manageSettlementCurrency.getValue().currencyType == false){
            				/*if(!isNullOrEmpty(records.get('balanceAmountInALBaseCurrency')) && records.get('baseCurrencyCode')){
            					tabstructure.down("#receiptAmountId").setValue(records.get('baseCurrencyCode')+" "+records.get('balanceAmountInALBaseCurrency'));
            				}*/
            			}else{
            				var totalAmount = parseFloat(records.get('amount')) || 0;
            				var totalReceiptBalanceAmount = parseFloat(records.get('totalBalanceAmount')) || 0;
            				var totalAmountRoundedValue = Ext.util.Format.round(totalAmount, 2).toFixed(2);
            				var totalBalanceAmountRoundedValue = Ext.util.Format.round(totalReceiptBalanceAmount, 2).toFixed(2);
            				tabstructure.down("#receiptAmountId").setValue(totalAmountRoundedValue);
            				tabstructure.down("#receiptPaymentBalanceAmountId").setValue(totalBalanceAmountRoundedValue);
            			}

            			$this.setProgressTracker(1);
            			$this.setProgressTracker(2);
            			$this.setProgressTracker(3);
           			    $this.setProgressTracker(4);
           			    $this.loadPaymentGridForReceiptSettlement();
            		} 
            	  }else{
            		  showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
            	  }
            	  manageSettlementCurrency.setReadOnly(true);
              },

              getAmountToSettle :  function()
              {
            	  var $this=this;
            	  var structure = this.getAdjustmentstructure();
            	  var tabstructure = structure.down("#adjustmenttabstructure");
            	  //var grid = this.getReceiptslist();
            	  var tabstructure = this.getAdjustmentstructure().down('adjustmenttabstructure');
            	  var receiptslist =this.getReceiptslist();
            	  var paymentListGrid = this.getPaymentslist();
            	  var billListGrid = this.getBilllist();
            	  var istrmntGrid = this.getInstumentdetailslist();
            	  var billrcvblGrid = this.getBillreceivablelist();
            	  var form = structure.down('adjustmentfilters');
            	  var manageSettlementCurrency =  form.down("#manageSettlementCurrency");
            	  if(receiptslist.getSelectionModel().getSelection()[0] != undefined)
            	  {
            		  var records = receiptslist.getSelectionModel().getSelection()[0];
            	  }
            	  else if(paymentListGrid.getSelectionModel().getSelection()[0] != undefined)
            	  {
            		  var records = paymentListGrid.getSelectionModel().getSelection()[0];
            	  }
            	  else if(istrmntGrid.getSelectionModel().getSelection()[0] != undefined)
            	  {
            		  var records = istrmntGrid.getSelectionModel().getSelection()[0];
            	  }
            	  else if(billrcvblGrid.getSelectionModel().getSelection()[0] != undefined)
            	  {
            		  var records = billrcvblGrid.getSelectionModel().getSelection()[0];
            	  }
            	  else if(billListGrid.getSelectionModel().getSelection()[0] != undefined)
            	  {
            		  var records = billListGrid.getSelectionModel().getSelection()[0];
            	  }
            	  var totalInstrumentBalanceAmountInALBaseCurrency=records.get('convertedBalanceAmount');
            	  //var records = receiptslist.getSelectionModel().getSelection()[0];
            	  var totalRecieptBalanceAmount=records.get('totalBalanceAmount');
            	  var balance=tabstructure.down('#recipt_bill_balance_amount');
            	  var totalBalanceAmount=balance.getValue();
            	  var receiptslistgrid = $this.getBillreceivablelist();
            	  receiptslistgrid.getView().refresh()
            	  var models=null;
            	  var models = receiptslistgrid.getStore().getRange();

            	  var totalCount=0;
            	  var validTotalCount=0;
            	  var amountToBeAdjustedCount=0;
            	  var adjustmentMode =  form.down("#adjustment").getValue();
            	  if(receiptslistgrid.getStore().data.length > 0)
            	  {
            		  for(var i=0;i< receiptslistgrid.getStore().data.length;i++)
            		  {
            			  var totalbalance= receiptslistgrid.getStore().getAt(i).get('totalBalanceAmount');
            			  if(manageSettlementCurrency.getValue().currencyType == true){
            				
            			  var amountToBeAdjusted= receiptslistgrid.getStore().getAt(i).get('amountToBeAdjusted');
            			  var totalCountValidation=totalCount+totalbalance;
            			  if(totalbalance != 0){
            				  if(totalCountValidation < totalRecieptBalanceAmount &&  totalCountValidation  < totalRecieptBalanceAmount )
            				  {
            					  models[i].set('amountToBeAdjusted', totalbalance);
            					  models[i].set('totalBalanceAmount', 0);
            					  totalCount=totalCount+totalbalance;
            					  amountToBeAdjustedCount=amountToBeAdjustedCount+amountToBeAdjusted;
            					  validTotalCount=1;
            				  }else if(totalCount == totalRecieptBalanceAmount){
            				  }else
            				  {
            					  var remainingAmmout=totalRecieptBalanceAmount-totalCount;
            					  // models[i].set('amountToBeAdjusted',);
            					  var remainingsettled= totalRecieptBalanceAmount - totalCount;
            					  var amounttosettled=totalbalance - remainingsettled;
            					  models[i].set('amountToBeAdjusted', remainingAmmout);
            					  models[i].set('totalBalanceAmount', amounttosettled);
            					  amountToBeAdjustedCount=amountToBeAdjustedCount+amountToBeAdjusted;

            					  validTotalCount=2;
            					  tabstructure.down("#recipt_bill_balance_amount").setValue(0);   //hardCoded
            					  break;
            				  }
            			  }
            			  }else{
            				  if(adjustmentMode == "BILL"){
                    			  var amountToBeAdjusted= receiptslistgrid.getStore().getAt(i).get('amountToBeAdjusted');
                    			  var totalCountValidation=totalCount+totalbalance;
                    			  if(totalbalance != 0){ 
                    				// No calculation for Bill
                    			  }
            				  }else{
            					  var baseCurrencyCovertedbalanceAmount= receiptslistgrid.getStore().getAt(i).get('baseCurrencyCovertedbalanceAmount');
            					  var baseCurrencyCovertedAdjustedAmount= receiptslistgrid.getStore().getAt(i).get('baseCurrencyCovertedAdjustedAmount');
            					  var exchangeRate = receiptslistgrid.getStore().getAt(i).get('exchangeRate');
            					  var convertedBalanceAmount=baseCurrencyCovertedbalanceAmount*exchangeRate;
            					  var totalCountValidation=totalCount+baseCurrencyCovertedbalanceAmount;
            					  if(records.get('voucherMode')=='BANK'){
            						  if(totalbalance != 0){
            							  if(totalCountValidation < totalInstrumentBalanceAmountInALBaseCurrency &&  totalCountValidation  < totalInstrumentBalanceAmountInALBaseCurrency )
            							  {
            								  models[i].set('convertedBalanceAmount',convertedBalanceAmount);
            								  validTotalCount=1;
            							  }else if(totalCount == totalRecieptBalanceAmount){
            							  }else
            							  {
            								  var remainingAmmout=totalInstrumentBalanceAmountInALBaseCurrency-totalCount;
            								  var remainingsettled=totalInstrumentBalanceAmountInALBaseCurrency-totalCount;
            								  var amounttosettled=baseCurrencyCovertedbalanceAmount - remainingsettled;
            								  models[i].set('amountToBeAdjusted', remainingAmmout);
            								  models[i].set('totalBalanceAmount', amounttosettled);
            								  amountToBeAdjustedCount=amountToBeAdjustedCount+amountToBeAdjusted;
            								  validTotalCount=2;
            								  tabstructure.down("#recipt_bill_balance_amount").setValue(0);   //hardCoded
            								  break;
            							  }
            						  }
            					  }else
            					  {

            		  }
            				  }
            			  }
            		  }
            		  var recipt_bill_balance_amount_value=  tabstructure.down("#recipt_bill_balance_amount").getValue(records.get('totalBalanceAmount'));
            		  var totalRemaining=recipt_bill_balance_amount_value-totalCount;
            		  if(validTotalCount==1)
            		  tabstructure.down("#recipt_bill_balance_amount").setValue((recipt_bill_balance_amount_value - totalCount).toFixed(2));

            	  }
              },

              paymentNextTab : function(){
            	  var $this=this;
            	  var structure = this.getAdjustmentstructure();
            	  var tabstructure = structure.down("#adjustmenttabstructure");
            	  var grid = this.getPaymentslist();
            	  var istrmntGrid = this.getInstumentdetailslist();
            	  var billrcvblGrid = this.getBillreceivablelist();
            	  var allBillsList = this.getAllbillslist();
            	  var paymentgrid = this.getPaymentslist();
            	  var form = structure.down('adjustmentfilters');
            	  var settleWithCheckBox = form.down('#settleWithCheckBoxId');
            	  var isSettleWithChecked = settleWithCheckBox.getValue();
        		  var manageSettlementCurrency =  form.down("#manageSettlementCurrency").getValue();
        		  billrcvblGrid.getView().refresh();
					if(manageSettlementCurrency.currencyType == true){
						var columns = billrcvblGrid.columns;
						for(var i in columns) {
							if (columns[i].dataIndex == "currencyExchangeRate" || columns[i].dataIndex == "convertedBalanceAmount") {
								columns[i].hide();
							}
						}  
					}else{
						var columns = billrcvblGrid.columns;
						for(var i in columns) {
							if (columns[i].dataIndex == "currencyExchangeRate" || columns[i].dataIndex == "convertedBalanceAmount") {
								columns[i].show();
							}
						}    
					}
            	  if (grid.getSelectionModel().getCount() > 0) {
            		  var records = grid.getSelectionModel().getSelection()[0];
            		  var paymentrecords = paymentgrid.getSelectionModel().getSelection()[0];
            		  this.getCheckedPaymentListing(grid,records);
            		if(!isSettleWithChecked){
            		  if(records.get('voucherMode')=='BANK'){
            			  tabstructure.down("#instumentdetailscontainer").setDisabled(false);
            			  tabstructure.setActiveTab(tabstructure.down("#instumentdetailscontainer"));
            			  tabstructure.down("#receipt_no").setFieldLabel('Payment No');
            			  tabstructure.down("#receipt_no").setValue(records.get('paymentVoucherNo'));
            			  tabstructure.down("#recipt_amount").setFieldLabel('Payment Amount');
            			   if(manageSettlementCurrency.currencyType == false)
            			  {
            			  if(records.get('baseCurrencyCode')!=null && records.get('convertedAmount'))
            			  {
            				  tabstructure.down("#recipt_amount").setValue(records.get('baseCurrencyCode')+" "+records.get('convertedAmount'));
            			  }
            			  }else
            			  {
            			  tabstructure.down("#recipt_amount").setValue(records.get('amount'));
            			  }
            			  this.setProgressTracker(1);
            		  }else{
            			  tabstructure.down("#billreceivablecontainer").setDisabled(false);
            			  tabstructure.setActiveTab(tabstructure.down("#billreceivablecontainer"));
            			  tabstructure.down("#receipt_bill_no").setFieldLabel(getFeeAndPaymentCommonTranslation('PAYMENT_NO'));
            			  tabstructure.down("#receipt_bill_no").setValue(records.get('paymentVoucherNo'));
            			  tabstructure.down("#receipt_bill_amount").setFieldLabel(getFeeAndPaymentCommonTranslation('PAYMENT_AMOUNT'));
            			  if(manageSettlementCurrency.currencyType == false)
            			  {
            			  if(!isNullOrEmpty(records.get('baseCurrencyCode')) && !isNullOrEmpty(records.get('convertedAmount')))
            			  {
            				  tabstructure.down("#receipt_bill_amount").setValue(records.get('baseCurrencyCode')+" "+records.get('convertedAmount'));
            			  }
            			  }else
            			  {
            				  tabstructure.down("#receipt_bill_amount").setValue(records.get('amount'));
            			  }
            			  tabstructure.down("#instrument_no").setVisible(false);
            			  tabstructure.down("#instrument_amount").setVisible(false);
            			  if(manageSettlementCurrency.currencyType == false)
            	             {
            				  if(records.get('totalInstrumentBalanceAmountInALBaseCurrency')!=null && paymentrecords.get('baseCurrencyCode')!=null)
            					  if(records.get('balanceAmountInALBaseCurrency')){
            						  tabstructure.down("#recipt_bill_balance_amount").setValue(paymentrecords.get('baseCurrencyCode')+" "+records.get('balanceAmountInALBaseCurrency').toFixed(2));
            					  }
            	             }else
            	             {
            	            	 if(records.get('totalBalanceAmount')){
            	            		 tabstructure.down("#recipt_bill_balance_amount").setValue(records.get('totalBalanceAmount').toFixed(2));
            	            	 }
            	             }
            			  var billreceivable = this.getBillreceivablelist();
            			  var form = structure.down('adjustmentfilters');
            			  var thirdParty =  form.down("#thirdParty");
            			  var sponsors =  form.down("#sponsors");
            			  var applicant =  form.down("#applicant");
            			  var userId =  form.down("#userId");
            			  var student =  form.down("#student");

            			  var id=0;
            			  var billedUserType=null;
            			  if(!thirdParty.isHidden()){
            				  id = thirdParty.getValue();
            				  billedUserType ="THIRD PARTY";

            			  }else if(!sponsors.isHidden()){
            				  id = sponsors.getValue();
            				  billedUserType ="SPONSOR";

            			  }else if(!applicant.isHidden()){
            				  id = applicant.getValue();
            				  billedUserType ="APPLICANT";

            			  }else if(!userId.isHidden()){
            				  id = userId.getValue();
            				  billedUserType ="USER";  

            			  }else if(!student.isHidden()){
            				  id = student.getValue();
            				  billedUserType ="STUDENT";
            			  }

            			  var value = form.down("#adjustmentFor").getValue();
            			  var showAllSettlement = form.down("#showAllSettlementId").getValue();
            			  var adjustment = form.down("#adjustment").getValue();
            			  var adjustmentType;

            			  switch(showAllSettlement){
            			  case 'ALL' :{
            				  showAllSettlement = 'All'
            					  break;
            			  }
            			  case 'FULLY_SETTELED' :{
            				  showAllSettlement = 'settled'
            					  break;
            			  }
            			  case 'NOT_FULLY_SETTELED' :{
            				  showAllSettlement = 'Pending'
            					  break;
            			  }
            			  }

            			  if(adjustment=='RECEIPT'){
            				  adjustmentType = 'Bill Receivable';		
            			  }
            			  else if(adjustment=='PAYMENT'){
            				  adjustmentType = 'Bill Payable';
            			  }
            			  else if(adjustment=='BILL'){
            				  adjustmentType = 'Bill Payable';
            			  }

            			  billreceivable.getStore().getProxy().extraParams = {
            				  billedUserType: billedUserType,
            				  id:id,
            				  adjustmentType:adjustmentType,
            				  showAllSettlement:showAllSettlement,
            				  whetherCreatedCurrency:manageSettlementCurrency.currencyType,
            				  limit:1000
            			  };
            			  billreceivable.getStore().load({
            				  callback: function(records, operation, success) {
            					  if (success) {
            						  $this.getAmountToSettle();
            						  $this.setProgressTracker(1);
            						  $this.setProgressTracker(2);
            					  }

            				  }	   
            			  });
            		  }
            		}else{
            			tabstructure.down("#allbilllistcontainer").setDisabled(true);
            			tabstructure.down("#billreceivablecontainer").setDisabled(true);
            			tabstructure.down("#instumentdetailscontainer").setDisabled(true);
            			tabstructure.down("#paymentReceiptSetttlementcontainer").setDisabled(false);
            			tabstructure.setActiveTab(tabstructure.down("#paymentReceiptSetttlementcontainer"));
            			tabstructure.down('#receiptsListForPaymentSettlement').setVisible(true);
            			tabstructure.down('#paymentsListForReceiptSettlement').setVisible(false);
            			
            			tabstructure.down('#paymentNumId').setVisible(true);
            			tabstructure.down('#paymentAmountId').setVisible(true);
            			tabstructure.down('#receiptNumId').setVisible(false);
            			tabstructure.down('#receiptAmountId').setVisible(false);
            			
            			$this.setProgressTracker(1);
           			    $this.setProgressTracker(2);
           			    $this.setProgressTracker(3);
            		} 
            	  }else{
            		  showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
            	  }
            	  var manageSettlementCurrencyReadOnly =  form.down("#manageSettlementCurrency");
            	  manageSettlementCurrencyReadOnly.setReadOnly(true);
              },
              billNextTab : function(){
            	  var $this=this;
            	  var structure = this.getAdjustmentstructure();
            	  var tabstructure = structure.down("#adjustmenttabstructure");
            	  var grid = this.getBilllist();
            	  var billrcvblGrid = this.getBillreceivablelist();
            	  var allBillsList = this.getAllbillslist();
            	  var form = structure.down('adjustmentfilters');
            	  var manageSettlementCurrency =  form.down("#manageSettlementCurrency");
            	  
            	  
            	  if (grid.getSelectionModel().getCount() > 0) {
            		  var records = grid.getSelectionModel().getSelection()[0];
            		  this.getCheckedBillListing(grid,records);
            		  tabstructure.down("#billreceivablecontainer").setDisabled(false);
            		  tabstructure.setActiveTab(tabstructure.down("#billreceivablecontainer"));
            		  tabstructure.down("#receipt_bill_no").setFieldLabel(getFeeAndPaymentCommonTranslation('BILL_NO'));
            		  tabstructure.down("#receipt_bill_no").setValue(records.get('billNo'));
            		  tabstructure.down("#receipt_bill_amount").setFieldLabel(getFeeAndPaymentCommonTranslation('BILL_AMOUNT'));
            		  tabstructure.down("#receipt_bill_amount").setValue(records.get('totalAmount'));
            		  tabstructure.down("#instrument_no").setVisible(false);
            		  tabstructure.down("#instrument_amount").setVisible(false);
            		  if(records.get('totalBalanceAmount')){
            			  tabstructure.down("#recipt_bill_balance_amount").setValue(records.get('totalBalanceAmount').toFixed(2));
            		  }
            		  var billreceivable = null;
            		   billreceivable = this.getBillreceivablelist();
            		  var form = structure.down('adjustmentfilters');
            		  var thirdParty =  form.down("#thirdParty");
            		  var sponsors =  form.down("#sponsors");
            		  var applicant =  form.down("#applicant");
            		  var userId =  form.down("#userId");
            		  var student =  form.down("#student");
            		  var adjustmentMode =  form.down("#adjustment").getValue();
            		  
            		  
            		  if(manageSettlementCurrency.getValue().currencyType == false)
        			  {
            			  if(adjustmentMode == "BILL"){
            				  if(!isNullOrEmpty(records.get('baseCurrencyCovertedbalanceAmount')) && records.get('baseCurrencyName'))
                			  {
                				  tabstructure.down("#receipt_bill_amount").setValue(records.get('baseCurrencyName')+" "+records.get('baseCurrencyCovertedTotalAmount'));
                				  tabstructure.down("#recipt_bill_balance_amount").setValue(records.get('baseCurrencyName')+" "+records.get('baseCurrencyCovertedbalanceAmount').toFixed(2));
                			  }
                		  }else{
                			  if(!isNullOrEmpty(records.get('baseCurrencyCovertedbalanceAmount')) && records.get('baseCurrencyName'))
                			  {
                				  tabstructure.down("#receipt_bill_amount").setValue(records.get('baseCurrencyName')+" "+records.get('baseCurrencyCovertedbalanceAmount').toFixed(2));
                			  }
                		  }
        			  
        			  }else
        			  {
        				  tabstructure.down("#receipt_bill_amount").setValue(records.get('totalAmount'));
        			  }

            		  var id=0;
            		  var billedUserType=null;
            		  if(!thirdParty.isHidden()){
            			  id = thirdParty.getValue();
            			  billedUserType ="THIRD PARTY";

            		  }else if(!sponsors.isHidden()){
            			  id = sponsors.getValue();
            			  billedUserType ="SPONSOR";

            		  }else if(!applicant.isHidden()){
            			  id = applicant.getValue();
            			  billedUserType ="APPLICANT";

            		  }else if(!userId.isHidden()){
            			  id = userId.getValue();
            			  billedUserType ="USER";  

            		  }else if(!student.isHidden()){
            			  id = student.getValue();
            			  billedUserType ="STUDENT";
            		  }

            		  var value = form.down("#adjustmentFor").getValue();
            		  var showAllSettlement = form.down("#showAllSettlementId").getValue();
            		  var adjustment = form.down("#adjustment").getValue();
            		  var adjustmentType;

            		  switch(showAllSettlement){
            		  case 'ALL' :{
            			  showAllSettlement = 'All'
            				  break;
            		  }
            		  case 'FULLY_SETTELED' :{
            			  showAllSettlement = 'settled'
            				  break;
            		  }
            		  case 'NOT_FULLY_SETTELED' :{
            			  showAllSettlement = 'Pending'
            				  break;
            		  }
            		  }

            		  if(adjustment=='RECEIPT'){
            			  adjustmentType = 'Bill Receivable';		
            		  }
            		  else if(adjustment=='PAYMENT'){
            			  adjustmentType = 'Bill Payable';
            		  }
            		  else if(adjustment=='BILL'){
            			  adjustmentType = 'Bill Payable';
            			  //adjustmentType = 'Bill Receivable';
            		  }
            		  billreceivable.getView().refresh();
            		  if(manageSettlementCurrency.getValue().currencyType == true){
        				  var columns = billreceivable.columns;
                		   for(var i in columns) {
                			   if (columns[i].dataIndex == "currencyExchangeRate" || columns[i].dataIndex == "convertedBalanceAmount") {
                				   columns[i].hide();
                			   }
                		   }  
        			  }else{
        				  var columns = billreceivable.columns;
                		   for(var i in columns) {
                			   if (columns[i].dataIndex == "currencyExchangeRate" || columns[i].dataIndex == "convertedBalanceAmount") {
                				   columns[i].show();
                			   }
                		   }    
        			  }

            		  billreceivable.getStore().getProxy().extraParams = {
            			  billedUserType: billedUserType,
            			  id:id,
            			  adjustmentType:adjustmentType,
            			  showAllSettlement:showAllSettlement,
            			  whetherCreatedCurrency:manageSettlementCurrency.getValue().currencyType,
            			  limit:1000
            		  };
            		  billreceivable.getStore().load({
            			  callback: function(records, operation, success) {
            				  if (success) {
            					  $this.getAmountToSettle();
            					  $this.setProgressTracker(1);
            					  $this.setProgressTracker(2);
            				  }
            			  }	   
            		  });
            	  }else{
            		  showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
            	  }
            	  var manageSettlementCurrencyReadOnly =  form.down("#manageSettlementCurrency");
            	  manageSettlementCurrencyReadOnly.setReadOnly(true);
              },
              instrumentNextTab : function(){
            	  var $this=this;
            	  var tabstructure = this.getAdjustmentstructure().down("#adjustmenttabstructure");
            	  var grid = this.getInstumentdetailslist();
            	  var adjustment = this.getAdjustmentstructure().down('adjustmentfilters').down("#adjustment").getValue();

            	  var billreceivable = this.getBillreceivablelist();
            	  var allBillsList = this.getAllbillslist();
            	  var structure = this.getAdjustmentstructure();
            	  var form = structure.down('adjustmentfilters');
        		  var manageSettlementCurrency =  form.down("#manageSettlementCurrency");
            	  var thirdParty =  form.down("#thirdParty");
            	  var sponsors =  form.down("#sponsors");
            	  var applicant =  form.down("#applicant");
            	  var userId =  form.down("#userId");
            	  var student =  form.down("#student");

            	  var id=0;
            	  var billedUserType=null;
            	  if(!thirdParty.isHidden()){
            		  id = thirdParty.getValue();
            		  billedUserType ="THIRD PARTY";

            	  }else if(!sponsors.isHidden()){
            		  id = sponsors.getValue();
            		  billedUserType ="SPONSOR";

            	  }else if(!applicant.isHidden()){
            		  id = applicant.getValue();
            		  billedUserType ="APPLICANT";

            	  }else if(!userId.isHidden()){
            		  id = userId.getValue();
            		  billedUserType ="USER";  

            	  }else if(!student.isHidden()){
            		  id = student.getValue();
            		  billedUserType ="STUDENT";
            	  }

            	  var value = form.down("#adjustmentFor").getValue();
            	  var showAllSettlement = form.down("#showAllSettlementId").getValue();
            	  var adjustment = form.down("#adjustment").getValue();
            	  var adjustmentType;

            	  switch(showAllSettlement){
            	  case 'ALL' :{
            		  showAllSettlement = 'All'
            			  break;
            	  }
            	  case 'FULLY_SETTELED' :{
            		  showAllSettlement = 'settled'
            			  break;
            	  }
            	  case 'NOT_FULLY_SETTELED' :{
            		  showAllSettlement = 'Pending'
            			  break;
            	  }
            	  }
            	  if(adjustment=='RECEIPT'){
            		  adjustmentType = 'Bill Receivable';		
            	  }
            	  else if(adjustment=='PAYMENT'){
            		  adjustmentType = 'Bill Payable';
            	  }
            	  else if(adjustment=='BILL'){
            		  adjustmentType = 'Bill Payable';
            	  }
            	  if(adjustment=='RECEIPT'){
            		  var receiptgrid = this.getReceiptslist();
            		  if (grid.getSelectionModel().getCount() > 0) {
            			  var records = grid.getSelectionModel().getSelection()[0];
            			  var receiptrecords = receiptgrid.getSelectionModel().getSelection()[0];
            			  tabstructure.down("#allbilllistcontainer").setDisabled(false);
            			  tabstructure.setActiveTab(tabstructure.down("#allbilllistcontainer"));
            			  tabstructure.down('#nextBtnAllBillBtn').setDisabled(true);
            			  tabstructure.down("#receipt_bill_no_ab").setValue(receiptrecords.get('receiptNo'));
            			  if(billedUserType=='STUDENT' || billedUserType=='APPLICANT' || billedUserType=='USER' || billedUserType=='THIRD PARTY')
            			  {
            			  	tabstructure.down('#fnpMultiBrandCampusAdjustmentItemId').hide();
            			  }
            			  
            			  if(manageSettlementCurrency.getValue().currencyType == false)
            			  {
            			  if(receiptrecords.get('acadLocCurrConvertedAmount')!=null && receiptrecords.get('baseCurrencyCode'))
            			  {
            				  var baseCurrencyCode = receiptrecords.get('baseCurrencyCode') || '';
            				  var acadLocCurrConvertedAmount = parseFloat(receiptrecords.get('acadLocCurrConvertedAmount')) || 0;
        					  var roundedAcadLocCurrConvertedAmount = Ext.util.Format.round(acadLocCurrConvertedAmount, 2).toFixed(2);
        					  tabstructure.down("#receipt_bill_amount_ab").setValue(baseCurrencyCode + " " + roundedAcadLocCurrConvertedAmount);
            			  }
            			  }else
            			  {
            				  var RAmount = parseFloat(receiptrecords.get('amount')) || 0;
            				  var roundedRAmount = Ext.util.Format.round(RAmount, 2).toFixed(2);
            				  tabstructure.down("#receipt_bill_amount_ab").setValue(roundedRAmount);
            				  tabstructure.down("#receiptCurrency").setValue(receiptrecords.get('currencyId'));
            			  }
            			  
            			  tabstructure.down("#instrument_no_ab").setVisible(true);
            			  if(records.get('instrumentNo').length>20){
            				  tabstructure.down("#instrument_no_ab").setWidth(300);
            			  }else{
            				  tabstructure.down("#instrument_no_ab").setWidth(200);
            			  }
            			  tabstructure.down("#instrument_amount_ab").setVisible(true);
            			  tabstructure.down("#instrument_no_ab").setValue(records.get('instrumentNo'));
            			  
            			  if(manageSettlementCurrency.getValue().currencyType == false)
            			  {
            				  var baseCurrencyCode = receiptrecords.get('baseCurrencyCode') || '';
            				  var totalInstrumentBalance = parseFloat(records.get('totalInstrumentBalanceAmountInALBaseCurrency')) || 0;

            				  var roundedAmount = Ext.util.Format.round(totalInstrumentBalance, 2).toFixed(2);

            				  var finalValue = baseCurrencyCode + ' ' + roundedAmount;

            				  tabstructure.down("#instrument_amount_ab").setValue(finalValue);
            				  tabstructure.down("#recipt_bill_balance_amount_ab").setValue(finalValue);
            			  }else
            			  {
            				  var instrumentAmount = parseFloat(records.get('instrumentAmount')) || 0;
            				  var totalInstrumentBalanceAmount = parseFloat(records.get('totalInstrumentBalanceAmount')) || 0;

            				  var roundedInstrumentAmount = Ext.util.Format.round(instrumentAmount, 2).toFixed(2);
            				  var roundedTotalBalanceAmount = Ext.util.Format.round(totalInstrumentBalanceAmount, 2).toFixed(2);

            				  tabstructure.down("#instrument_amount_ab").setValue(roundedInstrumentAmount);
            				  tabstructure.down("#recipt_bill_balance_amount_ab").setValue(roundedTotalBalanceAmount);
            			  }
            			  
            			  
            			  var form = structure.down('adjustmentfilters');
            			  var thirdParty =  form.down("#thirdParty");
            			  var sponsors =  form.down("#sponsors");
            			  var applicant =  form.down("#applicant");
            			  var userId =  form.down("#userId");
            			  var student =  form.down("#student");

            			  var id=0;
            			  var billedUserType=null;
            			  if(!thirdParty.isHidden()){
            				  id = thirdParty.getValue();
            				  billedUserType ="THIRD PARTY";

            			  }else if(!sponsors.isHidden()){
            				  id = sponsors.getValue();
            				  billedUserType ="SPONSOR";


            			  }else if(!applicant.isHidden()){
            				  id = applicant.getValue();
            				  billedUserType ="APPLICANT";

            			  }else if(!userId.isHidden()){
            				  id = userId.getValue();
            				  billedUserType ="USER";  

            			  }else if(!student.isHidden()){
            				  id = student.getValue();
            				  billedUserType ="STUDENT";
            			  }

            			  var value = form.down("#adjustmentFor").getValue();
            			  var manageSettlementCurrency =  form.down("#manageSettlementCurrency");
            			  var showAllSettlement = form.down("#showAllSettlementId").getValue();
            			  var adjustment = form.down("#adjustment").getValue();
            			  var adjustmentType;

            			  switch(showAllSettlement){
            			  case 'ALL' :{
            				  showAllSettlement = 'All'
            					  break;
            			  }
            			  case 'FULLY_SETTELED' :{
            				  showAllSettlement = 'settled'
            					  break;
            			  }
            			  case 'NOT_FULLY_SETTELED' :{
            				  showAllSettlement = 'Pending'
            					  break;
            			  }
            			  }

            			  if(adjustment=='RECEIPT'){
            				  adjustmentType = 'Bill Receivable';		
            			  }
            			  else if(adjustment=='PAYMENT'){
            				  adjustmentType = 'Bill Payable';
            			  }
            			  else if(adjustment=='BILL'){
            				  adjustmentType = 'Bill Payable';
            			  }

        					if(!sponsors.isHidden()){
     	                	   Ext.Ajax.request({
    	                		   method: "GET",
    	                		   type: 'rest',
    	                		   url: SERVERURL.SPONSORSHIP_URL,
    	                		   params: {
    	                			   id: id
    	                		   },
    	                		   success: function(f, action) {
    	                			   var responseData = Ext.JSON.decode(f.responseText);
    	                			   var sponsorsIsSuspenseAccount = responseData.isSuspenseAccount;
    	                			   if(!sponsors.isHidden()&& sponsorsIsSuspenseAccount == false && !isNullOrEmpty(sponsorsIsSuspenseAccount)){
    	                			   		tabstructure.down('#studentNameId').hide();
    	                			   }else{
    	                				   tabstructure.down('#studentNameId').show();
    	                				   tabstructure.down('#studentSearchBtn').show();
    	                			   }
    	                		   }
    	                	   });
           					}
            			  
          					 if(manageSettlementCurrency.getValue().currencyType == true){
	            				  var columns = allBillsList.columns;
		                		   for(var i in columns) {
		                			   if (columns[i].dataIndex == "currencyExchangeRate" || columns[i].dataIndex == "convertedBalanceAmount") {
		                				   columns[i].hide();
		                			   }
		                		   }  
	            			  }else{
	            				  var columns = allBillsList.columns;
		                		   for(var i in columns) {
		                			   if (columns[i].dataIndex == "currencyExchangeRate" || columns[i].dataIndex == "convertedBalanceAmount") {
		                				   columns[i].show();
		                			   }
		                		   }    
	            			  }

      						allBillsList.getStore().getProxy().extraParams = {
              				  billedUserType: billedUserType,
              				  id:id,
              				  adjustmentType:adjustmentType,
              				  showAllSettlement:showAllSettlement,
              				  limit:1000,
              				  fetchBillOfOtherCurrency:manageSettlementCurrency.getValue().currencyType,
              				  currencyId: records.get('currencyId') 
              			  };
              			  allBillsList.getStore().reload();
            			  
            			  $this.setProgressTracker(2);
            		  }else{
            			  showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
            		  } 
            	  }
            	  else if(adjustment=='PAYMENT'){
            		  var $this=this;
            		  var paymentgrid = this.getPaymentslist();
            		  var form = structure.down('adjustmentfilters');
            		  var manageSettlementCurrency =  form.down("#manageSettlementCurrency");
            		  if (grid.getSelectionModel().getCount() > 0) {
            			  var records = grid.getSelectionModel().getSelection()[0];
            			  var paymentrecords = paymentgrid.getSelectionModel().getSelection()[0];
            			  tabstructure.down("#billreceivablecontainer").setDisabled(false);
            			  tabstructure.setActiveTab(tabstructure.down("#billreceivablecontainer"));
            			  tabstructure.down("#receipt_bill_no").setFieldLabel(getFeeAndPaymentCommonTranslation('PAYMENT_NO'));
            			  tabstructure.down("#receipt_bill_amount").setFieldLabel(getFeeAndPaymentCommonTranslation('PAYMENT_AMOUNT'));
            			  tabstructure.down("#receipt_bill_no").setValue(paymentrecords.get('paymentVoucherNo'));
            			  if(manageSettlementCurrency.getValue().currencyType == false)
            			  {
            			  if(paymentrecords.get('convertedAmount')!=null && paymentrecords.get('baseCurrencyCode'))
            			  {
            				  tabstructure.down("#receipt_bill_amount").setValue(paymentrecords.get('baseCurrencyCode')+" "+paymentrecords.get('convertedAmount'));
            			  }
            			  }else
            			  {
            			  tabstructure.down("#receipt_bill_amount").setValue(paymentrecords.get('amount'));
            			  }
            			  tabstructure.down("#instrument_no").setVisible(true);
            			  if(records.get('instrumentNo').length>20){
            				  tabstructure.down("#instrument_no").setWidth(300);
            			  }else{
            				  tabstructure.down("#instrument_no").setWidth(200);
            			  }
            			  tabstructure.down("#instrument_amount").setVisible(true);
            			  tabstructure.down("#instrument_no").setValue(records.get('instrumentNo'));
            			  if(manageSettlementCurrency.getValue().currencyType == false)
            			  {
            				  var baseCurrencyCode = paymentrecords.get('baseCurrencyCode') || '';
            				  var totalInstrumentBalance = parseFloat(records.get('totalInstrumentBalanceAmountInALBaseCurrency')) || 0;
            				  var roundedBalance = Ext.util.Format.round(totalInstrumentBalance, 2).toFixed(2);
            				  var finalValue = baseCurrencyCode + " " + roundedBalance;
            				  tabstructure.down("#instrument_amount").setValue(finalValue);
            				  tabstructure.down("#recipt_bill_balance_amount").setValue(finalValue);
            			  }else
            			  {
            				  var totalInstrumentBalanceAmount = parseFloat(records.get('totalInstrumentBalanceAmount')) || 0;
            				  var roundedAmount = Ext.util.Format.round(totalInstrumentBalanceAmount, 2).toFixed(2);
            				  tabstructure.down("#instrument_amount").setValue(roundedAmount);
            				  tabstructure.down("#recipt_bill_balance_amount").setValue(roundedAmount);
            			  }
            			  if(manageSettlementCurrency.getValue().currencyType == true){
            				  var columns = billreceivable.columns;
	                		   for(var i in columns) {
	                			   if (columns[i].dataIndex == "currencyExchangeRate" || columns[i].dataIndex == "convertedBalanceAmount") {
	                				   columns[i].hide();
	                			   }
	                		   }  
            			  }else{
            				  var columns = billreceivable.columns;
	                		   for(var i in columns) {
	                			   if (columns[i].dataIndex == "currencyExchangeRate" || columns[i].dataIndex == "convertedBalanceAmount") {
	                				   columns[i].show();
	                			   }
	                		   }    
            			  }

            			  billreceivable.getStore().getProxy().extraParams = {
            				  billedUserType: billedUserType,
            				  id:id,
            				  adjustmentType:adjustmentType,
            				  showAllSettlement:showAllSettlement,
            				  limit:1000,
            				  whetherCreatedCurrency:manageSettlementCurrency.getValue().currencyType,
            				  currencyId: records.get('currencyId')
            			  };
            			  billreceivable.getStore().load({
            				  callback: function(records, operation, success) {
            					  if (success) {
            						  //$this.getAmountToSettle();
            						  var istrmntGrid = $this.getInstumentdetailslist();
            		            	  var records = istrmntGrid.getSelectionModel().getSelection()[0];
            		            	  // var records = paymentgrid.getSelectionModel().getSelection()[0];
            		            	  var totalRecieptBalanceAmount=records.get('totalInstrumentBalanceAmount');
            		            	  var totalInstrumentBalanceAmountInALBaseCurrency=records.get('totalInstrumentBalanceAmountInALBaseCurrency');
            		            	  var balance=tabstructure.down('#recipt_bill_balance_amount');
            		            	  var form = structure.down('adjustmentfilters');
            		            	  var manageSettlementCurrency =  form.down("#manageSettlementCurrency");
            		            	  var totalBalanceAmount=balance.getValue();
            		            	  var receiptslistgrid = $this.getBillreceivablelist();
            		            	  receiptslistgrid.getView().refresh()
            		            	  var models=null;
            		            	  var models = receiptslistgrid.getStore().getRange();

            		            	  var totalCount=0;
            		            	  var validTotalCount=0;
            		            	  var amountToBeAdjustedCount=0;
            		            	  if(receiptslistgrid.getStore().data.length > 0)
            		            	  {
            		            		  for(var i=0;i< receiptslistgrid.getStore().data.length;i++)
            		            		  {
            		            			  if(manageSettlementCurrency.getValue().currencyType == true){
            		            			  var totalbalance= receiptslistgrid.getStore().getAt(i).get('totalBalanceAmount');
            		            			  var amountToBeAdjusted= receiptslistgrid.getStore().getAt(i).get('amountToBeAdjusted');
            		            			  var totalCountValidation=totalCount+totalbalance;
            		            			  if(totalbalance != 0){
            		            				  if(totalCountValidation < totalRecieptBalanceAmount &&  totalCountValidation  < totalRecieptBalanceAmount )
            		            				  {
                		            					  //models[i].set('amountToBeAdjusted', totalbalance);
                		            					  //models[i].set('totalBalanceAmount', 0);
                		            					  //totalCount=totalCount+totalbalance;
                		            					  //amountToBeAdjustedCount=amountToBeAdjustedCount+amountToBeAdjusted;
            		            					  validTotalCount=1;
            		            				  }else if(totalCount == totalRecieptBalanceAmount){
            		            				  }else
            		            				  {
            		            					  var remainingAmmout=totalRecieptBalanceAmount-totalCount;
            		            					  var remainingsettled= totalRecieptBalanceAmount - totalCount;
            		            					  var amounttosettled=totalbalance - remainingsettled;
                		            					  //models[i].set('amountToBeAdjusted', remainingAmmout);
                		            					  //models[i].set('totalBalanceAmount', amounttosettled);
                		            					  amountToBeAdjustedCount=amountToBeAdjustedCount+amountToBeAdjusted;
                		            					  validTotalCount=2;
                		            					  //tabstructure.down("#recipt_bill_balance_amount").setValue(0);   //hardCoded
                		            					  break;
                		            				  }
                		            			  }
            		            			  }else{
            		            				  var baseCurrencyCovertedbalanceAmount= receiptslistgrid.getStore().getAt(i).get('totalBalanceAmount');
            		            				  var baseCurrencyCovertedAdjustedAmount= receiptslistgrid.getStore().getAt(i).get('baseCurrencyCovertedAdjustedAmount');
            		            				  var exchangeRate = receiptslistgrid.getStore().getAt(i).get('exchangeRate');
            		            				  var convertedBalanceAmount=baseCurrencyCovertedbalanceAmount*exchangeRate;
            		            				  var totalCountValidation=totalCount+baseCurrencyCovertedbalanceAmount;
            		            				  if(totalbalance != 0){
            		            					  if(totalCountValidation < totalInstrumentBalanceAmountInALBaseCurrency &&  totalCountValidation  < totalInstrumentBalanceAmountInALBaseCurrency )
            		            					  {
            		            						  /*models[i].set('amountToBeAdjusted', baseCurrencyCovertedbalanceAmount);
            		            						  models[i].set('totalBalanceAmount', 0);*/
            		            						  models[i].set('convertedBalanceAmount',convertedBalanceAmount);
            		            						  //totalCount=totalCount+baseCurrencyCovertedbalanceAmount;
            		            						  //amountToBeAdjustedCount=amountToBeAdjustedCount+amountToBeAdjusted;
            		            						  validTotalCount=1;
            		            					  }else if(totalCount == totalRecieptBalanceAmount){
            		            					  }else
            		            					  {
            		            						  var remainingAmmout=totalInstrumentBalanceAmountInALBaseCurrency-totalCount;
            		            						  var remainingsettled=totalInstrumentBalanceAmountInALBaseCurrency-totalCount;
            		            						  var amounttosettled=baseCurrencyCovertedbalanceAmount - remainingsettled;
            		            						  //models[i].set('amountToBeAdjusted', remainingAmmout);
            		            						  //models[i].set('totalBalanceAmount', amounttosettled);
            		            					  amountToBeAdjustedCount=amountToBeAdjustedCount+amountToBeAdjusted;

            		            					  validTotalCount=2;
            		            						 // tabstructure.down("#recipt_bill_balance_amount").setValue(0);   //hardCoded
            		            					  break;
            		            				  }
            		            			  }
            		            		  }
            		            		  }
            		            		  var recipt_bill_balance_amount_value=  tabstructure.down("#recipt_bill_balance_amount").getValue(records.get('totalBalanceAmount'));
            		            		  var totalRemaining=recipt_bill_balance_amount_value-totalCount;
            		            		  /*if(validTotalCount==1)
            		            			  tabstructure.down("#recipt_bill_balance_amount").setValue(recipt_bill_balance_amount_value-totalCount);*/
            		            	  }
            						  $this.setProgressTracker(2);		
            					  }
            				  }	   
            			  });

            		  }else{
            			  showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
            		  } 
            	  }
            	  var manageSettlementCurrencyReadOnly =  form.down("#manageSettlementCurrency");
            	  manageSettlementCurrencyReadOnly.setReadOnly(true);
              },
              allbillNextTab: function(){

            	  var $this=this;
            	  var tabstructure = this.getAdjustmentstructure().down("#adjustmenttabstructure");
            	  var grid = this.getAllbillslist();
            	  var adjustment = this.getAdjustmentstructure().down('adjustmentfilters').down("#adjustment").getValue();

            	  var billreceivable = this.getBillreceivablelist();
            	  var structure = this.getAdjustmentstructure();
            	  var form = structure.down('adjustmentfilters');
            	  var thirdParty =  form.down("#thirdParty");
            	  var sponsors =  form.down("#sponsors");
            	  var applicant =  form.down("#applicant");
            	  var userId =  form.down("#userId");
            	  var student =  form.down("#student");
            	  var manageSettlementCurrency =  form.down("#manageSettlementCurrency");

            	  var id=0;
            	  var billedUserType=null;
            	  if(!thirdParty.isHidden()){
            		  id = thirdParty.getValue();
            		  billedUserType ="THIRD PARTY";

            	  }else if(!sponsors.isHidden()){
            		  id = '';
            		  //billedUserType = getFeeAndPaymentCommonTranslation('SPONSOR_TYPE');
            		  billedUserType ="STUDENT";

            	  }else if(!applicant.isHidden()){
            		  id = applicant.getValue();
            		  billedUserType ="APPLICANT";

            	  }else if(!userId.isHidden()){
            		  id = userId.getValue();
            		  billedUserType ="USER";  

            	  }else if(!student.isHidden()){
            		  id = student.getValue();
            		  billedUserType ="STUDENT";
            	  }

            	  var value = form.down("#adjustmentFor").getValue();
            	  var showAllSettlement = form.down("#showAllSettlementId").getValue();
            	  var adjustment = form.down("#adjustment").getValue();
            	  var adjustmentType;

            	  switch(showAllSettlement){
            	  case 'ALL' :{
            		  showAllSettlement = 'All'
            			  break;
            	  }
            	  case 'FULLY_SETTELED' :{
            		  showAllSettlement = 'settled'
            			  break;
            	  }
            	  case 'NOT_FULLY_SETTELED' :{
            		  showAllSettlement = 'Pending'
            			  break;
            	  }
            	  }
            	  if(adjustment=='RECEIPT'){
            		  adjustmentType = 'Bill Receivable';		
            	  }
            	  else if(adjustment=='PAYMENT'){
            		  adjustmentType = 'Bill Payable';
            	  }
            	  else if(adjustment=='BILL'){
            		  adjustmentType = 'Bill Payable';
            	  }
            	  if(adjustment=='RECEIPT'){
            		  var receiptgrid = this.getReceiptslist();
            		  var selectionModel =  grid.getSelectionModel();
            		  if (selectionModel.getCount() > 0) {
            			  var records = selectionModel.getSelection()[0];
            			  var billHeaderIdsArr = [];
            			  selectionModel.getSelection().forEach(function(obj){
            				  billHeaderIdsArr.push(obj.get('billHeaderId'));
            			  });
            			  
            			  var storeLength = grid.getStore().getRange();  
                		  var count = 0;
                		  for(var i in storeLength){
                			  if(storeLength[i].get("amountToBeAdjusted")!=undefined && storeLength[i].get("amountToBeAdjusted")>0){
                				  count = count+1; 
                			  }
                		  }	  
                		  if(selectionModel.getCount() == count){
            			  
	            			  var receiptrecords = receiptgrid.getSelectionModel().getSelection()[0];
	            			  
	            			  tabstructure.down("#billreceivablecontainer").setDisabled(false);
	            			  tabstructure.setActiveTab(tabstructure.down("#billreceivablecontainer"));
	            			  tabstructure.down("#receipt_bill_no").setValue(receiptrecords.get('receiptNo'));
	            			  
	            			  var receiptAmount = parseFloat(receiptrecords.get('amount')) || 0;
        					  var roundedReceiptAmount = Ext.util.Format.round(receiptAmount, 2).toFixed(2);
	            			  tabstructure.down("#receipt_bill_amount").setValue(roundedReceiptAmount);
	            			  if(receiptrecords.get('voucherMode') == "BANK"){
	            				  var instumentGrid = this.getInstumentdetailslist();
	            				  var instumentRec = instumentGrid.getSelectionModel().getSelection()[0];
		            			  tabstructure.down("#instrument_no").setVisible(true);
		            			  if(instumentRec.get('instrumentNo').length>20){
		            				  tabstructure.down("#instrument_no").setWidth(300);
		            			  }else{
		            				  tabstructure.down("#instrument_no").setWidth(200);
		            			  }
		            			  tabstructure.down("#instrument_amount").setVisible(true);
		            			  tabstructure.down("#instrument_no").setValue(instumentRec.get('instrumentNo'));
		            			  var instrument_amount_ab = parseFloat(tabstructure.down('#instrument_amount_ab').getValue()) || 0;
		            			  var roundedValue = Ext.util.Format.round(instrument_amount_ab, 2).toFixed(2);
		            			  tabstructure.down("#instrument_amount").setValue(roundedValue);
	            			  } else {
	            				  tabstructure.down("#instrument_no").setVisible(false);
		            			  tabstructure.down("#instrument_amount").setVisible(false);
	            			  }
	            			  tabstructure.down("#receipt_bill_amount").setValue(tabstructure.down('#receipt_bill_amount_ab').getValue());
	            			  var recipt_bill_balance_amount_ab = parseFloat(tabstructure.down('#recipt_bill_balance_amount_ab').getValue()) || 0;
	            			  var roundedValue = Ext.util.Format.round(recipt_bill_balance_amount_ab, 2).toFixed(2);
	            			  tabstructure.down("#recipt_bill_balance_amount").setValue(roundedValue);
	            			  if(manageSettlementCurrency.getValue().currencyType == true){
	            				  var columns = billreceivable.columns;
		                		   for(var i in columns) {
		                			   if (columns[i].dataIndex == "currencyExchangeRate" || columns[i].dataIndex == "convertedBalanceAmount") {
		                				   columns[i].hide();
		                			   }
		                		   }  
	            			  }else{
	            				  var columns = billreceivable.columns;
		                		   for(var i in columns) {
		                			   if (columns[i].dataIndex == "currencyExchangeRate" || columns[i].dataIndex == "convertedBalanceAmount") {
		                				   columns[i].show();
		                			   }
		                		   }    
	            			  }
	
	            			  billreceivable.getStore().getProxy().extraParams = {
	            				  billedUserType: billedUserType,
	            				  id:id,
	            				  adjustmentType:adjustmentType,
	            				  showAllSettlement:showAllSettlement,
	            				 billHeaderIds:billHeaderIdsArr.join(),
	            				  fetchBillOfOtherCurrency:manageSettlementCurrency.getValue().currencyType,
	            				  limit:1000
	            			  };
	            			  billreceivable.getStore().load({
	            				  url: SERVERURL.GRID_DATA_BILLS_HEAD_SETTLEMENT_FOR,
	            				  callback: function(record, operation, success) {
	            					  if (success) {
	            						  allbillslist = $this.getAllbillslist();
	            						  billSelected = allbillslist.getSelectionModel().getSelection();
	            						  tempArr = [];
	            						  billSelected.forEach(function(obj){
	            							  tempArr.push({amountToBeAdjusted:obj.get('amountToBeAdjusted'), billHeaderId:obj.get('billHeaderId')});
	            						  });
	            		            	  
	            		            	  if(this.getCount() > 0)
	            		            	  {	  
	            		            		  this.group('billHeaderId');
	            		            		  this.groups.items.forEach(function(obj1){
	            		            			  headLength = obj1.records.length;
	            		            			  obj1.records.forEach(function(obj2){
	            		            				  for(i=0;i<=billSelected.length-1;i++){
	            		            					  if(manageSettlementCurrency.getValue().currencyType == true){
	            		            					  if(obj2.get('billHeaderId') == billSelected[i].get('billHeaderId')){
	            		            						  totalAmtToAdjustForHeads = billSelected[i].get('amountToBeAdjusted');
	            		            						  if(totalAmtToAdjustForHeads>0){
		            		            						  if(obj2.get('totalBalanceAmount') >= totalAmtToAdjustForHeads){
		            		            							  amounttosettled = obj2.get('totalBalanceAmount') - totalAmtToAdjustForHeads;
		            		            							  obj2.set('amountToBeAdjusted', totalAmtToAdjustForHeads);
		            		            							  obj2.set('totalBalanceAmount', amounttosettled);
		            		            							  billSelected[i].set('amountToBeAdjusted',0);
		            		            						  } else {
		            		            							  totalRemainingBalance = totalAmtToAdjustForHeads - obj2.get('totalBalanceAmount');
		            		            							  obj2.set('amountToBeAdjusted', obj2.get('totalBalanceAmount'));
		            		            							  obj2.set('totalBalanceAmount', 0);
		            		            							  billSelected[i].set('amountToBeAdjusted',totalRemainingBalance);
		            		            						  }
	            		            						  }
	            		            					  }
	            		            					  }else{
	            		            						  if(obj2.get('billHeaderId') == billSelected[i].get('billHeaderId')){
	            		            							  totalAmtToAdjustForHeads = billSelected[i].get('amountToBeAdjusted');
	            		            							  if(totalAmtToAdjustForHeads>0){
	            		            								  if(obj2.get('convertedBalanceAmount') >= totalAmtToAdjustForHeads){
	            		            									  amounttosettled = obj2.get('convertedBalanceAmount') - totalAmtToAdjustForHeads;
	            		            									  obj2.set('amountToBeAdjusted', totalAmtToAdjustForHeads);
	            		            									  obj2.set('convertedBalanceAmount', amounttosettled);
	            		            									  billSelected[i].set('amountToBeAdjusted',0);
	            		            								  } else {
	            		            									  totalRemainingBalance = totalAmtToAdjustForHeads - obj2.get('convertedBalanceAmount');
	            		            									  obj2.set('amountToBeAdjusted', obj2.get('convertedBalanceAmount'));
	            		            									  obj2.set('convertedBalanceAmount', 0);
	            		            									  billSelected[i].set('amountToBeAdjusted',totalRemainingBalance);
	            		            								  }
	            		            							  }
	            		            						  }
	            		            					  }
	            		            				  }
	            		            			  });
	            		            		  });
	            		            		  tempArr.forEach(function(obj1){
	            		            			  billSelected.forEach(function(obj2){
	            		            				  if(obj2.get('billHeaderId') == obj1.billHeaderId){
	            		            					  obj2.set('amountToBeAdjusted',obj1.amountToBeAdjusted);
	            		            				  }
	            		            			  });
	            		            		  });
	            		            		  this.clearGrouping();
	            		            	  }
	            						  $this.setProgressTracker(3);		
	            					  }
	            				  }	   
	            			  });
            			  } else {
                			  showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_ALL_UPDATED_RECORDS'));//Please select a record
                		  }
            		  }else{
            			  showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
            		  } 
            	  }
            	  else if(adjustment=='PAYMENT'){
            		  var $this=this;
            		  var paymentgrid = this.getPaymentslist();
            		  if (grid.getSelectionModel().getCount() > 0) {
            			  var records = grid.getSelectionModel().getSelection()[0];
            			  var paymentrecords = paymentgrid.getSelectionModel().getSelection()[0];
            			  tabstructure.down("#billreceivablecontainer").setDisabled(false);
            			  tabstructure.setActiveTab(tabstructure.down("#billreceivablecontainer"));
            			  tabstructure.down("#receipt_bill_no").setFieldLabel(getFeeAndPaymentCommonTranslation('PAYMENT_NO'));
            			  tabstructure.down("#receipt_bill_amount").setFieldLabel(getFeeAndPaymentCommonTranslation('PAYMENT_AMOUNT'));
            			  tabstructure.down("#receipt_bill_no").setValue(paymentrecords.get('paymentVoucherNo'));
            			  
            			  var paymentAmount = parseFloat(paymentrecords.get('amount')) || 0;
    					  var roundedPaymentAmount = Ext.util.Format.round(paymentAmount, 2).toFixed(2);
            			  tabstructure.down("#receipt_bill_amount").setValue(roundedPaymentAmount);
            			  tabstructure.down("#instrument_no").setVisible(true);
            			  if(records.get('instrumentNo').length>20){
            				  tabstructure.down("#instrument_no").setWidth(300);
            			  }else{
            				  tabstructure.down("#instrument_no").setWidth(200);
            			  }
            			  tabstructure.down("#instrument_amount").setVisible(true);
            			  tabstructure.down("#instrument_no").setValue(records.get('instrumentNo'));
            			  
            			  var totalInstrumentBalanceAmount = parseFloat(records.get('totalInstrumentBalanceAmount')) || 0;
            			  var roundedValue = Ext.util.Format.round(totalInstrumentBalanceAmount, 2).toFixed(2);
            			  tabstructure.down("#instrument_amount").setValue(roundedValue);
            			  tabstructure.down("#recipt_bill_balance_amount").setValue(roundedValue);

            			  billreceivable.getStore().getProxy().extraParams = {
            				  billedUserType: billedUserType,
            				  id:id,
            				  adjustmentType:adjustmentType,
            				  showAllSettlement:showAllSettlement,
            				  limit:1000
            			  };
            			  billreceivable.getStore().load({
            				  callback: function(records, operation, success) {
            					  if (success) {
            						  //$this.getAmountToSettle();
            						  var istrmntGrid = $this.getInstumentdetailslist();
            		            	  var records = istrmntGrid.getSelectionModel().getSelection()[0];
            		            	  // var records = paymentgrid.getSelectionModel().getSelection()[0];
            		            	  var totalRecieptBalanceAmount=records.get('totalInstrumentBalanceAmount');
            		            	  var balance=tabstructure.down('#recipt_bill_balance_amount');
            		            	  var totalBalanceAmount=balance.getValue();
            		            	  var receiptslistgrid = $this.getBillreceivablelist();
            		            	  receiptslistgrid.getView().refresh()
            		            	  var models=null;
            		            	  var models = receiptslistgrid.getStore().getRange();

            		            	  var totalCount=0;
            		            	  var validTotalCount=0;
            		            	  var amountToBeAdjustedCount=0;
            		            	  if(receiptslistgrid.getStore().data.length > 0)
            		            	  {
            		            		  for(var i=0;i< receiptslistgrid.getStore().data.length;i++)
            		            		  {
            		            			  var totalbalance= receiptslistgrid.getStore().getAt(i).get('totalBalanceAmount');
            		            			  var amountToBeAdjusted= receiptslistgrid.getStore().getAt(i).get('amountToBeAdjusted');
            		            			  var totalCountValidation=totalCount+totalbalance;
            		            			  if(totalbalance != 0){
            		            				  if(totalCountValidation < totalRecieptBalanceAmount &&  totalCountValidation  < totalRecieptBalanceAmount )
            		            				  {
            		            					  models[i].set('amountToBeAdjusted', totalbalance);
            		            					  models[i].set('totalBalanceAmount', 0);
            		            					  totalCount=totalCount+totalbalance;
            		            					  amountToBeAdjustedCount=amountToBeAdjustedCount+amountToBeAdjusted;
            		            					  validTotalCount=1;
            		            				  }else if(totalCount == totalRecieptBalanceAmount){
            		            				  }else
            		            				  {
            		            					  var remainingAmmout=totalRecieptBalanceAmount-totalCount;
            		            					  // models[i].set('amountToBeAdjusted',);
            		            					  var remainingsettled= totalRecieptBalanceAmount - totalCount;
            		            					  var amounttosettled=totalbalance - remainingsettled;
            		            					  models[i].set('amountToBeAdjusted', remainingAmmout);
            		            					  models[i].set('totalBalanceAmount', amounttosettled);
            		            					  amountToBeAdjustedCount=amountToBeAdjustedCount+amountToBeAdjusted;

            		            					  validTotalCount=2;
            		            					  tabstructure.down("#recipt_bill_balance_amount").setValue(0);   //hardCoded
            		            					  break;
            		            				  }
            		            			  }
            		            		  }
            		            		  var recipt_bill_balance_amount_value=  tabstructure.down("#recipt_bill_balance_amount").getValue(records.get('totalBalanceAmount'));
            		            		  var totalRemaining=recipt_bill_balance_amount_value-totalCount;
            		            		  if(validTotalCount==1)
            		            			  tabstructure.down("#recipt_bill_balance_amount").setValue(recipt_bill_balance_amount_value-totalCount);
            		            	  }
            						  $this.setProgressTracker(2);		
            					  }
            				  }	   
            			  });

            		  }else{
            			  showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
            		  } 
            	  }
            	  var manageSettlementCurrencyReadOnly =  form.down("#manageSettlementCurrency");
            	  manageSettlementCurrencyReadOnly.setReadOnly(true);
              },
              setProgressTracker : function(progresstracker){
            	  var structure = this.getAdjustmentstructure();
            	  var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");

            	  var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
            	  var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
            	  var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");
            	  var progresstracker4 = adjustmentprogresstracker.down("#progresstracker4");
            	  var progresstracker5 = adjustmentprogresstracker.down("#progresstracker5");

            	  if(progresstracker==1){
            		  for(var i = 0; i < 11; i ++ ){
            			  progresstracker1.updateProgress((i * 0.1), '');
            		  }
            		  progresstracker1.textEl.addCls("custom-progress-text");
            		  progresstracker1.textEl.removeCls("inProgressCss-progress-text");
            		  progresstracker2.textEl.removeCls("x-progress-text x-progress-text-back");
            		  progresstracker2.textEl.addCls("inProgressCss-progress-text");
            		  progresstracker2.updateText("Step 2 In Progress");
            		  progresstracker1.updateText(getCommonTranslation('STEP_1_COMPLETE'));
            	  }
            	  if(progresstracker==2){
            		  for(var i = 0; i < 11; i ++ ){
            			  progresstracker2.updateProgress((i * 0.1), '');
            		  }
            		  progresstracker3.textEl.removeCls("x-progress-text x-progress-text-back");
            		  progresstracker3.textEl.addCls("inProgressCss-progress-text");
            		  progresstracker3.updateText("Step 3 In Progress");
            		  progresstracker2.textEl.removeCls("inProgressCss-progress-text");
            		  progresstracker2.textEl.addCls("custom-progress-text");
            		  progresstracker2.updateText(getCommonTranslation('STEP_2_COMPLETE'));
            	  }
            	  if(progresstracker==3){
            		  for(var i = 0; i < 11; i ++ ){
            			  progresstracker3.updateProgress((i * 0.1), '');
            		  }
            		  progresstracker4.textEl.removeCls("x-progress-text x-progress-text-back");
            		  progresstracker4.textEl.addCls("inProgressCss-progress-text");
            		  progresstracker4.updateText("Step 4 In Progress");
            		  progresstracker3.textEl.removeCls("inProgressCss-progress-text");
            		  progresstracker3.textEl.addCls("custom-progress-text");
            		  progresstracker3.updateText(getCommonTranslation('STEP_3_COMPLETE'));
            	  }
            	  if(progresstracker==4){
            		  for(var i = 0; i < 11; i ++ ){
            			  progresstracker4.updateProgress((i * 0.1), '');
            		  }
            		  progresstracker5.textEl.removeCls("x-progress-text x-progress-text-back");
            		  progresstracker5.textEl.addCls("inProgressCss-progress-text");
            		  progresstracker5.updateText("Step 5 In Progress");
            		  progresstracker4.textEl.removeCls("inProgressCss-progress-text");
            		  progresstracker4.textEl.addCls("custom-progress-text");
            		  progresstracker4.updateText(getCommonTranslation('STEP_4_COMPLETE'));
            	  }
              },
              /**
               * set max amount limit based on balance amount and amount
               */
              setMaxAmountLimit : function(obj){
            	  var adjustmenttabstructure = this.getAdjustmentstructure().down('adjustmenttabstructure');
            	  var billReceivableGrid = this.getBillreceivablelist();
            	  var store = billReceivableGrid.getStore();
            	  var rowIndex = billReceivableGrid.getRowIndexes();
            	  var records = store.getAt(rowIndex);
            	  var totalBalanceAmount = records.get('totalBalanceAmount');
            	  var billingAmount = records.get('totalTempBalanceAmount');        		 
            	  var convertedBalanceAmountValue = records.get('convertedBalanceAmount');     
            	  var value = obj.getValue();
            	  var form = this.getAdjustmentFilters();
            	  var manageSettlementCurrency =  form.down("#manageSettlementCurrency").getValue();
            	  var adjustmentMode =  form.down("#adjustment").getValue();
            	  if(!isNullOrEmpty(value)){
            		  var recipt_bill_amount = adjustmenttabstructure.down('#recipt_bill_balance_amount');
            		  if(manageSettlementCurrency.currencyType==true)
            		  {
            		  var recipt_bill_amount_value = parseFloat(recipt_bill_amount.getValue());
            		  var roundedValue = recipt_bill_amount_value + value;
            		  recipt_bill_amount.setValue(roundedValue.toFixed(2));
            		  var totalBalanceAmountForBill = totalBalanceAmount+value;
            		  records.set('totalBalanceAmount',totalBalanceAmountForBill);
            		  }else
            		  {
            				  var recipt_bill=recipt_bill_amount.getValue();
                			  var arrValue = recipt_bill.split(' ');
                			  var recipt_bill_amount_value = arrValue[1];
                			  recipt_bill_FinalAmount= parseFloat(recipt_bill_amount_value) + value;
                			  recipt_bill_amount.setValue(arrValue[0]+" "+recipt_bill_FinalAmount.toFixed(2));
                			  var totalConvertedAmountForBill = convertedBalanceAmountValue+value;
                			  records.set('convertedBalanceAmount',totalConvertedAmountForBill);
            	  }            	  
            		 
            	  }            	  
              },
              setMaxAmountLimitForBillList : function(obj){
            	  var adjustmenttabstructure = this.getAdjustmentstructure().down('adjustmenttabstructure');
            	  var allbillslist = this.getAllbillslist();
            	  var store = allbillslist.getStore();
            	  var rowIndex = allbillslist.getRowIndexes();
            	  var records = store.getAt(rowIndex);
            	  var convertedBalanceAmountValue = records.get('convertedBalanceAmount');     
            	  var totalBalanceAmount = records.get('balanceAmount');      		 
            	  var value = obj.getValue();
            	  var form = this.getAdjustmentFilters();
            	  var manageSettlementCurrency =  form.down("#manageSettlementCurrency").getValue();
            	  if(!isNullOrEmpty(value)){
            		  var recipt_bill_amount = adjustmenttabstructure.down('#recipt_bill_balance_amount_ab');
            		  if(manageSettlementCurrency.currencyType==true)
            		  {
            			  var recipt_bill_amount_value = parseFloat(recipt_bill_amount.getValue()) || 0;
            			  var updatedValue = recipt_bill_amount_value + parseFloat(value);
            			  var roundedUpdatedValue = Ext.util.Format.round(updatedValue, 2).toFixed(2);
            			  recipt_bill_amount.setValue(roundedUpdatedValue);
            			  var totalBalanceAmountForBill = totalBalanceAmount+value;
            			  records.set('balanceAmount',totalBalanceAmountForBill);
            		  }else
            		  {
            			  var recipt_bill = recipt_bill_amount.getValue() || '';
            			  var arrValue = recipt_bill.split(' ');
            			  var recipt_bill_amount_value = parseFloat(arrValue[1]) || 0;
            			  var recipt_bill_FinalAmount = recipt_bill_amount_value + parseFloat(value);
            			  var roundedFinalAmount = Ext.util.Format.round(recipt_bill_FinalAmount, 2).toFixed(2);
            			  recipt_bill_amount.setValue(arrValue[0] + " " + roundedFinalAmount);
            			  var totalConvertedAmountForBill = convertedBalanceAmountValue+value;
            			  records.set('convertedBalanceAmount',totalConvertedAmountForBill);
            		  }            	  
            	  }            	  
              },
              /**
               * after save, grid will refresh , progressbar reset and grid will disable 
               */
              getInitialFormView : function(){
            	  var structure = this.getAdjustmentstructure();
            	  var form = structure.down('adjustmentfilters');
            	  var tabStructure =  structure.down('adjustmenttabstructure');
            	  var thirdParty =  form.down("#thirdParty");
            	  var sponsors =  form.down("#sponsors");
            	  var applicant =  form.down("#applicant");
            	  var userId =  form.down("#userId");
            	  var student =  form.down("#student");
            	  var manageSettlementCurrency =  form.down("#manageSettlementCurrency");
            	  manageSettlementCurrency.setReadOnly(true);
            	  var adForm = this.getAdjustmentFilters();
            	  
            	  var bill = adForm.down("#billNoId");
            	  var receipt = adForm.down("#receiptNoId");
            	  var payment = adForm.down("#paymentNoId");

            	  var id=0;
            	  var billedUserType=null;
            	  if(!thirdParty.isHidden()){
            		  id = thirdParty.getValue();
            		  billedUserType ="THIRD PARTY";

            	  }else if(!sponsors.isHidden()){
            		  id = sponsors.getValue();
            		  billedUserType ="SPONSOR";

            	  }else if(!applicant.isHidden()){
            		  id = applicant.getValue();
            		  billedUserType ="APPLICANT";

            	  }else if(!userId.isHidden()){
            		  id = userId.getValue();
            		  billedUserType ="USER";  

            	  }else if(!student.isHidden()){
            		  id = student.getValue();
            		  billedUserType ="STUDENT";
            	  }

            	  var value = form.down("#adjustmentFor").getValue();
            	  var showAllSettlement = form.down("#showAllSettlementId").getValue();
            	  var adjustment = form.down("#adjustment").getValue();
            	  var instrumentNumberFieldValue = form.down("#instrumentNumberId").getValue();
            	  var adjustmentType;

            	  switch(showAllSettlement){
            	  case 'ALL' :{
            		  showAllSettlement = 'All'
            			  break;
            	  }
            	  case 'FULLY_SETTELED' :{
            		  showAllSettlement = 'settled'
            			  break;
            	  }
            	  case 'NOT_FULLY_SETTELED' :{
            		  showAllSettlement = 'Pending'
            			  break;
            	  }
            	  }

            	  if(adjustment=='RECEIPT'){
            		  adjustmentType = 'Bill Receivable';
            		  receiptId=receipt.value;
            		  this.loadReceiptGrid(billedUserType,id,showAllSettlement,instrumentNumberFieldValue,receiptId,manageSettlementCurrency,form);
            		  this.loadBillReceivableGrid(billedUserType,id,adjustmentType,showAllSettlement,manageSettlementCurrency);
            	  }
            	  else if(adjustment=='PAYMENT'){
            		  adjustmentType = 'Bill Payable';
            		  paymentId=payment.value;
            		  this.loadPaymentGrid(billedUserType,id,showAllSettlement,paymentId,manageSettlementCurrency,form);
            		  this.loadBillReceivableGridForPayment(billedUserType,id,adjustmentType,showAllSettlement,manageSettlementCurrency);
            	  }
            	  else if(adjustment=='BILL'){
            		  adjustmentType = 'Bill Payable';
            		  billId= bill.value;
            		  this.loadBillGrid(billedUserType,id,adjustment,showAllSettlement,billId,manageSettlementCurrency,form);
            		  this.loadBillReceivableGridForPayment(billedUserType,id,adjustmentType,showAllSettlement,manageSettlementCurrency);
            	  }

            	  if(this.getPaymentslist().getSelectionModel().getCount()>0){
            		  this.getPaymentslist().getSelectionModel().deselectAll();  
            	  }
            	  if(this.getBilllist().getSelectionModel().getCount()>0){
            		  this.getBilllist().getSelectionModel().deselectAll();  
            	  }
            	  if(this.getReceiptslist().getSelectionModel().getCount()>0){
            		  this.getReceiptslist().getSelectionModel().deselectAll();  
            	  }
            	  if(this.getInstumentdetailslist().getSelectionModel().getCount()>0){
            		  this.getInstumentdetailslist().getSelectionModel().deselectAll();  
            	  }
            	  if(this.getBillreceivablelist().getSelectionModel().getCount()>0){
            		  this.getBillreceivablelist().getSelectionModel().deselectAll();  
            	  }
            	  if(this.getAllbillslist().getSelectionModel().getCount()>0){
            		  this.getAllbillslist().getSelectionModel().deselectAll();  
            	  }
            	  
            	  tabStructure.down("#instumentdetailscontainer").setDisabled(true);
            	  tabStructure.down("#billreceivablecontainer").setDisabled(true);
            	  tabStructure.down("#allbilllistcontainer").setDisabled(true);
            	  tabStructure.down("#paymentReceiptSetttlementcontainer").setDisabled(true);
            	  tabStructure.setActiveTab(tabStructure.down("#listcontainer"));
              },
              resetProgressTracker : function(){
            	  var structure = this.getAdjustmentstructure();
            	  var manageSettlementCurrency =  structure.down("#manageSettlementCurrency");
            	  manageSettlementCurrency.setReadOnly(false);
            	  var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");
            	  var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
            	  var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
            	  var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");
            	  var progresstracker4 = adjustmentprogresstracker.down("#progresstracker4");
            	  var progresstracker5 = adjustmentprogresstracker.down("#progresstracker5");
            	  progresstracker1.reset();
            	  progresstracker1.updateText('');
            	  progresstracker2.reset();
            	  progresstracker2.updateText('');
            	  progresstracker3.reset();
            	  progresstracker3.updateText('');
            	  progresstracker4.reset();
            	  progresstracker4.updateText('');
            	  progresstracker5.reset();
            	  progresstracker5.updateText('');
              },
              updateProgressTracker : function(){
            	  var $this = this;
            	  Ext.defer(function() {
            		  $this.resetProgressTracker();
            		  var structure = $this.getAdjustmentstructure();
            		  var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");
            		  var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
            		  progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
            		  progresstracker1.textEl.addCls("inProgressCss-progress-text");
            		  progresstracker1.updateText("Step 1 In Progress");
            	  }, 1500, this);
              },
              getViewBillReceivablePaybleAdjustmentView : function(grid,record){
             	 var $this=this;
             	 var billHeaderId = record.get("billHeaderId");
             	 var raiseBillCategory = record.get("raiseBillCategory");
             	 var formWindow = $this.getReceiptandpaymentgridwindow();
             	 if (!formWindow) {
             		 Ext.widget('receiptandpaymentgridwindow');
             		 formWindow = $this.getReceiptandpaymentgridwindow();
             	 }
             	 var bindingStore = this.getStore('feeandpayment.common.BillSettlementDetails');
             	 var listGrid=$this.getReceiptAndPaymentGrid();
    	            var paginationStore = listGrid.getDockedItems()[1].items.items[0];
             	 listGrid.bindStore(bindingStore);
             	 paginationStore.bindStore(bindingStore);
             	 var store = listGrid.getStore();
             	 store.getProxy().extraParams = {
             		 billHeaderId: billHeaderId,
             		 raiseBillCategory:raiseBillCategory
             	 };
             	 store.load();
             	 
             	 formWindow.show();
              },
              findBillReceivableByStudentId: function(){
            	  $this=this;
            	  var adjustmentstructure = $this.getAdjustmentstructure();
            	  var adjustmenttabstructure = adjustmentstructure.down('adjustmenttabstructure');
            	  var studentNameValues = adjustmenttabstructure.down('#studentNameId');
            	  var receiptCurrency =  adjustmenttabstructure.down('#receiptCurrency').getValue();
            	  var values = studentNameValues.getValue();
            	  if(!isNullOrEmpty(values))
            	  {
            		  var locations = [];
            		  for(var i=0; i<values.length; i++){
            			  locations.push(values[i].data.id);
            		  }
            		  var grid = this.getAllbillslist();
            		  var allBillsListStore = grid.getStore();
            		  allBillsListStore.getProxy().extraParams = {
            			  billedUserType: 'STUDENT',
            			  id:'',
            			  adjustmentType:'Bill Receivable',
            			  showAllSettlement:'All',
            			  idList:locations.join(),
            			  currencyId:receiptCurrency,
            			  limit:1000

            		  };
            		  this.resetPageSetting(allBillsListStore);
            		  allBillsListStore.load();
            	  }
              },
              getViewBillReceivablePaybleFeeHeadDetailsView : function(grid,record){
            	  var $this=this;
            	  var billreceivable = this.getBillreceivablelist();
            	  var structure = this.getAdjustmentstructure();
            	  var form = structure.down('adjustmentfilters');
            	  var thirdParty =  form.down("#thirdParty");
            	  var sponsors =  form.down("#sponsors");
            	  var applicant =  form.down("#applicant");
            	  var userId =  form.down("#userId");
            	  var student =  form.down("#student");
            	  var id=0;
            	  var billedUserType=null;
            	  if(!thirdParty.isHidden()){
            		  id = thirdParty.getValue();
            		  billedUserType ="THIRD PARTY";

            	  }else if(!sponsors.isHidden()){
            		  id = '';
            		  //billedUserType = getFeeAndPaymentCommonTranslation('SPONSOR_TYPE');
            		  billedUserType ="STUDENT";

            	  }else if(!applicant.isHidden()){
            		  id = applicant.getValue();
            		  billedUserType ="APPLICANT";

            	  }else if(!userId.isHidden()){
            		  id = userId.getValue();
            		  billedUserType ="USER";  

            	  }else if(!student.isHidden()){
            		  id = student.getValue();
            		  billedUserType ="STUDENT";
            	  }
            	  var value = form.down("#adjustmentFor").getValue();
            	  var showAllSettlement = form.down("#showAllSettlementId").getValue();
            	  var adjustment = form.down("#adjustment").getValue();
            	  var adjustmentType;

            	  switch(showAllSettlement){
            	  case 'ALL' :{
            		  showAllSettlement = 'All'
            			  break;
            	  }
            	  case 'FULLY_SETTELED' :{
            		  showAllSettlement = 'settled'
            			  break;
            	  }
            	  case 'NOT_FULLY_SETTELED' :{
            		  showAllSettlement = 'Pending'
            			  break;
            	  }
            	  }
            	  var billHeaderId = record.get("billHeaderId");
            	  var formWindow = $this.getFeeheaddetailswindow();
            	  if (!formWindow) {
            		  Ext.widget('feeheaddetailswindow');
            		  formWindow = $this.getFeeheaddetailswindow();
            	  }
            	  var gridStore = formWindow.down('grid').getStore();

            	  gridStore.getProxy().extraParams = {
            		  billHeaderIds: billHeaderId,
            		  billedUserType: billedUserType,
            		  id:id,
            		  adjustmentType:'Bill Receivable',
            		  showAllSettlement:showAllSettlement,
            	  };
            	  gridStore.load();
            	  formWindow.show();
              },
              loadBillStore:function(store,userType,userId,billNo){
            	  store.getProxy().extraParams = {
                       userId: userId,
                       userType:userType
                   };
              },
              loadReceiptStore:function(store,userType,userId,receiptNo){
            	  store.getProxy().extraParams = {
                      userId: userId,
                      userType:userType
                  };
              },
              loadPaymentStore:function(store,userType,userId,paymentNo){
            	  store.getProxy().extraParams = {
                      userId: userId,
                      userType:userType
                  };            	  
              },
              fnpChangeAcademyLocationEvent:function(obj,record){
           	   var $this = this;
           	   var formLayout = $this.getAdjustmentFilters();
           	   var studentNameCombo= formLayout.down('#student');
           	   var thirdPartyNameCombo= formLayout.down('#thirdParty');
           	   var sponsorsNameCombo= formLayout.down('#sponsors');
           	   var applicantNameCombo= formLayout.down('#applicant');
           	   var userIdNameCombo= formLayout.down('#userId');
           	   var academyLocationId = formLayout.down("#fnpBrandCampusItemId").getValue();
           	   
           	   studentNameCombo.reset();
           	   thirdPartyNameCombo.reset();
           	   sponsorsNameCombo.reset();
           	   applicantNameCombo.reset();
           	   userIdNameCombo.reset();
           	   var alids=[];

           	   if(obj.hidden!=true){
           		   var alids=[];
           		   if(record.length>0){
           			   if(Ext.isObject(record[0])){
           				   alids.push(record[0].get('id'));
           			   }
           			   else{
           				   alids.push(record[0]);	
           			   }
           		   }else{
           			   alids = $this.getCurrentAcademyLocation();
           		   }  
           	   }else{
           		   alids = $this.getCurrentAcademyLocation(); 
           	   }
           	
           	   var studentNameComboStore = studentNameCombo.getStore();
           	   studentNameComboStore.getProxy().extraParams = {
           		   academyLocationIds: alids
           	   };
           	   studentNameComboStore.load();
              	   
           	   var thirdPartyNameComboStore = thirdPartyNameCombo.getStore();
           	   thirdPartyNameComboStore.getProxy().extraParams = {
           		   academyLocationIds: alids
           	   };
           	   thirdPartyNameComboStore.load();

           	   var sponsorsNameComboStore = sponsorsNameCombo.getStore();
           	   sponsorsNameComboStore.getProxy().extraParams = {
           		   academyLocationIds: alids
           	   };
           	   sponsorsNameComboStore.load();

           	   var applicantNameComboStore = applicantNameCombo.getStore();
           	   applicantNameComboStore.getProxy().extraParams = {
           		   academyLocationIds: alids
           	   };
           	   applicantNameComboStore.load();

           	   var userIdNameComboStore = userIdNameCombo.getStore();
           	   userIdNameComboStore.getProxy().extraParams = {
           		   academyLocationIds: alids
           	   };
           	   userIdNameComboStore.load();
              },
              
              fnpChangeAcademyLocationEventNew:function(obj,record){
              	   var $this = this;
              	   var formLayout = $this.getAdjustmenttabstructure();
              	   var studentNameCombo= formLayout.down('#studentNameId');
              	   var academyLocationId = formLayout.down("#fnpMultiBrandCampusAdjustmentItemId").getValue();
              	   
              	   studentNameCombo.reset();

              	   if(obj.hidden!=true){
             		   var alids=[];
                 	   if(record.length>0){
                 		   for (var i in record) {
                 			   if(Ext.isObject(record[i])){
                 				   alids.push(record[i].get('id'));
                 			   }
                 			   else{
                 				   alids.push(record[i]);	
                 			   }
                 		   }
                 	   }else{
                 		   alids = $this.getCurrentAcademyLocation();
                 	   }  
             	   }else{
             		   alids = $this.getCurrentAcademyLocation(); 
             	   }
             	   if(isArray(alids)){
             		   alidsValue =  alids.join(); 
             	   }else{
             		   alidsValue = alids;
             	   }
             	   
             	   var studentNameComboStore = studentNameCombo.getStore();
             	   studentNameComboStore.getProxy().extraParams = {
             		   academyLocationIds: alidsValue
             	   };
             	   studentNameComboStore.load();
              	   
              	 },
              
            //************ disableAcademyLocationPivileges****************  
              disableAcademyLocationPivileges: function(form,permissionsMap) {
           	   var associatedAcadLocationIds = new Array();
           	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
           	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
           	   var fnpMultiBrandCampusName = form.down('#fnpBrandCampusItemId');
           	   if(form.down('#fnpMultiBrandCampusAdjustmentItemId')!=null){
           	   var fnpMultiBrandCampusName = form.down('#fnpMultiBrandCampusAdjustmentItemId');
           	   }
           	   fnpMultiBrandCampusName.setVisible(false);
           	   Ext.each(permissionList, function(privilege) {	
           		   if (privilege === 'MAP_ACADEMY_LOCATIONS') {
           			   if(!isNullOrEmpty(fnpMultiBrandCampusName)){
           				   fnpMultiBrandCampusName.setVisible(true);
           			   }        		
           		   }
           	   });
           	   
           	     } ,
              //******************Disable for Radio button Permission ****************************************
          	disableSettlementCurrencyPivileges: function(form,permissionsMap) {
             	var associatedAcadLocationIds = new Array();
         		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
         		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
         		var manageSettlementCurrencyRadioGroup = form.down('#manageSettlementCurrency');
         		manageSettlementCurrencyRadioGroup.setVisible(false);
             	Ext.each(permissionList, function(privilege) {	
             		if (privilege === 'SETTLEMENT_WITH_MULTICURRENCY') {
                 		if(!isNullOrEmpty(manageSettlementCurrencyRadioGroup)){
                 			manageSettlementCurrencyRadioGroup.setVisible(true);
                 		}        		
                 	}
             	});
              },
              loadGridStoreFaculty: function(gridItemId, url, params) {
                  var this$ = this;
                  var personProfile = this.getContentPanel();
                  var grid=null;
                  
                  Ext.ComponentQuery.query('facultyprofile').forEach(function(entry) {
      			    if(entry.isHidden() == false){
      			    	var tabPanel=entry.down('tabpanel');
      			    	grid=tabPanel.activeTab.down('grid');
      			    }
      			    
      			});
                  
//                  var facutyProfile =  Ext.ComponentQuery.query('facultyprofile')[0]
//                      var facProfile = facutyProfile.down('tabpanel')
//                    var grid=facProfile.activeTab.down('grid');

                  if (grid) {
                  	var store = grid.getStore();
                      store.getProxy().api.read = url;
                      store.getProxy().extraParams = params;
                  	 if(portalId == 2){
              			 setTimeout(function(){
              			var check=grid.selModel.view.selModel.mode=='MULTI';
              			 var gridColumns=grid.columns;
         	 				 var length = gridColumns.length;
         	 				 if(length != null && length != ""){
         	 					 for(var i = 0; i < length; i++){
         	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount' || gridColumns[i].dataIndex=='receiptStatus'){
         	 							 gridColumns[i].destroy();
         	 						 }
         	 					 }
         	 					store.load({ 
         	                 	callback: function(record, operation, success) {
         	                 		if (record.length > 0) {
         	                 			for(var i in record){
         	                 				if (record[i].data.whetherDisplayTotal != false) {
         	                 					this$.toggleGridSummaryRow(grid,true); 
         	                 				}
         	                 			}
         	                 		}else{
         	                 			this$.toggleGridSummaryRow(grid,false);
         	                 		}
         	                 	}
         	                 });
         	 				} 
         	 				},300);
         	 				 
              			 
              		 } if(portalId == 1){

              			 var gridColumns=grid.columns;
         	 				 var length = gridColumns.length;
         	 				 var academyLocationId = this.getCurrentAcademyLocation();
    				   
         	 			 Ext.Ajax.request({
    			    		  method: "GET",
    			    		  type: 'rest',
    			    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
    			    		  params:{
    			    			  academyLocationId:academyLocationId
    			    		  },
    			    		  success: function(response) {
    			    			  if(response){
    			    				  result=response.responseText;	
    			    			  }
    			    	    		  if(result=="false"){
    			    	 				 var gridColumns=grid.columns;
    			    	 				 var length = gridColumns.length;
    			    	 				 if(length!=null && length!=""){
    			    	 					 for(var i=0; i<length; i++){
    			    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
    			    	 							 gridColumns[i].setVisible(false);
    			    	 						 }
    			    	 					 }
    			    	 				 }
    			    	 			  }else{
    			    	 				 var gridColumns=grid.columns;
    			    	 				 var length = gridColumns.length;
    			    	 				 if(length!=null && length!=""){
    			    	 					 for(var i=0; i<length; i++){
    			    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
    			    	 							 gridColumns[i].setVisible(true);
    			    	 						 }
    			    	 					 }
    			    	 				 }
    			    	    	  }
    			    		  }
    			    	  });
         	 		
              			 store.load({ 
                           	callback: function(record, operation, success) {
                           		if (record.length > 0) {
                           			for(var i in record){
                           					this$.toggleGridSummaryRow(grid,true); 
                           			}
                           		}else{
                           			this$.toggleGridSummaryRow(grid,false);
                           		}
                           	}
                           });
              		 
              		 }
                  	 else{
              			 store.load({ 
                           	callback: function(record, operation, success) {
                           		if (record.length > 0) {
                           			for(var i in record){
                           				if (record[i].data.whetherDisplayTotal != false) {
                           					this$.toggleGridSummaryRow(grid,true); 
                           				}
                           			}
                           		}else{
                           			this$.toggleGridSummaryRow(grid,false);
                           		}
                           	}
                           });
              		 }
                      
                      
                  }
          },
          disableSettleWithCheckBoxPrivileges: function(form,permissionsMap) {
        	  var me = this;
        	  var associatedAcadLocationIds = new Array();
        	  associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
        	  var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        	  var settleWithCheckBox = form.down('#settleWithCheckBoxId');
        	  settleWithCheckBox.setVisible(false);
        	  Ext.each(permissionList, function(privilege) {	
        		  if (privilege === 'SETTLE_WITH_CHECKBOX') {
        			  if(!isNullOrEmpty(settleWithCheckBox)){
        				  //settleWithCheckBox.setVisible(true);
        				  me.isVisibleSettleWithCheckBox=true;
        			  }        		
        		  }
        	  });
          },
          getCalForBalanceAmtOfSettleWithReceiptOrPayment : function(obj){
        	  var form = this.getAdjustmentstructure(),
        	  adjustment = form.down("#adjustment").getValue(),
        	  manageSettlementCurrency = form.down('#manageSettlementCurrency').getValue(),
        	  settedValue = parseFloat(obj.getValue()) || 0,
        	  grid = obj.ownerCt.grid,
        	  store = grid.getStore(),
        	  rowIndex = grid.getRowIndexes(),
        	  records = store.getAt(rowIndex),
        	  totalBalanceAmount =parseFloat(records.get('totalBalanceAmount')) || 0,
        	  receiptPaymentAmount = grid.ownerCt.down("#receiptPaymentBalanceAmountId");

        	  if(manageSettlementCurrency.currencyType==true){
        		  var receipt_payment_amount_value =  parseFloat(receiptPaymentAmount.getValue()) || 0;
        		  if(settedValue > receipt_payment_amount_value || settedValue > totalBalanceAmount){
        			  Ext.defer(function() {
        				  records.set('amountToBeAdjusted',0);
        			  }, 50, this);
        			  showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('AMOUNT_TO_SETTLE_CANNOT_BE_GREATER_THAN_AVAILABLE_MOUNT'));//Please select a record
        		  }else{
        			  var newvalue = receipt_payment_amount_value - settedValue;
        			  newvalue = Ext.util.Format.round(newvalue, 2).toFixed(2);
        			  receiptPaymentAmount.setValue(newvalue);
        			  var totalBalanceAmountForBill = totalBalanceAmount - settedValue;
        			  totalBalanceAmountForBill = Ext.util.Format.round(totalBalanceAmountForBill, 2).toFixed(2);
        			  records.set('totalBalanceAmount', totalBalanceAmountForBill);
        		  }
        	  }else{/*
        		  var receipt_bill = receiptPaymentAmount.getValue();
        		  var arrValue = receipt_bill.split(' ');
        		  var receipt_payment_amount_value=arrValue[1];
        		  if(settedValue > receipt_payment_amount_value || settedValue > convertedBalanceAmount){
        			  Ext.defer(function() {
        				  records.set('amountToBeAdjusted',0);
        			  }, 50, this);
        			  showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('AMOUNT_TO_SETTLE_CANNOT_BE_GREATER_THAN_AVAILABLE_MOUNT'));//Please select a record
        		  }else{
        			  receipt_bill_FinalAmount= parseFloat(receipt_payment_amount_value) - settedValue;
        			  receiptPaymentAmount.setValue(arrValue[0]+" "+(receipt_bill_FinalAmount).toFixed(2));
        			  var totalconvertedBalanceAmountForBill = convertedBalanceAmount-settedValue;
        			  records.set('convertedBalanceAmount',totalconvertedBalanceAmountForBill);
        		  }
        	  */}
        	  selectionModel = grid.getSelectionModel();
        	  selectedRow = selectionModel.getSelection();
        	  amountToBeAdjusted = selectedRow[0].get('amountToBeAdjusted');
        	  if(amountToBeAdjusted <= 0 || settedValue > recipt_bill_amount_value || settedValue > totalBalanceAmount){
        		  selectionModel.deselect(selectedRow);
        	  }
        	  settedValue = 0;
         },
          viewPaymentRecievedHistoryGrid: function(informationType, windowXType, gridItemId, url) {

        	  var this$ = this;
        	  var personProfile = this$.getContentPanel();

        	  if(gridItemId == "receiptgridforapplicant"){
        		  grid=this.getReceiptgridforapplicant();
        	  }
        	  else{
        		  grid = this.getPaymentreceivedhistorygrid();
        	  }

        	  if (grid.getSelectionModel().getCount() > 0) {
        		  var record = grid.getSelectionModel().getSelection()[0];
        		  var formWindow = Ext.widget(windowXType);
        		  formWindow.show();
        		  var params = {
        				  receiptHeaderId : record.get('id'),
        				  screen:'profile',
        		  };
        		  var gridWindow = formWindow.down('grid');

        		  var portalId = this.getCurrentLoggedPortalId();
        		  setTimeout(function(){ 
        			  Ext.Ajax.request({
        				  method: "GET",
        				  type: 'rest',
        				  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
        				  params:{
        					  academyLocationId:academyLocationId
        				  },
        				  success: function(response) {
        					  if(response){
        						  result=response.responseText;	
        					  }
        					  if(result=="false"){
        						  var gridColumns=gridWindow.columns;
        						  var length = gridColumns.length;
        						  if(length!=null && length!=""){
        							  for(var i=0; i<length; i++){
        								  if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
        									  gridColumns[i].setVisible(false);
        								  }
        							  }
        						  }
        					  }else{
        						  var gridColumns=grid.columns;
        						  var length = gridColumns.length;
        						  if(length!=null && length!=""){
        							  for(var i=0; i<length; i++){
        								  if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
        									  gridColumns[i].setVisible(true);
        								  }
        							  }
        						  }
        					  }
        				  }
        			  });
        		  },300);
        		  var store = gridWindow.getStore();
        		  store.getProxy().api.read = url;
        		  store.getProxy().extraParams = params;

        		  store.load();

        	  } else {
        		  showWarningMessage(getPersonModuleTranslation('PAYMENT_RECEIVED_HISTORY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        	  }
          },
          getSavePaymentListDetails:function(obj){
        	  var $this = this;
        	  adjustmentStructure = $this.getAdjustmentstructure(),
        	  adjustmenttabstructure = adjustmentStructure.down('adjustmenttabstructure'),
        	  adjustmentfilters =  adjustmentStructure.down("#adjustmentfilters"),
        	  receiptAvailableAmount = adjustmenttabstructure.down('#receiptPaymentBalanceAmountId'),
        	  adform = this.getAdjustmentstructure(),
        	  manageSettlementCurrency = adform.down('#manageSettlementCurrency').getValue(),
        	  adjustmentFor = adform.down("#adjustmentFor").getValue(),
        	  receiptGrid = $this.getReceiptslist(),
        	  paymentslistGrid =  $this.getPaymentslistforreceiptsettlement();

        	  var receiptAvailableAmountValue = parseFloat(receiptAvailableAmount.getValue()),
        	  selectedPaymentslistGridRec = paymentslistGrid.selModel.getSelection();

        	  if(selectedPaymentslistGridRec.length>0){
        		  var storeLength = paymentslistGrid.getStore().getRange(),amountadjusted = 0,count = 0;
        		  for(var i in storeLength){
        			  if(storeLength[i].get("amountToBeAdjusted")!=undefined && storeLength[i].get("amountToBeAdjusted")>0){
        				  count = count+1; 
        			  }
        		  }	  
        		  if(selectedPaymentslistGridRec.length == count){
        			  var selectedReceiptGrid = receiptGrid.selModel.getSelection()[0],
        			  newValue=0,adjustmentDataObj = {};
        			  for(var i in selectedPaymentslistGridRec){
        				  if(selectedPaymentslistGridRec[i].data.amountToBeAdjusted!= undefined){
        					  newValue = parseFloat(newValue) + parseFloat(selectedPaymentslistGridRec[i].data.amountToBeAdjusted);
        				  }
        			  }
        			  var voucherMode = selectedReceiptGrid.data.voucherMode;
        			  if(voucherMode=='BANK'){
        				  adjustmentDataObj.voucherMode = 'BANK';
        			  }else{
        				  adjustmentDataObj.voucherMode = 'CASH';
        			  }
        			  adjustmentDataObj.voucherType = 'RECEIPT';
        			  adjustmentDataObj.adjustedAmount = newValue;
        			  adjustmentDataObj.adjustmentDate = Ext.Date.format(new Date(), CONSTANTS.SUBMIT_DATE_FORMAT);
        			  adjustmentDataObj.balanceAmount = receiptAvailableAmountValue;
        			  adjustmentDataObj.receiptHeader = $this.getIdValueJson(selectedReceiptGrid.data.id);
        			  adjustmentDataObj.adjustmentFor = adjustmentFor;
        			  var totalAdjustedAmount = 0, feeAdjustmentDetails=[];

        			  for(var i in selectedPaymentslistGridRec){
        				  if(selectedPaymentslistGridRec[i].data.amountToBeAdjusted!=undefined){
        					  totalAdjustedAmount = totalAdjustedAmount + selectedPaymentslistGridRec[i].data.amountToBeAdjusted;
        					   feeAdjustmentDetails.push({
        						  "voucherType":'RECEIPT',
        						  "voucherMode":'CASH',
        						  "adjustedAmount":selectedPaymentslistGridRec[i].data.amountToBeAdjusted,
        						  "balanceAmount":selectedPaymentslistGridRec[i].data.totalBalanceAmount,
        						  "adjustmentDate":Ext.Date.format(new Date(), CONSTANTS.SUBMIT_DATE_FORMAT),
        						  "paymentHeader":$this.getIdValueJson(selectedPaymentslistGridRec[i].data.id)
        					  });
        					  adjustmentDataObj.feeAdjustmentDetails=feeAdjustmentDetails;
        				  }
        			  }
        			  var receiptPaymentBalanceAmount = adjustmenttabstructure.down('#receiptPaymentBalanceAmountId'),
        			  receiptPaymentBalanceAmountValue = parseFloat(receiptPaymentBalanceAmount.getValue());
        			  if(receiptPaymentBalanceAmountValue>=0){
        				  var submitData = Ext.encode(adjustmentDataObj);
        				  var submitUrl = SERVERURL.SAVE_RECEIPT_SETTELMENT_WITH_PAYMENT;
        				  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        				  Ext.Ajax.request({
        					  url: submitUrl,
        					  jsonData: submitData,
        					  method: 'POST',
        					  success: function(response) {
        						  showSuccessMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('ADJUSTMENT_SUCCESS'));
        						  $this.getResetForCashAndBank();
        						  Ext.getBody().unmask();
        						  $this.setProgressTracker(3);
        						  $this.getInitialFormView();
        						  $this.updateProgressTracker();  
        						  obj.setDisabled(false);
        						  if($this.getAdjustmentform()){
        							  var adjustmentform = $this.getAdjustmentform();
        							  adjustmentform.down('panel').scrollBy(0,1);
        							  adjustmentform.down('panel').scrollBy(0,-1);
        						  }
        					  },
        					  failure:function() {
        						  obj.setDisabled(false);
        					  }
        				  });
        			  }else{
        				  showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('PLEASE_SETTLE_TOTAL_AMOUNT'));
        			  }
        		  }else{
        			  showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_ALL_UPDATED_RECORDS'));//Please select a record
        		  }

        	  }else{
        		  showWarningMessage(getFeeAndPaymentCommonTranslation('ADJUSTMENT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
        	  }
        	  paymentslistGrid.getSelectionModel().deselectAll();
        	  obj.setDisabled(false);
          },
          setMaxAmountLimitForPaymentList:function(obj){
        	  var adjustmenttabstructure = this.getAdjustmentstructure().down('adjustmenttabstructure');
        	  var paymentListGrid = this.getPaymentslistforreceiptsettlement();
        	  var store = paymentListGrid.getStore();
        	  var rowIndex = paymentListGrid.getRowIndexes();
        	  var records = store.getAt(rowIndex);
        	  var totalBalanceAmount = records.get('balanceAmount');      		 
        	  var value = parseFloat(obj.getValue()) || 0;
        	  if(!isNullOrEmpty(value)){
        		  var receiptPayment_amount = adjustmenttabstructure.down('#receiptPaymentBalanceAmountId');
        		  var receiptPayment_amount_value = parseFloat(receiptPayment_amount.getValue()) || 0;
        		  var newAmount = Ext.util.Format.round(receiptPayment_amount_value + value, 2).toFixed(2);
        		  receiptPayment_amount.setValue(newAmount);
        		  var totalBalanceAmountForPayment = Ext.util.Format.round(totalBalanceAmount + value, 2).toFixed(2);
        		  records.set('balanceAmount', totalBalanceAmountForPayment);
        	  }            	  
          },
          getViewReceiptPaymentAdjustment : function(grid,record){
        	  var form = this.getAdjustmentstructure(),
        	  adjustmentType = form.down("#adjustment").getValue();

        	  var formWindow = this.getReceiptandpaymentviewadjustmentwindow();
        	  if (!formWindow) {
        		  Ext.widget('receiptandpaymentviewadjustmentwindow');
        		  formWindow = this.getReceiptandpaymentviewadjustmentwindow();
        	  }
        	  var store = formWindow.down("#paymentViewGrid").getStore();
        	  store.getProxy().extraParams = {
        		  paymentHeaderId: record.data.id
        	  };
        	  store.load();
        	  formWindow.show();
          },
          loadPaymentGridForReceiptSettlement: function () {
        	    var me = this,
        	    structure = me.getAdjustmentstructure();

        	    if (!structure) return;
        	    var form = structure.down('adjustmentfilters'),
        	    tabStructure = structure.down('adjustmenttabstructure'),
        	    thirdParty = form.down("#thirdParty"),
        	    sponsors = form.down("#sponsors"),
        	    applicant = form.down("#applicant"),
        	    userId = form.down("#userId"),
        	    student = form.down("#student"),
        	    manageSettlementCurrency = form.down("#manageSettlementCurrency"),
        	    bill = form.down("#billNoId"),
        	    receipt = form.down("#receiptNoId"),
        	    payment = form.down("#paymentNoId"),
        	    id = 0,
        	    billedUserType = null;

        	    if (manageSettlementCurrency) {
        	        manageSettlementCurrency.setReadOnly(true);
        	    }

        	    if (thirdParty && !thirdParty.isHidden()) {
        	        id = thirdParty.getValue();
        	        billedUserType = "THIRD PARTY";
        	    } else if (sponsors && !sponsors.isHidden()) {
        	        id = sponsors.getValue();
        	        billedUserType = "SPONSOR";
        	    } else if (applicant && !applicant.isHidden()) {
        	        id = applicant.getValue();
        	        billedUserType = "APPLICANT";
        	    } else if (userId && !userId.isHidden()) {
        	        id = userId.getValue();
        	        billedUserType = "USER";
        	    } else if (student && !student.isHidden()) {
        	        id = student.getValue();
        	        billedUserType = "STUDENT";
        	    }

        	    var showAllSettlementField = form.down("#showAllSettlementId"),
        	    adjustmentField = form.down("#adjustment"),
        	    instrumentNumberField = form.down("#instrumentNumberId");

        	    var showAllSettlement = showAllSettlementField ? showAllSettlementField.getValue() : null,
        	    adjustment = adjustmentField ? adjustmentField.getValue() : null,
        	    instrumentNumberFieldValue = instrumentNumberField ? instrumentNumberField.getValue() : null,
        	    multiCurrencyValue = null;

        	    if (manageSettlementCurrency && manageSettlementCurrency.getValue()) {
        	        multiCurrencyValue = manageSettlementCurrency.getValue().currencyType || null;
        	    }

        	    switch (showAllSettlement) {
        	        case 'ALL':
        	            showAllSettlement = 'All';
        	            break;
        	        case 'FULLY_SETTELED':
        	            showAllSettlement = 'settled';
        	            break;
        	        case 'NOT_FULLY_SETTELED':
        	            showAllSettlement = 'Pending';
        	            break;
        	        default:
        	            showAllSettlement = 'All';
        	    }

        	    var paymentHeaderId = (payment && payment.getValue) ? payment.getValue() : null;
        	    var paymentAdjustmentstore = me.getStore('feeandpayment.adjustment.PaymentAdjustmentWithReceiptStore');
        	    if (paymentAdjustmentstore && paymentAdjustmentstore.getProxy) {
        	        var proxy = paymentAdjustmentstore.getProxy();
        	        if (proxy && proxy.extraParams) {
        	            proxy.extraParams = {
        	                billedUserType: billedUserType,
        	                id: id,
        	                showAllSettlement: showAllSettlement,
        	                paymentHeaderId: paymentHeaderId,
        	                whetherCreatedCurrency: multiCurrencyValue,
        	                limit: -1
        	            };
        	        }
        	        paymentAdjustmentstore.load();
        	    }
        	}
});
