/**
 *  @author Deepika Parmar
 *
 */
Ext.define('Academia.controller.feeandpayment.coursefeedefinition.CourseFeeDefinitionController', {
	extend: 'Academia.controller.base.BaseController',
	models:['feeandpayment.coursefeedefinition.CourseFeeDefinitionListModel','feeandpayment.coursefeedefinition.FeeHeadConfigurationGridModel','feeandpayment.coursefeedefinition.CourseRepetitionFeeConfigurationGridModel'],
	stores: ['course.CourseDepartmentStore','course.CourseByDepartmentIdStore','feeandpayment.coursefeedefinition.CourseFeeDefinitionListStore',
		'feeandpayment.coursefeedefinition.FeeHeadConfigurationGridStore','feeandpayment.coursefeedefinition.FeeHeadConfigurationSubHeadStore',
		'feeandpayment.coursefeedefinition.FeeHeadConfigurationCostCenterStore','feeandpayment.coursefeedefinition.FeeHeadConfigurationRuleStore',
		'feeandpayment.coursefeedefinition.FeeHeadConfigurationRefundableRuleStore','feeandpayment.coursefeedefinition.FeeHeadCourseDepartmentStore',
		'feeandpayment.coursefeedefinition.FeeHeadCourseNameStore','feeandpayment.coursefeedefinition.FeeHeadCourseFeeTypeStore',
		'feeandpayment.coursefeedefinition.FeeHeadGroupingFeeHeadStore','feeandpayment.coursefeedefinition.FeeHeadCourseNameStore',
		'coursetransaction.studymaterialdistribution.CoursesAllSmartSearch','department.DepartmentAcademyLocationWiseStore','feeandpayment.coursefeedefinition.CourseFeeSubHeadStore',
		'feeandpayment.coursefeedefinition.CourseFeeDefinitionListStore','feeandpayment.coursefeedefinition.CourseRepetitionFeeConfigurationGridStore','feeandpayment.coursefeedefinition.CourseRepetitionStore',
		'feeandpayment.coursefeedefinition.CourseFeeCopyEnrollmentStore','feeandpayment.coursefeedefinition.FeeHeadConfigurationDiscountRuleStore','department.DepartmentAcademyLocationWiseStore',
		'feeandpayment.coursefeedefinition.CourseFeeDefinitionListStore','feeandpayment.coursefeedefinition.ImportCourseFeeDefTemplateForStore','feeandpayment.coursefeedefinition.ImportCourseFeeDefinitionStore',
		'feeandpayment.coursefeedefinition.ImportCourseFeeDefGridStore','program.CourseFeeDefinationProgramStore','program.CourseFeeDefinationBatchStore','program.CourseFeeDefinationPeriodStore','common.AcademicTermStore',
		],
	views: ['feeandpayment.coursefeedefinition.CourseFeeDefinitionStructure','feeandpayment.coursefeedefinition.CourseFeeDefinitionSearchTab',
		'feeandpayment.coursefeedefinition.CourseFeeDefinitionSearchFilter','feeandpayment.coursefeedefinition.CourseFeeDefinitionSeachGrid',
		'feeandpayment.coursefeedefinition.CourseFeeDefinitionDetailStructure','feeandpayment.coursefeedefinition.FeeHeadConfigurationTab',
		'feeandpayment.coursefeedefinition.FeeHeadConfigurationFilter','feeandpayment.coursefeedefinition.FeeHeadConfigurationGrid',
		'feeandpayment.coursefeedefinition.CourseRepetitionConfigurationTab','feeandpayment.coursefeedefinition.FeeSubHeadGridWindow','feeandpayment.coursefeedefinition.CourseRepetitionCopyWindow',
		'feeandpayment.coursefeedefinition.CourseEnrollmentConfigurationStructure','feeandpayment.coursefeedefinition.CourseEnrollnmentSection','feeandpayment.coursefeedefinition.CourseRepitionFeeConfigurationGrid',
		'feeandpayment.coursefeedefinition.CourseEnrollmentConfigurationEditStructure','feeandpayment.coursefeedefinition.CourseEnrollnmentEditSection','feeandpayment.coursefeedefinition.CourseRepitionFeeConfigurationEditGrid',
		'feeandpayment.coursefeedefinition.ImportCourseFeeDefinitionTab','feeandpayment.coursefeedefinition.ImportCourseFeeDefinitionUploadForm','feeandpayment.coursefeedefinition.ImportCourseFeeDefinitionDownloadForm',
		'feeandpayment.coursefeedefinition.ImportCourseFeeDefinitionGrid','UploadOptionRadioGroup'
		],
	config: {
		COURSE_FEE_HEAD_CONFIGURATION_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSE_FEE_HEAD_CONFIGURATION_PRIVILEGES'),
		COURSE_FEE_DEFINATION_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSE_FEE_DEFINITION_PRIVILEGES'),
		COURSE_REPETITION_CONFIGURATION_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSE_REPETITION_CONFIGURATION_PRIVILEGES'),
	},           
     refs: [
    {
   	  ref: 'contentPanel',
	  selector: 'contentPanel'
    },{
    	 ref:'coursefeedefinitionstructure',
    	 selector:'coursefeedefinitionstructure'
     },{
    	 ref:'coursefeedefinitionseachgrid',
    	 selector:'coursefeedefinitionseachgrid'
     },{
    	 ref:'coursefeedefinitionsearchfilter',
    	 selector:'coursefeedefinitionsearchfilter'
     },{
    	 ref:'coursefeedefinitionsearchtab',
    	 selector:'coursefeedefinitionsearchtab'
     },{
    	 ref:'coursefeedefinitiondetailstructure',
    	 selector:'coursefeedefinitiondetailstructure'
     },{
    	 ref:'courserepetitionconfigurationtab',
    	 selector:'courserepetitionconfigurationtab'
     },{
    	 ref:'feeheadconfigurationgrid',
    	 selector:'feeheadconfigurationgrid'
     },{
    	 ref:'feeheadconfigurationfilter',
    	 selector:'feeheadconfigurationfilter'
     },{
    	 ref:'feesubheadgridwindow',
    	 selector:'feesubheadgridwindow'
     },{
    	 ref:'feeheadconfigurationtab',
    	 selector:'feeheadconfigurationtab'
     },{
    	 ref:'courserepetitioncopywindow',
    	 selector:'courserepetitioncopywindow'
     },{
    	 ref:'courseenrollmentconfigurationstructure',
    	 selector:'courseenrollmentconfigurationstructure'
     },{
    	 ref:'courseenrollnmentsection',
    	 selector:'courseenrollnmentsection'
     },{
    	 ref:'courserepitionfeeconfigurationgrid',
    	 selector:'courserepitionfeeconfigurationgrid'
     },{
    	 ref:'courseenrollmentconfigurationeditstructure',
    	 selector:'courseenrollmentconfigurationeditstructure'
     },{
    	 ref:'courseenrollnmenteditsection',
    	 selector:'courseenrollnmenteditsection'
     },{
    	 ref:'courserepitionfeeconfigurationeditgrid',
    	 selector:'courserepitionfeeconfigurationeditgrid'
     },{
    	 ref:'importcoursefeedefinitionuploadform',
    	 selector:'importcoursefeedefinitionuploadform'
     },{
    	 ref:'importcoursefeedefinitiondownloadform',
    	 selector:'importcoursefeedefinitiondownloadform'
     },{
    	 ref:'importcoursefeedefinitiongrid',
    	 selector:'importcoursefeedefinitiongrid'
     },{
    	 ref:'uploadoptionradiogroup',
    	 selector:'uploadoptionradiogroup'
     }],
     init: function() {
    	 this.isCourseFeeDefinitionMapping;
    	 this.control({
    		 'feeheadconfigurationfilter':{
    			 render:function(grid){

    				 var academyLocationsIds = this$.getCurrentAcademyLocation();
    				 var form = this.getFeeheadconfigurationfilter();
    				 var courseCode = form.down("#feeheadCourseDepartmentId");
    				 var store = courseCode.getStore();
    				 store.getProxy().extraParams = {
    					 academyLocationsIds: academyLocationsIds
    				 };
    				 store.load();
    				
    			 },
    			 afterrender:function(formWin){
    				 var $this=this,allowblankFalse = '<span class="required" style="color:red"> *</span>';
    		   		 formWin.down("#feeheadCourseDepartmentId").setFieldLabel(getCommonTranslation('COURSE_DEPARTMENT')+allowblankFalse);
    		   		 formWin.down("#feeheadCourseCodeNameId").setFieldLabel(getCommonTranslation('COURSE_CODE_NAME')+allowblankFalse);
    		   		 formWin.down("#feeheadDefinationNameId").setFieldLabel(getCommonTranslation('FEE_DEFINATION_NAME')+allowblankFalse);
    		   		formWin.down("#feeheadTypeId").setFieldLabel(getCommonTranslation('FEE_TYPE')+allowblankFalse);
    		   		formWin.down("#feeHeadId").setFieldLabel( getCommonTranslation('FEE_HEAD')+allowblankFalse);
    		   		 
    				 Ext.Ajax.request({
    					method: "GET",
    					type: 'rest',
    					url: SERVERURL.ORGINFOLOADREQUEST,
    					success: function(response, action) {
    						var data = JSON.parse(response.responseText);
    						$this.isCourseFeeDefinitionMapping = data.isCourseFeeDefinitionMapping;
    						if(!isNullOrEmpty(data.isCourseFeeDefinitionMapping) && data.isCourseFeeDefinitionMapping == false){ 
    						    var billDateField = formWin.down("#billingDate");
    						    var academicTerm =  formWin.down("#academicTermId");
    						
    						    academicTerm.allowBlank = false;
    						    billDateField.allowBlank = false;
    						    billDateField.setFieldLabel( getCommonTranslation('BILLING_DATE')+allowblankFalse);
    		   		            academicTerm.setFieldLabel( getCommonTranslation('ACADEMIC_TERM')+allowblankFalse);
    		   		        
    						}else{
    						      formWin.down("#academicTermId").setVisible(false);
    						      formWin.down("#billingDate").setVisible(false);
    						      formWin.down("#billingDate").reset();
    						}
    					}
    				}); 
    			 }
    		 },
    		 'feeheadconfigurationfilter customcombobox#feeheadTypeId':{
    			 select: function(obj, record) {
    				 var $this = this,form =  this.getFeeheadconfigurationfilter();
    				 if(obj.getValue()=='CREDIT_BASED'){
    					 form.down("#academicTermId").setVisible(false);
    					 $this.setAllowBlank(form.down("#academicTermId"),true);
    					 form.down("#billingDate").setVisible(false);
    					 $this.setAllowBlank(form.down("#billingDate"),true);
    					 form.down("#billingDate").reset();
    				 }else if(obj.getValue()=='FIXED' && $this.isCourseFeeDefinitionMapping==false){
    					 form.down("#academicTermId").setVisible(true);
    					 $this.setAllowBlank(form.down("#academicTermId"),false);
    					 form.down("#billingDate").setVisible(true);
    					 $this.setAllowBlank(form.down("#billingDate"),false);
    					 form.down("#billingDate").setValue(new Date());
    				 }
    			 }
    		 },
    	  'feeheadconfigurationfilter customcombobox#feeheadCourseDepartmentId': {
  			  select: function(obj, record) {
  				  var form = this.getFeeheadconfigurationfilter();
  				  var courseCode = form.down("#feeheadCourseCodeNameId");
  				  var id = record[0].get("id");
  				  if(id > 0){
  					  var store = courseCode.getStore();
  					  store.getProxy().extraParams = {
  						departmentId: id
  					  };
  					  store.load();
  				  }
  			  }
   		  },
   		'feeheadconfigurationfilter customcombobox#feeheadCourseCodeNameId': {
   			render: function(obj, record) {
   				var form = this.getFeeheadconfigurationfilter();
   				var courseCode = form.down("#feeheadCourseCodeNameId");
   				var store = courseCode.getStore();
   				store.getProxy().extraParams = {
   					departmentId: null
   				};
   				store.load();
   			}
 		  },
    	  'coursefeedefinitionseachgrid': {
    	    	   cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
    	    		   var columnName = View.getGridColumns()[ColIdx].dataIndex;
    	               var $this =this;
    	               if(columnName == "subHeadCount"){
    	      			   if(e.target.tagName=='A'){
    	      				   this.getFeeCourseSubHeadGridWindow(View,record);
    	      			   }
    	      		   }
    	    	     },
    		  render:function(grid){
    			  this.doAccessControlValidation(grid, this.getCOURSE_FEE_DEFINATION_PERMISSION());
    		  },
    		  afterrender : function(grid){
    			  var me = this;
    			  setTimeout(function(){
    				  me.addDataGridConfigButton(grid, me.getCOURSE_FEE_DEFINATION_PERMISSION());
    			  },1500);
    		  }
    	    	   },
    		 'coursefeedefinitionseachgrid button#btnAdd': {
    			 click:function(){
   				  this.openCourseFeeDefintaionConfigureTab("AddView");
   			  }
    		 },
			'coursefeedefinitionseachgrid button#btnDelete': {
    			 click:function(){
   				  this.getDeleteCourseFeeDefinitionConfigure();
   			  }
    		 },
    		 'coursefeedefinitionsearchtab':{
    			 render: function(grid){
    				 var academyLocationsIds = this$.getCurrentAcademyLocation();
    				 var form = this.getCoursefeedefinitionsearchfilter();
    				 var courseCode = form.down("#courseDepartment");
    				 var store = courseCode.getStore();
    				 store.getProxy().extraParams = {
    					 academyLocationsIds: academyLocationsIds
    				 };
    				 store.load();
    			 }
    		 },
    		  'coursefeedefinitionseachgrid button#btnEdit': {
    			 click:function(){
   				  this.openEditCourseFeeDefintaionConfigureTab();
   			  }
    		 },
    		 'coursefeedefinitionseachgrid button#btnView': {
    			 click:function(){
   				  this.ViewCourseFeeDefintaionConfigureTab();
   			  }
    		 },
    	  'coursefeedefinitionsearchfilter customcombobox#courseDepartment': {
  			  select: function(obj, record) {
  				  var form = this.getCoursefeedefinitionsearchfilter();
  				  var courseCode = form.down("#courseCodeNameId");
  				  var id = record[0].get("id");
  				  if(id > 0){
  					  var store = courseCode.getStore();
  					  store.getProxy().extraParams = {
  						departmentId: id
  					  };
  					  store.load();
  				  }
  			  }
   		  },
   		  'coursefeedefinitionsearchfilter button#searchBtn':{
   			  click:function(){
   				  var filterForm = this.getCoursefeedefinitionsearchfilter();
   				filterForm.down('#searchBtn').setDisabled(true);
   				var form = this.getCoursefeedefinitionsearchfilter().getForm();
   				var formValues = form.getValues();
   				var grid = this.getCoursefeedefinitionseachgrid();
   				var store= grid.getStore();
   				store.getProxy().extraParams= {
   					courseDepartmentID:formValues.department,
   				    courseID:formValues.courseCodeName,
   				}
   				
   				this.resetPageSetting(store);
   				store.load({
						callback:function(record){
							filterForm.down('#searchBtn').setDisabled(false);
						}
						});
   				grid.getSelectionModel().deselectAll();
   				grid.config.searchFilterForm = filterForm;
   			  }
   		  },
   		 'coursefeedefinitionsearchfilter button#resetBtn':{
  			  click:function(){
  				var form = this.getCoursefeedefinitionsearchfilter().getForm();
  				form.reset();
  			  }
  		  },
   		  'feeheadconfigurationgrid button#btnAdd': {
   			  click: function(){
   				 var grid = this.getFeeheadconfigurationgrid();
				 this.onFeeHeadGridAddClick(1, grid);
				 this.disableFeeConfigurationSaveResetBtnByPriivilege(grid,this.getCOURSE_FEE_HEAD_CONFIGURATION_PERMISSION());
				 
				 
				
   				
   			  }
   		  },
   		 'feeheadconfigurationgrid button#submitBtn': {
  			  click: function(){
  				this.saveFeeHeadConfigurationDetail();
  			  }
  		  },
  		 'feeheadconfigurationgrid button#resetBtn': {
 			  click: function(){
 				 var feeHeadFilter = this.getFeeheadconfigurationfilter();
 				
 				var grid = this.getFeeheadconfigurationgrid();
 				var form = feeHeadFilter.getForm();
 				var feeheadCourseDepartment = form.findField('feeheadCourseDepartment');
 				var feeheadCourseCodeName = form.findField('feeheadCourseCodeName');
 				var feeheadDefinationName = form.findField('feeheadDefinationName');
 				var feeheadType = form.findField('feeheadType');
 				var feeHead = form.findField('feeHead');
 				
 				var record = grid.getSelectionModel().getSelection();
 				if(record.length == 1){
 					record[0].set("serialNo", record[0].data.serialNo);
 					record[0].set("feeHead", '');
 					record[0].set("amountOrWeightage", '');
 					record[0].set("costCentre", '');
 					record[0].set("isRefundable", '');
 					record[0].set("rule", '');
 					record[0].set("isAddDeleteRow", true);
 					record[0].set("discountRule", '');
 					record[0].set("discountCostCentre", '');
 					record[0].set("payableDiscountFeeHead", '');
 					record[0].set("discountType", '');
 				}
 				else{
 	    		   showWarningMessage(getFeeAndPaymentCommonTranslation('FEE_HEAD_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
 	    	   }
 			  }
 		  },
 		  'coursefeedefinitionsearchfilter button[itemId=resetBtn]': {
 			  click: function(){
 				  var academyLocationsIds = this$.getCurrentAcademyLocation();
 				  var form = this.getCoursefeedefinitionsearchfilter();
 				  var departmentStore=form.down('#courseDepartment').getStore();
 				  departmentStore.getProxy().extraParams={
 					  academyLocationsIds: academyLocationsIds,
 					  'qry': ''
 				  };
 				  departmentStore.load(); 
 				  var store=form.down('#courseCodeNameId').getStore();
 				  store.getProxy().extraParams={
 					  'qry': ''
 				  };
 				  store.load();
 				  form.getForm().reset(); 

 			  }
         },
  		
  		'feeheadconfigurationgrid':{
  			 cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
  				 
  				 var columnName = grid.getGridColumns()[cellIndex].dataIndex;
  				 if (e.target.tagName == 'DIV' &&  columnName == "addButton" ) {
  					 
  					serialNo = grid.getStore().getCount();
  					this.onFeeHeadGridAddClick(serialNo+1,grid);
  				 }
  				 else if (e.target.tagName == 'DIV' && columnName == "deleteButton") {
  					 var feeheadconfigurationgridStructure = this.getFeeheadconfigurationgrid();
  					 var titleMessage = getCommonTranslation('SUBHEAD_CONFIGURATION');
  					 this.deleteFeeHeadConfigurationDetails(grid,record,feeheadconfigurationgridStructure,titleMessage,rowIndex);
  					 /*grid.getStore().removeAt(rowIndex);
  					 var storeCount = grid.getStore().getCount();*/
  				 }
  			   },
  			   afterrender:function(grid){
  				 this.disableFeeConfigurationButtonByPriivilege(grid, this.getCOURSE_FEE_HEAD_CONFIGURATION_PERMISSION());
  			   }
  		    },
  		  'courserepetitionconfigurationtab button[itemId=btnAdd]':{
     		 click:function(){
     			//var grid = this.getFeeheadconfigurationgrid();
     			 var feeHeadFilter = this.getFeeheadconfigurationfilter();
     			var feeHeadFilterValues = feeHeadFilter.getForm().getValues();
     			var courseFeeDefinitionId = feeHeadFilterValues.feeDefinitionId;
     			 this.showRepetitionCopyWindow(courseFeeDefinitionId);
     			//this.disableFeeConfigurationButtonByPriivilege(grid, this.getCOURSE_REPETITION_CONFIGURATION_PERMISSION());
     			 }
  		 
     	 },
     	 'courserepetitionconfigurationtab button[itemId=btnEdit]':{
     		 click : function(){
     			 var $this = this;
     			 var tab = $this.getCourserepetitionconfigurationtab();
     			 var grid = tab.down('#courserepetitionconfigurationGridId');
     			 if(grid.getSelectionModel().getCount() > 0){
     				 var record = grid.getSelectionModel().getSelection()[0]; 
     				 this.showUpdateCourseEnrollment(record);
     			 }else
     			 {
     				showWarningMessage(getFeeAndPaymentCommonTranslation('COURSE_ENROLLMENT_CONFIGURATION'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
     			 }
     		 }
     	 },
     	'courserepetitionconfigurationtab button[itemId=btnDelete]':{
    		 click : function(){
    			 var $this = this;
    			 var tab = $this.getCourserepetitionconfigurationtab();
    			 var grid = tab.down('#courserepetitionconfigurationGridId');
    			 var store = grid.getStore();
    			 var addBtn = grid.down('#btnAdd');
    			 if(grid.getSelectionModel().getCount() > 0){
     				var records = grid.getSelectionModel().getSelection();
     				var id = records[0].get("id");
     				Ext.Ajax.request({
     					method: "DELETE",
     					type: 'rest',
     					url: SERVERURL.COURSE_REPETITION_FEE_ENROLLNMENT_DELETE+'?id='+id,
     					headers: {
     						'Content-Type': 'application/json'
     					},
     					success: function(form, action) {
     						var data = Ext.JSON.decode(form.responseText);
     						if(data==0){
     							showWarningMessage(getCommonTranslation('ALERT'),getErrorTranslation('CAMPAIGN_MASTER_DEPENDENCY_EXIST_ON_DELETE'));
     						}else{
     							store.load({
         							callback:function(record){
         								if(record.length == 0){
         									addBtn.enable();
         								}
         								for(var count=0;count<record.length;count++){
        	 								if(record[count].data.repAppOnFutureEnrollment){
        	 									addBtn.disable(true)
        	 								}
        	 							}
         							}
         						});
         						showSuccessMessage(getFeeAndPaymentCommonTranslation('COURSE_REPETITION_CONFIGURATION'), getCommonTranslation('SUCCESS'));
     						}
     						
     					}
     				});
     			
    			 }else
    			 {
    				showWarningMessage(getFeeAndPaymentCommonTranslation('COURSE_ENROLLMENT_CONFIGURATION'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
    			 }
    		 }
    	 },
     	 'courserepetitioncopywindow button[itemId=btnCancel]':{
			 click : this.closeRepetitionCopyWindow
		 },
		 'courserepetitioncopywindow button[itemId=btnContinue]':{
			 click : function(){
				 this.showAddCourseEnrollment();
				 this.closeRepetitionCopyWindow();
			 }
		 },
		 'courserepitionfeeconfigurationgrid':{
			 afterrender: function(grid1){
				 var $this = this;
		    	  var grid = $this.getCoursefeedefinitionseachgrid();
		    	  var form = this.getCourseenrollnmentsection();
		    	  var courseFeeType = form.down('#courseFeeType');
		    	  // $this.openCourseFeeDefintaionConfigureTab();
		    	  grid1.on('beforeedit', function(editor, e) {
		    		  if (e.colIdx === 1){
			    	  	 	 return false;
			    	  	 }
			    	  });
		    	  if(grid.getSelectionModel().getCount() > 0){
		    		   var record = grid.getSelectionModel().getSelection()[0]; 
		    		   var id = record.get("id");
		    		   var editUrl = SERVERURL.PATH_FIND_BY_ID_COURSE_FEE_DEFINITION;
		    		   Ext.Ajax.request({
		    			   method: "GET",
		    			   type: 'rest',
		    			   url: editUrl,
		    			   params: {
		    				   id: id
		    			   },
		    			   success: function(f, action) {
		    				   var data = Ext.JSON.decode(f.responseText);
		    				   if(data.courseFeeSubHeads.length>0){
		    					   grid1.getStore().removeAll();
		    					   var ObjModel = [];
		    					   var serialNo = 0;
		    					   for(i=0;i< data.courseFeeSubHeads.length; i++){
		    						   serialNo = serialNo+1;
		    						   var subHeadData = data.courseFeeSubHeads[i];
		    						   var courseRepitionFeeConfGridModel = new Academia.model.feeandpayment.coursefeedefinition.CourseRepetitionFeeConfigurationGridModel();
		    						   courseRepitionFeeConfGridModel.set("serialNo", serialNo);
		    						   courseRepitionFeeConfGridModel.set("feeHead", subHeadData.feeHead.id);
		    						   courseRepitionFeeConfGridModel.set("amountOrWeightage", subHeadData.amountOrWeightage);
		    						 //  courseRepitionFeeConfGridModel.set("discountRule", subHeadData.discountRule.id);
		    						 //  courseRepitionFeeConfGridModel.set("costCentre", subHeadData.costCentre.id);
		    						 //  courseRepitionFeeConfGridModel.set("isRefundable", subHeadData.isRefundable);
		    						 //  courseRepitionFeeConfGridModel.set("rule", subHeadData.rule.id);
		    						   
		    						   if(subHeadData.costCentre!=null)
			    						   courseRepitionFeeConfGridModel.set("costCentre", subHeadData.costCentre.id);
			    						   else
			    							   courseRepitionFeeConfGridModel.set("costCentre",'');
		    						   
									if(subHeadData.isRefundable!=null)
			    						   courseRepitionFeeConfGridModel.set("isRefundable", subHeadData.isRefundable);
			    						   else
			    							   courseRepitionFeeConfGridModel.set("isRefundable","");
			       						
			    						   if(subHeadData.rule!=null)
			    						   courseRepitionFeeConfGridModel.set("rule", subHeadData.rule.id);
			    						   else
			    						   courseRepitionFeeConfGridModel.set("rule", '');
			    						   
			    						   if(subHeadData.discountRule!=null)
				    						   courseRepitionFeeConfGridModel.set("discountRule", subHeadData.discountRule.id);
				    						  else
				    							   courseRepitionFeeConfGridModel.set("discountRule",'');
			    						   
			    						   if(subHeadData.payableDiscountFeeHead!=null && subHeadData.payableDiscountFeeHead.id!=null)
			        						   courseRepitionFeeConfGridModel.set("payableDiscountFeeHead", subHeadData.payableDiscountFeeHead.id);
			        						   else
			        							   courseRepitionFeeConfGridModel.set("payableDiscountFeeHead",'');
			    						   
			    						   if(subHeadData.discountCostCentre!=null && subHeadData.discountCostCentre.id!=null)
			        						   courseRepitionFeeConfGridModel.set("discountCostCenter", subHeadData.discountCostCentre.id);
			        						   else
			        							   courseRepitionFeeConfGridModel.set("discountCostCenter",'');
			    						   
			    						   if(subHeadData.discountType!=null)
			        						   courseRepitionFeeConfGridModel.set("discountType", subHeadData.discountType);
			        						   else
			        							   courseRepitionFeeConfGridModel.set("discountType",'');
			    						   
		    						   courseRepitionFeeConfGridModel.set("id", subHeadData.id);
		    						   courseRepitionFeeConfGridModel.set("isAddDeleteRow", true);
		    						   ObjModel.push(courseRepitionFeeConfGridModel);
		    					   }
		    					   courseFeeType.setValue(data.courseFeeType);
		    					   grid1.getStore().loadRawData(ObjModel, true);
		    					   
		    					   //   grid1.getStore().load();

		    				   }
		    			   }
		    		   });
		    	  }
			 }
			
		 },
		 'courserepitionfeeconfigurationgrid button#submitBtn': {
			  click: function(){
				this.saveCourseRepetitionFeeConfigurationDetail();
			  }
		  },
		  'courserepitionfeeconfigurationgrid button#resetBtn': {
 			  click: function(){
 				// var feeHeadFilter = this.getFeeheadconfigurationfilter();
 				
 				var grid = this.getCourserepitionfeeconfigurationgrid();
 				var record = grid.getSelectionModel().getSelection();
 				if(record.length == 1){
 					record[0].set("serialNo", record[0].data.serialNo);
 					//record[0].set("feeHead", '');
 					record[0].set("amountOrWeightage", '');
 					record[0].set("costCentre", '');
 					record[0].set("isRefundable", '');
 					record[0].set("rule", '');
 					record[0].set("discountRule", '');
 					record[0].set("discountCostCenter", '');
 					record[0].set("payableDiscountFeeHead", '');
 					record[0].set("discountType", '');
 					//record[0].set("isAddDeleteRow", true);
 				}
 				else{
 	    		   showWarningMessage(getFeeAndPaymentCommonTranslation('FEE_HEAD_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
 	    	   }
 			  }
 		  },
 		 'courserepitionfeeconfigurationeditgrid button#submitBtn': {
			  click: function(){
				this.updateCourseRepetitionFeeConfigurationDetail();
			  }
		  },
		  'courserepitionfeeconfigurationeditgrid button#resetBtn': {
 			  click: function(){
 				
 				var grid = this.getCourserepitionfeeconfigurationeditgrid();
 				var record = grid.getSelectionModel().getSelection();
 				if(record.length == 1){
 					record[0].set("serialNo", record[0].data.serialNo);
 					record[0].set("amountOrWeightage", '');
 					record[0].set("costCentre", '');
 					record[0].set("isRefundable", '');
 					record[0].set("rulePrintName", '');
 					record[0].set("discountRule", '');
 					record[0].set("discountCostCentre", '');
 					record[0].set("payableDiscountFeeHead", '');
 					record[0].set("discountType", '');
 				}
 				else{
 	    		   showWarningMessage(getFeeAndPaymentCommonTranslation('FEE_HEAD_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
 	    	   }
 			  }
 		  },
 		
 		
 		 'courserepetitionconfigurationtab':{
 			 afterrender : function(){
 				 var courseRepetitionPanel = this.getCourserepetitionconfigurationtab();
 				 var grid = courseRepetitionPanel.down('grid');
 				 var addBtn = grid.down('#btnAdd');
 				 var feeHeadFilter = this.getFeeheadconfigurationfilter();
 				 var feeHeadFilterValues = feeHeadFilter.getForm().getValues();
 				 var courseRepetitionStore = grid.getStore();
 				 courseRepetitionStore.getProxy().extraParams = {
 					 feeDefinitionId:  feeHeadFilterValues.feeDefinitionId
 				 };
 				 courseRepetitionStore.load({
 					 callback:function(record){
 						if(record.length >0){
 							if(record[0].data.enrollmentNo == 2  && record[0].data.isForAllEnrollment ==  true ){
 								addBtn.disable(true)
 							}
 							for(var count=0;count<record.length;count++){
 								if(record[count].data.repAppOnFutureEnrollment){
 									addBtn.disable(true)
 								}
 							}
 						} 
 					 }
 				 });

 			 },	
 		 },
 		'courserepetitionconfigurationtab grid': {
	    	   cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
	    		   var columnName = View.getGridColumns()[ColIdx].dataIndex;
	               var $this =this;
	               var repetitionGrid = true;
	               if(columnName == "subHeadCount"){
	      			   if(e.target.tagName=='A'){
	      				   this.getFeeCourseSubHeadGridWindow(View,record,repetitionGrid);
	      			   }
	      		   }
	    	     },
	    	     render:function(grid){
	    			  this.doAccessControlValidation(grid, this.getCOURSE_REPETITION_CONFIGURATION_PERMISSION());
	    		  }
 		},
	    	   'courseenrollmentconfigurationstructure':{
	    		   afterrender : function(){
	    			   var $this = this;
	    			   var courseRepetitionPanel = this.getCourserepetitionconfigurationtab();
	    			   var grid = courseRepetitionPanel.down('grid');
	    			   var courseRepetitionStore = grid.getStore();
	    			   var rowCount = courseRepetitionStore.totalCount;
	    			   var courseEnrollnmentSection = this.getCourseenrollnmentsection();
	    			   var enrollmentNoField = courseEnrollnmentSection.down('#enrollNoItemId');
	    			   var  forAllEnrollmentCheck= courseEnrollnmentSection.down('#forAllEnrollment');
	    			   var  repAppOnFutureEnrollment= courseEnrollnmentSection.down('#repAppOnFutureEnrollment');
	    			   if(rowCount==0)
	    				   {
	    				   enrollmentNoField.setValue(2);
	    				   repAppOnFutureEnrollment.setVisible(false);
	    				   }
	    			   else if(rowCount>0)
	    			   {
	    				   var a = rowCount+2;
	    				   enrollmentNoField.setValue(a);
	    			   }
	    			   var enrollmentNoValue = enrollmentNoField.getValue();
	    			   if(enrollmentNoValue > 2){
	    				   forAllEnrollmentCheck.disable(true);
	    			   }
	    			   var associatedAcadLocationIds = new Array();
	    		  		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
	    		  		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getCOURSE_REPETITION_CONFIGURATION_PERMISSION());
	    		  		forAllEnrollmentCheck.setVisible(false);
	    		  		Ext.each(permissionList, function(privilege) {
	    		  			if(privilege === "FOR_ALL_ENROLLMENTS"){
	    		  				if(!isNullOrEmpty(forAllEnrollmentCheck)){
	    		  					forAllEnrollmentCheck.setVisible(true);
	    		        		}
	    		  			}
	    		  		});
	    		   }
	    	   },
	    	   'courserepetitioncopywindow':{
	    		   afterrender : function(formWin){
	    			   var $this = this;
	    			   var courseRepetitionPanel = this.getCourserepetitionconfigurationtab();
	    			   var grid = courseRepetitionPanel.down('grid');
	    			   var courseRepetitionStore = grid.getStore();
	    			   var rowCount = courseRepetitionStore.totalCount;
	    			//   var courseEnrollnmentSection = this.getCourseenrollnmentsection();
	    			   var enrollmentNoField = formWin.down('#enrollmentNoId');
	    			   if(rowCount==0)
	    				   {
	    				   enrollmentNoField.setValue(2);
	    				   }
	    			   else if(rowCount>0)
	    			   {
	    				   var a = rowCount+2;
	    				   enrollmentNoField.setValue(a);
	    			   }
	    		   }
	    	   },
	    	   'courserepetitioncopywindow button[itemId=btnSubmit]':{
	  			 click : this.saveRepetitionCopyWindow
	  		 },
             'feeheadconfigurationfilter radiogroup[itemId=whetherMandatoryToPayId]':{
            	 change:function(cb,nv,ov){
            		 var filter = this.getFeeheadconfigurationfilter();
            		 var allowPartialPay = filter.down('#allowPartialPaymentId');
            		 var partialPayMob =  filter.down('#allowPartialPaymentMobileAppId');
            		 if(nv.whetherMandatoryToPay==true){
            			 allowPartialPay.items.items[0].setValue(false);
            			 allowPartialPay.items.items[1].setValue(true);
            			 allowPartialPay.setDisabled(true);
            			 partialPayMob.setDisabled(true);
            		 }
            		 else{
            			 allowPartialPay.setDisabled(false);
            			 partialPayMob.setDisabled(false);
            		 }
            	 }
             },
             'importcoursefeedefinitiontab radiogroup[itemId=importDownloadgroupIds]':{
          	   change  : function(obj,newValue,oldValue){
          		   var form = obj.up('importcoursefeedefinitiontab');	 
          		   var value = obj.getValue();
          		   var downloadform = form.down('importcoursefeedefinitiondownloadform');
          		   var uploadform = form.down('importcoursefeedefinitionuploadform');
          		   var importGrid = form.down('importcoursefeedefinitiongrid');

          		   downloadform.setVisible(false);
          		   uploadform.setVisible(false);
          		   importGrid.setVisible(false);

          		   if(value.downloadUploadTemplate=='forDownloadTemplate'){
          			 downloadform.setVisible(true);
          		   }else if(value.downloadUploadTemplate=='forUploadTemplate'){
          			   var uploadoptionradiogroupform  = this.getUploadoptionradiogroup();
          			   uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
          				   isUploadAll: false
          			   });
          			  uploadform.setVisible(true);
          			  importGrid.setVisible(true);
          		   }
          	   }
             },
             'importcoursefeedefinitiondownloadform  multiselectcombofield[itemId=courseDepartmentItemId]':{
            	 change : function(obj, record) {
 					var form = this.getImportcoursefeedefinitiondownloadform();
 					var formValues = form.getValues();

 					var courseFeeDefinitionField = form.down("#courseFeeDefinitionItemId");
 					courseFeeDefinitionField.setDisabled(true);
 					courseFeeDefinitionField.reset();
 					courseFeeDefinitionField.clearAllDataFn();
 					var deptId = obj.getValue();
 					var deptIds = [];
 					for(var i in deptId){
 						if(Ext.isObject(deptId[i])){
 							deptIds.push(deptId[i].data.id);
 						}else{
 							deptIds.push(deptId[i]);
 						}
 					}
 					var deptIds = deptIds.join();
 					if(deptId.length>0){
 						courseFeeDefinitionField.setDisabled(false);
 						var academyLocationsIds = this$.getCurrentAcademyLocation();
 						var store = courseFeeDefinitionField.getStore();
 						store.getProxy().extraParams = {
 							courseDepartmentId : deptIds,
 							academyLocationsIds:academyLocationsIds
 						};
 						store.load();
 					}
 					form.getForm().checkValidity();
 				}
             },
             'importcoursefeedefinitiondownloadform  multiselectcombofield[itemId=courseFeeDefinitionItemId]': {
                 change :function(obj,record){
                	 var form = this.getImportcoursefeedefinitiondownloadform();
                	 var courseFeeDefination;
                     var courseFeeDefinationIds = form.down("#courseFeeDefinitionItemId").getValue();
                     var programStoreId = form.down("#programCodeName").getValue();
                     if(courseFeeDefinationIds && courseFeeDefinationIds.length == 1 && !Ext.isEmpty(courseFeeDefinationIds[0])){
            			 try{
            				 courseFeeDefination=Ext.pluck(Ext.pluck(courseFeeDefination, 'data'), 'id').join(',')
            			 }catch(e){
            				 courseFeeDefination=courseFeeDefinationIds.join(',')
            			 }
            			 
               		 }else if(courseFeeDefinationIds && courseFeeDefinationIds.length >1){
               			 try{
               				courseFeeDefination=Ext.pluck(Ext.pluck(courseFeeDefinationIds, 'data'), 'id').join(',')
            			 }catch(e){
            				 courseFeeDefination=courseFeeDefinationIds.join(',')
            			 }
               		 }
                     
                     var programStore = form.down("#programCodeName");
                     
                     programStore.getStore().getProxy().extraParams = {
                    	 courseFeeDefinationId:courseFeeDefination
                         
                     }
                     programStore.getStore().load();
                    // programStoreId.reset();
                    // programStoreId.getStore().load();
                 }
             },
             //test
             'importcoursefeedefinitiondownloadform  multiselectcombofield[itemId=programCodeName]': {
                 change :function(obj,record){
                	 var form = this.getImportcoursefeedefinitiondownloadform();
                	// var formValues = form.getValues();
                	 var courseFeeDefinationBatch;
                	// var programBatchPeriodId = form.down('#programBatchPeriodId');
                     var courseFeeDefinationProgIds = form.down("#programCodeName").getValue();
                     var BatchStoreId = form.down("#batchItemId").getValue();
                     if(courseFeeDefinationProgIds && courseFeeDefinationProgIds.length == 1 && !Ext.isEmpty(courseFeeDefinationProgIds[0])){
            			 try{
            				 courseFeeDefinationBatch=Ext.pluck(Ext.pluck(courseFeeDefinationBatch, 'data'), 'id').join(',')
            			 }catch(e){
            				 courseFeeDefinationBatch=courseFeeDefinationProgIds.join(',')
            			 }
            			 
               		 }else if(courseFeeDefinationProgIds && courseFeeDefinationProgIds.length >1){
               			 try{
               				courseFeeDefinationBatch=Ext.pluck(Ext.pluck(courseFeeDefinationProgIds, 'data'), 'id').join(',')
            			 }catch(e){
            				 courseFeeDefinationBatch=courseFeeDefinationProgIds.join(',')
            			 }
               		 }
                     
                     var BatchStore = form.down("#batchItemId")
                     
                     BatchStore.getStore().getProxy().extraParams = {
                    	 ProgramId:courseFeeDefinationBatch
                         
                     }
                     BatchStore.getStore().load();
                    // programStoreId.reset();
                    // programStoreId.getStore().load();
                 }
             },
             //test 2
             'importcoursefeedefinitiondownloadform  multiselectcombofield[itemId=batchItemId]': {
                 change :function(obj,record){
                	 var form = this.getImportcoursefeedefinitiondownloadform();
                	// var formValues = form.getValues();
                	 var courseFeeDefinationPeriod;
                	// var programBatchPeriodId = form.down('#programBatchPeriodId');
                     var courseFeeDefinationBatchIds = form.down("#batchItemId").getValue();
                     var PeriodStoreId = form.down("#periodId").getValue();
                     if(courseFeeDefinationBatchIds && courseFeeDefinationBatchIds.length == 1 && !Ext.isEmpty(courseFeeDefinationBatchIds[0])){
            			 try{
            				 courseFeeDefinationPeriod=Ext.pluck(Ext.pluck(courseFeeDefinationBatchIds, 'data'), 'id').join(',')
            			 }catch(e){
            				 courseFeeDefinationPeriod=courseFeeDefinationBatchIds.join(',')
            			 }
            			 
               		 }else if(courseFeeDefinationBatchIds && courseFeeDefinationBatchIds.length >1){
               			 try{
               				courseFeeDefinationPeriod=Ext.pluck(Ext.pluck(courseFeeDefinationBatchIds, 'data'), 'id').join(',')
            			 }catch(e){
            				 courseFeeDefinationPeriod=courseFeeDefinationBatchIds.join(',')
            			 }
               		 }
                     
                     var PeriodStore = form.down("#periodId")
                     
                     PeriodStore.getStore().getProxy().extraParams = {
                    	 batchId:courseFeeDefinationPeriod
                         
                     }
                     PeriodStore.getStore().load();
                    // programStoreId.reset();
                    // programStoreId.getStore().load();
                 }
             },
             'importcoursefeedefinitiondownloadform button[itemId=courseFeeDefinitionDownload]':{
            	 click:function(obj){
					 var $this = this;
					 var form =$this.getImportcoursefeedefinitiondownloadform().getForm();
					 var value = form.getValues();
					 var id = [];
					 var courseFeeDefinitionId = [];
					 var programId = [];
					 var batchIdJson=[];
					 var periodIdJson=[];
					 var templateFor=$this.getImportcoursefeedefinitiondownloadform().down("#templateFor");
                     if( value.courseDepartment.length > 0){
                    	 for( var i = 0; i < value.courseDepartment.length; i++) {
                    		 id.push(value.courseDepartment[i].data.id);
                    	 }
                     }
                     
                     var Ids = id.join(',');
                     
                     
                     var url;
                     if(templateFor.getValue()=="COURSE_FEE_DEFINITION_FIXED_BASED"){
                    	 url=SERVERURL.DOWNLOAD_TEMPLATE_COURSE_FEE_DEFINITION;
                     }else if(templateFor.getValue()=="COURSE_FEE_DEFINITION_CREDIT_BASED"){
                    	 url=SERVERURL.DOWNLOAD_TEMPLATE_COURSE_FEE_DEFINITION_CREDIT_BASED;
                     }else if(templateFor.getValue()=="BULK_COURSE_REPETITION_FEE_DEFINITON_CONFIGURATION"){
                    	 if( value.courseFeeDefinition.length > 0){
                    		 for( var i = 0; i < value.courseFeeDefinition.length; i++) {
                    			 courseFeeDefinitionId.push(value.courseFeeDefinition[i].data.id);
                    		 }
                    	 }
                    	 var courseFeeDefinitionIds = courseFeeDefinitionId.join(',');
                    	 url=SERVERURL.DOWNLOAD_TEMPLATE_COURSE_REPETITION_FEE_DEFINITION;
                     }
                     else if(templateFor.getValue()=="COURSE_FEE_DEFINITION_MAPPING"){
                    	 if( value.courseFeeDefinition.length > 0){
                    		 for( var i = 0; i < value.courseFeeDefinition.length; i++) {
                    			 courseFeeDefinitionId.push(value.courseFeeDefinition[i].data.id);
                    		 }
                    	 }
                    	 var courseFeeDefinitionIds = courseFeeDefinitionId.join(',');
                    	 if(value.programCodeName!=undefined){
                    	 if(value.programCodeName.length>0){
                    		 for( var i = 0; i < value.programCodeName.length; i++) {
                    			 if(value.programCodeName[0]!='')
                    			 programId.push(value.programCodeName[i].data.id);
                    		 } 
                    	 }
                    	 var programIdsForMap = programId.join(',');
                    	 }
                    	 
                    	 if(value.batchId!=undefined){
                        	 if(value.batchId.length>0){
                        		 for( var i = 0; i < value.batchId.length; i++) {
                        			 if(value.batchId[0]!='')
                        				 batchIdJson.push(value.batchId[i].data.id);
                        		 } 
                        	 }
                        	 var batchIdsForMapping = batchIdJson.join(',');
                        	 }
                    	 
                    	 if(value.period!=undefined){
                        	 if(value.period.length>0){
                        		 for( var i = 0; i < value.period.length; i++) {
                        			 if(value.period[0]!='')
                        				 periodIdJson.push(value.period[i].data.id);
                        		 } 
                        	 }
                        	 var periodIdsForMapping = periodIdJson.join(',');
                        	 }
                		 url=SERVERURL.PATH_DOWNLOAD_TEMPLATE_FOR_COURSE_FEE_DEFINITION_MAPPING;
                	 }
                     else if(templateFor.getValue()=="UPDATE_BULK_COURSE_REPETITION_FEE_DEFINITON"){
                    	 if( value.courseFeeDefinition.length > 0){
                    		 for( var i = 0; i < value.courseFeeDefinition.length; i++) {
                    			 courseFeeDefinitionId.push(value.courseFeeDefinition[i].data.id);
                    		 }
                    	 }
                    	 var courseFeeDefinitionIds = courseFeeDefinitionId.join(',');
                    	 url=SERVERURL.DOWNLOAD_TEMPLATE_UPDATE_COURSE_REPETITION_FEE_DEFINITION;
                     }
                     if(templateFor.getValue()=="BULK_COURSE_REPETITION_FEE_DEFINITON_CONFIGURATION"){
                    	 var csvForm = Ext.create('Ext.form.Panel'); 
	       				 csvForm.getForm().submit({
	       					 target: '_blank',
	       					 method:'POST',
	       					 params :{
	       						 access_token : Ext.Ajax.defaultHeaders.access_token,
	       						 deptIds : Ids,
	       						courseFeeDefinitionIds:courseFeeDefinitionIds
	       					 },
	       					 headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	       					 url: url,
	       					 standardSubmit :true
	       				 });
                    	 
                     }else if(templateFor.getValue()=="UPDATE_BULK_COURSE_REPETITION_FEE_DEFINITON"){
                        	 var csvForm = Ext.create('Ext.form.Panel'); 
    	       				 csvForm.getForm().submit({
    	       					 target: '_blank',
    	       					 method:'POST',
    	       					 params :{
    	       						 access_token : Ext.Ajax.defaultHeaders.access_token,
    	       						 deptIds : Ids,
    	       						courseFeeDefinitionIds:courseFeeDefinitionIds
    	       					 },
    	       					 headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
    	       					 url: url,
    	       					 standardSubmit :true
    	       				 });
                        	 
                         }
                     
                     else if(templateFor.getValue()=="COURSE_FEE_DEFINITION_MAPPING"){
                    	 var csvForm = Ext.create('Ext.form.Panel'); 
	       				 csvForm.getForm().submit({
	       					 target: '_blank',
	       					 method:'POST',
	       					 params :{
	       						 access_token : Ext.Ajax.defaultHeaders.access_token,
	       						 deptIds : Ids,
	       						courseFeeDefId:courseFeeDefinitionIds,
	       						programId:programIdsForMap,
	       						batchId:batchIdsForMapping,
	       						peridId:periodIdsForMapping
	       					 },
	       					 headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	       					 url: url,
	       					 standardSubmit :true
	       				 });
                    	 
                     }
                     else{
                    	 
                     
						var csvForm = Ext.create('Ext.form.Panel'); 
	       				 csvForm.getForm().submit({
	       					 target: '_blank',
	       					 method:'POST',
	       					 params :{
	       						 access_token : Ext.Ajax.defaultHeaders.access_token,
	       						 deptIds : Ids
	       					 },
	       					 headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	       					 url: url,
	       					 standardSubmit :true
	       				 });
            	 }
            	 }
             },
             'importcoursefeedefinitiondownloadform button#resetBtn':{
				   click:function(obj){
					   var $this = this;
					   var form = $this.getImportcoursefeedefinitiondownloadform();
					   var downloadBtn =form.down('#courseFeeDefinitionDownload');
					   var getForm = form.getForm();
					   getForm.reset();
					   var courseDeptField =form.down('#courseDepartmentItemId');
					   var courseFeeDefField =form.down('#courseFeeDefinitionItemId');
					   var templateFor =form.down('#templateFor');
					   courseFeeDefField.setVisible(false);
					   courseDeptField.setDisabled(true);
					   if(form.isValid()){
							downloadBtn.enable();
						}else{
							downloadBtn.disable();
						}
				   } 
			   
	 		   },
	 		   'importcoursefeedefinitiondownloadform customcombobox[itemId=templateFor]':{
	 			   change:function(obj,record){
	 				   var $this = this;
					   var form = $this.getImportcoursefeedefinitiondownloadform()
	 				   var value = obj.getValue();
	 				   var courseDeptField = obj.up().up().down('#courseDepartmentItemId');
	 				   var courseFeeDefField = obj.up().up().down('#courseFeeDefinitionItemId');
	 				   var programBatchPeriodId = form.down('#programBatchPeriodId');
	 				   
	 				  programBatchPeriodId.setVisible(false);
	 				   
	 				   if(value == 'COURSE_FEE_DEFINITION_FIXED_BASED'){
	 					   courseDeptField.setDisabled(false);
	 					   courseFeeDefField.setVisible(false);
	 					   courseFeeDefField.reset();
	 					   courseDeptField.reset();
	 					   courseFeeDefField.allowBlank=true;
	 				   }else if(value == 'COURSE_FEE_DEFINITION_CREDIT_BASED'){
	 					   courseDeptField.setDisabled(false);
	 					   courseFeeDefField.setVisible(false);
	 					   courseFeeDefField.reset();
	 					   courseDeptField.reset();
	 					   courseFeeDefField.allowBlank=true;
	 				   }else if(value == 'BULK_COURSE_REPETITION_FEE_DEFINITON_CONFIGURATION'){
	 					   courseDeptField.setDisabled(false);
	 					   courseFeeDefField.setVisible(true);
	 					   courseFeeDefField.reset();
	 					   courseDeptField.reset();
	 					  courseFeeDefField.allowBlank=false;
	 					  var allowblankFalse = '<span class="required" style="color:red"> *</span>';
	 					  courseFeeDefField.setFieldLabel(getFeeAndPaymentCommonTranslation('COURSE_FEE_DEFINITION')+allowblankFalse);
	 				   }
	 				  else if(value == 'UPDATE_BULK_COURSE_REPETITION_FEE_DEFINITON'){
	 					   courseDeptField.setDisabled(false);
	 					   courseFeeDefField.setVisible(true);
	 					   courseFeeDefField.reset();
	 					   courseDeptField.reset();
	 					  courseFeeDefField.allowBlank=false;
	 					  var allowblankFalse = '<span class="required" style="color:red"> *</span>';
	 					  courseFeeDefField.setFieldLabel(getFeeAndPaymentCommonTranslation('COURSE_FEE_DEFINITION')+allowblankFalse);
	 				   }
	 				   else if(value == 'COURSE_FEE_DEFINITION_MAPPING'){
	 					  programBatchPeriodId.setVisible(true);
	 					 courseFeeDefField.setVisible(true);
	 					courseDeptField.setDisabled(false);
	 				   }
	 				   else {
	 					   courseFeeDefField.setVisible(true);
	 					  courseFeeDefField.allowBlank=true;
	 					   var allowblankFalse = '<span class="required" style="color:red"> *</span>';
	 					   courseFeeDefField.setFieldLabel(getFeeAndPaymentCommonTranslation('COURSE_FEE_DEFINITION')+allowblankFalse);
	 					   courseFeeDefField.setDisabled(true);
	 					   courseDeptField.setDisabled(false);
	 					   courseDeptField.reset();
	 					  courseFeeDefField.reset();
	 				   }
	 			   }
	 		   },
	 		   'coursefeedefinitionstructure':{
	 			   render:function(structure){
	 				   this.disableImportCourseFeeDefTab(structure, this.getCOURSE_FEE_DEFINATION_PERMISSION());
	 			   }
	 		   },
	 		  'importcoursefeedefinitionuploadform customcombobox[itemId=templateFor]':{
  				select: function(obj){
  					var $this = this;
  					var temForm = $this.getImportcoursefeedefinitionuploadform();
  					var tempFormValue=temForm.getForm().findField('importUtilityMasterId');
  					var grid = $this.getImportcoursefeedefinitiongrid();
  					var form = $this.getUploadoptionradiogroup();
  					var isUploadAll = form.items.items[0].getValue().isUploadAll;
  					var templateNameValue;
                       if(obj.getValue()=="COURSE_FEE_DEFINITION_FIXED_BASED"){
                          templateNameValue = "Bulk Course Fee Definition";
                       	$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Course Fee Definition');
                       }else if(obj.getValue()=="COURSE_FEE_DEFINITION_CREDIT_BASED"){
                    	   templateNameValue = "Bulk Course Fee Definition Credit Based";
                          	$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Course Fee Definition Credit Based');
                       }
                       else if(obj.getValue()=="COURSE_FEE_DEFINITION_MAPPING"){
                    	   templateNameValue = "Course Fee Definition Mapping";
                          	$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Course Fee Definition Mapping');
                       }
                       else if(obj.getValue()=="BULK_COURSE_REPETITION_FEE_DEFINITON_CONFIGURATION"){
                       	 templateNameValue = "Bulk Course Repetition Fee Definition";
                       	$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Course Repetition Fee Definition');
                       }
                       else if(obj.getValue()=="UPDATE_BULK_COURSE_REPETITION_FEE_DEFINITON"){
                         	 templateNameValue = "Update Bulk Course Repetition Fee Definition";
                         	$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Update Bulk Course Repetition Fee Definition');
                         }
                       
  					tempFormValue.getStore().load({
  						callback:function(record){
  							for(var i in record){
  								if(record[i].data.value == templateNameValue){
  									tempFormValue.setValue(record[i].data.id);
  									tempFormValue.setReadOnly(true);
  								}
  							}
  						}
  					});
  				}
  			},
  			'importcoursefeedefinitionuploadform button[itemId=SubmitBtn]':{
   				click: function(obj){
   					var temForm = obj.up('importcoursefeedefinitionuploadform');
   			    	var tempFormValue=temForm.getForm().findField('importUtilityMasterId').getRawValue();
   			    	var $this=this;
   			    	var grdStore;
   			    	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
       	            $this.getHashOfFile(temForm);
   		            setTimeout(function() {
   				    	temForm.getForm().submit({
   				    		method : 'POST',
   				    		url : submitUrl,
   				    		success : function(form, action){
   					        	showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
   				    		},
   				    		failure: function(form, action) {
      		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
   				    	    }
   				    	});
   		        	},1000);
   			    	Ext.defer(function() {
   			    		$this.loadCourseFeeDefLoaderGrid(tempFormValue);
   			    	}, 2000, this);
   					
   				}
   			},
   			'importcoursefeedefinitionuploadform button[itemId=resetBtn]':{
				click: function(obj){
					var $this=this;
					var temForm = $this.getImportcoursefeedefinitionuploadform();
					temForm.down('#uploadFileField').reset();
					temForm.down('#templateFor').reset();
					temForm.down('#moduleName').reset();
					var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
					uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
						isUploadAll: false
					});
					temForm.getForm().isValid();
					var tempFormValue=temForm.getForm().findField('importUtilityMasterId');
					var grid = $this.getImportcoursefeedefinitiongrid();
					var form = $this.getUploadoptionradiogroup();
					var isUploadAll = form.items.items[0].getValue().isUploadAll;
					var templateNameValue;
					if(temForm.down('#templateFor').getValue()=="COURSE_FEE_DEFINITION_FIXED_BASED"){
						templateNameValue = "Bulk Course Fee Definition";
						$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Course Fee Definition');
					}else if(obj.getValue()=="COURSE_FEE_DEFINITION_CREDIT_BASED"){
						templateNameValue = "Bulk Course Fee Definition Credit Based";
						$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Course Fee Definition Credit Based');
					}else if(obj.getValue()=="COURSE_FEE_DEFINITION_MAPPING"){
						templateNameValue = "Course Fee Definition Mapping";
						$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Course Fee Definition Mapping');
					}else if(obj.getValue()=="UPDATE_BULK_COURSE_REPETITION_FEE_DEFINITON"){
						templateNameValue = "Update Bulk Course Repetition Fee Definition";
						$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Update Bulk Course Repetition Fee Definition');
					}else{
						templateNameValue = "Bulk Course Repetition Fee Definition";
						$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Course Repetition Fee Definition');
					}		
                 	tempFormValue.getStore().load({
						callback:function(record){
							for(var i in record){
								if(record[i].data.value == templateNameValue){
									tempFormValue.setValue(record[i].data.id);
									tempFormValue.setReadOnly(true);
								}
							}
						}
					});
				}
			},
			'importcoursefeedefinitiongrid':{
				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					if (e.target.tagName == 'A') {
						var fileType=null;
						if(cellIndex==1){
							fileType='successFile';
						}else if(cellIndex==6){
							fileType='errorFile';
						}else if(cellIndex==7){
							fileType='logFile';
						}
						var documentId = record.get("id");
						if (!isNullOrEmpty(documentId)) {
							this.getImportLoaderDownloadFile(documentId,fileType);
						}
					}
				}
			},
			'importcoursefeedefinitiongrid button[itemId=btnForce]':{
  				 click : function(obj) {
  					 var grid = this.getImportcoursefeedefinitiongrid();
  		            	if (grid.getSelectionModel().getCount() > 0) {
  		            		if(grid.getSelectionModel().getCount() > 1){
  			        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
  			        		}else{
  			        			var this$ = this;
  	 	                	var id = grid.getSelectionModel().selectionStart.data.id;
  	 	                	var urlAppend="?jobName="+id;
  	 	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
  	 	    	        	Ext.Ajax.request({
  	 	    	        		url: submitURL,
  	 	    	        		method: 'GET',
  	 	    	        		success: function(response) {
  	 	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
  	 	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
  	 	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
  	 	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
  	 	    	        			}else if(response.responseText==="SUCCESS"){
  	     	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
  	 	    	        			}
  	 	    	        		}
  	 	    	        	});
  			        		}
  		            	} else {
  		            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
  		            	}  
  		            }
  			 },
  			'importcoursefeedefinitionuploadform uploadoptionradiogroup radiogroup[itemId=uploadgroupItemId]':{
  				change: function( radioGroup, newValue, oldValue, eOpts){
                    var grid =this.getImportcoursefeedefinitiongrid();
                    var form =this.getUploadoptionradiogroup();
                    var isUploadAll = newValue.isUploadAll;
                    this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'Bulk Course Fee Definition');
                }
  			} 
    	 });
     },
     openCourseFeeDefintaionConfigureTab :function(modeOfView){
    	 var me = this;
     	 var contentpanel = me.getContentPanel();
     	 var courseFeeDefinitionStructure = Ext.widget('coursefeedefinitiondetailstructure',{
     		 autoScroll:false
     	 });
     	 var tabName = getCommonTranslation('COURSE_FEE_DEFINITION_DETAILS');
     	 
     	 /**
     	  * This is to remove tab from content panel and open same tab again 
     	  */
     	 var getcontroller=me.getController('menu.CoreERPNavigationController');
     	 var getTab=getcontroller.getInnerTab(contentpanel,tabName);
     	 
      	 if(getTab){
      		 contentpanel.remove(getTab, true);
      	 }
     	 openTab(contentpanel, tabName, courseFeeDefinitionStructure,CONSTANTS.MENU_COLOR_FIVE);
     	 if(modeOfView =="AddView" ){
     		 var filter =courseFeeDefinitionStructure.down('feeheadconfigurationfilter');
     		 var definitionStatus =filter.down('#feeDefinationStatusId');
     		 var inactiveStatus =definitionStatus.down('#feeDefinationInactiveStatus').setDisabled(true);

     		 var grid  =courseFeeDefinitionStructure.down('feeheadconfigurationgrid');
     		 grid.getStore().removeAll();
     		courseFeeDefinitionStructure.items.items[1] && courseFeeDefinitionStructure.items.items[1].tab.setDisabled(true)
     	 }
     	courseFeeDefinitionStructure.config.isEditForm = false;
     	
     },
     onFeeHeadGridAddClick: function(serialNo,grid){
    	 var $this = this;
			 var ObjModel = [];
			 var feeHeadConfGridModel = new Academia.model.feeandpayment.coursefeedefinition.FeeHeadConfigurationGridModel();
			 feeHeadConfGridModel.set("serialNo", serialNo);
			 feeHeadConfGridModel.set("feeHead", '');
			 feeHeadConfGridModel.set("amountOrWeightage", '');
			 feeHeadConfGridModel.set("costCentre", '');
			 feeHeadConfGridModel.set("isRefundable", '');
			 feeHeadConfGridModel.set("rule", '');
			 feeHeadConfGridModel.set("isAddDeleteRow", true);
			 ObjModel.push(feeHeadConfGridModel);
			 grid.getStore().loadRawData(ObjModel, true);
			 if(serialNo == 1){
				 grid.down('#btnAdd').hide();
				 grid.down('#submitBtn').setVisible(true);
				 grid.down('#resetBtn').setVisible(true);
			 }
     },
 	  //**********View getFeeSubHeadGridWindow ************//
     getFeeCourseSubHeadGridWindow : function(grid,record,repetitionGrid){
    	 var $this=this;
    	 var courseFeeId = record.raw.id;

    	 var formWindow = this.getFeesubheadgridwindow();
    	 if (!formWindow) {
    		 Ext.widget('feesubheadgridwindow');
    		 formWindow = this.getFeesubheadgridwindow();
    	 }
    	 formWindow.show();
    	 /*var feeHeadFilter = this.getFeeheadconfigurationfilter();
    	 var feeHeadFilterValues = feeHeadFilter.getForm().getValues();*/
    	 var store = this.getStore('feeandpayment.coursefeedefinition.CourseFeeSubHeadStore');
    	 if(repetitionGrid){
    		 store.getProxy().extraParams = {
    			 // courseFeeId: feeHeadFilterValues.feeDefinitionId
    			 courseFeeId: record.data.id,
    			 isCourseFeeDefination: false
    		 };
    		 $this.resetPageSetting(store);
    		 store.load();


    	 }else{
    		 store.getProxy().extraParams = {
    			 courseFeeId: courseFeeId,
    			 isCourseFeeDefination: true
    		 };
    		 $this.resetPageSetting(store);
    		 store.load();
    	 }

     },
     saveFeeHeadConfigurationDetail: function(){
    	 var structure =this.getCoursefeedefinitiondetailstructure();
    	 var courseFeeGrid = this.getCoursefeedefinitionseachgrid();
    	 var feeHeadFilter = this.getFeeheadconfigurationfilter();
    	 var subHeadGrid = this.getFeeheadconfigurationgrid();
    	 var feeHeadFilterValue = feeHeadFilter.getForm();
    	 var feeHeadFilterValues = feeHeadFilter.getForm().getValues();
    	 var defaultfeeDefinition = feeHeadFilter.down('#defaultFeeDefinition').getValue();
    	 var courseId = feeHeadFilter.down('#feeheadCourseCodeNameId').getValue();
    	 var academicTermId = feeHeadFilter.down('#academicTermId').getValue();
    	  var billingDate =null;
    	 if(!isNullOrEmpty(academicTermId)){
    	   billingDate = feeHeadFilter.down('#billingDate').getValue();
    	 }
    	 var jsonObj ={};
    	 var subHeadArray = [];
    	 var flag= true;
    	 var submitUrl = null;
    	 var checkDefinationStatusURL = null
    	 var storeItems = subHeadGrid.getStore().data.items;
    	 if(storeItems.length > 0){
    		 storeItems.forEach(function(obj){
    			 var obj1 = new Object(); 

    			 obj1.serialNo=obj.data.serialNo;	 

    			 if(!isNullOrEmpty(obj.data.feeHead)){
    				 obj1.feeHead= {
    						 id:obj.data.feeHead
    				 }


    			 }else{
    				 flag =false;
    			 }
    			 if(!isNullOrEmpty(obj.data.amountOrWeightage)){
    				 obj1.amountOrWeightage= obj.data.amountOrWeightage

    			 }else{
    				 flag =false;
    			 }
    			 if(!isNullOrEmpty(obj.data.costCentre)){
    				 obj1. costCentre= {
    						 id: obj.data.costCentre

    				 }
    			 }
    			 if(!isNullOrEmpty(obj.data.discountRule)){
    				 obj1. discountRule= {
    						 id: obj.data.discountRule

    				 }
    			 }
    			 if(obj.data.isRefundable==true&&!isNullOrEmpty(obj.data.rule))
    			 {
    				 obj1.rule= {
    						 id: obj.data.rule

    				 }
    				 obj1.isRefundable= obj.data.isRefundable;
    			 }else if(obj.data.isRefundable==true&&isNullOrEmpty(obj.data.rule)){
    				 	flag=false;
     			 }
    			 
    			 else if(obj.data.isRefundable==false)
    			 {
    				 obj1.isRefundable= obj.data.isRefundable;

    			 }
    			 else
    			 {
    				 obj1.isRefundable= obj.data.isRefundable;
    			 } 
    			 obj1.id = obj.data.id;

    			 if(!isNullOrEmpty(obj.data.discountCostCentre)){
        			 obj1.discountCostCentre= {
        					 id: obj.data.discountCostCentre
        			 }
        		 }
        		 if(!isNullOrEmpty(obj.data.payableDiscountFeeHead)){
        			 obj1.payableDiscountFeeHead= {
        					 id: obj.data.payableDiscountFeeHead
        			 }
        		 }
        		 if(!isNullOrEmpty(obj.data.discountType)){
        			 obj1.discountType= obj.data.discountType
        		 }
        		 if(isNullOrEmpty(obj.data.payableDiscountFeeHead) && !isNullOrEmpty(obj.data.discountType)){
        			 flag=false;
        		 }else if(!isNullOrEmpty(obj.data.payableDiscountFeeHead) && isNullOrEmpty(obj.data.discountType)){
        			 flag=false;
        		 }
    			 

    			 subHeadArray.push(obj1);
    		 });
    		 if(feeHeadFilter.getForm().isValid()){
    			 if(structure.config.isEditForm){
    				 jsonObj = {
    						 id: feeHeadFilterValues.feeDefinitionId,
    						 course: {
    							 id: feeHeadFilterValues.feeheadCourseCodeName
    						 },
    						 department:{
    							 id:feeHeadFilterValues.feeheadCourseDepartment
    						 },
    						 parentFeeHead: {
    							 id: feeHeadFilterValues.feeHead
    						 },
    						 courseFeeType: feeHeadFilterValues.feeheadType,
    						 courseDefinationName:feeHeadFilterValues.feeheadDefinationName,
    						 isActive:feeHeadFilterValues.feeDefinationStatus,
    						 courseFeeSubHeads:subHeadArray,
    						 isDefaultFeeDefinition:defaultfeeDefinition,
    						 whetherOLPaymentAvailable: feeHeadFilterValues.whetherOLPaymentAvailable,
    						 whetherPaymentAtBillLevel: feeHeadFilterValues.whetherPaymentAtBillLevel,
    						 allowPartialPayment: feeHeadFilterValues.allowPartialPayment,
    						 allowPartialPaymentMobileApp: feeHeadFilterValues.allowPartialPaymentMobileApp,
    						 whetherPaymentAtBillLevelMobile: feeHeadFilterValues.whetherPaymentAtBillLevelMobile,
    						 whetherMandatoryToPay: feeHeadFilterValues.whetherMandatoryToPay,
    						 academicTerm:{
    						    id:academicTermId
    						 },
    						 billingDate:billingDate
    						 
    				 }
    			 }
    			 else{
    				 jsonObj = {
    						 course: {
    							 id: feeHeadFilterValues.feeheadCourseCodeName
    						 },
    						 department:{
    							 id:feeHeadFilterValues.feeheadCourseDepartment
    						 },
    						 parentFeeHead: {
    							 id: feeHeadFilterValues.feeHead
    						 },
    						 courseFeeType: feeHeadFilterValues.feeheadType,
    						 courseDefinationName:feeHeadFilterValues.feeheadDefinationName,
    						 isActive:feeHeadFilterValues.feeDefinationStatus,
    						 courseFeeSubHeads:subHeadArray,
    						 isDefaultFeeDefinition:defaultfeeDefinition,
    						 whetherOLPaymentAvailable: feeHeadFilterValues.whetherOLPaymentAvailable,
    						 whetherPaymentAtBillLevel: feeHeadFilterValues.whetherPaymentAtBillLevel,
    						 allowPartialPayment: feeHeadFilterValues.allowPartialPayment,
    						 allowPartialPaymentMobileApp: feeHeadFilterValues.allowPartialPaymentMobileApp,
    						 whetherPaymentAtBillLevelMobile: feeHeadFilterValues.whetherPaymentAtBillLevelMobile,
    						 whetherMandatoryToPay: feeHeadFilterValues.whetherMandatoryToPay,
    						 academicTerm:{
    						    id:academicTermId
    						 },
    						 billingDate:billingDate

    				 }
    			 }
    		 }
    		 else{
    			 flag = false;
    		 }
    		 if(flag){
    			 if(structure.config.isEditForm){
    				 submitUrl = SERVERURL.COURSE_FEE_DEFINATION_UPDATE;
    				 var feeDefinitionId = feeHeadFilterValues.feeDefinitionId,
    				 checkDefinationStatusURL = SERVERURL.PATH_CHECK_DEFAULT_FEE_DEFINITION_STATUS +'?courseId='+courseId+'&feeDefinitionId='+feeDefinitionId
    			 }
    			 else{
    				 submitUrl = SERVERURL.COURSE_FEE_DEFINATION_CREATE;
    				 checkDefinationStatusURL =SERVERURL.PATH_CHECK_DEFAULT_FEE_DEFINITION_STATUS +'?courseId='+courseId
    			 }
    			 if(defaultfeeDefinition==true){
    				 Ext.Ajax.request({
    					 type: 'rest',
    					 url: checkDefinationStatusURL,
    					 method: 'GET',
    					 success: function(res, action) {
    						 var data = Ext.decode(res.responseText);
    						 if(data==false){ //var submitUrl = SERVERURL.COURSE_FEE_DEFINATION_CREATE;
    							 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    							 Ext.encode(jsonObj);
    							 Ext.Ajax.request({
    								 type : 'rest',
    								 url : submitUrl,
    								 jsonData : jsonObj,
    								 method : 'POST',
    								 success : function(form, action) {
    									 Ext.getBody().unmask();
    									 showSuccessMessage(getCommonTranslation('FEE_HEAD_DETAILS'),getCommonTranslation('SUCCESS'));
    									 structure.up().close();
    									 courseFeeGrid.getStore().load();
    									 structure.items.items[1] && structure.items.items[1].tab.setDisabled(false);
    								 },
    								 failure:function(form,action){

    								 }
    							 });
    						 }else{
    							 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DEFAULT_FEE_DEFINITION_IS_ALREADY_SET'));
    						 }
    					 }
    				 });
    			 }else{
    				 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    				 Ext.encode(jsonObj);
    				 Ext.Ajax.request({
    					 type : 'rest',
    					 url : submitUrl,
    					 jsonData : jsonObj,
    					 method : 'POST',
    					 success : function(form, action) {
    						 Ext.getBody().unmask();
    						 showSuccessMessage(getCommonTranslation('FEE_HEAD_DETAILS'),getCommonTranslation('SUCCESS'));
    						 structure.up().close();
    						 courseFeeGrid.getStore().load();
    						 structure.items.items[1] && structure.items.items[1].tab.setDisabled(false);
    					 },
    					 failure:function(form,action){

    					 }
    				 });
    			 }
    			 

    		 }
    		 else{
    			 showWarningMessage(getCommonTranslation('ALERT'),getServiceRequestTranslation('FILL_MANDATORY_FIELDS'));
    		 }

    	 }
       },
       openEditCourseFeeDefintaionConfigureTab:function(){
    	   var $this = this;
    	   var grid = $this.getCoursefeedefinitionseachgrid();
    	   if (grid.getSelectionModel().getCount() > 0) {
    	   $this.openCourseFeeDefintaionConfigureTab();
    	   var grid1 = $this.getFeeheadconfigurationgrid();
    	   grid1.getStore().removeAll();
    	   this.disableFeeConfigurationSaveResetBtnByPriivilege(grid1,this.getCOURSE_FEE_HEAD_CONFIGURATION_PERMISSION());
    	   grid1.down('#submitBtn').setVisible(true);
    	   grid1.down('#resetBtn').setVisible(true);
    	   grid1.down('#btnAdd').setVisible(false);
    	   var courseFeeDefinitionStructure =this.getCoursefeedefinitiondetailstructure();
    	   var feeheadconfigurationtab = courseFeeDefinitionStructure.down("#feeheadconfigurationItemId");
    	   var feeConfigurationFilter = this.getFeeheadconfigurationfilter();
    		   courseFeeDefinitionStructure.config.isEditForm = true;
    		   var record = grid.getSelectionModel().getSelection()[0]; 
    		   var id = record.get("id");
    		   var editUrl = SERVERURL.PATH_FIND_BY_ID_COURSE_FEE_DEFINITION;
    		   Ext.Ajax.request({
    			   method: "GET",
    			   type: 'rest',
    			   url: editUrl,
    			   params: {
    				   id: id
    			   },
    			   success: function(f, action) {
    				   var data = Ext.JSON.decode(f.responseText);

    				   feeConfigurationFilter.down("#feeDefinitionId").setValue(id);
    				   var courseDepartmentId = feeConfigurationFilter.down('#feeheadCourseDepartmentId');
    				   var statusRadio = feeConfigurationFilter.down('#feeDefinationStatusId');
    				   var whetherOLPaymentAvailable =  feeConfigurationFilter.down('#whetherOLPaymentAvailableId');
    				   var whetherPaymentAtBillLevel = feeConfigurationFilter.down('#whetherPaymentAtBillLevelId');
    				   var whetherPaymentAtBillLevelMobile = feeConfigurationFilter.down('#whetherPaymentAtBillLevelIdMobile');
    				   var whetherMandatoryToPay = feeConfigurationFilter.down('#whetherMandatoryToPayId');
    				   var allowPartialPayment = feeConfigurationFilter.down('#allowPartialPaymentId');
    				   var allowPartialPaymentMobileApp = feeConfigurationFilter.down('#allowPartialPaymentMobileAppId');
    				   var billDateField = feeConfigurationFilter.down('#billingDate');
   				       var academicTerm =  feeConfigurationFilter.down("#academicTermId");
    				   
    				   courseDepartmentId.store.load({
    					   callback: function(records, operation, success) {
    						   if (success) {
    							   courseDepartmentId.setValue(data.department.id);
    						   }
    					   }});

    				   var courseCodeName = feeConfigurationFilter.down('#feeheadCourseCodeNameId');
    				   courseCodeName.store.getProxy().extraParams={
    					   'qry': ''
    				   };
    				   courseCodeName.store.load({
    					   callback: function(records, operation, success) {
    						   if (success) {
    							   courseCodeName.setValue(data.course.id);
    						   }
    					   }});
    				   var feeDefinitionName = feeConfigurationFilter.down('#feeheadDefinationNameId');
    				   feeDefinitionName.setValue(data.courseDefinationName);

    				   var feeHeadType = feeConfigurationFilter.down('#feeheadTypeId');
    				   feeHeadType.store.load({
    					   callback: function(records, operation, success) {
    						   if (success) {
    							   feeHeadType.setValue(data.courseFeeType);
    							   if(data.courseFeeType=='CREDIT_BASED'){
    								     academicTerm.setVisible(false);
    			    					 $this.setAllowBlank(academicTerm,true);
    			    					 billDateField.setVisible(false);
    			    					 $this.setAllowBlank(billDateField,true);
    			    					 billDateField.reset();
    			    				 }else if(data.courseFeeType=='FIXED' && $this.isCourseFeeDefinitionMapping==false){
    			    					 academicTerm.setVisible(true);
    			    					 $this.setAllowBlank(academicTerm,false);
    			    					 billDateField.setVisible(true);
    			    					 $this.setAllowBlank(billDateField,false);
    			    				 }
    						   }
    					   }});
    				   var feeHeadId = feeConfigurationFilter.down('#feeHeadId');
    				   feeHeadId.store.load({
    					   callback: function(records, operation, success) {
    						   if (success) {
    							   feeHeadId.setValue(data.parentFeeHead.id);
    						   }
    					   }});
    				   var feeDefinationStatusId= feeConfigurationFilter.down('#feeDefinationStatusId');
    				   if(data.isActive==true)
    				   {
    					   statusRadio.setValue({feeDefinationStatus:true});
    				   }
    				   else{
    					   statusRadio.setValue({feeDefinationStatus:false});
    				   }
    				   var defaultfeeDefinition = feeConfigurationFilter.down('#defaultFeeDefinition');
    				   if(data.isDefaultFeeDefinition==true)
						{
    					   defaultfeeDefinition.setValue(true);
						}
    				   else{
    					   defaultfeeDefinition.setValue(false);
    				   }
    				   if(data.whetherOLPaymentAvailable ==true){
    					   whetherOLPaymentAvailable.setValue({whetherOLPaymentAvailable:true});
    				   }else{
    					   whetherOLPaymentAvailable.setValue({whetherOLPaymentAvailable:false});
    				   }
    				   if(data.whetherPaymentAtBillLevel ==true){
    					   whetherPaymentAtBillLevel.setValue({whetherPaymentAtBillLevel:true});
    				   }else{
    					   whetherPaymentAtBillLevel.setValue({whetherPaymentAtBillLevel:false});
    				   }
    				   if(data.whetherPaymentAtBillLevelMobile==true){
        				  whetherPaymentAtBillLevelMobile.setValue({whetherPaymentAtBillLevelMobile:true});
    				   }else{
    					   whetherPaymentAtBillLevelMobile.setValue({whetherPaymentAtBillLevelMobile:false});
    				   }
    				   if(data.whetherMandatoryToPay ==true){
    					    whetherMandatoryToPay.setValue({whetherMandatoryToPay:true});
    				   }else{
    					   whetherMandatoryToPay.setValue({whetherMandatoryToPay:false});
    				   }
    				   if(data.allowPartialPayment==true){
    					  allowPartialPayment.setValue({allowPartialPayment:true});
    				   }else{
    					  allowPartialPayment.setValue({allowPartialPayment:false});
    				   }
    				   if(data.allowPartialPaymentMobileApp==true){
    					   allowPartialPaymentMobileApp.setValue({allowPartialPaymentMobileApp:true});
    				   }else{
    					   allowPartialPaymentMobileApp.setValue({allowPartialPaymentMobileApp:false});
    				   }
    				    if(!isNullOrEmpty(data.academicTerm)){
    					   academicTerm.store.load({
    					       callback: function(records, operation, success) {
    						        if (success) {
    							       academicTerm.setValue(data.academicTerm.id);
    						         }
    					       }})
    				   }
    				    if(!isNullOrEmpty(data.billingDate)){
    					   billDateField.setValue(dateRender(data.billingDate));
    				   }else{
    				      billDateField.setValue(null);
    				   }
    				   if(data.courseFeeSubHeads.length>0){
    					   
    					   var ObjModel = [];
    					   var serialNo = 0;
    					   for(i=0;i< data.courseFeeSubHeads.length; i++){
    						   serialNo = serialNo+1;
    						   var subHeadData = data.courseFeeSubHeads[i];
    						   var feeHeadConfGridModel = new Academia.model.feeandpayment.coursefeedefinition.FeeHeadConfigurationGridModel();
    						   feeHeadConfGridModel.set("serialNo", serialNo);
    						   feeHeadConfGridModel.set("feeHead", subHeadData.feeHead.id);
    						   feeHeadConfGridModel.set("amountOrWeightage", subHeadData.amountOrWeightage);
    						  // feeHeadConfGridModel.set("discountRule", subHeadData.discountRule.id);
    						 //  feeHeadConfGridModel.set("costCentre", subHeadData.costCentre.id);
    						 //  feeHeadConfGridModel.set("isRefundable", subHeadData.isRefundable);
    						 //  feeHeadConfGridModel.set("rule", subHeadData.rule.id);
    						   if(subHeadData.costCentre!=null)
	    						   feeHeadConfGridModel.set("costCentre", subHeadData.costCentre.id);
	    						   else
	    							   feeHeadConfGridModel.set("costCentre",'');
							if(subHeadData.isRefundable!=null)
	    						   feeHeadConfGridModel.set("isRefundable", subHeadData.isRefundable);
	    						   else
	    							   feeHeadConfGridModel.set("isRefundable","");
	       						
	    						   if(subHeadData.rule!=null)
	    						   feeHeadConfGridModel.set("rule", subHeadData.rule.id);
	    						   else
	    							   feeHeadConfGridModel.set("rule", '');
	    						   
	    						   if(subHeadData.discountRule!=null)
		    						   feeHeadConfGridModel.set("discountRule", subHeadData.discountRule.id);
		    						  
	    						   if(subHeadData.payableDiscountFeeHead!=null && subHeadData.payableDiscountFeeHead.id !=null)
	    							   feeHeadConfGridModel.set("payableDiscountFeeHead", subHeadData.payableDiscountFeeHead.id);
	        						   else
	        							   feeHeadConfGridModel.set("payableDiscountFeeHead",'');
	    						   
	    						   if(subHeadData.discountCostCentre!=null && subHeadData.discountCostCentre.id !=null)
	    							   feeHeadConfGridModel.set("discountCostCentre", subHeadData.discountCostCentre.id);
	        						   else
	        							   feeHeadConfGridModel.set("discountCostCentre",'');
	    						   
	    						   if(subHeadData.discountType!=null)
	    							   feeHeadConfGridModel.set("discountType", subHeadData.discountType);
	        						   else
	        							   feeHeadConfGridModel.set("discountType",'');
	    						   
	    						   
    						   feeHeadConfGridModel.set("id", subHeadData.id);
    						   feeHeadConfGridModel.set("isAddDeleteRow", true);
    						   ObjModel.push(feeHeadConfGridModel);
    					   }
    					   
    					   Ext.defer(function() {
    						   grid1.getStore().loadRawData(ObjModel, true);
    	   			    	}, 1500);
    					   
    					//   grid1.getStore().load();

    				   }
    				      			   }
    		   });



    	   }else{
    		   showWarningMessage(getFeeAndPaymentCommonTranslation('FEE_HEAD_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
    	   }





       },
//******************delete course fee configuration*******************
          getDeleteCourseFeeDefinitionConfigure : function(){
	
            	var grid = this.getCoursefeedefinitionseachgrid();
            	var grdStore = grid.getStore();
            	if (grid.getSelectionModel().getCount() > 0) {
            		showConfirmMessage(getFeeAndPaymentCommonTranslation('COURSE_FEE_DEFINITION_LIST'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
            			if (btn == 'yes') {
            				var records = grid.getSelectionModel().getSelection();
            				var id = records[0].get("id");
            				Ext.Ajax.request({
            					method: "DELETE",
            					type: 'rest',
            					url: SERVERURL.COURSE_FEE_DEFINATION_DELETE+'?id='+id,
            					headers: {
            						'Content-Type': 'application/json'
            					},
            					success: function(form, action) {
            						grdStore.reload();
            						showSuccessMessage(getFeeAndPaymentCommonTranslation('COURSE_FEE_DEFINITION_LIST'), getFeeAndPaymentCommonTranslation('COURSE_FEE_DEFINITION_DELETE_MESSAGE'));
            					}
            				});
            			}
            		});
            	} else {
            		showWarningMessage(getFeeAndPaymentCommonTranslation('COURSE_FEE_DEFINITION_LIST'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
            	} 
          },
       ViewCourseFeeDefintaionConfigureTab : function(){
    	   this.openEditCourseFeeDefintaionConfigureTab();
    	   var feeConfigurationFilter = this.getFeeheadconfigurationfilter();
    	   feeConfigurationFilter.down('#feeheadCourseDepartmentId').setReadOnly(true);
    	   feeConfigurationFilter.down('#feeheadCourseCodeNameId').setReadOnly(true);
    	   feeConfigurationFilter.down('#feeheadDefinationNameId').setReadOnly(true);
    	   feeConfigurationFilter.down('#feeheadTypeId').setReadOnly(true);
    	   feeConfigurationFilter.down('#feeHeadId').setReadOnly(true);
    	   feeConfigurationFilter.down('#feeDefinationStatusId').setReadOnly(true);
    	   feeConfigurationFilter.down('#defaultFeeDefinition').setReadOnly(true);
		 
    	   feeConfigurationFilter.down('#whetherOLPaymentAvailableId').setReadOnly(true);
    	   feeConfigurationFilter.down('#whetherPaymentAtBillLevelId').setReadOnly(true);
    	   feeConfigurationFilter.down('#whetherPaymentAtBillLevelIdMobile').setReadOnly(true);
    	   feeConfigurationFilter.down('#whetherMandatoryToPayId').setReadOnly(true);
    	   feeConfigurationFilter.down('#allowPartialPaymentId').setReadOnly(true);
    	   feeConfigurationFilter.down('#allowPartialPaymentMobileAppId').setReadOnly(true);
    	   feeConfigurationFilter.down('#academicTermId').setReadOnly(true);
    	   feeConfigurationFilter.down('#billingDate').setReadOnly(true);
		 
    	   var grid1 = this.getFeeheadconfigurationgrid();
    	   grid1.down('#submitBtn').setVisible(false);
    	   grid1.down('#resetBtn').setVisible(false);
    	   grid1.down('#btnAdd').setVisible(false);
    	   //grid1.down('#subheadItemId').setReadOnly(true);
    	   Ext.getCmp('resume-applicantdetails-view-address').setReadOnly(true);
    	   grid1.on('beforeedit', function(editor, e) {
	    		 return false;
	    	  });
    	   
    	   var gridColumns=grid1.columns;
			 var length = gridColumns.length;
			 if(length != null && length != ""){
				 for(var i = 0; i < length; i++){
					 if(gridColumns[i].dataIndex == 'addButton' || gridColumns[i].dataIndex == 'deleteButton'){
						 gridColumns[i].setVisible(false);
					 }
				 }
			 }
			 var courseFeeDefinitionStructure =this.getCoursefeedefinitiondetailstructure();
			 var courseRepitionTab = courseFeeDefinitionStructure.down('#courserepetitionconfigurationItemId');
			 courseRepitionTab.down('#btnAdd').setVisible(false);
			 courseRepitionTab.down('#btnEdit').setVisible(false);
//			  V2D-182396 view button removed from the grid
//			 courseRepitionTab.down('#btnView').setVisible(false);
			 //courseRepitionTab.down('#btnView').setVisible(false);  //already button commented on view file.
			 courseRepitionTab.down('#btnDelete').setVisible(false);
			 
			 var gridCFR = this.getCourserepetitionconfigurationtab();
			 gridCFR.down("#btnAdd").setDisabled(true);
			 gridCFR.down("#btnEdit").setDisabled(true);
			 gridCFR.down("#btnDelete").setDisabled(true);
			 
			 
       },
       showRepetitionCopyWindow : function(courseFeeDefinitionId){
      	 var copyWindow = this.getCourserepetitioncopywindow();
      	 var grid = this.getCourserepetitionconfigurationtab();
      	 if(!copyWindow){
      		 Ext.widget('courserepetitioncopywindow');
      		 copyWindow = this.getCourserepetitioncopywindow();
      	 }
      	 copyWindow.show();
      	 var copyFormWin = this.getCourserepetitioncopywindow();
    	 var enrollmentNoField = copyFormWin.down("#copiedEnrollmentId").getStore();
    	 enrollmentNoField.getProxy().extraParams = {
    		 feeDefinitionId : courseFeeDefinitionId,
		 };
    	 enrollmentNoField.load();
       },
       closeRepetitionCopyWindow : function(){
      	 this.getCourserepetitioncopywindow().close();
       },
       showAddCourseEnrollment:function(){

      	 var contentPanel = this.getContentPanel();
  		 var structure = Ext.widget('courseenrollmentconfigurationstructure');
  		 var tabName = getFeeAndPaymentCommonTranslation('COURSE_ENROLLMENT_CONFIGURATION');

  		 /**
  		  * This is to remove tab from content panel and open same tab again
  		  */
  		 var getcontroller=this.getController('menu.CoreERPNavigationController');
  		 var getTab=getcontroller.getTab(tabName);
  		 var $this=this;
  		 if(getTab!=null){
  			 contentPanel.remove(getTab, true);
  		 }
  		 openTab(contentPanel, tabName, structure, CONSTANTS.MENU_COLOR_FIVE);
  		 var frmWin = this.getCourseenrollmentconfigurationstructure();
      	 
       },
       showUpdateCourseEnrollment:function(record){
    	   var contentPanel = this.getContentPanel();
    	   var structure = Ext.widget('courseenrollmentconfigurationeditstructure');
    	   var tabName = getFeeAndPaymentCommonTranslation('COURSE_ENROLLMENT_CONFIGURATION');

    	   /**
    	    * This is to remove tab from content panel and open same tab again
    	    */
    	   var getcontroller=this.getController('menu.CoreERPNavigationController');
    	   var getTab=getcontroller.getTab(tabName);
    	   var $this=this;
    	   if(getTab!=null){
    		   contentPanel.remove(getTab, true);
    	   }
    	   openTab(contentPanel, tabName, structure, CONSTANTS.MENU_COLOR_FIVE);
    	   var structure = this.getCourseenrollmentconfigurationeditstructure();
    	   var enrollmentSection = structure.down('courseenrollnmenteditsection');
    	   enrollmentSection.down('#enrollNoItemId').setValue(record.data.enrollmentNo);
    	   enrollmentSection.down('#repAppOnFutureEnrollment').setValue(record.data.repAppOnFutureEnrollment);
    	   var courseFeeId = record.data.id;

    	   var grid1 = this.getCourserepitionfeeconfigurationeditgrid();
    	   var store = grid1.getStore();
    	   store.getProxy().extraParams = {
    		   courseFeeId: record.data.id,
    		   isCourseFeeDefination: false
    	   };
    	   $this.resetPageSetting(store);
    	   store.load({
    		   callback: function(records, operation, success) {
    			   if(success){
    					   grid1.getStore().removeAll();
    					   var ObjModel = [];
    					   var serialNo = 0;
    					   for(i=0;i< records.length; i++){
    						   serialNo = serialNo+1;
    						   var subHeadData =  records[i].data;
    						   var courseRepitionFeeConfGridModel = new Academia.model.feeandpayment.coursefeedefinition.CourseRepetitionFeeConfigurationGridModel();
    						   courseRepitionFeeConfGridModel.set("courseRepetitionFeeDefinationId", subHeadData.courseRepetitionFeeDefinationId);
    						   courseRepitionFeeConfGridModel.set("courseFeeSubHeadId", subHeadData.courseFeeSubHeadId);
    						   courseRepitionFeeConfGridModel.set("serialNo", serialNo);
    						   courseRepitionFeeConfGridModel.set("feeHeadName", subHeadData.feeHeadId);
    						   courseRepitionFeeConfGridModel.set("amountOrWeightage", subHeadData.amountOrWeightage);
    						   if(subHeadData.costCentreId!=null)
        						   courseRepitionFeeConfGridModel.set("costCentre", subHeadData.costCentreId);
        						   else
        							   courseRepitionFeeConfGridModel.set("costCentre",'');
    						  
    						   if(subHeadData.payableDiscountFeeHeadId!=null)
        						   courseRepitionFeeConfGridModel.set("payableDiscountFeeHead", subHeadData.payableDiscountFeeHeadId);
        						   else
        							   courseRepitionFeeConfGridModel.set("payableDiscountFeeHead",'');
    						   
    						   if(subHeadData.discountCostCentreId!=null)
        						   courseRepitionFeeConfGridModel.set("discountCostCentre", subHeadData.discountCostCentreId);
        						   else
        							   courseRepitionFeeConfGridModel.set("discountCostCentre",'');
    						   
    						   if(subHeadData.discountType!=null)
        						   courseRepitionFeeConfGridModel.set("discountType", subHeadData.discountType);
        						   else
        							   courseRepitionFeeConfGridModel.set("discountType",'');
    						   
    						   if(subHeadData.discountRule!=null)
        						   courseRepitionFeeConfGridModel.set("discountRule", subHeadData.discountRuleId);
        						   else
        							   courseRepitionFeeConfGridModel.set("discountRule",'');
    						   
    						if(subHeadData.isRefundable!=null)
        						   courseRepitionFeeConfGridModel.set("isRefundable", subHeadData.isRefundable);
        						   else
        							   courseRepitionFeeConfGridModel.set("isRefundable","");
           						
        						   if(subHeadData.ruleId!=null)
        						   courseRepitionFeeConfGridModel.set("rulePrintName", subHeadData.ruleId);
        						   else
        						   courseRepitionFeeConfGridModel.set("rulePrintName", '');
    						   courseRepitionFeeConfGridModel.set("id", subHeadData.id);
    						   courseRepitionFeeConfGridModel.set("isAddDeleteRow", true);
    						   ObjModel.push(courseRepitionFeeConfGridModel);
    					   }
    					   //courseFeeType.setValue(data.courseFeeType);
    					   Ext.defer(function() {
    						   grid1.getStore().loadRawData(ObjModel, true);
					    	}, 3000, this);
    			   }
    		   }
    	   });
       },
       saveCourseRepetitionFeeConfigurationDetail: function(){
    	   var structure =this.getCourseenrollmentconfigurationstructure();
    	   var courseEnrolnment = this.getCourseenrollnmentsection();
    	   var enrollNumField = courseEnrolnment.down('#enrollNoItemId');
    	   var forAllEnrollment = courseEnrolnment.down('#forAllEnrollment');
    	   var repAppOnFutureEnrollment = courseEnrolnment.down('#repAppOnFutureEnrollment');
    	   var enrollNo =enrollNumField.getValue();
    	   var subHeadGrid = this.getCourserepitionfeeconfigurationgrid();
    	   var feeHeadFilter = this.getFeeheadconfigurationfilter();
    	   var feeHeadFilterValue = feeHeadFilter.getForm();
    	   var feeHeadFilterValues = feeHeadFilter.getForm().getValues();
    	   var courseRepetitionPanel = this.getCourserepetitionconfigurationtab();
		   var grid = courseRepetitionPanel.down('grid');
		   var addBtn = grid.down('#btnAdd');
		   var courseRepetitionStore = grid.getStore();
    	   var jsonObj ={};
    	   var subHeadArray = [];
    	   var flag= true;
    	   var submitUrl = null;
    	   var storeItems = subHeadGrid.getStore().data.items;
    	   if(storeItems.length > 0){
    		   storeItems.forEach(function(obj){
    			   var obj1 = new Object(); 

    			   obj1.serialNo=obj.data.serialNo;	 

    			   if(!isNullOrEmpty(obj.data.costCentre)){
            			 obj1. costCentre= {
           		          id: obj.data.costCentre
           		     
            		 }
            		 }
    			   if(!isNullOrEmpty(obj.data.discountRule)){
          			 obj1. discountRule= {
         		          id: obj.data.discountRule
         		     
          		 }
          		 }
            		 if(obj.data.isRefundable==true&&!isNullOrEmpty(obj.data.rule))
     	            {
     	            	 obj1.rule= {
            		          id: obj.data.rule

     		                      }
     		    obj1.isRefundable= obj.data.isRefundable;
     	            }
         		  else if(obj.data.isRefundable==false)
     	            {
     	            	 obj1.isRefundable= obj.data.isRefundable;
     	            	 
        	            }
     	            else
     	            {
     	            	 obj1.isRefundable= obj.data.isRefundable;
     	            	flag=false;
     	            } 
            		 
            		 if(!isNullOrEmpty(obj.data.discountCostCenter)){
            			 obj1.discountCostCentre= {
            					 id: obj.data.discountCostCenter
            			 }
            		 }
            		 if(!isNullOrEmpty(obj.data.payableDiscountFeeHead)){
            			 obj1.payableDiscountFeeHead= {
            					 id: obj.data.payableDiscountFeeHead
            			 }
            		 }
            		 if(!isNullOrEmpty(obj.data.discountType)){
            			 obj1.discountType= obj.data.discountType
            		 }
            		 if(isNullOrEmpty(obj.data.payableDiscountFeeHead) && isNullOrEmpty(obj.data.discountType)){
            			 flag=true;
            		 }else if(isNullOrEmpty(obj.data.payableDiscountFeeHead) && !isNullOrEmpty(obj.data.discountType)){
            			 flag=false;
            		 }else if(!isNullOrEmpty(obj.data.payableDiscountFeeHead) && isNullOrEmpty(obj.data.discountType)){
            			 flag=false;
            		 }else if(!isNullOrEmpty(obj.data.payableDiscountFeeHead) && !isNullOrEmpty(obj.data.discountType)){
            			 flag=true;
            		 }
            		 if(!isNullOrEmpty(obj.data.feeHead)){
      				   obj1.feeHead= {
      						   id:obj.data.feeHead
      				   }      

      			   }else{
      				   flag =false;
      			   }
      			   if(!isNullOrEmpty(obj.data.amountOrWeightage)){
      				   obj1.amountOrWeightage= obj.data.amountOrWeightage

      			   }else{
      				   flag =false;
      			   }
    			 //  obj1.id = obj.data.id;


    			   subHeadArray.push(obj1);
    		   });
    		   jsonObj = {
    				   courseFeeDefination: {
    					   id: feeHeadFilterValues.feeDefinitionId
    				   },
    				   enrollmentNo : enrollNo,
    				   courseFeeSubHeads:subHeadArray,
    				   isForAllEnrollment: forAllEnrollment.getValue(),
    				   repAppOnFutureEnrollment:repAppOnFutureEnrollment.getValue()

    		   } 
    		   if(flag){
    		   submitUrl = SERVERURL.COURSE_REPETITION_FEE_ENROLLNMENT_CREATE;
    		   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		   Ext.encode(jsonObj);
    		   Ext.Ajax.request({
    			   type : 'rest',
    			   url : submitUrl,
    			   jsonData : jsonObj,
    			   method : 'POST',
    			   success : function(form, action) {
    				   Ext.getBody().unmask();
    				   showSuccessMessage(getCommonTranslation('COURSE_REPETITION_CONFIGURATION'),getCommonTranslation('SUCCESS'));
    				   structure.up().close();
    				   courseRepetitionStore.load({
    	 					 callback:function(record){
    	  						if(record.length >0){
    	  							if(record[0].data.enrollmentNo == 2  && record[0].data.isForAllEnrollment ==  true ){
    	  								addBtn.disable(true) 
    	  							}
    	  							for(var count=0;count<record.length;count++){
    	 								if(record[count].data.repAppOnFutureEnrollment){
    	 									addBtn.disable(true)
    	 								}
    	 							}
    	  						} 
    	  					 }
    	  				 });
    				   //courseFeeGrid.getStore().load();
    			   },
    			   failure:function(form,action){

    			   }
    		   });
    		   }else{
      			 showWarningMessage(getCommonTranslation('ALERT'),getServiceRequestTranslation('FILL_MANDATORY_FIELDS'));

    		   }

    	   }
       },
       updateCourseRepetitionFeeConfigurationDetail: function(){
    	   var structure =this.getCourseenrollmentconfigurationeditstructure();
    	   var courseEnrolnment = this.getCourseenrollnmenteditsection();
    	   var enrollNumField = courseEnrolnment.down('#enrollNoItemId');
    	   var repAppOnFutureEnrollment = courseEnrolnment.down('#repAppOnFutureEnrollment');
    	   var enrollNo =enrollNumField.getValue();
    	   var subHeadGrid = this.getCourserepitionfeeconfigurationeditgrid();
    	   var feeHeadFilter = this.getFeeheadconfigurationfilter();
    	   var feeHeadFilterValue = feeHeadFilter.getForm();
    	   var feeHeadFilterValues = feeHeadFilter.getForm().getValues();
    	   var courseRepetitionPanel = this.getCourserepetitionconfigurationtab();
    	   var grid = courseRepetitionPanel.down('grid');
    	   var courseRepetitionStore = grid.getStore();
    	   var jsonObj ={};
    	   var subHeadArray = [];
    	   var flag= true;
    	   var submitUrl = null;
    	   var storeItems = subHeadGrid.getStore().data.items;
    	   if(storeItems.length > 0){
    		   var courseRepetitionFeeDefinationId = storeItems[0].data.courseRepetitionFeeDefinationId;
    		   storeItems.forEach(function(obj){
    			   var obj1 = new Object(); 
    			   obj1.id=obj.data.courseFeeSubHeadId;
    			   obj1.serialNo=obj.data.serialNo;	 

    			   if(!isNullOrEmpty(obj.data.feeHeadName)){
    				   obj1.feeHead= {
    						   id:obj.data.feeHeadName
    				   }      
    			   }else{
    				   flag =false;
    			   }
    			   if(!isNullOrEmpty(obj.data.amountOrWeightage)){
    				   obj1.amountOrWeightage= obj.data.amountOrWeightage
    			   }else{
    				   flag =false;
    			   }
    			   if(!isNullOrEmpty(obj.data.costCentre)){
    				   obj1. costCentre= {
    						   id: obj.data.costCentre
    				   }
    			   }
    			   if(!isNullOrEmpty(obj.data.discountRule)){
    				   obj1. discountRule= {
    						   id: obj.data.discountRule
    				   }
    			   }
    			   if(obj.data.isRefundable==null)
    			   {
    				   obj.data.isRefundable="";
    			   }
    			   if(obj.data.isRefundable==true&&!isNullOrEmpty(obj.data.rulePrintName))
    			   {
    				   obj1.rule= {
    						   id: obj.data.rulePrintName
    				   }
    				   obj1.isRefundable= obj.data.isRefundable;
    			   }
    			   else if(obj.data.isRefundable==false)
    			   {
    				   obj1.isRefundable= obj.data.isRefundable;
    			   }
    			   else
    			   {
    				   obj1.isRefundable= obj.data.isRefundable;
    				   flag=false;
    			   } 
    			   
    			   if(!isNullOrEmpty(obj.data.discountCostCentre)){
          			 obj1.discountCostCentre= {
          					 id: obj.data.discountCostCentre
          			 }
          		 }
          		 if(!isNullOrEmpty(obj.data.payableDiscountFeeHead)){
          			 obj1.payableDiscountFeeHead= {
          					 id: obj.data.payableDiscountFeeHead
          			 }
          		 }
          		 if(!isNullOrEmpty(obj.data.discountType)){
          			 obj1.discountType= obj.data.discountType
          		 }
    			   
    			   subHeadArray.push(obj1);
    		   });
    		   jsonObj = {
    				   courseFeeDefination: {
    					   id: feeHeadFilterValues.feeDefinitionId
    				   },
    				   enrollmentNo : enrollNo,
    				   courseFeeSubHeads:subHeadArray,
    				   id : courseRepetitionFeeDefinationId,
    				   repAppOnFutureEnrollment:repAppOnFutureEnrollment.getValue()
    		   } 
    		   if(flag){
    			   submitUrl = SERVERURL.COURSE_REPETITION_FEE_ENROLLNMENT_UPDATE;
    			   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    			   Ext.encode(jsonObj);
    			   Ext.Ajax.request({
    				   type : 'rest',
    				   url : submitUrl,
    				   jsonData : jsonObj,
    				   method : 'POST',
    				   success : function(form, action) {
    					   Ext.getBody().unmask();
    					   showSuccessMessage(getCommonTranslation('COURSE_REPETITION_CONFIGURATION'),getCommonTranslation('RECORD_UPDATE_SUCCESS'));
    					   structure.up().close();
    					   courseRepetitionStore.reload();
    				   },
    				   failure:function(form,action){
    				   }
    			   });
    		   }else{
    			   showWarningMessage(getCommonTranslation('ALERT'),getServiceRequestTranslation('FILL_MANDATORY_FIELDS'));
    		   }
    	   }
       },
       saveRepetitionCopyWindow: function(){
    	   var $this = this;
    	   var frmwin = this.getCourserepetitioncopywindow(); 
    	   var copyFromEnrollment = frmwin.down('#copiedEnrollmentId').getValue();
    	   var enrollmentNo = frmwin.down('#enrollmentNoId').getValue();
    	   var courseRepetitionPanel = this.getCourserepetitionconfigurationtab();
    	   var grid = courseRepetitionPanel.down('grid');
    	   var courseRepetitionStore = grid.getStore();

    	   jsonObj = {
    			   id : copyFromEnrollment,
    			   enrollmentNo:enrollmentNo
    	   }

    	   var submitUrl =  SERVERURL.PATH_COPY_COURSE_REPETITION;
    	   $this.applyWindowMask(); 
    	   Ext.Ajax.request({
    		   type : 'rest',
    		   url : submitUrl,
    		   jsonData : jsonObj,
    		   method : 'POST',
    		   success : function(response, action) {
    			   showSuccessMessage(getCommonTranslation('COURSE_REPETITION_CONFIGURATION'), getFeeAndPaymentCommonTranslation('COURSE_REPETITION_COPIED_SUCCESS'));
    			   $this.hideWindowMask();
    			   courseRepetitionStore.reload(); 
    			   $this.closeRepetitionCopyWindow();
    		   }
    	   });
       },
       deleteFeeHeadConfigurationDetails: function(grid,record,createexameventdetailsgridStructure,titleMessage,rowIndex){
    	   if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.id)) {
    		   if (grid.getStore().getRange().length > 0) {
    			   grid.getStore().removeAt(rowIndex);
    			   var models = grid.getStore().getRange();
    			   for (var i = 0; i < models.length; i++) {
    				   models[i].data.serialNo = i + 1;
    			   }
    			   grid.getStore().loadRawData(models, true);
    			   if(models.length == 0){
    				   var grid1 =this.getFeeheadconfigurationgrid();
    				   this.disableFeeConfigurationButtonByPriivilege(grid1, this.getCOURSE_FEE_HEAD_CONFIGURATION_PERMISSION());
    				   this.disableFeeConfigurationSaveResetBtnByPriivilege(grid1, this.getCOURSE_FEE_HEAD_CONFIGURATION_PERMISSION())
    			
    			   }
    		   }
    	   }
       },
       disableFeeConfigurationButtonByPriivilege: function(grid,permissionsMap){
    	   var confugurationTab = this.getFeeheadconfigurationtab();
    	  var addBtn =  grid.down('#btnAdd');
    	  var submitBtn = grid.down('#submitBtn');
    	  var resetBtn = grid.down('#resetBtn');
    	  addBtn.setVisible(false);
    	  submitBtn.setVisible(false);
    	  resetBtn.setVisible(false);
    	 
    	  var associatedAcadLocationIds = new Array();
  		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
  		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
  		Ext.each(permissionList, function(privilege) {
  			if(privilege === "ADD"){
  				if(!isNullOrEmpty(addBtn)){
  					addBtn.setVisible(true);
  					confugurationTab.addPermission =true;
        		}
  			}if(privilege === "DELETE"){
    			confugurationTab.deletePermission =true;
  			}
  		});
       },
       disableImportCourseFeeDefTab:function(structure,permissionsMap){

		   	 var associatedAcadLocationIds = new Array();
		   	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		   	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		   	 var importCourseFeeDefTab=false;
		   	 for (var i = 0; i < permissionList.length; i++) {
		   		 if (permissionList[i] === "IMPORT_COURSE_FEE_DEFINITION") {
		   			importCourseFeeDefTab=true;
		   		 }
		   	 }
		   	 this.showImportCourseFeeDefTab(importCourseFeeDefTab, structure);
       },
       showImportCourseFeeDefTab:function(importCourseFeeDefTab, structure){
		   	 var panelItem = new Array();
		   	 var $this = this;
		   	 var newcont=structure.items.items.length;
		   	 var insertPosition=newcont+1;
		   	 if(importCourseFeeDefTab==true) {
		   		 panelItem.push({
		   			xtype:'tabpanel',
		   			 plain: true,
		   			 style:{overflow:'hidden !important',margin:'0!important'},
		   			 
		   			 frame: false,
		   			 border:false,
		   			items:[{
		   				xtype:'coursefeedefinitionsearchtab',
		   				title: getCommonTranslation('SEARCH'),
		   				tabCls: 'right-tab'	
		   			},{
		   				xtype:'importcoursefeedefinitiontab',
		   				title: getFeeAndPaymentCommonTranslation('IMPORT_BULK_COURSE_FEE_DEFINITION'),
		   				tabCls: 'right-tab'	
		   			}]
		   		 });
		   	 }else{
		   		 panelItem.push({
		   			 xtype:'tabpanel',
		   			 plain: true,
		   			 style:{overflow:'hidden !important',margin:'0!important'},
		   			 
		   			 frame: false,
		   			 border:false,
		   			items:[{
		   				xtype:'coursefeedefinitionsearchtab',
		   				title: getCommonTranslation('SEARCH'),
		   				tabCls: 'right-tab'	
		   			}]
		   		 });
		   	 }
		   	 structure.insert(insertPosition,panelItem);
		  
       },
       loadCourseFeeDefLoaderGrid : function(tempFormValue){
			var $this = this;
			var grid = this.getImportcoursefeedefinitiongrid();
			var form  = $this.getUploadoptionradiogroup();
			var isUploadAll = form.items.items[0].getValue().isUploadAll;
			if(tempFormValue=="Bulk Course Fee Definition"){
 				$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Course Fee Definition');
			}else if(tempFormValue=="Bulk Course Fee Definition Credit Based"){
 				$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Course Fee Definition Credit Based');
			}else if(tempFormValue=="Course Fee Definition Mapping"){
 				$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Course Fee Definition Mapping');
			}else if(tempFormValue=="Bulk Course Repetition Fee Definition"){
 				$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Course Repetition Fee Definition');
			}else if(tempFormValue == "Update Bulk Course Repetition Fee Definition"){
				$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Update Bulk Course Repetition Fee Definition');
				}
		},
		getImportLoaderDownloadFile : function(documentId,fileType){
		    	if(!isNullOrEmpty(documentId)){
		    		var csvForm = Ext.create('Ext.form.Panel'); 
		    		csvForm.getForm().submit({
		    			target: '_blank',
		    			method:'POST',
		    			params :{
		    				access_token : Ext.Ajax.defaultHeaders.access_token
		    			},
		    			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
		    			url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
		    			standardSubmit :true
		    		});
		    	}
		    },
       disableFeeConfigurationSaveResetBtnByPriivilege :function(grid,permissionsMap){
    	   var submitBtn = grid.down('#submitBtn')
			 var resetBtn=	grid.down('#resetBtn')
			 resetBtn.setVisible(false);
			 submitBtn.setVisible(false);
			 var associatedAcadLocationIds = new Array();
		  		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
		  		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getCOURSE_FEE_HEAD_CONFIGURATION_PERMISSION());
		  		Ext.each(permissionList, function(privilege) {
		  			if(privilege === "SAVE"){
		  				if(!isNullOrEmpty(submitBtn)){
		  					submitBtn.setVisible(true);
		        		}
		  			}if(privilege === "RESET"){
		  				if(!isNullOrEmpty(resetBtn)){
		  					resetBtn.setVisible(true);
		        		}
		  			}
		  		});
       }
});
