/**
 *  @author Rajkumar.patidar
 *
 */
Ext.define('Academia.controller.feeandpayment.dashboardAndReports.FeeAndPaymentDashboardController', {
	extend: 'Academia.controller.programCourseDashboard.organizationUnit.organizationUnitController',
	stores: ['feeandpayment.dashboardAndReports.FeeUserType', 'feeandpayment.dashboardAndReports.FeeStaticsFor',
	         'feeandpayment.dashboardAndReports.FeeStaticsView', 'common.ProgramByAcademyLocationStore',
	         'feeandpayment.dashboardAndReports.FeeHeadByFeePlanTypeId','feeandpayment.FeePlanTypeStore',
	         'feeandpayment.dashboardAndReports.PaymentStatisticsType','facilitiesresources.resourcemaster.ProgramGridStore',
	         'feeandpayment.dashboardAndReports.FeeCollectionHeadWiseAllFeeHead','enquiry.AcademicBatchStore',
	         'feeandpayment.dashboardAndReports.FeeStaticCollectionHeadWiseAllProgram',
	         'feeandpayment.dashboardAndReports.FeeStaticCollectionHeadWiseAllLocation',
	         'feeandpayment.dashboardAndReports.FeeStaticCollectionHeadWiseAllAcademy',
	         'program.programbatchdetail.BatchStore','feeandpayment.reports.FeeDashboardReportTreeStore','program.programDetails.programBatches.PrimaryAcademicStore'
	         ],
	         views: ['feeandpayment.dashboardAndReports.FeeAndPaymentDashboardStructure',
	                 'feeandpayment.dashboardAndReports.paymentStatistics.PaymentStatisticsByAcademiesChart',
	                 'feeandpayment.dashboardAndReports.paymentStatistics.PaymentStatisticsStructure',
	                 'feeandpayment.dashboardAndReports.paymentStatistics.PaymentStatisticsByLocationChart',
	                 'feeandpayment.dashboardAndReports.paymentStatistics.PaymentStatisticsByProgramChart',
	                 'feeandpayment.dashboardAndReports.refundStatistics.RefundStatisticsByAcademiesChart',
	                 'feeandpayment.dashboardAndReports.refundStatistics.RefundStatisticsByLocationChart',
	                 'feeandpayment.dashboardAndReports.refundStatistics.RefundStatisticsByProgramChart',
	                 'feeandpayment.dashboardAndReports.refundStatistics.RefundStatisticsStructure',
	                 'feeandpayment.dashboardAndReports.facultyPaymentStatistics.FacultyPaymentStatisticsStructure',
	                 'feeandpayment.dashboardAndReports.facultyPaymentStatistics.FacultyPaymentStatisticsByAcademiesChart',
	                 'feeandpayment.dashboardAndReports.facultyPaymentStatistics.FacultyPaymentStatisticsByLocationChart',
	                 'feeandpayment.dashboardAndReports.discountStatistics.DiscountStatisticsStructure',
	                 'feeandpayment.dashboardAndReports.discountStatistics.DiscountStatisticsByProgramChart',
	                 'feeandpayment.dashboardAndReports.discountStatistics.DiscountStatisticsByLocationChart',
	                 'feeandpayment.dashboardAndReports.discountStatistics.DiscountStatisticsByAcademiesChart', 'feeandpayment.dashboardAndReports.FeeAndPaymentCommonFilter',
	                 'feeandpayment.dashboardAndReports.paymentStatistics.EnlargeFeeChartWindow',
	                 'feeandpayment.dashboardAndReports.PaymentStatisticsFilter',
	                 'feeandpayment.dashboardAndReports.FeeDashboardReportTabPanel'
	                 ],
	                 config: {
	                	 FEEANDPAYMENT_DASHBOARD_STATISTICS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FEEANDPAYMENT_DASHBOARD_STATISTICS_PRIVILEGES'),  		  
	                	 FEEANDPAYMENTDASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FEEANDPAYMENTDASHBOARD_PRIVILEGES')  		  
	                 },           
	                 refs: [{
	                	 ref: 'feeAndPaymentDashboardStructure',
	                	 selector: 'feeandpaymentdashboardstructure'
	                 }, {
	                	 ref: 'organizationUnit',
	                	 selector: 'organizationunit[itemId=organizationunitId]'
	                 }, {
	                	 ref: 'feeAndPaymentCommonFilter',
	                	 selector: 'feeandpaymentcommonfilter'
	                 }, {
	                	 ref: 'paymentStatiSticsStructure',
	                	 selector: 'paymentstatisticsstructure'
	                 }, {
	                	 ref: 'feeCollectionHeadWiseAllFeeHeadGrid',
	                	 selector: 'searchresultgrid[itemId=feecollectionheadwiseallfeeheadgrid]'
	                 },{
	                	 ref: 'feeCollectionHeadwiseApplicationGrid',
	                	 selector: 'searchresultgrid[itemId=feecollectionheadwiseapplicationgrid]'
	                 },{
	                	 ref: 'feecollectionheadwiseprogramgrid',
	                	 selector: 'searchresultgrid[itemId=feecollectionheadwiseprogramgrid]'
	                 },{
	                	 ref: 'collectionuserwiseapplicantfirstgrid',
	                	 selector: 'searchresultgrid[itemId=collectionuserwiseapplicantfirstgrid]'
	                 },{
	                	 ref: 'collectionuserwiseapplicantsecondgrid',
	                	 selector: 'searchresultgrid[itemId=collectionuserwiseapplicantsecondgrid]'
	                 }, {
	                	 ref: 'collectionuserwisesponsorfirstgrid',
	                	 selector: 'searchresultgrid[itemId=collectionuserwisesponsorfirstgrid]'
	                 },{
	                	 ref: 'collectionuserwisesponsorsecondgrid',
	                	 selector: 'searchresultgrid[itemId=collectionuserwisesponsorsecondgrid]'
	                 },{
	                	 ref: 'enlargeFeeChartWindow',
	                	 selector: 'enlargefeechartwindow'
	                 }, {
	                	 ref: 'collectionUserWiseFirstGrid',
	                	 selector: 'searchresultgrid[itemId=collectionuserwisefirstgrid]'
	                 }, {
	                	 ref: 'collectionUserWiseSecondGrid',
	                	 selector: 'searchresultgrid[itemId=collectionuserwisesecondgrid]'
	                 }, {
	                	 ref: 'collectionuserwisestudentfirstgrid',
	                	 selector: 'searchresultgrid[itemId=collectionuserwisestudentfirstgrid]'
	                 },{
	                	 ref: 'collectionuserwisestudentsecondgrid',
	                	 selector: 'searchresultgrid[itemId=collectionuserwisestudentsecondgrid]'
	                 },{
	                	 ref: 'billfeeheadwiseallfeeheadgrid',
	                	 selector: 'searchresultgrid[itemId=billfeeheadwiseallfeeheadgrid]'
	                 },{
	                	 ref: 'billfeeheadwiseapplicationgrid',
	                	 selector: 'searchresultgrid[itemId=billfeeheadwiseapplicationgrid]'
	                 },{
	                	 ref: 'billfeeheadwiseprogramgrid',
	                	 selector: 'searchresultgrid[itemId=billfeeheadwiseprogramgrid]'
	                 },{
	                	 ref: 'billuserwiseapplicantfirstgrid',
	                	 selector: 'searchresultgrid[itemId=billuserwiseapplicantfirstgrid]'
	                 },{
	                	 ref: 'billuserwiseapplicantsecondgrid',
	                	 selector: 'searchresultgrid[itemId=billuserwiseapplicantsecondgrid]'
	                 },{
	                	 ref: 'billuserwisestudentfirstgrid',
	                	 selector: 'searchresultgrid[itemId=billuserwisestudentfirstgrid]'
	                 },{
	                	 ref: 'billuserwisestudentsecondgrid',
	                	 selector: 'searchresultgrid[itemId=billuserwisestudentsecondgrid]'
	                 },{
	                	 ref: 'billstudentwisesponsorfirstgrid',
	                	 selector: 'searchresultgrid[itemId=billstudentwisesponsorfirstgrid]'
	                 },{
	                	 ref: 'billstudentwisesponsorsecondgrid',
	                	 selector: 'searchresultgrid[itemId=billstudentwisesponsorsecondgrid]'
	                 },{
	                	 ref: 'feeBillHeadWiseAllFeeHeadGrid',
	                	 selector: 'searchresultgrid[itemId=feebillheadwiseallfeeheadgrid]'
	                 }, {
	                	 ref: 'feeOutstandingHeadWiseAllFeeHeadGrid',
	                	 selector: 'searchresultgrid[itemId=feeoutstandingheadwiseallfeeheadgrid]'
	                 },{
	                	 ref: 'outstandingheadwisegrid',
	                	 selector: 'searchresultgrid[itemId=outstandingheadwisegrid]'
	                 }, {
	                	 ref: 'outStandingUserWiseFirstGrid',
	                	 selector: 'searchresultgrid[itemId=outstandinguserwisefirstgrid]'
	                 }, {
	                	 ref: 'outStandingUserWiseSecondGrid',
	                	 selector: 'searchresultgrid[itemId=outstandinguserwisesecondgrid]'
	                 },{
	                	 ref: 'outstandingheadwiseprogramgrid',
	                	 selector: 'searchresultgrid[itemId=outstandingheadwiseprogramgrid]'
	                 },{
	                	 ref: 'outstandingstudentwisesponsorfirstgrid',
	                	 selector: 'searchresultgrid[itemId=outstandingstudentwisesponsorfirstgrid]'
	                 }, {
	                	 ref: 'outstandingstudentwisesponsorsecondgrid',
	                	 selector: 'searchresultgrid[itemId=outstandingstudentwisesponsorsecondgrid]'
	                 }, {
	                	 ref: 'billUserWiseFirstGrid',
	                	 selector: 'searchresultgrid[itemId=billuserwisefirstgrid]'
	                 }, {
	                	 ref: 'billUserWiseSecondGrid',
	                	 selector: 'searchresultgrid[itemId=billuserwisesecondgrid]'
	                 },{
	                	 ref: 'outstandingheadwiseapplicationgrid',
	                	 selector: 'searchresultgrid[itemId=outstandingheadwiseapplicationgrid]'
	                 },{
	                	 ref: 'outstandingstudentwisestudentfirstgrid',
	                	 selector: 'searchresultgrid[itemId=outstandingstudentwisestudentfirstgrid]'
	                 },{
	                	 ref: 'outstandingstudentwisestudentsecondgrid',
	                	 selector: 'searchresultgrid[itemId=outstandingstudentwisestudentsecondgrid]'
	                 }, {
	                	 ref: 'outstandingstudentwiseapplicantfirstgrid',
	                	 selector: 'searchresultgrid[itemId=outstandingstudentwiseapplicantfirstgrid]'
	                 },{
	                	 ref: 'outstandingstudentwiseapplicantsecondgrid',
	                	 selector: 'searchresultgrid[itemId=outstandingstudentwiseapplicantsecondgrid]'
	                 }, {
	                	 ref: 'refundWiseFirstGrid',
	                	 selector: 'searchresultgrid[itemId=refundwisefirstgrid]'
	                 },{
	                	 ref: 'refunduserwiseapplicantfirstgrid',
	                	 selector: 'searchresultgrid[itemId=refunduserwiseapplicantfirstgrid]'
	                 },{
	                	 ref: 'refunduserwiseapplicantsecondgrid',
	                	 selector: 'searchresultgrid[itemId=refunduserwiseapplicantsecondgrid]'
	                 },{
	                	 ref: 'refunduserwisestudentfirstgrid',
	                	 selector: 'searchresultgrid[itemId=refunduserwisestudentfirstgrid]'
	                 },{
	                	 ref: 'refunduserwisestudentsecondgrid',
	                	 selector: 'searchresultgrid[itemId=refunduserwisestudentsecondgrid]'
	                 }, {
	                	 ref: 'refundWiseSecondGrid',
	                	 selector: 'searchresultgrid[itemId=refundwisesecondgrid]'
	                 },{
	                	 ref:'paymentStatiSticsFilter',
	                	 selector:'paymentstatisticsfilter'
	                 }, {
	                	 ref: 'resultGridsContainer',
	                	 selector: 'fieldcontainer[itemId=resultGridsContainer]'
	                 }, {
	                	 ref: 'testing',
	                	 selector: 'searchresultgrid[itemId=testing]'
	                 }],
	                 init: function() {
	                	 this.control({
	                		 'feeandpaymentdashboardstructure panel[itemId=feeDashboardReportView] treepanel[itemId=feeDashboardReportTreePanelItemId]' : {
									itemclick : this.getOpenFeeDashboardReportStructure
								},
	                		 //***1**************Export For Report******Fee Headwise All****************************************************************
	                		 'feeandpaymentdashboardstructure fieldcontainer searchresultgrid button[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
	                			 click : function(obj) {
	                				 var grid = obj.up('grid');
	                				 var configCode = grid.getConfigInfo();
	                				 this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,grid,configCode);
	                			 }
	                		 },
	                		 'feeandpaymentdashboardstructure fieldcontainer searchresultgrid button[itemId=exportToPdfBtn] #exportPdfAll': {
	                			 click: function(obj) {
	                				 var grid = obj.up('grid');
	                				 var configCode = grid.getConfigInfo();
	                				 this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true,grid,configCode);
	                			 }
	                		 },
	                		 'feeandpaymentdashboardstructure fieldcontainer searchresultgrid button[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
	                			 click : function(obj) {
	                				 var grid = obj.up('grid');
	                				 var configCode = grid.getConfigInfo();
	                				 this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,grid,configCode);
	                			 }
	                		 },
	                		 'feeandpaymentdashboardstructure fieldcontainer searchresultgrid button[itemId=exportToPdfBtn] #exportExcelAll': {
	                			 click: function(obj) {
	                				 var grid = obj.up('grid');
	                				 var configCode = grid.getConfigInfo();
	                				 this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,grid,configCode);
	                			 }
	                		 },
	                		 'feeandpaymentcommonfilter': {
	                			 render: this.getLoadPrograms,
	                			 afterrender: this.setFromAndTillDate
	                		 },
	                		 'feeandpaymentcommonfilter customcombobox[itemId=academicYear]': {
	                			 select: function(obj, record) {
	                				 var academyYearId = record[0].data.id;
	                				 this.setFromDateToDateByAcademyYear(obj,academyYearId)
	                			 }
	                		 },
	                		 'organizationunit[itemId=organizationunitId] radiogroup[itemId=organizationRadioUnitId]': {
	                			 change: this.getLoadPrograms
	                		 },
	                		 'feeandpaymentcommonfilter button[itemId=searchBtn] ': {
	                			 click: this.getSearchCommonFilterForm
	                		 },
	                		 'feeandpaymentcommonfilter button[itemId=resetBtn] ': {
	                			 click: this.getResetCommonFilterForm
	                		 },
	                		 'feeandpaymentcommonfilter customcombobox#showStaticView': {
	                			 select: function(obj, record) {
	                				 var feeAndPaymentCommonFilter = this.getFeeAndPaymentCommonFilter();
	                				 var statisView = record[0].get("id");
	                				 var userTypeField = feeAndPaymentCommonFilter.down("#feeUserType");
	                				 userTypeField.clearValue();
	                				 userTypeField.setVisible(false);
	                				 userTypeField.allowBlank = true;
	                				 if (statisView == 'STUDENTWISE') {
	                					 userTypeField.setVisible(true);
	                					 userTypeField.allowBlank = false;
	                					 userTypeField.labelSeparator='';
	                					 userTypeField.setFieldLabel(getFeeAndPaymentCommonTranslation('USER_TYPES')+': <span class="required" style="color:red"> *</span>');
	                					 //load user type field's store
	                					 var feePlanTypeFld = feeAndPaymentCommonFilter.down('customcombobox[itemId=feePlanType]');
	                					 var rec = feePlanTypeFld.getStore().findRecord('id', feePlanTypeFld.getValue());
	                					 feePlanTypeFld.fireEvent('select', null, [rec]);
	                				 }
	                				 userTypeField.validate();
	                				 userTypeField.clearInvalid();
	                			 }
	                		 },
	                		 'feeandpaymentcommonfilter customcombobox#feePlanType': {
	                			 select: function(obj, record) {
	                				 var feeAndPaymentCommonFilter = this.getFeeAndPaymentCommonFilter();
	                				 var feePlanTypeId = record[0].get("id");
	                				 var feePlanType = record[0].get("value");
	                				 var feeHead = feeAndPaymentCommonFilter.down("#feeHead");
	                				 var feeUserType = feeAndPaymentCommonFilter.down("#feeUserType");
	                				 var feeUserTypeStore = feeUserType.getStore();
	                				 var feeHeadStore = feeHead.getStore();
	                				 feeHead.clearValue();
	                				 feeUserType.clearValue();
	                				 feeUserTypeStore.getProxy().extraParams = {
	                					 feePlanType : feePlanType
	                				 };
	                				 feeUserTypeStore.load();

	                				 // fee head by fee plan type
	                				 feeHeadStore.getProxy().extraParams = {
	                					 feePlanTypeId : feePlanTypeId
	                				 };
	                				 feeHeadStore.load();
	                			 }
	                		 },
	                		 'feeandpaymentcommonfilter combo#programId': {
	                			 change: function(obj, newValue) {
	                				 var feeAndPaymentCommonFilter = this.getFeeAndPaymentCommonFilter();
	                				 var programId = obj.getValue().toString();
	                				 var batch = feeAndPaymentCommonFilter.down("#batchId");
	                				 batch.setDisabled(false);
	                				 batch.clearValue();
	                				 var batchStore = batch.getStore();
	                				 batchStore.getProxy().extraParams = {
	                					 programIds: programId
	                				 };
	                				 batchStore.load();
	                			 }
	                		 },
	                		 'panel[itemId=feechartpanelsbyacademies]': {
	                			 render: this.enlargeFeeChart
	                		 },
	                		 'panel[itemId=feechartpanelbylocation]': {
	                			 render: this.enlargeFeeChart
	                		 },
	                		 'panel[itemId=feechartpanelbycolumn]': {
	                			 render: this.enlargeFeeChart
	                		 },
	                		 'panel[itemId=feechartpanelallfeehead]': {
	                			 render: this.enlargeFeeChart
	                		 },
	                		 'panel[itemId=feechartpanelsbyacademiestwo]':{
	                			 render: this.enlargeFeeChart
	                		 },
	                		 'panel[itemId=feechartpanelbylocationtwo]':{
	                			 render: this.enlargeFeeChart
	                		 },
	                		 'organizationunit[itemId=organizationunitId] multiselectcombofield#academyLocationId': {
	                			 change: this.doLoadProgramStore
	                		 },
	                		 'organizationunit[itemId=organizationunitId] multiselectcombofield#multiselectAcademyLocationId': {
	                			 change: this.doLoadProgramStore
	                		 },
	                		 'organizationunit[itemId=organizationunitId] button[itemId=resetBtn]': {
	                			 click:function(obj,record){ 
	                				 this.resetOrganizationunit(obj);
	                			 }
	                		 },
	                		 'organizationunit[itemId=organizationunitId] radiogroup[itemId=organizationRadioUnitId]': {
	                			 change:function(obj,record){
	                				 this.organizationUnitChange(obj,record);
	                			 },
	                			 render:function(obj){
	                				 var permission = this.getFEEANDPAYMENTDASHBOARD_PERMISSIONS();
	                				 this.organizationUnitChange(obj,null,permission);
	                			 }
	                		 },
	                		 'feeandpaymentcommonfilter datefield[itemId=fromDate]': {
	                			 blur: function(field){
	                				 var fromDate = field.getValue();
	                				 var feeAndPaymentCommonFilter = this.getFeeAndPaymentCommonFilter();
	                				 var tillDateField = feeAndPaymentCommonFilter.down('#tillDate');
	                				 var minTillDate = new Date(fromDate);
	                				 var tillDate = tillDateField.getValue();
	                				 if(tillDate <= field.getValue()){
	                					 tillDateField.setValue(dateRender(minTillDate));
	                				 }
	                				 // tillDateField.setMinValue(minTillDate);
	                			 }
	                		 },
	                		 'feeandpaymentcommonfilter datefield[itemId=tillDate]': {
	                			 blur: function(field){
	                				 var tillDate = field.getValue();
	                				 var feeAndPaymentCommonFilter = this.getFeeAndPaymentCommonFilter();
	                				 var fromDateField = feeAndPaymentCommonFilter.down('#fromDate');
	                				 var minFromDate = new Date(tillDate);
	                				 var fromDate = fromDateField.getValue();
	                				 if(tillDate <=fromDate){
	                					 fromDateField.setValue(dateRender(minFromDate));
	                				 }
	                				 // fromDateField.setMinValue(minFromDate);
	                			 }
	                		 },
	                		 'paymentstatisticsfilter button[itemId=searchBtn] ': {
	                			 click: this.getSearchPaymentStatisticsFilter
	                		 },
	                		 'paymentstatisticsfilter button[itemId=resetBtn] ': {
	                			 click: function(obj){
	                				 obj.up('paymentstatisticsfilter').getForm().reset();
	                			 }
	                		 },
	                		 'paymentstatisticsfilter customcombobox[itemId=academicYear]': {
	                			 select: function(obj, record) {
	                				 var academyYearId = record[0].data.id;
	                				 this.setFromDateToDateByAcademyYear(obj,academyYearId)
	                			 }
	                		 },
	                	 });
	                 },
	                 /*
	                  * program will load based on logged in academy location or common filter
	                  */
	                 getLoadPrograms: function() {
	                	 var feeAndPaymentCommonFilter = this.getFeeAndPaymentCommonFilter();
	                	 var organizationUnit = this.getOrganizationUnit();
	                	 var organizationUnitForm = organizationUnit.getForm();
	                	 var academyLocation = organizationUnitForm.getValues();
	                	 var academyLocationId = null;
	                	 if (isEmpty(academyLocation["multiselectAcademyLocation"])) {
	                		 academyLocationId = this.getCurrentAcademyLocation();
	                	 } else {
	                		 academyLocationId = academyLocation.multiselectAcademyLocation;
	                	 }
	                	 var programStore = feeAndPaymentCommonFilter.down("#programId").getStore();
	                	 programStore.getProxy().extraParams = {
	                		 academyLocationId: academyLocationId
	                	 };
	                	 programStore.load();

	                	 var staticFor = feeAndPaymentCommonFilter.down("#showStaticFor");
	                	 staticFor.store.load({
	                		 callback: function(records, operation, success) {
	                			 if (success) {
	                				 staticFor.setValue(records[0].get("id"));
	                			 }
	                		 }
	                	 });

	                	 var staticView = feeAndPaymentCommonFilter.down("#showStaticView");
	                	 staticView.store.load({
	                		 callback: function(records, operation, success) {
	                			 if (success) {
	                				 staticView.setValue(records[0].get("id"));
	                			 }
	                		 }
	                	 });
	                	 var feeHead = feeAndPaymentCommonFilter.down("#feeHead");
	                	 var feeHeadStore = feeHead.getStore();
	                	 var feePlanType = feeAndPaymentCommonFilter.down("#feePlanType");
	                	 feePlanType.store.load({
	                		 callback: function(records, operation, success) {
	                			 if (success) {
	                				 feePlanType.setValue(records[1].get("id"));

	                				 feeHeadStore.getProxy().extraParams = {
	                					 feePlanTypeId: records[1].get("id")
	                				 };
	                				 feeHeadStore.load();  
	                			 }
	                		 }
	                	 });
	                 },
	                 /*
	                  * set default value for From Date & Till Date
	                  * From date should be one month before and
	                  * Till Date should be Current date
	                  */
	                 setFromAndTillDate: function(form) {
	                	 var date = new Date();
	                	 var fromdate = new Date(date.setMonth(date.getMonth() - 1));
	                	 form.down('#tillDate').setValue(new Date());
	                	 form.down('#fromDate').setValue(dateRender(fromdate));
	                 },
	                 /*
	                  * click on search button it will call for payment statistics dahsboard
	                  */
	                 getSearchPaymentStatisticsFilter : function(){
	                	 var structure = this.getFeeAndPaymentDashboardStructure();
	                	 var paymentFilter = this.getPaymentStatiSticsFilter();
	                	 var paymentStatiSticsField = paymentFilter.down("#paymentStatisticsType");
	                	 var paymentStatiSticsValue = paymentStatiSticsField.getValue();
	                	 var paymentStatiSticsRawValue = paymentStatiSticsField.getRawValue();


	                	 /**
	                	  * if stasticfor is collection ,stasticview if fee head wise and fee plan type is course or exam or service
	                	  */
	                	 if (paymentStatiSticsValue == 'ALL PAYMENT'){
	                		 var configCodeForAllAcademy = CONSTANTS.CB.FEE_DASHBOARD_PAYMENT_STATISTICS_ALL_PAYMENT_ACADEMY_CONFIG_CODE;
	                		 var configCodeForAllLocation = CONSTANTS.CB.FEE_DASHBOARD_PAYMENT_STATISTICS_ALL_PAYMENT_LOCATION_CONFIG_CODE;

	                		 this.getLoadPaymentStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadPaymentStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 paymentFilter.down("#paymentstatisticssTabpaneltwo").setVisible(true);

	                		 /**
	                		  * for this case -
	                		  * 
	                		  * show fee head chart 
	                		  * show fee head grid
	                		  * 
	                		  * hide user wise first grid 
	                		  * hide user wise second grid
	                		  * 
	                		  * */
	                	 }
	                	 if (paymentStatiSticsValue == 'PENDING PAYMENT'){
	                		 var configCodeForAllAcademy = CONSTANTS.CB.FEE_DASHBOARD_PAYMENT_STATISTICS_PENDING_PAYMENT_ACADEMY_CONFIG_CODE;
	                		 var configCodeForAllLocation = CONSTANTS.CB.FEE_DASHBOARD_PAYMENT_STATISTICS_PENDING_PAYMENT_LOCATION_CONFIG_CODE;

	                		 this.getLoadPaymentStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadPaymentStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 paymentFilter.down("#paymentstatisticssTabpaneltwo").setVisible(true);

	                		 /**
	                		  * for this case -
	                		  * 
	                		  * show fee head chart 
	                		  * show fee head grid
	                		  * 
	                		  * hide user wise first grid 
	                		  * hide user wise second grid
	                		  * 
	                		  * */
	                	 }

	                	 if (paymentStatiSticsValue == 'PAYMENT MADE'){
	                		 var configCodeForAllAcademy = CONSTANTS.CB.FEE_DASHBOARD_PAYMENT_STATISTICS_PAYMENT_MADE_ACADEMY_CONFIG_CODE;
	                		 var configCodeForAllLocation = CONSTANTS.CB.FEE_DASHBOARD_PAYMENT_STATISTICS_PAYMENT_MADE_LOCATION_CONFIG_CODE;

	                		 this.getLoadPaymentStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadPaymentStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 paymentFilter.down("#paymentstatisticssTabpaneltwo").setVisible(true);

	                		 /**
	                		  * for this case -
	                		  * 
	                		  * show fee head chart 
	                		  * show fee head grid
	                		  * 
	                		  * hide user wise first grid 
	                		  * hide user wise second grid
	                		  * 
	                		  * */
	                	 }
	                 },

	                 /*
	                  * click on search button it will call for fee statistics dahsboard
	                  */
	                 getSearchCommonFilterForm: function() {
	                	 var structure = this.getFeeAndPaymentDashboardStructure();
	                	 var feeAndPaymentCommonFilter = this.getFeeAndPaymentCommonFilter();
	                	 var showStaticForField = feeAndPaymentCommonFilter.down("#showStaticFor");
	                	 var showStaticFor = showStaticForField.getValue();
	                	 var staticForRawValue = showStaticForField.getRawValue();
	                	 var showStaticView = feeAndPaymentCommonFilter.down("#showStaticView").getValue();
	                	 var feePlanTypeId = feeAndPaymentCommonFilter.down("#feePlanType").getValue();
	                	 var feeUserTypeId = feeAndPaymentCommonFilter.down("#feeUserType").getValue();

	                	 this.getResultGridsContainer().removeAll(true, true);

	                	 structure.down("#feechartpanelbycolumn").setVisible(true);
	                	 structure.down("#resultGridsContainer").setVisible(true);


	                	 /**
	                	  * if stasticfor is collection ,stasticview if fee head wise and fee plan type is course or exam or service
	                	  */
	                	 if (showStaticFor == 'COLLECTIONS' && showStaticView == 'FEEHEADWISE' && (feePlanTypeId == 3 || feePlanTypeId == 4 || feePlanTypeId == 5)) {

	                		 var configCodeForAllAcademy = CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_HEADWISE_ALL_ACADEMY_CONFIGCODE;
	                		 var configCodeForAllLocation = CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_HEADWISE_ALL_LOCATION_CONFIGCODE;
	                		 var configCodeForAllProgram = CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_HEADWISE_ALL_PROGRAM_CONFIGCODE;
	                		 var configCodeForAllFeeHead = CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_HEADWISE_ALL_FEEHEAD_CONFIGCODE;
	                		 var configCodeForAllFeeHeadGrid = CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_HEAD_WISE_ALL_FEEHEAD_GRID_CONFIGCODE;

	                		 this.getLoadFeeStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadFeeStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 this.getLoadFeeStatiSticsByAllProgram(structure,configCodeForAllProgram);
	                		 this.getLoadFeeStatiSticsByAllFeeHead(structure,configCodeForAllFeeHead);
	                		 var grid = this.getLoadFeeStatiSticsByAllFeeHeadGrid(structure,configCodeForAllFeeHeadGrid);
	                		 this.toggleGridSummaryRow(grid,true);
	                		 this.setFirstGridConfiguration(grid,configCodeForAllFeeHeadGrid);
	                		 grid.setTitle(getFeeAndPaymentCommonTranslation('COLLECTION_BY_FEE_HEAD_DETAILS'));
	                		 structure.down("#paymentstatisticssTabpanel").setVisible(true);

	                		 /**
	                		  * for this case -
	                		  * 
	                		  * show fee head chart 
	                		  * show fee head grid
	                		  * 
	                		  * hide user wise first grid 
	                		  * hide user wise second grid
	                		  * 
	                		  * */
	                		 structure.down("#feechartpanelallfeehead").setVisible(true);
	                	 }

	                	 /**
	                	  * if stasticfor is collection ,stasticview if fee head wise and fee plan type is Application
	                	  */
	                	 else if(showStaticFor == 'COLLECTIONS' && showStaticView == 'FEEHEADWISE' && feePlanTypeId == 1) {

	                		 var configCodeForAllAcademy = CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_HEADWISE_APPLICATION_ACADEMY_CONFIGCODE;
	                		 var configCodeForAllLocation = CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_HEADWISE_APPLICATION_LOCATION_CONFIGCODE;
	                		 var configCodeForAllProgram = CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_HEADWISE_APPLICATION_PROGRAM_CONFIGCODE;
	                		 var configCodeForAllFeeHead = CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_HEADWISE_APPLICATION_FEEHEAD_CONFIGCODE;
	                		 var configCodeForAllFeeHeadGrid = CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_HEADWISE_APPLICATION_FEEHEAD_GRID_CONFIGCODE;

	                		 this.getLoadFeeStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadFeeStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 this.getLoadFeeStatiSticsByAllProgram(structure,configCodeForAllProgram);
	                		 this.getLoadFeeStatiSticsByAllFeeHead(structure,configCodeForAllFeeHead);
	                		 var grid = this.getLoadFeeStatiSticsByAllFeeHeadGrid(structure,configCodeForAllFeeHeadGrid);
	                		 this.toggleGridSummaryRow(grid,true);
	                		 this.setFirstGridConfiguration(grid,configCodeForAllFeeHeadGrid);
	                		 grid.setTitle(getFeeAndPaymentCommonTranslation('COLLECTION_BY_FEE_HEAD_DETAILS'));
	                		 structure.down("#paymentstatisticssTabpanel").setVisible(true);

	                		 /**
	                		  * for this case -
	                		  * 
	                		  * show fee head chart 
	                		  * show fee head grid
	                		  * 
	                		  * hide user wise first grid 
	                		  * hide user wise second grid
	                		  * 
	                		  * */
	                		 structure.down("#feechartpanelallfeehead").setVisible(true);
	                	 }
	                	 /**
	                	  * if stasticfor is collection ,stasticview if fee head wise and fee plan type is Program
	                	  */
	                	 else if(showStaticFor == 'COLLECTIONS' && showStaticView == 'FEEHEADWISE' && feePlanTypeId == 2) {

	                		 var configCodeForAllAcademy =  CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_HEADWISE_PROGRAM_ACADEMY_CONFIGCODE;
	                		 var configCodeForAllLocation =  CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_HEADWISE_PROGRAM_LOCATION_CONFIGCODE;
	                		 var configCodeForAllProgram = CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_HEADWISE_PROGRAM_PROGRAMS_CONFIGCODE;
	                		 var configCodeForAllFeeHead =  CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_HEADWISE_PROGRAM_FEEHEAD_CONFIGCODE;
	                		 var configCodeForAllFeeHeadGrid =  CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_HEADWISE_PROGRAM_FEEHEAD_GRID_CONFIGCODE;

	                		 this.getLoadFeeStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadFeeStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 this.getLoadFeeStatiSticsByAllProgram(structure,configCodeForAllProgram);
	                		 this.getLoadFeeStatiSticsByAllFeeHead(structure,configCodeForAllFeeHead);
	                		 var grid = this.getLoadFeeStatiSticsByAllFeeHeadGrid(structure,configCodeForAllFeeHeadGrid);
	                		 this.toggleGridSummaryRow(grid,true);
	                		 this.setFirstGridConfiguration(grid,configCodeForAllFeeHeadGrid);
	                		 grid.setTitle(getFeeAndPaymentCommonTranslation('COLLECTION_BY_FEE_HEAD_DETAILS'));
	                		 structure.down("#paymentstatisticssTabpanel").setVisible(true);

	                		 /**
	                		  * for this case -
	                		  * 
	                		  * show fee head chart 
	                		  * show fee head grid
	                		  * 
	                		  * hide user wise first grid 
	                		  * hide user wise second grid
	                		  * 
	                		  * */

	                		 structure.down("#feechartpanelallfeehead").setVisible(true);
	                	 }
	                	 /**
	                	  * if stasticfor is collection ,stasticview if fee head wise and fee plan type is Program/Application and 
	                	  * also fee user type is appplicant
	                	  */
	                	 else if(showStaticFor == 'COLLECTIONS' && showStaticView == 'STUDENTWISE' && feeUserTypeId=='APPLICANT'&& (feePlanTypeId == 1 || feePlanTypeId == 2)) {

	                		 var configCodeForAllAcademy = CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_USERWISE_APPLICANT_SUMMARY_ACADEMY_CONFIGCODE;
	                		 var configCodeForAllLocation =  CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_USERWISE_APPLICANT_SUMMARY_LOCATION_CONFIGCODE;
	                		 var configCodeForAllProgram = CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_USERWISE_APPLICANT_SUMMARY_PROGRAM_CONFIGCODE;
	                		 var configCodeForUserWiseFirstGrid =  CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_USERWISE_APPLICANT_DETAIL_FIRST_GRID_CONFIGCODE;
	                		 var configCodeForAllUserWiseSecondGrid = CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_USERWISE_APPLICANT_DETAIL_SECOND_GRID_CONFIGCODE;

	                		 this.getLoadFeeStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadFeeStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 this.getLoadFeeStatiSticsByAllProgram(structure,configCodeForAllProgram);
	                		 /**
	                		  * in below two methods first param for config code and second is for view code
	                		  * */
	                		 var gridOne = this.getLoadUserWiseFirstGrid(configCodeForUserWiseFirstGrid, configCodeForUserWiseFirstGrid);
	                		 var gridTwo = this.getLoadUserWiseSecondGrid(configCodeForAllUserWiseSecondGrid, configCodeForAllUserWiseSecondGrid);

	                		 this.toggleGridSummaryRow(gridOne,true);
	                		 this.toggleGridSummaryRow(gridTwo,true);
	                		 
	                		 this.setFirstGridConfiguration(gridOne,configCodeForUserWiseFirstGrid);
	                		 this.setSecondGridConfiguration(gridTwo,configCodeForAllUserWiseSecondGrid);

	                		 gridOne.setTitle(getFeeAndPaymentCommonTranslation('COLLECTION_BY_BATCH_DETAILS'));
	                		 gridTwo.setTitle(getFeeAndPaymentCommonTranslation('COLLECTION_BY_USER_DETAILS'));
	                		 structure.down("#paymentstatisticssTabpanel").setVisible(true);

	                		 /**
	                		  * for this case -
	                		  * 
	                		  * hide fee head chart 
	                		  * hide fee head grid
	                		  * 
	                		  * show user wise first grid 
	                		  * show user wise second grid
	                		  * 
	                		  * */

	                		 structure.down("#feechartpanelallfeehead").setVisible(false);
	                	 }
	                	 /**
	                	  * if stasticfor is collection ,stasticview if fee head wise and fee plan type is 
	                	  * Program/Course/Service/Exam  and also fee user type is student 
	                	  */
	                	 else if(showStaticFor == 'COLLECTIONS' && showStaticView == 'STUDENTWISE' && feeUserTypeId=='STUDENT' && (feePlanTypeId == 2 || feePlanTypeId == 3 || feePlanTypeId == 4 || feePlanTypeId == 5)) {

	                		 var configCodeForAllAcademy = CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_USERWISE_STUDENT_SUMMARY_ACADEMY_CONFIGCODE;
	                		 var configCodeForAllLocation =  CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_USERWISE_STUDENT_SUMMARY_LOCATION_CONFIGCODE;
	                		 var configCodeForAllProgram = CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_USERWISE_STUDENT_SUMMARY_PROGRAM_CONFIGCODE;
	                		 var configCodeForUserWiseFirstGrid =  CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_USERWISE_STUDENT_DETAIL_FIRST_GRID_CONFIGCODE;
	                		 var configCodeForAllUserWiseSecondGrid =  CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_USERWISE_STUDENT_DETAIL_SECOND_GRID_CONFIGCODE;

	                		 this.getLoadFeeStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadFeeStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 this.getLoadFeeStatiSticsByAllProgram(structure,configCodeForAllProgram);
	                		 /**
	                		  * in below two methods first param for config code and second is for view code
	                		  * */
	                		 var gridOne = this.getLoadUserWiseFirstGrid(configCodeForUserWiseFirstGrid, configCodeForUserWiseFirstGrid);
	                		 var gridTwo = this.getLoadUserWiseSecondGrid(configCodeForAllUserWiseSecondGrid, configCodeForAllUserWiseSecondGrid);

	                		 this.toggleGridSummaryRow(gridOne,true);
	                		 this.toggleGridSummaryRow(gridTwo,true);
	                		 
	                		 this.setFirstGridConfiguration(gridOne,configCodeForUserWiseFirstGrid);
	                		 this.setSecondGridConfiguration(gridTwo,configCodeForAllUserWiseSecondGrid);
	                		 gridOne.setTitle(getFeeAndPaymentCommonTranslation('COLLECTION_BY_BATCH_DETAILS'));
	                		 gridTwo.setTitle(getFeeAndPaymentCommonTranslation('COLLECTION_BY_USER_DETAILS'));
	                		 structure.down("#paymentstatisticssTabpanel").setVisible(true);

	                		 /**
	                		  * for this case -
	                		  * 
	                		  * hide fee head chart 
	                		  * hide fee head grid
	                		  * 
	                		  * show user wise first grid 
	                		  * show user wise second grid
	                		  * 
	                		  * */

	                		 structure.down("#feechartpanelallfeehead").setVisible(false);
	                		 //structure.down("#feecollectionheadwiseallfeeheadgrid").setVisible(false);

	                		 //this.getCollectionUserWiseFirstGrid().setTitle(getFeeAndPaymentCommonTranslation('COLLECTION_BY_BATCH_DETAILS'));
	                		 //this.getCollectionUserWiseSecondGrid().setTitle(getFeeAndPaymentCommonTranslation('COLLECTION_BY_USER_DETAILS'));
	                		 //this.getCollectionUserWiseFirstGrid().setVisible(true);
	                		 //this.getCollectionUserWiseSecondGrid().setVisible(true);
	                	 }
	                	 /**
	                	  * if stasticfor is collection ,stastic view is user wise if fee head wise and fee plan type is 
	                	  * Program/Course/Service/Exam  and also fee user type is sponsor 
	                	  */
	                	 else if(showStaticFor == 'COLLECTIONS' && showStaticView == 'STUDENTWISE' && feeUserTypeId=='SPONSOR' && (feePlanTypeId == 2 || feePlanTypeId == 3 || feePlanTypeId == 4 || feePlanTypeId == 5)) {

	                		 var configCodeForAllAcademy = CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_USER_WISE_SPONSOR_SUMMARY_ACADEMY_CONFIGCODE;
	                		 var configCodeForAllLocation =  CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_USERWISE_SPONSOR_SUMMARY_LOCATION_CONFIGCODE;
	                		 var configCodeForAllProgram = CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_USERWISE_SPONSOR_SUMMARY_PROGRAM_CONFIGCODE;
	                		 var configCodeForUserWiseFirstGrid =  CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_USERWISE_SPONSOR_DETAIL_FIRST_GRID_CONFIGCODE;
	                		 var configCodeForAllUserWiseSecondGrid =  CONSTANTS.CB.FEE_DASHBOARD_COLLECTION_USERWISE_SPONSOR_DETAIL_SECOND_GRID_CONFIGCODE;

	                		 this.getLoadFeeStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadFeeStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 this.getLoadFeeStatiSticsByAllProgram(structure,configCodeForAllProgram);
	                		 var gridOne = this.getLoadUserWiseFirstGrid(configCodeForUserWiseFirstGrid, configCodeForUserWiseFirstGrid);
	                		 var gridTwo = this.getLoadUserWiseSecondGrid(configCodeForAllUserWiseSecondGrid, configCodeForAllUserWiseSecondGrid);
	                		
	                		 this.toggleGridSummaryRow(gridOne,true);
	                		 this.toggleGridSummaryRow(gridTwo,true);
	                		 
	                		 this.setFirstGridConfiguration(gridOne,configCodeForUserWiseFirstGrid);
	                		 this.setSecondGridConfiguration(gridTwo,configCodeForAllUserWiseSecondGrid);
	                		 gridOne.setTitle(getFeeAndPaymentCommonTranslation('COLLECTION_BY_BATCH_DETAILS'));
	                		 gridTwo.setTitle(getFeeAndPaymentCommonTranslation('COLLECTION_BY_USER_DETAILS'));
	                		 structure.down("#paymentstatisticssTabpanel").setVisible(true);

	                		 /**
	                		  * for this case -
	                		  * 
	                		  * hide fee head chart 
	                		  * hide fee head grid
	                		  * 
	                		  * show user wise first grid 
	                		  * show user wise second grid
	                		  * 
	                		  * */

	                		 structure.down("#feechartpanelallfeehead").setVisible(false);
	                	 }
	                	 /**
	                	  * if stasticfor is bill , stastic view is fee head wise and fee plan type is 
	                	  * Course/Service/Exam  
	                	  */
	                	 else if(showStaticFor == 'BILLS' && showStaticView == 'FEEHEADWISE' && (feePlanTypeId == 3 || feePlanTypeId == 4 || feePlanTypeId == 5)) {

	                		 var configCodeForAllAcademy =  CONSTANTS.CB.FEE_DASHBOARD_BILL_HEADWISE_ALL_ACADEMY_CONFIGCODE;
	                		 var configCodeForAllLocation =   CONSTANTS.CB.FEE_DASHBOARD_BILL_HEADWISE_ALL_LOCATION_CONFIG_CODE;
	                		 var configCodeForAllProgram =  CONSTANTS.CB.FEE_DASHBOARD_BILL_HEADWISE_ALL_PROGRAM_CONFIG_CODE;
	                		 var configCodeForAllFeeHead =   CONSTANTS.CB.FEE_DASHBOARD_BILL_HEADWISE_ALL_FEEHEAD_CONFIG_CODE;
	                		 var configCodeForAllFeeHeadGrid =   CONSTANTS.CB.FEE_DASHBOARD_BILL_HEADWISE_ALL_FEEHEAD_GRID_CONFIG_CODE;

	                		 this.getLoadFeeStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadFeeStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 this.getLoadFeeStatiSticsByAllProgram(structure,configCodeForAllProgram);
	                		 this.getLoadFeeStatiSticsByAllFeeHead(structure,configCodeForAllFeeHead);
	                		 var grid = this.getLoadBillFeeStatiSticsByAllFeeHeadGrid(structure,configCodeForAllFeeHead);
	                		
	                		 this.toggleGridSummaryRow(grid,true);
	                		 
	                		 this.setFirstGridConfiguration(grid,configCodeForAllFeeHead);
	                		 grid.setTitle(getFeeAndPaymentCommonTranslation('BILL_BY_FEE_HEAD_DETAILS'));
	                		 //this.getFeeBillHeadWiseAllFeeHeadGrid().setVisible(true);
	                		 structure.down("#paymentstatisticssTabpanel").setVisible(true);

	                		 /**
	                		  * for this case -
	                		  * 
	                		  * show fee head chart 
	                		  * show fee head grid
	                		  * 
	                		  * hide user wise first grid 
	                		  * hide user wise second grid
	                		  * 
	                		  * */

	                		 structure.down("#feechartpanelallfeehead").setVisible(true);

	                	 }
	                	 /**
	                	  * if stasticfor is bill , stastic view is fee head wise and fee plan type is Application
	                	  */
	                	 else if(showStaticFor == 'BILLS' && showStaticView == 'FEEHEADWISE' && feePlanTypeId ==1) {

	                		 var configCodeForAllAcademy =  CONSTANTS.CB.FEE_DASHBOARD_BILL_HEADWISE_APPLICATION_ACADEMY_CONFIG_CODE;
	                		 var configCodeForAllLocation =   CONSTANTS.CB.FEE_DASHBOARD_BILL_HEADWISE_APPLICATION_LOCATION_CONFIG_CODE;
	                		 var configCodeForAllProgram =  CONSTANTS.CB.FEE_DASHBOARD_BILL_HEADWISE_APPLICATION_PROGRAM_CONFIG_CODE;
	                		 var configCodeForAllFeeHead =   CONSTANTS.CB.FEE_DASHBOARD_BILL_HEADWISE_APPLICATION_FEEHEAD_CONFIG_CODE;
	                		 var configCodeForAllFeeHeadGrid =   CONSTANTS.CB.FEE_DASHBOARD_BILL_HEADWISE_APPLICATION_FEEHEAD_GRID_CONFIG_CODE;

	                		 this.getLoadFeeStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadFeeStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 this.getLoadFeeStatiSticsByAllProgram(structure,configCodeForAllProgram);
	                		 this.getLoadFeeStatiSticsByAllFeeHead(structure,configCodeForAllFeeHead);
	                		 //this.getLoadFeeStatiSticsByAllFeeHeadGrid(structure,configCodeForAllFeeHeadGrid);
	                		 var grid = this.getLoadBillFeeStatiSticsByAllFeeHeadGrid(structure,configCodeForAllFeeHead);
	                		 
	                		 this.toggleGridSummaryRow(grid,true);
	                		 
	                		 this.setFirstGridConfiguration(grid,configCodeForAllFeeHead);
	                		 grid.setTitle(getFeeAndPaymentCommonTranslation('BILL_BY_FEE_HEAD_DETAILS'));
	                		 //this.getFeeBillHeadWiseAllFeeHeadGrid().setVisible(true);
	                		 structure.down("#paymentstatisticssTabpanel").setVisible(true);

	                		 /**
	                		  * for this case -
	                		  * 
	                		  * show fee head chart 
	                		  * show fee head grid
	                		  * 
	                		  * hide user wise first grid 
	                		  * hide user wise second grid
	                		  * 
	                		  * */

	                		 structure.down("#feechartpanelallfeehead").setVisible(true);
	                		 //structure.down("#feecollectionheadwiseallfeeheadgrid").setVisible(true);
	                		 //this.getFeeCollectionHeadWiseAllFeeHeadGrid().setVisible(true);

	                	 }

	                	 /**
	                	  * if stasticfor is bill , stastic view is fee head wise and fee plan type is Program
	                	  */
	                	 else if(showStaticFor == 'BILLS' && showStaticView == 'FEEHEADWISE' && feePlanTypeId ==2) {

	                		 var configCodeForAllAcademy =  CONSTANTS.CB.FEE_DASHBOARD_BILL_HEADWISE_PROGRAM_ACADEMY_CONFIG_CODE;
	                		 var configCodeForAllLocation =   CONSTANTS.CB.FEE_DASHBOARD_BILL_HEADWISE_PROGRAM_LOCATION_CONFIG_CODE;
	                		 var configCodeForAllProgram =  CONSTANTS.CB.FEE_DASHBOARD_BILL_HEADWISE_PROGRAM_PROGRAMS_CONFIG_CODE;
	                		 var configCodeForAllFeeHead =   CONSTANTS.CB.FEE_DASHBOARD_BILL_HEADWISE_PROGRAM_FEEHEAD_CONFIG_CODE;
	                		 var configCodeForAllFeeHeadGrid =   CONSTANTS.CB.FEE_DASHBOARD_BILL_HEADWISE_PROGRAM_FEEHEAD_GRID_CONFIG_CODE;

	                		 this.getLoadFeeStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadFeeStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 this.getLoadFeeStatiSticsByAllProgram(structure,configCodeForAllProgram);
	                		 this.getLoadFeeStatiSticsByAllFeeHead(structure,configCodeForAllFeeHead);
	                		 //this.getLoadFeeStatiSticsByAllFeeHeadGrid(structure,configCodeForAllFeeHeadGrid);
	                		 var grid = this.getLoadBillFeeStatiSticsByAllFeeHeadGrid(structure,configCodeForAllFeeHead);
	                		 
	                		 this.toggleGridSummaryRow(grid,true);
	                		 
	                		 this.setFirstGridConfiguration(grid,configCodeForAllFeeHead);
	                		 grid.setTitle(getFeeAndPaymentCommonTranslation('BILL_BY_FEE_HEAD_DETAILS'));
	                		 //this.getFeeBillHeadWiseAllFeeHeadGrid().setVisible(true);
	                		 structure.down("#paymentstatisticssTabpanel").setVisible(true);

	                		 /**
	                		  * for this case -
	                		  * 
	                		  * show fee head chart 
	                		  * show fee head grid
	                		  * 
	                		  * hide user wise first grid 
	                		  * hide user wise second grid
	                		  * 
	                		  * */

	                		 structure.down("#feechartpanelallfeehead").setVisible(true);
	                		 //structure.down("#feecollectionheadwiseallfeeheadgrid").setVisible(true);
	                		 //this.getFeeCollectionHeadWiseAllFeeHeadGrid().setVisible(true);

	                	 }

	                	 /**
	                	  * if stasticfor is bill , stastic view is fee USERWISE  and fee plan type is Application ,Program
	                	  */
	                	 else if(showStaticFor == 'BILLS' && showStaticView == 'STUDENTWISE' && feeUserTypeId=='APPLICANT' && (feePlanTypeId ==2 || feePlanTypeId ==1)) {

	                		 var configCodeForAllAcademy =  CONSTANTS.CB.FEE_DASHBOARD_BILL_USERWISE_APPLICANT_SUMMARY_ACADEMY_CONFIG_CODE;
	                		 var configCodeForAllLocation =   CONSTANTS.CB.FEE_DASHBOARD_BILL_USERWISE_APPLICANT_SUMMARY_LOCATION_CONFIG_CODE;
	                		 var configCodeForAllProgram =  CONSTANTS.CB.FEE_DASHBOARD_BILL_USERWISE_APPLICANT_SUMMARY_PROGRAM_CONFIG_CODE;
	                		 var configCodeForUserWiseFirstGrid =   CONSTANTS.CB.FEE_DASHBOARD_BILL_USERWISE_APPLICANT_DETAIL_FIRST_GRID_CONFIG_CODE;
	                		 var configCodeForAllUserWiseSecondGrid =   CONSTANTS.CB.FEE_DASHBOARD_BILL_USERWISE_APPLICANTDETAIL_SECOND_GRID_CONFIG_CODE;

	                		 this.getLoadFeeStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadFeeStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 this.getLoadFeeStatiSticsByAllProgram(structure,configCodeForAllProgram);
	                		 //this.getLoadFeeStatiSticsByAllFeeHead(structure,configCodeForAllFeeHead);
	                		 //this.getLoadFeeStatiSticsByAllFeeHeadGrid(structure,configCodeForAllFeeHeadGrid);
	                		 var gridOne = this.getLoadBillUserWiseFirstGrid(configCodeForUserWiseFirstGrid, configCodeForUserWiseFirstGrid);
	                		 var gridTwo = this.getLoadBillUserWiseSecondGrid(configCodeForAllUserWiseSecondGrid, configCodeForAllUserWiseSecondGrid);

	                		 this.toggleGridSummaryRow(gridOne,true);
	                		 this.toggleGridSummaryRow(gridTwo,true);
	                		 
	                		 this.setFirstGridConfiguration(gridOne,configCodeForUserWiseFirstGrid);
	                		 this.setSecondGridConfiguration(gridTwo,configCodeForAllUserWiseSecondGrid);
	                		 gridOne.setTitle(getFeeAndPaymentCommonTranslation('BILL_BY_BATCH_DETAILS'));
	                		 gridTwo.setTitle(getFeeAndPaymentCommonTranslation('BILL_BY_USER_DETAILS'));
	                		 structure.down("#paymentstatisticssTabpanel").setVisible(true);
	                		 /**
	                		  * for this case -
	                		  * 
	                		  * hide fee head chart 
	                		  * hide fee head grid
	                		  * 
	                		  * show user wise first grid 
	                		  * show user wise second grid
	                		  * 
	                		  * */

	                		 structure.down("#feechartpanelallfeehead").setVisible(false);
	                		 //structure.down("#feecollectionheadwiseallfeeheadgrid").setVisible(false);

	                		 //this.getBillUserWiseFirstGrid().setTitle(getFeeAndPaymentCommonTranslation('BILL_BY_BATCH_DETAILS'));
	                		 //this.getBillUserWiseSecondGrid().setTitle(getFeeAndPaymentCommonTranslation('BILL_BY_USER_DETAILS'));
	                		 //this.getBillUserWiseFirstGrid().setVisible(true);
	                		 //this.getBillUserWiseSecondGrid().setVisible(true);
	                	 }

	                	 /**
	                	  * if stasticfor is bill , stastic view is fee USERWISE  and fee plan type is Program,Service,Course,Exam - here
	                	  */
	                	 else if(showStaticFor == 'BILLS' && showStaticView == 'STUDENTWISE'  && feeUserTypeId=='STUDENT' && (feePlanTypeId ==2 || feePlanTypeId ==3 || feePlanTypeId ==4 || feePlanTypeId ==5)) {

	                		 var configCodeForAllAcademy =  CONSTANTS.CB.FEE_DASHBOARD_BILL_USERWISE_STUDENT_SUMMARY_ACADEMY_CONFIG_CODE;
	                		 var configCodeForAllLocation =   CONSTANTS.CB.FEE_DASHBOARD_BILL_USERWISE_STUDENT_SUMMARY_LOCATION_CONFIG_CODE;
	                		 var configCodeForAllProgram =  CONSTANTS.CB.FEE_DASHBOARD_BILL_USERWISE_STUDENT_SUMMARY_PROGRAM_CONFIG_CODE;
	                		 var configCodeForUserWiseFirstGrid =   CONSTANTS.CB.FEE_DASHBOARD_BILL_USERWISE_STUDENT_DETAIL_FIRST_GRID_CONFIG_CODE;
	                		 var configCodeForAllUserWiseSecondGrid =   CONSTANTS.CB.FEE_DASHBOARD_BILL_USERWISE_STUDENT_DETAIL_SECOND_GRID_CONFIG_CODE;

	                		 this.getLoadFeeStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadFeeStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 this.getLoadFeeStatiSticsByAllProgram(structure,configCodeForAllProgram);
	                		 var gridOne = this.getLoadBillUserWiseFirstGrid(configCodeForUserWiseFirstGrid,configCodeForUserWiseFirstGrid);
	                		 var gridTwo = this.getLoadBillUserWiseSecondGrid(configCodeForAllUserWiseSecondGrid,configCodeForAllUserWiseSecondGrid);
	                		
	                		 this.toggleGridSummaryRow(gridOne,true);
	                		 this.toggleGridSummaryRow(gridTwo,true);
	                		 
	                		 this.setFirstGridConfiguration(gridOne,configCodeForUserWiseFirstGrid);
	                		 this.setSecondGridConfiguration(gridTwo,configCodeForAllUserWiseSecondGrid);
	                		 gridOne.setTitle(getFeeAndPaymentCommonTranslation('BILL_BY_BATCH_DETAILS'));
	                		 gridTwo.setTitle(getFeeAndPaymentCommonTranslation('BILL_BY_USER_DETAILS'));
	                		 structure.down("#paymentstatisticssTabpanel").setVisible(true);

	                		 /**
	                		  * for this case -
	                		  * 
	                		  * hide fee head chart 
	                		  * hide fee head grid
	                		  * 
	                		  * show user wise first grid 
	                		  * show user wise second grid
	                		  * 
	                		  * */

	                		 structure.down("#feechartpanelallfeehead").setVisible(false);
	                		 //structure.down("#feecollectionheadwiseallfeeheadgrid").setVisible(false);

	                		 //this.getBillUserWiseFirstGrid().setTitle(getFeeAndPaymentCommonTranslation('BILL_BY_BATCH_DETAILS'));
	                		 //this.getBillUserWiseSecondGrid().setTitle(getFeeAndPaymentCommonTranslation('BILL_BY_USER_DETAILS'));
	                		 //this.getBillUserWiseFirstGrid().setVisible(true);
	                		 //this.getBillUserWiseSecondGrid().setVisible(true);
	                	 }

	                	 /**
	                	  * if stasticfor is bill , stastic view is fee USERWISE  and fee plan type is Program,Service,Course,Exam
	                	  */
	                	 else if(showStaticFor == 'BILLS' && showStaticView == 'STUDENTWISE' && feeUserTypeId=='SPONSOR' && (feePlanTypeId ==2 || feePlanTypeId ==3 || feePlanTypeId ==4 || feePlanTypeId ==5)) {

	                		 var configCodeForAllAcademy =  CONSTANTS.CB.FEE_DASHBOARD_BILL_USERWISE_SPONSOR_SUMMARY_ACADEMY_CONFIG_CODE;
	                		 var configCodeForAllLocation =   CONSTANTS.CB.FEE_DASHBOARD_BILL_USERWISE_SPONSOR_SUMMARY_LOCATION_CONFIG_CODE;
	                		 var configCodeForAllProgram =  CONSTANTS.CB.FEE_DASHBOARD_BILL_USERWISE_SPONSOR_SUMMARY_PROGRAM_CONFIG_CODE;
	                		 var configCodeForUserWiseFirstGrid = CONSTANTS.CB.FEE_DASHBOARD_BILL_USERWISE_SPONSOR_DETAIL_FIRST_GRID_CONFIG_CODE;
	                		 var configCodeForAllUserWiseSecondGrid =   CONSTANTS.CB.FEE_DASHBOARD_BILL_USERWISE_SPONSOR_DETAIL_SECOND_GRID_CONFIG_CODE;

	                		 this.getLoadFeeStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadFeeStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 this.getLoadFeeStatiSticsByAllProgram(structure,configCodeForAllProgram);

	                		 var gridOne = this.getLoadBillUserWiseFirstGrid(configCodeForUserWiseFirstGrid,configCodeForUserWiseFirstGrid);
	                		 var gridTwo = this.getLoadBillUserWiseSecondGrid(configCodeForAllUserWiseSecondGrid,configCodeForAllUserWiseSecondGrid);
	                		
	                		 this.toggleGridSummaryRow(gridOne,true);
	                		 this.toggleGridSummaryRow(gridTwo,true);
	                		 
	                		 this.setFirstGridConfiguration(gridOne,configCodeForUserWiseFirstGrid);
	                		 this.setSecondGridConfiguration(gridTwo,configCodeForAllUserWiseSecondGrid);
	                		 gridOne.setTitle(getFeeAndPaymentCommonTranslation('BILL_BY_BATCH_DETAILS'));
	                		 gridTwo.setTitle(getFeeAndPaymentCommonTranslation('BILL_BY_USER_DETAILS'));
	                		 //this.getLoadFeeStatiSticsByAllFeeHeadGrid(structure,configCodeForAllFeeHeadGrid);
	                		 structure.down("#paymentstatisticssTabpanel").setVisible(true);

	                		 /**
	                		  * for this case -
	                		  * 
	                		  * show fee head chart 
	                		  * show fee head grid
	                		  * 
	                		  * hide user wise first grid 
	                		  * hide user wise second grid
	                		  * 
	                		  * */

	                		 structure.down("#feechartpanelallfeehead").setVisible(false);
	                		 //structure.down("#feecollectionheadwiseallfeeheadgrid").setVisible(true);

	                		 //this.getBillUserWiseFirstGrid().setTitle(getFeeAndPaymentCommonTranslation('BILL_BY_BATCH_DETAILS'));
	                		 //this.getBillUserWiseSecondGrid().setTitle(getFeeAndPaymentCommonTranslation('BILL_BY_USER_DETAILS'));
	                		 //this.getBillUserWiseFirstGrid().setVisible(true);
	                		 //this.getBillUserWiseSecondGrid().setVisible(true);
	                	 }

	                	 /**
	                	  * if stasticfor is OUTSTANDING , stastic view is fee FEEHEAD  and fee plan type is Service,Course,Exam
	                	  */
	                	 else if(showStaticFor == 'OUTSTANDING' && showStaticView == 'FEEHEADWISE' &&  (feePlanTypeId ==3 || feePlanTypeId ==4 || feePlanTypeId ==5)) {

	                		 var configCodeForAllAcademy =  CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_HEADWISE_ALL_ACADEMY_CONFIG_CODE;
	                		 var configCodeForAllLocation =   CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_HEADWISE_ALL_LOCATION_CONFIG_CODE;
	                		 var configCodeForAllProgram =  CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_HEADWISE_ALL_PROGRAM_CONFIG_CODE;
	                		 var configCodeForAllFeeHead =   CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_HEADWISE_ALL_FEEHEAD_CONFIG_CODE;
	                		 var configCodeForAllFeeHeadGrid =   CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_HEADWISE_ALL_FEEHEAD_GRID_CONFIG_CODE;

	                		 this.getLoadFeeStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadFeeStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 this.getLoadFeeStatiSticsByAllProgram(structure,configCodeForAllProgram);
	                		 this.getLoadFeeStatiSticsByAllFeeHead(structure,configCodeForAllFeeHead);
	                		 var grid = this.getLoadFeeStatiSticsByAllFeeHeadGrid(structure,configCodeForAllFeeHeadGrid);
	                		 this.toggleGridSummaryRow(grid,true);
	                		 this.setFirstGridConfiguration(grid,configCodeForAllFeeHeadGrid);
	                		 grid.setTitle(getFeeAndPaymentCommonTranslation('OUT_STANDING_BY_FEE_HEAD_DETAILS'));
	                		 structure.down("#paymentstatisticssTabpanel").setVisible(true);

	                		 /**
	                		  * for this case -
	                		  * 
	                		  * show fee head chart 
	                		  * show fee head grid
	                		  * 
	                		  * hide user wise first grid 
	                		  * hide user wise second grid
	                		  * 
	                		  * */

	                		 structure.down("#feechartpanelallfeehead").setVisible(true);
	                		 //structure.down("#feecollectionheadwiseallfeeheadgrid").setVisible(true);
	                		 //this.getFeeOutstandingHeadWiseAllFeeHeadGrid().setTitle(getFeeAndPaymentCommonTranslation('OUT_STANDING_BY_FEE_HEAD_DETAILS'));
	                		 //this.getFeeOutstandingHeadWiseAllFeeHeadGrid().setVisible(true);

	                	 }

	                	 /**
	                	  * if stasticfor is OUTSTANDING , stastic view is fee FEEHEAD  and fee plan type is Apllication
	                	  */
	                	 else if(showStaticFor == 'OUTSTANDING' && showStaticView == 'FEEHEADWISE' &&  feePlanTypeId ==1 ) {

	                		 var configCodeForAllAcademy =  CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_HEADWISE_APPLICATION_ACADEMY_CONFIG_CODE;
	                		 var configCodeForAllLocation =   CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_HEADWISE_APPLICATION_LOCATION_CONFIG_CODE;
	                		 var configCodeForAllProgram =  CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_HEADWISE_APPLICATION_PROGRAM_CONFIG_CODE;
	                		 var configCodeForAllFeeHead =   CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_HEADWISE_APPLICATION_FEEHEAD_CONFIG_CODE;
	                		 var configCodeForAllFeeHeadGrid =   CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_HEADWISE_APPLICATION_FEEHEAD_GRID_CONFIG_CODE;

	                		 this.getLoadFeeStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadFeeStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 this.getLoadFeeStatiSticsByAllProgram(structure,configCodeForAllProgram);
	                		 this.getLoadFeeStatiSticsByAllFeeHead(structure,configCodeForAllFeeHead);
	                		 var grid = this.getLoadOutstandingFeeStatiSticsByAllFeeHeadGrid(structure,configCodeForAllFeeHeadGrid);
	                		 this.toggleGridSummaryRow(grid,true);
	                		 this.setFirstGridConfiguration(grid,configCodeForAllFeeHeadGrid);
	                		 grid.setTitle(getFeeAndPaymentCommonTranslation('OUT_STANDING_BY_FEE_HEAD_DETAILS'));
	                		 structure.down("#paymentstatisticssTabpanel").setVisible(true);

	                		 /**
	                		  * for this case -
	                		  * 
	                		  * show fee head chart 
	                		  * show fee head grid
	                		  * 
	                		  * hide user wise first grid 
	                		  * hide user wise second grid
	                		  * 
	                		  * */

	                		 structure.down("#feechartpanelallfeehead").setVisible(true);
	                		 //structure.down("#feecollectionheadwiseallfeeheadgrid").setVisible(true);
	                		 //this.getFeeOutstandingHeadWiseAllFeeHeadGrid().setTitle(getFeeAndPaymentCommonTranslation('OUT_STANDING_BY_FEE_HEAD_DETAILS'));
	                		 //this.getFeeOutstandingHeadWiseAllFeeHeadGrid().setVisible(true);
	                	 }

	                	 /**
	                	  * if stasticfor is OUTSTANDING , stastic view is fee FEEHEAD  and fee plan type is Program
	                	  */
	                	 else if(showStaticFor == 'OUTSTANDING' && showStaticView == 'FEEHEADWISE' &&  feePlanTypeId ==2 ) {

	                		 var configCodeForAllAcademy =  CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_HEADWISE_PROGRAM_ACADEMY_CONFIG_CODE;
	                		 var configCodeForAllLocation =   CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_HEADWISE_PROGRAM_LOCATION_CONFIG_CODE;
	                		 var configCodeForAllProgram =  CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_HEADWISE_PROGRAM_PROGRAMS_CONFIG_CODE;
	                		 var configCodeForAllFeeHead =   CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_HEADWISE_PROGRAM_FEEHEAD_CONFIG_CODE;
	                		 var configCodeForAllFeeHeadGrid =   CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_HEADWISE_PROGRAM_FEEHEAD_GRID_CONFIG_CODE;

	                		 this.getLoadFeeStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadFeeStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 this.getLoadFeeStatiSticsByAllProgram(structure,configCodeForAllProgram);
	                		 this.getLoadFeeStatiSticsByAllFeeHead(structure,configCodeForAllFeeHead);
	                		 var grid = this.getLoadOutstandingFeeStatiSticsByAllFeeHeadGrid(structure,configCodeForAllFeeHeadGrid);
	                		 this.toggleGridSummaryRow(grid,true);
	                		 this.setFirstGridConfiguration(grid,configCodeForAllFeeHeadGrid);
	                		 grid.setTitle(getFeeAndPaymentCommonTranslation('OUT_STANDING_BY_FEE_HEAD_DETAILS'));
	                		 structure.down("#paymentstatisticssTabpanel").setVisible(true);

	                		 /**
	                		  * for this case -
	                		  * 
	                		  * show fee head chart 
	                		  * show fee head grid
	                		  * 
	                		  * hide user wise first grid 
	                		  * hide user wise second grid
	                		  * 
	                		  * */

	                		 structure.down("#feechartpanelallfeehead").setVisible(true);
	                		 //structure.down("#feecollectionheadwiseallfeeheadgrid").setVisible(true);
	                		 //this.getFeeOutstandingHeadWiseAllFeeHeadGrid().setTitle(getFeeAndPaymentCommonTranslation('OUT_STANDING_BY_FEE_HEAD_DETAILS'));
	                		 //this.getFeeOutstandingHeadWiseAllFeeHeadGrid().setVisible(true);
	                	 }

	                	 /**
	                	  * if stasticfor is OUTSTANDING , stastic view is fee FEEHEAD  and fee plan type is Program
	                	  */
	                	 else if(showStaticFor == 'OUTSTANDING' && showStaticView == 'STUDENTWISE' && feeUserTypeId=='STUDENT'   &&  (feePlanTypeId ==2 || feePlanTypeId ==3 || feePlanTypeId ==4 || feePlanTypeId ==5) ) {

	                		 var configCodeForAllAcademy =  CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_USERWISE_STUDENT_SUMMARY_ACADEMY_CONFIG_CODE;
	                		 var configCodeForAllLocation =   CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_USERWISE_STUDENT_SUMMARY_LOCATION_CONFIG_CODE;
	                		 var configCodeForAllProgram =  CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_USERWISE_STUDENT_SUMMARY_PROGRAM_CONFIG_CODE;
	                		 var configCodeForUserWiseFirstGrid =   CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_USERWISE_STUDENT_DETAIL_FIRST_GRID_CONFIG_CODE;
	                		 var configCodeForAllUserWiseSecondGrid =   CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_USERWISE_STUDENT_DETAIL_SECOND_GRID_CONFIG_CODE;

	                		 this.getLoadFeeStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadFeeStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 this.getLoadFeeStatiSticsByAllProgram(structure,configCodeForAllProgram);
	                		 //this.getLoadFeeStatiSticsByAllFeeHead(structure,configCodeForAllFeeHead);
	                		 //this.getLoadFeeStatiSticsByAllFeeHeadGrid(configCodeForAllUserWiseSecondGrid,configCodeForAllUserWiseSecondGrid);
	                		 var gridOne = this.getLoadOutstandingUserWiseFirstGrid(configCodeForUserWiseFirstGrid,configCodeForUserWiseFirstGrid);
	                		 var gridTwo = this.getLoadOutstandingUserWiseSecondGrid(configCodeForAllUserWiseSecondGrid,configCodeForAllUserWiseSecondGrid);
	                		 
	                		 this.toggleGridSummaryRow(gridOne,true);
	                		 this.toggleGridSummaryRow(gridTwo,true);
	                		 
	                		 this.setFirstGridConfiguration(gridOne,configCodeForUserWiseFirstGrid);
	                		 this.setSecondGridConfiguration(gridTwo,configCodeForAllUserWiseSecondGrid);
	                		 gridOne.setTitle(getFeeAndPaymentCommonTranslation('OUT_STANDING_BY_BATCH_DETAILS'));
	                		 gridTwo.setTitle(getFeeAndPaymentCommonTranslation('OUT_STANDING_BY_USER_DETAILS'));
	                		 structure.down("#paymentstatisticssTabpanel").setVisible(true);

	                		 /**
	                		  * for this case -
	                		  * 
	                		  * show fee head chart 
	                		  * show fee head grid
	                		  * 
	                		  * hide user wise first grid 
	                		  * hide user wise second grid
	                		  * 
	                		  * */

	                		 structure.down("#feechartpanelallfeehead").setVisible(false);
	                		 //structure.down("#feecollectionheadwiseallfeeheadgrid").setVisible(true);

	                		 //this.getOutStandingUserWiseFirstGrid().setTitle(getFeeAndPaymentCommonTranslation('OUT_STANDING_BY_BATCH_DETAILS'));
	                		 //this.getOutStandingUserWiseSecondGrid().setTitle(getFeeAndPaymentCommonTranslation('OUT_STANDING_BY_USER_DETAILS'));
	                		 //this.getOutStandingUserWiseFirstGrid().setVisible(true);
	                		 //this.getOutStandingUserWiseSecondGrid().setVisible(true);
	                	 }

	                	 /**
	                	  * if stasticfor is OUTSTANDING , stastic view is fee FEEHEAD  and fee plan type is Program
	                	  */
	                	 else if(showStaticFor == 'OUTSTANDING' && showStaticView == 'STUDENTWISE' && feeUserTypeId=='SPONSOR' &&  (feePlanTypeId ==2 || feePlanTypeId ==3 || feePlanTypeId ==4 || feePlanTypeId ==5 )) {

	                		 var configCodeForAllAcademy =  CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_USERWISE_SPONSOR_SUMMARY_ACADEMY_CONFIG_CODE;
	                		 var configCodeForAllLocation =   CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_USERWISE_SPONSOR_SUMMARY_LOCATION_CONFIG_CODE;
	                		 var configCodeForAllProgram =  CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_USERWISE_SPONSOR_SUMMARY_PROGRAM_CONFIG_CODE;
	                		 var configCodeForUserWiseFirstGrid =   CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_USERWISE_SPONSOR_DETAIL_FIRST_GRID_CONFIG_CODE;
	                		 var configCodeForAllUserWiseSecondGrid =   CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_USERWISE_SPONSOR_DETAIL_SECOND_GRID_CONFIG_CODE;

	                		 this.getLoadFeeStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadFeeStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 this.getLoadFeeStatiSticsByAllProgram(structure,configCodeForAllProgram);
	                		 var gridOne = this.getLoadOutstandingUserWiseFirstGrid(configCodeForUserWiseFirstGrid,configCodeForUserWiseFirstGrid);
	                		 var gridTwo = this.getLoadOutstandingUserWiseSecondGrid(configCodeForAllUserWiseSecondGrid,configCodeForAllUserWiseSecondGrid);
	                		
	                		 this.toggleGridSummaryRow(gridOne,true);
	                		 this.toggleGridSummaryRow(gridTwo,true);
	                		 
	                		 this.setFirstGridConfiguration(gridOne,configCodeForUserWiseFirstGrid);
	                		 this.setSecondGridConfiguration(gridTwo,configCodeForAllUserWiseSecondGrid);
	                		 gridOne.setTitle(getFeeAndPaymentCommonTranslation('OUT_STANDING_BY_BATCH_DETAILS'));
	                		 gridTwo.setTitle(getFeeAndPaymentCommonTranslation('OUT_STANDING_BY_USER_DETAILS'));
	                		 structure.down("#paymentstatisticssTabpanel").setVisible(true);

	                		 /**
	                		  * for this case -
	                		  * 
	                		  * show fee head chart 
	                		  * show fee head grid
	                		  * 
	                		  * hide user wise first grid 
	                		  * hide user wise second grid
	                		  * 
	                		  * */

	                		 structure.down("#feechartpanelallfeehead").setVisible(false);
	                		 //structure.down("#feecollectionheadwiseallfeeheadgrid").setVisible(true);

	                		 //this.getOutStandingUserWiseFirstGrid().setTitle(getFeeAndPaymentCommonTranslation('OUT_STANDING_BY_BATCH_DETAILS'));
	                		 //this.getOutStandingUserWiseSecondGrid().setTitle(getFeeAndPaymentCommonTranslation('OUT_STANDING_BY_USER_DETAILS'));
	                		 //this.getOutStandingUserWiseFirstGrid().setVisible(true);
	                		 //this.getOutStandingUserWiseSecondGrid().setVisible(true);
	                	 }
	                	 /**
	                	  * if stasticfor is OUTSTANDING , stastic view is fee FEEHEAD  and fee plan type is Program
	                	  */
	                	 else if((showStaticFor == 'OUTSTANDING' && showStaticView == 'STUDENTWISE') &&  (feePlanTypeId ==1 || feePlanTypeId==2 )) {

	                		 var configCodeForAllAcademy =  CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_USERWISE_APPLICANT_SUMMARY_ACADEMY_CONFIG_CODE;
	                		 var configCodeForAllLocation =   CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_USERWISE_APPLICANT_SUMMARY_LOCATION_CONFIG_CODE;
	                		 var configCodeForAllProgram =  CONSTANTS.CB.FEE_DASHBOARD_OUTSTDING_USERWISE_APPLICANT_SUMMARY_PROGRAM_CONFIG_CODE;
	                		 var configCodeForUserWiseFirstGrid =   CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_USERWISE_APPLICANT_DETAIL_FIRST_GRID_CONFIG_CODE;
	                		 var configCodeForAllUserWiseSecondGrid =   CONSTANTS.CB.FEE_DASHBOARD_OUTSTANDING_USERWISE_APPLICANT_DETAIL_SECOND_GRID_CONFIG_CODE;

	                		 this.getLoadFeeStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadFeeStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 this.getLoadFeeStatiSticsByAllProgram(structure,configCodeForAllProgram);
	                		 //this.getLoadFeeStatiSticsByAllFeeHead(structure,configCodeForAllFeeHead);
	                		 //this.getLoadFeeStatiSticsByAllFeeHeadGrid(structure,configCodeForAllFeeHeadGrid);
	                		 var gridOne = this.getLoadOutstandingUserWiseFirstGrid(configCodeForUserWiseFirstGrid, configCodeForUserWiseFirstGrid);
	                		 var gridTwo = this.getLoadOutstandingUserWiseSecondGrid(configCodeForAllUserWiseSecondGrid, configCodeForAllUserWiseSecondGrid);
	                		
	                		 this.toggleGridSummaryRow(gridOne,true);
	                		 this.toggleGridSummaryRow(gridTwo,true);
	                		 
	                		 gridOne.setTitle(getFeeAndPaymentCommonTranslation('OUT_STANDING_BY_BATCH_DETAILS'));
	                		 gridTwo.setTitle(getFeeAndPaymentCommonTranslation('OUT_STANDING_BY_USER_DETAILS'));
	                		 this.setFirstGridConfiguration(gridOne,configCodeForUserWiseFirstGrid);
	                		 this.setSecondGridConfiguration(gridTwo,configCodeForAllUserWiseSecondGrid);
	                		 structure.down("#paymentstatisticssTabpanel").setVisible(true);

	                		 /**
	                		  * for this case -
	                		  * 
	                		  * show fee head chart 
	                		  * show fee head grid
	                		  * 
	                		  * hide user wise first grid 
	                		  * hide user wise second grid
	                		  * 
	                		  * */

	                		 structure.down("#feechartpanelallfeehead").setVisible(false);
	                		 //structure.down("#feecollectionheadwiseallfeeheadgrid").setVisible(true);
	                		 //this.getOutStandingUserWiseFirstGrid().setVisible(true);
	                		 //this.getOutStandingUserWiseSecondGrid().setVisible(true);

	                	 }
	                	 /**
	                	  * static for 'refund' static view 'fee head wise' and fee plan type are  course , exam , service
	                	  * 
	                	  */
	                	 else if (showStaticFor == 'REFUND' && showStaticView == 'FEEHEADWISE' && (feePlanTypeId == 3 || feePlanTypeId == 4 || feePlanTypeId == 5)) {

	                		 var configCodeForAllAcademy = CONSTANTS.CB.FEE_DASHBOARD_REFUND_HEADWISE_ALL_ACADEMY_CONFIG_CODE;
	                		 var configCodeForAllLocation = CONSTANTS.CB.FEE_DASHBOARD_REFUND_HEAD_WISE_ALLLOCATION_CONFIG_CODE;
	                		 var configCodeForAllProgram = CONSTANTS.CB.FEE_DASHBOARD_REFUND_HEADWISE_ALL_PROGRAM_CONFIG_CODE;
	                		 var configCodeForAllFeeHead = CONSTANTS.CB.FEE_DASHBOARD_REFUND_HEADWISE_ALL_FEEHEAD_CONFIG_CODE;

	                		 this.getLoadFeeStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadFeeStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 this.getLoadFeeStatiSticsByAllProgram(structure,configCodeForAllProgram);
	                		 this.getLoadFeeStatiSticsByAllFeeHead(structure,configCodeForAllFeeHead);
	                		 // this.getLoadFeeStatiSticsByAllFeeHeadGrid(structure,configCodeForAllFeeHeadGrid);
	                		 structure.down("#paymentstatisticssTabpanel").setVisible(true);
	                		 structure.down("#feechartpanelallfeehead").setVisible(true);


	                	 }

	                	 /**
	                	  * static for 'refund' static view 'fee head wise' and fee plan type is  application
	                	  * 
	                	  */
	                	 else if (showStaticFor == 'REFUND' && showStaticView == 'FEEHEADWISE' && feePlanTypeId == 1) {

	                		 var configCodeForAllAcademy = CONSTANTS.CB.FEE_DASHBOARD_REFUND_HEADWISE_APPLICATION_ACADEMY_CONFIG_CODE;
	                		 var configCodeForAllLocation = CONSTANTS.CB.FEE_DASHBOARD_REFUND_HEADWISE_APPLICATION_LOCATION_CONFIG_CODE;
	                		 var configCodeForAllProgram = CONSTANTS.CB.FEE_DASHBOARD_REFUND_HEADWISE_APPLICATION_PROGRAM_CONFIG_CODE;
	                		 var configCodeForAllFeeHead = CONSTANTS.CB.FEE_DASHBOARD_REFUND_HEADWISE_APPLICATION_FEEHEAD_CONFIG_CODE;

	                		 this.getLoadFeeStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadFeeStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 this.getLoadFeeStatiSticsByAllProgram(structure,configCodeForAllProgram);
	                		 this.getLoadFeeStatiSticsByAllFeeHead(structure,configCodeForAllFeeHead);
	                		 // this.getLoadFeeStatiSticsByAllFeeHeadGrid(structure,configCodeForAllFeeHeadGrid);
	                		 structure.down("#paymentstatisticssTabpanel").setVisible(true);
	                		 structure.down("#feechartpanelallfeehead").setVisible(true);
	                	 }

	                	 /**
	                	  * static for 'refund' static view 'fee head wise' and fee plan type is  program
	                	  * 
	                	  */
	                	 else if (showStaticFor == 'REFUND' && showStaticView == 'FEEHEADWISE' && feePlanTypeId == 2) {

	                		 var configCodeForAllAcademy = CONSTANTS.CB.FEE_DASHBOARD_REFUND_HEADWISE_PROGRAM_ACADEMY_CONFIG_CODE;
	                		 var configCodeForAllLocation = CONSTANTS.CB.FEE_DASHBOARD_REFUND_HEADWISE_PROGRAM_LOCATION_CONFIG_CODE;
	                		 var configCodeForAllProgram = CONSTANTS.CB.FEE_DASHBOARD_REFUND_HEADWISE_PROGRAM_PROGRAMS_CONFIG_CODE;
	                		 var configCodeForAllFeeHead = CONSTANTS.CB.FEE_DASHBOARD_REFUND_HEADWISE_PROGRAM_FEEHEAD_CONFIG_CODE;

	                		 this.getLoadFeeStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadFeeStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 this.getLoadFeeStatiSticsByAllProgram(structure,configCodeForAllProgram);
	                		 this.getLoadFeeStatiSticsByAllFeeHead(structure,configCodeForAllFeeHead);
	                		 // this.getLoadFeeStatiSticsByAllFeeHeadGrid(structure,configCodeForAllFeeHeadGrid);
	                		 structure.down("#paymentstatisticssTabpanel").setVisible(true);
	                		 structure.down("#feechartpanelallfeehead").setVisible(true);

	                	 }

	                	 /**
	                	  * static for 'refund' static view 'fee head wise' and fee plan type is  program
	                	  * 
	                	  */
	                	 else if (showStaticFor == 'REFUND' && showStaticView == 'FEEHEADWISE' && feePlanTypeId == 2) {

	                		 var configCodeForAllAcademy = CONSTANTS.CB.FEE_DASHBOARD_REFUND_HEADWISE_PROGRAM_ACADEMY_CONFIG_CODE;
	                		 var configCodeForAllLocation = CONSTANTS.CB.FEE_DASHBOARD_REFUND_HEADWISE_PROGRAM_LOCATION_CONFIG_CODE;
	                		 var configCodeForAllProgram = CONSTANTS.CB.FEE_DASHBOARD_REFUND_HEADWISE_PROGRAM_PROGRAMS_CONFIG_CODE;
	                		 var configCodeForAllFeeHead = CONSTANTS.CB.FEE_DASHBOARD_REFUND_HEADWISE_PROGRAM_FEEHEAD_CONFIG_CODE;

	                		 this.getLoadFeeStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadFeeStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 this.getLoadFeeStatiSticsByAllProgram(structure,configCodeForAllProgram);
	                		 this.getLoadFeeStatiSticsByAllFeeHead(structure,configCodeForAllFeeHead);
	                		 // this.getLoadFeeStatiSticsByAllFeeHeadGrid(structure,configCodeForAllFeeHeadGrid);
	                		 structure.down("#paymentstatisticssTabpanel").setVisible(true);
	                		 structure.down("#feechartpanelallfeehead").setVisible(true);
	                	 }

	                	 /**
	                	  * static for 'refund' static view 'fee head wise' and fee plan type is  program
	                	  * 
	                	  */
	                	 else if(showStaticFor == 'REFUND' && showStaticView == 'STUDENTWISE' && feeUserTypeId=='APPLICANT' &&  feePlanTypeId ==1) {

	                		 var configCodeForAllAcademy = CONSTANTS.CB.FEE_DASHBOARD_REFUND_USERWISE_APPLICANT_SUMMARY_ACADEMY_CONFIG_CODE;
	                		 var configCodeForAllLocation = CONSTANTS.CB.FEE_DASHBOARD_REFUND_USERWISE_APPLICANT_SUMMARY_LOCATION_CONFIG_CODE;
	                		 var configCodeForAllProgram = CONSTANTS.CB.FEE_DASHBOARD_REFUND_USERWISE_APPLICANT_SUMMARY_PROGRAM_CONFIG_CODE;
	                		 var configCodeForUserWiseFirstGrid = CONSTANTS.CB.FEE_DASHBOARD_REFUND_USERWISE_APPLICANT_DETAIL_FIRST_GRID_CONFIG_CODE;
	                		 var configCodeForUserWiseSecondGrid = CONSTANTS.CB.FEE_DASHBOARD_REFUND_USERWISE_APPLICANT_DETAIL_SECOND_GRID_CONFIG_CODE;

	                		 this.getLoadFeeStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadFeeStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 this.getLoadFeeStatiSticsByAllProgram(structure,configCodeForAllProgram);
	                		 var gridOne = this.getLoadRefundUserWiseFirstGrid(configCodeForUserWiseFirstGrid,configCodeForUserWiseFirstGrid);
	                		 var gridTwo = this.getLoadRefundUserWiseSecondGrid(configCodeForUserWiseSecondGrid,configCodeForUserWiseSecondGrid);
	                		
	                		 this.toggleGridSummaryRow(gridOne,true);
	                		 this.toggleGridSummaryRow(gridTwo,true);
	                		 
	                		 this.setFirstGridConfiguration(gridOne,configCodeForUserWiseFirstGrid);
	                		 this.setSecondGridConfiguration(gridTwo,configCodeForUserWiseSecondGrid);
	                		 structure.down("#paymentstatisticssTabpanel").setVisible(true);
	                		 structure.down("#feechartpanelallfeehead").setVisible(false);

	                		 //this.getRefundWiseFirstGrid().setVisible(true);
	                		 //this.getRefundWiseSecondGrid().setVisible(true);
	                	 }

	                	 /**
	                	  * static for 'refund' static view 'fee head wise' and fee plan type is  program
	                	  * 
	                	  */
	                	 else if(showStaticFor == 'REFUND' && showStaticView == 'STUDENTWISE' && feeUserTypeId=='STUDENT' && feePlanTypeId ==2) {

	                		 var configCodeForAllAcademy = CONSTANTS.CB.FEE_DASHBOARD_REFUND_USERWISE_STUDENT_SUMMARY_ACADEMY_CONFIG_CODE;
	                		 var configCodeForAllLocation = CONSTANTS.CB.FEE_DASHBOARD_REFUND_USERWISE_STUDENT_SUMMARY_LOCATION_CONFIG_CODE;
	                		 var configCodeForAllProgram = CONSTANTS.CB.FEE_DASHBOARD_REFUND_USERWISE_STUDENT_SUMMARY_PROGRAM_CONFIG_CODE;
	                		 var configCodeForUserWiseFirstGrid = CONSTANTS.CB.FEE_DASHBOARD_REFUND_USERWISE_STUDENT_DETAIL_FIRST_GRID_CONFIG_CODE;
	                		 var configCodeForUserWiseSecondGrid = CONSTANTS.CB.FEE_DASHBOARD_REFUND_USERWISE_STUDENT_DETAIL_SECOND_GRID_CONFIG_CODE;

	                		 this.getLoadFeeStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadFeeStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 this.getLoadFeeStatiSticsByAllProgram(structure,configCodeForAllProgram);
	                		 var gridOne = this.getLoadRefundUserWiseFirstGrid(configCodeForUserWiseFirstGrid,configCodeForUserWiseFirstGrid);
	                		 var gridTwo = this.getLoadRefundUserWiseSecondGrid(configCodeForUserWiseSecondGrid,configCodeForUserWiseSecondGrid);
	                		
	                		 this.toggleGridSummaryRow(gridOne,true);
	                		 this.toggleGridSummaryRow(gridTwo,true);
	                		 
	                		 this.setFirstGridConfiguration(gridOne,configCodeForUserWiseFirstGrid);
	                		 this.setSecondGridConfiguration(gridTwo,configCodeForUserWiseSecondGrid);
	                		 structure.down("#paymentstatisticssTabpanel").setVisible(true);
	                		 structure.down("#feechartpanelallfeehead").setVisible(false);

	                		 //this.getRefundWiseFirstGrid().setVisible(true);
	                		 //this.getRefundWiseSecondGrid().setVisible(true);
	                	 }

	                	 else if(showStaticFor == 'REFUND' && showStaticView == 'STUDENTWISE' && feeUserTypeId=='APPLICANT' && feePlanTypeId ==2) {

	                		 var configCodeForAllAcademy = CONSTANTS.CB.FEE_DASHBOARD_REFUND_USERWISE_APPLICANT_SUMMARY_ACADEMY_CONFIG_CODE;
	                		 var configCodeForAllLocation = CONSTANTS.CB.FEE_DASHBOARD_REFUND_USERWISE_APPLICANT_SUMMARY_LOCATION_CONFIG_CODE;
	                		 var configCodeForAllProgram = CONSTANTS.CB.FEE_DASHBOARD_REFUND_USERWISE_APPLICANT_SUMMARY_PROGRAM_CONFIG_CODE;
	                		 var configCodeForUserWiseFirstGrid = CONSTANTS.CB.FEE_DASHBOARD_REFUND_USERWISE_APPLICANT_DETAIL_FIRST_GRID_CONFIG_CODE;
	                		 var configCodeForUserWiseSecondGrid = CONSTANTS.CB.FEE_DASHBOARD_REFUND_USERWISE_APPLICANT_DETAIL_SECOND_GRID_CONFIG_CODE;

	                		 this.getOutStandingUserWiseFirstGrid().setTitle(getFeeAndPaymentCommonTranslation('OUT_STANDING_BY_BATCH_DETAILS'));
	                		 this.getOutStandingUserWiseSecondGrid().setTitle(getFeeAndPaymentCommonTranslation('OUT_STANDING_BY_USER_DETAILS'));
	                		 this.getLoadFeeStatiSticsByAllAcademy(structure,configCodeForAllAcademy);
	                		 this.getLoadFeeStatiSticsByAllLocation(structure,configCodeForAllLocation);
	                		 this.getLoadFeeStatiSticsByAllProgram(structure,configCodeForAllProgram);
	                		 var gridOne = this.getLoadRefundUserWiseFirstGrid(configCodeForUserWiseFirstGrid,configCodeForUserWiseFirstGrid);
	                		 var gridTwo = this.getLoadRefundUserWiseSecondGrid(configCodeForUserWiseSecondGrid,configCodeForUserWiseSecondGrid);
	                		
	                		 this.toggleGridSummaryRow(gridOne,true);
	                		 this.toggleGridSummaryRow(gridTwo,true);
	                		 
	                		 this.setFirstGridConfiguration(gridOne,configCodeForUserWiseFirstGrid);
	                		 this.setSecondGridConfiguration(gridTwo,configCodeForUserWiseSecondGrid);
	                		 structure.down("#paymentstatisticssTabpanel").setVisible(true);
	                		 structure.down("#feechartpanelallfeehead").setVisible(false);

	                		 //this.getRefundWiseFirstGrid().setVisible(true);
	                		 //this.getRefundWiseSecondGrid().setVisible(true);
	                	 }

	                	 var task = new Ext.util.DelayedTask(function(){
	                		 structure.down("#paymentstatisticsbyacademieschart").updateTitle(staticForRawValue + ' ' + getFeeAndPaymentCommonTranslation('BY_ACADEMIES'));
	                		 structure.down("#paymentstatisticsbylocationchart").updateTitle(staticForRawValue + ' ' + getFeeAndPaymentCommonTranslation('BY_LOCATIONS'));
	                		 structure.down("#paymentstatisticsbyprogramchart").updateTitle(staticForRawValue + ' ' + getFeeAndPaymentCommonTranslation('BY_PROGRAMS'));
	                		 structure.down("#feecollectionheadwiseallfeehead").updateTitle(staticForRawValue + ' ' + getFeeAndPaymentCommonTranslation('BY_FEEHEADS'));
	                	 });
	                	 task.delay(1200);
	                	 //delay added by rohit because when no data to display and again search for another the title not display properly
	                 },
	                 createJsonFormatCommon: function(respectiveLinkConfigCode) {
	                	 var values = new Object();
	                	 values.configCode = respectiveLinkConfigCode;
	                	 var searchcriteria = new Array();
	                	 var organizationUnit = this.getOrganizationUnit();
	                	 var organizationUnitForm = organizationUnit.getForm();
	                	 var academyLocation = organizationUnitForm.getValues();
	                	 var academyLocationId = null;

	                	 if (isEmpty(academyLocation["multiselectAcademyLocation"])) {
	                		 academyLocationId = this.getCurrentAcademyLocation();
	                	 } else {
	                		 var multipleAcademyId=[];
	                		 Ext.Array.each(academyLocation.multiselectAcademyLocation,function(value){
	                			 if(Ext.isObject(value)){
	                				 multipleAcademyId.push(value.data.id);
	                			 }else{
	                				 multipleAcademyId.push(value);
	                			 }
	                		 });
	                		 academyLocationId = multipleAcademyId.join();
	                	 }

	                	 formValues = this.getFeeAndPaymentCommonFilter().getForm().getValues();
	                	 var program = formValues.programId;
	                	 var batch = formValues.batchId;
	                	 var feeHead = formValues.feeHead;

	                	 var multiProgramData;
	                	 var multiProgramArrayData=[];
	                	 if(program != undefined){
	                		 if(program.length>0){
	                			 for(var i in program){
	                				 if(Ext.isObject(program[i])){
	                					 multiProgramData = program[i].get("id");
	                					 multiProgramArrayData.push(multiProgramData);
	                				 }else{
	                					 multiProgramData = program[i];
	                					 multiProgramArrayData.push(multiProgramData);
	                				 }
	                			 }
	                		 }
	                	 }

	                	 var multiBatchData;
	                	 var multiBatchArrayData=[];
	                	 if(batch != undefined){
	                		 if(batch.length>0){
	                			 for(var i in batch){
	                				 if(Ext.isObject(batch[i])){
	                					 multiBatchData = batch[i].get("id");
	                					 multiBatchArrayData.push(multiBatchData);
	                				 }else{
	                					 multiBatchData = batch[i];
	                					 multiBatchArrayData.push(multiBatchData);
	                				 }
	                			 }
	                		 }
	                	 }
	                	 var multiFeeHeadData;
	                	 var multiFeeHeadArrayData=[];
	                	 if(feeHead != undefined){
	                		 if(feeHead.length>0){
	                			 for(var i in feeHead){
	                				 if(Ext.isObject(feeHead[i])){
	                					 multiFeeHeadData = feeHead[i].get("id");
	                					 multiFeeHeadArrayData.push(multiFeeHeadData);
	                				 }else{
	                					 multiFeeHeadData = feeHead[i];
	                					 multiFeeHeadArrayData.push(multiFeeHeadData);
	                				 }
	                			 }
	                		 }
	                	 }
	                	 var ACADEMY_LOCATION_ID = this.getJsonObject('ACADEMY_LOCATION_ID', academyLocationId);
	                	 this.pushJsonObjectInArray(ACADEMY_LOCATION_ID, searchcriteria);

	                	 var PROGRAM_ID = this.getJsonObject('PROGRAM_ID', multiProgramArrayData.join());
	                	 this.pushJsonObjectInArray(PROGRAM_ID, searchcriteria);

	                	 var BATCH_ID = this.getJsonObject('BATCH_ID', multiBatchArrayData.join());
	                	 this.pushJsonObjectInArray(BATCH_ID, searchcriteria);

	                	 var FEE_HEAD_ID = this.getJsonObject('FEE_HEAD_ID', multiFeeHeadArrayData.join());
	                	 this.pushJsonObjectInArray(FEE_HEAD_ID, searchcriteria);

	                	 var FEE_PLAN_TYPE_ID = this.getJsonObject('FEE_PLAN_TYPE_ID', formValues.feePlanType);
	                	 this.pushJsonObjectInArray(FEE_PLAN_TYPE_ID, searchcriteria);

	                	 var TRANSACTION_DATE = this.getJsonObject('TRANSACTION_DATE',formValues.fromDate,formValues.tillDate );
	                	 this.pushJsonObjectInArray(TRANSACTION_DATE, searchcriteria);

	                	 values.searchCriterias = searchcriteria;
	                	 return values;
	                 },
	                 createJsonFormatForPayment:function(respectiveLinkConfigCode){
	                	 var values = new Object();
	                	 values.configCode = respectiveLinkConfigCode;
	                	 var searchcriteria = new Array();
	                	 var organizationUnit = this.getOrganizationUnit();
	                	 var organizationUnitForm = organizationUnit.getForm();
	                	 var academyLocation = organizationUnitForm.getValues();
	                	 var academyLocationId = null;

	                	 if (isEmpty(academyLocation["multiselectAcademyLocation"])) {
	                		 academyLocationId = this.getCurrentAcademyLocation();
	                	 } else {
	                		 var multipleAcademyId=[];
	                		 Ext.Array.each(academyLocation.multiselectAcademyLocation,function(value){
	                			 if(Ext.isObject(value)){
	                				 multipleAcademyId.push(value.data.id);
	                			 }else{
	                				 multipleAcademyId.push(value);
	                			 }
	                		 });
	                		 academyLocationId = multipleAcademyId.join();
	                	 }

	                	 formValues = this.getPaymentStatiSticsFilter().getForm().getValues();

	                	 var ACADEMY_LOCATION_ID = this.getJsonObject('ACADEMY_LOCATION_ID', academyLocationId);
	                	 this.pushJsonObjectInArray(ACADEMY_LOCATION_ID, searchcriteria);

	                	 var TRANSACTION_DATE = this.getJsonObject('TRANSACTION_DATE',formValues.fromDate,formValues.tillDate );
	                	 this.pushJsonObjectInArray(TRANSACTION_DATE, searchcriteria);

	                	 values.searchCriterias = searchcriteria;
	                	 return values;
	                 },
	                 getJsonObject: function(key, value, additionalValue) {
	                	 if (value != '' && value != null && additionalValue == undefined) {
	                		 return {
	                			 "paramCode": key,
	                			 "paramValues": [value]
	                		 };
	                	 } else if (value != '' && additionalValue != undefined) {
	                		 return {
	                			 "paramCode": key,
	                			 "paramValues": [value, additionalValue]
	                		 };
	                	 }
	                 },
	                 pushJsonObjectInArray: function(object, array) {
	                	 if (object) {
	                		 array.push(object);
	                	 }
	                 },
	                 /*
	                  * load All Academy
	                  */
	                 getLoadPaymentStatiSticsByAllAcademy: function(structure,configCode) {
	                	 var paymentstatisticsbyacademies = structure.down("#paymentstatisticsbyacademiescharttwo");
	                	 var emptyLabelByAcademies = structure.getForm().findField("emptylabelbyacademies");
	                	 var resultViewUrl = SERVERURL.USERQUICKSEARCH;
	                	 var jsonFormatFormData = this.createJsonFormatForPayment(configCode);
	                	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');

	                	 Ext.Ajax.request({
	                		 type: 'rest',
	                		 url: resultViewUrl + '?page=1&limit=10',
	                		 method: 'POST',
	                		 headers: {
	                			 'Content-Type': 'application/json'
	                		 },
	                		 jsonData: jsonFormatFormData,
	                		 success: function(response) {
	                			 Ext.getBody().unmask();
	                			 data = Ext.decode(response.responseText);
	                			 var store = paymentstatisticsbyacademies.getStore();
	                			 if(store.getRange().length>0){
	                				 store.removeAll();
	                			 }
	                			 store.loadData(data.rows);
	                			 if(data.rows.length === 0){
	                				 var msg = paymentstatisticsbyacademies.chartTitle.el.dom.textContent + '<br/>'+getFeeAndPaymentCommonTranslation('NO_DATA_TO_DISPLAY');
	                				 emptyLabelByAcademies.setValue(msg);
	                				 emptyLabelByAcademies.setVisible(true);
	                				 paymentstatisticsbyacademies.setVisible(false);
	                			 }
	                			 else{
	                				 emptyLabelByAcademies.setVisible(false);
	                				 paymentstatisticsbyacademies.setVisible(true);
	                			 }
	                		 }
	                	 });
	                 },
	                 /*
	                  * load All Location
	                  */
	                 getLoadPaymentStatiSticsByAllLocation: function(structure,configCode) {
	                	 var paymentstatisticsbylocation = structure.down("#paymentstatisticsbylocationcharttwo");
	                	 var emptyLabelByLocation = structure.getForm().findField("emptylabelbylocationchart");
	                	 var resultViewUrl = SERVERURL.USERQUICKSEARCH;
	                	 var jsonFormatFormData = this.createJsonFormatForPayment(configCode);

	                	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');

	                	 Ext.Ajax.request({
	                		 type: 'rest',
	                		 url: resultViewUrl + '?page=1&limit=10',
	                		 method: 'POST',
	                		 headers: {
	                			 'Content-Type': 'application/json'
	                		 },
	                		 jsonData: jsonFormatFormData,
	                		 success: function(response) {
	                			 Ext.getBody().unmask();
	                			 data = Ext.decode(response.responseText);
	                			 var store = paymentstatisticsbylocation.getStore();
	                			 if(store.getRange().length>0){
	                				 store.removeAll();
	                			 }
	                			 store.loadData(data.rows);
	                			 if(data.rows.length === 0){
	                				 var msg = paymentstatisticsbylocation.chartTitle.el.dom.textContent + '<br/>'+getFeeAndPaymentCommonTranslation('NO_DATA_TO_DISPLAY');
	                				 emptyLabelByLocation.setValue(msg);
	                				 emptyLabelByLocation.setVisible(true);
	                				 paymentstatisticsbylocation.setVisible(false);
	                			 }
	                			 else{
	                				 emptyLabelByLocation.setVisible(false);
	                				 paymentstatisticsbylocation.setVisible(true);
	                			 }
	                		 }
	                	 });
	                 },
	                 /*
	                  * load All Academy
	                  */
	                 getLoadFeeStatiSticsByAllAcademy: function(structure,configCode) {
	                	 var paymentstatisticsbyacademies = structure.down("#paymentstatisticsbyacademieschart");
	                	 var emptyLabelByAcademies = structure.getForm().findField("emptylabelbyacademies");
	                	 var resultViewUrl = SERVERURL.USERQUICKSEARCH;
	                	 var jsonFormatFormData = this.createJsonFormatCommon(configCode);
	                	 var fieldModel = ['ACADEMY_NAME','ACADEMY_ID','AMOUNT'];
	                	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                	 var store = this.createCustomStore(resultViewUrl,jsonFormatFormData,fieldModel);
	                	 store.load({
	                		 callback: function(record, operation, success) {
	                			 Ext.getBody().unmask();
	                			 var store = paymentstatisticsbyacademies.getStore();
	                			 if(store.getRange().length>0){
	                				 store.removeAll();
	                			 }
	                			 store.loadData(record);
	                			 if(record.length === 0){
	                				 var msg = paymentstatisticsbyacademies.chartTitle.el.dom.textContent + '<br/>'+getFeeAndPaymentCommonTranslation('NO_DATA_TO_DISPLAY');
	                				 emptyLabelByAcademies.setValue(msg);
	                				 emptyLabelByAcademies.setVisible(true);
	                				 paymentstatisticsbyacademies.setVisible(false);
	                			 }
	                			 else{
	                				 emptyLabelByAcademies.setVisible(false);
	                				 paymentstatisticsbyacademies.setVisible(true);
	                			 }
	                		 }
	                	 });
	                 },
	                 /*
	                  * load All Location
	                  */
	                 getLoadFeeStatiSticsByAllLocation: function(structure,configCode) {
	                	 var paymentstatisticsbylocation = structure.down("#paymentstatisticsbylocationchart");
	                	 var emptyLabelByLocation = structure.getForm().findField("emptylabelbylocationchart");
	                	 var resultViewUrl = SERVERURL.USERQUICKSEARCH;
	                	 var jsonFormatFormData = this.createJsonFormatCommon(configCode);
	                	 var fieldModel = ['LOCATION_ID','LOCATION_NAME','AMOUNT'];
	                	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                	 var store = this.createCustomStore(resultViewUrl,jsonFormatFormData,fieldModel);
	                	 store.load({
	                		 callback: function(record, operation, success) {
	                			 Ext.getBody().unmask();
	                			 var store = paymentstatisticsbylocation.getStore();
	                			 if(store.getRange().length>0){
	                				 store.removeAll();
	                			 }
	                			 store.loadData(record);
	                			 if(record.length === 0){
	                				 var msg = paymentstatisticsbylocation.chartTitle.el.dom.textContent + '<br/>'+getFeeAndPaymentCommonTranslation('NO_DATA_TO_DISPLAY');
	                				 emptyLabelByLocation.setValue(msg);
	                				 emptyLabelByLocation.setVisible(true);
	                				 paymentstatisticsbylocation.setVisible(false);
	                			 }
	                			 else{
	                				 emptyLabelByLocation.setVisible(false);
	                				 paymentstatisticsbylocation.setVisible(true);
	                			 }
	                		 }
	                	 });
	                 },
	                 /*
	                  * load Program
	                  */
	                 getLoadFeeStatiSticsByAllProgram: function(structure,configCode) {
	                	 var paymentstatisticsbyprogram = structure.down("#paymentstatisticsbyprogramchart");
	                	 var emptyLabelByProgram = structure.getForm().findField("emptylabelbyprogramchart");
	                	 var resultViewUrl = SERVERURL.USERQUICKSEARCH;
	                	 var jsonFormatFormData = this.createJsonFormatCommon(configCode);
	                	 var fieldModel = ['PROGRAM_ID','PROGRAM_NAME','AMOUNT'];
	                	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                	 var store = this.createCustomStore(resultViewUrl,jsonFormatFormData,fieldModel);
	                	 store.load({
	                		 callback: function(record, operation, success) {
	                			 Ext.getBody().unmask();
	                			 var store = paymentstatisticsbyprogram.getStore();
	                			 if(store.getRange().length>0){
	                				 store.removeAll();
	                			 }
	                			 store.loadData(record);
	                			 if(record.length === 0){
	                				 var msg = paymentstatisticsbyprogram.chartTitle.el.dom.textContent + '<br/>'+getFeeAndPaymentCommonTranslation('NO_DATA_TO_DISPLAY');
	                				 emptyLabelByProgram.setValue(msg);
	                				 emptyLabelByProgram.setVisible(true);
	                				 paymentstatisticsbyprogram.setVisible(false);
	                			 }
	                			 else{
	                				 emptyLabelByProgram.setVisible(false);
	                				 paymentstatisticsbyprogram.setVisible(true);
	                			 }
	                		 }
	                	 });
	                 },
	                 /*
	                  * load All Fee Head
	                  */
	                 getLoadFeeStatiSticsByAllFeeHead: function(structure,configCode) {
	                	 var paymentstatisticsbyfeehead = structure.down("#feecollectionheadwiseallfeehead");
	                	 var emptyLabelAllFeeHead = structure.getForm().findField("emptylabelallfeeheadchart");
	                	 var resultViewUrl = SERVERURL.USERQUICKSEARCH;
	                	 var jsonFormatFormData = this.createJsonFormatCommon(configCode);
	                	 var fieldModel = ['FEE_HEAD_ID','FEE_HEAD_NAME','AMOUNT'];
	                	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                	 var store = this.createCustomStore(resultViewUrl,jsonFormatFormData,fieldModel);
	                	 store.load({
	                		 callback: function(record, operation, success) {
	                			 Ext.getBody().unmask();
	                			 var store = paymentstatisticsbyfeehead.getStore();
	                			 if(store.getRange().length>0){
	                				 store.removeAll();
	                			 }
	                			 store.loadData(record);
	                			 if(record.length === 0){
	                				 var msg = paymentstatisticsbyfeehead.chartTitle.el.dom.textContent + '<br/>'+getFeeAndPaymentCommonTranslation('NO_DATA_TO_DISPLAY');
	                				 emptyLabelAllFeeHead.setValue(msg);
	                				 emptyLabelAllFeeHead.setVisible(true);
	                				 paymentstatisticsbyfeehead.setVisible(false);
	                			 }
	                			 else{
	                				 emptyLabelAllFeeHead.setVisible(false);
	                				 paymentstatisticsbyfeehead.setVisible(true);
	                			 }
	                		 }
	                	 });
	                 },
	                 /*
	                  * load collection Fee Head Grid
	                  */
	                 getLoadFeeStatiSticsByAllFeeHeadGrid: function(structure,configCode) {
	                	 var viewCode = configCode;
	                	 var jsonFormatFormData = this.createJsonFormatCommon(configCode);
	                	 //var searchResultGrid = this.getFeeCollectionHeadWiseAllFeeHeadGrid();
	                	 var searchResultGrid = new Academia.view.criteriabuilder.grid.SearchResultGrid();
	                	 this.getResultGridsContainer().add(searchResultGrid);
	                	 var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
	                	 resultViewUrl = resultViewUrl.concat(viewCode);
	                	 this.gridRenderFunction(searchResultGrid);
	                	 this.genericCBGridAccessControlValidation(searchResultGrid,this.getFEEANDPAYMENT_DASHBOARD_STATISTICS_PERMISSIONS());
	                	 searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
	                	 return searchResultGrid;
	                 },
	                 /*
	                  * load Bill Fee Head Grid
	                  */
	                 getLoadBillFeeStatiSticsByAllFeeHeadGrid: function(structure,configCode) {
	                	 var viewCode = configCode;
	                	 var jsonFormatFormData = this.createJsonFormatCommon(configCode);
	                	 //var searchResultGrid = this.getFeeBillHeadWiseAllFeeHeadGrid();
	                	 var searchResultGrid = new Academia.view.criteriabuilder.grid.SearchResultGrid();
	                	 this.getResultGridsContainer().add(searchResultGrid);
	                	 var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
	                	 resultViewUrl = resultViewUrl.concat(viewCode);
	                	 this.gridRenderFunction(searchResultGrid);
	                	 this.genericCBGridAccessControlValidation(searchResultGrid,this.getFEEANDPAYMENT_DASHBOARD_STATISTICS_PERMISSIONS());
	                	 searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
	                	 return searchResultGrid;
	                 },
	                 /*
	                  * load Outstanding Fee Head Grid
	                  */
	                 getLoadOutstandingFeeStatiSticsByAllFeeHeadGrid: function(structure,configCode) {
	                	 var viewCode = configCode;
	                	 var jsonFormatFormData = this.createJsonFormatCommon(configCode);
	                	 //var searchResultGrid = this.getFeeOutstandingHeadWiseAllFeeHeadGrid();
	                	 var searchResultGrid = new Academia.view.criteriabuilder.grid.SearchResultGrid();
	                	 this.getResultGridsContainer().add(searchResultGrid);
	                	 var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
	                	 resultViewUrl = resultViewUrl.concat(viewCode);
	                	 this.gridRenderFunction(searchResultGrid);
	                	 this.genericCBGridAccessControlValidation(searchResultGrid,this.getFEEANDPAYMENT_DASHBOARD_STATISTICS_PERMISSIONS());
	                	 searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
	                	 return searchResultGrid;
	                 },
	                 /*
	                  * load collection User Wise First Grid
	                  */
	                 getLoadUserWiseFirstGrid: function(configCode, viewCode) {
	                	 var jsonFormatFormData = this.createJsonFormatCommon(configCode);
	                	 //var searchResultGrid = this.getCollectionUserWiseFirstGrid();
	                	 var searchResultGrid = new Academia.view.criteriabuilder.grid.SearchResultGrid();
	                	 this.getResultGridsContainer().add(searchResultGrid);
	                	 var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
	                	 resultViewUrl = resultViewUrl.concat(viewCode);
	                	 this.gridRenderFunction(searchResultGrid);
	                	 this.genericCBGridAccessControlValidation(searchResultGrid,this.getFEEANDPAYMENT_DASHBOARD_STATISTICS_PERMISSIONS());
	                	 searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
	                	 return searchResultGrid;
	                 },
	                 /*
	                  * load collection User Wise Second Grid
	                  */
	                 getLoadUserWiseSecondGrid: function(configCode, viewCode) {
	                	 var jsonFormatFormData = this.createJsonFormatCommon(configCode);
	                	 //var searchResultGrid = this.getCollectionUserWiseSecondGrid();
	                	 var searchResultGrid = new Academia.view.criteriabuilder.grid.SearchResultGrid();
	                	 this.getResultGridsContainer().add(searchResultGrid);
	                	 var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
	                	 resultViewUrl = resultViewUrl.concat(viewCode);
	                	 this.gridRenderFunction(searchResultGrid);
	                	 this.genericCBGridAccessControlValidation(searchResultGrid,this.getFEEANDPAYMENT_DASHBOARD_STATISTICS_PERMISSIONS());
	                	 searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
	                	 return searchResultGrid;
	                 },
	                 /*
	                  * load outstanding User Wise First Grid
	                  */
	                 getLoadOutstandingUserWiseFirstGrid: function(configCode, viewCode) {
	                	 var jsonFormatFormData = this.createJsonFormatCommon(configCode);
	                	 //var searchResultGrid = this.getOutStandingUserWiseFirstGrid();
	                	 var searchResultGrid = new Academia.view.criteriabuilder.grid.SearchResultGrid();
	                	 this.getResultGridsContainer().add(searchResultGrid);
	                	 var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
	                	 resultViewUrl = resultViewUrl.concat(viewCode);
	                	 this.gridRenderFunction(searchResultGrid);
	                	 this.genericCBGridAccessControlValidation(searchResultGrid,this.getFEEANDPAYMENT_DASHBOARD_STATISTICS_PERMISSIONS());
	                	 searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
	                	 return searchResultGrid;
	                 },
	                 /*
	                  * load outstanding User Wise Second Grid
	                  */
	                 getLoadOutstandingUserWiseSecondGrid: function(configCode, viewCode) {
	                	 var jsonFormatFormData = this.createJsonFormatCommon(configCode);
	                	 //var searchResultGrid = this.getOutStandingUserWiseSecondGrid();
	                	 var searchResultGrid = new Academia.view.criteriabuilder.grid.SearchResultGrid();
	                	 this.getResultGridsContainer().add(searchResultGrid);
	                	 var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
	                	 resultViewUrl = resultViewUrl.concat(viewCode);
	                	 this.gridRenderFunction(searchResultGrid);
	                	 this.genericCBGridAccessControlValidation(searchResultGrid,this.getFEEANDPAYMENT_DASHBOARD_STATISTICS_PERMISSIONS());
	                	 searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
	                	 return searchResultGrid;
	                 },
	                 /*
	                  * load bill User Wise First Grid
	                  */
	                 getLoadBillUserWiseFirstGrid: function(configCode, viewCode) {
	                	 var jsonFormatFormData = this.createJsonFormatCommon(configCode);
	                	 //var searchResultGrid = this.getBillUserWiseFirstGrid();
	                	 var searchResultGrid = new Academia.view.criteriabuilder.grid.SearchResultGrid();
	                	 this.getResultGridsContainer().add(searchResultGrid);
	                	 var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
	                	 resultViewUrl = resultViewUrl.concat(viewCode);
	                	 this.gridRenderFunction(searchResultGrid);
	                	 this.genericCBGridAccessControlValidation(searchResultGrid,this.getFEEANDPAYMENT_DASHBOARD_STATISTICS_PERMISSIONS());
	                	 searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
	                	 return searchResultGrid;
	                 },
	                 /*
	                  * load bill User Wise Second Grid
	                  */
	                 getLoadBillUserWiseSecondGrid: function(configCode, viewCode) {
	                	 var jsonFormatFormData = this.createJsonFormatCommon(configCode);
	                	 //var searchResultGrid = this.getBillUserWiseSecondGrid();
	                	 var searchResultGrid = new Academia.view.criteriabuilder.grid.SearchResultGrid();
	                	 this.getResultGridsContainer().add(searchResultGrid);
	                	 var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
	                	 resultViewUrl = resultViewUrl.concat(viewCode);
	                	 this.gridRenderFunction(searchResultGrid);
	                	 this.genericCBGridAccessControlValidation(searchResultGrid,this.getFEEANDPAYMENT_DASHBOARD_STATISTICS_PERMISSIONS());
	                	 searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
	                	 return searchResultGrid;
	                 },
	                 /*
	                  * load refund User Wise First Grid
	                  */
	                 getLoadRefundUserWiseFirstGrid: function(configCode, viewCode) {
	                	 var jsonFormatFormData = this.createJsonFormatCommon(configCode);
	                	 //var searchResultGrid = this.getRefundWiseFirstGrid();
	                	 var searchResultGrid = new Academia.view.criteriabuilder.grid.SearchResultGrid();
	                	 this.getResultGridsContainer().add(searchResultGrid);
	                	 var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
	                	 resultViewUrl = resultViewUrl.concat(viewCode);
	                	 this.gridRenderFunction(searchResultGrid);
	                	 this.genericCBGridAccessControlValidation(searchResultGrid,this.getFEEANDPAYMENT_DASHBOARD_STATISTICS_PERMISSIONS());
	                	 searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
	                	 return searchResultGrid;
	                 },
	                 /*
	                  * load refund User Wise Second Grid
	                  */
	                 getLoadRefundUserWiseSecondGrid: function(configCode, viewCode) {
	                	 var jsonFormatFormData = this.createJsonFormatCommon(configCode);
	                	 //var searchResultGrid = this.getRefundWiseSecondGrid();
	                	 var searchResultGrid = new Academia.view.criteriabuilder.grid.SearchResultGrid();
	                	 this.getResultGridsContainer().add(searchResultGrid);
	                	 var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
	                	 resultViewUrl = resultViewUrl.concat(viewCode);
	                	 this.gridRenderFunction(searchResultGrid);
	                	 this.genericCBGridAccessControlValidation(searchResultGrid,this.getFEEANDPAYMENT_DASHBOARD_STATISTICS_PERMISSIONS());
	                	 searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
	                	 return searchResultGrid;
	                 },
	                 /*
	                  * enable panel click to view enlarged view of fee charts
	                  */
	                 enlargeFeeChart: function(panel){
	                	 var $this = this;
	                	 var me = panel;
	                	 panel.body.on('click', function(){
	                		 if(me.down('chart').isVisible()){
	                			 var chartWindow = $this.openEnlargeChartWindow(),
	                			 oriView = me.items.items[0],
	                			 viewType = oriView.xtype,
	                			 store = oriView.getStore(),
	                			 storeName = store.$className,
	                			 minHeight = oriView.minHeight, minWidth = oriView.minWidth, view = {};

	                			 chartWindow.setTitle(oriView.chartTitle.el.dom.textContent);
	                			 if(oriView.series.getAt(0).type != 'pie'){
	                				 view = {
	                						 xtype: viewType,
	                						 minHeight: minHeight,
	                						 minWidth: minWidth,
	                						 columnWidth: oriView.columnWidth,
	                						 columnColor: oriView.columnColor,
	                						 store: storeName,
	                						 xAxesNumericField: oriView.xAxesNumericField,
	                						 xAxesNumericTitle: oriView.xAxesNumericTitle,
	                						 yAxesCategoryField: oriView.yAxesCategoryField,
	                						 yAxesCategoryTitle: oriView.yAxesCategoryTitle
	                				 };
	                			 }
	                			 else {
	                				 view = {
	                						 xtype: viewType,
	                						 minHeight : minHeight,
	                						 minWidth: minWidth,
	                						 store: storeName,
	                						 numericField: oriView.numericField,
	                						 categoryField: oriView.categoryField,
	                						 legend: {
	                							 position: 'right',
	                							 minWidth: 140
	                						 }
	                				 };
	                			 }
	                			 chartWindow.add(view);
	                			 var clonedView = chartWindow.down('chart');
	                			 clonedView.series.getAt(0).renderer = function(sprite, record, attr, index, store) {
	                				 var color = CONSTANTS.CHART_COLORSET[index];
	                				 if(store.getCount() <= 8){
	                					 return Ext.apply(attr, {
	                						 fill: color,
	                						 height: 30,
	                						 y: Math.max(attr.y, attr.y + (attr.height - 30) / 2)
	                					 });
	                				 }
	                				 else{
	                					 return Ext.apply(attr, {
	                						 fill: color
	                					 });
	                				 }
	                			 };
	                			 clonedView.getStore().add(store.data.items);
	                			 clonedView.series.getAt(0).label.font = CONSTANTS.LABEL_FONT_STYLE_ENLARGED_VIEW;
	                			 clonedView.updateTitle('');
	                			 $this.addExportToPngForFeeDashboard(chartWindow);
	                		 }
	                	 });
	                	 panel.body.on('mouseover', function(){
	                		 if(me.down('chart').isVisible()){
	                			 me.getEl().applyStyles(CONSTANTS.CHART_FRAMING);
	                		 }
	                	 });
	                	 panel.body.on('mouseout', function(){
	                		 me.getEl().applyStyles(CONSTANTS.CHART_UNFRAMING);
	                	 });
	                 },
	                 /*
	                  * show window for enlart chart view
	                  */
	                 openEnlargeChartWindow: function(){
	                	 var chartWindow = this.getEnlargeFeeChartWindow();
	                	 if (!chartWindow) {
	                		 Ext.widget('enlargefeechartwindow');
	                		 chartWindow = this.getEnlargeFeeChartWindow();
	                	 }
	                	 chartWindow.show();
	                	 return chartWindow;
	                 }, 
	                 /*
	                  * load programs store data on the basis of selected AcademyLocationId
	                  */
	                 doLoadProgramStore: function(obj, record) {
	                	 
	                	 var org = this.getOrganizationUnit();
	                	 var organizationForm = org.getForm();
	    				 var academyLocation = organizationForm.findField('multiselectAcademyLocation');
	    				 var feeandpaymentdashboardstructure = org.up('feeandpaymentdashboardstructure');
	    				 var feedashboardreporttabpanel = feeandpaymentdashboardstructure.down('feedashboardreporttabpanel');
	    				 var ttabpanelitems = feedashboardreporttabpanel.items.items;
	    				 
	    				 var academyLocationIds=[];
	    				 Ext.Array.each(academyLocation.getValue(),function(value){
	    					 if(Ext.isObject(value)){
	    						 academyLocationIds.push(value.data.id);	
	    					 }else {
	    						 academyLocationIds.push(value);
	    					 }
	    				 });
	                	 
	                	 for(var i in ttabpanelitems){
	                		 if(ttabpanelitems[i].title === 'Fee Statistics'){
	                			 var programsStore = this.getFeeAndPaymentCommonFilter().getForm().findField('programId').getStore();
	    	                	 programsStore.getProxy().extraParams = {
	    	                		 academyLocationIds: academyLocationIds.join()
	    	                	 };
	    	                	 programsStore.load();
	                		 }
	                	 }
	                 },
	                 /*
	                  * reset common filter form function
	                  */
	                 getResetCommonFilterForm: function(button){
	                	 var fields = button.up('form').getForm().getFields();
	                	 fields.each(function(field) {
	                		 if(field.name != 'showStaticFor' && field.name != 'showStaticView' && field.name != 'feePlanType'){
	                			 field.reset();
	                			 if(field.name==='programId' || field.name==='batchId' || field.name==='feeHead'){
	                				 field.onTrigger1Click();
	                			 }
	                		 }
	                	 });
	                	 this.getLoadPrograms();
	                	 var feeAndPaymentCommonFilter = this.getFeeAndPaymentCommonFilter();
	                	 var userTypeField = feeAndPaymentCommonFilter.down("#feeUserType");
	                	 feeAndPaymentCommonFilter.down("#batchId").setDisabled(true);
	                	 userTypeField.clearValue();
	                	 userTypeField.setVisible(false);
	                	 userTypeField.allowBlank = true;
	                	 userTypeField.validate();
	                	 userTypeField.clearInvalid();
	                	 this.setFromAndTillDate(feeAndPaymentCommonFilter);
	                 },
	                 gridRenderFunction:function(grid){
	                	 grid.addButtonToolbar();
	                 },
	                 //**********************************Export Functionality********************************************************
	                 exportUserList : function(exportUrl,filetype,whetherAll,grid,configcode) {
	                	 var quickSearchForm = null;
	                	 var searchResultGrid = null;
	                	 var pagingtoolbaroptions = null; 
	                	 var searchCriteriaString = null;
	                	 var jsonFormatFormData = null;

	                	 quickSearchForm=this.getFeeAndPaymentDashboardStructure(); 
	                	 searchResultGrid = grid;
	                	 pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
	                	 searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	                	 jsonFormatFormData=this.createJsonFormatCommon(configcode);

	                	 var visibleColumns=this.getVisibleColumns(searchResultGrid);
	                	 var reportTitle = searchResultGrid.title;
	                	 if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
	                		 jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
	                	 }
	                	 searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
	                	 console.log("exportSuccess");
	                 }, 
	                 //**************************************End*********************************************************************  
	                 createSearchCriteriaString: function(searchForm) {
	                	 var me=this;
	                	 var formValues = new Array();
	                	 formValues = searchForm.getValues();        
	                	 var searchCriteriaString="";
	                	 for (var key in formValues) {
	                		 var value = formValues[key];            
	                		 if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
	                			 //  var keyValueJsonObject = me.getJsonObject( key , value);
	                			 //searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
	                		 }
	                	 }
	                	 searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
	                	 return searchCriteriaString;
	                 },
	                 /**
	                  * set grid config code for print
	                  */ 
	                 setFirstGridConfiguration : function(grid,configInfo){
	                	 Ext.apply(grid, {
	                		 //  configInfo: null,
	                		 setConfigInfo: function(configInfo) {
	                			 grid.configInfo = configInfo;
	                		 },
	                		 getConfigInfo: function() {
	                			 return grid.configInfo;
	                		 }
	                	 });
	                	 grid.setConfigInfo(configInfo);
	                 },
	                 setSecondGridConfiguration : function(grid,configInfo){
	                	 Ext.apply(grid, {
	                		 configInfo: null,
	                		 setConfigInfo: function(configInfo) {
	                			 grid.configInfo = configInfo;
	                		 },
	                		 getConfigInfo: function() {
	                			 return grid.configInfo;
	                		 }
	                	 });
	                	 grid.setConfigInfo(configInfo);
	                 },
                 createCustomStore : function(searchEndPointURL,searchCriteria,fields){
                	 var me = this;
                	 var store = Ext.create('Ext.data.Store', {
                		 remoteSort : true,
                		 autoLoad: false,
                		 fields : fields,	
                		 proxy: {
                			 type: 'rest',
                			 actionMethods: {
                				 create : 'POST',
                				 read   : 'POST',
                				 update : 'POST',
                				 destroy: 'POST'
                			 },
                			 doRequest: function(operation, callback, scope) {
                				 var writer  = this.getWriter(),
                				 request = this.buildRequest(operation, callback, scope);

                				 if (operation.allowWrite()) {
                					 request = writer.write(request);
                				 }
                				 Ext.apply(request, {
                					 headers       : this.headers,
                					 timeout       : this.timeout,
                					 scope         : this,
                					 callback      : this.createRequestCallback(request, operation, callback, scope),
                					 method        : this.getMethod(request),
                					 jsonData        : this.jsonData,
                					 disableCaching: false // explicitly set it to false, ServerProxy handles caching
                				 });

                				 try {
                					 Ext.Ajax.request(request);
                				 } catch(ex) {
                					 showErrorMessage(getCommonTranslation('ERROR'), getErrorTranslation("UNABLETORETRIEVEDATAFROMTHESERVER"));
                					 Ext.Error.notify = false;
                					 Ext.Error.ignore = true;
                					 Ext.Error.raise(getErrorTranslation("UNABLETORETRIEVEDATAFROMTHESERVER"));
                					 return false;
                				 }

                				 return request;
                			 },
                			 headers: {
                				 'Content-Type': 'application/json'
                			 },
                			 url: searchEndPointURL,
                			 reader : {
                				 type : 'json',
                				 root : 'rows',
                				 totalProperty : 'records',
                				 successProperty : 'success'
                			 },
                			 writer: {
                				 type: 'json',
                				 encode: true
                			 }

                		 },
                		 listeners: {
                			 beforeload: function(store, operation,eOpts) {
                				 store.proxy.jsonData = Ext.encode(searchCriteria);  
                			 }
                		 }
                	 });
                	 return store;
                 },
                 getOpenFeeDashboardReportStructure : function(treePanel, record, item,index, e, eOpts){
                   	  var $this = this;
                   	  var feedashboardstructure = $this.getFeeAndPaymentDashboardStructure();
                   	  var treeTab = feedashboardstructure.down('#feeDashboardReportTreePanelItemId');
                   	  var feeDashboardTabStructure = feedashboardstructure.down('#feeDashboardReportTabStructure');

                   	  var tabDetail = record.data;
                   	  var structure = Ext.widget(tabDetail.reportXtype);

                   	  if (!isNullOrEmpty(tabDetail.text)
                   			  && !isNullOrEmpty(tabDetail.reportXtype)
                   			  && !isNullOrEmpty(tabDetail.reportXtypeItemId)) {
//                   		  treeTab.toggleCollapse();

                   		  openTab(feeDashboardTabStructure, tabDetail.text,structure);
                   		  treePanel.getSelectionModel().deselectAll();
                   	  }
                 },
                 
                 addExportToPngForFeeDashboard:function(panel){
             		var $this = this;
                 	var exportToPNG={
                 			 text: 'Export To Png',
             		         itemId :'exportToPng',
             		         handler: function(btn, target, header, tool){
             		        	 var chart = btn.up('window').items.items[0];
             		        	 var surface = chart.surface;
             		        	 var svg = Ext.draw.engine.SvgExporter.generate(surface);
             		        	 var canvas = document.createElement('canvas');
             		        	 canvas.height = surface.height;
             		        	 canvas.width = surface.width;
             		        	 canvg(canvas, svg);
             		        	 var dataURL = canvas.toDataURL('image/png',1.0);
             		        	 downloadImage(dataURL,'chart.png');
             		         }
             	     };
                 	var exportToJPEG={
                			 text: 'Export To JPG',
             		         itemId :'exportToJPG',
             		         handler: function(btn, target, header, tool){
             		        	 var chart = btn.up('window').items.items[0];
             		        	 var surface = chart.surface;
             		        	 var svg = Ext.draw.engine.SvgExporter.generate(surface);
             		        	 var canvas = document.createElement('canvas');
             		        	 canvas.height = surface.height;
             		        	 canvas.width = surface.width;
             		        	 canvg(canvas, svg);
             		        	 var dataURL = canvas.toDataURL('image/jpeg',1.0);
             		        	 downloadImage(dataURL,'chart.jpeg');
             		         }
             	     };
                 	this.addMenuForFee(exportToPNG,panel);
                 	this.addMenuForFee(exportToJPEG,panel);
             	},
             	addMenuForFee:function(menu,panel){
            		if(!panel)
            			panel=this;
            		var menuBtn = panel.header.down('#extraBtns'),menuPanel = menuBtn.menu;
            		menuBtn.setVisible(true);
            		menuPanel.add(menu);
            	},
            	
            	setFromDateToDateByAcademyYear:function(obj,academyYearId){
            		var resultViewUrl = SERVERURL.ACADEMY_DATE_RANGE;
            		var form = obj.up('form');
            		var startDate = form.down('#fromDate');
            		var tillDate = form.down('#tillDate');
            		Ext.Ajax.request({
            			type: 'rest',
            			url: resultViewUrl + '?academicYear='+academyYearId,
            			method: 'GET',
            			headers: {
            				'Content-Type': 'application/json'
            			},
            			success: function(response) {
            				data = Ext.decode(response.responseText);
            				startDate.setValue(dateRender(data[0].startDate));
            				tillDate.setValue(dateRender(data[0].tillDate));
            			}
            		});
            	}
});
