/**
 *  @author Rajkumar.patidar
 * 
 */
Ext.define('Academia.controller.feeandpayment.discounts.DiscountController',{
	extend: 'Academia.controller.base.BaseController',
	models : [],
	stores : ['feeandpayment.accountingConfigurationMapping.IAUAcademyLocationWise','examinationcenters.evaluation.evaluationPlanHeirarchy.DroolCalculationData',
		      'feeandpayment.discount.DiscountTypeStore','feeandpayment.discount.DiscountListStore','feeandpayment.FeePlanTypeStore',
	          'feeandpayment.MappingStatus','examinationcenters.evaluation.coverageDetails.CourseCoverageStore','feeandpayment.discount.DiscountMasterListStore',
	          'feeandpayment.discount.DiscountFeePlanTypeStageStore','feeandpayment.discount.DiscountFeePlanTypeMappingListStore',
	          'feeandpayment.finance.FinanceALProgramList','feeandpayment.discount.DiscountFeeHeadMappingListStore','othermasters.currencymaster.CurrencyMasterFindALLCurrenciesStore'],
	          views : ['feeandpayment.discounts.DiscountMasterStructure','feeandpayment.discounts.MapFeePlanStructure',
	                   'feeandpayment.discounts.DiscountPanel','feeandpayment.discounts.DiscountList',
	                   'feeandpayment.discounts.DiscountFilters','feeandpayment.discounts.AddDiscount',
	                   'feeandpayment.discounts.ViewMappedFeePlan','baselayout.contentarea.ContentPanel','feeandpayment.discounts.ManageDiscountFeePlanTypeMappingTab',
	                   'feeandpayment.discounts.DiscountWithFeePlanTypeMapStructure','feeandpayment.discounts.DiscountMapFeePlanTypeGrid',
	                   'feeandpayment.discounts.DiscountMapFeeHeadGrid'],
	                   config: {
	                	   DISCOUNT_MAP_FEEPLANTYPE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('DISCOUNT_MAP_FEEPLANTYPE'),
	                	   DISCOUNT_MAP_FEEHEAD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('DISCOUNT_MAP_FEEHEAD'),
	                	   DISCOUNT_MASTER_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('DISCOUNT_MASTER_PRIVILEGES')
	                   },      
	                   refs : [{
                     	  ref: 'contentpanel',
                    	  selector: 'contentpanel'
                      },{
	                	   ref : 'discountfilters',
	                	   selector : 'discountfilters'
	                   },{
	                	   ref : 'discountlist',
	                	   selector : 'discountlist'
	                   },{
	                	   ref : 'adddiscount',
	                	   selector : 'adddiscount'
	                   },{
	                	   ref : 'discountmasterstructure',
	                	   selector : 'discountmasterstructure'
	                   },{
	                	   ref : 'mapfeeplanstructure',
	                	   selector : 'mapfeeplanstructure'
	                   },{
	                	   ref : 'viewmappedfeeplan',
	                	   selector : 'viewmappedfeeplan'
	                   },{
	                       ref: 'viewmappedfeeplan',
	                       selector: 'viewmappedfeeplan[itemId=viewmappedfeeplanwin]'
	                   },{
	                	   ref:'managediscountfeeplantypemappingtabstructure',
	                	   selector:'managediscountfeeplantypemappingtab'
	                   },{
	                	   ref:'discountmapfeeplantypegrid',
	                	   selector:'discountmapfeeplantypegrid'
	                   },{
	                	   ref:'discountwithfeeplantypemapstructure',
	                	   selector:'discountwithfeeplantypemapstructure'
	                   },{
	                	   ref:'discountmapfeeheadgrid',
	                	   selector:'discountmapfeeheadgrid'
	                   }],
	                   init : function() {
	                	   this.control({
	                		   'discountfilters button[itemId=searchBtn]':{
	                			   click : this.getSearchDiscountList
	                		   },
	                		   'discountfilters button[itemId=resetBtn]':{
	                			   click : function(obj){
	                				   var form = obj.up('form').getForm();
	                				   form.reset();
	                			   }
	                		   },
	                		   'discountlist button[itemId=btnAdd]':{
	                			   click : function(obj){
	                				   var $this = this;
	                				   var formWindow = $this.getAdddiscount();
	                				   if (!formWindow) {
	                					   Ext.widget('adddiscount');
	                					   formWindow = $this.getAdddiscount();
	                				   }
	                				   formWindow.show();
	                				   var combo = formWindow.down('#discountTypeItemId');
	                				   combo.getStore().getProxy().extraParams = {
	                					   param: 'add'
	                				   };
	                				   combo.getStore().load();
	                				   Ext.apply(formWindow,{
	                					   editMode:null,
	                					   setEditMode : function(editMode){
	                						   formWindow.editMode = editMode;
	                					   },
	                					   getEditMode:function(){
	                						   return formWindow.editMode;
	                					   }
	                				   });
	                				   formWindow.setEditMode(false);
	                				   var academyLocationId = $this.getCurrentAcademyLocation()
	                				   Ext.Ajax.request({
	                					   method: "GET",
	                					   type: 'rest',
	                					   url: SERVERURL.BASE_CURRENCY_ACADEMY_LOCATION,
	                					   params:{
	                						   academyLocationId:academyLocationId
	                					   },
	                					   success: function(f, action) {
	                						   var a = Ext.JSON.decode(f.responseText);
	                						   var currency = formWindow.down('#discountCurrency');
	                						   var currencyStore = currency.getStore();
	                						   currencyStore.getProxy().extraParams = {
	                							   academyLocationId:academyLocationId
	                						   };
	                						   currencyStore.load({
	                							   callback: function(rec, operation, success) {
	                								   for(var i in rec){
	                									   if(rec[i].data.id==a.id){
	                										   currency.setValue(rec[i].data.id);
	                									   }
	                								   }
	                							   }
	                						   });
	                					   }
	                				   })
	                			   }
	                		   },
	                		   'discountlist button[itemId=btnEdit]':{
	                			   click : function(obj){
	                				   var grid = this.getDiscountlist();
	                				   if(grid.getSelectionModel().getCount() >0) {
	                					   var $this = this;
	                					   var formWindow = $this.getAdddiscount();
	                					   if (!formWindow) {
	                						   Ext.widget('adddiscount');
	                						   formWindow = $this.getAdddiscount();
	                					   }
	                					   formWindow.show();
	                					   Ext.apply(formWindow,{
	                						   editMode:null,
	                						   setEditMode : function(editMode){
	                							   formWindow.editMode = editMode;
	                						   },
	                						   getEditMode:function(){
	                							   return formWindow.editMode;
	                						   }
	                					   });
	                					   formWindow.setEditMode(true);
	                					   var record = grid.getSelectionModel().getSelection()[0].data;
	                					   var discountTypeId=record.discount.id;
	                					   var droolsItemId = formWindow.down('#droolsItemId');
	                					   droolsItemId.setDisabled(false);
	                					   droolsItemId.getStore().getProxy().extraParams={
	                						   moduleName:'DISCOUNT'
	                					   };
	                					   droolsItemId.getStore().load({
	                						   callback:function(records) {
	                							   for(var i in records) {
	                								   if(records[i].data.code == record.rule){
	                									   droolsItemId.setValue(records[i].data.id);
	                								   }
	                							   }
	                						   }
	                					   });
	                					   var combo = formWindow.down('#discountTypeItemId');
	                					   combo.getStore().getProxy().extraParams = {
	                						   param: 'edit',
	                						   discountTypeId:discountTypeId
	                					   };
	                					   combo.getStore().load();
	                					   combo.setValue(record.discount.id);
	                					   formWindow.down('#discountCodeItemId').setValue(record.discountCode);
	                					   formWindow.down('#descriptionItemId').setValue(record.description);
	                					   formWindow.down('#standAloneItemId').setValue(record.whetherStandAlone);
	                					   formWindow.down('#discountCurrency').setReadOnly(true);
                                           var currency = formWindow.down('#discountCurrency');
                                           var currencyStore = currency.getStore();
                                           currencyStore.load({
                                               callback: function(rec, operation, success) {
                                                   for(var i in rec){
                                                       if(rec[i].data.id==record.discountCurrency.id){
                                                           currency.setValue(rec[i].data.id);
                                                       }
                                                   }
                                               }
                                           });
	                					 //  formWindow.down('#discountCurrency').setValue(record.discountCurrency.id);
	                					   if(record.whetherPercentage) {
	                						   formWindow.down('#percentageItemId').setValue(record.whetherPercentage); 
	                						   formWindow.down('#fixedItemId').setDisabled(true);
	                						   formWindow.down('#adhocItemId').setDisabled(true);
	                					   }
	                					   if(record.whetherFixedAmount) {
	                						   formWindow.down('#percentageItemId').setDisabled(true); 
	                						   formWindow.down('#fixedItemId').setValue(record.whetherFixedAmount);
	                						   formWindow.down('#adhocItemId').setDisabled(true);
	                					   }
	                					   if(record.whetherAdhoc) {
	                						   formWindow.down('#percentageItemId').setDisabled(true); 
	                						   formWindow.down('#fixedItemId').setDisabled(true);
	                						   formWindow.down('#adhocItemId').setValue(record.whetherAdhoc);
	                					   }

	                					   Ext.Ajax.request({
	                						   method : "GET",
	                						   type : 'rest',
	                						   url : SERVERURL.PATH_CHECKDISCOUNTMASTER_DEPENDENCY+ '?discountMasterId='+record.id,
	                						   headers : {
	                							   'Content-Type' : 'application/json'
	                						   },
	                						   success : function(form,action) {
	                							   if(form.responseText == 'true')
	                							   {
	                								   //this.toggleReadOnlyFormItems(formWindow.down('form').getForm(), true);
	                								   formWindow.down('form').getForm().getFields().each(function(field) {
	                							        	if(field.xtype !== 'itemselector' && field.xtype != 'multiselectfield') {
	                							        		field.setReadOnly(true);	
	                							        	} else {
	                							        		field.setDisabled(true);
	                							        	}
	                							        });
	                							   }
	                							   //form.down("#applicableFromItemId").clearInvalid();
	                						   }
	                					   });
	                				   } else {
	                					   showWarningMessage(getCommonTranslation('ALERTS'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                				   }
	                			   }
	                		   },
	                		   'discountlist button[itemId=btnView]':{
	                			   click : function(obj){
	                				   var grid = this.getDiscountlist();
	                				   if(grid.getSelectionModel().getCount() >0) {
	                					   var $this = this;
	                					   var formWindow = $this.getAdddiscount();
	                					   if (!formWindow) {
	                						   Ext.widget('adddiscount');
	                						   formWindow = $this.getAdddiscount();
	                					   }
	                					   formWindow.show();
	                					   var record = grid.getSelectionModel().getSelection()[0].data;
	                					   var droolsItemId = formWindow.down('#droolsItemId');
	                					   droolsItemId.setDisabled(false);
	                					   droolsItemId.getStore().getProxy().extraParams={
	                						   moduleName:'DISCOUNT'
	                					   };
	                					   droolsItemId.getStore().load({
	                						   callback:function(records) {
	                							   for(var i in records) {
	                								   if(records[i].data.code == record.rule){
	                									   droolsItemId.setValue(records[i].data.id);
	                								   }
	                							   }
	                						   }
	                					   });
	                					   var combo = formWindow.down('#discountTypeItemId');
	                					   combo.getStore().getProxy().extraParams = {
	                						   param: 'edit'
	                					   };
	                					   combo.getStore().load();
	                					   combo.setValue(record.discount.id);
	                					   formWindow.down('#discountCodeItemId').setValue(record.discountCode);
	                					   formWindow.down('#descriptionItemId').setValue(record.description);
	                					   if(!isNullOrEmpty(record.discountCurrency)){
	                						   formWindow.down('#discountCurrency').setValue(record.discountCurrency.value);
	                					   }
	                					   if(record.whetherPercentage) {
	                						   formWindow.down('#percentageItemId').setValue(record.whetherPercentage); 
	                						   formWindow.down('#fixedItemId').setDisabled(true);
	                						   formWindow.down('#adhocItemId').setDisabled(true);
	                					   }
	                					   if(record.whetherFixedAmount) {
	                						   formWindow.down('#percentageItemId').setDisabled(true); 
	                						   formWindow.down('#fixedItemId').setValue(record.whetherFixedAmount);
	                						   formWindow.down('#adhocItemId').setDisabled(true);
	                					   }
	                					   if(record.whetherAdhoc) {
	                						   formWindow.down('#percentageItemId').setDisabled(true); 
	                						   formWindow.down('#fixedItemId').setDisabled(true);
	                						   formWindow.down('#adhocItemId').setValue(record.whetherAdhoc);
	                					   }
	                					   formWindow.down('#standAloneItemId').setValue(record.whetherStandAlone);
	                					   formWindow.down('#submitButtonId').setVisible(false);
	                					   $this.toggleReadOnlyFormItems(formWindow.down('form').getForm(), true);
	                				   } else {
	                					   showWarningMessage(getCommonTranslation('ALERTS'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                				   }
	                			   }
	                		   },
	                		   'discountlist button[itemId=btnDelete]':{
	                			   click : function(obj){
	                				   var grid = this.getDiscountlist();
	                				   if(grid.getSelectionModel().getCount() >0) {
	                					   var id = grid.getSelectionModel().getSelection()[0].data.id;
	                					   showConfirmMessage(getCommonTranslation('ALERTS'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
	                							   function(btn, text) {
	                						   if (btn == 'yes') {
	                							   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                							   Ext.Ajax.request({
	                								   method : "DELETE",
	                								   type : 'rest',
	                								   url : SERVERURL.DELETE_DISCOUNT_MASTER+ '?id='+id,
	                								   headers : {
	                									   'Content-Type' : 'application/json'
	                								   },
	                								   params : {
	                									   id : id
	                								   },
	                								   success : function(form,action) {
	                									   Ext.getBody().unmask();
	                									   showSuccessMessage(getFeeAndPaymentCommonTranslation('DISCOUNT_MASTER_ADD'),
	                											   getCommonTranslation('SUCCESS'));
	                									   grid.getStore().reload();
	                								   }
	                							   });
	                						   }
	                					   });
	                				   } else {
	                					   showWarningMessage(getCommonTranslation('ALERTS'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                				   }
	                			   }
	                		   },
	                           'viewmappedfeeplan[itemId=viewmappedfeeplanwin] grid[itemId=courseGridItemId] button#btnDelete': {
	                        	   click : function(obj){
	                        		   //var discountGrid = this.getDiscountlist();
	                				  // var grid = obj.up().up();
	                				   var formWindow = this.getViewmappedfeeplan();
	                				   
	                				   var grid = formWindow.down('#courseGridItemId')
	                				   
	                				   if(grid.getSelectionModel().getCount() >0) {
	                					   var id = grid.getSelectionModel().getSelection()[0].data.id;
	                					   showConfirmMessage(getCommonTranslation('ALERTS'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
	                							   function(btn, text) {
	                						   if (btn == 'yes') {
	                							   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                							   Ext.Ajax.request({
	                								   method : "DELETE",
	                								   type : 'rest',
	                								   url : SERVERURL.FEEPLANTYPE_STAGE_DELETE+ '?id='+id,
	                								   headers : {
	                									   'Content-Type' : 'application/json'
	                								   },
	                								   params : {
	                									   id : id
	                								   },
	                								   success : function(form,action) {
	                									   Ext.getBody().unmask();
	                									   showSuccessMessage(getFeeAndPaymentCommonTranslation('DISCOUNT_MASTER_ADD'),
	                											   getCommonTranslation('SUCCESS'));
	                									   formWindow.close();
	                									   grid.getStore().reload();
	                								   }
	                							   });
	                						   }
	                					   });
	                				   } else {
	                					   showWarningMessage(getCommonTranslation('ALERTS'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                				   }
	                			   }
	                		   },
	                		   'discountlist splitbutton[itemId=spBtnMoreActions] #btnMapFeePlanType':{
	                			   click : function(obj){
	                				   var $this = this;
	                				   var grid =  $this.getDiscountlist();
	                				   var record = grid.getSelectionModel().getSelection()[0];
	                				   if(grid.getSelectionModel().getCount() > 0) {
	                					   var contentPanelMain = $this.getContentpanel().getActiveTab();
	                					   var contentPanel = contentPanelMain.down('tabpanel')
	                					   var newTab = contentPanel.items.findBy(function(tab) {
	                						   return tab.title === getFeeAndPaymentCommonTranslation('MAP_FEE_PLAN_TYPE');
	                					   });
	                					   if (!newTab) {
	                						   contentPanel.add({
	                							   title: getFeeAndPaymentCommonTranslation('MAP_FEE_PLAN_TYPE'),
	                							   closable : true,
	                							   autoScroll:true,
	                							   xtype : 'managediscountfeeplantypemappingtab',
	                						   }).show();
	                					   }
	                					   contentPanel.setActiveTab(newTab);
	                					   contentPanel.doLayout();
	                					   var window = $this.getDiscountwithfeeplantypemapstructure();
	                					   var dicountType = window.down('#discountTypeTabMappingId');
	                					   dicountType.setValue(record.data.discount.value);
	                					   var dicountHiddenIdField = window.down('#discountId');
	                					   dicountHiddenIdField.setValue(record.data.id);
	                					   
	                					   var FeePlangrid = this.getDiscountmapfeeplantypegrid();
	                				    	FeePlangrid.getStore().clearFilter();
	                				    	FeePlangrid.getSelectionModel().deselectAll(true);
	                				    	FeePlangrid.getStore().getProxy().extraParams ={
	                				            discountMasterId:record.data.id
	                				            };
	                				    	FeePlangrid.getStore().load();
	                					   
	                				   } else {
	                					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                				   }
	                			   }
	                		   },

	                		   'discountlist':{
	                			   cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
	                				   if (e.target.tagName == 'A') {
	                					   var grid = this.getDiscountlist();
	                					   var $this = this;
	                					   var formWindow = $this.getViewmappedfeeplan();
	                					   if (!formWindow) {
	                						   Ext.widget('viewmappedfeeplan',{
	                   	 						   itemId: "viewmappedfeeplanwin"
	                   	 					   });
	                						   formWindow = $this.getViewmappedfeeplan();
	                					   }
	                					   formWindow.show();
	                					   formWindow.down('#dicountCode').setValue(record.data.discount.value);
	                					   var innerGrid = formWindow.down('grid');
	                					   
	            	                	   var store = innerGrid.getStore();
	            	                	   var json=[];
	                					   for(var i in record.data.feePlanType){
	                						   json.push({
	                							   'courseId':record.data.feePlanType[i].id,
	                						   });
	                					   }
	                					   store.loadRawData(json);
	                					   
	                					   store.getProxy().extraParams = {
	            	                		   discountMasterId:record.data.id,
	            	                	   }
	                					   $this.resetPageSetting(store);
	            	                	   store.load();
	                					   
	                					 /*  var json=[];
	                					   for(var i in record.data.feePlanType){
	                						   json.push({
	                							   'courseId':record.data.feePlanType[i].id,
	                							   'courseName':record.data.feePlanType[i].value,
	                							   'markingType':record.data.feePlanType[i].code
	                						   });
	                					   }*/
	                					   //innerGrid.getStore().loadRawData(json);
	                				   }
	                			   },
	                			   
	                			   afterrender:function(grid){
	             					var me = this;
									setTimeout(function(){
				    					me.addDataGridConfigButton(grid, me.getDISCOUNT_MASTER_PRIVILEGES());
				    				},1500);
	                			   }
	                		   },


	                		   'adddiscount button[itemId=submitButtonId]':{
	                			   click : function(obj){
	                				   var $this = this;
	                				   var formWindow = $this.getAdddiscount();
	                				   var grid = this.getDiscountlist();
	                				   var form = $this.getAdddiscount().down('form');
	                				   var values = form.getForm().getValues();
	                				   var drl;
	                				   var discount = {
	                						   'id': values.discountType
	                				   };
	                				   if(!isNullOrEmpty(form.getForm().findField('drools').getValue())) {
	                					   drl=form.getForm().findField('drools').valueModels[0].data.code;
	                				   }
	                				   var json;
	                				   var submitUrl;
	                				   if(!formWindow.getEditMode()){
	                					   submitUrl = SERVERURL.CREATE_DISCOUNT_MASTER;
	                					   json ={
	                							   "discount":discount,
	                							   "discountCode": values.discountCode,
	                							   "description": values.description,
	                							   "whetherPercentage": values.percentage,
	                							   "whetherFixedAmount": values.fixed,
	                							   "whetherAdhoc": values.adhoc,
	                							   "whetherStandAlone": values.standAlone,
	                							   "rule": drl,
	                							   "discountCurrency":$this.getIdValueJson(values.discountCurrency)
	                					   }; 
	                				   } else {
	                					   submitUrl = SERVERURL.UPDATE_DISCOUNT_MASTER;
	                					   json ={
	                							   "id":grid.getSelectionModel().getSelection()[0].data.id,
	                							   "discount":discount,
	                							   "discountCode": values.discountCode,
	                							   "description": values.description,
	                							   "whetherPercentage": values.percentage,
	                							   "whetherFixedAmount": values.fixed,
	                							   "whetherAdhoc": values.adhoc,
	                							   "whetherStandAlone": values.standAlone,
	                							   "rule": drl,
                                                   "discountCurrency":$this.getIdValueJson(values.discountCurrency)
	                					   }; 
	                				   }
	                				   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                				   Ext.Ajax.request({
	                					   type : 'rest',
	                					   url : submitUrl,
	                					   jsonData : json,
	                					   method : 'POST',
	                					   success : function(form, action) {
	                						   Ext.getBody().unmask();
	                						   showSuccessMessage(getFeeAndPaymentCommonTranslation('DISCOUNT_MASTER_ADD'),
	                								   getCommonTranslation('SUCCESS'));
	                						   formWindow.close();
	                						   grid.getSelectionModel().deselectAll();
	                						   grid.getStore().reload();
	                					   }
	                				   });
	                			   }
	                		   },
	                		   'adddiscount customcombobox[itemId=discountTypeItemId]':{
	                			   select : function(obj){
	                				   var $this = this;
	                				   var formWindow = $this.getAdddiscount();
	                				   var droolsItemId = formWindow.down('#droolsItemId');
	                				   var values = formWindow.down('form').getForm().getValues();
	                				   droolsItemId.setDisabled(false);
	                				   droolsItemId.getStore().getProxy().extraParams={
	                					   moduleName:'DISCOUNT'
	                				   };
	                				   droolsItemId.getStore().load();
	                				   if( formWindow.down('form').getForm().isValid() && (values.percentage || values.fixed || values.adhoc)) {
	                					   formWindow.down('#submitButtonId').setDisabled(false);
	                				   } else {
	                					   formWindow.down('#submitButtonId').setDisabled(true);
	                				   }
	                			   }
	                		   },

	                		   'adddiscount textfield[itemId=discountCodeItemId]':{
	                			   blur : function(obj){
	                				   var $this = this;
	                				   var formWindow = $this.getAdddiscount();
	                				   var values = formWindow.down('form').getForm().getValues();
	                				   if( formWindow.down('form').getForm().isValid() && (values.percentage || values.fixed || values.adhoc)) {
	                					   formWindow.down('#submitButtonId').setDisabled(false);
	                				   } else {
	                					   formWindow.down('#submitButtonId').setDisabled(true);
	                				   }
	                			   }
	                		   },
	                		   'adddiscount textfield[itemId=descriptionItemId]':{
	                			   blur : function(obj){
	                				   var $this = this;
	                				   var formWindow = $this.getAdddiscount();
	                				   var values = formWindow.down('form').getForm().getValues();
	                				   if( formWindow.down('form').getForm().isValid() && (values.percentage || values.fixed || values.adhoc)) {
	                					   formWindow.down('#submitButtonId').setDisabled(false);
	                				   } else {
	                					   formWindow.down('#submitButtonId').setDisabled(true);
	                				   }
	                			   }
	                		   },
//	                		   discountCodeItemId
	                		   /* render: function(obj) {
	                				   var $this = this;
	                				   var formWindow = $this.getAdddiscount();
	                                   var combo = formWindow.down('#discountTypeItemId');
	                                   combo.getStore().getProxy().extraParams = {
	                					   param: 'add'
	                				   };
	                                   combo.getStore().load();
	                			   }*/

	                		   'adddiscount checkboxfield#percentageItemId':{
	                			   change:function(obj, newValue, oldValue, eOpts ){
	                				   var $this = this;
	                				   var formWindow = $this.getAdddiscount();
	                				   var fixedItemId = formWindow.down('#fixedItemId');
	                				   var adhocItemId = formWindow.down('#adhocItemId');
	                				   if(newValue){
	                					   adhocItemId.setDisabled(true);
	                					   fixedItemId.setDisabled(true);
	                				   }else{
	                					   adhocItemId.setDisabled(false);
	                					   fixedItemId.setDisabled(false);
	                				   }
	                				   var $this = this;
	                				   var formWindow = $this.getAdddiscount();
	                				   var values = formWindow.down('form').getForm().getValues();
	                				  if(values.percentage || values.fixed || values.adhoc) {
	                					   formWindow.down('#checkWhetherCheckboxEmpty').setValue(true);
	                				   } else {
	                					   formWindow.down('#checkWhetherCheckboxEmpty').setValue('');
	                				   }
	                				   formWindow.down('form').getForm().isValid();
	                			   }
	                		   },

	                		   'adddiscount checkboxfield#adhocItemId':{
	                			   change:function(obj, newValue, oldValue, eOpts ){
	                				   var $this = this;
	                				   var formWindow = $this.getAdddiscount();
	                				   var percentageItemId = formWindow.down('#percentageItemId');
	                				   var fixedItemId = formWindow.down('#fixedItemId');
	                				   if(newValue){
	                					   fixedItemId.setDisabled(true);
	                					   percentageItemId.setDisabled(true);
	                				   }else{
	                					   fixedItemId.setDisabled(false);
	                					   percentageItemId.setDisabled(false);
	                				   }
	                				   var $this = this;
	                				   var formWindow = $this.getAdddiscount();
	                				   var values = formWindow.down('form').getForm().getValues();
	                				   if( values.percentage || values.fixed || values.adhoc) {
	                					   formWindow.down('#checkWhetherCheckboxEmpty').setValue(true);
	                				   } else {
	                					   formWindow.down('#checkWhetherCheckboxEmpty').setValue('');
	                				   }
	                				   formWindow.down('form').getForm().isValid();
	                			   }
	                		   },

	                		   'adddiscount checkboxfield#fixedItemId':{
	                			   change:function(obj, newValue, oldValue, eOpts ){
	                				   var $this = this;
	                				   var formWindow = $this.getAdddiscount();
	                				   var percentageItemId = formWindow.down('#percentageItemId');
	                				   var adhocItemId = formWindow.down('#adhocItemId');
	                				   if(newValue){
	                					   adhocItemId.setDisabled(true);
	                					   percentageItemId.setDisabled(true);
	                				   }else{
	                					   adhocItemId.setDisabled(false);
	                					   percentageItemId.setDisabled(false);
	                				   }
	                				   var $this = this;
	                				   var formWindow = $this.getAdddiscount();
	                				   var values = formWindow.down('form').getForm().getValues();
	                				    if(values.percentage || values.fixed || values.adhoc) {
	                					   formWindow.down('#checkWhetherCheckboxEmpty').setValue(true);
	                				   } else {
	                					   formWindow.down('#checkWhetherCheckboxEmpty').setValue('');
	                					   
	                				   }
	                				   formWindow.down('form').getForm().isValid();
	                			   }
	                		   },

	                		   'adddiscount button[itemId=cancelButtonId]':{
	                			   click : function(obj){
	                				   var $this = this;
	                				   var formWindow = $this.getAdddiscount();
	                				   formWindow.close();
	                			   }
	                		   },
	                		   'mapfeeplanstructure button[itemId=addFilterBtn]':{
	                			   click: function(obj){
	                				   this.addFeePlanType(obj);
	                			   }
	                		   },
	                		   'mapfeeplanstructure':{
	                			   afterrender: function(obj){
	                				   var $this = this;
	                				   var feePlanType = obj.down('#feePlanType');
	                				   var stage = obj.down('#stage');
	                				   feePlanType.getStore().load({
	                					   callback:function(record) {
	                						   for(var i in record) {
	                							   if(record[i].data.value=='Program' || record[i].data.value=='Class'){
	                								   feePlanType.setValue(record[i].data.id);
	                								   stage.setDisabled(false);
	                								   stage.getStore().getProxy().extraParams={
	                									   feePlanTypeId:record[i].data.id
	                								   };
	                								   stage.getStore().load({
	                									   callback:function(records) {
	                										   for(var j in records) {
	                											   if(records[j].data.id==6){
	                												   stage.setValue(records[j].data.id); 
	                											   }
	                										   }
	                									   }
	                								   });
	                							   }
	                						   }
	                					   }
	                				   });
	                			   }
	                		   },
	                		   'mapfeeplanstructure button[itemId=mappingSaveBtn]':{
	                			   click: function(obj){
	                				   var $this = this;
	                				   var formWindow = this.getMapfeeplanstructure();
	                				   var grid =  $this.getDiscountlist();
	                				   var json = $this.generateJson(grid);
	                				   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                				   var submitUrl = SERVERURL.CREATE_FEE_PLAN_DISCOUNT_STAGE;
	                				   Ext.Ajax.request({
	                					   type : 'rest',
	                					   url : submitUrl,
	                					   jsonData : json,
	                					   method : 'POST',
	                					   success : function(resp, action) {
	                						   Ext.getBody().unmask();
	                						   showSuccessMessage(getExaminationTranslation('SUCCESS'),getCommonTranslation('SUCCESS'));
	                						   var  contentPanelMain = $this.getContentpanel().getActiveTab();
	                						   var contentPanel = contentPanelMain.down('tabpanel');
	                						   contentPanel.items.items[1].close();
	                						   grid.getSelectionModel().deselectAll();
	                						   grid.getStore().reload();
	                					   }
	                				   });
	                			   }
	                		   },
	                		   'discountmasterstructure': {
	                			   render:function(discountmasterstructure){
	                				   this.enableTabforDiscountPanel(discountmasterstructure);
	                			   },
	                			   afterrender:function(structure){
	                				   var grid = structure.down('discountlist');
	                				   this.getGridHeaderFreeze(grid,structure,true);
	                			   }   
	                		   },
	                		   'discountmapfeeplantypegrid button#nextButton':{
	                			   click:function(btn){
	                				   this.discountMapFeePlanTypeNextEvent(btn);
	                			   }
	                		   },
	                		   'discountwithfeeplantypemapstructure button#resetBtn':{
	                			   click:function(btn){
	                				   var tabStructure = this.getDiscountwithfeeplantypemapstructure();

	                				   var activeGrid = tabStructure.getActiveTab().down('grid');
	                				   activeGrid.getSelectionModel().deselectAll();
	                				   activeGrid.getStore().clearFilter();
										var feeHeadGrid = this.getDiscountmapfeeheadgrid()
										var feePlanTxt = feeHeadGrid.down('#feePlanNametext');
										feePlanTxt.setValue('');
										feeHeadGrid.down('#searchBtn').setDisabled(true);
										this.discountMapFeePlanTypeNextEvent();
	                			   }
	                		   },
	                		   'discountwithfeeplantypemapstructure button#submitBtn':{
	                			   click:function(btn){
	                				   this.submitDiscountMappingWithFeeplanStageType();
	                			   }
	                		   },
	                		   'discountmapfeeplantypegrid': {
	                			   render: function(grid){
	                				   this.disableSubmitActionPivileges(grid,this.getDISCOUNT_MAP_FEEPLANTYPE_PERMISSIONS());
	                			   }
	                		   },
	                		   'discountmapfeeheadgrid': {
	                			   render: function(grid){
	                				   this.disableSubmitActionPivileges(grid,this.getDISCOUNT_MAP_FEEHEAD_PERMISSIONS());

										
	                			   }
	                		   },'discountmapfeeheadgrid button[itemId=searchBtn]': {
					                 click: this.loadFeePlan
					             },

								
								
								'discountmapfeeheadgrid customcombobox#feePlanNametext':{
	                           select:function(view,newVal,oldValue){
									var searchbtn = this.getDiscountmapfeeheadgrid();
									searchbtn.down('#searchBtn').setDisabled(false);
									}
								},
	                	   });
	                   },
	                   
	                   
            		   enableTabforDiscountPanel:function(discountmasterstructure){
            		 	   this.showTabforDiscountPanel(discountmasterstructure);
            		    },
            		    showTabforDiscountPanel : function(discountmasterstructure) {
            		  	   var panelItem = new Array();
            		  	   var $this = this;
            		  	   var newcont=discountmasterstructure.items.items.length;
            		  	   var insertPosition=newcont+1;
            		  		   panelItem.push({
            		  			   xtype:'tabpanel',
            		  			   itemId:'allVisibleTP',
            		  			   style:{'margin':'0px !important'},
            		  			   plain: true,
            		  			   frame: false,
            		  			   items:[{
            		  					 xtype : 'discountpanel',  
            		  					 title: getCommonTranslation('SEARCH'),
            		  					 tabCls: 'right-tab',
            		  					 listeners: {
            		  						 activate: function(me, eOpts){
            		  							 var  contentPanelMain = $this.getContentpanel().getActiveTab();
            		  							 setTimeout(function(){
            		  								 contentPanelMain.scrollBy(0,1);
            		  								 contentPanelMain.scrollBy(0,-1);
            		  							 },5);
            		  						 }
            		  					 }
            		  				}]
            		  		   });

            		  		 discountmasterstructure.insert(insertPosition,panelItem);
            		     },
	                   
	                   
	                   
	                   
	                   generateJson:function(grid) {
	                	   var this$ = this;
	                	   var record = grid.getSelectionModel().getSelection()[0];
	                	   var basicStudentSearchForm=this$.getMapfeeplanstructure();
	                	   var pbpsContiner = basicStudentSearchForm.down('#programBatchContainerId');
	                	   var pbpsFieldsCount = pbpsContiner.items.length;
	                	   var pbpsArray=new Array();
	                	   var endJson=null;
	                	   var fieldSequence=1;
	                	   for(var j=0; j<pbpsContiner.items.length; j++){
	                		   var pbpsPanelContainer=pbpsContiner.items.items[j];
	                		   var typeId={
	                				   'id':pbpsPanelContainer.items.items[0].getValue()
	                		   };
	                		   var stageId={
	                				   'id':pbpsPanelContainer.items.items[1].getValue()
	                		   };
	                		   var discountId={
	                				   'id':record.data.id
	                		   };
	                		   pbpsArray.push({
	                			   'feePlanType':typeId,
	                			   'feeStageMaster':stageId,
	                			   'discountMaster':discountId
	                		   });
	                	   }
	                	   return pbpsArray;	

	                   },
	                   getSearchDiscountList : function(obj){
	                	   var $this = this;
	                	   var form = obj.up('form');
	                	   form.down('#searchBtn').setDisabled(true);
	                	   var getForm = form.getForm();
	                	   var getFormValues = getForm.getValues();
	                	   var grid = this.getDiscountlist();
						   grid.config.searchFilterForm = form;
	                	   var store = grid.getStore();
	                	   store.getProxy().extraParams = {
	                		   discountTypeId:getFormValues.discountType,
	                		   percentage:getFormValues.percentage,
	                		   fixed:getFormValues.fixed,
	                		   standAlone:getFormValues.standAlone,
	                		   adhoc:getFormValues.adhoc
	                	   },
	                	   $this.resetPageSetting(store);
	                	   grid.getSelectionModel().deselectAll();
	                	   store.load({
							   callback: function(rec, operation, success) {
								   form.down('#searchBtn').setDisabled(false); 
							   }
						   });
	                   },

	                   addFeePlanType:function(obj) {
	                	   var $this = this;
	                	   var stopContiner = $this.getMapfeeplanstructure().down('#programBatchContainerId');
	                	   var from = $this.getMapfeeplanstructure().getForm();
	                	   var panelItem = new Array();
	                	   var fieldContainer=obj.up('fieldcontainer');
	                	   var newcont=stopContiner.items.items.length;
	                	   var insertPosition=newcont+1;
	                	   panelItem.push({
	                		   xtype : 'fieldcontainer',
	                		   layout : 'hbox',
	                		   defaults: {
	                			   labelAlign: 'top',
	                			   width: 256   
	                		   },
	                		   items : [{
	                			   xtype: 'customcombobox',
	                			   name: 'feePlanType',
	                			   itemId:'feePlanType',
	                			   valueField: 'id',
	                			   displayField: 'value',
	                			   allowBlank:false,	
	                			   typeAhead:true,
	                			   forceSelection:true,
	                			   style:{
	                				   marginRight:'10px !important'
	                			   },
	                			   listeners: {
	                				   render: function(combo) {
	                					   var store = Ext.create('Academia.store.feeandpayment.FeePlanTypeStore');
	                					   combo.bindStore(store);
	                				   },
	                				   select:function(obj,record){
	                					   var typeId = record[0].get("id");
	                					   var  stage = obj.nextSibling();
	                					   stage.reset();
	                					   stage.setDisabled(false);
	                					   var store = stage.getStore();
	                					   store.proxy.extraParams = {
	                							   feePlanTypeId : typeId
	                					   };
	                					   store.load();
	                				   }
	                			   },
	                			   listConfig: {
	                				   listeners: {
	                					   beforeshow: function(picker) {
	                						   picker.minWidth = picker.up('combobox').getSize().width;
	                					   }
	                				   },
	                				   loadingText: getCommonTranslation('SEARCHING'),
	                				   emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                				   getInnerTpl: function() {
	                					   return '<div class="search-item">' +
	                					   '{value}' +
	                					   '</div>';
	                				   }
	                			   }
	                		   },{
	                			   xtype: 'customcombobox',
	                			   name: 'stage',
	                			   itemId:'stage',
	                			   valueField: 'id',
	                			   displayField: 'value',
	                			   typeAhead:true,
	                			   allowBlank:false,
	                			   disabled:true,
	                			   forceSelection:true,
	                			   listeners: {
	                				   render: function(combo) {
	                					   var store = Ext.create('Academia.store.feeandpayment.FeePlanStageType');
	                					   combo.bindStore(store);
	                				   }
	                			   }
	                		   },{
	                			   xtype: 'button',
	                			   itemId: 'delFilterBtn',
	                			   cls: 'CustomBodyBtnReject',
	                			   width: 30,
	                			   glyph: ICONGLYPH.DELETEGLYPH,
	                			   tooltip: getCommonTranslation('DELETE'),
	                			   listeners:{
	                				   click:function(obj){
	                					   var container = obj.up('fieldcontainer');
	                					   var panelContiner = $this.getMapfeeplanstructure().down('#programBatchContainerId');
	                					   panelContiner.remove(container);
	                					   if(from.isValid()) {
	                						   $this.getMapfeeplanstructure().down('#mappingSaveBtn').setDisabled(false);
	                					   } else {
	                						   $this.getMapfeeplanstructure().down('#mappingSaveBtn').setDisabled(true);
	                					   }
	                				   }}
	                		   },{
	                			   xtype: 'button',
	                			   itemId: 'addFilterBtn',
	                			   width: 30,
	                			   cls: 'CustomBodyBtnSettings',
	                			   text: getCommonTranslation('ADDBUTTONTEXT'),
	                			   tooltip: getCommonTranslation('ADD'),
	                			   style:{
	                				   marginLeft:'0px !important'
	                			   }
	                		   }]
	                	   });
	                	   stopContiner.insert(insertPosition,panelItem);
	                	   stopContiner.doLayout();
	                   },
	                   discountMapFeePlanTypeNextEvent:function(btn){
	                	   var discountMapFeePlanTypeGrid = this.getDiscountmapfeeplantypegrid();
	                	   var grid =  this.getDiscountlist();
	                	   var record = grid.getSelectionModel().getSelection()[0];
	                	   var selectionModel = discountMapFeePlanTypeGrid.getSelectionModel().getSelection();
	                	   var discountMapFeePlanTypeIdsArr = [];
	                	   selectionModel.forEach(function(obj){
	                		   discountMapFeePlanTypeIdsArr.push(obj.get('id'));
	                	   });
	                	   if(discountMapFeePlanTypeIdsArr.length > 0){
	                		   var discountWithFeePlanTypeMapStructure = this.getDiscountwithfeeplantypemapstructure();
	                		   var feeHeadContainer = discountWithFeePlanTypeMapStructure.down('#feeHeadContainer');
	                		   feeHeadContainer.setDisabled(false);
	                		   discountWithFeePlanTypeMapStructure.setActiveTab(feeHeadContainer);
	                		   var discountMapfeeheadgrid = this.getDiscountmapfeeheadgrid();
	                		   var discountMapfeeheadgridStore = discountMapfeeheadgrid.getStore();
								discountMapfeeheadgridStore.removeAll();
							   var textValueCombo = discountMapfeeheadgrid.down('#feePlanNametext');
								textValueCombo.setValue('');
								discountMapfeeheadgrid.down('#searchBtn').setDisabled(true);
								var store = discountMapfeeheadgrid.down('#feePlanNametext').getStore();
                                store.removeAll();
                                store.getProxy().extraParams= {
	                            feePlanNametext: '',
     							stageIds: discountMapFeePlanTypeIdsArr.join(),
                                discountMasterId:record.data.id,
								flagForExactSearch:false
                				};
								store.load();

								discountMapfeeheadgridStore.getProxy().extraParams= {
								   feePlanNametext: '',
	                			   stageIds: discountMapFeePlanTypeIdsArr.join(),
	                		   	   discountMasterId:record.data.id,
								   flagForExactSearch:false
	                		   };
	                		   discountMapfeeheadgridStore.clearFilter();
	                		   discountMapfeeheadgridStore.load();



	                		   var structure = this.getDiscountwithfeeplantypemapstructure();
	                		   if(structure !=undefined){
	                			   var discountTypeValue = structure.down('#discountTypeTabMappingId').getValue();
	                			   var discountIdValue = structure.down('#discountId').getValue();
	                			   structure.down("#discountTypeHeadId").setValue(discountTypeValue); 
	                			   structure.down("#discountId").setValue(discountIdValue); 
	                		   }

	                	   } else {
	                		   showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
	                	   }
	                   },

						loadFeePlan: function() {
				    	   var discountMapFeePlanTypeGrid = this.getDiscountmapfeeplantypegrid();
	                	   var grid =  this.getDiscountlist();
	                	   var record = grid.getSelectionModel().getSelection()[0];
	                	   var selectionModel = discountMapFeePlanTypeGrid.getSelectionModel().getSelection();
	                	   var discountMapFeePlanTypeIdsArr = [];
	                	   selectionModel.forEach(function(obj){
	                		   discountMapFeePlanTypeIdsArr.push(obj.get('id'));
	                	   });
	                	   if(discountMapFeePlanTypeIdsArr.length > 0){
	                		   var discountWithFeePlanTypeMapStructure = this.getDiscountwithfeeplantypemapstructure();
	                		   var feeHeadContainer = discountWithFeePlanTypeMapStructure.down('#feeHeadContainer');
	                		   feeHeadContainer.setDisabled(false);
	                		   discountWithFeePlanTypeMapStructure.setActiveTab(feeHeadContainer);
	                		   var discountMapfeeheadgrid = this.getDiscountmapfeeheadgrid();
	                		   var discountMapfeeheadgridStore = discountMapfeeheadgrid.getStore();

								var feePlantext = discountMapfeeheadgrid.down('#feePlanNametext').value;
                                

	                		   discountMapfeeheadgridStore.removeAll();
	                		   //discountMapfeeheadgridStore.currentPage = 1;
	                		   discountMapfeeheadgridStore.getProxy().extraParams= {
								   feePlanNametext: feePlantext,
	                			   stageIds: discountMapFeePlanTypeIdsArr.join(),
	                		   	   discountMasterId:record.data.id,
								   flagForExactSearch:true
	                		   };
	                		   discountMapfeeheadgridStore.clearFilter();
	                		   discountMapfeeheadgridStore.load();
	                		   var structure = this.getDiscountwithfeeplantypemapstructure();
	                		   if(structure !=undefined){
	                			   var discountTypeValue = structure.down('#discountTypeTabMappingId').getValue();
	                			   var discountIdValue = structure.down('#discountId').getValue();
	                			   structure.down("#discountTypeHeadId").setValue(discountTypeValue); 
	                			   structure.down("#discountId").setValue(discountIdValue); 
	                		   }
				      }
},



	                   submitDiscountMappingWithFeeplanStageType: function(btn){
	                   	var tabStructure = this.getDiscountwithfeeplantypemapstructure();
	                   	var discountMasterId = tabStructure.down('#discountId').getValue();
	                   	var activeGrid = tabStructure.getActiveTab().down('grid');
	                   	var selectedRecord = activeGrid.getSelectionModel().getSelection();
	                   	var submitJsonArr = [];
	                   	if(selectedRecord.length>0){
	                   		var submitUrl = SERVERURL.CREATE_FEE_PLAN_DISCOUNT_STAGE;
	                   		if(activeGrid.xtype == 'discountmapfeeplantypegrid'){
	               	    		selectedRecord.forEach(function(obj){
	               	    			submitJsonArr.push({
	               	    				discountMaster: {id:parseInt(discountMasterId)},
	               	    				feeStageMaster: {id:obj.get('id')},
	               	    				feePlanType:{id:obj.get('feePlanTypeId')}
	               	    			});
	               	    		});
	               	    		
	                   		} else if(activeGrid.xtype == 'discountmapfeeheadgrid'){
	                   			submitUrl = SERVERURL.PATH_FEESTAGE_WITH_FEEHEADS;
	                   			selectedRecord.forEach(function(obj){
	               	    			submitJsonArr.push({
	               	    				discountMaster: {id:parseInt(discountMasterId)},
	               	    				feeStageMaster: {id:obj.get('feeStageMasterId')},
	               	    				feePlanType:{id:obj.get('feePlanTypeId')},
	               	    				feeStageHeadConfig:{id:obj.get('feeStageHeadConfigurationsId')},
	               	    			});
	               	    		});
	                   		}
	                   		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                   		Ext.Ajax.request({
	                   			method: "POST",
	                   			type: 'rest',
	                   			url: submitUrl,
	                   			scope:this,
	                   			jsonData:submitJsonArr,
	                   			success : function(response, action) {
	                   				Ext.getBody().unmask();
	                   				var mainTabContentPanel = this.getDiscountmasterstructure();
	                   				var tabPanel = mainTabContentPanel.down('panel');
	                   		    	var tabName = getFeeAndPaymentCommonTranslation('MAP_FEE_PLAN_TYPE');
	                   		    	var getTab=tabPanel.getActiveTab(tabName);
	                   		    	if(getTab!=null){
	                   		    		tabPanel.remove(getTab, true);
	                   		    	}
	                   		    	var grid = this.getDiscountlist();
	                   		    	var grdStore = grid.getStore();
	                   		    	grdStore.load();
	                   		    	
	                   		    	var data = response.responseText;
	                   		    	showSuccessMessage(getFeeAndPaymentCommonTranslation('MAP_FEE_PLAN_TYPE'), getCommonTranslation('SUCCESS'));
	                         		/*	if(data == getFeeAndPaymentCommonTranslation('APPLICABLE_FOR_SUCCESS')){
	                         				showSuccessMessage(getFeeAndPaymentCommonTranslation('APPLICABLE_FOR'), getFeeAndPaymentCommonTranslation('APPLY_TO_CREATED_SUCCESS'));
	                         			} else {
	                         				var alertWin = this.getFeedomappingalertwin();
	                         				if(!alertWin){
	                         					alertWin = Ext.widget('feedomappingalertwin');
	                         				}
	                         				alertWin.down('#feePlanAlert').setValue(data);
	                         				alertWin.show();
	                         			}*/
	                   			}
	                   		});
	                   	} else {
	                   		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
	                   	}
	                   },
	                   disableSubmitActionPivileges: function(gridReference,permissionsMap) {
	                	   var associatedAcadLocationIds = new Array();
	                	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
	                	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	                	   var submitBtn = gridReference.down('#submitBtn');
	                	   submitBtn.setVisible(false);
	                	   var buttonsToolBar = gridReference.query('toolbar')[0];
	                	   Ext.each(permissionList, function(privilege) {
	                		   if (privilege === 'SUBMIT') {
	                			   var button = buttonsToolBar.query('#submitBtn')[0];
	                			   if(!isNullOrEmpty(button)){
	                				   submitBtn.setVisible(true);
	                			   }        		
	                		   }
	                	   });
	                   },
	               	 getIdValueJson: function(id, value) {
	             		if (id) return {
	             			id: id,
	             			value: value
	             		};
	             	}
});
