/**
 *  @author Rajkumar.patidar
 * 
 */
Ext.define('Academia.controller.feeandpayment.discounts.ManageDiscountController', {
    extend: 'Academia.controller.base.BaseController',
    models: ['feeandpayment.discounts.ViewSettledDiscountModel'],
    stores: ['feeandpayment.accountingConfigurationMapping.IAUAcademyLocationWise',
        'examinationcenters.evaluation.evaluationPlanHeirarchy.DroolCalculationData',
        'feeandpayment.discount.DiscountTypeStore', 'feeandpayment.ProgramBatchSeatTypeStore',
        'feeandpayment.discount.DiscountListStore', 'feeandpayment.managebill.Student',
        'importutility.ModuleName', 'feeandpayment.discount.ManageDiscountListStore', 'criteriabuilder.userquicksearch.QuickSearchName',
        'importutility.ImportDiscountStore', 'feeandpayment.discount.DiscountStatusStore', 'feeandpayment.discount.DiscountPercentageStore',
        'user.UserAcademyLocationStore','common.IntakeYearStore','feeandpayment.ALProgramBatchSearchCombo',
        'feeandpayment.ALProgramBatchSeatTypeList','common.AssignedProgramStore',
        'feeandpayment.discount.DiscountMasterListStore','Academia.store.common.IntakeYearStore',
        'common.ProgramForBillStoreFeePayment','enquiry.AcademicBatchStore','common.SeatTypesByBatchId',
        'feeandpayment.discount.UserSmartSearchByUserCode','feeandpayment.discount.ViewSettledDiscountStore','feeandpayment.discount.ViewSettledDiscountApplicantStore',
        'feeandpayment.discount.DiscountTypeListByStudentStore','feeandpayment.dashboardAndReports.DiscountFindAllUserTypeStore',
        'feeandpayment.managebill.Applicant','feeandpayment.reports.InstrumentReportUserFindAllStore','feeandpayment.discount.DiscountApplicantStore',
        'feeandpayment.discount.AddDiscountStudentSibilingGridStore','common.AcademyLocationNameSeparated', 'feeandpayment.discount.AddDiscountStudentParentGridStore'
    ],
    views: ['baselayout.contentarea.ContentPanel', 'feeandpayment.discounts.ManageDiscountPanel',
        'feeandpayment.discounts.ManageDiscountStructure',
        'feeandpayment.discounts.ManageDiscountFilter', 'feeandpayment.discounts.AddDiscountStructure',
        'feeandpayment.discounts.ManageDiscountStudentList', 'feeandpayment.discounts.AddManageDiscount',
        'feeandpayment.discounts.uploaddownload.DiscountUploadDownloadStructure',
        'feeandpayment.discounts.uploaddownload.DiscountUploadForm',
        'feeandpayment.discounts.uploaddownload.DiscountDownloadForm',
        'importutility.ImportByModule.ImportListDiscountGrid', 'feeandpayment.discounts.AddDiscountEntryStructure',
        'common.AddressDetailPanel','feeandpayment.discounts.DiscountApproveReject','feeandpayment.discounts.ViewSettledDiscount',
        'feeandpayment.discounts.ManageDiscountApplicantList',
        'UploadOptionRadioGroup','feeandpayment.discounts.AddDiscountStudentSibilingGrid','feeandpayment.discounts.AddDiscountStudentParentGrid',
        'feeandpayment.discounts.AddDiscountApplicantSibilingGrid','personinfo.common.paymentandrefund.ReceiptGridForApplicant',
        'admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionPaymentsGrid','admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionRefundsGrid',
        'feeandpayment.reports.FeeHeadWiseCollectionReportForm','feeandpayment.reports.FeeHeadWiseCollectionReportGrid','feeandpayment.reports.ApplicantFeeHeadWiseCollectionReportForm','feeandpayment.reports.ApplicantFeeHeadWiseCollectionReportGrid',
		'programCourseDashboard.organizationUnit.OrganizationUnit'
    ],
    config: {
   		CORE_ERP_LOADER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_LOADER_PRIVILEGES'),
        MANAGE_DISCOUNT_SCREEN_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_DISCOUNT_SCREEN_PRIVILEGES') ,
        ADD_DISCOUNT_STUDENT_SIBLING_GRID_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ADD_DISCOUNT_STUDENT_SIBLING_GRID_PRIVILEGES'),
   		ADD_DISCOUNT_STUDENT_PARENT_GRID_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ADD_DISCOUNT_STUDENT_PARENT_GRID_PRIVILEGES')
    },
    refs: [{
    	ref:'raisebillform',
    	selector:'raisebillform'
    },{
    	ref: 'contentpanel',
    	selector: 'contentpanel'
    }, {
        ref: 'managediscountfilter',
        selector: 'managediscountfilter'
    }, {
        ref: 'managediscountstudentlist',
        selector: 'managediscountstudentlist'
    }, {
        ref: 'adddiscountentrystructure',
        selector: 'adddiscountentrystructure'
    }, {
        ref: 'managediscountstructure',
        selector: 'managediscountstructure'
    }, {
        ref: 'discountaddressdetailpanel',
        selector: 'addressdetailpanel[itemId=manageDiscount]'
    }, {
        ref: 'addmanagediscount',
        selector: 'addmanagediscount'
    }, {
        ref: 'importlistdiscountgrid',
        selector: 'importlistdiscountgrid'
    }, {
        ref: 'discountapprovereject',
        selector: 'discountapprovereject'
    }, {
        ref: 'discountdownloadform',
        selector: 'discountdownloadform'
    },{
    	ref: 'viewsettleddiscount',
        selector: 'viewsettleddiscount'
    }, {
        ref: 'managediscountapplicantlist',
        selector: 'managediscountapplicantlist'
    },{
   		ref : 'uploadoptionradiogroup',
   		selector : 'uploadoptionradiogroup[itemId=discountUploadOptionRadioGroupItemId]'
   	},{
   		ref: 'adddiscountstudentsibilinggrid',
   		selector: 'adddiscountstudentsibilinggrid',
	},{
		ref: 'adddiscountstudentparentgrid',
		selector: 'adddiscountstudentparentgrid'
	},{
     	 ref : 'pendingbillsgrid',
    	 selector : 'pendingbillsgrid'
     },{
    	 ref : 'paymentreceivedhistorygrid',
    	 selector : 'paymentreceivedhistorygrid'
     },{
    	 ref : 'refundhistorygrid',
    	 selector : 'refundhistorygrid'
     },{
      	 ref : 'pendingbillsgrid',
    	 selector : 'pendingbillsgrid'
     },{
    	 ref : 'transportpersondetailsgrid',
    	 selector : 'transportpersondetailsgrid[itemId=paymenttransportpersondetailsgrid]'
     },{
    	 ref : 'hostelpersondetailsgrid',
    	 selector : 'hostelpersondetailsgrid[itemId=paymenthostelpersondetailsgrid]'
     },{
   	   ref : 'receiptgridforapplicant',
	   selector : 'receiptgridforapplicant' 
   }
   ,{
 	   ref : 'preadmissionpaymentsgrid',
	   selector : 'preadmissionpaymentsgrid' 
   },{
 	   ref : 'preadmissionrefundsgrid',
	   selector : 'preadmissionrefundsgrid' 
   },{
	   ref : 'feeheadwisecollectionreportform',
	   selector : 'feeheadwisecollectionreportform'
   },{
	   ref : 'feeheadwisecollectionreportgrid',
	   selector : 'feeheadwisecollectionreportgrid'
   },
   {
	   ref:'applicantfeeheadwisecollectionreportform',
	   selector:'applicantfeeheadwisecollectionreportform'
   },
   {
	   ref:'applicantfeeheadbasedcollectionreportgrid',
	   selector:'applicantfeeheadbasedcollectionreportgrid'
   },{
	   ref:'applicantfeeheadwisecollectionreportgrid',
	   selector:'applicantfeeheadwisecollectionreportgrid'
   },{
	   ref : 'organizationunit',
	   selector : 'organizationunit'
   },{
	   ref:'adddiscountstructure',
	   selector:'adddiscountstructure'
   }
	],
    init: function() {
        this.control({
            'managediscountfilter button[itemId=searchBtn]': {
                click: this.getSearchDiscountList
            },
           'managediscountfilter multiselectcombofield#manageDiscountAcademyLocId':{
        	   change:this.manageOtherFilerByAcademyLocation
           },
            'managediscountfilter button[itemId=resetBtn]': {
                click: function(obj) {
                	var $this = this;
                    var form = obj.up('form').getForm();
                     var student = form.findField('student');
                    var applicant = form.findField('applicant');
                    student.reset();
                    applicant.reset();
                    form.reset();
                    
                    var userTypeField = form.findField('userType');
                    var userTypeStore = userTypeField.getStore();
                    
                    var applicableFromDate = obj.up('form').down('#applicableFromDateId');
					var applicableToDate = obj.up('form').down('#applicableToDateId');
					
					applicableFromDate.setMaxValue(false);
					applicableFromDate.setMinValue(false);
					applicableToDate.setMaxValue(false);
					applicableToDate.setMinValue(false);
					
					var approvedFromDate = obj.up('form').down('#approvedFromDateId');
					var approvedToDate = obj.up('form').down('#approvedToDateId');
					
					approvedFromDate.setMaxValue(false);
					approvedFromDate.setMinValue(false);
					approvedToDate.setMaxValue(false);
					approvedToDate.setMinValue(false);
					
					var discountValFromDate = obj.up('form').down('#discountValFromDateId');
					var discountValToDate = obj.up('form').down('#discountValToDateId');
					
					discountValFromDate.setMaxValue(false);
					discountValFromDate.setMinValue(false);
					discountValToDate.setMaxValue(false);
					discountValToDate.setMinValue(false);
					
					
					var discountAppFromDate = obj.up('form').down('#discountAppFromDateId');
					var discountAppToDate = obj.up('form').down('#discountAppToDateId');
					
					discountAppFromDate.setMaxValue(false);
					discountAppFromDate.setMinValue(false);
					discountAppToDate.setMaxValue(false);
					discountAppToDate.setMinValue(false);
					var discountStructure = this.getManagediscountstructure();
					
                    userTypeStore.load({
                    	 callback: function(rec) {
                             for (var i in rec) {
                                 userTypeField.setValue(rec[0].data.value);
                             }
                             manageDiscountPanel = discountStructure.down("managediscountpanel"); 
                             manageDiscountStudentList = manageDiscountPanel.down("managediscountstudentlist");
                             manageDiscountStudentListStore = manageDiscountStudentList.getStore();

                             manageDiscountApplicantList = manageDiscountPanel.down("managediscountapplicantlist");
                             manageDiscountApplicantListStore = manageDiscountApplicantList.getStore();
                             manageDiscountStudentList.setVisible(true);
                             manageDiscountApplicantList.setVisible(false);
                             manageDiscountStudentList.getStore().removeAll();
                             student.setVisible(true);
                             applicant.setVisible(false);

                             manageDiscountStudentList.getView().refresh();
                             manageDiscountApplicantList.getView().refresh();
                         },
                         params : {
                             screenType:'discount'
                         }
                    });
                    var manageDiscountAcademyLoc = form.findField('manageDiscountAcademyLoc');
           		 manageDiscountAcademyLoc.getStore().load({
           			 callback: function(records, operation, success) {
   						 if (success) {
   							 manageDiscountAcademyLoc.select(manageDiscountAcademyLoc.getStore().collect(manageDiscountAcademyLoc.valueField));
   							 $this.manageOtherFilerByAcademyLocation();
   						 }
   					 }  
           		 });
                    
                }
            },
            'managediscountstudentlist button[itemId=btnAdd]': {
                click: function(obj) {
                    var $this = this;
                    var grid = $this.getManagediscountstudentlist();
                    var record = grid.getSelectionModel().getSelection()[0];
                    
                    var isEditOPenVal = this.getManagediscountfilter().config.isEditOpen;
                    var openTab;
                    if(isEditOPenVal==true) {
                    	openTab = getFeeAndPaymentCommonTranslation('EDIT_DISCOUNT_ENTRY');
                    }else{
                    	openTab = getFeeAndPaymentCommonTranslation('VIEW_DISCOUNT_ENTRY');
                    }
                    
                    var contentpanel = this.getContentpanel();
                    var tabName = getFeeAndPaymentCommonTranslation('ADD_DISCOUNT_ENTRY');
                    var getcontroller = this.getController('menu.CoreERPNavigationController');
                    var getTab = getcontroller.getTab(openTab);
                    if (getTab != null) {
                        contentpanel.remove(getTab, true);
                    }
                    var contentXtype = 'adddiscountentrystructure'; //'billformstructure';
                    var newTab = this.getTabReferenceByTabTitle(tabName);
                    if (!newTab) {
                        newTab = contentpanel.add({
                            xtype: contentXtype,
                            closable: true,
                            title: tabName,
                            menuColorCls: CONSTANTS.MENU_COLOR_FIVE
                        });
                    }
                    contentpanel.setActiveTab(newTab);
                    var discountForm = newTab.down('addmanagediscount');
                    Ext.apply(discountForm, {
                        editMode: null,
                        setEditMode: function(editMode) {
                            discountForm.editMode = editMode;
                        },
                        getEditMode: function() {
                            return discountForm.editMode;
                        }
                    });
                    var currentLoggedUser=this.getCurrentlyLoggedInUser();
                    var validTill = discountForm.down("#validTillItemId"); 
                    this.setAllowBlank(validTill,false);
                    discountForm.getForm().clearInvalid();
                    var appliedByUser = discountForm.down("#user_name");
                    appliedByUser.getStore().load({
                        callback: function(rec) {
                            for (var i in rec) {
                                if (rec[i].data.id == currentLoggedUser.id) {
                                    appliedByUser.setValue(rec[i].data.id);
                                    break;
                                }
                            }
                        }
                    });
                    discountForm.down('#applicant').allowBlank = true;
                    discountForm.setEditMode(false);
                    this.getManagediscountfilter().config.isAddOpen = true;
                }
            },
            'addmanagediscount customcombobox[itemId=student]': {
            	select: function(obj, record) {
            		var form = this.getAddmanagediscount();
            		var discountTypeField=form.down("#discountTypeItemId");
            		discountTypeField.setDisabled(false);
            		discountTypeField.reset();
            		var store = discountTypeField.getStore();
                    store.getProxy().api.read = SERVERURL.PATH_FIND_BY_STUDENT;
                    store.getProxy().extraParams={
            			studentId: record[0].data.id
            		};
                    store.load();
            		this.setAddressForDiscountStudent(obj, record);
            		this.loadStudentSiblingGrid(record[0].get("id"));
            		this.loadStudentParentGrid(record[0].get("personId"));
            	}
            },
            'addmanagediscount customcombobox[itemId=applicant]': {
            	select: function(obj, record) {
            		var form = this.getAddmanagediscount();
            		var discountTypeField=form.down("#discountTypeItemId");
            		discountTypeField.setDisabled(false);
            		discountTypeField.reset();

            		var store = discountTypeField.getStore();
                    store.getProxy().api.read = SERVERURL.PATH_FIND_BY_APPLICANT;
                    store.getProxy().extraParams={
            			applicantId: record[0].data.id
            		};
                    store.load();
            		var store = discountTypeField.getStore();
                    store.getProxy().api.read = SERVERURL.PATH_FIND_BY_APPLICANT;
                    store.getProxy().extraParams={
            			applicantId: record[0].data.id
            		};
                    store.load();
            		this.setAddressForDiscountApplicant(obj, record);
            		this.loadApplicantSiblingGrid(record[0].get("id"));
            		this.loadApplicantParentGrid(record[0].get("personId"));
            	}
            },

            'addmanagediscount customcombobox[itemId=discountTypeItemId]': {
            	select: function(obj, record) {
            		var form = this.getAddmanagediscount();
            		var discountPercentage = form.down('#discountPercentageItemId');
            		form.down('#discountAmount').setVisible(false);
            		form.down('#discountAmount').setDisabled(false);
            		form.down('#discountAmount').allowBlank = true;
            		form.down('#discountAmount').reset();
            		           		

            		for (var i in record) {
            			if (record[i].data.value == 'WhetherFixedAmount') {
            				form.down('#discountAmount').setVisible(true);
            				form.down('#discountAmount').allowBlank = false;
            				discountPercentage.setVisible(false);
            				discountPercentage.setDisabled(true);
            				discountPercentage.allowBlank = true;
            				discountPercentage.reset();
            			}else if (record[i].data.value == 'WhetherAdhoc') {
            				form.down('#discountAmount').setVisible(true);
            				form.down('#discountAmount').allowBlank = false;
            				discountPercentage.setVisible(false);
            				discountPercentage.setDisabled(true);
            				discountPercentage.allowBlank = true;
            				discountPercentage.reset();
            			}else
            			{
            				discountPercentage.getStore().getProxy().extraParams = {
            					discountId: record[0].data.id
            				};
            				discountPercentage.getStore().load({
            					callback: function(records) {
            						discountPercentage.setVisible(true);
            						discountPercentage.setDisabled(false);
            						discountPercentage.allowBlank = false;
            						discountPercentage.reset();

            					}
            				});
            			}
            		}
            		form.isValid();
            	}
            },
            'discountapprovereject button[itemId=submitButtonId]': {
            	click: function(obj) {
            		this.saveDiscountApproveReject();
            	}
            },
            'discountapprovereject button[itemId=cancelButtonId]': {
            	click: function(obj) {
            		this.getDiscountapprovereject().close();  
            	}
            },
            'discountapprovereject': {
            	render: function(obj) {
            		var $this = this;
            		var formWindow = $this.getDiscountapprovereject();
            		var combo = formWindow.down('#appStatus');
            		combo.getStore().getProxy().extraParams = {
            			param: 'approve'
            		};
            		combo.getStore().load();
            	}
            },
            'addmanagediscount button[itemId=SubmitBtn]': {
                click: function(obj) {
                    var $this = this;
                    var record;
                    var addmanagediscount = $this.getAddmanagediscount();
                    var formValue = addmanagediscount.getForm().getValues();
                    var discountForm = $this.getManagediscountfilter()
                    var validTillToDate = obj.up('addmanagediscount').down('#validTillItemId').getValue();
                	userType = discountForm.down('#userType').getValue();
                	if(userType == getFeeAndPaymentCommonTranslation('STUDENT')){
                		var grid = $this.getManagediscountstudentlist();	
                	}else
                	{
                		var grid = $this.getManagediscountapplicantlist();
                	}
                    var json, submitUrl = SERVERURL.SAVE_STUDENT_DISCOUNT_MASTER;
                    
                    var parentGuardianGrid =this.getAdddiscountentrystructure().down('#adddiscountstudentparentgrid');
                    if(parentGuardianGrid.getSelectionModel().getCount()> 0){
                    	 record = parentGuardianGrid.getSelectionModel().getSelection()[0];
                    }
                    var baseTab = $this.getAddmanagediscount();
                    json = $this.getCreateJson(baseTab.getEditMode(), formValue, baseTab, addmanagediscount,record);
                    
                    if (baseTab.getEditMode()) {
                    	submitUrl = SERVERURL.UPDATE_STUDENT_DISCOUNT_MASTER;
                    	var structure=this.getAdddiscountentrystructure();
                    	var parentGuardianGrid=structure.down('#adddiscountstudentparentgridItem');
                    	if(parentGuardianGrid.getSelectionModel().getCount()> 0){
                    		record = parentGuardianGrid.getSelectionModel().getSelection()[0];
                    		if(!isNullOrEmpty(record.data.selectedRec) && record.data.selectedRec == false){
                    			record.data.personId = null;
                    		}
                    	}
                    	json = $this.getCreateJson(baseTab.getEditMode(), formValue, baseTab, addmanagediscount,record);
                    }
                    Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                    Ext.Ajax.request({
                        type: 'rest',
                        url: submitUrl,
                        jsonData: json,
                        method: 'POST',
                       /* params :{
                        	validTillToDate:validTillToDate
                        	
                        },*/
                   
                        success: function(form, action) {
                            Ext.getBody().unmask();
                            if(form.responseText == '0'){
                         		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('VALID_TILL_DATE_LESSER')); //spoonsor code exist
                         	}else{
                            showSuccessMessage(getFeeAndPaymentCommonTranslation('DISCOUNT_MASTER_ADD'),
                                getCommonTranslation('SUCCESS'));
                            $this.getAdddiscountentrystructure().close();
                            grid.getSelectionModel().deselectAll();
                            
                            grid.getStore().getProxy().extraParams = {
                            	isApplicant: false
                       	    };
                            grid.getStore().reload();
                         	}
                        },
                        failure: function(form, action) {
                        	var altMessage = Ext.decode(form.responseText);
                        	showWarningMessage(getCommonTranslation('ALERT'), altMessage[0].key);
                        }
                    });
                }
            },

            'addmanagediscount button[itemId=CancelBtn]': {
                click: function(obj) {
                    var $this = this;
                    var addmanagediscount = $this.getAddmanagediscount().getForm();
                    addmanagediscount.reset();
                    addmanagediscount.findField('discountAmount').setDisabled(true);
                    addmanagediscount.findField('discountPercentage').setDisabled(true);
                    addmanagediscount.findField('discountType').setDisabled(true);
                    
                    var formObj = this.getAddmanagediscount();
					   formObj.fireEvent("render",formObj);
					   var recieptDateObj = formObj.getForm().findField('applicableFrom');
					   recieptDateObj.fireEvent("render",recieptDateObj);
					   var addresDetailPanel = this.getDiscountaddressdetailpanel();	
						  var addressForm=addresDetailPanel.getForm();
						  var nameField = addressForm.findField('name');
						  nameField.reset();
						  var fatherNameField = addressForm.findField('fatherName');
						  fatherNameField.reset();
						  var addressField = addressForm.findField('address');
						  addressField.reset();
						  var emailIdField = addressForm.findField('emailId');
						  emailIdField.reset();
						  var contactNoField = addressForm.findField('contactNo');
						  contactNoField.reset();
						  var addmissionIdField = addressForm.findField('addmissionId');
						  addmissionIdField.reset();
						  var applicationIdField = addressForm.findField('applicationId');
						  applicationIdField.reset();
						  var actualUserId = addressForm.findField('actualUserId');
						  actualUserId.reset();
						  var applicantIdField = addressForm.findField('applicantId');
						  applicantIdField.reset();
						  var programField = addressForm.findField('program');
						  programField.reset();
						  var batchField = addressForm.findField('batch');
						  batchField.reset();
						  var periodField = addressForm.findField('period');
						  periodField.reset();
						  var sectionField = addressForm.findField('section');
						  sectionField.reset();
						  var seatTypeField = addressForm.findField('seatType');
						  seatTypeField.reset();
						  var totalAcadInvoiceAmountField = addressForm.findField('totalAcadInvoiceAmount');
						  totalAcadInvoiceAmountField.reset();
						  var totalAcadReceiptAmountField = addressForm.findField('totalAcadReceiptAmount');
						  totalAcadReceiptAmountField.reset();
						  var totalAcadPaymentAmountField = addressForm.findField('totalAcadPaymentAmount');
						  totalAcadPaymentAmountField.reset();
						  var totalConvertedOutstandingField = addressForm.findField('totalConvertedOutstanding');
						  totalConvertedOutstandingField.reset();
						  var totalAcadDicountAmountField = addressForm.findField('totalAcadDicountAmount');
						  totalAcadDicountAmountField.reset();
						  var totalAcadLocAdvanceAmountField = addressForm.findField('totalAcadLocAdvanceAmount');
						  totalAcadLocAdvanceAmountField.reset();
						  addresDetailPanel.collapse();
						  
                    
                    /*var applicableFromDate = obj.up('addmanagediscount').down('#applicableFromItemId');
					var validTillToDate = obj.up('addmanagediscount').down('#validTillItemId');
					
					applicableFromDate.setMaxValue(false);
					applicableFromDate.setMinValue(false);
					validTillToDate.setMaxValue(false);
					validTillToDate.setMinValue(false);*/
                    
                }
            },

            'managediscountstudentlist button[itemId=btnEdit]': {
                click: function(obj) {
                    this.showAddDiscountEntry(true);
                }
            },

            'managediscountstudentlist button[itemId=btnView]': {
                click: function(obj) {
                    this.showAddDiscountEntry(false);
                }
            },

            'managediscountstudentlist splitbutton[itemId=spBtnMoreActions] #btnApproveReject': {
                click: function(obj) {
                	this.approveRejectWindowOpen();
                }
            },

            'managediscountstudentlist button[itemId=btnDelete]': {
                click: function(obj) {
                    var grid = this.getManagediscountstudentlist();
                    if (grid.getSelectionModel().getCount() > 0) {
                        if (grid.getSelectionModel().getCount() == 1) {
                            var id = grid.getSelectionModel().getSelection()[0].data.id;
                            showConfirmMessage(getCommonTranslation('ALERTS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
                                function(btn, text) {
                                    if (btn == 'yes') {
                                        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                                        Ext.Ajax.request({
                                            method: "DELETE",
                                            type: 'rest',
                                            url: SERVERURL.DELETE_STUDENT_DISCOUNT_MASTER + '?id=' + id,
                                            headers: {
                                                'Content-Type': 'application/json'
                                            },
                                            params: {
                                                id: id
                                            },
                                            success: function(form, action) {
                                                Ext.getBody().unmask();
                                                showSuccessMessage(getFeeAndPaymentCommonTranslation('MANAGE_DISCOUNT_LIST'),
                                                    getCommonTranslation('SUCCESS'));
                                                grid.getStore().reload();
                                            }
                                        });
                                    }
                                });
                        } else {
                            showWarningMessage(getCommonTranslation('ALERTS'), getCommonTranslation('PLEASE_SELECT_ONLY_ONE_RECORD'));
                        }
                    } else {
                        showWarningMessage(getCommonTranslation('ALERTS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
                    }
                }
            },

            /* Discount Loader init control START */
            'discountuploaddownloadstructure radiogroup[itemId=importDownloadUploadGroupItemId]': {
            	change: function(cb, nv, ov) {
            		this.discountDownloadUploadFormChange(cb, nv, ov);
            		this.resetDiscountDownloadForm();
            	}
            },
            'discountdownloadform button[itemId=downloadDiscountDownloadFormItemId]': {
                click: function(obj) {
                    var $this = this;
                    var form = obj.up('discountdownloadform').getForm();
                    form.reset();
                }
            },
            'discountdownloadform button[itemId=downloadDiscountDownloadFormItemId]': {
                click: function(obj) {
                    var $this = this;
                    var form = $this.getDiscountdownloadform();

                    var discountTypeItemId = form.down('#discountTypeItemId');
                    var manageDiscountAcademyLocId = form.down('#manageDiscountAcademyLocId');
					var academyLocationValues = manageDiscountAcademyLocId.getValue();
					var alIds = [];
			        if (!isNullOrEmpty(academyLocationValues)) {
				
						for(var i in academyLocationValues){
							 if(Ext.isObject(academyLocationValues[i])){
								 alIds.push(academyLocationValues[i].data.id);
							 }else{
								 alIds.push(academyLocationValues[i]);
							 }
						}
			        }
                    var intakeYearItemId = form.down('#intakeYearItemId');

                    var pbpsContiner = form.down('#programBatchSeatContainerItemId');
                    //var newcont=pbpsContiner.items.items.length;


                    var pbpsFieldsCount = pbpsContiner.items.length;
                    var programIdArray = new Array();
                    var batchIdArray = new Array();
                    var seatTypeArray = new Array();
                    for (var j = 0; j < pbpsContiner.items.length; j++) {
                        var pbpsPanelContainer = pbpsContiner.items.items[j];

                        if (!isNullOrEmpty(pbpsPanelContainer.items.items[0].getValue())) {
                            programIdArray.push(pbpsPanelContainer.items.items[0].getValue())
                        }
                        if (!isNullOrEmpty(pbpsPanelContainer.items.items[1].getValue())) {
                            batchIdArray.push(pbpsPanelContainer.items.items[1].getValue())
                        }
                        if (!isNullOrEmpty(pbpsPanelContainer.items.items[2].getValue())) {
                            seatTypeArray.push(pbpsPanelContainer.items.items[2].getValue())
                        }
                    }

                    var programIdStr = null;
                    if (programIdArray.length > 0) {
                        programIdStr = programIdArray.join();
                    }

                    var batchIdStr = null;
                    if (batchIdArray.length > 0) {
                        batchIdStr = batchIdArray.join();
                    }

                    var seatTypeIdStr = null;
                    if (seatTypeArray.length > 0) {
                        seatTypeIdStr = seatTypeArray.join();
                    }

                    var csvForm = Ext.create('Ext.form.Panel');

                    csvForm.getForm().submit({
                        target: '_blank',
                        method: 'POST',
                        params: {
                            access_token: Ext.Ajax.defaultHeaders.access_token,
                            discountTypeId: discountTypeItemId.getValue(),
                            academyLocationId: alIds.join(),
                            intakeYearId: intakeYearItemId.getValue(),
                            programIds: programIdStr,
                            batchIds: batchIdStr,
                            seatTypeIds: seatTypeIdStr
                        },
                        headers: {
                            'Authorization': Ext.Ajax.defaultHeaders.Authorization
                        },
                        url: SERVERURL.DOWNLOAD_TEMPLATE_BULK_DISCOUNTS,
                        standardSubmit: true
                    });
                }
            },
            'discountuploadform button[itemId=uploadDiscountUploadFormItemId]': {
                click: function(obj) {
                    var $this = this;
                    var importWin = obj.up('discountuploadform');
                    var grdStore;
                    var form = obj.up('discountuploadform');
                    submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
    	        	$this.getHashOfFile(form);
		        	setTimeout(function() {
	                    form.getForm().submit({
	                        method: 'POST',
	                        url: submitUrl,
	                        success: function(form, action) {
	                            showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
	                        },
	                        failure: function(form, action) {
   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
	                        }
	                    });
		        	},1000);

                    Ext.defer(function() {
                        var grid = $this.getImportlistdiscountgrid();
                        var form = $this.getUploadoptionradiogroup();
  					    var isUploadAll = form.items.items[0].getValue().isUploadAll;
  					    $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Discounts');
                    }, 2000, this);
                }
            },
	        'discountuploadform uploadoptionradiogroup[itemId=discountUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
	        	change: function( radioGroup, newValue, oldValue, eOpts){
	        		var grid =this.getImportlistdiscountgrid();
	        		var form =this.getUploadoptionradiogroup();
	        		var isUploadAll = newValue.isUploadAll;
	        		this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'Bulk Discounts');
	        	}   
	 		   },
            'discountuploadform button[itemId=resetDiscountUploadFormItemId]': {
                click: function(obj) {
                    var $this = this;
                    var form = obj.up('discountuploadform').getForm();
                    form.findField('file').reset();
                    var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
  				    uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
  					   isUploadAll: false
  				   });
                    form.isValid();
                },
                render: function(obj) {
                    var $this = this;
                    var form = obj.up('discountuploadform').getForm();
                    var combo = form.findField('importUtilityMasterId');
                    combo.getStore().load({
                        callback: function(records, operation, success) {
                            for (var i in records) {
                                if (records[i].data.value == 'Bulk Discounts') {
                                    combo.setValue(records[i].data.id);
                                    combo.setReadOnly(true);
                                }
                            }
                        }
                    });
                }
            },
            'importlistdiscountgrid': {
                render: function(obj) {
                    var $this = this;
                    var grid = $this.getImportlistdiscountgrid();
                    var form  = $this.getUploadoptionradiogroup();
					var isUploadAll = form.items.items[0].getValue().isUploadAll;
					$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Discounts');
                },
                cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    if (e.target.tagName == 'A') {
                        var fileType = null;
                        if (cellIndex == 1) {
                            fileType = 'successFile';
                        } else if (cellIndex == 6) {
                            fileType = 'errorFile';
                        } else if (cellIndex == 7) {
                            fileType = 'logFile';
                        }
                        var documentId = record.get("id");
                        if (!isNullOrEmpty(documentId)) {
                            this.getDiscountDownloadFile(documentId, fileType);
                        }
                    }
                }
            },
            'importlistdiscountgrid button[itemId=btnForce]': {
                click: function(obj) {
                    var grid = this.getImportlistdiscountgrid();
                    if (grid.getSelectionModel().getCount() > 0) {
                        if (grid.getSelectionModel().getCount() > 1) {
                            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
                        } else {
                            var this$ = this;
                            var id = grid.getSelectionModel().selectionStart.data.id;
                            console.log(id);
                            var urlAppend = "?jobName=" + id;
                            var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER + urlAppend;
                            Ext.Ajax.request({
                                url: submitURL,
                                method: 'GET',
                                success: function(response) {
                                    if (response.responseText === "JOB_STATUS_NOT_PENDING") {
                                        showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
                                    } else if (response.responseText === "SIMILAR_NATURE_JOB_ALREADY_RUNNING") {
                                        showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
                                    } else if (response.responseText === "SUCCESS") {
                                        showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
                                        grid.getStore().reload();
                                    }
                                }
                            });
                        }
                    } else {
                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
                    }
                }
            },
            /*'discountdownloadform combo#academyLocationItemId': {
                render: function(obj) {
                    var userId = this.getCurrentlyLoggedInUser().id;
                    var store = obj.getStore();
                    store.getProxy().extraParams = {
                        id: userId
                    };
                    store.load();
                },
                select: function(obj, record) {
                    this.loadProgramCombo();
                }
            },*/

			'discountdownloadform multiselectcombofield#manageDiscountAcademyLocId': {
				render: function(obj) {
					var $this = this;
                    var form=this.getDiscountdownloadform().getForm();
                    var academyLocationId = this.getCurrentAcademyLocation();
                    var manageDiscountAcademyLoc = form.findField('manageDiscountAcademyLoc');
                     manageDiscountAcademyLoc.getStore().load({
                         callback: function(records, operation, success) {
                             if (success) {
                                 manageDiscountAcademyLoc.setValue(manageDiscountAcademyLoc.getStore().collect(manageDiscountAcademyLoc.valueField));
                                 //$this.manageOtherFilerByAcademyLocation();
                             }
                         }  
                     });
                    
                    var program = form.findField('programId');
                    var arr = [];
                    arr.push(academyLocationId);
                    program.reset();
                                
                    
                 //   var userTypeField = form.findField('userType');
                 //   var userTypeStore = userTypeField.getStore();

                    /*userTypeStore.load({
                        callback: function(rec) {
                            for (var i in rec) {
                                    userTypeField.setValue(rec[0].data.value);
                            }
                        },
                        params : {
                            screenType:'discount'
                        }
                    });*/
                    
				},
                change: function(obj, record) {
                    this.loadProgramCombo();
                }
			},

            'discountdownloadform combo#intakeYearItemId': {
                select: function(obj, record) {
                    this.loadProgramCombo();
                }
            },
            'discountdownloadform button[itemId=addFilterBtn]': {
                click: function(obj) {
                    this.addDiscountMultipleProgramBatchSeatFilter(obj);
                }
            },
            'discountdownloadform button[itemId=resetBtnDiscountDownloadFormItemId]': {
            	click: function(obj) {
            		this.resetDiscountDownloadForm();
            	}
            },
            'managediscountfilter customcombobox#programId': {
            	select: function(obj, record) {
            		var form = this.getManagediscountfilter();
            		form.down("#batchId").setDisabled(false);
            		var programId = record[0].get("id");
            		if(programId > 0){
            			var store = this.getStore('enquiry.AcademicBatchStore');
            			store.getProxy().extraParams = {
            				id: programId
            			};
            			store.load();
            		}
            	},
            	change: function(value,newValue) {
            		if(isNullOrEmpty(newValue)){
            			var form = this.getManagediscountfilter(); 
            			form.down("#batchId").setDisabled(true);
            		}
            	}
            },
            'managediscountfilter customcombobox#batchId': {
            	select: function(obj, record) {
            		var form = this.getManagediscountfilter();
            		form.down("#seatType").setDisabled(false);
            		var batchId = record[0].get("id");
            		if(batchId > 0){
            			var store = this.getStore('common.SeatTypesByBatchId');
            			store.getProxy().extraParams = {
            				batchId: batchId
            			};
            			store.load();
            		}
            	},
            	change: function(value,newValue) {
            		if(isNullOrEmpty(newValue)){
            			var form = this.getManagediscountfilter(); 
            			form.down("#seatType").setDisabled(true);
            		}
            	}
            },
			'managediscountfilter customcombobox[itemId=userType]':{
				select:function(obj,record){
					this.getShowAndHideManageDiscountList(obj,record); 
				}
			},
            'managediscountfilter':{
            	afterrender:function(){
            		var $this = this;
            		var form=this.getManagediscountfilter().getForm();
            		var academyLocationId = this.getCurrentAcademyLocation();
            		 var manageDiscountAcademyLoc = form.findField('manageDiscountAcademyLoc');
            		 manageDiscountAcademyLoc.getStore().load({
            			 callback: function(records, operation, success) {
    						 if (success) {
    							 manageDiscountAcademyLoc.select(manageDiscountAcademyLoc.getStore().collect(manageDiscountAcademyLoc.valueField));
    							 $this.manageOtherFilerByAcademyLocation();
    						 }
    					 }  
            		 });
     				
            		var program = form.findField('programId');
            		var arr = [];
            		arr.push(academyLocationId);
            		program.reset();
            		/*program.getStore().getProxy().extraParams={
            			academyLocationIds:arr.join()
            		};
            		program.getStore().load();   */       		
            		
            		var userTypeField = form.findField('userType');
					var userTypeStore = userTypeField.getStore();

					userTypeStore.load({
						callback: function(rec) {
							for (var i in rec) {
									userTypeField.setValue(rec[0].data.value);
							}
						},
						params : {
							screenType:'discount'
						}
					});
					/*
					var academyLocationId = this.getCurrentAcademyLocation();
					var manageDiscountFilterStudentStore = form.findField('student')
					.getStore();
					manageDiscountFilterStudentStore.getProxy().extraParams = {
						academyLocationIds : academyLocationId
					};
					manageDiscountFilterStudentStore.load();
					

					var manageDiscountFilterApplicantStore = form.findField('applicant')
					.getStore();
					manageDiscountFilterApplicantStore.getProxy().extraParams = {
						academyLocationIds : academyLocationId
					};
					manageDiscountFilterApplicantStore.load();
            		*/
            		
            	}  
            },
            'addressdetailpanel[itemId=manageDiscount] displayfield[itemId=feeheadwisedistributionId]':{
				 render: function(component) {
					 var $this =this;
					 var infoPanel = $this.getDiscountaddressdetailpanel();
					 if(!isNullOrEmpty(infoPanel)) {
						 var  detail = getCommonTranslation('FEE_HEADWISE_DISTRIBUTION');
						 infoPanel.down('#feeheadwisedistributionId').setValue("<a href='#'>"+detail+"</a>");
						 component.getEl().on('click', function(e) {
							 if(e.target.tagName=='A'){

								 var billFlayOutForm = $this.getAddmanagediscount();
	 							   
	 							   var studentId = billFlayOutForm.down('#student').getValue();
	 							  var applicantId = billFlayOutForm.down('#applicant').getValue();

								 if(!isNullOrEmpty(studentId)){
									 var contentpanel = $this.getContentpanel();
									 Academia.app.getController('Academia.controller.feeandpayment.reports.FeeReportCommonController');
									 var accountstatmentstructure = Ext.widget('studentfeereportfinalstructure');
									 var tabName = 'Fee Reports';
									 /**
									  * This is to remove tab from content panel and open same tab again 
									  */
									 var getcontroller=$this.getController('menu.CoreERPNavigationController');
									 var getTab=getcontroller.getTab(tabName);
									 if(getTab!=null){
										 contentpanel.remove(getTab, true);
									 }
									 openTab(contentpanel, tabName, accountstatmentstructure, CONSTANTS.MENU_COLOR_FIVE);

									 var frm = accountstatmentstructure.down('form');
									 var studentfeereportfinalstructure = accountstatmentstructure;
									 var feeReportTabStructure = studentfeereportfinalstructure.down('#feeReportTabStructure');
									 /* var academyForm = $this.getStudentFeeAndPaymentOrganizationUnit().getForm();
           											   var values = academyForm.getValues();
           											   if(values.multiselectAcademyLocation[0] =="" || values.multiselectAcademyLocation.length==0){
           												   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_ATLEAST_ONE_ACADEMY_LOCATION'));
           												   return;
           											   }*/
									 var treeTab = studentfeereportfinalstructure.down('#studentReportTreePanelItemId');
									 // var feeReportTabStructure = $this.getFeeReportTabStructure();
									 var feeReportTabStructure = studentfeereportfinalstructure.down('#feeReportTabStructure');
									 // feeReportTabStructure.removeAll();
									 var tabDetail = 'feeheadwisecollectionreportstructure';
									 var structure = Ext.widget(tabDetail);

									 openTab(feeReportTabStructure, getFeeAndPaymentCommonTranslation('STUDENT_FEE_HEAD_WISE'),
											 structure);

									 treeTab.toggleCollapse();
									 var headWiseForm = $this.getFeeheadwisecollectionreportform();
									 var moreFilterOpt = headWiseForm.down('fieldset');
									 moreFilterOpt.expand(true);		                												   
									 var studentField = headWiseForm.down('#student');
									 var studentFieldStore =  studentField.getStore();
									 studentFieldStore.getProxy().extraParams = { 
										 pageSize: 0,
										 limit: 0,};
									
									 
									 setTimeout(function(){
										 studentFieldStore.load({
											 callback: function(records, operation, success) {
												 if (success) {
													 for(var i in records){
														 if(records[i].data.id==studentId){
															 studentField.setValue(records[i].data.id);
														 }
													 }

												 }
											 }
										 });
										 var feeheadwisecollectionreportgrid = $this.getFeeheadwisecollectionreportgrid();
										 var feeheadwisecollectionreportgridStore =  feeheadwisecollectionreportgrid.getStore();
										 
										  var organizationForm=$this.getOrganizationunit().getForm();
							                var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation').getValue();
							                var ALsId = [];
							                for(var i in multiselectAcademyLocation){

							                ALsId.push(multiselectAcademyLocation[i]);
							                }
							               
										 feeheadwisecollectionreportgridStore.getProxy().extraParams = { 
											 academyLocationIds: ALsId.join(),
											 studentId: studentId,
											 onlyStudent: false,
											 isSchool: false,
											 studentStatus: true,
											 screenName: "feeheadwisecollectionreportform"
										 };
										 feeheadwisecollectionreportgridStore.load();


									 },1500);
									


								 } 
								 else if(!isNullOrEmpty(applicantId)){

									 var contentpanel = $this.getContentpanel();
									 Academia.app.getController('Academia.controller.feeandpayment.reports.FeeReportCommonController');
									 var accountstatmentstructure = Ext.widget('studentfeereportfinalstructure');
									 var tabName = 'Fee Reports';
									 /**
									  * This is to remove tab from content panel and open same tab again 
									  */
									 var getcontroller=$this.getController('menu.CoreERPNavigationController');
									 var getTab=getcontroller.getTab(tabName);
									 if(getTab!=null){
										 contentpanel.remove(getTab, true);
									 }
									 openTab(contentpanel, tabName, accountstatmentstructure, CONSTANTS.MENU_COLOR_FIVE);

									 var frm = accountstatmentstructure.down('form');
									 var studentfeereportfinalstructure = accountstatmentstructure;
									 var feeReportTabStructure = studentfeereportfinalstructure.down('#feeReportTabStructure');
									
									 var treeTab = studentfeereportfinalstructure.down('#studentReportTreePanelItemId');
									 var feeReportTabStructure = studentfeereportfinalstructure.down('#feeReportTabStructure');
									 var tabDetail = 'applicantfeeheadwisecollectionreportstructure';
									 var structure = Ext.widget(tabDetail);

									 openTab(feeReportTabStructure, getFeeAndPaymentCommonTranslation('APPLIACNT_HEAD_WISE'),
											 structure);

									 treeTab.toggleCollapse();
									 var headWiseForm = $this.getApplicantfeeheadwisecollectionreportform();
									 var moreFilterOpt = headWiseForm.down('fieldset');
									 moreFilterOpt.expand(true);		                												   
									 var studentField = headWiseForm.down('#applicantId');
									 var studentFieldStore =  studentField.getStore();
									 studentFieldStore.getProxy().extraParams = { 
										 pageSize: 0,
										 limit:0,
										 applicantId :applicantId};
									 studentFieldStore.load({
										 callback: function(records, operation, success) {
											 if (success) {
												 for(var i in records){
													 if(records[i].data.id==applicantId){
														 studentField.setValue(records[i].data.id);
													 }
												 }

											 }
										 }
									 });
									 setTimeout(function(){
									 var feeheadwisecollectionreportgrid = $this.getApplicantfeeheadwisecollectionreportgrid();
									 var feeheadwisecollectionreportgridStore =  feeheadwisecollectionreportgrid.getStore();
									  var organizationForm=$this.getOrganizationunit().getForm();
						                var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation').getValue();
						                var ALsId = [];
						                for(var i in multiselectAcademyLocation){

						                ALsId.push(multiselectAcademyLocation[i]);
						                }
						               
									 feeheadwisecollectionreportgridStore.getProxy().extraParams = { 
										 academyLocationIds: ALsId.join(),
										 applicantId: applicantId,
										 onlyApplicant: false,

									 };
									 feeheadwisecollectionreportgridStore.load();

									 },1500);




								 }


							 }
						 });    
					 }
				 }
			 },


            'addressdetailpanel[itemId=manageDiscount] displayfield[itemId=hosteldetailId]':{
     		   render: function(component) {
     			   var $this =this;
     			   var infoPanel = $this.getDiscountaddressdetailpanel();
     			   if(!isNullOrEmpty(infoPanel)) {
     				   infoPanel.down('#hosteldetailId').setValue("<a href='#'>Hostel Detail</a>");
     				   component.getEl().on('click', function(e) {		                						

     					   if(e.target.tagName=='A'){
     						   var billFlayOutForm = $this.getDiscountaddressdetailpanel();
     						   var tabTitle =  $this.getAddmanagediscount().down('#student').getValue();

     						   var programBatchSeatTypeConfigId = null;
     						   var personId = billFlayOutForm.down('#person').getValue(); //billFlayOutForm.down('#person').getValue();
     						   var userId = $this.getAddmanagediscount().down('#student').getValue();
     						   var admissionId = null; //billFlayOutForm.down('#addmissionId').getValue();
     						   var applicationId = null; //billFlayOutForm.down('#applicationId').getValue();		                						   

     						   /* For student case */
     						   if(!isNullOrEmpty(userId)){
     							   Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
     							   var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
     							   personController.isProfilePicSaved = false;
     							   if(!isNullOrEmpty(personId)){
     								   personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, applicationId, admissionId, null);
 									   personController.addPersonTabPanel('STUDENT', 'studentHostelPersonDetails', 'HOSTEL_DETAILS', 'hostelpersondetailsgrid', 'paymenthostelpersondetailsgrid', true);
     								   var pendingGrid = $this.getHostelpersondetailsgrid();
     								   var pendingGridStore = pendingGrid.getStore();
     								   pendingGridStore.getProxy().extraParams = {		                									
     									   personId:personId
     								   };
     								   pendingGridStore.load();
     							   }		                										                								
     						   }			                				           
     					   }

     				   });    
     			   }
     		   }
     	   },
		   'addressdetailpanel[itemId=manageDiscount] displayfield[itemId=statementaccountId]':{
			   render: function(component) {
				   var $this =this;
				   var infoPanel = $this.getDiscountaddressdetailpanel();
				   if(!isNullOrEmpty(infoPanel)) {
					   infoPanel.down('#statementaccountId').setValue("<a href='#'>Statement of Account</a>");
					   component.getEl().on('click', function(e) {
						   if(e.target.tagName=='A'){
							   var path = SERVERURL.IS_ACCOUNT_CFG_EXISTS_OR_NOT+"?academyLocationId="+$this.getCurrentAcademyLocation();
							   Ext.Ajax.request({
								   url: path,
								   method: 'GET',
								   success: function(response) {
									   var responseData = Ext.decode(response.responseText);
									   if(responseData) {
										   var form = $this.getAddmanagediscount();
										   var studentId = form.down('#student').getValue();
										   if(!isNullOrEmpty(studentId)){
											   var contentpanel = $this.getContentpanel();
											   Academia.app.getController('Academia.controller.feeandpayment.AccountStatementReportController');
											   var accountstatmentstructure = Ext.widget('accountstatmentstructure');
											   var tabName = 'Statement of Account';
											   /**
											    * This is to remove tab from content panel and open same tab again 
											    */
											   var getcontroller=$this.getController('menu.CoreERPNavigationController');
											   var getTab=getcontroller.getTab(tabName);
											   if(getTab!=null){
												   contentpanel.remove(getTab, true);
											   }
											   openTab(contentpanel, tabName, accountstatmentstructure, CONSTANTS.MENU_COLOR_FIVE);
											   var frm = accountstatmentstructure.down('form');
											   var student = frm.down('#student');
											   var showAllStudents = frm.down('#showAllStudentsItemId');
											   var statusComboItemId = frm.down('#statusComboItemId');
		                					   showAllStudents.setValue(true);
											   var recieptView = frm.down('#recieptView');
											   student.getStore().load({
												   callback:function(rec) {
													   for (var i in rec) {
														   if(rec[i].data.id==studentId) {
																 student.setValue(studentId);
																 if(rec[i].data.studentStatus=="Active"){
																	 statusComboItemId.setValue(true);
																 }else if(rec[i].data.studentStatus=="Inactive"){
																	 statusComboItemId.setValue(false);
																 }else{ 
																	 statusComboItemId.setValue(null);
																	 statusComboItemId.setReadOnly(true);}
															 }
													   }
													   var status = statusComboItemId.getValue();
													   var gird = accountstatmentstructure.down('grid');
													   gird.getStore().getProxy().extraParams={
														   id:studentId,
														   billedUserType:'STUDENT',
														   status:status,
							                			   screenName:'StatementOfAccount',
							                			   whetherShowAllStudents:true
													   };
													   gird.getStore().load();
												   }
											   });
											  
										   } else {
											   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SELECT_STUENT'));
										   }
									   } else {
										   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ACCOUNTING_CFG_IS_NOT_DONE_MSG'));
									   }
								   }
							   });
						   }
					   });    
				   }
			   }
		   },
		   
		   /*added for transport detail*/
		   'addressdetailpanel[itemId=manageDiscount] displayfield[itemId=transportdetailId]':{
			   render: function(component) {
				   var $this =this;
				   var infoPanel = $this.getDiscountaddressdetailpanel();
				   if(!isNullOrEmpty(infoPanel)) {
					   infoPanel.down('#transportdetailId').setValue("<a href='#'>Transport Details</a>");
					   component.getEl().on('click', function(e) {		                						

						   if(e.target.tagName=='A'){
							   var billFlayOutForm = $this.getDiscountaddressdetailpanel();
							   var tabTitle =  $this.getAddmanagediscount().down('#student').getValue();

							   var programBatchSeatTypeConfigId = null;
     						   var personId = billFlayOutForm.down('#person').getValue(); //billFlayOutForm.down('#person').getValue();
							   var userId = $this.getAddmanagediscount().down('#student').getValue();
     						   var admissionId = null; //billFlayOutForm.down('#addmissionId').getValue();
     						   var applicationId = null; //billFlayOutForm.down('#applicationId').getValue();		                						   

							   /* For student case */
							   if(!isNullOrEmpty(userId)){
								   Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
								   var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
								   personController.isProfilePicSaved = false;
								   if(!isNullOrEmpty(personId)){
									   personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, applicationId, admissionId, null);
  									   personController.addPersonTabPanel('STUDENT', 'studentTransportPersonDetails', 'TRANSPORT_DETAILS', 'transportpersondetailsgrid', 'paymenttransportpersondetailsgrid', true);
  									   var pendingGrid = $this.getTransportpersondetailsgrid();
  									   var pendingGridStore = pendingGrid.getStore();
  									   pendingGridStore.getProxy().extraParams = {		                									
										   userId:userId
									   };
  									   pendingGridStore.load();

								   }		                										                								
							   }			                				           
						   }

					   });    
				   }
			   }
		   },
		   
  		  /*added for total bill amount flyout link manage receipt link*/
  		  'addressdetailpanel[itemId=manageDiscount] [itemId=totalAcadInvoiceAmount]':{
  			  render: function(component) {
  				  var $this =this;
  				  component.getEl().on('click', function(e) {
  					  if(e.target.tagName=='A'){
  						  var billFlayOutForm = $this.getDiscountaddressdetailpanel();
  						  var tabTitle =   billFlayOutForm.down('#studentCode').getValue();
  						  var personId = null;
  						  var programBatchSeatTypeConfigId = null;
  						  var userId = $this.getAddmanagediscount().down('#student').getValue();
  						  var admissionId = null; //billFlayOutForm.down('#addmissionId').getValue();
  						  var applicationId = null; //billFlayOutForm.down('#applicationId').getValue();	
  						  var applicantId = billFlayOutForm.down('#applicantId').getValue();

  						  /* For student case */
  						  if(!isNullOrEmpty(userId)){
  							  Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
  							  var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
  							  personController.isProfilePicSaved = false;
 							  personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, applicationId, admissionId, null);
 							  personController.addPersonTabPanel('STUDENT', 'studentPendingBillDetails', 'BILL', 'pendingbillsgrid', 'studentPendingBillsGrid', true);
 							  var pendingGrid = $this.getPendingbillsgrid();
							  var pendingGridStore = pendingGrid.getStore();
							   pendingGridStore.getProxy().extraParams = {	
  								  id:userId,
  								  billedUserType:'STUDENT',
  								  raiseBillCategory:'BILL_RECEIVABLE'
  							  };
  							  // pendingGridStore.load();
  							  pendingGridStore.load({ 
  								  callback: function(record, operation, success) {
  									  if (record.length > 0) {
  										  $this.toggleGridSummaryRow(pendingGrid,true);
  									  }else{
  										  $this.toggleGridSummaryRow(pendingGrid,false);
  									  }
  								  }
  							  });
  						  }		
  	     				//For Applicant.......
  						   if(!isNullOrEmpty(applicantId)){
							   var tabTitle = billFlayOutForm.down('#applicationId').getValue();
  							  
							  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
							  var personController=  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
							  personController.isProfilePicSaved = false;
							  personController.addContentPanelTab(tabTitle, 'applicantprofile', applicantId, personId, applicantId, admissionId, null);
							  personController.addPersonTabPanel('APPLICANT', 'applicantPendingBillDetails', 'Payment', 'preadmissionpaymentsgrid', 'applicantPendingBillDetails', true);
 							  var pendingGridNew = $this.getPreadmissionpaymentsgrid();
							  var pendingGridStoreNew = pendingGridNew.getStore();
							  pendingGridStoreNew.getProxy().extraParams = {
								  applicantId:applicantId
								 //  billedUserType:'APPLICANT',
								 //  raiseBillCategory:'BILL_RECEIVABLE'
							   };
						
							  pendingGridStoreNew.load({ 
					        		callback: function(record, operation, success) {
								 if (record.length > 0) {
									 $this.toggleGridSummaryRow(pendingGrid,true);
									 }else{
										 $this.toggleGridSummaryRow(pendingGrid,false);
									 }
								 }
							});
						   }
  						  
  					  }
  				  });    
  			  }		                			   
  		  },
  		/*added for total reciept flyout link to manage receipt link*/
 		  'addressdetailpanel[itemId=manageDiscount] [itemId=totalAcadReceiptAmount]':{
 			  render: function(component) {
 				  var $this =this;
 				  component.getEl().on('click', function(e) {
 					  if(e.target.tagName=='A'){
  						  var billFlayOutForm = $this.getDiscountaddressdetailpanel();
  						  var tabTitle =  billFlayOutForm.down('#studentCode').getValue();
  						  var personId = null;
  						  var programBatchSeatTypeConfigId = null;
  						  var userId = $this.getAddmanagediscount().down('#student').getValue();
  						  var admissionId = null; //billFlayOutForm.down('#addmissionId').getValue();
  						  var applicationId = null; //billFlayOutForm.down('#applicationId').getValue();		                						   
  						  var applicantId = billFlayOutForm.down('#applicantId').getValue();
 						  /* For student case */
 						  if(!isNullOrEmpty(userId)){
 							  Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
 							  var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
 							  personController.isProfilePicSaved = false;
 							  personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, applicationId, admissionId, null);
 							  personController.addPersonTabPanel('STUDENT', 'studentPaymentReceivedHistoryDetails', 'RECEIPTS', 'paymentreceivedhistorygrid', 'studentPaymentReceivedHistoryGrid', true);
 							  var paymentReceivedGrid = $this.getPaymentreceivedhistorygrid();
 							  // var pendingGridStore = $this.getStore('Academia.store.personinfo.common.paymentandrefund.PendingBillStore');
 							  var paymentReceivedGridStore = paymentReceivedGrid.getStore();
 							  paymentReceivedGridStore.getProxy().extraParams = {
 								  studentId:userId		                								   
 							  };
 							  paymentReceivedGridStore.load({ 
 								  callback: function(record, operation, success) {
 									  if (record.length > 0) {
 										  $this.toggleGridSummaryRow(paymentReceivedGrid,true);
 									  }else{
 										  $this.toggleGridSummaryRow(paymentReceivedGrid,false);
 									  }
 								  }
 							  });
 						  }
		     				//For Applicant.......
   						   if(!isNullOrEmpty(applicantId)){
 							   var tabTitle =  billFlayOutForm.down('#applicationId').getValue();
   							  
 							  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
 							  var personController=  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
 							  personController.isProfilePicSaved = false;
 							  personController.addContentPanelTab(tabTitle, 'applicantprofile', applicantId, personId, applicantId, admissionId, null);
 							 personController.addPersonTabPanel('APPLICANT', 'applicantPaymentReceivedHistoryDetails', 'RECEIPTS', 'receiptgridforapplicant', 'applicantPaymentReceivedHistoryGrid', true);
        						
 							  var pendingGridNew = $this.getReceiptgridforapplicant();
							  var pendingGridStoreNew = pendingGridNew.getStore();
							  pendingGridStoreNew.getProxy().extraParams = {
								  personId:applicantId,
								  billedUserType: 'APPLICANT',
								  adjustmentType: 'BILL_RECEIVABLE',
								  whetherDeleted: 'FALSE',
								  raiseBillType: 'P_AND_C_FEE'
						
							   };
							  pendingGridStoreNew.load({ 
								   callback: function(record, operation, success) {
									   if (record.length > 0) {
										   $this.toggleGridSummaryRow(paymentReceivedGrid,true);
									   }else{
										   $this.toggleGridSummaryRow(paymentReceivedGrid,false);
									   }
								   }
							   });
					  }	
 						  
 					  }
 				  });    
 			  }		                			   
 		  },

 		  /*added for total payment amount flyout link to manage receipt link*/
 		  'addressdetailpanel[itemId=manageDiscount] [itemId=totalAcadPaymentAmount]':{
 			  render: function(component) {
 				  var $this =this;
 				  component.getEl().on('click', function(e) {
 					  if(e.target.tagName=='A'){
 						 var billFlayOutForm = $this.getDiscountaddressdetailpanel();
 						  var tabTitle = billFlayOutForm.down('#studentCode').getValue();
 						  var personId = null;
 						  var programBatchSeatTypeConfigId = null;
 						  var userId = $this.getAddmanagediscount().down('#student').getValue();
 						  var admissionId = null; //billFlayOutForm.down('#addmissionId').getValue();
 						  var applicationId = null; //billFlayOutForm.down('#applicationId').getValue();		                						   
 						  var applicantId = billFlayOutForm.down('#applicantId').getValue();
 						  
 						  /* For student case */
 						  if(!isNullOrEmpty(userId)){
 							  Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
 							  var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
 							  personController.isProfilePicSaved = false;
 							  personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, applicationId, admissionId, null);
 							  personController.addPersonTabPanel('STUDENT', 'studentRefundHistoryDetails', 'REFUNDS', 'refundhistorygrid', 'studentRefundHistoryGrid', true);
 							  var refundhistorygrid = $this.getRefundhistorygrid();
 							  var refundhistorygridStore = refundhistorygrid.getStore();
 							  refundhistorygridStore.getProxy().extraParams = {
 								  studentId:userId		                								   
 							  };
 							  refundhistorygridStore.load({ 
 								  callback: function(record, operation, success) {
 									  if (record.length > 0) {
 										  $this.toggleGridSummaryRow(refundhistorygrid,true);
 									  }else{
 										  $this.toggleGridSummaryRow(refundhistorygrid,false);
 									  }
								   }		                										                								
 							  });
							   }	
 				   			//For Applicant.......
  						   if(!isNullOrEmpty(applicantId)){
							   var tabTitle =  billFlayOutForm.down('#applicationId').getValue();
  							  
							  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
							  var personController=  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
							  personController.isProfilePicSaved = false;
							  personController.addContentPanelTab(tabTitle, 'applicantprofile', applicantId, personId, applicantId, admissionId, null);
							  personController.addPersonTabPanel('APPLICANT', 'applicantRefundHistoryDetails', 'REFUNDS', 'preadmissionrefundsgrid', 'applicantRefundHistoryGrid', true);
							   var preadrefundsgrid = $this.getPreadmissionrefundsgrid();
							   var preadrefundsgridStore = preadrefundsgrid.getStore();
							   preadrefundsgridStore.getProxy().extraParams = {
								   studentId:userId		                								   
							   };
							   preadrefundsgridStore.load({ 
								   callback: function(record, operation, success) {
									   if (record.length > 0) {
										   $this.toggleGridSummaryRow(refundhistorygrid,true);
									   }else{
										   $this.toggleGridSummaryRow(refundhistorygrid,false);
									   }
								   }
							   });

					  }
						   }
 				  });    
 			  }		                			   
 		  },

 		  /*added for total outstanding amount flyout link manage receipt link*/
 		  'addressdetailpanel[itemId=manageDiscount] [itemId=totalConvertedOutstanding]':{
 			  render: function(component) {
 				  var $this =this;
 				  component.getEl().on('click', function(e) {
 					  if(e.target.tagName=='A'){
 						 var billFlayOutForm = $this.getDiscountaddressdetailpanel();
						  var tabTitle =  billFlayOutForm.down('#studentCode').getValue();
						  var personId = null;
						  var programBatchSeatTypeConfigId = null;
						  var userId = $this.getAddmanagediscount().down('#student').getValue();
						  var admissionId = null; //billFlayOutForm.down('#addmissionId').getValue();
						  var applicationId = null; //billFlayOutForm.down('#applicationId').getValue();		                						   
						  var applicantId = billFlayOutForm.down('#applicantId').getValue();
						  
 						  /* For student case */
 						  if(!isNullOrEmpty(userId)){
 							  Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
 							  var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
 							  personController.isProfilePicSaved = false;
 							  personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, applicationId, admissionId, null);
 							  personController.addPersonTabPanel('STUDENT', 'studentPendingBillDetails', 'BILL', 'pendingbillsgrid', 'studentPendingBillsGrid', true);
 							  var pendingGrid = $this.getPendingbillsgrid();
 							  var pendingGridStore = pendingGrid.getStore();
 							  pendingGridStore.getProxy().extraParams = {
 								  id:userId,
 								  billedUserType:'STUDENT',
 								  raiseBillCategory:'BILL_RECEIVABLE'
 							  };
 							  // pendingGridStore.load();
 							  pendingGridStore.load({ 
 								  callback: function(record, operation, success) {
 									  if (record.length > 0) {
 										  $this.toggleGridSummaryRow(pendingGrid,true);
 									  }else{
 										  $this.toggleGridSummaryRow(pendingGrid,false);
 									  }
 								  }
					   });    
				   }
 				//For Applicant.......
  						   if(!isNullOrEmpty(applicantId)){
							   var tabTitle =  billFlayOutForm.down('#applicationId').getValue();
  							  
							  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
							  var personController=  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
							  personController.isProfilePicSaved = false;
							  personController.addContentPanelTab(tabTitle, 'applicantprofile', applicantId, personId, applicantId, admissionId, null);
							  personController.addPersonTabPanel('APPLICANT', 'applicantPendingBillDetails', 'Payment', 'preadmissionpaymentsgrid', 'applicantPendingBillDetails', true);
 							  var pendingGridNew = $this.getPreadmissionpaymentsgrid();
							  var pendingGridStoreNew = pendingGridNew.getStore();
							  pendingGridStoreNew.getProxy().extraParams = {
								  applicantId:applicantId
								 //  billedUserType:'APPLICANT',
								 //  raiseBillCategory:'BILL_RECEIVABLE'
							   };
						
							  pendingGridStoreNew.load({ 
					        		callback: function(record, operation, success) {
								 if (record.length > 0) {
									 $this.toggleGridSummaryRow(pendingGrid,true);
									 }else{
										 $this.toggleGridSummaryRow(pendingGrid,false);
									 }
								 }
							});
					  }

			        }
 				  });    
 			  }		                			   
		   },
		   'managediscountstudentlist':{
			   cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
				   if (e.target.tagName == 'A') {
					   var grid = this.getManagediscountstudentlist();
					   var $this = this;
					   var formWindow = $this.getViewsettleddiscount();
					   if (formWindow) {
						   formWindow.destroy();
					   }
					   Ext.widget('viewsettleddiscount');
					   var formWindow = $this.getViewsettleddiscount();
					   var userType = $this.getManagediscountfilter().down('#userType').getValue();
					   if(userType==getFeeAndPaymentCommonTranslation('APPLICANT')){
						   var gridColumns = formWindow.down('grid').columns;
						   var newStore = Ext.getStore('feeandpayment.discount.ViewSettledDiscountApplicantStore');
						   
						   formWindow.down('grid').reconfigure(newStore,gridColumns);
						   formWindow.down('#dicountType').setValue(record.data.discountType);
						   formWindow.down('#studentCode').setFieldLabel(getFeeAndPaymentCommonTranslation('APPLICANT_CODE_NAME'));
						   formWindow.down('#studentCode').setValue(record.data.applicantCode+'/'+record.data.applicantName);
					   }else{
					   formWindow.down('#dicountType').setValue(record.data.discountType);
					   formWindow.down('#studentCode').setValue(record.data.studentCode+'/'+record.data.studentName);
					   }
					   formWindow.show();
					   var innerGrid = formWindow.down('grid');
					   innerGridStore = innerGrid.getStore();
					   innerGridStore.getProxy().extraParams = {
						   studentDiscountMasterId: record.data.id
			            };
					   $this.resetPageSetting(innerGridStore);
					   innerGridStore.load({
						   callback: function(record,grid, operation, success) {
							   if (record.length > 0) {
								   this$.toggleGridSummaryRow(innerGrid,true);
							   }else{
								   this$.toggleGridSummaryRow(innerGrid,false);
							   }
						   }
					   });
				   }
			   },
			   afterrender:function(grid){
	   				var me = this;
	   				me.doAccessControlValidationGrid(grid, me.getMANAGE_DISCOUNT_SCREEN_PERMISSION());
	   				setTimeout(function(){
	   					me.addDataGridConfigButton(grid, me.getMANAGE_DISCOUNT_SCREEN_PERMISSION());
	   				},1500);
			   }
		   },
		   'managediscountapplicantlist':{
			   cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
				   if (e.target.tagName == 'A') {
					   var grid = this.getManagediscountapplicantlist();
					   var $this = this;
					   var formWindow = $this.getViewsettleddiscount();
					   if (formWindow) {
						   formWindow.destroy();
					   }
					   Ext.widget('viewsettleddiscount');
					   var formWindow = $this.getViewsettleddiscount();
					   var userType = $this.getManagediscountfilter().down('#userType').getValue();
					   if(userType==getFeeAndPaymentCommonTranslation('APPLICANT')){
						   var gridColumns = formWindow.down('grid').columns;
						   var newStore = Ext.getStore('feeandpayment.discount.ViewSettledDiscountApplicantStore');
						   Ext.suspendLayouts();
						   formWindow.down('grid').reconfigure(newStore,gridColumns);
						   Ext.resumeLayouts(true);
						   formWindow.down('grid').down('pagingtoolbar').bindStore(newStore);
						   formWindow.down('#dicountType').setValue(record.data.discountType);
						   formWindow.down('#studentCode').setFieldLabel(getFeeAndPaymentCommonTranslation('APPLICANT_CODE_NAME'));
						   formWindow.down('#studentCode').setValue(record.data.applicantCode+'/'+record.data.applicantName);
					   }else{
					   formWindow.down('#dicountType').setValue(record.data.discountType);
					   formWindow.down('#studentCode').setValue(record.data.studentCode+'/'+record.data.studentName);
					   }
					   formWindow.show();
					   var innerGrid = formWindow.down('grid');
					   innerGridStore = innerGrid.getStore();
					   innerGridStore.getProxy().extraParams = {
						   studentDiscountMasterId: record.data.id
			            };
					   innerGridStore.load({
						   callback: function(record,grid, operation, success) {
							   if (record.length > 0) {
								   this$.toggleGridSummaryRow(innerGrid,true);
							   }else{
								   this$.toggleGridSummaryRow(innerGrid,false);
							   }
						   }
					   });
				   }
			   },
			   afterrender:function(grid){
   				var me = this;
   				me.doAccessControlValidationGrid(grid, me.getMANAGE_DISCOUNT_SCREEN_PERMISSION());
   				setTimeout(function(){
   					me.addDataGridConfigButton(grid, me.getMANAGE_DISCOUNT_SCREEN_PERMISSION());
   				},1500);

   			},

		   },
			'addmanagediscount customcombobox[itemId=userType]':{
				select:function(obj,record){
					this.getShowAndHideUserByUserTypeInDiscount(obj,record);
				}
			},
			
			'adddiscountstructure tabpanel[itemId=adddiscountsubtabsitemid] tab':{
				activate:function(obj){
					var tabField = obj.card;
					if( !isNullOrEmpty(tabField) ){
						if( tabField.itemId == "adddiscountstudentparenttab" ){
							this.loadParentTabGrid();
						}
						if( tabField.itemId == "adddiscountstudentsibilingtab" ){
							this.loadSiblingTabGrid();
						}
					}
				}
			},
			'addmanagediscount':{
				afterrender:function(){
					var $this = this;
					var form=$this.getAddmanagediscount().getForm();

					var userTypeField = form.findField('userType');
					var userTypeStore = userTypeField.getStore();
					
					var combo = form.findField('USER_NAME');
					var applicantForm = this.getAddmanagediscount();
			    	var applicantField = applicantForm.down("#applicant");
		    		applicantField.allowBlank=true;

              		var store = combo.getStore();
              		store.getProxy().extraParams={
              			academyLocationIds:this.getCurrentAcademyLocation(),
              			isDiscount:true
     				};
					userTypeStore.load({
						callback: function(rec) {
							for (var i in rec) {
									userTypeField.setValue(rec[0].data.value);
							}
						},
						params : {
							screenType:'discount'
						}
					});
					
					var academyLocationId = this.getCurrentAcademyLocation();
					var addManageDiscountStudentStore = this.getAddmanagediscount().getForm().findField('student')
					.getStore();
					var contentPanel=this.getContentpanel();
					var studentCode=contentPanel.getActiveTab().student;
					var academyLocations=contentPanel.getActiveTab().academyLocations;
					addManageDiscountStudentStore.getProxy().extraParams = {
						academyLocationIds : academyLocations,
						studentNameOrCode:studentCode
					};
					addManageDiscountStudentStore.load();
					
					var addManageDiscountApplicantStore = this.getAddmanagediscount().getForm().findField('applicant')
					.getStore();
					
					var addForm=this.getAddmanagediscount();
					addManageDiscountApplicantStore.getProxy().extraParams = {
						academyLocationIds : academyLocationId,
						
					};
					addManageDiscountApplicantStore.load();
					
				}
			},
            'managediscountapplicantlist button[itemId=btnAdd]': {
                click: function(obj) {
                    var $this = this;
                    var grid = $this.getManagediscountapplicantlist();
                    var record = grid.getSelectionModel().getSelection()[0];
                    var contentpanel = this.getContentpanel();
                    var tabName = getFeeAndPaymentCommonTranslation('ADD_DISCOUNT_ENTRY');
                    var getcontroller = this.getController('menu.CoreERPNavigationController');
                    var getTab = getcontroller.getTab(tabName);
                    if (getTab != null) {
                        contentpanel.remove(getTab, true);
                    }
                    var contentXtype = 'adddiscountentrystructure'; //'billformstructure';
                    var newTab = this.getTabReferenceByTabTitle(tabName);
                    if (!newTab) {
                        newTab = contentpanel.add({
                            xtype: contentXtype,
                            closable: true,
                            title: tabName,
                            menuColorCls: CONSTANTS.MENU_COLOR_FIVE
                        });
                    }
                    contentpanel.setActiveTab(newTab);
                    var discountForm = newTab.down('addmanagediscount');
                    Ext.apply(discountForm, {
                        editMode: null,
                        setEditMode: function(editMode) {
                            discountForm.editMode = editMode;
                        },
                        getEditMode: function() {
                            return discountForm.editMode;
                        }
                    });
                    var currentLoggedUser=this.getCurrentlyLoggedInUser();
                    var appliedByUser = discountForm.down("#user_name");
                    appliedByUser.getStore().load({
                        callback: function(rec) {
                            for (var i in rec) {
                                if (rec[i].data.id == currentLoggedUser.id) {
                                    appliedByUser.setValue(rec[i].data.id);
                                    break;
                                }
                            }
                        }
                    });
                    discountForm.setEditMode(false);
                }
            },
            'managediscountapplicantlist button[itemId=btnEdit]': {
                click: function(obj) {
                    this.showAddDiscountEntry(true);
                }
            },

            'managediscountapplicantlist button[itemId=btnView]': {
                click: function(obj) {
                    this.showAddDiscountEntry(false);
                }
            },

            'managediscountapplicantlist splitbutton[itemId=spBtnMoreActions] #btnApproveReject': {
                click: function(obj) {
                	this.approveRejectWindowOpen();
                }
            },

            'managediscountapplicantlist button[itemId=btnDelete]': {
                click: function(obj) {
                    var grid = this.getManagediscountapplicantlist();
                    if (grid.getSelectionModel().getCount() > 0) {
                        if (grid.getSelectionModel().getCount() == 1) {
                            var id = grid.getSelectionModel().getSelection()[0].data.id;
                            showConfirmMessage(getCommonTranslation('ALERTS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
                                function(btn, text) {
                                    if (btn == 'yes') {
                                        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                                        Ext.Ajax.request({
                                            method: "DELETE",
                                            type: 'rest',
                                            url: SERVERURL.DELETE_STUDENT_DISCOUNT_MASTER + '?id=' + id,
                                            headers: {
                                                'Content-Type': 'application/json'
                                            },
                                            params: {
                                                id: id
                                            },
                                            success: function(form, action) {
                                                Ext.getBody().unmask();
                                                showSuccessMessage(getFeeAndPaymentCommonTranslation('MANAGE_DISCOUNT_LIST'),
                                                    getCommonTranslation('SUCCESS'));
                                                grid.getStore().reload();
                                            }
                                        });
                                    }
                                });
                        } else {
                            showWarningMessage(getCommonTranslation('ALERTS'), getCommonTranslation('PLEASE_SELECT_ONLY_ONE_RECORD'));
                        }
                    } else {
                        showWarningMessage(getCommonTranslation('ALERTS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
                    }
                }
            },
            'managediscountstructure':{
            	render:function(managediscountstructure){
            		this.enableTabforDiscountPanel(managediscountstructure);
            	},
            	afterrender:function(structure){
            		var $this = this;
            		structure.body.on('scroll', function(e, target) {
            			var manageDiscountStudentList = $this.getManagediscountstudentlist();
            			var manageDiscountApplicantList = $this.getManagediscountapplicantlist();

            			var grid = null;
            			if(!manageDiscountStudentList.isHidden()){
            				grid = $this.getManagediscountstudentlist();
            			}
            			if(!manageDiscountApplicantList.isHidden()){
            				grid = $this.getManagediscountapplicantlist();
            			}
            			$this.getMultipleGridHeaderFreeze(grid,structure,true);
            		});
            	}
            },
            /* Discount Loader init control END */

            'adddiscountstudentsibilinggrid':{
            	afterrender:function(grid){
            		var me = this;
            		setTimeout(function(){
            			me.addDataGridConfigButton(grid,me.getADD_DISCOUNT_STUDENT_SIBLING_GRID_PERMISSION());
            		},1500);
            	}
            },
            'adddiscountstudentparentgrid':{
            	afterrender:function(grid){
            		var me = this;
            		var form = me.getManagediscountfilter();            		
            		if(form.viewMode==true){
            			setTimeout(function(){
            				me.addDataGridConfigButton(grid,me.getADD_DISCOUNT_STUDENT_PARENT_GRID_PERMISSION());
            			},1500);
            		}
            	},
            	cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
            		var grid = this.getAdddiscountstudentparentgrid();

            		var columnName = grid.columns[7].dataIndex;
                     var grid =  this.getAdddiscountentrystructure().down('#adddiscountstudentparentgridItem');
            			
                     if(e.target.tagName == 'BUTTON' && columnName == "deleteButton"){
                    	 record.set('selectedRec',false)
                    	 View.addRowCls(RowEl,'clearSelectedRow');
                    	 View.removeRowCls(RowEl,'setSelectedRow');
                    	 View.getSelectionModel().deselect(record);
                    	 View.getSelectionModel().clearSelections();
                     }else{
                    	 View.removeRowCls(RowEl,'clearSelectedRow');
                    	 View.addRowCls(RowEl,'setSelectedRow');
                    	 record.set('selectedRec',true)
                     }
            	}, 
            	
            	
            },
            'managediscountstudentlist button[itemId=discountApproveBtn]': {
                click: function(obj) {
                	this.approveRejectWindowOpen(obj);
                }
            },
            'managediscountstudentlist button[itemId=discountRejectBtn]': {
                click: function(obj) {
                	this.approveRejectWindowOpen(obj);
                }
            },
            'managediscountapplicantlist button[itemId=discountApproveBtn]': {
                click: function(obj) {
                	this.approveRejectWindowOpen(obj);
                }
            },
            'managediscountapplicantlist button[itemId=discountRejectBtn]': {
                click: function(obj) {
                	this.approveRejectWindowOpen(obj);
                }
            },
        });
    },
    /*****START:Applied Permssion Management for Bill Import****************/
    //@author Ranga
    enableTabforDiscountPanel:function(managediscountstructure){
 	   this.showTabforDiscountPanel(managediscountstructure);
    },
    showTabforDiscountPanel : function(managediscountstructure) {
 	   var panelItem = new Array();
 	   var $this = this;
 	   var newcont=managediscountstructure.items.items.length;
 	   var insertPosition=newcont+1;
 		   panelItem.push({
 			   xtype:'tabpanel',
 			   itemId:'allVisibleTP',
 			   plain: true,
 			   autoScroll:false,
 			   style:{'margin':'0px !important'},
 			   frame: false,
 			   border:false,
 			   defaults: {
 				   labelAlign: 'top'
 			   },
 			   items:[{
 					 xtype : 'managediscountpanel',  
 					 title: getCommonTranslation('SEARCH'),
 					 tabCls: 'right-tab'
 				}, {
 					xtype: 'discountuploaddownloadstructure',
 					title: getCommonTranslation('IMPORT_DISCOUNTS'),
 				}]
 		   });

 		  managediscountstructure.insert(insertPosition,panelItem);
    },
    /* Discount Loader functions START */
    resetDiscountDownloadForm: function() {
    	var form = this.getDiscountdownloadform();

		var form1 = form.getForm();

		var academyLocationId = this.getCurrentAcademyLocation();
                    var manageDiscountAcademyLoc = form1.findField('manageDiscountAcademyLoc');
                     manageDiscountAcademyLoc.getStore().load({
                         callback: function(records, operation, success) {
                             if (success) {
                                 manageDiscountAcademyLoc.setValue(manageDiscountAcademyLoc.getStore().collect(manageDiscountAcademyLoc.valueField));
                             }
                         }  
                     });

        var pbpsContiner = form.down('#programBatchSeatContainerItemId');
        var newcont = pbpsContiner.items.items.length;
        for (var i = newcont; i > 0; i--) {
            pbpsContiner.remove(pbpsContiner.items.items[i]);
        }
        form.doLayout();
        form.getForm().reset();
        var programItemId = form.down('#programItemId');
        var addFilterBtn = form.down('#addFilterBtn');
        programItemId.setDisabled(true);
        addFilterBtn.setDisabled(true);

        var batchItemId = form.down("#batchItemId");
        batchItemId.setDisabled(true);
        batchItemId.reset();

        var seatTypeItemId = form.down("#seatTypeItemId");
        seatTypeItemId.setDisabled(true);
        seatTypeItemId.reset();
    },
    loadProgramCombo: function() {
        $this = this;
        var filter = $this.getDiscountdownloadform();
        var academyLocationItemId = filter.down('#manageDiscountAcademyLocId');
        var intakeYearItemId = filter.down('#intakeYearItemId');
        var programItemId = filter.down('#programItemId');
        var addFilterBtn = filter.down('#addFilterBtn');

        programItemId.reset();
		var academyLocationValues = academyLocationItemId.getValue();
		var alIds = [];
        if (!isNullOrEmpty(academyLocationValues) && !isNullOrEmpty(intakeYearItemId.getValue())) {
	
			for(var i in academyLocationValues){
				 if(Ext.isObject(academyLocationValues[i])){
					 alIds.push(academyLocationValues[i].data.id);
				 }else{
					 alIds.push(academyLocationValues[i]);
				 }
			}
	
	
            var programStore = programItemId.getStore();
            programStore.getProxy().extraParams = {
                academyLocationIds: alIds.join(),
                intakeYearId: intakeYearItemId.getValue()
            };
            programStore.load();
            programItemId.setDisabled(false);
            addFilterBtn.setDisabled(false);
        }

        var pbpsContiner = filter.down('#programBatchSeatContainerItemId');
        var newcont = pbpsContiner.items.items.length;
        for (var i = newcont; i > 0; i--) {
            pbpsContiner.remove(pbpsContiner.items.items[i]);
        }
        filter.doLayout();

        var batchItemId = filter.down("#batchItemId");
        batchItemId.setDisabled(true);
        batchItemId.reset();

        var seatTypeItemId = filter.down("#seatTypeItemId");
        seatTypeItemId.setDisabled(true);
        seatTypeItemId.reset();
    },
    discountDownloadUploadFormChange: function(cb, nv, ov) {
        var $this = this;
        var structure = cb.up('discountuploaddownloadstructure');
        var downloadTemplateForm = structure.down('discountdownloadform');
        var uploadTemplateForm = structure.down('discountuploadform');
        var grid = $this.getImportlistdiscountgrid();
        if (nv.downloadUploadTemplate == 'forDownloadTemplate') {
            uploadTemplateForm.hide();
            downloadTemplateForm.show();
            grid.setVisible(false);
        } else {
        	$this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
        	var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
        	uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
        		isUploadAll: false
        	});
            downloadTemplateForm.hide();
            uploadTemplateForm.show();
            grid.setVisible(true);
            uploadTemplateForm.down("#uploadFileField").reset();
        }
    },
    getDiscountDownloadFile: function(documentId, fileType) {
        if (!isNullOrEmpty(documentId)) {
            var csvForm = Ext.create('Ext.form.Panel');
            csvForm.getForm().submit({
                target: '_blank',
                method: 'POST',
                params: {
                    access_token: Ext.Ajax.defaultHeaders.access_token
                },
                headers: {
                    'Authorization': Ext.Ajax.defaultHeaders.Authorization
                },
                url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL + '?id=' + documentId + '&fileType=' + fileType,
                standardSubmit: true
            });
        }
    },
    addDiscountMultipleProgramBatchSeatFilter: function(obj) {
        var $this = this;
        var form = $this.getDiscountdownloadform();
        var academyLocationItemId = form.down('#manageDiscountAcademyLocId');
		var academyLocationValues = academyLocationItemId.getValue();
		var alIds = [];
        if (!isNullOrEmpty(academyLocationValues)) {
	
			for(var i in academyLocationValues){
				 if(Ext.isObject(academyLocationValues[i])){
					 alIds.push(academyLocationValues[i].data.id);
				 }else{
					 alIds.push(academyLocationValues[i]);
				 }
			}
		}
        var intakeYearItemId = form.down('#intakeYearItemId');
        var stopContiner = $this.getDiscountdownloadform().down('#programBatchSeatContainerItemId');
        var panelItem = new Array();
        var fieldContainer = obj.up('fieldcontainer');
        var newcont = stopContiner.items.items.length;
        var insertPosition = newcont + 1;
        panelItem.push({
            xtype: 'fieldcontainer',
            layout: 'hbox',
            width: '100%',
            defaults: {
                labelAlign: 'top',
            },
            style: {
                marginTop: '20px'
            },
            items: [{
                xtype: 'customcombobox',
                name: 'programId',
                itemId: 'programItemId',
                displayField: 'code',
                valueField: 'id',
                queryParam: 'name',
                width: 256,
                typeAhead: true,
                forceSelection: true,
                hideTrigger: false,
                allowBlank: true,
                triggerAction: 'all',
                triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
                minChars: 3,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                listConfig: {
                    listeners: {
                        beforeshow: function(picker) {
                            picker.minWidth = picker.up('combobox').getSize().width;
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function() {
                        return '<div class="search-item">' +
                            '{value}' +
                            '</div>';
                    }
                },
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.common.AssignedProgramStore');
                        combo.bindStore(store);
                        store.getProxy().extraParams = {
                            academyLocationIds: alIds.join(),
                            intakeYearId: intakeYearItemId.getValue()
                        }
                    },
                    select: function(obj, record) {
                        var programId = record[0].get("id");
                        var batch = obj.nextSibling();
                        var seatType = batch.nextSibling();

                        batch.setDisabled(false);
                        batch.reset();

                        seatType.setDisabled(true);
                        seatType.reset();

                        var store = batch.getStore();
                        store.proxy.extraParams = {
                            programIds: programId
                        };
                        store.load();
                    }
                }
            }, {
                xtype: 'customcombobox',
                name: 'batchId',
                itemId: 'batchItemId' + insertPosition,
                valueField: 'id',
                displayField: 'batch',
                disabled: true,
                forceSelection: true,
                width: 256,
                editable: false,
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.feeandpayment.ALProgramBatchSearchCombo');
                        combo.bindStore(store);
                    },
                    select: function(obj, record) {
                        var batchId = record[0].get("id");
                        var seatType = obj.nextSibling();

                        seatType.setDisabled(false);
                        seatType.reset();

                        var store = seatType.getStore();
                        store.proxy.extraParams = {
                            batchIds: batchId
                        };
                        store.load();
                    }
                }
            }, {
                xtype: 'customcombobox',
                name: 'seatTypeId',
                itemId: 'seatTypeItemId' + insertPosition,
                //store: 'feeandpayment.ALProgramBatchSeatTypeList',
                valueField: 'programBatchSeatTypeId',
                displayField: 'seatName',
                disabled: true,
                width: 256,
                editable: false,
                forceSelection: true,
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.feeandpayment.ALProgramBatchSeatTypeList');
                        combo.bindStore(store);
                    },
                }
            }, {
                xtype: 'button',
                itemId: 'delFilterBtn',
                cls: 'CustomBodyBtnReject',
                glyph: ICONGLYPH.DELETEGLYPH,
                tooltip: getCommonTranslation('DELETE'),
                style: {
                    marginTop: '5px'
                },
                listeners: {
                    click: function(obj) {
                        var container = obj.up('fieldcontainer');
                        var panelContiner = $this.getDiscountdownloadform().down('#programBatchSeatContainerItemId');
                        panelContiner.remove(container);
                    }
                }
            }, {
                xtype: 'button',
                itemId: 'addFilterBtn',
                cls: 'CustomBodyBtnSettings',
                text: getCommonTranslation('ADDBUTTONTEXT'),
                tooltip: getCommonTranslation('ADD'),
                style: {
                    marginTop: '5px'
                }
            }]
        });
        stopContiner.insert(insertPosition, panelItem);
        stopContiner.doLayout();
    },
    /* Discount Loader functions END */

    getProgramBatchSeatConfigurationId: function(obj, type) {
        var $this = this;
        var contentpanel = this.getContentpanel();
        Ext.apply(contentpanel, {
            pbscByStudentId: null,
            setProgramBatchConfByStudentId: function(pbscByStudentId) {
                contentpanel.pbscByStudentId = pbscByStudentId;
            },
            getProgramBatchConfByStudentId: function(pbscByStudentId) {
                return contentpanel.pbscByStudentId;
            }
        });
        var id = obj.getValue();
        if (type == 'STUDENT') {
            var editUrl = SERVERURL.PROGRAM_BATCH_SEAT_TYPE_CONF_STUDENTID;
            Ext.Ajax.request({
                type: 'rest',
                url: editUrl,
                params: {
                    'studentId': id
                },
                method: 'GET',
                success: function(f, action) {
                    console.log(f);
                    var pbscByStudent = Ext.JSON.decode(f.responseText);
                    var pbscByStudentId = pbscByStudent[0].programBatchSeatConfigId;
                    contentpanel.setProgramBatchConfByStudentId(pbscByStudentId);
                }
            });
        }
    },

    setAddressForDiscountStudent: function(obj, record) {
        var form = this.getDiscountaddressdetailpanel();
        if (form.collapsed) {
            form.expand();
        }
        form.down("#profile_image").setVisible(true);
       
        
        var studentId;
        var personId;
        if (record) {
            studentId = record[0].get("id");
            personId = record[0].get("personId");
        } else {
            studentId = obj.studentId;
            personId = obj.personId;
        }

        if (!isNullOrEmpty(personId)) {
            Ext.Ajax.request({
                type: 'rest',
                binary: true,
                url: SERVERURL.PERSON_IMAGE_DOWNLOAD + '?personId=' + personId,
                method: 'GET',
                success: function(response) {
                    if (response.responseBytes.length > 0) {
                        var blob = new Blob([response.responseBytes], {
                            type: 'image/jpg'
                        });
                        var url = window.URL.createObjectURL(blob);
                        var image = form.down("#profile_image");
                        image.getEl().dom.src = url;
                    }
                }
            });
        }
        Ext.Ajax.request({
            method: "GET",
            type: 'rest',
            url: SERVERURL.PAYMENT_STUDENT_FO_FLYOUT_INFO,
            params: {
                studentId: studentId
            },
            success: function(f, action) {
                var responseData = Ext.JSON.decode(f.responseText);

                form.down("#departmentName").setVisible(false),
                    form.down("#whetherFaculty").setVisible(false),
                    form.down("#whetherInternal").setVisible(false),
                    form.down("#sponsorType").setVisible(false);
                form.down("#sponsorCode").setVisible(false);
                form.down("#noOfSponsoredStudents").setVisible(false);

                form.down("#addmissionId").setVisible(true);
                form.down("#applicationId").setVisible(true);
                form.down("#program").setVisible(true);
                form.down("#batch").setVisible(true);
                form.down("#period").setVisible(true);
                form.down("#section").setVisible(true);
                form.down("#seatType").setVisible(true);
                form.down("#userId").setVisible(true);
                form.down("#feeheadwisedistributionId").setVisible(true);

                form.down("#name").setValue(responseData.studentName);
                form.down("#fatherName").setValue(responseData.fatherName);
                form.down("#address").setValue(responseData.addressText);
                form.down("#emailId").setValue(responseData.primaryeEmailId);
                form.down("#contactNo").setValue(responseData.cellNo);
                form.down("#addmissionId").setValue(responseData.admissionID);
                form.down("#applicationId").setValue(responseData.applicationID);
                form.down("#userId").setValue(responseData.id);
                form.down("#program").setValue(responseData.programName);
                form.down("#batch").setValue(responseData.batch);
                form.down("#studentCode").setValue(responseData.studentCode);
                
                var alinfomodel = Academia.model.authentication.ALInfoModel;
                var wheatherSchool = alinfomodel.get('wheatherSchool');
                if(wheatherSchool){
                   form.down("#period").setVisible(false);
                }else{
                   form.down("#period").setVisible(true);
                   form.down("#period").setValue(responseData.period);   
                }
                
                form.down("#section").setValue(responseData.sectionCode);
                form.down("#seatType").setValue(responseData.seatType);
                form.down("#totalAcadDicountAmount").setValue(responseData.totalAcadDicountAmount);
                form.down("#person").setValue(responseData.personId);
    			form.down("#totalAcadInvoiceAmount").setValue(responseData.totalAcadInvoiceAmount);
      			form.down("#totalAcadReceiptAmount").setValue(responseData.totalAcadReceiptAmount);
      			form.down("#totalAcadPaymentAmount").setValue(responseData.totalAcadPaymentAmount);
      			form.down("#totalConvertedOutstanding").setValue(responseData.totalConvertedOutstanding);            			  
               // form.down("#totalAdvanceFee").setValue(responseData.totalAdvanceFee);
                form.down("#totalAcadLocAdvanceAmount").setValue(responseData.totalAcadLocAdvanceAmount);
            }
        });
    }, 
    
    //********* Set Address For Applicant *********
    setAddressForDiscountApplicant:function(obj,record){
    	 var form = this.getDiscountaddressdetailpanel();
  	  if (form.collapsed) {
  		  form.expand();
  	  }
  	  form.down("#profile_image").setVisible(true);
  	  var applicantId ;
  	  var personId;
  	  if(record){
  		  applicantId = record[0].get("id");
  		  personId = record[0].get("personId");
  	  }else{
 		 applicantId = obj.applicantId;
		 personId = obj.applicantPersonId
  	  }
  	  form.down("#applicantId").setValue(applicantId);
  	  
  	  if(!isNullOrEmpty(personId)){
  		  Ext.Ajax.request({
  			  type: 'rest',
  			  binary: true,
  			  url: SERVERURL.APPLICANT_IMAGE_DOWNLOAD+'?personId='+personId,
  			  method: 'GET',
  			  success : function(response){
  				  if(response.responseBytes.length>0){
  					  var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
  					  var url = window.URL.createObjectURL(blob);
  					  var image = form.down("#profile_image");
//					  image.setVisible(true);
  					  image.getEl().dom.src=url;
  				  }
  			  }
  		  });
  	  }

  	  Ext.Ajax.request({
  		  method: "GET",
  		  type: 'rest',
  		  url: SERVERURL.APPLICANT_FLYOUT,
  		  params: {
  			  id: applicantId
  		  },
  		  success: function(f, action) {
  			  var responseData = Ext.JSON.decode(f.responseText);

  			  form.down("#program").setVisible(true);
  			  form.down("#batch").setVisible(true);
  			  form.down("#seatType").setVisible(true);
  			  form.down("#applicationId").setVisible(true);

  			  form.down("#sponsorType").setVisible(false);
  			  form.down("#sponsorCode").setVisible(false);
  			  form.down("#noOfSponsoredStudents").setVisible(false);
  			  form.down("#addmissionId").setVisible(false);
  			  form.down("#period").setVisible(false);
  			  form.down("#section").setVisible(false);
  			  form.down("#userId").setVisible(false);
  			  form.down("#whetherFaculty").setVisible(false);
  			  form.down("#whetherInternal").setVisible(false);
  			  form.down("#departmentName").setVisible(false);
  			  form.down("#feeheadwisedistributionId").setVisible(true);

  			  form.down("#name").setValue(responseData.applicantName);
  			  form.down("#fatherName").setValue(responseData.fatherName);
  			  form.down("#address").setValue(responseData.addressText);
  			  form.down("#emailId").setValue(responseData.primaryEmailId);
  			  form.down("#contactNo").setValue(responseData.cellNo);
  			  form.down("#applicationId").setValue(responseData.code);
  			  form.down("#program").setValue(responseData.program);
  			  form.down("#batch").setValue(responseData.batch);
  			  form.down("#seatType").setValue(responseData.seatType);
  			  form.down("#totalAcadInvoiceAmount").setValue(responseData.totalAcadInvoiceAmount);
  			  form.down("#totalAcadReceiptAmount").setValue(responseData.totalAcadReceiptAmount);
  			  form.down("#totalAcadPaymentAmount").setValue(responseData.totalAcadPaymentAmount);
  			  form.down("#totalConvertedOutstanding").setValue(responseData.totalConvertedOutstanding);            			  
  			  form.down("#totalAcadDicountAmount").setValue(responseData.totalAcadDicountAmount);
		      form.down("#totalAcadLocAdvanceAmount").setValue(responseData.totalAcadLocAdvanceAmount);
  		  }
  	  });
    },
    getSearchDiscountList: function(obj) {
    	var $this = this;
    	var discountForm = $this.getManagediscountfilter()
    	userType = discountForm.down('#userType').getValue();
    	discountForm.down('#searchBtn').setDisabled(true);
    	if(userType == getFeeAndPaymentCommonTranslation('APPLICANT')){
    		var DiscountList = $this.getManagediscountapplicantlist();
        	if(!DiscountList.isHidden()){
        		this.getLoadDiscountList(DiscountList);
        		if(DiscountList.getSelectionModel()){
        			if(DiscountList.getSelectionModel().getSelection().length>0)
        				DiscountList.getSelectionModel().deselectAll();
        		}
        	}
    	}
    	if(userType == getFeeAndPaymentCommonTranslation('STUDENT')){
    		var DiscountList = $this.getManagediscountstudentlist();
        	if(!DiscountList.isHidden()){
        		this.getLoadDiscountList(DiscountList);
        		if(DiscountList.getSelectionModel()){
        			if(DiscountList.getSelectionModel().getSelection().length>0)
        				DiscountList.getSelectionModel().deselectAll();
        		}
        	}
    	}
    	
		$this.getManagediscountapplicantlist().config.searchFilterForm = discountForm;
    	$this.getManagediscountstudentlist().config.searchFilterForm = discountForm;
    },

    getCreateJson: function(isEdit, formValue, baseTab, addmanagediscount,parentGridRec) {
        var json;
        if(parentGridRec && parentGridRec.data.employeeId){
        	var personID = parentGridRec.data.personId
        }
        
        var person = {
                "id": personID
            };
        var disMaster = {
            "id": formValue.discountType
        };
        var student = {
            "id": formValue.student
        };
        var applicant = {
                "id": formValue.applicant
            };
        var appliedBy = {
            "id": formValue.USER_NAME
        };
        if (isEdit) {
        	if(!isNullOrEmpty(formValue.student))
        		{
        		 if (!isNullOrEmpty(formValue.discountPercentage)) {
                     json = {
                    	  "id": baseTab.getRecordId(),
                    	  "person": person,
                         "discountMaster": disMaster,
                         "student": student,
                         "appliedBy": appliedBy,
                         "studentDiscountStatus": baseTab.getStudentDiscountStatusEdit(),
                         "discountPercentage": addmanagediscount.down('#discountPercentageItemId').getRawValue(),
                         "discountAmount": formValue.discountAmount,
                         "applicableFrom": formValue.applicableFrom,
                         "validTill": formValue.validTill,
                         "appliedDate": formValue.appliedDate
                     };
                 } else {
                     json = {                    		
                         "id": baseTab.getRecordId(),
                         "person": person,
                         "discountMaster": disMaster,
                         "student": student,
                         "appliedBy": appliedBy,
                         "studentDiscountStatus": baseTab.getStudentDiscountStatusEdit(),
                         "discountAmount": formValue.discountAmount,
                         "applicableFrom": formValue.applicableFrom,
                         "validTill": formValue.validTill,
                         "appliedDate": formValue.appliedDate
                     };
                 }
        		
        		}else{
        			 if (!isNullOrEmpty(formValue.discountPercentage)) {
        	                json = {        	                	       	                         
        	                    "id": baseTab.getRecordId(),
        	                    "person": person,
        	                    "discountMaster": disMaster,
        	                    "applicant": applicant,
        	                    "appliedBy": appliedBy,
        	                    "studentDiscountStatus": baseTab.getStudentDiscountStatusEdit(),
        	                    "discountPercentage": addmanagediscount.down('#discountPercentageItemId').getRawValue(),
        	                    "discountAmount": formValue.discountAmount,
        	                    "applicableFrom": formValue.applicableFrom,
        	                    "validTill": formValue.validTill,
        	                    "appliedDate": formValue.appliedDate
        	                };
        	            } else {
        	                json = {        	                	
        	                    "id": baseTab.getRecordId(),
        	                    "person": person,
        	                    "discountMaster": disMaster,
        	                    "applicant": applicant,
        	                    "appliedBy": appliedBy,
        	                    "studentDiscountStatus": baseTab.getStudentDiscountStatusEdit(),
        	                    "discountAmount": formValue.discountAmount,
        	                    "applicableFrom": formValue.applicableFrom,
        	                    "validTill": formValue.validTill,
        	                    "appliedDate": formValue.appliedDate
        	                };
        	            }
        		}
           
        } else {
        	if(!isNullOrEmpty(formValue.student))
    		{
        		if (!isNullOrEmpty(formValue.discountPercentage)) {
                    json = {
                    	"person": person, 
                        "discountMaster": disMaster,
                        "student": student,
                        "appliedBy": appliedBy,
                        "studentDiscountStatus": "APPLIED",
                        "discountPercentage": addmanagediscount.down('#discountPercentageItemId').getRawValue(),
                        "applicableFrom": formValue.applicableFrom,
                        "validTill": formValue.validTill,
                        "appliedDate": formValue.appliedDate
                    };
                } else {
                    json = {
                    	"person": person,
                        "discountMaster": disMaster,
                        "student": student,
                        "appliedBy": appliedBy,
                        "studentDiscountStatus": "APPLIED",
                        "discountAmount": formValue.discountAmount,
                        "applicableFrom": formValue.applicableFrom,
                        "validTill": formValue.validTill,
                        "appliedDate": formValue.appliedDate
                    };
                }
    		}else{
    			if (!isNullOrEmpty(formValue.discountPercentage)) {
                    json = {
                    	"person": person,
                        "discountMaster": disMaster,
                        "applicant": applicant,
                        "appliedBy": appliedBy,
                        "studentDiscountStatus": "APPLIED",
                        "discountPercentage": addmanagediscount.down('#discountPercentageItemId').getRawValue(),
                        "applicableFrom": formValue.applicableFrom,
                        "validTill": formValue.validTill,
                        "appliedDate": formValue.appliedDate
                    };
                } else {
                    json = {
                    	"person": person,
                        "discountMaster": disMaster,
                        "applicant": applicant,
                        "appliedBy": appliedBy,
                        "studentDiscountStatus": "APPLIED",
                        "discountAmount": formValue.discountAmount,
                        "applicableFrom": formValue.applicableFrom,
                        "validTill": formValue.validTill,
                        "appliedDate": formValue.appliedDate
                    };
                }
    		}
            
        }
        return json;
    },

    showAddDiscountEntry: function(isButton) {
        var $this = this;
    	var discountForm = $this.getManagediscountfilter()
    	userType = discountForm.down('#userType').getValue();
    	
    	
    	
    	var academyLocationId = discountForm.down('#manageDiscountAcademyLocId').getValue();
        var alIds = [];
            var academyLocationIds = null;
         if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
                for (var i in academyLocationId) {
                    if (Ext.isObject(academyLocationId[0])) {
                        if(Ext.isObject(academyLocationId[i]) && academyLocationId[i]!=""){
                            alIds.push(academyLocationId[i].get("id"));
                        }else{
                            alIds.push(academyLocationId[i]);
                        }
                    } else {
                        alIds.push(academyLocationId[i]);
                    }
                }
                academyLocationIds = alIds.join();
            }else{
                academyLocationIds = academyLocationId;
            }
    	
    	var addForm =this.getAddmanagediscount();
    	var openTab;
    	if(addForm !=undefined && addForm.editMode == false){
    		isEditOPenVal = 'addFormOpen'
    	}
    	else{
    		var isEditOPenVal = this.getManagediscountfilter().config.isEditOpen
    	}
    	
    	
    	if(userType == getFeeAndPaymentCommonTranslation('STUDENT')){
    		var grid = $this.getManagediscountstudentlist();
    	}else
    	{
    		var grid = $this.getManagediscountapplicantlist();
    	}
        if (grid.getSelectionModel().getCount() > 0) {
            if (grid.getSelectionModel().getCount() == 1) {
                var record = grid.getSelectionModel().getSelection()[0];
                var contentpanel = this.getContentpanel();
                if(!isButton)
                {
                	var tabName = getFeeAndPaymentCommonTranslation('VIEW_DISCOUNT_ENTRY');
                	if(isEditOPenVal==true) {
                		openTab = getFeeAndPaymentCommonTranslation('EDIT_DISCOUNT_ENTRY');
                	}else if(isEditOPenVal == undefined && isButton ==true){
                		openTab = getFeeAndPaymentCommonTranslation('VIEW_DISCOUNT_ENTRY');
                	}else if(isEditOPenVal == 'addFormOpen'){
                		openTab = getFeeAndPaymentCommonTranslation('ADD_DISCOUNT_ENTRY');
                	}else{
                		openTab = getFeeAndPaymentCommonTranslation('VIEW_DISCOUNT_ENTRY');
                	}
                }else{
                	var tabName = getFeeAndPaymentCommonTranslation('EDIT_DISCOUNT_ENTRY');
                	if(isEditOPenVal==true){
                		openTab = getFeeAndPaymentCommonTranslation('EDIT_DISCOUNT_ENTRY');
                	}else if(isEditOPenVal == undefined && isButton ==false){
                		openTab = getFeeAndPaymentCommonTranslation('EDIT_DISCOUNT_ENTRY');

                	}else if(isEditOPenVal == 'addFormOpen'){
                		openTab = getFeeAndPaymentCommonTranslation('ADD_DISCOUNT_ENTRY');
                	}else{
                		openTab = getFeeAndPaymentCommonTranslation('VIEW_DISCOUNT_ENTRY');
                	}
                }
                
                var form1 = this.getAddmanagediscount();
                discountForm.viewMode = isButton;
                var getcontroller= $this.getController('menu.CoreERPNavigationController');
                var getTab = getcontroller.getTab(openTab);
                if (getTab != null) {
                    contentpanel.remove(getTab, true);
                }
                var contentXtype = 'adddiscountentrystructure'; //'billformstructure';
                var newTab = this.getTabReferenceByTabTitle(tabName);
                if (!newTab) {
                    newTab = contentpanel.add({
                        xtype: contentXtype,
                        closable: true,
                        title: tabName,
                        menuColorCls: CONSTANTS.MENU_COLOR_FIVE
                    });
                }
                if(record){
                	newTab.student=record.data.studentCode;
                    }
                if(academyLocationIds)
                	{
                	newTab.academyLocations=academyLocationIds;
                	}
                contentpanel.setActiveTab(newTab);
                var discountForm = newTab.down('addmanagediscount');
                discountForm.viewMode = isButton;
                Ext.apply(discountForm, {
                    editMode: null,
                    setEditMode: function(editMode) {
                        discountForm.editMode = editMode;
                    },
                    getEditMode: function() {
                        return discountForm.editMode;
                    }
                });
                discountForm.setEditMode(true);
                
                var siblingparenttabpanel = newTab.down('#adddiscountsubtabsitemid');
                /*siblingparenttabpanel.down('#adddiscountstudentsibilingtab').setVisible(false);
                siblingparenttabpanel.down('#adddiscountstudentparenttab').setVisible(true);*/ 
                siblingparenttabpanel.setVisible(false);
               /* var structure=this.getAdddiscountentrystructure();
                structure.down('#adddiscountstudentparentgridItem').setVisible(true);*/

                var structure=this.getAdddiscountentrystructure();
                var parentGrid =  structure.down('#adddiscountstudentparentgridItem')
                 parentGrid.setVisible(true);
                /*   grid.getSelectionModel().select(record);
                    var studentField =discountForm.down("#student");
                     var studentId = studentField.getValue();
                   var store = parentGrid.getStore();
     	            store.getProxy().extraParams = {
     		            id: studentField.findRecordByValue(studentId).data.personId
 		                }
     	            store.load();*/

                

                Ext.apply(discountForm, {
                    recordId: null,
                    setRecordId: function(recordId) {
                        discountForm.recordId = recordId;
                    },
                    getRecordId: function() {
                        return discountForm.recordId;
                    },
                    studentDiscountStatusEdit: null,
                    setStudentDiscountStatusEdit: function(studentDiscountStatusEdit) {
                        discountForm.studentDiscountStatusEdit = studentDiscountStatusEdit;
                    },
                    getStudentDiscountStatusEdit: function() {
                        return discountForm.studentDiscountStatusEdit;
                    }
                    
                });
                discountForm.setRecordId(grid.getSelectionModel().getSelection()[0].data.id);
                discountForm.setStudentDiscountStatusEdit(record.data.studentDiscountStatus);
                discountForm.down('#applicableFromItemId').setValue(dateRender(record.data.applicableFrom));
                discountForm.down('#validTillItemId').setValue(dateRender(record.data.validTill));
                discountForm.down('#appliedDateItemId').setValue(dateRender(record.data.appliedDate));
                if(!isButton)
                {
                	$this.getManagediscountfilter().config.isEditOpen = false;
                discountForm.setTitle(getFeeAndPaymentCommonTranslation('VIEW_DISCOUNT_ENTRY'));
                }else
                	{
                	$this.getManagediscountfilter().config.isEditOpen = true;
                	discountForm.setTitle(getFeeAndPaymentCommonTranslation('EDIT_DISCOUNT_ENTRY'));
                	}
                if(record.data.studentDiscountStatus=="APPROVED")
                {
                	discountForm.down('#student').setReadOnly(true);
                	discountForm.down('#discountTypeItemId').setReadOnly(true);
                	discountForm.down('#discountPercentageItemId').setReadOnly(true);
                	discountForm.down('#discountAmount').setReadOnly(true);
                	discountForm.down('#applicableFromItemId').setReadOnly(true);
                	discountForm.down('#appliedDateItemId').setReadOnly(true);
                	discountForm.down('#user_name').setReadOnly(true);
                	

                }
                if(record.data.studentDiscountStatus=="REJECTED")
                {
                	$this.toggleReadOnlyFormItems(discountForm.getForm(), true);
                }
                
                discountForm.down('#CancelBtn').setVisible(false);
                discountForm.down('#SubmitBtn').setDisabled(false);
                var student = discountForm.down('#student');
                var applicant = discountForm.down('#applicant');
                var userTypeField = discountForm.down('#userType');
                if(record.data.userType == 'APPLICANT')
                	{
                	student.setVisible(false);
                	applicant.setVisible(true);
                	student.allowBlank=true;
                	applicant.getStore().load({
                           callback: function(rec) {
                               for (var i in rec) {
                                   if (rec[i].data.id == record.data.applicantId) {
                                       var arr = [];
                                       arr.push(rec[i]);
                                       $this.setAddressForDiscountApplicant(applicant, arr);
                                       applicant.setValue(rec[i].data.id);
                                       break;
                                   }
                               }
                           }
                       });
                	   
                	   userTypeField.getStore().load({
                           callback: function(rec) {
                               for (var i in rec) {
                                   if (rec[i].data.id == record.data.userType) {
                                       var arr = [];
                                       arr.push(rec[i]);
                                       userTypeField.setValue(rec[i].data.value);
                                       break;
                                   }
                               }
                           }
                       });
                	}else
                		{
                		applicant.setVisible(false);
                		student.setVisible(true);
                		applicant.allowBlank=true;
                		   student.getStore().load({
                               callback: function(rec) {
                            	   for (var i in rec) {
                            		   if (rec[i].data.id == record.data.studentId) {
                            			   var arr = [];
                            			   arr.push(rec[i]);
                            			   $this.setAddressForDiscountStudent(student, arr);
                            			   student.setValue(rec[i].data.id);
                            			   var studentField = discountForm.down("#student");
                            			   var studentId = studentField.getValue();
                            			   //$this.loadStudentParentGrid(studentField.findRecordByValue(studentId).data.personId);
                            			   var studentSibblingGrid = $this.getAdddiscountstudentparentgrid();
                            			   var store = studentSibblingGrid.getStore();
                            			   store.getProxy().extraParams = {
                            				   id: studentField.findRecordByValue(studentId).data.personId
                            			   }
                            			   store.load({
                            				   callback: function(rec) {
                            					   /*if(isNullOrEmpty(studentSibblingGrid.el)){
                            						   var gridLen =Ext.ComponentQuery.query('adddiscountstudentparentgrid').length;
                            						   for(var i=0 ;i<gridLen;i++){
                            							   var parentGridEL =Ext.ComponentQuery.query('adddiscountstudentparentgrid')[i]
                            							   if(!isNullOrEmpty(parentGridEL.el)){
                            								   studentSibblingGrid =parentGridEL;
                            								   break;
                            							   }
                            						   }
                            					   }*/
                            					   for (var i in rec) {
                            							if(isButton == false) {
                           						   		 parentGrid.columns[7].hide()
                           						     	}
                            						   if(rec[i].data.employeeId){
                            							   if (rec[i].data.employeeId == record.data.employeeId) {
                            								   parentGrid.getSelectionModel().select(rec[i]);
                                							   rec[i].set('linkedRecord',true);
                                						   }
                            						   }
                            						  
                            					   }

                            				   }
                            			   });
                            			 
                            			   break;
                            		   }
                            	   }
                               }
                           });
                		   
                		   userTypeField.getStore().load({
                               callback: function(rec) {
                                   for (var i in rec) {
                                       if (rec[i].data.id == record.data.userType) {
                                           var arr = [];
                                           arr.push(rec[i]);
                                           userTypeField.setValue(rec[i].data.value);
                                           break;
                                       }
                                   }
                               }
                           });
                		}
             
                var discount = discountForm.down('#discountTypeItemId');
                
                discount.setDisabled(false);
                discount.setReadOnly(true);
                userTypeField.setReadOnly(true)
                student.setReadOnly(true)
                applicant.setReadOnly(true)
                var store = discount.getStore();
                 store.getProxy().api.read = SERVERURL.FIND_ALL_DISCOUNT_MASTERS;
                 store.load({
                    callback: function(rec) {
                        for (var i in rec) {
                            if (!isNullOrEmpty(record.data.discountType) &&
                                rec[i].data.code.toUpperCase() == record.data.discountType.toUpperCase()) {
                                discount.setValue(rec[i].data.id);
                                var discountPercentage = discountForm.down('#discountPercentageItemId');
                                var discountAmount = discountForm.down('#discountAmount');
                                if (!isNullOrEmpty(record.data.discountAmount)) {
                                    discountAmount.setVisible(true);
                                    discountAmount.setDisabled(false);
                                    discountAmount.setReadOnly(true);
                                    discountAmount.allowBlank = false;
                                    discountAmount.setValue(record.data.discountAmount);
                                    discountPercentage.setVisible(false);
                                    discountPercentage.allowBlank = true;
                                    discountPercentage.reset();
                                } else {
                                    discountPercentage.setVisible(true);
                                    discountPercentage.setDisabled(false);
                                    discountPercentage.setReadOnly(true);
                                    discountPercentage.allowBlank = false;
                                    discountPercentage.getStore().getProxy().extraParams = {
                                        discountId: rec[i].data.id
                                    };
                                    discountPercentage.getStore().load({
                                        callback: function(records) {
                                            for (var j in records) {
                                                if (records[j].data.code == record.data.discountPercentage) {
                                                    discountPercentage.setValue(records[j].data.id);
                                                    break;
                                                }
                                            }
                                        }
                                    });
                                    discountAmount.setVisible(false);
                                    discountAmount.reset();
                                    discountAmount.allowBlank = true;
                                }
                                break;
                            }
                        }
                    }
                });
                var applidBy = discountForm.down('#user_name');
                applidBy.getStore().load({
                    callback: function(rec) {
                        for (var i in rec) {
                            if (rec[i].data.value.toUpperCase() == record.data.appliedBy.toUpperCase()) {
                                applidBy.setValue(rec[i].data.id);
                                break;
                            }
                        }
                    }
                });
                if (!isButton) {
                    discountForm.down('#SubmitBtn').setVisible(false);
                    discountForm.down('#CancelBtn').setVisible(false);
                    $this.toggleReadOnlyFormItems(discountForm.getForm(), true);
                }
            } else {
                showWarningMessage(getCommonTranslation('ALERTS'), getCommonTranslation('PLEASE_SELECT_ONLY_ONE_RECORD'));
            }
        } else {
            showWarningMessage(getCommonTranslation('ALERTS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
       
    	
        
    },
    saveDiscountApproveReject: function(obj) 
    {
        var $this = this;
        var discountapprovereject = $this.getDiscountapprovereject();
        
 	    var form = discountapprovereject.down('#discountapprovereject').getForm();
        var formValue = form.getValues();
    	var discountForm = $this.getManagediscountfilter()
    	userType = discountForm.down('#userType').getValue();
    	if(userType == getFeeAndPaymentCommonTranslation('STUDENT')){
    		var grid = $this.getManagediscountstudentlist();	
    	}else
    	{
    		var grid = $this.getManagediscountapplicantlist();
    	}
     	var jsonData = []; 
    	var selected = grid.selModel.getSelection();
    	if( selected.length > 0){
    		for( var i = 0; i < selected.length; i++) {
    			jsonData.push({
    				"id":selected[i].data.id,
    				"studentDiscountStatus" : formValue.appStatus,
    				"approvalRejectionDate" : formValue.approveRejectDate,
    				"remark" : formValue.remark,
    			});
    		}
    	}
        submitUrl = SERVERURL.APPROVE_REJECT_DISCOUNT;
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        Ext.Ajax.request({
            type: 'rest',
            url: submitUrl,
            jsonData: jsonData,
            method: 'POST',
            success: function(form, action) {
                Ext.getBody().unmask();
                var templateData= form.responseText;
                showSuccessMessage(getFeeAndPaymentCommonTranslation('APPROVE_REJECT'),templateData);
                $this.getDiscountapprovereject().close();
                grid.getSelectionModel().deselectAll();
                grid.getStore().reload();
            }
        });
    
    	
    	
    },
    getIdValueJson: function(id, value) {
  	  if (id) return {
  		  id: id,
  		  value: value
  	  };
    },
    approveRejectWindowOpen:function(obj){
    	var $this = this;
    	var discountForm = $this.getManagediscountfilter()
    	userType = discountForm.down('#userType').getValue();
    	
    	if(userType == getFeeAndPaymentCommonTranslation('STUDENT')){
    		var grid = $this.getManagediscountstudentlist();
    	}else
    	{
    		var grid = $this.getManagediscountapplicantlist();
    	}
    	var record = grid.getSelectionModel().getSelection();
    	if (grid.getSelectionModel().getCount() > 0) {
    		var formWindow = $this.getDiscountapprovereject();
    		if (!formWindow) {
    			Ext.widget('discountapprovereject');
    			formWindow = $this.getDiscountapprovereject();
    			
    			var jsonData = []; 
    	    	if( record.length > 0){
    	    		for( var i = 0; i < record.length; i++) {
    	    			jsonData.push(record[i].data.id);
    	    		}
    	    	}
    	    	if(record[0].data.userType)
    	    		{
    	    		var userType = record[0].data.userType; 
    	    		}
    		        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		        Ext.Ajax.request({
    		            type: 'rest',
    		            url: SERVERURL.FIND_MAX_DISCOUNT_APPLIEDDATE + '?masterIds=' + jsonData.join() + '&userType='+userType,
    		            method: 'GET',
    		            success: function(form, action) {
    		                Ext.getBody().unmask();
    		                var data = Ext.JSON.decode(form.responseText);
    		                formWindow.down('#approveRejectDateItemId').setValue(dateRender(data.appliedDate));
    		                formWindow.down('#approveRejectDateItemId').setMinValue(dateRender(data.appliedDate));
    		                formWindow.down('#approveRejectDateItemId').setMaxValue(dateRender(new Date()));
    		            }
    		        });
    		        
    		        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		        Ext.Ajax.request({
    		            type: 'rest',
    		            url: SERVERURL.PATH_FIND_COUNT_BY_ID + '?studentDiscountMasterIds=' + jsonData.join(),
    		            method: 'GET',
    		            success: function(form, action) {
    		                Ext.getBody().unmask();
    		                var data = Ext.JSON.decode(form.responseText);
    		                if(data.Approved)
    		                {
    		                	formWindow.down('#approvedId').setVisible(true);
    		                	formWindow.down('#approvedId').setValue(data.Approved);
    		                }
    		                if(data.Rejected)
    		                {
    		                	formWindow.down('#rejectedId').setVisible(true);
    		                	formWindow.down('#rejectedId').setValue(data.Rejected);
    		                }
    		                if(data.Applied)
    		                {
    		                	formWindow.down('#appliedId').setVisible(true);
    		                	formWindow.down('#appliedId').setValue(data.Applied);
    		                }
    		            }
    		        });

    		        formWindow.down('#noOfRecord').setValue(grid.getSelectionModel().getCount());
    		}
    		formWindow.show();
    		Ext.defer(function() {
    			formWindow.down('#approveRejectDateItemId').labelSeparator = '';
    			if(obj.itemId=='discountApproveBtn'){
    				formWindow.setTitle(getCommonTranslation('APPROVE'));
    				formWindow.down('#appStatus').setValue('APPROVED');
    				formWindow.down('#approveRejectDateItemId').setFieldLabel(getCommonTranslation('APPROVAL_DATE')+'<span class="required" style="color:red"> *</span>');
    			}else if(obj.itemId=='discountRejectBtn'){
    				formWindow.setTitle(getCommonTranslation('REJECT'));
    				formWindow.down('#appStatus').setValue('REJECTED');
    				formWindow.down('#approveRejectDateItemId').setFieldLabel(getCommonTranslation('REJECTION_DATE')+ '<span class="required" style="color:red"> *</span>');
    			}
    		}, 300, this);
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}

    }, 
    getShowAndHideUserByUserTypeInDiscount : function(obj,record){
    	var form = this.getAddmanagediscount();
    	var userType = record[0].get("value");
    	var applicantField = form.down("#applicant");
    	var studentField = form.down("#student");
    	
		var discountTypeField=form.down("#discountTypeItemId");
		discountTypeField.setDisabled(true);

    	applicantField.setVisible(false);
    	studentField.setVisible(false);

    	applicantField.reset();
    	studentField.reset();
    	
    	var studentSibblingGrid = this.getAdddiscountstudentsibilinggrid();
    	var studentParentGrid = this.getAdddiscountstudentparentgrid();
    	
    	form.down("#SubmitBtn").setDisabled(true);
    	if(userType == getFeeAndPaymentCommonTranslation('APPLICANT')){
    		applicantField.setVisible(true);
    		studentField.allowBlank=true;
    		/*if( !isNullOrEmpty(studentSibblingGrid) ){
    			studentSibblingGrid.getStore().removeAll();
    		}*/
    	}
    	if(userType == getFeeAndPaymentCommonTranslation('STUDENT')){
    		studentField.setVisible(true);
    		applicantField.allowBlank=true;
    		/*if( !isNullOrEmpty(studentParentGrid) ){
    			studentParentGrid.getStore().removeAll();
    		}*/
    	}
    },
    loadStudentSiblingGrid : function(id){
    	var form = this.getAddmanagediscount();
    	var studentSibblingGrid = this.getAdddiscountstudentsibilinggrid();
    	var store = studentSibblingGrid.getStore();
    	store.getProxy().extraParams = {
			id: id
		}
    	store.load();
    },
    loadApplicantSiblingGrid : function(id){
    	var form = this.getAddmanagediscount();
    	var studentSibblingGrid = this.getAdddiscountstudentsibilinggrid();
    	var store = studentSibblingGrid.getStore();
    	store.getProxy().extraParams = {
    		id: id,
			isApplicant: true
		}
    	store.load();
    },
    loadStudentParentGrid : function(id){
    	var form = this.getAddmanagediscount();
    	var studentSibblingGrid = this.getAdddiscountstudentparentgrid();
    	var store = studentSibblingGrid.getStore();
    	store.getProxy().extraParams = {
    		id: id
		}
    	store.load();
    },
    loadApplicantParentGrid : function(id){
    	var form = this.getAddmanagediscount();
    	var studentSibblingGrid = this.getAdddiscountstudentparentgrid();
    	var store = studentSibblingGrid.getStore();
    	store.getProxy().extraParams = {
    		id: id,
			isApplicant: true
		}
    	store.load();
    },
    
    loadParentTabGrid : function(){
    	var form = this.getAddmanagediscount();
    	var userTypeField = form.down("#userType");
    	var userType = userTypeField.getValue();
    	var applicantField = form.down("#applicant");
    	var studentField = form.down("#student");
    	
    	if(userType == getFeeAndPaymentCommonTranslation('APPLICANT')){
    		if( !isNullOrEmpty(applicantField.getValue()) ){
    			var applicantId = applicantField.getValue();
    			this.loadApplicantParentGrid(applicantField.findRecordByValue(applicantId).data.personId);
    		}
    	}
    	if(userType == getFeeAndPaymentCommonTranslation('STUDENT')){
    		if( !isNullOrEmpty(studentField.getValue()) ){
    			var studentId = studentField.getValue();
    			this.loadStudentParentGrid(studentField.findRecordByValue(studentId).data.personId);
    		}
    	}
    },
    
    loadSiblingTabGrid : function(){
    	var form = this.getAddmanagediscount();
    	var userTypeField = form.down("#userType");
    	var userType = userTypeField.findRecord().get("value");
    	var applicantField = form.down("#applicant");
    	var studentField = form.down("#student");
    	
    	if(userType == getFeeAndPaymentCommonTranslation('APPLICANT')){
    		if( !isNullOrEmpty(applicantField.getValue()) ){
    			this.loadApplicantSiblingGrid(applicantField.getValue());
    		}
    	}
    	if(userType == getFeeAndPaymentCommonTranslation('STUDENT')){
    		if( !isNullOrEmpty(studentField.getValue()) ){
    			this.loadStudentSiblingGrid(studentField.getValue());
    		}
    	}
    },
    
    //*********************** Manage Discount listing******************************
    getShowAndHideManageDiscountList : function(obj,record){

    	var form = this.getManagediscountfilter();
    	var discountStructure = this.getManagediscountstructure();
    	var userType = record[0].get("value");
    	var applicantField = form.down("#applicant");
    	var programId = form.down("#programId");
    	var studentField = form.down("#student");
    	var batchId = form.down("#batchId");
    	var seatType = form.down("#seatType");
    	var manageDiscountAcademyLocId =form.down("#manageDiscountAcademyLocId");
    	
    	var alValue = manageDiscountAcademyLocId.getValue();
    	 programId.reset();
    	 batchId.reset();
    	 batchId.disable();
    	 seatType.reset();
    	 seatType.disable();
    	 
    	applicantField.setVisible(false);
    	studentField.setVisible(false);

    	applicantField.reset();
    	studentField.reset();

    	var columnNames = [{
    		name:'DISCOUNT_TYPE',
    		dataIndex: 'discountType'
    	},{
    		name:'STUDENT_ID',
    		dataIndex: 'studentCode'
    	},{
    		name:'STUDENT_NAME',
    		dataIndex: 'studentName'
    	}];
    	
    	if(userType==getFeeAndPaymentCommonTranslation('STUDENT')){
    		columnNames.push({
        		name : 'STUDENT_FIRST_NAME',
        		dataIndex : 'firstName',
        		hidden:true,
        		flex : 1
        	},{
        		name : 'STUDENT_MIDDLE_NAME',
        		dataIndex : 'middleName',
        		hidden:true,
        		flex : 1
        	},{
        		name : 'STUDENT_LAST_NAME',
        		dataIndex : 'lastName',
        		hidden:true,
        		flex : 1
        	});
    	}
    	
    	columnNames.push({
    		name:'APPLICANT_ID',
    		dataIndex: 'applicantCode'
    	},{
    		name:'APPLICANT_NAME',
    		dataIndex: 'applicantName'
    	},{
    		name:'INTAKE_YEAR',
    		dataIndex: 'intakeYear',
    		hidden:true
    	},{
    		name:'PROGRAM',
    		dataIndex: 'programName',
    		hidden:true
    	},{
    		name:'BATCH',
    		dataIndex: 'batchName',
    		hidden:true
    	},{
    		name:'SEAT_TYPE',
    		dataIndex: 'seatType',
    		hidden:true
    	},{
    		name:'DISCOUNT_PERCENTAGE_AMOUNT',
    		dataIndex: 'discountPercentage',
    		renderfn:function(val,rec,record,rowIndex,colIndex,store,view){
    			if(!isNullOrEmpty(record.data.discountPercentage)){
    				return record.data.discountPercentage+' %';
    			}else
    			{
    				return record.data.discountAmount;
    			}
    		}
    	},{
    		name:'APPLICABLE_FROM',
    		dataIndex: 'applicableFrom',
    		renderfn:function(val,rec,record,rowIndex,colIndex,store,view){
    			return dateRender(val);
    		}
    	},{
    		name:'VALID_TILL',
    		dataIndex: 'validTill',
    		renderfn:function(val,rec,record,rowIndex,colIndex,store,view){
    			return dateRender(val);
    		}
    	},{
    		name:'APPLIED_DATE',
    		dataIndex: 'appliedDate',
    		renderfn:function(val,rec,record,rowIndex,colIndex,store,view){
    			return dateRender(val);
    		}
    	},{
    		name:'APPLIED_BY',
    		dataIndex: 'appliedBy'
    	},{
    		name:'STATUS',
    		dataIndex: 'studentDiscountStatus',
    		renderfn:function(val,rec,record,rowIndex,colIndex,store,view){
    			if(!isNullOrEmpty(val)) {
    				return getCommonTranslation(val);
    			} else {
    				return '-';
    			}
    		}
    	},{
    		name:'APPROVED_REJECTED_DATE',
    		dataIndex: 'approvedRejectedDate',
    		hidden:true,
    		renderfn:function(val1,rec,record,rowIndex,colIndex,store,view){
    			if(!isNullOrEmpty(val1)) {
    				return dateRender(val1);
    			} else {
    				return '-';
    			}
    		}
    	},{
    		name:'APPROVED_REJECTED_BY',
    		dataIndex: 'approvedRejectedBy',
    		hidden:true,
    		renderfn:function(val,rec,record,rowIndex,colIndex,store,view){
    			if(!isNullOrEmpty(val)) {
    				return val;
    			} else {
    				return '-';
    			}
    		}
    	},{
    		name:'REMARKS',
    		dataIndex: 'remark',
    		hidden:true,
    		
    	},{
    		name:'SETTLED_DISCOUNT',
    		dataIndex: 'voucherDate',
    		renderfn: function(val,rec,record,rowIndex,colIndex,store,view){
				return '<a href=#>View</a>';
    		}
    	});
    	
    	
    	columns = this.getDiscountGridColumns(columnNames,userType);

    	manageDiscountPanel = discountStructure.down("managediscountpanel"); 
    	manageDiscountStudentList = manageDiscountPanel.down("managediscountstudentlist");
    	manageDiscountStudentListStore = manageDiscountStudentList.getStore();
    	
    	manageDiscountApplicantList = manageDiscountPanel.down("managediscountapplicantlist");
    	manageDiscountApplicantListStore = manageDiscountApplicantList.getStore();

    	if(userType==getFeeAndPaymentCommonTranslation('STUDENT')){
    		manageDiscountStudentList.setVisible(true);
    		manageDiscountApplicantList.setVisible(false);
    		manageDiscountStudentList.getStore().removeAll();
    		studentField.setVisible(true);
    	}
    	if(userType==getFeeAndPaymentCommonTranslation('APPLICANT')){
    		manageDiscountStudentList.setVisible(false);
    		manageDiscountApplicantList.setVisible(true);
    		manageDiscountApplicantList.getStore().removeAll();
    		applicantField.setVisible(true);
    	}
    	
    	//Ext.suspendLayouts();
		//manageDiscountList.reconfigure(manageDiscountListStore, columns);
		//manageDiscountList.reconfigure(null,columns);
		//Ext.resumeLayouts(true);
    	manageDiscountStudentList.getView().refresh();
    	manageDiscountApplicantList.getView().refresh();

    },
    getDiscountGridColumns: function(columnNames,userType) {
        var columns = new Array();
        for (var count = 0; count < columnNames.length; count++) {
        	if(userType==getFeeAndPaymentCommonTranslation('STUDENT') && (columnNames[count].name=='APPLICANT_ID' || columnNames[count].name=='APPLICANT_NAME' )){
        		
        	}
        	else if(userType==getFeeAndPaymentCommonTranslation('APPLICANT') && (columnNames[count].name=='STUDENT_ID' || columnNames[count].name=='STUDENT_NAME' )){
        		
        	}
        	else {
        		if(Ext.isDefined(columnNames[count].renderfn)){
            		columns.push({
    	                header: getFeeAndPaymentCommonTranslation(columnNames[count].name),
    	                dataIndex: columnNames[count].dataIndex,
    	                hidden: columnNames[count].hidden,
    	                flex: .2,
    	                renderer: columnNames[count].renderfn
    	            });
            	}else{
    	            columns.push({
    	                header: getFeeAndPaymentCommonTranslation(columnNames[count].name),
    	                dataIndex: columnNames[count].dataIndex,
    	                hidden: columnNames[count].hidden,
    	                flex: .2
    	            });
            	}
        	}
        }
        return columns;
    },
    getLoadDiscountList: function(grid){
    	$this =this;
    	var form = $this.getManagediscountfilter();
    	var getForm = form.getForm();
    	var getFormValues = getForm.getValues();
    	var store = grid.getStore();
    	var userTypeField = getForm.findField('userType');
    	var record =getFormValues.manageDiscountAcademyLoc;
    	var alids =[];
		if(record.length>0){
 		   for (var i in record) {
 			   if(Ext.isObject(record[i])){
 				   alids.push(record[i].get('id'));
 			   }
 			   else{
 				   alids.push(record[i]);	
 			   }
 		   }
 	   }
    	if(userTypeField.getValue() ==getFeeAndPaymentCommonTranslation('STUDENT'))
    	{
    		store.getProxy().extraParams = {
    			academyLocationIds: alids.join(),
    			discountId: getFormValues.discountType,
    			studentId: getFormValues.student,
    			studentDiscountStatus: getFormValues.appStatus,
    			appliedBy: getFormValues.appliedBy,
    			approvedBy: getFormValues.approvedBy,
    			intakeYearId: getFormValues.intakeYear,
    			programId: getFormValues.programId,
    			batchId: getFormValues.batchId,
    			seatId: getFormValues.seatType,
    			applicableFromDate: getFormValues.applicableFromDate,
    			applicableToDate: getFormValues.applicableToDate,
    			approvedFromDate: getFormValues.approvedFromDate,
    			approvedToDate: getFormValues.approvedToDate,
    			discountValidFromDate: getFormValues.discountValFromDate,
    			discountValidToDate: getFormValues.discountValToDate,
    			discountAppliedFromDate: getFormValues.discountAppFromDate,
    			discountAppliedToDate: getFormValues.discountAppToDate,
    			firstName:getFormValues.firstName,
    			middleName:getFormValues.middleName,
    			lastName:getFormValues.lastName,
    			isApplicant:false
    		};
    	}else
    	{
    		store.getProxy().extraParams = {
    			academyLocationIds: alids.join(),
    			discountId: getFormValues.discountType,
    			applicantId: getFormValues.applicant,
    			studentDiscountStatus: getFormValues.appStatus,
    			appliedBy: getFormValues.appliedBy,
    			approvedBy: getFormValues.approvedBy,
    			intakeYearId: getFormValues.intakeYear,
    			programId: getFormValues.programId,
    			batchId: getFormValues.batchId,
    			seatId: getFormValues.seatType,
    			applicableFromDate: getFormValues.applicableFromDate,
    			applicableToDate: getFormValues.applicableToDate,
    			approvedFromDate: getFormValues.approvedFromDate,
    			approvedToDate: getFormValues.approvedToDate,
    			discountValidFromDate: getFormValues.discountValFromDate,
    			discountValidToDate: getFormValues.discountValToDate,
    			discountAppliedFromDate: getFormValues.discountAppFromDate,
    			discountAppliedToDate: getFormValues.discountAppToDate,
    			isApplicant:true
    		};
    	}

    	$this.resetPageSetting(store)
    	grid.getSelectionModel().deselectAll();
    	store.load({
  			 callback: function(records, operation, success) {
  				form.down('#searchBtn').setDisabled(false);
  			 }  
   		 });
    },
    doAccessControlValidationGrid: function(grid, privilegesMap){
		var associatedAcadLIds = new Array();
		associatedAcadLIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLIds, privilegesMap);
        var discountApproveBtn = grid.down('#discountApproveBtn');
        var discountRejectBtn = grid.down('#discountRejectBtn');
        if(grid && discountApproveBtn && discountRejectBtn){
        	discountApproveBtn.setVisible(false);
        	discountRejectBtn.setVisible(false);
        	Ext.each(permissionList, function(privilege) {
        		if(privilege == 'APPROVE'){
        			discountApproveBtn.setVisible(true);
        		}
        		if(privilege == 'REJECT'){
        			discountRejectBtn.setVisible(true);
        		}

        	});
        }
    },
    manageOtherFilerByAcademyLocation : function(){
    	var form=this.getManagediscountfilter().getForm();
    	var manageDiscountAcademyLoc = form.findField('manageDiscountAcademyLoc');
    	var record = manageDiscountAcademyLoc.getValue();
		var academyLocationId = this.getCurrentAcademyLocation();
		
		if(record.length>0 && record[0] !=""){
			var alids =[];
	 		   for (var i in record) {
	 			   if(Ext.isObject(record[i])){
	 				   alids.push(record[i].get('id'));
	 			   }
	 			   else{
	 				   alids.push(record[i]);	
	 			   }
	 		   }
	 	   }else{
	 		   var alids =this.getCurrentAcademyLocation();
	 	   }
		
		if(isArray(alids)){
 		   alidsValue =  alids.join(); 
 	   }else{
 		   alidsValue = alids;
 	   }
		var program = form.findField('programId');
		program.reset();
		program.getStore().getProxy().extraParams={
			academyLocationIds:alidsValue
		};
		program.getStore().load();

		
		
		var manageDiscountFilterStudentStore = form.findField('student').getStore();
		manageDiscountFilterStudentStore.getProxy().extraParams = {
			academyLocationIds : alidsValue
		};
		manageDiscountFilterStudentStore.load();
		

		var manageDiscountFilterApplicantStore = form.findField('applicant').getStore();
		manageDiscountFilterApplicantStore.getProxy().extraParams = {
			academyLocationIds : alidsValue
		};
		manageDiscountFilterApplicantStore.load();
    }
});
