/*
 *  @author Amit G
 * 
 */
Ext.define('Academia.controller.hostel.accommodationProvider.AccommodationProviderController', {
	extend : 'Academia.controller.base.BaseController',

	models : ['Academia.model.hostel.accommodationProvider.AccommodationProviderCreateModel'],
	
	stores : ['hostel.accommodationProvider.AccommodationProviderGridStore'],
	          
	views : ['hostel.accommodationProvider.AccommodationProviderStructure',
	         'hostel.accommodationProvider.AccommodationProviderGrid','hostel.accommodationProvider.AccommodationProviderForm'
	         ],
	         config: {
	        	 MANAGE_ACCOMMODATION_PROVIDER_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_ACCOMMODATION_PROVIDER_PRIVILEGES'),
	         },
	         refs :[{
	        	 ref : 'managehostelstructure',
	        	 selector : 'managehostelstructure'
	         },{
	        	 ref : 'accommodationprovidergrid',
	        	 selector : 'accommodationprovidergrid'
	         },{
	        	 ref : 'accommodationproviderform',
	        	 selector : 'accommodationproviderform'
	         },{
	         	ref: 'contentPanel',
	        	selector: 'contentPanel'
	        }],

	init : function() {
		this.control({
			'accommodationprovidergrid button[itemId=btnEdit]':{
				click :	function(cmp){
					this.editAccommodationProviderDetails(false);
				}
			},
			'accommodationprovidergrid button[itemId=btnView]':{
				click :	function(cmp){
					this.editAccommodationProviderDetails(true);
				}
			},
			'accommodationprovidergrid button[itemId=btnAdd]':{
				click: this.addAccommodationProviderRecord
			},
			'accommodationprovidergrid':{
    			 render:function(grid){
    				grid.getStore().load();
 					this.genericCBGridAccessControlValidation(grid, this.getMANAGE_ACCOMMODATION_PROVIDER_PRIVILEGES());
 				}
			},
			'accommodationproviderform button[itemId=submitBtn]':{
    			click: function(){
    				this.saveAccommodationProviderDetails(true)
    			}
    		},
    		'accommodationprovidergrid button[itemId=btnDelete]': {
    			click:this.deleteAccommodationProviderDetails
    		}
		});
	},
	addAccommodationProviderRecord:function(isViewMode){
		   var $this = this;
	 	   var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
	 	   var structure = Ext.widget('accommodationproviderform');
	 	   var tabName = getHostelTranslation('ACCOMMODATION_PROVIDER_DETAILS');
	 	   /**
	 	    * This is to remove tab from content panel and open same tab again
	 	    */
	 	   var getcontroller=this.getController('menu.CoreERPNavigationController');
	 	   var getTab=getcontroller.getTab(tabName);
	 	   if(getTab!=null){
	 		   contentPanel.remove(getTab, true);
	 	   }
	 	 openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_TWELVE);	
	 	Ext.Ajax.request({
       	 type: 'rest',
       	 url: SERVERURL.FIND_WHETHER_CONFIGORNOT_DATA_SETTING_FOR_ACCOMMODATION_PROVIDER,
       	 method: 'GET',
       	 headers : {
       		 'Content-Type' : 'application/json'
       	 },
       	 success: function(response,form, action) {
       		if(!isNullOrEmpty(response.responseText)){
       			var responseObject =  Ext.JSON.decode(response.responseText);//make object of response text
				$this.formData=responseObject; 
				if(!isNullOrEmpty(responseObject)){
            var providercode= structure.down('#providerCode')
		            if(!isViewMode){
							 if(responseObject === true){
								 providercode.setReadOnly(false)
								 $this.setAllowBlank(providercode,false);  
								 $this.setFieldPlaceHolder(providercode,'');
		             }else{
								 providercode.setReadOnly(true);
								 $this.setAllowBlank(providercode,true);
								 $this.setFieldPlaceHolder(providercode,getCommonTranslation('ID_AUTOGENERATE'));
							 }
		            }
				}
       		}                 
        
       	 }
        });
	    },
	 saveAccommodationProviderDetails: function(isAdd){

	  	  var $this = this;
	  	  var accommodationproviderform = $this.getAccommodationproviderform();
	  	  var grid = $this.getAccommodationprovidergrid();
	  	  var form = accommodationproviderform.getForm();
	  	  accommodationproviderform.down('#submitBtn').setDisabled(true);
	  	  var value = form.getValues();
	  	 if ($this.validateAccomodationPhone(value,accommodationproviderform)) {
	  	  var accommodationprovidercreatemodel = new Academia.model.hostel.accommodationProvider.AccommodationProviderCreateModel();
	  	  accommodationprovidercreatemodel.set("providerCode",value.providerCode);
	  	  accommodationprovidercreatemodel.set("accommodProviderName",value.accommodProviderName);
	  	  accommodationprovidercreatemodel.set("accreditationStatus",value.accreditationStatus);
	  	  accommodationprovidercreatemodel.set("contactPerson",value.contactPerson);
	  	  accommodationprovidercreatemodel.set("contactEmail",value.contactEmail);
	  	  accommodationprovidercreatemodel.set("status",value.status);
	  	  accommodationprovidercreatemodel.set("phoneAreaCode",value.phoneAreaCode);
	  	  accommodationprovidercreatemodel.set("phoneCountryCode",value.phoneCountryCode);
	  	  accommodationprovidercreatemodel.set("phoneNo",value.phoneNo);
	  	  accommodationprovidercreatemodel.set("mobileCountryCode",value.mobileCountryCode);
	  	  accommodationprovidercreatemodel.set("mobileNo",value.mobileNumber);
	  	  accommodationprovidercreatemodel.set("address",value.address);
	  	  accommodationprovidercreatemodel.set("roomsAvailable",value.roomsAvailable),
	  	  accommodationprovidercreatemodel.set("isIntellimaliRegistered",value.isIntellimaliRegistered);
	   	 accommodationprovidercreatemodel.set("isIntellimaliRegistered",value.isIntellimaliRegistered);
	   	 accommodationprovidercreatemodel.set("isIntellimaliRegistered",value.isIntellimaliRegistered);

	  	  if(!isNullOrEmpty(value.id)){
	  		  submitUrl = SERVERURL.PATH_ACCOMMODATION_PROVIDER_UPDATE; 
	  		accommodationprovidercreatemodel.set("id",value.id);
	  		  message = getHostelTranslation('PATH_ACCOMMODATION_PROVIDER_UPDATED_SUCCESSFULLY');
	  	  }
	  	  else{
	  		  submitUrl = SERVERURL.PATH_ACCOMMODATION_PROVIDER_CREATE; 
	  		  message = getHostelTranslation('PATH_ACCOMMODATION_PROVIDER_CREATED_SUCCESSFULLY');
	  	  }
	  	  var formData = Ext.encode(accommodationprovidercreatemodel.data);

	  	  var submitUrl; 
	  	  var message;
	  	  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	  	  Ext.Ajax.request({
	  		  type : 'rest',
	  		  url : submitUrl,
	  		  jsonData : formData,
	  		  method : 'POST',
	  		  success : function(frm, action) {
	  			  Ext.getBody().unmask();
	  			  var contentpanel = $this.getContentPanel();
	  			  var tabName = getHostelTranslation('ACCOMMODATION_PROVIDER_DETAILS');
	  			  var getcontroller=$this.getController('menu.CoreERPNavigationController');
	  			  var getTab=getcontroller.getTab(tabName);
	  			  if(getTab!=null){
	  				  contentpanel.remove(getTab, true);
	  			  }
	  			if(grid==null || grid==undefined){ }else{
           		 grid.getStore().reload();
           		 grid.getSelectionModel().deselectAll(true);
	  			}
	  			 
	  			  showSuccessMessage(getHostelTranslation('ACCOMMODATION_PROVIDER_DETAILS'), message);
	  		  }
	  	  });
	  	}
	    },
	    editAccommodationProviderDetails:function(isViewMode){
	    	var $this = this;
	    	var grid = $this.getAccommodationprovidergrid();
	    	if (grid.getSelectionModel().getCount() > 0) {
	    		$this.addAccommodationProviderRecord(isViewMode);
	    		var form = this.getAccommodationproviderform();
	    		var getform = form.getForm();
	    		var record = grid.getSelectionModel().getSelection()[0];
	    		form.loadRecord(record);
	    		if(record.data.isIntellimaliRegistered){
	    			form.down('#intellimaliRegisteredItemId').setValue({isIntellimaliRegistered:true});
	  	    		}
	    		form.down('#isIntellimaliRegisteredYes').setReadOnly(true);
	    		form.down('#isIntellimaliRegisteredNo').setReadOnly(true);
	    		form.down('#accreditationStatusId').setReadOnly(true);
	    		form.down('#providerCode').setReadOnly(true);
	    		var phoneCountryCode=form.down('#phoneCountryCode');
				 if(record.data.phoneCountryCode!=null){
					 phoneCountryCode.store.load({
						 callback: function(records, operation, success) {
							 if (success) {
								 phoneCountryCode.setValue(record.data.phoneCountryCode);
							 }
						 }
					 });
				 }
				 var mobileNumber=form.down('#mobileNumber');
				 mobileNumber.setValue(record.data.mobileNo);
				 var phoneAreaCodeField=form.down('#phoneAreaCode');
				 phoneAreaCodeField.setValue(record.data.phoneAreaCode);
				 var phoneNoField=form.down('#phoneNoField');
				 phoneNoField.setValue(record.data.phoneNo);
				 
				 var mobileCountryCode=form.down('#cellCountryCode');
				 if(record.data.mobileCountryCode!=null){
					 mobileCountryCode.store.load({
						 callback: function(records, operation, success) {
							 if (success) {
								 mobileCountryCode.setValue(record.data.mobileCountryCode);
							 }
						 }
					 });
				 }
				 if(isViewMode){
					 	 $this.toggleReadOnlyFormItems(form.getForm(), true);
						 form.down('#submitBtn').setVisible(false);
					 }else{
						 form.down('#submitBtn').setVisible(true);
					 }
	    	}else{
	    		showWarningMessage(getHostelTranslation('ACCOMMODATION_PROVIDER_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
	    	}
	    },
	    // *********** delete ACCOMMODATION_PROVIDER_DETAILS records *********
	    deleteAccommodationProviderDetails:function(){
	    	 var $this = this;
	    	 var grid = $this.getAccommodationprovidergrid();
	         var grdStore = grid.getStore();
	         if (grid.getSelectionModel().getCount() > 0) {
	        	 showConfirmMessage(getHostelTranslation('ACCOMMODATION_PROVIDER'), getHostelTranslation('ARE_YOU_SURE_YOU_WANT_TO_DELETE'), function(btn, text) {
	                 if (btn == 'yes') {
	                     var records = grid.getSelectionModel().getSelection();
	                     var id = records[0].get("id");
	                     Ext.Ajax.request({
	                         method: "DELETE",
	                         type: 'rest',
	                         url: SERVERURL.PATH_ACCOMMODATION_PROVIDER_DELETE+'/'+id,
	                         headers: {
	                             'Content-Type': 'application/json'
	                         },
	                         success: function(form, action) {
	                        	 var contentpanel = $this.getContentPanel();
	                        	 var tabName = getHostelTranslation('ACCOMMODATION_PROVIDER_DETAILS');
	                        	 var getcontroller=$this.getController('menu.CoreERPNavigationController');
	                        	 var getTab=getcontroller.getTab(tabName);
	                        	 if(getTab!=null){
	                        		 contentpanel.remove(getTab, true);
	                        	 }
	                        	 if(grid==null || grid==undefined){ }else{
	                        		 grid.getStore().reload();
	                        		 grid.getSelectionModel().deselectAll(true);
	                        	 }
	                        	 showSuccessMessage(getHostelTranslation('ACCOMMODATION_PROVIDER'), getHostelTranslation('ACCOMMODATION_PROVIDER_DELETED_SUCCESSFULLY'));
	                         }
	                     });
	                 }
	             });
	         } else {
	             showWarningMessage(getHostelTranslation('ACCOMMODATION_PROVIDER'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
	         }
	     },
	     validateAccomodationPhone:function(data,form){
	     	var isValid;
	    	if(!(data.phoneNo && data.phoneCountryCode && data.phoneAreaCode) && !(data.mobileNumber && data.mobileCountryCode)){
	    		showWarningMessage(getCommonTranslation('ALERT'),getHostelTranslation('PHONE_NO_VALIDATION_MESSAGE'));
	    		form.down('#submitBtn').setDisabled(false);
	    		isValid= false;
	    	}
	    	else{
	    		isValid=true;
	    	}
	    	return isValid;
	    },
});
