/*
 * @author Pankaj Sisodiya
 * 
 */
Ext.define('Academia.controller.hostel.hostelApplicationSetup.HostelApplicationSetupController', {
	extend : 'Academia.controller.base.BaseController',

	stores : ['emailAccountStatement.EmailAccountCriteriaGridStore','common.AcademicTermStore','hostel.HostelApplicationSetup.SetupCodeNameStore','hostel.HostelApplicationSetup.HostelApplicationSetupGridStore',
		'hostel.HostelApplicationSetup.HostelApplicationSetupMapProgramGridStore','hostel.HostelApplicationSetup.HostelSetupALMappingStore','manageCeremony.CeremoneyALMappingComboStore','manageCeremony.CeremoneyProgramGroupMappingStore','manageCeremony.CeremonyProgramMappingStore','feeandpayment.FindAllProgramsByALId'
		,'feeandpayment.ALProgramBatchList','feeandpayment.ALProgramBatchSearchCombo','hostel.HostelApplicationSetup.HostelSetupSeatTypeStore','committee.committee.CommitteeBatchSeatTypeStore'],

	views : ['hostel.hostelApplicationSetup.HostelApplicationSetupStructure','hostel.hostelApplicationSetup.HostelApplicationSetupFilter','hostel.hostelApplicationSetup.HostelApplicationSetupGrid',
		'hostel.hostelApplicationSetup.AddHostelApplicationSetup','hostel.hostelApplicationSetup.AddHostelApplicationSetupStructure','hostel.hostelApplicationSetup.HostelApplicationSetupMapProgramStructure','hostel.hostelApplicationSetup.HostelApplicationSetupMapProgramGrid',
		'hostel.hostelApplicationSetup.HostelApplicationSetupAddMappingTab','hostel.hostelApplicationSetup.HostelApplicationSetupAddMappingStructure','hostel.hostelApplicationSetup.HostelApplicationSetupApplyToView','hostel.hostelApplicationSetup.HostelSetupAddMappingALGrid',
		'hostel.hostelApplicationSetup.HostelSetupAddMappingProgramGrid','hostel.hostelApplicationSetup.HostelSetupAddMappingBatchGrid','hostel.hostelApplicationSetup.HostelSetupAddMappingSeatTypeGrid','hostel.hostelApplicationSetup.DuplicatHostelMapWin'],	           

		refs :[{
			ref: 'hostelApplicationSetupStructure',
			selector: 'hostelApplicationSetupStructure'
		},{
			ref: 'hostelApplicationSetupFilter',
			selector: 'hostelApplicationSetupFilter'
		},{
			ref:'hostelApplicationSetupGrid',
			selector:'hostelApplicationSetupGrid'
		},{
			ref: 'contentPanel',
			selector: 'contentpanel'
		},{
			ref:'addHostelApplicationSetupStructure',
			selector:'addHostelApplicationSetupStructure'
		},{
			ref:'addHostelApplicationSetup',
			selector:'addHostelApplicationSetup'
		},{
			ref:'hostelApplicationSetupMapProgramStructure',
			selector:'hostelApplicationSetupMapProgramStructure'
		},{
			ref:'hostelApplicationSetupMapProgramGrid',
			selector:'hostelApplicationSetupMapProgramGrid'
		},{
			ref:'hostelApplicationSetupAddMappingStructure',
			selector:'hostelApplicationSetupAddMappingStructure'
		},{
			ref:'hostelApplicationSetupAddMappingTab',
			selector:'hostelApplicationSetupAddMappingTab'
		},{
			ref:'hostelApplicationSetupApplyToView',
			selector:'hostelApplicationSetupApplyToView'
		},{
			ref:'hostelSetupAddMappingALGrid',
			selector:'hostelSetupAddMappingALGrid'
		},{
			ref:'hostelSetupAddMappingProgramGrid',
			selector:'hostelSetupAddMappingProgramGrid'
		},{
			ref:'hostelSetupAddMappingSeatTypeGrid',
			selector:'hostelSetupAddMappingSeatTypeGrid'
		},{
			ref:'hostelSetupAddMappingBatchGrid',
			selector:'hostelSetupAddMappingBatchGrid'
		},{
			ref:'duplicatHostelMapWin',
			selector:'duplicatHostelMapWin'
		}],
		config: {
			HOSTEL_APPLICATION_SETUP_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('HOSTEL_APPLICATION_SETUP')
		},
		init : function() {
			this.control({
				'hostelApplicationSetupFilter customcombobox[itemId=accountTermId]':{
					change:function(cmp){
						var me = this,
						form = me.getHostelApplicationSetupFilter(),
						setupType = form.down('#setupType'),
						userType = form.down('#userType'),
						setupCodeName = form.down('#setupCodeName');
						setupCodeName.reset();
						setupCodeName.setDisabled(false);
						setupCodeName.getStore().getProxy().extraParams={
							userType:userType.getValue(),
							setupType:setupType.getValue(),
							academicTermId:cmp.getValue()
						}
						setupCodeName.getStore().load();
					}

				},
				'hostelApplicationSetupFilter customcombobox[itemId=userType]':{
					select:function(cmp){
						var me = this,
						form = me.getHostelApplicationSetupFilter(),
						setupType = form.down('#setupType'),
						accountTermId = form.down('#accountTermId'),
						setupCodeName = form.down('#setupCodeName');
						setupCodeName.reset();
						setupCodeName.getStore().getProxy().extraParams={
							userType : cmp.getValue(),
							setupType : setupType.getValue(),
							academicTermId : accountTermId.getValue()
						}
						setupCodeName.getStore().load();
					}

				},
				'hostelApplicationSetupFilter customcombobox[itemId=setupType]':{
					select:function(cmp){
						var me = this,
						form = me.getHostelApplicationSetupFilter(),
						accountTermId = form.down('#accountTermId'),
						userType = form.down('#userType'),
						setupCodeName = form.down('#setupCodeName');
						setupCodeName.reset();
						setupCodeName.getStore().getProxy().extraParams={
							userType : userType.getValue(),
							setupType : cmp.getValue(),
							academicTermId : accountTermId.getValue()
						}
						setupCodeName.getStore().load();
					}

				},
				'hostelApplicationSetupFilter button[itemId=searchHostelSetup]':{
					click :this.searchHostelApplicationSetup
				},
				'hostelApplicationSetupFilter button[itemId=resetBtnItemId]':{
					click :function(){
						var me = this,
						form = me.getHostelApplicationSetupFilter();
						form.getForm().reset();
					}
				},
				'addHostelApplicationSetup button[itemId=cancelBtnItemId]':{
					click :function(){
						var me = this,
						contentPanel = me.getActiveTabfromContentPanel();
						contentPanel.close();
					}
				},
				'hostelApplicationSetupStructure':{
					afterrender:function(cmp){
						var me = this,
						grid = me.getHostelApplicationSetupGrid(),
						academyLocationId = this.getCurrentAcademyLocation(),
						associatedAcadLocationIds = new Array(),
						form = me.getHostelApplicationSetupFilter();
						me.doAccessControlValidation(grid, me.getHOSTEL_APPLICATION_SETUP_PERMISSIONS());
						me.addDataGridConfigButton(grid,me.getHOSTEL_APPLICATION_SETUP_PERMISSIONS());
						associatedAcadLocationIds = new Array();
	        			associatedAcadLocationIds.push(academyLocationId);
	        				var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, me.getHOSTEL_APPLICATION_SETUP_PERMISSIONS());
	        				grid.down('#spBtnMoreActions').setVisible(false);
	        			permissionList.forEach(function(rec){
	        				if(rec=='MOREACTIONS'){
	        					grid.down('#spBtnMoreActions').setVisible(true);
	        				}
	        			})
					}
				},
				'hostelApplicationSetupGrid button[itemId=btnAdd]':{
					click:function(btn){
						this.addEditHostelSetupForm('ADD');

					}
				},
				'hostelApplicationSetupGrid':{
					selectionchange:function(cmp,selected){
						var me = this,
						grid = me.getHostelApplicationSetupGrid(),
						editbtn = grid.down('#btnEdit'),
						deletebtn = grid.down('#btnDelete'),
						viewbtn = grid.down('#btnView');
						if(selected && selected.length>0){
							editbtn.setDisabled(false);
							deletebtn.setDisabled(false);
							viewbtn.setDisabled(false);
						}else{
							editbtn.setDisabled(true);
							deletebtn.setDisabled(true);
							viewbtn.setDisabled(true);
						}

					}
				},
				'hostelApplicationSetupGrid button[itemId=btnDelete]':{
					click:function(btn){
						this.deleteHostelSetup();
					}
				},
				'hostelApplicationSetupGrid button[itemId=btnEdit]':{
					click:function(btn){
						this.addEditHostelSetupForm('EDIT');
					}
				},
				'hostelApplicationSetupGrid button[itemId=btnView]':{
					click:function(btn){
						this.addEditHostelSetupForm('VIEW');
					}
				},
				'addHostelApplicationSetup customcombobox[itemId=userType]':{
					change :function(cmp){
						var me = this,
						form = me.getAddHostelApplicationSetup(),
						offerLetterStartDate   = form.down('#offerLetterStartDate'),
						offerLetterEndDate   = form.down('#offerLetterEndDate'),
						maxDaysToAcceptOffer   = form.down('#maxDaysToAcceptOffer'),
						notificationBeforeOfferExpires   = form.down('#notificationBeforeOfferExpires'),
						offerApplicable   = form.down('#offerApplicable'),
						hostelSetupType   = form.down('#hostelSetupType'),
						applicationRuleApplicable   = form.down('#applicationRuleApplicable'),
						IsApplicationCancellationFromSP = form.down('#IsApplicationCancellationFromSP'),
						applicationCancellationFromDate =  form.down('#applicationCancellationFromDate'),
						applicationCancellationToDate = form.down('#applicationCancellationToDate'),
						TC_Document = form.down('#TC_Document');
						applicationRuleApplicable.reset();
						if(cmp.getValue() == 'APPLICANT'){
							cmp.getValue().offerApplicable &&	offerLetterStartDate.setVisible(true);
							offerLetterStartDate.setDisabled(false);
							cmp.getValue().offerApplicable && offerLetterEndDate.setVisible(true);
							offerLetterEndDate.setDisabled(false);
							cmp.getValue().offerApplicable && maxDaysToAcceptOffer.setVisible(true);
							maxDaysToAcceptOffer.setDisabled(false);
							cmp.getValue().offerApplicable && notificationBeforeOfferExpires.setVisible(true);
							notificationBeforeOfferExpires.setDisabled(false);
							offerApplicable.setVisible(true);
							offerApplicable.setDisabled(false);
							TC_Document.setVisible(false);
							TC_Document.setDisabled(true);
							IsApplicationCancellationFromSP.setVisible(false);
							applicationCancellationFromDate.setVisible(false);
							applicationCancellationToDate.setVisible(false);
							this.setAllowBlank(applicationCancellationFromDate,true);
							this.setAllowBlank(applicationCancellationToDate,true);
							var store= Ext.create('Ext.data.Store', {
								fields: ['id', 'value'],
								data: [{
									id: 'APPLICANT_WAITING_LIST_RULES',
							        value: getCommonTranslation('APPLICANT_WAITING_LIST_RULES')
								}]
							})
							applicationRuleApplicable.bindStore(store);
						}else if(cmp.getValue() == 'STUDENT'){
							offerLetterStartDate.setVisible(false);
							offerLetterStartDate.setDisabled(true);
							offerLetterEndDate.setVisible(false);
							offerLetterEndDate.setDisabled(true);
							maxDaysToAcceptOffer.setVisible(false);
							maxDaysToAcceptOffer.setDisabled(true);
							notificationBeforeOfferExpires.setVisible(false);
							notificationBeforeOfferExpires.setDisabled(true);
							offerApplicable.setVisible(false);
							offerApplicable.setDisabled(true);
							TC_Document.setVisible(true);
							TC_Document.setDisabled(false);
							IsApplicationCancellationFromSP.setVisible(true);
							if(IsApplicationCancellationFromSP.getValue() && IsApplicationCancellationFromSP.getValue().IsApplicationCancellationFromSP){
								applicationCancellationFromDate.setVisible(true);
								applicationCancellationToDate.setVisible(true);
								this.setAllowBlank(applicationCancellationFromDate,false);
								this.setAllowBlank(applicationCancellationToDate,false);
							}else{
								applicationCancellationFromDate.setVisible(false);
								applicationCancellationToDate.setVisible(false);
								this.setAllowBlank(applicationCancellationFromDate,true);
								this.setAllowBlank(applicationCancellationToDate,true);
							}
						var store=	Ext.create('Ext.data.Store', {
								fields: ['id', 'value'],
								data: [ {
							        id: 'STUDENT_WAITING_LIST_RULES_FOR_NEXT_YEAR',
							        value: getCommonTranslation('STUDENT_WAITING_LIST_RULES_FOR_NEXT_YEAR')
							    }, {
							        id: 'STUDENT_WAITING_LIST_CURRENT_YEAR_RULES',
							        value: getCommonTranslation('STUDENT_WAITING_LIST_CURRENT_YEAR_RULES')
							    }
							     ]
							});
							
							applicationRuleApplicable.bindStore(store);
						}else {
							TC_Document.setVisible(false);
							TC_Document.setDisabled(true);
						}
						hostelSetupType.fireEvent('select',hostelSetupType);
						form.doLayout();
						form.isValid();
						form.getForm().clearInvalid();
					}
				},
				'addHostelApplicationSetup customcombobox[itemId=hostelSetupType]':{
					select:function(cmp){
						var me = this,
						form = me.getAddHostelApplicationSetup(),
						userType = form.down('#userType'),
						applicationRuleApplicable   = form.down('#applicationRuleApplicable');
						if(cmp.getValue()=='HOSTEL_GENERAL_SETUP' && userType.getValue()== 'STUDENT'){
							applicationRuleApplicable.reset();
							applicationRuleApplicable.setVisible(false);
						}else{
							applicationRuleApplicable.setVisible(true);
						}
					}

				},
				'addHostelApplicationSetup radiogroup[itemId=offerApplicable]':{
					change :function(cmp){
						var me = this,
						form = me.getAddHostelApplicationSetup(),
						offerLetterStartDate   = form.down('#offerLetterStartDate'),
						offerLetterEndDate   = form.down('#offerLetterEndDate'),
						maxDaysToAcceptOffer   = form.down('#maxDaysToAcceptOffer');
						notificationBeforeOfferExpires   = form.down('#notificationBeforeOfferExpires');
						if(cmp.getValue().offerApplicable){
							offerLetterStartDate.setVisible(true);
							
							this.setAllowBlank(offerLetterStartDate, false);
							offerLetterEndDate.setVisible(true);
							this.setAllowBlank(offerLetterEndDate, false);
							maxDaysToAcceptOffer.setVisible(true);
							this.setAllowBlank(maxDaysToAcceptOffer, false);
							notificationBeforeOfferExpires.setVisible(true);
							this.setAllowBlank(notificationBeforeOfferExpires, false);
						}else{
							offerLetterStartDate.setVisible(false);
							offerLetterStartDate.reset();
							this.setAllowBlank(offerLetterStartDate, true);
							offerLetterEndDate.setVisible(false);
							offerLetterEndDate.reset();
							this.setAllowBlank(offerLetterEndDate, true);
							maxDaysToAcceptOffer.setVisible(false);
							maxDaysToAcceptOffer.reset();
							this.setAllowBlank(maxDaysToAcceptOffer, true);
							notificationBeforeOfferExpires.setVisible(false);
							notificationBeforeOfferExpires.reset();
							this.setAllowBlank(notificationBeforeOfferExpires, true);
						}
						form.doLayout();
						form.isValid();
						form.getForm().clearInvalid();
					}
				},
				'addHostelApplicationSetup button[itemId=resetBtnItemId]':{
						click:function(){
							var form = this.getAddHostelApplicationSetup();
							form.down('#applicationCancellationFromDate') && form.down('#applicationCancellationFromDate').setMaxValue(null);
							form.down('#applicationCancellationFromDate') && form.down('#applicationCancellationFromDate').setMinValue(null);
							form.down('#applicationCancellationToDate') && form.down('#applicationCancellationToDate').setMaxValue(null);
							form.down('#applicationCancellationToDate') && form.down('#applicationCancellationToDate').setMinValue(null);
							var setupId=this.getAddHostelApplicationSetup('#setupId');
							this.getAddHostelApplicationSetup().getForm().reset();
							this.getAddHostelApplicationSetup('#setupId').setValue(setupId);
						}
				},
				'addHostelApplicationSetup button[itemId=saveHostelSetup]':{
					click:this.saveHostelSetup
				},
				'addHostelApplicationSetup filefield[itemId=TC_Document]':{
					change:this.checkFileExtentionandSize
				},
				'addHostelApplicationSetup datefield[itemId=applicationStartDate]':{
					select :function(cmp,val){
						var form =this.getAddHostelApplicationSetup();
						form.down('#adminStartDate').isVisible() && form.down('#adminStartDate').setValue(new Date(val));
						form.down('#applicationCancellationFromDate') && form.down('#applicationCancellationFromDate').setMinValue(new Date(val));	
						form.down('#applicationCancellationFromDate') && form.down('#applicationCancellationFromDate').reset();
						form.down('#applicationCancellationToDate') && form.down('#applicationCancellationToDate').reset();
					}
				},
					'addHostelApplicationSetup datefield[itemId=applicationEndDate]':{
						select :function(cmp,val){
							var form =this.getAddHostelApplicationSetup();
							form.down('#adminEndDate').isVisible() && form.down('#adminEndDate').setValue(new Date(val));
							form.down('#applicationCancellationToDate') && form.down('#applicationCancellationToDate').setMaxValue(new Date(val));
							form.down('#applicationCancellationFromDate') && form.down('#applicationCancellationFromDate').reset();
							form.down('#applicationCancellationToDate') && form.down('#applicationCancellationToDate').reset();
						}
				},
				'hostelApplicationSetupGrid menuitem[itemId=btnApplyTo]':{
					click:this.openApplyToMapGrid
			},
			'hostelApplicationSetupMapProgramGrid button[itemId=btnAdd]':{
				click:this.openHostelApplicationSetupAddMappingTab
			},
			'hostelApplicationSetupMapProgramGrid button[itemId=btnView]':{
				click:this.hostelApplicationSetupAddMappingViews
			},
			'hostelApplicationSetupMapProgramGrid button[itemId=btnDelete]':{
				click:function(){
					var me = this,
					grid = me.getHostelApplicationSetupMapProgramGrid(),
					selectedRec= grid.getSelectionModel().getSelection()[0];
					showConfirmMessage(getMegaMenuTranslation('HOSTEL_APPLICATION_SETUP'), getCommonTranslation('DELETE_DOCUMENTS_CONFIRMATION_MSG'), function (cbtn, text) {
						if (cbtn == 'yes') {
							Ext.getBody().mask(getCommonTranslation('CANCEL'), 'x-mask-loading');
							Ext.Ajax.request({
								type : 'rest',
								async: false,
								method : 'DELETE',
								url : SERVERURL.PATH_DELETE_HOSTEL_APPLICATION_SETUP_MAPPING+'?id='+selectedRec.data.id,
								success: function(response, action) {
									showSuccessMessage(getMegaMenuTranslation('HOSTEL_APPLICATION_SETUP'),getCommonTranslation('SUCCESS'));
									grid.getStore().load();
									Ext.getBody().unmask()
								}
							});
						}
					})
					
				}
			},
			'hostelApplicationSetupMapProgramGrid':{
				selectionchange:function(cmp,selected){
					var me = this,
					grid = me.getHostelApplicationSetupMapProgramGrid(),
					deletebtn = grid.down('#btnDelete'),
					viewbtn = grid.down('#btnView');
					if(selected && selected.length>0){
						deletebtn.setDisabled(false);
						viewbtn.setDisabled(false);
					}else{
						deletebtn.setDisabled(true);
						viewbtn.setDisabled(true);
					}

				}
			},
			'hostelSetupAddMappingALGrid':{
				afterrender:function(cmp){
					var me =this,
					hostelApplicationSetupAddMappingStructure = me.getHostelApplicationSetupAddMappingStructure(),
					hostelApplicationSetupMapProgramGrid = me.getHostelApplicationSetupMapProgramGrid();
					cmp.getStore().clearFilter();
					cmp.getStore().load();
					hostelApplicationSetupAddMappingStructure.down('#lblHostelSetupnameAL').setValue(hostelApplicationSetupMapProgramGrid.hostelSetupRec.data.setupName);
					
				}
			},
			'hostelSetupAddMappingALGrid button[itemId=resetBtn]':{
				click:function(){
					var grid = this.getHostelSetupAddMappingALGrid();
					grid.getSelectionModel().deselectAll();
					grid.getStore().clearFilter();
	 				  if(grid.down('#academylocationsearchcombo')){
	 					 grid.down('#academylocationsearchcombo').reset();
	 				  }
				}
			},
			'hostelSetupAddMappingALGrid button[itemId=nextButton]':{
				click:function(){
					var grid = this.getHostelSetupAddMappingALGrid(),
					selectedRec= grid.getSelectionModel().getSelection(),
					academyLocationIdsArr = [];
				
					if(selectedRec && selectedRec.length){
						selectedRec.forEach(function(obj){
				    		academyLocationIdsArr.push(obj.get('id'));
				    	});
				    	var addmappingstructure = this.getHostelApplicationSetupAddMappingStructure(),
				    	hostelApplicationSetupMapProgramGrid = this.getHostelApplicationSetupMapProgramGrid(),
				    	hostelApplicationSetupAddMappingTab = this.getHostelSetupAddMappingProgramGrid(),
				    	structure = this.getHostelApplicationSetupAddMappingTab(),
				    	programcontainer = addmappingstructure.down('#programcontainer');
				    	programcontainer.setDisabled(false);
				    	addmappingstructure.setActiveTab(programcontainer);
				    	var alProgramGrid = this.getHostelSetupAddMappingProgramGrid();
				    	var alProgramSearchCombo = alProgramGrid.down('#programsearchcombo');
				    	alProgramSearchCombo.reset();
				    	alProgramSearchCombo.getStore().getProxy().extraParams= {
				    		academyLocationIds: academyLocationIdsArr.join()
				    	};
				    	//alProgramSearchCombo.getStore().load();
				    	var alProgramGridStore = alProgramGrid.getStore();
				    	alProgramGridStore.getProxy().extraParams= {
				    		academyLocationIds: academyLocationIdsArr.join()
				    	};
				    	alProgramGridStore.clearFilter();
				    	alProgramGridStore.load();
				    	this.setProgressTracker(1);
				    	var hostelSetupRec = hostelApplicationSetupMapProgramGrid.hostelSetupRec;
						if(!isNullOrEmpty(hostelSetupRec)){
							addmappingstructure.down("#lblHostelSetupnameProgramTab").setValue(hostelSetupRec.get('setupName'));
							structure.down('#HostelApplicationSetupName').setValue(hostelSetupRec.get('setupName'));
							structure.down('#HostelApplicationSetupId').setValue(hostelSetupRec.get('id'));
						}
			    	
					}else{
						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
	 		 'hostelSetupAddMappingProgramGrid button#nextButton':{
	 			  click:function(btn){
	 				 this.programNextEventHostelSetup(btn);
	 			  }
	 		  },
				'hostelSetupAddMappingProgramGrid button[itemId=resetBtn]':{
					click:function(){
						var grid = this.getHostelSetupAddMappingProgramGrid();
						grid.getSelectionModel().deselectAll();
						grid.getStore().clearFilter();
		 				  if(grid.down('#programsearchcombo')){
		 					 grid.down('#programsearchcombo').reset();
		 				  }
					}
				},
		 		 'hostelSetupAddMappingBatchGrid button#nextButton':{
		 			  click:function(btn){
		 				 this.batchNextEventHostelSetup(btn);
		 			  }
		 		  },
					'hostelSetupAddMappingBatchGrid button[itemId=resetBtn]':{
						click:function(){
							var grid = this.getHostelSetupAddMappingBatchGrid();
							grid.getSelectionModel().deselectAll();
							grid.getStore().clearFilter();
			 				  if(grid.down('#programbatchsearchcombo')){
			 					 grid.down('#programbatchsearchcombo').reset();
			 				  }
						}
					},
					'hostelSetupAddMappingSeatTypeGrid button[itemId=resetBtn]':{
						click:function(){
							var grid = this.getHostelSetupAddMappingSeatTypeGrid();
							grid.getSelectionModel().deselectAll();
							grid.getStore().clearFilter();
			 				  if(grid.down('#batchSeatType')){
			 					 grid.down('#batchSeatType').reset();
			 				  }
						}
					},
			   		 'hostelSetupAddMappingALGrid customcombobox#academylocationsearchcombo' : {
			   			 select:function(obj, record){
			   				 var academylocationgrid = this.getHostelSetupAddMappingALGrid();
			   				 academylocationgrid.getStore().clearFilter();
			   				 if(!isNullOrEmpty(record)){
			   					 academylocationgrid.getStore().filter({property: 'id',
			   						 value: record[0].get('id'),
			   						 exactMatch: true,
			   						 caseSensitive: true});
			   				 }
			   				var gridDom = academylocationgrid.el ? academylocationgrid.el.dom : null;
			 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ academylocationgrid.getStore().getCount();
			   			 }
			   		 },
			 		 'hostelSetupAddMappingProgramGrid customcombobox#programsearchcombo' : {
			 			 select:function(obj, record){
			 				 var grid = this.getHostelSetupAddMappingProgramGrid();
			 				grid.getStore().clearFilter();
			 				 if(!isNullOrEmpty(record)){
			 					grid.getStore().filter({
			 						property: 'programId',
			 						 value: record[0].get('id'),
			 						 exactMatch: true,
			 						 caseSensitive: true});
			 				 }
			 				var gridDom = grid.el ? grid.el.dom : null;
			 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ grid.getStore().getCount();
			 			 }
			 		 },
			 		 'hostelSetupAddMappingBatchGrid customcombobox#programbatchsearchcombo' : {
			 			 select:function(obj, record){
			 				 var grid = this.getHostelSetupAddMappingBatchGrid();
			 				grid.getStore().clearFilter();
			 				 if(!isNullOrEmpty(record)){
			 					grid.getStore().filter({property: 'batchId',
			 						 value: record[0].get('id'),
			 						 exactMatch: true,
			 						 caseSensitive: true});
			 				 }
			 				var gridDom = grid.el ? grid.el.dom : null;
			 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ grid.getStore().getCount();
			 			 }
			 		 },
			 		 'hostelSetupAddMappingSeatTypeGrid customcombobox#batchSeatType' : {
			 			 select:function(obj, record){
			 				 var grid = this.getHostelSetupAddMappingSeatTypeGrid();
			 				grid.getStore().clearFilter();
			 				 if(!isNullOrEmpty(record)){
			 					grid.getStore().filter({property: 'programBatchSeatTypeId',
			 						 value: record[0].get('programBatchSeatTypeId'),
			 						 exactMatch: true,
			 						 caseSensitive: true});
			 				 }
			 				var gridDom = grid.el ? grid.el.dom : null;
			 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ grid.getStore().getCount();
			 			 }
			 		 },
			 		 'hostelSetupAddMappingSeatTypeGrid button#submitFeeMapping' : {
			 			 click:function(btn){
			 				 this.submitMapHostelApplocationSetup(btn,'seatType')
			 			 }
			 		 },
			 		 'hostelSetupAddMappingBatchGrid button#submitFeeMapping' : {
			 			 click:function(btn){
			 				 this.submitMapHostelApplocationSetup(btn,'batchType')
			 			 }
			 		 },
			 		'addHostelApplicationSetup radiogroup[itemId=IsApplicationCancellationFromSP]':{
						change:function(obj, newValue, oldValue){
							var form = this.getAddHostelApplicationSetup(),
							applicationCancellationFromDate = form.down('#applicationCancellationFromDate'),
							applicationCancellationToDate = form.down('#applicationCancellationToDate');
			                if(newValue.IsApplicationCancellationFromSP){
			                	applicationCancellationFromDate && applicationCancellationFromDate.setVisible(true);
			                	applicationCancellationToDate && applicationCancellationToDate.setVisible(true);
			                	this.setAllowBlank (applicationCancellationFromDate,false);
			                	this.setAllowBlank (applicationCancellationToDate,false);
			                }else{
			                	applicationCancellationFromDate && applicationCancellationFromDate.setVisible(false);
			                	applicationCancellationToDate && applicationCancellationToDate.setVisible(false);
			                	applicationCancellationFromDate && applicationCancellationFromDate.reset();
			                	applicationCancellationToDate && applicationCancellationToDate.reset();
			                	this.setAllowBlank (applicationCancellationFromDate,true);
			                	this.setAllowBlank (applicationCancellationToDate,true);
			                }
			                form.doLayout();
			                form.getForm().checkValidity();
						}
					},
					'addHostelApplicationSetup datefield[itemId=adminStartDate]':{
						select :function(cmp,val){
							var form =this.getAddHostelApplicationSetup();
							form.down('#applicationCancellationFromDate') && form.down('#applicationCancellationFromDate').setMinValue(new Date(val));
							form.down('#applicationCancellationFromDate') && form.down('#applicationCancellationFromDate').reset();
							form.down('#applicationCancellationToDate') && form.down('#applicationCancellationToDate').reset();
						}
					},
					'addHostelApplicationSetup datefield[itemId=adminEndDate]':{
						select :function(cmp,val){
							var form =this.getAddHostelApplicationSetup();
							form.down('#applicationCancellationToDate') && form.down('#applicationCancellationToDate').setMaxValue(new Date(val));
							form.down('#applicationCancellationFromDate') && form.down('#applicationCancellationFromDate').reset();
							form.down('#applicationCancellationToDate') && form.down('#applicationCancellationToDate').reset();
						}
					}
			});
		},
		searchHostelApplicationSetup:function(btn){
			btn.setDisabled(true)
			var me = this,
			form = me.getHostelApplicationSetupFilter(),
			grid = me.getHostelApplicationSetupGrid(),
			formVal = form.getValues();
			grid.getStore().getProxy().extraParams={
				userType:formVal.userType,
				setupType:formVal.setupType,
				withoutMapping:formVal.setupWithoutMapping ? true:false,
				hostelApplicationSetupId:formVal.setupCodeName,
				status:formVal.status,
				academicTermId:formVal.accountTermId

			}
			grid.getStore().load();
			btn.setDisabled(false)
		},
		addEditHostelSetupForm:function(isView){
			var me = this,
			grid = me.getHostelApplicationSetupGrid(),
			selectedRec= grid.getSelectionModel().getSelection();
			var contentpanel = me.getContentPanel();

			var addHostelApplicationSetup = Ext.widget('addHostelApplicationSetupStructure'); 
			var tabName 

			if (isView == 'ADD') {      		
				tabName = getCommonTranslation('HOSTEL_SETUP');
			}
			else if (isView == 'VIEW') {
				tabName = getCommonTranslation('VIEW_HOSTEL_SETUP')

			} else if (isView== 'EDIT') {
				if(selectedRec && selectedRec[0]){
					addHostelApplicationSetup.down('#setupId').setValue(selectedRec[0].data.id);
				}
				tabName = getCommonTranslation('EDIT_HOSTEL_SETUP')
			} 

			var getcontroller=me.getController('menu.CoreERPNavigationController');
			var getAddTab=getcontroller.getTab(getCommonTranslation('HOSTEL_SETUP'));
			var getEditTab = getcontroller.getTab(getCommonTranslation('EDIT_HOSTEL_SETUP'));
			var getViewTab = getcontroller.getTab(getCommonTranslation('VIEW_HOSTEL_SETUP'));
			if(getAddTab!=null){
				contentpanel.remove(getAddTab, true);
			}
			if (getEditTab != null) {
				contentPanel.remove(getEditTab, true);
			}
			if (getViewTab != null) {
				contentPanel.remove(getViewTab, true);
			}
			openTab(contentpanel, tabName, addHostelApplicationSetup,CONSTANTS.MENU_COLOR_FIVE); 
			if (isView== 'EDIT' || isView== 'VIEW') {
				me.setHostelSetupValue(isView,selectedRec[0]);
			}
		},
		deleteHostelSetup:function(){
			var me = this,
			grid = me.getHostelApplicationSetupGrid(),
			selectedRec= grid.getSelectionModel().getSelection()[0];
			showConfirmMessage(getMegaMenuTranslation('HOSTEL_APPLICATION_SETUP'), getCommonTranslation('DELETE_DOCUMENTS_CONFIRMATION_MSG'), function (cbtn, text) {
				Ext.getBody().mask(getCommonTranslation('CANCEL'), 'x-mask-loading');
				if (cbtn == 'yes') {
					Ext.Ajax.request({
						type : 'rest',
						async: false,
						method : 'DELETE',
						url : SERVERURL.PATH_DELETE_HOSTEL_APPLICATION_SETUP+'?id='+selectedRec.data.id+'&userType='+ selectedRec.data.userType,
						success: function(response, action) {
							showSuccessMessage(getMegaMenuTranslation('HOSTEL_APPLICATION_SETUP'),getCommonTranslation('SUCCESS'));
							grid.getStore().load();
							Ext.getBody().unmask()
						}
					});
				}
			});
	},
	saveHostelSetup:function(btn){
		btn.setDisabled(true);
		var me = this,fileFld,
		form = me.getAddHostelApplicationSetup(),
		contentPanel = me.getActiveTabfromContentPanel(),
		filterForm = me.getHostelApplicationSetupFilter(),
		grid = me.getHostelApplicationSetupGrid(),
		fileField = form.down('#TC_Document');
		if(fileField){
			fileFld=fileField.fileInputEl.dom;
		}
		
    	formVal = form.getValues();
		var params = me.createJsonData(formVal);
		var apiUrl = SERVERURL.PATH_SAVE_HOSTEL_APPLICATION_SETUP;
		if(formVal.setupId){
			params.id = formVal.setupId;
			var apiUrl = SERVERURL.PATH_UPDATE_HOSTEL_APPLICATION_SETUP;
		}
		
		
		if(fileFld && fileFld.files.length){
			
			fileField.up('form').getForm().submit({
    			type: 'rest',
    			url: SERVERURL.DOCUMENT_FILE_ADD,
    			method : 'POST',
    			success: function(f, action) {
    				var data=Ext.decode(action.response.responseText);
    				params.documentPath=data.path;
    				me.saveHostelSetupData(params,apiUrl,btn);
    			}
    		});
		}else{
		me.saveHostelSetupData(params,apiUrl,btn)
		}
		
	},
	createJsonData:function(formVal){
		var me = this;
		if(formVal == 'STUDENT'){
			var params = {
				    "userType":formVal.userType,
				    "setupName":formVal.setupName,
				    "setupCode":formVal.setupCode,
				    "applicationStartDate":formVal.applicationStartDate,
				    "applicationEndDate":formVal.applicationEndDate,
				    "hostelSetupType":formVal.hostelSetupType,
				    "academyLocation":{
				        "id":me.getCurrentAcademyLocation()
				    },
				    "year":{
				        "id":formVal.accountTermId
				    },
				    "applicationDroolRule":formVal.applicationDroolRule,
				    "adminStartDate":formVal.adminStartDate,
				    "adminEndDate":formVal.adminEndDate,
				    "status":formVal.status,
				    "isApplicationCancellationFromSP":formVal.IsApplicationCancellationFromSP,
				    "applicationCancellationFromDate": formVal.applicationCancellationFromDate,
				    "applicationCancellationToDate": formVal.applicationCancellationToDate
			}
		}else{
			var params = {
				    "userType":formVal.userType,
				    "setupName":formVal.setupName,
				    "setupCode":formVal.setupCode,
				    "applicationStartDate":formVal.applicationStartDate,
				    "applicationEndDate":formVal.applicationEndDate,
				    "hostelSetupType":formVal.hostelSetupType,
				    "academyLocation":{
				        "id":me.getCurrentAcademyLocation()
				    },
				    "year":{
				        "id":formVal.accountTermId
				    },
				    "applicationDroolRule":formVal.applicationDroolRule,
				    "adminStartDate":formVal.adminStartDate,
				    "adminEndDate":formVal.adminEndDate,
				    "status":formVal.status,
				    "offerApplicable":formVal.offerApplicable,
				    "offerLetterStartDate":formVal.offerLetterStartDate,
				    "offerLetterEndDate":formVal.offerLetterEndDate,
				    "maxDaysToAcceptOffer":formVal.maxDaysToAcceptOffer,
				    "notificationBeforeOfferExpires":formVal.notificationBeforeOfferExpires,
				    "isApplicationCancellationFromSP":formVal.IsApplicationCancellationFromSP,
				    "applicationCancellationFromDate": formVal.applicationCancellationFromDate,
				    "applicationCancellationToDate": formVal.applicationCancellationToDate
			}
		};
		return params;
	},
	setHostelSetupValue:function(isView,records){
		var me = this,
		form = me.getAddHostelApplicationSetup();
		Ext.getBody().mask(getCommonTranslation('CANCEL'), 'x-mask-loading');
		Ext.Ajax.request({
			type : 'rest',
			async: false,
			method : 'GET',
			params:{
				id:records.data.id
			},
			url : SERVERURL.PATH_FIND_BY_ID_HOSTEL_APPLICATION_SETUP,
			success: function(response, action) {
				
				if(response.responseText){
					var recData = Ext.decode(response.responseText);
					form.getForm().setValues(recData);
					form.down('#applicationStartDate').setValue(new Date(recData.applicationStartDate));
					form.down('#applicationEndDate').setValue(new Date(recData.applicationEndDate));
					form.down('#adminStartDate').setValue(new Date(recData.adminStartDate));
					form.down('#adminEndDate').setValue(new Date(recData.adminEndDate));
					recData.offerLetterStartDate &&	form.down('#offerLetterStartDate').setValue(new Date(recData.offerLetterStartDate));
					recData.offerLetterEndDate && form.down('#offerLetterEndDate').setValue(new Date(recData.offerLetterEndDate));
					recData.maxDaysToAcceptOffer && form.down('#maxDaysToAcceptOffer').setValue(recData.maxDaysToAcceptOffer);
					recData.notificationBeforeOfferExpires && form.down('#notificationBeforeOfferExpires').setValue(recData.notificationBeforeOfferExpires);
					recData.offerApplicable && form.down('#offerApplicable').setValue(recData.offerApplicable);
					recData.documentPath && form.down('#TC_Document').setRawValue(recData.documentPath);
					form.down('#accountTermId').getStore().load({
          			callback: function(records, operation, success) {
          					form.down('#accountTermId').setValue(recData.year.id);
						}});
					form.down('#userType').setReadOnly(true);
					form.down('#hostelSetupType').setReadOnly(true);
					form.down('#setupCode').setReadOnly(true);
					form.down('#accountTermId').setReadOnly(true);
					form.down('#offerApplicable').setReadOnly(true);
					recData.isApplicationCancellationFromSP && form.down('#IsApplicationCancellationFromSP').setValue({IsApplicationCancellationFromSP:recData.isApplicationCancellationFromSP});
					recData.applicationCancellationFromDate && form.down('#applicationCancellationFromDate').setValue(new Date(recData.applicationCancellationFromDate));
					recData.applicationCancellationToDate && form.down('#applicationCancellationToDate').setValue(new Date(recData.applicationCancellationToDate));
					
					recData.adminStartDate && form.down('#applicationCancellationFromDate').setMinValue(new Date(recData.adminStartDate));
					recData.adminEndDate && form.down('#applicationCancellationToDate').setMaxValue(new Date(recData.adminEndDate));
					
					if(recData.userType=='APPLICANT'){
						form.down('#IsApplicationCancellationFromSP').setVisible(false);
						form.down('#applicationCancellationFromDate').setVisible(false);
						form.down('#applicationCancellationToDate').setVisible(false);
						me.setAllowBlank(form.down('#applicationCancellationFromDate'),true);
						me.setAllowBlank(form.down('#applicationCancellationToDate'),true);
					}
					
					if(isView == 'VIEW'){
						form.getForm().getFields().items.forEach(function(rec){
							rec.setReadOnly(true);
						});
						form.down('#saveHostelSetup').setVisible(false);
						
						form.down('#TC_Document').setDisabled(true)
					}
					form.down('#resetBtnItemId').setVisible(false);
					form.down('#cancelBtnItemId').setVisible(true);
					Ext.defer(function(){
						form.down('#status').setValue(recData.status);
					},300)
				}
				Ext.getBody().unmask();
				
			}
		});
		
	},
	checkFileExtentionandSize:function(fileField){
		var me = this;
    	value = fileField.getValue().replace('C:\\fakepath\\', '');
    	var newValue = value.replace(/ +/g, " ").split(' ').join('_');
    	fileField.setRawValue(newValue);
    	if (!isNullOrEmpty(newValue)) {
    	    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
    	    if (me.isValidProfileImageExtensionReAddmission(extension)) {
    	        var file = fileField.fileInputEl.dom.files[0];
    	        if (file.size / 1048576 > 2) {
    	            fileField.reset();
    	            showWarningMessage(getPersonModuleTranslation('ALERT'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
    	        }
    	    } else {
    	    	 fileField.reset();
    	        showWarningMessage(getPersonModuleTranslation('ALERT'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
    	    }
    	}
	},
	saveHostelSetupData:function(record,apiUrl,btn){
		var me = this,
		contentPanel = me.getActiveTabfromContentPanel(),
		form = me.getAddHostelApplicationSetup(),
		filterForm = me.getHostelApplicationSetupFilter();
		var data= Ext.encode(record);
		Ext.getBody().mask(getCommonTranslation('CANCEL'), 'x-mask-loading');
		Ext.Ajax.request({
			type : 'rest',
			async: false,
			jsonData:data,
			method : 'POST',
			url : apiUrl,
			success: function(response, action) {
				Ext.getBody().unmask()
				if(record.id){
					showSuccessMessage(getMegaMenuTranslation('HOSTEL_APPLICATION_SETUP'),getCommonTranslation('HOSTEL_APPLICATION_UPDATED_SUCCESSFULLY'));
				}else{
					showSuccessMessage(getMegaMenuTranslation('HOSTEL_APPLICATION_SETUP'),getCommonTranslation('HOSTEL_APPLICATION_SETUP_CREATED_SUCCESSFULLY'));
				}
				
				filterForm.down('#searchHostelSetup').fireEvent('click',filterForm.down('#searchHostelSetup'));
				contentPanel.close();
				
			},
			failure:function(response, action){
				btn.setDisabled(false);
				form.isValid();
			}
		});
	},
	openApplyToMapGrid:function(){
		var me = this,
		grid = me.getHostelApplicationSetupGrid(),
		selectedRec= grid.getSelectionModel().getSelection();
		if(selectedRec.length){
		 var mapView = Ext.widget('hostelApplicationSetupMapProgramStructure'),
			 contentpanel = me.getContentPanel(),
			 tabName = getCommonTranslation('APPLY_TO'),
			 getcontroller=me.getController('menu.CoreERPNavigationController'),
			 getTab=getcontroller.getTab(tabName),
			 applyToGrid = mapView.query('hostelApplicationSetupMapProgramGrid')[0];
		if(getTab!=null){
				contentpanel.remove(getTab, true);
			}
		applyToGrid.hostelSetupRec = selectedRec[0];
		openTab(contentpanel, tabName, mapView,CONSTANTS.MENU_COLOR_SEVEN);
		applyToGrid.getStore().getProxy().extraParams={
			hostelApplicationSetupId: parseInt(selectedRec[0].get('id'))
		};
		applyToGrid.getStore().load();
		}else{
			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	openHostelApplicationSetupAddMappingTab:function(){
		var me = this,
		hostelApplicationSetupAddMappingTab = Ext.widget('hostelApplicationSetupAddMappingTab'),
		 contentpanel = me.getContentPanel(),
		 tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING'),
		 getcontroller=me.getController('menu.CoreERPNavigationController'),
		 getTab=getcontroller.getTab(tabName);
		if(getTab!=null){
				contentpanel.remove(getTab, true);
			}
		openTab(contentpanel, tabName, hostelApplicationSetupAddMappingTab,CONSTANTS.MENU_COLOR_SEVEN);
	},
	hostelApplicationSetupAddMappingViews:function(){
		var me = this,
		grid = me.getHostelApplicationSetupMapProgramGrid(),
		selectedRec= grid.getSelectionModel().getSelection()[0],
		hostelApplicationSetupApplyToView = Ext.widget('hostelApplicationSetupApplyToView');
		hostelApplicationSetupApplyToView.show();
		hostelApplicationSetupApplyToView.down("#setupCode").setValue(grid.hostelSetupRec.data.setupCode);
		hostelApplicationSetupApplyToView.down("#setupName").setValue(grid.hostelSetupRec.data.setupName);
		hostelApplicationSetupApplyToView.down("#academyLocationAL").setValue(selectedRec.data.academyName);
		hostelApplicationSetupApplyToView.down("#programAL").setValue(selectedRec.data.programCode+'/'+selectedRec.data.programName);
		hostelApplicationSetupApplyToView.down("#batchAL").setValue(selectedRec.data.batchName);
		hostelApplicationSetupApplyToView.down("#seatName").setValue(selectedRec.data.seatTypeName);
	},
	setProgressTracker : function(progresstracker){
    	var structure = this.getHostelApplicationSetupAddMappingTab();
    	var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");

    	var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
    	var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
    	var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");
    	var progresstracker4 = adjustmentprogresstracker.down("#progresstracker4");
    	var progresstracker5 = adjustmentprogresstracker.down("#progresstracker5");

    	if(progresstracker==1){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker1.updateProgress((i * 0.1), '');
    		}
    		progresstracker1.textEl.addCls("custom-progress-text");
    		progresstracker1.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker2.textEl.removeCls("x-progress-text x-progress-text-back");
    		progresstracker2.textEl.addCls("inProgressCss-progress-text");
    		progresstracker2.updateText("Step 2 In Progress");
    		progresstracker1.updateText(getCommonTranslation('STEP_1_COMPLETE'));
    	}
    	if(progresstracker==2){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker2.updateProgress((i * 0.1), '');
    		}
    		progresstracker2.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker2.textEl.addCls("custom-progress-text");
    		progresstracker3.textEl.removeCls("x-progress-text x-progress-text-back");
    		progresstracker3.textEl.addCls("inProgressCss-progress-text");
    		progresstracker3.updateText("Step 3 In Progress");
    		progresstracker2.updateText(getCommonTranslation('STEP_2_COMPLETE'));
    	}
    	if(progresstracker==3){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker3.updateProgress((i * 0.1), '');
    		}
    		progresstracker3.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker3.textEl.addCls("custom-progress-text");
    		progresstracker4.textEl.removeCls("x-progress-text x-progress-text-back");
    		progresstracker4.textEl.addCls("inProgressCss-progress-text");
    		progresstracker4.updateText("Step 4 In Progress");
    		progresstracker3.updateText(getCommonTranslation('STEP_3_COMPLETE'));
    	}
    	if(progresstracker==4){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker4.updateProgress((i * 0.1), '');
    		}
    		progresstracker4.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker4.textEl.addCls("custom-progress-text");
    		progresstracker5.textEl.removeCls("x-progress-text x-progress-text-back");
    		progresstracker5.textEl.addCls("inProgressCss-progress-text");
    		progresstracker5.updateText("Step 5 In Progress");
    		progresstracker4.updateText(getCommonTranslation('STEP_4_COMPLETE'));
    	}
    	if(progresstracker==5){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker5.updateProgress((i * 0.1), '');
    		}
    		progresstracker5.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker5.textEl.addCls("custom-progress-text");
    		progresstracker5.updateText(getCommonTranslation('STEP_5_COMPLETE'));
    	}
    },
    programNextEventHostelSetup:function(btn){
	var me = this,programcontainer,
    	alprogramgrid =btn.up('grid'),
    	 selectionModel = alprogramgrid.getSelectionModel().getSelection(),
    	 alprogramgridIdsArr = [],
    	 programId=[];
    	selectionModel.forEach(function(obj){
    		alprogramgridIdsArr.push(obj.get('academyLocationId'));
    		programId.push(obj.get('programId'))
    	});
    	
    	if(selectionModel.length > 0){
    		var addmappingstructure = this.getHostelApplicationSetupAddMappingStructure(),
	    	hostelApplicationSetupMapProgramGrid = this.getHostelApplicationSetupMapProgramGrid(),
	    	hostelSetupAddMappingBatchGrid = this.getHostelSetupAddMappingBatchGrid(),
	    	programcontainer = addmappingstructure.down('#programbatchcontainer');
	    	programcontainer.setDisabled(false);
	    	addmappingstructure.setActiveTab(programcontainer);
	    	var alprogramgrid = hostelSetupAddMappingBatchGrid;
	    	var alprogramgridCombo = hostelSetupAddMappingBatchGrid.down('#programbatchsearchcombo');
	    	alprogramgridCombo.getStore().getProxy().extraParams= {
		    		academyLocationIds: alprogramgridIdsArr.join(),
		    		programIds:programId.join()
	    		};
	    	
	    	var alprogramgridStore = alprogramgrid.getStore();
	    	var  proxy = alprogramgridStore.getProxy();
			var  newApi =  {read: SERVERURL.FIND_PROGRAM_BATCH_AND_ACADEMY_LOCATION, update: SERVERURL.FIND_PROGRAM_BATCH_AND_ACADEMY_LOCATION };
			Ext.apply(proxy.api,newApi);
			proxy.extraParams= {
					academyLocationIds: alprogramgridIdsArr.join(),
		    		programIds:programId.join(),
	    	};
			alprogramgridStore.clearFilter();
			alprogramgridStore.load();
			var hostelSetupRec = hostelApplicationSetupMapProgramGrid.hostelSetupRec;
			if(!isNullOrEmpty(hostelSetupRec)){
				addmappingstructure.down("#lblHostelSetupProgramBatchTab").setValue(hostelSetupRec.get('setupName'));
			}
	    	this.setProgressTracker(3);
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    
    },
    batchNextEventHostelSetup:function(btn){
    	var me = this,programcontainer,
    	alprogramgrid =btn.up('grid'),
    	 selectionModel = alprogramgrid.getSelectionModel().getSelection(),
    	 alprogramgridIdsArr = [],
    	 programId=[],
    	 batchId=[];
    	selectionModel.forEach(function(obj){
    		alprogramgridIdsArr.push(obj.get('academyLocationId'));
    		programId.push(obj.get('programId'));
    		batchId.push(obj.get('batchId'));
    	});
    	
    	if(selectionModel.length > 0){
    		var addmappingstructure = this.getHostelApplicationSetupAddMappingStructure(),
	    	hostelApplicationSetupMapProgramGrid = this.getHostelApplicationSetupMapProgramGrid(),
	    	hostelSetupAddMappingSeatTypeGrid = this.getHostelSetupAddMappingSeatTypeGrid(),
	    	programcontainer = addmappingstructure.down('#programbatchSeatTypecontainer');
	    	programcontainer.setDisabled(false);
	    	addmappingstructure.setActiveTab(programcontainer);
	    	
	    	var alprogramgrid = me.getHostelSetupAddMappingSeatTypeGrid();
	    	var alprogramgridCombo = alprogramgrid.down('#batchSeatType');
		  	alprogramgridCombo.getStore().getProxy().extraParams= {
			  		academyLocationIds: alprogramgridIdsArr.join(),
		    		programIds:programId.join(),
		    		batchIds:batchId.join()
		    	};
	    	var alprogramgridStore = alprogramgrid.getStore();
	    	var  proxy = alprogramgridStore.getProxy();
			var  newApi =  {read: SERVERURL.FIND_BY_PROGRAM_BATCH_SEAT_TYPE_AND_ACADEMY_LOCATION, update: SERVERURL.FIND_BY_PROGRAM_BATCH_SEAT_TYPE_AND_ACADEMY_LOCATION };
			Ext.apply(proxy.api,newApi);
			proxy.extraParams= {
				academyLocationIds: alprogramgridIdsArr.join(),
	    		programIds:programId.join(),
	    		batchIds:batchId.join()
	    	};
			alprogramgridStore.clearFilter();
			alprogramgridStore.load();
			var hostelSetupRec = hostelApplicationSetupMapProgramGrid.hostelSetupRec;
			if(!isNullOrEmpty(hostelSetupRec)){
				
				addmappingstructure.down("#lblHostelSetupProgramBatchPeriodTab").setValue(hostelSetupRec.get('setupName'));
			}
	    	this.setProgressTracker(4,addmappingstructure);
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    submitMapHostelApplocationSetup:function(btn, type){
		  var $this = this,params=[],
		   submitUrl = SERVERURL.PATH_SAVE_HOSTEL_APPLICATION_SETUP_MAPPING_BATCH_TYPE,
	       batchGrid = $this.getHostelSetupAddMappingBatchGrid(),
	       seatTypeGrid = $this.getHostelSetupAddMappingSeatTypeGrid(),
	       selectedRecord = batchGrid.getSelectionModel().getSelection(),
	       hostelApplicationSetupAddMappingTab = $this.getHostelApplicationSetupAddMappingTab(),
	  	   contentPanel = $this.getContentPanel(),
	  	 HostelApplicationSetupAddMappingStructure = $this.getHostelApplicationSetupAddMappingStructure();
	       getcontroller = $this.getController('menu.CoreERPNavigationController'),
	       applyToGrid = $this.getHostelApplicationSetupMapProgramGrid(),
	       HostelApplicationSetupId = hostelApplicationSetupAddMappingTab.down('#HostelApplicationSetupId').getValue(),
	       hostelSetupRec = applyToGrid.hostelSetupRec;
		  if(type == "seatType"){
			  selectedRecord = seatTypeGrid.getSelectionModel().getSelection();
			  submitUrl = SERVERURL.PATH_SAVE_HOSTEL_APPLICATION_SETUP_MAPPING_SEAT_TYPE
		  }
		  if(HostelApplicationSetupId){
			  HostelApplicationSetupId = parseInt(HostelApplicationSetupId);
		  }
		  if(selectedRecord.length>0){
			  if(type == "seatType"){
				  selectedRecord.forEach(function(rec){
				  params.push({
					  "progBatchSeatConfig": {
				            "id": rec.get('programBatchSeatTypeId')
				        },
					   "batch":{
			              id:rec.get('batchId')
			          },
			          "hostelApplicationSetupId":HostelApplicationSetupId,
			          "academyLocation" : {
			              "id":rec.get('academyLocationId')
			          }, 
			          "program" : {
			              "id":rec.get('programId')
			          }
			      })
			  })
			  }else{
				  selectedRecord.forEach(function(rec){
				  params.push({
    					  "batch":{
    			              id:rec.get('batchId')
    			          },
    			          "hostelApplicationSetupId":HostelApplicationSetupId,
    			          "academyLocation" : {
    			              "id":rec.get('academyLocationId')
    			          },
    			          
    			          "program" : {
    			              "id":rec.get('programId')
    			          }
			      });
			  });
			  }
			 
	    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	    		Ext.Ajax.request({
	    			method: "POST",
	    			type: 'rest',
	    			url: submitUrl,
	    			jsonData:Ext.encode(params),
	    			success : function(response, action) {
	    				if(response.responseText == "SUCCESS"){
	    					Ext.getBody().unmask();
	    					showSuccessMessage(getMegaMenuTranslation('HOSTEL_APPLICATION_SETUP'),getExaminationTranslation('MAPPED_SUCCESSFULLY'))
	    					var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
		    				var getTab=getcontroller.getTab(tabName);
		    				if(getTab!=null){
		    					contentPanel.remove(getTab, true);
		    				}
		    				var hostelApplicationSetupMapProgramGrid = applyToGrid.getStore();
		    				if(!isNullOrEmpty(HostelApplicationSetupId)){
		    					hostelApplicationSetupMapProgramGrid.getProxy().extraParams={
		    						hostelApplicationSetupId: HostelApplicationSetupId
		    					};
		    				}
		    				hostelApplicationSetupMapProgramGrid.load();
	    				}else{
	    					Ext.getBody().unmask();
	    					alertWin = Ext.widget('duplicatHostelMapWin');
		          				alertWin.down('#hostelSetupAlert').setValue(getMegaMenuTranslation('HOSTEL_APPLICATION_SETUP')+' '+getCommonTranslation('ALREADY_MAPPED'));
		          				var pnlListMappingFld = alertWin.down('#hostelSetupId');
		          				var htmlData = '';
		          						htmlData = htmlData + '<div style="padding-bottom: 3px;">' +response.responseText + '</div>';
		          					
		          					pnlListMappingFld.html = htmlData;
		          				
		          					var btn = alertWin.down('#hostelSetupIdAlertBtnOk');
		              				btn.on('click', function() {
		              					alertWin.close();
		              				})
		          				alertWin.show();
	    				}
	    			}
	    		});
	    	} else {
	    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	    	}
  }
});
