/*
 *  @author Dharmendra.prajapati
 * 
 */
Ext.define('Academia.controller.hostel.roomallocation.RoomAllocationStructureController', {
	extend : 'Academia.controller.base.BaseController',
	
	models : [],
	
	stores : ['hostel.manageroomtype.RoomType','hostel.managehostel.hostel.RestrictionType','attendance.UserGroup',
	          'hostel.managehostel.hostel.HostelCodeName','user.UserAcademyLocationStore','hostel.managehostel.floor.RoomCodeName',
	          'hostel.managehostel.floor.FloorCodeName','hostel.managehostel.building.BuildingCodeName','hostel.managehostel.room.RoomDetailsStatus',
	          'hostel.roomallocation.UserSmartSearchByUserType','hostel.roomallocation.userwise.UserWiseList',
	          'criteriabuilder.userquicksearch.QuickSearchName','hostel.roomallocation.userwise.CancelAllotmentList',
	          'hostel.roomallocation.userwise.CancellationReasonCombo','hostel.roomallocation.userwise.BedNoCombo',
	          'hostel.roomallocation.userwise.CheckOutReasonCombo','hostel.roomallocation.userwise.OccupiedBedsGridS',
	          'hostel.roomallocation.userwise.AvailableBedsGridS','hostel.roomallocation.UserSmartSearchForOccupant','importutility.ModuleName','hostel.importhostel.ImportHostelAllocation',
	          'hostel.roomallocation.AdmissionByStudentIdStore'
	          ],
	          
	views : ['hostel.roomallocation.HostelRoomAllocationStructure',/*'hostel.roomallocation.RoomAllocationSearchStructure',*/
	         'hostel.roomallocation.userwise.UserWiseSearch','hostel.roomallocation.roomwise.RoomWiseSearch',
	         'hostel.roomallocation.userwise.UserWiseList','hostel.roomallocation.roomwise.RoomWiseList',
	         'hostel.roomallocation.userwise.UserAllotRoomWin','hostel.roomallocation.userwise.CancelAllotmentWin',
	         'hostel.roomallocation.userwise.CancelAllotmentList','hostel.roomallocation.userwise.CheckInWin',
	         'hostel.roomallocation.userwise.CheckOutWin','hostel.roomallocation.userwise.OccupiedBedDetailsWin',
	         'hostel.roomallocation.userwise.OccupiedBedsGrid','hostel.roomallocation.userwise.AvailableBedDetailsWin',
	         'hostel.roomallocation.userwise.AvailableBedDetailsGrid', 'hostel.roomallocation.userwise.AllottedDetailsGrid',
	         'hostel.roomallocation.userwise.AllottedDetailsWin','hostel.roomallocation.ImportRoomAllocation',
	         'hostel.roomallocation.ImportRoomAllocationList','hostel.roomallocation.DownloadHostelRoomAllocation',
	         'hostel.roomallocation.ImportHostelRoomAllocationForm','UploadOptionRadioGroup','hostel.roomallocation.ImportHostelRoomAllotmentLoaderGrid',
	         'hostel.roomallocation.ImportHostelRoomAllotmentLoader','hostel.roomallocation.ImportHostelRoomAllotmentUploadForm','hostel.roomallocation.ImportHostelRoomAllotmentDownloadForm'
	         ],	           
               
	         refs :[/*{
	        	 ref: 'roomallocationsearchstructure',
	        	 selector: 'roomallocationsearchstructure'
	         },*/{
	        	 ref: 'hostelroomallocationstructure',
	        	 selector: 'hostelroomallocationstructure'
	         },{
	        	 ref: 'userwisesearch',
	        	 selector:'userwisesearch'
	         },{
	        	 ref: 'userwiselist',
	        	 selector: 'userwiselist'
	         },{
	        	 ref: 'roomwisesearch',
	        	 selector:'roomwisesearch'
	         },{
	        	 ref: 'roomwiselist',
	        	 selector: 'roomwiselist'
	         },{
	        	 ref: 'userallotroomwin',
	        	 selector: 'userallotroomwin'
	         },{
	        	 ref: 'userAllotroomwin',
	        	 selector: 'userallotroomwin form'
	         },{
	        	 ref: 'cancelallotmentwin',
	        	 selector: 'cancelallotmentwin'
	         },{
	        	 ref: 'cancelAllotmentwin',
	        	 selector: 'cancelallotmentwin form'
	         },{
	        	 ref: 'checkinwin',
	        	 selector: 'checkinwin'
	         },{
	        	 ref: 'checkInwin',
	        	 selector: 'checkinwin form'
	         },{
	        	 ref: 'checkoutwin',
	        	 selector: 'checkoutwin'
	         },{
	        	 ref: 'checkoutwin',
	        	 selector: 'checkoutwin form'
	         },{
	        	 ref: 'occupiedbeddetailswin',
	        	 selector: 'occupiedbeddetailswin'
	         },{
	        	 ref: 'occupiedbedsgrid',
	        	 selector: 'occupiedbedsgrid'
	         },{
	        	 ref: 'occupiedbeddetailswin',
	        	 selector: 'occupiedbeddetailswin'
	         },{
	        	 ref: 'availablebeddetailswin',
	        	 selector: 'availablebeddetailswin'
	         },{
	        	 ref: 'availableBeddetailswin',
	        	 selector: 'availablebeddetailswin form'
	         },{
	        	 ref: 'availablebeddetailsgrid',
	        	 selector: 'availablebeddetailsgrid'
	         },{
	        	 ref: 'allottedDetailsGrid',
	        	 selector: 'allottedDetailsGrid'
	         },{
	        	 ref: 'allottedDetailsWin',
	        	 selector: 'allottedDetailsWin'
	         },{
	        	 ref: 'cancelallotmentlist',
	        	 selector: 'cancelallotmentlist[itemId=cancelallotmentlist]'
	         },{
	        	 ref: 'checkinlist',
	        	 selector: 'cancelallotmentlist[itemId=checkinwinListItemId]'
	         },{
	        	 ref: 'checkoutlist',
	        	 selector: 'cancelallotmentlist[itemId=checkoutwinListItemId]'
	         },{
	        	 ref: 'importroomallocation',
	        	 selector: 'importroomallocation'
	         },{
	        	 ref: 'importroomallocationlist',
	        	 selector: 'importroomallocationlist'
	         },{
	        	 ref: 'downloadhostelroomallocation',
	        	 selector: 'downloadhostelroomallocation'
	         },{
	        	 ref: 'importhostelroomallocationform',
	        	 selector: 'importhostelroomallocationform'
	         },{
	        	 ref : 'uploadoptionradiogroup',
	        	 selector : 'uploadoptionradiogroup[itemId=hostelCheckInUploadOptionRadioGroupItemId]'
	         },{
	        	 ref : 'importhostelroomallotmentloader',
	        	 selector : 'importhostelroomallotmentloader'
	         },{
	        	 ref : 'importhostelroomallotmentdownloadform',
	        	 selector : 'importhostelroomallotmentdownloadform'
	         },{
	        	 ref : 'importhostelroomallotmentuploadform',
	        	 selector : 'importhostelroomallotmentuploadform'
	         },{
	        	 ref : 'importhostelroomallotmentloadergrid',
	        	 selector : 'importhostelroomallotmentloadergrid'
	         }],
	         config: {
		         	HOSTEL_ROOM_ALLOCATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('HOSTEL_ROOM_ALLOCATION_PRIVILEGES'),
		        	CORE_ERP_LOADER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_LOADER_PRIVILEGES')
	         },
	init : function() {
		this.control({
			'hostelroomallocationstructure radiogroup[itemId=allocationType]':{
				change:function(obj,record){
					this.onChaneAllocationType(obj,record);
				}
			},
			'hostelroomallocationstructure userwiselist[itemId=userwiselist]':{
				render:function(grid){
					this.doAccessControlValidation(grid, this.getHOSTEL_ROOM_ALLOCATION_PERMISSIONS());
					this.doAccessControlCustomBtnValidation(grid, this.getHOSTEL_ROOM_ALLOCATION_PERMISSIONS());
					var btnExportToPDF = grid.down('#btnExportToPDF');
					btnExportToPDF.setDisabled(true);
					var btnExportToExcel = grid.down('#btnExportToExcel');
					btnExportToExcel.setDisabled(true);
					var exportPDFCurrentPage = grid.down('#exportPDFCurrentPage');
					exportPDFCurrentPage.setDisabled(true);
					var exportExcelCurrentPage = grid.down('#exportExcelCurrentPage');
					exportExcelCurrentPage.setDisabled(true);
					var exportPDFAll = grid.down('#exportPDFAll');
	        		exportPDFAll.setDisabled(true);
	        		var exportExcelAll = grid.down('#exportExcelAll');
	        		exportExcelAll.setDisabled(true);
				}
			},
			
			'hostelroomallocationstructure roomwiselist[itemId=roomwiselist]':{
				render:function(grid){
					this.doAccessControlValidation(grid, this.getHOSTEL_ROOM_ALLOCATION_PERMISSIONS());
					this.doAccessControlCustomBtnValidation(grid, this.getHOSTEL_ROOM_ALLOCATION_PERMISSIONS());
				}
			},
			
			'hostelroomallocationstructure':{
				 afterrender : function(structure){
					 var $this = this;
					 structure.body.on('scroll', function(e, target) {
		   				  var pcstructure = structure.down("userwiselist");
		   				  var academyLocationId = $this.getCurrentAcademyLocation();
		   				  var grid = null;
		   				  
		   				  if(!pcstructure.isHidden()){
		   					  grid = pcstructure;
		   				  }
		   				  $this.getMultipleGridHeaderFreeze(grid,structure,true);
		   				  
		   				  
						 });
				 }
			},
			'userwiselist button[itemId=btnAllotRoom]':{
				click:function(){
					var grid = this.getUserwiselist();
					if (grid.getSelectionModel().getCount() > 0) {
						var records = grid.getSelectionModel().getSelection()[0];  
						if(!isNullOrEmpty(records.data.noOfAvailableBeds) && records.data.noOfAvailableBeds > 0){
							this.showAllotRoomWin(grid);
						}else{
							showWarningMessage(getCommonTranslation('ALERT'),getHostelTranslation('BEDS_AVAILABILITY'));
						}
					}else{
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
			'userallotroomwin':{
				render:function(win){
					var $this =this;
					var userWiseSearch = this.getUserwisesearch().getForm();
			    	var userWiseValues = userWiseSearch.getValues();
			    	var roomAllotAdmissionCodeId = win.down('#roomAllotAdmissionCodeId');
			    	if(!isNullOrEmpty(userWiseValues.studentNameDefault)){
			    		userWiseValues.studentName=userWiseValues.studentNameDefault;
			    	}
			    	/*if(userWiseValues.userType==3) {
			    		var store = roomAllotAdmissionCodeId.getStore();
			    		store.getProxy().extraParams = {
			    			studentId:userWiseValues.studentName
			    		};
			    		store.load();
			    	} else {
			    		roomAllotAdmissionCodeId.setVisible(false);
			    		roomAllotAdmissionCodeId.allowBlank = true;
			    	}*/
			    	
			    	Ext.Ajax.request({
						type: 'rest',
			 			url: SERVERURL.HOSTEL_OPT_IN_DROP_DOWN, 
			 			method: 'GET',
			 			async:false,
			 			success: function(res, action) {
			 				var response = JSON.parse(res.responseText);
			 				$this.HostelResponse = JSON.parse(res.responseText);
			 				if($this.HostelResponse.length > 0 && ($this.HostelResponse[0].value == 'yes' || $this.HostelResponse[0].value == 'YES' || $this.HostelResponse[0].value == 'Yes' || $this.HostelResponse[0].value == 'YEs')){
			 					if(userWiseValues.userType==3) {
						    		var store = roomAllotAdmissionCodeId.getStore();
						    		store.getProxy().extraParams = {
						    			studentId:userWiseValues.studentName
						    		};
						    		store.load();
						    	} else {
						    		roomAllotAdmissionCodeId.setVisible(false);
						    		roomAllotAdmissionCodeId.allowBlank = true;
						    	}
							}
			 				else{
			 					if(userWiseValues.userType==3) {
			 						var store = roomAllotAdmissionCodeId.getStore();
			 						store.getProxy().extraParams = {
			 							studentId:userWiseValues.studentName
			 						};
			 						store.load({
			 							callback:function(records, operation, success){
			 								if (success) {
			 									if(records.length == 1){
			 										roomAllotAdmissionCodeId.setValue(records[0].get("id"));									
			 									}else{
			 										var admissionId=records[0].get("id");
			 										for(var i in records){
			 											if(admissionId<records[i].get("id")){
			 												admissionId=records[i].get("id");
			 											}
			 										}
			 										roomAllotAdmissionCodeId.setValue(admissionId);
			 									}
			 								}
			 							}
			 						});
			 						
			 						
			 						
			 					} else {
			 						roomAllotAdmissionCodeId.setVisible(false);
			 						roomAllotAdmissionCodeId.allowBlank = true;
			 					}
			 				}
			 			}
					})
			    	
			    	
				}
			},
			'userallotroomwin button[itemId=submitBtn]':{
				click:function(obj){
					this.saveUserAllotment(obj);
				}
			},
			'userallotroomwin button[itemId=cancelBtn]':{
				click:function(obj){
					obj.up('window').close();	
				}
			},
			'userwisesearch combo[itemId=userType]':{
				select:function(combo,record){
					var userTypeId = record[0].get("id");
					var form = combo.up('form');
					var studentName = form.down('#studentName');
					studentName.setDisabled(false);
					var store = studentName.getStore();
					
					store.getProxy().extraParams = {
						userType: userTypeId
					};
					store.load();
				}
			
			},
			
			/*'userwisesearch combo[itemId=studentName]':{
				blur:function(combo,record){
					var value=combo.getValue();
					if(isNaN(value)||value==null||value==""){
						combo.reset();
					}
					
					
				}
			
			},*/
			'userwisesearch combo[itemId=studentName]':{
				select:function(combo,record){
					var form = this.getUserwisesearch();
					var feePlan = form.down("#hostelFeePlanName");
					var feeRule = form.down("#hostelFeeRule");
					var feeTotalAmount = form.down("#hostelFeeTotalAmount");
					var userId = record[0].get("id");
					url = SERVERURL.PATH_FIND_STUDENT_HOSTEL_FEE_DETAIL+"?userId="+userId;
					Ext.Ajax.request({
						method: 'GET',
						url: url,
						success: function(response) {
							if(!isNullOrEmpty(response.responseText)){
								var data = Ext.decode(response.responseText);
								feePlan.setValue('<span style="color:strong;font-weight:bold">' +data.feeplan+ '</span>');
								feeRule.setValue('<span style="color:strong;font-weight:bold">' +data.feeplanRule+ '</span>');
								feeTotalAmount.setValue('<span style="color:strong;font-weight:bold">' +data.totalAmount+ '</span>');
							}else{
								feePlan.setValue();
								feeRule.setValue();
								feeTotalAmount.setValue();
							}
						}
					});
				}
			},

			'userwisesearch combo[itemId=academyLocation]':{
				render:function(combo){
					var store = combo.getStore();
					store.getProxy().extraParams = {
						id: this.getCurrentlyLoggedInUser().id
					};
					store.load({
						callback:function(records, operation, success){
							if (success) {
								if(records.length == 1){
									combo.setValue(records[0].get("id"));									
								}
							}
						}
					});
				},
				select:function(combo,record){
					var alId = record[0].get("id");
					var form = combo.up('form');
					var hostelCodeName = form.down('#hostelCodeName');
					hostelCodeName.clearValue();
					var store = hostelCodeName.getStore();
					store.getProxy().extraParams = {
						academyLocationId: alId
					};
					store.load();
				}
			},
			'userwisesearch button[itemId=searchButtonId]':{
				click:function(obj){
					this.loadUserOrRoomWiseRecord(obj);
				}
			},
			'userwisesearch button[itemId=resetButtonId]':{
				click:function(obj){
					this.resetUserWise(obj);
				}
			},
			'roomwisesearch button[itemId=resetButtonId]':{
				click:function(obj){
					var form = obj.up('form');
					form.getForm().reset();
					form.down('#studentName').setDisabled(true);
				}
			},
			'userwiselist':{
				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					var userwiselist = this.getUserwiselist();
					var columnName=userwiselist.columnManager.columns[cellIndex].dataIndex;

					if(columnName=='noOfBeds'){
						if (e.target.tagName == 'A') {

							var manageHostelController=  Academia.app.getController('Academia.controller.hostel.managehostel.ManageHostelController');
							manageHostelController.openListOfBedWin(grid, rowIndex, record);
						}
					}
					
					if(columnName=='noOfOccupiedBeds'){
						if (e.target.tagName == 'A') {
							this.showOccupiedBedsDetails(grid, rowIndex, record);
						}
					}
					
					if(columnName=='noOfAvailableBeds'){
						if (e.target.tagName == 'A') {
							this.showAvailableBedsDetails(grid, rowIndex, record);
						}
					}
					
					if(columnName=='noOfAllotted') {
						if (e.target.tagName == 'A') {
							this.showAllottedDetails(grid, rowIndex, record);
						}
					}
				}
			},
			/*'checkinwin checkboxfield[itemId=isCheckedInRecords]':{
				change:function($this, newValue, oldValue, eOpts){
					this.loadGridDataByCheckedInRecords($this, newValue, oldValue, eOpts);
				}
			},*/
			'userwisesearch':{
				afterrender:function(obj){
					var $this =this;
					var studentFieldDefault = obj.down("#studentName");
					var studentFieldCsm =  obj.down("#studentNameNo");
					var hostelDefault = obj.down("#hostelCodeName");
					var Hostel = obj.down("#hostelCodeNo");
					var academyLocation = obj.down("#academyLocation");
					Ext.Ajax.request({
						type: 'rest',
			 			url: SERVERURL.HOSTEL_OPT_IN_DROP_DOWN, 
			 			method: 'GET',
			 			async:false,
			 			success: function(res, action) {
			 				var response = JSON.parse(res.responseText);
			 				$this.HostelResponse = JSON.parse(res.responseText);
			 				if($this.HostelResponse.length > 0 && ($this.HostelResponse[0].value == 'yes' || $this.HostelResponse[0].value == 'YES' || $this.HostelResponse[0].value == 'Yes' || $this.HostelResponse[0].value == 'YEs')){
								$this.setAllowBlank(studentFieldDefault,false);
								$this.setAllowBlank(studentFieldCsm,true)
								hostelDefault.setVisible(true);
								
								studentFieldDefault.setVisible(true);
								studentFieldCsm.setVisible(false);
								Hostel.setVisible(false);
							}
							else{
								studentFieldCsm.setVisible(true);
								$this.setAllowBlank(studentFieldDefault,true);
								Hostel.setVisible(true);
								$this.setAllowBlank(studentFieldCsm,false);
								hostelDefault.setVisible(false);
								academyLocation.setDisabled(true);
							}
			 			}
					})
					
					
					this.onRenderStoreLoad();

				}
			},
			'userwisesearch combo[itemId=studentNameNo]':{
			 select:function(obj){
				 var $this =this;
				 if($this.HostelResponse.length > 0 && ($this.HostelResponse[0].value == 'NO' || $this.HostelResponse[0].value == 'No' || $this.HostelResponse[0].value == 'nO' || $this.HostelResponse[0].value == 'no')){
						var form = obj.up('form');
						var studentNameNo = form.down("#studentNameNo").getValue();
						var hostelField = form.down("#hostelCodeNo");
						var hostel = form.down("#hostelCodeNo").getStore();
						var buildingCodeName  = form.down('#buildingCodeName');
						var buildingCodeStore =  buildingCodeName.getStore();
						
						
						
						
						hostel.getProxy().extraParams = {
							studentId: studentNameNo
						};
						hostel.load({
							 callback: function(records, operation, success) {
								   if (success) {
									   if(records.length > 0){
										   hostelField.setValue(records[0].data.id);
										   
											buildingCodeStore.getProxy().extraParams = {
											hostelCode:records[0].data.id,
											
										};
											buildingCodeStore.load();
									   }
								   }
							   }	
						});
						
						

//						
//						buildingCodeStore.load({
//							 callback: function(records, operation, success) {
//								   if (success) {
//									   if(records.length > 0){
//										   hostelField.setValue(records[0].data.id);
//									   }
//								   }
//							   }	
//						});
					
				 }
			}
		},
			'userwisesearch customcombobox[itemId=hostelCodeName]':{
				select: function(obj,record){
					var form = obj.up('form');
					var hostelCode = record[0].get("id");
					var buildingCodeName  = form.down('#buildingCodeName');
					buildingCodeName.clearValue();
					var buildingCodeStore =  buildingCodeName.getStore();

					var values = form.getForm().getValues();
					
						buildingCodeStore.getProxy().extraParams = {
							hostelCode:hostelCode,
							status:values.status
						};
						buildingCodeStore.load();
				}
			},
			'userwisesearch customcombobox[itemId=buildingCodeName]':{
				select: function(obj,record){
					var form = obj.up('form');
					var buildingCode = record[0].get("id");
					var floorCodeName  = form.down('#floorCodeNo');
					floorCodeName.clearValue();
					var floorCodeStore =  floorCodeName.getStore();

					var values = form.getForm().getValues();
					
//					if(values.hostelType == 'FLOOR' || values.hostelType == 'ROOM'){
						floorCodeStore.getProxy().extraParams = {
							buildingCode:buildingCode,
							status:values.status,
							resourceGroup:'Floor'
						};
						floorCodeStore.load();
//					}
				}
			},
			'userwisesearch customcombobox[itemId=floorCodeNo]':{
				select: function(obj,record){
					var form = obj.up('form');
					var floorCode = record[0].get("id");
					var roomNoField  = form.down('#roomNo');
					roomNoField.clearValue();
					var roomStore =  roomNoField.getStore();

					var values = form.getForm().getValues();
					
//					if(values.hostelType == 'ROOM'){
						roomStore.getProxy().extraParams = {
							floorCode:floorCode,
							status:values.status,
							resourceGroup:'Room'
						};
						roomStore.load();
					}
//				}
			},
			'hostelroomallocationstructure':{
				render:function(structure){
					this.disableManageAllocationImportTab(structure, this.getHOSTEL_ROOM_ALLOCATION_PERMISSIONS());
					var grid =structure.down('userwiselist');
					this.getGridHeaderFreeze(grid,structure,true);
				}
			},
			'importroomallocation radiogroup[itemId=importDownloadRoomAllocationgroupIds]':{
				change  : function(obj,newValue,oldValue){
					var form = obj.up('importroomallocation');	 
					var value = obj.getValue();
					var downAllocationform = form.down('downloadhostelroomallocation');
					var importAllocationform = form.down('importhostelroomallocationform');
					var importList = form.down('importroomallocationlist');

					downAllocationform.setVisible(false);
					importAllocationform.setVisible(false);
					importList.setVisible(false);

					if(value.downloadUploadTemplate=='forDownloadTemplate'){
						downAllocationform.setVisible(true);
					}else if(value.downloadUploadTemplate=='forUploadTemplate'){
						this.doAccessControlValidationForLoader(importAllocationform,this.getCORE_ERP_LOADER_PERMISSIONS());
						var uploadoptionradiogroupform  = this.getUploadoptionradiogroup();
						uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
							isUploadAll: false
						});
						importAllocationform.setVisible(true);
						importList.setVisible(true);
					}
				}
			},
			'importroomallocation uploadoptionradiogroup[itemId=hostelCheckInUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
	        	change: function( radioGroup, newValue, oldValue, eOpts){
	        		var grid =this.getImportroomallocationlist();
	        		var form =this.getUploadoptionradiogroup();
	        		var isUploadAll = newValue.isUploadAll;
	        		this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_HOSTEL_ROOM_ALLOCATION');
	        	}   
	 		   },
	 		  'importhostelroomallocationform':{
					render: function(obj){
						var $this = this;
						var temForm = $this.getImporthostelroomallocationform();
						var tempFormValue=temForm.getForm().findField('importUtilityMasterId');
						var grid = $this.getImportroomallocationlist();
						var form = $this.getUploadoptionradiogroup();
						var isUploadAll = form.items.items[0].getValue().isUploadAll;
						$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_HOSTEL_ROOM_ALLOCATION');
						//
						tempFormValue.getStore().load({
							callback:function(record){
								for(var i in record){
									if(record[i].data.value == 'Bulk Hostel Room Allocation'){
										tempFormValue.setValue(record[i].data.id);
										tempFormValue.setReadOnly(true);
									}
								}
							}
						});
					}
				},
	 		  'importhostelroomallocationform button[itemId=SubmitBtn]':{
					click: function(obj){
						var temForm = obj.up('importhostelroomallocationform');
				    	var tempFormValue=temForm.getForm().findField('importUtilityMasterId').getValue();
				    	var $this=this;
				    	var grdStore;
				    	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	    	            $this.getHashOfFile(temForm);
			            setTimeout(function() {
					    	temForm.getForm().submit({
					    		method : 'POST',
					    		url : submitUrl,
					    		success : function(form, action){
						        	showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
						        	temForm.getForm().isValid();
					    		},
					    		failure: function(form, action) {
	   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
					    	    }
					    	});
			        	},1000);
				    	Ext.defer(function() {
				    		$this.loadImportHostelRoomAllocationGrid();
				    	}, 2000, this);
						
					}
				},
				'downloadhostelroomallocation button[itemId=hostelRoomAllocationDownload]':{
					click: function(obj){
						 var $this = this;
						 var csvForm = Ext.create('Ext.form.Panel'); 
						 csvForm.getForm().submit({
							 target: '_blank',
							 method:'POST',
							 params :{
								 access_token : Ext.Ajax.defaultHeaders.access_token,
								 academyLocationId:$this.getCurrentAcademyLocation()
							 },
							 headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
							 url: SERVERURL.IMPORT_UTILITY_DOWNLOAD_HOSTEL_ROOM_ALLOCATION_FILE,
							 standardSubmit :true
						 });
					}
				},
				'importhostelroomallocationform button[itemId=resetBtn]':{
					click: function(obj){
						var $this=this;
						var form = $this.getImporthostelroomallocationform();
						form.down('#uploadFileField').reset();
						var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
						uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
							isUploadAll: false
						});
						form.getForm().isValid();
					}
				},
				'importroomallocationlist':{
					cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
						if (e.target.tagName == 'A') {
							var fileType=null;
							if(cellIndex==1){
								fileType='successFile';
							}else if(cellIndex==6){
								fileType='errorFile';
							}else if(cellIndex==7){
								fileType='logFile';
							}
							var documentId = record.get("id");
							if (!isNullOrEmpty(documentId)) {
								this.getDownloadFile(documentId,fileType);
							}
						}
					}
				},
				 'importroomallocationlist button[itemId=btnForce]':{
					 click : function(obj) {
						 var grid = this.getImportroomallocationlist();
			            	if (grid.getSelectionModel().getCount() > 0) {
			            		if(grid.getSelectionModel().getCount() > 1){
				        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
				        		}else{
				        			var this$ = this;
		 	                	var id = grid.getSelectionModel().selectionStart.data.id;
		 	                	var urlAppend="?jobName="+id;
		 	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
		 	    	        	Ext.Ajax.request({
		 	    	        		url: submitURL,
		 	    	        		method: 'GET',
		 	    	        		success: function(response) {
		 	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
		 	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
		 	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
		 	    	        				//console.log("Manual trigger hit");
		 	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
		 	    	        			}else if(response.responseText==="SUCCESS"){
		 	    	        				//console.log("Manual trigger hit");
		     	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
		 	    	        			}
		 	    	        		}
		 	    	        	});
				        		}
			            	} else {
			            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
			            	}  
			            }
				 },
				 'hostelroomallocationstructure tabpanel[itemId=allVisibleTP]':{
						tabchange : function(tabPanel, newCard, oldCard, eOpts ){
	   		   				      var $this = this;
	   		   				      var structure=$this.getHostelroomallocationstructure();
	   		   		              var grid =newCard.down('grid');
	   		  	  		 		  var gridTitle = grid.dockedItems.items[0];
	   		  	  		 		  var gridBttns = grid.dockedItems.items[1];
	   		   	  		 		  var gridHeader = grid.dockedItems.items[2];
	   		  		  		      gridTitle.removeCls('sticky-header-active-title-withouttab-pagination-customized');
	   	                          gridBttns.removeCls('sticky-header-active-buttons-withouttab-pagination-customized');
	   	                          gridHeader.removeCls('sticky-header-active-columns-withouttab-pagination-customized');
	   		   			}
				},
				'importhostelroomallotmentloader radiogroup[itemId=importDownloadRoomAllotmentIds]':{
					change  : function(obj,newValue,oldValue){
						var form = obj.up('importhostelroomallotmentloader');	 
						var value = obj.getValue();
						var downloadAllotmentform = form.down('importhostelroomallotmentdownloadform');
						var uploadAllotmentform = form.down('importhostelroomallotmentuploadform');
						var loaderGrid = form.down('importhostelroomallotmentloadergrid');

						downloadAllotmentform.setVisible(false);
						uploadAllotmentform.setVisible(false);
						loaderGrid.setVisible(false);

						if(value.downloadUploadTemplate=='forDownloadTemplate'){
							downloadAllotmentform.setVisible(true);
						}else if(value.downloadUploadTemplate=='forUploadTemplate'){
							var uploadoptionradiogroupform  = this.getUploadoptionradiogroup();
							uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
								isUploadAll: false
							});
							uploadAllotmentform.setVisible(true);
							loaderGrid.setVisible(true);
						}
					}
				},
				'importhostelroomallotmentdownloadform button[itemId=hostelRoomAllotmentDownload]':{
					click: function(obj){
						 var $this = this;
						 var csvForm = Ext.create('Ext.form.Panel'); 
						 csvForm.getForm().submit({
							 target: '_blank',
							 method:'POST',
							 params :{
								 access_token : Ext.Ajax.defaultHeaders.access_token,
								 academyLocationId:$this.getCurrentAcademyLocation()
							 },
							 headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
							 url: SERVERURL.IMPORT_UTILITY_DOWNLOAD_HOSTEL_ROOM_ALLOCATION_SUNSHINE_FILE,
							 standardSubmit :true
						 });
					}
				},
				'importhostelroomallotmentuploadform button[itemId=SubmitBtn]':{
					click: function(obj){
						var $this = this;
						var temForm = obj.up('importhostelroomallotmentuploadform');
				    	var tempFormValue=temForm.getForm().findField('importUtilityMasterId').getValue();
				    	var $this=this;
				    	var grdStore;
				    	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	    	            $this.getHashOfFile(temForm);
			            setTimeout(function() {
					    	temForm.getForm().submit({
					    		method : 'POST',
					    		url : submitUrl,
					    		success : function(form, action){
						        	showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
						        	temForm.getForm().isValid();
					    		},
					    		failure: function(form, action) {
	   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
					    	    }
					    	});
			        	},1000);
				    	Ext.defer(function() {
					   		var grid = $this.getImporthostelroomallotmentloadergrid();
					   		var form  = $this.getUploadoptionradiogroup();
					   		var isUploadAll = form.items.items[0].getValue().isUploadAll;
					   		$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_HOSTEL_ROOM_ALLOTMENT_SUNSHINE');
				    	}, 2000, this);
						
					}
				},
				'importhostelroomallotmentuploadform button[itemId=resetBtn]':{
					click: function(obj){
						var $this=this;
						var form = $this.getImporthostelroomallotmentuploadform();
						form.down('#uploadFileField').reset();
						var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
						uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
							isUploadAll: false
						});
						form.getForm().isValid();
					}
				},
				'importhostelroomallotmentuploadform uploadoptionradiogroup[itemId=hostelCheckInUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
		        	change: function( radioGroup, newValue, oldValue, eOpts){
		        		var grid =this.getImporthostelroomallotmentloadergrid();
		        		var form =this.getUploadoptionradiogroup();
		        		var isUploadAll = newValue.isUploadAll;
		        		this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_HOSTEL_ROOM_ALLOTMENT_SUNSHINE');
		        	}   
		 		   },
		 		  'importhostelroomallotmentuploadform':{
						render: function(obj){
							var $this = this;
							var temForm = $this.getImporthostelroomallotmentuploadform();
							var tempFormValue=temForm.getForm().findField('importUtilityMasterId');
							var grid = $this.getImporthostelroomallotmentloadergrid();
							var form = $this.getUploadoptionradiogroup();
							var isUploadAll = form.items.items[0].getValue().isUploadAll;
							$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_HOSTEL_ROOM_ALLOTMENT_SUNSHINE');
							tempFormValue.getStore().load({
								callback:function(record){
									for(var i in record){
										if(record[i].data.value == 'Import Hostel Room Allotment Sunshine'){
											tempFormValue.setValue(record[i].data.id);
											tempFormValue.setReadOnly(true);
										}
									}
								}
							});
						}
					},
					'importhostelroomallotmentloadergrid':{
						cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
							if (e.target.tagName == 'A') {
								var fileType=null;
								if(cellIndex==1){
									fileType='successFile';
								}else if(cellIndex==6){
									fileType='errorFile';
								}else if(cellIndex==7){
									fileType='logFile';
								}
								var documentId = record.get("id");
								if (!isNullOrEmpty(documentId)) {
									this.getDownloadFile(documentId,fileType);
								}
							}
						}
					},
					 'importhostelroomallotmentloadergrid button[itemId=btnForce]':{
						 click : function(obj) {
							 var grid = this.getImporthostelroomallotmentloadergrid();
				            	if (grid.getSelectionModel().getCount() > 0) {
				            		if(grid.getSelectionModel().getCount() > 1){
					        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
					        		}else{
					        			var this$ = this;
			 	                	var id = grid.getSelectionModel().selectionStart.data.id;
			 	                	var urlAppend="?jobName="+id;
			 	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
			 	    	        	Ext.Ajax.request({
			 	    	        		url: submitURL,
			 	    	        		method: 'GET',
			 	    	        		success: function(response) {
			 	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
			 	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
			 	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
			 	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
			 	    	        			}else if(response.responseText==="SUCCESS"){
			     	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
			 	    	        			}
			 	    	        		}
			 	    	        	});
					        		}
				            	} else {
				            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				            	}  
				            }
					 },
		});
	},
	onRenderStoreLoad:function(){
		var $this = this;
		var form = this.getUserwisesearch();
		
		var hostelCodeName  = form.down('#hostelCodeName');
		var buildingCodeName  = form.down('#buildingCodeName');
		var floorCodeNoField  = form.down('#floorCodeNo');
		var roomNoField  = form.down('#roomNo'),
		 	userTypeField  = form.down('#userType');

		var hostelCodeNameStore =  hostelCodeName.getStore();
		var buildingCodeStore =  buildingCodeName.getStore();
		var floorCodeNo = floorCodeNoField.getStore();
		var studentStore = form.down('#studentNameNo').getStore();;
		var roomNo = roomNoField.getStore(),
		userTypeFldStore = userTypeField.getStore();

		var values = form.getForm().getValues();
        
		
		if($this.HostelResponse.length > 0 && ($this.HostelResponse[0].value == 'no' || $this.HostelResponse[0].value == 'NO' || $this.HostelResponse[0].value == 'No' || $this.HostelResponse[0].value == 'nO')){
			studentStore.getProxy().extraParams = {
				
			};
			studentStore.load();
		}
		
		
		if($this.HostelResponse.length > 0 && ($this.HostelResponse[0].value == 'yes' || $this.HostelResponse[0].value == 'YES' || $this.HostelResponse[0].value == 'Yes' || $this.HostelResponse[0].value == 'YEs')){
			hostelCodeNameStore.getProxy().extraParams = {
				hostelCode:values.hostelCodeName,
				status:values.status,
				resourceGroup:'Hostel'
			};
			hostelCodeNameStore.load();
		}

		
		buildingCodeStore.getProxy().extraParams = {
			hostelCode:values.hostelCodeName,
			status:values.status,
			resourceGroup:'Building'
		};
		buildingCodeStore.load();

		floorCodeNo.getProxy().extraParams = {
			buildingCode:values.floorCodeNo,
			status:values.status,
			resourceGroup:'Floor'
		};
		floorCodeNo.load();

		roomNo.getProxy().extraParams = {
			floorCode:values.roomNo,
			status:values.status,
			resourceGroup:'Room'
		};
		roomNo.load();
		
		userTypeFldStore.load({
			callback:function(records, operation, success){
				if(records.length > 0){
					var rec = userTypeFldStore.findRecord('userGroupName',getCommonTranslation('STUDENT'));
					if(rec){
						userTypeField.setValue(rec.data.id);	
						var studentName = form.down('#studentName');
						
						if(!studentName.config.isAllotRoom){
							if($this.HostelResponse.length > 0 && ($this.HostelResponse[0].value == 'yes' || $this.HostelResponse[0].value == 'YES' || $this.HostelResponse[0].value == 'Yes' || $this.HostelResponse[0].value == 'YEs')){
								var store = studentName.getStore();
								store.getProxy().extraParams = {
									userType: rec.data.id
								};
								store.load();	
							}
							
						}
						studentName.config.isAllotRoom=false;
					}
				}
			}
		});
	},
	resetUserWise:function(obj){
		var form = obj.up('form');
		form.getForm().reset();
		//form.down('#studentName').setDisabled(true);

		this.onRenderStoreLoad();
	},
	showOccupiedBedsDetails:function(grid, rowIndex, record){
		var $this = this;
		var formWindow = $this.getOccupiedbeddetailswin();
		if (!formWindow) {
			Ext.widget('occupiedbeddetailswin');
			formWindow = $this.getOccupiedbeddetailswin();
		}
		formWindow.show();

		var store = $this.getOccupiedbedsgrid().getStore();
		store.getProxy().extraParams = {
			hostelRoomId:record.data.hostelRoomId
		};
		store.load();

	},
	showAvailableBedsDetails:function(grid, rowIndex, record){
		var $this = this;
		var formWindow = $this.getAvailablebeddetailswin();
		if (!formWindow) {
			Ext.widget('availablebeddetailswin');
			formWindow = $this.getAvailablebeddetailswin();
		}
		formWindow.show();

		 var form = $this.getAvailableBeddetailswin().getForm();
	   	   
    	 if(!isNullOrEmpty(record.data.floorNo)){
    		 var floorNo =   record.data.floorNo;
    		 form.findField('floorNo').setValue(floorNo);
    	 }
    	 
    	 if(!isNullOrEmpty(record.data.roomType)){
    		 var roomType =   record.data.roomType;
    		 form.findField('roomType').setValue(roomType);
    	 }
    	 	
    	 
    	 if(!isNullOrEmpty(record.data.roomNo)){
    		 var roomNo =   record.data.roomNo;
    		 form.findField('roomNo').setValue(roomNo);
    	 }
    	 
    	 
   	  var store = $this.getAvailablebeddetailsgrid().getStore();
		store.getProxy().extraParams = {
			resourceId:record.data.resourceId
		};
		store.load();

	},
	loadUserOrRoomWiseRecord:function(obj){
		var $this = this;
		var searchForm = obj.up('form');
		var form = searchForm.getForm();
		var values = form.getValues();
		
		/*var searchStructure = $this.getRoomallocationsearchstructure().getForm();
		var allocationType = searchStructure.findField('allocationType').getValue();*/
		
		//if(allocationType || allocationType =='true'){
			var grid = $this.getUserwiselist();
			var btnExportToPDF = grid.down('#btnExportToPDF');
			btnExportToPDF.setDisabled(false);
			var btnExportToExcel = grid.down('#btnExportToExcel');
			btnExportToExcel.setDisabled(false);
			var exportPDFCurrentPage = grid.down('#exportPDFCurrentPage');
			exportPDFCurrentPage.setDisabled(false);
			var exportExcelCurrentPage = grid.down('#exportExcelCurrentPage');
			exportExcelCurrentPage.setDisabled(false);
			var exportPDFAll = grid.down('#exportPDFAll');
    		exportPDFAll.setDisabled(false);
    		var exportExcelAll = grid.down('#exportExcelAll');
    		exportExcelAll.setDisabled(false);
    		
//    		if(isNaN(values.studentName)||values.studentName==""||values.studentName==null){
//    			searchForm.down("#studentName").reset();
//    			return false;
//    		}
//    		
			var store = grid.getStore();
			Ext.Ajax.request({
                type: 'rest',
                 url: SERVERURL.HOSTEL_OPT_IN_DROP_DOWN, 
                 method: 'GET',
                 async:false,
                 success: function(res, action) {
                     var response = JSON.parse(res.responseText);
                     $this.HostelResponse = JSON.parse(res.responseText);
                     if($this.HostelResponse.length > 0 && ($this.HostelResponse[0].value == 'yes' || $this.HostelResponse[0].value == 'YES' || $this.HostelResponse[0].value == 'Yes' || $this.HostelResponse[0].value == 'YEs')){
                         store.getProxy().extraParams = {
                             roomTypeId:values.roomType,
                             hostelResourceId:values.hostelCodeName,
                             buildingResourceId:values.buildingCodeName,
                             floorResourceId:values.floorCodeNo,
                             roomResourceId:values.roomNo,
                             status:values.status,
                             userType:values.userType,
                             userId:values.studentNameDefault,
                             academyLocationId:values.academyLocation,
                             fromDate:values.fromDate,
                             toDate:values.toDate
                             };
                    }
                    else{
                        store.getProxy().extraParams = {
                            
                            roomTypeId:values.roomType,
                            hostelResourceId:values.hostelCodeName,
                            buildingResourceId:values.buildingCodeName,
                            floorResourceId:values.floorCodeNo,
                            roomResourceId:values.roomNo,
                            status:values.status,
                            userType:values.userType,
                            userId:values.studentName  ,
                            academyLocationId:values.academyLocation,
                            fromDate:values.fromDate,
                            toDate:values.toDate
                            };
                    }
                 }
            });
			store.loadPage(1);
			
		//}
	},
	onChaneAllocationType:function(obj,record){
		var form = obj.up('form');
		var allocationType = record.allocationType;

//		var gridStructure  = this.getHostelroomallocationstructure();
		if(allocationType == 'USER_WISE'){
			form.down('#userwisesearch').setVisible(true);
			form.down('#roomwisesearch').setVisible(false);

			form.down('#userwiselist').setVisible(true);
			form.down('#roomwiselist').setVisible(false);
		}else{
			form.down('#userwisesearch').setVisible(false);
			form.down('#roomwisesearch').setVisible(true);

			form.down('#userwiselist').setVisible(false);
			form.down('#roomwiselist').setVisible(true);
		}
	},
	showAllotRoomWin:function(grid){
    	var $this = this;
    	var formWindow = $this.getUserallotroomwin();
    	if (!formWindow) {
    		Ext.widget('userallotroomwin');
    		formWindow = $this.getUserallotroomwin();
    	}
    	formWindow.show();
    	$this.setAllotedRoomDetailsOnWindow(grid);
    },
   /* showCancelAllotmentWin:function(grid){
    	var $this = this;
    	var formWindow = $this.getCancelallotmentwin();
    	if (!formWindow) {
    		Ext.widget('cancelallotmentwin');
    		formWindow = $this.getCancelallotmentwin();
    	}
    	formWindow.show();
    	$this.setCancelAllotmentRecord(grid);
    },*/
    /*showCheckInWin:function(grid){
    	var $this = this;
    	var formWindow = $this.getCheckinwin();
    	if (!formWindow) {
    		Ext.widget('checkinwin');
    		formWindow = $this.getCheckinwin();
    	}
    	formWindow.show();
    	$this.setCheckInWind(grid);
    },*/
    showCheckOutWin:function(grid){
    	var $this = this;
    	var formWindow = $this.getCheckoutwin();
    	if (!formWindow) {
    		Ext.widget('checkoutwin');
    		formWindow = $this.getCheckoutwin();
    	}
    	formWindow.show();
    	$this.setCheckOutWind(grid);
    },
    setAllotedRoomDetailsOnWindow:function(grid){
    	var $this = this;
    	var userWiseSearch = $this.getUserwisesearch();
    	var form = userWiseSearch.getForm();
    	var values = form.getValues();
    	var userType = parseInt(values.userType);
    	console.log('userType',userType);

    	var userTypeRawValue = form.findField('studentName').getRawValue();

    	if (isEmpty(userTypeRawValue)) {
    		userTypeRawValue=form.findField('studentNameDefault').getRawValue();
    	}
    	
    	var allotmentForm = $this.getUserAllotroomwin();
    	var userTypeField = allotmentForm.down('#userName');
    	userTypeField.setValue(userTypeRawValue);

    	var records = grid.getSelectionModel().getSelection()[0];

    	var hostelNameField = allotmentForm.down('#hostelName');
    	var roomTypeField = allotmentForm.down('#roomType');
    	var roomNoField = allotmentForm.down('#roomNo');
    	var inactiveStatusMsgField = allotmentForm.down('#inactiveStatusMsg');
    	
    	
    	if (!isNullOrEmpty(records.data.hostelName)) {
    		hostelNameField.setValue(records.data.hostelName);
    	}

    	if (!isNullOrEmpty(records.data.roomType)) {
    		roomTypeField.setValue(records.data.roomType);
    	}
    	if (!isNullOrEmpty(records.data.roomNo)) {
    		roomNoField.setValue(records.data.roomNo);
    	}

    	var createdByField = allotmentForm.down('#createdBy');
    	var store = createdByField.getStore();
    	store.load({
    		callback: function(records, operation, success) {
    			if (success) {
    				if(records.length > 0){
    					createdByField.setValue($this.getCurrentlyLoggedInUser().id);
    				}		 
    			}
    		}	   
    	});
    	
    	var allotmentByField = allotmentForm.down('#allotmentBy');
    	var store = allotmentByField.getStore();
    	store.load({
    		callback: function(records, operation, success) {
    			if (success) {
    				if(records.length > 0){
    					allotmentByField.setValue($this.getCurrentlyLoggedInUser().id);
    				}		 
    			}
    		}	   
    	});
    	
    	
    	Ext.Ajax.request({
			type : 'rest',
			url : SERVERURL.FIND_TEMP_INACTIVE_STATUS_DETAILS,
			params : {
				hostelRoomId:records.data.hostelRoomId
			},
			method : 'GET',
			success : function(form, action) {
				if(!isNullOrEmpty(form.responseText)){
				var res = Ext.JSON.decode(form.responseText);
				if(!isNullOrEmpty(res.roomStatus)){
					if(res.roomStatus == 'TEMPORARY_INACTIVE'){
						inactiveStatusMsgField.setValue('<span style="color:red;">' + 'Please note that, this room will not be available from '
								+ dateRender(res.fromDate) +' '+  'to' + ' '+ dateRender(res.toDate) + '.</span>');	
					}
				}
			 }
			}
		});
    	
    },
    saveUserAllotment:function(obj){
    	var $this = this;
    	var form = obj.up('form').getForm();
    	var values = form.getValues();
    	var admissionId =  obj.up('form').down('#roomAllotAdmissionCodeId').getValue();
    	var userWiseSearch = $this.getUserwisesearch().getForm();
    	var userWiseValues = userWiseSearch.getValues();

    	if(!isNullOrEmpty(userWiseValues.studentNameDefault)){
    		userWiseValues.studentName=userWiseValues.studentNameDefault;
    	}

    	var grid = $this.getUserwiselist();
    	var records = grid.getSelectionModel().getSelection()[0];
    	if(!isNullOrEmpty(userWiseValues.studentNameDefault)){
    		userWiseValues.studentName=userWiseValues.studentNameDefault;
    	}

    	var data = {
    			"hostelRoomId": records.data.hostelRoomId,
    			"userTypeId": userWiseValues.userType,
    			"userId": userWiseValues.studentName,
    			"allotmentDate": values.allotmentDate,
    			"allotmentById": values.allotmentBy,
    			"createdById": values.createdBy,
    			"feePlanRueStageId":records.data.feePlanRueStageId,
    			"admissionId":admissionId
    	};
    	var url;
    	url = SERVERURL.HOSTEL_ROOM_ALLOTMENT;
    	
    	Ext.Ajax.request({
			type: 'rest',
 			url: SERVERURL.HOSTEL_OPT_IN_DROP_DOWN, 
 			method: 'GET',
 			async:false,
 			success: function(res, action) {
 				var response = JSON.parse(res.responseText);
 				$this.HostelResponse = JSON.parse(res.responseText);
 				if($this.HostelResponse.length > 0 && ($this.HostelResponse[0].value == 'yes' || $this.HostelResponse[0].value == 'YES' || $this.HostelResponse[0].value == 'Yes' || $this.HostelResponse[0].value == 'YEs')){

 					Ext.Ajax.request({
 						method: 'POST',
 						url: SERVERURL.HOSTEL_ROOM_ALLOTMENT,
 						jsonData:data,
 						success: function(response) {
 							//var data = Ext.decode(response.responseText);

 							if(response.responseText == '0'){
 								showSuccessMessage(getHostelTranslation('ALLOT_ROOM'),getCommonTranslation('DUPLICATE_RECORD_CONDITION'));	
 							}else{
 								showSuccessMessage(getHostelTranslation('ALLOT_ROOM'),getCommonTranslation('SUCCESS'));	
 							}
 							grid.getStore().reload();
 						}
 					});
 					obj.up('window').close();

 				}
				else{
					
					Ext.Ajax.request({
			    		method : "GET",
			    		type : 'rest',
			    		url: SERVERURL.PATH_FIND_HOSTEL_ALREADY_ALLOTED_STUDENTS,
			    		params: {
			    			studentId : userWiseValues.studentName,
			    		},
			    		success: function(response) {
			    			if(response.responseText == 'true'){
			    				showWarningMessage(getHostelTranslation('ALLOT_ROOM'),getCommonTranslation('HOSTEL_ROOM_ALLOTMENT_IS_DONE_FOR_THIS_ACADEMIC_TERM')+" "+new Date().getFullYear());	
			    			}else{
			    				Ext.Ajax.request({
			 						method: 'POST',
			 						url: SERVERURL.HOSTEL_ROOM_ALLOTMENT,
			 						jsonData:data,
			 						success: function(response) {
			 							//var data = Ext.decode(response.responseText);

			 							if(response.responseText == '0'){
			 								showSuccessMessage(getHostelTranslation('ALLOT_ROOM'),getCommonTranslation('DUPLICATE_RECORD_CONDITION'));	
			 							}else{
			 								showSuccessMessage(getHostelTranslation('ALLOT_ROOM'),getCommonTranslation('SUCCESS'));	
			 							}
			 							grid.getStore().reload();
			 						}
			 					});
			    			}
			    			obj.up('window').close();
			    		}
			    	});
					
				}
 			}
		})
    	
    	
    	
    	
    },
    /*setCancelAllotmentRecord:function(grid){
    	var $this = this;
    	var cancelallotmentlist = $this.getCancelallotmentlist();
    	var cancelAllotmentListStore = cancelallotmentlist.getStore();
    	
    	var userWiseSearch = $this.getUserwisesearch().getForm();
    	var userWiseValues = userWiseSearch.getValues();
    	
    	
    	var grid = $this.getUserwiselist();
    	var records = grid.getSelectionModel().getSelection()[0];
    	
    	cancelAllotmentListStore.getProxy().extraParams = {
    		hostelRoomId:records.data.hostelRoomId,
    		userTypeId: userWiseValues.userType,
    		allotmentStatus:'ALLOTTED'
		};
    	cancelAllotmentListStore.load();
    	

    	var cancelallotmentForm = $this.getCancelallotmentwin();
    	var records = grid.getSelectionModel().getSelection()[0];

    	var hostelNameField = cancelallotmentForm.down('#hostelName');
    	var roomTypeField = cancelallotmentForm.down('#roomType');
    	var roomNoField = cancelallotmentForm.down('#roomNo');

    	if (!isNullOrEmpty(records.data.hostelName)) {
    		hostelNameField.setValue(records.data.hostelName);
    	}

    	if (!isNullOrEmpty(records.data.roomType)) {
    		roomTypeField.setValue(records.data.roomType);
    	}
    	if (!isNullOrEmpty(records.data.roomNo)) {
    		roomNoField.setValue(records.data.roomNo);
    	}

    	var createdByField = cancelallotmentForm.down('#cancellationBy');
    	var store = createdByField.getStore();
    	store.load({
    		callback: function(records, operation, success) {
    			if (success) {
    				if(records.length > 0){
    					createdByField.setValue($this.getCurrentlyLoggedInUser().id);
    				}		 
    			}
    		}	   
    	});
    },*/
   /* saveCancelAllotment:function(obj){

    	var $this = this;
    	var form = obj.up('form').getForm();
    	var values = form.getValues();
    	var grid = $this.getUserwiselist();

    	var userWiseSearch = $this.getUserwisesearch().getForm();
    	var userWiseValues = userWiseSearch.getValues();
    	var grid = $this.getUserwiselist();
    	var records = grid.getSelectionModel().getSelection()[0];
    	
    	var cancelallotmentlist = $this.getCancelallotmentlist();
//    	var cancelallotmentrecords = cancelallotmentlist.getSelectionModel().getSelection()[0];
    	

    	var allotmentsIds=[];
    	cancelallotmentlistRecord  = cancelallotmentlist.selModel.getSelection();
    		for(var i=0; i< cancelallotmentlistRecord.length; i++){
    			allotmentsIds.push(cancelallotmentlistRecord[i].data.id);
    			
    	}
    							
    		var data = {
    				"cancellationById": values.cancellationBy,
    				"cancelDate": values.cancelDate,
    				"cancellationReasonId": values.cancellationReason,
    				"cancelRemarks": values.remarks,
    				"allotmentIds":allotmentsIds ,
    		};

    	var url;
    	url = SERVERURL.CANCEL_ALLOTMENT;

    	Ext.Ajax.request({
    		method: 'POST',
    		url: url,
    		jsonData:data,
    		success: function(response) {
    			//var data = Ext.decode(response.responseText);
    			showSuccessMessage(getHostelTranslation('CANCEL_ALLOTMENT'),getCommonTranslation('SUCCESS'));
//    			grid.down('#btnCheckIn').setDisabled(false);
    		}
    	});
    	obj.up('window').close();
    
    },*/
    /*setCheckInWind:function(grid){
    	var $this = this;
    	var checkinlist = $this.getCheckinlist();
    	var checkinlistStore = checkinlist.getStore();
    	
    	var userWiseSearch = $this.getUserwisesearch().getForm();
    	var userWiseValues = userWiseSearch.getValues();
    	
    	
    	var grid = $this.getUserwiselist();
    	var records = grid.getSelectionModel().getSelection()[0];
    	
    	checkinlistStore.getProxy().extraParams = {
    		hostelRoomId:records.data.hostelRoomId,
    		userTypeId: userWiseValues.userType
		};
    	checkinlistStore.load();
    	
    	
    	var checkinwinForm = $this.getCheckInwin();
    	var records = grid.getSelectionModel().getSelection()[0];

    	var hostelNameField = checkinwinForm.down('#hostelName');
    	var roomTypeField = checkinwinForm.down('#roomType');
    	var roomNoField = checkinwinForm.down('#roomNo');
    	var bedNoField = checkinwinForm.down('#bedNo');

    	if (!isNullOrEmpty(records.data.hostelName)) {
    		hostelNameField.setValue(records.data.hostelName);
    	}

    	if (!isNullOrEmpty(records.data.roomType)) {
    		roomTypeField.setValue(records.data.roomType);
    	}
    	if (!isNullOrEmpty(records.data.roomNo)) {
    		roomNoField.setValue(records.data.roomNo);
    	}
    	
    	var bedStore = bedNoField.getStore();
    	bedStore.getProxy().extraParams = {
    		hostelRoomId:records.data.hostelRoomId
		};
    	bedStore.load();
    	
    },*/
    /*saveCheckInDetails:function(obj){

    	var $this = this;
    	var form = obj.up('form').getForm();
    	var values = form.getValues();
    	var grid = $this.getUserwiselist();
    	var userWiseSearch = $this.getUserwisesearch().getForm();
    	var userWiseValues = userWiseSearch.getValues();
    	var grid = $this.getUserwiselist();
    	var records = grid.getSelectionModel().getSelection()[0];
    	
    	var checkinlist = $this.getCheckinlist();
//    	var cancelallotmentrecords = cancelallotmentlist.getSelectionModel().getSelection()[0];
    	

    	var allotmentsIds=[];
    	checkinlistRecord  = checkinlist.selModel.getSelection();
    		for(var i=0; i< checkinlistRecord.length; i++){
    			allotmentsIds.push(checkinlistRecord[i].data.id);
    			
    	}
    							
    		var data = {
    				"hostelBedId": values.bedNo,
    				"checkInDate": values.checkInDate,
    				"expectedCheckOutDate": values.expectedCheckOutDate,
    				"keyHandoverToId": values.keyHandoverTo,
    				"keyHandoverById":values.keyHandoverBy,
    				"allotmentIds":allotmentsIds
    		};

    	var url;
    	url = SERVERURL.HOSTEL_ROOM_ALLOTMENT_CHECK_IN;

    	Ext.Ajax.request({
    		method: 'POST',
    		url: url,
    		jsonData:data,
    		success: function(response) {
    			//var data = Ext.decode(response.responseText);
    			showSuccessMessage(getHostelTranslation('CHECK_IN'),getCommonTranslation('SUCCESS'));
//    			grid.down('#btnCheckOut').setDisabled(false);
    		}
    	});
    	obj.up('window').close();
    },*/
   /* loadGridDataByCheckedInRecords:function($this, newValue, oldValue, eOpts){
    	var me = this;
    	var checkinlist = me.getCheckinlist();
    	var checkinlistStore = checkinlist.getStore();
    	
    	var userWiseSearch = me.getUserwisesearch().getForm();
    	var userWiseValues = userWiseSearch.getValues();
    	
    	
    	var grid = me.getUserwiselist();
    	var records = grid.getSelectionModel().getSelection()[0];
    	
    	
    	if(newValue == true){
    		checkinlistStore.getProxy().extraParams = {
        		hostelRoomId:records.data.hostelRoomId,
        		userTypeId: userWiseValues.userType
    		};
        	checkinlistStore.load();	
    	}else{
    		checkinlistStore.getProxy().extraParams = {
        		hostelRoomId:records.data.hostelRoomId,
        		userTypeId: userWiseValues.userType,
        		allotmentStatus:'ALLOTTED'
    		};
        	checkinlistStore.load();
    	}
    	
    },
    setCheckOutWind:function(){
    	var $this = this;

    	var checkoutlist = $this.getCheckoutlist();
    	var checkoutlistStore = checkoutlist.getStore();

    	var userWiseSearch = $this.getUserwisesearch().getForm();
    	var userWiseValues = userWiseSearch.getValues();


    	var grid = $this.getUserwiselist();
    	var records = grid.getSelectionModel().getSelection()[0];

    	checkoutlistStore.getProxy().extraParams = {
    		hostelRoomId:records.data.hostelRoomId,
    		userTypeId: userWiseValues.userType
    	};
    	checkoutlistStore.load();


    	var checkoutwinForm = $this.getCheckoutwin();
    	var records = grid.getSelectionModel().getSelection()[0];

    	var hostelNameField = checkoutwinForm.down('#hostelName');
    	var roomTypeField = checkoutwinForm.down('#roomType');
    	var roomNoField = checkoutwinForm.down('#roomNo');

    	if (!isNullOrEmpty(records.data.hostelName)) {
    		hostelNameField.setValue(records.data.hostelName);
    	}

    	if (!isNullOrEmpty(records.data.roomType)) {
    		roomTypeField.setValue(records.data.roomType);
    	}
    	if (!isNullOrEmpty(records.data.roomNo)) {
    		roomNoField.setValue(records.data.roomNo);
    	}


    	var keyReturnedToField = checkoutwinForm.down('#keyReturnedTo');
    	var store = keyReturnedToField.getStore();
    	store.load({
    		callback: function(records, operation, success) {
    			if (success) {
    				if(records.length > 0){
    					keyReturnedToField.setValue($this.getCurrentlyLoggedInUser().id);
    				}		 
    			}
    		}	   
    	});
    },
    saveCheckOutDetails:function(obj){

    	var $this = this;
    	var form = obj.up('form').getForm();
    	var values = form.getValues();
    	
    	var checkoutlist = $this.getCheckoutlist();
//    	var cancelallotmentrecords = cancelallotmentlist.getSelectionModel().getSelection()[0];
    	

    	var allotmentsIds=[];
    	checkoutlistRecord  = checkoutlist.selModel.getSelection();
    		for(var i=0; i< checkoutlistRecord.length; i++){
    			allotmentsIds.push(checkoutlistRecord[i].data.id);
    			
    	}
    							
    		var data = {
    				"checkOutDate": values.checkInDate,
    				"keyReturnedToId": values.keyReturnedTo,
    				"hostelCheckoutReasonId":values.checkOutReason,
    				"allotmentIds":allotmentsIds
    		};

    	var url;
    	url = SERVERURL.HOSTEL_ROOM_ALLOTMENT_CHECK_OUT;

    	Ext.Ajax.request({
    		method: 'POST',
    		url: url,
    		jsonData:data,
    		success: function(response) {
    			//var data = Ext.decode(response.responseText);
    			showSuccessMessage(getHostelTranslation('CHECK_OUT'),getCommonTranslation('SUCCESS'));
    		}
    	});
    	obj.up('window').close();
    }*/
    
	showAllottedDetails:function(grid, rowIndex, record){
		var $this = this;
		
		var allottedWin = $this.getAllottedDetailsWin();
		if (!allottedWin) {
			Ext.widget('allottedDetailsWin');
			allottedWin = $this.getAllottedDetailsWin();
		}
		allottedWin.show();
		
		var userWiseSearchForm = $this.getUserwisesearch().getForm();
    	var userWiseValues = userWiseSearchForm.getValues();

		var store = $this.getAllottedDetailsGrid().getStore();
		store.getProxy().extraParams = {
			hostelRoomId:record.data.hostelRoomId,
			userTypeId:userWiseValues.userType
		};
		store.load();
	},
	
	doAccessControlCustomBtnValidation: function(grid,permissionsMap) {
	    	
	    	var associatedAcadLocationIds = new Array();
	    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	    
			var alloteRoomBtn = grid.down('#btnAllotRoom');
	    	
			alloteRoomBtn.setVisible(false);
	    	
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'ALLOTEROOM') {
	    			alloteRoomBtn.setVisible(true);
	        	}
	    	});
	    },
	    disableManageAllocationImportTab:function(structure,permissionsMap){
	      	 var associatedAcadLocationIds = new Array();
	      	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	      	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	      	 var mamnageAllocationCheckInImportTab=false;
	         var manageAllotmentImportTab=false;
	      	 
	      	 for (var i = 0; i < permissionList.length; i++) {
	      		 if (permissionList[i] === "IMPORT_HOSTEL_ROOM_ALLOCATION") {
	      			mamnageAllocationCheckInImportTab=true;
	      		 }
	      		 if (permissionList[i] === "IMPORT_HOSTEL_ROOM_ALLOTMENT") {
	      			manageAllotmentImportTab=true;
		      		 }
	      	 }
	      	 this.showmManageAllocationCheckInImportTab(mamnageAllocationCheckInImportTab,manageAllotmentImportTab, structure);
	       },
	    showmManageAllocationCheckInImportTab : function(mamnageAllocationCheckInImportTab,manageAllotmentImportTab, structure) {
	      	 var panelItem = new Array();
	      	 var $this = this;
	      	 var newcont=structure.items.items.length;
	      	 var insertPosition=newcont+1;
	      		 panelItem.push({
	      			 xtype:'tabpanel',
	      			 itemId:'allVisibleTP',
	      			 plain: true,
	      			 style:{overflow:'hidden !important',margin:'0!important'},
	      			 
	      			 frame: false,
	      			 border:false,
	      			 defaults: {
	      				 labelAlign: 'top'
	      			 },
	      			 items:[{
		      				title :getCommonTranslation('SEARCH'),  
		      				xtype:'panel',
		      				items : [/*{
		      					xtype : 'radiogroup',
		      					itemId:'allocationType',
		      					defaults: {
		      						labelAlign:'top',
		      						width:256
		      					},
		      					items : [{
		      						boxLabel : getHostelTranslation('USER_WISE'),
		      						name:'allocationType',
		      						inputValue : 'USER_WISE',
		      						checked : true
		      					},{
		      						boxLabel : getHostelTranslation('ROOM_WISE'),
		      						name:'allocationType',	
		      						inputValue : 'ROOM_WISE'

		      					}]
		      				},*/{
		      					xtype: 'userwisesearch',
		      					itemId: 'userwisesearch',
		      				},{
		      					xtype: 'roomwisesearch',
		      					itemId: 'roomwisesearch',
		      					hidden:true,
		      				},{
		      				xtype:'userwiselist',
		      				itemId:'userwiselist'
		      			},{
		      				xtype:'roomwiselist',
		      				itemId:'roomwiselist',
		      				hidden:true
		      			}]
		      			}/*,{
		      				xtype:'panel',
		      				title :getCommonTranslation('IMPORT_HOSTEL_ROOM_ALLOCATION'),
		      				cls:'panelNoSpace',
		      				items:[{
		      			 		xtype: 'importroomallocation',
		      			 		itemId: 'importroomallocationId'
		      			 	}]
		      			}*/]
	      		 });
	      		Ext.Ajax.request({
					type: 'rest',
		 			url: SERVERURL.HOSTEL_OPT_IN, 
		 			method: 'GET',
		 			async:false,
		 			success: function(res, action) {
		 				var response = JSON.parse(res.responseText);
		 				$this.HostelResponse = JSON.parse(res.responseText);
		 				var insertAt = panelItem["0"].items.length;
		 				if(($this.HostelResponse && $this.HostelResponse.length) && ($this.HostelResponse[0].value == 'yes' || $this.HostelResponse[0].value == 'YES' || $this.HostelResponse[0].value == 'Yes' || $this.HostelResponse[0].value == 'YEs')){
		 		    		if (mamnageAllocationCheckInImportTab) {
		 		    			panelItem["0"].items[insertAt] = {
		 		    					xtype: 'importroomallocation',
		 		      			 		itemId: 'importroomallocationId'
		 		    			};
		 		    			insertAt = insertAt + 1;
		 		    		}
						}
						else{
							if (manageAllotmentImportTab) {
		 		    			panelItem["0"].items[insertAt] = {
		 		    					xtype: 'importhostelroomallotmentloader',
		 		      			 		itemId: 'importhostelroomallotmentloaderId'
		 		    			};
		 		    		}
						}
		 				structure.insert(insertPosition,panelItem);
		 			}
				});
	       },
	       loadImportHostelRoomAllocationGrid : function(){
	   		var $this = this;
	   		var grid = this.getImportroomallocationlist();
	   		var form  = $this.getUploadoptionradiogroup();
	   		var isUploadAll = form.items.items[0].getValue().isUploadAll;
	   		$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_HOSTEL_ROOM_ALLOCATION');
	   	},
	    getDownloadFile : function(documentId,fileType){

	    	if(!isNullOrEmpty(documentId)){
	    		var csvForm = Ext.create('Ext.form.Panel'); 
	    		csvForm.getForm().submit({
	    			target: '_blank',
	    			method:'POST',
	    			params :{
	    				access_token : Ext.Ajax.defaultHeaders.access_token
	    			},
	    			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	    			url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
	    			standardSubmit :true
	    		});
	    	}
	    },
});
