/**
 * @author Shashank Jain
 *  
 */
Ext.define('Academia.controller.hrm.EmployeePatentReportController', {
	extend: 'Academia.controller.base.BaseController',
	mixins : {
		extend: 'Academia.controller.personinfo.common.PersonPastHistoryController',
	},

	models:['hrm.report.EmployeePatentDetailsReportGridModel'],

	stores:['coursetransaction.sectionmanagement.EmployeeIdValueSmartSearch','Academia.store.facilitiesresources.resourcebooking.departmentFilterStore',
		'Academia.store.common.StatusComboStore','hrm.report.EmployeePatentDetailsReportGridStore','personinfo.common.pasthistory.PatentTypeStore','coursetransaction.sectionmanagement.EmployeeIdValueSmartSearch'],

		views: ['hrm.report.EmployeePatentReportStructure','hrm.report.EmployeePatentReportFilter','hrm.report.EmployeePatentReportGrid',
			'personinfo.common.pasthistory.PatentDocumentViewForm','servicerequest.infirmary.PatentDetailsSupervisorrWindow','personinfo.common.PersonCommonWindow'],

			refs: [{
				ref:'employeepatentreportstructure',
				selector:'employeepatentreportstructure'
			},{
				ref:'employeepatentreportfilter',
				selector:'employeepatentreportfilter'
			},{
				ref:'employeepatentreportgrid',
				selector:'employeepatentreportgrid'
			},{
				ref: 'personPatentDocumentViewForm',
				selector: 'patentdocumentviewform[itemId=facultyPatentDocumentViewForm]'
			},{
				ref:'patentdetailssupervisorrwindow',
				selector:'patentdetailssupervisorrwindow'
			},{
				ref: 'personCommonWindow',
				selector: 'personcommonwindow'
			}],
config: {
			    	EMPLOYEE_PATENT_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EMPLOYEE_PATENT_REPORT_PRIVILEGES'),
},

			init: function(application) {
				this.control({
					'employeepatentreportfilter button[itemId=empPatentSearchButtonId]' : {
						click : this.loadEmpPatentMasterGridData
					},'employeepatentreportfilter button[itemId=empPatentClearSearch]' : {
						click : this.resetFormData
					},
					'employeepatentreportgrid': {
						cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {

							var searchResultGrid =  grid.ownerCt;
							var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;

							if(columnName=='noOfdocument'){
								if (e.target.tagName == 'A') {
									this.showPersonCommonWindow('PATENT_VIEW_DOCUMENT', 'facultyPatentDocumentViewForm');
									var form = this.getPersonPatentDocumentViewForm();
									var grid = form.down('#patentdocumentviewId');
									this.loadDocumnetGrid(record,grid);
								}
							}
							if(columnName=='supervisorId'){
								if (e.target.tagName == 'A') {
									this.loadSupervisorGrid(record,grid);
								}
							}
						}
					},
					'patentdocumentviewform[itemId=facultyPatentDocumentViewForm] patenttypedocument': {
						cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
							var $this = this;
							var documentGrid =  grid.ownerCt;
							var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

							if (columnName == "documentName") {
								if (e.target.tagName == 'A') {
									var documentId = record.get("documentId");
									if (!isNullOrEmpty(documentId)) {
										$this.getDocumentController().downloadDocumentFile(documentId);
									}
								}
							}
						}
					},
				});
			}, 
			loadEmpPatentMasterGridData:function(obj){
				var $this=this;
				var form = obj.up('form');
				var getForm = form.getForm();
				var getFormValues=getForm.getValues();

				var grid=$this.getEmployeepatentreportgrid();
				var store = grid.getStore();

				store.getProxy().extraParams = {
					empId:getFormValues.FACULTY_CODE,
					deptId:getFormValues.DEPARTMENT,
					patentTypeId:getFormValues.patentType,
					patentFiledFromDate:getFormValues.patentFiledFromDate,
					patentFiledToDate:getFormValues.patentFiledToDate,
					patentAwardFromDate:getFormValues.patentAwardedFromDate,
					patentAwardToDate:getFormValues.patentAwardedToDate,
				}
				$this.resetPageSetting(store);
				store.load();
				grid.getSelectionModel().deselectAll(true);
				/*pdf & excel report header filter*/
				grid.config.searchFilterForm = form;
			},resetFormData:function(){
				var $this=this;
				var form = $this.getEmployeepatentreportfilter();
				var getForm=form.getForm();
				getForm.reset();
				var patentFileFromDate = form.down('#patentFiledFromDate');
	            var patentFiletllDate = form.down('#patentFiledToDate');
	            patentFileFromDate.setMinValue(false);
	            patentFiletllDate.setMinValue(false);
	            patentFileFromDate.setMaxValue(false);
	            patentFiletllDate.setMaxValue(false);
	            var patentAwardFromDate = form.down('#patentAwardedFromDate');
	            var patentAwardtllDate = form.down('#patentAwardedToDate');
	            patentAwardFromDate.setMinValue(false);
	            patentAwardtllDate.setMinValue(false);
	            patentAwardFromDate.setMaxValue(false);
	            patentAwardtllDate.setMaxValue(false);
			},
			loadDocumnetGrid:function(record,grid){
				var deleteButton = grid.down('#btnDelete');
				deleteButton.setDisabled(true);
				var store = grid.getStore();
				store.getProxy().extraParams = {
					personDocumentId : record.data.id
				};
				store.load();
			},
			loadSupervisorGrid:function(record,grid){
				var formWindow = this.getPatentdetailssupervisorrwindow();
				if (formWindow==undefined) {
					formWindow=	Ext.widget('patentdetailssupervisorrwindow');
				}
				var innergrid=formWindow.down('#patentDetailsSupervisorSsGrid');
				formWindow.show();
				var store = innergrid.getStore();
				store.getProxy().extraParams = {
					patentdetailsId : record.data.id
				};
				store.load();

			},
});
