/**
 * This controller is used for the HR Management Add/Edit/Delete/View
 * 
 * 
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.controller.hrm.HRManagementController', {
    extend: 'Academia.controller.base.BaseController',
    stores: [
        'department.DepartmentAcademyLocationWiseStore',
        'userGroup.UserGroupStore',
        'hrm.HRManagementEmployeeWiseAttendanceStore',
        'hrm.HRManagementDateWiseAttendanceStore',
        'userGroup.UserGroupStore',
        'hrm.timesheet.TimesheetPeriodStore',
        'hrm.HRMEAEmployeeSmartSearchStore',
        'hrm.timesheet.HRMTEmployeeSmartSearchStore',
        'hrm.report.HRMAttendanceReportTreeStore',
        'importutility.ModuleName',
        'hrm.HRMAttendanceTemplateStore',
        'importutility.ImportEmployeeAttendanceStore',
        'hrm.timesheet.HRMTimesheetGridStore',
        'hrm.timesheet.HRMEmployeeDetailedTimesheetGridStore',
        'hrm.report.HRMAttendanceSummaryReportStore',
        'hrm.report.HRMWorkHourReportGridStore',
        'hrm.timesheet.HRMTimesheetPeriodGridStore',
        'hrm.report.HRMAttendancePunchLogReportGridStore',
        'hrm.HRMAttendanceMarkingTypeStatusStore',
        'calendar.StaffCalendarByCalendarIdStore',
        'calendar.ActiveStaffCalendarStore',
        'calendar.StaffWorkHourStore',
     //   'hrm.hrmeaemployeeattendancestatussmartsearchstore',
        'hrm.report.HRMAttendanceStatusReportGridStore',
        'hrm.AttendanceStatusStore',
        'program.ProgramByGroupIdStore',
        'program.programbatchdetail.BatchStore',
        'feeandpayment.managebill.Student',
        'hrm.report.BMStudentPunchLogReportGridStore',
        'common.ModuleAndServiceStore',
        'common.ReportTypeStore',
        'common.MonthStore',
        'common.CostCenterStore',
        'hrm.report.ICAttendanceAndPaymentConsolidatedReportGridStore',
        'hrm.report.ICAttendanceAndPaymentDetailedReportGridStore',
        'common.UserShortNameStore'
    ],
    views: ['hrm.HRManagementStructure',
        'hrm.HRManagementTabStructure',
        'hrm.HRMEmployeeAttendanceFilter',
        'hrm.HRManagementEmployeeWiseAttendanceStructure',
        'hrm.HRManagementEmployeeWiseAttendanceGrid',
        'hrm.HRManagementEmployeeWiseAttendanceSummaryGrid',
        'hrm.HRManagementDateWiseAttendanceStructure',
        'hrm.HRManagementDateWiseAttendanceGrid',
        'hrm.HRManagementDateWiseAttendanceSummaryGrid',
        'hrm.timesheet.HRMTimesheetStructure',
        'hrm.timesheet.HRMTimesheetTabStructure',
        'hrm.timesheet.HRMTimesheetFilter',
        'hrm.timesheet.HRMTimesheetGrid',
        'hrm.report.HRMAttendanceReportStructure',
        'hrm.report.HRMAttendanceSummaryReportStructure',
        'hrm.report.HRMAttendanceSummaryReportFilter',
        'hrm.report.HRMAttendanceSummaryReportGrid',
        'hrm.HRMImportEmployeeAttendanceTabStructure',
        'hrm.HRMImportEmployeeAttendanceDownloadForm',
        'hrm.HRMImportEmployeeAttendanceUploadForm',
        'importutility.ImportByModule.ImportListEmployeeAttendanceGrid',
        'hrm.timesheet.HRMEmployeeTimesheetStructure',
        'hrm.timesheet.HRMEmployeeDetailedTimesheetGrid',
        'hrm.timesheet.HRMEmployeeTimesheetSummaryGrid',
        'hrm.report.HRMWorkingHourReportStructure',
        'hrm.report.HRMWorkingHourReportFilter',
        'hrm.report.HRMWorkingHourReportGrid',
        'hrm.report.HRMAttendancePunchLogReportStructure',
        'hrm.report.HRMAttendancePunchLogReportFilter',
        'hrm.report.HRMAttendancePunchLogReportGrid',
        'hrm.report.HRMAttendanceStatusReportStructure',
        'hrm.report.HRMAttendanceStatusReportFilter',
        'hrm.report.HRMAttendanceStatusReportGrid',        
        'UploadOptionRadioGroup',
        'hrm.timesheet.HRMTimesheetPeriodStructure',
        'hrm.timesheet.HRMTimesheetPeriodGrid',
        'hrm.timesheet.HRMTimesheetPeriodWindow',
        'hrm.employeePortal.HRMMyTimesheetStructure',
        'hrm.employeePortal.HRMMyTimesheetTabStructure',
        'hrm.employeePortal.HRMMyTimesheetFilter',
        'hrm.employeePortal.HRMMyTimesheetGrid',
        'hrm.employeePortal.HRMMyAttendanceStructure',
        'hrm.employeePortal.HRMMyAttendanceTabStructure',
        'hrm.employeePortal.HRMMyAttendanceFilter',
        'hrm.employeePortal.HRMMyPunchLogTabStructure',
        'hrm.employeePortal.HRMMyPunchLogFilter',
        'hrm.employeePortal.HRMMyPunchLogGrid',
        'personinfo.faculty.StaffWorkHoursGrid',
        'calendar.EmployeeWorkHoursWindow',
        'hrm.report.HRMWorkingHourTabDetail',
        'calendar.AssignWorkCalendarWindow',
        'hrm.report.BMStudentPunchLogReportStructure',
        'hrm.report.BMStudentPunchLogReportGrid',
        'hrm.report.BMStudentPunchLogReportFilter',
        'hrm.ICAttendanceAndPaymentReport.ICAttendanceAndPaymentReportFilter',
        'hrm.ICAttendanceAndPaymentReport.ICAttendanceAndPaymentReportTabStructure',
        'hrm.ICAttendanceAndPaymentReport.ICAttendanceAndPaymentReportStructure',
        'hrm.ICAttendanceAndPaymentReport.ICAttendanceAndPaymentConsolidatedReportGrid',
        'hrm.ICAttendanceAndPaymentReport.ICAttendanceAndPaymentDetailedReportGrid'
    ],
    requires: ['Academia.utilities.ux.Notification'],
    models: ['hrm.HRManagementEmployeeAttendanceUpdateModel','hrm.report.HRMAttendanceSummaryReportModel',
    		'hrm.report.HRMAttendancePunchLogReportGridModel','hrm.report.HRMAttendanceStatusReportGridModel'],
    refs: [{
        ref: 'contentpanel',
        selector: 'contentpanel'
    },{
        ref: 'hrmemployeeattendancefilter',
        selector: 'hrmemployeeattendancefilter'
    }, {
        ref: 'hrmanagementemployeewiseattendancestructure',
        selector: 'hrmanagementemployeewiseattendancestructure'
    }, {
        ref: 'hrmanagementdatewiseattendancestructure',
        selector: 'hrmanagementdatewiseattendancestructure'
    }, {
        ref: 'hrmanagementemployeewiseattendancegrid',
        selector: 'hrmanagementemployeewiseattendancegrid'
    }, {
        ref: 'hrmanagementdatewiseattendancegrid',
        selector: 'hrmanagementdatewiseattendancegrid'
    }, {
        ref: 'hrmtimesheetfilter',
        selector: 'hrmtimesheetfilter'
    }, {
    	ref: 'hrmattendancereportstructure',
        selector: 'hrmattendancereportstructure'
    }, {
    	ref: 'hrmattendancesummaryreportstructure',
        selector: 'hrmattendancesummaryreportstructure'
    }, {
    	ref: 'hrmattendancesummaryreportfilter',
        selector: 'hrmattendancesummaryreportfilter'
    },{
    	ref: 'hrmattendancesummaryreportgrid',
        selector: 'hrmattendancesummaryreportgrid'
    },{
    	ref: 'hrmimportemployeeattendancedownloadform',
        selector: 'hrmimportemployeeattendancedownloadform'
    },{
    	ref: 'importlistemployeeattendancegrid',
        selector: 'importlistemployeeattendancegrid'
    },{
    	ref: 'hrmimportemployeeattendanceuploadform',
        selector: 'hrmimportemployeeattendanceuploadform'
    },{
    	ref: 'hrmtimesheetgrid',
        selector: 'hrmtimesheetgrid'
    },{
    	ref: 'hrmemployeetimesheetstructure',
        selector: 'hrmemployeetimesheetstructure'
    },{
    	ref: 'hrmemployeedetailedtimesheetgrid',
        selector: 'hrmemployeedetailedtimesheetgrid'
    },{
    	ref: 'hrmemployeetimesheetsummarygrid',
        selector: 'hrmemployeetimesheetsummarygrid'
    },{
    	ref: 'hrmworkinghourreportstructure',
        selector: 'hrmworkinghourreportstructure'
    },{
    	ref: 'hrmworkinghourreportfilter',
        selector: 'hrmworkinghourreportfilter'
    },{
    	ref: 'hrmworkinghourreportgrid',
        selector: 'hrmworkinghourreportgrid'
    },{
    	ref: 'uploadoptionradiogroup',
        selector: 'uploadoptionradiogroup[itemId=hrmEmployeeAttendanceUploadOptionRadioGroupItemId]'
    },{
    	ref: 'hrmtimesheetperiodstructure',
        selector: 'hrmtimesheetperiodstructure'
    },{
    	ref: 'hrmtimesheetperiodgrid',
        selector: 'hrmtimesheetperiodgrid'
    },{
    	ref: 'hrmtimesheetperiodwindow',
        selector: 'hrmtimesheetperiodwindow'
    },{
    	ref: 'hrmmytimesheetstructure',
        selector: 'hrmmytimesheetstructure'
    },{
    	ref: 'hrmmytimesheettabstructure',
        selector: 'hrmmytimesheettabstructure'
    },{
    	ref: 'hrmmytimesheetfilter',
        selector: 'hrmmytimesheetfilter'
    },{
    	ref: 'hrmmytimesheetgrid',
        selector: 'hrmmytimesheetgrid'
    },{
    	ref: 'hrmmyattendancestructure',
        selector: 'hrmmyattendancestructure'
    },{
    	ref: 'hrmmyattendancetabstructure',
        selector: 'hrmmyattendancetabstructure'
    },{
    	ref: 'hrmmyattendancefilter',
        selector: 'hrmmyattendancefilter'
    },{
    	ref: 'hrmattendancepunchlogreportstructure',
        selector: 'hrmattendancepunchlogreportstructure'
    },{
    	ref: 'hrmattendancepunchlogreportfilter',
        selector: 'hrmattendancepunchlogreportfilter'
    },{
    	ref: 'hrmattendancepunchlogreportgrid',
        selector: 'hrmattendancepunchlogreportgrid'
    },{
    	ref: 'hrmattendancestatusreportstructure',
        selector: 'hrmattendancestatusreportstructure'
    },{
    	ref: 'hrmattendancestatusreportfilter',
        selector: 'hrmattendancestatusreportfilter'
    },{
    	ref: 'hrmattendancestatusreportgrid',
        selector: 'hrmattendancestatusreportgrid'
    },{
    	ref: 'hrmmypunchlogtabstructure',
        selector: 'hrmmypunchlogtabstructure'
    },{
    	ref: 'hrmmypunchlogfilter',
        selector: 'hrmmypunchlogfilter'
    },{
    	ref: 'hrmmypunchloggrid',
        selector: 'hrmmypunchloggrid'
    },{
    	ref: 'staffworkhoursgrid',
        selector: 'staffworkhoursgrid'
    },{
    	ref :'employeeworkhourswindow',
    	selector : 'employeeworkhourswindow' 
    },{
    	ref :'hrmworkinghourtabdetail',
    	selector : 'hrmworkinghourtabdetail' 
    },{
    	ref :'assignworkcalendarwindow',
    	selector : 'assignworkcalendarwindow'
    },{
    	ref: 'bmstudentpunchlogreportfilter',
        selector: 'bmstudentpunchlogreportfilter'
    },{
    	ref: 'bmstudentpunchlogreportgrid',
        selector: 'bmstudentpunchlogreportgrid'
    },{
    	ref :'icattendanceandpaymentreportstructure',
    	selector : 'icattendanceandpaymentreportstructure'
    },{
    	ref: 'icattendanceandpaymentreportfilter',
        selector: 'icattendanceandpaymentreportfilter'
    },{
    	ref: 'icattendanceandpaymentreporttabstructure',
        selector: 'icattendanceandpaymentreporttabstructure'
    },{
    	ref: 'icattendanceandpaymentconsolidatedreportgrid',
        selector: 'icattendanceandpaymentconsolidatedreportgrid'
    },{
    	ref: 'icattendanceandpaymentdetailedreportgrid',
        selector: 'icattendanceandpaymentdetailedreportgrid'
    }],
    config: {
        EMPLOYEE_ATTENDANCE_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EMPLOYEE_ATTENDANCE_PRIVILEGES'),
        EMPLOYEE_TIMESHEET_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EMPLOYEE_TIMESHEET_PRIVILEGES'),
        EMPLOYEE_ATTENDANCE_REPORT_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EMPLOYEE_ATTENDANCE_REPORT_PRIVILEGES'),
        IMPORT_EMPLOYEE_ATTENDANCE_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('IMPORT_EMPLOYEE_ATTENDANCE_PRIVILEGES'),
        WORKING_HOUR_REPORT_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('WORKING_HOUR_REPORT_PRIVILEGES'),
        ATTENDANCE_SUMMARY_REPORT_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('HRM_ATTENDANCE_SUMMARY_REPORT_PRIVILEGES'),
        CORE_ERP_LOADER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_LOADER_PRIVILEGES'),
        HRM_TIMESHEET_PERIOD_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('HRM_TIMESHEET_PERIOD_PRIVILEGES'),
        ATTENDANCE_PUNCH_LOG_REPORT_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ATTENDANCE_PUNCH_LOG_REPORT_PRIVILEGES'),
        HRM_FP_MY_ATTENDANCE_PUNCH_LOG_TAB_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('HRM_FP_MY_ATTENDANCE_PUNCH_LOG_TAB_PRIVILEGES'),
        LM_FP_MY_TIMESHEET_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('LM_FP_MY_TIMESHEET_PRIVILEGES'),
        LM_FP_MY_ATTENDANCE_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('LM_FP_MY_ATTENDANCE_PRIVILEGES'),
        FACULTY_WORK_HOURS_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_WORK_HOURS_PRIVILEGES'),
        ATTENDANCE_STATUS_REPORT_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ATTENDANCE_STATUS_REPORT_PRIVILEGES'),
        STUDENT_PUNCH_LOG_REPORT_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PUNCH_LOG_REPORT_PRIVILEGES'),
        HRM_FP_MY_ATTENDANCE_AND_PAYMENT_REPORT_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('HRM_FP_MY_ATTENDANCE_AND_PAYMENT_REPORT_PRIVILEGES'),
    },
    init: function() {
        this.control({
            'hrmemployeeattendancefilter radiogroup[itemId=attendanceByItemId]': {
                change: function(cb, nv, ov) {
                    $this = this;
                    var filter = this.getHrmemployeeattendancefilter();
                    var lateArrivalEarlyGoingEWId = filter.down('#lateArrivalEarlyGoingEWId');
                    var lateArrivalEarlyGoingDWId = filter.down('#lateArrivalEarlyGoingDWId');
                    var employeeItemId = filter.down('#employeeItemId');
                    var startDateItemId = filter.down('#startDateItemId');
                    var endDateItemId = filter.down('#endDateItemId');

                    var departmentItemId = filter.down('#departmentItemId');
                    var userGroupItemId = filter.down('#userGroupItemId');
                    var dateItemId = filter.down('#dateItemId');
                    
                    filter.down('#markDefaultInOutBtnItemId').setDisabled(true);

                    var employeeWiseStructure = $this.getHrmanagementemployeewiseattendancestructure();
                    var dateWiseStructure = $this.getHrmanagementdatewiseattendancestructure();
                    var employeeWiseGrid = $this.getHrmanagementemployeewiseattendancegrid();
                    var dateWiseGrid = $this.getHrmanagementdatewiseattendancegrid();
                    var employeeWiseSummaryGrid = Ext.ComponentQuery.query('hrmanagementemployeewiseattendancesummarygrid')[0];
                    var summaryGrid = Ext.ComponentQuery.query('hrmanagementdatewiseattendancesummarygrid')[0];
                    employeeWiseGrid.getStore().removeAll();
                    dateWiseGrid.getStore().removeAll();
                    employeeWiseSummaryGrid.getStore().removeAll();
                    summaryGrid.getStore().removeAll()
                    employeeWiseStructure.down('#saveHRManagementEmployeeWiseAttendanceStructureItemId').setDisabled(true);
                    employeeWiseStructure.down('#resetHRManagementEmployeeWiseAttendanceStructureItemId').setDisabled(true);
                    dateWiseStructure.down('#saveHRManagementDateWiseAttendanceStructureeItemId').setDisabled(true);
                    dateWiseStructure.down('#resetHRManagementDateWiseAttendanceStructureeItemId').setDisabled(true);
                    employeeWiseGrid.down('#exportReportItemId').setDisabled(true);
                    dateWiseGrid.down('#exportReportHRMDateWiseAttendanceItemId').setDisabled(true);
                    if (nv.attendanceBy == 'EmployeeWise') {
                    	employeeWiseStructure.setVisible(true);
                        dateWiseStructure.setVisible(false);

                        employeeItemId.setVisible(true);
                        startDateItemId.setVisible(true);
                        endDateItemId.setVisible(true);
                        departmentItemId.setVisible(false);
                        userGroupItemId.setVisible(false);
                        dateItemId.setVisible(false);

                        employeeItemId.allowBlank = false;
                        startDateItemId.allowBlank = false;
                        endDateItemId.allowBlank = false;
                        dateItemId.allowBlank = true;

                        var date = new Date();
                        var startDate = new Date(date.getFullYear(), date.getMonth(), 1);
                        startDateItemId.setValue(dateRender(startDate));
                        endDateItemId.setValue(new Date());
                        dateItemId.reset();
                        
                        lateArrivalEarlyGoingEWId.reset();
                        lateArrivalEarlyGoingDWId.reset();
                        lateArrivalEarlyGoingEWId.setVisible(true);
                        lateArrivalEarlyGoingDWId.setVisible(false);
                        var contentPanelMain = this.getContentpanel();
                    	if(!isNullOrEmpty(contentPanelMain)){
                            contentPanelMain.scrollBy(0,1);
                            contentPanelMain.scrollBy(0,-1);
                        }
                    } else {
                    	employeeWiseStructure.setVisible(false);
                        dateWiseStructure.setVisible(true);

                        employeeItemId.setVisible(false);
                        startDateItemId.setVisible(false);
                        endDateItemId.setVisible(false);
                        departmentItemId.setVisible(true);
                        userGroupItemId.setVisible(true);
                        dateItemId.setVisible(true);

                        employeeItemId.allowBlank = true;
                        startDateItemId.allowBlank = true;
                        endDateItemId.allowBlank = true;
                        dateItemId.allowBlank = false;

                        startDateItemId.reset();
                        endDateItemId.reset();
                        filter.down('#dateItemId').setValue(new Date());
                        
                        lateArrivalEarlyGoingEWId.reset();
                        lateArrivalEarlyGoingDWId.reset();
                        lateArrivalEarlyGoingEWId.setVisible(false);
                        lateArrivalEarlyGoingDWId.setVisible(true);
                        
                        var contentPanelMain = this.getContentpanel();
                    	if(!isNullOrEmpty(contentPanelMain)){
                            contentPanelMain.scrollBy(0,1);
                            contentPanelMain.scrollBy(0,-1);
                        }
                    }
                    dateWiseGrid.columnManager.headerCt.removeCls('gridFixHeader');
                    summaryGrid.columnManager.headerCt.removeCls('gridFixHeader');
                    if(dateWiseGrid.dockedItems.items[0]){
                       dateWiseGrid.dockedItems.items[0].removeCls('gridFixHeader'); 
                    }
                    if(dateWiseGrid.dockedItems.items[2]){
                       dateWiseGrid.dockedItems.items[2].removeCls('gridFixHeader'); 
                    }
                    if(summaryGrid.dockedItems.items[0]){
                       summaryGrid.dockedItems.items[0].removeCls('gridFixHeader');  
                    }
                    var hrMgmtTabStructure = contentPanelMain.down('hrmanagementtabstructure');
                    if(!isNullOrEmpty(hrMgmtTabStructure)){
                    	hrMgmtTabStructure.scrollBy(0,1);
                    	hrMgmtTabStructure.scrollBy(0,-1);
                    }
                    employeeItemId.reset();
                    departmentItemId.reset();
                    userGroupItemId.reset();
                    filter.getForm().isValid();
                }
            },
 	       
            'hrmemployeeattendancefilter button[itemId=searchBtnHRMEmployeeAttendanceFilterItemId]': {
            	click: function() {
            		this.loadAttendanceWiseGrid();
            	}
            },
            'hrmemployeeattendancefilter button[itemId=resetBtnHRMEmployeeAttendanceFilterItemId]': {
                click: function() {
                    var $this = this;
                    var filter = $this.getHrmemployeeattendancefilter();
                    var selectionTypeItemId = filter.down('#attendanceByItemId');
                    var selectionTypeValue = selectionTypeItemId.getValue().attendanceBy;
                    filter.getForm().reset();
                    var date = new Date();

                    if(selectionTypeValue == 'EmployeeWise'){
                    	selectionTypeItemId.setValue({
                    		attendanceBy: 'EmployeeWise'
                    	});
                    	var startDate = new Date(date.getFullYear(), date.getMonth(), 1);
                    	filter.down('#startDateItemId').setValue(dateRender(startDate));
                    	filter.down('#endDateItemId').setValue(new Date());
                    }else{
                    	selectionTypeItemId.setValue({
                    		attendanceBy: 'DateWise'
                    	});
                    }
                    filter.down('#markDefaultInOutBtnItemId').setDisabled(true);

                    var employeeWiseGrid = $this.getHrmanagementemployeewiseattendancegrid();
                    var dateWiseGrid = $this.getHrmanagementdatewiseattendancegrid();
                // employeeWiseGrid.getStore().removeAll();
                  // dateWiseGrid.getStore().removeAll();

                    var employeeWiseStructure = $this.getHrmanagementemployeewiseattendancestructure();
                    var dateWiseStructure = $this.getHrmanagementdatewiseattendancestructure();
                    employeeWiseStructure.down('#saveHRManagementEmployeeWiseAttendanceStructureItemId').setDisabled(true);
                    employeeWiseStructure.down('#resetHRManagementEmployeeWiseAttendanceStructureItemId').setDisabled(true);
                    dateWiseStructure.down('#saveHRManagementDateWiseAttendanceStructureeItemId').setDisabled(true);
                    dateWiseStructure.down('#resetHRManagementDateWiseAttendanceStructureeItemId').setDisabled(true);
                    employeeWiseGrid.down('#exportReportItemId').setDisabled(true);
                    dateWiseGrid.down('#exportReportHRMDateWiseAttendanceItemId').setDisabled(true);
                    
                    var grid = this.getHrmanagementemployeewiseattendancegrid();
                    var exportButton = grid.down('#exportReportItemId');
                    if(!isNullOrEmpty(exportButton)){
                    	exportButton.setDisabled(true);	
                    }
                }
            },
            'hrmemployeeattendancefilter': {
                render: function(obj, value) {
                    var filter = this.getHrmemployeeattendancefilter();
                    var dateItemId = filter.down('#dateItemId');
                    dateItemId.allowBlank = true;
                },
                afterrender: function(obj, value) {
                    var filter = this.getHrmemployeeattendancefilter();
                    var date = new Date();
                    var startDate = new Date(date.getFullYear(), date.getMonth(), 1);
                    filter.down('#attendanceByItemId').items.items[1].setValue(true);
                    filter.down('#startDateItemId').setValue(dateRender(startDate));
                    filter.down('#endDateItemId').setValue(new Date());
                }
            },
            'hrmemployeeattendancefilter combo#departmentItemId': {
                render: function(obj) {
                    $this = this;
                    var store = obj.getStore();
                    var academyLocationId = $this.getCurrentAcademyLocation();
                    store.getProxy().extraParams = {
                        academyLocationsIds: academyLocationId
                    };
                    store.load();
                }
            },
            'hrmanagementemployeewiseattendancestructure': {
                afterrender: function(form) {
                	var portalId = this.getCurrentLoggedPortalId();
                	if (portalId == 1){
                		this.doAccessHRMEmployeeAttendanceSave('EmployeeWise', this.getEMPLOYEE_ATTENDANCE_PERMISSION(), form);
                	}
                	else if(portalId == 2){
                		this.doAccessHRMEmployeeAttendanceSave('EmployeeWise', this.getLM_FP_MY_ATTENDANCE_PERMISSION(), form);
                		form.down('#saveHRManagementEmployeeWiseAttendanceStructureItemId').setVisible(false);
                		form.down('#resetHRManagementEmployeeWiseAttendanceStructureItemId').setVisible(false);
                	}
                }
            },
            'hrmanagementdatewiseattendancestructure': {
                afterrender: function(form) {
                    this.doAccessHRMEmployeeAttendanceSave('DateWise', this.getEMPLOYEE_ATTENDANCE_PERMISSION(), form);
                }
            },
            'hrmanagementemployeewiseattendancegrid': {
                beforerender: function() {
                    this.getStore('hrm.HRManagementEmployeeWiseAttendanceStore').removeAll();
                }
            },
            'hrmanagementdatewiseattendancegrid': {
                beforerender: function() {
                    this.getStore('hrm.HRManagementDateWiseAttendanceStore').removeAll();
                }
            },
            'hrmanagementemployeewiseattendancestructure button[itemId=saveHRManagementEmployeeWiseAttendanceStructureItemId]': {
                click: this.saveEmployeeWiseAttendance
            },
            'hrmanagementemployeewiseattendancestructure button[itemId=resetHRManagementEmployeeWiseAttendanceStructureItemId]': {
                click: function() {
                    this.loadAttendanceWiseGrid();
                }
            },
            'hrmanagementdatewiseattendancestructure button[itemId=saveHRManagementDateWiseAttendanceStructureeItemId]': {
                click: this.saveDateWiseAttendance
            },
            'hrmanagementdatewiseattendancestructure button[itemId=resetHRManagementDateWiseAttendanceStructureeItemId]': {
                click: function() {
                    this.loadAttendanceWiseGrid();
                }
            },
            'hrmtimesheetfilter nestedJsonCombo#departmentItemId': {
                render: function(obj) {
                    var store = obj.getStore();
                    var academyLocationId = this.getCurrentAcademyLocation();
                    store.getProxy().extraParams = {
                        academyLocationsIds: academyLocationId
                    };
                    store.load();
                }
            },
            'hrmtimesheetfilter button[itemId=resetHRMTimesheetFilterItemId]': {
                click: function() {
                    var filter = this.getHrmtimesheetfilter();
                    filter.getForm().reset();
                }
            },
            'hrmtimesheetfilter button[itemId=searchHRMTimesheetFilterItemId]': {
                click: function() {
                	this.loadTimesheetGridData();
                }
            },
            'hrmtimesheetgrid button[itemId=approveTimesheetItemId]' : {
            	click :function() {
            		this.approveOrGenerateTimeSheet('Approved');
            	}
            },
            'hrmtimesheetgrid button[itemId=generateTimesheetItemId]' : {
            	click :function() {
            		this.approveOrGenerateTimeSheet('Generated');
            	}
            },
            'hrmtimesheetgrid button[itemId=downloadTimesheetItemId]' : {
            	click :function() {
            		this.downloadTimeSheetRecord();
            	}
            },
            'hrmtimesheetperiodgrid' : {
            	render :function(grid) {
        			this.doAccessControlValidation(grid, this.getHRM_TIMESHEET_PERIOD_PERMISSION());
            		var store = grid.getStore();
            		this.resetPageSetting(store);
            		store.getProxy().extraParams = {
    		        	limit : CONSTANTS.DEFAULT_PAGESIZE
    		    	}
            		store.load();
            	}
            },
            'hrmtimesheetperiodgrid button[itemId=btnAdd]':{
    			click: this.addHRMTimesheetPeriodWindow
    		},
            'hrmtimesheetperiodgrid button[itemId=btnEdit]': {
    			click: function() {
    				this.editHRMTimesheetPeriod(false);
    			}
    		},
    		'hrmtimesheetperiodgrid button[itemId=btnView]': {
    			click: function() {
    				this.editHRMTimesheetPeriod(true);
    			}
    		},
    		'hrmtimesheetperiodgrid button[itemId=btnDelete]': {
    			click: function() {
    				this.deleteHRMTimesheetPeriod();
    			}
    		},
    		'hrmtimesheetperiodwindow button[itemId=btnCancelTimesheetPeriodForm]': {
                click: this.cancelHRMTimesheetPeriodForm
            },
            'hrmtimesheetperiodwindow button[itemId=btnSaveTimesheetPeriodForm]': {
                click: function() {
                	this.saveHRMTimesheetPeriod();
                }
            },
            'hrmtimesheetperiodwindow radiogroup[itemId=timesheetPeriodTypeItemId]': {
            	change: function(obj, newValue, oldValue, eOpts ) {
            		var grid = this.getHrmtimesheetperiodgrid();
            		var win = this.getHrmtimesheetperiodwindow();
            		var daysField = win.down('#daysItemId');
            		if(newValue.timesheetPeriodType != 'FIXED') {
            			daysField.setVisible(false);
            			daysField.reset();
            		} else {
            			win.down('#daysItemId').setVisible(true);
            			if (grid.getSelectionModel().getCount() > 0) {
            				var records = grid.getSelectionModel().getSelection();
            				if(records[0].data.timesheetPeriodType == 'FIXED') {
            					daysField.setValue(records[0].data.days)
            				}
            			}
            		}
            	}
            },
            'hrmtimesheetgrid': {
            	beforerender: function() {
    				this.getStore('hrm.timesheet.HRMTimesheetGridStore').removeAll();
    			},
                afterrender: function(form) {
                    this.doAccessHRMTimesheetGridButton(form, this.getEMPLOYEE_TIMESHEET_PERMISSION());
                },
                cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var hrmtimesheetgrid = this.getHrmtimesheetgrid();
                    var columnName = hrmtimesheetgrid.columnManager.columns[cellIndex].dataIndex;

                    if (columnName == 'timesheet') {
                        if (e.target.tagName == 'A') {
                            this.openEmployeeTimesheetStructure(record);
                        }
                    }
                },
                /*selectionchange:function(grid,record) {
                	var grid=this.getHrmtimesheetgrid();
                	var generateBtn=grid.down('#generateTimesheetItemId');
                    var approveBtn=grid.down('#approveTimesheetItemId');
                	if(record.length==1){
                		var msg = record[0].data.timeSheetStatus;
                        if(isNullOrEmpty(msg)){
                        	generateBtn.setDisabled(false);
                        	approveBtn.setDisabled(true);
                        }else {
                        	if(msg=="Approved"){
                        		generateBtn.setDisabled(true);
                            	approveBtn.setDisabled(true);
                        	}else if(msg=="Generated"){
                        		generateBtn.setDisabled(true);
                            	approveBtn.setDisabled(false);
                        	}
                        }
                	}else{
                		generateBtn.setDisabled(true);
                    	approveBtn.setDisabled(true);
                	}
                	
                }*/
                
            },
            'hrmemployeeattendancefilter combo#employeeItemId': {
                render: function(obj) {
                    $this = this;
                    var store = obj.getStore();
                    store.getProxy().extraParams = {
                    	isInTimeOutTimeRequired: true
                    };
                    store.load();
                }
            },
            'hrmtimesheetfilter combo#employeeItemId': {
                render: function(obj) {
                    $this = this;
                    var store = obj.getStore();
                    store.getProxy().extraParams = {
                    	isTimesheetRequired: true
                    };
                    store.load();
                }
            },
            'hrmattendancereportstructure treepanel[itemId=hrmAttendanceReportTreePanelItemId]': {
                itemclick: this.getOpenAttendanceReportStructure
            },
            'hrmattendancesummaryreportfilter nestedJsonCombo#departmentItemId': {
                render: function(obj) {
                    var store = obj.getStore();
                    var academyLocationId = this.getCurrentAcademyLocation();
                    store.getProxy().extraParams = {
                        academyLocationsIds: academyLocationId
                    };
                    store.load();
                }
            },
            'hrmattendancereportstructure': {
                render: function(structure) {
                    this.doAccessEmployeeAttendanceReport(structure, this.getEMPLOYEE_ATTENDANCE_REPORT_PERMISSION());
                }
            },
            'hrmattendancesummaryreportfilter button[itemId=resetHRMAttendanceSummaryReportFilterItemId]': {
                click: function() {
                    var filter = this.getHrmattendancesummaryreportfilter();
                    filter.getForm().reset();
                }
            },
            /* Employee Attendance Loader init :START */
            'hrmimportemployeeattendancetabstructure radiogroup[itemId=importDownloadUploadGroupItemId]': {
                change: this.employeeAttendanceDownloadUploadFormChange
            },
            'hrmimportemployeeattendancedownloadform button[itemId=hrmDownloadFormResetBtn]': {
                click: function(obj) {
                    var $this = this;
                    var form = obj.up('hrmimportemployeeattendancedownloadform').getForm();
                    form.reset();
                    var filter = this.getHrmimportemployeeattendancedownloadform();
                    var sampleTemplateNameItemId = filter.down('#sampleTemplateNameItemId');
                    sampleTemplateNameItemId.setValue('TEMPLATE_1');
                }
            },
            'hrmimportemployeeattendancedownloadform combobox#sampleTemplateNameItemId': {
            	render: function(obj) {
            		obj.getStore().load({
                        callback: function(records, operation, success) {
                        	obj.setValue('TEMPLATE_1');
                        }
                    });
            	},
                select: function(obj) {
                    /*var form = this.getHrmimportemployeeattendancedownloadform();
                    if (form.isValid()) {
                        form.down("#downoladBtnItemId").setDisabled(false);
                    } else {
                        form.down("#downoladBtnItemId").setDisabled(true);
                    }*/
                }
            },
            'hrmimportemployeeattendancedownloadform button[itemId=downoladBtnItemId]': {
                click: function(obj) {
                    var $this = this;
                    var form = obj.up('hrmimportemployeeattendancedownloadform').getForm();
                    var csvForm = Ext.create('Ext.form.Panel');
                    var values = form.getValues();
                    var sampleTemplateName = values.sampleTemplateName;
                    csvForm.getForm().submit({
                        target: '_blank',
                        method: 'POST',
                        params: {
                            access_token: Ext.Ajax.defaultHeaders.access_token,
                            templateName: sampleTemplateName
                        },
                        headers: {
                            'Authorization': Ext.Ajax.defaultHeaders.Authorization
                        },
                        url: SERVERURL.DOWNLOAD_TEMPLATE_EMPLOYEE_ATTENDANCE,
                        standardSubmit: true
                    });
                }
            },
            'hrmimportemployeeattendanceuploadform button[itemId=uploadId]': {
                click: function(obj) {
                    var $this = this;
                    var form = obj.up('hrmimportemployeeattendanceuploadform');
                    submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
    	        	$this.getHashOfFile(form);
		        	setTimeout(function() {
	                    form.getForm().submit({
	                        method: 'POST',
	                        url: submitUrl,
	                        success: function(form, action) {
	                            showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
	                        },
	                        failure: function(form, action) {
   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
	                        }
	                    });
		        	},1000);

                    Ext.defer(function() {
                        var grid = $this.getImportlistemployeeattendancegrid();
                        var form  = $this.getUploadoptionradiogroup();
	 					var isUploadAll = form.items.items[0].getValue().isUploadAll;
	 					$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Employee Attendance');
                        /*grid.getStore().getProxy().extraParams = {
                            moduleName: 'Bulk Employee Attendance'
                        };
                        grid.getStore().load();*/
                    }, 2000, this);
                }
            },
            'hrmimportemployeeattendanceuploadform uploadoptionradiogroup[itemId=hrmEmployeeAttendanceUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
            	change: function( radioGroup, newValue, oldValue, eOpts){
            		var $this = this;
            		var grid = $this.getImportlistemployeeattendancegrid();
            		var isUploadAll = newValue.isUploadAll;
            		this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Employee Attendance');
            	}
	 		   },
            'hrmimportemployeeattendanceuploadform button[itemId=resetBtn]': {
                click: function(obj) {
                    var $this = this;
                    var form = obj.up('hrmimportemployeeattendanceuploadform').getForm();
                    form.findField('file').reset();
                    var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
	 				   uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
	 					   isUploadAll: false
	 				   });
                    // form.isValid();
                },
                render: function(obj) {
                    var $this = this;
                    var form = obj.up('hrmimportemployeeattendanceuploadform').getForm();
                    var combo = form.findField('importUtilityMasterId');
                    combo.getStore().load({
                        callback: function(records, operation, success) {
                            for (var i in records) {
                                if (records[i].data.value == 'Bulk Employee Attendance') {
                                    combo.setValue(records[i].data.id);
                                    combo.setReadOnly(true);
                                }
                            }
                        }
                    });
                }
            },
            'importlistemployeeattendancegrid': {
                render: function(obj) {
                    var $this = this;
                    var grid = $this.getImportlistemployeeattendancegrid();
                    var form  = $this.getUploadoptionradiogroup();
					var isUploadAll = form.items.items[0].getValue().isUploadAll;
                    this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Employee Attendance');
                  /*  grid.getStore().getProxy().extraParams = {
                        moduleName: 'Bulk Employee Attendance'
                    };
                    grid.getStore().load();*/
                },
                cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    if (e.target.tagName == 'A') {
                        var fileType = null;
                        if (cellIndex == 1) {
                            fileType = 'successFile';
                        } else if (cellIndex == 6) {
                            fileType = 'errorFile';
                        } else if (cellIndex == 7) {
                            fileType = 'logFile';
                        }
                        var documentId = record.get("id");
                        if (!isNullOrEmpty(documentId)) {
                            this.getEmployeeAttendanceDownloadFile(documentId, fileType);
                        }
                    }
                }
            },
            'importlistemployeeattendancegrid button[itemId=btnForce]': {
                click: function(obj) {
                    var grid = this.getImportlistemployeeattendancegrid();
                    if (grid.getSelectionModel().getCount() > 0) {
                        if (grid.getSelectionModel().getCount() > 1) {
                            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
                        } else {
                            var this$ = this;
                            var id = grid.getSelectionModel().selectionStart.data.id;
                            console.log(id);
                            var urlAppend = "?jobName=" + id;
                            var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER + urlAppend;
                            Ext.Ajax.request({
                                url: submitURL,
                                method: 'GET',
                                success: function(response) {
                                    if (response.responseText === "JOB_STATUS_NOT_PENDING") {
                                        showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
                                    } else if (response.responseText === "SIMILAR_NATURE_JOB_ALREADY_RUNNING") {
                                        showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
                                    } else if (response.responseText === "SUCCESS") {
                                        showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
                                        grid.getStore().reload();
                                    }
                                }
                            });
                        }
                    } else {
                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
                    }
                }
            },
    		'hrmanagementstructure': {
    			render:function(structure){
    				this.disableImportEmployeeAttendance(structure, this.getIMPORT_EMPLOYEE_ATTENDANCE_PERMISSION());
    		 },
    		 afterrender:function(structure){
    			 var $this = this;
    			 structure.body.on('scroll', function(e, target) {
					 
    				 var pcstructure = $this.getHrmanagementemployeewiseattendancegrid();
					
					 var grid = null;
					 if(!pcstructure.isHidden()){
						 grid = $this.getHrmanagementemployeewiseattendancegrid();
					 }
					 
					 if(grid!=null){
						 $this.getGridHeaderFreeze(grid,structure,true); 
					 }
				 });
    			 structure.setActiveTab(0);
    		 }
            
    		},
    		'hrmemployeetimesheetstructure' :{
    			render : function(structure){
    				var $this = this;
    				var portalId = $this.getCurrentLoggedPortalId();
            		if (portalId == 1){
            			var grid = $this.getHrmtimesheetgrid();
        				var filter = $this.getHrmtimesheetfilter();
        				var timeSheetPeriodId = filter.down('#timesheetPeriodItemId').getValue();
        				//var employeeId = grid.getSelectionModel().getStore().data.items[0].data.empId;
        				
        				var employeeId = structure.config.employeeId;
        				Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        				Ext.Ajax.request({
        	                type: 'rest',
        	                url: SERVERURL.PATH_EMPLOYEE_TIME_SHEET,
        	                method: 'GET',
        	                params: {
        	                	timeSheetPeriodId : timeSheetPeriodId,
        	                	employeeId : employeeId
        	                	},
        	                headers: {
        	                    'Content-Type': 'application/json'
        	                },
        	                success: function(frm, action) {
        	                	var data = Ext.decode(frm.responseText);
        	                	var filter = $this.getHrmtimesheetfilter();
        	                	var detailedTimesheetGrid = $this.getHrmemployeedetailedtimesheetgrid();
        	                	var summaryTimesheetGrid = $this.getHrmemployeetimesheetsummarygrid();
        	                	//var pagingToolBar = detailedTimesheetGrid.down('custompagingtoolbar');
        	                	var detailedTimesheetStore1 = Ext.create('Academia.store.hrm.timesheet.HRMEmployeeDetailedTimesheetGridStore');
        	                	var detailedTimesheetStore2 = Ext.create('Academia.store.hrm.timesheet.HRMEmployeeDetailedTimesheetGridStore');
        	                	var personId = data.personId;
        	                	Ext.Ajax.request({
        	                        type: 'rest',
        	                        binary: true,
        	                        url: SERVERURL.PERSON_IMAGE_DOWNLOAD +'?personId='+personId,
        	                        method: 'GET',
        	                        success : function(response){
        	                        	if(response.responseBytes.length>0){
        	                        		var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
        	                        		var url = window.URL.createObjectURL(blob);
        	                        		var a= structure.down('#timesheetProfileImage');
        	                        		a.getEl().dom.src=url;
        	                        	}         	    		
        	                       }
        	                    });
        	            	
        	                	structure.down('#empId').setValue(data.code);
        	                	structure.down('#empName').setValue(data.printName);
        	                	structure.down('#empDepartment').setValue(data.department);
        	                	structure.down('#empDesignation').setValue(data.designation);
        	                	structure.down('#empSalaryMonth').setValue(filter.down('#timesheetPeriodItemId').rawValue);;
        	                	var dailyAttendanceModels = data.employeeAttendanceModel.dailyAttendanceModels;
        	                	var attendanceSummaryModels = data.employeeAttendanceModel.employeeAttendanceSummaryModel;
        	                	
        	                	detailedTimesheetStore1.removeAll();
        	                	detailedTimesheetStore1.add(dailyAttendanceModels);
        	                	
        	                	detailedTimesheetStore2.removeAll();
        	                	detailedTimesheetStore2.add(attendanceSummaryModels);
        	                	
        	                	detailedTimesheetGrid.reconfigure(detailedTimesheetStore1);
        	                	// pagingToolBar.bindStore(detailedTimesheetStore1);
        	                	summaryTimesheetGrid.reconfigure(detailedTimesheetStore2);
        	                	
        	                	detailedTimesheetGrid.getView().refresh();
        	                	summaryTimesheetGrid.getView().refresh();
        	                	$this.toggleGridSummaryRow(detailedTimesheetGrid,true);
        	                	Ext.getBody().unmask();
        	                }
        	            });
            		} 
            		else if (portalId == 2){
            			var grid = $this.getHrmmytimesheetgrid();
        				var filter = $this.getHrmmytimesheetfilter();
        				var employeeId = structure.config.employeeId;
        				var timeSheetPeriodId = structure.config.timeSheetPeriodId;
        				var timeSheetPeriodName = structure.config.timeSheetPeriodName;
        				Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        				Ext.Ajax.request({
        	                type: 'rest',
        	                url: SERVERURL.PATH_EMPLOYEE_TIME_SHEET,
        	                method: 'GET',
        	                params: {
        	                	timeSheetPeriodId : timeSheetPeriodId,
        	                	employeeId : employeeId
        	                	},
        	                headers: {
        	                    'Content-Type': 'application/json'
        	                },
        	                success: function(frm, action) {
        	                	var data = Ext.decode(frm.responseText);
        	                	var detailedTimesheetGrid = $this.getHrmemployeedetailedtimesheetgrid();
        	                	var summaryTimesheetGrid = $this.getHrmemployeetimesheetsummarygrid();
        	                	var detailedTimesheetStore1 = Ext.create('Academia.store.hrm.timesheet.HRMEmployeeDetailedTimesheetGridStore');
        	                	var detailedTimesheetStore2 = Ext.create('Academia.store.hrm.timesheet.HRMEmployeeDetailedTimesheetGridStore');
        	                	var personId = data.personId;
        	                	Ext.Ajax.request({
        	                        type: 'rest',
        	                        binary: true,
        	                        url: SERVERURL.PERSON_IMAGE_DOWNLOAD +'?personId='+personId,
        	                        method: 'GET',
        	                        success : function(response){
        	                        	if(response.responseBytes.length>0){
        	                        		var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
        	                        		var url = window.URL.createObjectURL(blob);
        	                        		var a= structure.down('#timesheetProfileImage');
        	                        		a.getEl().dom.src=url;
        	                        	}         	    		
        	                       }
        	                    });
        	            	
        	                	structure.down('#empId').setValue(data.code);
        	                	structure.down('#empName').setValue(data.printName);
        	                	structure.down('#empDepartment').setValue(data.department);
        	                	structure.down('#empDesignation').setValue(data.designation);
        	                	structure.down('#empSalaryMonth').setValue(timeSheetPeriodName);
        	                	var dailyAttendanceModels = data.employeeAttendanceModel.dailyAttendanceModels;
        	                	var attendanceSummaryModels = data.employeeAttendanceModel.employeeAttendanceSummaryModel;
        	                	
        	                	detailedTimesheetStore1.removeAll();
        	                	detailedTimesheetStore1.add(dailyAttendanceModels);
        	                	
        	                	detailedTimesheetStore2.removeAll();
        	                	detailedTimesheetStore2.add(attendanceSummaryModels);
        	                	
        	                	detailedTimesheetGrid.reconfigure(detailedTimesheetStore1);
        	                	summaryTimesheetGrid.reconfigure(detailedTimesheetStore2);
        	                	
        	                	detailedTimesheetGrid.getView().refresh();
        	                	summaryTimesheetGrid.getView().refresh();
        	                	$this.toggleGridSummaryRow(detailedTimesheetGrid,true);
        	                	Ext.getBody().unmask();
        	                }
        	            });
            		}
    			},
                afterrender: function(form) {
                	var portalId = this.getCurrentLoggedPortalId();
                	if (portalId == 1){
                		this.doAccessHRMTimesheetGridButton(form, this.getEMPLOYEE_TIMESHEET_PERMISSION());	
                	}
                }
    		},
	        'hrmemployeetimesheetstructure button#printHRMEmployeeTimesheetStructureItemId': {
	        	click: function(button) {
	        		// var grid = this.getSearchResultGrid();
	        		this.exportTimeSheetJRXML('pdf');
    			}
	        },
    		 'hrmworkinghourreportfilter combo#workingHourDepartmentItemId': {
                 render: function(obj) {
                     $this = this;
                     var store = obj.getStore();
                     var academyLocationId = $this.getCurrentAcademyLocation();
                     store.getProxy().extraParams = {
                         academyLocationsIds: academyLocationId
                     };
                     store.load();
                 }
             },
             'hrmworkinghourreportfilter button[itemId=resetHRMWorkingHourReportFilterItemId]': {
                 click: function() {
                     var filter = this.getHrmworkinghourreportfilter();
                     filter.getForm().reset();
                 }
             },
             // TO DO
             'hrmworkinghourreportfilter button[itemId=searchHRMWorkingHourReportFilterItemId]': {
                 click: function() {
                	 //Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                     this.loadHrmWorkingHourReportGridData();
                 }
             },
             'hrmworkinghourreportgrid': {
                 render: function(grid) {
                	 var store = grid.getStore();
                	 store.getProxy().extraParams = {
                 		isEmployeeWithNoCalendar: false
                 	};
                	 store.load();
                    /* $this = this;
                     var store = grid.getStore();
                     var academyLocationId = $this.getCurrentAcademyLocation();
                     store.getProxy().extraParams = {
                         academyLocationsIds: academyLocationId
                     };
                     store.load();*/
                     
                   /*  var arrayData = [
                         {"empCode":"AL", "empPrintName":"Alabama", "empGender":"Alabama", "deptName":"Alabama", "empDesignation":"Alabama", "empGroupType":"Alabama", "empEmpType":"Alabama","empWorkingDays":"5","weekDaysDetail":[{"Weekday":"Monday","InTime":"9:00","OutTime":"18:00","TotalTime":"9:00"},{"Weekday":"Tuesday","InTime":"9:00","OutTime":"18:00","TotalTime":"9:00"}]},
                         {"empCode":"AL", "empPrintName":"Alabama", "empGender":"Alabama", "deptName":"Alabama", "empDesignation":"Alabama", "empGroupType":"Alabama", "empEmpType":"Alabama","empWorkingDays":"5","weekDaysDetail":[{"Weekday":"Monday","InTime":"9:00","OutTime":"18:00","TotalTime":"9:00"},{"Weekday":"Tuesday","InTime":"9:00","OutTime":"18:00","TotalTime":"9:00"}]},
                         {"empCode":"AL", "empPrintName":"Alabama", "empGender":"Alabama", "deptName":"Alabama", "empDesignation":"Alabama", "empGroupType":"Alabama", "empEmpType":"Alabama","empWorkingDays":"5","weekDaysDetail":[{"Weekday":"Monday","InTime":"9:00","OutTime":"18:00","TotalTime":"9:00"},{"Weekday":"Tuesday","InTime":"9:00","OutTime":"18:00","TotalTime":"9:00"}]}
                     ];
                  // The data store containing the list of states
                     var store = Ext.create('Ext.data.Store', {
                         fields: ['empCode', 'empPrintName', 'empGender', 'deptName','empDesignation','empGroupType','empEmpType','empWorkingDays','weekDaysDetail']
                     });
                      
                    
                     // store.load();
                     // grid.reconfigure(store);
                      store.loadData(arrayData);
                      grid.bindStore(store);
                      
                      var custompagingtoolbar=grid.down('custompagingtoolbar');
                      if(custompagingtoolbar){
                      	custompagingtoolbar.bindStore(store);     */   	
                   //   } 
                   
                 },
                 beforerender: function(grid) {
                	 grid.getStore().removeAll();
                	 this.resetPageSetting(grid.getStore());
                 },
                 afterrender: function(form) {
                     this.doAccessWorkHourReportGridButton(form, this.getWORKING_HOUR_REPORT_PERMISSION());
                 },
                 cellclick: this.cellClickHRMWorkingHourReport
             },
             
             'hrmworkinghourreportgrid button[itemId=exportReportItemId]': {
            	 click: function(btn) {
            		 this.exportXlsEmpWorkHours();
            	 }
             },
             'hrmattendancepunchlogreportgrid': {
                 render: function(grid) {
                	 var store = grid.getStore();
                	 this.doAccessControlValidation(grid, this.getATTENDANCE_PUNCH_LOG_REPORT_PERMISSION());
                	// store.load();
                 },
                 beforerender: function(grid) {
                	 grid.getStore().removeAll();
                	 this.resetPageSetting(grid.getStore());
                 }
             },
			 'hrmattendancestatusreportgrid': {
			 	render: function(grid) {
                	var store = grid.getStore();
                    this.doAccessControlValidation(grid, this.getATTENDANCE_STATUS_REPORT_PERMISSION());
                },
                beforerender: function(grid) {
					grid.getStore().removeAll();
                	this.resetPageSetting(grid.getStore());
                }
             },
             'hrmattendancepunchlogreportgrid button[itemId=exportReportItemId]': {
            	 click: function(btn) {
            		 this.exportXlsEmpWorkHours();
            	 }
             },
    		 'hrmattendancepunchlogreportfilter combo#attendancePunchLogDepartmentItemId': {
                 render: function(obj) {
                     $this = this;
                     var store = obj.getStore();
                     var academyLocationId = $this.getCurrentAcademyLocation();
                     store.getProxy().extraParams = {
                         academyLocationsIds: academyLocationId
                     };
                     store.load();
                 }
             },
             'hrmattendancepunchlogreportfilter button[itemId=resetAttendancePunchLogReportFilterItemId]': {
            	 click: function() {
            		 var filter = this.getHrmattendancepunchlogreportfilter();
            		 filter.getForm().reset();
            		 var toDate =filter.down('#toDateItemId');
            		 toDate.setMinValue(null);
            		 toDate.setMaxValue(null);
            		 var fromDate =filter.down('#fromDateItemId');
            		 fromDate.setMaxValue(null);
            	 }
             },
             // TO DO
             'hrmattendancepunchlogreportfilter button[itemId=searchAttendancePunchLogReportFilterItemId]': {
                 click: function() {
                     this.loadAttendancePunchLogReportGridData();
                 }
             },
             'hrmattendancepunchlogreportfilter datefield[itemId=fromDateItemId]': {
                 select: function() {
                     this.changePunchLogFilterDate();
                 }
             },
             /* attendeance stautas report */
             'hrmattendancestatusreportfilter button[itemId=exportReportItemId]': {
            	 click: function(btn) {
            		 this.exportXlsEmpWorkHours();
            	 }
             },
             'hrmattendancestatusreportfilter combo#attendanceStatusReportDepartmentItemId': {
                 render: function(obj) {
                     $this = this;
                     var store = obj.getStore();
                     var academyLocationId = $this.getCurrentAcademyLocation();
                     store.getProxy().extraParams = {
                         academyLocationsIds: academyLocationId
                     };
                     store.load();
                 }
             },
             'hrmattendancestatusreportfilter button[itemId=resetAttendanceStatusReportFilterItemId]': {
            	 click: function() {
            		 var filter = this.getHrmattendancestatusreportfilter();
            		 filter.getForm().reset();
            		 var toDate =filter.down('#toDateItemId');
            		 toDate.setMinValue(null);
            		 toDate.setMaxValue(null);
            		 var fromDate =filter.down('#fromDateItemId');
            		 fromDate.setMaxValue(null);
            	 }
             },
             'hrmattendancestatusreportfilter combo#statusItemId': {
                 render: function(obj) {
                     $this = this;
                     var filter = this.getHrmattendancestatusreportfilter();
            		// filter.getForm().reset();
            		 var store = obj.getStore();
                     store.load();
                 }
             },
             
             // TO DO
             'hrmattendancestatusreportfilter button[itemId=searchAttendanceStatusReportFilterItemId]': {
                 click: function() {
                     this.loadAttendanceStatusReportGridData();
                 }
             },
             'hrmanagementemployeewiseattendancegrid button[itemId=exportReportItemId]': {
            	 click: function(btn) {
            		 this.exportXlsEmpAttendanceReport();
            	 }
             },
             'hrmanagementdatewiseattendancegrid button[itemId=exportReportHRMDateWiseAttendanceItemId]': {
            	 click: function(btn) {
            		 this.exportXlsDateWiseEmployeeAttendanceReport();
            	 }
             },
			/* Employee Attendance Loader init :END */
             'hrmattendancesummaryreportfilter button[itemId=searchHRMAttendanceSummaryReportFilterItemId]': {
                 click: function() {
                     this.loadAttendanceSummaryGrid();
                 }
             },
             'hrmemployeeattendancefilter button[itemId=markDefaultInOutBtnItemId]': {
                 click: function() {
                	 this.markDefaultInOutGrid();
                 }
                          },
             'hrmattendancesummaryreportgrid': {
                 afterrender: function(form) {
                     this.doAccessAttendanceSummaryReportGridButton(form, this.getATTENDANCE_SUMMARY_REPORT_PERMISSION());
                 }
             },
             'hrmattendancesummaryreportgrid button[itemId=attendanceRegisterItemId]': {
            	 click: function(btn) {
            		 this.exportXlsEmpAttendanceRegister();
            	 }
             },
             'hrmmytimesheetfilter button[itemId=searchHRMMyTimesheetFilterItemId]': {
                 click: function() {
                 	this.loadMyTimesheetGridData();
                 }
             },
             'hrmmytimesheetfilter button[itemId=resetHRMMyTimesheetFilterItemId]': {
                 click: function() {
                     var filter = this.getHrmmytimesheetfilter();
                     filter.getForm().reset();
                 }
             },
             'hrmmytimesheetgrid': {
            	 render:function(grid){
            		 this.doAccessControlValidation(grid, this.getLM_FP_MY_TIMESHEET_PERMISSION()); 
            	 },
            	 beforerender: function() {
            		 this.getStore('hrm.timesheet.HRMTimesheetGridStore').removeAll();
            	 },
            	 cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
            		 var hrmmytimesheetgrid = this.getHrmmytimesheetgrid();
            		 var columnName = hrmmytimesheetgrid.columnManager.columns[cellIndex].dataIndex;

            		 if (columnName == 'timesheet') {
            			 if (e.target.tagName == 'A') {
            				 this.openEmployeeTimesheetStructure(record);
            			 }
            		 }
            	 }
             },
             'hrmmyattendancefilter button[itemId=searchBtnHRMMyAttendanceFilterItemId]': {
             	click: function() {
             		this.loadMyAttendanceGrid();
             	}
             },
             'hrmmyattendancefilter button[itemId=resetBtnHRMMyAttendanceFilterItemId]': {
            	 click: function() {
            		 var $this = this;
            		 var filter = $this.getHrmmyattendancefilter();
            		 filter.getForm().reset();
            		 var date = new Date();
            		 var startDate = new Date(date.getFullYear(), date.getMonth(), 1);
            		 filter.down('#startDateItemId').setValue(dateRender(startDate));
            		 filter.down('#endDateItemId').setValue(new Date());
            		 var employeeWiseGrid = $this.getHrmanagementemployeewiseattendancegrid();
            		 employeeWiseGrid.down('#exportReportItemId').setDisabled(true);
            		 var grid = this.getHrmanagementemployeewiseattendancegrid();
            		 var exportButton = grid.down('#exportReportItemId');
            		 if(!isNullOrEmpty(exportButton)){
            			 exportButton.setDisabled(true);	
            		 }
            	 }
             },
             'hrmmyattendancefilter': {
                 afterrender: function(obj, value) {
                     var filter = this.getHrmmyattendancefilter();
                     var date = new Date();
                     var startDate = new Date(date.getFullYear(), date.getMonth(), 1);
                     filter.down('#startDateItemId').setValue(dateRender(startDate));
                     filter.down('#endDateItemId').setValue(new Date());
                     Ext.defer(function(){
                    	 if(obj.isValid()){
                        	 obj.down('#searchBtnHRMMyAttendanceFilterItemId').setDisabled(false);
                         }
                     },200)
                    
                 }
             },
             
             'hrmmypunchlogfilter': {
                 afterrender: function(obj, value) {
                     var filter = this.getHrmmypunchlogfilter();
                     var date = new Date();
                     var startDate = new Date(date.getFullYear(), date.getMonth(), 1);
                     filter.down('#startDateItemId').setValue(dateRender(startDate));
                     filter.down('#endDateItemId').setValue(new Date());
                 }
             },
             'hrmmypunchlogfilter button[itemId=resetBtnHRMMyPunchLogFilterItemId]': {
            	 click: function() {
            		 var $this = this;
            		 var filter = $this.getHrmmypunchlogfilter();
            		 filter.getForm().reset();
            		 var date = new Date();
            		 var startDate = new Date(date.getFullYear(), date.getMonth(), 1);
            		 filter.down('#startDateItemId').setValue(dateRender(startDate));
            		 filter.down('#endDateItemId').setValue(new Date());
            	 }
             },
             'hrmmyattendancestructure': {
            	 render: function(structure) {
            		 this.disableMyAttendancePunchLogTab(structure, this.getHRM_FP_MY_ATTENDANCE_PUNCH_LOG_TAB_PERMISSION());
            	 }
             },
             'hrmmypunchlogfilter button[itemId=searchBtnHRMMyPunchLogFilterItemId]': {
              	click: function() {
              		this.loadMyPunchLogGrid();
              	}
              },
              'hrmmypunchloggrid': {
                  beforerender: function(grid) {
                 	 grid.getStore().removeAll();
                 	 this.resetPageSetting(grid.getStore());
                  },
                  render: function(grid) {
                 	 this.doAccessControlValidation(grid, this.getHRM_FP_MY_ATTENDANCE_PUNCH_LOG_TAB_PERMISSION());
                  }
              },
              'staffworkhoursgrid[itemId=hrmStaffWorkingGridId]': {
            	  render: function(grid){
            		  var this$ = this;
            		  var store = grid.getStore();
            		  var userId=grid.config.userId;
            		  var personId=grid.config.personId;

            		  store.proxy.extraParams = {
            				  id : userId
            		  };
            		  this$.resetPageSetting(store);
            		  store.load();
            		  this$.doAccessControlValidation(grid, this$.getFACULTY_WORK_HOURS_PERMISSIONS()); 
            		  var portalId = this.getCurrentLoggedPortalId();
            		  if(portalId==2){
            			  grid.down('#btnEdit').setVisible(false);
            			  grid.down('#btnAdd').setVisible(false); 

            		  }
            	  },
            	  cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
            		  var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;

            		  if(columnName == "calendarName"){
            			  if(e.target.tagName=='A'){
            				  this.workHourDetailsByCalendar(grid,record);
            			  }
            		  }
            	  }
              },
              'staffworkhoursgrid[itemId=hrmStaffWorkingGridId] button[itemId=btnEdit]' : {
            	  click : this.editEmployeeCalendarHRM
              },
              'staffworkhoursgrid[itemId=hrmStaffWorkingGridId] button[itemId=btnAdd]' : {
            	  click:  function(button){
            		  this.openAssignCalendarWindowHRM();
            	  }
              },
              'assignworkcalendarwindow[itemId=hrmAssignworkcalendarwindowItemId] button#btnSaveEmployeeCalendar': {
  	        	click: function(button) {
  	        		this.saveAssignWorkCalendarHRM();
  	        	}
  	        },
              
  	        'assignworkcalendarwindow[itemId=hrmAssignworkcalendarwindowItemId] button#btnCancel': {
  	        	click: function(button) {
  	        		 this.getAssignworkcalendarwindow().close();
  	        	}
  	        },
  	        'bmstudentpunchlogreportfilter datefield[itemId=fromDateItemId]': {
  	        	select: function() {
  	        		var $this = this;
  	        		var form = $this.getBmstudentpunchlogreportfilter();
  	        		var fromDateFld = form.down('#fromDateItemId');
  	        		var toDateFld = form.down('#toDateItemId');

  	        		toDateFld.reset();
  	        		var val = fromDateFld.getValue();
  	        		var eDate = Ext.Date.add(val, Ext.Date.MONTH, 1);
  	        		toDateFld.setMaxValue(eDate);
  	        		fromDateFld.setMaxValue(null);
  	        	}
  	        },
  	        'bmstudentpunchlogreportfilter customcombobox[itemId=program]': {
  	        	select: function(programCombo) {
  	        		var this$ = this;
  	        		var basicSearchForm = this$.getBmstudentpunchlogreportfilter();
  	        		var batchCombo = basicSearchForm.down('#batch');
  	        		batchCombo.setDisabled(false);
  	        		var store = batchCombo.getStore();
  	        		var id = programCombo.getValue();
  	        		if(!isNullOrEmpty(id)){
  	        			batchCombo.clearValue();
  	        			store.removeAll();
  	        			store.proxy.extraParams = {
  	        					id : id
  	        			};
  	        			store.reload();
  	        		}
  	        	}
  	        },
  	        'bmstudentpunchlogreportfilter button[itemId=resetStudentPunchLogReportFilterItemId]': {
  	        	click: function() {
  	        		var filter = this.getBmstudentpunchlogreportfilter();
  	        		filter.getForm().reset();
  	        		var toDate =filter.down('#toDateItemId');
  	        		toDate.setMinValue(null);
  	        		toDate.setMaxValue(null);
  	        		var fromDate =filter.down('#fromDateItemId');
  	        		fromDate.setMaxValue(null);

  	        		var batchCombo = filter.down('#batch');
  	        		batchCombo.setDisabled(true);
  	        	}
  	        },
  	        'bmstudentpunchlogreportfilter button[itemId=searchStudentPunchLogReportFilterItemId]': {
  	        	click: function() {
  	        		this.loadStudentPunchLogReportGridData();
  	        	}
  	        },
  	        'bmstudentpunchlogreportgrid': {
  	        	render: function(grid) {
  	        		this.doAccessControlValidation(grid, this.getSTUDENT_PUNCH_LOG_REPORT_PERMISSION());
  	        		var exportPDFAll = grid.down('#exportPDFAll');
	        		exportPDFAll.setDisabled(true);
	        		var exportExcelAll = grid.down('#exportExcelAll');
	        		exportExcelAll.setDisabled(true);
  	        	},
  	        	beforerender: function(grid) {
  	        		grid.getStore().removeAll();
  	        		this.resetPageSetting(grid.getStore());
  	        	}
  	        },
        
  	      'icattendanceandpaymentreportfilter customcombobox[itemId=employeeId]': {
  	    	afterrender: function (combo) {
  	            var form = this.getIcattendanceandpaymentreportfilter();
  	            var userCombo = form.down('#employeeId');
  	            var userId = this.getCurrentlyLoggedInUser().id;
  	            var store = userCombo.getStore();
  	            store.getProxy().extraParams = {
  	                userId: userId
  	            };
  	           
  	          store.load({
  	            callback: function (records, operation, success) {
  	                if (success && records && records.length) {
  	                	var record = records[0].data.value;
  	                    if (record) {
  	                        userCombo.setValue(record);
  	                    } else {
  	                        userCombo.setValue(userId);
  	                    }
  	                }
  	            }
  	        });
  	      }
  	    },

  	  'icattendanceandpaymentreportfilter customcombobox[itemId=name]': {
	        afterrender: function(combo) {
	            var me = this;
	            var userData = me.getCurrentlyLoggedInUser();
	            var userStore = Ext.create('Ext.data.Store', {
	                fields: ['id', 'value', 'code'],
	                data: [userData]
	            });
	            combo.bindStore(userStore);
	            if (!combo.valueField) {
	                combo.valueField = 'id';
	            }
	            if (!combo.displayField) {
	                combo.displayField = 'value';
	            }
	            combo.setValue(userData.id);
	        }
	    },
	    'icattendanceandpaymentreportfilter customcombobox[itemId=reportTypeId]': {
	        select: function(combo, record) {
	            var rec = Ext.isArray(record) ? record[0] : record;
	            var reportTypeId = rec ? rec.get('id') : combo.getValue();
	            if (!reportTypeId) return;

	            var form = this.getIcattendanceandpaymentreportfilter();
	            var monthCombo = form.down('#monthId');
	            var moduleCombo = form.down('#moduleId');
	            var costCenterCombo = form.down('#costCenterId');
	            monthCombo.reset();
	            moduleCombo.reset();
	            costCenterCombo.reset();

	            var userId = this.getCurrentlyLoggedInUser().id;
	            var monthStore = monthCombo.getStore();
	            monthStore.getProxy().extraParams = {
	                userId: userId,
	                reportType: reportTypeId
	            };
	            monthStore.load();

	            var moduleStore = moduleCombo.getStore();
	            moduleStore.getProxy().extraParams = {
	                userId: userId,
	                reportType: reportTypeId
	            };
	            moduleStore.load();

	            var costCenterStore = costCenterCombo.getStore();
	            costCenterStore.getProxy().extraParams = {
	                userId: userId,
	                reportType: reportTypeId
	            };
	            costCenterStore.load();
	        }
	    },
	   
	    'icattendanceandpaymentreportfilter multiselectcombofield[itemId=monthId]': {
	    	afterrender: function (combo) {
	            var form = this.getIcattendanceandpaymentreportfilter();
	            var monthCombo = form.down('#monthId');
	            var userId = this.getCurrentlyLoggedInUser().id;
	            var store = monthCombo.getStore();
	            store.getProxy().extraParams = {
	                userId: userId
	            };
	            store.load();
	        },
	        
             change : function(obj){
			   var form = obj.up('form');
			   var values = form.getForm().getValues();
			   var monthId = values.month;
			   var module = form.down('#moduleId');
			   var costCenter = form.down('#costCenterId');
			   var reportTypeId = form.down('#reportTypeId').getValue();
			   var userId = this.getCurrentlyLoggedInUser().id;
			   module.reset();
			   costCenter.reset();
			   var month=[];
			   var months; 
			   if(monthId !=undefined && monthId.length > 0){
		    		for(var i in monthId){
		    			if(Ext.isObject(monthId[0])){
		    				month.push(monthId[i].get("id"));
		    			}else{
		    				if(i<(monthId.length-1))
		    				month.push(monthId[i]+"__");
		    				else
		    				month.push(monthId[i]);
		    			}
		    		}
		    	months = month.join();
		    	var store = module.getStore();
            	store.proxy.extraParams = {
            			userId: userId,
            			month : months,
            			reportType : reportTypeId
				};
            	store.load();
		    	}else {
		            var store = module.getStore();
		            store.getProxy().extraParams = {
		                userId: userId
		            };
		            store.load();
		        }

		   }
	   },
	
	    'icattendanceandpaymentreportfilter multiselectcombofield[itemId=moduleId]': {
	    	afterrender: function(combo) {
				 var form = this.getIcattendanceandpaymentreportfilter();
				 var moduleCombo = form.down('#moduleId');
				 var userId = this.getCurrentlyLoggedInUser().id;
				 var store = moduleCombo.getStore();
				 store.getProxy().extraParams = {
					 userId : userId
				 };
				 store.load();                    
			 },
	        
             change : function(obj){
			   var form = obj.up('form');
			   var values = form.getForm().getValues();
			   var moduleId = values.module;
			   var costCenter = form.down('#costCenterId');
			   var reportTypeId = form.down('#reportTypeId').getValue();
			   var userId = this.getCurrentlyLoggedInUser().id;
			   costCenter.reset();
			   var module=[];
			   var modules; 
			   if(moduleId !=undefined && moduleId.length > 0){
		    		for(var i in moduleId){
		    			if(Ext.isObject(moduleId[0])){
		    				module.push(moduleId[i].get("id"));
		    			}else{
		    				if(i<(moduleId.length-1))
		    					module.push(moduleId[i]+"__");
		    				else
		    					module.push(moduleId[i]);
		    			}
		    		}
		    	modules = module.join();
		    	var store = costCenter.getStore();
            	store.proxy.extraParams = {
            			userId: userId,
            			moduleAndServices : modules,
            			reportType : reportTypeId
				};
            	store.load();
		    	}else {
		            var store = costCenter.getStore();
		            store.getProxy().extraParams = {
		                userId: userId
		            };
		            store.load();
		        }
		   }
	   },
		 'icattendanceandpaymentreportfilter multiselectcombofield[itemId=costCenterId]': {
			 afterrender: function(combo) {
				 var form = this.getIcattendanceandpaymentreportfilter();
				 var costCenterCombo = form.down('#costCenterId');
				 var userId = this.getCurrentlyLoggedInUser().id;
				 var store = costCenterCombo.getStore();
				 store.getProxy().extraParams = {
					 userId : userId
				 };
				 store.load();                    
			 }
		 },
	    'icattendanceandpaymentreportfilter button[itemId=resetBtn]' : {
			 click : function(obj) {
				  var $this = this;
	        	  var form = $this.getIcattendanceandpaymentreportfilter();
	        	  
	        	  var reportType = form.down('#reportTypeId');
	        	  reportType.reset();
	        	  
	        	  var month = form.down('#monthId');
	        	  month.reset();
	        	  
	        	  var module = form.down('#moduleId');
	        	  module.reset();
	        	  
	        	  var costCenter = form.down('#costCenterId');
	        	  costCenter.reset();
	        	  
	        	  this.reloadFilterStores();
			 }
		  },
		  
		  'icattendanceandpaymentreportfilter button[itemId=searchBtn]' : {
				click : function(){
					var newTabName=this.getIcattendanceandpaymentreportstructure().down('#icattendanceandpaymentreportpanel').getActiveTab().title;
					if(newTabName==getCommonTranslation('CONSOLIDATED_REPORT')){
						this.loadICAttendanceConsolidatedReportGridData();
					}else  if(newTabName==getCommonTranslation('DETAILED_REPORT')){						   
						this.loadICAttendanceDetailedReportGridData();
					}
				}
			},
		  
		  'icattendanceandpaymentreportstructure tabpanel[itemId=icattendanceandpaymentreportpanel]':{
				tabchange:function(tabPanel, newCard, oldCard, eOpts){
					   var newTabName=newCard;
					   var consolidatedGridNew = newCard.down('icattendanceandpaymentconsolidatedreportgrid');
					   var detailedGridNew = newCard.down('icattendanceandpaymentdetailedreportgrid');
					   var consolidatedGridOld = oldCard.down('icattendanceandpaymentconsolidatedreportgrid');
					   var detailedGridOld = oldCard.down('icattendanceandpaymentdetailedreportgrid');
					   if(consolidatedGridNew != null){
						  var detailedLengthOld =  detailedGridOld.getStore().getRange().length;
					   if(detailedLengthOld > 0){
						   this.loadICAttendanceConsolidatedReportGridData(); 
					     }
					  }
	
					   if(detailedGridNew != null){
						   var consolidatedLengthOld =  consolidatedGridOld.getStore().getRange().length;
					   if(consolidatedLengthOld > 0){
						   this.loadICAttendanceDetailedReportGridData(); 
					     }
					  }
					   
					   if(consolidatedGridOld != null){
							  var detailedLengthNew =  detailedGridNew.getStore().getRange().length;
						   if(detailedLengthNew > 0){
							   this.loadICAttendanceConsolidatedReportGridData(); 
						     }
						  }
		
						   if(detailedGridOld != null){
							   var consolidatedLengthNew =  consolidatedGridNew.getStore().getRange().length;
						   if(consolidatedLengthNew > 0){
							   this.loadICAttendanceDetailedReportGridData(); 
						     }
						  }
				    }
			},
	    
  	      'icattendanceandpaymentconsolidatedreportgrid': {
			  render:function(grid){
				  var me = this;
				  grid.getStore().removeAll();
				  me.addDataGridConfigButton(grid,me.getHRM_FP_MY_ATTENDANCE_AND_PAYMENT_REPORT_PERMISSION());
    			}
  	      },
  	      
  	    'icattendanceandpaymentdetailedreportgrid': {
			  render:function(grid){
				  var me = this;
				  grid.getStore().removeAll();
				  me.addDataGridConfigButton(grid,me.getHRM_FP_MY_ATTENDANCE_AND_PAYMENT_REPORT_PERMISSION());
  			}
	      }
  	        
        });
    },
    loadICAttendanceConsolidatedReportGridData:function(){
		var $this = this;
		var attendancePaymentReportStructure = this.getIcattendanceandpaymentreportstructure();
		var filterForm = $this.getIcattendanceandpaymentreportfilter();
		filterForm.down('#searchBtn').setDisabled(true);
		var form = filterForm.getForm();
		var grid = $this.getIcattendanceandpaymentconsolidatedreportgrid();
		var values = form.getValues();
	 	var monthIdsArray = values.month;
      	var monthIds;
      	if (!isNullOrEmpty(monthIdsArray)) {
      		if(typeof monthIdsArray[0]!="object"){
          		var monthIds = monthIdsArray;
          	}
          	else {
          		var monthIdsTempArray = [];
          		Ext.each(monthIdsArray,function(currentMonthId){
          			if (currentMonthId && currentMonthId.data) {
          				monthIdsTempArray.push(currentMonthId.data.value);
          		    } else {
          		    	monthIdsTempArray.push(currentMonthId);
          		    }
          		});
          		var monthIds = monthIdsTempArray.join('__,');
          	}
		}
      	
       	var costCenterIdsArray = values.costCenter;
       	var costCenterIds;
       	if (!isNullOrEmpty(costCenterIdsArray)) {
       		if(typeof costCenterIdsArray[0]!="object"){
           		var costCenterIds = costCenterIdsArray;
           	}
           	else {
           		var costCenterIdsTempArray = [];
           		Ext.each(costCenterIdsArray,function(currentCostCenterId){
           			if (currentCostCenterId && currentCostCenterId.data) {
           				costCenterIdsTempArray.push(currentCostCenterId.data.id);
           		    } else {
           		    	costCenterIdsTempArray.push(currentCostCenterId);
           		    }
           		});
           		var costCenterIds = costCenterIdsTempArray.join(',');
           	}
		}

       	var moduleIdsArray = values.module;
       	var moduleIds;
       	if (!isNullOrEmpty(moduleIdsArray)) {
       		if(typeof moduleIdsArray[0]!="object"){
           		var moduleIds = moduleIdsArray;
           	}
           	else {
           		var moduleIdsTempArray = [];
           		Ext.each(moduleIdsArray,function(currentModuleId){
           			if (currentModuleId && currentModuleId.data) {
           		        moduleIdsTempArray.push(currentModuleId.data.value);
           		    } else {
           		        moduleIdsTempArray.push(currentModuleId);
           		    }
           		});
           		var moduleIds = moduleIdsTempArray.join('__,');
           	}
		}
       	
		var store = grid.getStore();
			store.getProxy().extraParams = {	
				userId : values.name,
				moduleAndServices : moduleIds,
				month : monthIds,
				reportType : values.reportType,
				costCenterId : costCenterIds,
				limit : 100 };
			this.resetPageSetting(store);
			store.pageSize = 100;
			store.load({
				callback: function(records, operation, success) {
					filterForm.down('#searchBtn').setDisabled(false);
				}
			});
			grid.config.searchFilterForm =  $this.getIcattendanceandpaymentreportfilter();
	},
	
	loadICAttendanceDetailedReportGridData:function(){
		var $this = this;
		var attendancePaymentReportStructure = this.getIcattendanceandpaymentreportstructure();
		var filterForm = $this.getIcattendanceandpaymentreportfilter();
		filterForm.down('#searchBtn').setDisabled(true);
		var form = filterForm.getForm();
		var grid = $this.getIcattendanceandpaymentdetailedreportgrid();
		var values = form.getValues();
		var monthIdsArray = values.month;
      	var monthIds;
      	if (!isNullOrEmpty(monthIdsArray)) {
      		if(typeof monthIdsArray[0]!="object"){
          		var monthIds = monthIdsArray;
          	}
          	else {
          		var monthIdsTempArray = [];
          		Ext.each(monthIdsArray,function(currentMonthId){  
          			if (currentMonthId && currentMonthId.data) {
          				monthIdsTempArray.push(currentMonthId.data.value);
          		    } else {
          		    	monthIdsTempArray.push(currentMonthId);
          		    }
          		});
          		var monthIds = monthIdsTempArray.join('__,');
          	}
		}
      	
       	var costCenterIdsArray = values.costCenter;
       	var costCenterIds;
       	if (!isNullOrEmpty(costCenterIdsArray)) {
       		if(typeof costCenterIdsArray[0]!="object"){
           		var costCenterIds = costCenterIdsArray;
           	}
           	else {
           		var costCenterIdsTempArray = [];
           		Ext.each(costCenterIdsArray,function(currentCostCenterId){
           			if (currentCostCenterId && currentCostCenterId.data) {
           				costCenterIdsTempArray.push(currentCostCenterId.data.id);
           		    } else {
           		    	costCenterIdsTempArray.push(currentCostCenterId);
           		    }
           		});
           		var costCenterIds = costCenterIdsTempArray.join(',');
           	}
		}

       	var moduleIdsArray = values.module;
       	var moduleIds;
       	if (!isNullOrEmpty(moduleIdsArray)) {
       		if(typeof moduleIdsArray[0]!="object"){
           		var moduleIds = moduleIdsArray;
           	}
           	else {
           		var moduleIdsTempArray = [];
           		Ext.each(moduleIdsArray,function(currentModuleId){
           			if (currentModuleId && currentModuleId.data) {
           		        moduleIdsTempArray.push(currentModuleId.data.value);
           		    } else {
           		        moduleIdsTempArray.push(currentModuleId);
           		    }
           		});
           		var moduleIds = moduleIdsTempArray.join('__,');
           	}
		}
       	
		var store = grid.getStore();
			store.getProxy().extraParams = {	
				userId : values.name,
				moduleAndServices : moduleIds,
				month : monthIds,
				reportType : values.reportType,
				costCenterId : costCenterIds,
				limit : 100
			};
			this.resetPageSetting(store);
			store.pageSize = 100;
			
			store.load({
				callback: function(records, operation, success) {
					filterForm.down('#searchBtn').setDisabled(false);
				}
			});
			grid.config.searchFilterForm =  $this.getIcattendanceandpaymentreportfilter();
	},
	
    reloadFilterStores: function() {
    	var form = this.getIcattendanceandpaymentreportfilter();
        var userId = this.getCurrentlyLoggedInUser().id; 
        var comboIds = ['monthId', 'moduleId', 'costCenterId'];

        Ext.each(comboIds, function(itemId) {
            var combo = form.down('#' + itemId);
            if (combo) {
                var store = combo.getStore();
                store.getProxy().setExtraParam('userId', userId);
            }
        })
    },
    
    loadAttendanceWiseGrid: function() {
        $this = this;
        var filter = $this.getHrmemployeeattendancefilter();
        var employeeWiseStructure = $this.getHrmanagementemployeewiseattendancestructure();
        var dateWiseStructure = $this.getHrmanagementdatewiseattendancestructure();
        var employeeWiseGrid = $this.getHrmanagementemployeewiseattendancegrid();
        var dateWiseGrid = $this.getHrmanagementdatewiseattendancegrid();

        var attendanceByItemId = filter.down('#attendanceByItemId');
        var employeeItemId = filter.down('#employeeItemId');
        var startDateItemId = filter.down('#startDateItemId');
        var endDateItemId = filter.down('#endDateItemId');
        var departmentItemId = filter.down('#departmentItemId');
        var userGroupItemId = filter.down('#userGroupItemId');
        var dateItemId = filter.down('#dateItemId');

        if (attendanceByItemId.getValue().attendanceBy == 'EmployeeWise') {
            employeeWiseStructure.setVisible(true);
            dateWiseStructure.setVisible(false);
            startDateItemId = Ext.Date.format(startDateItemId.getValue() ,'Y-m-d H:i:s.u');
            endDateItemId = Ext.Date.format(endDateItemId.getValue() ,'Y-m-d H:i:s.u');
            var store = employeeWiseGrid.getStore();
            var url = SERVERURL.HRM_FIND_EMPLOYEE_DAILY_ATTENDANCE_LIST;
            url = url.concat('?attendanceBy='+attendanceByItemId.getValue().attendanceBy+'&employeeId='+ employeeItemId.getValue()+'&startDate='+ startDateItemId+'&endDate='+ endDateItemId+'&lateArrivalEarlyGoing=' +filter.down('#lateArrivalEarlyGoingEWId').getValue());
            //var url = 'rest/employeeDailyAttendance/findEmployeeDailyAttendanceList?_dc=1526560936469&attendanceBy=EmployeeWise&employeeId=6&startDate=2018-05-01T00%3A00%3A00&endDate=2018-05-02T00%3A00%3A00&page=1&start=0&limit=25';
            Ext.Ajax.request({
                type: 'rest',
                url: url,
                method: 'GET',
                async: true,
                params: null,
                headers: {
                    'Content-Type': 'application/json'
                },
                success: function(frm, action) {
                    var data = frm.responseText;
                    Ext.getBody().unmask();
                    if(!isNullOrEmpty(data)){
                        var decodedResponse = Ext.decode(data);
                        var dailyAttendanceModels = decodedResponse.dailyAttendanceModels;
                        var employeeAttendanceSummaryModel = decodedResponse.employeeAttendanceSummaryModel;
                        var store1 = Ext.create('Academia.store.hrm.HRManagementEmployeeWiseAttendanceStore');
                        var store2 = Ext.create('Academia.store.hrm.HRManagementEmployeeWiseAttendanceStore');
                        
                        store1.removeAll();
                        store1.add(dailyAttendanceModels);
                        
                        store2.removeAll();
                        store2.add(employeeAttendanceSummaryModel);
                        
                        var employeeWiseGrid = $this.getHrmanagementemployeewiseattendancegrid();
                        var summaryGrid = Ext.ComponentQuery.query('hrmanagementemployeewiseattendancesummarygrid')[0];
                        
                        employeeWiseGrid.reconfigure(store1);
                        summaryGrid.reconfigure(store2);
                        
                        employeeWiseGrid.getView().refresh();
                        summaryGrid.getView().refresh();
                        
                        employeeWiseGrid.getSelectionModel().deselectAll(true);
                        summaryGrid.getSelectionModel().deselectAll(true);
                        
                        if (dailyAttendanceModels.length > 0) {
                            employeeWiseStructure.down('#saveHRManagementEmployeeWiseAttendanceStructureItemId').setDisabled(false);
                            employeeWiseStructure.down('#resetHRManagementEmployeeWiseAttendanceStructureItemId').setDisabled(false);
                            filter.down('#markDefaultInOutBtnItemId').setDisabled(false);
                            employeeWiseGrid.down('#exportReportItemId').setDisabled(false);
                        } else {
                            employeeWiseStructure.down('#saveHRManagementEmployeeWiseAttendanceStructureItemId').setDisabled(true);
                            employeeWiseStructure.down('#resetHRManagementEmployeeWiseAttendanceStructureItemId').setDisabled(true);
                            filter.down('#markDefaultInOutBtnItemId').setDisabled(true);
                            employeeWiseGrid.down('#exportReportItemId').setDisabled(true);
                        }
                        
                    }
                }
            });
            /*store.getProxy().extraParams = {
                attendanceBy: attendanceByItemId.getValue().attendanceBy,
                employeeId: employeeItemId.getValue(),
                startDate: startDateItemId.getValue(),
                endDate: endDateItemId.getValue()
            };
            store.load({
                callback: function(records, operation, success) {
                    if (records.length > 0) {
                        employeeWiseStructure.down('#saveHRManagementEmployeeWiseAttendanceStructureItemId').setDisabled(false);
                        employeeWiseStructure.down('#resetHRManagementEmployeeWiseAttendanceStructureItemId').setDisabled(false);
                    } else {
                        employeeWiseStructure.down('#saveHRManagementEmployeeWiseAttendanceStructureItemId').setDisabled(true);
                        employeeWiseStructure.down('#resetHRManagementEmployeeWiseAttendanceStructureItemId').setDisabled(true);
                    }
                }
            });*/
        } else {
            employeeWiseStructure.setVisible(false);
            dateWiseStructure.setVisible(true);

            var store = dateWiseGrid.getStore();
            var url = SERVERURL.HRM_FIND_EMPLOYEE_DAILY_ATTENDANCE_LIST;
            dateItemId =  Ext.Date.format(dateItemId.getValue() ,'Y-m-d H:i:s.u')
            url = url.concat('?attendanceBy='+attendanceByItemId.getValue().attendanceBy+'&date='+ dateItemId+ '&lateArrivalEarlyGoing='+ filter.down('#lateArrivalEarlyGoingDWId').getValue());
            if (!isNullOrEmpty(userGroupItemId.getValue())) {
            	url = url.concat('&userGroupId='+userGroupItemId.getValue());
            }
            if (!isNullOrEmpty(departmentItemId.getValue())) {
            	url = url.concat('&departmentId='+departmentItemId.getValue());
            }
            /*store.getProxy().extraParams = {
                attendanceBy: attendanceByItemId.getValue().attendanceBy,
                departmentId: departmentItemId.getValue(),
                userGroupId: userGroupItemId.getValue(),
                date: dateItemId.getValue()
            };*/
            Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');

            Ext.Ajax.request({
                type: 'rest',
                url: url,
                method: 'GET',
                async: true,
                params: null,
                headers: {
                    'Content-Type': 'application/json'
                },
                success: function(frm, action) {
                    var data = frm.responseText;
                    
                    if(!isNullOrEmpty(data)){
                        var decodedResponse = Ext.decode(data);
                        var dailyAttendanceModels = decodedResponse.dailyAttendanceModels;
                        var employeeAttendanceSummaryModel = decodedResponse.employeeAttendanceSummaryModel;
                        var store1 = Ext.create('Academia.store.hrm.HRManagementDateWiseAttendanceStore');
                        var store2 = Ext.create('Academia.store.hrm.HRManagementDateWiseAttendanceStore');
                        
                        store1.removeAll();
                        store1.add(dailyAttendanceModels);
                        
                        store2.removeAll();
                        store2.add(employeeAttendanceSummaryModel);
                        
                        var employeeWiseGrid = $this.getHrmanagementdatewiseattendancegrid();
                        var summaryGrid = Ext.ComponentQuery.query('hrmanagementdatewiseattendancesummarygrid')[0];
                        
                        employeeWiseGrid.reconfigure(store1);
                        summaryGrid.reconfigure(store2);
                        
                        employeeWiseGrid.getView().refresh();
                        summaryGrid.getView().refresh();
                        
                        employeeWiseGrid.getSelectionModel().deselectAll(true);
                        summaryGrid.getSelectionModel().deselectAll(true);
                        
                        if (dailyAttendanceModels.length > 0) {
                        	dateWiseStructure.down('#saveHRManagementDateWiseAttendanceStructureeItemId').setDisabled(false);
                            dateWiseStructure.down('#resetHRManagementDateWiseAttendanceStructureeItemId').setDisabled(false);
                            filter.down('#markDefaultInOutBtnItemId').setDisabled(false);
                            dateWiseGrid.down('#exportReportHRMDateWiseAttendanceItemId').setDisabled(false);
                        } else {
                        	dateWiseStructure.down('#saveHRManagementDateWiseAttendanceStructureeItemId').setDisabled(true);
                            dateWiseStructure.down('#resetHRManagementDateWiseAttendanceStructureeItemId').setDisabled(true);
                            filter.down('#markDefaultInOutBtnItemId').setDisabled(true);
                            dateWiseGrid.down('#exportReportHRMDateWiseAttendanceItemId').setDisabled(true);
                        }
                        
                    }
                    Ext.getBody().unmask();
                }
            });
            
           /* store.load({
                callback: function(records, operation, success) {
                    if (records.length > 0) {
                        dateWiseStructure.down('#saveHRManagementDateWiseAttendanceStructureeItemId').setDisabled(false);
                        dateWiseStructure.down('#resetHRManagementDateWiseAttendanceStructureeItemId').setDisabled(false);
                    } else {
                        dateWiseStructure.down('#saveHRManagementDateWiseAttendanceStructureeItemId').setDisabled(true);
                        dateWiseStructure.down('#resetHRManagementDateWiseAttendanceStructureeItemId').setDisabled(true);
                    }
                }
            });*/
        }
    },
    doAccessHRMEmployeeAttendanceSave: function(attendanceWise, privilegesMap, form) {
        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, privilegesMap);

        var saveBtn;
        var expBtn;
        if (attendanceWise == 'EmployeeWise') {
            saveBtn = form.down('#saveHRManagementEmployeeWiseAttendanceStructureItemId');
            expBtn =  form.down('#exportReportItemId');
        } else {
            saveBtn = form.down('#saveHRManagementDateWiseAttendanceStructureeItemId');
            expBtn =  form.down('#exportReportHRMDateWiseAttendanceItemId');
        }
        saveBtn.setVisible(false);
        if(!isNullOrEmpty(expBtn)){
        	expBtn.setVisible(false);
        }
        Ext.each(permissionList, function(privilege) {
            if (privilege == 'SAVE') {
                saveBtn.setVisible(true);
            }
            if (privilege == 'EXPORTREPORTS') {
            	if(!isNullOrEmpty(expBtn)){
            		expBtn.setVisible(true);
            	}
            }
        });
    },
    doAccessHRMTimesheetGridButton: function(grid, privilegesMap) {
        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, privilegesMap);

        var generateTimesheetItemId = grid.down('#generateTimesheetItemId');
        var approveTimesheetItemId = grid.down('#approveTimesheetItemId');
        var downloadTimesheetItemId = grid.down('#downloadTimesheetItemId');
        //var employeeTimesheetStructure = Ext.widget('hrmemployeetimesheetstructure');
        var printButtonItemId = grid.down("#printHRMEmployeeTimesheetStructureItemId");
        if(generateTimesheetItemId!=null){
        generateTimesheetItemId.setVisible(false);
        }
        if(approveTimesheetItemId!=null){
        	approveTimesheetItemId.setVisible(false);
        }
        if(downloadTimesheetItemId!=null){
        	downloadTimesheetItemId.setVisible(false);
        }
        if(printButtonItemId!=null){
        	printButtonItemId.setVisible(false);
        }
        Ext.each(permissionList, function(privilege) {
            if (privilege == 'GENERATE_TIMESHEET') {
            	 if(generateTimesheetItemId!=null){
                generateTimesheetItemId.setVisible(true);
            	 }
            }
            if (privilege == 'APPROVE_TIMESHEET') {
            	  if(approveTimesheetItemId!=null){
                approveTimesheetItemId.setVisible(true);
            	  }
            }
            if (privilege == 'DOWNLOAD_TIMESHEET') {
          	  if(downloadTimesheetItemId!=null){
          		downloadTimesheetItemId.setVisible(true);
          	  }
          }
            if (privilege == 'PRINT') {
          	  if(printButtonItemId!=null){
          		printButtonItemId.setVisible(true);
          	  }
          }
        });
    },
    doAccessWorkHourReportGridButton: function(grid, privilegesMap) {
        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, privilegesMap);

        var exportReportItemId = grid.down('#exportReportItemId');
        if(exportReportItemId!=null){
        	exportReportItemId.setVisible(false);
        }
        Ext.each(permissionList, function(privilege) {
            if (privilege == 'EXPORTREPORTS') {
            	 if(exportReportItemId!=null){
            		 exportReportItemId.setVisible(true);
            	 }
            }
        });
    },

    doAccessAttendanceSummaryReportGridButton: function(grid, privilegesMap) {
        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, privilegesMap);

        var attendanceRegisterItemId = grid.down('#attendanceRegisterItemId');
        if(attendanceRegisterItemId!=null){
        	attendanceRegisterItemId.setVisible(false);
        }
        Ext.each(permissionList, function(privilege) {
            if (privilege == 'ATTENDANCE_REGISTER') {
            	 if(attendanceRegisterItemId!=null){
            		 attendanceRegisterItemId.setVisible(true);
            	 }
            }
        });
    },
    saveEmployeeWiseAttendance: function() {
       /* var $this = this;

        var employeeWiseGrid = $this.getHrmanagementemployeewiseattendancegrid();
        var models = employeeWiseGrid.getStore().getUpdatedRecords();
        var myJson = new Array();
        var innerJson ='';
        for (var i = 0; i < models.length; i++) {
            //var attendanceModel = new Academia.model.hrm.HRManagementEmployeeAttendanceUpdateModel();
        	innerJson = '{'
            if (!isNullOrEmpty(models[i].get('id'))) {
            	innerJson + 'id :' +  models[i].get('id') + ',' ;
                //attendanceModel.set("id", models[i].get('id'));
            }
            if (!isNullOrEmpty(models[i].get('attendanceDate'))) {
                var dateAssign = new Date(models[i].get('attendanceDate'));
                innerJson += 'attendanceDate :' +  Ext.Date.format(dateAssign, CONSTANTS.SUBMIT_DATE_FORMAT) + ',' ;
                //attendanceModel.set("attendanceDate", Ext.Date.format(dateAssign, CONSTANTS.SUBMIT_DATE_FORMAT));
            }
            if (!isNullOrEmpty(models[i].get('intime'))) {
            	innerJson += 'intime :' +  Ext.Date.format(new Date(models[i].get("intime")), CONSTANTS.DISPLAY_TIME_FORMAT) + ',' ;
                //attendanceModel.set("intime", Ext.Date.format(new Date(models[i].get("intime")), CONSTANTS.DISPLAY_TIME_FORMAT));
            }
            if (!isNullOrEmpty(models[i].get('outtime'))) {
            	innerJson += 'outtime :' +  Ext.Date.format(new Date(models[i].get("outtime")), CONSTANTS.DISPLAY_TIME_FORMAT) + ',' ;
                //attendanceModel.set("outtime", Ext.Date.format(new Date(models[i].get("outtime")), CONSTANTS.DISPLAY_TIME_FORMAT));
            }
            if (!isNullOrEmpty(models[i].get('totaltime'))) {
            	innerJson += 'totaltime :' +  Ext.Date.format(new Date(models[i].get("totaltime")), CONSTANTS.DISPLAY_TIME_FORMAT) + ',' ;
                //attendanceModel.set("totaltime", Ext.Date.format(new Date(models[i].get("totaltime")), CONSTANTS.DISPLAY_TIME_FORMAT));
            }
            if (!isNullOrEmpty(models[i].get('empId'))) {
            	innerJson += 'empId :' +  models[i].get('empId') ;
                //attendanceModel.set("empId", models[i].get('empId'));
            }
            if(i == (models.length-1)){
            	innerJson = innerJson + '}';
            } else {
            	innerJson = innerJson + '} , ';
            }
        }
        //var innerJson = innerJson + ']';
        myJson.push(innerJson);
        if (myJson.length > 0) {
            var formData = Ext.encode(myJson);
            Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            Ext.Ajax.request({
                type: 'rest',
                url: SERVERURL.HRM_EMPLOYEE_DAILY_ATTENDANCE_UPDATE,
                jsonData: formData,
                method: 'POST',
                success: function(frm, action) {
                    var data = frm.responseText;
                    Ext.getBody().unmask();
                    $this.loadAttendanceWiseGrid();
                    showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('HRM_EMPLOYEE_ATTENDANCE_SAVED_SUCCESSFULLY'));
                }
            });
        } else {
        	showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('HRM_EMPLOYEE_ATTENDANCE_SAVED_SUCCESSFULLY'));
        }*/
    
    
    
        
        var $this = this;

        var employeeWiseGrid = $this.getHrmanagementemployeewiseattendancegrid();
        var models = employeeWiseGrid.getStore().getModifiedRecords();
        var myJson = new Array();
        var isValid = true ; 
        for (var i = 0; i < models.length; i++) {
        	if (models[i].dirty == true) {
        		if((!isNullOrEmpty(models[i].get('intime')) && !isNullOrEmpty(models[i].get('outtime'))) || (!isNullOrEmpty(models[i].get('statusForGrid')) && isNullOrEmpty(models[i].get('intime')) && isNullOrEmpty(models[i].get('outtime')))){
        			

                	var attendanceModel = new Academia.model.hrm.HRManagementEmployeeAttendanceUpdateModel();
                    //var attendanceModel = new Academia.model.hrm.HRManagementEmployeeWiseAttendanceModel();
                	if(isNullOrEmpty(models[i].get('intime')) || isNullOrEmpty(models[i].get('outtime'))){
                		models[i].set('overtime','')
        			}
                    if (!isNullOrEmpty(models[i].get('id'))) {
                        attendanceModel.set("id", models[i].get('id'));
                    }
                    if (!isNullOrEmpty(models[i].get('attendanceDate'))) {
                        var dateAssign = new Date(models[i].get('attendanceDate'));
                        attendanceModel.set("attendanceDate", Ext.Date.format(dateAssign, CONSTANTS.SUBMIT_DATE_FORMAT));
                    }
                    if (!isNullOrEmpty(models[i].get('intime'))) {
                        attendanceModel.set("intime", Ext.Date.format(new Date(models[i].get("intime")), CONSTANTS.DISPLAY_TIME_FORMAT));
                    }
                    if (!isNullOrEmpty(models[i].get('outtime'))) {
                        attendanceModel.set("outtime", Ext.Date.format(new Date(models[i].get("outtime")), CONSTANTS.DISPLAY_TIME_FORMAT));
                    }
                    if (!isNullOrEmpty(models[i].get('totaltime'))) {
                        attendanceModel.set("totaltime", Ext.Date.format(new Date(models[i].get("totaltime")), CONSTANTS.DISPLAY_TIME_FORMAT));
                    }
                    if (!isNullOrEmpty(models[i].get('empId'))) {
                        attendanceModel.set("empId", models[i].get('empId'));
                    }
                    /*if (!isNullOrEmpty(models[i].get('isArrivedLate'))) {
                        attendanceModel.set("isArrivedLate", models[i].get('isArrivedLate'));
                    }
                    if (!isNullOrEmpty(models[i].get('isLessHours'))) {
                        attendanceModel.set("isLessHours", models[i].get('isLessHours'));
                    }
                    if (!isNullOrEmpty(models[i].get('isWentEarly'))) {
                        attendanceModel.set("isWentEarly", models[i].get('isWentEarly'));
                    }*/
                    if (!isNullOrEmpty(models[i].get('overtime'))) {
                        attendanceModel.set("overtime", models[i].get('overtime'));
                    }
                    if (!isNullOrEmpty(models[i].get('remarks'))) {
                        attendanceModel.set("remarks", models[i].get('remarks'));
                    }
                    if (!isNullOrEmpty(models[i].get('statusForGrid'))) {
                        attendanceModel.set("status", models[i].get('statusForGrid'));
                    }
                    if (!isNullOrEmpty(models[i].get('statusForGrid')) && !isNullOrEmpty(models[i].get('employeeAttendanceMarkingTypeId'))) {
                      if(models[i].get('statusForGrid') == 'Half Day'){
                    	  attendanceModel.set("status", models[i].get('statusForGrid'));
                      } else {
                    	  attendanceModel.set("status", models[i].get('empAttendanceStatus'));
                      }
                        var obj = {
                        		"id":models[i].get('employeeAttendanceMarkingTypeId')
                        }
                        attendanceModel.set("employeeAttendanceMarkingType", obj);
                    } else {
                         attendanceModel.set("employeeAttendanceMarkingType", null)
                    }
                    
                    if(typeof models[i].modified.statusForGrid != "undefined" || (typeof models[i].modified.statusForGrid != "undefined" && isNullOrEmpty(models[i].modified.statusForGrid))){
                    	attendanceModel.set("isUpdateByUser", true);
                    }else{
                    	if(!isNullOrEmpty(models[i].get('isUpdateByUser'))){
                    		attendanceModel.set("isUpdateByUser", models[i].get('isUpdateByUser'));
                    	}
                    }
                    
                    
                    myJson.push(attendanceModel.data);
                
            	
        		} else {
        			isValid = false; 
        		}
        	}
        }
        if(isValid == false){
        	showWarningMessage(getCommonTranslation('ALERT'), getPersonModuleTranslation('HRM_IN_OUT_TIME_REQUIRED'));
        } else if (myJson.length > 0) {
            var formData = Ext.encode(myJson);
            Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            Ext.Ajax.request({
                type: 'rest',
                url: SERVERURL.HRM_EMPLOYEE_DAILY_ATTENDANCE_UPDATE,
                jsonData: formData,
                method: 'POST',
                success: function(frm, action) {
                    var data = frm.responseText;
                    if(data == 'TIMESHEET_IS_APPROVED') {
                    	showWarningMessage(getCommonTranslation('EMPLOYEE_ATTENDANCE'), getCommonTranslation('TIMESHEET_IS_APPROVED'));
                    } else {
                         showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('HRM_EMPLOYEE_ATTENDANCE_SAVED_SUCCESSFULLY'));
                         $this.loadAttendanceWiseGrid();
                    }
                    Ext.getBody().unmask();
                }
            });
        } else {
        	showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('HRM_EMPLOYEE_ATTENDANCE_SAVED_SUCCESSFULLY'));
        }
    },
    saveDateWiseAttendance: function() {
        var $this = this;

        var employeeWiseGrid = $this.getHrmanagementdatewiseattendancegrid();
        var models = employeeWiseGrid.getStore().getModifiedRecords();
        var myJson = new Array();
        var isValid = true;
        for (var i = 0; i < models.length; i++) {
        	if (models[i].dirty == true) {
        		if((!isNullOrEmpty(models[i].get('intime')) && !isNullOrEmpty(models[i].get('outtime'))) || (!isNullOrEmpty(models[i].get('statusForGrid')) && isNullOrEmpty(models[i].get('intime')) && isNullOrEmpty(models[i].get('outtime')))){
        			var attendanceModel = new Academia.model.hrm.HRManagementEmployeeAttendanceUpdateModel();
                    //var attendanceModel = new Academia.model.hrm.HRManagementEmployeeWiseAttendanceModel();
                    if (!isNullOrEmpty(models[i].get('id'))) {
                        attendanceModel.set("id", models[i].get('id'));
                    }
                    if (!isNullOrEmpty(models[i].get('attendanceDate'))) {
                        var dateAssign = new Date(models[i].get('attendanceDate'));
                        attendanceModel.set("attendanceDate", Ext.Date.format(dateAssign, CONSTANTS.SUBMIT_DATE_FORMAT));
                    }
                    if (!isNullOrEmpty(models[i].get('intime'))) {
                        attendanceModel.set("intime", Ext.Date.format(new Date(models[i].get("intime")), CONSTANTS.DISPLAY_TIME_FORMAT));
                    }
                    if (!isNullOrEmpty(models[i].get('outtime'))) {
                        attendanceModel.set("outtime", Ext.Date.format(new Date(models[i].get("outtime")), CONSTANTS.DISPLAY_TIME_FORMAT));
                    }
                    if (!isNullOrEmpty(models[i].get('totaltime'))) {
                        attendanceModel.set("totaltime", Ext.Date.format(new Date(models[i].get("totaltime")), CONSTANTS.DISPLAY_TIME_FORMAT));
                    }
                    if (!isNullOrEmpty(models[i].get('empId'))) {
                        attendanceModel.set("empId", models[i].get('empId'));
                    }
                    if (!isNullOrEmpty(models[i].get('overtime'))) {
                        attendanceModel.set("overtime", models[i].get('overtime'));
                    }
                    if (!isNullOrEmpty(models[i].get('remarks'))) {
                        attendanceModel.set("remarks", models[i].get('remarks'));
                    }
                    if (!isNullOrEmpty(models[i].get('statusForGrid'))) {
                        attendanceModel.set("status", models[i].get('statusForGrid'));
                    }
                    if (!isNullOrEmpty(models[i].get('statusForGrid')) && !isNullOrEmpty(models[i].get('employeeAttendanceMarkingTypeId'))) {
                    	if(models[i].get('statusForGrid') == 'Half Day'){
                      	  attendanceModel.set("status", models[i].get('statusForGrid'));
                        } else {
                       	  attendanceModel.set("status", models[i].get('empAttendanceStatus'));
                         }
                        var obj = {
                        		"id":models[i].get('employeeAttendanceMarkingTypeId')
                        }
                        attendanceModel.set("employeeAttendanceMarkingType", obj);
                    } else {
                         attendanceModel.set("employeeAttendanceMarkingType", null)
                    }
                    
                    if(typeof models[i].modified.statusForGrid != "undefined" || (typeof models[i].modified.statusForGrid != "undefined" && isNullOrEmpty(models[i].modified.statusForGrid))){
                    	attendanceModel.set("isUpdateByUser", true);
                    }else{
                    	if(!isNullOrEmpty(models[i].get('isUpdateByUser'))){
                    		attendanceModel.set("isUpdateByUser", models[i].get('isUpdateByUser'));
                    	}
                    }
                    myJson.push(attendanceModel.data);	
        		}else{
        			isValid = false;	
        		}
            	
            
        	}
        }
        if(isValid == false){
        	showWarningMessage(getCommonTranslation('ALERT'), getPersonModuleTranslation('HRM_IN_OUT_TIME_REQUIRED'));
        } else  if (myJson.length > 0) {
            var formData = Ext.encode(myJson);
            Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            Ext.Ajax.request({
                type: 'rest',
                url: SERVERURL.HRM_EMPLOYEE_DAILY_ATTENDANCE_UPDATE,
                jsonData: formData,
                method: 'POST',
                success: function(frm, action) {
                    var data = frm.responseText;
                    if(data == 'TIMESHEET_IS_APPROVED') {
                    	showWarningMessage(getCommonTranslation('EMPLOYEE_ATTENDANCE'), getCommonTranslation('TIMESHEET_IS_APPROVED'));
                    } else {
                        showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('HRM_EMPLOYEE_ATTENDANCE_SAVED_SUCCESSFULLY'));
                        $this.loadAttendanceWiseGrid();
                    }
                    Ext.getBody().unmask();
                }
            });
        } else {
        	showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('HRM_EMPLOYEE_ATTENDANCE_SAVED_SUCCESSFULLY'));
        }
    },

    employeeWiseAttendanceRowEdit: function(rowData, e) {
        var $this = this;
        var grid = e.grid;
        var models = grid.getStore().getRange();
        if (!isNullOrEmpty(rowData.intime) && !isNullOrEmpty(rowData.outtime)) {
            var inTimeDate = new Date(rowData.intime);
            inTimeDate.setFullYear(1970);
            var inTimeInMiliSeconds = inTimeDate.getTime();
            var outTimeDate = new Date(rowData.outtime);
            outTimeDate.setFullYear(1970);
            var outTimeInMiliSeconds = outTimeDate.getTime();

            var timeDiff = outTimeInMiliSeconds - inTimeInMiliSeconds;
            if(timeDiff < 0 ){
            	showWarningMessage(getCommonTranslation('ALERT'), getPersonModuleTranslation('HRM_OUTTIME_INTIME_VALIDATION'));
            	models[e.rowIdx].set(e.field,e.originalValue);
            	
            } else {
                models[e.rowIdx].set("totaltime", timeDiff);

            }
        } else {
        	
            models[e.rowIdx].set("totaltime", null);
        }
    },
    getOpenAttendanceReportStructure: function(treePanel, record, item, index, e, eOpts) {
        var $this = this;
        var containpanel = $this.getHrmattendancereportstructure();
        var treePanel = containpanel.down('#hrmAttendanceReportTreePanelItemId');
        var tabDetail = record.data;
        var structure = Ext.widget(tabDetail.reportXtype);
        var tabstructure = containpanel.down('#tabpanelIds');

        if (!isNullOrEmpty(tabDetail.text) &&
            !isNullOrEmpty(tabDetail.reportXtype) &&
            !isNullOrEmpty(tabDetail.reportXtypeItemId)) {
            treePanel.toggleCollapse();
            openTab(tabstructure, tabDetail.text, structure);
            treePanel.getSelectionModel().deselectAll();
        }
    },
    doAccessEmployeeAttendanceReport: function(structure, privilegesMap) {
        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, privilegesMap);

        var treePanel = structure.down('#hrmAttendanceReportTreePanelItemId');
        var isAttendanceSummaryReport = false;
        var isWorkingHourReport = false;
        var isEmployeeLeaveReport = false;
        var isAttendancePunchLogReport = false;
        var isAttendanceStatusReport=false;
        Ext.each(permissionList, function(privilege) {
            if (privilege == 'ATTENDANCE_SUMMARRY_REPORT') {
                isAttendanceSummaryReport = true;
            }
            if (privilege == 'WORKING_HOUR_REPORT') {
                isWorkingHourReport = true;
            }
            if (privilege == 'ATTENDANCE_PUNCH_LOG_REPORT') {
                isAttendancePunchLogReport = true;
            }
            if (privilege == 'ATTENDANCE_STATUS_REPORT') {
            	isAttendanceStatusReport = true;
            }
        });
        var childNodes = treePanel.getRootNode().childNodes;
        for (var i = 0; i < childNodes.length; i++) {
            if (childNodes[i].data.permissionKey == 'ATTENDANCE_SUMMARY_REPORT' && !isAttendanceSummaryReport) {
                childNodes[i].remove();
                i--;
                continue;
            }
            if (childNodes[i].data.permissionKey == 'WORKING_HOUR_REPORT' && !isWorkingHourReport) {
                childNodes[i].remove();
                i--;
                continue;
            }
            if (childNodes[i].data.permissionKey == 'ATTENDANCE_PUNCH_LOG_REPORT' && !isAttendancePunchLogReport) {
                childNodes[i].remove();
                i--;
                continue;
            }
            if (childNodes[i].data.permissionKey == 'ATTENDANCE_STATUS_REPORT' && !isAttendanceStatusReport) {
                childNodes[i].remove();
                i--;
                continue;
            }
            
            /*if (childNodes[i].data.permissionKey == 'EMPLOYEE_LEAVE_REPORT' && !isEmployeeLeaveReport) {
                childNodes[i].remove();
                i--;
                continue;
            }*/
        }
    },    
    /* Employee Attendance Loader functions :START */
    employeeAttendanceDownloadUploadFormChange: function(cb, nv, ov) {
        var $this = this;
        var structure = cb.up('hrmimportemployeeattendancetabstructure');
        var downloadTemplateForm = structure.down('hrmimportemployeeattendancedownloadform');
        var uploadTemplateForm = structure.down('hrmimportemployeeattendanceuploadform');
        var grid = $this.getImportlistemployeeattendancegrid();
        if (nv.downloadUploadTemplate == 'forDownloadTemplate') {
            uploadTemplateForm.hide();
            downloadTemplateForm.show();
            grid.setVisible(false);
            downloadTemplateForm.down("#sampleTemplateNameItemId").setValue('TEMPLATE_1');
        } else {
        	$this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
        	var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
			uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
				isUploadAll: false
			});
        	downloadTemplateForm.hide();
            uploadTemplateForm.show();
            grid.setVisible(true);
            uploadTemplateForm.down("#uploadFileField").reset();
        }
    },
    getEmployeeAttendanceDownloadFile: function(documentId, fileType) {
        if (!isNullOrEmpty(documentId)) {
            var csvForm = Ext.create('Ext.form.Panel');
            csvForm.getForm().submit({
                target: '_blank',
                method: 'POST',
                params: {
                    access_token: Ext.Ajax.defaultHeaders.access_token
                },
                headers: {
                    'Authorization': Ext.Ajax.defaultHeaders.Authorization
                },
                url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL + '?id=' + documentId + '&fileType=' + fileType,
                standardSubmit: true
            });
        }
    },
    disableImportEmployeeAttendance:function(structure,permissionsMap){
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		var importEmpAttendancePermission = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getIMPORT_EMPLOYEE_ATTENDANCE_PERMISSION());
		
		var empAttendanceUploadDownloadStructure = structure.down('#hrmimportemployeeattendancetabstructureItemId');
		var empAttendanceUploadDownloadStructuretab=false;
		var empSearchStructure = structure.down("#hrmanagementtabstructureItemId");
		var empSearchStructure=false;
		
		Ext.each(permissionList, function(privilege) {
			if (privilege === 'VIEW') {
				empAttendanceUploadDownloadStructuretab = true;
			} else {
				empAttendanceUploadDownloadStructuretab = false;
			}
		});
		this.showSearchTab(empAttendanceUploadDownloadStructuretab, structure);
	},
	showSearchTab : function(empAttendanceUploadDownloadStructuretab, structure) {
		 var panelItem = new Array();
	        var $this = this;
	        var newcont=structure.items.items.length;
	        var insertPosition=newcont+1;
	        if(!Ext.ComponentQuery.query("hrmanagementtabstructure")[0]){
	        
	            var panelItem = new Array();
	             var $this = this;
	             var newcont = structure.items.items.length;
	             var insertPosition = newcont;
	             panelItem.push({
	                    xtype: 'hrmanagementtabstructure',
	                    title: getPersonModuleTranslation('SEARCH'),
	                    tabCls: 'right-tab'
	             });
	            
	            
	            var insertAt = panelItem.length;
	             
	             if (empAttendanceUploadDownloadStructuretab) {
	                 panelItem[insertAt] = {
	                         xtype:'hrmimportemployeeattendancetabstructure',
	                        itemId:'hrmimportemployeeattendancetabstructureItemId',
	                        title: getPersonModuleTranslation('HRM_IMPORT_ATTENDANCE')
	                 };
	                 insertAt = insertAt + 1;
	             }
	             
	            structure.insert(insertPosition,panelItem);
	        }
	},
    /* Employee Attendance Loader functions :END */
	
	approveOrGenerateTimeSheet : function(status) {
		var this$ = this;
		var filter = this.getHrmtimesheetfilter();
		var grid = this.getHrmtimesheetgrid();
		var formValues = filter.getValues();
        var timeSheetPeriodId = formValues.timesheetPeriodId;
		var records = grid.getSelectionModel().getSelection();
		var employees = []
		var employeeIds;
		var flag = true;
		if(!isNullOrEmpty(records) && records.length > 0) {
			if(status == 'Approved') {
			for( var i=0; i<records.length; i++ ) {
				employees.push(records[i].data.empId);
				if(records[i].data.timeSheetStatus != 'Generated') {
					flag = false;
				}
			}
			}else if(status == 'Generated') {
				for( var i=0; i<records.length; i++ ) {
					employees.push(records[i].data.empId);
				}
			}
			if(flag == true) {
			employeeIds = employees.join();
			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			Ext.Ajax.request({
                type: 'rest',
                url: SERVERURL.PATH_UPDATE_TIME_SHEET_STATUS,
                method: 'POST',
                params: {
                	timeSheetPeriodId : timeSheetPeriodId,
                	employeeIds: employeeIds,
                	status:status
                },
                headers: {
                    'Content-Type': 'application/json'
                },
                success: function(form, action) {
            		grid.getSelectionModel().deselectAll(true);
            		if(status=="Approved"){
            			showSuccessMessage(getPersonModuleTranslation('TIMESHEET'), getPersonModuleTranslation('TIMESHEET_APPROVED'));	
            		}else if(status=="Generated"){
            			showSuccessMessage(getPersonModuleTranslation('TIMESHEET'),getPersonModuleTranslation('TIMESHEET_GENERATED_SUCCESSFULLY'));
            		}
            		this$.loadTimesheetGridData();
            		Ext.getBody().unmask();
                }
            });
			} else {
				showWarningMessage(getPersonModuleTranslation('HRM_TIMESHEET'), getPersonModuleTranslation('HRM_APPROVED_TIMESHEET_MSG'));
			}
			
		} else {
			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	loadTimesheetGridData : function() {
        var filter = this.getHrmtimesheetfilter();
        var grid = this.getHrmtimesheetgrid();
        var formValues = filter.getValues();
        var timesheetPeriodId = formValues.timesheetPeriodId;
        var empId = formValues.employeeId;
        var deptId = null;
        var userGroupId = null;
        if(!isNullOrEmpty(filter.getValues().department)) {
        	deptId = filter.getValues().department.id;
        }
        if(!isNullOrEmpty(filter.getValues().userGroupId)) {
        	userGroupId = filter.getValues().userGroupId.id;
        }
        var store = grid.getStore();
        store.getProxy().extraParams = {
        	timeSheetPeriodId: timesheetPeriodId,
        	employeeId: empId,
        	departmentId: deptId,
        	userGroupId: userGroupId
        };
        store.load();
        /*pdf & excel report header filter*/
    	grid.config.searchFilterForm = filter;
    },
	openEmployeeTimesheetStructure: function(record) {
		var contentPanel = this.getContentpanel();
       // var employeeTimesheetStructure = this.getHrmemployeetimesheetstructure();
        var employeeTimesheetStructure = Ext.widget('hrmemployeetimesheetstructure');
        // employeeTimesheetStructure.setTitle(getCommonTranslation('HRM_EMPLOYEE_TIMESHEET'));
        var tabName = getPersonModuleTranslation('HRM_EMPLOYEE_TIMESHEET');
        var getcontroller = this.getController('menu.CoreERPNavigationController');
        var getEmployeeTimesheetTab = getcontroller.getTab(getPersonModuleTranslation('HRM_EMPLOYEE_TIMESHEET'));
        if (getEmployeeTimesheetTab != null) {
            contentPanel.remove(getEmployeeTimesheetTab, true);
        }
        employeeTimesheetStructure.config.employeeId = record.get('empId');
        employeeTimesheetStructure.config.timeSheetPeriodId = record.get('timeSheetPeriodId');
        employeeTimesheetStructure.config.timeSheetPeriodName = record.get('timeSheetPeriodName');
        openTab(contentPanel, tabName, employeeTimesheetStructure, CONSTANTS.MENU_COLOR_THREE);
      
    },
    loadAttendanceSummaryGrid: function(){

    	var $this = this;
    	var form = $this.getHrmattendancesummaryreportfilter();

    	var departmentItemId = form.down("#departmentItemId").getValue();
    	var userGroupItemId = form.down("#userGroupItemId").getValue();

    	var fromDate = form.down("#fromDateItemId").getValue();
    	var toDate = form.down("#toDateItemId").getValue();

    	var attendanceSummaryGrid = $this.getHrmattendancesummaryreportgrid();

    	var store = attendanceSummaryGrid.getStore();
    	store.getProxy().extraParams = {
    		departmentId: departmentItemId,
    		userGroupId: userGroupItemId,               
    		startDate: fromDate,
    		endDate: toDate
    	};
    	store.load();
    	/*pdf & excel report header filter*/
    	attendanceSummaryGrid.config.searchFilterForm = form;
    },
    loadHrmWorkingHourReportGridData : function(){
    	var $this = this;
    	var form = $this.getHrmworkinghourreportfilter();

    	var departmentItemId = form.down("#workingHourDepartmentItemId").getValue();
    	var userGroupItemId = form.down("#workingHourUserGroupItemId").getValue();

    	var empId = form.down("#workingHourEmpItemId").getValue();
    	var chkEmpWithNoCalendar = form.down('#viewEmployeeWithNoCalendarItemId').getValue();

    	var workHourReportGridGrid = $this.getHrmworkinghourreportgrid();

    	var store = workHourReportGridGrid.getStore();
    	store.getProxy().extraParams = {
    		staffId: empId,
    		departmentId: departmentItemId,               
    		userGroupId: userGroupItemId,
    		isEmployeeWithNoCalendar: chkEmpWithNoCalendar
    	};
    	store.load({
            callback: function(records, operation, success) {
            	$this.resetPageSetting(workHourReportGridGrid.getStore());
            	//Ext.getBody().unmask();
            	}
            });
    },
    loadAttendancePunchLogReportGridData : function(){
    	var $this = this;
    	var form = $this.getHrmattendancepunchlogreportfilter();

    	var departmentItemId = form.down("#attendancePunchLogDepartmentItemId").getValue();
    	var userGroupItemId = form.down("#attendancePunchLogUserGroupItemId").getValue();

    	var empId = form.down("#attendancePunchLogEmpItemId").getValue();
    	var startDate = form.down("#fromDateItemId");
		if(startDate!=null){
			startDate=startDate.getValue();
		}
		
		var endDate = form.down("#toDateItemId");
		if(endDate!=null){
			endDate= endDate.getValue();
		}
		
		if (startDate != null) {
			startDate = new Date(startDate);
			startDate = Ext.Date.format(startDate, 'Y-m-d');
		}

		if (endDate != null) {
			endDate = new Date(endDate);
			endDate = Ext.Date.format(endDate, 'Y-m-d');
		}
    	var hrmattendancepunchlogreportgrid = $this.getHrmattendancepunchlogreportgrid();

    	var store = hrmattendancepunchlogreportgrid.getStore();
    	store.getProxy().extraParams = {
    		staffId: empId,
    		departmentId: departmentItemId,               
    		userGroupId: userGroupItemId,
    		fromDate:startDate,
    		toDate:endDate
    	};
    	$this.resetPageSetting(store);
    	store.load({
            callback: function(records, operation, success) {
            	Ext.getBody().unmask();
            	}
            });
    	/*pdf & excel report header filter*/
    	hrmattendancepunchlogreportgrid.config.searchFilterForm = form;
    },
    loadAttendanceStatusReportGridData : function(){
    	var $this = this;
    	var form = $this.getHrmattendancestatusreportfilter();
    	var departmentId=form.down('#attendanceStatusReportDepartmentItemId').getValue();
    	var userGroupId = form.down("#attendanceStatusReportUserGroupItemId").getValue();
    	var staffId = form.down("#attendanceStatusReportEmpItemId").getValue();
    	var status = form.down("#statusItemId").getValue();

    	var startDate = form.down("#fromDateItemId");
    	if(startDate!=null){
    		startDate=startDate.getValue();
    	}

    	var endDate = form.down("#toDateItemId");
    	if(endDate!=null){
    		endDate= endDate.getValue();
    	}
		if (startDate != null) {
			startDate = new Date(startDate);
			startDate = Ext.Date.format(startDate, 'Y-m-d');
		}

		if (endDate != null) {
			endDate = new Date(endDate);
			endDate = Ext.Date.format(endDate, 'Y-m-d');
		}

    	var hrmattendancestatusreportgrid = $this.getHrmattendancestatusreportgrid();

    	var store = hrmattendancestatusreportgrid.getStore();
    	store.getProxy().extraParams = {
    		employeeId: staffId,
    		departmentId: departmentId,               
    		userGroupId: userGroupId,
    		startDate:startDate,
    		endDate:endDate,
    		status:status
    	};
    	$this.resetPageSetting(store);
    	store.load({
    		callback: function(records, operation, success) {
    			Ext.getBody().unmask();
    		}
    	});
    	/*pdf & excel report header filter*/
    	hrmattendancestatusreportgrid.config.searchFilterForm = form;
    },
    
    markDefaultInOutGrid: function(){
    	var $this = this,
    	filter = $this.getHrmemployeeattendancefilter(),
    	selectionTypeItemId = filter.down('#attendanceByItemId'),
    	selectionTypeValue = selectionTypeItemId.getValue().attendanceBy,
    	cnt = 0;

    	if(selectionTypeValue == 'EmployeeWise'){
    		var employeeWiseGrid = $this.getHrmanagementemployeewiseattendancegrid(),
    		store = employeeWiseGrid.getStore();
    		
    		// employeeWiseGrid.setLoading(true);
    		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    		Ext.defer(function() {
    			store.each(function(record){
        			if(isNullOrEmpty(record.get("intime"))  && isNullOrEmpty(record.get("outtime"))  ){
        				var defaultIntime = record.get("defaultIntime"),
            			defaultOuttime = record.get("defaultOuttime");
            			record.set('intime',defaultIntime);
            			record.set('outtime', defaultOuttime);

            			if (!isNullOrEmpty(defaultIntime) && !isNullOrEmpty(defaultOuttime)) {
            				var inTimeDate = new Date(defaultIntime);
            				inTimeDate.setFullYear(1970);
            				var inTimeInMiliSeconds = inTimeDate.getTime();
            				var outTimeDate = new Date(defaultOuttime);
            				outTimeDate.setFullYear(1970);
            				var outTimeInMiliSeconds = outTimeDate.getTime();

            				var timeDiff = outTimeInMiliSeconds - inTimeInMiliSeconds;
            				if(timeDiff < 0 ){

            				} else {
            					record.set('totaltime', timeDiff);
            				}
            			} else {
            				record.set('totaltime', null);
            			}
        			}
        			cnt = cnt+1;
        			if(record.store.getCount() == cnt){
        				// employeeWiseGrid.setLoading(false);
        				Ext.getBody().unmask();
        			}
        		});
        		employeeWiseGrid.getView().refresh();
    		}, 100);
    	}
    	else{
    		var dateWiseGrid = $this.getHrmanagementdatewiseattendancegrid(),
    		store = dateWiseGrid.getStore();
    		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    		Ext.defer(function() {
    			store.each(function(record){
    				if(isNullOrEmpty(record.get("intime"))  && isNullOrEmpty(record.get("outtime"))  ){
    					var defaultIntime = record.get("defaultIntime"),
    					defaultOuttime = record.get("defaultOuttime");
    					record.set('intime',defaultIntime);
    					record.set('outtime', defaultOuttime);

    					if (!isNullOrEmpty(defaultIntime) && !isNullOrEmpty(defaultOuttime)) {
    						var inTimeDate = new Date(defaultIntime);
    						inTimeDate.setFullYear(1970);
    						var inTimeInMiliSeconds = inTimeDate.getTime();
    						var outTimeDate = new Date(defaultOuttime);
    						outTimeDate.setFullYear(1970);
    						var outTimeInMiliSeconds = outTimeDate.getTime();

    						var timeDiff = outTimeInMiliSeconds - inTimeInMiliSeconds;
    						if(timeDiff < 0 ){

    						} else {
    							record.set('totaltime', timeDiff);

    						}
    					} else {
    						record.set('totaltime', null);
    					}
    				}
    				cnt = cnt+1;
        			if(record.store.getCount() == cnt){
        				// employeeWiseGrid.setLoading(false);
        				Ext.getBody().unmask();
        			}
    			});
    			dateWiseGrid.getView().refresh();
    		}, 100);
    	}
    },
    exportTimeSheetJRXML: function(fileType) {
    	var $this = this;
    	var structure = $this.getHrmemployeetimesheetstructure();
    	var portalId = this.getCurrentLoggedPortalId();
    	if (portalId == 1){
    		var filter = $this.getHrmtimesheetfilter();
        	var timeSheetPeriodId = filter.down('#timesheetPeriodItemId').getValue();
        	var timeSheetPeriodValue = structure.down('#empSalaryMonth').rawValue;
        	var employeeId = structure.config.employeeId;
        	user=this.getCurrentlyLoggedInUser();
    	}
    	else if(portalId == 2){
    		var filter = $this.getHrmtimesheetfilter();
        	var employeeId = structure.config.employeeId;
			var timeSheetPeriodId = structure.config.timeSheetPeriodId;
			var timeSheetPeriodValue = structure.config.timeSheetPeriodName;
        	user=this.getCurrentlyLoggedInUser();
    	}
    	// code to identify jasper
    	var dt = new Date();
    	var dateString = Ext.Date.format(dt, 'YmdHis'); 
    	var reportHeader = "EMPLOYEE_TIMESHEET_EXPORT_REPORT";
		var reportTitle = "Employee TimeSheet Export Report"+dateString;
    	var code = 'EMPLOYEE_TIMESHEET_EXPORT_REPORT';
    	var reportParams =new Object();
    	reportParams.code = code;
    	reportParams.reportTitle = reportTitle;
    	reportParams.headerName = reportHeader;
		reportParams.timeSheetPeriodId=String(timeSheetPeriodId); // convert int into string
		reportParams.employeeId=String(employeeId);
		reportParams.timeSheetPeriodValue=String(timeSheetPeriodValue);
    		var exportUrl = SERVERURL.HRM_EMP_TIMESHEET_PRINT_PDF;
    		this.exportJRXMLReport(code,reportParams,reportTitle,'.pdf',exportUrl);
    },
    
	exportXlsEmpWorkHours : function() {
		var $this = this;
		var form = $this.getHrmworkinghourreportfilter().getForm();
		//var exportType = $this.getAttendanceregisterwindow().down("#exportType");
		var values = form.getValues();
		var dt = new Date();
    	var dateString = Ext.Date.format(dt, 'YmdHis'); 
		var reportTitle = "Working Hour-Pivot"+"_"+dateString;
		var code = 'EMPLOYEE_WORK_HOURS_XCEL_EXPORT_REPORT';
		//var attendanceType  = $this.getAttendancereprotstructure().getForm().findField('studentAttendanceType').getValue();
		var staffId =form.findField('employeeId');
		if(staffId!=null){
			staffId =staffId.getValue();
			}
		
		var academyLocationIds =$this.getCurrentAcademyLocation();
		var userGroup =form.findField('userGroupId');
		if(userGroup!=null){
			userGroup = userGroup.getValue();
		}
		var departmentId =form.findField('departmentId')
		if(values.department!=null){
			departmentId= values.department.id;
		}
		
		var reportParams = new Object();
		reportParams.staffId = staffId;
		reportParams.academyLocationIds = academyLocationIds;
		reportParams.userGroup = userGroup;
		reportParams.departmentId = values.department;
		reportParams.isEmployeeWithNoCalendar = values.viewEmployeeWithNoCalendar;
		
		reportParams.headerName = getProgramandcourseTranslation('Employee Work Hours Report');
		$this.exportJRXMLReport(code, reportParams, reportTitle, '.vnd.ms-excel', SERVERURL.EMPLOYEE_WORK_HOURS_XCEL_EXPORT_REPORT);
	},
	exportXlsEmpAttendanceRegister : function() {
		var $this = this;
    	var form = $this.getHrmattendancesummaryreportfilter();

    	var attendanceSummaryGrid = $this.getHrmattendancesummaryreportgrid();
		//var exportType = $this.getAttendanceregisterwindow().down("#exportType");
		var values = form.getValues();
		var dt = new Date();
    	var dateString = Ext.Date.format(dt, 'YmdHis'); 
		var reportTitle = "Employee Attendance Register"+"_"+dateString;
		var code = 'EMPLOYEE_ATTENDANCE_REGISTER_XCEL_EXPORT_REPORT';
		
		//var attendanceType  = $this.getAttendancereprotstructure().getForm().findField('studentAttendanceType').getValue();
		var departmentId = form.down("#departmentItemId");
		if(departmentId!=null){
			departmentId =departmentId.getValue();
			}
		
		var academyLocationIds =$this.getCurrentAcademyLocation();
		var userGroup = form.down("#userGroupItemId");
		if(userGroup!=null){
			userGroup = userGroup.getValue();
		}
		var startDate = form.down("#fromDateItemId");
		if(startDate!=null){
			startDate=startDate.getValue();
		}
		
		var endDate = form.down("#toDateItemId");
		if(endDate!=null){
			endDate= endDate.getValue();
		}
		if(endDate!=null && startDate!=null) {
			var reportParams = new Object();
			reportParams.startDate = startDate;
			reportParams.endDate = endDate;
			reportParams.userGroup = userGroup;
			reportParams.departmentId = values.department;
			
			reportParams.headerName = getProgramandcourseTranslation('Employee Attendance Register');
			$this.exportJRXMLReport(code, reportParams, reportTitle, '.vnd.ms-excel', SERVERURL.HRM_EMP_ATTENDACE_REGISTER_REPORT);
		} else {
			showWarningMessage(getCommonTranslation('ALERT'), 'Please select From Date and To Date');
		}
		
	},
	
	exportXlsEmpAttendanceReport : function() {
		var $this = this;
    	var portalId = this.getCurrentLoggedPortalId();
    	if (portalId == 1){
    		var form = $this.getHrmemployeeattendancefilter();
    		var values = form.getValues();
    		var employeeId =form.down('#employeeItemId');
    		if(employeeId!=null){
    			employeeId =employeeId.getValue();
    		}
    	}
    	else if(portalId == 2){
    		var form = $this.getHrmmyattendancefilter();
    		var values = form.getValues();
    		var employeeId = $this.getCurrentlyLoggedInUser().id;
    	}
    	var dt = new Date();
    	var dateString = Ext.Date.format(dt, 'YmdHis'); 
		var reportTitle = "Employee Wise Attendance Report"+"_"+dateString;
		var code = 'EMPLOYEE_WISE_ATTENDANCE_EXCEL_EXPORT_REPORT';
		var reportHeader = "Employee Wise Attendance Report";
		var startDate = form.down("#startDateItemId");
		var arrival=form.down("#lateArrivalEarlyGoingEWId");
		if(arrival!=null){
			arrival=arrival.getValue();
		}
		if(startDate!=null){
			startDate=startDate.getValue() ;
		}
		
		var endDate = form.down("#endDateItemId");
		if(endDate!=null){
			endDate= endDate.getValue();
		}
		var reportParams = new Object();
		reportParams.startDate = startDate;
		reportParams.endDate = endDate;
		reportParams.employeeId = employeeId;
		reportParams.headerName = reportHeader;
		reportParams.arrival=arrival;
		$this.exportJRXMLReport(code, reportParams, reportTitle, '.vnd.ms-excel', SERVERURL.HRM_EXPORT_EMPLOYEE_ATTENDANCE_EXCEL_REPORT);
	},
	
	exportXlsDateWiseEmployeeAttendanceReport : function() {
		var $this = this;
    	var form = $this.getHrmemployeeattendancefilter();
		var values = form.getValues();
		var dt = new Date();
    	var dateString = Ext.Date.format(dt, 'YmdHis'); 
		var reportTitle = "Date Wise Employee Attendance Report"+"_"+dateString;
		var code = 'DATE_WISE_EMPLOYEE_ATTENDANCE_EXCEL_EXPORT_REPORT';
		var reportHeader = "Date Wise Employee Attendance Report";
		var departmentId = form.down("#departmentItemId");
		var arrival = form.down("#lateArrivalEarlyGoingDWId");
		if(arrival!=null){
			arrival=arrival.getValue();
		}
		if(departmentId!=null){
			departmentId =departmentId.getValue();
			}
		
		var academyLocationIds =$this.getCurrentAcademyLocation();
		var userGroup = form.down("#userGroupItemId");
		if(userGroup!=null){
			userGroup = userGroup.getValue();
		}
		var date = form.down("#dateItemId");
		if(date!=null){
			date=date.getValue() ;
		}
		
		var reportParams = new Object();
		reportParams.date = date;
		reportParams.userGroup = userGroup;
		reportParams.departmentId = departmentId;
		reportParams.headerName = reportHeader;
		reportParams.arrival=arrival
		$this.exportJRXMLReport(code, reportParams, reportTitle, '.vnd.ms-excel', SERVERURL.HRM_EXPORT_DATE_WISE_EMPLOYEE_ATTENDANCE_EXCEL_REPORT);
	},
	
	addHRMTimesheetPeriodWindow: function() {
        var winHRMTimesheetPeriodWindow = Ext.widget('hrmtimesheetperiodwindow');
        winHRMTimesheetPeriodWindow.show();
    },
    
    editHRMTimesheetPeriod: function(isView){
        var me = this;
        var grid = me.getHrmtimesheetperiodgrid();
        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection();
            me.showHRMTimesheetPeriodForm();
            if (records != "" && records != null && records != undefined) {
                var hrmTimesheetPeriodFormWin = me.getHrmtimesheetperiodwindow();
                var formPnl = hrmTimesheetPeriodFormWin.down('form');
                formPnl.down('#hrmTimesheetPeriodId').setValue(records[0].data.id);
                formPnl.down('#timesheetNameItemId').setValue(records[0].data.name);
                formPnl.down('#startDate').setValue(dateRender(records[0].data.startDate));
                formPnl.down('#endDate').setValue(dateRender(records[0].data.endDate));
                formPnl.down('#daysItemId').setValue(records[0].data.days);
                formPnl.down('#version').setValue(records[0].data.version);
                
                var timesheetPeriodType = records[0].data.timesheetPeriodType.toUpperCase()
                formPnl.down('#timesheetPeriodTypeItemId').setValue({timesheetPeriodType : timesheetPeriodType});
                if(timesheetPeriodType != 'FIXED') {
                	formPnl.down('#daysItemId').setVisible(false);
                	formPnl.down('#daysItemId').setValue(1);
                }
                if (isView) {
                	hrmTimesheetPeriodFormWin.down('#btnSaveTimesheetPeriodForm').setVisible(false);
                    toggleReadOnlyFormItems(formPnl.getForm(), true);
                }
            }
        } else {
        	showWarningMessage(getPersonModuleTranslation('HRM_TIMESHEET_PERIOD'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
        }
    },
    showHRMTimesheetPeriodForm: function() {
        var hrmTimesheetPeriodWin = this.getHrmtimesheetperiodwindow();
        if (isEmpty(hrmTimesheetPeriodWin)) {
        	hrmTimesheetPeriodWin = Ext.widget('hrmtimesheetperiodwindow');
        }
        hrmTimesheetPeriodWin.show();
    },
    cancelHRMTimesheetPeriodForm: function(){
    	this.getHrmtimesheetperiodwindow().close();
    },
    saveHRMTimesheetPeriod: function(){
     var $this = this;
     var win = this.getHrmtimesheetperiodwindow();
     var hrmTimesheetPeriodObject = this.getHRMTimesheetPeriodObject();
         
     var serverURL = SERVERURL.PATH_SAVE_TIMESHEET_PERIOD;
     var isUpdate = false;
     
     if(!isNullOrEmpty(win.down('#hrmTimesheetPeriodId').getValue())) {
    	 serverURL =  SERVERURL.PATH_UPDATE_TIMESHEET_PERIOD;
    	 isUpdate = true;
     }
     var jsonHRMTimesheetPeriodObject = Ext.encode(hrmTimesheetPeriodObject);
   	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
     Ext.Ajax.request({
         type: 'rest',
         url: serverURL,
         jsonData: jsonHRMTimesheetPeriodObject,
         method: 'POST',
         success: function(form, action) {
 			if (!isNullOrEmpty(form.responseText) && form.responseText.length > 0) {
				showWarningMessage(getPersonModuleTranslation('HRM_TIMESHEET_PERIOD'), getErrorTranslation(form.responseText));
			} else {
				win.close();
				var grid = $this.getHrmtimesheetperiodgrid();
				$this.resetPageSetting(grid.getStore());
				grid.getStore().load();
				grid.getSelectionModel().deselectAll();
				if (isUpdate) {
					showSuccessMessage(getPersonModuleTranslation('HRM_TIMESHEET_PERIOD'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
				} else {
					showSuccessMessage(getPersonModuleTranslation('HRM_TIMESHEET_PERIOD'), getCommonTranslation('RECORD_ADD_SUCCESS'));
				}
			}
 			Ext.getBody().unmask()
		}
     });
   },
   
   getHRMTimesheetPeriodObject : function(){
	     var win = this.getHrmtimesheetperiodwindow();
	     var hrmTimesheetPeriodObject = new Object();
	     
	     var sDate = win.down('#startDate').getValue();
	     var eDate = win.down('#endDate').getValue();
	     var timesheetPeriodType = win.down('#timesheetPeriodTypeItemId').getValue().timesheetPeriodType;
	     
	     hrmTimesheetPeriodObject.id = win.down('#hrmTimesheetPeriodId').getValue();
	     hrmTimesheetPeriodObject.name = win.down('#timesheetNameItemId').getValue();
	     hrmTimesheetPeriodObject.timesheetPeriodType = timesheetPeriodType;
	     hrmTimesheetPeriodObject.startDate = sDate
	     hrmTimesheetPeriodObject.endDate =  eDate;
	     hrmTimesheetPeriodObject.version =  win.down('#version').getValue();;
	     
	     if(timesheetPeriodType == 'DYNAMIC') {
	    	 var dateDiff = eDate.getTime() - sDate.getTime();
		     var days = dateDiff/(1000*3600*24);
		     days = days + 1 ;
		     hrmTimesheetPeriodObject.days = days;
	     } else{
	    	 hrmTimesheetPeriodObject.days = win.down('#daysItemId').getValue();
	     }
	     return hrmTimesheetPeriodObject;
   },
   
   deleteHRMTimesheetPeriod: function() {
	   var this$ = this;
	   var grid = this.getHrmtimesheetperiodgrid();
	   var grdStore = grid.getStore();
	   if (grid.getSelectionModel().getCount() > 0) {
		   showConfirmMessage(getPersonModuleTranslation('HRM_TIMESHEET_PERIOD'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
			   if (btn == 'yes') {
				   var records = grid.getSelectionModel().getSelection();
				   var id = records[0].data.id;
				   Ext.Ajax.request({
					   type: 'rest',
					   method: 'DELETE',
					   url: SERVERURL.PATH_DELETE_TIMESHEET_PERIOD,
					   headers: {
						   'Content-Type': 'application/json'
					   },
					   params: {
						   id: id
					   },
					   success: function(form, action) {
						   showSuccessMessage(getPersonModuleTranslation('HRM_TIMESHEET_PERIOD'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
						   this$.resetPageSetting(grdStore);
						    grdStore.load();
					   },
				   });
			   }
		   });
	   } else {
		   showWarningMessage(getPersonModuleTranslation('HRM_TIMESHEET_PERIOD'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	   }
   },
   loadMyTimesheetGridData : function() {
       var filter = this.getHrmmytimesheetfilter();
       var grid = this.getHrmmytimesheetgrid();
       var formValues = filter.getValues();
       var timesheetPeriodId = formValues.timesheetPeriodId;
       var empId = this.getCurrentlyLoggedInUser().id;
       var store = grid.getStore();
       store.getProxy().extraParams = {
       	timeSheetPeriodId: timesheetPeriodId,
       	employeeId: empId
       };
       store.load();
   },
   loadMyAttendanceGrid:function(){
       var $this = this;
       var filter = $this.getHrmmyattendancefilter();
       var employeeWiseStructure = $this.getHrmanagementemployeewiseattendancestructure();
       var employeeWiseGrid = $this.getHrmanagementemployeewiseattendancegrid();

       var employeeId = this.getCurrentlyLoggedInUser().id;
       var startDateItemId = filter.down('#startDateItemId');
       var endDateItemId = filter.down('#endDateItemId');
       var lateArrivalEarlyGoing = filter.down('#lateArrivalEarlyGoingId');

       employeeWiseStructure.setVisible(true);
       startDateItemId = Ext.Date.format(startDateItemId.getValue() ,'Y-m-d H:i:s.u');
       endDateItemId = Ext.Date.format(endDateItemId.getValue() ,'Y-m-d H:i:s.u');
       var store = employeeWiseGrid.getStore();
       var url = SERVERURL.HRM_FIND_EMPLOYEE_DAILY_ATTENDANCE_LIST;
       url = url.concat('?attendanceBy=EmployeeWise&employeeId='+ employeeId+'&startDate='+ startDateItemId+'&endDate='+ endDateItemId+'&lateArrivalEarlyGoing=' +lateArrivalEarlyGoing.getValue());
       Ext.Ajax.request({
           type: 'rest',
           url: url,
           method: 'GET',
           async: true,
           params: null,
           headers: {
               'Content-Type': 'application/json'
           },
           success: function(frm, action) {
               var data = frm.responseText;
               Ext.getBody().unmask();
               if(!isNullOrEmpty(data)){
                   var decodedResponse = Ext.decode(data);
                   var dailyAttendanceModels = decodedResponse.dailyAttendanceModels;
                   var employeeAttendanceSummaryModel = decodedResponse.employeeAttendanceSummaryModel;
                   var store1 = Ext.create('Academia.store.hrm.HRManagementEmployeeWiseAttendanceStore');
                   var store2 = Ext.create('Academia.store.hrm.HRManagementEmployeeWiseAttendanceStore');
                   
                   store1.removeAll();
                   store1.add(dailyAttendanceModels);
                   
                   store2.removeAll();
                   store2.add(employeeAttendanceSummaryModel);
                   
                   var employeeWiseGrid = $this.getHrmanagementemployeewiseattendancegrid();
                   var summaryGrid = Ext.ComponentQuery.query('hrmanagementemployeewiseattendancesummarygrid')[0];
                   
                   employeeWiseGrid.reconfigure(store1);
                   summaryGrid.reconfigure(store2);
                   
                   employeeWiseGrid.getView().refresh();
                   summaryGrid.getView().refresh();
                   
                   employeeWiseGrid.getSelectionModel().deselectAll(true);
                   summaryGrid.getSelectionModel().deselectAll(true);
                   
                   if (dailyAttendanceModels.length > 0) {
                       employeeWiseGrid.down('#exportReportItemId').setDisabled(false);
                   } else {
                       employeeWiseGrid.down('#exportReportItemId').setDisabled(true);
                   }
               }
           }
       });
   },
   disableMyAttendancePunchLogTab:function(structure,permissionsMap){
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		var empAttendancePunchLogStructure = structure.down('#hrmmypunchlogtabstructureItemId');
		var empAttendancePunchLogStructuretab=false;
		var empSearchStructure = structure.down("#hrmmyattendancetabstructureItemId");
		var empSearchStructure=false;
		
		Ext.each(permissionList, function(privilege) {
			if (privilege === 'VIEW') {
				empAttendancePunchLogStructuretab = true;
			}
		});
		this.showMyAttendanceTab(empAttendancePunchLogStructuretab, structure);
	},
	showMyAttendanceTab : function(empAttendancePunchLogStructuretab, structure) {
		var panelItem = new Array();
		var $this = this;
		var newcont=structure.items.items.length;
		var insertPosition=newcont+1;
		if(!Ext.ComponentQuery.query("hrmmyattendancetabstructure")[0]){
		
			var panelItem = new Array();
 			var $this = this;
 			var newcont = structure.items.items.length;
 			var insertPosition = newcont;
 			panelItem.push({
 				xtype : 'tabpanel',
 				itemId : 'allVisibleTP',
 				plain : true,
 				
 				style : {
 					overflow : 'hidden !important'
 				},
 				frame : false,
 				border : false,
 				defaults : {
 					labelAlign : 'top'
 				},
 				items : [{
		        	xtype: 'hrmmyattendancetabstructure',
					title: getPersonModuleTranslation('HRM_DAILY_ATTENDANCE'),
					tabCls: 'right-tab'
 				}]
 			});
			
			
			var insertAt = panelItem["0"].items.length;
 			
 			if (empAttendancePunchLogStructuretab) {
 				panelItem["0"].items[insertAt] = {
 						xtype:'hrmmypunchlogtabstructure',
						itemId:'hrmmypunchlogtabstructureItemId',
						title: getPersonModuleTranslation('HRM_MY_ATTENDANCE_PUNCH_LOG')
 				};
 				insertAt = insertAt + 1;
 			}
 			
			structure.insert(insertPosition,panelItem);
		}
	},
	
	loadMyPunchLogGrid:function(){
		var filter = this.getHrmmypunchlogfilter();
		var grid = this.getHrmmypunchloggrid();
		var formValues = filter.getValues();
		var empId = this.getCurrentlyLoggedInUser().id;
		var startDate =  new Date(formValues.startDate);
		
		/*startDate = startDate.getTime();
		endDate = formValues.endDate.concat(' 23:59:59')
        endDate = new Date(endDate);
		endDate = endDate.getTime();*/
		
	if (startDate != null) {
			startDate = new Date(startDate);
			startDate = Ext.Date.format(startDate, 'Y-m-d');
		}
		var endDate =  new Date(formValues.endDate);
		if (endDate != null) {
			endDate = new Date(endDate);
			endDate = Ext.Date.format(endDate, 'Y-m-d');
		}
		var store = grid.getStore();
		store.getProxy().extraParams = {
			staffId: empId,
			fromDate:startDate,
			toDate:endDate
		};
		store.removeAll();
		store.loadPage(1);
	},
	
	changePunchLogFilterDate:function(){
		var $this = this;
		var form = $this.getHrmattendancepunchlogreportfilter();
		var fromDateFld = form.down('#fromDateItemId');
		var toDateFld = form.down('#toDateItemId');

		toDateFld.reset();
		var val = fromDateFld.getValue();
		var eDate = Ext.Date.add(val, Ext.Date.MONTH, 1);
		toDateFld.setMaxValue(eDate);
		fromDateFld.setMaxValue(null);
	},
	cellClickHRMWorkingHourReport: function(view, td, cellIndex, record, tr, rowIndex, e, eOpts){
		var $this = this;
		if (e.target.tagName == 'A') {
			var associatedAcadLocationIds = new Array();
			associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getFACULTY_WORK_HOURS_PERMISSIONS());
			var flag = true;
			Ext.each(permissionList, function(privilege) {
				if (privilege == 'VIEW') {
					flag=false;
				}
			});
			if(flag){
				showErrorMessage(getCommonTranslation('ROLE'), getPersonModuleTranslation('HRM_YOU_DO_NOT_HAVE_PERMISSION_ACCESS_MSG'));
				return;
			}
			else{
				var xType = '', tabTitle = '';
				facultyProfile=record;
				tabTitle = 'Work Hours';
				var userId = record.get('userId');
				var personId = record.get('personId');
				xType = 'hrmworkinghourtabdetail';
				var closable = null;
				if(isNullOrEmpty(closable)){
					closable = true;
				}
				var contentPanel = this.getContentpanel(); //get hold of the content panel where we are adding all the tabs
				var getcontroller=this.getController('menu.CoreERPNavigationController');
				var getTab=getcontroller.getTab(tabTitle);
				if(getTab!=null){
					contentPanel.remove(getTab, true);
				}
				var newTab = this.getTabReferenceByTabTitle(tabTitle);
				if (!newTab) {
					newTab = contentPanel.add({
						xtype: xType,
						closable: closable,
						title: tabTitle,
						menuColorCls:CONSTANTS.MENU_COLOR_EIGHT
					});
				}
				var grid = this.getStaffworkhoursgrid();
				grid.config.userId= userId;
				grid.config.personId= personId;
				contentPanel.setActiveTab(newTab);
			}
		}    
	},
	workHourDetailsByCalendar: function(view, td, cellIndex, record, tr, rowIndex, e, eOpts) {
		var this$ = this;
		var frmWin=this$.getEmployeeworkhourswindow();
		if(!frmWin){
			Ext.widget('employeeworkhourswindow');
			frmWin = this.getEmployeeworkhourswindow();
		}
		frmWin.show();

		// var gridStaffWorkHour = this.getStaffworkhoursgrid();
		var gridStaffWorkHour = this$.getContentpanel().getActiveTab().down('staffworkhoursgrid');
		var record=gridStaffWorkHour.getSelectionModel().getSelection()[0];
		var employeeGrid=this$.getEmployeeworkhourswindow();
		var grid=employeeGrid.down('#employeeWorkHourId');

		grid.getStore().getProxy().api.read = SERVERURL.FIND_WORK_HOUR_BY_CALENDAR_ID; //URL - :rest/applicationProgram/findOfferLetterAccepted
		this$.resetPageSetting(grid.getStore());
		grid.getStore().load({
			params: {
				calendarId : record.data.calendarId,
				staffId:record.data.staffId
			},
			callback: function(record, operation, success) {
				if (record.length > 0) {
					this$.toggleGridSummaryRow(grid,true);
				}else{
					this$.toggleGridSummaryRow(grid,false);
				}
			}
		});          	
		var weekday=frmWin.down('#weekday');
		var startTime=frmWin.down('#startTime');
		var endTime=frmWin.down('#endTime');
		var lateComingAllowedTill=frmWin.down('#lateComingAllowedTill');
		var earlyGoingAllowedAfter=frmWin.down('#earlyGoingAllowedAfter');
		var totalHours=frmWin.down('#totalHours');
		var minHoursOfFullDay=frmWin.down('#minHoursOfFullDay');
		var minHoursOfHalfDay=frmWin.down('#minHoursOfHalfDay');
	},
	openAssignCalendarWindowHRM: function() {
    	var $this = this;
    	var formWindow = $this.getAssignworkcalendarwindow();
    	if(!formWindow){
    		formWindow = Ext.widget('assignworkcalendarwindow',{
    			itemId:'hrmAssignworkcalendarwindowItemId'
    		});
    		formWindow.setHeight(180);
    		formWindow.setWidth(780);
    	}
    	var calendarStore = formWindow.down('#calendarId').getStore();
    	calendarStore.load();
    	formWindow.show();
    },
    editEmployeeCalendarHRM:function(){
  	   var $this = this;	  
  	  var grid = $this.getContentpanel().getActiveTab().down('staffworkhoursgrid');
  	   if (grid.getSelectionModel().getCount() > 0) {
  		   var formWindow = $this.getAssignworkcalendarwindow();
  		   if (!formWindow) {
  			 formWindow = Ext.widget('assignworkcalendarwindow',{
     			itemId:'hrmAssignworkcalendarwindowItemId'
     		});
  			   formWindow = $this.getAssignworkcalendarwindow();
  		   }
  		   formWindow.show();
  		   var form = $this.getAssignworkcalendarwindow();
  		   var record = grid.getSelectionModel().getSelection()[0];
  		   form.down('#startDate').setValue(record.data.startDate);
  		   form.down('#endDate').setValue(record.data.endDate);
  		   var calendarId=form.down('#calendarId').getValue();
  		   var calendarStore = form.down('#calendarId');
  		   form.down('#id').setValue(record.data.id);
  		   form.down('#assignCalendarId').setValue(record.data.calendarId);
  		  calendarStore.getStore().load({
  			   callback: function(records, operation, success) {
  				   calendarStore.setRawValue(record.data.calendarName);
  				   calendarStore.setReadOnly(true);
  				   calendarStore.up('form').getForm().checkValidity();
  			   }
  		   }); 
  		   form.setTitle(getCommonTranslation('EDIT_EMPLOYEE_CALENDAR'));
  	   }
  	   else{
  		 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
  	   }
     },
     saveAssignWorkCalendarHRM: function(record) {
     	var $this = this;
     	var formWindow = $this.getAssignworkcalendarwindow();
     	var form = formWindow.down('#assignworkcalendar');
     	var formValues = form.form.getValues();
     	var grid = this.getContentpanel().getActiveTab().down('staffworkhoursgrid');
     	var startDate = formWindow.down('#startDate').getValue();
     	var endDate = formWindow.down('#endDate').getValue();
     	var id = formWindow.down('#id').getValue();
     	var assignCalendarId = formWindow.down('#assignCalendarId').getValue();
     	var calendarId = formWindow.down('#calendarId').getValue();
     	var staffId;
     	if(this.getContentpanel().getActiveTab().xtype == 'hrmworkinghourtabdetail') {
     		staffId = grid.config.userId;
     	}
     	var submitUrl, isUpdate = false;
     	var validateCalendar = true;
     	var isUpdateCalendar = null;
     	if (isNullOrEmpty(id)) {
     	    submitUrl = SERVERURL.STAFF_CALENDAR_CREATE;
     	    isUpdate = false;
     	    var calendarValue = {
     	        id: calendarId
     	    };
     	    isUpdateCalendar = false;
     	} else {
     	    submitUrl = SERVERURL.STAFF_CALENDAR_UPDATE;
     	    isUpdate = true;
     	    var calendarValue = {
     	        id: assignCalendarId
     	    };
     	    isUpdateCalendar = true;
     	}
     	var staffValue = {
     	    id: staffId
     	};
     	
     	// TO DO
         var configureArray = [];
         var calendarFormformData = new Academia.model.calendar.StaffCalendarGridModel();
         if (isUpdate) {
             calendarFormformData.set("id", id);
             calendarFormformData.set("calendarId", assignCalendarId);
             calendarFormformData.set("staffId", staffId);
             calendarFormformData.set("startDate", startDate);
             calendarFormformData.set("endDate", endDate);
             configureArray.push(calendarFormformData.data);
         } else {
         	 if(this.getContentpanel().getActiveTab().xtype == 'hrmworkinghourtabdetail') {
         		calendarFormformData.set("id", id);
                 calendarFormformData.set("calendarId", calendarId);
                 calendarFormformData.set("staffId", staffId);
                 calendarFormformData.set("startDate", startDate);
                 calendarFormformData.set("endDate", endDate);
                 configureArray.push(calendarFormformData.data);
         	}
         }
         configureArray = Ext.encode(configureArray);
         Ext.getBody().mask();
         Ext.Ajax.request({
             type: 'rest',
             url: submitUrl,
             jsonData: configureArray,
             method: 'POST',
             success: function(frm, action) {
                 Ext.getBody().unmask();
                 if (isUpdate) {
                     showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('UPDATED_STAFF_CALENDAR_SUCCESSFULLY'));
                     formWindow.close();
                     grid.getStore().load();
                     grid.getSelectionModel().deselectAll();
                 } else {
                     showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('ASSIGN_CALENDAR_SUCCESSFULLY'));
                     formWindow.close();
                    if(!isNullOrEmpty(grid)) {
                     grid.getStore().load();
                     grid.getSelectionModel().deselectAll();
                    }else if(!isNullOrEmpty($this.getSearchResultGrid())) {
                 	   $this.getSearchResultGrid().getSelectionModel().deselectAll();
                    }
                 }
             }
         });
     },
     
     downloadTimeSheetRecord: function(){
 		var this$ = this;
 		var filter = this.getHrmtimesheetfilter();
 		var grid = this.getHrmtimesheetgrid();
 		var formValues = filter.getValues();
         var timeSheetPeriodId = formValues.timesheetPeriodId;
 		var records = grid.getSelectionModel().getSelection();
 		var academyLocationId = $this.getCurrentAcademyLocation();
 		var currentLoggedUser = $this.getCurrentlyLoggedInUser();
 		var flag = true;
 		var employees = []
		var employeeIds;
 		if(!isNullOrEmpty(records) && records.length > 0) {
 			for( var i=0; i<records.length; i++ ) {
 				if(!isNullOrEmpty(records[i].data.timeSheetStatus)){
 					var empObj = {
 							academylocationid:academyLocationId,
 							employeeId:records[i].data.empId,
 							employeeCode:records[i].data.empCode,
 							timeSheetPeriodValue:records[i].data.timeSheetPeriodName,
 							timeSheetPeriodId:records[i].data.timeSheetPeriodId,
 							userId:currentLoggedUser.code
 					}
 					employees.push(empObj);
 				}
 				else{
 					flag = false;
 				}
 			}
 			if(flag == true) {
 				employeeIds = Ext.encode(employees);
 				var isSuccess = true;
 				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
 				Ext.Ajax.timeout= 90000;
 				Ext.Ajax.request({
 					type: 'rest',
 					url: SERVERURL.HRM_EMP_BULK_TIMESHEET_PDF,
 					method: 'POST',
 					jsonData: employeeIds,
 					headers: {
 						'Content-Type': 'application/json'
 					},
 					success: function(form, action) {
 						Ext.create('widget.uxNotification', {
 		 					title: 'Notification',
 		 					position: 'br',
 		 					manager: 'instructions',
 		 					cls: 'ux-notification-light',
 		 					iconCls: 'ux-notification-icon-information',
 		 					html: getPersonModuleTranslation('HRM_TIMESHEET_DOWNLOAD_PROCESS_COMPLETE_MSG'),
 		 					autoCloseDelay: 4000,
 		 					slideBackDuration: 500,
 		 					autoClose:true,
 		 					slideInAnimation: 'bounceOut',
 		 					slideBackAnimation: 'easeIn',
 		 					resizable:false
 		 					}).show();
 					},
			        failure: function(form, action) {
			        	isSuccess = false;
			        	//showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
			        }
 				});
 				
 				setTimeout(function(){
 					if(isSuccess){
 						Ext.getBody().unmask();
 	 	 				//showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('HRM_TIMESHEET_DOWNLOAD_SUCCESSFULLY_MSG'));
 	 	 				showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('HRM_TIMESHEET_PROCESS_STARTED_MSG'));
 					}
 					grid.getSelectionModel().deselectAll(true);	
 				},2000);
 				
				//this$.loadTimesheetGridData();
 				
 			} else {
 				showWarningMessage(getCommonTranslation('ALERT'), getPersonModuleTranslation('HRM_TIMESHEET_HAS_NOT_BEEN_GENERATED_MSG'));
 			}
 			
 		} else {
 			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
 		}
     },
     
     loadStudentPunchLogReportGridData : function(){
    	 var $this = this;
    	 var form = $this.getBmstudentpunchlogreportfilter();
    	 form.down('#searchStudentPunchLogReportFilterItemId').setDisabled(true);
    	 var studentId = form.down("#studentId").getValue();
    	 var programId = form.down("#program").getValue();

    	 var batchId = form.down("#batch").getValue();
    	 var startDate = form.down("#fromDateItemId");
    	 if(startDate!=null){
    		 startDate=startDate.getValue();
    		 startDate = startDate.getTime();
    	 }

    	 var endDate = form.down("#toDateItemId");
    	 if(endDate!=null){
    		 endDate= endDate.getValue();
    		 endDate = endDate.toString().replace('00:00:00','23:59:59')
    		 endDate = new Date(endDate).getTime();
    	 }
    	 var bmstudentpunchlogreportgrid = $this.getBmstudentpunchlogreportgrid();

    	 var store = bmstudentpunchlogreportgrid.getStore();
    	 store.getProxy().extraParams = {
    		 studentId: studentId,
    		 programId: programId,               
    		 batchId: batchId,
    		 fromDate:startDate,
    		 toDate:endDate
    	 };
    	 $this.resetPageSetting(store);
    	 store.load({
    		 callback: function(records, operation, success) {
    			 form.down('#searchStudentPunchLogReportFilterItemId').setDisabled(false);
    			 Ext.getBody().unmask();
    		 }
    	 });
    	 bmstudentpunchlogreportgrid.config.searchFilterForm =  $this.getBmstudentpunchlogreportfilter();
     }
});