/**
 * @author Bhanu PS
 */
Ext.define('Academia.controller.leavemanagement.LeaveSettingController', {
	extend: 'Academia.controller.base.BaseController',

    stores: ['leavemanagement.LeaveTypeStore', 'leavemanagement.EligibilityEnumStore', 'common.StatusComboStore','leavemanagement.LeaveTypeGridStore','leavemanagement.EligibilityALGridStore','leavemanagement.ApplyToSelectedALGridStore',
             'leavemanagement.LeavePeriodEnumStore','leavemanagement.EligibilityCodeStore','leavemanagement.EligibilitySettingGridStore','leavemanagement.MonthsStore','common.AcademyLocationNameSeparated',
             'leavemanagement.EligibilityEnumStore','leavemanagement.EmployeeAttributeStore','leavemanagement.EnumEmployeeAttributeStore','department.DepartmentStore','leavemanagement.EligibilityLeaveTypeGridStore','leavemanagement.EmpLeaveUserGroupAttributeValue'],
             
    views: ['leavemanagement.LeaveSettingStructure','leavemanagement.EligilibitySettingFilter','leavemanagement.EligilibitySettingForm','leavemanagement.LeaveSettingsGrid',
            'leavemanagement.AddEligibilitySetting','leavemanagement.ApplyToSettingFilter','leavemanagement.SettingsApplyToGrid','leavemanagement.AddApplyToSettingFilter',
            'leavemanagement.AddApplyToSettingForm','leavemanagement.EligibilityMappedAlWindow'],
            
    
            
    refs: [{
    	ref: 'contentPanel',
        selector: 'contentpanel'
    },{
    	ref: 'leavesettingstructure',
        selector: 'leavesettingstructure'
    },{
    	ref: 'eligilibitysettingfilter',
        selector: 'eligilibitysettingfilter'
    },{
    	ref: 'eligilibitysettingform',
        selector: 'eligilibitysettingform'
    },{
    	ref: 'leavesettingsgrid',
        selector: 'leavesettingsgrid'
    },{
    	ref: 'addeligibilitysetting',
        selector: 'addeligibilitysetting'
    },{
    	ref: 'applytosettingfilter',
        selector: 'applytosettingfilter'
    },{
    	ref: 'settingsapplytogrid',
        selector: 'settingsapplytogrid'
    },{
    	ref: 'addapplytosettingfilter',
        selector: 'addapplytosettingfilter'
    },{
    	ref: 'addapplytosettingform',
        selector: 'addapplytosettingform'
    },{
    	ref: 'eligibilitymappedalwindow',
        selector: 'eligibilitymappedalwindow'
    }],
    config: {
    	FACULTY_UNASSIGNEDREQUEST_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_UNASSIGNEDREQUEST_PRIVILEGES'),
    	FACULTY_FOLLOWUPSCHEDULED_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_FOLLOWUPSCHEDULED_PRIVILEGES'),
    	FACULTYDASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTYDASHBOARD_PRIVILEGES')
    },
    init: function(application) {
        this.control({
        	'leavesettingsgrid': {
        		beforerender: function() {
        			this.getStore('leavemanagement.EligibilitySettingGridStore').removeAll();
        		}
        	},
       	 'leavesettingsgrid button#btnAdd':{
			   click: function(obj, record) {
				   this.openAddEligibilitySettingTab('ADD');
			   }
		   },
		   
		   'leavesettingsgrid button#btnEdit':{
			   click: function(obj, record) {
				   this.openEditableEligibilitySettingTab();
			   }
		   },
		   
		   'settingsapplytogrid button#btnAdd':{
			   click: function(obj, record) {
				   this.openAddApplyToEligibility('ADD');
			   }
		   },
		   
		   'settingsapplytogrid button#btnEdit':{
			   click: function(obj, record) {
				   var $this = this;
				   var grid= $this.getSettingsapplytogrid();
				   if (grid.getSelectionModel().getCount() > 0) {
					   $this.openAddApplyToEligibility('EDIT');
					   $this.editApplyToEligibility();
				   } else{
					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				   }
			   }
		   },
		   
		   'settingsapplytogrid button#btnDelete':{
			   click: function(obj, record) {
				   var $this = this;
				   var grid= $this.getSettingsapplytogrid();
				   if (grid.getSelectionModel().getCount() > 0) {
					   $this.deleteEligibilitySettingFunction();
				   } else{
					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				   }
			   }
		   },
		   
		   'settingsapplytogrid ': {
            cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
          	 var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
          	 if (e.target.tagName == 'A') {
          		 this.openEligibilitySettingDetailsWindow(columnName, record, ColIdx);
          	 }
			}
		  }, 
		   
		   'addapplytosettingform button#saveBtn':{
			   click: function(obj, record) {
				   this.saveApplyToEligibility();
			   }
		   },
		   
		   
		   'addapplytosettingform button#cancelBtn':{
			   click: function(obj, record) {
				   var $this=this;
				   var formWindow = $this.getAddapplytosettingfilter();
				   formWindow.close();
			   }
		   },
		   
		   'addapplytosettingform multiselectcombofield[itemId=multiselectAcademyLocationId]' : {
			   render:function(obj,rec){
				   var store = obj.getStore();
				   /*store.load({
					   callback: function(records, operation, success) {
						   if (success) {
							   var allAl =[];
							   for(var i in records){
								   allAl.push(records[i].get("id"));
							   }
							   obj.setValue(allAl);
						   }
					   }
				   });*/
			   }
		   },
		   'addapplytosettingform multiselectcombofield[itemId=userGrpEmpAttributeValueItemId]' : {
			   render:function(obj,rec){
				   var store = obj.getStore();
				   store.load({
					   callback: function(records, operation, success) {
						   if (success) {
							   var allAl =[];
							   for(var i in records){
								   allAl.push(records[i].get("value"));
							   }
							   obj.setValue(allAl);
						   }
					   }
				   });
			   }
		   },
		   
		   'addapplytosettingform customcombobox[itemId=EligibilityEnumItemId]' : {
			   select:function(obj, rec){
				   var $this = this;
				   var form = $this.getAddapplytosettingform().getForm();
				   var multiLeaveType = form.findField("HRLeaveType");
				   var leaveType = form.findField("LeaveType");
				   var empAttributeType =  form.findField("empAttributeType");
				   var empAttributeValue =  form.findField("empAttributeValue");
				   var enumEmpAttributeValue =  form.findField("enumEmpAttributeValue");
				   var userGrpEmpAttributeValue = form.findField('userGrpEmpAttributeValue');
				   var store = $this.getStore('leavemanagement.LeaveTypeStore');
				   store.getProxy().extraParams={
					   eligibilityCriteria:rec[0].data.id,
				   };
				   store.load();
				   if(rec[0].data.id != "EMPLOYEEATTRIBUTEBASED"){
					   multiLeaveType.setVisible(true);
					   leaveType.setVisible(false);
					   empAttributeType.setVisible(false);
					   multiLeaveType.allowBlank=false;
					   leaveType.allowBlank=true;
					   empAttributeType.allowBlank=true;
					   empAttributeValue.allowBlank=true;
					   enumEmpAttributeValue.allowBlank=true;
					   userGrpEmpAttributeValue.allowBlank=true;
					   userGrpEmpAttributeValue.setVisible(false);
				   } else {
					   multiLeaveType.setVisible(false);;
					   multiLeaveType.allowBlank=true;
					   leaveType.setVisible(true);
					   empAttributeType.setVisible(true);
					   leaveType.allowBlank=false;
					   empAttributeType.allowBlank=false;
					   empAttributeValue.allowBlank=false;
					   enumEmpAttributeValue.allowBlank=false;
					   userGrpEmpAttributeValue.allowBlank=false;
				   }
				   empAttributeType.reset();
				   leaveType.reset();
				   multiLeaveType.reset();
				   form.isValid();
				   empAttributeValue.setVisible(false);;
				   enumEmpAttributeValue.setVisible(false);;
				   empAttributeValue.reset();
				   enumEmpAttributeValue.reset();
			   }
		   },
		   
		   'addapplytosettingform customcombobox[itemId=empAttributeTypeItemId]' : {
			   select:function(obj, rec){
				   var $this = this;
				   var form = $this.getAddapplytosettingform().getForm();
				   var empAttributeValue = form.findField("empAttributeValue");
				   var enumEmpAttributeValue = form.findField("enumEmpAttributeValue");
				   var userGrpEmpAttributeValue = form.findField("userGrpEmpAttributeValue");
				   if(rec[0].data.type=="ENUM"){
					   empAttributeValue.reset();
					   empAttributeValue.setVisible(false);;
					   empAttributeValue.allowBlank=true;
					   enumEmpAttributeValue.setVisible(true);
					   enumEmpAttributeValue.reset();
					   enumEmpAttributeValue.allowBlank=false;
					   userGrpEmpAttributeValue.reset();
					   userGrpEmpAttributeValue.setVisible(false);
					   userGrpEmpAttributeValue.allowBlank=true;
					   if(rec[0].data.value=="GENDER"){
						   enumEmpAttributeValue.getStore().getProxy().api.read=SERVERURL.ENQUIRY_GENDER;
						   enumEmpAttributeValue.getStore().load();
					   }
				   } else {
					   if(rec[0].data.value=="department"){
						   empAttributeValue.getStore().getProxy().api.read=SERVERURL.DEPARTMENT_GRIDDATA;
						   empAttributeValue.getStore().load();
						  
						   empAttributeValue.setVisible(true);
						   empAttributeValue.reset();
						   empAttributeValue.allowBlank=false;
						   enumEmpAttributeValue.reset();
						   enumEmpAttributeValue.setVisible(false);
						   enumEmpAttributeValue.allowBlank=true;
						   userGrpEmpAttributeValue.reset();
						   userGrpEmpAttributeValue.setVisible(false);
						   userGrpEmpAttributeValue.allowBlank=true;
					   }
					   else if(rec[0].data.value=="User Group Type"){
						   userGrpEmpAttributeValue.getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_USER_GROUP_TYPE_VALUE;
						   userGrpEmpAttributeValue.reset();
						   userGrpEmpAttributeValue.getStore().load();
						   userGrpEmpAttributeValue.setVisible(true);
						   userGrpEmpAttributeValue.allowBlank=false;
						   empAttributeValue.setVisible(false);
						   empAttributeValue.reset();
						   empAttributeValue.allowBlank=true;
						   enumEmpAttributeValue.reset();
						   enumEmpAttributeValue.setVisible(false);
						   enumEmpAttributeValue.allowBlank=true;
						   
					   }
					   
				   }
				   
			   }
		   },

		   
		   'leavesettingsgrid button#btnApplyToItemId':{
			   click: function(obj, record) {
				   var $this = this;
				   var grid = $this.getLeavesettingsgrid();
				   if (grid.getSelectionModel().getCount() > 0) {
					   $this.openApplyToTab();
				   } else {
					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				   }
			   }
		   },
		   
		   'eligilibitysettingform button[itemId=quickSearchId]':{
			   click : function(obj){
				   var $this = this;
				   var form = $this.getEligilibitysettingform().getForm();
				   var grid = $this.getLeavesettingsgrid();
				   grid.getStore().getProxy().extraParams ={
					   eligibilityId:form.findField("EligibilityCodeType").getValue(),
				    availabilityType:form.findField("AvailabilityPeriod").getValue(),
				   };
				   $this.resetGridSetting(grid);
				   grid.getStore().load();
				   /*pdf & excel report header filter*/
			    	grid.config.searchFilterForm = $this.getEligilibitysettingform();
			   }
		   },
		   'eligilibitysettingform button[itemId=resetBtn]':{
			   click : function(obj){
				   var $this = this;
				   var form = $this.getEligilibitysettingform().getForm();
				   form.reset();
			   }
		   },
		   
		   'eligibilitymappedalwindow grid[itemId=attributeGrid] button[itemId=btnDelete]':{
			   click : function(obj){
				  this.deleteEligibilityLeaveAttributeValues();
			   }
		   },
		   
		   'addeligibilitysetting':{
  			   render : function(){
  					var $this = this;
  			    	var form = $this.getAddeligibilitysetting().getForm();
  			    	var periodType = form.findField('creditPeriodType');
  			    	var daysToCredit =form.findField('leaveDaysToCredit');
  			    	var advanceCredit = form.findField('allowAdvanceCredit');
  			    	var monthPeriodStart = form.findField('monthPeriodStart');
  			    	monthPeriodStart.setDisabled(true);
  			    	monthPeriodStart.allowBlank=true;
  			    	periodType.allowBlank=true;
  			    	daysToCredit.allowBlank=true;
  			    	advanceCredit.allowBlank=true;
  			    	form.findField('servicePeriodType').allowBlank=true;
  		    		form.findField('minimumServiceTerm').allowBlank=true;
  		    		form.findField('servicePeriodType').setDisabled(true);
  		    		form.findField('minimumServiceTerm').setDisabled(true);
  			   }
  		   },
  		   
  		 'addeligibilitysetting customcombobox[itemId=AvailabilityPeriodItemId]':{
			   select : function(obj, record){
				    var $this = this;
			    	var form = $this.getAddeligibilitysetting().getForm();
			    	var monthPeriodStart = form.findField('monthPeriodStart');
			    	var periodStartFrom = form.findField('periodStartFrom');
			    	
			    	var leaveDaysToCredit = form.findField('leaveDaysToCredit');
			    	var creditPeriodType = form.findField('creditPeriodType');
			    	var allowAdvanceCredit = form.findField('allowAdvanceCredit');
			    	
			    	var data = record[0].data.id;
			    	var diffrentCreditPeriodId = $this.getAddeligibilitysetting().down('#diffrentCreditPeriodId');
			    	if(data=="YEAR"){
			    		monthPeriodStart.setDisabled(true);
	  			    	monthPeriodStart.reset();
	  			    	monthPeriodStart.allowBlank=true;
	  			    	periodStartFrom.setDisabled(false);
	  			    	periodStartFrom.reset();
	  			    	periodStartFrom.allowBlank=false;
	  			    	diffrentCreditPeriodId.setDisabled(false);
	  			    	/*leaveDaysToCredit.setDisabled(false);
			    		leaveDaysToCredit.reset();
			    		leaveDaysToCredit.setDisabled(true);
			    		leaveDaysToCredit.allowBlank=false;*/
			    		creditPeriodType.reset();
			    		creditPeriodType.allowBlank=false;
			    		allowAdvanceCredit.reset();
	  			    	
			    	} else {
			    		leaveDaysToCredit.setDisabled(true);
			    		leaveDaysToCredit.reset();
			    		leaveDaysToCredit.allowBlank=true;
			    		creditPeriodType.setDisabled(true);
			    		creditPeriodType.reset();
			    		creditPeriodType.allowBlank=true;
			    		allowAdvanceCredit.setDisabled(true);
			    		allowAdvanceCredit.reset();
			    		
			    		monthPeriodStart.setDisabled(false);
	  			    	monthPeriodStart.reset();
	  			    	monthPeriodStart.allowBlank=false;
	  			    	periodStartFrom.setDisabled(true);
	  			    	periodStartFrom.reset();
	  			    	periodStartFrom.allowBlank=true;
	  			    	diffrentCreditPeriodId.setDisabled(true);
			    	}
			    	form.isValid();
			   }
		   },
  		 
  		 'addeligibilitysetting customcombobox[itemId=servicePeriodTypeItemId]':{
			   select : function(obj, record){
				    var $this = this;
 			    	var form = $this.getAddeligibilitysetting().getForm();
 			    	form.isValid();
			   }
		   },

		   'addeligibilitysetting button[itemId=saveBtn]':{
			   click : function(obj){
				   var $this = this;
				   $this.saveEligibilityFunctionality();
			   }
		   },
		   
		   'addeligibilitysetting button[itemId=resetBtn]':{
			   click : function(obj){
				   var $this = this;
				   $this.getAddeligibilitysetting().getForm().reset();
			   }
		   },

		   
		   'addeligibilitysetting radiogroup[itemId=basedOnServicePeriod]':{
  			   change : function(value,newValue,oldValue){
  				   this.showHideServiceBasedOn(value,newValue,oldValue);
  			   }
  		   },

  		 
  		  'addeligibilitysetting numberfield[itemId=availableLeaveItemId]':{
			   change : function(obj, record){
				    var $this = this;
			    	var form = $this.getAddeligibilitysetting().getForm();
			    	var leaveDaysToCredit = form.findField('leaveDaysToCredit');
			    	var AvailabilityPeriod = form.findField('AvailabilityPeriod');
			    	var availableLeaveDays = form.findField('availableLeaveDays');
			    	if(AvailabilityPeriod.getValue()=='YEAR'){
			    		leaveDaysToCredit.setMaxValue(availableLeaveDays.getValue()/12);
			    		leaveDaysToCredit.reset();
			    	}
			   }
		   },
  		 
		   'addeligibilitysetting numberfield[itemId=minimumServiceTermId]':{
			   change : function(obj, record){
				    var $this = this;
 			    	var form = $this.getAddeligibilitysetting().getForm();
 			    	form.isValid();
			   }
		   },
  		 
		   'addeligibilitysetting radiogroup[itemId=diffrentCreditPeriodId]':{
  			   change : function(value,newValue,oldValue){
  				   this.showHideDiffrentCreditScenerio(value,newValue,oldValue);
  			   }
  		   },
		   
        });
    },
    showHideServiceBasedOn:function(value,newValue,oldValue){
    	var $this = this;
    	var $this = this;
    	var form = $this.getAddeligibilitysetting().getForm();
    	if(newValue.isBasedOnServicePeriod==true){
    		form.findField('servicePeriodType').setDisabled(false);
    		form.findField('minimumServiceTerm').setDisabled(false);
    		form.findField('servicePeriodType').allowBlank=false;
    		form.findField('minimumServiceTerm').allowBlank=false;
    	} else {
    		form.findField('servicePeriodType').allowBlank=true;
    		form.findField('minimumServiceTerm').allowBlank=true;
    		form.findField('servicePeriodType').setDisabled(true);
    		form.findField('minimumServiceTerm').setDisabled(true);
    	}
    	form.findField('servicePeriodType').reset();
		form.findField('minimumServiceTerm').reset();
		form.isValid();
    },
    
    openApplyToTab:function(){
    	var $this = this;
		var contentPanel = $this.getLeavesettingstructure();
			var newTab = contentPanel.items.findBy(function(tab) {
				return tab.title === getCommonTranslation('ELIGIBILITY_SETTING_APPLY_TO_LIST');
			});
			if (!newTab) {
				contentPanel.add({
					title: getCommonTranslation('ELIGIBILITY_SETTING_APPLY_TO_LIST'),
					closable : true,
					autoScroll:true,
					xtype : 'applytosettingfilter',
				}).show();
			}
			contentPanel.setActiveTab(newTab);
			contentPanel.doLayout();
	    
			var grid = $this.getSettingsapplytogrid();
			var leaveSettingsgrid = $this.getLeavesettingsgrid();
	    	var record = leaveSettingsgrid.getSelectionModel().getSelection()[0];
			grid.getStore().getProxy().extraParams={
				eligibilitySettingId:record.data.id
			};
			grid.getStore().load();
    },
    openEligibilitySettingDetailsWindow:function(title, record, ColIdx){
			var $this = this;
			var formWindow = this.getEligibilitymappedalwindow();
     	    if (!formWindow) {
     		   Ext.widget('eligibilitymappedalwindow');
     		   formWindow = this.getEligibilitymappedalwindow();
     	    }
    	    formWindow.show();
    	    var gridAl = formWindow.down('#alGridItemId');
    	    var gridAttr = formWindow.down('#attributeGrid');
    	    gridAttr.hide();
    	    gridAl.hide();
    	    if(ColIdx==3){
    	    	gridAttr.show();
    	    	formWindow.setTitle(getCommonTranslation('ATTRIBUTE_VALUE'));
				var gridStore =  gridAttr.getStore();
				gridStore.removeAll();
				var details;
				if(record.data.employeeAttributeValues.length != 0){
					for(var i in record.data.employeeAttributeValues){
						if(!isNullOrEmpty(record.data.employeeAttributeLongValues)){
							if(record.data.employeeAttributeType == "User Group Type"){
								details={
										'id':record.data.employeeAttributeLongValues[i],
										'value':getCommonTranslation(record.data.employeeAttributeValues[i])
								};
							}
							else{
								details={
										'id':record.data.employeeAttributeLongValues[i],
										'value':record.data.employeeAttributeValues[i]
								};
							}
							
						} else {
							details={
									'value':getCommonTranslation(record.data.employeeAttributeValues[i])
							};
						}
						gridStore.loadRawData(details, true);
					}
				}
    	    } else{
    	    	gridAl.show();
    	    	formWindow.setTitle(getCommonTranslation('ACADEMY_LOCATION'));
				var gridStore =  gridAl.getStore();
				gridStore.removeAll();
				var details;
				if(record.data.academyLocationIdName.length != 0){
					for(var i in record.data.academyLocationIdName){
						details={
								'value':record.data.academyLocationIdName[i],
						};
						gridStore.loadRawData(details, true);
					}
				}
    	    }
    },
    
    showHideDiffrentCreditScenerio:function(value,newValue,oldValue){
    	var $this = this;
    	var form = $this.getAddeligibilitysetting().getForm();
    	
    	var periodType = form.findField('creditPeriodType');
    	var daysToCredit =form.findField('leaveDaysToCredit');
    	var advanceCredit = form.findField('allowAdvanceCredit');
    	
    	if(newValue.isDiffrentCreditPeriodId==true){
    		periodType.setDisabled(false);
    		daysToCredit.setDisabled(false);
    		advanceCredit.setDisabled(false);
    		periodType.allowBlank=false;
    		daysToCredit.allowBlank=false;
    		advanceCredit.allowBlank=false;
    		daysToCredit.setMaxValue(form.findField('availableLeaveDays').getValue()/12);
    		periodType.getStore().load({
    			callback:function(record){
    				periodType.setValue(record[0].data.id);
    				periodType.setReadOnly(true);
    			}
    		});
    	} else {
    		periodType.setDisabled(true);
    		daysToCredit.setDisabled(true);
    		advanceCredit.setDisabled(true);
    		
    		periodType.allowBlank=true;
    		daysToCredit.allowBlank=true;
    		advanceCredit.allowBlank=true;
    		
    		periodType.reset();
    		daysToCredit.reset();
    		advanceCredit.reset();
    	}    
    	form.isValid();
    },
    
    saveEligibilityFunctionality:function(){
    	var $this = this;
    	var contentpanel = this.getContentPanel();
    	var filter = $this.getAddeligibilitysetting();
    	var form = filter.getForm();
    	var fromValue = form.getValues();
    	var grid = $this.getLeavesettingsgrid();
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	var isView = '';
    	var tabName = '';
    	var id=null;
    	/*if(filter.down("#saveBtn").getText()=="Save" && (isNullOrEmpty(action) || action != 'ADD')){
    		if(grid.getSelectionModel().getSelection().length > 0){
    			var record = grid.getSelectionModel().getSelection()[0];
    			id=record.data.id;
    		}
    	}*/
    	if(! isNullOrEmpty(fromValue.id)) {
    		id=fromValue.id;
    	}
    	if(fromValue.isDiffrentCreditPeriodId){
    		if(fromValue.isBasedOnServicePeriod){
    			if(fromValue.AvailabilityPeriod=="YEAR"){
    				var submitValue={
                			'id':id,
                			'eligibilityCode':fromValue.elegilibityCode,
                			'availabilityPeriodType':fromValue.AvailabilityPeriod,
                			'availableLeaveDays':fromValue.availableLeaveDays,
                			'months':fromValue.periodStartFrom,
                			'isDifferentCreditPeriod':fromValue.isDiffrentCreditPeriodId,
                			'creditPeriodType':fromValue.creditPeriodType,
                			'leaveDaysToCredit':fromValue.leaveDaysToCredit,
                			'isAllowAdvanceCredit':fromValue.isAllowAdvanceCredit,
                			'isBasedOnJoiningDate':fromValue.isBasedOnJoiningDate,
                			'isEligibleForCompOff':fromValue.isEligibleOfCompOff,
                			'isBasedOnServicePeriod':fromValue.isBasedOnServicePeriod,
                			'servicePeriodType':fromValue.servicePeriodType,
                			'minimumServiceTerm':fromValue.minimumServiceTerm
                	};
    			} else {
    				var submitValue={
                			'id':id,
                			'eligibilityCode':fromValue.elegilibityCode,
                			'availabilityPeriodType':fromValue.AvailabilityPeriod,
                			'availableLeaveDays':fromValue.availableLeaveDays,
                			'applicableDate':fromValue.monthPeriodStart,
                			'isDifferentCreditPeriod':fromValue.isDiffrentCreditPeriodId,
                			'creditPeriodType':fromValue.creditPeriodType,
                			'leaveDaysToCredit':fromValue.leaveDaysToCredit,
                			'isAllowAdvanceCredit':fromValue.isAllowAdvanceCredit,
                			'isBasedOnJoiningDate':fromValue.isBasedOnJoiningDate,
                			'isEligibleForCompOff':fromValue.isEligibleOfCompOff,
                			'isBasedOnServicePeriod':fromValue.isBasedOnServicePeriod,
                			'servicePeriodType':fromValue.servicePeriodType,
                			'minimumServiceTerm':fromValue.minimumServiceTerm
                	};
    			}
    			
    		} else {
    			if(fromValue.AvailabilityPeriod=="YEAR"){
    				var submitValue={
                			'id':id,
                			'eligibilityCode':fromValue.elegilibityCode,
                			'availabilityPeriodType':fromValue.AvailabilityPeriod,
                			'availableLeaveDays':fromValue.availableLeaveDays,
                			'months':fromValue.periodStartFrom,
                			'isDifferentCreditPeriod':fromValue.isDiffrentCreditPeriodId,
                			'creditPeriodType':fromValue.creditPeriodType,
                			'leaveDaysToCredit':fromValue.leaveDaysToCredit,
                			'isAllowAdvanceCredit':fromValue.isAllowAdvanceCredit,
                			'isBasedOnJoiningDate':fromValue.isBasedOnJoiningDate,
                			'isEligibleForCompOff':fromValue.isEligibleOfCompOff,
                			'isBasedOnServicePeriod':fromValue.isBasedOnServicePeriod
                	};
    			} else {
    				var submitValue={
                			'id':id,
                			'eligibilityCode':fromValue.elegilibityCode,
                			'availabilityPeriodType':fromValue.AvailabilityPeriod,
                			'availableLeaveDays':fromValue.availableLeaveDays,
                			'applicableDate':fromValue.monthPeriodStart,
                			'isDifferentCreditPeriod':fromValue.isDiffrentCreditPeriodId,
                			'creditPeriodType':fromValue.creditPeriodType,
                			'leaveDaysToCredit':fromValue.leaveDaysToCredit,
                			'isAllowAdvanceCredit':fromValue.isAllowAdvanceCredit,
                			'isBasedOnJoiningDate':fromValue.isBasedOnJoiningDate,
                			'isEligibleForCompOff':fromValue.isEligibleOfCompOff,
                			'isBasedOnServicePeriod':fromValue.isBasedOnServicePeriod
                	};
    			}
    		}
    		
    	} else {
    		if(fromValue.isBasedOnServicePeriod){
    			if(fromValue.AvailabilityPeriod=="YEAR"){
    				var submitValue={
            				'id':id,
                			'eligibilityCode':fromValue.elegilibityCode,
                			'availabilityPeriodType':fromValue.AvailabilityPeriod,
                			'availableLeaveDays':fromValue.availableLeaveDays,
                			'months':fromValue.periodStartFrom,
                			'isDifferentCreditPeriod':fromValue.isDiffrentCreditPeriodId,
                			'isBasedOnJoiningDate':fromValue.isBasedOnJoiningDate,
                			'isEligibleForCompOff':fromValue.isEligibleOfCompOff,
                			'isBasedOnServicePeriod':fromValue.isBasedOnServicePeriod,
                			'servicePeriodType':fromValue.servicePeriodType,
                			'minimumServiceTerm':fromValue.minimumServiceTerm
                	};
    			} else {
    				var submitValue={
            				'id':id,
                			'eligibilityCode':fromValue.elegilibityCode,
                			'availabilityPeriodType':fromValue.AvailabilityPeriod,
                			'availableLeaveDays':fromValue.availableLeaveDays,
                			'applicableDate':fromValue.monthPeriodStart,
                			'isDifferentCreditPeriod':fromValue.isDiffrentCreditPeriodId,
                			'isBasedOnJoiningDate':fromValue.isBasedOnJoiningDate,
                			'isEligibleForCompOff':fromValue.isEligibleOfCompOff,
                			'isBasedOnServicePeriod':fromValue.isBasedOnServicePeriod,
                			'servicePeriodType':fromValue.servicePeriodType,
                			'minimumServiceTerm':fromValue.minimumServiceTerm
                	};
    			}
    		} else {
    			if(fromValue.AvailabilityPeriod=="YEAR"){
    				var submitValue={
            				'id':id,
                			'eligibilityCode':fromValue.elegilibityCode,
                			'availabilityPeriodType':fromValue.AvailabilityPeriod,
                			'availableLeaveDays':fromValue.availableLeaveDays,
                			'months':fromValue.periodStartFrom,
                			'isDifferentCreditPeriod':fromValue.isDiffrentCreditPeriodId,
                			'isBasedOnJoiningDate':fromValue.isBasedOnJoiningDate,
                			'isEligibleForCompOff':fromValue.isEligibleOfCompOff,
                			'isBasedOnServicePeriod':fromValue.isBasedOnServicePeriod
                	};
    			} else {
    				var submitValue={
            				'id':id,
                			'eligibilityCode':fromValue.elegilibityCode,
                			'availabilityPeriodType':fromValue.AvailabilityPeriod,
                			'availableLeaveDays':fromValue.availableLeaveDays,
                			'applicableDate':fromValue.monthPeriodStart,
                			'isDifferentCreditPeriod':fromValue.isDiffrentCreditPeriodId,
                			'isBasedOnJoiningDate':fromValue.isBasedOnJoiningDate,
                			'isEligibleForCompOff':fromValue.isEligibleOfCompOff,
                			'isBasedOnServicePeriod':fromValue.isBasedOnServicePeriod
                	};
    			}
    		}
    	}
    	var submitUrl;
    	if(! isNullOrEmpty(id)){
    		submitUrl = SERVERURL.ELIGIBILITY_SETTING_UPDATE_URL;
    		isView = 'EDIT';
    		tabName = getCommonTranslation('EDIT_ELIGIBILITY_SETTINGS');
    	} else {
    		submitUrl = SERVERURL.ELIGIBILITY_SETTING_SAVE_URL;
    		isView = 'ADD';
    		tabName = getCommonTranslation('ADD_ELIGIBILITY_SETTINGS');
    	}
    	
    	Ext.Ajax.request({
    		method : "GET",
    		type : 'rest',
    		url : SERVERURL.PATH_ELIGIBILITY_CODE_EXISTS,
    		params:{
    			id:id,
    			code:fromValue.elegilibityCode
    		},
    		success : function(response, action) {
    			var resp = Ext.decode(response.responseText);
    			if(resp){
    				Ext.getBody().unmask();
    				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('LEAVE_CODE_EXISTS_MSG'));
    			}
    			else{
    				Ext.Ajax.request({
    					type : 'rest',
    					url : submitUrl,
    					jsonData : submitValue,
    					method : 'POST',
    					success : function(form, action) {
    						Ext.getBody().unmask();
    						showSuccessMessage(getCommonTranslation('ELIGIBILITY_SETTINGS'),getCommonTranslation('SUCCESS'));
    						if (!isNullOrEmpty(grid)) {
    							grid.getStore().reload();
    							grid.getSelectionModel().deselectAll();
    						}
    						var getcontroller=$this.getController('menu.CoreERPNavigationController');
    						var getTab=getcontroller.getTab(tabName);
    						if(getTab!=null){
    							contentpanel.remove(getTab, true);
    						}
    					}
    				});
    			}
    		}
    	});
    },
    
    openEditableEligibilitySettingTab:function(editMode){
    	   var $this = this;
		   var grid = $this.getLeavesettingsgrid();
		   if (grid.getSelectionModel().getCount() > 0) {
			   $this.openAddEligibilitySettingTab();
			   $this.eligibilityEditModeFunctionality(grid);
		   } else {
			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		   }
    },
    
    deleteEligibilitySettingFunction:function(){
    	var $this=this;
    	var grid = $this.getSettingsapplytogrid();
    	var record = grid.getSelectionModel().getSelection()[0];
    	var attributeName = !isNullOrEmpty(record.data.employeeAttributeType)?record.data.employeeAttributeType:'';
    	showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
    		function(btn, text) {
				if (btn == 'yes') {
					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					Ext.Ajax.request({
						method : "DELETE",
						type : 'rest',
						url : SERVERURL.PATH_DELETE_ELIGIBILITY_LEAVE_TYPE_APPLY_TO+ '?id='+ record.data.hrEligibilitySettingId+"&eligibilityCtiteria="+record.data.eligibilityCtiteria
						+"&attributeName="+attributeName+"&hrLeaveTypeId=" + record.data.hrLeaveTypeId,
						headers : {
							'Content-Type' : 'application/json'
						},
						params : {
							id : record.data.hrEligibilitySettingId,
							eligibilityCtiteria:record.data.eligibilityCtiteria,
							attributeName:record.data.employeeAttributeType
						},
						success : function(form,action) {
							Ext.getBody().unmask();
							showSuccessMessage(getCommonTranslation('ELIGIBILITY_SETTINGS'),getCommonTranslation('SUCCESS'));
							grid.getStore().reload();
						}
					});
				}
    	});
    },
    
    saveApplyToEligibility:function(){
    	var $this=this;
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	var contentpanel = this.getContentPanel();
    	var filter = $this.getAddapplytosettingform();
    	var form = filter.getForm();
    	var fromValue = form.getValues();
    	var grid = $this.getSettingsapplytogrid();
    	var leaveSettingsgrid = $this.getLeavesettingsgrid();
    	var record = leaveSettingsgrid.getSelectionModel().getSelection()[0];
    	var empAttributeType;
    	if(!isNullOrEmpty(form.findField("empAttributeType").valueModels) && form.findField("empAttributeType").valueModels.length!=0){
    		empAttributeType=form.findField("empAttributeType").valueModels[0].data.type;
    	}
    	
    	var submitValue =[], alIds=[];
    	var id;
    	var submitUrl;
    	if(filter.down('#saveBtn').getText()=='Save'){
    		if(grid.getSelectionModel().getSelection().length > 0) {
    			id = grid.getSelectionModel().getSelection()[0].data.id;
    		}
    	}
    	submitUrl = SERVERURL.PATH_UPDATE_ELIGIBILITY_LEAVE_TYPE_APPLY_TO;
    	for(var i in fromValue.multiselectAcademyLocation){
    		if(fromValue.multiselectAcademyLocation[i].data == undefined){
    			alIds.push(fromValue.multiselectAcademyLocation[i]);
    		} else {
    			alIds.push(fromValue.multiselectAcademyLocation[i].data.id);
    		}
    	}	
    	
    	if(fromValue.EligibilityEnum=="EMPLOYEEATTRIBUTEBASED"){
    		var enumEmpAttribute;
    		if(empAttributeType=='ENUM'){
    			for (var i in fromValue.enumEmpAttributeValue){
    				if(fromValue.enumEmpAttributeValue[i].data == undefined){
            			enumEmpAttribute=fromValue.enumEmpAttributeValue[i];
            		} else {
            			enumEmpAttribute=fromValue.enumEmpAttributeValue[i].data.id;
            		}
    				var data={
    						'id':id,
        	    			'hrEligibilitySettingId':record.data.id,
        	    			'eligibilityCtiteria':fromValue.EligibilityEnum,
        	    			'hrLeaveTypeId':fromValue.LeaveType,
        	    			'employeeAttributeType':empAttributeType,
        	    			'employeeAttributeValue':enumEmpAttribute,
        	    			'hrEmployeeAttributeMasterId':fromValue.empAttributeType,
        	    			'academyLocationIds':alIds
        	    	};
    				submitValue.push(data);
    			}
    		} else if(empAttributeType=='STR'){
    			if(fromValue.userGrpEmpAttributeValue!=undefined){
    				for (var i in fromValue.userGrpEmpAttributeValue){
    					var userGrpEmpAttributeValue;
    					if(fromValue.userGrpEmpAttributeValue[i].data == undefined){
    						userGrpEmpAttributeValue=fromValue.userGrpEmpAttributeValue[i];
    					} else {
    						userGrpEmpAttributeValue=fromValue.userGrpEmpAttributeValue[i].data.code
    					}
    					var data={
    							'id':id,
    							'hrEligibilitySettingId':record.data.id,
    							'eligibilityCtiteria':fromValue.EligibilityEnum,
    							'hrLeaveTypeId':fromValue.LeaveType,
    							'employeeAttributeType':empAttributeType,
    							'employeeAttributeValue':userGrpEmpAttributeValue,
    							'hrEmployeeAttributeMasterId':fromValue.empAttributeType,
    							'academyLocationIds':alIds
    					};
    					submitValue.push(data);
    				}
    			}
    		} else {
        		if(fromValue.empAttributeValue!=undefined){
        			for (var i in fromValue.empAttributeValue){
            			var empAttributeValue;
            			if(fromValue.empAttributeValue[i].data == undefined){
            				empAttributeValue=fromValue.empAttributeValue[i];
                		} else {
                			empAttributeValue=fromValue.empAttributeValue[i].data.id;
                		}
            			var data={
            					'id':id,
            	    			'hrEligibilitySettingId':record.data.id,
            	    			'eligibilityCtiteria':fromValue.EligibilityEnum,
            	    			'hrLeaveTypeId':fromValue.LeaveType,
            	    			'employeeAttributeType':empAttributeType,
            	    			'employeeAttributeValue':empAttributeValue,
            	    			'hrEmployeeAttributeMasterId':fromValue.empAttributeType,
            	    			'academyLocationIds':alIds
            	    	};
            			submitValue.push(data);
            		}
        		}
        		
        	}
    	} else {
    		for (var i in fromValue.HRLeaveType){
    			var leaveTp;
    			if(fromValue.HRLeaveType[i].data == undefined){
    				leaveTp=fromValue.HRLeaveType[i];
        		} else {
        			leaveTp=fromValue.HRLeaveType[i].data.id;
        		}
    			var data={
    					'id':id,
    					'hrEligibilitySettingId':record.data.id,
    	    			'eligibilityCtiteria':fromValue.EligibilityEnum,
    	    			'hrLeaveTypeId':leaveTp,
    	    			'academyLocationIds':alIds
    	    	};
    			submitValue.push(data);
    		}
    	}
    	 Ext.Ajax.request({
				type : 'rest',
				url : submitUrl,
				jsonData : submitValue,
				method : 'POST',
				success : function(form, action) {
					 Ext.getBody().unmask();
					 showSuccessMessage(getCommonTranslation('ELIGIBILITY_SETTINGS'),getCommonTranslation('SUCCESS'));
					 grid.getStore().reload();
					 grid.getSelectionModel().deselectAll();
					 var formWindow = $this.getAddapplytosettingfilter();
				 	    if (!formWindow) {
				 		   Ext.widget('addapplytosettingfilter');
				 		   formWindow = $this.getAddapplytosettingfilter();
				 	    }
				 	   formWindow.close();
				}
			});
    },
    
    
    openAddApplyToEligibility:function(view){
    	var $this = this;
    	var formWindow = $this.getAddapplytosettingfilter();
    	if (!formWindow) {
    		Ext.widget('addapplytosettingfilter');
    		formWindow = $this.getAddapplytosettingfilter();
    	}
    	formWindow.show();
    	if(view == 'ADD'){
    		var academyLocationFld = formWindow.down('#multiselectAcademyLocationId');
        	var store = academyLocationFld.getStore();
        	store.load({
        		callback: function(records, operation, success) {
        			if (success) {
        				var allAl =[];
        				for(var i in records){
        					allAl.push(records[i].get("id"));
        				}
        				academyLocationFld.setValue(allAl);
        			}
        		}
        	});
    	}
    },
    
    editApplyToEligibility:function(){
    	var $this = this;
    	var filter = $this.getAddapplytosettingform();
    	var form = filter.getForm();
    	var grid = $this.getSettingsapplytogrid();
    	var record = grid.getSelectionModel().getSelection()[0];
    	var multiselectAcademyLocation = form.findField('multiselectAcademyLocation');
    	var EligibilityEnum = form.findField('EligibilityEnum');
    	var HRLeaveType = form.findField('HRLeaveType');
    	var LeaveType = form.findField('LeaveType');
    	var empAttributeType = form.findField('empAttributeType');
    	var empAttributeValue = form.findField('empAttributeValue');
    	var enumEmpAttributeValue = form.findField('enumEmpAttributeValue');
    	var userGrpEmpAttributeValue = form.findField('userGrpEmpAttributeValue');
    	
    	multiselectAcademyLocation.getStore().load({
    		callback:function(rec){
    			var arr=[];
    			for(var i in rec){
    				for(var j in record.data.academyLocationIdName){
    					if(rec[i].data.value==record.data.academyLocationIdName[j]){
        					arr.push(rec[i].data.id);
        				}
    				}
    			}
    			multiselectAcademyLocation.setValue(arr);
    		}
    	});
    	EligibilityEnum.getStore().load({
			callback:function(rec){
				for(var i in rec){
					if(rec[i].data.id==record.data.eligibilityCtiteria){
						EligibilityEnum.setValue(rec[i].data.id);
					}
				}
			}
		});
    	if(record.data.eligibilityCtiteria == "EMPLOYEEATTRIBUTEBASED"){
    		HRLeaveType.setVisible(false);;
    		HRLeaveType.allowBlank=true;
    		LeaveType.setVisible(true);;
    		LeaveType.allowBlank=false;
    		LeaveType.getStore().getProxy().extraParams={
    			eligibilityCriteria:'EMPLOYEEATTRIBUTEBASED'
    		};
    		LeaveType.getStore().load({
    			callback:function(rec){
    				for(var i in rec){
    					if(rec[i].data.id==record.data.hrLeaveTypeId){
    						LeaveType.setValue(rec[i].data.id);
    					}
    				}
    			}
    		});
    		 empAttributeType.setVisible(true);;
			 empAttributeType.allowBlank=false;
			 empAttributeType.getStore().load({
				 callback:function(rec){
					 if(record.data.employeeAttributeType=='Gender'){
						 empAttributeType.setValue(rec[0].data.id); 
					 }else if(record.data.employeeAttributeType=='User Group Type') {
						 empAttributeType.setValue(rec[2].data.id); 
					 } else {
						 empAttributeType.setValue(rec[1].data.id); 
					 }
				 }
			 });
    		if(record.data.employeeAttributeType=='Gender'){
    			
    			  empAttributeValue.setVisible(false);
    			  empAttributeValue.allowBlank=true;
    			  userGrpEmpAttributeValue.setVisible(false);
    			  userGrpEmpAttributeValue.allowBlank=true;
    			  enumEmpAttributeValue.setVisible(true);;
    			  enumEmpAttributeValue.allowBlank=false;
    			  enumEmpAttributeValue.getStore().getProxy().api.read=SERVERURL.ENQUIRY_GENDER;
    			  enumEmpAttributeValue.getStore().load({
    				  callback:function(rec){
    					  var arr=[];
    					  for(var i in rec){
    						  for(var j in record.data.employeeAttributeValues){
    							  if(rec[i].data.id==record.data.employeeAttributeValues[j]){
    								  arr.push(rec[i].data.id);
    							  }
    						  }
    					  }
    					  enumEmpAttributeValue.setValue(arr);
    				  }
    			  });
    		} else if(record.data.employeeAttributeType=='User Group Type'){
    			enumEmpAttributeValue.setVisible(false);
    			enumEmpAttributeValue.allowBlank=true;
    			empAttributeValue.setVisible(false);
    			empAttributeValue.allowBlank=true;
    			userGrpEmpAttributeValue.setVisible(true);
   			    userGrpEmpAttributeValue.allowBlank=false;
   			    userGrpEmpAttributeValue.getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_USER_GROUP_TYPE_VALUE;
   			    userGrpEmpAttributeValue.getStore().load({
    				callback:function(rec){
    					var arr=[];
    					for(var i in rec){
    						for(var j in record.data.employeeAttributeValues){
    							if(rec[i].data.code==record.data.employeeAttributeValues[j]){
    								arr.push(rec[i].data.code);
    							}
    						}
    					}
    					userGrpEmpAttributeValue.setValue(arr);
    				}
    			});
    		}else {
    			enumEmpAttributeValue.setVisible(false);
    			enumEmpAttributeValue.allowBlank=true;
    			userGrpEmpAttributeValue.setVisible(false);
   			    userGrpEmpAttributeValue.allowBlank=true;
    			empAttributeValue.setVisible(true);;
    			empAttributeValue.allowBlank=false;
    			empAttributeValue.getStore().getProxy().api.read=SERVERURL.DEPARTMENT_GRIDDATA;
    			empAttributeValue.getStore().load({
    				callback:function(rec){
    					var arr=[];
    					for(var i in rec){
    						for(var j in record.data.employeeAttributeValues){
    							if(rec[i].data.name==record.data.employeeAttributeValues[j]){
        							arr.push(rec[i].data.id);
        						}
    						}
    					}
    					empAttributeValue.setValue(arr);
    				}
    			});
    		}
    	} 
    	else if(record.data.eligibilityCtiteria == "COMPENSATORY" || record.data.eligibilityCtiteria == "LOP"){
    		empAttributeValue.setVisible(false);
    		empAttributeValue.allowBlank=true;
    		enumEmpAttributeValue.setVisible(false);
    		enumEmpAttributeValue.allowBlank=true;
    		empAttributeType.setVisible(false);
    		empAttributeType.allowBlank=true;
    		userGrpEmpAttributeValue.setVisible(false);
    		userGrpEmpAttributeValue.allowBlank=true;
    		LeaveType.setVisible(false);
    		LeaveType.allowBlank=true;
    		HRLeaveType.setVisible(true);
    		HRLeaveType.allowBlank=false;
    		HRLeaveType.getStore().getProxy().extraParams={
    			eligibilityCriteria:record.data.eligibilityCtiteria
    		};
    		HRLeaveType.getStore().load({
    			callback:function(rec){
    				var arr=[];
    				for(var i in rec){
    					if(rec[i].data.id==record.data.hrLeaveTypeId){
    						arr.push(rec[i].data.id);
    					}
    				}
    				HRLeaveType.setValue(arr);
    			}
    		});
    	}
    	else {
    		empAttributeValue.setVisible(false);;
    		empAttributeValue.allowBlank=true;
    		enumEmpAttributeValue.setVisible(false);;
    		enumEmpAttributeValue.allowBlank=true;
    		empAttributeType.setVisible(false);;
    		empAttributeType.allowBlank=true;
    		userGrpEmpAttributeValue.setVisible(false);
			userGrpEmpAttributeValue.allowBlank=true;
    		LeaveType.setVisible(false);;
    		LeaveType.allowBlank=true;
    		HRLeaveType.setVisible(true);;
    		HRLeaveType.allowBlank=false;
    		HRLeaveType.getStore().getProxy().extraParams={
    			eligibilityCriteria:'GENERIC'
    		};
    		HRLeaveType.getStore().load({
    			callback:function(rec){
    				var arr=[];
    				for(var i in rec){
    					if(rec[i].data.id==record.data.hrLeaveTypeId){
    						arr.push(rec[i].data.id);
    					}
    				}
    				HRLeaveType.setValue(arr);
    			}
    		});
    	}
    	form.checkValidity();
    	filter.down('#saveBtn').setText('Save');
    },
    
    openAddEligibilitySettingTab:function(action){
    	   var contentpanel = this.getContentPanel();
		   var studentRoomStructure = Ext.widget('addeligibilitysetting');
		   var tabName ='';
		   if(action == 'ADD'){
			   var tabName = getCommonTranslation('ADD_ELIGIBILITY_SETTINGS');
		   }
		   else{
			   var tabName = getCommonTranslation('EDIT_ELIGIBILITY_SETTINGS');
			   studentRoomStructure.setTitle(tabName);
		   }
		   var grid = this.getLeavesettingsgrid();
		   grid.config.action = action;
		   /**
		    * This is to remove tab from content panel and open same tab again 
		    */
		   var getcontroller=this.getController('menu.CoreERPNavigationController');
		   var getTab=getcontroller.getTab(tabName);
		   if(getTab!=null){
			   contentpanel.remove(getTab, true);
		   }
		   openTab(contentpanel, tabName, studentRoomStructure,CONSTANTS.MENU_COLOR_EIGHT);
    },
    
    eligibilityEditModeFunctionality:function(grid){
    	var $this = this;
    	var filter = $this.getAddeligibilitysetting();
    	var form = filter.getForm();
    	var record = grid.getSelectionModel().getSelection()[0];
    	var id = form.findField("id");
    	var elegilibityCode = form.findField("elegilibityCode");
    	var AvailabilityPeriod = form.findField("AvailabilityPeriod");
    	var availableLeaveDays = form.findField("availableLeaveDays");
    	var periodStartFrom = form.findField("periodStartFrom");
    	var creditPeriodType = form.findField("creditPeriodType");
    	var leaveDaysToCredit = form.findField("leaveDaysToCredit");
    	var servicePeriodType = form.findField("servicePeriodType");
    	var minimumServiceTerm = form.findField("minimumServiceTerm");
    	var monthPeriodStart = form.findField('monthPeriodStart');
    	minimumServiceTerm.setDisabled(true);
    	id.setValue(record.data.id);
    	elegilibityCode.setValue(record.data.eligibilityCode);
    	AvailabilityPeriod.getStore().load({
    		callback:function(rec){
    			for(var i in rec){
    				if(rec[i].data.id==record.data.availabilityPeriodType){
    					AvailabilityPeriod.setValue(rec[i].data.id);
    					break;
    				}
    			}
    		}
    	});
    	availableLeaveDays.setValue(record.data.availableLeaveDays);
    	
    	if(record.data.availabilityPeriodType=="YEAR"){
    		periodStartFrom.setDisabled(false);
    		periodStartFrom.allowBlank=false;
    		periodStartFrom.reset();
    		monthPeriodStart.setDisabled(true);
    		monthPeriodStart.allowBlank=true;
    		monthPeriodStart.reset();
    		periodStartFrom.getStore().load({
        		callback:function(rec){
        			for (var i in rec){
        				if(rec[i].data.id == record.data.months){
        					periodStartFrom.setValue(rec[i].data.id);
        					break;
        				}
        			}
        		}
        	});
    	} else {
    		periodStartFrom.setDisabled(true);
    		periodStartFrom.allowBlank=true;
    		periodStartFrom.reset();
    		monthPeriodStart.setDisabled(false);
    		monthPeriodStart.allowBlank=false;
    		monthPeriodStart.reset();
    		monthPeriodStart.setValue(dateRender(record.data.applicableDate));
    	}
    
    	if(record.data.isDifferentCreditPeriod){
    		var diffrentCreditPeriodId = filter.down("#diffrentCreditPeriodId");
    		diffrentCreditPeriodId.items.items[0].setValue(true);
    		diffrentCreditPeriodId.items.items[1].setValue(false);
    		creditPeriodType.setDisabled(false);
    		creditPeriodType.getStore().load({
        		callback:function(rec){
        			for(var i in rec){
        				if(rec[i].data.id==record.data.creditPeriodType){
        					creditPeriodType.setValue(rec[i].data.id);
        					break;
        				}
        			}
        		}
        	});
    		leaveDaysToCredit.setDisabled(false);
    		leaveDaysToCredit.setValue(record.data.leaveDaysToCredit);
        	var allowAdvanceCreditId = filter.down("#allowAdvanceCreditId");
        	allowAdvanceCreditId.setDisabled(false);
        	if(record.data.isAllowAdvanceCredit){
        		allowAdvanceCreditId.items.items[0].setValue(true);
            	allowAdvanceCreditId.items.items[1].setValue(false);
        	}
    	}
    	servicePeriodType.setDisabled(true);
    	servicePeriodType.getStore().load({
    		callback:function(rec){
    			for (var i in rec){
    				if(rec[i].data.id==record.data.servicePeriodType){
    					servicePeriodType.setValue(rec[i].data.id);
    					break;
    				}
    			}
    		}
    	});
    	if(record.data.isBasedOnJoiningDate){
    		var basedOnJoiningDate = filter.down("#basedOnJoiningDate");
    		basedOnJoiningDate.items.items[0].setValue(true);
    		basedOnJoiningDate.items.items[1].setValue(false);
    	}
    	
    	if(record.data.isBasedOnServicePeriod){
    		servicePeriodType.setDisabled(false);
        	servicePeriodType.getStore().load({
        		callback:function(rec){
        			for (var i in rec){
        				if(rec[i].data.id==record.data.servicePeriodType){
        					servicePeriodType.setValue(rec[i].data.id);
        					break;
        				}
        			}
        		}
        	});
    		var basedOnServicePeriod = filter.down("#basedOnServicePeriod");
    		basedOnServicePeriod.items.items[0].setValue(true);
    		basedOnServicePeriod.items.items[1].setValue(false);
    		minimumServiceTerm.setDisabled(false);
    		minimumServiceTerm.setValue(record.data.minimumServiceTerm);
    	}
    	
    	if(record.data.isEligibleForCompOff){
    		var eligibleOfCompOff = filter.down("#eligibleOfCompOff");
    		eligibleOfCompOff.items.items[0].setValue(true);
    		eligibleOfCompOff.items.items[1].setValue(false);
    	}
    	var saveBtn = filter.down("#saveBtn");
    	saveBtn.setText(getExaminationTranslation('Save'));
    },
    
    deleteEligibilityLeaveAttributeValues:function(){
    	var $this=this;
    	var winGrid = $this.getEligibilitymappedalwindow().down('#attributeGrid');
    	if (winGrid.getSelectionModel().getCount() > 0) {
    		if(winGrid.store.data.items.length==1){
    			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ATTRIBUTE_REQUIRED'));
    			return;
    		}
    		var records = winGrid.getSelectionModel().getSelection()[0];
    		var grid = $this.getSettingsapplytogrid();
    		var record = grid.getSelectionModel().getSelection()[0];
    		var attributeValue = record.data.hrEmployeeAttributeMasterId==1?records.data.value:records.data.id;
    		showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
    				function(btn, text) {
    			if (btn == 'yes') {
    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    				Ext.Ajax.request({
    					method : "DELETE",
    					type : 'rest',
    					url : SERVERURL.PATH_DELETE_ELIGIBILITY_LEAVE_TYPE_ATTRIBUTE+ "?eligibilityCtiteria="+record.data.eligibilityCtiteria
    					+"&hrEmployeeAttributeMasterId="+record.data.hrEmployeeAttributeMasterId+"&hrLeaveTypeId=" + record.data.hrLeaveTypeId
    					+"&attributeValue=" +attributeValue,
    					headers : {
    						'Content-Type' : 'application/json'
    					},
    					params : {
    						id : record.data.hrEligibilitySettingId,
    						eligibilityCtiteria:record.data.eligibilityCtiteria,
    						attributeName:record.data.employeeAttributeType
    					},
    					success : function(form,action) {
    						Ext.getBody().unmask();
    						showSuccessMessage(getCommonTranslation('ELIGIBILITY_SETTINGS'),getCommonTranslation('SUCCESS'));
    						grid.getStore().reload();
    						grid.getSelectionModel().deselectAll();
    						$this.getEligibilitymappedalwindow().close();
    					}
    				});
    			}
    		});
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    }
});
