/**
 * @author Deepak S
 */
Ext.define('Academia.controller.leavemanagement.leavecreditsetting.LeaveCreditSettingController', {
    extend: 'Academia.controller.base.BaseController',
    stores: ['leavemanagement.LeaveTypeStore','leavemanagement.leavecreditsetting.LeaveCreditSettingGridStore',
    		'leavemanagement.leavecreditsetting.LeaveCreditTypeEnumStore', 'leavemanagement.leavecreditsetting.LeaveCreditPeriodEnumStore',
    		'leavemanagement.leavecreditsetting.EmployeeAttributeTypeEnumStore',
    		'department.DepartmentStore','leavemanagement.EnumEmployeeAttributeStore','leavemanagement.EmpLeaveUserGroupAttributeValue',
    		'feeandpayment.SkipMonths','leavemanagement.leavecreditsetting.LeaveYearStore',
    		'leavemanagement.leavecreditsetting.LeaveCreditSettingCodeFilterStore','common.GenderTypeStore',
    		'facilitiesresources.resourcebooking.AcademyLocationListByUserStore','department.DepartmentAcademyLocationWiseStore',
    		'personinfo.common.pasthistory.WorkExperienceDesignationStore','leavemanagement.leavecreditsetting.LeaveSetupIfEmpTypeChangedStore'],
    views: ['leavemanagement.leavecreditsetting.LeaveCreditSettingStructure',
    		'leavemanagement.leavecreditsetting.LeaveCreditSettingFilter',
    		'leavemanagement.leavecreditsetting.LeaveCreditSettingFilterForm',
    		'leavemanagement.leavecreditsetting.LeaveCreditSettingGrid',
    		'leavemanagement.leavecreditsetting.LeaveCreditSettingFormLayout'
    	   ],
    refs: [{
        ref: 'contentPanel',
        selector: 'contentPanel'
    }, {
        ref: 'leavecreditsettingstructure',
        selector: 'leavecreditsettingstructure'
    }, {
        ref: 'leavecreditsettingfilter',
        selector: 'leavecreditsettingfilter'
    }, {
        ref: 'leavecreditsettingfilterform',
        selector: 'leavecreditsettingfilterform'
    }, {
        ref: 'leavecreditsettinggrid',
        selector: 'leavecreditsettinggrid'
    }, {
        ref: 'leavecreditsettingformlayout',
        selector: 'leavecreditsettingformlayout'
    }],
    config: {
    	EMPLOYEE_LEAVE_CREDIT_SETTINGS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EMPLOYEE_LEAVE_CREDIT_SETTINGS_PRIVILEGES'),
    },
    init: function(application) {
        this.control({
        	'leavecreditsettinggrid':{
        		render: function(grid){
        			var $this = this;
        			this.doAccessControlValidation(grid, this.getEMPLOYEE_LEAVE_CREDIT_SETTINGS_PERMISSIONS());
        		}
        	},
        	'leavecreditsettinggrid button[itemId=btnAdd]':{
        		click: this.addLeaveCreditSettingForm
    		},
    		'leavecreditsettinggrid button[itemId=btnView]':{
        		click: this.viewLeaveCreditSettingForm
    		},
    		'leavecreditsettingformlayout multiselectcombofield[itemId=academyLocationId]':{
    			change : function(obj, record) {
    				var $this = this;
    				var leavecreditsettingformlayout = $this.getLeavecreditsettingformlayout();
    				var employeeAttributeType = leavecreditsettingformlayout.down('#employeeAttributeTypeId').getValue();
    				if(!isNullOrEmpty(employeeAttributeType) && employeeAttributeType == 'DEPARTMENT') {
    					var alIds = leavecreditsettingformlayout.down("#academyLocationId").getValue();
    		    		if(!isNullOrEmpty(alIds)) {
    		    			var academyLocationIds = alIds.join();
    		    			var store = leavecreditsettingformlayout.down('#empAttributeValueItemId').getStore();
    		    			store.getProxy().extraParams = {
    		    				academyLocationsIds : academyLocationIds
    		    			};
    		    			store.load();
    		    		}
    				}
    			}
    		},
    		'leavecreditsettingformlayout customcombobox[itemId=creditTypeId]':{
    			select : function(obj, record) {
    				var $this = this;
    				$this.enableDisableLeaveCreditFormFields(obj, record);
    			}
    		},
    		'leavecreditsettingformlayout radiogroup[itemId=leaveLapseId]':{
    			change : function(obj, newValue, oldValue, eOpts) {
    				this.changeLeaveLapseRadioVal(obj, newValue, oldValue, eOpts);
    			}
    		},
    		'leavecreditsettingformlayout radiogroup[itemId=leaveCarryForwardId]':{
    			change : function(obj, newValue, oldValue, eOpts) {
    				this.changeLeaveCarryForwardRadioVal(obj, newValue, oldValue, eOpts);
    			}
    		},
    		'leavecreditsettingformlayout radiogroup[itemId=leaveEncashmentId]':{
    			change : function(obj, newValue, oldValue, eOpts) {
    				this.changeLeaveEncashmentRadioVal(obj, newValue, oldValue, eOpts);
    			}
    		},
    		'leavecreditsettingformlayout customcombobox[itemId=leaveTypeId]' : {
    			select:function(obj, rec){
    				this.selectLeaveTypeEvent(obj, rec);
    			}
    		},
    		'leavecreditsettingformlayout customcombobox[itemId=yearId]' : {
    			select:function(obj, rec){
    				var $this = this;
    				var leavecreditsettingformlayout = $this.getLeavecreditsettingformlayout();
    				var monthId = leavecreditsettingformlayout.down('#monthId');
    				monthId.setDisabled(false);
    				$this.checkLeaveTypeExist();
    			}
    		},
    		'leavecreditsettingformlayout customcombobox[itemId=monthId]' : {
    			select:function(obj, rec){
    				var $this = this;
    				var leavecreditsettingformlayout = $this.getLeavecreditsettingformlayout();
    				$this.checkLeaveTypeExist();
    			}
    		},
    		'leavecreditsettingformlayout customcombobox[itemId=employeeAttributeTypeId]' : {
 			   change:function(obj, rec){
 				  this.selectEmployeeAttributeTypeEvent(obj, rec);
 			   }
 		   },
 		   'leavecreditsettingformlayout button[itemId=btnSaveLeaveCreditSettingForm]': {
 			   click: this.saveLeaveCreditSettingFormData
 		   },
 		  'leavecreditsettingformlayout button[itemId=btnResetLeaveCreditSettingForm]': {
			   click: this.resetLeaveCreditSettingFormData
		   },
		   'leavecreditsettingfilterform button[itemId=filterSearchId]': {
			   click: this.searchLeaveCreditSettingForm
		   },
		   'leavecreditsettingfilterform button[itemId=resetBtn]': {
			   click: this.resetLeaveCreditSearchFilterForm
		   },
		   'leavecreditsettingformlayout textfield#creditSettingCodeId': {
               blur: function(obj, record) {
                   var data = obj.getValue();
                   if (data) {
                       var form = this.getLeavecreditsettingformlayout();
                       var grid = this.getLeavecreditsettinggrid();
                       var idItemId = form.down("#idItemId");
                       var submitUrl = SERVERURL.PATH_HR_LEAVE_CREDIT_SETTING_UNIQUE_CODE + '?code=' + data;
                       
                       if (!isNullOrEmpty(idItemId.getValue())) {
                       	submitUrl = submitUrl +  '&id=' + idItemId.getValue();
                       }	
                       Ext.Ajax.request({
                           type: 'rest',
                           url: submitUrl,
                           method: 'GET',
                           success: function(response, action) {
                               if (response.responseText == 'EXIST') {
                               	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('CREDIT_SETTING_CODE_IS_NOT_UNIQUE'));
                                   form.down("#creditSettingCodeId").reset();
                               }
                           }
                       });
                   }
               }
           },
           'leavecreditsettingformlayout multiselectcombofield#userGrpEmpAttributeValueItemId': {
        	   change: function(obj, record) {
        		   var leavecreditsettingformlayout = obj.up().up();
        		   var leaveSetupEmpTypeChanged = leavecreditsettingformlayout.down('#leaveSetupEmpTypeChanged');
        		   this.enableLeaveSetupField();
        		   if(record.length>0){
        			   this.loadDataForLeaveSetupCombo();
        		   }else{
        			   leaveSetupEmpTypeChanged.setDisabled(true);
        			   leaveSetupEmpTypeChanged.reset();
        		   }
        	   }
           },
           'leavecreditsettingformlayout customcombobox': {
        	   change: function(obj, record) {
        		   var form = obj.up().up();
        		   form.isValid();
        	   }
           },
        });
    },
    searchLeaveCreditSettingForm: function(){
    	var $this=this;
    	var form = $this.getLeavecreditsettingfilterform().getForm();
    	var formValue = form.getValues();
    	var grid = $this.getLeavecreditsettinggrid();
    	var store = grid.getStore();
    	store.getProxy().extraParams={
    		hrLeaveCreditSettingId:formValue.creditSettingCode,
    		hrLeaveTypeId:formValue.HRLeaveType
    	}
    	grid.getSelectionModel().deselectAll();
    	store.load();
    	/*pdf & excel report header filter*/
    	grid.config.searchFilterForm = $this.getLeavecreditsettingfilterform();
    },
    addLeaveCreditSettingForm : function(isView){
    	var contentpanel = this.getContentPanel();
        var getcontroller=this.getController('menu.CoreERPNavigationController');
        var tabName = getCommonTranslation('ADD_LEAVE_CREDIT_SETTINGS');
        
        leaveCreditSettingFormLayout = Ext.widget('leavecreditsettingformlayout',{
        	title:getCommonTranslation('ADD_LEAVE_CREDIT_SETTINGS')
        });
        
        if (isView == 'VIEW') {
        	leaveCreditSettingFormLayout.setTitle(getCommonTranslation('VIEW_LEAVE_CREDIT_SETTINGS'));
            tabName = getCommonTranslation('VIEW_LEAVE_CREDIT_SETTINGS');
        }
        
        var getTab=getcontroller.getTab(getCommonTranslation('ADD_LEAVE_CREDIT_SETTINGS'));
        var getViewTab = getcontroller.getTab(getCommonTranslation('VIEW_LEAVE_CREDIT_SETTINGS'));
    	if(getTab!=null){
    		contentpanel.remove(getTab, true);
    	}
    	if(getViewTab!=null){
    		contentpanel.remove(getViewTab, true);
    	}
        openTab(contentpanel, tabName, leaveCreditSettingFormLayout, CONSTANTS.MENU_COLOR_EIGHT);   
    },
    viewLeaveCreditSettingForm : function(){
		var $this = this;
		var grid = $this.getLeavecreditsettinggrid();
		if(grid.getSelectionModel().getCount()>0) {
			$this.addLeaveCreditSettingForm('VIEW');
			var form = $this.getLeavecreditsettingformlayout();
			var formPnl = form.getForm();
			var record = grid.getSelectionModel().getSelection()[0];
			formPnl.setValues(record.data);
			formPnl.findField('isleaveLapseId').setValue(record.get('isLeaveLapse'));
			if(record.get('isLeaveLapse')){
				form.down('#leaveLapseId').setDisabled(false);
			}
			formPnl.findField('isleaveEncashmentId').setValue(record.get('isLeaveEncashment'));
			if(record.get('isLeaveEncashment')){
				form.down('#leaveEncashmentId').setDisabled(false);
			}
			formPnl.findField('isleaveCarryForwardId').setValue(record.get('isLeaveCarryForward'));
			if(record.get('isLeaveCarryForward')){
				form.down('#leaveCarryForwardId').setDisabled(false);
			}
			formPnl.findField('isproratedCreditId').setValue(record.get('isProratedCredit'));
			if(record.get('isProratedCredit')){
				form.down('#proratedCreditId').setDisabled(false);
			}
			var hrLeaveType = formPnl.findField('hrLeaveType');
			hrLeaveType.getStore().load({
				callback:function(){
					hrLeaveType.setValue(record.get('hrLeaveType').id);
					var year = formPnl.findField('year');
					year.setRawValue(record.get('year'));
					year.setDisabled(false);
				}
			});
			
			var monthStartsFrom = formPnl.findField('monthStartsFrom');
			monthStartsFrom.getStore().load({
				callback:function(){
					monthStartsFrom.setValue(record.get('monthStartsFrom'));
					monthStartsFrom.setDisabled(false);
				}
			});
			
			var hrLeaveCreditType = formPnl.findField('hrLeaveCreditType');
			hrLeaveCreditType.getStore().load({
				callback:function(){
					hrLeaveCreditType.setValue(record.get('hrLeaveCreditType'));
					if(!isNullOrEmpty(record.get('creditBalance')) && record.get('creditBalance')>0){
						formPnl.findField('creditBalance').setDisabled(false);	
					}
					if(!isNullOrEmpty(record.get('maxCreditBalance')) && record.get('maxCreditBalance')>0){
						formPnl.findField('maxCreditBalance').setDisabled(false);	
					}
				}
			});
			
			var leaveCreditPeriod = formPnl.findField('leaveCreditPeriod');
			leaveCreditPeriod.getStore().load({
				callback:function(){
					if(!isNullOrEmpty(record.get('leaveCreditPeriod'))){
						leaveCreditPeriod.setValue(record.get('leaveCreditPeriod'));
						leaveCreditPeriod.setDisabled(false);	
					}
				}
			});
			
			var leaveLapsePeriod = formPnl.findField('leaveLapsePeriod');
			leaveLapsePeriod.getStore().load({
				callback:function(){
					leaveLapsePeriod.setValue(record.get('leaveLapsePeriod'));
				}
			});
			
			var leaveEncashmentPeriod = formPnl.findField('leaveEncashmentPeriod');
			leaveEncashmentPeriod.getStore().load({
				callback:function(){
					leaveEncashmentPeriod.setValue(record.get('leaveEncashmentPeriod'));
				}
			});
			
			var academyLocationId = record.get('hrLeaveCreditSettingLocations');
			var hrLeaveCreditSettingLocations = formPnl.findField('hrLeaveCreditSettingLocations');
			var alIdValue;
			hrLeaveCreditSettingLocations.getStore().load({
				callback:function(){
					var alids=[];
					
					var academyLocationIds = null;
					if(academyLocationId.length>0){
						if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
							for (var i in academyLocationId) {
								if (Ext.isObject(academyLocationId[0])) {
									alids.push(academyLocationId[i].academyLocation.id);
								}
							}
							academyLocationIds = alids.join();
						}
						alIdValue= alids;
						hrLeaveCreditSettingLocations.setValue(alids);
					}
				}
			});
			
			var leaveCarryForwardPeriod = formPnl.findField('leaveCarryForwardPeriod');
			leaveCarryForwardPeriod.getStore().load({
				callback:function(){
					leaveCarryForwardPeriod.setValue(record.get('leaveCarryForwardPeriod'));
				}
			});
			var eligibilityBasedOnId = formPnl.findField('elgibilityBasedOn');
			eligibilityBasedOnId.setValue(getCommonTranslation(record.get('elgibilityBasedOn')));
			var employeeAttributeTypeId = formPnl.findField('hrEmployeeAttributeType');
			var leaveSetupEmpTypeChanged = formPnl.findField('leaveSetupEmpTypeChanged');
			var creditTypeId = form.down('#creditTypeId');

			eligibilityBasedOnId.config.eligibilityCriteria = record.get('elgibilityBasedOn');
			if(record.get('elgibilityBasedOn') == "EMPLOYEEATTRIBUTEBASED"){
				employeeAttributeTypeId.setVisible(true);
				employeeAttributeTypeId.setDisabled(false);
				employeeAttributeTypeId.reset();
				employeeAttributeTypeId.getStore().load({
					callback:function(){
						employeeAttributeTypeId.setValue(record.get('hrEmployeeAttributeType'));

						var enumEmpAttributeValue = formPnl.findField('enumEmpAttributeValue');
						var userGrpEmpAttributeValue = formPnl.findField('userGrpEmpAttributeValue');
						var deptEmpAttributeValue = formPnl.findField('empAttributeValue');
						var designationEmpAttributeValue = formPnl.findField('designationAttributeValue');
						if(record.get('hrEmployeeAttributeType') == "GENDER"){
							enumEmpAttributeValue.setVisible(true);
							enumEmpAttributeValue.getStore().load({
								callback:function(){
									var genderValueId = [];
									var gender = record.get('gender');
									if(!isNullOrEmpty(gender)){
										genderVal = gender.split(',');
										for(i in genderVal){
											genderValueId.push(parseInt(genderVal[i]));
										}
										enumEmpAttributeValue.setValue(genderValueId);
										$this.multiselectMouseOverEvent(enumEmpAttributeValue);
									}
								}
							});
						}
						else if(record.get('hrEmployeeAttributeType') =="USER_GROUP_TYPE"){
							userGrpEmpAttributeValue.setVisible(true);
							userGrpEmpAttributeValue.getStore().load({
								callback:function(){
									var userGroupType = record.get('userGroupType');
									if(!isNullOrEmpty(userGroupType)){
										userGroupTypeVal = userGroupType.split(',');
										userGrpEmpAttributeValue.setValue(userGroupTypeVal);
										$this.multiselectMouseOverEvent(userGrpEmpAttributeValue);
										if(creditTypeId.getValue() == "RECURRING" && employeeAttributeTypeId.getValue()=="USER_GROUP_TYPE"){
											leaveSetupEmpTypeChanged.setVisible(true);
											if(isNullOrEmpty(userGrpEmpAttributeValue.getDisplayValue())){
												leaveSetupEmpTypeChanged.setDisabled(true);
											}else{
					                             leaveSetupEmpTypeChanged.setDisabled(false);
				                             }
											leaveSetupEmpTypeChanged.getStore().load({
												callback:function(records, operation, success){
												   leaveSetupEmpTypeChanged.setValue(record.get('leaveSetupEmpTypeChanged'));
												}
											});
										}else{
											leaveSetupEmpTypeChanged.setVisible(false);
										}
									}
								}
							});
						}
						else if(record.get('hrEmployeeAttributeType') =="DEPARTMENT"){
							deptEmpAttributeValue.setVisible(true);
							var store = deptEmpAttributeValue.getStore();
							store.getProxy().extraParams = {
			    				academyLocationsIds : alIdValue
			    			};
							store.load({
								callback:function(){
									var departmentIds = record.get('departmentIds');
									if(!isNullOrEmpty(departmentIds)){
										departments = departmentIds.split(',');
										var departmentVal = [];
										for(i in departments) {
											departmentVal.push(parseInt(departments[i]))
										}
										deptEmpAttributeValue.setValue(departmentVal);
									}
								}
							});
						}
						else if(record.get('hrEmployeeAttributeType') =="DESIGNATION"){
							designationEmpAttributeValue.setVisible(true);
							var store = designationEmpAttributeValue.getStore();
							store.load({
								callback:function(){
									var designationIds = record.get('designationIds');
									if(!isNullOrEmpty(designationIds)){
										designations = designationIds.split(',');
										var designationVal = [];
										for(i in designations) {
											designationVal.push(parseInt(designations[i]))
										}
										designationEmpAttributeValue.setValue(designationVal);
									}
								}
							});
						}
					}
				});
			}
			$this.toggleReadOnlyFormItems(formPnl, true);
			form.down('#btnSaveLeaveCreditSettingForm').setVisible(false);
			form.down('#btnResetLeaveCreditSettingForm').setVisible(false);
		} else {
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
    },
    
    selectLeaveTypeEvent: function(obj, rec){
    	var $this = this;
    	var leavecreditsettingformlayout = $this.getLeavecreditsettingformlayout();
    	var eligibilityBasedOnId = leavecreditsettingformlayout.down('#eligibilityBasedOnId');
    	var employeeAttributeTypeId = leavecreditsettingformlayout.down('#employeeAttributeTypeId');
    	var leaveSetupEmpTypeChanged = leavecreditsettingformlayout.down('#leaveSetupEmpTypeChanged');

    	var empAttributeValue = leavecreditsettingformlayout.getForm().findField("empAttributeValue");
    	var enumEmpAttributeValue = leavecreditsettingformlayout.getForm().findField("enumEmpAttributeValue");
    	var userGrpEmpAttributeValue = leavecreditsettingformlayout.getForm().findField("userGrpEmpAttributeValue");

    	var yearId = leavecreditsettingformlayout.down('#yearId');
    	yearId.setDisabled(false);
    	
    	$this.checkLeaveTypeExist();

    	var idVal = obj.getValue();
    	Ext.Ajax.request({
    		method : "GET",
    		type : 'rest',
    		url : SERVERURL.PATH_HR_LEAVE_TYPE_FIND_BY_ID,
    		params : {
    			id : idVal
    		},
    		success : function(form,action) {
    			var data = Ext.JSON.decode(form.responseText);
    			eligibilityBasedOnId.setValue(getCommonTranslation(data.eligibilityCriteria));
    			eligibilityBasedOnId.config.eligibilityCriteria = data.eligibilityCriteria;
    			if(data.eligibilityCriteria == "EMPLOYEEATTRIBUTEBASED"){
    				employeeAttributeTypeId.setVisible(true);
    				employeeAttributeTypeId.setDisabled(false);
    				employeeAttributeTypeId.reset();
    			}
    			else{
    				employeeAttributeTypeId.setVisible(false);
    				employeeAttributeTypeId.setDisabled(true);
    				employeeAttributeTypeId.reset();
    				leaveSetupEmpTypeChanged.setVisible(false);
    				leaveSetupEmpTypeChanged.reset();
    			}
    			empAttributeValue.setVisible(false);
    			enumEmpAttributeValue.setVisible(false);
    			userGrpEmpAttributeValue.setVisible(false);
    			$this.setAllowBlank(empAttributeValue,true);
    			$this.setAllowBlank(enumEmpAttributeValue,true);
    			$this.setAllowBlank(userGrpEmpAttributeValue,true);
    			leavecreditsettingformlayout.getForm().checkValidity();
    		}
    	});
    },
    selectEmployeeAttributeTypeEvent: function(obj, rec){
    	var $this = this;
    	var leavecreditsettingformlayout = $this.getLeavecreditsettingformlayout();
    	var form = $this.getLeavecreditsettingformlayout().getForm();
    	var empAttributeValue = form.findField("empAttributeValue");
    	var enumEmpAttributeValue = form.findField("enumEmpAttributeValue");
    	var userGrpEmpAttributeValue = form.findField("userGrpEmpAttributeValue");
    	var designationAttributeValue = form.findField("designationAttributeValue");
    	var leaveSetupEmpTypeChanged  = form.findField("leaveSetupEmpTypeChanged");
    	var creditTypeId = form.findField("hrLeaveCreditType");

    	if(creditTypeId.getValue() == "RECURRING" && obj.getValue()=='USER_GROUP_TYPE'){
    		leaveSetupEmpTypeChanged.setVisible(true);
    		leaveSetupEmpTypeChanged.reset();
    		if(isNullOrEmpty(userGrpEmpAttributeValue.getDisplayValue())){
				leaveSetupEmpTypeChanged.setDisabled(true);
			}else{
			   leaveSetupEmpTypeChanged.setDisabled(false);
			}
    	}else{
    		leaveSetupEmpTypeChanged.setVisible(false);	
    	}
    	
    	if(rec == "GENDER"){
    		empAttributeValue.reset();
    		empAttributeValue.setVisible(false);
    		//empAttributeValue.allowBlank=true;
    		$this.setAllowBlank(empAttributeValue,true);
    		enumEmpAttributeValue.setVisible(true);
    		enumEmpAttributeValue.reset();
    		//enumEmpAttributeValue.allowBlank=false;
    		$this.setAllowBlank(enumEmpAttributeValue,false);
    		userGrpEmpAttributeValue.reset();
    		userGrpEmpAttributeValue.setVisible(false);
    		//userGrpEmpAttributeValue.allowBlank=true;
    		$this.setAllowBlank(userGrpEmpAttributeValue,true);
    		
    		$this.setAllowBlank(designationAttributeValue,true);
    		designationAttributeValue.setVisible(false);
    		designationAttributeValue.reset();
    	
    		enumEmpAttributeValue.getStore().load();
    	}
    	else if(rec == "DEPARTMENT"){
    		var alIds = leavecreditsettingformlayout.down("#academyLocationId").getValue();
    		if(!isNullOrEmpty(alIds) && !isNullOrEmpty(alIds[0])) {
    			var academyLocations = []; 
    			var academyLocationIds; 
    			for( var i=0; i<alIds.length; i++ ) {
    				if (Ext.isObject(alIds[i])) {
    					academyLocations.push(alIds[i].data.id);
					} else {
						academyLocations.push(alIds[i]);
					}
    			}
    			academyLocationIds = academyLocations.join();

    			var store = leavecreditsettingformlayout.down('#empAttributeValueItemId').getStore();
    			store.getProxy().extraParams = {
    				academyLocationsIds : academyLocationIds
    			};
    			store.load();
    		}

    		empAttributeValue.setVisible(true);
    		empAttributeValue.reset();
    		$this.setAllowBlank(empAttributeValue,false);
    		
    		enumEmpAttributeValue.reset();
    		enumEmpAttributeValue.setVisible(false);
    		$this.setAllowBlank(enumEmpAttributeValue,true);
    		
    		userGrpEmpAttributeValue.reset();
    		userGrpEmpAttributeValue.setVisible(false);
    		$this.setAllowBlank(userGrpEmpAttributeValue,true);
    		
    		designationAttributeValue.reset();
    		designationAttributeValue.setVisible(false);
    		$this.setAllowBlank(designationAttributeValue,true);
    		
    	}
    	else if(rec =="USER_GROUP_TYPE"){
    		userGrpEmpAttributeValue.getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_USER_GROUP_TYPE_VALUE;
    		userGrpEmpAttributeValue.reset();
    		userGrpEmpAttributeValue.getStore().load();
    		userGrpEmpAttributeValue.setVisible(true);
    		//userGrpEmpAttributeValue.allowBlank=false;
    		$this.setAllowBlank(userGrpEmpAttributeValue,false);
    		empAttributeValue.setVisible(false);
    		empAttributeValue.reset();
    		//empAttributeValue.allowBlank=true;
    		$this.setAllowBlank(empAttributeValue,true);
    		enumEmpAttributeValue.reset();
    		enumEmpAttributeValue.setVisible(false);
    		//enumEmpAttributeValue.allowBlank=true;
    		
    		designationAttributeValue.reset();
    		designationAttributeValue.setVisible(false);
    		$this.setAllowBlank(designationAttributeValue,true);
    		
    		$this.setAllowBlank(enumEmpAttributeValue,true);
    	}
    	else if(rec =="DESIGNATION"){
    		
			userGrpEmpAttributeValue.reset();
    		userGrpEmpAttributeValue.setVisible(false);
    		$this.setAllowBlank(userGrpEmpAttributeValue,true);
    		
    		empAttributeValue.setVisible(false);
    		empAttributeValue.reset();
    		$this.setAllowBlank(empAttributeValue,true);
    		
    		enumEmpAttributeValue.reset();
    		enumEmpAttributeValue.setVisible(false);
    		$this.setAllowBlank(enumEmpAttributeValue,true);
    		
    		designationAttributeValue.reset();
    		designationAttributeValue.setVisible(true);
    		$this.setAllowBlank(designationAttributeValue,false);
    		
    		var store = leavecreditsettingformlayout.down('#designationAttributeValueItemId').getStore();
			store.load();
    	}
    },
    
    enableDisableLeaveCreditFormFields: function(obj, record){
    	var $this = this;
    	var leavecreditsettingformlayout = $this.getLeavecreditsettingformlayout();
    	var objVal = obj.getValue();
    	var creditPeriodId = leavecreditsettingformlayout.down('#creditPeriodId');
    	var proratedCreditId = leavecreditsettingformlayout.down('#proratedCreditId');
    	var creditBalanceId = leavecreditsettingformlayout.down('#creditBalanceId');
    	var maxBalanceId = leavecreditsettingformlayout.down('#maxBalanceId');
    	var leaveLapseId = leavecreditsettingformlayout.down('#leaveLapseId');
    	var leaveCarryForwardId = leavecreditsettingformlayout.down('#leaveCarryForwardId');
    	var leaveEncashmentId = leavecreditsettingformlayout.down('#leaveEncashmentId');
    	
    	var lapsePeriodId = leavecreditsettingformlayout.down('#lapsePeriodId');
    	var encashmentPeriodId = leavecreditsettingformlayout.down('#encashmentPeriodId');
    	var minBalanceRequiredId = leavecreditsettingformlayout.down('#minBalanceRequiredId');
    	var maxDaysToEncashId = leavecreditsettingformlayout.down('#maxDaysToEncashId');
    	var carryForwardPeriodId = leavecreditsettingformlayout.down('#carryForwardPeriodId');
    	var maxDaysToCarryForwardId = leavecreditsettingformlayout.down('#maxDaysToCarryForwardId');
    	var creditFromNextPeriodOfJoining = leavecreditsettingformlayout.down('#creditFromNextPeriodOfJoiningId');
    	var leaveSetupEmpTypeChanged = leavecreditsettingformlayout.down('#leaveSetupEmpTypeChanged');
    	var employeeAttributeTypeId = leavecreditsettingformlayout.down('#employeeAttributeTypeId');
    	var userGrpEmpAttributeValue = leavecreditsettingformlayout.down('#userGrpEmpAttributeValueItemId');
    	
    	if(objVal == "RECURRING"){
    		creditPeriodId.setDisabled(false);
    		proratedCreditId.setDisabled(false);
    		creditBalanceId.setDisabled(false);
    		maxBalanceId.setDisabled(false);
    		leaveLapseId.setDisabled(false);
    		creditFromNextPeriodOfJoining.setDisabled(false);
    		
    		var isLeaveLapseId = leaveLapseId.getValue().isleaveLapseId;
    		if(!isLeaveLapseId){
    			leaveCarryForwardId.setDisabled(false);
    			leaveEncashmentId.setDisabled(false);
    		}
    		else{
    			leaveCarryForwardId.setDisabled(true);
    			leaveEncashmentId.setDisabled(true);
    		}
    		
    		lapsePeriodId.setDisabled(true);
    		encashmentPeriodId.setDisabled(true);
    		minBalanceRequiredId.setDisabled(true);
    		maxDaysToEncashId.setDisabled(true);
    		carryForwardPeriodId.setDisabled(true);
    		maxDaysToCarryForwardId.setDisabled(true);
    		
    		leaveLapseId.setValue({isleaveLapseId: false});
    		leaveCarryForwardId.setValue({isleaveCarryForwardId: false});
    		leaveEncashmentId.setValue({isleaveEncashmentId: false}); 
    		if(employeeAttributeTypeId.getValue()=="USER_GROUP_TYPE"){
    			leaveSetupEmpTypeChanged.setVisible(true);
    			if(isNullOrEmpty(userGrpEmpAttributeValue.getDisplayValue())){
					leaveSetupEmpTypeChanged.setDisabled(true);
				}else{
					leaveSetupEmpTypeChanged.setDisabled(false);
				}
    		}else{
    			leaveSetupEmpTypeChanged.setVisible(false);
    		}
    	}
    	else if(objVal == "ONE_TIME"){
    		creditPeriodId.setDisabled(true);
    		proratedCreditId.setDisabled(true);
    		creditBalanceId.setDisabled(false);
    		maxBalanceId.setDisabled(false);
    		leaveLapseId.setDisabled(true);
    		leaveCarryForwardId.setDisabled(true);
			leaveEncashmentId.setDisabled(true);
			creditFromNextPeriodOfJoining.setDisabled(true);
			
			lapsePeriodId.setDisabled(true);
			encashmentPeriodId.setDisabled(true);
    		minBalanceRequiredId.setDisabled(true);
    		maxDaysToEncashId.setDisabled(true);
    		carryForwardPeriodId.setDisabled(true);
    		maxDaysToCarryForwardId.setDisabled(true);
    		
    		leaveLapseId.setValue({isleaveLapseId: false});
    		leaveCarryForwardId.setValue({isleaveCarryForwardId: false});
    		leaveEncashmentId.setValue({isleaveEncashmentId: false});
    		leaveSetupEmpTypeChanged.setVisible(false);
    		
    		/*var leaveLapseId = leaveLapseId.getValue().isleaveLapseId;
    		if(!leaveLapseId){
    			leaveCarryForwardId.setDisabled(false);
    			leaveEncashmentId.setDisabled(false);
    		}
    		else{
    			leaveCarryForwardId.setDisabled(true);
    			leaveEncashmentId.setDisabled(true);
    		}*/
    	}
    	else{
    		leaveLapseId.setValue({isleaveLapseId: false});
    		leaveCarryForwardId.setValue({isleaveCarryForwardId: false});
    		leaveEncashmentId.setValue({isleaveEncashmentId: false});
    		
    		creditPeriodId.setDisabled(true);
    		proratedCreditId.setDisabled(true);
    		creditBalanceId.setDisabled(true);
    		maxBalanceId.setDisabled(true);
    		leaveLapseId.setDisabled(true);
    		leaveCarryForwardId.setDisabled(true);
    		leaveEncashmentId.setDisabled(true);
    		lapsePeriodId.setDisabled(true);
    		encashmentPeriodId.setDisabled(true);
    		minBalanceRequiredId.setDisabled(true);
    		maxDaysToEncashId.setDisabled(true);
    		carryForwardPeriodId.setDisabled(true);
    		maxDaysToCarryForwardId.setDisabled(true);
    		creditFromNextPeriodOfJoining.setDisabled(true);
    		leaveSetupEmpTypeChanged.setVisible(false);
    	}
    	creditPeriodId.reset();
    	creditBalanceId.reset();
    	maxBalanceId.reset();
    	lapsePeriodId.reset();
    	encashmentPeriodId.reset();
    	minBalanceRequiredId.reset();
    	maxDaysToEncashId.reset();
    	carryForwardPeriodId.reset();
    	maxDaysToCarryForwardId.reset();
    	
    	leavecreditsettingformlayout.getForm().checkValidity();
    },
    changeLeaveLapseRadioVal: function(obj, newValue, oldValue, eOpts){
    	var $this = this;
    	var leavecreditsettingformlayout = $this.getLeavecreditsettingformlayout();
    	var lapsePeriodId = leavecreditsettingformlayout.down('#lapsePeriodId');
    	var leaveEncashmentId = leavecreditsettingformlayout.down('#leaveEncashmentId');
    	var leaveCarryForwardId = leavecreditsettingformlayout.down('#leaveCarryForwardId');

    	var lapsePeriodId = leavecreditsettingformlayout.down('#lapsePeriodId');
    	var encashmentPeriodId = leavecreditsettingformlayout.down('#encashmentPeriodId');
    	var minBalanceRequiredId = leavecreditsettingformlayout.down('#minBalanceRequiredId');
    	var maxDaysToEncashId = leavecreditsettingformlayout.down('#maxDaysToEncashId');
    	var carryForwardPeriodId = leavecreditsettingformlayout.down('#carryForwardPeriodId');
    	var maxDaysToCarryForwardId = leavecreditsettingformlayout.down('#maxDaysToCarryForwardId');
    	var leaveSetupEmpTypeChanged = leavecreditsettingformlayout.down('#leaveSetupEmpTypeChanged');
    	leaveSetupEmpTypeChanged.reset();
    	if(newValue.isleaveLapseId){
    		lapsePeriodId.setDisabled(false);
    		leaveEncashmentId.setDisabled(true);
    		leaveCarryForwardId.setDisabled(true);
    		leaveCarryForwardId.setValue({isleaveCarryForwardId: false});
    		leaveEncashmentId.setValue({isleaveEncashmentId: false});
    		this.loadDataForLeaveSetupCombo();
    	}
    	else{
    		lapsePeriodId.setDisabled(true);
    		leaveEncashmentId.setDisabled(false);
    		leaveCarryForwardId.setDisabled(false);
    		lapsePeriodId.reset();
    		this.loadDataForLeaveSetupCombo();
    	}
    	encashmentPeriodId.setDisabled(true);
    	minBalanceRequiredId.setDisabled(true);
    	maxDaysToEncashId.setDisabled(true);
    	carryForwardPeriodId.setDisabled(true);
    	maxDaysToCarryForwardId.setDisabled(true);
    	leavecreditsettingformlayout.getForm().checkValidity();
    	
    	
    },
    changeLeaveCarryForwardRadioVal: function(obj, newValue, oldValue, eOpts){
    	var $this = this;
    	var leavecreditsettingformlayout = $this.getLeavecreditsettingformlayout();
    	var carryForwardPeriodId = leavecreditsettingformlayout.down('#carryForwardPeriodId');
    	var maxDaysToCarryForwardId = leavecreditsettingformlayout.down('#maxDaysToCarryForwardId');
    	var leaveSetupEmpTypeChanged = leavecreditsettingformlayout.down('#leaveSetupEmpTypeChanged');
    	leaveSetupEmpTypeChanged.reset();
    	this.loadDataForLeaveSetupCombo();
    	if(newValue.isleaveCarryForwardId){
    		carryForwardPeriodId.setDisabled(false);
    		maxDaysToCarryForwardId.setDisabled(false);
    	}
    	else{
    		carryForwardPeriodId.setDisabled(true);
    		maxDaysToCarryForwardId.setDisabled(true);
    		carryForwardPeriodId.reset();
    		maxDaysToCarryForwardId.reset();
    	}
    	leavecreditsettingformlayout.getForm().checkValidity();
    },
    changeLeaveEncashmentRadioVal: function(obj, newValue, oldValue, eOpts){
    	var $this = this;
    	var leavecreditsettingformlayout = $this.getLeavecreditsettingformlayout();
    	var encashmentPeriodId = leavecreditsettingformlayout.down('#encashmentPeriodId');
    	var minBalanceRequiredId = leavecreditsettingformlayout.down('#minBalanceRequiredId');
    	var maxDaysToEncashId = leavecreditsettingformlayout.down('#maxDaysToEncashId');
    	var leaveSetupEmpTypeChanged = leavecreditsettingformlayout.down('#leaveSetupEmpTypeChanged');
    	leaveSetupEmpTypeChanged.reset();
    	this.loadDataForLeaveSetupCombo();
    	if(newValue.isleaveEncashmentId){
    		encashmentPeriodId.setDisabled(false);
    		minBalanceRequiredId.setDisabled(false);
    		maxDaysToEncashId.setDisabled(false);
    	}
    	else{
    		encashmentPeriodId.setDisabled(true);
    		minBalanceRequiredId.setDisabled(true);
    		maxDaysToEncashId.setDisabled(true);
    		encashmentPeriodId.reset();
    		minBalanceRequiredId.reset();
    		maxDaysToEncashId.reset(true);
    	}
    	leavecreditsettingformlayout.getForm().checkValidity();
    },
    checkLeaveTypeExist: function(){
    	var $this = this;
    	var leavecreditsettingformlayout = $this.getLeavecreditsettingformlayout();
    	var leaveTypeId = leavecreditsettingformlayout.down('#leaveTypeId');
    	var yearId = leavecreditsettingformlayout.down('#yearId');
    	var monthId = leavecreditsettingformlayout.down('#monthId');

    	var leaveTypeId = leaveTypeId.getValue();
    	var yearVal = yearId.getValue();
    	var monthVal = monthId.getValue();
    	
    	if(!isNullOrEmpty(leaveTypeId) && !isNullOrEmpty(yearVal) && !isNullOrEmpty(monthVal)){
    		Ext.Ajax.request({
        		method : "GET",
        		type : 'rest',
        		url : SERVERURL.PATH_CHECK_LEAVE_TYPE_FOR_PERIOD,
        		params : {
        			leaveTypeId : leaveTypeId,
        			year:yearVal,
        			month:monthVal
        		},
        		success : function(form,action) {
        			var data = Ext.JSON.decode(form.responseText);
        			if(data === false){
        				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ALERT_LEAVE_CREDIT_SETTING_ALREADY_EXIST'));
        				yearId.reset();
        				monthId.reset();
        			}
        		}
        	});
    	}
    },
    saveLeaveCreditSettingFormData: function(){
		var $this = this;
		var formLayout = $this.getLeavecreditsettingformlayout();
		var values = formLayout.getForm().getValues();
		var grid = $this.getLeavecreditsettinggrid();
		var filterForm = $this.getLeavecreditsettingfilterform();
		var leaveCreditSettingModel = new Academia.model.leavemanagement.leavecreditsetting.LeaveCreditSettingGridModel(values);
		var formData = leaveCreditSettingModel.data;
		var id = formLayout.down('#idItemId').getValue();
		formData.hrLeaveType = {
				"id":values.hrLeaveType
		};
		
		var isleaveLapse = formLayout.down('#leaveLapseId').getValue().isleaveLapseId;
		var leaveEncashmentId = formLayout.down('#leaveEncashmentId').getValue().isleaveEncashmentId;
		var isleaveCarryForwardId = formLayout.down('#leaveCarryForwardId').getValue().isleaveCarryForwardId;
		var isproratedCreditId = formLayout.down('#proratedCreditId').getValue().isproratedCreditId;
		var leaveSetupEmpTypeChanged = formLayout.down('#leaveSetupEmpTypeChanged').getValue();
		
		if(formData.hrLeaveCreditType == "RECURRING"){
			if(isleaveLapse == false && leaveEncashmentId == false && isleaveCarryForwardId == false){
				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ALERT_CARRY_FORWARD_ENCASHMENT'));
				return;
			}
		}
		
		formData.isLeaveLapse = isleaveLapse;
		formData.isLeaveEncashment = leaveEncashmentId;
		formData.isLeaveCarryForward = isleaveCarryForwardId;
		formData.isProratedCredit = isproratedCreditId;
		formData.leaveSetupEmpTypeChanged = leaveSetupEmpTypeChanged;
		
		var eligibilityBasedOnId = formLayout.down('#eligibilityBasedOnId');
		formData.elgibilityBasedOn = eligibilityBasedOnId.config.eligibilityCriteria;
		
		if(!isNullOrEmpty(formData.hrEmployeeAttributeType) &&  formData.hrEmployeeAttributeType == "GENDER"){
			var arryGender = [];
			values.enumEmpAttributeValue.forEach(function(obj){
				arryGender.push(obj.data.id);
			});
			formData.gender = arryGender.join();
		}
		else if(!isNullOrEmpty(formData.hrEmployeeAttributeType) &&  formData.hrEmployeeAttributeType == "USER_GROUP_TYPE"){
			var arryUserGrp = [];
			values.userGrpEmpAttributeValue.forEach(function(obj){
				arryUserGrp.push(obj.data.code);
			});
			formData.userGroupType = arryUserGrp.join();
		}
		else if(!isNullOrEmpty(formData.hrEmployeeAttributeType) &&  formData.hrEmployeeAttributeType == "DEPARTMENT"){
			var arryDepartment = [];
			values.empAttributeValue.forEach(function(obj){
				arryDepartment.push(obj.data.id);
			});
			formData.departmentIds = arryDepartment.join();
		}
		else if(!isNullOrEmpty(formData.hrEmployeeAttributeType) &&  formData.hrEmployeeAttributeType == "DESIGNATION"){
			var arryDesignation = [];
			values.designationAttributeValue.forEach(function(obj){
				arryDesignation.push(obj.data.id);
			});
			formData.designationIds = arryDesignation.join();
		}
		
		if(formData.hrLeaveCreditType == "RECURRING" || formData.hrLeaveCreditType == "ONE_TIME"){
			if(parseFloat(formData.creditBalance)>parseFloat(formData.maxCreditBalance)){
				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('Max Balance should be greater then Credit Balance'));
				return;
			}
		}
		
		if(formData.hrLeaveCreditType == "NOT_APPLICABLE"){
			formData.creditBalance = 0;
			formData.maxCreditBalance = 0;
		}
		
		if(formData.hrLeaveCreditType == "ONE_TIME" || formData.hrLeaveCreditType == "NOT_APPLICABLE"){
			delete formData.leaveCreditPeriod;
		}
		
		if(!isNullOrEmpty(values.hrLeaveCreditSettingLocations)){
			var arryLeaveSettingLocations = [];
			values.hrLeaveCreditSettingLocations.forEach(function(obj){
				var objnew = new Object();
				objnew.academyLocation = {
						"id":obj.data.id
				};
				arryLeaveSettingLocations.push(objnew);
			});
			formData.hrLeaveCreditSettingLocations = arryLeaveSettingLocations;
		}
		
		
		if(isNullOrEmpty(formData.leaveLapsePeriod)){
			delete formData.leaveLapsePeriod;
		}
		if(isNullOrEmpty(formData.leaveCarryForwardPeriod)){
			delete formData.leaveCarryForwardPeriod;
		}
		if(isNullOrEmpty(formData.leaveCreditPeriod)){
			delete formData.leaveCreditPeriod;
		}
		
		if(isNullOrEmpty(formData.creditBalance)){
			formData.creditBalance = 0;
		}
		if(isNullOrEmpty(formData.maxCreditBalance)){
			formData.maxCreditBalance = 0;
		}
		if(isNullOrEmpty(formData.leaveEncashmentPeriod)){
			delete formData.leaveEncashmentPeriod;
		}
		if(isNullOrEmpty(formData.minBalanceForLeaveEncashment)){
			delete formData.minBalanceForLeaveEncashment;
		}
		if(isNullOrEmpty(formData.maxDaysForLeaveEncashment)){
			delete formData.maxDaysForLeaveEncashment;
		}
		
		if(isNullOrEmpty(formData.maxDaysToCarryForward)){
			delete formData.maxDaysToCarryForward;
		}
		
		if(isNullOrEmpty(formData.hrEmployeeAttributeType)){
			delete formData.hrEmployeeAttributeType;
		}
		if(isNullOrEmpty(formData.gender)){
			delete formData.gender;
		}
		if(isNullOrEmpty(formData.userGroupType)){
			delete formData.userGroupType;
		}
		if(isNullOrEmpty(formData.departmentIds)){
			delete formData.departmentIds;
		}
		if(isNullOrEmpty(formData.designationIds)){
			delete formData.designationIds;
		}
		if(isNullOrEmpty(formData.creditFromNextPeriodOfJoining)){
			formData.creditFromNextPeriodOfJoining = false
		}
		if(!isNullOrEmpty(formData)){
			formData = Ext.encode(formData);
			var tabName;
			var submitUrl, isUpdate = false;
			
			if (isNullOrEmpty(id)) {
				submitUrl = SERVERURL.PATH_HR_LEAVE_CREDIT_SETTING_SAVE;
				isUpdate = false;
				tabName = getCommonTranslation('ADD_LEAVE_CREDIT_SETTINGS');
			} else {
				//submitUrl = SERVERURL.PATH_HR_LEAVE_CREDIT_SETTING_SAVE;				    			
				isUpdate = true;
				//tabName = getCommonTranslation('ADD_LEAVE_CREDIT_SETTINGS');
			}        
			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			Ext.Ajax.request({
				type: 'rest',
				url: submitUrl,
				jsonData: formData,
				method: 'POST',
				success: function(form, action) {
					var resp = form.responseText;
					Ext.getBody().unmask();
					showSuccessMessage(getCommonTranslation('HR_LEAVE_CREDIT_SETTINGS'), getCommonTranslation('SAVEDSUCCESSFULLY'));
					
					var contentpanel = $this.getContentPanel();
			        var getcontroller=$this.getController('menu.CoreERPNavigationController');
			        var tabName = getCommonTranslation('ADD_LEAVE_CREDIT_SETTINGS');
			        var getTab=getcontroller.getTab(tabName);
			    	if(getTab!=null){
			    		contentpanel.remove(getTab, true);
			    	}
			    	if(grid != undefined) {
						var grdStore = grid.getStore();
						grid.getSelectionModel().deselectAll();
						grdStore.reload();
					}
			    	
			    	if(filterForm != undefined){
			    		var creditSettingCodeItemId = filterForm.down('#creditSettingCodeItemId');
			    		creditSettingCodeItemId.getStore().load();
			    	}
				},
				failure: function(form, action) {
					Ext.getBody().unmask();
					showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
				}
			});
		}
	},
	
	resetLeaveCreditSettingFormData: function(){

		var $this = this;
		var leavecreditsettingformlayout = $this.getLeavecreditsettingformlayout();
		leavecreditsettingformlayout.getForm().reset();
		
		var creditPeriodId = leavecreditsettingformlayout.down('#creditPeriodId');
    	var proratedCreditId = leavecreditsettingformlayout.down('#proratedCreditId');
    	var creditBalanceId = leavecreditsettingformlayout.down('#creditBalanceId');
    	var maxBalanceId = leavecreditsettingformlayout.down('#maxBalanceId');
	
	    var leaveLapseId = leavecreditsettingformlayout.down('#leaveLapseId');
    	var leaveEncashmentId = leavecreditsettingformlayout.down('#leaveEncashmentId');
    	var leaveCarryForwardId = leavecreditsettingformlayout.down('#leaveCarryForwardId');

    	var lapsePeriodId = leavecreditsettingformlayout.down('#lapsePeriodId');
    	var encashmentPeriodId = leavecreditsettingformlayout.down('#encashmentPeriodId');
    	var minBalanceRequiredId = leavecreditsettingformlayout.down('#minBalanceRequiredId');
    	var maxDaysToEncashId = leavecreditsettingformlayout.down('#maxDaysToEncashId');
    	var carryForwardPeriodId = leavecreditsettingformlayout.down('#carryForwardPeriodId');
    	var maxDaysToCarryForwardId = leavecreditsettingformlayout.down('#maxDaysToCarryForwardId');
    	
    	var yearId = leavecreditsettingformlayout.down('#yearId');
    	var monthId = leavecreditsettingformlayout.down('#monthId');
    	
    	var employeeAttributeTypeId = leavecreditsettingformlayout.down('#employeeAttributeTypeId');
    	var empAttributeValueItemId = leavecreditsettingformlayout.down('#empAttributeValueItemId');
    	var enumEmpAttributeValueItemId = leavecreditsettingformlayout.down('#enumEmpAttributeValueItemId');
    	var userGrpEmpAttributeValueItemId = leavecreditsettingformlayout.down('#userGrpEmpAttributeValueItemId');
    	var leaveSetupEmpTypeChanged = leavecreditsettingformlayout.down('#leaveSetupEmpTypeChanged');
    	
    	employeeAttributeTypeId.setVisible(false);
    	employeeAttributeTypeId.setDisabled(true);
    	empAttributeValueItemId.setVisible(false);
    	enumEmpAttributeValueItemId.setVisible(false);
    	userGrpEmpAttributeValueItemId.setVisible(false);
    	leaveSetupEmpTypeChanged.setVisible(false);
    	leaveSetupEmpTypeChanged.setDisabled(true);
    	
    	yearId.setDisabled(true);
    	monthId.setDisabled(true);
    	
    	creditPeriodId.setDisabled(true);
    	proratedCreditId.setDisabled(true);
    	creditBalanceId.setDisabled(true);
    	maxBalanceId.setDisabled(true);
    	
    	leaveLapseId.setDisabled(true);
    	leaveEncashmentId.setDisabled(true);
    	leaveCarryForwardId.setDisabled(true);
    	
    	lapsePeriodId.setDisabled(true);
    	encashmentPeriodId.setDisabled(true);
    	minBalanceRequiredId.setDisabled(true);
    	maxDaysToEncashId.setDisabled(true);
    	carryForwardPeriodId.setDisabled(true);
    	maxDaysToCarryForwardId.setDisabled(true);
	},
	
	resetLeaveCreditSearchFilterForm: function(){
		var $this = this;
		var form = $this.getLeavecreditsettingfilterform();
		form.getForm().reset();
	},
	multiselectMouseOverEvent: function(field){
		var $this = this;
		var leavecreditsettingformlayout = $this.getLeavecreditsettingformlayout();
		field.bodyEl.on('mouseover', function(e, t, eOpts) {
			if(e.target.className == "x-tab-close-btn x-boxselect-item-close"){
				e.target.style.backgroundPosition = "0px 0px";
				e.stopPropagation();
				e.preventDefault();
			}
		})
	},
	enableLeaveSetupField:function(){
		var $this = this;
		var leavecreditsettingformlayout = $this.getLeavecreditsettingformlayout();
		var leaveSetupEmpTypeChanged = leavecreditsettingformlayout.down('#leaveSetupEmpTypeChanged');
		leaveSetupEmpTypeChanged.setDisabled(false);
	},
	loadDataForLeaveSetupCombo:function(){
		var leavecreditsettingformlayout = this.getLeavecreditsettingformlayout();
		var leaveLapseId = leavecreditsettingformlayout.down('#leaveLapseId');
    	var leaveEncashmentId = leavecreditsettingformlayout.down('#leaveEncashmentId');
    	var leaveCarryForwardId = leavecreditsettingformlayout.down('#leaveCarryForwardId');
		var leaveSetupEmpTypeChanged = leavecreditsettingformlayout.down('#leaveSetupEmpTypeChanged');
		var userGrpEmpAttributeValueItemId = leavecreditsettingformlayout.down('#userGrpEmpAttributeValueItemId');
		var leaveSetupEmpTypeChangedStore = leaveSetupEmpTypeChanged.getStore();
		
		leaveSetupEmpTypeChangedStore.clearFilter(true);
		leaveSetupEmpTypeChangedStore.load();
		if(!isNullOrEmpty(userGrpEmpAttributeValueItemId.getDisplayValue())){
		  leaveSetupEmpTypeChanged.setDisabled(false);
		}else{
			leaveSetupEmpTypeChanged.setDisabled(true);
		}
		if(leaveLapseId.getValue().isleaveLapseId){
			leaveSetupEmpTypeChangedStore.filter({
	            filterFn: function(record) {
	                var flag = true;
	                if (record.get('value') == 'Leave Lapse') {
	                    flag = true;
	                } else {
	                    flag = false;
	                }
	                return flag;
	            }
	        }, this);
			
		}else if(leaveEncashmentId.getValue().isleaveEncashmentId && leaveCarryForwardId.getValue().isleaveCarryForwardId){
			leaveSetupEmpTypeChangedStore.filter({
	            filterFn: function(record) {
	                var flag = true;
	                if (record.get('value') == 'Leave Encash' || record.get('value') == 'Leave Carry Forward') {
	                    flag = true;
	                } else {
	                    flag = false;
	                }
	                return flag;
	            }
	        }, this);
		}else if(leaveEncashmentId.getValue().isleaveEncashmentId){
			leaveSetupEmpTypeChangedStore.filter({
	            filterFn: function(record) {
	                var flag = true;
	                if (record.get('value') == 'Leave Encash') {
	                    flag = true;
	                } else {
	                    flag = false;
	                }
	                return flag;
	            }
	        }, this);
		}else if(leaveCarryForwardId.getValue().isleaveCarryForwardId){
			leaveSetupEmpTypeChangedStore.filter({
	            filterFn: function(record) {
	                var flag = true;
	                if (record.get('value') == 'Leave Carry Forward') {
	                    flag = true;
	                } else {
	                    flag = false;
	                }
	                return flag;
	            }
	        }, this);
		}else{
			leaveSetupEmpTypeChangedStore.filter({
	            filterFn: function(record) {
	                return false;
	            }
	        }, this);
		}
	}
});