/**
 * This controller is used for the Manage Ceremony
 * 
 * 
 * @author Pankaj Sisodiya
 */
Ext.define('Academia.controller.manageCeremony.ManageCeremonyController', {
    extend: 'Academia.controller.base.BaseController',
    views: ['manageCeremony.ManageCeremonyStructure','manageCeremony.ManageCeremonyFilter','manageCeremony.ManageCeremonyGrid','manageCeremony.AddNewCeremonyStructure','manageCeremony.AddNewCeremonyForm',
    	'manageCeremony.ManageCeremonyMappedProgramGridStructure','manageCeremony.ManageCeremonyMappedProgramGrid','manageCeremony.CeremonyApplyToViewWindow',
    	'manageCeremony.ManageCeremonyAddMappingTab','manageCeremony.CeremoneyAddMappingStructure','manageCeremony.CeremoneyAddMappingALGrid',
    	'manageCeremony.CeremoneyAddMappingProgramGrid','manageCeremony.CeremonyAddMappingProgramViewGrid','manageCeremony.CeremonyAddMappingBatchGrid',
    	'manageCeremony.CeremonyAddMappingBatchPeriodGrid','feeandpayment.adjustment.AdjustmentProgressTracker','manageCeremony.CeremonyMappingAlertWin','manageCeremony.ManageCeremonyStudentMappedGrid','manageCeremony.ManageCeremonyStudentMappedStructure','common.StatusCombo',
    	'manageCeremony.StudentMappedCeremonyWin'],
    models:['manageceremony.CeremonyAcademyLocationModel','manageceremony.CeremoneyALMappingModel','manageceremony.CeremonyPBPModel'],	
    stores:['common.AcademyLocationNameSeparated','manageCeremony.CeremonyIdNameStore','common.AcademyLocationNameSeparated','manageCeremony.ManageCeremonyGridStore','program.ProgramGroupStoreForLocalSerach',
    	'manageCeremony.ManageCeremonyApplyToGridStore','manageCeremony.CeremoneyALMappingComboStore','manageCeremony.CeremoneyALMappingStore',
    	'manageCeremony.CeremoneyProgramGroupMappingStore','manageCeremony.CeremoneyProgramGroupSmartComboStore','manageCeremony.CeremonyProgramMappingStore',
    	'manageCeremony.CeremonyBatchPeriodStore','feeandpayment.ALProgramSearchCombo','feeandpayment.ALProgramBatchList',
        'feeandpayment.ALProgramBatchSearchCombo','feeandpayment.ALProgramBatchSeatTypeList','feeandpayment.ALProgramBatchPeriodList','manageCeremony.ManageCeremonyStudentMappedStore','scholarships.ScholarshipAccountingYearStore','common.StatusComboStore','manageCeremony.CeremonyStudentMappedStore','feeandpayment.FindAllProgramsByALId'],
    refs: [{
    	ref:'manageCeremonyStructure',
    	selector:'manageCeremonyStructure'
    },{
    	ref:'manageCeremonyFilter',
    	selector:'manageCeremonyFilter'
    },{
    	ref:'manageCeremonyGrid',
    	selector:'manageCeremonyGrid'
    },{
        ref: 'contentPanel',
        selector: 'contentpanel'
    },{
        ref: 'addNewCeremonyStructure',
        selector: 'addNewCeremonyStructure'
    },{
        ref: 'addNewCeremonyForm',
        selector: 'addNewCeremonyForm'
    },{
        ref: 'manageceremonymappedprogramgridstructure',
        selector: 'manageceremonymappedprogramgridstructure'
    },{
        ref: 'manageceremonymappedprogramgrid',
        selector: 'manageceremonymappedprogramgrid'
    },{
    	ref:'ceremonyapplytoviewwindow',
    	selector:'ceremonyapplytoviewwindow'
    },{
    	ref:'manageceremonyaddmappingtab',
    	selector:'manageceremonyaddmappingtab'
    },{
    	ref:'ceremoneyaddmappingstructure',
    	selector:'ceremoneyaddmappingstructure'
    },{
    	ref:'ceremoneyaddmappingalgrid',
    	selector:'ceremoneyaddmappingalgrid'
    },{
    	ref:'ceremoneyaddmappingprogramgrid',
    	selector:'ceremoneyaddmappingprogramgrid'
    },{
    	ref:'ceremonyaddmappingprogramviewgrid',
    	selector:'ceremonyaddmappingprogramviewgrid'
    },{
    	ref:'ceremonyaddmappingbatchgrid',
    	selector:'ceremonyaddmappingbatchgrid'
    },{
    	ref:'ceremonyaddmappingbatchperiodgrid',
    	selector:'ceremonyaddmappingbatchperiodgrid'
    },{
    	ref:'adjustmentprogresstracker',
    	selector:'adjustmentprogresstracker'
    },{
    	ref:'ceremonymappingalertwin',
    	selector:'ceremonymappingalertwin'
    },{
    	ref:'manageCeremonyStudentMappedGrid',
    	selector:'manageCeremonyStudentMappedGrid'
    },{
    	ref:'manageCeremonyStudentMappedStructure',
    	selector:'manageCeremonyStudentMappedStructure'
    },{
    	ref:'studentMappedCeremonyWin',
    	selector:'studentMappedCeremonyWin'
    }],  
    config: {
    	TNS_MANAGE_CEREMONY_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TNS_MANAGE_CEREMONY_PRIVILEGES'),
    	TNS_MANAGE_CEREMONY_STUDENT_MAP_PRIVILEGES:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TNS_MANAGE_CEREMONY_STUDENT_MAP_PRIVILEGES')
    },

    init: function(application) {
        this.control({
        	'manageCeremonyGrid': {
                render: function(grid) {
                	var me=this;
                	var buttonsToolBar = grid.query('toolbar')[0];
                	var buttons = buttonsToolBar.query('button');
                	me.doAccessControlValidation(grid,me.getTNS_MANAGE_CEREMONY_PRIVILEGES());
                	var associatedAcadLocationIds = new Array();
                	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
            		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, me.getTNS_MANAGE_CEREMONY_PRIVILEGES());
                	Ext.each(permissionList, function(privilege) {
                		if (privilege === 'MOREACTIONS') {
                    		var button = buttonsToolBar.query('#spBtnMoreActions')[0];
                    		if(!isNullOrEmpty(button)){
                    			button.setVisible(true);
                    		}  
                    	}
                	});
                },
                selectionchange: function(column, selected,eOpts ){
                    var grid = column.view.up('grid');
                    if(selected.length){
                        if(selected.length == 1){
                        	grid.down('#btnEdit').setDisabled(false);
                        	grid.down('#btnView').setDisabled(false);
                        }else{
                        	grid.down('#btnEdit').setDisabled(true);
                        	grid.down('#btnView').setDisabled(true);
                        }
                        grid.down('#btnDelete').setDisabled(false);
                        
                    }else{
                    	grid.down('#btnEdit').setDisabled(true);
                    	grid.down('#btnView').setDisabled(true);
                    	grid.down('#btnDelete').setDisabled(true);
                    }
                },
                cellclick:function(cmp, td, cellIndex, record, tr, rowIndex, e, eOpts ){
                	var me = this,structure,tabName,getcontroller,getTab,contentpanel,
                	 columnName = cmp.ownerCt.columnManager.columns[cellIndex].dataIndex,
                	 manageCeremonyGrid= me.getManageCeremonyGrid(),
                	 selectedRec=manageCeremonyGrid.getSelectionModel().getSelection()[0];
                	if(columnName == "mappedStudentCount"){
                		if (e.target.tagName == 'A') {
                			contentpanel = me.getContentPanel();
                			structure = Ext.widget('manageCeremonyStudentMappedStructure');
                			tabName = getCommonTranslation('MAPPED_STUDENT_CEREMONY');
                			getcontroller=me.getController('menu.CoreERPNavigationController');
                			getTab=getcontroller.getTab(tabName);
                			if(getTab!=null){
                				contentpanel.remove(getTab, true);
                			}
                			structure.down('grid').ceremonyRec=selectedRec;
                			openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_NINE);
                			
                		}
                	}
                }
            },
            'manageCeremonyGrid button[itemId=btnAdd]': {
                click: function(btn){
                	this.addNewCeremonyStructure('ADD')
                }
            },
        	'manageCeremonyGrid button[itemId=btnView]':{
        		//click: this.viewCeremonyRecord
        		click: function(btn){
                	this.viewCeremonyRecord('VIEW')
                }
        	},
        	'manageCeremonyGrid menuitem[itemId=btnApplyTo]':{
        		click : this.getApplyToTab
        	},
        	'manageCeremonyGrid button[itemId=btnEdit]':{
        		click:function(btn){         			
        			this.editCeremonyRecord('EDIT')
        		}
        	},
            'manageCeremonyFilter':{
            	afterrender: function(form) {
            		var academiLoc = form.down('#academyLocationItemId');
            		academiLoc.getStore().load(function(){
            			academiLoc.select(academiLoc.getStore().collect(academiLoc.valueField));
            		})
                }
            },
            'manageCeremonyFilter button[itemId=resetBtnItemId]': {
                click: function(cmp){
                	var me = this,
                	form = me.getManageCeremonyFilter(),
                	academiLoc = form.down('#academyLocationItemId');
                	form.getForm().reset();
                	academiLoc.getStore().load(function(){
            			academiLoc.select(academiLoc.getStore().collect(academiLoc.valueField));
            		})
                }
            },
            'manageCeremonyFilter button[itemId=searchBtnItemID]': {
                click: function(cmp){
                	var me = this,arr=[],
                	form = me.getManageCeremonyFilter(),
                	grid = me.getManageCeremonyGrid(),
                	formVal = form.getForm().getValues();
                	if(formVal.academyLocationItemId && formVal.academyLocationItemId.length > 0){
						try{
							var academyLocation = Ext.Array.pluck(Ext.Array.pluck(formVal.academyLocationItemId, 'data'), 'id').join();
							/*formVal.academyLocationItemId.forEach(function(rec){
							      if(rec && rec.data){
							    	  arr.push(rec.data.id)
							    }
							});
							var academyLocation = arr.join();*/
						} catch(e) {
							var academyLocation = formVal.academyLocationItemId.join();
						}
					}
                	if(formVal.programGroupId && formVal.programGroupId.length > 0){
						try{
							var programGroupVal = Ext.Array.pluck(Ext.Array.pluck(formVal.programGroupId, 'data'), 'id').join();
						} catch(e) {
							var programGroupVal = formVal.programGroupId.join();
						}
					}
                	grid.getStore().getProxy().extraParams = {
                		academyLocationIds:academyLocation,
                		date:formVal.ceremonyDate,
                		programGroupIds:programGroupVal,
                		id:formVal.ceremonyIdName,
                		ceremonyWithoutMapping:formVal.CEREMONY_WITHOUT_MAPPING,
					}
                	grid.getStore().load();
                	
                }
            },
            'addNewCeremonyForm':{
            	afterrender:function(com){
            		
            		com.down('#ceremonyTimeFromItemId').setDisabled(true)
            		com.down('#ceremonyTimeToItemId').setDisabled(true)
            		var getcontroller=this.getController('menu.CoreERPNavigationController');
                  	var getAddTab=getcontroller.getTab(getCommonTranslation('ADD_NEW_CEREMONY'));                  	
                    if(getAddTab.title == getCommonTranslation('ADD_NEW_CEREMONY')){
                    	var currentUser = this.getCurrentlyLoggedInUser()
                		com.down('#ceremonyCreatedByItemId').setValue(currentUser.value)
                    }
            	}
            },
            'addNewCeremonyForm datefield[itemId=ceremonyDateItemId]':{
            	change:function(com){
            		var form = com.up('#adddNewCeremonyFormId')
            		form.down('#ceremonyTimeFromItemId').setDisabled(false)
            		form.down('#ceremonyTimeToItemId').setDisabled(false)
            		
            		if(!com.getValue()){
            			form.down('#ceremonyTimeFromItemId').setDisabled(true)
                		form.down('#ceremonyTimeToItemId').setDisabled(true)
            		}
            	}
            },
            'addNewCeremonyForm button[itemId=submitBtn]': {
            	//click: this.saveAddNewCeremonyRecord(btn)
            	click:function(btn){
               		this.saveAddNewCeremonyRecord(btn);
               	}
            },
            'addNewCeremonyForm button[itemId=resetBtnToCere]': {
            	click:function(btn){
            		var currentUser = this.getCurrentlyLoggedInUser()
            		var me = this
            		var form = btn.up('#adddNewCeremonyFormId')
            		var createdId = form.down('#ceremonyItemId')
            		var createdName = form.down('#ceremonyNameItemId')
            		var createdNameOl = form.down('#ceremonyNameOtherlanItemId')
            		var CereDate = form.down('#ceremonyDateItemId')
            		var ceremonyTime = form.down('#ceremonyTimeFromItemId')
            		var ceremonyTo = form.down('#ceremonyTimeToItemId')
            		var ceremonyVenue = form.down('#ceremonyVenueItemId')
            		var ceremonyDes = form.down('#ceremonyDesItemId')
            		
            		createdId.reset()
            		createdName.reset()
            		createdNameOl.reset()
            		CereDate.reset()
            		ceremonyTime.reset()
            		ceremonyTo.reset()
            		ceremonyVenue.reset()
            		ceremonyDes.reset()
            		form.getForm().reset();
            		ceremonyTime.setDisabled(true)
            		ceremonyTo.setDisabled(true)
            		//form.down('#ceremonyCreatedByItemId').setValue(currentUser.code + '' + "/" + "" + currentUser.value)
            		
//            		this.editCeremonyRecord
//            		var createdBy = form.down('#ceremonyCreatedByItemId').getValue()
//            		var createdId = form.down('#ceremonyItemId').getValue()
//            		form.down('#ceremonyCreatedByItemId').setValue(createdBy)
//            		form.down('#ceremonyItemId').setValue(createdId)
            		
               	}
            },
            
            'addNewCeremonyForm timefield[itemId=ceremonyTimeFromItemId]': {
            	select: function(cmp) {
            		var form = cmp.up('form');
            		var timeTo = form.down('#ceremonyTimeToItemId');
            		timeTo.reset();
            		timeTo.setMinValue(cmp.getRawValue());
            	}
            },
            
            'addNewCeremonyForm timefield[itemId=ceremonyTimeToItemId]': {
            	select: function(cmp) {
            		var form = cmp.up('form');
            		var timeFrom = form.down('#ceremonyTimeFromItemId');
            		timeFrom.setMaxValue(cmp.getRawValue());
            	}
            },
            'manageceremonymappedprogramgrid':{
            	afterrender:function(cmp){
            		var associatedAcadLocationIds = new Array();
                	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
            		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getTNS_MANAGE_CEREMONY_PRIVILEGES());
            		cmp.down('#saveSequenceButton').setVisible(false);
            		Ext.each(permissionList, function(privilege) {
                		if (privilege === 'SAVE') {
                		//	cmp.down('#saveSequenceButton').setVisible(true);
                    	}
                	});
            	}
            },
            'manageceremonymappedprogramgrid button[itemId=btnDelete]':{
	   			 click:this.deleteCeremonyMappingRecord
	   		 },
	   		 'manageceremonymappedprogramgrid button[itemId=saveSequenceButton]':{
	   			 click:this.saveSequenceStudentMapped
	   		 },
	   		 'manageceremonymappedprogramgrid button[itemId=btnView]':{
	   			 click:this.openViewCeremonyMappingTab
	   		 },'manageceremonymappedprogramgrid button[itemId=btnAdd]':{
	   			 click:this.openAddCeremonyMappingTab
	   		 },
	   		 'ceremoneyaddmappingalgrid customcombobox#academylocationsearchcombo' : {
	   			 select:function(obj, record){
	   				 var academylocationgrid = this.getCeremoneyaddmappingalgrid();
	   				 academylocationgrid.getStore().clearFilter();
	   				 if(!isNullOrEmpty(record)){
	   					 academylocationgrid.getStore().filter({property: 'id',
	   						 value: record[0].get('id'),
	   						 exactMatch: true,
	   						 caseSensitive: true});
	   				 }
	   				var gridDom = academylocationgrid.el ? academylocationgrid.el.dom : null;
	 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ academylocationgrid.getStore().getCount();
	   			 }
	   		 },
	 		 'ceremoneyaddmappingalgrid button#resetBtn':{
	 			  click:function(btn){
	 				 var activeGrid = this.getCeremoneyaddmappingalgrid();
	 				  activeGrid.getSelectionModel().deselectAll();
	 				  activeGrid.getStore().clearFilter();
	 				  if(activeGrid.down('#academylocationsearchcombo')){
	 					 activeGrid.down('#academylocationsearchcombo').reset();
	 				  }
	 			  }
	 		  },
	 		 'ceremoneyaddmappingalgrid button#nextButton':{
	 			  click:function(btn){
	 				 this.academyLocationNextEventCeremony(btn);
	 			  }
	 		  },
	 		 'ceremoneyaddmappingprogramgrid button#nextButton':{
	 			  click:function(btn){
	 				 this.programGroupNextEventCeremony(btn);
	 			  }
	 		  },
	 		 'ceremoneyaddmappingprogramgrid customcombobox#programsearchcombo' : {
	 			 select:function(obj, record){
	 				 var grid = this.getCeremoneyaddmappingprogramgrid();
	 				grid.getStore().clearFilter();
	 				 if(!isNullOrEmpty(record)){
	 					grid.getStore().filter({property: 'longValue',
	 						 value: record[0].get('id'),
	 						 exactMatch: true,
	 						 caseSensitive: true});
	 				 }
	 				var gridDom = grid.el ? grid.el.dom : null;
	 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ grid.getStore().getCount();
	 			 }
	 		 },
	 		 'ceremoneyaddmappingprogramgrid button#resetBtn':{
	 			  click:function(btn){
	 				 var activeGrid = this.getCeremoneyaddmappingprogramgrid();
	 				  activeGrid.getSelectionModel().deselectAll();
	 				  activeGrid.getStore().clearFilter();
	 				  if(activeGrid.down('#programsearchcombo')){
	 					 activeGrid.down('#programsearchcombo').reset();
	 				  }
	 			  }
	 		  },
	 		 'ceremonyaddmappingprogramviewgrid button#nextButton':{
	 			  click:function(btn){
	 				 this.programNextEventCeremony(btn);
	 			  }
	 		  },
	 		 'ceremonyaddmappingprogramviewgrid customcombobox#programsearchcombo' : {
	   			 select:function(obj, record){
	   				 var programGrid = this.getCeremonyaddmappingprogramviewgrid();
	   				programGrid.getStore().clearFilter();
	   				 if(!isNullOrEmpty(record)){
	   					programGrid.getStore().filter({property: 'programId',
	   						 value: record[0].get('id'),
	   						 exactMatch: true,
	   						 caseSensitive: true});
	   				 }
	   				var gridDom = programGrid.el ? programGrid.el.dom : null;
	 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ programGrid.getStore().getCount();
	   			 }
	   		 },
	   		'ceremonyaddmappingprogramviewgrid button#resetBtn':{
	 			  click:function(btn){
	 				 var activeGrid = this.getCeremonyaddmappingprogramviewgrid();
	 				  activeGrid.getSelectionModel().deselectAll();
	 				  activeGrid.getStore().clearFilter();
	 				  if(activeGrid.down('#programsearchcombo')){
	 					 activeGrid.down('#programsearchcombo').reset();
	 				  }
	 			  }
	 		  },
	 		 'ceremonyaddmappingbatchgrid button#nextButton':{
	 			  click:function(btn){
	 				 this.batchNextEventCeremony(btn);
	 			  }
	 		  },
	 		 'ceremonyaddmappingbatchgrid customcombobox#programbatchsearchcombo' : {
	   			 select:function(obj, record){
	   				 var batchgrid = this.getCeremonyaddmappingbatchgrid();
	   				batchgrid.getStore().clearFilter();
	   				 if(!isNullOrEmpty(record)){
	   					batchgrid.getStore().filter({property: 'batchId',
	   						 value: record[0].get('id'),
	   						 exactMatch: true,
	   						 caseSensitive: true});
	   				 }
	   				var gridDom = batchgrid.el ? batchgrid.el.dom : null;
	 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ batchgrid.getStore().getCount();
	   			 }
	   		 },
	   		'ceremonyaddmappingbatchgrid button#resetBtn':{
	 			  click:function(btn){
	 				 var activeGrid = this.getCeremonyaddmappingbatchgrid();
	 				  activeGrid.getSelectionModel().deselectAll();
	 				  activeGrid.getStore().clearFilter();
	 				  if(activeGrid.down('#programbatchsearchcombo')){
	 					 activeGrid.down('#programbatchsearchcombo').reset();
	 				  }
	 			  }
	 		},
	 		'ceremonyaddmappingbatchperiodgrid customcombobox#batchPeriodType' : {
	   			 select:function(obj, record){
	   				 var batchgrid = this.getCeremonyaddmappingbatchperiodgrid();
	   				batchgrid.getStore().clearFilter();
	   				 if(!isNullOrEmpty(record)){
	   					batchgrid.getStore().filter({property: 'periodName',
	   						 value: record[0].get('value'),
	   						 exactMatch: true,
	   						 caseSensitive: true});
	   				 }
	   				var gridDom = batchgrid.el ? batchgrid.el.dom : null;
	 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ batchgrid.getStore().getCount();
	   			 }
	   		 },
			'ceremonyaddmappingbatchperiodgrid button#resetBtn':{
	 			  click:function(btn){
	 				 var activeGrid = this.getCeremonyaddmappingbatchperiodgrid();
	 				  activeGrid.getSelectionModel().deselectAll();
	 				  activeGrid.getStore().clearFilter();
	 				 if(activeGrid.down('#batchPeriodType')){
	 					 activeGrid.down('#batchPeriodType').reset();
	 				  }
	 			  }
	 		  },
	 		 'ceremonyaddmappingbatchgrid button#submitFeeMapping':{
	 			  click:function(btn){
	 				  this.submitCeremonyMapping(btn,'batchType');
	 			  }
	 		  },
	 		 'ceremonyaddmappingbatchperiodgrid button#submitFeeMapping':{
	 			click:function(btn){
	 				  this.submitCeremonyMapping(btn,'periodType');
	 			  }
	 		  },
	 		  'manageCeremonyStudentMappedGrid':{
	 			  afterrender:function(cmp){
	 				  var me = this,
	 				  store = cmp.getStore();
	 				 me.doAccessControlValidation(cmp,me.getTNS_MANAGE_CEREMONY_STUDENT_MAP_PRIVILEGES());
	 				 store.getProxy().extraParams={
	 					ceremonyId: cmp.ceremonyRec.data.id
	 				};
	 				store.load();
	 			  },
	                selectionchange: function(column, selected,eOpts ){
	                    var grid = column.view.up('grid');
	                    if(selected.length){
	                         grid.down('#btnDelete').setDisabled(false);
	                    }else{
	                    	grid.down('#btnDelete').setDisabled(true);
	                    }
	                }
	 		  },
	 		  'manageCeremonyStudentMappedGrid button[itemId=btnDelete]':{
	 			  click:function(btn){
	 				  var me = this,idArray=[],
	 				 manageCeremonyGrid= me.getManageCeremonyGrid(),
	 				  grid = me.getManageCeremonyStudentMappedGrid(),
	 				  selectedRec = grid.getSelectionModel().getSelection();
	 				 selectedRec.forEach(function(rec){
	 					idArray.push(rec.data.id);
	 				 })
	 				 if(idArray.length){
	 					showConfirmMessage(getCommonTranslation('MAPPED_STUDENT_CEREMONY'),getCommonTranslation('REMOVE_STUDENT_CEREMONY_LIST'),
	            				   function(btn, text) {
	            			   if (btn == 'yes') {
	            				   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	 				 Ext.Ajax.request({
		 		            type: 'rest',
		 		            url: SERVERURL.DELETE_GRADUATION_CEREMONY_MAPPED_STUDENTS +'?ids='+idArray.join(),                          
		 		            method: 'DELETE',
		 		            success: function(response,form, action) {
		 		            	grid.getStore().load();
		 		            	Ext.getBody().unmask();
		 		            	manageCeremonyGrid.getStore().load();
		 		            	showSuccessMessage(getCommonTranslation('MAPPED_STUDENT_CEREMONY'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
		 		            }
		 		        });
	            			   }
	            		   });
	 				 }
	 			  }
	 		  },
	 		  'manageCeremonyStudentMappedGrid button[itemId=btnAdd]':{
	 			  click:function(btn){
	 				  var me = this,
	 				  formView =me.getManageCeremonyStudentMappedGrid(),
	 				  mappedStudentWin = Ext.widget('studentMappedCeremonyWin');
	 				  mappedStudentWin.show();
	 				  mappedStudentWin.down('#studentId').getStore().getProxy().extraParams={
	 					  ceremonyId: formView.ceremonyRec.data.id
	 				};
	 				  
	 			  }
	 		  },
	 		  'studentMappedCeremonyWin button[itemId=closeBtn]':{
	 			  click:function(btn){
	 				  btn.up('window').close();
	 			  }
	 		  },
	 		  'studentMappedCeremonyWin button[itemId=submitBtn]':{
	 			  click:function(btn){
	 				  btn.setDisabled(true);
	 				  var me = this,
	 				  form = btn.up('form'),
	 				 manageCeremonyGrid= me.getManageCeremonyGrid(),
	 				  studentId = form.down('#studentId'),
	 				  grid =me.getManageCeremonyStudentMappedGrid(),
	 				  rec = studentId.lastSelection[0],
	 				  formView =me.getManageCeremonyStudentMappedGrid();
	 				  var params={
	 						  student:{
	 							  id:rec.data.id
	 						  },
	 						  ceremony:{
	 							  id:grid.ceremonyRec.data.id
	 						  },
	 						  admission:{
	 							  id:rec.data.admissionId
	 						  },
	 						  programBatchPeriodConfiguration:{
	 							  id:rec.data.programBatchPeriodConfigurationId
	 						  }
	 				  }
	 				  params = Ext.encode(params);
	 				  me.applyWindowMask();
	 				  Ext.Ajax.request({
	 					  type: 'rest',
	 					  url: SERVERURL.SAVE_GRADUATION_CEREMONY_MAPPED_STUDENTS,                          
	 					  method: 'POST',
	 					  jsonData:params,
	 					  success: function(response,form, action) {
	 						  grid.getStore().load();
	 						 manageCeremonyGrid.getStore().load();
	 						  btn.up('window').close();
	 						  me.hideWindowMask();
	 						  showSuccessMessage(getCommonTranslation('MAP_STUDENT'), getCommonTranslation('SUCCESS')); 
	 					  },
	 					  failure: function(form, action) {
	 						                                       btn.setDisabled(false);
	 						                                }
	 				  });
	 				  
	 			  }
	 		  }
        })
    },
    addNewCeremonyStructure: function(isView){
      	var contentpanel = this.getContentPanel();
      	var $this = this;
      	var addNewCeremonyStructure = Ext.widget('addNewCeremonyStructure'); 
      	var tabName 
      	//= getCommonTranslation('ADD_NEW_CEREMONY');
      	var adddNewCeremonyForm = addNewCeremonyStructure.down('#adddNewCeremonyFormId')
      	
      	if (isView == 'ADD') {      		
      		adddNewCeremonyForm.setTitle(getCommonTranslation('ADD_NEW_CEREMONY_DETAILS'));      		
            tabName = getCommonTranslation('ADD_NEW_CEREMONY');
        }
      	else if (isView == 'VIEW') {
      		adddNewCeremonyForm.setTitle(getCommonTranslation('VIEW_CEREMONY'));
            tabName = getCommonTranslation('VIEW_CEREMONY')
            
        } else if (isView== 'EDIT') {
        	adddNewCeremonyForm.setTitle(getCommonTranslation('EDIT_CEREMONY'));
            tabName = getCommonTranslation('EDIT_CEREMONY')
        } 
      	
      	var getcontroller=this.getController('menu.CoreERPNavigationController');
      	var getAddTab=getcontroller.getTab(getCommonTranslation('ADD_NEW_CEREMONY'));
      	var getEditTab = getcontroller.getTab(getCommonTranslation('EDIT_CEREMONY'));
        var getViewTab = getcontroller.getTab(getCommonTranslation('VIEW_CEREMONY'));
      	if(getAddTab!=null){
      		contentpanel.remove(getAddTab, true);
      	}
      	if (getEditTab != null) {
            contentPanel.remove(getEditTab, true);
        }
        if (getViewTab != null) {
            contentPanel.remove(getViewTab, true);
        }
      	openTab(contentpanel, tabName, addNewCeremonyStructure,CONSTANTS.MENU_COLOR_FIVE); 
      

      	Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.PATH_FIND_WHETHER_MANUALID_CHECK,                          
            method: 'GET',
            params: {
                idColumn: 'ceremonyId'
            },
            success: function(response,form, action) {
                if(!isNullOrEmpty(response.responseText)){
                    var responseObject =  Ext.JSON.decode(response.responseText);
                    if(!Ext.isEmpty(responseObject)){
                        var flagId = adddNewCeremonyForm.down('#ceremonyItemId');
                        if(responseObject){
                            flagId.setReadOnly(false)
                            $this.setAllowBlank(flagId,false);  
                            $this.setFieldPlaceHolder(flagId,'');
                        }else{
                            flagId.setReadOnly(true);
                            $this.setAllowBlank(flagId,true);
                            $this.setFieldPlaceHolder(flagId,getCommonTranslation('ID_AUTOGENERATE'));
                        }
                    }
                }
            }
        });
      	var form = this.getAddNewCeremonyForm();
      	var effectivePassoutDate = form.down('#effectivePassoutDate'); 
    	var approvalDate = form.down('#approvalDate');  
      	Ext.Ajax.request({
      	    type: 'rest',
      	    url: SERVERURL.COMMON_FORM_FIELD_INFO,
      	    params: {
      	        screenName: 'addnewceremonyform',  // Changed to reflect the screen name for the new form
      	        academyLocationId: this.getCurrentAcademyLocation(),
      	        languageCode: 'en'
      	    },
      	    method: 'GET',
      	  success: function(res, action) {
      	    var response = Ext.decode(res.responseText);
      	    if (Object.keys(response).length > 0) {
      	        var records = response.AddNewCeremonyForm;
      	        for (var i = 0; i < records.length; i++) {
      	            var record = records[i];

      	            if (record.isVisible && record.formFieldName === 'effectivePassoutDate') {
      	            	effectivePassoutDate.setVisible(true);
      	                 
      	            }
      	            if(record.isVisible && record.formFieldName === 'approvalDate'){
      	            	approvalDate.setVisible(true); 
      	            }
      	        }
      	    }
      	}
      	});


      	
    },
    getApplyToTab : function(){
   		var grid = this.getManageCeremonyGrid();
   		this.resetPageSetting(grid.getStore());
		grid.getStore().load();
   		if (grid.getSelectionModel().getCount() > 0) {
   		if(grid.getSelectionModel().getCount() == 1) {
			var record = grid.getSelectionModel().getSelection();
   			var contentpanel = this.getContentPanel();
   			var structure = Ext.widget('manageceremonymappedprogramgridstructure');
   			var tabName = getCommonTranslation('APPLY_TO');
   			var getcontroller=this.getController('menu.CoreERPNavigationController');
   			var getTab=getcontroller.getTab(tabName);
   			if(getTab!=null){
   				contentpanel.remove(getTab, true);
   			}
   			
   			var applyToGrid = structure.query('manageceremonymappedprogramgrid')[0];
			var manageCeremonyApplyToGridStore = applyToGrid.getStore();
			if(!isNullOrEmpty(record)){
				structure.config.ceremonyGridRecord = record[0];
				manageCeremonyApplyToGridStore.getProxy().extraParams={
					ceremonyId: record[0].get('id')
				};
			}
			//manageCeremonyApplyToGridStore.sorters.clear();
			//manageCeremonyApplyToGridStore.removeAll();
			manageCeremonyApplyToGridStore.load();
			
   			openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_SEVEN);
   		} else {
			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
		}	
   		}else{
   			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
   		}
   	},
    deleteCeremonyMappingRecord: function(){
    	var $this=this;
    	var grid = $this.getManageceremonymappedprogramgrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		showConfirmMessage(getCommonTranslation('CEREMONY'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
    			if (btn == 'yes') {
    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    				var records = grid.getSelectionModel().getSelection();
    				var id = records[0].get("id");
    				Ext.Ajax.request({
    					method : "DELETE",
    					type : 'rest',
    					url : SERVERURL.CEREMONY_MAPPING_DELETE+'?id='+ id,
    					headers : {
    						'Content-Type' : 'application/json'
    					},
    					success : function(form,action) {
    						Ext.getBody().unmask();
    						if(Ext.decode(form.responseText) == 0) {
    							showWarningMessage(getCommonTranslation('CEREMONY'), getCommonTranslation('DEPENDENCY_EXIST_MSG'));
    						}else {
    							$this.resetGridSetting(grid);
    				        	$this.resetPageSetting(grid.getStore());
    							grid.getStore().load();
    							showSuccessMessage(getCommonTranslation('CEREMONY'), getCommonTranslation('CEREMONY_MAPPING_DELETED_SUCCESSFULLY'));
    						}
    					}
    				});
    			}
    		});
    	}else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    openAddCeremonyMappingTab: function(){
		var contentpanel = this.getContentPanel();
		var ceremonymappingtabstructure = Ext.widget('manageceremonyaddmappingtab'); // ManageCeremonyAddMappingTab
		var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
	
		var getcontroller=this.getController('menu.CoreERPNavigationController');
		var getTab=getcontroller.getTab(tabName);
		if(getTab!=null){
			contentpanel.remove(getTab, true);
		}
		openTab(contentpanel, tabName, ceremonymappingtabstructure,CONSTANTS.MENU_COLOR_NINE);
		var ceremonyaddmappingstructure = this.getCeremoneyaddmappingstructure();
		var manageceremonymappedprogramgridstructure = this.getManageceremonymappedprogramgridstructure();
		var academylocationgrid = this.getCeremoneyaddmappingalgrid();
		academylocationgrid.getStore().clearFilter();
		academylocationgrid.getStore().load();
		this.getAdjustmentprogresstracker().setVisible(true);
	
		this.resetProgressTracker();
		var adjustmentprogresstracker = ceremonymappingtabstructure.down("#adjustmentprogresstracker");
		var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
		progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
		progresstracker1.textEl.addCls("inProgressCss-progress-text");
		progresstracker1.updateText("Step 1 In Progress");
		var recordsCommitteeGrid = manageceremonymappedprogramgridstructure.config.ceremonyGridRecord;
		if(!isNullOrEmpty(recordsCommitteeGrid)){
			ceremonymappingtabstructure.down("#lblCeremony").setValue(recordsCommitteeGrid.get('ceremonyName'));
			ceremonymappingtabstructure.down('#ceremonyMappingName').setValue(recordsCommitteeGrid.get('ceremonyName'));
			ceremonymappingtabstructure.down('#ceremonyMappingId').setValue(recordsCommitteeGrid.get('id'));
		}
	},
	resetProgressTracker : function(){
    	var structure = this.getManageceremonyaddmappingtab();
    	var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");
    	var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
    	var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
    	progresstracker1.reset();
    	progresstracker1.updateText('');
    	progresstracker2.reset();
    	progresstracker2.updateText('');
    },
    academyLocationNextEventCeremony:function(btn){
		var academylocationgrid = this.getCeremoneyaddmappingalgrid();
    	var selectionModel = academylocationgrid.getSelectionModel().getSelection();
    	var academyLocationIdsArr = [];
    	selectionModel.forEach(function(obj){
    		academyLocationIdsArr.push(obj.get('id'));
    	});
    	if(academyLocationIdsArr.length > 0){
	    	var ceremoneyaddmappingstructure = this.getCeremoneyaddmappingstructure();// ManageCeremonyMappedProgramGridStructure
	    	var manageceremonymappedprogramgridstructure = this.getManageceremonymappedprogramgridstructure();
	    	var manageceremonyaddmappingtab = this.getManageceremonyaddmappingtab();
	    	var programcontainer = ceremoneyaddmappingstructure.down('#programcontainer');
	    	programcontainer.setDisabled(false);
	    	ceremoneyaddmappingstructure.setActiveTab(programcontainer);
	    	var alProgramGrid = this.getCeremoneyaddmappingprogramgrid();
	    	var alProgramSearchCombo = alProgramGrid.down('#programsearchcombo');
	    	alProgramSearchCombo.reset();
	    	alProgramSearchCombo.getStore().getProxy().extraParams= {
	    		academyLocationIds: academyLocationIdsArr.join()
	    	};
	    	//alProgramSearchCombo.getStore().load();
	    	var alProgramGridStore = alProgramGrid.getStore();
	    	alProgramGridStore.getProxy().extraParams= {
	    		academyLocationIds: academyLocationIdsArr.join()
	    	};
	    	alProgramGridStore.clearFilter();
	    	alProgramGridStore.load();
	    	this.setProgressTracker(1);
	    	var recordsCommitteeGrid = manageceremonymappedprogramgridstructure.config.ceremonyGridRecord;
			if(!isNullOrEmpty(recordsCommitteeGrid)){
				manageceremonyaddmappingtab.down("#lblCeremonyProgramTab").setValue(recordsCommitteeGrid.get('ceremonyName'));
				manageceremonyaddmappingtab.down('#ceremonyMappingName').setValue(recordsCommitteeGrid.get('ceremonyName'));
				manageceremonyaddmappingtab.down('#ceremonyMappingId').setValue(recordsCommitteeGrid.get('id'));
			}
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    programGroupNextEventCeremony:function(btn){
    	var ceremoneyaddmappingstructure = this.getCeremoneyaddmappingstructure();//CeremoneyAddMappingStructure
    	var me=this,alprogramgroupgrid =btn.up('grid'),
    	 selectionModel = alprogramgroupgrid.getSelectionModel().getSelection()
    	 alprogramgridIdsArr = [],
    	 programIdsArr = [];
    	selectionModel.forEach(function(obj){
    		alprogramgridIdsArr.push(obj.get('secondId'));
    		programIdsArr.push(obj.get('longValue'));
    	});
    	
    	if(selectionModel.length > 0){
    		var manageceremonymappedprogramgridstructure = this.getManageceremonymappedprogramgridstructure();
    		var manageceremonyaddmappingtab = this.getManageceremonyaddmappingtab();
	    	programcontainer = ceremoneyaddmappingstructure.down('#programcontainer2');
	    	programcontainer.setDisabled(false);
	    	ceremoneyaddmappingstructure.setActiveTab(programcontainer);
	    	var alprogramgrid = this.getCeremonyaddmappingprogramviewgrid(); 
	    	var alprogramgridCombo = alprogramgrid.down('#programsearchcombo');
	    	alprogramgridCombo.getStore().getProxy().extraParams= {
	    		academyLocationIds: alprogramgridIdsArr.join(),
	    		//programGroupId:programIdsArr.join()
	    	};
	    	
	    	var alprogramgridStore = alprogramgrid.getStore();
	    	alprogramgridStore.getProxy().extraParams= {
	    		academyLocationIds: alprogramgridIdsArr.join(),
	    		programGroupId:programIdsArr.join()
	    	};
			alprogramgridStore.clearFilter();
			alprogramgridStore.load();
			var recordsCommitteeGrid = manageceremonymappedprogramgridstructure.config.ceremonyGridRecord;
			if(!isNullOrEmpty(recordsCommitteeGrid)){
				manageceremonyaddmappingtab.down("#lblCeremonyProgramView").setValue(recordsCommitteeGrid.get('ceremonyName'));
				manageceremonyaddmappingtab.down('#ceremonyMappingName').setValue(recordsCommitteeGrid.get('ceremonyName'));
				manageceremonyaddmappingtab.down('#ceremonyMappingId').setValue(recordsCommitteeGrid.get('id'));
			}
	    	this.setProgressTracker(2);
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    
    },
    programNextEventCeremony:function(btn){
    	var ceremoneyaddmappingstructure = this.getCeremoneyaddmappingstructure();
    	var me = this,programcontainer,
    	alprogramgrid =btn.up('grid'),
    	 selectionModel = alprogramgrid.getSelectionModel().getSelection(),
    	 alprogramgridIdsArr = [],
    	 programId=[];
    	selectionModel.forEach(function(obj){
    		alprogramgridIdsArr.push(obj.get('academyLocationId'));
    		programId.push(obj.get('programId'))
    	});
    	
    	if(selectionModel.length > 0){
    		 var manageceremonymappedprogramgridstructure = this.getManageceremonymappedprogramgridstructure();
    		 var manageceremonyaddmappingtab = this.getManageceremonyaddmappingtab();
	    	 programcontainer = ceremoneyaddmappingstructure.down('#programbatchcontainer');
	    	programcontainer.setDisabled(false);
	    	ceremoneyaddmappingstructure.setActiveTab(programcontainer);
	    	var alprogramgrid = this.getCeremonyaddmappingbatchgrid();
	    	var alprogramgridCombo = alprogramgrid.down('#programbatchsearchcombo');
	    	alprogramgridCombo.getStore().getProxy().extraParams= {
		    		academyLocationIds: alprogramgridIdsArr.join(),
		    		programIds:programId.join()
	    		};
	    	
	    	var alprogramgridStore = alprogramgrid.getStore();
	    	var  proxy = alprogramgridStore.getProxy();
			var  newApi =  {read: SERVERURL.FIND_PROGRAM_BATCH_AND_ACADEMY_LOCATION, update: SERVERURL.FIND_PROGRAM_BATCH_AND_ACADEMY_LOCATION };
			Ext.apply(proxy.api,newApi);
			proxy.extraParams= {
					academyLocationIds: alprogramgridIdsArr.join(),
		    		programIds:programId.join(),
	    	};
			alprogramgridStore.clearFilter();
			alprogramgridStore.load();
			var recordsCommitteeGrid = manageceremonymappedprogramgridstructure.config.ceremonyGridRecord;
			if(!isNullOrEmpty(recordsCommitteeGrid)){
				manageceremonyaddmappingtab.down("#ceremonyProgramBatchTab").setValue(recordsCommitteeGrid.get('ceremonyName'));
				manageceremonyaddmappingtab.down('#ceremonyMappingName').setValue(recordsCommitteeGrid.get('ceremonyName'));
				manageceremonyaddmappingtab.down('#ceremonyMappingId').setValue(recordsCommitteeGrid.get('id'));
			}
	    	this.setProgressTracker(3);
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    batchNextEventCeremony:function(btn){
    	var ceremoneyaddmappingstructure = this.getCeremoneyaddmappingstructure();
    	var me = this,programcontainer,
    	alprogramgrid =btn.up('grid'),
    	 selectionModel = alprogramgrid.getSelectionModel().getSelection(),
    	 alprogramgridIdsArr = [],
    	 programId=[],
    	 batchId=[];
    	selectionModel.forEach(function(obj){
    		alprogramgridIdsArr.push(obj.get('academyLocationId'));
    		programId.push(obj.get('programId'));
    		batchId.push(obj.get('batchId'));
    	});
    	
    	if(selectionModel.length > 0){
    		 var manageceremonymappedprogramgridstructure = this.getManageceremonymappedprogramgridstructure();
    		 var manageceremonyaddmappingtab = this.getManageceremonyaddmappingtab();
	    	 programcontainer = ceremoneyaddmappingstructure.down('#programbatchperiodcontainer');
	    	programcontainer.setDisabled(false);
	    	ceremoneyaddmappingstructure.setActiveTab(programcontainer);
	    	
	    	var alprogramgrid = this.getCeremonyaddmappingbatchperiodgrid();
	    	var alprogramgridCombo = alprogramgrid.down('#batchPeriodType');
		  	alprogramgridCombo.getStore().getProxy().extraParams= {
			  		academyLocationIds: alprogramgridIdsArr.join(),
		    		programIds:programId.join(),
		    		batchIds:batchId.join()
		    	};
	    	var alprogramgridStore = alprogramgrid.getStore();
	    	var  proxy = alprogramgridStore.getProxy();
			var  newApi =  {read: SERVERURL.CEREMONY_FIND_ALL_BY_PERIOD_BY_PROGRAM_BATCH_AND_ACADEMY_LOCATION, update: SERVERURL.CEREMONY_FIND_ALL_BY_PERIOD_BY_PROGRAM_BATCH_AND_ACADEMY_LOCATION };
			Ext.apply(proxy.api,newApi);
			proxy.extraParams= {
				academyLocationIds: alprogramgridIdsArr.join(),
	    		programIds:programId.join(),
	    		batchIds:batchId.join()
	    	};
			alprogramgridStore.clearFilter();
			alprogramgridStore.load();
			var recordsCommitteeGrid = manageceremonymappedprogramgridstructure.config.ceremonyGridRecord;
			if(!isNullOrEmpty(recordsCommitteeGrid)){
				manageceremonyaddmappingtab.down("#ceremonyProgramBatchPeriodTab").setValue(recordsCommitteeGrid.get('ceremonyName'));
				manageceremonyaddmappingtab.down('#ceremonyMappingName').setValue(recordsCommitteeGrid.get('ceremonyName'));
				manageceremonyaddmappingtab.down('#ceremonyMappingId').setValue(recordsCommitteeGrid.get('id'));
			}
	    	this.setProgressTracker(4);
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    submitCeremonyMapping:function(btn, type){
		  var $this = this,params=[],
		   submitUrl = SERVERURL.PATH_SAVE_CEREMONY_BATCH_TYPE,
	       batchGrid = $this.getCeremonyaddmappingbatchgrid(),
	       periodTypeGrid = $this.getCeremonyaddmappingbatchperiodgrid(),
	       selectedRecord = batchGrid.getSelectionModel().getSelection(),
	       manageceremonyaddmappingtab = $this.getManageceremonyaddmappingtab(),
	  	   contentPanel = $this.getContentPanel(),
	  	   tabStructure = $this.getCeremoneyaddmappingstructure();
	       getcontroller = $this.getController('menu.CoreERPNavigationController'),
	       applyToGrid = $this.getManageceremonymappedprogramgrid(),
	       ceremonyMappingId = manageceremonyaddmappingtab.down('#ceremonyMappingId').getValue();
		  if(type == "periodType"){
			  selectedRecord = periodTypeGrid.getSelectionModel().getSelection();
			  submitUrl = SERVERURL.PATH_SAVE_CEREMONY_PERIOD_TYPE
		  }
		  if(ceremonyMappingId){
			  ceremonyMappingId = parseInt(ceremonyMappingId);
		  }
		  if(selectedRecord.length>0){
			  if(type == "periodType"){
				  selectedRecord.forEach(function(rec){
  				  params.push({
  					  "programBatchPeriodConfiguration":{
  			              id:rec.get('programBatchPeriodId')
  			          },
  			          "batch":{
  			              id:rec.get('batchId')
  			          },
  			          "ceremony":{
  			              id:ceremonyMappingId
  			          },
  			          "academyLocation" : {
  			              "id":rec.get('academyLocationId')
  			          },
  			          "programGroup" : {
  			              "id":rec.get('programGroupId')
  			          },
  			          "program" : {
  			              "id":rec.get('programId')
  			          }
  			      })
  			  })
			  }else{
				  selectedRecord.forEach(function(rec){
  				  params.push({
      					  "batch":{
      			              id:rec.get('batchId')
      			          },
      			          "ceremony":{
      			              id:ceremonyMappingId
      			          },
      			          "academyLocation" : {
      			              "id":rec.get('academyLocationId')
      			          },
      			          "programGroup" : {
      			              "id":rec.get('programGroupId')
      			          },
      			          "program" : {
      			              "id":rec.get('programId')
      			          }
  			      });
  			  });
			  }
			 
	    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	    		Ext.Ajax.request({
	    			method: "POST",
	    			type: 'rest',
	    			url: submitUrl,
	    			jsonData:Ext.encode(params),
	    			success : function(response, action) {
	    				if(response.responseText == "SUCCESS"){
	    					Ext.getBody().unmask();
	    					var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
		    				var getTab=getcontroller.getTab(tabName);
		    				if(getTab!=null){
		    					contentPanel.remove(getTab, true);
		    				}

		    				var tabNameApplyTo = getCommonTranslation('APPLY_TO');
		    				var getTabApplyTo=getcontroller.getTab(tabNameApplyTo);
		    				if(getTabApplyTo!=null){
		    					contentPanel.remove(getTabApplyTo, true);
		    				}
		    				var ceremonyApplyToGridStore = applyToGrid.getStore();
		    				if(!isNullOrEmpty(ceremonyMappingId)){
		    					ceremonyApplyToGridStore.getProxy().extraParams={
		    						ceremonyId: ceremonyMappingId
		    					};
		    				}
		    				$this.resetGridSetting(applyToGrid);
				        	$this.resetPageSetting(ceremonyApplyToGridStore);
				        	ceremonyApplyToGridStore.load();
				        	var structure = Ext.widget('manageceremonymappedprogramgridstructure');
		    				openTab(contentPanel, tabNameApplyTo, structure,CONSTANTS.MENU_COLOR_NINE);
	    					showSuccessMessage(getCommonTranslation('COMMITTEE'), getCommonTranslation('CEREMONY_MAPPED_SUCCESSFULLY'));
	    				}else{
	    					Ext.getBody().unmask();
	    					var alertWin = $this.getCeremonymappingalertwin();
	          				if(!alertWin){
	          					alertWin = Ext.widget('ceremonymappingalertwin');
	          				}
	          				alertWin.down('#ceremonyAlert').setValue(getCommonTranslation('CEREMONY_ALREDAY_MAPPED_AL_PROGRAM_GROUP_MSG'));
	          				var pnlListMappingFld = alertWin.down('#pnlListMappingItemId');
	          				var htmlData = '';
	          						htmlData = htmlData + '<div style="padding-bottom: 3px;">' +response.responseText + '</div>';
	          					
	          					pnlListMappingFld.html = htmlData;
	          				
	          					var btn = alertWin.down('#ceremonyAlertBtnOk');
	              				btn.on('click', function() {
	              					alertWin.close();
	              				})
	          				alertWin.show();
	    				}
	    				
	    				
	    			}
	    		});
	    	} else {
	    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	    	}
    },
	setProgressTracker : function(progresstracker){
    	var structure = this.getManageceremonyaddmappingtab();
    	var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");

    	var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
    	var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
    	var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");
    	var progresstracker4 = adjustmentprogresstracker.down("#progresstracker4");
    	var progresstracker5 = adjustmentprogresstracker.down("#progresstracker5");

    	if(progresstracker==1){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker1.updateProgress((i * 0.1), '');
    		}
    		progresstracker1.textEl.addCls("custom-progress-text");
    		progresstracker1.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker2.textEl.removeCls("x-progress-text x-progress-text-back");
    		progresstracker2.textEl.addCls("inProgressCss-progress-text");
    		progresstracker2.updateText("Step 2 In Progress");
    		progresstracker1.updateText(getCommonTranslation('STEP_1_COMPLETE'));
    	}
    	if(progresstracker==2){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker2.updateProgress((i * 0.1), '');
    		}
    		progresstracker2.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker2.textEl.addCls("custom-progress-text");
    		progresstracker3.textEl.removeCls("x-progress-text x-progress-text-back");
    		progresstracker3.textEl.addCls("inProgressCss-progress-text");
    		progresstracker3.updateText("Step 3 In Progress");
    		progresstracker2.updateText(getCommonTranslation('STEP_2_COMPLETE'));
    	}
    	if(progresstracker==3){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker3.updateProgress((i * 0.1), '');
    		}
    		progresstracker3.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker3.textEl.addCls("custom-progress-text");
    		progresstracker4.textEl.removeCls("x-progress-text x-progress-text-back");
    		progresstracker4.textEl.addCls("inProgressCss-progress-text");
    		progresstracker4.updateText("Step 4 In Progress");
    		progresstracker3.updateText(getCommonTranslation('STEP_3_COMPLETE'));
    	}
    	if(progresstracker==4){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker4.updateProgress((i * 0.1), '');
    		}
    		progresstracker4.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker4.textEl.addCls("custom-progress-text");
    		progresstracker5.textEl.removeCls("x-progress-text x-progress-text-back");
    		progresstracker5.textEl.addCls("inProgressCss-progress-text");
    		progresstracker5.updateText("Step 5 In Progress");
    		progresstracker4.updateText(getCommonTranslation('STEP_4_COMPLETE'));
    	}
    	if(progresstracker==5){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker5.updateProgress((i * 0.1), '');
    		}
    		progresstracker5.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker5.textEl.addCls("custom-progress-text");
    		progresstracker5.updateText(getCommonTranslation('STEP_5_COMPLETE'));
    	}
    },
    openViewCeremonyMappingTab: function(){
		var $this=this;
		var grid = $this.getManageceremonymappedprogramgrid();
		var gridData = grid.getSelectionModel().getSelection()[0];
		if (grid.getSelectionModel().getCount() > 0) {
			
			var formWindow = $this.getCeremonyapplytoviewwindow();
			if (!formWindow) {
				Ext.widget('ceremonyapplytoviewwindow');
				formWindow = $this.getCeremonyapplytoviewwindow();
				formWindow.down('#ceremonyCodeAL').setValue(gridData.data.ceremony.code);
				formWindow.down('#ceremonyNameAL').setValue(gridData.data.ceremony.value);
				formWindow.down('#academyLocationAL').setValue(gridData.get('academyLocationName'));
				formWindow.down('#programGroupAL').setValue(gridData.get('programGroupName'));
				formWindow.down('#programAL').setValue(gridData.get('programName'));
				formWindow.down('#batchAL').setValue(gridData.get('batchName'));
				formWindow.down('#periodAL').setValue(gridData.get('periodPrintName'));
				
			}
			formWindow.show();
			
		}else {
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
    saveAddNewCeremonyRecord: function(btn){
		var $this = this;
		var contentPanel = $this.getContentPanel();
		var grid = $this.getManageCeremonyGrid();
		var record = grid.getSelectionModel().getSelection();
		var json;
		var submitUrl;
		var isView = '';
		var form = this.getAddNewCeremonyForm();
		json = $this.createJsonForAddCeremony(form);
		submitUrl = SERVERURL.PATH_CEREMONY_CREATE;
		var successMsg;    	
		 var tabName;
		var formData = json;
		var isView = '';
		var ceremonyId = form.getForm().findField('ceremonyPrimaryId').getValue()
		if(!isNullOrEmpty(ceremonyId)) {
			json = $this.createJsonForAddCeremony($this, grid);			
			submitUrl = SERVERURL.PATH_CEREMONY_UPDATE;
			successMsg = getCommonTranslation('CEREMONY_UPDATED_SUCCESSFULLY');    
			 tabName = getCommonTranslation('EDIT_CEREMONY');
			isView = 'EDIT';
		} else {
			json = $this.createJsonForAddCeremony($this);
			submitUrl = SERVERURL.PATH_CEREMONY_CREATE;
			successMsg = getCommonTranslation('CEREMONY_CREATED_SUCCESSFULLY');
		    tabName = getCommonTranslation('ADD_NEW_CEREMONY');
		    isView = 'ADD';
		}
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');		
		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl,
			jsonData : formData,
			method : 'POST',
			success : function(frm, action) {
				Ext.getBody().unmask(); 
				showSuccessMessage(getCommonTranslation('SUCCESS'), successMsg);
				var getcontroller=$this.getController('menu.CoreERPNavigationController');
			   grid.getSelectionModel().deselectAll();
			  var filterForm = $this.getManageCeremonyFilter(),
            	  formVal = filterForm.getForm().getValues();
	           	if(formVal.academyLocationItemId && formVal.academyLocationItemId.length > 0){
						try{
							var academyLocation = Ext.Array.pluck(Ext.Array.pluck(formVal.academyLocationItemId, 'data'), 'id').join();
						} catch(e) {
							var academyLocation = formVal.academyLocationItemId.join();
						}
					}
	           	if(formVal.programGroupId && formVal.programGroupId.length > 0){
						try{
							var programGroupVal = Ext.Array.pluck(Ext.Array.pluck(formVal.programGroupId, 'data'), 'id').join();
						} catch(e) {
							var programGroupVal = formVal.programGroupId.join();
						}
					}
	           	grid.getStore().getProxy().extraParams = {
	           		academyLocationIds:academyLocation,
	           		date:formVal.ceremonyDate,
	           		programGroupIds:programGroupVal,
	           		id:formVal.ceremonyIdName,
	           		ceremonyWithoutMapping:formVal.CEREMONY_WITHOUT_MAPPING,
					}
	           	grid.getStore().load();
					var getTab=getcontroller.getTab(tabName);
					if(getTab!=null){
						contentPanel.remove(getTab, true);
					}
				}
		});	
    },
//  Add/Update Ceremony json
    createJsonForAddCeremony:function(form){
    	var $this = this
    	var form = $this.getAddNewCeremonyForm()
    	var formDatas = form.getValues();
    	var currentUserId = this.getCurrentlyLoggedInUser().id
    	if(formDatas.ceremonyPrimaryId){
    		json = {
        			'id':formDatas.ceremonyPrimaryId,
        			"ceremonyName":formDatas.ceremonyName,
        			"ceremonyNameOtherLanguage": formDatas.ceremonyNameOtherlan, 
        			"date": formDatas.ceremonyDate,
        			"fromTime": formDatas.ceremonyTimeFrom,
        		    "tillTime": formDatas.ceremonyTimeTo,
        		    "createdBy": currentUserId,
        		    "venue": formDatas.ceremonyVenue,
        		    "description": formDatas.ceremonyDes,
        		    "accountingYear":{
        		    	id:formDatas.accountingYear
        		    },
        		    "lastDateOfAbsentia":formDatas.lastDateAbsentia,
        		    "capacity":formDatas.capacity,
        		    "status":formDatas.statusComboItemId,
        		    "effectivePassoutDate":formDatas.effectivePassoutDate,
        		    "approvalDate":formDatas.approvalDate
        	}
    	}
    	else{
    		json = {
    				"ceremonyId":formDatas.ceremonyID,
        			"ceremonyName":formDatas.ceremonyName,
        			"ceremonyNameOtherLanguage": formDatas.ceremonyNameOtherlan, 
        			"date": formDatas.ceremonyDate,
        			"fromTime": formDatas.ceremonyTimeFrom,
        		    "tillTime": formDatas.ceremonyTimeTo,
        		    "createdBy": currentUserId,
        		    "venue": formDatas.ceremonyVenue,
        		    "description": formDatas.ceremonyDes,
        		    "accountingYear":{
        		    	id:formDatas.accountingYear
        		    },
        		    "lastDateOfAbsentia":formDatas.lastDateAbsentia,
        		    "capacity":formDatas.capacity,
        		    "status":formDatas.statusComboItemId,
        		    "effectivePassoutDate":formDatas.effectivePassoutDate,
        		    "approvalDate":formDatas.approvalDate
        	}
    	}
    	
    	return json;
    },
    viewCeremonyRecord: function(isView){
		var $this = this;
		var grid = $this.getManageCeremonyGrid();
		if(grid.getSelectionModel().getCount()>0) {
			$this.addNewCeremonyStructure('VIEW');
			var ceremonyForm = $this.getAddNewCeremonyForm()
			$this.populateCeremonyRecord(grid, ceremonyForm, false);
		} else {
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}	
    },
    editCeremonyRecord:function(isView){
		var $this = this;
		var grid = $this.getManageCeremonyGrid();
		var form = $this.getAddNewCeremonyForm();
		if(grid.getSelectionModel().getCount()>0) {
			$this.addNewCeremonyStructure('EDIT');
			var ceremonyForm = $this.getAddNewCeremonyForm();
			$this.populateCeremonyRecord(grid, ceremonyForm, true);
			ceremonyForm.down('#resetBtnToCere').setVisible(false)

		} else {
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	
    },
	populateCeremonyRecord:function(grid, ceremonyForm, isEditable){
		var $this = this;
		var record = grid.getSelectionModel().getSelection()[0];
		var form=$this.getAddNewCeremonyForm().getForm();;		
		var submitUrl = SERVERURL.PATH_CEREMONY_FIND_BY_ID;
		var currentUserId = this.getCurrentlyLoggedInUser().id
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl+"?id="+record.data.id,
			method : 'GET',
			success : function(resp, action) {
				Ext.getBody().unmask();
				var data = Ext.decode(resp.responseText);
				
				var id = form.findField('ceremonyPrimaryId');
				id.setValue(data.id);
				
				var ceremonyID = form.findField('ceremonyID');
				ceremonyID.setValue(data.ceremonyId);
				ceremonyID.setReadOnly(true)
				
				var ceremonyNameItemId = form.findField('ceremonyName');
				ceremonyNameItemId.setValue(data.ceremonyName);
				
				var ceremonyNameOtherlanItemId = form.findField('ceremonyNameOtherlan');
				ceremonyNameOtherlanItemId.setValue(data.ceremonyNameOtherLanguage);
				
				var ceremonyDateItemId = form.findField('ceremonyDate');
				ceremonyDateItemId.setValue(new Date(data.date));
				
				var currentDate = new Date();
				var formDate = data.date;
				if(formDate<currentDate){					
					ceremonyDateItemId.setMinValue(new Date(data.date));
				}
				ceremonyDateItemId.clearInvalid()
				
				var ceremonyTimeFromItemId = form.findField('ceremonyTimeFrom');
				ceremonyTimeFromItemId.setValue(timeRender(data.fromTime));
				var ceremonyTimeToItemId = form.findField('ceremonyTimeTo');
				ceremonyTimeToItemId.setValue(timeRender(data.tillTime));				
				
				var ceremonyCreatedByItemId = form.findField('ceremonyCreatedBy');
				ceremonyCreatedByItemId.setValue(data.createdBy.value);
				
				var ceremonyVenueItemId = form.findField('ceremonyVenue');
				ceremonyVenueItemId.setValue(data.venue);
				
				var ceremonyDesItemId = form.findField('ceremonyDes');
				ceremonyDesItemId.setValue(data.description);
				form.findField('accountingYear').getStore().load(function(){
					if(data.accountingYear && data.accountingYear.id){
						form.findField('accountingYear').setValue(data.accountingYear.id);
					}
        		})
				
				data.lastDateOfAbsentia && form.findField('lastDateAbsentia').setValue(new Date(data.lastDateOfAbsentia));
				data.effectivePassoutDate && form.findField('effectivePassoutDate').setValue(new Date(data.effectivePassoutDate));
				data.approvalDate && form.findField('approvalDate').setValue(new Date(data.approvalDate));


				form.findField('capacity').setValue(data.capacity);
				form.findField('statusComboItemId').setValue(data.status);
				
				if(!isEditable) {
					$this.getAddNewCeremonyForm().down('#submitBtn').setVisible(false);
					$this.getAddNewCeremonyForm().down('#resetBtnToCere').setVisible(false);
					form.getFields().items.forEach(function(rec){
						rec.setReadOnly(true);
					});
				}
			}
		})
		
	},
	saveSequenceStudentMapped:function(btn){
		var me = this;
		Ext.defer(function(){
			var updatedRecordArry=[],
			grid = btn.up('grid'),
			gridStore= grid.getStore(),
			updatedRec= gridStore.getUpdatedRecords();
			if(updatedRec.length){
				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				Ext.each(updatedRec, function(record) {
					updatedRecordArry.push({
						id:record.data.id,
						sequence:record.data.sequence,
					})
				});
				updatedRecordArry=Ext.encode(updatedRecordArry);
				Ext.Ajax.request({
		            type: 'rest',
		            url: SERVERURL.PATH_SAVE_ACADEMEMY_SEQUENCE,                          
		            method: 'POST',
		            jsonData:updatedRecordArry,
		            success: function(response,form, action) {
		            	gridStore.load();
		            Ext.getBody().unmask()
		            showSuccessMessage(getProgramandcourseTranslation('TERM_SEQUENCE'), getCommonTranslation('SUCCESS'));
		            }
		        });
			}
		},250)
		
	}
    })