/*
 * @author trupti.paoneker
 * 
 * This controller is used for Currency Master related Actions.   
 */
Ext.define('Academia.controller.othermasters.currencymaster.CurrencyMasterController', {
    extend: 'Academia.controller.base.BaseController',

    stores: ['othermasters.currencymaster.CurrencyMasterStore', 'othermasters.currencymaster.CurrencyExchangeRateHistoryStore','othermasters.currencymaster.CurrencyNameStore','othermasters.currencymaster.CurrencyCodeStore',
    	'othermasters.currencymaster.CurrencyRegionCodeStore','othermasters.currencymaster.AssociateInvoiceCurrencyMasterGridStore','othermasters.currencymaster.CurrencyMasterMainGridStore',
    	'othermasters.currencymaster.CurrencyMasterFindALLCurrenciesStore','othermasters.currencymaster.ExchangeRateCurrencyMasterGridStore'],

    views: ['othermasters.currencymaster.CurrencyMaster', 'othermasters.currencymaster.ExchangeRateCurrencyMasterGrid',
            'othermasters.currencymaster.ExchangeRateCurrencyFormSetUpWindow', 'othermasters.currencymaster.CurrencyExchangeRateHistoryGrid','othermasters.currencymaster.AssociateInvoiceReceiptCurrencyMasterTab',
            'othermasters.currencymaster.SetupExchangeRateCurrencyMasterTab','othermasters.currencymaster.AssociateInvoiceCurrencyMasterGrid',
            'othermasters.currencymaster.AssociateInvoiceCurrencyFormSetUpWindow','othermasters.currencymaster.ExchangeRateHistorySetUpWindow','othermasters.currencymaster.CurrencyMasterTabStructure',
            'othermasters.currencymaster.CurrencyMasterListSetupGrid','othermasters.currencymaster.CurrencyMasterFormSetUpWindow'],

    alias: "widget.currencyMastercontroller",

    refs: [{
        ref: 'exchangeratecurrencymasterGrid',
        selector: 'exchangeratecurrencymastergrid'
    }, {
        ref: 'winexchangeratecurrencyformwindow',
        selector: 'exchangeratecurrencyformsetupwindow'
    }, {
        ref: 'currencyMaster',
        selector: 'currencymaster'
    }, {
        ref: 'exchangeratehistoryGrid',
        selector: 'exchangeratehistorygrid'
    }, {
        ref: 'contentPanel',
        selector: 'contentPanel'
    },{
        ref: 'associateinvoicecurrencymasterGrid',
        selector: 'associateinvoicecurrencymastergrid'
    },{
        ref: 'associateinvoicecurrencyformsetupwindow',
        selector: 'associateinvoicecurrencyformsetupwindow'
    },{
        ref: 'exchangeratehistorysetupwindow',
        selector: 'exchangeratehistorysetupwindow'
    },{

    	ref: 'currencymasterformsetupwindow',
        selector: 'currencymasterformsetupwindow'
     },{
    	 ref: 'currencymasterlistsetupgrid',
         selector: 'currencymasterlistsetupgrid'
     },{
        ref: 'currencyexchangeratehistorygrid',
        selector: 'currencyexchangeratehistorygrid'
    }],
    config: {
    	CURRENCY_MASTER_PERMISSIONSTAB: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CURRENCY_MASTER_PRIVILEGES'),
    	EXCHANGE_RATECURRENCY_MASTER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXCHANGE_RATECURRENCY_MASTER_PRIVILEGES'),
    	ASSOCIATEINVOICE_CURRENCY_MASTER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ASSOCIATEINVOICE_CURRENCY_MASTER_PRIVILEGES'),
    	CURRENCY_LIST_GRID_BUTTON_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CURRENCY_LIST_GRID_BUTTON_PRIVILEGES')
    	
    },
    init: function(application) {
        this.control({
            'exchangeratecurrencymastergrid': {
                render: function(component, options) {
                	this.resetPageSetting(component.getStore());
                    component.getStore().load();
                    this.doAccessControlValidation(component, this.getEXCHANGE_RATECURRENCY_MASTER_PERMISSIONS());
                },
                cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
   				 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
				 if(columnName == "exchangeRateHistory"){
					 if(e.target.tagName=='A'){
						 this.getOpenExchangeRateHistoryDetails(grid,record);
					 }
				 }
			 }
            },
            'exchangeratecurrencymastergrid button[itemId=btnAdd]': {
                click: this.addExchangeRateCurrencyMaster
            },
            'exchangeratecurrencymastergrid button[itemId=btnEdit]': {
                click: Ext.bind(this.editExchangeRateCurrencyMaster, this, [false])
            },
            'exchangeratecurrencymastergrid button[itemId=btnView]': {
                click: Ext.bind(this.editExchangeRateCurrencyMaster, this, [true])
            },
            'exchangeratecurrencyformsetupwindow button[itemId=btnSaveExchangeRateCurrencyForm]': {
                click: function(button) {
                	this.saveExchangeRateCurrencyForm(button);	
                }
            },
            'exchangeratecurrencyformsetupwindow button[itemId=btnCancelExchangeRateCurrencyForm]': {
                click: this.cancelExchangeRateCurrencyForm
            },
            'exchangeratecurrencymastergrid #spBtnMoreActions menuitem[itemId=exchangeratehistory]': {
                click: this.exchangerateHistoryMenuClicked
            },
            'exchangeratecurrencyformsetupwindow form[itemId=exchangeRateCurrencyForm] combo[itemId=name]': {
         	   select: function(combo, records, eOpts) {
                    this.loadCurrencyFromCode(combo, records, eOpts);
                }
             },
             'exchangeratecurrencyformsetupwindow form[itemId=exchangeRateCurrencyForm] combo[itemId=toCurrencyName]': {
           	   select: function(combo, records, eOpts) {
                      this.loadCurrencyToCode(combo, records, eOpts);
                  }
               },
             'associateinvoicecurrencymastergrid': {
                 render: function(component, options) {
                	 this.resetPageSetting(component.getStore());
                     component.getStore().load();
                     this.doAccessControlValidation(component, this.getASSOCIATEINVOICE_CURRENCY_MASTER_PERMISSIONS());
                 }
             },
             'associateinvoicecurrencymastergrid button[itemId=btnAdd]': {
                 click: this.addAssociateInvoiceCurrencyMaster
             },
             'associateinvoicecurrencymastergrid button[itemId=btnEdit]': {
                 click: Ext.bind(this.editAssociateInvoiceCurrencyMaster, this, [false])
             },
             'associateinvoicecurrencymastergrid button[itemId=btnView]': {
                 click: Ext.bind(this.editAssociateInvoiceCurrencyMaster, this, [true])
             },
             'associateinvoicecurrencyformsetupwindow button[itemId=btnAddAssoInvoiceHeader]':{
            	 click:this.addAssociateInvoiceHeaderContainer
             },
             'associateinvoicecurrencyformsetupwindow button[itemId=SubmitBtn]': {
            	 click: function(button) {
            		 this.saveAssociateInvoiceCurrencyForm(button);	
            	 }
             },
             'associateinvoicecurrencyformsetupwindow button[itemId=btnCancel]': {
            	 click: this.cancelAssociateInvoiceCurrencyForm
             },
             'currencymaster': {
            	 render: function(structure) {
            		 this.disableCurrencyMasterTabPivileges(structure,this.getCURRENCY_MASTER_PERMISSIONSTAB());
            	 }
             },
             'associateinvoicecurrencyformsetupwindow form[itemId=associateInvoiceCurrencyForm] combo[itemId=invoiceCurrency]': {
           	   select: function(combo, records, eOpts) {
                      this.setAssociateCurrencyFromCode(combo, records, eOpts);
                  }
               },
               'currencymasterlistsetupgrid': {
                   render: function(component, options) {
                  	 this.resetPageSetting(component.getStore());
                       component.getStore().load();
                    this.doAccessControlValidation(component, this.getCURRENCY_LIST_GRID_BUTTON_PERMISSIONS());
                   }
               },
               'currencymasterlistsetupgrid button[itemId=btnAdd]': {
                   click: this.addCurrencyMasterSetupForm
               },
               'currencymasterlistsetupgrid button[itemId=btnEdit]': {
                   click: this.editCurrencyMasterSetUpForm
               },
               'currencymasterformsetupwindow form[itemId=currencyMasterSetupForm] combo[itemId=name]': {
            	   select: function(combo, records, eOpts) {
            		   this.setCurrencyMasterCodeFromCurrency(combo, records, eOpts);
            	   }
               },
               'currencymasterformsetupwindow button[itemId=btnCancelCurrencyMainForm]': {
            	   click: this.cancelCurrencyMainForm
               },
               'currencymasterformsetupwindow button[itemId=btnSaveCurrencyMainForm]': {
              	 click: function(button) {
              		 this.saveCurrencyMasterSetUpForm(button);	
              	 }
               },
               'exchangeratecurrencyformsetupwindow datefield[itemId=applicableFrom]': {
            	   select: function(data) {
            		   var applicableTo = this.getWinexchangeratecurrencyformwindow().down("#applicableTo");
            		   var date = data.getValue();
            		   var future = new Date(date.getFullYear()+1, date.getMonth(), date.getDate());
            		   applicableTo.setValue(future);
            	   }
               }
        });
    },

    loadCurrencyFromCode: function(combo, records, eOpts) {
    	var id = records[0].get('id');
        var currencyCode = this.getWinexchangeratecurrencyformwindow().down("#currencyCode");
        currencyCode.setValue(id);
    },

    loadCurrencyToCode: function(combo, records, eOpts) {
    	var id = records[0].get('id');
        var currencyCode = this.getWinexchangeratecurrencyformwindow().down("#toCurrencyCode");
        currencyCode.setValue(id);
    },
    setAssociateCurrencyFromCode: function(combo, records, eOpts) {
    	var id = records[0].get('id');
        var currencyCode = this.getAssociateinvoicecurrencyformsetupwindow().down("#invoiceCurrencyCode");
        currencyCode.setValue(id);
    },
    /**
     * This is the function to add Exchange rate History tab on main content panel.
     * 
     */

    exchangerateHistoryMenuClicked: function() {
        var me = this;
        var grid = me.getExchangeratecurrencymasterGrid();


        var record = grid.getSelectionModel().getSelection()[0];
       

        if (grid.getSelectionModel().getCount() > 0) {
        	 var id = record.get('id');
        	 var name = record.get('name');
            var contentpanel = me.getContentPanel();
            var exchangehistorygrid = Ext.widget('exchangeratehistorygrid');


            var records = grid.getSelectionModel().getSelection();
            if (records != "" && records != null && records != undefined) {
                var rec = new Academia.model.othermasters.currencymaster.CurrencyExchangeRateHistoryModel(records[0].data);
                if (rec.data.id !== "" && rec.data.id != undefined) {
                    var tabName = name + " - " + getCommonTranslation('CURRENCY_EXCHANGE_RATE_HISTORY');
                    openTab(contentpanel, tabName, exchangehistorygrid,CONSTANTS.MENU_COLOR_TWELVE);
                    var store = exchangehistorygrid.getStore();

                    store.getProxy().extraParams = {
                        currencyId: id
                    };
                    store.load();

                }
            }
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }

    },


    /**
     * This function is used for to show Exchange Currency
     */
    addExchangeRateCurrencyMaster: function() {
    	var winExchangeRateCurrencyFormWindow = Ext.widget('exchangeratecurrencyformsetupwindow');
    	var applicableFrom = winExchangeRateCurrencyFormWindow.down('#applicableFrom');
    	applicableFrom.allowBlank= false;
    	var status = winExchangeRateCurrencyFormWindow.down('#status');
    	status.setValue(true);
    	winExchangeRateCurrencyFormWindow.show();
    },
    editExchangeRateCurrencyMaster: function(isView) {
        var me = this;
        var grid = me.getExchangeratecurrencymasterGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            var record = grid.getSelectionModel().getSelection()[0];
            
            var editUrl = SERVERURL.PATH_CURRENCY_EXCHANGE_RATE_FINDBY;
            Ext.Ajax.request({
                method: "GET",
                type: 'rest',
                url: editUrl,
                params: {
                    id: record.data.id
                },
                success: function(f, action) {
                	var getResponseData = Ext.JSON.decode(f.responseText);
                	
                	 var exchangeRateCurrencyWindow = me.showWindow('exchangeratecurrencyformsetupwindow');
                     var exchangeRateCurrencyForm = exchangeRateCurrencyWindow.down('form');
                     exchangeRateCurrencyForm.loadRecord(record);
                     var hiddenId = exchangeRateCurrencyForm.down('#Exchange_hidden_field');
                     hiddenId.setValue(record.data.id);
                     var fromCurrency = exchangeRateCurrencyForm.down('customcombobox#name');

                     fromCurrency.getStore().load({
 						  callback: function(records, operation, success) {
 							 for(var i in records){
 								 if(getResponseData.fromCurrency.id==records[i].data.id){
 									fromCurrency.setValue(records[i].data.id);
 	 								fromCurrency.setReadOnly(true);
     							}
 							  }
 						  }
 					  });
                     var fromCurrencyCode = exchangeRateCurrencyForm.down('customcombobox#currencyCode');
                     fromCurrencyCode.getStore().load({
						  callback: function(records, operation, success) {
							 for(var i in records){
								 if(getResponseData.fromCurrency.id==records[i].data.id){
									 fromCurrencyCode.setValue(records[i].data.currencyCode);
									 fromCurrencyCode.setReadOnly(true);
    							}
							  }
						  }
					  });
                     
                     var toCurrency = exchangeRateCurrencyForm.down('customcombobox#toCurrencyName');
                     toCurrency.getStore().load({
						  callback: function(records, operation, success) {
							  for(var i in records){
							  if(getResponseData.toCurrency.id==records[i].data.id){
								  toCurrency.setValue(records[i].data.id);
								  toCurrency.setReadOnly(true);
							  }
							  }
						  }
					  });
                     var toCurrencyCode = exchangeRateCurrencyForm.down('customcombobox#toCurrencyCode');
                     toCurrencyCode.getStore().load({
						  callback: function(records, operation, success) {
							  for(var i in records){
							  if(getResponseData.toCurrency.id==records[i].data.id){
								  toCurrencyCode.setValue(records[i].data.currencyCode);
								  toCurrencyCode.setReadOnly(true);
							  }
							  }
						  }
					  });
                     var applicableFrom = exchangeRateCurrencyForm.down('#applicableFrom');
                     var allowblankFalse = '<span class="required" style="color:red"> *</span>';
                     applicableFrom.labelSeparator = '';
                     applicableFrom.setFieldLabel(getCommonTranslation('APPLICABLE_FROM')+allowblankFalse);
                     applicableFrom.setValue(dateRender(getResponseData.applicableFrom));
                     var applicableTill =exchangeRateCurrencyForm.down('datefield#applicableTo');
                     applicableTill.setValue(dateRender(getResponseData.applicableTill));
                     var currencyExchangeRate =exchangeRateCurrencyForm.down('numberfield#currencyExchangeRate');
                     currencyExchangeRate.setValue(getResponseData.exchangeRate);
         	        if (isView) {
         	        	exchangeRateCurrencyWindow.down('#btnSaveExchangeRateCurrencyForm').setVisible(false);
         	            toggleReadOnlyFormItems(exchangeRateCurrencyForm.getForm(), true);
         	        }
                }
            }); 
            
            
           
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },
    
    /**
     * This function is used for to save Exchange Rate Currency Master Details after clicking on save button    
     */
    saveExchangeRateCurrencyForm: function(button) {
        var this$ = this;
        var exchangeRateCurrencyWindow = button.up('window[xtype=exchangeratecurrencyformsetupwindow]');
        var grid = this$.getExchangeratecurrencymasterGrid();
        var exchangeRateCurrencyForm = exchangeRateCurrencyWindow.down('form');
        var formData = exchangeRateCurrencyForm.getValues();
        var submitUrl= null;
        var isUpdate = false;
        
        if(formData.id) {
        	submitUrl = SERVERURL.PATH_CURRENCT_EXCHANGE_RATE_UPDATE, //URL-rest/currency/update
            isUpdate = true;
        	formData.id = formData.id;
        } else {
        	submitUrl = SERVERURL.PATH_CURRENCY_EXCHANGE_RATE_CREATE, //URL-rest/currency/create
            isUpdate = false;
        	 delete formData.id;
        }
       
        var fromCurrency = {
            "id":formData.name
        };
        var toCurrency = {
                "id":formData.toCurrencyName
            };
        
        formData.fromCurrency = fromCurrency;
        formData.toCurrency = toCurrency;
        formData.applicableTill = formData.applicableTo;
        delete formData.currencyExchangeRateId;
        delete formData.name;
        delete formData.currencyCode;
        delete formData.toCurrencyName;
        delete formData.toCurrencyCode;
        delete formData.version;
        delete formData.applicableTo;
       // delete formData.status;
        //formData.regionCode= "IN";
       // formData.id= "";
       // formData.whetherDeleted= false;

        var jsonFormatFormData = Ext.encode(formData);
        this$.applyWindowMask(); 
        Ext.Ajax.request({
            type: 'rest',
            url: submitUrl,
            jsonData: jsonFormatFormData,
            method: 'POST',
            success: function(form, action) {
            	exchangeRateCurrencyWindow.close();
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll();

                if (isUpdate) {
                	showSuccessMessage(getCommonTranslation('CURRENCY_MASTER_DETAILS'), getCommonTranslation('UPDATE_EXCHANGE_CURRENCY_MASTER_MSG')); //Currency updated successfully												
                } else {
                	showSuccessMessage(getCommonTranslation('CURRENCY_MASTER_DETAILS'), getCommonTranslation('ADD_EXCHANGE_CURRENCY_MASTER_MSG')); //Currency added successfully												
                }
                this$.hideWindowMask();
            }, failure: function(form, action) {
            	exchangeRateCurrencyWindow.close();
            	this$.hideWindowMask();
            }

        });
    },

    /**
     * This function is used for to close Exchange Rate currency Details Dialog box after clicking on cancel button   
     */
    cancelExchangeRateCurrencyForm: function() {
        this.getWinexchangeratecurrencyformwindow().close();
    },
    /**
     * This function is used for to show Exchange Currency
     */
    addAssociateInvoiceCurrencyMaster: function() {
        var winAssociateInvoiceCurrencyFormWindow = Ext.widget('associateinvoicecurrencyformsetupwindow');
        winAssociateInvoiceCurrencyFormWindow.show();
    },
    /**
     * This function is used for to show Associate Invoice Currency Master Details Dialog box with values of selected record after clicking on edit button   
     */
    editAssociateInvoiceCurrencyMaster: function(isView) {
        var me = this;
        var grid = me.getAssociateinvoicecurrencymasterGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            var record = grid.getSelectionModel().getSelection()[0];
            
            var editUrl = SERVERURL.PATH_CURRENCY_MASTER_INVOICE_SETTLEMENT_FINDBY;
            Ext.Ajax.request({
                method: "GET",
                type: 'rest',
                url: editUrl,
                params: {
                	invoiceCurrencyId: record.data.id
                },
                success: function(f, action) {
                	var getResponseData = Ext.JSON.decode(f.responseText);
                	var associateInvoiceCurrencyWindow = me.showWindow('associateinvoicecurrencyformsetupwindow');
                	associateInvoiceCurrencyWindow.setHeight(250);
                	var associateInvoiceCurrencyForm = associateInvoiceCurrencyWindow.down('form');
                	var receiptId =  associateInvoiceCurrencyForm.down('#receiptId');
                	var receiptIdArray= [];
                	Ext.Array.each(getResponseData.receiptCurrencies,function(value){
                		receiptIdArray.push(value.id);
                	});
                	receiptId.setValue(receiptIdArray);
                	var invoiceCurrency =  associateInvoiceCurrencyForm.down('#invoiceCurrency');
                	invoiceCurrency.getStore().load({
						  callback: function(records, operation, success) {
									 invoiceCurrency.setValue(getResponseData[0].invoiceCurrency.id);
									 invoiceCurrency.setReadOnly(true);
						  }
					  });
                	var invoiceCurrencyCode =  associateInvoiceCurrencyForm.down('#invoiceCurrencyCode');
                	invoiceCurrencyCode.setValue(getResponseData.invoiceCurrencyCode);
                	var receiptCurrency =  associateInvoiceCurrencyForm.down('#receiptCurrency');
                	invoiceCurrency.setReadOnly(true);
                	receiptCurrency.store.load({
                		callback : function(records, operation, success) {
                			if (success) {
                				for (var i = 0; i < getResponseData.length; i++) {
                				//if(getResponseData[i].receiptCurrency.id==records[i].data.id){
                					//receiptCurrency.setValue(records[i].data.id);
									// invoiceCurrency.setReadOnly(true);
                				var receiptCurrencyArray= [];
                				//var array = record.data.receiptCurrencyNames.split(',');
                				Ext.Array.each(getResponseData,function(value){
                					receiptCurrencyArray.push(value.receiptCurrency.id);
                				})
                				receiptCurrency.setValue(receiptCurrencyArray);
                				//}
                				}
                			}
                		}
                	});
                	 var currencyCode = invoiceCurrencyCode.next();
					 if(!isNullOrEmpty(currencyCode))  {
						 currencyCode.setValue(getResponseData.invoiceCurrencyCode); 
					 }
					 if (isView) {
						 associateInvoiceCurrencyWindow.down('#SubmitBtn').setVisible(false);
						 receiptCurrency.setReadOnly(true);
				        }
                	associateInvoiceCurrencyWindow.down('#id').setValue(record.data.id);
                	associateInvoiceCurrencyWindow.down('#btnAddAssoInvoiceHeader').setVisible(false);

                }
            }); 
            
            
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },
    // ************ After Associate Invoice Currency Header Render for add and delete button*************

    addAssociateInvoiceHeaderContainer: function() {
 	   var this$ = this;
 	   var form = this$.getAssociateinvoicecurrencyformsetupwindow();
 	   var getform = form.down('form').getForm();
 	  var associateInvoicePanel = form.down('#associateInvoiceHeaderPanel');
 	   var panelItem = new Array();
 	   var count = associateInvoicePanel.items.length-1;
 	   panelItem.push({
 		   xtype: 'fieldcontainer',
 		   width: '100%',
 		   layout: {
 			   type: 'hbox'
 		   },
 		   items: [{
   			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox',
				width:256
			},
			items: [{
				xtype: 'customcombobox',
				itemId: 'invoiceCurrency'+count,
				name: 'invoiceCurrency1',
				labelAlign: 'top',
				width:256,
				store: 'othermasters.currencymaster.CurrencyMasterFindALLCurrenciesStore',
				valueField: 'id',
				displayField: 'name',
				forceSelection:true,
				allowBlank: false,
				listeners: {
					 select: function(combo, records, eOpts){
						 var id = records[0].get('id');
						 var currencyCode = combo.next();
						 if(!isNullOrEmpty(currencyCode))  {
							 currencyCode.setValue(id); 
						 } 
					},
					render: function(field) {
						 var allowblankFalse = '<span class="required" style="color:red"> *</span>';
						 field.labelSeparator = '';
						 field.setFieldLabel(getCommonTranslation('INVOICE_CURRENCY')+allowblankFalse);
					}
				}
			},{
				xtype: 'hidden',
				itemId: 'invoiceCurrencyCode'+count,
				name: 'invoiceCurrencyCode1',
			},{
				xtype: 'multiselectcombofield',
				itemId: 'receiptCurrency'+count,
				name: 'receiptCurrency1',
				cls:'receiptHeaderMultiselect',
				labelAlign: 'top',
				width: 536,
				store: 'othermasters.currencymaster.CurrencyMasterFindALLCurrenciesStore',
				valueField: 'id',
				displayField: 'name',
				typeAhead:true,
				forceSelection:true,
				allowBlank: false,
				listeners: {
					render: function(field) {
						 var allowblankFalse = '<span class="required" style="color:red"> *</span>';
						 field.labelSeparator = '';
						 field.setFieldLabel(getCommonTranslation('RECEIPT_CURRENCY')+allowblankFalse);
					}
				}      	  
			},{
				xtype: 'button',
				itemId: 'btnAddAssoInvoiceHeader',
				cls: 'CustomBodyBtnSettings',
				style:{'margin-top':'24px'},
				text: getCommonTranslation('ADDBUTTONTEXT'),
				tooltip: getCommonTranslation('ADD'),
				 listeners:{
					 click:function(obj){
						 var window = obj.up('associateinvoicecurrencyformsetupwindow');
						 var frm = window.down('form');
						 if (getform.isValid()) {
							 frm.down('#SubmitBtn').setDisabled(false);
						 }else{
							 frm.down('#SubmitBtn').setDisabled(true); 
						 }
						 frm.doLayout();
					 }
	 			   }
			}] 
		},{
 			   xtype: 'button',
 			   glyph: ICONGLYPH.DELETEGLYPH,
 			   cls: 'CustomBodyBtnReject',
 			  style:{'margin-top':'24px'},
 			   tooltip: getCommonTranslation('DELETETOOLTIP'),
 			   listeners:{
 				   click:function(obj){
 					   var frm = obj.ownerCt.ownerCt.ownerCt;
 					   var associateInvoicePanel = frm.down('#associateInvoiceHeaderPanel');
 					   var container = obj.up('fieldcontainer');
 					   associateInvoicePanel.remove(container);
 					  if (getform.isValid()) {
 						 frm.down('#SubmitBtn').setDisabled(false);
 					  }else{
 						 frm.down('#SubmitBtn').setDisabled(true); 
 					  }
 					   frm.doLayout();
 				   }
 			   }
 		   }]    
 	   });

 	  
 	   if(associateInvoicePanel.items.length<10){
 		  associateInvoicePanel.add(panelItem);
 		  count  = count+1
 	   }
 	  if (getform.isValid()) {
 		  	form.down('#SubmitBtn').setDisabled(false);
		 }else{
			 form.down('#SubmitBtn').setDisabled(true); 
		 }
 	   form.doLayout();
    },
    /**
     * This function is used for to close associate Invoice currency Details Dialog box after clicking on cancel button   
     */
    cancelAssociateInvoiceCurrencyForm: function() {
        this.getAssociateinvoicecurrencyformsetupwindow().close();
    },
    disableCurrencyMasterTabPivileges: function(structureReference, permissionsMap) {
    	var me = this;
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	Ext.each(permissionList, function(privilege) {
    		if(privilege === 'CURRENCYSETUPTAB'){
    			var tabName=getCommonTranslation('CURRENCY_SETUP');
    			var contentXtype ='currencymastertabstructure';
    			var itemId='currencymastertabstructureItemId';
    			var	newTab = structureReference.add(0,{
    				xtype: contentXtype,
    				closable: false,
    				title: tabName,
    				itemId:itemId
    			});
    			
    		}
    		if (privilege === 'SETUPEXCHANGERATECM') {
    			var tabName=getCommonTranslation('SETUP_EXCHANGE_RATE');
    			var contentXtype ='setupexchangeratecurrencymastertab';
    			var itemId='setupexchangeratecurrencymastertab';
    			var	newTab = structureReference.add(1,{
    				xtype: contentXtype,
    				closable: false,
    				title: tabName,
    				itemId:itemId
    			});

    		}
    		if (privilege === 'ASSOCIATEINVOICECM') {
    			var tabName= getCommonTranslation('ASSOCIATE_INVOICE_RECEIPT_CURRENCY');
    			var contentXtype ='associateinvoicereceiptcurrencymastertab';
    			var itemId='associateinvoicereceiptcurrencymastertab';

    			var	newTab = structureReference.add(3,{
    				xtype: contentXtype,
    				closable: false,
    				title: tabName,
    				itemId:itemId
    			});
    		}   
    		structureReference.setActiveTab(0);
    	});
    	
    	
    },
    //**********Exchange Rate History Detail Grid************//
    getOpenExchangeRateHistoryDetails : function(grid,record){
    	var this$=this;
    	Ext.widget('exchangeratehistorysetupwindow');
    	var	formWindow = this$.getExchangeratehistorysetupwindow();
    	var formCurrencyCode=record.data.fromCurrencyName;
    	var toCurrencyCode=record.data.toCurrencyName;
    	var title = formCurrencyCode+" to "+toCurrencyCode;
    	var tabName = getCommonTranslation('DATE_WISE_EXCHANGE_RATE_HISTORY');
    	var contentpanel = this.getContentPanel();
    	var coursetabstructure = Ext.widget('exchangeratehistorysetupwindow');
    	var getcontroller=this.getController('menu.CoreERPNavigationController');
    	var getTab=getcontroller.getTab(tabName);
    	openTab(contentpanel, tabName, coursetabstructure,CONSTANTS.MENU_COLOR_FIVE);
    	var grid = contentpanel.getActiveTab().down('grid');
    	grid.setTitle(title+" "+getCommonTranslation('DATE_WISE_EXCHANGE_RATE_HISTORY'));
    	var store = grid.getStore();
    	store.getProxy().extraParams={
    		currencyId: record.get('id'),
    	}
    	store.load();
    },
    /**
     * This function is used for to save INVOICE Receipt Currency Master Details after clicking on save button    
     */
    saveAssociateInvoiceCurrencyForm: function(button) {
    	var this$ = this;
    	var associateInvoiceCurrencyWindow = button.up('window[xtype=associateinvoicecurrencyformsetupwindow]');
    	var grid = this$.getAssociateinvoicecurrencymasterGrid();
    	var associateInvoiceCurrencyForm = associateInvoiceCurrencyWindow.down('form');
    	var formData = associateInvoiceCurrencyForm.getValues();
    	var submitUrl= null;
    	var isUpdate = false;

    	if(formData.id) {
    		submitUrl = SERVERURL.PATH_CURRENCY_MASTER_INVOICE_SETTLEMENT_UPDATE, //URL-rest/currency/update
    		isUpdate = true;  
    		var myJsonReceipt = new Array();
    		for (var j = 0; j < formData["receiptCurrency"].length; j++) {
    			if(Ext.isObject(formData["receiptCurrency"][j])){
    				var idInvoiceEditJson = {
							id:formData["invoiceCurrency"]
					}
    				if(!isNullOrEmpty(formData["receiptCurrency"][j].data.id)){
    				var idReceiptEditJson = {
    						id:formData["receiptCurrency"][j].data.id
    				}
    				var recObjsonEdit={
        					"invoiceCurrency": idInvoiceEditJson,
        					"receiptCurrency": idReceiptEditJson,
        			}
    				}
                }else{
                	var idInvoiceEditJson = {
							id:formData["invoiceCurrency"]
					}
                	var rec = associateInvoiceCurrencyForm.down('#receiptCurrency').getStore().findRecord('id', formData["receiptCurrency"][j]).data;
                	if(!isNullOrEmpty(rec.id)){
                		var idReceiptEditJson = {
        						id:rec.id
        				}
                		var recObjsonEdit={
        					"invoiceCurrency": idInvoiceEditJson,
        					"receiptCurrency": idReceiptEditJson,
        			}
                	}	
                }
    			
    			myJsonReceipt.push(recObjsonEdit);
    		}
    		
    		var jsonFormatFormData = Ext.encode(myJsonReceipt);
    	} else {
    		submitUrl = SERVERURL.PATH_CURRENCY_MASTER_INVOICE_SETTLEMENT_CREATE, //URL-rest/currency/create
    		isUpdate = false;
    		var invoiceCurrency = associateInvoiceCurrencyForm.down('#invoiceCurrency');
    		var invoiceCurrencyCode = associateInvoiceCurrencyForm.down('#invoiceCurrencyCode');
    		var receiptCurrency = associateInvoiceCurrencyForm.down('#receiptCurrency');


    		var myJson = new Array();
    		for (var j = 0; j < formData["receiptCurrency"].length; j++) {
    			var idInvoiceJson = {
						id:formData["invoiceCurrency"]
				}
				var idReceiptJson = {
						id:formData["receiptCurrency"][j].data.id
				}
    			var recObjson={
    					"invoiceCurrency": idInvoiceJson,
    					"receiptCurrency": idReceiptJson
    			}
    			myJson.push(recObjson);
    		}
    		//myJson.push(recObjson);


    		if (!isEmpty(associateInvoiceCurrencyWindow.down('#associateInvoiceHeaderPanel').items.items)) {
    			var isArr = isArray(associateInvoiceCurrencyWindow.down('#associateInvoiceHeaderPanel').items.items);
    			if (isArr == true) {
    				for (var i = 0; i < associateInvoiceCurrencyWindow.down('#associateInvoiceHeaderPanel').items.items.length; i++) {
    					var invoiceCurrency1 = associateInvoiceCurrencyForm.down('#invoiceCurrency'+[i]);
    					var invoiceCurrencyCode1 = associateInvoiceCurrencyForm.down('#invoiceCurrencyCode'+[i]);
    					var receiptCurrency1 = associateInvoiceCurrencyForm.down('#receiptCurrency'+[i]);
    					if(receiptCurrency1!=null){
    						for (var j = 0; j < receiptCurrency1.value.length; j++) {
    							if(!isNullOrEmpty(receiptCurrency1.getValue()[j].data.id)){
    								var idInvoiceJson1 = {
    										id:invoiceCurrency1.getValue()
    								}
    								var idReceiptJson1 = {
    										id:receiptCurrency1.getValue()[j].data.id
    								}
    								var recObjson1={
    				    					"invoiceCurrency": idInvoiceJson1,
    				    					"receiptCurrency": idReceiptJson1
    				    			}
    							}
    							myJson.push(recObjson1);	
    						}
    					}
    				}
    			}
    		}
    		var jsonFormatFormData = Ext.encode(myJson);
    	}
    	this$.applyWindowMask(); 
    	Ext.Ajax.request({
    		type: 'rest',
    		url: submitUrl,
    		jsonData: jsonFormatFormData,
    		method: 'POST',
    		success: function(form, action) {
    			associateInvoiceCurrencyWindow.close();
    			grid.getStore().reload();
    			grid.getSelectionModel().deselectAll();

    			if (isUpdate) {
    				showSuccessMessage(getCommonTranslation('ASSOCIATE_BILLING_AND_RECEIPT_CURRENCY'), getCommonTranslation('UPDATE_CURRENCY_ASSOCIATION_MASTER_MSG')); //Currency updated successfully												
    			} else {
    				showSuccessMessage(getCommonTranslation('ASSOCIATE_BILLING_AND_RECEIPT_CURRENCY'), getCommonTranslation('ADD_CURRENCY_ASSOCIATION_MASTER_MSG')); //Currency added successfully												
    			}
    		}, failure: function(form, action) {
    			associateInvoiceCurrencyWindow.close();
    			this$.hideWindowMask();
    		}

    	});
    },
    //*********create json formate**********
    getIdValueJson: function(id, value) {
 	   if (id) return {
 		   id: id,
 		   value: value
 	   };
    },
    /**
     * This function is used for to show Currency Master
     */
    addCurrencyMasterSetupForm: function() {
    	var winCurrencyFormSetupWindow = Ext.widget('currencymasterformsetupwindow');
    	var status = winCurrencyFormSetupWindow.down('#status');
    	status.setValue(true);
    	winCurrencyFormSetupWindow.show();
    },
    setCurrencyMasterCodeFromCurrency: function(combo, records, eOpts) {
    	var id = records[0].get('id');
        var currencyCode = this.getCurrencymasterformsetupwindow().down("#currencyCode");
        currencyCode.setValue(id);
    },
    cancelCurrencyMainForm: function() {
        this.getCurrencymasterformsetupwindow().close();
    },    
    /**
     * This function is used for to save Currency Master Details after clicking on save button    
     */
    saveCurrencyMasterSetUpForm: function(button) {
        var this$ = this;
        var currencyMasterSetupWindow = button.up('window[xtype=currencymasterformsetupwindow]');
        var grid = this$.getCurrencymasterlistsetupgrid();
        var currencyMasterSetupForm = currencyMasterSetupWindow.down('form');
        var formData = currencyMasterSetupForm.getValues();
        var submitUrl= null;
        var isUpdate = false;
        
        if(formData.id) {
        	submitUrl = SERVERURL.CURRENCY_MASTER_UPDATE, //URL-rest/currency/update
            isUpdate = true;            
        } else {
        	submitUrl = SERVERURL.CURRENCY_MASTER_CREATE, //URL-rest/currency/create
            isUpdate = false;
        }
       
        var jsonFormatFormData = Ext.encode(formData);
        this$.applyWindowMask(); 
        Ext.Ajax.request({
            type: 'rest',
            url: submitUrl,
            jsonData: jsonFormatFormData,
            method: 'POST',
            success: function(form, action) {
            	currencyMasterSetupWindow.close();
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll();
                if (isUpdate) {
                	showSuccessMessage(getCommonTranslation('CURRENCY_MASTER_DETAILS'), getCommonTranslation('UPDATE_CURRENCY_MASTER_MSG')); //Currency updated successfully												
                } else {
                	showSuccessMessage(getCommonTranslation('CURRENCY_MASTER_DETAILS'), getCommonTranslation('ADD_CURRENCY_MASTER_MSG')); //Currency added successfully												
                }
                this$.hideWindowMask();
            }, failure: function(form, action) {
            	currencyMasterSetupWindow.close();
            	this$.hideWindowMask();
            }

        });
    },
    editCurrencyMasterSetUpForm: function() {
        var me = this;
        var grid = me.getCurrencymasterlistsetupgrid();
        if (grid.getSelectionModel().getCount() > 0) {
            var record = grid.getSelectionModel().getSelection()[0];
            var currencySetupWindow = me.showWindow('currencymasterformsetupwindow');
            var currencySetupWindowForm = currencySetupWindow.down('form');
            currencySetupWindowForm.loadRecord(record);
            var currencyName = currencySetupWindowForm.down('customcombobox#name');
            currencyName.setReadOnly(true);
            var currencyCode = currencySetupWindowForm.down('customcombobox#currencyCode');
            currencyCode.setReadOnly(true);
            var hiddenId = currencySetupWindowForm.down('#currencyFormSetupHiddenId');
            hiddenId.setValue(record.data.id);
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    }

});
