/*
 * @author trupti.paoneker
 * This controller is used for Service Master related Actions.   
 */
Ext.define('Academia.controller.othermasters.servicemaster.ServiceMasterController', {
    extend: 'Academia.controller.base.BaseController',

    stores: ['othermasters.servicemaster.ServiceMasterStore', 'othermasters.servicemaster.ServiceMappingStore', 
             'othermasters.servicemaster.ServiceComboStore','user.UserAcademyLocationStore','common.ProgramsByAcademyIdLocationId',
             'common.BatchesByProgramId','common.SeatTypesByBatchId','common.StatusComboStore',
             'othermasters.servicemaster.ServiceNameComboStore','othermasters.servicemaster.ServiceMasterMappedProgramGridStore',
             'feeandpayment.AcademyLocationFeeMappingList','common.AcademyLocationByName',
             'feeandpayment.ALProgramList','feeandpayment.ALProgramSearchCombo',
             'feeandpayment.ALProgramBatchList','feeandpayment.ALProgramBatchSearchCombo',
             'feeandpayment.ALProgramBatchSeatTypeList','othermasters.servicemaster.ServiceCoordinatorComboStore','othermasters.servicemaster.ServiceMasterServiceCoordinatorGridStore'],

    views: ['othermasters.servicemaster.ServiceMaster', 'othermasters.servicemaster.ServiceMasterGrid',
            'othermasters.servicemaster.ServiceMasterFormWindow', 'othermasters.servicemaster.ServiceMappingGrid', 
            'othermasters.servicemaster.ServiceMappingFormWindow', 'othermasters.servicemaster.ServiceMappingPanel',
            'othermasters.servicemaster.ServiceMasterALProgramBatchSeatTypeForm',
            'othermasters.servicemaster.ServiceMasterMappedProgramWindow',
            'othermasters.servicemaster.ServiceMasterApplyToTabStructure','othermasters.servicemaster.ServiceMasterApplyToStructure',
            'feeandpayment.adjustment.AdjustmentProgressTracker',
            'othermasters.servicemaster.AddServiceMasterMappingTab',
            'othermasters.servicemaster.ServiceMasterProgramBatchSeatStructure',
            'othermasters.servicemaster.ServiceMasterALMappingGrid',
            'othermasters.servicemaster.ServiceMasterProgramMappingGrid',
            'othermasters.servicemaster.ServiceMasterBatchMappingGrid',
            'othermasters.servicemaster.ServiceMasterSeatTypeMappingGrid',
            'committee.committee.CommitteeMappingAlertWin','othermasters.servicemaster.ServiceMasterServiceCoordinatorWin'],

    alias: "widget.serviceMastercontroller",

    refs: [{
    	ref: 'contentPanel',
    	selector: 'contentPanel'
    },{
        ref: 'servicemasterGrid',
        selector: 'servicemastergrid'
    }, {
        ref: 'winservicemasterformwindow',
        selector: 'servicemasterformwindow'
    }, {
        ref: 'frmservicemasterformwindow',
        selector: 'servicemasterformwindow form[itemId=serviceMasterForm]'
    }, {
        ref: 'serviceMaster',
        selector: 'servicemaster'
    }, {
        ref: 'servicemasterformwindow',
        selector: 'servicemasterformwindow'
    }, {
        ref: 'servicemappingGrid',
        selector: 'servicemappinggrid'
    }, {
        ref: 'winservicemappingformwindow',
        selector: 'servicemappingformwindow'
    }, {
        ref: 'frmservicemappingformwindow',
        selector: 'servicemappingformwindow form[itemId=serviceMappingForm]'
    }, {
        ref: 'servicemappingformwindow',
        selector: 'servicemappingformwindow'
    }, {
        ref: 'servicemappingpanel',
        selector: 'servicemappingpanel'
    }, {
        ref: 'servicemasteralprogrambatchseattypeform',
        selector: 'servicemasteralprogrambatchseattypeform'
    },{
    	ref: 'servicemastermappedprogramwindow',
        selector: 'servicemastermappedprogramwindow'
    },{
    	ref: 'servicemasterapplytotabstructure',
        selector: 'servicemasterapplytotabstructure'
    },{
    	ref: 'servicemasterapplytostructure',
        selector: 'servicemasterapplytostructure'
    },{
    	ref:'adjustmentprogresstracker',
    	selector:'adjustmentprogresstracker'
    },{
    	ref:'addservicemastermappingtab',
    	selector:'addservicemastermappingtab'
    },{
    	ref:'servicemasterprogrambatchseatstructure',
    	selector:'servicemasterprogrambatchseatstructure'
    },{
    	ref:'servicemasteralmappinggrid',
    	selector:'servicemasteralmappinggrid'
    },{
    	ref:'servicemasterprogrammappinggrid',
    	selector:'servicemasterprogrammappinggrid'
    },{
    	ref:'servicemasterbatchmappinggrid',
    	selector:'servicemasterbatchmappinggrid'
    },{
    	ref:'servicemasterseattypemappinggrid',
    	selector:'servicemasterseattypemappinggrid'
    },{
    	ref:'committeemappingalertwin',
    	selector:'committeemappingalertwin'
    },{
    	ref:'servicemasterservicecoordinatorwin',
    	selector:'servicemasterservicecoordinatorwin'
    }],
    config: {
    	SERVICE_MASTER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SERVICE_MASTER_PRIVILEGES')
    },
    init: function(application) {
        this.control({
            'servicemastergrid': {
                render: function(component, options) {
                    //component.getStore().load();
                    this.doAccessControlValidation(component, this.getSERVICE_MASTER_PERMISSIONS());
                    this.disableApplyToPrivileges(component, this.getSERVICE_MASTER_PERMISSIONS());
                },
                cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
    				var $this =this;
    				if(columnName == "serviceLocation"){
    					if(e.target.tagName=='A'){
    						this.openServiceMasterMappedProgramsGridWindow(grid,record);
    					}
    				}
    				if(columnName == "serviceStaff"){
    					if(e.target.tagName=='A'){
    						this.openServiceMasterServiceCoordinatorWin(grid,record);
    					}
    				}
    			}
            },
            
            'servicemastergrid[itemId=serviceMasterGrid] button[itemId=btnAdd]': {
                click: this.addServiceMaster
            },
            'servicemastergrid[itemId=serviceMasterGrid] button[itemId=btnEdit]': {
                click: Ext.bind(
                this.editServiceMaster, this, [false])
            },
            'servicemastergrid[itemId=serviceMasterGrid] button[itemId=btnView]': {
                click: Ext.bind(
                this.editServiceMaster, this, [true])
            },
            'servicemastergrid[itemId=serviceMasterGrid] button[itemId=btnApplyTo]': {
                click: this.openApplyToTabMappingServiceMaster
            },
            'servicemasterformwindow button[itemId=btnSaveServiceMasterForm]': {
                click: this.saveServiceMasterForm
            },
            'servicemasterformwindow button[itemId=btnCancelServiceMasterForm]': {
                click: this.cancelServiceMasterForm
            },
            'servicemappinggrid[itemId=servicemappinggridItemId] button[itemId=btnDelete]': {
                click: this.deleteServiceMapping
            },
            'servicemappinggrid[itemId=servicemappinggridItemId] button[itemId=btnAdd]': {
                click: this.openAddProgramMappingTab
            },
            'servicemappinggrid[itemId=servicemappinggridItemId] button[itemId=btnView]': {
                click: Ext.bind(this.editServiceMapping, this, [true])
            },
            /*'servicemappingformwindow button[itemId=btnSaveServiceMapping]': {
                click: this.saveServiceMappingForm
            },*/
            'servicemappingformwindow button[itemId=btnCancelServiceMapping]': {
                click: this.cancelServiceMappingForm
            },
         /*   'servicemappingpanel acadlocprogbatchseattypecomponent customcombobox#academyCombo': {
                select: function(combo, records) {
                    var criteria = new Object();
                    criteria.academyId = records[0].get("id");
                    criteria.searchable = true;
                }
            },
            'servicemappingpanel acadlocprogbatchseattypecomponent customcombobox#locationCombo': {
                select: function(combo, records) {
                    var criteria = new Object();
                    criteria.academyId = combo.up().down('#academyCombo').value;
                    criteria.locationId = records[0].get("id");
                    criteria.searchable = true;
                    this.reloadGrid(criteria);

                }
            },
            'servicemappingpanel acadlocprogbatchseattypecomponent customcombobox#programCombo': {
                select: function(combo, records) {
                    var criteria = new Object();
                    criteria.academyId = combo.up().down('#academyCombo').value;
                    criteria.locationId = combo.up().down('#locationCombo').value;
                    criteria.programId = records[0].get("id");
                    this.reloadGrid(criteria);

                }
            },
            'servicemappingpanel acadlocprogbatchseattypecomponent customcombobox#batchCombo': {
                select: function(combo, records) {
                    var criteria = new Object();
                    criteria.academyId = combo.up().down('#academyCombo').value;
                    criteria.locationId = combo.up().down('#locationCombo').value;
                    criteria.programId = combo.up().down('#programCombo').value;
                    criteria.batchId = records[0].get("id");
                    this.reloadGrid(criteria);

                }
            },
            'servicemappingpanel acadlocprogbatchseattypecomponent customcombobox#seatTypeCombo': {
                select: function(combo, records) {
                    var criteria = new Object();
                    criteria.academyId = combo.up().down('#academyCombo').value;
                    criteria.locationId = combo.up().down('#locationCombo').value;
                    criteria.programId = combo.up().down('#programCombo').value;
                    criteria.batchId = combo.up().down('#batchCombo').value;
                    criteria.seatTypeId = records[0].get("id");
                    this.reloadGrid(criteria);

                }
            },*/
            /***
             * Dynamic button added to search and reset fields
             */
            'servicemappingpanel acadlocprogbatchseattypecomponent': {
                render: function(form) {
                  var panelItem=new Array();
                  panelItem.push({
   		   		   xtype:'fieldcontainer',
   		   		   width: '100%',
   		   		   layout : 'hbox',
   		   		   items : [{
		   		   			xtype: 'button',
		   					text: getTransportTranslation('SEARCH'),
		   					itemId: 'SearchBtn',
		   					ui: 'CustomBtnSubmit',
		   					scale: CONSTANTS.BUTTONSIZE
		   				},{
		   					xtype: 'button',
		   					text: getTransportTranslation('RESET'),
		   					itemId: 'cancelBtn',	
		   					ui: 'CustomBtnCancel',
		   					scale: CONSTANTS.BUTTONSIZE,
		   					handler: function() {
		   						this.up('form').getForm().reset();
		   					}
   		   		    }]
                  });
                  form.insert(1,panelItem);
                  form.doLayout();
                  
                }
            },
            'servicemappingpanel acadlocprogbatchseattypecomponent button[itemId=SearchBtn]': {
                click: function(obj) {
                	var form=obj.up('form').getForm();
                	var formValues=form.getValues();
                	var grid = this.getServicemasterGrid();
                	if (grid.getSelectionModel().getCount() > 0) {
	                	var records = grid.getSelectionModel().getSelection()[0];
	                	
	                	var criteria = new Object();
	                    criteria.academyId =formValues.academy!=null?formValues.academy.id:null;
	                    criteria.locationId=formValues.location!=null?formValues.location.id:null;
	                    criteria.programId = formValues.program!=null?formValues.program.id:null;
	                    criteria.batchId = formValues.batch!=null?formValues.batch.id:null;
	                    criteria.seatTypeId = formValues.batch!=null?formValues.seatType.id:null;
	                    criteria.masterId = records.data.id;
	                    this.reloadGrid(criteria);
                     }else {
                 		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
                   }   
                }
            },
            'servicemappingpanel acadlocprogbatchseattypecomponent button[itemId=cancelBtn]': {
                click: function(obj) {
                	//this.items.items[0].resetOtherDropdowns(locationCombo);
            		//locationCombo.reset();
                	var form = obj.up('form');
                	obj.up('form').getForm().reset();
                	var locationCombo =form.down('combo[name=location]');
            		var programCombo =form.down('combo[name=program]');
            		var batchCombo =form.down('combo[name=batch]');
            		var seatCombo =form.down('combo[name=seatType]');
            		locationCombo.setDisabled(true);
            		programCombo.setDisabled(true);
            		batchCombo.setDisabled(true);
            		seatCombo.setDisabled(true);
                }
            },
            'servicemasteralprogrambatchseattypeform button[itemId=resetBtn]': {
            	click: this.resetServiceMasterFilter
            },
            'servicemasteralprogrambatchseattypeform customcombobox[itemId=serviceNameCombo]': {
            	select: function(combo, records) {
            		var me = this;
            		var serviceMasterALProgBatchSeatForm = me.getServicemasteralprogrambatchseattypeform();
            		var statusItemId = serviceMasterALProgBatchSeatForm.down('#statusItemId');
            		if(records.length>0){
            			if(records[0].data.active){
            				statusItemId.setValue('ACTIVE');
            			}
            			else{
            				statusItemId.setValue('INACTIVE');
            			}
            		}
            	}
            },
            'servicemasteralprogrambatchseattypeform button[itemId=searchBtn]': {
            	click: this.searchServiceMasterFilter
            },
            'servicemasteralmappinggrid customcombobox#academylocationsearchcombo' : {
            	select:function(obj, record){
            		this.getServicemasteralmappinggrid().getStore().clearFilter();
            		this.getServicemasteralmappinggrid().getStore().filter({property: 'id',
            			value: record[0].get('id'),
            			exactMatch: true,
            			caseSensitive: true});
            	}
            },
            'servicemasteralmappinggrid button#nextButton':{
            	click:function(btn){
            		this.academyLocationNextEventServiceMaster(btn);
            	}
            },
            'servicemasteralmappinggrid button#resetBtn':{
            	click:function(btn){
            		var tabStructure = this.getServicemasterprogrambatchseatstructure();
            		var activeGrid = tabStructure.getActiveTab().down('grid');
            		activeGrid.getSelectionModel().deselectAll();
            		activeGrid.getStore().clearFilter();
            		if(activeGrid.down('customcombobox'))
            			activeGrid.down('customcombobox').reset();
            	}
            },
            'servicemasterprogrammappinggrid customcombobox#programsearchcombo' : {
            	select:function(obj, record){
            		this.getServicemasterprogrammappinggrid().getStore().clearFilter();
            		this.getServicemasterprogrammappinggrid().getStore().filter({property: 'programId',
            			value: record[0].get('id'),
            			exactMatch: true,
            			caseSensitive: true});
            	}
            },
            'servicemasterprogrammappinggrid button#nextButton':{
            	click:function(btn){
            		this.programNextEventServiceMaster(btn);
            	}
            },
            'servicemasterprogrammappinggrid button#resetBtn':{
            	click:function(btn){
            		var tabStructure = this.getServicemasterprogrambatchseatstructure();
            		var activeGrid = tabStructure.getActiveTab().down('grid');
            		activeGrid.getSelectionModel().deselectAll();
            		activeGrid.getStore().clearFilter();
            		if(activeGrid.down('customcombobox'))
            			activeGrid.down('customcombobox').reset();
            	}
            },
            'servicemasterbatchmappinggrid customcombobox#programbatchsearchcombo' : {
            	select:function(obj, record){
            		this.getServicemasterbatchmappinggrid().getStore().clearFilter();
            		this.getServicemasterbatchmappinggrid().getStore().filter({property: 'batchId',
            			value: record[0].get('id'),
            			exactMatch: true,
            			caseSensitive: true});
            	}
            },
            'servicemasterbatchmappinggrid button#nextButton':{
            	click:function(btn){
            		this.batchNextEventServiceMaster(btn);
            	}
            },
            'servicemasterbatchmappinggrid button#resetBtn':{
            	click:function(btn){
            		var tabStructure = this.getServicemasterprogrambatchseatstructure();
            		var activeGrid = tabStructure.getActiveTab().down('grid');
            		activeGrid.getSelectionModel().deselectAll();
            		activeGrid.getStore().clearFilter();
            		if(activeGrid.down('customcombobox'))
            			activeGrid.down('customcombobox').reset();
            	}
            },
            'servicemasterbatchmappinggrid button#submitBatchMapping':{
            	click:function(btn){
            		this.submitBatchMappingServiceMaster();
            	}
            },
            'servicemasterseattypemappinggrid button#resetBtn':{
            	click:function(btn){
            		var tabStructure = this.getServicemasterprogrambatchseatstructure();
            		var activeGrid = tabStructure.getActiveTab().down('grid');
            		activeGrid.getSelectionModel().deselectAll();
            	}
            },
            'servicemasterseattypemappinggrid button#submitSeatTypeMapping':{
            	click:function(btn){
            		this.submitBatchMappingServiceMaster();
            	}
            }
    		
        });
    },

    reloadGrid: function(criteria) {
        var me = this;
        var grid = me.getServicemappingGrid();
        var store = grid.getStore();
        store.getProxy().extraParams=criteria;
        store.load();
        grid.down('pagingtoolbar').moveFirst();
    },

    /** 
     * This function is used for to show Service Master Details Dialog box after clicking on Add button
     */
    addServiceMaster: function() {
        var winservicemasterformwindow = Ext.widget('servicemasterformwindow');
        winservicemasterformwindow.show();
    },


    showServiceMappingForm: function() {
        var servicemappingformwindow = this.getServicemappingformwindow();
        if (isEmpty(servicemappingformwindow)) {
            servicemappingformwindow = Ext.widget('servicemappingformwindow');
        }
        servicemappingformwindow.show();
    },
    
    /**
     * This function is used for to show contact Details Dialog box after clicking on Add button   
     */
   /* addServiceMapping: function() {
        var grid = this.getServicemasterGrid();
        var me = this;
        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection();
            me.showServiceMappingForm();
            if (records != "" && records != null && records != undefined) {}
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_SERVICE')); //Please select a sponsor 							
        }


    },*/

    /**
     * This function is used for to show Service Master Details Dialog box with values of selected record after clicking on edit button
     * 
     */
    editServiceMaster: function(isView) {
        var me = this;
        var grid = me.getServicemasterGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            me.showServiceMasterForm();
            var records = grid.getSelectionModel().getSelection();
            if (records != "" && records != null && records != undefined) {
                var frmservicemasterformwindow = me.getFrmservicemasterformwindow();
                var serviceCoordinator = frmservicemasterformwindow.down('#serviceCoordinatorId');
                var rec = new Academia.model.othermasters.servicemaster.ServiceMasterModel(
                records[0].data);
                Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                frmservicemasterformwindow.loadRecord(rec);
                var coordinatorIds= [];
                var coordinatorRec  = records[0].data.serviceStaff;
		        Ext.each(coordinatorRec,function (coordinatorData){
		        	coordinatorIds.push(coordinatorData.coordinatorId);
		        });
		        serviceCoordinator.getStore().load({
		        	callback:function(records){
		        		serviceCoordinator.setValue(coordinatorIds); 
		        		Ext.getBody().unmask(); 
		        	}
		        });
                if(rec.data.billFaculty=="true"){
					Ext.ComponentQuery.query('radiogroup#billFacultyId')[0].items.items[0].setValue(true);
					Ext.ComponentQuery.query('radiogroup#billFacultyId')[0].items.items[1].setValue(false);
				}else{
					Ext.ComponentQuery.query('radiogroup#billFacultyId')[0].items.items[0].setValue(false);
					Ext.ComponentQuery.query('radiogroup#billFacultyId')[0].items.items[1].setValue(true);
				}
                grid.getStore().reload();
                if (isView) {
                    var winservicemasterformwindow = me.getWinservicemasterformwindow();
                    winservicemasterformwindow.down('#btnSaveServiceMasterForm').setVisible(false);
                    toggleReadOnlyFormItems(
                    frmservicemasterformwindow.getForm(), true);
                }
            }
        } else {
        	showWarningMessage(
            getCommonTranslation('ALERT'),
            getCommonTranslation('PLEASE_SELECT_RECORD')); // Please
            
        }
    },

    /**
     * This function is used for to save Service Master Details after clicking on save button
     * 
     */
    saveServiceMasterForm: function() {
        var this$ = this;
        var winservicemasterformwindow = this$.getWinservicemasterformwindow();
        var grid = this$.getServicemasterGrid();
        var frmservicemasterformwindow = this$.getFrmservicemasterformwindow();
        var filterForm = this$.getServicemasteralprogrambatchseattypeform();
        var serviceNameCombo = filterForm.down('#serviceNameCombo');
        var formData = frmservicemasterformwindow.getValues();
        var submitUrl, isUpdate = false;
        var servicemaster = frmservicemasterformwindow.down('#serviceMaster_hidden_field');
        if (servicemaster.getSubmitValue() == null || servicemaster.getSubmitValue() == "" || servicemaster.getSubmitValue() === undefined) {
            submitUrl = SERVERURL.SERVICE_MASTER_CREATE, // URL-rest/service/create
            isUpdate = false;
        } else {
            submitUrl = SERVERURL.SERVICE_MASTER_UPDATE, // URL-rest/service/update
            isUpdate = true;
        }
        var serviceCoordinatorArr=[];
        Ext.each(formData.serviceCoordinatorName,function (coordinatorData){
        	if(!isNullOrEmpty(coordinatorData.data)){
        		serviceCoordinatorArr.push(coordinatorData.data.id);
        	}else if(!isNullOrEmpty(coordinatorData)){
        		serviceCoordinatorArr.push(coordinatorData);
        	}
        });
		
		delete formData.serviceCoordinatorName;
		formData.coordinatorId = serviceCoordinatorArr;
        var jsonFormatFormData = Ext.encode(formData);
        Ext.Ajax.request({
            type: 'rest',
            url: submitUrl,
            jsonData: jsonFormatFormData,
            method: 'POST',
            success: function(form, action) {
            	
            	if (!isNullOrEmpty(form.responseText) && form.responseText.length > 0) {
            		showWarningMessage(getCommonTranslation('SERVICEMASTER'), getErrorTranslation(form.responseText));
            	}
            	else{
            		winservicemasterformwindow.close();
            		grid.getStore().reload();
            		grid.getSelectionModel().deselectAll();
            		serviceNameCombo.getStore().load();

            		if (isUpdate) {
            			showSuccessMessage(getCommonTranslation('SERVICEMASTER'),getCommonTranslation('UPDATE_SERVICE_MASTER_MSG'));

            		} else {
            			showSuccessMessage(getCommonTranslation('SERVICEMASTER'),getCommonTranslation('ADD_SERVICE_MASTER_MSG')); 
            		}
            	}
            }
        });
    },

    /**
     * This function is used for to close service master Details Dialog box after clicking on cancel button
     * 
     */
    cancelServiceMasterForm: function() {
        this.getWinservicemasterformwindow().close();
    },

    showServiceMasterForm: function() {
        var servicemasterformwindow = this.getServicemasterformwindow();
        if (isEmpty(servicemasterformwindow)) {
            servicemasterformwindow = Ext.widget('servicemasterformwindow');
        }
        servicemasterformwindow.show();
    },



    /**
     * This function is used for to close service master Details Dialog box after clicking on cancel button
     * 
     */
    cancelServiceMappingForm: function() {
        this.getWinservicemappingformwindow().close();
    },


    /**
     * This function is used for to show community Master Details Dialog box with values of selected record after clicking on edit button
     * 
     */
    editServiceMapping: function(isView) {
        var me = this;
        var grid = me.getServicemappingGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            me.showServiceMappingForm();
            var records = grid.getSelectionModel().getSelection();
            if (records != "" && records != null && records != undefined) {
                var frmservicemappingformwindow = me.getFrmservicemappingformwindow();
                var rec = new Academia.model.othermasters.servicemaster.ServiceMappingModel(records[0].data);
                frmservicemappingformwindow.down('#serviceCodeId').setValue(rec.get('serviceCode'));
                frmservicemappingformwindow.down('#serviceNameId').setValue(rec.get('serviceName'));
                frmservicemappingformwindow.down('#academyLocationId').setValue(rec.get('academyLocation'));
                frmservicemappingformwindow.down('#program').setValue(rec.get('programName'));
                frmservicemappingformwindow.down('#batch').setValue(rec.get('batchName'));
                frmservicemappingformwindow.down('#seatType').setValue(rec.get('seatName'));
            }
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /*saveServiceMappingForm: function() {
        var this$ = this;
        var winservicemappingformwindow = this$.getWinservicemappingformwindow();
        var refServiceMappingForm = this$.getFrmservicemappingformwindow();
        var grid = this$.getServicemappingGrid();
        
        var submitUrl = SERVERURL.SERVICE_MAPPING_CREATE;
        var jsonData = refServiceMappingForm.getValues();
        var seatType = new Object();
        seatType.id = refServiceMappingForm.down('nestedJsonCombo#seatTypeCombo').valueModels[0].data.id;
        jsonData.seatType = seatType;
        jsonData.seatTypeId = refServiceMappingForm.down('nestedJsonCombo#seatTypeCombo').valueModels[0].data.seatTypeId;
        var jsonFormatFormData = Ext.encode(jsonData);
        
        var masterGrid = this.getServicemasterGrid();
        var record = masterGrid.getSelectionModel().getSelection()[0];
        var id = record.get('id');
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        Ext.Ajax.request({
            type: 'rest',
            url: submitUrl,
            jsonData: jsonFormatFormData,
            method: 'POST',
            success: function(form, action) {
            	Ext.getBody().unmask();
            	var msg = form.responseText;
            	
            	if(msg == 'SUCCESSFULL'){
                    winservicemappingformwindow.close();
                    grid.getStore().load({
                        params: {
                            masterId: id
                        }

                    });
                    grid.getSelectionModel().deselectAll();
                    showSuccessMessage(getCommonTranslation('SERVICE_MAPPING'), getCommonTranslation('ADD_SERVICE_MAPPING_MSG'));            		
            	}else{
            		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('RECORD_NOT_ENIQUE'));
            	}


            }

        });
    },*/

    deleteServiceMapping: function() {
    	var me = this;
        var grid = this.getServicemappingGrid();
        var grdStore = grid.getStore();
        if (grid.getSelectionModel().getCount() > 0) {
			  showConfirmMessage(getCommonTranslation('DELETE_SERVICE_MAPPING'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
					  function(btn,text) {
				  if (btn == 'yes') {
                        if (grid.getSelectionModel().getCount() > 0) {
                            var records = grid.getSelectionModel().getSelection();
                            for (var count = 0; count < records.length; count++) {
                                var id = "";
                                if (records[count].get("id") != "" && records[count].get("id") != undefined && records[count].get("id") != null) {
                                    id = records[count].get("id");
                                }
                                Ext.Ajax.request({
                                    type: 'rest',
                                    method: 'DELETE',
                                    url: SERVERURL.SERVICE_MAPPING_DELETE + '?id=' + id,		
                                    headers: {
                                        'Content-Type': 'application/json'
                                    },
                                    params: {
                                        id: id
                                    },
                                    success: function(form, action) {
                                        grdStore.reload();
                                        // subGrid.getStore().reload();
                                        me.searchServiceMasterFilter();
                                        showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('DELETE_SERVICE_MAPPING_MSG'));
                                    },
                                    failure: function(form, action) {
                                    	showSuccessMessage(getCommonTranslation('FAILURE'),getCommonTranslation('ERROR_MSG'));//Error occured while performing transaction                                    
                                    }
                                });
                            }
                        }
                    }
            });
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    resetServiceMasterFilter: function(){
    	var $this = this;
    	var filter = $this.getServicemasteralprogrambatchseattypeform();
    	filter.getForm().reset();
    	filter.down("#programCombo").setDisabled(true);
    	filter.down("#batchCombo").setDisabled(true);
    	filter.down("#seatTypeCombo").setDisabled(true);
    },
    disableApplyToPrivileges: function(gridReference,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	var applyToBtn = gridReference.down('#btnApplyTo');
    	if(!isNullOrEmpty(applyToBtn)){
    		applyToBtn.setVisible(false);
    	} 
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'APPLY_TO') {
    			if(!isNullOrEmpty(applyToBtn)){
    				applyToBtn.setVisible(true);
    			}        		
    		}
    	});
    },
    openServiceMasterMappedProgramsGridWindow : function(grid,record){
    	var $this=this;
    	var id = record.get("id");

    	var formWindow = $this.getServicemastermappedprogramwindow();
    	if (!formWindow) {
    		Ext.widget('servicemastermappedprogramwindow');
    		formWindow = $this.getServicemastermappedprogramwindow();
    	}
    	formWindow.show();
    	var grid = formWindow.down('#mappedProgGrid');
    	var store = grid.getStore();
    	store.getProxy().extraParams = {
    		serviceId: id
    	};
    	$this.resetPageSetting(store);
    	store.load();
    },
    openServiceMasterServiceCoordinatorWin:function(){
    	var grid = this.getServicemasterGrid(),
    	record = grid.getSelectionModel().getSelection()[0],
    	id = record.get("id"),
    	servicecoordinatorwin = this.getServicemasterservicecoordinatorwin();
    	if (!servicecoordinatorwin) {
    		servicecoordinatorwin = Ext.widget('servicemasterservicecoordinatorwin',{
    			itemId:'servicecoordinatorwinId'
    		});
    	}
    	servicecoordinatorwin.show();
    	var grid = servicecoordinatorwin.down('grid');
    	grid.down('#totalRecordDisplayField').setVisible(false);
    	grid.header.setVisible(false);
    	grid.store.getProxy().extraParams = {
    		serviceId: id
    	};
    	grid.getStore().load();
    },
    searchServiceMasterFilter: function(){
    	var $this = this;
    	var filterForm = $this.getServicemasteralprogrambatchseattypeform();
    	if(!isNullOrEmpty(filterForm)){
    		var values = filterForm.getValues();
    		var grid = $this.getServicemasterGrid();
    		var programCombo =filterForm.down('#programCombo');
    		var batchCombo =filterForm.down('#batchCombo');
    		var seatTypeCombo =filterForm.down('#seatTypeCombo');
    		var store = grid.getStore();
    		if(values.status == 'ACTIVE'){
    			values.status = true;
    		}
    		else{
    			values.status = false;
    		}
    		store.getProxy().extraParams = {
    			academyLocationId: values.academy_location_id,
    			programId:programCombo.getValue(),
    			batchId:batchCombo.getValue(),
    			seatTypeId:seatTypeCombo.getValue(),
    			status:values.status,
    			serviceId:values.serviceName
    		};
    		$this.resetPageSetting(store);
    		store.load();
    		grid.getSelectionModel().deselectAll();
    	}
    },
    openApplyToTabMappingServiceMaster:function(){
    	var $this=this;
    	var grid = $this.getServicemasterGrid();
    	var gridData = grid.getSelectionModel().getSelection()[0];
    	if (grid.getSelectionModel().getCount() > 0) {
    		if(grid.getSelectionModel().getCount() == 1) {
    			var record = grid.getSelectionModel().getSelection();

    			var tabName = getExaminationTranslation('APPLY_TO');
    			var contentPanel = $this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
    			var structure = Ext.widget('servicemasterapplytotabstructure');
    			/**
    			 * This is to remove tab from content panel and open same tab again
    			 */
    			var getcontroller=$this.getController('menu.CoreERPNavigationController');
    			var getTab=getcontroller.getTab(tabName);
    			if(getTab!=null){
    				contentPanel.remove(getTab, true);
    			}

    			structure.config.serviceMasterGridRecord = record[0];
    			var applyToGrid = structure.query('servicemappinggrid')[0];
    			var applyToGridStore = applyToGrid.getStore();
    			if(!isNullOrEmpty(record)){
    				applyToGridStore.getProxy().extraParams={
    					serviceId: record[0].get('id'),
    					limit :25
    				};
    			}
    			applyToGridStore.sorters.clear();
    			applyToGridStore.removeAll();
    			applyToGridStore.loadPage(1);

    			openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_THIRTEEN);

    		} else {
    			showWarningMessage(getExaminationTranslation('APPLY_TO'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
    		}
    	}else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    openAddProgramMappingTab: function(){
    	var contentpanel = this.getContentPanel();
    	var mappingTabStructure = Ext.widget('addservicemastermappingtab');
    	var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
    	var grid = this.getServicemasterGrid();
    	var getcontroller=this.getController('menu.CoreERPNavigationController');
    	var getTab=getcontroller.getTab(tabName);
    	if(getTab!=null){
    		contentpanel.remove(getTab, true);
    	}
    	openTab(contentpanel, tabName, mappingTabStructure,CONSTANTS.MENU_COLOR_THIRTEEN);
    	var academylocationgrid = this.getServicemasteralmappinggrid();
    	var servicemasterprogrambatchseatstructure = this.getServicemasterprogrambatchseatstructure();
    	academylocationgrid.getStore().clearFilter();
    	academylocationgrid.getStore().load();
    	this.getAdjustmentprogresstracker().setVisible(true);
    	
    	this.resetProgressTracker();
    	var adjustmentprogresstracker = mappingTabStructure.down("#adjustmentprogresstracker");
    	var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
    	progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
    	progresstracker1.textEl.addCls("inProgressCss-progress-text");
    	progresstracker1.updateText("Step 1 In Progress");
  	  
    	var servicemasterapplytotabstructure = this.getServicemasterapplytotabstructure();
    	var serviceMasterGridRecord = servicemasterapplytotabstructure.config.serviceMasterGridRecord;
    	if(!isNullOrEmpty(serviceMasterGridRecord)){
    		servicemasterprogrambatchseatstructure.down("#lblServiceName").setValue(serviceMasterGridRecord.get('serviceName'));
    		mappingTabStructure.down('#serviceMasterMappingName').setValue(serviceMasterGridRecord.get('serviceName'));
    		mappingTabStructure.down('#serviceMasterMappingId').setValue(serviceMasterGridRecord.get('id'));
    	}
    },
    academyLocationNextEventServiceMaster:function(btn){
    	var academylocationgrid = this.getServicemasteralmappinggrid();
    	var selectionModel = academylocationgrid.getSelectionModel().getSelection();
    	var academyLocationIdsArr = [];
    	var grid = this.getServicemasterGrid();
    	selectionModel.forEach(function(obj){
    		academyLocationIdsArr.push(obj.get('id'));
    	});
    	if(academyLocationIdsArr.length > 0){
	    	var servicemasterprogrambatchseatstructure = this.getServicemasterprogrambatchseatstructure();
	    	var programcontainer = servicemasterprogrambatchseatstructure.down('#programcontainer');
	    	programcontainer.setDisabled(false);
	    	servicemasterprogrambatchseatstructure.setActiveTab(programcontainer);
	    	var alProgramGrid = this.getServicemasterprogrammappinggrid();
	    	var alProgramSearchCombo = alProgramGrid.down('#programsearchcombo');
	    	alProgramSearchCombo.getStore().getProxy().extraParams= {
	    		academyLocationIds: academyLocationIdsArr.join()
	    	};
	    	//alProgramSearchCombo.getStore().load();
	    	var alProgramGridStore = alProgramGrid.getStore();
	    	alProgramGridStore.getProxy().extraParams= {
	    		academyLocationIds: academyLocationIdsArr.join()
	    	};
	    	alProgramGridStore.clearFilter();
	    	alProgramGridStore.load();
	    	this.setProgressTracker(1);
	    	
	    	var servicemasterapplytotabstructure = this.getServicemasterapplytotabstructure();
	    	var serviceMasterGridRecord = servicemasterapplytotabstructure.config.serviceMasterGridRecord;
	    	if(!isNullOrEmpty(serviceMasterGridRecord)){
	    		servicemasterprogrambatchseatstructure.down("#lblServiceNameProgramTab").setValue(serviceMasterGridRecord.get('serviceName'));
	    	}
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    programNextEventServiceMaster:function(btn){
    	var alprogramgrid = this.getServicemasterprogrammappinggrid();
    	var grid = this.getServicemasterGrid();
    	var selectionModel = alprogramgrid.getSelectionModel().getSelection();
    	var alprogramgridIdsArr = [];
    	var programIdsArr = [];
    	selectionModel.forEach(function(obj){
    		alprogramgridIdsArr.push(obj.get('academyLocationId'));
    		programIdsArr.push(obj.get('programId'));
    	});
    	
    	if(programIdsArr.length > 0){
	    	var servicemasterprogrambatchseatstructure = this.getServicemasterprogrambatchseatstructure();
	    	var programbatchcontainer = servicemasterprogrambatchseatstructure.down('#programbatchcontainer');
	    	programbatchcontainer.setDisabled(false);
	    	servicemasterprogrambatchseatstructure.setActiveTab(programbatchcontainer);
	    	
	    	var alProgramBatchGrid = this.getServicemasterbatchmappinggrid();
	    	
	    	var alProgramBatchSearchCombo = alProgramBatchGrid.down('#programbatchsearchcombo');
	    	alProgramBatchSearchCombo.getStore().getProxy().extraParams= {
	    		academyLocationIds: alprogramgridIdsArr.join(),
	    		programIds:programIdsArr.join(),
	    		page:1,
                start:0,
                limit:-1
	    	};
	    	//alProgramBatchSearchCombo.getStore().load();
	    	
	    	var alProgramBatchGridStore = alProgramBatchGrid.getStore();
	    	alProgramBatchGridStore.getProxy().extraParams= {
	    		academyLocationIds: alprogramgridIdsArr.join(),
	    		programIds:programIdsArr.join(),
	    		page:1,
                start:0,
                limit:-1
	    	};
	    	alProgramBatchGridStore.clearFilter();
	    	alProgramBatchGridStore.load();
	    	var servicemasterapplytotabstructure = this.getServicemasterapplytotabstructure();
	    	var serviceMasterGridRecord = servicemasterapplytotabstructure.config.serviceMasterGridRecord;
	    	if(!isNullOrEmpty(serviceMasterGridRecord)){
	    		servicemasterprogrambatchseatstructure.down("#lblServiceNameProgramBatchTab").setValue(serviceMasterGridRecord.get('serviceName'));
	    	}
	    	
	    	this.setProgressTracker(2);
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    batchNextEventServiceMaster:function(btn){
    	var alprogrambatchgrid = this.getServicemasterbatchmappinggrid();
    	var grid = this.getServicemasterGrid();
    	var selectionModel = alprogrambatchgrid.getSelectionModel().getSelection();
    	var alprogramgridIdsArr = [];
    	var programIdsArr = [];
    	var batchIdsArr = [];
    	selectionModel.forEach(function(obj){
    		alprogramgridIdsArr.push(obj.get('academyLocationId'));
    		programIdsArr.push(obj.get('programId'));
    		batchIdsArr.push(obj.get('batchId'));
    	});
    	
    	if(batchIdsArr.length > 0){
	    	var servicemasterprogrambatchseatstructure = this.getServicemasterprogrambatchseatstructure();
	    	var programbatchseattypecontainer = servicemasterprogrambatchseatstructure.down('#programbatchseattypecontainer');
	    	programbatchseattypecontainer.setDisabled(false);
	    	servicemasterprogrambatchseatstructure.setActiveTab(programbatchseattypecontainer);
	    	
	    	var alprogrambatchseartypegrid = this.getServicemasterseattypemappinggrid();
	
	    	var alProgramBatchSeatTypeGridStore = alprogrambatchseartypegrid.getStore();
	    	alProgramBatchSeatTypeGridStore.getProxy().extraParams= {
	    		//academyLocationIds: alprogramgridIdsArr.join(),
	    		//programIds:programIdsArr.join(),
	    		batchIds:batchIdsArr.join()
	    	};
	    	alProgramBatchSeatTypeGridStore.clearFilter();
	    	alProgramBatchSeatTypeGridStore.load();
	    	
	    	var servicemasterapplytotabstructure = this.getServicemasterapplytotabstructure();
	    	var serviceMasterGridRecord = servicemasterapplytotabstructure.config.serviceMasterGridRecord;
	    	if(!isNullOrEmpty(serviceMasterGridRecord)){
	    		servicemasterprogrambatchseatstructure.down("#lblServiceNameProgramBatchSeattypeTab").setValue(serviceMasterGridRecord.get('serviceName'));
	    	}
	    	this.setProgressTracker(3);
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    submitBatchMappingServiceMaster:function(){
    	var $this=this;
    	var tabStructure = this.getServicemasterprogrambatchseatstructure();
    	var activeGrid = tabStructure.getActiveTab().down('grid');
    	var selectedRecord = activeGrid.getSelectionModel().getSelection();
    	var addservicemastermappingtab = this.getAddservicemastermappingtab();
    	var applyToGrid = this.getServicemappingGrid();
    	var serviceId = addservicemastermappingtab.down('#serviceMasterMappingId').getValue();
    	var submitJsonArr;
    	var batchIdsArr = [];
    	var batchSeatTypeIdsArr = [];
    	var getcontroller=this.getController('menu.CoreERPNavigationController');
    	var contentpanel = this.getContentPanel();
    	if(selectedRecord.length>0){
    		var submitUrl = SERVERURL.SERVICE_MAPPING_CREATE;
    		if(activeGrid.xtype == 'servicemasterbatchmappinggrid'){
    			selectedRecord.forEach(function(obj){
    				batchIdsArr.push(obj.get('batchId'));
    			});
    			submitJsonArr = {
    					serviceId: serviceId,
    					batchIds: batchIdsArr.join()
    			};

    		} else if(activeGrid.xtype == 'servicemasterseattypemappinggrid'){
    			selectedRecord.forEach(function(obj){
    				batchSeatTypeIdsArr.push(obj.get('programBatchSeatTypeId'));
    			});
    			submitJsonArr = {
    					serviceId: serviceId,
    					programBatchSeatConfigIds: batchSeatTypeIdsArr.join()
    			};
    		}
    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		
    		Ext.Ajax.request({
    			method: "POST",
    			type: 'rest',
    			url: SERVERURL.SERVICE_MAPPING_CHECK_DUPLICATE,
    			jsonData:submitJsonArr,
    			success : function(response, action) {
    				var resp = Ext.decode(response.responseText);
    				if(!isNullOrEmpty(resp) && resp.length>0){
    					var alertWin = $this.getCommitteemappingalertwin();
    					if(!alertWin){
    						alertWin = Ext.widget('committeemappingalertwin');
    					}
    					alertWin.down('#committeeAlert').setValue(getCommonTranslation('SERVICE_IS_ALREADY_MAPPED_AL_PROGRAM_BATCH_SEATTYPE_MSG'));
    					var pnlListMappingFld = alertWin.down('#pnlListMappingItemId');
    					var htmlData = '';
    					if(resp.length>0){
    						resp.forEach(function(obj){
    							var nameStr = obj.academyLocation + ' - ' + obj.programName + ' - ' + obj.batchName + ' - ' + obj.seatName;
    							htmlData = htmlData + '<div style="padding-bottom: 3px;">' + nameStr + '</div>';
    						});

    						pnlListMappingFld.setValue(htmlData);
    					}
    					var btn = alertWin.down('#committeeAlertBtnOk');
    					btn.on('click', function() {
    						alertWin.close();
    						Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    						Ext.Ajax.request({
    							method: "POST",
    							type: 'rest',
    							url: submitUrl,
    							jsonData:submitJsonArr,
    							success : function(response, action) {
    								Ext.getBody().unmask();
    								var data = response.responseText;
    								var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
    								var getTab=getcontroller.getTab(tabName);
    								if(getTab!=null){
    									contentPanel.remove(getTab, true);
    								}

    								//Start code for open Apply To tab again with updated records 
    								var tabNameApplyTo = getExaminationTranslation('APPLY_TO');
    								var getTabApplyTo=getcontroller.getTab(tabNameApplyTo);
    								if(getTabApplyTo!=null){
    									contentPanel.remove(getTabApplyTo, true);
    								}
    								
    								if(!isNullOrEmpty(applyToGrid)){
    									var applyToGridStore = applyToGrid.getStore();
        								if(!isNullOrEmpty(serviceId)){
        									applyToGridStore.getProxy().extraParams={
        										serviceId: serviceId
        									};
        								}
        								$this.resetGridSetting(applyToGrid);
        								$this.resetPageSetting(applyToGridStore);
        								applyToGridStore.loadPage(1);
        								var structure = Ext.widget('servicemasterapplytotabstructure');

        								openTab(contentPanel, tabNameApplyTo, structure,CONSTANTS.MENU_COLOR_THIRTEEN);
        								$this.searchServiceMasterFilter();
    								}
    								// End code for open Apply To tab again with updated records 
    								showSuccessMessage(getCommonTranslation('SERVICE_MAPPING'), getCommonTranslation('ADD_SERVICE_MAPPING_MSG'));  
    							}
    						});
    					});
    					Ext.getBody().unmask();
    					alertWin.show();
    				}
    				else{
    					Ext.Ajax.request({
    						method: "POST",
    						type: 'rest',
    						url: submitUrl,
    						jsonData:submitJsonArr,
    						success : function(response, action) {
    							Ext.getBody().unmask();
    							var data = response.responseText;
    							var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
    							var getTab=getcontroller.getTab(tabName);
    							if(getTab!=null){
    								contentPanel.remove(getTab, true);
    							}
    							//Start code for open Apply To tab again with updated records 
    							var tabNameApplyTo = getExaminationTranslation('APPLY_TO');
    							var getTabApplyTo=getcontroller.getTab(tabNameApplyTo);
    							if(getTabApplyTo!=null){
    								contentPanel.remove(getTabApplyTo, true);
    							}
    							
    							if(!isNullOrEmpty(applyToGrid)){
    								var applyToGridStore = applyToGrid.getStore();
        							if(!isNullOrEmpty(serviceId)){
        								applyToGridStore.getProxy().extraParams={
        									serviceId: serviceId
        								};
        							}
        							$this.resetGridSetting(applyToGrid);
        							$this.resetPageSetting(applyToGridStore);
        							applyToGridStore.loadPage(1);
        							var structure = Ext.widget('servicemasterapplytotabstructure');

        							openTab(contentPanel, tabNameApplyTo, structure,CONSTANTS.MENU_COLOR_THIRTEEN);
        							$this.searchServiceMasterFilter();
    							}
    							// End code for open Apply To tab again with updated records 
    							
    							showSuccessMessage(getCommonTranslation('SERVICE_MAPPING'), getCommonTranslation('ADD_SERVICE_MAPPING_MSG'));
    						}
    					});
    				}
    			}
    		});
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    setProgressTracker : function(progresstracker){
    	var structure = this.getAddservicemastermappingtab();
    	var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");

    	var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
    	var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
    	var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");
    	var progresstracker4 = adjustmentprogresstracker.down("#progresstracker4");

    	if(progresstracker==1){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker1.updateProgress((i * 0.1), '');
    		}
    		progresstracker1.textEl.addCls("custom-progress-text");
    		progresstracker1.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker2.textEl.removeCls("x-progress-text x-progress-text-back");
    		progresstracker2.textEl.addCls("inProgressCss-progress-text");
    		progresstracker2.updateText("Step 2 In Progress");
    		progresstracker1.updateText(getCommonTranslation('STEP_1_COMPLETE'));
    	}
    	if(progresstracker==2){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker2.updateProgress((i * 0.1), '');
    		}
    		progresstracker3.textEl.removeCls("x-progress-text x-progress-text-back");
    		progresstracker3.textEl.addCls("inProgressCss-progress-text");
    		progresstracker3.updateText("Step 3 In Progress");
    		progresstracker2.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker2.textEl.addCls("custom-progress-text");
    		progresstracker2.updateText(getCommonTranslation('STEP_2_COMPLETE'));
    	}
    	if(progresstracker==3){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker3.updateProgress((i * 0.1), '');
    		}
    		progresstracker4.textEl.removeCls("x-progress-text x-progress-text-back");
    		progresstracker4.textEl.addCls("inProgressCss-progress-text");
    		progresstracker4.updateText("Step 4 In Progress");
    		progresstracker3.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker3.textEl.addCls("custom-progress-text");
    		progresstracker3.updateText(getCommonTranslation('STEP_3_COMPLETE'));
    	}
    	if(progresstracker==4){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker4.updateProgress((i * 0.1), '');
    		}
    		progresstracker4.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker4.textEl.addCls("custom-progress-text");
    		progresstracker4.updateText(getCommonTranslation('STEP_4_COMPLETE'));
    	}
    },
    resetProgressTracker : function(){
    	var structure = this.getAddservicemastermappingtab();
    	var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");
    	var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
    	var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
    	var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");
    	var progresstracker4 = adjustmentprogresstracker.down("#progresstracker4");
    	progresstracker1.reset();
    	progresstracker1.updateText('');
    	progresstracker2.reset();
    	progresstracker2.updateText('');
    	progresstracker3.reset();
    	progresstracker3.updateText('');
    	progresstracker4.reset();
    	progresstracker4.updateText('');
    }
});
