/**
 * This controller is used for the student, faculty personal information functionality.
 * Add/Edit/delete/view
 * 
 * @author Sachin.Bangar
 */
Ext.define('Academia.controller.personinfo.common.PersonInfoController', {
    extend: 'Academia.controller.personinfo.common.PersonCommonController',
    mixins: {
    	AddressController: 'Academia.controller.organization.AddressController'/*,
    	StudentPersonalController: 'Academia.controller.personinfo.student.StudentPersonalController'*/
    },

    models: ['personinfo.common.personalinfo.SiblingModel', 'personinfo.common.personalinfo.ParentGuardianModel',
             'genericmodels.dropdowns.EnumCombo','Academia.model.common.OtherAddressCopyModel',
             'student.managehold.StudentApplyHoldModel','personinfo.common.personalinfo.StudentPassportDocumentGridModel','personinfo.common.personalinfo.StudentPassportDocumentModel',
             'personinfo.common.personalinfo.StudentPassportUrlModel','personinfo.common.personalinfo.StudentPassportModel','personinfo.common.personalinfo.StudentVisaDocumentModel' ,
             'personinfo.common.personalinfo.StudentVisaUrlModel','personinfo.common.personalinfo.StudentVisaModel','personinfo.common.personalinfo.StudentVisaDocumentGridModel',
             'personinfo.common.personalinfo.ApplicantPassportDocumentGridModel','personinfo.common.personalinfo.ApplicantPassportDocumentModel','personinfo.common.personalinfo.ApplicantPassportUrlModel', 
             'personinfo.common.personalinfo.PermitDocumentGridModel','personinfo.common.personalinfo.PermitUrlDocumentGridModel',
             'personinfo.common.personalinfo.ApplicantVisaDocumentGridModel','personinfo.common.personalinfo.ApplicantVisaUrlModel','personinfo.common.personalinfo.InsuranceDetailModel', 'personinfo.common.personalinfo.StudentInsuranceDocumentModel','personinfo.common.personalinfo.StudentInsuranceUrlModel', 'personinfo.common.personalinfo.ApplicantInsuranceDetailModel', 'personinfo.common.personalinfo.ApplicantInsuranceDocumentModel','personinfo.common.personalinfo.ApplicantInsuranceUrlModel','personinfo.common.personalinfo.ApplicantInsuranceDocumentGridModel'],
             

    stores: ['personinfo.student.StudentProfileStore', 'personinfo.faculty.FacultyProfileStore', 'common.DesignationTypeStore', 'department.DepartmentComboStore', 'department.SubDepartmentComboStore', 
             'common.NationalityStore', 'common.ReligionStore', 'common.CastCategoryStore', 'common.MaritalStatusStore', 
             'common.RelationshipStore', 'personinfo.common.personalinfo.SiblingStore', 
             'personinfo.common.personalinfo.ParentGuardianStore',
             'personinfo.common.personalinfo.AddressComboStore','personinfo.faculty.FacultyTypeStore','common.SalutationStore',
             'enquiry.studentDetail.GenderStore','enquiry.studentDetail.BloodGroupStore','common.CountryStore',
             'organization.AddressTypeStore','organization.CityStore','organization.CountryRegionStore','organization.CountryRegionStore1',
             'common.ColorStore', 'personinfo.common.personalinfo.IdentityTypeStore','common.DomicileStore', 'user.AccountTypeStore',
             'personinfo.common.personalinfo.HaveDisibilitiesStore','personinfo.common.personalinfo.HomeLanguageStore',
             'personinfo.common.personalinfo.SecondLanguageStore','personinfo.common.personalinfo.SADCCitizenshipStore',
             'personinfo.common.personalinfo.FeePayerDetailStore',
             'personinfo.common.personalinfo.FeePayerDetailDocumentStore',
             'personinfo.common.personalinfo.CurrentEducationalIntervention',
             'personinfo.common.personalinfo.StudentAttendanceGroupStore','common.OtherAddressCopyStore','common.SiblingsByParentDetailsStore',
             'feeandpayment.receipts.DrawnOnBank','personinfo.common.personalinfo.FeePayerDetailGridStore',
             'personinfo.common.personalinfo.FeePayerPaymentTermSelectionGridStore','personinfo.common.personalinfo.FeePayerPaymentTermSelectionComboStore',
             'personinfo.common.personalinfo.FeePayerCurrentPaymentTermEditGridStore','personinfo.common.personalinfo.FeePayerNextPaymentTermViewGridStore','enquiry.EnquiryModeStore',
            'examinationdegreeremark.DegreeAuditReportCoursesStatusChartStore',
             'examinationdegreeremark.DegreeAuditReportCGPAStatusChartStore','student.studentprofile.StudentProgramStore','examinationdegreeremark.DegreeAuditReportCreditStatusChartStore',
             'common.GenderTypeStore','common.FacultyFamilyRelationshipStore',
             'personinfo.common.personalinfo.FacultyFamilyDetailStore','common.IDTypeStore','common.FacultyTypeCSMStore','organization.CityByCountryOrRegion',
             'Academia.store.personinfo.common.personalinfo.BankBranchCodeStore',
             'personinfo.common.personalinfo.IdentityDetailsStore','enquiry.ExamCenterCSMStore',
             'personinfo.common.personalinfo.SSODetailsStore','common.EmployeeLanguageStore',
             'personinfo.common.personalinfo.SocialLoginIntegrationStore','servicerequest.servicerequestsettings.AssigneeApproverHostelGridStore', 'feeandpayment.FeePayerDebitOrderDateStore', 'student.studentprofile.StudentStatusCSMStore','common.EmployeeLanguageCountStore',
             'personinfo.common.personalinfo.AreaOfResearchStore','personinfo.common.personalinfo.FieldOfInterestStore',
             'Academia.store.common.MaritalStatusCSMStore','enquiry.CurrentActivityStore','personinfo.common.personalinfo.ArmsOfServiceStore','examCenter.AssignSequence.ExamintionRemarkGridStore','personinfo.common.personalinfo.MusteringStore',
             'organization.academylocations.LocationCustomSearchStore',
             'common.FindAllNationalIdsStore','Academia.store.admission.applications.applicationBase.OfferTypeStore',
             'Academia.store.admission.applications.applicationBase.FinalApprovalStore','student.managehold.StudentHoldCategoryNameStore',
             'coursetransaction.sectionmanagement.FacultyIdValueSmartSearch','student.managehold.StudentSubHoldCategoryNameStore',
             'student.managehold.StudentApplyHoldGridStore','student.managehold.StudentSeatTypeConfigHoldCategoryNameStore',
             'personinfo.common.NSFAS.BursaryFunddingDetailStore','student.managehold.ManageHoldApplyAtStore','student.managehold.HoldStatusComboStore'
             ,'Academia.store.enquiry.studentDetail.ExamCenterEnumStore','feeandpayment.receipts.BankNameStore','feeandpayment.receipts.BranchNameStore','feeandpayment.receipts.BankIfscStore',
             'feeandpayment.receipts.BranchByBankNameStore','feeandpayment.receipts.BranchIfscCodeStore','personinfo.common.personalinfo.ApplicantPassportStore','personinfo.common.personalinfo.PassportDetailStore','personinfo.common.personalinfo.VisaDetailStore', 'personinfo.common.personalinfo.VisaTypeStore', 'personinfo.common.personalinfo.VisaStatusStore',
             'personinfo.common.personalinfo.StudentPassportDocumentGridStore','personinfo.common.personalinfo.StudentPassportDocumentStore','personinfo.common.personalinfo.StudentPassportUrlGridStore', 
             'personinfo.common.personalinfo.StudentVisaUrlGridStore', 'personinfo.common.personalinfo.StudentVisaDocumentGridStore', 'personinfo.common.personalinfo.StudentVisaDocumentStore',
             'personinfo.common.personalinfo.ApplicantPassportDocumentGridStore','personinfo.common.personalinfo.ApplicantPassportDocumentStore','personinfo.common.personalinfo.ApplicantPassportUrlGridStore',
             'feeandpayment.receipts.BranchByBankNameStore','feeandpayment.receipts.BranchIfscCodeStore','personinfo.common.personalinfo.ApplicantPassportStore','personinfo.common.personalinfo.PassportDetailStore','personinfo.common.personalinfo.VisaDetailStore', 'personinfo.common.personalinfo.VisaTypeStore', 'personinfo.common.personalinfo.VisaStatusStore',
             'personinfo.common.personalinfo.StudentPassportDocumentGridStore','personinfo.common.personalinfo.StudentPassportDocumentStore','personinfo.common.personalinfo.StudentPassportUrlGridStore', 
             'personinfo.common.personalinfo.StudentVisaUrlGridStore','personinfo.common.personalinfo.StudentVisaDocumentGridStore', 'personinfo.common.personalinfo.StudentVisaDocumentStore',
             'personinfo.common.personalinfo.ApplicantPassportDocumentGridStore','personinfo.common.personalinfo.ApplicantPassportDocumentStore','personinfo.common.personalinfo.ApplicantPassportUrlGridStore',
             'personinfo.common.personalinfo.PermitDocumentGridStore','personinfo.common.personalinfo.PermitUrlDocumentGridStore',
             'personinfo.common.personalinfo.PermitTypeStore','personinfo.common.personalinfo.CantonOfIssueStore',
             'personinfo.common.personalinfo.PermitMethodOfSubmissionStore','personinfo.common.personalinfo.PermitDocumentGridStore',
             'personinfo.common.personalinfo.PermitUrlDocumentGridStore',
             'personinfo.common.personalinfo.ApplicantPermitDocumentGridStore','personinfo.common.personalinfo.ApplicantPermitUrlDocumentGridStore',
             'personinfo.common.personalinfo.ApplicantVisaStore','personinfo.common.personalinfo.ApplicantVisaUrlGridStore','personinfo.common.personalinfo.ApplicantVisaDocumentGridStore','personinfo.common.personalinfo.InsuranceDetailStore','personinfo.common.personalinfo.StudentInsuranceDocumentStore',
             'personinfo.common.personalinfo.StudentInsuranceUrlGridStore','personinfo.common.personalinfo.ApplicantInsuranceDetailStore','personinfo.common.personalinfo.ApplicantInsuranceDocumentStore','personinfo.common.personalinfo.ApplicantInsuranceUrlGridStore','personinfo.common.personalinfo.SchoolInsuranceTypeStore',
             'personinfo.common.personalinfo.ApplicantInsuranceDocumentGridStore','personinfo.common.personalinfo.CommunicationChannelStore',
             'personinfo.common.pasthistory.EmpQualificationUsedInApprovalStore',
             'personinfo.common.pasthistory.EmpQualificationMajorOneStore','personinfo.common.pasthistory.EmpQualificationNameStore','personinfo.common.pasthistory.EmpQualificationCategoryStore','personinfo.common.pasthistory.EmpQualificationTypeStore',
            'personinfo.common.pasthistory.EmpQualificationMajorTwoStore','personinfo.common.pasthistory.EmpQualificationMajorThreeStore','personinfo.common.pasthistory.EmpQualificationHEQFLevelStore',
            'personinfo.common.pasthistory.EmpQualificationInstitutionStore','personinfo.common.pasthistory.EmpQualificationApprovalLevelStore','personinfo.common.personalinfo.GovernmentSponsorStore','common.CityPinCodeStoreSmartSearch','common.DietPreferenceStore','common.ActiveSponserTypeStore',
            'common.EthnicityResourceStore','common.GenderIdentityStore','common.SexualOrientationStore',
            'common.TermTimeAccommodationTypeStore','common.CareLeaverStore','personinfo.common.personalinfo.EmploymentStatusCSMStore'],
           
             
    views: ['personinfo.common.PersonCommonWindow', 'personinfo.common.personalinfo.PersonalInformationForm', 
            'personinfo.common.personalinfo.ParentGuardianGrid', 'personinfo.common.personalinfo.ParentGuardianForm',
            'personinfo.common.personalinfo.SiblingDetailsGrid', 'personinfo.common.personalinfo.SiblingForm',
            'common.AddressFieldsForm', 'personinfo.common.personalinfo.AddressFormWindow', 'personinfo.common.personalinfo.AddressDisplayPanel',
            'personinfo.common.personalinfo.AddressDetails', 'personinfo.faculty.personalinfo.FacultyAddressDetails',
           	'personinfo.common.personalinfo.PhotoUploadForm', 'organization.addresses.CustomAddressDisplayField', 
           	'personinfo.common.personalinfo.IdentityDetailsGrid', 'personinfo.common.personalinfo.IdentityDetailsForm',
           	'personinfo.common.personalinfo.OtherInformationDetailsForm',
           	'personinfo.common.personalinfo.FeePayerDetailGrid',
           	'personinfo.common.personalinfo.FeePayerDetailForm',
           	'personinfo.common.personalinfo.FeePayerDetailDocumentWin',
           	'personinfo.common.personalinfo.FeePayerDetailDocumentGrid',
           	'personinfo.common.personalinfo.StudentFeePayerDetailDocumentWin',
           	'personinfo.common.personalinfo.StudentFeePayerDetailDocumentGrid',
           	'personinfo.common.personalinfo.IdVerificationDetailWin','personinfo.common.personalinfo.ApplicantPersonalInformationFormStructure',
           	'common.PersonHostelRequirementForm','common.StudentPersonHostelRequirementForm',
           	'personinfo.faculty.familydetail.FacultyFamilyDetailGrid','personinfo.faculty.familydetail.FacultyFamilyDetailForm','personinfo.common.personalinfo.ProfileDocUploadForm',
           	'personinfo.common.personalinfo.SSODetailsGrid','personinfo.common.personalinfo.FlagDetailsForm','personinfo.common.personalinfo.StudentHoldsGrid','personinfo.common.personalinfo.StudentApplyHoldsForm',
           	'personinfo.common.personalinfo.StudentRemoveHoldsForm','personinfo.common.NSFAS.ApplicantNSFABursaryDetailStructure',
            'personinfo.common.NSFAS.BursaryApplicationStatus','personinfo.common.NSFAS.BursaryApplicationDetails', 
            'personinfo.common.NSFAS.BursaryFunddingDetails','personinfo.common.personalinfo.ManageHoldsStructure','personinfo.BankDetails.StudentBankDetailsGrid','personinfo.common.personalinfo.ApplicantPassportGrid','personinfo.common.personalinfo.PassportDetailGrid','personinfo.common.personalinfo.VisaDetailGrid','personinfo.common.personalinfo.VisaForm',
            'personinfo.common.personalinfo.StudentPassportDetailsForm','personinfo.common.personalinfo.StudentPassportDocumentGrid','personinfo.common.personalinfo.StudentPassportDocumentList','personinfo.common.personalinfo.StudentPassportDocumentListGrid',
            'personinfo.common.personalinfo.StudentPassportUrlGrid','personinfo.common.personalinfo.StudentPassportDocUrlList','personinfo.common.personalinfo.StudentPassportDocUrlListGrid','personinfo.common.personalinfo.StudentVisaUrlGrid', 'personinfo.common.personalinfo.StudentVisaDocumentGrid',
            'personinfo.common.personalinfo.StudentVisaDocumentList','personinfo.common.personalinfo.StudentVisaDocumentListGrid','personinfo.common.personalinfo.StudentVisaDocUrlList','personinfo.common.personalinfo.StudentVisaDocUrlListGrid',
            'personinfo.common.personalinfo.ApplicantPassportDocumentGrid','personinfo.common.personalinfo.ApplicantPassportDocumentList','personinfo.common.personalinfo.ApplicantPassportDocumentListGrid',
            'personinfo.common.personalinfo.ApplicantPassportUrlGrid','personinfo.common.personalinfo.ApplicantPassportDocUrlList','personinfo.common.personalinfo.ApplicantPassportDocUrlListGrid', 
            'personinfo.common.NSFAS.BursaryFunddingDetails','personinfo.common.personalinfo.ManageHoldsStructure','personinfo.common.personalinfo.ApplicantPassportGrid','personinfo.common.personalinfo.PassportDetailGrid','personinfo.common.personalinfo.VisaDetailGrid','personinfo.common.personalinfo.VisaForm',
            'personinfo.common.personalinfo.StudentPassportDetailsForm','personinfo.common.personalinfo.StudentPassportDocumentGrid','personinfo.common.personalinfo.StudentPassportDocumentList','personinfo.common.personalinfo.StudentPassportDocumentListGrid',
            'personinfo.common.personalinfo.StudentPassportUrlGrid','personinfo.common.personalinfo.StudentPassportDocUrlList','personinfo.common.personalinfo.StudentPassportDocUrlListGrid','personinfo.common.personalinfo.StudentVisaUrlGrid', 'personinfo.common.personalinfo.StudentVisaDocumentGrid',
            'personinfo.common.personalinfo.StudentVisaDocumentList','personinfo.common.personalinfo.StudentVisaDocumentListGrid','personinfo.common.personalinfo.StudentVisaDocUrlList','personinfo.common.personalinfo.StudentVisaDocUrlListGrid',
            'personinfo.common.personalinfo.ApplicantPassportDocumentGrid','personinfo.common.personalinfo.ApplicantPassportDocumentList','personinfo.common.personalinfo.ApplicantPassportDocumentListGrid',
            'personinfo.common.personalinfo.ApplicantPassportUrlGrid','personinfo.common.personalinfo.ApplicantPassportDocUrlList','personinfo.common.personalinfo.ApplicantPassportDocUrlListGrid','personinfo.common.personalinfo.ApplicantVisaGrid',
            'personinfo.common.personalinfo.PermitDetailGrid','personinfo.common.personalinfo.PermitDetailForm','personinfo.common.personalinfo.PermitDocumentGrid','personinfo.common.personalinfo.PermitUrlDocumentGrid',
            'personinfo.common.personalinfo.PermitDocumentList','personinfo.common.personalinfo.PermitDocumentListGrid','personinfo.common.personalinfo.PermitUrlDocumentList','personinfo.common.personalinfo.PermitUrlDocumentListGrid',
            'personinfo.common.personalinfo.ApplicantVisaDocumentGrid','personinfo.common.personalinfo.ApplicantVisaUrlGrid','personinfo.common.personalinfo.ApplicantVisaDocumentList','personinfo.common.personalinfo.ApplicantVisaDocumentListGrid',
            'personinfo.common.personalinfo.ApplicantVisaDocUrlList','personinfo.common.personalinfo.ApplicantVisaDocUrlListGrid','personinfo.common.personalinfo.StudentInsuranceDetailsGrid','personinfo.common.personalinfo.StudentInsuranceDocumentList', 'personinfo.common.personalinfo.StudentInsuranceDocumentListGrid',
            'personinfo.common.personalinfo.StudentInsuranceDocUrlList', 'personinfo.common.personalinfo.StudentInsuranceDocUrlListGrid','personinfo.common.personalinfo.ApplicantInsuranceDetailsGrid','personinfo.common.personalinfo.ApplicantInsuranceDocUrlList', 'personinfo.common.personalinfo.ApplicantInsuranceDocUrlListGrid',
            'personinfo.common.personalinfo.StudentInsuranceUrlGrid','personinfo.common.personalinfo.StudentInsuranceDocumentGrid','personinfo.common.personalinfo.VisaDetailGrid','personinfo.common.personalinfo.InsuranceForm','personinfo.common.personalinfo.ApplicantInsuranceDocumentList','personinfo.common.personalinfo.ApplicantInsuranceDocumentListGrid',
            'personinfo.common.personalinfo.ApplicantPermitDetailGrid','personinfo.common.personalinfo.ApplicantPermitDocumentGrid','personinfo.common.personalinfo.ApplicantPermitUrlDocumentGrid','personinfo.common.pasthistory.QualificationDetailsForm',
            'personinfo.common.personalinfo.ApplicantPermitDocumentList','personinfo.common.personalinfo.ApplicantPermitDocumentListGrid','personinfo.common.personalinfo.ApplicantPermitUrlDocumentList','personinfo.common.personalinfo.ApplicantPermitUrlDocumentListGrid','personinfo.common.personalinfo.ApplicantInsuranceDocumentGrid','personinfo.common.personalinfo.ApplicantInsuranceUrlGrid',
            'personinfo.faculty.EmployeePersonalInformationForm','personinfo.common.pasthistory.QualificationDetailsGrid','personinfo.common.personalinfo.FeePayerGoogleAddressWin'],


    alias: "widget.personinfocontroller",
    refs : [{
 	   ref : 'personalinformationform',
 	   selector : 'personalinformationform'
    },{
    	ref:'addressdisplaypanel',
    	selector:'addressdisplaypanel'
    },{
    	ref:'studentholdsgrid',
    	selector:'studentholdsgrid'
    },{
    	ref:'flagdetailsform',
    	selector:'flagdetailsform'
    }],
    config: {
    	PARENT_FLAG_LIST_PRIVILEGES : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_FLAG_DETAILS_PRIVILEGES'),
    	STUDENT_FLAG_LIST_PRIVILEGES : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_FLAG_DETAILS_PRIVILEGES'),
    	STUDENT_LIST_FEE_PAYER_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_FEE_PAYER_DETAILS_PRIVILEGES'),
	},
    init : function() {
    	this.control({
    		'personalinformationform': {
    			beforerender: function(obj) {
    				var specifyOtherItemId = obj.down("#specifyOtherItemId");
    				if(!isNullOrEmpty(specifyOtherItemId)) {
    					specifyOtherItemId.setFieldLabel(getPersonModuleTranslation('PP_SPECIFY_OTHER') + '<span class="required" style="color:red"> *</span>');
    				}
    			},
    			render: function(obj) {
    				this.getStore('user.AccountTypeStore').load();
    				 var portalId = this.getCurrentLoggedPortalId();
       				 if(portalId != 3 && portalId != 7){
       					this.getStore('personinfo.common.personalinfo.CurrentEducationalIntervention').load();
       				 }
    			},
    			afterrender:function(frm){
    				var me = this;
    				var phoneNoFldItemId = this.getActiveTabfromContentPanel().down('#phoneNoFldItemId');
    				var mobileNoFldItemId = this.getActiveTabfromContentPanel().down('#mobileNoFldItemId');
    				var lblOneContactDetail = this.getActiveTabfromContentPanel().down('#lblOneContactDetail');
    				var emailId = this.getActiveTabfromContentPanel().down('#emailId');
    				var alternateEmailId = this.getActiveTabfromContentPanel().down('#alternateEmailId');
    				var contactFieldSet = this.getActiveTabfromContentPanel().down('#contactFieldSet');
    				if(this.getActiveTabfromContentPanel().personType =='FACULTY'){
    					var employCode = frm.down('#personCodeField');
    					employCode.setFieldLabel(getPersonModuleTranslation('EMPLOYEE_ID'))
    				}

    				if(!isNullOrEmpty(phoneNoFldItemId)){
    					if(phoneNoFldItemId.isVisible() && mobileNoFldItemId.isVisible()){
    						lblOneContactDetail.setVisible(true);
    					}else{
    						lblOneContactDetail.setVisible(false);
    					}
    					if(!mobileNoFldItemId.isVisible() && !phoneNoFldItemId.isVisible() && !emailId.isVisible() && !alternateEmailId.isVisible()){
    						contactFieldSet.setVisible(false);
    					}
    					else{
    						contactFieldSet.setVisible(true);
    					}
    				}

    				setTimeout(function(){
    					if(frm.up('stcpncstudentregistration')){
    						var formAlias = frm.alias[0].split(".")[1];
    						var frmValues = frm.getValues();
    						me.toggleFormFieldsItems(frm,formAlias);
    						setTimeout(function(){
    							frm.getForm().setValues(frmValues);
    							frm.isValid(true);
    							try{
    								frm.getForm().clearInvalid();
    							}
    							catch(e){}
    						},500);
    					}
    					/*if(portalId == 3){
    						var form  = me.getPersonalinformationform();
    						Ext.defer(function(){
    							me.hideFieldsOfPersonalInformationForm(form);
    						},500);
    					} */

    				},3000);


    			}
    		},
    		'feepayerdetailform': {
    			beforerender: function(obj) {
    				var feePayerIDItemId = obj.down("#feePayerIDItemId");
    				var feePayerProofOfAccountItemId = obj.down('#feePayerProofOfAccountItemId');
//    				var feePayerLatestPayslipItemId = obj.down("#feePayerLatestPayslipItemId");
//    				feePayerIDItemId.allowBlank = true; // V2D-504104
//    				feePayerLatestPayslipItemId.allowBlank = false;
    				//feePayerIDItemId.setFieldLabel(getPersonModuleTranslation('FPD_FEE_PAYER_ID') + '<span class="required" style="color:red"> *</span>');
    				//feePayerProofOfAccountItemId.setFieldLabel(getPersonModuleTranslation('FPD_FEE_PAYER_PROOF_OF_ACCOUNT') + '<span class="required" style="color:red"> *</span>');
//    				feePayerLatestPayslipItemId.setFieldLabel(getPersonModuleTranslation('FPD_FEE_PAYER_LATEST_PAYSLIP') + '<span class="required" style="color:red"> *</span>');
    			},
    			render: function(obj) {
    				//this.getStore('common.SalutationStore').load();
    				//this.getStore('common.CountryStore').load();    				
    			}
    		},
    		'flagdetailsform':{
    			afterrender: function(grid){
    				if(portalId == 3){
    				   this.doAccessControlValidation(grid, this.getSTUDENT_FLAG_LIST_PRIVILEGES());
    				}else if(portalId == 7){
    					this.doAccessControlValidation(grid, this.getPARENT_FLAG_LIST_PRIVILEGES());
    				}
    				
    			}
    		}

            
    	})
    },
    /**
     * Save file upload for person
     * @param  form
     * @param personId
     * @param personId
     */
    /* V2D-479891
     * savePersonPhotoUpload : function(form, personId, uplaodUrl, downloadUrl, callback){
    	var this$ = this;
    	var photoFileImage = form.down('#photoFileImage');
    	var fileUploadPath = photoFileImage.getValue();
    	if(!isNullOrEmpty(fileUploadPath)){
    		var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
    		if (extension == "gif" || extension == "png" || extension == "bmp"
                || extension == "jpeg" || extension == "jpg") {
    			form.getForm().submit({
    	        	method : 'POST',
    	        	url : uplaodUrl,
    	        	params:{
    	        		personId : personId
    	        	},
    	        	success : function(form, action){
    	        		var photoUrl=action.result.path;
    	        		callback(true,photoUrl);
    	        		showSuccessMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('PHOTO_UPLOAD_SUCCESS'));
    	        		this$.setUploadedPhotoToPersonProfile(downloadUrl);
    	        	}
    	        });
    		}else{
    			photoFileImage.reset();
    			showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_VALID_FILE'));
    		}
    		
    	}
    	
    	
    },
*/    
    /**
     * Save file upload for person
     * @param  form
     * @param personId
     * @param personId
     */
    savePhotoUploadForm : function(form, personId, uplaodUrl, downloadUrl, callback){
    	var this$ = this;
    	var photoFileImage = form.down('#photoFileImage');
    	var fileUploadPath = photoFileImage.getValue();
    	if(!isNullOrEmpty(fileUploadPath)){
    		var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
    		if (extension == "gif" || extension == "png" || extension == "bmp"
                || extension == "jpeg" || extension == "jpg") {
    			form.getForm().submit({
    	        	method : 'POST',
    	        	url : uplaodUrl,
    	        	params:{
    	        		personId : personId
    	        	},
    	        	success : function(form, action){
    	        		var photoUrl=action.result.path;
    	        		var version=action.result.version;
    	        		callback(true,photoUrl,version);
    	        	},
                        failure: function(form, action) {
			            var  msg = getCommonTranslation('UPLOAD_FILE_TYPE_IS_INVALID');
                        showWarningMessage(getCommonTranslation('ALERT'), msg);
				        
				    }
    	        });
    		}else{
    			photoFileImage.reset();
    			showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_VALID_FILE'));
    			Ext.getBody().unmask();
    			if(form.up('employeepersonalinformationform')){
    				form.up('employeepersonalinformationform').down('#personalInfoSaveButtonId').setDisabled(false);
    			}else{
    				form.up('personalinformationform').down('#personalInfoSaveButtonId').setDisabled(false);
    			}
    			
    		}
    		
    	}
    	
    	
    },
    /**
     * Save file upload for person
     * @param  form
     * @param personId
     * @param personId
     */
    saveStudentProfileDocumentUploadForm : function(form, personId, uplaodUrl, downloadUrl, callback){
    	var this$ = this;
    	var docFileImage = form.down('#documentFileUpload');
    	var fileUploadPath = docFileImage.getValue();
    	if(!isNullOrEmpty(fileUploadPath)){
    		var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
    		if (extension == "docx" || extension == "doc" || extension == "xls"
                || extension == "pdf" || extension == "xlsx" || extension == "png" || extension == "bmp"
                    || extension == "jpeg" || extension == "jpg") {
    			form.getForm().submit({
    	        	method : 'POST',
    	        	url : uplaodUrl,
    	        	params:{
    	        		personId : personId
    	        	},
    	        	success : function(form, action){
    	        		var photoUrl=action.result.path;
    	        		var version=action.result.version;
    	        		callback(true,photoUrl,version);
    	        	}
    	        });
    		}else{
    			docFileImage.reset();
    			showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_VALID_FILE'));
    		}
    		
    	}
    },
    /**
     * Save file upload for Applicant + size validation
     * @param  form
     * @param personId
     * @param personId
     */
    saveApplicantPhotoUploadForm : function(form, personId, uplaodUrl, downloadUrl, callback){
    	var this$ = this;
    	var photoFileImage = form.down('#photoFileImage');
    	var fileUploadPath = photoFileImage.getValue();
    	if(!isNullOrEmpty(fileUploadPath)){
    		file = photoFileImage.fileInputEl.dom.files[0];
    		if(file.size / 1048576 < CONSTANTS.UPLOAD_FILE_SIZE_LIMIT)
    			{
    		var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
    		if (extension == "gif" || extension == "png" || extension == "bmp"
                || extension == "jpeg" || extension == "jpg") {
    			form.getForm().submit({
    	        	method : 'POST',
    	        	url : uplaodUrl,
    	        	params:{
    	        		personId : personId
    	        	},
    	        	success : function(form, action){
    	        		var photoUrl=action.result.path;
    	        		var version=action.result.version;
    	        		callback(true,photoUrl,version);
    	        	}
    	        });
    		}else{
    			Ext.getBody().unmask();
    			photoFileImage.reset();
    			showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_VALID_FILE'));
    		}
    			}else{
    				Ext.getBody().unmask();
    				photoFileImage.reset();
    				showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
    			}
    		
    	}
    	
    	
    },
    /**
     * Set photo to person profile image 
     * @param  form
     * @param personId
     * @param personId
     */
    setUploadedPhotoToPersonProfile : function(downloadUrl,userType){
    	var this$ = this;
    	var personProfile = this$.getContentPanelActiveTab();
    	var personId ;
    	try{
    		personId = personProfile.getPersonId();
    	}catch(e){
    		personId =this$.getContentPanel().items.items[0].getPersonId();
    	}
    	var portalId = this$.getCurrentLoggedPortalId();
    	var finalDownloadUrl = downloadUrl+'?personId='+personId+'&portalId='+portalId+'&isDefaultImageRequired=false';
    	if( !isNullOrEmpty(userType) ){
    		finalDownloadUrl = downloadUrl+'?personId='+personId+'&userType='+userType+'&portalId='+portalId+'&isDefaultImageRequired=false';
    	}
   
		if(!isNullOrEmpty(personId)){
    		Ext.Ajax.request({
                type: 'rest',
                binary: true,
                url: finalDownloadUrl,
                method: 'GET',
                success : function(response){
                	if(response.responseBytes.length>0){
    					 var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
    					 var url = window.URL.createObjectURL(blob);
    					 var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
    					 if(personController.isProfilePicSaved && (portalId==2 || portalId==3 || portalId==7)) {
    						 var fimg = this$.getUserinfo().down('#userInfoButton');
    						 fimg.setIcon(url);
    						 fimg.setVisible(true);
    					 } else {
    						 var img=personProfile.down("#profile_image");
    						 if(!isNullOrEmpty(img)){
	    						 if(Ext.isChrome==false){
	    							 img.setVisible(true);
	    							 setTimeout(function(){
	    								 img.el.dom.src = url;
	    							 },1000);
	    						 } else {
	    							 Ext.defer(function (){
	    								 var fallbackImg = generateInitialsImage(
	    										 personProfile.personInfo.firstName,
	    										 personProfile.personInfo.middleName,
	    										 personProfile.personInfo.lastName
	    								 );
	    								 
	    								 img.setVisible(true);
	    								 
	    								 
	    								 var photoUrl = personProfile.personInfo.photoUrl;
	    								 if (photoUrl) {
	    									 img.setSrc(url);
	    								 } else {
	    									 img.setSrc(fallbackImg); 
	    								 }
	    								 
	    								 // Handle error fallback
	    								 if (img.rendered) {
    									    var imgDom = img.getEl().dom;
    									    imgDom.onerror = function () {
    									        this.onerror = null;
    									        this.src = fallbackImg;
    									    };
    									 } else {
    									    img.on('afterrender', function () {
    									        var imgDom = img.getEl().dom;
    									        imgDom.onerror = function () {
    									            this.onerror = null;
    									            this.src = fallbackImg;
    									        };
    									    });
    									 }
	    								 
	    							 },1000)
	    							 
	    						 }
	    						 }
    						 
    						 }         	    		
    					 /**
    					  * @Author Surendra Jha
    					  * Show user image for applicant portal user
    					  */
    					 if(portalId==6) {
    						 if(!isNullOrEmpty(this$.getUserInfo()))
    						 {
    							 var fimg = this$.getUserInfo().down('#userInfoButton');
    							 fimg.setIcon(url);
    							 fimg.setVisible(true);
    						 } else {
    							 Ext.defer(function (){
    								 var img=personProfile.down('image[customId=profileImageRef]');
    								 var fallbackImg = generateInitialsImage(
    										 personProfile.personInfo.firstName,
    										 personProfile.personInfo.middleName,
    										 personProfile.personInfo.lastName
    								 );
    								 
    								 img.setVisible(true);
    								 
    								 
    								 var photoUrl = personProfile.personInfo.photoUrl;
    								 if (photoUrl) {
    									 img.setSrc(url);
    								 } else {
    									 img.setSrc(fallbackImg); 
    								 }
    								 
    								 // Handle error fallback
    								 if (img.rendered) {
									    var imgDom = img.getEl().dom;
									    imgDom.onerror = function () {
									        this.onerror = null;
									        this.src = fallbackImg;
									    };
    								 } else {
									    img.on('afterrender', function () {
									        var imgDom = img.getEl().dom;
									        imgDom.onerror = function () {
									            this.onerror = null;
									            this.src = fallbackImg;
									        };
									    });
    								 }
    								 
    							 },1000)
    						 }
    					 }
    					 
    				}else{
    					if(portalId == 6) {
    						img=personProfile.down('image[customId=profileImageRef]');
    						var cc;
    						Ext.defer(function() {
        						img.setVisible(true);
            					var fallbackImg = generateInitialsImage(
        								 personProfile.personInfo.firstName,
        								 personProfile.personInfo.middleName,
        								 personProfile.personInfo.lastName
        						 );
        						 img.setSrc(fallbackImg);
        						 if(this$.getUserInfo()) {
             						cc = this$.getUserInfo().down("#userInfoButton");
             						cc.setIcon(fallbackImg);
             					}
        					}, 1000)
    					} else {
    						var img=personProfile.down("#profile_image");
    						var cc;
    						Ext.defer(function() {
        						img.setVisible(true);
            					var fallbackImg = generateInitialsImage(
        								 personProfile.personInfo.firstName,
        								 personProfile.personInfo.middleName,
        								 personProfile.personInfo.lastName
        						 );
            					img.setSrc(fallbackImg);
            					if(this$.getUserInfo() && typeof this$.getUserInfo() != "number") {
            						cc = this$.getUserInfo().down("#userInfoButton");
            						cc.setIcon(fallbackImg);
            					}
        					}, 1000)
    					}
    				}
               }

            });
    	}
    },
    
    /**
     * This is to set short name on change on first name
     */
    shortNameOnchangeOfFirstName: function(firstNameField,formItemId,status){
    	var personProfile = this.getContentPanelActiveTab();
    	var form = personProfile.down(formItemId);
    	
    	
    	Ext.Ajax.request({
    		type: 'rest',
    		async: false,
    		url: SERVERURL.FILE_PRIORITY,
    		params: {
    			type:'ShortName'
    		},
    		method: 'GET',
    		success: function(res, action) {
    			var response = Ext.decode(res.responseText);
    			if(response.length == 0){
    		    	//V2D-56058-resolved
    		    	if(!isNullOrEmpty(form)){
    		    		var shortNameField = form.down('textfield[name=shortName]');
    		    		var firstNameValue = firstNameField.getValue();
    		    		if(!isNullOrEmpty(firstNameValue)){
    		    			if(isNullOrEmpty(status)){
    		        			shortNameField.setValue(firstNameValue);
    		        		}
    		    		}
    		    	}
    			}
    		}
    	});
    },
    shortNameOtherLnguageOnchangeOfFirstName: function(firstNameField,formItemId,status){
    	var personProfile = this.getContentPanelActiveTab();
    	var form = personProfile.down(formItemId);
    	if(!isNullOrEmpty(form)){
    		var shortNameField = form.down('textfield[name=shortNameOtherLanguage]');
    		var firstNameValue = firstNameField.getValue();
    		if(!isNullOrEmpty(firstNameValue)){
    			if(isNullOrEmpty(status)){
        			shortNameField.setValue(firstNameValue);
        		}
    		}
    	}
    },
    
    getPersonalInfoJsonValue: function(data, obj, datafield, formField) {
        if (data[obj] != null && data[obj].hasOwnProperty(datafield)) {
            var dataObj = data[obj];
            data[formField] = dataObj[datafield];
        }
        return data;
    },

    setJsonfield: function(jsonData, obj, dataField, formField) {
        if (jsonData.hasOwnProperty(formField)) {
        	if(!isNullOrEmpty(jsonData[formField])){
        		obj[dataField] = jsonData[formField];
        	}else{
        		obj[dataField] = null;
        	}
            
            delete jsonData[formField];
        }
    },
    
    /**
     * On selection address type combo
     *  @param addressDetailsItemId
     */
    onSelectionPersonAddressType: function(addressDetailsItemId) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var addressDetails = personProfile.down(addressDetailsItemId);
        var addressTemplateData = addressDetails.getAddressTemplateData();
        var addressCombo = addressDetails.down('#addressCombo');
        var type = addressCombo.getValue();
        
        this$.setAddressTemplateDisplayField(addressDetailsItemId, addressTemplateData, type);
    },
    /**
     * On selection address type combo
     *  @param addressDetailsItemId
     *  @param url
     */
    onSelectionPersonAddressTypeCombo: function(addressDetailsItemId, findRelatedPersonUrl, relatedPersonUrl) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var addressDetails = personProfile.down(addressDetailsItemId);
        if(isNullOrEmpty(addressDetails)){
        	var addressDetails = Ext.ComponentQuery.query(addressDetailsItemId)[0];
        }
        var addressCombo;
        try{
        	addressCombo = addressDetails.down('#addressCombo');
        } catch(e) {
        	//-- code changed for multiple tabs functionality for applicant portal
            if(Ext.isDefined(Ext.ComponentQuery.query('addressdetails')))
            {
            	addressCombo = Ext.ComponentQuery.query('addressdetails')[0].down('#addressCombo');
            }
            else
            {
            	addressCombo=this$.getContentPanel().items.items[1].down('#addressCombo');
            }
        	//addressCombo = this$.getContentPanel().items.items[1].down('#addressCombo');
        }
        var type = addressCombo.getValue();
        var personObj = this$.getPersonObj();
        var personId = personObj["id"];
        if (!isNullOrEmpty(personId)) {
        	if(type == 'SELF_ADDRESS'){
        		this$.setDataToPersonAddressDetailsTemplate(addressDetailsItemId, type, personId, relatedPersonUrl);
        	}else{
        		var addressType = null;
        		if (type == 'FATHER_ADDRESS') {
                    addressType = "FATHER";
                } else if(type == 'MOTHER_ADDRESS'){
                    addressType = "MOTHER";
                } else if (type == "GUARDIAN_ADDRESS") {
                    addressType = "GUARDIAN";
                } else if (type == "LOCAL_GUARDIAN_ADDRESS") {
                    addressType = "LOCAL_GUARDIAN";
                }
        		var params = {
            			personId : personId,
            			relationship : addressType
            	};
            	this$.sendGetAjaxRequest(findRelatedPersonUrl, 'GET', params, function(option, success, response) {
                	if(success){
                		var relatedpersonId = null;
                		if(!isNullOrEmpty(response.responseText)){
                			relatedpersonId = Ext.decode(response.responseText);
                        }
                		this$.setDataToPersonAddressDetailsTemplate(addressDetailsItemId, type, relatedpersonId, relatedPersonUrl);
                	}
                });
        	}
        	
        }
    },
    /**
     *  Get person address detail template data
     *  @param addressDetailsItemId
     *  @param type
     *  @param url
     */
    getPersonAddressDetailTemplateData : function(addressDetailsItemId, type, url) {
        var this$ = this;
        var personObj = this$.getPersonObj();
        var personId = personObj["id"];
        this$.setDataToPersonAddressDetailsTemplate(addressDetailsItemId, type, personId, url);
    },
    /**
     *  Set data to person address details template
     *  @param addressDetailsItemId
     *  @param type
     *  @param personId
     *  @param url
     */
    setDataToPersonAddressDetailsTemplate: function(addressDetailsItemId, type, personId, url) {
        var this$ = this;
        var data = null;
        var personProfile = this$.getContentPanelActiveTab();
        var addressDetails = personProfile.down(addressDetailsItemId);
        if(addressDetails == null) {
        	addressDetails = personProfile;
        }
        var addressDisplayPanel = addressDetails.down('addressdisplaypanel');
        
        addressDetails.setAddressPersonId(personId);
        if (!isNullOrEmpty(personId)) {
        	addressDisplayPanel.setDisabled(false);
        	var params = {
        			personId : personId	
        	}; 
        	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        	var studentController = Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
        	studentController.getStudentAddressPrivilege(addressDetails);
        	this$.sendGetAjaxRequest(url, 'GET', params, function(option, success, response) {
            	if(success){
            		data = Ext.decode(response.responseText);
            		this$.setAddressTemplateDisplayField(addressDetailsItemId, data, type);
                    addressDetails.setAddressTemplateData(data);
                    
            	}else{
            		this$.setAddressTemplateDisplayField(addressDetailsItemId, data, type);
            		addressDetails.setAddressTemplateData(data);
            	}
            	var studentController = Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
            	studentController.getStudentAddressPrivilege(addressDetails);
            	
            	var applicantController = Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
            	applicantController.getApplicantAddressPrivilege(addressDetails);
            	
            	
            });
        }else{
        	addressDisplayPanel.setDisabled(true);
        	showWarningMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'), getPersonModuleTranslation('RELATED_PERSON_NOT_PRESENT'));
        	this$.setAddressTemplateDisplayField(addressDetailsItemId, data, type);
    		addressDetails.setAddressTemplateData(data);
    		
    		var studentController = Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
        	studentController.getStudentAddressPrivilege(addressDetails);
        	
        	var applicantController = Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
        	applicantController.getApplicantAddressPrivilege(addressDetails);
        }
    },
    
    
    
    /*
     *  Print the address details
     */
    onPrintClick: function(addressDisplayField) {
        Ext.ux.Printer.print(addressDisplayField);
    },
    /*
     *  On Selection Generic field store load 
     */
    onSelectionGenericField: function(combo, record, form) {
        var genericField2ComboBox = form.down('customcombobox#genericFieldId2');//this.getAddressfieldsform().down('customcombobox#genericFieldId2');
        genericField2ComboBox.reset();

        var countryRegion1 = record[0].get("id");
        var store = this.getStore('organization.CountryRegionStore1');
        store.getProxy().api.read = SERVERURL.COUNTRY_FINDALL;
        store.getProxy().extraParams = {
            pid: countryRegion1
        };
        store.reload();
    },

    /*
     *  On Country Selection Generic, cell, city field store load 
     */
    onSelectionCountry: function(combo, record, form) {
        var cityComboBox = form.down('customcombobox#cityId');//this.getAddressfieldsform().down('customcombobox#cityId');
        cityComboBox.clearValue();

        var parentCountryRegionComboBox = form.down('customcombobox#parentCountryRegionId');
        parentCountryRegionComboBox.reset();

        /*var genericField2ComboBox = form.down('customcombobox#genericFieldId2');
        genericField2ComboBox.reset();*/

        var countryId = record[0].get("id");

       /* var cityStore = cityComboBox.getStore();
        cityStore.getProxy().extraParams = {
            id: countryId
        };
        cityStore.load();*/

        var countryRegionStore = parentCountryRegionComboBox.getStore();
        countryRegionStore.getProxy().extraParams = {
            cid: countryId
        };
        countryRegionStore.load();

        /*var countryRegion2Store = genericField2ComboBox.getStore();
        countryRegion2Store.removeAll();*/
    },
    /**
     *  Get city & region based on selected country
     *  @param combo,record,form
     */
    onCountryChange: function(combo, record, form) {
        var cityComboBox = form.down('customcombobox#cityId');
        cityComboBox.reset();

        var parentCountryRegionComboBox = form.down('customcombobox#parentCountryRegionId');
        parentCountryRegionComboBox.reset();

        var countryId = record[0].get("id");

       /* var cityStore = cityComboBox.getStore();
        cityStore.getProxy().extraParams = {
        	countryId: countryId
        };
        cityStore.load();*/

        var countryRegionStore = parentCountryRegionComboBox.getStore();
        countryRegionStore.getProxy().extraParams = {
            cid: countryId
        };
        countryRegionStore.load();

    },
    /*
     *  On Country change, value set for Generic, cell field
     */
    onChangeCountry: function(combo, record, form) {
        var phoneCountryCode = form.down('customcombobox#phoneCountryCode');
        var cellCountryCode = form.down('customcombobox#cellCountryCode');
        var countryStore = form.down('customcombobox#countryId').getStore();
        var val = countryStore.getById(record);
        
        /*var formValues = form.getValues();
        if (isNullOrEmpty(formValues.id)) {
        	phoneCountryCode.setValue(val);
            cellCountryCode.setValue(val);
        }*/
        
        phoneCountryCode.setValue(val);
        cellCountryCode.setValue(val);
    },
    
    /*
     *  Set the address template data, hide show print button, set add/update text 
     */
    setAddressTemplateDisplayField: function(addressDetailsItemId, data, type) {
    	
        var this$ = this,
        	currentAddress = false,
            correspondanceAddress = false,
            permanentAddress = false,
            officeAddress = false,
            googleAddress = false,
            crntMandatory = false,
    		crspndcMandatory = false,
    		prmntMandatory = false,
    		ofcMandatory = false,
    		googleMandatory = false,
    		crntHeaderTitle = getPersonModuleTranslation('CURRENT_ADDRESS'),
        	crspndcHeaderTitle = getPersonModuleTranslation('ADDRESS_FOR_CORRESPONDANCE'),
        	prmntHeaderTitle = getPersonModuleTranslation('PERMANENT_ADDRESS'),
        	ofcHeaderTitle = getPersonModuleTranslation('OFFICE_ADDRESS'),
        	googleHeaderTitle = getPersonModuleTranslation('GOOGLE_ADDRESS');

        var personProfile = this$.getContentPanelActiveTab();
        var addressDetails = personProfile.down(addressDetailsItemId);
        if(addressDetails == undefined || isNullOrEmpty(addressDetails)){
        	personProfile.setAutoScroll(true);
        	addressDetails=personProfile;
        }
        var personAddressDisplayField1 = addressDetails.down('displayfield#personAddressDisplayField1');
        var personAddressDisplayField2 = addressDetails.down('displayfield#personAddressDisplayField2');
        var personAddressDisplayField3 = addressDetails.down('displayfield#personAddressDisplayField3');
        var personAddressDisplayField4 = addressDetails.down('displayfield#personAddressDisplayField4');
        var personAddressDisplayField5 = addressDetails.down('displayfield#personAddressDisplayField5');

        this$.enabledDisabledResetAddressDisplayField(personAddressDisplayField1);
    	this$.enabledDisabledResetAddressDisplayField(personAddressDisplayField2);
    	this$.enabledDisabledResetAddressDisplayField(personAddressDisplayField3);
    	this$.enabledDisabledResetAddressDisplayField(personAddressDisplayField4);
    	this$.enabledDisabledResetAddressDisplayField(personAddressDisplayField5);
    	
    	if(type == "SELF_ADDRESS"){
        	if(addressDetails.up() && addressDetails.up().registrationSetupAddress && addressDetails.up().registrationSetupAddress.length){
        		var tempCount=0;
					Ext.each(addressDetails.up().registrationSetupAddress, function(currentSetup){
					tempCount++;
        			if(currentSetup.addressCode == "CRNT"){
        				crntMandatory = currentSetup.whetherMandatory;
        			}
        			if(currentSetup.addressCode == "CRSPDNC"){
        				crspndcMandatory = currentSetup.whetherMandatory;
        			}
        			if(currentSetup.addressCode == "PRMNT"){
        				prmntMandatory = currentSetup.whetherMandatory;
        			}
        			if(currentSetup.addressCode == "OFC"){
        				ofcMandatory = currentSetup.whetherMandatory;
        			}
        			if(currentSetup.addressCode == "GOOGLE"){
        				googleMandatory = currentSetup.whetherMandatory;
        			}
        			
        			if(tempCount==addressDetails.up().registrationSetupAddress.length && !crntMandatory && !crspndcMandatory && !prmntMandatory && !ofcMandatory && !googleMandatory){
        				crntMandatory = true;
        			}
        		});
        	}
        	else{
        		crntMandatory = true;
        		crspndcMandatory = false;
        		prmntMandatory = false;
        		ofcMandatory = false;
        		googleMandatory = false;
        	}
        	
        	if(crntMandatory){
        		crntHeaderTitle = crntHeaderTitle+ " <span class='addressMandatoryCls'>*</span>";
        	}
        	if(crspndcMandatory){
        		crspndcHeaderTitle = crspndcHeaderTitle+ " <span class='addressMandatoryCls'>*</span>";
        	}
        	if(prmntMandatory){
        		prmntHeaderTitle = prmntHeaderTitle+ " <span class='addressMandatoryCls'>*</span>";
        	}
        	if(ofcMandatory){
        		ofcHeaderTitle = ofcHeaderTitle+ " <span class='addressMandatoryCls'>*</span>";
        	}
        	if(googleMandatory){
        		googleHeaderTitle = googleHeaderTitle+ " <span class='addressMandatoryCls'>*</span>";
        	}
    	}
    	
    	personAddressDisplayField1.up().setTitle(crntHeaderTitle);
    	personAddressDisplayField2.up().setTitle(crspndcHeaderTitle);
    	personAddressDisplayField3.up().setTitle(prmntHeaderTitle);
    	personAddressDisplayField4.up().setTitle(ofcHeaderTitle);
    	personAddressDisplayField5.up().setTitle(googleHeaderTitle);
    	
        var AddressTpl = Ext.create('Ext.XTemplate', '<p><B><span style="word-break: break-all;">{address.addressText}</span></B></p>','<tpl if=\'address.countryIdText != null\'><span style="word-break: break-all;">{address.countryIdText}</span><br></tpl>','<tpl if=\'address.parentCountryRegionIdText != null\'><span style="word-break: break-all;">{address.parentCountryRegionIdText}</span><br></tpl>','<tpl if=\'address.cityIdText != null\'><span style="word-break: break-all;">{address.cityIdText}</span><br></tpl>',/*'<tpl if=\'address.pincode != null\'>{address.pincode}</tpl>',*/ '<tpl if=\'address.city != null\'>', '{address.city.value} </tpl> {address.code}', '<tpl if=\'address.countryRegion != null\'>','{address.countryRegion.value}</tpl> <br>', '<tpl if=\'address.parentCountryRegion != null\'>', '{address.parentCountryRegion.value}</tpl><br> {address.country.value}<br>',
        '<tpl if=\'!isNullOrEmpty(address.pincode)\'>','{address.pincode}</tpl><br>','<tpl if=\'address.pincodeNew != null\'>', '{address.pincodeNew.value} </tpl><br>', '<tpl if=\'address.phoneNo != null\'>',
        getCommonTranslation('ADDRESS_PHONE_NUMBER') + ' ' + '{address.phoneCountryCode}-', '<tpl if=\'address.phoneAreaCode != null\'>', '{address.phoneAreaCode}-</tpl>', '{address.phoneNo}</tpl><br>', '<tpl if=\'address.cellNo != null\'>',
        getCommonTranslation('ADDRESS_MOBILE_NO') + ' ' + '{address.cellCountryCode}-{address.cellNo}</tpl><br>', '<span style="word-break: break-all;">{address.primaryeEmailId}</span>');
        if (!isEmpty(data)) {

            Ext.each(data, function(obj) {
            	var address = obj['address'];

            	var addressType = address['addressType'];
            	if(addressType !== null) {
            	
                    if (address['addressType']['code'] == 'CRNT') {
                        currentAddress = true;
                        personAddressDisplayField1.setValue(AddressTpl.applyTemplate(obj));
                        personAddressDisplayField1.setModel(obj);
                        personAddressDisplayField1.up().setTitle(crntHeaderTitle);
                        
                    } else if (address['addressType']['code'] == 'CRSPDNC') {
                        correspondanceAddress = true;
                        personAddressDisplayField2.setValue(AddressTpl.applyTemplate(obj));
                        personAddressDisplayField2.setModel(obj);
                        personAddressDisplayField2.up().setTitle(crspndcHeaderTitle);

                    } else if (address['addressType']['code'] == 'PRMNT') {
                        permanentAddress = true;
                        personAddressDisplayField3.setValue(AddressTpl.applyTemplate(obj));
                        personAddressDisplayField3.setModel(obj);
                        personAddressDisplayField3.up().setTitle(prmntHeaderTitle);

                    } else if (address['addressType']['code'] == 'OFC') {
                        officeAddress = true;
                        personAddressDisplayField4.setValue(AddressTpl.applyTemplate(obj));
                        personAddressDisplayField4.setModel(obj);
                        personAddressDisplayField4.up().setTitle(ofcHeaderTitle);

                    } else if (address['addressType']['code'] == 'GOOGLE') {
                        googleAddress = true;
                        personAddressDisplayField5.setValue(AddressTpl.applyTemplate(obj));
                        personAddressDisplayField5.setModel(obj);
                        personAddressDisplayField5.up().setTitle(googleHeaderTitle);

                    }
            	}
            });
        }else{
        	this$.enabledDisabledResetAddressDisplayField(personAddressDisplayField1);
        	this$.enabledDisabledResetAddressDisplayField(personAddressDisplayField2);
        	this$.enabledDisabledResetAddressDisplayField(personAddressDisplayField3);
        	this$.enabledDisabledResetAddressDisplayField(personAddressDisplayField4);
        	this$.enabledDisabledResetAddressDisplayField(personAddressDisplayField5);
        }


        //var printPersonalAddress1 = addressDetails.down('button#printPersonalAddress1');
        var modifyPersonalAddress1 = addressDetails.down('button#modifyPersonalAddress1');
        var isModify1 = this$.setAddressDisplayField(personAddressDisplayField1, 5, currentAddress, modifyPersonalAddress1);
       /* modifyPersonalAddress1.address = {};
        if(isModify1 == true){
        	modifyPersonalAddress1.address.isModify = true;
        } else {
        	modifyPersonalAddress1.address.isModify = false;
        }*/
       // var printPersonalAddress2 = addressDetails.down('button#printPersonalAddress2');
        var modifyPersonalAddress2 = addressDetails.down('button#modifyPersonalAddress2');
        var isModify2 = this$.setAddressDisplayField(personAddressDisplayField2, 6, correspondanceAddress, modifyPersonalAddress2);
       // modifyPersonalAddress2.address = {};
       /* if(isModify2 == true){
        	modifyPersonalAddress2.address.isModify = true;
        } else {
        	modifyPersonalAddress2.address.isModify = false;
        }*/
       // var printPersonalAddress3 = addressDetails.down('button#printPersonalAddress3');
        var modifyPersonalAddress3 = addressDetails.down('button#modifyPersonalAddress3');
        var isModify3 = this$.setAddressDisplayField(personAddressDisplayField3, 7, permanentAddress, modifyPersonalAddress3);
        /*modifyPersonalAddress3.address = {};
        if(isModify3 == true){
        	modifyPersonalAddress3.address.isModify = true;
        } else {
        	modifyPersonalAddress3.address.isModify = false;
        }*/
        //var printPersonalAddress4 = addressDetails.down('button#printPersonalAddress4');
        var modifyPersonalAddress4 = addressDetails.down('button#modifyPersonalAddress4');
        var isModify4 = this$.setAddressDisplayField(personAddressDisplayField4, 8, officeAddress, modifyPersonalAddress4);
       /* modifyPersonalAddress1.address = {};
        if(isModify4 == true){
        	modifyPersonalAddress4.address.isModify = true;
        } else {
        	modifyPersonalAddress4.address.isModify = false;
        }*/
        var modifyPersonalAddress5 = addressDetails.down('button#modifyPersonalAddress5');
        var isModify5 = this$.setAddressDisplayField(personAddressDisplayField5, 20, googleAddress, modifyPersonalAddress5);
        Ext.getBody().unmask();
    },
    /**
     * Enabled/Disabled and reset address display template if no data
     */
    enabledDisabledResetAddressDisplayField : function(personAddressDisplayField){
    	personAddressDisplayField.reset();
    },
    /*
     * Set address display field hide and show
     */
    setAddressDisplayField: function(personAddressDisplayField, addressType, addressExist, modifyAddress) {
    	if (addressExist) {
    		modifyAddress.setText(getCommonTranslation('MODIFY'));
    		//printAddress.setVisible(true);
    		modifyAddress.address = {};
    		modifyAddress.address.isModify = true;
    		
    	} else {
    		modifyAddress.setText(getCommonTranslation('ADD_ADDRESS'));
    		//printAddress.setVisible(false);
    		var object = new Object();
    		object.addressType = addressType;
    		personAddressDisplayField.setModel(object);
    		modifyAddress.address = {};
    		modifyAddress.address.isModify = false;
    	}
    },
    /*
     *  change the url for hidden drop down field
     */
    setAddressTypeDropDown: function(value, addressdetailsform) {
        var addressTypeComboBox = addressdetailsform.down('#addressTypeId');
        addressTypeComboBox.store.getProxy().api.read = SERVERURL.PERSON_ADDRESS_TYPE_COMBO_STORE;
        addressTypeComboBox.store.load({
            callback: function(records, operation, success) {
                if (success) {
                    addressTypeComboBox.setValue(value);
                }
            }
        });
    },

    /*
     *  On Add/modify click address form shown. value set to form
     */
    onModifyClick: function(addressDisplayField, addressDetailsItemId, addressWindowItemId) {
        var this$ = this;
        // Enable Form.
        var personProfile = this$.getContentPanelActiveTab();
        var addressDetails = personProfile.down(addressDetailsItemId);
        if(addressDetails == undefined || isNullOrEmpty(addressDetails)){
        	addressDetails = personProfile;
        }
        
    	var portalId = this$.getCurrentLoggedPortalId();
        if(portalId != 2 && portalId != 3) {
        	try {
            	personProfile.getApplicationId();
    		} catch(e){
    			//-- code changed for multiple tabs functionality for applicant portal
                if(Ext.isDefined(Ext.ComponentQuery.query('addressdetails')))
                {
                	addressDetails = Ext.ComponentQuery.query('addressdetails')[0];
                }
                else
                {
                	addressDetails=this$.getContentPanel().items.items[1];
                }
    			//addressDetails = this$.getContentPanel().items.items[1];
    		}
        }
        
        var personAddressDisplayField = addressDetails.down(addressDisplayField);
        var addressFormWindow = Ext.widget('addressformwindow', {
            itemId: addressWindowItemId
        });
        addressFormWindow.show();
        addressFormWindow.center();
        var addressTypeComboBox = addressFormWindow.down('#addressTypeId');
        addressTypeComboBox.setReadOnly(true);
        var cityIdText = addressFormWindow.down('#cityIdText');
        cityIdText.setVisible(false);
        cityIdText.allowBlank = true;
        var parentCountryRegionIdText = addressFormWindow.down('#parentCountryRegionIdText');
        parentCountryRegionIdText.setVisible(false);
        parentCountryRegionIdText.allowBlank = true;
        var countryIdText = addressFormWindow.down('#countryIdText');
        countryIdText.setVisible(false);
        countryIdText.allowBlank = true;
        var data = personAddressDisplayField.getModel();
        var addressDetailsform = addressFormWindow.down('#personAddressFieldsForm');
        //current address
        if(!isNullOrEmpty(data) && (data.addressType == 5 || (data && data.address && !isNullOrEmpty(data.address) && data.address.addressType.id == 5) ||
        		(data && data.address && !isNullOrEmpty(data.address) && data.address.addressType == 5))){

        	var addressOtherLnguage = addressDetailsform.down('#addressOtherLanguageId');
        	addressOtherLnguage.setVisible(true);

        	var addressOtherLanguageId = ['addressOtherLanguageId'];
        	var academyLocationId = this.getCurrentAcademyLocation();

        	Ext.Ajax.request({
        		url: SERVERURL.COMMON_FORM_FIELD_INFO,
        		method: 'GET',
        		async: false,
        		params: {
        			academyLocationId:academyLocationId,
        			languageCode:'en'
        		},
        		success: function(response) {
        			var json = JSON.parse(response.responseText);
        			var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
        			fieldInfo.set("formFieldsInfo", json);
        			if( !isNullOrEmpty(json) ){
        				if( !isNullOrEmpty(json.addressformwindow) ){
        					var addressformwindowDFRConfig = json.addressformwindow;
        					for( i in addressformwindowDFRConfig){
        						var fieldConfig = addressformwindowDFRConfig[i];
        						if( addressOtherLanguageId.includes(fieldConfig.formFieldId) ){
        							if(!fieldConfig.isVisible){
        								addressOtherLnguage.setVisible(false);
        							}
        						}
        					}
        				}
        			}
        		}
        	});
        } else if(!isNullOrEmpty(data) && (data.addressType == 20  || (data && data.address && !isNullOrEmpty(data.address) && data.address.addressType.id == 20) ||
        		(data && data.address && !isNullOrEmpty(data.address) && data.address.addressType == 20))){

        	var addressOtherLnguage = addressDetailsform.down('#addressOtherLanguageId');
        	addressOtherLnguage.setVisible(true);

        	var addressOtherLanguageId = ['addressOtherLanguageId'];
        	var academyLocationId = this.getCurrentAcademyLocation();
        	
        	Ext.Ajax.request({
        		url: SERVERURL.COMMON_FORM_FIELD_INFO,
        		method: 'GET',
        		async: false,
        		params: {
        			academyLocationId:academyLocationId,
        			languageCode:'en'
        		},
        		success: function(response) {
        			var json = JSON.parse(response.responseText);
        			var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
        			fieldInfo.set("formFieldsInfo", json);
					addressDetailsform.down('#pincodeId').setFieldLabel(getPersonModuleTranslation('GOOGLE_ADDRESS_ZIP_CODE'));
        			var allFields = addressDetailsform.query('[isFormField=true]');
        			Ext.each(allFields, function(currentField){
        				if(currentField.itemId != "addressText" && currentField.itemId != "countryIdText" && currentField.itemId != "parentCountryRegionIdText" && currentField.itemId != "cityIdText" && currentField.itemId != "pincodeId"){
        					currentField.hide();
        					this$.setAllowBlank(currentField, true);
        				}
        				else{
        					if( !isNullOrEmpty(json) ){
                				if( !isNullOrEmpty(json.addressformwindow) ){
                					var addressformwindowDFRConfig = json.addressformwindow;
                					for( i in addressformwindowDFRConfig){
                						var fieldConfig = addressformwindowDFRConfig[i];
                						if(fieldConfig.formFieldId == 'addressText' && fieldConfig.isVisible == true && currentField.itemId == 'addressText'){
                							currentField.show();
                						}
                						if(fieldConfig.formFieldId == 'pincodeId' && fieldConfig.isVisible == true && currentField.itemId == 'pincodeId'){
                							currentField.show();
                						}
                						if(fieldConfig.formFieldId == 'countryIdText' && fieldConfig.isVisible == true && currentField.itemId == 'countryIdText'){
                							currentField.show();
                						}
                						if(fieldConfig.formFieldId == 'parentCountryRegionIdText' && fieldConfig.isVisible == true && currentField.itemId == 'parentCountryRegionIdText'){
                							currentField.show();
                						}
                						if(fieldConfig.formFieldId == 'cityIdText' && fieldConfig.isVisible == true && currentField.itemId == 'cityIdText'){
                							currentField.show();
                						}
                						if(fieldConfig.formFieldId == 'pincodeId' && fieldConfig.isMandatory == true){
                							addressDetailsform.down('#pincodeId').setFieldLabel(getPersonModuleTranslation('GOOGLE_ADDRESS_ZIP_CODE')+ '<span class="required" style="color:red"> *</span>');
                						}
                					}
                				}else{
                    				currentField.show();
                    			}
                			}
        				}
        			});
        			
        			/*var pincodeField = addressDetailsform.down('#pincodeId');
        			if (pincodeField && pincodeField.inputEl) {
        			    pincodeField.inputEl.dom.maxLength = 45;  // Set maxLength directly on the DOM element
        			}*/

        			addressDetailsform.down('#topFieldContainer').hide();
        			addressDetailsform.down('#addressPhoneFieldContainerId').hide();
        			addressDetailsform.down('#addressCellFieldContainerId').hide();
        			addressDetailsform.down('#geographicalAreaContainer').hide();
        			/*var field = addressDetailsform.down('#parentCountryRegionIdText');
        			field.allowBlank = false;  
        			field.validate();  */       

        			/*var field = addressDetailsform.down('#cityIdText');
        			field.allowBlank = false;  
        			field.validate();    */      
        			
        			addressDetailsform.down('#addressText').setFieldLabel(getPersonModuleTranslation('GOOGLE_ADDRESS_ADDRESS_TEXT')+ '<span class="required" style="color:red"> *</span>');
        			
        		}
        	});
        } else{
        	var addressOtherLnguage = addressDetailsform.down('#addressOtherLanguageId');
        	addressOtherLnguage.setVisible(false);
        	addressOtherLnguage.allowBlank = true;
        }
        var topFieldContainer = addressDetailsform.down('#topFieldContainer');
        var primaryAddress = {
            xtype: 'checkboxfield',
            labelAlign: 'right',
            boxLabel: getPersonModuleTranslation('COMMUNICATION_ADDRESS'),
            name: 'isPrimary',
            itemId:'communicationAddressItemId',
            cls:'checkBoxCstmAddressLabel',
            inputValue: true,
        	height:45,
            uncheckedValue: false,
            width:'235px !important',
            listeners:{
            	afterrender: function(adrsFld){
            		setTimeout(function(){
            			adrsFld.setWidth('235px !important');
            		},300);
            	}
            }
        };
        var legalAddress = {
                xtype: 'checkboxfield',
                labelAlign: 'right',
                boxLabel: getPersonModuleTranslation('LEGAL_ADDRESS'),
                name: 'isLegalAddress',
                itemId:'legalAddressItemId',
                inputValue: true,
                cls:'checkBoxCstmAddressLabel',
    			height:45,
                uncheckedValue: false,
                width:'235px !important',
                listeners:{
                	afterrender: function(adrsFld){
                		setTimeout(function(){
                			adrsFld.setWidth('235px !important');
                		},300);
                	}
                }
            };
        
        var addressData;
        if(addressDetails.addressTemplateData)
        	addressData = addressDetails.getAddressTemplateData();
        var isPrimary = false, addressType = null;
        if(!isEmpty(addressData)){
        	for(var i = 0; i< addressData.length; i++){
            	isPrimary = addressData[i].isPrimary;
            	if(isPrimary){
            		var type = addressData[i].address.addressType;
					//addressType = type.code;
					addressType = type;
					break;
				}
            }
        }
        var address = !isNullOrEmpty(data) ? data["address"] : "";
        
        if((!isPrimary && addressType == null) || 
        		(!isEmpty(address) && isPrimary && address.addressType == addressType)){
        	topFieldContainer.insert(0, primaryAddress);
        	legalAddress.margin = '0 0 0 10';
        }else{
        	addressDetailsform.insert(0, {
                xtype: 'hidden',
                name: 'isPrimary',
                value : false
            });
        }
        topFieldContainer.insert(1, legalAddress);
        var otherAddressType = addressDetailsform.down('#otherAddressTypeItemId');
        
        if (address) {
        	this$.mixins.AddressController.setIdFromNestedObject(address, "addressType");
        	this$.mixins.AddressController.setIdFromNestedObject(address, "country");
        	this$.mixins.AddressController.setIdFromNestedObject(address, "parentCountryRegion");
        	this$.mixins.AddressController.setIdFromNestedObject(address, "countryRegion");
            this$.mixins.AddressController.setIdFromNestedObject(address, "city");
            this$.mixins.AddressController.setIdFromNestedObject(address, "pincodeNew");
            var cityPinCodeId=addressDetailsform.down('#pincodeNewId');
            var cityId = data.address.city;
            cityPinCodeId.getStore().getProxy().setExtraParam('id', cityId);
            cityPinCodeId.getStore().load({
            	callback: function(records, operation, success) {
            		for(var i in records){
            			if(records[i].data.id == data.address.pincodeNew){
            				cityPinCodeId.setValue(records[i].data.id);
            				cityPinCodeId.defaultVal = records[i].data.id;
            			}
            		}
            	}
            });
            if(!isNullOrEmpty(data.address.pincodeNew)){
            	 cityPinCodeId.setValue(data.address.pincodeNew);
            	 cityPinCodeId.defaultVal = data.address.pincodeNew;
            }
            var countryId = address["country"];
            this$.setAddressTypeDropDown(address["addressType"], addressDetailsform);
            if (countryId) {
                this$.mixins.AddressController.setCountryDropDown(countryId, addressDetailsform);
//                this$.mixins.AddressController.setCityropDown(countryId, address["city"], addressDetailsform);
                this$.mixins.AddressController.setRegion1DropDown(countryId, address["parentCountryRegion"], addressDetailsform);
                this$.mixins.AddressController.setRegion2DropDown(address["parentCountryRegion"], address["countryRegion"], addressDetailsform);
                if(addressDetailsItemId=='#studentAddressDetails') {
                	addressDetailsform.down('#parentCountryRegionId').setDisabled(false);
                	if(address["parentCountryRegion"]) {
                		addressDetailsform.down('#cityId').setDisabled(false);
                	}
                	
                	///new code V2D-404777
                	if(address["countryRegion"]){
                		var countryRegion=addressDetailsform.down('#parentCountryRegionId');
                		var countryRegionStore=countryRegion.getStore();
                		if(countryId){
                			countryRegionStore.getProxy().extraParam={
                				cid: countryId
                			};
                		}
                		addressDetailsform.down('#cityId').setDisabled(false);
                		setTimeout(function() {
                			countryRegionStore.load({
                				callback: function(records, operation, success) {
                					if (success) {
                						var countryRegionField=addressDetailsform.down('#parentCountryRegionId');
                						if(Ext.isDefined(countryRegionField)){
                							countryRegionField.setValue(address["countryRegion"]);
                						}
                						var cityId=addressDetailsform.down('#cityId');
                						var cityStore=cityId.getStore();
                						if(address["countryRegion"]){
                							var countryRegion=address["countryRegion"];
                							cityStore.getProxy().extraParam={
                								id: countryRegion
                							};
                							cityStore.load({
                								callback: function(records, operation, success) {
                									if (success) {
                										cityId.setValue(address["city"]);
                									}}});
                						}
                					}
                				}
                			});
                		},500);
                	}
                	else if(address["parentCountryRegion"]) {
                		var countryRegion=addressDetailsform.down('#parentCountryRegionId');
                		var countryRegionStore=countryRegion.getStore();
                		if(countryId){
                			countryRegionStore.getProxy().extraParam={
                				cid: countryId
                			};
                		}
                		addressDetailsform.down('#cityId').setDisabled(false);
                		setTimeout(function() {
                			countryRegionStore.load({
                				callback: function(records, operation, success) {
                					if (success) {
                						var countryRegionField=addressDetailsform.down('#parentCountryRegionId');
                						if(Ext.isDefined(countryRegionField)){
                							countryRegionField.setValue(address["parentCountryRegion"]);
                						}
                						var cityId=addressDetailsform.down('#cityId');
                						var cityStore=cityId.getStore();
                						if(address["parentCountryRegion"]){
                							var countryRegion=address["parentCountryRegion"];
                							cityStore.getProxy().extraParam={
                								id: countryRegion
                							};
                							cityStore.load({
                								callback: function(records, operation, success) {
                									if (success) {
                										cityId.setValue(address["city"]);
                									}}});
                						}
                					}
                				}
                			});
                		},500);
                	}
                
                	
                }
            }
            var form = this.getPersonAddressFieldsForm();
        	var countryCodeField = form.down("#cellCountryCode");
        	var mobileField = form.down("#cellNo");
        	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, null);
        	
        	var countryCodeField = form.down("#phoneCountryCode");
            var phoneNoField = form.down("#phoneNoField");
            this.setMaximumMinimumDigitsForPhoneNoValidation(form, countryCodeField, phoneNoField, null);
       
            var parentCountryRegion = address["parentCountryRegion"];
            if (parentCountryRegion) {
                this$.mixins.AddressController.setCityropDown(parentCountryRegion, address["city"], addressDetailsform);
            }
            if(addressDetailsItemId=='#applicantAddressDetails'){
            	addressDetailsform.down('#parentCountryRegionId').setDisabled(false);
            	if(address["countryRegion"]){
            		var countryRegion=addressDetailsform.down('#parentCountryRegionId');
            		var countryRegionStore=countryRegion.getStore();
            		if(countryId){
            			countryRegionStore.getProxy().extraParam={
            				cid: countryId
            			};
            		}
            		addressDetailsform.down('#cityId').setDisabled(false);
            		setTimeout(function() {
            			countryRegionStore.load({
            				callback: function(records, operation, success) {
            					if (success) {
            						var countryRegionField=addressDetailsform.down('#parentCountryRegionId');
            						if(Ext.isDefined(countryRegionField)){
            							countryRegionField.setValue(address["countryRegion"]);
            						}
            						var cityId=addressDetailsform.down('#cityId');
            						var cityStore=cityId.getStore();
            						if(address["countryRegion"]){
            							var countryRegion=address["countryRegion"];
            							cityStore.getProxy().extraParam={
            								id: countryRegion
            							};
            							cityStore.load({
            								callback: function(records, operation, success) {
            									if (success) {
            										cityId.setValue(address["city"]);
            									}}});
            									
            						}
            					}
            				}
            			});
            		},500);
            	}
            	else if(address["parentCountryRegion"]) {
            		var countryRegion=addressDetailsform.down('#parentCountryRegionId');
            		var countryRegionStore=countryRegion.getStore();
            		if(countryId){
            			countryRegionStore.getProxy().extraParam={
            				cid: countryId
            			};
            		}
            		addressDetailsform.down('#cityId').setDisabled(false);
            		setTimeout(function() {
            			countryRegionStore.load({
            				callback: function(records, operation, success) {
            					if (success) {
            						var countryRegionField=addressDetailsform.down('#parentCountryRegionId');
            						if(Ext.isDefined(countryRegionField)){
            							countryRegionField.setValue(address["parentCountryRegion"]);
            						}
            						var cityId=addressDetailsform.down('#cityId');
            						var cityStore=cityId.getStore();
            						if(address["parentCountryRegion"]){
            							var countryRegion=address["parentCountryRegion"];
            							cityStore.getProxy().extraParam={
            								id: countryRegion
            							};
            							cityStore.load({
            								callback: function(records, operation, success) {
            									if (success) {
            										cityId.setValue(address["city"]);
            									}}});
            						}
            					}
            				}
            			});
            		},500);
            	}
            }
            
            if(!isNullOrEmpty(data.address.addressType)) {
            	otherAddressType.getStore().getProxy().setExtraParam('addressTypeId', data.address.addressType);
            }
        }
        else{
        	otherAddressType.getStore().getProxy().setExtraParam('addressTypeId', data.addressType);
        }
        otherAddressType.getStore().getProxy().setExtraParam('addressCategory', 'PERSON');
        otherAddressType.getStore().load();
    
        var form = addressDetailsform.getForm();
        //form.reset();
        addressFormWindow.setFormAddressData(data);
        form.setValues(data);
    	var addressTypeStore = addressTypeComboBox.getStore();
    	addressTypeStore.load({         		
            callback: function(records, operation, success) {
            	 for(var i in records){
					if(records[i].data.id == data.addressType){
						addressTypeComboBox.setValue(records[i].data.id);
					 }
				  }
               }
        });
        if(!isNullOrEmpty(address)){
        	form.setValues(address);
        }
        this$.loadDFRForAddressContactDetailVisibility(addressDetailsform);
    },
    loadDFRForAddressContactDetailVisibility: function(addressDetailsform){
    	var $this = this;
    	var primaryAddress=addressDetailsform.down('#communicationAddressItemId');
    	var legalAddress =addressDetailsform.down('#legalAddressItemId');
    	Ext.Ajax.request({
    		type: 'rest',
    		async: false,
    		url: SERVERURL.COMMON_FORM_FIELD_INFO,
    		params: {
    			screenName: 'addressformwindow',
    			academyLocationId: $this.getCurrentAcademyLocation(),
    			languageCode:'en'
    		},
    		method: 'GET',
    		success: function(res, action) {
    			var response = Ext.decode(res.responseText);
    			if( Object.keys(response).length > 0 ){
    				var records=response.addressformwindow;
    				for(i in records){  
    					if(Ext.isDefined(legalAddress) && records[i].formFieldInputType=='checkboxfield' && records[i].formFieldId=='legalAddressItemId' && records[i].isVisible==true || records[i].isMandatory == true){
    						legalAddress.setVisible(true);
    					}
    					
    					if(Ext.isDefined(primaryAddress) && records[i].formFieldInputType=='checkboxfield' && records[i].formFieldId=='communicationAddressItemId' && records[i].isVisible==true){
    						if(primaryAddress!=null){
    							primaryAddress.setVisible(true);
    						}
    					}
    					
    					if(Ext.isDefined(legalAddress) && records[i].formFieldInputType=='checkboxfield' && records[i].formFieldId=='legalAddressItemId' && records[i].isVisible==false){
    						legalAddress.setVisible(false);
    					}
    					if(Ext.isDefined(primaryAddress) && records[i].formFieldInputType=='checkboxfield' && records[i].formFieldId=='communicationAddressItemId' && records[i].isVisible==false){
    						if(primaryAddress!=null){
    							primaryAddress.setVisible(false);
    						}
    					}
    					
    					if(Ext.isDefined(legalAddress) && records[i].formFieldInputType=='checkboxfield' && records[i].formFieldId=='legalAddressItemId' && records[i].isMandatory == true){
    						legalAddress.setAllowBlank(true);
    					}
    					
    					if(Ext.isDefined(primaryAddress) && records[i].formFieldInputType=='checkboxfield' && records[i].formFieldId=='communicationAddressItemId' && records[i].isMandatory == true){
    						primaryAddress.setAllowBlank(true);
    					}
    					if(Ext.isDefined(legalAddress) && records[i].formFieldInputType=='checkboxfield' && records[i].formFieldId=='legalAddressItemId' && records[i].isMandatory == true){
    						legalAddress.setAllowBlank(true);
    					}
    					
    					if(Ext.isDefined(primaryAddress) && records[i].formFieldInputType=='checkboxfield' && records[i].formFieldId=='communicationAddressItemId' && records[i].isMandatory == true){
    						primaryAddress.setAllowBlank(true);
    					}
    				}
    			}else{
    				if(legalAddress!=null){
    					legalAddress.setVisible(true);
    				}
    				
    				if(primaryAddress!=null){
    					primaryAddress.setVisible(true);
    				}
    			}
    		}
    	});
    },
    /**
     * show person common window
     * @param informationType
     * @param formItemId
     */
    showPersonCommonWindow : function(formWindow, informationType, formItemId, isAdd){
    	var this$ = this;
    	var title = null, xtypeForm = null;
    	var winItemId = 'personCommonWindow';
    	if(!formWindow){
    		switch(informationType){
	    		case 'PARENT_GUARDIAN' : {//Parent_Guardian
		    		title = getPersonModuleTranslation('PARENT_GUARDIAN_DETAILS');
		    		xtypeForm = 'parentguardianform';
		    		break;
		    	}
    			case 'SIBLING' : {//SIBLING
		    		title = getPersonModuleTranslation('SIBLING_DETAILS');
		    		xtypeForm = 'siblingform';
		    		break;
		    	}
    			case 'IDENTITY_DETAILS' : {
		    		title = getPersonModuleTranslation('IDENTITY_DETAILS');
		    		xtypeForm = 'identitydetailsform';
		    		break;
		    	}
    			case 'FEE_PAYER_DETAILS': {
    		        title = getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS');
    		        xtypeForm = 'feepayerdetailform';
    		        
    		        break;
    		    }
    			case 'FACULTY_FAMILY_DETAIL' : {//Faculty Family Detail
		    		title = getPersonModuleTranslation('FAMILY_DETAILS');
		    		xtypeForm = 'facultyfamilydetailform';
		    		winItemI = 'facultyPersonCommonWindow';
		    		break;
		    	}
    			case 'APPLY_HOLDS' : {
		    		title = getCommonTranslation('APPLY_HOLD');
		    		xtypeForm = 'studentapplyholdsform';
		    		break;
		    	}
    			
    			case 'REMOVE_HOLDS' : {
		    		title = getCommonTranslation('REMOVE_HOLD');
		    		xtypeForm = 'studentremoveholdsform';
		    		break;
		    	}
    			
    			case 'LIVING_ARRANGEMENT_DETAILS' : {
		    		title = getCommonTranslation('LIVING_ARRANGEMENT');
		    		xtypeForm = 'livingarrangementdetailsform';
		    		break;
		    	}
    			
    			case 'VISA_FORM' : {
		    		title = getCommonTranslation('VISA');
		    		xtypeForm = 'visaform';


		    		break;
		    	}
		    	
		    	case 'PASSPORT_DETAILS' : {
		    		title = getPersonModuleTranslation('PASSPORT_DETAILS');
		    		xtypeForm = 'studentpassportdetailsform';
		    		var studentPassportDocumentGridStore=this.getStore('personinfo.common.personalinfo.StudentPassportDocumentGridStore');
		    		studentPassportDocumentGridStore.removeAll();
                    var studentPassportUrlGridStore=this.getStore('personinfo.common.personalinfo.StudentPassportUrlGridStore');
                    studentPassportUrlGridStore.removeAll();
		    		break;
		    	}
    			
    			case 'VISA_FORM' : {
		    		title = getCommonTranslation('ADD_VISA');
		    		xtypeForm = 'visaform';
		    		break;
		    	}
    			
    			case 'INSURANCE_FORM' : {
		    		title = getCommonTranslation('ADD_INSURANCE');
		    		xtypeForm = 'insuranceform';
		    		break;
		    	}
		    	case 'PASSPORT_DETAILS' : {
		    		title = getPersonModuleTranslation('PASSPORT_DETAILS');
		    		xtypeForm = 'studentpassportdetailsform';
		    		var studentPassportDocumentGridStore=this.getStore('personinfo.common.personalinfo.StudentPassportDocumentGridStore');
		    		studentPassportDocumentGridStore.removeAll();
                    var studentPassportUrlGridStore=this.getStore('personinfo.common.personalinfo.StudentPassportUrlGridStore');
                    studentPassportUrlGridStore.removeAll();
		    		break;
		    	}
		    	case 'PERMIT_DETAILS' : {
		    		title = getCommonTranslation('ADD_PERMIT');
		    		xtypeForm = 'permitdetailform';
		    		var permitDocumentGridStore = this$.getStore('personinfo.common.personalinfo.PermitDocumentGridStore');
		    		permitDocumentGridStore.removeAll();
                    var permitUrlDocumentGridStore = this$.getStore('personinfo.common.personalinfo.PermitUrlDocumentGridStore');
                    permitUrlDocumentGridStore.removeAll();
                    var applicantPermitDocumentGridStore = this$.getStore('personinfo.common.personalinfo.ApplicantPermitDocumentGridStore');
                    applicantPermitDocumentGridStore.removeAll();
                    var applicantPermitUrlDocumentGridStore = this$.getStore('personinfo.common.personalinfo.ApplicantPermitUrlDocumentGridStore');
                    applicantPermitUrlDocumentGridStore.removeAll();
		    		break;
		    	}
    			
		    	default :{
		    		break;
		    	}
	    	
    		}
    		
    		if(informationType == 'PARENT_GUARDIAN'){
    			formWindow = Ext.widget('personcommonwindow',{
        			title: title,
        			itemId : winItemId,
        			cls:informationType == 'PARENT_GUARDIAN'? 'horizontalScrollFixed': '',
   		     		y:50,
        			items: [{
        			 	xtype: xtypeForm,
        		     	itemId: formItemId
        			}]
        		});
    		}
    		else{
        		formWindow = Ext.widget('personcommonwindow',{
        			title: title,
        			itemId : winItemId,
   		     		y:50,
        			items: [{
        			 	xtype: xtypeForm,
        		     	itemId: formItemId
        			}]
        		});
    		}
        }
    	formWindow.show();
    	if(!isNullOrEmpty(isAdd) 
    			&& isAdd && informationType == 'SIBLING'){
    		var siblingForm = formWindow.down('#studentSiblingForm');
            this.onRenderHideInnerSiblingFormField(siblingForm);
            this.getPersonCommonWindow().doLayout();
		}
    	return formWindow;
    },
    /**
     * view person common window
     */
	viewPersonCommonWindow: function(form){
	    	
	    if (form) {
	        form.down('#submitButtonId').setVisible(false);
	        form = form.getForm();
	        toggleReadOnlyFormItems(form, true);
	    }
	},
	
	/**
     * Close person common window
     */
    closePersonCommonWindow: function() {
        var this$ = this;
        this$.getPersonCommonWindow().close();
    },
    
    /**
     *  Get Json for form submission
     */
    getJsonSubmitData: function(form) {

    	var this$ = this;
        var jsonFormFieldData = new Object();
        var formData = form.getValues();
        if (!isEmpty(formData)) {
        	var personObj = this$.getPersonObj();
            formData.person = personObj;

        }
        jsonFormFieldData = Ext.encode(formData);
        return jsonFormFieldData;
    },
    
    getJsonIdentityDetailsSubmitData: function(form,path) {

    	var this$ = this;
        var jsonFormFieldData = new Object();
        var formData = form.getValues();
        if (!isEmpty(formData)) {
        	var personObj = this$.getPersonObj();
            formData.person = personObj;
            
            if(!isNullOrEmpty(path)){
            var doc = {
            		path : path,
            		type:'DOCUMENT'
            };
            formData.documents = [doc];
            }else{
                formData.documents = null;
            }

        }
        delete formData.person.personType;
        delete formData.identityDetailsUploadPath;
        delete formData.module;
        jsonFormFieldData = Ext.encode(formData);
        return jsonFormFieldData;
    },
    
    /*
     *  Load store on grid renderer
     */
    loadGridStore: function(gridItemId, url) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var personObj = this$.getPersonObj();
        var grid = personProfile.down(gridItemId);
        if (grid) {
            var personId = personObj["id"];
            var store = grid.getStore();
            store.getProxy().api.read = url;
            store.getProxy().extraParams = {
            	personId: personId
            };
            store.load();
        }
    },
    /**
     * On select relationship combo value
     * @params combo
     * @params gridItemId
     * @params parentGuardianForm
     */
    onSelectRelationshipComboValue : function(combo, gridItemId, parentGuardianForm){
    	var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
        var store = grid.getStore();
        var relationship = combo.getValue();
        var record = store.findRecord('relationship', relationship);
        if(!isEmpty(record)){
        	combo.reset();
        	showWarningMessage(getPersonModuleTranslation('PARENT_GUARDIAN_DETAILS'), getPersonModuleTranslation('RELATIONSHIP_ALREADY_EXIST'));
        }else{
        	this$.onSelectionRelationShipSetMaritalStatusCombo(parentGuardianForm, relationship);
        }
    },
    /**
     * On select relationship combo value
     * @params combo
     * @params gridItemId
     * @params sibling
     */
    onSelectSiblingRelationshipComboValue : function(combo, gridItemId, siblingForm){    	        
    	var this$ = this;
        var relationship = combo.getValue();
        this$.onSelectionRelationShipSetGenderCombo(siblingForm, relationship);
    },
    /**
     * View student parent guardian history form window
     * @params gridItemId
     * @params formItemId
     * @params url
     */

    viewPersonParentGuardianFormWindow: function(gridItemId, formItemId, url) {
    	var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
        if (grid.getSelectionModel().getCount() > 0) {
        	var formWindow = this$.getPersonCommonWindow();
        	this.showPersonCommonWindow(formWindow, 'PARENT_GUARDIAN', formItemId);
        	var parentGuardianForm = this$.getPersonParentGuardianForm();
        	this$.viewParentGuardianFormWindow(grid, parentGuardianForm, url);
        } else {
            showWarningMessage(getPersonModuleTranslation('PARENT_GUARDIAN_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /**
     * edit student parent guardian history form window
     */
    editPersonParentGuardianFormWindow: function(gridItemId, formItemId, url) {

    	var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
        if (grid.getSelectionModel().getCount() > 0) {
        	var formWindow = this$.getPersonCommonWindow();
        	this.showPersonCommonWindow(formWindow, 'PARENT_GUARDIAN', formItemId);
        	var parentGuardianForm = this.getPersonParentGuardianForm();
        	this$.editParentGuardianFormWindow(grid, parentGuardianForm, url);
        	var countryCodeField = parentGuardianForm.down("#mobileCountryCode");
            var mobileField = parentGuardianForm.down("#cellNo");
            this$.setMaximumMinimumDigitsForMobileNoValidation(parentGuardianForm,countryCodeField,mobileField,null);
            countryCodeField = parentGuardianForm.down("#alternateMobileCountryCode");
            mobileField = parentGuardianForm.down("#alternateMobileNo");
            this$.setMaximumMinimumDigitsForMobileNoValidation(parentGuardianForm,countryCodeField,mobileField,null);
        	return formWindow;
        } else {
            showWarningMessage(getPersonModuleTranslation('PARENT_GUARDIAN_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
            return null;
        }
    },
    /**
     * delete student parent guardian history form window
     */
    deletePersonParentGuardianRecord: function(gridItemId, url) {
    	var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
        this$.deleteParentGuardianRecord(grid, url);
    },
    /**
     * save student parent guardian history form window
     */
    savePersonParentGuardian: function(personType, gridItemId, addUrl, updateUrl) {
    	
    	var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
        var personObj = this$.getPersonObj();
        var parentGuardianForm = this.getPersonParentGuardianForm();
        var personCommonWindow = this$.getPersonCommonWindow();
        this$.saveParentGuardian(personType, grid, personCommonWindow, parentGuardianForm, personObj, addUrl, updateUrl);
    },
    
    
    /**
     *  View parent guardian form window
     *  @param grid
     *  @param form
     *  @param relatedPersonUrl
     */
    viewParentGuardianFormWindow: function(grid, form, relatedPersonUrl) {
    	var this$ = this;
        this$.editParentGuardianFormWindow(grid, form, relatedPersonUrl);
        this$.viewPersonCommonWindow(form);
        
        setTimeout(function(){
       	 var photoFileImageParent = Ext.ComponentQuery.query('[name=photoFileImageSnapshot]')[0];
         photoFileImageParent.setDisabled(true);
    	},100);
    },
    /**
     * Edit parent guardian history form window
     *  @param grid
     *  @param form
     *  @param relatedPersonUrl
     */
    editParentGuardianFormWindow: function(grid, form, relatedPersonUrl) {
    	var this$ = this;
    	var records = grid.getSelectionModel().getSelection()[0];
        if (!isEmpty(records)) {
            var id = records.get("id");
            var params = {
                id: id
            };
            this$.sendGetAjaxRequest(relatedPersonUrl, 'GET', params, function(option, success, response) {
            	if(success){
            		var data = Ext.decode(response.responseText);
                    if (!isEmpty(data)) {

                       	if(!(isNullOrEmpty(data.relatedPerson.birthDate)))
						data.relatedPerson.birthDate = new Date(data.relatedPerson.birthDate);
                        form.getForm().setValues(data);
                        var formDetails = new Object();
                        formDetails["id"] = data["id"];
                        formDetails["version"] = data["version"];


                        if (!isEmpty(data['relatedPerson'])) {
                            var relatedPerson = data['relatedPerson'];
                            if(!isNullOrEmpty(relatedPerson.lastName)){
                            	relatedPerson.lastName = relatedPerson.lastName.trim();
                            }
                            var relationship = data['relationship'];
                            form.setRelatedPerson(relatedPerson);
                            if(!isNullOrEmpty(relatedPerson.isEmployeeOfOrganization)){
                            	if(relatedPerson.isEmployeeOfOrganization || relationship == "FATHER" || relationship == "MOTHER"){
                            		//form.down('#genderCombo').setReadOnly(true);
                            		//form.down('#maritalStatusCombo').setReadOnly(true);
                            	}
                            }
                            
                            //form.down('#haveAccessToLearnerId').setValue(data['relatedPerson'].haveAccessToLearner);
                            //form.down('#searchButtonId').setDisabled(true);
                            //form.down('#relationShipField').setReadOnly(true);
//                            form.down('#isEmployeeOrganisation').setReadOnly(true);
//                            form.down('#employeeIdField').setReadOnly(true);
                            //form.down('#submitButtonId').setDisabled(false);
                            form.getForm().setValues(relatedPerson);
                            
                        }
                        form.getForm().setValues(formDetails);
                        var gender = form.down("#genderCombo");
                        var maritalStatus = form.down("#maritalStatus");
                        var employmentStatus = form.down("#employmentStatus");
                        if (!isNullOrEmpty(relatedPerson.genderCSM) && !isNullOrEmpty(relatedPerson.genderCSM.id)) {
                        	gender.setValue(relatedPerson.genderCSM.id);
                        }
                        if (!isNullOrEmpty(relatedPerson.maritalStatusId) && !isNullOrEmpty(relatedPerson.maritalStatusId.id)) {
                        	maritalStatus.setValue(relatedPerson.maritalStatusId.id);
                        }
                        var haveAccessToLearner = form.down('#haveAccessToLearnerId');
                        if(relatedPerson.haveAccessToLearner) {
                        	haveAccessToLearner.items.items[0].setValue(true);
                        	haveAccessToLearner.items.items[1].setValue(false);
                        } else {
                        	haveAccessToLearner.items.items[0].setValue(false);
                        	haveAccessToLearner.items.items[1].setValue(true);
                        }
                        if (!isNullOrEmpty(relatedPerson.employmentStatus) && !isNullOrEmpty(relatedPerson.employmentStatus.id)) {
                        	employmentStatus.setValue(relatedPerson.employmentStatus.id);
                        }
                		var countryCodeFieldItemIDArray = ["#mobileCountryCode","#phoneCountryCode","#alternateMobileCountryCode"];
                		this$.setDefaultCountryCode(form, countryCodeFieldItemIDArray);
                		var relationship = data['relationship'];
                		if( relationship == "FATHER" || relationship == "MOTHER"){
                			this$.checkOtherLanguageFieldVisibility(form);
                    	}
                    }
            	}
                

            });//SERVERURL.PERSON_RELATIONSHIP_FORM_DETAILS
        }    
        
    },
    
    /**
     * Delete parent guardian history record
     * @param grid
     * @param deleteUrl
     */
    deleteParentGuardianRecord: function(grid, deleteUrl) {

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getPersonModuleTranslation('PARENT_GUARDIAN_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            var id = "";
                            if (!isNullOrEmpty(records[count].get("id"))) {
                                id = records[count].get("id");
                            }
                            Ext.Ajax.request({
                                type: 'rest',
                                url: deleteUrl,// SERVERURL.PERSON_RELATIONSHIP_DELETE,
                                method: 'DELETE',
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                params: {
                                    id: id
                                },
                                success: function(form, action) {
                                    grid.getStore().reload();
                                    showSuccessMessage(getPersonModuleTranslation('PARENT_GUARDIAN_DETAILS'), getPersonModuleTranslation('PARENTS_GUARDIANS_DELETE_SUCCESS'));
                                }
                            });
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getPersonModuleTranslation('PARENT_GUARDIAN_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }

    },
    /**
     *  Save parent guardian history
     *  @param grid
     *  @param personCommonWindow
     *  @param form
     *  @param personObj
     *  @param saveUrl
     *  @param updateUrl
     */
    saveParentGuardian: function(personType, grid, personCommonWindow, form, personObj, saveUrl, updateUrl) {
    	var this$ = this;
	    var submitUrl, isUpdate = false;
	     var isWindowClose = true;
	    if(form.getForm().isValid()){
	    	var values = form.getValues();
	    	 
	    	if (this$.validatePhone(values)) {
	    		var id = form.down('#pg_hidden_field');
			    if (isNullOrEmpty(id.getSubmitValue())) {
			        submitUrl = saveUrl; //SERVERURL.PERSON_RELATIONSHIP_ADD,
			        isUpdate = false;
			    } else {
			        submitUrl = updateUrl; //SERVERURL.PERSON_RELATIONSHIP_UPDATE,
			        isUpdate = true;
			    }
			    var jsonFormatFormData = this$.getParentGuardianJsonData(personType, form, personObj, isUpdate);
			    if (!isNullOrEmpty(jsonFormatFormData)) {
			    	this$.applyWindowMask();
			    	var isPersonRelationship = false;
			    	if(personType=="APPLICANT" && isUpdate==false) {
			    		isPersonRelationship = true;
			    	}
			    	form.down("#submitButtonId").setDisabled(true);
			    	this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
			        	if(success){
			        		if(!isNullOrEmpty(response.responseText)){
			        			var personId = response.responseText;
			        		}
			        		else{
			        			var personId = form.getRelatedPerson().id;
			        		}
			        		if(Ext.isDefined(form.down('#photoFileImageParent')) && !isNullOrEmpty(form.down('#photoFileImageParent').getValue())){
			        			isWindowClose = false;
			        			this$.saveUpdatePersonImage(personId,grid,personCommonWindow,isPersonRelationship,personType);
			            	}
			        		else{
				                grid.getStore().reload();
				                grid.getSelectionModel().deselectAll();
				        		personCommonWindow.close();
			        		}
			        		if(isWindowClose == true){
			        			this$.hideWindowMask();
				        		if(Ext.isDefined(personCommonWindow)){
	                                personCommonWindow.close();
	                            }
			        		}
			        		grid.getStore().load({
			        			callback: function(){
			        				this$.validateParentDetails(grid);
			        			}
			        		});
			                if (isUpdate) {
			                    showSuccessMessage(getPersonModuleTranslation('PARENT_GUARDIAN_DETAILS'), getPersonModuleTranslation('PARENTS_GUARDIANS_UPDATE_SUCCESS'));
			                } else {
			                    showSuccessMessage(getPersonModuleTranslation('PARENT_GUARDIAN_DETAILS'), getPersonModuleTranslation('PARENTS_GUARDIANS_ADD_SUCCESS'));
			                }
			    		}else{
			    			personCommonWindow.close();
			    			this$.hideWindowMask();
			        		grid.getStore().load({
			        			callback: function(){
			        				this$.validateParentDetails(grid);
			        			}
			        		});
			                this$.hideWindowMask();
			    		}
			        });
			    }
	    	}
	    	
	    }else{
	    	this$.hideWindowMask();
        	showWarningMessage(getPersonModuleTranslation('PARENT_GUARDIAN_DETAILS'), getPersonModuleTranslation('MANDATORY_FIELDS_NOT_FILLED'));
        }	    
    },
    
    saveUpdatePersonImage: function(personId,grid,personCommonWindow,isPersonRelationship,personType){
		var this$ = this;
		var portalId = this$.getCurrentLoggedPortalId();
		var userInfo = Academia.model.authentication.UserInfoModel;
		var access_token = userInfo.get("accessToken");
		var url = 'rest/personImage/uploadeB64Image?access_token='+access_token;
		var fileName = '1.png';
    	if(Ext.isDefined(localStorage.getItem('parentDataURL')) && !isNullOrEmpty(localStorage.getItem('parentDataURL'))){
    		//upload snapshot
    		var dataUrl = localStorage.getItem('parentDataURL');
			var form = new FormData();
			form.append('file', dataUrl);
			form.append('fileName', fileName);
			form.append('personId', personId);
			if(personType=='APPLICANT') {
				form.append('isApplicant', true);
			}
			var xhr = new XMLHttpRequest();
			xhr.open('POST', url, true);
			xhr.onreadystatechange = function (resp) {
				if(resp.currentTarget.readyState==4){
					var responseText = Ext.decode(resp.currentTarget.responseText);
					/*if(responseText.success){
						console.log(responseText.path);
					}*/
					localStorage.setItem('parentDataURL','');
					grid.getStore().load();
					grid.getSelectionModel().deselectAll();
	        		personCommonWindow.close();
				}
			};
			xhr.send(form);
    	}
    	else {
    		//upload photo
    		var mainForm = this$.getPersonParentGuardianForm().down('#parentImageInnerForm');
        	var photoFileImage = mainForm.down('#photoFileImageParent');
        	var fileUploadPath = photoFileImage.getValue();
        	
        	if(!isNullOrEmpty(fileUploadPath)){
        		var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
        		if (extension == "gif" || extension == "png" || extension == "bmp"
                    || extension == "jpeg" || extension == "jpg") {
        			var activePanel = this$.getActiveTabfromContentPanel();
        			var parameter = null;
                	if(!isNullOrEmpty(activePanel) && !isNullOrEmpty(activePanel.body) && !isNullOrEmpty(activePanel.body.id) && ( activePanel.body.id.split('-')[0]=='applicantprofile' || portalId==6)) {
                		parameter = {
                			personId : personId, 
                			isApplicant : true,
                			isPersonRelationship : isPersonRelationship
                    	}
                	} else {
                		parameter = {
                    			personId : personId,
                    			isApplicant : false,
                    			isPersonRelationship : isPersonRelationship
                        	}
                	}
                	// setTimeout(function() {
        				 mainForm.getForm().submit({
             	        	method : 'POST',
             	        	url : SERVERURL.PERSON_IMAGE_UPLOAD_PARENT,
             	        	params:parameter,
             	        	success : function(form, action){
             	        		//var photoUrl=action.result.path;
             	        		localStorage.setItem('parentDataURL','');
             	        		grid.getStore().load();
             	        		grid.getSelectionModel().deselectAll();
             	        		if(Ext.isDefined(personCommonWindow)){
     			        			personCommonWindow.close();
     			        		}
             	        	},
                            failure: function(form, action) {
                            var  msg = getCommonTranslation('UPLOAD_FILE_TYPE_IS_INVALID');
                            showWarningMessage(getCommonTranslation('ALERT'), msg);
                            if (Ext.isDefined(personCommonWindow)) {
                            personCommonWindow.close();
                            }
                          }

             	        });			       
        		}else{
        			photoFileImage.reset();
        			showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_VALID_FILE'));
        		}
        		
        	}
    	}
    },
    
    /**
     * Get parent guardian jsondata
     * @param form
     * @param personObj
     * @param relatedPersonObj
     * @param isUpdate
     */
    getParentGuardianJsonData: function(personType, form, personObj, isUpdate) {
    	var $this = this;
        var jsonFormFieldData = new Object();
        var formData = form.getValues();

        if (!isEmpty(formData)) {        	
            jsonFormFieldData.relationship = formData.relationship;
            jsonFormFieldData.id = formData.id;
            jsonFormFieldData.version = formData.version;
            var person = new Object();
            person.id = personObj["id"];
            jsonFormFieldData.person = person;
            var relatedPerson = new Object();
            if(Ext.app.checkVelocity || Ext.app.checkVelocity=="true"){
            	if(isNullOrEmpty(formData.mobileNumber)){
            		formData.mobileCountryCode="";
            	}
            	if(isNullOrEmpty(formData.phoneNo)){
            		formData.phoneCountryCode="";
            	}
            	if(isNullOrEmpty(formData.alternateMobileNo)){
            		formData.alternateMobileCountryCode="";
            	}
            	if(isNullOrEmpty(formData.externalEmployeeId)){
            		formData.externalEmployeeId="";
            	}
            }
            if(!isNullOrEmpty(formData.customData)) {
            	relatedPerson.customData = formData.customData;
            }
            relatedPerson.emailId = formData.emailId;
            relatedPerson.enableEmailCommunication = formData.enableEmailCommunication;
            relatedPerson.mobileCountryCode = formData.mobileCountryCode;
            relatedPerson.mobileNumber = formData.mobileNumber;
            var value = form.down('#isMobUseForCommunicationField').value;  
            relatedPerson.isMobUseForCommunication = value;
             var gender = form.down('#genderCombo').value;  
            relatedPerson.gender = gender;
            
            relatedPerson.externalEmployeeId = formData.externalEmployeeId;
            relatedPerson.phoneAreaCode = formData.phoneAreaCode;
            relatedPerson.phoneCountryCode = formData.phoneCountryCode;
            relatedPerson.phoneNo = formData.phoneNo;
            relatedPerson.isPhoneUseForCommunication = formData.isPhoneUseForCommunication;
            
            relatedPerson.personalIncome = formData.personalIncome;
            if(!isNullOrEmpty(formData.alternateMobileCountryCode) && !isNullOrEmpty(formData.alternateMobileNo)){
            	relatedPerson.alternateMobileCountryCode = formData.alternateMobileCountryCode;
            	relatedPerson.alternateMobileNo = formData.alternateMobileNo;
            	//relatedPerson.isAlternateMobUseForCommunication = formData.isAlternateMobUseForCommunication;
            }
            
            relatedPerson.isAlternateMobUseForCommunication = formData.isAlternateMobUseForCommunication;
            
        	/*if(Ext.isDefined(form.down('#photoFileImageParent')) && !isNullOrEmpty(form.down('#photoFileImageParent').getValue())){
        		if(!isNullOrEmpty(localStorage.getItem('parentDataURL'))){
        			relatedPerson.photoUrl = localStorage.getItem('parentDataURL');
        		}
        	}*/
            
            if(Ext.isDefined(form.down('#photoFileImageParent')) && isNullOrEmpty(form.down('#photoFileImageParent').getValue())){
            	relatedPerson.photoUrl = formData.photoUrl;
            }
            
            if(!isNullOrEmpty(formData.alternateMobileNo)){
            	
            	relatedPerson.alternateMobileNo = formData.alternateMobileNo;
            	
            }
            
            relatedPerson.businessName = formData.businessName;
            relatedPerson.vehicleLicenseNo = formData.vehicleLicenseNo;
            relatedPerson.haveAccessToLearner = formData.haveAccessToLearner;
            
            relatedPerson.isEmergencyContact = formData.isEmergencyContact;
            relatedPerson.parentDesignation = formData.parentDesignation;
            relatedPerson.position = formData.position;
            
            var relatedPersonObj = form.getRelatedPerson();
            if (!isNullOrEmpty(relatedPersonObj)) {
            	relatedPerson.id = relatedPersonObj["id"];
                relatedPerson.version = relatedPersonObj["version"];
                relatedPerson.isDeleted = relatedPersonObj["isDeleted"];
                relatedPerson.shortName = relatedPersonObj["shortName"];
                if(formData.isEmployeeOfOrganization){
                    if( relatedPersonObj["employeeId"])
                    	relatedPerson.employeeId = relatedPersonObj["employeeId"];
                    else
                    	relatedPerson.employeeId = relatedPersonObj["id"];
                }
            	if(personType == 'APPLICANT'){
            		if(!isUpdate){
            			relatedPerson.id = null;
                        relatedPerson.version = null;
                        relatedPerson.isDeleted = false;
                        relatedPerson.shortName = null;
            		}
                	relatedPerson.status = "ACTIVE";
                }
            } else {
            	relatedPerson.id = null;
                relatedPerson.version = null;
                relatedPerson.isDeleted = false;
                relatedPerson.shortName = null;
                if(personType == 'APPLICANT'){
                	relatedPerson.status = "ACTIVE";
                }
            }
            
            var genderId = {};
            Ext.Ajax.request({
  			   type : 'rest',
  			   url : SERVERURL.PATH_GENDER_FIND_ALL,
  			   method : 'GET',
  			   async:false,
  			   success : function(response, action) {
  				 var data = Ext.decode(response.responseText);
  				 for(var i=0;i<data.length;i++){
  					if(data[i].id == gender){
                        genderId = {
                                id: gender,
                                code:data[i].code,
                                value:data[i].value
                            };
                    }
  				 }
  			   }
  		   });
            var maritalStatusObj = {};
            Ext.Ajax.request({
  			   type : 'rest',
  			   url : SERVERURL.PATH_FIND_ALL_MARITAL_STATUS,
  			   method : 'GET',
  			   async:false,
  			   success : function(response, action) {
  				 var data = Ext.decode(response.responseText);
  				 for(var i=0;i<data.length;i++){
  					 if(data[i].id == formData.maritalStatus){
  						maritalStatusObj = {
  				                 id: formData.maritalStatus,
  				                 code:data[i].code,
  				                 value:data[i].value
  				             };
  					 }
  				 }
  			   }
  		   });
  		    var employmentStatusObj = {};
            Ext.Ajax.request({
  			   type : 'rest',
  			   url : SERVERURL.FIND_ALL_EMPLOYMENT_STATUS_CSM,
  			   method : 'GET',
  			   async:false,
  			   success : function(response, action) {
  				 var data = Ext.decode(response.responseText);
  				 for(var i=0;i<data.length;i++){
  					 if(data[i].id == formData.employmentStatus){
  						employmentStatusObj = {
  				                 id: formData.employmentStatus,
  				                 code:data[i].code,
  				                 value:data[i].value
  				             };
  					 }
  				 }
  			   }
  		   });
            if(formData.salutation == undefined || isNullOrEmpty(formData.salutation)|| isNullOrEmpty(formData.salutation.id)){
            	delete relatedPerson.salutation;
            }else{
            	relatedPerson.salutation = formData.salutation;
            }
            relatedPerson.firstName = formData.firstName;
            relatedPerson.middleName = formData.middleName;
            relatedPerson.lastName = formData.lastName;
            relatedPerson.birthDate = formData.birthDate;
            relatedPerson.occupation = formData.occupation;
            relatedPerson.personalIncome = formData.personalIncome;
            relatedPerson.genderCSM =genderId;
            if(isNullOrEmpty(relatedPerson.genderCSM.id)){
            	 relatedPerson.genderCSM=null;
            }
            if(isNullOrEmpty(formData.maritalStatus)){
            	relatedPerson.maritalStatus = null;
            }else{
				relatedPerson.maritalStatusId = maritalStatusObj;
			}
            
            relatedPerson.bloodGroup = formData.bloodGroup;
            if(isNullOrEmpty(relatedPerson.bloodGroup)){
				relatedPerson.bloodGroup = null;
			}
            relatedPerson.isEmployeeOfOrganization = formData.isEmployeeOfOrganization;
            relatedPerson.firstNameOtherLanguage = formData.firstNameOtherLanguage;
            relatedPerson.middleNameOtherLanguage = formData.middleNameOtherLanguage;
            relatedPerson.lastNameOtherLanguage = formData.lastNameOtherLanguage;

            jsonFormFieldData.relatedPerson = relatedPerson;
            
            relatedPerson.isAlumnus = formData.isAlumnus;
            relatedPerson.schoolAttended = formData.schoolAttended;
            relatedPerson.nationalID = formData.nationalID;
            if(isNullOrEmpty(formData.schoolAttended) || relatedPerson.isAlumnus == 'false'){
            	relatedPerson.schoolAttended = null;
            }else{
				relatedPerson.schoolAttended = formData.schoolAttended;
			}
            
            if(isNullOrEmpty(formData.nationalID)){
            	relatedPerson.nationalID = null;
            }else{
				relatedPerson.nationalID = formData.nationalID;
			}
            if(personType == 'STUDENT'){
            	relatedPerson.isDeceased = formData.isDeceased;
            }
            if(isNullOrEmpty(formData.employmentStatus)){
            	relatedPerson.employmentStatus = null;
            }else{
				relatedPerson.employmentStatus = employmentStatusObj;
			}
        }
        var SiblingDetailForParent =  this.saveJsonSiblingDetailForParent(formData,relatedPerson.id,form);
        jsonFormFieldData.siblingAssociationDetails = SiblingDetailForParent;
        jsonFormFieldData = Ext.encode(jsonFormFieldData);
        return jsonFormFieldData;
    },
    
    /**
     * on render show hide parent guardian field
     * @param parentGuardianForm
     * @param disabled
     */
    onRenderHideInnerParentGuardianFormField : function(parentGuardianForm){
    	if(parentGuardianForm){
    		var primaryeEmailId = parentGuardianForm.down('#primaryeEmailId');
            var photoFileImage = parentGuardianForm.down('#photoFileImage');
            var isEmployeeOrganisation = parentGuardianForm.down('#isEmployeeOrganisation');
            
            if(Ext.isDefined(isEmployeeOrganisation)){
            	if(isEmployeeOrganisation.boxLabel.length>30){
            		isEmployeeOrganisation.setWidth(450);
            	}else{
            		isEmployeeOrganisation.setWidth(256);
            	}
            }
            
            photoFileImage.allowBlank = true;
            photoFileImage.setDisabled(true);
            photoFileImage.setVisible(false);
            
            //Remove code
            /*var cellCountryCode = parentGuardianForm.down('#cellCountryCode');
            cellCountryCode.allowBlank = true;
            cellCountryCode.setDisabled(true);
            cellCountryCode.setVisible(false);*/
            
            
           /* 
            	commented by rupesh
            var cellNo = parentGuardianForm.down('#cellNo');
            primaryeEmailId.allowBlank = true;
         
            cellNo.allowBlank = true;
            primaryeEmailId.setDisabled(true);
            cellNo.setDisabled(true);
            primaryeEmailId.setVisible(false);
            cellNo.setVisible(false);*/
            
            parentGuardianForm.doLayout();
    	}
    	
    },
    
    
    /**
     * On change employee ID , disable inner form details
     */
    
    onChangeDisabledInnerParentGuardianForm : function(parentGuardianForm){
    	if(parentGuardianForm){
    		var id = parentGuardianForm.down('#pg_hidden_field');
    	    if (isNullOrEmpty(id.getSubmitValue())) {
    	    	var innerForm = parentGuardianForm.down('#parentGuardianInfoItemField');
        		innerForm.getForm().reset();
        		innerForm.setDisabled(true);
        		parentGuardianForm.down('#submitButtonId').setDisabled(true);
    	    }
    	    // By Default Set bellow checkboxes as checked Issue: V2D-41278
    	    if(parentGuardianForm.itemId=='studentParentGuardianForm'){
    		    var isMobileAvalaibleForCommunicationField = parentGuardianForm.down('#isMobUseForCommunicationField');
    		    var isPhoneAvalaibleForCommunicationField = parentGuardianForm.down('#isPhoneUseForCommunicationField');
    		    var isAlternateMobileAvalaibleForCommunicationField = parentGuardianForm.down('#isAlternateMobUseForCommunicationField');
    		    
    		    if( !isNullOrEmpty(isMobileAvalaibleForCommunicationField) ){
    		    	isMobileAvalaibleForCommunicationField.setValue(true);
    		    }
    		    if( !isNullOrEmpty(isPhoneAvalaibleForCommunicationField) ){
    		    	isPhoneAvalaibleForCommunicationField.setValue(true);
    		    }
    		    if( !isNullOrEmpty(isAlternateMobileAvalaibleForCommunicationField) ){
    		    	isAlternateMobileAvalaibleForCommunicationField.setValue(true);
    		    }
    		    var countryCodeFieldItemIDArray = ["#mobileCountryCode","#phoneCountryCode","#alternateMobileCountryCode"];
    		    this.setDefaultCountryCode(parentGuardianForm, countryCodeFieldItemIDArray);
    	    }
    	}
    },
    onChangeEmployeeOrgField: function(parentGuardianForm, checkValue) {
        if(parentGuardianForm){
        	var innerForm = parentGuardianForm.down('#parentGuardianInfoItemField');
        	var employeeIdSearchField = parentGuardianForm.down('#employeeIdSearchField');
        	var employeeIdField = parentGuardianForm.down('#employeeIdField');
        	var id = parentGuardianForm.down('#pg_hidden_field');
        	var relationship = parentGuardianForm.down('#relationShipField').getValue();
        	
        	if(parentGuardianForm.itemId=='facultyFamilyDetailForm'){
        		if (isNullOrEmpty(id.getSubmitValue())) {
        			employeeIdField.setValue('');
        			if (checkValue) {
        				employeeIdSearchField.setVisible(true);
        				employeeIdSearchField.setDisabled(false);
        				innerForm.setDisabled(true);
        			} else {
        				employeeIdSearchField.setVisible(false);
        				employeeIdSearchField.setDisabled(true);
        				innerForm.setDisabled(false);
        			}
        			innerForm.getForm().reset();
        			parentGuardianForm.setRelatedPerson(null);
        			//this.onSelectionRelationShipSetGenderCombo(parentGuardianForm, relationship);
        			//this.onSelectionRelationShipSetMaritalStatusCombo(parentGuardianForm, relationship);
        		} else {
        			if (checkValue) {
        				employeeIdSearchField.setVisible(true);
        				employeeIdSearchField.setDisabled(false);
        				innerForm.setDisabled(false);
        			} else {
        				employeeIdSearchField.setVisible(false);
        				employeeIdSearchField.setDisabled(true);
        				innerForm.setDisabled(false);
        				//this.onSelectionRelationShipSetGenderCombo(parentGuardianForm, relationship);
        				//this.onSelectionRelationShipSetMaritalStatusCombo(parentGuardianForm, relationship);
        			}
        		}
        		var isMobileAvalaibleForCommunicationField = parentGuardianForm.down('#isMobUseForCommunicationField');
        		var isPhoneAvalaibleForCommunicationField = parentGuardianForm.down('#isPhoneUseForCommunicationField');
        		var isAlternateMobileAvalaibleForCommunicationField = parentGuardianForm.down('#isAlternateMobUseForCommunicationField');

        		if( !isNullOrEmpty(isMobileAvalaibleForCommunicationField) ){
        			isMobileAvalaibleForCommunicationField.setValue(true);
        		}
        		if( !isNullOrEmpty(isPhoneAvalaibleForCommunicationField) ){
        			isPhoneAvalaibleForCommunicationField.setValue(true);
        		}
        		if( !isNullOrEmpty(isAlternateMobileAvalaibleForCommunicationField) ){
        			isAlternateMobileAvalaibleForCommunicationField.setValue(true);
        		}
        		var countryCodeFieldItemIDArray = ["#mobileCountryCode","#phoneCountryCode","#alternateMobileCountryCode"];
        		this.setDefaultCountryCode(parentGuardianForm, countryCodeFieldItemIDArray);
        	}
        	else{
        		if (isNullOrEmpty(id.getSubmitValue())) {
        			employeeIdField.setValue('');
        			if (checkValue) {
        				employeeIdSearchField.setVisible(true);
        				employeeIdSearchField.setDisabled(false);
        				innerForm.setDisabled(true);
        				employeeIdField.allowBlank = false;
        				employeeIdField.setFieldLabel(getPersonModuleTranslation('USER_ID') + '<span class="required" style="color:red"> *</span>');
        			} else {
        				employeeIdSearchField.setVisible(false);
        				employeeIdSearchField.setDisabled(true);
        				innerForm.setDisabled(false);
        				employeeIdField.setValue('');
        				employeeIdField.allowBlank = true;
        			}
        			innerForm.getForm().reset();
        			parentGuardianForm.setRelatedPerson(null);
        			parentGuardianForm.isValid();
//        			this.onSelectionRelationShipSetGenderCombo(parentGuardianForm, relationship);
        			this.onSelectionRelationShipSetMaritalStatusCombo(parentGuardianForm, relationship);
        		} else {
        			if (checkValue) {
        				employeeIdSearchField.setVisible(true);
        				employeeIdSearchField.setDisabled(false);
        				innerForm.setDisabled(false);
        				employeeIdField.allowBlank = false;
        				employeeIdField.setFieldLabel(getPersonModuleTranslation('USER_ID') + '<span class="required" style="color:red"> *</span>');
        			} else {
        				employeeIdSearchField.setVisible(false);
        				employeeIdSearchField.setDisabled(true);
        				innerForm.setDisabled(false);
        				employeeIdField.setValue('');
        				employeeIdField.allowBlank = true;
//        				this.onSelectionRelationShipSetGenderCombo(parentGuardianForm, relationship);
        				this.onSelectionRelationShipSetMaritalStatusCombo(parentGuardianForm, relationship);
        			}
        			parentGuardianForm.isValid();

        		}
        		// By Default Set bellow checkboxes as checked Issue: V2D-41278
        		if(parentGuardianForm.itemId=='studentParentGuardianForm'){
        			var isMobileAvalaibleForCommunicationField = parentGuardianForm.down('#isMobUseForCommunicationField');
        			var isPhoneAvalaibleForCommunicationField = parentGuardianForm.down('#isPhoneUseForCommunicationField');
        			var isAlternateMobileAvalaibleForCommunicationField = parentGuardianForm.down('#isAlternateMobUseForCommunicationField');

        			if( !isNullOrEmpty(isMobileAvalaibleForCommunicationField) ){
        				isMobileAvalaibleForCommunicationField.setValue(true);
        			}
        			if( !isNullOrEmpty(isPhoneAvalaibleForCommunicationField) ){
        				isPhoneAvalaibleForCommunicationField.setValue(true);
        			}
        			if( !isNullOrEmpty(isAlternateMobileAvalaibleForCommunicationField) ){
        				isAlternateMobileAvalaibleForCommunicationField.setValue(true);
        			}
        			var countryCodeFieldItemIDArray = ["#mobileCountryCode","#phoneCountryCode","#alternateMobileCountryCode"];
        			this.setDefaultCountryCode(parentGuardianForm, countryCodeFieldItemIDArray);
        		}
        	}
        }
    },
    /**
     *  Enabled/Disabled inner Parent guardian Form
     */
    enabledDisabledInnerParentGuardianForm : function(parentGuardianForm, checkValue){
    	
    	var innerForm = parentGuardianForm.down('#parentGuardianInfoItemField');
    	var employeeIdSearchField = parentGuardianForm.down('#employeeIdSearchField');
    	if (checkValue) {
    		employeeIdSearchField.setVisible(true);
    		employeeIdSearchField.setDisabled(false);
    		innerForm.setDisabled(false);
        } else {
    		innerForm.setDisabled(true);
        }
    	innerForm.getForm().reset();
    },

    /**
     * On render parent guardian relationship combo
     * @param combo
     */
    onRenderParentGuardianRelationShipCombo: function(combo,relationShipComboPermissionMap) {
        combo.store.clearFilter(true);
        var user=this.getCurrentlyLoggedInUser();
        if(user.code!="sysadmin"){
        	var associatedAcadLocationIds = new Array();
        	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, relationShipComboPermissionMap);
        	Ext.each(permissionList, function(privilege) {
        		combo.store.filter({
        			filterFn: function(record) {
        				var flag = true;
        				if ((record.get('name') == 'VISITOR1' && privilege == 'RELATIONSHIP_VISITOR1') || (record.get('name') == 'VISITOR2' && privilege == 'RELATIONSHIP_VISITOR2')
        						|| (record.get('name') == 'VISITOR3' && privilege == 'RELATIONSHIP_VISITOR3') || (record.get('name') == 'VISITOR4' && privilege == 'RELATIONSHIP_VISITOR4')) {
        					flag = false;
        				} else {
        					flag = true;
        				}
        				return flag;
        			}
        		}, this);
        	});
        }
        combo.store.filter({
            filterFn: function(record) {
                var flag = true;
                if (record.get('name') == 'BROTHER' || record.get('name') == 'SISTER') {
                    flag = false;
                } else {
                    flag = true;
                }
                return flag;
            }
        }, this);
        
    },

    /**
     *  validate organization Employee Id
     */
    validateEmployeeOrgId: function(parentGuardianForm) {
        var this$ = this;
        var userIdField = parentGuardianForm.down('#employeeIdField');
        var userCode = userIdField.getValue();
        if (!isNullOrEmpty(userCode) && !(userIdField.readOnly == true)) {
        	var params = {
                userCode: userCode
            };
            this$.sendGetAjaxRequest(SERVERURL.VALIDATE_EMPLOYEE_ID_FOR_ADMISSION, 'GET', params, function(option, success, response) {
            	if(success){
                    var data = Ext.decode(response.responseText);
                    if (!isEmpty(data)) {
                        var id = parentGuardianForm.down('#pg_hidden_field').getValue();
                        var version = parentGuardianForm.down('#pg_version_field').getValue();
                        var userId = data.id;
                        var formDetails = new Object();
                        formDetails["id"] = id;
                        formDetails["version"] = version;

                        if (!isNullOrEmpty(data["person"])) {
                        	var relatedPerson = data["person"];
                        	if(!isNullOrEmpty(relatedPerson.isEmployeeOfOrganization)){
                            	if(relatedPerson.isEmployeeOfOrganization){
                            		parentGuardianForm.down('#genderCombo').setReadOnly(true);
                            		parentGuardianForm.down('#maritalStatus').setReadOnly(true);
                            	}
                            }
                        	this$.enabledDisabledInnerParentGuardianForm(parentGuardianForm, true);
                        	parentGuardianForm.down('#submitButtonId').setDisabled(false);
                        	parentGuardianForm.down('#photoFileImage').setDisabled(true);
                        	var innerForm = parentGuardianForm.down('#parentGuardianInfoItemField');
                        	relatedPerson.birthDate = new Date(relatedPerson.birthDate);
                        	relatedPerson.employeeId = userId;
                        	relatedPerson.userCode = data.code;
                        	innerForm.getForm().setValues(relatedPerson);
                        	var genderField = innerForm.getForm().findField('gender');
                        	if(data.person.genderCSM!=null){
                        		genderField.setValue(data.person.genderCSM.id);
                        	}
                        	parentGuardianForm.getForm().setValues(formDetails);
                            parentGuardianForm.setRelatedPerson(data.person);
                            if(parentGuardianForm.isValid()){
                            	parentGuardianForm.down('#submitButtonId').setDisabled(false);
                			}else{
                				parentGuardianForm.down('#submitButtonId').setDisabled(true);
                			}
                            
                      	    // By Default Set bellow checkboxes as checked Issue: V2D-41278
                    	    if(parentGuardianForm.itemId=='studentParentGuardianForm'){
                    		    var isMobileAvalaibleForCommunicationField = parentGuardianForm.down('#isMobUseForCommunicationField');
                    		    var isPhoneAvalaibleForCommunicationField = parentGuardianForm.down('#isPhoneUseForCommunicationField');
                    		    var isAlternateMobileAvalaibleForCommunicationField = parentGuardianForm.down('#isAlternateMobUseForCommunicationField');
                    		    var isEmergencyContactFieldField = parentGuardianForm.down('#isEmergencyContactField');
                    		    
                    		    if( !isNullOrEmpty(isMobileAvalaibleForCommunicationField) ){
                    		    	isMobileAvalaibleForCommunicationField.setValue(true);
                    		    }
                    		    if( !isNullOrEmpty(isPhoneAvalaibleForCommunicationField) ){
                    		    	isPhoneAvalaibleForCommunicationField.setValue(true);
                    		    }
                    		    if( !isNullOrEmpty(isAlternateMobileAvalaibleForCommunicationField) ){
                    		    	isAlternateMobileAvalaibleForCommunicationField.setValue(true);
                    		    }
                    		    if( !isNullOrEmpty(isEmergencyContactFieldField) ){
                    		    	isEmergencyContactFieldField.setValue(true);
                    		    }
                    		    
                    		    var haveAccessToLearner = parentGuardianForm.down('#haveAccessToLearnerId');
                                	haveAccessToLearner.items.items[0].setValue(true);
                                	haveAccessToLearner.items.items[1].setValue(false);
                               
                    		    var countryCodeFieldItemIDArray = ["#mobileCountryCode","#phoneCountryCode","#alternateMobileCountryCode"];
                    		    this$.setDefaultCountryCode(parentGuardianForm, countryCodeFieldItemIDArray);
                    	    }
                        } else {
                            showWarningMessage(getPersonModuleTranslation('PARENT_GUARDIAN_DETAILS'), getPersonModuleTranslation('USER_ID_NOT_EXIST'));
                            userIdField.setValue('');
                        }

                    }

                }
            });
        }

    },
    
    /**
     * View student sibling history form window
     */

    viewPersonSiblingFormWindow: function(gridItemId, formItemId, url) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
        if (grid.getSelectionModel().getCount() > 0) {
        	var formWindow = this$.getPersonCommonWindow();
        	this.showPersonCommonWindow(formWindow, 'SIBLING', formItemId);
        	var form = this$.getPersonSiblingForm();
        	this$.viewSiblingFormWindow(grid, form, url);
        } else {
            showWarningMessage(getPersonModuleTranslation('SIBLING_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
        
    },
    /**
     * edit student sibling history form window
     */
    editPersonSiblingFormWindow: function(gridItemId, formItemId, url) {

    	var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
        if (grid.getSelectionModel().getCount() > 0) {
        	var formWindow = this$.getPersonCommonWindow();
        	this.showPersonCommonWindow(formWindow, 'SIBLING', formItemId, false);
        	var form = this$.getPersonSiblingForm();
        	//form.down("#relationShipField").readOnly = true;
        	//form.down("#siblingStudentId").readOnly = true;
        	//form.down("#searchButtonId").readOnly = true;
        	//form.down("#salutationItemId").readOnly = true;
        	form.down("#genderCombo").readOnly = true;
        	this$.editSiblingFormWindow(grid, form, url);
        } else {
            showWarningMessage(getPersonModuleTranslation('SIBLING_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
       
    },
    /**
     * delete student sibling history form window
     */
    deletePersonSiblingRecord: function(gridItemId, url) {

    	var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
        this$.deleteSiblingRecord(grid, url);
    },
    /**
     * save student sibling history form window
     */
    savePersonSibling: function(personType, gridItemId, addUrl, updateUrl) {

    	var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        try {
        	personProfile.getApplicationId();
		} catch(e){
			personProfile = this$.getContentPanel().items.items[0];
		}
		var grid = personProfile.down(gridItemId);
        if(!grid) {
        	//-- code changed for multiple tabs functionality for applicant portal
        	if(Ext.isDefined(Ext.ComponentQuery.query('applicantsiblingdetailsgridstructure')))
            {
        		grid = Ext.ComponentQuery.query('applicantsiblingdetailsgridstructure')[0].down(gridItemId);
            }
            else
            {
            	grid=this$.getContentPanel().items.items[1].down(gridItemId);
            }        	
        	//grid = this$.getContentPanel().items.items[1].down(gridItemId);
        }
        var personObj = this$.getPersonObj();
        var siblingForm = this$.getPersonSiblingForm();
        var personCommonWindow = this$.getPersonCommonWindow();
        var personId = personProfile.personInfo.id;
        if(!isNullOrEmpty(siblingForm.relatedPerson))
        	{
        var relatedPersonId = siblingForm.relatedPerson.id;
        
        if(personId == relatedPersonId){
    		showWarningMessage(getPersonModuleTranslation('SIBLING_DETAILS'), getPersonModuleTranslation('INCORRECT_SIBLING_SELECTED'));
        } else{
           var submitUrl = SERVERURL.PATH_FIND_PERSON_RELATIONSHIP_EXIST+'?personId='+personId+'&relatedPersonId='+relatedPersonId;
 		   if(personType == 'APPLICANT') {
 			  submitUrl = SERVERURL.PATH_FIND_APPLICANT_PERSON_RELATIONSHIP_EXIST+'?personId='+personId+'&relatedPersonId='+relatedPersonId;
 		   }
           Ext.Ajax.request({
 			   type : 'rest',
 			   url : submitUrl,
 			   method : 'GET',
 			   success : function(form1, action) {
 				   var status = Ext.decode(form1.responseText);
 				   if(status) {
 					  showWarningMessage(getPersonModuleTranslation('SIBLING_DETAILS'), getPersonModuleTranslation('SIBLING_SELECTED_EXIST'));
 				   } else {
 					  this$.saveSibling(personType, grid, personCommonWindow, siblingForm, personObj, addUrl, updateUrl);
 				   }
 			   }
 		   });
		}
    }else
    	{
    	showWarningMessage(getPersonModuleTranslation('SIBLING_DETAILS'), getPersonModuleTranslation('SIBLING_SEARCH_ACTION'));
    	}
    },

    /**
     *  View sibling form window
     *  @param grid
     *  @param form
     *  @param relatedPersonUrl
     */

    viewSiblingFormWindow: function(grid, form, relatedPersonUrl) {
    	var this$ = this;
        this$.editSiblingFormWindow(grid, form, relatedPersonUrl);
        this$.viewPersonCommonWindow(form);
    },
    /**
     * Edit sibling form window
     *  @param grid
     *  @param form
     *  @param relatedPersonUrl
     */
    editSiblingFormWindow: function(grid, form, relatedPersonUrl) {
    	var this$ = this;
    	var records = grid.getSelectionModel().getSelection()[0];
        if (!isEmpty(records)) {
            form.loadRecord(records);
            var id = records.get("id");
            var params = {
            		id: id
            };
            this$.sendGetAjaxRequest(relatedPersonUrl, 'GET', params, function(option, success, response) {
            	if(success){
            		var data = Ext.decode(response.responseText);
            		if(!isEmpty(data)){
            			var personRelationship = data['personRelationship'];
                        var formDetails = new Object();
                        formDetails["id"] = personRelationship["id"];
                        formDetails["version"] = personRelationship["version"];
                        formDetails["studentCode"] = data["studentCode"];
                        var studentId = data["studentId"];
                        if (!isNullOrEmpty(studentId)) {
                        	var siblingStudentId = form.down('#siblingStudentId');
                        	siblingStudentId.getStore().load({ 
                        		params: {
                        		 studentNameOrCode: data["studentCode"]
                        		},
                                callback: function(records, operation, success) {
                                	siblingStudentId.setValue(studentId);
                                }
                            });
                        }
                        if (!isEmpty(data['personRelationship'])) {
                            var personRelationship = data['personRelationship'];
                            data.personRelationship.relatedPerson.birthDate = new Date(data.personRelationship.relatedPerson.birthDate);
                            form.setRelatedPerson(personRelationship.relatedPerson);
                            //form.down('#siblingStudentId').setReadOnly(true);
                            //form.down('#searchButtonId').setDisabled(true);
                            /*form.down('#submitButtonId').setDisabled(false);*/
                            form.getForm().setValues(personRelationship.relatedPerson);
                            
                        }
                        form.getForm().setValues(formDetails);
            		}
            		
            	}
            });//SERVERURL.PERSON_RELATIONSHIP_FORM_DETAILS,
            
            
            
        }
        
    },
    /**
     * Delete sibling history record
     * @param grid
     * @param deleteUrl
     */
    deleteSiblingRecord: function(grid, deleteUrl) {
    	var this$ = this;
    	if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getPersonModuleTranslation('SIBLING_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            var id = "";
                            if (!isNullOrEmpty(records[count].get("id"))) {
                                id = records[count].get("id");
                            }
                            Ext.Ajax.request({
                                type: 'rest',
                                url: deleteUrl,//SERVERURL.PERSON_RELATIONSHIP_DELETE,
                                method: 'DELETE',
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                params: {
                                    id: id
                                },
                                success: function(form, action) {
                                    grid.getStore().reload();
                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('SIBLING_DELETE_SUCCESS'));
                                }
                            });
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getPersonModuleTranslation('SIBLING_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }

    },
    /**
     *  Save sibling form
     *  @param grid
     *  @param personCommonWindow
     *  @param siblingForm
     *  @param personObj
     *  @param siblingPerson
     *  @param saveUrl
     *  @param updateUrl
     */
    saveSibling: function(personType, grid, personCommonWindow, siblingForm, personObj, saveUrl, updateUrl) {

        var this$ = this;
        var submitUrl, isUpdate = false;
        if(siblingForm.getForm().isValid()){
        	var id = siblingForm.down('#sibling_hidden_field');
        	if (isNullOrEmpty(id.getSubmitValue())) {
                submitUrl = saveUrl;//SERVERURL.PERSON_RELATIONSHIP_ADD,
                isUpdate = false;
            } else {
                submitUrl = updateUrl;//SERVERURL.PERSON_RELATIONSHIP_UPDATE,
                isUpdate = true;
            }
            var jsonFormatFormData = this$.getJsonSiblingData(personType, siblingForm, personObj, isUpdate);
            this$.applyWindowMask(); 
            
            this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
            	this$.hideWindowMask();
            	if(success){
            		personCommonWindow.close();
                    grid.getStore().reload();
                    grid.getSelectionModel().deselectAll();
                    if (isUpdate) {
                        showSuccessMessage(getPersonModuleTranslation('SIBLING_DETAILS'), getPersonModuleTranslation('SIBLING_UPDATE_SUCCESS'));
                    } else {
                        showSuccessMessage(getPersonModuleTranslation('SIBLING_DETAILS'), getPersonModuleTranslation('SIBLING_ADD_SUCCESS'));
                    }
        		}else{
        			personCommonWindow.close();
                    grid.getStore().reload();
        		}
            });
        }else{
        	this$.hideWindowMask();
        	showWarningMessage(getPersonModuleTranslation('SIBLING_DETAILS'), getPersonModuleTranslation('MANDATORY_FIELDS_NOT_FILLED'));
        }

    },
    /**
     *  Get sibling Json for form submission
     */
    getJsonSiblingData: function(personType, siblingForm, personObj, isUpdate) {

        var this$ = this;
        var jsonFormFieldData = {};
        var formData = siblingForm.getValues();
        var sibForm = siblingForm.getForm();
        if (!isEmpty(formData)) {
            jsonFormFieldData.relationship = formData.relationship;
            jsonFormFieldData.id = formData.id;
            jsonFormFieldData.version = parseInt(formData.version);
            var person = new Object();
            person.id = personObj["id"];
            jsonFormFieldData.person = person;
            var siblingPerson = siblingForm.getRelatedPerson();
            var relatedPerson = new Object();
            
            relatedPerson.emailId = sibForm.findField('emailId').getValue();//formData.emailId;
            relatedPerson.alternateEmailId = formData.alternateEmailId;
            relatedPerson.mobileCountryCode = sibForm.findField('mobileCountryCode').getValue(); //formData.mobileCountryCode;
            relatedPerson.mobileNumber = sibForm.findField('mobileNumber').getValue(); //formData.mobileNumber;
            relatedPerson.phoneAreaCode = sibForm.findField('phoneAreaCode').getValue(); //formData.phoneAreaCode;
            relatedPerson.phoneCountryCode = sibForm.findField('phoneCountryCode').getValue(); //formData.phoneCountryCode;
            relatedPerson.phoneNo = sibForm.findField('phoneNo').getValue(); //formData.phoneNo;
            
            relatedPerson.id = siblingPerson["id"];
            relatedPerson.version = siblingPerson["version"];
            if(personType == 'APPLICANT'){
            	var referredStudent= new Object();
            	if(!isUpdate){
            		relatedPerson.id = null;
                    relatedPerson.version = null;
                    relatedPerson.isDeleted = false;
                    relatedPerson.shortName = null;
                    referredStudent.id = siblingForm.getRelatedPersonUserId();
            	}else{
            		relatedPerson.id = null;
                    relatedPerson.version = null;
                    relatedPerson.isDeleted = false;
                    relatedPerson.shortName = null;
                    referredStudent.id = siblingForm.getRelatedPersonUserId();
            	}
            	relatedPerson.referredStudent = referredStudent; 
            	relatedPerson.status = "ACTIVE";
            	relatedPerson.isEmployeeOfOrganization = false;
            }
            //relatedPerson.salutation = sibForm.findField('phoneNoField').getValue(); //formData.salutation;
            relatedPerson.firstName = sibForm.findField('firstName').getValue(); //formData.firstName;
            relatedPerson.middleName = sibForm.findField('middleName').getValue(); //formData.middleName;
            relatedPerson.lastName = sibForm.findField('lastName').getValue(); //formData.lastName;
            relatedPerson.gender = sibForm.findField('gender').getValue(); //formData.gender;
            var birthDateField=sibForm.findField('birthDate');
            relatedPerson.birthDate = Ext.util.Format.date(birthDateField.getValue(), birthDateField.submitFormat); //formData.birthDate;
            jsonFormFieldData.relatedPerson = relatedPerson;
        }
        jsonFormFieldData = Ext.encode(jsonFormFieldData);
        return jsonFormFieldData;
    },
    
    /**
     * on render show hide parent guardian field
     * @param siblingForm
     * @param disabled
     */
    onRenderHideInnerSiblingFormField : function(siblingForm){
    		if(siblingForm){	
    			var innerForm = siblingForm.down('#siblingInfoItemField');
    			toggleReadOnlyFormItems(innerForm.getForm(),true);
    		}
    	
    },
    
    
    /**
     * On change sibling ID , reset inner form details
     * @param siblingForm
     */
    
    onChangeResetInnerSiblingForm : function(siblingForm){
    	if(siblingForm){
    		var id = siblingForm.down('#sibling_hidden_field');
    		var innerForm = siblingForm.down('#siblingInfoItemField');
            if (isNullOrEmpty(id.getSubmitValue())) {
        		innerForm.getForm().reset();
        	}
    		
    	}
    },
    /**
     *  on render sibling relationship combo
     */
    onRenderSiblingRelationShipCombo: function(combo) {
        combo.store.clearFilter(true);
        combo.store.filter({
            filterFn: function(record) {
                var flag = true;
                if (record.get('name') == 'BROTHER') {
                    flag = true;
                } else if (record.get('name') == 'SISTER') {
                    flag = true;
                } else {
                    flag = false;
                }
                return flag;
            }
        }, this);
    },

    /**
     * Validate sibling student ID
     * @param personSiblingForm
     */
    validateSiblingStudentId: function(personSiblingForm) {
        var this$ = this;
        var siblingStudentField = personSiblingForm.down('#siblingStudentId');
        //var studentCode = siblingStudentField.getValue();
        var studentCode = siblingStudentField.valueModels[0].data.studentCode
        var siblingInfoForm = personSiblingForm.down('form');
        if (!isNullOrEmpty(studentCode)) {
        	
        	 var params = {
                 studentCode: studentCode
             };
        	 
        	 this$.sendGetAjaxRequest(SERVERURL.VALIDATE_SIBLING_STUDENT_ID, 'GET', params, function(option, success, response) {
             	if(success){
                    var data = Ext.decode(response.responseText);
                    if (!isEmpty(data)) {
                    	//siblingInfoForm.setVisible(true);
                    	var id = personSiblingForm.down('#sibling_hidden_field').getValue();
                        var version = personSiblingForm.down('#sibling_version_field').getValue();
                        var formDetails = new Object();
                        formDetails["id"] = id;
                        formDetails["version"] = version;
                        if (!isNullOrEmpty(data["person"])) {
                        	if(data.status == true){
                        		siblingInfoForm.setVisible(true);
                        		personSiblingForm.down('#submitButtonId').setDisabled(false);
                        		var innerForm = personSiblingForm.down('#siblingInfoItemField');
                        		/*innerForm.setDisabled(false);*/
                        		data.person.birthDate = new Date(data.person.birthDate);
                        		innerForm.getForm().setValues(data.person);
                        		personSiblingForm.getForm().setValues(formDetails);
                        		personSiblingForm.setRelatedPersonUserId(data.id);
                        		personSiblingForm.setRelatedPerson(data.person);
                        		var gender=personSiblingForm.down('#genderCombo');
                        		gender.getStore().load({
              					   callback: function(recordss, operation, success) {
              						   for(var i in recordss){
              							   if( !isNullOrEmpty(data.person.genderCSM) ){
              								   if(recordss[i].data.id==data.person.genderCSM.id){
              									   gender.setValue(recordss[i].data.id);
              								   }
              							   }
              						   }
              					   }	   
              				   });
                        		} else {
                        			siblingInfoForm.setVisible(false);
                        			personSiblingForm.down('#submitButtonId').setDisabled(true);
                        			showWarningMessage(getPersonModuleTranslation('SIBLING_DETAILS'), getPersonModuleTranslation('STUDENT_IS_NULL'));
                        		}
                        	} else {
                        		siblingInfoForm.setVisible(false);
                        		personSiblingForm.down('#submitButtonId').setDisabled(true);
                        		showWarningMessage(getPersonModuleTranslation('SIBLING_DETAILS'), getPersonModuleTranslation('STUDENT_ID_NOT_EXIST'));
                        	}
                    	}
             		}
             	});
        	}
    },
    /**
     * On relationship selection set value for gender combo
     * @params form parent-guardian/sibling form
     * @params value relationship combo value
     */
    onSelectionRelationShipSetGenderCombo : function(form, value){

    	var genderCombo= form.down("#genderCombo");
    	var studentId=form.down("#siblingStudentId");
    	if(genderCombo){
    		if(value == "FATHER" || value == "BROTHER"){
    			genderCombo.setValue("MALE");
        		genderCombo.setReadOnly(true);

        	}else if(value == "MOTHER" || value == "SISTER"){
        		genderCombo.setValue("FEMALE");
        		genderCombo.setReadOnly(true);

        	}else{
        		genderCombo.reset();
        		genderCombo.setReadOnly(false);
        	}
    	}
    	if(!isNullOrEmpty(studentId)){
    		studentId.reset();
    	}
    },
    
    /**
     * On relationship selection set value for marital status combo
     * @params form parent-guardian
     * @params value
     */
    onSelectionRelationShipSetMaritalStatusCombo : function(form, value){

    	var maritalStatusCombo= form.down("#maritalStatus");
    	if(maritalStatusCombo){
    		if(value == "FATHER" || value == "MOTHER"){
    			var storeData = maritalStatusCombo.getStore().data.items;
    			var idToSet = null;
    			Ext.each(storeData, function(item) {
    				if (item.data.value == 'Married') {
    					idToSet = item.data.id;
					}
    			});
    			if (idToSet != null) {
    				maritalStatusCombo.setValue(idToSet);
				}
    			maritalStatusCombo.setReadOnly(true);
    			this.checkOtherLanguageFieldVisibility(form);
        	}else{
        		maritalStatusCombo.reset();
        		maritalStatusCombo.setReadOnly(false);
        	}
    	}
    },
    
    /*
     * This method is used to validate form contact details
     */
    validatePhone:function(data){
    	var isValid;
    	if(!(data.phoneNo && data.phoneCountryCode && data.phoneAreaCode) && !(data.mobileNumber && data.mobileCountryCode)){
    		//showErrorMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'),getCommonTranslation('ADD_PHONE_NO'));
    		Ext.getBody().unmask();
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ADD_PHONE_NO'));
    		isValid= false;
    	}
    	else{
    		isValid=true;
    	}
    	return isValid;
    },
    
    /*
     *  Identity Details
     */
    editIdentityDetailFormWindow: function(informationType, formItemId, gridItemId) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
        	this$.showPersonCommonWindow(undefined, informationType, formItemId, null);
            var form = this$.getPersonIdentityDetailsForm();
            var records = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(records)) {
            	if(!isNullOrEmpty(records.data.studentActualFollowUpDate))
            		records.data.actualFollowUpDate = records.data.studentActualFollowUpDate;
            	if(!isNullOrEmpty(records.data.studentIssuedDate))
            		records.data.issuedDate = records.data.studentIssuedDate;
            	if(!isNullOrEmpty(records.data.studentValidTillDate))
            		records.data.validTillDate = records.data.studentValidTillDate;
                form.loadRecord(records);
                if(!isNullOrEmpty(records.data.idNumberWithoutMasking)){
            		var idNumber = form.down('#idNumber');
            		idNumber.setValue(records.data.idNumberWithoutMasking);
            	}
                form.down('#identityType').setReadOnly(true);
            }
        } else {
            showWarningMessage(getPersonModuleTranslation('IDENTITY_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    viewIdentityDetailFormWindow: function(informationType, formItemId, gridItemId) {
    	var this$ = this;
    	this$.editIdentityDetailFormWindow(informationType, formItemId, gridItemId);
    	var form = this$.getPersonIdentityDetailsForm();
    	var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
        var records = grid.getSelectionModel().getSelection()[0];
        var idNumber = form.down('#idNumber');
        if (!isEmpty(records) && !isNullOrEmpty(records.data.idNumber)) {
            idNumber.setValue(records.data.idNumber);
        }
    	this$.viewPersonCommonWindow(form);
    	
    	idNumber.maxLength = 30;
    	var setMaxLengthOnInput = function() {
    	    if (idNumber.inputEl && idNumber.inputEl.dom) {
    	        idNumber.inputEl.dom.maxLength = 30;
    	    }
    	};

    	if (idNumber.rendered) {
    	    setMaxLengthOnInput();
    	} else {
    	    idNumber.on('afterrender', setMaxLengthOnInput);
    	}
    	idNumber.clearInvalid();
    },
    
    deleteIdentityDetailRecord: function(gridItemId, deleteUrl) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getPersonModuleTranslation('IDENTITY_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            var id = "";
                            if (!isNullOrEmpty(records[count].get("id"))) {
                                id = records[count].get("id");
                            }
                            Ext.Ajax.request({
                                type: 'rest',
                                url: deleteUrl + id,
                                method: 'DELETE',
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                success: function(form, action) {
                                    grid.getStore().reload();
                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('IDENTITY_DETAILS_DELETE_SUCCESS'));
                                }
                            });
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getPersonModuleTranslation('IDENTITY_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    deleteIdentityDetailOfApplicantAndStudentRecord: function(gridItemId, deleteUrl,requestFrom) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getPersonModuleTranslation('IDENTITY_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            var id = "";
                            if (!isNullOrEmpty(records[count].get("id"))) {
                                id = records[count].get("id");
                            }
                            Ext.Ajax.request({
                                type: 'rest',
                                url: deleteUrl+requestFrom+"/"+ id,
                                method: 'DELETE',
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                success: function(form, action) {
                                    grid.getStore().reload();
                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('IDENTITY_DETAILS_DELETE_SUCCESS'));
                                }
                            });
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getPersonModuleTranslation('IDENTITY_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    getDocumentController : function() {
		var this$ = this;
		return this$.getController('Academia.controller.document.DocumentController');
	},
	
	savePersonIdentity:function(gridItemId, saveUrl, updateUrl){
		var $this = this;
		var form = $this.getPersonIdentityDetailsForm();
		$this.saveIdentityDetail(gridItemId, saveUrl, updateUrl,form, null, SERVERURL.DOCUMENT_FILE_ADD, function(success){
			if(success){
				console.log('SUCCESS');
			}
		});
	},
	
	saveIdentityDetail : function(gridItemId, saveUrl, updateUrl,form,personId, uplaodUrl, callback){
		var this$ = this;
		var identityDetails = form.down('#identityDetailsDocId');
		var identityDetailsPath = identityDetails.getValue();
		form.down('#submitButtonId').setDisabled(true);
		
		if( !isNullOrEmpty(identityDetailsPath)){
			form.getForm().submit({
				method : 'POST',
				url : uplaodUrl,
				success : function(form1, action){
					callback(true);
					var responseData = Ext.decode(action.response.responseText);
					var path = responseData.path;
					form.getForm().findField('identityDetailsUploadPath').setValue(path);
					this$.saveIdentityDetailReocrd(gridItemId, saveUrl, updateUrl);
				},
				failure: function(form, action) {
			            var  msg = getCommonTranslation('UPLOAD_FILE_TYPE_IS_INVALID');
                        showWarningMessage(getCommonTranslation('ALERT'), msg);
				        
				    }
			});
		}else{
			this$.saveIdentityDetailReocrd(gridItemId, saveUrl, updateUrl);
		}
	},
	
	saveIdentityDetailReocrd: function(gridItemId, saveUrl, updateUrl) {
		var this$ = this;
		var form = this$.getPersonIdentityDetailsForm();
		var personProfile = this$.getContentPanelActiveTab();
		var grid = personProfile.down(gridItemId);
		form.down('#submitButtonId').setDisabled(true);

		var submitUrl, isUpdate = false;
		var id = form.down('#identity_detail_hidden_field');
		if (isNullOrEmpty(id.getSubmitValue())) {
			submitUrl = saveUrl;
			isUpdate = false;
		} else {
			submitUrl = updateUrl;
			isUpdate = true;
		}

		var path = form.getForm().findField('identityDetailsUploadPath').getValue();

		var jsonFormatFormData = this$.getJsonIdentityDetailsSubmitData(form,path);

		this$.applyWindowMask(); 

		this$.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
			this$.hideWindowMask();
			if(success,form){
				var data = Ext.decode(response.responseText);
				if(isArray(data)){
					form.down('#submitButtonId').setDisabled(false);
					if(data[0].key == 'ID_TYPE_ALREADY_EXISTS'){
						return false;
					}
				}

				grid.getStore().reload();
				grid.getSelectionModel().deselectAll();
				if(form.itemId == 'facultyIdentityDetailsForm') {
					form.up().close();
				} else {
					this$.closePersonCommonWindow();
				}
				if (isUpdate) {
					showSuccessMessage(getPersonModuleTranslation('IDENTITY_DETAILS'), getPersonModuleTranslation('IDENTITY_DETAILS_UPDATE_SUCCESS'));
				} else {
					showSuccessMessage(getPersonModuleTranslation('IDENTITY_DETAILS'), getPersonModuleTranslation('IDENTITY_DETAILS_ADD_SUCCESS'));
				}
			}else{
				this$.closePersonCommonWindow();
				grid.getStore().reload();
				form.down('#submitButtonId').setDisabled(false);
			}
		});
	},
	
	saveStudentApplyHold : function(gridItemId, saveUrl, updateUrl){

		var this$ = this;
		var form = this$.getStudentapplyholdsform();
		var personProfile = this$.getContentPanelActiveTab();
		var grid = personProfile.down(gridItemId);
		 var records=	grid.getSelectionModel().getSelection();
		var submitUrl, isUpdate = false;
		var id = form.down('#identity_detail_hidden_field');
		if (isNullOrEmpty(id.getSubmitValue())) {
			submitUrl = saveUrl;
			isUpdate = false;
		} else {
			submitUrl = updateUrl;
			isUpdate = true;
		}

		var values = form.getValues();
		var  manageHoldCategory={
				"id":values.holdCatStudent
		};
		var  manageSubHoldCategory={
				"id":values.subHoldCatStudent
		};
		
		var  applyBy={
				"id":values.applyBy
		};
		
		var  student={
				"id":personProfile.getUserId()
		};
		var jsonFormatFormData= new Object;
		records=grid.getStore().data.items;
		var isAdded=true;
		for(var i in records){
			if(records[i].data.isRemoval==null){
				if(records[i].data.holdCategoryId==values.holdCatStudent && records[i].data.holdSubCategoryId==values.subHoldCatStudent){
					isAdded=false;
					break;
				}
			}
		}
		if(isAdded==true){
                jsonFormatFormData = {
					"manageHoldCategory":manageHoldCategory,
					"manageSubHoldCategory":manageSubHoldCategory,
					"applyBy":applyBy,
					"applyReason":values.applyReason,
					"applyDate":values.applyDate,
					"student":student,
					"id":values.id
			}
      this$.applyWindowMask();
     this$.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
	this$.hideWindowMask();
	if(success){
		var data ;
		if (!isNullOrEmpty(response.responseText)) {
			 data = Ext.decode(response.responseText);
		}
		var store=grid.getStore();
		 store.getProxy().extraParams = {
			 studentId:personProfile.getUserId(),
			 applyHoldAt: ''
		   };
		   store.reload();
		grid.getSelectionModel().deselectAll();
		
		if (isUpdate) {
			if(!isNullOrEmpty(data)){
				this$.closePersonCommonWindow();
				showSuccessMessage(getCommonTranslation('APPLY_HOLD'), getCommonTranslation('HOLD_APPLIED_SUCCESSFULLY'));

			}else{
				showWarningMessage(getCommonTranslation('APPLY_HOLD'), getCommonTranslation('ACCESS_DENIED_TO_APPLIED_HOLD'));
			}
		} else {
			
			if(!isNullOrEmpty(data)){
				this$.closePersonCommonWindow();
				showSuccessMessage(getCommonTranslation('APPLY_HOLD'), getCommonTranslation('HOLD_APPLIED_SUCCESSFULLY'));

			}else{
				showWarningMessage(getCommonTranslation('APPLY_HOLD'), getCommonTranslation('ACCESS_DENIED_TO_APPLIED_HOLD'));
			}
		}
	}else{
		this$.closePersonCommonWindow();
		var store=grid.getStore();
		 store.getProxy().extraParams = {
			 studentId:personProfile.getUserId()
		   };
		   store.reload();
	}
});
		}else{
			showWarningMessage(getCommonTranslation('APPLY_HOLD'), getCommonTranslation('HOLD_ALREADY_APPLIED_ON_STUDENT'));
			this$.closePersonCommonWindow();
			grid.getStore().reload();
			
		}
},
	saveStudentRemoveHold : function(gridItemId, updateUrl){

		var this$ = this;
		var form = this$.getStudentremoveholdsform();
		var personProfile = this$.getContentPanelActiveTab();
		var grid = personProfile.down(gridItemId);
	   var records=	grid.getSelectionModel().getSelection()[0].raw;
		var submitUrl, isUpdate = false;
		var id = form.down('#identity_detail_hidden_field');
		if (isNullOrEmpty(id.getSubmitValue())) {
			submitUrl = updateUrl;
			isUpdate = false;
		} else {
			submitUrl = updateUrl;
			isUpdate = true;
		}

		var values = form.getValues();
		var  manageHoldCategory={
				"id":records.holdCategoryId
		};
		var  manageSubHoldCategory={
				"id":records.holdSubCategoryId
		};
		
		var  removalBy={
				"id":values.removalBy
		};
		
		var  student={
				"id":personProfile.getUserId()
		};
		var  applyBy={
				"id":records.holdAppliedById
		};
		var  applyReason=records.reasonForApply;
// 		var  applyDate=records.holdAppliedDate;
		var applyDate = Ext.Date.format(new Date(records.holdAppliedDate), "Y-m-d");
		var jsonFormatFormData= new Object;
		jsonFormatFormData = {
					
					"manageHoldCategory":manageHoldCategory,
					"manageSubHoldCategory":manageSubHoldCategory,
					"removalBy":removalBy,
					"removalReason":values.removalReason,
					"removalDate":values.removaltDate,
					"applyBy":applyBy,
					"applyReason":applyReason,
					"applyDate":applyDate,
					"student":student,
					"id":records.id,
					"isRemoval": true
			}

		this$.applyWindowMask(); 

		this$.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
			this$.hideWindowMask();
			if(success){
				
				var data ;
				if (!isNullOrEmpty(response.responseText)) {
					 data = Ext.decode(response.responseText);
				}
				
				var store=grid.getStore();
				 store.getProxy().extraParams = {
					 studentId:personProfile.getUserId()
				   };
				   store.reload();
				grid.getSelectionModel().deselectAll();
				
				if (isUpdate) {
					if (!isNullOrEmpty(data)) {
						this$.closePersonCommonWindow();
						showSuccessMessage(getCommonTranslation('REMOVE_HOLD'), getCommonTranslation('HOLD_REMOVED_SUCCESSFULLY'));
					}else{
						showWarningMessage(getCommonTranslation('REMOVE_HOLD'), getCommonTranslation('ACCESS_DENIED_TO_REMOVED_HOLD'));
					}
				} else {
					if (!isNullOrEmpty(data)) {
						this$.closePersonCommonWindow();
						showSuccessMessage(getCommonTranslation('REMOVE_HOLD'), getCommonTranslation('HOLD_REMOVED_SUCCESSFULLY'));
					}else{
						showWarningMessage(getCommonTranslation('REMOVE_HOLD'), getCommonTranslation('ACCESS_DENIED_TO_REMOVED_HOLD'));
					}				}
			}else{
				this$.closePersonCommonWindow();
				grid.getStore().reload();
			}
		});
	
		
	},
	
	StudentRemovalWin: function(formWindow,informationType, formItemId, gridItemId,isAdd) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
        
        if (grid.getSelectionModel().getCount() > 0) {
        	this$.showPersonCommonWindow(formWindow, informationType, formItemId, null);
        	var selectedRecord = grid.getSelectionModel().getSelection();
        	var form = this$.getStudentremoveholdsform();
    		var removalDate=form.down('#removaltDate');
    		var date=new Date(selectedRecord[0].data.holdAppliedDate);
    		removalDate.setMinValue(date);
          
        } else {
            showWarningMessage(getCommonTranslation('REMOVE_HOLD'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
	
	saveOtherInformation:function(saveUrl,getUrl, personType){
		var this$ = this;
		var form = this$.getPersonOtherinformationdetailsform();
		var values = form.getForm().getValues();
		
		if(portalId == 6){
			var personProfile = this$.getContentPanel().items.items[0];
			}else{
				var personProfile = this$.getContentPanelActiveTab();
				var form = personProfile.down('otherinformationdetailsform').getForm();
				var values = form.getValues();
			}
		var userId = '';
		if (!isNullOrEmpty(personType) && personType == 'APPLICANT') {
			userId =personProfile.getPersonId();
		}else{
			userId = personProfile.getUserId();	
		}
		
		var jsonFormatFormData ={
				"id": values.id,
				"userId": userId,
				"customData": values.customData
		};
		
		if (personType === 'APPLICANT' || personType === 'STUDENT') {
			jsonFormatFormData.financialAidGranted = values.financialAidGranted;
		}
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading'); 
		this$.sendSaveAjaxRequest(saveUrl, 'PUT', jsonFormatFormData, function(option, success, response) {
			Ext.getBody().unmask();
			if(success,form){
					showSuccessMessage(getPersonModuleTranslation('OTHER_INFORMATION'), getPersonModuleTranslation('OTHER_INFORMATION_ADD_SUCCESS'));
					this$.onRenderOtherInformationForm(getUrl, personType);
			}
		});
	},
	 /**
     * On render Other personal information form
     * call to personal information
     */
	onRenderOtherInformationForm : function(geturl,personType){
		var this$ = this;
		if(portalId == 6){
		var personProfile = this$.getContentPanel().items.items[0];
		}else{
			var personProfile = this$.getContentPanelActiveTab();
		}
		var userId = '';
		if (!isNullOrEmpty(personType) && personType == 'APPLICANT') {
			userId =personProfile.getPersonId();
		}else{
			userId = personProfile.getUserId();	
		}
		
		if (!isNullOrEmpty(userId)) {
			Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
			var url = geturl+userId;
			this$.sendGetAjaxRequest(url, 'GET', null, function(option, success, response) {
				Ext.getBody().unmask();
				if(success){
					if (!isNullOrEmpty(response.responseText)) {
						var data = Ext.decode(response.responseText);
						if(!isEmpty(data)){
							this$.setValueToOtherInformationForm(data);
						}
					}
				}
			});
		}
	},
    /**
     * Set value to other personal info
     */
	setValueToOtherInformationForm : function(data){
		var this$ = this;
		var personalInformationForm = this.getPersonOtherinformationdetailsform();
		if(portalId != 6){
			var personProfile = this$.getContentPanelActiveTab();
			var personalInformationForm = personProfile.down('otherinformationdetailsform');
		}
		if(personalInformationForm){
			personalInformationForm.getForm().setValues(data);
		}
	},
	savePersonFeePayerDetail:function(gridItemId, saveUrl, updateUrl){
		var $this = this;
		if(portalId == "7" || portalId == 7 ) {
			var form = this.getParentFeePayerDetailForm();
		}else{
			var form = $this.getPersonFeePayerDetailForm();
			
		}
		$this.saveFeePayerDetail(gridItemId, saveUrl, updateUrl,form, null, SERVERURL.FPD_UPLOAD_FEE_PAYER_DOCUMENTS_TEMP, function(success){
			if(success){
				console.log('SUCCESS');
			}
		});
	},
	saveFeePayerDetail: function(gridItemId, saveUrl, updateUrl, form, personId, uplaodUrl, callback) {
        var this$ = this;
        var feePayerIDItemId = form.down('#feePayerIDItemId');
        var feePayerID = feePayerIDItemId.getValue();
        var feePayerLatestPayslipItemId = form.down('#feePayerLatestPayslipItemId');
        var feePayerLatestPayslip = feePayerLatestPayslipItemId.getValue();
        var companySponsorLetterItemId= form.down('#companySponsorLetterItemId');
        var companySponsorLetter= companySponsorLetterItemId.getValue();
		var feePayerProofOfAccountItemId = form.down('#feePayerProofOfAccountItemId');
		var feePayerProofOfAccountId = feePayerProofOfAccountItemId.getValue();
       if (!isNullOrEmpty(feePayerID) || !isNullOrEmpty(feePayerLatestPayslip) || !isNullOrEmpty(companySponsorLetter) || !isNullOrEmpty(feePayerProofOfAccountId)) {
            form.getForm().submit({
                method: 'POST',
                url: uplaodUrl,
                success: function(form1, action) {
                    var responseData = Ext.decode(action.response.responseText);
                    if(responseData.success) {
                    	 var path = responseData.path;
                         var pathForSecondFile = responseData.pathForSecondFile;
                         var pathForThirdFile = responseData.pathForThirdFile;
                         var pathForFourthFile = responseData.pathForFourthFile;
                         form.getForm().findField('feePayerIdUploadPath').setValue(path);
                         form.getForm().findField('feePayerLatestPayslipUploadPath').setValue(pathForSecondFile);
                         form.getForm().findField('companySponsorLetterUploadPath').setValue(pathForThirdFile);
                         form.getForm().findField('feePayerProofOfAccountUploadPath').setValue(pathForFourthFile);
                         this$.saveFeePayerDetailReocrd(gridItemId, saveUrl, updateUrl, form);
                    } 
                },
                /*failure: function(d, f, s) {
                    console.log('hello');
                }*/
			            failure: function(form, action) {
			            var  msg = getCommonTranslation('UPLOAD_FILE_TYPE_IS_INVALID');
                        showWarningMessage(getCommonTranslation('ALERT'), msg);
				       /*var form = this$.getPersonFeePayerDetailForm();
				        var   activeTab = form.up('panel');
				     	this$.closeTab(activeTab);*/ 
				    }

            });
        } else {
            this$.saveFeePayerDetailReocrd(gridItemId, saveUrl, updateUrl, form);
        }
        
    },
    saveFeePayerDetailReocrd: function(gridItemId, saveUrl, updateUrl) {
        var this$ = this;
        if(portalId == "7" || portalId == 7 ) {
			var form = this$.getParentFeePayerDetailForm();
		}else{
			var form = this$.getPersonFeePayerDetailForm();
			
		}
       // var form = this$.getPersonFeePayerDetailForm();
        var personProfile = this$.getContentPanelActiveTab();
        var contentpanel = this.getContentPanel();
        var grid = personProfile.down(gridItemId);
        
        if(isNullOrEmpty(grid)){
        	try{
        		var grid = Ext.ComponentQuery.query(gridItemId)[0];
			}
			catch(e){
				//---
			}
        }

        var submitUrl, isUpdate = false;
        var id = form.down('#idItemId');
        if (isNullOrEmpty(id.getSubmitValue())) {
            submitUrl = saveUrl;
            isUpdate = false;
        } else {
            submitUrl = updateUrl;
            isUpdate = true;
        }

        var path = form.getForm().findField('feePayerIdUploadPath').getValue();
        var pathForSecondFile = form.getForm().findField('feePayerLatestPayslipUploadPath').getValue();
        var pathForThirdFile = form.getForm().findField('companySponsorLetterUploadPath').getValue();
        var pathForFourthFile = form.getForm().findField('feePayerProofOfAccountUploadPath').getValue();
        var jsonFormatFormData = this$.getJsonFeePayerDetailSubmitData(form, path, pathForSecondFile,pathForThirdFile, pathForFourthFile);
        var googleAddressId = form.down('#googleAddressId').getValue();
          
        if(personProfile && (personProfile.xtype=='studentprofile' || personProfile.xtype=='applicantprofile') && isNullOrEmpty(googleAddressId)){
        	var showAlert=false;
        	var associatedAcadLocationIds = new Array();
        	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getSTUDENT_LIST_FEE_PAYER_DETAILS_PERMISSIONS());

        	Ext.each(permissionList, function(privilege) {
        		if (privilege === 'GOOGLE_ADDRESS') {
        			showAlert=true;
        		}
        	});
        	if(showAlert){
        		return showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getCommonTranslation('PLEASE_ADD_GOOGLE_ADDRESS'));
        	}
        }
      
       var personType =this.getContentPanelActiveTab().personType;
       if(isNullOrEmpty(personType)){
    	   personType =  form.personType;
       }
        if(personType == "APPLICANT"){
        	personType = "APPLICANT" ;
        }else{
        	personType = "OTHER";
        }
        try{
            var jsonFormatFormDataObj = Ext.decode(jsonFormatFormData);
            if(submitUrl==SERVERURL.FPD_PERSON_FEE_PAYER_DETAIL_CREATE || submitUrl==SERVERURL.FPD_PERSON_FEE_PAYER_DETAIL_UPDATE){
                delete jsonFormatFormDataObj.person.personType;
              
            }
        }
        catch(e){
        	console.log('--');
        }
        var isAlreadyFeePayer=false;
        if(form && form.isPrimaryFeePayer){
        	isAlreadyFeePayer=true;
        }
        
         var  jsonFormatFormDataSub = Ext.encode(jsonFormatFormDataObj);
        Ext.Ajax.request({
     		type: 'rest',
     		async: false,
     		url: SERVERURL.PATH_CHECK_ISPRIMARYFEEPAYER,
     		params: {
     			personId :jsonFormatFormDataObj.person.id,
     			userType : personType,
     			
     		},
     		method: 'GET',
     		success:function(res,data){
     			if((jsonFormatFormDataObj.isPrimaryFeePayer) && (res.responseText == "true" || res.responseText == true) && !isAlreadyFeePayer) {

     				showConfirmMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getCommonTranslation('ARE_YOU_SURE_YOU_WANT_TO_CHANGE_THE_PRIMARY_FEE_PAYER?'), function(btn, text) {
     	                if (btn == 'yes') {
     	                   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
     	         	      
     	            	   this$.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormDataSub, function(option, success, response) {
     	                   	Ext.getBody().unmask();
     	                   if(portalId == "7" || portalId == 7 ) {
	                 			var form = this$.getParentFeePayerDetailForm();
	                 		}else{
	                 			var form = this$.getPersonFeePayerDetailForm();
	                 			
	                 		}
     	                       if (success, form) {
     	                           var data = Ext.decode(response.responseText);

     	                           if(grid!=undefined && !isNullOrEmpty(grid)) {
     	                           grid.getStore().reload();
     	                           grid.getSelectionModel().deselectAll();
     	                           }
	     	                      
     	                           var   activeTab = form.up('panel');
     	              			 	this$.closeTab(activeTab);
     	                           if (isUpdate) {
     	                               showSuccessMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS_UPDATE_SUCCESS'));
     	                           } else {
     	                        	   if(jsonFormatFormDataObj.isPrimaryFeePayer) {
     	                        		  showSuccessMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FPD_PRIMARY_FEE_PAYER_DETAILS_ADD_SUCCESS'));
     	                        	   } else {
     	                               showSuccessMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS_ADD_SUCCESS'));
     	                        	   }
     	                           }
     	                       } else {
     	                       	 activeTab = form.up('panel');
     	               			 	this$.closeTab(activeTab);
     	                           //this$.closePersonCommonWindow();
     	               			   if(grid!=undefined && !isNullOrEmpty(grid)) {
     	                           grid.getStore().reload();
     	               			   }
     	                       }
     	                   });
     	                }
     	            });
     			}else{
     				  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
     	    	      
     		    	   this$.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormDataSub, function(option, success, response) {
     		           	Ext.getBody().unmask();
     		           	
     		           if(portalId == "7" || portalId == 7 ) {
                			var form = this$.getParentFeePayerDetailForm();
                		}else{
                			var form = this$.getPersonFeePayerDetailForm();
                			
                		}
     		               if (success, form) {
     		                   var data = Ext.decode(response.responseText);

     		                   if(grid!=undefined && !isNullOrEmpty(grid)) {
     		                   grid.getStore().reload();
     		                   grid.getSelectionModel().deselectAll();
     		                   }
     		                   var   activeTab = form.up('panel');
     		      			 	this$.closeTab(activeTab);
     		                   if (isUpdate) {
     		                       showSuccessMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS_UPDATE_SUCCESS'));
     		                   } else {
     		                	  if(jsonFormatFormDataObj.isPrimaryFeePayer) {
 	                        		  showSuccessMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FPD_PRIMARY_FEE_PAYER_DETAILS_ADD_SUCCESS'));
 	                        	   } else {
     		                       showSuccessMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS_ADD_SUCCESS'));
 	                        	   }
     		                   }
     		               } else {
     		               	 activeTab = form.up('panel');
     		       			 	this$.closeTab(activeTab);
     		                   //this$.closePersonCommonWindow();
     		       			   if(grid!=undefined && !isNullOrEmpty(grid)) {
     		                   grid.getStore().reload();
     		       			   }
     		               }
     		           });
     			}
     		}
         });
        
      
    },
    getJsonFeePayerDetailSubmitData: function(form, path, pathForSecondFile,pathForThirdFile, pathForFourthFile) {
    	var this$ = this;
    	var jsonFormFieldData = new Object();
    	var formData = form.getValues();
    	if (!isEmpty(formData)) {
    		if(isNullOrEmpty(formData.homeTelephone)){
    			formData.homeTelephoneCountryCode="";
    		}
    		if(isNullOrEmpty(formData.workTelephone)){
    			formData.workTelephoneCountryCode="";
    		}
    		if(isNullOrEmpty(formData.mobileNumber)){
    			formData.countryCode="";
    		}

    		var personObj = this$.getPersonObj();
    		var personId = personObj["id"];

    		/*var personObj = this$.getPersonObj();
        	if(portalId==6){
        		delete personObj.personType	
        	}
            formData.person = personObj;*/
    		formData.person={
    				id: personId
    		};
    		var userId = this.getCurrentlyLoggedInUser().id;
    		user = {
    				id: userId
    		};

    		if (!isNullOrEmpty(path)) {
    			var fileName = path.substring(path.lastIndexOf('/') + 1, path.length);
    			var doc = {
    					path: path,
    					name: fileName,
    					type: 'DOCUMENT',
    					createdBy: user
    			};
    			formData.feePayerId = doc;
    		} else {
    			formData.feePayerId = null;
    		}
    		if (!isNullOrEmpty(pathForSecondFile)) {
    			var fileName = pathForSecondFile.substring(pathForSecondFile.lastIndexOf('/') + 1, pathForSecondFile.length);
    			var doc = {
    					path: pathForSecondFile,
    					name: fileName,
    					type: 'DOCUMENT',
    					createdBy: user
    			};
    			formData.feePayerLatestPayslip = doc;
    		} else {
    			formData.feePayerLatestPayslip = null;
    		}
    		if (!isNullOrEmpty(pathForThirdFile)) {
    			var fileName = pathForThirdFile.substring(pathForThirdFile.lastIndexOf('/') + 1, pathForThirdFile.length);
    			var doc = {
    					path: pathForThirdFile,
    					name: fileName,
    					type: 'DOCUMENT',
    					createdBy: user
    			};
    			formData.companySponsorLetter = doc;
    		} else {
    			formData.companySponsorLetter = null;
    		}
    		if (!isNullOrEmpty(pathForFourthFile)) {
    			var fileName = pathForFourthFile.substring(pathForFourthFile.lastIndexOf('/') + 1, pathForFourthFile.length);
    			var doc = {
    					path: pathForFourthFile,
    					name: fileName,
    					type: 'DOCUMENT',
    					createdBy: user
    			};
    			formData.feePayerProofOfAccountUploadPath = doc;
    		} else {
    			formData.feePayerProofOfAccountUploadPath = null;
    		}
    	}
    	var salutation = null;
    	if (!isNullOrEmpty(formData.salutationId) && !isNullOrEmpty(formData.salutationId.id)) {
    		salutation = {
    				id: formData.salutationId.id
    		};
    	}
    	formData.salutation = salutation;

    	var bank = null;
    	if (!isNullOrEmpty(formData.bank)) {
    		bank = {
    				id: formData.bank
    		};
    	}
    	formData.bank = bank;

    	var debitOrderDateCSM=null;
    	if (!isNullOrEmpty(formData.debitOrderDate) && formData.paymentMode!="EFT") {
    		if(formData.paymentMode=="DEBIT_ORDER")
    		{
    			debitOrderDateCSM = {
    					id: formData.debitOrderDate
    			};
    			/*var debitOrderStartDate =formData.debitOrderStartDate;
    			var debitOrderEndDate = formData.debitOrderEndDate;*/
    		}
    	}
    	formData.debitOrderDateCSM = debitOrderDateCSM;
    	formData.debitOrderStartDate;
		formData.debitOrderEndDate;

    	if ( isNullOrEmpty(formData.accountType) || formData.accountType == "" ) {
    		delete formData.accountType;
    	}
    	if ( isNullOrEmpty(formData.bank) || formData.bank == "" ) {
    		delete formData.bank;
    	}
    	if ( portalId==7 ) {
    		delete formData.debitOrderDate;
    	}
    	delete formData.debitOrderDate;



    	if ( formData.paymentMode == 'EFT' ){

    		var paymentModProperties = ['accountName', 'accountNumber', 'branchCode', 
    			'bank', 'accountType', 'debitOrderDate'];

    		for( i in paymentModProperties ){
    			var propertyName = paymentModProperties[i];
    			if( propertyName in formData ){
    				delete formData[propertyName];
    			}
    		}
    	}
    	formData.sponsorId=formData.sponsor;
    	delete formData.sponsor;
    	delete formData.salutationId;
    	delete formData.module;
    	delete formData.feePayerIdUploadPath;
    	delete formData.feePayerLatestPayslipUploadPath;
    	delete formData.documentCount;
    	jsonFormFieldData = Ext.encode(formData);
    	return jsonFormFieldData;
    },
    editFeePayerDetailFormWindow: function(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,ApproveBtn, menuColorCls) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
        var personComContlr =Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
    	
        if (grid.getSelectionModel().getCount() > 0) {
        	personComContlr.addPersonTabPanel(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,ApproveBtn, menuColorCls);
	    	
           // this$.showPersonCommonWindow(undefined, informationType, formItemId, null);
            var form = this$.getPersonFeePayerDetailForm();
            var formScroll = form.up('form');
			if(!isNullOrEmpty(formScroll.getEl()))
			{
				var getElValue=formScroll.getEl();
				var getFirstChild = getElValue.first();
				getFirstChild.dom.style.overflowY="scroll";
			}
            var records = grid.getSelectionModel().getSelection()[0];
            form.isPrimaryFeePayer=records.data.isPrimaryFeePayer;
            if (!isEmpty(records)) {
                var payerTypeItemId = form.down("#payerTypeItemId");
                payerTypeItemId.setReadOnly(true);
                var doesFeePayerConsentToCreditCheckItemId = form.down("#doesFeePayerConsentToCreditCheckItemId");
                if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.doesFeePayerConsentToCreditCheck)) {
                	doesFeePayerConsentToCreditCheckItemId.setValue({
                		doesFeePayerConsentToCreditCheck: records.data.doesFeePayerConsentToCreditCheck
                	});
                }
                var salutationItemId = form.down("#salutationItemId");
                if (!isNullOrEmpty(records.data.salutation) && !isNullOrEmpty(records.data.salutation.id)) {
                	salutationItemId.getStore().load({
  					   callback: function(recordss, operation, success) {
  						   for(var i in recordss){
  							   if( !isNullOrEmpty(records.data.salutation) ){
  								   if(recordss[i].data.id==records.data.salutation.id){
  									 salutationItemId.setValue(recordss[i].data.id);
  								   }
  							   }
  						   }
  					   }	   
  				   });
                }
                
                
                var bankItemId = form.down("#bankItemId");
                /*if (!isNullOrEmpty(records.data.bank) && !isNullOrEmpty(records.data.bank.id)) {
                	bankItemId.setValue(records.data.bank.id);
                }*/
                
                var empOfTheOrganizationField = form.down("#empOfTheOrgItemId");
                if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.employeeOfOrganization)) {
                	empOfTheOrganizationField.setValue({
                		employeeOfOrganization: records.data.employeeOfOrganization
                	});
                }
                
                var branchCodeId = form.down("#branchCodeItemId");
                
                if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.bank)){
                bankItemId.getStore().load({
					   callback: function(recordss, operation, success) {
						   for(var i in recordss){
							   if( !isNullOrEmpty(records.data.bank) ){
								   if(recordss[i].data.id==records.data.bank.id){
									   bankItemId.setValue(recordss[i].data.id);
								   }
							   }
						   }
					   }	   
				   });
                
                
                var branchCodeStore = branchCodeId.getStore();
                 branchCodeStore.getProxy().extraParams = {
                     bankId: records.data.bank.id
                 };
                 branchCodeStore.load();
                }

                var debitOrderDateItemId = form.down("#debitOrderDateItemId");
                debitOrderDateItemId.getStore().load({
 				   callback: function(recordss, operation, success) {
 					   for(var i in recordss){
 						   if(!isNullOrEmpty(records.data.debitOrderDateCSM)){
 							   if(recordss[i].data.id==records.data.debitOrderDateCSM.id){
 								   debitOrderDateItemId.setValue(recordss[i].data.id);
 							   } 
 						   }
 					   }
 				   }	   
 			   });
                
                var debitOrderDateItemId = form.down("#debitOrderDateItemId");
                if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.debitOrderDateCSM)){
                	debitOrderDateItemId.getStore().load({
    					   callback: function(recordss, operation, success) {
    						   for(var i in recordss){
    							   if( !isNullOrEmpty(records.data.debitOrderDateCSM) ){
    								   if(recordss[i].data.id==records.data.debitOrderDateCSM.id){
    									   debitOrderDateItemId.setValue(recordss[i].data.id);
    								   }
    							   }
    						   }
    					   }	   
    				   });
                    
                     var debitOrderDateStore = debitOrderDateItemId.getStore();
                     debitOrderDateStore.getProxy().extraParams = {
                         bankId: records.data.debitOrderDateCSM.id
                     };
                     debitOrderDateStore.load();
                    }
                
                var debitOrderDateItemId = form.down("#debitOrderDateItemId");
                if (!isNullOrEmpty(records.data.debitOrderDate) && !isNullOrEmpty(records.data.debitOrderDate)) {
                	debitOrderDateItemId.setValue(records.data.debitOrderDate);
                }
                
                
                
                if(!isNullOrEmpty(records.data) && records.data.branchcode!=null){
                	branchCodeId.setValue(records.data.branchcode);
                }
                
                var addressText = form.down('#addressTextArea');
            	var country = form.down('#countryId');
            	var countryRegion = form.down('#parentCountryRegionId');
            	var city = form.down('#cityId');
            	var pincode = form.down('#pincodeId');
            	var corporateId = form.down('#corporateId');
            	
            	if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.corporateId)) {
            		corporateId.setValue(records.data.corporateId);
              }
            	
            	if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.addressText)) {
            		  addressText.setValue(records.data.addressText);
                }
            	if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.pincode)) {
            		pincode.setValue(records.data.pincode);
              }
            	if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.countryId)) {
            		country.setValue(records.data.countryId);
            		var countryRegionStore = countryRegion.getStore();
                    countryRegionStore.getProxy().extraParams = {
                        cid: records.data.countryId
                    };
                    countryRegionStore.load();  
                    countryRegion.setDisabled(false);
              }
            	if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.parentCountryRegionId)) {
            	
            		countryRegion.setValue(records.data.parentCountryRegionId);            		
            		  var cityStore = city.getStore();
                                           
                      cityStore.getProxy().extraParams = {
                     	 countryId: records.data.countryId,
                     	 countryRegionId: records.data.parentCountryRegionId
                      };
                      cityStore.load();
                      city.setDisabled(false);
              }
            	if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.cityId)) {
            		city.setValue(records.data.cityId);
              }           	
            	var sponsorItemId = form.down("#sponsorItemId");
            	sponsorItemId.getStore().load({
					   callback: function(recordss, operation, success) {
						   if(records.data.sponsor && records.data.sponsor.id){
							   sponsorItemId.setValue(records.data.sponsor.id);
						   }
						   
					   }	   
				   });
            	var occupationItemId = form.down("#occupationItemId");
            	var employerCompanyNameItemId = form.down("#employerCompanyNameItemId");
            	var employerEmailItemId = form.down("#employerEmailItemId");
            	if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.occupation)) {
            		occupationItemId.setValue(records.data.occupation);
            	}
            	if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.employerCompanyName)) {
            		employerCompanyNameItemId.setValue(records.data.employerCompanyName);
            	}
            	if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.employerEmail)) {
            		employerEmailItemId.setValue(records.data.employerEmail);
            	}
                
                var feePayerIDItemId = form.down("#feePayerIDItemId");
                var feePayerLatestPayslipItemId = form.down("#feePayerLatestPayslipItemId");
                var feePayerProofOfAccountItemId = form.down('#feePayerProofOfAccountItemId');
                var companySponsorLetterItemId= form.down('#companySponsorLetterItemId');
                var homeTelephoneCountryCodeItemId = form.down("#homeTelephoneCountryCodeItemId");
	               var workTelephoneCountryCode = form.down("#workTelephoneCountryCodeItemId");
	               var countryCodeItemId = form.down("#countryCodeItemId");
	               homeTelephoneCountryCodeItemId.getStore().load({
					   callback: function(rec, operation, success) {
						   homeTelephoneCountryCodeItemId.setValue(records.data.homeTelephoneCountryCode);
					   }
				   });
	               workTelephoneCountryCode.getStore().load({
					   callback: function(rec, operation, success) {
						   workTelephoneCountryCode.setValue(records.data.workTelephoneCountryCode);
					   }
				   });
	               countryCodeItemId.getStore().load({
					   callback: function(rec, operation, success) {
						   countryCodeItemId.setValue(records.data.countryCode);
					   }
				   });
                var $this=this;
                setTimeout(function(){
					  // $this.setAllowBlank(feePayerIDItemId, true);
                	  feePayerIDItemId.allowBlank = true;
					  form.isValid();
               	},500);
                //feePayerIDItemId.allowBlank = true;
                feePayerLatestPayslipItemId.allowBlank = true;
                feePayerIDItemId.setFieldLabel(getPersonModuleTranslation('FPD_FEE_PAYER_ID'));
				feePayerLatestPayslipItemId.setFieldLabel(getPersonModuleTranslation('FPD_FEE_PAYER_LATEST_PAYSLIP'));
				feePayerProofOfAccountItemId.setFieldLabel(getPersonModuleTranslation('FPD_FEE_PAYER_PROOF_OF_ACCOUNT'));
                form.loadRecord(records);
                if(!isNullOrEmpty(records.data.debitOrderStartDate)){
            		var debitOrderStartDate = form.down("#debitOrderStartDate");
            		debitOrderStartDate.setValue(dateRender(records.data.debitOrderStartDate));
            	}
            	if(!isNullOrEmpty(records.data.debitOrderEndDate)){
            		var debitOrderEndDate = form.down("#debitOrderEndDate")
                	debitOrderEndDate.setValue(dateRender(records.data.debitOrderEndDate));
            	}
            	var feePayerURL = form.down('#feePayerURL');
            	var feePayerLatestPayslipURL = form.down('#feePayerLatestPayslipURL');
            	var feePayerProofOfAccountURL = form.down('#feePayerProofOfAccountURL');
            	var companySponsorLetterURL = form.down('#companySponsorLetterURL');
            	if (!isNullOrEmpty(records.data.feePayerId)) {
					feePayerURL.setValue(records.data.feePayerId.path);
				}
            	if(feePayerIDItemId.isVisible()){
					feePayerURL.setVisible(true);	
				}
            	if (!isNullOrEmpty(records.data.feePayerLatestPayslip)) {
					feePayerLatestPayslipURL.setValue(records.data.feePayerLatestPayslip.path);
				}
            	if(feePayerLatestPayslipItemId.isVisible()){
					feePayerLatestPayslipURL.setVisible(true);
				}
            	if (!isNullOrEmpty(records.data.feePayerProofOfAccountUploadPath)) {
					feePayerProofOfAccountURL.setValue(records.data.feePayerProofOfAccountUploadPath.path);
					form.getForm().findField('feePayerProofOfAccountUploadPath').setValue('');
				}
            	if(feePayerProofOfAccountItemId.isVisible()){
					feePayerProofOfAccountURL.setVisible(true);
				}
            	if (!isNullOrEmpty(records.data.companySponsorLetter)) {
					companySponsorLetterURL.setValue(records.data.companySponsorLetter.path);
				}
            	if(companySponsorLetterItemId.isVisible()){
					companySponsorLetterURL.setVisible(true);
				}
            	
            	var googleAddress = form.down('#googleAddressId'),
            	googleAddressCountry = form.down('#googleAddressCountryId'),
            	googleAddressCountryRegion = form.down('#googleAddressCountryRegionId'),
            	googleAddressCity = form.down('#googleAddressCityId'),
            	googleAddressPincode = form.down('#googleAddressPincodeId');
            	
            	if (!isNullOrEmpty(records.data.addressText)) {
            		googleAddress.setValue(records.data.addressText);
				}
            	if (!isNullOrEmpty(records.data.countryText)) {
            		googleAddressCountry.setValue(records.data.countryText);
				}
            	if (!isNullOrEmpty(records.data.provinceText)) {
            		googleAddressCountryRegion.setValue(records.data.provinceText);
				}
            	if (!isNullOrEmpty(records.data.cityText)) {
            		googleAddressCity.setValue(records.data.cityText);
				}
            	if (!isNullOrEmpty(records.data.postalCodeText)) {
            		googleAddressPincode.setValue(records.data.postalCodeText);
				}
                return form;
            }
        } else {
            showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
            return null;
        }
    },
    viewFeePayerDetailFormWindow: function(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,approveBtn,menuColorCls) {
        var this$ = this;
        this$.editFeePayerDetailFormWindow(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,approveBtn,menuColorCls);
        var form = this$.getPersonFeePayerDetailForm();
        var feePayerIDItemId = form.down("#feePayerIDItemId");
        var feePayerLatestPayslipItemId = form.down("#feePayerLatestPayslipItemId");
        var feePayerProofOfAccountItemId = form.down('#feePayerProofOfAccountItemId');
        feePayerIDItemId.setDisabled(true);
        feePayerLatestPayslipItemId.setDisabled(true);
        feePayerProofOfAccountItemId.setDisabled(true);
        this$.viewPersonCommonWindow(form);
    },
    deleteFeePayerDetailRecord: function(gridItemId, deleteUrl) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            var id = "";
                            if (!isNullOrEmpty(records[count].get("id"))) {
                                id = records[count].get("id");
                            }
                            Ext.Ajax.request({
                                type: 'rest',
                                url: deleteUrl + id,
                                method: 'DELETE',
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                success: function(form, action) {
                                    grid.getStore().reload();
                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS_DELETE_SUCCESS'));
                                }
                            });
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    
    /*student passport details  */

    saveStudentPassportDetail: function(gridItemId, saveUrl, updateUrl) {

      var this$ = this;
      var isValid = true;
      var submitUrl, isUpdate = false;

      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      var form = this$.getStudentpassportdetailsform();
      form.down('#submitButtonId').setDisabled(true);

          var id = form.down('#Student_Passport_Details_hidden_field');
          if (!isNullOrEmpty(id.getSubmitValue())) {
          	submitUrl = updateUrl,
              isUpdate = true;
          } else {
          	submitUrl = saveUrl,
              isUpdate = false;       
          }
          var jsonFormatFormData = this$.getJsonStudentPassportData(form,grid,isUpdate);
          this$.applyWindowMask(); 
          this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
              this$.hideWindowMask();
              if(success){
                  this$.closePersonCommonWindow();
                  if(this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7){
                  	try{
                  		personId = this$.getPersonObj().id;
                  		if(isNullOrEmpty(personId)){
                  			personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                  		}
                  	}
                  	catch(e){
                  		personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                  	}
                  	grid.getStore().getProxy().extraParams = {
                  		personId : personId
                  	};
                  }else if(!isNullOrEmpty(personProfile.getPersonInfo())){
	        			grid.getStore().getProxy().extraParams = {
	        				personId : personProfile.getPersonInfo().id
	        			};
	        		}
                  grid.getStore().reload();
                  grid.getSelectionModel().deselectAll();
                  if (isUpdate) {
                      showSuccessMessage(getCommonTranslation('STUDENT_PASSPORT'), getCommonTranslation('STUDENT_PASSPORT_UPDATE_SUCCESS'));
                  } else {
                      showSuccessMessage(getCommonTranslation('STUDENT_PASSPORT'), getCommonTranslation('STUDENT_PASSPORT_ADD_SUCCESS'));
                  }
              }else{
                  this$.hideWindowMask();
                  this$.closePersonCommonWindow();
                  grid.getStore().reload();
                  form.down('#submitButtonId').setDisabled(false);
              }
          });
	      

  },
  getJsonStudentPassportData: function(form,grid,isUpdate) { 
      var this$ = this;
      var jsonFormFieldData = new Object();
      var personObj = this$.getPersonObj();
      var formData = form.getValues();
      if (!isEmpty(formData)) {
          var person = new Object();
          person.id = personObj["id"];
          formData.person = person;
          if(formData.countryOfIssue=='')
        	  {
        	  formData.countryOfIssue=null;
        	  }
          delete formData.pageSize;
          delete formData.customData;

          var docArray = [];
          var docStore = this$.getStore('personinfo.common.personalinfo.StudentPassportDocumentGridStore');
          if (docStore.data.items != null
                  && docStore.data.items.length > 0) {
              Ext.each(docStore.data.items, function(val) {
                  var newData = {
                          "name" : val.data.documentName,
                          "path" : val.data.path,
                          "type" : val.data.type,
                          "id" 	 : val.data.id,
                          "createdBy" : this$.getIdValueJson(
                                  val.data.createdBy.id,
                                  val.data.createdBy.value)
                  };
                  docArray.push(newData);
              });
          }
          var urlArray = [];
          var urlStore = this$.getStore('personinfo.common.personalinfo.StudentPassportUrlGridStore');
          if (urlStore.data.items != null
                  && urlStore.data.items.length > 0) {
              Ext.each(urlStore.data.items, function(val) {
                  var newData = {
                          "name" : val.data.documentName==null?val.data.name:val.data.documentName,
                          "path" : val.data.path,
                          "id"   : val.data.id,
                  };
                  urlArray.push(newData);
              });
          }
      }
      if (isUpdate==false) {
    	  docArray.length==0&&urlArray.length==0?formData.fileModifiedDate="":'';
      } 
      formData.copyOfPassports = docArray;
      formData.copyOfPassportUrls = urlArray;
      jsonFormFieldData = Ext.encode(formData);
      return jsonFormFieldData;
  },
  
  editPassportDetailWindow: function(informationType, formItemId, gridItemId, isViewMode) {
      var this$ = this;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);

      if (grid.getSelectionModel().getCount() > 0) {
      	this$.showPersonCommonWindow(undefined, informationType, formItemId, null);
      	var formWindow = this$.getPersonCommonWindow();
      	if(isViewMode!=null && (isViewMode==true || isViewMode=='true')) {
      		formWindow.setTitle(getCommonTranslation('VIEW_STUDENT_PASSPORT'));
      	}else{
      		formWindow.setTitle(getCommonTranslation('EDIT_PASSPORT'));
      	}
      	  var form = this$.getStudentpassportdetailsform();
          var records = grid.getSelectionModel().getSelection()[0];
          if (!isEmpty(records)) {
        	form.down('#Student_Passport_Details_hidden_field').setValue(records.data.id);
        	  
          	if(!isNullOrEmpty(records.data.passportExpirationDate))
          		records.data.passportExpirationDate = new Date(records.data.passportExpirationDate);
          	
          	var fileModifiedDate = form.down('#fileModifiedDate')
          	if(!isNullOrEmpty(records.data.fileModifiedDate)){
          		records.data.fileModifiedDate = new Date(records.data.fileModifiedDate);
          	}
          		fileModifiedDate.setReadOnly(true);
          	
          		var countryOfIssue = form.down('#countryOfIssue')
             	 if (!isNullOrEmpty(records.data.countryOfIssue)) {		            	
                    countryOfIssue.getStore().load({ 
                    	callback: function(recordss, operation, success) {
                    		if (success) {
                    			for(i in recordss){
                    				if(recordss[i].data.id == records.data.countryOfIssue.id)
                    					countryOfIssue.setValue(recordss[i].data.id);  	
                    			}
                    		}
                    	}
                    });
                    }
          	 
          	var passportNumber = form.down("#passportNumber");
            if(!isNullOrEmpty(records.data.passportNumber))
            	passportNumber.setValue(records.data.passportNumber);
            
            form.loadRecord(records);
          }
      } else {
          showWarningMessage(getPersonModuleTranslation('PASSPORT_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  
  /*Applicant passport details  */
  saveApplicantPassportDetail: function(gridItemId, saveUrl, updateUrl) {

      var this$ = this;
      var isValid = true;
      var submitUrl, isUpdate = false;

      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      var form = this$.getStudentpassportdetailsform();
      form.down('#submitButtonId').setDisabled(true);

          var id = form.down('#Student_Passport_Details_hidden_field');
          if (!isNullOrEmpty(id.getSubmitValue())) {
          	submitUrl = updateUrl,
              isUpdate = true;
          } else {
          	submitUrl = saveUrl,
              isUpdate = false;       
          }
          var jsonFormatFormData = this$.getJsonApplicantPassportData(form,grid,isUpdate);
          this$.applyWindowMask(); 
          this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
              this$.hideWindowMask();
              if(success){
                  this$.closePersonCommonWindow();
                  if(this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7){
                  	try{
                  		personId = this$.getPersonObj().id;
                  		if(isNullOrEmpty(personId)){
                  			personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                  		}
                  	}
                  	catch(e){
                  		personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                  	}
                  	grid.getStore().getProxy().extraParams = {
                  		personId : personId
                  	};
                  }else if(!isNullOrEmpty(personProfile.getPersonInfo())){
	        			grid.getStore().getProxy().extraParams = {
	        				personId : personProfile.getPersonInfo().id
	        			};
	        		}
                  grid.getStore().reload();
                  grid.getSelectionModel().deselectAll();
                  if (isUpdate) {
                      showSuccessMessage(getCommonTranslation('APPLICANT_PASSPORT'), getCommonTranslation('APPLICANT_PASSPORT_UPDATE_SUCCESS'));
                  } else {
                      showSuccessMessage(getCommonTranslation('APPLICANT_PASSPORT'), getCommonTranslation('APPLICANT_PASSPORT_ADD_SUCCESS'));
                  }
              }else{
                  this$.hideWindowMask();
                  this$.closePersonCommonWindow();
                  grid.getStore().reload();
                  form.down('#submitButtonId').setDisabled(false);
              }
          });
  },
  getJsonApplicantPassportData: function(form,grid,isUpdate) { 
      var this$ = this;
      var jsonFormFieldData = new Object();
      var personObj = this$.getPersonObj();
      var formData = form.getValues();
      if (!isEmpty(formData)) {
          var applicantPerson = new Object();
          applicantPerson.id = personObj["id"];
          formData.applicantPerson = applicantPerson;
          if(formData.countryOfIssue=='')
        	  {
        	  formData.countryOfIssue=null;
        	  }
          delete formData.pageSize;
          delete formData.customData;

          var docArray = [];
          var docStore = this$.getStore('personinfo.common.personalinfo.ApplicantPassportDocumentGridStore');
          if (docStore.data.items != null
                  && docStore.data.items.length > 0) {
              Ext.each(docStore.data.items, function(val) {
                  var newData = {
                          "name" : val.data.documentName,
                          "path" : val.data.path,
                          "type" : val.data.type,
                          "id"   : val.data.id,
                          "createdBy" : this$.getIdValueJson(
                                  val.data.createdBy.id,
                                  val.data.createdBy.value)
                  };
                  docArray.push(newData);
              });
          }
          var urlArray = [];
          var urlStore = this$.getStore('personinfo.common.personalinfo.ApplicantPassportUrlGridStore');
          if (urlStore.data.items != null
                  && urlStore.data.items.length > 0) {
              Ext.each(urlStore.data.items, function(val) {
                  var newData = {
                		  "name" : val.data.documentName==null?val.data.name:val.data.documentName,
                          "path" : val.data.path,
                          "id"   : val.data.id,
                  };
                  urlArray.push(newData);
              });
          }
      }
      if (isUpdate==false) {
    	  docArray.length==0&&urlArray.length==0?formData.fileModifiedDate="":'';
      } 
      formData.copyOfPassports = docArray;
      formData.copyOfPassportUrls = urlArray;
      jsonFormFieldData = Ext.encode(formData);
      return jsonFormFieldData;
  },
  editApplicantPassportDetailFormWindow: function(informationType, formItemId, gridItemId, isViewMode) {
      var this$ = this;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);

      if (grid.getSelectionModel().getCount() > 0) {
      	this$.showPersonCommonWindow(undefined, informationType, formItemId, null);
      	var formWindow = this$.getPersonCommonWindow();
      	if(isViewMode!=null && (isViewMode==true || isViewMode=='true')) {
      		formWindow.setTitle(getCommonTranslation('VIEW_APPLICANT_PASSPORT'));
      	}else{
      		formWindow.setTitle(getCommonTranslation('EDIT_PASSPORT'));
      	}
      	  var form = this$.getStudentpassportdetailsform();
          var records = grid.getSelectionModel().getSelection()[0];
          if (!isEmpty(records)) {
        	form.down('#Student_Passport_Details_hidden_field').setValue(records.data.id);
        	  
          	if(!isNullOrEmpty(records.data.passportExpirationDate))
          		records.data.passportExpirationDate = new Date(records.data.passportExpirationDate);
          	
        	var fileModifiedDate = form.down('#fileModifiedDate')
          	if(!isNullOrEmpty(records.data.fileModifiedDate)){
          		records.data.fileModifiedDate = new Date(records.data.fileModifiedDate);
          	}
          		fileModifiedDate.setReadOnly(true);
          	
          		var countryOfIssue = form.down('#countryOfIssue')
             	 if (!isNullOrEmpty(records.data.countryOfIssue)) {		            	
                    countryOfIssue.getStore().load({ 
                    	callback: function(recordss, operation, success) {
                    		if (success) {
                    			for(i in recordss){
                    				if(recordss[i].data.id == records.data.countryOfIssue.id)
                    					countryOfIssue.setValue(recordss[i].data.id);  	
                    			}
                    		}
                    	}
                    });
                    }
          	 
          	var passportNumber = form.down("#passportNumber");
            if(!isNullOrEmpty(records.data.passportNumber))
            	passportNumber.setValue(records.data.passportNumber);
            
            form.loadRecord(records);
          }
      } else {
          showWarningMessage(getPersonModuleTranslation('PASSPORT_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  
  viewApplicantPassportDetailFormWindow: function(informationType, formItemId, gridItemId) {
	  var this$ = this;
	  var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      if (grid.getSelectionModel().getCount() > 0) {
	      this$.editApplicantPassportDetailFormWindow(informationType, formItemId, gridItemId, true);
	      var form = this$.getStudentpassportdetailsform();
	      form.down('#uploadPassportDocItemId').setVisible(false);
	      form.down('#uploadPassportUrlItemId').setVisible(false);
	      var applicantPassportDocGrid = form.down('#applicantpassportdocumentgrid');
	      var applicantPassportUrlGrid = form.down('#applicantpassporturlgrid');
	      applicantPassportDocGrid.down('#btnDelete').setDisabled(true);
	      applicantPassportUrlGrid.down('#btnDelete').setDisabled(true);
	      this$.viewPersonCommonWindow(form);
      } else {
    	  showWarningMessage(getCommonTranslation('VIEW_APPLICANT_PASSPORT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  deleteApplicantPassportDetailRecord:function(gridItemId, deleteUrl) {
      var this$ = this;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      if (grid.getSelectionModel().getCount() > 0) {
          showConfirmMessage(getCommonTranslation('DELETE_APPLICANT_PASSPORT'), getCommonTranslation('APPLICANT_PASSPORT_DELETE_CONFIRM_MESSAGE'), function(btn, text) {
              if (btn == 'yes') {
                  if (grid.getSelectionModel().getCount() > 0) {
                      var records = grid.getSelectionModel().getSelection();
                      var flag=false;
                      for (var count = 0; count < records.length; count++) {
                          var id = "";
                          if (!isNullOrEmpty(records[count].get("id"))) {
                              id = records[count].get("id");
                          }
                          Ext.Ajax.request({
                              type: 'rest',
                              url: deleteUrl,
                              async:false,
                              method: 'DELETE',
                              headers: {
                                  'Content-Type': 'application/json'
                              },
                              params: {
                              	id: id
                              },
                              success: function(form, action) {
                            	  flag=true;
                              }
                          });
                      }
                      if(flag) {
                          grid.getStore().reload();
                          showSuccessMessage(getCommonTranslation('DELETE_APPLICANT_PASSPORT'), getCommonTranslation('APPLICANT_PASSPORT_DELETE_SUCCESS'));
                      }
                  }
              }
          });
      } else {
          showWarningMessage(getCommonTranslation('DELETE_APPLICANT_PASSPORT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  
  /*student Visa details*/
  
  editVisaDetailWindow: function(informationType, formItemId, gridItemId) {
      var this$ = this;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);

      if (grid.getSelectionModel().getCount() > 0) {
      	this$.showPersonCommonWindow(undefined, informationType, formItemId, null);
      	  var form = this$.getVisaform();
          var records = grid.getSelectionModel().getSelection()[0];
          if (!isEmpty(records)) {
        	form.down('#visa_detail_hidden_field').setValue(records.data.id);
        	  
          	if(!isNullOrEmpty(records.data.studentVisaAppliedDate))
          		records.data.visaAppliedDate = records.data.studentVisaAppliedDate;
          	
          	if(!isNullOrEmpty(records.data.studentVisaIssuedDate))
          		records.data.visaIssuedDate = records.data.studentVisaIssuedDate;
          	
          	if(!isNullOrEmpty(records.data.studentVisaCollectedDate))
          		records.data.visaCollectedDate = records.data.studentVisaCollectedDate;
          	
          	if(!isNullOrEmpty(records.data.studentVisaExpiryDate))
          		records.data.visaExpiryDate = records.data.studentVisaExpiryDate;
          	          	
          	var dateCountryEntAllowance = form.down("#dateCountryEntAllowanceItemId");
            if(!isNullOrEmpty(records.data.studentDateOfentryAllowance)) {
//            	var setDateCountryEntAllowanceDate = new Date(records.data.dateOfentryAllowance)
//            	dateCountryEntAllowance.setValue(setDateCountryEntAllowanceDate);
            	records.data.dateOfCountryEntryAllowance = records.data.studentDateOfentryAllowance;
            }
            
//            var visaCancellationDate = form.down("#visaCancellationDateItemId");
//            if(!isNullOrEmpty(records.data.dateOfentryAllowance)) {
//            	var setVisaCancellationDateDate = new Date(records.data.dateOfentryAllowance)
//            	visaCancellationDate.setValue(setVisaCancellationDateDate);
//            }
//            	
          	
          	if(!isNullOrEmpty(records.data.studentVisaCancellationDate))
          		records.data.visaCancellationDate = records.data.studentVisaCancellationDate;
          	
//          	if(!isNullOrEmpty(records.data.auditId))
//          		records.data.auditId = records.data.auditId;
          	
        	
          	
          		var visaType = form.down('#visaTypeItemId')
             	 if (!isNullOrEmpty(records.data.visaType)) {		            	
             		visaType.getStore().load({ 
                    	callback: function(recordss, operation, success) {
                    		if (success) {
                    			for(i in recordss){
                    				if(recordss[i].data.id == records.data.visaType.id)
                    					visaType.setValue(recordss[i].data.id);  	
                    			}
                    		}
                    	}
                    });
                    }
          		
          		var countryOfIssue = form.down('#countryOfIssueItemId')
            	 if (!isNullOrEmpty(records.data.countryOfIssue)) {		            	
                   countryOfIssue.getStore().load({ 
                   	callback: function(recordss, operation, success) {
                   		if (success) {
                   			for(i in recordss){
                   				if(recordss[i].data.id == records.data.countryOfIssue.id)
                   					countryOfIssue.setValue(recordss[i].data.id);  	
                   			}
                   		}
                   	}
                   });
                   }
          		
          		var visaStatus = form.down('#visaStatusItemId')
            	 if (!isNullOrEmpty(records.data.countryOfIssue)) {		            	
            		 visaStatus.getStore().load({ 
                   	callback: function(recordss, operation, success) {
                   		if (success) {
                   			for(i in recordss){
                   				if(recordss[i].data.id == records.data.visaStatus.id)
                   					visaStatus.setValue(recordss[i].data.id);  	
                   			}
                   		}
                   	}
                   });
                   }
          	 
          	var reasonForVisaRefused = form.down("#reasonForVisaRefusedItemId");
            if(!isNullOrEmpty(records.data.reasonVisaRefused))
            	reasonForVisaRefused.setValue(records.data.reasonVisaRefused);
            
            if(!isNullOrEmpty(records.data.isPrimary))
//            	reasonForVisaRefused.setValue(records.data.reasonVisaRefused);
            	records.data.visaIsPrimary = records.data.isPrimary
            form.loadRecord(records);
          }
      } else {
          showWarningMessage(getPersonModuleTranslation('VISA_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  
  saveStudentVisaDetail: function(gridItemId, saveUrl, updateUrl) {

      var this$ = this;
      var isValid = true;
      var submitUrl, isUpdate = false;

      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      var form = this$.getVisaform();
      form.down('#submitButtonId').setDisabled(true);

          var id = form.down('#visa_detail_hidden_field');
          if (!isNullOrEmpty(id.getSubmitValue())) {
          	submitUrl = updateUrl,
              isUpdate = true;
          } else {
          	submitUrl = saveUrl,
              isUpdate = false;       
          }
          var jsonFormatFormData = this$.getJsonStudentVisaData(form,grid,isUpdate);
          this$.applyWindowMask(); 
          this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
              this$.hideWindowMask();
              if(success){
                  this$.closePersonCommonWindow();
                  if(this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7){
                  	try{
                  		personId = this$.getPersonObj().id;
                  		if(isNullOrEmpty(personId)){
                  			personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                  		}
                  	}
                  	catch(e){
                  		personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                  	}
                  	grid.getStore().getProxy().extraParams = {
                  		personId : personId
                  	};
                  }else if(!isNullOrEmpty(personProfile.getPersonInfo())){
	        			grid.getStore().getProxy().extraParams = {
	        				personId : personProfile.getPersonInfo().id
	        			};
	        		}
                  grid.getStore().reload();
                  grid.getSelectionModel().deselectAll();
                  if (isUpdate) {
                      showSuccessMessage(getCommonTranslation('STUDENT_VISA'), getCommonTranslation('STUDENT_VISA_UPDATE_SUCCESSFULLY'));
                  } else {
                      showSuccessMessage(getCommonTranslation('STUDENT_VISA'), getCommonTranslation('STUDENT_VISA_ADD_SUCCESSFULLY'));
                  }
              }else{
                  this$.hideWindowMask();
                  this$.closePersonCommonWindow();
                  grid.getStore().reload();
                  form.down('#submitButtonId').setDisabled(false);
              }
          });
	      

  },
  
  getJsonStudentVisaData: function(form,grid,isUpdate) { 
	  var this$ = this;
      var jsonFormFieldData = new Object();
      var personObj = this$.getPersonObj();
      
      var formData = form.getValues();
      var user=this.getCurrentlyLoggedInUser()
      if(isUpdate) {
	     var record = grid.getSelectionModel().getSelection();
	     formData.auditId = this$.getIdValueJson(record[0].data.auditId.id);
       } else {                        
	        formData.auditId = this$.getIdValueJson(user.id);
       }
      if (!isEmpty(formData)) {
          var person = new Object();
          person.id = personObj["id"];
          formData.person = person;
          if(formData.countryOfIssue=='') {
        	  formData.countryOfIssue=null;
    	  }
    	  formData.reasonVisaRefused = formData.reasonForVisaRefused;
    	  delete formData.reasonForVisaRefused;

    	  formData.isPrimary = formData.visaIsPrimary;
    	  delete formData.visaIsPrimary
    	  
    	  formData.dateOfentryAllowance = formData.dateOfCountryEntryAllowance;
    	  delete formData.dateOfCountryEntryAllowance

    	  if(!formData.hasOwnProperty('visaStatus') || formData.visaStatus == "" || formData.visaStatus.id == "") {
              formData.visaStatus = null;
          }
    	  
          delete formData.pageSize;
          delete formData.customData;
          var docArray = [];
          var docStore = this$.getStore('personinfo.common.personalinfo.StudentVisaDocumentGridStore');
          if (docStore.data.items != null
                  && docStore.data.items.length > 0) {
              Ext.each(docStore.data.items, function(val) {
                  var newData = {
                          "name" : val.data.documentName,
                          "path" : val.data.path,
                          "type" : val.data.type,
                          "createdBy" : this$.getIdValueJson(
                                  val.data.createdBy.id,
                                  val.data.createdBy.value)
                  };
                  docArray.push(newData);
              });
          }
          var urlArray = [];
          var urlStore = this$.getStore('personinfo.common.personalinfo.StudentVisaUrlGridStore');
          if (urlStore.data.items != null
                  && urlStore.data.items.length > 0) {
              Ext.each(urlStore.data.items, function(val) {
                  var newData = {
                          "name" : val.data.documentName,
                          "path" : val.data.path,
                          "type" : val.data.type,
                          "createdBy" : this$.getIdValueJson(
                                  val.data.createdBy.id,
                                  val.data.createdBy.value)
                  };
                  urlArray.push(newData);
              });
          }
      }
      formData.studentVisaDocument = docArray;
      formData.studentVisaDocumentUrl = urlArray;
      jsonFormFieldData = Ext.encode(formData);
      return jsonFormFieldData;
  },
  viewStudentPassportDetail: function(informationType, formItemId, gridItemId) {
	  var this$ = this;
	  var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      if (grid.getSelectionModel().getCount() > 0) {
	      this$.editPassportDetailWindow(informationType, formItemId, gridItemId, true);
	      var form = this$.getStudentpassportdetailsform();
	      form.down('#uploadPassportDocItemId').setVisible(false);
	      form.down('#uploadPassportUrlItemId').setVisible(false);
	      var studentPassportDocGrid = form.down('#studentpassportdocumentgrid');
	      var studentPassportUrlGrid = form.down('#studentpassporturlgrid');
	      studentPassportDocGrid.down('#btnDelete').setDisabled(true);
	      studentPassportUrlGrid.down('#btnDelete').setDisabled(true);
	      this$.viewPersonCommonWindow(form);
      } else {
    	  showWarningMessage(getCommonTranslation('VIEW_STUDENT_PASSPORT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  deleteStudentPassportDetail:function(gridItemId, deleteUrl) {
      var this$ = this;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      if (grid.getSelectionModel().getCount() > 0) {
          showConfirmMessage(getCommonTranslation('DELETE_STUDENT_PASSPORT'), getCommonTranslation('STUDENT_PASSPORT_DELETE_CONFIRM_MESSAGE'), function(btn, text) {
              if (btn == 'yes') {
                  if (grid.getSelectionModel().getCount() > 0) {
                      var records = grid.getSelectionModel().getSelection();
                      var flag=false;
                      for (var count = 0; count < records.length; count++) {
                          var id = "";
                          if (!isNullOrEmpty(records[count].get("id"))) {
                              id = records[count].get("id");
                          }
                          Ext.Ajax.request({
                              type: 'rest',
                              url: deleteUrl,
                              async:false,
                              method: 'DELETE',
                              headers: {
                                  'Content-Type': 'application/json'
                              },
                              params: {
                              	id: id
                              },
                              success: function(form, action) {
                            	  flag=true;
                                }
                          });
                      }
                      if(flag) {
                      grid.getStore().reload();
                      showSuccessMessage(getCommonTranslation('DELETE_STUDENT_PASSPORT'), getCommonTranslation('STUDENT_PASSPORT_DELETE_SUCCESS')); 
                    	  }
                  }
              }
          });
      } else {
          showWarningMessage(getCommonTranslation('DELETE_STUDENT_PASSPORT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  /*student passport details  */

    saveStudentPassportDetail: function(gridItemId, saveUrl, updateUrl) {

      var this$ = this;
      var isValid = true;
      var submitUrl, isUpdate = false;

      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      var form = this$.getStudentpassportdetailsform();
      form.down('#submitButtonId').setDisabled(true);

          var id = form.down('#Student_Passport_Details_hidden_field');
          if (!isNullOrEmpty(id.getSubmitValue())) {
          	submitUrl = updateUrl,
              isUpdate = true;
          } else {
          	submitUrl = saveUrl,
              isUpdate = false;       
          }
          var jsonFormatFormData = this$.getJsonStudentPassportData(form,grid,isUpdate);
          this$.applyWindowMask(); 
          this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
              this$.hideWindowMask();
              if(success){
                  this$.closePersonCommonWindow();
                  if(this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7){
                  	try{
                  		personId = this$.getPersonObj().id;
                  		if(isNullOrEmpty(personId)){
                  			personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                  		}
                  	}
                  	catch(e){
                  		personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                  	}
                  	grid.getStore().getProxy().extraParams = {
                  		personId : personId
                  	};
                  }else if(!isNullOrEmpty(personProfile.getPersonInfo())){
	        			grid.getStore().getProxy().extraParams = {
	        				personId : personProfile.getPersonInfo().id
	        			};
	        		}
                  grid.getStore().reload();
                  grid.getSelectionModel().deselectAll();
                  if (isUpdate) {
                      showSuccessMessage(getCommonTranslation('STUDENT_PASSPORT'), getCommonTranslation('STUDENT_PASSPORT_UPDATE_SUCCESS'));
                  } else {
                      showSuccessMessage(getCommonTranslation('STUDENT_PASSPORT'), getCommonTranslation('STUDENT_PASSPORT_ADD_SUCCESS'));
                  }
              }else{
                  this$.hideWindowMask();
                  this$.closePersonCommonWindow();
                  grid.getStore().reload();
                  form.down('#submitButtonId').setDisabled(false);
              }
          });
	      

  },
  getJsonStudentPassportData: function(form,grid,isUpdate) { 
      var this$ = this;
      var jsonFormFieldData = new Object();
      var personObj = this$.getPersonObj();
      var formData = form.getValues();
      if (!isEmpty(formData)) {
          var person = new Object();
          person.id = personObj["id"];
          formData.person = person;
          if(formData.countryOfIssue=='')
        	  {
        	  formData.countryOfIssue=null;
        	  }
          delete formData.pageSize;
          delete formData.customData;

          var docArray = [];
          var docStore = this$.getStore('personinfo.common.personalinfo.StudentPassportDocumentGridStore');
          if (docStore.data.items != null
                  && docStore.data.items.length > 0) {
              Ext.each(docStore.data.items, function(val) {
                  var newData = {
                          "name" : val.data.documentName,
                          "path" : val.data.path,
                          "type" : val.data.type,
                          "id" : val.data.id,
                          "createdBy" : this$.getIdValueJson(
                                  val.data.createdBy.id,
                                  val.data.createdBy.value)
                  };
                  docArray.push(newData);
              });
          }
          var urlArray = [];
          var urlStore = this$.getStore('personinfo.common.personalinfo.StudentPassportUrlGridStore');
          if (urlStore.data.items != null
                  && urlStore.data.items.length > 0) {
              Ext.each(urlStore.data.items, function(val) {
                  var newData = {
                          "name" : val.data.documentName==null?val.data.name:val.data.documentName,
                          "path" : val.data.path,
                          "id" : val.data.id
                  };
                  urlArray.push(newData);
              });
          }
      }
      if (isUpdate==false) {
    	  docArray.length==0&&urlArray.length==0?formData.fileModifiedDate="":'';
      } 
      formData.copyOfPassports = docArray;
      formData.copyOfPassportUrls = urlArray;
      jsonFormFieldData = Ext.encode(formData);
      return jsonFormFieldData;
  },
  
  editPassportDetailWindow: function(informationType, formItemId, gridItemId, isViewMode) {
      var this$ = this;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);

      if (grid.getSelectionModel().getCount() > 0) {
      	this$.showPersonCommonWindow(undefined, informationType, formItemId, null);
      	var formWindow = this$.getPersonCommonWindow();
      	if(isViewMode!=null && (isViewMode==true || isViewMode=='true')) {
      		formWindow.setTitle(getCommonTranslation('VIEW_STUDENT_PASSPORT'));
      	}else{
      		formWindow.setTitle(getCommonTranslation('EDIT_PASSPORT'));
      	}
      	  var form = this$.getStudentpassportdetailsform();
          var records = grid.getSelectionModel().getSelection()[0];
          if (!isEmpty(records)) {
        	form.down('#Student_Passport_Details_hidden_field').setValue(records.data.id);
        	  
          	if(!isNullOrEmpty(records.data.studentPassportExpirationDate))
          		records.data.passportExpirationDate = records.data.studentPassportExpirationDate;
          	
          	var fileModifiedDate = form.down('#fileModifiedDate')
          	if(!isNullOrEmpty(records.data.studentFileModifiedDate)){
          		records.data.fileModifiedDate = records.data.studentFileModifiedDate;
          	}
          		fileModifiedDate.setReadOnly(true);
          	
          		var countryOfIssue = form.down('#countryOfIssue')
             	 if (!isNullOrEmpty(records.data.countryOfIssue)) {		            	
                    countryOfIssue.getStore().load({ 
                    	callback: function(recordss, operation, success) {
                    		if (success) {
                    			for(i in recordss){
                    				if(recordss[i].data.id == records.data.countryOfIssue.id)
                    					countryOfIssue.setValue(recordss[i].data.id);  	
                    			}
                    		}
                    	}
                    });
                    }
          	 
          	var passportNumber = form.down("#passportNumber");
            if(!isNullOrEmpty(records.data.passportNumber))
            	passportNumber.setValue(records.data.passportNumber);
            
            var passportName = form.down("#passportName");
            if(!isNullOrEmpty(records.data.passportName))
            	passportName.setValue(records.data.passportName);
            
            form.loadRecord(records);
          }
      } else {
          showWarningMessage(getPersonModuleTranslation('PASSPORT_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  
  /*Applicant passport details  */
  saveApplicantPassportDetail: function(gridItemId, saveUrl, updateUrl) {

      var this$ = this;
      var isValid = true;
      var submitUrl, isUpdate = false;

      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      var form = this$.getStudentpassportdetailsform();
      form.down('#submitButtonId').setDisabled(true);

          var id = form.down('#Student_Passport_Details_hidden_field');
          if (!isNullOrEmpty(id.getSubmitValue())) {
          	submitUrl = updateUrl,
              isUpdate = true;
          } else {
          	submitUrl = saveUrl,
              isUpdate = false;       
          }
          var jsonFormatFormData = this$.getJsonApplicantPassportData(form,grid,isUpdate);
          this$.applyWindowMask(); 
          this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
              this$.hideWindowMask();
              if(success){
                  this$.closePersonCommonWindow();
                  if(this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7){
                  	try{
                  		personId = this$.getPersonObj().id;
                  		if(isNullOrEmpty(personId)){
                  			personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                  		}
                  	}
                  	catch(e){
                  		personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                  	}
                  	grid.getStore().getProxy().extraParams = {
                  		personId : personId
                  	};
                  }else if(!isNullOrEmpty(personProfile.getPersonInfo())){
	        			grid.getStore().getProxy().extraParams = {
	        				personId : personProfile.getPersonInfo().id
	        			};
	        		}
                  grid.getStore().reload();
                  grid.getSelectionModel().deselectAll();
                  if (isUpdate) {
                      showSuccessMessage(getCommonTranslation('APPLICANT_PASSPORT'), getCommonTranslation('APPLICANT_PASSPORT_UPDATE_SUCCESS'));
                  } else {
                      showSuccessMessage(getCommonTranslation('APPLICANT_PASSPORT'), getCommonTranslation('APPLICANT_PASSPORT_ADD_SUCCESS'));
                  }
              }else{
                  this$.hideWindowMask();
                  this$.closePersonCommonWindow();
                  grid.getStore().reload();
                  form.down('#submitButtonId').setDisabled(false);
              }
          });
  },
  getJsonApplicantPassportData: function(form,grid,isUpdate) { 
      var this$ = this;
      var jsonFormFieldData = new Object();
      var personObj = this$.getPersonObj();
      var formData = form.getValues();
      if (!isEmpty(formData)) {
          var applicantPerson = new Object();
          applicantPerson.id = personObj["id"];
          formData.applicantPerson = applicantPerson;
          if(formData.countryOfIssue=='')
        	  {
        	  formData.countryOfIssue=null;
        	  }
          delete formData.pageSize;
          delete formData.customData;

          var docArray = [];
          var docStore = this$.getStore('personinfo.common.personalinfo.ApplicantPassportDocumentGridStore');
          if (docStore.data.items != null
                  && docStore.data.items.length > 0) {
              Ext.each(docStore.data.items, function(val) {
                  var newData = {
                          "name" : val.data.documentName,
                          "path" : val.data.path,
                          "type" : val.data.type,
                          "id" : val.data.id,
                          "createdBy" : this$.getIdValueJson(
                                  val.data.createdBy.id,
                                  val.data.createdBy.value)
                  };
                  docArray.push(newData);
              });
          }
          var urlArray = [];
          var urlStore = this$.getStore('personinfo.common.personalinfo.ApplicantPassportUrlGridStore');
          if (urlStore.data.items != null
                  && urlStore.data.items.length > 0) {
              Ext.each(urlStore.data.items, function(val) {
                  var newData = {
                		  "name" : val.data.documentName==null?val.data.name:val.data.documentName,
                          "path" : val.data.path,
                          "id" : val.data.id
                  };
                  urlArray.push(newData);
              });
          }
      }
      if (isUpdate==false) {
    	  docArray.length==0&&urlArray.length==0?formData.fileModifiedDate="":'';
      } 
      formData.copyOfPassports = docArray;
      formData.copyOfPassportUrls = urlArray;
      jsonFormFieldData = Ext.encode(formData);
      return jsonFormFieldData;
  },
  editApplicantPassportDetailFormWindow: function(informationType, formItemId, gridItemId, isViewMode) {
      var this$ = this;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);

      if (grid.getSelectionModel().getCount() > 0) {
      	this$.showPersonCommonWindow(undefined, informationType, formItemId, null);
      	var formWindow = this$.getPersonCommonWindow();
      	if(isViewMode!=null && (isViewMode==true || isViewMode=='true')) {
      		formWindow.setTitle(getCommonTranslation('VIEW_APPLICANT_PASSPORT'));
      	}else{
      		formWindow.setTitle(getCommonTranslation('EDIT_PASSPORT'));
      	}
      	  var form = this$.getStudentpassportdetailsform();
          var records = grid.getSelectionModel().getSelection()[0];
          if (!isEmpty(records)) {
        	form.down('#Student_Passport_Details_hidden_field').setValue(records.data.id);
        	  
          	if(!isNullOrEmpty(records.data.passportExpirationDate))
          		records.data.passportExpirationDate = new Date(records.data.passportExpirationDate);
          	
        	var fileModifiedDate = form.down('#fileModifiedDate')
          	if(!isNullOrEmpty(records.data.fileModifiedDate)){
          		records.data.fileModifiedDate = new Date(records.data.fileModifiedDate);
          	}
          		fileModifiedDate.setReadOnly(true);
          	
          		var countryOfIssue = form.down('#countryOfIssue')
             	 if (!isNullOrEmpty(records.data.countryOfIssue)) {		            	
                    countryOfIssue.getStore().load({ 
                    	callback: function(recordss, operation, success) {
                    		if (success) {
                    			for(i in recordss){
                    				if(recordss[i].data.id == records.data.countryOfIssue.id)
                    					countryOfIssue.setValue(recordss[i].data.id);  	
                    			}
                    		}
                    	}
                    });
                    }
          	 
          	var passportNumber = form.down("#passportNumber");
            if(!isNullOrEmpty(records.data.passportNumber))
            	passportNumber.setValue(records.data.passportNumber);
            
            var passportName = form.down("#passportName");
            if(!isNullOrEmpty(records.data.passportName))
            	passportName.setValue(records.data.passportName);
            
            form.loadRecord(records);
          }
      } else {
          showWarningMessage(getPersonModuleTranslation('PASSPORT_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  
  viewApplicantPassportDetailFormWindow: function(informationType, formItemId, gridItemId) {
	  var this$ = this;
	  var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      if (grid.getSelectionModel().getCount() > 0) {
	      this$.editApplicantPassportDetailFormWindow(informationType, formItemId, gridItemId, true);
	      var form = this$.getStudentpassportdetailsform();
	      form.down('#uploadPassportDocItemId').setVisible(false);
	      form.down('#uploadPassportUrlItemId').setVisible(false);
	      var applicantPassportDocGrid = form.down('#applicantpassportdocumentgrid');
	      var applicantPassportUrlGrid = form.down('#applicantpassporturlgrid');
	      applicantPassportDocGrid.down('#btnDelete').setDisabled(true);
	      applicantPassportUrlGrid.down('#btnDelete').setDisabled(true);
	      this$.viewPersonCommonWindow(form);
      } else {
    	  showWarningMessage(getCommonTranslation('VIEW_APPLICANT_PASSPORT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  deleteApplicantPassportDetailRecord:function(gridItemId, deleteUrl) {
      var this$ = this;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      if (grid.getSelectionModel().getCount() > 0) {
          showConfirmMessage(getCommonTranslation('DELETE_APPLICANT_PASSPORT'), getCommonTranslation('APPLICANT_PASSPORT_DELETE_CONFIRM_MESSAGE'), function(btn, text) {
              if (btn == 'yes') {
                  if (grid.getSelectionModel().getCount() > 0) {
                      var records = grid.getSelectionModel().getSelection();
                      var flag=false;
                      for (var count = 0; count < records.length; count++) {
                          var id = "";
                          if (!isNullOrEmpty(records[count].get("id"))) {
                              id = records[count].get("id");
                          }
                          Ext.Ajax.request({
                              type: 'rest',
                              url: deleteUrl,
                              async:false,
                              method: 'DELETE',
                              headers: {
                                  'Content-Type': 'application/json'
                              },
                              params: {
                              	id: id
                              },
                              success: function(form, action) {
                            	  flag=true;
                              }
                          });
                      }
                      if(flag) {
                          grid.getStore().reload();
                          showSuccessMessage(getCommonTranslation('DELETE_APPLICANT_PASSPORT'), getCommonTranslation('APPLICANT_PASSPORT_DELETE_SUCCESS'));
                      }
                  }
              }
          });
      } else {
          showWarningMessage(getCommonTranslation('DELETE_APPLICANT_PASSPORT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  
  /*student Visa details*/
  
  editVisaDetailWindow: function(informationType, formItemId, gridItemId, isViewMode) {
      var this$ = this;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);

      if (grid.getSelectionModel().getCount() > 0) {
      	this$.showPersonCommonWindow(undefined, informationType, formItemId, null);
      	  var form = this$.getVisaform();
      	  var formWindow = this$.getPersonCommonWindow();
      	  if(isViewMode!=null && (isViewMode==true || isViewMode=='true')) {
      		  formWindow.setTitle(getCommonTranslation('VIEW_STUDENT_VISA'));
      	  }else{
      		  formWindow.setTitle(getCommonTranslation('EDIT_STUDENT_VISA'));
      	  }
          var records = grid.getSelectionModel().getSelection()[0];
          if (!isEmpty(records)) {
        	form.down('#visa_detail_hidden_field').setValue(records.data.id);
        	  
          	if(!isNullOrEmpty(records.data.studentVisaAppliedDate))
          		records.data.visaAppliedDate = records.data.studentVisaAppliedDate;
          	
          	if(!isNullOrEmpty(records.data.studentVisaIssuedDate))
          		records.data.visaIssuedDate = records.data.studentVisaIssuedDate;
          	
          	if(!isNullOrEmpty(records.data.studentVisaCollectedDate))
          		records.data.visaCollectedDate =records.data.studentVisaCollectedDate;
          	
          	if(!isNullOrEmpty(records.data.studentVisaExpiryDate))
          		records.data.visaExpiryDate = records.data.studentVisaExpiryDate;
          	          	
          	var dateCountryEntAllowance = form.down("#dateCountryEntAllowanceItemId");
            if(!isNullOrEmpty(records.data.studentDateOfentryAllowance)) {
//            	var setDateCountryEntAllowanceDate = new Date(records.data.dateOfentryAllowance)
//            	dateCountryEntAllowance.setValue(setDateCountryEntAllowanceDate);
            	records.data.dateOfCountryEntryAllowance = records.data.studentDateOfentryAllowance;
            }
            
//            var visaCancellationDate = form.down("#visaCancellationDateItemId");
//            if(!isNullOrEmpty(records.data.dateOfentryAllowance)) {
//            	var setVisaCancellationDateDate = new Date(records.data.dateOfentryAllowance)
//            	visaCancellationDate.setValue(setVisaCancellationDateDate);
//            }
//            	
          	
          	if(!isNullOrEmpty(records.data.studentVisaCancellationDate))
          		records.data.visaCancellationDate = records.data.studentVisaCancellationDate;
          	
//          	if(!isNullOrEmpty(records.data.auditId))
//          		records.data.auditId = records.data.auditId;
          	
        	
          	
          		var visaType = form.down('#visaTypeItemId')
             	 if (!isNullOrEmpty(records.data.visaType)) {		            	
             		visaType.getStore().load({ 
                    	callback: function(recordss, operation, success) {
                    		if (success) {
                    			for(i in recordss){
                    				if(recordss[i].data.id == records.data.visaType.id)
                    					visaType.setValue(recordss[i].data.id);  	
                    			}
                    		}
                    	}
                    });
                    }
          		
          		var countryOfIssue = form.down('#countryOfIssueItemId')
            	 if (!isNullOrEmpty(records.data.countryOfIssue)) {		            	
                   countryOfIssue.getStore().load({ 
                   	callback: function(recordss, operation, success) {
                   		if (success) {
                   			for(i in recordss){
                   				if(recordss[i].data.id == records.data.countryOfIssue.id)
                   					countryOfIssue.setValue(recordss[i].data.id);  	
                   			}
                   		}
                   	}
                   });
                   }
          		
          		var visaStatus = form.down('#visaStatusItemId')
            	 if (!isNullOrEmpty(records.data.countryOfIssue)) {		            	
            		 visaStatus.getStore().load({ 
                   	callback: function(recordss, operation, success) {
                   		if (success) {
                   			for(i in recordss){
                   				if(recordss[i].data.id == records.data.visaStatus.id)
                   					visaStatus.setValue(recordss[i].data.id);  	
                   			}
                   		}
                   	}
                   });
                   }
          	 
          	var reasonForVisaRefused = form.down("#reasonForVisaRefusedItemId");
            if(!isNullOrEmpty(records.data.reasonVisaRefused))
            	reasonForVisaRefused.setValue(records.data.reasonVisaRefused);
            
            if(!isNullOrEmpty(records.data.isPrimary))
//            	reasonForVisaRefused.setValue(records.data.reasonVisaRefused);
            	records.data.visaIsPrimary = records.data.isPrimary
            form.loadRecord(records);
          }
      } else {
          showWarningMessage(getPersonModuleTranslation('VISA_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  
  
  
  editInsuranceDetailWindow: function(informationType, formItemId, gridItemId, isViewMode) {
      var this$ = this;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      var user=this.getCurrentlyLoggedInUser();

      if (grid.getSelectionModel().getCount() > 0) {
      	this$.showPersonCommonWindow(undefined, informationType, formItemId, null);
      	  var form = this$.getInsuranceform();
      	  var formWindow = this$.getPersonCommonWindow();
      	  if(isViewMode!=null && (isViewMode==true || isViewMode=='true')) {
      		  formWindow.setTitle(getCommonTranslation('VIEW_STUDENT_INSURANCE'));
      	  }else{
      		  formWindow.setTitle(getCommonTranslation('EDIT_STUDENT_INSURANCE'));
      	  }
          var records = grid.getSelectionModel().getSelection()[0];
          if (!isEmpty(records)) {
        	form.down('#insurance_detail_hidden_field').setValue(records.data.id);
           var auditId = form.down("#auditId");
           var validFrom = form.down("#validFrom");
           var validTo = form.down("#validTo");
           var nameOfInsuranceCompany = form.down("#nameOfInsuranceCompany");
           var policyNumber = form.down("#policyNumber");
           var schoolInsuranceCardReceived = form.down("#schoolInsuranceCardReceived");
           var receivedDate = form.down("#receivedDate");
           var remarks = form.down("#remarks");
           if(!isNullOrEmpty(records.data.dateOfentryAllowance)) {
           	var auditId = this$.getIdValueJson(user.id);
           	auditId.setValue(auditId);
           }
          		var schoolInsuranceType = form.down('#schoolInsuranceTypeItemId')
             	 if (!isNullOrEmpty(records.data.schoolInsuranceType)) {		            	
             		schoolInsuranceType.getStore().load({ 
                    	callback: function(recordss, operation, success) {
                    		if (success) {
                    			for(i in recordss){
                    				if(recordss[i].data.id == records.data.schoolInsuranceType.id)
                    					schoolInsuranceType.setValue(recordss[i].data.id);  	
                    			}
                    		}
                    	}
                    });
                    }          
            if(!isNullOrEmpty(records.data.healthInsuranceConfirmed))
            	records.data.healthInsuranceConfirmed = records.data.healthInsuranceConfirmed
            	form.loadRecord(records);            
            if(!isNullOrEmpty(records.data.schoolInsuranceType) && records.data.schoolInsuranceType.value == 'Private Health Insurance'){
            	if(!schoolInsuranceType.isVisible()){
            		validFrom.setVisible(false);
 					validTo.setVisible(false);
 					nameOfInsuranceCompany.setVisible(false);
 					policyNumber.setVisible(false);
 					schoolInsuranceCardReceived.setVisible(false);
 					receivedDate.setVisible(false);
 					validFrom.allowBlank = true;
 					validTo.allowBlank = true;
 					nameOfInsuranceCompany.allowBlank = true;
 					policyNumber.allowBlank = true;
 					schoolInsuranceCardReceived.allowBlank = true;
 					receivedDate.allowBlank = true;
 					validFrom.reset();
 					validTo.reset();
 					nameOfInsuranceCompany.reset();
 					policyNumber.reset();
 					schoolInsuranceCardReceived.items.items[0].setValue(true);
           		    schoolInsuranceCardReceived.items.items[1].setValue(false);
 					receivedDate.reset();
            	}else{
            		this.loadDFRForSchoolInsuranceType(schoolInsuranceType);
            	}
            	
                validFrom.setValue(dateRender(records.data.validFrom));
                validTo.setValue(dateRender(records.data.validTo));
                if(!isNullOrEmpty(records.data.nameOfInsuranceCompany)) {
                	nameOfInsuranceCompany.setValue(records.data.nameOfInsuranceCompany);
                }
                if(!isNullOrEmpty(records.data.policyNumber)) {
                	policyNumber.setValue(records.data.policyNumber);
                }
                if(!isNullOrEmpty(records.data.schoolInsuranceCardReceived)) {
                	 if(records.data.schoolInsuranceCardReceived == true){
                		 schoolInsuranceCardReceived.items.items[0].setValue(true);
                		 schoolInsuranceCardReceived.items.items[1].setValue(false);
                		 this$.loadDFRForSchoolInsuranceCardReceived(schoolInsuranceCardReceived);
                         receivedDate.setValue(dateRender(records.data.receivedDate));
                         if(!schoolInsuranceType.isVisible()){
                        	 receivedDate.setVisible(false);
                     		 receivedDate.allowBlank = true;
                     		 receivedDate.reset();
                     	}
                 	  }else{
                 		 schoolInsuranceCardReceived.items.items[0].setValue(false);
                 		 schoolInsuranceCardReceived.items.items[1].setValue(true);
                 		 receivedDate.setVisible(false);
                 		 receivedDate.allowBlank = true;
                 	  }
                }
            }else {
                validFrom.setVisible(false);
                validTo.setVisible(false);
                nameOfInsuranceCompany.setVisible(false);
                policyNumber.setVisible(false);
                schoolInsuranceCardReceived.setVisible(false);
                receivedDate.setVisible(false);
            }
            if(!isNullOrEmpty(records.data.remarks)) {
            	remarks.setValue(records.data.remarks);
            }
          }
      } else {
          showWarningMessage(getPersonModuleTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  
  
  
  
  saveStudentVisaDetail: function(gridItemId, saveUrl, updateUrl) {

      var this$ = this;
      var isValid = true;
      var submitUrl, isUpdate = false;

      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      var form = this$.getVisaform();
      form.down('#submitButtonId').setDisabled(true);

          var id = form.down('#visa_detail_hidden_field');
          if (!isNullOrEmpty(id.getSubmitValue())) {
          	submitUrl = updateUrl,
              isUpdate = true;
          } else {
          	submitUrl = saveUrl,
              isUpdate = false;       
          }
          var jsonFormatFormData = this$.getJsonStudentVisaData(form,grid,isUpdate);
          this$.applyWindowMask(); 
          this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
              this$.hideWindowMask();
              if(success){
                  this$.closePersonCommonWindow();
                  if(this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7){
                  	try{
                  		personId = this$.getPersonObj().id;
                  		if(isNullOrEmpty(personId)){
                  			personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                  		}
                  	}
                  	catch(e){
                  		personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                  	}
                  	grid.getStore().getProxy().extraParams = {
                  		personId : personId
                  	};
                  }else if(!isNullOrEmpty(personProfile.getPersonInfo())){
	        			grid.getStore().getProxy().extraParams = {
	        				personId : personProfile.getPersonInfo().id
	        			};
	        		}
                  grid.getStore().reload();
                  grid.getSelectionModel().deselectAll();
                  if (isUpdate) {
                      showSuccessMessage(getCommonTranslation('STUDENT_VISA'), getCommonTranslation('STUDENT_VISA_UPDATE_SUCCESSFULLY'));
                  } else {
                      showSuccessMessage(getCommonTranslation('STUDENT_VISA'), getCommonTranslation('STUDENT_VISA_ADD_SUCCESSFULLY'));
                  }
              }else{
                  this$.hideWindowMask();
                  this$.closePersonCommonWindow();
                  grid.getStore().reload();
                  form.down('#submitButtonId').setDisabled(false);
              }
          });
	      

  },
  
  
  
  
  
  
  
  getJsonStudentVisaData: function(form,grid,isUpdate) { 
	  var this$ = this;
      var jsonFormFieldData = new Object();
      var personObj = this$.getPersonObj();
      
      var formData = form.getValues();
      var user=this.getCurrentlyLoggedInUser()
      if(isUpdate) {
	     var record = grid.getSelectionModel().getSelection();
	     formData.auditId = this$.getIdValueJson(record[0].data.auditId.id);
       } else {                        
	        formData.auditId = this$.getIdValueJson(user.id);
       }
      if (!isEmpty(formData)) {
          var person = new Object();
          person.id = personObj["id"];
          formData.person = person;
          if(formData.countryOfIssue=='') {
        	  formData.countryOfIssue=null;
    	  }
    	  formData.reasonVisaRefused = formData.reasonForVisaRefused;
    	  delete formData.reasonForVisaRefused;

    	  formData.isPrimary = formData.visaIsPrimary;
    	  delete formData.visaIsPrimary
    	  
    	  formData.dateOfentryAllowance = formData.dateOfCountryEntryAllowance;
    	  delete formData.dateOfCountryEntryAllowance

    	  if(!formData.hasOwnProperty('visaStatus') || formData.visaStatus == "" || formData.visaStatus.id == "") {
              formData.visaStatus = null;
          }
    	  
          delete formData.pageSize;
          delete formData.customData;
          var docArray = [];
          var docStore = this$.getStore('personinfo.common.personalinfo.StudentVisaDocumentGridStore');
          if (docStore.data.items != null
                  && docStore.data.items.length > 0) {
              Ext.each(docStore.data.items, function(val) {
                  var newData = {
                          "name" : val.data.documentName,
                          "path" : val.data.path,
                          "type" : val.data.type,
                          "id" 	 :val.data.id,
                          "createdBy" : this$.getIdValueJson(
                                  val.data.createdBy.id,
                                  val.data.createdBy.value)
                  };
                  docArray.push(newData);
              });
          }
          var urlArray = [];
          var urlStore = this$.getStore('personinfo.common.personalinfo.StudentVisaUrlGridStore');
          if (urlStore.data.items != null
                  && urlStore.data.items.length > 0) {
              Ext.each(urlStore.data.items, function(val) {
                  var newData = {
                          "name" : val.data.documentName,
                          "path" : val.data.path,
                          "type" : val.data.type,
                          "id" 	 :val.data.id,
                          "createdBy" : this$.getIdValueJson(
                                  val.data.createdBy.id,
                                  val.data.createdBy.value)
                  };
                  urlArray.push(newData);
              });
          }
      }
      formData.studentVisaDocument = docArray;
      formData.studentVisaDocumentUrl = urlArray;
      jsonFormFieldData = Ext.encode(formData);
      return jsonFormFieldData;
  },
  viewStudentVisaDetail: function(informationType, formItemId, gridItemId) {
	  var this$ = this;
	  var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      if (grid.getSelectionModel().getCount() > 0) {
	      this$.editVisaDetailWindow(informationType, formItemId, gridItemId, true);
	      var form =  this$.getVisaform();
	      form.down('#visaUploadFileItemId').setVisible(false);
	      form.down('#visaUploadURLItemId').setVisible(false);
	      var studentVisaDocGrid = form.down('#studentvisadocumentgrid');
	      var studentVisaUrlGrid = form.down('#studentvisaurlgrid');
	      studentVisaDocGrid.down('#btnDelete').setDisabled(true);
	      studentVisaUrlGrid.down('#btnDelete').setDisabled(true);
	      this$.viewPersonCommonWindow(form);
      } else {
    	  showWarningMessage(getCommonTranslation('VIEW_STUDENT_VISA'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  
  /*insurance View*/
  
  viewStudentInsuranceDetail: function(informationType, formItemId, gridItemId) {
	  var this$ = this;
	  var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      if (grid.getSelectionModel().getCount() > 0) {
	      this$.editInsuranceDetailWindow(informationType, formItemId, gridItemId, true);
	      var form =  this$.getInsuranceform();
	      form.down('#insuranceUploadFileItemId').setVisible(false);
	      form.down('#insuranceUploadURLItemId').setVisible(false);
	      var studentInsuranceDocGrid = form.down('#studentinsurancedocumentgrid');
	      var studentInsuranceUrlGrid = form.down('#studentinsuranceurlgrid');
	      studentInsuranceDocGrid.down('#btnDelete').setDisabled(true);
	      studentInsuranceUrlGrid.down('#btnDelete').setDisabled(true);
	      this$.viewPersonCommonWindow(form);
      } else {
    	  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  
  
  deleteStudentInsuranceDetail:function(gridItemId, deleteUrl) {
      var this$ = this;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      if (grid.getSelectionModel().getCount() > 0) {
          showConfirmMessage(getCommonTranslation('ALERT'), getCommonTranslation('STUDENT_INSURANCE_DELETE_CONFIRM_MESSAGE'), function(btn, text) {
              if (btn == 'yes') {
                  if (grid.getSelectionModel().getCount() > 0) {
                      var records = grid.getSelectionModel().getSelection();
                      var flag=false;
                      for (var count = 0; count < records.length; count++) {
                    	  var id = "";
                          if (!isNullOrEmpty(records[count].get("id"))) {
                              id = records[count].get("id");
                          }
                          Ext.Ajax.request({
                        	  type: 'rest',
                        	  url: deleteUrl,
                        	  async:false,
                        	  method: 'DELETE',
                        	  headers: {
                        		  'Content-Type': 'application/json'
                        	  },
                        	  params: {
                        		  id: id
                        	  },
                        	  success: function(form, action) {
                        		 flag=true;
                        	  }
                          });
                      }
                     
                      if (flag)
                    	 {
                    	  grid.getSelectionModel().deselectAll();
                		  grid.getStore().reload();
                		  showSuccessMessage(getCommonTranslation('INSURANCE_SUCCESS'), getCommonTranslation('STUDENT_INSURANCE_DELETE_SUCCESS')); 
                    	 } 
                      
                  }
              }
          });
      } else {
          showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  
  
  
  
  deleteStudentVisaDetail:function(gridItemId, deleteUrl) {
      var this$ = this;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      if (grid.getSelectionModel().getCount() > 0) {
          showConfirmMessage(getCommonTranslation('DELETE_STUDENT_VISA'), getCommonTranslation('STUDENT_VISA_DELETE_CONFIRM_MESSAGE'), function(btn, text) {
              if (btn == 'yes') {
                  if (grid.getSelectionModel().getCount() > 0) {
                      var records = grid.getSelectionModel().getSelection();
                      var flag=false;
                      var ids=[];
                      for (var count = 0; count < records.length; count++) {
                          var id = [];
                          if (!isNullOrEmpty(records[count].get("id"))) {
                              ids.push(records[count].get("id"));
                          }
                      }
                      Ext.Ajax.request({
                    	  type: 'rest',
                    	  url: deleteUrl+'?ids='+ids,
                    	  async:false,
                    	  method: 'DELETE',
                    	  headers: {
                    		  'Content-Type': 'application/json'
                    	  },
                    	  params: {
                    		  ids: ids
                    	  },
                    	  success: function(form, action) {
                    		  grid.getSelectionModel().deselectAll();
                    		  grid.getStore().reload();
                    		  showSuccessMessage(getCommonTranslation('DELETE_STUDENT_VISA'), getCommonTranslation('STUDENT_VISA_DELETE_SUCCESS')); 
                    	  }
                      });
                  }
              }
          });
      } else {
          showWarningMessage(getCommonTranslation('DELETE_STUDENT_VISA'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  
  /*applicant visa code*/
  
  saveApplicantVisaDetail: function(gridItemId, saveUrl, updateUrl) {

      var this$ = this;
      var isValid = true;
      var submitUrl, isUpdate = false;

      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      var form = this$.getVisaform();
      form.down('#submitButtonId').setDisabled(true);

          var id = form.down('#visa_detail_hidden_field');
          if (!isNullOrEmpty(id.getSubmitValue())) {
          	submitUrl = updateUrl,
              isUpdate = true;
          } else {
          	submitUrl = saveUrl,
              isUpdate = false;       
          }
          var jsonFormatFormData = this$.getJsonApplicantVisaData(form,grid,isUpdate);
          this$.applyWindowMask(); 
          this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
              this$.hideWindowMask();
              if(success){
                  this$.closePersonCommonWindow();
                  if(this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7){
                  	try{
                  		personId = this$.getPersonObj().id;
                  		if(isNullOrEmpty(personId)){
                  			personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                  		}
                  	}
                  	catch(e){
                  		personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                  	}
                  	grid.getStore().getProxy().extraParams = {
                  		personId : personId
                  	};
                  }else if(!isNullOrEmpty(personProfile.getPersonInfo())){
	        			grid.getStore().getProxy().extraParams = {
	        				personId : personProfile.getPersonInfo().id
	        			};
	        		}
                  grid.getStore().reload();
                  grid.getSelectionModel().deselectAll();
                  if (isUpdate) {
                      showSuccessMessage(getCommonTranslation('APPLICANT_VISA'), getCommonTranslation('APPLICANT_VISA_UPDATE_SUCCESSFULLY'));
                  } else {
                      showSuccessMessage(getCommonTranslation('APPLICANT_VISA'), getCommonTranslation('APPLICANT_VISA_ADD_SUCCESSFULLY'));
                  }
              }else{
                  this$.hideWindowMask();
                  this$.closePersonCommonWindow();
                  grid.getStore().reload();
                  form.down('#submitButtonId').setDisabled(false);
              }
          });
	      

  },
  
  	/*applicant save Insurance*/
  
  saveApplicantInsuranceDetail: function(gridItemId, saveUrl, updateUrl) {

      var this$ = this;
      var isValid = true;
      var submitUrl, isUpdate = false;

      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      var form = this$.getInsuranceform();
      form.down('#submitButtonId').setDisabled(true);

          var id = form.down('#insurance_detail_hidden_field');
          if (!isNullOrEmpty(id.getSubmitValue())) {
          	submitUrl = updateUrl,
              isUpdate = true;
          } else {
          	submitUrl = saveUrl,
              isUpdate = false;       
          }
          var jsonFormatFormData = this$.getJsonApplicantInsuranceData(form,grid,isUpdate);
          this$.applyWindowMask(); 
          this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
              this$.hideWindowMask();
              if(success){
                  this$.closePersonCommonWindow();
                  if(this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7){
                  	try{
                  		personId = this$.getPersonObj().id;
                  		if(isNullOrEmpty(personId)){
                  			personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                  		}
                  	}
                  	catch(e){
                  		personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                  	}
                  	grid.getStore().getProxy().extraParams = {
                  		personId : personId
                  	};
                  }else if(!isNullOrEmpty(personProfile.getPersonInfo())){
	        			grid.getStore().getProxy().extraParams = {
	        				personId : personProfile.getPersonInfo().id
	        			};
	        		}
                  grid.getStore().reload();
                  grid.getSelectionModel().deselectAll();
                  if (isUpdate) {
                      showSuccessMessage(getCommonTranslation('APPLICANT_INSURANCE'), getCommonTranslation('APPLICANT_INSURANCE_UPDATE_SUCCESSFULLY'));
                  } else {
                      showSuccessMessage(getCommonTranslation('APPLICANT_INSURANCE'), getCommonTranslation('APPLICANT_INSURANCE_ADD_SUCCESSFULLY'));
                  }
              }else{
                  this$.hideWindowMask();
                  this$.closePersonCommonWindow();
                  grid.getStore().reload();
                  form.down('#submitButtonId').setDisabled(false);
              }
          });
	      

  },
  
  
/*applicant Insurance Json data*/
  
  getJsonApplicantInsuranceData: function(form,grid,isUpdate) { 
	  var this$ = this;
      var jsonFormFieldData = new Object();
      var personObj = this$.getPersonObj();
      
      var formData = form.getValues();
      var user=this.getCurrentlyLoggedInUser()
      if(isUpdate) {
	     var record = grid.getSelectionModel().getSelection();
	     formData.auditId = this$.getIdValueJson(record[0].data.auditId.id);
       } else {                        
	        formData.auditId = this$.getIdValueJson(user.id);
       }
      if (!isEmpty(formData)) {
          var applicantPerson = new Object();
          applicantPerson.id = personObj["id"];
          formData.applicantPerson = applicantPerson;

    	  if (!isNullOrEmpty(formData.schoolInsuranceType) && formData.schoolInsuranceType.hasOwnProperty('id')) {
    		  var copyVal = formData.schoolInsuranceType.id;
    		  delete formData.schoolInsuranceType;
    		  formData.schoolInsuranceType = copyVal;
    	   }
          if(formData.applicantInsuranceDocuments=='') {
            	  formData.applicantInsuranceDocuments=null;
           }
              
        	  formData.healthInsuranceConfirmed = formData.healthInsuranceConfirmed;
          
          
          delete formData.pageSize;
          delete formData.customData;
          var docArray = [];
          var docStore = this$.getStore('personinfo.common.personalinfo.ApplicantInsuranceDocumentGridStore');
          if (docStore.data.items != null
                  && docStore.data.items.length > 0) {
              Ext.each(docStore.data.items, function(val) {
                  var newData = {
                          "name" : val.data.documentName,
                          "path" : val.data.path,
                          "type" : val.data.type,
                          "id" : val.data.id,
                          "createdBy" : this$.getIdValueJson(
                                  val.data.createdBy.id,
                                  val.data.createdBy.value)
                  };
                  docArray.push(newData);
              });
          }
          var urlArray = [];
          var urlStore = this$.getStore('personinfo.common.personalinfo.ApplicantInsuranceUrlGridStore');
          if (urlStore.data.items != null
                  && urlStore.data.items.length > 0) {
              Ext.each(urlStore.data.items, function(val) {
                  var newData = {
                          "name" : val.data.documentName,
                          "path" : val.data.path,
                          "type" : val.data.type,
                          "id" : val.data.id,
                          "createdBy" : this$.getIdValueJson(
                                  val.data.createdBy.id,
                                  val.data.createdBy.value)
                  };
                  urlArray.push(newData);
              });
          }
      }
      formData.applicantInsuranceDocuments = docArray;
      formData.applicantInsuranceDocumentUrls = urlArray;
      jsonFormFieldData = Ext.encode(formData);
      return jsonFormFieldData;
  },
  
  
  
  
  getJsonApplicantVisaData: function(form,grid,isUpdate) { 
	  var this$ = this;
      var jsonFormFieldData = new Object();
      var personObj = this$.getPersonObj();
      
      var formData = form.getValues();
      var user=this.getCurrentlyLoggedInUser()
      if(isUpdate) {
	     var record = grid.getSelectionModel().getSelection();
	     formData.auditId = this$.getIdValueJson(record[0].data.auditId.id);
       } else {                        
	        formData.auditId = this$.getIdValueJson(user.id);
       }
      if (!isEmpty(formData)) {
          var person = new Object();
          person.id = personObj["id"];
          formData.person = person;
          if(formData.countryOfIssue=='') {
        	  formData.countryOfIssue=null;
    	  }
    	  formData.reasonVisaRefused = formData.reasonForVisaRefused;
    	  delete formData.reasonForVisaRefused;

    	  formData.isPrimary = formData.visaIsPrimary;
    	  delete formData.visaIsPrimary
    	  
    	  formData.dateOfentryAllowance = formData.dateOfCountryEntryAllowance;
    	  delete formData.dateOfCountryEntryAllowance

    	  if(!formData.hasOwnProperty('visaStatus') || formData.visaStatus == "" || formData.visaStatus.id == "") {
              formData.visaStatus = null;
          }
    	  
          delete formData.pageSize;
          delete formData.customData;
          var docArray = [];
          var docStore = this$.getStore('personinfo.common.personalinfo.ApplicantVisaDocumentGridStore');
          if (docStore.data.items != null
                  && docStore.data.items.length > 0) {
              Ext.each(docStore.data.items, function(val) {
                  var newData = {
                          "name" : val.data.documentName,
                          "path" : val.data.path,
                          "type" : val.data.type,
                          "id" 	 : val.data.id,
                          "createdBy" : this$.getIdValueJson(
                                  val.data.createdBy.id,
                                  val.data.createdBy.value)
                  };
                  docArray.push(newData);
              });
          }
          var urlArray = [];
          var urlStore = this$.getStore('personinfo.common.personalinfo.ApplicantVisaUrlGridStore');
          if (urlStore.data.items != null
                  && urlStore.data.items.length > 0) {
              Ext.each(urlStore.data.items, function(val) {
                  var newData = {
                          "name" : val.data.documentName,
                          "path" : val.data.path,
                          "type" : val.data.type,
                          "id" 	 : val.data.id,
                          "createdBy" : this$.getIdValueJson(
                                  val.data.createdBy.id,
                                  val.data.createdBy.value)
                  };
                  urlArray.push(newData);
              });
          }
      }
      formData.studentVisaDocument = docArray;
      formData.studentVisaDocumentUrl = urlArray;
      jsonFormFieldData = Ext.encode(formData);
      return jsonFormFieldData;
  },
  
  
  
  
  
  
  
  //student Insurance save Code
  saveStudentInsuranceDetail: function(gridItemId, saveUrl, updateUrl) {

      var this$ = this;
      var isValid = true;
      var submitUrl, isUpdate = false;

      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      var form = this.getInsuranceform();
//      var form =Ext.ComponentQuery.query('insuranceform')[0];
      form.down('#submitButtonId').setDisabled(true);

          var id = form.down('#insurance_detail_hidden_field');
          if (!isNullOrEmpty(id.getSubmitValue())) {
          	submitUrl = updateUrl,
              isUpdate = true;
          } else {
          	submitUrl = saveUrl,
              isUpdate = false;       
          }
          var jsonFormatFormData = this$.getJsonStudentInsuranceData(form,grid,isUpdate);
          this$.applyWindowMask(); 
          this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
              this$.hideWindowMask();
              if(success){
                  this$.closePersonCommonWindow();
                  if(this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7){
                  	try{
                  		personId = this$.getPersonObj().id;
                  		if(isNullOrEmpty(personId)){
                  			personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                  		}
                  	}
                  	catch(e){
                  		personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                  	}
                  	grid.getStore().getProxy().extraParams = {
                  		personId : personId
                  	};
                  }else if(!isNullOrEmpty(personProfile.getPersonInfo())){
	        			grid.getStore().getProxy().extraParams = {
	        				personId : personProfile.getPersonInfo().id
	        			};
	        		}
                  grid.getStore().reload();
                  grid.getSelectionModel().deselectAll();
                  if (isUpdate) {
                      showSuccessMessage(getCommonTranslation('INSURANCE_SUCCESS'), getCommonTranslation('STUDENT_INSURANCE_UPDATE_SUCCESSFULLY'));
                  } else {
                      showSuccessMessage(getCommonTranslation('INSURANCE_SUCCESS'), getCommonTranslation('STUDENT_INSURANCE_ADD_SUCCESSFULLY'));
                  }
              }else{
                  this$.hideWindowMask();
                  this$.closePersonCommonWindow();
                  grid.getStore().reload();
                  form.down('#submitButtonId').setDisabled(false);
              }
          });
	      

  },
  

  
  getJsonStudentInsuranceData: function(form,grid,isUpdate) { 
	  var this$ = this;
      var jsonFormFieldData = new Object();
      var personObj = this$.getPersonObj();
      
      var formData = form.getValues();
      var user=this.getCurrentlyLoggedInUser()
      if(isUpdate) {
	     var record = grid.getSelectionModel().getSelection();
	     formData.auditId = this$.getIdValueJson(record[0].data.auditId.id);
       } else {                        
	        formData.auditId = this$.getIdValueJson(user.id);
       }
      
    
	  if (!isNullOrEmpty(formData.schoolInsuranceType) && formData.schoolInsuranceType.hasOwnProperty('id')) {
		  var copyVal = formData.schoolInsuranceType.id;
		  delete formData.schoolInsuranceType;
		  formData.schoolInsuranceType = copyVal;
	   }
      
      if (!isEmpty(formData)) {
          var person = new Object();
          person.id = personObj["id"];
          formData.person = person;
          if(formData.studentInsuranceDocuments=='') {
        	  formData.studentInsuranceDocuments=null;
    	  }
          
    	  formData.healthInsuranceConfirmed = formData.healthInsuranceConfirmed;
    	  
          delete formData.pageSize;
          delete formData.customData;
          var docArray = [];
          var docStore = this$.getStore('personinfo.common.personalinfo.StudentInsuranceDocumentStore');
          if (docStore.data.items != null
                  && docStore.data.items.length > 0) {
              Ext.each(docStore.data.items, function(val) {
                  var newData = {
                          "name" : val.data.documentName,
                          "path" : val.data.path,
                          "type" : val.data.type,
                          "id" : val.data.id,
                          "createdBy" : this$.getIdValueJson(val.data.createdBy.id,val.data.createdBy.value)
                  };
                  docArray.push(newData);
              });
          }
          var urlArray = [];
          var urlStore = this$.getStore('personinfo.common.personalinfo.StudentInsuranceUrlGridStore');
          if (urlStore.data.items != null
                  && urlStore.data.items.length > 0) {
              Ext.each(urlStore.data.items, function(val) {
                  var newData = {
                          "name" : val.data.documentName,
                          "path" : val.data.path,
                          "type" : val.data.type,
                          "id" : val.data.id,
                          "createdBy" : this$.getIdValueJson(
                                  val.data.createdBy.id,
                                  val.data.createdBy.value)
                  };
                  urlArray.push(newData);
              });
          }
      }
      formData.studentInsuranceDocuments = docArray;
      formData.studentInsuranceDocumentUrls = urlArray;
      jsonFormFieldData = Ext.encode(formData);
      return jsonFormFieldData;
  },
  
  
  
  
  editApplicantVisaDetailWindow: function(informationType, formItemId, gridItemId, isViewMode) {
      var this$ = this;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);

      if (grid.getSelectionModel().getCount() > 0) {
      	this$.showPersonCommonWindow(undefined, informationType, formItemId, null);
      	  var form = this$.getVisaform();
      	  var formWindow = this$.getPersonCommonWindow();
      	  if(isViewMode!=null && (isViewMode==true || isViewMode=='true')) {
      		  formWindow.setTitle(getCommonTranslation('VIEW_VISA'));
      	  }else{
      		  formWindow.setTitle(getCommonTranslation('EDIT_VISA'));
      	  }
          var records = grid.getSelectionModel().getSelection()[0];
          if (!isEmpty(records)) {
        	form.down('#visa_detail_hidden_field').setValue(records.data.id);
        	  
          	if(!isNullOrEmpty(records.data.visaAppliedDate))
          		records.data.visaAppliedDate = new Date(records.data.visaAppliedDate);
          	
          	if(!isNullOrEmpty(records.data.visaIssuedDate))
          		records.data.visaIssuedDate = new Date(records.data.visaIssuedDate);
          	
          	if(!isNullOrEmpty(records.data.visaCollectedDate))
          		records.data.visaCollectedDate = new Date(records.data.visaCollectedDate);
          	
          	if(!isNullOrEmpty(records.data.visaExpiryDate))
          		records.data.visaExpiryDate = new Date(records.data.visaExpiryDate);
          	          	
          	var dateCountryEntAllowance = form.down("#dateCountryEntAllowanceItemId");
            if(!isNullOrEmpty(records.data.dateOfentryAllowance)) {
            	records.data.dateOfCountryEntryAllowance = new Date(records.data.dateOfentryAllowance);
            }
            
      	
          	if(!isNullOrEmpty(records.data.visaCancellationDate))
          		records.data.visaCancellationDate = new Date(records.data.visaCancellationDate);
          	          	
          	
          		var visaType = form.down('#visaTypeItemId')
             	 if (!isNullOrEmpty(records.data.visaType)) {		            	
             		visaType.getStore().load({ 
                    	callback: function(recordss, operation, success) {
                    		if (success) {
                    			for(i in recordss){
                    				if(recordss[i].data.id == records.data.visaType.id)
                    					visaType.setValue(recordss[i].data.id);  	
                    			}
                    		}
                    	}
                    });
                    }
          		
          		var countryOfIssue = form.down('#countryOfIssueItemId')
            	 if (!isNullOrEmpty(records.data.countryOfIssue)) {		            	
                   countryOfIssue.getStore().load({ 
                   	callback: function(recordss, operation, success) {
                   		if (success) {
                   			for(i in recordss){
                   				if(recordss[i].data.id == records.data.countryOfIssue.id)
                   					countryOfIssue.setValue(recordss[i].data.id);  	
                   			}
                   		}
                   	}
                   });
                   }
          		
          		var visaStatus = form.down('#visaStatusItemId')
            	 if (!isNullOrEmpty(records.data.countryOfIssue)) {		            	
            		 visaStatus.getStore().load({ 
                   	callback: function(recordss, operation, success) {
                   		if (success) {
                   			for(i in recordss){
                   				if(recordss[i].data.id == records.data.visaStatus.id)
                   					visaStatus.setValue(recordss[i].data.id);  	
                   			}
                   		}
                   	}
                   });
                   }
          	 
          	var reasonForVisaRefused = form.down("#reasonForVisaRefusedItemId");
            if(!isNullOrEmpty(records.data.reasonVisaRefused))
            	reasonForVisaRefused.setValue(records.data.reasonVisaRefused);
            
            if(!isNullOrEmpty(records.data.isPrimary))
            	records.data.visaIsPrimary = records.data.isPrimary
            form.loadRecord(records);
          }
      } else {
          showWarningMessage(getCommonTranslation('EDIT_VISA'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  
  /*applicant insurance edit*/
  
  
  
  editApplicantInsuranceDetailWindow: function(informationType, formItemId, gridItemId, isViewMode) {
      var this$ = this;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);

      if (grid.getSelectionModel().getCount() > 0) {
      	this$.showPersonCommonWindow(undefined, informationType, formItemId, null);
      	  var form = this$.getInsuranceform();
      	  var formWindow = this$.getPersonCommonWindow();
      	  if(isViewMode!=null && (isViewMode==true || isViewMode=='true')) {
      		  formWindow.setTitle(getCommonTranslation('VIEW_INSURANCE'));
      	  }else{
      		  formWindow.setTitle(getCommonTranslation('EDIT_INSURANCE'));
      	  }
          var records = grid.getSelectionModel().getSelection()[0];
          if (!isEmpty(records)) {

           form.down('#insurance_detail_hidden_field').setValue(records.data.id);
           var validFrom = form.down("#validFrom");
           var validTo = form.down("#validTo");
           var nameOfInsuranceCompany = form.down("#nameOfInsuranceCompany");
           var policyNumber = form.down("#policyNumber");
           var schoolInsuranceCardReceived = form.down("#schoolInsuranceCardReceived");
           var receivedDate = form.down("#receivedDate");
           var remarks = form.down("#remarks");
           var auditId = form.down("#auditId");
           if(!isNullOrEmpty(records.data.dateOfentryAllowance)) {
           	var auditId = this$.getIdValueJson(user.id);
           	auditId.setValue(auditId);
           }
          		var schoolInsuranceType = form.down('#schoolInsuranceTypeItemId')
             	 if (!isNullOrEmpty(records.data.schoolInsuranceType)) {		            	
             		schoolInsuranceType.getStore().load({ 
                    	callback: function(recordss, operation, success) {
                    		if (success) {
                    			for(i in recordss){
                    				if(recordss[i].data.id == records.data.schoolInsuranceType.id)
                    					schoolInsuranceType.setValue(recordss[i].data.id);  	
                    			}
                    		}
                    	}
                    });
                    }          
            if(!isNullOrEmpty(records.data.healthInsuranceConfirmed))
            	records.data.healthInsuranceConfirmed = records.data.healthInsuranceConfirmed
            	form.loadRecord(records);
            if(!isNullOrEmpty(records.data.schoolInsuranceType) && records.data.schoolInsuranceType.value == 'Private Health Insurance'){
            	if(!schoolInsuranceType.isVisible()){
            		validFrom.setVisible(false);
 					validTo.setVisible(false);
 					nameOfInsuranceCompany.setVisible(false);
 					policyNumber.setVisible(false);
 					schoolInsuranceCardReceived.setVisible(false);
 					receivedDate.setVisible(false);
 					validFrom.allowBlank = true;
 					validTo.allowBlank = true;
 					nameOfInsuranceCompany.allowBlank = true;
 					policyNumber.allowBlank = true;
 					schoolInsuranceCardReceived.allowBlank = true;
 					receivedDate.allowBlank = true;
 					validFrom.reset();
 					validTo.reset();
 					nameOfInsuranceCompany.reset();
 					policyNumber.reset();
 					schoolInsuranceCardReceived.items.items[0].setValue(true);
           		    schoolInsuranceCardReceived.items.items[1].setValue(false);
 					receivedDate.reset();
            	}else{
            		this.loadDFRForSchoolInsuranceType(schoolInsuranceType);
            	}
            	
                validFrom.setValue(dateRender(records.data.validFrom));
                validTo.setValue(dateRender(records.data.validTo));
                if(!isNullOrEmpty(records.data.nameOfInsuranceCompany)) {
                	nameOfInsuranceCompany.setValue(records.data.nameOfInsuranceCompany);
                }
                if(!isNullOrEmpty(records.data.policyNumber)) {
                	policyNumber.setValue(records.data.policyNumber);
                }
                if(!isNullOrEmpty(records.data.schoolInsuranceCardReceived)) {
                	 if(records.data.schoolInsuranceCardReceived == true){
                		 schoolInsuranceCardReceived.items.items[0].setValue(true);
                		 schoolInsuranceCardReceived.items.items[1].setValue(false);
                		 this.loadDFRForSchoolInsuranceCardReceived(schoolInsuranceCardReceived);
                         receivedDate.setValue(dateRender(records.data.receivedDate));
                         if(!schoolInsuranceType.isVisible()){
                        	 receivedDate.setVisible(false);
                     		 receivedDate.allowBlank = true;
                     		 receivedDate.reset();
                     	}
                 	   }else{
                 		 schoolInsuranceCardReceived.items.items[0].setValue(false);
                 		 schoolInsuranceCardReceived.items.items[1].setValue(true);
                 		 receivedDate.setVisible(false);
                 		 receivedDate.allowBlank = true;
                 	   }
                }
            }else {
                validFrom.setVisible(false);
                validTo.setVisible(false);
                nameOfInsuranceCompany.setVisible(false);
                policyNumber.setVisible(false);
                schoolInsuranceCardReceived.setVisible(false);
                receivedDate.setVisible(false);
            }
            if(!isNullOrEmpty(records.data.remarks)) {
            	remarks.setValue(records.data.remarks);
            }
          }
      } else {
          showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  
  
  

  viewApplicantVisaDetail: function(informationType, formItemId, gridItemId) {
	  var this$ = this;
	  var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      if (grid.getSelectionModel().getCount() > 0) {
	      this$.editApplicantVisaDetailWindow(informationType, formItemId, gridItemId, true);
	      var form =  this$.getVisaform();
	      form.down('#visaUploadFileItemId').setVisible(false);
	      form.down('#visaUploadURLItemId').setVisible(false);
	      var studentVisaDocGrid = form.down('#applicantvisadocumentgrid');
	      var studentVisaUrlGrid = form.down('#applicantvisaurlgrid');
	      studentVisaDocGrid.down('#btnDelete').setDisabled(true);
	      studentVisaUrlGrid.down('#btnDelete').setDisabled(true);
	      this$.viewPersonCommonWindow(form);
      } else {
    	  showWarningMessage(getCommonTranslation('VIEW_VISA'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  
  /*view and delete applicant Insurance*/
  
  
  viewApplicantInsuranceDetail: function(informationType, formItemId, gridItemId) {
	  var this$ = this;
	  var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      if (grid.getSelectionModel().getCount() > 0) {
	      this$.editApplicantInsuranceDetailWindow(informationType, formItemId, gridItemId, true);
	      var form =  this$.getInsuranceform();
	      form.down('#insuranceUploadFileItemId').setVisible(false);
	      form.down('#insuranceUploadURLItemId').setVisible(false);
	      var applicantInsuranceDocGrid = form.down('#applicantinsurancedocumentgrid');
	      var applicantInsuranceUrlGrid = form.down('#applicantinsuranceurlgrid');
	      applicantInsuranceDocGrid.down('#btnDelete').setDisabled(true);
	      applicantInsuranceUrlGrid.down('#btnDelete').setDisabled(true);
	      this$.viewPersonCommonWindow(form);
      } else {
    	  showWarningMessage(getCommonTranslation('VIEW_VISA'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  
  deleteApplicantInsuranceDetail:function(gridItemId, deleteUrl) {
      var this$ = this;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      if (grid.getSelectionModel().getCount() > 0) {
          showConfirmMessage(getCommonTranslation('ALERT'), getCommonTranslation('APPLICANT_INSURANCE_DELETE_CONFIRM_MESSAGE'), function(btn, text) {
              if (btn == 'yes') {
                  if (grid.getSelectionModel().getCount() > 0) {
                      var records = grid.getSelectionModel().getSelection();
                      var flag=false;
                      for (var count = 0; count < records.length; count++) {
                    	  var id = "";
                          if (!isNullOrEmpty(records[count].get("id"))) {
                              id = records[count].get("id");
                          }
                          Ext.Ajax.request({
                        	  type: 'rest',
                        	  url: deleteUrl,
                        	  async:false,
                        	  method: 'DELETE',
                        	  headers: {
                        		  'Content-Type': 'application/json'
                        	  },
                        	  params: {
                        		  id: id
                        	  },
                        	  success: function(form, action) {
                        		 flag=true;
                        	  }
                          });
                      }
                     
                      if (flag)
                    	 {
                    	  grid.getSelectionModel().deselectAll();
                		  grid.getStore().reload();
                		  showSuccessMessage(getCommonTranslation('INSURANCE_SUCCESS'), getCommonTranslation('APPLICANT_INSURANCE_DELETE_SUCCESS')); 
                    	 } 
                      
                  }
              }
          });
      } else {
          showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  
  
  
  deleteApplicantVisaDetail:function(gridItemId, deleteUrl) {
      var this$ = this;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      if (grid.getSelectionModel().getCount() > 0) {
          showConfirmMessage(getCommonTranslation('DELETE_APPLICANT_VISA'), getCommonTranslation('APPLICANT_VISA_DELETE_CONFIRM_MESSAGE'), function(btn, text) {
              if (btn == 'yes') {
                  if (grid.getSelectionModel().getCount() > 0) {
                      var records = grid.getSelectionModel().getSelection();
                      var flag=false;
                      var ids=[];
                      for (var count = 0; count < records.length; count++) {
                          var id = [];
                          if (!isNullOrEmpty(records[count].get("id"))) {
                              ids.push(records[count].get("id"));
                          }
                      }
                      Ext.Ajax.request({
                    	  type: 'rest',
                    	  url: deleteUrl,
                    	  async:false,
                    	  method: 'DELETE',
                    	  headers: {
                    		  'Content-Type': 'application/json'
                    	  },
                    	  params: {
                    		  ids: ids.join()
                    	  },
                    	  success: function(form, action) {
                    		  grid.getSelectionModel().deselectAll();
                    		  grid.getStore().reload();
                    		  showSuccessMessage(getCommonTranslation('DELETE_APPLICANT_VISA'), getCommonTranslation('APPLICANT_VISA_DELETE_SUCCESS')); 
                    	  }
                      });
                  }
              }
          });
      } else {
          showWarningMessage(getCommonTranslation('DELETE_APPLICANT_VISA'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  /* applicant visa code end*/
  
  viewStudentPassportDetail: function(informationType, formItemId, gridItemId) {
	  var this$ = this;
	  var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      if (grid.getSelectionModel().getCount() > 0) {
	      this$.editPassportDetailWindow(informationType, formItemId, gridItemId, true);
	      var form = this$.getStudentpassportdetailsform();
	      form.down('#uploadPassportDocItemId').setVisible(false);
	      form.down('#uploadPassportUrlItemId').setVisible(false);
	      var studentPassportDocGrid = form.down('#studentpassportdocumentgrid');
	      var studentPassportUrlGrid = form.down('#studentpassporturlgrid');
	      studentPassportDocGrid.down('#btnDelete').setDisabled(true);
	      studentPassportUrlGrid.down('#btnDelete').setDisabled(true);
	      this$.viewPersonCommonWindow(form);
      } else {
    	  showWarningMessage(getCommonTranslation('VIEW_STUDENT_PASSPORT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  deleteStudentPassportDetail:function(gridItemId, deleteUrl) {
      var this$ = this;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      if (grid.getSelectionModel().getCount() > 0) {
          showConfirmMessage(getCommonTranslation('DELETE_STUDENT_PASSPORT'), getCommonTranslation('STUDENT_PASSPORT_DELETE_CONFIRM_MESSAGE'), function(btn, text) {
              if (btn == 'yes') {
                  if (grid.getSelectionModel().getCount() > 0) {
                      var records = grid.getSelectionModel().getSelection();
                      var flag=false;
                      for (var count = 0; count < records.length; count++) {
                          var id = "";
                          if (!isNullOrEmpty(records[count].get("id"))) {
                              id = records[count].get("id");
                          }
                          Ext.Ajax.request({
                              type: 'rest',
                              url: deleteUrl,
                              async:false,
                              method: 'DELETE',
                              headers: {
                                  'Content-Type': 'application/json'
                              },
                              params: {
                              	id: id
                              },
                              success: function(form, action) {
                            	  flag=true;
                                }
                          });
                      }
                      if(flag) {
                      grid.getSelectionModel().deselectAll();
                      grid.getStore().reload();
                      showSuccessMessage(getCommonTranslation('DELETE_STUDENT_PASSPORT'), getCommonTranslation('STUDENT_PASSPORT_DELETE_SUCCESS')); 
                    	  }
                  }
              }
          });
      } else {
          showWarningMessage(getCommonTranslation('DELETE_STUDENT_PASSPORT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  saveApplicantHostelPersonalRequirmentDetails: function(obj){
    	var this$ = this,mainObj;
    	var personProfile = this$.getContentPanelActiveTab();
    	var personId;
    	var applicationId;
    	try{
    		personId = personProfile.getPersonId();
    		applicationId = personProfile.applicationId;
    	}catch(e){
    		personId = this$.getContentPanel().items.items[0].getPersonId();
    		applicationId = this$.getContentPanel().items.items[0].applicationId;
    	}
    	
    	var form = obj.up('form');
    	var locationDropdown = form.down('#academyLocationCombo');
    	
    	if(!isNullOrEmpty(form)){
    		var jsonFormatFormData = form.getForm().getValues();
    		var isHostelRequired = jsonFormatFormData.whetherHostelApplicable;
    		jsonFormatFormData.person = {id:personId};
    		var isDataValid = true;
    		var alHostelMap = new Ext.util.HashMap();
    		var applicantHostelDetailsJsonArry = [];
    		 var panelContiner = form.down('#hostelPreferencePanel');
    		if (jsonFormatFormData["academyLocationCombo"].length != null && jsonFormatFormData["academyLocationCombo"].length > 0) {
    			 for (var i = 0; i < jsonFormatFormData["academyLocationCombo"].length; i++) {
    				
    				 var panelContainerInner = panelContiner.items.items[i].items.items;
    				 
    				var ALCombo =  panelContainerInner[0].getValue();
    				var lastSelectVal=panelContainerInner[0].lastSelection[0].data.displayOtherLanguage;
    				var hostelDetailsId1 = panelContainerInner[1].getValue();
    				var hostelDetailsId2 = panelContainerInner[2].getValue();
    				var hostelDetailsId3 =  panelContainerInner[3].getValue();
    				if(!isNullOrEmpty(hostelDetailsId1)){
    					mainObj = {
		            			"hostel" : {"id" : hostelDetailsId1},
		            			"academyLocation" :{"id" :parseInt(lastSelectVal)},
		            			"location":{"id":ALCombo},
		            			"sequence":1
		            	}
    					applicantHostelDetailsJsonArry.push(mainObj);
    					alHostelMap.add(ALCombo, hostelDetailsId1);
    					
    				}
    				
    				if(!isNullOrEmpty(hostelDetailsId2)){
    					mainObj = {
		            			"hostel" : {"id" : hostelDetailsId2},
		            			"academyLocation" :{"id" :parseInt(lastSelectVal)},
		            			"location":{"id":ALCombo},
		            			"sequence":2
		            	}
    					applicantHostelDetailsJsonArry.push(mainObj);
    					alHostelMap.add(ALCombo, hostelDetailsId2);
    				}
    				
    				if(!isNullOrEmpty(hostelDetailsId3)){
    					mainObj = {
		            			"hostel" : {"id" : hostelDetailsId3},
		            			"academyLocation" :{"id" :parseInt(lastSelectVal)},
		            			"location":{"id":ALCombo},
		            			"sequence":3
		            	}
    					applicantHostelDetailsJsonArry.push(mainObj);
    					alHostelMap.add(ALCombo, hostelDetailsId3);
    				}
    				 delete jsonFormatFormData.applicantHostelDetails1;
    				 delete jsonFormatFormData.applicantHostelDetails2;   	
    				 delete jsonFormatFormData.applicantHostelDetails3;
    				 
    				
        		 }
			}else{
				 var panelContainerInner = panelContiner.items.items[0].items.items;
				 
 				var ALCombo =  panelContainerInner[0].getValue();
 				var lastSelectVal=panelContainerInner[0].lastSelection[0].data.displayOtherLanguage;
 				var hostelDetailsId1 = panelContainerInner[1].getValue();
 				var hostelDetailsId2 = panelContainerInner[2].getValue();
 				var hostelDetailsId3 =  panelContainerInner[3].getValue();
 				if(!isNullOrEmpty(hostelDetailsId1)){
 					mainObj = {
		            			"hostel" : {"id" : hostelDetailsId1},
		            			"academyLocation" :{"id" :parseInt(lastSelectVal)},
		            			"location":{"id":ALCombo},
		            			"sequence":1
		            	}
 					applicantHostelDetailsJsonArry.push(mainObj);
 					alHostelMap.add(ALCombo, hostelDetailsId1);
 					
 				}
 				
 				if(!isNullOrEmpty(hostelDetailsId2)){
 					mainObj = {
		            			"hostel" : {"id" : hostelDetailsId2},
		            			"academyLocation" :{"id" :parseInt(lastSelectVal)},
		            			"location":{"id":ALCombo},
		            			"sequence":2
		            	}
 					applicantHostelDetailsJsonArry.push(mainObj);
 					alHostelMap.add(ALCombo, hostelDetailsId2);
 				}
 				
 				if(!isNullOrEmpty(hostelDetailsId3)){
 					mainObj = {
		            			"hostel" : {"id" : hostelDetailsId3},
		            			"academyLocation" :{"id" :parseInt(lastSelectVal)},
		            			"location":{"id":ALCombo},
		            			"sequence":3
		            	}
 					applicantHostelDetailsJsonArry.push(mainObj);
 					alHostelMap.add(ALCombo, hostelDetailsId3);
 				}
		    		
			}
    		
    		 delete jsonFormatFormData.applicantHostelDetails1;
			 delete jsonFormatFormData.applicantHostelDetails2;   	
			 delete jsonFormatFormData.applicantHostelDetails3;
    		if(!isNullOrEmpty(jsonFormatFormData.waitingListType)){
    			jsonFormatFormData.waitingListType = {"id" : jsonFormatFormData.waitingListType};
        	} else {
        		delete jsonFormatFormData.waitingListType;
        	}
    		
    		delete jsonFormatFormData.waitingListSetup;
    		delete jsonFormatFormData.academyLocationCombo;
    		var locationItems =  locationDropdown.getStore().data.items;
    		if (!isNullOrEmpty(locationItems) && locationDropdown.isVisible() && isHostelRequired == true) {
    			Ext.each(locationItems, function(location) {
    				if (!alHostelMap.containsKey(location.data.id)) {
    					isDataValid = false;
    					return;
					}
    			});
			}
    		if (!isDataValid) {
    			showWarningMessage(getCommonTranslation('ALERT'), getPersonModuleTranslation('PLEASE_SELECT_ATLEAST_ONE_HOSTEL_FOR_EATCH_LOCATION'));
    			return false;
			}
            jsonFormatFormData.applicantHostelDetails = applicantHostelDetailsJsonArry;
    		
    		if( !isNullOrEmpty(jsonFormatFormData.whetherHostelApplicable) ){
    			if( !jsonFormatFormData.whetherHostelApplicable ){
    				//reset hostel fields to blank
    				this.resetHostelPersonalRequirementFieldsToBlank(form);
    				this.resetHostelPersonalRequirementCustomFieldsToBlank(form);
    				if( !isNullOrEmpty(form.down('#applicantHostelDetailsId')) ){
    		    		form.down('#applicantHostelDetailsId').reset();
    		    	}
    		    	if( !isNullOrEmpty(form.down('#tempAccommondationId')) ){
    		    		form.down('#tempAccommondationId').setValue({tempAccommondationType: false});
    		    	}
    		    	if( !isNullOrEmpty(form.down('#applyForWaitingListTypeId')) ){
    		    		form.down('#applyForWaitingListTypeId').setValue({applyForWaitingList: false});
    		    	}
    			}
    		} else{
    			//reset hostel fields to blank
    			this.resetHostelPersonalRequirementFieldsToBlank(form);
    			this.resetHostelPersonalRequirementCustomFieldsToBlank(form);
            	if( !isNullOrEmpty(form.down('#applicantHostelDetailsId')) ){
		    		form.down('#applicantHostelDetailsId').reset();
		    	}
		    	if( !isNullOrEmpty(form.down('#tempAccommondationId')) ){
		    		form.down('#tempAccommondationId').setValue({tempAccommondationType: false});
		    	}
		    	if( !isNullOrEmpty(form.down('#applyForWaitingListTypeId')) ){
		    		form.down('#applyForWaitingListTypeId').setValue({applyForWaitingList: false});
		    	}
    		}
    		jsonFormatFormData.isCalledFromCoreErp=true;
    		var submitUrl = SERVERURL.PATH_SAVE_APPLICANT_HOSTEL_PERSONAL_INFO;
    		if(!isNullOrEmpty(jsonFormatFormData.id)){
//    			submitUrl = SERVERURL.PATH_UPDATE_APPLICANT_HOSTEL_PERSONAL_INFO;
    		} 
    		var myMask = new Ext.LoadMask(Ext.getBody(), {msg:"Please wait..."});
    		myMask.show();
    		
    		this$.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
    			myMask.hide();
                if (success, form) {
                    var data = Ext.decode(response.responseText);
                    if(response.responseText == 0) {
                    	form.down('#idItemId').setValue(null);
                    }
                    else if(response.responseText > 0) {
                    	form.down('#idItemId').setValue(response.responseText);
                    }
                    else {
                    }
                    //var applicationId = applicantProfile.getApplicationId();
                    if (!isNullOrEmpty(applicationId)) {
                        var url = SERVERURL.APPLICATIONS_GET_APPLICANT_SUMMARY;
                        if(!isNullOrEmpty(url)){
                        	url = url.concat("?id=" + applicationId);
                            Ext.Ajax.request({
                                type: 'rest',
                                url: url,
                                method: 'GET',
                                success: function(res, action) {
                                	var data = Ext.decode(res.responseText);
                                    if(!isNullOrEmpty(data) && !isNullOrEmpty(data.currentStatus)){
                                    	//data.currentStatus = getAdmissionTranslation(data.currentStatus);
                                    	var applicantProfileView = personProfile.down('#applicantProfileTemplate');
                                        if(!isNullOrEmpty(applicantProfileView)){
                                        	var tpl = applicantProfileView.tpl;
                                        	if(!isNullOrEmpty(tpl)){
                                        		tpl.overwrite(applicantProfileView.el.dom, data);
                                        	}
                                        }
                                    }
                                }
                            });
                        }
                     }
                    //this$.setApplicantHostelRequirementInfo(form);
                    showSuccessMessage('Hostel Personal Requirements', 'Hostel personal requirements updated successfully');
                   /* var tabName = getPersonModuleTranslation('HOSTEL_PERSONAL_REQUIREMENTS');
			    		 var tabDetail = personProfile.down('personinfopanel').items.items;
			        	 for(var i in tabDetail){
			        		 if(tabDetail[i].title==tabName){
			        			 tabDetail[i].close();
			        		 }
			        	 }*/
                }
            });
    		
    	}
    },
    saveStudentHostelPersonalRequirmentDetails: function(obj){
    	var this$ = this;
    	var personProfile = this$.getContentPanelActiveTab();
    	var personId;
    	var applicationId;
    	try{
    		personId = personProfile.getPersonId();
    		applicationId = personProfile.applicationId;
    	}catch(e){
    		personId = this$.getContentPanel().items.items[0].getPersonId();
    		applicationId = this$.getContentPanel().items.items[0].applicationId;
    	}
    	
    	var form = obj.up('form');
    	
    	if(!isNullOrEmpty(form)){
    		var jsonFormatFormData = form.getForm().getValues();
    		//jsonFormatFormData.personId = personId;
    		jsonFormatFormData.person = {id:personId};
    		
    		var studentHostelDetailsJsonArry = [];
    		if (jsonFormatFormData["stdAcademyLocationCombo"].length != null && jsonFormatFormData["stdAcademyLocationCombo"].length > 0) {
   			 for (var i = 0; i < jsonFormatFormData["stdAcademyLocationCombo"].length; i++) {
    			 
				 if(!isNullOrEmpty(jsonFormatFormData.studentHostelDetails1)){
		    			var mainObj = '';
		    			var location = null;
		    			var hostel = null;
		    			if (!isNullOrEmpty(jsonFormatFormData["stdAcademyLocationCombo"][i])) {
		    				
		    				location= {"id" : jsonFormatFormData["stdAcademyLocationCombo"][i]};
						}
		    			if(!isArray(jsonFormatFormData["studentHostelDetails1"])){
		    				 hostel = {"id" : jsonFormatFormData.studentHostelDetails1.id}
		    				 delete jsonFormatFormData.studentHostelDetails1;
	                     }else{
	                    	 hostel = {
	            					"id" : jsonFormatFormData.studentHostelDetails1[i].id
	            			} 
	                     }
		    			mainObj = {
		    					"hostel" : hostel,
		            			"academyLocation" :location,
		            			"sequence":1
		            	}
		    			studentHostelDetailsJsonArry.push(mainObj);
		    			
		        		
		        	}
		    		if(!isNullOrEmpty(jsonFormatFormData.studentHostelDetails2)){
		    			var mainObj = '';
		    			var location = null;
		    			var hostel = null;
		    			if (!isNullOrEmpty(jsonFormatFormData["stdAcademyLocationCombo"][i])) {
		    				
		    				location= {"id" : jsonFormatFormData["stdAcademyLocationCombo"][i]};
						}
		    			if(!isArray(jsonFormatFormData["studentHostelDetails2"])){
  		    				 hostel = {"id" : jsonFormatFormData.studentHostelDetails2.id}
  		    				 delete jsonFormatFormData.studentHostelDetails2;
  	                     }else{
  	                    	 hostel = {
		            					"id" : jsonFormatFormData.studentHostelDetails2[i].id
		            			} 
  	                     }
		    			mainObj = {
		            			"hostel" : hostel,
		            			"academyLocation" :location,
		            			"sequence":2
		            	}
		    			studentHostelDetailsJsonArry.push(mainObj);
		    		}
		    		if(!isNullOrEmpty(jsonFormatFormData.studentHostelDetails3)){
		    			var mainObj = '';
		    			var location = null;
		    			if (!isNullOrEmpty(jsonFormatFormData["stdAcademyLocationCombo"][i])) {
		    				
		    				location= {"id" : jsonFormatFormData["stdAcademyLocationCombo"][i]};
						}
		    			if(!isArray(jsonFormatFormData["studentHostelDetails3"])){
  		    				 hostel = {"id" : jsonFormatFormData.studentHostelDetails3.id}
  		    				 delete jsonFormatFormData.studentHostelDetails3;
  	                     }else{
  	                    	 hostel = {
		            					"id" : jsonFormatFormData.studentHostelDetails3[i].id
		            			} 
  	                     }
		    			mainObj = {
		            			"hostel" : hostel,
		            			"academyLocation" :location,
		            			"sequence":3
		            	}
		    			studentHostelDetailsJsonArry.push(mainObj);
		    		}
    		 }
		}else{

				 if(!isNullOrEmpty(jsonFormatFormData.studentHostelDetails1)){
		    			var mainObj = '';
		    			var location = null;
		    			if (!isNullOrEmpty(jsonFormatFormData["stdAcademyLocationCombo"])) {
		    				
		    				location= {"id" : jsonFormatFormData["stdAcademyLocationCombo"]};
						}
		    			mainObj = {
		            			"hostel" : {
		            					"id" : jsonFormatFormData.studentHostelDetails1.id
		            			},
		            			"academyLocation" :location,
		            			"sequence":1
		            	}
		    			studentHostelDetailsJsonArry.push(mainObj);
		    			
		        		
		        	}
		    		if(!isNullOrEmpty(jsonFormatFormData.studentHostelDetails2)){
		    			var mainObj = '';
		    			var location = null;
		    			if (!isNullOrEmpty(jsonFormatFormData["stdAcademyLocationCombo"])) {
		    				
		    				location= {"id" : jsonFormatFormData["stdAcademyLocationCombo"]};
						}
		    			mainObj = {
		            			"hostel" : {
		            					"id" : jsonFormatFormData.studentHostelDetails2.id
		            					
		            			},
		            			"academyLocation" :location,
		            			"sequence":2
		            	}
		    			studentHostelDetailsJsonArry.push(mainObj);
		    		}
		    		if(!isNullOrEmpty(jsonFormatFormData.studentHostelDetails3)){
		    			var mainObj = '';
		    			var location = null;
		    			if (!isNullOrEmpty(jsonFormatFormData["stdAcademyLocationCombo"])) {
		    				
		    				location= {"id" : jsonFormatFormData["stdAcademyLocationCombo"]};
						}
		    			mainObj = {
		            			"hostel" : {
		            					"id" : jsonFormatFormData.studentHostelDetails3.id
		            			},
		            			"academyLocation" :location,
		            			"sequence":3
		            	}
		    			studentHostelDetailsJsonArry.push(mainObj);
		    		}
		    		
			
    		}
    		if(!isNullOrEmpty(jsonFormatFormData.studentHostelDetails1)){
        		delete jsonFormatFormData.studentHostelDetails1;
        	}
    		if(!isNullOrEmpty(jsonFormatFormData.studentHostelDetails2)){
        		delete jsonFormatFormData.studentHostelDetails2;
        	}
    		if(!isNullOrEmpty(jsonFormatFormData.studentHostelDetails3)){
        		delete jsonFormatFormData.studentHostelDetails3;
        	}
    			delete jsonFormatFormData.stdAcademyLocationCombo;
            jsonFormatFormData.studentHostelDetails = studentHostelDetailsJsonArry;
    		
    		if( !isNullOrEmpty(jsonFormatFormData.whetherHostelApplicable) ){
    			if( !jsonFormatFormData.whetherHostelApplicable ){
    				//reset hostel fields to blank
    				this.resetHostelPersonalRequirementFieldsToBlank(form);
    				this.resetHostelPersonalRequirementCustomFieldsToBlank(form);
    				if( !isNullOrEmpty(form.down('#studentHostelDetailsId')) ){
    		    		form.down('#studentHostelDetailsId').reset();
    		    	}
    		    	if( !isNullOrEmpty(form.down('#tempAccommondationId')) ){
    		    		form.down('#tempAccommondationId').setValue({tempAccommondationType: false});
    		    	}
    			}
    		} else{
    			//reset hostel fields to blank
    			this.resetHostelPersonalRequirementFieldsToBlank(form);
    			this.resetHostelPersonalRequirementCustomFieldsToBlank(form);
    			if( !isNullOrEmpty(form.down('#studentHostelDetailsId')) ){
		    		form.down('#studentHostelDetailsId').reset();
		    	}
		    	if( !isNullOrEmpty(form.down('#tempAccommondationId')) ){
		    		form.down('#tempAccommondationId').setValue({tempAccommondationType: false});
		    	}
    		}
    		
    		var submitUrl = SERVERURL.PATH_SAVE_STUDENT_HOSTEL_PERSONAL_INFO;
    		if(!isNullOrEmpty(jsonFormatFormData.id)){
    			submitUrl = SERVERURL.PATH_UPDATE_STUDENT_HOSTEL_PERSONAL_INFO;
    		}
    		var myMask = new Ext.LoadMask(Ext.getBody(), {msg:"Please wait..."});
    		myMask.show();
    		
    		this$.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
    			myMask.hide();
                if (success, form) {
                    var data = Ext.decode(response.responseText);
                    if(response.responseText == 0) {
                    	form.down('#idItemId').setValue(null);
                    }
                    else if(response.responseText > 0) {
                    	form.down('#idItemId').setValue(response.responseText);
                    }
                    else {
                    }
                    showSuccessMessage('Hostel Personal Requirements', 'Hostel personal requirements updated successfully');
                }
            });
    		
    	}
    },
    resetHostelPersonalRequirementFieldsToBlank: function(form){
    	if( !isNullOrEmpty(form.down('#dietaryRequirementsItemId')) ){
    		form.down('#dietaryRequirementsItemId').reset();
    	}
    	if( !isNullOrEmpty(form.down('#foodAllergiesItemId')) ){
    		form.down('#foodAllergiesItemId').reset();
    	}
    	if( !isNullOrEmpty(form.down('#sleepingDisorderItemId')) ){
    		form.down('#sleepingDisorderItemId').reset();
    	}
    	if( !isNullOrEmpty(form.down('#anyMedicalNeedsOrSomethingItemId')) ){
    		form.down('#anyMedicalNeedsOrSomethingItemId').reset();
    	}
    },
    resetHostelPersonalRequirementCustomFieldsToBlank: function(form){
    	if( !isNullOrEmpty(form.customFieldNameData) && isArray(form.customFieldNameData) ){
		   if( form.customFieldNameData.length > 0 ){
			   for( index in form.customFieldNameData ){
				   var fieldName = form.customFieldNameData[index];
				   if( fieldName != 'customHiddenId' && fieldName != 'customHiddenVersion' ){
					   if( !isNullOrEmpty(form.getForm().findField(fieldName)) ){
						   form.getForm().findField(fieldName).reset();
					   }
				   }
			   }
		   }
	   }
    },
    saveJsonSiblingDetailForParent: function(formData,parentPersonId,form){
    	if(formData.applyUpdateToSiblings!=undefined)
    	  {
    		var pbpsFieldsCount = formData.applyUpdateToSiblings.length;
        	var pbpsArray=new Array();
        	var endJson=null;
        	var fieldSequence=1;
        	var store = form.down('#applyUpdateToSiblings').getStore();
        	if(pbpsFieldsCount!=0){
        		
        		if( pbpsFieldsCount == 1 && formData.applyUpdateToSiblings[0] == "" ){
        			
        		} else {
        		var siblingModel = form.down('#applyUpdateToSiblings').getValueModels();
        		var userSelectData=new Array();
        		for(var j=0; j<pbpsFieldsCount; j++){
        			if(formData.applyUpdateToSiblings[j].data!=undefined){
        				var studentId=formData.applyUpdateToSiblings[j].data.id;
        			}else
        			{
        				var studentId=formData.applyUpdateToSiblings[j];
        			}

        			userSelectData.push({
        				//"studentId": formData.applyUpdateToSiblings[j]
        				"studentId":studentId
        			});

        		}
        		var alreadySelectedData=new Array();
        		for(var i=0; i<siblingModel[0].data.ids.length; i++){
        			alreadySelectedData.push({

        				"id" :siblingModel[0].data.ids[i],
        				"studentId": siblingModel[0].data.studentId[i]
        			});
        		}
        		
        		
        		for(l=0; l<userSelectData.length;l++){

        			var index = -1; 

        			for(var i = 0, len = alreadySelectedData.length; i < len; i++) { 
        				if (alreadySelectedData[i].studentId === userSelectData[l].studentId) { 
        					index = i; break;
        				} 
        			}

        			//var index=alreadySelectedData.findIndex(x => x.studentId==userSelectData[l].studentId);

        			if( index ==-1)
        			{
        				pbpsArray.push({ 
        					"id" :null,
        					"student": {
        						"id": userSelectData[l].studentId
        					},
        					"parentPerson": {
        						"id": parentPersonId
        					}
        				});	
        			}else{
        				pbpsArray.push({ 
        					"id" :alreadySelectedData[index].id,
        					"student": {
        						"id": userSelectData[l].studentId
        					},
        					"parentPerson": {
        						"id": parentPersonId
        					}
        				});	
        			}

        		}
        	}
        		
        		
        	}
        		
        	return pbpsArray;
    	}
    },
    loadDFRForParentGuardianOnChange: function(schoolAttendedField){
    	var $this = this;
    	Ext.Ajax.request({
    		type: 'rest',
    		async: false,
    		url: SERVERURL.COMMON_FORM_FIELD_INFO,
    		params: {
    			screenName: 'parentguardianform',
    			academyLocationId: this.getCurrentAcademyLocation(),
    			languageCode:'en'
    		},
    		method: 'GET',
    		success: function(res, action) {
    			var response = Ext.decode(res.responseText);
    			if( Object.keys(response).length > 0 ){
    				var records=response.parentguardianform;
    				for(i in records){
      					  if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='schoolAttended' && records[i].isMandatory==true){
      						  schoolAttendedField.allowBlank = false;
      					  }
      					  if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='schoolAttended' && records[i].isVisible==true){
      						   schoolAttendedField.setVisible(true);
      						   break;
      					  }else{
      						   schoolAttendedField.setVisible(false);
      						   schoolAttendedField.allowBlank = true;
      					  }
    				}
    			}else{
    				schoolAttendedField.setVisible(true);
    			}
    		}
    		
    	});   	
    },
    loadDFRForSchoolInsuranceType: function(schoolInsuranceType) {
        var $this = this;
        var form = $this.getInsuranceform();
        var validFrom = form.down('#validFrom');
        var validTo = form.down('#validTo');
        var nameOfInsuranceCompany = form.down('#nameOfInsuranceCompany');
        var policyNumber = form.down('#policyNumber');
        var schoolInsuranceCardReceived = form.down('#schoolInsuranceCardReceived');
        var receivedDate = form.down('#receivedDate');

        Ext.Ajax.request({
            type: 'rest',
            async: false,
            url: SERVERURL.COMMON_FORM_FIELD_INFO,
            params: {
                screenName: 'insuranceform',
                academyLocationId: this.getCurrentAcademyLocation(),
                languageCode: 'en'
            },
            method: 'GET',
            success: function(res, action) {
                var response = Ext.decode(res.responseText);
                if (Object.keys(response).length > 0) {
                    var records = response.insuranceform;
                    for (i in records) {
                        var record = records[i];
                        
                        if (record.formFieldInputType == 'datefield' && record.formFieldId == 'validFrom') {
                            if (record.isMandatory) {
                                validFrom.allowBlank = false;
                            }else{
                            	validFrom.allowBlank = true;
                            }
                            if (record.isVisible) {
                                validFrom.setVisible(true);
                            }else{
                            	validFrom.setVisible(false);
                            }
                        }
                        if (record.formFieldInputType == 'datefield' && record.formFieldId == 'validTo') {
                            if (record.isMandatory) {
                                validTo.allowBlank = false;
                            }else{
                            	validTo.allowBlank = true;
                            }
                            if (record.isVisible) {
                                validTo.setVisible(true);
                            }else{
                            	validTo.setVisible(false);
                            }
                        }
                        if (record.formFieldInputType == 'textfield' && record.formFieldId == 'nameOfInsuranceCompany') {
                            if (record.isMandatory) {
                                nameOfInsuranceCompany.allowBlank = false;
                            }else{
                            	nameOfInsuranceCompany.allowBlank = true;
                            }
                            if (record.isVisible) {
                                nameOfInsuranceCompany.setVisible(true);
                            }else{
                            	nameOfInsuranceCompany.setVisible(false);
                            }
                        }
                        if (record.formFieldInputType == 'textfield' && record.formFieldId == 'policyNumber') {
                            if (record.isMandatory) {
                                policyNumber.allowBlank = false;
                            }else{
                            	policyNumber.allowBlank = true;
                            }
                            if (record.isVisible) {
                                policyNumber.setVisible(true);
                            }else{
                            	policyNumber.setVisible(false);
                            }
                        }
                        if (record.formFieldInputType == 'radiogroup' && record.formFieldId == 'schoolInsuranceCardReceived') {
                            if (record.isVisible) {
                                schoolInsuranceCardReceived.setVisible(true);
                            }else{
                            	schoolInsuranceCardReceived.setVisible(false);
                            	schoolInsuranceCardReceived.items.items[0].setValue(false);
                        		schoolInsuranceCardReceived.items.items[1].setValue(true);
                            	receivedDate.setVisible(false);
                            }
                        }
                        if (record.formFieldInputType == 'datefield' && record.formFieldId == 'receivedDate') {
                            if (record.isMandatory) {
                                receivedDate.allowBlank = false;
                            }else{
                            	receivedDate.allowBlank = true;
                            }
                            if (record.isVisible) {
                                receivedDate.setVisible(true);
                            }else{
                            	receivedDate.setVisible(false);
                            }
                        }
                    }
                } else {
                    validFrom.setVisible(true);
                    validTo.setVisible(true);
                    nameOfInsuranceCompany.setVisible(true);
                    policyNumber.setVisible(true);
                    schoolInsuranceCardReceived.setVisible(true);
                    receivedDate.setVisible(true);
                }
            }
        });
    },
    loadDFRForSchoolInsuranceCardReceived: function(schoolInsuranceCardReceived) {
        var $this = this;
        var form = $this.getInsuranceform();
        var receivedDate = form.down('#receivedDate');

        Ext.Ajax.request({
            type: 'rest',
            async: false,
            url: SERVERURL.COMMON_FORM_FIELD_INFO,
            params: {
                screenName: 'insuranceform',
                academyLocationId: this.getCurrentAcademyLocation(),
                languageCode: 'en'
            },
            method: 'GET',
            success: function(res, action) {
                var response = Ext.decode(res.responseText);
                if (Object.keys(response).length > 0) {
                    var records = response.insuranceform;
                    for (i in records) {
                        var record = records[i];
                        
                        if (record.formFieldInputType == 'datefield' && record.formFieldId == 'receivedDate') {
                        	if (record.isMandatory) {
                                 receivedDate.allowBlank = false;
                            }else{
                            	receivedDate.allowBlank = true;
                            }
                            if (record.isVisible) {
                                receivedDate.setVisible(true);
                            }else{
                            	receivedDate.setVisible(false);
                            }
                        }
                    }
                } else {
                    receivedDate.setVisible(true);
                }
            }
        });
    },

    generateJsonDataForGender: function(genderFormId){
    	 var genderId = null;
         if (!isNullOrEmpty(genderFormId) && !isNullOrEmpty(genderFormId)) {
             genderId = {
                 id: genderFormId
             };
         }
        return genderId;
    },
    
    saveFacultyFamilyDetails: function(formWindow,personType, gridItemId, addUrl, updateUrl) {
    	var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
        var personObj = this$.getPersonObj();
        var facultyFamilyDetailForm = this.getFacultyfamilydetailform();
        //var personCommonWindow = this$.getPersonCommonWindow();
        this$.saveFacultyFamily(personType, grid, formWindow, facultyFamilyDetailForm, personObj, addUrl, updateUrl);
    },
    saveFacultyFamily: function(personType, grid, personCommonWindow, form, personObj, saveUrl, updateUrl) {
    	var this$ = this;
	    var submitUrl, isUpdate = false;
	    if(form.getForm().isValid()){
	    	var values = form.getValues();
	    	
	    	if (this$.validatePhone(values)) {
	    		var id = form.down('#pg_hidden_field');
			    if (isNullOrEmpty(id.getSubmitValue())) {
			        submitUrl = saveUrl;
			        isUpdate = false;
			    } else {
			        submitUrl = updateUrl;
			        isUpdate = true;
			    }
			    var jsonFormatFormData = this$.getFacultyFamilyJsonData(personType, form, personObj, isUpdate);
			    if (!isNullOrEmpty(jsonFormatFormData)) {
			       Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
 					 
			    	this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
			    		Ext.getBody().unmask();
			        	if(success){
			        		if(!isNullOrEmpty(response.responseText)){
			        			var personId = response.responseText;
			        		}
			        		else{
			        			var personId = form.getRelatedPerson().id;
			        		}
			        		if(Ext.isDefined(form.down('#photoFileImageParent')) && !isNullOrEmpty(form.down('#photoFileImageParent').getValue())){
			        			this$.saveUpdatePersonImageForFacultyFamily(personId,grid,personCommonWindow);
			            	}
			        		else{
				                grid.getStore().load({
									callback: function(recorrds){
										if(recorrds.length >= 5){
											this$.getFacultyfamilydetailaddmorecardtpl() && this$.getFacultyfamilydetailaddmorecardtpl().hide();
										}else{
											this$.getFacultyfamilydetailaddmorecardtpl() &&  this$.getFacultyfamilydetailaddmorecardtpl().show();
										}
									}
								});
				                grid.getSelectionModel().deselectAll();
				        		personCommonWindow.close();
			        		}
			                if (isUpdate) {
			                    showSuccessMessage(getPersonModuleTranslation('FAMILY_DETAILS'), getPersonModuleTranslation('FAMILY_DETAILS_UPDATE_SUCCESS'));
			                } else {
			                    showSuccessMessage(getPersonModuleTranslation('FAMILY_DETAILS'), getPersonModuleTranslation('FAMILY_DETAILS_ADD_SUCCESS'));
			                }
			    		}else{
			    			personCommonWindow.close();
			                grid.getStore().reload();
			    		}
			        });
			    }
	    	}
	    	
	    }else{
	    	Ext.getBody().unmask();
        	showWarningMessage(getPersonModuleTranslation('FAMILY_DETAILS'), getPersonModuleTranslation('MANDATORY_FIELDS_NOT_FILLED'));
        }	    
    },
    getFacultyFamilyJsonData: function(personType, form, personObj, isUpdate) {
    	var this$ = this;
    	var jsonFormFieldData = new Object();
    	var formData = form.getValues();

    	if (!isEmpty(formData)) {        	
    		var person = new Object();
    		person.id = personObj["id"];
    		formData.person = person;

    		var relatedPerson = new Object();
    		/*if(Ext.app.checkVelocity || Ext.app.checkVelocity=="true"){
            	if(isNullOrEmpty(formData.mobileNumber)){
            		formData.mobileCountryCode="";
            	}
            	if(isNullOrEmpty(formData.phoneNo)){
            		formData.phoneCountryCode="";
            	}
            	if(isNullOrEmpty(formData.alternateMobileNo)){
            		formData.alternateMobileCountryCode="";
            	}
            	if(isNullOrEmpty(formData.externalEmployeeId)){
            		formData.externalEmployeeId="";
            	}
            }*/
    		if(!isNullOrEmpty(formData.customData)) {
    			formData.customData = formData.customData;
    		}
    		/*if(Ext.isDefined(form.down('#photoFileImageParent')) && isNullOrEmpty(form.down('#photoFileImageParent').getValue())){
            	relatedPerson.photoUrl = formData.photoUrl;
            }*/

    		//formData.employee = form.getRelatedPersonUserId();
    		var relatedPersonObj = form.getRelatedPerson();
    		if (!isNullOrEmpty(relatedPersonObj)) {
    			relatedPerson.id = relatedPersonObj["id"];
    			//relatedPerson.version = relatedPersonObj["version"];
    			//relatedPerson.isDeleted = relatedPersonObj["isDeleted"];
    			//relatedPerson.shortName = relatedPersonObj["shortName"];
    			if(formData.isEmployeeOfOrganization){
    				if( relatedPersonObj["employeeId"])
    					relatedPerson.employeeId = relatedPersonObj["employeeId"];
    				else
    					relatedPerson.employeeId = relatedPersonObj["id"];
    			}
    			/*if(personType == 'APPLICANT'){
            		if(!isUpdate){
            			relatedPerson.id = null;
                        relatedPerson.version = null;
                        relatedPerson.isDeleted = false;
                        relatedPerson.shortName = null;
            		}
                	relatedPerson.status = "ACTIVE";
                }*/
    		} else {
    			relatedPerson.id = null;
    			//relatedPerson.version = null;
    			// relatedPerson.isDeleted = false;
    			// relatedPerson.shortName = null;
    			/*if(personType == 'APPLICANT'){
                	relatedPerson.status = "ACTIVE";
                }*/
    		}
    		if(this$.getUserInfo()){
    			var employee = new Object();
    			employee.id = this$.getUserInfo();
    			formData.employee = employee;
    		}
    		if(isNullOrEmpty(formData.maritalStatus)){
    			formData.maritalStatus = null;
    		}else{
    			formData.maritalStatus = formData.maritalStatus;
    		}
    		
    		if(isNullOrEmpty(formData.externalEmployeeId)){
        		delete formData.externalEmployeeId;
        	}
    		else{
    			formData.familyDetailCode = formData.externalEmployeeId;
    			delete formData.externalEmployeeId;
    		}
    		
    		if(isNullOrEmpty(formData.bloodGroup)){
        		delete formData.bloodGroup;
        	}
    		if(!isNullOrEmpty(formData.userCode)){
        		//delete formData.userCode;
    			var person = new Object();
        		person.id = form.config.personId;
        		formData.person = person;
        		
        		formData.whetherUserOfOrganization = true;
        	}
    		else if(formData.isEmployeeOfOrganization){
    			//delete formData.userCode;
    			if(!isNullOrEmpty(form.config.personId)){
    			var person = new Object();
        		person.id = form.config.personId;
        		formData.person = person;
    		}
        		formData.whetherUserOfOrganization = true;
    		}
    		if(!isNullOrEmpty(formData.gender)){
    			var gender = new Object();
    			gender.id = formData.gender;
    			formData.genderCSMWS = gender;
    		}
    		delete formData.isEmployeeOfOrganization;
    		delete formData.gender;
    		//delete formData.relationship;
    	}
    	jsonFormFieldData = Ext.encode(formData);
    	return jsonFormFieldData;
    },
    onSelectEmployeeFamilyRelationshipComboValue : function(combo, gridItemId, facultyFamilyForm){
    	var this$ = this;
    	var personProfile = this$.getContentPanelActiveTab();
    	var grid = personProfile.down(gridItemId);
    	var store = grid.getStore();
    	store.clearFilter();
    	var relationship = combo.getValue();
    	var record = store.findRecord('relationship', relationship);
    	if(!isEmpty(record)){
    		if(relationship == "CHILD"){
    			var arr = [];
    			store.each(function(rec) {
    			    if(rec.data.relationship == "CHILD") {
    			        arr.push(rec);
    			    }
    			});
    			if(arr.length>4){
    				combo.reset();
    				showWarningMessage(getPersonModuleTranslation('FAMILY_DETAILS'), getPersonModuleTranslation('RELATIONSHIP_ALREADY_EXIST'));
    			}
    		}
    		else{
    			combo.reset();
    			showWarningMessage(getPersonModuleTranslation('FAMILY_DETAILS'), getPersonModuleTranslation('RELATIONSHIP_ALREADY_EXIST'));
    		}
    	}else{
//  		if(!Ext.app.checkVelocity){
//  		this$.onSelectionRelationShipSetGenderCombo(parentGuardianForm, relationship);
//  		}
    		
    		var maritalStatusCombo= facultyFamilyForm.down("#maritalStatus");
    		if(maritalStatusCombo){
    			if(relationship){
    				if(relationship == "FATHER" || relationship == "MOTHER"){
    					maritalStatusCombo.setValue("MARRIED");
    				}else{
    					maritalStatusCombo.reset();
    				}
    				//maritalStatusCombo.setReadOnly(false);
    			}
    		}

    		var genderCombo= facultyFamilyForm.down("#genderCombo");
	    	if(relationship){
	    		if(relationship == "FATHER"){
	    			genderCombo.getStore().load({
						callback: function(){
							genderCombo.setValue(1);   //MALE
						}
					});
	        		//genderCombo.setReadOnly(true);

	        	}else if(relationship == "MOTHER"){
	        		genderCombo.getStore().load({
						callback: function(){
							genderCombo.setValue(2);  //FEMALE
						}
					});
	        		//genderCombo.setReadOnly(true);

	        	}else{
	        		genderCombo.reset();
	        		//genderCombo.setReadOnly(false);
	        	}
	    	}
	    
    	}
    },
    saveUpdatePersonImageForFacultyFamily: function(personId,grid,personCommonWindow){
		var this$ = this;
		var userInfo = Academia.model.authentication.UserInfoModel;
		var access_token = userInfo.get("accessToken");
		var url = 'rest/personImage/uploadEmployeeFamilySnapshotB64Image?access_token='+access_token;
		var fileName = '1.png';
    	if(Ext.isDefined(localStorage.getItem('parentDataURL')) && !isNullOrEmpty(localStorage.getItem('parentDataURL'))){
    		//upload snapshot
    		var dataUrl = localStorage.getItem('parentDataURL');
			var form = new FormData();
			form.append('file', dataUrl);
			form.append('fileName', fileName);
			form.append('personId', personId);
			var xhr = new XMLHttpRequest();
			xhr.open('POST', url, true);
			xhr.onreadystatechange = function (resp) {
				if(resp.currentTarget.readyState==4){
					var responseText = Ext.decode(resp.currentTarget.responseText);
					/*if(responseText.success){
						console.log(responseText.path);
					}*/
					localStorage.setItem('parentDataURL','');
					grid.getStore().load();
					grid.getSelectionModel().deselectAll();
	        		personCommonWindow.close();
				}
			};
			xhr.send(form);
    	}
    	else {
    		//upload photo
    		var mainForm = this$.getFacultyfamilydetailform().down('#parentImageInnerForm');
        	var photoFileImage = mainForm.down('#photoFileImageParent');
        	var fileUploadPath = photoFileImage.getValue();
        	
        	if(!isNullOrEmpty(fileUploadPath)){
        		var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
        		if (extension == "gif" || extension == "png" || extension == "bmp"
                    || extension == "jpeg" || extension == "jpg") {
        			
        			mainForm.getForm().submit({
        	        	method : 'POST',
        	        	url : SERVERURL.PATH_EMPLOYEE_FAMILY_DETAIL_UPLOAD_IMAGE,
        	        	params:{
        	        		personId : personId
        	        	},
        	        	success : function(form, action){
        	        		//var photoUrl=action.result.path;
        	        		localStorage.setItem('parentDataURL','');
        	        		grid.getStore().load();
        	        		grid.getSelectionModel().deselectAll();
			        		personCommonWindow.close();
        	        	}
        	        });
        		}else{
        			photoFileImage.reset();
        			showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_VALID_FILE'));
        		}
        		
        	}
    	}
    },
    validateEmployeeOrgIdFamilyDetail: function(facultyFamilyDetailForm) {
        var this$ = this;
        var userIdField = facultyFamilyDetailForm.down('#employeeIdField');
        var userCode = userIdField.getValue();
        if (!isNullOrEmpty(userCode) && !(userIdField.readOnly == true)) {
        	var params = {
        			empUserCode: userCode
            };
            this$.sendGetAjaxRequest(SERVERURL.PATH_FIND_BY_EMP_USER_CODE_FOR_PERSON, 'GET', params, function(option, success, response) {
            	if(success){
            		var innerForm = facultyFamilyDetailForm.down('#parentGuardianInfoItemField');
            		if(!isNullOrEmpty(response.responseText)){
            			var data = Ext.decode(response.responseText);
            			if (!isEmpty(data)) {
            				var id = facultyFamilyDetailForm.down('#pg_hidden_field').getValue();
            				//var version = facultyFamilyDetailForm.down('#pg_version_field').getValue();
            				var userId = data.id;
            				var formDetails = new Object();
            				formDetails["id"] = id;
            				//formDetails["version"] = version;
            				//facultyFamilyDetailForm.getForm().setValues(data);
            				var genderCombo = facultyFamilyDetailForm.down('#genderCombo');
            				if(!isNullOrEmpty(data.isEmployeeOfOrganization)){
            					if(data.isEmployeeOfOrganization){
            						if(!isNullOrEmpty(data.genderCSM)){
            							genderCombo.getStore().load({
                							callback: function(){
                								genderCombo.setValue(data.genderCSM.id);
                							}
                						});
            							//genderCombo.setReadOnly(true);
            						}
            						//facultyFamilyDetailForm.down('#maritalStatus').setReadOnly(true);
            					}
            				}
            				else{
        						if(!isNullOrEmpty(data.genderCSM)){
        							genderCombo.getStore().load({
            							callback: function(){
            								genderCombo.setValue(data.genderCSM.id);
            							}
            						});
        							//genderCombo.setReadOnly(true);
        						}
            				}
            				this$.enabledDisabledInnerFamilyDetailForm(facultyFamilyDetailForm, true);
            				facultyFamilyDetailForm.down('#submitButtonId').setDisabled(false);

            				if(!isNullOrEmpty(data.birthDate)){
                        		data.birthDate = new Date(data.birthDate);
                        	}
            				
            				innerForm.getForm().setValues(data);
            				facultyFamilyDetailForm.config.personId = data.id;
            				
            				var mobileCountryCode = facultyFamilyDetailForm.down('#mobileCountryCode');
                        	mobileCountryCode.getStore().load({
                        		callback:function(){
                        			mobileCountryCode.setValue(data.mobileCountryCode);
                        		}
                        	});
                        	
                        	var phoneCountryCode = facultyFamilyDetailForm.down('#phoneCountryCode');
                        	phoneCountryCode.getStore().load({
                        		callback:function(){
                        			phoneCountryCode.setValue(data.phoneCountryCode);
                        		}
                        	});
                        	
                        	var alternateMobileCountryCode = facultyFamilyDetailForm.down('#alternateMobileCountryCode');
                        	alternateMobileCountryCode.getStore().load({
                        		callback:function(){
                        			alternateMobileCountryCode.setValue(data.alternateMobileCountryCode);
                        		}
                        	});

            				if(facultyFamilyDetailForm.itemId=='facultyFamilyDetailForm'){
            					var isMobileAvalaibleForCommunicationField = facultyFamilyDetailForm.down('#isMobUseForCommunicationField');
            					var isPhoneAvalaibleForCommunicationField = facultyFamilyDetailForm.down('#isPhoneUseForCommunicationField');
            					var isAlternateMobileAvalaibleForCommunicationField = facultyFamilyDetailForm.down('#isAlternateMobUseForCommunicationField');
            					var isEmergencyContactFieldField = facultyFamilyDetailForm.down('#isEmergencyContactField');

            					if( !isNullOrEmpty(isMobileAvalaibleForCommunicationField) ){
            						isMobileAvalaibleForCommunicationField.setValue(true);
            					}
            					if( !isNullOrEmpty(isPhoneAvalaibleForCommunicationField) ){
            						isPhoneAvalaibleForCommunicationField.setValue(true);
            					}
            					if( !isNullOrEmpty(isAlternateMobileAvalaibleForCommunicationField) ){
            						isAlternateMobileAvalaibleForCommunicationField.setValue(true);
            					}
            					if( !isNullOrEmpty(isEmergencyContactFieldField) ){
            						isEmergencyContactFieldField.setValue(true);
            					}
            					var countryCodeFieldItemIDArray = ["#mobileCountryCode","#phoneCountryCode","#alternateMobileCountryCode"];
            					this$.setDefaultCountryCode(facultyFamilyDetailForm, countryCodeFieldItemIDArray);
            				}
            			}
            		}
            		else {
            			showWarningMessage(getPersonModuleTranslation('FAMILY_DETAILS'), getPersonModuleTranslation('USER_ID_NOT_EXIST'));
            			userIdField.setValue('');
            			innerForm.getForm().reset();
            		}
            	}
            });
        }
    },
    enabledDisabledInnerFamilyDetailForm : function(facultyFamilyDetailForm, checkValue){

    	var innerForm = facultyFamilyDetailForm.down('#parentGuardianInfoItemField');
    	var employeeIdSearchField = facultyFamilyDetailForm.down('#employeeIdSearchField');
    	if (checkValue) {
    		employeeIdSearchField.setVisible(true);
    		employeeIdSearchField.setDisabled(false);
    		innerForm.setDisabled(false);
    	} else {
    		innerForm.setDisabled(true);
    	}
    	innerForm.getForm().reset();
    },
    
    /*** SSO common functions for Student, Faculty, Parent & Gardian***/
    
    addNewRowInSSOGrid: function(gridItemId, winPnl) {
    	var this$ = this;
    	var personProfile = this$.getContentPanelActiveTab();
    	var grid = personProfile.down(gridItemId);

    	if(isNullOrEmpty(grid)){
    		grid = winPnl.down(gridItemId);
    	}
    	//var grid = this.getStudentssodetailsgrid();
    	var objModel = [];
    	var model = new Academia.model.personinfo.common.personalinfo.SSODetailsModel();

    	model.set("id", '');
    	model.set("socialEmail", '');
    	model.set("socialLoginIntegration", '');
    	// model.set("isAddDeleteRow", true);

    	objModel.push(model);
    	grid.getStore().loadRawData(objModel, true);
    	grid.down('#btnAddSSO').setVisible(false);
    	var gridDom = grid.el ? grid.el.dom : null;
 		gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ grid.getStore().getCount();

    },
    loadSSOGridData: function(gridItemId,winPnl,permissionObj){
    	var $this = this;
    	var personProfile = this.getContentPanelActiveTab();
    	var grid = personProfile.down(gridItemId);
    	var userId = personProfile.getUserId();
    	var isSaveFromWin = false;
    	if(isNullOrEmpty(grid)){
    		grid = winPnl.down(gridItemId);
    		userId = winPnl.userId;
    		isSaveFromWin = true;
    	}
    	grid.getStore().removeAll();
    	var store = this.getStore('personinfo.common.personalinfo.SocialLoginIntegrationStore');
    	store.load();
    	var portalId = $this.getCurrentLoggedPortalId();
    	if(portalId == 7){
    		userId = localStorage.getItem('parentUserId');
    	}
    	var submitUrl = SERVERURL.FIND_ALL_SOCIAL_MAPPING_DETAIL;
    	if(isSaveFromWin){
			$this.applyWindowMask();
		}
		else{
			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		}
    	Ext.Ajax.request({
    		type: 'rest',
    		url: submitUrl + "?userId=" + userId,
    		method: 'GET',
    		success: function(response, action) {
    			Ext.getBody().unmask();
    			$this.hideWindowMask();
    			var data = Ext.decode(response.responseText);
    			var isDataExist = false;
    			if (!isNullOrEmpty(data) && data.length > 0) {
    				var taskGrid = grid;
    				var objModel = [];
    				var emmTaskModel = null;

    				var models = data;
    				for (var i = 0; i < models.length; i++) {
    					var model = new Academia.model.personinfo.common.personalinfo.SSODetailsModel();
    					model.set("id", models[i].id);
    					model.set("socialEmail", models[i].socialEmail);
    					if (!isNullOrEmpty(models[i].socialLoginIntegration)) {
    						model.set("socialLoginIntegrationId", models[i].socialLoginIntegration.id); 
    					}
    					// model.set("isAddDeleteRow", false);
    					model.commit();
    					objModel.push(model);
    				}
    				taskGrid.getStore().loadRawData(objModel, true);
    				grid.down('#btnAddSSO').setVisible(false);
    				isDataExist = true;
    			}
    			else{
    				grid.down('#btnAddSSO').setVisible(true);
					grid.down('#btnSaveItemId').setDisabled(true);
    			}
    			$this.addPermissionOnSSOGridButtonCommon(grid,permissionObj,isDataExist);
    		}
    	});
    },
    deleteRowInSSOGrid: function(gridItemId,record,rowIndex,winPnl,permissionObj){
    	var $this = this;
    	var personProfile = this.getContentPanelActiveTab();
    	var grid = personProfile.down(gridItemId);
    	var idVal = record.get("id");
    	if(isNullOrEmpty(grid)){
    		grid = winPnl.down(gridItemId);
    	}
    	if(!isNullOrEmpty(idVal)){
    		if (grid.getSelectionModel().getCount() > 0) {
    			showConfirmMessage(getPersonModuleTranslation('SSO_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
    				if (btn == 'yes') {
    					Ext.Ajax.request({
    						method: "DELETE",
    						type: 'rest',
    						url: SERVERURL.DELETE_SOCIAL_MAPPING+'?id='+idVal,
    						headers: {
    							'Content-Type': 'application/json'
    						},
    						success: function(form, action) {
    							showSuccessMessage(getPersonModuleTranslation('SSO_DETAILS'), getPersonModuleTranslation('SSO_DELETE_SUCESS_MESSAGE'));
    							/*if(grid.getStore().data.length==0){
    								grid.down('#btnAddSSO').setVisible(true);
    								grid.down('#btnSaveItemId').setDisabled(true);
    							}*/
    							$this.loadSSOGridData(gridItemId,winPnl,permissionObj);
    							var gridDom = grid.el ? grid.el.dom : null;
    							gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ grid.getStore().getCount();
    						}
    					});
    				}
    			});
    		} else {
    			showWarningMessage(getCommonTranslation('SOCIAL_MAPPING'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
    		}
    	}
    	else{
    		grid.getStore().removeAt(rowIndex);
    		var gridDom = grid.el ? grid.el.dom : null;
    		gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ grid.getStore().getCount();
    	}
    	if(grid.getStore().data.length==0){
    		grid.down('#btnAddSSO').setVisible(true);
    		grid.down('#btnSaveItemId').setDisabled(true);
    	}
    },
    saveSSOGridData: function(gridItemId,winPnl){
    	var $this = this;
    	var personProfile = this.getContentPanelActiveTab();
    	var grid = personProfile.down(gridItemId);
    	var userId = personProfile.getUserId();
    	var isSaveFromWin = false;
    	if(isNullOrEmpty(grid)){
    		grid = winPnl.down(gridItemId);
    		userId = winPnl.userId;
    		isSaveFromWin = true;
    	}
    	var models = grid.getStore().getRange();
    	var flag = true;
    	var portalId = $this.getCurrentLoggedPortalId();
    	if(portalId == 7){
    		userId = localStorage.getItem('parentUserId');
    	}
    	if (models.length > 0) {
    		var myJson = new Array();
    		for (var i = 0; i < models.length; i++) {

    			var model = new Academia.model.personinfo.common.personalinfo.SSODetailsModel();
    			if (!isNullOrEmpty(models[i].get('id'))) {
    				model.set("id", models[i].get('id'));
    			}
    			if (!isNullOrEmpty(models[i].get('id'))) {
    				model.set("id", models[i].get('id'));
    			}
    			if (!isNullOrEmpty(models[i].get('socialEmail'))) {
    				model.set("socialEmail", models[i].get('socialEmail'));
    			}
    			else{
    				flag = false;
    			}

    			var socialLoginIntegration = null;
    			if (!isNullOrEmpty(models[i].get('socialLoginIntegrationId'))) {
    				socialLoginIntegration = {
    						id: models[i].get('socialLoginIntegrationId')
    				};
    				model.set("socialLoginIntegration", socialLoginIntegration); 
    			}
    			else{
    				flag = false;
    			}

    			var user = {
    					id: userId
    			};
    			model.set("user", user); 
    			delete model.data.socialLoginIntegrationId;
    			myJson.push(model.data);
    		}
    		if(flag){
    			var formData = Ext.encode(myJson);
    			if(isSaveFromWin){
    				$this.applyWindowMask();
    			}
    			else{
    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    			}
    			Ext.Ajax.request({
    				type: 'rest',
    				url: SERVERURL.SOCIAL_MAPPING_SAVE_ALL,
    				jsonData: formData,
    				method: 'POST',
    				success: function(response, action) {
    					Ext.getBody().unmask();
    					$this.hideWindowMask();
    					var data = Ext.decode(response.responseText);
    					if (data.code == 'NOT_UNIQUE') {
    						showWarningMessage(getCommonTranslation('ALERT'), getPersonModuleTranslation('SSO_MAPPING_NOT_UNIQUE'));
    					} else {
    						showSuccessMessage(getPersonModuleTranslation('SSO_DETAILS'), getPersonModuleTranslation('SSO_MAPPING_SAVE_SUCCESSFULLY'));
    						$this.loadSSOGridData(gridItemId,winPnl);
    						grid.down('#btnSaveItemId').setDisabled(true);
    					}
    				}
    			});
    		}
    		else{
    			showWarningMessage(getCommonTranslation('ALERT'),getPersonModuleTranslation('SSO_PLEASE_ENTER_SOURCE_AND_SOCIAL_ID'));	
    		}
    	}
    },
    
    addPermissionOnSSOGridButtonCommon: function(gridReference,permissionsMap,isDataExist) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	
    	var saveBtn = gridReference.down('#btnSaveItemId');
    	saveBtn.setVisible(false);
    	
    	var btnAddSSO = gridReference.down('#btnAddSSO');
    	btnAddSSO.setVisible(false);
    	
    	var deleteButton = gridReference.down('[dataIndex=deleteButton]');
    	deleteButton.setVisible(false);
    	
    	var addButton = gridReference.down('[dataIndex=addButton]');
    	addButton.setVisible(false);
    	
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'SAVE') {
    			if(!isNullOrEmpty(saveBtn)){
    				saveBtn.setVisible(true);
    			}        		
    		}
    		if (privilege === 'CREATE') {
    			if(!isNullOrEmpty(btnAddSSO) && !isDataExist){
    				btnAddSSO.setVisible(true);
    			}    
    			if(!isNullOrEmpty(addButton)){
    				addButton.setVisible(true);
    			}
    		}
    		if (privilege === 'DELETE') {
    			if(!isNullOrEmpty(deleteButton)){
    				deleteButton.setVisible(true);
    			}        		
    		}
    	});
    },
    disableStudentDisplyAddressPrivilege : function(displayAddressPanel , permissionsMap){
    	if(!isNullOrEmpty(displayAddressPanel)){
        	var associatedAcadLocationIds = new Array();
        	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        	var googleAddress =  displayAddressPanel.down('#googleAddressPanel');
        	googleAddress.setVisible(false);
        	var googleAddressModify = displayAddressPanel.down('#modifyPersonalAddress5');
        	googleAddressModify.setVisible(false);
        	Ext.each(permissionList, function(privilege) {
        		if (privilege === 'GOOGLE_ADDRESS') {
        			if(!isNullOrEmpty(googleAddress)){
        				googleAddress.setVisible(true);
        			}        		
        		}
        	});
        }
    },
    disableApplicantDisplyAddressPrivilege : function(displayAddressPanel , permissionsMap){
    	if(!isNullOrEmpty(displayAddressPanel)){
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	var currentAddress  = displayAddressPanel.down('#currentAddressPanel');
    	currentAddress.setVisible(false);
    	var correspondanceAddress = displayAddressPanel.down('#addressForCorrespondance');
    	correspondanceAddress.setVisible(false);
    	var permanentAddress = displayAddressPanel.down('#permanentAddressPanel');
    	permanentAddress.setVisible(false);
    	var officeAddress =  displayAddressPanel.down('#officeAddressPanel');
    	officeAddress.setVisible(false);
    	var googleAddress =  displayAddressPanel.down('#googleAddressPanel');
    	googleAddress.setVisible(false);
    	
    	//var currentAddressPrint =displayAddressPanel.down('#printPersonalAddress1');
    	var currentAddressModify =displayAddressPanel.down('#modifyPersonalAddress1');
    	//var correspondanceAddressPrint = displayAddressPanel.down('#printPersonalAddress2');
    	var correspondanceAddressModify = displayAddressPanel.down('#modifyPersonalAddress2');
    	//var permanentAddressPrint = displayAddressPanel.down('#printPersonalAddress3');
    	var permanentAddressModify = displayAddressPanel.down('#modifyPersonalAddress3');
    	//var officeAddressPrint = displayAddressPanel.down('#printPersonalAddress4');
    	var officeAddressModify = displayAddressPanel.down('#modifyPersonalAddress4');
    	
    	var googleAddressModify = displayAddressPanel.down('#modifyPersonalAddress5');
    	
    	//currentAddressPrint.setVisible(false);
    	currentAddressModify.setVisible(false);
    	///correspondanceAddressPrint.setVisible(false);
    	correspondanceAddressModify.setVisible(false);
    	//permanentAddressPrint.setVisible(false);
    	permanentAddressModify.setVisible(false);
    	//officeAddressPrint.setVisible(false);
    	officeAddressModify.setVisible(false);
    	
    	googleAddressModify.setVisible(false);
    	
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'CURRENT_ADDRESS') {
    			if(!isNullOrEmpty(currentAddress)){
    				currentAddress.setVisible(true);
    			}        		
    		}
    		if (privilege === 'ADDRESS_FOR_CORRESPONDANCE') {
    			if(!isNullOrEmpty(correspondanceAddress)){
    				correspondanceAddress.setVisible(true);
    			}    
    			
    		}
    		if (privilege === 'PERMANENT_ADDRESS') {
    			if(!isNullOrEmpty(permanentAddress)){
    				permanentAddress.setVisible(true);
    			}        		
    		}
    		if (privilege === 'OFFICE_ADDRESS') {
    			if(!isNullOrEmpty(officeAddress)){
    				officeAddress.setVisible(true);
    			}        		
    		}
    		if (privilege === 'GOOGLE_ADDRESS') {
    			if(!isNullOrEmpty(googleAddress)){
    				googleAddress.setVisible(true);
    			}        		
    		}
    		
    		if (privilege === 'ADD_ADDRESS') {
    			if(!isNullOrEmpty(currentAddressModify) && !isNullOrEmpty(correspondanceAddressModify) && !isNullOrEmpty(permanentAddressModify) && !isNullOrEmpty(officeAddressModify) && !isNullOrEmpty(googleAddressModify)){
    				if(currentAddressModify.address.isModify == false) {
    					currentAddressModify.setVisible(true);
    				}
    				if(correspondanceAddressModify.address.isModify == false) {
    					correspondanceAddressModify.setVisible(true);
    				}
    				if(permanentAddressModify.address.isModify == false) {
    					permanentAddressModify.setVisible(true);
    				}
    				if(officeAddressModify.address.isModify == false) {
    					officeAddressModify.setVisible(true);
    				}
    				if(googleAddressModify.address.isModify == false) {
    					googleAddressModify.setVisible(true);
    				}
    			}        		
    		} else if (privilege === 'MODIFY') {
    			if(!isNullOrEmpty(currentAddressModify) && !isNullOrEmpty(correspondanceAddressModify) && !isNullOrEmpty(permanentAddressModify) && !isNullOrEmpty(officeAddressModify) && !isNullOrEmpty(googleAddressModify)){
    				if(currentAddressModify.address.isModify == true) {
    					currentAddressModify.setVisible(true);
    				}
    				if(correspondanceAddressModify.address.isModify == true) {
    					correspondanceAddressModify.setVisible(true);
    				}
    				if(permanentAddressModify.address.isModify == true) {
    					permanentAddressModify.setVisible(true);
    				}
    				if(officeAddressModify.address.isModify == true) {
    					officeAddressModify.setVisible(true);
    				}
    				if(googleAddressModify.address.isModify == true) {
    					googleAddressModify.setVisible(true);
    				}
    			}        		
    		}/* else if (privilege === 'PRINT') {
    			if(!isNullOrEmpty(currentAddressPrint) && currentAddressModify.address.isModify == true){
    				currentAddressPrint.setVisible(true);
    			}
    			if(!isNullOrEmpty(correspondanceAddressPrint) && correspondanceAddressModify.address.isModify == true){
    				correspondanceAddressPrint.setVisible(true);
    			}
    			if(!isNullOrEmpty(permanentAddressPrint) && permanentAddressModify.address.isModify == true){
    				permanentAddressPrint.setVisible(true);
    			}
    			if(!isNullOrEmpty(officeAddressPrint) && officeAddressModify.address.isModify == true){
    				officeAddressPrint.setVisible(true);
    			}
    			}
    		}*/ 
    	});
    	}
    },
    
    addMultipleLanguage:function(obj){
	   	   var $this = this;
	   	   var personProfile = this.getContentPanelActiveTab();
	   	   var personalInformationForm;
	   	   var serviceRouteDetailForm;
	   	   if(personProfile) {
	    		personalInformationForm = personProfile.down('personalinformationform');
	    		serviceRouteDetailForm = personProfile.down('personalinformationform');
	   	   } 
	   	   // var recordStopListWithTimes = serviceRouteDetailForm.down('#recordStopListWithTimesId').getValue();
	   	  var stopContiner = serviceRouteDetailForm.down('#serviceStopPanelId');
	   	   var indx = stopContiner.items.length;
	   	   var panelItem = new Array();
		   var insertPosition=indx;
		    panelItem.push({
		   		   xtype:'fieldcontainer',
		   		   width: '100%',
		   		   layout : 'hbox',
		   		   defaults : {
		   			   labelAlign : 'top'
		   		   },
		   		   items : [{
						xtype: 'hidden',
						itemId:'langItemId',
						name: 'langId'
				},{
						xtype : 'customcombobox',
						name : 'employeeLanguage',	
						itemId:'employeeLanguage',
						store:Ext.create('Academia.store.common.EmployeeLanguageStore'),
						valueField: 'id',
						displayField: 'value',
						editable: false,
			            disableKeyFilter: false,
						forceSelection:true,
						width: 256,
						rowIndx:indx,
						allowBlank:false,
						listeners:{
							select:function(obj,rec,value){
								

								var departmentId=rec[0].get('id');
								var employeeLanguage =  rec[0].data.employeeLanguage;
								var flag = true;
								var pnlMain = obj.up("#serviceStopPanelId");
								var rowIndx = obj.rowIndx;
								if(!isNullOrEmpty(pnlMain)){
									pnlMain.items.each(function(item, index, items) {
										var deptNameVal = item.down("[name=employeeLanguage]").getValue();
										if(departmentId == deptNameVal && rowIndx != index){
											flag = false;
											return false;
										}
									});

									if(flag){
										var nextSiblingField = obj.nextSibling();
										var write = obj.nextSibling().nextSibling();
										var speak = obj.nextSibling().nextSibling().nextSibling();
										nextSiblingField.reset();
										write.reset();
										speak.reset();
										if (departmentId > 0) {
											var writeStore=write.getStore();
											var speakStore=speak.getStore();
											
											var store=nextSiblingField.getStore();
											store.getProxy().extraParams = {
												limit:-1,
												employeeLanguage : employeeLanguage
											};
											store.load();
											writeStore.getProxy().extraParams = {
												limit:-1,
												employeeLanguage : employeeLanguage
											};
											writeStore.load();
											speakStore.getProxy().extraParams = {
												limit:-1,
												employeeLanguage : employeeLanguage
											};
											speakStore.load();
										}
									}
									else{
										obj.reset();
										var nextSiblingField = obj.nextSibling();
										var write = obj.nextSibling().nextSibling();
										var speak = obj.nextSibling().nextSibling().nextSibling();
										nextSiblingField.reset();
										write.reset();
										speak.reset();
										//nextSiblingField.setDisabled(true);
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('LANGUAGE_ALREADY_SELECTED_MSG'));
										return false;
									}
								}
								
							},
							change:function(obj,rec,value){
								var nextSiblingField = obj.nextSibling();
								nextSiblingField.reset();
								//nextSiblingField.setDisabled(true);

							}
						}
					},{
						xtype : 'customcombobox',
						name : 'read',	
						itemId:'readItemId1',
					    width: 256,
						store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
						allowBlank:false,
						editable: false,
						valueField: 'id',
						displayField: 'value',
						autoloadStore: false
					},{
						xtype : 'customcombobox',
						name : 'write',	
					    store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
						itemId : 'writeItemId1',
						allowBlank:false,
						valueField: 'id',
						displayField: 'value',
						editable:false,
						width: 256,
						autoloadStore: false,
					},{
						xtype : 'customcombobox',
						name : 'speak',
						itemId : 'speakItemId1',
						store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
						editable:false,
						valueField: 'id',
						displayField: 'value',
						allowBlank: false,
						width: 191,
						autoloadStore: false
			   	   },{
		   			   xtype: 'button',
		   			   glyph: ICONGLYPH.DELETEGLYPH,
		   			   cls: 'CustomBodyBtnReject',
		   			   tooltip: getCommonTranslation('DELETETOOLTIP'),
		   			   width:30,
		   			   style:{
						marginTop:'2px'
					   },
		   			   listeners:{
		   				   click:function(obj){
		   					   var container = obj.up('fieldcontainer');
		   					   var panelContiner,form;
		   					   var personProfile = $this.getContentPanelActiveTab();
		   					   if(personProfile){
		   						   panelContiner = personProfile.down('personalinformationform').down('#serviceStopPanelId');
		   					   } 
		   					   panelContiner.remove(container);
		   					   personProfile.down('personalinformationform').getForm().checkValidity();
		   					   personProfile.down('personalinformationform').getForm().isValid();
		   					   personProfile.down('personalinformationform').getForm().clearInvalid();
		   				   }
		   			   }
		   		   }]
		   	   });
		   
		    
	     	stopContiner.insert(insertPosition,panelItem);
	     	stopContiner.doLayout();
	      },
	      onSelectionLanguage: function(combo, record, form) {
	    	
	    	  var cityComboBox = combo.nextSibling();
	    	  var writeComboBox = combo.nextSibling().nextSibling();
	    	  var speakComboBox = combo.nextSibling().nextSibling().nextSibling();
	          cityComboBox.reset();
	          writeComboBox.reset();
	          speakComboBox.reset();
	          var employeeLanguage =  record[0].raw.employeeLanguage;
              var cityStore = cityComboBox.getStore();
	          cityStore.getProxy().extraParams = {
	          	  limit:-1,
	        	  employeeLanguage: employeeLanguage
	          };
	          cityStore.load();

	          var writeStore = writeComboBox.getStore();
	          writeStore.getProxy().extraParams = {
	          	  limit:-1,
	        	  employeeLanguage: employeeLanguage
	          };
	          writeStore.load();
	          
	          var speakStore = speakComboBox.getStore();
	          speakStore.getProxy().extraParams = {
	          	  limit:-1,
	        	  employeeLanguage: employeeLanguage
	          };
	          speakStore.load(); 
	        },
	        checkOtherLanguageFieldVisibility : function(form) {
	        	var $this = this;
				var firstNameOther = form.down('#firstNameOtherLanguageId');
				var middleNameOther = form.down('#middleNameOtherLanguageId');
				var lastNameOther = form.down('#lastNameOtherLanguageId');
				
				Ext.Ajax.request({
		    		type: 'rest',
		    		async: false,
		    		url: SERVERURL.COMMON_FORM_FIELD_INFO,
		    		params: {
		    			screenName: 'parentguardianform',
		    			academyLocationId: $this.getCurrentAcademyLocation(),
		    			languageCode:'en'
		    		},
		    		method: 'GET',
		    		success: function(res, action) {
		    			var response = Ext.decode(res.responseText);
		    			if( Object.keys(response).length > 0 ){
		    				var records=response.parentguardianform;
		    				for(i in records){  
		    					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='firstNameOtherLanguageId' && records[i].isVisible==true){
		    						firstNameOther.setVisible(true);
		    					}
		    					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='middleNameOtherLanguageId' && records[i].isVisible==true){
		    						middleNameOther.setVisible(true);
		    					}
		    					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='lastNameOtherLanguageId' && records[i].isVisible==true){
		    						lastNameOther.setVisible(true);
		    					}
		    					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='firstNameOtherLanguageId' && records[i].isMandatory==true){
		    						firstNameOther.allowBlank = false;
		    					}
		    					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='middleNameOtherLanguageId' && records[i].isMandatory==true){
		    						middleNameOther.allowBlank = false;
		    					}
		    					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='lastNameOtherLanguageId' && records[i].isMandatory==true){
		    						lastNameOther.allowBlank = false;
		    					}
		    				}
		    				
		    			}else{
		    				if (firstNameOther!=null) {
		    					firstNameOther.setVisible(true);
		    					firstNameOther.allowBlank = true;
							}
		    				if (middleNameOther!=null) {
		    					middleNameOther.setVisible(true);
		    					middleNameOther.allowBlank = true;
							}
		    				if (lastNameOther!=null) {
		    					lastNameOther.setVisible(true);
		    					lastNameOther.allowBlank = true;
							}
							//please do not uncomment this code
							if(portalId == 3){
							$this.hideNameOtherLanguage(firstNameOther,middleNameOther,lastNameOther);
							}
		    			}
		    		}
		    	});
			},
			checkDFRForIdNumberSecond : function(form) {
	        	var idNumberSecond = form.down("#idNumberSecond");
	        	idNumberSecond.setVisible(false);
	        	var $this = this;
	        	Ext.Ajax.request({
	        		type: 'rest',
	        		async: false,
	        		url: SERVERURL.COMMON_FORM_FIELD_INFO,
	        		params: {
	        			screenName: 'personalinformationform',
	        			academyLocationId: this.getCurrentAcademyLocation(),
	        			languageCode:'en'
	        		},
	        		method: 'GET',
	        		success: function(res, action) {
	        			var response = Ext.decode(res.responseText);
	        			if( Object.keys(response).length > 0 ){
	        				var records=response.personalinformationform;
	        				for(i in records){    					
	        					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='idNumberSecond' && records[i].isVisible==true){
	        						idNumberSecond.setVisible(true);
	        					}
	        					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='idNumberSecond' && records[i].isMandatory==true){
	        						idNumberSecond.allowBlank = false;
	        					}
	        				}
	        			}else{
	        				if(idNumberSecond!=null){
	        					idNumberSecond.setVisible(true);
	        				}
	        			}
	        		}
	        		
	        	});
			},
			checkDFRForidentityExpiryDate : function(form) {
	        	var identityExpiryDate = form.down("#identityExpiryDateItemId");
	        	identityExpiryDate.setVisible(false);
	        	var $this = this;
	        	Ext.Ajax.request({
	        		type: 'rest',
	        		async: false,
	        		url: SERVERURL.COMMON_FORM_FIELD_INFO,
	        		params: {
	        			screenName: 'personalinformationform',
	        			academyLocationId: this.getCurrentAcademyLocation(),
	        			languageCode:'en'
	        		},
	        		method: 'GET',
	        		success: function(res, action) {
	        			var response = Ext.decode(res.responseText);
	        			if( Object.keys(response).length > 0 ){
	        				var records=response.personalinformationform;
	        				for(i in records){    					
	        					if(records[i].formFieldInputType=='datefield' && records[i].formFieldId=='identityExpiryDateItemId' && records[i].isVisible==true){
	        						identityExpiryDate.setVisible(true);
	        					}
	        				}
	        			}else{
	        				if(identityExpiryDate!=null){
	        					identityExpiryDate.setVisible(true);
	        				}
	        			}
	        		}
	        		
	        	});
			},
			setStudentDetails: function(form , isFieldReadOnly, personType) {
				var $this = this;
				var isEdit = localStorage.getItem('isEditFeePayer');
				 if (isEdit != null && isEdit) {
					 isFieldReadOnly = false; 
				 }
				 var person = null;
				 if (portalId == 6) {
					 person = personData;
				 }else{
					 var personProfile = $this.getContentPanelActiveTab();
					 person = personProfile.applicationDataObject.person;
				 }
				var salutationItemId = form.down("#salutationItemId");
            	var firstNameItemId = form.down("#firstNameItemId");
            	var middleNameItemId = form.down("#middleNameItemId");
            	var lastNameItemId = form.down("#lastNameItemId");
            	var homeTelephoneCountryCodeItemId = form.down("#homeTelephoneCountryCodeItemId");
            	var homeTelephoneItemId = form.down("#homeTelephoneItemId");
            	var workTelephoneCountryCodeItemId = form.down("#workTelephoneCountryCodeItemId");
            	var workTelephoneItemId = form.down("#workTelephoneItemId");
            	var countryCodeItemId = form.down("#countryCodeItemId");
            	var mobileNumberItemId = form.down("#mobileNumberItemId");
            	var emailHomeItemId = form.down("#emailHomeItemId");
            	var emailWorkItemId = form.down("#emailWorkItemId");
            	var nationalAlternateIdItemId = form.down("#nationalAlternateIdItemId");
            	nationalAlternateIdItemId.reset();
            	if (personType == 'STUDENT') {
            		if (!isNullOrEmpty(person.salutation)) {
            			salutationItemId.setValue(person.salutation.id);
            		}
                	firstNameItemId.setValue(person.firstName);
                	middleNameItemId.setValue(person.middleName);
                	lastNameItemId.setValue(person.lastName);
                	countryCodeItemId.setValue(person.mobileCountryCode);
                	mobileNumberItemId.setValue(person.mobileNumber);
                	nationalAlternateIdItemId.setValue(person.nationalID);
                	emailHomeItemId.setValue(person.emailId);
                	homeTelephoneCountryCodeItemId.setValue(person.phoneCountryCode);
                	homeTelephoneItemId.setValue(person.phoneNo);
				}
            	salutationItemId.setReadOnly(isFieldReadOnly);
            	firstNameItemId.setReadOnly(isFieldReadOnly);
            	middleNameItemId.setReadOnly(isFieldReadOnly);
            	lastNameItemId.setReadOnly(isFieldReadOnly);
            	countryCodeItemId.setReadOnly(isFieldReadOnly);
            	mobileNumberItemId.setReadOnly(isFieldReadOnly);
            	nationalAlternateIdItemId.setReadOnly(isFieldReadOnly);
            	emailHomeItemId.setReadOnly(isFieldReadOnly);
            	homeTelephoneCountryCodeItemId.setReadOnly(isFieldReadOnly);
            	homeTelephoneItemId.setReadOnly(isFieldReadOnly);
			},
			setApplicantHostelDetails:function(form,jData) {
				   var $this = this;
				   var count = 1;
				   var locationStore =  form.down('#academyLocationCombo').getStore();
				   var panelContiner = form.down('#hostelPreferencePanel');
				   
				   if(jData.wsApplicantHostelJson.length>0){
					   jData.wsApplicantHostelJson.forEach(function(modeOfObj){
						   if (count == 1) {
							   $this.generateDynamicRowForHostel(modeOfObj , form);

						   }else{
							   setTimeout(function(){
								  /* var locationLength = locationStore.data.items.length;
								   var indx = panelContiner.items.items.length;
								   if (indx <  locationLength) {*/
									   $this.addHostelPreferenceContainer(form, modeOfObj);
								  // } 
								
							   },300);
						   }
						   count = count + 1;
					   });

				   }	
			 },
			   
			 generateDynamicRowForHostel : function(modeOfObj, form){  
				 var profile = this.getContentPanelActiveTab()
				   var academyLocationCombo = form.getForm().findField('academyLocationCombo');
				   var hostelField1 = form.getForm().findField('applicantHostelDetails1');
				   var hostelField2 = form.getForm().findField('applicantHostelDetails2');
				   var hostelField3 = form.getForm().findField('applicantHostelDetails3');
				  	   if (!isNullOrEmpty(modeOfObj.academyLocation)) {
				  		 academyLocationCombo.getStore().load(function(records){
				  			academyLocationCombo.getStore().clearFilter()
				  			academyLocationCombo.setValue(modeOfObj.location.id);
				  			 var rec =academyLocationCombo.findRecord('id',modeOfObj.location.id);
				  			 if(rec){
				  				academyLocationCombo.fireEvent('select',academyLocationCombo,[rec]);
				  			 }
				  			
				  			Ext.defer(function(){
				  				hostelField1.setValue(modeOfObj.firstPreference);
				  				hostelField2.setValue(modeOfObj.secondPreference);
				  				hostelField3.setValue(modeOfObj.thirdPreference);
		    				   },1000);
				  		 })
						   
					   }
						  /* hostelField1.getStore().load({
			  					  callback: function(records, operation, success) {
			  						  if (success) {
			  							  		hostelField1.setValue(modeOfObj.firstPreference);  	
			  						  }
			  					  }
			  				  });
						   
						   hostelField2.getStore().load({
			  					  callback: function(records, operation, success) {
			  						  if (success) {
			  							  hostelField2.setValue(modeOfObj.secondPreference);  
			  							 }
			  					  }
			  				  });
						   
						   hostelField3.getStore().load({
			  					  callback: function(records, operation, success) {
			  						  if (success) {
			  							  hostelField3.setValue(modeOfObj.thirdPreference);
			  						 }
			  					  }
			  				  });*/
			},
			afterHostelFormRender: function(form) {
				   var this$ = this;
				   form.down('#btnAddHostelPreference0').on('click', function() {
					   var panelContiner = form.down('#hostelPreferencePanel');
                       var locationStore =  form.down('#academyLocationCombo').getStore();
                       var locationLength = locationStore.data.items.length;
                       var indx = panelContiner.items.items.length;
                       if (indx <  locationLength) {
                       this$.addHostelPreferenceContainer(form);
                       }else{
                           showWarningMessage('Alert', getPersonModuleTranslation('NO_LOCATION_FOUND'));
                           return false;
                       }
				   }, form);

				   var locationStore =  form.down('#academyLocationCombo').getStore();
				   var addButton =  form.down('#btnAddHostelPreference0');
				   if ( !form.down('#academyLocationCombo').isVisible()) {
					   addButton.setVisible(false);
				   }
				   locationStore.load({
	  					  callback: function(records, operation, success) {
	  						  if (records.length< 2) {
	  							addButton.setVisible(false);
	  						  }else{
	  							   addButton.setVisible(true); 
	  						   }
	  					  }
	  				  })
			   },
			   addHostelPreferenceContainer: function(form, data) {
			       var this$ = this;
			       var panelContiner = form.down('#hostelPreferencePanel');
			       var indx;
					indx = panelContiner.items.items.length;
					
			       var panelItem = new Array();
			       panelItem.push({
			           xtype: 'fieldcontainer',
			           width: 'auto',
				         defaults: {
				             labelAlign: 'top',
				             width: 220
				         },
			           layout: {
			               type: 'hbox',
			               align: 'bottom'
			           },
			           style: {
			               Left: '0px'
			           },
			           items: [{
			               xtype: 'customcombobox',
			   				fieldLabel: getAdmissionTranslation('LOCATION'),
			               name: 'academyLocationCombo',
			               itemId:'academyLocationCombo'+indx,
			               store:Ext.create('Academia.store.organization.academylocations.LocationCustomSearchStore'),
			               displayField: 'value',
			               valueField: 'id',
			               forceSelection:true,
			               typeAhead : false,
			               height:'auto',
				     		 autoloadStore: false,
			           },{
				             xtype: 'nestedJsonCombo',
				             name: 'applicantHostelDetails1',
				             labelSeparator : '',
				             addAllSelector: false,
				             itemId: 'applicantHostelDetailsId1'+indx,
				             fieldLabel: getCommonTranslation('HOSTEL_CHOICE_FIRST_PREFERENCE'),
				     		 store: Ext.create('Academia.store.servicerequest.servicerequestsettings.AssigneeApproverHostelLocationWiseStore'),
				     		 displayField: 'hostelName',
			                 valueField: 'hostelId',
				     		 forceSelection:true,
				     		 typeAhead:false,
				     		 cls:'multiBrandCampusCls',
				     		 height:'auto',
				     		 autoloadStore: false,
				     		 listConfig :{         
								listeners :{ 
									beforeshow: function(picker) {
			      					picker.width = picker.up('combobox').getSize().width;
			      				},
			      				beforeselect : function(combo,record,index,opts) {
			      					if (combo.getCount() == 3) {
			      						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('HOSTEL_SELECTION_EXCEEDS_MSG'));
			                              return false;
			                        }
			                    },
			                },
							}
				         },{
				             xtype: 'nestedJsonCombo',
				             name: 'applicantHostelDetails2',
				             addAllSelector: false,
				             itemId: 'applicantHostelDetailsId2'+indx,
				             fieldLabel: getCommonTranslation('HOSTEL_CHOICE_SECOND_PREFERENCE'),
				     		 store: Ext.create('Academia.store.servicerequest.servicerequestsettings.AssigneeApproverHostelLocationWiseStore'),
				     		 displayField: 'hostelName',
			                 valueField: 'hostelId',
				     		 forceSelection:true,
				     		 typeAhead:false,
				     		 labelSeparator : '',
				     		 cls:'multiBrandCampusCls',
				     		 height:'auto',
				     		 autoloadStore: false,
				     		 listConfig :{         
								listeners :{ 
									beforeshow: function(picker) {
			      					picker.width = picker.up('combobox').getSize().width;
			      				},
			      				beforeselect : function(combo,record,index,opts) {
			      					if (combo.getCount() == 3) {
			      						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('HOSTEL_SELECTION_EXCEEDS_MSG'));
			                              return false;
			                        }
			                    },
			                },
							}
				         }, {
				             xtype: 'nestedJsonCombo',
				             name: 'applicantHostelDetails3',
				             addAllSelector: false,
				             itemId: 'applicantHostelDetailsId3'+indx,
				             fieldLabel: getCommonTranslation('HOSTEL_CHOICE_THIRD_PREFERENCE'),
				     		 store: Ext.create('Academia.store.servicerequest.servicerequestsettings.AssigneeApproverHostelLocationWiseStore'),
				     		 displayField: 'hostelName',
			                 valueField: 'hostelId',
				     		 forceSelection:true,
				     		 typeAhead:false,
				     		 cls:'multiBrandCampusCls',
				     		 height:'auto',
				     		 autoloadStore: false,
				     		 listConfig :{         
								listeners :{ 
									beforeshow: function(picker) {
			      					picker.width = picker.up('combobox').getSize().width;
			      				},
			      				beforeselect : function(combo,record,index,opts) {
			      					if (combo.getCount() == 3) {
			      						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('HOSTEL_SELECTION_EXCEEDS_MSG'));
			                              return false;
			                        }
			                    },
			                },
							}
				         },{
				        		xtype : 'button',
				        		itemId: 'btnDeleteHostelRow' + indx,
				        		glyph: ICONGLYPH.DELETEGLYPH,
					   			cls: 'CustomBodyBtnReject',
					   			tooltip: getCommonTranslation('DELETETOOLTIP')
				        	}]
			       });
			       var locationStore =  form.down('#academyLocationCombo').getStore();
                   var locationLength = locationStore.data.items.length;
                   var indx = panelContiner.items.items.length;
                   if (indx <  locationLength) {
			       panelContiner.add(panelItem);
			       form.down('#btnDeleteHostelRow' + indx).on('click', function(deleteButton) {
			           this$.deleteHostelContainer(deleteButton);
			       }, form);
			       if (!isNullOrEmpty(data)) {
			    	   var locationDropdown = form.down('#academyLocationCombo' + indx);
			    	   var hostelField1 = form.down('#applicantHostelDetailsId1' + indx);
			    	   var hostelField2 = form.down('#applicantHostelDetailsId2' + indx);
			    	   var hostelField3 = form.down('#applicantHostelDetailsId3' + indx);
			    	   if (!isNullOrEmpty(data.academyLocation)) {
			    		   var profile = this$.getContentPanelActiveTab();
			    		   locationDropdown.getStore().getProxy().extraParams = {
			    			   applicationID: profile.applicationId
			    		   };
			    		   locationDropdown.getStore().load({
			    			   callback: function(){
			    				   data.location &&  locationDropdown.setValue(data.location.id);
			    				   var rec =locationDropdown.findRecord('id',data.location.id);
			    				   locationDropdown.fireEvent('select',locationDropdown,[rec]);
			    				   Ext.defer(function(){
			    					   hostelField1.setValue(data.firstPreference);
			    					   hostelField2.setValue(data.secondPreference);
			    					   hostelField3.setValue(data.thirdPreference);
			    				   },1000);
			    				   /*hostelField1.getStore().load({
					  					  callback: function(records, operation, success) {
					  						  if (success) {
					  							  for(i in records){
					  								  if(records[i].data.hostelId == data.firstPreference){
					  									hostelField1.setValue(records[i].data.hostelId);  									  
					  								  }
					  							  }
					  						  }
					  					  }
					  				  });
								   
								   hostelField2.getStore().load({
					  					  callback: function(records, operation, success) {
					  						  if (success) {
					  							  for(i in records){
					  								  if(records[i].data.hostelId == data.secondPreference){
					  									hostelField2.setValue(records[i].data.hostelId);  									  
					  								  }
					  							  }
					  						  }
					  					  }
					  				  });
								   
								   hostelField3.getStore().load({
					  					  callback: function(records, operation, success) {
					  						  if (success) {
					  							  for(i in records){
					  								  if(records[i].data.hostelId == data.thirdPreference){
					  									hostelField3.setValue(records[i].data.hostelId);  									  
					  								  }
					  							  }
					  						  }
					  					  }
					  				  });*/
			    			   }
			    		   });
			    	   }
						   
			       }
                   }
			   },
			   
			   deleteHostelContainer: function(deleteButton) {
			       var this$ = this;
			       var form = this$.getPersonhostelrequirementform();
			       var hostelPanel = form.down('#hostelPreferencePanel');
			       var container = deleteButton.up('fieldcontainer');

			       if (container != null && hostelPanel != null) {
			           if (hostelPanel.items.length > 1) {
			        	   hostelPanel.remove(container);
			           }
			       }
			   },
			setApplicantHostelRequirementInfo : function(obj) {
				   var this$ = this;
				   var personProfile = this$.getContentPanelActiveTab();
				   var personId;
				   var applicationId;
				   try{
					   personId = personProfile.getPersonId();
					   applicationId = personProfile.applicationId;
				   }catch(e){
			   			personId = this$.getContentPanel().items.items[0].getPersonId();
			   			applicationId = this$.getContentPanel().items.items[0].applicationId;
				   }
				   var params = {
						   applicantPersonId: personId
			       };
			       	
				   var hostelFieldsContainer1 = obj.down('#hostelFieldsContainer1');
				   var hostelFieldsContainer2 = obj.down('#hostelFieldsContainer2');
				   var hostelFieldsContainer3 = obj.down('#hostelFieldsContainer3');
				   var hostelPreferencePanel = obj.down('#hostelPreferencePanel');
			    		
				   var tempAccommondationId = obj.down('#tempAccommondationId');
				   var applyForWaitingListTypeId = obj.down('#applyForWaitingListTypeId');


				   var submitUrl = SERVERURL.PATH_GET_APPLICANT_HOSTEL_PERSONAL_INFO_BY_APPLICANT_PERSON_ID;
			  			
				   var myMask = new Ext.LoadMask(Ext.getBody(), {msg:"Please wait..."});
				   myMask.show();
				   
				   this$.sendGetAjaxRequest(submitUrl, 'GET', params, function(option, success, response) {
					   setTimeout(function(){
						   myMask.hide();
					   },300);
					   if(success){
			       			if(!isNullOrEmpty(response.responseText)){
			       				var data = Ext.decode(response.responseText);
			       				var personInfo = personProfile.personInfo;
			       				var applicationDataObject = personProfile.applicationDataObject;
			               	
			               	
			       				var formObj = obj.up('form');
			       				if(!isNullOrEmpty(data)){
			       					if(portalId == 6){
			       						var form = personProfile.getForm();
			       					}else{
			       						var form = formObj.getForm();
			       					}
			               		
			       					var jData=Ext.JSON.decode(response.responseText);
			              			form.setValues(jData);
			              			if(!isNullOrEmpty(jData.tempAccommondationType)) {
			              				tempAccommondationId.setValue({tempAccommondationType: jData.tempAccommondationType});
			              			}
			              			this$.loadApplicantCustomFieldData(form,jData);
			              			if(!isNullOrEmpty(jData.applyForWaitingList)) {
			              				applyForWaitingListTypeId.setValue({applyForWaitingList: jData.applyForWaitingList});
			              			}
			              			if(!isNullOrEmpty(jData.waitingListType) && !isNullOrEmpty(jData.waitingListType.id)){
			              				this$.setWaitingListTypeToHostel(obj,jData);
			              			}
			              			
			              			if( !isNullOrEmpty(jData.whetherHostelApplicable) ){
				              		   		hostelFieldsContainer1.setVisible(jData.whetherHostelApplicable);
				              		   		hostelFieldsContainer2.setVisible(jData.whetherHostelApplicable);
				              		   		if(!isNullOrEmpty(jData.applicantHostelDetails)) {
				              		   			this$.setApplicantHostelDetails(obj,jData);
				              		   		}
			              			} else{
				              		   		hostelFieldsContainer1.setVisible(false);
				              		   		hostelFieldsContainer2.setVisible(false);
				              		   		hostelFieldsContainer3.setVisible(false);
			              			}
			              			
			       				}
			       			}
			       		}
			       	});
			   		obj.getForm().checkValidity();
                	setTimeout(function(){
                		this$.afterHostelFormRender(obj);
                		},300)
			   	},
			   	setWaitingListTypeToHostel : function(form, modeOfObj){
					   var waitingListTypeCombo = form.getForm().findField('waitingListType');
					   waitingListTypeCombo.getStore().load({
						   callback: function(records, operation, success) {
							   if (success) {
								   for(i in records){
									   if(records[i].data.id == modeOfObj.waitingListType.id){
										   waitingListTypeCombo.setValue(records[i].data.id);  									  
									   }
								   }
							   }
						   }
					   });
			   	},
			   	savePermitDetail: function(gridItemId, saveUrl, updateUrl, personType) {
			   		var this$ = this;
			   		var isValid = true;
			   		var submitUrl, isUpdate = false;
			   		var personProfile = this$.getContentPanelActiveTab();
			   		var grid = personProfile.down(gridItemId);
			   		var form = this$.getPermitdetailform();
			   		form.down('#submitButtonId').setDisabled(true);
			   		var id = form.down('#permit_detail_hidden_field');
			   		if (!isNullOrEmpty(id.getSubmitValue())) {
			   			submitUrl = updateUrl,
			   			isUpdate = true;
			   		} else {
			   			submitUrl = saveUrl,
			   			isUpdate = false;       
			   		}
			   		var jsonFormatFormData = this$.getJsonPermitData(form,grid,personType);
			   		this$.applyWindowMask(); 
			   		this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
			   			this$.hideWindowMask();
			   			if(success){
			   				this$.closePersonCommonWindow();
			   				if(this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7){
			                  	try{
			                  		personId = this$.getPersonObj().id;
			                  		if(isNullOrEmpty(personId)){
			                  			personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
			                  		}
			                  	}
			                  	catch(e){
			                  		personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
			                  	}
			                  	grid.getStore().getProxy().extraParams = {
			                  		personId : personId
			                  	};
			                  }else if(!isNullOrEmpty(personProfile.getPersonInfo())){
				        			grid.getStore().getProxy().extraParams = {
				        				personId : personProfile.getPersonInfo().id
				        			};
				        		}
			   				grid.getStore().reload();
			   				grid.getSelectionModel().deselectAll();
			   				if(isUpdate && !isNullOrEmpty(personType) && personType=='APPLICANT'){
			   					showSuccessMessage(getCommonTranslation('EDIT_PERMIT'), getCommonTranslation('APPLICANT_PERMIT_DETAIL_UPDATE_SUCCESSFULLY'));
			   				} else if(isUpdate) {
			   					showSuccessMessage(getCommonTranslation('EDIT_PERMIT'), getCommonTranslation('PERMIT_DETAIL_UPDATE_SUCCESSFULLY'));
			   				} else if(!isNullOrEmpty(personType) && personType=='APPLICANT'){
			   					showSuccessMessage(getCommonTranslation('ADD_PERMIT'), getCommonTranslation('APPLICANT_PERMIT_DETAIL_ADD_SUCCESSFULLY'));
			   				} else{
			   					showSuccessMessage(getCommonTranslation('ADD_PERMIT'), getCommonTranslation('PERMIT_DETAIL_ADD_SUCCESSFULLY'));
			   				}
			   			}else{
			   				this$.hideWindowMask();
			   				this$.closePersonCommonWindow();
			   				grid.getStore().reload();
			   				form.down('#submitButtonId').setDisabled(false);
			   			}
			   		});
			   	},
			   	getJsonPermitData: function(form,grid,personType) { 
			   		var this$ = this;
			   		var jsonFormFieldData = new Object();
			   		var personObj = this$.getPersonObj();
			   		var formData = form.getValues();
			   		var user=this.getCurrentlyLoggedInUser();
			   		if (!isEmpty(formData)) {
			   			var person = new Object();
			   			person.id = personObj["id"];
			   			formData.person = person;
			   			if(isNullOrEmpty(formData.cantonOfIssue)) {
			   				delete formData.cantonOfIssue
			   			}
			   			if(isNullOrEmpty(formData.countryOfIssue)) {
			   				delete formData.countryOfIssue
			   			}
			   			if(isNullOrEmpty(formData.methodOfSubmission)) {
			   				delete formData.methodOfSubmission
			   			}
			   			delete formData.pageSize;
			   			delete formData.customData;
			   			var docArray = [];
			   			var docStore;
			   			if(!isNullOrEmpty(personType) && personType=='APPLICANT'){
			   				docStore = this$.getStore('personinfo.common.personalinfo.ApplicantPermitDocumentGridStore');
			   			}else{
			   				docStore = this$.getStore('personinfo.common.personalinfo.PermitDocumentGridStore');
			   			}
			   			if (!isNullOrEmpty(docStore) && docStore.data.items != null
			   					&& docStore.data.items.length > 0) {
			   				Ext.each(docStore.data.items, function(val) {
			   					var newData = {
			   							"name" : val.data.documentName,
			   							"path" : val.data.path,
			   							"type" : val.data.type,
			   							"id" : val.data.id,
			   							"createdBy" : this$.getIdValueJson(
			   									val.data.createdBy.id,
			   									val.data.createdBy.value)
			   					};
			   					docArray.push(newData);
			   				});
			   			}
			   			var urlArray = [];
			   			var urlStore;
			   			if(!isNullOrEmpty(personType) && personType=="APPLICANT"){
			   				urlStore = this$.getStore('personinfo.common.personalinfo.ApplicantPermitUrlDocumentGridStore');
			   			}else{
			   				urlStore = this$.getStore('personinfo.common.personalinfo.PermitUrlDocumentGridStore');
			   			}
			   			if (!isNullOrEmpty(urlStore) && urlStore.data.items != null
			   					&& urlStore.data.items.length > 0) {
			   				Ext.each(urlStore.data.items, function(val) {
			   					var newData = {
			                            "name" : val.data.documentName==null?val.data.name:val.data.documentName,
			                            "path" : val.data.path,
			                            "id" : val.data.id,
			                    };
			   					urlArray.push(newData);
			   				});
			   			}
			   		}
			   		formData.permitDetailDocuments = docArray;
			   		formData.permitDetailUrlDocuments = urlArray;
			   		jsonFormFieldData = Ext.encode(formData);
			   		return jsonFormFieldData;
			   	},
			   	editPermitDetail: function(informationType, formItemId, gridItemId, isViewMode) {
			        var this$ = this;
			        var personProfile = this$.getContentPanelActiveTab();
			        var grid = personProfile.down(gridItemId);

			        if (grid.getSelectionModel().getCount() > 0) {
			        	this$.showPersonCommonWindow(undefined, informationType, formItemId, null);
			        	var formWindow = this$.getPersonCommonWindow();
			        	if(!isNullOrEmpty(isViewMode) && (isViewMode==true || isViewMode=='true')) {
			        		formWindow.setTitle(getCommonTranslation('VIEW_PERMIT'));
			        	}else{
			        		formWindow.setTitle(getCommonTranslation('EDIT_PERMIT'));
			        	}
			        	var form = this$.getPermitdetailform();
			            var records = grid.getSelectionModel().getSelection()[0];
			            if (!isEmpty(records)) {
				          	form.down('#permit_detail_hidden_field').setValue(records.data.id);
				          	var permitTypeField = form.down('#permitTypeItemId')
				          	if (!isNullOrEmpty(records.data.permitType)) {		            	
				          		permitTypeField.getStore().load({ 
				          			callback: function(recordss, operation, success) {
				          				if (success) {
				          					for(i in recordss){
				          						if(recordss[i].data.id == records.data.permitType.id)
				          							permitTypeField.setValue(recordss[i].data.id);  	
				          					}
				          				}
				          			}
				          		});
				          	}
				          	var countryOfIssueField = form.down('#countryOfIssueItemId')
				          	if (!isNullOrEmpty(records.data.countryOfIssue)) {		            	
				          		countryOfIssueField.getStore().load({ 
				          			callback: function(recordss, operation, success) {
				          				if (success) {
				          					for(i in recordss){
				          						if(recordss[i].data.id == records.data.countryOfIssue.id)
				          							countryOfIssueField.setValue(recordss[i].data.id);  	
				          					}
				          				}
				          			}
				          		});
				          	}
				          	var cantonOfIssueField = form.down('#cantonOfIssueItemId')
				          	if (!isNullOrEmpty(records.data.cantonOfIssue)) {		            	
				          		cantonOfIssueField.getStore().load({ 
				          			callback: function(recordss, operation, success) {
				          				if (success) {
				          					for(i in recordss){
				          						if(recordss[i].data.id == records.data.cantonOfIssue.id)
				          							cantonOfIssueField.setValue(recordss[i].data.id);  	
				          					}
				          				}
				          			}
				          		});
				          	}
				          	var methodOfSubmissionField = form.down('#methodOfSubmissionItemId')
				          	if (!isNullOrEmpty(records.data.methodOfSubmission)) {		            	
				          		methodOfSubmissionField.getStore().load({ 
				          			callback: function(recordss, operation, success) {
				          				if (success) {
				          					for(i in recordss){
				          						if(recordss[i].data.id == records.data.methodOfSubmission.id)
				          							methodOfSubmissionField.setValue(recordss[i].data.id);  	
				          					}
				          				}
				          			}
				          		});
				          	}
				          	if(!isNullOrEmpty(records.data.studentPermitStartDate)) {
				          		records.data.permitStartDate = records.data.studentPermitStartDate;
				          	}
				          	if(!isNullOrEmpty(records.data.studentPermitExpirationDate)){
				          		records.data.permitExpirationDate = records.data.studentPermitExpirationDate;
				          	}
				          	if(!isNullOrEmpty(records.data.studentPermitCancellationDate)){
				          		records.data.permitCancellationDate = records.data.studentPermitCancellationDate;
				          	}
				          	if(!isNullOrEmpty(records.data.studentDateOfDepartureAnnouncement)){
				          		records.data.dateOfDepartureAnnouncement = records.data.studentDateOfDepartureAnnouncement;
				          	}
				          	if(!isNullOrEmpty(records.data.studentDateSubmittedToAuthorities)){
				          		records.data.dateSubmittedToAuthorities =records.data.studentDateSubmittedToAuthorities;
				          	}
				          	if(!isNullOrEmpty(records.data.studentDateIssued)){
				          		records.data.dateIssued = records.data.studentDateIssued;
				          	}
				          	if(!isNullOrEmpty(records.data.studentDateCollected)){
				          		records.data.dateCollected = records.data.studentDateCollected;
				          	}
				          	form.loadRecord(records);
			            }
			        } else {
			        	showWarningMessage(getCommonTranslation('EDIT_PERMIT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			        }
			   	},
			   	viewPermitDetail: function(informationType, formItemId, gridItemId) {
			   		var this$ = this;
			   		var personProfile = this$.getContentPanelActiveTab();
			   		var grid = personProfile.down(gridItemId);
			  	  	if (grid.getSelectionModel().getCount() > 0) {
			  	  		this$.editPermitDetail(informationType, formItemId, gridItemId, true);
			  	  		var form = this$.getPermitdetailform();
			  	  		form.down('#uploadPermitDocItemId').setVisible(false);
			  	  		form.down('#uploadPermitUrlItemId').setVisible(false);
			  	  		var permitDocGrid = form.down('#permitdocumentgridItemId');
			  	  		var permitUrlDocGrid = form.down('#permiturldocumentgridItemId');
			  	  		permitDocGrid.down('#btnDelete').setDisabled(true);
			  	  		permitUrlDocGrid.down('#btnDelete').setDisabled(true);
				  	  	var applicantPermitDocGrid = form.down('#applicantpermitdocumentgridItemId');
			  	  		var applicantPermitUrlDocGrid = form.down('#applicantpermiturldocumentgridItemId');
			  	  		applicantPermitDocGrid.down('#btnDelete').setDisabled(true);
			  	  		applicantPermitUrlDocGrid.down('#btnDelete').setDisabled(true);
			  	  		this$.viewPersonCommonWindow(form);
			  	  	} else {
			  	  		showWarningMessage(getCommonTranslation('VIEW_PERMIT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			  	  	}
			   	},
			   	deletePermitDetail:function(gridItemId, deleteUrl, successMsg) {
			   		var this$ = this;
			   		var personProfile = this$.getContentPanelActiveTab();
			   		var grid = personProfile.down(gridItemId);
			   		if (grid.getSelectionModel().getCount() > 0) {
			   			showConfirmMessage(getCommonTranslation('DELETE_PERMIT'), getCommonTranslation('PERMIT_DETAIL_DELETE_CONFIRM_MSG'), function(btn, text) {
			   				if (btn == 'yes') {
			   					if (grid.getSelectionModel().getCount() > 0) {
			   						var records = grid.getSelectionModel().getSelection();
			   						var ids = [];
			                        for (var count = 0; count < records.length; count++) {
			                            if (!isNullOrEmpty(records[count].get("id"))) {
			                            	ids.push(records[count].get("id"));
			                            }
			                        }
			                        Ext.Ajax.request({
			                        	type: 'rest',
			                        	url: deleteUrl,
			                        	async:false,
			                        	method: 'DELETE',
			                        	headers: {
			                        		'Content-Type': 'application/json'
			                        	},
			                        	params: {
			                        		ids: ids.join()
			                        	},
			                        	success: function(form, action) {
			                        		grid.getSelectionModel().deselectAll();
			                        		grid.getStore().reload();
			                        		showSuccessMessage(getCommonTranslation('DELETE_PERMIT'), getCommonTranslation(successMsg));
			                        	}
			                        })
			   					}
			   				}
			   			});
			   		} else {
			   			showWarningMessage(getCommonTranslation('DELETE_PERMIT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			   		}
			   	},
			   	
			
				   hideNameOtherLanguage : function(firstNameOther,middleNameOther,lastNameOther){
					   firstNameOther.setVisible(false);
					   middleNameOther.setVisible(false);
					   lastNameOther.setVisible(false);
				   }, 
	   hideFieldsOfPersonalInformationForm: function(form) {
		form.down('#profilePhotoRemove').setVisible(false)
		form.down('#admissionIdIteamId').setVisible(false);
		this.setAllowBlank(form.down('#photoFileImage'),true); 
        form.down('#photoFileImage').setDisabled(true);
		form.down('#photoFileImage').setVisible(false);
		Ext.ComponentQuery.query('#photoFileImage')[1].setVisible(false);
		form.down('#studentPhotoUploadForm').setVisible(false);
		form.down('#isAgencyRequiredField').setVisible(false);
		form.down('#middleNameId').setVisible(false);
		form.down('#initialsId').setVisible(false);
		form.down('#printNameId').setVisible(false);
		this.setAllowBlank(form.down('#printNameId'),true); 
		form.down('#fieldOfInterestItemId').setVisible(false);
		form.down('#firstNameOtherLnguageId').setVisible(false);
		form.down('#middleNameOtherLnguageId').setVisible(false);
		form.down('#lastNameOtherLnguageId').setVisible(false);
		form.down('#shortNameOtherLnguageId').setVisible(false);
		form.down('#printNameOtherLnguageId').setVisible(false);
		form.down('#birthPlaceItemId').setVisible(false);
		form.down('#birthPlaceOtherLanguageItemId').setVisible(false);
		form.down('#countryCombo').setVisible(false);
		form.down('#stuSecondaryCitizenshipItemId').setVisible(false);
		form.down('#admissionDate').setVisible(false);
		form.down('#domicileCombo').setVisible(false);
		form.down('#examCenterCSM').setVisible(false);
		form.down('#examCenterVenue').setVisible(false);
		form.down('#currentActivity').setVisible(false);
		form.down('#currentEducationalInterventionsItemId').setVisible(false);
		form.down('#areaOfResearchItemId').setVisible(false);
		form.down('#studentStatusItemId').setVisible(false);
		form.down('#studentAttendanceGroup').setVisible(false);
		form.down('#advisorItemId').setVisible(false);
		form.down('#isLearnerSACitizenField').setVisible(false);
		form.down('#isMidtermJoineeField').setVisible(false);
		form.down('#isMilitarySponsoredItemId').setVisible(false);
		form.down('#pHDSponsorItemId').setVisible(false);
		form.down('#isBursaryRequirementsItemId').setVisible(false);
		form.down('#whetherRPLApplicant').setVisible(false);
		form.down('#documentFileUpload').setVisible(false);
		form.down('#phoneNoFldItemId').setVisible(false);
		form.down('#phoneCountryCode').setVisible(false);
		form.down('#phoneNoField').setVisible(false);
		form.down('#alternateNoFldItemId').setVisible(false);
		form.down('#externalSysRefTwo').setVisible(false);
		form.down('#externalSysRefThree').setVisible(false);
		form.down('#boardNumberId').setVisible(false);
		form.down('#bloodGroupId').setVisible(false);
		form.down('#maritalStatusId').setVisible(false);
		form.down('#religionCombo').setVisible(false);
		form.down('#castCategoryCombo').setVisible(false);
		form.down('#categoryId').setVisible(false);
		form.down('#postNumberId').setVisible(false);
		form.down('#personalIncomeId').setVisible(false);
		form.down('#accountingKeyId').setVisible(false);
		form.down('#hpcsaRegNoId').setVisible(false);
		form.down('#armsOfService').setVisible(false);
		form.down('#mustering').setVisible(false);
		form.down('#employeeLanguage').setVisible(false);
		form.down('#readItemId').setVisible(false);
		form.down('#writeItemId').setVisible(false);
		form.down('#speakItemId').setVisible(false);
		form.down('#stopBtn').setVisible(false);
		form.down('#applicantPersonRadioBtnUwcBefore').setVisible(false);
		form.down('#applicantPersonRadioBtnRegisteredBeforeSA').setVisible(false);
		form.down('#applicantPersonRadioBtnPopiaAct').setVisible(false);
		form.down('#beneficiaryName').setVisible(true);
		form.down('#beneficiaryNameOtherLanguageId').setVisible(true);
		form.down('#accountNumber').setVisible(true);
		form.down('#accountTypeId').setVisible(true);
		form.down('#bankName').setVisible(true);
		form.down('#branchName').setVisible(true);
		form.down('#ifsCode').setVisible(true);
		form.down('#bankDetailsStudentApplicationFieldSetId').setVisible(true);
		},
		
		validateParentDetails: function(grid){
			var me = this;
			
			var currentProfileTab = grid.up();
			
			if(!isNullOrEmpty(currentProfileTab)){
				var innerTabBackButton = currentProfileTab.down('#innerTabBackButton');
				var innerTabNextButton = currentProfileTab.down('#innerTabNextButton');
				var innerTabSubmitButton = currentProfileTab.down('#innerTabSubmitButton');
				var errorMsgShow2 = currentProfileTab.down("#errorMsgShow2");
                var errorMsgShow1 = currentProfileTab.down("#errorMsgShow1");


				if(!isNullOrEmpty(innerTabBackButton)){
					innerTabBackButton.setDisabled(Ext.app.profileUpdateButtonsDisable);
					innerTabBackButton.isVisible() && errorMsgShow1.setVisible(Ext.app.profileUpdateButtonsDisable)
				}
				if(!isNullOrEmpty(innerTabNextButton)){
					innerTabNextButton.setDisabled(Ext.app.profileUpdateButtonsDisable);
				}
				if(!isNullOrEmpty(innerTabSubmitButton)){
					innerTabSubmitButton.setDisabled(Ext.app.profileUpdateButtonsDisable);
				}
			
				var registrationSetupParentDetails = currentProfileTab.registrationSetupParentDetails;
				
				
				if(currentProfileTab.registrationSetupParentDetails && currentProfileTab.registrationSetupParentDetails.length){
					
					
					if(Ext.Array.pluck(registrationSetupParentDetails,'whetherMandatory').indexOf(true) == -1){ //Default functionality if all are false
						if(!isNullOrEmpty(innerTabNextButton)){
							innerTabNextButton.setDisabled(false);
						}
						if(!isNullOrEmpty(innerTabSubmitButton)){
							innerTabSubmitButton.setDisabled(false);
						}
					}
					else{
						var enableBtn = true;
						var filledRelationshipArray = Ext.Array.pluck(Ext.Array.pluck(grid.getStore().data.items,'data'),'relationship');
					
						for (var i = 0; i < filledRelationshipArray.length; i++) {
						    switch (filledRelationshipArray[i]) {
						        case "FATHER":
						        	filledRelationshipArray[i] = "PG1";
						            break;
						        case "MOTHER":
						        	filledRelationshipArray[i] = "PG2";
						            break;
						        case "LOCAL_GUARDIAN":
						        	filledRelationshipArray[i] = "LG";
						            break;
						        case "GUARDIAN":
						        	filledRelationshipArray[i] = "G";
						            break;
						    }
						}
						
						Ext.each(currentProfileTab.registrationSetupParentDetails, function(currentRegistrationSetupParent){
							if(currentRegistrationSetupParent.whetherMandatory == true){
								var fIndex = filledRelationshipArray.indexOf(currentRegistrationSetupParent.parentCode);
								if(fIndex == -1){
									enableBtn = false;
								}
							}
						});
						if(enableBtn == true){
							if(!isNullOrEmpty(innerTabNextButton)){
								innerTabNextButton.setDisabled(false);
							}
							if(!isNullOrEmpty(innerTabSubmitButton)){
								innerTabSubmitButton.setDisabled(false);
							}
						}
						else{
							if(!isNullOrEmpty(innerTabNextButton)){
								innerTabNextButton.setDisabled(true);
							}
							if(!isNullOrEmpty(innerTabSubmitButton)){
								innerTabSubmitButton.setDisabled(true);
							}
						}
					}
				}
				else{ //Default functionality if all are false
					if(!isNullOrEmpty(innerTabNextButton)){
						innerTabNextButton.setDisabled(false);
					}
					if(!isNullOrEmpty(innerTabSubmitButton)){
						innerTabSubmitButton.setDisabled(false);
					}
				}
			}
		}
});
