/**
 * @author Priyanshi Sharma
 *  
 */
Ext.define('Academia.controller.personinfo.student.StudentManageHoldController', {
    extend: 'Academia.controller.personinfo.common.PersonCommonController',
    
    models:['student.managehold.StudentMangeHoldRolesModel','student.managehold.StudentMangeHoldSubCatModel','student.managehold.StudentApplyHoldModel',
    	'student.managehold.ManageHoldMappingGridModel','student.managehold.StudentReportHoldGridModel','student.managehold.StudentReportHoldFilterModel','genericmodels.dropdowns.EnumCombo',
    	'common.AcademyLocationProgramModel','student.managehold.LockPersonalDetailsGridModel'],
    
    stores:['common.StatusComboStore','student.managehold.StudentManageHoldGridStore','student.managehold.StudentHoldCategoryNameStore',
    	'feeandpayment.finance.FinanceHoldTypeStore','student.managehold.ManageHoldStaffNameCode','student.managehold.ManageHoldRolesStore',
    	'student.managehold.StudentManageHoldSubCatGridStore','student.managehold.StudentApplyHoldGridStore',
    	'student.managehold.StudentManageHoldSubCatGridStore','feeandpayment.AcademyLocationFeeMappingList','common.AcademyLocationByName','feeandpayment.ALProgramList',
    	'facilitiesresources.managegallery.MapFolderALProgramStore','student.managehold.ManageHoldMappingGridStore','facilitiesresources.managegallery.MapFolderALProgramStore',
    	'enquiry.AcademicBatchStore','student.managehold.StudentReportHoldGridStore','common.SeatTypesByBatchId','student.managehold.TemplateForStore',
    	'student.managehold.ImportStudentHoldStore','student.managehold.ManageHoldApplyAtStore',
    	'messaging.MessagingTemplatesStore','committee.committee.MessageTypeNotificationStore','messaging.StaticDocumentAttachmentGridStore'
    	,'student.managehold.ManageHoldApplyAtStore','student.managehold.HoldStatusComboStore','student.managehold.StudentAllHoldCategoryNameStore','student.managehold.ManageHoldProgBatchMappingStore',
		'student.managehold.ManageHoldProgramBatchSearchCombo','student.managehold.ManageHoldPBSTStore','feeandpayment.AcademyLocationManageHoldMappingList','committee.committee.CommitteeALMappingComboStore',
		'student.managehold.LockPersonalDetailsGridStore'],
    
    views: ['personinfo.student.StudentManageHoldStructure','personinfo.student.StudentManageHoldFilter',
	   'personinfo.student.StudentManageHoldGrid','personinfo.student.HoldCategoryDetailWin','personinfo.student.HoldSubCategoryDetailWin',
	   'personinfo.student.StudentManageHoldSubCategoryGrid','personinfo.student.HoldSubCategoryDetailStructure',
	   'personinfo.student.StudentPortalHoldsStructure','personinfo.common.personalinfo.StudentHoldsGrid',
	   'personinfo.student.StudentManageHoldSubCategoryGrid','personinfo.student.HoldSubCategoryDetailStructure',
	   'personinfo.student.ManageHoldMappedProgramStructure','personinfo.student.ManageHoldsMappedProgramGrid','personinfo.student.ManageHoldMappedProgramGridStructure',
	   'personinfo.student.ManageHoldMappingTab','personinfo.student.ManageHoldsWithProgramBatchSeatStructure','personinfo.student.AcademyLocationGridWithManageHold',
	   'personinfo.student.ManageHoldProgramGrid','personinfo.student.ManageHoldProgramBatchGrid','personinfo.student.ManageHoldProgramBatchSeatTypeGrid',
	   'personinfo.student.ManageHoldProgressTracker','personinfo.student.StudentHoldReportStructure','personinfo.student.StudentHoldReportTabStructure',
	   'personinfo.student.StudentHoldReportFilter','personinfo.student.StudentHoldReportGrid','personinfo.student.StudentHoldReportRemoveHoldForm',
	   'personinfo.student.ImportManageHold','personinfo.student.DownloadStudentHolds','personinfo.student.ImportStudentHoldsForm','UploadOptionRadioGroup',
	   'personinfo.student.ImportListStudentHold','personinfo.student.StudentManageSubHoldWindow','personinfo.student.HoldSubCategoryWindowGrid',
	   'personinfo.student.StudentHoldReportSendMessages','messaging.HoldReportStaticDocumentAttachmentGrid','personinfo.student.StudentMappedProgramWindow',
	   'personinfo.student.ManageHoldsMappedProgramWindowGrid','personinfo.student.StudentPortalHoldsInnerTab','personinfo.student.StudentPortalFinanceHoldsInnerTab',
	   'personinfo.student.StudentPortalFinanceHoldsGrid','personinfo.student.LockPersonalDetailsTab','personinfo.student.LockPersonalDetailsGrid'],
   
    refs: [{
    	ref:'studentmanageholdstructure',
    	selector:'studentmanageholdstructure'
    },{
    	ref:'studentmanageholdfilter',
    	selector:'studentmanageholdfilter'
    },{
    	ref:'studentmanageholdgrid',
    	selector:'studentmanageholdgrid'
    },{
    	ref:'holdcategorydetailwin',
    	selector:'holdcategorydetailwin'
    },{
    	ref:'holdsubcategorydetailwin',
    	selector:'holdsubcategorydetailwin'
    },{
    	ref:'studentmanageholdsubcategorygrid',
    	selector:'studentmanageholdsubcategorygrid'
    },{
    	ref:'holdsubcategorydetailstructure',
    	selector:'holdsubcategorydetailstructure'
    },{
    	ref:'studentportalholdsstructure',
    	selector:'studentportalholdsstructure'
    },{
    	ref:'studentholdsgrid',
    	selector:'studentholdsgrid'
    },{
    	ref:'manageholdmappedprogramstructure',
    	selector:'manageholdmappedprogramstructure'
    },{
    	ref:'manageholdsmappedprogramgrid',
    	selector:'manageholdsmappedprogramgrid'
    },{
    	ref:'manageholdsmappedprogramwindowgrid',
    	selector:'manageholdsmappedprogramwindowgrid'
    },{
    	ref:'manageholdmappingtab',
    	selector:'manageholdmappingtab'
    },{
    	ref:'manageholdswithprogrambatchseatstructure',
    	selector:'manageholdswithprogrambatchseatstructure'
    },{
    	ref: 'contentPanel',
    	selector: 'contentPanel'
    },{
    	ref: 'academylocationgridwithmanagehold',
    	selector: 'academylocationgridwithmanagehold'
    },{
    	ref: 'manageholdprogresstracker',
    	selector: 'manageholdprogresstracker'
    },{
    	ref: 'manageholdprogramgrid',
    	selector: 'manageholdprogramgrid'
    },{
    	ref: 'manageholdprogrambatchgrid',
    	selector: 'manageholdprogrambatchgrid'
    },{
    	ref: 'manageholdprogrambatchseattypegrid',
    	selector: 'manageholdprogrambatchseattypegrid'
    },{
    	ref: 'studentholdreportstructure',
    	selector: 'studentholdreportstructure'
    },{
    	ref: 'studentholdreporttabstructure',
    	selector: 'studentholdreporttabstructure'
    },{
    	ref: 'studentholdreportfilter',
    	selector: 'studentholdreportfilter'
    },{
    	ref: 'studentholdreportgrid',
    	selector: 'studentholdreportgrid'
    },{
    	ref: 'studentholdreportremoveholdform',
    	selector: 'studentholdreportremoveholdform'
    },{
    	ref: 'downloadstudentholds',
    	selector: 'downloadstudentholds'
    },{
    	ref: 'uploadoptionradiogroup',
    	selector: 'uploadoptionradiogroup'
    },{
    	ref: 'importstudentholdsform',
    	selector: 'importstudentholdsform'
    },{
    	ref: 'importliststudenthold',
    	selector: 'importliststudenthold'
    },{
    	ref: 'studentmanagesubholdwindow',
    	selector: 'studentmanagesubholdwindow'
    },
    {
    	ref: 'studentmappedprogramwindow',
    	selector: 'studentmappedprogramwindow'
    },{
    	ref: 'holdsubcategorywindowgrid',
    	selector: 'holdsubcategorywindowgrid'
    },{
    	ref: 'studentholdreportsendmessages',
    	selector: 'studentholdreportsendmessages'
    },{
    	ref: 'holdreportstaticdocumentattachmentgrid',
    	selector: 'holdreportstaticdocumentattachmentgrid'
    },{
    	ref:'studentportalholdsinnertab',
    	selector:'studentportalholdsinnertab'
    },{
    	ref:'studentportalfinanceholdsinnertab',
    	selector:'studentportalfinanceholdsinnertab'
    },{
    	ref:'studentportalfinanceholdsgrid',
    	selector:'studentportalfinanceholdsgrid'
    },{
        ref: 'lockpersonaldetailstab',
        selector: 'lockpersonaldetailstab'
    },{
        ref: 'lockpersonaldetailsgrid',
        selector: 'lockpersonaldetailsgrid'
    }],
    config: {
    	STUDENT_MANAGE_HOLD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_MANAGE_HOLDS_PRIVILEGES'),
    	STUDENT_MANAGE_SUB_HOLD_CAT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_MANAGE_SUB_HOLD_CAT_PRIVILEGES'),
    	STUDENT_PORTAL_HOLDS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_HOLDS_PRIVILEGES'),
    	STUDENT_HOLD_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_HOLD_REPORT_PRIVILEGES'),
    	PARENT_PORTAL_STUDENT_HOLDS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_HOLDS_PRIVILEGES'),
    	
    },
    init: function(application) {
        this.control({
        	
        	'studentmanageholdgrid button[itemId=btnAdd]':{
        		click:this.showHoldCategoryDetailWin
        	},
        	'studentmanageholdgrid button[itemId=btnEdit]':{
        		click:this.editHoldCategoryDetail
        	},
        	'studentmanageholdgrid button[itemId=btnDelete]':{
        		click:this.deleteHoldCategoryDetail
        	},
        	'studentmanageholdgrid':{
        		render: function(grid){
        			this.doAccessControlValidation(grid, this.getSTUDENT_MANAGE_HOLD_PERMISSIONS());
        			this.disableMoreActionPivileges(grid, this.getSTUDENT_MANAGE_HOLD_PERMISSIONS());
        		},
        		selectionchange: function(column, selected,eOpts ){
                	this.disableEditViewDeleteButton(column,selected);                	
                },
                cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
					var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
					if(columnName == "subHoldCatCount"){
						 if(e.target.tagName=='A'){
							 this.showSubHoldOnPopUpWindow();
						 }
					 }
					if(columnName == "mappedProgramHoldCount"){
						 if(e.target.tagName=='A'){
							 this.showMappedProgramOnPopUpWindow();
						 }
					 }
                }
        	},
        	'studentmanageholdgrid menuitem[itemId=holdSubCategory]':{
        		click:this.showHoldSubCategoryDetailWin
        	},
        	'holdcategorydetailwin button[itemId=SubmitBtnHoldCategory]':{
        		click: this.saveHoldCategoryDetails
        	},
        	'studentmanageholdfilter button[itemId=studentHoldSearchButtonId]':{
        		click: this.loadHoldCatGridData
        	},
        	'studentmanageholdfilter button[itemId=studentHoldClearSearch]':{
        		click: this.resetManageHoldFilter
        	},
        	'holdcategorydetailwin button[itemId=CancelBtnHoldCategory]':{
        		click:function(obj){
        			var window = obj.up('window');
        			window.close();
        		}
        	},
        	'holdsubcategorydetailwin button[itemId=CancelBtnHoldSubCategory]':{
        		click:function(obj){
        			var window = obj.up('window');
        			window.close();
        		}
        	},
        	'holdsubcategorydetailwin  button[itemId=SubmitBtnHoldSubCategory]':{
        		click: this.saveHoldSubCategoryDetails
        	},
        	'holdsubcategorydetailwin  radiogroup[itemId=authorizationBasis]':{
        		change:function(radioField, newValue, oldValue, eOpts){
        		  var formWin = this.getHoldsubcategorydetailwin();
      	         this.onChangeAuthorizationRadioGroup(formWin, newValue);
        	  }
        	},
        	'studentmanageholdsubcategorygrid button[itemId=btnAdd]':{
        		click:this.addHoldSubCategoryDetailWin
        	},
        	'studentmanageholdsubcategorygrid button[itemId=btnEdit]':{
        		click:function(){
        			this.editHoldSubCategoryDetail(false)
        		}
        	},
        	'studentmanageholdsubcategorygrid button[itemId=btnView]':{
        		click:function(){
        			this.viewHoldSubCategoryDetail(true)
        		}
        	},
        	'studentmanageholdsubcategorygrid button[itemId=btnDelete]':{
        		click:this.deleteHoldSubCategoryDetail
        	},
        	'studentmanageholdsubcategorygrid':{
        		render:function(obj){
        			this.doAccessControlValidation(obj, this.getSTUDENT_MANAGE_SUB_HOLD_CAT_PERMISSIONS());
        			var holdCatGrid = this.getStudentmanageholdgrid();
        			var record = holdCatGrid.getSelectionModel().getSelection()[0];
        			var store = obj.getStore();
        			store.getProxy().extraParams = {
        				holdCategoryId:record.data.id
        				//status:record.data.isActive
        			}
        			this.resetPageSetting(store);
        			store.load();
        		},
        		selectionchange: function(column, selected,eOpts ){
        			var grid = this.getStudentmanageholdsubcategorygrid();
                	var btnEdit = grid.down('#btnEdit');
            		var btnDelete = grid.down('#btnDelete');
            		var btnView = grid.down('#btnView');
            		btnEdit.setDisabled(false);
            		btnDelete.setDisabled(false);
            		btnView.setDisabled(false);
            		var count=selected.length;
            		if(count>1){
            			btnEdit.setDisabled(true);
            			btnDelete.setDisabled(true);
            			btnView.setDisabled(true);
            		}
                }
        	},
        	'holdsubcategorywindowgrid':{
        		render:function(obj){
        			var holdCatGrid = this.getStudentmanageholdgrid();
        			var record = holdCatGrid.getSelectionModel().getSelection()[0];
        			var store = obj.getStore();
        			store.getProxy().extraParams = {
        				holdCategoryId:record.data.id
        			}
        			store.load();
        		}
        	},
        	  'holdsubcategorydetailwin customcombobox[itemId=applyHoldAt]':{
    			  render:function(combo){
    				  $this = this;
    				  var store = combo.getStore(); 
    				  store.on('load', function(){
    						  var filterItemIds = ['EXAM_ENROLLMENT'];
    						  var storeItems = store.getRange();
    						  for(var i = 0; i<storeItems.length; i++){     
    							  if(Ext.Array.contains(filterItemIds, storeItems[i].get('id')))
    								  store.remove(store.getById(storeItems[i].get('id')));            
    						  }  
    				  });

    			  }
    		  },
    		  'studentportalholdsinnertab customcombobox[itemId=applyHoldAt]':{
    			  render:function(combo){
    				  var applyAtStore = combo.getStore(); 
    				  applyAtStore.on('load', function(){
    					  var filterItemIds = ['EXAM_ENROLLMENT'];
    					  var storeItems = applyAtStore.getRange();
    					  for(var i = 0; i<storeItems.length; i++){     
    						  if(Ext.Array.contains(filterItemIds, storeItems[i].get('id')))
    							  applyAtStore.remove(applyAtStore.getById(storeItems[i].get('id')));            
    					  }  
    				  });
    			  }
    		  },
    		  'studentportalholdsstructure':{
    			  render:function(structure){
    				  this.hideTabsFromPermission(structure);
    			  }  
    		  },
        	'studentportalholdsinnertab':{
        		render: function(){
        			var this$ = this;
        			var grid=this.getStudentholdsgrid();
        			var grid=this.getStudentholdsgrid();
        			var baseController=this.getController('base.BaseController');
        			var structure= grid.up('personinfostudentportal');
        			baseController.getGridHeaderFreeze(grid,structure,false);
        			
        			var store=grid.getStore();
        			var applyHold=grid.down('#applyHold');
        			var removeHold=grid.down('#removeHold');
        			var deleteHoldBtn = grid.down('#deleteHold');
        			if(!isNullOrEmpty(applyHold)){
        				applyHold.setVisible(false);
        				}
        			if(!isNullOrEmpty(removeHold)){
        				removeHold.setVisible(false);
        			}
        			if(!isNullOrEmpty(deleteHoldBtn)){
        				deleteHoldBtn.setVisible(false);
        			}
        			var currentlyLoggedInUserId= this.getCurrentlyLoggedInUser().id;
        			
        			if(this.getCurrentLoggedPortalId() == 7){
            			var portalInfo = Academia.model.authentication.PortalInfoModel;
            			var student = portalInfo.get('student');
            			currentlyLoggedInUserId = student.id;
            		}
        			var portalId = this.getCurrentLoggedPortalId();
        			store.getProxy().extraParams = {
        				studentId:currentlyLoggedInUserId,
        				portalId: portalId,
        				applyHoldAt: ''
        		        },
        			this.resetPageSetting(store);
        			 store.load();
        		}
        		
        	},
        	'studentportalfinanceholdsinnertab' :{
        		afterrender:function(){
        			var this$ = this;
        			var grid=this.getStudentportalfinanceholdsgrid();
        			var baseController=this.getController('base.BaseController');
        			var structure= grid.up('personinfostudentportal');
        			baseController.getGridHeaderFreeze(grid,structure,false);
        			
        				
        		}
        	},
        	'studentportalfinanceholdsinnertab button[itemId=resetButtonId]':{
	       		click: function() {
	       			var form = this.getStudentportalfinanceholdsinnertab();
	       			var holdType = form.down('#holdType');
	       			holdType.reset();
	       			
	       		 }
	       	   },  
	       	   'studentportalfinanceholdsinnertab customcombobox[itemId=holdType]':{
	   			  render:function(combo){
	  				  $this = this;
	  				  var store = combo.getStore(); 
	  				  store.on('load', function(){
	  						  var filterItemIds = ['EXAM_ENROLLMENT'];
	  						  var storeItems = store.getRange();
	  						  for(var i = 0; i<storeItems.length; i++){     
	  							  if(Ext.Array.contains(filterItemIds, storeItems[i].get('id')))
	  								  store.remove(store.getById(storeItems[i].get('id')));            
	  						  }  
	  				  });

	  			  }
	  		  },
	       	  'studentportalfinanceholdsinnertab button#searchButtonId':{
	       		  click: function() {
	       			  var form = this.getStudentportalfinanceholdsinnertab();
	       			  var grid = this.getStudentportalfinanceholdsgrid();
        			 
	       			  var holdType = form.down('#holdType').getValue();
	       			  var personProfile = this.getContentPanelActiveTab();
	       			  var store = grid.getStore();
	       			 
	       				  store.getProxy().extraParams = {
	       					  financeHoldType: holdType,
	       					  studentId:personProfile.getUserId()
	       				  };
	       			  grid.config.searchFilterForm =form
	       			  grid.getSelectionModel().deselectAll();
	       			  this.resetPageSetting(store);
	       			  store.load();
	       		  }
	       	  },
        	 'studentportalholdsinnertab button[itemId=resetButtonId]':{
            		click: function() {
            			var structure = this.getStudentportalholdsstructure();
            			var applyHoldAt = structure.down('#applyHoldAt');
            			var holdSubCatStatus = structure.down('#holdStatus');
            			applyHoldAt.reset();
            			holdSubCatStatus.reset();
            		 }
            	   },
            	  'studentportalholdsinnertab button[itemId=searchButtonId]':{
            		  click: function() {
            			  var structure = this.getStudentportalholdsstructure();
            			  var grid = this.getStudentholdsgrid();
            			  var portalId = this.getCurrentLoggedPortalId();
            			  
            			  var applyHoldAt = structure.down('#applyHoldAt').getValue();
            			  var status = structure.down('#holdStatus').getValue();
            			  var personProfile = this.getContentPanelActiveTab();
            			  var store = grid.getStore();
            			  if(isNullOrEmpty(status)){
            				  store.getProxy().extraParams = {
            					  applyHoldAt: applyHoldAt,
            					  studentId:personProfile.getUserId(),
            					  portalId:portalId
            				  };
            			  }else{
            				  store.getProxy().extraParams = {
            					  applyHoldAt: applyHoldAt,
            					  isRemovedData:status,
            					  studentId:personProfile.getUserId(),
            					  portalId:portalId
            				  };
            			  }
            			  grid.config.searchFilterForm =structure;
            			  grid.getSelectionModel().deselectAll();
    	       			  this.resetPageSetting(store);
            			  store.load();
            		  }
            	  },
        	'studentmanageholdgrid menuitem[itemId=applyHold]':{
        		click : this.getApplyToTab
        	},
        	'manageholdsmappedprogramgrid button[itemId=btnAdd]':{
        		click:this.manageHoldDoMappingTab
        	},
        	'academylocationgridwithmanagehold button#ALnextButton':{
        		click:function(btn){
        			this.manageHoldALNextEvent(btn);
        		}
        	},
        	'manageholdprogramgrid button#nextButton':{
        		click:function(btn){
        			this.manageHoldProgramNextEvent(btn);
        		}
        	},
        	'manageholdprogrambatchgrid button#nextButton':{
        		click:function(btn){
        			this.manageHoldProgramBatchNextEvent(btn);
        		}
        	},
        	 'manageholdswithprogrambatchseatstructure button#submitHoldMapping':{
	 			  click:function(btn){
	 				  this.submitHoldMappingWithPBSType(btn);
	 			  }
	 		  },
	 		 'manageholdsmappedprogramgrid':{
	        		render: function(grid){
	        			var store = grid.getStore();
	        			var holdCatGrid = this.getStudentmanageholdgrid();
	               	    var record = holdCatGrid.getSelectionModel().getSelection()[0];
	        			store.getProxy().extraParams = {
	        				holdCategoryId:record.data.id
	        			}
	        			this.resetPageSetting(store);
	        			store.load();
	        		}
	        	},
	        	'manageholdsmappedprogramwindowgrid':{
	        		render: function(grid){
	        			var store = grid.getStore();
	        			var holdCatGrid = this.getStudentmanageholdgrid();
	               	    var record = holdCatGrid.getSelectionModel().getSelection()[0];
	        			store.getProxy().extraParams = {
	        				holdCategoryId:record.data.id
	        			}
	        			store.load();
	        		}
	        	},
	        	'manageholdswithprogrambatchseatstructure button#manageHoldResetBtn':{
		 			  click:function(btn){
		 				  var tabStructure = this.getManageholdswithprogrambatchseatstructure();
		 				  var activeGrid = tabStructure.getActiveTab().down('grid');
		 				  activeGrid.getSelectionModel().deselectAll();
		 				  activeGrid.getStore().clearFilter();
		 				  if(activeGrid.down('customcombobox')){
		 				    activeGrid.down('customcombobox').reset();
		 				  }
		 			  }
		 		  },
		 		  'manageholdsmappedprogramgrid button[itemId=btnDelete]':{
		 			 click:function(btn){
		 				  this.deleteManageHoldMapping();
		 			  }
		 		  },
		 		 'academylocationgridwithmanagehold customcombobox#manageHoldALsearchcombo':{
		 			  select:function(obj, record){
			 				var grid =  this.getAcademylocationgridwithmanagehold();
			 				grid.getStore().clearFilter();
			   				 if(!isNullOrEmpty(record)){
			   					 grid.getStore().filter({property: 'id',
			   						 value: record[0].get('id'),
			   						 exactMatch: true,
			   						 caseSensitive: true});
			   				 }
			 				grid.getStore().filter({property: 'id',
								  value: record[0].get('id'),
								  exactMatch: true,
								  caseSensitive: true});
			 				var gridDom = grid.el ? grid.el.dom : null;
			 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ 1;	
			 			  }
		 		  },
		 		  'manageholdprogrambatchgrid customcombobox#programbatchsearchcombo' :{
		 			  select:function(obj, record){
		 				  var grid =  this.getManageholdprogrambatchgrid();
		 				  grid.getStore().clearFilter();
		 				  grid.getStore().filter({property: 'batchId',
		 					  value: record[0].get('id'),
		 					  exactMatch: true,
		 					  caseSensitive: true});
		 			/*	 grid.getStore().filter({property: 'id',
							  value: record[0].get('id'),
							  exactMatch: true,
							  caseSensitive: true});*/
		 				var gridDom = grid.el ? grid.el.dom : null;
		 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ 1;	
		 			  }
		 		  },
		 		 'manageholdprogramgrid customcombobox#manageHoldProgramsearchcombo' : {
		    			select:function(obj, record){
		    				var grid = this.getManageholdprogramgrid();
		    				grid.getStore().clearFilter();
		    				grid.getStore().filter({property: 'programId',
		    					value: record[0].get('programId'),
		    					exactMatch: true,
		    					caseSensitive: true});
		    				var gridDom = grid.el ? grid.el.dom : null;
			 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ 1;	
		    			}
		    		},
		    		 'studentholdreportfilter':{
		             	afterrender:function(){
		             		var $this = this;
		             		var form=this.getStudentholdreportfilter().getForm();
		             		var academyLocationId = this.getCurrentAcademyLocation();
		             		 var academyLocation = form.findField('academyLocationId');
		             		academyLocation.getStore().load({
		             			 callback: function(records, operation, success) {
		     						 if (success) {
		     							academyLocation.select(academyLocation.getStore().collect(academyLocation.valueField));
		     							 $this.manageOtherFieldByAL();
		     						 }
		     					 }  
		             		 });
		             		var program = form.findField('programHoldReport');
		             		var arr = [];
		             		arr.push(academyLocationId);
		             		program.reset();
		             		program.getStore().getProxy().extraParams={
		            			academyLocationIds:arr.join()
		            		};
		            		program.getStore().load();
		             	}  
		             },
		    		 'studentholdreportfilter combo[itemId=academyLocationItemId]': {
		    			 change:this.manageOtherFieldByAL             
		             },
		             'studentholdreportfilter combo[itemId=programHoldReport]': {
		            	 select: function(obj, record) {
		    				 var filter=this.getStudentholdreportfilter();
		    				 var filterForm = filter.getForm();
		    				 var filterFormValue=filter.getForm().getValues();
		    				 var programName = filterForm.findField('programHoldReport');
			    			 var batchName = filterForm.findField('intakeHoldReport');
			    			 var periodName = filterForm.findField('periodHoldReport');
			    			 var seatTypeName = filterForm.findField('seatTypeHoldReport');
			    				
		    				batchName.reset();
		    				periodName.reset();
		    				seatTypeName.reset();
		    				batchName.enable();
		    				periodName.disable();
		    				seatTypeName.disable();
		    				
		    				batchName.getStore().getProxy().extraParams = {
		    					id:record[0].data.id
		    				}
							batchName.getStore().load({
								callback:function(batchRecord){
									if(batchRecord.length ==1){
										batchName.setValue(batchRecord[0].data.id);
										periodName.reset();
										periodName.enable();
										seatTypeName.reset();
										seatTypeName.enable();
										periodName.getStore().getProxy().extraParams = {
											id:batchRecord[0].data.id
		    		    				}
										periodName.getStore().load({
											callback:function(periodRecord){
												if(periodRecord.length ==1){
													periodName.setValue(periodRecord[0].data.id);
													seatTypeName.reset();
													seatTypeName.enable();
													seatTypeName.getStore().getProxy().extraParams = {
														batchId:filterFormValue.intakeHoldReport
		    		    		    				}
													seatTypeName.getStore().load({
		    											callback:function(seatTypeRecord){
		    												if(seatTypeRecord.length ==1){
		    													seatTypeName.setValue(seatTypeRecord[0].data.seatType.id);
		    												}
		    											}
		    										});
												}
											}
										});
									}
								}
							});
		    				 
		    			 }
		             },
		             'studentholdreportfilter customcombobox#intakeHoldReport' :{
		    			 select:function(obj,record){
		    				 var filter=this.getStudentholdreportfilter();
		    				 var filterForm = filter.getForm();
		    				 var filterFormValue=filter.getForm().getValues();
		     				
		    				var programName = filterForm.findField('programHoldReport');
		    				var batchName = filterForm.findField('intakeHoldReport');
		    				var periodName = filterForm.findField('periodHoldReport');
		    				var seatTypeName = filterForm.findField('seatTypeHoldReport');
		    				
		    				periodName.reset();
		    				seatTypeName.reset();
		    				seatTypeName.enable();
		    				periodName.enable();
		    				periodName.getStore().getProxy().extraParams = {
		    				id:record[0].data.id	
		    				}
							periodName.getStore().load({
								callback:function(periodRecord){
									if(periodRecord.length ==1){
										periodName.setValue(periodRecord[0].data.id);
										seatTypeName.reset();
										seatTypeName.enable();
										seatTypeName.getStore().getProxy().extraParams = {
											batchId:filterFormValue.intakeHoldReport
		    		    				}
										seatTypeName.getStore().load({
											callback:function(seatTypeRecord){
												if(seatTypeRecord.length ==1){
													seatTypeName.setValue(seatTypeRecord[0].data.seatType.id);
												}
											}
										});
									}
								}
							});
		    				 
		    			 }
		    		 },
		    		 'studentholdreportfilter customcombobox#periodHoldReport' :{
		    			 select:function(obj,record){
		    				 var filter=this.getStudentholdreportfilter();
		    				 var filterForm = filter.getForm();
		    				 var filterFormValue=filter.getForm().getValues();
		    	     			
		    				 var programName = filterForm.findField('programHoldReport');
			    			 var batchName = filterForm.findField('intakeHoldReport');
			    			 var periodName = filterForm.findField('periodHoldReport');
			    			 var seatTypeName = filterForm.findField('seatTypeHoldReport');
		    				
		    				seatTypeName.reset();
		    				seatTypeName.enable();
		    				seatTypeName.getStore().getProxy().extraParams = {
		    					batchId:filterFormValue.intakeHoldReport
		    				}
							seatTypeName.getStore().load({
								callback:function(seatTypeRecord){
									if(seatTypeRecord.length ==1){
										seatTypeName.setValue(seatTypeRecord[0].data.seatType.id);
									}
								}
							});
		    				
		    			 }
		    		 },
		            
		             'studentholdreportfilter button[itemId=searchBtnHoldReportItemID]':{
		            	 click: this.loadHoldReportGridData
		             },
		             'studentholdreportgrid':{
		            	 render: function(grid){
		         			this.doAccessControlValidation(grid, this.getSTUDENT_HOLD_REPORT_PERMISSIONS());
		         			this.doAccessControlValidationOfStudentRemoveHolds(grid, this.getSTUDENT_HOLD_REPORT_PERMISSIONS(),'HOLDS_REPORT');
		         		},
		         		afterrender:function(grid){
							var me = this;
							setTimeout(function(){
								me.addDataGridConfigButton(grid,me.getSTUDENT_HOLD_REPORT_PERMISSIONS());
							},1500);
						},
	               			selectionchange: function(column, selected,eOpts ){
	                        	this.disableRmoveButton(column,selected);                	
	                        }
		         		
		         	},
		             'studentholdreportgrid button[itemId=holdReportRemoveHold]':{
		            	 click: this.showRemovalHoldsWin
		             },
		             'studentholdreportgrid button[itemId=deleteHold]':{
		            	 click: this.deleteHoldFromHoldReport
		             },
		             'studentholdreportgrid button[itemId=sendMessageBtn]':{
		            	 click:function(){
								this.openStudentHoldReportSendMessage();
							}
		             },
		             'studentholdreportsendmessages': {
							render: function(grid){
								var this$ = this;
								var docGrid = grid.down('#holdStaticDocumentAttachmentGridMessage');
								docGrid.getStore().removeAll();
								docGrid.getStore().sync();
							}
						},
		             'studentholdreportsendmessages customcombobox[itemId=holdMsgTempletId]':{
							select : function(obj,rec){
								this.selectMessageTempForHoldReport(obj,rec);
							}
					}
					,'studentholdreportsendmessages  filefield[itemId=holdStaticUploadFileField]': {
							change: function(fileField, value, eOpts){
								var this$ = this;
								//value = value.replace('C:\\fakepath\\', '');
								var form=this$.getStudentholdreportsendmessages();
								var holdSubject = form.down('#holdSubject').getValue();
								if(isNullOrEmpty(holdSubject)){
									form.down('#holdSubject').setValue(' ');
								}
								this$.uploadHoldStaticDocumentFileMessage(fileField, value, eOpts);
							}
						}, 'holdreportstaticdocumentattachmentgrid[itemId=holdStaticDocumentAttachmentGridMessage] actioncolumn': {
			            	click : function(view, rowIndex, colIndex, item, e, record, row){
			            		this.deleteHoldReportStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
			            	}
			            },	
			            
			            'studentholdreportsendmessages radiogroup#holdSendingPriority': {
							change: function( radio, newValue, oldValue, eOpts) {
								this.loadHoldReportScheduleField(radio, newValue, oldValue);
							}
			            },
			            
			            'studentholdreportsendmessages textarea[itemId=holdSmsDiscription]':{
	            			change : function(val,nV,oV){
	            				var studentsendmessage = this.getStudentholdreportsendmessages();
	            				var smsTextField = studentsendmessage.down('#holdSmsDiscription');
	            				var smsTextFieldDiscription = studentsendmessage.down('#holdSmsDiscriptionNotice');
	            				var maxLength = localStorage.getItem('maxLength');
	            				var newValue = maxLength - smsTextField.getValue().length;
	            				smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
	            			}
	            		},
	            		
	            		'studentholdreportsendmessages textarea[itemId=holdPushNotificationDiscription]':{
	          	        	change : function(val,nV,oV){
	          	        		var studentSendMessages = this.getStudentholdreportsendmessages();
	          	        		var pushTextField = studentSendMessages.down('#holdPushNotificationDiscription');
	          	        		var pushTextFieldDiscription = studentSendMessages.down('#holdPushNotificationDiscriptionNotice');
	          	        		var maxLength = 1000;
	          	        		var newValue = maxLength - pushTextField.getValue().length;
	          	        		pushTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
	          	        	}
	          	        },
	          	        
	          	      'studentholdreportsendmessages radiogroup[itemId=holdMessageType]':{
	            			change : function(val,nV,oV){
	            				this.selectSectionMessageType(val,nV,oV);
	            			}
	            		},
			            
			            'studentholdreportsendmessages button[itemId=holdAdhocMsgSubmitBtn]':{
	            			click: function(obj) {
	            				var isForAll = false;
//	            				var SearchForm = this.getStudentQuickSearchForm();
//	            		        var jsonFormatFormData = this.createJsonFormat(SearchForm);
	            				var grid = this.getStudentholdreportgrid();
	            				var studentsendmessage = this.getStudentholdreportsendmessages();
	            				studentsendmessage.down('#holdAdhocMsgSubmitBtn').setDisabled(true);
	        	    	       	var sendMessageLable = studentsendmessage.down("#holdSendMsgCountItemId");
	        	    	       	if (sendMessageLable.isVisible()) {
	        	    	       		isForAll = true;
								}
	            				var formPnl = obj.up('form');
	            				var isMySelfChecked = false;
	            				var fldValues = formPnl.getForm().getFieldValues();
	            				isMySelfChecked = fldValues.holdRecieverType;
	            				if(fldValues.holdRecieverType[0] == false && fldValues.holdRecieverType[1]==false && fldValues.holdRecieverType[2]==false ){
	          	        	    	showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SEND_MESSAGE_ALERT_FOR_MYSELF'));
	          	        	    	return;
	          	        	    }
	            				var currentlyLoggedInUserId= this.getCurrentlyLoggedInUser().id;
	            				var wsMsgEventRecipientConfigsUpdated = [];
	            				/*var wsMsgEventRecipientConfigsUpdated = [{ 
											                           	 	msgRecipientTypeId: 500,
											                           	 	msgTemplateConfigId: 0,	//formData.id, 
											                           	 	selectiveRecipientIds: [] 
											                            },{ 
											                           	 	msgRecipientTypeId: 600,
											                           	 	msgTemplateConfigId: 0,	//formData.id, 
											                           	 	selectiveRecipientIds: [] 
											                            }];*/
	            				
	            				var formData = obj.up('form').getValues();
	            				
	            				var sendMessageToOptions = formData.holdRecieverType;
	            				var isStudentChecked = false;
	            				var isParentChecked = false;
	            				var isFeePayerChecked = false;
	            				
	            				if(sendMessageToOptions != null && sendMessageToOptions != undefined ){
	            					if(sendMessageToOptions.constructor === Array){
	            						if(sendMessageToOptions.length > 0){
	            							sendMessageToOptions.forEach(function(current_value, index, initial_array) {
	                    						if(current_value == 1 || current_value == '1'){
	                    							isStudentChecked = true;
	                    						}
	        									if(current_value == 2 || current_value == '2'){
	        										isParentChecked = true;
	        									}
	        									if(current_value == 3 || current_value == '3'){
	        										isFeePayerChecked = true;
	        									}
	                    					});
	            						}
	            					}else{
	            						if(sendMessageToOptions == 1 || sendMessageToOptions == '1'){
	            							isStudentChecked = true;
	            						}
										if(sendMessageToOptions == 2 || sendMessageToOptions == '2'){
											isParentChecked = true;
										}
										if(sendMessageToOptions == 3 || sendMessageToOptions == '3'){
											isFeePayerChecked = true;
										}
	            					}
	            				}
	            				
	            				//var abc = xyz.c;
	            				
	            				if( !isParentChecked && !isFeePayerChecked ){ // No checkbox is checked
	            					//wsMsgEventRecipientConfigsUpdated = [];
	            					studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isStudentChecked,isMySelfChecked,currentlyLoggedInUserId, isForAll);
	            				}else{
	            					var recipientIds;
	            					if(grid.itemId == 'studentholdreportgrid'){
	            						recipientIds = this.getStudentReceipientIdsForSendingMessages(grid);
	            						recipientIds = Ext.encode(recipientIds);
	            						//typeId = 2;
	            						//recipientId = 2;
	            					}
	            					
	            					var RecipientTypeCodes = ["Fee Payer Adhoc","Parent Adhoc"];
	            					
	            					if(isParentChecked && isFeePayerChecked){ // Both checkboxes are cheked 
	            						// Ajax Call to get Parent Ids by Admission Ids
	            						
	            						Ext.Ajax.request({
		            						type: 'rest',
		            						url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
		            						jsonData: RecipientTypeCodes,
		            						method: 'POST',
		            						success: function(response) {
		            							var RecipientTypeCodesData = Ext.decode(response.responseText);
		            							
		            							Ext.Ajax.request({
		    	            						type: 'rest',
		    	            						url:SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS,
		    	            						jsonData: recipientIds,
		    	            						method: 'POST',
		    	            						success: function(response) {
		    	            							// update wsMsgEventRecipientConfigsUpdated with parent ids
		    	            							var wsMsgEventRecipientConfigsParents = {
		    									            									msgRecipientTypeId: 66,
		    													                           	 	msgTemplateConfigId: 0,	//formData.id, 
		    													                           	 	selectiveRecipientIds: []
		    										            							};
		    	            							if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
		    	            								wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
		    	            							}
		    	            							wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
		    	            							wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);
		    	            							
		    	            							// Ajax Call to get Fee Payer Ids by Admission Ids
		    	            							Ext.Ajax.request({
		    	    	            						type: 'rest',
		    	    	            						url: SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS,
		    	    	            						jsonData: recipientIds,
		    	    	            						method: 'POST',
		    	    	            						success: function(response) {
		    	    	            							// update wsMsgEventRecipientConfigsUpdated with fee payer ids
		    	    	            							var wsMsgEventRecipientConfigsFeePayer = {
		    			            									msgRecipientTypeId: 67,
		    							                           	 	msgTemplateConfigId: 0,	//formData.id, 
		    							                           	 	selectiveRecipientIds: []
		    				            							};
		    	    	            							
		    	    	            							if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
		    	    	            								wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
		    	    	            							}
		    	    	            							
		    	    	            							wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
		    													wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);
		    	    	            							studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isStudentChecked,isMySelfChecked,currentlyLoggedInUserId, isForAll);
		    	    	            						}
		    	    	            					});
		    	            						}
		    	            					});
		            						}
	            						});
	            					}else{ // Only one checkbox is selected
	            						var urlNew = '';
	            						if(isParentChecked) { // If Parent checkbox is selected
	            							// url for getting parent ids
	            							urlNew = SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS;
	            						}
	            						if(isFeePayerChecked) { // If Fee Payer checkbox is selected
	            							// url for getting fee payer ids
	            							urlNew = SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS;
	            						}
	            						
	            						Ext.Ajax.request({
		            						type: 'rest',
		            						url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
		            						jsonData: RecipientTypeCodes,
		            						method: 'POST',
		            						success: function(response) {
		            							var RecipientTypeCodesData = Ext.decode(response.responseText);
		            							
		            							Ext.Ajax.request({
		    	            						type: 'rest',
		    	            						url: urlNew,
		    	            						jsonData: recipientIds,
		    	            						method: 'POST',
		    	            						success: function(response) {
		    	            							if(isParentChecked) { // If Parent checkbox is selected
		    	            								// update wsMsgEventRecipientConfigsUpdated with parent ids
		    	            								var wsMsgEventRecipientConfigsParents = {
		    		            									msgRecipientTypeId: 66,
		    						                           	 	msgTemplateConfigId: 0,	//formData.id, 
		    						                           	 	selectiveRecipientIds: []
		    			            							};
		    	            								if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
			    	            								wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
			    	            							}
		    												wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
		    												wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);
		    	                						}
		    	            							if(isFeePayerChecked) { // If Fee Payer checkbox is selected
		    	                							// update wsMsgEventRecipientConfigsUpdated with fee payer ids
		    	            								var wsMsgEventRecipientConfigsFeePayer = {
		    		            									msgRecipientTypeId: 67,
		    						                           	 	msgTemplateConfigId: 0,	//formData.id, 
		    						                           	 	selectiveRecipientIds: []
		    			            							};
		    	            								if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
		    	            									wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
			    	            							}
		        	            							wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
		    												wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);
		    	                						}
		    	            							studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated,isStudentChecked,isMySelfChecked,currentlyLoggedInUserId, isForAll);
		    	            						}
		    	            					});
		            						}
	            						});
	            						
	            					}
	            					//studentsendmessage.sendMessage(obj,grid);
	            				}
	            				
	            			}
	            		},  
						
		             'studentholdreportremoveholdform button[itemId=submitButtonHoldReport]':{
		            	 click : function(btn) {
     						var form=btn.up('form');
       						this.saveHoldReportRemovalForm(form)
     					}
		             },
		             'studentholdreportremoveholdform button[itemId=cancelButtonHoldReport]':{
		         		click:function(obj){
		         			var window = obj.up('window');
		         			window.close();
		         		}
		         	},
		         	'studentholdreportfilter button[itemId=resetBtnHoldReportSUItemId]':{
		        		click: this.resetStudentHoldReportFilter
		        	},
		        	'studentholdreportremoveholdform  combo[itemId=removalByHoldReport]':{
		        		render: function(obj){
		        			var this$=this;
		        			var store = obj.getStore();
		        			store.getProxy().extraParams = {
		        				academyLocationIds:this.getCurrentAcademyLocation()
		        			};
		        			var userId=this.getCurrentlyLoggedInUser();
		        			store.load({
		        				callback : function(operation,success) {
		        					if (success) {
		        						obj.setValue(userId.id);
		        					}
		        				} 
		        			});
		        		}
		        	},
		        	'studentholdreportfilter combo[itemId=holdCatNameReportHold]': {
		        		select:function(obj1,records) {
		        			var subHoldCat = obj1.up('form').down('customcombobox#holdSubCatNameReportHold');
		        			subHoldCat.reset();
		        			var holdId = records[0].get("id");
		        			var subHoldCatStore = subHoldCat.getStore();
		        			subHoldCatStore.getProxy().extraParams = {
		        				holdCategoryId: holdId
		        			};
		        			subHoldCatStore.reload();
		        		}
		        	},
		        	'studentholdreportfilter customcombobox[itemId=applyHoldAtHoldReport]':{
		    			  render:function(combo){
		    				  $this = this;
		    				  var store = combo.getStore(); 
		    				  store.on('load', function(){
		    						  var filterItemIds = ['EXAM_ENROLLMENT'];
		    						  var storeItems = store.getRange();
		    						  for(var i = 0; i<storeItems.length; i++){     
		    							  if(Ext.Array.contains(filterItemIds, storeItems[i].get('id')))
		    								  store.remove(store.getById(storeItems[i].get('id')));            
		    						  }  
		    				  });

		    			  }
		    		  },
		    		  'downloadstudentholds button[itemId=addRowBtn]':{
		    			  click: function(obj){
		    				  this.addMultipleProgramBatchfilterForStdHold(obj);
		    			  }
		    		  },
		    		  'downloadstudentholds combo[itemId=holdProgram]': {
		    			  render : function(combo){
		    				  var academyLocationId = this.getCurrentAcademyLocation();
		    				  var store = combo.getStore();
		    				  store.proxy.extraParams = {
		    						  academyLocationId : academyLocationId
		    				  };
		    				  store.load();
		    			  }
		    		  },
		    		  'downloadstudentholds button[itemId=resetBtn]':{
		    			  click: function(obj){

		    				  var form = this.getDownloadstudentholds();
		    				  var pbpsContiner = form.down('#holdProgramBatchContainerId');
		    				  var templateFor = form.down('#templateFor');
		    				  var studentHoldTemplateDownload = form.down('#studentHoldTemplateDownload');
		    				  var newcont=pbpsContiner.items.items.length;
		    				  for(var i=newcont;i>0;i--){
		    					  pbpsContiner.remove(pbpsContiner.items.items[i]);
		    				  }
		    				  form.doLayout();
		    				  form.getForm().reset();
		    				  templateFor.reset();
		    				  studentHoldTemplateDownload.setDisabled(true);
		    			  }
		    		  },
		    		  'downloadstudentholds combo[itemId=templateFor]':{
		    			  select:function(obj,records) {
		    				  var form = this.getDownloadstudentholds();
		    				  var studentHoldTemplateDownload = form.down('#studentHoldTemplateDownload');
		    				  studentHoldTemplateDownload.setDisabled(false);
		    			  }
		    		  }, 
		    		  'downloadstudentholds button[itemId=studentHoldTemplateDownload]':{
		   	        		click:function(obj){
		   	        			var $this = this;
		   	        			var form =$this.getDownloadstudentholds();
		   	        			var values = this.getProgramBatchPeriodJsonForLoader();
		   	        			var submitUrl;
		   	        			var templateName = form.down("#templateFor").getValue();
		   	        			if(templateName == "Apply Hold" || templateName == "APPLY_HOLD"){
		   	        			   submitUrl =SERVERURL.DOWNLOAD_TEMPLATE_STUDENT_APPLY_HOLD;
		   	        			}else{
		   	        			   submitUrl =SERVERURL.DOWNLOAD_TEMPLATE_STUDENT_REMOVE_HOLD;
		   	        			}
                              
		   	        			var csvForm = Ext.create('Ext.form.Panel',{
		   	        	    		items:[{
		   	        	    			xtype : 'textfield',
		   	        	    			maxLength : 20480,
		   	        	    			itemId : 'exportListDTO',
		   	        	    			name : 'exportListDTO',
		   	        	    			vtype : 'spaceAsInput'
		   	        	    		}]
		   	        	    	});
		   	        			
		   	        			csvForm.down('#exportListDTO').setValue(values);
		   	        			csvForm.getForm().submit({
		   		  	        		  target: '_blank',
		   		  	        		  method:'POST',
		   		  	        		  params :{access_token : Ext.Ajax.defaultHeaders.access_token},
		   		  	        		  headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
		   		  	        		  url:  submitUrl,
		   		  	        		  standardSubmit :true,
		   		  	        		  success : function(form, action){
		 	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
		 	    	    	          },
		 	    	        		  failure: function(form, action) {
		 	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
		 	    	    	          }
		   		  	        	  });
		   	        			}  
		                   },
		                   'studentmanageholdstructure':{
		                	   render:function(structure){
		       					this.disableImportHoldTab(structure, this.getSTUDENT_MANAGE_HOLD_PERMISSIONS());
		       				 }
		                   },
		                   'importmanagehold radiogroup[itemId=importDownloadgroupIds]':{
		                	   change  : function(obj,newValue,oldValue){
		                		   var form = obj.up('importmanagehold');	 
		                		   var value = obj.getValue();
		                		   var downHoldform = form.down('downloadstudentholds');
		                		   var importHoldform = form.down('importstudentholdsform');
		                		   var importList = form.down('importliststudenthold');

		                		   downHoldform.setVisible(false);
		                		   importHoldform.setVisible(false);
		                		   importList.setVisible(false);

		                		   if(value.downloadUploadTemplate=='forDownloadTemplate'){
		                			   downHoldform.setVisible(true);
		                		   }else if(value.downloadUploadTemplate=='forUploadTemplate'){
		                			   //this.doAccessControlValidationForLoader(importAllocationform,this.getCORE_ERP_LOADER_PERMISSIONS());
		                			   var uploadoptionradiogroupform  = this.getUploadoptionradiogroup();
		                			   uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
		                				   isUploadAll: false
		                			   });
		                			   importHoldform.setVisible(true);
		                			   importList.setVisible(true);
		                		   }
		                	   }
		                   },
		               	'importstudentholdsform':{
		    				render: function(obj){
		    					var $this = this;
		    					var temForm = $this.getImportstudentholdsform();
		    					var tempFormValue=temForm.getForm().findField('importUtilityMasterId');
		    					var grid = $this.getImportliststudenthold();
		    					var form = $this.getUploadoptionradiogroup();
		    					var isUploadAll = form.items.items[0].getValue().isUploadAll;
		    					$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'BULK_APPLY_HOLD');
		    					tempFormValue.getStore().load({
		    						callback:function(record){
		    							for(var i in record){
		    								if(record[i].data.value == 'Bulk Apply Hold'){
		    									tempFormValue.setValue(record[i].data.id);
		    									tempFormValue.setReadOnly(true);
		    								}
		    							}
		    						}
		    					});
		    				}
		    			},
		    			'importstudentholdsform customcombobox[itemId=templateFor]':{
		    				select: function(obj){
		    					var $this = this;
		    					var temForm = $this.getImportstudentholdsform();
		    					var tempFormValue=temForm.getForm().findField('importUtilityMasterId');
		    					var grid = $this.getImportliststudenthold();
		    					var form = $this.getUploadoptionradiogroup();
		    					var isUploadAll = form.items.items[0].getValue().isUploadAll;
		    					var templateNameValue;
                                 if(obj.getValue()=="REMOVE_HOLD"){
                                    templateNameValue = "Bulk Remove Hold";
                                 	$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Remove Hold');
                                 }else{
                                 	 templateNameValue = "Bulk Apply Hold";
                                 	$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'BULK_APPLY_HOLD');
                                 }		    					
		    					tempFormValue.getStore().load({
		    						callback:function(record){
		    							for(var i in record){
		    								if(record[i].data.value == templateNameValue){
		    									tempFormValue.setValue(record[i].data.id);
		    									tempFormValue.setReadOnly(true);
		    								}
		    							}
		    						}
		    					});
		    				}
		    			},
		                  'importstudentholdsform button[itemId=SubmitBtn]':{
		       				click: function(obj){
		       					var temForm = obj.up('importstudentholdsform');
		       			    	var tempFormValue=temForm.getForm().findField('importUtilityMasterId').getRawValue();
		       			    	var $this=this;
		       			    	var grdStore;
		       			    	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
		           	            $this.getHashOfFile(temForm);
		       		            setTimeout(function() {
		       				    	temForm.getForm().submit({
		       				    		method : 'POST',
		       				    		url : submitUrl,
		       				    		success : function(form, action){
		       					        	showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
		       					        	temForm.getForm().isValid();
		       				    		},
		       				    		failure: function(form, action) {
		          		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
		       				    	    }
		       				    	});
		       		        	},1000);
		       			    	Ext.defer(function() {
		       			    		$this.loadImportStudentHoldGrid(tempFormValue);
		       			    	}, 2000, this);
		       					
		       				}
		       			},
		       			'importstudentholdsform button[itemId=resetBtn]':{
		    				click: function(obj){
		    					var $this=this;
		    					var temForm = $this.getImportstudentholdsform();
		    					temForm.down('#uploadFileField').reset();
		    					temForm.down('#templateFor').reset();
		    					var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
		    					uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
		    						isUploadAll: false
		    					});
		    					temForm.getForm().isValid();

		    					var tempFormValue=temForm.getForm().findField('importUtilityMasterId');
		    					var grid = $this.getImportliststudenthold();
		    					var form = $this.getUploadoptionradiogroup();
		    					var isUploadAll = form.items.items[0].getValue().isUploadAll;
		    					var templateNameValue;
                                 if(temForm.down('#templateFor').getValue()=="REMOVE_HOLD"){
                                    templateNameValue = "Bulk Remove Hold";
                                 	$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Remove Hold');
                                 }else{
                                 	 templateNameValue = "Bulk Apply Hold";
                                 	$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'BULK_APPLY_HOLD');
                                 }		    					
		    					tempFormValue.getStore().load({
		    						callback:function(record){
		    							for(var i in record){
		    								if(record[i].data.value == templateNameValue){
		    									tempFormValue.setValue(record[i].data.id);
		    									tempFormValue.setReadOnly(true);
		    								}
		    							}
		    						}
		    					});
		    				
		    					
		    					
		    					
		    					
		    				}
		    			},
		    			'importliststudenthold':{
		    				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		    					if (e.target.tagName == 'A') {
		    						var fileType=null;
		    						if(cellIndex==1){
		    							fileType='successFile';
		    						}else if(cellIndex==6){
		    							fileType='errorFile';
		    						}else if(cellIndex==7){
		    							fileType='logFile';
		    						}
		    						var documentId = record.get("id");
		    						if (!isNullOrEmpty(documentId)) {
		    							this.getImportListDownloadFile(documentId,fileType);
		    						}
		    					}
		    				}
		    			},
		    			'importliststudenthold button[itemId=btnForce]':{
		      				 click : function(obj) {
		      					 var grid = this.getImportliststudenthold();
		      		            	if (grid.getSelectionModel().getCount() > 0) {
		      		            		if(grid.getSelectionModel().getCount() > 1){
		      			        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
		      			        		}else{
		      			        			var this$ = this;
		      	 	                	var id = grid.getSelectionModel().selectionStart.data.id;
		      	 	                	var urlAppend="?jobName="+id;
		      	 	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
		      	 	    	        	Ext.Ajax.request({
		      	 	    	        		url: submitURL,
		      	 	    	        		method: 'GET',
		      	 	    	        		success: function(response) {
		      	 	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
		      	 	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
		      	 	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
		      	 	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
		      	 	    	        			}else if(response.responseText==="SUCCESS"){
		      	     	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
		      	 	    	        			}
		      	 	    	        		}
		      	 	    	        	});
		      			        		}
		      		            	} else {
		      		            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		      		            	}  
		      		            }
		      			 },
		      			'lockpersonaldetailsgrid': {
		      			    render: function (grid) {
		      			        var store = grid.getStore();
		      			        var baseController=this.getController('base.BaseController');
		          			    var structure= grid.up('studentmanageholdstructure');
		          			    baseController.getGridHeaderFreeze(grid,structure,false);
		      			        store.load({
		      			            callback: function (records, operation, success) {
		      			                if (success) {
		      			                    Ext.each(records, function (record) {
		      			                        // Update the record with its own data
		      			                        if (!isNullOrEmpty(record.get("displayName"))) {
		      			                            record.set("displayName", record.get("displayName"));
		      			                        }
		      			                        if (!isNullOrEmpty(record.get("isLocked"))) {
		      			                            record.set("isLocked", record.get("isLocked"));
		      			                        }
		      			                    });
		      			                }
		      			            }
		      			        });
		      			      structure.body.on('scroll', function () {
		      		            baseController.getGridHeaderFreeze(grid, structure, false);
		      		          });
		      			    }
		      			},
		      			'lockpersonaldetailsgrid button[itemId=btnSavePrivilege]': {
		                    click: function(obj){
		                    	this.saveLockPersonalDetailsField(obj);
		                    }
		                },
		      			'lockpersonaldetailsgrid button[itemId=resetBtn]':{
		                	  click:function(){              		  
		                		  var grid = this.getLockpersonaldetailsgrid();
		                		  var columnName = grid.columnManager.columns[1].dataIndex;
		                		  if (columnName == "isLocked") {
		                			  var store = grid.getStore();
		                			  store.each(function(record) {
		                			      record.set('isLocked', false);
		                			  });
		                		  }
		                	  }  
		                  }   
        });
    },
    
    saveLockPersonalDetailsField: function (obj) {
        var grid = obj.up('lockpersonaldetailsgrid');
        var store = grid.getStore();
        var records = store.getRange();

        var jsonArray = [];
        Ext.Array.each(records, function (record) {
        	jsonArray.push({
                id: record.get('id'),
                fieldNames: record.get('fieldNames'),
                displayName: record.get('displayName'),
                isLocked: record.get('isLocked')
            });
        });

        Ext.Ajax.request({
        	url: SERVERURL.PATH_STUDENT_PERSONAL_DETAIL_LOCK_UPDATE,
            method: 'PUT',
            jsonData: jsonArray,
            success: function (response) {
            	showSuccessMessage(getCommonTranslation('SUCCESS_STATUS'),getCommonTranslation('THE_DATA_IS_SAVED_SUCCESSFULLY'));
                store.reload();
            }
        });
    },

    disableMoreActionPivileges: function(grid,permissionMap){

    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
		
		var spBtnMoreActions = grid.down('#spBtnMoreActions');
		spBtnMoreActions.setVisible(false);
    	
		var applyHold = grid.down('#applyHold');
		applyHold.setVisible(false);
		
		var holdSubCategoryLink = grid.down('#holdSubCategory');
		holdSubCategoryLink.setVisible(false);
		
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'MOREACTIONS') {
        		if(!isNullOrEmpty(spBtnMoreActions)){
        			spBtnMoreActions.setVisible(true);
        		}        		
        	}
    		if (privilege === 'APPLY_TO') {
        		if(!isNullOrEmpty(applyHold)){
        			applyHold.setVisible(true);
        		}        		
        	}
    		if (privilege === 'HOLD_SUB_CATEGORY') {
        		if(!isNullOrEmpty(holdSubCategoryLink)){
        			holdSubCategoryLink.setVisible(true);
        		}        		
        	}
    	});
    
    },
    showHoldCategoryDetailWin:function(){
		var holdcategoryWin = this.getHoldcategorydetailwin();
		 if (!holdcategoryWin) {
            Ext.widget('holdcategorydetailwin');
            holdcategoryWin = this.getHoldcategorydetailwin();
        }
		holdcategoryWin.show();
	},
	showHoldSubCategoryDetailWin:function(){

		/*var grid = this.getStudentmanageholdgrid();
		if (grid.getSelectionModel().getCount() > 0) {var holdSubcategoryWin = this.getHoldsubcategorydetailgridwin();
		if (!holdSubcategoryWin) {
			Ext.widget('holdsubcategorydetailgridwin');
			holdSubcategoryWin = this.getHoldsubcategorydetailgridwin();
		}
		holdSubcategoryWin.show();
		}else{
			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
		}
		*/
		

   		var grid = this.getStudentmanageholdgrid();
   		if (grid.getSelectionModel().getCount() > 0) {
   			
   			var record = grid.getSelectionModel().getSelection()[0];
   			var contentpanel = this.getContentPanel();
   			var structure = Ext.widget('holdsubcategorydetailstructure');
   			var manageHoldId = structure.down('#manageHoldId');
   	   		manageHoldId.setValue(record.data.id);
   			var tabName = getCommonTranslation('HOLD_SUB_CATEGORY');
   			var getcontroller=this.getController('menu.CoreERPNavigationController');
   			var getTab=getcontroller.getTab(tabName);
   			if(getTab!=null){
   				contentpanel.remove(getTab, true);
   			}
   			openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_SEVEN);
   		}else{
   			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
   		}
   	
	},
	saveHoldCategoryDetails: function(){
		var $this = this;
		var window = this.getHoldcategorydetailwin();
		var grid = $this.getStudentmanageholdgrid();
		var holdCatCode = window.down('#holdCatCode').getValue();
		var holdCatName = window.down('#holdCatName').getValue();
		var status = window.down('#holdStatus').getValue();
		var manageHoldId = window.down('#manageHoldId').getValue();
		var json;
		var url;

		if(isNullOrEmpty(manageHoldId)){
			json = {
					"id":null,
					"holdCatCode":holdCatCode,
					"holdCatName":holdCatName,
					"isActive":status
			};
			submitUrl=SERVERURL.PATH_MANAGE_HOLD_CATEGORY_SAVE;
		}else{
			json = {
					"id":manageHoldId,
					"holdCatCode":holdCatCode,
					"holdCatName":holdCatName,
					"isActive":status
			};
			submitUrl=SERVERURL.PATH_MANAGE_HOLD_CATEGORY_UPDATE;
		}
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		var formData = Ext.encode(json);
		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl,
			jsonData : formData,
			method : 'POST',
			success : function(frm, action) {
				Ext.getBody().unmask(); 
				var response = frm.responseText;
				window.close();
				//grid.getStore().reload();
				if(!isNullOrEmpty(response)){
					if(isNullOrEmpty(manageHoldId)){
				  showSuccessMessage(getCommonTranslation('MANAGE_HOLD'), getCommonTranslation('HOLD_CATEGORY_CREATED_SUCCESSFULLY'));
				}else{
				   showSuccessMessage(getCommonTranslation('MANAGE_HOLD'), getCommonTranslation('HOLD_CATEGORY_UPDATED_SUCCESSFULLY'));
				}
				}else{
					 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('THE_STATUS_CANNOT_BE_MADE_INACTIVE_FOR_HOLDS'));
				}
				$this.resetManageHoldFilter();
				
				var filter = $this.getStudentmanageholdfilter();
				
				var holdCategoryStatus=filter.down('#holdCategoryStatus').getValue();
				grid.getSelectionModel().deselectAll();
				if(isNullOrEmpty(holdCategoryStatus) || holdCategoryStatus=="Active"){
					holdCategoryStatus = true;
				}
				grid.getStore().getProxy().extraParams= {
      	    		status: holdCategoryStatus
      	    	};
				grid.getStore().load();
			}
		});
	},
	editHoldCategoryDetail:function(){
		var this$ = this;
   		var grid = this$.getStudentmanageholdgrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		this$.showHoldCategoryDetailWin();
    		var form = this$.getHoldcategorydetailwin();
    		this$.populateManageHoldRecord(grid,form);
    		
    	}else{
			 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
		}
	},
	loadHoldCatGridData:function(){
		var filter = this.getStudentmanageholdfilter();
		filter.down('#studentHoldSearchButtonId').setDisabled(true);
		var holdCatId = filter.down('#holdCategoryName').getValue();
		var holdCatStatus = filter.down('#holdCategoryStatus').getValue();
		if(isNullOrEmpty(holdCatStatus) || holdCatStatus=="Active"){
			holdCatStatus = true;
		}
		var grid = this.getStudentmanageholdgrid();
		var store = grid.getStore();
		store.getProxy().extraParams = {
			holdCategoryId: holdCatId,
			status:holdCatStatus
		};
		grid.getSelectionModel().deselectAll();
		this.resetGridSetting(grid);
		this.resetPageSetting(store);
		store.load({
			callback: function(records, operation, success) {
				filter.down('#studentHoldSearchButtonId').setDisabled(false);
		}});
	},
	populateManageHoldRecord:function(grid,form){
		var record = grid.getSelectionModel().getSelection()[0];
		var holdCatName = form.down('#holdCatName').setValue(record.data.holdCatName);
		var holdCatCode = form.down('#holdCatCode').setValue(record.data.holdCatCode);
		var holdStatus = form.down('#holdStatus').setValue(record.data.isActive);
		var manageHoldId = form.down('#manageHoldId').setValue(record.data.id);
	},
	deleteHoldCategoryDetail:function(){
		var this$ = this;
   		var grid = this$.getStudentmanageholdgrid();
   		var form = this$.getHoldcategorydetailwin();
   		var filter = this$.getStudentmanageholdfilter();
   		var holdCatName = filter.down('#holdCategoryName');
    	if (grid.getSelectionModel().getCount() > 0) {
    		showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
    			if (btn == 'yes') {
    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    				var records = grid.getSelectionModel().getSelection();
    				var id = records[0].get("id");
    				Ext.Ajax.request({
    					method : "DELETE",
    					type : 'rest',
    					url : SERVERURL.PATH_MANAGE_HOLD_CATEGORY_DELETE +'?id='+ id,
    					headers : {
    						'Content-Type' : 'application/json'
    					},
    					params: {
							id: id
						},
    					success : function(form,action) {
    						Ext.getBody().unmask();
    						grid.getStore().reload();
							holdCatName.getStore().reload();
    						if(form.responseText=="not_Mapped"){
    							showSuccessMessage(getCommonTranslation('MANAGE_HOLD'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
    						}else {
    							showWarningMessage(getCommonTranslation('MANAGE_HOLD'), getCommonTranslation('CANNOT_DELETE'));
    							}
    							
    					}
    				});
    			}
    		});
    	}else{
			 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
		}
	},
	resetManageHoldFilter:function(){
		var filter = this.getStudentmanageholdfilter();
		var holdCategoryName =filter.down('#holdCategoryName');
		var holdCategoryStatus=filter.down('#holdCategoryStatus');
		holdCategoryName.reset();
		holdCategoryStatus.reset();
//		this.loadHoldCatGridData();
	},
	
	onChangeAuthorizationRadioGroup:function(formWin, newValue){
		
		var listOfRoles = formWin.down('#listOfRole');
		var listOfEmp = formWin.down('#listOfEmp');
		var saveBtn=formWin.down('#SubmitBtnHoldSubCategory');
		var form = formWin.down('form');
		if(newValue.authorizationBasis == false){
			listOfRoles.setVisible(true);
			listOfEmp.setVisible(false);
			listOfRoles.allowBlank=false;
			listOfEmp.allowBlank=true;
			listOfEmp.reset();
			if(form.isValid()){
				saveBtn.setDisabled(false);
			}
		}else{
			listOfRoles.setVisible(false);
			listOfEmp.setVisible(true);
			var allowblankFalse = '<span class="required" style="color:red"> *</span>';
			listOfEmp.labelSeparator = '';
			listOfEmp.setFieldLabel(getCommonTranslation('LIST_OF_EMPLOYEE')+allowblankFalse);
			listOfEmp.allowBlank=false;
			listOfRoles.allowBlank=true;
			listOfRoles.reset();
			if(form.isValid()){
				saveBtn.setDisabled(false);
			}
		}
	},
	disableEditViewDeleteButton:function(column,selected){
		var grid = this.getStudentmanageholdgrid();
		var btnEdit = grid.down('#btnEdit');
		var btnDelete = grid.down('#btnDelete');
		var holdSubCategory = grid.down('#holdSubCategory');
		var applyTo = grid.down('#applyHold');
		holdSubCategory.setDisabled(false);
		btnEdit.setDisabled(false);
		btnDelete.setDisabled(false);
		applyTo.setDisabled(false);
		var count=selected.length;
		if(count>1){
			btnEdit.setDisabled(true);
			btnDelete.setDisabled(true);
			holdSubCategory.setDisabled(true);
			applyTo.setDisabled(true);
		}
	},
	saveHoldSubCategoryDetails:function(column,selected){

		var $this = this;
		var window = $this.getHoldsubcategorydetailwin();
		var grid = $this.getStudentmanageholdgrid();
		var subHoldGrid = $this.getStudentmanageholdsubcategorygrid();
		var structure = $this.getHoldsubcategorydetailstructure();
		var record = grid.getSelectionModel().getSelection()[0];
		var form = window.down('form');
   		var values = form.getForm().getValues();
   		var isParentPortalAccess = form.down('#parentPortal').getValue();
   		var isStudentPortalAccess = form.down('#studentPortal').getValue()
		var json;
		var url;
		var subCatRecordId;
		var subHoldCatAuthorizationBasis=[];
		var authorizationRadioValues =values.authorizationBasis;
		
		if(authorizationRadioValues==true){
			var listOfEmp =values.listOfEmp;
			var listOfEmpId;
			if(typeof listOfEmp== 'object' && listOfEmp.length>0 && typeof listOfEmp[0]=='object'){
				listOfEmpId =Ext.Array.pluck(Ext.Array.pluck(listOfEmp,'data'),'id');
			
			}else if(typeof listOfEmp== 'object' && listOfEmp.length>0 && typeof listOfEmp[0]=='number'){
				listOfEmpId = listOfEmp;
			}
			
			for (var i=0; i<listOfEmpId.length; i++) {
				staff={
						"staff":{
							"id":listOfEmpId[i]
						}
				}	
				subHoldCatAuthorizationBasis.push(staff)
			}
		}else{
			var listOfRole = values.listOfRole;
			var listOfRoleId;
			if(typeof listOfRole== 'object' && listOfRole.length>0 && typeof listOfRole[0]=='object'){
				 listOfRoleId =Ext.Array.pluck(Ext.Array.pluck(listOfRole,'data'),'id');
			
			}else if(typeof listOfRole== 'object' && listOfRole.length>0 && typeof listOfRole[0]=='number'){
				listOfRoleId = listOfRole;
			}
			
			for (var i=0; i<listOfRoleId.length; i++) {
				role={
						"role":{
							"id":listOfRoleId[i]
						}
				}	
				subHoldCatAuthorizationBasis.push(role)
			}

		}
		
		var manageHoldId = structure.down('#manageHoldId').getValue();
		var manageHoldCategory={
   			"id":manageHoldId
   			};
		
		if(isNullOrEmpty(values.manageSubHoldId)){
			subCatRecordId=null;
			submitUrl=SERVERURL.PATH_MANAGE_SUB_HOLD_CATEGORY_SAVE;
		}else{
			subCatRecordId=values.manageSubHoldId;
			submitUrl=SERVERURL.PATH_MANAGE_SUB_HOLD_CATEGORY_UPDATE;
		}
			json = {
					"id":subCatRecordId,
					"subHoldCatCode":values.holdSubCatCode,
					"subHoldCatName":values.holdSubCatName,
					"isActive":values.holdSubCatStatus,
					"applyholdType":values.applyHoldAt,
					"manageHoldCategory":manageHoldCategory,
					"isAuthorizationUser":values.authorizationBasis,
					"subHoldCatAuthorizationBasis":subHoldCatAuthorizationBasis,
					"isParentPortalAccess" :isParentPortalAccess,
					"isStudentPortalAccess" :isStudentPortalAccess
			};
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		var formData = Ext.encode(json);
		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl,
			jsonData : formData,
			method : 'POST',
			success : function(frm, action) {
				Ext.getBody().unmask(); 
				var response = frm.responseText;
				window.close();
				grid.getStore().reload();
				subHoldGrid.getStore().reload();
				if(!isNullOrEmpty(response)){
					if(isNullOrEmpty(subCatRecordId)){
						showSuccessMessage(getCommonTranslation('MANAGE_HOLD'), getCommonTranslation('HOLD_SUB_CATEGORY_CREATED_SUCCESSFULLY'));
					}else{
						showSuccessMessage(getCommonTranslation('MANAGE_HOLD'), getCommonTranslation('HOLD_SUB_CATEGORY_UPDATED_SUCCESSFULLY'));
					}
				}else{
					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('THE_STATUS_CANNOT_BE_MADE_INACTIVE_FOR_SUB_HOLDS')); //Please select a record
				}
				subHoldGrid.getSelectionModel().deselectAll();
			}
		});
	
	},
	
	addHoldSubCategoryDetailWin:function(){
		var holdSubcategoryWin = this.getHoldsubcategorydetailwin();
		if (!holdSubcategoryWin) {
			Ext.widget('holdsubcategorydetailwin');
			holdSubcategoryWin = this.getHoldsubcategorydetailwin();
		}
		holdSubcategoryWin.show();
		var grid = this.getStudentmanageholdsubcategorygrid();
		var gridStore = grid.getStore();
		var addedHoldTypes = [];
		for(var i = 0; i < gridStore.data.items.length; i++) {
			var recData = gridStore.data.items[i];
			if(addedHoldTypes.indexOf(recData.get('applyHoldAt')) == -1) {
				addedHoldTypes.push(recData.get('applyHoldAt'));
			}
		}
		holdSubcategoryWin.down('#applyHoldAt').addedHoldTypes = addedHoldTypes;
	},
		
		editHoldSubCategoryDetail:function(isView){
			var this$ = this;
			var grid = this$.getStudentmanageholdsubcategorygrid();
			if (grid.getSelectionModel().getCount() > 0) {
				this$.addHoldSubCategoryDetailWin();
				var form = this$.getHoldsubcategorydetailwin();
				this$.populateManageSubHoldRecord(grid,form,isView);

			}else{
				showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
			}
		},
	viewHoldSubCategoryDetail:function(isView){
		var this$  = this;
		this$.editHoldSubCategoryDetail(isView);
		var win = this$.getHoldsubcategorydetailwin();
		if (win) {
 			var form = win.down('form');
 			var saveBtn=win.down('#SubmitBtnHoldSubCategory');
 			
 			saveBtn.setVisible(false);
 			form = form.getForm();
 			toggleReadOnlyFormItems(form,true);


			var applyHoldAt = win.down('#applyHoldAt');
			applyHoldAt.getStore().load({
				callback: function(records, operation, success) {
						applyHoldAt.setReadOnly(true)
				}
			});
		
 			
 			
 			
 			win.doLayout()
 		}
	},
	deleteHoldSubCategoryDetail:function(){

		var this$ = this;
   		var grid = this$.getStudentmanageholdsubcategorygrid();
   		var form = this$.getHoldsubcategorydetailwin();
   		var filter = this$.getStudentmanageholdfilter();
    	if (grid.getSelectionModel().getCount() > 0) {
    		showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
    			if (btn == 'yes') {
    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    				var records = grid.getSelectionModel().getSelection();
    				var id = records[0].get("id");
    				Ext.Ajax.request({
    					method : "DELETE",
    					type : 'rest',
    					url : SERVERURL.PATH_MANAGE_SUB_HOLD_CATEGORY_DELETE +'?id='+ id,
    					headers : {
    						'Content-Type' : 'application/json'
    					},
    					params: {
							id: id
						},
    					success : function(form,action) {
    						Ext.getBody().unmask();
    							grid.getStore().reload();
    							showSuccessMessage(getCommonTranslation('MANAGE_HOLD'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
    					}
    				});
    			}
    		});
    	}else{
			 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
		}
	
	},
	populateManageSubHoldRecord:function(grid,form, isView){
		var grid = this.getStudentmanageholdsubcategorygrid();
		var records = grid.getSelectionModel().getSelection();
		var id = records[0].get("id");
		Ext.Ajax.request({
			method : "GET",
			type : 'rest',
			url : SERVERURL.PATH_MANAGE_SUB_HOLD_CATEGORY_FIND_BY_ID+'?subHoldCategoryId='+ id,
			headers : {
				'Content-Type' : 'application/json'
			},
			success : function(resp, action) {
				var data =Ext.decode(resp.responseText);
				
				if(!isNullOrEmpty(data[0].subHoldCatName)){
					var holdSubCatName = form.down('#holdSubCatName');
					holdSubCatName.setValue(data[0].subHoldCatName);
				}
				
				if(!isNullOrEmpty(data[0].subHoldCatCode)){
					var holdSubCatCode = form.down('#holdSubCatCode');
					holdSubCatCode.setValue(data[0].subHoldCatCode);
				}
			
				if(!isNullOrEmpty(data[0].isActive)){
					var holdStatus = form.down('#holdSubCatStatus');
					holdStatus.setValue(data[0].isActive);
				}
				
				if(!isNullOrEmpty(data[0].id)){
					var manageSubHoldId = form.down('#manageSubHoldId');
					manageSubHoldId.setValue(data[0].id);
				}
			
					if(!isNullOrEmpty(data[0].applyholdType)){
						var applyHoldAt = form.down('#applyHoldAt');
						applyHoldAt.getStore().load({
							callback: function(records, operation, success) {
								applyHoldAt.setValue(data[0].applyholdType);
								if(!isView){   //for view 
								if(data[0].isHoldApplied == true) {
									applyHoldAt.setReadOnly(true)
								} else {
									applyHoldAt.setReadOnly(false)
								}
								}
							}
						});
					}
				
				if(!isNullOrEmpty(data[0].isAuthorizationUser)){
					var authorizationBasis = form.down('#authorizationBasis');
					authorizationBasis.setValue({authorizationBasis:data[0].isAuthorizationUser});
				}
				if(!isNullOrEmpty(data[0].isParentPortalAccess)){
					var parentPortal = form.down('#parentPortal');
					parentPortal.setValue(data[0].isParentPortalAccess);
				}else{
					var parentPortal = form.down('#parentPortal');
					parentPortal.setValue(false);
				}
				if(!isNullOrEmpty(data[0].isStudentPortalAccess)){
					var studentPortal = form.down('#studentPortal');
					studentPortal.setValue(data[0].isStudentPortalAccess);
				} else{
					var studentPortal = form.down('#studentPortal');
					studentPortal.setValue(false);
				}
				var authIDs= [];
				if(data[0].isAuthorizationUser==true){
					var listOfEmp = form.down('#listOfEmp');
					if(!isNullOrEmpty(data[0].subHoldCatAuthorizationBasis)) {
						for(var i in data[0].subHoldCatAuthorizationBasis){
							authIDs.push(data[0].subHoldCatAuthorizationBasis[i].staff.id);
						}
					}
					listOfEmp.getStore().load({
						callback: function(records) {
							listOfEmp.setValue(authIDs);
						}
					});
				}else{
					var listOfRole = form.down('#listOfRole');
					if(!isNullOrEmpty(data[0].subHoldCatAuthorizationBasis)) {
						for(var i in data[0].subHoldCatAuthorizationBasis){
							authIDs.push(data[0].subHoldCatAuthorizationBasis[i].role.id);
						}
					}
					listOfRole.getStore().load({
						callback: function(records) {
							listOfRole.setValue(authIDs);
						}
					});
				}
			}
		});
	},
	getApplyToTab : function(){
	   		var grid = this.getStudentmanageholdgrid();
	   		this.resetPageSetting(grid.getStore());
			grid.getStore().load();
	   		if (grid.getSelectionModel().getCount() > 0) {
	   			var contentpanel = this.getContentPanel();
	   			var structure = Ext.widget('manageholdmappedprogramstructure');
	   			var tabName = getCommonTranslation('APPLY_TO');
	   			var getcontroller=this.getController('menu.CoreERPNavigationController');
	   			var getTab=getcontroller.getTab(tabName);
	   			if(getTab!=null){
	   				contentpanel.remove(getTab, true);
	   			}
	   			openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_SEVEN);
	   			
	   		}else{
	   			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
	   		}
	   	},
	   	manageHoldDoMappingTab : function(){
          	var contentpanel = this.getContentPanel();
          	var coursetabstructure = Ext.widget('manageholdmappingtab');
          	var tabName = getCommonTranslation('ADD_MAPPING');
          	var getcontroller=this.getController('menu.CoreERPNavigationController');
          	var getTab=getcontroller.getTab(tabName);
          	if(getTab!=null){
          		contentpanel.remove(getTab, true);
          	}
          	openTab(contentpanel, tabName, coursetabstructure,CONSTANTS.MENU_COLOR_TWO);
         	var academylocationgrid = this.getAcademylocationgridwithmanagehold();
          	var manageHoldwithprogrambatchseatstructure = this.getManageholdswithprogrambatchseatstructure();
          	this.resetPageSetting(academylocationgrid.getStore());
          	academylocationgrid.getStore().clearFilter();
          	academylocationgrid.getStore().load();
          	this.getManageholdprogresstracker().setVisible(true);
          	
          	this.manageHoldResetProgressTracker();
          	var adjustmentprogresstracker = coursetabstructure.down("#manageholdprogresstracker");
          	var progresstracker1 = adjustmentprogresstracker.down("#manageHoldProgresstracker1");
          	progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
          	progresstracker1.textEl.addCls("inProgressCss-progress-text");
          	progresstracker1.updateText("Step 1 In Progress");
        	  
          	if(this.getStudentmanageholdgrid()){
          		var records = this.getStudentmanageholdgrid().getSelectionModel().getSelection()[0];
              	if(records){
              		manageHoldwithprogrambatchseatstructure.down("#holdCatNameAL").setValue(records.data.holdCatName);
              		manageHoldwithprogrambatchseatstructure.down("#holdCatNameProgram").setValue(records.data.holdCatName);
              		manageHoldwithprogrambatchseatstructure.down("#holdCatNameBatch").setValue(records.data.holdCatName);
              		manageHoldwithprogrambatchseatstructure.down("#holdCatNamePBSType").setValue(records.data.holdCatName);
              	}
          	}
	   	},
	   	manageHoldResetProgressTracker : function(){
          	var structure = this.getManageholdmappingtab();
          	var adjustmentprogresstracker = structure.down("#manageholdprogresstracker");
          	var progresstracker1 = adjustmentprogresstracker.down("#manageHoldProgresstracker1");
          	var progresstracker2 = adjustmentprogresstracker.down("#manageHoldProgresstracker2");
          	var progresstracker3 = adjustmentprogresstracker.down("#manageHoldProgresstracker3");
          	var progresstracker4 = adjustmentprogresstracker.down("#manageHoldProgresstracker4");
          	progresstracker1.reset();
          	progresstracker1.updateText('');
          	progresstracker2.reset();
          	progresstracker2.updateText('');
          	progresstracker3.reset();
          	progresstracker3.updateText('');
          	progresstracker4.reset();
          	progresstracker4.updateText('');
          },
          manageHoldALNextEvent:function(btn){
          	var academylocationgrid = this.getAcademylocationgridwithmanagehold();
          	var selectionModel = academylocationgrid.getSelectionModel().getSelection();
          	var academyLocationIdsArr = [];
          	selectionModel.forEach(function(obj){
          		academyLocationIdsArr.push(obj.get('id'));
          	});
          	if(academyLocationIdsArr.length > 0){
      	    	var manageHoldwithPBSStructure = this.getManageholdswithprogrambatchseatstructure();
      	    	var programcontainer = manageHoldwithPBSStructure.down('#manageHoldProgramContainer');
      	    	programcontainer.setDisabled(false);
      	    	manageHoldwithPBSStructure.setActiveTab(programcontainer);
      	    	var alProgramGrid = this.getManageholdprogramgrid();
      	    	var alProgramSearchCombo = alProgramGrid.down('#manageHoldProgramsearchcombo');
      	    	alProgramSearchCombo.getStore().getProxy().extraParams= {
      	    		academyLocationIds: academyLocationIdsArr.join()
      	    	};
      	    	alProgramSearchCombo.getStore().load();
      	    	var alProgramGridStore = alProgramGrid.getStore();
      	    	this.resetPageSetting(alProgramGridStore);
      	    	alProgramGridStore.getProxy().extraParams= {
      	    		academyLocationIds: academyLocationIdsArr.join()
      	    	};
      	    	alProgramGridStore.clearFilter();
      	    	alProgramGridStore.load();
      	    	this.setManageHoldProgressTracker(1);
      	    	/*if(this.getManageFeePlanList()){
      	    		var records = this.getManageFeePlanList().getSelectionModel().getSelection()[0];
      	        	if(records){
      	        		var structure = this.getAddprogramfeemappingtabstructure();
      	        		var feePlanName = structure.down('#feePlanMappingName').getValue();
      	        		feeplanwithprogrambatchseatstructure.down("#feePlanProgramTab").setValue(feePlanName);              	
      	        	}
      	    	}*/
          	} else {
          		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
          	}
          },
            manageHoldProgramNextEvent:function(btn){
            	var alprogramgrid = this.getManageholdprogramgrid();
            	var selectionModel = alprogramgrid.getSelectionModel().getSelection();
            	var alprogramgridIdsArr = [];
            	var programIdsArr = [];
            	selectionModel.forEach(function(obj){
            		alprogramgridIdsArr.push(obj.get('academyLocationId'));
            		programIdsArr.push(obj.get('programId'));
            	});
            
            	if(programIdsArr.length > 0){
        	    	var manageHoldwithPBSstructure = this.getManageholdswithprogrambatchseatstructure();
        	    	var programbatchcontainer = manageHoldwithPBSstructure.down('#manageHoldProgramBatchcontainer');
        	    	programbatchcontainer.setDisabled(false);
        	    	manageHoldwithPBSstructure.setActiveTab(programbatchcontainer);
        	    	var alProgramBatchGrid = this.getManageholdprogrambatchgrid();
        	    	
        	    	var alProgramBatchSearchCombo = alProgramBatchGrid.down('#programbatchsearchcombo');
        	    	alProgramBatchSearchCombo.getStore().getProxy().extraParams= {
        	    		academyLocationIds: alprogramgridIdsArr.join(),
        	    		programIds:programIdsArr.join()
							        	    	};
							// alProgramBatchSearchCombo.getStore().load();

							var alProgramBatchGridStore = alProgramBatchGrid
									.getStore();
							this.resetPageSetting(alProgramBatchGridStore);
							alProgramBatchGridStore.getProxy().extraParams = {
								academyLocationIds : alprogramgridIdsArr.join(),
								programIds : programIdsArr.join()
							};
							alProgramBatchGridStore.clearFilter();
							alProgramBatchGridStore.load();
               
				
				 /* var jsonD={ academyLocationIds: alprogramgridIdsArr.join(),
				  programIds:programIdsArr.join() };
				  
				  Ext.Ajax.request({ method: "POST", type: 'rest', url:
				  SERVERURL.PATH_FIND_BY_AL_PRGM_AND_BATCH_POST, params: jsonD,
				  success : function(response, action) {
				  alProgramBatchGridStore.removeAll();
				  alProgramBatchGridStore.clearFilter();
				  
				  alProgramBatchGridStore.loadData(Ext.decode(response.responseText))
				   } });
				 */
        	    	
        	    	this.setManageHoldProgressTracker(2);
            	} else {
            		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
            	}
            },
            manageHoldProgramBatchNextEvent:function(btn){
            	var alprogrambatchgrid = this.getManageholdprogrambatchgrid();
            	var selectionModel = alprogrambatchgrid.getSelectionModel().getSelection();
            	var alprogramgridIdsArr = [];
            	var programIdsArr = [];
            	var batchIdsArr = [];
            	selectionModel.forEach(function(obj){
            		alprogramgridIdsArr.push(obj.get('academyLocationId'));
            		programIdsArr.push(obj.get('programId'));
            		batchIdsArr.push(obj.get('batchId'));
            	});
            	
            	if(batchIdsArr.length > 0){
        	    	var manageHoldwithprogrambatchseatstructure = this.getManageholdswithprogrambatchseatstructure();
        	    	var programbatchseattypecontainer = manageHoldwithprogrambatchseatstructure.down('#manageHoldPBStypecontainer');
        	    	programbatchseattypecontainer.setDisabled(false);
        	    	manageHoldwithprogrambatchseatstructure.setActiveTab(programbatchseattypecontainer);
        	    	
        	    	var alprogrambatchseartypegrid = this.getManageholdprogrambatchseattypegrid();
        	
        	    	var alProgramBatchSeatTypeGridStore = alprogrambatchseartypegrid.getStore();
        	    	
        	    	this.resetPageSetting(alProgramBatchSeatTypeGridStore);
        	    	alProgramBatchSeatTypeGridStore.getProxy().extraParams = {
        	    		academyLocationIds: alprogramgridIdsArr.join(),
        	    		programIds:programIdsArr.join(),
        	    		batchIds:batchIdsArr.join(),
        	    		screen:'manageHold'
					};
        	    	alProgramBatchSeatTypeGridStore.clearFilter();
        	    	alProgramBatchSeatTypeGridStore.load();
        	    	
        	    /*	
        	    	jData= {
        	    		academyLocationIds: alprogramgridIdsArr.join(),
        	    		programIds:programIdsArr.join(),
        	    		batchIds:batchIdsArr.join(),
        	    		limit:100,
        	    		page:1,
        	    		start:0
        	    	};

                     Ext.Ajax.request({
            			  method: "POST",
            			  type: 'rest',
            			  url: SERVERURL.PATH_FIND_BY_AL_PRGM_BATCH_AND_PBST_MAPPING,
            			  params: jData,
            			  success : function(response, action) {
	                           	alProgramBatchSeatTypeGridStore.removeAll();
                                alProgramBatchSeatTypeGridStore.clearFilter();
            			  	    alProgramBatchSeatTypeGridStore.loadData(Ext.decode(response.responseText))

            				  }
            		  });*/
        	    	/*alProgramBatchSeatTypeGridStore.clearFilter();
        	    	alProgramBatchSeatTypeGridStore.load();*/
        	    	/*if(this.getStudentmanageholdgrid()){
        	    		var records = this.getStudentmanageholdgrid().getSelectionModel().getSelection()[0];
        	        	if(records){
        	        		var structure = this.getManageholdmappingtab();
        	        		var feePlanName = structure.down('#PaymentPlanMappingName').getValue();
        	        		feeplanwithprogrambatchseatstructure.down("#paymentPlanProgramBatchSeattypeTab").setValue(records.data.paymentPlanName);              	
        	        	}
        	    	}*/
        	    	this.setManageHoldProgressTracker(3);
            	} else {
            		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
            	}
            },
            setManageHoldProgressTracker : function(progresstracker){
            	  var structure = this.getManageholdmappingtab();
            	var adjustmentprogresstracker = structure.down("#manageholdprogresstracker");
            	var progresstracker1 = adjustmentprogresstracker.down("#manageHoldProgresstracker1");
            	var progresstracker2 = adjustmentprogresstracker.down("#manageHoldProgresstracker2");
            	var progresstracker3 = adjustmentprogresstracker.down("#manageHoldProgresstracker3");
            	var progresstracker4 = adjustmentprogresstracker.down("#manageHoldProgresstracker4");

            	if(progresstracker==1){
          		  for(var i = 0; i < 11; i ++ ){
          			  progresstracker1.updateProgress((i * 0.1), '');
          		  }
          		  progresstracker1.textEl.addCls("custom-progress-text");
          		  progresstracker1.textEl.removeCls("inProgressCss-progress-text");
          		  progresstracker2.textEl.removeCls("x-progress-text x-progress-text-back");
          		  progresstracker2.textEl.addCls("inProgressCss-progress-text");
          		  progresstracker2.updateText("Step 2 In Progress");
          		  progresstracker1.updateText(getCommonTranslation('STEP_1_COMPLETE'));
          	  }
          	  if(progresstracker==2){
          		  for(var i = 0; i < 11; i ++ ){
          			  progresstracker2.updateProgress((i * 0.1), '');
          		  }
          		  progresstracker3.textEl.removeCls("x-progress-text x-progress-text-back");
          		  progresstracker3.textEl.addCls("inProgressCss-progress-text");
          		  progresstracker3.updateText("Step 3 In Progress");
          		  progresstracker2.textEl.removeCls("inProgressCss-progress-text");
          		  progresstracker2.textEl.addCls("custom-progress-text");
          		  progresstracker2.updateText(getCommonTranslation('STEP_2_COMPLETE'));
          	  }
          	  if(progresstracker==3){
          		  for(var i = 0; i < 11; i ++ ){
          			  progresstracker3.updateProgress((i * 0.1), '');
          		  }
          		  progresstracker4.textEl.removeCls("x-progress-text x-progress-text-back");
          		  progresstracker4.textEl.addCls("inProgressCss-progress-text");
          		  progresstracker4.updateText("Step 4 In Progress");
          		  progresstracker3.textEl.removeCls("inProgressCss-progress-text");
          		  progresstracker3.textEl.addCls("custom-progress-text");
          		  progresstracker3.updateText(getCommonTranslation('STEP_3_COMPLETE'));
          	  }
          	  if(progresstracker==4){
          		  for(var i = 0; i < 11; i ++ ){
          			  progresstracker4.updateProgress((i * 0.1), '');
          		  }
          		  progresstracker4.textEl.removeCls("inProgressCss-progress-text");
          		  progresstracker4.textEl.addCls("custom-progress-text");
          		  progresstracker4.updateText(getCommonTranslation('STEP_4_COMPLETE'));
          	  }
              },
              submitHoldMappingWithPBSType:function(btn){
            	  var tabStructure = this.getManageholdswithprogrambatchseatstructure();
            	  var activeGrid = tabStructure.getActiveTab().down('grid');
            	  var holdCatGrid = this.getStudentmanageholdgrid();
            	  var record = holdCatGrid.getSelectionModel().getSelection()[0];
            	  var selectedRecord = activeGrid.getSelectionModel().getSelection();
            	  var submitJson= [];
            	  var PBSIs=[];
            	  var PBSPId=[];
            	  if(selectedRecord.length>0){
            		  var submitUrl = SERVERURL.PATH_SAVE_STUDENT_HOLD;
            		  selectedRecord.forEach(function(obj){
            			  PBSIs.push(obj.data.programBatchSeatTypeId);
            			  PBSPId.push(obj.data.programBatchPeriodId);
            			  
            		  });

//            		  json = {
//            				  batch:{id:obj.get('batchId')},
//            				   holdCategoryId:{id:record.data.id},
//            				   progBatchSeatConfigIds{id:PBSIs.join()},
//            				  progBatchPeriodConfig{id:PBSPId.join()}
//            		  };
            		  selectedRecord.forEach(function(obj){
            			  submitJson.push({
              				holdCategoryId: {id:record.data.id},
              				progBatchSeatConfig:{id:obj.get('programBatchSeatTypeId')},
              				progBatchPeriodConfig:{id:obj.get('programBatchPeriodId')}
              			});
              		});
            		  
            		  Ext.Ajax.request({
            			  method: "POST",
            			  type: 'rest',
            			  url: submitUrl,
            			  scope:this,
            			  jsonData:submitJson,
            			  success : function(response, action) {
            				  if(response.responseText=='SUCCESS'){
            					  var contentpanel = this.getContentPanel();
            					  var coursetabstructure = Ext.widget('manageholdmappedprogramstructure');
            					  var tabName = getCommonTranslation('ADD_MAPPING');

            					  var getcontroller=this.getController('menu.CoreERPNavigationController');
            					  var getTab=getcontroller.getTab(tabName);
            					  if(getTab!=null){
            						  contentpanel.remove(getTab, true);
            					  }
            					  openTab(contentpanel, tabName, coursetabstructure,CONSTANTS.MENU_COLOR_TWO);
            					  var gridMap = this.getManageholdsmappedprogramgrid();
            					  gridMap.getSelectionModel().deselectAll();
            					  this.resetPageSetting(gridMap.getStore());
            					  gridMap.getStore().load();
            					  showSuccessMessage(getCommonTranslation('MANAGE_HOLD'), getCommonTranslation('HOLD_MAPPED_MSG'));

            				  }else{
            					  showWarningMessage(getCommonTranslation('ALERT'),response.responseText);
            				  }
            			  }
            		  });
            	  } else {
            		  showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
            	  }


              },
              deleteManageHoldMapping:function(){
            	  var grid = this.getManageholdsmappedprogramgrid();
            	  //grid = Ext.ComponentQuery.query('manageholdsmappedprogramgrid')[1];
            	  var mappingGridRecordLength;
            	  var maapingGrid = Ext.ComponentQuery.query('manageholdsmappedprogramgrid');
            	  for(var i=0;i< maapingGrid.length;i++){
            		  if(maapingGrid[i].getEl()){
            			  grid = maapingGrid[i];
            			  mappingGridRecordLength =grid.getSelectionModel().getCount();
            		  }
            	  }

            	  if (mappingGridRecordLength > 0) {
            		  showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
            			  if (btn == 'yes') {
            				  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            				  var records = grid.getSelectionModel().getSelection();
            				  var id = records[0].get("id");
            				  Ext.Ajax.request({
            					  method : "DELETE",
            					  type : 'rest',
            					  url : SERVERURL.PATH_MANAGE_HOLD_CATEGORY_MAPPING_DELETE +'?id='+ id,
            					  headers : {
            						  'Content-Type' : 'application/json'
            					  },
            					  params: {
            						  id: id
            					  },
            					  success : function(form,action) {
            						  Ext.getBody().unmask();
            						  grid.getStore().reload();
            						  showSuccessMessage(getCommonTranslation('MANAGE_HOLD'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
            					  }
            				  });
            			  }
            		  });
            	  }else{

            		  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record

            	  }
              },
              loadHoldReportGridData:function(){
          		var filter = this.getStudentholdreportfilter();
          		filter.down('#searchBtnHoldReportItemID').setDisabled(true);
          		var holdCatId = filter.down('#holdCatNameReportHold').getValue();
          		var academyLocationId = filter.down('#academyLocationItemId').getValue();
          		var program = filter.down('#programHoldReport').getValue();
          		var intakYear = filter.down('#intakeHoldReport').getValue();
          		var period = filter.down('#periodHoldReport').getValue();
          		var seatType = filter.down('#seatTypeHoldReport').getValue();
          		var student = filter.down('#studentIdReportHold').getValue();
          		var subHoldCategory = filter.down('#holdSubCatNameReportHold').getValue();
          		var applyBy = filter.down('#appliedBy').getValue();
          		var removalBy = filter.down('#removedBy').getValue();
          		var applyHoldAtCombo = filter.down('#applyHoldAtHoldReport').getValue();
          		var isRemovalCheckBox = filter.down('#showRemoveHold').getValue();
          		
          		var alids=[];
          		var academyLocationIds=null;
          		if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
					for (var i in academyLocationId) {
						if (Ext.isObject(academyLocationId[0])) {
							alids.push(academyLocationId[i].get("id"));
						} else {
							alids.push(academyLocationId[i]);
						}
					}
					academyLocationIds = alids.join();
				}
				else if(!isNullOrEmpty(academyLocationId)){
					academyLocationIds = academyLocationId;
				}
          		var model = new Academia.model.student.managehold.StudentReportHoldFilterModel();
          		var grid = this.getStudentholdreportgrid();
          		var store = grid.getStore();
          		store.getProxy().extraParams = {
          			holdCategoryId: holdCatId,
          			academyLocationId: academyLocationIds,
          			programId: program,
          			intakYearId: intakYear,
          			periodId: period,
          			seatTypeId: seatType,
          			studentId: student,
          			subHoldCategoryId: subHoldCategory,
          			applyById:applyBy ,
          			removalById: removalBy,
          			applyHoldAt:applyHoldAtCombo ,
          			isRemoval: isRemovalCheckBox
          		};
          		store.load({
           			 callback: function(records, operation, success) {
           				filter.down('#searchBtnHoldReportItemID').setDisabled(false); 
           			 }  
           		 });
          		grid.getSelectionModel().deselectAll();
          		this.resetGridSetting(grid);
          		this.resetPageSetting(store);
          	},
            manageOtherFieldByAL : function(){
            	var form=this.getStudentholdreportfilter().getForm();
            	var academyLocation= form.findField('academyLocationId');
            	var record = academyLocation.getValue();
        		var academyLocationId = this.getCurrentAcademyLocation();
        		
        		if(record.length>0 && record[0] !=""){
        			var alids =[];
        	 		   for (var i in record) {
        	 			   if(Ext.isObject(record[i])){
        	 				   alids.push(record[i].get('id'));
        	 			   }
        	 			   else{
        	 				   alids.push(record[i]);	
        	 			   }
        	 		   }
        	 	   }else{
        	 		   var alids =this.getCurrentAcademyLocation();
        	 	   }
        		
        		if(isArray(alids)){
         		   alidsValue =  alids.join(); 
         	   }else{
         		   alidsValue = alids;
         	   }
        		var program = form.findField('programHoldReport');
        		program.reset();
        		program.getStore().getProxy().extraParams={
        			academyLocationIds:alidsValue
        		};
        		program.getStore().load();
            },
            showRemovalHoldsWin:function(){
            	var grid = this.getStudentholdreportgrid();
            	if (grid.getSelectionModel().getCount() > 0) {
            		var frmWin = this.getStudentholdreportremoveholdform();
    		   		if(!frmWin){
    		   			Ext.widget('studentholdreportremoveholdform');
    		   			frmWin = this.getStudentholdreportremoveholdform();
    		   		}
    		   		frmWin.show();
            	}else{
        			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
        		}
            },
            deleteHoldFromHoldReport:function(){
            	var grid = this.getStudentholdreportgrid();
            	var records = grid.getSelectionModel().getSelection();
            	var empAvailIds=[];
                if(!isNullOrEmpty(records) && records.length > 0) {
                    for( var i=0; i<records.length; i++ ) {
                       if(!isNullOrEmpty(records[i].data.id)){
                       empAvailIds.push(records[i].data.id);
                    }
                 }
                }
                var Ids = empAvailIds.join(',');
            	if (grid.getSelectionModel().getCount() > 0) {
            		showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
            			if (btn == 'yes') {
            				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            				Ext.Ajax.request({
            					method : "GET",
            					type : 'rest',
            					url : SERVERURL.PATH_STUDENT_APPLY_HOLD_CATEGORY_DELETE +'?studentHoldIds='+ Ids,
            					headers : {
            						'Content-Type' : 'application/json'
            					},
            					params: {
            						studentHoldIds: Ids
        						},
            					success : function(form,action) {
            						Ext.getBody().unmask();
            						grid.getStore().reload();
            						showSuccessMessage(getCommonTranslation('MANAGE_HOLD'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
            					}
            				});
            			}
            		});
            	}else{
        			 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
        		}
            },
            
            /********for Student Manage Hold Report send message**/
            openStudentHoldReportSendMessage:function(obj){

					var grid = this.getStudentholdreportgrid();
					if(grid.getSelectionModel().getCount()>0) {
						
						var $this=this;
						var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
						var structure = Ext.widget('studentholdreportsendmessages',{
							itemId:'holdReportForStudent'
						});
						var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
						/**
						 * This is to remove tab from content panel and open same tab again
						 */
						var getcontroller=this.getController('menu.CoreERPNavigationController');
						var getTab=getcontroller.getTab(tabName);
						if(getTab!=null){
							contentPanel.remove(getTab, true);
						}
						var formWindowTab = $this.getStudentholdreportsendmessages();
						formWindowTab.down("#holdSelectTemplate").allowBlank=true;
						formWindowTab.down("#holdSelectTemplate").setVisible(false);
						formWindowTab.down("#holdMessageName").allowBlank=true;   
						formWindowTab.down("#holdMessageName").setVisible(false);
					 var templateStore = formWindowTab.down('#holdSelectTemplate').getStore();
						templateStore.getProxy().extraParams={
							msgRecipientTypeId:2
						};
						templateStore.load();

						Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						Ext.Ajax.request({
							method : "GET",
							type : 'rest',
							url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=Election539740-692d-4ae1-bc17-338c4002874d',	//Committeebe539740-692d-4ae1-bc17-338c4002874d',
							headers : {
								'Content-Type' : 'application/json'
							},
							success : function(form,action) {
								var data = Ext.JSON.decode(form.responseText);
								formWindowTab.down("#id").setValue(data.id);
								formWindowTab.down("#code").setValue(data.code);
								formWindowTab.down("#holdTemplateConfigName").setValue(data.templateConfigName);
								formWindowTab.down("#holdMsgSubCategoryId").setValue(data.msgSubCategoryId);
								formWindowTab.down("#holdMsgCategoryId").setValue(data.msgCategoryId);
								Ext.getBody().unmask();

								//grid.getStore().reload();
								//showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
							}

						});
						openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_SEVEN);
						/*if (!formWindow) {
					    				Ext.widget('jobapplicationemployeesendmessages');
					    				formWindow = $ this.getElectionvoterpoolsendmessages();
					    			}
					    			formWindow.show(;*/

					} else {
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				},
				
				selectMessageTempForHoldReport:function(obj,rec){
					

					var $this =  this;
					var formWin = $this.getStudentholdreportsendmessages();
					var empSubject = formWin.down('#holdSubject');
					var smsDiscription = formWin.down('#holdSmsDiscription');
					var smsDiscriptionNotice = formWin.down('#holdSmsDiscriptionNotice');
					var pushNotificationDiscription = formWin.down('#holdPushNotificationDiscription');
					var pushNotificationDiscriptionNotice = formWin.down('#holdPushNotificationDiscriptionNotice');
					if(rec[0].data.value == "SMS")
					{  
						this.setAllowBlank (formWin.down("#holdSubject"),true);
						//formWin.down("#empSubject").allowBlank=true;
						formWin.down("#holdSubject").hide();
						formWin.down("#holdStaticUploadFileField").hide();
						formWin.down("#holdDocumentMessageAttachmentGrid").hide();
						formWin.down('#empDiscriptionId').reset();
						formWin.down('#empDiscriptionId').hide();	       		 
						formWin.down('#holdSubject').reset();
						formWin.down('#holdSmsDiscription').show();
						formWin.down('#holdSmsDiscriptionNotice').show();
						pushNotificationDiscription.hide();
						pushNotificationDiscriptionNotice.hide();
						pushNotificationDiscription.reset();
					}/*else if(rec[0].data.Dvalue == "PUSH_NOTIFICATION" || rec[0].data.value == "Push Notification"){
						      		 empSubject.show();
						      		 formWin.down("#empStaticUploadFileField").hide();
						      		 this.setAllowBlank(empSubject,false);
						      		 formWin.down("#VoterPoolStudentDocumentMessageAttachmentGrid").hide();
						      		 formWin.down('#empDiscriptionId').reset();
						      		 formWin.down('#empDiscriptionId').hide();
						      		 empSubject.reset();
						      		 smsDiscription.reset();
						      		 smsDiscription.hide();
						      		 empSmsDiscriptionNotice.hide();
						      		 pushNotificationDiscription.reset();
						      		 pushNotificationDiscription.show();
						      		 pushNotificationDiscriptionNotice.show();
						      		 pushNotificationDiscriptionNotice.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+' 1000/1000</span>');
						      		 //formWin.down('#smsDiscription')
						      	 }*/else{
						      		 formWin.down('#empDiscriptionId').reset();
						      		 formWin.down('#empDiscriptionId').reset();
						      		 formWin.down('#holdSmsDiscription').hide();
						      		 formWin.down('#holdSmsDiscriptionNotice').hide();
						      		 formWin.down("#holdStaticUploadFileField").show();
						      		 // formWin.down("#staticDocumentMessageAttachmentGrid").show();
						      		 formWin.down("#holdDocumentMessageAttachmentGrid").show();
						      		 formWin.down("#holdSubject").reset();
						      		 formWin.down("#holdSubject").show();
						      		 this.setAllowBlank (formWin.down("#holdSubject"),false);
						      		 //formWin.down("#empSubject").allowBlank=false;
						      		 formWin.down('#empDiscriptionId').show();
						      		pushNotificationDiscription.hide();
						      		pushNotificationDiscriptionNotice.hide();
						      		pushNotificationDiscription.reset();
						      	 }
				
					
				},
				 uploadHoldStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts){
			    	   var this$ = this;
			    	   var setupForm = fileField.up('studentholdreportsendmessages');
			    	   var grid = setupForm.down('#holdStaticDocumentAttachmentGridMessage');
			    	   fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
			    	   fileField.setRawValue(fileUploadPath);
			    	   var file = fileField.fileInputEl.dom.files[0];
			    	   fileField.setRawValue(fileUploadPath);
			    	   if((file.size / 1048576) <= CONSTANTS.EMAIL_UPLOAD_FILE_SIZE_LIMIT  ){
			    		   if(!isNullOrEmpty(fileUploadPath)){
			    			   var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
			    			   if (extension == "gif" || extension == "png" || extension == "bmp"
			    				   || extension == "jpeg" || extension == "jpg" || extension == "pdf" 
			    					   || extension == "doc" || extension == "docx" || extension == "txt"
			    						   || extension == "xls" || extension == "csv" || extension == "xml" 
			    							   || extension == "zip" || extension == "xlsx" || extension == "ppt" || extension == "pptx") {
			    				   var entityId = 'student';
			    				   var module = 'messaging';
			    				   var entityType = 'template';
			    				   var documentType = 'DOCUMENT';
			    				   var isTransient = true;
			    				   var this$ = this;
			    				   Ext.getBody().mask(getCommonTranslation('LOADING'), 'x-mask-loading');
			    				   this$.saveStaticDocumentFormMessage(entityId, module, entityType, documentType, function(success, action, isTransient){
			    					   if(success){
			    						   Ext.getBody().unmask();
			    						   var path = Ext.JSON.decode(action.response.responseText).path;
			    						   var user = this$.getCurrentlyLoggedInUser();
			    						   var store = grid.getStore();
			    						   var documentStatus = "SUBMITTED";
			    						   var documentType = null;
			    						   if(!isNullOrEmpty(path)){
			    							   store.add({
			    								   id: '',
			    								   name: fileUploadPath,
			    								   path: path ,
			    								   createdBy : {
			    									   id :user.id,
			    									   value : user.value,
			    									   code : user.code
			    								   },
			    								   status : documentStatus,
			    								   documentType : documentType,
			    								   templateConfigDocId: '',
			    								   submissionDate: Ext.Date.format(new Date(), 'd-m-Y')

			    							   });
			    							   this$.loadHoldGridWithFileNameMessage(grid,fileUploadPath,store);
			    							   showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
			    						   }
			    						   var form=this$.getStudentholdreportsendmessages();
			           	            	   var holdSubject = form.down('#holdSubject').getValue();
			           	            	   if(!isNullOrEmpty(holdSubject)){
			           	            		   if(holdSubject == ' '){
			           	            			form.down('#holdSubject').reset();
			           	            		   }
			           	            	   }
			    						   fileField.reset();
			    					   }

			    				   }, isTransient);
			    			   }else{
			    				   fileField.reset();
			    				   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
			    			   }
			    		   }
			    	   }else{
			    		   fileField.reset();
			    		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
			    	   }
			       },
			       
			       deleteHoldReportStaticMessageDocument : function(view, rowIndex, colIndex, item, e, record, row){
			    	   var grid = view.up('#holdStaticDocumentAttachmentGridMessage');
			    	   var panel = this.getContentPanel().getActiveTab();
			    	   var tabTitle = panel.title;
			    	   var store = grid.getStore();
			    	   var templateConfigDocId = record.get('templateConfigDocId');
			    	   var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
			    	   if(!(tabTitle == viewTitle)){
			    		   if(!isNullOrEmpty(templateConfigDocId)){
			    			   showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
			    				   if (btn == 'yes') {
			    					   Ext.Ajax.request({
			    						   type: 'rest',
			    						   url: SERVERURL.STATIC_DOC_DELETE,
			    						   method: 'DELETE',
			    						   params: {
			    							   templateConfigDocId : templateConfigDocId
			    						   },
			    						   headers: {
			    							   'Content-Type': 'application/json'
			    						   },
			    						   success: function(form, action) {
			    							   store.remove(record);
			    							   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
			    						   }
			    					   });
			    				   }
			    			   });

			    		   }else{
			    			   store.remove(record);
			    			   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
			    		   }
			    	   }else{
			    		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
			    	   }

			       },
			       
			       loadHoldReportScheduleField : function(radio,newValue, oldValue){
						var adhocMessageForm = radio.up('form');
						var scheduleDateField = adhocMessageForm.down('#holdScheduleDate');
						var scheduleTimeField = adhocMessageForm.down('#holdScheduleTime');
						var radioValue = radio.getValue().holdSendingPriority;

						if(radioValue=='IMMEDIATE'){
							scheduleDateField.setVisible(false);
							scheduleDateField.setDisabled(true);
							scheduleTimeField.setVisible(false);
							scheduleTimeField.setDisabled(true);    		
						}
						else if(radioValue=='SCHEDULE'){
							scheduleDateField.setVisible(true);
							scheduleDateField.setDisabled(false);
							scheduleTimeField.setVisible(true);
							scheduleTimeField.setDisabled(false);
						}
					}, 
			       
					getStudentReceipientIdsForSendingMessages : function(grid){
			    		
			    		if (grid.getSelectionModel().getCount() > 0) {
			    			var records = grid.getSelectionModel().getSelection();
			    			var ids=[];
			    			if(grid.itemId == 'studentholdreportgrid'){
			    				for(var i in records) {
			    					ids.push(records[i].data.admissionId);
			    				}
			    			}			
			    		}
			    		return ids;
			    	},
		            
			    	selectSectionMessageType : function(val,nV,oV){

				      	 var $this =  this;
				      	 var formWin = $this.getStudentsendmessages();

				      	 //var value = nV.1;
				      	formWin.down('#holdRecieverTypeIncludeMySelf').setValue(false);
				      	 if(nV.messageType==2){
				      		 formWin.down("#holdMessageId").hide();
				      		 formWin.down("#holdSelectTemplate").allowBlank=true;
				      		 formWin.down("#holdSelectTemplate").setVisible(false);     		 
				      		 formWin.down("#holdMessageName").allowBlank=true;   
				      		 formWin.down("#holdMessageName").setVisible(false);
				      		 formWin.down("#holdMsgTempletId").setVisible(true);
				      		 formWin.down("#holdMsgTempletId").allowBlank=false;
				      		 formWin.down("#holdMsgTempletId").reset();
				      		 formWin.down("#holdSubject").setVisible(true);
				      		 //formWin.down("#subject").allowBlank=false;
				      		 formWin.down("#holdSubject").reset();
				      		 formWin.down("#empDiscriptionId").setVisible(true);
				      		 formWin.down("#empDiscriptionId").reset();
				      		 formWin.down('#holdSmsDiscription').reset();
				      		 formWin.down('#holdSmsDiscription').hide();
				      		 formWin.down('#holdSmsDiscriptionNotice').hide();
				     		 formWin.down('#holdPushNotificationDiscription').hide();
				     		 formWin.down('#holdPushNotificationDiscriptionNotice').hide();
				     		 formWin.down('#holdRecieverTypeIncludeMySelf').setVisible(true);
				      		 this.setAllowBlank (formWin.down("#holdSubject"),false);
				      	 }else{
				      		 formWin.down("#holdMsgTempletId").allowBlank=true;
				      		 formWin.down("#holdMsgTempletId").setVisible(false);     		
				      		 formWin.down("#holdMessageId").setVisible(true);
				      		 formWin.down("#holdSelectTemplate").setVisible(true);     		
				      		 formWin.down("#holdMessageName").setVisible(true);
				      		 formWin.down("#holdMessageName").reset();
				      		 //formWin.down("#subject").allowBlank=true;
				      		 this.setAllowBlank (formWin.down("#holdSubject"),true);
				      		 formWin.down("#holdSubject").setVisible(false);
				      		 formWin.down("#empDiscriptionId").setVisible(false);
				      		 formWin.down("#holdMessageName").allowBlank=false;  
				      		 formWin.down("#holdSelectTemplate").allowBlank=false;
				      		 formWin.down("#holdSelectTemplate").reset();
				      		 formWin.down("#holdDocumentMessageAttachmentGrid").setVisible(false);
				      		 formWin.down("#holdStaticUploadFileField").setVisible(false);
				      		 formWin.down('#holdSmsDiscription').reset();
				      		 formWin.down('#holdSmsDiscription').hide();
				      		 formWin.down('#holdSmsDiscriptionNotice').hide();
				     		 formWin.down('#holdPushNotificationDiscription').hide();
				     		 formWin.down('#holdPushNotificationDiscriptionNotice').hide();
				     		 formWin.down('#holdRecieverTypeIncludeMySelf').setVisible(false);
				      		 this.setAllowBlank (formWin.down("#holdMessageName"),false);
				      		 this.setAllowBlank (formWin.down("#holdSelectTemplate"),false);
				      		// var allowblankFalse = '<span class="required" style="color:red"> *</span>';
				      		// formWin.down("#messageName").setFieldLabel(getMessagingModuleTranslation('MESSAGE_NAME')+allowblankFalse);
				      		 //formWin.down("#selectTemplate").setFieldLabel(getMessagingModuleTranslation('SELECT_TEMPLATE')+allowblankFalse);
				      	 }
				       },
					
			       loadHoldGridWithFileNameMessage:function(grid,value,store){
			    	   grid.bindStore(store);
			       },
			       saveStaticDocumentFormMessage : function(entityId, module, entityType, documentType, callBackFunction, isTransient){
				       	var submitUrl = '';
				       	var templateTab = this.getContentPanel();
				       	var formWin =  this.getStudentholdreportsendmessages();
				       	var form = formWin.down('#holdMsgDetailsForm');
				       	var id = form.down('#holdDocument_hidden_field');
				           if (isNullOrEmpty(id.getSubmitValue())) {
				               submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
				           }
				           var data = new Object();
				           if(!isNullOrEmpty(entityId)){
				           	data.entityId = entityId;
				           }else{
				           	data.entityId = null;
				           }
				           if(!isNullOrEmpty(module)){
				           	data.module = module;
				           }else{
				           	data.module = null;
				           }
				           if(!isNullOrEmpty(entityType)){
				           	data.entityType = entityType;
				           }else{
				           	data.entityType = null;
				           }
				           form.getForm().setValues(data);
				           form.getForm().submit({
				           	method : 'POST',
				           	url : submitUrl,
				           	success : function(form, action){
				           		callBackFunction(true, action, isTransient);
				           		
				           	}
				           });
				       },
			       
            resetStudentHoldReportFilter:function(){
            	var filter = this.getStudentholdreportfilter();
            	var filterForm = filter.getForm();
            	var filterFormValue = filter.getForm().reset();
            	
            	var aL = filterForm.findField('academyLocationId');
            	var batchName = filterForm.findField('intakeHoldReport');
            	var periodName = filterForm.findField('periodHoldReport');
            	var seatTypeName = filterForm.findField('seatTypeHoldReport');

            	batchName.disable();
            	periodName.disable();
            	seatTypeName.disable();
            	
           		 aL.getStore().load({
           			 callback: function(records, operation, success) {
   						 if (success) {
   							 aL.select(aL.getStore().collect(aL.valueField));
   							 this.manageOtherFieldByAL();
   						 }
   					 }  
           		 });

            },
            saveHoldReportRemovalForm:function(form){
            	var $this = this;
            	var submitUrl=SERVERURL.PATH_STUDENT_REMOVAL_HOLD_CATEGORY_FOR_LIST;
            	var studentHoldForm =form.getForm();
            	var grid = $this.getStudentholdreportgrid();
            	var records=grid.getSelectionModel().getSelection();
            	var values = studentHoldForm.getValues();
            	var jsonData = [];
            	for(var i in records){
            	var  manageHoldCategory={
            			"id":records[i].data.holdCategoryId
            	};
            	var  manageSubHoldCategory={
            			"id":records[i].data.holdSubCategoryId
            	};
            	var  applyBy={
            			"id":records[i].data.holdAppliedById
            	};
            	var  removalBy={
            			"id":values.removalByHoldReport
            	};
            	var  student={
        				"id":records[i].data.studentId
        		};
            	var  applyReason=records[i].data.reasonForApply;
            	var date=records[i].data.holdAppliedDate;
            	var applyDate = new Date(date);
            	var selected = grid.selModel.getSelection();
            	var jsonFormatFormData= new Object;
            			jsonFormatFormData = {

            					"manageHoldCategory":manageHoldCategory,
            					"manageSubHoldCategory":manageSubHoldCategory,
            					"removalBy":removalBy,
            					"removalReason":values.removalReasonHoldReport,
            					"removalDate":values.removaltDateHoldReport,
            					"applyBy":applyBy,
            					"applyReason":applyReason,
            					"applyDate":applyDate,
            					"student":student,
            					"id":records[i].data.id,
            					"isRemoval": true
            			};
            			jsonData.push(jsonFormatFormData);
            }
            	var requestJSON = {};
            	requestJSON=jsonData;
            	$this.applyWindowMask(); 
            	Ext.Ajax.request({
            		type : 'rest',
            		url : submitUrl,
            		jsonData : requestJSON,
            		method : 'POST',
            		success : function(response, form, action) {
            			var data ;
        				if (!isNullOrEmpty(response.responseText)) {
        					 data = response.responseText;
        				}
						$this.hideWindowMask();
						if (data == "ACCESS_DENIED") {
							showWarningMessage(getCommonTranslation('REMOVE_HOLD'), getCommonTranslation('ACCESS_DENIED_TO_REMOVED_HOLD'));
						}else{
							$this.getStudentholdreportremoveholdform().close();
							showSuccessMessage(getCommonTranslation('REMOVE_HOLD'), getCommonTranslation('HOLD_REMOVED_SUCCESSFULLY'));
						}
						grid.getStore().reload();
						grid.getSelectionModel().deselectAll();
					}
            	});
            	
            	/*var gridselection = grid.getSelectionModel().getSelection()[0];
            	var node = grid.view.getSelectedNodes(gridselection);
            	var firstnode = Ext.get(node[0]);
            	firstnode.el.addCls('disabledRow');*/
            },
            doAccessControlValidationOfStudentRemoveHolds:function(grid, privilegesMap, type) {
        		var associatedAcadLIds = new Array();
        		associatedAcadLIds.push(this.getCurrentAcademyLocation());
        		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLIds, privilegesMap);

        		if( type == 'HOLDS_REPORT' ){
        			var removeHold =  grid.down('#holdReportRemoveHold').setVisible(false);
        			var deleteHold =  grid.down('#deleteHold').setVisible(false);
        			var sendMsgBtn =  grid.down('#sendMessageBtn').setVisible(false);
        		}
        		removeHold.setVisible(false);
        		deleteHold.setVisible(false);
        		var portalId = this.getCurrentLoggedPortalId();
        		Ext.each(permissionList, function(privilege) {
        			if(portalId == 1){
        				if(privilege == 'REMOVE_HOLD'){
        					removeHold.setVisible(true);
        				}
        				if(privilege == 'DELETE_HOLD'){
        					deleteHold.setVisible(true);
        				}
        				if(privilege == 'SENDMESSAGE'){
        					sendMsgBtn.setVisible(true);
        				}
        			}

        		});
        	},
        	addMultipleProgramBatchfilterForStdHold:function(obj) {
     	   	   var $this = this;
     	   	   var PBSContainer = $this.getDownloadstudentholds().down('#holdProgramBatchContainerId');
     	   	   var panelItem = new Array();
     	   	   var fieldContainer=obj.up('fieldcontainer');
     	   	   var newcont=PBSContainer.items.items.length;
     		   var insertPosition=newcont+1;
     	   	   panelItem.push({
     				xtype : 'fieldcontainer',
     				width: '100%',
     				layout : 'hbox',
     				defaults: {
     					labelAlign: 'top'
     				},
     				items : [{
     					xtype: 'customcombobox',
     	                name: 'holdProgram',
     	                itemId: 'holdProgram' + insertPosition,
     	                fieldLabel: getCommonTranslation('PROGRAM'),
     	                valueField: 'id',
     	                displayField: 'value',
     	                width:410,
     	                minChars:3,
     	                queryParam:'programName',
     	                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
     	                listeners: {
     	                    render: function(combo) {
     	                        var store = Ext.create('Academia.store.common.ProgramByAcAndLoIdStore');
     	                        combo.bindStore(store);
     	                        
     	                        var academyLocationId = $this.getCurrentAcademyLocation();
                               	store.proxy.extraParams = {
              							 academyLocationId : academyLocationId
              					};
                               	store.load();	
     	                    },
     	                    select:function(obj,record){
     	                    	                    	
     	                    	var programId = record[0].get("id");
     	                    	var  batch = obj.nextSibling();
     	                    	var  seatType = batch.nextSibling();
     	                    	
     	                    	batch.setDisabled(false);
     	                    	batch.reset();
     	                    	
     	                    	seatType.setDisabled(true);
     	                    	seatType.reset();
     	                    	
     	                    	var store = batch.getStore();
     	                    	
                               	store.proxy.extraParams = {
              							 id : programId
              					};
                               	store.load();	                    	
     	                    }
     	                },
     	                listConfig: {
         	 				listeners: {
         						beforeshow: function(picker) {
         							picker.minWidth = picker.up('combobox').getSize().width;
         						}
         					},
         	 				loadingText: getCommonTranslation('SEARCHING'),
         	 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
         	 				getInnerTpl: function() {
         	 					return '<div class="search-item">' +
         	 					'{value}' +
         	 					'</div>';
         	 				}
         	 			}
     				},{
     					xtype: 'customcombobox',
     	                name: 'holdBatch',
     	                itemId: 'holdBatch' + insertPosition,
     	                fieldLabel: getCommonTranslation('BATCH'),
     	                disabled:true,
     	                editable: false,
     	                queryMode: 'local',
     	                displayField: 'value',
     	                valueField: 'id',
     	                listeners: {
     	                    render: function(combo) {
     	                        var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
     	                        combo.bindStore(store);
     	                    },
     	                    select:function(obj,record){
     	                    	var batchId = record[0].get("id");
     	                    	var  seatType = obj.nextSibling();
     	                    	
     	                    	seatType.setDisabled(false);
     	                    	seatType.reset();
     	                    	
     	                    	var store = seatType.getStore();
     	                    	
                               	store.proxy.extraParams = {
                               			batchId : batchId
              					};
                               	store.load();
     	                    	
     	                    }
     	                }
     				},{
     					xtype : 'customcombobox',
     					fieldLabel : getCommonTranslation('SEAT_TYPE'),
     					width: 256,
     					labelAlign: 'top',
     					name : 'holdSeatTypeId',
     					itemId : 'holdSeatTypeId' + insertPosition,
     					store:'common.SeatTypesByBatchId',
     					valueField: 'seatTypeId',
     	    			displayField: 'seatTypeName',
     	    			queryParam:'qry',
     					typeAhead : true,
     					disabled:true,
     					forceSelection : true,
     					/*listeners: {
     						render: function(combo) {
     		                	var store = Ext.create('Academia.store.common.SeatTypesByBatchId');
     		                    combo.bindStore(store);
     						}}*/
     				},{
     					xtype: 'button',
     					itemId: 'deleteRowBtn',
     					cls: 'CustomBodyBtnReject',
     					glyph: ICONGLYPH.DELETEGLYPH,
     					tooltip: getCommonTranslation('DELETE'),
     					style:{
     						marginTop:'30px'
     					},
     					listeners:{
     						click:function(obj){
     						   var container = obj.up('fieldcontainer');
     	   					   var panelContiner = $this.getDownloadstudentholds().down('#holdProgramBatchContainerId');
     	   					   panelContiner.remove(container);
     					}}
     				},{
     					xtype: 'button',
     					itemId: 'addRowBtn',
     					cls: 'CustomBodyBtnSettings',
     					text: getCommonTranslation('ADDBUTTONTEXT'),
     					tooltip: getCommonTranslation('ADD'),
     					style:{
     						marginTop:'30px'
     					}
     				  }]
     				});
     	   	        PBSContainer.insert(insertPosition,panelItem);
     	            PBSContainer.doLayout();
        	},
        	 getProgramBatchPeriodJsonForLoader:function(){
 		    	var this$ = this;
 	            var form=this$.getDownloadstudentholds();
 		    	var pbsContiner = form.down('#holdProgramBatchContainerId');
 		    	var pbsFieldsCount = pbsContiner.items.items.length;
 		    	var pbsArray=new Array();
 		    	var endJson=null;
 		    	var fieldSequence=1;
 		    		for(var j=0; j<pbsContiner.items.length; j++){
 		    			var pbsPanelContainer=pbsContiner.items.items[j];
 		    				pbsArray.push({
 		    					"programId" : pbsPanelContainer.items.items[0].getValue(),
 		    					"batchId":pbsPanelContainer.items.items[1].getValue(),
 		    					"seatTypeId":pbsPanelContainer.items.items[2].getValue()
 		    				});
 		    	}
 		    	var obj = new Object();
 		    	obj.studentsToConsider = pbsArray;
 		    	return Ext.encode(obj);	
 		    },
 		   disableImportHoldTab:function(structure,permissionsMap){
 			   	 var associatedAcadLocationIds = new Array();
 			   	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
 			   	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
 			   	 var ImportHoldTab=false;
 			   	 var lockPersonalDetailsTab=false;
 			   	 for (var i = 0; i < permissionList.length; i++) {
 			   		 if (permissionList[i] === "IMPORT_STUDENT_HOLD") {
 			   			ImportHoldTab=true;
 			   		 }
 			   		if (permissionList[i] === "LOCK_PERSONAL_DETAILS") {
 			   		    lockPersonalDetailsTab=true;
 			   		 }
 			   	 }
 			   	 this.showmManageHoldImportTab(ImportHoldTab, lockPersonalDetailsTab, structure);
 			    
 		   },
 		  showmManageHoldImportTab: function(ImportHoldTab, lockPersonalDetailsTab, structure){

 		   	 var panelItem = new Array();
 		   	 var $this = this;
 		   	 var newcont=structure.items.items.length;
 		   	 var insertPosition=newcont+1;
 		    panelItem.push({
 		    	 xtype:'tabpanel',
	   			 plain: true,
	   			 style:{overflow:'hidden !important',margin:'0!important'},
	   			 
	   			 frame: false,
	   			 border:false,
                 items: [{
		   				 title :getCommonTranslation('SEARCH'),     
	 		   				 xtype:'panel',
	 		   				 items : [{
	 		   					 xtype: 'studentmanageholdfilter',
	 		   					 itemId : 'studentmanageholdfilter'
	 		   				 },{
	 		   					 xtype:'studentmanageholdgrid',
	 		   					 itemId:'studentmanageholdgrid'
	 		   				 }]
	 		   			 }]
                 });
 		   var insertAt = panelItem["0"].items.length;
           if (ImportHoldTab) {
               panelItem["0"].items[insertAt] = {
            	   xtype: 'importmanagehold',
   	   			   itemId: 'importmanageholdId',
                   title: getCommonTranslation('IMPORT_HOLD')

               };
               insertAt = insertAt + 1;
           }
           if (lockPersonalDetailsTab) {
               panelItem["0"].items[insertAt] = {
            		xtype: 'lockpersonaldetailstab',
	   				itemId: 'lockPersonalDetailsTab',
   	                title: getCommonTranslation('LOCK_PERSONAL_DETAILS')
               };
               insertAt = insertAt + 1;
           }
 		   	 structure.insert(insertPosition,panelItem);
 		  },
 		  loadImportStudentHoldGrid : function(tempFormValue){
 				var $this = this;
 				var grid = this.getImportliststudenthold();
 				var form  = $this.getUploadoptionradiogroup();
 				var isUploadAll = form.items.items[0].getValue().isUploadAll;
 				if(tempFormValue=="Bulk Remove Hold"){
 	 				$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Remove Hold');
 				}else{
 	 				$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'BULK_APPLY_HOLD');
 				}
 			},
 			showSubHoldOnPopUpWindow: function(){
 				var subHoldWindow = this.getStudentmanagesubholdwindow();
 				if (!subHoldWindow) {
 					subHoldWindow = Ext.widget('studentmanagesubholdwindow',{
 						itemId:'studentmanagesubholdwindowItemId'
 					});
 				}
 				subHoldWindow.show();
 				var grid = this.getHoldsubcategorywindowgrid();
 				grid.down('#btnExportToPDF').setVisible(false);
 				grid.down('#btnExportToExcel').setVisible(false);
 				this.resetPageSetting(grid.getStore());
 				grid.getStore().load();
 			},
 			showMappedProgramOnPopUpWindow: function(){
 				var subHoldWindow = this.getStudentmappedprogramwindow();
 				if (!subHoldWindow) {
 					subHoldWindow = Ext.widget('studentmappedprogramwindow',{
 						itemId:'studentmappedprogramwindowItemId'
 					});
 				}
 				subHoldWindow.show();
 				var grid = this.getManageholdsmappedprogramwindowgrid();
 				this.resetPageSetting(grid.getStore());
 				grid.getStore().load();
 			},
 			getImportListDownloadFile : function(documentId,fileType){

 		    	if(!isNullOrEmpty(documentId)){
 		    		var csvForm = Ext.create('Ext.form.Panel'); 
 		    		csvForm.getForm().submit({
 		    			target: '_blank',
 		    			method:'POST',
 		    			params :{
 		    				access_token : Ext.Ajax.defaultHeaders.access_token
 		    			},
 		    			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
 		    			url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
 		    			standardSubmit :true
 		    		});
 		    	}
 		    },
 		    disableRmoveButton:function(column,selected) {
	 	    	var grid = this.getStudentholdreportgrid();
	 	    	var holdReportRemoveHold = grid.down('#holdReportRemoveHold');
	 	    	holdReportRemoveHold.setDisabled(false);
	 	    	var count=selected.length;
	 	    	for(var i in selected){
	 	    		if(selected[i].data.isRemoval==true){
	 	    			holdReportRemoveHold.setDisabled(true);
	 	    		}
	 	    	}
	 	    },
 		   hideTabsFromPermission:function(structure){
				var associatedAcadLocationIds = new Array();
 				associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
 				var permissionList; 
 				if(this.getCurrentLoggedPortalId() == '3'){
 					permissionList= Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getSTUDENT_PORTAL_HOLDS_PERMISSIONS());
 	 				
 				}
 				if(this.getCurrentLoggedPortalId() == '7'){
 					permissionList= Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getPARENT_PORTAL_STUDENT_HOLDS_PERMISSIONS());
 	 				
 				}
 				var manageHoldInnerTab = false;
 				var financeHoldInnerTab = false;
 				
 				Ext.each(permissionList, function(privilege) {
 					if (privilege === 'HOLDS_TAB') {
 						manageHoldInnerTab = true;
 					}
 					if (privilege === 'FINANCE_HOLDS_TAB') {
 						financeHoldInnerTab = true;
 					}
 				});

 				var panelItem = new Array();
 				var $this = this;
 				var newcont = structure.items.items.length;
 				var insertPosition=newcont+1;
 				if(structure){
 					
 					var panelItem = new Array();
 		 			var $this = this;
 		 			var newcont = structure.items.items.length;
 		 			var insertPosition = newcont;
 		 			panelItem.push({
 		 				xtype : 'tabpanel',
 		 				itemId : 'allVisibleTP',
 		 				plain : true,
 		 				style : {
 		 					overflow : 'hidden !important',
 		 					margin : '0!important'
 		 				},
 		 				border : false,
 		 				defaults : {
 		 					labelAlign : 'top'
 		 				},
 		 				items : [],
 		 				listeners:{
  		 					tabchange:function(tabpanel,newTab,oldTab){
	  		 					 var grid =newTab.down('grid');
	  		 					 var gridTitle = grid.dockedItems.items[0];
	  		 		    		 var gridBttns = grid.dockedItems.items[1];
	  		 		    		 var gridHeader = grid.dockedItems.items[3];
		  		 		    		gridTitle.removeCls('sticky-header-active-title-withouttab');
		  		 		 		    gridBttns.removeCls('sticky-header-active-buttons-withouttab');
		  		 		 		    gridHeader.removeCls('sticky-header-active-columns-withouttab');
	  		 		 		
  		 		    		 
  		 					}
  		 				}
 		 				
 		 			});
 		 			var insertAt = panelItem["0"].items.length;
 		 			if (manageHoldInnerTab) {
 		 				panelItem["0"].items[insertAt] = {
		 						xtype: 'studentportalholdsinnertab',
		 						title: getCommonTranslation('HOLDS'),
		 						tabCls: 'right-tab'
 		 				};
 		 				insertAt = insertAt + 1;
 		 			}
 					if (financeHoldInnerTab) {
 		 				panelItem["0"].items[insertAt] = {
		 						xtype: 'studentportalfinanceholdsinnertab',
		 						title: getCommonTranslation('FINANCE_HOLDS'),
		 						tabCls: 'right-tab'
 		 				};
 		 				insertAt = insertAt + 1;
 		 			}
 					
 					structure.insert(insertPosition,panelItem);
 				}
			}
});
