/**
 * @author Pritam.Patil
 *  Student Transfer Controller
 */
Ext.define('Academia.controller.personinfo.student.StudentTransferController', {
	extend: 'Academia.controller.personinfo.common.PersonCommonController',

   views: ['personinfo.student.StudentTransferView', 'personinfo.student.StudentCommonQuickSearch',
           'personinfo.student.StudentTransferForm'],
  
    stores : ['common.SelectNameComboStore', 'common.ProgramByAcAndLoIdStore',
              'program.programbatchdetail.BatchStore','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
              'coursetransaction.coursereading.CourseByPeriod', 'coursetransaction.sectionmanagement.CourseSectionCombo',
              'servicerequest.TransferReasons'],
   
    refs: [{
        ref: 'contentPanel',
        selector: 'contentpanel'
    }, {
        ref: 'studentTransferView',
        selector: 'studenttransferview'
    }, {
        ref: 'studentCommonQuickSearch',
        selector: 'studentcommonquicksearch[itemId=studentTransferSearchForm]'
    },{
    	ref:'searchResultGrid',
    	selector:'searchresultgrid[itemId=studentTransferGrid]'
    },{
    	ref:'studenttransferform',
    	selector:'studenttransferform'
    }],
    config: {
    	STUDENT_TRANSFER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_TRANSFER_PRIVILEGES')
    },
    init: function(application) {
        this.control({
        	
		    'studenttransferform button[itemId=studentTransferButtonId]':{
				click:this.initiateTransfer
			},
			'studentcommonquicksearch[itemId=studentTransferSearchForm]  button[itemId=studentListClearSearch]':{
		   	 	click : this.clearSearchForm
		    }, 
		    'studentcommonquicksearch combo[itemId=selectedNameField]': {
                change: this.changeNameFieldConfig
            },
		    'studentcommonquicksearch[itemId=studentTransferSearchForm]  button[itemId=studentDebarmentSearchButtonId]': {
		        click: this.loadGridAndSearchStudent
		    },
		    /*'studenttransferform grid[itemId=studentTransferGrid]' :  {
	      	   afterrender : function(grid){
					
				}	
	          },*/
		      'searchresultgrid[itemId=studentTransferGrid]': {
		    	  cellclick: this.cellClickStudentTransferSearchResultGrid,
		    	 render: function(grid) {
					this.gridRenderFunction(grid);
					this.genericCBGridAccessControlValidation(grid, this.getSTUDENT_TRANSFER_PERMISSIONS());
					if(!isNullOrEmpty(grid.down("#searchResultGridBtnView"))){
						var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
				   		viewButton.setVisible(false);
					}
			   		this.studentTransferGridHeaderFix(this.getStudenttransferform());
				}
		      },
		      'advancedsearchquerybuilder[itemId=advanceSeachStudentTransfer] searchresultgrid[itemId=userAdvSearchResultGrid]': {
	                 cellclick: this.cellClickStudentTransferSearchResultGrid,
	                 render: function(grid) {
	 	    			this.gridRenderFunction(grid);
	 	    			this.genericCBGridAccessControlValidation(grid, this.getSTUDENT_TRANSFER_PERMISSIONS());
	 	    			if(!isNullOrEmpty(grid.down("#searchResultGridBtnView"))){
	 	    				var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
		  			   		viewButton.setVisible(false);
	 	    			}
	 	    		}
	             },
		      'searchresultgrid[itemId=studentTransferGrid] button[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
		            click: function() {
		                this.exportStudentTransfer(SERVERURL.PDFEXPORT,'pdf',false);
		            }
		        },
		        'searchresultgrid[itemId=studentTransferGrid] button[itemId=exportToPdfBtn] #exportPdfAll': {
		            click: function() {
		                this.exportStudentTransfer(SERVERURL.PDFEXPORT,'pdf',true);
		            }
		        },
		        'searchresultgrid[itemId=studentTransferGrid] button[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
		            click: function() {
		                this.exportStudentTransfer(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
		            }
		        },
		        'searchresultgrid[itemId=studentTransferGrid] button[itemId=exportToPdfBtn] #exportExcelAll': {
		            click: function() {
		                this.exportStudentTransfer(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
		            }
		        },
		        'studentcommonquicksearch[itemId=studentTransferSearchForm] combo[itemId=program]': {
	            	afterrender : function(combo){
	            		
	            		var academyLocationId = this.getCurrentAcademyLocation();
	                   	var store = combo.getStore();
	                   	store.proxy.extraParams = {
	  							 academyLocationId : academyLocationId
	  					};
	                },
		           	 select: function(programCombo, records, eOpts) {
		           		var this$ = this;
		               	var basicStudentSearchForm=this.getStudentCommonQuickSearch();
		               	var batchCombo = basicStudentSearchForm.down('#batch');
		               	this$.loadDependentCombo(batchCombo, programCombo.getValue(), 'id');
		           	 }
	                
	            },
	            
	            'studentcommonquicksearch[itemId=studentTransferSearchForm] combo[itemId=batch]': {
	              	 select: function(batchCombo, records) {
	              		 var this$ = this;
	              		 var basicStudentSearchForm=this.getStudentCommonQuickSearch();
	              		 var periodCombo = basicStudentSearchForm.down('#period');
	              		 this$.loadDependentCombo(periodCombo, batchCombo.getValue(), 'id');
	              	 }
	             },
	               
	               'studentcommonquicksearch[itemId=studentTransferSearchForm] combo[itemId=period]': {
	                 	 select: function(periodCombo) {
	                 		var this$ = this;
	                 		var basicStudentSearchForm=this.getStudentCommonQuickSearch();
	                   		var courseCombo = basicStudentSearchForm.down('#course');
	                   		this$.loadDependentCombo(courseCombo, periodCombo.getValue(), 'periodId');
	                      }
	                  },
	                  
	                  'studentcommonquicksearch[itemId=studentTransferSearchForm] combo[itemId=course]': {
	                    	 select: function(courseCombo) {
	                    		 var this$ = this;
	                    		 var basicStudentSearchForm=this.getStudentCommonQuickSearch();
	                    		 var sectionCombo = basicStudentSearchForm.down('#section');
	                    		 this$.loadDependentCombo(sectionCombo, courseCombo.getValue(), 'courseId');
	                         }
	                     }
        });
    },
    
    /* Student Transfer gid header fixing**/
    studentTransferGridHeaderFix : function(structure) {

        var grid = structure.down('#studentTransferGrid');
    	this.getCBGridHeaderFreeze(grid,structure);
    },
    
    /*
     * This function is to export pdf and xcel
     */
    exportStudentTransfer : function(exportUrl,filetype,whetherAll) {
    	var quickSearchForm=this.getStudentCommonQuickSearch();	
    	var searchResultGrid = this.getSearchResultGrid();
    	var pagingtoolbaroptions = this.getSearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
    	var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
    	var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
    	var visibleColumns=this.getVisibleColumns(searchResultGrid);
    	var reportTitle=getCommonTranslation('STUDENT_TRANSFER');
		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
			jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
		searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
	},
	createSearchCriteriaString: function(searchForm) {
    	var me=this;
        var formValues = new Array();
        formValues = searchForm.getValues();        
        var searchCriteriaString="";
        for (var key in formValues) {
        	var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
                var keyValueJsonObject = me.getJsonObject( key , value);
    	        searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
            }
        }
        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
        return searchCriteriaString;
    },
    gridRenderFunction:function(grid){
		grid.addButtonToolbar();
    },
    
    /**
     * This method is used to load search result grid according to search criteria
     * @param model
     * @param records
     */
    loadGridAndSearchStudent: function(model, records) {
    	
        var SearchForm = this.getStudentCommonQuickSearch();
        SearchForm.down('#studentDebarmentSearchButtonId').setDisabled(true);
        var jsonFormatFormData = this.createJsonFormat(SearchForm, records);
        var ResultGrid = this.getSearchResultGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.STUDENT_TERMINATION_LIST_VIEWCODE);
        ResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData,SearchForm.down('#studentDebarmentSearchButtonId'));
    },
    
    /**
     * This method is used to create JSON format of form values
     * @param SearchForm
     * @return formated JSON of form Values
     */
    createJsonFormat: function(SearchForm) {

        var nameValue = SearchForm.down('#selectedName');

        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.STUDENT_TERMINATION_LIST_BASIC_CONFIGCODE;
        formValues = SearchForm.getValues();
        
        var FIRST_NAME = this.getJsonObject(nameValue.name, nameValue.getValue());
        this.pushJsonObjectInArray(FIRST_NAME, searchcriteria);
        
        var ACTIVE_STATUS_INACTIVE = this.getJsonObject('ACTIVE_STATUS_INACTIVE','0');
        this.pushJsonObjectInArray(ACTIVE_STATUS_INACTIVE, searchcriteria);
        
        var ACTIVE_STATUS_NULL = this.getJsonObject('ACTIVE_STATUS_NULL','');
        this.pushJsonObjectInArray(ACTIVE_STATUS_NULL, searchcriteria);

//        var ADMISSION_NUMBER = this.getJsonObject('ADMISSION_NUMBER', formValues.ADMISSION_NUMBER);
//        this.pushJsonObjectInArray(ADMISSION_NUMBER, searchcriteria);
//
//        var STUDENT_ID = this.getJsonObject('STUDENT_ID', formValues.STUDENT_ID);
//        this.pushJsonObjectInArray(STUDENT_ID, searchcriteria);
//
//        var PROGRAM_NAME = this.getJsonObject('PROGRAM_NAME', formValues.PROGRAM_NAME);
//        this.pushJsonObjectInArray(PROGRAM_NAME, searchcriteria);
//
//        var BATCH_NAME = this.getJsonObject('BATCH_NAME', formValues.BATCH_NAME);
//        this.pushJsonObjectInArray(BATCH_NAME, searchcriteria);
//
//        var COURSE_NAME = this.getJsonObject('COURSE_NAME', formValues.COURSE_NAME);
//        this.pushJsonObjectInArray(COURSE_NAME, searchcriteria);
//
//        var SECTION = this.getJsonObject('SECTION', formValues.SECTION);
//        this.pushJsonObjectInArray(SECTION, searchcriteria);
//       
//        var PERIOD_NAME = this.getJsonObject('PERIOD_NAME', formValues.PERIOD_NAME);
//        this.pushJsonObjectInArray(PERIOD_NAME, searchcriteria);
//
//        var ACADEMY_LOCATION = this.getJsonObject('ACADEMY_LOCATION_ID',this.getCurrentAcademyLocation());
//        this.pushJsonObjectInArray(ACADEMY_LOCATION, searchcriteria);
        
    	var map= {
    		    'ADMISSION_NUMBER': formValues.ADMISSION_NUMBER,
    		    'STUDENT_ID': formValues.STUDENT_ID,
    			'PROGRAM_NAME': formValues.PROGRAM_NAME,
    			'BATCH_NAME': formValues.BATCH_NAME,
    			'COURSE_NAME': formValues.COURSE_NAME,
    			'SECTION': formValues.SECTION,
    			'PERIOD_NAME': formValues.PERIOD_NAME,
    			'ACADEMY_LOCATION_ID': this.getCurrentAcademyLocation()
    			}
    	searchcriteria = this.getMap(map,searchcriteria);
        values.searchCriterias = searchcriteria;
        return values;
		
    },
    
    getMap:function(map, searchcriteria){
    	for (var key in map) {
				var criteria = this.getJsonObject(key, map[key]);
				if(!isNullOrEmpty(map[key])){
			    this.pushJsonObjectInArray(criteria, searchcriteria);
				}
    		}
    	return searchcriteria;
	},
    
    
    /**
     * This method is used to crate JSON object
     * @param key 
     * @param value
     * @param additional value
     * @return JSON object
     */
    getJsonObject: function(key, value, additionalValue) {
        if (value != '' && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (value != '' && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },
    
    /**
     * This method is used to push JSON object into array & create Object array
     *@param JSON object
     *@param array
     *@return JSON object Array
     */
    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    },
    
    /**
     * This method is used to open Student Transfer Form
     */
    initiateTransfer:function(){
    	
    	var grid = this.getSearchResultGrid();
    	if(grid.getSelectionModel().getCount() == 1){	
    		var record = grid.getSelectionModel().getSelection()[0];
    		var studentId = record.get('ID');
	    	var controller = Academia.app.getController('Academia.controller.servicerequest.ServiceRequestBaseController');
	    	var map = Academia.view.servicerequest.ServiceRequestViewMap;
	    	var requestTypeId = map.getStudentRequetsId('TRANSFER_REQUEST');
	    	var settings = controller.getStudentServiceRequestSettings(requestTypeId,SERVERURL.FIND_REQUEST_TYPE_ID,'TRANSFER_REQUEST');
	    	console.log(settings)
	    	if(settings === null){
	    		 showErrorMessage(getServiceRequestTranslation('SERVICE_REQUEST'),getServiceRequestTranslation('CONFIGURE_SETTINGS'));
	    	}else{
	    		controller.openTransferPanel('TRANSFER_REQUEST',studentId,settings,record);
	    	}
    	}else {
    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },
    
    getMenuController: function() {
        return Academia.app.getController('menu.CoreERPNavigationController');
    },
    
    /**
     * This method is used to clear fields on student Transfer search Form
     * @param button which is reference of buttton
     */
    clearSearchForm : function(button){
 	   
 	  var  form = button.up('#studentTransferSearchForm').getForm();
 	   form.getFields().each(function(field) {
 		  if(field.name=='BATCH_NAME' || field.name=='PERIOD_NAME' || field.name=='COURSE_NAME' || field.name=='SECTION'){
				field.disable();
			}
       		field.reset();	
        });
    },
    /**
     * This function is to open the student profile
     */
    cellClickStudentTransferSearchResultGrid: function(view, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    	var this$ = this;
        //var searchResultGrid = this$.getSearchResultGrid();
        var columnName = view.getGridColumns()[cellIndex].dataIndex;
		var academyLocationId = this$.getCurrentAcademyLocation();
        if (columnName == "STUDENT_ID") {
        	if (e.target.tagName == 'A'){
            var tabTitle = record.get('STUDENT_ID');
            var personId = record.get('PERSON_ID');
            var userId = record.get('ID');
			var admissionId = record.get('ADMISSION_ID');
            var programBatchSeatTypeConfigId = record.get('PROGRAM_BATCH_SEAT_CONFIG_ID');
           // this$.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, null, programBatchSeatTypeConfigId);
			
				Ext.Ajax.request({
					type: 'rest',
					url: SERVERURL.PATH_FIND_STUDENT_JOURNEY_DASHBOARD_SETTING_BY_AL_ID,
					method: 'GET',
					params: {
						academyLocationId: academyLocationId,
					},
					success: function(f, action) {
						var data = f.responseText;
						if (data == "true") {
							this$.addContentPanelTabWithSubTab("studentjourneystructureforcoreerp", tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
						} else {
							this$.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
						}
					},
					failure: function(result, request) {
						showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
						return false;
					}
				});
        }
        }
        
        return false; 
    },
    /**
     * Method to load the next combo based on the selection of
     * the previous combo value.
     * 
     * @param {Object}
     *            dependentCombo is the reference of the next
     *            dropdown which should be populated with
     *            values.
     * @param {Object}
     *            selectedRecord is the record of the previous
     *            dropdown which is selected.
     * @param {Object}
     *            parameter is the value that should be attached
     *            in the url.
     * @param {Object}
     *            extraParameter (optional) If there is any
     *            extra parameter to be sent for loading the
     *            dependent dropdown.
     * @param {Object}
     *            extraParamValue (optional) The value of the
     *            extraParam that is sent for loading the store.
     */
    loadDependentCombo: function(dependentCombo, comboValue, parameter, extraParameter, extraParamValue) {
    	var this$ = this;
    	this$.resetOtherDropdowns(dependentCombo);
        dependentCombo.clearValue();
        dependentCombo.store.removeAll();
        var store = dependentCombo.getStore();
        var id = comboValue;
        if(!isNullOrEmpty(id)){
        	var url = store.getProxy().proxyConfig.api.read;
            if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
                url = url.concat('?' + parameter + '=' + id);
            } else {
                url = url.concat('?' + parameter + '=' + id);
                url = url.concat('&' + extraParameter + '=' + extraParamValue);
            }
            store.getProxy().api.read = url;
            store.reload();
        }
    },

    /**
     * code to reset other dropdowns based on the selection of
     * any dropdown which is previous in the hierarchy. eg: if
     * all the dropdowns are loaded and the Academy is changed
     * then subsequent dropdowns should be changed accordingly,
     * so their value is cleared and reset and reloaded.
     * 
     * @param: {Object} combo The reference of the dropdown
     *         which is the dependent/next combo.
     */
    resetOtherDropdowns: function(combo) {
    	var form = this.getStudentCommonQuickSearch();
        switch (combo.name) {
        case 'PROGRAM_NAME':
            break;
        case 'BATCH_NAME':
            this.clearCombo(combo, false);
            periodCombo = form.down('combo[name=PERIOD_NAME]');
            this.clearCombo(periodCombo, true);
            courseCombo = form.down('combo[name=COURSE_NAME]');
            this.clearCombo(courseCombo, true);
            sectionCombo = form.down('combo[name=SECTION]');
            this.clearCombo(sectionCombo, true);
            break;
        case 'PERIOD_NAME':
            this.clearCombo(combo, false);
            courseCombo = form.down('combo[name=COURSE_NAME]');
            this.clearCombo(courseCombo, true);
            sectionCombo = form.down('combo[name=SECTION]');
            this.clearCombo(sectionCombo, true);
            break;
        case 'COURSE_NAME':
            this.clearCombo(combo, false);
            sectionCombo = form.down('combo[name=SECTION]');
            this.clearCombo(sectionCombo, true);
            break;
        case 'SECTION':
            this.clearCombo(combo, false);
            break;
        }
    },

    /**
     * function to clear the combo store, clear its existing
     * value and remove all the records from the store.
     * 
     * @param {Object}
     *            the reference of the combo whose store should
     *            be cleared.
     */
    clearCombo: function(combo, isDisabled) {
        combo.clearValue();
        combo.store.removeAll();
        combo.setDisabled(isDisabled);
    } 
});
