/**
 * This controller is used for the Company Add/Edit/delete/view
 * 
 * @author Abhishek Chouhan
 */
Ext
		.define(
				'Academia.controller.placement.createcompany.CreateCompanyController',
				{
					extend : 'Academia.controller.base.BaseController',
					mixins : {
						AddressController : 'Academia.controller.organization.AddressController'
					},
					 models: ['Academia.model.organization.Address','Academia.model.common.OtherAddressCopyModel',
					        'organization.academylocations.CreateCompanyAddressModel',
					        'placement.createcompany.PlacementContactDetailsModel'
					    ],
					stores : [
							'placement.createcompany.CreateCompanyGridStore',
							'placement.createcompany.CompanyCodeSearchStore',
							'placement.createcompany.LocationCodeSearchStore',
							'organization.AddressTypeStore',
							'organization.CityStore',
							'organization.CountryRegionStore',
							'organization.CountryRegionStore1',
							'placement.createcompany.LocationStore','common.CountryStore','organization.CityStore',
							'placement.createcompany.PlacementPersonContactDetailsGridStore','organization.CityByCountryRegion',
                            'placement.createcompany.TypeOfAgreementStore'],
					views : [ 'placement.createcompany.CreateCompanyStructure',
							'placement.createcompany.CreateCompanyFilter',
							'placement.createcompany.CreateCompanyGrid',
							'baselayout.contentarea.ContentPanel',
							'placement.createcompany.AddTypeWindow',
							'placement.createcompany.CreateCompanyForm',
							'organization.addresses.AddressFormWindow',
							'personinfo.common.personalinfo.PhotoUploadForm',
							 'organization.addresses.AddressFormWindow',
						        'common.AddressFieldsForm','placement.createcompany.PersonCantactDetailGrid','placement.createcompany.PlacementContactPersonDetailsWindow',
						        'placement.createcompany.PlacementContactPersonDetails','placement.createcompany.CreateCompanyAddressForm'],
					config : {
						PLACEMENT_CREATE_COMPANY_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager
								.getFeaturePrivilegesMap('PLACEMENT_CREATE_COMPANY_PRIVILEGES')
					},
					refs : [
							{
								ref : 'createcompanystructure',
								selector : 'createcompanystructure'
							},
							{
								ref : 'createcompanyfilter',
								selector : 'createcompanyfilter'
							},
							{
								ref : 'createcompanygrid',
								selector : 'createcompanygrid'
							},
							{
								ref : 'contentpanel',
								selector : 'contentpanel'
							},
							{
								ref : 'addtypewindow',
								selector : 'addtypewindow'
							},
							{
								ref : 'createcompanyform',
								selector : 'createcompanyform'
							},
							{
								ref : 'vehicleAddressFormWindow',
								selector : 'addressFormWindow[itemId=vehicleAddressFormWindow]'
							},
							{
								ref : 'addressformwindow',
								selector : 'addressFormWindow[itemId=placementCompanyAddressWinId]'
							} ,{
						        ref: 'createcompanyaddressform',
						        selector: 'createcompanyaddressform'
						    },{
						        ref: 'addressFormWindow',
						        selector: 'addressFormWindow'
						    },{
						        ref: 'addressfieldsform',
						        selector: 'addressFormWindow form[itemId=addressfieldsform]'
						    }, {
						        ref: 'personcantactdetailgrid',
						        selector: 'personcantactdetailgrid'
						    },{
						        ref: 'placementcontactpersondetailswindow',
						        selector: 'placementcontactpersondetailswindow'
						    }, {
						        ref: 'placemenContactPersonDetailsForm',
						        selector: 'placementcontactpersondetailswindow form[itemId=addContactform]'
						    },],
					init : function() {
						this
								.control({
									'createcompanystructure' : {
										render : function(obj) {
											var ob = this;
											var form = ob
													.getCreatecompanystructure();
										},
										 afterrender : function(structure){
		                        			   var $this = this;
		                        			   structure.body.on('scroll', function(e, target) {
		                        			      var pcstructure = structure.down("createcompanygrid");
		                        			      var academyLocationId = $this.getCurrentAcademyLocation();
		                        			      var grid = null;
		                        			      
		                        			      if(!pcstructure.isHidden()){
		                        			      grid = pcstructure;
		                        			      }
		                        			    //  $this.getMultipleGridHeaderFreeze(grid,structure,true);
		                        			   });
		                        			   }
									},
									'createcompanygrid' : {
										render : function(grid) {
											this.doAccessControlValidation(grid,this.getPLACEMENT_CREATE_COMPANY_PERMISSIONS());
											this.disableMoreActionPivileges(grid,this.getPLACEMENT_CREATE_COMPANY_PERMISSIONS());
										},
										select: function(grid, record, index, eOpts) {
	                                         var contactsGrid = this.getPersoncantactdetailgrid();
	                                         var id = record.data.academyLocationId;
	                                         var store = contactsGrid.getStore();
	                                         store.load({
	                                             params: {
	                                            	 academyLocationId: id
	                                             }
	                                         });
	                                    //     store.getProxy().extraParams.id = id;
	                                         store.getProxy().extraParams = {
	                                        	 academyLocationId : id
												};
	                                     },
									},
									'createcompanygrid button[itemId=btnAdd]' : {
										click : function() {
											this.openNewCmpTab();
										}
									},
									'createcompanygrid  button[itemId=btnEdit]' : {
										click : function(obj, record) {
											this.editPlacementCompanyRecord(
													obj, record);
										}
									},
									'createcompanygrid button[itemId=btnView]' : {
										click : function(obj, record) {
											this.viewPlacementCompanyRecord(
													obj, record);
										}
									},
									'createcompanygrid button[itemId=btnDelete]' : {
										click : this.deletePlacementCompanyRecord
									},

									'createcompanyform button[itemId=saveCompanyBtn]' : {
										click : function(button) {
											this.onNewCompanySave(button);
										}
									},

									'createcompanyform button[itemId=CancelBtn]' : {
										click : function(button) {
											this.onNewCompanyClose(button);
										}
									},
									'personcantactdetailgrid button[itemId=btnAdd]': {
						                click: this.addContact
						            },
						            'personcantactdetailgrid button[itemId=btnEdit]': {
						               click: Ext.bind(this.editPersonContact, this, [false])
						            },
						            'personcantactdetailgrid button[itemId=btnView]': {
						              click: Ext.bind(this.editPersonContact, this, [true])
						            },
						            'personcantactdetailgrid button[itemId=btnDelete]': {
						                click: this.deletPlacmentContact
						            },
						            'placementcontactpersondetailswindow button[itemId=btnSaveContactForm]': {
						                click: this.SavePlacemenContactDetailsForm
						            },
						            'placementcontactpersondetailswindow button[itemId=btnCancelContactForm]': {
						                click: this.cancelPlacementContactDetailsForm
						            },

									'addressFormWindow form[itemId=addressfieldsform] button[itemId=cancelButtonId]' : {
										click : function() {
											this.getCloseAddressDetail();
										}
									},

									'createcompanyfilter button[itemId=resetButtonId]' : {
										click : function() {
											this.getCreatecompanyfilter()
													.getForm().reset();
										}
									},

									'createcompanyform  button[itemId=personAddressDisplayField4]' : {
										click : function(obj) {
											var buttonId = obj.itemId;
											var form = obj.up('form');
											var a = form.getRecord();
											if (a == undefined) {
												var academyLocationId = form
														.down(
																"#academyLocationId")
														.getValue();
											} else {
												var academyLocationId = form
														.getRecord().getData().addressId;
											}
											// var
											// addressId=form.getRecord().getData()
											// var academyLocationId =
											// form.down("#academyLocationId").getValue();
											this.getCommonAddressDetails(buttonId,academyLocationId);
										}
									},

									'createcompanyfilter button[itemId=searchButtonId]' : {
										click : this.loadPlacementCompanyGrid
									},
									
									/*'addressFormWindow#placementCompanyAddressWinId  button[itemId=saveButtonId]' : {
										click : this.addCompanyAddress
									},*/
									
									'createcompanyform photouploadform[itemId=logoUploadField] filefield[itemId=photoFileImage]' : {
										change : function(photoFileImage,
												value, eOpts) {
											value = value.replace(
													'C:\\fakepath\\', '');
											var newValue = value.replace(/ +/g,
													" ").split(' ').join('_');
											photoFileImage
													.setRawValue(newValue);
											
											var extension = value.substring(value.lastIndexOf('.') + 1).toLowerCase();
						            		if(!isNullOrEmpty(value)){
						            			if (extension == "gif" || extension == "png" || extension == "bmp"
						            				|| extension == "jpeg" || extension == "jpg" || extension == "svg") {
						            				
						            			}else{
						                			photoFileImage.reset();
						                			showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_VALID_FILE'));
						            			}
						            		}

										}
									},
									
									'createcompanygrid[itemId=createcompanygrid]' : {
										cellclick : function(View, CellEl,
												ColIdx, Store, RowEl, RowIdx,
												e, Event) {
											if (e.target.tagName == 'A') {
												this.manageCompanyAddressType(
														View, CellEl, ColIdx,
														Store, RowEl, RowIdx,
														Event);
											}
										}
									},

									'createcompanyfilter combo#companyId' : {
										select : function(obj, rec) {
											var data = rec[0].data.id;
											var filterForm = obj.up('form');
											var progamField = filterForm
													.down('#locationId');
											// progamField.setDisabled(false);
											progamField.reset();
											progamField.getStore().getProxy().extraParams = {
												companyId : data
											};
											progamField.getStore().load();
										}
									},

									'createcompanyfilter combo#locationId' : {
										select : function(obj, rec) {
											var data = rec[0].data.id;
											var filterForm = obj.up('form');
											var location = filterForm.down('#locationId');
											//location.reset();
											var progamField = filterForm.down('#companyStatus');
											// progamField.setDisabled(false);
											progamField.reset();
											progamField.getStore().getProxy().extraParams = {
												locationId : data
											};
											progamField.getStore().load();
										}
									},

									'createcompanyform textfield[itemId=companyCode]' : {
										blur : function(response) {
											this
													.checkUniquenessForCompanyCode(response);
										}
									},
                                     
									'createcompanyform combo[itemId=locationComboId]' : {
										select: function(){
											var form = this.getCreatecompanyform().getForm();
											var name=form.findField('locationName');
											var code=form.findField('locationCode');
											code.setValue(null);
											name.setValue(null);
											name.setDisabled(true);
											code.setDisabled(true);
											this.setAllowBlank(form.findField('locationName'),true);
											this.setAllowBlank(form.findField('locationCode'),true);
											
										}
									},
									
									'createcompanyform textfield[itemId=locationCode]' : {
										blur : function(response) {
											this.checkUniquenessForLocationCode(response);
										},
										keyup: function(fld){
											var form = this.getCreatecompanyform().getForm();
											var code=form.findField('locationCode').getValue();
											var name=form.findField('locationName').getValue();
											if(!isNullOrEmpty(code)&&!isNullOrEmpty(name)){
												form.findField('locationCombo').setDisabled(true);
												this.setAllowBlank(form.findField('locationCombo'),true);
											}else{
												form.findField('locationCombo').setDisabled(false);
												this.setAllowBlank(form.findField('locationCombo'),false);
											}
											form.checkValidity();
										}
									},

									'createcompanyform textfield[itemId=locationName]' : {
										blur : function(response) {
											this.checkUniquenessForLocationName(response);
										},
										keyup: function(fld){
											var form = this.getCreatecompanyform().getForm();
											var name=form.findField('locationName').getValue();
											var code=form.findField('locationCode').getValue();
											if(!isNullOrEmpty(name)&&!isNullOrEmpty(code)){
												form.findField('locationCombo').setDisabled(true);
												this.setAllowBlank(form.findField('locationCombo'),true);
											}else{
												form.findField('locationCombo').setDisabled(false);
												this.setAllowBlank(form.findField('locationCombo'),false);
											}
											form.checkValidity();
										}
									},
									
									'createcompanyform textfield[itemId=companyName]' : {
		                    			blur : function(response) {
		                    				var form = this.getCreatecompanyform().getForm();
		                    				var companyName = form.findField('companyName').getValue();
		                    				this.checkUniquenessForCompanyCode(response);
		                    				form.findField('printName').setValue(companyName);
		                    			}
		                    		},
		                    		
		                    		'createcompanygrid button[itemId=addAddressItemId]': {
		                                click: function(button) {
		                                    var grid = this.getCreatecompanygrid();
		                                    if (grid.getSelectionModel().getCount() > 0 && button.itemId === "addAddressItemId") {
		                                        this.openCreateCompanyAddressFormTab(grid.getSelectionModel().getSelection()[0]);
		                                    } else {
		                                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		                                    }
		                                }
		                            },
		                            "button#createCompanymodifyAddressALAF1": {
		                                click: function() {
		                                    var customAddressDisplayField1 = this.getCreatecompanyaddressform().down('displayfield#customAddressDisplayFieldALAF1');
		                                    this.onModifyClick(customAddressDisplayField1, 10);
		                                }
		                            },
		                            "button#createCompanymodifyAddressALAF2": {
		                                click: function() {
		                                    var customAddressDisplayField2 = this.getCreatecompanyaddressform().down('displayfield#customAddressDisplayFieldALAF2');
		                                    this.onModifyClick(customAddressDisplayField2, 11);
		                                }
		                            },
		                            "button#createCompanymodifyAddressALAF3": {
		                                click: function() {
		                                    var customAddressDisplayField3 = this.getCreatecompanyaddressform().down('displayfield#customAddressDisplayFieldALAF3');
		                                    this.onModifyClick(customAddressDisplayField3, 12);
		                                }
		                            },
		                            "button#createCompanymodifyAddressALAF4": {
		                                click: function() {
		                                    var customAddressDisplayField4 = this.getCreatecompanyaddressform().down('displayfield#customAddressDisplayFieldALAF4');
		                                    this.onModifyClick(customAddressDisplayField4, 13);
		                                }
		                            },
		                            'addressFormWindow#createCompanyAddressWindow button#saveButtonId': {
		                                click: this.saveAcademyLocationAddress
		                            },
		                            'addressFormWindow#createCompanyAddressWindow button#cancelButtonId': {
		                                click: this.resetForm
		                            },
		                            "button#createCompanyprintAddressALAF1": {
		                                click: function() {
		                                    var addressDisplayField = this.getCreatecompanyaddressform().down('displayfield#customAddressDisplayFieldALAF1');
		                                    this.onPrintClick(addressDisplayField);
		                                }
		                            },
		                            "button#createCompanyprintAddressALAF2": {
		                                click: function() {
		                                    var addressDisplayField = this.getCreatecompanyaddressform().down('displayfield#customAddressDisplayFieldALAF2');
		                                    this.onPrintClick(addressDisplayField);
		                                }
		                            },
		                            "button#createCompanyprintAddressALAF3": {
		                                click: function() {
		                                    var addressDisplayField = this.getCreatecompanyaddressform().down('displayfield#customAddressDisplayFieldALAF3');
		                                    this.onPrintClick(addressDisplayField);
		                                }
		                            },
		                            "button#createCompanyprintAddressALAF4": {
		                                click: function() {
		                                    var addressDisplayField = this.getCreatecompanyaddressform().down('displayfield#customAddressDisplayFieldALAF4');
		                                    this.onPrintClick(addressDisplayField);
		                                }
		                            },
		                            "button#createCompanyprintallAddressALAF": {
		                                click: function() {
		                                    var addressDisplayField1 = this.getCreatecompanyaddressform().down('displayfield#customAddressDisplayFieldALAF1');
		                                    var addressDisplayField2 = this.getCreatecompanyaddressform().down('displayfield#customAddressDisplayFieldALAF2');
		                                    var addressDisplayField3 = this.getCreatecompanyaddressform().down('displayfield#customAddressDisplayFieldALAF3');
		                                    var addressDisplayField4 = this.getCreatecompanyaddressform().down('displayfield#customAddressDisplayFieldALAF4');

		                                    var allAddressDisplayField = Ext.create('Academia.view.organization.addresses.CustomAddressDisplayField');
		                                    var str = addressDisplayField1.value;
		                                    str += " \n <hr/>";
		                                    str += addressDisplayField2.value;
		                                    str += " \n <hr/>";
		                                    str += addressDisplayField3.value;
		                                    str += " \n <hr/>";
		                                    str += addressDisplayField4.value;

		                                    allAddressDisplayField.setValue(str);
		                                    this.onPrintClick(allAddressDisplayField);
		                                }
		                            },//addressFormWindow form[itemId=addressfieldsform]
		                            'addressFormWindow form[itemId=addressfieldsform] customcombobox[itemId=cellCountryCode]': {
		                                select: function(rowModel, record) {
		                                	var form = this.getAddressfieldsform();
		                                	var countryCodeField = form.down("#cellCountryCode");
		                                	var mobileField = form.down("#cellNo");
		                                	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, record);
		                                }
		                            },
		                            'createcompanyaddressform': {
		                                render: function() {
		                                    this.getCrateCompanyAddress();
		                                }},
		                                'placementcontactpersondetailswindow combo': {
		                                    render: this.loadContactCombo
		                                },
		                                'placementcontactpersondetailswindow combo[itemId=countryId]': {
		                                    select: this.loadcityParentRegionStore,

		                                    change: function(obj, newValue) {
		                                        var phoneCountryCode = this.getPlacementcontactpersondetailswindow().down('customcombobox#phoneCountryCode');
		                                        var cellCountryCode = this.getPlacementcontactpersondetailswindow().down('customcombobox#cellCountryCode');
		                                        var countryStore = this.getPlacementcontactpersondetailswindow().down('#countryId').getStore();
		                                        var val = countryStore.getById(newValue);
		                                        phoneCountryCode.setValue(val);
		                                        cellCountryCode.setValue(val);
		                                    }
		                                },
		                                'placementcontactpersondetailswindow  combo[itemId=parentCountryRegionId]': {
		                                    select: function(obj1, record) {
		                                        var cityComboBox = this.getPlacementcontactpersondetailswindow().down('customcombobox#cityId');
		                                        cityComboBox.reset();

		                                        var countryRegion1 = record[0].get("id");
//		                                        var store = this.getStore('organization.CountryRegionStore1');
		                                        var store = this.getStore('organization.CityByCountryRegion');
//		                                       
		                                        store.getProxy().extraParams = {
		                                            id: countryRegion1
		                                        };
		                                        store.reload();
		                                        
		                                    }
		                                },

								});
					},

					/**
					 * it is used check unique company code
					 */
					checkUniquenessForCompanyCode : function(response) {
						var $this = this;
						var form = $this.getCreatecompanyform().getForm();
						var companyCode = null;
						var companyName = null;
						if(response.itemId == 'companyName') {
							companyName = form.findField('companyName')
							.getValue();
						}else if(response.itemId == 'companyCode') {
							companyCode = form.findField('companyCode')
							.getValue();
						}
						var id = form.findField('academyLocationId').getValue();
						Ext.Ajax
								.request({
									method : "GET",
									type : 'rest',
									url : SERVERURL.PATH_PLACEMENT_COMPANY_CODE_CHECK_UNIQUENESS,
									params : {
										companyCode : companyCode,
										companyName : companyName,
										id : id,
									},
									headers : {
										'Content-Type' : 'application/json'
									},
									success : function(resp, action) {
										var mssg = resp.responseText;
										if (mssg == "false") {
											if(!isNullOrEmpty(action.params.companyCode)) {
												console.log(mssg);
												form.findField('companyCode')
												.reset();
												showWarningMessage(
														getCommonTranslation('ALERT'),
														getPlacementTranslation('COMPANY_CODE_EXISTS'));
											} else if(!isNullOrEmpty(action.params.companyName)) {
												form.findField('companyName')
												.reset();
												form.findField('printName').reset();
												showWarningMessage(
														getCommonTranslation('ALERT'),
														getPlacementTranslation('COMPANY_NAME_EXISTS'));
											}
										}
									}
								});
					},

					checkUniquenessForLocationCode : function(response) {
						var $this = this;
						var form = $this.getCreatecompanyform().getForm();
						var locationCode = form.findField('locationCode')
								.getValue();
						var id = form.findField('academyLocationId').getValue();
						Ext.Ajax
								.request({
									method : "GET",
									type : 'rest',
									url : SERVERURL.PATH_PLACEMENT_LOCATION_CODE_CHECK_UNIQUENESS,
									params : {
										locationCode : locationCode,
										id : id,

									},
									headers : {
										'Content-Type' : 'application/json'
									},
									success : function(resp, action) {
										var mssg = resp.responseText;
										if (mssg == "false") {
											showWarningMessage(
													getCommonTranslation('ALERT'),
													getPlacementTranslation('LOCATION_CODE_EXISTS'));
											form.findField('locationCode')
													.reset();
										}

									}
								});
					},

					checkUniquenessForLocationName : function(response) {
						var $this = this;
						var form = $this.getCreatecompanyform().getForm();
						var locationName = form.findField('locationName')
								.getValue();
						var id = form.findField('academyLocationId').getValue();

						Ext.Ajax
								.request({
									method : "GET",
									type : 'rest',
									url : SERVERURL.PATH_PLACEMENT_LOCATION_NAME_CHECK_UNIQUENESS,
									params : {

										locationName : locationName,
										id : id,

									},
									headers : {
										'Content-Type' : 'application/json'
									},
									success : function(resp, action) {
										var mssg = resp.responseText;
										if (mssg == "false") {
											showWarningMessage(
													getCommonTranslation('ALERT'),
													getPlacementTranslation('LOCATION_NAME_EXISTS'));
											form.findField('locationName')
													.reset();

										}

									}
								});
					},

					onNewCompanyClose : function() {
						var obj = this;
						var form=obj.getCreatecompanyform().getForm();
						form.reset();
						form.findField("locationCode").setDisabled(false);
						form.findField("locationName").setDisabled(false);
						form.findField("locationCombo").setDisabled(false);
						obj.setAllowBlank(form.findField('locationCombo'),false);
						
						var startDateId = form.findField("startDate");
						var tillDateId = form.findField("tillDate");
						
						startDateId.setMinValue(false);
						tillDateId.setMinValue(false);
				    	startDateId.setMaxValue(false);
				    	tillDateId.setMaxValue(false);
					},

					getCloseAddressDetail : function() {
						var formWindow = this.getAddressformwindow();
						formWindow.close();
					},
					getCommonAddressDetails : function(buttonId,
							academyLocationId) {
						var this$ = this;
						if (!isNullOrEmpty(academyLocationId)) {
							var addressWindowItemId = "addressformwindow";
							var addressFormWindow = Ext.widget(
									'addressFormWindow', {
										itemId : 'placementCompanyAddressWinId'
									});
							addressFormWindow.show();
							var addressDetailsform = addressFormWindow
							.down('form');
							var form = addressDetailsform.getForm();
							var url = SERVERURL.VEHICLE_ADDRESS_FIND_BY_ID;
							if (!isNullOrEmpty(academyLocationId)) {
								var params = {
										id : academyLocationId
								};
								// this$.applyWindowMask();
								this$
								.sendGetAjaxRequest(
										url,
										'GET',
										params,
										function(option, success,
												response) {
											if (success) {
												var data = Ext
												.decode(response.responseText);
												form.setValues(data);
												form
												.findField(
												'addressText')
												.setValue(
														data.addressText);
												form
												.findField(
												'phoneAreaCode')
												.setValue(
														data.phoneAreaCode);
												form
												.findField(
												'phoneNo')
												.setValue(
														data.phoneNo);
												form
												.findField(
												'cellNo')
												.setValue(
														data.cellNo);
												form
												.findField(
												'primaryeEmailId')
												.setValue(
														data.primaryeEmailId);
												form
												.findField(
												'alternateEmailId')
												.setValue(
														data.alternateEmailId);

												var country = form
												.findField('country');
												var city = form
												.findField('city');
												var parentCountryRegion = form
												.findField('parentCountryRegion');
												var countryRegion = form
												.findField('countryRegion');

												if (data.country) {

													country
													.getStore()
													.load(
															{
																callback : function(
																		rec,
																		operation,
																		success) {
																	country
																	.setValue(data.country.id);
																}
															});

													var cityStore = city
													.getStore();
													cityStore
													.getProxy().extraParams = {
														id : data.parentCountryRegion.id
													};
													cityStore
													.load({
														callback : function(
																rec,
																operation,
																success) {
															city
															.setValue(data.city.id);
														}
													});

													var pcrStore = parentCountryRegion
													.getStore();
													pcrStore.getProxy().extraParams = {
														cid : data.country.id
													};
													pcrStore
													.load({
														callback : function(
																rec,
																operation,
																success) {
															parentCountryRegion
															.setValue(data.parentCountryRegion.id);
														}
													});

													if (data.countryRegion) {
														var crStore = countryRegion
														.getStore();
														crStore
														.getProxy().extraParams = {
															pid : data.parentCountryRegion.id
														};
														crStore
														.load({
															callback : function(
																	rec,
																	operation,
																	success) {
																countryRegion
																.setValue(data.countryRegion.id);
															}
														});
													}
												}
											}
											// this$.hideWindowMask();
										});
							}
						} else {
							var addressWindowItemId = "addressformwindow";
							var addressFormWindow = Ext.widget(
									'addressFormWindow', {
										itemId : 'placementCompanyAddressWinId'
									});
							addressFormWindow.show();
							var addressDetailsform = addressFormWindow
							.down('form');
							var form = addressDetailsform.getForm();
						}
						var $this = this;
						var grid = $this.getCreatecompanygrid();
						if (grid.getIsEditAddress() != undefined
								&& !grid.getIsEditAddress()) {
							addressDetailsform.down('#saveButtonId').hide();
							$this.toggleReadOnlyFormItems(form, true);
						} else {
							addressDetailsform.down('#saveButtonId').show();
							$this.toggleReadOnlyFormItems(form, false);
						}

						var createForm = this.getCreatecompanyform().getForm();
						if(Ext.isDefined(createForm.getCode)){
							var formValues = createForm.getCode();
							addressDetailsform.getForm().setValues(formValues.data);	
							var country= addressDetailsform.down('#countryId');
							country.getStore().load({
								callback : function(rec,operation,success) 
								{
									country.setValue(formValues.data.country.id);
									var countryRegion= addressDetailsform.down('#parentCountryRegionId');
									countryRegion.getStore().getProxy().extraParams = {
										cid : formValues.data.country
									};

									countryRegion.getStore().load({
										callback : function(rec,operation,success) 
										{
											countryRegion.setValue(formValues.data.parentCountryRegion.id); 
											var city=addressDetailsform.down('#cityId');
											city.getStore().getProxy(formValues).extraParams = {
												id : formValues.data.countryRegion
											};

											city.getStore().load({
												callback : function(rec,operation,success) 
												{
													city.setValue(formValues.data.city.id);	
												}
											});
										}
									}); 
								}
							});

						}
					},
					manageCompanyAddressType : function(grid, td, cellIndex,
							record, tr, rowIndex, e, eOpts) {
						var $this = this;
						var mngCompanyStructure = this
								.getCreatecompanystructure();
						var records = grid.getSelectionModel().getSelection()[0];
						var id = records.get("addressId");

						Ext.Ajax
								.request({
									url : SERVERURL.VEHICLE_ADDRESS_FIND_BY_ID,
									method : 'GET',
									params : {
										id : id
									},
									success : function(resp, action) {
										var addressDetails = Ext.JSON
												.decode(resp.responseText);
										$this.openCompanyDetailAddress();
										var forms = $this
												.getAddressformwindow();
										var form = forms.down('form').getForm();
										var address = form.findField(
												'addressText').setValue(
												addressDetails.addressText);
										address.readOnly = true;
										form
												.findField('phoneAreaCode')
												.setValue(
														addressDetails.phoneAreaCode);
										form.findField('phoneNo').setValue(
												addressDetails.phoneNo);
										form.findField('city').setValue(
												addressDetails.city);
										form.findField('country').setValue(
												addressDetails.country);
										form
												.findField('primaryeEmailId')
												.setValue(
														addressDetails.primaryeEmailId);
										form
												.findField('alternateEmailId')
												.setValue(
														addressDetails.alternateEmailId);
										form.findField('pincode').setValue(
												addressDetails.pincode);
										form
												.findField('cellCountryCode')
												.setValue(
														addressDetails.cellCountryCode);
										form.findField('cellNo').setValue(
												addressDetails.cellNo);
										form.findField('latitude').setValue(
												addressDetails.latitude);
										form.findField('longitude').setValue(
												addressDetails.longitude);

										if (addressDetails.addressType != null) {
											var addressTypeField = form
													.findField('addressType');
											addressTypeField.store
													.load({
														callback : function(
																records,
																operation,
																success) {
															if (success) {
																addressTypeField
																		.setValue(addressDetails.addressType.id);
															}
														}
													});
										}

										if (addressDetails.country != null) {
											var country = form
													.findField('country');
											country.store
													.load({
														callback : function(
																records,
																operation,
																success) {
															if (success) {
																country
																		.setValue(addressDetails.country.id);
															}
														}
													});

											if (addressDetails.city != null) {
												var city = form
														.findField('city');
												city.store
														.load({
															params : {
																id : addressDetails.parentCountryRegion.id
															},
															callback : function(
																	records,
																	operation,
																	success) {
																if (success) {
																	city
																			.setValue(addressDetails.city.id);
																}
															}
														});
											}
										}

										if (addressDetails.parentCountryRegion != null) {
											var parentCountryRegion = form
													.findField('parentCountryRegion');
											parentCountryRegion.store
													.load({
														params : {
															cid : addressDetails.country.id
														},
														callback : function(
																records,
																operation,
																success) {
															if (success) {
																parentCountryRegion
																		.setValue(addressDetails.parentCountryRegion.id);
															}
														}
													});
										}

										if (addressDetails.countryRegion != null) {
											var countryRegionNameField = form
													.findField('countryRegionName');
											// countryRegionNameField.enable();
											countryRegionNameField.store
													.load({
														params : {
															pid : addressDetails.parentCountryRegion.id
														},
														callback : function(
																records,
																operation,
																success) {
															if (success) {
																countryRegionNameField
																		.setValue(addressDetails.countryRegion.id);

															}
														}
													});
										}

										var cellCountryCodeField = form
												.findField('cellCountryCode');
										cellCountryCodeField.store
												.load({
													callback : function(
															records, operation,
															success) {
														if (success) {
															cellCountryCodeField
																	.setValue(addressDetails.cellCountryCode);
														}
													}
												});

										var phoneCountryCodeField = form
												.findField('phoneCountryCode');
										phoneCountryCodeField.store
												.load({
													callback : function(
															records, operation,
															success) {
														if (success) {
															phoneCountryCodeField
																	.setValue(addressDetails.phoneCountryCode);
														}
													}
												});

										if (forms) {
											forms.down('#saveButtonId').hide();
											var formaddwindow=forms.down('form');
											var form = formaddwindow.getForm();
											var fields=	formaddwindow.getForm().getFields();
											Ext.each(fields.items, function(i) {
												i.setReadOnly(true);
											});
										}
									}
								});
					},
					/**
					 * Edit Record on click Edit
					 */
					editPlacementCompanyRecord : function(o, r) {
						var $this = this;
						var grid = $this.getCreatecompanygrid();
						if (grid.getSelectionModel().getCount() > 0) {
							$this.openCompanyDetailsWindowEditBasic();
							Ext.apply(grid, {
								//isEdit : null,
//								setIsEdit : function(isEdit) {
//									grid.isEdit = isEdit;
//								},
//								getIsEdit : function() {
//									return grid.isEdit;
//								}
							});
							//grid.setIsEdit(true);
						} else {
							showWarningMessage(
									getCommonTranslation('ALERT'),
									getCommonTranslation('PLEASE_SELECT_RECORD')); // Please
																					// select
																					// a
																					// record
						}
					},

					openCompanyDetailsWindowEditBasic : function() {
						var $this = this;
						var grid = $this.getCreatecompanygrid();
						var records = grid.getSelectionModel().getSelection()[0];
						var contentpanel = $this.getContentpanel();
						var companyform = Ext.widget('createcompanyform');
						var tabName = getCommonTranslation('Company Details');
						var getcontroller = this
								.getController('menu.CoreERPNavigationController');
						var getTab = getcontroller.getTab(tabName);
						if (getTab != null) {
							contentpanel.remove(getTab, true);
						}
						openTab(contentpanel, tabName, companyform,
								CONSTANTS.MENU_COLOR_ONE);
						companyform.getForm().findField('academyLocationId')
								.setValue(records.data.academyLocationId);
						$this.renderBasicTab(records.data.academyLocationId);
					},

					/**
					 * View Record
					 */

					viewPlacementCompanyRecord : function() {
						var $this = this;
						var grid = $this.getCreatecompanygrid();
						if (grid.getSelectionModel().getCount() > 0) {
							this.viewCompanyDetailsWindowEditBasic();
							grid.setIsEditAddress(false);
							var f = $this.getCreatecompanyform();
							var fields = f.getForm().getFields();
							Ext.each(fields.items, function(i) {
								i.setReadOnly(true);
							});
							f.down('#saveCompanyBtn').hide();
							f.down('#CancelBtn').hide();
							f.down('#logoUploadField').hide();
							f.down('#personAddressDisplayField4').hide();
						} else {
							showWarningMessage(
									getCommonTranslation('ALERT'),
									getCommonTranslation('PLEASE_SELECT_RECORD')); // Please
																					// select
																					// a
																					// record
						}
					},

					viewCompanyDetailsWindowEditBasic : function() {
						var $this = this;
						var grid = $this.getCreatecompanygrid();
						var records = grid.getSelectionModel().getSelection()[0];
						var contentpanel = $this.getContentpanel();
						var companyform = Ext.widget('createcompanyform');
						var tabName = getCommonTranslation('Company Details');
						var getcontroller = this
								.getController('menu.CoreERPNavigationController');
						var getTab = getcontroller.getTab(tabName);
						if (getTab != null) {
							contentpanel.remove(getTab, true);
						}
						openTab(contentpanel, tabName, companyform,
								CONSTANTS.MENU_COLOR_ONE);
						// companyform.getForm().findField('academyLocationId').setValue(records.data.academyLocationId);
						$this.renderBasicTab(records.data.academyLocationId);

					},
					/**
					 * Delete Record
					 */
					deletePlacementCompanyRecord : function() {
						var $this = this;
						var grid = $this.getCreatecompanygrid();
						if (grid.getSelectionModel().getCount() > 0) {
							showConfirmMessage(
									getPlacementTranslation('PROGRAM_PERIOD'),
									getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
									function(btn, text) {
										if (btn == 'yes') {
											Ext
													.getBody()
													.mask(
															getCommonTranslation('SUBMITTING_FORM'),
															'x-mask-loading');
											var records = grid
													.getSelectionModel()
													.getSelection();
											var id = records[0]
													.get("academyLocationId");
											Ext.Ajax
													.request({
														method : "DELETE",
														type : 'rest',
														url : SERVERURL.PATH_PLACEMENT_COMPANY_DELETE
																+ '?id=' + id,
														headers : {
															'Content-Type' : 'application/json'
														},
														success : function(
																form, action) {
															Ext.getBody()
															.unmask();
															grid.getStore()
															.reload();
															if(form.responseText=="EXCEPTION"){
																showWarningMessage(getCommonTranslation('ALERT'),
																		"Company"+getPlacementTranslation('RECORD_IS_IN_USE'));		
															}else{
																showSuccessMessage(
																		getPlacementTranslation('COMPANY'),
																		getPlacementTranslation('PATH_PLACEMENT_COMPANY_DELETED_SUCCESSFULLY'));
															}
														},
														failure: function(form, action) {

															Ext.getBody().unmask();
															grid.getStore().reload();
															showWarningMessage(getCommonTranslation('ALERT'),
																	"Company"+getPlacementTranslation('RECORD_IS_IN_USE'));
														}
													});
										}
									});
						} else {
							showWarningMessage(
									getCommonTranslation('ALERT'),
									getCommonTranslation('PLEASE_SELECT_RECORD'));
						}

					},
					/**
					 * Add New Tab
					 */
					openNewCmpTab : function() {
						var me = this;
						var contentpanel = this.getContentpanel();
						var companygrid = Ext.widget('createcompanyform');
						var tabName = getPlacementTranslation('ADD_COMPANY');
						openTab(contentpanel, tabName, companygrid,
								CONSTANTS.MENU_COLOR_ONE);
						var grid = me.getCreatecompanygrid();
						Ext.apply(grid, {
							isEditAddress : null,
							setIsEditAddress : function(isEditAddress) {
								grid.isEditAddress = isEditAddress;
							},
							getIsEditAddress : function() {
								return grid.isEditAddress;
							},
							/*setIsEdit : function(isEdit) {
								grid.isEdit = isEdit;
							},
							getIsEdit : function() {
								return grid.isEdit;
							}*/
						});
						grid.setIsEditAddress(true);
						//grid.setIsEdit(false);
					},
					loadPlacementCompanyGrid : function() {
						var $this = this;
						var grid = $this.getCreatecompanygrid();
						var form = $this.getCreatecompanyfilter().getForm();
						var value = form.getValues();
						var companyId = value.companyId;
						var locationId = value.locationId;
						var addressId = value.addressId;
						var status = value.status;
						var store = grid.getStore();
						store.getProxy().extraParams = {
							companyId : companyId,
							locationId : locationId,
							status : status
						};
						store.load();
						/*pdf & excel report header filter*/
				    	grid.config.searchFilterForm = $this.getCreatecompanyfilter();
					},
					renderBasicTab : function(rec) {
						var $this = this;
						var form = $this.getCreatecompanyform();
						var editForm = form.getForm();
						var id = rec;
						var grid = $this.getCreatecompanygrid();
						Ext.apply(grid, {
							isEditAddress : null,
							setIsEditAddress : function(isEditAddress) {
								grid.isEditAddress = isEditAddress;
							},
							getIsEditAddress : function() {
								return grid.isEditAddress;
							}
						});
						grid.setIsEditAddress(true);
						Ext.Ajax
								.request({
									method : "GET",
									type : 'rest',
									url : SERVERURL.PATH_PLACEMENT_COMPANY_FIND_BY_ID
											+ '?id=' + id,
									headers : {
										'Content-Type' : 'application/json'
									},
									params : {
										id : id
									},
									success : function(f, action) {
										var data = f.responseText;
										var jData = Ext.JSON.decode(data);
										var basicDetailTab = new Academia.model.placement.createcompany.CompanyCodeModel(
												jData);
										form.loadRecord(basicDetailTab);
										var rec=grid.getSelectionModel().getSelection()[0];
										form.down("#tillDate").setValue(rec.data.tillDate);
										var companyRegistrationNum=form.down('#companyRegistrationNum');
										var companySkillLevyNum=form.down('#companySkillLevyNum');
										var industryCategoryDes=form.down('#industryCategoryDes');
										
										var typeOfAgreement=form.down('#typeOfAgreement');
										var dateFBCSigned=form.down('#dateFBCSigned');
										var dateCompanySigned=form.down('#dateCompanySigned');
										
										companyRegistrationNum.setValue(rec.data.companyRegistrationNum);
										companySkillLevyNum.setValue(rec.data.companySkillLevyNum);
										industryCategoryDes.setValue(rec.data.industryCategoryDes);
										dateFBCSigned.setValue(jData.dateFBCSigned);
										dateCompanySigned.setValue(jData.dateCompanySigned);
										
										var typeOfAgreementStore=typeOfAgreement.getStore();
										
										typeOfAgreementStore.load({
											callback: function(records, operation, success) {
												if (success) {
													for(var i in records){
														if(jData.typeOfAgreement==records[i].data.id){
															typeOfAgreement.setValue(jData.typeOfAgreement);

														}
													}
												}
											}	   
										});
										
										form.down('#companyCode').setReadOnly(
												true);
										form.down('#companyName').setReadOnly(
												true);
									/*	form.down('#locationCode').setReadOnly(
												true);
										form.down('#locationName').setReadOnly(
												true);*/
										var locationCode=form.down('#locationCode');
										var locationName=form.down('#locationName');
										var locationName=form.down('#locationName');
										var locationCodeOrName=form.down('#locationCodeOrName');
										locationCodeOrName.setVisible(false);
										locationCode.setValue(null);
										locationName.setValue(null);
										$this.setAllowBlank(locationName,true);
										$this.setAllowBlank(locationCode,true);
										
										$this.companyDetailTabLoadStore(form,
												jData);
										var locationCombo=form.down('#locationComboId');
										var locationStore=locationCombo.getStore();
										locationStore.load({
			 								callback: function(records, operation, success) {
			 									if (success) {
			 										
			 										locationCombo.setValue(jData.locationId);
			 												 
			 									}
			 								}	   
			 							});
										locationCombo.setReadOnly(true);
									}
								});
					},

					companyDetailTabLoadStore : function(form, data) {
						var f = form.getForm();
						var companyCode = f.findField('companyCode');
						var resetButton = Ext.ComponentQuery
								.query('button#CancelBtn')[0];
						resetButton.setVisible(false);
						/*
						 * companyCode.getStore().load({ callback :
						 * function(records, operation, success) { if (success) {
						 * showSuccessMessage(getPlacementTranslation('COMPANY_RECORD'),
						 * getCommonTranslation('RECORD_ADD_SUCCESS'));
						 * companyCode.setValue(companyCode); } else {
						 * showSuccessMessage("Error,ERROR on edit saving"); } }
						 * });
						 */
					},
					/*
					 * Open manage address details
					 */
					openCompanyDetailAddress : function() {
						var formWindow = this.getAddressformwindow();
						if (!formWindow) {
							Ext.widget('addressFormWindow', {
								itemId : 'placementCompanyAddressWinId'
							});
							formWindow = this.getAddressformwindow();
						}
						formWindow.show();
					},
					/*
					 * Save address details
					 */
					addCompanyAddress : function(button) {
						var $this = this;
						// var formWin = $this.getAddressformwindow();
						var form = button.up().up();
						var filterForm = $this.getCreatecompanyform().getForm();
						var values = form.getValues();
						  var arr=[];
//						if($this.validatePhone(values))
//							{
						// var studentId=Ext.getCmp('id').getValue();
						var dataModel = new Academia.model.organization.Address;
						dataModel.set('id', values.id);
						dataModel.set('addressId', values.addressId);
						dataModel.set('version', values.version);
						dataModel.set('addressText', values.addressText);
						dataModel.set('country', $this
								.getIdValueJson(values.country));
						dataModel.set('parentCountryRegion', $this
								.getIdValueJson(values.parentCountryRegion));
						dataModel
								.set('city', $this.getIdValueJson(values.city));
						dataModel.set('pincode', values.pincode);
						dataModel.set('latitude', values.latitude);
						dataModel.set('longitude', values.longitude);
						dataModel
								.set('cellCountryCode', values.cellCountryCode);
						dataModel.set('cellNo', values.cellNo);
						dataModel.set('phoneCountryCode',
								values.phoneCountryCode);
						dataModel.set('phoneAreaCode', values.phoneAreaCode);
						dataModel.set('phoneNo', values.phoneNo);
						dataModel
								.set('primaryeEmailId', values.primaryeEmailId);
						dataModel.set('alternateEmailId',
								values.alternateEmailId);
						dataModel.set('addressType', null);
						dataModel.set('countryRegion', $this
								.getIdValueJson(values.countryRegion));
						dataModel.set('salutation', values.salutation);
						if (!isNullOrEmpty(values.customData)) {
							dataModel.set('customData', values.customData);
				      	   	
				      	   	}else
				      	   	dataModel.set('customData', arr);
				    	
						Ext.apply(filterForm, {
							code : null,
							setCode : function(code) {
								filterForm.code = code;
							},
							getCode : function() {
								return filterForm.code;
							}
						});
						filterForm.setCode(dataModel);
						button.up().up().up().close();
//					}
				},
					/**
					 * method to save the Company.
					 * 
					 * @param {Object}
					 *            button: reference of the clicked button.
					 */
					onNewCompanySave : function(button) {
						var obj = this;
						var formWindow = obj.getCreatecompanyform();
						var form = obj.getCreatecompanyform().getForm();
						var grid = this.getCreatecompanygrid();
						var formMethod = null;
						var formValues = form.getValues();
						delete formValues.customFieldDatas;
						delete formValues.serviceFromAddressId;
						// delete formValues.academyLocationId;
						var isEdit = false;
						if (formValues.academyLocationId !== "" && formValues.academyLocationId !== null && formValues.academyLocationId !== undefined) {
							formMethod = 'POST';
							isEdit = true;
						} else {
							formMethod = 'POST';
							
						}

						var verifyAddress = form.getRecord();
						if (verifyAddress == undefined)
						// form.getRecord().getData().addressId;
						{
							try {

//								if (!isNullOrEmpty(form.getCode())) {
									Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'),'x-mask-loading');
									//Ext.Ajax.request({
									//	method : 'POST',
									//	url : SERVERURL.VEHICLE_ADDRESS_CREATE,
										//jsonData : form.getCode().data,
									//	success : function(response) {
									//		var jData = response.responseText;
											//var record = Ext.decode(jData);
											//formValues.addressId = record;
											//Ext.getBody().unmask(); // unmask
									  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'),'x-mask-loading');
											Ext.Ajax.request({
												type : 'rest',
												url : SERVERURL.PATH_PLACEMENT_COMPANY_CREATE,
												jsonData : formValues,
												method : formMethod,
												success : function() {
													
													if(!isNullOrEmpty(grid)){
														grid.getStore().load();
														grid.getSelectionModel().deselectAll(true);
													}
													
													Ext.getBody().unmask();
													this.saveAcadLocLogoUpload
													//	form.reset();
													showSuccessMessage(getPlacementTranslation('COMPANY_RECORD'),getCommonTranslation('RECORD_ADD_SUCCESS'));
													
													var contentpanel = obj.getContentpanel();
													//var companyform = Ext.widget('createcompanyform');
													
													
													var getcontroller = obj.getController('menu.CoreERPNavigationController');
													var createCompanyTabName = getMegaMenuTranslation('CREATE_COMPANY');
													var getCompanyTabName = getcontroller.getTab(createCompanyTabName);
													
													var tabName = getPlacementTranslation('ADD_COMPANY');
													if(isEdit){
														tabName = getCommonTranslation('Company Details');
													}
													
													var getTab = getcontroller.getTab(tabName);
													if (getTab != null) {
														contentpanel.remove(getTab, true);
													}
													
													if (getCompanyTabName != null) {
														contentPanel.setActiveTab(getCompanyTabName);
													}
												}
											});
										//}
									//});
								//}
							} catch (e) {
								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('EMPTY_ADDRESS_MSG'));
							}
						} else {
							if (isEdit) {
								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'),'x-mask-loading');
								try {
									if (!isNullOrEmpty(form.getCode())) {
										Ext.Ajax.request({
											method : 'POST',
											url : SERVERURL.VEHICLE_ADDRESS_UPDATE,
											// jsonData
											// :form.getRecord().getData().addressId;
											jsonData : form.getCode().data,
											success : function(response) {
												var jData = response.responseText;
												var record = Ext.decode(jData);
												formValues.addressId = record;
												Ext.getBody().unmask();
											}
										});
									}
								} catch (e) {
								}

								Ext.Ajax.request({
									type : 'rest',
									url : SERVERURL.PATH_PLACEMENT_COMPANY_UPDATE,
									jsonData : formValues,
									method : formMethod,
									success : function() {
										if(!isNullOrEmpty(grid)){
											grid.getStore().load();
											grid.getSelectionModel().deselectAll(true);
										}
										
										Ext.getBody().unmask();
										this.saveAcadLocLogoUpload
										//	form.reset();
										
										showSuccessMessage(getPlacementTranslation('COMPANY_RECORD'),getCommonTranslation('RECORD_UPDATE_SUCCESS'));
										
										var contentpanel = obj.getContentpanel();
										//var companyform = Ext.widget('createcompanyform');
										var getcontroller = obj.getController('menu.CoreERPNavigationController');
										var createCompanyTabName = getMegaMenuTranslation('CREATE_COMPANY');
										var getCompanyTabName = getcontroller.getTab(createCompanyTabName);
										
										var tabName = getPlacementTranslation('ADD_COMPANY');
										if(isEdit){
											tabName = getCommonTranslation('Company Details');
										}
										
										var getTab = getcontroller.getTab(tabName);
										if (getTab != null) {
											contentpanel.remove(getTab, true);
										}
										
										if (getCompanyTabName != null) {
											contentPanel.setActiveTab(getCompanyTabName);
										}
										//grid.setIsEdit(false);
									}
								});
							} else {
								try {

									if (!isNullOrEmpty(form.getCode())) {
										Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'),'x-mask-loading');

										Ext.Ajax.request({
											method : 'POST',
											url : SERVERURL.VEHICLE_ADDRESS_UPDATE,
											// jsonData
											// :form.getRecord().getData().addressId;
											jsonData : form.getCode().data,
											success : function(response) {
												var jData = response.responseText;
												var record = Ext.decode(jData);
												formValues.addressId = record;
												//Ext.getBody().unmask(); // unmask

												Ext.Ajax.request({
													type : 'rest',
													url : SERVERURL.PATH_PLACEMENT_COMPANY_CREATE,
													jsonData : formValues,
													method : formMethod,
													success : function() {
														
														if(!isNullOrEmpty(grid)){
															grid.getStore().load();
															grid.getSelectionModel().deselectAll(true);	
														}
														Ext.getBody().unmask();
														this.saveAcadLocLogoUpload
														//form.reset();

														showSuccessMessage(getPlacementTranslation('COMPANY_RECORD'),getCommonTranslation('RECORD_ADD_SUCCESS'));

														var contentpanel = obj.getContentpanel();
														//var companyform = Ext.widget('createcompanyform');
														var getcontroller = obj.getController('menu.CoreERPNavigationController');
														var createCompanyTabName = getMegaMenuTranslation('CREATE_COMPANY');
														var getCompanyTabName = getcontroller.getTab(createCompanyTabName);
														
														var tabName = getPlacementTranslation('ADD_COMPANY');
														if(isEdit){
															tabName = getCommonTranslation('Company Details');
														}
														
														var getTab = getcontroller.getTab(tabName);
														if (getTab != null) {
															contentpanel.remove(getTab, true);
														}
														
														if (getCompanyTabName != null) {
															contentPanel.setActiveTab(getCompanyTabName);
														}
													}
												});
											}
										});
									} else {
										showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'),getPersonModuleTranslation('UPLOAD_VALID_FILE'));
									}
								} catch (e) {
								}
							}
						}
						
					},
					saveAcadLocLogoUpload : function(obj) {
						var this$ = this;
						var academyLocationId = 1;
						var form = this$.getCreatecompanyform();
						var uploadForm = form.down('#logoUploadField');
						var photoFileImage = uploadForm
								.down('filefield#photoFileImage');
						var fileUploadPath = photoFileImage.getValue();
						var uploadUrl = SERVERURL.ACADEMY_LOCATION_LOGO_UPLOAD;

						if (!isNullOrEmpty(fileUploadPath)) {
							var extension = fileUploadPath.substring(
									fileUploadPath.lastIndexOf('.') + 1)
									.toLowerCase();
							if (extension == "gif" || extension == "png"
									|| extension == "bmp"
									|| extension == "jpeg"
									|| extension == "jpg") {

								form
										.getForm()
										.submit(
												{
													type : 'rest',
													url : uploadUrl,
													method : 'POST',
													params : {
														academyLocationId : academyLocationId
													},
													success : function(form,
															action) {
														showSuccessMessage(
																getPersonModuleTranslation('PHOTO_UPLOAD'),
																getPersonModuleTranslation('PHOTO_UPLOAD_SUCCESS'));
														/**
														 * Check if the selected
														 * AL is the same as the
														 * current AL, Only then
														 * call to change the
														 * image in the header.
														 */
														if (this$
																.getCurrentAcademyLocation() === parseInt(academyLocationId)) {
															this$
																	.setUploadedPhotoToHeader(academyk);
														}
													}
												});
							} else {
								photoFileImage.reset();
								showWarningMessage(
										getPersonModuleTranslation('PHOTO_UPLOAD'),
										getPersonModuleTranslation('UPLOAD_VALID_FILE'));
							}

						}
					},
					
					validatePhone:function(data){
						var isValid;
						if(!data.phoneNo && !data.cellNo){
							showWarningMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'),getCommonTranslation('ADD_PHONE_NO'));
							isValid= false;
						}
						else{
							isValid=true;
						}
						return isValid;
					},
					openCreateCompanyAddressFormTab: function(record) {
				    	var $this = this;
				    	var contentpanel = this.getContentpanel();
				    	var createcompanyaddressform = Ext.widget('createcompanyaddressform');
				    	var tabName = getCommonTranslation('ALA_ADDRESS');
				    	
				    	/** This is to remove tab from content panel and open same tab again */
				    	var getcontroller = this.getController('menu.CoreERPNavigationController');
				    	var getTab = getcontroller.getTab(tabName);
				    	if (getTab != null) {
				    	    contentPanel.remove(getTab, true);
				    	}

				    	openTab(contentpanel, tabName, createcompanyaddressform, CONSTANTS.MENU_COLOR_ONE);
				    },
				    onModifyClick: function(customAddressDisplayField, addressTypeALId) {
				        var $this = this;
				        /** Enable Form. */
				        var addressFormWindow = Ext.widget('addressFormWindow', {
				            itemId: 'createCompanyAddressWindow'
				        });
				        addressFormWindow.show();

				        var websiteURLItemId = addressFormWindow.down('#websiteURLItemId');
				        websiteURLItemId.setVisible(true);

				        var grid = $this.getCreatecompanygrid();
				        Ext.apply(grid, {
				            addressTypeALId: null,
				            setAddressTypeALId: function(code) {
				                grid.addressTypeALId = addressTypeALId;
				            },
				            getAddressTypeALId: function() {
				                return grid.addressTypeALId;
				            }
				        });
				        grid.setAddressTypeALId(addressTypeALId);

				        var data = customAddressDisplayField.getModel();
				        var addressfieldsform = $this.getAddressfieldsform();
				        $this.setAddressFormData(data, addressfieldsform);
				        
				        var form = this.getAddressfieldsform();
				    	var countryCodeField = form.down("#cellCountryCode");
				    	var mobileField = form.down("#cellNo");
				    	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, null);
				    	var longitude = form.down('#longitude');
				    	var latitudeItemId = form.down('#latitudeItemId');
				    	var geographicalAreaContainer = form.down('#geographicalAreaContainer');
			        	
			        	
				    	Ext.Ajax.request({
			        		url: SERVERURL.COMMON_FORM_FIELD_INFO,
			        		method: 'GET',
			        		async: false,
			        		params: {
			        			screenName: 'addressformwindow',
			        			academyLocationId:this.getCurrentAcademyLocation(),
			        			languageCode:'en'
			        		},
			        		success: function(response) {
			        			var response = Ext.decode(response.responseText);
			        			if( Object.keys(response).length > 0 ){
			        				var records=response.addressformwindow;
			        				for(i in records){
			        					if(records[i].formFieldInputType=='fieldcontainer' && records[i].formFieldId=='geographicalAreaContainer'){
			                                 geographicalAreaContainer.setFieldLabel(records[i].formFieldLabel);
			        				         geographicalAreaContainer.setVisible(records[i].isVisible);
			        						if(records[i].isMandatory == true){
	     										geographicalAreaContainer.labelSeparator = '';
	     										geographicalAreaContainer.setFieldLabel(records[i].formFieldLabel+'<span class="required" style="color:red"> *</span>');
	     										geographicalAreaContainer.allowBlank=false;
	     									}
			     								
			     							}
			        					
			        					}
			        					
			        					}
			        			}
			        		
				    	
			        	});
				   
				        
				    },

				    setAddressFormData: function(data, addressfieldsform) {
				        var form = addressfieldsform.getForm();
				        form.reset();
				        var $this = this;
				        if (data) {
				        	setTimeout(function(){
				        		form.setValues(data);
				        		$this.setIdFromNestedObject(data, "addressType");
				        		$this.setIdFromNestedObject(data, "country");
				        		$this.setIdFromNestedObject(data, "parentCountryRegion");
				        		$this.setIdFromNestedObject(data, "countryRegion");
				        		$this.setIdFromNestedObject(data, "city");

					            var countryId = data["country"];
					            var countryRegionId = data["parentCountryRegion"];
					            var pinCodeId = data["pincodeNew"];
					            var cityId = data["city"];
					            if (countryId) {
					            	 var countryComboBox = addressfieldsform.down('#countryId');
								        var parentCountryRegionField = addressfieldsform.down('#parentCountryRegionId');
								        var parentCountryRegionField = addressfieldsform.down('#parentCountryRegionId');
								        var cityComboBox = addressfieldsform.down('#cityId');
								        parentCountryRegionField.setDisabled(true);
								        if (!countryComboBox.store.items) {
								            countryComboBox.store.load({
								                callback: function(records, operation, success) {
								                    if (success) {
								                        if (countryComboBox && countryId){
								                        	 countryComboBox.setValue(countryId);
								                        }
								                        if(countryId>0){
								                        	parentCountryRegionField.setDisabled(false);
						   									  var parentCountryRegionFieldStore = parentCountryRegionField.getStore();
						   									parentCountryRegionFieldStore.getProxy().extraParams = {
						   										  id: countryId
						   									  };
						   									parentCountryRegionFieldStore.load({
						   										  callback: function(records, operation, success) {
						   											for(var i in records){
						   												if(records[i].data.id ==countryRegionId){
						   													parentCountryRegionField.setValue(records[i].data.id);
						   													parentCountryRegionField.setDisabled(false);
						   												}
						   											}
						   											if(countryRegionId>0){
						   												cityComboBox.setDisabled(false);
									   									  var cityComboBoxStore = cityComboBox.getStore();
									   									cityComboBoxStore.getProxy().extraParams = {
									   										  id: countryRegionId
									   									  };
									   									cityComboBoxStore.load({
									   									 callback: function(records, operation, success) {
									   										for(var i in records){
								   												if(records[i].data.id ==cityId){
								   													cityComboBox.setValue(records[i].data.id);
								   													cityComboBox.setDisabled(false);
								   												}
								   											} 
									   									 }
									   									})
						   											}
						   											
						   										  }
						   									  });
								                        }
								                           
								                    }
								                }
								            });
								        }
								        $this.setPincodeDropDown(pinCodeId,data["city"],addressfieldsform);
					            }
		         			},300);
				        }

				    },
				    setCityropDown: function(countryId, cityId, addressfieldsform) {
				        var store = this.getStore('organization.CityByCountryRegion');
				        store.getProxy().extraParams = {
				            id: countryId
				        };
				        store.load({
				            callback: function(records, operation, success) {
				                if (success) {
				                    var cityComboBox = addressfieldsform.down('#cityId');
				                    if (cityComboBox && cityId)
				                        cityComboBox.setValue(cityId);
				                }
				            }
				        });
				    },
				    setPincodeDropDown: function(pincodeId,cityId, addressdetailsform) {
				    	var pincodeComboBox = addressdetailsform.down('#pincodeNewId');
				    	pincodeComboBox.getStore().getProxy().extraParams = {
				            id: cityId
				        };
				    	pincodeComboBox.getStore().load({
				            callback: function(records, operation, success) {
				                if (success) {
				                    if(pincodeComboBox && pincodeId)
				                    	pincodeComboBox.setValue(pincodeId.id);
				                }
				            }
				        });
				    },
				    setRegion1DropDown: function(countryId, regionId, addressfieldsform) {
				        var countryRegionStore = this.getStore('organization.CountryRegionStore');
				        countryRegionStore.getProxy().extraParams = {
				            cid: countryId
				        };
				        countryRegionStore.load({
				            callback: function(records, operation, success) {
				                if (success) {
				                    var genericField1ComboBox = addressfieldsform.down('#genericFieldId1');
				                    if (genericField1ComboBox && regionId)
				                        genericField1ComboBox.setValue(regionId);
				                }
				            }
				        });
				    },
				    setRegion2DropDown: function(countryRegion1, regionId, addressfieldsform) {
				        var countryRegionStore = this.getStore('organization.CountryRegionStore1');
				        countryRegionStore.getProxy().extraParams = {
				            pid: countryRegion1
				        };
				        countryRegionStore.load({
				            callback: function(records, operation, success) {
				                if (success) {
				                    /*var genericField1ComboBox = createcompanyaddressform.down('#genericFieldId2');
				                    if(genericField1ComboBox && regionId)
				                    	genericField1ComboBox.setValue(regionId);*/
				                }
				            }
				        });
				    },
				    saveAcademyLocationAddress: function(model) {
				        var $this = this;
				        var form = $this.getAddressfieldsform().getForm();
				        if (form.isValid()) {
				            var values = form.getValues();
//				            if ($this.validatePhone(values)) {
				                var address = new Academia.model.organization.Address();
				                var submitUrl;
				                var successMessage;
				                var id = form.findField('id').getSubmitValue();
				                form.updateRecord(address);
				                address.set('country', this.getIdValueJson(values.country));
				                address.set('parentCountryRegion', $this.getIdValueJson(values.parentCountryRegion));
				                address.set('countryRegion', $this.getIdValueJson(values.countryRegion));
				                address.set('city', $this.getIdValueJson(values.city));
				                address.set('pincode', values.pincode);
				                address.set('latitude', values.latitude);
				                address.set('longitude', values.longitude);
				                address.set('faxNumber', values.faxNumber);
				                address.set('customData',values.customData);
				                
				                var grid = $this.getCreatecompanygrid();
				                var companyId = grid.getCompanyId();
				                var addressTypeALId = grid.getAddressTypeALId();
				                address.set('addressType', $this.getIdValueJson(addressTypeALId));

				                var companyAddressModel = new Academia.model.organization.academylocations.CreateCompanyAddressModel;
				                companyAddressModel.set("address", address.data);
				                companyAddressModel.set("academyLocationId", companyId);

				                var formData = Ext.encode(companyAddressModel.data);
				                if (id == null || id == "") {
				                    submitUrl = SERVERURL.ALA_ACADEMY_LOCATION_ADDRESS_CREATE;
				                    successMessage = getCommonTranslation('ADDRESS_ADD_SUCCESS');
				                } else {
				                    submitUrl = SERVERURL.ALA_ACADEMY_LOCATION_ADDRESS_UPDATE;
				                    successMessage = getCommonTranslation('ADDRESS_UPDATE_SUCCESS');
				                }
				                Ext.Ajax.request({
				                    type: 'rest',
				                    url: submitUrl,
				                    jsonData: formData,
				                    method: 'POST',
				                    success: function(form, action) {
				                        showSuccessMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'), successMessage);
				                        $this.getCrateCompanyAddress();
				                        $this.resetForm(model);
				                    }
				                });
//				            }
				        }
				    },
				    getCrateCompanyAddress: function() {
				        var $this = this;
				        var currentAddress = false,
				            correspondanceAddress = false,
				            permanentAddress = false,
				            officeAddress = false;

				        var createcompanyaddressform = $this.getCreatecompanyaddressform();

				        var grid = $this.getCreatecompanygrid();
				        var record = grid.getSelectionModel().getSelection()[0];
				        var companyId = record.data.academyLocationId;

				        Ext.apply(grid, {
				            companyId: null,
				            setCompanyId: function(code) {
				                grid.companyId = companyId;
				            },
				            getCompanyId: function() {
				                return grid.companyId;
				            }
				        });
				        grid.setCompanyId(companyId);

				        if (!isNullOrEmpty(companyId)) {
				            Ext.Ajax.request({
				                type: 'rest',
				                url: SERVERURL.ALA_FIND_ALL_ADDRESS_BY_ACADEMY_LOCATION_ID,
				                params: {
				                	academyLocationId: companyId
				                },
				                method: 'GET',
				                success: function(responser, action) {
				                    var data = Ext.decode(responser.responseText);
				                    var addressDisplayField1 = createcompanyaddressform.down('displayfield#customAddressDisplayFieldALAF1');
				                    var addressDisplayField2 = createcompanyaddressform.down('displayfield#customAddressDisplayFieldALAF2');
				                    var addressDisplayField3 = createcompanyaddressform.down('displayfield#customAddressDisplayFieldALAF3');
				                    var addressDisplayField4 = createcompanyaddressform.down('displayfield#customAddressDisplayFieldALAF4');

				                    var AddressTpl = Ext.create('Ext.XTemplate',
				                        '<p><B>{addressText}</B></p>',
				                        '<tpl if=\'city != null\'>',
				                        '{city.value} , </tpl> {code}<br>',
				                        '<tpl if=\'countryRegion != null\'>',
				                        '{countryRegion.value}<br></tpl> ',
				                        '<tpl if=\'parentCountryRegion != null\'>',
				                        '{parentCountryRegion.value},</tpl> {country.value}<br>',
				                        '<tpl if=\'phoneNo != null\'>',
				                        getCommonTranslation('ADDRESS_PHONE_NUMBER') + ' ' + '{phoneCountryCode}-',
				                        '<tpl if=\'phoneAreaCode != null\'>',
				                        '{phoneAreaCode}-</tpl>',
				                        '{phoneNo}</tpl><br>',
				                        '<tpl if=\'cellNo != null\'>',
				                        getCommonTranslation('ADDRESS_MOBILE_NO') + ' ' + '{cellCountryCode}-{cellNo}</tpl><br>',
				                        '{primaryeEmailId}');

				                    Ext.each(data, function(obj) {
				                        if (obj['addressType']['id'] == 10) {
				                            currentAddress = true;
				                            addressDisplayField1.setValue(AddressTpl.applyTemplate(obj));
				                            addressDisplayField1.setModel(obj);
				                        } else if (obj['addressType']['id'] == 11) {
				                            correspondanceAddress = true;
				                            addressDisplayField2.setValue(AddressTpl.applyTemplate(obj));
				                            addressDisplayField2.setModel(obj);
				                        } else if (obj['addressType']['id'] == 12) {
				                            permanentAddress = true;
				                            addressDisplayField3.setValue(AddressTpl.applyTemplate(obj));
				                            addressDisplayField3.setModel(obj);
				                        } else if (obj['addressType']['id'] == 13) {
				                            officeAddress = true;
				                            addressDisplayField4.setValue(AddressTpl.applyTemplate(obj));
				                            addressDisplayField4.setModel(obj);
				                        }
				                    });
				                    var modifyAddress1 = createcompanyaddressform.down('button#createCompanymodifyAddressALAF1');
				                    var printAddress1 = createcompanyaddressform.down('button#createCompanyprintAddressALAF1');
				                    var modifyAddress2 = createcompanyaddressform.down('button#createCompanymodifyAddressALAF2');
				                    var printAddress2 = createcompanyaddressform.down('button#createCompanyprintAddressALAF2');
				                    var modifyAddress3 = createcompanyaddressform.down('button#createCompanymodifyAddressALAF3');
				                    var printAddress3 = createcompanyaddressform.down('button#createCompanyprintAddressALAF3');
				                    var modifyAddress4 = createcompanyaddressform.down('button#createCompanymodifyAddressALAF4');
				                    var printAddress4 = createcompanyaddressform.down('button#createCompanyprintAddressALAF4');

				                    var printallAddress = createcompanyaddressform.down("#createCompanyprintallAddressALAF");

				                    if (currentAddress) {
				                        modifyAddress1.setText(getCommonTranslation('MODIFY'));
				                        printAddress1.setVisible(true);
				                    } else {
				                        modifyAddress1.setText(getCommonTranslation('ADD_ADDRESS'));
				                        printAddress1.setVisible(false);
				                        var object = new Object();
				                        object.addressType = 10;
				                        addressDisplayField1.setModel(object);
				                    }
				                    if (correspondanceAddress) {
				                        modifyAddress2.setText(getCommonTranslation('MODIFY'));
				                        printAddress2.setVisible(true);
				                    } else {
				                        modifyAddress2.setText(getCommonTranslation('ADD_ADDRESS'));
				                        printAddress2.setVisible(false);
				                        var object = new Object();
				                        object.addressType = 11;
				                        addressDisplayField2.setModel(object);
				                    }

				                    if (permanentAddress) {
				                        modifyAddress3.setText(getCommonTranslation('MODIFY'));
				                        printAddress3.setVisible(true);
				                    } else {
				                        modifyAddress3.setText(getCommonTranslation('ADD_ADDRESS'));
				                        printAddress3.setVisible(false);
				                        var object = new Object();
				                        object.addressType = 12;
				                        addressDisplayField3.setModel(object);
				                    }

				                    if (officeAddress) {
				                        modifyAddress4.setText(getCommonTranslation('MODIFY'));
				                        printAddress4.setVisible(true);
				                    } else {
				                        modifyAddress4.setText(getCommonTranslation('ADD_ADDRESS'));
				                        printAddress4.setVisible(false);
				                        var object = new Object();
				                        object.addressType = 13;
				                        addressDisplayField4.setModel(object);
				                    }

				                    if (currentAddress && correspondanceAddress && permanentAddress && officeAddress) {
				                        printallAddress.setVisible(true);
				                    } else {
				                        printallAddress.setVisible(false);
				                    }
				                }
				            });
				        }
				    },
				    
				    addContact: function() {
				        var grid = this.getCreatecompanygrid();
				        if (grid.getSelectionModel().getCount() > 0) {
				            var records = grid.getSelectionModel().getSelection();
				            this.getPersoncantactdetailgrid().showContactPersonDetailsForm();
				            if (records != "" && records != null && records != undefined) {}
				        } else {
				            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a sponsor 							
				        }
				    },
				    cancelPlacementContactDetailsForm: function() {
				        this.getPlacementcontactpersondetailswindow().close();
				    },
				    loadcityParentRegionStore: function(combo, records, eOpts) {
				        var this$$ = this;
				        var id = records[0].data.id;
				        var comboref = this$$.getPlacementcontactpersondetailswindow().down("#cityId");
				        var parentcombo = this$$.getPlacementcontactpersondetailswindow().down("#parentCountryRegionId");
				        var store = comboref.getStore();
				        var parentStore = parentcombo.getStore();
				        store.getProxy().extraParams = {
                            id: id
                        };
                        store.reload();
                       
                      
                        parentStore.getProxy().extraParams = {
                            cid: id
                        };
                        parentStore.load();
                       
				        
				    },
				    SavePlacemenContactDetailsForm: function() {
				        var this$ = this;
				        var refAddContactForm = this$.getPlacemenContactPersonDetailsForm();
				     //   var form = refAddContactForm.down('form');
				        var formData = refAddContactForm.getValues();
				        var address = new Academia.model.organization.Address(formData);
				        var grid = this$.getPersoncantactdetailgrid();
				        var sponsorGrid = this$.getCreatecompanygrid();
				        var record = sponsorGrid.getSelectionModel().getSelection()[0];
				        var id = record.raw.academyLocationId;
				        var finalData = new Object();
				   //   vare academyLocationId= this.getIdValueJson(id)
				        if (!isNullOrEmpty(id)) finalData.academyLocation = this.getIdValueJson(id);

				        finalData.address = address.data;
				        finalData.id = formData.contactPersonId;
				        finalData.contactName = formData.contactName;
				        finalData.designation = formData.designation;
				        finalData.designation = formData.designation;
				        if (isNullOrEmpty(address.countryRegion)) delete finalData.address.countryRegion;
				        delete finalData.address.customData;
				        delete finalData.address.addressType;
				        delete finalData.address.pincodeNew;
				        
				        address.set('parentCountryRegion', this$.getIdValueJson(finalData.address.parentCountryRegion));
			            address.set('countryRegion', this$.getIdValueJson(finalData.address.countryRegion));
			            address.set('city', this$.getIdValueJson(finalData.address.city));
				        if (this$.validatePhone(formData)) {

				            var submitUrl, isUpdate = false;
				            var addContactField = refAddContactForm.down('#AddContactId');

				            if (addContactField.getSubmitValue() == null || addContactField.getSubmitValue() == "" || addContactField.getSubmitValue() === undefined) {
				                submitUrl = SERVERURL.PATH_ACADEMY_LOCATION_CONTACT_SAVE, //URL-rest/sponsorContact
				                isUpdate = false;
				            } else {
				                submitUrl = SERVERURL.PATH_ACADEMY_LOCATION_CONTACT_UPDATE, //URL-rest/sponsorContact
				                isUpdate = true;
				            };

				            var methodName = '';
				            if (isUpdate == true) {
				                methodName = 'POST';
				            } else {
				                methodName = 'POST';
				            }
				            this$.applyWindowMask(); 
				           
				            Ext.Ajax.request({
				                type: 'rest',
				                url: submitUrl,
				                jsonData: finalData,
				                method: methodName,

				                success: function(form, action) {
				                	 this$.hideWindowMask();
				                    this$.cancelPlacementContactDetailsForm();
				                    grid.getStore().reload();
				                    grid.getSelectionModel().deselectAll(true);

				                    if (isUpdate) {
				                        showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));												
				                    } else {
				                        showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_ADD_SUCCESS'));												
				                    }
				                }
				            });
				        }
				    },
				    disableMoreActionPivileges: function(gridReference,permissionsMap) {
				       	
				       	var associatedAcadLocationIds = new Array();
				   		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
				   		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
				       	buttonsToolBar = gridReference.query('toolbar')[0];
				       	var splitbuttons = buttonsToolBar.query('splitbutton')[0];
				       	Ext.each(permissionList, function(privilege) {
				       		if (privilege === 'ADD_ADDRESS') {
				           		var button = buttonsToolBar.query('#addAddressItemId')[0];
				           		if(!isNullOrEmpty(button)){
				           			button.setVisible(true);
				           		}        		
				           	}
				       	});
				       },
				       
				       loadContactCombo: function(combo) {
				           var store = combo.getStore();
				           store.load();
				       },
				       


				       editPersonContact: function(isView) {
				           var this$$ = this;
				           var grid = this$$.getPersoncantactdetailgrid();

				           if (grid.getSelectionModel().getCount() > 0) {
				               var record = grid.getSelectionModel().getSelection()[0];
				               var id = record.data.id;
				               this$$.getPersoncantactdetailgrid().showContactPersonDetailsForm();
				               var addContactFormVar = this$$.getPlacementcontactpersondetailswindow();
				               
				               
				               if (isView) {
				                   var contactPersonDetailsWindow = this$$.getPlacementcontactpersondetailswindow();
				                   contactPersonDetailsWindow.down('#btnSaveContactForm').setVisible(false);
				                   var form=  contactPersonDetailsWindow.down("form");
				                   toggleReadOnlyFormItems(form.getForm(), true);
				               }

				               var win=   this$$.getPlacementcontactpersondetailswindow();
						          var form=  win.down("form");
						           form.getForm().setValues({
						                   contactPersonId: id
						               });
				               Ext.Ajax.request({
				                   type: 'rest',
				                   url: SERVERURL.PATH_ACADEMY_LOCATION_CONTACT_FIND_BY_ID +"?id=" +id,
				                   method: 'GET',
				                   success: function(res, action) {
				                       var data = Ext.decode(res.responseText);
				                       var form = this$$.getPlacemenContactPersonDetailsForm().getForm();
				                    // var form=  win.getForm();
				                       var countryRef = this$$.getPlacemenContactPersonDetailsForm().down('#countryId');
				                       var cityRef = this$$.getPlacemenContactPersonDetailsForm().down('#cityId');
				                       var parentRegionRef = this$$.getPlacemenContactPersonDetailsForm().down('#parentCountryRegionId');
				                       var countryValue = data.address.country.id;
				                       var cityValue = data.address.city.id;
				                       var parentId = data.address.parentCountryRegion.id;
				                       var countryRegionId = '';
				                       
				                       if (!isNullOrEmpty(data.address.countryRegion)) countryRegionId = data.address.countryRegion.id;

				                       countryRef.setValue(countryValue);
				                       this$$.loadComboValue(cityRef, cityValue, new Object({
				                           id: parentId
				                       }));
				                       this$$.loadComboValue(parentRegionRef, parentId, new Object({
				                           cid: countryValue
				                       }));
				                     /*  this$$.loadComboValue(countryRegionRef, countryRegionId, new Object({
				                           pid: parentId
				                       }));*/
				                       form.setValues(data);
				                       form.setValues(data.address);
				                   }
				               });
				           } else {
				               showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
				           }
				       },

				       deletPlacmentContact: function() {
				           var grid = this.getPersoncantactdetailgrid();

				           if (grid.getSelectionModel().getCount() > 0) {
				               showConfirmMessage(getCommonTranslation('STEP2_CONTACT_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
				                   if (btn == 'yes') {
				                       var records = grid.getSelectionModel().getSelection()[0];

				                       var id = records.data.id;

				                       Ext.Ajax.request({
				                           type: 'rest',
				                           method: 'DELETE',
				                           url: SERVERURL.PATH_ACADEMY_LOCATION_CONTACT_DELETE +"?id=" +id,
				                           headers: {
				                               'Content-Type': 'application/json'
				                           },
				                           success: function(form, action) {
				                               grid.getStore().reload();
				                               showSuccessMessage(getCommonTranslation('STEP2_CONTACT_DETAILS'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
				                           }
				                       });
				                   }
				               });
				           } else {
				               showWarningMessage(getCommonTranslation('STEP2_CONTACT_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
				           }
				       },
				       loadComboValue: function(combo, value, param) {
				           var store = combo.getStore();
				           if (!store.items) {
				               store.load({
				                   params: param,
				                   callback: function(records, operation, success) {
				                       if (success) {
				                           combo.setValue(value);
				                       }
				                   }
				               });
				           }
				       },

				});