Ext.define('Academia.controller.placement.placementMaster.PlacementMaster', {
    extend: 'Academia.controller.base.BaseController',
    stores: ['placement.placementMaster.PlacementMasterStore'],
    views: ['placement.placementMaster.PlacementMasterScreen', 'placement.placementMaster.PlacementParentFormWindow',
            'placement.placementMaster.PlacementChildFormWindow'],

    alias: "widget.placementMasterController",

    refs: [{
        ref: 'standardMaster',
        selector: 'standardMaster'
    },{
        ref: 'placementmasterscreen',
        selector: 'placementmasterscreen'
    }, {
        ref: 'parentFormWindow',
        selector: 'placementParentFormWindow'
    }, {
        ref: 'childFormWindow',
        selector: 'placementChildFormWindow'
    }, {
        ref: 'stdMasterParentGrid',
        selector: 'standardMaster #stdMasterParentGrid'
    }, {
        ref: 'stdMasterChildGrid',
        selector: 'standardMaster #stdMasterChildGrid'
    }, {
        ref: 'stdMasterParentForm',
        selector: 'placementParentFormWindow form[itemId=stdMasterParentForm]'
    }, {
        ref: 'stdMasterChildForm',
        selector: 'placementChildFormWindow form[itemId=stdMasterChildForm]'
    }],
    config: {
    	STANDARD_MASTER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STANDARD_MASTER_PRIVILEGES')
    },
    init: function(application) {
        this.control({

            'placementmasterscreen #stdMasterParentGrid  button[itemId=btnAdd]': {
                click: function() {
                    this.showParentWindowPlacement("ADD");
                }
            },
            'placementmasterscreen': {
            	afterrender : function(obj,rec) {
            		var $this = this;
            		var filterForm=$this.getPlacementmasterscreen();
            		var selectionStageField=filterForm.down('#standardMasterComboField');
            		var store = selectionStageField.getStore();
            		store.getProxy().extraParams = {
            			masterName: 'place'
            		};
            		selectionStageField.setDisabled(false);
            		 store.load({
            	           scope:this,
            	              callback: function(records,option,success){
            	                     for(var i=0; i< records.length; i++){
            	                             var record = records[i];
            	                             if(isNullOrEmpty(record.get("code"))){
            	                               record.set("code",getTranslation('OTHER'));
            	                             }else{
            	                               record.set("code",getTranslation(record.get('code')));
            	                             }
            	                             record.set("value",getTranslation(record.get('value')));
            	                      }
            	                      store.commitChanges();
            	                      //combo.bindStore(store);
            	           }
            	        });
                },
            },
            'placementmasterscreen combobox[itemId=standardMasterComboField]': {
            	/*boxready : function(combo) {
                	var filterCodeValue = this.getfilterCodeValue(combo.up('standardMaster'));
                	var param={filterCode : filterCodeValue};
                	this.loadStandardMasterStore(combo,param);
                },
                
                change: function(combo,nV) {
                	var filterCodeValue = this.getfilterCodeValue();
                	var param={filterCode : filterCodeValue};
                
                	if(nV!=null && nV != undefined && nV.length >= 3){
                		param.masterName='placement';
                	}
                	this.loadStandardMasterStore(combo,param);
                }*/
            	/*  change:function(obj,rec){
    				   var jobId=rec[0].data.id;  
    				   var filterForm=obj.up('form');
    				   var selectionStageField=filterForm.down('#standardMasterComboField');
    				   var store = selectionStageField.getStore();
    				   store.getProxy().extraParams = {
    					   masterName: 'place'
    				   };
    				   selectionStageField.setDisabled(false);
    				   store.load();
    			   }*/
            },
            'placementmasterscreen #stdMasterParentGrid  button[itemId=btnEdit]': {
                click: function() {
                    this.parentEditBtnClickPlacement();
                }
            },
            'placementmasterscreen #stdMasterParentGrid  button[itemId=btnView]': {
                click: function() {
                    this.viewParentFormWindowPlacement();
                }
            },
            'placementmasterscreen #stdMasterParentGrid  button[itemId=btnDelete]': {
                click: function() {
                	 var pGrid = this.getStdMasterParentGrid();
                	 var parentTableId = this.getParentTableId();
                	 this.deleteButtonClickPlacement(pGrid,parentTableId);
                }
            },

            'placementmasterscreen #stdMasterChildGrid  button[itemId=btnAdd]': {
                click: function() {
                    this.showChildWindowPlacement("ADD");
                }
            },
            'placementmasterscreen #stdMasterChildGrid  button[itemId=btnEdit]': {
                click: function() {
                    this.childEditBtnClickPlacement();
                }
            },
            'placementmasterscreen #stdMasterChildGrid  button[itemId=btnView]': {
                click: function() {
                    this.viewChildFormWindowPlacement();
                }
            },
            'placementmasterscreen #stdMasterChildGrid  button[itemId=btnDelete]': {
                click: function() {
                    var grid = this.getStdMasterChildGrid();
                    var childTableId = this.getChildTableId();
                    this.deleteButtonClickPlacement(grid,childTableId);
                }
            },
            /*'standardMaster #stdMasterParentGrid':{
            	render: function(grid) {
                    this.doAccessControlValidation(grid, this.getSTANDARD_MASTER_PERMISSIONS());
                }
            },*/
            
            'placementmasterscreen > combo': {
                'select': function(combo, records) {
                  var parentResponseData = null,this$=this;
                  var parentTableId = null;
                  var childTableId = null, childResponseData = null;

                    parentTableId = records[0].get("id");
                    
                 	this.setParentTableId(parentTableId);

                    // Make parent HBOX visible 
                    this$.getStdMasterParentGrid().setVisible(true);

                    //Get grid data 
                    parentResponseData = this$.getGridMetaData(parentTableId);
                    this$.setParentResponseData(parentResponseData);

                    //Reconfigure parentHBOX
                    this$.reconfigureParentGrid(parentTableId, parentResponseData);

                    //Check for parent child relation
                    if (parentResponseData.whetherParent) {
                        //Make child HBOX visible
                        this$.getStdMasterChildGrid().setVisible(true);

                        childTableId = parentResponseData.childMaster;
                        this.setChildTableId(childTableId);
                        childResponseData = this$.getGridMetaData(childTableId);
                        
                        this.setChildResponseData(childResponseData);
                        this$.reconfigureChildGrid(childTableId, parentTableId, childResponseData);
                    } else {
                        this$.getStdMasterChildGrid().setVisible(false);
                    }
                },
            afterrender : function(combo){
				 var $this = this;
				 var Grid = this.getStdMasterParentGrid();
			        var structure = $this.getPlacementmasterscreen();
				 structure.body.on('scroll', function(e, target) {
	   				  var pcstructure = structure.down(Grid);
	   				  var academyLocationId = $this.getCurrentAcademyLocation();
	   				  var grid = null;
	   				  
	   				  if(!pcstructure.isHidden()){
	   					  grid = pcstructure;
	   				  }
	   				  $this.getMultipleGridHeaderFreeze(grid,structure,true);
					 });
			 }
            },

            //Listener for Parent master grid
            'placementmasterscreen #stdMasterParentGrid ': {
                //On row select
                select: function(model, records) {
                    var parentRecordId = records.get("id");
                    // If parent child relation load child grid
                    
                    this.setParentRecordId(parentRecordId);
                    var parentResponseData=this.getParentResponseData();
                    if (parentResponseData.whetherParent) {
                        var grid = this.getStdMasterChildGrid();
                    	var parentTableId=this.getParentTableId();
                    	
                        this.updateChildGrid(grid, parentTableId, parentRecordId);
                    }
                }
            },

            //Listener for Child master grid
            'placementmasterscreen #stdMaaaaasterChildGrid': {
                reconfigure: function(grid, eOpts) {
                    var pGrid = this.getStdMasterParentGrid();
                    var store = pGrid.getStore();
                    if (store.isLoading()) {
                        store.on("load", function() {
                            pGrid.getSelectionModel().select(0);
                        });
                    } else {
                        pGrid.getSelectionModel().select(0);
                    }
                    //this.doAccessControlValidation(grid, this.getSTANDARD_MASTER_PERMISSIONS());
                }
            },
            // Master Form submit button click  
            'placementParentFormWindow button[action=Submit]': {
                click: function(model, records) {
                    this.saveUpdateMaterDataPlacement();
                }
            },
            // Child Form submit button click  
            'placementChildFormWindow button[action=Submit]': {
                click: function(model, records) {
                    var parentRecordId=this.getParentRecordId();
                    this.saveUpdateChildMaterDataPlacement( parentRecordId);
                }
            },

            'placementParentFormWindow button[action=Cancle]': {
                click: function(model, records) {
                    this.closeParentWindow();
                }
            },
            'placementChildFormWindow button[action=Cancle]': {
                click: function(model, records) {
                    this.closeChildWindow();
                }
            }
        });
    },
    
    loadStandardMasterStore : function(combo,param){

        var store = Ext.create('Academia.store.placement.placementMaster.PlacementMasterStore');
        store.load({
        	params:param,
           scope:this,
              callback: function(records,option,success){
                     for(var i=0; i< records.length; i++){
                             var record = records[i];
                             if(isNullOrEmpty(record.get("code"))){
                               record.set("code",getTranslation('OTHER'));
                             }else{
                               record.set("code",getTranslation(record.get('code')));
                             }
                             record.set("value",getTranslation(record.get('value')));
                      }
                      store.commitChanges();
                      combo.bindStore(store);
           }
        });

    },
    
    closeParentWindow:function(){
    	this.getParentFormWindow().close();
    },
    closeChildWindow: function(){
    	this.getChildFormWindow().close();
    },

    showParentWindowPlacement: function(mode) {
    	 var responseData=this.getParentResponseData();
        var parentFormWindow = this.getParentFormWindow();
        if (!parentFormWindow) {
            this.reconfigureParentForm(responseData,mode);
            parentFormWindow = this.getParentFormWindow();
        }
        parentFormWindow.show();
    },

    showChildWindowPlacement: function(mode) {
        var childFormWindow = this.getChildFormWindow();
        if (!childFormWindow) {
            this.reconfigureChildForm(mode);
            childFormWindow = this.getChildFormWindow();
        }
        childFormWindow.show();
    },


    parentEditBtnClickPlacement: function() {
    	
        var grid = this.getStdMasterParentGrid();

        if (grid.getSelectionModel().getCount() > 0) {
            this.showParentWindowPlacement("EDIT");
            var form = this.getStdMasterParentForm();
            var records = grid.getSelectionModel().getSelection();
            if (records != undefined && records != "" && records != null) {
                form.loadRecord(records[0]);
            }
        } else {
        	showWarningMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    childEditBtnClickPlacement: function() {

        var grid = this.getStdMasterChildGrid();

        if (grid.getSelectionModel().getCount() > 0) {
            this.showChildWindowPlacement("EDIT");
            var form = this.getStdMasterChildForm();
            var records = grid.getSelectionModel().getSelection();
            if (records != undefined && records != "" && records != null) {
                form.loadRecord(records[0]);
            }
        } else {
        	showWarningMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    viewParentFormWindowPlacement:function(){
    	this.parentEditBtnClickPlacement();
    	 var form = this.getStdMasterParentForm();
    	 if(form){
    		form.down('#formSubmitButtonId').setVisible(false);
    		form=form.getForm();
    		toggleReadOnlyFormItems(form,true);
    	 }
    },
    viewChildFormWindowPlacement:function(){
    	this.childEditBtnClickPlacement();
    	 var form = this.getStdMasterChildForm();
    	 if(form){
    		form.down('#formSubmitButtonId').setVisible(false);
    		form=form.getForm();
    		toggleReadOnlyFormItems(form,true);
    	 }
    },
    
    deleteButtonClickPlacement: function(grid,tableId) {
         if (grid.getSelectionModel().getCount() > 0) {
             var records = grid.getSelectionModel().getSelection()[0];
             if (records != undefined && records != "" && records != null) {
            	 this.deleteMasterData(grid, tableId, records.index);
             }
         } else {
        	 showWarningMessage(getPlacementTranslation('PLACEMENT_MASTER_COMBO'), getCommonTranslation('PLEASE_SELECT_RECORD'));
         }
    },
    /**
     * Dynamically create master grid and form from table id and table meta data.
     * 
     * @param parentTableId
     *             Unique identifier for the standard master.
     * @param responseData
     *             Meta data for columns and store model. 
     */
    reconfigureParentGrid: function(parentTableId, responseData) {

        var this$ = this;
        var columnModel = [];
        var columnHeader = [];
        var columnMetaData = responseData.standardMasterItems;
        var parentGrid = this.getStdMasterParentGrid();

        // Load header for grid and model fields.
        this$.loadColumnModelAndHeader(columnModel, columnHeader, columnMetaData);

        // Add delete action column in grid.
//        columnHeader.push(this$.getDeleteActionColumn(parentGrid, parentTableId));\
        this$.createGrid(parentGrid, columnModel, columnHeader, parentTableId);
    },

    reconfigureParentForm: function(responseData,mode) {
        var columnMetaData = responseData.standardMasterItems;
        var form = this.getStdMasterParentForm();
        if (!form) {
            Ext.widget('placementParentFormWindow');
            form = this.getStdMasterParentForm();
        }
        this.createForm(form, columnMetaData,mode);
    },


    /**
     * Dynamically create child master grid and form from table id and table meta data.
     * 
     * @param childTableId
     *             Unique identifier for the standard master.
     * @param parentTableId
     *             Unique identifier for the parent standard master.
     * @param responseData
     *             Meta data for columns and store model. 
     */
    reconfigureChildGrid: function(childTableId, parentTableId, responseData) {
        var this$ = this;
        var columnModel = [];
        var columnHeader = [];
        var columnMetaData = responseData.standardMasterItems;
        var grid = this$.getStdMasterChildGrid();

        //Load header for grid and model fields.
        this$.loadColumnModelAndHeader(columnModel, columnHeader, columnMetaData);

        // Add delete action column in grid.
//        columnHeader.push(this$.getDeleteActionColumn(grid, childTableId));
        this$.createChildGrid(grid, columnModel, columnHeader, parentTableId);
    },

    reconfigureChildForm: function(mode) {
    	var responseData=this.getChildResponseData();
        var columnMetaData = responseData.standardMasterItems;
        var form = this.getStdMasterChildForm();

        if (!form) {
            Ext.widget('placementChildFormWindow');
            form = this.getStdMasterChildForm();
        }
        this.createForm(form, columnMetaData,mode); 
    },


    /**
     *  This method loads header for grid and model fields of store.
     * 
     * @param columnModel
     *             Array in which model for store will be added.
     * @param columnHeader
     *             Array in which header for grid will be added.
     * @param columnMetaData
     *             Meta data for columns and store model. 
     */
    loadColumnModelAndHeader: function(columnModel, columnHeader, columnMetaData) {
        var this$ = this;
        Ext.each(columnMetaData, function(obj) {
            var fieldName = obj.dbFieldName;
            if (obj.whetherForeignKey) {
                fieldName = obj.dbFieldName + "." + obj.fkDisplayField;
                columnModel.push({
                    name: obj.dbFieldName + ".id"
                });
            }
            if (obj.type == 'Date') {
                columnModel.push({
                    name: fieldName,
                    type: obj.type,
                    dateFormat: CONSTANTS.DATE_FORMAT
                });
                // add the records to the array
                columnHeader.push({
                    header: this$.getFieldLabel(obj.fieldLabel),
                    flex: 1,
                    //maxWidth:150,
                    dataIndex: fieldName,
                    renderer: function(date) {
                        return dateRender(date);
                    }
                });
            } else {
                columnModel.push({
                    name: fieldName,
                    type: obj.type
                });
                // add the records to the array
                columnHeader.push({
                    header: this$.getFieldLabel(obj.fieldLabel),
                    flex: 1,
                    //maxWidth:150,
                    dataIndex: fieldName
                });
            }
        });
        
        columnModel.push({
            name: 'version'
        });
    },

    /**
     *  This method used to save or update master.
     *  Check for id, if is is null call save else call update
     * 
     * @param parentTableId
     *              Unique identifier for the standard master.
     */
    saveUpdateMaterDataPlacement: function() {
    	var this$ = this;
        var form = this.getStdMasterParentForm();
        var stdMasterParentGrid = this.getStdMasterParentGrid();
        var submitUrl;
        var successMessge,	parentTableId=this.getParentTableId();;

        // Get form data in string form.
        var values = form.getValues();
        
        this.deleteEmptyFields(values);
        var formData = Ext.encode(values);
        // Check for id, if is is null call save else call update.
        if (form.getForm().findField('id').getSubmitValue() == null || form.getForm().findField('id').getSubmitValue() == "") {
            submitUrl = SERVERURL.STANDARD_MASTERS_SAVE;
            successMessge =  getCommonTranslation('RECORD_ADD_SUCCESS');
        } else {
            submitUrl = SERVERURL.STANDARD_MASTERS_UPDATE;
            successMessge = getCommonTranslation('RECORD_UPDATE_SUCCESS');
        }

        this$.applyWindowMask();

        Ext.Ajax.request({
            type: 'rest',
            method: 'POST',
            url: submitUrl,
            params: {
                formData: formData,
                parentTableId: parentTableId
            },
            headers: {
                'Content-Type': 'application/json'
            },

            success: function(form, action) {
            	this$.hideWindowMask();
            	this$.closeParentWindow();
            	stdMasterParentGrid.getSelectionModel().deselectAll(true);
                stdMasterParentGrid.getStore().reload();
                showSuccessMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'), successMessge);
            },
            failure: function(form, action) {
            	this$.hideWindowMask();
            }
        });

    },

    /**
     *  This method used to save or update child master.
     *  Check for id, if is is null call save else call update.
     * 
     * @param parentRecordId
     *              Unique identifier of parent record for the child standard master.
     */
    saveUpdateChildMaterDataPlacement: function( parentRecordId) {
        var this$ = this, parentTableId=this.getParentTableId();
        var grid = this$.getStdMasterChildGrid();
        var submitUrl;
        var successMessge;
        // Get form data in string form.
        var form = this$.getStdMasterChildForm();
        var values = form.getValues();
        
        this.deleteEmptyFields(values);
        var formData = Ext.encode(values);

        if (form.getForm().findField('id').getSubmitValue() == null || form.getForm().findField('id').getSubmitValue() == "") {
            submitUrl = SERVERURL.STANDARD_MASTERS_CHILD_SAVE;
            successMessge =  getCommonTranslation('RECORD_ADD_SUCCESS');
        } else {
            submitUrl = SERVERURL.STANDARD_MASTERS_CHILD_UPDATE;
            successMessge = getCommonTranslation('RECORD_UPDATE_SUCCESS');
        } 

        Ext.getBody().mask('Submitting Form....', 'x-mask-loading');

        Ext.Ajax.request({
            type: 'rest',
            method: 'POST',
            url: submitUrl,
            params: {
                formData: formData,
                parentTableId: parentTableId,
                parentRecordId: parentRecordId
            },
            headers: {
                'Content-Type': 'application/json'
            },
            success: function(form, action) {
                grid.getStore().reload();
                Ext.getBody().unmask();
                this$.closeChildWindow();
                grid.getSelectionModel().deselectAll(true);
                showSuccessMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'), successMessge);
            },
            failure: function(form, action) {
            	Ext.getBody().unmask();
            }
        });
       
    },

    /**
     * Fetches the standard master data by id from the server.
     * 
     * @param id
     *            Unique identifier for the standard master.
     * @return data
     *            Standard master data.
     */
    getGridMetaData: function(id) {
        var data = null;
        Ext.Ajax.request({
            async: false,
            method: 'get',
            url: SERVERURL.STANDARD_MASTERS + id,
            success: function(response) {
                data = Ext.JSON.decode(response.responseText);
            }
        });
        return data;
    },

    /**
     * Create grid by dynamic columnModel, columnHeader and master table id .
     * 
     * @param grid
     *          Reference object of grid. 
     * @param columnModel
     *          Array for store model fields.
     * @param columnHeader
     *          Array of header of grid.
     * @param masterId
     *         Unique identifier for the standard master.
     */
    createGrid: function(grid, columnModel, columnHeader, masterId) {
        grid.getSelectionModel().deselectAll(true);

        var url = SERVERURL.STANDARD_MASTERS_GRIDDATA;
        var params = {
            id: masterId
        };
        var store = this.createGridStore(columnModel, url, params);
        store.load();
        Ext.suspendLayouts();
        grid.reconfigure(store, columnHeader);
        Ext.resumeLayouts(true);
        //Rebind store to grid
        grid.down('custompagingtoolbar').bindStore(store);
    },


    /**
     * Create child grid by dynamic columnModel, columnHeader and parent master table id.
     * 
     * @param grid
     *          Reference object of grid. 
     * @param columnModel
     *          Array for store model fields.
     * @param columnHeader
     *          Array of header of grid.
     * @param parentTableId
     *         Unique identifier for the parent standard master.
     */
    createChildGrid: function(grid, columnModel, columnHeader, parentTableId) {
        grid.getSelectionModel().deselectAll(true);
        var url = SERVERURL.STANDARD_MASTERS_CHILD_GRIDDATA;
        var params = {
            parentTableId: parentTableId
        };
        var store = this.createGridStore(columnModel, url, params);
        Ext.suspendLayouts();
        grid.reconfigure(store, columnHeader);
        Ext.resumeLayouts(true);
        grid.down('custompagingtoolbar').bindStore(store);
    },

    /**
     * Updates child grid parent master table id and parent master record id.
     * 
     * @param grid
     *          Reference object of grid. 
     * @param parentTableId
     *         Unique identifier for the parent standard master.
     * @param parentRecId
     *         Unique identifier for the parent standard master record.
     */
    updateChildGrid: function(grid, parentTableId, parentRecId) {
        grid.getSelectionModel().deselectAll(true);
        var store = grid.getStore();
        store.getProxy().extraParams = {
            parentTableId: parentTableId,
            parentRecId: parentRecId
        };
        store.reload({
            callback: function(records, operation, success) {
                if (success) {
                    grid.getSelectionModel().select(0, true);
                }
            }
        });
        //Rebind store to grid
        grid.down('custompagingtoolbar').bindStore(store);
    },


    /**
     * Create dynamic form by column meta data.
     * 
     * @param form
     *          Reference object of form. 
     * @param responseData
     *             Meta data for columns and store model. 
     */
    createForm: function(form, responseData,mode) {
        var this$ = this;
        var formItems = [];
        var itemsArray = [];
        var itemCount=0;
        Ext.each(responseData, function(obj) {
            // Add the records to the formItems array.
        	var field;

            if (obj.type == 'Date') {
                field=this$.getDateField(obj);
            } else if (obj.type == 'Boolean') {
                field=this$.getCheckboxField(obj);
            } else if (obj.type == 'Number') {
                field=this$.getNumberField(obj);
            } else if (obj.whetherForeignKey == true) {
                field=this$.getComboBox(obj);
            } else if (obj.type == 'Enum') {
                field=this$.getEnumDropDown(obj);
            } else field=this$.getTextField(obj);
            
            if(obj.whetherReadOnly && mode=='EDIT'){
            	field.readOnly=true;
            }
            
            if(itemCount==1){
            	itemCount=0;
            	itemsArray.push(field);
            	var fieldcontainer=this$.createFieldcontainer(itemsArray);
            	itemsArray=[];
            	formItems.push(fieldcontainer);
            }else{
            	itemsArray.push(field);
            	itemCount++;
            }

        });
        
        if(itemsArray.length>0){
        	var fieldcontainer=this$.createFieldcontainer(itemsArray);
        	itemsArray=[];
        	formItems.push(fieldcontainer);
        }

        // Add the hidden field for id to the formItems array.
        formItems.push({
            xtype: 'hidden',
            name: 'id'
        });
        
     // Add the hidden field for id to the formItems array.
        formItems.push({
            xtype: 'hidden',
            name: 'version'
        });
        form.removeAll();
        form.add(formItems);
        form.add(this$.createButtons());
    },

    createFieldcontainer: function(itemArray) {
    	 field =  {
    				xtype : 'fieldcontainer',
    				width: 'auto',
    		        defaults: {
    		            labelAlign: 'top',
    		            width: 256
    		        },
    		        layout: {
    		            type: 'hbox'
    		        },
    		        items:itemArray
    	 };
    	  return field;
    },
    createButtons: function() {
	   var field =  {
			xtype : 'fieldcontainer',
			width : '100%',
//			cls : 'windowBtnPos',
			items : [{
			    xtype: 'button',
	            action: 'Submit',
	            itemId: 'formSubmitButtonId',
	            text: getCommonTranslation('SUBMIT'),
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE,
	            formBind: true,
	            disabled: true
	        },{
	        	xtype: 'button',
	            text: getCommonTranslation('CANCEL'),
	            action: 'Cancle',
	            ui: 'CustomBtnCancel',
	            scale: CONSTANTS.BUTTONSIZE
	        }]
		};
	   return field;
    },

    /**
     * This function create dynamic store with pagination of size 30 by column model and url.
     * 
     * @param columnModel
     *          Column model contains array of fields. 
     * @param url
     *          URL for reading data. 
     */
    createGridStore: function(columnModel, url, params) {
        var store = Ext.create('Ext.data.Store', {
            fields: columnModel,

            autoDestroy: true,
            autoLoad: false,

            remoteFilter: true,
            remoteSort: true,
            sortOnLoad: true,
            pageSize: CONSTANTS.DEFAULT_PAGESIZE,

            extraParams: params,

            proxy: {
                type: 'rest',
                api: {
                    read: url
                },
                reader: {
                    type: 'json',
                    root: 'rows',
                    totalProperty: 'records'
                },
                extraParams: params
            }
        });
        return store;
    },

    /**
     * This function create dynamic store by column model and url.
     * 
     * @param columnModel
     *          Column model contains array of fields. 
     * @param url
     *          URL for reading data. 
     */
    createSimpleStore: function(columnModel, url,extraParam) {
        var store = Ext.create('Ext.data.Store', {
            fields: columnModel,
            proxy: {
                type: 'rest',
                api: {
                    read: url
                },
                reader: {
                    type: 'json'
	            },
	            extraParams:extraParam
            }
        });
        return store;
    },

    /**
     * This function create delete record from database and update store .
     * 
     * @param grid
     *          Reference object of grid. 
     * @param parentTableId
     *         Unique identifier for the parent standard master.
     * @param rowIndex
     *         Row number for record which is to be delete.
     */
    deleteMasterData: function(grid, parentId, rowIndex) {
        var msgTitle = '';
         var rec = grid.getStore().getAt(rowIndex);
         var recId = rec.get("id");
         var standardMaster = this.getStandardMaster();
         if(standardMaster){
               var standardMasterComboField = standardMaster.down('#standardMasterComboField');
               msgTitle = standardMasterComboField.getRawValue();
         }
         showConfirmMessage(getPlacementTranslation('PLACEMENT_MASTER_COMBO'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                              Ext.Ajax.request({
                                  method: "DELETE",
                                  type: 'rest',
                                  url:SERVERURL.STANDARD_MASTERS_DELETE,
                                    params: {
                                        parentTableId: parentId,
                                        recordId: recId
                                    },
                                  success: function(response) {
                                    showSuccessMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'), getCommonTranslation('SUCCESS'));
                                      grid.getSelectionModel().deselectAll(true);
                                      grid.getStore().reload();
                                      grid.getSelectionModel().select(0, true);
                                  }
                              });
                }
         });
     },


    /**
     * This function create form field by field type and column meta data object.
     * Set	grow : true,
     * Set	growMax :300,
     * Set	growMin :100
     * 
     * @param xtype
     *          Xtype for form field. 
     * @param obj
     *         Column meta data object.
     */
    getfield: function(xtype, obj) {
        var field = {
            xtype: xtype,
            fieldLabel: this.getFieldLabel(obj.fieldLabel), 
            name: obj.dbFieldName,
            grow: true,
            growMax: 300,
            allowBlank: obj.wheherNullable,
            growMin: 100
        };
        return field;
    },

    /**
     * This function create form text field by column meta data object.
     * Uses getfield() function.
     * 
     * @param obj
     *         Column meta data object.
     */
    getTextField: function(obj) {
        var field = this.getfield('textfield', obj);
//        if(obj.dbFieldName === 'email'){
//        	field.vtype ='email';
//        	return field;
//        }
        field.vtype = 'NospaceAsInput';
        return field;
    },

    /**
     * This function create form number field by column meta data object.
     * Uses getfield() function.
     * 
     * @param obj
     *         Column meta data object.
     */
    getNumberField: function(obj) {
        var field = this.getfield('numberfield', obj);
        field.hideTrigger = true;
        field.minValue = 0;
//        if(obj.dbFieldName === 'phone'){
//        	field.maxLength = 10;
//        	field.setMaxLength = true;
//        	return field;
//        }
        if(obj.standardMaster.value === 'PLACEMENT_SALARY_RANGE' && (obj.dbFieldName === 'rangeFrom'||obj.dbFieldName === 'rangeTo')){
        	field.maxLength = 8;
        	field.setMaxLength = true;

        } if (obj.standardMaster.value === 'DOCUMENT_MASTER_TYPE' && (obj.dbFieldName === 'size')) {
        	field.maxLength = 10;
        }
        return field;
    },
    
    
    getEnumDropDown: function(obj) {
        var url = SERVERURL.STANDARD_MASTERS_ENUM_PICKLIST;
        var  extraParam={
        		enumType:obj.emunType
         };
         var store = this.createSimpleStore(['id', 'value','code'], url,extraParam);
         store.load();
         var fieldName = this.getFieldLabel(obj.fieldLabel);
         var field = {
             xtype: 'customcombobox',
             name: obj.dbFieldName,
             store: store,
             displayField: 'value',
             valueField: 'code',
             editable: false,
             fieldLabel: fieldName,
             allowBlank: obj.wheherNullable,
             grow: true,
             growMax: 300,
             growMin: 100
         };
         return field;
    },


    /**
     * This function create form date field by column meta data object.
     * Uses getfield() function.
     * Set date format to d-m-Y
     * 
     * @param obj
     *         Column meta data object.
     */
    getDateField: function(obj) {
        var field = this.getfield('datefield', obj);
        field.format = CONSTANTS.DATE_FORMAT;
        return field;
    },

    /**
     * This function create form checkbox field by column meta data object.
     * Uses getfield() function.
     * Set value type to true/false 
     * 
     * @param obj
     *         Column meta data object.
     */
    getCheckboxField: function(obj) {
        var field = this.getfield('checkboxfield', obj);
        field.labelAlign = 'left';
        field.inputValue = 'true';
        field.uncheckedValue = 'false';
        return field;
    },

    /**
     * This function create form combobox field by column meta data object.
     * User createSimpleStore() to load data in combobox.
     * Set editable to false
     * Override getSubmitData() function to set custom submit value as,
     * 	name :{id:value} 
     * 
     * @param obj
     *         Column meta data object.
     */
    getComboBox: function(obj) {
        var url = SERVERURL.STANDARD_MASTERS_DROPDOWN;
       var  extraParam={
        		parentTableId:obj.fkTable ,
        		columnName:obj.fkDisplayField
        };
        var store = this.createSimpleStore(['id', 'value'], url,extraParam);
        store.load();
        var fieldName = this.getFieldLabel(obj.fieldLabel);
        var field = {
            xtype: 'customcombobox',
            store: store,
            displayField: 'value',
            valueField: 'id',
            editable: false,
            fieldLabel: fieldName,
            allowBlank: obj.wheherNullable,
            name: obj.dbFieldName + ".id", //+"."+obj.fkDisplayField,
            grow: true,
            growMax: 300,
            growMin: 100,
            // Override method for submity value to submit nested json value
            getSubmitData: function() {
                var this$ = this,
                    data = null,
                    value;
                if (!this$.disabled && this$.submitValue) {
                    value = this$.getValue();
                    if (this$.store.items == 'undefined')
                    	this$.store.load(['id', 'value'], url);
                    if (value && value !== null) {
                    	var customValue = "{\"id\":" + value + "}";
                        value = Ext.decode(customValue);
                        data = {};
                        data[obj.dbFieldName] = value;
                    }
                }
                return data;
            }
        };
        return field;
    },

    /*
     * For addeing deleter button in each row
     */
    getDeleteActionColumn: function(grid, parentTableId) {
        var this$ = this;
        var field = {
            xtype: 'actioncolumn',
            flex: 1,
            header: this.getFieldLabel('DELETE'),
            icon: 'resources/images/close-btn.png',
            tooltip: this.getFieldLabel('DELETE'),
            handler: function(grid, rowIndex, colIndex) {
                this$.deleteMasterData(grid, parentTableId, rowIndex);
            }
        };
        return field;
    },
   
    getFieldLabel: function(field) {
        return getCommonTranslation(field);
    },
    
    getStdMasterParentGrid : function(combo) {
    	return this.getActiveTabfromContentPanel().down('#stdMasterParentGrid');
    },
    
    getStdMasterChildGrid : function(combo) {
    	return this.getActiveTabfromContentPanel().down('#stdMasterChildGrid');
    },
    getfilterCodeValue: function(panel) {
    	if(!panel)
    		panel=this.getActiveTabfromContentPanel();
    	return panel.searchConfigCode;
    },
    
    getParentResponseData : function(){
    	return 	this.getActiveTabfromContentPanel().parentResponseData;;
    },
    setParentResponseData : function(parentResponseData){
    	this.getActiveTabfromContentPanel().parentResponseData=parentResponseData;
    },
    
    getParentTableId : function(){
    	return 	this.getActiveTabfromContentPanel().parentTableId;;
    },
    setParentTableId : function(parentTableId){
    	this.getActiveTabfromContentPanel().parentTableId=parentTableId;
    },
    
    getChildTableId : function(){
    	return 	this.getActiveTabfromContentPanel().childTableId;;
    },
    setChildTableId : function(childTableId){
    	this.getActiveTabfromContentPanel().childTableId=childTableId;
    },
    getParentRecordId : function(){
    	return 	this.getActiveTabfromContentPanel().parentRecordId;;
    },
   setParentRecordId : function(parentRecordId){
    	this.getActiveTabfromContentPanel().parentRecordId=parentRecordId;
    },
    
    getChildResponseData : function(){
    	return 	this.getActiveTabfromContentPanel().childResponseData;;
    },
    setChildResponseData : function(childResponseData){
    	this.getActiveTabfromContentPanel().childResponseData=childResponseData;
    },
    
    
    
});
