/**
 * @author Vishal Joshi
 * 
 */
Ext.define('Academia.controller.placement.placementcampus.PlacementCampusController', {
	extend: 'Academia.controller.base.BaseController',
	models : ['placement.placementcampus.PlacementCampusCreateModel','placement.placementcampus.PlacementCampusApplyToProgramPeriodWindowModel',
		'placement.placementcampus.PlacementDriveFollowUpDetailModel','placement.placementcampus.PlacementDriveFollowUpActivityToModel','transport.serviceRoute.TimeDataModel'],
		stores : ['placement.placementcampus.PlacementCampusGridStore','placement.placementcampus.PlacementCampusApplyToProgramPeriodGridStore',
			'placement.PlacementTypeStore','placement.placementcampus.PlacementCampusProgramPeriodALStore','placement.placementcampus.PlacementCampusProgramPeriodOALStore',
			'placement.placementcampus.PlacementCampusStore','examinationcenters.evaluation.evaluationPlanHeirarchy.DroolCalculationData',
			'placement.placementcampus.placementCampusCoordinatorStore',
			'placement.placementcampus.placementCampusOrgAlStore','common.PlacementProgramByAcademyLocationStore','common.ProgramByAcademyLocationStore','common.BatchesByProgramId','common.PlacementBatchesByProgramStore',
			'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod','program.programDetails.programBatches.courseParameter.PlacementProgramCoursePeriodStore','placement.placementcampus.PlacementCampusRecruitingOrganizationGridStore',
			'placement.placementcampus.PlacementCampusDocumentStore','placement.placementcampus.PlacementCampusAcademicOrganizationGridStore','placement.placementcampus.PlacementCampusDocumentListStore','placement.placementcampus.PlacementCampusRecOrgALStore','user.UserAcademyLocationStore',
			'placement.placementcampus.PlacementFollowupNameStore','placement.placementcampus.PlacementFollowupActivityToStore',
			'placement.placementcampus.PlacementFollowupActivityTypeStore','placement.placementcampus.PlacementFollowupStatusStore',
			'placement.placementcampus.PlacementCampusFollowupGridStore','placement.placementcampus.PlacementCampusAssignedToStore','placement.PlacementDriveMODStore',
			'placement.PlacementActivityDurationTypeStore','placement.PlacementActivityTypeIdentifierStore','placement.PlacementHostIdentifierStore','placement.PlacementHostIdentifierTypeStore',
			'placement.PlacementMobilitySchemeStore'],
			views : ['placement.placementcampus.PlacementCampusStructure','placement.placementcampus.PlacementCampusFilter',
				'placement.placementcampus.PlacementCampusGrid','placement.placementcampus.PlacementCampusForm',
				'placement.placementcampus.PlacementCampusTabStructure','placement.placementcampus.PlacementCampusApplyToProgramPeriodStructure',
				'placement.placementcampus.PlacementCampusRecruitingOrganizationGrid','placement.placementcampus.PlacementCampusAcademicOrganizationGrid',
				'placement.placementcampus.PlacementCampusApplyToProgramPeriodForm','placement.placementcampus.PlacementCampusApplyToProgramPeriodGrid',
				'placement.placementcampus.PlacementCampusApplyToStructure','placement.placementcampus.RecruitingOrgGridWindow',
				'placement.placementcampus.AcademicOrgGridWindow','placement.placementcampus.PlacementCampusPeriodGridWindow',
				'placement.placementcampus.PlacementCampusDocumentGridWindow','placement.placementcampus.PlacementDriveStructure',
				'placement.placementcampus.PlacementDriveGrid','placement.placementcampus.PlacementCampusDetailStructure',
				'placement.placementcampus.PlacementCampusFollowUpStructure','placement.placementcampus.PlacementCampusFollowUpGrid','placement.placementcampus.PlacementCampusFollowUpForm'
				,'placement.placementcampus.PlacementCampusApplyToProgramPeriodEditForm'],
				config:{
					PLACEMENT_CAMPUS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PLACEMENT_CAMPUS_PRIVILEGES'),
					PLACEMENT_DRIVE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PLACEMENT_DRIVE_PRIVILEGES')	

				},	         
				refs : [
					{
						ref : 'placementcampusstructure',
						selector : 'placementcampusstructure'
					},{
						ref : 'placementcampusfilter',
						selector : 'placementcampusfilter'
					},{
						ref: 'placementcampusgrid',
						selector: 'placementcampusgrid'
					},{
						ref: 'placementcampusapplytoprogramperiodgrid',
						selector: 'placementcampusapplytoprogramperiodgrid'
					},{
						ref: 'placementcampusrecruitingorganizationgrid',
						selector: 'placementcampusrecruitingorganizationgrid'
					},{
						ref: 'placementcampusacademicorganizationgrid',
						selector: 'placementcampusacademicorganizationgrid'
					},{
						ref: 'placementcampusapplytoprogramperiodform',
						selector: 'placementcampusapplytoprogramperiodform'
					},{
						ref: 'contentPanel',
						selector: 'contentPanel'
					},{
						ref: 'placementcampusform',
						selector: 'placementcampusform'
					},{
						ref: 'placementCampusApplyoProgramperiodForm',
						selector: 'placementcampusapplytoprogramperiodform form'
					},{
						ref: 'placementCampusapplytoProgramperiodWin',
						selector: 'placementcampusapplytoprogramperiodform'
					},{
						ref: 'recruitingorggridwindow',
						selector: 'recruitingorggridwindow'
					},{
						ref: 'academicorggridwindow',
						selector: 'academicorggridwindow'
					},{
						ref: 'placementcampusperiodgridwindow',
						selector: 'placementcampusperiodgridwindow'
					},{
						ref: 'placementcampusdocumentgridwindow',
						selector: 'placementcampusdocumentgridwindow'
					},{
						ref: 'placementdrivestructure',
						selector: 'placementdrivestructure'
					},{
						ref: 'placementdrivegrid',
						selector: 'placementdrivegrid'
					},{
						ref: 'placementcampusdetailstructure',
						selector: 'placementcampusdetailstructure'
					},{
						ref:'placementcampusfollowupstructure',
						selector:'placementcampusfollowupstructure'
					},{
						ref:'placementcampusfollowupgrid',
						selector:'placementcampusfollowupgrid'
					},{
						ref:'placementcampusfollowupform',
						selector:'placementcampusfollowupform'
					},{
						ref:'placementcampustabstructure',
						selector:'placementcampusfollowupform'
					},{
						ref:'placementcampusapplytoprogramperiodeditform',
						selector:'placementcampusapplytoprogramperiodeditform'
					}],
					init : function() {
						this.control({
							'placementcampusfilter button[itemId=searchBtn]': {
								click: this.loadPlacementCampusGrid
							},
							'placementcampusfilter button[itemId=resetBtn]': {
								click: this.resetPlacementCampusFilter
							},
							/*'placementcampusgrid':{
								render: function(grid) {
									 this.disableAndEnableExportBtn(grid, this.getPLACEMENT_CAMPUS_PERMISSIONS());
								}
							},*/'placementcampusform customcombobox[itemId=droolsRule]':{
								render: function(obj) {
									var $this = this;
									var form = $this.getPlacementcampusform().getForm();
									var store = form.findField('droolsRule').getStore();
									store.getProxy().extraParams={
										moduleName:'PLACEMENT'
									};
									var organizingAcademyLocation = form.findField('organizingAcademyLocation').getStore();
									organizingAcademyLocation.getProxy().extraParams={
										id:$this.getCurrentlyLoggedInUser().id
									}
								}
							},
							'placementcampusgrid button[itemId=btnDelete]':{
								click: this.deletePlacementCampusRecord
							},
							'placementcampusgrid button[itemId=btnEdit]':{
								click: this.editPlacementCampusRecord
							},
							'placementcampusform button[itemId=resetBtn]':{
								click:this.resetPlacementCampusForm
							},
							'placementcampusgrid button[itemId=btnAdd]':{
								click: this.addPlacementCampusRecord
							},
							'placementcampusgrid button[itemId=btnView]':{
								click: this.viewPlacementCampusRecord
							},
							'placementcampusform button[itemId=submitBtn]':{
								click: this.savePlacementCampusRecord
							},
							'placementcampusapplytoprogramperiodform button[itemId=SubmitBtn]':{
								click: this.addProgramPeriod
							},'placementcampusapplytoprogramperiodform button[itemId=CancelBtn]':{
								click: this.cancelPlacementCampusWindow
							},
							'placementcampusapplytoprogramperiodeditform button[itemId=SubmitBtn]':{
								click: this.addProgramPeriodedit
							},'placementcampusapplytoprogramperiodeditform button[itemId=CancelBtn]':{
								click: this.cancelPlacementCampusWindowEdit
							},
							'placementcampusrecruitingorganizationgrid button[itemId=btnSaveRecruitingAcademyLocationId]':{
								click: this.mapUnmapALRecrutingOrg
							},
							'placementcampusacademicorganizationgrid button[itemId=btnSaveAcademicAcademyLocationId]':{
								click: this.mapUnmapALAcademicOrg
							},
							'placementcampusapplytoprogramperiodgrid button[itemId=btnAdd]':{
								click: this.addPlacementCampusProgramPeriodWindow
							},
							'placementcampusapplytoprogramperiodgrid button[itemId=btnEdit]':{
								click: this.editPlacementCampusPeriodRecord
							},
							'placementcampusapplytoprogramperiodgrid button[itemId=btnDelete]':{
								click: this.deletePlacementCampusProgramPeriodRecord
							},
							'placementcampusapplytoprogramperiodgrid button[itemId=btnView]':{
								click: this.viewPlacementCampusProgramPeriod
							},
							'placementcampusgrid splitbutton[itemId=spBtnMoreActions] #academyLocation':{
								click : function(){
									var $this = this;
									var grid = $this.getPlacementcampusgrid();

									if (grid.getSelectionModel().getCount() > 0) {
										this.openRecruitingOrganization();
									}else
									{
										showWarningMessage(getPlacementTranslation('PATH_PLACEMENT_CAMPUS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
									}
								}
							},'placementcampusgrid splitbutton[itemId=spBtnMoreActions] #programPeriod':{
								click : function(){
									var $this = this;
									var grid = $this.getPlacementcampusgrid();

									if (grid.getSelectionModel().getCount() > 0) {
										this.openApplyToProgramPeriod();
									}else
									{
										showWarningMessage(getPlacementTranslation('PATH_PLACEMENT_CAMPUS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
									}
								}
							},
							'placementcampusgrid':{
								cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
									var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;

									if(columnName == "recruitingOrganizationCount"){
										if(e.target.tagName=='A'){
											this.getRecruitingOrgGridWindow(grid,record);
										}
									}
									if(columnName == "academicOrganizationCount"){
										if(e.target.tagName=='A'){
											this.getAcademicOrgGridWindow(grid,record);
										}
									}

									if(columnName == "programPeriodCount"){
										if(e.target.tagName=='A'){
											this.getPeriodCountGridWindow(grid,record);
										}
									}

									if(columnName == "documentCount"){
										if(e.target.tagName=='A'){
											this.getdocumentCountGridWindow(grid,record);
										}
									}

								},
								render: function(grid) {
									 this.disableAndEnableExportBtn(grid, this.getPLACEMENT_CAMPUS_PERMISSIONS());
								}
							},
							/*  'placementcampusgrid':{
	                        			   cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	                        				   var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;

	                            				 if(columnName == "academicOrganizationCount"){
	                            					 if(e.target.tagName=='A'){
	                            						 this.getAcademicOrgGridWindow(grid,record);
	                            					 }
	                            				 }
	                            			 }
	                            		 },*/
							'placementcampusapplytoprogramperiodform nestedJsonCombo[itemId=academyLocation]':{
								select:function(obj,rec){
									var data=rec[0].data.id;  
									var filterForm=obj.up('form');
									var progamField=filterForm.down('#programId');
									progamField.setDisabled(false);
									progamField.reset();
									progamField.getStore().getProxy().extraParams={
										academyLocationId:data
									};
									progamField.getStore().load();
								}
							},
							'placementcampusapplytoprogramperiodeditform nestedJsonCombo[itemId=academyLocation]':{
								select:function(obj,rec){
									var data=rec[0].data.id;  
									var filterForm=obj.up('form');
									var progamField=filterForm.down('#programId');
									progamField.setDisabled(false);
									progamField.reset();
									progamField.getStore().getProxy().extraParams={
										academyLocationId:data
									};
									progamField.getStore().load();
								}
							},
							'placementcampusapplytoprogramperiodeditform nestedJsonCombo[itemId=programId]':{
								select:function(obj,rec){
									var data=obj.getValue();
									var filterForm=obj.up('form');
									var batchField=filterForm.down('#batchId');
									var periodField=filterForm.down('#periodId');
									batchField.setDisabled(false);
									batchField.reset();
									
									periodField.setDisabled(false);
									periodField.reset();
									
									var programIdArr=[];
									var programId = data;
									var programIds = null;

									if (!isNullOrEmpty(programId) && programId.length > 0 && !isNullOrEmpty(programId[0])) {
										for (var i in programId) {
											if (Ext.isObject(programId[0])) {
												programIdArr.push(programId[i].get("id"));
											} else {
												programIdArr.push(programId[i]);
											}
										}
										programIds = programIdArr.join();
									}
									else if(!isNullOrEmpty(programId)){
										programIds = programId;
									}

									batchField.getStore().getProxy().extraParams={
										programId:programIds
									};
									batchField.getStore().load();
								}
							},

							'placementcampusapplytoprogramperiodform multiselectcombofield[itemId=programId]':{
								change:function(obj,rec){
									var data=obj.getValue();
									var filterForm=obj.up('form');
									var batchField=filterForm.down('#batchId');
									batchField.reset();
									if(obj.isValid()){
										batchField.setDisabled(false);
									}else{
										batchField.setDisabled(true);
									}
									var programIdArr=[];
									var programId = data;
									var programIds = null;

									if (!isNullOrEmpty(programId) && programId.length > 0 && !isNullOrEmpty(programId[0])) {
										for (var i in programId) {
											if (Ext.isObject(programId[0])) {
												programIdArr.push(programId[i].get("id"));
											} else {
												programIdArr.push(programId[i]);
											}
										}
										programIds = programIdArr.join();
									}
									else if(!isNullOrEmpty(programId)){
										programIds = programId;
									}

									batchField.getStore().getProxy().extraParams={
										programId:programIds
									};
									batchField.getStore().load();
								}
							},
							'placementcampusapplytoprogramperiodform multiselectcombofield[itemId=batchId]':{
								change:function(obj,rec){
									var data=obj.getValue();
									var filterForm=obj.up('form');
									var periodField=filterForm.down('#periodId');
									periodField.reset();
									if(obj.isValid()){
										periodField.setDisabled(false);
									}else{
										periodField.setDisabled(true);
									}
									var batchIdArr=[];
									var batchId = data;
									var batchIds = null;

									if (!isNullOrEmpty(batchId) && batchId.length > 0 && !isNullOrEmpty(batchId[0])) {
										for (var i in batchId) {
											if (Ext.isObject(batchId[0])) {
												batchIdArr.push(batchId[i].get("id"));
											} else {
												batchIdArr.push(batchId[i]);
											}
										}
										batchIds = batchIdArr.join();
									}
									else if(!isNullOrEmpty(batchId)){
										batchIds = batchId;
									}
									
									periodField.getStore().getProxy().extraParams={
										batchId:batchIds
									};
									periodField.getStore().load();
								}
							},
							'placementcampusapplytoprogramperiodeditform nestedJsonCombo[itemId=batchId]':{
								select:function(obj,rec){
									var data=obj.getValue();
									var filterForm=obj.up('form');
									var periodField=filterForm.down('#periodId');
									periodField.setDisabled(false);
									periodField.reset();
									
									var batchIdArr=[];
									var batchId = data;
									var batchIds = null;

									if (!isNullOrEmpty(batchId) && batchId.length > 0 && !isNullOrEmpty(batchId[0])) {
										for (var i in batchId) {
											if (Ext.isObject(batchId[0])) {
												batchIdArr.push(batchId[i].get("id"));
											} else {
												batchIdArr.push(batchId[i]);
											}
										}
										batchIds = batchIdArr.join();
									}
									else if(!isNullOrEmpty(batchId)){
										batchIds = batchId;
									}
									
									periodField.getStore().getProxy().extraParams={
										batchId:batchIds
									};
									periodField.getStore().load();
								}
							},
							'placementcampusfilter nestedJsonCombo[itemId=organizingAcademyLocation]':{
								select:function(obj,rec){
									var data=rec[0].data.id;  
									var filterForm=obj.up('form');
									var progamField=filterForm.down('#programId');
									progamField.setDisabled(false);
									progamField.reset();
									progamField.getStore().getProxy().extraParams={
										academyLocationId:data
									};
									progamField.getStore().load();
								}
							},
							'placementcampusfilter nestedJsonCombo[itemId=campusCoordinator]':{
								render: function(obj) {
									var $this = this;
									var locations = [];
									var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
									for(var i=0; i<academyLocationList.length; i++){
										locations.push(academyLocationList[i].id);
									}
									var form = $this.getPlacementcampusfilter().getForm();
									var store = form.findField('campusCoordinator').getStore();
									store.getProxy().extraParams={
										roleName:'FACULTY',
										academyLocationIds:locations.join()
									}
								}
							},
							'placementcampusform nestedJsonCombo[itemId=campusCoordinator]':{
								render: function(obj) {
									var $this = this;
									var form = $this.getPlacementcampusform().getForm();
									var store = form.findField('campusCoordinator').getStore();
									store.getProxy().extraParams={
										roleName:'FACULTY',
										academyLocationId:this.getCurrentAcademyLocation()
									}
								}
							},
							'placementcampusfilter nestedJsonCombo[itemId=programId]':{
								select:function(obj,rec){
									var data=rec[0].data.id;  
									var filterForm=obj.up('form');
									var batchField=filterForm.down('#batchId');
									batchField.setDisabled(false);
									batchField.reset();
									batchField.getStore().getProxy().extraParams={
										id:data
									};
									batchField.getStore().load();
								}
							},
							'placementcampusfilter nestedJsonCombo[itemId=batchId]':{
								select:function(obj,rec){
									var data=rec[0].data.id;  
									var filterForm=obj.up('form');
									var periodField=filterForm.down('#periodId');
									periodField.setDisabled(false);

									periodField.reset();
									periodField.getStore().getProxy().extraParams={
										id:data
									};
									periodField.getStore().load();
								}
							},
							'placementcampusform radiogroup#documentRequired': {
								change: function(value, newValue,oldValue) {
									var form = value.up('form').getForm();
									var documentId = Ext.ComponentQuery.query('combo#documentCount')[0];
									var allowblankFalse = '<span class="required" style="color:red"> *</span>';
									documentId.labelSeparator = '';
									if(newValue.documentRequired){
										documentId.setVisible(true);
										documentId.allowBlank=false;
										documentId.setFieldLabel(getPlacementTranslation('DOCUMENTS')+allowblankFalse);
									}else{
										documentId.reset();
										documentId.setVisible(false);
										documentId.allowBlank=true;
									}
									form.isValid();
								}
							},

							'placementcampusacademicorganizationgrid':{
								render: function(obj, record) {
									var $this = this;
									var gridAcademic = $this.getPlacementcampusacademicorganizationgrid();
									var placementGrid = $this.getPlacementcampusgrid();
									gridAcademic.getStore().getProxy().extraParams={
										placementCampusId:placementGrid.getSelectionModel().getSelection()[0].data.id,
										purpose:'COURSE_EXECUTION'
									};
									Ext.apply(gridAcademic,{
										codeAL:null,
										setCodeAL : function(codeAL){
											gridAcademic.codeAL = codeAL;
										},
										getCodeAL:function(){
											return gridAcademic.codeAL;
										}
									});

									var arrr = [];
									gridAcademic.getStore().load({
										callback: function(records, operation, success) {
											if (success) {
												if(records.length > 0){
													if(gridAcademic.getSelectionModel().getCount()>0){
														gridAcademic.getSelectionModel().deselectAll();
													}
													for(i in records){
														if(records[i].data.isMapped){
															gridAcademic.getSelectionModel().select(records[i],true);
															arrr.push(records[i]);
														}
													}
												}		 
											}
										}	   
									});
									gridAcademic.setCodeAL(arrr);
								}
							},

							'placementcampusrecruitingorganizationgrid':{
								render: function(grid) {
									var buttonsToolBar = grid.query('toolbar')[0];
//									var exportAllPdfbuttons = buttonsToolBar.query('splitbutton')[0].menu.items.items[1];
//									exportAllPdfbuttons.setVisible(false);
								}
							},

							'placementdrivegrid':{
								render: function(grid) {
									this.doAccessControlValidation(grid, this.getPLACEMENT_DRIVE_PERMISSIONS());
									this.loadPlacementDriveGrid(grid);
								},
								cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
									var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;

									if(columnName == "recruitingOrganizationCount"){
										if(e.target.tagName=='A'){
											this.getRecruitingOrgGridWindow(grid,record);
										}
									}
									if(columnName == "academicOrganizationCount"){
										if(e.target.tagName=='A'){
											this.getAcademicOrgGridWindow(grid,record);
										}
									}

									if(columnName == "programPeriodCount"){
										if(e.target.tagName=='A'){
											this.getPeriodCountGridWindow(grid,record);
										}
									}

									if(columnName == "documentCount"){
										if(e.target.tagName=='A'){
											this.getdocumentCountGridWindow(grid,record);
										}
									}

								}
							},
							'placementcampusfollowupform checkboxfield[itemId=plcDrivewhetherNextFollowUp]': {
								change:function(checkbox, newValue, oldValue, eOpts){ 
									var $this = this;
									var form = $this.getPlacementcampusfollowupform();
//									var enquiryStatus = form.down('#trackEnquiry_enquiryStatus');
									var nextFollowUpDate = form.down('#plcDrivenextFollowUpDate');
									var userByAssignTo = form.down('#plcDriveuserByAssignTo');
									var scroller = form.up('placementcampusdetailstructure').up().body;
									var scrollTop = scroller.getScrollTop();
									//var closerReason = form.down('#plcDrivecloserReasonId');
//									enquiryStatus.reset();
									Ext.suspendLayouts();
									nextFollowUpDate.reset();
									//closerReason.setVisible(false);
									userByAssignTo.reset();
									//closerReason.reset();
									if(newValue==true){
										nextFollowUpDate.setVisible(true);
										userByAssignTo.setVisible(true);
										$this.setAllowBlank (nextFollowUpDate,false);
										$this.setAllowBlank (userByAssignTo,false);	
										var userByAssignToStore = userByAssignTo.getStore();
										var loggedUserId = this.getCurrentlyLoggedInUser().id;
										Ext.defer(function() {
											userByAssignToStore.load({
												scope:this,
												callback: function(records, operation, success) {
													if(success){
														userByAssignTo.setValue(loggedUserId);
													}
												}
											});
										});
										userByAssignTo.validate();
										nextFollowUpDate.validate();
									}else if(newValue==false){
										nextFollowUpDate.setVisible(false);
										userByAssignTo.setVisible(false);
										$this.setAllowBlank (nextFollowUpDate,true);
										$this.setAllowBlank (userByAssignTo,true);
										userByAssignTo.validate();
										nextFollowUpDate.validate();
									}
									form.getForm().isValid();
									Ext.resumeLayouts(true);
									Ext.defer(function () {
										scroller.setScrollTop(scrollTop + 880);
									}, 1);
								}
							},
							'placementcampusfollowupform button[itemId=plcDrivefollowdetail_savebtn]': {
								click: this.savePlcDriveFollowUpDetail

							},
							'placementcampusfollowupgrid button[itemId=editFollowUp]':{
								click:this.setFollowUpDetailOnEdit
							},
							'placementcampusfollowupform': {
								afterrender:function(obj){
									var $this = this;
									var grid = $this.getPlacementcampusgrid();
									var placementcampusform = $this.getPlacementcampusform();
									var form = $this.getPlacementcampusfollowupform();
									var plcDriveemailAdress = form.down("#plcDriveemailAdress");
									var plcDriveellCountryCode = form.down("#plcDriveellCountryCode");
									var plcDrivemobileNumber = form.down("#plcDrivemobileNumber");
									var plcDrivefollowupuser = form.down("#plcDrivefollowupuser");
									var record = grid.getSelectionModel().getSelection()[0];
									$this.loadDFRForPlacementFollowUpDetails(form);
									var id = record.get("id");
									var activityType = form.down('#plcfollowupActivityTo');
									var store = activityType.getStore();
									store.getProxy().extraParams = {
										placementDriveId:id
									};
									store.load();
									
									var Name = this.getCurrentlyLoggedInUser().value;
									plcDrivefollowupuser.setValue(Name);
									
									var plcDrivefollowupTime = form.down('#plcDrivefollowupTime');
									plcDrivefollowupTime.setValue( Ext.Date.format(new Date(), 'H:i'));
									
									var plcDriveactualFollowUpDate = form.down('#plcDriveactualFollowUpDate');
									plcDriveactualFollowUpDate.setValue(new Date());
									/*store.load({
			                        					   callback: function(records, operation, success) {
			                        						   if(records.length>0){
			                        						   plcDriveemailAdress.setValue(records[0].data.address.primaryeEmailId);
			                        						   plcDriveellCountryCode.setValue(records[0].data.phoneCountryCode);
			                        						   plcDrivemobileNumber.setValue(records[0].data.address.phoneNo);
			                        						   }
			                        					   }
			                        				   });*/

									/*var plcDriveemailAdress = form.down("#plcDriveemailAdress");
	                        					var plcDriveellCountryCode = form.down("#plcDriveellCountryCode");
	                        					var plcDrivemobileNumber = form.down("#plcDrivemobileNumber");
	                        					url = SERVERURL.PATH_FIND_ALL_COMPANY_CONTACTS+"?placementDriveId="+id;
	                        					Ext.Ajax.request({
	                        					method: 'GET',
	                        					url: url,
	                        					success: function(response) {
	                        					if(!isNullOrEmpty(response.responseText)){
	                        					var data = Ext.decode(response.responseText);
	                        					if(data.length>0){
	                        						plcDriveemailAdress.setValue(data[0].address.primaryeEmailId);
		                        					plcDriveellCountryCode.getStore().load({
			                        					   callback: function(records, operation, success) {
			                        						   plcDriveellCountryCode.setValue(data[0].address.phoneCountryCode);
			                        					   }
			                        				   });
		                        					plcDrivemobileNumber.setValue(data[0].address.phoneNo);
	                        					}
	                        					}
	                        					}
	                        					});*/
								}

							},
							'placementcampusfollowupgrid':{
								render:function(obj){
									var grid = this.getPlacementcampusgrid();
									var saveBtn = obj.down('#AddFollowUp');
									/*if(obj.getStore().getTotalCount()>0){
										saveBtn.setDisabled(true);
									}else{
										saveBtn.setDisabled(false);
									}*/
									var record = grid.getSelectionModel().getSelection()[0];
									var form = this.getPlacementcampusfollowupform();
									var id = record.get("id");
									var store = obj.getStore();
									store.getProxy().extraParams = {
										id:id
									};
									store.load({
										callback: function(records, operation, success) {
											if(records.length>0){
												form.setDisabled(true);
												saveBtn.setDisabled(true);
											}else{
												form.setDisabled(false);
												saveBtn.setDisabled(false);
											}
										}
									});
									var loadStore = store.load(); 
									/*if(loadStore.getCount()>0){
										saveBtn.setDisabled(true);
									}else{
										saveBtn.setDisabled(false);
									}*/
								},
								selectionchange:function(grid){
									var grid = this.getPlacementcampusfollowupgrid();
									var btnEdit = grid.down('#editFollowUp');
									var record = grid.getSelectionModel().getSelection();
                                   if(record.length>0){
                                	   if(!record[0].data.isLatestFollowUp&&record[0].data.status == "Closed"){
   										btnEdit.setDisabled(true);
   									}else{
   										btnEdit.setDisabled(false);
   									}
                                   }
								}
							},
							'placementcampusfollowupform nestedJsonCombo[itemId=plcfollowupActivityTo]': {
								select: function(obj){
									var $this = this;
									var grid = $this.getPlacementcampusgrid();
									var record = grid.getSelectionModel().getSelection()[0];
									var form = $this.getPlacementcampusfollowupform();
									var plcDriveemailAdress = form.down("#plcDriveemailAdress");
									var plcDriveellCountryCode = form.down("#plcDriveellCountryCode");
									var plcDrivemobileNumber = form.down("#plcDrivemobileNumber");
									var id = record.get("id");
									var store = obj.getStore();
									store.getProxy().extraParams = {
										placementDriveId:id
									};
									store.load({
										callback: function(records, operation, success) {
											if(records.length>0){
												for(var i in records){
													if(records[i].data.id == obj.getValue()){
														plcDriveemailAdress.setValue(records[i].data.address.primaryeEmailId);
														plcDriveellCountryCode.setValue(records[i].data.address.cellCountryCode);
														plcDrivemobileNumber.setValue(records[i].data.address.cellNo);
													}
												}
											}
										}
									});
								}
							},
							/* 'placementdrivegrid [itemId=placementdrivegrid]':{
	                        			   cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	                        				   var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;

	                        				   if(columnName == "recruitingOrganizationCount"){
	                        					   if(e.target.tagName=='A'){
	                        						   this.getRecruitingOrgGridWindow(grid,record);
	                        					   }
	                        				   }
	                        				   if(columnName == "academicOrganizationCount"){
	                        					   if(e.target.tagName=='A'){
	                        						   this.getAcademicOrgGridWindow(grid,record);
	                        					   }
	                        				   }

	                        				   if(columnName == "programPeriodCount"){
	                        					   if(e.target.tagName=='A'){
	                        						   this.getPeriodCountGridWindow(grid,record);
	                        					   }
	                        				   }

	                        				   if(columnName == "documentCount"){
	                        					   if(e.target.tagName=='A'){
	                        						   this.getdocumentCountGridWindow(grid,record);
	                        					   }
	                        				   }

	                        			   }
	                        		   },
							 */
							'placementcampusform radiogroup[itemId=documentRequired]':{
								change: function(obj) {
									var $this = this;
									var value = obj.getValue();
									var form=$this.getPlacementcampusform();
									if(value.documentRequired){
										
										var imageUploadFieldArr = ['documentCount'];
										var academyLocationId = this.getCurrentAcademyLocation();

										Ext.Ajax.request({
											url: SERVERURL.COMMON_FORM_FIELD_INFO,
											method: 'GET',
											async: false,
											params: {
												academyLocationId:academyLocationId,
												languageCode:'en'
											},
											success: function(response) {
												var json = JSON.parse(response.responseText);
												var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
												fieldInfo.set("formFieldsInfo", json);
												if( !isNullOrEmpty(json) ){
													if( !isNullOrEmpty(json.placementcampusform) ){
														var academyLocationDetailDFRConfig = json.placementcampusform;
														for( i in academyLocationDetailDFRConfig){
															var fieldConfig = academyLocationDetailDFRConfig[i];
															if( imageUploadFieldArr.includes(fieldConfig.formFieldId) ){
																var documentCount = form.down("#documentCount");
																if(!isNullOrEmpty(fieldConfig.formFieldLabel)){
																	documentCount.setFieldLabel(fieldConfig.formFieldLabel+":");
																}
															}
														}
													}
												}
											}
										});
										
									}
								}
							},
							'placementcampusfilter customcombobox[itemId=intakeYearPlcDriveId]':{
								select:function(obj,rec){
									var grid = this.getPlacementcampusgrid();  
									var exportBtn=grid.down('#exportPlacementFollowUpReport');
									exportBtn.setDisabled(false);
								}
							},
							'placementcampusgrid  button[itemId=exportPlacementFollowUpReport]': {
								click: function(obj) {
									this.exportXlsPlacementFollowUpReport();
								}
							},
							'placementcampustabstructure':{
								render: function(obj) {
									var $this = this;
									var form = $this.getPlacementcampusfilter();
									var grid = $this.getPlacementcampusgrid();
									
									var intakeYearPlcDriveId = ['intakeYearPlcDriveId'];
									var academyLocationId = this.getCurrentAcademyLocation();

									Ext.Ajax.request({
										url: SERVERURL.COMMON_FORM_FIELD_INFO,
										method: 'GET',
										async: false,
										params: {
											academyLocationId:academyLocationId,
											languageCode:'en'
										},
										success: function(response) {
											var json = JSON.parse(response.responseText);
											var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
											fieldInfo.set("formFieldsInfo", json);
											if( !isNullOrEmpty(json) ){
												if( !isNullOrEmpty(json.placementcampusfilter) ){
													var academyLocationDetailDFRConfig = json.placementcampusfilter;
													for( i in academyLocationDetailDFRConfig){
														var fieldConfig = academyLocationDetailDFRConfig[i];
														if( intakeYearPlcDriveId.includes(fieldConfig.formFieldId) ){
															var exportPlacementFollowUpReport = grid.down("#exportPlacementFollowUpReport");
															if(!fieldConfig.isVisible){
																exportPlacementFollowUpReport.setDisabled(false);
															}else{
																exportPlacementFollowUpReport.setDisabled(true);
															}
														}
													}
												}
											}
										}
									});
								}
							},
							 'placementcampustabstructure' :  {
								 afterrender : function(structure){
									 var $this = this;
									 structure.body.on('scroll', function(e, target) {
						   				  var pcstructure = structure.down("placementcampusgrid");
						   				  var academyLocationId = $this.getCurrentAcademyLocation();
						   				  var grid = null;
						   				  
						   				  if(!pcstructure.isHidden()){
						   					  grid = pcstructure;
						   				  }
						   				  $this.getMultipleGridHeaderFreeze(grid,structure,true);
										 });
								 }
							},
						});
					},

//					open recruiting org window

					getRecruitingOrgGridWindow : function(grid,record){
						var $this=this;
						var placementCampusId = record.get("id");
						var formWindow = $this.getRecruitingorggridwindow();
						if (!formWindow) {
							Ext.widget('recruitingorggridwindow');
							formWindow = $this.getRecruitingorggridwindow();
						}
						formWindow.show();

						var grid = formWindow.down('#recruitmentOrgGrid');
						var store = grid.getStore();
						store.getProxy().extraParams = {
							placementCampusId: placementCampusId,
						};
						store.load();
					},

//					open Academic org window

					getAcademicOrgGridWindow : function(grid,record){
						var $this=this;
						var placementCampusId = record.get("id");
						var formWindow = $this.getAcademicorggridwindow();
						if (!formWindow) {
							Ext.widget('academicorggridwindow');
							formWindow = $this.getAcademicorggridwindow();
						}		                            	 
						formWindow.show();

						var grid = formWindow.down('#academicOrgGrid');
						var store = grid.getStore();
						store.getProxy().extraParams = {
							placementCampusId: placementCampusId,
						};
						store.load();
					},
//					open Period Grid window
					getPeriodCountGridWindow:function(grid,record){
						var $this=this;
						var placementCampusId = record.get("id");
						var formWindow = $this.getPlacementcampusperiodgridwindow();
						if (!formWindow) {
							Ext.widget('placementcampusperiodgridwindow');
							formWindow = $this.getPlacementcampusperiodgridwindow();
						}		                            	 
						formWindow.show();

						var grid = formWindow.down('#periodGridWin');
						var store = grid.getStore();
						store.getProxy().extraParams = {
							placementCampusId: placementCampusId,
						};
						store.load();
					},
//					open Period Grid window
					getdocumentCountGridWindow:function(grid,record){
						var $this=this;
						var placementCampusId = record.get("id");
						var formWindow = $this.getPlacementcampusdocumentgridwindow();
						if (!formWindow) {
							Ext.widget('placementcampusdocumentgridwindow');
							formWindow = $this.getPlacementcampusdocumentgridwindow();
						}		                            	 
						formWindow.show();

						var grid = formWindow.down('#documentGridWin');
						var store = grid.getStore();
						store.getProxy().extraParams = {
							placementCampusId: placementCampusId,
						};
						store.load();
					},		                             

					mapUnmapALRecrutingOrg:function(){
						var submitData;
						var $this = this;
						var placementGrid = $this.getPlacementcampusgrid();
						var placementID = placementGrid.getSelectionModel().getSelection()[0].data.id;
						var grid = $this.getPlacementcampusrecruitingorganizationgrid();
						var submitValue =new Array();
						if (grid.getSelectionModel().getCount() > 0) {
//							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
var records = grid.getSelectionModel().getSelection();
var oldMapping = grid.getCode();
if(oldMapping.length==records.length){
	showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_DESELECT_RECORD'));
	return;
}
for(var i in records){
	var flag = true;
	if(oldMapping!= undefined && oldMapping.length != 0){
		for (var j in oldMapping){
			if(oldMapping[j].data.academyLocation.id==records[i].data.academyLocation.id){
				flag = false;
				break;
			}
		}
	}
	if(flag){
		submitData={"placementCampusId":placementID,
				"academyLocationId" :records[i].data.academyLocation.id,
				"isMapped":true};
		submitValue.push(submitData);
	}	                        			  
}
if(oldMapping!= undefined && oldMapping.length != 0){
	for (var j in oldMapping){
		var flag = false;
		for(var i in records){
			if(oldMapping[j].data.academyLocation.id==records[i].data.academyLocation.id){
				flag = true;
			} 
		}
		if(!flag){
			submitData={"placementCampusId":placementID,
					"academyLocationId" :oldMapping[j].data.academyLocation.id,
					"isMapped":false};
			submitValue.push(submitData);
		}
	}
}
if(submitValue.length!=0){
	var submitUrl=SERVERURL.PATH_PLACEMENT_RECRUTING_ORG_UPDATE_LIST;
	Ext.Ajax.request({
		type : 'rest',
		url : submitUrl,
		jsonData : submitValue,
		method : 'POST',
		success : function(form, action) {
			Ext.getBody().unmask();
			if(form.responseText=="DEPENDENCY_EXIST"){
				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DEPENDENT_RECORD_EXISTS'));
			} else {
				showSuccessMessage(getPlacementTranslation('RECRUITING_ORGANIZATION'),getCommonTranslation('SUCCESS'));
			}

			/* grid.getStore().getProxy().extraParams ={
	                  								  	evaluationPlanId:evaluationPlanId
	                  					        	 };
	                  	  							var arr = [];
	                  	  							grid.getStore().load({
	                  									callback: function(records, operation, success) {
	                  	        	            			   if (success) {
	                  	        	            				   if(records.length > 0){
	                  	        	            					   grid.getSelectionModel().deselectAll();
	                  	        	            					   for(i in records)
	                  	        	            					   if(records[i].data.isMapped){
	                  	        	            						   arr.push(records[i]);
	                  	        	            						   grid.getSelectionModel().select(records[i],true);
	                  	        	            					   }
	                  	        	            				   }
	                  	        	            				   var form =  $this.getEvaluationplanbasicdetailform();
	                  	        	            				   form.setCode(arr);
	                  	        	            			   }
	                  	        	            		   }	   
	                  								});*/
		}
	});
}
						} else{
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						}  
					},

					mapUnmapALAcademicOrg:function(){
						var submitData;
						var $this = this;
						var placementGrid = $this.getPlacementcampusgrid();
						var placementID = placementGrid.getSelectionModel().getSelection()[0].data.id;
						var grid = $this.getPlacementcampusacademicorganizationgrid();
						var submitValue =new Array();
						if (grid.getSelectionModel().getCount() > 0) {
							//Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
							var records = grid.getSelectionModel().getSelection();
							var oldMapping = grid.getCodeAL();
							if(oldMapping.length==records.length){
								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_DESELECT_RECORD'));
								return;
							}
							for(var i in records){
								var flag = true;
								if(oldMapping!= undefined && oldMapping.length != 0){
									for (var j in oldMapping){
										if(oldMapping[j].data.academyLocation.id==records[i].data.academyLocation.id){
											flag = false;
											break;
										}
									}
								}
								if(flag){
									submitData={"placementCampusId":placementID,
											"academyLocationId" :records[i].data.academyLocation.id,
											"isMapped":true};
									submitValue.push(submitData);
								}
							}
							if(oldMapping!= undefined && oldMapping.length != 0){
								for (var j in oldMapping){
									var flag = false;
									for(var i in records){
										if(oldMapping[j].data.academyLocation.id==records[i].data.academyLocation.id){
											flag = true;
										} 
									}
									if(!flag){
										submitData={"placementCampusId":placementID,
												"academyLocationId" :oldMapping[j].data.academyLocation.id,
												"isMapped":false};
										submitValue.push(submitData);
									}
								}
							}
							if(submitValue.length!=0){
								var submitUrl=SERVERURL.PATH_PLACEMENT_ACADEMIC_ORG_UPDATE_LIST;
								Ext.Ajax.request({
									type : 'rest',
									url : submitUrl,
									jsonData : submitValue,
									method : 'POST',
									success : function(form, action) {
										Ext.getBody().unmask();
										showSuccessMessage(getPlacementTranslation('ACADEMIC_ORGANIZATION'),getCommonTranslation('SUCCESS'));
										/* grid.getStore().getProxy().extraParams ={
	                  								  	evaluationPlanId:evaluationPlanId
	                  					        	 };
	                  	  							var arr = [];
	                  	  							grid.getStore().load({
	                  									callback: function(records, operation, success) {
	                  	        	            			   if (success) {
	                  	        	            				   if(records.length > 0){
	                  	        	            					   grid.getSelectionModel().deselectAll();
	                  	        	            					   for(i in records)
	                  	        	            					   if(records[i].data.isMapped){
	                  	        	            						   arr.push(records[i]);
	                  	        	            						   grid.getSelectionModel().select(records[i],true);
	                  	        	            					   }
	                  	        	            				   }
	                  	        	            				   var form =  $this.getEvaluationplanbasicdetailform();
	                  	        	            				   form.setCode(arr);
	                  	        	            			   }
	                  	        	            		   }	   
	                  								});*/
									}
								});
							}else{
								Ext.getBody().unmask();
							}
						} else{
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						}  
					},
					openRecruitingOrganization:function(){
						var $this=this;
						var tabName = getPlacementTranslation('APPLY_TO');
						var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
						var structure = Ext.widget('placementcampusapplytostructure');
						/**
						 * This is to remove tab from content panel and open same tab again
						 */
						var getcontroller=this.getController('menu.CoreERPNavigationController');
						var getTab=getcontroller.getTab(tabName);
						var $this=this;
						var filterGrid = $this.getPlacementcampusgrid();
						var record = filterGrid.getSelectionModel().getSelection()[0];

						var grid = $this.getPlacementcampusrecruitingorganizationgrid();
						grid.getStore().getProxy().extraParams={
							placementCampusId:record.data.id,
							purpose:'PLACEMENT'
						};
						Ext.apply(grid,{
							code:null,
							setCode : function(code){
								grid.code = code;
							},
							getCode:function(){
								return grid.code;
							}
						});
						var arr = [];
						grid.getStore().load({
							callback: function(records, operation, success) {
								if (success) {
									if(records.length > 0){
										if(grid.getSelectionModel().getCount()>0){
											grid.getSelectionModel().deselectAll();
										}
										for(i in records){
											if(records[i].data.isMapped){
												grid.getSelectionModel().select(records[i],true);
												arr.push(records[i]);
											}
										}
									}		 
								}
							}	   
						});
						grid.setCode(arr);
						if(getTab!=null){
							contentPanel.remove(getTab, true);
						}
						openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_ONE);
					},
					openApplyToProgramPeriod:function(){
						var $this=this;
						var tabName = getCommonTranslation('PROGRAM_PERIODS');
						var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
						var structure = Ext.widget('placementcampusapplytoprogramperiodstructure');
						/**
						 * This is to remove tab from content panel and open same tab again
						 */
						var getcontroller=this.getController('menu.CoreERPNavigationController');
						var getTab=getcontroller.getTab(tabName);
						var $this=this;
						var filterGrid = $this.getPlacementcampusgrid();
						var record = filterGrid.getSelectionModel().getSelection()[0];

						Ext.apply(contentPanel, {
							jobPlacementCampusId: null,
							setJobPlacementCampusId: function(jobPlacementCampusId) {
								contentPanel.jobPlacementCampusId = jobPlacementCampusId;
							},
							getJobPlacementCampusId: function() {
								return contentPanel.jobPlacementCampusId;
							}
						});
						contentPanel.setJobPlacementCampusId(record.data.id);

						var grid = $this.getPlacementcampusapplytoprogramperiodgrid();
	                      grid.getStore().getProxy().extraParams={
							placementCampusId:record.data.id
						};
						grid.getStore().load();
						if(getTab!=null){
							contentPanel.remove(getTab, true);
						}
						openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_ONE);
					},
					loadPlacementCampusGrid:function(){
						var $this=this;
						var form = $this.getPlacementcampusfilter();
						var intakeYearId = form.down("#intakeYearPlcDriveId").getValue();
						var placementId = form.down("#placementcampusItemId").getValue();
						var placementTypeId = form.down("#placementtypeItemId").getValue();
						var recruitingOrganizationALId = form.down("#academyLocation").getValue();
						var academyLocationId = form.down("#organizingAcademyLocation").getValue();
						var campusCoordinatorId = form.down("#campusCoordinator").getValue();
						var programId = form.down("#programId").getValue();
						var batchId = form.down("#batchId").getValue();
						var periodId = form.down("#periodId").getValue();
						var startDate = form.down("#startDate").getValue();
						var endDate = form.down("#endDate").getValue();
						var grid = $this.getPlacementcampusgrid();
						var values = form.getForm().getValues();
						var store =  grid.getStore();
						store.getProxy().extraParams = {
							placementCampusId: placementId,
							placementTypeId: placementTypeId,
							recruitingOrganizationALId: recruitingOrganizationALId,
							academyLocationId: academyLocationId,
							placementCampusCoordinatorId:campusCoordinatorId,
							programId: programId,
							batchId: batchId,
							periodId: periodId,
							startDate: values.startDate,
							endDate: values.endDate,
							intakeYear:intakeYearId
						};
						$this.resetPageSetting(store);
						store.load();
					},cancelPlacementCampusWindow:function(){
						this.getPlacementcampusapplytoprogramperiodform().close();  

					},cancelPlacementCampusWindowEdit:function(){
						this.getPlacementcampusapplytoprogramperiodeditform().close();  

					}, 
					resetPlacementCampusFilter:function(){
						this.getPlacementcampusfilter().getForm().reset();
						var form = this.getPlacementcampusfilter();
						var progamField=form.down('#programId');
						progamField.setDisabled(true);
						var batchField=form.down('#batchId');
						batchField.setDisabled(true);
						var periodField=form.down('#periodId');
						periodField.setDisabled(true);
						
						var grid = this.getPlacementcampusgrid();  
						var exportBtn=grid.down('#exportPlacementFollowUpReport');
						exportBtn.setDisabled(true);


					},
					resetPlacementCampusForm:function(){
						var form = this.getPlacementcampusform().getForm().reset();
					},
					deletePlacementCampusProgramPeriodRecord:function(){
						var $this=this;
						var grid = $this.getPlacementcampusapplytoprogramperiodgrid();
						if (grid.getSelectionModel().getCount() > 0) {
							showConfirmMessage(getPlacementTranslation('PROGRAM_PERIOD'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
								if (btn == 'yes') {
									Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
									var records = grid.getSelectionModel().getSelection();
									var id = records[0].get("id");
									Ext.Ajax.request({
										method : "DELETE",
										type : 'rest',
										url : SERVERURL.PLACEMENT_CAMPUS_PERIOD_DELETE+'?id='+ id,
										headers : {
											'Content-Type' : 'application/json'
										},
										success : function(form,action) {
											Ext.getBody().unmask();
											grid.getStore().reload();
											showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
										}

									});
								}
							});
						}else {
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						} 

					},
					deletePlacementCampusRecord:function(){
						var $this=this;
						var grid = $this.getPlacementcampusgrid();
						if (grid.getSelectionModel().getCount() > 0) {
							showConfirmMessage(getCommonTranslation('PATH_PLACEMENT_CAMPUS'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
								if (btn == 'yes') {
									Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
									var records = grid.getSelectionModel().getSelection();
									var id = records[0].get("id");
									Ext.Ajax.request({
										method : "DELETE",
										type : 'rest',
										url : SERVERURL.PATH_PLACEMENT_CAMPUS_DELETE+'?id='+ id,
										headers : {
											'Content-Type' : 'application/json'
										},
										success : function(form,action) {
											Ext.getBody().unmask();
											grid.getStore().reload();
											showSuccessMessage(getPlacementTranslation('PATH_PLACEMENT_CAMPUS'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_DELETED_SUCCESSFULLY'));
										}

									});
								}
							});
						}else {
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						}
					},
					addProgramPeriodedit:function(obj){
						

						var $this = this;
//						var win  = this.getPlacementCampusapplytoProgramperiodWin();

						var window = $this.getPlacementcampusapplytoprogramperiodeditform();
						var form=window.down('idgeneratorformwin');
						var getForm = form.getForm();
						var values = getForm.getValues();
						var grid = $this.getPlacementcampusapplytoprogramperiodgrid();
//						var placementcampusperiodmodel = new Academia.model.placement.placementcampus.PlacementCampusApplyToProgramPeriodWindowModel();
						var filterGrid = $this.getPlacementcampusgrid();
						var record = filterGrid.getSelectionModel().getSelection()[0];
//						placementcampusperiodmodel.set("placementCampusId",record.data.id);
//						placementcampusperiodmodel.set("periodId",values.periodName.id);
						var json= new Object;
						var jsonData = [];
//						if(values.periodName.length != undefined){
//						for( var i = 0; i < values.periodName.length; i++) {
//			    			json = {
//			    					"id":values.id,
//			    					"placementCampusId":record.data.id,
//									"periodIds":$this.getIdValueJson(values.periodName[i].data.id),
//				   					
//				   			};
//			    			jsonData.push(json);
//			    		}
//						}else{
							json = {
			    					"id":values.id,
			    					"placementCampusId":record.data.id,
									"periodIds":values.periodName,
				   			};
			    			jsonData.push(json);
//						}
			    	
			    	var requestJSON = {};	
			    	requestJSON=jsonData;
					
						
//						if(!isNullOrEmpty(values.id)){
							submitUrl = SERVERURL.PLACEMENT_CAMPUS_PERIOD_UPDATE; 
//							placementcampusperiodmodel.set("id",values.id);
							message = getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_UPDATED_SUCCESSFULLY')
//						}
//						else{
//							submitUrl = SERVERURL.PLACEMENT_CAMPUS_PERIOD_CREATE; 
//							message = getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_CREATED_SUCCESSFULLY');
//						}

//						delete placementcampusperiodmodel.data.academyLocationName;
//						delete placementcampusperiodmodel.data.programName;
//						delete placementcampusperiodmodel.data.batchName;
//						delete placementcampusperiodmodel.data.periodName;

						var formData = Ext.encode(requestJSON);

						var submitUrl; 
						var message;
						Ext.Ajax.request({
							type : 'rest',
							url : submitUrl,
							jsonData : formData,
							method : 'POST',
							success : function(frm, action) {
								Ext.getBody().unmask();
								grid.getStore().reload(); 
								window.close();
								showSuccessMessage(getPlacementTranslation('ADD_PROGRAM_PERIOD'), message);
							}
						});
					
						
						
					},
					addProgramPeriod:function(obj){
						var $this = this;
						var win  = this.getPlacementCampusapplytoProgramperiodWin();

						var form = $this.getPlacementCampusApplyoProgramperiodForm();
						var getForm = form.getForm();
						var values = getForm.getValues();
						var grid = $this.getPlacementcampusapplytoprogramperiodgrid();
//						var placementcampusperiodmodel = new Academia.model.placement.placementcampus.PlacementCampusApplyToProgramPeriodWindowModel();
						var filterGrid = $this.getPlacementcampusgrid();
						var record = filterGrid.getSelectionModel().getSelection()[0];
//						placementcampusperiodmodel.set("placementCampusId",record.data.id);
//						placementcampusperiodmodel.set("periodId",values.periodName.id);
						var json= new Object;
						var jsonData = [];
						if(values.periodName.length != undefined){
						for( var i = 0; i < values.periodName.length; i++) {
			    			json = {
			    					"id":values.id,
			    					"placementCampusId":record.data.id,
									"periodIds":$this.getIdValueJson(values.periodName[i].data.id),
				   					
				   			};
			    			jsonData.push(json);
			    		}
						}else{
							json = {
			    					"id":values.id,
			    					"placementCampusId":record.data.id,
									"periodIds":$this.getIdValueJson(values.periodName),
				   			};
			    			jsonData.push(json);
						}
			    	
			    	var requestJSON = {};	
			    	requestJSON=jsonData;
					
						
						if(!isNullOrEmpty(values.id)){
							submitUrl = SERVERURL.PLACEMENT_CAMPUS_PERIOD_UPDATE; 
//							placementcampusperiodmodel.set("id",values.id);
							message = getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_UPDATED_SUCCESSFULLY')
						}
						else{
							submitUrl = SERVERURL.PLACEMENT_CAMPUS_PERIOD_CREATE; 
							message = getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_CREATED_SUCCESSFULLY');
						}

//						delete placementcampusperiodmodel.data.academyLocationName;
//						delete placementcampusperiodmodel.data.programName;
//						delete placementcampusperiodmodel.data.batchName;
//						delete placementcampusperiodmodel.data.periodName;

						var formData = Ext.encode(requestJSON);

						var submitUrl; 
						var message;
						Ext.Ajax.request({
							type : 'rest',
							url : submitUrl,
							jsonData : formData,
							method : 'POST',
							success : function(frm, action) {
								Ext.getBody().unmask();
								grid.getStore().reload(); 
								win.close();
								showSuccessMessage(getPlacementTranslation('ADD_PROGRAM_PERIOD'), message);
							}
						});
					},
					  getIdValueJson: function(id, value,code) {
					    	if (id) return {
					    		id: id,
					    		value: value,
					    		code: code
					    	};
					    },
					addPlacementCampusRecord:function(){
						var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
						var structure = Ext.widget('placementcampusform');
						var tabName = getPlacementTranslation('PLACEMENT_CAMPUS_CREATE');
						/**
						 * This is to remove tab from content panel and open same tab again
						 */
						var getcontroller=this.getController('menu.CoreERPNavigationController');
						var getTab=getcontroller.getTab(tabName);
						if(getTab!=null){
							contentPanel.remove(getTab, true);
						}
						openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_ONE);		
					},
					addPlacementCampusProgramPeriodWindow:function(){
						var contentPanel = this.getContentPanel();
						var placementCampusId = contentPanel.getJobPlacementCampusId();
						var formWindow = this.getPlacementcampusapplytoprogramperiodform();
						if (!formWindow) {
							Ext.widget('placementcampusapplytoprogramperiodform');
							formWindow = this.getPlacementcampusapplytoprogramperiodform();
						}
						formWindow.show();
						var win = this.getPlacementcampusapplytoprogramperiodform();
						var AL = win.down('#academyLocation');
						AL.getStore().getProxy().extraParams={
							purpose:'COURSE_EXECUTION',
							placementCampusId : placementCampusId
						};
						var AL = win.down('#programId');
						AL.getStore().getProxy().extraParams={
							purpose:'COURSE_EXECUTION'
						};
						/*var AL = win.down('#academyLocation');
	                        	   AL.getStore().getProxy().extraParams={
	                        		      purpose:'COURSE_EXECUTION'
	                        	   };*/
						AL.getStore().load();
					},
					viewPlacementCampusProgramPeriod:function(){
						this.editPlacementCampusPeriodRecord();
//						var form =  this.getPlacementCampusApplyoProgramperiodForm();
						var window=this.getPlacementcampusapplytoprogramperiodeditform();
						
						var form=window.down('idgeneratorformwin');
						
						var applytoprogramperiodform = form.getForm();
						this.toggleReadOnlyFormItems(applytoprogramperiodform,true);
						form.down('#SubmitBtn').setVisible(false);

					},
					viewPlacementCampusRecord:function(){
						this.editPlacementCampusRecord();
						var form =  this.getPlacementcampusform();
						var placementcampusform = form.getForm();
						this.toggleReadOnlyFormItems(placementcampusform,true);
						form.down('#submitBtn').setVisible(false);


					},
					savePlacementCampusRecord: function(){

						var $this = this;
						var placementcampusform = $this.getPlacementcampusform();
						var grid = $this.getPlacementcampusgrid();
						var form = placementcampusform.getForm();
						var value = form.getValues();
						var placementcampusmodel = new Academia.model.placement.placementcampus.PlacementCampusCreateModel();
						var Drools= form.findField('droolsRule').getRawValue();
						var intake={
								"id":value.intakeYearPlcDriveId
						};
						var droolId=form.findField('droolsRule').getValue();
						var jobStatusItemVal = form.findField('JobStatusItem').getValue();
						placementcampusmodel.set("campusCode",value.campusCode);
						placementcampusmodel.set("campusName",value.campusName);
						placementcampusmodel.set("intakeYear",intake);
						placementcampusmodel.set("placementType",value.placementType);
						placementcampusmodel.set("campusCoordinator",value.campusCoordinator);
						placementcampusmodel.set("startDate",value.startDate);
						placementcampusmodel.set("endDate",value.endDate);
						placementcampusmodel.set("organizingAcademyLocation",value.organizingAcademyLocation);
						placementcampusmodel.set("status",value.status);
						placementcampusmodel.set("droolsRule",Drools);
						placementcampusmodel.set("droolId",droolId);
						placementcampusmodel.set("whetherDocumentRequired",value.documentRequired);
						placementcampusmodel.set("whetherAllowed",jobStatusItemVal);
						placementcampusmodel.set("remarks",value.remarks);
						placementcampusmodel.set("placementMOD",value.placementMOD);
						
						placementcampusmodel.set("activityDurationType",value.activityDurationType);
						placementcampusmodel.set("activityTypeIdentifier",value.activityTypeIdentifier);
						placementcampusmodel.set("country",$this.getIdValueJson(value.country));
						placementcampusmodel.set("hostIdentifier",value.hostIdentifier);
						placementcampusmodel.set("hostIdentifierType",value.hostIdentifierType);
						placementcampusmodel.set("mobileScheme",$this.getIdValueJson(value.mobilityScheme));
						placementcampusmodel.set("moduleInstanceIdentifier",value.moduleInstanceIdentifier);

						if(value.documentRequired){
							var multipledocumentCount = value.documentCount;
							var myJsonData=[];
							for(var i in multipledocumentCount){
								if(Ext.isObject(multipledocumentCount[0])){
									myJsonData.push({'placementDocumentMaster':$this.getIdJson(multipledocumentCount[i].get("id"))});
								}else{
									myJsonData.push({'placementDocumentMaster':$this.getIdJson(multipledocumentCount[i])});
								}
							}
							placementcampusmodel.set("placementCampusDocuments",myJsonData);
						}else{
							placementcampusmodel.set("placementCampusDocuments",null);
						}

						if(!isNullOrEmpty(value.id)){
							submitUrl = SERVERURL.PATH_PLACEMENT_CAMPUS_UPDATE; 
							placementcampusmodel.set("id",value.id);
							message = getPlacementTranslation('PATH_PLACEMENT_CAMPUS_UPDATED_SUCCESSFULLY')
						}
						else{
							submitUrl = SERVERURL.PATH_PLACEMENT_CAMPUS_SAVE; 
							message = getPlacementTranslation('PATH_PLACEMENT_CAMPUS_CREATED_SUCCESSFULLY');
						}
						var formData = Ext.encode(placementcampusmodel.data);

						var submitUrl; 
						var message;
						Ext.Ajax.request({
							type : 'rest',
							url : submitUrl,
							jsonData : formData,
							method : 'POST',
							success : function(frm, action) {
								Ext.getBody().unmask();
								grid.getStore().reload(); 
								if(isNullOrEmpty(value.id)){
									form.reset();
								}
								showSuccessMessage(getPlacementTranslation('PATH_PLACEMENT_CAMPUS'), message);
							}
						});

					},         //************* edit Placement details records********************
					editPlacementCampusRecord:function(){
						var $this = this;
						var grid = $this.getPlacementcampusgrid();
						if (grid.getSelectionModel().getCount() > 0) {
							$this.addDriveAndFollowUpDetail();
							var placementcampusform = $this.getPlacementcampusform();
							placementcampusform.down('#resetBtn').setVisible(false);
							var record = grid.getSelectionModel().getSelection()[0];
							var id = record.get("id");
							var editUrl = SERVERURL.PLACEMENT_CAMPUS_FINDBYID;
							Ext.Ajax.request({
								method: "GET",
								type: 'rest',
								url: editUrl,
								params: {
									id: id
								},
								success: function(f, action) {
									var data = Ext.JSON.decode(f.responseText);
									var dataModel = new Academia.model.placement.placementcampus.PlacementCampusModel(data);
									placementcampusform.loadRecord(dataModel);
									placementcampusform.down('#startDate').setValue(dateRender(data.startDate));
									placementcampusform.down('#endDate').setValue(dateRender(data.endDate));
									var placementDOC=placementcampusform.down('#documentRequired');
									var placementOffer=placementcampusform.down('#JobStatusItem');
									if(data.whetherDocumentRequired){
										placementDOC.items.items[0].setValue(true);
										placementDOC.items.items[1].setValue(false);
									}else{
										placementDOC.items.items[0].setValue(false);
										placementDOC.items.items[1].setValue(true);
									}
									if(data.whetherAllowed){
										placementOffer.items.items[0].setValue(true);
										placementOffer.items.items[1].setValue(false);
										placementOffer.setDisabled(true);
									}else{
										placementOffer.items.items[0].setValue(false);
										placementOffer.items.items[1].setValue(true);
										placementOffer.setDisabled(true);
									}
									var documentCount = data.placementCampusDocuments;
									var selectedDocuments=[];
									if(documentCount.length>0){
										for(var i in documentCount){

											selectedDocuments.push(documentCount[i].placementDocumentMaster.id);
										} 
									}
									if(!isNullOrEmpty(data.droolId)){
										var placementCampusdroolsRule =  placementcampusform.down("#droolsRule");
										placementCampusdroolsRule.getStore().load({
											callback: function(records, operation, success) {
												for(var i in records){
													if(data.droolId==records[i].data.id){
														placementCampusdroolsRule.setValue(records[i].data.id);
													}
												}

											}
										});
									}
									var documentCountField = placementcampusform.down("#documentCount");
									documentCountField.getStore().load({
										callback: function(records, operation, success) {
											documentCountField.setValue(selectedDocuments);
										}
									});
									var intakeYearPlcDriveId = placementcampusform.down("#intakeYearPlcDriveId");
									intakeYearPlcDriveId.getStore().load({
										callback: function(records, operation, success) {
											for(var i in records){
												if(!isNullOrEmpty(data.intakeYear)) {
													if(data.intakeYear.id==records[i].data.id){
														intakeYearPlcDriveId.setValue(data.intakeYear.id);
													}
												}
											}
										}
									});
									
									placementcampusform.down('#moduleInstanceIdentifierItemId').setValue(data.moduleInstanceIdentifier);
									
									if(!isNullOrEmpty(data.activityDurationType)){
										var activityDurationTypeItem =  placementcampusform.down("#activityDurationTypeItemId");
										activityDurationTypeItem.getStore().load({
											callback: function(records, operation, success) {
												for(var i in records){
													if(data.activityDurationType.id==records[i].data.id){
														activityDurationTypeItem.setValue(records[i].data.id);
													}
												}

											}
										});
									}
									if(!isNullOrEmpty(data.activityTypeIdentifier)){
										var activityTypeIdentifierItem =  placementcampusform.down("#activityTypeIdentifierItemId");
										activityTypeIdentifierItem.getStore().load({
											callback: function(records, operation, success) {
												for(var i in records){
													if(data.activityTypeIdentifier.id==records[i].data.id){
														activityTypeIdentifierItem.setValue(records[i].data.id);
													}
												}

											}
										});
									}
									if(!isNullOrEmpty(data.country)){
										var countryItem =  placementcampusform.down("#countryItemId");
										countryItem.getStore().load({
											callback: function(records, operation, success) {
												for(var i in records){
													if(data.country.id==records[i].data.id){
														countryItem.setValue(records[i].data.id);
													}
												}

											}
										});
									}
									if(!isNullOrEmpty(data.hostIdentifier)){
										var hostIdentifierItem =  placementcampusform.down("#hostIdentifierItemId");
										hostIdentifierItem.getStore().load({
											callback: function(records, operation, success) {
												for(var i in records){
													if(data.hostIdentifier.id==records[i].data.id){
														hostIdentifierItem.setValue(records[i].data.id);
													}
												}

											}
										});
									}
									if(!isNullOrEmpty(data.hostIdentifierType)){
										var hostIdentifierTypeItem =  placementcampusform.down("#hostIdentifierTypeItemId");
										hostIdentifierTypeItem.getStore().load({
											callback: function(records, operation, success) {
												for(var i in records){
													if(data.hostIdentifierType.id==records[i].data.id){
														hostIdentifierTypeItem.setValue(records[i].data.id);
													}
												}

											}
										});
									}
									if(!isNullOrEmpty(data.mobileScheme)){
										var mobilitySchemeItem =  placementcampusform.down("#mobilitySchemeItemId");
										mobilitySchemeItem.getStore().load({
											callback: function(records, operation, success) {
												for(var i in records){
													if(data.mobileScheme.id==records[i].data.id){
														mobilitySchemeItem.setValue(records[i].data.id);
													}
												}

											}
										});
									}
									 
								}
							});
						}else{
							showWarningMessage(getPlacementTranslation('PATH_PLACEMENT_CAMPUS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
						}
					},
					editPlacementCampusPeriodRecord:function(){
						var $this = this;
						var grid = $this.getPlacementcampusapplytoprogramperiodgrid();

						if (grid.getSelectionModel().getCount() > 0) {
//							$this.addPlacementCampusProgramPeriodWindow();
							var window= this.getPlacementcampusapplytoprogramperiodeditform();
							if (!window) {
								Ext.widget('placementcampusapplytoprogramperiodeditform');
								window= this.getPlacementcampusapplytoprogramperiodeditform();
							}
							window.show();
							var form=window.down('idgeneratorformwin');
//							var form1 = this.getPlacementCampusApplyoProgramperiodForm();
							var record = grid.getSelectionModel().getSelection()[0];
							var id = record.get("id");
							var editUrl = SERVERURL.PLACEMENT_CAMPUS_PERIOD_FINDBYID;
							Ext.Ajax.request({
								method: "GET",
								type: 'rest',
								url: editUrl,
								params: {
									id: id
								},
								success: function(f, action) {
									var data = Ext.JSON.decode(f.responseText);
									var dataModel =  new Academia.model.placement.placementcampus.PlacementCampusApplyToProgramPeriodWindowModel(data);
									form.loadRecord(dataModel);

									if(data.academyLocationId){
										var academyLocation =  form.down("#academyLocation");
										academyLocation.getStore().load({
											callback: function(records, operation, success) {
												academyLocation.setValue(data.academyLocationId);
											}
										});
										// form.down("#academyLocation").setValue(dataModel.data.academyLocationName.value);
									}
									if(data.programId){
										var program =  form.down("#programId");
										program.setDisabled(false);
										program.getStore().getProxy().extraParams={
											academyLocationId:data.academyLocationId
										};
										program.getStore().load({
											callback: function(records, operation, success) {
												for(var i  in records){
													if(data.programId==records[i].data.id)
														program.setValue(records[i].data.id);
												}
											}
										});
									}
									if(data.batchId){
										var batch =  form.down("#batchId");
										batch.setDisabled(false);
										batch.getStore().getProxy().extraParams={
											programId:data.programId
										};
										batch.getStore().load({
											callback: function(records, operation, success) {
												batch.setValue(data.batchId);
											}
										});
									}
									if(data.periodId){
										var period =  form.down("#periodId");
										period.setDisabled(false);
										period.getStore().getProxy().extraParams={
											batchId:data.batchId
										};
										period.getStore().load({
											callback: function(records, operation, success) {
												period.setValue(data.periodId);
											}
										}); 
									}
								}
							});
						}else{
							showWarningMessage(getPlacementTranslation('ADD_PROGRAM_PERIOD'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
						}
					},
					createJson: function(){
						// Create required json to Save
						var json= "";
						return json;	
					},
					getIdJson: function(id) {
						if (id) return {
							id: id
						};
					},
					loadPlacementDriveGrid:function(grid){
						var $this=this;
						var studentId=$this.getCurrentlyLoggedInUser().id;
						var academyLocation;
						var programId=$this.getCurrentlyLoggedInUserInfoForPortal().programBatchDetails.programId;
						var store =  grid.getStore();
						var checkActiveDate = new Date();
						checkActiveDate = checkActiveDate.toISOString().split('.')[0];
						if(checkActiveDate.includes('T')){
							checkActiveDate = checkActiveDate.replace('T', ' ');
						}
						if (grid) {
							var store = grid.getStore();
							store.getProxy().extraParams = {
								programId: programId,
								checkActiveDate : checkActiveDate,
							};
							store.load();
						}
					},
					addDriveAndFollowUpDetail:function(){
						var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
						var structure = Ext.widget('placementcampusdetailstructure');
						var tabName = getPlacementTranslation('PATH_PLACEMENT_CAMPUS_DETAIL');
						/**
						 * This is to remove tab from content panel and open same tab again
						 */
						var getcontroller=this.getController('menu.CoreERPNavigationController');
						var getTab=getcontroller.getTab(tabName);
						if(getTab!=null){
							contentPanel.remove(getTab, true);
						}
						openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_ONE);		
					},
					savePlcDriveFollowUpDetail:function(){

						var this$ = this;
						var jsonFormFieldData = new Object();
						var form = this$.getPlacementcampusfollowupform();
						var grid = this$.getPlacementcampusgrid();
						var driveRecord = grid.getSelectionModel().getSelection()[0];
						var followupGrid = this$.getPlacementcampusfollowupgrid();
						var record = followupGrid.getSelectionModel().getSelection()[0];
						var submitUrl = SERVERURL.PATH_SAVE_DRIVE_FOLLOW_UP;
						var formData = form.getValues();
						var followUpDetail = new Academia.model.placement.placementcampus.PlacementDriveFollowUpDetailModel();

						var id = driveRecord.get("id");
						if (!isEmpty(formData)) {
							if( record!=undefined && !isNullOrEmpty(record.data.id)){
								followUPId=record.data.id;
								followUpDetail.set("id", followUPId);
							}

							var drive={
									"id":id
							};

							followUpDetail.set("drive", drive);

							var followUpUser={
									"id":this.getCurrentlyLoggedInUser().id
							};
							followUpDetail.set("followUpUser", followUpUser);

							var followUpActivityToObj = new Object();
							followUpActivityToObj.id = formData.plcfollowupActivityTo;
							formData.plcfollowupActivityTo = followUpActivityToObj;

							followUpDetail.set("followUpActivityTo", followUpActivityToObj.id);


							followUpDetail.set("followUpDate", new Date());
							followUpDetail.set("actualFollowUpDate", formData.plcDriveactualFollowUpDate);
							followUpDetail.set("remark", formData.plcDriveremark);
							followUpDetail.set("isLatestFollowUp", true);
							followUpDetail.set("reasonForFollowUp", formData.plcDriveReasonForFollowUp);
							followUpDetail.set("followupTime", formData.plcDrivefollowupTime);

							var followupNameObj = new Object();
							followupNameObj.id = formData.plcDrivefollowupname;
							formData.plcDrivefollowupname = followupNameObj.id;

							followUpDetail.set("followupName", followupNameObj.id);

							var activityTypeObj = new Object();
							activityTypeObj.id = formData.plcDrivefollowUpActivityType;
							formData.plcDrivefollowUpActivityType = activityTypeObj.id;

							followUpDetail.set("activityType", activityTypeObj.id);

							var followupStatusObj = new Object();
							followupStatusObj.id = formData.plcDrivefollowUpStatus;
							formData.plcDrivefollowUpStatus = followupStatusObj.id;

							followUpDetail.set("followupStatus", followupStatusObj.id);

							var userByAssignToObj = new Object();
							userByAssignToObj.id = formData.plcDriveuserByAssignTo;
							formData.plcDriveuserByAssignTo = userByAssignToObj.id;

							followUpDetail.set("userByAssignTo", userByAssignToObj.id);
							followUpDetail.set("nextFollowUpDate", formData.plcDrivenextFollowUpDate);
						}
						jsonFormFieldData = Ext.encode(followUpDetail.data);
						this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormFieldData, function(option, success, response) {
							//this$.applyWindowMask(); 
							if(success){
								var store = followupGrid.getStore();
								followupGrid.getSelectionModel().deselectAll();
								var store = followupGrid.getStore();
								store.getProxy().extraParams = {
									id:id
								};
								store.reload();
								if(record!=undefined && !isNullOrEmpty(record.data.id)){
									showSuccessMessage(getCommonTranslation('FOLLOW_UP_DETAIL'), getPlacementTranslation('FOLLOW_UP_DETAIL_UPDATE_SUCCESS'));
								}else{
									
									   showSuccessMessage(getCommonTranslation('FOLLOW_UP_DETAIL'), getPlacementTranslation('FOLLOW_UP_DETAIL_ADD_SUCCESS'));
								}
								form.getForm().reset();
								//this$.hideWindowMask();
							}
						});
						/*var store = followupGrid.getStore();
						store.getProxy().extraParams = {
							id:id
						};
						this$.resetGridSetting(followupGrid);
						this$.resetPageSetting(store);
						store.load();*/
						var saveBtn = followupGrid.down('#AddFollowUp');
						saveBtn.setDisabled(true);
						form.setDisabled(true);
					},
					setFollowUpDetailOnEdit:function(){
						var this$ = this;
						var grid = this$.getPlacementcampusfollowupgrid();
						if (grid.getSelectionModel().getCount() > 0) {
						var form = this$.getPlacementcampusfollowupform();
						form.setDisabled(false);
						var record = grid.getSelectionModel().getSelection()[0];
						var followUpName = form.down('#plcDrivefollowupname');
						followUpName.setValue(record.data.followupName);

						var plcDriveactualFollowUpDate = form.down('#plcDriveactualFollowUpDate');
						plcDriveactualFollowUpDate.setValue(dateRender(record.data.actualFollowUpDate));

						var plcDrivefollowupTime = form.down('#plcDrivefollowupTime');
						plcDrivefollowupTime.setValue( Ext.Date.format(new Date(), 'H:i'));
						/*if(!isNullOrEmpty(record.data.followupTime)){
							 var time = record.data.followupTime;
		                        var timeSplit = time.split(":");
		                        var finalTime = timeSplit[0]+":"+timeSplit[1];
		                        plcDrivefollowupTime.setValue(finalTime);
						}*/
						var plcDrivefollowupuser = form.down('#plcDrivefollowupuser');
						plcDrivefollowupuser.setValue(record.data.followUpUser.value);

						var plcfollowupActivityTo = form.down('#plcfollowupActivityTo');
						plcfollowupActivityTo.setValue(record.data.followUpActivityTo);
						
						/*var plcDriveemailAdress = form.down('#plcDriveemailAdress');
						plcDriveemailAdress.setValue(record.data.email);
						
						var plcDrivemobileNumber = form.down('#plcDrivemobileNumber');
						plcDrivemobileNumber.setValue(record.data.phoneNo);*/

						var plcDriveemailAdress = form.down('#plcDriveemailAdress');
						var plcDriveellCountryCode = form.down('#plcDriveellCountryCode');
						var plcDrivemobileNumber = form.down('#plcDrivemobileNumber');

						var plcDrivefollowUpActivityType = form.down('#plcfollowupActivityTo');

						var store = plcDrivefollowUpActivityType.getStore();
						/*store.getProxy().extraParams = {
							placementDriveId:record.data.followUpActivityTo.id
						};*/
						store.load({
							callback: function(records, operation, success) {
								for(var i in records){
								  if(!isNullOrEmpty(record.data.followUpActivityTo)){
									  if(records[i].data.id == record.data.followUpActivityTo.id){
											if(records.length>0){
												plcDriveemailAdress.setValue(records[i].data.address.primaryeEmailId);
												plcDriveellCountryCode.setValue(records[i].data.address.cellCountryCode);
												plcDrivemobileNumber.setValue(records[i].data.address.cellNo);
											}
										}
								  }
								}
							}
						});

						var plcDrivefollowUpActivityType = form.down('#plcDrivefollowUpActivityType');
						plcDrivefollowUpActivityType.setValue(record.data.activityType);

						var plcDriveReasonForFollowUp = form.down('#plcDriveReasonForFollowUp');
						plcDriveReasonForFollowUp.setValue(record.data.reasonForFollowUp);

						var plcDrivefollowUpStatus = form.down('#plcDrivefollowUpStatus');
						plcDrivefollowUpStatus.setValue(record.data.followupStatus);

						var plcDriveremark = form.down('#plcDriveremark');
						plcDriveremark.setValue(record.data.remark);

						if(record.data.nextFollowUpDate!=null ||  record.data.userByAssignTo!=null){

							var plcDrivewhetherNextFollowUp = form.down('#plcDrivewhetherNextFollowUp');
							plcDrivewhetherNextFollowUp.setValue({plcDrivewhetherNextFollowUp:true});
						}

						var plcDrivenextFollowUpDate = form.down('#plcDrivenextFollowUpDate');
						plcDrivenextFollowUpDate.setValue(record.data.nextFollowUpDate);

						var plcDriveuserByAssignTo = form.down('#plcDriveuserByAssignTo');
						plcDriveuserByAssignTo.setValue(record.data.userByAssignTo);
						}else
						{
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						}		

					},
					timeFormator : function(value){
						var time="";
						if(!isNullOrEmpty(value)){
							var model = new Academia.model.transport.serviceRoute.TimeDataModel;
							model.set('startTime',value);
							time=Ext.Date.format(model.get('startTime'), 'g:i A');
						}
						return time;
					},
					loadDFRForPlacementFollowUpDetails: function(addressDetailsform){
						var $this = this;
						var mobNumber=addressDetailsform.down('#plcDrivemobileNumber');
						var plcDrivewhetherNextFollowUp =addressDetailsform.down('#plcDrivewhetherNextFollowUp');
						var plcDriveuserByAssignTo =addressDetailsform.down('#plcDriveuserByAssignTo');
						var plcDrivenextFollowUpDate =addressDetailsform.down('#plcDrivenextFollowUpDate');
						Ext.Ajax.request({
							type: 'rest',
							async: false,
							url: SERVERURL.COMMON_FORM_FIELD_INFO,
							params: {
								screenName: 'placementcampusfollowupform',
								academyLocationId: $this.getCurrentAcademyLocation(),
								languageCode:'en'
							},
							method: 'GET',
							success: function(res, action) {
								var response = Ext.decode(res.responseText);
								if( Object.keys(response).length > 0 ){
									var records=response.placementcampusfollowupform;
									for(i in records){  
										if(records[i].formFieldInputType=='checkboxfield' && records[i].formFieldId=='plcDrivewhetherNextFollowUp' && records[i].isVisible==true){
											plcDrivewhetherNextFollowUp.setVisible(true);
										}

										if(records[i].formFieldId=='plcDriveuserByAssignTo' && records[i].isVisible==true){
											plcDriveuserByAssignTo.setVisible(false);
										}

										if(records[i].formFieldInputType=='datefield' && records[i].formFieldId=='plcDrivenextFollowUpDate' && records[i].isVisible==true){
											plcDrivenextFollowUpDate.setVisible(false);
										}
									}
								}
							}
						});
					},
					disableAndEnableExportBtn: function(grid,permissionsMap) {
				    	var associatedAcadLocationIds = new Array();
				    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
						var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
				    	
				    	var exportPlacementFollowUpReport = grid.down('#exportPlacementFollowUpReport');
				    	exportPlacementFollowUpReport.setVisible(false);
				    	
				    	Ext.each(permissionList, function(privilege) {
				    		if (privilege === 'EXPORT') {
				        		if(!isNullOrEmpty(exportPlacementFollowUpReport)){
				        			exportPlacementFollowUpReport.setVisible(true);
				        		}        		
				        	}
				    	});
				    },
					exportXlsPlacementFollowUpReport: function(){
						var $this = this;
						var form = $this.getPlacementcampusfilter().getForm();
						var values = form.getValues();
						var reportParams = new Object();
					
						reportParams.intakeYear = values.intakeYearPlcDriveId;
						reportParams.placementcampus = values.placementcampus;
						reportParams.placementtype = values.placementtype;
						reportParams.placementStartDate = values.startDate;
						reportParams.placementEndDate = values.endDate;
						
						reportParams.placementCampusCoordinator = values.campusCoordinator;
						reportParams.recruitingOrganizationAL = values.academyLocation;
						reportParams.academyLocation = values.organizingAcademyLocation;
						reportParams.program = values.programName;
						reportParams.batch = values.batchName;
						reportParams.period = values.periodName;

						var grid = this.getPlacementcampusgrid();
						var placementDriveArray=[];
						var record = grid.getSelectionModel().getSelection();
						for(var i in record) {
							placementDriveArray.push(record[i].data.id);
						}
						var placementDriveIds = placementDriveArray.join(',');
						reportParams.placementDriveIds = placementDriveIds;

							reportHeader = "FollowUp Details Report";
							reportTitle = "FollowUp Details Report";
							code = 'PLACEMENT_FOLLOWUP_DETAILS_REPORT';
							reportParams.code = code;
							//reportParams.status = values.STATUS;
							reportParams.headerName = reportHeader;
								$this.exportJRXMLReport(code,reportParams,code,'.vnd.ms-excel',SERVERURL.PATH_GENERATE_EXCEL_PLACEMENT_DRIVE_FOLLOWUP_REPORT);

					}

});
