/**
 * @author Vishal Joshi
 * 
 */
Ext.define('Academia.controller.placement.placementjobapplication.PlacementJobApplicationController', {
	extend: 'Academia.controller.base.BaseController',
	// un-comment the model code if required.
	models : ['course.QuestionPaperDocument'],
	stores : ['placement.placementjobapplication.PlacementJobApplicationGridStore',
	          'placement.placementcampus.PlacementCampusStore',
	          'placement.placementjobapplication.PlacementJobApplicationGetStudentGridStore',
	          'placement.placementjobapplication.PlacementJobApplicationROStore',
	          'placement.placementjobapplication.PlacementLocationStore',
	          'placement.placementjobapplication.PlacementJobApplicationTitleStore',
	          'placement.placementcampus.PlacementJobPostingROStore',
	          'placement.placementjobapplication.PlacementJobApplicationStatusStore',
	          'placement.placementjobapplication.PlacementJobApplicationStageStatusStore',
	          'placement.placementjobapplication.PlacementJobApplicationOfferStatusStore',
	          'placement.placementjobapplication.PlacementJobApplicationJoiningStatusStore',
	          'placement.placementjobapplication.PlacementJobApplicationBatchByProgramStore',
	          'placement.placementjobapplication.PlacementJobApplicationProgramStore',
	          'placement.placementjobapplication.PlacementJobApplicationStudentNameStore',
	          'placement.placementjob.PlacementJobLocationListStore','placement.placementjobapplication.PlacementJobOfferLetterGridStore',
	          'placement.placementcampus.placementCampusCoordinatorStore','course.QuestionPaperBankDocument',
	          'placement.placementjobapplication.PlacementJobApplicationDesignationStore',
	          'placement.placementjobapplication.PlacementAppliedJobGridStore','placement.placementjobapplication.PlacementJobLocationWindowStore',
	          'coursetransaction.studymaterialdistributionnew.UpdateStatusUploadDocSmdStr','placement.createcompany.CompanyCodeSearchStore',
	          'placement.placementjobapplication.PlacementAvailableJobApplicationGridStore','criteriabuilder.userquicksearch.QuickSearchName',
	          'placement.placementjobapplication.PlacementSelectionProcessStore','placement.placementcampus.PlacementCampusDocumentListStore',
	          'messaging.MessagingTemplatesStore','committee.committee.MessageTypeNotificationStore','messaging.StaticDocumentAttachmentGridStore',
	          'placement.placementjob.JobPostingDocumentStore','sponsorship.Sponsors','placement.placementjobapplication.ManageApplicationStatusGridStore'],
	          views : ['placement.placementjobapplication.PlacementJobApplicationTabStructure',
	                   'placement.placementjobapplication.PlacementJobApplicationStructure',
	                   'placement.placementjobapplication.PlacementJobApplicationFilter',
	                   'placement.placementjobapplication.PlacementJobApplicationGrid',
	                   'placement.placementjobapplication.PlacementJobApplicationForm',
	                   'placement.placementjobapplication.PlacementJobApplicationApplyJobGrid',
	                   'placement.placementjobapplication.PlacementJobApplicationJobApplyWindow',
	                   'placement.placementjobapplication.PlacementJobApplicationUpdateOfferWindow',
	                   'placement.placementjobapplication.PlacementJobApplicationJoiningStatusWindow',
	                   /*'messaging.sendmessage.SendMessageWindow'*/'placement.placementjobapplication.OfferLetterDownlodDocGrid',
	                   'placement.placementjob.PlacementAppliedJobPanel','placement.placementjob.PlacementJobOpeningsStructure',
	                   'placement.placementjob.PlacementAppliedJobFilter','placement.placementjob.PlacementAppliedJobGrid',
	                   'placement.placementjobapplication.PlacementJobLocationGridWindow','placement.placementjob.PlacementAvailableJobPanel','placement.placementjob.PlacementAvailableJobGrid',
	                   'placement.placementjob.PlacementAvailableJobFilter','placement.placementjobapplication.PlacementAvailableJobApplicationJobApplyWindow',
	                   'placement.placementjobapplication.PlacementJobDescriptionWindow','placement.placementjobapplication.PlacementSelectionProcessWindow',
	                   'placement.placementcampus.PlacementCampusDocumentGridWindow','placement.placementjobapplication.PlacementJobSendMessages','placement.placementjobapplication.PlacementJobStaticDocumentAttachmentGrid',
	                   'placement.placementjob.JobPostingDocumentWin', 'placement.placementjob.JobPostingDocumentWinGrid','placement.placementjobapplication.ManageApplicationStatusGrid'],
	                   alias : 'widget.academylocationpurposecontroller',
	                   config:{
	                	   PLACEMENT_JOB_APPLICATION_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PLACEMENT_JOB_APPLICATION_PRIVILEGES'),
	                	   STUDENT_AVAILABLE_JOBS_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PLACEMENT_AVAILABLE_JOBS_PRIVILEGES'),
	                	   STUDENT_APPLIED_JOBS_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PLACEMENT_APPLIED_JOBS_PRIVILEGES'),
	                	   APPLY_FOR_JOB_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLY_FOR_JOB_PRIVILEGES'),

	                   },
	                   refs : [
	                           {
	                        	   ref : 'placementjobapplicationstructure',
	                        	   selector : 'placementjobapplicationstructure'
	                           },{
	                        	   ref : 'placementjobapplicationfilter',
	                        	   selector : 'placementjobapplicationfilter'
	                           },{
	                        	   ref : 'placementjobapplicationjobapplywindow',
	                        	   selector : 'placementjobapplicationjobapplywindow'
	                           },{
	                        	   ref : 'placementjobapplicationupdateofferwindow',
	                        	   selector : 'placementjobapplicationupdateofferwindow'
	                           },{
	                        	   ref : 'placementjobapplicationjoiningstatuswindow',
	                        	   selector : 'placementjobapplicationjoiningstatuswindow'
	                           },{
	                        	   ref: 'placementjobapplicationgrid',
	                        	   selector: 'placementjobapplicationgrid[itemId=placementjobapplicationgridId]'
	                           },{
	                        	   ref: 'placementjobapplicationapplyjobgrid',
	                        	   selector: 'placementjobapplicationapplyjobgrid'
	                           },{
	                        	   ref: 'contentPanel',
	                        	   selector: 'contentPanel'
	                           },{
	                        	   ref: 'placementjobapplicationform',
	                        	   selector: 'placementjobapplicationform'
	                           }/*,{
	                        	   ref :'sendMessageWindow',
	                        	   selector : 'sendmessagewindow[itemId=placementSendMessageWindow]'
	                           }*/,{
	                        	   ref :'offerletterdownloddocgrid',
	                        	   selector : 'offerletterdownloddocgrid'
	                           },{
	                        	   ref :'placementavailablejobfilter',
	                        	   selector : 'placementavailablejobfilter'
	                           },{
	                        	   ref:'placementavailablejobgrid',
	                        	   selector : 'placementavailablejobgrid'
	                           },{
	                        	   ref:'placementavailablejobapplicationjobapplywindow',
	                        	   selector:'placementavailablejobapplicationjobapplywindow'	   
	                           },{
	               	        	   ref : 'placementjobopeningsstructure',
	            	        	   selector: 'placementjobopeningsstructure'
	                           },{
	                        	   ref : 'placementappliedjobfilter',
	                        	   selector: 'placementappliedjobfilter'
	                           },{
	                        	   ref : 'placementappliedjobgrid',
	                        	   selector: 'placementappliedjobgrid'
	                           },{
	                        	   ref : 'placementjoblocationgridwindow',
	                        	   selector: 'placementjoblocationgridwindow'
	                           },{
	                        	   ref:'placementjobdescriptionwindow',
	                        	   selector:'placementjobdescriptionwindow'
	                           },{
	                        	   ref:'placementselectionprocesswindow',
	                        	   selector:'placementselectionprocesswindow'
	                           },{
	                        	   ref: 'placementcampusdocumentgridwindow',
	                        	   selector: 'placementcampusdocumentgridwindow'
	                           },{
	                        	   ref :'placementjobsendmessages',
	                        	   selector : 'placementjobsendmessages[itemId=placementSendMessageWindow]'
	                           },{
	                        	   ref :'placementjobDocumentMessageAttachmentGrid',
	                        	   selector : 'placementjobstaticdocumentattachmentgrid[itemId=placementjobStaticDocumentAttachmentGridMessage]'
	                           },{
	                        	   ref :'jobpostingdocumentwin',
	                        	   selector : 'jobpostingdocumentwin'
	                           },{
	                        	   ref :'jobpostingdocumentwingrid',
	                        	   selector : 'jobpostingdocumentwingrid'
	                           },{
	                        	   ref:'manageapplicationstatusgrid',
	                        	   selector:'manageapplicationstatusgrid'
	                           }], 
	                           init : function() {
	                        	   this.control({
	                        		   'placementjobapplicationfilter button[itemId=searchBtn]': {
	                        			   click: this.loadPlacementJobApplicationGrid
	                        		   },
	                        		   'placementjobapplicationfilter button[itemId=resetBtn]': {
	                        			   click: this.resetPlacementJobApplicationFilter
	                        		   },
	                        		   'placementjobapplicationgrid button[itemId=btnDelete]':{
	                        			   click: this.deletePlacementJobApplicationRecord
	                        		   },
	                        		   'placementjobapplicationgrid button[itemId=addApplication]':{
	                        			   click: this.addPlacementJobApplicationRecord
	                        		   },
	                        		   'placementjobapplicationgrid button[itemId=sendMessage]':{
	                        			   click: this.openStudentSendMessage
	                        		   },
	                        		   'placementjobapplicationgrid button[itemId=btnView]':{
	                        			   click: this.viewPlacementJobApplicationRecord
	                        		   },
	                        		   'placementjobapplicationform button[itemId=submitBtn]':{
	                        			   click: this.savePlacementJobApplicationRecord
	                        		   },
	                        		   'placementjobapplicationupdateofferwindow button[itemId=SubmitBtn]':{
	                        			   click: this.savePlacementAppOfferRecord
	                        		   },
	                        		   'placementjobapplicationupdateofferwindow button[itemId=CancelBtn]':{
	                        			   click: this.CancelPlacementAppOfferWin
	                        		   },
	                        		   'placementjobapplicationjoiningstatuswindow button[itemId=CancelBtn]':{
	                        			   click: this.CancelPlacementJoiningStatusWin
	                        		   },
	                        		   'placementjobapplicationjoiningstatuswindow button[itemId=SubmitBtn]':{
	                        			   click: this.savePlacementJoiningStatusRecord
	                        		   },
	                        		   'placementjobapplicationform button[itemId=getStudentRecord]':{
	                        			   click: this.getPlacementJobApplicationStudentRecord
	                        		   },
	                        		   'offerletterdownloddocgrid button[itemId=btnDelete]':{
	                        			   click: this.deleteOfferletterdownloddocgrid
	                        		   },
	                        		   'placementjobapplicationjoiningstatuswindow customcombobox[itemId=confirmedBy]':{
	                        			   render: function(obj,rec) {
	                        				   var filterForm=obj.up('form');
	                        				   var confirmedByField=filterForm.down('#confirmedBy');
	                        				       confirmedByField.getStore().getProxy().extraParams={
	                        					   roleName:'FACULTY',
	                        					   academyLocationId:this.getCurrentAcademyLocation()
	                        				   }
	                        			   }
	                        		   },
	                        		   'placementjobapplicationjobapplywindow customcombobox[itemId=recruitingOrganization]':{
	                        			   select:function(obj,rec){
	                        				   var data=rec[0].data.id;  
	                        				   var filterForm=obj.up('form');
	                        				   var jobTitleField=filterForm.down('#jobtitle');
	                        				   jobTitleField.setDisabled(false);
	                        				   jobTitleField.reset();
	                        				   jobTitleField.getStore().getProxy().extraParams={
	                        					   placementCampusRecruitingOrgId:data
	                        				   };
	                        				   jobTitleField.getStore().load();
	                        			   }
	                        		   },
	                        		   'placementjobapplicationupdateofferwindow customcombobox[itemId=jobLocation]':{
	                        			   select:function(obj,rec){
	                        				   var data=rec[0].data.id;  
	                        				   var filterForm=obj.up('form');
	                        				   var designationField=filterForm.down('#designation');
	                        				   designationField.setDisabled(false);
	                        				   designationField.reset();
	                        				   designationField.getStore().getProxy().extraParams={
	                        					   locationMasterId:data
	                        				   };
	                        				   designationField.getStore().load();
	                        			   }
	                        		   },
	                        		   'placementjobapplicationjobapplywindow customcombobox[itemId=jobtitle]':{
	                        			   select:function(obj,rec){
	                        				   var jobId=rec[0].data.id;  
	                        				   var filterForm=obj.up('form');
	                        				   var locationField=filterForm.down('#multiselectPlacementLocation');
	                        				   var store = locationField.getStore();
	                        				   store.getProxy().extraParams = {
	                        					   placementJobId: jobId

	                        				   };
	                        				   store.load();
	                        			   }
	                        		   },
	                        		   'placementjobapplicationfilter customcombobox[itemId=jobtitle]':{
	                        			   select:function(obj,rec){
	                        				   var jobId=rec[0].data.id;  
	                        				   var filterForm=obj.up('form');
	                        				   var selectionStageField=filterForm.down('#selectionStage');
	                        				   var store = selectionStageField.getStore();
	                        				   store.getProxy().extraParams = {
	                        					   placementJobId: jobId
	                        				   };
	                        				   selectionStageField.setDisabled(false);
	                        				   store.load();
	                        			   }
	                        		   },
	                        		   'placementjobapplicationfilter combo[itemId=placementjobapplicationItemId]':{
	                        			   select:function(obj,rec){
	                        				   var Id=rec[0].data.id;  
	                        				   var filterForm=obj.up('form');
	                        				   var jobTitleField=filterForm.down('#jobtitle');
	                        				   jobTitleField.reset();
	                        				   var store = jobTitleField.getStore();
	                        				   store.getProxy().extraParams = {
	                        					   placementCampusId: Id

	                        				   };
	                        				   store.load();
	                        				   var studentNameField=filterForm.down('#studentName');
	                        				   var Studentstore = studentNameField.getStore();
	                        				   Studentstore.getProxy().extraParams = {
	                        					   placementCampusId: Id

	                        				   };
	                        				   studentNameField.setDisabled(false);
	                        			   }
	                        		   },
	                        		   'placementjobapplicationfilter nestedJsonCombo[itemId=programId]':{
	                        			   select:function(obj,rec){
	                        				   var Id=rec[0].data.id;  
	                        				   var filterForm=obj.up('form');
	                        				   var batchIdField=filterForm.down('#batchId');
	                        				   var store = batchIdField.getStore();
	                        				   store.getProxy().extraParams = {
	                        					   id: Id
	                        				   };
	                        				   batchIdField.setDisabled(false);
	                        				   store.load();
	                        			   }
	                        		   },
	                        		   'placementjobapplicationfilter customcombobox[itemId=placementjobapplicationItemId]':{
	                        			   select:function(obj,rec){
	                        				   var Id=rec[0].data.id;  
	                        				   var filterForm=obj.up('form');
	                        				   var studentNameField=filterForm.down('#studentName');
	                        				   var store = studentNameField.getStore();
	                        				   store.getProxy().extraParams = {
	                        					   placementCampusId: Id

	                        				   };
	                        				   store.load();
	                        			   }
	                        		   },
	                        		   'placementjobapplicationapplyjobgrid button[itemId=applyApplication]':{
	                        			   click : function(){
	                        				   var $this = this;
	                        				   var grid = $this.getPlacementjobapplicationapplyjobgrid();

	                        				   if (grid.getSelectionModel().getCount() > 0) {
	                        					   this.openJobApplicationJobApplyWindow();
	                        				   }else
	                        				   {
	                        					   showWarningMessage(getPlacementTranslation('APPLY_FOR_JOB'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
	                        				   }
	                        			   }
	                        		   },
	                        		   'placementjobapplicationgrid button[itemId=updateOfferStatus]':{
	                        			   click : function(){
	                        				   var $this = this;
	                        				   var grid = $this.getPlacementjobapplicationgrid();

	                        				   //if (grid.getSelectionModel().getCount() > 0) {
	                        				   this.openJobApplicationUpdateOfferWindow();
	                        				   // }else
	                        				   // {
	                        				   //showWarningMessage(getPlacementTranslation('PLACEMENT_JOB_APPLICATION_OFFER_STATUS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
	                        			   }
	                        		   //}
	                        		   },
	                        		   'placementjobapplicationgrid button[itemId=updateJoiningStatus]':{
	                        			   click : function(){
	                        				   var $this = this;
	                        				   var grid = $this.getPlacementjobapplicationgrid();

	                        				   //if (grid.getSelectionModel().getCount() > 0) {
	                        				   this.openJobApplicationJoiningStatusWindow();
	                        				   // }else
	                        				   // {
	                        				   //showWarningMessage(getPlacementTranslation('PLACEMENT_JOB_APPLICATION_OFFER_STATUS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
	                        			   }
	                        		   //}
	                        		   },

	                        		   'placementjobapplicationjobapplywindow button[itemId=submitBtn]':{
	                        			   click:function(){
	                        				   var this$ = this;
	                        				   this$.applyStudentForJobApplication();
	                        			   }
	                        		   },
	                        		   'placementjobapplicationjobapplywindow button[itemId=cancelBtn]':{
	                        			   click:function(){
	                        				   var this$ = this;
	                        				   var applyWin = this$.getPlacementjobapplicationjobapplywindow();
	                        				   applyWin.close();
	                        			   }
	                        		   },
	                        		   'placementjobapplicationgrid button[itemId=uploadResume]':{
	                        			   click: this.openUploadResumeFormWindow
	                        		   },
	                        		   'placementjobapplicationupdateofferwindow button#updateStatusDocument': {
		                           			  click:function(){
		                          				 
		                          				  var docGrid = this.getOfferletterdownloddocgrid();
		                          				  if(!isNullOrEmpty(docGrid.getStore().data) && docGrid.getStore().data.items.length==1){
		                          					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DELETE_OLD_UPLOADED_DOCUMENTS'));
		                          				  }else {
		                          					 this.getDocumentController().
			                          				  showDocumentFormWindow('placementDocumentItemId', 'DOCUMENT');
		                          				  }
		                          			  }
	                        		   },
	                        		   'placementjobapplicationupdateofferwindow':{
	                        			   render : function(obj) {
	                        				   var $this = this;
	                        				   var form = $this.getPlacementjobapplicationupdateofferwindow();
	                        				   var grid = $this.getPlacementjobapplicationgrid();
	                        				   var record = grid.getSelectionModel().getSelection()[0];
	                        				   var docGrid = $this.getOfferletterdownloddocgrid();
	                        				   if(!isNullOrEmpty(record.data.offerLetterDocId)){
	                        					   docGrid.getStore().getProxy().extraParams= {
	                        						   placementJobOfferId: record.data.placementJobOfferId
		                        				   };
		                        				   docGrid.getStore().load({
		                        					   callback:function(record) {
		                        						   if(record.length>0) {
		                        							   form.down('#updateStatusDocument').setVisible(false);
		                        							   form.down('#btnDelete').setVisible(true);
		                        						   }
		                        					   }
		                        				   });
	                        				   }
	                        			   }
	                        		   },
	                        		   
	                        		   'documentformwindow[itemId=placementUploadResume] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
			                     			click : function() {
			                     				var $this = this;
			                     				$this.uploadResumeJobApplication();
			                     			}
			                     		},

		                          	 'documentformwindow[itemId=placementDocumentItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
		                     			click : function() {
		                     				var $this = this;
		                     				var isTransient = true;
		                     				var module = 'placement';
		                     				var entityId;
		                     				var entityType = 'uploadOfferLetter';

		                     				$this
		                     				.getDocumentController()
		                     				.saveDocumentForm(
		                     						entityId,
		                     						module,
		                     						entityType,
		                     						'DOCUMENT',
		                     						function(success,
		                     								response,
		                     								isCallBackTransient) {
		                     							var documentModel = new Academia.model.course.QuestionPaperDocument();
		                     							documentModel
		                     							.set(
		                     									"documentName",
		                     									response.name);
		                     							documentModel
		                     							.set(
		                     									"path",
		                     									response.path);
		                     							documentModel
		                     							.set(
		                     									"type",
		                     									response.type);
		                     							documentModel
		                     							.set(
		                     									"documentName",
		                     									response.name);
		                     							documentModel
		                     							.set(
		                     									"isNewRecord",
		                     									true);
		                     							documentModel
		                     							.set(
		                     									"createdBy",
		                     									$this
		                     									.getIdValueJson(
		                     											response.createdBy.id,
		                     											response.createdBy.value));
		                     							var offerletterdownloddocgrid = $this.getOfferletterdownloddocgrid();
		                    							var store = offerletterdownloddocgrid
		                    							.getStore();
		                    							store
		                    							.add(documentModel);
		                    							if (offerletterdownloddocgrid
		                    									.isHidden()
		                    									&& store.data.items.length > 0) {
		                    								offerletterdownloddocgrid
		                    								.setVisible(true);
		                    							}
		                     							$this
		                     							.getDocumentController()
		                     							.closeDocumentFormWindow();
		                     						}, isTransient);
		                     			}
		                     		},
		                     		'documentformwindow[itemId=placementDocumentItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
		                    			click : function() {
		                    				this.getDocumentController()
		                    				.closeDocumentFormWindow();
		                    			}
		                    		},
		                    		'offerletterdownloddocgrid' : {
		                    			cellclick : function(grid, td,
		                    					cellIndex, record, tr,
		                    					rowIndex, e, eOpts) {
		                    				var $this = this;
		                    				var documentGrid = $this.getOfferletterdownloddocgrid();
		                    				var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

		                    				if (columnName == "documentName") {
		                    					if (e.target.tagName == 'A') {
		                    						//var documentId = record
		                    						//.get("documentId");
											var documentId =record.get("ecrptydocumentId");
		                    						if (!isNullOrEmpty(documentId)) {
		                    							$this
		                    							.getDocumentController()
		                    							.downloadDocumentFile(
		                    									documentId);
		                    						}
		                    					}
		                    				}
		                    			},
		                    			 beforerender: function(grid) {
		                    				 var $this = this;
		                    				   var form = $this.getPlacementjobapplicationupdateofferwindow();
		                    				   var grid = $this.getPlacementjobapplicationgrid();
		                    				   var record = grid.getSelectionModel().getSelection()[0];
		                    				   var docGrid = $this.getOfferletterdownloddocgrid();
		                    				   if(!isNullOrEmpty(record.data.offerLetterDocId)){
		                    					   docGrid.getStore().getProxy().extraParams= {
		                    						   placementJobOfferId: record.data.placementJobOfferId
		                    					   };
		                    		                }
		                                 }
		                    		},
		                    		
	                        		   'placementjobapplicationgrid ':{
	                        			   render:function(grid){
//	                        				   this.doAccessControlValidation(grid, this.getPLACEMENT_JOB_APPLICATION_PERMISSION());
//	                        				   this.jobApplicationgridButtonPivileges(grid,this.getPLACEMENT_JOB_APPLICATION_PERMISSION());
	                        			   },
	                        			   cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
	                        				   if (e.target.tagName == 'A') {
	                        					   var documentId = record.get("documentIdEncrypt");
	                        					   if (!isNullOrEmpty(documentId)) {
	                        						   this.getDownloadFileForResumePDocument(documentId);
	                        					   }
	                        				   }
	                        			   },
	                        			   select:function(obj, record,rowIndex, e){
	                        				   this.enableDisableUploadResumeBtn();
	                        				   this.enableDisableJoinigStatusBtn();
	                        				   this.enableDisableOfferStatusBtn();
	                        			   },
	                        			   deselect:function(obj, record, rowIndex, e){
	                        				   this.enableDisableUploadResumeBtn();
	                        				   this.enableDisableJoinigStatusBtn();
	                        				   this.enableDisableOfferStatusBtn();
	                        			   }
	                        		   },
	                        		   'placementjobapplicationtabstructure' :  {
	                        			   afterrender : function(structure){
	                        			   var $this = this;
	                        			   structure.body.on('scroll', function(e, target) {
	                        			      var pcstructure = structure.down("placementjobapplicationgrid");
	                        			      var academyLocationId = $this.getCurrentAcademyLocation();
	                        			      var grid = null;
	                        			      
	                        			      if(!pcstructure.isHidden()){
	                        			      grid = pcstructure;
	                        			      }
	                        			      $this.getMultipleGridHeaderFreeze(grid,structure,true);
	                        			   });
	                        			   }
	                        			   },
	                        		 /*  'documentformwindow[itemId=updateStatusSmd] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId':{
	                     			  click:function(){
	                     				  var $this=this;
	                     				  var isTransient = true;
	                     				  var module = 'placementOfferUpdate';
	                     				  var entityId ;
	                     				  var entityType = 'placementOfferUpdate';

	                     				  $this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function(success, response, isCallBackTransient){
	                     					  var documentModel=new Academia.model.coursetransaction.studymaterialdistributionnew.UpdateStatusUploadDocSmdMdl();
	                     					  documentModel.set("documentName",response.name);
	                     					  documentModel.set("path",response.path);
	                     					  documentModel.set("type",response.type);
	                     					  documentModel.set("documentName",response.name);
	                     					  documentModel.set("createdBy",$this.getIdValueJson(response.createdBy.id,response.createdBy.value));
	                     					  
	                     					  var store=$this.getStore('coursetransaction.studymaterialdistributionnew.UpdateStatusUploadDocSmdStr');
	                     					  store.add(documentModel);
	                     					  $this.getDocumentController().closeDocumentFormWindow();
	                     				  }, isTransient);
	                     			  }
	                     		  },*/
	                        		   /*'sendmessagewindow[itemId=placementSendMessageWindow] button[itemId=adhocMsgSubmitBtn]':{
	                        			   click: function(button){
	                        				    var grid = this.getPlacementjobapplicationgrid();
	                       	        			this.sendPlaceMessage(button,grid);
	                        			   }
	                        		   },
	                        		   
	                        		   'sendmessagewindow[itemId=placementSendMessageWindow] combo#selectTemplate': {
	                       	        	render: function(combo) {
	                       	        		var store = combo.getStore();
	                       	        		var msgRecipientTypeId = combo.up('window').down('#msgRecipientTypeItemId').getValue();
	                       	        		 store.on('beforeload', function(store, operation) {
	                       	                     store.proxy.extraParams = {
	                       	                    		 msgRecipientTypeId :msgRecipientTypeId
	                       	                     };
	                       	                 });
	                           			},
	                           			select :function(combo,records){
	                           				var msgCategoryId = combo.up('window').down('#msgCategoryId');
	                           				var msgSubCategoryId = combo.up('window').down('#msgSubCategoryId');
	                           				msgCategoryId.setValue(records[0].data.msgCategoryId);
	                           				msgSubCategoryId.setValue(records[0].data.msgSubCategoryId);
	                           			}
	                       	        },*/	                        		   
	                       	        
	                       	         'placementappliedjobfilter button[itemId=appliedJobSearchBtn]': {
	                       	        	click: this.loadPlacementAppliedJobGrid
	                       	        },
	                       	        
	                       	         'placementappliedjobgrid button[itemId=uploadResume]':{
	                       	        	click: this.openUploadResumeForStudent
	                       	        },
	                       	        
	                       	         'documentformwindow[itemId=studentUploadResume] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
	                       	        	click : function() {
	                       	        		var $this = this;
	                       	        		$this.uploadResumeAppliedJobApplication();
	                       	        	}
		                     		},
		                     		
		                     	 	'placementappliedjobgrid ':{
	                        			   render:function(grid){
	                        				   this.doAccessControlValidation(grid, this.getSTUDENT_APPLIED_JOBS_PERMISSION());
	                       	    			   this.disableAppliedGridPivileges(grid, this.getSTUDENT_APPLIED_JOBS_PERMISSION());
	                        			   },
	                        			   cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
	                        				   var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;

	                        				   if(columnName == "noOfLocation"){
	                        					   if(e.target.tagName=='A'){
	                        						   this.getAppliedJobLocationGridWindow(grid,record);
	                        					   }
	                        				   }
	                        				   if(columnName == "documentName"){
	                        				   if (e.target.tagName == 'A') {
	                        					   var documentId = record.get("documentIdEncrypt");
	                        					   if (!isNullOrEmpty(documentId)) {
	                        						   this.getDownloadFileForResumePDocument(documentId);
	                        					   }
	                        				   }
   	                       				     }
	                        				   if (columnName == "offerLetterDocName") {
	                        					    if (e.target.tagName == 'A') {
	                        					        var offerLetterDocId = record.get("offerLetterdocIdEncrypt");
	                        					        if (!isNullOrEmpty(offerLetterDocId)) {
	                        					            this.getDocumentController().downloadDocumentFile(offerLetterDocId);
	                        					        }
	                        					    }

	                        					}	                        			 
	                        				},
	                        		   },
	                        		   
	                        	    'placementappliedjobfilter button[itemId=appliedJobresetBtn]': {
		                       	        	click: this.resetPlacementAppliedJobFilter
		                       	        },
	                       	        
	                       	        'placementavailablejobfilter button[itemId=availableJobSearchBtn]': {
	                       	    	 		click: function() {
	                       	    	 			this.loadPlacementAvailableJobApplicationGrid();
	                       	    	 		}
	                       	      },
	                       	      
	                       	       'placementavailablejobgrid button[itemId=applyJobId]':{
	                       	    	   click : function(){
	                       	    		  var $this = this;
	                       	    		  var grid = $this.getPlacementavailablejobgrid();

	                       	    		  if (grid.getSelectionModel().getCount() > 0) {
	                       	    			  this.openJobApplicationJobApplyForStudentWindow();
	                       	    			  
	                       	    			  var formWindow = this.getPlacementavailablejobapplicationjobapplywindow();
	                       	    			  var locationField=formWindow.down('#multiselectPlacementLocation');
	                       	    			  var store = locationField.getStore();
	                       	    			  var record = grid.getSelectionModel().getSelection();
	                       	    			  var jobId = record[0].data.jobId;
	                       	    			  store.getProxy().extraParams = {
	                       	    				  placementJobId: jobId

	                       	    			  };
	                       	    			  store.load();
	                       	    		  }else
	                       	    		  {
	                       	    			  showWarningMessage(getPlacementTranslation('APPLY_FOR_JOB'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
	                       	    		  }
	                       	    	  }
	                       	      },
	                       	      
	                       	     'placementavailablejobapplicationjobapplywindow button[itemId=submitBtn]':{
                    			   click:function(){
                    				   var this$ = this;
                    				   this$.applyForStudentJobApplication();
                    			    }
                    		     },
                    		   
                    		    'placementavailablejobapplicationjobapplywindow button[itemId=cancelBtn]':{
                    			   click:function(){
                    				   var this$ = this;
                    				   var applyWin = this$.getPlacementavailablejobapplicationjobapplywindow();
                    				   applyWin.close();
                    			    }
                    		     },
                    		  
                    		    'placementavailablejobfilter button[itemId=availableJobresetBtn]': {
                    			   click: function(){
                    				   this.getPlacementavailablejobfilter().getForm().reset();
                    			   }
                    		   },
                    		   
                    		   'placementavailablejobgrid ':{
                    			   render:function(grid){
                    				   this.doAccessControlValidation(grid, this.getSTUDENT_AVAILABLE_JOBS_PERMISSION());
                   	    			   this.disableAvailableGridPivileges(grid, this.getSTUDENT_AVAILABLE_JOBS_PERMISSION());
                    			   },
                    			   cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    				   var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
                    				   var $this = this;
                    				   if(columnName == "noOfLocations"){
                    					   if(e.target.tagName=='A'){
                    						   this.getAvailableJobLocationGridWindow(grid,record);
                    					   }
                    				   }
                    				   if(columnName == "selectionStage"){
                    				   if (e.target.tagName == 'A') {
                    					   var jobId = record.get("jobId");
                    					   if (!isNullOrEmpty(jobId)) {
                    						   this.getPlacementSelectionGridWindow(grid,record);
                    					   }
                    				   }
                    				  }
                    				   if(columnName == "jobDescription"){
                        				   if (e.target.tagName == 'A') {
                        					   var placementJobId = record.get("jobId");
                        					   if (!isNullOrEmpty(placementJobId)) {
                        						   
                        						   var frmWin = this.getPlacementjobdescriptionwindow();
                        						   if(!frmWin){
                        							   Ext.widget('placementjobdescriptionwindow');
                        							   frmWin = this.getPlacementjobdescriptionwindow();
                        						   }
                        						   var jobDesc = record.data.jobDescription;
                        						   frmWin.show();
                        						   frmWin.down('#jobDescriptionId').setValue(jobDesc);
                        					   }
                        				   }
                        				  } 
                    				   
                    				   if(columnName == "documentName"){
                    					   if(e.target.tagName=='A'){
                    						   this.getdocumentGridWindow(grid,record);
                    					   }
                    				   }
                    				   if(columnName == "jobPostingDocuments"){
                    					   if(e.target.tagName=='A'){
               		                    	var placementAvailableJobGrid = this.getPlacementavailablejobgrid();
            		                    	if(placementAvailableJobGrid.getSelectionModel().getSelection()[0].data.jobPostingDocuments.length == 1) {
            		                    		$this.getDocumentController().downloadDocumentFile(placementAvailableJobGrid.getSelectionModel().getSelection()[0].data.jobPostingDocuments[0].document.encryptedDocId);
            		                    	} else {
            		                            var formWindow = $this.getJobpostingdocumentwin();
            		                            if (!formWindow) {
            		                                Ext.widget('jobpostingdocumentwin');
            		                                formWindow = $this.getJobpostingdocumentwin();
            		                            }
            		                            formWindow.show();
            		                            var documentGrid = $this.getJobpostingdocumentwingrid();
            		                            documentGrid.down('#btnDelete').setVisible(false);
            		                            documentGrid.getStore().getProxy().extraParams = {
            		                                placementJobId: record.data.jobId
            		                            };
            		                          
            		                            documentGrid.getStore().load();
            		                    	}
            	                        }
                    				   }
                    				   
                    			   },
                    		     },
                    		     'jobpostingdocumentwingrid button[itemId=btnDownloadDispatchForms]':{
             	    				click:function(obj){
             	    					this.downloadAllDescriptionDocumentFormsZip();
             	    				}
             	    			},
             	    			'jobpostingdocumentwingrid':{
            	    				cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e, eopts) {
            	    					var $this = this;
            	    					if (e.target.tagName == 'A' && !(Ext.isDefined(Ext.ComponentQuery.query("placementjobgrid")[0]))) {
            	    						var grid=$this.getJobpostingdocumentwingrid();
            	    						if (grid.getSelectionModel().getCount() > 0) {
            	    							var documentId = grid.getSelectionModel().getSelection()[0].data.document.encryptedDocId;
            	    							$this.getDocumentController().downloadDocumentFile(documentId);
            	    						}
            	    					}
            	    				}
            	    			},
    	                           'placementavailablejobfilter nestedJsonCombo[itemId=coordinatorItemId]':{
                        			   render: function(obj) {
                        				   var $this = this;
                        				   var store = obj.getStore();
                        				   store.getProxy().extraParams={
                        					   roleName:'FACULTY',
                        					   academyLocationId:this.getCurrentAcademyLocation()
                        				   }
                        			   }
    	                           },
    	                           /*'placementavailablejobfilter':{
    	                        	   render: function() {
    	                        		   this.loadPlacementAvailableJobApplicationGrid();
    	                        	   }
    	                           },*/
    	                           /*START :- added for adhoc messaging*/
    	                           'placementjobsendmessages[itemId=placementSendMessageWindow] radiogroup[itemId=messageType]':{
    	                        	   change : function(val,nV,oV){
    	                        		   this.selectPlacementSectionMessageType(val,nV,oV);
    	                        	   }
    	                           },
    	                           'placementjobsendmessages[itemId=placementSendMessageWindow] customcombobox[itemId=msgTempletId]':{
    	                        	   select : function(obj,rec){
    	                        		   this.selectPlacementMessageTemp(obj,rec);
    	                        	   }
    	                           },
    	                           'placementjobsendmessages[itemId=placementSendMessageWindow] button[itemId=adhocMsgSubmitBtn]':{
    	                        	   click: function(obj) {
    	                        		   var grid = this.getPlacementjobapplicationgrid();
    	                        		   var placementSendMessage = this.getPlacementjobsendmessages();
    	                        		   var formPnl = obj.up('form');
    	                        		   var isMySelfChecked = false;
    	                        		   var fldValues = formPnl.getForm().getFieldValues();
    	                        		   isMySelfChecked = fldValues.recieverType;
    	                        		   var currentlyLoggedInUserId= this.getCurrentlyLoggedInUser().id;
    	                        		   placementSendMessage.placementSendMessage(obj,grid,isMySelfChecked,currentlyLoggedInUserId);
    	                        	   }
    	                           },
    	                           'placementjobsendmessages[itemId=placementSendMessageWindow]  filefield[itemId=staticUploadFileField]': {
    	                        	   change: function(fileField, value, eOpts){
    	                        		   var this$ = this;
    	                        		   this$.uploadPlacementStaticDocumentFileMessage(fileField, value, eOpts);
    	                        	   }
    	                           },
    	                           'placementjobsendmessages[itemId=placementSendMessageWindow]': {
    	                        	   render: function(grid){
    	                        		   var this$ = this;
    	                        		   var docGrid = grid.down('#placementjobStaticDocumentAttachmentGridMessage');
    	                        		   docGrid.getStore().removeAll();
    	                        		   docGrid.getStore().sync();
    	                        		   var itemIdPrivilegeNameArray = [{"#adhocMessage" : "ADHOC_MESSAGE" , "#messageTemplate" : "MESSAGE_TEMPLATE", "radioGroupItemId" : "#messageType", "defaultButtonItemId" : "#adhocMessage" }];
    	                 	        	   this$.disableRadioGroupAndOtherPivileges(grid, this$.getPLACEMENT_JOB_APPLICATION_PERMISSION(), itemIdPrivilegeNameArray);
    	                        	   }
    	                           }, 
    	                           'placementjobsendmessages[itemId=placementSendMessageWindow] radiogroup#sendingPriority': {
    	                        	   change: function( radio, newValue, oldValue, eOpts) {
    	                        		   this.loadPlacementScheduleField(radio, newValue, oldValue);
    	                        	   }
    	                           },
    	                           'placementjobstaticdocumentattachmentgrid[itemId=placementjobStaticDocumentAttachmentGridMessage] actioncolumn': {
    	                        	   click : function(view, rowIndex, colIndex, item, e, record, row){
    	                        		   this.deletePlacementStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
    	                        	   }
    	                           },
    	                           /*V2D-13247*/
    	                           'placementjobsendmessages[itemId=placementSendMessageWindow] textarea[itemId=smsDiscription]':{
    	                        	   change : function(val,nV,oV){
    	                        		   var placementJobSendMessages = this.getPlacementjobsendmessages();
    	                        		   var smsTextField = placementJobSendMessages.down('#smsDiscription');
    	                        		   var smsTextFieldDiscription = placementJobSendMessages.down('#smsDiscriptionNotice');
    	                        		   var maxLength = localStorage.getItem('maxLength');
    	                        		   var newValue = maxLength - smsTextField.getValue().length;
    	                        		   smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
    	                        	   }
    	                           },
    	                           
    	                           'placementjobsendmessages[itemId=placementSendMessageWindow] textarea[itemId=pushNotificationDiscription]':{
    	                 	        	change : function(val,nV,oV){
    	                 	        		var studentSendMessageWindowDashlet = this.getPlacementjobsendmessages();
    	                 	        		var pushTextField = studentSendMessageWindowDashlet.down('#pushNotificationDiscription');
    	                 	        		var pushTextFieldDiscription = studentSendMessageWindowDashlet.down('#pushNotificationDiscriptionNotice');
    	                 	        		var maxLength = 1000;
    	                 	        		var newValue = maxLength - pushTextField.getValue().length;
    	                 	        		pushTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
    	                 	        	}
    	                 	        },
    	                 	        
    	                           /*END :- added for adhoc messaging*/
    	                           'placementavailablejobfilter combo#placementcampusItemId':{
                        			   render: function(obj) {
                        				   var $this = this;
                        				   var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
                        				   var store = obj.getStore();
                        				   store.getProxy().extraParams={
                        					   periodId:studentPortalInfo.programBatchDetails.periodId,
                        					   studentId:studentPortalInfo.student.id
                        				   },
                        				   store.load();
                        			   }
    	                           },  	                          

    	                           'placementavailablejobfilter combo#placementcampusItemId':{
    	                        	   render: function(obj) {
    	                        		   var $this = this;
    	                        		   var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
    	                        		   var store = obj.getStore();
    	                        		   store.getProxy().extraParams={
    	                        			   periodId:studentPortalInfo.programBatchDetails.periodId,
    	                        			   studentId:studentPortalInfo.student.id
    	                        		   },
    	                        		   store.load();
    	                        	   },
    	                           },
    	                            'placementjobsendmessages' :{
	                        	afterrender:function(form){
	                        		 var me = this;
	             					me.saveDFRInfo(me.getCurrentAcademyLocation(),form);
	                        	 }
	                         },
    	                           'placementjobapplicationform':{
    	                        	   afterrender: function(form){
    	                        		   var manageApplicationStatus =form.down('#manageApplicationStatus');
    	                        		   var academyLocationId = this.getCurrentAcademyLocation();
    	                        		   var associatedAcadLocationIds = new Array();
    	                        		   associatedAcadLocationIds.push(academyLocationId);

    	                        		   manageApplicationStatus.setVisible(false);
    	                        		   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getAPPLY_FOR_JOB_PERMISSION());
    	                        		   Ext.each(permissionList,function(privilege){
    	                        			   if(privilege === 'MANAGE_APPLICATION_STATUS'){
    	                        				   manageApplicationStatus.setVisible(true);
    	                        			   }
    	                        		   })
    	                        	   }
    	                           },
    	                           'placementjobapplicationform button[itemId=manageApplicationStatus]':{
    	                        	   click: function(btn){
    	                        		   var contentPanel = this.getContentPanel();
    		                        	   var structure = Ext.widget('manageapplicationstatusgrid');
    		                        	   var tabName = getPlacementTranslation('MANAGE_APPLICATION_STATUS');
    		                        	    var getcontroller=this.getController('menu.CoreERPNavigationController');
    		                        	   var getTab=getcontroller.getTab(tabName);
    		                        	   if(getTab!=null){
    		                        		   contentPanel.remove(getTab, true);
    		                        	   }
    		                        	   openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_ONE);
    	                        	   }
    	                           },
    	                           'manageapplicationstatusgrid':{
    	                        	   afterrender:function(grid){
    	                        		   var $this=this;
    		                        	   var form = $this.getPlacementjobapplicationform();
    		                        	   var placementId = form.down("#placementjobapplicationItemId").getValue();
    		                        	   var whetherAllowed = form.down("#placementjobapplicationItemId").valueModels[0].get('whetherAllowed');
    		                        	   var gridStore =grid.getStore();
    		                        	   gridStore.getProxy().extraParams = {
    	                        			   placementCampusId: placementId,
    		                        		   whetherAllowed: whetherAllowed
    	                        		   }
    	                        		   this.resetPageSetting(gridStore);
    		                        	   gridStore.load();
    	                        	   },
    	                        	   selectionchange:function( view, selected, eOpts ){
    	                        		   var grid = this.getManageapplicationstatusgrid();
      	                        		 
    	                        		  var saveApplication =  grid.down('#saveApplication');
    	                        		  if(selected.length> 0){
    	                        			  saveApplication.enable();
    	                        		  }else{
    	                        			  saveApplication.disable();
    	                        		  }
    	                        		  
    	                        	   }
    	                           },
    	                           'manageapplicationstatusgrid button[itemId=saveApplication]':{
    	                        	   click:function(btn){
    	                        		   var grid = this.getManageapplicationstatusgrid();
    	                        		   var form = this.getPlacementjobapplicationform();
    		                        	   var placementId = form.down("#placementjobapplicationItemId").getValue();
    		                        	  
    	                        		   if(grid.getSelectionModel().getCount() > 0){
    	                        			    var selectedItems = grid.getSelectionModel().getSelection();
    	                        			    var jsonArray=[];
    	                        			    for(var i=0;i< selectedItems.length;i++){
    	                        			    	var obj = new Object();
    	                        			    	if(!isNullOrEmpty(selectedItems[i].data.appStatusId)){
    	                        			    		obj.id = selectedItems[i].data.appStatusId;
    	                        			    	}
    	                        			    	obj.placementCampus ={
    	                        			    			id :placementId
    	                        			    	},
    	                        			    	obj.progBatchSeatConfig ={
    	                        			    			id :selectedItems[i].data.progBatchSeatConfigId
    	                        			    	},
    	                        			    	obj.student ={
    	                        			    			id :selectedItems[i].data.studentId
    	                        			    	},
    	                        			    	obj.admission  ={
    	                        			    			id: selectedItems[i].data.admissionId
    	                        			    	}
    	                        			    	obj.status =  selectedItems[i].data.selectionProcessName
    	                        			    	jsonArray.push(obj);
    	                        			    }
    	                        			    var jsonSubmitData = Ext.encode(jsonArray);
    	                        			    Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	                        			    Ext.Ajax.request({
 	                        			    	   type: 'rest',
	                   	    						   url: SERVERURL.PATH_SAVE_ALL_STUDENT_JOB_STATUS,
	                   	    						   method: 'POST',
	                   	    						   jsonData:jsonSubmitData,
	                   	    						   success: function(form, action) {
	                   	    							    Ext.getBody().unmask();
	                   	    							    grid.getStore().load();
	                   	    							    showSuccessMessage(getPlacementTranslation('MANAGE_APPLICATION_STATUS'), getCommonTranslation('SUCCESS_MSG'));
	                   	    						   }
	                   	    					   
 	                        			    	});
    	                        		   }else{
    	                        			   showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_RECORD")); 
    	                        		   }
    	                        	   }
    	                           },
    	                           'placementjobapplicationjoiningstatuswindow':{
    	                        	           render : function(win){
    	                        		        var grid= this.getPlacementjobapplicationgrid();
    	                        		        var record = grid.getSelectionModel().getSelection()[0];
    	                        		        var admissionId = record.data.admissionId;

    	                        		         Ext.Ajax.request({
    	                        			      type: 'rest',
    	                        			      url: SERVERURL.PATH_BATCH_START_DATE_BY_ADMISSION_ID,
    	                        			      method: 'GET',
    	                        			      params: {
                                                  admissionId : record.data.admissionId,
                                                  },
    	                        			       success: function(response, action){
    	                        				   var resp = Ext.decode(response.responseText);
    	                        				   var datefield =  win.down('#dateOfJoining');
    	                                           datefield.setMinValue(resp.startDate);
    	                        			       }
    	                        		   });
    	                        	   }
    	                           },
    	                           'placementjobapplicationupdateofferwindow customcombobox[itemId=statusItemId]':{
                                      select:function(obj){
                                    	  var win = this.getPlacementjobapplicationupdateofferwindow();
                                    	  if(obj.getValue()=='OFFERED'){
                                    		  win.down('#jobLocation').setDisabled(false);
                                    		  win.down('#saleryPKG').setDisabled(false);
                                    		  win.down('#dateOfJoining').setDisabled(false);
                                    	  }else{
                                    		  win.down('#jobLocation').reset();
                                    		  win.down('#designation').reset();
                                    		  win.down('#saleryPKG').reset();
                                    		  win.down('#dateOfJoining').reset();
                                    		  win.down('#jobLocation').setDisabled(true);
                                    		  win.down('#designation').setDisabled(true);
                                    		  win.down('#saleryPKG').setDisabled(true);
                                    		  win.down('#dateOfJoining').setDisabled(true);
                                    	  }
                                    	  win.down('form').getForm().checkValidity();
                                      }
    	                           }
	                        	   });
	                           },
	                           
	                           /**
	                            * This method is used to send message
	                            */
	                           /*sendPlaceMessage : function(button,grid){
	                       		baseController = Academia.app.getController('Academia.controller.base.BaseController');
	                       		var formData = button.up('form').getValues();
	                       		var recipientIds = this.getReceipientId(grid);

	                       		
	                       		var typeId;
	                       		if(formData.msgRecipientTypeId == 10){
	                       			typeId = 32;
	                       		} else {
	                       			typeId = formData.msgRecipientTypeId;
	                       		}
	                       		
	                       		var json = {
	                       				id: null, 
	                       			    status: null, 
	                       			    msgTemplateConfigId: null, 
	                       			    sendingPriority: formData.sendingPriority, 
	                       			    msgCategoryId:formData.msgCategoryId, 
	                       			    msgSubCategoryId: formData.msgSubCategoryId, 
	                       			    messageId: formData.messageId, 
	                       			    displayCode: formData.displayCode, 
	                       			    wsMsgEventRecipientConfigs: [ 
	                       			        { 
	                       			            msgRecipientTypeId: typeId, 
	                       			            msgTemplateConfigId:formData.msgTemplateConfigId, 
	                       			            selectiveRecipientIds:recipientIds 
	                       			        } 
	                       			    ], 
	                       			    wsAdhocRecipients: null, 
	                       			    approverId: null, 
	                       			    approvalRequired: false, 
	                       			    reviewStatusCode: "APPROVED" 

	                       		};
	                       		if(formData.sendingPriority==="SCHEDULE"){
	                    			if(!isNullOrEmpty(formData.msgDueDate) && !isNullOrEmpty(formData.msgDueDateTime)){
	                        			var dateString="";
	                        			dateString=formData.msgDueDate+" "+formData.msgDueDateTime;
	                        			json.msgDueDate=dateString;
	                        		}else{
	                        			json.msgDueDate= null;
	                        		}
	                    		}else if(formData.sendingPriority==="IMMEDIATE"){
	                    			var now = new Date();
	                    			var dateString = Ext.Date.format(now,'Y-m-d h:i A');
	                    			json.msgDueDate=dateString;
	                    		}else{
	                    			json.msgDueDate= null;
	                    		}
	                    		
	                    		var academyLocation=baseController.getCurrentAcademyLocation();
	                        	if(!isNullOrEmpty(academyLocation)){
	                        		json.academyLocationId=academyLocation;
	                        	}
	                        	
	                        	var currentlyLoggedInUser=baseController.getCurrentlyLoggedInUser();
	                        	if(!isEmpty(currentlyLoggedInUser)){
	                        		json.authorId=currentlyLoggedInUser.id;
	                        		json.authorName=currentlyLoggedInUser.value;
	                        	}
	                            jsonDataEncode = Ext.encode(json);
	                    		Ext.Ajax.request({
	                                type: 'rest',
	                                url: SERVERURL.ADOC_MESSAGEING_CREATE,
	                                jsonData: jsonDataEncode,
	                                method: 'POST',
	                                success: function(form, action) {
	                                    grid.getStore().reload();
	                                    grid.getSelectionModel().deselectAll(true);
	                                    button.up('window').close();
	                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('MESSAGE_SEND_MSG'));
	                                }

	                            });
	                           },*/	
	                           

	                       	/**
	                       	 * This method is used to get Ids 
	                       	 */
	                         /*getReceipientId : function(grid){
	                       		var records = grid.getSelectionModel().getSelection();
	                       		var ids = new Array();
	                       		
	                       		if(grid.itemId === 'StudentSearchResultGrid'){
	                       			for(var i = 0 ; i<records.length;i++){
	                       				ids.push(records[i].raw.ADMISSION_ID);
	                       			}
	                       		}else if(grid.itemId === 'facultySearchResultGrid' ||grid.itemId === 'applicationsListGrid',grid.itemId ==='trackenquirygrid'){
	                       			for(var i = 0 ; i<records.length;i++){
	                       				ids.push(records[i].raw.ID);
	                       			}
	                       		}else if(grid.itemId === 'userSearchresultgrid'){
	                       			for(var i = 0 ; i<records.length;i++){
	                       				ids.push(records[i].raw.USER_ID);
	                       			}
	                       		}else{
	                       			for(var i = 0 ; i<records.length;i++){
	                       				ids.push(records[i].data.admissionId);
	                       			}
	                       		}
	                       		return ids;
	                       	},*/
	                           
	                           loadPlacementJobApplicationGrid:function(){


	                        	   var $this=this;
	                        	   var form = $this.getPlacementjobapplicationfilter();
	                        	   var placementjobapplicationItemId = form.down("#placementjobapplicationItemId").getValue();
	                        	   var jobtitle = form.down("#jobtitle").getValue();
	                        	   var academyLocation = form.down("#academyLocation").getValue();
	                        	   var applicationStatus = form.down("#applicationStatus").getValue();
	                        	   var selectionStage = form.down("#selectionStage").getValue();
	                        	   var offerStatus = form.down("#offerStatus").getValue();
	                        	   var joiningStatus = form.down("#joiningStatus").getValue();
	                        	   var programId = form.down("#programId").getValue();
	                        	   var batchId = form.down("#batchId").getValue();
	                        	   var studentName = form.down("#studentName").getValue();
	                        	   var grid = $this.getPlacementjobapplicationgrid();
	                        	   var store =  grid.getStore();

	                        	   store.getProxy().extraParams = {
	                        		   placementCampusId: placementjobapplicationItemId,
	                        		   jobTitleId: jobtitle,
	                        		   recruitingOrganizationALId: academyLocation,
	                        		   applicationStatus: applicationStatus,
	                        		   selectionStage:selectionStage,
	                        		   offerStatus:offerStatus,
	                        		   joiningStatus:joiningStatus,
	                        		   programId:programId,
	                        		   batchId:batchId,
	                        		   admissionId:studentName
	                        	   };
	                        	   store.load();
	                        	   /*pdf & excel report header filter*/
	                           	   grid.config.searchFilterForm = form;
	                           },
	                           openJobApplicationJobApplyWindow:function(obj){

	                        	   var formWindow = this.getPlacementjobapplicationjobapplywindow();
	                        	   if (!formWindow) {
	                        		   Ext.widget('placementjobapplicationjobapplywindow');
	                        		   formWindow = this.getPlacementjobapplicationjobapplywindow();
	                        	   }
	                        	   formWindow.show();

	                        	   var form = this.getPlacementjobapplicationform();
	                        	   var placementCampusId = form.down("#placementjobapplicationItemId").getValue();

	                        	   var roField = formWindow.down('#recruitingOrganization');
	                        	   var store = roField.getStore();
	                        	   store.getProxy().extraParams = {
	                        		   placementCampusId: placementCampusId

	                        	   };
	                           },
	                           /*addSendMessage:function(){
	           	                	var grid = this.getPlacementjobapplicationgrid();
	               	            	if (grid.getSelectionModel().getCount() > 0) {
	               	            		var this$ = this;
//	               	            		Academia.app.getController('Academia.controller.personinfo.student.StudentListController');
	               	                	var window = this$.getSendMessageWindow();
	               	                	if(!window){
	               	                		window = Ext.widget('placementjobsendmessages',{
	               	                			itemId:'placementSendMessageWindow'
	               	                		});
	               	                		window.down('#msgRecipientTypeItemId').setValue(RECIPIENT_TYPES_COSTANTS.STUDENT);
	               	                	}
	               	                	window.show();
	               	            	} else {
	               	            		showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_RECORD"));
	               	            	}  
	                           },*/
	                           openJobApplicationUpdateOfferWindow:function(obj){
	                        	   var $this = this;
	                        	   var grid = this.getPlacementjobapplicationgrid();
	                        	   if(grid.getSelectionModel().getCount()>0){
	                        		   var formWindow = this.getPlacementjobapplicationupdateofferwindow();
	                        		   if (!formWindow) {
	                        			   Ext.widget('placementjobapplicationupdateofferwindow');
	                        			   formWindow = this.getPlacementjobapplicationupdateofferwindow();
	                        			   formWindow.show();
	                        			   var jobapplicationGrid=this.getPlacementjobapplicationgrid();
	                        			   var record = jobapplicationGrid.getSelectionModel().getSelection()[0];
	                        			   formWindow.down('#recruitingOrganization').setValue(record.data.recruitingOrgName);
	                        			   formWindow.down('#jobtitle').setValue(record.data.jobTitle);
	                        			   formWindow.down('#stipend').setValue(record.data.stipend);
	                        			   formWindow.down('#placementCampus').setValue(record.data.placementCampus);
	                        			   var statusItemId = formWindow.down('#statusItemId');

	                        			   statusItemId.getStore().load({
	                        				   callback: function(records, operation, success) {
	                        					   statusItemId.setValue(record.data.offerStatus);
	                        				   }
	                        			   });
	                        			   
	                        			   var jobLocationItem = formWindow.down('#jobLocation');
	                        			   jobLocationItem.getStore().getProxy().extraParams={
	                        				   placementJobId:record.data.placementJobId
	                        			   };
	                        			   jobLocationItem.getStore().load({
	                        				   callback: function(records, operation, success) {
	                        					   for(var i in records) {
	                        						   if(records[i].data.value==record.data.jobLocation){
	                        							   jobLocationItem.setValue(records[i].data.id);
	                        						   }
	                        					   }
	                        				   }
	                        			   });
	                        			   
	                        			   var designationItem = formWindow.down('#designation');
	                        			   designationItem.getStore().getProxy().extraParams={
	                        				   placementJobId:record.data.placementJobId,
	                        				   locationMasterId:record.data.jobLocationId,
	                        				   placementJobLocationId:record.data.jobDesignationId
	                        			   };
	                        			   designationItem.getStore().load({
	                        				   callback: function(records, operation, success) {
	                        					   for(var i in records) {
	                        						   if(records[i].data.id==record.data.jobDesignationId){
	                        							   designationItem.setValue(records[i].data.id);
	                        							   designationItem.setDisabled(false);
	                        						   }
	                        					   }
	                        				   }
	                        			   });

	                        			   var saleryPKGItem = formWindow.down('#saleryPKG');
	                        			   saleryPKGItem.setValue(record.data.salaryPkg);
	                        			  
	                        			   var remarks = formWindow.down('#remarksJobItemId');
	                                       remarks.setValue(record.data.remark);

	                        			   var dateOfJoiningItem = formWindow.down('#dateOfJoining');
	                        			   dateOfJoiningItem.setValue(dateRender(record.data.dateOfJoining));
	                        			   var sponsorId = formWindow.down('#sponsorId');
	                        			   sponsorId.getStore().load({
	                        				   callback: function(records, operation, success) {
	                        					   for(var i in records) {
	                        						   if(records[i].data.id==record.data.sponsorId){
	                        							   sponsorId.setValue(records[i].data.id);
	                        							 
	                        						   }
	                        					   }
	                        				   }
	                        			   });
	                        			   
//	                        			   var JobId = formWindow.down('#jobLocation');
//	                        			   JobId.getStore().getProxy().extraParams={
//	                        				   placementJobId:record.data.placementJobId
//	                        			   };
//	                        			   JobId.getStore().load();

//	                        			   var designationId = formWindow.down('#designation');
//	                        			   designationId.getStore().getProxy().extraParams={
//	                        				   placementJobId:record.data.placementJobId
//	                        			   };
//	                        			   designationId.getStore().load();
	                        		   }

	                        		 //  formWindow.show();
	                        	   }else{
	                        		   showWarningMessage(getPlacementTranslation('UPDATE_OFFER_STATUS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
	                        	   }


	                           },
	                           openJobApplicationJoiningStatusWindow:function(obj){

	                        	   var grid = this.getPlacementjobapplicationgrid();
	                        	   
                    			   var record = grid.getSelectionModel().getSelection()[0];
	                        	   
	                        	   if(grid.getSelectionModel().getCount()>0){
	                        		   var formWindow = this.getPlacementjobapplicationjoiningstatuswindow();
	                        		   if (!formWindow) {
	                        			   Ext.widget('placementjobapplicationjoiningstatuswindow');
	                        			   formWindow = this.getPlacementjobapplicationjoiningstatuswindow();
	                        			   var jobapplicationGrid=this.getPlacementjobapplicationgrid();
	                        			   var record = jobapplicationGrid.getSelectionModel().getSelection()[0];
	                        			   formWindow.down('#recruitingOrganization').setValue(record.data.recruitingOrgName);
	                        			   formWindow.down('#jobtitle').setValue(record.data.jobTitle);
	                        			   formWindow.down('#placementCampus').setValue(record.data.placementCampus);
	                        			   formWindow.down('#jobLocation').setValue(record.data.jobLocation);
	                        			   
	                        			   var confirmedByItem = formWindow.down('#confirmedBy');

	                        			   confirmedByItem.getStore().load({
	                        				   callback: function(records, operation, success) {
	                        					   for(var i in records) {
	                        						   if(record.data.usersByConfirmedById == records[i].data.id){
	                        							   confirmedByItem.setValue(records[i].data.id);
	                        						   }
	                        					   }
	                        				   }
	                        			   });
	                        			   
	                        			   var dateOfJoiningItem = formWindow.down('#dateOfJoining');
	                        			   dateOfJoiningItem.setValue(dateRender(record.data.joiningDate));
	                        			   
	                        		   }
	                        		   formWindow.show();
	                        	   }else{
	                        		   showWarningMessage(getPlacementTranslation('UPDATE_JOINING_STATUS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
	                        	   }


	                           },
	                           getPlacementJobApplicationStudentRecord:function(){
	                        	   var $this=this;
	                        	   var form = $this.getPlacementjobapplicationform();
	                        	   var placementId = form.down("#placementjobapplicationItemId").getValue();
	                        	   var whetherAllowed = form.down("#placementjobapplicationItemId").valueModels[0].get('whetherAllowed');
	                        	   var grid = $this.getPlacementjobapplicationapplyjobgrid();
	                        	   var store =  grid.getStore();
	                        	   store.getProxy().extraParams = {
	                        		   placementCampusId: placementId,
	                        		   whetherAllowed: whetherAllowed,
	                        	   };
	                        	   store.load({
	                        		   callback: function(records, operation, success) {
	                        			   if(records.length>0){
	                        				   var jsonArray=[];
	                        				   for(var i in records) {
	                        					   var obj = new Object();
	                        					   if(!isNullOrEmpty(records[i].data.appStatusId)){
	                        						   obj.id = records[i].data.appStatusId;
	                        					   }
	                        					   obj.placementCampus ={
	                        							   id :placementId
	                        					   },
	                        					   obj.progBatchSeatConfig ={
	                        							   id :records[i].data.progBatchSeatConfigId
	                        					   },
	                        					   obj.student ={
	                        							   id :records[i].data.studentId
	                        					   },
	                        					   obj.admission  ={
	                        							   id: records[i].data.admissionId
	                        					   }
	                        					   obj.status =  records[i].data.selectionProcessName
	                        					   jsonArray.push(obj);
	                        				   }
	                        				   var jsonSubmitData = Ext.encode(jsonArray);
		                        			   Ext.Ajax.request({
	                    						   type: 'rest',
	                    						   url: SERVERURL.PATH_SAVE_ALL_STUDENT_ELIGIBLE_FOR_JOB,
	                    						   method: 'POST',
	                    						   jsonData:jsonSubmitData,
	                    						   success: function(form, action) {
	                    						   }
	                    					   });
	                        			   }
	                        		   }
	                        	   });
	                        	   
	                           }, 
	                           CancelPlacementAppOfferWin:function(){
	                        	   var $this = this;
	                        	   var offerWindow = $this.getPlacementjobapplicationupdateofferwindow();
	                        	   offerWindow.close();
	                           }, 
	                           CancelPlacementJoiningStatusWin:function(){
	                        	   var $this = this;
	                        	   var offerWindow = $this.getPlacementjobapplicationjoiningstatuswindow();
	                        	   offerWindow.close();
	                           },
	                           resetPlacementJobApplicationFilter:function(){
	                        	   var $this=this;
	                        	   var filter = $this.getPlacementjobapplicationfilter().getForm();
	                        	   filter.reset();
	                        	   var form = $this.getPlacementjobapplicationfilter();
	                        	   var batchField=form.down('#batchId');
	                        	   batchField.setDisabled(true);
	                        	   var studentNameField=form.down('#studentName');
	                        	   studentNameField.setDisabled(true);
	                        	   var selectionStageField=form.down('#selectionStage');
	                        	   selectionStageField.setDisabled(true);
	                        	   
	                           },
	                           deleteOfferletterdownloddocgrid:function(){
	                        	   var $this=this;
	                        	   var window = $this.getPlacementjobapplicationupdateofferwindow();
	                        	   var placementGrid = $this.getPlacementjobapplicationgrid();
	                        	   var grid = $this.getOfferletterdownloddocgrid();
	                        	   if (grid.getSelectionModel().getCount() > 0) {
	                        		   showConfirmMessage(getCommonTranslation('PLACEMENT_JOB_APPLICATION'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	                        			   if (btn == 'yes') {
	                        				   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                        				   var records = placementGrid.getSelectionModel().getSelection()[0];
	                        				   Ext.Ajax.request({
	                        					   method : "DELETE",
	                        					   type : 'rest',
	                        					   url : SERVERURL.PLACEMENT_JOB_OFFER_DOC_DELETE+'?placementJobOfferId='+ records.data.placementJobOfferId,
	                        					   headers : {
	                        						   'Content-Type' : 'application/json'
	                        					   },
	                        					   success : function(form,action) {
	                        						   Ext.getBody().unmask();
	                        						   grid.getStore().reload();
	                        						   placementGrid.getSelectionModel().deselectAll();
	                        						   placementGrid.getStore().reload();
	                        						   window.close();
	                        						   showSuccessMessage(getCommonTranslation('PLACEMENT_JOB_APPLICATION'),getPlacementTranslation('PLACEMENT_JOB_OFFER_DELSUCCESS_MSG'));
	                        					   }

	                        				   });
	                        			   }
	                        		   });
	                        	   }else {
	                        		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                        	   }
	                           },
	                           deletePlacementJobApplicationRecord:function(){
	                        	   var $this=this;
	                        	   var grid = $this.getPlacementjobapplicationgrid();
	                        	   if (grid.getSelectionModel().getCount() > 0) {
	                        		   showConfirmMessage(getPlacementTranslation('PLACEMENT_JOB_APPLICATION'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	                        			   if (btn == 'yes') {
	                        				   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                        				   var records = grid.getSelectionModel().getSelection();
	                        				   var id = records[0].get("id");
	                        				   Ext.Ajax.request({
	                        					   method : "DELETE",
	                        					   type : 'rest',
	                        					   url : SERVERURL.PLACEMENT_JOB_APPLICATION_DELETE+'?id='+ id,
	                        					   headers : {
	                        						   'Content-Type' : 'application/json'
	                        					   },
	                        					   success : function(form,action) {
	                        						   Ext.getBody().unmask();
	                        						   grid.getStore().reload();
	                        						   showSuccessMessage(getPlacementTranslation('PLACEMENT_JOB_APPLICATION'),getPlacementTranslation('PLACEMENT_JOB_APPLICATION_SUCCESS_MSG'));
	                        					   }

	                        				   });
	                        			   }
	                        		   });
	                        	   }else {
	                        		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                        	   }
	                           },
	                           addPlacementJobApplicationRecord:function(){
	                        	   var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
	                        	   var structure = Ext.widget('placementjobapplicationform');
	                        	   var tabName = getPlacementTranslation('APPLY_FOR_JOB');
	                        	   /**
	                        	    * This is to remove tab from content panel and open same tab again
	                        	    */
	                        	   var getcontroller=this.getController('menu.CoreERPNavigationController');
	                        	   var getTab=getcontroller.getTab(tabName);
	                        	   if(getTab!=null){
	                        		   contentPanel.remove(getTab, true);
	                        	   }
	                        	   openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_ONE);		
	                           },
	                           viewPlacementJobApplicationRecord:function(){

	                           },
	                           savePlacementAppOfferRecord:function(){
	                          
	                        	   var $this = this;
	                        	   
	                        	   var offerGrid = $this.getOfferletterdownloddocgrid();
	                        	   var record = offerGrid.getSelectionModel().getSelection();
	                        	   
	                        	   var offerWindow = $this.getPlacementjobapplicationupdateofferwindow();
	                        	   var form = offerWindow.down('#placementjobapplicationupdateofferwindow').getForm();
	                        	   var value = form.getValues();
	                        	   var grid = this.getPlacementjobapplicationgrid();
	                        	   var rec = grid.getSelectionModel().getSelection();
	                        	   var sponsor = this.getIdValueJson(value.sponsorId);
	                        	   var docs;
	                        	   var arr=[];
	                        	   var logineUser= this.getCurrentlyLoggedInUser().id;
	                        	   if(offerGrid.getStore().data.items.length==1) {
	                        	   //if(logineUser!=null) {
	                        		   var createdby ={
	                        				   id:	logineUser 
	                        		   };
	                        		   docs = {
	                        				   "createdBy":createdby,
	                        				   "name":offerGrid.getStore().data.items[0].data.documentName,
	                        				   "path":offerGrid.getStore().data.items[0].data.path,
	                        				   "type":"DOCUMENT"
	                        		   };
	                        		   for(var i in rec) {
		                        		   var jsonObj={
		                        				   "id":rec[i].data.placementJobOfferId,
		                        				   "placementJobApplicationId":rec[i].data.id,
		                        				   "placementJobLocationId":value.designation,
		                        				   "salaryPackage":value.saleryPKG,
		                        				   "dateOfJoining":value.dateOfJoining,
		                        				   "joiningStatus":value.status,
		                        				   "stipend":value.stipend,
		                        				   "sponsor":sponsor,
		                        				   "document":docs,
		                        				   "remark":value.remarks
		                        		   }
		                        		   arr.push(jsonObj);
		                        	   }
	                        	   } else {
	                        		   for(var i in rec) {
		                        		   var jsonObj={
		                        				   "id":rec[i].data.placementJobOfferId,
		                        				   "placementJobApplicationId":rec[i].data.id,
		                        				   "placementJobLocationId":value.designation,
		                        				   "salaryPackage":value.saleryPKG,
		                        				   "dateOfJoining":value.dateOfJoining,
		                        				   "stipend":value.stipend,
		                        				    "sponsor":sponsor,
		                        				   "joiningStatus":value.status,
		                        				   "remark":value.remarks
		                        		   }
		                        		   arr.push(jsonObj);
		                        	   }
	                        	   }
	                        	 
	                        	   
	                        	   submitUrl = SERVERURL.PLACEMENTJOB_APPLICATION_PROVIDEOFFER; 
	                        	   message = getPlacementTranslation('PLACEMENT_JOB_OFFER_SUCCESSFULLY_CREATED');
	                        	   var submitUrl; 
	                        	   var message;
	                        	   $this.applyWindowMask();
	                        	   Ext.Ajax.request({
	                        		   type : 'rest',
	                        		   url : submitUrl,
	                        		   jsonData : arr,
	                        		   method : 'POST',
	                        		   success : function(frm, action) {
	                        			   Ext.getBody().unmask();
	                        			   grid.getStore().reload(); 
	                        			   grid.getSelectionModel().deselectAll();
	                        			   offerWindow.close();
	                        			   showSuccessMessage(getPlacementTranslation('PLACEMENT_JOB_APPLICATION_SEND_LETTER'), message);
	                        		   }
	                        	   });

	                           },
	                           savePlacementJoiningStatusRecord:function(){

	                        	   var $this = this;
	                        	   var offerWindow = $this.getPlacementjobapplicationjoiningstatuswindow();
	                        	   var form = offerWindow.down('#placementjobapplicationjoiningstatuswindow').getForm();
	                        	   var value = form.getValues();
	                        	   var grid = this.getPlacementjobapplicationgrid();
	                        	   var rec = grid.getSelectionModel().getSelection();
	                        	   var arr=[];
	                        	   for(var i in rec) {
	                        		   var jsonObj={
	                        				   "id":rec[i].data.placementJobJoiningId,
	                        				   "placementJobApplicationId":rec[i].data.id,
	                        				   "usersByConfirmedById":value.confirmedBy,
	                        				   "joiningDate":value.dateOfJoining
	                        		   }
	                        		   arr.push(jsonObj);
	                        	   }
	                        	   submitUrl = SERVERURL.PLACEMENTJOB_APP_UPDATE_JOINING_STATUS; 
	                        	   message = getPlacementTranslation('PLACEMENT_JOB_JOINING_SUCCESSFULLY_UPDATED');
	                        	   var submitUrl; 
	                        	   var message;
	                        	   $this.applyWindowMask();
	                        	   Ext.Ajax.request({
	                        		   type : 'rest',
	                        		   url : submitUrl,
	                        		   jsonData : arr,
	                        		   method : 'POST',
	                        		   success : function(frm, action) {
	                        			   Ext.getBody().unmask();
	                        			   grid.getStore().reload(); 
	                        			   grid.getSelectionModel().deselectAll();
	                        			   offerWindow.close();
	                        			   showSuccessMessage(getPlacementTranslation('PLACEMENT_JOB_APPLICATION_JOINING_STATUS'), message);
	                        		   }
	                        	   });

	                           },
	                           savePlacementJobApplicationRecord: function(){
	                        	   // Create required json to Save
	                        	   var json = this.createJson();
	                        	   var formData = Ext.encode(json);
	                        	   // API call to save PlacementJobApplication
	                        	   var submitUrl = SERVERURL.PLACEMENT_JOB_APPLICATION_SAVE; 
	                        	   this.applyWindowMask();
	                        	   Ext.Ajax.request({
	                        		   type : 'rest',
	                        		   url : submitUrl,
	                        		   jsonData : formData,
	                        		   method : 'POST',
	                        		   success : function(frm, action) {
	                        			   Ext.getBody().unmask();
	                        			   showSuccessMessage(getPlacementTranslation('PLACEMENT_JOB_APPLICATION'), getPlacementTranslation('PLACEMENT_JOB_APPLICATION_CREATED_SUCCESSFULLY'));
	                        		   }
	                        	   });

	                           },
	                           createJson: function(){
	                        	   // Create required json to Save
	                        	   var json= "";
	                        	   return json;	
	                           },

	                           openUploadResumeFormWindow:function(obj){

	                        	   var grid = this.getPlacementjobapplicationgrid();
	                        	   if(grid.getSelectionModel().getCount()>0){
	                        		   this.getDocumentController().showDocumentFormWindow('placementUploadResume', 'DOCUMENT');
	                        	   }else{
	                        		   showWarningMessage(getCommonTranslation('JOB_APPLICATION_UPLOAD_RESUME'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
	                        	   }
	                           },

	                           getDocumentController : function(){
	                        	   var this$ = this;
	                        	   return this$.getController('Academia.controller.document.DocumentController');
	                           },

	                           uploadResumeJobApplication:function(obj){

	                        	   var this$ = this;
	                        	   var grid=this.getPlacementjobapplicationgrid();
	                        	   var isTransient = false;
	                        	   var module = 'placementUploadResume';
	                        	   var entityId ;
	                        	   var entityType = 'placementUploadResume';
	                        	   this$.applyWindowMask(); 

	                        	   this$.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function(success, response, isCallBackTransient){
	                        		   this$.hideWindowMask();
	                        		   if(success){
	                        			   var record = grid.getSelectionModel().getSelection()[0];
	                        			   var id = record.get("id");
	                        			   var documentId = Ext.decode(response.responseText);
	                        			   var updateUrl = SERVERURL.PLACEMENT_JOB_APPLICATION_UPLOAD_RESUME+'?id='+id+'&documentId='+documentId;
	                        			   Ext.Ajax.request({
	                        				   type : 'rest',
	                        				   url : updateUrl,
	                        				   method : 'POST',
	                        				   success : function(response, action) {
	                        					   this$.hideWindowMask();
	                        					   showSuccessMessage(getCommonTranslation('JOB_APPLICATION_UPLOAD_RESUME'), getFeeAndPaymentCommonTranslation('DOCUMENT_UPLOADED_SUCCESSFULLY'));
	                        					   grid.getStore().reload();
	                        				   }
	                        			   });
	                        		   }
	                        		   this$.getDocumentController().closeDocumentFormWindow();

	                        	   }, isTransient);
	                           },

	                           getDownloadFileForResumePDocument : function(documentId){
	                        	   if(!isNullOrEmpty(documentId)){
	                        		   var csvForm = Ext.create('Ext.form.Panel'); 
	                        		   csvForm.getForm().submit({
	                        			   target: '_blank',
	                        			   method:'GET',
	                        			   params :{
	                        				   access_token : Ext.Ajax.defaultHeaders.access_token
	                        			   },
	                        			   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	                        			   url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
	                        			   standardSubmit :true
	                        		   });
	                        	   }
	                           },
                               applyStudentForJobApplication : function() {
                                   var this$ = this;					    		
	                        	   var applyGrid = this$.getPlacementjobapplicationapplyjobgrid();
	                        	   var record = applyGrid.getSelectionModel().getSelection();
	                        	   var applyWin = this$.getPlacementjobapplicationjobapplywindow();
	                        	   var applyFormVal = applyWin.down('form').getValues();

	                        	   var mainObj = new Array();
	                        	   var applicationStatus = 'APPLIED';
	                        	   var jobLocationIds = applyFormVal.multiselectPlacementLocation;
	                        	   var mainJobLocationIds = new Array();
	                        	   var placementLocLength = 0; 
	                        	   if(!isNullOrEmpty(applyFormVal.multiselectPlacementLocation)) {
	                        		   placementLocLength = applyFormVal.multiselectPlacementLocation.length;
	                        	   }
	                        	   for(var i=0;i<placementLocLength;i++) {
	                        		   mainJobLocationIds.push(jobLocationIds[i].data.id);
	                        	   }

	                        	   var form = this.getPlacementjobapplicationform();
	                        	   var placementCampusId = form.down("#placementjobapplicationItemId").getValue();

	                        	   if (applyGrid.getSelectionModel().getCount() > 0) {
	                        		   for(var i = 0; i< record.length;i++){
	                        			   var parameterListObj =new Object();

	                        			   parameterListObj.placementJobId = applyFormVal.jobtitle;
	                        			   parameterListObj.academyLocationId = applyFormVal.recruitingOrganization;

	                        			   parameterListObj.placementCampusId = placementCampusId;
	                        			   parameterListObj.admissionId = record[i].data.admissionId;
	                        			   parameterListObj.applicationStatus = applicationStatus;
	                        			   parameterListObj.joiningStatus = 'PENDING';
	                        			   parameterListObj.offerStatus = 'PENDING';
	                        			   parameterListObj.jobLocationIds = mainJobLocationIds;
	                        			   mainObj.push(parameterListObj);
	                        		   }
	                        	   }
	                        	   var jsonSubmitData = Ext.encode(mainObj);
	                        	   var submitUrl = SERVERURL.PLACEMENT_JOB_APPLICATION_SAVE_ALL; 
	                        	   Ext.Ajax.request({
	                        		   type : 'rest',
	                        		   url : submitUrl,
	                        		   jsonData : jsonSubmitData,
	                        		   method : 'POST',
	                        		   success : function(frm, action) {
	                        			   Ext.getBody().unmask();
	                        			   showSuccessMessage(getPlacementTranslation('PLACEMENT_JOB_APPLICATION'), getPlacementTranslation('PLACEMENT_JOB_APPLICATION_CREATED_SUCCESSFULLY'));
	                        		   }
	                        	   });

	                        	   applyWin.close();
	                           },
	                           enableDisableUploadResumeBtn : function() {

	                        	   var jobapplicationGrid=this.getPlacementjobapplicationgrid();
	                        	   var uploadResumeBtn = jobapplicationGrid.down('#uploadResume');
	                        	   console.log('Grid ',jobapplicationGrid);
	                        	   if (jobapplicationGrid.getSelectionModel().getCount() > 1) {
	                        		   uploadResumeBtn.disable();
	                        	   } else {
	                        		   uploadResumeBtn.enable();
	                        	   }
	                           },
	                           enableDisableOfferStatusBtn: function() {

						    		var placementJobGrid=this.getPlacementjobapplicationgrid();
						    		var updateOfferStatus = placementJobGrid.down('#updateOfferStatus');
						    		var record = placementJobGrid.getSelectionModel().getSelection();
						    		if (placementJobGrid.getSelectionModel().getCount() > 1) {
	 			        				updateOfferStatus.disable(); 
									 }
									else{
										if (placementJobGrid.getSelectionModel().getCount() == 1) 
											{
	 			        						if(record[0].data.offerStatus=='REJECTED' || record[0].data.offerStatus=='OFFERED')
												{
						        				updateOfferStatus.disable(); 
							        			}
												else { updateOfferStatus.enable();  }
											}
											else { updateOfferStatus.enable();  } 			
									 }
								},
	                           enableDisableJoinigStatusBtn : function() {

						    		var placementJobGrid=this.getPlacementjobapplicationgrid();
						    		var joinigStatusBtn = placementJobGrid.down('#updateJoiningStatus');
						    		var record = placementJobGrid.getSelectionModel().getSelection();
						    		 if (placementJobGrid.getSelectionModel().getCount() > 1) {
										joinigStatusBtn.disable();   
						    		} else { if (placementJobGrid.getSelectionModel().getCount() == 1) 
											{if(record[0].data.offerStatus !='OFFERED'){
						        				joinigStatusBtn.disable(); 
						        			}else {joinigStatusBtn.enable();}
											}else {joinigStatusBtn.enable();}
						    		}
	                           },
	                           getDocumentController : function(){
	                        	   var this$ = this;
	                        	   return this$.getController('Academia.controller.document.DocumentController');
	                           },
	                           jobApplicationgridButtonPivileges: function(gridReference,permissionsMap) {

	                        	   var associatedAcadLocationIds = new Array();
	                        	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
	                        	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	                        	   buttonsToolBar = gridReference.query('toolbar')[0];

	                        	   var addApplicationBtn = buttonsToolBar.query('#addApplication')[0];
	                        	   addApplicationBtn.setVisible(false);

	                        	   var sendOfferLetterBtn = buttonsToolBar.query('#sendOfferLetter')[0];
	                        	   sendOfferLetterBtn.setVisible(false);

	                        	   var updateOfferStatusBtn = buttonsToolBar.query('#updateOfferStatus')[0];
	                        	   updateOfferStatusBtn.setVisible(false);

	                        	   var updateJoiningStatusBtn = buttonsToolBar.query('#updateJoiningStatus')[0];
	                        	   updateJoiningStatusBtn.setVisible(false);

	                        	   var uploadResumeBtn = buttonsToolBar.query('#uploadResume')[0];
	                        	   uploadResumeBtn.setVisible(false);

	                        	   Ext.each(permissionList, function(privilege) {
	                        		   if (privilege === 'ADDAPPLICATION') {
	                        			   if(!isNullOrEmpty(addApplicationBtn)){
	                        				   addApplicationBtn.setVisible(true);
	                        			   }        		
	                        		   }
	                        		   if (privilege === 'SENDOFFERLETTER') {
	                        			   if(!isNullOrEmpty(sendOfferLetterBtn)){
	                        				   sendOfferLetterBtn.setVisible(true);
	                        			   }        		
	                        		   }
	                        		   if (privilege === 'UPDATEOFFERSTATUS') {
	                        			   if(!isNullOrEmpty(updateOfferStatusBtn)){
	                        				   updateOfferStatusBtn.setVisible(true);
	                        			   }        		
	                        		   }
	                        		   if (privilege === 'UPDATEJOININGSTATUS') {
	                        			   if(!isNullOrEmpty(updateJoiningStatusBtn)){
	                        				   updateJoiningStatusBtn.setVisible(true);
	                        			   }        		
	                        		   }
	                        		   if (privilege === 'UPLOADRESUME') {
	                        			   if(!isNullOrEmpty(uploadResumeBtn)){
	                        				   uploadResumeBtn.setVisible(true);
	                        			   }        		
	                        		   }			    	

	                        	   });
	                           },
	                           getIdValueJson : function(id, value) {
	                             	if (id)
	                             		return {
	                             		id : id,
	                             		value : value
	                             	};
	                             },
	                             
	                             loadPlacementAppliedJobGrid:function(){
	                            	 var $this=this;
	                            	 var form = $this.getPlacementappliedjobfilter();
	                            	 var placementcampus = form.down("#placementcampusItemId").getValue();
	                            	 var academyLocation = form.down("#academyLocation").getValue();
	                            	 //  var placementjobapplicationItemId = form.down("#placementjobapplicationItemId").getValue();
                                     var status = form.down("#status").getValue();
	                            	 var admissionId=$this.getCurrentlyLoggedInUser().id;
	                            	 var grid = $this.getPlacementappliedjobgrid();
	                            	 var store =  grid.getStore();
	                            	 store.getProxy().extraParams = {
	                            		 admissionId: admissionId,
	                            		 recruitingOrganizationALId: academyLocation,
	                            		 placementCampusId: placementcampus,
	                            		 status:status,
	                            	 };
	                            	 store.load();
	                            	 /*pdf & excel report header filter*/
	                             	 grid.config.searchFilterForm = $this.getPlacementappliedjobfilter();
	                             },
	                           
	                           openUploadResumeForStudent:function(obj){
	                        	   var grid = this.getPlacementappliedjobgrid();
	                        	   if(grid.getSelectionModel().getCount()>0){
	                        		   this.getDocumentController().showDocumentFormWindow('studentUploadResume', 'DOCUMENT');
	                        	   }else{
	                        		   showWarningMessage(getCommonTranslation('JOB_APPLICATION_UPLOAD_RESUME'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
	                        	   }
	                           },
	                           
	                           uploadResumeAppliedJobApplication:function(obj){

	                        	   var this$ = this;
	                        	   var grid=this.getPlacementappliedjobgrid();
	                        	   var isTransient = false;
	                        	   var module = 'studentUploadResume';
	                        	   var entityId ;
	                        	   var entityType = 'studentUploadResume';
	                        	   this$.applyWindowMask(); 

	                        	   this$.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function(success, response, isCallBackTransient){
	                        		   this$.hideWindowMask();
	                        		   if(success){
	                        			   var record = grid.getSelectionModel().getSelection()[0];
	                        			   var id = record.get("id");
	                        			   var documentId = Ext.decode(response.responseText);
	                        			   var updateUrl = SERVERURL.PLACEMENT_JOB_APPLICATION_UPLOAD_RESUME+'?id='+id+'&documentId='+documentId;
	                        			   Ext.Ajax.request({
	                        				   type : 'rest',
	                        				   url : updateUrl,
	                        				   method : 'POST',
	                        				   success : function(response, action) {
	                        					   this$.hideWindowMask();
	                        					   showSuccessMessage(getCommonTranslation('JOB_APPLICATION_UPLOAD_RESUME'), getFeeAndPaymentCommonTranslation('DOCUMENT_UPLOADED_SUCCESSFULLY'));
	                        					   grid.getStore().reload();
	                        				   }
	                        			   });
	                        		   }
	                        		   this$.getDocumentController().closeDocumentFormWindow();

	                        	   }, isTransient);
	                           },
	                           
//	                           open appliedjob Location Grid window
	                           
	                           getAppliedJobLocationGridWindow:function(grid,record){
	                        	   var frmWin = this.getPlacementjoblocationgridwindow();
	                        	   if(!frmWin){
	                        		   Ext.widget('placementjoblocationgridwindow');
	                        		   frmWin = this.getPlacementjoblocationgridwindow();
	                        	   }
	                        	   var placementappliedjobgrid=this.getPlacementappliedjobgrid();
	                        	   //var record = placementappliedjobgrid.getSelectionModel().getSelection()[0];
	                        	   frmWin.down('#jobTitle').setValue(record.data.jobTitle);
	                        	   frmWin.down('#placementCampus').setValue(record.data.placementCampus);
	                        	   frmWin.down('#recruitingOrgName').setValue(record.data.recruitingOrgName);
	                        	   var gridStore=frmWin.down('grid').getStore();
	                        	   gridStore.getProxy().extraParams={
	                        		   placementJobId: record.data.placementJobId
	                        	   }
	                        	   gridStore.load();
	                        	   frmWin.show();
	                           },
	                           
	                           resetPlacementAppliedJobFilter:function(){
	                        	   var $this=this;
	                        	   var filter = $this.getPlacementappliedjobfilter().getForm();
	                        	   filter.reset();
	                           },
	                           
	                           loadPlacementAvailableJobApplicationGrid:function(){
	                        	   var $this=this;
	                        	   var form = $this.getPlacementavailablejobfilter();
	                        	   var placementjobapplicationItemId = form.down("#placementcampusItemId").getValue();
	                        	   var jobCompany = form.down("#jobCompanyId").getValue();
	                        	   var coordinatorId = form.down("#coordinatorItemId").getValue();
	                        	   var whetherAllowedtemp = form.down("#placementcampusItemId").valueModels[0];
	                        	   var whetherAllowed=whetherAllowedtemp.get('whetherAllowed');
	                        	   var admissionId = $this.getCurrentlyLoggedInUserInfoForPortal().admissionDetails[0].id;
	                        	   var grid = $this.getPlacementavailablejobgrid();
	                        	   var store =  grid.getStore();
	                        	   var periodId=$this.getCurrentlyLoggedInUserInfoForPortal().programBatchDetails.periodId;
	                        	   store.getProxy().extraParams = {
	                        		   placementDriveId: placementjobapplicationItemId,
	                        		   admissionId:admissionId,
	                        		   jobCompanyId:jobCompany,
	                        		   coordinatorId:coordinatorId,
	                        		   periodId:periodId,
	                        		   whetherAllowed:whetherAllowed
	                        	   };
	                        	   store.load();
	                           },
	                           
	                           openJobApplicationJobApplyForStudentWindow:function(obj){

	                        	   var formWindow = this.getPlacementjobapplicationjobapplywindow();
	                        	   if (!formWindow) {
	                        		   Ext.widget('placementavailablejobapplicationjobapplywindow');
	                        		   formWindow = this.getPlacementavailablejobapplicationjobapplywindow();
	                        	   }
	                        	   formWindow.show();

	                           },
	                           
	                           applyForStudentJobApplication : function() {

	                        	   var this$ = this;					    		
	                        	   var applyGrid = this$.getPlacementavailablejobgrid();
	                        	   var record = applyGrid.getSelectionModel().getSelection();
	                        	   var applyWin = this$.getPlacementavailablejobapplicationjobapplywindow();
	                        	   var applyFormVal = applyWin.down('form').getValues();

	                        	   var mainObj = new Array();
	                        	   var applicationStatus = 'APPLIED';
	                        	   var jobLocationIds = applyFormVal.multiselectPlacementLocation;
	                        	   var mainJobLocationIds = new Array();
	                        	   var placementLocLength = 0; 
	                        	   if(!isNullOrEmpty(applyFormVal.multiselectPlacementLocation)) {
	                        		   placementLocLength = applyFormVal.multiselectPlacementLocation.length;
	                        	   }
	                        	   for(var i=0;i<placementLocLength;i++) {
	                        		   mainJobLocationIds.push(jobLocationIds[i].data.id);
	                        	   }

	                        	   var form = this.getPlacementjobapplicationform();
	                        	   //var placementCampusId = form.down("#placementjobapplicationItemId").getValue();
	                        	   var admissionId = this$.getCurrentlyLoggedInUserInfoForPortal().admissionDetails[0].id;
	                        	   if (applyGrid.getSelectionModel().getCount() > 0) {
	                        		   for(var i = 0; i< record.length;i++){
	                        			   var parameterListObj =new Object();

	                        			   parameterListObj.placementJobId = record[i].data.jobId;
	                        			   parameterListObj.academyLocationId = applyFormVal.recruitingOrganization;

	                        			   parameterListObj.placementCampusId = record[i].data.placementCampusId;
	                        			   parameterListObj.admissionId = admissionId;
	                        			   parameterListObj.applicationStatus = applicationStatus;
	                        			   parameterListObj.joiningStatus = 'PENDING';
	                        			   parameterListObj.offerStatus = 'PENDING';
	                        			   parameterListObj.jobLocationIds = mainJobLocationIds;
	                        			   mainObj.push(parameterListObj);
	                        		   }
	                        	   }
	                        	   var jsonSubmitData = Ext.encode(mainObj);
	                        	   var submitUrl = SERVERURL.PLACEMENT_JOB_APPLICATION_SAVE_ALL; 
	                        	   Ext.Ajax.request({
	                        		   type : 'rest',
	                        		   url : submitUrl,
	                        		   jsonData : jsonSubmitData,
	                        		   method : 'POST',
	                        		   success : function(frm, action) {
	                        			   Ext.getBody().unmask();
	                        			   showSuccessMessage(getPlacementTranslation('PLACEMENT_JOB_APPLICATION'), getPlacementTranslation('PLACEMENT_JOB_APPLICATION_CREATED_SUCCESSFULLY'));
	                        		   }
	                        	   });

	                        	   applyWin.close();
	                        	   this$.loadPlacementAvailableJobApplicationGrid();
	                           },
	                           
//	                           open available Job Location Grid window
	                           
	                           getAvailableJobLocationGridWindow:function(grid,record){
	                        	   var frmWin = this.getPlacementjoblocationgridwindow();
	                        	   if(!frmWin){
	                        		   Ext.widget('placementjoblocationgridwindow');
	                        		   frmWin = this.getPlacementjoblocationgridwindow();
	                        	   }
	                        	   var placementavailablejobgrid=this.getPlacementavailablejobgrid();
	                        	   //var record = placementappliedjobgrid.getSelectionModel().getSelection()[0];
	                        	   frmWin.down('#jobTitle').setValue(record.data.jobTitle);
	                        	   frmWin.down('#placementCampus').setValue(record.data.placementCampusName);
	                        	   frmWin.down('#recruitingOrgName').setValue(record.data.companyName);
	                        	   var gridStore=frmWin.down('grid').getStore();
	                        	   gridStore.getProxy().extraParams={
	                        		   placementJobId: record.data.jobId
	                        	   }
	                        	   gridStore.load();
	                        	   frmWin.show();
	                           },
	                           
//	                           open available Job selection Grid window
	                           
	                           getPlacementSelectionGridWindow:function(grid,record){
	                        	   var frmWin = this.getPlacementselectionprocesswindow();
	                        	   if(!frmWin){
	                        		   Ext.widget('placementselectionprocesswindow');
	                        		   frmWin = this.getPlacementselectionprocesswindow();
	                        	   }
	                        	   var placementavailablejobgrid=this.getPlacementavailablejobgrid();
	                        	   //var record = placementappliedjobgrid.getSelectionModel().getSelection()[0];
	                        	   frmWin.down('#selectionProcess').setValue(record.data.selectionStage);
	                        	   frmWin.down('#placementCampus').setValue(record.data.placementCampusName);
	                        	   frmWin.down('#recruitingOrgName').setValue(record.data.companyName);
	                        	   frmWin.down('#jobTitle').setValue(record.data.jobTitle);
	                        	   var gridStore=frmWin.down('grid').getStore();
	                        	   gridStore.getProxy().extraParams={
	                        		   placementJobId: record.data.jobId
	                        	   }
	                        	   gridStore.load();
	                        	   frmWin.show();
	                           },
	                           
	                           disableAppliedGridPivileges: function(gridReference,permissionsMap) {

	                        	   var associatedAcadLocationIds = new Array();
	                        	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	                        	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	                        	   buttonsToolBar = gridReference.query('toolbar')[0];
	                        	   var uploadResumeBtn = gridReference.down('#uploadResume');

	                        	   uploadResumeBtn.setVisible(false);
	                        	   Ext.each(permissionList, function(privilege) {
	                        		   if (privilege === 'UPLOADRESUME') {
	                        			   if(!isNullOrEmpty(uploadResumeBtn)){
	                        				   uploadResumeBtn.setVisible(true);
	                        			   }        		
	                        		   }

	                        	   });
	                           },
	                           
	                           disableAvailableGridPivileges: function(gridReference,permissionsMap) {

	                        	   var associatedAcadLocationIds = new Array();
	                        	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	                        	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	                        	   buttonsToolBar = gridReference.query('toolbar')[0];
	                        	   var applyJobBtn = gridReference.down('#applyJobId');

	                        	   applyJobBtn.setVisible(false);
	                        	   Ext.each(permissionList, function(privilege) {
	                        		   if (privilege === 'APPLY') {
	                        			   if(!isNullOrEmpty(applyJobBtn)){
	                        				   applyJobBtn.setVisible(true);
	                        			   }        		
	                        		   }

	                        	   });
	                           },
	                           
//	                           open document Grid window
	                           getdocumentGridWindow:function(grid,record){
	                        	   var $this=this;
	                        	   var placementCampusId = record.get("placementCampusId");
	                        	   var formWindow = $this.getPlacementcampusdocumentgridwindow();
	                        	   if (!formWindow) {
	                        		   Ext.widget('placementcampusdocumentgridwindow');
	                        		   formWindow = $this.getPlacementcampusdocumentgridwindow();
	                        	   }		                            	 
	                        	   formWindow.show();

	                        	   var grid = formWindow.down('#documentGridWin');
	                        	   var store = grid.getStore();
	                        	   store.getProxy().extraParams = {
	                        		   placementCampusId: placementCampusId,
	                        	   };
	                        	   store.load();
	                           },
	                           
	                           
	                           /*function added for adhoc messsaging*/
	                           openStudentSendMessage:function(obj){

	                   	    	var grid = this.getPlacementjobapplicationgrid();
	                   	    	//var gridMSG = this.getStaticDocumentAttachmentGrid();
	                   	    	if(grid.getSelectionModel().getCount()>0) {
	                   	    		
	                   	    			var $this=this;
	                   	    			var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
	                   	    	       	   var structure = Ext.widget('placementjobsendmessages',{
	                                  			itemId:'placementSendMessageWindow'
	                                  		});
	                   	    	       	   var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
	                   	    	       	   /**
	                   	    	       	    * This is to remove tab from content panel and open same tab again
	                   	    	       	    */
	                   	    	       	   var getcontroller=this.getController('menu.CoreERPNavigationController');
	                   	    	       	   var getTab=getcontroller.getTab(tabName);
	                   	    	       	   if(getTab!=null){
	                   	    	       		   contentPanel.remove(getTab, true);
	                   	    	       	   }
	                   	    	       	var formWindowTab = $this.getPlacementjobsendmessages();
	                   	    	       	formWindowTab.down("#selectTemplate").allowBlank=true;
	                   	    	       	formWindowTab.down("#selectTemplate").setVisible(false);
	                   	    	       	formWindowTab.down("#messageName").allowBlank=true;   
	                   	    	       	formWindowTab.down("#messageName").setVisible(false);
	                   	    			var templateStore = formWindowTab.down('#selectTemplate').getStore();
	                   	    			templateStore.getProxy().extraParams={
	                   	    				msgRecipientTypeId:2
	                   	    			};
	                   	    			templateStore.load();
	                   	    			
	                   	    			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                   	    			   Ext.Ajax.request({
	                   	    				   method : "GET",
	                   	    				   type : 'rest',
	                   	    				   url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=PlacementJobTemplatebe539740-692d-4ae1-bc17-338c4002874d',	//Committeebe539740-692d-4ae1-bc17-338c4002874d',
	                   	    				   headers : {
	                   	    					   'Content-Type' : 'application/json'
	                   	    				   },
	                   	    				   success : function(form,action) {
	                   	    					   var data = Ext.JSON.decode(form.responseText);
	                   	    					   formWindowTab.down("#id").setValue(data.id);
	                   	    					   formWindowTab.down("#code").setValue(data.code);
	                   	    					   formWindowTab.down("#templateConfigName").setValue(data.templateConfigName);
	                   	    					   formWindowTab.down("#msgSubCategoryId").setValue(data.msgSubCategoryId);
	                   	    					   formWindowTab.down("#msgCategoryId").setValue(data.msgCategoryId);
	                   	    					   Ext.getBody().unmask();
	                   	    					   
	                   	    					   //grid.getStore().reload();
	                   	    					   //showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
	                   	    				   }

	                   	    			   });
	                   	    	       	openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_ONE);
	                   	    				                   	    		
	                   	    	} else {
	                   	    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                   	    	}
	                   	    },
	                   	 selectPlacementSectionMessageType : function(val,nV,oV){

	                   	      	 var $this =  this;
	                   	      	 var formWin = $this.getPlacementjobsendmessages();
	                   	      	 formWin.down("#templatedItemId").hide();
                                 formWin.down("#templatedItemId").allowBlank=true;

	                   	      	 //var value = nV.1;
	                   	      	 if(nV.messageType==2){
	                   	      		 formWin.down("#messageId").hide();
	                   	      		 formWin.down("#selectTemplate").allowBlank=true;
	                   	      		 formWin.down("#selectTemplate").setVisible(false);     		 
	                   	      		 formWin.down("#messageName").allowBlank=true;   
	                   	      		 formWin.down("#messageName").setVisible(false);
	                   	      		 formWin.down("#msgTempletId").setVisible(true);
	                   	      		 formWin.down("#msgTempletId").allowBlank=false;
	                   	      		 formWin.down("#msgTempletId").reset();
	                   	      		 formWin.down("#subject").setVisible(true);
	                   	      		 formWin.down("#subject").allowBlank=false;
	                   	      		 formWin.down("#subject").reset();
	                   	      		 formWin.down("#discriptionId").setVisible(true);
	                   	      		 formWin.down("#discriptionId").reset();
	                   	      		 formWin.down('#smsDiscription').reset();
	                   	      		 formWin.down('#smsDiscription').hide();
	                   	      		 formWin.down('#smsDiscriptionNotice').hide();
	                   	      		 formWin.down('#pushNotificationDiscription').hide();
	                   	      		 formWin.down('#pushNotificationDiscriptionNotice').hide();
	                   	      		 formWin.down('#fldSendToContainer').show();
	                   	      	 }else{
	                   	      		 formWin.down("#msgTempletId").allowBlank=true;
	                   	      		 formWin.down("#msgTempletId").setVisible(false);     		
	                   	      		 formWin.down("#messageId").setVisible(true);
	                   	      		 formWin.down("#selectTemplate").setVisible(true);     		
	                   	      		 formWin.down("#messageName").setVisible(true);
	                   	      		 formWin.down("#messageName").reset();
	                   	      		 formWin.down("#subject").allowBlank=true;
	                   	      		 formWin.down("#subject").setVisible(false);
	                   	      		 formWin.down("#discriptionId").setVisible(false);
	                   	      		 formWin.down("#messageName").allowBlank=false;  
	                   	      		 formWin.down("#selectTemplate").allowBlank=false;
	                   	      		 formWin.down("#selectTemplate").reset();
	                   	      		 formWin.down("#placementjobDocumentMessageAttachmentGrid").setVisible(false);
	                   	      		 formWin.down("#staticUploadFileField").setVisible(false);
	                   	      		 formWin.down('#smsDiscription').reset();
	                   	      		 formWin.down('#smsDiscription').hide();
	                   	      		 formWin.down('#smsDiscriptionNotice').hide();
	                   	      		 formWin.down('#pushNotificationDiscription').hide();
	                   	      		 formWin.down('#pushNotificationDiscriptionNotice').hide();
                                     this.setAllowBlank (formWin.down("#messageName"),false);
                                     this.setAllowBlank (formWin.down("#selectTemplate"),false);
	                   	      		// var allowblankFalse = '<span class="required" style="color:red"> *</span>';
	                   	      //	 formWin.down("#messageName").setFieldLabel(getMessagingModuleTranslation('MESSAGE_NAME')+allowblankFalse);
	                   	      	// formWin.down("#selectTemplate").setFieldLabel(getMessagingModuleTranslation('SELECT_TEMPLATE')+allowblankFalse);
	                   	      		 formWin.down('#fldSendToContainer').hide();
	                   	      	 }
	                   	      	 formWin.getForm().checkValidity();
	                   	       },
	                   	       selectPlacementMessageTemp: function(obj,rec){
	                   	    	   var $this =  this;
	                   	    	   var formWin = $this.getPlacementjobsendmessages();
	                   	    	   var subject = formWin.down('#subject');
	                   	    	   var smsDiscription = formWin.down('#smsDiscription');
	                   	    	   var smsDiscriptionNotice = formWin.down('#smsDiscriptionNotice');
	                   	    	   var pushNotificationDiscription = formWin.down('#pushNotificationDiscription');
	                   	    	   var pushNotificationDiscriptionNotice = formWin.down('#pushNotificationDiscriptionNotice');
	                   	    	   formWin.down("#templatedItemId").hide();
		                           formWin.down("#templatedItemId").reset();
		                           if(formWin.defaultValue){
			                       formWin.down("#templatedItemId").setValue(formWin.defaultValue)
 		                                }
		                           
                            	   formWin.down("#templatedItemId").allowBlank=true;
	                   	    	   if(rec[0].data.value == "SMS")
	                   	    	   {
	                   	    		   formWin.down("#subject").allowBlank=true;
	                   	    	       formWin.down("#subject").hide();
	                   	    	 if(formWin.templateIdVisble){
      			                   formWin.down("#templatedItemId").show();
      			                   
      		                  }else{
      		                  formWin.down("#templatedItemId").allowBlank=true;
      			                   formWin.down("#templatedItemId").hide();
      			 
      		             }if(formWin.templateIdMandatory){
      			              if(formWin.templateIdVisble){
                                       formWin.down("#templatedItemId").allowBlank=false;
                                       formWin.down("#templatedItemId").setFieldLabel(getMessagingModuleTranslation('TEMPLATE_ID') +'<span class="required" style="color:red"> *</span>')

                               }else{
                                      formWin.down("#templatedItemId").allowBlank=true;
                               }
      		   }
      		   else{
     			formWin.down("#templatedItemId").allowBlank=true;
      		 
      		           }       
	                   	    		   formWin.down("#staticUploadFileField").hide();
	                   	    		   formWin.down("#placementjobDocumentMessageAttachmentGrid").hide();
	                   	    		   formWin.down('#discriptionId').reset();
	                   	    		   formWin.down('#discriptionId').hide();	       		 
	                   	    		   subject.reset();
	                   	    		   smsDiscription.show();
	                   	    		   smsDiscriptionNotice.show();
	                   	    		   pushNotificationDiscription.hide();
	                   	    		   pushNotificationDiscriptionNotice.hide();
	                   	    		   pushNotificationDiscription.reset();
	                   	    		   formWin.getForm().checkValidity();
	                   	    	   } else if(rec[0].data.Dvalue == "PUSH_NOTIFICATION_ONLY" || rec[0].data.value == "Push Notification Only")
	                   	    	   {
	                   	    		   formWin.down('#discriptionId').reset();
	                   	    		   formWin.down('#smsDiscription').reset();
	                   	    		   formWin.down('#smsDiscription').hide();
	                   	    		   formWin.down('#smsDiscriptionNotice').hide();
	                   	    		   formWin.down("#staticUploadFileField").hide();
	                   	    		   // formWin.down("#staticDocumentMessageAttachmentGrid").show();
	                   	    		   formWin.down("#placementjobDocumentMessageAttachmentGrid").hide()
	                   	    		   subject.show();
	                   	    		   subject.reset();
	                   	    		   this.setAllowBlank (subject,false);
	                   	    		   //formWin.down("#subject").allowBlank=false;
	                   	    		   formWin.down('#discriptionId').show();
	                   	    		   pushNotificationDiscription.hide();
	                   	    		   pushNotificationDiscriptionNotice.hide();
	                   	    		   pushNotificationDiscription.reset();
	                   	    		   formWin.getForm().checkValidity();
	                   	    	   }
	                   	    	   /*else if(rec[0].data.Dvalue == "PUSH_NOTIFICATION" || rec[0].data.value == "Push Notification"){
	                   	    		   subject.show();
	                   	    		   formWin.down("#staticUploadFileField").hide();
	                   	    		   this.setAllowBlank (subject,false);
	                   	    		   formWin.down("#placementjobDocumentMessageAttachmentGrid").hide();
	                   	    		   formWin.down('#discriptionId').reset();
	                   	    		   formWin.down('#discriptionId').hide();
	                   	    		   subject.reset();
	                   	    		   smsDiscription.reset();
	                   	    		   smsDiscription.hide();
	                   	    		   smsDiscriptionNotice.hide();
	                   	    		   pushNotificationDiscription.reset();
	                   	    		   pushNotificationDiscription.show();
	                   	    		   pushNotificationDiscriptionNotice.show();
	                   	    		   pushNotificationDiscriptionNotice.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+' 1000/1000</span>');
	                   	    		   //formWin.down('#smsDiscription')
	                   	    		   formWin.getForm().checkValidity();
	                   	    	   }*/
	                   	    	   else
	                   	    	   {
	                   	    		   formWin.down('#discriptionId').reset();
	                   	    		   formWin.down('#smsDiscription').reset();
	                   	    		   formWin.down('#smsDiscription').hide();
	                   	    		   formWin.down('#smsDiscriptionNotice').hide();
	                   	    		   formWin.down("#staticUploadFileField").show();
	                   	    		   // formWin.down("#staticDocumentMessageAttachmentGrid").show();
	                   	    		   formWin.down("#placementjobDocumentMessageAttachmentGrid").show()
	                   	    		   subject.show();
	                   	    		   subject.reset();
	                   	    		   this.setAllowBlank (subject,false);
	                   	    		   //formWin.down("#subject").allowBlank=false;
	                   	    		   formWin.down('#discriptionId').show();
	                   	    		   pushNotificationDiscription.hide();
	                   	    		   pushNotificationDiscriptionNotice.hide();
	                   	    		   pushNotificationDiscription.reset();
	                   	    		   formWin.getForm().checkValidity();
	                   	    	   }
	                   	       },
	                   	       /**
	                   	        * upload static document file for Student
	                   	        */
	                   	       uploadPlacementStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts){
	                   	    	   var this$ = this;
	                   	    	   var setupForm = fileField.up('placementjobsendmessages');
	                   	    	   var grid = setupForm.down('#placementjobStaticDocumentAttachmentGridMessage');
	                   	    	   fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
	                   	    	   fileField.setRawValue(fileUploadPath);
	                   	    	   var file = fileField.fileInputEl.dom.files[0];
	                   	    	   var fileSizeLimit = '5';
	                   	    	   var url = SERVERURL.FILE_PRIORITY;
	                   	    	   Ext.Ajax.request({
	                   	    		   type: 'rest',
	                   	    		   url: url+'?type=emailFileSize',
	                   	    		   method: 'GET',
	                   	    		   success : function(response, action){
	                   	    			   var responseData = Ext.JSON.decode(response.responseText);
	                   	    			   if(responseData.length>0 && responseData[0].value!=undefined && !isNullOrEmpty(responseData[0].value))
	                   	    			   {
	                   	    				   fileSizeLimit=responseData[0].value;
	                   	    			   }
	                   	    			   if((file.size / 1048576) <=  fileSizeLimit ){

	                   	    				   if(!isNullOrEmpty(fileUploadPath)){
	                   	    					   var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
	                   	    					   if (extension == "gif" || extension == "png" || extension == "bmp"
	                   	    						   || extension == "jpeg" || extension == "jpg" || extension == "pdf" 
	                   	    							   || extension == "doc" || extension == "docx" || extension == "txt"
	                   	    								   || extension == "xls" || extension == "csv" || extension == "xml" || extension == "zip" || extension == "xlsx"){
	                   	    						   var entityId = 'placement';
	                   	    						   var module = 'messaging';
	                   	    						   var entityType = 'template';
	                   	    						   var documentType = 'DOCUMENT';
	                   	    						   var isTransient = true;
	                   	    						   this$.saveStaticDocumentFormMessage(entityId, module, entityType, documentType, function(success, action, isTransient){
	                   	    							   if(success){
	                   	    								   var path = Ext.JSON.decode(action.response.responseText).path;
	                   	    								   var user = this$.getCurrentlyLoggedInUser();
	                   	    								   var store = grid.getStore();
	                   	    								   var documentStatus = "SUBMITTED";
	                   	    								   var documentType = null;
	                   	    								   if(!isNullOrEmpty(path)){
	                   	    									   store.add({
	                   	    										   id: '',
	                   	    										   name: fileUploadPath,
	                   	    										   path: path ,
	                   	    										   createdBy : {
	                   	    											   id :user.id,
	                   	    											   value : user.value,
	                   	    											   code : user.code
	                   	    										   },
	                   	    										   status : documentStatus,
	                   	    										   documentType : documentType,
	                   	    										   templateConfigDocId: '',
	                   	    										   submissionDate: Ext.Date.format(new Date(), 'd-m-Y')

	                   	    									   });
	                   	    									   this$.loadGridWithFileNameMessage(grid,fileUploadPath,store);
	                   	    									   showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
	                   	    								   }

	                   	    								   fileField.reset();
	                   	    							   }

	                   	    						   }, isTransient);
	                   	    					   }else{
	                   	    						   fileField.reset();
	                   	    						   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
	                   	    					   }
	                   	    				   }

	                   	    			   }else{
	                   	    				   fileField.reset();
	                   	    				   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ATTACHMENT_LIMIT_EXCEEDS')+' '+fileSizeLimit+' MB');

	                   	    			   }
	                   	    		   }
	                   	    	   });

	                   	       },

	                   	       /**
	                   	        * Add value to grid
	                   	        */
	                   	       loadGridWithFileNameMessage:function(grid,value,store){
	                   	    	   grid.bindStore(store);
	                   	       },
	                   	       /**
	                   	        * Remove entry from grid
	                   	        */
	                   	       deletePlacementStaticMessageDocument : function(view, rowIndex, colIndex, item, e, record, row){
	                   	    	   var grid = view.up('#placementjobStaticDocumentAttachmentGridMessage');
	                   	    	   var panel = this.getContentPanel().getActiveTab();
	                   	    	   var tabTitle = panel.title;
	                   	    	   var store = grid.getStore();
	                   	    	   var templateConfigDocId = record.get('templateConfigDocId');
	                   	    	   var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
	                   	    	   if(!(tabTitle == viewTitle)){
	                   	    		   if(!isNullOrEmpty(templateConfigDocId)){
	                   	    			   showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	                   	    				   if (btn == 'yes') {
	                   	    					   Ext.Ajax.request({
	                   	    						   type: 'rest',
	                   	    						   url: SERVERURL.STATIC_DOC_DELETE,
	                   	    						   method: 'DELETE',
	                   	    						   params: {
	                   	    							   templateConfigDocId : templateConfigDocId
	                   	    						   },
	                   	    						   headers: {
	                   	    							   'Content-Type': 'application/json'
	                   	    						   },
	                   	    						   success: function(form, action) {
	                   	    							   store.remove(record);
	                   	    							   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
	                   	    						   }
	                   	    					   });
	                   	    				   }
	                   	    			   });

	                   	    		   }else{
	                   	    			   store.remove(record);
	                   	    			   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
	                   	    		   }
	                   	    	   }else{
	                   	    		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
	                   	    	   }

	                   	       },
	                   	       /**
	                   	        * save document file. It's external call method
	                   	        * @param entityId : person id, It's mandatory. 
	                   	        * @param module : module name, for student module 'student', It's mandatory.
	                   	        * @param entityType : entity type, It's mandatory.
	                   	        * @param documentType : document type, It's mandatory.
	                   	        * @param isTransient : true or false (send json back to module controller or not)
	                   	        * @param callBackFunction : callback function return in module controller. It's mandatory.
	                   	        */
	                   	       saveStaticDocumentFormMessage : function(entityId, module, entityType, documentType, callBackFunction, isTransient){
	                   	       	var submitUrl = '';
	                   	       	var templateTab = this.getContentPanel();
	                   	       	var formWin =  this.getPlacementjobsendmessages();
	                   	       	var form = formWin.down('#msgDetailsForm');
	                   	       	var id = form.down('#document_hidden_field');
	                   	           if (isNullOrEmpty(id.getSubmitValue())) {
	                   	               submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
	                   	           }
	                   	           var data = new Object();
	                   	           if(!isNullOrEmpty(entityId)){
	                   	           	data.entityId = entityId;
	                   	           }else{
	                   	           	data.entityId = null;
	                   	           }
	                   	           if(!isNullOrEmpty(module)){
	                   	           	data.module = module;
	                   	           }else{
	                   	           	data.module = null;
	                   	           }
	                   	           if(!isNullOrEmpty(entityType)){
	                   	           	data.entityType = entityType;
	                   	           }else{
	                   	           	data.entityType = null;
	                   	           }
	                   	           form.getForm().setValues(data);
	                   	           form.getForm().submit({
	                   	           	method : 'POST',
	                   	           	url : submitUrl,
	                   	           	success : function(form, action){
	                   	           		callBackFunction(true, action, isTransient);
	                   	           		
	                   	           	}
	                   	           });
	                   	       }, 
	                   	       /**
	                   	        * This method is to enable schedule field
	                   	        */
	                   	       loadPlacementScheduleField : function(radio,newValue, oldValue){
	                   	       	var adhocMessageForm = radio.up('form');
	                   	       	var scheduleDateField = adhocMessageForm.down('#scheduleDate');
	                   	       	var scheduleTimeField = adhocMessageForm.down('#scheduleTime');
	                   	       	var radioValue = radio.getValue().sendingPriority;
	                   	       	
	                   	       	if(radioValue=='IMMEDIATE'){
	                   	       		scheduleDateField.setVisible(false);
	                   	       		scheduleDateField.setDisabled(true);
	                   	       		scheduleTimeField.setVisible(false);
	                   	       		scheduleTimeField.setDisabled(true);    		
	                   	       	}
	                   	       	else if(radioValue=='SCHEDULE'){
	                   	       		scheduleDateField.setVisible(true);
	                   	       		scheduleDateField.setDisabled(false);
	                   	       		scheduleTimeField.setVisible(true);
	                   	       		scheduleTimeField.setDisabled(false);
	                   	       	}
	                   	       },
	                   	        saveDFRInfo: function(academyLocationId,form) {
    	var templateId = form.down('#templatedItemId');
    	templateId.setVisible(false)
    	templateId.setFieldLabel(getMessagingModuleTranslation('TEMPLATE_ID'));
        Ext.Ajax.request({
            url: SERVERURL.COMMON_FORM_FIELD_INFO,
            method: 'GET',
            async: false,
            params: {
            	screenName: 'placementjobsendmessages',
                academyLocationId:academyLocationId,
                languageCode:'en'
            },
            success: function(res, action) {
    			var response = Ext.decode(res.responseText);
    			if( Object.keys(response).length > 0 ){
    				var records=response.placementjobsendmessages;
    				for(i in records){
    					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='templatedItemId'){
    					var defaultValue = records[i].defaultValue;
   						    if(!isNullOrEmpty(defaultValue)){
  						    	templateId.setValue(defaultValue);
  						    	form.defaultValue =defaultValue;
   						    }
    							if(records[i].isVisible==false ){
    								form.templateIdVisble =false;
    							}if(records[i].isMandatory == true ){
    								form.templateIdMandatory= true
    							}if(records[i].isVisible==true){
    								form.templateIdVisble =true;
    							}if(records[i].isMandatory == false ){
    								form.templateIdMandatory= false
    							}
    						}
    					}
    				}
    			
    		}
        });
    
    },
	                   	       
	                   	    downloadAllDescriptionDocumentFormsZip:function(){
	           				 var $this=this;
	           				 var grid=$this.getJobpostingdocumentwingrid();
	           				 if (grid.getSelectionModel().getCount() > 0) {
	           					 //courseGrid.getSelectionModel().deselectAll();
	           					 var records = grid.getSelectionModel().getSelection();
	           					 var saveModel=[];  

	           					 var zipName = "JobDescriptionDocuments"+records[0].data.document.path;
	           					 for(var i in records){
	           						 if(!isNullOrEmpty(records[i].data.document)) {
	           							 saveModel.push(records[i].data.document.path);
	           						 }
	           					 }
	           					 showConfirmMessage(getPlacementTranslation('JOB_DESCRIPTION_DOCUMENTS'),getPlacementTranslation('JOB_DESCRIPTION_DOCUMENTS_ALERT'),function(btn, text) {
	           						 if (btn == 'yes') {
	           							 var directoryType = CONSTANTS.DIRECTORY_TYPE_BASEDIR;
	           							 $this.getDocumentController().downloadMultipleDocumentFile(saveModel, zipName, directoryType);
	           						 }});
	           				 }else {
	           					 showWarningMessage(getPlacementTranslation('JOB_DESCRIPTION_DOCUMENTS'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	           				 }
	           			 }
	                   	       /*End added adhoc messaging*/ 
	                       
});

