/**
 * @author Dharmendra.Prajapati
 * 
 */
Ext.define('Academia.controller.portal.StudentAttendanceReportController', {
	extend: 'Academia.controller.personinfo.common.PersonCourseExecutionController',
	models : [],
	stores : ['common.ProgramByAcademyLocationStore','attendance.StudentCourses','attendance.CourseLevelFacultyBlank',
	          'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameBySmartSearch','attendance.FacultyNameSmartSearch',
	          'course.coursecomponent.CourseComponentCouseWise','attendance.StudentSearch','enquiry.AcademicBatchStore',
	          'attendance.SectionByCourseNComponent','attendance.AllProgramMappedByCourse','common.BatchesByProgramId','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
	          'attendance.SectionAndFacultyByPeriodID','attendance.StudentAttendanceStatus','attendance.TimeSlotList',
	          'attendance.attendancereport.CourseByStudentId','servicerequest.placementrequest.PlacementPrograms','attendance.attendancereport.AttendanceReportGrid',
	          'attendance.attendancereport.AttendanceReportSummary','attendance.AdmissionSearchByStudent','attendance.AttendanceMarkingTypeStore',
	          'personinfo.common.course.CourseAttendanceWCCPStore','servicerequest.programcoursesectiontransfer.FromPrograms',
	          'attendance.AdmissionSearchByStudentIdCodeName','common.AcademicTermByPeriodIdsStore'],
	views : ['studentPortal.attendancereport.StudentAttendanceReportStructure','studentPortal.attendancereport.StudentPortalAttendanceGrid',
	         'studentPortal.attendancereport.StudentAttendanceReportSearch','studentPortal.attendancereport.AttendanceReportGridConsolidatedStudentReport',
	         'attendance.attendancereport.AttendanceDataStatus','attendance.attendancereport.AttendanceDataStatusGrid',
	         'studentPortal.attendancereport.StudentAttendanceReportCourseSearch','studentPortal.attendancereport.StudentPortalProgramAttendanceGrid',
	         'attendance.attendancereport.AttendanceDataStatusDetails'],
	         refs : [{
	        	 ref: 'studentattendancereportsearch',
	        	 selector: 'studentattendancereportsearch'
	         },{
	        	 ref: 'studentattendancereportcoursesearch',
	        	 selector: 'studentattendancereportcoursesearch'
	         },{
	        	 ref: 'studentattendancereportstructure',
	        	 selector: 'studentattendancereportstructure'
	         },{
	             ref: 'studentportalattendancegrid',
	             selector: 'studentportalattendancegrid'
	         },{
	             ref: 'attendancereportgridconsolidatedstudentreport',
	             selector: 'attendancereportgridconsolidatedstudentreport'
	         },{
	             ref: 'attendancereportviewforstudentwin',
	             selector: 'attendancereportviewforstudentwin'
	         },{
	             ref: 'studentportalprogramattendancegrid',
	             selector: 'studentportalprogramattendancegrid'
	         },{
	    		ref : 'attendancedatastatus',
	    		selector : 'attendancedatastatus'
	    	},{
	    		ref : 'attendanceDatastatus',
	    		selector : 'attendancedatastatus grid'
	    	},{
	    		ref : 'attendancedatastatusgrid',
	    		selector : 'attendancedatastatusgrid'
	    	},{
	    		ref : 'attendancedatastatusdetails',
	    		selector : 'attendancedatastatusdetails'
	    	}],
	    	 config: {
	    	        STUDENT_PROFILE_ATTENDANCE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PROFILE_ATTENDANCE_PRIVILEGES'),
	    	        PARENT_PORTAL_STUDENT_ATTENDANCE_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_ATTENDANCE_DETAILS_PRIVILEGES'),
	    	        STUDENT_PORTAL_STUDENT_ATTENDANCE_DETAILS_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_ATTENDANCE_DETAILS_PRIVILEGES'),
	    	        FACULTY_PORTAL_STUDENT_ATTENDANCE_DETAILS_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_ATTENDANCE_DETAILS_PRIVILEGES'),
	    	 },
	         init : function() {
	        	 this.control({
	        		 'studentattendancereportstructure':{
	        			 afterrender: function(structure){
	        				 var $this = this;
	        				 var contentPanelActiveTab = $this.getContentPanelActiveTab();
	        				 var form =contentPanelActiveTab.down('studentattendancereportstructure');
	        				 var attendanceTypeRadio=form.down('[name=attendanceTypeRadio]');
	        				 var academyLocationId = $this.getCurrentAcademyLocation();
	        	        	 var permissionsMap = new Ext.util.HashMap();
	        	        	 var portalId=this.getCurrentLoggedPortalId();
	        	        	 if(portalId==7){
	        	        		 permissionsMap=this.getPARENT_PORTAL_STUDENT_ATTENDANCE_DETAILS_PERMISSIONS();
	        	        	 }else if(portalId==3){
	        	        		 permissionsMap=this.getSTUDENT_PORTAL_STUDENT_ATTENDANCE_DETAILS_PERMISSIONS();
	        	        	 }else if(portalId==2){
	        	        		 permissionsMap=this.getFACULTY_PORTAL_STUDENT_ATTENDANCE_DETAILS_PRIVILEGES();
	        	        	 }else{
	        	        		 permissionsMap=this.getSTUDENT_PROFILE_ATTENDANCE_PERMISSIONS();
	        	        	 }
	        				 var associatedAcadLocationIds = new Array();
	        				 associatedAcadLocationIds.push(academyLocationId);
	        				 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

	        				 var studentAttendanceType = [];
	        				 var attendanceType=[];
	        				 var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
	        				 if(!isNullOrEmpty(attendanceTypess.data.COMPLETE_DAY) && attendanceTypess.data.COMPLETE_DAY.academyLocationId == academyLocationId) {
	        					 attendanceType.push(attendanceTypess.data.COMPLETE_DAY.studentAttendanceType);
	        				 } else {
	        					 var authenticationController = Academia.app.getController('Academia.controller.authentication.AuthenticationController');
	        					 authenticationController.loadMultipleLangFilePerAL(this.getCurrentAcademyLocation());
	        					 attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
	        					 if(!isNullOrEmpty(attendanceTypess.data.COMPLETE_DAY)) {
	        						 attendanceType.push(attendanceTypess.data.COMPLETE_DAY.studentAttendanceType);
	        					 }
	        				 }
	        				 if(!isNullOrEmpty(attendanceTypess.data.MULTIPLE_SESSION)) {
	        					 attendanceType.push(attendanceTypess.data.MULTIPLE_SESSION.studentAttendanceType);
	        				 }
	        				 if(!isNullOrEmpty(attendanceTypess.data.COURSE_LEVEL)) {
	        					 attendanceType.push(attendanceTypess.data.COURSE_LEVEL.studentAttendanceType);
	        				 }

	        				 if(attendanceType.length > 0){
	        					 studentAttendanceType=attendanceType.join();
	        				 } else {
	        					 showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ATTENDANCE_SETTING_NOT_DONE'));
	        				 }


	        				 //--setting initial values to false
	        				 var tab2=false, tab3=false,tab4=false;

	        				 //--initially setting all radio fields to true
	        				 var completeDayRadio = form.down('[inputValue=COMPLETE_DAY]');
	        				 var courseLevelRadio = form.down('[inputValue=COURSE_LEVEL]');
	        				 var multipleSessionRadio = form.down('[inputValue=MULTIPLE_SESSION]');
	        				 attendanceTypeRadio.items.items[0].setVisible(true);
	        				 attendanceTypeRadio.items.items[1].setVisible(true);
	        				 attendanceTypeRadio.items.items[2].setVisible(true);

	        				 //--checking for the visible tabs
	        				 if((Ext.Array.contains(permissionList, 'PROGRAM_WISE'))&&(Ext.Array.contains(attendanceType, 'COMPLETE_DAY') || Ext.Array.contains(attendanceType, 'Complete Day'))){
	        					 tab2=true;
	        				 }
	        				 if((Ext.Array.contains(permissionList, 'COURSE_WISE'))&&(Ext.Array.contains(attendanceType, 'COURSE_LEVEL') || Ext.Array.contains(attendanceType, 'Course Level'))){
	        					 tab3=true;
	        				 }
	        				 if((Ext.Array.contains(permissionList, 'SESSION_WISE'))&&(Ext.Array.contains(attendanceType, 'MULTIPLE_SESSION') || Ext.Array.contains(attendanceType, 'Multiple Session'))){
	        					 tab4=true;
	        				 }

	        				 if(!tab2 && !tab3 && !tab4){
	        					 tab2=true;
	        				 }

	        				 if((!tab2 && !tab3) || (!tab3 && !tab4) || (!tab4 && !tab2)){
	        					 attendanceTypeRadio.setVisible(false);
	        				 }
	        				 else {
	        					 attendanceTypeRadio.setVisible(true);
	        				 }

	        				 //-- setting values to true/false on the basis of visible tabs
	        				 if(!tab2){
	        					 attendanceTypeRadio.items.items[0].setVisible(false);
	        				 }
	        				 if(!tab3){
	        					 attendanceTypeRadio.items.items[1].setVisible(false);
	        				 }
	        				 if(!tab4){
	        					 attendanceTypeRadio.items.items[2].setVisible(false);
	        				 }

	        				 //-- setting radioGroup value on the basis of visible tabs
	        				 setTimeout(function(){
	        					 if(tab2){
	        						 completeDayRadio.setValue(true);
	        					 }
	        					 else if(tab3){
	        						 courseLevelRadio.setValue(true);
	        					 }
	        					 else if(tab4){
	        						 multipleSessionRadio.setValue(true);
	        					 }
	        				 },300);
	        			 }
	        		 },
	        		 'studentattendancereportstructure radiogroup[name=attendanceTypeRadio]':{
	        			 change : function(obj,rec) {
	        				 var attendanceType = rec.attendanceTypeWise;
	        				 if(typeof attendanceType != "undefined"){
		        				 this.attendanceTypeDropdown(attendanceType);
	        				 }
	        				 else{
	        					 return false;
	        				 }
	        			 }
	        		 },
	        		 'studentattendancereportsearch button[itemId=resetBtn]': {
	        			 click: function(obj){
	        				 this.resetSearchFilter(obj);
	        			 }
	        		 },
	        		 'studentattendancereportsearch':{
	        			 afterrender: function(form){
	        				 var me = this;
	        				 var studentALField = form.down("#studentAcademyLocation");
	        				 var programBatchField = form.down("#programBatch_programId");
	        				 var programBatchFieldStore = programBatchField.getStore();
	        				 if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
	        					 this$.setAllowBlank(studentALField, false);
	        					 studentALField.show();

	        					 programBatchFieldStore.on('beforeload', function(store, operation) {
	        						 var selectedALId = studentALField.getValue();
	        						 var currentALId = me.getCurrentAcademyLocation();
	        						 store.proxy.extraParams.academyLocationIds = isNullOrEmpty(selectedALId) ? currentALId : selectedALId;
	        					 });

	        					 var studentALStore = studentALField.getStore();
	        					 var portalId = me.getCurrentLoggedPortalId();
	        					 var currentALId = me.getCurrentAcademyLocation();

	        					 if(portalId==7){
	        						 var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
	        						 var admissionDetails=portalInfo.admissionDetails;
	        					 } else {
	        						 var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
	        						 var admissionDetails=portalInfo.admissionDetails;
	        					 }

	        					 var admissionIds = Ext.Array.pluck(admissionDetails,'id').join();

	        					 studentALStore.getProxy().extraParams = {
	        						 admissionIds:admissionIds
	        					 };

	        					 studentALStore.load({
	        				    		callback: function(records, operation, success) {
	        				    			if (success) {
	        				    				if(records.length > 0){
	        				    					studentALField.setValue(currentALId);
	        				    				}
	        				    			}
	        				    		}
	        					 });
	        				 }else{
	        					 this$.setAllowBlank(studentALField, false);
	        					 studentALField.hide();
	        				 } 
	        			 }
	        		 },
	        		 'studentattendancereportsearch combo[itemId=studentAcademyLocation]': {
	        			 select: function(combo, records, eOpts) {
	        				 var this$ = this;
	        				 var form = combo.up('studentattendancereportsearch');

	        				 var studentALField = form.down("#studentAcademyLocation");
	        				 var studentProgramField = form.down("#programBatch_programId");
	        				 
	        				 studentProgramField.clearValue();
	        				 form.down('#programBatch_batchId').clearValue();
	        				 form.down('#periodIdItemId').clearValue();
	        				 form.down('#programCoursection_ID').clearValue();
	        				 
	        				 var academyLocationId=studentALField.getValue();
	        				 
	        				 if(this$.getCurrentLoggedPortalId()==3 || this$.getCurrentLoggedPortalId()==7){
	        					 studentPortalInfo = this$.getCurrentlyLoggedInUserInfoForPortal();
	        				 } else {
	        					 studentPortalInfo = this$.getStudentDetailForErpPortal();
	        				 }
	        				 
	        				 var studentId = studentPortalInfo.student.id;
	        				 if(this$.getCurrentLoggedPortalId()==2){
	        					 var personProfile = this$.getContentPanelActiveTab();
	        					 studentId = personProfile.userId;
	        				 }

	        				 /*studentProgramField.store.getProxy().extraParams={
	        					 studentId: studentId,
	        					 onlyCurrentRecord:false,
	        					 academyLocationId: academyLocationId
	        				 };*/

	        				 studentProgramField.store.load({
	        					 callback : function(records, operation, success) {
	        						 if (success) {
	        							 if(records.length==1){
	        								 studentProgramField.setValue(records[0].data.id);
	        							 }
	        						 }
	        					 }
	        				 });
	        			 }
	        		 },
	        		 'studentattendancereportcoursesearch':{
	        			 afterrender: function(form){
	        				 var me = this;
	        				 var studentALField = form.down("#studentAcademyLocationCourse");
	        				 var programBatchField = form.down("#courseWiseProgramId");
	        				 var programBatchFieldStore = programBatchField.getStore();
	        				 if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
	        					 this$.setAllowBlank(studentALField, false);
	        					 studentALField.show();

	        					 programBatchFieldStore.on('beforeload', function(store, operation) {
	        						 var selectedALId = studentALField.getValue();
	        						 var currentALId = me.getCurrentAcademyLocation();
	        						 store.proxy.extraParams.academyLocationIds = isNullOrEmpty(selectedALId) ? currentALId : selectedALId;
	        					 });
	        					 
	        					 var studentALStore = studentALField.getStore();
	        					 var portalId = me.getCurrentLoggedPortalId();
	        					 var currentALId = me.getCurrentAcademyLocation();

	        					 if(portalId==7){
	        						 var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
	        						 var admissionDetails=portalInfo.admissionDetails;
	        					 } else {
	        						 var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
	        						 var admissionDetails=portalInfo.admissionDetails;
	        					 }

	        					 var admissionIds = Ext.Array.pluck(admissionDetails,'id').join();

	        					 studentALStore.getProxy().extraParams = {
	        						 admissionIds:admissionIds
	        					 };

	        					 studentALStore.load({
	        				    		callback: function(records, operation, success) {
	        				    			if (success) {
	        				    				if(records.length > 0){
	        				    					studentALField.setValue(currentALId);
	        				    				}
	        				    			}
	        				    		}
	        					 });

	        				 }else{
	        					 this$.setAllowBlank(studentALField, false);
	        					 studentALField.hide();
	        				 } 
	        			 }
	        		 },
	        		 'studentattendancereportcoursesearch combo[itemId=studentAcademyLocationCourse]': {
	        			 select: function(combo, records, eOpts) {
	        				 var this$ = this;
	        				 var form = combo.up('studentattendancereportcoursesearch');

	        				 var studentALField = form.down("#studentAcademyLocationCourse");
	        				 var studentProgramField = form.down("#courseWiseProgramId");
	        				 
	        				 studentProgramField.clearValue();
	        				 form.down('#courseWiseBatchId').clearValue();
	        				 form.down('#courseWisePeriodId').clearValue();
	        				 form.down('#courseWiseCourseNameId').clearValue();
	        				 form.down('#courseWiseCoursevarientId').clearValue();
	        				 
	        				 form.down('#courseWiseBatchId').setDisabled(true);
	        				 form.down('#courseWisePeriodId').setDisabled(true);
	        				 form.down('#courseWiseCoursevarientId').setDisabled(true);	 
	        				 
	        				 form.down('#courseWiseCourseNameId').store.getProxy().extraParams={};
	        				 form.down('#courseWiseCourseNameId').store.load();
	        				 
	        				 var academyLocationId=studentALField.getValue();
	        				 
	        				 if(this$.getCurrentLoggedPortalId()==3 || this$.getCurrentLoggedPortalId()==7){
	        					 studentPortalInfo = this$.getCurrentlyLoggedInUserInfoForPortal();
	        				 } else {
	        					 studentPortalInfo = this$.getStudentDetailForErpPortal();
	        				 }
	        				 
	        				 var studentId = studentPortalInfo.student.id;
	        				 if(this$.getCurrentLoggedPortalId()==2){
	        					 var personProfile = this$.getContentPanelActiveTab();
	        					 studentId = personProfile.userId;
	        				 }

	        				 /*studentProgramField.store.getProxy().extraParams={
	        					 studentId: studentId,
	        					 onlyCurrentRecord:false,
	        					 academyLocationId: academyLocationId
	        				 };*/

	        				 studentProgramField.store.load({
	        					 callback : function(records, operation, success) {
	        						 if (success) {
	        							 if(records.length==1){
	        								 studentProgramField.setValue(records[0].data.id);
	        							 }
	        						 }
	        					 }
	        				 });
	        			 }
	        		 },
	        		 'studentattendancereportcoursesearch button[itemId=resetBtn]': {
	        			 click: function(obj){
	        				 this.resetCourseSearchFilter(obj);
	        			 }
	        		 },
	        		 'studentattendancereportsearch button[itemId=searchBtn]':{
	        			 click : function(obj){
	        			 this.loadAttendanceRecord();	 
	        			 }
	        		 },
	        		 'studentattendancereportcoursesearch button[itemId=searchBtn]':{
	        			 click : function(obj){
	        				 this.onClickSearchButton();
	        			 }
	        		 },
	        		 'studentattendancereportsearch combo#programBatch_programId': {
	        			 change: function(obj, record) {
	        				 var $this=this;
	        				 var records = obj.value;
	        				 var programId = 0;
	        				 if(!isNullOrEmpty(records)) {
	        					 if(typeof records=="number"){
	        						 programId = records;
	        					 }else if(!isNullOrEmpty(records.data)){
	        						 programId = records.data.id;
	        					 }
	        				 }
	        				 var form = obj.up('form');
	        				 var batchCombo=form.down("#programBatch_batchId");
	        				 var periodCombo=form.down("#periodIdItemId");
	        				 var sectionCombo = form.down("#programCoursection_ID");
	        				 batchCombo.reset();
	        				 periodCombo.reset();
	        				 sectionCombo.reset();
	        				 batchCombo.setDisabled(true);
	        				 periodCombo.setDisabled(true);
	        				 sectionCombo.setDisabled(true);
	        				 if(programId > 0) {
	        					 var studentInfo = null;
	        		        	 var studentId 
	        		        	 if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
	        		        		 studentInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	        		        		 studentId = studentInfo.student.id;
	        		        	 } else {
	        		        		 var personProfile = this.getContentPanelActiveTab();
	        		        	     studentId = personProfile.getUserId();
	        		        	     studentInfo = this.getStudentDetailForErpPortal()
	        		        	 }
	        					 var batchId=studentInfo.programBatchDetails.batchId;
	        					 batchCombo.setDisabled(false);
	        					 var batchComboStore = batchCombo.getStore();
	        					 batchComboStore.getProxy().extraParams = {
	        						 programId: programId,
	        						 studentId:studentId,
	        						 onlyCurrentRecords:false
	        					 };
	        					 batchComboStore.load({
	        						 callback: function(records, operation, success) {
	        							 if (success) {
	        								 if(records.length == 1) {
	        									 batchCombo.setValue(records[0].data.id);
	        								 }else if(records.length>0){
	        									 batchCombo.setValue(batchId);
	        								 } 
	        							 }
	        						 }
	        					 });
	        				 }
	        			 }
	        		 },
	        		 'studentattendancereportsearch combo#programBatch_batchId': {
	        			 change: function(obj, record) {
	        				 var $this=this;
	        				 var records = obj.value;
	        				 var batchId = 0;
	        				 if(!isNullOrEmpty(records)) {
	        					 if(typeof records=="number"){
	        						 batchId = records;
	        					 }else if(!isNullOrEmpty(records.data)){
	        						 batchId = records.data.id;
	        					 }
	        				 }
	        				 var form = obj.up('form');
	        				 var periodCombo=form.down("#periodIdItemId");
	        				 var sectionCombo = form.down("#programCoursection_ID");
	        				 periodCombo.reset();
	        				 sectionCombo.reset();
	        				 periodCombo.setDisabled(true);
	        				 sectionCombo.setDisabled(true);
	        				 if(batchId > 0) {
	        					 var studentInfo = null;
	        		        	 var studentId 
	        		        	 if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
	        		        		 studentInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	        		        		 studentId = studentInfo.student.id;
	        		        	 } else {
	        		        		 var personProfile = this.getContentPanelActiveTab();
	        		        	     studentId = personProfile.getUserId();
	        		        	     studentInfo = this.getStudentDetailForErpPortal()
	        		        	 }
	        					 var periodId=studentInfo.programBatchDetails.periodId;
	        					 periodCombo.setDisabled(false);
	        					 var periodComboStore = periodCombo.getStore();
	        					 periodComboStore.getProxy().extraParams = {
	        						 batchId: batchId,
	        						 studentId:studentId,
	        						 onlyCurrentRecords:false
	        					 };
	        					 periodComboStore.load({
	        						 callback: function(records, operation, success) {
	        							 if (success) {
	        								 if(records.length == 1) {
	        									 periodCombo.setValue(records[0].data.id);
	        								 }else if(records.length>0){
	        									 periodCombo.setValue(periodId);
	        								 } 
	        							 }
	        						 }
	        					 });
	        				 }
	        			 }
	        		 },
	        		 'studentattendancereportsearch combo#periodIdItemId': {
	        			 change: function(obj, record) {
	        				 var $this=this;
	        				 var records = obj.value;
	        				 var periodId = 0;
	        				 if(!isNullOrEmpty(records)) {
	        					 if(typeof records=="number"){
	        						 periodId = records;
	        					 } else if(!isNullOrEmpty(records.data)){
	        						 periodId = records.data.id;
	        					 }
	        				 }
	        				 var form = obj.up('form');
	        				 var sectionCombo = form.down("#programCoursection_ID");
	        				 sectionCombo.reset();
	        				 sectionCombo.setDisabled(true);
	        				 if(periodId > 0) {
	        					 var studentInfo = null;
	        		        	 var studentId 
	        		        	 if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
	        		        		 studentInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	        		        		 studentId = studentInfo.student.id;
	        		        	 } else {
	        		        		 var personProfile = this.getContentPanelActiveTab();
	        		        	     studentId = personProfile.getUserId();
	        		        	     studentInfo = this.getStudentDetailForErpPortal()
	        		        	 }
	        					 var sectionId=studentInfo.programBatchDetails.sectionId;
	        					 sectionCombo.setDisabled(false);
	        					 var sectionComboStore = sectionCombo.getStore();
	        					 sectionComboStore.getProxy().extraParams = {
	        						 periodId: periodId,
	        						 studentId:studentId,
	        						 onlyCurrentRecords:false
	        					 };
	        					 sectionComboStore.load({
	        						 callback: function(records, operation, success) {
	        							 if (success) {
	        								 if(records.length == 1) {
	        									 sectionCombo.setValue(records[0].data.id);
	        								 }else if(records.length>0){
	        									 sectionCombo.setValue(sectionId);
	        								 }
	        							 }
	        						 }
	        					 });
	        				 }
	        			 }
	        		 },
	        		'studentattendancereportsearch combo#programCoursection_ID':{
	        			 change: function(obj, record) {
	        				 var $this=this;
	        				 var records = obj.value;
	        				 var sectionId = 0;
	        				 if(!isNullOrEmpty(records)) {
	        					 if(typeof records=="number"){
	        						 sectionId = records;
	        					 }else if(!isNullOrEmpty(records.data)){
	        						 sectionId = records.data.id;
	        					 }
	        				 }
	        				 var form = obj.up('form');
	        				 if(sectionId > 0) {
	        					 $this.loadAttendanceRecord();
	        				 }
	        			 }
	        		},

	                 'studentportalattendancegrid': {
	                	 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	        				 var $this=this;
	        				 var studentId =  null;
	        				 if($this.getCurrentLoggedPortalId()==3){
	        					 studentPortalInfo = $this.getCurrentlyLoggedInUserInfoForPortal();
	        					 studentId = studentPortalInfo.student.id;
	        				 } else {
	        					 var personProfile = $this.getContentPanelActiveTab();
	        					 studentId = personProfile.getUserId();
	        				 }
	        				 var searchResultGrid = $this.getStudentportalattendancegrid();
	        				 var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;
	        				 
	        				 if(columnName=='totalRecords' &&  record.data.totalRecords > 0){
	        					 this.studentAttendanceDataStatusRecords(record,null,studentId);
	        				 }
	        				 
	        				 if(columnName=='presentRecords' &&  record.data.presentRecords > 0){
	        					 var status = 'PRESENT';
	        					 this.studentAttendanceDataStatusRecords(record,status,studentId);
	        				 }
	        				 if(columnName=='absentRecords' &&  record.data.absentRecords > 0){
	        					 var status = 'ABSENT';
	        					 this.studentAttendanceDataStatusRecords(record,status,studentId);
	        				 }
	        			 },
	        			 render : function(searchResultGrid) {
	        				    var portalId = this.getCurrentLoggedPortalId();
	        				    if(portalId==7){
	        				    	this.doAccessControlValidation(searchResultGrid, this.getPARENT_PORTAL_STUDENT_ATTENDANCE_DETAILS_PERMISSIONS());
	        				    }else{
	        				    	this.doAccessControlValidation(searchResultGrid, this.getSTUDENT_PORTAL_STUDENT_ATTENDANCE_DETAILS_PERMISSIONS());
	        				    }
	        			 }
	                  },
	                  'attendancereportgridconsolidatedstudentreport': {
		                	 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		        				 var $this=this;
		        				 var searchResultGrid=$this.getAttendancereportgridconsolidatedstudentreport();
		        				 var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;
		        				 
		        				 if(columnName=='totalRecords' &&  record.data.totalRecords > 0){
		        					 $this.loadStudentCourseWiseAttendanceRecord(record.data.periodId);
		        				 }
		        			 },
			                 render : function(searchResultGrid) {
		      				    var portalId = this.getCurrentLoggedPortalId();
		      				    if(portalId==7){
		      				    	this.doAccessControlValidation(searchResultGrid, this.getPARENT_PORTAL_STUDENT_ATTENDANCE_DETAILS_PERMISSIONS());
		      				    }else{
		      				    	this.doAccessControlValidation(searchResultGrid, this.getSTUDENT_PORTAL_STUDENT_ATTENDANCE_DETAILS_PERMISSIONS());
		      				    }
		      			 }
	                  },
	                  'studentportalprogramattendancegrid': {
	                	  cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	                		  var $this=this;
	                		  var studentId =  null;
	                		  if($this.getCurrentLoggedPortalId()==3){
	                			  studentPortalInfo = $this.getCurrentlyLoggedInUserInfoForPortal();
	                			  studentId = studentPortalInfo.student.id;
	                		  } else {
	                			  var personProfile = $this.getContentPanelActiveTab();
	                			  studentId = personProfile.getUserId();
	                		  }
	                		  var searchResultGrid = $this.getStudentportalprogramattendancegrid();
	                		  var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;
	                		  if (e.target.tagName == 'A') {
	                			  if(columnName=='totalRecords' &&  record.data.totalRecords > 0){
	                				  this.studentAttendanceDataStatusRecords(record,null,studentId);
	                			  }

	                			  if(columnName=='presentRecords' &&  record.data.presentRecords > 0){
	                				  var status = 'PRESENT';
	                				  this.studentAttendanceDataStatusRecords(record,status,studentId);
	                			  }

	                			  if(columnName=='absentRecords' &&  record.data.absentRecords > 0){
	                				  var status = 'ABSENT';
	                				  this.studentAttendanceDataStatusRecords(record,status,studentId);
	                			  }
	                		  }
	                	  }
	                  },
	                  'studentattendancereportcoursesearch combo#courseWiseProgramId': {
	                	  change:function(combo, rec){
	                		  var form = combo.up('studentattendancereportcoursesearch');
	                		  var programId = combo.value;
	                		  if(programId > 0){
	                			  this.courseWiseStudentAttendanceProgramChange(form, programId);
	                		  }
	                	  }
	                  },
	        		 'studentattendancereportcoursesearch combo#courseWiseBatchId': {
	        			 change:function(combo, rec){
	         				   var form = combo.up('studentattendancereportcoursesearch');
	         				   var batchId = combo.value;
	         				   if(batchId > 0){
	         					   this.courseWiseStudentAttendanceBatchChange(form, batchId);
	         				     }
	  	                   }
	        		 },
	        		 'studentattendancereportcoursesearch combo#courseWisePeriodId': {
	        			 change:function(combo, rec){
	         				   var form = combo.up('studentattendancereportcoursesearch');
	         				   var periodId = combo.value;
	         				   if(periodId > 0){
	         					   this.courseWiseStudentAttendancePeriodChange(form, periodId);
	         				     }
	  	                   }
		        		 },
	        		 'studentattendancereportcoursesearch combo#courseWiseCourseNameId': {
	        			 change:function(combo, rec){
	         				   var form = combo.up('studentattendancereportcoursesearch');
	         				   var courseId = combo.value;
	         				   if(courseId > 0){
	         					   this.courseWiseStudentAttendanceCourseChange(form, courseId);
	         				     }
	  	                   }
		        		 },
		        		 'studentattendancereportcoursesearch combo#courseWiseCoursevarientId': {
		        			 change:function(combo, rec){
		         				   var form = combo.up('studentattendancereportcoursesearch');
		         				   var courseVarientId = combo.value;
		         				   if(courseVarientId > 0){
		         					//  this.onClickSearchButton(); 
		         				     }
		  	                   }
			        		 },
		        	 'studentattendancereportstructure tabpanel#attendancereportpanelstudentportel':{
		     				tabchange:function(tabPanel, newCard, oldCard, eOpts){
		     					   var newTabName=newCard;
		     					  /* if(newTabName.title==getProgramandcourseTranslation('CONSOLIDATED')){
		     						   this.loadStudentConsolidatedAttendanceRecord()
		     					   }else  if(newTabName.title==getCommonTranslation('COURSE_WISE')){						   
		     						   this.loadStudentCourseWiseAttendanceRecord()
		     					   }*/
		     				}
		     			},
	        	 });
	         },
	         loadStudentConsolidatedAttendanceRecord:function(){
	        	 var $this = this;
	        	 var contentPanelActiveTab = $this.getContentPanelActiveTab();
	        	 var form = contentPanelActiveTab.down('studentattendancereportcoursesearch');
				 var attendancesearchstrucure =contentPanelActiveTab.down('studentattendancereportstructure');
	        	 //var attendancesearchstrucure =  this.getStudentattendancereportstructure();
	        	 var attendanceType = attendancesearchstrucure.down('[name=attendanceTypeRadio]').getValue().attendanceTypeWise;
	        	 var studentId = null;
	        	 var grid = this.getAttendancereportgridconsolidatedstudentreport();
				    var alinfomodel = Academia.model.authentication.ALInfoModel;
				    var wheatherSchool = alinfomodel.get('wheatherSchool');
				    var length = grid.columns.length-1;
	   				for(var i = 0; i<=length ; i++) {
	   					var columnName = grid.columns[i].dataIndex;
	   					
	   					if(wheatherSchool){
	   						if(columnName == 'periodName') {
		      						grid.columns[i].hide();
		      					}
	   				    }else{
	   				    	if(columnName == 'periodName') {
		      						grid.columns[i].show();
		      					}
	   				    }
	   					
	   				}
	        	 if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
	        		 studentInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	        		 studentId = studentInfo.student.id;
	        	 } else {
	        		 var personProfile = this.getContentPanelActiveTab();
	        		 studentId = personProfile.getUserId();
	        		 studentInfo = this.getStudentDetailForErpPortal()
	        	 }
	        	 var values = form.getForm().getValues();
	        	 var programId = values.courseWiseProgram; 
	        	 var batchId = values.courseWiseBatch;
	        	 var periodId = values.courseWisePeriod;
	        	 var courseId = values.courseWiseCourseName;
	        	 var courseVariantId = values.courseWiseCoursevarient;
	        	 var attendancePerFrom = values.courseWiseAttendancePercentageFrom;
	        	 if(isNullOrEmpty(attendancePerFrom)){
	        		 attendancePerFrom=0;
	        	 }
	        	 var attendancePerTo = values.courseWiseAttendancePercentageTo;
	        	 if(isNullOrEmpty(attendancePerTo)){
	        		 attendancePerTo=100;
	        	 }
	        	 var startDate = values.startDate;
	        	 var endDate = values.endDate;
	        	 if(courseId > 0) {
		        	 var attendancereportpanel=attendancesearchstrucure.down('#attendancereportpanelstudentportel');
		        	 var courseWiseAttendanceTabItemId = attendancereportpanel.down('#studentCourseWiseAttendanceTabItemId');
	        		 attendancereportpanel.setActiveTab(courseWiseAttendanceTabItemId);
	        	 }
	        	 var params = {
	        			 programId:programId,
	        			 batchId:batchId,
	        			 periodId:periodId,
	        			 courseId: courseId,
	        			 startDate: startDate,
	        			 endDate: endDate,
	        			 sectionId : values.courseSectionId,
	        			 attendanceType:attendanceType,
	        			 studentId:studentId,
	        			 isCurrentPeriod:false,
	        			 attendancePercentageFrom:attendancePerFrom,
	        			 attendancePercentageTo:attendancePerTo,
	        			 viewAttendanceType:'CONSOLIDATE'
	        	 };
	        	 var grid = this.getAttendancereportgridconsolidatedstudentreport();
	        	 var gridStore = grid.getStore();
	        	 gridStore.getProxy().api.read=SERVERURL.GET_STUDENT_ATTENDANCE_SUMMARY_CORE_ERP;
	        	 gridStore.getProxy().extraParams = params;
	        	 
        		 if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
        			 gridStore.getProxy().extraParams.academyLocationId = values.studentAcademyLocationCourse;
        		 }
	        	 
	        	 gridStore.load();
	         },
	         loadStudentCourseWiseAttendanceRecord:function(periodId){
	        	 var $this = this;
	        	 var contentPanelActiveTab = $this.getContentPanelActiveTab();
	        	 var form = contentPanelActiveTab.down('studentattendancereportcoursesearch');
				 var attendancesearchstrucure =contentPanelActiveTab.down('studentattendancereportstructure');
	        	// var attendancesearchstrucure =  this.getStudentattendancereportstructure();
	        	 var attendanceType = attendancesearchstrucure.down('[name=attendanceTypeRadio]').getValue().attendanceTypeWise;
	        	 var studentId = null;
	        	 if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
	        		 studentInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	        		 studentId = studentInfo.student.id;
	        	 } else {
	        		 var personProfile = this.getContentPanelActiveTab();
	        		 studentId = personProfile.getUserId();
	        		 studentInfo = this.getStudentDetailForErpPortal()
	        	 }
	        	 var attendancereportpanel=attendancesearchstrucure.down('#attendancereportpanelstudentportel');
	        	 var courseWiseAttendanceTabItemId = attendancereportpanel.down('#studentCourseWiseAttendanceTabItemId');
        		 attendancereportpanel.setActiveTab(courseWiseAttendanceTabItemId);
	        	 var searchProgramId = null;
	        	 var searchBatchId = null;
	        	 var searchPeriodId = null;
	        	 var values = form.getForm().getValues();
	        	 if(periodId > 0) {
	        		 searchPeriodId = periodId;
	        	 } else {
	        		 searchProgramId = values.courseWiseProgram; 
	        		 searchBatchId = values.courseWiseBatch;
	        		 searchPeriodId = values.courseWisePeriod;
	        	 }
	        	 var courseId = values.courseWiseCourseName;
	        	 var courseVariantId = values.courseWiseCoursevarient;
	        	 var attendancePerFrom = values.courseWiseAttendancePercentageFrom;
	        	 if(isNullOrEmpty(attendancePerFrom)){
	        		 attendancePerFrom=0;
	        	 }
	        	 var attendancePerTo = values.courseWiseAttendancePercentageTo;
	        	 if(isNullOrEmpty(attendancePerTo)){
	        		 attendancePerTo=100;
	        	 }
	        	 var startDate = values.startDate;
	        	 var endDate = values.endDate;
	        	 var params = {
	        			 programId:searchProgramId,
	        			 batchId:searchBatchId,
	        			 periodId:searchPeriodId,
	        			 courseId: courseId,
	        			 startDate: startDate,
	        			 endDate: endDate,
	        			 sectionId : values.courseSectionId,
	        			 attendanceType:attendanceType,
	        			 studentId:studentId,
	        			 isCurrentPeriod:false,
	        			 attendancePercentageFrom:attendancePerFrom,
	        			 attendancePercentageTo:attendancePerTo,
	        			 courseVariantId:courseVariantId
	        	 };
	        	 var grid = this.getStudentportalattendancegrid();
	        	 grid.getStore().removeAll();
	        	 var gridStore = grid.getStore();
	        	 this.resetPageSetting(gridStore);
	        	 gridStore.getProxy().api.read=SERVERURL.GET_STUDENT_ATTENDANCE_SUMMARY_CORE_ERP;
	        	 gridStore.getProxy().extraParams = params;
	        	 
        		 if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
        			 gridStore.getProxy().extraParams.academyLocationId = values.studentAcademyLocationCourse;
        		 }
	        	 
	        	 gridStore.load();
	         },
	         loadAttendanceRecord:function(){
	        	 var $this = this;
	        	 var contentPanelActiveTab = $this.getContentPanelActiveTab();
				 var attendancesearchstrucure =contentPanelActiveTab.down('studentattendancereportstructure');
	        	 //var attendancesearchstrucure =  this.getStudentattendancereportstructure();
	        	 var attendanceType = attendancesearchstrucure.down('[name=attendanceTypeRadio]').getValue().attendanceTypeWise;
	        	 var studentId = null;
	        	 if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
	        		 studentInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	        		 studentId = studentInfo.student.id;
	        	 } else {
	        		 var personProfile = this.getContentPanelActiveTab();
	        		 studentId = personProfile.getUserId();
	        		 studentInfo = this.getStudentDetailForErpPortal()
	        	 }
	        	 if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL') {/*
	        		 var alinfomodel = Academia.model.authentication.ALInfoModel;
	        		 var wheatherSchool = alinfomodel.get('wheatherSchool');
	        		 var attendancereportpanel=attendancesearchstrucure.down('#attendancereportpanelstudentportel');
	        		 var activeTab=attendancereportpanel.getActiveTab().title;
	        		 var courseWiseAttendanceTabItemId = attendancereportpanel.down('#studentCourseWiseAttendanceTabItemId');
	        		 this.getStudentattendancereportstructure().down('#attendancereportpanelstudentportel').setVisible(true);
	        		 var form = this.getStudentattendancereportcoursesearch();
	        		 var values = form.getForm().getValues();
	        		 var programId = values.courseWiseProgram; 
	        		 var batchId = values.courseWiseBatch;
	        		 var periodId = values.courseWisePeriod;
	        		 var courseId = values.courseWiseCourseName;
	        		 var courseVariantId = values.courseWiseCoursevarient;
	        		 var attendancePerFrom = values.courseWiseAttendancePercentageFrom;
	        		 var attendancePerTo = values.courseWiseAttendancePercentageTo;
	        		 var startDate = values.startDate;
	        		 var endDate = values.endDate;
	        		 var academicTermId = null;
	        		 if(!wheatherSchool) {
	        			 academicTermId=values.ACADEMIC_TERM;
	        		 }
	        		 
	        		 var params = {
	        				 programId:programId,
	        				 batchId:batchId,
	        				 periodId:periodId,
	        				 courseId: courseId,
	        				 startDate: startDate,
	        				 endDate: endDate,
	        				 sectionId : values.courseSectionId,
	        				 attendanceType:attendanceType,
	        				 studentId:studentId,
	        				 isCurrentPeriod:false,
	        				 academicTermId:academicTermId,
	        				 attendancePercentageFrom:attendancePerFrom,
	        				 attendancePercentageTo:attendancePerTo
	        		 };
	        		 
	        		 if(isNullOrEmpty(courseId) && activeTab!=getCommonTranslation('COURSE_WISE')){
	        			 var grid = this.getAttendancereportgridconsolidatedstudentreport();
	        			 var gridStore = grid.getStore();
	        			 gridStore.getProxy().api.read=SERVERURL.GET_STUDENT_ATTENDANCE_SUMMARY_CORE_ERP;
	        		 }else if(!isNullOrEmpty(courseId) || activeTab==getCommonTranslation('COURSE_WISE')){
	        			 var grid = this.getStudentportalattendancegrid();
	        			 var gridStore = grid.getStore();
	        			 attendancereportpanel.setActiveTab(courseWiseAttendanceTabItemId);
	        			 gridStore.getProxy().api.read=SERVERURL.GET_STUDENT_ATTENDANCE_SUMMARY_CORE_ERP;
	        		 }
	        		 gridStore.getProxy().extraParams = params;
	        		 gridStore.load();
	        	 */} else {
					 var form =contentPanelActiveTab.down('studentattendancereportsearch');
	        		 //var form = this.getStudentattendancereportsearch();
	        		 var values = form.getForm().getValues();
	        		 var programId = values.programId;
	        		 var batchId = values.batchId;
	        		 var periodId = values.periodId;
	        		 var sectionId = values.sectionId;
	        		 var startDate = values.startDate;
	        		 var endDate = values.endDate;
	        		 var grid = this.getStudentportalprogramattendancegrid();
	        		 var store = grid.getStore();
	        		 store.getProxy().extraParams = {
	        			 periodId:periodId,
	        			 sectionId:sectionId,
	        			 startDate:startDate,
	        			 endDate:endDate,
	        			 onlyCurrentRecords:false,
	        			 includeAttendanceOfOnlyPlannedSession:false,
	        			 attendanceType:attendanceType,
	        			 studentId:studentId,
	        			 viewAttendanceType:'CONSOLIDATE'
	        		 };
	        		 
	        		 if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
	        			 store.getProxy().extraParams.academyLocationIds = values.studentAcademyLocation;
	        		 }
	        		 
	        		 store.load();
	        	 }
	         },
	         attendanceTypeDropdown:function(attendanceType){
	        	 var $this = this;
	        	 var contentPanelActiveTab = $this.getContentPanelActiveTab();
				 var programSearch =contentPanelActiveTab.down('studentattendancereportsearch');
	        	 //var programSearch = this.getStudentattendancereportsearch();
	        	 var courseSearch = contentPanelActiveTab.down('studentattendancereportcoursesearch');
	        	 var academyLocationId = this.getCurrentAcademyLocation();
	        	 var alinfomodel = Academia.model.authentication.ALInfoModel;
	        	 var wheatherSchool = alinfomodel.get('wheatherSchool');
	        	 var studentInfo = null;
	        	 var studentId;
	        	 if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
	        		 studentInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	        		 studentId = studentInfo.student.id;
	        	 } else {
	        		 var personProfile = this.getContentPanelActiveTab();
	        	     studentId = personProfile.getUserId();
	        	     studentInfo = this.getStudentDetailForErpPortal();
	        	 }
        		 
	        	 if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL'){
	        		 courseSearch.setVisible(true);
	        		 programSearch.setVisible(false);
	        		 var programId=studentInfo.programBatchDetails.programId;
	        		 
	        		 if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
		        		 var alField = courseSearch.down('#studentAcademyLocationCourse');
		        		 alField.setValue(academyLocationId);
	        		 } else{
	        			 courseSearch.down('#studentAcademyLocationCourse').allowBlank=true;
	        		 }
	        		 
	        		 var programField = courseSearch.down('#courseWiseProgramId');
	        		 var periodField = courseSearch.down('#courseWisePeriodId');
	        		 if(wheatherSchool){
	        			 periodField.setVisible(false);
	        		 }else{
	        			 periodField.setVisible(true);
	        		 }
	        		 var programStore =  programField.getStore();
	        		 programStore.getProxy().extraParams = {
	        			 studentId:studentId,
	        			 academyLocationIds:academyLocationId,
	        			 onlyCurrentRecords:false
	        		 }
	        		 programStore.load({
	        			 callback: function(records, operation, success) {
    	        			 if (success) {
    	        				 if(records.length > 0){
    	        					 programField.setValue(programId);
    	        				 }
    	        			 }
	        			 }
	        		 });
		        	 var contentPanelActiveTab = $this.getContentPanelActiveTab();
					 var attendancesearchstrucure =contentPanelActiveTab.down('studentattendancereportstructure');
					 attendancesearchstrucure.down('#studentportalprogramattendancegridId').setVisible(false);

	        	 }else{
	        		 var $this = this;
		        	 var form = contentPanelActiveTab.down('studentattendancereportsearch');
	        		 
		        	 if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
		        		 var alField = form.down('#studentAcademyLocation');
		        		 alField.setValue(academyLocationId);
	        		 } else{
	        			 programSearch.down('#studentAcademyLocation').allowBlank=true;
	        		 }
		        	 
		        	 var sectionField1 = form.down("#programCoursection_ID").getValue();
		        	 
		        	 if(!isNullOrEmpty(sectionField1)){
		        		 $this.loadAttendanceRecord();
		        	 }
	        		
	        		 var programId=studentInfo.programBatchDetails.programId;
	        		 courseSearch.setVisible(false);
	        		 programSearch.setVisible(true);
	        		 
	        		 var contentPanelActiveTab = $this.getContentPanelActiveTab();
					 var attendancesearchstrucure =contentPanelActiveTab.down('studentattendancereportstructure');
					 attendancesearchstrucure.down('#studentportalprogramattendancegridId').setVisible(true);
					 attendancesearchstrucure.down('#attendancereportpanelstudentportel').setVisible(false);
	        		 var programField = programSearch.down('#programBatch_programId');
	        		 var programStore =  programField.getStore();
	        		 programStore.getProxy().extraParams = {
	        			 studentId:studentId,
	        			 academyLocationIds:academyLocationId,
	        			 onlyCurrentRecords:false
	        		 }
	        		 programStore.load({
	        			 callback: function(records, operation, success) {
    	        			 if (success) {
    	        				 if(records.length > 0){
    	        					 programField.setValue(programId);
    	        				 }
    	        			 }
	        			 }
	        		 });
	        	 }
	        	 if(wheatherSchool){
	        		 programSearch.down("#periodIdItemId").setVisible(false);
	        	 } else {
	        		 programSearch.down("#periodIdItemId").setVisible(true);
	        	 }
	        	 
	         },
	         resetSearchFilter:function(obj){
	        	 var $this = this;
	        	 var form=obj.up('form');
	        	 var academyLocationId = $this.getCurrentAcademyLocation();
	        	 var programSearch = obj.up('form');
	        	 var programField = form.down('#programBatch_programId');
	        	 var batchField = form.down('#programBatch_batchId');
	        	 var periodField = form.down('#periodIdItemId');
	        	 var sectionield = form.down('#programCoursection_ID');
	        	 var startDate = form.down('#startDate');
	        	 var endDate = form.down('#endDate');
	        	 startDate.reset();
	        	 endDate.reset();
	        	 startDate.setMinValue(false);
	        	 endDate.setMinValue(false);
	        	 startDate.setMaxValue(new Date());
	        	 endDate.setMaxValue(new Date());
	        	 var alinfomodel = Academia.model.authentication.ALInfoModel;
	        	 var wheatherSchool = alinfomodel.get('wheatherSchool');
	        	 var studentInfo = null;
	        	 var studentId;
	        	 if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
	        		 studentInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	        		 studentId = studentInfo.student.id;
	        	 } else {
	        		 var personProfile = this.getContentPanelActiveTab();
	        	     studentId = personProfile.getUserId();
	        	     studentInfo = this.getStudentDetailForErpPortal()
	        	 }
	        	 var programId=studentInfo.programBatchDetails.programId;
        		 programField.reset();
        		 programField.setDisabled(true);
        		 batchField.reset();
        		 batchField.setDisabled(true);
        		 periodField.reset();
        		 periodField.setDisabled(true);
        		 sectionield.reset();
        		 sectionield.setDisabled(true);
        		 var programStore =  programField.getStore();
        		 programStore.getProxy().extraParams = {
        			 studentId:studentId,
        			 academyLocationIds:academyLocationId,
        			 onlyCurrentRecords:false
        		 }
        		 programStore.load({
        			 callback: function(records, operation, success) {
	        			 if (success) {
	        				 if(records.length > 0){
	        					 programField.setDisabled(false);
	        					 programField.setValue(programId);
	        				 }
	        			 }
        			 }
        		 });
	         },
	         resetCourseSearchFilter:function(obj){
	        	 var $this = this;
	        	 var academyLocationId = this.getCurrentAcademyLocation();
	        	 var alinfomodel = Academia.model.authentication.ALInfoModel;
	        	 var wheatherSchool = alinfomodel.get('wheatherSchool');
	        	 var studentInfo = null;
	        	 var studentId 
	        	 if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
	        		 studentInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	        		 studentId = studentInfo.student.id;
	        	 } else {
	        		 var personProfile = this.getContentPanelActiveTab();
	        	     studentId = personProfile.getUserId();
	        	     studentInfo = this.getStudentDetailForErpPortal()
	        	 }
	        	 var form=obj.up('form');
	        	 var programId=studentInfo.programBatchDetails.programId;
	        	 var ALIdField = form.down("#studentAcademyLocationCourse");
	        	 var programField=form.down("#courseWiseProgramId");
	        	 var batchField=form.down("#courseWiseBatchId");
				 var periodField=form.down("#courseWisePeriodId");
				 var courseField=form.down("#courseWiseCourseNameId");
				 var courseVariantField=form.down("#courseWiseCoursevarientId");
				 var attendancePercentageFromField=form.down("#courseWiseAttendancePercentageFromId");
				 var attendancePercentageToField=form.down("#courseWiseAttendancePercentageToId");
				 var courseWiseStartDateField=form.down("#startDate");
				 var courseWiseEndDateField=form.down("#endDate");
				 
				 if(wheatherSchool){
        			 periodField.setVisible(false);
        		 }else{
        			 periodField.setVisible(true);
        		 }
				 
				 ALIdField.reset();
				 programField.reset();
				 batchField.reset();
				 periodField.reset();
				 courseField.reset();
				 courseVariantField.reset();
	        	 attendancePercentageFromField.reset();
	        	 attendancePercentageToField.reset();
	        	 courseWiseStartDateField.reset();
	        	 courseWiseEndDateField.reset();
	        	 courseWiseStartDateField.setMinValue(false);
	        	 courseWiseEndDateField.setMinValue(false);
	        	 courseWiseStartDateField.setMaxValue(new Date());
	        	 courseWiseEndDateField.setMaxValue(new Date());
	        	 batchField.setDisabled(true);
				 periodField.setDisabled(true);
	        	 courseVariantField.setDisabled(true);
        		 var programStore =  programField.getStore();
        		 programStore.getProxy().extraParams = {
        			 studentId:studentId,
        			 academyLocationIds:academyLocationId,
        			 onlyCurrentRecords:false
        		 }
        		 
        		 var studentALStore = ALIdField.getStore();
				 var portalId = $this.getCurrentLoggedPortalId();
				 var currentALId = $this.getCurrentAcademyLocation();

				 if(portalId==7){
					 var portalInfo = $this.getCurrentlyLoggedInUserInfoForPortal();
					 var admissionDetails=portalInfo.admissionDetails;
				 } else {
					 var portalInfo = $this.getCurrentlyLoggedInUserInfoForPortal();
					 var admissionDetails=portalInfo.admissionDetails;
				 }

				 var admissionIds = Ext.Array.pluck(admissionDetails,'id').join();

				 studentALStore.getProxy().extraParams = {
					 admissionIds:admissionIds
				 };

				 studentALStore.load({
			    		callback: function(records, operation, success) {
			    			if (success) {
			    				if(records.length > 0){
			    					ALIdField.setValue(currentALId);
			    					
			    					programStore.load({
			    						callback: function(records, operation, success) {
			    							if (success) {
			    								if(records.length > 0) {
			    									programField.setValue(programId);
			    								}else{
			    									var courseStore = courseField.getStore();
			    									courseStore.getProxy().extraParams = {
			    										studentId:studentId,
			    										onlyCurrentRecords:false
			    									};
			    									courseStore.load();
			    								}
			    							}
			    						}
			    					});
			    				}
			    			}
			    		}
				 });
        		 
        		 
        		 
	         },
	         studentAttendanceDataStatusRecords:function(record,status,studentId){
	        	 var $this =this;
	        	 var formWindow = $this.getAttendancedatastatus();
	        	 if (!formWindow) {
	        		 Ext.widget('attendancedatastatus');
	        		 formWindow = $this.getAttendancedatastatus();
	        	 }
	        	 formWindow.show();
	        	 $this.loadStudentAttendanceStatusData(record,status,studentId);
	         },
	         
	         loadStudentAttendanceStatusData:function(record,statusData,studentId){
	        	 var $this = this;
	        	 var contentPanelActiveTab = $this.getContentPanelActiveTab();
				 var attendancesearchstrucure =contentPanelActiveTab.down('studentattendancereportstructure');
	        	 //var attendancesearchstrucure =  this.getStudentattendancereportstructure();
	        	 var attendanceType = attendancesearchstrucure.down('[name=attendanceTypeRadio]').getValue().attendanceTypeWise;
	        	 var grid = $this.getAttendancedatastatusgrid();
	        	 var attendancedatastatusdetails=$this.getAttendancedatastatusdetails();
	        	 attendancedatastatusdetails.down('#admissionCodeItemId').setValue(record.data.admissionCode);
	        	 attendancedatastatusdetails.down('#studentCodeItemId').setValue(record.data.studentCode);
	        	 attendancedatastatusdetails.down('#studentNameItemId').setValue(record.data.studentName);
	        	 attendancedatastatusdetails.down('#programNameItemId').setValue(record.data.programName);
	        	 attendancedatastatusdetails.down('#batchNameItemId').setValue(record.data.batchName);
	        	 attendancedatastatusdetails.down('#periodItemId').setValue(record.data.periodName);
	        	 
	        	 attendancedatastatusdetails.down('#admissionCodeItemId').setVisible(false);
	        	 attendancedatastatusdetails.down('#studentCodeItemId').setVisible(false);
	        	 attendancedatastatusdetails.down('#studentNameItemId').setVisible(false);
	        	 var store = grid.getStore();
	        	 var programSearchForm = contentPanelActiveTab.down('studentattendancereportsearch').getForm();
	        	 var courseSearchForm = contentPanelActiveTab.down('studentattendancereportcoursesearch').getForm();
	        	 var status; 
	        	 if(!isNullOrEmpty(statusData)){
	        		 status = statusData;
	        	 }else{
	        		 status =null;
	        	 }
	        	 var studentData=studentId;
	        	 var courseId = null;
	        	 var sd = programSearchForm.findField('startDate').getValue();
	        	 var td = programSearchForm.findField('endDate').getValue();
	        	 if(!isNullOrEmpty(attendanceType) && attendanceType == "COURSE_LEVEL"){
	        		 sd = courseSearchForm.findField('startDate').getValue();
		        	 td = courseSearchForm.findField('endDate').getValue();
		        	 courseId = record.data.courseId;
	        		 grid.columns[0].show();
	        		 grid.columns[1].hide();
	        		 grid.columns[2].show();
	        		 grid.columns[4].show();
	        		 grid.columns[6].hide();
	        		 studentData=studentId;
	        		 admissionId=null;
	        		 var sectionId = courseSearchForm.findField('courseWiseCoursevarient').getValue();
	        		 if(sectionId > 0) {
	        		 	var courseVariantId = record.data.courseVariantId;
	        		 	sectionId = null;
	        		 }
	        	 } else if(!isNullOrEmpty(attendanceType) && attendanceType == "MULTIPLE_SESSION"){
	        		 var sectionId = record.data.sectionId;
	        		 grid.columns[0].hide();
	        		 grid.columns[1].show();
	        		 grid.columns[2].hide();
	        		 grid.columns[4].hide();
	        	 } 
	        	 else if(!isNullOrEmpty(attendanceType) && attendanceType == "COMPLETE_DAY"){
	        		 var sectionId = record.data.sectionId;
	        		 grid.columns[0].hide();
	        		 grid.columns[1].show();
	        		 grid.columns[2].hide();
	        		 grid.columns[4].hide();
	        		 grid.columns[6].hide();
	        	 } 
	        	 var startDate = null;
	        	 var endDate = null;
	        	 if(!isNullOrEmpty(sd)){
	        		 startDate = Ext.Date.format(new Date(sd), 'Y-m-d');
	        	 }
	        	 if(!isNullOrEmpty(td)){
	        		 endDate = Ext.Date.format(new Date(td), 'Y-m-d');
	        	 }

	        	 store.getProxy().extraParams = {
	        		 sectionId: sectionId,
	        		 attendanceType:attendanceType,
	        		 attendanceStatus:status,
	        		 startDate:startDate,
	        		 endDate:endDate,
	        		 courseId:courseId,
	        		 studentId:studentData,
	        		 courseVariantId:courseVariantId
	        	 };
	        	 this.resetPageSetting(store);
	        	 store.load();

	         },
	         courseWiseStudentAttendanceProgramChange : function(form, programId){
	        	 var $this=this;
				 var batchField=form.down("#courseWiseBatchId");
				 var periodField=form.down("#courseWisePeriodId");
				 var courseField=form.down("#courseWiseCourseNameId");
				 var courseVariantField=form.down("#courseWiseCoursevarientId");
				 var attendancePercentageFromField=form.down("#courseWiseAttendancePercentageFromId");
				 var attendancePercentageToField=form.down("#courseWiseAttendancePercentageToId");
				 var courseWiseStartDateField=form.down("#startDate");
				 var courseWiseEndDateField=form.down("#endDate");
				 
				 var studentInfo = null;
	        	 var studentId 
	        	 if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
	        		 studentInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	        		 studentId = studentInfo.student.id;
	        	 } else {
	        		 var personProfile = this.getContentPanelActiveTab();
	        	     studentId = personProfile.getUserId();
	        	     studentInfo = this.getStudentDetailForErpPortal()
	        	 }
	        	 
				 batchField.reset();
				 periodField.reset();
				 courseField.reset();
				 courseVariantField.reset();
	        	 attendancePercentageFromField.reset();
	        	 attendancePercentageToField.reset();
	        	 courseWiseStartDateField.reset();
	        	 courseWiseEndDateField.reset();
	        	 batchField.setDisabled(true);
	        	 periodField.setDisabled(true);
	        	 courseVariantField.setDisabled(true);	 
					 var batchId=studentInfo.programBatchDetails.batchId;
					 batchField.setDisabled(false);
					 var batchComboStore = batchField.getStore();
					 batchComboStore.getProxy().extraParams = {
						 programId: programId,
						 studentId:studentId,
						 onlyCurrentRecords:false
					 };
					 batchComboStore.load({
						 callback: function(records, operation, success) {
							 if (success) {
								 if(records.length == 1) {
									 batchField.setValue(records[0].data.id);
								 }else if(records.length>0){
									 //batchField.setValue(batchId);
									 var courseStore = courseField.getStore();
									 courseStore.getProxy().extraParams = {
										 programId: programId,
										 studentId:studentId,
										 onlyCurrentRecords:false
									 };
									 courseStore.load();
								 }else if(records.length == 0){
									 var courseStore = courseField.getStore();
									 courseStore.getProxy().extraParams = {
										 programId: programId,
										 studentId:studentId,
										 onlyCurrentRecords:false
									 };
									 courseStore.load(); 
								 } 
							 }
						 }
					 });
					 
	         },
	         courseWiseStudentAttendanceBatchChange : function(form, batchId){
	        	 var $this=this;
	        	 var contentPanelActiveTab = $this.getContentPanelActiveTab();
				 var attendancesearchstrucure =contentPanelActiveTab.down('studentattendancereportstructure');
	        	 var gridWithtab=attendancesearchstrucure.down('#attendancereportpanelstudentportel');
	        	 gridWithtab.setVisible(false);
	        	 gridWithtab.down('#attendancereportgridconsolidatedstudentportelItemID').getStore().removeAll();
	        	 gridWithtab.down('#studentportalattendancegridId').getStore().removeAll();
	        	 var programId=form.down("#courseWiseProgramId").getValue();
				 var periodField=form.down("#courseWisePeriodId"); 
				 var courseField=form.down("#courseWiseCourseNameId");
				 var courseVariantField=form.down("#courseWiseCoursevarientId");
				 var attendancePercentageFromField=form.down("#courseWiseAttendancePercentageFromId");
				 var attendancePercentageToField=form.down("#courseWiseAttendancePercentageToId");
				 var courseWiseStartDateField=form.down("#startDate");
				 var courseWiseEndDateField=form.down("#endDate");
				 
				 var studentInfo = null;
	        	 var studentId 
	        	 if($this.getCurrentLoggedPortalId()==3 || $this.getCurrentLoggedPortalId()==7){
	        		 studentInfo = $this.getCurrentlyLoggedInUserInfoForPortal();
	        		 studentId = studentInfo.student.id;
	        	 } else {
	        		 var personProfile = $this.getContentPanelActiveTab();
	        	     studentId = personProfile.getUserId();
	        	     studentInfo = $this.getStudentDetailForErpPortal()
	        	 }
	        
	        	 var periodId=studentInfo.programBatchDetails.periodId;
				 periodField.reset();
				 courseField.reset();
				 courseVariantField.reset();
	        	 attendancePercentageFromField.reset();
	        	 attendancePercentageToField.reset();
	        	 courseWiseStartDateField.reset();
	        	 courseWiseEndDateField.reset();
				 periodField.setDisabled(false);
				 courseVariantField.setDisabled(true);
				 var periodStore = periodField.getStore();
				 periodStore.getProxy().extraParams = {
					 batchId: batchId,
					 studentId:studentId,
					 onlyCurrentRecords:false
				 };
				 periodStore.load({
					 callback: function(records, operation, success) {
						 if (success) {
							 if(records.length == 1) {
								 periodField.setValue(records[0].data.id);
							 }else if(records.length >= 0){
								 var courseStore = courseField.getStore();
								 courseStore.getProxy().extraParams = {
									 programId: programId,
									 batchId: batchId,
									 studentId:studentId,
									 onlyCurrentRecords:false
								 };
								 courseStore.load();
							 } 
						 }
					 }
				 });
				// this.onClickSearchButton();
	         },
	         courseWiseStudentAttendancePeriodChange : function(form, periodId){
	        	 var $this=this; 
	        	 var programId=form.down("#courseWiseProgramId").getValue();
	        	 var studentALField = form.down("#studentAcademyLocationCourse");
	        	 var batchId=form.down("#courseWiseBatchId").getValue();
				 var courseField=form.down("#courseWiseCourseNameId");
				 var courseVariantField=form.down("#courseWiseCoursevarientId");
				 var attendancePercentageFromField=form.down("#courseWiseAttendancePercentageFromId");
				 var attendancePercentageToField=form.down("#courseWiseAttendancePercentageToId");
				 var courseWiseStartDateField=form.down("#startDate");
				 var courseWiseEndDateField=form.down("#endDate");
				 var selectedALId = studentALField.getValue();
				 var currentALId = $this.getCurrentAcademyLocation();
				 
				 var studentInfo = null;
	        	 var studentId 
	        	 if($this.getCurrentLoggedPortalId()==3 || $this.getCurrentLoggedPortalId()==7){
	        		 studentInfo = $this.getCurrentlyLoggedInUserInfoForPortal();
	        		 studentId = studentInfo.student.id;
	        	 } else {
	        		 var personProfile = $this.getContentPanelActiveTab();
	        	     studentId = personProfile.getUserId();
	        	     studentInfo = $this.getStudentDetailForErpPortal()
	        	 }
	        	// this.onClickSearchButton();
				 courseField.reset();
				 courseVariantField.reset();
	        	 attendancePercentageFromField.reset();
	        	 attendancePercentageToField.reset();
	        	 courseWiseStartDateField.reset();
	        	 courseWiseEndDateField.reset();
	        	 courseVariantField.setDisabled(true);
				 var courseStore = courseField.getStore();
				 courseStore.getProxy().extraParams = {
					 programId: programId,
					 batchId: batchId,
					 periodId: periodId,
					 studentId:studentId,
					 onlyCurrentRecords:false,
					 academyLocationIds:selectedALId
				 };
				 courseStore.load();
	         },
	         courseWiseStudentAttendanceCourseChange : function(form, courseId){
	        	 var $this=this; 
	        	 var programId=form.down("#courseWiseProgramId").getValue();
	        	 var batchId=form.down("#courseWiseBatchId").getValue();
				 var periodId=form.down("#courseWisePeriodId").getValue();
				 var courseVariantField=form.down("#courseWiseCoursevarientId");
				 var attendancePercentageFromField=form.down("#courseWiseAttendancePercentageFromId");
				 var attendancePercentageToField=form.down("#courseWiseAttendancePercentageToId");
				 var courseWiseStartDateField=form.down("#startDate");
				 var courseWiseEndDateField=form.down("#endDate");
				 
				 var studentInfo = null;
	        	 var studentId 
	        	 if($this.getCurrentLoggedPortalId()==3 || $this.getCurrentLoggedPortalId()==7){
	        		 studentInfo = $this.getCurrentlyLoggedInUserInfoForPortal();
	        		 studentId = studentInfo.student.id;
	        	 } else {
	        		 var personProfile = $this.getContentPanelActiveTab();
	        	     studentId = personProfile.getUserId();
	        	     studentInfo = $this.getStudentDetailForErpPortal()
	        	 }
	        	 courseVariantField.reset();
	        	 attendancePercentageFromField.reset();
	        	 attendancePercentageToField.reset();
	        	 courseWiseStartDateField.reset();
	        	 courseWiseEndDateField.reset();
	        	 
	        	 courseVariantField.setDisabled(false);
				 var courseVariantStore = courseVariantField.getStore();
				 courseVariantStore.getProxy().extraParams = {
					 programId: programId,
					 batchId: batchId,
					 periodId: periodId,
					 courseId: courseId,
					 studentId:studentId,
					 onlyCurrentRecords:false
				 };
				 courseVariantStore.load({
					 callback: function(records, operation, success) {
						 if (success) {
							 if(records.length == 1) {
								 courseVariantField.setValue(records[0].data.id);
								// $this.onClickSearchButton();
							 } else {
								 //$this.onClickSearchButton();
							 }
						 }
					 }
				 });
	         },
	         onClickSearchButton : function(form, courseId){
	        	 var me = this;
	        	 var contentPanelActiveTab = me.getContentPanelActiveTab();
				 var attendancesearchstrucure =contentPanelActiveTab.down('studentattendancereportstructure');
				 attendancesearchstrucure.down('#attendancereportpanelstudentportel').setVisible(true);
	        	 var newTabName=attendancesearchstrucure.down('#attendancereportpanelstudentportel').getActiveTab();
	        	 if(newTabName.title==getProgramandcourseTranslation('CONSOLIDATED')){
	        		 this.loadStudentConsolidatedAttendanceRecord();
	        	 }else  if(newTabName.title==getCommonTranslation('COURSE_WISE')){	
	        		 this.loadStudentCourseWiseAttendanceRecord();
	        	 }
	         }

});
