/**

 * @author Deepika Parmar
 */

Ext.define('Academia.controller.powerBI.MarkSummaryAnalyticsReportController', {
	extend: 'Academia.controller.powerBI.AnalyticsCommonController',

	models: [],
	stores: ['powerBI.MarkSummaryReportStore'],

	views: ['powerBI.MarkSummaryReportView','powerBI.MarkSummaryReportViewTabPanel','powerBI.analytics.MarkSummaryReportView2021',
		'powerBI.analytics.MarkSummaryReportView2022','powerBI.analytics.MarkSummaryReportView2023','powerBI.analytics.MarkSummaryReportView2024',
		'powerBI.analytics.MarkSummaryReportView2025','powerBI.analytics.MarkSummaryReportView2026','powerBI.analytics.SubMenu1_Report1'],
	requires:['Academia.constants.ServiceRequestConstants'],
	refs: [{
		ref: 'contentpanel',
		selector: 'contentpanel'
	},{
		ref:"marksummaryreportview",
		selector:"marksummaryreportview"
	},{
		ref:'marksummaryreportviewtabpanel',
		selctor:'marksummaryreportviewtabpanel'
	},{
		ref:'marksummaryreportview2021',
		selector:'marksummaryreportview2021'
	},{
		ref:'marksummaryreportview2022',
		selector:'marksummaryreportview2022'
	},{
		ref:'marksummaryreportview2023',
		selector:'marksummaryreportview2023'
	},{
		ref:'marksummaryreportview2024',
		selector:'marksummaryreportview2024'
	},{
		ref:'marksummaryreportview2025',
		selector:'marksummaryreportview2025'
	},{
		ref:'marksummaryreportview2026',
		selector:'marksummaryreportview2026'
	},{
		ref:'submenu1_report1',
		selector:'submenu1_report1'
	}],
	config: {
		MARK_SUMMARY_VIEW_2021_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_MARK_SUMMARY_REPORT_2021_PRIVILEGES'),
		MARK_SUMMARY_VIEW_2022_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_MARK_SUMMARY_REPORT_2022_PRIVILEGES'),
		MARK_SUMMARY_VIEW_2023_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_MARK_SUMMARY_REPORT_2023_PRIVILEGES'),
		MARK_SUMMARY_VIEW_2024_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_MARK_SUMMARY_REPORT_2024_PRIVILEGES'),
		MARK_SUMMARY_VIEW_2025_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_MARK_SUMMARY_REPORT_2025_PRIVILEGES'),
		MARK_SUMMARY_VIEW_2026_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_MARK_SUMMARY_REPORT_2026_PRIVILEGES'),

	},
	init: function(application) {
		var this$ = this;


		this.control({
			'contentpanel [cls=markSummaryStructureItemId]': {
				afterrender: function(structure){
					var this$=this;
					this.getReport(structure);
					this.setAccessTokenInterval(structure);
				},
				beforeclose:function(structure){
					this.clearAccessTokenInterval(structure);
				}
			},
			'marksummaryreportview treepanel[itemId=markSummaryeportTreePanel]' : {
				afterrender:function(obj){
					var $this = this;
					var reportParantNode = obj.getStore().tree.root;
					$this.applyPermissionOnLinks(reportParantNode);
				},
				itemclick : this.penReportTabStructure
			},
			'contentpanel [cls=markSummaryStructureItemId] button#reload': {
				click: function(btn){
					var structure = btn.up('[cls=markSummaryStructureItemId]');
					this.reloadButton(structure);
				}
			},

		});
	},

	applyPermissionOnLinks: function(reportParantNode){

		var $this = this;

		if(reportParantNode.hasChildNodes()){
			reportParantNode.removeAll();
		}
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());

		var permissionMap =$this.getMARK_SUMMARY_VIEW_2021_PERMISSIONS();
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
		Ext.each(permissionList, function(privilege) {
			if (privilege === 'VIEW') {
				reportParantNode.appendChild({
					text: getExaminationTranslation('MARK_SUMMARY_VIEW_2021'),
					reportXtype: 'marksummaryreportview2021',
					reportXtypeItemId: 'marksummaryreportview2021ItemId',
					leaf: true,
					expanded: false
				});
			}
		});
		permissionMap =$this.getMARK_SUMMARY_VIEW_2022_PERMISSIONS();
		permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
		Ext.each(permissionList, function(privilege) {
			if (privilege === 'VIEW') {
				reportParantNode.appendChild({
					text: getExaminationTranslation('MARK_SUMMARY_VIEW_2022'),
					reportXtype: 'marksummaryreportview2022',
					reportXtypeItemId: 'marksummaryreportview2022ItemId',
					leaf: true,
					expanded: true
				});
			}
		});
		permissionMap =$this.getMARK_SUMMARY_VIEW_2023_PERMISSIONS();
		permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
		Ext.each(permissionList, function(privilege) {
			if (privilege === 'VIEW') {
				reportParantNode.appendChild({
					text: getExaminationTranslation('MARK_SUMMARY_VIEW_2023'),
					reportXtype: 'marksummaryreportview2023',
					reportXtypeItemId: 'marksummaryreportview2023ItemId',
					leaf: true,
					expanded: true
				});
			}
		});

		permissionMap =$this.getMARK_SUMMARY_VIEW_2024_PERMISSIONS();
		permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
		Ext.each(permissionList, function(privilege) {
			if (privilege === 'VIEW') {
				reportParantNode.appendChild({
					text: getExaminationTranslation('MARK_SUMMARY_VIEW_2024'),
					reportXtype: 'marksummaryreportview2024',
					reportXtypeItemId: 'marksummaryreportview2024ItemId',
					leaf: true,
					expanded: true
				});
			}
		});

		permissionMap =$this.getMARK_SUMMARY_VIEW_2025_PERMISSIONS();
		permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
		Ext.each(permissionList, function(privilege) {
			if (privilege === 'VIEW') {
				reportParantNode.appendChild({
					text: getExaminationTranslation('MARK_SUMMARY_VIEW_2025'),
					reportXtype: 'marksummaryreportview2025',
					reportXtypeItemId: 'marksummaryreportview2025ItemId',
					leaf: true,
					expanded: true
				});
			}
		});

		permissionMap =$this.getMARK_SUMMARY_VIEW_2026_PERMISSIONS();
		permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
		Ext.each(permissionList, function(privilege) {
			if (privilege === 'VIEW') {
				reportParantNode.appendChild({
					text: getExaminationTranslation('MARK_SUMMARY_VIEW_2026'),
					reportXtype: 'marksummaryreportview2026',
					reportXtypeItemId: 'marksummaryreportview2026ItemId',
					leaf: true,
					expanded: true
				});
			}
		});
	},
	penReportTabStructure : function(treePanel,record,item,index,e,eOpts) {
		var $this = this;
		var markSummaryReportView = $this.getMarksummaryreportview();
		var treeTab = markSummaryReportView.down('#markSummaryeportTreePanel');
		var markSummaryReportViewTabPanel = markSummaryReportView.down('marksummaryreportviewtabpanel');;


		var contentpanel = $this.getContentpanel();
		var tabName = record.data.text;

		var getcontroller=$this.getController('menu.CoreERPNavigationController');
		var getTab=getcontroller.getInnerTab(markSummaryReportViewTabPanel,tabName);
		if(getTab==null){
			contentpanel.remove(getTab, true);
		}

		var tabDetail = record.data;
		var structure = Ext.widget(tabDetail.reportXtype);

		if (!isNullOrEmpty(tabDetail.text)&& !isNullOrEmpty(tabDetail.reportXtype)&& !isNullOrEmpty(tabDetail.reportXtypeItemId)) {
			treeTab.toggleCollapse();
			openTab(markSummaryReportViewTabPanel, tabDetail.text,structure);
			treePanel.getSelectionModel().deselectAll();
		}
	},
});
