Ext.define('Academia.controller.program.ProgramPeriodsBreaksController', {
    //extend: 'Ext.app.Controller',
    extend: 'Academia.controller.base.BaseController',
    
    stores: ['program.programDetails.programBatches.programPeriodBreak.ProgramPeriodBreakGrid',
             'program.programDetails.programBatches.programPeriodBreak.PeriodBreakSequence',
             'program.programDetails.programBatches.programPeriodBreak.ProgramPeriodBreakType'
             ],
    model: ['program.programDetails.programBatches.programPeriodBreak.ProgramPeriodBreak'],
    
    views: [
            'program.programDetails.programBatchDetails.periodsBreaks.ProgramPeriodsBreaksForm',
        	'program.programDetails.programBatchDetails.periodsBreaks.ProgramPeriodsBreaksGrid',
        	'program.programDetails.programBatchDetails.periodsBreaks.ProgramPeriodsBreaksStructure'
        	],
    config:{
    		/*
    		 * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
        		   	 */
        	   	/**
        	        * @cfg {Array} PERIODBREAK_PERMISSIONS array (required)
        	        * The array of permissions to use for Access control wise enabling and disabling buttons.
        	        * @accessor
        	        */
          PERIODBREAK_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PERIODBREAK_PRIVILEGES')  		  
    },
    refs: [
           {
    ref: 'programbatchdetailstabstructure',
    selector: 'programbatchdetailstabstructure'
    },{
        ref: 'programperiodsbreaksgrid',
        selector: 'programperiodsbreaksgrid'
    },{
        ref: 'programperiodsbreaksformwindow',
        selector: 'programperiodsbreaksformwindow'
    },{
        ref: 'programperiodsBreaksformwindow',
        selector: 'programperiodsbreaksformwindow form'
    },{
	    ref: 'contentPanel',
	    selector: 'contentPanel'
	}],

    init: function(application) {
        this.control({
        	'programperiodsbreaksgrid':{
        		afterrender:function(grid){
        			this.doAccessControlValidation(grid, this.getPERIODBREAK_PERMISSIONS());
        			grid.getStore().load();
        		} 
        	},
        	
        	'programperiodsbreaksgrid button[itemId=btnAdd]':{
            	click: function() {
                	this.onAddshowProgramPeriodsBreaksFormWindow();
                }
            },
            'programperiodsbreaksgrid button[itemId=btnEdit]':{
            	click: function() {
                	this.editProgramPeriodsBreaksFormWindow();
                }
            },
            'programperiodsbreaksgrid button[itemId=btnView]':{
            	click: function() {
                	this.viewProgramPeriodsBreaksFormWindow();
                }
            },
            'programperiodsbreaksgrid button[itemId=btnDelete]':{
            	click: function() {
                	this.deleteProgramPeriodsBreaksFormWindow();
                }
            },
            'programperiodsbreaksformwindow button[itemId=programPeriodsBreaksFormCancel]':{
            	click: function() {
                	this.closeProgramPeriodsBreaksFormCancel();
                }
            },
            'programperiodsbreaksformwindow button[itemId=programPeriodsBreaksFormSubmit]':{
            	click: function() {
                	this.addProgramPeriodsBreaks();
                }
            },
            'programperiodsbreaksformwindow combo[itemId=programPeriodSequence_Id]':{
            	select: function(ob,rec) {
                	this.progPeriodSeq(ob,rec);
                }
            }
            ,
            'programbatchdetailstabstructure combo[itemId=batchId]' : {
        		select : function(t,r) {
        			var $this = this;
        			var batchId = "";
            		if(Ext.isObject(r) || Ext.isArray(r)){
            			batchId=r[0].data.id;
					  }else{
						  batchId=r;
					  }
        			var store = $this.getStore('program.programDetails.programBatches.programPeriodBreak.ProgramPeriodBreakGrid');
        			store.getProxy().extraParams ={
        				batchId : batchId
        			};
        			store.load();
        		}
        	}
        });
    },
           
      showProgramPeriodsBreaksFormWindow: function() {
	        var formWindow = this.getProgramperiodsbreaksformwindow();
	        if (!formWindow) {
	            Ext.widget('programperiodsbreaksformwindow');
	            formWindow = this.getProgramperiodsbreaksformwindow();
	        }
	        formWindow.show();
	    },
	    onAddshowProgramPeriodsBreaksFormWindow:function(){
	    	this.showProgramPeriodsBreaksFormWindow();
	    	
	    	/*var form = this.getProgramperiodsBreaksformwindow().getForm();
	        console.log('form',form);
	        form.findField('breakStart').setDisabledDates(["03-02-2015", "09-02-2015"]);*/
	        
	    	var batchId =this.getProgrambatchdetailstabstructure().getForm().findField('batch').getValue();
	        	var store = this.getStore('program.programDetails.programBatches.programPeriodBreak.PeriodBreakSequence');
	    		store.getProxy().extraParams ={
	    			id : batchId
	    		},
	    		store.load();
	    },
	    closeProgramPeriodsBreaksFormCancel: function() {
	        this.getProgramperiodsbreaksformwindow().close();
	    },
	     
     addProgramPeriodsBreaks:function(){
    	 var $this = this;
    	 var batchId =$this.getProgrambatchdetailstabstructure().getForm().findField('batch').getValue();
    	 var form = Ext.getCmp('programPeriodsBreaksForm').getForm();
    	 var value = form.getValues();
    	 var seqId = form.findField('programPeriodSequence').getValue();
    	 var seqType = form.findField('programPeriodSequence').getRawValue();
    	 var periodSequenceCombo = this.getIdValueJson(seqId, seqType);
    	 var periodBreaks  =  new  Academia.model.program.programDetails.programBatches.programPeriodBreak.ProgramPeriodBreak();
    	 periodBreaks.set("id", value.id );
    	 periodBreaks.set("programPeriodBreakSeq", value.programPeriodBreakSeq );
    	 periodBreaks.set("breakStart", value.breakStart );
    	 periodBreaks.set("breakEnd", value.breakEnd );
    	 periodBreaks.set("breakName", value.breakName );
    	 periodBreaks.set("batchId", batchId);
    	 periodBreaks.set("breakType", value.breakType);
    	 periodBreaks.set("programPeriodSequence", periodSequenceCombo);
    	 periodBreaks.set("customFieldDatas", value.customFieldDatas);
    	 var submitUrl;
    	 if (form.findField('id').getSubmitValue() == null
    			 || form.findField('id').getSubmitValue() == "") {
    		 submitUrl = SERVERURL.PERIOD_BREAK_CREATE;
    	 } else {
    		 periodBreaks.set("id", value.id);
    		 submitUrl = SERVERURL.PERIOD_BREAK_UPDATE;
    	 }
    	 var formData = Ext.encode(periodBreaks.data);
    	 $this.applyWindowMask(); 
    	 Ext.Ajax.request({
    		 type : 'rest',
    		 url : submitUrl,
    		 jsonData : formData,
    		 method : 'POST',
    		 success : function(form, action) {
    			 $this.hideWindowMask();
    			 showSuccessMessage(getCommonTranslation('PERIOD_BREAKS_FORM'),
    					 getCommonTranslation('SUCCESS'));
    			 $this.getStore('program.programDetails.programBatches.programPeriodBreak.ProgramPeriodBreakGrid').load();
    			 $this.getProgramperiodsbreaksformwindow().close();
    		 }
    	 });
     },
     getIdValueJson : function(id, value, code) {
    	 if (id)
    		 return {
    		 id : id,
    		 value : value,
    		 code : code
    	 };
     },
     progPeriodSeq:function(ob,rec){
    	 var $this = this;
    	 var periodSeqId = rec[0].data.id;
    	 var periodId = rec[0].data.levelId;
    	 console.log('rec[0].data',rec[0].data);
    	 var code = rec[0].data.code;
    	 var form = Ext.getCmp('programPeriodsBreaksForm').getForm();
    	 form.findField('periodName').setValue(code);
    	 var submitUrl = SERVERURL.PROGRAM_BREAK_SEQUENCE + '?periodSeqId=' + periodSeqId; 
    	 Ext.Ajax.request({
    		 type : 'rest',
    		 url : submitUrl,
    		 params : {
    			 periodSeqId : periodSeqId
    		 },
    		 method : 'GET',
    		 success : function(form, action) {
    			 var res =	Ext.JSON.decode(form.responseText);
    			 var form = Ext.getCmp('programPeriodsBreaksForm').getForm();
    			 form.findField('programPeriodBreakSeq').setValue(res);
    		 }
    	 });

    	 Ext.Ajax.request({
    		 type : 'rest',
    		 url : SERVERURL.PERIOD_FIND_BY_ID,
    		 params : {
    			 id : periodId
    		 },
    		 method : 'GET',
    		 success : function(form, action) {
    			 var res =	Ext.JSON.decode(form.responseText);
    			 var form = Ext.getCmp('programPeriodsBreaksForm').getForm();
    			 form.findField('breakStart').setMinValue(dateRender(res.programPeriodStart));
    			 form.findField('breakStart').setMaxValue(dateRender(res.programPeriodEnd));

    			 form.findField('breakEnd').setMinValue(dateRender(res.programPeriodStart));
    			 form.findField('breakEnd').setMaxValue(dateRender(res.programPeriodEnd));
    			 
    			 
    			 Ext.Ajax.request({
    	    		 type : 'rest',
    	    		 url : SERVERURL.DATES_AVAILABLE_FOR_BREAKS,
    	    		 params : {
    	    			 periodId : periodId
    	    		 },
    	    		 method : 'GET',
    	    		 success : function(form, action) {
    	    			 var res =	Ext.JSON.decode(form.responseText);
    	    			 console.log('res',res);
    	    			 var form = $this.getProgramperiodsBreaksformwindow().getForm();
    	    		        form.findField('breakStart').setDisabledDates(res);
    	    		        form.findField('breakEnd').setDisabledDates(res);
    	    		 }
    	    	 }); 

    			 
    		 }
    	 }); 


     },
  viewProgramPeriodsBreaksFormWindow:function(){
	  this.editProgramPeriodsBreaksFormWindow();
		 var form = Ext.getCmp('programPeriodsBreaksForm').getForm();
		 if (form) {
 		Ext.ComponentQuery.query('button#programPeriodsBreaksFormSubmit')[0].hide(); 
 		//Ext.ComponentQuery.query('button#programPeriodsBreaksFormCancel')[0].hide();  
			toggleReadOnlyFormItems(form, true);
		}
  },
  editProgramPeriodsBreaksFormWindow:function(){
	  var $this = this;
	  var grid = $this.getProgramperiodsbreaksgrid();
	  if (grid.getSelectionModel().getCount() > 0) {
		  $this.showProgramPeriodsBreaksFormWindow();

		  var records = grid.getSelectionModel()
		  .getSelection();
		  if (records != undefined && records != ""
			  && records != null) {
			  var id = records[0].data.id;
			  Ext.Ajax
			  .request({
				  type : 'rest',
				  url : SERVERURL.PERIOD_BREAK_FIND_BY_ID,
				  params : {
					  id : id
				  },
				  method : 'GET',
				  success : function(response) {
					  var	form = Ext.getCmp('programPeriodsBreaksForm').getForm();
					  var data = Ext.decode(response.responseText);
					  var periodBreaks = new Academia.model.program.programDetails.programBatches.programPeriodBreak.ProgramPeriodBreak(data);
					  form.loadRecord(periodBreaks);
					  form.findField('breakStart').setValue(dateRender(data.breakStart));
					  form.findField('breakEnd').setValue(dateRender(data.breakEnd));
					  var button =Ext.ComponentQuery.query('button#programPeriodsBreaksFormSubmit')[0];
					  button.setText('Save');
					  form.findField('periodName').setValue(data.programPeriodSequence.code);
					  var periodBreakSeqCombo = form.findField('programPeriodSequence');
					  var batchId=data.batchId;
					  periodBreakSeqCombo.getStore().getProxy().extraParams ={
						  id : batchId
					  };
					  periodBreakSeqCombo.getStore().load({
						  callback : function(records,operation,success) {
							  if (success) {
								  for(var i in records){
									  if(records[i].data.id==data.programPeriodSequence.id){
										  var periodId=records[i].data.levelId
										  periodBreakSeqCombo.setValue(data.programPeriodSequence.id);
										  Ext.Ajax.request({
											  type : 'rest',
											  url : SERVERURL.PERIOD_FIND_BY_ID,
											  params : {
												  id : periodId
											  },
											  method : 'GET',
											  success : function(form, action) {
												  var res =	Ext.JSON.decode(form.responseText);
												  var form = Ext.getCmp('programPeriodsBreaksForm').getForm();
												  form.findField('breakStart').setMinValue(dateRender(res.programPeriodStart));
												  form.findField('breakStart').setMaxValue(dateRender(res.programPeriodEnd));
												  form.findField('breakStart').validate(true);
												  
												  form.findField('breakEnd').setMinValue(dateRender(res.programPeriodStart));
												  form.findField('breakEnd').setMaxValue(dateRender(res.programPeriodEnd));
												  form.findField('breakEnd').validate(true);
											  }
										  });
									  }
								  }
							  }
						  }
					  });
				  }
			  });
		  }
	  }else{
		  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	  }
  },
  deleteProgramPeriodsBreaksFormWindow:function(){
	  var grid = this.getProgramperiodsbreaksgrid();
	  if (grid.getSelectionModel().getCount() > 0) {
		  showConfirmMessage(getCommonTranslation('PERIOD_BREAKS'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
				  function(btn, text) {
			  if (btn == 'yes'){
				  var records = grid.getSelectionModel().getSelection()[0];
				  var id = records.data.id;
				  Ext.Ajax
				  .request({
					  method : "DELETE",
					  type : 'rest',
					  url : SERVERURL.PERIOD_BREAK_DELETE+ 'id='+ id,
					  headers : {
						  'Content-Type' : 'application/json'
					  },
					  params : {
						  id : id
					  },
					  success : function(form,action) {
						  showSuccessMessage(getCommonTranslation('PERIOD_BREAKS'),getCommonTranslation('SUCCESS'));
						  grid.getStore().reload();
					  }
				  });
			  }
		  });
	  } else {
		  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
	  }
  }
     
});