/**
 * This controller is used for the User Role And Privilege Report. 
 * 
 * @author Amit Gupta
 */
Ext.define('Academia.controller.reports.allReports.ReportsMainController', {
    extend: 'Academia.controller.base.BaseController',
    views: ['reports.allReports.ReportsMainStructure',
        'reports.allReports.ReportsCardTpl',
        'reports.allReports.ReportInnerMenuDataView',
        'baselayout.contentarea.ContentPanel',
        'baselayout.megamenu.VerticalNavigationMenu'
    ],
    stores: ['reports.allReports.ReportInnerMenuDataViewStore'],
    models : [ ], 
    refs: [{
        ref: 'reportsmainstructure',
        selector: 'reportsmainstructure'
    },{
    	ref: 'reportscardtpl',
        selector: 'reportscardtpl'
    },{
    	ref: 'reportinnermenudataview',
        selector: 'reportinnermenudataview'
    }, {
        ref: 'contentPanel',
        selector: 'contentPanel'
    },{
        ref: 'verticalNavigationMenu',
        selector: 'verticalNavigationMenu'
    }],
    config: {
    	
    },
    init: function(application) {
    	this.control({ 
    		'reportsmainstructure': {
    			afterrender: function(structure) {
    				Ext.defer(function() {
    					structure.down('[name=menuTitleName]').setValue(structure.title);
    				}, 100);
    			}
    		},
    		'reportinnermenudataview':{
    			afterrender: function(structure) {
    				var getMenuName = structure.up('reportsmainstructure').title;
    				var getTitleHeader = structure.up('reportsmainstructure').titleHeader;
    				var mainStore = structure.getStore();
    				 mainStore.getProxy().extraParams = {
                    	menuCode: getTitleHeader,
         				menuName: getMenuName,
         				portalId: this.getCurrentLoggedPortalId()
                     };
    				 mainStore.load({
    					 callback: function (records) {
    					        if (records && records.length > 0) {
    					            var record = records[0];
    					            var index = mainStore.indexOf(record);
    					            var item = structure.getNode(index);

    					            // Pass dummy event object { }
    					            structure.fireEvent('itemclick', structure, record, item, index, {}); 
    					        }
    					    }
    				    });
    			},
    			itemclick: function (view, record) {
    				var getReportTplStore = view.up('reportsmainstructure').down('reportscardtpl').getStore();
    				getReportTplStore.loadData(record.data.subLink);
    			}
    		},
    		'reportscardtpl':{
            	afterrender: function(currentTpl){
            		var me = this;
            			var getManuName = currentTpl.manuName;
            			var getTitleName = currentTpl.titleName;
            			//currentTpl.down('[name=menuName]').setValue(getManuName);
            			//currentTpl.down('[name=subTitleName]').setValue(getTitleName);
            			
            		//currentTpl.doLayout();
            	},
    			itemclick: function (view, record) {
    				//--
    				
    				Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    		    	spinnerDiv = document.getElementById('innerSpinner');
    		    	var navPosition = this.getVerticalNavigationMenu().collapsed;
    		    	var mainView = this.getContentPanel();
    		    	var height = mainView.getHeight()/2;
    		    	spinnerDiv.style.width = mainView.getWidth() + 'px';
    		    	if(navPosition == "left")
    		    	{
    		    		spinnerDiv.style.margin = height+"px auto "+ height+"px 60px";
    		    	}
    		    	else{
    		    		spinnerDiv.style.margin = height+"px auto "+ height+"px 220px";
    		    	}
    		    	$('#innerSpinner').show();
    		    	var that = this;
    		    	
    		    	if(record.data.privilegeCode == "AVAILABILITY_REPORT"){
        		    	var displayCode = "ROOM_AVAILABILITY_REPORT";
        		    	var launchView = "roomallocationreportstructure";
        		    	var moduleName = "MENU_REPORTS";
    		    	}
    		    	else if(record.data.privilegeCode == "OCCUPANCY_REPORT"){
    		    		var displayCode = "ROOM_OCCUPANCY_REPORT";
        		    	var launchView = "manageallocationreportstructure";
        		    	var moduleName = "MENU_REPORTS";
    		    	}
    		    	else if(record.data.privilegeCode == "HOSTEL_FEE_REPORT"){
    		    		var displayCode = "HOSTEL_FEE_REPORT";
        		    	var launchView = "hostelfeereportstructure";
        		    	var moduleName = "MENU_REPORTS";
    		    	}
    		    	else if(record.data.privilegeCode == "HOSTEL_ATTENDANCE_REPORT"){
    		    		var displayCode = "HOSTEL_ATTENDANCE_REPORT";
        		    	var launchView = "hostelattendancestructure";
        		    	var moduleName = "MENU_REPORTS";
    		    	}
    		    	else if(record.data.privilegeCode == "HOSTEL_DETAILS_REPORT"){
    		    		var displayCode = "HOSTEL_DETAIL_REPORT";
        		    	var launchView = "hosteldetailreportstructure";
        		    	var moduleName = "MENU_REPORTS";
    		    	}
    		    	else{
    		    		$('#innerSpinner').hide();
    		    		Ext.getBody().unmask();
    		    		showWarningMessage(getCommonTranslation('ALERT'),getServiceRequestTranslation('N_A')); 
    		    		return;
    		    	}
    		    		
    		    	this.openNewReportTab(getMenuDisplayName(displayCode), launchView, "menuColorOne", null, null, null, moduleName, true);
    		    	
    			}            
           }
    	});
    },
    openNewReportTab: function(tabTitle, contentXtype, menuColorcls,contentPanel,configCode,viewCode,moduleName, isNavigationMenuClicked,headerDisplayCode) {
    	this.loadReportContollers(contentXtype);
    	
    	try{
        	isNavigationMenuClicked = !isNullOrEmpty(isNavigationMenuClicked) ? isNavigationMenuClicked : false;
    	}
    	catch(e){
    		isNavigationMenuClicked = false;
    	}
    	
    	//if(!contentPanel)
    	if(!contentPanel)
    		contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
    	var newTab = contentPanel.items.findBy(function(tab) {
    		if(!isNavigationMenuClicked){
        		return tab.title === tabTitle && contentPanel.getActiveTab() != tab;
    		}
    		else{
    			return tab.title === tabTitle;
    		}
    	});
    	
    	if(newTab && newTab.xtype == "servicerequestpanel"){
    		newTab.close();
    		newTab = false;
    	}
    	
    	if (!newTab) {
    		newTab = contentPanel.add({
    			xtype: contentXtype,
    			closable: true,
    			menuColorCls: menuColorcls,
    			title: tabTitle,
    			searchConfigCode : configCode,
    			searchResultViewCode: viewCode,
    			gridTitle: tabTitle,
    			titleHeader:headerDisplayCode,
    			moduleName:moduleName
    			
    		});
    	}
    	contentPanel.setActiveTab(newTab);
    	//spinnerDiv.style.display = "none";
    	$('#innerSpinner').hide();
    	Ext.getBody().unmask();
    	return newTab;
    },
    loadReportContollers:function(contentXtype){
		if(environment=="Development"){ 
	    	var tempArr = [];
	    	tempArr = myControllers(contentXtype);
	    	if(tempArr == false){
	    		tempArr =[];
	    	}
	    	for (var i = 0; i < tempArr.length; i++) {
	    		if (this.getApplication().ctrls.indexOf(tempArr[i]) === -1) {
	    			Academia.getApplication().runAction(tempArr[i]);
	    			this.getApplication().ctrls.push(tempArr[i]);
	    		}
			}
		}
	}
    });