/**
 * @author Pritam.Patil
 * This is used for faculty reports functionality 
 */
Ext.define('Academia.controller.reports.faculty.FacultyReportsController', {
    extend: 'Academia.controller.base.BaseController',

    views: ['reports.faculty.personaldetails.FacultyChildReportPanel',
            'reports.faculty.personaldetails.FacultyChildReportSearchForm',
            'reports.faculty.personaldetails.FacultyChildReportView',
            'reports.faculty.personaldetails.FacultyExtraCurricularActivityPanel',
            'reports.faculty.personaldetails.FacultyExtraCurricularActivityReportSearchForm', 
            'reports.faculty.personaldetails.FacultyExtraCurricularActivityView'],

    stores: ['common.SelectNameComboStore', 'common.RelationshipStore', 'scholarships.ScholarshipCoursesStore', 
             'department.SubDepartmentComboStore','department.DepartmentComboStore',
             'Academia.store.common.ProgramsByAcademyIdLocationId', 
             'Academia.store.common.BatchesByProgramId'
             ],

    refs: [{
        ref: 'contentPanel',
        selector: 'contentpanel'
    }, {
        ref: 'facultyExtraCurricularActivityReportSearchForm',
        selector: 'facultyextracurricularactivityreportsearchform[itemId=facultyExtraCurricularActivityReportSearchForm]'
    }, {
        ref: 'extraCurricularSearchResultGrid',
        selector: 'searchresultgrid[itemId=facultyExtraCurricularSearchResultGrid]'
    }, {
        ref: 'facultyChildReportSearchForm',
        selector: 'facultychildreportsearchform[itemId=facultyChildReportSearchForm]'
    }, {
        ref: 'facultyChildSearchResultGrid',
        selector: 'searchresultgrid[itemId=facultyChildSearchResultGrid]'
    }],
    config: {
    	FACULTY_EXTRACURRICULUMREPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_EXTRACURRICULUMREPORT_PRIVILEGES'),
    	FACULTY_EMPLOYEECHILDREPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_EMPLOYEECHILDREPORT_PRIVILEGES')
    },
    init: function(application) {
        this.control({

        	'fieldcontainer[itemId=progrmBatchCourseContainer] combo[itemId=programComboField]': {
        		afterrender : function(programComboField, records, eOpts) {
        			var academyLocationIds = this.getCurrentAcademyLocation();
        			this.loadDependentCombo(programComboField, academyLocationIds, 'academyLocationIds');
        		},
        		select: function(combo, records, eOpts) {
        			// For batch load
        			var comboValue = combo.getValue();
                    var batchComboField = combo.up('form').down('#batchComboField');
                    this.loadDependentCombo( batchComboField, comboValue, 'id');
                    //For course load
                    var courseComboField = combo.up('form').down('#courseComboField');
                    this.loadDependentCombo(courseComboField, comboValue, 'programId');
                }
        	},
        	
        	
            /**
             * Faculty employee child report
             */
            
        	'facultychildreportsearchform[itemId=facultyChildReportSearchForm] button[itemId=searchButtonId]': {
                click: function(){
                	this.loadFacultyChildReportsGrid();
                }
            },
            'facultychildreportsearchform[itemId=facultyChildReportSearchForm] button[itemId=resetButtonId]': {
                click: function(){
                	var form = this.getFacultyChildReportSearchForm();
                	this.resetSearchCriteriaForm(form);
                }
            },
            'facultychildreportsearchform[itemId=facultyChildReportSearchForm] combo[itemId=selectedNameFieldId]': {
                change: function(combo, record, value){
                	this.changeNameFieldConfig(combo);
                }
            },
            
            /**
             * Faculty extra curricular activity report
             */
            'facultyextracurricularactivityreportsearchform[itemId=facultyExtraCurricularActivityReportSearchForm] button[itemId=searchButtonId]': {
                click: function(){
                	this.loadExtraCurricularReportsGrid();
                }
            },
            'facultyextracurricularactivityreportsearchform[itemId=facultyExtraCurricularActivityReportSearchForm] button[itemId=resetButtonId]': {
                click: function(){
                	var form = this.getFacultyExtraCurricularActivityReportSearchForm();
                	this.resetSearchCriteriaForm(form);
                }
            },
            'facultyextracurricularactivityreportsearchform[itemId=facultyExtraCurricularActivityReportSearchForm] combo[itemId=selectedNameFieldId]': {
            	change: function(combo, record, value){
                	this.changeNameFieldConfig(combo);
                }
            },
            'searchresultgrid[itemId=facultyChildSearchResultGrid]': {
            	render: function(grid) {
 					this.gridRenderFunction(grid);
 				}
            },
            'searchresultgrid[itemId=facultyExtraCurricularSearchResultGrid]' : {
            	render: function(grid) {
 					this.gridRenderFunction(grid);
 				}
            },
            'facultychildreportview grid[itemId=facultyChildSearchResultGrid]': {
            	afterrender : function(grid){
 					this.genericCBGridAccessControlValidation(grid, this.getFACULTY_EMPLOYEECHILDREPORT_PERMISSIONS());
 					var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
 			   		viewButton.setVisible(false);
 				}	
            },
            'facultyextracurricularactivityview grid[itemId=facultyExtraCurricularSearchResultGrid]' : {
            	afterrender : function(grid){
 					this.genericCBGridAccessControlValidation(grid, this.getFACULTY_EXTRACURRICULUMREPORT_PERMISSIONS());
 					var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
 			   		viewButton.setVisible(false);
 				}
            },
            /*FixingHeaderColumn*/
            'facultyextracurricularactivitypanel':{
            	afterrender : function(structure){
					var $this = this;
					structure.body.on('scroll', function(e, target) {
						 var grid = structure.down('searchresultgrid');
						 //this.getCBGridHeaderFreeze(grid,structure);
						 $this.getMultipleCBGridHeaderFreezeMultipleStructure(grid,structure, true);
					 });
					
				}
     		},
            /**** Export button for children Of Employee ******/
	        'searchresultgrid[itemId=facultyChildSearchResultGrid] button[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
	            click: function() {
	                this.exportReport(SERVERURL.PDFEXPORT,'pdf',false,'CHILDRENEMPLOYEE');
	            }
	        },
	        'searchresultgrid[itemId=facultyChildSearchResultGrid] button[itemId=exportToPdfBtn] #exportPdfAll': {
	            click: function() {
	                this.exportReport(SERVERURL.PDFEXPORT,'pdf',true,'CHILDRENEMPLOYEE');
	            }
	        },
	        'searchresultgrid[itemId=facultyChildSearchResultGrid] button[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'CHILDRENEMPLOYEE');
	            }
	        },
	        'searchresultgrid[itemId=facultyChildSearchResultGrid] button[itemId=exportToPdfBtn] #exportExcelAll': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'CHILDRENEMPLOYEE');
	            }
	        },
	        /**** Export button for extraCurrActivity ******/
	        'searchresultgrid[itemId=facultyExtraCurricularSearchResultGrid] button[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
	            click: function() {
	                this.exportReport(SERVERURL.PDFEXPORT,'pdf',false,'EXTRACURRREPORT');
	            }
	        },
	        'searchresultgrid[itemId=facultyExtraCurricularSearchResultGrid] button[itemId=exportToPdfBtn] #exportPdfAll': {
	            click: function() {
	                this.exportReport(SERVERURL.PDFEXPORT,'pdf',true,'EXTRACURRREPORT');
	            }
	        },
	        'searchresultgrid[itemId=facultyExtraCurricularSearchResultGrid] button[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'EXTRACURRREPORT');
	            }
	        },
	        'searchresultgrid[itemId=facultyExtraCurricularSearchResultGrid] button[itemId=exportToPdfBtn] #exportExcelAll': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'EXTRACURRREPORT');
	            }
	        }
        });
    },
    
    /***
	  * This function is to export pdf and xcel
	  */
	    
  exportReport : function(exportUrl,filetype,whetherAll,requestType) {
	    	var quickSearchForm=null;	
	    	var searchResultGrid= null;
	    	var pagingtoolbaroptions = null;
	    	var reportTitle = null;
	    	var configCode = null;
	    	if(requestType == 'EXTRACURRREPORT'){
	    	 quickSearchForm=this.getFacultyExtraCurricularActivityReportSearchForm();
	    	 searchResultGrid = this.getExtraCurricularSearchResultGrid();	
	    	 pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
	    	 configCode = CONSTANTS.CB.FACULTY_EXTRA_CUR_ACTIVITY_REPORT_BASIC_CONFIGCODE;
	      	var reportTitle=getCommonTranslation('FACULTY_EXTRACURRREPORT');
	    	}
	    	if(requestType == 'CHILDRENEMPLOYEE'){
	    	 quickSearchForm=this.getFacultyChildReportSearchForm();
	    	 searchResultGrid = this.getFacultyChildSearchResultGrid();
	    	 pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
	    	 configCode = CONSTANTS.CB.FACULTY_CHILDREN_REPORT_BASIC_CONFIGCODE;
	      	var reportTitle=getCommonTranslation('FACULTY_CHILDRENEMPLOYEE');
	    	}
	    	var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	    	var jsonFormatFormData=this.createJsonFormat(quickSearchForm,configCode);
	    	var visibleColumns=this.getVisibleColumns(searchResultGrid);
			if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
				jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
			searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
		},
		
		createSearchCriteriaString: function(searchForm) {
	    	var me=this;
	        var formValues = new Array();
	        formValues = searchForm.getValues();        
	        var searchCriteriaString="";
	        for (var key in formValues) {
	        	var value = formValues[key];            
	            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
	                var keyValueJsonObject = me.getJsonObject( key , value);
	    	        searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
	            }
	        }
	        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
	        return searchCriteriaString;
	    },
	    
	    gridRenderFunction:function(grid){
			grid.addButtonToolbar();
	    },
	    
    /**
     * Clear the combo values
     * @params combo
     */
    clearCombo: function(combo) {
        combo.clearValue();
        combo.store.removeAll();
    },
    /**
     * This method is used to clear fields on faculty reports search Form
     * @param button which is reference of button
     */
    resetSearchCriteriaForm: function(form) {
    	
    	var comboToBeResetArray = new Array();
        form.getForm().reset();
        comboToBeResetArray.push(form.down('#batchComboField'));
    	comboToBeResetArray.push(form.down('#courseComboField'));
        
        for(var i= 0; i < comboToBeResetArray.length; i++){
        	if(!isEmpty(comboToBeResetArray[i])){
        		this.clearCombo(comboToBeResetArray[i]);
        	}
        }
    },
    
    /**
     * Method to load the next combo based on the selection of
     * the previous combo value.
     * 
     * @param {Object}
     *            dependentCombo is the reference of the next
     *            dropdown which should be populated with
     *            values.
     * @param {Object}
     *            selectedRecord is the record of the previous
     *            dropdown which is selected.
     * @param {Object}
     *            parameter is the value that should be attached
     *            in the url.
     * @param {Object}
     *            extraParameter (optional) If there is any
     *            extra parameter to be sent for loading the
     *            dependent dropdown.
     * @param {Object}
     *            extraParamValue (optional) The value of the
     *            extraParam that is sent for loading the store.
     */
    loadDependentCombo: function(dependentCombo, comboValue, parameter, extraParameter, extraParamValue) {
    	var this$ = this;
    	this$.resetOtherDropdowns(dependentCombo);
        dependentCombo.clearValue();
        dependentCombo.store.removeAll();
        var store = dependentCombo.getStore();
        var id = comboValue;
        if(!isNullOrEmpty(id)){
        	var url = store.getProxy().proxyConfig.api.read;
            if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
                url = url.concat('?' + parameter + '=' + id);
            } else {
                url = url.concat('?' + parameter + '=' + id);
                url = url.concat('&' + extraParameter + '=' + extraParamValue);
            }
            store.getProxy().api.read = url;
            store.reload();
        }
    },

    /**
     * code to reset other dropdowns based on the selection of
     * any dropdown which is previous in the hierarchy. eg: if
     * all the dropdowns are loaded and the Academy is changed
     * then subsequent dropdowns should be changed accordingly,
     * so their value is cleared and reset and reloaded.
     * 
     * @param: {Object} combo The reference of the dropdown
     *         which is the dependent/next combo.
     */
    resetOtherDropdowns: function(combo) {
        var container = combo.up('form');
        switch (combo.name) {
        case 'academy':
            break;
        case 'location':
            programCombo = container.down('combo[name=programId]');
            this.clearCombo(programCombo);
            batchCombo = container.down('combo[name=batchId]');
            this.clearCombo(batchCombo);
            courseCombo = container.down('combo[name=courseId]');
            this.clearCombo(courseCombo);
            break;
        case 'programId':
            batchCombo = container.down('combo[name=batchId]');
            this.clearCombo(batchCombo);
            courseCombo = container.down('combo[name=courseId]');
            this.clearCombo(courseCombo);
            break;
        case 'batchId':
            courseCombo = container.down('combo[name=courseId]');
            this.clearCombo(courseCombo);
            break;
        case 'courseId':
            break;
        }
    },

    /**
     * This method is used to load faculty child report search result grid according to search criteria
     */
    loadFacultyChildReportsGrid: function() {
        var searchForm = this.getFacultyChildReportSearchForm();
        var configCode = CONSTANTS.CB.FACULTY_CHILDREN_REPORT_BASIC_CONFIGCODE;
        var jsonFormatFormData = this.createJsonFormat(searchForm, configCode);
        var resultGrid = this.getFacultyChildSearchResultGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.FACULTY_CHILDREN_REPORT_VIEWCODE);
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        resultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
        Ext.getBody().unmask();

    },

    /**
     * This method is used to load faculty extra curricular activity report search result grid
     *  according to search criteria
     */
    loadExtraCurricularReportsGrid: function() {
        var searchForm = this.getFacultyExtraCurricularActivityReportSearchForm();
        var configCode = CONSTANTS.CB.FACULTY_EXTRA_CUR_ACTIVITY_REPORT_BASIC_CONFIGCODE;
        var jsonFormatFormData = this.createJsonFormat(searchForm, configCode);
        var resultGrid = this.getExtraCurricularSearchResultGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.FACULTY_EXTRA_CUR_ACTIVITY_REPORT_VIEWCODE);
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        resultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
        Ext.getBody().unmask();
    },

    /**
     * This method is used to create JSON format of form values
     * @param SearchForm
     * @return formated JSON of form Values
     */
    createJsonFormat: function(searchForm, configCode) {

        

        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        if(!isNullOrEmpty(configCode)) {
        	values.configCode = configCode;
        }

        formValues = searchForm.getValues();

        var FACULTY_ID = this.getJsonObject('FACULTY_ID', formValues.FACULTY_ID);
        this.pushJsonObjectInArray(FACULTY_ID, searchcriteria);

        var nameValue = searchForm.down('#selectedName');
        if(!isEmpty(nameValue)){
        	var FIRST_NAME = this.getJsonObject(nameValue.name, nameValue.getValue());
            this.pushJsonObjectInArray(FIRST_NAME, searchcriteria);
        }
        
        var PROGRAM_ID = this.getJsonObject('PROGRAM_ID', formValues.programId);
        this.pushJsonObjectInArray(PROGRAM_ID, searchcriteria);
        
        var BATCH_ID = this.getJsonObject('BATCH_ID', formValues.batchId);
        this.pushJsonObjectInArray(BATCH_ID, searchcriteria);
        
        var COURSE_ID = this.getJsonObject('COURSE_ID', formValues.courseId);
        this.pushJsonObjectInArray(COURSE_ID, searchcriteria);
        
        var SPECIFIC_ACTIVITY = this.getJsonObject('SPECIFIC_ACTIVITY', formValues.SPECIFIC_ACTIVITY);
        this.pushJsonObjectInArray(SPECIFIC_ACTIVITY, searchcriteria);
        
        var RELATIONSHIP = this.getJsonObject('RELATIONSHIP', formValues.RELATIONSHIP);
        this.pushJsonObjectInArray(RELATIONSHIP, searchcriteria);
        
        var academyLocationId = this.getCurrentAcademyLocation();;
    	if(!isNullOrEmpty(academyLocationId)){
    		var ACADEMY_LOCATION_ID = this.getJsonObject('ACADEMY_LOCATION_ID', academyLocationId);
    		this.pushJsonObjectInArray(ACADEMY_LOCATION_ID, searchcriteria);
    	}
        
        values.searchCriterias = searchcriteria;
        return values;
    },

    /**
     * This method is used to crate JSON object
     * @param key 
     * @param value
     * @param additional value
     * @return JSON object
     */
    getJsonObject: function(key, value, additionalValue) {
        if (!isNullOrEmpty(key) && !isNullOrEmpty(value) && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (!isNullOrEmpty(key) && !isNullOrEmpty(value) && !isNullOrEmpty(additionalValue)) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },

    /**
     * This method is used to push JSON object into array & create Object array
     *@param JSON object
     *@param array
     *@return JSON object Array
     */
    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    },

    /**
     * This is used to change name of selected name combo 
     * @param combo which is reference of combo
     */
    changeNameFieldConfig: function(combo) {
        var nameField = combo.up('form').down('#selectedName');
        if (nameField != undefined) {
            nameField.setFieldLabel(combo.getRawValue());
            nameField.name = combo.getValue();
            nameField.emptyText = combo.getRawValue();
            nameField.applyEmptyText();
        }
    }
});
