/**
 * @author Trupti.Paoneker This controller is use to handle functionality for
 *         InactiveUserReport
 */
Ext
		.define(
				'Academia.controller.reports.systemutilization.inactiveusers.InactiveUserReportController',
				{
					extend : 'Academia.controller.base.BaseController',

					stores : [
							'reports.systemutilization.inactiveusers.InactiveUserGroupwiseandMonthwiseSummaryStore',
							'common.AllActiveAcademyLocationStore',
							'common.UserGroupTypeStore',
							'common.AcademyLocationByAcademyId',
							'common.ProgramByAcademyLocationStore',
							'systemusage.YearStore',
							'common.AcademyStore' ],

					views : [
							'Academia.view.criteriabuilder.grid.SearchResultGrid',
							'reports.systemutilization.inactiveusers.InactiveUserReportListView',
							'reports.systemutilization.inactiveusers.InactiveUserReportQuickSearchForm',
							'reports.systemutilization.inactiveusers.InactiveUserReportQuickSearchView',
							'reports.systemutilization.inactiveusers.InactiveUserGroupwiseSummary' ],

					alias : "widget.inactiveuserreportcontroller",
					requires : [ 'Academia.constants.ServiceRequestConstants' ],

					refs : [
							{
								ref : 'contentPanel',
								selector : 'contentpanel'
							},
							{
								ref : 'inactiveUserReportQuickSearch',
								selector : 'inactiveuserreportquicksearchform'
							},
							{
								ref : 'inactiveUserReportResultGrid',
								selector : 'searchresultgrid[itemId=inactiveUserReportResultGrid]'
							}, {
								ref : 'inactiveUserReportListView',
								selector : 'inactiveuserreportlistview'
							} ],
					config : {
						INACTIVE_USER_REPORT_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager
								.getFeaturePrivilegesMap('INACTIVE_USER_REPORT_PRIVILEGES')
					},
					init : function(application) {
						this
								.control({
									'inactiveuserreportquicksearchview inactiveuserreportquicksearchform#inactiveUserReportQuickSearch button#inactiveUserReportListSearchButtonId' : {
										click : this.loadGridAndSearchUsers,
									// render: this.loadGridAndSearchUsers
									},
									'inactiveuserreportquicksearchview inactiveuserreportquicksearchform#inactiveUserReportQuickSearch button[itemId=resetBtn]' : {
										click : this.clearSearchData
									},

									'inactiveuserreportquicksearchview' : {
										render : function(panel, eOpts) {
											var searchPanel = panel
													.down('inactiveuserreportquicksearchform#inactiveUserReportQuickSearch');
											var totalUsageLimit = searchPanel
													.down('textfield#totalUsageLimit');
											totalUsageLimit.allowBlank = true;
											totalUsageLimit.setVisible(false);
										}
									},
									'inactiveuserreportquicksearchview groupedbarchart#inactiveusergroupwiseandmonthwisesummary' : {
										afterrender : function(chart, a) {
											this.addColumListener(chart);
										}
									},
									'inactiveuserreportquicksearchview columnchartreport#groupwisesummaryChart' : {
										afterrender : function(chart, a) {
											this.addGroupColumListener(chart);
										}
									},

									'inactiveuserreportquicksearchview searchresultgrid[itemId=inactiveUserReportResultGrid]' : {
										afterrender : function(grid) {
											var me = this;
						        			var structure = grid.up('inactiveuserreportquicksearchview');
						        			
						        			if (structure.items.items[1].activeTab.title == getCommonTranslation('INACTIVE_USERS')) {
												me.getGridHeaderFreezeForInactiveUser(grid, structure, false);
											}
											
											this.gridRenderFunction(grid);
											this
													.genericCBGridAccessControlValidation(
															grid,
															this
																	.getINACTIVE_USER_REPORT_PERMISSIONS());
											var viewButton = grid
													.down("#searchResultGridBtnView");// itemId
																						// of
																						// split
																						// button
											viewButton.setVisible(false);
										}
									},
									/**
									 * ** Export button for online user report
									 * *****
									 */
									'inactiveuserreportquicksearchview searchresultgrid[itemId=inactiveUserReportResultGrid] button[itemId=exportToPdfBtn] #exportCurrentPagePdf' : {
										click : function() {
											this.exportInactiveUserReport(
													SERVERURL.PDFEXPORT, 'pdf',
													false);
										}
									},
									'inactiveuserreportquicksearchview searchresultgrid[itemId=inactiveUserReportResultGrid] button[itemId=exportToPdfBtn] #exportPdfAll' : {
										click : function() {
											this.exportInactiveUserReport(
													SERVERURL.PDFEXPORT, 'pdf',
													true);
										}
									},
									'inactiveuserreportquicksearchview searchresultgrid[itemId=inactiveUserReportResultGrid] button[itemId=exportToPdfBtn] #exportCurrentExcelPage' : {
										click : function() {
											this.exportInactiveUserReport(
													SERVERURL.EXCELEXPORT,
													'vnd.ms-excel', false);
										}
									},
									'inactiveuserreportquicksearchview searchresultgrid[itemId=inactiveUserReportResultGrid] button[itemId=exportToPdfBtn] #exportExcelAll' : {
										click : function() {
											this.exportInactiveUserReport(
													SERVERURL.EXCELEXPORT,
													'vnd.ms-excel', true);
										}
									}
								});

					},
					/***********************************************************
					 * This function is to export pdf and xcel
					 */

					exportInactiveUserReport : function(exportUrl, filetype,
							whetherAll, requestType) {
						var quickSearchForm = this
								.getInactiveUserReportQuickSearch();
						var searchResultGrid = this
								.getInactiveUserReportResultGrid();
						var pagingtoolbaroptions = this
								.getInactiveUserReportResultGrid().down(
										'pagingtoolbar').getStore().lastOptions;
                        var reportTitle=getCommonTranslation('INACTIVE_USER_REPORT');
						var searchCriteriaString = this
								.createSearchCriteriaString(quickSearchForm);
						var jsonFormatFormData = this
								.createJsonFormat(quickSearchForm);
						var visibleColumns = this
								.getVisibleColumns(searchResultGrid);
						if (!isEmpty(searchResultGrid.store
								.getCurrentSortCriteria())
								&& searchResultGrid.store
										.getCurrentSortCriteria() != undefined
								&& searchResultGrid.store
										.getCurrentSortCriteria() != null)
							jsonFormatFormData.sortCriterias = searchResultGrid.store
									.getCurrentSortCriteria();
						searchResultGrid.exportData(exportUrl, filetype,
								jsonFormatFormData, pagingtoolbaroptions,
								whetherAll, searchCriteriaString,
								visibleColumns, reportTitle);
					},

					createSearchCriteriaString : function(searchForm) {
						var me = this;
						var formValues = new Array();
						formValues = searchForm.getValues();
						var searchCriteriaString = "";
						for ( var key in formValues) {
							var value = formValues[key];
							if (!isNullOrEmpty(value) && value !== 'All'
									&& key !== 'selectedNameField') {
								var keyValueJsonObject = me.getJsonObject(key,
										value);
								if (keyValueJsonObject !== undefined) {
									searchCriteriaString = searchCriteriaString
											+ keyValueJsonObject.paramCode
											+ "  : "
											+ searchForm.getForm().findField(
													key).getRawValue() + " ,";
								}
							}
						}
						searchCriteriaString = searchCriteriaString.substring(
								0, searchCriteriaString.length - 1);
						return searchCriteriaString;
					},

					gridRenderFunction : function(grid) {
						grid.addButtonToolbar();
					},

					addColumListener : function(chart) {
						var this$ = this;
						chart.series.items[0].listeners = {
							itemclick : function(item, a) {
								this$.barClickUserFrequencyModule(this, item);
							}
						};
					},

					barClickUserFrequencyModule : function(this$, item) {
						var month = item.storeItem.get('MONTH'), quickSearchForm = this
								.getInactiveUserReportQuickSearch();
						var date = Ext.Date.parse(month, 'F-Y');
						var firstDay = new Date(date.getFullYear(), date
								.getMonth(), 1);
						var lastDay = new Date(date.getFullYear(), date
								.getMonth() + 1, 0);
						var USER_GROUP_NAME = this
								.getUserGroupName(item.yField);
						quickSearchForm.getForm().setValues({
							'fromDate' : firstDay,
							'toDate' : lastDay,
							'USER_GROUP_NAME' : USER_GROUP_NAME
						});
						quickSearchForm.nextSibling().setActiveTab(0);
						this
								.loadGridAndSearchUsers(null, null,
										quickSearchForm);
					},

					addGroupColumListener : function(chart) {
						var this$ = this;
						chart.series.items[0].listeners = {
							itemclick : function(item, a) {
								this$.barClickUserGroup(this, item);
							}
						};
					},

					barClickUserGroup : function(this$, item) {
						var USER_GROUP_NAME = this
								.getUserGroupName(item.storeItem
										.get('USER_GRP_NAME')), quickSearchForm = this
								.getInactiveUserReportQuickSearch();
						quickSearchForm.getForm().setValues({
							'USER_GROUP_NAME' : USER_GROUP_NAME
						});
						quickSearchForm.nextSibling().setActiveTab(0);
						this
								.loadGridAndSearchUsers(null, null,
										quickSearchForm);
					},

					getUserGroupName : function(key) {
						var USER_GROUP_NAME = false;
						switch (key) {
						case 'Admin':
							USER_GROUP_NAME = 'ADMIN';
							break;
						case 'Faculty':
							USER_GROUP_NAME = 'FACULTY';
							break;
						case 'Student':
							USER_GROUP_NAME = 'STUDENT';
							break;
						}
						return USER_GROUP_NAME;
					},

					loadGridAndSearchUsers : function(button, records,
							masterForm) {

						if (!masterForm)
							masterForm = button
									.up('#inactiveUserReportQuickSearch');
						var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
						var basicSearchUrl = SERVERURL.EXECUTEBASICSEARCH;
						var jsonFormatFormData = this.createJsonFormat(
								masterForm, records);

						var activeTab = masterForm.up(
								'inactiveuserreportquicksearchview').down(
								'tabpanel').getActiveTab();
						if (activeTab.itemId == 'inactiveUserReportResultGridTab') {

							jsonFormatFormData.viewCode = CONSTANTS.CB.INACTIVE_USER_REPORT_VIEWCODE;
							resultViewUrl = resultViewUrl
									.concat(CONSTANTS.CB.INACTIVE_USER_REPORT_VIEWCODE);
							activeTab.down('grid').initialize(basicSearchUrl, resultViewUrl,
									jsonFormatFormData);

						} else if (activeTab.itemId == 'inactiveusergroupwiseandmonthwisesummary') {

							jsonFormatFormData.viewCode = CONSTANTS.CB.INACTIVE_USERS_GRAPH_GRP_MONTH_VIEWCODE;
							var store = activeTab.down('groupedbarchart').getStore();
							// var store =
							// this.getStore('reports.systemutilization.inactiveusers.InactiveUserByUsageMonthwiseSummaryStore');
							this.loadGroupWiseSummChart(basicSearchUrl
									+ '?page=-1&limit=-1', jsonFormatFormData,
									store, activeTab);

						} else if (activeTab.itemId == 'inactiveusergroupwisesummary') {
							jsonFormatFormData.viewCode = CONSTANTS.CB.INACTIVE_USERS_GRAPH_USERGRPWISE_VIEWCODE;
							var store = activeTab
									.down('#groupwisesummaryChart').getStore();
							this.loadChartData(basicSearchUrl
									+ '?page=-1&limit=-1', jsonFormatFormData,
									store);
						}

					},
					loadChartData : function(viewUrl, jsonFormatFormData, store) {
						Ext.Ajax.request({
							type : 'rest',
							url : viewUrl,
							method : 'POST',
							headers : {
								'Content-Type' : 'application/json'
							},
							jsonData : jsonFormatFormData,
							success : function(response) {
								data = Ext.decode(response.responseText);
								store.loadData(data.rows);
							}
						});
					},
					loadCombo : function(combo) {
						var store = combo.getStore();
						store.load();

					},
					createJsonFormat : function(MasterForm) {
						var me = this;
						var formValues = new Array();
						var values = new Object();
						var searchcriteria = new Array();

						values.configCode = CONSTANTS.CB.INACTIVE_USER_REPORT_BASIC_CONFIGCODE;
						values.viewCode = CONSTANTS.CB.INACTIVE_USER_REPORT_VIEWCODE;
						formValues = MasterForm.getValues();

						if (formValues.USER_GROUP_NAME != false) {
							var serviceRequestConstants = this
									.getServiceRequestConstant();
							var userGroupStudentId = serviceRequestConstants
									.getRequestStatus('USER_GROUP_'
											+ formValues.USER_GROUP_NAME
											+ '_ID');
							formValues.USER_GROUP_ID = userGroupStudentId;
						}
						delete formValues.USER_GROUP_NAME;
						var REQUEST_DATE = this.getJsonObject('REQUEST_DATE',
								formValues.fromDate, formValues.toDate);
						this
								.pushJsonObjectInArray(REQUEST_DATE,
										searchcriteria);

						delete formValues.fromDate;
						delete formValues.toDate;

						for ( var key in formValues) {
							var value = formValues[key];
							if (!isNullOrEmpty(value) && value !== 'All'
									&& key !== 'selectedNameField') {
								var keyValueJsonObject = me.getJsonObject(key,
										value);
								me.pushJsonObjectInArray(keyValueJsonObject,
										searchcriteria);
							}
						}

						values.searchCriterias = searchcriteria;
						return values;
					},
					getJsonObject : function(key, value, additionalValue) {
						if (value != '' && additionalValue == undefined) {
							return {
								"paramCode" : key,
								"paramValues" : [ value ]
							};
						} else if (value != '' && additionalValue != undefined) {
							return {
								"paramCode" : key,
								"paramValues" : [ value, additionalValue ]
							};
						}
					},
					pushJsonObjectInArray : function(object, array) {
						if (object) {
							array.push(object);
						}
					},
					/**
					 * load loadGroupWiseSummChart graph
					 */
					loadGroupWiseSummChart : function(viewUrl,jsonFormatFormData, store, activeTab) {
						var this$ = this;
						console.log('activeTaCb', activeTab);
//						
						// activeTab.redraw(true);
						// console.log('activeTab
						// itemId',activeTab.down('#inactiveusergroupwiseandmonthwisesummary'));
						Ext.Ajax.request({
							type : 'rest',
							url : viewUrl,
							method : 'POST',
							headers : {
								'Content-Type' : 'application/json'
							},
							jsonData : jsonFormatFormData,
							success : function(response) {
								data = Ext.decode(response.responseText);
								data = this$.convertJson(data.rows);
								 store.loadData(data.getValues());
//								 console.log('activeTab',activeTab);
								 //activeTab.setWidth('100%');
								 /* store.loadData([ { "Faculty": "1", "MONTH":
								  "November-2015" }, { "Student": "2",
								  "Faculty": "1", "MONTH": "September-2015",
								  "Admin": "1" }, { "Student": "5", "Faculty":
								  "3", "MONTH": "October-2015", "Admin": "3" }, {
								  "Student": "1", "Faculty": "1", "MONTH":
								  "December-2015", "Admin": "3" }, { "Student":
								  "1", "Faculty": "2", "MONTH": "August-2015",
								  "Admin": "8" }, { "Faculty": "1", "MONTH":
								  "November-2014" }, { "Student": "2",
								  "Faculty": "1", "MONTH": "September-2014",
								  "Admin": "1" }, { "Student": "5", "Faculty":
								  "3", "MONTH": "October-2014", "Admin": "3" }, {
								  "Student": "1", "Faculty": "1", "MONTH":
								  "December-2014", "Admin": "3" }, { "Student":
								  "1", "Faculty": "2", "MONTH": "August-2014",
								  "Admin": "8" }
								  ]);*/
								 

							}
						});
					},

					convertJson : function(jsonObject) {
						var map = new Ext.util.HashMap();

						Ext.each(jsonObject, function(object) {
							var key = object.USER_LOGIN_MONTH;
							var value = map.get(object.USER_LOGIN_MONTH);
							if (!value) {
								value = {};
								value['MONTH'] = key;
							}
							value[object.USER_GRP_NAME] = object.noOfUsers;
							map.add(key, value);
						});
						return map;
					},

					/**
					 * Create dashboard search criteria json
					 * 
					 * @params searchCriteriaForm
					 * @params configCode
					 */
					createSeachCriteriaDashboardJsonFormat : function(
							searchCriteriaForm, configCode) {
						var me = this;
						var values = new Object();
						var searchcriteria = new Array();
						var formValues = new Array();
						formValues = searchCriteriaForm.getValues();
						if (!isNullOrEmpty(configCode)) {
							values.configCode = configCode;
						}

						var notLoggedInSince = formValues["NOT_LOGGED_IN_SINCE_DAYS"];
						if (!isNullOrEmpty(requestSubCategory)) {
							var keyValueJsonObject = me.getJsonObject(
									'NOT_LOGGED_IN_SINCE_DAYS_GRAPH',
									notLoggedInSince);
							me.pushJsonObjectInArray(keyValueJsonObject,
									searchcriteria);
						}

						var userGroupName = formValues["USER_GROUP_NAME"];
						if (!isNullOrEmpty(certificateSubCategory)) {
							var keyValueJsonObject = me.getJsonObject(
									'USER_GRP_NAME', userGroupName);
							me.pushJsonObjectInArray(keyValueJsonObject,
									searchcriteria);
						}
						values.searchCriterias = searchcriteria;

						return values;
					},

					clearSearchData : function(button) {

						button.up('form').getForm().reset();
						var masterForm = button
								.up('#inactiveUserReportQuickSearch');

						var InactiveByUsageGrid = masterForm.up(
								'inactiveuserreportquicksearchview').down(
								'#inactiveUserReportResultGrid');
						var inactiveusergroupwiseandmonthwisesummary = masterForm
								.up('inactiveuserreportquicksearchview')
								.down(
										'#inactiveusergroupwiseandmonthwisesummary');
						var inactiveusergroupwisesummary = masterForm.up(
								'inactiveuserreportquicksearchview').down(
								'#groupwisesummaryChart');

						InactiveByUsageGrid.getStore().removeAll();
						inactiveusergroupwiseandmonthwisesummary.getStore()
								.removeAll();
						inactiveusergroupwisesummary.getStore().removeAll();
					},
					/**
					 * This method is use to get the reference to the service
					 * request constants file
					 */
					getServiceRequestConstant : function() {
						var serviceRequestConstant = Academia.constants.ServiceRequestConstants;
						return serviceRequestConstant;
					}

				});