Ext.define('Academia.controller.reports.systemutilization.loginFrequency.LoginFrequencyController', {
    extend: 'Academia.controller.base.BaseController',

    stores: ['reports.systemutilization.loginFrequency.LoginFrequencyGridStore','systemusage.Modules','criteriabuilder.userquicksearch.QuickSearchCode',
           'systemusage.SubMdules', 'systemusage.UserNames','systemusage.UsersNameStore','systemusage.UserGroupStore' ],

    views: ['reports.systemutilization.loginFrequency.LoginFrequencyGrid', 
            'reports.systemutilization.loginFrequency.UserLoginFrequency',
            'reports.systemutilization.loginFrequency.LoginFrequencySearchForm',
            'reports.systemutilization.loginFrequency.ModuleUsageGrid'],
            refs: [{
            	ref: 'loginfrequencygrid',
            	selector: 'loginfrequencygrid'
            },{
            	ref: 'moduleusagegrid',
            	selector: 'moduleusagegrid'
            }],

    config: {
    	INACTIVE_USER_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('INACTIVE_USER_REPORT_PRIVILEGES')
    },
    init: function(application) {
        this.control({
    		//V2D-359081        	
        	'loginfrequencygrid' : {
                afterrender : this.headerFixForLF
            },
            
            'userloginfrequency tabpanel[itemId=userloginfrequencyInnerTabPanel]':{
            	tabchange:function(tabPanel, newCard, oldCard, eOpts){
            		var structure = tabPanel.up('userloginfrequency');
            		structure.scrollBy(0,1);
            		structure.scrollBy(0,-1);
	 			  }
            },
            
            'moduleusagegrid' : {
                afterrender : this.headerFixForLF
            },
        	//end
            'userloginfrequency loginfrequencysearchform#loginfrequencysearchform button#searchBtn': {
            	 /*render:function(cmp){
            		 this.loadActiveGrid(cmp);
          	 	 }*/
                 click:function(cmp){
            		 this.loadActiveGrid(cmp);
          	 	 }
            },
            'userloginfrequency loginfrequencysearchform#loginfrequencysearchform button#clearBtn': {
                click:function(cmp){
                	var form = cmp.up('loginfrequencysearchform');
                	form.getForm().reset();
                	this.showCombo(cmp,false,false,form);
                	 var userCombo = form.down('#frequency_user_id');
                	var contentPanel = Ext.ComponentQuery.query('contentPanel');
                    if (contentPanel.length == 1) {
                        var x = contentPanel[0].getActiveTab();
                        if (x.getXType() == 'userloginfrequency') {
                            var a = userCombo.el.down('[name=userIds]');
                            if (a != null) {
                                a.setHeight('auto');
                            }
                            userCombo.el.dom.style.height = 'auto';
                            userCombo.up('form').doLayout();
                        }
                    }
                	
                }
           },
            'loginfrequencysearchform fieldcontainer#radioPanelUsers radiofield[itemId=allRadioBtn]':{
          	 	 focus: function(cmp){
          	 		 this.showCombo(cmp,false,false);
          	 	 }
	         }, 
	         'loginfrequencysearchform combo[itemId=frequency_user_name]':{
	           	 focus: this.loadUserNamesCombo
	         },
	         'loginfrequencysearchform fieldcontainer#radioPanelUsers radiofield[itemId=individualRadioBtn]':{
          	 	 focus: function(cmp){
          	 		 this.showCombo(cmp,true,false);
          	 	 }
	         },
	         'loginfrequencysearchform fieldcontainer#radioPanelUsers radiofield[itemId=userGroupRadioBtn]':{
          	 	 focus: function(cmp){
          	 		 this.showCombo(cmp,false,true);
          	 	 }
	         },
            
	            'userloginfrequency loginfrequencygrid': {
	            	cellclick: function( grid, td, cellIndex) {
	        			var loginfrequencygrid = grid.up('grid');
	        			var columnName = loginfrequencygrid.columnManager.columns[cellIndex].dataIndex;
	        			if(columnName == 'count') {
	        				this.loginFrequencyGridCellClick(loginfrequencygrid)
	        			}
	        		}
	            },
	            /*
	            'userloginfrequency customcombobox[itemId=frequency_user_id]': {
	                select: function(combo, record) {
	                    var searchForm = this.getUrpfilter();
	                    var userCombo = searchForm.down('#frequency_user_id');
	                    var store = userCombo.getStore();
	                    var featureId = combo.getValue();
	                    store.getProxy().extraParams = {
	                        featureId: featureId
	                    };
	                    userCombo.setDisabled(false);
	                    userCombo.reset();
	                    store.load();
	                    var contentPanel = Ext.ComponentQuery.query('contentPanel');
	                    if (contentPanel.length == 1) {
	                        var x = contentPanel[0].getActiveTab();
	                        if (x.getXType() == 'userloginfrequency') {
	                            var a = userCombo.el.down('[name=userIds]');
	                            if (a != null) {
	                                a.setHeight('auto');
	                            }
	                            userCombo.el.dom.style.height = 'auto';
	                            userCombo.up('form').doLayout();
	                        }
	                    }
	                }
	            },
            */
	        /**** Export button for online user report ******/
//	        'inactiveuserreportquicksearchview searchresultgrid[itemId=inactiveUserReportResultGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
//	            click: function() {
//	                this.exportInactiveUserReport(SERVERURL.PDFEXPORT,'pdf',false);
//	            }
//	        },
//	        'inactiveuserreportquicksearchview searchresultgrid[itemId=inactiveUserReportResultGrid] splitbutton[itemId=exportToPdfBtn] #exportPdfAll': {
//	            click: function() {
//	                this.exportInactiveUserReport(SERVERURL.PDFEXPORT,'pdf',true);
//	            }
//	        },
//	        'inactiveuserreportquicksearchview searchresultgrid[itemId=inactiveUserReportResultGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
//	            click: function() {
//	                this.exportInactiveUserReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
//	            }
//	        },
//	        'inactiveuserreportquicksearchview searchresultgrid[itemId=inactiveUserReportResultGrid] splitbutton[itemId=exportToPdfBtn] #exportExcelAll': {
//	            click: function() {
//	                this.exportInactiveUserReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
//	            }
//	        }
        });

    },
    
    headerFixForLF: function(grid){
    	 var me = this;
         var structure = grid.up('userloginfrequency');

         me.getGridHeaderFreezeForCompletion(grid, structure, true);
    },
    
    /***
	  * This function is to export pdf and xcel
	  */
    exportInactiveUserReport : function(exportUrl,filetype,whetherAll,requestType) {
	   	 var quickSearchForm=this.getInactiveUserReportQuickSearch();
	   	 var searchResultGrid = this.getInactiveUserReportResultGrid();	
	   	 var pagingtoolbaroptions = this.getInactiveUserReportResultGrid().down('pagingtoolbar').getStore().lastOptions;
         var reportTitle=getCommonTranslation('INACTIVE_USER_REPORT');
	   	var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	   	var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
	   	var visibleColumns=this.getVisibleColumns(searchResultGrid);
			if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
				jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
			searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
		},
		
		createSearchCriteriaString: function(searchForm) {
	   	var me=this;
	       var formValues = new Array();
	       formValues = searchForm.getValues();        
	       var searchCriteriaString="";
	       for (var key in formValues) {
	       	var value = formValues[key];            
	           if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
	               var keyValueJsonObject = me.getJsonObject( key , value);
	               if(keyValueJsonObject !== undefined){
	   	        searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
	               }
	           }
	       }
	       searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
	       return searchCriteriaString;
	   },
	   
	   gridRenderFunction:function(grid){
			grid.addButtonToolbar();
	   },
	   
	   loadActiveGrid : function(button,loginfrequencysearchform) {
		   if(!loginfrequencysearchform)
		   		loginfrequencysearchform=button.up('loginfrequencysearchform');
		   var tabPanel = loginfrequencysearchform.up('userloginfrequency').down('tabpanel');
		   var activeTab=tabPanel.getActiveTab(), jsonFormatFormData=loginfrequencysearchform.getValues();
	     	
		   delete jsonFormatFormData.usrRadio;
		   this.deleteEmptyFields(jsonFormatFormData);
	       if(activeTab.itemId== 'loginfrequencygrid' ){
	        	var store=activeTab.down('grid').getStore();
	        	store.getProxy().extraParams=jsonFormatFormData;
	        	store.reload();
	       }else   if(activeTab.itemId=='moduleusagegrid'){
	        	var store=activeTab.down('grid').getStore();
	        	store.getProxy().extraParams=jsonFormatFormData;
	        	store.reload();
        	}
	       
	       if(jsonFormatFormData.periodType){
	    	   activeTab.down('grid').columns[2].setVisible(true);
	       }else{
	    	   activeTab.down('grid').columns[2].setVisible(false);	    	   
	       }
	       activeTab.doLayout();
	   },
	   
	   loadGridAndSearchUsers: function(button, records,masterForm) {
		   var loginfrequencysearchform=button.up('loginfrequencysearchform');
		   var tabpanel = loginfrequencysearchform.up('userloginfrequency').down('tabpanel');
		   var activeTab=tabpanel.getActiveTab(), jsonFormatFormData=loginfrequencysearchform.getValues();
	     	
		   delete jsonFormatFormData.usrRadio;
		   this.deleteEmptyFields(jsonFormatFormData);
	        if(activeTab.itemId== 'loginfrequencygrid' ){
	        	var store=activeTab.getStore();
	        	store.getProxy().extraParams=jsonFormatFormData;
	        	store.reload();
		        	
	        }
	        
	    },
	    
	    loginFrequencyGridCellClick: function(grid) {
			var selectedRecord = grid.getSelectionModel().getSelection()[0];
			var userId = selectedRecord.get('userId');
			if(!isNullOrEmpty(userId)) {
				  var loginfrequencysearchform=grid.up('userloginfrequency').down('loginfrequencysearchform');
				  loginfrequencysearchform.getForm().setValues({'usrRadio':'individual'});
				  this.showCombo(null,true,false,loginfrequencysearchform);
				  var userIds= [userId];
				  loginfrequencysearchform.down('#frequency_user_id').setValue(userIds);
				  grid.up('tabpanel').setActiveTab(1);
				  this.loadActiveGrid(null,loginfrequencysearchform);
			}
	    },
	    
	    showCombo : function(cmp,whetherUserType,whetherUserGroup,form){
	    	if(!form)
	    		form = cmp.up('form');
	    	var userTypeFieldContainer = form.down('#userTypeIndividualFieldContainer');
	    	var userIdCmb = userTypeFieldContainer.down('#frequency_user_id');
	    	var userNameCmb = userTypeFieldContainer.down('#frequency_user_name');
	    	
	    	var userGroupFieldContainer = form.down('#userGroupFieldContainer');
	        var userGroup = userGroupFieldContainer.down('#frequency_user_group');
	        
			userTypeFieldContainer.setDisabled(!whetherUserType);
			userTypeFieldContainer.setVisible(whetherUserType);

			userGroupFieldContainer.setDisabled(!whetherUserGroup);
			userGroupFieldContainer.setVisible(whetherUserGroup);
			
//			userIdCmb.clearValue();
//			userNameCmb.clearValue();
			userGroup.clearValue();
	    },
	    /**
	     * This is used to load user name combo on select of user code
	     */
	    loadUserNamesCombo : function(combo){
	   	 
	   	var userIdCombo = combo.up('form').down('#frequency_user_id');
	   	var store = combo.getStore();
	  	 	var userCodes = userIdCombo.getRawValue();
	  	 	userCodes = userCodes.replace(/[ ,]+/g, ",");
	  		/*var userCodes = new Array();
	  		if(value){
	  			Ext.each(value, function(values) {
	  				if(values instanceof Object){
	  					userCodes.push(values.get('code'));
	  				}else{
	  					userCodes.push(values);
	  				}
	  		});
	  		userCodes =userCodes.toString();*/
	  		store.load({
	  			params: {
	  				userCodes: userCodes
	  			}
	  		});
//	  		}
	    }

});
