/**
 * This controller is used for the User Role And Privilege Report.
 * 
 * @author Ankur Jaiswal
 */
Ext.define('Academia.controller.reports.userroleprivilege.UserRolePrivilegeController', {
    extend: 'Academia.controller.base.BaseController',
    views: ['reports.userroleprivilege.URPStructure',
        'reports.userroleprivilege.URPTabStructure',
        'reports.userroleprivilege.URPFilter',
        'reports.userroleprivilege.URPGrid',
        'reports.userroleprivilege.NoOfRolesWin',
        'reports.userroleprivilege.NoOfRolesGrid',
        'reports.userroleprivilege.NoOfUsersWin',
        'reports.userroleprivilege.NoOfUsersGrid',
        'reports.userroleprivilege.URPUserFilter',
        'reports.userroleprivilege.URPUserTabStructure',
        'reports.userroleprivilege.URPUserGrid'
    ],
    stores: ['reports.userroleprivilege.URPPortalStore',
        'reports.userroleprivilege.URPModuleStore',
        'reports.userroleprivilege.URPPrivilegeStore',
        'reports.userroleprivilege.URPFeatureStore',
        'reports.userroleprivilege.URPStore',
        'reports.userroleprivilege.NoOfRolesStore',
        'reports.userroleprivilege.NoOfUsersStore',
        'facilitiesresources.resourcebooking.AcademyLocationListByUserStore',
        'reports.userroleprivilege.URPUserStore'
    ],
    models : [ ], 
    refs: [{
        ref: 'urpfilter',
        selector: 'urpfilter'
    }, {
        ref: 'urpsearchpanel',
        selector: 'urpsearchpanel'
    }, {
        ref: 'urpgrid',
        selector: 'urpgrid'
    }, {
        ref: 'noofroleswin',
        selector: 'noofroleswin'
    }, {
        ref: 'noofrolesgrid',
        selector: 'noofrolesgrid'
    }, {
        ref: 'noofuserswin',
        selector: 'noofuserswin'
    }, {
        ref: 'noofusersgrid',
        selector: 'noofusersgrid'
    },{
        ref: 'urpstructure',
        selector: 'urpstructure'
    },{
        ref: 'urpuserfilter',
        selector: 'urpuserfilter'
    },{
        ref: 'urpusergrid',
        selector: 'urpusergrid'
    },{
        ref: 'urpusertabstructure',
        selector: 'urpusertabstructure'
    }],
    config: {
    	USER_ROLES_AND_PRIVILEGE_REPORTS_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('USER_ROLES_AND_PRIVILEGE_REPORTS_PRIVILEGES'),
    	USER_ROLES_AND_PRIVILEGE_REPORTS_USERS_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('USER_ROLES_AND_PRIVILEGE_REPORTS_USERS_PRIVILEGES'),
    },
    init: function(application) {
    	this.control({ 
    		'urpfilter': {
    			render: function(structure) {
    				var searchForm = this.getUrpfilter();
    				searchForm.down('#portalItemId').getStore().load();
    			}
            },
            'urpfilter customcombobox[itemId=portalItemId]': {
            	render: function(combo) {
            		var searchForm = this.getUrpfilter();
            		var store = searchForm.down('#portalItemId').getStore();
            		store.on('load', function(){
            			for(var i=0; i< store.data.items.length;i++){
            				if(store.data.items[i].data.id !=1 && store.data.items[i].data.id !=2 && store.data.items[i].data.id !=3 && store.data.items[i].data.id !=7){
            					store.removeAt(i);
            					i--;
            				}
            			}
                   	});
    			},
                select: function() {
                    var searchForm = this.getUrpfilter()
                    var moduleCombo = searchForm.down('#moduleItemId');
                    var featureCombo = searchForm.down('#featureItemId');
                    var privilegeCombo = searchForm.down('#privilegeItemId');
                    var moduleStore = moduleCombo.getStore();
                    var portalId = searchForm.down('#portalItemId').getValue();
                    moduleStore.getProxy().extraParams = {
                        portalId: portalId
                    };
                    featureCombo.reset();
                    featureCombo.setDisabled(true);
                    privilegeCombo.reset();
                    privilegeCombo.setDisabled(true);
                    moduleCombo.reset();
                    moduleStore.load();
                    moduleCombo.setDisabled(false);
                    var contentPanel = Ext.ComponentQuery.query('contentPanel');
                    if (contentPanel.length == 1) {
                        var x = contentPanel[0].getActiveTab();
                        if (x.getXType() == 'urpstructure') {
                            var a = privilegeCombo.el.down('[name=privilegeId]');
                            if (a != null) {
                                a.setHeight('auto');
                            }
                            privilegeCombo.el.dom.style.height = 'auto';
                            privilegeCombo.up('form').doLayout();
                        }
                    }
                }
            },
            'urpfilter customcombobox[itemId=moduleItemId]': {
                select: function(combo, record) {
                    var searchForm = this.getUrpfilter();
                    var featureCombo = searchForm.down('#featureItemId');
                    var privilegeCombo = searchForm.down('#privilegeItemId');
                    var store = featureCombo.getStore();
                    var moduleId = combo.getValue();
                    store.getProxy().extraParams = {
                        moduleId: moduleId
                    };
                    privilegeCombo.reset();
                    privilegeCombo.setDisabled(true);
                    featureCombo.reset();
                    featureCombo.setDisabled(false);
                    store.load();
                    var contentPanel = Ext.ComponentQuery.query('contentPanel');
                    if (contentPanel.length == 1) {
                        var x = contentPanel[0].getActiveTab();
                        if (x.getXType() == 'urpstructure') {
                            var a = privilegeCombo.el.down('[name=privilegeId]');
                            if (a != null) {
                                a.setHeight('auto');
                            }
                            privilegeCombo.el.dom.style.height = 'auto';
                            privilegeCombo.up('form').doLayout();
                        }
                    }
                }
            },
            'urpfilter customcombobox[itemId=featureItemId]': {
                select: function(combo, record) {
                    var searchForm = this.getUrpfilter();
                    var privilegeCombo = searchForm.down('#privilegeItemId');
                    var store = privilegeCombo.getStore();
                    var featureId = combo.getValue();
                    store.getProxy().extraParams = {
                        featureId: featureId
                    };
                    privilegeCombo.setDisabled(false);
                    privilegeCombo.reset();
                    store.load({
            			
                        callback:function(rec,operation,success){
                        	var contentPanel = Ext.ComponentQuery.query('contentPanel');
                            if (contentPanel.length == 1) {
                                var x = contentPanel[0].getActiveTab();
                                if (x.getXType() == 'urpstructure') {
                                    var a = privilegeCombo.el.down('[name=privilegeId]');
                                    if (a != null) {
                                        a.setHeight('auto');
                                    }
                                    privilegeCombo.el.dom.style.height = 'auto';
                                    privilegeCombo.up('form').doLayout();
                                }
                            }
                        }
                    });
                    
                }
            },
            'urpfilter button[itemId=resetURPFilterItemId]': {
                click: function() {
                    var filter = this.getUrpfilter();
                    var moduleCombo = filter.down('#moduleItemId');
                    var featureCombo = filter.down('#featureItemId');
                    var privilegeCombo = filter.down('#privilegeItemId');
                    moduleCombo.setDisabled(true);
                    featureCombo.setDisabled(true);
                    privilegeCombo.setDisabled(true);
                    filter.getForm().reset();
                    var a = privilegeCombo.el.down('[name=privilegeId]');
                    if (a != null) {
                        a.setHeight('auto');
                    }
                    privilegeCombo.el.dom.style.height = 'auto';
                    privilegeCombo.up('form').doLayout();
                }
            },
            'urpfilter button[itemId=searchURPFilterItemId]': {
                click: function() {
                    this.loadURPGrid();
                }
            },
            'urpgrid': {
            	beforerender: function() {
    				this.getStore('reports.userroleprivilege.URPStore').removeAll();
    			},
    			render: function(grid) {
    				this.doAccessControlValidation(grid, this.getUSER_ROLES_AND_PRIVILEGE_REPORTS_PRIVILEGES());
    			},
                cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var urpgrid = this.getUrpgrid();
                    var columnName = urpgrid.columnManager.columns[cellIndex].dataIndex;

                    if (columnName == 'rolesCount') {
                        if (e.target.tagName == 'A') {
                            this.openListOfRolesWin(grid, rowIndex, record);
                        }
                    }
                    if (columnName == 'usersCount') {
                        if (e.target.tagName == 'A') {
                            this.openURPUserTabStructure(record);
                        }
                    }
                }
            },
            'urpusergrid': {
            	beforerender: function() {
    				this.getStore('reports.userroleprivilege.URPUserStore').removeAll();
    			},
                render: function(grid) {
                this.loadURPUserGrid();
                this.doAccessControlValidation(grid, this.getUSER_ROLES_AND_PRIVILEGE_REPORTS_USERS_PRIVILEGES());
                }
            },
            'urpuserfilter button[itemId=searchURPUserFilterItemId]': {
                click: function() {
                    this.loadURPUserGrid();
                }
            },
            'urpuserfilter button[itemId=resetURPUserFilterItemId]': {
                click: function() {
                    var urpUserFilter = this.getUrpuserfilter();
                    var alCombo = urpUserFilter.down('#alItemId');
                    alCombo.reset();
                    var contentPanel = Ext.ComponentQuery.query('contentPanel');
                    if (contentPanel.length == 1) {
                        var x = contentPanel[0].getActiveTab();
                        if (x.getXType() == 'urpstructure') {
                            var a = alCombo.el.down('[name=alId]');
                            if (a != null) {
                                a.setHeight('auto');
                            }
                            alCombo.el.dom.style.height = 'auto';
                            alCombo.up('form').doLayout();
                        }
                    }
                }
            }
        });
    },
    loadURPGrid: function() {
        var $this = this;
        var filter = this.getUrpfilter();
        var portalCombo = filter.down('#portalItemId');
        var moduleCombo = filter.down('#moduleItemId');
        var featureCombo = filter.down('#featureItemId');
        var privilegeCombo = filter.down('#privilegeItemId');
        var portalId = portalCombo.getValue();
        var moduleId = moduleCombo.getValue();
        var featureId = featureCombo.getValue();
        var privilegeId = privilegeCombo.getValue();
        var plIds = [];
        var privilegeIds = null;

        if (!isNullOrEmpty(privilegeId) && privilegeId.length > 0) {
            for (var i in privilegeId) {
                if (Ext.isObject(privilegeId[0])) {
                    plIds.push(privilegeId[i].get("id"));
                } else {
                    plIds.push(privilegeId[i]);
                }
            }
            privilegeIds = plIds.join();
        }
        var urpGrid = $this.getUrpgrid();
        var store = urpGrid.getStore();
        store.getProxy().extraParams = {
            moduleId: moduleId,
            featureId: featureId,
            privilegeIds: privilegeIds
        };
        store.load();
    },
	/**
	 *  openListOfRolesWin is using when click on No. of Roles column cell of URP Grid
	 */
    openListOfRolesWin:function(grid, rowIndex, record){
   	 var $this = this;
   	 var formWindow = $this.getNoofroleswin();
   	 if (!formWindow) {
   		 Ext.widget('noofroleswin');
   		 formWindow = $this.getNoofroleswin();
   	 }
   	 formWindow.show();
   	 
   	   var form = $this.getNoofroleswin();
    	 if(!isNullOrEmpty(record.data.portal)){
    		// var hostelCodeName =   record.data.hostelCode + '/' + record.data.hostelName;
    		 form.down('#portalItemId').setValue(record.data.portal.value);
    	 }
    	 if(!isNullOrEmpty(record.data.module)){
    		 var module =   record.data.module;
    		 form.down('#moduleItemId').setValue(module.value);
    	 }
    	 if(!isNullOrEmpty(record.data.feature)){
    		 var featureId =   record.data.feature;
    		 form.down('#featureItemId').setValue(featureId.value);
    	 }
    	 if(!isNullOrEmpty(record.data.privilege)){
    		 var privilegeId =   record.data.privilege;
    		 form.down('#privilegeItemId').setValue(privilegeId.value);
    	 }
    	 
    	 
   	  var store = $this.getNoofrolesgrid().getStore();
		store.getProxy().extraParams = {
			featurePrivilegeId:record.data.featurePrivilegeId
		};
		$this.resetPageSetting(store);
		store.load({
			//Added for horizontal scroll show after 3 record for safari
            callback:function(rec,operation,success){
                if(rec.length <= 3){
                    $this.getNoofroleswin().setAutoScroll(false);
                }
            }
        });
		
	},
	/**
	 *  openListOfUsersWin is using when click on No. of Users column cell of URP Grid
	 */
	/*openListOfUsersWin:function(grid, rowIndex, record){
		var $this = this;
		var formWindow = $this.getNoofuserswin();
		if (!formWindow) {
			Ext.widget('noofuserswin');
			formWindow = $this.getNoofuserswin();
		}
		formWindow.show();

		var form = $this.getNoofuserswin();
		if(!isNullOrEmpty(record.data.portal)){
			// var hostelCodeName =   record.data.hostelCode + '/' + record.data.hostelName;
			form.down('#portalItemId').setValue(record.data.portal.value);
		}
		if(!isNullOrEmpty(record.data.module)){
			var module =   record.data.module;
			form.down('#moduleItemId').setValue(module.value);
		}
		if(!isNullOrEmpty(record.data.feature)){
			var featureId =   record.data.feature;
			form.down('#featureItemId').setValue(featureId.value);
		}
		if(!isNullOrEmpty(record.data.privilege)){
			var privilegeId =   record.data.privilege;
			form.down('#privilegeItemId').setValue(privilegeId.value);
		}


		var store = $this.getNoofusersgrid().getStore();
		store.getProxy().extraParams = {
			featurePrivilegeId:record.data.featurePrivilegeId
		};
		$this.resetPageSetting(store);
		store.load({
			//Added for horizontal scroll show after 3 record for safari
			callback:function(rec,operation,success){
				 if(rec.length <= 3){
                    $this.getNoofroleswin().setAutoScroll(false);
                }
			}
		});

	},*/
	openURPUserTabStructure: function(record) {
        var urpStructure = this.getUrpstructure();
        var urpUserTabStructure = Ext.widget('urpusertabstructure');
        var tabName = getCommonTranslation('URP_USERS');
        var getcontroller = this.getController('menu.CoreERPNavigationController');
        this.getUserTab(getServiceRequestTranslation('USERS'));
        /*if (getUserTab != null) {
        	urpStructure.items.removeAt(urpStructure.items.items.getAt(1));
        }*/
        var portal = record.data.portal.value;
        var module = record.data.module.value;
        var feature = record.data.feature.value;
        var privilege = record.data.privilege.value;
        var featurePrivilegeId = record.data.featurePrivilegeId;

        var urpUserFilter = this.getUrpuserfilter();
        var userPortalId = urpUserFilter.down('#userPortalItemId').setValue(portal);
        var userModuleId = urpUserFilter.down('#userModuleItemId').setValue(module);
        var userFeatureId = urpUserFilter.down('#userFeatureItemId').setValue(feature);
        var userPrivilegeId = urpUserFilter.down('#userPrivilegeItemId').setValue(privilege);
        urpUserFilter.down('#userFeaturePrivilegeItemId').setValue(featurePrivilegeId);
        openTab(urpStructure, tabName, urpUserTabStructure, CONSTANTS.MENU_COLOR_THREE);
    },
    
    getUserTab: function(tabTitle) {
    	urpstructure = this.getUrpstructure(); 
    	if (urpstructure.items.items.length == 2 ) {
    		urpstructure.items.items[1].close();
    	}
    },
    
    loadURPUserGrid: function() {
        var urpUserFilter = this.getUrpuserfilter();
        var alCombo = urpUserFilter.down('#alItemId');
        var academyLocationId = alCombo.getValue();
        var alIds = [];
        var academyLocationIds = null;

        if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0) {
            for (var i in academyLocationId) {
                if (Ext.isObject(academyLocationId[0])) {
                    alIds.push(academyLocationId[i].get("id"));
                } else {
                    alIds.push(academyLocationId[i]);
                }
            }
            academyLocationIds = alIds.join();
        }
        var featurePrivilegeId = urpUserFilter.down('#userFeaturePrivilegeItemId').getValue();

        var portal = urpUserFilter.down('#userPortalItemId').getValue();
        var module = urpUserFilter.down('#userModuleItemId').getValue();
        var feature = urpUserFilter.down('#userFeatureItemId').getValue();
        var privilege = urpUserFilter.down('#userPrivilegeItemId').getValue();
        var store = this.getUrpusergrid().getStore();
        store.getProxy().extraParams = {
            featurePrivilegeId: featurePrivilegeId,
            portal: portal,
            module: module,
            feature: feature,
            privilege: privilege,
            academyLocationIds: academyLocationIds
        };
        store.load();
    }
});