/**
 * @author Pritam.Patil
 * This is used for current Locked User Functionality
 */
Ext.define('Academia.controller.securitysetup.unlockUser.CurrentLockUserController', {
    extend: 'Academia.controller.base.BaseController',

    stores:['criteriabuilder.userquicksearch.QuickSearchCode','criteriabuilder.userquicksearch.QuickSearchName'],
    views: ['securitysetup.unlockuser.CurrentlyLockedUserPanel', 'securitysetup.unlockuser.CurrentlyLockedUserSearchForm', 
            'securitysetup.unlockuser.CurrentlyLockedUserView'],
    refs: [{
        ref: 'lockedUserSearchForm',
        selector: 'currentlylockedusersearchform[itemId=currentlyLockedUserSearchForm]'
    }, {
        ref: 'searchResultGrid',
        selector: 'searchresultgrid[itemId=currentlyLockedUserGrid]'
    }],
    config: {
    	CURRENTLY_LOCKED_USER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CURRENTLY_LOCKED_USER_PRIVILEGES')
    },
    init: function(application) {
        this.control({

            'currentlylockedusersearchform[itemId=currentlyLockedUserSearchForm] button[itemId=lockedUserSearchButtonId]': {
                click: this.loadGridAndSearchUsers,
                //render: this.loadGridAndSearchUsers
            },
            'searchresultgrid[itemId=currentlyLockedUserGrid]': {
                //TODO: figure out the onload stratergy
                //render:this.loadGridAndSearchUsers
            	afterrender: function(grid) {
            		this.loadGridAndSearchUsers();
 					this.gridRenderFunction(grid);
 				}
            },
            'currentlylockeduserpanel button[itemId=currentlyLockedReleaseBtn]': {
                click: this.unlockUser
            },
            'currentlylockedusersearchform[itemId=currentlyLockedUserSearchForm] button[itemId=lockedUserClearSearchBtn]': {
                click: this.clearSearchForm
            },
            'currentlylockeduserpanel grid[itemId=currentlyLockedUserGrid]' : {
            	afterrender : function(grid){
            		this.genericCBGridAccessControlValidation(grid, this.getCURRENTLY_LOCKED_USER_PERMISSIONS());
            		var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
            		viewButton.setVisible(false);
            		this.gridButtonCheckPermission(grid,this.getCURRENTLY_LOCKED_USER_PERMISSIONS());
            	}
            },
            //FixingColumnHeader
            'currentlylockeduserpanel':{
				afterrender : function(structure){
					var grid = structure.down('searchresultgrid');
					this.getGridHeaderFreeze(grid,structure);
				}
     		},
            /**** Export button for currently locked user ******/
	        'searchresultgrid[itemId=currentlyLockedUserGrid] button[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
	            click: function() {
	                this.exportCurrentlyLockedUser(SERVERURL.PDFEXPORT,'pdf',false);
	            }
	        },
	        'searchresultgrid[itemId=currentlyLockedUserGrid] button[itemId=exportToPdfBtn] #exportPdfAll': {
	            click: function() {
	                this.exportCurrentlyLockedUser(SERVERURL.PDFEXPORT,'pdf',true);
	            }
	        },
	        'searchresultgrid[itemId=currentlyLockedUserGrid] button[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
	            click: function() {
	                this.exportCurrentlyLockedUser(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
	            }
	        },
	        'searchresultgrid[itemId=currentlyLockedUserGrid] button[itemId=exportToPdfBtn] #exportExcelAll': {
	            click: function() {
	                this.exportCurrentlyLockedUser(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
	            }
	        }
        });
    },
    	
    /***
	  * This function is to export pdf and xcel
	  */
   
    exportCurrentlyLockedUser : function(exportUrl,filetype,whetherAll,requestType) {
	   	 var quickSearchForm=this.getLockedUserSearchForm();
	   	 var searchResultGrid = this.getSearchResultGrid();	
	   	 var pagingtoolbaroptions = this.getSearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
         var reportTitle=getCommonTranslation('CURRENTLY_LOCKED_USER');
	   	var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	   	var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
	   	var visibleColumns=this.getVisibleColumns(searchResultGrid);
			if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
				jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
			searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
		},
		
		createSearchCriteriaString: function(searchForm) {
	   	var me=this;
	       var formValues = new Array();
	       formValues = searchForm.getValues();        
	       var searchCriteriaString="";
	       for (var key in formValues) {
	       	var value = formValues[key];            
	           if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
	               var keyValueJsonObject = me.getJsonObject( key , value);
	   	        searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
	           }
	       }
	       searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
	       return searchCriteriaString;
	   },
   
	   gridRenderFunction:function(grid){
			grid.addButtonToolbar();
			
			var butonstoolbar=grid.down('#functionButtonsToolbar');
			butonstoolbar.insert(4,{
		        xtype: 'fieldcontainer',
		        layout: 'hbox',
		        items: [{
					xtype: 'button',
					ui: 'CustomBtnThird',
					itemId: 'currentlyLockedReleaseBtn',
					text:getUserModuleTranslation('RELEASE_LOCK'),
					tooltip :getUserModuleTranslation('RELEASE_LOCK'),
					cls: 'btn-with-no-icon release-lock-btn'
				}]
		    });
	   },
    /**
     * This is used to load search result grid
     * @param model
     * @param records
     */
    loadGridAndSearchUsers: function(model, records) {
        var searchviewForm = this.getLockedUserSearchForm();
        var jsonFormatFormData = this.createJsonFormat(searchviewForm, records);
        if(!isNullOrEmpty(jsonFormatFormData) && jsonFormatFormData == 'FAILED') {
        	showWarningMessage(getUserModuleTranslation('CURRENTLY_LOCKED_USERS'), "Minimum value can not be greater than Maximum value.");
        } else {
        	var searchResultGrid = this.getSearchResultGrid();
            var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
            resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.CURRENT_LOCKED_USER_VIEWCODE);
            searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
        }
    },

    /**
     * This method is used to create JSON format of form values
     * @param SearchForm
     * @return formated JSON of form Values
     */
    createJsonFormat: function(searchviewForm) {
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.CURRENT_LOCKED_USER_BASIC_CONFIGCODE;

        formValues = searchviewForm.getValues();

        var USER_ID = this.getJsonObject('USER_ID', formValues.USER_ID);
        this.pushJsonObjectInArray(USER_ID, searchcriteria);

        var USER_NAME = this.getJsonObject('USER_NAME', formValues.USER_NAME);
        this.pushJsonObjectInArray(USER_NAME, searchcriteria);

        if(!isNullOrEmpty(formValues.FROM_DATE)){
        	var LOCKED_ON_FROM_DATE = this.getJsonObject('LOCKED_ON_FROM_DATE', formValues.FROM_DATE+" "+'00:00:00');
        	this.pushJsonObjectInArray(LOCKED_ON_FROM_DATE, searchcriteria);
        }
        if(!isNullOrEmpty(formValues.TO_DATE)){
        	var toDate = (formValues.TO_DATE).replace('00:00:00','23:59:59');
        	var LOCKED_ON_TO_DATE = this.getJsonObject('LOCKED_ON_TO_DATE', toDate+" "+'23:59:59');
        	this.pushJsonObjectInArray(LOCKED_ON_TO_DATE, searchcriteria);
        }

        var MIN_NO_OF_TIME_LOCKED = this.getJsonObject('MIN_NO_OF_TIME_LOCKED', formValues.MIN_NO_OF_TIMES_LOCKED);
        this.pushJsonObjectInArray(MIN_NO_OF_TIME_LOCKED, searchcriteria);

        var MAX_NO_OF_TIME_LOCKED = this.getJsonObject('MAX_NO_OF_TIME_LOCKED', formValues.MAX_NO_OF_TIMES_LOCKED);
        this.pushJsonObjectInArray(MAX_NO_OF_TIME_LOCKED, searchcriteria);
        
        if(!isNullOrEmpty(MIN_NO_OF_TIME_LOCKED) && !isNullOrEmpty(MAX_NO_OF_TIME_LOCKED)) {
        	if(MIN_NO_OF_TIME_LOCKED.paramValues[0] > MAX_NO_OF_TIME_LOCKED.paramValues[0]){
        		return 'FAILED';
        	}
        }
        
        var LOCKED_REASON='';
        if(formValues.LOCKED_REASON=='Locked for wrong password attempt'){
        	LOCKED_REASON='locked_for_wrong_password_attempt'
        	LOCKED_REASON = this.getJsonObject('LOCKED_REASON', LOCKED_REASON);
        }
        else{
            LOCKED_REASON = this.getJsonObject('LOCKED_REASON', formValues.LOCKED_REASON);
        }
       
        this.pushJsonObjectInArray(LOCKED_REASON, searchcriteria);

        values.searchCriterias = searchcriteria;
        return values;
    },

    /**
     * This method is used to crate JSON object
     * @param key 
     * @param value
     * @param additional value
     * @return JSON object
     */
    getJsonObject: function(key, value, additionalValue) {
        if (value != '' && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (value != '' && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },

    /**
     * This method is used to push JSON object into array & create Object array
     *@param JSON object
     *@param array
     *@return JSON object Array
     */
    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    },

    /**
     * This is used to unlock user on click of 'Unlock' button
     */
    unlockUser: function() {
        var unlockUserUrl = SERVERURL.UNLOCKUSERURL;
        var grid = this.getSearchResultGrid();
        var selectedUserRecord = this.getSearchResultGrid().getSelectionModel();
        if (grid.getSelectionModel().getCount() > 0) {
        	  showConfirmMessage(getCommonTranslation('UNLOCKUSER'), getCommonTranslation('UNLOCK_USER_CONFIRMATION'), function(btn, text) {
                  if (btn == 'yes') {
                	  var ids = [];
                	  grid.getSelectionModel().getSelection().forEach(function(obj){
                		  ids.push(obj.data.ID);
      				});
                   // unlockUserUrl = unlockUserUrl.concat('?id=' + selectedUserRecord.getLastSelected().data.ID);
                	  unlockUserUrl = unlockUserUrl.concat('?ids=' + ids.join());
                    Ext.Ajax.request({
                        type: 'rest',
                        url: unlockUserUrl,
                        method: 'GET',
                        success: function(response) {
                            showSuccessMessage(getCommonTranslation('UNLOCKUSER'), getCommonTranslation('UNLOCK_SUCCESSFUL'));
                            grid.getSelectionModel().deselectAll(true);
                            grid.getStore().reload();
                            grid.getSelectionModel().select(0, true);
                        }
                    });
                }
            });
        } else {
            showWarningMessage(getUserModuleTranslation('CURRENTLY_LOCKED_USERS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },

    /**
     * This method is used to clear fields on User Frequency search Form
     * @param button which is reference of buttton
     */
    clearSearchForm: function(button) {

        form = button.up('form').getForm();
        form.getFields().each(function(field) {
            field.reset();
        });
    },
    
    gridButtonCheckPermission: function(gridReference,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	buttonsToolBar = gridReference.query('toolbar')[0];
    	
    	var currentlyLockedReleaseBtn = gridReference.down('#currentlyLockedReleaseBtn');
		currentlyLockedReleaseBtn.setVisible(false);
    	
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'RELEASE_LOCK') {
        		if(!isNullOrEmpty(currentlyLockedReleaseBtn)){
        			currentlyLockedReleaseBtn.setVisible(true);
        		}        		
        	}
    	});
    }
});
