/**
\ * @author Deepak S
 */
Ext.define('Academia.controller.setup.campaignmaster.CampaignMasterController', {
    extend: 'Academia.controller.base.BaseController',

    views: ['setup.campaignmaster.CampaignMasterTabPanel','setup.campaignmaster.ManageSchoolList','setup.campaignmaster.ManageSchoolGrid',
    		'setup.campaignmaster.ManageSchoolUploadDownloadStructure','setup.campaignmaster.ManageSchoolDownloadForm','setup.campaignmaster.ManageSchoolUploadForm',
    		'setup.campaignmaster.ImportListManageSchool','setup.campaignmaster.StcManageSchoolFormPadmStructure',
    		'setup.campaignmaster.MapSchoolPriorityTabStructure','setup.campaignmaster.MapSchoolPriorityForm','setup.campaignmaster.MapSchoolPriorityGrid',
    		'setup.campaignmaster.CopyMappingPriorityWindow','setup.campaignmaster.SetDefaultPriorityWindow',
    		'setup.campaignmaster.ManageSchoolCreationPadmForm'],
    models : [ 'setup.campaignmaster.ModCampaignSchoolCreatepAdmModel'],
    stores: ['setup.campaignmaster.ManageSchoolStore','criteriabuilder.userquicksearch.ImportUsers','importutility.ModuleName','user.UserAcademyLocationStore',
    		'common.IntakeYearStore','campaignnew.CampaignSchoolStore','setup.campaignmaster.MapSchoolPriorityStore','campaignnew.SchoolPriorityStore',
    		'enquiry.EducationDepartmentStore','common.ExamBoardStore','common.CountryStore','setup.campaignmaster.StoPadmManageSchoolCategoryStore','setup.campaignmaster.StoPadmCreateSchoolContactDetailStore'],
    refs: [{
        ref: 'campaignmastertabpanel',
        selector: 'campaignmastertabpanel[itemId=campaignmastertabpanelItemId]'
    },{
        ref: 'manageschoollist',
        selector: 'manageschoollist'
    },{
        ref: 'manageschoolgrid',
        selector: 'manageschoolgrid'
    },{
        ref: 'manageschooluploaddownloadstructure',
        selector: 'manageschooluploaddownloadstructure'
    },{
        ref: 'manageschooluploadform',
        selector: 'manageschooluploadform'
    },{
        ref: 'manageschooldownloadform',
        selector: 'manageschooldownloadform'
    },{
    	ref: 'importlistmanageschool',
        selector: 'importlistmanageschool'
    },{
    	ref: 'stcmanageschoolformpadmstructure',
        selector: 'stcmanageschoolformpadmstructure'
    },{
    	ref: 'mapschoolprioritytabstructure',
        selector: 'mapschoolprioritytabstructure'
    },{
    	ref: 'mapschoolpriorityform',
        selector: 'mapschoolpriorityform'
    },{
    	ref: 'mapschoolprioritygrid',
        selector: 'mapschoolprioritygrid'
    },{
    	ref: 'copymappingprioritywindow',
        selector: 'copymappingprioritywindow'
    },{
    	ref: 'setdefaultprioritywindow',
        selector: 'setdefaultprioritywindow'
    },{
    	ref: 'manageschoolcreationpadmform',
        selector: 'manageschoolcreationpadmform'
    }],
    config: {
    	CAMPAIGN_MASTER_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CAMPAIGN_MASTER_PRIVILEGES'),
    	CAMPAIGN_MAP_SCHOOL_PRIORITY_TAB_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CAMPAIGN_MAP_SCHOOL_PRIORITY_TAB_PRIVILEGES')
    },
    init: function(application) {
    	this.control({
    	
    		'manageschoolgrid[itemId=manageschoolgridId]': {
    			render: function(grid){
    				var store = grid.getStore();
    				store.load();
    				this.resetPageSetting(store);
    				this.doAccessControlValidation(grid, this.getCAMPAIGN_MASTER_PERMISSIONS());
    			},
    			afterrender:function(grid){
    				var me = this;
    				setTimeout(function(){
    					me.addDataGridConfigButton(grid,me.getCAMPAIGN_MASTER_PERMISSIONS());
    				},1500);
    			}
    		},
    		'stcmanageschoolformpadmstructure': {
    			render: function(stc){
    				var $this = this;
    				stc.body.on('click', function() {
    	    			var filter = stc.down('manageschoolcreationpadmform');
    	    			$this.hideInvalidIconFromField(filter);
    	    	       });
    			}
    		},
    		
    		'manageschoolgrid button[itemId=btnAdd]':{
    			click: function(){
    				this.addManageSchool();
    			}
    		},
    		'manageschoolgrid button[itemId=btnEdit]': {
    			click: function() {
    				this.editManageSchool();
    			}
    		},
    		'manageschoolgrid button[itemId=btnDelete]': {
    			click: function() {
    				this.deleteManageSchool();
    			}
    		},
    		'manageschooluploaddownloadstructure radiogroup[itemId=importDownloadgroupManageSchoolId]':{
    			change: this.userDownloadUploadFormChange
    		},
    		'manageschoolcreationpadmform button[itemId=btnCancelManageSchoolForm]': {
                click: this.cancelManageSchoolForm
            },
            'manageschoolcreationpadmform button[itemId=btnSaveManageSchoolForm]': {
                click: this.savelManageSchoolForm
            },
            'manageschooldownloadform button[itemId=downoladBtnId]':{
            	click:function(obj){
            		var $this = this;
            		var form =obj.up('manageschooldownloadform').getForm();
            		var value = form.getValues();
            		var csvForm = Ext.create('Ext.form.Panel'); 
            		csvForm.getForm().submit({
            			target: '_blank',
            			method:'POST',
            			params :{
            				access_token : Ext.Ajax.defaultHeaders.access_token
            			},
            			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
            			url: SERVERURL.DOWNLOAD_TEMPLATE_CAMPAIGN_SCHOOL,
            			standardSubmit :true
            		});
            	}  
            },
            'manageschooluploadform button[itemId=uploadId]':{
            	click:function(obj){
            		var $this=this;
            		var grdStore;
            		var form=obj.up('manageschooluploadform');
            		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
    	        	$this.getHashOfFile(form);
		        	setTimeout(function() {
	            		form.getForm().submit({
	            			method : 'POST',
	            			url : submitUrl,
	            			success : function(form, action){
	            				showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	            			},
	            			failure: function(form, action) {
   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
	            			}
	            		});
		        	},1000);
            		Ext.defer(function() {
            			var grid = $this.getImportlistmanageschool();
            			grid.getStore().getProxy().extraParams = {
            				moduleName: 'Bulk Campaign School'
            			};
            			grid.getStore().load();
            		}, 2000, this);
            	}  
            },
            'manageschooluploadform button[itemId=resetBtn]':{
            	click:function(obj){
            		var $this = this;
            		var form =obj.up('manageschooluploadform').getForm();
            		form.findField('file').reset();
            		form.isValid();
            	},
            	render :function(obj){
            		var $this = this;
            		var form =obj.up('manageschooluploadform').getForm();
            		var combo = form.findField('importUtilityMasterId');
            		combo.getStore().load({
            			callback: function(records, operation, success) {
            				for(var i in records){
            					if(records[i].data.value=='Bulk Campaign School'){
            						combo.setValue(records[i].data.id);
            						combo.setReadOnly(true);
            					}
            				}
            			}	   
            		});
            	}  
            },
            'importlistmanageschool':{
            	render:function(obj){
            		var $this = this;
            		var grid = $this.getImportlistmanageschool();

            		grid.getStore().getProxy().extraParams = {
            			moduleName: 'Bulk Campaign School'
            		};
            		grid.getStore().load();
            	},
            	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
            		if (e.target.tagName == 'A') {
            			var fileType=null;
            			if(cellIndex==1){
            				fileType='successFile';
            			}else if(cellIndex==6){
            				fileType='errorFile';
            			}else if(cellIndex==7){
            				fileType='logFile';
            			}
            			var documentId = record.get("id");
            			if (!isNullOrEmpty(documentId)) {
            				this.getCampaignSchoolDownloadFile(documentId,fileType);
            			}
            		}
            	}
            },
     	  'importlistmanageschool button[itemId=btnForce]':{
			   click: function(obj) {
				   var grid = this.getImportlistmanageschool();
				   if (grid.getSelectionModel().getCount() > 0) {
					   if(grid.getSelectionModel().getCount() > 1){
						   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
					   }else{
						   var this$ = this;
						   var id = grid.getSelectionModel().selectionStart.data.id;
						   console.log(id);
						   var urlAppend="?jobName="+id;
						   var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
						   Ext.Ajax.request({
							   url: submitURL,
							   method: 'GET',
							   success: function(response) {
								   if(response.responseText==="JOB_STATUS_NOT_PENDING"){
									   showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
								   }else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
									   showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
								   }else if(response.responseText==="SUCCESS"){
									   showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'),getCommonTranslation('SUCCESS'));
									   grid.getStore().reload();
								   }
							   }
						   });
					   }
				   } else {
					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				   }  
			   }
		   },
		   'mapschoolpriorityform customcombobox[itemId=brandCampusId]': {
			   select: function(combo, records, eOpts){
				   this.searchMapSchoolPriority();
			   }
		   },
		   
		   'mapschoolpriorityform customcombobox[itemId=intakeYearId]': {
			   select: function(combo, records, eOpts){
				   this.searchMapSchoolPriority();
			   }
		   },
		   /*'mapschoolpriorityform button[itemId=searchBtn]': {
			   click: function(btn) {
				   this.searchMapSchoolPriority();
			   }
		   },*/
		   'campaignmastertabpanel[itemId=campaignmastertabpanelItemId]':{
			   tabchange:function(tabPanel, newCard, oldCard, eOpts){
				   var me = this;
				   var formPnl = me.getMapschoolpriorityform();
				   var grid = me.getMapschoolprioritygrid();
				   if(newCard.xtype == "mapschoolprioritytabstructure"){
					   grid.down('#mapSchoolSubmitBtn').setDisabled(true);
					   grid.down('#copyMappingBtn').setDisabled(true);
					   grid.down('#resetBtnGrid').setDisabled(true);
					   grid.down('#setDefaultPriorityBtn').setDisabled(true);
					   grid.down('#exportReportItemId').setDisabled(true);
					   grid.down('#schoolId').setDisabled(true);
					   grid.down('#schoolId').reset();
					   formPnl.getForm().reset();
					   me.resetGridSetting(grid);
					   grid.getStore().removeAll();
					   grid.down('custompagingtoolbar').hide();
					   grid.getView().refresh();
					   newCard.body.on('click', function() {
	    					
	    					var filter = newCard.down('mapschoolpriorityform');
	    					me.hideInvalidIconFromField(filter);
	    			       });
				   }
			   },
			 
			   beforerender:function(structure){
				   this.showHideMapSchoolPriorityTab(structure, this.getCAMPAIGN_MAP_SCHOOL_PRIORITY_TAB_PERMISSIONS());
			   },
		   },
		   'mapschoolprioritygrid button[itemId=copyMappingBtn]': {
			   click: function(btn) {
				   var me = this;
				   var formPnl = me.getMapschoolpriorityform();
				   var grid = me.getMapschoolprioritygrid();

				   var formWindow = me.getCopymappingprioritywindow();
				   if (!formWindow) {
					   Ext.widget('copymappingprioritywindow');
					   formWindow = this.getCopymappingprioritywindow();
				   }
				   var brandCampusDisplayFld = formWindow.down('#brandCampusDisplayId');
				   var intakeYearDisplayFld = formWindow.down('#intakeYearDisplayId');
				   
				   var brandCampusIdVal = formPnl.down('#brandCampusId').getRawValue();
				   var intakeYearIdVal = formPnl.down('#intakeYearId').getRawValue();
				   brandCampusDisplayFld.setValue(brandCampusIdVal);
				   intakeYearDisplayFld.setValue(intakeYearIdVal);
				   formWindow.show();
			   }
		   },
		   'mapschoolprioritygrid button[itemId=setDefaultPriorityBtn]': {
			   click: function(btn) {
				   var me = this;
				   var formPnl = me.getMapschoolpriorityform();
				   var grid = me.getMapschoolprioritygrid();

				   if(grid.getSelectionModel().getCount()>0){
					   var formWindow = me.getSetdefaultprioritywindow();
					   if (!formWindow) {
						   Ext.widget('setdefaultprioritywindow');
						   formWindow = this.getSetdefaultprioritywindow();
					   }
					   formWindow.show();
				   }
				   else {
					   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
				   }
			   }
		   },
		   'mapschoolprioritygrid button[itemId=mapSchoolSubmitBtn]': {
			   click: function(btn) {
				   this.saveSchoolPriorityMappingRecord(btn);
			   }
		   },
		   'mapschoolprioritygrid customcombobox[itemId=schoolId]': {
			   select: function(combo, records, eOpts){
				   var me = this;
				   var grid = me.getMapschoolprioritygrid();
				   var formPnl = me.getMapschoolpriorityform();
				   var brandCampusFld = formPnl.down('#brandCampusId');
				   var intakeYearFld = formPnl.down('#intakeYearId');
				   var store = grid.getStore();
				   store.getProxy().extraParams = {
					academyLocationId: brandCampusFld.getValue(),
					intakeYear: intakeYearFld.getValue(),
					campaignSchoolId: combo.getValue()
                   }
				   store.loadPage(1);
			   }
		   },
		   'mapschoolprioritygrid button[itemId=resetBtnGrid]': {
			   click: function(btn) {
				   this.searchMapSchoolPriority();
			   }
		   },
		   'mapschoolprioritygrid button[itemId=exportReportItemId]': {
          	 click: function(btn) {
          		 this.exportXlsMapSchoolPriority();
          	 }
           },
		   'mapschoolprioritygrid': {
               cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
            	   var me = this;
				   var formPnl = me.getMapschoolpriorityform();
				   var grid = me.getMapschoolprioritygrid();
                   var columnName = grid.columnManager.columns[cellIndex].dataIndex;
                   if (e.target.tagName == 'INPUT') {
                	   record.set('schoolPriority',columnName);
                   }
                   me.resetMapSchoolPriorityGridHeaderFreeze();
               },
               afterrender: function(grid) {
                   this.doAccessMapSchoolPriorityGridButton(grid, this.getCAMPAIGN_MAP_SCHOOL_PRIORITY_TAB_PERMISSIONS());
               }
           },
		   
		   'copymappingprioritywindow button[itemId=addNewRowCampusBtn]': {
			   click: function(obj) {
				   this.addMultipleCampusIntakeRow(obj);
			   }
		   },
		   'copymappingprioritywindow button[itemId=CancelBtn]': {
			   click: function(obj) {
				   this.getCopymappingprioritywindow().close();
			   }
		   },
		   'copymappingprioritywindow button[itemId=SubmitBtn]': {
			   click: function(obj) {
				   this.saveCopyMappingSchoolPriority();
			   }
		   },
		   'copymappingprioritywindow customcombobox[name=brandCampusWin]': {
			   select: function(combo, records, eOpts){
				   this.selectBrandCampusWin(combo, records);
			   }
		   },
		   'copymappingprioritywindow customcombobox[name=intakeYearWin]': {
			   select: function(combo, records, eOpts){
				   this.selectBrandCampusWin(combo, records);
			   }
		   },
		   'setdefaultprioritywindow button[itemId=PriorityCancelBtn]': {
			   click: function(obj) {
				   this.getSetdefaultprioritywindow().close();
			   }
		   },
		   'setdefaultprioritywindow button[itemId=PrioritySubmitBtn]': {
			   click: function(obj) {
				   this.saveDefaultSchoolPriorityWindow(obj);
			   }
		   },
		   'manageschoolcreationpadmform button[itemId=btnAddpAdmMSContactHeader]':{
			   click:this.addpAdmMSContactHeaderContainer
		   },
   		'manageschoolcreationpadmform button[itemId=containerDetailedpAdmMSDeleteButton]':{
			click : function(deleteButton) {
				 this.deletepAdmMSContactHeaderContainer(deleteButton)
			 }
		},
		'manageschoolcreationpadmform combo[itemId=dlipAdmMScontactDetailItemId]' : {
			select : function(obj, record) {
				var departmentId=record[0].get('id');
				var flag = true;
				var pnlMain = obj.up("#contactDetailHeaderPanelItemId");
				var rowIndx = obj.rowIndx;
				if(!isNullOrEmpty(pnlMain)){
					pnlMain.items.each(function(item, index, items) {
						var deptNameVal = item.down("[name=contactDetails]").getValue();
						if(departmentId == deptNameVal && rowIndx != index){
							flag = false;
        					return false;
						}
					});
					
					if(flag){
						var nextSiblingField = obj.nextSibling();
						nextSiblingField.setDisabled(false);
						var nextSiblingField1 = obj.nextSibling().nextSibling();
						nextSiblingField1.setDisabled(false);
						var nextSiblingField2 = obj.nextSibling().nextSibling().nextSibling();
						nextSiblingField2.setDisabled(false);
						var nextSiblingField3 = obj.nextSibling().nextSibling().nextSibling().nextSibling();
						nextSiblingField3.setDisabled(false);
					}
					else{
						obj.reset();
						var nextSiblingField = obj.nextSibling();
						nextSiblingField.reset();
						nextSiblingField.setDisabled(true);
						var nextSiblingField1 = obj.nextSibling().nextSibling();
						nextSiblingField1.reset();
						nextSiblingField1.setDisabled(true);
						var nextSiblingField2 = obj.nextSibling().nextSibling().nextSibling();
						nextSiblingField2.items.items[0].reset();
						nextSiblingField2.items.items[1].reset();
						nextSiblingField2.setDisabled(true);
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CONTACT_DETAIL_ALREADY_SELECTED_MSG'));
						return false;
					}
				}
			}
		},
		'manageschoolcreationpadmform button[itemId=btnResetManageSchoolForm]' : {
			click:function(obj){
				 this.resetCreateSchoolpAdmMSform();
				 var form = this.getManageschoolcreationpadmform();
                 var plusIcon =form.down('#btnAddpAdmMSContactHeader');
                 this.loadDFRForPlusIcon(plusIcon);
			 }
		},
		'manageschoolcreationpadmform customcombobox[name=country]' : {
			select:function(obj, record){
				var this$ = this;
		    	var winform = this$.getStcmanageschoolformpadmstructure();
		    	var form = winform.down('form');
		    	var cityComboBox = form.down('customcombobox#cityIteamId');
		        cityComboBox.clearValue();
		        cityComboBox.reset();
		        cityComboBox.setDisabled(true);
		        var countryRegionComboBox = form.down('customcombobox#countryRegionIteamId');
		        countryRegionComboBox.setDisabled(false);
		        countryRegionComboBox.clearValue();
		        countryRegionComboBox.reset();
		        var countryId = record[0].get("id");
		        
		        var countryRegionStore = countryRegionComboBox.getStore();
		        countryRegionStore.getProxy().extraParams = {
		            cid: countryId
		        };
		        countryRegionStore.load();
		        
		        var cityStore = cityComboBox.getStore();
		        cityStore.getProxy().extraParams = {
		            id: null
		        };
		        cityStore.load();
			}
		},
		'manageschoolcreationpadmform customcombobox[name=countryRegion]' : {
			select:function(obj, record){
				var this$ = this;
				var winform = this$.getStcmanageschoolformpadmstructure();
				var form = winform.down('form');
				var cityComboBox = form.down('customcombobox#cityIteamId');
				cityComboBox.setDisabled(false);
				cityComboBox.reset();
				var countryRegion1 = record[0].get("id");
				var cityStore =cityComboBox.getStore();
				cityStore.getProxy().extraParams = {
					id: countryRegion1
				};
				cityStore.reload();
			}
		}
    	});
    },
    resetMapSchoolPriorityGridHeaderFreeze : function(){
    	var structurePnl = this.getMapschoolprioritytabstructure();
    	structurePnl.scrollBy(0,1);
        structurePnl.scrollBy(0,-1);
    },
    getCampaignSchoolDownloadFile : function(documentId,fileType){
  	   if(!isNullOrEmpty(documentId)){
  		   var csvForm = Ext.create('Ext.form.Panel'); 
  		   csvForm.getForm().submit({
  			   target: '_blank',
  			   method:'POST',
  			   params :{
  				   access_token : Ext.Ajax.defaultHeaders.access_token
  			   },
  			   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
  			   url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
  			   standardSubmit :true
  		   });
  	   }
     },
    userDownloadUploadFormChange : function(cb, nv, ov){
		var $this = this;
		var structure = cb.up('manageschooluploaddownloadstructure');
		var downloadTemplateForm = structure.down('manageschooldownloadform');
		var uploadTemplateForm = structure.down('manageschooluploadform');
		var grid = $this.getImportlistmanageschool();
		if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
			uploadTemplateForm.hide();
			downloadTemplateForm.show();
			grid.setVisible(false);
		}else{
			downloadTemplateForm.hide();
			uploadTemplateForm.show();
			grid.setVisible(true);
			uploadTemplateForm.down("#uploadFileField").reset();
		}
	},
	addManageSchool : function(){
		var $this = this;
		var contentPanel = $this.getCampaignmastertabpanel();
        var contentXtype ='stcmanageschoolformpadmstructure';
        var tabName = getCommonTranslation('SCHOOL_DETAILS');
        var getTab = null;
		for(var i =0 ;i<contentPanel.items.length;i++){
			if(contentPanel.items.items[i].title == tabName){
				getTab= contentPanel.items.items[i];
			}
		}
		if(getTab!=null){
			contentPanel.remove(getTab, true);
		}
		var newTab = $this.getTabReferenceByTabTitle(tabName);
		if(!newTab){
    		newTab = contentPanel.add({
    			xtype: contentXtype,
    			closable: true,
    			title: tabName,
    			menuColorCls: CONSTANTS.MENU_COLOR_ONE
    		});
    	}
    	contentPanel.setActiveTab(newTab);
        
      /*  winForm.show();
        winForm.body.on('click', function() {
			var filter = winForm.down('manageSchoolForm');
			$this.hideInvalidIconFromField(filter);
	       });*/
    },
    cancelManageSchoolForm: function() {
        this.getManageschoolformwindow().close();
    },
    savelManageSchoolForm:function(){
    	var this$ = this;
    	var winform = this$.getStcmanageschoolformpadmstructure();
    	var grid = this$.getManageschoolgrid();
    	var createCampaignSchool = new Academia.model.setup.campaignmaster.ModCampaignSchoolCreatepAdmModel();
    	var winFormPnl = winform.down('form');
    	var winFormPnlValues = winFormPnl.getForm().getFieldValues();
    	var txtPadmMSEmailItemId = winFormPnl.down('#txtPadmMSEmailItemId').getValue();
    	var dlipAdmMScellCountrycodeId = winFormPnl.down('#dlipAdmMScellCountrycodeId').getValue();
    	var numpAdmMScellNoId = winFormPnl.down('#numpAdmMScellNoId').getValue();
    	createCampaignSchool.set("id", winFormPnlValues.id);
    	createCampaignSchool.set("code", winFormPnlValues.code);
    	createCampaignSchool.set("schoolCategory", this$.getIdValueJson(winFormPnlValues.schoolCategory));
    	createCampaignSchool.set("number", winFormPnlValues.number);
    	createCampaignSchool.set("examBoardMaster", this$.getIdValueJson(winFormPnlValues.examBoardMaster));
    	createCampaignSchool.set("educationDepartment", this$.getIdValueJson(winFormPnlValues.educationDepartment));
    	createCampaignSchool.set("value", winFormPnlValues.value);
    	createCampaignSchool.set("schoolNameAfr", winFormPnlValues.schoolNameAfr);
    	createCampaignSchool.set("address", winFormPnlValues.address);
    	createCampaignSchool.set("emailAddress", txtPadmMSEmailItemId);
    	createCampaignSchool.set("url", winFormPnlValues.url);
    	createCampaignSchool.set("telephoneCountryCode", dlipAdmMScellCountrycodeId);
    	createCampaignSchool.set("telephoneNumber", numpAdmMScellNoId);
    	createCampaignSchool.set("fax", winFormPnlValues.fax);
    	createCampaignSchool.set("correspondenceStatus", winFormPnlValues.correspondenceStatus);
    	createCampaignSchool.set("active", winFormPnlValues.active);
    	createCampaignSchool.set("marketer", this$.getIdValueJson(winFormPnlValues.marketer));
    	createCampaignSchool.set("waiveApplicationFees", winFormPnlValues.waiveApplicationFees);
    	createCampaignSchool.set("classification", winFormPnlValues.classification);
    	createCampaignSchool.set("emis", winFormPnlValues.emis);
    	createCampaignSchool.set("quintile", winFormPnlValues.quintile);
    	createCampaignSchool.set("topHundred", winFormPnlValues.topHundred);
    	createCampaignSchool.set("wordsOpenWorlds", winFormPnlValues.wordsOpenWorlds);
    	createCampaignSchool.set("visitSchool", winFormPnlValues.visitSchool);
    	createCampaignSchool.set("careerMaties", winFormPnlValues.careerMaties);
    	createCampaignSchool.set("aliasSchool", winFormPnlValues.aliasSchool);
    	createCampaignSchool.set("country", this$.getIdValueJson(winFormPnlValues.country));
    	createCampaignSchool.set("countryRegion", this$.getIdValueJson(winFormPnlValues.countryRegion));
    	createCampaignSchool.set("city", this$.getIdValueJson(winFormPnlValues.city));
    	
    	
    	var docMaster = winform.down('#hidManageSchoolId');
    	this$.showInvalidIconOnField(winFormPnl);
    	var submitUrl = null;
    	var isUpdate = false;
    	if (docMaster.getSubmitValue() == null || docMaster.getSubmitValue() == "" || docMaster.getSubmitValue() === undefined) {
    		submitUrl = SERVERURL.CAMPAIGN_SCHOOL_CREATE;
    	} else {
    		submitUrl = SERVERURL.CAMPAIGN_SCHOOL_UPDATE;
    		isUpdate = true;
    	}
    	delete winFormPnlValues.customData;
    	 var contactDetailArray = [];
         if (!isNullOrEmpty(winFormPnl.down('#contactDetailHeaderPanelItemId').items.items)
        		 && winFormPnl.down('#contactDetailHeaderPanelItemId').items.items.length > 1) {
        	 for (var i = 0; i < winFormPnl.down('#contactDetailHeaderPanelItemId').items.items.length; i++) {
        		 if(!isNullOrEmpty(winFormPnlValues.contactDetails[i])){
        			 if(winFormPnlValues.telephoneCountryCode!=null &&  winFormPnlValues.telephoneNumber !=null){
        				 var newData = {
                				 "contactDetails" :winFormPnlValues.contactDetails[i],
                				 "name" : winFormPnlValues.name[i],
                				 "emailAddress" : winFormPnlValues.emailAddress[i],
                				 "telephoneCountryCode" : winFormPnlValues.telephoneCountryCode[i],
                				 "telephoneNumber" : winFormPnlValues.telephoneNumber[i]
                		 }; 
        			 }else{
        				 var newData = {
                				 "contactDetails" :winFormPnlValues.contactDetails[i],
                				 "name" : winFormPnlValues.name[i],
                				 "emailAddress" : winFormPnlValues.emailAddress[i],
                				 "telephoneCountryCode" : null,
                				 "telephoneNumber" : null
                		 }; 
        			 }
        			
            		 contactDetailArray.push(newData); 
        		 }
        	 }
         }else if(!isNullOrEmpty(winFormPnl.down('#contactDetailHeaderPanelItemId').items.items)
        		 && winFormPnl.down('#contactDetailHeaderPanelItemId').items.items.length == 1){
        	 if(!isNullOrEmpty(winFormPnlValues.contactDetails)){
        		 var newData = {
            			 "contactDetails" :winFormPnlValues.contactDetails,
            			 "name" : winFormPnlValues.name,
            			 "emailAddress" : winFormPnlValues.emailAddress,
            			 "telephoneCountryCode" : winFormPnlValues.telephoneCountryCode,
            			 "telephoneNumber" : winFormPnlValues.telephoneNumber
            	 }; 
        		 contactDetailArray.push(newData);
        	 }else{
        		 contactDetailArray=null;
        	 }
         }
         createCampaignSchool.set("campaignSchoolContactDetails", contactDetailArray);
    	var jsonFormatFormData = Ext.encode(createCampaignSchool.data);
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	Ext.Ajax.request({
    		type: 'rest',
    		url: submitUrl,
    		jsonData: jsonFormatFormData,
    		method: 'POST',
    		success: function(form, action) {
    			Ext.getBody().unmask();
    			if (!isNullOrEmpty(form.responseText) && form.responseText.length > 0 && form.responseText != 'Success') {
    				showWarningMessage(getTranslation('CAMPAIGN_MASTER'), getErrorTranslation(form.responseText));
    			} else {
    				winform.close();
    				this$.resetPageSetting(grid.getStore());
        			grid.getStore().load();
        			grid.getSelectionModel().deselectAll();
        			if (isUpdate) {
        				showSuccessMessage(getTranslation('CAMPAIGN_MASTER'), getCommonTranslation('UPDATE_CAMPAIGN_MASTER_MSG'));
        			} else {
        				showSuccessMessage(getTranslation('CAMPAIGN_MASTER'), getCommonTranslation('ADD_CAMPAIGN_MASTER_MSG'));
        			}
    			}
    		}
    	});
    },
    editManageSchool: function() {
        var me = this;
        var grid = me.getManageschoolgrid();
        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection();
            me.addManageSchool();
            if (records != "" && records != null && records != undefined) {
                var winForm = me.getStcmanageschoolformpadmstructure();
                var formPnl = winForm.down('form');
                formPnl.loadRecord(records[0]);
                winForm.down("#txtPadmMSEmailItemId").setValue(records[0].data.emailAddress);
                var educationDepartmentCombo = winForm.down("#educationDepartmentItemId");
                if( !isNullOrEmpty(educationDepartmentCombo) ){
                	if ( !isNullOrEmpty(records[0].data.educationDepartment) ) {
                		educationDepartmentCombo.store.load({
                			callback: function(record, operation, success) {
                				if (success) {
                					educationDepartmentCombo.setValue(records[0].data.educationDepartment.id);
                				}
                			}
                		});
                	}
                }
                var dlipAdmMSCategoryCombo = winForm.down("#dlipAdmMSCategoryItemId");
                if( !isNullOrEmpty(dlipAdmMSCategoryCombo) ){
                	if ( !isNullOrEmpty(records[0].data.schoolCategory) ) {
                		dlipAdmMSCategoryCombo.store.load({
                			callback: function(record, operation, success) {
                				if (success) {
                					dlipAdmMSCategoryCombo.setValue(records[0].data.schoolCategory.id);
                				}
                			}
                		});
                	}
                }
            	var country = winForm.down("#countryIteamId");
            	var countryRegion = winForm.down("#countryRegionIteamId");
            	var city = winForm.down("#cityIteamId");
            	var countryId = null;
            	var countryRegionId = null;
            	if ( !isNullOrEmpty(records[0].data.country) ) {
            		countryId = records[0].data.country.id;
            	}
            	if ( !isNullOrEmpty(records[0].data.countryRegion) ) {
            		countryRegionId = records[0].data.countryRegion.id;
            	}
            	if( !isNullOrEmpty(country) ){
                		if ( !isNullOrEmpty(records[0].data.country) ) {
                			countryRegion.setDisabled(false);
                			setTimeout(function(){
                				country.store.load({
                					callback: function(record, operation, success) {
                						if (success) {
                							country.setValue(records[0].data.country.id);
                						}
                					}
                				});
                			},100)
                		}
                	}

                	if( !isNullOrEmpty(countryRegion) ){
                		if ( !isNullOrEmpty(records[0].data.countryRegion) ) {
                			city.setDisabled(false);
                			setTimeout(function(){
                				countryRegion.store.getProxy().extraParams = {
                		            cid:countryId
                		        };
                				countryRegion.store.load({
                					callback: function(record, operation, success) {
                						if (success) {
                							countryRegion.setValue(records[0].data.countryRegion.id);
                						}
                					}
                				});
                			},100)
                		}
                	}                	
                	if( !isNullOrEmpty(city) ){
                		if ( !isNullOrEmpty(records[0].data.city) ) {
                			setTimeout(function(){
                				city.store.getProxy().extraParams = {
                		            id:countryRegionId
                		        };
                				city.store.load({
                					callback: function(record, operation, success) {
                						if (success) {
                							city.setValue(records[0].data.city.id);
                						}
                					}
                				});
                			},100)
                		}
                	}
                var dlipAdmMSExamBoardItemIdCombo = winForm.down("#dlipAdmMSExamBoardItemId");
                if( !isNullOrEmpty(dlipAdmMSExamBoardItemIdCombo) ){
                	if ( !isNullOrEmpty(records[0].data.examBoardMaster) ) {
                		dlipAdmMSExamBoardItemIdCombo.store.load({
                			callback: function(record, operation, success) {
                				if (success) {
                					dlipAdmMSExamBoardItemIdCombo.setValue(records[0].data.examBoardMaster.id);
                				}
                			}
                		});
                	}
                }
                var dlipAdmMScellCountrycodeIdCombo = winForm.down("#dlipAdmMScellCountrycodeId");
                if( !isNullOrEmpty(dlipAdmMScellCountrycodeIdCombo) ){
                	if ( !isNullOrEmpty(records[0].data.telephoneCountryCode) ) {
                		dlipAdmMScellCountrycodeIdCombo.store.load({
                			callback: function(record, operation, success) {
                				if (success) {
                					dlipAdmMScellCountrycodeIdCombo.setValue(records[0].data.telephoneCountryCode);
                				}
                			}
                		});
                	}
                }
                winForm.down("#numpAdmMScellNoId").setValue(records[0].data.telephoneNumber);
                winForm.down("#waiveApplicationFeespAdmMSItemId").setValue(records[0].data.waiveApplicationFees);
                var cosStatusField = winForm.down("#rbnpAdmCorrespondenceStatusItemId");
                this.setRadioFieldSchoolValue(cosStatusField,cosStatusField.getValue().correspondenceStatus);
                var activeStatusField = winForm.down("#rbnpAdmActiveItemId");
                this.setRadioFieldSchoolValue(activeStatusField,activeStatusField.getValue().active);
                var topStatusField = winForm.down("#rbnpAdmTopStatusItemId");
                this.setRadioFieldSchoolValue(topStatusField,topStatusField.getValue().topHundred);
                var wordOpenField = winForm.down("#rbnpAdmWordsOpenItemId");
                this.setRadioFieldSchoolValue(wordOpenField,wordOpenField.getValue().wordsOpenWorlds);
                var visitSchoolField = winForm.down("#rbnpAdmVisitSchoolItemId");
                this.setRadioFieldSchoolValue(visitSchoolField,visitSchoolField.getValue().visitSchool);
                var carretMatisField = winForm.down("#rbnpAdmCareerMatiesItemId");
                this.setRadioFieldSchoolValue(carretMatisField,carretMatisField.getValue().careerMaties);
                var dlipAdmMMarketerCombo = winForm.down("#dlipAdmMMarketerItemId");
                if( !isNullOrEmpty(dlipAdmMMarketerCombo) ){
                	if ( !isNullOrEmpty(records[0].data.marketer) ) {
                		dlipAdmMMarketerCombo.store.load({
                			callback: function(record, operation, success) {
                				if (success) {
                					dlipAdmMMarketerCombo.setValue(records[0].data.marketer.id);
                				}
                			}
                		});
                	}
                }
                if(!isNullOrEmpty(records[0].data.campaignSchoolContactDetails)){
                	 var contactDetailLength= records[0].data.campaignSchoolContactDetails.length;
  				   if(contactDetailLength>0){
  					   var fieldPanel=winForm.down('#contactDetailHeaderPanelItemId');
  					   Ext.Array.each(records[0].data.campaignSchoolContactDetails,function(value,index){
  						   if(index>0){
  							   me.addpAdmMSContactHeaderContainer();	
  						   }
  						   var filedContainer = fieldPanel.items.items[index];
  						   var dlipAdmMScontactDetail = filedContainer.items.items[0];
  						   var dlipAdmMScontactDetailStore = dlipAdmMScontactDetail.getStore();
  						   dlipAdmMScontactDetailStore.load({
  							   callback: function(rec, operation, success) {
  								   if (success) {
  									   dlipAdmMScontactDetail.setValue(value.contactDetails);
  								   }
  							   }
  						   });

  						   filedContainer.items.items[1].setValue(value.name);
  						   filedContainer.items.items[1].setReadOnly(false);
  						   filedContainer.items.items[1].setDisabled(false);
  						   filedContainer.items.items[2].setValue(value.emailAddress);
  						   filedContainer.items.items[2].setReadOnly(false);
  						   filedContainer.items.items[2].setDisabled(false);
  						   filedContainer.items.items[3].setDisabled(false);
  						   var telephoneCountryCode = filedContainer.items.items[3].items.items[0];
  						   var telephoneCountryCodeStore = telephoneCountryCode.getStore();
  						   telephoneCountryCodeStore.load({
  							   callback: function(rec, operation, success) {
  								   if (success) {
  									   telephoneCountryCode.setValue(value.telephoneCountryCode);
  								   }
  							   }
  						   });
  						   filedContainer.items.items[3].items.items[1].setValue(value.telephoneNumber);
  						   if(!isNullOrEmpty(filedContainer.items.items[5])){
  							   filedContainer.items.items[5].setDisabled(false);
  						   }
  					   });

  				   }
                }
            }
        } else {
        	showWarningMessage(getTranslation('CAMPAIGN_MASTER'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
        }
    },setRadioFieldSchoolValue: function(field,fieldItem){
    	if(fieldItem=="true"){
    		field.items.items[0].setValue(true);
    		field.items.items[1].setValue(false);
    	}else{
    		field.items.items[0].setValue(false);
    		field.items.items[1].setValue(true);
    	}
    },
    showManageSchoolForm: function() {
    	var $this = this;
        var winForm= this.getManageschoolformwindow();
        if (isEmpty(winForm)) {
        	winForm = Ext.widget('manageschoolformwindow');
        }
        winForm.show();
        winForm.body.on('click', function() {
			var filter = winForm.down('manageSchoolForm');
			$this.hideInvalidIconFromField(filter);
	       });
    },
    deleteManageSchool: function() {
        var grid = this.getManageschoolgrid();
        var grdStore = grid.getStore();
        if (grid.getSelectionModel().getCount() > 0) {
        	showConfirmMessage(getTranslation('CAMPAIGN_MASTER'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                    if (btn == 'yes') {
                        if (grid.getSelectionModel().getCount() > 0) {
                            var records = grid.getSelectionModel().getSelection();
                            for (var count = 0; count < records.length; count++) {
                                var id = "";
                                if (records[count].get("id") != "" && records[count].get("id") != undefined && records[count].get("id") != null) {
                                    id = records[count].get("id");
                                }
                                Ext.Ajax.request({
                                    type: 'rest',
                                    method: 'DELETE',
                                    url: SERVERURL.CAMPAIGN_SCHOOL_DELETE + '?id=' + id,
                                    headers: {
                                        'Content-Type': 'application/json'
                                    },
                                    params: {
                                        id: id
                                    },
                                    success: function(form, action) {
                                    	if (form.responseText == 0) {
                                    		 showWarningMessage(getTranslation('CAMPAIGN_MASTER'), getErrorTranslation('CAMPAIGN_MASTER_DEPENDENCY_EXIST_ON_DELETE'));
                                    	} else {
                                    		showSuccessMessage(getTranslation('CAMPAIGN_MASTER'), getCommonTranslation('DELETE_CAMPAIGN_MASTER_MSG'));
                                        	grdStore.reload();
                                        	grid.getStore().reload();
                                    	}
                                    	
                                    },
                                    failure: function(form, action) {
                                        showWarningMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
                                    }
                                });
                            }
                        }
                    }
        	});
        } else {
        	showWarningMessage(getTranslation('CAMPAIGN_MASTER'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    resetCreateSchoolpAdmMSform:function(){
    	var $this = this;
    	var form = $this.getManageschoolcreationpadmform().getForm();
    	form.reset();
    	form.findField('countryRegion').setDisabled(true);
    	form.findField('city').setDisabled(true);
    	if(!form.findField('country').isVisible() && !form.findField('countryRegion').isVisible()){
    		form.findField('city').setDisabled(false);
    	}else if(!form.findField('country').isVisible()){
    		form.findField('countryRegion').setDisabled(false);
    	}else if(!form.findField('countryRegion').isVisible()){
    		form.findField('city').setDisabled(false);
    	}

    	$this.removeContactDetailsDynamicFields();
    },
    //******* remove dynamic fileds*************
    removeContactDetailsDynamicFields : function(){
    	var form = this.getManageschoolcreationpadmform();
    	var contactPanel = form.down('#contactDetailHeaderPanelItemId');
    	for(var i=contactPanel.items.length-1; i>0;i--){
    		contactPanel.remove(contactPanel.items.items[i]);
    	}
    	contactPanel.items.items[0].items.items[1].setDisabled(true);
    	contactPanel.items.items[0].items.items[2].setDisabled(true);
    	contactPanel.items.items[0].items.items[3].setDisabled(true);
    	if(contactPanel.items.items[0].items.items[4].isHidden()){
    		contactPanel.items.items[0].items.items[4].hide();
    	}else{
    		contactPanel.items.items[0].items.items[4].show();
    	}
    	form.doLayout();
    },

    searchMapSchoolPriority: function(){
    	var me = this;
    	var formPnl = me.getMapschoolpriorityform();
    	var grid = me.getMapschoolprioritygrid();

    	var schoolFld = grid.down('#schoolId');
    	var brandCampusFld = formPnl.down('#brandCampusId');
    	var intakeYearFld = formPnl.down('#intakeYearId');
    	
    	if(!isNullOrEmpty(brandCampusFld.getValue()) && !isNullOrEmpty(intakeYearFld.getValue())){
    		schoolFld.reset();
    		/*schoolFld.getStore().getProxy().extraParams = {
    			academyLocationIds: brandCampusFld.getValue(),
    			intakeYearId: intakeYearFld.getValue()
        	}*/
        	var store = grid.getStore();
    		store.pageSize=1000;
    		store.limit=1000;
        	store.getProxy().extraParams = {
        		academyLocationId: brandCampusFld.getValue(),
        		intakeYear: intakeYearFld.getValue()
        	}
        	store.sorters.clear();
        	store.loadPage(1,{
        		callback:function(records, operation, success){
        			if(records.length>0){
        				grid.down('#mapSchoolSubmitBtn').setDisabled(false);
        				grid.down('#copyMappingBtn').setDisabled(false);
        				grid.down('#resetBtnGrid').setDisabled(false);
        				grid.down('#schoolId').setDisabled(false);
        				grid.down('#setDefaultPriorityBtn').setDisabled(false);
        				grid.down('#exportReportItemId').setDisabled(false);
        				me.resetMapSchoolPriorityGridHeaderFreeze();
        			}
        		}
        	});
    	}
    },
    addMultipleCampusIntakeRow: function(obj){
    	var me = this;
    	var formPnl = me.getMapschoolpriorityform();
    	var grid = me.getMapschoolprioritygrid();
    	var formWindow = me.getCopymappingprioritywindow();

    	var stopContiner = formWindow.down('#brandCampusContainerId');
    	// var timeFieldsCount = stopContiner.items.length;
    	var panelItem = new Array();
    	var fieldContainer=obj.up('fieldcontainer');
    	var newcont=stopContiner.items.items.length;
    	var insertPosition=newcont+1;
    	panelItem.push({
    		xtype : 'fieldcontainer',
    		width: '100%',
    		layout : 'hbox',
    		defaults: {
    			width: 256,
    			labelAlign: 'top'
    		},
    		items : [{
				xtype: 'customcombobox',
				name: 'brandCampusWin',
				itemId: 'brandCampusWinId1',
				valueField: 'id',
				displayField: 'value',
				store: 'user.UserAcademyLocationStore',
				minChars:3,
				queryParam:'qry',
				width : 462,
				typeAhead:false,
				//triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				//enableKeyEvents  : 'true',
				hideTrigger:false,
				allowBlank:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				//triggerAction: '',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			}, {
				xtype: 'customcombobox',
				name: 'intakeYearWin',
				itemId: 'intakeYearWinId1',
				store: Ext.create('Academia.store.common.IntakeYearStore'),
				valueField: 'id',
				displayField: 'value',
				emptyText: getCommonTranslation('SELECT'),
				editable: false,
				forceSelection: true,
				allowBlank: false
			},{
    			xtype:'fieldcontainer',
    			items:[{
    				xtype: 'button',
    				itemId: 'delFilterBtn',
    				cls: 'CustomBodyBtnReject',
    				glyph: ICONGLYPH.DELETEGLYPH,
    				tooltip: getCommonTranslation('DELETE'),
    				listeners:{
    					click:function(obj){
    						var copyWin = me.getCopymappingprioritywindow();
    						var container = obj.up('fieldcontainer').up('fieldcontainer');
    						var panelContiner = copyWin.down('#brandCampusContainerId');
    						panelContiner.remove(container);
    						copyWin.down('form').getForm().checkValidity();
    					}}
    			},{
    				xtype: 'button',
    				itemId: 'addNewRowCampusBtn',
    				cls: 'CustomBodyBtnSettings',
    				text: getCommonTranslation('ADDBUTTONTEXT'),
    				tooltip: getCommonTranslation('ADD')
    			}]
    		}]
    	});
    	stopContiner.insert(insertPosition,panelItem);
    	stopContiner.doLayout();
    },
    
    saveSchoolPriorityMappingRecord: function(btn){
    	var me = this;
    	var formPnl = me.getMapschoolpriorityform();
    	var grid = me.getMapschoolprioritygrid();
    	var store = grid.getStore();
    	var storeArray=[];
    	var brandCampusFld = formPnl.down('#brandCampusId');
		var intakeYearFld = formPnl.down('#intakeYearId');
    	if(store.getCount()>0){
    		store.data.items.forEach(function(obj){
    			var data = {
    					'id':obj.data.id,
    					'campaignSchoolId':obj.data.campaignSchoolId,
    					'academyLocationId':brandCampusFld.getValue(),
    					'intakeYearId':intakeYearFld.getValue(),
    					'schoolPriority':obj.data.schoolPriority
    			};
    			storeArray.push(data);
			});
    	}
    	
    	showConfirmMessage(getCommonTranslation('MAP_SCHOOL_PRIORITY'), getCommonTranslation('SCHOOL_PRIORITY_EXISTING_MAP_MSG'), function(btn, text) {
			if (btn == 'yes') {
				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				var formData = Ext.encode(storeArray);
				Ext.Ajax.timeout= 90000;
				Ext.Ajax.request({
					type : 'rest',
					url : SERVERURL.PATH_CSPM_SAVE_MAPPING,
					jsonData : formData,
					method : 'POST',
					success : function(frm, action) {
						Ext.getBody().unmask();
						grid.getSelectionModel().deselectAll();
						store.load({
							callback:function(){
								me.resetMapSchoolPriorityGridHeaderFreeze();
							}
						});
						showSuccessMessage(getCommonTranslation('MAP_SCHOOL_PRIORITY'), getCommonTranslation('SCHOOL_PRIORITY_MAPPED_MSG'));
					}
				});
			}
		});
    },
    
    saveCopyMappingSchoolPriority: function(){
    	var me = this;
    	var formPnl = me.getMapschoolpriorityform();
    	var grid = me.getMapschoolprioritygrid();
    	var formWindow = me.getCopymappingprioritywindow();
    	var brandCampusContainerFld = formWindow.down('#brandCampusContainerId');
    	var brandCampusIdVal = formPnl.down('#brandCampusId').getValue();
		var intakeYearIdVal = formPnl.down('#intakeYearId').getValue();
		var storeArray=[];
		if(brandCampusContainerFld.items.items.length>0){
			brandCampusContainerFld.items.items.forEach(function(obj){
				
				var brandCampusVal = obj.down('[name=brandCampusWin]').getValue();
				var intakeYearVal = obj.down('[name=intakeYearWin]').getValue();
    			var data = {
    					'academyLocationId':brandCampusVal,
    					'intakeYearId':intakeYearVal
    			};
    			storeArray.push(data);
			});
		}
		var finalObj = {
				'intakeYearId': intakeYearIdVal,
				'academyLocationId': brandCampusIdVal,
				'campaignSchoolPriorityMappingModelList':storeArray
		}
		
		showConfirmMessage(getCommonTranslation('MAP_SCHOOL_PRIORITY'), getCommonTranslation('SCHOOL_PRIORITY_EXISTING_MAP_MSG'), function(btn, text) {
			if (btn == 'yes') {
				me.applyWindowMask();
				var formData = Ext.encode(finalObj);
				Ext.Ajax.timeout= 90000;
				Ext.Ajax.request({
					type : 'rest',
					url : SERVERURL.PATH_CSPM_COPY_MAPPING,
					jsonData : formData,
					method : 'POST',
					success : function(frm, action) {
						me.hideWindowMask();
						formWindow.close();
						grid.getSelectionModel().deselectAll();
						grid.getStore().load({
							callback:function(){
								me.resetMapSchoolPriorityGridHeaderFreeze();
							}
						});
						showSuccessMessage(getCommonTranslation('MAP_SCHOOL_PRIORITY'), getCommonTranslation('SCHOOL_PRIORITY_MAPPED_MSG'));
					}
				});
			}
		});
    },
    
    saveDefaultSchoolPriorityWindow: function(btn){
    	var me = this;
    	var formPnl = me.getMapschoolpriorityform();
    	var grid = me.getMapschoolprioritygrid();
    	var formWindow = me.getSetdefaultprioritywindow();
    	var store = grid.getStore();
    	var storeArray=[];
    	var brandCampusFld = formPnl.down('#brandCampusId');
		var intakeYearFld = formPnl.down('#intakeYearId');
		if (grid.getSelectionModel().getCount() > 0) {
			var records = grid.getSelectionModel().getSelection();
            if (records != "" && records != null && records != undefined) {
            	var schoolPriority = formWindow.down('#schoolPriorityId').getValue();
            	records.forEach(function(obj){
        			var data = {
        					'id':obj.data.id,
        					'campaignSchoolId':obj.data.campaignSchoolId,
        					'academyLocationId':brandCampusFld.getValue(),
        					'intakeYearId':intakeYearFld.getValue(),
        					'schoolPriority':schoolPriority
        			};
        			storeArray.push(data);
    			});
            }
		}
    	
    	showConfirmMessage(getCommonTranslation('MAP_SCHOOL_PRIORITY'), getCommonTranslation('SCHOOL_PRIORITY_EXISTING_MAP_MSG'), function(btn, text) {
			if (btn == 'yes') {
				me.applyWindowMask();
				var formData = Ext.encode(storeArray);
				Ext.Ajax.timeout= 90000;
				Ext.Ajax.request({
					type : 'rest',
					url : SERVERURL.PATH_CSPM_SAVE_MAPPING,
					jsonData : formData,
					method : 'POST',
					success : function(frm, action) {
						me.hideWindowMask();
						formWindow.close();
						grid.getSelectionModel().deselectAll();
						grid.getStore().load({
							callback:function(){
								me.resetMapSchoolPriorityGridHeaderFreeze();
							}
						});
						showSuccessMessage(getCommonTranslation('MAP_SCHOOL_PRIORITY'), getCommonTranslation('SCHOOL_PRIORITY_MAPPED_MSG'));
					}
				});
			}
		});
    },
    
    showHideMapSchoolPriorityTab: function(structure, permissionsMap) {
        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        var mapSchoolPriorityTab = false;
        
        for (var i = 0; i < permissionList.length; i++) {
            if (permissionList[i] === "VIEW") {
            	mapSchoolPriorityTab = true;
            }
        }

        this.showMapSchoolPriorityTab(mapSchoolPriorityTab, structure);
    },
    showMapSchoolPriorityTab: function(mapSchoolPriorityTab, structure) {
    	var panelItem = new Array();
    	var newcont = structure.items.items.length;
    	var insertPosition = newcont + 1;
    	panelItem.push({
    		xtype: 'mapschoolprioritytabstructure',
    		itemId: 'mapschoolprioritytabstructureItemId',
    		title: getCommonTranslation('MAP_SCHOOL_PRIORITY')
    	});

    	if (mapSchoolPriorityTab) {
    		structure.insert(insertPosition, panelItem);
    	}
    	
    },
    
    selectBrandCampusWin: function(combo, records){
    	var me = this;
    	var formWindow = me.getCopymappingprioritywindow();
    	var formPnl = me.getMapschoolpriorityform();
    	var brandCampusIdVal = formPnl.down('#brandCampusId').getValue();
		var intakeYearIdVal = formPnl.down('#intakeYearId').getValue();
		var arryObj=[];
    	var keyObj = brandCampusIdVal + '_' + intakeYearIdVal;
		var brandCampusContainerFld = formWindow.down('#brandCampusContainerId');
		arryObj.push(keyObj);
		
		if(brandCampusContainerFld.items.items.length>0){
			brandCampusContainerFld.items.items.forEach(function(obj){
				var selectedCombo = combo;
				var brandCampusWinFld = obj.down('[name=brandCampusWin]');
				var intakeYearWinFld = obj.down('[name=intakeYearWin]');
				var brandCampusVal = brandCampusWinFld.getValue();
				var intakeYearVal = intakeYearWinFld.getValue();
				
				var intakeYearRawValue = intakeYearWinFld.getRawValue();
				var brandCampusRawValue = brandCampusWinFld.getRawValue();
				
				if(!isNullOrEmpty(brandCampusVal) && !isNullOrEmpty(intakeYearVal)){
					var keyObjNew = brandCampusVal + '_' + intakeYearVal;
					if (Ext.Array.contains(arryObj, keyObjNew)) {
						showWarningMessage(getCommonTranslation("ALERT"), 'Intake Year '+ intakeYearRawValue + ' for '+ brandCampusRawValue +' is a duplicate selection');
						if(selectedCombo.getName() == "intakeYearWin"){
							selectedCombo.prev().reset();
						}
						else if(selectedCombo.getName() == "brandCampusWin"){
							selectedCombo.next().reset();
						}
						
						selectedCombo.reset();
						return;
					}
					else{
						arryObj.push(keyObjNew);
					}
				}
			});
		}
    },
    doAccessMapSchoolPriorityGridButton: function(grid, privilegesMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, privilegesMap);
    	var exportReportItemId = grid.down('#exportReportItemId');
    	if(exportReportItemId!=null){
    		exportReportItemId.setVisible(false);
    	}
    	var setDefaultPriorityBtn = grid.down('#setDefaultPriorityBtn');
    	if(setDefaultPriorityBtn!=null){
    		setDefaultPriorityBtn.setVisible(false);
    	}

    	Ext.each(permissionList, function(privilege) {
    		if (privilege == 'EXPORTREPORTS') {
    			if(exportReportItemId!=null){
    				exportReportItemId.setVisible(true);
    			}
    		}
    		if (privilege == 'SET_DEFAULT_PRIORITY') {
    			if(setDefaultPriorityBtn!=null){
    				setDefaultPriorityBtn.setVisible(true);
    			}
    		}
    	});
    },
    exportXlsMapSchoolPriority : function() {
    	var $this = this;
    	var formPnl = $this.getMapschoolpriorityform();
    	var dt = new Date();
    	var dateString = Ext.Date.format(dt, 'YmdHis'); 
    	var reportTitle = "School Priority List"+"_"+dateString;
    	var code = 'MAP_PRIORITY_XCEL_EXPORT_REPORT';

    	var brandCampusFld = formPnl.down('#brandCampusId');
    	var intakeYearFld = formPnl.down('#intakeYearId');

    	var academyLocationIds =$this.getCurrentAcademyLocation();
    	if(brandCampusFld!=null){
    		brandCampus = brandCampusFld.getValue();
    	}
    	if(intakeYearFld!=null){
    		intakeYear= intakeYearFld.getValue();
    	}

    	var reportParams = new Object();
    	reportParams.brandCampus = brandCampus;
    	reportParams.intakeYear = intakeYear;

    	reportParams.headerName = getProgramandcourseTranslation('Map Priority Report');
    	$this.exportJRXMLReport(code, reportParams, reportTitle, '.vnd.ms-excel', SERVERURL.PATH_EXPORT_XCEL_MAPING_SCHOOL_PRIORITY);
    },
    
    // ************ Manage School Contact Panel *************
    addpAdmMSContactHeaderContainer: function() {
		var $this = this;
		var createcourseform=$this.getManageschoolcreationpadmform();
		var indx;
		var panelContiner = createcourseform.down('#contactDetailHeaderPanelItemId');
		if(panelContiner.items.items.length<=5){
			indx = panelContiner.items.items.length;
			var panelItem = new Array();
			panelItem.push({
				xtype : 'fieldcontainer',
				defaults : {
					labelAlign : 'top',
					width:256
				},
				style:{'margin-left':'0px'},
				layout : {
					type : 'hbox'
				},
				items:[{
					xtype: 'customcombobox',
					itemId: 'dlipAdmMScontactDetailItemId',
					name: 'contactDetails',
					fieldLabel: getCommonTranslation('CONTACT_DETAIL'),
					labelAlign: 'top',
					rowIndx:indx,
					store: 'setup.campaignmaster.StoPadmCreateSchoolContactDetailStore',
					valueField: 'id',
					displayField: 'value',
				    forceSelection:true,
				    allowBlank:false,
				    listeners:{
						select:function(obj,rec,value){
							var departmentId=rec[0].get('id');
							var flag = true;
							var pnlMain = obj.up("#contactDetailHeaderPanelItemId");
							var rowIndx = obj.rowIndx;
							if(!isNullOrEmpty(pnlMain)){
								pnlMain.items.each(function(item, index, items) {
									var deptNameVal = item.down("[name=contactDetails]").getValue();
									if(departmentId == deptNameVal && rowIndx != index){
										flag = false;
										return false;
									}
								});

								if(flag){
									var nextSiblingField = obj.nextSibling();
									nextSiblingField.setDisabled(false);
									var nextSiblingField1 = obj.nextSibling().nextSibling();
									nextSiblingField1.setDisabled(false);
									var nextSiblingField2 = obj.nextSibling().nextSibling().nextSibling();
									nextSiblingField2.setDisabled(false);
									var nextSiblingField3 = obj.nextSibling().nextSibling().nextSibling().nextSibling();
									nextSiblingField3.setDisabled(false);
									var nextSiblingField4 = obj.nextSibling().nextSibling().nextSibling().nextSibling().nextSibling();
									nextSiblingField4.setDisabled(false);
								}
								else{
									obj.reset();
									var nextSiblingField = obj.nextSibling();
									nextSiblingField.reset();
									nextSiblingField.setDisabled(true);
									var nextSiblingField1 = obj.nextSibling().nextSibling();
									nextSiblingField1.reset();
									nextSiblingField1.setDisabled(true);
									var nextSiblingField2 = obj.nextSibling().nextSibling().nextSibling();
									nextSiblingField2.items.items[0].reset();
									nextSiblingField2.items.items[1].reset();
									nextSiblingField2.setDisabled(true);
									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CONTACT_DETAIL_ALREADY_SELECTED_MSG'));
									return false;
								}
							}
						}
					}
				}, {
					xtype:'textfield',
					fieldLabel: getCommonTranslation('NAME'),
					enableKeyEvents : true,
					itemId: 'txtpAdmMSNameItemId',
					labelAlign: 'top',
					disabled:true,
					name: 'name',
					maxLength: 40,
				},{
					xtype: 'textfield',
					fieldLabel: getAdmissionTranslation('EMAIL_ID'), //Email ID
					name: 'emailAddress',
					vtype: 'email',
					disabled:true,
					labelAlign: 'top',
					itemId: 'txtpAdmMSemailIdItemId',
					maxLength: '100'
				},{
					xtype:'fieldcontainer',
					labelSeparator : '',
					fieldLabel: getCommonTranslation('TELEPHONE'),
					itemId:'telephonepAdmMSContactNumberItemId',
					layout:'hbox',
					disabled:true,
					labelAlign:'top',
					items:[{
						xtype: 'customcombobox',
						itemId: 'dlipAdmMScellPanelCountrycodeId',
						valueField: 'isdCode',
						displayField: 'isdCode',
						store: 'common.CountryStore',
						triggerAction: 'all',
						name: 'telephoneCountryCode',
						editable: false,
						width: 80,
						emptyText: getCommonTranslation('CODE')
					}, {
						xtype: 'numberfield',
						name: 'telephoneNumber',
						itemId: 'numpAdmMSPanelcellNoId',
						minLength: 0,
						maxLength: 11,
						width: 145,
						emptyText: 'Mobile Number',
						hideTrigger: true
					}]
				},{
					xtype: 'button',
					glyph: ICONGLYPH.DELETEGLYPH,
					itemId: 'containerDetailedpAdmMSDeleteButton',
					width: 'auto',
					style:{'margin-top':'24px'},
					cls: 'CustomBodyBtnReject',
					tooltip: getCommonTranslation('DELETETOOLTIP')
				},{
					xtype: 'button',
					itemId: 'btnAddpAdmMSContactHeader',
					cls: 'CustomBodyBtnSettings',
					disabled:true,
					style:{'margin-top':'24px'},
					text: getCommonTranslation('ADDBUTTONTEXT'),
					tooltip: getCommonTranslation('ADD')
				}]

			});
			panelContiner.add(panelItem);
			this.containerpAdmMSHideShowDetails(panelContiner);
			panelContiner.doLayout();
		}
	},
	containerpAdmMSHideShowDetails: function(detailedPanel) {
   	 var this$ = this;
   	 var form = this.getManageschoolcreationpadmform();
   	 var cnt = detailedPanel.items.length;
   	 detailedPanel.items.each(function(item, index, items) {
   		 var addButton = item.getComponent(item.items.length - 1);
   		 if (index == (items - 1)) {
   			 if (addButton != null) {
   				 addButton.show();
   				 addButton.setDisabled(false);
   				 if(cnt == 5){
   					 addButton.hide();
   				 }
   			 }
   		 } else {
   			 if (addButton != null) {
   				 addButton.hide();
   			 }
   		 }
   	 });
    },
    deletepAdmMSContactHeaderContainer: function(deleteButton) {
   	 var this$ = this;
   	 var form=this$.getManageschoolcreationpadmform();
   	 var departmentPanel = form.down('#contactDetailHeaderPanelItemId');
   	 var container = deleteButton.up('fieldcontainer');

   	 if (container != null && departmentPanel != null) {
   		 if (departmentPanel.items.length > 1) {
   			 departmentPanel.remove(container);
   			 form.getForm().checkValidity();
   			 this$.containerpAdmMSHideShowDetails(departmentPanel);
   		 }
   	 }
   	 //departmentPanel.doLayout();
    },
	 getIdValueJson: function(id, value) {
			if (id) return {
				id: id,
				value: value
			};
		},
		
		loadDFRForPlusIcon: function(plusIcon){
          	var $this = this;
          	Ext.Ajax.request({
          		type: 'rest',
          		async: false,
          		url: SERVERURL.COMMON_FORM_FIELD_INFO,
          		params: {
          			screenName: 'manageschoolcreationpadmform',
          			academyLocationId: this.getCurrentAcademyLocation(),
          			languageCode:'en'
          		},
          		method: 'GET',
          		success: function(res, action) {
          			var response = Ext.decode(res.responseText);
          			var records=response.manageschoolcreationpadmform;
      				for(i in records){
          			if( Object.keys(response).length > 0 ){
          					if(records[i].formFieldId=='btnAddpAdmMSContactHeader' && records[i].isVisible==false) {
          						plusIcon.setVisible(false);
          						break;
          					}
                       }
          		  }
          		}		
          		
          	});
          	
          }  
		
});