/**
 * @author ravindra
 * 
 */
Ext.define('Academia.controller.setup.loginpage.LoginPageConfigurationController', {
	extend: 'Academia.controller.base.BaseController',
	models : [],
	stores : [
		'setup.droolrules.DroolMasterStore','setup.loginPageSetup.LoginPageUrlStore'
	],
	views : [
		'setup.loginPageContent.LoginPageContentStructure',
		'setup.loginPageContent.LoginPageConfigurationForm'
	],
	config: {
		DROOL_RULES_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('DROOL_RULES_PRIVILEGES')
	},
	refs : [{
 	   ref: 'contentPanel',
	   selector: 'contentPanel'
   },{
		ref: 'loginpagecontentstructure',
		selector: 'loginpagecontentstructure'
	},{
		ref: 'loginpageconfigurationform',
		selector: 'loginpageconfigurationform'
	}],
	init : function() {
		this.control({
			'loginpageconfigurationform':{
				afterrender: function(form){
					var me = this;
					var structure = me.getLoginpagecontentstructure();
					structure.down('#urlItemId').getStore().load();
					setTimeout(function(){
						me.loadAllData(form,'DEFAULT_PAGE');
					},100);
				}
			},
			'loginpageconfigurationform button[itemId=submitHomePageButtonId], loginpageconfigurationform button[itemId=submitStudentPortalButtonId], loginpageconfigurationform button[itemId=submitParentPortalButtonId], loginpageconfigurationform button[itemId=submitApplicantPortalButtonId], loginpageconfigurationform button[itemId=submitAdminPortalButtonId], loginpageconfigurationform button[itemId=submitTeacherPortalButtonId],loginpageconfigurationform button[itemId=submitAlumniPortalButtonId]':{
				click: this.saveBtnClick
			},
			'loginpagecontentstructure customcombobox[itemId=urlItemId]':{
				select:function(combo, records, eOpts ){
					var form = this.getLoginpagecontentstructure();
					if(records && records.length>0 && records[0].data.value!='Default Page'){
					  form.down('#urlHyperLinkItemId').setValue(records[0].data.value);
					}else{
						form.down('#urlHyperLinkItemId').setValue('');
					}
					var form = this.getLoginpageconfigurationform();
					this.loadAllData(form,records[0].data.id);
				}
			}
		})
	},
	saveBtnClick: function(btn){
		var $this = this;
		var structure = $this.getLoginpagecontentstructure();
		var form = btn.up('panel')
		var editorValue = form.down('#templateCKEditor_'+btn.pageCode).getValue();
		var isCaptchaVisible = form.down('#isCaptchaVisible_'+btn.pageCode) ? form.down('#isCaptchaVisible_'+btn.pageCode).getValue() : false;
		var termsConditions = form.down('#termsConditions_'+btn.pageCode) ? form.down('#termsConditions_'+btn.pageCode).getValue() : false;
		var loginPageUrlId;
		if(structure.down('#urlItemId').getValue()!='DEFAULT_PAGE'){
			loginPageUrlId = {
				id:structure.down('#urlItemId').getValue()
			};
		}
		var pageName = btn.pageCode;
		
		var loginpagecontentstructure = form.up('loginpagecontentstructure');
		var captchaSiteKey = loginpagecontentstructure.down('#captchaSiteKey').getValue();
		var captchaSecretKey = loginpagecontentstructure.down('#captchaSecretKey').getValue();
		
		if(!isNullOrEmpty(captchaSiteKey) && !isNullOrEmpty(captchaSecretKey)){
			this.addDataToLoginPageContent(pageName, editorValue, captchaSiteKey, captchaSecretKey, isCaptchaVisible,loginPageUrlId,termsConditions);
		}
		else{
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CAPTCHA_KEY_REQUIRED_MESSAGE')); 
		}
	},
	addDataToLoginPageContent : function(pageName, editorValue, captchaSiteKey, captchaSecretKey, isCaptchaVisible,loginPageUrlId,termsConditions){
		var me = this;
		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'));
		var urlCombo = contentPanel.getActiveTab().down('#urlItemId');
		var hyperLinkValue = contentPanel.getActiveTab().down("#urlHyperLinkItemId").getValue();
		var linkUpperCase=hyperLinkValue.replace(/https?:\/\//, '').replace(/\/$/, '').replace(/\./g, '_').toUpperCase();
		if(urlCombo.getValue()=='DEFAULT_PAGE'){
			linkUpperCase='PAGE';
		}
		var comboRecords = urlCombo.store.data.items;
		var allUrlsArray = Ext.Array.pluck(Ext.Array.pluck(comboRecords,"data"),"value");
		var finalPages = [];
		var urlPageMappingObj = {};
        var formData = new Object();
        formData.pageName = pageName;
        formData.htmlContent = editorValue;
        formData.captchaKey = captchaSiteKey;
        formData.captchaSecretKey = captchaSecretKey;
        formData.isCaptchaVisible = isCaptchaVisible;  
        formData.isTermsAndConditionsVisible = termsConditions;
        formData.loginPageURLId = loginPageUrlId;
        
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.LOGIN_PAGE_CONFIGURATION_CREATE,
            jsonData: Ext.encode(formData),
            method: 'POST',
            success: function(response, form) {
            	var data = Ext.decode(response.responseText);
            	if(!isNullOrEmpty(data)){
            		showSuccessMessage(getCommonTranslation('LOGIN_PAGE_CONTENT'),getCommonTranslation('CONFIG_SAVED_SUCCESSFULLY'));
            		CONST['SK']=captchaSiteKey;
            		CONST['SECK']=captchaSecretKey;
            		CONST['IS_CAPTCHA_ENABLED_'+pageName.toUpperCase()] = isCaptchaVisible;
            	
            		Ext.each(allUrlsArray, function(currentURL){
            			if(!isNullOrEmpty(currentURL)){
            				if(currentURL == "Default Page"){
            					finalPages.push("PAGE");
            					urlPageMappingObj["default"] = "PAGE";
            				}
            				else{
            					finalPages.push(currentURL.replace(/https?:\/\//, '').replace(/\/$/, '').replace(/\./g, '_').toUpperCase()); 
            					urlPageMappingObj[currentURL] = currentURL.replace(/https?:\/\//, '').replace(/\/$/, '').replace(/\./g, '_').toUpperCase();
            				}
            			}
            		});
            		
            		CONST.URL_PAGE_MAPPING=urlPageMappingObj;
            		
            		Ext.each(finalPages, function(currentPage){
            			if(!CONST[currentPage]){
            				CONST[currentPage] = {};
            			}
            			Ext.each(Object.keys(CONST['PAGE']), function(pageKey){
            				if(pageKey==pageName && CONST[currentPage][pageKey] && currentPage==linkUpperCase){
            					CONST[currentPage][pageKey]=editorValue;
            				}
            				else if(!CONST[currentPage][pageKey]){
            					CONST[currentPage][pageKey] = CONST['PAGE'][pageKey];
            				}
            				else{
            					CONST[currentPage][pageKey] = CONST[currentPage][pageKey];
            				}
            			});
            		});

                	var fileData ="CONST="+JSON.stringify(CONST);
                	var myblob = new Blob([fileData], {
                	    type: 'text/plain'
                	});
                	var myFileObject = me.blobToFile(myblob,'constants.txt');
                	
                	var formData = new FormData();
                	formData.append('file', myFileObject);
                	formData.append('filePath', 'constants.js');
                	var xhr = new XMLHttpRequest();
                	xhr.open("POST", 'writeFileConstants.php');
                	xhr.send(formData);
                	Ext.getBody().unmask();
            	}
            }
        });
	},
	loadAllData: function(form,loginPageUrlId){
	    //var url = SERVERURL.LOGIN_PAGE_CONFIGURATION_FIND_ALL;
		var url = SERVERURL.PATH_FIND_ALL_BY_LOGINPAGE_URL_ID;
		var logInPageId;
		if(loginPageUrlId!='DEFAULT_PAGE'){
			logInPageId=loginPageUrlId;
		}
		Ext.Ajax.request({
			type: 'rest',
			params:{
				logInPageURLId:logInPageId
			},
			url: url,//+'?pageName=homePage',
			method: 'GET',
			success : function(response){
				var responseText = Ext.decode(response.responseText);
				if(responseText.length){
					var captchaSiteKey = !isNullOrEmpty(responseText[0].captchaKey) ? responseText[0].captchaKey : CONST.SK;
					var captchaSecretKey = !isNullOrEmpty(responseText[0].captchaSecretKey) ? responseText[0].captchaSecretKey : CONST.SECK;
					form.up('loginpagecontentstructure').down('#captchaSiteKey').setValue(captchaSiteKey);
					form.up('loginpagecontentstructure').down('#captchaSecretKey').setValue(captchaSecretKey);
				}
				Ext.each(responseText, function(currentData){
					form.down('#templateCKEditor_'+currentData.pageName).setValue(currentData.htmlContent);
					
					if(form.down('#isCaptchaVisible_'+currentData.pageName)){
						form.down('#isCaptchaVisible_'+currentData.pageName).setValue(currentData.isCaptchaVisible);
					}
					if(form.down('#termsConditions_'+currentData.pageName)){
						form.down('#termsConditions_'+currentData.pageName).setValue(currentData.isTermsAndConditionsVisible);
					}
				});
			}
		});
	},
	blobToFile: function(theBlob, fileName){
        theBlob.lastModifiedDate = new Date();
        theBlob.name = fileName;
        return theBlob;
    }
});