/**
 * @author Shashank Jain
 *  
 */
Ext.define('Academia.controller.setup.sessionlogouttimesetup.SessionLogoutTimeSetupController', {
	extend: 'Academia.controller.base.BaseController',
    
    models:[],
    
    stores:['setup.sessionlogouttimesetup.SessionLogoutTimeSetupHourStore','setup.sessionlogouttimesetup.SessionLogoutTimeSetupMinuteStore'],
    
    views: ['setup.sessionlogouttimesetup.SessionLogoutTimeSetupStructure','setup.sessionlogouttimesetup.SessionLogoutTimeSetupView',
    	'setup.sessionlogouttimesetup.SessionLogoutTimeStudentPortalSetupView','setup.sessionlogouttimesetup.SessionLogoutTimeParentPortalSetupView',
    	'setup.sessionlogouttimesetup.SessionLogoutTimeFacultyPortalSetupView','setup.sessionlogouttimesetup.SessionLogoutTimeApplicantPortalSetupView'],
   
    refs: [{
    	ref:'sessionlogouttimesetupstructure',
    	selector:'sessionlogouttimesetupstructure'
    },{
    	ref:'sessionlogouttimesetupview',
    	selector:'sessionlogouttimesetupview'
    },{
    	ref:'sessionlogouttimestudentportalsetupview',
    	selector:'sessionlogouttimestudentportalsetupview'
    },{
    	ref:'sessionlogouttimeparentportalsetupview',
    	selector:'sessionlogouttimeparentportalsetupview'
    },{
    	ref:'sessionlogouttimefacultyportalsetupview',
    	selector:'sessionlogouttimefacultyportalsetupview'
    },{
    	ref:'sessionlogouttimeapplicantportalsetupview',
    	selector:'sessionlogouttimeapplicantportalsetupview'
    }
    ],
    config: {
    	SESSION_LOGOUT_TIME_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SESSION_LOGOUT_TIME_PRIVILEGES'),
    },
    init: function(application) {
        this.control({
        	
        	'sessionlogouttimesetupview button[itemId=sessionLogoutReset]':{
        	},
        	'sessionlogouttimesetupstructure':{
        		
        		render:function(obj){
        			var $this=this;
        			var form = $this.getSessionlogouttimesetupview();
        			var min=form.down('#noOfMinutes');
        			var hour=form.down('#noOfHours');
        			var res;
        	    	Ext.Ajax.request({
        				type : 'rest',
        				url : SERVERURL.PATH_FIND_AUTO_LOGOUT_TIME,
        				method : 'GET',
        				success : function(frm, response, action) {
        					res = Ext.decode(frm.responseText);
        					if(!isNullOrEmpty(res)){
        						var holdTimeHour;
        						var holdTimeMin;
        						var formAdmin = $this.getSessionlogouttimesetupview();
    							var formStudent = $this.getSessionlogouttimestudentportalsetupview();
    							var formParent = $this.getSessionlogouttimeparentportalsetupview();
    							var formFaculty = $this.getSessionlogouttimefacultyportalsetupview();
    							var formApplicant = $this.getSessionlogouttimeapplicantportalsetupview();
    							for(var i=0;i<res.length;i++){
    								var responseData=res[i];
    								var minuteComboBox;
    								var hourComboBox;
    								if(responseData.userGroup.userGroupName == "Admin"){
    									minuteComboBox=formAdmin.down('#noOfMinutes');
    									hourComboBox=formAdmin.down('#noOfHours');
    								}else if(responseData.userGroup.userGroupName == "Faculty"){
    									minuteComboBox=formFaculty.down('#noOfMinutes');
    									hourComboBox=formFaculty.down('#noOfHours');
    								}else if(responseData.userGroup.userGroupName == "Student"){
    									minuteComboBox=formStudent.down('#noOfMinutes');
    									hourComboBox=formStudent.down('#noOfHours');
    								}else if(responseData.userGroup.userGroupName == "Parent"){
    									minuteComboBox=formParent.down('#noOfMinutes');
    									hourComboBox=formParent.down('#noOfHours');
    								}else if(responseData.userGroup.userGroupName == "Applicant"){
    									minuteComboBox=formApplicant.down('#noOfMinutes');
    									hourComboBox=formApplicant.down('#noOfHours');
    								}

    								if(!isNullOrEmpty(res[i])){
    									minuteComboBox.getStore().load({
    										callback: function(records, operation, success) {
    											if (success) {
    												holdTimeMin=""+res[i].minutes+"";
    												minuteComboBox.setValue(holdTimeMin);
    											}
    										}
    									});
    									hourComboBox.getStore().load({
    										callback: function(records, operation, success) {
    											if (success) {
    												holdTimeHour=""+res[i].hours+"";
    												hourComboBox.setValue(holdTimeHour);
    											}
    										}
    									});
    								}
    								if(holdTimeHour == "4"){
    									minuteComboBox.getStore().load({
    										callback: function(records, operation, success) {
    											if (success) {
    												minuteComboBox.setValue('0');
    												minuteComboBox.setReadOnly(true);
    											}
    										}
    									});
    								}else{
    									minuteComboBox.setReadOnly(false);
    								}


    							}
        						
        						/*if(!isNullOrEmpty(res)){
        							min.getStore().load({
        								callback: function(records, operation, success) {
        									if (success) {
        										holdTimeMin=""+res.minutes+"";
        										min.setValue(holdTimeMin);
        									}
        								}
        							});
        							hour.getStore().load({
        								callback: function(records, operation, success) {
        									if (success) {
        										holdTimeHour=""+res.hours+"";
        										hour.setValue(holdTimeHour);
        									}
        								}
        							});
        						}
        						if(holdTimeHour == "4"){
        							min.getStore().load({
        								callback: function(records, operation, success) {
        									if (success) {
        										min.setValue('0');
        										min.setReadOnly(true);
        									}
        								}
        							});
        						}else{
        							min.setReadOnly(false);
        						}*/
        					}
        				}
        			});
        			}
        		
        	},
        	'sessionlogouttimesetupview button[itemId=sessionLogoutSave]':{
        		click: function(obj){
        			this.checkData(obj);
        		}
        	},
        	'sessionlogouttimesetupview customcombobox[itemId=noOfHours]':{
        		select:function(obj){
        			this.setHours(obj);
        			}
        	},
        	'sessionlogouttimesetupview customcombobox[itemId=noOfMinutes]':{
        		select:function(obj){
        			this.setMinutes(obj);
        			}
        	},
        	'sessionlogouttimestudentportalsetupview customcombobox[itemId=noOfHours]':{
        		select:function(obj){
        			this.setHours(obj);
        			}
        	},
        	'sessionlogouttimestudentportalsetupview customcombobox[itemId=noOfMinutes]':{
        		select:function(obj){
        			this.setMinutes(obj);
        			}
        	},
        	'sessionlogouttimeparentportalsetupview customcombobox[itemId=noOfHours]':{
        		select:function(obj){
        			this.setHours(obj);
        			}
        	},
        	'sessionlogouttimeparentportalsetupview customcombobox[itemId=noOfMinutes]':{
        		select:function(obj){
        			this.setMinutes(obj);
        			}
        	},
        	'sessionlogouttimefacultyportalsetupview customcombobox[itemId=noOfHours]':{
        		select:function(obj){
        			this.setHours(obj);
        			}
        	},
        	'sessionlogouttimefacultyportalsetupview customcombobox[itemId=noOfMinutes]':{
        		select:function(obj){
        			this.setMinutes(obj);
        			}
        	},
        	'sessionlogouttimeapplicantportalsetupview customcombobox[itemId=noOfHours]':{
        		select:function(obj){
        			this.setHours(obj);
        			}
        	},
        	'sessionlogouttimeapplicantportalsetupview customcombobox[itemId=noOfMinutes]':{
        		select:function(obj){
        			this.setMinutes(obj);
        			}
        	},
        	'sessionlogouttimestudentportalsetupview button[itemId=sessionLogoutSave]':{
        		click: function(obj){
        			this.checkData(obj);
        		}
        	},
        	'sessionlogouttimeparentportalsetupview button[itemId=sessionLogoutSave]':{
        		click: function(obj){
        			this.checkData(obj);
        		}
        	},
        	'sessionlogouttimefacultyportalsetupview button[itemId=sessionLogoutSave]':{
        		click: function(obj){
        			this.checkData(obj);
        		}
        	},
        	'sessionlogouttimeapplicantportalsetupview button[itemId=sessionLogoutSave]':{
        		click: function(obj){
        			this.checkData(obj);
        		}
        	},
        });
    },
    checkData:function(obj){
    	var $this=this;
//    	var form = this.getSessionlogouttimesetupview();
    	var form = obj.up().up();
		var min=form.down('#noOfMinutes').getValue();
		var hour=form.down('#noOfHours').getValue();
		var res;
		var id;
		var userGroupNameFromForm;
		var userGroupIdFromForm;
		
		if(form.xtype=='sessionlogouttimesetupview'){
			userGroupNameFromForm="Admin";
		}else if(form.xtype=='sessionlogouttimefacultyportalsetupview'){
			userGroupNameFromForm="Faculty";
		}else if(form.xtype=='sessionlogouttimestudentportalsetupview'){
			userGroupNameFromForm="Student";
		}else if(form.xtype=='sessionlogouttimeparentportalsetupview'){
			userGroupNameFromForm="Parent";
		}else if(form.xtype=='sessionlogouttimeapplicantportalsetupview'){
			userGroupNameFromForm="Applicant";
		}
		//USERGROUP_FIND_ALL
		
		/*Ext.Ajax.request({
			type : 'rest',
			url : SERVERURL.PATH_FIND_AUTO_LOGOUT_TIME,
			method : 'GET',
			params: {
				 userGroupId : userGroupIdFromForm,
			 },
			success : function(frm, response, action) {
				if(!isNullOrEmpty(frm.responseText)){
					res = Ext.decode(frm.responseText);
					id=res.id;
					$this.saveSessionLogout(id);
				  	}else{
				  		$this.saveSessionLogout(id);
				  	}
			}
		});*/
		
		Ext.Ajax.request({
			type : 'rest',
			url : SERVERURL.USERGROUP_FIND_ALL,
			method : 'GET',
			success : function(frm, response, action) {
				
				if(!isNullOrEmpty(frm.responseText)){
					
					res = Ext.decode(frm.responseText);
					
					for(var x=0;x<res.length;x++){
						if(res[x].userGroupName==userGroupNameFromForm){
							userGroupIdFromForm=res[x].id;
						}
					}
					
					Ext.Ajax.request({
						type : 'rest',
						url : SERVERURL.PATH_FIND_AUTO_LOGOUT_TIME,
						method : 'GET',
						params: {
							 userGroupId : userGroupIdFromForm,
						 },
						success : function(frm1, response1, action1) {
							if(!isNullOrEmpty(frm1.responseText)){
								res = Ext.decode(frm1.responseText);
								if(res[0]!=null){
									id=res[0].id;
								}
								$this.saveSessionLogout(id,userGroupIdFromForm,min,hour);
							  	}else{
							  		$this.saveSessionLogout(id,userGroupIdFromForm,min,hour);
							  	}
						}
					});
					
				}
				
			}
		});
		
		
		
		
    },
    
    saveSessionLogout: function(id,userGroupId,min,hour){

    	var $this = this;
		var form = this.getSessionlogouttimesetupview();
//		var min=form.down('#noOfMinutes').getValue();
//		var hour=form.down('#noOfHours').getValue();
		var json;
		var url;
		var submitUrl;
		var userGroupModel=new Object();
		userGroupModel.id=userGroupId;
		if(!isNullOrEmpty(id)){
			json = {
					"id":id,
					"hours":hour,
					"minutes":min,
					"userGroup":userGroupModel
			};
		}else{
			json = {
					"hours":hour,
					"minutes":min,
					"userGroup":userGroupModel
			};
		}
		submitUrl=SERVERURL.PATH_SAVE_AUTO_LOGOUT_TIME;
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		var formData = Ext.encode(json);
		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl,
			jsonData : formData,
			method : 'POST',
			success : function(frm, action) {
				Ext.getBody().unmask(); 
				  showSuccessMessage(getCommonTranslation('SAVE'), getCommonTranslation('TIME_SAVED_SUCCESSFULLY'));
			}
		});
		
    },
    
    setHours: function(obj){
    	
    	var $this = this;
//		var form = this.getSessionlogouttimesetupview();
    	var form=obj.up().up();
		var min=form.down('#noOfMinutes');
		var hour=form.down('#noOfHours');
		if(obj.getValue() == "4"){
			min.getStore().load({
			       callback: function(records, operation, success) {
			           if (success) {
			        	   min.setValue('0');
			        	   min.setReadOnly(true);
			           }
			       }
			   });
		}else{
		 min.setReadOnly(false);
		}
		var getHour=hour.getValue();
		var getMin=min.getValue();
		if((getHour == "0") && (getMin == "0")){
			min.getStore().load({
			       callback: function(records, operation, success) {
			           if (success) {
			        	   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('TIME_SHOULD_BE_GREATER_THAN_OR_EQUAL_TO_1_MINUTE')); 
			        	   min.reset();
			           }
			       }
			   });
		}
    },
    setMinutes:function(obj){
    	var $this = this;
//		var form = this.getSessionlogouttimesetupview();
    	var form=obj.up().up();
		var min=form.down('#noOfMinutes');
		var hour=form.down('#noOfHours');
		var getHour=hour.getValue();
		var getMin=min.getValue();
		if((getHour == "0") && (getMin == "0")){
			min.getStore().load({
			       callback: function(records, operation, success) {
			           if (success) {
			        	   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('TIME_SHOULD_BE_GREATER_THAN_OR_EQUAL_TO_1_MINUTE')); 
			        	   min.reset();
			           }
			       }
			   });
		}
    },
});
