
Ext.define('Academia.controller.signupreport.signUpReportController',{
	extend: 'Academia.controller.base.BaseController',
	
	models: ['Academia.model.signUpReport.SignUpReportModel','signUpReport.SignUpUser'],
	
	stores: ['dashboard.FollowUpDashboardStore',
		'importutility.ImportEnquiryNewStore','campaign.CampaignCodeOrNameSmartSearch','user.UserAcademyLocationStore',
		'signUpReport.SignUpReportStore','admission.applications.applicantProfileBase.ApplicantSmartSearchStore',
		'common.AcademyLocationNameSeparated','Academia.store.signUpReport.SignUpUserStore',
		'messaging.MessagingTemplatesStore','committee.committee.MessageTypeNotificationStore','messaging.StaticDocumentAttachmentGridStore'],
		
	
	 views: ['Academia.view.campaign.dashboard.SignUpReportFilter','Academia.view.campaign.dashboard.SignUpReportForm',
		 'Academia.view.campaign.dashboard.SignUpReportGrid','Academia.view.campaign.dashboard.SignupReportStructure',
		 'admission.applications.applicationBase.ApplicantSendMessage',
		 'admission.applications.applicationBase.ApplicantStaticDocumentAttachmentGrid'],
		 
		 refs: [{
			 ref: 'contentpanel',
			 selector: 'contentpanel'
		 },{
			 ref: 'signupreportfilter',
			 selector: 'signupreportfilter'   
		 },
		 {
			 ref: 'signupreportfiltergrid',
			 selector: 'signupreportfiltergrid'
		 },{
			 ref :'applicantsendmessage',
			 selector : 'applicantsendmessage[itemId=applicationSignupSendMessageWindow]'
		 },{
			 ref :'applicantstaticdocumentattachmentgrid',
			 selector : 'applicantstaticdocumentattachmentgrid'
		 }],
		  config: {
		     	SIGNUP_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SIGNUP_REPORT_PRIVILEGES')
		     },
		     
		 init: function(application) {
			 this.control({
				 
				 'signupreportfilter button[itemId=resetBtn]':{
		     			click:function(obj, record){
		 					var $this = this;
		 					var filter = $this.getSignupreportfilter();
		 					var signUpUserName = filter.down("#signUpUserName");
		 					var academyLocationCombo = filter.down("#academyLocationCombo");
		 					var toDate = filter.down("#fromdate");
		 					var fromDate = filter.down("#todate");
		 					filter.getForm().reset();
		 					toDate.setMaxValue(new Date());
		 					toDate.setMinValue(null);
		 					fromDate.setMaxValue(new Date());
		 					fromDate.setMinValue(null);
		 					
		 					var academyLocationId = this.getCurrentAcademyLocation();
//		 					academyLocationCombo.getStore().load({
//		 						callback: function(record){
//		 							academyLocationCombo.select(academyLocationId);
//		 						}
//		 					});
		 				}
		     		},
		     		'signupreportfilter datefield[itemId=fromdate]':{
			        	 change: function() {
			        	   var $this = this;
			        	   var frm = $this.getSignupreportfilter();
			        	   var fromdate = frm.down('#fromdate');
			        	   var todate = frm.down('#todate');
			  			   if(!isNullOrEmpty(fromdate.getValue())){
			  				   
				  					todate.setMinValue(fromdate.getValue());
				  					todate.setMaxValue(new Date());
					  				todate.validate();
				  				 }else{
				  					todate.setMaxValue(null);
				  				 }
			        	 }
			        	 },
		     		'signupreportfilter button[itemId=searchBtn]':{
		     			click:function(obj, record){
		 					var $this = this;
		 					var grid = $this.getSignupreportfiltergrid();
		 					var buttonsToolBar = grid.query('toolbar')[0];
			                var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
			                var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
			                var form = $this.getSignupreportfilter().getForm();
		 					var formValue = form.getValues();
		 					var submissionRecordFlag = '';
		 					if(formValue.showSubmissionRecord){
		 						submissionRecordFlag=true;
		 					}else{
		 						submissionRecordFlag=false;
		 					}
		 					var acaloc = [];
		 					if(formValue.multiselectAcademyLocation!="" && formValue.multiselectAcademyLocation!=null){
		 						for(var i in formValue.multiselectAcademyLocation){
		 							if(formValue.multiselectAcademyLocation[i].raw!=null && formValue.multiselectAcademyLocation[i].raw!=""){
		 								acaloc.push(formValue.multiselectAcademyLocation[i].raw.id);
		 							}
		 								
		 						}
		 					}
		 			    	grid.getStore().getProxy().extraParams ={
		 			    		academyLocationId:acaloc.join(),
		 			    		signUpUserId:formValue.signUpUserName,
		 			    		fromDate : formValue.fromdate,
		 			    		toDate : formValue.todate,
		 			    		showSubmissionRecord:submissionRecordFlag
		 			    	};
		 			    	$this.resetPageSetting(grid.getStore());
		 			    	grid.getStore().load({
						    	  callback: function(records, operation, success) {
						 				if(records.length>0){
						 				    	pdftoolbar.setDisabled(false);
											    	exceltoolbar.setDisabled(false);
						 					}
											  }
						 				});
		 			    	/***************Start Code added for show filter data on PDF/Excel Export Report **************/
				        	grid.config.searchFilterForm = $this.getSignupreportfilter();
				         /***************End Code added for show filter data on PDF/Excel Export Report **************/      
		 				}
		     		},
		            'signupreportfiltergrid button[itemId=sendMessageBtn]': {
		 	           /* click: function(obj) {
		                 	var grid = this.getSignupreportfiltergrid();
		 	            	if (grid.getSelectionModel().getCount() > 0) {
		 	            		var this$ = this;
		 	                	var window = this$.getSendMessageWindow();
		 	                	if(!window){
		 	                		window = Ext.widget('sendmessagewindow',{
		 	                			itemId:'applicationSendMessageWindow'
		 	                		});
		 	                		window.down('#msgRecipientTypeItemId').setValue(RECIPIENT_TYPES_COSTANTS.APPLICANT);
		 	                	}
		 	                	window.show();
		 	            	} else {
		 	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		 	            	}  
		 	            }*/
		             	click: this.openApplicantSignupSendMessage
		 	        },
		    		 'signupreportfiltergrid': {
		    			 render: function(grid){
		    				 grid.getStore().removeAll();
		    				 this.doAccessControlValidation(grid, this.getSIGNUP_REPORT_PERMISSIONS());
		    				 var buttonsToolBar = grid.query('toolbar')[0];
		            		 var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
		                 	 var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
		                 	 pdftoolbar.setDisabled(true);
		                 	 exceltoolbar.setDisabled(true);
		    				 var sendMessageBtn = grid.down('#sendMessageBtn');
		    		         sendMessageBtn.setVisible(true);
		    			 },
		    			 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		    					var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
		    					var $this =this;
		    					if(e.target.tagName=="A"){
		    					if(columnName == "applicationCode"){
		    		    			  var applicantId = record.get('applicationId'); 
		    							this.openApplicantProfileFromSignUpReport(applicantId, true,grid,record);
		    		    		  }
		    					}
		    				},
		 	     afterrender:function(grid){
    				var me = this;
    				setTimeout(function(){
    					me.addDataGridConfigButton(grid,me.getSIGNUP_REPORT_PERMISSIONS());
    				},1500);

    			},
		     },
		    		 'applicantsendmessage[itemId=applicationSignupSendMessageWindow] radiogroup[itemId=messageType]':{
		   	        	change : function(val,nV,oV){
		  	        		this.selectSectionMessageType(val,nV,oV);
		  	        	}
		  	        },
		  	        'applicantsendmessage[itemId=applicationSignupSendMessageWindow] customcombobox[itemId=msgTempletId]':{
		  	        	select : function(obj,rec){
		  	        		this.selectApplicantMessageTemp(obj,rec);
		  	        	}
		  	        },
		  	        'applicantsendmessage[itemId=applicationSignupSendMessageWindow] button[itemId=adhocMsgSubmitBtn]':{
		  	        	click: function(obj) {
		  	        		var grid = this.getSignupreportfiltergrid();
		    				var applicantsendmessage = this.getApplicantsendmessage();
		    				var formPnl = obj.up('form');
		    				var isMySelfChecked = false;
		    				var fldValues = formPnl.getForm().getFieldValues();
		    				isMySelfChecked = fldValues.recieverType;
		    				if(fldValues.recieverType[0] == false && fldValues.recieverType[1]==false && fldValues.recieverType[2]==false ){
		  	        	    	showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SEND_MESSAGE_ALERT_FOR_MYSELF'));
		  	        	    	return;
		  	        	    }
		    				var currentlyLoggedInUserId= this.getCurrentlyLoggedInUser().id;
		    				var wsMsgEventRecipientConfigsUpdated = [];
		    				/*var wsMsgEventRecipientConfigsUpdated = [{ 
										                           	 	msgRecipientTypeId: 500,
										                           	 	msgTemplateConfigId: 0,	//formData.id, 
										                           	 	selectiveRecipientIds: [] 
										                            },{ 
										                           	 	msgRecipientTypeId: 600,
										                           	 	msgTemplateConfigId: 0,	//formData.id, 
										                           	 	selectiveRecipientIds: [] 
										                            }];*/
		    				
		    				var formData = obj.up('form').getValues();
		    				
		    				var sendMessageToOptions = formData.recieverType;
		    				var isApplicantChecked = false;
		    				
		    				if(sendMessageToOptions != null && sendMessageToOptions != undefined ){
		    					if(sendMessageToOptions.constructor === Array){
		    						if(sendMessageToOptions.length > 0){
		    							sendMessageToOptions.forEach(function(current_value, index, initial_array) {
		            						if(current_value == 1 || current_value == '1'){
		            							isApplicantChecked = true;
		            						}
		            					});
		    						}
		    					}else{
		    						if(sendMessageToOptions == 1 || sendMessageToOptions == '1'){
		    							isApplicantChecked = true;
		    						}
		    					}
		    				}
		    				
		    				//wsMsgEventRecipientConfigsUpdated = [];
		    				applicantsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isApplicantChecked,isMySelfChecked,currentlyLoggedInUserId,true);
		  	        	}
		  	        },'applicantsendmessage[itemId=applicationSignupSendMessageWindow]  filefield[itemId=staticUploadFileField]': {
		  	        	change: function(fileField, value, eOpts){
		  	        		var this$ = this;
		  	        		this$.uploadApplicantStaticDocumentFileMessage(fileField, value, eOpts);
		  	        	}
		  	        },
		  	       'applicantsendmessage[itemId=applicationSignupSendMessageWindow]': {
		  	        	render: function(grid){
		  	        		var this$ = this;
		  	        		var docGrid = grid.down('#applicantStaticDocumentAttachmentGridMessage');
		  	        		docGrid.getStore().removeAll();
		  	        		docGrid.getStore().sync();
		  	        	}
		  	        }, 'applicantsendmessage[itemId=applicationSignupSendMessageWindow] radiogroup#sendingPriority': {
		  	        	change: function( radio, newValue, oldValue, eOpts) {
		  	        		this.loadApplicantScheduleField(radio, newValue, oldValue);
		  	        	}
		  	        },
		  	        /*V2D-13247*/
		  	        'applicantsendmessage[itemId=applicationSignupSendMessageWindow] textarea[itemId=smsDiscription]':{
		  	        	change : function(val,nV,oV){
		  	        		var maxLength = localStorage.getItem('maxLength');
		  	        		var applicantSendmessageForm = this.getApplicantsendmessage();
		  	        		var smsTextField = applicantSendmessageForm.down('#smsDiscription');
		  	        		var smsTextFieldDiscription = applicantSendmessageForm.down('#smsDiscriptionNotice');            				
		  	        		var newValue = maxLength - smsTextField.getValue().length;
		  	        		smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
		  	        	}
		  	        },
		  	       
			 });
			 
		 },
getAcademyLocationIds: function(){
    
  	var form =this.getSignupreportfilter().getForm();
  	var values = form.getValues();
  	var aL = values.academyLocation;
  	var mAL = values.multiselectAcademyLocation;

  	var alArray=[];
  	var mALArray=[];

  	if(aL !=undefined && aL.length > 0 && aL!=""){
  		for(var i in aL){
  			if(Ext.isObject(aL[0])){
  				alArray.push(aL[i].get("id"));
  			}else{
  				alArray.push(aL[i]);
  			}
  		}
  		academyLocation= alArray.join();

  	}else if(mAL !=undefined && mAL.length > 0 && mAL!=""){
  		for(var i in mAL){
  			if(Ext.isObject(mAL[0])){
  				mALArray.push(mAL[i].get("id"));
  			}else{
  				mALArray.push(mAL[i]);
  			}
  		}
  		academyLocation= mALArray.join();
  	}else{
  		academyLocation = this.getCurrentAcademyLocation();
  	}
  	return academyLocation;
  },
  openApplicantSignupSendMessage:function(obj){
	    	//var grid = this.getSignupreportfiltergrid();
	    	var grid = obj.up('grid');
	    	//var gridMSG = this.getStaticDocumentAttachmentGrid();
	    	if(grid.getSelectionModel().getCount()>0) {
	    		
	    			var $this=this;
	    			var contentPanel = $this.getContentpanel(); //get hold of the content panel where we are adding all the tabs
	    	       	   var structure = Ext.widget('applicantsendmessage',{
            			itemId:'applicationSignupSendMessageWindow',
            			//customGridId: grid.itemId
            		});
	    	       	   var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
	    	       	   /**
	    	       	    * This is to remove tab from content panel and open same tab again
	    	       	    */
	    	       	   var getcontroller=this.getController('menu.CoreERPNavigationController');
	    	       	   var getTab=getcontroller.getTab(tabName);
	    	       	   if(getTab!=null){
	    	       		   contentPanel.remove(getTab, true);
	    	       	   }
	    	       	var formWindowTab = $this.getApplicantsendmessage();
	    	       	formWindowTab.down("#selectTemplate").allowBlank=true;
	    	       	formWindowTab.down("#selectTemplate").setVisible(false);
	    	       	formWindowTab.down("#messageName").allowBlank=true;   
	    	       	formWindowTab.down("#messageName").setVisible(false);
	    			var templateStore = formWindowTab.down('#selectTemplate').getStore();
	    			templateStore.getProxy().extraParams={
	    				msgRecipientTypeId:10
	    			};
	    			templateStore.load();
	    			
	    			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	    			   Ext.Ajax.request({
	    				   method : "GET",
	    				   type : 'rest',
	    				   url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=EnquirerTemplatebe539740-692d-4ae1-bc17-338c4002874d',	//Committeebe539740-692d-4ae1-bc17-338c4002874d',
	    				   headers : {
	    					   'Content-Type' : 'application/json'
	    				   },
	    				   success : function(form,action) {
	    					   var data = Ext.JSON.decode(form.responseText);
	    					   formWindowTab.down("#id").setValue(data.id);
	    					   formWindowTab.down("#code").setValue(data.code);
	    					   formWindowTab.down("#templateConfigName").setValue(data.templateConfigName);
	    					   formWindowTab.down("#msgSubCategoryId").setValue(data.msgSubCategoryId);
	    					   formWindowTab.down("#msgCategoryId").setValue(data.msgCategoryId);
	    					   Ext.getBody().unmask();
	    					   
	    					   //grid.getStore().reload();
	    					   //showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
	    				   }

	    			   });
	    	       	openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_ONE);
	    	       	//formWindowTab.down("#recieverType").setVisible(true);
	    	       	var recipientTypeArr = formWindowTab.down("#recieverType").items.items;
	    	       	for(var i in recipientTypeArr){
	    	       		var recipientCheckBox = recipientTypeArr[i];
	    	       		if( recipientCheckBox.inputValue == 2 || recipientCheckBox.inputValue == 3 ){
	    	       			recipientCheckBox.setVisible(false);
	    	       		} else if(recipientCheckBox.inputValue == 1) {
	    	       			recipientCheckBox.setValue(true);
	    	       		} else if(recipientCheckBox.inputValue == 4) {
	    	       			recipientCheckBox.setValue(false);
	    	       		}
	    	       	}
	    		
	    	} else {
	    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	    	}
	    },
	    openTab: function(tabTitle, contentXType, menuColorcls,contentPanel) {
      	  var baseController =  Academia.app.getController('Academia.controller.base.BaseController');
      	  baseController.openTab(tabTitle, contentXType, menuColorcls,contentPanel);
        },
         selectApplicantMessageTemp: function(obj,rec){
   	       	var $this =  this;
   	       	 var formWin = $this.getApplicantsendmessage();
   	       	 if(rec[0].data.value == "SMS")
   	       	 {
   	       		 formWin.down("#templateId").allowBlank=false;
	       		 formWin.down("#templateId").show();
   	       		 formWin.down("#subject").allowBlank=true;
   	       		 formWin.down("#subject").hide();
   	       		 formWin.down("#staticUploadFileField").hide();
   	       		 formWin.down("#applicantDocumentMessageAttachmentGrid").hide();
   	       		 formWin.down('#discriptionId').reset();
   	       		 formWin.down('#discriptionId').hide();	       		 
   	       		 formWin.down('#subject').reset();
   	       		 formWin.down('#smsDiscription').show();
   	       		 formWin.down('#smsDiscriptionNotice').show();
   	       	 }else
   	       	 {
	   	       	 formWin.down("#templateId").allowBlank=true;
	       		 formWin.down("#templateId").hide();
	       		 formWin.down("#templateId").reset();
   	       		 formWin.down('#discriptionId').reset();
   	       		 formWin.down('#smsDiscription').reset();
   	       		 formWin.down('#smsDiscription').hide();
   	       		 formWin.down('#smsDiscriptionNotice').hide();
   	       		 formWin.down("#staticUploadFileField").show();
   	       		 // formWin.down("#staticDocumentMessageAttachmentGrid").show();
   	       		 formWin.down("#applicantDocumentMessageAttachmentGrid").show();
   	       		 formWin.down('#subject').reset();
   	       		 formWin.down("#subject").show();
   	       		 formWin.down("#subject").allowBlank=false;
   	       		 formWin.down('#discriptionId').show();    		
   	       	 }
   	       },
   	    uploadApplicantStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts){
	    	   var this$ = this;
	    	   var setupForm = fileField.up('applicantsendmessage');
	    	   var grid = setupForm.down('#applicantStaticDocumentAttachmentGridMessage');
	    	   fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
	    	   fileField.setRawValue(fileUploadPath);
	    	   var file = fileField.fileInputEl.dom.files[0];
	    	   if((file.size / 1048576) <= CONSTANTS.EMAIL_UPLOAD_FILE_SIZE_LIMIT  ){
	    		   if(!isNullOrEmpty(fileUploadPath)){
	    			   var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
	    			   if (extension == "gif" || extension == "png" || extension == "bmp"
	    				   || extension == "jpeg" || extension == "jpg" || extension == "pdf" 
	    					   || extension == "doc" || extension == "docx" || extension == "txt"
	    						   || extension == "xls" || extension == "csv" || extension == "xml" || extension == "zip" || extension == "xlsx") {
	    				   var entityId = 'student';
	    				   var module = 'messaging';
	    				   var entityType = 'template';
	    				   var documentType = 'DOCUMENT';
	    				   var isTransient = true;
	    				   var this$ = this;
	    				   this$.saveApplicantStaticDocumentFormMessage(entityId, module, entityType, documentType, function(success, action, isTransient){
	    					   if(success){
	    						   var path = Ext.JSON.decode(action.response.responseText).path;
	    						   var user = this$.getCurrentlyLoggedInUser();
	    						   var store = grid.getStore();
	    						   var documentStatus = "SUBMITTED";
	    						   var documentType = null;
	    						   if(!isNullOrEmpty(path)){
	    							   store.add({
	    								   id: '',
	    								   name: fileUploadPath,
	    								   path: path ,
	    								   createdBy : {
	    									   id :user.id,
	    									   value : user.value,
	    									   code : user.code
	    								   },
	    								   status : documentStatus,
	    								   documentType : documentType,
	    								   templateConfigDocId: '',
	    								   submissionDate: Ext.Date.format(new Date(), 'd-m-Y')

	    							   });
	    							   this$.loadGridWithFileNameMessage(grid,fileUploadPath,store);
	    							   showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
	    						   }

	    						   fileField.reset();
	    					   }

	    				   }, isTransient);
	    			   }else{
	    				   fileField.reset();
	    				   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
	    			   }
	    		   }
	    	   }else{
	    		   fileField.reset();
	    		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
	    	   }
	       },
  		    /**
		        * save document file. It's external call method
		        * @param entityId : person id, It's mandatory. 
		        * @param module : module name, for student module 'student', It's mandatory.
		        * @param entityType : entity type, It's mandatory.
		        * @param documentType : document type, It's mandatory.
		        * @param isTransient : true or false (send json back to module controller or not)
		        * @param callBackFunction : callback function return in module controller. It's mandatory.
		        */
		    	saveApplicantStaticDocumentFormMessage : function(entityId, module, entityType, documentType, callBackFunction, isTransient){
		       	var submitUrl = '';
		       	var templateTab = this.getContentpanel();
		       	var formWin =  this.getApplicantsendmessage();
		       	var form = formWin.down('#msgDetailsForm');
		       	var id = form.down('#document_hidden_field');
		           if (isNullOrEmpty(id.getSubmitValue())) {
		               submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
		           }
		           var data = new Object();
		           if(!isNullOrEmpty(entityId)){
		           	data.entityId = entityId;
		           }else{
		           	data.entityId = null;
		           }
		           if(!isNullOrEmpty(module)){
		           	data.module = module;
		           }else{
		           	data.module = null;
		           }
		           if(!isNullOrEmpty(entityType)){
		           	data.entityType = entityType;
		           }else{
		           	data.entityType = null;
		           }
		           form.getForm().setValues(data);
		           form.getForm().submit({
		           	method : 'POST',
		           	url : submitUrl,
		           	success : function(form, action){
		           		callBackFunction(true, action, isTransient);
		           		
		           	}
		           });
		       },
		       loadGridWithFileNameMessage:function(grid,value,store){
   		    	   grid.bindStore(store);
   		       },
   	   	       /**
   	   	        * This method is to enable schedule field
   	   	        */
   	   	       loadApplicantScheduleField : function(radio,newValue, oldValue){
   	   	       	var adhocMessageForm = radio.up('form');
   	   	       	var scheduleDateField = adhocMessageForm.down('#scheduleDate');
   	   	       	var scheduleTimeField = adhocMessageForm.down('#scheduleTime');
   	   	       	var radioValue = radio.getValue().sendingPriority;
   	   	       	
   	   	       	if(radioValue=='IMMEDIATE'){
   	   	       		scheduleDateField.setVisible(false);
   	   	       		scheduleDateField.setDisabled(true);
   	   	       		scheduleTimeField.setVisible(false);
   	   	       		scheduleTimeField.setDisabled(true);    		
   	   	       	}
   	   	       	else if(radioValue=='SCHEDULE'){
   	   	       		scheduleDateField.setVisible(true);
   	   	       		scheduleDateField.setDisabled(false);
   	   	       		scheduleTimeField.setVisible(true);
   	   	       		scheduleTimeField.setDisabled(false);
   	   	       	}
   	   	       },
   		    openApplicantProfileFromSignUpReport:function(applicationId,isView,searchResultGrid,record){
   		  	  Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
   			  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
   			  Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
   			  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
   			  Academia.app.getController('Academia.controller.personinfo.student.StudentListController');
   			  Academia.app.getController('Academia.controller.personinfo.faculty.FacultyListController');
   			  Academia.app.getController('Academia.controller.personinfo.faculty.FacultyPersonalController');
   			  Academia.app.getController('Academia.controller.admission.admissionCommon.AdmissionFormCommonController');
   			  Academia.app.getController('Academia.controller.admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionPaymentsRefundsAndFeePlansController');
   			  Academia.app.getController('Academia.controller.admission.directSubmission.DirectSubmissionController');
   			  Academia.app.getController('Academia.controller.admission.preAdmissionFeesAndRefund.PreAdmissionFeesAndRefundController');
   			  Academia.app.getController('Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.ButtonPanelConfiguration');
   			  Academia.app.getController('Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.LinkPanelConfiguration');
   			  Academia.app.getController('Academia.controller.admission.applications.applicationBase.ApplicationBaseController');
   			  Academia.app.getController('Academia.controller.admission.applications.applicantProfileBase.ApplicantProfileBaseController');
   			  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
   			  Academia.app.getController('Academia.controller.admission.applications.applicationDetailsAndReferences.ApplicationDetailsAndReferencesController');
   			  Academia.app.getController('Academia.controller.admission.applications.applicantService.ApplicantServiceController');
   			  Academia.app.getController('Academia.controller.admission.applications.applicantDocuments.ApplicantDocumentController');
   			  Academia.app.getController('Academia.controller.admission.applications.admissionAndMidTermAdmission.AdmissionAndMidTermAdmissionController');
   			  if(searchResultGrid){
   				  var store=searchResultGrid.getStore();
   				  var tabTitle = null;
   				  var personId = null;
   				  var applicationId = null;
   				  var admissionId = null;
   				  var record = record;
   				  tabTitle = record.get('applicationCode');
   				  applicationId = record.get('applicationId');
   				  admissionId = record.get('applicationCode');
   				  var applicationBaseController =Academia.app.getController('Academia.controller.admission.applications.applicationBase.ApplicationBaseController');
   				  var me=applicationBaseController;
   				  var applicantProfile=me.getTabReferenceByTabTitle(tabTitle);
   				  if(applicantProfile){
   					  me.getContentPanel().setActiveTab(applicantProfile);        			
   				  }else{
   					  me.addContentPanelTab(tabTitle, 'applicantprofile', null, null,applicationId,admissionId);
   					  var applicantProfile=me.getTabReferenceByTabTitle(tabTitle);
   					  if (applicantProfile) {            	
   						  me.setParameterForApplicantProfile(applicantProfile,record,'',isView);
   						  me.mixins.ButtonPanelConfiguration.enableDisableButtonPanel(applicantProfile,true);
   						  me.mixins.LinkPanelConfiguration.enableDisableAccorianLinkPanel(applicantProfile,true);    			
   						  var applicantLinkPanelObject=me.mixins.PersonDetailsLinkPanel.getApplicantProfileLink();
   						  var applicantPortalController  = me.getController('Academia.controller.portal.ApplicantPortalController');
   						  //commenting bacause permission code is already written in addContentPanelTab
   	      	        	  //applicantPortalController.loadPanellinkForApplicant(applicantProfile, applicantLinkPanelObject);
   						  me.gettingDataInSummaryGrid(applicantProfile);    
   						  //me.getApplicantProfileInformation(applicantProfile);
   						  if(!isEmpty(applicantLinkPanelObject)){

   							  var personalDetailObject=applicantLinkPanelObject.PERSONAL_INFORMATION[0];    				
   							  me.addPersonTabPanel('APPLICANT', personalDetailObject.tabPanelItemId, personalDetailObject.tabPanelTitle, personalDetailObject.tabPanelItemXtype, personalDetailObject.xtypeItemId,personalDetailObject.defaultPanel);

   							  var admissionDetailObject=applicantLinkPanelObject.APPLICATION_AND_ADMISSION[2];    				
   							  me.addPersonTabPanel('APPLICANT', admissionDetailObject.tabPanelItemId, admissionDetailObject.tabPanelTitle, admissionDetailObject.tabPanelItemXtype, admissionDetailObject.xtypeItemId,admissionDetailObject.defaultPanel);

   							  var personInfoPanel=applicantProfile.down("#personInfoPanel");
   							  var saveBtn = applicantProfile.down('#personalInfoSaveButtonId');
   					    	  saveBtn.setVisible(false);
   							  if(personInfoPanel){
   								  var applicantPersonalDetails=personInfoPanel.down("#applicantPersonalDetails");
   								  if(applicantPersonalDetails){
   									  var applicantProfileItems = applicantProfile.down('actionbuttonpanel').items.items;
   									  if(applicantProfileItems != undefined && applicantProfileItems.length > 0){
   										  applicantProfileItems.forEach(function(buttons) {
   							    			    	buttons.hide();
   							    			});
   							    		}
   									  personInfoPanel.setActiveTab(applicantPersonalDetails);
   								  }        						
   							  }

   						  }

   					  }
   				  }    	        
   			  }                	
   		}
});